/*----------------------------------------------------------------------*
 * Bounds Checking for GCC.						*
 * Copyright (C) 1995 Richard W.M. Jones <rwmj@doc.ic.ac.uk>.		*
 *----------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify	*
 * it under the terms of the GNU General Public License as published by	*
 * the Free Software Foundation; either version 2 of the License, or	*
 * (at your option) any later version.					*
 *									*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 * GNU General Public License for more details.				*
 *									*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software		*
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*
 *----------------------------------------------------------------------*
 * File:
 *	run-includes/fix-args.h
 * Summary:
 *	Fix the definition of `va_arg' macro used both by <stdarg.h> and
 *	<varargs.h>. You should include this file _after_ one of these
 *	standard header files.
 * Other notes:
 *	Possibly this should be fixed automatically in `ginclude/'
 *	files?
 * Author      	Date		Notes
 * RWMJ		6/6/95		Initial implementation.
 *----------------------------------------------------------------------*/

#ifndef _FIX_ARGS_H_
#define _FIX_ARGS_H_

#ifdef __BOUNDS_CHECKING_ON

#undef va_arg

/* This is the definition of `__old_va_arg' copied from <stdarg.h>. It is
 * identical to the one in <varargs.h> too.
 */
#if defined (__arm__) || defined (__i386__) || defined (__i860__) || defined (__ns32000__) || defined (__vax__)
/* This is for little-endian machines; small args are padded upward.  */
#define __old_va_arg(AP, TYPE)						\
 (AP = (__gnuc_va_list) ((char *) (AP) + __va_rounded_size (TYPE)),	\
  *((TYPE *) (void *) ((char *) (AP) - __va_rounded_size (TYPE))))
#else /* big-endian */
/* This is for big-endian machines; small args are padded downward.  */
#define __old_va_arg(AP, TYPE)						\
 (AP = (__gnuc_va_list) ((char *) (AP) + __va_rounded_size (TYPE)),	\
  *((TYPE *) (void *) ((char *) (AP) - ((sizeof (TYPE) < 4		\
					 ? sizeof (TYPE)		\
					 : __va_rounded_size (TYPE))))))
#endif /* big-endian */

#define va_arg(AP,TYPE) \
  ({extern int __bounds_debug_no_checking; \
  int __t = __bounds_debug_no_checking; \
  TYPE __r; \
  __bounds_debug_no_checking = 1; \
  __r = __old_va_arg(AP,TYPE); \
  __bounds_debug_no_checking = __t; \
  __r;})

#endif /* __BOUNDS_CHECKING_ON */
#endif /* _FIX_ARGS_H_ */
