      PROGRAM TEST
C
C******************************************************************
C                                                                 *
C  Test program for the subroutine  FFTB  with function values of *
C  the sum of the base functions                                  *
C                                                                 *
C         2 * EXP(I*(-3)*X) + I * EXP(I*7*X)                      *
C                                                                 *
C     ( I : imaginary unit (I**2 = -1), Period : 2*PI )           *
C  for 32 ( = 2**5) equidistant nodes in the interval [0, 2*PI).  *
C  The resulting discrete Fourier coefficients should all be zero,*
C  except                                                         *
C                                                                 *
C      RE ( F^(-3) ) = 2 ,  IM( F^(7) ) = 1  .                    *
C                                                                 *
C  After the inverse transformation (finding the functional       *
C  values), we display the difference to the original funactional *
C  values which should be close to zero throughout.               *
C  An IBM PC with Microsoft FORTRAN Compiler 5.0 gets the         *
C  following results:                                             *
C                                                                 *
C[   NODES:                                                      ]*
C[   ======                                                      ]*
C[   *    X    *     RE(F(X))     *     IM(F(X))     *           ]*
C[   *************************************************           ]*
C[   *  .00000 *  .2000000000E+01 *  .1000000000E+01 *           ]*
C[   *  .29920 *  .3809541999E+00 * -.2063662965E+01 *           ]*
C[   *  .59840 *  .4209835359E+00 * -.2449855824E+01 *           ]*
C[   *  .89760 * -.1801937736E+01 *  .1322325218E+00 *           ]*
C[   * 1.19680 * -.2667963140E+01 *  .3677674782E+00 *           ]*
C[   * 1.49600 *  .4209835359E+00 *  .1449855824E+01 *           ]*
C[   * 1.79520 *  .1246979604E+01 *  .2563662965E+01 *           ]*
C[   * 2.09440 *  .1133974596E+01 * -.5000000000E+00 *           ]*
C[   * 2.39359 *  .2113005008E+01 * -.2063662965E+01 *           ]*
C[   * 2.69279 * -.4450418679E+00 * -.9498558244E+00 *           ]*
C[   * 2.99199 * -.2667963140E+01 * -.1367767478E+01 *           ]*
C[   * 3.29119 * -.9359123320E+00 *  .3677674782E+00 *           ]*
C[   * 3.59039 * -.4450418679E+00 *  .2949855824E+01 *           ]*
C[   * 3.88959 *  .3809541999E+00 *  .1063662965E+01 *           ]*
C[   * 4.18879 *  .2866025404E+01 * -.5000000000E+00 *           ]*
C[   * 4.48799 *  .1246979604E+01 * -.5636629649E+00 *           ]*
C[   * 4.78719 * -.1311067272E+01 * -.2449855824E+01 *           ]*
C[   * 5.08639 * -.9359123320E+00 * -.1367767478E+01 *           ]*
C[   * 5.38559 * -.1801937736E+01 *  .1867767478E+01 *           ]*
C[   * 5.68479 * -.1311067272E+01 *  .1449855824E+01 *           ]*
C[   * 5.98399 *  .2113005008E+01 *  .1063662965E+01 *           ]*
C[                                                               ]*
C[   FOURIER COEFFICIENTS:                                       ]*
C[   =====================                                       ]*
C[   *  K  *     RE(C(K))     *     IM(C(K))     *               ]*
C[   *********************************************               ]*
C[   * -10 *  .1963548529E-14 *  .2288276890E-15 *               ]*
C[   *  -9 *  .2867953755E-14 * -.4965875468E-15 *               ]*
C[   *  -8 *  .1717482570E-14 * -.3818381662E-15 *               ]*
C[   *  -7 *  .6972605975E-15 *  .2408859273E-15 *               ]*
C[   *  -6 *  .2045006766E-14 * -.5751148707E-15 *               ]*
C[   *  -5 *  .2233678912E-14 * -.1024059832E-15 *               ]*
C[   *  -4 *  .1420585904E-14 *  .1173870923E-14 *               ]*
C[   *  -3 *  .2000000000E+01 *  .1790792217E-13 *               ]*
C[   *  -2 * -.9919485825E-14 * -.1222469258E-14 *               ]*
C[   *  -1 * -.3549841963E-14 * -.2162252733E-14 *               ]*
C[   *   0 *  .7031412489E-15 * -.2630171213E-14 *               ]*
C[   *   1 *  .1686158930E-14 * -.2895314717E-14 *               ]*
C[   *   2 *  .1439883622E-14 * -.2906465927E-15 *               ]*
C[   *   3 * -.1319465693E-14 *  .6758658750E-16 *               ]*
C[   *   4 * -.2761512940E-15 * -.6817394553E-15 *               ]*
C[   *   5 * -.1500262067E-14 *  .1253211171E-14 *               ]*
C[   *   6 * -.2676653762E-14 * -.1151791636E-14 *               ]*
C[   *   7 * -.1872344872E-14 *  .1000000000E+01 *               ]*
C[   *   8 *  .4423686535E-14 * -.1794873319E-14 *               ]*
C[   *   9 *  .3298061928E-14 * -.1044104753E-14 *               ]*
C[   *  10 *  .2014647869E-14 * -.1613029786E-14 *               ]*
C[                                                               ]*
C[   INVERSE FOURIER TRANSFORM:                                  ]*
C[   ==========================                                  ]*
C[   *    X    *     RE(F(X))     *     IM(F(X))     *           ]*
C[   *************************************************           ]*
C[   *  .00000 *  .2000000000E+01 *  .1000000000E+01 *           ]*
C[   *  .29920 *  .3809541999E+00 * -.2063662965E+01 *           ]*
C[   *  .59840 *  .4209835359E+00 * -.2449855824E+01 *           ]*
C[   *  .89760 * -.1801937736E+01 *  .1322325218E+00 *           ]*
C[   * 1.19680 * -.2667963140E+01 *  .3677674782E+00 *           ]*
C[   * 1.49600 *  .4209835359E+00 *  .1449855824E+01 *           ]*
C[   * 1.79520 *  .1246979604E+01 *  .2563662965E+01 *           ]*
C[   * 2.09440 *  .1133974596E+01 * -.5000000000E+00 *           ]*
C[   * 2.39359 *  .2113005008E+01 * -.2063662965E+01 *           ]*
C[   * 2.69279 * -.4450418679E+00 * -.9498558244E+00 *           ]*
C[   * 2.99199 * -.2667963140E+01 * -.1367767478E+01 *           ]*
C[   * 3.29119 * -.9359123320E+00 *  .3677674782E+00 *           ]*
C[   * 3.59039 * -.4450418679E+00 *  .2949855824E+01 *           ]*
C[   * 3.88959 *  .3809541999E+00 *  .1063662965E+01 *           ]*
C[   * 4.18879 *  .2866025404E+01 * -.5000000000E+00 *           ]*
C[   * 4.48799 *  .1246979604E+01 * -.5636629649E+00 *           ]*
C[   * 4.78719 * -.1311067272E+01 * -.2449855824E+01 *           ]*
C[   * 5.08639 * -.9359123320E+00 * -.1367767478E+01 *           ]*
C[   * 5.38559 * -.1801937736E+01 *  .1867767478E+01 *           ]*
C[   * 5.68479 * -.1311067272E+01 *  .1449855824E+01 *           ]*
C[   * 5.98399 *  .2113005008E+01 *  .1063662965E+01 *           ]*
C[                                                               ]*
C[   ERROR TABLE:                                                ]*
C[   ============                                                ]*
C[   *   X    * ABS(RE(F(X)-F^(X))) * ABS(IM(F(X)-F^(X))) *      ]*
C[   ********************************************************    ]*
C[   *  .0000 *  .8215650382226E-13 *  .1665334536938E-14 *      ]*
C[   *  .2992 *  .5365976760152E-13 *  .6380405101827E-13 *      ]*
C[   *  .5984 *  .3159066975025E-13 *  .7514724519736E-13 *      ]*
C[   *  .8976 *  .7312119659764E-13 *  .3685441708756E-13 *      ]*
C[   * 1.1968 *  .6956560978308E-13 *  .3351090021794E-13 *      ]*
C[   * 1.4960 *  .2080529758891E-13 *  .6560984394666E-13 *      ]*
C[   * 1.7952 *  .5043795242576E-13 *  .4845559717359E-13 *      ]*
C[   * 2.0944 *  .5598939280954E-13 *  .3658504705781E-14 *      ]*
C[   * 2.3936 *  .4448823037392E-13 *  .5250769437304E-13 *      ]*
C[   * 2.6928 *  .1416165904163E-13 *  .6239897921284E-13 *      ]*
C[   * 2.9920 *  .5664734089791E-13 *  .2724892794043E-13 *      ]*
C[   * 3.2912 *  .5796556810933E-13 *  .2298606183865E-13 *      ]*
C[   * 3.5904 *  .1462778466063E-13 *  .6662389823858E-13 *      ]*
C[   * 3.8896 *  .2989720016694E-13 *  .4269365893803E-13 *      ]*
C[   * 4.1888 *  .9236735725240E-13 *  .7502136932513E-15 *      ]*
C[   * 4.4880 *  .5165551146546E-13 *  .3721426378861E-13 *      ]*
C[   * 4.7872 *  .4151946798522E-13 *  .8731221041308E-13 *      ]*
C[   * 5.0864 *  .5975049014589E-13 *  .4064115580529E-13 *      ]*
C[   * 5.3856 *  .8074985992368E-13 *  .7646986342758E-13 *      ]*
C[   * 5.6848 *  .5699737556930E-13 *  .8533261987645E-13 *      ]*
C[   * 5.9840 *  .8773532031089E-13 *  .7183414019868E-13 *      ]*
C                                                                 *
C******************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      INTEGER M
      PARAMETER ( M = 21 )
      DIMENSION X(0:M-1), FUNKRE(0:M-1), FUNKIM(0:M-1)
C
C     Find real and imaginary parts of the function values
C
      PI = 4.0D0*ATAN(1.0D0)
      WRITE(*,900)
      DO 10 J = 0, M-1
        X(J) = DBLE(J)*2.0D0*PI/DBLE(M)
        FUNKRE(J) = 2.0D0*COS(3.0D0*X(J)) - SIN(7.0D0*X(J))
        FUNKIM(J) = -2.0D0*SIN(3.0D0*X(J)) + COS(7.0D0*X(J))
        WRITE(*,910) X(J), FUNKRE(J), FUNKIM(J)
  10  CONTINUE

C
C Compute Fourier coefficients
C
      CALL FFTB (M, FUNKRE, FUNKIM, 0)
      WRITE(*,920)
C
      DO 20 K = -(M-1)/2, -1
        WRITE (*, 940) K, FUNKRE(K+M), FUNKIM(K+M)
  20  CONTINUE
      DO 30 K = 0, (M-1)/2
        WRITE (*, 940) K, FUNKRE(K), FUNKIM(K)
  30  CONTINUE
C
C Inverse Fourier transformation
C
      CALL FFTB (M, FUNKRE, FUNKIM, 1)
C
      WRITE(*,930)
      DO 40 J = 0, M-1
        WRITE (*,910) X(J), FUNKRE(J), FUNKIM(J)
  40  CONTINUE
C
      WRITE(*,950)
      DO 50 J = 0, M-1
        WRITE (*, 960) X(J),
     #    DABS(2.0D0*COS(3.0D0*X(J))-SIN(7.0D0*X(J)) - FUNKRE(J)),
     #    DABS(-2.0D0*SIN(3.0D0*X(J))+COS(7.0D0*X(J)) - FUNKIM(J))
  50  CONTINUE
      STOP
C
C Format statements
C
  900 FORMAT(1X,'C[   NODES:',T67,']*',/,
     +       1X,'C[',3X,6('='),T67,']*',/,
     +       1X,'C[   *',4X,'X',4X,'*',5X,'RE(F(X))',5X,'*',
     +             5X,'IM(F(X))',5X,'*',T67,']*',/,
     +       1X,'C[',3X,49('*'),T67,']*')
  910 FORMAT(1X,'C[   * ',F7.5,' * ',2(E16.10,' * '),T67,']*')
  920 FORMAT(1X,'C[',T67,']*',/,
     +       1X,'C[   FOURIER COEFFICIENTS:',T67,']*',/,
     +       1X,'C[',3X,21('='),T67,']*',/,
     +       1X,'C[   *  K  *',5X,'RE(C(K))',5X,'*',5X,'IM(C(K))',
     +       5X,'*',T67,']*',/,1X,'C[',3X,45('*'),T67,']*')
  930 FORMAT(1X,'C[',T67,']*',/,
     +       1X,'C[   INVERSE FOURIER TRANSFORM:',T67,']*',/,
     +       1X,'C[',3X,26('='),T67,']*',/,
     +       1X,'C[   *',4X,'X',4X,'*',5X,'RE(F(X))',5X,'*',
     +             5X,'IM(F(X))',5X,'*',T67,']*',/,
     +       1X,'C[',3X,49('*'),T67,']*')
  940 FORMAT(1X,'C[   * ',I3,' * ',E16.10,' * ',E16.10,' *',T67,']*')
  950 FORMAT(1X,'C[',T67,']*',/,
     +       1X,'C[   ERROR TABLE:',T67,']*',/,
     +       1X,'C[',3X,12('='),T67,']*',/,
     +       1X,'C[   *',3X,'X',4X,'*',' ABS(RE(F(X)-F^(X))) *',
     +       ' ABS(IM(F(X)-F^(X))) *',T67,']*',/,
     +       1X,'C[',3X,56('*'),T67,']*')
  960 FORMAT(1X,'C[   * ',F6.4,' * ',2(E19.13,' * '),T67,']*')
      END
