      PROGRAM TEST
C***************************************************************************
C                                                                          *
C  Test progrmm for the subroutine   SHPGLO.                               *
C  Computes points on the surface which is generated via a global          *
C  Shepard interpolation.                                                  *
C                                                                          *
C--------------------------------------------------------------------------*
C                                                                          *
C     The results are displayed on the screen for the following parameters.*
C     For IBM compatible PCs and the MICROSOFT FORTRAN 5.0 Compiler the    *
C     following results are computed:                                      *
C                                                                          *
C--------------------------------------------------------------------------*
C                                                                          *
C     Required subroutine:  SHPGLO                                         *
C                                                                          *
C--------------------------------------------------------------------------*
C                                                                          *
C   GIVEN:                                                                 *
C   ======                                                                 *
C    DMUE = 3      : Exponent                                              *
C    N    = 11     : Index of final node                                   *
C                                                                          *
C            FX           |            FY         |           FZ           *
C   ====================================================================   *
C   -.80000000000000D+00  |   .15000000000000D+01 |  .10535653752853D+01   *
C    .20000000000000D+00  |   .13000000000000D+01 |  .15066519173319D+01   *
C    .10000000000000D+01  |   .14000000000000D+01 |  .10198039027186D+01   *
C   -.12000000000000D+01  |   .30000000000000D+00 |  .15716233645502D+01   *
C   -.20000000000000D+00  |   .20000000000000D+00 |  .19798989873223D+01   *
C    .10000000000000D+01  |   .10000000000000D+01 |  .14142135623731D+01   *
C   -.80000000000000D+00  |  -.30000000000000D+00 |  .18083141320025D+01   *
C    .50000000000000D+00  |  -.40000000000000D+00 |  .18947295321496D+01   *
C    .15000000000000D+01  |  -.30000000000000D+00 |  .12884098726725D+01   *
C   -.11000000000000D+01  |  -.14000000000000D+01 |  .91104335791443D+00   *
C    .50000000000000D+00  |  -.17000000000000D+01 |  .92736184954957D+00   *
C    .13000000000000D+01  |  -.14000000000000D+01 |  .59160797830996D+00   *
C                                                                          *
C                                                                          *
C[                                                                        ]*
C[  WANTED TO FIND: POINTS THAT LIE ON THE SURFACE GENERATED BY GLOBAL    ]*
C[  ==============  SHEPARD INTERPOLATION                                 ]*
C[                                                                        ]*
C[                                                                        ]*
C[  SOLUTION: POINTS ON THE INTERPOLATING SURFACE                         ]*
C[  ========                                                              ]*
C[                                                                        ]*
C[                                                                        ]*
C[           X           |          Y           |          Z              ]*
C[  =====================+======================+======================   ]*
C[  -.20000000000000D+01 | -.20000000000000D+01 |  .11151351831927D+01    ]*
C[  -.20000000000000D+01 | -.15000000000000D+01 |  .11198898864140D+01    ]*
C[  -.20000000000000D+01 | -.10000000000000D+01 |  .12579565797566D+01    ]*
C[  -.20000000000000D+01 | -.50000000000000D+00 |  .14656916715327D+01    ]*
C[  -.20000000000000D+01 |  .00000000000000D+00 |  .15449527080825D+01    ]*
C[  -.20000000000000D+01 |  .50000000000000D+00 |  .15326741070552D+01    ]*
C[  -.20000000000000D+01 |  .10000000000000D+01 |  .14520067633664D+01    ]*
C[  -.20000000000000D+01 |  .15000000000000D+01 |  .13466608916261D+01    ]*
C[  -.20000000000000D+01 |  .20000000000000D+01 |  .13042873634186D+01    ]*
C[  -.15000000000000D+01 | -.20000000000000D+01 |  .10151486323201D+01    ]*
C[  -.15000000000000D+01 | -.15000000000000D+01 |  .95478826664125D+00    ]*
C[  -.15000000000000D+01 | -.10000000000000D+01 |  .11156820102078D+01    ]*
C[  -.15000000000000D+01 | -.50000000000000D+00 |  .15562218564635D+01    ]*
C[  -.15000000000000D+01 |  .00000000000000D+00 |  .15900421063530D+01    ]*
C[  -.15000000000000D+01 |  .50000000000000D+00 |  .15681060275343D+01    ]*
C[  -.15000000000000D+01 |  .10000000000000D+01 |  .14203084832693D+01    ]*
C[  -.15000000000000D+01 |  .15000000000000D+01 |  .12121642665714D+01    ]*
C[  -.15000000000000D+01 |  .20000000000000D+01 |  .12058150475172D+01    ]*
C[  -.10000000000000D+01 | -.20000000000000D+01 |  .99169720175570D+00    ]*
C[  -.10000000000000D+01 | -.15000000000000D+01 |  .91375762798880D+00    ]*
C[  -.10000000000000D+01 | -.10000000000000D+01 |  .10887824910145D+01    ]*
C[  -.10000000000000D+01 | -.50000000000000D+00 |  .17698734607498D+01    ]*
C[  -.10000000000000D+01 |  .00000000000000D+00 |  .16868263366815D+01    ]*
C[  -.10000000000000D+01 |  .50000000000000D+00 |  .15791733296064D+01    ]*
C[  -.10000000000000D+01 |  .10000000000000D+01 |  .12926402158150D+01    ]*
C[  -.10000000000000D+01 |  .15000000000000D+01 |  .10615454992118D+01    ]*
C[  -.10000000000000D+01 |  .20000000000000D+01 |  .11220110268622D+01    ]*
C[  -.50000000000000D+00 | -.20000000000000D+01 |  .10583030368669D+01    ]*
C[  -.50000000000000D+00 | -.15000000000000D+01 |  .10717943830902D+01    ]*
C[  -.50000000000000D+00 | -.10000000000000D+01 |  .13814500211218D+01    ]*
C[  -.50000000000000D+00 | -.50000000000000D+00 |  .17675440769472D+01    ]*
C[  -.50000000000000D+00 |  .00000000000000D+00 |  .18646562955876D+01    ]*
C[  -.50000000000000D+00 |  .50000000000000D+00 |  .18187959457551D+01    ]*
C[  -.50000000000000D+00 |  .10000000000000D+01 |  .13719689316653D+01    ]*
C[  -.50000000000000D+00 |  .15000000000000D+01 |  .11028591045832D+01    ]*
C[  -.50000000000000D+00 |  .20000000000000D+01 |  .11756085287939D+01    ]*
C[   .00000000000000D+00 | -.20000000000000D+01 |  .99062710964958D+00    ]*
C[   .00000000000000D+00 | -.15000000000000D+01 |  .10439950946364D+01    ]*
C[   .00000000000000D+00 | -.10000000000000D+01 |  .14454392619356D+01    ]*
C[   .00000000000000D+00 | -.50000000000000D+00 |  .17781123681415D+01    ]*
C[   .00000000000000D+00 |  .00000000000000D+00 |  .19343946747634D+01    ]*
C[   .00000000000000D+00 |  .50000000000000D+00 |  .18718702687249D+01    ]*
C[   .00000000000000D+00 |  .10000000000000D+01 |  .15035853734990D+01    ]*
C[   .00000000000000D+00 |  .15000000000000D+01 |  .14820991591227D+01    ]*
C[   .00000000000000D+00 |  .20000000000000D+01 |  .13557349069033D+01    ]*
C[   .50000000000000D+00 | -.20000000000000D+01 |  .93211446076695D+00    ]*
C[   .50000000000000D+00 | -.15000000000000D+01 |  .93210257862083D+00    ]*
C[   .50000000000000D+00 | -.10000000000000D+01 |  .13946216779345D+01    ]*
C[   .50000000000000D+00 | -.50000000000000D+00 |  .18923417673124D+01    ]*
C[   .50000000000000D+00 |  .00000000000000D+00 |  .18075643086269D+01    ]*
C[   .50000000000000D+00 |  .50000000000000D+00 |  .15631279984192D+01    ]*
C[   .50000000000000D+00 |  .10000000000000D+01 |  .14209994093694D+01    ]*
C[   .50000000000000D+00 |  .15000000000000D+01 |  .13857214384169D+01    ]*
C[   .50000000000000D+00 |  .20000000000000D+01 |  .13038416051146D+01    ]*
C[   .10000000000000D+01 | -.20000000000000D+01 |  .85475726775896D+00    ]*
C[   .10000000000000D+01 | -.15000000000000D+01 |  .68446589334696D+00    ]*
C[   .10000000000000D+01 | -.10000000000000D+01 |  .95570696290933D+00    ]*
C[   .10000000000000D+01 | -.50000000000000D+00 |  .15217508759694D+01    ]*
C[   .10000000000000D+01 |  .00000000000000D+00 |  .15014580854535D+01    ]*
C[   .10000000000000D+01 |  .50000000000000D+00 |  .14109753413276D+01    ]*
C[   .10000000000000D+01 |  .10000000000000D+01 |  .14142135623731D+01    ]*
C[   .10000000000000D+01 |  .15000000000000D+01 |  .10241771176909D+01    ]*
C[   .10000000000000D+01 |  .20000000000000D+01 |  .11657994131319D+01    ]*
C[   .15000000000000D+01 | -.20000000000000D+01 |  .74824944406669D+00    ]*
C[   .15000000000000D+01 | -.15000000000000D+01 |  .60731094767518D+00    ]*
C[   .15000000000000D+01 | -.10000000000000D+01 |  .81406459907044D+00    ]*
C[   .15000000000000D+01 | -.50000000000000D+00 |  .12866149876885D+01    ]*
C[   .15000000000000D+01 |  .00000000000000D+00 |  .12985037908520D+01    ]*
C[   .15000000000000D+01 |  .50000000000000D+00 |  .13530274421204D+01    ]*
C[   .15000000000000D+01 |  .10000000000000D+01 |  .13070079575708D+01    ]*
C[   .15000000000000D+01 |  .15000000000000D+01 |  .11594298147469D+01    ]*
C[   .15000000000000D+01 |  .20000000000000D+01 |  .11893445393032D+01    ]*
C[   .20000000000000D+01 | -.20000000000000D+01 |  .84234478745877D+00    ]*
C[   .20000000000000D+01 | -.15000000000000D+01 |  .80288731959780D+00    ]*
C[   .20000000000000D+01 | -.10000000000000D+01 |  .10084357609658D+01    ]*
C[   .20000000000000D+01 | -.50000000000000D+00 |  .12555814772561D+01    ]*
C[   .20000000000000D+01 |  .00000000000000D+00 |  .12945547464744D+01    ]*
C[   .20000000000000D+01 |  .50000000000000D+00 |  .13196087613372D+01    ]*
C[   .20000000000000D+01 |  .10000000000000D+01 |  .12968594721591D+01    ]*
C[   .20000000000000D+01 |  .15000000000000D+01 |  .12528884263632D+01    ]*
C[   .20000000000000D+01 |  .20000000000000D+01 |  .12481570651188D+01    ]*
C                                                                          *
C***************************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (N=11)
      DIMENSION FX(0:N),FY(0:N),FZ(0:N),W(0:N),R(0:N)
      DATA FX /  -.8D+00, .2D+00, .1D+01, -.12D+01, -.2D+00, .1D+01,
     F  -.8D+00, .5D+00, .15D+01, -.11D+01, .5D+00, .13D+01 /
      DATA FY /  .15D+01, .13D+01, .14D+01, .3D+00, .2D+00, .1D+01,
     F  -.3D+00, -.4D+00, -.3D+00, -.14D+01, -.17D+01, -.14D+01 /
      DATA FZ / .10535653752853D+01, .15066519173319D+01,
     F .10198039027186D+01, .15716233645502D+01, .19798989873223D+01,
     F .14142135623731D+01, .18083141320025D+01, .18947295321496D+01,
     F .12884098726725D+01, .91104335791443D+00, .92736184954957D+00,
     F .59160797830996D+00 /
      DMUE=3
      WRITE(*,890)
      WRITE(*,910)
      DO 10 X=-2.D0,2.D0,0.5D0
        DO 20 Y=-2.D0,2.D0,0.5D0
           CALL SHPGLO(X,Y,FX,FY,FZ,W,R,N,DMUE,PHI)
           WRITE(*,900)X,Y,PHI
20      CONTINUE
10    CONTINUE
      STOP
890   FORMAT(1X,'C[',T76,']*',
     +    /,1X,'C[',2X,'WANTED TO FIND: POINTS THAT LIE ON THE SURFACE'
     +    ,' GENERATED BY GLOBAL',T76,']*',
     +    /,1X,'C[',2X,'==============  SHEPARD INTERPOLATION',T76,']*',
     +    /,1X,'C[',T76,']*',
     +    /,1X,'C[',T76,']*',
     +    /,1X,'C[',2X,
     +    'SOLUTION: POINTS ON THE INTERPOLATING SURFACE ',T76,']*',
     +    /,1X,'C[',2X,'========',T76,']*',
     +    /,1X,'C[',T76,']*')
900   FORMAT(1X,'C[',2X,2(D20.14,1X,'|',1X),D20.14,T76,']*')
910   FORMAT(1X,'C[',T76,']*',
     +    /,1X,'C[',11X,'X',11X,'|',10X,'Y',11X,'|',10X,'Z',T76,']*',
     +    /,1X,'C[',2X,21('='),'+',22('='),'+',22('='),T76,']*')
      END
