      PROGRAM TEST
C
C*********************************************************************
C              Test program for the subroutines                      *
C              CFSPTR, CFSPPE, NCYFSY, TSPTAB.                       *
C--------------------------------------------------------------------*
C   required subroutines    :  CFSPTR,CFSPPE,NCYFSY,NCYFSP,          *
C                              NCYFSS,TSPTAB                         *
C--------------------------------------------------------------------*
C                                                                    *
C   This test program computes a transformed cubic fitting spline    *
C   for the nodes:                                                   *
C                                                                    *
C                  X            Y             W                      *
C              ----------------------------------                    *
C                32.0         15.0           10                      *
C                16.0         32.0            5                      *
C                -6.0         31.0            7                      *
C               -18.0         18.0           10                      *
C               -20.0         10.0            1                      *
C               -20.0         -7.0            1                      *
C               -13.0        -22.0            2                      *
C                -4.0        -26.0            5                      *
C                 4.0        -31.0            1                      *
C                12.0        -28.0            5                      *
C                21.0        -25.0            5                      *
C                33.0        -11.0           10                      *
C                32.0         15.0           10                      *
C                                                                    *
C                where W(I) = weight foru X(I),Y(I).                 *
C                                                                    *
C                                                                    *
C   the subroutien CFSPTR computes the transformed coordinates       *
C   PHIN(I),R(I), the translation PX, PY and the rotation PHID.      *
C   These, the computed spline coefficients and a table of values    *
C   for the points  XW(I), YW(I) are put out.                        * 
C                                                                    *
C  Results:                                                          *
C                                                                    *
C[                                                                  ]*
C[ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N=12)                 ]*
C[ ======   AND WEIGHTS W(I)                                        ]*
C[                                                                  ]*
C[  I        X(I)         Y(I)          W(I)                        ]*
C[ -------------------------------------------                      ]*
C[  0      32.0000      15.0000       10.0000                       ]*
C[  1      16.0000      32.0000        5.0000                       ]*
C[  2      -6.0000      31.0000        7.0000                       ]*
C[  3     -18.0000      18.0000       10.0000                       ]*
C[  4     -20.0000      10.0000        1.0000                       ]*
C[  5     -20.0000      -7.0000        1.0000                       ]*
C[  6     -13.0000     -22.0000        2.0000                       ]*
C[  7      -4.0000     -26.0000        5.0000                       ]*
C[  8       4.0000     -31.0000        1.0000                       ]*
C[  9      12.0000     -28.0000        5.0000                       ]*
C[ 10      21.0000     -25.0000        5.0000                       ]*
C[ 11      33.0000     -11.0000       10.0000                       ]*
C[ 12      32.0000      15.0000       10.0000                       ]*
C[                                                                  ]*
C[                                                                  ]*
C[ TO FIND: A) TABLE OF TRANSFORMED COORDINATES                     ]*
C[ ========    PHI(I),R(I), I=0(1)N                                 ]*
C[                                                                  ]*
C[          B) COEFFICIENTS OF A TRANSFORMED CUBIC APPROXIMATING    ]*
C[             SPLINE S(PHI) FOR THE NODES PHI(I),R(I)              ]*
C[                                                                  ]*
C[          C) TABLE OF VALUES FOR XW=XW(S(PHI)), YW=YW(S(PHI))     ]*
C[                                                                  ]*
C[                                                                  ]*
C[ SOLUTION:                                                        ]*
C[ =========                                                        ]*
C[                                                                  ]*
C[ A) TRANSFORMED COORDINATES:                                      ]*
C[    ------------------------                                      ]*
C[ SHIFT IN X DIRECTION :  PX =   6.5000000000                      ]*
C[   "   IN Y     "     :  PY =    .5000000000                      ]*
C[ ROTATION OF COORDINATE SYSTEM (IN RAD): PHID =    .5170319525    ]*
C[                                                                  ]*
C[ TRANSFORMED NODES:                                               ]*
C[                                                                  ]*
C[  I         PHI(I)                  R(I)                          ]*
C[ -------------------------------------------------                ]*
C[  0    .00000000000000E+00    .29334280287745E+02                 ]*
C[  1    .76085197677783E+00    .32901367752724E+02                 ]*
C[  2    .14427212544824E+01    .32962099447699E+02                 ]*
C[  3    .20043112151154E+01    .30108138434649E+02                 ]*
C[  4    .22803420181158E+01    .28151376520518E+02                 ]*
C[  5    .29003665996868E+01    .27540878707841E+02                 ]*
C[  6    .34812663292810E+01    .29774149861919E+02                 ]*
C[  7    .38181079682508E+01    .28504385627478E+02                 ]*
C[  8    .41161579569237E+01    .31599050618650E+02                 ]*
C[  9    .43859959338072E+01    .29025850547400E+02                 ]*
C[ 10    .47123889803847E+01    .29334280287745E+02                 ]*
C[ 11    .53567161451619E+01    .28887713651309E+02                 ]*
C[ 12    .62831853071796E+01    .29334280287745E+02                 ]*
C[                                                                  ]*
C[                                                                  ]*
C[ B) SPLINE COEFFICIENTS:                                          ]*
C[    --------------------                                          ]*
C[                                                                  ]*
C[  I       A(I)           B(I)           C(I)           D(I)       ]*
C[ --------------------------------------------------------------   ]*
C[  0  .30097996E+02  .19442135E+01  .96044926E+00 -.11773147E+01   ]*
C[  1  .31614702E+02  .13611055E+01 -.17268374E+01 -.10509333E+00   ]*
C[  2  .31706594E+02 -.11404373E+01 -.19418172E+01  .13596624E+01   ]*
C[  3  .30694538E+02 -.20350030E+01  .34890116E+00  .38233026E+00   ]*
C[  4  .30167439E+02 -.17549954E+01  .66550594E+00  .46319832E-01   ]*
C[  5  .29346180E+02 -.87631502E+00  .75166425E+00 -.25456375E+00   ]*
C[  6  .29040874E+02 -.26073532E+00  .30803620E+00 -.10138487E-01   ]*
C[  7  .28987611E+02 -.56667485E-01  .29779101E+00 -.41282594E+00   ]*
C[  8  .28986244E+02  .10827045E-01 -.71337286E-01  .22641771E-01   ]*
C[  9  .28984417E+02 -.22726158E-01 -.53008457E-01  .57170120E-01   ]*
C[ 10  .28973340E+02 -.39057928E-01  .29713318E-02  .35795399E+00   ]*
C[ 11  .29045159E+02  .41059294E+00  .69488978E+00  .95545357E-01   ]*
C[                                                                  ]*
C[ COEFFICIENTS FOUND.                                              ]*
C[                                                                  ]*
C[                                                                  ]*
C[ TABLE OF VALUES FOR:                                             ]*
C[   STARTING VALUE = PHIN(0) = 0.0                                 ]*
C[   FINAL VALUE    = PHIN(N) = 2*PI                                ]*
C[                                                                  ]*
C[                                                                  ]*
C[  C) TABLE OF VALUES:                                             ]*
C[     ----------------                                             ]*
C[                                                                  ]*
C[   I             XW(I)                   YW(I)                    ]*
C[ ---------------------------------------------------              ]*
C[   0     .32663890815521E+02     .15377506542159E+02              ]*
C[   1     .29680510081921E+02     .20313529692902E+02              ]*
C[   2     .25776578492299E+02     .24665125834790E+02              ]*
C[   3     .21041049893868E+02     .28218894761539E+02              ]*
C[   4     .15628485842216E+02     .30768137266295E+02              ]*
C[   5     .85875073847831E+01     .32265105449133E+02              ]*
C[   6     .13706108442276E+01     .31951190493943E+02              ]*
C[   7    -.55238831216903E+01     .29838274816924E+02              ]*
C[   8    -.10625310523828E+02     .26859418088446E+02              ]*
C[   9    -.14986194868087E+02     .22955170048523E+02              ]*
C[  10    -.18477172748328E+02     .18340837677377E+02              ]*
C[  11    -.20452111074902E+02     .14608183787896E+02              ]*
C[  12    -.21897799137619E+02     .10680343087071E+02              ]*
C[  13    -.23051805766275E+02     .45904959986984E+01              ]*
C[  14    -.22988385978566E+02    -.15418164523113E+01              ]*
C[  15    -.21737072020777E+02    -.74916241568236E+01              ]*
C[  16    -.19543731720110E+02    -.12710956945477E+02              ]*
C[  17    -.16437599299678E+02    -.17415175609434E+02              ]*
C[  18    -.12519755288615E+02    -.21445871486863E+02              ]*
C[  19    -.85536656735097E+01    -.24293444328190E+02              ]*
C[  20    -.41780028495387E+01    -.26449245286931E+02              ]*
C[  21    -.57665357701423E-01    -.27732839299399E+02              ]*
C[  22     .42067155653212E+01    -.28395383876953E+02              ]*
C[  23     .81142876628961E+01    -.28441476565396E+02              ]*
C[  24     .11992148822686E+02    -.27959316626645E+02              ]*
C[  25     .16541359221519E+02    -.26684280364398E+02              ]*
C[  26     .20821586233672E+02    -.24686237859217E+02              ]*
C[  27     .25857292732464E+02    -.21051728355090E+02              ]*
C[  28     .30019497274969E+02    -.16440819894307E+02              ]*
C[  29     .33144431552870E+02    -.11062677843698E+02              ]*
C[  30     .35218624662137E+02    -.46612580607138E+01              ]*
C[  31     .35851445936299E+02     .20805557271043E+01              ]*
C[  32     .34996586613502E+02     .88616369170127E+01              ]*
C[  33     .32663890815521E+02     .15377506542159E+02              ]*
C[                                                                  ]*
C[ TABLE FOUND.                                                     ]*
C                                                                    *
C*********************************************************************
C                                                                    *
C   Author      :  Gnter Palm                                       *
C   Date        :  5.22.1988                                         *
C   Source code :  FORTRAN 77                                        *
C                                                                    *
C*********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (N=12,MT=25)
C
      DIMENSION X(0:N),Y(0:N),PHIN(0:N),R(0:N),W(0:N)
      DIMENSION A(0:N),B(0:N),C(0:N),D(0:N)
      DIMENSION XW(0:N+MT+2),YW(0:N+MT+2)
      DIMENSION HILF(14*N-10)
C
      DATA X / 32.0D0, 16.0D0, -6.0D0,-18.0D0,-20.0D0,-20.0D0,
     +        -13.0D0, -4.0D0,  4.0D0, 12.0D0, 21.0D0, 33.0D0, 32.0D0/
      DATA Y / 15.0D0, 32.0D0, 31.0D0, 18.0D0, 10.0D0, -7.0D0,
     +        -22.0D0,-26.0D0,-31.0D0,-28.0D0,-25.0D0,-11.0D0, 15.0D0/
      DATA W / 10.0D0,  5.0D0,  7.0D0, 10.0D0,  1.0D0,  1.0D0,
     +          2.0D0,  5.0D0,  1.0D0,  5.0D0,  5.0D0, 10.0D0, 10.0D0/
      DATA JV /-1/
C
      CALL CFSPTR (N,X,Y,W,JV,PX,PY,A,B,C,D,PHIN,R,PHID,HILF,IFEHL)
      IF (IFEHL .NE. 0) THEN
         WRITE (*,1000) IFEHL
         STOP
      ENDIF
      WRITE (*,2000) N
      DO 100 I = 0,N,1
         WRITE (*,2100) I,X(I),Y(I),W(I)
  100 CONTINUE
      WRITE (*,2200)
      WRITE (*,2250) PX,PY,PHID
      DO 150 I = 0,N,1
         WRITE (*,2300) I,PHIN(I),R(I)
  150 CONTINUE
      WRITE (*,2400)
      DO 200 I = 0,N-1,1
         WRITE (*,2500) I,A(I),B(I),C(I),D(I)
  200 CONTINUE
C
      WRITE (*,1050)
      PANF = PHIN(0)
      PEND = PHIN(N)
      CALL TSPTAB (N,MT,PANF,PEND,PHIN,A,B,C,D,PHID,PX,PY,
     +             NT,XW,YW,IFEHL)
      IF (IFEHL .NE. 0) THEN
         WRITE (*,1300) IFEHL
         STOP
      ENDIF
      WRITE (*,2700)
      DO 300 I = 0,NT,1
         WRITE (*,2800) I,XW(I),YW(I)
  300 CONTINUE
      WRITE (*,2900)
      STOP
C
C Formatangaben
C
 1000 FORMAT(1X,'C[ ERROR IN COMPUTING COEFFICIENTS.',T70,']*',/,
     +       1X,'C[ ERROR PARAMETER =',I4,T70,']*')
 1050 FORMAT(1X,'C[',T70,']*',/,
     +       1X,'C[ COEFFICIENTS FOUND.',
     +           T70,']*',/,1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,
     +       1X,'C[ TABLE OF VALUES FOR:',T70,']*',/,
     +       1X,'C[   STARTING VALUE = PHIN(0) = 0.0',T70,']*',/,
     +       1X,'C[   FINAL VALUE    = PHIN(N) = 2*PI',T70,']*',/,
     +       1X,'C[',T70,']*')
 1300 FORMAT(1X,'C[ ERRONEOUS INPUT.',T70,']*',/,
     +       1X,'C[ PHIN(0) EXCEEDS PHIN(N).',T70,']*')
 2000 FORMAT(1X,'C[',T70,']*',/,
     +       1X,'C[ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N=',I2,
     +          ')',T70,']*',/,
     +       1X,'C[ ======   AND WEIGHTS W(I)',T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[  I        X(I)         Y(I)          W(I)',
     +       T70,']*',/,
     +       1X,'C[',1X,43('-'),T70,']*')
 2100 FORMAT(1X,'C[',1X,I2,4X,F9.4,4X,F9.4,4X,F10.4,T70,']*')
 2200 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,
     +       1X,'C[ TO FIND: A) TABLE OF TRANSFORMED COORDINATES',
     +              T70,']*',/,
     +       1X,'C[ ========    PHI(I),R(I), I=0(1)N',T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[',10X,'B) COEFFICIENTS OF A TRANSFORMED CUBIC ',
     +          'APPROXIMATING',T70,']*',/,
     +       1X,'C[',13X,'SPLINE S(PHI) FOR THE NODES PHI(I),R(I)',
     +          T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[',10X,'C) TABLE OF VALUES FOR XW=XW(S(PHI)), ',
     +          'YW=YW(S(PHI))',T70,']*',/,
     +       1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,
     +       1X,'C[ SOLUTION:',T70,']*',/,1X,'C[ =========',T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[ A) TRANSFORMED COORDINATES:',T70,']*',/,
     +       1X,'C[    ------------------------',T70,']*')
 2250 FORMAT(1X,'C[ SHIFT IN X DIRECTION :  PX = ',F14.10,T70,']*',/,
     +       1X,'C[   "   IN Y     "     :  PY = ',F14.10,T70,']*',/,
     +       1X,'C[ ROTATION OF COORDINATE SYSTEM (IN RAD): PHID = ',
     +          F14.10,T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[ TRANSFORMED NODES:',T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[  I         PHI(I)                  R(I)',T70,']*',/,
     +       1X,'C[',1X,49('-'),T70,']*')
 2300 FORMAT(1X,'C[',1X,I2,2(3X,E20.14),T70,']*')
 2400 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,
     +       1X,'C[ B) SPLINE COEFFICIENTS:',T70,']*',/,
     +       1X,'C[    --------------------',T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[  I',7X,'A(I)',11X,'B(I)',11X,'C(I)',11X,'D(I)',
     +          T70,']*',/,
     +       1X,'C[',1X,62('-'),T70,']*')
 2500 FORMAT(1X,'C[',1X,I2,4(1X,E14.8),T70,']*')
 2700 FORMAT(1X,'C[',T70,']*',/,
     +       1X,'C[  C) TABLE OF VALUES:',T70,']*',/,
     +       1X,'C[     ----------------',T70,']*',/,
     +       1X,'C[',T70,']*',/,
     +       1X,'C[   I             XW(I)                   YW(I)',
     +       T70,']*',/,1X,'C[',1X,51('-'),T70,']*')
 2800 FORMAT(1X,'C[',1X,I3,2(4X,E20.14),T70,']*')
 2900 FORMAT(1X,'C[',T70,']*',/,
     +       1X,'C[ TABLE FOUND.',T70,']*')
      END
