(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Morphisms` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 0. Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  	AbstractAlgebra`Morphisms *)

(* :Context: AbstractAlgebra`Morphisms` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 1. Startup Morphisms
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Morphisms`",{"AbstractAlgebra`Core`",
"AbstractAlgebra`Joint`", "AbstractAlgebra`GroupProperties`",
"Graphics`Colors`", "Graphics`Arrow`",
	"Utilities`FilterOptions`"}];
	
Off[General::spell,General::spell1];
SetOptions[Graphics,AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.1 Morphoid Usage/message
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Usage
:[font = input; initialization; preserveAspect; endGroup]
*)
Aut::usage ="Aut[G] is a shortcut for AutomorphismGroup[G].";

ToFunction::usage = "ToFunction[rules] returns a function of the form
ffx (where x is an integer), which is the result of converting the list
of rules to a function. ToFunction[rules, f] specifies that the returned
function is represented by the symbol f. ToFunction[f] converts the
Morphoid based on the Rules definition to one based on a Function (or
Symbol) definition, using a function of the form ffx (where x is an
integer). ToFunction[f, g] specifies that the returned function is
represented by the symbol g.";

Automorphism::usage="Automorphism[G, a -> b] forms the automorphism
determined by the single rule a -> b, if a and b are both generators of
the cyclic group G.";

AutomorphismGroup::usage="AutomorphismGroup[G] returns the group of
automorphisms of a cyclic group G.";

Cautious::usage="Cautious is an option of IsomorphismQ, indicating
whether MorphismQ or ProbableMorphismQ should be used.";

Codomain::usage = "Codomain[f] returns the structure used in the image
of the Morphoid f.";

ColorCodomain::usage = "ColorCodomain is an option for the
VisualizeMorphoid function. By specifying ColorCodomain -> {{color1,
cod1}, {color2, cod2},...}, the arrows to the codomain element codi will
be colored colori. Note that these requests supersede those requests
from ColorDomain, if an arrow is requested to be colored by both
ColorDomain and ColorCodomain.";

ColorDomain::usage = "ColorDomain is an option for the VisualizeMorphoid
function. By specifying ColorDomain -> {{color1, dom1}, {color2,
dom2},...}, the arrow from domain element domi will be colored colori,
unless superseded by a color request from ColorCodomain.";

EqualMorphoidQ::usage="EqualMorphoidQ[f, g] compares two Morphoids f and
g and returns True if their functions are identical and are between
identical types of structures, and False otherwise. The operations of
the structures are not compared.";

Fiber::usage="Fiber[f, S] is equivalent to InverseImage[f,S].";

FormatFunction::usage = "FormatFunction is an option of FormMorphoid
that indicates whether a Morphoids function should be displayed in an
abbreviated (or formatted form). While the default value is False, it
can also be set to True.";

FormMorphoid::usage = "FormMorphoid[f, S1, S2, (opts)] is the standard
means for creating a Morphoid. Here, S1 and S2 are Groupoids or Ringoids,
and f is either a list of Rules, a Function, or a Symbol. In the special
case where S1 is a cyclic Groupoid, f can consist of just one rule that
sets up the morphism. Additionally, if S1 consists of n elements and S2
consists of m elements, then FormMorphoid[{p1, p2, ... pn}, S1, S2]
forms the Morphoid by sending the first element in S1 to the element in
S2 in position p1, the second element in S1 to the element in position
p2 in S2, until finally the nth element goes to the element in position
pn in S2. FormMorphoidSetup may be useful in using this method. The
options opts can consist of setting the Mode or the value of
FormatFunction (default is False), which determines if the function
should be formatted or not.";

FormMorphoidSetup::usage= "FormMorphoidSetup[S1, S2] produces a graphic
that assists in the preparation of a list of positions to use in
FormMorphoid. The arguments S2 and S2 must be Groupoids or Ringoids";

FunctionForm::usage="Function form is an option that controls whether a
Morphoid defined by a rule or a function is to be created. An option of
InnerAutomorphism.";

HomomorphismQ::usage = "HomomorphismQ[f] returns True if the Morphoid f
is a homomorphism. This is equivalent to MorphismQ.";

Image::usage = "Image[f] returns a Groupoid or Ringoid (as appropriate)
consisting of the image values of the Morphoid f. Additionally, Image[f,
S] returns the images of the substructure S of the domain of f.";

InducedCanonical::usage = "InducedCanonical[f], given a Morphoid f: G -> H,
returns the Morphoid g : G -> G/Ker[f].";

InducedIsomorphism::usage = "InducedIsomorphism[f], given a Morphoid f: G -> H,
returns the Morphoid g : G/Kernel[f] -> Image[H].";

InjectiveQ::usage="InjectiveQ[f] returns True if the Morphoid f is
injective (one-to-one), and False otherwise.";

Inn::usage = "Inn[G] is identical to InnerAutomorphismGroup[G].";

InnerAutomorphism::usage = "InnerAutomorphism[G, g], when given an
element g in the group G, returns the inner automorphism of G induced by
g.";

InnerAutomorphismGroup::usage="InnerAutomorphismGroup[G] returns the
group of inner automorphisms of G, if G is a group.";

InverseImage::usage="InverseImage[f, S] returns the elements of the
domain of the Morphoid f that map into elements of the list or element
S, coming from the codomain. There is a Visual mode for this function.";

InverseImages::usage = "InverseImages[f] returns the set of inverse
images. This is partially equivalent to InverseImage[f,
Elements[Codomain[f]]] except the latter returns a single (unsorted)
list of the inverse images while this function partitions them according
to the elements in Codomain[f]. The option WithImages (defaults to
False) indicates whether the image elements should be included in the
output. There is a Visual mode for this function.";

IsomorphismQ::usage = "IsomorphismQ[f] returns True if the Morphoid f is
an isomorphism (group or ring, as appropriate), and False otherwise. The
option Cautious (defaults to False) indicates MorphismQ (if True) or if
ProbableMorphismQ (if False) should be used.";

Kernel::usage = "Kernel[f] returns the kernel of the Morphoid f, if the
second Groupoid/Ringoid has an identity element. It is not necessary
that f satisfies MorphismQ. The object returned is a Groupoid or Ringoid
(as appropriate). There is a Visual mode for this function.";

MorphismQ::usage = "MorphismQ[f] returns True if the Morphoid f is a
homomorphism, and False otherwise. This function automatically checks to
see if f represents a group homomorphism or a ring homomorphism. The
Visual mode can be used with this function. MorphismQ[f, {S1, op1}, {S2,
op2}] or MorphismQ[f, {S1, op1, op3}, {S2, op2, op4}] are alternative
usages, where f is either a list of Rules, a Function or a Symbol.";

Morphoid::usage = "Morphoid is the data structure for possible
morphisms. This is the 'Head' of the object returned by FormMorphoid
when one creates a morphism.";

MorphoidComposition::usage="MorphoidComposition[g, f] forms the
composition of f and g if the codomain of f and the domain of g are the
same structured system. Note: this function creates a Morphoid with
function g[f[#]]& and converts it to rules.";

MorphoidFunction::usage = "MorphoidFunction[f] returns the function
defining the Morphoid f.";

MorphoidRules::usage = "MorphoidRules[f] returns the list of rules
defining the Morphoid f.";

OneToOneQ::usage="OneToOneQ[f] is equivalent to InjectiveQ[f].";

OntoQ::usage = "OntoQ[f] is equivalent to SurjectiveQ[f].";

ZMap::usage = "ZMap[m, n] creates Morphoid[Mod[#, n]&, Z[m], Z[n]]. ZMap[m,
n, g -> h] creates Morphoid[g -> h, Z[m], Z[n]], where g must be a
generator in Z[m]. In either case, one can add the option Structure ->
Ring to indicate that Z[m] and Z[n] should be considered rings.";

PreservesQ::usage = "PreservesQ[f, {a, b}] returns True if the Morphoid
f preserves the binary operations for the pair (a,b), and False
otherwise. Alternatively, if f is either a list of Rules, a Function or
a Symbol, S(i) is a set of Elements, and op(i) is a binary operation,
then the following are also acceptable usages: PreservesQ[f, {S1, op1},
{S2, op2}, {a, b}], PreservesQ[f, {S1, op1, op3}, {S2, op2, op4}, {a,
b}]. This also supports the Visual Mode.";

PrintMessage::usage="PrintMessage is an option of ProbableMorphism. Set
to True (the default), it will warn the user that a positive result is
not absolutely certain, but only probabilistic.";

ProbableMorphismQ::usage="ProbableMorphismQ[f] returns True if checking
random pairs of elements in the domain of Morphoid f indicates that f
preserves operations, and False otherwise. This is a fast, effective,
yet not a foolproof way of testing whether a Morphoid is a morphism. The
options SampleSize controls the number of pairs tested. SamplePairs,
by default set to Random, controls the specific pairs to be tested,
if not chosen randomly";

Rules::usage="Rules is an option value of FunctionForm.";

SamplePairs::usage="SamplePairs is an option for ProbableMorphismQ,
whose default value is Random, meaning the pairs are chosen randomly.
Alternatively, the value Default uses a short, built-in list of pairs,
one can give a list
of pairs of indices (not elements) to test, for example: {{2,3},{3,5}}.";

SampleSize::usage="SampleSize is an Option of ProbableMorphismQ, that
specifies the number of tests to perform.";

Sgn::usage = "Sgn[G] gives the Morphoid from the group of permutations G to
IntegerUnits given by the Parity function.";

SurjectiveQ::usage="Surjective[f] returns True if the Morphoid f is a
surjection (is onto), and False otherwise.";

VisualizeMorphoid::usage = "VisualizeMorphoid[f, opts] provides a
visualization of the Morphoid f by using arrows from the domain to the
codomain to indicate the map. Available options are ColorDomain and
ColorCodomain, both of whose default value is {}.";

WithImages::usage = "WithImages is an option for the InverseImages
function. If set to False (default), only the list of inverse images are
listed, while if set to True, each inverse image is listed with its
image element.";
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Other Messages
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Automorphism::badrule="The rule provided does not uniquely define an
automorphism on `1`. The rule must map a generator to a generator.";

Automorphism::nosup="Automorphism only supports cyclic groups at this
time.";

AutomorphismGroup::nosup="AutomorphismGroup only supports cyclic groups
at this time.";

FormMorphoid::badpos="Invalid list of positions.";

ProbableMorphismQ::warning = "The ProbableMorphismQ function is being used;
'True' results are only probable, not certain.";

FormMorphoid::badstruc = "In creating a Morphism between two structures
A and B, these structures must be both Groupoids or both Ringoids.";

InnerAutomorphism::noinv="InnerAutomorphism is not defined; group
element `1` does not have an inverse.";

InnerAutomorphismGroup::nogroup="`1` is not a group - no inner
automorphism group.";

IsomorphismQ::notHom = "The Morphoid is not a homomorphism, so it is
not possible to be an isomorphism.";

Kernel::noid="Kernel is undefined - codomain `1` has no identity";

Morphoid::badarg="Invalid argument(s) to `1`.";

Morphoid::dff = "The number of elements in `1` is not the same as in `2`
and so it can't be an isomorphism.";

Morphoid::domain = "The list of rules `1` needs to have exactly one
instance of the elements of the domain `2` occurring on the left-hand
side of the rules before we can have a morphoid.";

Morphoid::fail = "The function or rules `1` needs to carry the elements
of `2` to `3` before we can have a morphoid.";

Morphoid::notonto="Since the Morphoid is not onto, it can not be an isomorphism.";

Morphoid::npres="Morphoid doesn't preserve operations for at least one
pair of elements.";

Morphoid::range = "The values on the right-hand side of each rule in `1`
needs to form a subset of the codomain `2` before we can have a
morphoid.";

MorphoidComposition::notdef2="Composition is not defined because the
first Morphoid is based on a `1` while the second is based on a `2`,
which are not the same.";

MorphoidComposition::notdef="Composition is not defined because the
image of the first map is `1` while the domain of the second map is `2`,
which are not the same.";

ZMap::relpr = "In forming ZMap[`1`, `2`, `3` -> `4`], the element `3` must
be a generator in Z[`1`].";

Structure::nosup="`1` does not support structures of type `2`.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.5 Begin private section
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 Morphoid Definitions
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
general
:[font = input; initialization; preserveAspect; endGroup]
*)
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Morphoid Form & Formation
:[font = input; initialization; preserveAspect; endGroup]
*)
StringRule[rule_] := Module[{lst},
		lst = rule /. Rule[x_,y_] :> Rule[ToString[x],ToString[y]];
		If[$VersionNumber < 2.5, ToString[lst],
			lst /. Rule[x_, y_] :> x<>" \[Rule] "<>y]
]

Format[morphoid[f_,S1_?StructuredSetQ,S2_?StructuredSetQ,str_,ft_,opts___?OptionQ]] :=
	Module[{fmt=FormatFunction/.Flatten[{opts, Options[FormMorphoid]}],
		gr=First[GeneratingRule/.Flatten[{opts, Options[PrivateFormMorphoid]}]],
		ce=ConjugatingElement/.Flatten[{opts, Options[PrivateFormMorphoid]}],
		fts = If[ft===Rule, "-Rules-","-Function-"]},
	If[fmt===True,
		Morphoid[fts,"-"<>AbstractAlgebra`Core`Private`StructureName[S1]<>"-","-"<>AbstractAlgebra`Core`Private`StructureName[S2]<>"-"],
		If[fmt===Rule,
			Morphoid[StringRule[gr],"-"<>AbstractAlgebra`Core`Private`StructureName[S1]<>"-","-"<>AbstractAlgebra`Core`Private`StructureName[S2]<>"-"],
			If[fmt===Conjugation,
				Morphoid["Conjugation by "<>ToString[KeyForm[S1][ce]],"-"<>AbstractAlgebra`Core`Private`StructureName[S1]<>"-","-"<>AbstractAlgebra`Core`Private`StructureName[S2]<>"-"],
				Morphoid[f,"-"<>AbstractAlgebra`Core`Private`StructureName[S1]<>"-","-"<>AbstractAlgebra`Core`Private`StructureName[S2]<>"-"]]]]]
	
MorphoidQ[f_] :=  ValidMorphFuncQ[First[f]] &&
	StructuredSetQ[f[[2]]] && StructuredSetQ[f[[3]]]
	
ValidMorphFuncQ[f_] := (Head[f]==Symbol || Head[f]==Function ||
	(Head[f]==List && Head[f[[1]]]==Rule))
	
MorphoidRules[f_?MorphoidQ] := f[[1]] (* for external use *)

MorphoidFunction[f_?MorphoidQ] := f[[1]] (* for external use *)

Domain[f_?MorphoidQ] := f[[2]] (* for external use *)

Codomain[f_?MorphoidQ] := f[[3]] (* for external use *)

MorphoidStructure[f_?MorphoidQ] := f[[4]] (* for internal use *)

MorphoidType[f_?MorphoidQ] := f[[5]] (* for internal use *)

MorphoidOptions[f_?MorphoidQ] := Apply[List, Drop[f, 5]]
(* for internal use *)

morphoid[f_,S1_?StructuredSetQ,S2_?StructuredSetQ,_,Rule,opts__][x_]:=
		Which[ElementQ[x,S1], x/.f,
			ElementsQ[x, S1], x/.f,
			True, Message[MemberQ::elsbst, x, S1]; $Failed];
		
morphoid[f_,S1_?StructuredSetQ,S2_?StructuredSetQ,_,Function,opts__][x_]:=
		Which[ElementQ[x, S1], f[x],
			ElementsQ[x, S1], Map[f, x],
			True, Message[MemberQ::elsbst, x, S1]; $Failed];
 
Options[FormMorphoid]={Mode -> Computational, FormatFunction->False};

Options[PrivateFormMorphoid]={GeneratingRule -> {Null}, 
ConjugatingElement->Null};
	
FormMorphoid[f_Function, S1_?StructuredSetQ,S2_?StructuredSetQ,
	opts___?OptionQ] :=
	Module[{head1=Head[S1],head2=Head[S2],structure,
	 		 ff = FormatFunction/.Flatten[{opts, Options[FormMorphoid]}],
	 		 ce = ConjugatingElement/.Flatten[{opts, Options[PrivateFormMorphoid]}],
	 		 gr = GeneratingRule/.Flatten[{opts, Options[PrivateFormMorphoid]}]},
		If[head1 === head2,
			structure = Switch[head1,
					AbstractAlgebra`Core`Private`groupoid, Group,
					AbstractAlgebra`Core`Private`ringoid, Ring];	
		If[SubsetQ[Map[f,Elements[S1]], Elements[S2]],
			morphoid[f,S1,S2,structure,Function,
												FormatFunction->ff, GeneratingRule -> gr,ConjugatingElement->ce],
			Message[Morphoid::fail,f,AbstractAlgebra`Core`Private`StructureName[S1],AbstractAlgebra`Core`Private`StructureName[S2]];$Failed],
			$Failed]]

FormMorphoid[args__, Mode -> Visual, opts___?OptionQ] := Module[{f},
	f = FormMorphoid[args, opts];
	VisualizeMorphoid[f, opts];
	f]
	
FormMorphoid[f_Symbol, 
					S1_?StructuredSetQ,
					S2_?StructuredSetQ,
					opts___?OptionQ] :=
				FormMorphoid[f[#]&,S1,S2,opts];

FormMorphoid[rules:{_Rule..},
			 S1_?StructuredSetQ,
			 S2_?StructuredSetQ,
			 opts___?OptionQ] :=
	Module[{head1=Head[S1],head2=Head[S2],structure,sets,
	 		 ff=FormatFunction/.Flatten[{opts, Options[FormMorphoid]}], 
	 		 ce = ConjugatingElement/.Flatten[{opts, Options[PrivateFormMorphoid]}],
	 		 gr = GeneratingRule/.Flatten[{opts, Options[PrivateFormMorphoid]}]},
		If[head1===head2,structure=Switch[head1,
										AbstractAlgebra`Core`Private`groupoid,Group,
										AbstractAlgebra`Core`Private`ringoid,Ring];	
		sets = Apply[List,rules,1]//Transpose;
		If[Length[rules] > 20, ff = True];
		(* I picked 20, but this can be changed, to say that the list of
		rules should be formatted. *)
		If[Equal[Sort[Elements[S1]],Sort[First[sets]]] && 
		       SubsetQ[Last[sets],Elements[S2]],
			morphoid[rules,S1,S2,structure, Rule,
			 										FormatFunction -> ff,
			 									 GeneratingRule -> gr,
			 									 ConjugatingElement->ce],
			If[Not[Equal[Sort[Elements[S1]],Sort[First[sets]]]],
			Message[Morphoid::domain,rules,AbstractAlgebra`Core`Private`StructureName[S1]]; $Failed,
			Message[Morphoid::range,rules,AbstractAlgebra`Core`Private`StructureName[S2]]; $Failed]],
			$Failed]]

semiop[x_,op_] := op[x,#]&

CyclicQ[R_?RingoidQ] := CyclicQ[TempGroupoid[R[[1]], R[[2]]]] 

FormMorphoid[gen_ -> im_, G_?CyclicQ, H_?StructuredSetQ, opts___?OptionQ] :=
        Module[{dom,rng, len = Length[Elements[G]], rules,s1=Head[G],s2=Head[H]},
                dom = NestList[semiop[gen,Addition[G]],gen,len-1];
                rng = NestList[semiop[im,Addition[H]],im,len-1];
                rules = Apply[Rule,Transpose[{dom,rng}],1];
	If[s1===s2, 
		id1 = GroupIdentity[If[GroupoidQ[G], G, TAGroupoid[G]]];
		id2 = GroupIdentity[If[GroupoidQ[H], H, TAGroupoid[H]]];
		rules = rules/. Rule[id1,_] :> Rule[id1, id2];
		(* to ensure that identities match up *)
		morphoid[rules, G, H, If[s1===AbstractAlgebra`Core`Private`groupoid, Group,Ring], Rule, FormatFunction -> Rule, 
                	GeneratingRule -> {Rule[gen, im]}],
               Message[FormMorphoid::badstruc]; $Failed]]

RulesByPosition[S1_List,S2_List,pos_List]:=
  Module[{n=Length[S2]},
   If[(Length[S1]=!=Length[pos])||(Union[pos,Range[1,n]]=!=Range[1,n]),"Error",
       Transpose[{S1,Map[S2[[#]]&,pos]}]//Map[Rule[First[#],Last[#]]&,#]&]]

FormMorphoid[pos:{_Integer..},
						S1_?StructuredSetQ,
						S2_?StructuredSetQ,
						opts___?OptionQ]:=
Module[{mymode=Mode/.{opts}/.Options[FormMorphoid],
		s1=Head[S1],s2=Head[S2],structure},
	If[s1===s2,structure=Which[s1===AbstractAlgebra`Core`Private`groupoid,Group,
						  s1===AbstractAlgebra`Core`Private`ringoid,Ring,
						  True,Null]];
	If[(structure===Group)||(structure===Ring),
		Which[mymode==Computational,
    		If[(Length[First[S1]]=!=Length[pos])||
   				(Union[pos,Range[1,Length[First[S2]]]]=!=Range[1,Length[First[S2]]]),
				Message[FormMorphoid::badpos];$Failed,
				FormMorphoid[RulesByPosition[S1[[1]],S2[[1]],pos],
							 S1,S2,opts]],
			True,Message[Mode::notavail,FormMorphoid,mymode]],
			Message[Morphoid::badarg,FormMorphoid];$Failed]];
				 
Options[FormMorphoidSetup]={Mode->Visual};

FormMorphoidSetup[S1_?StructuredSetQ,
						S2_?StructuredSetQ,opts___?OptionQ]:=
	Module[{m,n,mp,np,r1,r2,T1=First[S1],T2=First[S2],
			mymode=Mode/.{opts}/.Options[FormMorphoidSetup]},
			Which[mymode==Visual,
			m=Length[T1];n=Length[T2];
			mp=Quotient[m,2];np=Quotient[n,2];
			r1=Range[1,m];r2=Range[1,n];
			{Line[{{0,Min[mp-m-1,np-n-1]},{0,Max[mp+1,np+1]}}],
			(* removed the -2 and +2 in calculations of line height *)
				Text["Domain",{-6,mp}],Text["Codomain",{6,np}],
			 Map[{Text[KeyForm[S1][T1[[#]]],{-6,-#+mp}],
			     Text[#,{-1,-#+mp}]}&,r1],
			 Map[{Text[KeyForm[S2][T2[[#]]],{6,-#+np}],
			     Text[#,{1,-#+np}]}&,r2]}//Graphics//
			     Show[#,PlotRange->{{-10,10},
			                  {Min[mp-m-2,np-n-2],Max[mp+2,np+2]}}]&,
			      True,Message[Mode::notavail,FormMorphoidSetup,mymode]]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Automorphisms
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Automorphism
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[Automorphism]={Mode->Computational};

Automorphism[G_?GroupoidQ,a_->b_,Mode->Computational]:=
If[CyclicQ[G],
If[(OrderOfElement[G,a]==Order[G])&&
      (OrderOfElement[G,b]==Order[G]),
	FormMorphoid[Map[{ElementToPower[G,a,#],
						ElementToPower[G,b,#]}&,Range[1,Order[G]]]//
						Sort[#,(First[#1]<First[#2])&]&//
						Map[Apply[Rule,#]&,#]&,G,G,
           			 FormatFunction->Rule, GeneratingRule ->{Rule[a, b]}],
	Message[Automorphism::badrule,GroupoidName[G]]; $Failed],
	(Message[Automorphism::nosup];$Failed)];

Automorphism[G_?GroupoidQ,a_->b_, opts___?OptionQ] := 
Module[{mymode, 
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts],auto},
	mymode = Mode/.Flatten[{opts, Options[Automorphism]}];
	auto =Automorphism[G,a->b,Mode->Computational];
	AbstractAlgebra`Core`Private`ShowModes[
				"AbstractAlgebra`Morphisms",
	           Automorphism,mymode,auto,
	           {G,a->b},
	           {Null},
	           {Null},
	           {Null},
	           sc]]


AutomorphismTextual[G_?GroupoidQ,a_->b_]:=
  Module[{ord=OrderOfElement[G,a],
         sumstring,
         symb=ToString[OperatorSymbol[G]]},
   	sumstring=Module[{as=ToString[#1]},
	If[#2<4,Nest[(#<>symb<>as)&,as,#2-1],
		as<>symb<>as<>symb<>"<<"<>ToString[#2-3]<>">>"<>symb<>as]]&;
	Map[{#,ElementToPower[G,a,#],
			ElementToPower[G,b,#]}&,Range[2,ord]]//
	 Map[(ToString[#[[2]]]<>" = "<>
	 		sumstring[a,#[[1]]]<>" is mapped to "<>
	 		sumstring[b,#[[1]]]<>" = "<>
	 		ToString[#[[3]]])&,#]&//
	 		Map[Print,#]&];
 

Options[AutomorphismGroup]={Mode->Computational};

AutomorphismGroup[G_,opts___?OptionQ]:=
   Module[{gens,fg,
        	ff=FormatFunction/.Flatten[{opts, Options[MorphoidComposition]}]},
   If[CyclicQ[G],gens=CyclicGenerators[G];fg=First[gens];
       Map[Automorphism[G,fg->#,Mode -> Computational]&,gens]//
		FormGroupoid[#,MorphoidComposition[#1,#2]&,"*",
		             GroupoidName->"Aut["<>GroupoidName[G]<>"]",
		             GroupoidDescription->"Automorphism group of "<>GroupoidName[G],
		             KeyForm->OutputForm,
		             IsAGroup->True,
		             WideElements->True,
		             CayleyForm->OutputForm]&,
		Message[AutomorphismGroup::nosup];
									$Failed]];
									
Aut[G_?GroupoidQ,opts___?OptionQ]:=AutomorphismGroup[G,opts];
(*
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Inner Automorphisms
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)

Options[InnerAutomorphism]={FunctionForm->Rules};

Options[InnerAutomorphismPrivate]={FormatFunction->Conjugation};

InnerAutomorphism[G_?GroupoidQ, g_, opts___?OptionQ] :=
Module[{ff=FormatFunction/.Flatten[{opts, Options[InnerAutomorphismPrivate]}],
		funform=FunctionForm/.Flatten[{opts, Options[InnerAutomorphism]}],
		f,Sd=Sort[Elements[G]]},
    If[InvertibleQ[G, g],Which[funform===Rules,
		f=Map[Rule[#[[1]],#[[2]]]&,Transpose[{Sd,
			      Map[(Operation[G][Operation[G][GroupInverse[G, g],
			                                     #],g])&,Sd]}]],
		True,f=(Operation[G][Operation[G][GroupInverse[G, g],#],g])&];
		FormMorphoid[f,G,G,FormatFunction->ff,ConjugatingElement->g],
		Message[InnerAutomorphism::noinv, g];$Failed]]

ConjugationComposition[f_?MorphoidQ,g_?MorphoidQ,cosets_,opts___?OptionQ]:=
			Module[{cf,cg,interm,ccomp,	op=Operation[f[[2]]]},
						cf=ConjugatingElement/.Options[f];
						cg=ConjugatingElement/.Options[g];
						interm=op[cg,cf];
						ccomp=First[First[Select[cosets,MemberQ[#,interm]&]]];
						MorphoidComposition[f,g,FormatFunction->Conjugation,
																								ConjugatingElement->ccomp]]

ConjugationComposition[f_?MorphoidQ,g_?MorphoidQ,{{elem_}...},opts___?OptionQ]:=
			Module[{cf,cg,interm,ccomp,	op=Operation[f[[2]]]},
						cf=ConjugatingElement/.Options[f];
						cg=ConjugatingElement/.Options[g];
						ccomp=op[cg,cf];
						MorphoidComposition[f,g,FormatFunction->Conjugation,
																								ConjugatingElement->ccomp]]

InnerAutomorphismGroup[G_?GroupoidQ]:=
	If[Not[GroupQ[G]],Message[InnerAutomorphismGroup::nogroup, G];$Failed,
	Module[{center=GroupCenter[G],cosets},
	cosets=LeftCosets[G,center];
	(reps=Map[First,LeftCosets[G,center]])//
		Map[InnerAutomorphism[G,#,FunctionForm->Rules,
														    FormatFunction->Conjugation]&,#]&//
		FormGroupoid[#,ConjugationComposition[#1,#2,cosets, FormatFunction->Conjugation]&,
			"*",
		             GroupoidName->"Inn["<>GroupoidName[G]<>"]",
		             GroupoidDescription->"Inner automorphism group of "<>GroupoidName[G],
		             IsAGroup->True,
		             KeyForm->OutputForm, 
		             
		             WideElements->True,
		             FormatElements -> True,
		             OperatorSymbol->""]&]]

Inn[G_?GroupoidQ] := InnerAutomorphismGroup[G]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Comparison of Morphoids
:[font = input; initialization; preserveAspect; endGroup]
*)
SameMorphFunctionQ[f_?MorphoidQ,g_?MorphoidQ]:=
	Module[{},
	    If[(Sort[f[[2,1]]]===Sort[g[[2,1]]]),
	    Fold[(#1&&(f[#2]===g[#2]))&,
	             f[f[[2,1,1]]]===g[f[[2,1,1]]],
	             Rest[f[[2,1]]]   ],
	    False,False]]; (* internal *)

EqualMorphoidQ[f_?MorphoidQ, g_?MorphoidQ]:=
	Module[{},(Sort[f[[2,1]]]===Sort[g[[2,1]]])&&
	          (Sort[f[[3,1]]]===Sort[g[[3,1]]])&&
	          Head[f[[2,1]]]===Head[g[[2,1]]]&&
	          Head[f[[3,1]]]===Head[g[[3,1]]]&&
	          SameMorphFunctionQ[f,g]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
PreservesQ
:[font = input; initialization; preserveAspect; endGroup]
*)

Options[PreservesQ]={Mode -> Computational,
                    Structure :> DefaultStructure};

PreservesQ[rules:{_Rule..},{S1_List,op1_}, {S2_List,op2_}, {a_, b_}] := 
	PreservesGroupQ[rules,{op1,op2},{a,b}]

PreservesQ[f_Function,{S1_List,op1_}, {S2_List,op2_}, {a_, b_}] := 
	PreservesGroupQ[f,{op1,op2},{a,b},S1,S2]

PreservesQ[f_Symbol,{S1_List,op1_}, {S2_List,op2_}, {a_, b_}] := 
	PreservesGroupQ[f,{op1,op2},{a,b},S1,S2]

PreservesQ[rules:{_Rule..},{S1_List,op1_,op3_},{S2_List,op2_,op4_},{a_, b_}] := 
	PreservesGroupQ[rules,{op1,op2},{a,b}] &&
	PreservesGroupQ[rules,{op3,op4},{a,b}]
	
PreservesQ[f_Function,{S1_List,op1_,op3_},{S2_List,op2_,op4_},{a_, b_}] := 
	PreservesGroupQ[f,{op1,op2},{a,b},S1,S2] &&
	PreservesGroupQ[f,{op3,op4},{a,b},S1,S2]

PreservesQ[f_Symbol,{S1_List,op1_,op3_},{S2_List,op2_,op4_},{a_, b_}] := 
	PreservesGroupQ[f,{op1,op2},{a,b},S1,S2] &&
	PreservesGroupQ[f,{op3,op4},{a,b},S1,S2]
	
PreservesQ[f_?MorphoidQ, {a_, b_},opts___?OptionQ] := Module[{
		structure,mymode,p, sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
		structure=f[[4]];
	mymode = Mode/.Flatten[{opts, Options[PreservesQ]}];
	p= Switch[structure,
	 	 	Group,PreservesQ[First[f],{f[[2,1]],f[[2,2]]},{f[[3,1]],f[[3,2]]},	{a,b}],
			Ring,PreservesQ[First[f],{f[[2,1]],f[[2,2]],f[[2,3]]},{f[[3,1]],f[[3,2]],f[[3,3]]},	
			{a,b}]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Morphisms",PreservesQ,mymode,
		p, {Null}, 
		{f,{a,b},opts},{Null},{Null},sc]
]
		
Options[PreservesQVisual]={DisplayFunction -> $DisplayFunction,
	nameToUse -> ""};

PreservesQVisual[rules_,{op1_,op1sym_,nm1_},{op2_,op2sym_,nm2_},
	{a_,b_}, opts___?OptionQ] := Module[{column1, column2,arrows,rects,labels,
		color2 = RGBColor[1,0,1],color1 = RGBColor[0,1,0],
		df = DisplayFunction/.Flatten[{opts, Options[PreservesQVisual]}],
		name = nameToUse/.Flatten[{opts, Options[PreservesQVisual]}]},
	column1 = {Text[ToString[op1[a,b]//InputForm], {1,1}],
		Text["a"<>op1sym<>"b", {1,1.8}], Text[ToString[a//InputForm],{-1,5}],
		Text["a",{-1,5.8}],Text[ToString[b//InputForm],{2,7}],
		Text["b",{2,7.8}],Text[nm1,{1,9}]};
	column2 = {Text["f(a"<>op1sym<>"b)", {8,.2}],
		Text[ToString[((op1[a,b])/.rules)//InputForm], {8,1}],
		Text[ToString[op2[(a/.rules),(b/.rules)]//InputForm], {8,1.8}],
		Text["f(a)"<>op2sym<>"f(b)", {8,2.6}], 
		Text[ToString[(a/.rules)//InputForm],{7,5}],
		Text["f(a)",{7,5.8}],Text[ToString[(b/.rules)//InputForm],{10,7}],
		Text["f(b)",{10,7.8}],Text[nm2,{8,9}]};
	arrows = {color2,Arrow[{3.5,7}, {8.5,7}],Arrow[{0.5,5}, {5.5,5}],
		Arrow[{7,4.4}, {8,3.1}],Arrow[{10,6.4}, {8,3.1}],
		color1,Arrow[{2.5,1}, {6.5,1}],Arrow[{-1,4.5}, {1,2.5}],
		Arrow[{2,6.5}, {1,2.5}]};
	rects = {RGBColor[1,.72,1],Rectangle[{6.6,1.3},{9.4,3.0}],
		RGBColor[.54,1,0],Rectangle[{6.6,-.2},{9.4,1.3}],
		color2,Rectangle[{8.7, 6.6}, {11.3, 7.4}],
		Rectangle[{5.7,4.6},{8.3,5.4}],Rectangle[{6.7,1.4},{9.3, 2.2}],
		color1, Rectangle[{.7, 6.6}, {3.3, 7.4}],
		Rectangle[{-2.3,4.6},{0.3,5.4}],Rectangle[{-0.3,0.6},{2.3,1.4}],
		Rectangle[{6.7,.6},{9.3,1.4}]};
	labels = {color2,Text["f",{4.5,7.25}],Text["f",{4.5,5.25}],
		color1,Text["f",{4.5,1.25}],RGBColor[0,0,0],Text[op1sym,{1.0,3.9}],
		Text[op2sym,{8.0,3.9}]};
	Show[Graphics[{{RGBColor[1,0,0],AbsoluteThickness[2],
		Line[{{-0.3,8.6},{2.3,8.6}}],Line[{{6.7,8.6},{9.3,8.6}}]},
		rects,arrows,labels,column1,column2, Text[name,{4.4,-0.6},{0,0}]}],PlotRange -> All,
		DisplayFunction -> df]
]

PreservesQVisual[f_?MorphoidQ,{a_,b_},opts___?OptionQ] := Module[{structure,
		showopts = FilterOptions[Graphics,opts], g, S1 = f[[2]],S2=f[[3]], names,
		df = DisplayFunction/.Flatten[{opts, Options[PreservesQVisual]}],gr1,gr2,gr},
	g = If[f[[5]]=!=Rule,ToRules[f],f];
	structure = g[[4]];
	gr = Switch[structure, Group,
		PreservesQVisual[First[g],{Operation[S1],OperatorSymbol[S1],
			AbstractAlgebra`Core`Private`StructureName[S1]},{Operation[S2],OperatorSymbol[S2],AbstractAlgebra`Core`Private`StructureName[S2]},
			{a,b},DisplayFunction -> Identity,opts],
		Ring, gr1 = PreservesQVisual[First[g],{Addition[S1],PlusSymbol[S1],
			AbstractAlgebra`Core`Private`StructureName[S1]},{Addition[S2],PlusSymbol[S2],AbstractAlgebra`Core`Private`StructureName[S2]},
			{a,b},DisplayFunction -> Identity,nameToUse -> "Addition",opts];
			gr2 = PreservesQVisual[First[g],{Multiplication[S1],TimesSymbol[S1],
			AbstractAlgebra`Core`Private`StructureName[S1]},{Multiplication[S2],TimesSymbol[S2],AbstractAlgebra`Core`Private`StructureName[S2]},
			{a,b},DisplayFunction -> Identity,nameToUse -> "Multiplication",opts];
			Show[GraphicsArray[{gr1,gr2}],DisplayFunction -> Identity]];
	Show[gr,showopts,DisplayFunction-> df]
]

PreservesGroupQ[rules:{_Rule..}, {op1_,op2_},{a_,b_},dom___List] := 
	((op1[a,b])/.rules) === op2[a/.rules,b/.rules]
	
PreservesGroupQ[f_Function, {op1_,op2_},{a_,b_},dom1_,dom2___] := 
	PreservesGroupQ[ToRules[f,dom1,dom2],{op1,op2},{a,b}]
	
PreservesGroupQ[f_Symbol, {op1_,op2_},{a_,b_},dom1_,dom2___] := 
	PreservesGroupQ[ToRules[f,dom1,dom2],{op1,op2},{a,b}]
	
(* Textual mode? *)
(*
;[s]
4:0,0;43,1;44,0;5044,1;5064,-1;
2:2,12,10,Courier,1,12,0,0,0;2,12,10,Courier,1,12,0,0,65535;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Formation Shortcuts
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[ZMap]={Structure:>DefaultStructure, FormatFunction -> Rule};

ZMap[m_,n_,opts___?OptionQ] := 
	Module[{str=Structure/.Flatten[{{opts},{Structure:>DefaultStructure}}],
		ff = FormatFunction/.Flatten[{opts, Options[ZMap]}]},
	FormMorphoid[Mod[#, n]&,
				Z[m,Structure->str],
				Z[n,Structure->str], 
				FormatFunction -> ff, 
				GeneratingRule -> {Rule[1,1]}]]

ZMap[m_,n_, Rule[a_,b_], opts___?OptionQ] := 
	If[GCD[m,a]==1,
Module[{str=Structure/.{opts}/.{Structure:>DefaultStructure}, powers,
	exp, ff = FormatFunction/.Flatten[{opts, Options[ZMap]}]},
	powers = Table[{k,ElementToPower[Z[m,Structure->Group], a, k]}, {k, 1, m}];
	exp[y_] := First[First[Select[powers, #[[2]]==y&]]]; 
	FormMorphoid[Mod[b*exp[#],n]&, Z[m,Structure->str],Z[n,Structure->str], 
		FormatFunction -> ff, 
		GeneratingRule -> {Rule[a,b]}]],
		Message[ZMap::relpr, m, n, a, b]]

Unprotect[ToRules];

Options[ToRules] = {FormatFunction -> False};

ToRules[f_Function, A_List, B_List] := 
	Module[{rules = Map[(# -> f[#])&, A], im},
		If[SubsetQ[im = (Transpose[Apply[List, rules, 1]]//Last), B], 
			rules, 
			Message[MemberQ::elmnts, "the image elements "<>ToString[im], B];
			$Failed]]

ToRules[f_Function, A_List] := Map[(#->f[#])&, A]

ToRules[f_Function, A_?StructuredSetQ] := ToRules[f, Elements[A]]

ToRules[morphoid[f_Function, dom_, cod_,
	str_, Function, opts___?OptionQ],tropts___?OptionQ] :=
	FormMorphoid[ToRules[f, Elements[dom]], dom, cod, 
		FormatFunction :> (FormatFunction/.Flatten[{tropts, Options[ToRules]}]), opts]

ToRules[morphoid[rules:{_Rule..}, dom_, cod_,
	str_, Rule, opts___?OptionQ],tropts___?OptionQ] :=
	FormMorphoid[rules, dom, cod, 
		FormatFunction :> (FormatFunction/.Flatten[{tropts, Options[ToRules]}]),
		 opts]
		
Protect[ToRules];

ToFunction[rules:{_Rule..}, f_] := 
	(Map[(f[#[[1]]] = #[[2]])&, Apply[List,rules,1]];f)

ToFunction[rules:{_Rule..}] := Module[{f = Unique["ff"]},
	Map[(f[#[[1]]] = #[[2]])&, Apply[List,rules,1]];f
]

ToFunction[morphoid[rules:{_Rule..}, dom_, cod_,
		str_, Rule, opts___?OptionQ]] :=
	FormMorphoid[ToFunction[rules], dom, cod, GeneratingSet -> {Null}]

ToFunction[morphoid[rules:{_Rule..}, dom_, cod_,
		str_, Rule, opts___?OptionQ], g_] :=
	FormMorphoid[ToFunction[rules, g], dom, cod, GeneratingSet -> {Null}]
		
Options[MorphoidComposition]={Mode -> Computational, 
	FormatFunction->False, ConjugatingElement->Null};

MorphoidComposition[g_?MorphoidQ,
                    f_?MorphoidQ,opts___?OptionQ]:=
   Module[{mymode = Mode/.{opts}/.Options[MorphoidComposition],ng,typesok,imdomok,
								ce= ConjugatingElement/.Flatten[{opts, Options[MorphoidComposition]}],
   		   ff = FormatFunction/.{opts}/.Options[MorphoidComposition],
   		   (* mn = MorphoidName/.{opts}/.Options[FormMorphoid],*)
           fr=If[f[[5]]===Function,ToRules[f],f],
           gr=If[g[[5]]===Function,ToRules[g],g],
           cr},
           If[(imdomok = Sort[fr[[3,1]]]===Sort[gr[[2,1]]])&&
                 (typesok = fr[[4]]===gr[[4]]),
              cr=Map[(#[[1]]->(#[[2]]/.First[gr]))&,First[fr]];
              FormMorphoid[cr,fr[[2]],gr[[3]],
              				FormatFunction->If[(ng=NewGenerator[g,f]) === Null,ff,
              					Rule], GeneratingRule -> {ng},ConjugatingElement->ce],
             If[Not[imdomok], Message[MorphoidComposition::notdef,
             	AbstractAlgebra`Core`Private`StructureName[fr[[3]]],AbstractAlgebra`Core`Private`StructureName[gr[[2]]]]];
             If[Not[typesok], Message[MorphoidComposition::notdef2,
             	fr[[4]],gr[[4]]]]; $Failed]]
  
NewGenerator[g_?MorphoidQ, f_?MorphoidQ] := Module[{fr, gr},
		fr = First[GeneratingRule/.MorphoidOptions[f]];
	gr = First[GeneratingRule/.MorphoidOptions[g]]; (*Print[{fr, gr, First[g]}];*)
	If[fr === Null || gr === Null, Null,
		If[Head[First[g]]===List && Head[First[f]]===List, 
		Rule[First[fr],Last[fr]/.First[g]],
	Rule[First[fr],First[g][Last[fr]]]]]
	] (* private *)

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Other built-in Morphoids
:[font = input; initialization; preserveAspect; endGroup]
*)
InducedCanonical[f_?MorphoidQ] := Module[{K, Q, st, rules, GQ, els},
	K = Kernel[f];
	st = MorphoidStructure[f];
	Q = If[st === Group, QuotientGroup[Domain[f], K, Form -> Cosets],
		QuotientRing[Domain[f], K, Form -> Cosets]];
	GQ = If[st === Group, Q, AGroupoid[Q]];
	els = Elements[Domain[f]];
	rules = Table[Rule[els[[k]], ElementToCoset[GQ, els[[k]]]], {k,Length[els]}];
	FormMorphoid[rules, Domain[f], Q]]
	
InducedIsomorphism[f_?MorphoidQ] := Module[{K, Q, st, rules},
	K = Kernel[f];
	st = MorphoidStructure[f];
	Q = If[st === Group, QuotientGroup[Domain[f], K, Form -> Cosets],
		QuotientRing[Domain[f], K, Form -> Cosets]];
	rules = Map[Rule[#, f[CosetToList[Q,#]//First]]&, Elements[Q]];
	FormMorphoid[rules, Q, Image[f]]]
	
Sgn[G_?GroupoidQ] := 
	FormMorphoid[AbstractAlgebra`Permutations`Parity, G, 
	AbstractAlgebra`Groupoids`IntegerUnits]

(* DetHomomorphism[n_, k_] := FormMorphoid[Det, GL[n, k], U[k]] 

need to change/extend def. of FormMorphoid for this to work

Also consider Projection[ListOfStructures_List, coordinate_Integer] :=
FormMorphoid[f, ListOfStructures, ListOfStructures[[coordinate]]]*)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
MorphismQ
:[font = input; initialization; preserveAspect; endGroup]
*)
goodSamplePairsQ[in_, n_] := SubsetQ[Union[Flatten[in]], Range[n]]

Options[ProbableMorphismQ]={SampleSize->5, SamplePairs->False,
	PrintMessage->True};
	
ProbableMorphismQ[f_?MorphoidQ,opts___?OptionQ]:=
		Module[{pm,ss,nrr,sample,dom=f[[2,1]],sp,
										dl=Length[f[[2,1]]]},
			If[(PrintMessage/.{opts})/.Options[ProbableMorphismQ],
				Message[ProbableMorphismQ::warning]];
			ss=(SampleSize/.{opts})/.Options[ProbableMorphismQ];
			If[Not[IntegerQ[ss]] || (ss<1),ss=5];
			sp=(SamplePairs/.{opts})/.Options[ProbableMorphismQ];
			If[Head[sp]===List && goodSamplePairsQ[sp, dl],
				sample = sp,
				If[sp===Default && dl > 4,
					sample={{1,2},{2,3},{3,5},{4,1},{5,4}},
					sample=Table[{Random[Integer,{1,dl}],Random[Integer,{1,dl}]},{ss}]]];
			Fold[And[#1,PreservesQ[f,{dom[[#2[[1]]]],dom[[#2[[2]]]]}]]&,
									 PreservesQ[f,{dom[[sample[[1,1]]]],dom[[sample[[1,2]]]]}],
									 Rest[sample]]];
		
Options[MorphismQ]={Mode -> Computational,
                    Structure :> DefaultStructure};

cay[G_?GroupoidQ,opts___?OptionQ]:=
	AbstractAlgebra`Core`Private`makeTable[G, Elements[G],opts];

TempGroupoid[list_List, op_] :=
	AbstractAlgebra`Core`Private`groupoid[list, op, {{},{},{},{},{}}];
	
TAGroupoid[R_?RingoidQ] :=
	FormGroupoid[R[[1]], R[[2]], GroupoidName -> 
		"Add("<>RingoidName[R]<>")", 
		KeyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[KeyForm[R]],
				InputForm, KeyForm[R]],
		CayleyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[CayleyForm[R]],
				OutputForm, CayleyForm[R]], 
		AbstractAlgebra`Core`Private`ExtraInformation -> {{},{},{},{},{"AG" -> True}}]
	
TMGroupoid[R_?RingoidQ] :=
	FormGroupoid[R[[1]], R[[3]], GroupoidName -> 
		"Mult("<>RingoidName[R]<>")", 
		KeyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[KeyForm[R]],
				InputForm, KeyForm[R]],
		CayleyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[CayleyForm[R]],
				OutputForm, CayleyForm[R]], 
		AbstractAlgebra`Core`Private`ExtraInformation -> {{},{},{},{},{"MG" -> True}}]
		
MorphismQ[rulesorf_, G1_?GroupoidQ, G2_?GroupoidQ] := 
MorphismQ[rulesorf, G1, G2] = 
	Module[{f = If[(Head[rulesorf]===Function)||(Head[rulesorf]===Symbol),
			rulesorf[#]&, (#/.rulesorf)&], S1 = Elements[G1], op2 = Operation[G2]},
	(Map[f[#]&,cay[G1],{2}])===
     (cay[TempGroupoid[Map[f[#]&,S1],op2]])
]

MorphismQ[rulesorf_, R1_?RingoidQ, R2_?RingoidQ] :=
MorphismQ[rulesorf, R1, R2] =
	Module[{f = If[(Head[rulesorf]===Function)||(Head[rulesorf]===Symbol),
		rulesorf[#]&,(#/.rulesorf)&], S1 = Elements[R1], S3},
		S3 = Map[f[#]&, S1];
	(Map[f[#]&,cay[TempGroupoid[S1, Addition[R1]]],{2}]===
     cay[TempGroupoid[S3,Addition[R2]]])&&
 (Map[f[#]&,cay[TempGroupoid[S1,Multiplication[R1]]],{2}]===
     cay[TempGroupoid[S3, Multiplication[R2]]])
 
]

MorphismQ[f_?MorphoidQ, opts___?OptionQ] := Module[{mymode, 
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts],morph},
	mymode = Mode/.Flatten[{opts, Options[MorphismQ]}];
	morph = Switch[f[[4]],
		Group, MorphismQ[First[f], f[[2]], f[[3]]],
		Ring, MorphismQ[First[f], f[[2]], f[[3]]]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Morphisms",
	           MorphismQ, mymode, morph,
	           {Null},
	           {f, opts},
	           {Null},
	           {Null},
	           sc]
    ]
    
Options[MorphismQVisual]=
 {DisplayFunction -> $DisplayFunction,TextFormat->InputForm,prologue->True};

MorphismQVisual[f_?MorphoidQ,opts___?OptionQ]  := 
Switch[f[[4]],
 Group,
  Module[{els,
  								rects,
  								wideQ,
  								coloredRects,
  								gText,
  								preserves,
  								gLines,
  								G,
  								color,
  								txtform=TextFormat/.{opts}/.Options[MorphismQVisual],
  								showopts = FilterOptions[Graphics,opts],
  								dp =prologue/.Flatten[{opts, Options[MorphismQVisual]}],
  								df = DisplayFunction/.Flatten[{opts, Options[MorphismQVisual]}]},
	 If[dp,
							Print["The table entry corresponding to the computation a*b in the
domain of the morphoid is colored if and only if the pair
 {a,b} is preserved by the morphoid; i.e., f(a*b) = f(a)*f(b)"]];
		G = f[[2]];
		wideQ=AbstractAlgebra`Core`Private`WideElementsQ[f[[2]]];
	 If[wideQ,txtform=OutputForm];
		els = Elements[G];
		{gLines, gText, rects} = 
			AbstractAlgebra`Core`Private`basicCayley[G,els,
																																	CayleyForm->txtform,
																																	WideElements->wideQ];
		preserves=Position[MapThread[SameQ,{Map[f[#]&,cay[G],{2}],
	                        cay[TempGroupoid[Map[f[#]&,els],f[[3,2]]]]},2],True];
		color = Map[rects[[Apply[Sequence,#]]]&,preserves];
	coloredRects = Prepend[Join[Complement[Flatten[rects],color],
		{Prepend[color,RGBColor[1,1,0]]}],RGBColor[1,1,1]];
	If[wideQ,
		AbstractAlgebra`Core`Private`PrintCayleyKey[els,GroupoidName[G],G,KeyForm[G]]];
	Show[{Graphics[coloredRects],gLines, gText},showopts,
		DisplayFunction -> df(*,PlotRange -> All*)]],
 Ring,
 Module[{ag,mg},
 Print["The table entry corresponding to the sum a+b (resp. product a*b) in the domain
of the morphoid is colored if and only if addition (resp. multiplication) of the
 pair {a,b} is preserved by the morphoid; i.e., f(a+b) = f(a)+f(b) (resp.  f(a*b) = f(a)*f(b)) "];
 ag=MorphismQVisual[FormMorphoid[f[[1]],
                          TAGroupoid[f[[2]]],
                          TAGroupoid[f[[3]]]],
                 DisplayFunction->Identity,opts,prologue->False];
 mg=MorphismQVisual[FormMorphoid[f[[1]],
 																								TMGroupoid[f[[2]]],
 																								TMGroupoid[f[[3]]]],
 															DisplayFunction->Identity,opts,prologue->False];
 	Show[GraphicsArray[{ag,mg}]]]];

HomomorphismQ[f_?MorphoidQ,opts___?OptionQ]:=MorphismQ[f,opts];

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Kernel
:[font = input; initialization; preserveAspect; endGroup]
*)
Kernel[f_?MorphoidQ, opts___?OptionQ] := Module[{structure=f[[4]],
	mymode,g,K,idtest,idname, els},
	{idtest,idname}=Switch[structure,Group,{HasIdentityQ,GroupIdentity},
	    Ring, {AbstractAlgebra`RingProperties`HasZeroQ, 
	    AbstractAlgebra`RingProperties`Zero}];
	mymode = (Mode/.{opts})/.Options[Kernel];
	els = Elements[Domain[f]];
	g = If[f[[5]]===Rule,f,ToRules[f]];
	If[Not[idtest[g[[3]]]], Message[Kernel::noid,AbstractAlgebra`Core`Private`StructureName[g[[3]]]];$Failed,
		K=Select[Elements[g[[2]]],((#/.g[[1]])==idname[g[[3]]])&];
		If[mymode===Visual, KernelVisual[f, K]];
		Switch[structure, Group,
			If[ProperSubsetQ[K,els],
				FormGroupoid[K,f[[2,2]],OperatorSymbol[f[[2]]], 
					GroupoidName->"Ker("<>ToString[f]<>")",
					AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[f[[2]]]],
				Domain[f]], 
			Ring, 
			If[ProperSubsetQ[K,els],
				FormRingoid[K,f[[2,2]],f[[2,3]], RingoidName->"Ker("<>ToString[f]<>")",
					AbstractAlgebra`Core`Private`GatherSubRingoidOptions[f[[2]]]],
				Domain[f]]]]
]

KernelVisual[f_?MorphoidQ, k_] := 
	VisualizeMorphoid[f, ColorDomain -> 
		Table[{Magenta, k[[i]]},{i, Length[k]}]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Image
:[font = input; initialization; preserveAspect; endGroup]
*)
Image[f_?MorphoidQ,opts___?OptionQ]:=
	Module[{structure=f[[4]],mymod,dom=Elements[f[[2]]],im,
		els = Elements[Codomain[f]]},
	im=If[f[[5]]===Rule,
		Transpose[Apply[List,First[f],1]]//Last//UnionNoSort,
		Map[First[f],dom]//UnionNoSort];
		Switch[structure, Group,
			If[ProperSubsetQ[im,els],
				FormGroupoid[im,f[[3,2]],OperatorSymbol[f[[3]]], 
					GroupoidName->"Im("<>ToString[f]<>")",
					AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[f[[3]]]],
				Codomain[f]], 
			Ring, 
			If[ProperSubsetQ[im,els],
				FormRingoid[im,f[[3,2]],f[[3,3]], RingoidName->"Im("<>ToString[f]<>")",
					AbstractAlgebra`Core`Private`GatherSubRingoidOptions[f[[3]]]],
				Codomain[f]]]]

Image[f_?MorphoidQ,subgroup_List,opts___?OptionQ]:=
Module[{structure=f[[4]],mymode,dom=subgroup,im,els = Elements[Codomain[f]]},
 im=If[f[[5]]===Rule,
    Transpose[Apply[List,Select[First[f],MemberQ[dom,First[#]]&],1]]//Last//UnionNoSort,
    Map[First[f],dom]//UnionNoSort];
  Switch[structure,Group,
  	If[ProperSubsetQ[im, els],
				FormGroupoid[im,f[[3,2]],OperatorSymbol[f[[3]]], 
					GroupoidName->"Im("<>ToString[f]<>")",
					AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[f[[3]]]],
				Codomain[f]],
            Ring,If[ProperSubsetQ[im,els],
				FormRingoid[im,f[[3,2]],f[[3,3]], RingoidName->"Im("<>ToString[f]<>")",
					AbstractAlgebra`Core`Private`GatherSubRingoidOptions[f[[3]]]],
				Codomain[f]]]];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
InverseImage
:[font = input; initialization; preserveAspect; endGroup]
*)
InverseImageOfEl[f_?MorphoidQ, el_]:=
	If[ElementQ[el, f[[3]]],
		Select[f[[2,1]],MemberQ[{el},f[#]]&],
		Message[MemberQ::elmnt, el, AbstractAlgebra`Core`Private`StructureName[f[[3]]]]; {}]
		
InverseImage[f_?MorphoidQ,Img_]:= 
	If[ElementQ[Img, f[[3]]], InverseImageOfEl[f, Img],
		If[Head[Img]===List,
			If[Or@@Map[ElementQ[#, f[[3]]]&, Img],
				Map[InverseImageOfEl[f, #]&, Img]//Flatten[#,1]&//UnionNoSort,
				Message[MemberQ::elsbst, Img, f[[3]]]; {}],
			Message[MemberQ::elmnt, Img, f[[3]]]; {}]]

InverseImage[f_?MorphoidQ,Img_, Mode -> Visual]:= 
	InverseImageVisual[f, Img]

InverseImageVisual[f_?MorphoidQ, Img_] := Module[{els},
	els = InverseImage[f, Img];
	If[els =!= $Failed,
		VisualizeMorphoid[f, ColorCodomain -> 
			Table[{Magenta, els[[i]]},{i, Length[els]}]]];
	els]
	
Fiber[args___] := InverseImage[args]

Options[InverseImages] = {Mode -> Computational, WithImages -> False};

InverseImages[f_?MorphoidQ, opts___?OptionQ] := 
		Module[{imq = WithImages/.Flatten[{opts, Options[InverseImages]}], preimages,
			mymode},
			mymode = Mode/.Flatten[{opts, Options[InverseImages]}];
			preimages = Map[{InverseImage[f,#],#}&, f[[3,1]]];
			If[mymode===Visual, InverseImagesVisual[f]];
			If[imq, preimages, preimages//Transpose//First]]
	
InverseImagesVisual[f_?MorphoidQ] := Module[{els,n},
	els = Elements[Image[f]];
	n = Length[els];
	VisualizeMorphoid[f, ColorCodomain -> 
			Table[{Hue[i/n], els[[i]]},{i, n}]]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
SurjectiveQ
:[font = input; initialization; preserveAspect; endGroup]
*)
SurjectiveQ[f_?MorphoidQ]:=(Sort[First[Image[f]]]===Sort[f[[3,1]]]);

OntoQ[args___] := SurjectiveQ[args];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
InjectiveQ
:[font = input; initialization; preserveAspect; endGroup]
*)
InjectiveQ[f_?MorphoidQ]:=(Length[f[[2,1]]]==Length[First[Image[f]]])

OneToOneQ[args___] := InjectiveQ[args];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
IsomorphismQ
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[IsomorphismQ] = {Cautious->False};

IsomorphismQ[g_?MorphoidQ,opts___?OptionQ] := 
	Module[{S,f=First[g],G=g[[2]],H=g[[3]],op2,iso=False,caut,gfun},
	caut=(Cautious/.{opts})/.Options[IsomorphismQ];
	S = Elements[G];
	op2 = Operation[H];
	gfun=If[g[[5]]===Rule,ToFunction[f],f];
	If[Length[S]== Length[Elements[H]],
		(*passes first test of being the same size *)
		If[Length[S] == Length[Union[Map[gfun,S]]],
			(* passes being onto *)
			If[(*Small case *) Length[S]<7 || caut, If[MorphismQ[g],
				iso = True, Message[IsomorphismQ::notHom]; $Failed],
				(*Large case*) If[ProbableMorphismQ[g]&&If[caut,MorphismQ[g],True],
				             iso = True, Message[IsomorphismQ::notHom]; $Failed]],
		Message[Morphoid::notonto]; $Failed],
	Message[Morphoid::dff,G,H]];
	iso
]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
VisualizingMorphoid
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Options[VisualizeMorphoid] = {ColorDomain -> {}, ColorCodomain -> {}};

VisualizeMorphoid[f_?MorphoidQ, opts___?OptionQ] := 
Module[{sys=f[[4]], dom, cod, rules, n1, n2, domrls, codrls, dx, row1, row2, 
	lines, eps = .3, elsd,elsc,
	pts1, pts2, t1, t2, fdom, fcod, showopts = FilterOptions[Graphics,opts],
	kd = ColorDomain/.Flatten[{opts, Options[VisualizeMorphoid]}],
	kc = ColorCodomain/.Flatten[{opts, Options[VisualizeMorphoid]}]},
	rules  = If[MorphoidType[f] === Rule, f[[1]],
		ToRules[f[[1]], Elements[Domain[f]]]];
	{pts1, pts2} = Transpose[Apply[List,rules,1]];
	{fdom, fcod} = {Domain[f], Codomain[f]};
	elsc = Elements[Codomain[f]];
	elsd = Elements[Domain[f]];
	If[kd===Automatic, kd = Table[{Hue[k/Length[elsd]],elsd[[k]]},
		{k,Length[elsd]}]];
	If[kc===Automatic, kc = Table[{Hue[k/Length[elsc]],elsc[[k]]},
		{k,Length[elsc]}]];
	t1 = textRules[fdom, "g", True];
	t2 = textRules[fcod, "h", Not[fdom === fcod]];
	{dom, cod} = Map[First, {t1, t2}, {2}];
	{pts1, pts2} = {pts1/. Map[Reverse, t1], pts2/. Map[Reverse, t2]};
	{n1, n2} = Map[Length, {dom, cod}];
	dx = n1/n2;
	domrls = Table[Rule[dom[[i]], {i-1, 4-eps}], {i, n1}];
	codrls = Table[Rule[cod[[i]], {(i-1)dx, eps}], {i, n2}];
	row1 = Prepend[Table[Text[dom[[i]], {i-1, 4}], {i, n1}],
		Text[AbstractAlgebra`Core`Private`StructureName[fdom], {(n1-1)/2, 4.5},{0,0}]];
	row2 = Prepend[Table[Text[cod[[i]], {(i-1)dx, 0}], {i, n2}],
		Text[AbstractAlgebra`Core`Private`StructureName[fcod], {(n1-1)/2, -.5},{0,0}]];
	{kd, kc} = Map[Cases[#, {RGBColor[_,_,_], _} | {Hue[_],_}]&, {kd, kc}];
	kd = Select[kd, ElementQ[Last[#], fdom]&];
	kc = Select[kc, ElementQ[Last[#], fcod]&];
	kd = If[kd =!= {}, kd /. Map[Reverse, t1]/. domrls, kd];
	kc = If[kc =!= {}, kc /. Map[Reverse, t2]/. codrls, kc];
	{pts1, pts2} = {pts1 /. domrls, pts2 /. codrls};
	kd = Join[Map[Rule[{RGBColor[0,0,1], Arrow[x_, Last[#]]}, {First[#],Arrow[x,Last[#]]}]&, kc],
		Map[Rule[{RGBColor[0,0,1], Arrow[Last[#],x_]}, {First[#],Arrow[Last[#],x]}]&, kd]];
	lines = Map[{RGBColor[0,0,1], Arrow[#[[1]], #[[2]]]}&, Transpose[{pts1, pts2}], 1];
	lines = lines/.kd;
	Show[Graphics[{row1, row2, lines}], showopts, PlotRange -> {-1, 5}, 
		Background -> Antique]]

textRules[S_, lab_String, printkeyQ_] := Module[{fff, x, rules, Els = Elements[S]},
	If[AbstractAlgebra`Core`Private`WideElementsQ[S],
		fff[x_,{n_}] := lab<>ToString[n] -> x;
		If[printkeyQ, AbstractAlgebra`Core`Private`PrintCayleyKey[Els, 
			AbstractAlgebra`Core`Private`StructureName[S], S, KeyForm[S],lab]],
		fff[x_,{n_}] := ToString[KeyForm[S][x]] -> x];
	rules = MapIndexed[fff, Els]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 99. Wrap up Morphisms
:[font = input; initialization; preserveAspect]
*)
End[];

Protect[Aut];

EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
