(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`RingProperties` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`RingProperties *)

(* :Context: AbstractAlgebra`RingProperties` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Startup AbstractAlgebra`RingProperties
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`RingProperties`",
{"AbstractAlgebra`Core`", "AbstractAlgebra`Joint`", "Graphics`Graphics`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];

Off[AppendTo::rvalue];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
AdditiveGroupoid::usage = "AdditiveGroupoid[R] returns the additive
Groupoid of the ring R. A shortcut is AGroupoid.";

AGroupoid::usage = "AGroupoid[R] returns the additive Groupoid
associated with the Ringoid R.";

Annihilator::usage = "Annihilator[R, S] returns the annihilator of S in
R. This consists of all elements r in R such that r s = Zero[R] for all
s in S.";

CayleyTables::usage = "CayleyTables[R] returns the Cayley tables (in
double array form), for the additive and multiplicative Groupoids
associated with the Ringoid R. CayleyTables[R, Mode -> Visual] returns a
graphical view of these tables. See CayleyTable for a description of the
available options.";

Characteristic::usage = "Characteristic[R] returns the characteristic of
the structure R.";

ClosedDiffQ::usage= "ClosedDiffQ[R, S] returns True if S is closed with
respect to subtraction in the structure R, and False otherwise.";

ClosedPlusQ::usage = "ClosedPlusQ[R, S] returns True if S is closed with
respect to addition in the structure R, and False otherwise.";

ClosedTimesQ::usage = "ClosedTimesQ[R, S] returns True if S is closed
with respect to multiplication in the structure R, and False
otherwise.";

ComplexToPoint::usage = "ComplexToPoint[z] returns {Re[z], Im[z]} given
any complex number z.";

DistributiveQ::usage="DistributiveQ[R] returns True if the Multiplication 
is (two-sided) distributive over the Addition in the structure R, and
False otherwise.";

EisensteinsCriterionQ::usage = "EisensteinsCriterionQ[zpoly] returns True
if Eisenstein's Criterion indicates that the polynomial zpoly, with
coefficients from the integers, is irreducible, and False otherwise. The
Textual mode is available.";

FactorRing::usage = "FactorRing[R, S] is equivalent to QuotientRing; see
this for details.";

FieldQ::usage = "FieldQ[R] returns True if the Ringoid R is a field, and
False otherwise.";

GaussianIntegerQ::usage = "GaussianIntegerQ[z] returns True if the
complex number z is a Gaussian integer and false otherwise.";

HasNegativeQ::usage = "HasNegativeQ[R, r] returns True if r has a negative
in the structure R, and False otherwise.";

HasUnityQ::usage = "HasUnityQ[R] returns True if the structure R has
a unity, and False otherwise.";

HasZeroQ::usage = "HasZeroQ[R] returns True if the structure R has a
zero, and False otherwise.";

IdealQ::usage = "IdealQ[S, R] returns True if the set S is an ideal of
the structure R, and False otherwise.";

IdempotentQ::usage = "IdempotentQ[R, r] returns True if r is an
idempotent in the structure R, and False otherwise.";

Idempotents::usage = "Idempotents[R] returns all the idempotent elements
in the structure R.";

IntegerLatticeGrid::usage = "IntegerLatticeGrid[{a, b}, {c, d}, opts]
returns a ListPlot of an integer lattice with domain [a,b] and range
[c,d]. Any opts given are used by ListPlot.";

IntegralDomainQ::usage = "IntegralDomainQ[R] returns True if the
structure R is an integral domain, and False otherwise.";

InterpolatingPolynomial::usage="InterpolatingPolynomial[R,{{x,y},...}]
returns the interpolating polynomial of degree at most n-1 where n is
the number of pairs in {{x,y},...}. The x coordinates must all be
distinct and R should be a field, for example Z[p] for prime p. The
standard (built-in) usage still exists: InterpolatingPolynomial[data,
var] gives a polynomial in the variable var which provides an exact fit
to a list of data. The data can have the forms {{x1, f1}, {x2, f2}, ...}
or {f1, f2, ...}, where in the second case, the xi are taken to have
values 1, 2, .... The fi can be replaced by {fi, dfi, ddfi, ...},
specifying derivatives at the points xi.";

J::usage = "J is the symbol to represent an ideal in the quotient ring
Z[I]/<z> for a Gaussian integer z.";

LeftIdealQ::usage = "LeftIdealQ[S, R] returns True if the set S is a
left ideal of the structure R, and False otherwise.";

LeftDistributiveQ::usage="LeftDistributiveQ[R] returns True if the
Multiplication is left distributive over the Addition in the structure R,
and False otherwise.";

LowerDegreeOK::usage="LowerDegreeOK is an option for
RandomElement[RingExtension[PolyRing,...]] that controls whether random
polynomials must have the specified degree (LowerDegreeOK -> False, the
default) or may have a degree less than or equal to the specified degree
(LowerDegreeOK -> True).";

MaximalIdealQ::usage = "MaximalIdealQ[S, R] returns if the set S is a
maximal ideal in the structure R, and False otherwise.";

MGroupoid::usage = "MGroupoid[R] returns the multiplicative Groupoid
associated with the Ringoid R.";

ModpIrreducibilityQ::usage = "ModpIrreducibilityQ[zpoly] returns
True if the Mod p Irreducibility Test indicates that the polynomial zpoly, 
with coefficients from the integers, is irreducible, and False otherwise.
(This method tries the first 25 primes.)
The Textual mode is available. ModpIrreducibilityQ[p, zpoly] tests
the polynomial zpoly specifically with the prime p.";

Monic::usage="Monic is an option to RandomElement for Polynomial
Rings.";

MultipleOfElement::usage = "MultipleOfElement[R, r, n] returns the nth
multiple of the element r in the structure R. In other words, r + r +
... + r (n times) is returned. This is the additive version of
ElementToPower.";

MultiplicationTable::usage = "MultiplicationTable[R] returns the
multiplication table of the Ringoid R. MultiplicationTable[R, Mode ->
Visual] returns a graphical view of this table.";

MultiplicativeGroupoid::usage = "MultiplicativeGroupoid[R] returns the
multiplicative Groupoid of the ring R. A shortcut is MGroupoid.";

MultiplicativeInverse::usage = "MultiplicativeInverse[R, a] returns the
multiplicative inverse of a in the structure R, if it exists.";

NegationOf::usage = "NegationOf[R, r] returns the additive inverse of r
in the structure R, if it exists.";

NilpotentDegree::usage = "NilpotentDegree[R, r] returns 0 if the element
r is NOT nilpotent in the structure R; otherwise a positive integer n is
returned, which is the least positive integer such that r^n is the zero
element.";

NilpotentQ::usage = "NilpotentQ[R, r] returns True if r is a nilpotent
element in the structure R, and False otherwise.";

Nilpotents::usage = "Nilpotents[R] returns all the nilpotent elements in
the structure R.";

NonUnity::usage = "NonUnity is value for the SelectFrom option of
RandomElement";

NonZero::usage = "NonZero is value for the SelectFrom option of
RandomElement";

NonZeroMGroupoid::usage = "NonZeroMGroupoid[R] returns the Groupoid of
nonzero elements of R with the Multiplication from R. If R is a field,
this is the group of units.";

PrimeIdealQ::usage = "PrimeIdealQ[S, R] returns True if the set S can is
a prime ideal in the structure R, and False otherwise.";

PrincipalIdeal::usage = "PrincipalIdeal[R, r] returns the Ringoid <r> in
the Ringoid R. This is the principal ideal generated by r in R.";

ProbableRingQ::usage = "ProbableRingQ[R] returns True if R is probably a
ring (all properties are checked except associativity and distributivity
use the randomized versions), and False otherwise.";

QuotientRing::usage = "QuotientRing[R, S] returns the quotient ring
formed by the ring R and the ideal S. Options for this function are
Form and Representatives. Form can have the value Cosets
(default) which returns the elements in coset form g + NS or g NS where
NS is a symbol representing the Ideal (normal subgroup). Alternatively,
one can use Form -> Representatives and then only the representatives of
the cosets will be returned. The default list of representatives uses
the 'smallest' element in the coset and is indicated by Representatives
-> Canonical; if you wish to change this list, use Representatives ->
list, where list is a list of one element from each coset. This can be
used also if one has Form -> Cosets. By default, left cosets are used.
For a polynomial p
over the base ring R, QuotientRing[R, p] returns the Ringoid of
polynomials mod p, if R is a Ringoid with unity and the leading
coefficient of p is a unit of R. QuotientRing[Z[I], z] returns the
quotient ring Z[I]/<z> for a Gaussian integer z; this has a Visual mode.
WARNING: This function may use a lot of
memory if R is large (|R| > 5) and/or the degree of p is large (>3?).";

RandomDistributiveQ::usage="RandomDistributiveQ[R] returns True if
Multiplication is likely to be distributive over Addition in structure R
by checking 20 triples, and False otherwise. RandomDistributive[R, n]
checks n triples.";

RationalRootCandidates::usage = "RationalRootCandidates[poly] returns
a list of candidates for the Rational Root Theorem, given the polynomial
poly in the indeterminate var.";

RationalRootTheorem::usage = "RationalRootTheorem[poly] returns a list
of two lists, given a polynomial poly in the indeterminate var. The first
list consists of those rational candidates which are zeros for poly while
the second list consists of those rational candidates which are not zeros
for poly.";

RightDistributiveQ::usage="RightDistributiveQ[R] returns True if the
Multiplication is right distributive over the Addition in the structure R,
and False otherwise.";

RightIdealQ::usage = "RightIdealQ[S, R] returns True if the set S is a
right ideal of the structure R, and False otherwise.";

RingInfo::usage="RingInfo[R] is a list of facts about R that are
generated by various tests of R.";

RingQ::usage="RingQ[R] returns True if R is a ring, and False
otherwise.";

RingSolve::usage="RingSolve[R, a, b] solves the linear equation a x ==b
in the Ringoid R, returning a list of elements that solve the
equation.";

SelectBaseElementsFrom::usage = "SelectBaseElementsFrom is an option for
RandomElement and RandomElements when using extension rings. The values
are Any, NonZero, NonUnity and NonIdentity.";

SubringQ::usage="SubringQ[S, R] returns True if S is a subring of R, and
False otherwise. (This function tests whether S is nonempty and closed
with respect to difference and multiplication in R.)";

UnitQ::usage = "UnitQ[R, r] returns True if r is a unit in the structure
R, and False otherwise.";

Units::usage="Units[R] returns the list of units of the structure R.";

Unity::usage = "Unity[R] returns the unity of R, if one exists in R.";

WithUnityQ::usage = "WithUnityQ[R] returns True if the structure R has a
unity, and False otherwise.";

Zero::usage = "Zero[R] returns the zero of R, if one exists in R.";

ZeroDivisorQ::usage="ZeroDivisorQ[R, r] returns True if r is a zero
divisor of the structure R, and False otherwise. Since this calls
ZeroDivisors (which generates a complete list of zero divisors), a
noticeable delay may be noticed upon the first call for large
Ringoids.";

ZeroDivisors::usage="ZeroDivisors[R] returns a list of all zero divisors
of the structure R. If R does not have a zero (HasZeroQ[R] == False), a
message is returned. This calculation is based on the definition that if
nonzero r and nonzero s have the product Zero[R], then r and s are both
zero divisors.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
Characteristic::fail = "This Ringoid either is not a ring or does not
have a unity, and so it does not make sense to find its
characteristic.";

IdealQ::fail = "The Ringoid needs to be commutative and with a unity.";

ModpIrreducibilityQ::baddeg = "Using the prime number `1`, the degree of the
reduced polynomial does not match that of the original.";

ModpIrreducibilityQ::badpoly = "The expression `1` is an ill-formed polynomial.";

QuotientRing::NS = "This quotient ring uses NS to represent the ideal
(normal subgroup) `1` you specified. Use CosetToList to convert
this coset representation to a list of the elements.";

QuotientRing::notideal = "The set `1` is not an ideal of the Ringoid
`2`.";

QuotientRing::toobig="Requested quotient ring is likely to be too large.
Option SizeLimit can be reset.";

QuotientRing::J = "This quotient ring uses J to represent the principal
ideal generated by `1`.";

QuotientRing::badz = "For this function, the parameter z must be a
Gaussian integer other than 1, -1, I, -I, which `1` is not.";

RandomElement::fail = "When trying to comply with the option SelectFrom
-> `1`, this Ringoid does not have enough elements to still choose a
random element.";

Ring::fail = "The structure `1` fails to be a ring.";

Ringoid::AddAssoc="Addition is associative.";

Ringoid::AddComm="Addition is commutative.";

Ringoid::Distrib="Multiplication is distributive over addition.";

Ringoid::HasAZero="This Ringoid has a zero.";

Ringoid::HasUnity="This Ringoid has a unity (multiplicative identity).";

Ringoid::MultAssoc="Multiplication is associative.";

Ringoid::NAddAssoc="Addition is not associative.";

Ringoid::NAddComm="Addition not commutative.";

Ringoid::NDistrib="Multiplication is not distributive over addition.";

Ringoid::NMultAssoc="Multiplication is not associative.";

Ringoid::Negation="All elements of the Ringoid have a negation.";

Ringoid::NoNeg="Not all elements of the Ringoid have a negation.";

Ringoid::NoUnity="This Ringoid does not have a unity.";

Ringoid::NoZero="This Ringoid does not have a zero.";

Ringoid::NotUnit="`1` is not a unit of `2`";

Ringoid::RDistrib="Multiplication is likely to be distributive over
addition.";

Ring::subringfail = "The set `1` fails to be a subring of the ring.";

UnitQ::nounity="The ring does not have a unity; no units are possible.";

ZeroDivisors::NA = "The Ringoid does not have a zero and so the notion
of zero divisors does not make sense.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Begin private
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Misc. startup code
:[font = input; initialization; preserveAspect]
*)

AddRingInfo[G_, ok_, mess1_, mess2_] := 
	(If[AbstractAlgebra`Core`Private`untestedQ[RingInfo[G]], RingInfo[G] = {}];
	If[ok,
		If[!MemberQ[RingInfo[G],mess1],
			AppendTo[RingInfo[G],mess1]],
		If[!MemberQ[RingInfo[G],mess2],
			AppendTo[RingInfo[G],mess2]]];)
			
ModifiedAnd[x_, y_] := If[MemberQ[{x,y},$Failed],
	$Failed, x && y]

RingStuff:=
(DefaultStructure = Ring;
		Options[ClosedQ]={Mode -> Computational, Structure :> DefaultStructure, 
			Operation -> Both};
		Options[AssociativeQ]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[RandomAssociativeQ]={Mode -> Computational, 
			Structure :> DefaultStructure, Operation -> Both};
		Options[HasIdentityQ]={Mode -> Computational, Structure :> DefaultStructure, 
			Operation -> Both};
		Options[GroupIdentity]={Mode -> Computational, Structure :> DefaultStructure};
		Options[InvertibleQ]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[GroupInverse]={Mode -> Computational, Structure :> DefaultStructure};
		Options[HasInversesQ]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[Inverses]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[RandomElement]= {SelectFrom -> NonZero, LowerDegreeOK -> False, 
			Monic -> False, SelectBaseElementsFrom -> Any};
			Unprotect[Z];
		Options[Z]={Mode -> Computational, Structure :> DefaultStructure};
		Protect[Z];
		Ring)

Clear[SwitchStructureTo];

SwitchStructureTo[Group] := AbstractAlgebra`Core`Private`GroupStuff

SwitchStructureTo[Groups] := AbstractAlgebra`Core`Private`GroupStuff

SwitchStructureTo[Groupoid] := AbstractAlgebra`Core`Private`GroupStuff

SwitchStructureTo[Groupoids] := AbstractAlgebra`Core`Private`GroupStuff

SwitchStructureTo[Ring] := RingStuff

SwitchStructureTo[Rings] := RingStuff

SwitchStructureTo[Ringoid] := RingStuff

SwitchStructureTo[Ringoids] := RingStuff
		
SwitchStructureTo[Ring];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
general
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Interface with Group Package
:[font = input; initialization; preserveAspect; endGroup]
*)
AdditiveGroupoid[R_?RingoidQ] := AGroupoid[R]

MultiplicativeGroupoid[R_?RingoidQ] := MGroupoid[R]

newName[pre_, nm_, post_] :=
	Switch[Head[nm], 
		String, pre<>nm<>post, 
		SequenceForm, Prepend[Append[nm, post],pre],
		_, "add. groupoid"]

AGroupoid[R_?RingoidQ] := AGroupoid[R] =
	FormGroupoid[R[[1]], R[[2]], PlusSymbol[R],
		WideElements -> AbstractAlgebra`Core`Private`WideElementsQ[R], GroupoidName -> 
		newName["Add(", RingoidName[R],")"], 
		FormatOperator -> AbstractAlgebra`Core`Private`FormatOpQ[R], 
		FormatElements -> AbstractAlgebra`Core`Private`FormatElsQ[R],
		KeyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[KeyForm[R]],
				InputForm, KeyForm[R]],
		CayleyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[CayleyForm[R]],
				OutputForm, CayleyForm[R]], 
		AbstractAlgebra`Core`Private`ExtraInformation -> {{},{},{},{},{"AG" -> True}}];

MGroupoid[R_?RingoidQ] := MGroupoid[R] = 
	FormGroupoid[R[[1]], R[[3]], TimesSymbol[R],
		WideElements -> AbstractAlgebra`Core`Private`WideElementsQ[R], GroupoidName -> 
		newName["Mult(", RingoidName[R],")"], 
		FormatOperator -> AbstractAlgebra`Core`Private`FormatOpQ[R], 
		FormatElements -> AbstractAlgebra`Core`Private`FormatElsQ[R],
		KeyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[KeyForm[R]],
				InputForm, KeyForm[R]],
		CayleyForm -> 
			If[AbstractAlgebra`Core`Private`untestedQ[CayleyForm[R]],
				OutputForm, CayleyForm[R]],
		AbstractAlgebra`Core`Private`ExtraInformation -> {{},{},{},{},{"MG" -> True}}];
				
NonZeroMGroupoid[R_?RingoidQ] := NonZeroMGroupoid[R] = 
	FormGroupoid[Complement[R[[1]], {Zero[R]}], R[[3]], TimesSymbol[R],
		WideElements -> AbstractAlgebra`Core`Private`WideElementsQ[R], GroupoidName -> RingoidName[R], 
		FormatOperator -> AbstractAlgebra`Core`Private`FormatOpQ[R], 
		FormatElements -> AbstractAlgebra`Core`Private`FormatElsQ[R]];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Defining Properties of Rings
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Closure
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[ClosedQ] = {Mode -> Computational, Operation -> Both,
	Structure -> Ring};

ClosedQ[R_?RingoidQ] := ClosedQ[R] = 
	ModifiedAnd[ClosedQ[R, Operation -> Addition],
		ClosedQ[R, Operation -> Multiplication]]

ClosedQ[R_?RingoidQ, Operation -> Addition]:=
	ClosedQ[R, Operation -> Addition] = Module[{AG = AGroupoid[R], aok},
		aok = ClosedQ[AG];
		AddRingInfo[R, aok, "the set is closed under addition",
			"the set is not closed under this addition"];
		aok]

ClosedQ[R_?RingoidQ, Operation -> Multiplication]:=
	ClosedQ[R, Operation -> Multiplication] = Module[{MG = MGroupoid[R], mok},
		mok = ClosedQ[MG];
		AddRingInfo[R, mok, "the set is closed under multiplication",
			"the set is not closed under this multiplication"];
		mok]
	
ClosedQ[R_?RingoidQ, Operation -> Addition, opts__?OptionQ]:=
	(ClosedQ[R, Operation -> Addition]; 
	ClosedQ[AGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)
	
ClosedQ[R_?RingoidQ, Operation -> Multiplication, opts__?OptionQ]:=
	(ClosedQ[R, Operation -> Multiplication]; 
	ClosedQ[MGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)

ClosedQ[R_, Operation -> Both]:=
	ClosedQ[R]
	
ClosedQ[R_?RingoidQ, Operation -> Both, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[ClosedQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {ClosedQ[R, Operation -> Addition],
			ClosedQ[R, Operation -> Multiplication]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			ClosedQ[AG, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:"];
			ClosedQ[MG, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			gr1 = ClosedQ[AG, Mode -> Visual, Output -> Graphics, 
				DisplayFunction -> Identity, showopts];
			gr2 = ClosedQ[MG, Mode -> Visual, Output -> Graphics, 
				DisplayFunction -> Identity, showopts];
			(*gr1 = AbstractAlgebra`Core`Private`ClosedQVisual[AG, aok, 
				DisplayFunction -> Identity, showopts];
			gr2 = ClosedQ[MG, Mode -> Visual, Output -> Graphics, 
				DisplayFunction -> Identity, showopts];*)
			{gr1, gr2} = Map[If[Head[#]===Graphics,#,		
				AbstractAlgebra`Core`Private`ErrorSpace]&, {gr1, gr2}];
			Show[GraphicsArray[{gr1, gr2}], DisplayFunction -> $DisplayFunction];
			
		];
		ModifiedAnd[aok , mok]
	]

ClosedQ[R_?RingoidQ, opts__?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[ClosedQ]}],
    Multiplication, ClosedQ[R, Operation -> Multiplication, opts],
    Addition, ClosedQ[R, Operation -> Addition, opts],
    Both, ClosedQ[R, Operation -> Both, opts]]

ClosedQ[R_?RingoidQ, S_List, Operation -> Addition, opts___?OptionQ]:=
	ClosedQ[AGroupoid[R], S, Structure -> Ring, opts]
	
ClosedQ[R_?RingoidQ, S_List, Operation -> Multiplication, opts___?OptionQ]:=
	ClosedQ[MGroupoid[R], S, Structure -> Ring, opts]
	
ClosedQ[R_?RingoidQ, S_List, Operation -> Both, opts___?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[ClosedQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {ClosedQ[AG, S], ClosedQ[MG, S]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:\n"];
			ClosedQ[AG, S, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:\n"];
			ClosedQ[MG, S, Structure -> Ring, Mode -> Textual];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			gr1 = AbstractAlgebra`Core`Private`SubgroupQVisual4[AG, S, 
				DisplayFunction -> Identity, showopts];
			gr2 = AbstractAlgebra`Core`Private`SubgroupQVisual4[MG, S, 
				DisplayFunction -> Identity, showopts];
			{gr1, gr2} = Map[If[Head[#]===Graphics,#,		
				AbstractAlgebra`Core`Private`ErrorSpace]&, {gr1, gr2}];
			Show[GraphicsArray[{gr1, gr2}], DisplayFunction -> $DisplayFunction];
		];
		ModifiedAnd[aok , mok]
	]
	
ClosedQ[R_?RingoidQ, S_List, opts___?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[ClosedQ]}],
    Multiplication, ClosedQ[R, S, Operation -> Multiplication, opts],
    Addition, ClosedQ[R, S, Operation -> Addition, opts],
    Both, ClosedQ[R, S, Operation -> Both, opts]]

ClosedQ[R_?RingoidQ, S_?RingoidQ, opts___?OptionQ]:=
	ClosedQ[R, Elements[S], opts]

ClosedPlusQ[R_?RingoidQ, S_List]:=
     ClosedQ[FormGroupoid[S, Addition[R]]];
     
ClosedPlusQ[R_?RingoidQ, S_?RingoidQ]:=
     ClosedQ[FormGroupoid[Elements[S], Addition[R]]];
     
ClosedTimesQ[R_?RingoidQ, S_List]:=
     ClosedQ[FormGroupoid[S, Multiplication[R]]];

ClosedTimesQ[R_?RingoidQ, S_?RingoidQ,opts___?OptionQ]:=
     ClosedTimesQ[R,S//Elements, opts];

Options[ClosedDiffQ] = {Mode -> Computational};

ClosedDiffQ[R_?RingoidQ, S_List] := 
  ClosedQ[FormGroupoid[S,(Addition[R][#1,NegationOf[R,#2]])&]];

ClosedDiffQ[R_?RingoidQ, S_?RingoidQ,opts___?OptionQ] := 
  ClosedDiffQ[R, Elements[S], opts];

ClosedDiffQ[R_?RingoidQ, S_List, opts__?OptionQ] := 
    Block[{fn=ClosedDiffQ[R,S],
            md=Mode/.Flatten[{opts, Options[ClosedDiffQ]}],
            tr,a,b,c},
         If[(md == Textual),
            (* Textual Stuff *)
            tr:=S[[Random[Integer,{1,Length[S]}]]];
            Print["Representative Tests for closure with respect to difference"];
            Do[a=tr;b=tr;c=(Addition[R][a,NegationOf[R,b]]);
               Print[a," + NegationOf[",b,"] = ",a," + ",NegationOf[R,b]," = ",c];
               If[MemberQ[S,c],Print["\t Result is in the set - closure still possible"],
                               Print["\t Result is not in the set - closure not true."]],{4}]
            ];
         If[(md == Visual),
            (* Visual Stuff *)
            CayleyTable[AGroupoid[R],Mode -> Visual]];
        fn];

Options[ClosedTimesQ] = {Mode -> Computational};

ClosedTimesQ[R_?RingoidQ, S_List, opts__?OptionQ] := 
    Block[{fn=ClosedTimesQ[R,S],
            md=Mode/.Flatten[{opts, Options[ClosedTimesQ]}],
            tr,a,b,c},
         If[(md== Textual),
            (* Textual Stuff *)
            tr:=S[[Random[Integer,{1,Length[S]}]]];
            Print["Representative Tests for closure with respect to multiplication"];
            Do[a=tr;b=tr;c=(Multiplication[R][a,b]);
               Print[a," . ",b," = ",c];
               If[MemberQ[S,c],Print["\t Result is in the set - closure still possible"],
                               Print["\t Result is not in the set - closure not true."]],{4}]
            ];
         If[(md== Visual),
            (* Visual Stuff *)
            MultiplicationTable[R,Mode ->  Visual]];
        fn];

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Commutativity
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[CommutativeQ] = {Mode -> Computational, Operation -> Both,
	Structure -> Ring};

CommutativeQ[R_?RingoidQ] := CommutativeQ[R] = 
	ModifiedAnd[CommutativeQ[R, Operation -> Addition],
		CommutativeQ[R, Operation -> Multiplication]]
	
CommutativeQ[R_?RingoidQ, Operation -> Addition]:=
	CommutativeQ[R, Operation -> Addition] = Module[{AG = AGroupoid[R],aok},
		aok = CommutativeQ[AG];
		AddRingInfo[R, aok, "the addition operation is commutative",
			"the addition operation is not commutative"];
		aok]

CommutativeQ[R_?RingoidQ, Operation -> Multiplication]:=
	CommutativeQ[R, Operation -> Multiplication] = 
		Module[{MG = MGroupoid[R],mok},
		mok = CommutativeQ[MG];
		AddRingInfo[R, mok, "the multiplication operation is commutative",
			"the multiplication operation is not commutative"];
		mok]

CommutativeQ[R_?RingoidQ, Operation -> Addition, opts__?OptionQ]:=
	(CommutativeQ[R, Operation -> Addition]; 
	CommutativeQ[AGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)
	
CommutativeQ[R_?RingoidQ, Operation -> Multiplication, opts__?OptionQ]:=
	(CommutativeQ[R, Operation -> Multiplication]; 
	CommutativeQ[MGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)

CommutativeQ[R_, Operation -> Both] := CommutativeQ[R]
	
CommutativeQ[R_?RingoidQ, Operation -> Both, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[CommutativeQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {CommutativeQ[R, Operation -> Addition],
			CommutativeQ[R, Operation -> Multiplication]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			CommutativeQ[AG, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:"];
			CommutativeQ[MG, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			CommutativeQ[{AG, MG}, Mode -> Visual, showopts];
		];
		ModifiedAnd[aok, mok]]

CommutativeQ[R_?RingoidQ, opts__?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[CommutativeQ]}],
    Multiplication, CommutativeQ[R, Operation -> Multiplication, opts],
    Addition, CommutativeQ[R, Operation -> Addition, opts],
    Both, CommutativeQ[R, Operation -> Both, opts]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Associativity
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[AssociativeQ] = {Mode -> Computational, Operation -> Both,
	Structure -> Ring};

AssociativeQ[R_?RingoidQ] := AssociativeQ[R] = 
	ModifiedAnd[AssociativeQ[R, Operation -> Addition],
		AssociativeQ[R, Operation -> Multiplication]]
	
AssociativeQ[R_?RingoidQ, Operation -> Addition]:=
	AssociativeQ[R, Operation -> Addition] = 
			Module[{AG = AGroupoid[R], aok},
		aok = AssociativeQ[AG];
		AddRingInfo[R, aok, "the addition operation is associative",
			"the addition operation is not associative"];
		aok]
	
AssociativeQ[R_?RingoidQ, Operation -> Addition, opts__?OptionQ]:=
	(AssociativeQ[R, Operation -> Addition]; 
	AssociativeQ[AGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)
	
AssociativeQ[R_?RingoidQ, Operation -> Multiplication]:=
	AssociativeQ[R, Operation -> Multiplication] = 
			Module[{MG = MGroupoid[R], mok},
		mok = AssociativeQ[MG];
		AddRingInfo[R, mok, "the multiplication operation is associative",
			"the multiplication operation is not associative"];
		mok]
	
AssociativeQ[R_?RingoidQ, Operation -> Multiplication, opts__?OptionQ]:=
	(AssociativeQ[R, Operation -> Multiplication]; 
	AssociativeQ[MGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)

AssociativeQ[R_?RingoidQ, Operation -> Both]:=
	AssociativeQ[R]
	
AssociativeQ[R_?RingoidQ, Operation -> Both, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[AssociativeQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {AssociativeQ[R, Operation -> Addition],
			AssociativeQ[R, Operation -> Multiplication]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			AssociativeQ[AG, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:"];
			AssociativeQ[MG, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			AssociativeQ[{AG, MG}, Mode -> Visual, showopts];
		];
		ModifiedAnd[aok, mok]]

AssociativeQ[R_?RingoidQ, opts__?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[AssociativeQ]}],
    Multiplication, AssociativeQ[R, Operation -> Multiplication, opts],
    Addition, AssociativeQ[R, Operation -> Addition, opts],
    Both, AssociativeQ[R, Operation -> Both, opts]]
    
Options[RandomAssociativeQ] = {Mode -> Computational, Operation -> Both,
	Structure -> Ring};

RandomAssociativeQ[R_?RingoidQ, max_:25] := RandomAssociativeQ[R, max] = 
	ModifiedAnd[RandomAssociativeQ[R, Operation -> Addition, max],
		RandomAssociativeQ[R, Operation -> Multiplication, max]]
	
RandomAssociativeQ[R_?RingoidQ, Operation -> Addition, max_:25]:=
	RandomAssociativeQ[R, Operation -> Addition] = 
			Module[{AG = AGroupoid[R], aok},
		aok = RandomAssociativeQ[AG, max];
		AddRingInfo[R, aok, "the addition operation is probably associative",
			"the addition operation is not associative"];
		aok]
	
RandomAssociativeQ[R_?RingoidQ, Operation -> Addition, opts__?OptionQ]:=
	(RandomAssociativeQ[R, Operation -> Addition]; 
	RandomAssociativeQ[AGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)
	
RandomAssociativeQ[R_?RingoidQ, Operation -> Multiplication, 
		max_:25]:=
	RandomAssociativeQ[R, Operation -> Multiplication] = 
			Module[{MG = MGroupoid[R], mok},
		mok = RandomAssociativeQ[MG, max];
		AddRingInfo[R, mok, "the multiplication operation is probably associative",
			"the multiplication operation is not associative"];
		mok]
	
RandomAssociativeQ[R_?RingoidQ, Operation -> Multiplication, opts__?OptionQ]:=
	(RandomAssociativeQ[R, Operation -> Multiplication]; 
	RandomAssociativeQ[MGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)

RandomAssociativeQ[R_?RingoidQ, Operation -> Both]:=
	RandomAssociativeQ[R]
	
RandomAssociativeQ[R_?RingoidQ, Operation -> Both, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[RandomAssociativeQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {RandomAssociativeQ[R, Operation -> Addition],
			RandomAssociativeQ[R, Operation -> Multiplication]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			RandomAssociativeQ[AG, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:"];
			RandomAssociativeQ[MG, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			RandomAssociativeQ[{AG, MG}, Mode -> Visual, showopts];
		];
		ModifiedAnd[aok, mok]]

RandomAssociativeQ[R_?RingoidQ, opts__?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[RandomAssociativeQ]}],
    Multiplication, RandomAssociativeQ[R, Operation -> Multiplication, opts],
    Addition, RandomAssociativeQ[R, Operation -> Addition, opts],
    Both, RandomAssociativeQ[R, Operation -> Both, opts]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Identities
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
zero
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[HasZeroQ] = {Mode -> Computational, Structure -> Ring};

HasZeroQ[R_?RingoidQ] := HasZeroQ[R] = 
	Module[{AG = AGroupoid[R], aok, z},
		{aok, z} = {HasIdentityQ[AG], GroupIdentity[AG]};
		Zero[R] = z;
		AddRingInfo[R, aok, "the Ringoid has as a zero the element "<>ToString[z],
			"the Ringoid does not have a zero"];
		aok]
	
HasZeroQ[R_?RingoidQ, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], aok, z, 
			mode=Mode/.Flatten[{opts, Options[HasZeroQ]}],
			showopts = FilterOptions[Graphics, opts]},
		{aok, z} = {HasZeroQ[R], Zero[R]};
		If[mode === Textual && aok =!= $Failed,
			HasIdentityQ[AG, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && aok =!= $Failed,
			HasIdentityQ[AG, Structure -> Ring, Mode -> Visual, showopts]];
		aok]
		
Options[Zero] = {Mode -> Computational, Structure -> Ring};

Zero[R_?RingoidQ] := Zero[R] = 
	Module[{AG = AGroupoid[R], aok, z},
		{aok, z} = {HasIdentityQ[AG], GroupIdentity[AG]};
		HasZeroQ[R] = aok;
		AddRingInfo[R, aok, "the Ringoid has as a zero the element "<>ToString[z],
			"the Ringoid does not have a zero"];
		z]
	
Zero[R_?RingoidQ, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], aok, z, 
			mode=Mode/.Flatten[{opts, Options[Zero]}],
			showopts = FilterOptions[Graphics, opts]},
		{aok, z} = {HasZeroQ[R], Zero[R]};
		If[mode === Textual && z =!= $Failed,
			GroupIdentity[AG, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && z =!= $Failed,
			GroupIdentity[AG, Structure -> Ring, Mode -> Visual, showopts]];
		z]
(*
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
unity
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[WithUnityQ] = {Mode -> Computational, Structure -> Ring};

WithUnityQ[R_?RingoidQ] := WithUnityQ[R] = 
	Module[{MG = MGroupoid[R], mok, u},
		{mok, u} = {HasIdentityQ[MG], GroupIdentity[MG]};
		Unity[R] = u;
		AddRingInfo[R, mok, "the Ringoid has as unity the element "<>ToString[u],
			"the Ringoid does not have a unity element"];
		mok]
	
	
WithUnityQ[R_?RingoidQ, opts__?OptionQ]:=
	Module[{MG = MGroupoid[R], mok, u, 
			mode=Mode/.Flatten[{opts, Options[WithUnityQ]}],
			showopts = FilterOptions[Graphics, opts]},
		{mok, u} = {WithUnityQ[R], Unity[R]};
		If[mode === Textual && mok =!= $Failed,
			HasIdentityQ[MG, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && mok =!= $Failed,
			HasIdentityQ[MG, Structure -> Ring, Mode -> Visual, showopts]];
		mok]        

HasUnityQ[args__] := WithUnityQ[args]
         
Options[Unity] = {Mode -> Computational, Structure -> Ring};

Unity[R_?RingoidQ] := Unity[R] = 
	Module[{MG = MGroupoid[R], mok, u},
		{mok, u} = {HasIdentityQ[MG], GroupIdentity[MG]};
		WithUnityQ[R] = mok;
		AddRingInfo[R, mok, "the Ringoid has as unity the element"<>ToString[u],
			"the Ringoid does not have a unity element"];
		u]
	
Unity[R_?RingoidQ, opts__?OptionQ]:=
	Module[{MG = MGroupoid[R], mok, u, 
			mode=Mode/.Flatten[{opts, Options[Unity]}],
			showopts = FilterOptions[Graphics, opts]},
		{mok, u} = {WithUnityQ[R], Unity[R]};
		If[mode === Textual && u =!= $Failed,
			GroupIdentity[MG, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && u =!= $Failed,
			GroupIdentity[MG, Structure -> Ring, Mode -> Visual, showopts]];
		u]
(*
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
combined
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Options[HasIdentityQ] = {Mode -> Computational, Operation -> Both,
	Structure -> Ring};

HasIdentityQ[R_?RingoidQ] := HasIdentityQ[R] = ModifiedAnd[HasZeroQ[R], WithUnityQ[R]]
		
HasIdentityQ[R_?RingoidQ, Operation -> Addition]:=
	HasIdentityQ[R, Operation -> Addition] = 
		HasZeroQ[R]
	
HasIdentityQ[R_?RingoidQ, Operation -> Addition, opts__?OptionQ]:=
	(HasIdentityQ[R]; HasIdentityQ[AGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)

HasIdentityQ[R_?RingoidQ, Operation -> Multiplication]:=
	HasIdentityQ[R, Operation -> Multiplication] = 
		WithUnityQ[R]
	
HasIdentityQ[R_?RingoidQ, Operation -> Multiplication, opts__?OptionQ]:=
	(HasIdentityQ[R]; HasIdentityQ[MGroupoid[R], Structure -> Ring, opts])
	(* first line to set the RingInfo *)

HasIdentityQ[R_, Operation -> Both] := HasIdentityQ[R]
	
HasIdentityQ[R_?RingoidQ, Operation -> Both, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[HasIdentityQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {HasZeroQ[R], WithUnityQ[R]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			HasIdentityQ[AG, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:"];
			HasIdentityQ[MG, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			HasIdentityQ[{AG, MG}, Mode -> Visual, showopts];
		];
		ModifiedAnd[aok, mok]]

HasIdentityQ[R_?RingoidQ, opts__?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[HasIdentityQ]}],
    Multiplication, HasIdentityQ[R, Operation -> Multiplication, opts],
    Addition, HasIdentityQ[R, Operation -> Addition, opts],
    Both, HasIdentityQ[R, Operation -> Both, opts]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Inverses
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Additive
:[font = input; initialization; Cclosed; preserveAspect; startGroup]
*)
Options[HasNegativeQ] = {Mode -> Computational, Structure -> Ring};

HasNegativeQ[R_?RingoidQ, r_] := HasNegativeQ[R,r] = 
	If[ElementQ[r,R], 
	Module[{AG = AGroupoid[R], aok, n},
		{aok, n} = {InvertibleQ[AG,r], GroupInverse[AG,r]};
		NegationOf[R,r] = n;
		AddRingInfo[R, aok, "the negation of "<>ToString[r]<>" is "<>ToString[n],
			ToString[r]<>" does not have a negation"];
		aok],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; False]
	
HasNegativeQ[R_?RingoidQ, r_, opts__?OptionQ] :=
	If[ElementQ[r,R],
	Module[{AG = AGroupoid[R], aok, n, 
			mode=Mode/.Flatten[{opts, Options[HasNegativeQ]}],
			showopts = FilterOptions[Graphics, opts]},
		{aok, n} = {HasNegativeQ[R,r], NegationOf[R,r]};
		If[mode === Textual && aok =!= $Failed,
			InvertibleQ[AG, r, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && aok =!= $Failed,
			InvertibleQ[AG, r, Structure -> Ring, Mode -> Visual, showopts]];
		aok],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; False]
		
Options[NegationOf] = {Mode -> Computational, Structure -> Ring};

NegationOf[R_?RingoidQ, r_] := NegationOf[R,r] = 
	If[ElementQ[r,R],
	Module[{AG = AGroupoid[R], aok, n},
		{aok, n} = {InvertibleQ[AG,r], GroupInverse[AG,r]};
		HasNegativeQ[R,r] = aok;
		AddRingInfo[R, aok, "the negation of "<>ToString[r]<>" is "<>ToString[n],
			ToString[r]<>" does not have a negation"];
		n],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; $Failed]
	
NegationOf[R_?RingoidQ, r_, opts__?OptionQ] :=
	If[ElementQ[r,R],
	Module[{AG = AGroupoid[R], aok, n, 
			mode=Mode/.Flatten[{opts, Options[NegationOf]}],
			showopts = FilterOptions[Graphics, opts]},
		{aok, n} = {HasNegativeQ[R,r], NegationOf[R,r]};
		If[mode === Textual && aok =!= $Failed,
			InvertibleQ[AG, r, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && aok =!= $Failed,
			InvertibleQ[AG, r, Structure -> Ring, Mode -> Visual, showopts]];
		n],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; 
	$Failed]
	
Unprotect[Inverse]

AbstractAlgebra`Core`Private`ringoid /: 
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, Operation -> Addition, opts___?OptionQ] :=
	NegationOf[R, r, opts]

AbstractAlgebra`Core`Private`ringoid /:
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, opts___?OptionQ, Operation -> Addition] :=
	NegationOf[R, r, opts]

Protect[Inverse]
(*
:[font = output; output; inactive; preserveAspect]
{"Inverse"}
;[o]
{Inverse}
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
{"Inverse"}
;[o]
{Inverse}
:[font = subsubsection; inactive; initialization; Cclosed; preserveAspect; startGroup]
Multiplicative
:[font = input; initialization; Cclosed; preserveAspect; startGroup]
*)
Options[UnitQ] = {Mode -> Computational, Structure -> Ring};

UnitQ[R_?RingoidQ, r_] := UnitQ[R,r] = 
	If[ElementQ[r,R],
	Module[{MG = MGroupoid[R], mok, inv},
		{mok, inv} = {InvertibleQ[MG,r], GroupInverse[MG,r]};
		MultiplicativeInverse[R,r] = inv;
		AddRingInfo[R, mok, "the multiplicative inverse of "<>ToString[r]<>" is "<>ToString[inv],
			ToString[r]<>" does not have a multiplicative inverse"];
		mok],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; False]
	
UnitQ[R_?RingoidQ, r_, opts__?OptionQ] :=
	If[ElementQ[r,R],
	Module[{MG = MGroupoid[R], mok, inv, 
			mode=Mode/.Flatten[{opts, Options[UnitQ]}],
			showopts = FilterOptions[Graphics, opts]},
		{mok, inv} = {UnitQ[R,r], MultiplicativeInverse[R,r]};
		If[mode === Textual && mok =!= $Failed,
			InvertibleQ[MG, r, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && mok =!= $Failed,
			InvertibleQ[MG, r, Structure -> Ring, Mode -> Visual, showopts]];
		mok],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; False]
		

Options[MultiplicativeInverse] = {Mode -> Computational, Structure -> Ring};

MultiplicativeInverse[R_?RingoidQ, r_] := MultiplicativeInverse[R,r] = 
	If[ElementQ[r,R], 
	Module[{MG = MGroupoid[R], mok, inv},
		{mok, inv} = {InvertibleQ[MG,r], GroupInverse[MG,r]};
		UnitQ[R,r] = mok;
		AddRingInfo[R, mok, "the multiplicative inverse of "<>ToString[r]<>" is "<>ToString[inv],
			ToString[r]<>" does not have a multiplicative inverse"];
		inv],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; $Failed]
	
MultiplicativeInverse[R_?RingoidQ, r_, opts__?OptionQ] :=
	If[ElementQ[r,R], 
	Module[{MG = MGroupoid[R], mok, inv, 
			mode=Mode/.Flatten[{opts, Options[MultiplicativeInverse]}],
			showopts = FilterOptions[Graphics, opts]},
		{mok, inv} = {UnitQ[R,r], MultiplicativeInverse[R,r]};
		If[mode === Textual && mok =!= $Failed,
			InvertibleQ[MG, r, Structure -> Ring, Mode -> Textual]];
		If[mode === Visual && mok =!= $Failed,
			InvertibleQ[MG, r, Structure -> Ring, Mode -> Visual, showopts]];
		inv],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]];
	 $Failed]
	
Unprotect[Inverse]

AbstractAlgebra`Core`Private`ringoid /: 
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, Operation -> 
	Multiplication, opts___?OptionQ] :=
	MultiplicativeInverse[R, r, opts]

AbstractAlgebra`Core`Private`ringoid /:
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, opts___?OptionQ, 
	Operation -> Multiplication] :=
	MultiplicativeInverse[R, r, opts]

Protect[Inverse]

Options[Units] = {Mode->Computational};

Units[R_?RingoidQ] := Units[R] = 
	DeleteCases[Inverses[MGroupoid[R]],
		{x_,"no inverse"}]//Flatten[#,1]&//Union
		
Units[R_?RingoidQ, opts__?OptionQ] := 
   If[WithUnityQ[R],
     Block[{pairs,
            jm=(ToString[#1]<>
                " is a unit because "<>
                ToString[#1]<>" . "<> 
                ToString[#2]<>" = "<> 
                ToString[Unity[R]]<>".")&,
            md=Mode/.Flatten[{opts, Options[Units]}],
            gr=MGroupoid[R],
            us=Units[R],
            zeroOneFirst=Join[{Zero[R],Unity[R]},
                           Complement[First[R],{Zero[R],Unity[R]}]]},
        OperatorSymbol[gr]=".";
        us=Units[R];
        If[(md==Textual)||(md==Visual),
           pairs=Map[{#,MultiplicativeInverse[R,#]}&,us];
           Apply[jm,pairs,{1}]//
               TableForm//Print];
        If[(md==Visual),
            Print["\nNotice the locations of unity (pink) in the table below."];
            MultiplicationTable[R,Mode -> Visual,
                                         TheSet->zeroOneFirst]];
        us],
        (* ********** *)
        Print["Ringoid has no unity, units not applicable"]];
(*
:[font = output; output; inactive; preserveAspect]
{"Inverse"}
;[o]
{Inverse}
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
{"Inverse"}
;[o]
{Inverse}
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
combined
:[font = input; initialization; Cclosed; preserveAspect; startGroup]
*)
Options[InvertibleQ] = {Mode -> Computational, Operation -> Both,
	Structure -> Ring};

InvertibleQ[R_?RingoidQ, r_] := InvertibleQ[R, r] = 
	ModifiedAnd[HasNegativeQ[R,r], UnitQ[R,r]]
		
InvertibleQ[R_?RingoidQ, r_, Operation -> Addition] :=
	InvertibleQ[R, r, Operation -> Addition] = 
		HasNegativeQ[R,r]
	
InvertibleQ[R_?RingoidQ, r_, Operation -> Addition, opts__?OptionQ]:=
	(InvertibleQ[R,r]; HasNegativeQ[R, r, opts])

InvertibleQ[R_?RingoidQ, r_, Operation -> Multiplication]:=
	InvertibleQ[R, r, Operation -> Multiplication] = 
		UnitQ[R,r]
	
InvertibleQ[R_?RingoidQ, r_, Operation -> Multiplication, opts__?OptionQ]:=
	(InvertibleQ[R,r]; UnitQ[R, r, opts])

InvertibleQ[R_, r_, Operation -> Both]:=
	InvertibleQ[R,r]
	
InvertibleQ[R_?RingoidQ, r_, Operation -> Both, opts__?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], aok, mok, 
			mode=Mode/.Flatten[{opts, Options[InvertibleQ]}],
			showopts = FilterOptions[Graphics, opts]},
		{aok, mok} = {HasNegativeQ[R,r], UnitQ[R,r]};
		If[mode === Textual && aok =!= $Failed && mok =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			InvertibleQ[AG,r, Structure -> Ring, Mode -> Textual];
			Print["Multiplicative Groupoid:"];
			InvertibleQ[MG,r, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && aok =!= $Failed && mok =!= $Failed,
			InvertibleQ[{{AG,r}, {MG,r}}, Mode -> Visual, showopts];
		];
		ModifiedAnd[aok, mok]]

InvertibleQ[R_?RingoidQ, r_, opts__?OptionQ]:=
  Switch[Operation/.Flatten[{opts, Options[InvertibleQ]}],
    Multiplication, InvertibleQ[R, r, Operation -> Multiplication, opts],
    Addition, InvertibleQ[R, r, Operation -> Addition, opts],
    Both, InvertibleQ[R, r, Operation -> Both, opts]]

Unprotect[Inverse]

AbstractAlgebra`Core`Private`ringoid /: 
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, Operation -> Both, opts___?OptionQ] :=
	{NegationOf[R, r, opts], MultiplicativeInverse[R, r, opts]}

AbstractAlgebra`Core`Private`ringoid /:
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, opts___?OptionQ, Operation -> Both] :=
	{NegationOf[R, r, opts], MultiplicativeInverse[R, r, opts]}

AbstractAlgebra`Core`Private`ringoid /:
Inverse[R_AbstractAlgebra`Core`Private`ringoid, r_, opts___?OptionQ] :=
	Inverse[R, r, Operation -> Both, opts]

Protect[Inverse]
	
Options[HasInversesQ] = {Mode -> Computational, Operation -> 
	Both, Structure -> Ring};

HasInversesQ[R_?RingoidQ] := HasInversesQ[R] = 
	ModifiedAnd[HasInversesQ[R, Operation -> Addition],
		HasInversesQ[R, Operation -> Multiplication]]
		
HasInversesQ[R_?RingoidQ, Operation -> Addition] := 
	HasInversesQ[R, Operation -> Addition] = 
	Module[{AG = AGroupoid[R], ok},
		ok = HasInversesQ[AG];
		AddRingInfo[R, ok, "every element has an additive inverse",
			 "there are elements that do not have an additive inverse"];
		ok]

HasInversesQ[R_?RingoidQ, Operation -> Multiplication] := 
	HasInversesQ[R, Operation -> Multiplication] = 
	Module[{MG = MGroupoid[R], ok},
		ok = HasInversesQ[MG];
		AddRingInfo[R, ok, "every element has a multiplicative inverse",
			 "there are elements that do not have a multiplicative inverse"];
		ok]

HasInversesQ[R_?RingoidQ, Operation -> Addition, opts___?OptionQ]:=
	HasInversesQ[AGroupoid[R], Structure -> Ring, opts]
	
HasInversesQ[R_?RingoidQ, Operation -> Multiplication, opts___?OptionQ]:=
	HasInversesQ[MGroupoid[R], Structure -> Ring, opts]
	
HasInversesQ[R_?RingoidQ, Operation -> Both, opts___?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], ac, mc, 
			mode=Mode/.Flatten[{opts, Options[HasInversesQ]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		{ac, mc} = {HasInversesQ[R, Operation -> Addition],
			HasInversesQ[R, Operation -> Multiplication]};
		If[mode === Textual && ac =!= $Failed && mc =!= $Failed,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			HasInversesQ[AG, Structure -> Ring, opts];
			Print["Multiplicative Groupoid:"];
			HasInversesQ[MG, Structure -> Ring, opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual && ac =!= $Failed && mc =!= $Failed,
			HasInversesQ[{AG, MG}, opts];
		];
		ModifiedAnd[ac, mc]]

HasInversesQ[R_?RingoidQ, opts___?OptionQ] :=
  Switch[Operation/.Flatten[{opts, Options[HasInversesQ]}],
    Multiplication, HasInversesQ[R, Operation -> Multiplication, opts],
    Addition, HasInversesQ[R, Operation -> Addition, opts],
    Both, HasInversesQ[R, Operation -> Both, opts]]

Options[Inverses] = {Mode -> Computational, Operation -> 
	Both, Structure -> Ring};

Inverses[R_?RingoidQ, Operation -> Addition, opts___?OptionQ]:=
	Inverses[AGroupoid[R], Structure -> Ring, opts]
	
Inverses[R_?RingoidQ, Operation -> Multiplication, opts___?OptionQ]:=
	Inverses[MGroupoid[R], Structure -> Ring, opts]
	
Inverses[R_?RingoidQ, Operation -> Both, opts___?OptionQ]:=
	Module[{AG = AGroupoid[R], MG = MGroupoid[R], ac, mc, 
			mode=Mode/.Flatten[{opts, Options[Inverses]}], gr1, gr2,
			showopts = FilterOptions[Graphics, opts]},
		ac = Inverses[AG];
		mc = Inverses[MG];
		If[mode === Textual,
			AbstractAlgebra`Core`Private`multipleQ = True;
			AbstractAlgebra`Core`Private`firstPassQ = True;
			Print["Additive Groupoid:"];
			Inverses[AG, Structure -> Ring, opts];
			Print["Multiplicative Groupoid:"];
			Inverses[MG, Structure -> Ring opts];
			AbstractAlgebra`Core`Private`multipleQ = False;
		];
		If[mode === Visual,
			Inverses[{AG, MG}, opts];
		];
		{ac, mc}]

Inverses[R_?RingoidQ, opts___?OptionQ] :=
  Switch[Operation/.Flatten[{opts, Options[Inverses]}],
    Multiplication, Inverses[R, Operation -> Multiplication, opts],
    Addition, Inverses[R, Operation -> Addition, opts],
    Both, Inverses[R, Operation -> Both, opts]]
(*
:[font = output; output; inactive; preserveAspect]
{"Inverse"}
;[o]
{Inverse}
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
{"Inverse"}
;[o]
{Inverse}
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Distributivity
:[font = input; initialization; preserveAspect; endGroup]
*)
LeftDistributiveQ[R_?RingoidQ] := 
	Module[{els = Elements[R], plus = Addition[R],
	    times=Multiplication[R],
		ok, i,j,k, len,mymode},
	len = Length[els];
	Off[Part::partd];
	Do[ok = times[els[[i]],plus[els[[j]],els[[k]]]] === 
		plus[times[els[[i]],els[[j]]],times[els[[i]],els[[k]]]];
		If[!ok,Break[]], {i,1,len},{j,1,len},{k,1,len}];
	On[Part::partd];
	AddRingInfo[R,ok,"multiplication is left distributive over addition", 
		"multiplication is not left distributive over addition"];
	ok]
	
RightDistributiveQ[R_?RingoidQ] := 
	Module[{els = Elements[R], plus = Addition[R],
	    times=Multiplication[R],
		ok, i,j,k, len,mymode},
	len = Length[els];
	Off[Part::partd];
	Do[ok = times[plus[els[[j]],els[[k]]], els[[i]]] === 
		plus[times[els[[j]],els[[i]]],times[els[[k]],els[[i]]]];
		If[!ok,Break[]], {i,1,len},{j,1,len},{k,1,len}];
	On[Part::partd];
	AddRingInfo[R,ok,"multiplication is right distributive over addition", 
		"multiplication is not right distributive over addition"];
	ok]
	
DistributiveQ[R_?RingoidQ] := DistributiveQ[R] = 
	Module[{ok},
	ok = LeftDistributiveQ[R] && RightDistributiveQ[R];
	AddRingInfo[R,ok,"multiplication is distributive over addition", 
		"multiplication is not distributive over addition"];
	ok]

RandomDistributiveQ[R_?RingoidQ, n_Integer:25] :=
	 Module[{els = Elements[R], plus = Addition[R],
	    times=Multiplication[R],
		ok, i,j,k,len = Length[R[[1]]],mymode},
	Off[Part::partd];
	Do[i = Random[Integer,{1,len}];
		j = Random[Integer,{1,len}];
		k = Random[Integer,{1,len}];
		ok = times[els[[i]],plus[els[[j]],els[[k]]]] === 
		 plus[times[els[[i]],els[[j]]],times[els[[i]],els[[k]]]] &&
		 times[plus[els[[j]],els[[k]]], els[[i]]] === 
		 plus[times[els[[j]],els[[i]]],times[els[[k]],els[[i]]]];
		If[!ok,Break[]], {n}];
	On[Part::partd];
	AddRingInfo[R,ok, "multiplication is probably distributive over addition",
		"multiplication is not distributive over addition"];
	ok]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Ring
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
ZRingoidQn[R_?RingoidQ] := Module[{chars, zpartq, index, ok, nm = RingoidName[R]},
	If[Head[nm] === String, 
		Off[ToExpression::esntx, ToExpression::sntx, ToExpression::sntxi];
		chars = Characters[nm];
		zpartq = Join[Take[chars,2],{Last[chars]}];
		index = ComplementNoSort[chars,zpartq]//StringJoin//ToExpression;
		On[ToExpression::esntx, ToExpression::sntx, ToExpression::sntxi];
		zpartq = StringJoin[zpartq];
		ok = IntegerQ[index] && zpartq === "Z[]";
		If[ok, {ok, index}, {ok, Null}], {False, Null}]]
	
Options[RingQ] = {Mode -> Computational};
	
RingQ[R_?RingoidQ] := RingQ[R] = Module[{ok,zq,n,crq},
	{zq,n} = ZRingoidQn[R];
	crq = If[!AbstractAlgebra`Core`Private`untestedQ[AbstractAlgebra`Core`Private`ringQ[R]],
		AbstractAlgebra`Core`Private`ringQ[R],False];
	If[zq || crq, ok = True,
		ok = ClosedQ[R, Operation -> Both];
		If[ok, ok = HasIdentityQ[R, Operation -> Addition]];
		If[ok, ok = HasInversesQ[R, Operation -> Addition]];
		If[ok, ok = CommutativeQ[R, Operation -> Addition]];
		If[ok, ok = DistributiveQ[R]];
		If[ok, ok = AssociativeQ[R, Operation -> Both]]];
	AddRingInfo[R,ok,"this is a ring","this is NOT a ring"];
	ok]
			
RingQ[R_?RingoidQ, opts__?OptionQ] := Module[{
	 	mymode, out, ok, sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[RingQ]}];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`RingProperties",RingQ, 
		mymode, RingQ[R], {R},{R},{Null},{Null},sc]]

RingQTextual[R_] := 
	(ClosedQ[R, Mode -> Textual, Operation -> Both];
	HasIdentityQ[R, Mode -> Textual, Operation -> Addition];
	HasInversesQ[R, Mode -> Textual, Operation -> Addition];
	CommutativeQ[R, Mode -> Textual, Operation -> Addition];
	(*DistributiveQ[R, Mode -> Textual];*)
	AssociativeQ[R, Mode -> Textual, Operation -> Both])
	
RingQVisual[R_] := 
	(ClosedQ[R, Mode -> Visual, Operation -> Both];
	HasIdentityQ[R, Mode -> Visual, Operation -> Addition];
	HasInversesQ[R, Mode -> Visual, Operation -> Addition];
	CommutativeQ[R, Mode -> Visual, Operation -> Addition];
	(*DistributiveQ[R, Mode -> Visual];*)
	AssociativeQ[R, Mode -> Visual, Operation -> Both])
	
Options[RingQ] = {Mode -> Computational};

ProbableRingQ[R_?RingoidQ] := ProbableRingQ[R] = Module[{ok},
	ok = ClosedQ[R, Operation -> Both];
	If[ok, ok = HasIdentityQ[R, Operation -> Addition]];
	If[ok, ok = HasInversesQ[R, Operation -> Addition]];
	If[ok, ok = CommutativeQ[R, Operation -> Addition]];
	If[ok, ok = RandomDistributiveQ[R]];
	If[ok, ok = RandomAssociativeQ[R, Operation -> Both]];
	AddRingInfo[R, ok, "this is probably a ring","this is NOT a ring"]; 
	ok]

ProbableRingQ[R_?RingoidQ,opts___?OptionQ] := Module[{
	 	mymode,  sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[RingQ]}];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`RingProperties",ProbableRingQ, mymode, ProbableRingQ[R], 
		{R},{R},{Null},{Null},sc]]
	
ProbableRingQTextual[R_] := 
	(ClosedQ[R, Mode -> Textual, Operation -> Both];
	HasIdentityQ[R, Mode -> Textual, Operation -> Addition];
	HasInversesQ[R, Mode -> Textual, Operation -> Addition];
	CommutativeQ[R, Mode -> Textual, Operation -> Addition];
	(*RandomDistributiveQ[R, Mode -> Textual];*)
	RandomAssociativeQ[R, Mode -> Textual, Operation -> Both])
	
ProbableRingQVisual[R_] := 
	(ClosedQ[R, Mode -> Visual, Operation -> Both];
	HasIdentityQ[R, Mode -> Visual, Operation -> Addition];
	HasInversesQ[R, Mode -> Visual, Operation -> Addition];
	CommutativeQ[R, Mode -> Visual, Operation -> Addition];
	(*RandomDistributiveQ[R, Mode -> Visual];*)
	RandomAssociativeQ[R, Mode -> Visual, Operation -> Both])
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Additional Ring properties
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Zero Divisors
:[font = input; initialization; preserveAspect; endGroup]
*)
ZeroDivisorQ[R_?RingoidQ, a_] := MemberQ[ZeroDivisors[R], a];
      
Options[ZeroDivisors] = {Mode -> Computational};

ZeroDivisors[R_?RingoidQ] := ZeroDivisors[R]=
	If[HasZeroQ[R],
		Module[{G = FormGroupoid[Complement[Elements[R],{Zero[R]}],
				Multiplication[R]], zd},
			zd = CayleyTable[G]//Map[Fold[(#1||(Zero[R]==#2))&,
				(First[#]==Zero[R]),Rest[#]]&,#]&//
				{#,Elements[G]}&//Transpose//
				Select[#,First[#]&]&//If[#=={},{},#//Transpose//Last]&;
			AddRingInfo[R,zd==={},"the ring has no zero divisors", "the
ring has the following zero divisors: "<>ToString[zd]];
			zd], 
	Message[ZeroDivisors::NA]; $Failed];

ZeroDivisors[R_?RingoidQ, opts__?OptionQ] := 
   If[HasZeroQ[R],
     Block[{pairs,
            jm=("One reason why "<>ToString[#1]<>
                " is a zero divisor is that "<>
                ToString[#1]<>" * "<> 
                ToString[#2]<>" = "<> 
                ToString[Zero[R]]<>".")&,
            md = Mode/.Flatten[{opts, Options[ZeroDivisors]}],
            G = MGroupoid[R],
            zd = ZeroDivisors[R],
            showopts = FilterOptions[Graphics, opts],
            zeroFirst=Join[{Zero[R]},
                           Complement[First[R],{Zero[R]}]]},
        OperatorSymbol[G] = "*";
        If[(md==Textual),
           pairs=Map[{#,RingSolve[R,#,Zero[R]]//
                       Complement[#,{Zero[R]}]&//
                       randElement}&,zd];
           If[pairs=={},
              Print["There are no zero divisors in "<>
              						(RingInfo[R][[1,1]])],
             Apply[jm,pairs,{1}]//
               TableForm//Print]];
        If[(md==Visual),
        	    Print["\nNotice the locations of zero "<>
        	    	ToString[Zero[R]]<>" in the table below."];
             MultiplicationTable[R, Mode -> Visual,
                                         TheSet->zeroFirst,showopts]];
          zd],
        Message[ZeroDivisors::NA];$Failed];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Types of Rings
:[font = input; initialization; preserveAspect; endGroup]
*)
FieldQ[R_?RingoidQ] := FieldQ[R] = 
	Module[{zq,n},
	{zq,n} = ZRingoidQn[R];
	If[zq && PrimeQ[n], True, 
 (RingQ[R] &&
  CommutativeQ[R, Operation -> Multiplication] &&
  WithUnityQ[R] &&
  Units[R]===Complement[R[[1]],{Zero[R]}])]]

IntegralDomainQ[R_?RingoidQ] := IntegralDomainQ[R] = 
	Module[{zq,n},
	{zq,n} = ZRingoidQn[R];
	If[zq && PrimeQ[n], True, 
   (RingQ[R] &&
    CommutativeQ[R, Operation -> Multiplication] &&
    WithUnityQ[R] &&
    (ZeroDivisors[R]==={}))]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
other properties
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Characteristic[R_?RingoidQ] := Module[{unity},
	If[WithUnityQ[R] && RingQ[R],
		unity = Unity[R];
		FixedPointList[Addition[R][unity,#]&,unity,
			SameTest->(#2===Zero[R]&)]//Length,
		Message[Characteristic::fail];$Failed]]
		
NilpotentDegree[R_?RingoidQ, r_] := NilpotentDegree[R, r] = 
	Module[{f,n,u,uns,nl, z = Zero[R],stop,nil,m},
	n = Length[Elements[R]];
	f = Floor[n/3];
	nl = NestList[Multiplication[R][r,#]&,r,f];
	stop = (m=MemberQ[nl,z]) || Union[nl] =!= UnionNoSort[nl];
	If[stop, nil = If[m, Position[nl,z]//Flatten//First,0],
		nl = NestList[Multiplication[R][Last[nl],#]&,r,f];
		stop = (m=MemberQ[nl,z]) || Union[nl] =!= UnionNoSort[nl];
		If[stop, nil = If[m,Position[nl,z]//Flatten//First+f,0],
			nl = NestList[Multiplication[R][Last[nl],#]&,r,n-2f];
			stop = (m=MemberQ[nl,z]) || Union[nl] =!= UnionNoSort[nl];
			If[stop, nil = If[m,Position[nl,z]//Flatten//First+f +f,0],
				nil = 0]]];
	nil
]

NilpotentQ[R_?RingoidQ, r_] := NilpotentDegree[R,r]=!=0

IdempotentQ[R_?RingoidQ, r_] := Multiplication[R][r,r]===r

Idempotents[R_?RingoidQ] := 
	Select[Map[{#,IdempotentQ[R,#]}&,Elements[R]],Last[#]===True&]//
	Transpose//First
	
Nilpotents[R_?RingoidQ] := 
	Select[Map[{#,NilpotentQ[R,#]}&,Elements[R]],Last[#]===True&]//
	Transpose//First
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Working with elements
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
RandomElement(s)
:[font = input; initialization; preserveAspect; endGroup]
*)
randElement[{}] := {};

randElement[Dom_List]:=
       Dom[[Random[Integer,{1,Length[Dom]}]]];
       
Options[RandomElement]= {SelectFrom -> NonZero, LowerDegreeOK -> False, 
	Monic -> False, SelectBaseElementsFrom -> Any};

RandomElement[R_?RingoidQ, opts___?OptionQ]:=
	Module[{p,sel=(SelectFrom/.Flatten[{opts, Options[RandomElement]}]),
			d=Elements[R], chooseFrom, aok,mok},
		Off[Identity::lfail, Identity::rfail, Identity::fail];
		{aok,mok} = {HasZeroQ[R], WithUnityQ[R]};
		If[sel===NonZero && aok,
			chooseFrom = Complement[d, {Zero[R]}],
			If[sel===NonUnity && mok,
				chooseFrom = Complement[d, {Unity[R]}],
				If[sel===NonIdentity && aok && mok,
					chooseFrom = Complement[d, {Zero[R],Unity[R]}],
					chooseFrom = d]]];
		On[Identity::lfail, Identity::rfail, Identity::fail];
		If[chooseFrom =!= {},
			randElement[chooseFrom],
			Message[RandomElement::fail, sel]; $Failed]]

Options[RandomElements]={SelectFrom -> Any, Replacement -> True, 
	LowerDegreeOK -> False, Monic -> False, SelectBaseElementsFrom -> Any};

RandomElements[R_?RingoidQ ,n_Integer?Positive, opts___?OptionQ]:= 
	Module[{sel, rep, els=Elements[R], list, possible, aok,mok, p,s,chooseFrom},
	sel=SelectFrom/.Flatten[{opts, Options[RandomElements]}];
	rep=Replacement/.Flatten[{opts, Options[RandomElements]}];
	s = Length[els];
	{aok,mok} = {HasZeroQ[R], WithUnityQ[R]};
	If[sel===NonZero && aok,
			chooseFrom = Complement[els, {Zero[R]}];
			possible = rep || n < s,
			If[sel===NonUnity && mok,
				chooseFrom = Complement[els, {Unity[R]}];
				possible = rep || n < s,
				If[sel===NonIdentity && aok && mok,
					chooseFrom = Complement[els, {Zero[R],Unity[R]}];
					possible = rep || n < s - 1,
					chooseFrom = els;
					possible = rep || n <= s]]];
	If[possible && chooseFrom =!= {},
    	If[rep,
    		(* just find some random elements, replacement ok *)
    		list = Table[randElement[chooseFrom],{n}],
    		(* replacement not ok *)
    		p = RandomPermutation[s];
    		p = Map[els[[#]]&,p];
				If[n <= s && sel=!=NonIdentity && sel=!=NonZero && 
					sel=!=NonUnity, list = Take[p, n]];
				If[n < s && sel === NonZero,
					p = Take[p, n+1];
					id = If[HasZeroQ[R],
    				Zero[R],{}];
    			p = DeleteCases[p,id];
    			If[Length[p] == n, list = p, list = Drop[p,1]]
					];
				If[n < s && sel === NonUnity,
					p = Take[p, n+1];
					id = If[WithUnityQ[R],
    				Unity[R],{}];
    			p = DeleteCases[p,id];
    			If[Length[p] == n, list = p, list = Drop[p,1]]
					];
				If[n < s - 1 && sel === NonIdentity,
					p = Take[p, n+2];
					id = If[HasZeroQ[R],
    				Zero[R],{}];
    			p = DeleteCases[p,id];
    			id = If[WithUnityQ[R],
    				Unity[R],{}];
    			p = DeleteCases[p,id];
    			list = Take[p,n]
					]
    		]
    	];
    If[!rep,
  		If[n > s, Message[RandomElements::toomany,n,s]; list = $Failed];
   		If[n == s && (sel === NonZero || sel === NonUnity),
   				Message[RandomElements::toomanyni,n,s]; list = $Failed];
   		If[n == s-1 && sel === NonIdentity,
   				Message[RandomElement::fail, sel]; list = $Failed]];
   	If[chooseFrom === {},
   		Message[RandomElement::fail, sel]; list = $Failed];
    list
    ]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
ElementToPower (MultipleOfElement)
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
ElementToPower[R_?RingoidQ, r_, n_Integer] := 
	ElementToPower[MGroupoid[R], r, n]
	
MultipleOfElement[R_?RingoidQ, r_, n_Integer] := 
	ElementToPower[AGroupoid[R], r, n]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
CayleyTables
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[CayleyTables] := {Mode -> Computational, Operation -> Both};

CayleyTables[many:{_?RingoidQ..}, Mode -> Visual] := 
	Module[{len = Length[many], i, out},
		Do[out[i] = CayleyTables[many[[i]], Mode -> Visual], {i, len}];
		Table[out[i], {i, len}]]
		
CayleyTables[R_?RingoidQ, Operation -> Addition] := 
	CayleyTables[R, Operation -> Addition] = CayleyTable[AGroupoid[R]]
	
CayleyTables[R_?RingoidQ, Operation -> Multiplication] := 
	CayleyTables[R, Operation -> Multiplication] = CayleyTable[MGroupoid[R]]
		
CayleyTables[R_?RingoidQ]:= 
	{CayleyTable[AGroupoid[R]], CayleyTable[MGroupoid[R]]};

CayleyTables[R_?RingoidQ, Operation -> rngop_, Mode -> Visual, 
	opts___?OptionQ] := CayleyTables[R, Mode -> Visual, Operation -> rngop, opts]

CayleyTables[R_?RingoidQ, Operation -> rngop_, Mode -> Textual, 
	opts___?OptionQ] := (Message[Mode::notavail, CayleyTables, Textual];CayleyTables[R])

CayleyTables[R_?RingoidQ, Mode -> Textual, 
	opts___?OptionQ] := (Message[Mode::notavail, CayleyTables, Textual];CayleyTables[R])
	
CayleyTables[R_?RingoidQ, Mode -> Visual, opts___?OptionQ]:= 
   Module[{G,Gm, wide = MemberQ[{List,AbstractAlgebra`RingExtensions`Func,
   	AbstractAlgebra`RingExtensions`Poly},Head[R[[1,1]]]],
   ctopts = FilterOptions[CayleyTable,opts],
   gropts = FilterOptions[Graphics,opts],
   rngop = Operation/.Flatten[{opts, Options[CayleyTables]}]},
  (* find any CayleyTable  or Graphics options and pass these through *)
  G = AGroupoid[R];
  Gm = MGroupoid[R];
	ctopts = Apply[Sequence,
   	{ctopts}/.{a___,Mode->_,b___}->{a,b}];
	If[wide || AbstractAlgebra`Core`Private`WideElementsQ[R],
		AbstractAlgebra`Core`Private`WideElementsQ[G]=True;
		AbstractAlgebra`Core`Private`WideElementsQ[Gm]=True];
	(* only specify wide if we know they are - otherwise let
	basicCayley fuss over width issues *)
	If[rngop === Addition, CayleyTable[G, Mode->Visual, ctopts, gropts,
		AbstractAlgebra`Core`Private`TableName -> "("<>
		AbstractAlgebra`Core`Private`StructureName[R] <>", +)"],
		If[rngop === Multiplication, CayleyTable[Gm, Mode->Visual,
			ctopts, gropts,
			AbstractAlgebra`Core`Private`TableName -> "("<>
			AbstractAlgebra`Core`Private`StructureName[R] <>", x)"],
		CayleyTable[{{G,ctopts,gropts, AbstractAlgebra`Core`Private`TableName -> 
			"Addition"},{Gm,ShowKey -> False,
			ctopts,gropts,AbstractAlgebra`Core`Private`TableName -> "Multiplication"}},
			Mode->Visual]]]];

MultiplicationTable[R_?RingoidQ, opts___?OptionQ]:=
	CayleyTables[R, Operation -> Multiplication, opts];

CayleyTable[R_?RingoidQ, Operation -> rngop_] := 
	CayleyTables[R, Operation -> rngop]

CayleyTable[R_?RingoidQ, Operation -> rngop_, opts___?OptionQ] :=
	CayleyTables[R, Operation -> rngop, opts]

CayleyTable[R_?RingoidQ, opts1___?OptionQ, Operation -> rngop_, 
	opts2___?OptionQ] := CayleyTables[R, Operation -> rngop, opts1, opts2]

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Subrings
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[SubringQ] = {Mode->Computational};

SubringQ[S_List, R_?RingoidQ] := (RingQ[R] && Length[S] > 0 && 
	ClosedQ[R,S, Operation -> Multiplication] && ClosedDiffQ[R,S])
	
SubringQ[S_?RingoidQ, R_?RingoidQ,  opts___?OptionQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R],SubringQ[Elements[S], R,  opts],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[R]]; False],
		Message[Operation::fail]; False]
                           
SubringQ[S_List, R_?RingoidQ,  Mode -> Textual] := 
	Block[{fn=SubringQ[S,R],  tr},
		If[Length[S]>0,
			Print["Prospective subring is not empty; passes the first test."],
			Print["Prospective subring is empty; it can not be a subring."]];
		If[ClosedQ[R,S,Operation->Addition],
			Print["Prospective subring is closed with respect to addition; passes the second test."], 
			Print["Prospective subring is not closed with respect to addition; it can not be a subring."]];
		If[ClosedQ[R,S,Operation->Multiplication],
		Print["Prospective subring is closed with respect to multiplication; passes the third test."], 
		Print["Prospective subring is not closed with respect to multiplication; it can not be a subring."]];
        fn]
        
 SubringQ[S_List, R_?RingoidQ, Mode -> Visual] := Message[Mode::novis]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Ideals
:[font = input; initialization; preserveAspect; endGroup]
*)
	LeftIdealQ[S_List, R_?RingoidQ] := 
	If[SubringQ[S,R],
		SubsetQ[Union[Map[Apply[Multiplication[R],#]&,
			CartesianProduct[Elements[R],S]]],S],
		Message[Ring::subringfail,S];False]

LeftIdealQ[S_?RingoidQ, R_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], LeftIdealQ[Elements[S], R],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; False],
		Message[Operation::fail]; False]
	
RightIdealQ[S_List, R_?RingoidQ] := 
	If[SubringQ[S,R],
		SubsetQ[Union[Map[Apply[Multiplication[R],#]&,
			CartesianProduct[S,Elements[R]]]],S],
		Message[Ring::subringfail,S];False]

RightIdealQ[S_?RingoidQ, R_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], RightIdealQ[Elements[S], R],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; False],
		Message[Operation::fail]; False]
		
IdealQ[S_List, R_?RingoidQ] := If[LeftIdealQ[S,R],RightIdealQ[S,R],
	False]

IdealQ[S_?RingoidQ, R_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], IdealQ[Elements[S], R],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; False],
		Message[Operation::fail]; False]
		
PrincipalIdeal[R_?RingoidQ,r_] := If[CommutativeQ[R] && WithUnityQ[R],
	FormRingoid[Map[Multiplication[R][r,#]&,Elements[R]]//Union,
		Addition[R],Multiplication[R],
		AbstractAlgebra`Core`Private`GatherRingoidOptions[R]],
	Message[IdealQ::fail]; $Failed]

PrincipalIdeal[R_?RingoidQ, S_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], PrincipalIdeal[R, Elements[S]],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; $Failed],
		Message[Operation::fail]; $Failed]
		
PrimeIdealQ[S_List, R_?RingoidQ] := Module[{ok},
	If[ElementsQ[S,R],
		If[CommutativeQ[R] && WithUnityQ[R],
			Off[QuotientRing::NS];
			ok = If[ProperSubsetQ[S, Elements[R]],
				IntegralDomainQ[QuotientRing[R,S]], False];
			On[QuotientRing::NS]; ok,
		Message[IdealQ::fail];False],
	Message[MemberQ::elmnts, S, AbstractAlgebra`Core`Private`StructureName[R]]; $Failed]]

PrimeIdealQ[S_?RingoidQ, R_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], PrimeIdealQ[Elements[S], R],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; False],
		Message[Operation::fail]; False]
			
MaximalIdealQ[S_?RingoidQ, R_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], MaximalIdealQ[Elements[S],R],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; False],
		Message[Operation::fail]; False]

MaximalIdealQ[S_List, R_?RingoidQ] := Module[{ok},
	If[ElementsQ[S,R],
		If[CommutativeQ[R] && WithUnityQ[R],
			Off[QuotientRing::NS];
			ok = If[ProperSubsetQ[S, Elements[R]],
				FieldQ[QuotientRing[R,S]], False];
			On[QuotientRing::NS]; ok,
		Message[IdealQ::fail];False],
	Message[MemberQ::elmnts, S, AbstractAlgebra`Core`Private`StructureName[R]]; $Failed]]
			
(* Annihilator[R_?RingoidQ,S_List] := 
	If[CommutativeQ[R] && SubsetQ[S, Elements[R]],
		FormRingoid[Map[First,Select[Transpose[{Elements[R],
			Map[(Apply[Multiplication[R],#,2]//Union)&,
			CartesianProduct[Elements[R],S,
			Partition->True]]}], 
			(#[[2]]=={Zero[R]})&]], Addition[R], Multiplication[R],
			AbstractAlgebra`Core`Private`GatherRingoidOptions[R]],$Failed]*)
			
Annihilator[R_?RingoidQ, S_List] :=
		Module[{els},
	els=Map[First,Select[Transpose[{Elements[R],
                        Map[(Apply[Multiplication[R],#,1]//Union)&,
                        CartesianProduct[Elements[R],S,
                        Partition->True]]}],
                        (#[[2]]=={Zero[R]})&]];
        If[CommutativeQ[R] && SubsetQ[S, Elements[R]],
                FormRingoid[els, Addition[R], Multiplication[R],
AbstractAlgebra`Core`Private`GatherRingoidOptions[R]],$Failed]]

Annihilator[R_?RingoidQ, S_?RingoidQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		If[RingQ[R], Annihilator[R, Elements[S]],
			Message[Ring::fail, AbstractAlgebra`Core`Private`StructureName[S]]; $Failed],
		Message[Operation::fail]; $Failed]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Factor/quotient ring
:[font = input; initialization; preserveAspect; endGroup]
*)
LeftCoset[R_?RingoidQ, H_List, r_] := LeftCoset[AGroupoid[R], H, r]

LeftCoset[R_?RingoidQ, H_List, r_, LeftMeans -> lm_] := 
	LeftCoset[AGroupoid[R], H, r, LeftMeans -> lm]
	
LeftCoset[R_?RingoidQ, H_List, r_, opts___?OptionQ] := 
	LeftCoset[AGroupoid[R], H, r, opts]

LeftCoset[R_?RingoidQ, S_?RingoidQ, other__] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		LeftCoset[R, Elements[S], other],
		Message[Operation::fail]; $Failed]
			
RightCoset[R_?RingoidQ, H_List, r_] := RightCoset[AGroupoid[R], H, r]

RightCoset[R_?RingoidQ, H_List, r_, LeftMeans -> lm_] := 
	RightCoset[AGroupoid[R], H, r, LeftMeans -> lm]
	
RightCoset[R_?RingoidQ, H_List, r_, opts___?OptionQ] := 
	RightCoset[AGroupoid[R], H, r, opts]

RightCoset[R_?RingoidQ, S_?RingoidQ, other__] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		RightCoset[R, Elements[S], other],
		Message[Operation::fail]; $Failed]
			
LeftCosets[R_?RingoidQ, H_List] := LeftCosets[AGroupoid[R], H]

LeftCosets[R_?RingoidQ, H_List, LeftMeans -> lm_] := 
	LeftCosets[AGroupoid[R], H, LeftMeans -> lm]
	
LeftCosets[R_?RingoidQ, H_List, Operation -> Multiplication, Mode -> Visual] := 
	AbstractAlgebra`Joint`Private`BothCosetsVisual[MultiplicativeGroupoid[R],H,
	LeftCosets[AdditiveGroupoid[R],H]]
	
LeftCosets[R_?RingoidQ, H_List, Mode -> Visual, Operation -> Multiplication] := 
	LeftCosets[R, H, Operation -> Multiplication, Mode -> Visual]

LeftCosets[R_?RingoidQ, H_List, opts___?OptionQ] := 
	LeftCosets[AGroupoid[R], H, opts]

LeftCosets[R_?RingoidQ, S_?RingoidQ, other___] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		LeftCosets[R, Elements[S], other],
		Message[Operation::fail]; $Failed]
			
RightCosets[R_?RingoidQ, H_List] := RightCosets[AGroupoid[R], H]

RightCosets[R_?RingoidQ, H_List, LeftMeans -> lm_] := 
	RightCosets[AGroupoid[R], H, LeftMeans -> lm]

RightCosets[R_?RingoidQ, H_List, Operation -> Multiplication, Mode -> Visual] := 
	AbstractAlgebra`Joint`Private`BothCosetsVisual[MultiplicativeGroupoid[R],H,
	RightCosets[AdditiveGroupoid[R],H]]
	
RightCosets[R_?RingoidQ, H_List, Mode -> Visual, Operation -> Multiplication] := 
	RightCosets[R, H, Operation -> Multiplication, Mode -> Visual]

RightCosets[R_?RingoidQ, H_List, opts___?OptionQ] := 
	RightCosets[AGroupoid[R], H, opts]

RightCosets[R_?RingoidQ, S_?RingoidQ, other___] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		RightCosets[R, Elements[S], other],
		Message[Operation::fail]; $Failed]
			
Index[R_?RingoidQ, H_List, opts___?OptionQ] :=
	Index[AGroupoid[R], H, opts]

Index[R_?RingoidQ, S_?RingoidQ, other___] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		Index[R, Elements[S], other],
		Message[Operation::fail]; $Failed]
			
CosetToList[QR_?RingoidQ, coset_] := Module[{QG,R,S, form},
	R = Qnum /. QR[[4,5]];
	S = Qden /. QR[[4,5]];
	form = Qform /. QR[[4,5]];
	QG = QuotientGroup[AGroupoid[R], S, Form -> form,
		AbstractAlgebra`Joint`Private`ShowMessage -> False];
	CosetToList[QG, coset]]
	
FactorRing[args___] := QuotientRing[args]

Options[QuotientRing] = {Mode -> Computational, 
	Form -> Cosets, 
	Representatives -> Canonical, SizeLimit->50, Staged -> False};

QuotientRing[R_?RingoidQ, S_?RingoidQ, opts___?OptionQ] :=
	If[Addition[R] === Addition[S] && Multiplication[R]===Multiplication[S],
		QuotientRing[R, Elements[S], opts],
		Message[Operation::fail]; $Failed]

QuotientRing[R_?RingoidQ, S_List, opts___?OptionQ] :=
	Module[{cosets,reps,mymode,sc,form,repmethod,QR,els,
		id,ok=True,rands, AG = AGroupoid[R], MG = MGroupoid[R], QG},
If[IdealQ[S,R],
	QG = QuotientGroup[AG, S, opts, 
		AbstractAlgebra`Joint`Private`ShowMessage -> False];
If[QG =!= $Failed,
	els = Elements[QG];
	cosets = AbstractAlgebra`Joint`Private`cosetlist /. QG[[3,5]];
	reps = AbstractAlgebra`Joint`Private`cosetreps /. QG[[3,5]];
	form = Form/.Flatten[{opts, Options[QuotientRing]}];
	If[form === Representatives,
		QR = FormRingoid[reps, 
		AbstractAlgebra`Joint`Private`QGRepProd[AG,cosets,#1,#2,reps]&,
			AbstractAlgebra`Joint`Private`QGRepProd[MG,cosets,#1,#2,reps]&, 
			RingoidName -> RingoidName[R]<>"/NS", IsARing -> True, 
			AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{Zero[R], Unity[R]},
			{},{},{cosetlist -> cosets,
			cosetreps -> reps, Qnum -> R, Qden -> S, Qform -> form}}]];
	If[form === CosetLists,
		QR = FormRingoid[cosets, 
			AbstractAlgebra`Joint`Private`QGListProd[AG,cosets,#1,#2,reps]&,
			AbstractAlgebra`Joint`Private`QGListProd[MG,cosets,#1,#2,reps]&, 
			RingoidName -> RingoidName[R]<>"/NS", IsARing -> True,
			AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{LeftCoset[R,S,Zero[R]], 
			LeftCoset[R,S,Unity[R]]},{},{},
			{cosetlist -> cosets, cosetreps -> reps, Qnum -> R, Qden -> S, Qform -> form}}]];
	If[form === Cosets,
		QR = FormRingoid[els, 
			AbstractAlgebra`Joint`Private`QGCosetSum[AG,cosets,#1,#2,reps]&,
			AbstractAlgebra`Joint`Private`QGCosetSum[MG,cosets,#1,#2,reps]&, 
			RingoidName -> RingoidName[R]<>"/NS", KeyForm -> OutputForm, 
			IsARing -> True, WideElements -> True,
			AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{NS, Unity[R] + NS},{},{},
			{cosetlist -> cosets, cosetreps -> reps, Qnum -> R, Qden -> S, Qform -> form}}];
			If[MessageCount[QuotientRing,NS]++ < 5, Message[QuotientRing::NS,S]]]];
	If[Head[QR]===AbstractAlgebra`Core`Private`ringoid, QR, $Failed],
	Message[QuotientRing::notideal,S,
		AbstractAlgebra`Core`Private`StructureName[R]];$Failed]]
		
MessageCount[QuotientRing,NS] = 0;
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Other
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Solution of Equations
:[font = input; initialization; preserveAspect; endGroup]
*)
RingSolve[R_?RingoidQ, a_, b_] :=
    Select[Elements[R], (Multiplication[R][a,#]==b)&]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Z[I]/<a+bI> code
:[font = input; initialization; preserveAspect; endGroup]
*)
IntegerLatticeGrid[{a_Integer,b_Integer},{c_Integer,d_Integer},
	opts___?OptionQ] := Module[{pts},
	pts = Table[{i,j},{i,a,b},{j,c,d}]//Flatten[#,1]&;
	ListPlot[pts,opts]]

SortByPosXAxis[{}] = {};

SortByPosXAxis[pts_List] := Map[{Abs[N[Arg[#]]],#}&,pts]//Sort//
	Transpose//Last
	
RectangleOfLatticePoints[{xmin_Integer,xmax_Integer},{ymin_Integer,ymax_Integer}] := 
	pts = Table[{i,j},{i,xmin,xmax},{j,ymin,ymax}]//Flatten[#,1]&

distance[{a_,b_},{c_,d_}] := Sqrt[(a-c)^2 + (b-d)^2]

slope[{a_,b_},{c_,d_}] := (d-b)/(c-a)

ComplexToPoint[z_] := {Re[z],Im[z]}

CircleOfLatticePoints[{xCent_Integer,yCent_Integer}, rad_] := 
		Module[{rd = Floor[rad]+1, pts},
	pts = RectangleOfLatticePoints[{xCent - rd, xCent + rd},{yCent - rd, yCent + rd}];
	Select[pts, (N[distance[#, {xCent, yCent}]] <= rad) &]
	]

CircleOfLatticePoints[{xCent_Integer,yCent_Integer}, rad_, {theta1_, theta2_}] := 
		Module[{pts, arg, out},
	pts = CircleOfLatticePoints[{xCent, yCent},rad];
	Off[Arg::indet];
	out = Select[pts, (((arg = N[Arg[Complex@@#]])>= N[theta1]) && 
		(arg <= N[theta2])) &];
	out]

makeSquare[c_] := Module[{x = Re[c], y = Im[c],
	A, B, C, O},
	A = {x,y};
	C = {{0, 1}, {-1,0}}.A;
	B = C + A;
	O = {0,0};
	{O,A, B, C, O}]
	
Stretch[x_] := If[x < 0, Floor[x], Ceiling[x]]

makeSquares[c_, window_List] := Module[{x = Re[c], y = Im[c], xl,xr, 
		yd,yu, len, C, lnpts},
	len = N[Abs[c] Sqrt[2]];
	C = {{0, -1},{1,0}}.{x,y};
	{{xl, xr}, {yd, yu}} = window/len;
	{{xl, xr}, {yd, yu}} = Map[Stretch, {{xl, xr}, {yd, yu}}, {2}];
	lnpts = Table[Map[i {x,y} + j C + #&, makeSquare[c]], {i, xl, xr}, 
		{j, yd, yu}]//Flatten[#, 1]&;
	Graphics[Map[Line, lnpts, {1}]]
	]

drawSquare[c_] := Graphics[Line[makeSquare[c]]]

(* The following few functions are from Stan Wagon's 'Mathematica
in Action' book, pages 334, 335 (in first edition with Freeman) *)

Orientation[{{x1_,y1_}, {x2_,y2_}, {x3_,y3_}}] :=
	Sign[Chop[Det[{{x1,y1,1}, {x2,y2,1}, {x3,y3,1}}]]]

LeftOf[p_, q_, r_] := Orientation[{p, q, r}] == 1 

norm[p_] := N[Sqrt[p.p]]

Between[p_, q_, r_] := Orientation[{p, q, r}] == 0 &&
	       (r-p) . (q-p) >= 0 && norm[r-p] <= norm[q-p]

IntersectQ[{a_, b_}, {c_, d_}] :=  
	 (LeftOf[a,b,c] ~Xor~ LeftOf[a,b,d]) &&
	 (LeftOf[c,d,a] ~Xor~ LeftOf[c,d,b])     ||
	 
	 Between[a,b,c] || Between[a,b,d]  ||
	 Between[c,d,a] || Between[c,d,b]
	 
(* end of contribution from Stan Wagon *)

SortByArg[{}] = {};

SortByArg[pts_List] := Module[{out},
	Off[Arg::indet];
	out = Map[{If[N[Arg[#]]<0, N[Arg[#] + 2Pi],N[Arg[#]]],#}&,pts]//Sort//
		Transpose//Last;
	out]

LatticePointsInSquare[c_] := Module[{x,y, sq, th1, th2, slp, pts, a, b, inside,
			notsure, p2, p3, p4, l1, l2},
	{x, y} = ComplexToPoint[c];
	sq = makeSquare[c];
	{p2, p3, p4} = sq[[{2,3,4}]];
	l1 = {p2, p3}; l2 = {p3, p4};
	Off[Power::infy];
	slp = slope[sq[[1]], p2];
	Off[Arg::indet];
	th2 = Arg[c]//N;
	slp = slope[sq[[1]], p4];
	th1 = Arg[Complex@@{Im[c],-Re[c]}]//N;
	pts = If[th1 > th2, Join[CircleOfLatticePoints[{0,0},N[Sqrt[2] Abs[c]], 
		{th1, Pi}], CircleOfLatticePoints[{0,0},N[Sqrt[2] Abs[c]], 
		{-Pi, th2}]], CircleOfLatticePoints[{0,0},N[Sqrt[2] Abs[c]], 
		{th1, th2}]];
	inside = Select[pts, N[distance[#,{0,0}]] <= N[Abs[c]]&];
	notsure = Complement[pts, inside];
	pts = Join[inside, Select[notsure, (((!IntersectQ[l1, {{0,0},#}]) && 
		(!IntersectQ[l2, {{0,0},#}])) || Between[p2,p3,#] || Between[p3,p4,#])&]];
	On[Power::infy];
	Join[{{0,0}},DeleteCases[SortByArg[pts],{0,0}]] (* to adjust for {0,0} in middle *)
]

CalculateZICosets[z_, {{a_, b_}, {c_, d_}}] := CalculateZICosets[z, {{a,b},{c,d}}] =
	Module[{J,gr,g,rep,starting, cstarting,
	remaining,Iremaining,pts,cpts,done = False,iter = 0},
starting = LatticePointsInSquare[z];
cstarting = Map[Apply[Complex,#]&,starting];
pts = RectangleOfLatticePoints[{a,b},{c,d}];
cpts = Map[Apply[Complex,#]&,pts];
J[0] = Intersection[cpts,z cpts];
rep[iter++] = 0;
Iremaining = ComplementNoSort[cstarting, Intersection[J[0],cstarting]]//SortByArg;
While[!done,
	rep[iter] = First[Iremaining];
	J[iter] = Intersection[cpts, rep[iter] + J[0]];
	Iremaining = ComplementNoSort[Iremaining,
		Intersection[cstarting,J[iter++]]]//SortByArg;
	done = Iremaining == {}];
Table[{rep[k],J[k]},{k,0,iter-1}]//Transpose]

ZICosetReps[z_] := CalculateZICosets[z, FindGoodWindow[z]][[1]]

DetermineOneZICoset[z_, rep_, {{a_, b_}, {c_, d_}}] := 
		OneZICosetWork[z, rep, {{a,b},{c,d}}]//Last

OneZICosetWork[z_, rep_, {{a_, b_}, {c_, d_}}] := 
	OneZICosetWork[z, rep, {{a,b},{c,d}}] = 
		Module[{reps, cosets,nums, pos, repQ},
	{reps, cosets} = CalculateZICosets[z, {{a,b},{c,d}}];
	{repQ, pos} = If[MemberQ[reps, rep], {True, Position[reps, rep,{1}]},
		{False, Position[cosets, rep]}];
	nums = If[pos =!= {}, cosets[[First[Flatten[pos]]]],
		$Failed];
	If[repQ, {1, nums}, {pos, nums}]]

OneZICosetGraphics[z_, rep_, {{a_, b_}, {c_, d_}}, width_:0.02] := 
		Module[{pos,coset, len},
	len = Abs[z]^2;
	{pos, coset} = OneZICosetWork[z, rep, {{a,b},{c,d}}];
	Graphics[{PointSize[width], Hue[pos/len], (* not the right color *)
		Map[Point[ComplexToPoint[#]]&, coset]}]]

DotSize[n_] := Which[n<13, .04, n < 15, .035, n<17, .03, n<21, .025, n<26, .02,
	n>25, .015];
	
AllZICosetGraphics[z_, reps_, {{a_, b_}, {c_, d_}}, width_:0.02] := 
		Module[{pos,coset, len, size = Length[reps], wd},
	wd = If[width == 0.02, 0.02, DotSize[n]];
	{Graphics[{Thickness[0.015],Line[makeSquare[z]], Table[
	{pos, coset} = OneZICosetWork[z, reps[[i]], {{a,b},{c,d}}];
	{PointSize[width], Hue[i/size], Map[Point[ComplexToPoint[#]]&, coset]},
	{i,size}]}], makeSquares[z,{{a,b},{c,d}}]}]

PartialZICosetGraphics[z_, reps_, n_, {{a_, b_}, {c_, d_}}, width_:0.02] := 
		Module[{pos,coset, len, size = Length[reps], wd},
	wd = If[width == 0.02, 0.02, DotSize[n]];
	{Graphics[{Thickness[0.015],Line[makeSquare[z]], Table[
	{pos, coset} = OneZICosetWork[z, reps[[i]], {{a,b},{c,d}}];
	{PointSize[width], Hue[i/size], Map[Point[ComplexToPoint[#]]&, coset]},
	{i,n}]}], makeSquares[z,{{a,b},{c,d}}]}]

ZICosetsVisual[z_, {{a_, b_}, {c_, d_}}] := 
		Module[{extra = Abs[z]^2,reps},
	reps = CalculateZICosets[z, {{a-extra, b+extra},{c-extra,d+extra}}]//First;
	Show[AllZICosetGraphics[z, reps, {{a-extra, b+extra},{c-extra,d+extra}},DotSize[extra]],
		Axes -> True, PlotRange -> {{a,b},{c,d}}, Frame -> True]]

QuotientRingVisualAll[z_,n_,opts___?OptionQ] := Module[{i},
	QuotientRingVisualStaged[z, opts];
	Do[NextStage[QuotientRing],{i,2,n}]]

QuotientRingVisualStaged[z_,opts___?OptionQ] := 
Module[{i, reps, n, wd,extra = Abs[z]^2, a, b, c, d},
	{{a,b},{c,d}} = FindGoodWindow[z];
	reps = CalculateZICosets[z, {{a-extra, b+extra},{c-extra,d+extra}}]//First;
	n = Length[reps];
	wd = DotSize[n];
	Do[QuotientRingVisualStagedSlide[i] = 
		Show[PartialZICosetGraphics[z,reps, i, {{a-extra, b+extra},
			{c-extra,d+extra}}, wd], DisplayFunction -> 
		Identity,opts, Axes -> True, PlotRange -> {{a,b},{c,d}}, Frame -> True],{i, n}];
	TotalStages[QuotientRing] = n;
	CurrentStage[QuotientRing] = 1;
	Show[QuotientRingVisualStagedSlide[1],
		DisplayFunction -> $DisplayFunction]]

NextStage[QuotientRing] := (CurrentStage[QuotientRing]++;
	If[CurrentStage[QuotientRing] <= TotalStages[QuotientRing],
		Show[QuotientRingVisualStagedSlide[CurrentStage[QuotientRing]],
			DisplayFunction -> $DisplayFunction],
		Show[QuotientRingVisualStagedSlide[1],
			DisplayFunction -> $DisplayFunction];
			CurrentStage[QuotientRing]=1];)
			
PreviousStage[QuotientRing] := (CurrentStage[QuotientRing]--;
	If[CurrentStage[QuotientRing] > 0,
		Show[QuotientRingVisualStagedSlide[CurrentStage[QuotientRing]],
			DisplayFunction -> $DisplayFunction],
		CurrentStage[QuotientRing]=TotalStages[QuotientRing];
		Show[QuotientRingVisualStagedSlide[TotalStages[QuotientRing]],
			DisplayFunction -> $DisplayFunction]];)

FindGoodWindow[z_] := FindGoodWindow[z] = 
	Module[{sq = makeSquare[z], len = Abs[z]},
	{x,y} = sq[[3]]/2;
	{{Ceiling[N[x - 2 len]], Ceiling[N[x + 2 len]]},
		{Ceiling[N[y - 2 len]],Ceiling[N[y + 2 len]]}}]

ZICosetsVisual[z_] := 
	ZICosetsVisual[z, FindGoodWindow[z]]
	
Unprotect[Z];

Z[I] = "Z[I]";

Protect[Z];

QuotientRing["Z[I]", z_, opts___?OptionQ] :=
	Module[{cosets,reps,mymode,sc,form,repmethod,els, staged, 
		id,ok=True,rands, QG},
mymode = Mode/.Flatten[{opts, Options[QuotientRing]}];
staged = Staged/.Flatten[{opts, Options[QuotientRing]}];
If[N[Abs[z]] > 1 && IntegerQ[Re[z]] && IntegerQ[Im[z]],
	{reps, cosets} = CalculateZICosets[z, FindGoodWindow[z]];
	If[mymode === Visual, Switch[staged,
		False, ZICosetsVisual[z],
		All, QuotientRingVisualAll[z, Length[reps]],
		True, QuotientRingVisualStaged[z]]];
	form = Form/.Flatten[{opts, Form -> Cosets}];
	If[form === Representatives,
		QR = FormRingoid[reps, ZICosetSum[z,#1, #2]&, ZICosetProduct[z,#1, #2]&,
			RingoidName -> "Z[I]/<"<>ToString[z]<>">", WideElements -> True]];
	If[form === Cosets,
		reps = Map[#+J&, reps];
		QR = FormRingoid[reps, ZICosetSum[z,#1, #2]&, ZICosetProduct[z,#1, #2]&,
			RingoidName -> "Z[I]/<"<>ToString[z]<>">", WideElements -> True];
			If[MessageCount[QuotientRing,j]++ < 5, Message[QuotientRing::J,z]]];
	If[Head[QR]===AbstractAlgebra`Core`Private`ringoid, QR, $Failed],
	Message[QuotientRing::badz,z];$Failed]]
	
MessageCount[QuotientRing,j] = 0;

ZICosetProduct[zPIgen_, (z1_:0) + J, (z2_:0) + J] :=
	ZICosetProduct[zPIgen, z1, z2] + J

ZICosetSum[zPIgen_, (z1_:0) + J, (z2_:0) + J] :=
	ZICosetSum[zPIgen, z1, z2] + J
	
ZICosetProduct[zPIgen_, J + (z1_:0), J + (z2_:0)] :=
	J + ZICosetProduct[zPIgen, z1, z2]

ZICosetSum[zPIgen_, J + (z1_:0), J + (z2_:0)] :=
	J + ZICosetSum[zPIgen, z1, z2]

ZICosetProduct[zPIgen_, (z1_:0), (z2_:0)] :=
	Module[{pr = z1 z2, searchlist,cosets},
	cosets = ZICosetReps[zPIgen];
	searchlist = Map[Simplify[(pr-#)/(zPIgen)]&,cosets];
	cosets[[(Position[searchlist,_?GaussianIntegerQ]//Flatten)[[1]]]]
]

ZICosetSum[zPIgen_, (z1_:0), (z2_:0)] :=
	Module[{sum = z1+z2, searchlist,cosets},
	cosets = ZICosetReps[zPIgen];
	searchlist = Map[Simplify[(sum-#)/(zPIgen)]&,cosets];
	cosets[[(Position[searchlist,_?GaussianIntegerQ]//Flatten)[[1]]]]
]

GaussianIntegerQ[z_] := IntegerQ[z] || (Head[z]===Complex &&
	IntegerQ[Re[z]] && IntegerQ[Im[z]])
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Misc.
:[font = input; initialization; preserveAspect; endGroup]
*)
DirectProduct[R_?RingoidQ, Rs__] := Module[{factorsAreRings,numgrps = Length[{R,Rs}]},
  If[Apply[And,Map[RingoidQ,{R, Rs}]],
  	factorsAreRings = Apply[And,Map[RingQ,{R, Rs}]];
    FormRingoid[Distribute[Elements/@{R,Rs},List],
    	MapThread[(#1[#2,#3])&, {Addition/@{R,Rs},#1,#2}]&,
   	 MapThread[(#1[#2,#3])&, {Multiplication/@{R,Rs},#1,#2}]&,
    	RingoidName -> Apply[StringJoin,Transpose[{Map[RingoidName,{R,Rs}],
		Table[" x ",{numgrps}]}]//Flatten//Drop[#,-1]&],
   	 WideElements -> True, IsARing -> If[factorsAreRings, True, False]],
  Message[DirectProduct::ArgErr]]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
working with polynomials
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
RationalRootCandidates[expr_] := 
  Module[{cl, cand,var,ok}, 
  	var = Variables[expr];
		ok = Length[var]==1;
		If[Not[ok],$Failed,
			cl = CoefficientList[expr, var]; 
    	cand = Union[Flatten[Outer[Divide, Divisors[First[cl]], 
        Divisors[Last[cl]]]]]; cand = Union[cand, -cand]]]
        
RationalRootTheorem[expr_] := 
  Module[{cand, vals, a, b, pairs, T, F,var,ok},
  	var = Variables[expr];
		ok = Length[var]==1;
		If[Not[ok],$Failed,
			var = First[var];
  		cand = RationalRootCandidates[expr]; 
    	vals = expr /. var :> cand; 
   	 pairs = Transpose[{cand, vals}] /. 
     	 {{a_, 0} :> {a, True}, 
       {a_, (b_)?NumberQ} :> {a, False}}; 
    	T = Select[pairs, #1[[2]] === True & ] /. 
      {a_, True} :> a; 
    	F = Select[pairs, #1[[2]] === False & ] /. {a_, False} :> a;
 {T, F}]]

dividesQ[a_Integer, b_Integer] := IntegerQ[b/a]

EisensteinsCriterionQ[zpoly_] := Module[{var, ok, coef, npoly, gcd, primes,fi},
	var = Variables[zpoly];
	ok = Length[var]==1;
	coef = CoefficientList[zpoly, var];
	If[ok, 
		var = First[var];
		coef = CoefficientList[zpoly, var];
		gcd = GCD[Sequence@@coef];
		npoly = If[Head[gcd]===Rational, Expand[1/gcd zpoly], zpoly];
		coef = CoefficientList[npoly, var];
		gcd = GCD[Sequence@@Drop[coef, -1]];
		fi = FactorInteger[gcd];
		ok = If[fi =!= {}, True, False];
		If[ok, 
			primes = fi//Transpose//First;
			ok = Or@@Map[(Not[dividesQ[#,Last[coef]]] && Not[dividesQ[#^2, 
				First[coef]]]) &,primes]]];
	ok]

EisensteinsCriterionQ[zpoly_, Mode -> Textual] := 
		Module[{var, ok, coef, npoly, gcd, primes,fi, lenpr, i, pr},
	var = Variables[zpoly];
	ok = Length[var]==1;
	If[ok, 
		var = First[var];
		coef = CoefficientList[zpoly, var];
		gcd = GCD[Sequence@@coef];
		npoly = If[Head[gcd]===Rational, 
			Print["Typically, Eisenstein's Criterion requires the polynomial "<>
			"to have integer coefficients, but the polynomial entered will be "<>
			"irreducible if the following is also: "<>
				ToString[Expand[1/gcd zpoly]//StandardForm]];
			If[$VersionNumber < 2.5, Print[" "]];
			Expand[1/gcd zpoly], zpoly];
		coef = CoefficientList[npoly, var];
		gcd = GCD[Sequence@@Drop[coef, -1]];
		fi = FactorInteger[gcd];
		ok = If[fi =!= {}, True, False];
		If[ok, 
			primes = fi//Transpose//First;
			lenpr = Length[primes];
			Print["The coefficients to consider (from low degree to high degree) are: "<>
				ToString[coef]];
			If[$VersionNumber < 2.5, Print[" "]];
			Do[
				pr = primes[[i]];
				Print[ToString[pr]<>" is a prime that divides all of the first n-1 coefficients."];
				If[$VersionNumber < 2.5, Print[" "]];
				Print["Is it true that "<>ToString[pr]<> " does not divide "<>
					ToString[Last[coef]]<>"?" <>If[$VersionNumber >2.5,
		" \[Rule] "," -> "]<>ToString[Not[dividesQ[pr,Last[coef]]]]];
				If[$VersionNumber < 2.5, Print[" "]];
				Print["Is it true that "<>ToString[pr^2]<> " does not divide "<>
					ToString[First[coef]]<>"?" <>If[$VersionNumber >2.5,
		" \[Rule] "," -> "]<>ToString[Not[dividesQ[pr^2,First[coef]]]]];
				If[$VersionNumber < 2.5, Print[" "]];
				Print["Therefore, "<>ToString[pr]<>If[Not[dividesQ[pr,Last[coef]]]&&
					Not[dividesQ[pr^2,First[coef]]]," is a prime that illustrates the "<>
					"polynomial is irreducible.", " is a prime that does not satisfy "<>
					"the hypotheses of Eisenstein's Criterion."]];
				If[$VersionNumber < 2.5, Print[" "]];,
				{i,lenpr}];
			ok = Or@@Map[(Not[dividesQ[#,Last[coef]]] && Not[dividesQ[#^2, 
				First[coef]]]) &,primes],
			Print["The gcd of the coefficients (ignoring leading one) is 1; "<>
			"the hypotheses of Eisenstein's Criterion are not satisfied."]],
		Print["This function can only test polynomials in a single variable."]];
	ok]
	

ModpIrreducibilityQ[zpoly_, max_Integer?Positive:25] := 
		Module[{var, ok, coef, npoly, gcd,lcv = 0, done = False, p, pzpoly,
			dego, degn},
	var = Variables[zpoly];
	coef = CoefficientList[zpoly, var];
	ok = Length[var]==1 && (dego = First[Exponent[zpoly, var]]) >= 1 &&
		And@@Map[Head[#]===Rational || Head[#]===Integer&, coef];
	If[ok, 
		var = First[var];
		gcd = GCD[Sequence@@coef];
		npoly = If[Head[gcd]===Rational, Expand[1/gcd zpoly], zpoly];
		coef = CoefficientList[npoly, var];
		While[Not[done],
			lcv++;
			p = Prime[lcv];
			pzpoly = PolynomialMod[zpoly, p];
			degn = Exponent[pzpoly, var];
			If[degn =!= dego, ok = False,
				ok = IrreducibleListQ[FactorList[pzpoly, Modulus -> p],p]];
			done = ok || lcv > max
			],
		Message[ModpIrreducibilityQ::badpoly, zpoly]];
	ok]

ModpIrreducibilityQ[p_?PrimeQ, zpoly_] := 
		Module[{var, ok, coef, npoly, gcd,lcv = 0, done = False, pzpoly, max = 25,
			dego, degn},
	var = Variables[zpoly];
	coef = CoefficientList[zpoly, var];
	ok = Length[var]==1 && (dego = First[Exponent[zpoly, var]]) >= 1 &&
		And@@Map[Head[#]===Rational || Head[#]===Integer&, coef];
	If[ok, 
		var = First[var];
		gcd = GCD[Sequence@@coef];
		npoly = If[Head[gcd]===Rational, Expand[1/gcd zpoly], zpoly];
		coef = CoefficientList[npoly, var];
		pzpoly = PolynomialMod[zpoly, p];
		degn = Exponent[pzpoly, var];
		If[degn =!= dego, Message[ModpIrreducibilityQ::baddeg,p];
			ok = $Failed,
				ok = IrreducibleListQ[FactorList[pzpoly, Modulus -> p],p]],
		Message[ModpIrreducibilityQ::badpoly, zpoly]];
	ok]
	
	IrreducibleListQ[flist_List, p_] := (Length[flist] == 1 && Last[First[flist]] == 1) ||
		(Length[flist] == 2 && Last[Last[flist]] == 1 && MemberQ[Range[0,p-1],flist[[1,1]]])
	
	ModpIrreducibilityQ[zpoly_, Mode -> Textual] := 
		Module[{var, ok, coef, npoly, gcd,lcv = 0, done = False, p, pzpoly, max = 25,fp,
			dego, degn, ratQ},
	var = Variables[zpoly];
	coef = CoefficientList[zpoly, var];
	ok = Length[var]==1 && (dego = First[Exponent[zpoly, var]]) >= 1 &&
		And@@Map[Head[#]===Rational || Head[#]===Integer&, coef];
	If[ok, 
		var = First[var];
		gcd = GCD[Sequence@@coef];
		npoly = If[(ratQ = Head[gcd]===Rational), Expand[1/gcd zpoly], zpoly];
		coef = CoefficientList[npoly, var];
		If[ratQ,
			Print["Modifying the polynomial with rational coefficients to integer
coefficients results in ",npoly,"."]];
			If[$VersionNumber < 2.5, Print[" "]];
		While[Not[done],
			lcv++;
			p = Prime[lcv];
			pzpoly = PolynomialMod[npoly, p];
			Print["When the coefficients are reduced mod "<>ToString[p]<>
				", this polynomial becomes ",
				pzpoly,"."];
			If[$VersionNumber < 2.5, Print[" "]];
			degn = Exponent[pzpoly, var];
			If[degn =!= dego, ok = False,
				ok = IrreducibleListQ[FactorList[pzpoly, Modulus -> p],p]];
			If[ok,
				Print["Since this modified polynomial is irreducible over Z["<>ToString[p]<>
				"], then the original is irreducible over Q by the Mod p Irreducibility Test."],
				Print["Factoring over Z["<>ToString[p]<>"], we obtain ",Factor[pzpoly,Modulus -> p],
				" Since this modified polynomial is not irreducible or does not have
the same degree as the original, we try the next prime."]];
			done = ok || lcv > max;
			If[done && Not[ok], If[$VersionNumber < 2.5, Print[" "]];
				Print["After trying the first 25 primes, we have not been
able to show that the polynomial is irreducible."]]
			];
		];
	ok] (*max_Integer?Positive:25*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Wrapup AbstractAlgebra`RingProperties
:[font = input; initialization; preserveAspect]
*)
End[];

(* Protect[J]; *)

EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
