(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 2. Determining the symmetry group of a given figure
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
Though not absolutely necessary, it would be useful if you completed Group Lab 1 before attempting this lab.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 539; startGroup]
2.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
In this lab, we will continue to look at symmetries. This will resume where Lab One left off. The goal is to find the complete list of symmetries (via permutations) for a variety of (more or less) random figures. When "complete," this list should comprise the "symmetry group" of the object.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.3 Symmetries and how to find them
:[font = text; inactive; preserveAspect]
To start this lab, the following package needs to be read into Mathematica. 
;[s]
3:0,0;63,1;74,0;77,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; rightWrapOffset = 540]
Consider the following array of figures.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; pictureLeft = 35; pictureWidth = 494; pictureHeight = 244]
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119048 0.47619 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.0119048 0.477324 0.238662 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.25 0.190476 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
.74 .99 .79 r
.02 w
.88095 .44048 m
.88095 .05952 L
.11905 .44048 L
.11905 .05952 L
s
P
p
[(1)] .97619 .4881 0 0 Mshowa
[(2)] .97619 .0119 0 0 Mshowa
[(3)] .02381 .0119 0 0 Mshowa
[(4)] .02381 .4881 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.88095 .44048 Mdot
P
p
0 1 0 r
.035 w
.88095 .05952 Mdot
P
p
0 0 1 r
.035 w
.11905 .05952 Mdot
P
p
1 1 0 r
.035 w
.11905 .44048 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119048 0.97619 0.238662 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.400557 0.459434 0.400557 [
[ 0 0 0 0 ]
[ 1 .98355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .98355 L
0 .98355 L
closepath
clip
newpath
p
p
p
.74 .99 .79 r
.88095 .58321 m
.73544 .13538 L
.26456 .13538 L
.11905 .58321 L
.5 .85999 L
F
P
p
0 0 0 r
.004 w
.88095 .58321 m
.73544 .13538 L
.26456 .13538 L
.11905 .58321 L
.5 .85999 L
.88095 .58321 L
s
P
P
p
[(1)] .97619 .61416 0 0 Mshowa
[(2)] .7943 .05436 0 0 Mshowa
[(3)] .2057 .05436 0 0 Mshowa
[(4)] .02381 .61416 0 0 Mshowa
[(5)] .5 .96013 0 0 Mshowa
P
p
.004 w
.73544 .13538 m
.69906 .02342 L
s
.26456 .13538 m
.14684 .13538 L
s
.11905 .58321 m
.08267 .69517 L
s
.5 .85999 m
.59524 .92919 L
s
.88095 .58321 m
.97619 .51402 L
s
P
p
p
1 0 0 r
.035 w
.88095 .58321 Mdot
P
p
0 1 0 r
.035 w
.73544 .13538 Mdot
P
p
0 0 1 r
.035 w
.26456 .13538 Mdot
P
p
1 1 0 r
.035 w
.11905 .58321 Mdot
P
p
.628 .126 .941 r
.035 w
.5 .85999 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.261338 0.477324 0.488095 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.25 0.190476 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
.74 .99 .79 r
.88095 .44048 m
.88095 .05952 L
.11905 .05952 L
.11905 .44048 L
F
P
p
[(1)] .97619 .4881 0 0 Mshowa
[(2)] .97619 .0119 0 0 Mshowa
[(3)] .02381 .0119 0 0 Mshowa
[(4)] .02381 .4881 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.88095 .44048 Mdot
P
p
0 1 0 r
.035 w
.88095 .05952 Mdot
P
p
0 0 1 r
.035 w
.11905 .05952 Mdot
P
p
1 1 0 r
.035 w
.11905 .44048 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.261338 0.97619 0.488095 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.386829 0.477823 0.386829 [
[ 0 0 0 0 ]
[ 1 .98481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .98481 L
0 .98481 L
closepath
clip
newpath
p
p
p
.74 .99 .79 r
.74865 .77415 m
.88095 .545 L
.835 .28441 L
.6323 .11432 L
.3677 .11432 L
.165 .28441 L
.11905 .545 L
.25135 .77415 L
.5 .86465 L
F
P
p
0 0 0 r
.004 w
.74865 .77415 m
.88095 .545 L
.835 .28441 L
.6323 .11432 L
.3677 .11432 L
.165 .28441 L
.11905 .545 L
.25135 .77415 L
.5 .86465 L
.74865 .77415 L
s
P
P
p
[(1)] .81081 .84823 0 0 Mshowa
[(2)] .97619 .56179 0 0 Mshowa
[(3)] .91875 .23606 0 0 Mshowa
[(4)] .66538 .02345 0 0 Mshowa
[(5)] .33462 .02345 0 0 Mshowa
[(6)] .08125 .23606 0 0 Mshowa
[(7)] .02381 .56179 0 0 Mshowa
[(8)] .18919 .84823 0 0 Mshowa
[(9)] .5 .96136 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.74865 .77415 Mdot
P
p
0 1 0 r
.035 w
.88095 .545 Mdot
P
p
0 0 1 r
.035 w
.835 .28441 Mdot
P
p
1 1 0 r
.035 w
.6323 .11432 Mdot
P
p
.628 .126 .941 r
.035 w
.3677 .11432 Mdot
P
p
1 .5 0 r
.035 w
.165 .28441 Mdot
P
p
.251 .878 .816 r
.035 w
.11905 .545 Mdot
P
p
.69 .188 .377 r
.035 w
.25135 .77415 Mdot
P
p
0 0 .502 r
.035 w
.5 .86465 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect]
When we look for the "symmetry group" of any one of these objects, we are looking for a complete list of symmetries for the object. (Technically, a symmetry of an object F is an isometry  that maps F onto itself, with distances being preserved. Since an isometry is actually a function, the "natural" way of combining symmetries is to use function composition.) 

Symmetries can come in several varieties. Often these involve rotations about a certain point (the "center"), through some angle. For example, in the figure in the upper left, if we rotate about the center of the rectangle (where the diagonals intersect) through an angle of 180 degrees, this will place the figure back onto itself. Note that the figure does NOT include the colored and labeled dots used to mark the vertices; these are only tags to help coordinate the movements. With the rotation just described, observe that vertices 1 and 3 are interchanged, as are vertices 2 and 4. We can describe this by
;[s]
3:0,0;427,1;436,0;977,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 542]
{1 -> 3, 2 -> 4, 3 -> 1, 4 -> 2}
;[s]
2:0,1;32,0;33,-1;
2:1,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 542]
or, in block permutation notation,
:[font = input; preserveAspect]
PermutationMatrix[{1 -> 3, 2 -> 4, 3 -> 1, 4 -> 2}]
:[font = text; inactive; preserveAspect]
or, as you may recall from the last lab, this can also be written as {3, 4, 1, 2} which constitutes the second coordinates or row of the representations above. Each of these is a representation for the permutation of the vertices that corresponds to the described rotational symmetry. Thus, we can say that the permutation {3, 4, 1, 2} represents one of the symmetries of this figure. (What are the others?) 
;[s]
5:0,0;69,1;81,0;323,1;335,0;409,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
Consider the rectangle again. If we imagine a horizontal line parallel to the base and through the center and consider this as a line of reflection, then we have another common type of symmetry: the reflection. In this case, we could also describe the symmetry by what happens to the vertices. We would say
;[s]
3:0,0;199,1;209,0;307,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 542]
{1 -> 2, 2 -> 1, 3 -> 4, 4 -> 3}
;[s]
2:0,1;32,0;33,-1;
2:1,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 542]
or,
:[font = input; preserveAspect]
PermutationMatrix[{1 -> 2, 2 -> 1, 3 -> 4, 4 -> 3}]
:[font = text; inactive; preserveAspect]
or, {2, 1, 4, 3} describes the permutation of the vertices that corresponds to this reflectional symmetry.
;[s]
3:0,0;4,1;16,0;107,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
There are several questions you may ask yourself. Is every symmetry either a rotation or a reflection? (You might consider the case of a finite object, such as above, in contrast with an infinite object, such as as infinitely long wall-papered wall.) You might also wonder if every object has both rotational and reflectional symmetries. For this, consider the lower right figure that has extra "wings" off the edges. 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
2.3.1 Getting started 
:[font = text; inactive; preserveAspect]
Evaluate the cell below to see the figure that you will first consider.
:[font = input; preserveAspect]
firstfig = ShowOne[Lab2]
:[font = text; inactive; preserveAspect]
Your task is to determine the symmetry group for this figure, using permutations as the elements. In other words, as in the first lab, you are to determine the symmetries (transformations) in the form of a permutation that will move the figure onto itself. 
:[font = text; inactive; preserveAspect]
As before, you may express your permutation either in the form {a,b,c,} or {1 -> a, 2 -> b, 3 -> }, }. Also, as in Lab 1, use p[1] = {a,b,c} or p[1] = {1 -> a, 2 -> b, 3 -> c, } to define your first permutation, p[2] for your second and so on. 
;[s]
11:0,0;63,1;72,0;76,1;103,0;127,1;143,0;147,1;181,0;216,1;220,0;249,-1;
2:6,16,12,Times,0,14,0,0,0;5,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect; endGroup]
Below is a list of functions that can be used for bookkeeping and testing while determining the permutations in the symmetry group.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
2.3.2 Functions/variables to use in this lab 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
functions from the last lab:
:[font = text; inactive; preserveAspect]
You should already be familiar with how the functions ShowPermutation and MultiplyPermutations work; to refresh yourself, simply type ? followed by the command, as below.
;[s]
5:0,0;54,1;69,0;74,1;94,0;171,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?ShowPermutation
:[font = input; preserveAspect; endGroup]
?MultiplyPermutations
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
ShowOne[Lab2]
:[font = text; inactive; preserveAspect]
This is how you started this lab. Type ShowOne[Lab2] to get a figure with which to work.
;[s]
3:0,0;39,1;52,0;89,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?ShowOne
;[s]
2:0,0;1,1;9,-1;
2:1,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
AddPermToGroup[p[i]]
:[font = text; inactive; preserveAspect]
If you are fully confident that p[i] is indeed a permutation of the vertices and is a symmetry, then type AddPermToGroup[p[i]], which will add it to the list of all your symmetries.
;[s]
5:0,0;32,1;36,0;106,1;126,0;182,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?AddPermToGroup
;[s]
2:0,0;1,1;16,-1;
2:1,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
DropPermFromGroup[p[i]]
:[font = text; inactive; preserveAspect]
DropPermFromGroup[p[i]] removes the permutation p[i] from the accumulated list of symmetries.
;[s]
4:0,1;23,0;48,1;52,0;94,-1;
2:2,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?DropPermFromGroup
;[s]
2:0,0;1,1;19,-1;
2:1,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
MySymmetryGroup
;[s]
1:0,1;16,-1;
2:0,13,9,Times,1,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = text; inactive; preserveAspect]
To see the list of symmetries accumulated thus far by these previous two functions, type MySymmetryGroup. 
;[s]
3:0,0;88,1;104,0;107,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
MySymmetryGroup
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
TestPermutationQ[p[i]]
:[font = text; inactive; preserveAspect]
If you have a permutation p[i] that you believe is a symmetry, but you want to check to be sure, type TestPermutationQ[p[i]] and either True or False will be returned.
;[s]
9:0,0;26,1;30,0;102,1;124,0;136,1;140,0;144,1;149,0;168,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?TestPermutationQ
;[s]
2:0,0;1,1;18,-1;
2:1,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
GoodGroupElementsQ[]
:[font = text; inactive; preserveAspect]
To determine if the accumulated permutations (as found in MySymmetryGroup) are all proper elements of the symmetry group of the figure, calling GoodGroupElementsQ[] answers with True or False.
;[s]
9:0,0;58,1;73,0;144,1;164,0;178,1;182,0;186,1;191,0;193,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?GoodGroupElementsQ
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
CompleteGroupQ[]
:[font = text; inactive; preserveAspect]
When you believe that you have found all the symmetries and have added them to MySymmetryGroup via AddPermToGroup, then you may check to see if your group is correct (complete) by typing CompleteGroupQ[], which will return True or False, and possibly additional information. 
;[s]
11:0,0;79,1;94,0;99,1;113,0;187,1;203,0;223,1;227,0;231,1;236,0;276,-1;
2:6,16,12,Times,0,14,0,0,0;5,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?CompleteGroupQ
;[s]
2:0,0;1,1;16,-1;
2:1,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
ShowPossiblePermutations[n]
:[font = text; inactive; preserveAspect]
If you get stuck trying to think of what other possible permutations might yield a symmetry, type ShowPossiblePermutations[n] (n being the number of vertices if a regular n-gon is shown, or 2 if a zee or rectangle is shown). You will be given a list of ALL possible permutations.
;[s]
3:0,0;98,1;125,0;280,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?ShowPossiblePermutations
;[s]
2:0,0;1,1;26,-1;
2:1,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
ShowPossiblePermsAsRules[n]
:[font = text; inactive; preserveAspect]
This is the same as the last function except the permutations are listed as rules, which may be helpful in using the RestrictList function described below.
;[s]
3:0,0;117,1;129,0;156,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?ShowPossiblePermsAsRules
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
RestrictList[r]
:[font = text; inactive; preserveAspect]
This function can be used to restrict the list produced by ShowPossiblePermsAsRules when you know that you want one vertex to go to another specific vertex, but want to explore what can happen with the other vertices. Note that r should be in the form i->j, {i->j}, or as a list of either of these.
;[s]
7:0,0;59,1;83,0;253,1;255,0;260,1;262,0;299,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
?RestrictList
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
all together now
:[font = text; inactive; preserveAspect]
It is easy to forget this list of functions. By typing AvailableFunctions (after evaluating the following), you can have the list of names always available.
;[s]
3:0,0;55,1;73,0;157,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; initialization; preserveAspect; endGroup; endGroup; endGroup]
*)
AvailableFunctions := {ShowPermutation, MultiplyPermutations,
	ShowOne, AddPermToGroup, DropPermFromGroup,
	"MySymmetryGroup", TestPermutationQ, GoodGroupElementsQ,
	CompleteGroupQ, ShowPossiblePermutations,
	ShowPossiblePermsAsRules, RestrictList};
	
AvailableFunctions
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.4 Now your turn
:[font = text; inactive; preserveAspect]
To see the figure again for the first exercise, evaluate the cell below. (Note: you should have already viewed it once when evaluating firstfig = ShowOne[Lab2] in the Getting Started section above.)
;[s]
5:0,0;135,1;159,0;167,2;182,0;199,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
firstfig[[1]]//Show;
:[font = special3; inactive; preserveAspect]
Q1. Using the information found in "Functions/variables to use in this lab" above, determine the complete list of all the symmetries (in the form of permutations) for the figure above. Use p[i] notation for each one (or ppp[i] if used by one of the functions described above). Show all work below in establishing this list.
;[s]
6:0,1;2,0;189,2;193,0;220,2;226,0;324,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
AvailableFunctions 
(* evaluate to be reminded what functions are available *)
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q2. Use the function MultiplyPermutations as in the previous lab (MultiplyPermutations[p[i], p[j]] determines the permutation of p[j] followed by p[i]) to determine the Cayley table for the symmetry group of this figure.
;[s]
10:0,1;2,0;21,2;41,0;66,2;98,0;128,2;133,0;146,2;150,0;221,-1;
3:5,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q3. Repeat the steps in Q1 and Q2 above with secondfig, determined below. 
;[s]
4:0,1;2,0;45,2;54,0;75,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[p, ppp]
secondfig = ShowOne[Lab2]
:[font = input; preserveAspect]
AvailableFunctions 
(* evaluate to be reminded what functions are available *)
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q4. Repeat the steps in Q1 and Q2 above again. 
;[s]
2:0,1;2,0;48,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect]
Clear[p, ppp]
thirdfig = ShowOne[Lab2]
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.5 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?PermutationMatrix
:[font = input; preserveAspect]
?ShowOne
:[font = input; preserveAspect]
?ShowPermutation
:[font = input; preserveAspect]
?MultiplyPermutations
:[font = input; preserveAspect]
?AddPermToGroup
:[font = input; preserveAspect]
?DropPermFromGroup
:[font = input; preserveAspect]
?TestPermutationQ
:[font = input; preserveAspect]
?GoodGroupElementsQ
:[font = input; preserveAspect]
?CompleteGroupQ
:[font = input; preserveAspect]
?ShowPossiblePermutations
:[font = input; preserveAspect]
?ShowPossiblePermsAsRules
:[font = input; preserveAspect; endGroup; endGroup]
?RestrictList
^*)
