(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 4. Let's get these orders straight
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab you should be familiar with the basic definition of a group. You should also have seen the definition of the order of an element in a group. (Recall that the order of an element g of a finite group G is the least positive integer k such that g^k is equal to the identity of G.)
;[s]
7:0,0;75,1;80,0;130,1;136,0;179,1;185,0;299,-1;
2:4,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
In this lab, we will look at issues regarding the order of groups and their elements. First we consider the relationship between the order of g and the order of the inverse of g. We then look at the distribution of the orders of elements in Z[n], followed by an inspection of which elements share a common order. We then begin an exploration regarding the probability that an arbitrary element of Z[n] will generate the whole group. Finally, we consider the order of the group U[n] (the multiplicative units of Z[n]) and try to find an expression for this order in terms of n.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.3 Order of g and its inverse
:[font = text; inactive; preserveAspect]
Suppose we consider any group G and take a random element g from G. The question we would like to consider here is: How does the order of g, denoted by |g|, compare with the order of its inverse, |g-1|?

For this section of the lab, the groups that we will consider come from the following list: Z[n] (1 < n < 31), U[n] (2 < n < 41), D[n] (1 < n < 8), GaussianUnits ({1, i}, under multiplication), and IntegerUnits ({1}, under multiplication).

The function ShowOne[Lab4] will present a random group G from the list above and then choose a random element g from the chosen group. First, we read in the Mathematica code needed for this lab; evaluate the following two cells:
;[s]
11:0,0;198,1;200,0;352,2;365,0;404,2;416,0;461,2;474,0;605,3;616,0;677,-1;
4:6,16,12,Times,0,14,0,0,0;1,21,13,Times,32,12,0,0,0;3,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
SetOptions[ListPlot, PlotStyle -> RGBColor[0, 0, 1]];
(*
:[font = input; preserveAspect]
{G, g} = ShowOne[Lab4];
ColumnForm[{G, g}]
op = Operation[G];
:[font = text; inactive; preserveAspect]
This gives a random group G, and an element g in G; we have also defined op as a variable for the group operation.

We now wish to determine the order of g in G. We can do this by successively applying the operation to g:
;[s]
3:0,0;73,1;75,0;222,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
op[g, g]
:[font = text; inactive; preserveAspect]
This calculates g^2. To calculate g^3, apply op to g and the last result (indicated by %):
;[s]
5:0,0;45,1;47,0;87,1;88,0;91,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
op[g, %]
:[font = text; inactive; preserveAspect]
To calculate g^4, apply op to g and the last result (%), and so on.
;[s]
5:0,0;24,1;26,0;53,1;54,0;68,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
op[g, %]
:[font = special3; inactive; preserveAspect]
Q1. For the group G given above, determine the order of the element g. Also record your group G and element g.
;[s]
2:0,1;2,0;111,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's pick another group and element:
:[font = input; preserveAspect]
{G, g} = ShowOne[Lab4];
ColumnForm[{G, g}]
:[font = text; inactive; preserveAspect]
As an alternative, one can use the ElementToPower function that calculates g^n for any integer n:
;[s]
3:0,0;35,1;49,0;98,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ElementToPower[G, g, 2]
:[font = text; inactive; preserveAspect]
The following calculates the first 6 powers; adjust the range accordingly to determine |g|.
:[font = input; preserveAspect]
Table[ElementToPower[G, g, k], {k, 1, 6}]
:[font = special3; inactive; preserveAspect]
Q2. What is the order of g in this case? (Also record your group G and element g.)
;[s]
2:0,1;2,0;83,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
We can also use the following function to calculate the order. Since it is important to know how to calculate orders, be sure you answer questions 1 and 2 "by hand" before confirming your answer with this function.
:[font = input; preserveAspect]
Order[G, g]
:[font = special3; inactive; preserveAspect]
Q3. For the group G given above, determine the inverse of the element g in the group. (You are expected to do this without using Mathematica.)
;[s]
4:0,1;2,0;129,2;140,0;143,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Just as it is important to be able to determine orders through calculations, it is also important to be able to determine ("by hand") the inverse of an element. The following command can be used to confirm your answer to the last question, but evaluate it only after you found an answer.
:[font = input; preserveAspect]
invg = GroupInverse[G, g]
:[font = text; inactive; preserveAspect]
Now let's ask Mathematica to help us calculate the order of the inverse.
;[s]
3:0,0;14,1;25,0;73,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Order[G, invg]
:[font = special3; inactive; preserveAspect]
Q4. In this case, what is the relationship between the order of g and the order of its inverse? Record g and g's inverse in your answer.
;[s]
2:0,1;2,0;137,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's try this again. First we will pick out a group and an element.
:[font = input; preserveAspect]
{G, g} = ShowOne[Lab4];
ColumnForm[{G, g}]
:[font = text; inactive; preserveAspect]
Next, determine the order of g in G (without Mathematica) and then use the following to confirm your answer.
;[s]
3:0,0;45,1;56,0;109,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Order[G, g]
:[font = text; inactive; preserveAspect]
Now, determine the inverse of g and confirm with the following.
:[font = input; preserveAspect]
invg = GroupInverse[G, g]
:[font = text; inactive; preserveAspect]
Finally, calculate the order of the inverse and compare this to the order of g itself.
:[font = input; preserveAspect]
Order[G, invg]
:[font = special3; inactive; preserveAspect]
Q5. In this case, what is the relationship between the order of g and the order of its inverse? Since the pair (G, g) you investigated was randomly generated, include in your answer the group G, element g, order of g, g^(-1), and order of g^(-1).
;[s]
2:0,1;2,0;247,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's generate some more data. The output from the cell below might take a little time to compute. It will consist of a list of several groups, a random element from each group, the inverse of the element and the orders of the element and its inverse.
:[font = input; preserveAspect]
TableForm[Table[{G, g} = ShowOne[Lab4, Verbal -> False];
{GroupoidName[G], g, invg = GroupInverse[G,g], Order[G,g],
	Order[G, invg]}, {20}], TableHeadings -> 
	{None, {"group", "g", "g^(-1)", "|g|", "|g^(-1)|\n"}},
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
:[font = special3; inactive; preserveAspect]
Q6. Make a conjecture about the relationship between the order of an element in a group and the order of its inverse.
;[s]
2:0,1;2,0;118,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q7. Try to prove your conjecture.
;[s]
2:0,1;2,0;34,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
4.4 Distribution of the orders of elements in Z[n]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
We now pick a random index n between 20 and 60 and consider the group Z[n].
:[font = input; preserveAspect; rightWrapOffset = 521]
n = Random[Integer, {20, 60}]
G = Z[n]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's take a random element from Z[n] and find its order. Making a table, we will do this experiment with 20 trials.
:[font = input; preserveAspect; rightWrapOffset = 521]
numTrials = 20;
TableForm[Table[g = RandomElement[G]; {g, Order[G, g]}, 
{numTrials}],
	TableHeadings -> {None, {"g", "|g|\n"}}, 
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Record, either below or on your paper, both the index n used above and all the different orders (appearing in the second column); at this point, we only want to record which orders occur for a given index n.

Now repeat this experiment with a new group by evaluating the cell below. In the unlikely event that you get the same index, evaluate the cell again to get a new value for n.
;[s]
6:0,0;79,1;88,0;168,1;173,0;283,1;384,-1;
2:3,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
n = Random[Integer, {20, 60}];
G = Z[n]
numTrials = 20;
TableForm[Table[g = RandomElement[G]; {g, Order[G, g]}, 
	{numTrials}],
	TableHeadings -> {None, {"g", "|g|\n"}}, 
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Record both the index n and the orders that appear. Keep evaluating the above input cell until you can answer the question below.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q8. Given a positive integer n, what can you say about the orders of the elements of Z[n]? State your conclusion formally in the form of a conjecture.
;[s]
2:0,1;2,0;151,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.5 Another look at orders
:[font = text; inactive; preserveAspect]
In the previous section, we considered the relationship between |g| and |G| for elements g from some group G = Z[n]. Now that the relationship is hopefully determined, we now wish to consider the frequencies of various orders. In other words, how frequently does a particular order occur, once we know that it does occur.

For the moment, we will still consider G = Z[n]. Let's pick an arbitrary index for this group.
:[font = input; preserveAspect]
n = Random[Integer, {8, 50}]
G = Z[n]
:[font = text; inactive; preserveAspect]
Evaluate the following command.
:[font = input; preserveAspect]
ShowGroupOrders[Z[n]];
:[font = text; inactive; preserveAspect]
If these graphics are hard to read, you may wish to enlarge them. (To do so, click once on the graphic to select it and then drag from the lower right corner until sufficiently enlarged.) 

A word of explanation is in order. The first graph, a ListPlot, consists of a graphical representation of what was accomplished in the previous section. Along the horizontal axis are the elements in Z[n] and along the vertical axis are the orders the elements can take. For each element in G, there is a dot at the height corresponding to the order of that element. 

The second graph is a bar chart showing the frequencies with which the orders occur. Along the bottom are the different orders of elements in the group, and the height of the bar corresponds with how many elements in the group have that particular order.

Consider another example.
;[s]
3:0,0;244,1;252,0;840,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
n = Random[Integer, {8, 50}]
G = Z[n]
ShowGroupOrders[G];
:[font = text; inactive; preserveAspect]
Evaluate the cell above a few more times. Do it enough times until you can answer the following question.
:[font = special3; inactive; preserveAspect]
Q9. Consider Z[n] when n is composite. (If n is prime, the above graphs are boringly simple.) What can you say about the frequencies of the orders? What can you say about the shape of the frequency histogram (second graph)? What can you say about the ListPlot?
;[s]
4:0,1;2,0;251,2;259,0;261,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Try the following, which executes the same commands, but looks at the group U(n) (the elements in Z(n) that have multiplicative inverses, with the group operation being multiplication mod n).
:[font = input; preserveAspect]
Do[ShowGroupOrders[U[i]], {i, 14, 20}];
:[font = special3; inactive; preserveAspect]
Q10. Reconsider what you answered in the previous question. Are any of your answers specific to Z[n], not holding here with U[n]? Are any still true with U[n]?
;[s]
2:0,1;3,0;160,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
With the work above, we did not worry about which elements lead to various orders, only how many. Now we wish to focus on which elements. 

Evaluate the following.
;[s]
9:0,0;44,1;49,0;88,1;96,0;122,1;127,0;137,1;140,0;164,-1;
2:5,16,12,Times,0,14,0,0,0;4,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
n = Random[Integer, {8, 50}]
CollectOrders[OrderOfAllElements[Z[n]]]//ColumnForm
:[font = text; inactive; preserveAspect]
Here, we pick a random integer n and then pairs of the form {p, A} are returned, where p is an order that occurs in the group Z[n] and A is the set of all elements in Z[n] that have this order p. Study the output. Try evaluating the cell again. And again. And again, until you can answer the following questions.
:[font = special3; inactive; preserveAspect]
Q11. What relationship is there among the elements in the set A when given a pair {p, A} is the output? Can you formalize a relationship in the form of a (generalized) conjecture?
;[s]
2:0,1;3,0;180,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. For a given pair {p, A}, what relationships are there between the elements in the set A and p and n? Can you formalize a relationship in the form of a (generalized) conjecture?
;[s]
2:0,1;3,0;182,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
4.6 What is P(|g|=n) for g in Z[n]?
:[font = text; inactive; preserveAspect]
Let's pick a random group Z[n] for n in {15, 16, ..., 40}.
:[font = input; preserveAspect]
n = Random[Integer, {15, 40}]
G = Z[n]
:[font = text; inactive; preserveAspect]
Of all the elements in this group, how many of them have order n? Think about it. How many do you think?

Using the function Orders, n pairs are returned, each taking the form {g, |g|}, an element and its order.
;[s]
5:0,0;125,1;131,0;176,1;184,0;212,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?Orders
:[font = input; preserveAspect]
orders = Orders[G]
:[font = text; inactive; preserveAspect]
From this list, we will select those whose second coordinate is equal to n (the order of the group Z[n]).
:[font = input; preserveAspect]
nIsOrder = Select[orders, (#[[2]] == n)&]
:[font = text; inactive; preserveAspect]
How many are there with this order? Length will find out.
;[s]
3:0,0;36,1;42,0;58,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
howMany = Length[nIsOrder]
:[font = text; inactive; preserveAspect]
To calculate the ratio, we can do the following:
:[font = input; preserveAspect]
N[howMany/n]
:[font = text; inactive; preserveAspect]
Let's record our results. What information is really significant to record? How about the index n and the percentage found in the last result? Record this somewhere.

Now let's do this again, but compact all the steps in one cell.
:[font = input; preserveAspect]
n = Random[Integer, {5, 40}]
G = Z[n]
orders = OrderOfAllElements[G]
nIsOrder = Select[orders, (#[[2]]==n)&]
howMany = Length[nIsOrder]
N[howMany/n]
:[font = text; inactive; preserveAspect]
Or if you are a real Mathematica nerd, you might combine it as follows (output is {n, percentage}).
;[s]
3:0,0;21,1;32,0;100,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
n = Random[Integer, {5, 40}];
{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}
:[font = text; inactive; preserveAspect]
The advantage of the last method is that it is a little quicker and easier to put in a loop if one wants to repeat this a number of times (say, 15). Depending on your computer and the indices n that will be chosen, the following may take some time.
:[font = input; preserveAspect]
numTrials = 15;
percents = Table[n = Random[Integer, {5, 40}];
	{n,N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {numTrials}]//Sort
:[font = input; preserveAspect]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> 
	{Min[Transpose[percents][[1]]]-1, 0},
	PlotStyle -> {RGBColor[0, 0, 1], PointSize[0.015]}];
:[font = special3; inactive; preserveAspect]
Q13. Look at the ListPlot, as well as the data above. Which integers yield high percentages? Which yield low percentages? Can you give any explanation for this phenomenon? 
;[s]
4:0,1;3,0;17,2;25,0;173,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's calculate the overall average (arithmetic mean):
:[font = input; preserveAspect]
mean = Apply[Plus, Transpose[percents][[2]]]/Length[percents]
:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21]
Now let's consider calculating the percentages for all Z[n] up to n = 25. (The watch means it would take some time if you were to evaluate the next cell; instead, simply open it up to look at the pre-evaluated output.)
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {n, 2, 25}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540; fontLeading = 0]
{{2, 0.5}, {3, 0.6666666666666666}, {4, 0.5}, {5, 0.8}, 
 {6, 0.3333333333333333}, {7, 0.857142857142857}, {8, 0.5}, 
 {9, 0.6666666666666666}, {10, 0.4}, {11, 0.909090909090909}, 
 {12, 0.3333333333333333}, {13, 0.923076923076923}, 
 {14, 0.4285714285714286}, {15, 0.5333333333333333}, {16, 0.5}, 
 {17, 0.941176470588235}, {18, 0.3333333333333333}, 
 {19, 0.947368421052632}, {20, 0.4}, {21, 0.5714285714285714}, 
 {22, 0.4545454545454545}, {23, 0.956521739130435}, 
 {24, 0.3333333333333333}, {25, 0.8}}
;[o]
{{2, 0.5}, {3, 0.666667}, {4, 0.5}, {5, 0.8}, {6, 0.333333}, 
 {7, 0.857143}, {8, 0.5}, {9, 0.666667}, {10, 0.4}, 
 {11, 0.909091}, {12, 0.333333}, {13, 0.923077}, {14, 0.428571}, 
 {15, 0.533333}, {16, 0.5}, {17, 0.941176}, {18, 0.333333}, 
 {19, 0.947368}, {20, 0.4}, {21, 0.571429}, {22, 0.454545}, 
 {23, 0.956522}, {24, 0.333333}, {25, 0.8}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0380952 0 0.618034 [
[(0)] .02381 0 0 2 Msboxa
[(5)] .21429 0 0 2 Msboxa
[(10)] .40476 0 0 2 Msboxa
[(15)] .59524 0 0 2 Msboxa
[(20)] .78571 0 0 2 Msboxa
[(25)] .97619 0 0 2 Msboxa
[(0.2)] .01131 .12361 1 0 Msboxa
[(0.4)] .01131 .24721 1 0 Msboxa
[(0.6)] .01131 .37082 1 0 Msboxa
[(0.8)] .01131 .49443 1 0 Msboxa
[(1)] .01131 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(5)] .21429 0 0 2 Mshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(10)] .40476 0 0 2 Mshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(15)] .59524 0 0 2 Mshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(20)] .78571 0 0 2 Mshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(25)] .97619 0 0 2 Mshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
.02381 .12361 m
.03006 .12361 L
s
P
[(0.2)] .01131 .12361 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(0.4)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .37082 m
.03006 .37082 L
s
P
[(0.6)] .01131 .37082 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(0.8)] .01131 .49443 1 0 Mshowa
p
.002 w
.02381 .61803 m
.03006 .61803 L
s
P
[(1)] .01131 .61803 1 0 Mshowa
p
.001 w
.02381 .02472 m
.02756 .02472 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .07416 m
.02756 .07416 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .17305 m
.02756 .17305 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .22249 m
.02756 .22249 L
s
P
p
.001 w
.02381 .27193 m
.02756 .27193 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .32138 m
.02756 .32138 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .42026 m
.02756 .42026 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46971 m
.02756 .46971 L
s
P
p
.001 w
.02381 .51915 m
.02756 .51915 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56859 m
.02756 .56859 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.1 .30902 Mdot
.1381 .41202 Mdot
.17619 .30902 Mdot
.21429 .49443 Mdot
.25238 .20601 Mdot
.29048 .52974 Mdot
.32857 .30902 Mdot
.36667 .41202 Mdot
.40476 .24721 Mdot
.44286 .56185 Mdot
.48095 .20601 Mdot
.51905 .57049 Mdot
.55714 .26487 Mdot
.59524 .32962 Mdot
.63333 .30902 Mdot
.67143 .58168 Mdot
.70952 .20601 Mdot
.74762 .58551 Mdot
.78571 .24721 Mdot
.82381 .35316 Mdot
.8619 .28092 Mdot
.9 .59116 Mdot
.9381 .20601 Mdot
.97619 .49443 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21; rightWrapOffset = 540]
As well as the percentages from n = 26 to n = 40: 
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {n, 26, 40}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {26, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540; fontLeading = 0]
{{26, 0.4615384615384616}, {27, 0.6666666666666666}, 
 {28, 0.4285714285714286}, {29, 0.96551724137931}, 
 {30, 0.2666666666666666}, {31, 0.967741935483871}, {32, 0.5}, 
 {33, 0.6060606060606061}, {34, 0.4705882352941177}, 
 {35, 0.6857142857142858}, {36, 0.3333333333333333}, 
 {37, 0.972972972972973}, {38, 0.4736842105263158}, 
 {39, 0.6153846153846155}, {40, 0.4}}
;[o]
{{26, 0.461538}, {27, 0.666667}, {28, 0.428571}, {29, 0.965517}, 
 {30, 0.266667}, {31, 0.967742}, {32, 0.5}, {33, 0.606061}, 
 {34, 0.470588}, {35, 0.685714}, {36, 0.333333}, {37, 0.972973}, 
 {38, 0.473684}, {39, 0.615385}, {40, 0.4}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.7449 0.0680272 0 0.618034 [
[(26)] .02381 0 0 2 Msboxa
[(28)] .15986 0 0 2 Msboxa
[(30)] .29592 0 0 2 Msboxa
[(32)] .43197 0 0 2 Msboxa
[(34)] .56803 0 0 2 Msboxa
[(36)] .70408 0 0 2 Msboxa
[(38)] .84014 0 0 2 Msboxa
[(40)] .97619 0 0 2 Msboxa
[(0.2)] .01131 .12361 1 0 Msboxa
[(0.4)] .01131 .24721 1 0 Msboxa
[(0.6)] .01131 .37082 1 0 Msboxa
[(0.8)] .01131 .49443 1 0 Msboxa
[(1)] .01131 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(26)] .02381 0 0 2 Mshowa
p
.002 w
.15986 0 m
.15986 .00625 L
s
P
[(28)] .15986 0 0 2 Mshowa
p
.002 w
.29592 0 m
.29592 .00625 L
s
P
[(30)] .29592 0 0 2 Mshowa
p
.002 w
.43197 0 m
.43197 .00625 L
s
P
[(32)] .43197 0 0 2 Mshowa
p
.002 w
.56803 0 m
.56803 .00625 L
s
P
[(34)] .56803 0 0 2 Mshowa
p
.002 w
.70408 0 m
.70408 .00625 L
s
P
[(36)] .70408 0 0 2 Mshowa
p
.002 w
.84014 0 m
.84014 .00625 L
s
P
[(38)] .84014 0 0 2 Mshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(40)] .97619 0 0 2 Mshowa
p
.001 w
.05102 0 m
.05102 .00375 L
s
P
p
.001 w
.07823 0 m
.07823 .00375 L
s
P
p
.001 w
.10544 0 m
.10544 .00375 L
s
P
p
.001 w
.13265 0 m
.13265 .00375 L
s
P
p
.001 w
.18707 0 m
.18707 .00375 L
s
P
p
.001 w
.21429 0 m
.21429 .00375 L
s
P
p
.001 w
.2415 0 m
.2415 .00375 L
s
P
p
.001 w
.26871 0 m
.26871 .00375 L
s
P
p
.001 w
.32313 0 m
.32313 .00375 L
s
P
p
.001 w
.35034 0 m
.35034 .00375 L
s
P
p
.001 w
.37755 0 m
.37755 .00375 L
s
P
p
.001 w
.40476 0 m
.40476 .00375 L
s
P
p
.001 w
.45918 0 m
.45918 .00375 L
s
P
p
.001 w
.48639 0 m
.48639 .00375 L
s
P
p
.001 w
.51361 0 m
.51361 .00375 L
s
P
p
.001 w
.54082 0 m
.54082 .00375 L
s
P
p
.001 w
.59524 0 m
.59524 .00375 L
s
P
p
.001 w
.62245 0 m
.62245 .00375 L
s
P
p
.001 w
.64966 0 m
.64966 .00375 L
s
P
p
.001 w
.67687 0 m
.67687 .00375 L
s
P
p
.001 w
.73129 0 m
.73129 .00375 L
s
P
p
.001 w
.7585 0 m
.7585 .00375 L
s
P
p
.001 w
.78571 0 m
.78571 .00375 L
s
P
p
.001 w
.81293 0 m
.81293 .00375 L
s
P
p
.001 w
.86735 0 m
.86735 .00375 L
s
P
p
.001 w
.89456 0 m
.89456 .00375 L
s
P
p
.001 w
.92177 0 m
.92177 .00375 L
s
P
p
.001 w
.94898 0 m
.94898 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
.02381 .12361 m
.03006 .12361 L
s
P
[(0.2)] .01131 .12361 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(0.4)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .37082 m
.03006 .37082 L
s
P
[(0.6)] .01131 .37082 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(0.8)] .01131 .49443 1 0 Mshowa
p
.002 w
.02381 .61803 m
.03006 .61803 L
s
P
[(1)] .01131 .61803 1 0 Mshowa
p
.001 w
.02381 .02472 m
.02756 .02472 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .07416 m
.02756 .07416 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .17305 m
.02756 .17305 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .22249 m
.02756 .22249 L
s
P
p
.001 w
.02381 .27193 m
.02756 .27193 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .32138 m
.02756 .32138 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .42026 m
.02756 .42026 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46971 m
.02756 .46971 L
s
P
p
.001 w
.02381 .51915 m
.02756 .51915 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56859 m
.02756 .56859 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.02381 .28525 Mdot
.09184 .41202 Mdot
.15986 .26487 Mdot
.22789 .59672 Mdot
.29592 .16481 Mdot
.36395 .5981 Mdot
.43197 .30902 Mdot
.5 .37457 Mdot
.56803 .29084 Mdot
.63605 .42379 Mdot
.70408 .20601 Mdot
.77211 .60133 Mdot
.84014 .29275 Mdot
.90816 .38033 Mdot
.97619 .24721 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = special3; inactive; preserveAspect]
Q14. Make one or more conjectures about the probability that a random element g of Z[n] has order n (and thus will generate the whole group). You may wish to specialize, having your conjecture depend on n. Consider the cells that follow.
;[s]
2:0,1;3,0;238,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21; rightWrapOffset = 540]
Now let's consider looking at prime indices.
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[n = Prime[j];
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {j, 1, 20}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540; fontLeading = 0]
{{2, 0.5}, {3, 0.6666666666666666}, {5, 0.8}, 
 {7, 0.857142857142857}, {11, 0.909090909090909}, 
 {13, 0.923076923076923}, {17, 0.941176470588235}, 
 {19, 0.947368421052632}, {23, 0.956521739130435}, 
 {29, 0.96551724137931}, {31, 0.967741935483871}, 
 {37, 0.972972972972973}, {41, 0.975609756097561}, 
 {43, 0.976744186046512}, {47, 0.978723404255319}, 
 {53, 0.981132075471698}, {59, 0.983050847457627}, 
 {61, 0.983606557377049}, {67, 0.985074626865672}, 
 {71, 0.985915492957746}}
;[o]
{{2, 0.5}, {3, 0.666667}, {5, 0.8}, {7, 0.857143}, 
 {11, 0.909091}, {13, 0.923077}, {17, 0.941176}, {19, 0.947368}, 
 {23, 0.956522}, {29, 0.965517}, {31, 0.967742}, {37, 0.972973}, 
 {41, 0.97561}, {43, 0.976744}, {47, 0.978723}, {53, 0.981132}, 
 {59, 0.983051}, {61, 0.983607}, {67, 0.985075}, {71, 0.985915}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0134138 0 0.618034 [
[(0)] .02381 0 0 2 Msboxa
[(10)] .15795 0 0 2 Msboxa
[(20)] .29209 0 0 2 Msboxa
[(30)] .42622 0 0 2 Msboxa
[(40)] .56036 0 0 2 Msboxa
[(50)] .6945 0 0 2 Msboxa
[(60)] .82864 0 0 2 Msboxa
[(70)] .96278 0 0 2 Msboxa
[(0.2)] .01131 .12361 1 0 Msboxa
[(0.4)] .01131 .24721 1 0 Msboxa
[(0.6)] .01131 .37082 1 0 Msboxa
[(0.8)] .01131 .49443 1 0 Msboxa
[(1)] .01131 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.15795 0 m
.15795 .00625 L
s
P
[(10)] .15795 0 0 2 Mshowa
p
.002 w
.29209 0 m
.29209 .00625 L
s
P
[(20)] .29209 0 0 2 Mshowa
p
.002 w
.42622 0 m
.42622 .00625 L
s
P
[(30)] .42622 0 0 2 Mshowa
p
.002 w
.56036 0 m
.56036 .00625 L
s
P
[(40)] .56036 0 0 2 Mshowa
p
.002 w
.6945 0 m
.6945 .00625 L
s
P
[(50)] .6945 0 0 2 Mshowa
p
.002 w
.82864 0 m
.82864 .00625 L
s
P
[(60)] .82864 0 0 2 Mshowa
p
.002 w
.96278 0 m
.96278 .00625 L
s
P
[(70)] .96278 0 0 2 Mshowa
p
.001 w
.05064 0 m
.05064 .00375 L
s
P
p
.001 w
.07746 0 m
.07746 .00375 L
s
P
p
.001 w
.10429 0 m
.10429 .00375 L
s
P
p
.001 w
.13112 0 m
.13112 .00375 L
s
P
p
.001 w
.18478 0 m
.18478 .00375 L
s
P
p
.001 w
.2116 0 m
.2116 .00375 L
s
P
p
.001 w
.23843 0 m
.23843 .00375 L
s
P
p
.001 w
.26526 0 m
.26526 .00375 L
s
P
p
.001 w
.31891 0 m
.31891 .00375 L
s
P
p
.001 w
.34574 0 m
.34574 .00375 L
s
P
p
.001 w
.37257 0 m
.37257 .00375 L
s
P
p
.001 w
.3994 0 m
.3994 .00375 L
s
P
p
.001 w
.45305 0 m
.45305 .00375 L
s
P
p
.001 w
.47988 0 m
.47988 .00375 L
s
P
p
.001 w
.50671 0 m
.50671 .00375 L
s
P
p
.001 w
.53353 0 m
.53353 .00375 L
s
P
p
.001 w
.58719 0 m
.58719 .00375 L
s
P
p
.001 w
.61402 0 m
.61402 .00375 L
s
P
p
.001 w
.64085 0 m
.64085 .00375 L
s
P
p
.001 w
.66767 0 m
.66767 .00375 L
s
P
p
.001 w
.72133 0 m
.72133 .00375 L
s
P
p
.001 w
.74816 0 m
.74816 .00375 L
s
P
p
.001 w
.77498 0 m
.77498 .00375 L
s
P
p
.001 w
.80181 0 m
.80181 .00375 L
s
P
p
.001 w
.85547 0 m
.85547 .00375 L
s
P
p
.001 w
.88229 0 m
.88229 .00375 L
s
P
p
.001 w
.90912 0 m
.90912 .00375 L
s
P
p
.001 w
.93595 0 m
.93595 .00375 L
s
P
p
.001 w
.9896 0 m
.9896 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
.02381 .12361 m
.03006 .12361 L
s
P
[(0.2)] .01131 .12361 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(0.4)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .37082 m
.03006 .37082 L
s
P
[(0.6)] .01131 .37082 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(0.8)] .01131 .49443 1 0 Mshowa
p
.002 w
.02381 .61803 m
.03006 .61803 L
s
P
[(1)] .01131 .61803 1 0 Mshowa
p
.001 w
.02381 .02472 m
.02756 .02472 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .07416 m
.02756 .07416 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .17305 m
.02756 .17305 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .22249 m
.02756 .22249 L
s
P
p
.001 w
.02381 .27193 m
.02756 .27193 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .32138 m
.02756 .32138 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .42026 m
.02756 .42026 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46971 m
.02756 .46971 L
s
P
p
.001 w
.02381 .51915 m
.02756 .51915 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56859 m
.02756 .56859 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.05064 .30902 Mdot
.06405 .41202 Mdot
.09088 .49443 Mdot
.11771 .52974 Mdot
.17136 .56185 Mdot
.19819 .57049 Mdot
.25184 .58168 Mdot
.27867 .58551 Mdot
.33233 .59116 Mdot
.41281 .59672 Mdot
.43964 .5981 Mdot
.52012 .60133 Mdot
.57378 .60296 Mdot
.6006 .60366 Mdot
.65426 .60488 Mdot
.73474 .60637 Mdot
.81522 .60756 Mdot
.84205 .6079 Mdot
.92254 .60881 Mdot
.97619 .60933 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21; rightWrapOffset = 540]
How about looking at indices that are squares.
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[n = j^2;
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {j, 2, 13}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540; fontLeading = 0]
{{4, 0.5}, {9, 0.6666666666666666}, {16, 0.5}, {25, 0.8}, 
 {36, 0.3333333333333333}, {49, 0.857142857142857}, {64, 0.5}, 
 {81, 0.6666666666666666}, {100, 0.4}, {121, 0.909090909090909}, 
 {144, 0.3333333333333333}, {169, 0.923076923076923}}
;[o]
{{4, 0.5}, {9, 0.666667}, {16, 0.5}, {25, 0.8}, {36, 0.333333}, 
 {49, 0.857143}, {64, 0.5}, {81, 0.666667}, {100, 0.4}, 
 {121, 0.909091}, {144, 0.333333}, {169, 0.923077}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00563539 0 0.618034 [
[(0)] .02381 0 0 2 Msboxa
[(25)] .16469 0 0 2 Msboxa
[(50)] .30558 0 0 2 Msboxa
[(75)] .44646 0 0 2 Msboxa
[(100)] .58735 0 0 2 Msboxa
[(125)] .72823 0 0 2 Msboxa
[(150)] .86912 0 0 2 Msboxa
[(0.2)] .01131 .12361 1 0 Msboxa
[(0.4)] .01131 .24721 1 0 Msboxa
[(0.6)] .01131 .37082 1 0 Msboxa
[(0.8)] .01131 .49443 1 0 Msboxa
[(1)] .01131 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.16469 0 m
.16469 .00625 L
s
P
[(25)] .16469 0 0 2 Mshowa
p
.002 w
.30558 0 m
.30558 .00625 L
s
P
[(50)] .30558 0 0 2 Mshowa
p
.002 w
.44646 0 m
.44646 .00625 L
s
P
[(75)] .44646 0 0 2 Mshowa
p
.002 w
.58735 0 m
.58735 .00625 L
s
P
[(100)] .58735 0 0 2 Mshowa
p
.002 w
.72823 0 m
.72823 .00625 L
s
P
[(125)] .72823 0 0 2 Mshowa
p
.002 w
.86912 0 m
.86912 .00625 L
s
P
[(150)] .86912 0 0 2 Mshowa
p
.001 w
.05199 0 m
.05199 .00375 L
s
P
p
.001 w
.08016 0 m
.08016 .00375 L
s
P
p
.001 w
.10834 0 m
.10834 .00375 L
s
P
p
.001 w
.13652 0 m
.13652 .00375 L
s
P
p
.001 w
.19287 0 m
.19287 .00375 L
s
P
p
.001 w
.22105 0 m
.22105 .00375 L
s
P
p
.001 w
.24923 0 m
.24923 .00375 L
s
P
p
.001 w
.2774 0 m
.2774 .00375 L
s
P
p
.001 w
.33376 0 m
.33376 .00375 L
s
P
p
.001 w
.36193 0 m
.36193 .00375 L
s
P
p
.001 w
.39011 0 m
.39011 .00375 L
s
P
p
.001 w
.41829 0 m
.41829 .00375 L
s
P
p
.001 w
.47464 0 m
.47464 .00375 L
s
P
p
.001 w
.50282 0 m
.50282 .00375 L
s
P
p
.001 w
.53099 0 m
.53099 .00375 L
s
P
p
.001 w
.55917 0 m
.55917 .00375 L
s
P
p
.001 w
.61553 0 m
.61553 .00375 L
s
P
p
.001 w
.6437 0 m
.6437 .00375 L
s
P
p
.001 w
.67188 0 m
.67188 .00375 L
s
P
p
.001 w
.70006 0 m
.70006 .00375 L
s
P
p
.001 w
.75641 0 m
.75641 .00375 L
s
P
p
.001 w
.78459 0 m
.78459 .00375 L
s
P
p
.001 w
.81276 0 m
.81276 .00375 L
s
P
p
.001 w
.84094 0 m
.84094 .00375 L
s
P
p
.001 w
.8973 0 m
.8973 .00375 L
s
P
p
.001 w
.92547 0 m
.92547 .00375 L
s
P
p
.001 w
.95365 0 m
.95365 .00375 L
s
P
p
.001 w
.98183 0 m
.98183 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
.02381 .12361 m
.03006 .12361 L
s
P
[(0.2)] .01131 .12361 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(0.4)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .37082 m
.03006 .37082 L
s
P
[(0.6)] .01131 .37082 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(0.8)] .01131 .49443 1 0 Mshowa
p
.002 w
.02381 .61803 m
.03006 .61803 L
s
P
[(1)] .01131 .61803 1 0 Mshowa
p
.001 w
.02381 .02472 m
.02756 .02472 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .07416 m
.02756 .07416 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .17305 m
.02756 .17305 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .22249 m
.02756 .22249 L
s
P
p
.001 w
.02381 .27193 m
.02756 .27193 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .32138 m
.02756 .32138 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .42026 m
.02756 .42026 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46971 m
.02756 .46971 L
s
P
p
.001 w
.02381 .51915 m
.02756 .51915 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56859 m
.02756 .56859 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.04635 .30902 Mdot
.07453 .41202 Mdot
.11398 .30902 Mdot
.16469 .49443 Mdot
.22668 .20601 Mdot
.29994 .52974 Mdot
.38447 .30902 Mdot
.48028 .41202 Mdot
.58735 .24721 Mdot
.70569 .56185 Mdot
.83531 .20601 Mdot
.97619 .57049 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21; rightWrapOffset = 540]
Or powers of two.
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[n = 2^j;
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {j, 1, 6}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540]
{{2, 0.5}, {4, 0.5}, {8, 0.5}, {16, 0.5}, {32, 0.5}, {64, 0.5}}
;[o]
{{2, 0.5}, {4, 0.5}, {8, 0.5}, {16, 0.5}, {32, 0.5}, {64, 0.5}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00691244 0.015361 0 0.618034 [
[(10)] .1467 0 0 2 Msboxa
[(20)] .30031 0 0 2 Msboxa
[(30)] .45392 0 0 2 Msboxa
[(40)] .60753 0 0 2 Msboxa
[(50)] .76114 0 0 2 Msboxa
[(60)] .91475 0 0 2 Msboxa
[(0.2)] -0.01941 .12361 1 0 Msboxa
[(0.4)] -0.01941 .24721 1 0 Msboxa
[(0.6)] -0.01941 .37082 1 0 Msboxa
[(0.8)] -0.01941 .49443 1 0 Msboxa
[(1)] -0.01941 .61803 1 0 Msboxa
[ -0.00791 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.1467 0 m
.1467 .00625 L
s
P
[(10)] .1467 0 0 2 Mshowa
p
.002 w
.30031 0 m
.30031 .00625 L
s
P
[(20)] .30031 0 0 2 Mshowa
p
.002 w
.45392 0 m
.45392 .00625 L
s
P
[(30)] .45392 0 0 2 Mshowa
p
.002 w
.60753 0 m
.60753 .00625 L
s
P
[(40)] .60753 0 0 2 Mshowa
p
.002 w
.76114 0 m
.76114 .00625 L
s
P
[(50)] .76114 0 0 2 Mshowa
p
.002 w
.91475 0 m
.91475 .00625 L
s
P
[(60)] .91475 0 0 2 Mshowa
p
.001 w
.02381 0 m
.02381 .00375 L
s
P
p
.001 w
.05453 0 m
.05453 .00375 L
s
P
p
.001 w
.08525 0 m
.08525 .00375 L
s
P
p
.001 w
.11598 0 m
.11598 .00375 L
s
P
p
.001 w
.17742 0 m
.17742 .00375 L
s
P
p
.001 w
.20814 0 m
.20814 .00375 L
s
P
p
.001 w
.23886 0 m
.23886 .00375 L
s
P
p
.001 w
.26959 0 m
.26959 .00375 L
s
P
p
.001 w
.33103 0 m
.33103 .00375 L
s
P
p
.001 w
.36175 0 m
.36175 .00375 L
s
P
p
.001 w
.39247 0 m
.39247 .00375 L
s
P
p
.001 w
.4232 0 m
.4232 .00375 L
s
P
p
.001 w
.48464 0 m
.48464 .00375 L
s
P
p
.001 w
.51536 0 m
.51536 .00375 L
s
P
p
.001 w
.54608 0 m
.54608 .00375 L
s
P
p
.001 w
.5768 0 m
.5768 .00375 L
s
P
p
.001 w
.63825 0 m
.63825 .00375 L
s
P
p
.001 w
.66897 0 m
.66897 .00375 L
s
P
p
.001 w
.69969 0 m
.69969 .00375 L
s
P
p
.001 w
.73041 0 m
.73041 .00375 L
s
P
p
.001 w
.79186 0 m
.79186 .00375 L
s
P
p
.001 w
.82258 0 m
.82258 .00375 L
s
P
p
.001 w
.8533 0 m
.8533 .00375 L
s
P
p
.001 w
.88402 0 m
.88402 .00375 L
s
P
p
.001 w
.94547 0 m
.94547 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
-0.00691 .12361 m
-0.00066 .12361 L
s
P
[(0.2)] -0.01941 .12361 1 0 Mshowa
p
.002 w
-0.00691 .24721 m
-0.00066 .24721 L
s
P
[(0.4)] -0.01941 .24721 1 0 Mshowa
p
.002 w
-0.00691 .37082 m
-0.00066 .37082 L
s
P
[(0.6)] -0.01941 .37082 1 0 Mshowa
p
.002 w
-0.00691 .49443 m
-0.00066 .49443 L
s
P
[(0.8)] -0.01941 .49443 1 0 Mshowa
p
.002 w
-0.00691 .61803 m
-0.00066 .61803 L
s
P
[(1)] -0.01941 .61803 1 0 Mshowa
p
.001 w
-0.00691 .02472 m
-0.00316 .02472 L
s
P
p
.001 w
-0.00691 .04944 m
-0.00316 .04944 L
s
P
p
.001 w
-0.00691 .07416 m
-0.00316 .07416 L
s
P
p
.001 w
-0.00691 .09889 m
-0.00316 .09889 L
s
P
p
.001 w
-0.00691 .14833 m
-0.00316 .14833 L
s
P
p
.001 w
-0.00691 .17305 m
-0.00316 .17305 L
s
P
p
.001 w
-0.00691 .19777 m
-0.00316 .19777 L
s
P
p
.001 w
-0.00691 .22249 m
-0.00316 .22249 L
s
P
p
.001 w
-0.00691 .27193 m
-0.00316 .27193 L
s
P
p
.001 w
-0.00691 .29666 m
-0.00316 .29666 L
s
P
p
.001 w
-0.00691 .32138 m
-0.00316 .32138 L
s
P
p
.001 w
-0.00691 .3461 m
-0.00316 .3461 L
s
P
p
.001 w
-0.00691 .39554 m
-0.00316 .39554 L
s
P
p
.001 w
-0.00691 .42026 m
-0.00316 .42026 L
s
P
p
.001 w
-0.00691 .44498 m
-0.00316 .44498 L
s
P
p
.001 w
-0.00691 .46971 m
-0.00316 .46971 L
s
P
p
.001 w
-0.00691 .51915 m
-0.00316 .51915 L
s
P
p
.001 w
-0.00691 .54387 m
-0.00316 .54387 L
s
P
p
.001 w
-0.00691 .56859 m
-0.00316 .56859 L
s
P
p
.001 w
-0.00691 .59331 m
-0.00316 .59331 L
s
P
p
.002 w
-0.00691 0 m
-0.00691 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.02381 .30902 Mdot
.05453 .30902 Mdot
.11598 .30902 Mdot
.23886 .30902 Mdot
.48464 .30902 Mdot
.97619 .30902 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21; rightWrapOffset = 540]
Or multiples of two.
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[n = 2j;
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {j, 1, 25}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540; fontLeading = 0]
{{2, 0.5}, {4, 0.5}, {6, 0.3333333333333333}, {8, 0.5}, 
 {10, 0.4}, {12, 0.3333333333333333}, {14, 0.4285714285714286}, 
 {16, 0.5}, {18, 0.3333333333333333}, {20, 0.4}, 
 {22, 0.4545454545454545}, {24, 0.3333333333333333}, 
 {26, 0.4615384615384616}, {28, 0.4285714285714286}, 
 {30, 0.2666666666666666}, {32, 0.5}, {34, 0.4705882352941177}, 
 {36, 0.3333333333333333}, {38, 0.4736842105263158}, {40, 0.4}, 
 {42, 0.2857142857142857}, {44, 0.4545454545454545}, 
 {46, 0.4782608695652174}, {48, 0.3333333333333333}, {50, 0.4}}
;[o]
{{2, 0.5}, {4, 0.5}, {6, 0.333333}, {8, 0.5}, {10, 0.4}, 
 {12, 0.333333}, {14, 0.428571}, {16, 0.5}, {18, 0.333333}, 
 {20, 0.4}, {22, 0.454545}, {24, 0.333333}, {26, 0.461538}, 
 {28, 0.428571}, {30, 0.266667}, {32, 0.5}, {34, 0.470588}, 
 {36, 0.333333}, {38, 0.473684}, {40, 0.4}, {42, 0.285714}, 
 {44, 0.454545}, {46, 0.478261}, {48, 0.333333}, {50, 0.4}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0190476 0 0.618034 [
[(0)] .02381 0 0 2 Msboxa
[(10)] .21429 0 0 2 Msboxa
[(20)] .40476 0 0 2 Msboxa
[(30)] .59524 0 0 2 Msboxa
[(40)] .78571 0 0 2 Msboxa
[(50)] .97619 0 0 2 Msboxa
[(0.2)] .01131 .12361 1 0 Msboxa
[(0.4)] .01131 .24721 1 0 Msboxa
[(0.6)] .01131 .37082 1 0 Msboxa
[(0.8)] .01131 .49443 1 0 Msboxa
[(1)] .01131 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(10)] .21429 0 0 2 Mshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(20)] .40476 0 0 2 Mshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(30)] .59524 0 0 2 Mshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(40)] .78571 0 0 2 Mshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(50)] .97619 0 0 2 Mshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
.02381 .12361 m
.03006 .12361 L
s
P
[(0.2)] .01131 .12361 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(0.4)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .37082 m
.03006 .37082 L
s
P
[(0.6)] .01131 .37082 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(0.8)] .01131 .49443 1 0 Mshowa
p
.002 w
.02381 .61803 m
.03006 .61803 L
s
P
[(1)] .01131 .61803 1 0 Mshowa
p
.001 w
.02381 .02472 m
.02756 .02472 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .07416 m
.02756 .07416 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .17305 m
.02756 .17305 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .22249 m
.02756 .22249 L
s
P
p
.001 w
.02381 .27193 m
.02756 .27193 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .32138 m
.02756 .32138 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .42026 m
.02756 .42026 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46971 m
.02756 .46971 L
s
P
p
.001 w
.02381 .51915 m
.02756 .51915 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56859 m
.02756 .56859 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.0619 .30902 Mdot
.1 .30902 Mdot
.1381 .20601 Mdot
.17619 .30902 Mdot
.21429 .24721 Mdot
.25238 .20601 Mdot
.29048 .26487 Mdot
.32857 .30902 Mdot
.36667 .20601 Mdot
.40476 .24721 Mdot
.44286 .28092 Mdot
.48095 .20601 Mdot
.51905 .28525 Mdot
.55714 .26487 Mdot
.59524 .16481 Mdot
.63333 .30902 Mdot
.67143 .29084 Mdot
.70952 .20601 Mdot
.74762 .29275 Mdot
.78571 .24721 Mdot
.82381 .17658 Mdot
.8619 .28092 Mdot
.9 .29558 Mdot
.9381 .20601 Mdot
.97619 .24721 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; watchDingbatToken; leftWrapOffset = 21; rightWrapOffset = 540]
Or powers of three.
:[font = input; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
percents = Table[n = 3^j;
	{n, N[Length[Select[OrderOfAllElements[Z[n]],
	(#[[2]]==n)&]]/n]}, {j, 1, 4}]
ListPlot[percents, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = output; output; inactive; locked; preserveAspect; rightWrapOffset = 540]
{{3, 0.6666666666666666}, {9, 0.6666666666666666}, 
 {27, 0.6666666666666666}, {81, 0.6666666666666666}}
;[o]
{{3, 0.666667}, {9, 0.666667}, {27, 0.666667}, {81, 0.666667}}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 240; pictureHeight = 148; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0128205 0.01221 0 0.618034 [
[(20)] .23138 0 0 2 Msboxa
[(40)] .47558 0 0 2 Msboxa
[(60)] .71978 0 0 2 Msboxa
[(80)] .96398 0 0 2 Msboxa
[(0.2)] -0.02532 .12361 1 0 Msboxa
[(0.4)] -0.02532 .24721 1 0 Msboxa
[(0.6)] -0.02532 .37082 1 0 Msboxa
[(0.8)] -0.02532 .49443 1 0 Msboxa
[(1)] -0.02532 .61803 1 0 Msboxa
[ -0.01382 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.23138 0 m
.23138 .00625 L
s
P
[(20)] .23138 0 0 2 Mshowa
p
.002 w
.47558 0 m
.47558 .00625 L
s
P
[(40)] .47558 0 0 2 Mshowa
p
.002 w
.71978 0 m
.71978 .00625 L
s
P
[(60)] .71978 0 0 2 Mshowa
p
.002 w
.96398 0 m
.96398 .00625 L
s
P
[(80)] .96398 0 0 2 Mshowa
p
.001 w
.28022 0 m
.28022 .00375 L
s
P
p
.001 w
.32906 0 m
.32906 .00375 L
s
P
p
.001 w
.3779 0 m
.3779 .00375 L
s
P
p
.001 w
.42674 0 m
.42674 .00375 L
s
P
p
.001 w
.52442 0 m
.52442 .00375 L
s
P
p
.001 w
.57326 0 m
.57326 .00375 L
s
P
p
.001 w
.6221 0 m
.6221 .00375 L
s
P
p
.001 w
.67094 0 m
.67094 .00375 L
s
P
p
.001 w
.76862 0 m
.76862 .00375 L
s
P
p
.001 w
.81746 0 m
.81746 .00375 L
s
P
p
.001 w
.8663 0 m
.8663 .00375 L
s
P
p
.001 w
.91514 0 m
.91514 .00375 L
s
P
p
.001 w
.18254 0 m
.18254 .00375 L
s
P
p
.001 w
.1337 0 m
.1337 .00375 L
s
P
p
.001 w
.08486 0 m
.08486 .00375 L
s
P
p
.001 w
.03602 0 m
.03602 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
-0.01282 .12361 m
-0.00657 .12361 L
s
P
[(0.2)] -0.02532 .12361 1 0 Mshowa
p
.002 w
-0.01282 .24721 m
-0.00657 .24721 L
s
P
[(0.4)] -0.02532 .24721 1 0 Mshowa
p
.002 w
-0.01282 .37082 m
-0.00657 .37082 L
s
P
[(0.6)] -0.02532 .37082 1 0 Mshowa
p
.002 w
-0.01282 .49443 m
-0.00657 .49443 L
s
P
[(0.8)] -0.02532 .49443 1 0 Mshowa
p
.002 w
-0.01282 .61803 m
-0.00657 .61803 L
s
P
[(1)] -0.02532 .61803 1 0 Mshowa
p
.001 w
-0.01282 .02472 m
-0.00907 .02472 L
s
P
p
.001 w
-0.01282 .04944 m
-0.00907 .04944 L
s
P
p
.001 w
-0.01282 .07416 m
-0.00907 .07416 L
s
P
p
.001 w
-0.01282 .09889 m
-0.00907 .09889 L
s
P
p
.001 w
-0.01282 .14833 m
-0.00907 .14833 L
s
P
p
.001 w
-0.01282 .17305 m
-0.00907 .17305 L
s
P
p
.001 w
-0.01282 .19777 m
-0.00907 .19777 L
s
P
p
.001 w
-0.01282 .22249 m
-0.00907 .22249 L
s
P
p
.001 w
-0.01282 .27193 m
-0.00907 .27193 L
s
P
p
.001 w
-0.01282 .29666 m
-0.00907 .29666 L
s
P
p
.001 w
-0.01282 .32138 m
-0.00907 .32138 L
s
P
p
.001 w
-0.01282 .3461 m
-0.00907 .3461 L
s
P
p
.001 w
-0.01282 .39554 m
-0.00907 .39554 L
s
P
p
.001 w
-0.01282 .42026 m
-0.00907 .42026 L
s
P
p
.001 w
-0.01282 .44498 m
-0.00907 .44498 L
s
P
p
.001 w
-0.01282 .46971 m
-0.00907 .46971 L
s
P
p
.001 w
-0.01282 .51915 m
-0.00907 .51915 L
s
P
p
.001 w
-0.01282 .54387 m
-0.00907 .54387 L
s
P
p
.001 w
-0.01282 .56859 m
-0.00907 .56859 L
s
P
p
.001 w
-0.01282 .59331 m
-0.00907 .59331 L
s
P
p
.002 w
-0.01282 0 m
-0.01282 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
p
.008 w
.02381 .41202 Mdot
.09707 .41202 Mdot
.31685 .41202 Mdot
.97619 .41202 Mdot
P
P
% End of Graphics
MathPictureEnd

:[font = special3; inactive; preserveAspect]
Q15. Do you wish to change any of your conjectures? Can you prove any of them?
;[s]
2:0,1;3,0;79,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.7 More questions about U(n)
:[font = text; inactive; preserveAspect]
What is the order of the group U(n), as a function of n? We now investigate this.

Below is a list of the orders |U(n)| for n from 1 to 60, followed by a ListPlot of the same.
;[s]
3:0,0;154,1;162,0;176,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
data = Table[Size[U[n]], {n, 1, 60}]
ListPlot[data];
:[font = special3; inactive; preserveAspect]
Q16. Why does the ListPlot seem to be limited to the lower triangle of the above rectangle? What values are making the "diagonal"?
;[s]
4:0,1;3,0;18,2;26,0;131,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's now change the form of what we observe. Below, instead of simply making a list of the orders, we divide the order of the group by the index n and then plot these values.
:[font = input; preserveAspect]
data = MapIndexed[#1/First[#2]&, data]
ListPlot[data, AxesOrigin -> {0, 0}, PlotRange -> {0, 1}];
:[font = special3; inactive; preserveAspect]
Q17. Does this look at all familiar? Have you seen this before?
;[s]
2:0,1;3,0;64,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's continue our investigation into the order of U(n) by considering various types of integers n.
:[font = text; inactive; preserveAspect]
For example, when n is prime we get
:[font = input; preserveAspect]
data1 = Table[n = Prime[p];
	{n, Size[U[n]]}, {p, 1, 40}]
data2 = Table[n = Prime[p];
	{n, Size[U[n]]/n}, {p, 1, 40}];
Show[GraphicsArray[{ListPlot[data1,DisplayFunction ->
	Identity, Ticks -> {Table[50i,{i, 1, 4}], Automatic}], 
	ListPlot[data2, DisplayFunction ->
	Identity, PlotRange -> {0, 1},
	Ticks -> {Table[50i, {i, 1, 4}], Automatic}]}], 
	DisplayFunction -> $DisplayFunction];
:[font = text; inactive; preserveAspect]
The first plot reflects the orders of U[n] for prime n (horizontal axis is n and vertical is |U[n]|). The second plot has the vertical axis being |U[n]/n| (again, for prime n). We will use just the latter type of plot below.

When n is a power of two we get:
:[font = input; preserveAspect]
max = 8;
data1 = Table[n = 2^p;
	{n, Size[U[n]]}, {p, 1, max}]
data2 = Table[n = 2^p;
	{n, Size[U[n]]/n}, {p, 1, max}]
ListPlot[data2, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = text; inactive; preserveAspect]
Or when n is a power of three we get:
:[font = input; preserveAspect]
max = 8;
data1 = Table[n = 3^p;
	{n, Size[U[n]]}, {p, 1, max}]
data2 = Table[n = 3^p;
	{n, Size[U[n]]/n}, {p, 1, max}]
ListPlot[data2, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = special3; inactive; preserveAspect]
Q18. The code below shows similar results for powers of 4. Evaluate it. Then change it to powers of 5, 6, 7, 8, 9 and so on until you can make some kind of conjecture. Can you prove it? (max is the number of terms to compute; you may wish to reduce this to 5 for larger values.)
;[s]
4:0,1;3,0;186,2;190,0;279,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
powersOf = 4;
max = 6;
data1 = Table[n = powersOf^p;
	{n, Size[U[n]]}, {p, 1, max}]
data2 = Table[n = powersOf^p;
	{n, Size[U[n]]/n}, {p, 1, max}]
ListPlot[data2, PlotRange -> {0, 1}, AxesOrigin -> {0, 0}];
:[font = text; inactive; preserveAspect]
Now consider multiples of three:
;[s]
3:0,0;13,1;22,0;33,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
data1 = Table[n = 3p;
	{n, Size[U[n]]}, {p, 1, 40}]
data2 = Table[n = 3p;
	{n, Size[U[n]]/n}, {p, 1, 40}];
Show[GraphicsArray[{ListPlot[data1, DisplayFunction ->
	Identity, PlotStyle -> {RGBColor[0, 0, 1], PointSize[0.025]}],
	ListPlot[data2, DisplayFunction -> Identity, AxesOrigin ->
	{0, 0}, PlotRange -> {0, 1}, PlotStyle -> {RGBColor[0, 0, 1],
	PointSize[0.025]}]}], DisplayFunction -> $DisplayFunction];
:[font = text; inactive; preserveAspect]
If the graphs appear a little small, click on the graph, then move the mouse to the lower right corner. When the cursor is a double arrow (facing NW and SE), then press down and drag to an appropriate size.
:[font = special3; inactive; preserveAspect]
Q19. Can you see any dichotomy in the graphs above? Describe it. Try to explain why this exists? Look at the data above which is used to generate the plots. (In particular, consider factoring some of the indices.)
;[s]
2:0,1;3,0;214,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's try this for multiples of two:
:[font = input; preserveAspect]
multiplesOf = 2;
max = 60;
data1 = Table[n = multiplesOf*p;
	{n, Size[U[n]]}, {p, 1, max}]
data2 = Table[n = multiplesOf*p;
	{n, Size[U[n]]/n}, {p, 1, max}];
Show[GraphicsArray[{ListPlot[data1, DisplayFunction ->
	Identity, PlotStyle -> {RGBColor[0, 0, 1],PointSize[0.025]}],
	ListPlot[data2, DisplayFunction -> Identity, AxesOrigin ->
	{0,0}, PlotRange -> {0, 1}, PlotStyle -> {RGBColor[0, 0, 1],
	PointSize[0.025]}]}], DisplayFunction -> $DisplayFunction];
:[font = special3; inactive; preserveAspect]
Q20. Change the above (by changing the first line) to multiples of 5, 6, 7, 8, 9 and so on until you can make some kind of conjecture. (Again, max indicates the number of terms that are calculated; you may wish to modify this.) Can you provide any proof? 
;[s]
4:0,1;3,0;143,2;146,0;256,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q21. What is the order of U(n)? Give as complete an answer as possible, even if you don't have all the cases covered.
;[s]
2:0,1;3,0;118,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.8 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?ShowOne
:[font = input; preserveAspect]
?ColumnForm
:[font = input; preserveAspect]
?Operation
:[font = input; preserveAspect]
?ElementToPower
:[font = input; preserveAspect]
?Table
:[font = input; preserveAspect]
?Order
:[font = input; preserveAspect]
?GroupInverse
:[font = input; preserveAspect]
?TableForm
:[font = input; preserveAspect]
?Random
:[font = input; preserveAspect]
?RandomElement
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?ShowGroupOrders
:[font = input; preserveAspect]
?CollectOrders
:[font = input; preserveAspect]
?Orders
:[font = input; preserveAspect]
?OrderOfAllElements
:[font = input; preserveAspect]
?Length 
:[font = input; preserveAspect]
?ListPlot
:[font = input; preserveAspect]
?Apply
:[font = input; preserveAspect]
?Size
:[font = input; preserveAspect; endGroup; endGroup]
?U
^*)
