(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 5. Subversively grouping our elements
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should be familiar with the definition of a subgroup of a group.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
What constitutes a subgroup? What elements are necessary before a set can be considered a subgroup? What do the subgroups of Z[n] look like? What about the subgroups of U(n)? What is the probability that a randomly chosen subset of elements from Z[n] will actually be a subgroup? What elements of Z[n] will guarantee closure to the full group? These are some of the questions that will be explored in this lab.
;[s]
3:0,0;317,1;324,0;411,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.3 When do we have a subgroup?
:[font = text; inactive; preserveAspect]
In Lab 3, we considered when a set with an operation on the set forms a group. In this lab, we consider when a subset of a group is a group in its own right (when using the operation from the parent set). 

First, let's consider a random group Z[n] for n in [6, 20]. To define this group, we need to first read in the Mathematica package that defines Z[n] and the other functions that we will be using.
;[s]
3:0,0;318,1;329,0;403,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect]
n = Random[Integer, {6, 20}]
G = Z[n]
:[font = text; inactive; preserveAspect]
Next, we pick a random integer m, less than n, and then choose this many elements from G and put them in a set that we call H.
:[font = input; preserveAspect]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}]
H = RandomElements[G, m, Replacement -> False]
:[font = text; inactive; preserveAspect]
The question we would like to pursue first is whether this set H forms a subgroup of G, and if not, how can we make one with it.
:[font = special3; inactive; preserveAspect]
Q1. In this case, is H a subgroup of G? Justify your answer. (Indicate the group G and subset H that were chosen.)
;[s]
2:0,1;2,0;115,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now, use the command below to confirm your answer to the previous question.
:[font = input; preserveAspect]
SubgroupQ[H, G]
:[font = text; inactive; preserveAspect]
Simply knowing whether it is true or false if H is a subgroup of G is of limited value. We would also like to know how to make H become a subgroup (by adding certain elements, if necessary). Let's look at a Cayley table where we focus on the elements of H.
:[font = input; preserveAspect]
SubgroupQ[H, G, Mode -> Visual]
:[font = text; inactive; preserveAspect]
Note that the elements colored red are in G, but not in H.
:[font = special3; inactive; preserveAspect]
Q2. The presence of red elements (if any) indicates that the set H does not satisfy what property relative to the operation in G?
;[s]
2:0,1;2,0;130,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
What would happen if we modified H to include some (or all) of the elements that were sums of elements in H, but not already in H (namely, the red elements)? In the variable labeled ElementsToAdd, add the elements (between {}) you would like to join to H to see if you can make H a subgroup of G.
;[s]
3:0,0;182,1;195,0;297,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ElementsToAdd = {}; (* <- add elements here *)
H = Join[H,ElementsToAdd]//Union
SubgroupQ[H, G, Mode -> Visual];
;[s]
3:0,0;20,1;46,0;113,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,10,Courier,1,12,0,0,65535;
:[font = special3; inactive; preserveAspect]
Q3. By deleting the previous elements in the list ElementsToAdd and replacing them with new ones, keep modifying the above code until you have enlarged H to become a subgroup. You will know that you are done if there are no longer any red elements. (It may be the case that you have enlarged H to become G itself.) What is your subgroup H? (Also, what was your group G?)
;[s]
4:0,1;2,0;50,2;63,0;371,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's try this again:
:[font = input; preserveAspect]
n = Random[Integer, {6, 20}];
G = Z[n]
:[font = input; preserveAspect]
m = Random[Integer,{1, Floor[N[Sqrt[n]]]}]
H = RandomElements[G, m, Replacement -> False]
SubgroupQ[H, G, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q4. As before, keep modifying the code below until you have enlarged H to become a subgroup. What is your subgroup H? (Also, what was your group G and the original H?)
;[s]
2:0,1;2,0;168,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
ElementsToAdd = {}; (* <- add elements here *)
H = Join[H,ElementsToAdd]//Union
SubgroupQ[H, G, Mode -> Visual];
;[s]
3:0,0;20,1;46,0;113,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,10,Courier,1,12,0,0,65535;
:[font = text; inactive; preserveAspect]
Once you feel comfortable knowing how to enlarge H to make it a subgroup, we can ask Mathematica to do that part and you can focus on related issues. We call the new subgroup of G formed from the set H the closure of H in G and we can use the Closure command.

Let's try this with a new group.
;[s]
7:0,0;85,1;96,0;206,1;223,0;243,2;250,0;294,-1;
3:4,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
n = Random[Integer, {6, 20}];
G = Z[n]
:[font = input; preserveAspect]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}]
H = RandomElements[G, m, Replacement -> False]
:[font = text; inactive; preserveAspect]
If all we want is to determine the closure of H, we use the following.
:[font = input; preserveAspect]
Closure[G, H]
:[font = text; inactive; preserveAspect]
(Apply SortGroupoid to this result if you want to see the elements ordered.) If we ever want to know what else we can do with a function, it is often useful to ask for information about the function:
;[s]
3:0,0;7,1;19,0;200,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?Closure
:[font = text; inactive; preserveAspect]
Let's try a few of these variations.
:[font = input; preserveAspect]
Closure[G, H, ReportIterations -> True]
:[font = text; inactive; preserveAspect]
Note that this returns the closure of H first, followed by the number of iterations, and the results of each iteration.

Let's consider another option:
:[font = input; preserveAspect]
Closure[G, H, Mode -> Visual]
:[font = text; inactive; preserveAspect]
This simply shows the same information visually. These graphics can now be animated, if desired. (To do so, double-click on one of the graphics and adjust the motion with the arrow keys.)

If one does not want to see all the graphics at once, one can try the following.
:[font = input; preserveAspect]
Closure[G, H, Mode -> Visual, Staged -> True];
:[font = text; inactive; preserveAspect]
To see the next stage, evaluate the following.
:[font = input; preserveAspect]
NextStage[Closure];
:[font = text; inactive; preserveAspect]
Or to see a previous stage, try
:[font = input; preserveAspect]
PreviousStage[Closure];
:[font = text; inactive; preserveAspect]
Either of these last two commands can be repeatedly cycled.

Test yourself one more time; evaluate the following.
:[font = input; preserveAspect]
n = Random[Integer, {6, 20}]
G = Z[n]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}]
:[font = input; preserveAspect]
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Mode -> Visual, Staged -> True];
:[font = text; inactive; preserveAspect]
You should know which elements need to be added. Now predict which elements will be colored red, if any, in the next iteration. When you think you know, evaluate the following. Keep doing this until you have found the closure of H.
:[font = input; preserveAspect]
NextStage[Closure];
:[font = special3; inactive; preserveAspect]
Q5. You may have noticed that sometimes the closure becomes the whole group. There are many questions related to this to think about, some of which we consider in this lab. Here is one with which to start. If we let H(n) be the size of the closure of H at the nth iteration (so H(1) = |H|), how big does H(n) have to become before we can be certain that the closure of H will be all of G? You may wish to evaluate the cell below a number of times to gain some insights.
;[s]
8:0,1;2,0;216,2;220,0;278,2;288,0;304,2;308,0;470,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
n = Random[Integer, {6, 30}];
G = Z[n]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}];
:[font = input; preserveAspect; endGroup]
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, ReportIterations -> True]//Last//Last//ColumnForm
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.4 Subgroups of Z[n]
:[font = text; inactive; preserveAspect]
Let's pick a random group Z[n], where n is in [6, 30].
:[font = input; preserveAspect]
n = Random[Integer, {6, 30}]
G = Z[n]
:[font = text; inactive; preserveAspect]
What are the subgroups of this group G = Z[n]? One naive way of exploring this would be to pick a random set of elements and look at the closure, which we have seen always results in a subgroup. If this is repeated enough times, one might find all the subgroups of the group. Let's try this. Evaluate the following 3 to 5 times.
:[font = input; preserveAspect]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}];
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Sort -> True] 
(* we sort the list to improve readability *)
:[font = text; inactive; preserveAspect]
You may notice that the full group is often returned. Suppose we try restricting the number of elements in H to 1 or 2. Try evaluating the following a number of times.
:[font = input; preserveAspect]
m = Random[Integer, {1, 2}];
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Sort -> True]
:[font = special3; inactive; preserveAspect]
Q6. What do you think are the subgroups of Z[n] for the n with which you have been working? (Also indicate what n you were given.)
;[s]
2:0,1;2,0;131,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's get a new group and try this again.
:[font = input; preserveAspect]
n = Random[Integer, {6, 30}]
G = Z[n]
:[font = input; preserveAspect]
m = Random[Integer, {1, 2}];
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Sort -> True]
:[font = special3; inactive; preserveAspect]
Q7. What group did you get this time? What do you think are the subgroups for this group?
;[s]
2:0,1;2,0;90,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.5 P(H < G) for a random subset H of G = Z[n]
:[font = text; inactive; preserveAspect]
Suppose we consider the group Z[12]. Recall that if H is a subgroup of G, we sometimes denote this by H < G. If we choose a random set of elements, H, from the elements of G, what is the probability that H is indeed a subgroup of G (denoted P(H<G))? In this section, we wish to pursue this question (and modifications of it, using other indices n in Z[n]).
:[font = input; preserveAspect]
G = Z[12]
:[font = text; inactive; preserveAspect]
First we start with |H| = 1. Evaluate the following to determine the results of randomly choosing one element 30 different times to see if it forms a subgroup of G.
:[font = input; preserveAspect]
orderOfH = 1;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {30}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = special3; inactive; preserveAspect]
Q8. Out of the 30 attempts, how many of these yielded a subgroup? What did you expect to happen? What would you expect to happen if 100 people did this experiment and each ran the loop for 1000 times instead of 30? Justify your answer. You should have an answer for P(H < Z[12]) for H = {g} for some g in Z[12].
;[s]
2:0,1;2,0;312,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Next, we consider the case when |H| = 2. Evaluate the following to determine the results of choosing two elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect]
orderOfH = 2;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect]
If you didn't get a True, try evaluating this cell again (which will not guarantee a True, but may be worth trying, in some cases).
;[s]
5:0,0;20,1;24,0;85,1;89,0;132,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q9. How many successes did you have? (That is, how many times did you get True?) Which pair of elements yielded a subgroup, if any? Is there any (other) subset of size two that will (also) be a subgroup? Why or why not? Given a random set H of two elements from Z[12], what do you think is the probability that H will be a subgroup (i.e., P(H < Z[12]))?
;[s]
4:0,1;2,0;74,2;78,0;354,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Next, we consider the case when |H| = 3. Evaluate the following to determine the results of choosing three elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect]
orderOfH = 3;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect]
If you didn't get a True, try evaluating this cell again. (Again, no guarantee.)
;[s]
3:0,0;20,1;24,0;81,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q10. How many successes did you have? Which triple of elements yielded a subgroup, if any? Is there any (other) subset of size three that will (also) be a subgroup? Why or why not? Given a random set H consisting of three elements of Z[12], what is P(H < Z[12])?
;[s]
4:0,1;3,0;233,2;234,0;263,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Next, we consider the case when |H| = 4. Evaluate the following to determine the results of choosing four elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect]
orderOfH = 4;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect]
If you didn't get a True, evaluate again until you do, keeping track of how many attempts were made. If you get tired of doing this, and think you know what you should expect, you can quit.
;[s]
3:0,0;20,1;24,0;190,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
Next, we consider the case when |H| = 5. Evaluate the following to determine the results of choosing five elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect]
orderOfH = 5;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect]
Keep trying the above to get True or stop when you think you know what is likely to happen.
;[s]
3:0,0;29,1;33,0;92,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
Keep increasing the order of H and evaluating the cell above until you can answer the following question.
:[font = special3; inactive; preserveAspect]
Q11. Given G = Z[12], what are the different possible orders of the subgroups of G? Also, how many subgroups are there of each order?
;[s]
2:0,1;3,0;134,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Now suppose we have G = Z[10]. What are the orders of the subgroups of G and how many subgroups are there of each order? Use the cell below if you want to do some experimenting.
;[s]
2:0,1;3,0;183,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
G = Z[10];

orderOfH = 1;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = special3; inactive; preserveAspect]
Q13. Now suppose we have G = Z[11]. What are the orders of the subgroups of G and how many are there of each order? Use the cell below if you want to do some experimenting.
;[s]
2:0,1;3,0;173,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
G = Z[11];

orderOfH = 1;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = special3; inactive; preserveAspect]
Q14. Summarize your findings by writing a conjecture about the subgroup structure of Z[n]. How might you prove your answer?
;[s]
2:0,1;3,0;124,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q15. Given G = Z[n], and a subset H of G with |H| = m, what is P(H < G)?
;[s]
4:0,1;3,0;62,2;63,0;73,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q16. Look back at the subgroups you found for Z[12]. Starting with the subgroup(s) of order 2 and working up, what can you say about the relationship(s), if any, between the order of the subgroup, the elements of Z[12], and the actual elements in the subgroup?
;[s]
4:0,1;3,0;174,2;179,0;261,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q17. Do you think the results summarized in question 14 pertain only to Z[n] or are they valid for other groups (either some or all) as well? Try the following to help you think about this question.
;[s]
2:0,1;3,0;199,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect; endGroup]
G = U[20]

orderOfH = 2;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.6 Necessary elements for full closure
:[font = text; inactive; preserveAspect]
Suppose we focus on the group Z[10] as an example in thinking about the question of what elements must be in a set H to guarantee that we have the closure of H be the entire group.

First we define G.
:[font = input; preserveAspect]
G = Z[10]
:[font = text; inactive; preserveAspect]
Then we will look at a table of random sets H with one or two elements, with their closure.
:[font = input; preserveAspect]
TableForm[Table[m = Random[Integer, {1, 2}];
	{H = RandomElements[G, m, Replacement -> False],
		Elements[Closure[G, H, Sort -> True]]}, {25}], 
		TableHeadings -> {None, {"H", "closure of H\n"}}, 
		TableSpacing -> {0, 3}, TableDepth -> 2]
:[font = special3; inactive; preserveAspect]
Q18. Partition the elements of Z[10] into 3 classes: (1) those whose presence in H cause the closure of H to be the full group, (2) those whose presence in H do NOT cause the closure of H to be the full group, and (3) the remaining elements being ones that you are not sure about their impact.
;[s]
2:0,1;3,0;294,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Next, consider another example, Z[8].
:[font = input; preserveAspect]
G = Z[8]
TableForm[Table[m = Random[Integer, {1, 2}];
	{H = RandomElements[G, m, Replacement -> False],
		Elements[Closure[G, H, Sort -> True]]}, {25}], 
		TableHeadings -> {None, {"H", "closure of H\n"}}, 
		TableSpacing -> {0, 3}, TableDepth -> 2]
:[font = special3; inactive; preserveAspect]
Q19. Repeat the previous question with the results of Z[8].
;[s]
2:0,1;3,0;60,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Finally, consider another example, Z[12].
;[s]
3:0,0;34,1;35,0;42,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
G = Z[12] 
ColumnForm[Table[m = Random[Integer, {1, 2}];
	{H = RandomElements[G, m, Replacement -> False],
		Elements[Closure[G, H, Sort -> True]]}, {25}]]
:[font = special3; inactive; preserveAspect]
Q20. Consider the results of the last three examples. If H = {g, h} is a subset of Z[n] and the closure of H is all of Z[n], what can you conclude about the relationship between at least one of g or h and the number n?
;[s]
4:0,1;3,0;56,2;57,0;219,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.7 Subgroups of U[n]
:[font = text; inactive; preserveAspect]
For a quick review of the group U(n), let's view the first 20 groups when n runs from 1 to 20.
:[font = input; preserveAspect]
ColumnForm[Table[{n, Elements[U[n]]}, {n, 1, 20}]]
:[font = text; inactive; preserveAspect]
From this it should be clear how many elements are in each group listed here (and if you answered all the questions from the last lab, you perhaps know the order of U(n) as a function of n for any n). What about the subgroups of U(n)? Since we know the trivial subgroup consisting of the identity is always a subgroup, as is the full group, we can ignore these. Therefore, the first group to consider for non-trivial subgroups is U(5). (Why?) Furthermore, we know that any subgroup must have the identity, so we can be sure that 1 will be in any subgroup.
:[font = text; inactive; preserveAspect]
Let's look at the possible subgroups of U(5) by first considering all the nonidentity elements. (Recall what the complement of a set is, and that 1 is the identity.)
:[font = input; preserveAspect]
els = Complement[Elements[U[5]], {1}]
:[font = text; inactive; preserveAspect]
These are the elements from which we need to consider all possible subsets. The function KSubsets (from DiscreteMath`Combinatorica) does this job.
;[s]
5:0,0;89,1;97,0;104,1;130,0;147,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?KSubsets
:[font = text; inactive; preserveAspect]
We will make a table of all possible subsets of length 1, 2, ... up to one less than the length of els, which is 2 (= 3 - 1) in this case. (We have deleted the identity 1 from els, and we know the full group is a subgroup, so we search for sets of length up to two less than the size of our group.)
;[s]
5:0,0;99,1;102,0;176,1;179,0;299,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Table[KSubsets[els, i], {i, Length[els]-1}]
:[font = text; inactive; preserveAspect]
There are too many levels of braces, so we remove one layer:
:[font = input; preserveAspect]
Flatten[%, 1]
:[font = text; inactive; preserveAspect]
Now we want to join the identity back into each of these. These are now candidates for being (proper) subgroups.
;[s]
3:0,0;72,1;82,0;113,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Hsets = Map[Join[{1}, #]&, %]
:[font = text; inactive; preserveAspect]
The next step is to test each one by mapping the SubgroupQ function on each.
;[s]
3:0,0;49,1;58,0;77,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
subgroups = Map[SubgroupQ[#, U[5]]&, Hsets]
:[font = text; inactive; preserveAspect]
It is easier to see which are subgroups if we match up the sets with these results:
:[font = input; preserveAspect]
Transpose[{Hsets, subgroups}]//MatrixForm
:[font = special3; inactive; preserveAspect]
Q21. From the above information, what can you say about the order of the element 2? What about 3? What about 4? Do you think U(5) is cyclic or not? Justify your answer.
;[s]
4:0,1;3,0;125,2;129,0;169,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now let's put all the steps above into one compact function that gives the final output as above.
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[n_Integer?Positive] := 
		Module[{els, Hsets, subgroups},
	els = Complement[Elements[U[n]], {1}];
	Hsets = Flatten[Table[KSubsets[els, i], {i, Length[els]-1}], 1];
	Hsets = Map[Join[#, {1}]&, Hsets];
	subgroups = Map[SubgroupQ[#, U[n]]&, Hsets];
	Transpose[{Hsets, subgroups}]//MatrixForm
] (* There is no output since this is just a definition *)
:[font = text; inactive; preserveAspect]
It is time to test it on the next index, n = 6.
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[6]
:[font = special3; inactive; preserveAspect]
Q22. What happened? Was there a mistake made in the coding? Think about this! Why was there no output?
;[s]
2:0,1;3,0;103,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
What about n = 7?
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[7]
:[font = text; inactive; preserveAspect]
We see many False conclusions. Why? Can we be more efficient in our search for subgroups? How many elements are there in U(7)?
;[s]
3:0,0;12,1;17,0;127,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Elements[U[7]]//Length
:[font = text; inactive; preserveAspect]
Perhaps through some previous experiences, either in this lab, a previous lab or class work, you have become aware that if we have a subgroup, its order must be a divisor of the order of the group. This is an important result, called Lagrange's Theorem, which will be proven later.

What are the divisors of 6? It is easy in this case, but here is how Mathematica can be asked.
;[s]
3:0,0;352,1;363,0;378,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
divs = Divisors[6]
:[font = text; inactive; preserveAspect]
Now let's gather all the actual "HSets" which our function generates.
:[font = input; preserveAspect]
temp = FindNontrivialSubgroupsOfUn[7][[1]]//Transpose//First
:[font = text; inactive; preserveAspect]
Since we really only have questions about the those of orders 2 and 3 (why?), let's select just those:
:[font = input; preserveAspect]
Select[temp, MemberQ[{2, 3}, Length[#]]&]
:[font = text; inactive; preserveAspect]
Now we can test just these as subgroups. These last several steps are implemented in a new version of our function, given below.
:[font = input; preserveAspect]
Clear[FindNontrivialSubgroupsOfUn];

FindNontrivialSubgroupsOfUn[n_Integer?Positive] := 
		Module[{els, Hsets, subgroups, divs},
	els = Complement[Elements[U[n]], {1}];
	Hsets = Flatten[Table[KSubsets[els, i], {i, Length[els]-1}], 1];
	Hsets = Map[Join[#, {1}]&, Hsets];
	Hsets = Select[Hsets, MemberQ[Complement[Divisors[Order[U[n]]],
		{1, n}], Length[#]]&];
	subgroups = Map[SubgroupQ[#, U[n]]&, Hsets];
	Transpose[{Hsets, subgroups}]//MatrixForm
] (* There is no output since this is just a definition *)
:[font = text; inactive; preserveAspect]
Now we will try it again.
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[7]
:[font = special3; inactive; preserveAspect]
Q23. Do you think U(7) is cyclic? Why or why not? 
;[s]
2:0,1;3,0;51,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[8]
:[font = special3; inactive; preserveAspect]
Q24. Do you think U(8) is cyclic? Why or why not?
;[s]
2:0,1;3,0;50,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[9]
:[font = special3; inactive; preserveAspect]
Q25. Do you think U(9) is cyclic? Why or why not?
;[s]
2:0,1;3,0;50,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[10]
:[font = special3; inactive; preserveAspect]
Q26. Do you think U(10) is cyclic? Why or why not?
;[s]
2:0,1;3,0;51,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
If you are willing to wait a little while, try the following.
:[font = input; preserveAspect]
FindNontrivialSubgroupsOfUn[11]
:[font = special3; inactive; preserveAspect]
Q27. Why does this take so long?
;[s]
2:0,1;3,0;33,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
One can also use a more general function that determines the actual subgroups for any (finite) group (given enough time, memory and disk space). Here we try it on U(20). 
:[font = input; preserveAspect]
Subgroups[U[20]]
:[font = special3; inactive; preserveAspect]
Q28. Do you think U(20) is cyclic? Why or why not?
;[s]
2:0,1;3,0;51,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.8 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?RandomElements
:[font = input; preserveAspect]
?Replacement
:[font = input; preserveAspect]
?SubgroupQ
:[font = input; preserveAspect]
?Mode
:[font = input; preserveAspect]
?Visual
:[font = input; preserveAspect]
?Closure
:[font = input; preserveAspect]
?SortGroupoid
:[font = input; preserveAspect]
?ReportIterations
:[font = input; preserveAspect]
?Staged
:[font = input; preserveAspect]
?NextStage
:[font = input; preserveAspect]
?PreviousStage
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?U
:[font = input; preserveAspect; endGroup; endGroup]
?Subgroups
^*)
