(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 6. Cycling through the groups
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
Other than the basic definitions related to a group, there are no prerequisites.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
We first look at what it means for a group to be cyclic and try to determine the generators when it is. We will try to classify the cyclicity of the groups Z[n], Dihedral[n], and U[n], and determine the set of generators when they are cyclic. Next, we consider the case when the direct product of Z[m] and Z[n] yields a cyclic group. Finally, we look at some of the cyclic subgroups of the infinite additive group of integers, Z.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.3 What, when, how and why about cyclic groups
:[font = text; inactive; preserveAspect]
We need to read in the Master package inside the AbstractAlgebra directory to conduct this lab:
;[s]
5:0,0;23,1;29,0;49,1;64,0;96,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect]
Recall that we say a group G is cyclic if there exists an element g in G such that G = {gk | k in Z}. In this case, we call g a generator of G and denote this relationship by <g> = G. 

Which groups, if any, are cyclic?

First let's consider a random group Z[n], for n in [6, 14].
;[s]
9:0,0;32,2;38,0;89,4;90,0;100,1;128,3;137,1;219,0;281,-1;
5:4,16,12,Times,0,14,0,0,0;2,16,11,Times,0,15,0,0,0;1,16,12,Times,2,14,0,0,0;1,16,11,Times,2,15,0,0,0;1,24,16,Times,32,14,0,0,0;
:[font = input; preserveAspect]
n = Random[Integer, {6, 14}]
G = Z[n]
:[font = text; inactive; preserveAspect]
Is this group cyclic? How can we find out? Recalling the definition of being cyclic (which was written for multiplicative groups), we need to see if there is an element g in G such that the set of multiples of g constitutes the whole group. Let's generate multiples of each element and find out if G is cyclic. Note that since our group G is finite with order n, we only need to consider a finite number of multiples.
;[s]
3:0,0;197,1;206,0;418,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q1. Why is it true that we only need to consider a finite number of multiples? Explain your answer.
;[s]
2:0,1;2,0;100,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
So let's take a look at some multiples of each of the elements in G.
:[font = input; preserveAspect]
els = Elements[G]
TableForm[multiples = Table[j els[[i]], {i, n}, {j, n}],
	TableHeadings -> {Table["multiples of "<>ToString[i]<>":",
	{i, 0, n-1}], None}, TableSpacing -> {0, 1}]
:[font = text; inactive; preserveAspect]
Whoops! These don't all look like elements in G. What did we forget?
:[font = input; preserveAspect]
TableForm[Map[Mod[#, n]&, multiples],
	TableHeadings -> {Table["multiples of "<>ToString[i]<>":",
	{i, 0, n-1}], None}, TableSpacing -> {0, 1}]
:[font = text; inactive; preserveAspect]
The first list of numbers represents multiples of 0, the second list represents multiples of 1, the third list has the multiples of 2 and so on; the last row represents multiples of (n - 1).
:[font = special3; inactive; preserveAspect]
Q2. Do any of these lists represent G? Is G cyclic? What had you expected? If G is cyclic, what are the generators? Does this list of generators surprise you? (Record the group G that was given to you.)
;[s]
2:0,1;2,0;203,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
We can get similar results by using a function called SubgroupGenerated:
;[s]
3:0,0;54,1;71,0;73,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?SubgroupGenerated
:[font = input; preserveAspect]
Table[Elements[SubgroupGenerated[G, g]], 
	{g, 0, n - 1}]//ColumnForm
:[font = text; inactive; preserveAspect]
Let's focus on G = Z[12] for the moment. (If this is the group that was randomly generated for you, pardon the redundancy.)
:[font = input; preserveAspect]
G = Z[12]
:[font = text; inactive; preserveAspect]
Does the element 5 generate the whole group? Let's find out.
:[font = input; preserveAspect]
SubgroupGenerated[G, 5]
:[font = text; inactive; preserveAspect]
The list, as given, is the order in which the elements are generated. To see this with a little more explanation, try the following:
:[font = input; preserveAspect]
SubgroupGenerated[G, 5, Mode -> Textual]
:[font = text; inactive; preserveAspect]
A visual perspective might also be useful. Evaluate the following cell and then double-click on any graphic cell (perhaps closing the enclosing cell bracket first) and then adjust the speed by typing a number from 1 (slow) to 9 (fast). Or you can step through the animation with the (up/down) arrow keys.
:[font = input; preserveAspect]
SubgroupGenerated[G, 5, Mode -> Visual];
:[font = text; inactive; preserveAspect]
What follows is another visual way of seeing the subgroup generated by 5. In this case, the colors indicate the order in which the multiples (powers) occur, following the rainbow; the key at the bottom helps by listing the element in the colored box and the multiple (power) above.
:[font = input; preserveAspect]
SubgroupGenerated[G, 5, Mode -> Visual2]
:[font = text; inactive; preserveAspect]
These illustrations show that indeed Z[12] is cyclic. If there is a Thomas in the crowd, he/she can also try
:[font = input; preserveAspect]
CyclicQ[Z[12]]
:[font = text; inactive; preserveAspect]
It is not only interesting to know whether a group is cyclic, but it is also interesting to know what (other) elements generate the whole group. Try the following:
;[s]
3:0,0;35,1;42,0;164,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
OrderOfAllElements[G, Mode -> Textual]
:[font = special3; inactive; preserveAspect]
Q3. What are the generators of Z[12]? How do you know? Justify your answer.
;[s]
2:0,1;2,0;76,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Using an idea similar to what we saw above, we can also approach this visually:
:[font = input; preserveAspect]
OrderOfAllElements[G, Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q4. Look at this table. What observations can you make? Can you explain any of these observations?
;[s]
2:0,1;2,0;99,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now let's consider the group Z[15].
:[font = input; preserveAspect]
G = Z[15]
:[font = special3; inactive; preserveAspect]
Q5. Determine if Z[15] is cyclic. If so, specify the generators; if not, explain why not.
;[s]
2:0,1;2,0;90,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q6. What about Z[17]?
;[s]
2:0,1;2,0;22,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's check out the cyclicity of some other Z[n].
:[font = input; preserveAspect]
TableForm[Table[{n, CyclicQ[Z[n]]}, {n, 2, 25}],
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 2}, 
	TableHeadings -> {None, {"n", "cyclic?\n"}}]
:[font = special3; inactive; preserveAspect]
Q7. What conclusion can you infer about the cyclicity of Z[n]? Prove your statement, if you can.
;[s]
2:0,1;2,0;97,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q8. For an arbitrary n, what elements are the generators of Z[n]? You should be able to be very specific with a description here. Can you also specify (as a function of n), the number of generators for Z[n]?
;[s]
4:0,1;2,0;177,2;183,0;208,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's think about some other groups. What about the dihedral family? We will start our index at 1.
:[font = input; preserveAspect]
CyclicQ[Dihedral[1]]
:[font = input; preserveAspect]
CyclicQ[Dihedral[2]]
:[font = text; inactive; preserveAspect]
Or if you wish to see this visually, try
:[font = input; preserveAspect]
OrderOfAllElements[Dihedral[2], Mode -> Visual]
:[font = input; preserveAspect]
OrderOfAllElements[Dihedral[3], Mode -> Visual]
:[font = input; preserveAspect]
OrderOfAllElements[Dihedral[4], Mode -> Visual]
:[font = text; inactive; preserveAspect]
Table allows us to quickly look at a few more examples
;[s]
2:0,1;5,0;55,-1;
2:1,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Table[{n, CyclicQ[Dihedral[n]]}, {n, 5, 8}]//TableForm
:[font = special3; inactive; preserveAspect]
Q9. What do you suppose is true about Dihedral[n] being cyclic? Justify your answer. Can you prove it?
;[s]
2:0,1;2,0;103,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
What about the group U(n)? Let's consider a few examples.
:[font = input; preserveAspect]
OrderOfAllElements[U[15], Mode -> Visual]
:[font = input; preserveAspect]
OrderOfAllElements[U[14], Mode -> Visual]
:[font = input; preserveAspect]
OrderOfAllElements[U[13], Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q10. Is U(n) cyclic for all n? Why or why not?
;[s]
2:0,1;3,0;47,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Considering only whether U(n) is cyclic or not, we can use Table and CyclicQ. The following is already generated -- do not evaluate the cell again.
;[s]
5:0,0;59,1;64,0;69,1;76,0;148,-1;
2:3,16,12,Times,0,14,0,0,0;2,13,10,Courier,0,12,0,0,0;
:[font = input; inactive; Cclosed; preserveAspect; watchDingbatToken; startGroup]
TableForm[Table[{n, CyclicQ[U[n]]}, {n, 3, 50}],
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
(* ALREADY EVALUATED - SIMPLY OPEN UP *)
:[font = output; output; inactive; locked; preserveAspect; endGroup]
TableForm[{{3, True}, {4, True}, {5, True}, {6, True}, {7, True}, 
 {8, False}, {9, True}, {10, True}, {11, True}, {12, False}, 
 {13, True}, {14, True}, {15, False}, {16, False}, {17, True}, 
 {18, True}, {19, True}, {20, False}, {21, False}, {22, True}, 
 {23, True}, {24, False}, {25, True}, {26, True}, {27, True}, 
 {28, False}, {29, True}, {30, False}, {31, True}, {32, False}, 
 {33, False}, {34, True}, {35, False}, {36, False}, {37, True}, 
 {38, True}, {39, False}, {40, False}, {41, True}, {42, False}, 
 {43, True}, {44, False}, {45, False}, {46, True}, {47, True}, 
 {48, False}, {49, True}, {50, True}}]
;[o]
3    True

4    True

5    True

6    True

7    True

8    False

9    True

10   True

11   True

12   False

13   True

14   True

15   False

16   False

17   True

18   True

19   True

20   False

21   False

22   True

23   True

24   False

25   True

26   True

27   True

28   False

29   True

30   False

31   True

32   False

33   False

34   True

35   False

36   False

37   True

38   True

39   False

40   False

41   True

42   False

43   True

44   False

45   False

46   True

47   True

48   False

49   True

50   True
:[font = text; inactive; preserveAspect]
Here is another list, that it is also already generated -- do not evaluate the cell again.
:[font = input; inactive; Cclosed; preserveAspect; watchDingbatToken; startGroup]
TableForm[Table[{n, CyclicQ[U[n]]}, {n, 51, 100}],
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
(* ALREADY EVALUATED - SIMPLY OPEN UP *)
:[font = output; output; inactive; locked; preserveAspect; fontLeading = 0; endGroup]
TableForm[{{51, False}, {52, False}, {53, True}, {54, True}, 
 {55, False}, {56, False}, {57, False}, {58, True}, {59, True}, 
 {60, False}, {61, True}, {62, True}, {63, False}, {64, False}, 
 {65, False}, {66, False}, {67, True}, {68, False}, {69, False}, 
 {70, False}, {71, True}, {72, False}, {73, True}, {74, True}, 
 {75, False}, {76, False}, {77, False}, {78, False}, {79, True}, 
 {80, False}, {81, True}, {82, True}, {83, True}, {84, False}, 
 {85, False}, {86, True}, {87, False}, {88, False}, {89, True}, 
 {90, False}, {91, False}, {92, False}, {93, False}, {94, True}, 
 {95, False}, {96, False}, {97, True}, {98, True}, {99, False}, 
 {100, False}}, TableSpacing -> {0, 3}]
;[o]
51    False
52    False
53    True
54    True
55    False
56    False
57    False
58    True
59    True
60    False
61    True
62    True
63    False
64    False
65    False
66    False
67    True
68    False
69    False
70    False
71    True
72    False
73    True
74    True
75    False
76    False
77    False
78    False
79    True
80    False
81    True
82    True
83    True
84    False
85    False
86    True
87    False
88    False
89    True
90    False
91    False
92    False
93    False
94    True
95    False
96    False
97    True
98    True
99    False
100   False
:[font = special3; inactive; preserveAspect]
Q11. For what values of n is U(n) cyclic? (Think about the answer---you do not need to list them.) Can you see any patterns? What conclusions can you make?
;[s]
2:0,1;3,0;156,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.4 Cyclicity of Z[m] + Z[n]
:[font = text; inactive; preserveAspect]
We are quite familiar with the Z[n] groups. Suppose we consider pairing up two (possibly the same) Z[n] groups and make a new group from the pairs. For example, consider Z[2] and Z[3] and form all pairs (x, y) where the x comes from Z[2] and the y comes from Z[3]: G = {(x, y) | x in Z[2] and y in Z[3]}. What are the elements in G? This is called the direct sum (also called direct product) of Z[2] and Z[3], denoted here simply by Z[2] + Z[3].
:[font = input; preserveAspect]
Elements[DirectSum[Z[2], Z[3]]]
:[font = text; inactive; preserveAspect]
Note that all the first elements in the pairs are either 0 or 1 and the second elements are 0, 1, or 2, exactly as specified. So what operation do we use? There is a "natural" one to consider. Suppose (x, y) and (a, b) are generic elements. Then we say (x, y) + (a, b) = ((x + a) mod 2, (y + b) mod 3). In other words, we treat each dimension (component or coordinate) as we did before joining them, using the operation of the contributing group for that part.
:[font = special3; inactive; preserveAspect]
Q12. Do some calculations in the above setting: 
(0, 1) + (1, 0) = ?
(1, 1) + (1, 1) = ?
(1, 0) + (1, 2) = ?
(0, 1) + (0, 2) = ?
;[s]
2:0,1;3,0;129,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider the Cayley table of the above group:
:[font = input; preserveAspect]
CayleyTable[DirectSum[Z[2], Z[3]], Mode -> Visual];
:[font = text; inactive; preserveAspect]
Since the elements do not fit very well in the limited space in the table, you need to use the Key to guide you.
:[font = special3; inactive; preserveAspect]
Q13. Check your answers to the previous question. Were they right? Is this group Abelian? Why? What is the identity? Is the group cyclic? How do you know?
;[s]
2:0,1;3,0;155,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
So, when is Z[m] + Z[n] cyclic? The following produces a table for various m and n (and is already evaluated -- simply open it up).
:[font = input; Cclosed; preserveAspect; watchDingbatToken; startGroup]
Flatten[Table[G = DirectSum[Z[m], Z[n]]; {m, n, CyclicQ[G]}, 
	{m, 2, 7}, {n, 2, 7}], 1]//TableForm[#, TableHeadings -> 
	{None, {"m", "n", "cyclic?\n"}}, TableSpacing -> 
	{If[$VersionNumber > 2.5, 0.5, 0], 2}]&
	(* ALREADY EVALUATED - SIMPLY OPEN UP *)
:[font = output; output; inactive; locked; preserveAspect; fontLeading = 0; endGroup]
TableForm[{{2, 2, False}, {2, 3, True}, {2, 4, False}, {2, 5, True}, 
 {2, 6, False}, {2, 7, True}, {3, 2, True}, {3, 3, False}, {3, 4, True}, 
 {3, 5, True}, {3, 6, False}, {3, 7, True}, {4, 2, False}, {4, 3, True}, 
 {4, 4, False}, {4, 5, True}, {4, 6, False}, {4, 7, True}, {5, 2, True}, 
 {5, 3, True}, {5, 4, True}, {5, 5, False}, {5, 6, True}, {5, 7, True}, 
 {6, 2, False}, {6, 3, False}, {6, 4, False}, {6, 5, True}, 
 {6, 6, False}, {6, 7, True}, {7, 2, True}, {7, 3, True}, {7, 4, True}, 
 {7, 5, True}, {7, 6, True}, {7, 7, False}}, 
 TableHeadings -> {None, {"m", "n", "cyclic?\n"}}, 
 TableSpacing -> {0, 2}]
;[o]
   m  n  cyclic?

   2  2  False
   2  3  True
   2  4  False
   2  5  True
   2  6  False
   2  7  True
   3  2  True
   3  3  False
   3  4  True
   3  5  True
   3  6  False
   3  7  True
   4  2  False
   4  3  True
   4  4  False
   4  5  True
   4  6  False
   4  7  True
   5  2  True
   5  3  True
   5  4  True
   5  5  False
   5  6  True
   5  7  True
   6  2  False
   6  3  False
   6  4  False
   6  5  True
   6  6  False
   6  7  True
   7  2  True
   7  3  True
   7  4  True
   7  5  True
   7  6  True
   7  7  False
:[font = special3; inactive; preserveAspect]
Q14. Give a conjecture about the necessary conditions for Z[m] + Z[n] to be cyclic. How might a proof go?
;[s]
4:0,1;3,0;33,2;42,0;106,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.5 Structure of intersections of subgroups of Z
:[font = text; inactive; preserveAspect]
For any integer m, the subgroup <m> is a cyclic subgroup of the integers Z. Given two such subgroups, <m> and <n>, we know that the intersection of these two subgroups is another subgroup (as is the intersection of any two subgroups from the same group). Furthermore, we know that it is another subgroup of the form <p>.
:[font = special3; inactive; preserveAspect]
Q15. Why must this intersection look like <p> for some integer p?
;[s]
2:0,1;3,0;66,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's look at some examples. Since these subgroups are all infinite, all we can do is look at a finite swath, but this should be sufficient to build our intuition.

Consider H = <4> and K = <10>:
:[font = input; preserveAspect]
leftAndRight = 15;
H = Table[4 i, {i, -leftAndRight, leftAndRight}]
K = Table[10 i, {i, -leftAndRight, leftAndRight}]
Intersection[H, K]
:[font = special3; inactive; preserveAspect]
Q16. What does the intersection appear to be? What connection, if any, is there between your answer and the fact that H = <4> and K = <10>?
;[s]
2:0,1;3,0;140,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider H = <4> and K = <11>:
:[font = input; preserveAspect]
leftAndRight = 22;
H = Table[4 i, {i, -leftAndRight, leftAndRight}]
:[font = input; preserveAspect]
K = Table[11 i, {i, -leftAndRight, leftAndRight}]
:[font = input; preserveAspect]
Intersection[H, K]
:[font = special3; inactive; preserveAspect]
Q17. What does the intersection appear to be? What connection, if any, is there between your answer and the fact that H = <4> and K = <11>?
;[s]
2:0,1;3,0;140,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider H = <4> and K = <12>:
:[font = input; preserveAspect]
leftAndRight = 15;
H = Table[4 i, {i, -leftAndRight, leftAndRight}]
K = Table[12 i, {i, -leftAndRight, leftAndRight}]
Intersection[H, K]
:[font = special3; inactive; preserveAspect]
Q18. What does the intersection appear to be? What connection, if any, is there between your answer and the fact that H = <4> and K = <12>?
;[s]
2:0,1;3,0;140,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q19. Can you give a conjecture? Test it with a few more examples. Try to prove it.
;[s]
2:0,1;3,0;83,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.6 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?Mod
:[font = input; preserveAspect]
?SubgroupGenerated
:[font = input; preserveAspect]
?CyclicQ
:[font = input; preserveAspect]
?OrderOfAllElements
:[font = input; preserveAspect]
?Dihedral
:[font = input; preserveAspect]
?U
:[font = input; preserveAspect]
?DirectSum
:[font = input; preserveAspect; endGroup; endGroup]
?DirectProduct
^*)
