(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 7. Permutations
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should have a good understanding of functions, including "right to left" composition. It is not necessary to have completed any previous labs to attempt this one.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
We will look at the notion of a permutation and how a group can be formed with permutations. Additionally, we will look at properties of permutations and consider different ways of rewriting a permutation to gain insights regarding products and orders.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.3 What is a permutation?
:[font = text; inactive; preserveAspect]
We need to read in the following Mathematica code to work through this lab:
;[s]
3:0,0;33,1;44,0;76,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect]
What is a permutation? Suppose we had 5 colored squares labeled 1 through 5:
:[font = input; preserveAspect]
RandomColoredSquares[5];
:[font = text; inactive; preserveAspect]
Suppose further that we decide we wish to change the order in which these squares appear. Let's say we want square 1 to go to the second location, square 2 to the third location, square 3 to the first, square 4 to the fifth and square 5 to the fourth:
:[font = input; preserveAspect]
PermuteColoredSquares[{1 -> 2, 2 -> 3, 3 -> 1, 4 -> 5,
	5 -> 4}];
:[font = text; inactive; preserveAspect]
Note how the first square went to the second location (1 -> 2), the second square went to the third position (2 -> 3), the third square went to the first position (3 -> 1) and so on. Here we say that the second row of squares is a permutation of the squares in the first row. 

Technically, a permutation of a set X is a function g from X to X that is both one-to-one and onto. In the case above, we could define g : X -> X by g(1) = 2, g(2) = 3, g(3) = 1, g(4) = 5, and g(5) = 4, where X = {1, 2, 3, 4}. This is often represented by a matrix as follows:
;[s]
11:0,0;57,2;59,0;112,2;114,0;166,2;168,0;231,1;242,0;419,2;421,0;555,-1;
3:6,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
PermutationMatrix[{1 -> 2, 2 -> 3, 3 -> 1, 4 -> 5, 5 -> 4}]
:[font = text; inactive; preserveAspect]
Note that the domain occurs in the first row and the corresponding range elements in the second row. (Note also that the range, or second row in the matrix, is NOT the same as the numbers in the second row of labeled squares shown above. There is a connection, however; can you see it?)
:[font = text; inactive; preserveAspect; endGroup]
Since permutations are functions, we can combine two permutations by using function composition; this will be shown below. Using this binary operation, the set of all permutations of a set X is called the permutation group of the set X. If X is the set of integers {1, 2,  n}, then we call this group the symmetric group of degree n (denoted Sn). If the set X is some other collection of n elements, we can simply (re-)label the elements 1 through n and still consider the group of permutations as the symmetry group Sn.
;[s]
11:0,0;205,1;236,0;306,1;334,0;344,2;345,0;346,1;348,0;519,2;520,0;522,-1;
3:6,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;2,24,16,Times,64,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.4 Computations with permutations
:[font = text; inactive; preserveAspect]
Suppose we have two permutations as shown:
:[font = input; preserveAspect]
p = {1 -> 2, 2 -> 4, 3 -> 3, 4 -> 5, 5 -> 1}
q = {1 -> 5, 2 -> 4, 3 -> 1, 4 -> 2, 5 -> 3}
:[font = text; inactive; preserveAspect]
We can view each permutation as a matrix.
:[font = input; preserveAspect]
PermutationMatrix[p]
PermutationMatrix[q]
:[font = text; inactive; preserveAspect]
To perform the product of p followed by q (note the order here and below), it may help to think of these as side-by-side matrices:
:[font = input; preserveAspect]
SideBySideMatrices[q, p]
:[font = text; inactive; preserveAspect]
Observe that q is on the left and p is on the right. We start by first considering the right-hand side. Observe that p maps 1 to 2. Since q follows p, we note that q takes 2 to 4. Therefore, the composition of p followed by q takes 1 to 2 to 4, or simply 1 to 4. Let's try another. Note that p takes 5 to the element 1 and that q takes the element 1 to the element 5. Therefore the composition of p followed by q takes 5 to 1 to 5 (and thus 5 is said to be fixed under this composition).

The complete product is shown below.
;[s]
3:0,0;457,1;462,0;526,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
MultiplyPermutations[q, p]//PermutationMatrix
:[font = special3; inactive; preserveAspect]
Q1. Suppose we have two permutations s and t given by s = { 1 -> 2, 2 -> 3, 3 -> 1, 4 -> 4} and t = {1 -> 2, 2 -> 3, 3 -> 4, 4 -> 1}. Determine the two compositions: (i) s followed by t and (ii) t followed by s (indicating which is which). First do your work on paper and then verify it using the Mathematica functions. What property does S4 not have, as illustrated here?
;[s]
24:0,1;2,0;62,4;64,0;70,4;72,0;78,4;80,0;86,4;88,0;103,4;105,0;111,4;113,0;119,4;121,0;127,4;129,0;297,3;308,0;340,2;341,0;342,3;345,0;373,-1;
5:12,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;2,16,12,Times,2,14,0,0,0;8,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
When we viewed the permutation p in matrix form, it looked like
:[font = input; preserveAspect]
PermutationMatrix[p]
:[font = text; inactive; preserveAspect]
You may have noticed that this form always has the top row being the first consecutive n integers and the bottom row captures the images of the top row under the function defined by the permutation. Therefore, it is really the bottom row that holds the important information. Consequently, we will frequently refer to a permutation by simply using the bottom row, as illustrated below:
:[font = input; preserveAspect]
MultiplyPermutations[{2, 3, 1, 4}, {4, 2, 3, 1}, 
	Mode -> Textual]
:[font = special3; inactive; preserveAspect]
Q2. Determine the product of {2, 3, 4, 1} followed by {1, 3, 2, 4}.
;[s]
2:0,1;2,0;68,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider the following permutation and its illustration using colored squares.
:[font = input; preserveAspect]
p = {3, 1, 2, 5, 4, 6}
ShowColoredPermutation[p];
:[font = text; inactive; preserveAspect]
Study the permutation (and/or its colored representation). Note that elements in the set {1, 2, 3} permute among themselves, as do the elements in the sets {4, 5} and {6}. In particular, note that p(1) = 3, p(p(1)) = p(3) = 2, and p(p(p(1))) = p(p(3)) = p(2) = 1. Therefore, these elements cycle through as 1 -> 3 -> 2 -> 1. We say that the (ordered) subset {1, 3, 2} is a cycle of the permutation p. Furthermore, {4, 5} and {6} are also cycles. The standard way to denote these cycles is by the notation (1, 3, 2), (4, 5), and (6) respectively. (Often the commas are dropped, if only single digits are used.) Since Mathematica only allows parentheses to be used as grouping symbols (and not delimeters), we use Cycle[1, 3, 2] to denote the cycle (1, 3, 2); the leading word Cycle should make it clear that a cycle is under discussion, and not a permutation. Frequently it is convenient to rewrite permutations into disjoint cycles. (The three cycles (1, 3, 2), (4, 5) and (6) are said to be disjoint since the intersection of any pair is empty.) The following command will do this:
;[s]
11:0,0;373,1;378,0;616,1;627,0;712,2;726,0;775,2;780,0;992,1;1000,0;1083,-1;
3:6,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ToCycles[p]
:[font = text; inactive; preserveAspect]
The following takes us back:
:[font = input; preserveAspect]
FromCycles[%]
:[font = text; inactive; preserveAspect]
The cycle (3, 2, 5, 4, 1) is different from the permutation {3, 2, 5, 4, 1}. Study the following until you see how these differ.
:[font = input; preserveAspect]
PermutationMatrix[{3, 2, 5, 4, 1}]
(* viewing the permutation *)
:[font = input; preserveAspect]
PermutationMatrix[FromCycles[{Cycle[3, 2, 5, 4, 1]}]]
(* viewing the cycle, the output is the cycle
converted to a permutation. Note how 3 -> 2 -> 5 ->
4 -> 1 -> 3. *)
:[font = text; inactive; preserveAspect]
You should read in your text for further details about working with cycles; in particular, determine how to multiply permutations represented in cycle notation.
:[font = special3; inactive; preserveAspect]
Q3. Suppose the permutation p is given as a product of disjoint cycles as 
p = (1, 2, 5) (3, 6) (4) and q is given by q = (2, 5, 6) (3, 1, 4). Determine the product of p followed by q.
;[s]
2:0,1;2,0;185,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.5 Applications of permutations
:[font = text; inactive; preserveAspect]
You may recall working with permutations in labs 1 and 2. There, we had figures such as what is given below:
:[font = input; preserveAspect]
ShowFigure[4, {1, 2, 3, 4}, "D"];
:[font = text; inactive; preserveAspect]
In those labs, you were supposed to find all the symmetries of a figure and determine the group of symmetries. You may realize now that this figure's group of symmetries consists of four rotations and four reflections, the dihedral group D4. Using Rot to represent the lowest order rotation, 90 degrees in this case, and Ref for any reflection, the group is given by
;[s]
7:0,0;239,1;240,0;248,2;251,0;321,2;324,0;367,-1;
3:4,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Dihedral[4]
:[font = text; inactive; preserveAspect]
This representation of D4 is useful in some contexts. However, viewing it in terms of the permutations of the four vertices to accomplish these symmetries might be more useful at the moment, as well as reminding us of what we did in earlier labs:
;[s]
3:0,0;24,1;25,0;247,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
G = Dihedral[4, Form -> Permutations]
:[font = text; inactive; preserveAspect]
Let's look at just the elements:
:[font = input; preserveAspect]
els = Elements[G]
:[font = special3; inactive; preserveAspect]
Q4. As already indicated, we know that D4 consists of 4 rotations and 4 reflections. Match up the elements when using Rot and Ref form with the elements corresponding to permutations.
;[s]
8:0,1;2,0;40,2;41,0;118,3;121,0;126,3;129,0;184,-1;
4:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now let's randomly choose one of these permutations and show the result of applying it to our figure:
:[font = input; preserveAspect]
ShowPermutation[els[[Random[Integer, {1, 8}]]]]
:[font = text; inactive; preserveAspect]
Consider the permutation
:[font = input; preserveAspect]
p = {1, 2, 4, 3}
:[font = text; inactive; preserveAspect]
and its effect on our square:
:[font = input; preserveAspect]
ShowPermutation[p]
:[font = text; inactive; preserveAspect]
What symmetry is this? Note that vertices 1 and 2 both stayed fixed. A rotation only fixes one point (which one?), so this can not be a rotation. A reflection moves all points except those on the line of reflection. But using a line of reflection through vertices 1 and 2 would not land this square back onto itself again. Furthermore, it would not transpose vertices 3 and 4. Therefore, this is not a symmetry of the square. 

So what is it? It is just a permutation of the vertices that can not be obtained by a symmetry. 

Recall that we use S4 to denote the group of all permutations of four objects. This group is given below.
;[s]
3:0,0;546,1;547,0;632,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
Symmetric[4]
:[font = text; inactive; preserveAspect]
How many elements are there in S4? The order of a group is precisely that number.
;[s]
5:0,0;32,2;33,0;39,1;44,0;82,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
Order[Symmetric[4]]
:[font = special3; inactive; preserveAspect]
Q5. For any given n, what is the order of Sn? Why?
;[s]
4:0,1;2,0;43,2;44,0;51,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.6 Questions about permutations
:[font = text; inactive; preserveAspect]
Consider the following permutation:
:[font = input; preserveAspect]
p1 = {3, 1, 2, 5, 4, 6}
:[font = text; inactive; preserveAspect]
We might want to know how to write this as a product of disjoint cycles. This is something you want to learn how to do without the computer, but for now, let's use Mathematica.
;[s]
5:0,0;119,1;126,0;164,1;175,0;177,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
ToCycles[p1]
:[font = text; inactive; preserveAspect]
Since there are three cycles, let's call them a, b, and c:
:[font = input; preserveAspect]
{a, b, c} = ToCycles[p1]
:[font = text; inactive; preserveAspect]
Recall that cycle notation is not to be read in the same way as a permutation. We can determine the permutation for any one of these as follows:
:[font = input; preserveAspect]
ToPermutation[a, 6]
ToPermutation[b, 6]
ToPermutation[c, 6]
:[font = text; inactive; preserveAspect]
The second parameter 6 is used to indicate that we want to think of these cycles as permutations living inside S6 (i.e., permutations of length 6). Without this we get slightly different results:
;[s]
3:0,0;112,1;113,0;196,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
ToPermutation[a]
ToPermutation[b]
:[font = text; inactive; preserveAspect]
As usual, when a new function is encountered, it is good to learn more about it:
:[font = input; preserveAspect]
?ToPermutation
:[font = text; inactive; preserveAspect]
Since the cycles a, b, and c are really permutations in S6, it makes sense to multiply these:
;[s]
3:0,0;57,1;58,0;94,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
MultiplyCycles[a, b]
MultiplyCycles[b, a]
:[font = text; inactive; preserveAspect]
Here's a shortcut for multiplying cycles:
:[font = input; preserveAspect]
a @ b
b @ a
:[font = text; inactive; preserveAspect]
What happens if we multiply two cycles from another permutation. Evaluate the following lines of code until you get a cycle representation consisting of at least two cycles, each of which has length at least 2.
:[font = input; preserveAspect]
p2 = RandomPermutation[9]
ToCycles[p2]
:[font = special3; inactive; preserveAspect]
Q6. Multiply the two cycles by hand. Confirm your work with Mathematica.
;[s]
4:0,1;2,0;60,2;71,0;73,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider the following permutation in S8:
;[s]
3:0,0;39,1;40,0;42,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
q = {1, 2, 3, 4, 5, 7, 6, 8}
:[font = text; inactive; preserveAspect]
Let's view this in matrix form.
:[font = input; preserveAspect]
PermutationMatrix[q]
:[font = text; inactive; preserveAspect]
It is clear that the only "action" in the permutation is that 6 goes to 7 and 7 goes to 6; everything else goes to itself. What happens when we view this using cycles?
:[font = input; preserveAspect]
ToCycles[q]
:[font = special3; inactive; preserveAspect]
Q7. Give a reasonable explanation why the cycles (1), (2), (3), (4) and (5) are omitted in this cycle list. Additionally, explain why (8) is included.
;[s]
2:0,1;2,0;151,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
When do two cycles commute? Try the following.
:[font = input; preserveAspect]
Cycle[2, 3, 4] @ Cycle[5, 6]
Cycle[5, 6] @ Cycle[2, 3, 4]
:[font = input; preserveAspect]
Cycle[2, 3, 4] @ Cycle[3, 6]
Cycle[3, 6] @ Cycle[2, 3, 4]
:[font = text; inactive; preserveAspect]
The following picks a random permutation from S6, converts it to cycles and then grabs the first cycle and calls it a. This is repeated to obtain b. These are then multiplied, in both orders (a * b and b * a).
;[s]
3:0,0;47,1;48,0;210,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
a = First[ToCycles[RandomPermutation[6]]]
b = First[ToCycles[RandomPermutation[6]]]
MultiplyCycles[a, b]
MultiplyCycles[b, a]
:[font = special3; inactive; preserveAspect]
Q8. Keep evaluating the above code until you can make a conjecture regarding when two cycles will commute. (Evaluate it 5 times at a minimum.)
;[s]
2:0,1;2,0;143,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's pick a cycle from some permutation in S6.
;[s]
3:0,0;45,1;46,0;48,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
a = First[ToCycles[RandomPermutation[6]]]
:[font = text; inactive; preserveAspect]
What is the order of this element? (Recall that the order of an element g in a finite group G is the least positive integer n such that g^n is the identity of the group. In S6, the identity is {1, 2, 3, 4, 5, 6}.)
;[s]
3:0,0;174,1;175,0;214,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
OrderOfElement[S[6], ToPermutation[a, 6]]
:[font = text; inactive; preserveAspect]
Let's try this again:
:[font = input; preserveAspect]
a = First[ToCycles[RandomPermutation[6]]]
OrderOfElement[S[6], ToPermutation[a, 6]]
:[font = special3; inactive; preserveAspect]
Q9. Keep evaluating the above code until you can make a conjecture regarding the order of a cycle. How might a proof go?
;[s]
2:0,1;2,0;121,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now that we know how to find the order of any cycle, and we know that all permutations can be written as a product of disjoint cycles, let's see if we can determine the order of an arbitrary permutation.
:[font = input; preserveAspect]
p = RandomPermutation[7]
ToCycles[p]
OrderOfElement[S[7], p]
(* read the following question next *)
:[font = special3; inactive; preserveAspect]
Q10. Why do you think this first warning message is given?
;[s]
2:0,1;3,0;59,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
We will try again, following the instructions.
:[font = input; preserveAspect]
p = RandomPermutation[7]
ToCycles[p]
OrderOfElement[S[7, IndexLimit -> 7], p]
:[font = special3; inactive; preserveAspect]
Q11. Keep evaluating the above code until you can make a conjecture regarding the order of a permutation. Make sure you get some permutations with two or more cycles before forming a conjecture.
;[s]
2:0,1;3,0;195,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now we want to think about permutations in terms of 2-cycles (not to be confused with bicycles---here we mean cycles of length two), which are also called transpositions. 
;[s]
3:0,0;155,1;169,0;172,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
Before continuing on that thread, an observation needs to be made, if not already observed. Note that when a permutation is given in cycle notation, sometimes singleton cycles (cycles of length 1) show up, as below:
:[font = input; preserveAspect]
ToCycles[{2, 1, 3}]
:[font = text; inactive; preserveAspect]
In this case, the permutation can really be thought of just as the transposition (1, 2) since the 1-cycle (3) really acts like the identity permutation---the three goes to itself and everything is fixed! Keep this in mind as we continue below.
:[font = text; inactive; preserveAspect]
First we will pick a random permutation, convert it to cycles and pick one of these cycles at random. The code in the next cell might look a little confusing, but it is set up to give a cycle with length at least 3.
:[font = input; preserveAspect]
long = False;
While[Not[long],
		a = First[Randomize[ToCycles[p = RandomPermutation[7]]]];
		long = Length[a] >= 3]
a
:[font = text; inactive; preserveAspect]
Now we convert this cycle to a product of transpositions. It is important to note that these transpositions are not disjoint.
;[s]
3:0,0;112,1;115,0;126,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
transp = ToTranspositions[a]
:[font = text; inactive; preserveAspect]
If we multiply these cycles together,
:[font = input; preserveAspect]
MultiplyCycles[transp]
:[font = text; inactive; preserveAspect]
we get a permutation as the output, and so we can convert it back to cycle notation:
:[font = input; preserveAspect]
ToCycles[%]
:[font = text; inactive; preserveAspect]
Now this should be where we started out. Therefore, converting to transpositions is a safe operation and one that can be undone by multiplying them out. What can be obtained by writing a cycle as a product of transpositions?
:[font = text; inactive; preserveAspect]
Let's pick two random cycles from two random permutations, convert them to a product of transpositions and look at the number of transpositions obtained from each cycle:
:[font = input; preserveAspect]
a = First[Randomize[ToCycles[RandomPermutation[7]]]]
b = First[Randomize[ToCycles[RandomPermutation[7]]]]
:[font = input; preserveAspect]
transpa = ToTranspositions[a]
transpb = ToTranspositions[b]
:[font = input; preserveAspect]
Length[transpa]
Length[transpb]
:[font = text; inactive; preserveAspect]
Next, we form the product of the two cycles we found above and convert it back to cycle notation. Now we want to convert this list of cycles into transpositions, so we apply the function ToTranspositions to each cycle in the list (this is what the second line does). Since this has extra levels of {}'s, we "flatten" out the unnecessary levels and then count how many are in the list.
;[s]
3:0,0;187,1;203,0;385,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ToCycles[MultiplyCycles[a, b]]
Map[ToTranspositions, %]
:[font = input; preserveAspect]
Flatten[%, 1]
Length[%]
:[font = text; inactive; preserveAspect]
Compare this length with the two lengths above it. We will look at this process again, this time suppressing all output except the counts:
:[font = input; preserveAspect]
a = First[Randomize[ToCycles[RandomPermutation[7]]]];
b = First[Randomize[ToCycles[RandomPermutation[7]]]];
transpa = ToTranspositions[a];
transpb = ToTranspositions[b];
Length[transpa]
Length[transpb]
:[font = input; preserveAspect]
ToCycles[MultiplyCycles[a, b]];
Map[ToTranspositions, %];
Flatten[%, 1];
Length[%]
:[font = text; inactive; preserveAspect]
The first value is the number of transpositions in the first cycle, the second value is the number of transpositions in the second cycle, and the third value is the number of transpositions in the product of the two cycles.
:[font = special3; inactive; preserveAspect]
Q12. Keep evaluating the above code until you can make a conjecture regarding a relationship between the number of transpositions in the product (the last number) and the number of transpositions in the two factors. Hint: do not try to be too specific.
;[s]
2:0,1;3,0;253,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
There is another function that we can apply to permutations, the Parity function. Let's see how this works.
;[s]
3:0,0;65,1;71,0;108,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
p = RandomPermutation[7]
ToTranspositions[p]
:[font = input; preserveAspect]
Length[%]
Parity[p]
:[font = special3; inactive; preserveAspect]
Q13. Keep evaluating the above code until you can make a conjecture regarding a relationship between the number of transpositions in a permutation and its parity.
;[s]
2:0,1;3,0;163,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now let's resume our pursuit that preceded question 12. Here we pick random cycles a and b, form the product and call it p. We convert each of these to transpositions and count these; the first triple is the number of transpositions of each in the list {a, b, p}. Then we also calculate the parity of each and this is reflected in the second triple.
:[font = input; preserveAspect]
a = First[Randomize[ToCycles[RandomPermutation[7]]]];
b = First[Randomize[ToCycles[RandomPermutation[7]]]];
transpa = ToTranspositions[a];
transpb = ToTranspositions[b];
p = MultiplyCycles[a, b];
ToTranspositions[p];
{Length[transpa], Length[transpb], Length[%]}
{Parity[ToPermutation[a, 7]], 
	Parity[ToPermutation[b, 7]], Parity[p]}
:[font = text; inactive; preserveAspect]
The output is {# transp. in a, # transp. in b, # transp. in a*b} followed by {parity of a, parity of b, parity of a*b}.
:[font = special3; inactive; preserveAspect]
Q14. Keep evaluating the above code until you can make a conjecture regarding a relationship between the parity of a product and the parity of its factors. Now go back to questions 12 and 13 and see if you have any changes to make; if so, state them here.
;[s]
2:0,1;3,0;256,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
A permutation with parity 1 is called an even permutation and if the parity is -1, we call it an odd permutation. We have two functions to test evenness and oddness of permutations:
;[s]
5:0,0;41,1;57,0;97,1;114,0;182,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
p = RandomPermutation[6]
:[font = input; preserveAspect]
OddPermutationQ[p]
EvenPermutationQ[p]
:[font = special3; inactive; preserveAspect]
Q15. Using your knowledge about sums of odd and even integers and how products result from various combinations of -1 and 1, do you see any connection between parity and the number of transpositions? State them.
;[s]
2:0,1;3,0;212,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; leftNameWrapOffset = 5; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.7 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?PermutationMatrix
:[font = input; preserveAspect]
?MultiplyPermutations
:[font = input; preserveAspect]
?ToCycles
:[font = input; preserveAspect]
?FromCycles
:[font = input; preserveAspect]
?ToPermutation
:[font = input; preserveAspect]
?MultiplyCycles
:[font = input; preserveAspect]
?RandomPermutation
:[font = input; preserveAspect]
?OrderOfElement
:[font = input; preserveAspect]
?S
:[font = input; preserveAspect]
?Length
:[font = input; preserveAspect]
?ToTranspositions
:[font = input; preserveAspect]
?Parity
:[font = input; preserveAspect]
?ToTranspositions
:[font = input; preserveAspect]
?OddPermutationQ
:[font = input; preserveAspect; endGroup; endGroup]
?EvenPermutationQ
^*)
