(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 9. Automorphisms
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should have completed Group Lab 8.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab continues the exploration of isomorphisms begun in the previous lab. In this lab, we look at a collection of isomorphisms from a group to itself and ask what kind of structure, if any, might be present.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.3 Automorphisms on Zn
;[s]
2:0,0;22,1;24,-1;
2:1,19,14,Times,1,18,0,0,0;1,31,20,Times,65,18,0,0,0;
:[font = text; inactive; preserveAspect]
Before beginning, we read in the necessary code for this lab:
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect]
In the previous lab we considered questions such as "Is U[12] isomorphic to U[10]?" (or other groups besides U[10]). Consider the group Z[12]. We never asked "Is Z[12] isomorphic to Z[12]?" (i.e., itself). Why not ask this? Is the answer obvious? On the one hand, since isomorphisms indicate that two groups are the "same" in some sense, if two groups are identical (as in this case), we should certainly expect them to be isomorphic. 
:[font = text; inactive; preserveAspect]
Indeed, Z[12] is isomorphic to itself. What isomorphism (map) will show this? Try the identity function that takes every element to itself. All the properties hold. Since we are mapping from Z[12] to itself, we call this kind of isomorphism an automorphism. We illustrate the use of the identity function below.
;[s]
4:0,0;244,2;248,1;258,0;312,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,16,12,Times,3,14,0,0,0;
:[font = input; preserveAspect]
f1 = FormMorphoid[#&, Z[12], Z[12]]
IsomorphismQ[f1]
:[font = text; inactive; preserveAspect]
We can see the details of this Morphoid by looking at the Rules used in its definition.
;[s]
3:0,0;31,1;39,0;88,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ToRules[f1]
:[font = text; inactive; preserveAspect]
A more important question to ask at this time is whether there are any other automorphisms besides the identity map. We know that we must map 0 to 0. (Why?) What about the element 5? Since it is a generator and has order 12, to what must it be mapped? Clearly it needs to go to another generator, if we wish to preserve orders. So it could be mapped to 1, 5, 7, or 11. 

Let x be any other element of Z[12]. Since 5 is a generator, x = n5 = 5 + 5 +  + 5 (n summands) for some integer n. To what should we map x? Suppose our function is f. Then,
:[font = text; inactive; preserveAspect; center]
f(x) = f(5 + 5 + ... + 5) = f(5) + f(5) + ... + f(5)
:[font = text; inactive; preserveAspect]
with n summands in both instances. This should indicate that once we know to where 5 is mapped, we know where every element is mapped.
:[font = special3; inactive; preserveAspect]
Q1. Explain this last statement (in such a way that would convince a classmate who may not have heard this yet).
;[s]
2:0,1;2,0;113,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Since we know we can send the generator 5 to any one of the four generators, let's make a function for each possibility. Below we use a function called Automorphism that allows us  to specify a rule as a generator and will build the complete morphism from that single piece of information. Asking for more information about a function is always a good idea:
;[s]
3:0,0;152,1;164,0;358,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?Automorphism
:[font = text; inactive; preserveAspect]
We can also get further information by specifying the Textual mode of Automorphism.
;[s]
5:0,0;54,1;61,0;70,1;82,0;84,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
f2 = Automorphism[Z[12], 5 -> 1, Mode -> Textual]
:[font = text; inactive; preserveAspect]
Instead of checking to see if f1 and f2 are morphisms, we can check whether they are isomorphisms directly with IsomorphismQ.
;[s]
3:0,0;112,1;124,0;126,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
IsomorphismQ[f1]
IsomorphismQ[f2]
:[font = text; inactive; preserveAspect]
Let's create our last two automorphisms and check them:
:[font = input; preserveAspect]
f3 = Automorphism[Z[12], 5 -> 7]
IsomorphismQ[f3, Cautious -> True]
:[font = input; preserveAspect]
f4 = Automorphism[Z[12], 5 -> 11]
IsomorphismQ[f4, Cautious -> True]
:[font = text; inactive; preserveAspect]
We now have four automorphisms. What can we do with these functions? Is this set of four functions anything special? What would happen if we followed one by another (i.e., compose the functions)? In particular, what do we get if we follow f2 by f3?
:[font = text; inactive; preserveAspect]
First, define Els to be the elements of the group Z[12] under consideration.
;[s]
3:0,0;14,1;17,0;77,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Els = Elements[Z[12]]
:[font = text; inactive; preserveAspect]
We want the output of f2 to be the input for f3, so let's evaluate f2 at the set Els.
;[s]
3:0,0;81,1;84,0;86,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
f2[Els]
:[font = text; inactive; preserveAspect]
This maps f2 over each element in Els. We could also have f2 mapped onto each element by using the Map command:
;[s]
5:0,0;34,1;37,0;99,1;102,0;112,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
f2Output = Map[f2, Els]
:[font = text; inactive; preserveAspect]
Now we use this as input for f3:
:[font = input; preserveAspect]
Map[f3, f2Output]
:[font = text; inactive; preserveAspect]
Now the question is which function, if any, has this same output (in this order) when mapped over Els? Let's try each one:
;[s]
3:0,0;98,1;101,0;123,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[f1, Els]
Map[f2, Els]
Map[f3, Els]
Map[f4, Els]
:[font = text; inactive; preserveAspect]
Great! It matches f4. But what does this mean?
:[font = special3; inactive; preserveAspect]
Q2. What is the relationship, if any, between f2, f3 and f4?
;[s]
2:0,1;2,0;61,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q3. Modify the steps above and determine the result of taking f1 followed by f4. Which function, if any, does this yield?
;[s]
2:0,1;2,0;122,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q4. Where are we going with all of this? What seems to be lurking around the corner (i.e., Mathematica computation)?
;[s]
4:0,1;2,0;91,2;102,0;117,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Suppose we try to automate all of this work above. First, we define our list of automorphisms, but redefine f1 using Automorphism, converting it into a rules-based Morphoid. (This is necessary to form a Groupoid of Morphoids.)
;[s]
9:0,0;117,1;129,0;164,1;172,0;203,1;211,0;215,1;224,0;227,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
f1 = Automorphism[Z[12], 5 -> 5]
automorphisms = {f1, f2, f3, f4}
:[font = text; inactive; preserveAspect]
We can operate on these automorphisms with the function MorphoidComposition:
;[s]
3:0,0;56,1;75,0;77,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?MorphoidComposition
:[font = text; inactive; preserveAspect]
If we want to know f4 followed by f3, we use the following. (Notice that the ordering is from right to left.)
:[font = input; preserveAspect]
MorphoidComposition[f3, f4]
:[font = text; inactive; preserveAspect]
Or f1 followed by f4:
:[font = input; preserveAspect]
MorphoidComposition[f4, f1]
:[font = text; inactive; preserveAspect]
The next question one might ask concerns a Cayley table. First we need to turn this set and operation into a Groupoid. We will call it Automorphisms.
;[s]
5:0,0;109,1;117,0;135,1;148,0;150,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Automorphisms = FormGroupoid[automorphisms, 
	MorphoidComposition[#1, #2]&, WideElements->True, 
	KeyForm -> OutputForm]
:[font = text; inactive; preserveAspect]
Now, for the moment for which we have all been waiting:
:[font = input; preserveAspect]
CayleyTable[Automorphisms, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q5. Does this appear to be a group? Why? Is there an identity? If so, what is it; if not, why not? Since this is of order four, to what familiar group is this isomorphic?
;[s]
2:0,1;2,0;171,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
All the work above is automated in the function AutomorphismGroup:
;[s]
3:0,0;48,1;65,0;67,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?AutomorphismGroup
:[font = text; inactive; preserveAspect]
Let's change our modulus from 12 to 10 and see what kind of group we get.
:[font = input; preserveAspect]
G = AutomorphismGroup[Z[10]]
:[font = text; inactive; preserveAspect]
Now take a look at its Cayley table.
:[font = input; preserveAspect]
CayleyTable[G, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q6. To what familiar group is this isomorphic?
;[s]
2:0,1;2,0;47,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's try one more.
:[font = input; preserveAspect]
G = AutomorphismGroup[Z[14]];
CayleyTable[G, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q7. To what familiar group is this isomorphic?
;[s]
2:0,1;2,0;47,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.4 Inner automorphisms
:[font = text; inactive; preserveAspect]
We have seen how we obtain all the automorphisms on a cyclic group. If the group is not cyclic, the question is a bit harder. There are certain automorphisms, however, that are easy to generate for any group. 

Let G be any group and g by any element in G. Consider the function fg : G -> G defined by fg(h) = ghg^(-1). We call ghg^(-1) the conjugate of h by g and the process of applying fg to an element is called conjugation. 
;[s]
10:0,0;280,1;281,0;303,1;304,0;341,2;360,0;390,1;391,0;416,2;430,-1;
3:5,16,12,Times,0,14,0,0,0;3,24,16,Times,64,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q8. If the group G is Abelian, what happens when we conjugate h by g? What is the map fg in this case?
;[s]
4:0,1;2,0;87,2;88,0;103,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider the group G = Dihedral[4] and let's try conjugating some elements, using the function ElementConjugate.
;[s]
3:0,0;95,1;111,0;113,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Dihedral[4]
(* recall Rot is the element corresponding to the lowest order
rotation, 90 degrees in this case, and Ref is any reflection.*)
:[font = input; preserveAspect]
?ElementConjugate
:[font = input; preserveAspect]
ElementConjugate[Dihedral[4], Rot^3, Rot]
:[font = input; preserveAspect]
ElementConjugate[Dihedral[4], Ref, Rot]
:[font = text; inactive; preserveAspect]
We can speed this up by looking at all the conjugates at once:
:[font = input; preserveAspect]
ConjugatingElement = Rot;
TableForm[Transpose[{Elements[Dihedral[4]],
	Map[ElementConjugate[Dihedral[4], #, ConjugatingElement]&,
	Elements[Dihedral[4]]]}], TableHeadings ->
	{None, {"h", StringJoin["h conjugated by ", 
	ToString[ConjugatingElement], "\n"]}}, TableSpacing ->
		{If[$VersionNumber > 2.5, 0.5, 0], 5}]
:[font = special3; inactive; preserveAspect]
Q9. Which elements didn't get changed when they were conjugated by Rot? Is there anything special about this set?
;[s]
4:0,1;2,0;67,2;70,0;114,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
What if we conjugate by Ref?
;[s]
3:0,0;24,1;27,0;29,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ConjugatingElement = Ref;
TableForm[Transpose[{Elements[Dihedral[4]],
	Map[ElementConjugate[Dihedral[4], #, ConjugatingElement]&,
	Elements[Dihedral[4]]]}], TableHeadings ->
	{None, {"h", StringJoin["h conjugated by ", 
	ToString[ConjugatingElement], "\n"]}}, TableSpacing -> 
	{If[$VersionNumber > 2.5, 0.5, 0], 5}]
:[font = text; inactive; preserveAspect]
For each element g in a group G, there is a conjugation function fg (that takes an element to its conjugation by g). Note that fg is a function from G to G and therefore a candidate for being an automorphism. In fact, each of these functions is an automorphism and is called an inner automorphism of G induced by g. We can use Mathematica to help us construct these:
;[s]
9:0,0;66,1;67,0;128,1;129,0;278,2;315,0;327,2;338,0;367,-1;
3:5,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?InnerAutomorphism
:[font = input; preserveAspect]
Clear[f1]
f1 = InnerAutomorphism[Dihedral[4], Rot^2]
:[font = text; inactive; preserveAspect]
Let's look at some details of this function. One way of seeing the action is to map f1 onto the elements of the group:
:[font = input; preserveAspect]
Map[f1, Elements[Dihedral[4]]]
:[font = text; inactive; preserveAspect]
Is f1 really an automorphism?
:[font = input; preserveAspect]
IsomorphismQ[f1]
:[font = text; inactive; preserveAspect]
Suppose we call f2 the inner automorphism induced by Rot^3:
:[font = input; preserveAspect]
f2 = InnerAutomorphism[Dihedral[4], Rot^3]
Map[f2, Elements[Dihedral[4]]]
:[font = text; inactive; preserveAspect]
Since f1 and f2 are functions, it is legitimate to ask about the composition. Will this be another inner automorphism? If so, which one? Perhaps we should try to find all the inner automorphims by mapping the InnerAutomorphism function onto the elements of the group. 
;[s]
3:0,0;209,1;226,0;269,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
funcs = Map[InnerAutomorphism[Dihedral[4], #]&, 
	Elements[Dihedral[4]]]
:[font = text; inactive; preserveAspect]
 Now let's map each of these onto the elements of the group to see if any of these functions are the same.
:[font = input; preserveAspect]
images = Map[Map[#, Elements[Dihedral[4]]]&, funcs]
:[font = special3; inactive; preserveAspect]
Q10. By looking at this list, would you say that any of these functions are the same? If so, which ones?
;[s]
2:0,1;3,0;105,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Sorting this list, we remove any duplicates:
:[font = input; preserveAspect]
Union[images]
:[font = text; inactive; preserveAspect]
At this stage, you should be able to match these up with the original ones obtained, but we put all of this together in one function:
:[font = input; preserveAspect]
G = InnerAutomorphismGroup[Dihedral[4]]
:[font = text; inactive; preserveAspect]
The elements of this Groupoid are suppressed until we ask for them.
;[s]
3:0,0;21,1;29,0;68,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Elements[G]
:[font = text; inactive; preserveAspect]
Let's look at the details of the second element.
:[font = input; preserveAspect]
MorphoidRules[Elements[G][[2]]]
:[font = text; inactive; preserveAspect]
Here is the Cayley table for this group:
:[font = input; preserveAspect]
CayleyTable[G, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q11. You now know about the different groups of order 4. To what (common) group is this isomorphic?
;[s]
2:0,1;3,0;100,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider the following groups. 
:[font = input; preserveAspect]
K = InnerAutomorphismGroup[Dihedral[5]];
CayleyTable[K, Mode -> Visual];
:[font = input; preserveAspect]
L = InnerAutomorphismGroup[Dihedral[6]];
CayleyTable[L, Mode -> Visual, ShowKey -> False];
:[font = special3; inactive; preserveAspect]
Q12. Can you make a conjecture about the inner automorphism group of Dihedral[n]?
;[s]
2:0,1;3,0;82,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.5 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Automorphism
:[font = input; preserveAspect]
?MorphoidComposition
:[font = input; preserveAspect]
?AutomorphismGroup
:[font = input; preserveAspect]
?ElementConjugate
:[font = input; preserveAspect]
?InnerAutomorphism
:[font = input; preserveAspect; endGroup; endGroup]
?InnerAutomorphismGroup
^*)
