(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 10. Direct products
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
10.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
10.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete the last section of this lab, you should have completed the lab on isomorphisms (Group Lab 8); otherwise, there are no prerequisites.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
10.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab explores the direct product of two groups. First we define the concept of a direct product and how to determine its order. Next we determine the order of an element in a direct product. We also consider when a direct product might be cyclic, given its factors are cyclic. Finally, we consider when U groups are isomorphic to direct products of other U groups.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.3 What is a direct product?
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
In abstract algebra, when an object (such as a group) is being studied, there are several natural questions that are often asked: 1. When does a subset still have the algebraic properties of the parent set? and 2. Can we take two (or more) objects and combine them to build a new one with similar properties? (We will pursue a third natural question in Group Lab 11.)

Since we have already spent some time looking at subgroups, it is time to consider the second question.
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's consider two groups, G1 and G2, as defined below. (First, we read in code from the AbstractAlgebra packages.)
;[s]
3:0,0;89,1;104,0;116,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; initialization; preserveAspect; rightWrapOffset = 521]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect; rightWrapOffset = 521]
G1 = U[10]
G2 = Z[4]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
How can we combine these so that we form a new group where both G1 and G2 can be viewed as "subgroups" in some sense? From linear algebra, we know what it means to view vectors as ordered pairs and then use component-wise addition, so perhaps we can implement a similar strategy.
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
What we want to do is form all ordered pairs of the form (x, y) where x is obtained from G1 and y is obtained from G2. The set of all these ordered pairs can be given a group structure by considering the operation defined by (x, y) (a, b) = (x a, y b), where the operation in the first component on the right-hand side takes place in G1 and in G2 in the second component. We call this group the direct product of G1 and G2. We denote this direct product by G1 x G2.
;[s]
3:0,0;395,1;424,0;466,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
G = DirectProduct[G1, G2]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q1. Here we see there are 16 elements. If |G1| = n and |G2| = m, what is the order of the direct product of G1 and G2? Why?
;[s]
2:0,1;2,0;124,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's look at another direct product. 
:[font = input; preserveAspect; rightWrapOffset = 521]
H = DirectProduct[U[10], Z[2]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
As we have seen in the past, studying the Cayley table of a group can reveal significant information. Study the following.
:[font = input; preserveAspect; rightWrapOffset = 521]
CayleyTable[H, Mode -> Visual];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q2. What observations can you make about the group H? Can you "see" any subgroups? Can you identify the order of any elements? Is this Abelian? What other observations can you make?
;[s]
2:0,1;2,0;182,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.4 Order of an element in a direct product
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
We continue to use the same G as in the previous section. (Evaluate the following only if you have changed your definition of G.)
:[font = input; preserveAspect; rightWrapOffset = 521]
G = DirectProduct[U[10], Z[4]];
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's pick a random element from G.
:[font = input; preserveAspect; rightWrapOffset = 521]
?RandomElement 
(* if you are not sure how RandomElement works, try this *)
:[font = input; preserveAspect; rightWrapOffset = 521]
g = RandomElement[G, SelectFrom -> NonIdentity]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
What is the order of this element?
:[font = input; preserveAspect; rightWrapOffset = 521]
OrderOfElement[G, g]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Now let's determine the order of each component in its respective group. That is, we would like to know the order (in G1) of the first component of g and the order (in G2) of the second component of g. In Mathematica, one uses g[[k]] to obtain the kth component of a list, so here we use g[[1]] and g[[2]] to find the coordinates of g in G1 and G2 respectively.
;[s]
7:0,0;205,1;216,0;288,2;294,0;299,2;305,0;362,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
OrderOfElement[{{G1, g[[1]]}, {G2, g[[2]]}}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Recall, the first number is the order of the first coordinate of g in the group G1 and the second number is the order of the second coordinate of g in the group G2.

Let's look at a table of these and see if we can come to any conclusions:
:[font = input; preserveAspect; rightWrapOffset = 521]
MatrixForm[Table[g = RandomElement[G, SelectFrom -> 
	NonIdentity]; {g, OrderOfElement[G, g], OrderOfElement[{{G1,
	First[g]}, {G2, Last[g]}}]}, {8}], TableHeadings -> {None,
	{"g = {x, y}", "|g|", "{|x|, |y|}\n\n"}}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q3. Evaluate the cell above at least one more time. Make a conjecture about a relationship between the order of the element g = {x, y} in G1 x G2 and the orders |x| and |y|.
;[s]
2:0,1;2,0;174,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Change the groups G1 and G2 to some other groups (use Z, U, Symmetric, Dihedral or any other groups you might know).
;[s]
9:0,0;54,1;55,0;57,1;58,0;60,1;69,0;71,1;79,0;117,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
G1 = (* fill in your group here *)
G2 = (* fill in your group here *)
G = DirectProduct[G1, G2];
Elements[G]
:[font = input; preserveAspect; rightWrapOffset = 521]
MatrixForm[Table[g = RandomElement[G, SelectFrom -> 
	NonIdentity]; {g, OrderOfElement[G, g],OrderOfElement[{{G1,
	First[g]}, {G2, Last[g]}}]}, {5}], TableHeadings -> {None,
	{"g = {x, y}", "|g|", "{|x|, |y|}\n"}}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q4. Test your conjecture from question 3. Does it still hold? What are your groups G1 and G2 in your direct product? Try this again by changing groups (again listing your component groups). State your final conjecture. How might you prove it?
;[s]
2:0,1;2,0;243,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.5 When is a direct product of cyclic groups cyclic?
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Consider the two groups given below, with their direct product:
:[font = input; preserveAspect; rightWrapOffset = 521]
G1 = Z[6]
G2 = Z[4]
G = DirectProduct[G1, G2]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
We know that both G1 and G2 are cyclic; what about G?
:[font = input; preserveAspect; rightWrapOffset = 521]
CyclicQ[{G1, G2, G}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
In this case, we see that G is not cyclic. Let's make a table of some random indices for Z[m] and Z[n] and then consider the cyclicity of the direct product Z[m] x Z[n]. (While you wait for the code to evaluate, think about what might make the direct product cyclic and when it might not be cyclic.)
:[font = input; preserveAspect; rightWrapOffset = 521]
numberToSample = 6;
TableForm[Table[n = Random[Integer, {2, 10}];
	m = Random[Integer, {2, 11}];
	{m, n, CyclicQ[DirectProduct[Z[m], Z[n]]]}, {numberToSample}],
	TableHeadings -> {None, {"m", "n", "Z[m] x Z[n] cyclic?\n"}}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q5. By either repeating the code above, or substituting values in for m and n below, try enough examples until you can make a conjecture about a relationship between n and m that will guarantee that the direct product of Z[m] and Z[n] is cyclic.
;[s]
2:0,1;2,0;246,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer: 
:[font = input; preserveAspect; rightWrapOffset = 521]
n = 7
m = 8
CyclicQ[DirectProduct[Z[m], Z[n]]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q6. Give a reasonable explanation why your conjecture makes sense.
;[s]
2:0,1;2,0;67,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
What are the generators of a cyclic direct product? 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
One of the examples that you may have tested, Z[4] x Z[5], turns out to be cyclic. A natural question to ask concerns the generators of this cyclic group. Before you evaluate the following cell, think about what the list of generators might be.
;[s]
3:0,0;155,1;161,0;245,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
?CyclicGenerators
:[font = input; preserveAspect; rightWrapOffset = 521]
CyclicGenerators[DirectProduct[Z[4], Z[5]]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q7. What is another example of indices m and n for which Z[m] x Z[n] is cyclic? Without using Mathematica, determine the generators for this group. Test yourself below.
;[s]
4:0,1;2,0;94,2;105,0;169,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Fill in values for n and m for which the direct product is cyclic.
:[font = input; preserveAspect; rightWrapOffset = 521]
m = 4
n = 5
CyclicGenerators[DirectProduct[Z[m], Z[n]]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q8. When is Z[m] x Z[n] isomorphic to Z[m n]? 
;[s]
2:0,1;2,0;47,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
10.6 Isomorphisms among U[n] groups
:[font = text; inactive; preserveAspect]
Consider the following, where we form the groups U[m], U[n], U[m * n] and the direct product U[m] x U[n]. 
:[font = input; preserveAspect]
m = 5;
n = 4;
G1 = U[m]
G2 = U[n]
:[font = input; preserveAspect]
G = DirectProduct[G1, G2]
:[font = input; preserveAspect]
U[m * n]
:[font = text; inactive; preserveAspect]
Note that U[mn] and U[m] x U[n] have the same number of elements:
:[font = input; preserveAspect]
Length[Elements[U[m * n]]] == 
	Length[Elements[DirectProduct[G1, G2]]]
:[font = text; inactive; preserveAspect]
Suppose we define a function from U[m * n] to U[m] x U[n]. To do so, we need to make sure that the image of any element lands in U[m] x U[n], which means the first component must be in U[m] and the second in U[n]. The following function is one way to accomplish this.
:[font = input; preserveAspect]
Clear[f]
f[x_] := {Mod[x, m], Mod[x, n]}
:[font = text; inactive; preserveAspect]
What is the image of this function on U[m * n]?
:[font = input; preserveAspect]
Map[f, Elements[U[m * n]]]
:[font = text; inactive; preserveAspect]
How does this compare to the elements of U[m] x U[n]?
:[font = input; preserveAspect]
SameSetQ[%, Elements[DirectProduct[U[m], U[n]]]]
:[font = text; inactive; preserveAspect]
Thus, we see that we have the same set of elements. Could this possibly be an isomorphism? First, let's set up a Morphoid.
;[s]
3:0,0;113,1;121,0;123,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
func = FormMorphoid[f, U[m * n], DirectProduct[U[m], U[n]]]
:[font = text; inactive; preserveAspect]
Since we see that the map is onto (and one-to-one), what we really need to do is check to see if it is a morphism.
:[font = input; preserveAspect]
MorphismQ[func, Mode -> Visual]
:[font = text; inactive; preserveAspect]
Indeed. We have an isomorphism. Is there anything special about the m and n we chose? Let's try some random values and see what happens:
:[font = input; preserveAspect]
numberToSample = 6;
Off[Morphoid::dff];
TableForm[Table[
	m = Random[Integer, {2, 10}];
	n = Random[Integer, {2, 10}];
	G1 = U[m];
	G2 = U[n];
	G = DirectProduct[G1, G2];
	H = U[m * n];
	Clear[f];
	f[x_] := {Mod[x, m], Mod[x, n]};
	{m, n, IsomorphismQ[FormMorphoid[f, U[m * n], 
		DirectProduct[U[m], U[n]]], Cautious -> True]},
{numberToSample}],
TableHeadings -> {None, {"m", "n", "isomorphic?\n"}}]
On[Morphoid::dff];
:[font = special3; inactive; preserveAspect]
Q9. By either repeating the code above, or substituting values in for n and m below, try enough examples until you can make a conjecture about a relationship between n and m that will guarantee that the direct product of U[n] and U[m] is isomorphic to U[mn].
;[s]
2:0,1;2,0;259,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
n = 
m = 
Clear[f];
f[x_] := {Mod[x, m], Mod[x, n]};
IsomorphismQ[FormMorphoid[f, U[m * n], DirectProduct[U[m], U[n]]]]
:[font = special3; inactive; preserveAspect]
Q10. Is U[30] isomorphic to U[2] x U[3] x U[5]? Why or why not? If so, set up the isomorphism; if not, explain why not.
;[s]
2:0,1;3,0;120,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q11. Is Z[30] isomorphic to Z[2] x Z[3] x Z[5]? Why or why not? If so, set up the isomorphism; if not, explain why not.
;[s]
2:0,1;3,0;120,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Is Z[m n] isomorphic to Z[m] x Z[n]? Set up the isomorphism when it is and explain why not when it is not.
;[s]
2:0,1;3,0;112,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
10.7 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?U
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?DirectProduct
:[font = input; preserveAspect]
?CayleyTable
:[font = input; preserveAspect]
?RandomElement
:[font = input; preserveAspect]
?SelectFrom
:[font = input; preserveAspect]
?NonIdentity
:[font = input; preserveAspect]
?OrderOfElement
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?CyclicQ
:[font = input; preserveAspect]
?CyclicGenerators
:[font = input; preserveAspect]
?Length
:[font = input; preserveAspect]
?SameSetQ
:[font = input; preserveAspect]
?FormMorphoid
:[font = input; preserveAspect]
?MorphismQ
:[font = input; preserveAspect; endGroup; endGroup]
?IsomorphismQ
^*)
