(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 11. Cosets
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
This lab is self-contained. No prior labs need to be completed to attempt this one. One should be familiar with the basic groups such as Z[n], U[n] and Dihedral[n].
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab explores the notion of cosets. We will look at how cosets are determined, the different types of cosets and some of the properties of cosets.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.3 Cosets, left and right
:[font = text; inactive; preserveAspect]
Suppose we start with some group G, say the dihedral group of order 8, D4. (First, we read in the necessary Mathematica code.)
;[s]
5:0,0;72,1;73,0;108,2;119,0;127,-1;
3:3,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect]
G = Dihedral[4]
:[font = text; inactive; preserveAspect]
Now consider a subgroup of G, say H = {1, Rot^2}, consisting of the identity and the 180 degree rotation (when we view D4 as the symmetries of the square).
;[s]
3:0,0;120,1;121,0;156,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
H = {1, Rot^2}
:[font = text; inactive; preserveAspect]
We would like to take another element g from G and multiply it by all the elements in H. Suppose we choose one of the reflections, say Ref. Before multiplying, we need to first choose on which side to multiply Ref, since this group is not Abelian. We also need to find a way of calculating this product in Mathematica. 

If one has a function f of two variables (such as f(x, y) = x^2 + y^2), and one wants to hold one variable fixed and let the other roam over some fixed set, one can do this using the Map function as follows:
;[s]
9:0,0;135,2;138,0;210,2;213,0;306,1;317,0;504,2;507,0;529,-1;
3:5,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[f, x, y]
f[x_, y_] := x^2 + y^2
Map[f[2, #]&, {-2, -1, 0, 1, 2}]
:[font = text; inactive; preserveAspect]
The expression f[2, #]& indicates that all the elements in the list {-2, -1, 0, 1, 2} should, one at a time, be placed in for the # and then f can be properly evaluated with the two arguments (the first always being 2, in this example). Think about what the following will return; don't evaluate it until you have made some (educated) guess.
;[s]
7:0,0;15,1;23,0;130,1;131,0;141,1;142,0;342,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[f[#, 1]&, {-2, -1, 0, 1, 2}]
:[font = text; inactive; preserveAspect]
We will use this mapping principle to calculate our product of Ref times the elements in H. First we need the group's operation, which is a function of two variables. The following allows us to use op as a short name for the operation. (The semicolon suppresses the actual definition, since its details are not important.)
;[s]
5:0,0;63,1;66,0;198,1;200,0;323,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
op = Operation[G];
(* the ; suppresses any output, so don't expect any *)
:[font = text; inactive; preserveAspect]
Now we will use op to do the calculations, placing Ref on the left (as the first operand).
;[s]
5:0,0;16,1;18,0;51,1;54,0;91,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[op[Ref, #]&, H]
:[font = text; inactive; preserveAspect]
This result is called the left coset of H in G containing g (where H = {1, Rot^2} and g = Ref). In general, we denote the left coset of H in G containing g by the notation gH. This coset is the set {g * h | h in H}. We define the right coset of H in G containing g in a similar fashion: Hg = {h * g | h in H}. (Note that when a group is written additively, we denote these cosets by g + H and H + g.) We can calculate the right coset in a similar fashion.
;[s]
7:0,0;26,1;41,0;42,1;46,0;47,1;59,0;456,-1;
2:4,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Map[op[#, Ref]&, H]
(* note that Ref is now the second, or right, operand *)
:[font = text; inactive; preserveAspect]
Observe that, in this case, the right coset and the left coset are the same. Suppose we use a new element, g = Rot^2 Ref. 

A technical Mathematica note might be useful here, since in Mathematica we enter Rot^2 Ref as Rot^2 ** Ref. In Mathematica, multiplication is denoted either by juxtaposition, 6 7, or by using the asterisk, 6 * 7.
;[s]
9:0,0;136,1;147,0;184,1;195,0;218,2;230,0;235,1;246,0;337,-1;
3:5,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
6 7
6 * 7
:[font = input; preserveAspect]
Clear[g, h]
g * h
h * g
:[font = text; inactive; preserveAspect]
Note that both g * h and h * g return g h. In other words, by default Mathematica assumes that the multiplication * is commutative and the elements are returned in some canonical order (alphabetically in this case). To force a non-commutative multiplication we use **. 
;[s]
5:0,0;70,1;81,0;227,1;242,0;270,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
g ** h
h ** g
:[font = text; inactive; preserveAspect]
One further note is needed (ONLY for version 2.2). Consider the following.
:[font = input; preserveAspect]
h^2 * g
h^2 ** g
:[font = text; inactive; preserveAspect]
You can ignore the following technical jargon, but you need to heed the moral given at the end. Note that ** has higher precedence than ^, while * has lower precedence than ^. This can be seen above because h^2 ** g becomes h^(2 ** g) since ** acted first and took its two arguments, 2 and g, and then ^ was allowed to act and take its one argument, 2 ** g. On the other hand, with h^2 * g we have the * having lower precedence and so ^ acts first taking the 2 and then * acts taking its two arguments, h^2 and g. A canonical ordering (alphabetical here) takes place and this becomes g h^2. MORAL OF THE STORY: When you write elements such as Rot^2 Ref, they must be written (in Mathematica) as (Rot^2) ** Ref (with parentheses to override natural precedence). Again, note that this is ONLY for version 2 since in version 3 Mathematica switches the precedence order on these two.

Now let's try calculating the left coset of H in G containing Rot^2 Ref.
;[s]
7:0,0;591,2;609,0;679,1;690,0;824,1;835,0;954,-1;
3:4,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect]
Map[op[(Rot^2) ** Ref, #]&, H]
:[font = text; inactive; preserveAspect]
Note that this is the same result (as sets they don't need to be in the same order) as what we had for the left coset of H in G containing Ref.
:[font = special3; inactive; preserveAspect]
Q1. Calculate both the left and right cosets of H in G containing Rot. Are they the same?
;[s]
2:0,1;2,0;90,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Since this is a somewhat awkward way of calculating cosets (though it conveys exactly what is happening), let's use another method. We have functions LeftCoset and RightCoset that give us what we want:
;[s]
5:0,0;150,1;159,0;164,1;174,0;202,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?LeftCoset
:[font = input; preserveAspect]
LeftCoset[G, H, (Rot^2) ** Ref]
RightCoset[G, H, (Rot^2) ** Ref]
:[font = text; inactive; preserveAspect]
Suppose we consider another group, say Z8, and let H = {0, 2, 4, 6}.
;[s]
3:0,0;40,1;41,0;69,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
G = Z[8]
H = {0, 2, 4, 6}
SubgroupQ[H, G]
:[font = text; inactive; preserveAspect]
(SubgroupQ is a function that one can use to test to see if a set is truly a subgroup or not. We want to make sure that H is a subgroup before we try making cosets.)

Let's try some cosets.
;[s]
3:0,0;1,1;10,0;190,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
LeftCoset[G, H, 0]
LeftCoset[G, H, 1]
:[font = text; inactive; preserveAspect]
For a little more information, try the Textual mode:
;[s]
3:0,0;39,1;46,0;53,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
LeftCoset[G, H, 1, Mode -> Textual]
:[font = text; inactive; preserveAspect]
Here is this last coset from another perspective:
:[font = input; preserveAspect]
LeftCoset[G, H, 1, Mode -> Visual]
:[font = text; inactive; preserveAspect]
To get all the cosets, we can use our Map function and map the LeftCoset function across the whole set of elements of G.
;[s]
5:0,0;38,1;41,0;63,1;72,0;121,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[LeftCoset[G, H, #]&, Elements[G]]
:[font = text; inactive; preserveAspect]
This can be understood better, perhaps, by viewing both the coset and the element that generates the coset; try the following.
:[font = input; preserveAspect]
Map[{#, LeftCoset[G, H, #]}&, Elements[G]]//ColumnForm
:[font = special3; inactive; preserveAspect]
Q2. What observations can you make about these cosets? If you can't think of anything, try the following (but try to think of something first).
;[s]
2:0,1;2,0;144,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
Map[{#, Sort[LeftCoset[G, H, #]]}&, Elements[G]]//ColumnForm
:[font = text; inactive; preserveAspect]
Now compare the left cosets and the right cosets of H = {0, 2, 4, 6} in G = Z8.
;[s]
3:0,0;77,1;78,0;80,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "g + H", "H + g\n"}}, 
	TableDepth -> 2]
:[font = text; inactive; preserveAspect]
In each row, the first element is the element that we are multiplying by (adding to, in this case) our set H. (This element is usually called a coset representative.) The second item is the left coset and the third is the corresponding right coset.
;[s]
3:0,0;143,1;165,0;249,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q3. What observations can you make about the relationship between these left and right cosets?
;[s]
2:0,1;2,0;95,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Lest you jump to a false conclusion, let's consider another example.
:[font = input; preserveAspect]
G = Symmetric[3]
H = {{1, 2, 3}, {1, 3, 2}}
SubgroupQ[H, G]
:[font = text; inactive; preserveAspect]
Now that we know that H is a subgroup of G, we can consider the various left and right cosets.
:[font = input; preserveAspect]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "gH", "Hg\n"}}, 
	TableDepth -> 2]
:[font = special3; inactive; preserveAspect]
Q4. What observations can you make about the relationship between these left and right cosets?
;[s]
2:0,1;2,0;95,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.4 Properties of cosets
:[font = text; inactive; preserveAspect]
Let's look for some common properties among the three collections of cosets found above.
:[font = input; preserveAspect]
G = Dihedral[4];
H = {1, Rot^2};
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "gH", "Hg\n"}}, 
	TableDepth -> 2, TableSpacing -> {0,1}]
:[font = input; preserveAspect]
G = Z[8];
H = {0, 2, 4, 6};
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "g + H", "H + g\n"}}, 
	TableDepth -> 2]
:[font = input; preserveAspect]
G = Symmetric[3];
H = {{1, 2, 3}, {1, 3, 2}};
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "gH", "Hg\n"}}, 
	TableDepth -> 2]
:[font = text; inactive; preserveAspect]
For each of the following questions, consider the examples above and see if you can provide an answer. (Note that in the following questions we use gH and Hg generically, independent of whether the group G writes the cosets additively or multiplicatively.)
:[font = special3; inactive; preserveAspect]
Q5. Recall that when we talk about the left (or right) coset of H in G containing g, we call the element g the coset representative of gH (or Hg). Does it appear that g is one of the elements in gH and Hg? Why or why not?
;[s]
2:0,1;2,0;222,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q6. As you look at the cosets above, when is it the case that gH or Hg actually is the set H? Why is this the case?
;[s]
2:0,1;2,0;116,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q7. Pick any two elements x and y in G. What can you say about the two cosets xH and yH (or, for that matter, the corresponding right cosets)? Justify your answer.
;[s]
2:0,1;2,0;164,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q8. How many different cosets are there for a given group G and subgroup H? Why is this the case?
;[s]
2:0,1;2,0;98,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q9. Although there is only limited evidence (you could produce more, however), what can you say about when we might have the left coset gH equal to the right coset Hg?
;[s]
2:0,1;2,0;168,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q10. When is the left coset gH (or right coset Hg) a subgroup of G? Are there any conditions that guarantee it?
;[s]
2:0,1;3,0;112,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's consider two more examples of cosets. Instead of using the Map function to get our cosets, we can use the functions LeftCosets and RightCosets
;[s]
7:0,0;65,1;68,0;122,1;132,0;137,1;148,0;149,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?LeftCosets
:[font = input; preserveAspect]
G = U[35];
H = {4, 16, 29, 11, 9, 1};
SubgroupQ[H, G]
:[font = input; preserveAspect]
LeftCosets[G, H]
RightCosets[G, H]
:[font = input; preserveAspect]
G = Z[35];
H = {5, 10, 15, 20, 25, 30, 0};
SubgroupQ[H, G]
:[font = input; preserveAspect]
LeftCosets[G, H]
RightCosets[G, H]
:[font = special3; inactive; preserveAspect]
Q11. For each of the groups above, count the number of cosets (either left or right), and calculate the orders of H and G. Now offer a conjecture.
;[s]
2:0,1;3,0;147,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Suppose G = Z (the integers) and H = 2 Z, the even integers. Verify that H is a subgroup of G. Describe the coset 3 + H.
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]

Q13. Suppose G = Z (the integers) and H = 5 Z, the multiples of 5. Suppose x and y are the scores of two opponents playing table tennis. There is a change of service whenever the sum of the scores x and y is a multiple of 5 (and so in H). Each score belongs to one of the following cosets: H, 1 + H, 2 + H, 3 + H or 4 + H. (Why?) Is there any relationship between the coset to which x belongs and the one to which -y belongs at the time of the change of service? Can you give a reasonable explanation for this?
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q14. Suppose G = U[5] x Z[4] and H ={{2,2}, {4,0},{3,2}, {1,0}} is a subgroup. Determine the other left cosets by hand. See if you can use Mathematica to confirm your answer.

;[s]
3:0,0;139,1;150,0;176,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.5 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Dihedral
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?Operation
:[font = input; preserveAspect]
?NonCommutativeMultiply
:[font = input; preserveAspect]
?LeftCoset
:[font = input; preserveAspect]
?RightCoset
:[font = input; preserveAspect]
?SubgroupQ
:[font = input; preserveAspect]
?Textual
:[font = input; preserveAspect]
?Visual
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?Symmetric
:[font = input; preserveAspect]
?LeftCosets
:[font = input; preserveAspect; endGroup; endGroup]
?RightCosets
^*)
