(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 1. An introduction to rings and Ringoids
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
There are no prerequisites for this lab, although a brief introduction to the terminology related to rings may be beneficial.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab is intended to introduce the user both to the mathematical concept of the structure of a ring as well as the corresponding Mathematica structure Ringoid. Various properties that a ring must and can have are introduced and the Mathematica commands to explore these properties are illustrated.
;[s]
3:0,0;154,1;161,0;301,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.3 Getting started? Begin here
:[font = text; inactive; preserveAspect]
In most of the labs in Exploring Abstract Algebra using Mathematica, one needs to first read in extra Mathematica packages necessary to provide the functionality within the lab. This is done using a Needs statement, as below. (Usually, just reading in the AbstractAlgebra`Master` package is done.) Upon opening this notebook you were likely asked "Do you want to automatically evaluate all the initialization cells in the Notebook?". If you answered affirmatively, then you do not need to evaluate the following cell, but it doesn't hurt to do so. If you answered negatively, then you need to evaluate this cell.
;[s]
7:0,0;23,1;67,0;199,2;204,0;256,2;279,0;613,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; initialization; preserveAspect; endGroup]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.4 Ringoids and rings
:[font = text; inactive; preserveAspect]
Consider any set and two operations on that set. We will call this structure a Ringoid. An example of a Ringoid is the following:
;[s]
5:0,0;79,1;86,0;104,1;111,0;130,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
R = FormRingoid[{0, 1, 2}, Mod[#1 + #2, 3]&, Mod[#1 #2, 3]&]
:[font = text; inactive; preserveAspect]
We always refer to the first operation of a Ringoid as addition and the second as multiplication. However, there is no restriction on either of the operations. (In other words, there is no implication that the addition could not act like multiplication and the multiplication act like some other type of operation.) One can access these operations as follows:
;[s]
11:0,0;44,2;51,0;55,1;64,0;82,1;96,0;229,1;237,0;276,1;284,0;360,-1;
3:6,16,12,Times,0,14,0,0,0;4,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Addition[R]
Multiplication[R]
:[font = text; inactive; preserveAspect]
To compute the sum of 2 and 2, as well as the product of 2 and 2, one does as follows:
:[font = input; preserveAspect]
Addition[R][2, 2]
Multiplication[R][2, 2]
:[font = special3; inactive; preserveAspect]
Q1. Will it always be the case that the addition and multiplication return the same value? Why or why not?
;[s]
2:0,1;2,0;107,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
The set of elements in a Ringoid is obtained using either of the following methods:
;[s]
3:0,0;25,1;32,0;84,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Elements[R]
Domain[R]
:[font = text; inactive; preserveAspect]
The operations on R are mod three addition and mod three multiplication, with which you may be very well acquainted. The operation tables for any Ringoid may be displayed with the function CayleyTables:
;[s]
5:0,0;146,1;153,0;189,1;201,0;203,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
CayleyTables[R, Mode -> Visual]
:[font = text; inactive; preserveAspect]
The output of CayleyTables, using the Visual mode, appears in two forms. There are two graphical objects that should resemble tables that appear in an abstract algebra text, and a pair of Mathematica lists representing the tables. If you just want to look at the graphical tables, you need to end the input cell with a semicolon (";") so that the list of list is not displayed. We will often do this from now on. On the other hand, if you are only interested in the output, you may want to drop the Mode -> Visual argument.

There are several types of Ringoids we will consider. Note that the Ringoid we called R above is simply the set of integers mod 3 with the appropriate operations. This can also be obtained by Z[3]. 
;[s]
15:0,0;14,2;26,0;38,2;44,0;188,1;199,0;499,2;513,0;552,2;560,0;593,2;600,0;717,2;721,0;724,-1;
3:8,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;6,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Z[3]
:[font = text; inactive; preserveAspect]
For every integer n, n  1, Zn is the ring with domain {0, 1, . . ., n -1} and operations mod n addition and mod n multiplication. If you used some of the group labs, you may recall that we also use Zn for the group consisting of the same set but with just addition mod n. By default, when we work with rings, we will intend Z[n] to refer to the ring Zn. We can always obtain the group as follows:
;[s]
9:0,0;29,1;30,0;200,1;201,0;325,2;329,0;352,1;353,0;398,-1;
3:5,16,12,Times,0,14,0,0,0;3,24,16,Times,64,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
G = Z[3, Structure -> Group]
:[font = text; inactive; preserveAspect]
We can change the default understanding of Zn to be the group or ring by specifying the options for Zn. For example, when reading in the Mathematica code at start up, the equivalent of the following statement was evaluated.
;[s]
7:0,0;44,2;45,0;101,2;102,0;137,1;148,0;224,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
SetOptions[Z, Structure -> Ring]
:[font = text; inactive; preserveAspect; endGroup]
One could change Ring to Group and then Zn would thereafter be understood to be the group instead of the ring. (Note: the SwitchStructureTo function may also be useful.)

We will be using this family of rings extensively in this lab and subsequent labs. Other rings will be introduced as well. 
;[s]
9:0,0;17,1;21,0;25,1;30,0;41,2;42,0;122,1;139,0;295,-1;
3:5,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.5 Properties of rings
:[font = text; inactive; preserveAspect]
We will be considering some of the properties of a ring. Execute the cell below to be given a random Zn.
;[s]
3:0,0;102,1;103,0;105,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
n = Random[Integer, {8, 19}]
T = Z[n]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
1.5.1 Additive properties
:[font = text; inactive; preserveAspect]
These first few properties pertain only to the addition. To test these properties, we form the additive Groupoid consisting of the elements and the addition of the Ringoid.
;[s]
5:0,0;104,1;112,0;164,1;171,0;173,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?AdditiveGroupoid
:[font = input; preserveAspect]
AG = AdditiveGroupoid[T]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Addition must be closed
:[font = text; inactive; preserveAspect]
Recall that a set H is closed under the operation * if g * h is in H for all g and h in H. We can test for this property with the function ClosedQ. We can either check the additive Groupoid or the Ringoid with a restriction on the operation. (Almost all the ring properties are related to group properties of either the additive or multiplicative Groupoid. In each case, one can check the particular Groupoid or check the Ringoid by specifying a value for the Operation option.)
;[s]
17:0,0;23,2;29,0;139,1;146,0;181,1;189,0;197,1;204,0;347,1;355,0;400,1;408,0;422,1;429,0;460,1;469,0;479,-1;
3:9,16,12,Times,0,14,0,0,0;7,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; endGroup]
ClosedQ[AG]
ClosedQ[T, Operation -> Addition]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Addition must be associative
:[font = text; inactive; preserveAspect]
Recall that addition is associative if and only if a + (b + c) = (a + b) + c for all values of a, b, and c in the domain. We can test for this property with the function AssociativeQ.
;[s]
5:0,0;24,2;35,0;170,1;182,0;184,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
AssociativeQ[T, Operation -> Addition]
:[font = text; inactive; preserveAspect; endGroup]
For larger Ringoids, this test is quite time-consuming. Use of the function RandomAssociativeQ is advised for these Ringoids. This function tests random triples (a, b, c) for the associative property. If any triple violates the condition, the addition is known to be not associative. If no violation occurs, it is likely that the addition is associative.
;[s]
7:0,0;11,1;19,0;76,1;94,0;116,1;124,0;355,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Addition must be commutative
:[font = text; inactive; preserveAspect]
Addition is commutative if and only if a + b = b + a for all values of a and b in the domain. You can test for this property with the function AbelianQ or CommutativeQ, but the former only works with Groupoids. (Thus, we can use AbelianQ with the additive Groupoid or use CommutativeQ on the Ringoid.)
;[s]
17:0,0;12,2;23,0;143,1;151,0;155,1;167,0;200,1;210,0;229,1;237,0;256,1;264,0;272,1;284,0;292,1;299,0;302,-1;
3:9,16,12,Times,0,14,0,0,0;7,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; endGroup]
AbelianQ[AG]
CommutativeQ[T, Operation -> Addition]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Existence of a "zero"
:[font = text; inactive; preserveAspect]
The term zero is used for the additive identity of a ring. That is, if z is the zero, then
;[s]
3:0,0;9,1;13,0;91,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
z + r = r + z = r
:[font = text; inactive; preserveAspect]
for all r in the ring. To ask whether a zero exists, use the following.
:[font = input; preserveAspect]
HasIdentityQ[T, Operation -> Addition]
:[font = text; inactive; preserveAspect]
This test can be performed more directly as follows:
:[font = input; preserveAspect]
HasZeroQ[T]
:[font = text; inactive; preserveAspect]
When a Ringoid has a zero, it can be called upon by name.
;[s]
3:0,0;7,1;14,0;58,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Zero[T]
:[font = special3; inactive; preserveAspect]
Q2. What is the zero of Ringoid[{0, 1, 2, 3}, Mod[#1 + #2, 4] & , Mod[#1*#2, 4] & ]?
;[s]
4:0,1;2,0;24,2;83,0;85,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q3. What is the zero of Ringoid[{0, 1, 2, 3}, Mod[#1*#2, 4] & , Mod[#1 + #2, 4] & ]?
;[s]
4:0,1;2,0;24,2;83,0;85,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Additive inverses
:[font = text; inactive; preserveAspect]
Assuming a Ringoid has a zero z, we say r is the additive inverse of s if s + r = r + s = z. All elements of a ring must have an additive inverse. The additive inverse of s is referred to as its negation. We can ask whether all elements have an additive inverse.
;[s]
5:0,0;11,1;18,0;195,2;203,0;263,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
HasInversesQ[T, Operation -> Addition]
:[font = text; inactive; preserveAspect]
We can also ask for a list that displays how the elements of the Ringoid pair up as inverses. As long as the addition is associative, it can be proven that no element can have more than one negation. You will find that in some cases an element is its own negation. 
;[s]
3:0,0;65,1;72,0;266,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Inverses[T, Operation -> Addition]
:[font = special3; inactive; preserveAspect]
Q4. How many elements in T are their own negation? (Also, what is your ring T?)
;[s]
2:0,1;2,0;80,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
The negation of an individual Ringoid element can be determined using NegationOf.
;[s]
5:0,0;30,1;37,0;70,1;80,0;82,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
NegationOf[T, 1]
:[font = special3; inactive; preserveAspect]
Q5. Below, form another random Zn, named T2. What ring did you get? For each element, determine its negation without Mathematica. Use either Inverses or NegationOf to check your work.
;[s]
12:0,1;2,0;32,4;33,0;41,3;43,0;117,2;128,0;141,3;149,0;153,3;163,0;184,-1;
5:6,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;3,15,11,Courier,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect; endGroup; endGroup]
n = Random[Integer, {5, 12}]
T2 = Z[n]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
1.5.2 Multiplicative properties
:[font = text; inactive; preserveAspect]
We will use MG for the multiplicative Groupoid of the ring T:
;[s]
5:0,0;12,1;14,0;38,1;46,0;62,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?MultiplicativeGroupoid
:[font = input; preserveAspect]
MG = MultiplicativeGroupoid[T]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Multiplication must be closed
:[font = text; inactive; preserveAspect]
Not only must the addition be closed, but the multiplication must be as well. As noted above, we can either check the multiplicative Groupoid or the Ringoid and restrict the operation.
;[s]
5:0,0;133,1;141,0;149,1;156,0;185,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
ClosedQ[MG]
ClosedQ[T, Operation -> Multiplication]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Multiplication must be associative
:[font = text; inactive; preserveAspect]
Besides being closed, the multiplication must also be associative.
:[font = input; preserveAspect; endGroup; endGroup]
AssociativeQ[T, Operation -> Multiplication]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
1.5.3 Distributive property
:[font = text; inactive; preserveAspect]
There is one property that considers how the addition and multiplication interact: multiplication must be distributive over addition in order for a Ringoid to be a ring. That is, we must have
;[s]
5:0,0;106,2;118,0;148,1;155,0;192,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
a(b + c) = ab + ac         and         (b + c)a = ba + ca
:[font = text; inactive; preserveAspect]
for all values of a, b, and c in the domain of the Ringoid. The function DistributiveQ tests for this property.
;[s]
5:0,0;51,1;58,0;73,1;86,0;112,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
DistributiveQ[T]
:[font = text; inactive; preserveAspect; endGroup]
A function called RandomDistributiveQ, which is similar to RandomAssociativeQ, is also available.
;[s]
5:0,0;18,1;38,0;59,1;77,0;98,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
1.5.4 Is the Ringoid a ring?
:[font = text; inactive; preserveAspect]
If all the properties we have tested up to this point are satisfied, then we can call the Ringoid a ring. We can use the function RingQ to perform all of these tests in one statement.
;[s]
9:0,0;3,1;6,0;90,3;97,0;100,2;104,0;130,3;135,0;184,-1;
4:5,16,12,Times,0,14,0,0,0;1,16,12,Times,4,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
RingQ[T]
:[font = text; inactive; preserveAspect]
As one works with a Ringoid and is testing various properties, the results are collected and can be retrieved by a function called RingInfo. Here is what we know so far about T.
;[s]
5:0,0;20,1;27,0;131,1;139,0;178,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
RingInfo[T]
:[font = special3; inactive; preserveAspect]
Q6. Given any value of n, is Z[n] a ring? Why or why not?
;[s]
2:0,1;2,0;58,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
1.5.5 "Optional" properties
:[font = text; inactive; preserveAspect]
There are additional properties that are frequently satisfied by a ring. We will often look for rings that satisfy some combination of these properties in the future. 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Ring with unity
:[font = text; inactive; preserveAspect]
Unity is the term that is used for the multiplicative identity of a ring. That is, if u is the unity, then
;[s]
2:0,1;5,0;107,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
u r = r u = r
:[font = text; inactive; preserveAspect]
for all r in the ring. To determine whether a unity exists, try the following:
:[font = input; preserveAspect]
WithUnityQ[T]
:[font = text; inactive; preserveAspect]
If there is a unity, it can be called upon by name.
:[font = input; preserveAspect]
Unity[T]
:[font = special3; inactive; preserveAspect]
Q7. Does Z[n] have a unity for all values of n? Why or why not? If so, what is it?
;[s]
2:0,1;2,0;83,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Commutative ring
:[font = text; inactive; preserveAspect]
A ring is said to be commutative if its multiplication is commutative. (Recall that the addition must be commutative in a ring.)
;[s]
5:0,0;21,1;32,0;97,1;101,0;129,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
CommutativeQ[T, Operation -> Multiplication]
:[font = text; inactive; preserveAspect]
There are several other "optional" properties that we will introduce in the next lab.
:[font = special3; inactive; preserveAspect]
Q8. Is Z[n] commutative for all values of n? Why or why not?
;[s]
2:0,1;2,0;61,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.6 Additional exercises
:[font = special3; inactive; preserveAspect]
Q9. If k is a divisor of n, we use Z[n, k] to denote the Ringoid whose elements are {0, k, 2k,..., ((n/k)-1)k} with addition being mod n addition and multiplication being mod n multiplication. Is Z[8, 2] a ring? Is it commutative? Is it a ring with unity? Justify your answers.
;[s]
8:0,1;2,0;34,2;42,0;57,2;64,0;196,2;203,0;278,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q10. Is Z[10, 2] a ring? Is it commutative? Is it a ring with unity? Justify your answers.
;[s]
4:0,1;3,0;7,2;16,0;91,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q11. What happens if you switch the addition and multiplication in a ring? In other words, if we have a ring R = Ringoid[D, plus, times], then is Ringoid[D, times, plus] ever a ring? Try Z[n, k] for various n and k and see if you can produce such a ring.
;[s]
8:0,1;3,0;109,2;136,0;146,2;169,0;187,2;194,0;255,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Evaluate the following cells. Study the multiplication tables. Can you note any differences or similarities between any of these rings?
;[s]
2:0,1;3,0;141,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
CayleyTables[Z[4], Mode -> Visual];
:[font = input; preserveAspect]
CayleyTables[Z[5], Mode -> Visual];
:[font = input; preserveAspect]
CayleyTables[Z[6], Mode -> Visual];
:[font = input; preserveAspect; endGroup]
CayleyTables[Z[7], Mode -> Visual];
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
1.7 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect]
?SwitchStructureTo
:[font = input; preserveAspect]
?FormRingoid
:[font = input; preserveAspect]
?Addition
:[font = input; preserveAspect]
?Multiplication
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?Domain
:[font = input; preserveAspect]
?CayleyTables
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?Structure
:[font = input; preserveAspect]
?Group
:[font = input; preserveAspect]
?Ring
:[font = input; preserveAspect]
?Random
:[font = input; preserveAspect]
?AdditiveGroupoid
:[font = input; preserveAspect]
?Operation
:[font = input; preserveAspect]
?ClosedQ
:[font = input; preserveAspect]
?AssociativeQ
:[font = input; preserveAspect]
?RandomAssociativeQ
:[font = input; preserveAspect]
?AbelianQ
:[font = input; preserveAspect]
?CommutativeQ
:[font = input; preserveAspect]
?HasIdentityQ
:[font = input; preserveAspect]
?HasZeroQ
:[font = input; preserveAspect]
?Zero
:[font = input; preserveAspect]
?HasInversesQ
:[font = input; preserveAspect]
?Inverses
:[font = input; preserveAspect]
?NegationOf
:[font = input; preserveAspect]
?MultiplicativeGroupoid
:[font = input; preserveAspect]
?DistributiveQ
:[font = input; preserveAspect]
?RandomDistributiveQ
:[font = input; preserveAspect]
?RingQ
:[font = input; preserveAspect]
?RingInfo
:[font = input; preserveAspect]
?WithUnityQ
:[font = input; preserveAspect; endGroup; endGroup]
?Unity
^*)
