(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 2. An introduction to rings: part two
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
2:0,0;51,1;63,-1;
2:1,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
You should complete Ring Lab 1 before attempting this lab.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goals of this lab are to familiarize you with several important types of rings and to make you aware of how to work with these rings in the context of the AbstractAlgebra packages.
;[s]
3:0,0;159,1;174,0;185,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.3 Units & zero divisors
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
2.3.1 Units of a ring
:[font = text; inactive; preserveAspect]
First, let's read in the code that provides the functionality needed for this lab.
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect]
In a ring with unity, an element that has a multiplicative inverse in the ring is called a unit. The percentage of elements that are units in a ring can vary quite a bit. The unity of a ring is always a unit, and the zero of a ring is never a unit. If all the nonzero elements of a commutative ring with unity are units, the ring is called a field. We will discuss fields at length in a later lab. It is also possible for a ring to have no units other than the unity. 

We will now consider the set of units in a variety of rings.
;[s]
5:0,0;91,1;95,0;342,1;347,0;531,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Units of Z[8]
:[font = text; inactive; preserveAspect]
Consider the ring Z8. What do the Cayley tables tell us?
;[s]
3:0,0;19,1;20,0;57,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
CayleyTables[Z[8], Mode->Visual];
:[font = special3; inactive; preserveAspect]
Q1. What is the unity of the ring Z8? What are the units of Z8? Explain how you obtained your answers.
;[s]
6:0,1;2,0;35,2;36,0;61,2;62,0;103,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Boolean rings
:[font = text; inactive; preserveAspect]
A Boolean ring consists of the set of all subsets of a given set, combined with the operations symmetric difference for the addition, and intersection for the multiplication.
Let's consider an example:
;[s]
3:0,0;2,1;14,0;202,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
R = BooleanRing[{Larry, Moe, Curly}]
:[font = text; inactive; preserveAspect]
This is the collection of all subsets of the set {Larry, Moe, Curly}. Note the cardinality of the set.
;[s]
3:0,0;49,1;68,0;103,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q2. Suppose that you replaced {Larry, Moe, Curly} with the names of the students in your class. (This would increase the average intelligence of the set by a huge factor.) How many elements would this new Ringoid have? Justify your answer.
;[s]
4:0,1;2,0;30,2;49,0;240,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Note that this Ringoid has a different approach to addition and multiplication. The following will confirm the description given above.
:[font = input; preserveAspect]
Addition[R]
Multiplication[R]
:[font = text; inactive; preserveAspect]
The multiplication is simply the intersection of two subsets. The addition, as indicated, is the symmetric difference of two subsets. In case you need a quick review of the symmetric difference, consider the following examples:
:[font = input; preserveAspect]
setA = {2, 3, 4}
setB = {1, 3, 4, 5}
setC = {3, 4}
:[font = input; preserveAspect]
Addition[R][setA, setB]
Addition[R][setA, setC]
:[font = text; inactive; preserveAspect]
You should note that the symmetric difference of two sets returns the union of the two sets with the elements in the intersection removed.

Consider the Cayley tables of this ring. After the tables are produced, enlarge them (until you can see them more clearly) by selecting the graphic and then stretching from one of the corners.
:[font = input; preserveAspect]
CayleyTables[BooleanRing[{Curly, Moe, Larry}], Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q3. What is the zero of this ring? Justify your answer.
;[s]
2:0,1;2,0;56,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now we will focus on the Boolean ring of subsets of {1, 2} and its multiplication table.
:[font = input; preserveAspect]
R1 = BooleanRing[2]
:[font = input; preserveAspect]
MultiplicationTable[R1, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q4. What is the zero for this ring? Is there a unity for this ring? If so, what is it (and explain how you obtained it); if not, explain why not.
;[s]
2:0,1;2,0;146,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q5. Determine all the units for this ring.
;[s]
2:0,1;2,0;43,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q6. Generalize: determine all the units for the ring BooleanRing[n].
;[s]
4:0,1;2,0;53,2;67,0;69,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Gaussian integers mod n
:[font = text; inactive; preserveAspect]
The Gaussian integers, Z[i], is defined as the ring whose elements are {a + b i | a, b are in Z} and whose operations are ordinary (complex) addition and multiplication. Note that this is an infinite subring of the complex numbers.
:[font = special3; inactive; preserveAspect]
Q7. Prove this last statement.
;[s]
2:0,1;2,0;31,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
We can consider a finite variation of Z[i] by reducing the elements modulo some positive integer. Try, for example, 3:
:[font = input; preserveAspect]
R2 = Z[3, I, Structure -> Ring]
:[font = text; inactive; preserveAspect]
What can we see in the tables? (Again, enlarge the graphic so it is more visible.)
:[font = input; preserveAspect]
CayleyTables[R2, Mode -> Visual];
:[font = special3; inactive; preserveAspect]
Q8. What is the zero of this ring?
;[s]
2:0,1;2,0;35,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q9. Is there a unity for this ring? If so, what is it (and explain how you obtained it); if not, explain why not.
;[s]
2:0,1;2,0;114,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q10. Determine all the units for this ring.
;[s]
2:0,1;3,0;44,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Units of a ringoid.
:[font = text; inactive; preserveAspect]
There are three basic functions related to units that can be used: UnitQ, Units and MultiplicativeInverse.
;[s]
7:0,0;67,1;72,0;74,1;79,0;84,1;105,0;107,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?UnitQ
:[font = input; preserveAspect]
?Units
:[font = input; preserveAspect]
?MultiplicativeInverse
:[font = text; inactive; preserveAspect]
You can test your answer to the last question:
:[font = input; preserveAspect; endGroup]
Units[R2]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Trivial ring
:[font = text; inactive; preserveAspect]
Consider the "trivial ring," for which all products are zero: 
:[font = input; preserveAspect]
?TrivialZR
:[font = input; preserveAspect]
CayleyTables[TrivialZR[5], Mode -> Visual];
:[font = input; preserveAspect]
UnitQ[TrivialZR[5], 3]
:[font = text; inactive; preserveAspect; endGroup; endGroup]
Since the "trivial ring" has no unity, appropriate messages are given. Observe that 3 does not have a multiplicative inverse.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
2.3.2 Zero divisors of a ring
:[font = text; inactive; preserveAspect]
In solving a quadratic equation such as x2- 3x -10 = 0, we routinely factor the left-hand side to (x - 5)(x + 2) and solve x - 5 = 0 and then x + 2 = 0. We are accustomed to assuming that in order for a product to be zero, one of the factors must be zero. This is an assumption that can not be made in the general theory of rings. Consider the ring of integers modulo 15, Z15. As can be seen from the multiplication table, there are many instances where products of nonzero elements of Z15 are zero.
;[s]
7:0,0;41,1;42,0;373,2;375,0;487,2;489,0;500,-1;
3:4,16,12,Times,0,14,0,0,0;1,24,16,Times,32,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
CayleyTables[Z[15], Mode -> Visual, Operation -> Multiplication];
:[font = text; inactive; preserveAspect]
A zero divisor is a nonzero ring element that can produce a product of zero upon multiplication with another nonzero element. For example, in Z15, 10 is a zero divisor because its product with 3 is zero.
;[s]
5:0,0;2,1;14,0;143,2;145,0;204,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q11. Determine all the zero divisors for Z15.
;[s]
4:0,1;3,0;42,2;44,0;46,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Determine all the zero divisors for Z11. (If you wish, change the 15 to 11 in the CayleyTables command above.)
;[s]
6:0,1;3,0;42,3;44,0;87,2;99,0;116,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Recall the two rings with which we worked earlier:
:[font = input; preserveAspect]
R1 = BooleanRing[2]
R2 = Z[3, I, Structure -> Ring]
:[font = special3; inactive; preserveAspect]
Q13. Determine all the zero divisors of both R1 and R2.
;[s]
2:0,1;3,0;56,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
2.3.3 Working with zero divisors
:[font = text; inactive; preserveAspect]
To work with zero divisors, one can use either of the following functions:
:[font = input; preserveAspect]
?ZeroDivisors
:[font = input; preserveAspect]
?ZeroDivisorQ
:[font = text; inactive; preserveAspect]
Here is how one might test one's answer to the questions above:
:[font = input; preserveAspect]
ZeroDivisors[Z[15]]
:[font = input; preserveAspect]
ZeroDivisorQ[Z[15], 8]
ZeroDivisorQ[Z[15], 9]
:[font = text; inactive; preserveAspect]
The number of zero divisors can vary substantially from one Ringoid to another.
;[s]
3:0,0;60,1;67,0;80,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ZeroDivisors[Z[11]]
:[font = input; preserveAspect]
ZeroDivisors[TrivialZR[11]]
:[font = text; inactive; preserveAspect]
You may want to check your answers to the previous question.
:[font = input; preserveAspect; endGroup; endGroup]
ZeroDivisors[R1]
ZeroDivisors[R2]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.4 Integral domains
:[font = text; inactive; preserveAspect]
An integral domain is a commutative ring with unity with no zero divisors. The ring of integers is a prototypical example. 
:[font = special3; inactive; preserveAspect]
Q14. Recall the rings used in this lab thus far. Which are integral domains and which are not? Come up with at least one of each.
;[s]
2:0,1;3,0;130,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.5 Fields
:[font = text; inactive; preserveAspect]
A field is a commutative ring with unity with the property that every nonzero element is a unit. 
:[font = special3; inactive; preserveAspect]
Q15. Recall the rings used in this lab thus far. Which are fields and which are not? Come up with at least one of each.
;[s]
2:0,1;3,0;120,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.6 Additional exercises
:[font = special3; inactive; preserveAspect]
Q16. What are the units of Z[20, 5]? What are the zero divisors? 
;[s]
4:0,1;3,0;27,2;35,0;66,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
CayleyTables[Z[20, 5], Mode -> Visual];
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q17. Using the functions provided thus far, find a Ringoid that has a unity and this element is the only nonzero element that is not a zero divisor.
;[s]
4:0,1;3,0;51,2;58,0;149,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q18. Using the functions provided thus far, find a Ringoid that has a unity and the only non-unit is the zero. Is this ring a field?
;[s]
4:0,1;3,0;51,2;58,0;133,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q19. True or False? In a commutative ring with unity, the intersection of units and zero divisors is always empty. Prove that your answer is correct.
;[s]
2:0,1;3,0;150,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
To test if a Ringoid is an integral domain or field, there are appropriate functions that can be used (besides testing the parts of the definition). The following illustrates these.
;[s]
3:0,0;13,1;20,0;182,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
IntegralDomainQ[Z[7]]
IntegralDomainQ[BooleanRing[2]]
:[font = input; preserveAspect; endGroup]
FieldQ[Z[7]]
FieldQ[Z[15]]
FieldQ[Z[20, 4]]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
2.7 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect]
?SwitchStructureTo
:[font = input; preserveAspect]
?Ring
:[font = input; preserveAspect]
?CayleyTables
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?Mode
:[font = input; preserveAspect]
?Visual
:[font = input; preserveAspect]
?BooleanRing
:[font = input; preserveAspect]
?Addition
:[font = input; preserveAspect]
?Multiplication
:[font = input; preserveAspect]
?MultiplicationTable
:[font = input; preserveAspect]
?Structure
:[font = input; preserveAspect]
?UnitQ
:[font = input; preserveAspect]
?Units
:[font = input; preserveAspect]
?MultiplicativeInverse
:[font = input; preserveAspect]
?TrivialZR
:[font = input; preserveAspect]
?Operation
:[font = input; preserveAspect]
?ZeroDivisors
:[font = input; preserveAspect]
?ZeroDivisorQ
:[font = input; preserveAspect]
?IntegralDomainQ
:[font = input; preserveAspect; endGroup; endGroup]
?FieldQ
^*)
