(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O431, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O433,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; fontColorBlue = 0]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
Ring Lab 5. Ring homomorphisms
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
5.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.1 Prerequisites
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Before you start this lab, you should be familiar with Ringoids and the ideas found in Ring Labs 1 and 2, as well as normal subgroups and ideals.
;[s]
3:0,0;55,1;63,0;146,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.2 Goals for this lab
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
This lab explores the notion of a ring homomorphism. First we define one, and then we see how one can be constructed. 

This lab is designed to be independent of the group labs on isomorphisms and homomorphisms. If you have done them, you can skip the first section of this lab, except to evaluate the inputs that define Morphoids f, g, and w.
;[s]
3:0,0;321,1;330,0;344,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.3 Morphoids on rings
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
A Morphoid is a Mathematica object that consists of either a function or a set of rules followed by two structured sets (Ringoids or Groupoids). The function or rules serve to map each element in the first structured set into the second one. The only principle governing construction of a Morphoid is that an actual (mathematical) function must be defined by the rules or function. To continue, let's read in the Mathematica functions that we will need for this lab.
;[s]
13:0,0;2,2;10,0;16,1;27,0;121,2;129,0;133,2;142,0;289,2;297,0;413,1;424,0;467,-1;
3:7,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; initialization; preserveAspect; rightWrapOffset = 522]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The way to create a Morphoid is with the function FormMorphoid. For example, to define the Morphoid from the ring Z[15] into the ring Z[30],where the image of each element x in Z[15] is 2x, we evaluate
;[s]
7:0,0;20,1;28,0;50,1;62,0;91,1;99,0;202,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
f = FormMorphoid[2# &, Z[15], Z[30]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
If you try to create a Morphoid with an invalid function, it will fail to be created:
;[s]
3:0,0;23,1;31,0;86,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FormMorphoid[2# &, Z[15], Z[20]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
One family of built-in Morphoids is ZMap[m, n], where m and n are positive integers.
;[s]
5:0,0;23,1;32,0;36,1;46,0;85,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
?ZMap
:[font = input; preserveAspect; rightWrapOffset = 522]
g = ZMap[15, 5, Structure -> Ring]
:[font = text; inactive; preserveAspect]
You can get a graphical representation of a Morphoid with the function VisualizeMorphoid (or by using the Visual mode of FormMorphoid).
;[s]
9:0,0;44,1;52,0;71,1;88,0;106,1;112,0;121,1;133,0;136,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?VisualizeMorphoid
:[font = input; preserveAspect]
VisualizeMorphoid[g, ColorCodomain -> 
	Table[{Hue[i/5], Elements[Codomain[g]][[i]]}, {i, 5}]];
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Any pair of Ringoids can potentially have a Morphoid connecting them. Here is an example that is defined with a list of rules instead of a function.
;[s]
5:0,0;12,1;20,0;44,1;52,0;149,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
w = FormMorphoid[{{} -> 0, {1} -> 0, {2} -> 0, {1, 2} -> 1}, 
	BooleanRing[2], Z[2]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
You may have noticed that depending on how you create a Morphoid, the first argument that appears in the output can vary. Ideally, what appears is the simplest description of the function that defines the Morphoid. As you will see later, the single rule 1->1 defines the Morphoid g (that was defined above), so the rest of the rules that define g do not need to be displayed.
;[s]
7:0,0;56,1;64,0;205,1;213,0;271,1;279,0;376,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.4 Ring homomorphisms
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
A homomorphism between rings R and T is a function that preserves the operations between the two rings. That is, if f is a homomorphism, then for all values of x and y selected from R,
;[s]
3:0,0;2,1;14,0;185,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 522]
f(x + y) = f(x) + f(y), and
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 522]
f(x * y) = f(x) * f(y).
;[s]
5:0,0;4,1;6,0;16,1;18,0;24,-1;
2:3,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
(Note that the operations + and * on the left-hand side occur within R, while those on the right-hand side occur within T.) If f is also one-to-one and onto, then it is an isomorphism. The existence of an isomorphism between two rings establishes them as being "equal" in an algebraic sense.

To review the notion of operation preserving, we will start by looking at the first two Morphoids (f and g) that were defined above, since their domains are the same. For both of them we use the pair of elements {11, 7} and use the function PreservesQ to see if the conditions above are satisfied when x = 11 and y = 17.
;[s]
7:0,0;172,2;183,0;381,1;390,0;534,1;544,0;614,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
PreservesQ[f, {11, 7}]
:[font = input; preserveAspect; rightWrapOffset = 522]
PreservesQ[g, {11, 7}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
To see why f does not preserve operations, we can use the Visual mode.
;[s]
3:0,0;58,1;64,0;71,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
PreservesQ[f, {11, 7}, Mode -> Visual];
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
From this graphical representation of the tests, we see that the addition condition is satisfied, but the multiplication condition fails: f(11 * 7) = 4 but f(11) * f(7) = 8. Therefore, f is not a ring homomorphism. Although g did preserve the operations for the pair {11, 7}, we can not conclude that g is a homomorphism, since the conditions were checked for only one of the 152 = 225 pairs of values that need to be checked. MorphismQ will check them all at once. 
;[s]
5:0,0;378,2;379,0;427,1;436,0;467,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
MorphismQ[g, Mode -> Visual]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q1. The third Morphoid that was defined in the first section of this lab is also not a homomorphism. Explain why this is the case with a specific example that shows it is not.
;[s]
4:0,1;2,0;14,2;22,0;176,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.5 The kernel and image
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.5.1 The kernel
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since every ring "contains" the additive group consisting of the domain and the addition operation, a ring homomorphism can also be viewed as a group homomorphism. This observation extends to the more general structures of a Morphoid on a Ringoid and a Morphoid on a Groupoid. If you have already studied group homomorphisms, you are aware of the concept of the kernel. In the group setting, the kernel of a homomorphism is the set of elements in the domain that map onto the identity of the codomain. With rings, the additive identity is the zero of the ring. Therefore it is natural to make the following definition: the kernel of a ring homomorphism is the set of elements in the domain that map onto the zero of the codomain.

Our first true ring homomorphism was called g. What is its kernel? The Visual mode of Kernel should clearly illustrate the elements in the kernel.
;[s]
15:0,0;225,1;233,0;239,1;246,0;253,1;261,0;267,1;275,0;623,2;629,0;802,1;808,0;817,1;823,0;878,-1;
3:8,16,12,Times,0,14,0,0,0;6,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Kernel[g, Mode -> Visual]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q2. First, review the definition of an ideal. Without making any assumptions about the kernel (except its definition), answer the following questions.

(a) If h is a ring homomorphism and r and s are in K = Kernel[h], explain why r - s must also be in K.

(b) If h is a ring homomorphism and r is in K = Kernel[h] and s is in the domain of h, explain why r s and s r must also be in K.

(c) Properties from (a) and (b) above imply what about the kernel? 
;[s]
6:0,1;2,0;207,2;213,0;304,2;309,0;455,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Kernel returns a result that is a Ringoid. It is a well-defined Mathematica function, provided the codomain has a zero.
;[s]
6:0,2;6,0;34,2;41,0;64,1;75,0;120,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
f
Kernel[f]
:[font = input; preserveAspect; rightWrapOffset = 522]
w
Kernel[w]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q3. What conclusions, if any, can be drawn from the observations made in question 2 and the values of Kernel[f] and Kernel[w]? Assume that you do not know whether f or w is a homomorphism.
;[s]
10:0,1;2,0;102,2;111,0;116,2;126,0;163,2;164,0;168,2;169,0;189,-1;
3:5,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.5.2 The image
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The image of a ring homomorphism is the range of the function, but it inherits the operation of the codomain and is also a Ringoid. For our first homomorphism, g, the image is the whole codomain, which is quite common.
;[s]
3:0,0;123,1;130,0;219,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Image[g]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Although a Morphoid that is not a homomorphism can have an image, and that image may also be a subring (as we see with f that we defined above), there is no guarantee that it will be a subring.
;[s]
3:0,0;11,1;19,0;194,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Image[f]
ClosedQ[%]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q4. Find an example of a Morphoid of rings for which the image is not a subring of the codomain.
;[s]
4:0,1;2,0;25,2;33,0;97,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.6 The kernel is an ideal
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
It was observed at the conclusion of question 2 that the kernel of a ring homomorphism is an ideal of the domain. This closely parallels the situation with groups. The kernel of a group homomorphism is a normal subgroup. Ideals and normal subgroups are precisely the subsets of their respective systems that allow quotient systems of cosets. We will illustrate this situation in the ring case here.
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.6.1 Example 1
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Our first true ring homomorphism was called g. 
:[font = input; preserveAspect; rightWrapOffset = 522]
g

Kernel[g]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We can create the quotient ring with QuotientRing.
;[s]
3:0,0;37,2;49,1;51,-1;
3:1,16,12,Times,0,14,0,0,0;1,13,10,Courier,1,12,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
QR = QuotientRing[Z[15], Kernel[g]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The theory that has lead up to this point assures us that QR is a ring.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q5. To what common ring is QR isomorphic?
;[s]
2:0,1;2,0;42,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Your response to the question above should be implied by the following theorem. (The proof of this appears in nearly every introductory abstract algebra text.)
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.6.2 The First Isomorphism Theorem (for rings)
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Theorem Let f : R -> S be a surjective (onto) homomorphism of rings with kernel K. Then the quotient ring R/K is isomorphic to the image of f, with the isomorphism g : R/K -> f(R) defined by g(a + K) = f(a).
;[s]
2:0,1;7,0;208,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.6.3 Example 2
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
In our second example, we will define and work with a Morphoid based on a direct product.
;[s]
3:0,0;54,1;62,0;90,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
R = DirectProduct[Z[3], Z[5]]
:[font = text; inactive; preserveAspect]
We define a Morphoid from Z30 into R.
;[s]
5:0,0;12,2;20,0;27,1;29,0;38,-1;
3:3,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
beta = FormMorphoid[{Mod[#, 3], Mod[#, 5]}&, Z[30], R]
:[font = input; preserveAspect; rightWrapOffset = 522]
MorphismQ[beta]
:[font = input; preserveAspect; rightWrapOffset = 522]
K = Kernel[beta]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q6. Based on the size of the kernel, how many elements should we expect to have in the quotient ring Z[30]/K? 
;[s]
2:0,1;2,0;111,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We can generate the quotient ring to verify your conjecture from the last question.
:[font = input; preserveAspect; rightWrapOffset = 522]
Q2 = QuotientRing[Z[30], Elements[K]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q7. Based on the First Isomorphism Theorem, to what ring is the quotient ring isomorphic?
;[s]
2:0,1;2,0;90,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
5.7 One rule Morphoids
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
It was noted earlier that ZMap[15, 5] and similar expressions form Morphoids with a single rule displayed. Internally, the Morphoid is actually defined with a function, but the rule may be somewhat shorter, so for simplicity we display the rule.
;[s]
5:0,0;67,1;76,0;123,1;131,0;246,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
h = ZMap[4, 2]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q8. (a) Assuming that h is a morphism, which is true, explain how and why the rule 1 -> 1 determines rules for the other elements in Z[4]. (What are the other rules?)

		(b) Explain what goes wrong with ZMap[3, 2] and why 1 -> 1 can not define a morphism.
;[s]
2:0,1;2,0;256,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.8 The Chinese Remainder Theorem
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The image of the homomorphism beta, considered before the last section, was the direct product of Z[3] with Z[5]. This direct product happens to be isomorphic to Z[15]. This follows from the Chinese Remainder Theorem.

Chinese Remainder Theorem. If m1, m2, ..., mr are positive integers such that no two have a common divisor greater than one, then the ring Z[m1m2...mr] is isomorphic to the direct product of the rings Z[m1], Z[m2], ..., and Z[mr].

We will not provide the complete proof of this theorem since it appears in many standard texts. We will, however, describe one approach from a computational point of view, using our previous example.

An isomorphism from Z[15] into Z[3] x Z[5] is easy to construct. We map each element of Z[15] into the pair of remainders upon division by 3 and 5 respectively.
;[s]
21:0,0;219,1;244,0;250,2;251,0;254,2;255,0;263,2;264,0;361,2;362,0;363,2;364,0;368,2;369,0;423,2;424,0;430,2;431,0;446,2;447,0;813,-1;
3:11,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;9,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
theta = FormMorphoid[{Mod[#, 3], Mod[#, 5]}&, Z[15], R]
:[font = input; preserveAspect; rightWrapOffset = 522]
IsomorphismQ[theta]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
For our specific case, the matter is settled. In the general situation, if we were to define a similar function from Z[m1m2...mr] into the direct product, it is not totally clear that the function would be one-to-one and onto. This can be proven, however, and there is an algorithm that determines the inverse of the function. The inverse, which is not as simple to compute, is available as a function called ChineseRemainderTheorem in the NumberTheory`NumberTheoryFunctions package. Let's load this package and learn about this function.
;[s]
11:0,0;120,1;121,0;122,1;123,0;127,1;128,0;409,2;432,0;440,2;474,0;539,-1;
3:6,16,12,Times,0,14,0,0,0;3,21,13,Times,64,12,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Needs["NumberTheory`NumberTheoryFunctions`"];

?ChineseRemainderTheorem
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
In our example, we might want to know what the inverse image of {2, 3} is; that is, for what integer n is theta[n] equal to {2, 3}. We use {2, 3} for the first argument and {3, 5} for the second, since 3 and 5 are two moduli used to form the codomain of theta.
;[s]
3:0,0;130,1;131,0;261,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
ChineseRemainderTheorem[{2, 3}, {3, 5}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
This says that 8 is the smallest integer congruent to 2 mod 3 and also congruent to 3 mod 5. We can easily verify this result.
:[font = input; preserveAspect; rightWrapOffset = 522]
theta[8]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The inverse function can be used to create an inverse isomorphism
:[font = input; preserveAspect; rightWrapOffset = 522]
gamma = FormMorphoid[ChineseRemainderTheorem[#, {3, 5}]&, R, Z[15]]
:[font = input; preserveAspect; rightWrapOffset = 522]
IsomorphismQ[gamma]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Of course, we should also verify that gamma is really the inverse of theta.
:[font = input; preserveAspect; rightWrapOffset = 521]
MorphoidComposition[theta, gamma]
:[font = input; preserveAspect; rightWrapOffset = 521]
MorphoidComposition[gamma, theta]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q9. Explain why the last two results verify that these two functions are inverses.
;[s]
2:0,1;2,0;83,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The power of the ChineseRemainderTheorem function may not be clear, since our original function was based on a relatively small set. Here is a question for which the Chinese Remainder Theorem can be employed.
;[s]
3:0,0;17,1;40,0;209,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q10. Suppose that Franklin Street Clothing is having a sale. You give x dollars to person A, who then buys as many $19 shirts as possible with the x dollars and then has $3 left over. You also give x dollars to person B, who then buys as many $29 sweat shirts as possible with the x dollars and then has $26 left over. What is the least positive number of dollars that x could be? Explain how the answer to this problem can be obtained using isomorphisms.
;[s]
2:0,1;3,0;456,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We finish up the lab with a couple of follow-up questions.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q11. Does the Chinese Remainder Theorem tell us that Z[12] is isomorphic to the direct product of Z[2] and Z[6]? Explain your answer.
;[s]
2:0,1;3,0;134,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q12. Explain, from what we have done in this lab, why the rings Z[30]/{0,15} and Z[15] are isomorphic.
;[s]
2:0,1;3,0;103,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
5.9 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; rightWrapOffset = 522]
?FormMorphoid
:[font = input; preserveAspect; rightWrapOffset = 522]
?ZMap
:[font = input; preserveAspect; rightWrapOffset = 522]
?Structure
:[font = input; preserveAspect; rightWrapOffset = 521]
?VisualizeMorphoid
:[font = input; preserveAspect; rightWrapOffset = 522]
?Ring
:[font = input; preserveAspect; rightWrapOffset = 522]
?BooleanRing
:[font = input; preserveAspect; rightWrapOffset = 522]
?PreservesQ
:[font = input; preserveAspect; rightWrapOffset = 522]
?MorphismQ
:[font = input; preserveAspect; rightWrapOffset = 522]
?Kernel
:[font = input; preserveAspect; rightWrapOffset = 522]
?Image
:[font = input; preserveAspect; rightWrapOffset = 522]
?ClosedQ
:[font = input; preserveAspect; rightWrapOffset = 522]
?QuotientRing
:[font = input; preserveAspect; rightWrapOffset = 522]
?Elements
:[font = input; preserveAspect; rightWrapOffset = 522]
?DirectProduct
:[font = input; preserveAspect; rightWrapOffset = 522]
?IsomorphismQ
:[font = input; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
?ChineseRemainderTheorem
^*)
