(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 6. Polynomial rings
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To work on this lab, you need only a cursory familiarity with Ringoids, mostly just Z[n]. 
;[s]
3:0,0;62,1;70,0;91,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to help one discover some of the basic properties of polynomial algebra over a ring, through division and the GCD function. Factorization is discussed in detail in Ring Lab 7.
;[s]
3:0,0;134,1;137,0;200,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.3 An introduction to polynomials
:[font = text; inactive; preserveAspect]
To get started, let's read in the package that provides the functionality needed for this lab.
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect]
Consider the polynomial p = x^2 + 3x - 4. This type of expression has been familiar to you for many years. You should know how to factor this, as well as how to graph y = p.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q1. How does one factor this? What does the graph of y look like? Try also to get Mathematica to do both of these tasks.
;[s]
4:0,1;2,0;82,2;93,0;121,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
With the polynomial p, we implicitly considered viewing this as having coefficients coming from the integers (or possibly real numbers). Do we need to confine our coefficients to the integers, rationals, reals or complex numbers? No.

Let R be any commutative ring. We define the ring of polynomials over R in the indeterminate x as the set of all (formal) symbols of the form
;[s]
3:0,0;280,1;329,0;377,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
anxn + an-1xn-1 +  + a2x2 + a1x + a0
;[s]
19:0,0;1,1;2,0;3,2;4,0;8,1;11,0;12,2;15,0;18,3;19,0;23,1;24,0;25,2;26,0;30,1;31,0;36,1;37,0;38,-1;
4:10,16,12,Times,0,14,0,0,0;5,21,13,Times,64,12,0,0,0;3,21,13,Times,32,12,0,0,0;1,24,16,Times,32,14,0,0,0;
:[font = text; inactive; preserveAspect]
where the coefficients ai are from the ring R and n is a nonnegative integer. We denote this ring of polynomials by R[x].

In Mathematica, we can create a ring of polynomials as follows.
;[s]
5:0,0;24,1;25,0;126,2;137,0;187,-1;
3:3,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
P = PolynomialsOver[Z[7]]
:[font = text; inactive; preserveAspect]
The ring P is the set of all polynomials whose coefficients come from Z[7].
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q2. Why don't we list all the elements? How many are there?
;[s]
2:0,1;2,0;60,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The first thing we need to think about when working with polynomials is to be able to distinguish when two elements are different or the same. Suppose we have a polynomial f(x) of the form
:[font = text; inactive; preserveAspect; center]
anxn + an-1xn-1 +  + a2x2 + a1x + a0.
;[s]
20:0,0;1,1;2,0;3,2;4,0;8,1;11,0;12,2;15,0;18,3;19,0;23,1;24,0;25,2;26,0;30,1;31,0;36,1;37,4;38,1;39,-1;
5:9,16,12,Times,0,14,0,0,0;6,21,13,Times,64,12,0,0,0;3,21,13,Times,32,12,0,0,0;1,24,16,Times,32,14,0,0,0;1,13,9,Times,0,12,0,0,0;
:[font = text; inactive; preserveAspect]
In this case, if an is not zero, we say f(x) has degree n and we call the coefficient an the leading coefficient. We will say that the two polynomials f(x) and g(x) =
;[s]
9:0,0;18,1;19,0;49,2;55,0;87,1;89,0;93,2;113,0;167,-1;
3:5,16,12,Times,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
bmxm + bm-1xm-1 +  + b2x2 + b1x + b0
;[s]
18:0,0;1,1;2,0;3,2;4,0;8,1;11,0;12,2;15,0;18,3;19,0;23,1;24,0;25,2;26,0;30,1;31,0;36,1;38,-1;
4:9,16,12,Times,0,14,0,0,0;5,21,13,Times,64,12,0,0,0;3,21,13,Times,32,12,0,0,0;1,24,16,Times,32,14,0,0,0;
:[font = text; inactive; preserveAspect]
are equal if n = m (i.e., they have the same degree) and if ai = bi for all i  n. Note that what is important in a polynomial is only the list of coefficients used; the variable (and its powers) act merely as place holders, indicating the position of the coefficients. Thus, in Mathematica, one way we create a polynomial is to simply give the function Poly a sequence of coefficients, prefixed by the ring from which the coefficients come. For example,
;[s]
9:0,0;61,1;62,0;66,1;67,0;279,2;290,0;354,3;358,0;455,-1;
4:5,16,12,Times,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[x]
p = Poly[Z[7], 6, 1, 0, 2]
:[font = text; inactive; preserveAspect]
yields the polynomial 2x^3 + x + 6. In this case, the indeterminate is denoted by x. You can specify some other indeterminate:
:[font = input; preserveAspect]
Clear[y]
p2 = Poly[Z[7], 6, 1, 0, 2, Indeterminate -> y]
:[font = text; inactive; preserveAspect]
One can also enter a polynomial directly:
:[font = input; preserveAspect]
p3 = Poly[Z[7], 2x^3 + x + 6]
:[font = text; inactive; preserveAspect]
It is important to remember to specify the ring from which the coefficients come. If this is forgotten, the expression will be returned as entered (which is a standard Mathematica means for communicating that the input is unsuitable).
;[s]
3:0,0;168,1;179,0;235,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
p4 = Poly[2x^3 + x + 6]
:[font = text; inactive; preserveAspect]
As usual, asking for information about a function is often useful.
:[font = input; preserveAspect]
?Poly
:[font = text; inactive; preserveAspect]
In particular, note that if you are accustomed to entering polynomials, as well as viewing them, the way Mathematica returns them, you will feel at home with the default setting of PowersIncrease. On the other hand, if you prefer to have the powers of the polynomial increase from right to left for both input and output, you may wish to use SetOptions and change the default on PowersIncrease. Note how this option works:
;[s]
9:0,0;105,1;116,0;181,2;195,0;342,2;352,0;379,2;393,0;423,-1;
3:5,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Poly[Z[5], 1, 2, 3]
Poly[Z[5], 1, 2, 3, PowersIncrease -> RightToLeft]
:[font = text; inactive; preserveAspect]
Note that both the input method (when just giving a sequence of coefficients) and the output display is governed by this option. Based on the method you prefer, evaluate ONE of the following two cells:
:[font = input; preserveAspect]
SetOptions[Poly, PowersIncrease -> LeftToRight]
(* output will be similar to 1 + 2x + 3x^2 *)
:[font = input; preserveAspect]
SetOptions[Poly, PowersIncrease -> RightToLeft]
(* output will be similar to 3x^2 + 2x + 1 *)
:[font = text; inactive; preserveAspect]
Consider the polynomial r as defined below:
:[font = input; preserveAspect]
r = Poly[Z[7], 7x^4 - 4x + 4x^2 + 9]
:[font = text; inactive; preserveAspect]
When the base ring is Z[n], polynomials can be entered with coefficients from the integers (positive or negative) and they will be reduced mod n. (This property can be turned off by adding the option FlexibleEntering -> False.)
;[s]
3:0,0;200,1;225,0;228,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
Finally, recall the Boolean ring over {a, b} and consider the following polynomials:
:[font = input; preserveAspect]
Clear[a, b]
R3 = BooleanRing[{a, b}]
:[font = input; preserveAspect]
s1 = Poly[R3, {b}, {a, b}, {}, {b}]
:[font = input; preserveAspect]
s2 = Poly[R3, {c}, {a, b, c}, {y}, {b}]
:[font = text; inactive; preserveAspect]
When a polynomial is constructed, the coefficients are checked for membership against the base ring; an error message is given if the polynomial is ill-formed.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q3. Construct a well-formed and an ill-formed third-degree polynomial over Z[10].
;[s]
2:0,1;2,0;82,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Let's pick a couple of random polynomials of degree 3. (Recall that P is our extension ring of polynomials over Z[7].)
:[font = input; preserveAspect]
a = RandomElement[P, 3]
b = RandomElement[P, 3]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q4. List your polynomials. You should have a reasonable guess or idea how to add these two polynomials. Do so (by hand). Also, determine their product.
;[s]
2:0,1;2,0;152,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
In the ring of polynomials, there is a built-in addition and multiplication. Let's define some Mathematica aliases for these functions in our ring of polynomials over Z[7]:
;[s]
3:0,0;95,1;106,0;173,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
add = Addition[P];
mult = Multiplication[P];
(* no output is given *)
:[font = text; inactive; preserveAspect]
Now, let's add and multiply a and b (and note that this should check your answers from above):
:[font = input; preserveAspect]
add[a, b]
mult[a, b]
:[font = text; inactive; preserveAspect]
Conventional notation works as well:
:[font = input; preserveAspect]
a + b
a b
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q5. What is the degree of the product of polynomials a and b?
;[s]
2:0,1;2,0;62,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The Degree function will determine the degree of a polynomial.
;[s]
3:0,0;4,1;10,0;63,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Degree[Poly[Z[8], 4x^2 + 7x - 2]]
:[font = input; preserveAspect]
Degree[a b]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q6. What are the constant polynomials in P? (These are the polynomials without the indeterminate x.)
;[s]
2:0,1;2,0;101,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q7. Does this ring of polynomials over Z[7] have a zero? What about a unity? If you answered yes to either, what are they?
;[s]
2:0,1;2,0;123,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q8. Can one add two polynomials of degree k and obtain a sum of a lower degree? Try the code below once or twice (or more times, if you feel it necessary) and consider the results. If this can not happen, explain why not; if it can, cite circumstances under which it can.
;[s]
2:0,1;2,0;272,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
Print["Let d(p) be the degree of the polynomial p:"];
Table[a = RandomElement[P, 2];
b = RandomElement[P, 2];
{a, b, {Degree[a], Degree[b]}, Degree[a + b]},
	{25}]//TableForm[#, TableHeadings -> 
	{None, {"polynomial a", "polynomial b", "{d(a), d(b)}", "d(a + b)\n"}},
	TableSpacing -> {0, 3}, TableDepth -> 2]&
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q9. What happens when one multiplies a polynomial of degree 3 with one of degree 2? What is the degree of the product? Try the code below once or twice (or more times, if you feel it necessary) and consider the results. Explain your conclusion.
;[s]
2:0,1;2,0;245,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
Table[a = RandomElement[P, 3];
b = RandomElement[P, 2];
{a, b, Degree[P, Multiplication[P][a, b]]},
	{20}]//TableForm[#, TableHeadings -> 
	{None, {"polynomial a","polynomial b","d(a * b)\n"}},
	TableSpacing -> {0, 3}]&
:[font = text; inactive; preserveAspect]
Since P is the ring of all polynomials over Z[7], we can ask about the Zero and Unity of this ring.
;[s]
5:0,0;71,1;75,0;80,1;85,0;100,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
{z, u} = {Zero[P], Unity[P]}
:[font = text; inactive; preserveAspect]
Of course, we need to be careful about how we interpret what we see here. If we ask if z is equal to the number 0 and if u is equal to the number 1, we get the following:
:[font = input; preserveAspect]
z === 0
u === 1
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q10. Explain these results.
;[s]
2:0,1;3,0;28,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Let's shift gears for a moment and consider polynomials over Z[6] and look at two polynomials and their product in this context.
:[font = input; preserveAspect]
P2 = PolynomialsOver[Z[6]]
a = Poly[Z[6], 3x^3 + x^2 + x + 1]
b = Poly[Z[6], 2x^2 + 5]
a b
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q11. What can you surmise from this example? Look carefully at the output. Give another example of a similar occurrence in the ring of polynomials over Z6.
;[s]
4:0,1;3,0;153,2;154,0;156,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.4 Divide and conquer
:[font = text; inactive; preserveAspect]
The main reason why arithmetic with polynomials is interesting (and so similar to integer arithmetic) is due to the division property. The division property is often referred to as the Division Algorithm in algebra texts.
:[font = text; inactive; preserveAspect]
Let's do some quick reviewing of familiar territory before looking at general polynomial rings.
:[font = text; inactive; preserveAspect]
When we divide 159 by 13, we seek to find the number of times we can multiply 13 and still remain less than 159. Or in the vernacular, "How many times does 13 go into 159?". In this case, 12 times 13 equals 156, leaving a remainder of 3:
:[font = input; preserveAspect]
159 == 13 12 + 3
:[font = text; inactive; preserveAspect]
Note that we have written 159 as the product of an integer times 13 plus a remainder whose value is less than 13.
:[font = text; inactive; preserveAspect]
Now consider the polynomials (over the integers)
:[font = input; preserveAspect]
a = x^3 + 5 x^2 - 3x + 8
b = x - 7
:[font = text; inactive; preserveAspect]
What do we get when we divide a by b? In other words, can we write a = b q + r for some polynomials q and r? 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q12. You should know how to do this by hand. Do so and report your results.
;[s]
2:0,1;3,0;76,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Mathematica has some built-in functions to find the quotient and remainder when considering polynomials over the integers (as well as some other standard rings):
;[s]
2:0,1;11,0;162,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
q = PolynomialQuotient[a, b, x]
r = PolynomialRemainder[a, b, x]
:[font = text; inactive; preserveAspect]
Do these work as we suppose?
:[font = input; preserveAspect]
a == b q + r
:[font = text; inactive; preserveAspect]
We need to do some coaxing:
:[font = input; preserveAspect]
a == Expand[b q + r]
:[font = text; inactive; preserveAspect]
To consider equivalent functionality over arbitrary rings, we need to use the functions built into the packages that were read in at the beginning. In this scenario, we use the function PolynomialDivision. Here, we define polynomials a and b in the ring of polynomials over Z[7].
;[s]
9:0,0;186,1;204,0;234,1;235,0;240,1;241,0;274,1;278,0;280,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
a = Poly[Z[7], x^4 + 5x^2 + 3x + 4]
b = Poly[Z[7], x^2 + 3x + 2]
:[font = text; inactive; preserveAspect]
Try your hand, using paper and pencil, at determining the quotient and remainder of a divided by b. Confirm your results with the following cell.
:[font = input; preserveAspect]
(* do by hand first *)
{q, r} = PolynomialDivision[a, b]
:[font = text; inactive; preserveAspect]
We can test this result by multiplying the quotient q times b, and then adding the remainder r.
:[font = input; preserveAspect]
a == b * q + r
:[font = text; inactive; preserveAspect]
Often it's only necessary to know the remainder or the quotient. The built-in functions used above also have extensions in this package.
:[font = input; preserveAspect]
?PolynomialQuotient
:[font = input; preserveAspect]
?PolynomialRemainder
:[font = input; preserveAspect]
PolynomialQuotient[a, b]
PolynomialRemainder[a, b]
:[font = text; inactive; preserveAspect]
Let's consider another example by changing b to a linear polynomial
:[font = input; preserveAspect]
a = Poly[Z[7], 4x^4 + 3x^3 + 5x^2 + 1]
b = Poly[Z[7], x - 3]
:[font = text; inactive; preserveAspect]
Note that x - 3 is the same polynomial as x + 4 in the ring of polynomials over Z[7].
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q13. Use long division to determine the quotient and remainder. Now evaluate the polynomial a at the value 3.
;[s]
2:0,1;3,0;110,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
To evaluate any polynomial, one simply substitutes in the value and computes in the ring. In this case, we reduce mod 7 as we go. Try it. One can also use the following function.
:[font = input; preserveAspect]
PolynomialEvaluation[a, 3]
:[font = text; inactive; preserveAspect]
Now compare this to the following:
:[font = input; preserveAspect]
PolynomialRemainder[a, b]
:[font = text; inactive; preserveAspect]
Why did we divide by x - 3 and evaluate at 3? See if you can see why with a couple more examples.

Let's change our b to a different linear polynomial. We divide and examine the remainder:
:[font = input; preserveAspect]
b = Poly[Z[7], x - 2]
PolynomialRemainder[a, b]
:[font = text; inactive; preserveAspect]
Also, evaluate a when x is given the value 2.
:[font = input; preserveAspect]
PolynomialEvaluation[a, 2]
:[font = text; inactive; preserveAspect]
And again, one more time, over a different ring.
:[font = input; preserveAspect]
a = Poly[Z[13], 4x^4 + 3x^3 + 5x^2 + 1]
b = Poly[Z[13], x + 5]
PolynomialEvaluation[a, 8]
PolynomialRemainder[a, b]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q14. Can you make a conjecture based on the examples above? You may wish to try some other linear polynomials. Note that you need to determine where to evaluate the polynomial and this depends on the linear polynomial. What is this relationship? 
;[s]
2:0,1;3,0;247,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q15. Suppose that a = f(x) and b = x - k. Based on your answer to the previous question, what can you say about the remainder r when we have f(k) = 0? (Consider the example below, if you wish.)
;[s]
2:0,1;3,0;194,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
a = Poly[Z[7], x^4 + 2x^3 + 2x^2 + 1]
b = Poly[Z[7], x - 3]
PolynomialEvaluation[a, 3]
PolynomialRemainder[a, b]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q16. In all the examples we have encountered, what is the relationship between the degree of the remainder r and the degree of the divisor b?
;[s]
2:0,1;3,0;142,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Now let's fix a polynomial and consider the zeros of the polynomial over various rings Z[n]. By a zero, we mean a value such that the polynomial evaluates to the zero of the base ring (which, in Z[n], is 0). For example, consider the polynomial x^2 + 3x + 2.
:[font = input; preserveAspect]
p = x^2 + 3x + 2
:[font = text; inactive; preserveAspect]
Consider finding the zeros for this polynomial over Z[15], Z[17] and Z[37].
:[font = input; preserveAspect]
Zeros[Poly[Z[15], p]]
Zeros[Poly[Z[17], p]]
Zeros[Poly[Z[37], p]]
:[font = text; inactive; preserveAspect]
Suppose we consider all Z[k] for k = 2 to k = 11:
:[font = input; preserveAspect]
TableForm[Table[{k, Zeros[Poly[Z[k], x^2 + 3x + 2]]}, {k, 2, 11}],
	TableHeadings -> {None, {"k", "zeros over Z[k]\n"}},
	TableDepth -> 2, TableSpacing -> {0, 3}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q17. While several indices k resulted in 4 zeros, most resulted in 2. For those that yielded only 2, is there anything significant about the two zeros? What is the explanation for this?
;[s]
2:0,1;3,0;186,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Note that finding zeros is a special case of solving an equation set equal to zero:
:[font = input; preserveAspect]
Solve[Poly[Z[11], x^2 + 3x + 2] == 0]
:[font = text; inactive; preserveAspect]
Of course, we can also solve equations involving other constants:
:[font = input; preserveAspect]
solns = Solve[Poly[Z[11], x^2 + 3x + 2] == 1]
:[font = text; inactive; preserveAspect]
We can also verify the solutions. (Recall that x + 3 /. {x -> 5} results in 8.)
;[s]
3:0,0;47,1;64,0;80,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
x + 3 /. {x -> 5}
:[font = input; preserveAspect]
Poly[Z[11], x^2 + 3x + 2] /. solns
:[font = text; inactive; preserveAspect]
Let's try another polynomial:
:[font = input; preserveAspect]
TableForm[Table[{k, Zeros[Poly[Z[k], 3x^3 + x^2 + 3x + 2]]}, {k, 2, 11}],
	TableHeadings -> {None, {"k", "zeros over Z[k]\n"}},
	TableDepth -> 2, TableSpacing -> {0, 3}]

(* an empty list indicates no zeros *)
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q18. By modifying the code above, try another polynomial and/or other rings to see if you can determine a relationship between the (maximum) number of zeros and the index k of the ring Z[k] under consideration.
;[s]
2:0,1;3,0;211,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
6.4.1 The Euclidean Algorithm
:[font = text; inactive; preserveAspect]
The greatest common divisor of two polynomials, a and b, b not zero, can be determined using the fact that if r is the result of PolynomialRemainder[a, b] then gcd(a, b) = gcd(b, r). This is a polynomial extension of what you have already seen with integers. In other words, if a = 24 and b = 40, we know that gcd(a, b) = 8. Below is how we use Mod, which is the integer equivalent to PolynomialRemainder, to implement the Euclidean Algorithm. First, define a and b.
;[s]
7:0,0;129,1;154,0;345,1;348,0;385,1;404,0;467,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
a = 40
b = 24
:[font = text; inactive; preserveAspect]
Calculate the new values for a and b. Let the new a become the old b and the new b become the remainder upon dividing a by b (Mod[a, b]). Now call these values a and b again.
;[s]
3:0,0;126,1;135,0;175,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
newa = b
newb = Mod[a, b]
{a, b} = {newa, newb}
:[font = text; inactive; preserveAspect]
Repeat.
:[font = input; preserveAspect]
newa = b
newb = Mod[a, b]
{a, b} = {newa, newb}
:[font = text; inactive; preserveAspect]
Repeat.
:[font = input; preserveAspect]
newa = b
newb = Mod[a, b]
{a, b} = {newa, newb}
:[font = text; inactive; preserveAspect]
You are done when the remainder (newb) becomes 0; the gcd is then the last nonzero remainder (b).
;[s]
3:0,0;33,1;37,0;98,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q19. Employ this algorithm by verifying that the gcd of 21 and 13 is 1.
;[s]
2:0,1;3,0;72,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q20. Employ the Euclidean Algorithm for polynomials to determine the gcd of the polynomials x^4 + 2x^3 + 2x^2 + 2 and x^4 + 3x^3 + 3x^2 + 3x + 2, both over Z[5]; see below.
;[s]
2:0,1;3,0;173,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
a = Poly[Z[5], x^4 + 2x^3 + 2x^2 + 2]
b = Poly[Z[5], x^4 + 3x^3 + 3x^2 + 3x + 2]
:[font = text; inactive; preserveAspect]
You might find this cell handy:
:[font = input; preserveAspect; endGroup]
newa = b
newb = PolynomialRemainder[a, b]
{a, b} = {newa, newb}
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
6.4.2 Another approach
:[font = text; inactive; preserveAspect]
Algorithms are great things to instruct computers to do. The Euclidean Algorithm has been implemented in the function PolynomialGCD:
;[s]
3:0,0;118,1;131,0;133,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup; endGroup]
PolynomialGCD[a, b]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
6.5 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect]
?PolynomialsOver
:[font = input; preserveAspect]
?Poly
:[font = input; preserveAspect]
?Indeterminate
:[font = input; preserveAspect]
?PowersIncrease
:[font = input; preserveAspect]
?LeftToRight
:[font = input; preserveAspect]
?Equal
:[font = input; preserveAspect]
?BooleanRing
:[font = input; preserveAspect]
?RandomElement
:[font = input; preserveAspect]
?Addition
:[font = input; preserveAspect]
?Multiplication
:[font = input; preserveAspect]
?Degree
:[font = input; preserveAspect]
?Zero
:[font = input; preserveAspect]
?Unity
:[font = input; preserveAspect]
?PolynomialQuotient
:[font = input; preserveAspect]
?PolynomialRemainder
:[font = input; preserveAspect]
?PolynomialDivision
:[font = input; preserveAspect]
?PolynomialEvaluation
:[font = input; preserveAspect]
?Zeros
:[font = input; preserveAspect]
?Solve
:[font = input; preserveAspect; endGroup; endGroup]
?PolynomialGCD
^*)
