(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect; fontColorBlue = 0]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
Ring Lab 8. Roots of unity
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
8.1 Prerequisites
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
No other lab needs to be completed before attempting this lab. However, experience with cyclic groups (see Group Lab 6) may prove beneficial.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
8.2 Goals for this lab
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
The main goal of this lab is to become familiar with the roots of unity, the roots of polynomials of the form x^n - 1.
;[s]
3:0,0;57,1;71,0;119,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
8.3 An introduction
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
This whole lab will focus on the polynomial x^n - 1 (for a positive integer n) or factors thereof. This is a fairly simple polynomial. For n = 2 and n = 3, you first saw these in first-year algebra.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q1. Quick! Do you remember how to factor x^3 - 1 (over Q)? How is it done?
;[s]
2:0,1;2,0;75,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since we will employ Mathematica for higher powers, let's get it started here to check your answer.
;[s]
3:0,0;21,1;32,0;100,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[x]
Factor[x^3 - 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Was your answer correct? What about other values of n? Let's make a table.
:[font = input; preserveAspect; rightWrapOffset = 522]
TableForm[Table[Factor[x^n - 1], {n, 1, 17}],
	TableSpacing -> {0, 0}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q2. What observations can you make from this table?
;[s]
2:0,1;2,0;52,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q3. Modify the Table command above to get a listing of values from 18 to some higher value. Do your observations still hold? Do you have any new ones or modifications?
;[s]
4:0,1;2,0;15,2;20,0;168,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's look at x^ 63 - 1 and consider some questions regarding it.
:[font = input; preserveAspect; rightWrapOffset = 522]
Factor[x^63 - 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
What things might be of interest? Consider the following list, for starters. 

1. How many factors are there? 
2. What coefficients are used? 
3. What is the highest degree of any factor?
4. What is the list of all the degrees that occur among the factors?

The Factor command easily factors this polynomial, but what is returned is just the product of all the factors with no way of accessing the pieces of the factorization. The function FactorList gives us a list of the factors, so we can access the them:
;[s]
7:0,0;262,1;268,0;440,1;450,0;462,2;466,0;510,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorList[x^63 - 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Note that this returns pairs of the form {g(x), m} where f(x) is a factor of the polynomial and m is an integer. This integer represents the multiplicity of the factor. This is just a fancy term for expressing how many times a factor occurs in the factorization. For an example, the following should illustrate the concept of multiplicity.
;[s]
3:0,0;141,1;153,0;340,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorList[Expand[(x-3)^4 (x+1) (x+2)^3 x^8]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's look at this using MatrixForm.
;[s]
3:0,0;25,1;35,0;37,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorList[Expand[(x-3)^4 (x+1) (x+2)^3 x^8]]//MatrixForm
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
To get at just the factors, we need to transpose the list so that the factors are in the first row rather than the first column. We can then ask for the first row. Here is our result for the polynomial x^63 - 1:
:[font = input; preserveAspect; rightWrapOffset = 522]
factors = First[Transpose[FactorList[x^63 - 1]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now we can pursue some of the questions mentioned above. One of the questions was to count the number of factors. For x^63 - 1, of course, we can simply step through and count, but we want to look for a way of doing this in Mathematica. What we really want to know is how many elements there are in the list factors, which can be measured by the Length function.
;[s]
7:0,0;224,1;235,0;308,2;315,0;346,2;352,0;363,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Length[factors]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Another question related to the coefficients. The function CoefficientList does exactly what we want.
;[s]
3:0,0;59,1;74,0;102,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
CoefficientList[factors, x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
It may of interest to remove any duplicates and not distinguish from which factor the values were obtained. The Flatten function puts these all into one list.
;[s]
3:0,0;112,1;119,0;159,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Flatten[CoefficientList[factors, x]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now, we will use the Union function which will sort them and remove any duplicates.
;[s]
3:0,0;21,1;26,0;84,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Union[Flatten[CoefficientList[factors, x]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The next two questions deal with the degree of the factors, namely what is the highest degree of all the factors and what is the degree of each factor. The latter can be easily answered with the Exponent function.
;[s]
3:0,0;195,1;203,0;214,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Exponent[factors, x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Once we have this list, it is easy to find the maximum by applying the Max function.
;[s]
3:0,0;71,1;74,0;85,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Exponent[factors, x]//Max
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's put all of these steps into one function:
:[font = input; preserveAspect; rightWrapOffset = 522]
PolyInfo[x^n_Integer?Positive - 1] := PolyInfo[x^n - 1] = 
	Module[{factors,exps},
factors = First[Transpose[FactorList[x^n - 1]]];
exps = Exponent[factors,x];
{n, 
Length[factors],
Union[Flatten[CoefficientList[factors,x]]],
Max[exps],
Union[exps]}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Here is a test of this function.
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorList[x^12 - 1]
:[font = input; preserveAspect; rightWrapOffset = 522]
PolyInfo[x^12 - 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Note that the information is in the form {n, # factors, coefficients used, highest degree, all degrees}. Here is a table showing some results.
:[font = input; preserveAspect; rightWrapOffset = 522]
TableForm[Table[PolyInfo[x^n - 1], {n, 2, 37}], TableDepth -> 2,
	TableSpacing -> {0, 2}, TableHeadings -> {None, {"n", 
	"#fac", "coefs", "max deg", "degrees\n"}}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q4. In question 2, you were asked what observations you could make from what you had seen? Do you have any additions, corrections, or comments? Make some conjectures. 
;[s]
2:0,1;2,0;168,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q5. Change the range of values for n in the Table command to test your conjectures with more data. In particular, make sure you test your conjectures with values of n that exceed 100 (examples to consider might be n = 210 or n = 165). (Hint: if testing n = 210, do not test from n = 2 to n = 210, but use a smaller range, centered at 210.)
;[s]
4:0,1;2,0;44,2;49,0;340,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q6. What is the relationship between n and the number of factors of x^n - 1?
;[s]
2:0,1;2,0;77,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q7. What is the relationship between the degrees of the factors and the highest degree among the factors?
;[s]
2:0,1;2,0;106,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q8. What conclusion(s) can you make about the highest degree of a factor of x^n - 1 and n?
;[s]
2:0,1;2,0;91,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
8.4 A closer look -- graphically
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
For the moment, we focus on x^6 - 1.
:[font = input; preserveAspect; rightWrapOffset = 522]
factors = First[Transpose[FactorList[x^6 - 1]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
As we have seen, zeros are intimately related to factors. The first two factors have the zeros 1 and -1 associated with them. What about the last two factors? What are the zeros? Let's check out the second quadratic factor (the fourth factor in the list) by using the Solve command.
;[s]
3:0,0;268,1;273,0;283,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
solns = Solve[factors[[4]] == 0]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
These are complex zeros. What are the real and imaginary parts of these zeros?
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[{Re[#], Im[#]}&, x /. solns]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q9. These numbers, in pairs, should look familiar. To what are they related or where have you seen them before? Find the zeros for the third factor and find the real and imaginary parts as above. 
;[s]
2:0,1;2,0;197,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q10. Look again at the factorization of x^6 - 1. The first two factors (together) yielded 2 zeros and the last two factors had two zeros each, yielding a total of 6 zeros. Graph (not necessarily with Mathematica) these six zeros in the complex plane, using the vertical axis as the imaginary axis and the horizontal for the real axis. In other words, the complex number a + bi is to be mapped to the point (a, b) in the plane. Can you give a precise description of the resulting graph?
;[s]
4:0,1;3,0;200,2;211,0;486,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Perhaps it may be worth looking at the zeros of other polynomials. Here we use the Solve command on several others.
;[s]
3:0,0;83,1;88,0;116,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Solve[x^8 - 1 == 0]
Solve[x^10 - 1 == 0]
Solve[x^16 - 1 == 0]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since the exact answers may not be so informative, let's use NSolve instead, resulting in approximate decimal answers.
;[s]
3:0,0;61,1;67,0;119,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
NSolve[x^8 - 1 == 0]
NSolve[x^10 - 1 == 0]
NSolve[x^16 - 1 == 0]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's plot the zeros of this last equation. First, we need our list of zeros.
:[font = input; preserveAspect; rightWrapOffset = 522]
zeros = x /. NSolve[x^16 - 1 == 0]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Next, we need to convert each zero to its real and imaginary part and make them Mathematica graphics-type points. Finally, we graph them. Do not concern yourself with the Mathematica details.
;[s]
5:0,0;80,1;91,0;171,1;182,0;192,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Show[Graphics[{RGBColor[0, 0, 1], PointSize[0.025],
	Map[Point[{Re[#], Im[#]}]&, zeros]}], Axes -> True,
	AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
This sure looks beautiful! Note, however, that this graph has not considered the individual factors in the factorization of the polynomial x^16 - 1:
;[s]
3:0,0;62,1;65,0;149,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorList[x^16 - 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
How do the zeros plotted above relate to the individual factors just given? What we would like to do is find the zeros for each factor and then plot these so that we can discriminate them from each other. We need to slightly modify the code used above. We will write a function that can take any positive integer n as input and output a graph of the zeros of the nth roots of unity, colored by factor. (Again, don't concern yourself with the Mathematica details.)
;[s]
5:0,0;123,1;127,0;442,1;453,0;464,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
RootsOfUnityZeros[n_Integer?Positive] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.2, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors, {p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[Map[Flatten,sizedpts]], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n]]]
(* no output - just a definition *)
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's try this on a few examples. Depending on the memory of your Mathematica Front End, you may want to expand or narrow the range of values in the following loop by adjusting the values of lowk and highk. (Note: you may wish to delete all previous graphics cells before continuing, if you are getting low on memory.)
;[s]
7:0,0;66,1;77,0;191,2;195,0;200,2;205,0;319,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
lowk = 4;
highk = 11;
Do[RootsOfUnityZeros[k], {k, lowk, highk}]
:[font = text; inactive; preserveAspect]
In each graph, dots of the same color come from the same factor.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q11. What observations can you make from these graphs?
;[s]
2:0,1;3,0;55,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q12. Do you see any groups (or a ring) lurking behind the scenes?
;[s]
2:0,1;3,0;66,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
When we find the roots of the polynomial x^n - 1, we are finding the solutions (zeros) to the equation x^n - 1 = 0 or, more simply, x^n = 1. In other words, we are finding all the nth roots of 1, the unity; hence, the nth roots of unity. Since 1 is always a solution, starting with 1, let's number the roots and work counter-clockwise, labeling the first with 0. (You might ask yourself why we start counting/labeling with 0.) Below we slightly modify our code from above to reflect the numbering/counting scheme.
;[s]
3:0,0;218,1;237,0;514,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
RootsOfUnityZeros[n_Integer?Positive, powers] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.3, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors,{p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[{Map[Flatten,sizedpts],{RGBColor[0,0,1],Table[Text[i, 
	1.2{Cos[i/n 2Pi],Sin[i/n 2Pi]}],{i,0,n - 1}]}}], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now let's try it out. (Note: you again may wish to delete all previous graphics cells before continuing, if you are getting low on memory.)
:[font = input; preserveAspect; rightWrapOffset = 522]
(* adjust lowk and/or highk depending on memory *)
lowk = 4;
highk = 11;
Do[RootsOfUnityZeros[k, powers], {k, lowk, highk}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q13. You should be seeing two distinct groups. Can you name them? Do you now know why we started counting at 0?
;[s]
2:0,1;3,0;112,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Instead of simply labeling the points 0 through n-1, let's use these numbers but divide them by n, which is the number of roots (and the degree of the polynomial). Here we slightly modify the code again to reflect this change.
:[font = input; preserveAspect; rightWrapOffset = 522]
RootsOfUnityZeros[n_Integer?Positive, fractions] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.3, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors,{p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[{Map[Flatten,sizedpts],{RGBColor[0,0,1],
	Table[Text[InputForm[i/n], 
	1.2{Cos[i/n 2Pi],Sin[i/n 2Pi]}],{i,0,n - 1}]}}], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's try it out one more time. (Note: you again may wish to delete all previous graphics cells before continuing, if you are getting low on memory.)
:[font = input; preserveAspect; rightWrapOffset = 522]
(* adjust lowk and/or highk depending on memory *)
lowk = 4;
highk = 11;
Do[RootsOfUnityZeros[k, fractions], {k, lowk, highk}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q14. Can you find any connections between the fractions used and the colors of the dots to which they correspond? (You may wish to try another range of values.)
;[s]
2:0,1;3,0;161,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
8.5 Another look -- algebraically
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Above we used the function FactorList, but often had to manipulate it to get just the list of factors. Since we wish to do this often, let's write a function to do it for us.
;[s]
3:0,0;27,1;37,0;175,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorsOfUnity[n_Integer?Positive] := 
	First[Transpose[FactorList[x^n - 1]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Here is how it works.
:[font = input; preserveAspect; rightWrapOffset = 522]
FactorsOfUnity[4]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's try a few others:
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[FactorsOfUnity, {2, 4, 8, 16, 32}]//ColumnForm
(* here n = 2, 4, 8, 16, 32 *)
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[FactorsOfUnity, {3, 6, 18, 36}]//ColumnForm
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[FactorsOfUnity, {5, 20}]//ColumnForm
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[FactorsOfUnity, {14, 28}]//ColumnForm
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[FactorsOfUnity, {3, 6, 12, 24}]//ColumnForm
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q15. Look at the relationship(s) between the numbers which FactorsOfUnity is acting on and the results of the factorizations given. What conjectures or conclusions can you make? Can you give any explanations for these conclusions?
;[s]
4:0,1;3,0;59,2;73,0;231,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; endGroup]
Note: some of the ideas for this lab came from chapter 17 of Exploring Mathematics with Mathematica by Theodore W. Gray and Jerry Glynn.
;[s]
3:0,0;61,1;100,0;137,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
8.6 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; rightWrapOffset = 522]
?Factor
:[font = input; preserveAspect; rightWrapOffset = 522]
?Table
:[font = input; preserveAspect; rightWrapOffset = 522]
?FactorList
:[font = input; preserveAspect; rightWrapOffset = 522]
?Length
:[font = input; preserveAspect; rightWrapOffset = 522]
?CoefficientList
:[font = input; preserveAspect; rightWrapOffset = 522]
?Flatten
:[font = input; preserveAspect; rightWrapOffset = 522]
?Union
:[font = input; preserveAspect; rightWrapOffset = 522]
?Exponent
:[font = input; preserveAspect; rightWrapOffset = 522]
?Solve
:[font = input; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
?NSolve
^*)
