(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O431, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O433,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; fontColorBlue = 0]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
Ring Lab 9. Cyclotomic polynomials
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
9.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.1 Prerequisites
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Before working on this lab, you should have completed Ring Lab 8, on roots of unity.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.2 Goals for this lab
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
The goal for this lab is to formulate recursive and non-recursive definitions of the cyclotomic polynomials and discover some of the properties of these polynomials. 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.3 An introduction
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Recall that in Ring Lab 8 we focused on the polynomial x^n - 1 (for a positive integer n). Here, we will continue to have this (or more accurately, factors of it) be our focus.

First, let's remind ourselves what the factorizations of these polynomials look like.
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[x]
Table[{n, Factor[x^n - 1]}, {n, 1, 11}]//TableForm
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We also redefine two functions that we created in the last lab:
:[font = input; preserveAspect; rightWrapOffset = 522]
RootsOfUnityZeros[n_Integer?Positive, fractions,opts___?OptionQ] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.3, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors,{p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[{Map[Flatten,sizedpts],{RGBColor[0,0,1],
	Table[Text[InputForm[i/n], 
	1.2{Cos[i/n 2Pi],Sin[i/n 2Pi]}],{i,0,n - 1}]}}], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n],opts]]
	
UnityFactors[n_Integer?Positive] := 
	First[Transpose[FactorList[x^n - 1]]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Also, we remind ourselves of how the zeros of these polynomials are distributed:
:[font = input; preserveAspect; rightWrapOffset = 522]
Do[RootsOfUnityZeros[k, fractions], {k, 2, 11}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Our goal is to consider what is called a cyclotomic polynomial. For each positive integer n, there is a polynomial Fn(x) called the nth cyclotomic polynomial. (Often the polynomial is denoted not with a capital F but a capital Phi.)
;[s]
3:0,0;116,1;117,0;233,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since cyclotomic polynomials are quite important, there is a built-in function for them in Mathematica. Here are the fifth and sixth cyclotomic polynomials:
;[s]
3:0,0;91,1;102,0;157,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
{Cyclotomic[5, x], Cyclotomic[6, x]}
(* x simply indicates with what indeterminate to express
the polynomial *)
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The cyclotomic polynomials are related to the roots of unity. We were reminded above that these numbers are all on the unit circle. (Note that cyclo refers to a circle and tomic indicates a cutting.) The nth roots of unity take the form u(n, k) = cos(2 k/n) + i sin(2 k/n) = e^(2 i  k/n), where k = 0, 1, 2, ..., n-1. 

If you have ever browsed through The Mathematica Book, you may have stumbled across the description of the cyclotomic polynomials. The description is that the nth cyclotomic polynomial in x is the product of all linear factors of the form x - u(n, k) for which k is relatively prime to n (i.e., GCD[n, k] = 1). These are the factors corresponding to the so-called "primitive nth roots of unity" that are labeled red in the graphs above.
;[s]
9:0,0;143,1;148,0;172,1;178,0;355,1;376,0;618,2;631,0;760,-1;
3:5,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
u[n_, k_] := Cos[2Pi k/n] + I Sin[2Pi k/n]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
For example, there are two primitive 6th roots of unity, u(6, 1) and u(6, 5).
:[font = input; preserveAspect; rightWrapOffset = 522]
{Expand[(x - u[6, 1]) (x - u[6, 5])], Cyclotomic[6, x]}
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q1. (a) Determine F8(x), the 8th cyclotomic polynomial in x, by expanding the proper linear factors.

(b) Without generating F128(x) itself, determine its degree. 
;[s]
6:0,1;2,0;19,2;20,0;126,2;129,0;164,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Our goal at this point is to develop an alternate way of building the cyclotomic polynomials without using the complex numbers. We will be asking you to look at many patterns to see if you can come up with this alternate definition. First, let's compare x^n - 1 and the nth cyclotomic polynomial in tandem. Note that the output consists of n, then the factorization of x^n - 1, followed by Cyclotomic[n, x].
;[s]
3:0,0;390,1;406,0;408,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{{n, Factor[x^n - 1], Cyclotomic[n, x],
	"--------------------------"}}, {n, 1, 11}]//TableForm
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q2. At least one observation regarding the relationship between Fn(x) and the factorization of x^n - 1 should be obvious. What is it?
;[s]
4:0,1;2,0;65,2;66,0;134,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q3. Suppose that n is a prime number. How can you formulate Fn(x) in terms of x^n - 1?
;[s]
4:0,1;2,0;61,2;62,0;87,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
In the last question, you should have found a method of formulating Fn(x) in terms of x^n - 1, when n is prime. What if n is composite? Note: we simply define F1(x) to be x - 1, just as we define 0! to be 1.) Let's extend our table and make some more comparisons.
;[s]
9:0,0;69,1;70,0;152,3;158,0;160,2;161,0;189,3;195,0;264,-1;
4:5,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,21,13,Times,64,12,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{{n, Factor[x^n - 1], Cyclotomic[n, x],
	"--------------------------"}}, {n, 12, 30}]//TableForm
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
It appears as if Cyclotomic[n, x] is a factor of x^n - 1. Recall from the last lab that UnityFactors gave just the list of factors of the polynomial x^n - 1. Let's test some random indices and see if Cyclotomic[n, x] really is a factor of x^n - 1. (We use MemberQ to see if Cyclotomic[n, x] belongs to the list of factors of x^n - 1.)
;[s]
11:0,0;17,1;33,0;88,1;100,0;200,1;216,0;256,1;263,0;274,1;290,0;335,-1;
2:6,16,12,Times,0,14,0,0,0;5,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
n = Random[Integer, {31, 120}]
MemberQ[UnityFactors[n], Cyclotomic[n, x]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We should perhaps try this a number of times.
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{n = Random[Integer,{31, 120}],
	MemberQ[UnityFactors[n], Cyclotomic[n, x]]}, {20}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
One more time with other values of n.
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{n = Random[Integer, {121, 180}],
	MemberQ[UnityFactors[n], Cyclotomic[n, x]]}, {15}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
This is not a proof, but the evidence seems quite indicative that Fn(x) divides x^n - 1. Let's assume that this is the case and that there exists some function (depending on n), gn(x), such that Fn(x) gn(x) = x^n - 1. We already know that gn(x) = x - 1 when n is prime. What about when n is composite?
;[s]
11:0,0;67,1;68,0;179,1;180,0;196,1;197,0;202,1;203,0;240,1;241,0;302,-1;
2:6,16,12,Times,0,14,0,0,0;5,24,16,Times,64,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q4. Although premature for any definitive solution, do you have any thoughts on the nature of gn(x) for composite n?
;[s]
4:0,1;2,0;95,2;96,0;117,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.4 The search for gn(x)
;[s]
3:0,0;20,1;21,0;25,-1;
2:2,19,14,Times,1,18,0,0,0;1,31,20,Times,65,18,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since we are assuming that we have Fn(x) gn(x) = x^n - 1, perhaps we should solve for gn(x) and explore the quotient of the two pieces we can calculate. (Note, of course, that Mathematica knows Fn(x), but we do not, yet.) Let's consider this with n = 6.
;[s]
11:0,0;36,1;37,0;42,1;43,0;87,1;88,0;176,2;187,0;195,1;196,0;254,-1;
3:6,16,12,Times,0,14,0,0,0;4,24,16,Times,64,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Simplify[(x^6 - 1)/Cyclotomic[6, x]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We want to factor this, so we can know what the pieces look like.
:[font = input; preserveAspect; rightWrapOffset = 522]
Factor[%]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We should define a function to do all of these steps at once and then try it out.
:[font = input; preserveAspect; rightWrapOffset = 522]
gFunction[n_] := 
	Factor[Simplify[(x^n - 1)/Cyclotomic[n, x]]]
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{n, gFunction[n]}, {n, 1, 14}]//TableForm
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
This may not be so revealing. Perhaps we should also add the nth cyclotomic polynomial to the table. Study the following results and look for patterns.
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{{n, gFunction[n], Cyclotomic[n, x],
	"--------------------------"}}, {n, 1, 14}]//TableForm
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Extend the table, if you wish, by looking at six more cases (in conjunction with the previous ones).
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{{n, gFunction[n], Cyclotomic[n, x],
	"--------------------------"}}, {n, 15, 20}]//TableForm
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q5. What is the nature of gn(x) for composite n? For a hint, given an index n, consider the (proper) divisors d of n and the corresponding collection of Fd(x). Can these be used to construct gn(x)? Look carefully at the first 15 examples and apply the hint and see what you can come up with.
;[s]
8:0,1;2,0;27,2;28,0;154,2;155,0;192,2;193,0;292,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q6. Now we want to give a recursive definition for Fn(x). In other words, you should be able to write Fn(x) = RHS, where the RHS depends on Fk(x) for one or more values of k that are less than n.
;[s]
8:0,1;2,0;52,2;53,0;103,2;104,0;141,2;142,0;196,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5 Some properties of Fn(x)
;[s]
3:0,0;24,1;25,0;29,-1;
2:2,19,14,Times,1,18,0,0,0;1,31,20,Times,65,18,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We now consider some properties of the cyclotomic polynomials. First, we remind ourselves of some of these polynomials and precede each with its degree.
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{{n, Exponent[p = Cyclotomic[n, x], x], p,
	"----------------------"}}, {n, 2, 15}]//TableForm
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.1 Each cyclotomic polynomial is monic
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q7. Based on what you know about the function Fn(x), why is the nth cyclotomic polynomial monic? (Recall that monic means that the leading coefficient, the one associated with the term of highest degree, has the value of 1.)
;[s]
6:0,1;2,0;47,2;48,0;110,3;115,0;225,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.2 The degrees of the cyclotomic polynomials
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q8. Compare the index n of the function Fn(x) with its degree. You should be able to see an interesting relationship and be able to express the degree of Fn(x) as a "nice" function of n. What is it?
;[s]
6:0,1;2,0;41,2;42,0;155,2;156,0;199,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.3 The irreducibility of the cyclotomic polynomial
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
In a previous lab, we explored the notion of irreducibility. Which, if any, of the cyclotomic polynomials are irreducible over the rationals? Try the following to factor a random cyclotomic polynomial.
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{n = Random[Integer, {2, 50}],
	Factor[Cyclotomic[n, x]]}, {10}]//TableForm
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q9. Repeat and/or modify the range of the random index until you are ready to make a conjecture regarding when (i.e., for what n) Fn(x) is irreducible over the rationals.
;[s]
4:0,1;2,0;131,2;132,0;171,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's choose a prime, say 29, and consider Fn(x) for n = 29. We will call the polynomial h for this example.
;[s]
3:0,0;44,1;45,0;109,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[h]
h[x_] = Cyclotomic[29, x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now consider h(x + 1).
:[font = input; preserveAspect; rightWrapOffset = 522]
h[x + 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Of course we knew that we wanted this polynomial expanded, but we need to tell Mathematica explicitly to do so.
;[s]
5:0,0;10,1;13,0;79,1;90,0;112,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Expand[%]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now examine the coefficients more closely.
:[font = input; preserveAspect; rightWrapOffset = 522]
coeffs = CoefficientList[%, x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since h(x) is monic, so is h(x + 1). Therefore the leading coefficient is 1. Is there any significance to the rest of the coefficients. Suppose we ignore the last (ie., leading) coefficient and ask for the greatest common divisor of the balance.
:[font = input; preserveAspect; rightWrapOffset = 522]
Apply[GCD, Drop[coeffs, -1]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
This says that 29 divides each of the coefficients, except the leading one. Note further that 29^2 does not divide the constant term, 29. We can now use Eisenstein's Criterion to conclude that the polynomial h(x + 1) is irreducible over the rationals. Consequently, the polynomial h(x) is also irreducible over the rationals. This illustrates that a cyclotomic polynomial with prime index is irreducible. It is also true for composite indices, but the proof requires some understanding of extension fields. (See Ring Lab 11 for an introduction to quadratic extension fields.)
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.4 Graphs of roots of the cyclotomic polynomial
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
As we saw in the previous section, the cyclotomic polynomial is irreducible over the rationals. It is, of course, reducible over the complex numbers. In fact, we saw this in the last lab. As was pointed out earlier, the zeros of the nth cyclotomic polynomial are a subset of the whole set of nth roots of unity.

Let's remind ourselves what these roots look like. The roots of the cyclotomic polynomial are the red ones plotted in the complex plane. (You may wish to delete previous graphics cells to release memory.)
:[font = input; preserveAspect; rightWrapOffset = 522]
Do[RootsOfUnityZeros[k, fractions], {k, 5, 20, 3}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q10. The zeros of the cyclotomic polynomials (the red dots) are labeled with fractions of the form k/n for certain values of k. What are the k values? How do they relate to n? You may wish to modify the cell above to see more examples.
;[s]
2:0,1;3,0;236,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q11. In each of the graphs above, the full collection of zeros forms a group under multiplication. To what group is this naturally isomorphic? What is the relationship between the zeros of the cyclotomic polynomials and this group?
;[s]
2:0,1;3,0;232,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
As a noted earlier, the roots of the nth cyclotomic polynomial are often called the primitive nth roots of unity. Can you imagine why?
;[s]
3:0,0;84,1;114,0;135,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.5 Fn(x) and F2n(x) for odd n
;[s]
5:0,0;7,1;8,0;17,2;19,0;33,-1;
3:3,16,12,Times,1,14,0,0,0;1,24,16,Times,65,14,0,0,0;1,21,13,Times,65,12,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Here we wish to look for a relationship, if any, between Fn(x) and F2n(x). First we look at a table listing some pairs.
;[s]
5:0,0;58,1;59,0;68,2;70,0;120,-1;
3:3,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{{k, Cyclotomic[k, x], 2k, Cyclotomic[2k, x],
	"-----------------------------", " "}}, 
	{k, 3, 13, 2}]//TableForm
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
You may wish to expand this table to encompass other values. A plot of an example might also be revealing. You may wish to modify your value of n to see other plots. Fn is plotted in red and F2n in blue.
;[s]
5:0,0;167,1;168,0;192,1;194,0;204,-1;
2:3,16,12,Times,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
n = 9;
Plot[Evaluate[{Cyclotomic[n, x], Cyclotomic[2n, x]}], {x, -2, 2},
	PlotStyle -> {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}];
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Note that this plot reveals that there are no real zeros (at least in the domain shown). We can still, however, compare the complex zeros. You may need to enlarge the output below to view it. 
:[font = input; preserveAspect; rightWrapOffset = 522]
n = 11;
gr1 = RootsOfUnityZeros[11, fractions, DisplayFunction -> Identity];
gr2 = RootsOfUnityZeros[22, fractions, DisplayFunction -> Identity];
Show[GraphicsArray[{gr1, gr2}]];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q12. What conclusion(s), if any, can you make about how Fn(x) and F2n(x) are related?
;[s]
6:0,1;3,0;57,2;58,0;67,3;69,0;86,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.6 Fp(x) and Fp^k(x) for prime p
;[s]
5:0,0;7,1;8,0;17,2;20,0;36,-1;
3:3,16,12,Times,1,14,0,0,0;1,24,16,Times,65,14,0,0,0;1,21,13,Times,65,12,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Suppose p is a prime and k is an integer with k  1. We wish to compare Fp(x) and Fp^k(x) for various primes p. Below we make a table consisting of a 5-tuple {p, k, p^k, Fp(x), Fp^k(x)} where p runs through the first 6 primes and k is a random integer between 2 and 4. Study the results.
;[s]
9:0,0;73,1;74,0;83,1;86,0;171,1;172,0;178,1;181,0;288,-1;
2:5,16,12,Times,0,14,0,0,0;4,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[k = Random[Integer, {2, 4}];
	{{p = Prime[n], k, p^k, Cyclotomic[p, x], Cyclotomic[p^k, x], 
	"----------------------"}}, {n, 1, 6}]//TableForm
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q13. Since k is generated randomly, you may wish to evaluate the above cell again if it is not clear what relationship is being expressed. Determine how you can express Fp^k(x) in terms of the pth cyclotomic polynomial, if possible.
;[s]
4:0,1;3,0;170,2;173,0;233,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.7 Fn(x) and Fm(x) where m and n have similar prime decompositions
;[s]
5:0,0;7,1;8,0;17,2;18,0;70,-1;
3:3,16,12,Times,1,14,0,0,0;1,24,16,Times,65,14,0,0,0;1,21,13,Times,65,12,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Suppose m is an integer whose prime-power decomposition is given as p1p2pk and n is an integer whose prime-power decomposition is given as (p1)e1(p2)e2(pk)ek where e1, e2,ek are the positive integral exponents belonging to primes p1 through pk. We wish to compare Fm(x) and Fn(x).

For investigative purposes, suppose m = (2)(3)(5) and n = 2a3b5c for some powers a, b, and c. Below we make a table consisting of a 4-tuple {{a, b, c}, n, Fm(x), Fn(x)} where a, b, c are random integers between 2 and 4. Study the results.
;[s]
46:0,0;69,2;70,0;71,2;72,0;74,1;75,0;142,2;143,0;144,3;145,4;146,0;148,2;149,0;150,3;151,4;152,0;155,1;156,0;157,3;158,4;159,0;167,2;168,0;171,2;172,0;175,2;176,0;234,2;235,0;245,2;246,0;268,2;269,0;278,2;279,0;344,3;345,0;346,3;347,0;348,3;349,0;441,2;442,0;448,1;449,0;524,-1;
5:22,16,12,Times,0,14,0,0,0;3,24,16,Times,64,14,0,0,0;12,21,13,Times,64,12,0,0,0;6,24,16,Times,32,14,0,0,0;3,18,12,Times,32,10,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
m = 2 3 5;
Table[{a, b, c} = Table[Random[Integer, {2, 4}], {3}]; 
n = 2^a 3^b 5^c; {{{"a = "<>ToString[a], "b = " <> ToString[b],
"c = " <> ToString[c]}, "2^" <> ToString[a] <> " 3^" <>
ToString[b] <> " 5^" <> ToString[c] <> " = " <> ToString[n],
 Cyclotomic[m, x], Cyclotomic[n, x],
"--------------------"}}, {6}]//TableForm
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q14. Since a, b, and c are generated randomly, you may wish to evaluate the above cell again if it is not clear what relationship is being expressed. What relationship is there between Fn(x) and Fm(x) for the n as obtained above and m = 30. Generalize for arbitrary m and n satisfying the hypothesis given at the beginning of this section.
;[s]
6:0,1;3,0;186,3;187,0;196,2;197,0;340,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.8 Fn(1)
;[s]
3:0,0;7,1;8,0;12,-1;
2:2,16,12,Times,1,14,0,0,0;1,24,16,Times,65,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We have seen many cyclotomic polynomials Fn(x) and even seen a few plotted, but we haven't investigated viewing them as polynomial functions and evaluating them at specific points. Here we consider Fn(1) for various values of n. Consider the table of values of Fn(1) for n generated randomly between 1 and 150. Study the results.
;[s]
7:0,0;42,1;43,0;199,2;200,0;262,2;263,0;330,-1;
3:4,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[n = Random[Integer, {1, 150}];
	{n, Cyclotomic[n, x]/. x -> 1}, {20}]//TableForm[#, 
	TableHeadings -> {None,
	{"n", "Fn(1)\n"}}, TableSpacing -> {0, 3}]&
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q15. What conclusions can you make? State this as a conjecture.
;[s]
2:0,1;3,0;64,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Evaluate the cell below.
:[font = input; preserveAspect; rightWrapOffset = 522]
Table[{n, Cyclotomic[n, x]/. x -> 1},
{n, 1, 25}]//TableForm[#, TableHeadings -> {None,
	{"n", "Fn(1)\n"}}, TableSpacing -> {0, 3}]&
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q16. Does this confirm or deny your previous conjecture? Reformulate, if necessary.
;[s]
2:0,1;3,0;84,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.9 How Fn(x) is related to the Moebius function, yielding a non-recursive definition
;[s]
3:0,0;11,1;12,0;88,-1;
2:2,16,12,Times,1,14,0,0,0;1,24,16,Times,65,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The Moebius function (often denoted with the lower-case Greek letter mu) is a number-theoretic function defined as follows: 
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 522]
mu(n) = 1, if n = 1;
mu(n) = (-1)k, if n is a product of k distinct primes;
mu(n) = 0, if p2 divides n for some prime p.
;[s]
5:0,0;33,1;34,0;91,2;92,0;121,-1;
3:3,16,12,Times,0,14,0,0,0;1,24,16,Times,32,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q17. For n = 1, 2, 3, 4, 6, and 12, calculate mu(n). (Note that these are all divisors of 12.)
;[s]
2:0,1;3,0;95,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Since the Moebius function is quite important for various parts of mathematics, it is a built-in function in Mathematica. The following table can be used to confirm your answers to the previous question.
;[s]
3:0,0;109,1;120,0;204,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Map[MoebiusMu, {1, 2, 3, 4, 6, 12}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Applying the MoebiusMu function to the divisors of an integer will prove itself useful below. In Mathematica, we can obtain the list of divisors of an integer using the Divisors function.
;[s]
7:0,0;13,2;22,0;97,1;108,0;169,2;177,0;188,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Divisors[12]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
With n = 12, what we now want to do is raise the polynomial x^(12/d) -1 to the power mu(d) for each divisor d. Below is one way of doing this.
:[font = input; preserveAspect; rightWrapOffset = 522]
n = 12;
polys = Map[(x^(n/#) - 1)^MoebiusMu[#]&, Divisors[n]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now we want to multiply these together.
:[font = input; preserveAspect; rightWrapOffset = 522]
Apply[Times, polys]
:[font = input; preserveAspect; rightWrapOffset = 522]
Simplify[%]
:[font = input; preserveAspect; rightWrapOffset = 522]
Cyclotomic[n, x]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q18. In the previous few input cells, replace the 12 with 20 and evaluate each of the cells. What is your result? Any conjectures? Try it again with another value or two.
;[s]
2:0,1;3,0;171,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q19. In a previous section we found a recursive definition for Fn(x). Now give a non-recursive definition.
;[s]
4:0,1;3,0;64,2;65,0;107,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.5.10 Disclaimer/warning
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
You are not finished! Nearly all the conclusions that you have reached in this lab were based on looking at patterns and formulating conjectures. Your next step should be to prove at least some of your conjectures. Your instructors may, no doubt, assign at least some of these proofs to you.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
9.6 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; rightWrapOffset = 522]
?Table
:[font = input; preserveAspect; rightWrapOffset = 522]
?Cyclotomic
:[font = input; preserveAspect; rightWrapOffset = 522]
?Factor
:[font = input; preserveAspect; rightWrapOffset = 522]
?Random
:[font = input; preserveAspect; rightWrapOffset = 522]
?MemberQ
:[font = input; preserveAspect; rightWrapOffset = 522]
?Simplify
:[font = input; preserveAspect; rightWrapOffset = 522]
?Exponent
:[font = input; preserveAspect; rightWrapOffset = 522]
?Expand
:[font = input; preserveAspect; rightWrapOffset = 522]
?Apply
:[font = input; preserveAspect; rightWrapOffset = 522]
?GCD
:[font = input; preserveAspect; rightWrapOffset = 522]
?Drop
:[font = input; preserveAspect; rightWrapOffset = 522]
?MoebiusMu
:[font = input; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
?Divisors
^*)
