(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 12. Factoring in Z[d]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
One should have an elementary understanding of divisors and factoring with integers. It may also be helpful to be familiar with the ring Z[d].
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 504; startGroup]
12.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to explore the notion of factoring numbers in Z[d] for various intergers d. In particular, we want to see when this factorization is unique (in some sense) and when it is not.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.3 An introduction to divisibility
:[font = text; inactive; preserveAspect]
To work on this lab we need to load the packages that define the needed functionality.
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect]
This lab will focus on a particular class of rings that are extensions of the integers. Let d be a fixed integer and consider the set {r + s d | r, s are integers}. We will denote this set by Z[d]. If d = 2, the following illustrates a subset of Z[2], when we restrict r and s to {-2, -1, ..., 3}.
:[font = input; preserveAspect]
Adjoin[Range[-2, 3], Sqrt[2]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q1. What is the result of letting d = 4? In other words, what does Z[4] look like? What about Z[9]? What about Z[16]? Can you think of any conditions on d that we may wish to impose?
;[s]
2:0,1;2,0;186,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Note that when we let d = -1, we obtain Z[-1], the Gaussian integers; this is frequently denote Z[i].
:[font = text; inactive; preserveAspect]
Throughout the rest of the lab, we assume that D is an integral domain. If r and s are two elements in D, with r nonzero, we say that r divides s (or r is a factor of s) if s = rt for some t in D. When r divides s, this is denoted r | s and we say that r is a divisor of s. Note that the units of D are those elements that are divisors of the unity of D.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q2. For each ring that is given, determine whether r | s. If yes, indicate the value of t such that s = rt.
(a) In Z, is it the case that 5 | 15?
(b) In Z, is it the case that 15 | 5? 
(c) In Z[3], is it the case that (2 + 3) | (-7 - 63)?
(d) In Z[3], is it the case that (4 - 53) | (-7 - 63)?
(e) In Z[-5], is it the case that 3 | 9?
(f) In Z[-5], is it the case that (2 + -5) | 9?
(g) In Z[-5], is it the case that (2 - -5) | 9?
(h) What is the product of 2 + -5 and 2 - -5?
(i) In Z[-5], is it the case that 3 | (2 + -5)?
;[s]
2:0,1;2,0;540,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q3. If r is a unit in D and x is any other element, what can you say about r | x? Justify your answer.
;[s]
2:0,1;2,0;103,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
When we are working with (ordinary) integers, it is fairly easy to know when r divides s. Essentially, we want to know if the quotient s/r is an integer. We can define a function DividesQ by using this approach.
;[s]
3:0,0;179,1;187,0;212,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
DividesQ[6, 18]
DividesQ[6, 16]
:[font = input; preserveAspect]
?DividesQ
:[font = text; inactive; preserveAspect]
When we work over the ring Z[d], we extend this function by adding the option Radical -> d. The following shows that 1 + 2 is a unit in Z[2].
;[s]
3:0,0;79,1;91,0;145,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
DividesQ[1 + Sqrt[2], 1, Radical -> 2]
:[font = text; inactive; preserveAspect]
This indicates that there is an element t in Z[2] such that (1 + 2) t = 1. What is t? Let's perform the division.
:[font = input; preserveAspect]
1/(1 + Sqrt[2])
:[font = input; preserveAspect]
Simplify[%]
:[font = text; inactive; preserveAspect]
Note that Simplify does not return an element in the form a + b2, so we need to turn to another function.
;[s]
3:0,0;10,1;18,0;107,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ZdDivide[1, 1 + Sqrt[2]]
:[font = text; inactive; preserveAspect; endGroup]
So we see that t is indeed an element in Z[d].
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.4 Associates, irreducibility and norms
:[font = text; inactive; preserveAspect]
We need to introduce (or review) some definitions. Given elements r and s in D, we say that they are associates if there is a unit u in D such that r = su. A nonzero element r in D is called irreducible if r is not a unit and whenever r = b c (for elements b and c in D), then b or c is a unit. (In other words, the only divisors of r are units and associates of r.)
;[s]
5:0,0;101,1;111,0;191,1;202,0;367,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q4. (a) What are the associates of 5 over the integers? 
(b) What are the associates of 5 over Z[i]? 
(c) Are 3 + 42 and 5 - 2 associates over Z[2]?
;[s]
2:0,1;2,0;152,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q5. (a) Is 5 irreducible over the integers? Why or why not?
(b) Is 6 irreducible over the integers? Why or why not?
(c) Is 5 irreducible over Z[i]? Why or why not?
;[s]
2:0,1;2,0;164,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The function ZdAssociatesQ can confirm whether a pair of numbers are associates over Z[d].
;[s]
3:0,0;13,1;26,0;92,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?ZdAssociatesQ
:[font = input; preserveAspect]
ZdAssociatesQ[2, 3 + 4 Sqrt[2], 5 - Sqrt[2]]
:[font = text; inactive; preserveAspect]
For negative d, the function ZdIrreducibleQ specifies whether an element is irreducible. (The problem is more difficult to answer for positive d.)
;[s]
3:0,0;29,1;43,0;147,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ZdIrreducibleQ[-1, 5]
:[font = text; inactive; preserveAspect]
Since 5 is not irreducible, we should be able to factor this over Z[i], the GaussianIntegers.
;[s]
3:0,0;76,1;92,0;94,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
FactorInteger[5, GaussianIntegers -> True]
:[font = text; inactive; preserveAspect]
The last idea to introduce in this section is a function called the norm function. We define the function N: Z[d] -> {nonnegative integers} by N(a + b d) = |a^2 - d b^2|. (Note: some authors prefer a slightly different definition.) In Mathematica, we use the function ZdNorm to accomplish this. Let's consider some examples over Z[5].
;[s]
7:0,0;68,2;72,0;237,2;248,0;270,1;276,0;338,-1;
3:4,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
examples = Adjoin[{-1, 0, 1, 2}, Sqrt[5]]
:[font = input; preserveAspect]
Map[{#, ZdNorm[#]}&, examples]//TableForm[#, TableHeadings -> 
	{None, {"x", "N(x)\n"}}, TableSpacing -> {0, 4}]&
:[font = text; inactive; preserveAspect]
There are four important properties about the norm function that should be observed; check your text for details concerning these.

1. N(x) = 0 if and only if x = 0,
2. N(x y) = N(x) N(y) for all x and y,
3. N(x) = 1 if and only if x is a unit, and
4. If N(x) is prime (in Z), then x is irreducible in Z[d].
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q6. In the list of examples of elements from Z[5] given above, which are units and which can be readily seen as being irreducible?
;[s]
2:0,1;2,0;132,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Consider x = 2 + 3 -6 and y = 2 - 3 -6 as elements in Z[-6]. Let's verify property 2 listed above.
:[font = input; preserveAspect]
x = 2 + 3 Sqrt[-6]
y = 2 - 3 Sqrt[-6]
ZdNorm[x y] === ZdNorm[x] ZdNorm[y]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q7. Let x = 1 + 3 -5 and y = 1 - 3 -5. Verify that property 2 is true with these values of x and y. Repeat this using x = 2 and y = 23.
;[s]
2:0,1;2,0;138,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Be careful how you read property 4; the converse is not true in general. For example, with x = 1 + 3 -5, used in the previous question, the norm of x is 46, which is composite.
:[font = input; preserveAspect]
ZdNorm[1 + 3 Sqrt[-5]]
:[font = text; inactive; preserveAspect; endGroup]
This does not imply that x is not irreducible! In fact, in a subsequent section, we will show that x is indeed irreducible.
;[s]
5:0,0;9,1;13,0;30,1;33,0;124,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.5 Units in Z[d]
:[font = text; inactive; preserveAspect]
Recall from the third property above that x is a unit if and only if N(x) = 1. Can we use this to determine the units of Z[d]? Let x = a + b d be an element in Z[d]. Then N(x) = |a^2 - d b^2|. First, let's consider the case where d < -1 and let k = -d. Then we have N(x) = a^2 + k b^2, with k > 1. Since k > 1 and we are assuming that N(x) = 1 (since we want x to be a unit), then we must have b = 0, for otherwise a^2 + k b^2 >= k > 1. Therefore, a^2 = 1, and so the only units are 1 and -1.

Let's consider a geometric argument for the same question. To be specific, suppose we consider k = 2 (i.e., d = -2). What we really are considering is whether there are integral solutions to the equation a^2 + 2 b^2 = 1. But this is just the equation of an ellipse, so let's look at its graph. We need to first read in a package that allows us to plot equations implicitly.
:[font = input; preserveAspect]
Needs["Graphics`ImplicitPlot`"]
:[font = text; inactive; preserveAspect]
Here, we plot the ellipse determined by this equation.
:[font = input; preserveAspect]
Clear[a, b]
gr1 = ImplicitPlot[a^2 + 2 b^2 == 1, {a, -2, 2}, 
	AspectRatio -> Automatic, PlotRange -> {{-2, 2}, {-2, 2}}];
:[font = text; inactive; preserveAspect]
Next, we plot a backdrop for our ellipse, consisting of points with integer coordinates in the neighborhood of the ellipse.
:[font = input; preserveAspect]
gr2 = IntegerLatticeGrid[{-2, 2}, {-2, 2}, PlotStyle -> 
	{PointSize[0.025], RGBColor[0, 0, 1]}, AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect]
Putting them together results in the following.
:[font = input; preserveAspect]
Show[{gr2, gr1}, AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect]
It should be clear that the only points with integer coordinates that lie on the ellipse occur where a = 1 and b = 0 and where a = -1 and b = 0.

This illustrates that when d = -2 the only units are 1 and -1. What about for smaller values of d? Consider the following series of graphics. After evaluating the cell, you may wish to double-click on one of the graphics and adjust the animation speed by typing 1 through 9 (1 slow, 9 fast).
:[font = input; preserveAspect]
Do[ImplicitPlot[a^2 - d b^2 == 1, {a, -2, 2}, 
	AspectRatio -> Automatic,
	PlotRange -> {{-1, 1}, {-1, 1}}, 
	PlotLabel -> "d = "<>ToString[d]], {d, -3, -15, -2}];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q8. What is the conclusion? If d < -2, how many units are there? What are they? Justify your answer.
;[s]
2:0,1;2,0;101,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
What if d = -1? We then have N(x) = a^2 - (-1)b^2 = 1, or a^2 + b^2 = 1.
:[font = input; preserveAspect]
gr1 = ImplicitPlot[a^2 + b^2 == 1, {a, -2, 2}, 
	AspectRatio -> Automatic, PlotRange -> {{-2, 2}, {-2, 2}},
	DisplayFunction -> Identity];
	
Show[{gr2, gr1}, AspectRatio -> Automatic, 
	DisplayFunction -> $DisplayFunction];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q9. When d = -1, how many units are there? What are they? Justify your answer.
;[s]
2:0,1;2,0;79,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Next, we consider when d > 1.When d = 2 we have  N(x) = |a^2 - 2 b^2| = 1. Therefore, we need a^2 - 2 b^2 to have the value 1 or -1. This simply gives rise to two hyperbolas: a^2 - 2b^2 = 1 and a^2 - 2b^2 = -1. These two are now graphed, to gain some geometric insight.
:[font = input; preserveAspect]
c = 4;
gr1 = ImplicitPlot[{a^2 - 2b^2 == 1, a^2 - 2b^2 == -1}, {a, -c, c}, 
	AspectRatio -> Automatic, PlotStyle -> {{Thickness[0.02], Green}, 
	{Thickness[0.02], Magenta}},
	PlotRange -> {{-c, c}, {-c, c}}];
:[font = text; inactive; preserveAspect]
Here is the graph with an integer lattice backdrop (actually, a "foredrop" this time), showing the two together.
:[font = input; preserveAspect]
gr2 = IntegerLatticeGrid[{-c, c}, {-c, c}, PlotStyle -> 
	{PointSize[0.025], Blue}, AspectRatio -> Automatic, 
	DisplayFunction -> Identity];
	
Show[{gr1, gr2}, DisplayFunction -> $DisplayFunction]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q10. Do you "see" any units? (Remember, we are looking for units in Z[2] = {a + b 2 | a, b in Z} which have integer coordinates and must satisfy one of the equations giving rise to a hyperbola.) List those that you see. Use the function ZdUnitQ if you wish to verify that it is a unit; see below for example.
;[s]
4:0,1;3,0;239,2;246,0;311,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The function ZdUnitQ can be used to confirm or deny whether an element is a unit or not.
;[s]
3:0,0;13,1;20,0;89,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?ZdUnitQ
:[font = input; preserveAspect]
ZdUnitQ[2, 2 + Sqrt[2]]
:[font = text; inactive; preserveAspect]
Consider the element x = 3 + 2 2; this is a unit in Z[2]:
:[font = input; preserveAspect]
ZdUnitQ[2, x = 3 + 2 Sqrt[2]]
:[font = text; inactive; preserveAspect]
Since x is a unit, then any power of x is also a unit. (Appropriate use of properties 2 and 3 is one way of verifying this.) Let's examine the powers of this element. Here are the first five powers.
:[font = input; preserveAspect]
pts1 = Table[Expand[x^k], {k, 1, 5}]
:[font = text; inactive; preserveAspect]
We can verify that these are indeed units.
:[font = input; preserveAspect]
Map[ZdUnitQ[2, #]&, pts1]
:[font = text; inactive; preserveAspect]
These elements appear to be growing without bound. Here is geometric view of what is happening, showing only the hyperbolas in the first quadrant, and the powers of x colored according to Hue (the "rainbow").
;[s]
3:0,0;188,1;191,0;209,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
convertPts[lst_] := lst /. {a_ + b_ Sqrt[2] :> {a, b}, a_ + Sqrt[2] :> {a,1}}
pts1 = pts1//convertPts;
n = Length[pts1];
c = 3400;
gr1 = ImplicitPlot[{a^2 - 2b^2 == 1, a^2 - 2b^2 == -1}, {a, 0, c}, 
	AspectRatio -> Automatic, PlotStyle -> {Green, Magenta},
	PlotRange -> {{0, c}, {0, c}}, Epilog -> Table[{Hue[k/n], PointSize[0.03],
	Map[Point, pts1[[k]], {0}]}, {k, 1, n}]];
:[font = text; inactive; preserveAspect]
Here are the five colors (in order) of the dots plotted.
:[font = input; preserveAspect]
Show[Graphics[Table[{Hue[i/5], Rectangle[{i, 0},{i + 1, 1}]}, 
	{i, 5}]]];
:[font = text; inactive; preserveAspect]
(You might ask where the yellow is on the plot.) Let's try another element, x = -1 + 2, which is also a unit, and its first ten powers.
:[font = input; preserveAspect]
ZdUnitQ[2, x = -1 + Sqrt[2]]

pts2 = Table[Expand[x^k], {k, 1, 10}]

Map[ZdUnitQ[2, #]&, pts2]
:[font = text; inactive; preserveAspect]
Here is the graph of the hyperbolas with the 10 powers of this x plotted.
:[font = input; preserveAspect]
pts2 = pts2//convertPts;
n = Length[pts2];
c = 3400;
gr1 = ImplicitPlot[{a^2 - 2b^2 == 1, a^2 - 2b^2 == -1}, {a, -c, c}, 
	AspectRatio -> Automatic, PlotStyle -> {Green, Magenta},
	PlotRange -> {{-c, c}, {-c, c}}, Epilog -> Table[{Hue[k/n], PointSize[0.03],
	Map[Point, pts2[[k]], {0}]}, {k, 1, n}]];
:[font = text; inactive; preserveAspect]
As n increased on the power x^n, the point was colored according to the scheme shown below, where the power n is located in the rectangle.
:[font = input; preserveAspect]
Show[Graphics[Table[{Hue[i/10], Rectangle[{i, 0},{i + 1, 1}], Black,
	Text[i, {0.5 + i, .5}]}, {i, 10}]]];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q11. What is fundamentally different between the powers of these two elements (3 + 22 versus -1 + 2), as shown by the graphs?
;[s]
2:0,1;3,0;128,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect; endGroup]
As can be seen, Z[2] has an infinite number of units. This is true whenever d > 1.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.6 Factoring 46 in Z[-5]
:[font = text; inactive; preserveAspect]
In question 7, we investigated the norm of the following four numbers.
:[font = input; preserveAspect]
x = 1 + 3 Sqrt[-5]
y = ZdConjugate[x]
a = 2
b = 23
Map[ZdNorm, {x, y, a, b}]
:[font = text; inactive; preserveAspect]
Note further that x y = a b = 46.
:[font = input; preserveAspect]
Expand[x y] == 46
:[font = text; inactive; preserveAspect]
This shows that x, y, a, and b are all divisors of 46. Are there any more?
:[font = input; preserveAspect]
ZdDivisors[-5, 46]
:[font = text; inactive; preserveAspect]
We are really only interested in the non-trivial ones:
:[font = input; preserveAspect]
ZdDivisors[-5, 46, NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect]
That 46 has four non-trivial divisors (over Z[-5]) is not significant in itself. If we consider the integer 80, we know that it has many divisors as well.
:[font = input; preserveAspect]
IntegerDivisors[80, NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect]
We know that 80 can be written as 2 * 40, 4 * 20, 5 * 16, or 8 * 10, but in each case one or both factors can be further factored (into primes) until one obtains the result 2 * 2 * 2 * 2 * 5, or 2^4 * 5:
:[font = input; preserveAspect]
FactorInteger[80]
:[font = text; inactive; preserveAspect]
Except for the order that these factors are written, or if perhaps some (even number) are traded for their associates (their negatives), this product is unique. This is a result of the Fundamental Theorem of Arithmetic. The question to pursue here is whether an analogous situation holds in Z[-5], and other rings. In other words, even though (1 + 3 -5) (1 - 3 -5) = 46 = 2 * 23 in Z[-5] shows that we have two factorizations that appear different, we want to make sure that we have factored 46 into irreducibles. Also, we want to see if 1 + 3 -5 is possibly an associate of 2 or 23 and if 1 - 3 -5 is an associate of the other.Thus, we have two steps to take:

1. Determine whether 2, 23, 1 + 3 -5, and 1 - 3 -5 satisfy our definition of being irreducible.

2. Determine if any of {2, 23} are associates with any of {1 + 3 -5, 1 - 3 -5}.
:[font = text; inactive; preserveAspect]
Recall that for r to be irreducible over an integral domain D, it must be nonzero, not a unit, and if we ever have s t = r (for s, t in D), we must have either s or t a unit. Clearly none of these four are zero, and when we calculated their norms we observed that none had norm 1, so they are not units. First, let's consider 2 and show that it is irreducible. Its norm is four.
:[font = input; preserveAspect]
ZdNorm[2]
:[font = text; inactive; preserveAspect]
Therefore, if 2 = s t for some s and t in D = Z[-5], then N(s) N(t) = 4, by the second property of norms. To show that 2 is irreducible, we need to show that either s or t is a unit, and consequently having norm 1 (by the third property). Therefore, since the divisors of 4 are {1, 2, 4}, we want to show that we can not have N(s) = N(t) = 2 and then we will know that 2 is irreducible.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q12. Why do we only need to show that we cannot have N(s) = 2 to show 2 is irreducible?
;[s]
2:0,1;3,0;88,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
If we let s = a + b -5, then we see that N(s) = a^2 + 5 b^2. For N(s) = 2, we must have integral coordinates for a point somewhere on the ellipse a^2 + 5 b^2 = 2. Inspecting this algebraically, clearly if b is not zero, then the left-hand side is already at least 5, which is not possible (since we still have to add a^2 to 5 b^2, while the right-hand side is 2). Geometrically, we can see this below.
:[font = input; preserveAspect]
ZdPossibleNorms[-5, 2, Mode -> Visual]
:[font = text; inactive; preserveAspect]
This function shows the ellipse with the equation given above, as well as showing all points whose norm is less than or equal to 2 (and the output is a list of all norms that are possible that are less than or equal to 2). We can also just use the function ZdPossibleNormQ as follows:
;[s]
3:0,0;257,1;272,0;285,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ZdPossibleNormQ[-5, 2]
:[font = text; inactive; preserveAspect]
Now we know that 2 is indeed an irreducible element. Next, we attack 23 and investigate whether it is irreducible. Let's assume that it is not irreducible and see if we can find a contradiction. Therefore 23 = s t, where s and t are in D. Consequently, N(23) = N(s) N(t) and we need to find elements s and t whose norm is a divisor of the norm of 23. Not that we need Mathematica to help us in this case (the arithmetic is trivial), but to illustrate the general idea, we want to look for the non-trivial divisors of 23^2.
;[s]
3:0,0;368,1;379,0;523,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
IntegerDivisors[ZdNorm[23], NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect]
The only possible divisor is 23, so both N(s) and N(t) must be 23. Is it possible to have this norm in the ring D = Z[-5]?
:[font = input; preserveAspect]
ZdPossibleNormQ[-5, 23]
:[font = text; inactive; preserveAspect]
Let's "see" why not.
:[font = input; preserveAspect]
ZdPossibleNorms[-5, 23, Mode -> Visual]
:[font = text; inactive; preserveAspect]
The value 23 is not obtainable as a norm, and therefore there are no s and t such that N(s) = N(t) = 23, so either s or t is a unit, and 23 is irreducible.

There are two elements left to check for irreducibility: 1 + 3 -5 and 1 - 3 -5. We proceed in the same manner.
:[font = input; preserveAspect]
IntegerDivisors[ZdNorm[1 + 3 Sqrt[-5]], NonTrivialOnly -> True]
IntegerDivisors[ZdNorm[1 - 3 Sqrt[-5]], NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect]
Since the only possible non-trivial divisors of the norms of these two are 2 and 23, and we have seen that neither of these norms are possible, we know that both of the elements 1 + 3 -5 and 1 - 3 -5 are irreducible.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q13. Here is an optional question. Define the function PN by PN(x) is the number of norms less than or equal to x that are possible in Z[-5]. What is PN(100)? How much larger is PN(200) than PN(100)? (In other words, are there more or less in the second 100, from 101 to 200, then in the first 100?) How does PN(300) compare to PN(200)? Is there a monotonic pattern? You may wish to use what is below to help you, with the Length function to measure the output. (Eliminate the Mode -> Visual option if the graphics take too long -- they are not needed for the count.)
;[s]
6:0,1;3,0;424,2;430,0;478,2;492,0;569,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
ZdPossibleNorms[-5, 100, Mode -> Visual]
:[font = text; inactive; preserveAspect]
We have shown that the four divisors of 46 are all irreducible. Next, we want to know if any of {2, 23} are associates with {1 + 3 -5, 1 - 3 -5}, which was step two in our outline above. Recall that for 2 to be an associate of 1 + 3 -5, it must have a unit u such that 2 = u * 1 + 3 -5. If so, then N(2) = N(u) N(1 + 3 -5), or 4 = 1 * 46, which is clearly not possible. The following shows that no possible arrangement (matching across the two sets) for pairing up associates will be fruitful.
:[font = input; preserveAspect]
Map[ZdNorm, {2, 23}]
Map[ZdNorm, {1 + 3 Sqrt[-5], 1 - 3 Sqrt[-5]}]
:[font = text; inactive; preserveAspect]
(Note that checking for associates could have also been done as follows.)
:[font = input; preserveAspect]
ZdAssociatesQ[-5, 2, 1 + 3 Sqrt[-5]]
ZdAssociatesQ[-5, 23, 1 + 3 Sqrt[-5]]
:[font = text; inactive; preserveAspect]
What is the conclusion? In Z[-5] we have 46 = 2 * 23 and 46 = (1 + 3 -5) * (1 - 3 -5). These four divisors are all irreducible and the two factorizations do not involve associates (as would 46 = 2 * 23 and 46 = (-2) * (-23)). Consequently, we have two distinct, unrelated factorizations of the number 46. This verifies that Z[-5] is not a Unique Factorization Domain (UFD).
;[s]
3:0,0;337,1;340,0;378,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; endGroup]
Historical Note: There was a short time in the nineteenth century when Fermat's Last Theorem was considered to have been proven, but there was a flaw in the proof. This flaw, discovered by Kummar, traced back to an assumption that factorization was unique in rings such as Z[-5].
;[s]
2:0,1;15,0;281,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.7 Is Z[-6] a UFD?
:[font = text; inactive; preserveAspect]
Since we have shown that Z[-5] is not a UFD (Unique Factorization Domain), we may wonder about other related rings. Let's consider a neighbor (in some sense), D = Z[-6]. To show that D is not a UFD, we need to find an element r in D that has two distinct factorizations. Since we may like to somewhat automate this, we label each step along the way with variables to hold the values, so we can readily try other rings.
:[font = text; inactive; preserveAspect]
In this example, we are using d = -6.
:[font = input; preserveAspect]
d = -6
:[font = text; inactive; preserveAspect]
Let's pick two random coefficients, but not too large.
:[font = input; preserveAspect]
{a, b} = Table[Random[Integer, {1, 5}], {2}]
:[font = text; inactive; preserveAspect]
We use these values to form our x, and let y be its conjugate.
:[font = input; preserveAspect]
x = a + b Sqrt[d]
y = ZdConjugate[x]
:[font = text; inactive; preserveAspect]
Let z be their product.
:[font = input; preserveAspect]
z = Expand[x y]
:[font = text; inactive; preserveAspect]
We use nrm form the norm of this product.
:[font = input; preserveAspect]
nrm = ZdNorm[z]
:[font = text; inactive; preserveAspect]
Let's take a look at all the divisors of z.
:[font = input; preserveAspect]
ZdDivisors[d, z, DivisorsComplete -> True]
(* may take a little time *)
:[font = text; inactive; preserveAspect]
We can view these divisors by pairing up associates.
:[font = input; preserveAspect]
ZdDivisors[d, z, Combined -> Associates, DivisorsComplete -> True]
:[font = text; inactive; preserveAspect]
We can also pair up the divisors so that the product of each pair is z.
:[font = input; preserveAspect]
ZdDivisors[d, z, Combined -> Products, DivisorsComplete -> True]
:[font = text; inactive; preserveAspect]
From here, we should look for two pairs whose product is z, all divisors are irreducible and none are associates of the others.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q14. Find two pairs that satisfy these conditions. If there are not two pairs, go back and generate a new x and y and see if two pairs arise that satisfy these conditions. 
;[s]
2:0,1;3,0;173,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.8 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Adjoin
:[font = input; preserveAspect]
?DividesQ
:[font = input; preserveAspect]
?Radical
:[font = input; preserveAspect]
?ZdDivide
:[font = input; preserveAspect]
?ZdAssociatesQ
:[font = input; preserveAspect]
?ZdIrreducibleQ
:[font = input; preserveAspect]
?FactorInteger
:[font = input; preserveAspect]
?GaussianIntegers
:[font = input; preserveAspect]
?ZdNorm
:[font = input; preserveAspect]
?ImplicitPlot
:[font = input; preserveAspect]
?IntegerLatticeGrid
:[font = input; preserveAspect]
?ZdUnitQ
:[font = input; preserveAspect]
?ZdConjugate
:[font = input; preserveAspect]
?ZdDivisors
:[font = input; preserveAspect]
?NonTrivialOnly
:[font = input; preserveAspect]
?IntegerDivisors
:[font = input; preserveAspect]
?ZdPossibleNorms
:[font = input; preserveAspect]
?ZdPossibleNormQ
:[font = input; preserveAspect]
?Combine
:[font = input; preserveAspect]
?Associates
:[font = input; preserveAspect; endGroup; endGroup]
?Products
^*)
