(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Matrices` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`Matrices *)

(* :Context: AbstractAlgebra`Matrices` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Startup AbstractAlgebra`Matrices
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Matrices`",{"AbstractAlgebra`Core`", 
"AbstractAlgebra`RingProperties`", "AbstractAlgebra`RingExtensions`",
"AbstractAlgebra`Joint`",
"Graphics`Graphics`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
Adjoint::usage = "Adjoint[A] returns Transpose[MatrixConjugate[A]], the transpose
of the conjugate of a matrix. (For the usage of adjoint as it relates to
determinants, see DetAdjoint.)";

AntiCommutingMatricesQ::usage = "AntiCommutingMatricesQ[R, A, B] returns True
or False depending on whether the matrices A and B over the Ringoid R anti-commute
(i.e., A B = - B A). 
AntiCommutingMatricesQ[MatricesOver[R,{n,n}], A, B] works similarly. For
matrices with numeric entries (over Integers, Rationals, Reals or Complex),
AntiCommutingMatricesQ[A, B] works similarly.";

(*Conjugate::usage = "Conjugate[A], where A is a matrix, returns the matrix with
all of the elements being the complex conjugate of what occurred in A."; *)

CommutingMatricesQ::usage = "CommutingMatricesQ[R, A, B] returns True or False
depending on whether the matrices A and B over the Ringoid R commute. 
CommutingMatricesQ[MatricesOver[R,{n,n}], A, B] works similarly. For
matrices with numeric entries (over Integers, Rationals, Reals or Complex),
CommutingMatricesQ[A, B] works similarly.";

ComplexMatrixQ::usage = "ComplexMatrixQ[A] returns True or False
depending on whether the matrix A has all of its entries being complex numbers
(in the mathematical sense - entries can be Integer, Rational, Algebraic, Real,
or Complex).";

Det::usage="Det[R, A] returns the determinant of the square
matrix A over the Ringoid R. Det[MatricesOver[R,{n,n}],A]
is equivalent to Det[R, A]. The standard (built-in) usage still exists:
Det[m] gives the determinant of the square matrix m.";

DetAdjoint::usage = "DetAdjoint[A] returns the adjoint of a matrix A, which
is defined as (-1)^(i+j) Det[Transpose[Bij]], where Bij is the matrix Aij
with the ith row and jth column removed.";

Diag::usage = "Diag[n, R] (alternately, Diag[R, n]) returns the extension of
n by n
diagonal matrices over the Ringoid R that are invertible.";

DiagonalMatrices::usage = "DiagonalMatrices[n, R] (alternately,
DiagonalMatrices[R, n]) - see Diag.";

DiagQ::usage = "DiagQ[R, A] returns True or False depending on whether the matrix
A over the Ringoid R is in Diag[R, n] (where A is an n by n matrix).";

Dot::usage="Dot[R, a, b] generalizes the (scalar) dot product for a Ringoid R and
computes a.b (for vectors a and b over R) using the arithmetic of R.
The standard (built-in) usage still exists: 
a.b.c or Dot[a, b, c] gives products of vectors, matrices and tensors.";

GeneralLinear::usage = "GeneralLinear[args] - see GL.";

GeneralLinearGroup::usage = "GeneralLinearGroup[args] - see GL.";

GL::usage = "GL[n, R] (alternately, GL[R, n]) returns the extension of
n by n matrices
over the Ringoid R that are invertible. For a positive integer k,
GL[n,k] is equivalent to GL[n,Z[k]].";

GLQ::usage = "GLQ[R, A] returns True or False depending on whether the matrix
A over the Ringoid R is in GL[R, n] (where A is an n by n matrix).";

HermitianQ::usage = "HermitianQ[A] returns True or False
depending on whether the matrix A is Hermitian (i.e., A = Adjoint[A]).";

IntegerMatrixQ::usage = "IntegerMatrixQ[A] returns True or False
depending on whether the matrix A has all of its entries being integers.";

LT::usage = "LT[n, R] (alternately, LT[R, n]) returns the extension of n by n
lower triangular matrices (fully below the diagonal) over the Ringoid R.";

LTD::usage = "LTD[n, R] (alternately, LTD[R, n]) returns the extension of n by n
lower triangular matrices (including the diagonal) over the Ringoid R.";

MatricesOver::usage="MatricesOver[R,{m,n}] generates the RingExtension of m by n matrices
over R. MatricesOver[R,n] is equivalent to MatricesOver[R,{n,n}].";

MatrixConjugate::usage = "MatrixConjugate[A], where A is a matrix, returns the
matrix with all of the elements being the complex conjugate of what occurred
in A."; 

MatrixDelete::usage = "MatrixDelete[A, {i, j}] returns the matrix remaining
when the ith row and jth column of the matrix A are removed.";

MatrixOverQ::usage = "MatrixOverQ[R, A] returns True or False depending on
whether the elements of the matrix A come from the Ringoid R.";

MatrixOperation::usage = "MatrixOperation[MatricesOver[R, {m,n}]] returns the operation
inherent in the matrix extension. Values are the same as for Operation: Both,
Addition, or Multiplication.";

MatrixPower::usage = "MatrixPower[MatricesOver[R, {n,n}], A, k] returns the
kth power of the matrix A, as an element of the n by n matrices over the
Ringoid R. MatrixPower[R, A, k] works similarly.
The standard (built-in) usage still exists: MatrixPower[mat, n]
gives the nth matrix power of mat.";

MatrixTrace::usage = "MatrixTrace[R, A] returns the trace of the square matrix
A. MatrixTrace[MatricesOver[R,{n,n}], A] works similarly. For
matrices with numeric entries (over Integers, Rationals, Reals or Complex),
MatrixTrace[A] works similarly.";

MatrixType::usage = "MatrixType is the name of an option for working with matrix
extension rings. It takes on values GL, SL, Diag, UT, LT, UTD, and LTD (and defaults
to All).";

Mat::usage = "Mat[R,n] (alternatively, Mat[n, R]) returns the extension ring
of n by n matrices over the Ringoid R. Mat[R, {m,n}] (or Mat[{m,n},R]) returns
the extension ring of m by n matrices over R.";

MatA::usage = "MatA[R,{m,n}] (alternatively, MatA[{m,n}, R]) returns the extension
of m by n matrices over the Ringoid R with the operation being addition of matrices.";

MatM::usage = "MatM[R,n] (alternatively, MatM[n, R]) returns the extension
of n by n matrices over the Ringoid R with the operation being multiplication of matrices.";

OrthogonalQ::usage = "OrthogonalQ[R, A] returns True or False
depending on whether the matrix A over the Ringoid R is an orthogonal
matrix (i.e., the product of the transpose of A and A itself is the
identity matrix). For matrices with real entries,
OrthogonalQ[A] works similarly.";

RandomMatrix::usage = "RandomMatrix[R, n, MatrixType -> type] returns a random
n by n matrix over the Ringoid R of the specified type; see MatrixType for the
possible values.";

RationalMatrixQ::usage = "RationalMatrixQ[A] returns True or False
depending on whether the matrix A has all of its entries being rational numbers
(in the mathematical sense - entries can be Integer or Rational).";

RealMatrixQ::usage = "RealMatrixQ[A] returns True or False
depending on whether the matrix A has all of its entries being real numbers
(in the mathematical sense - entries can be Integer, Rational, Algebraic, or Real).";

SizeOfMatrices::usage = "SizeOfMatrices[matrixExtension] returns the
dimensions of the matrices used in this extension ring.";

SkewHermitianQ::usage = "SkewHermitianQ[A] returns True or False
depending on whether the matrix A is skew-Hermitian (i.e., A = -Adjoint[A]).";

SkewSymmetricQ::usage = "SkewSymmetricQ[R, A] returns True or False
depending on whether the matrix A is skew-symmetric (i.e., A = -Transpose[A]).
For matrices with numeric entries (over Integers, Rationals, Reals or Complex),
SkewSymmetricQ[A] works similarly.";

SL::usage = "SL[n, R] (alternately, SL[R, n]) returns the the extension
of invertible
n by n matrices over the Ringoid R that have determinant Unity[R].
For a positive integer k, SL[n,k] is equivalent to SL[n,Z[k]].";

SLQ::usage = "SLQ[R, A] returns True or False depending on whether the matrix
A over the Ringoid R is in SL[R, n] (where A is an n by n matrix).";

SpecialLinear::usage = "SpecialLinear[args] - see SL.";

SpecialLinearGroup::usage = "SpecialLinearGroup[args] - see SL.";

SymmetricQ::usage = "SymmetricQ[R, A] returns True or False
depending on whether the matrix A is symmetric.  For
matrices with numeric entries (over Integers, Rationals, Reals or Complex),
SymmetricQ[A] works similarly.";

ToGroupoid::usage = "ToGroupoid[extension], where extension might be GL[R,n]
or some similar extension (or specificially, ToGroupoid[MatricesOver[R,
{m,n}, opts]]), calculates
the actual elements and forms a Groupoid when the number of elements is not larger
than the default value of the option SizeLimit. Setting this option higher allows
more Groupoids to be formed, but one needs to be sure there is sufficient memory to
do so, since these Groupoids can become rather large. Using Size first may be a good
idea, to see how many elements there are. To just get the list of elements, use the
function Elements (which uses the same SizeLimit restriction).";

ToRingoid::usage = "ToRingoid[Mat[R, n]], if the SizeLimit permits,
returns the Ringoid consisting of the n by n matrices over the Ringoid
R. See ToGroupoid for more details.";

UnitaryQ::usage = "UnitaryQ[A] returns True or False
depending on whether the matrix A (over the complex numbers) is an
unitary matrix (i.e., the product of the adjoint of A and A itself is the
identity matrix).";

UT::usage = "UT[n, R] (alternately, UT[R, n]) returns the extension of n by n
upper triangular matrices (fully above the diagonal) over the Ringoid R.";

UTD::usage = "UTD[n, R] (alternately, UTD[R, n]) returns the extension of n by n
upper triangular matrices (including the diagonal) over the Ringoid R.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
Dot::DimErr="Dimensions of parameters to Dot fail to match.";

Random::toomany = "After 500 attempts, a random matrix meeting these conditions
was not found.";

Random::notype = "`1` is not an acceptable value for MatrixType.";

SizeLimit::toobig = "With the present restriction on SizeLimit, there are too
many elements to form a Groupoid that determines all of the elements.";

Identity::nonsquare = "To have an Identity matrix, one needs to consider square
matrices.";

Multiplication::fail = "A `1` by `2` matrix can not be multiplied by a `3` by `4`
matrix.";

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Begin private
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
MatricesOver RingExtension
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
general
:[font = input; initialization; preserveAspect; endGroup]
*)
RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Creation
:[font = input; initialization; preserveAspect; endGroup]
*)
Format[RingExtension[Matrices,R_,{m_, n_},t_, All,_]] := 
SequenceForm["-",Subscripted["Mat"["("<>ToString[m]<>","<>ToString[n]<>")"]],
	"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, All,_]] := 
SequenceForm["-",Subscripted["Mat"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, GL,_]] := 
SequenceForm["-",Subscripted["GL"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, SL,_]] := 
SequenceForm["-",Subscripted["SL"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, Diag,_]] := 
SequenceForm["-",Subscripted["Diag"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, UT,_]] := 
SequenceForm["-",Subscripted["UT"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, LT,_]] := 
SequenceForm["-",Subscripted["LT"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, UTD,_]] := 
SequenceForm["-",Subscripted["UTD"[ToString[n]]],"("<>RingoidName[R]<>")-"]

Format[RingExtension[Matrices,R_,{n_, n_},t_, LTD,_]] := 
SequenceForm["-",Subscripted["LTD"[ToString[n]]],"("<>RingoidName[R]<>")-"]

MatrixTypes = {All, GL, SL, Diag, UT, UTD, LT, LTD, GenA, GenM};

Options[MatricesOver] = {MatrixType -> All, AnotherTest -> True, Operation ->
	Both};

MatricesOver[R_?RingoidQ, n_Integer?Positive, opts___?OptionQ] := 
	MatricesOver[R, {n,n},opts]

MatricesOver[R_?RingoidQ, {m_Integer?Positive, n_Integer?Positive}, opts___?OptionQ] := 
		Module[{at = AnotherTest/.Flatten[{opts, Options[MatricesOver]}],
		tom = MatrixType/.Flatten[{opts, Options[MatricesOver]}],
		op = Operation/.Flatten[{opts, Options[MatricesOver]}]}, 
	RingExtension[Matrices, R, {m,n}, ((GoodElementsDimensionsQ[#, Elements[R],{m,n}]) &&
	AnotherTest/.Flatten[{opts, Options[MatricesOver]}])& , tom, op]]

TestFunction[RingExtension[Matrices,base_,param_,test_, ___]]:=test

BaseRing[RingExtension[Matrices,base_,param_,test_, ___]]:=base

ExtensionType[RingExtension[Type_,base_,param_,test_, _, _]] := Matrices

Mat[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> All, Operation -> Both]
	
Mat[n_Integer?Positive, R_?RingoidQ] := Mat[R, n]

MatM[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> All, Operation -> Multiplication]
	
MatM[n_Integer?Positive, R_?RingoidQ] := MatM[R, n]

Mat[R_?RingoidQ, {n_Integer?Positive, n_Integer?Positive}] := 
	MatricesOver[R, {n,n}, MatrixType -> All, Operation -> Both]

Mat[R_?RingoidQ, {m_Integer?Positive, n_Integer?Positive}] := 
	MatricesOver[R, {m,n}, MatrixType -> All, Operation -> Addition]

Mat[{m_Integer?Positive, n_Integer?Positive}, R_?RingoidQ] := Mat[R, {m,n}]
		
MatA[R_?RingoidQ, {m_Integer?Positive, n_Integer?Positive}] := 
	MatricesOver[R, {m,n}, MatrixType -> All, Operation -> Addition]

MatA[{m_Integer?Positive, n_Integer?Positive}, R_?RingoidQ] := MatA[R, {m,n}]
		
GL[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> GL, AnotherTest -> GLQ[R,#],
	Operation -> Multiplication]

GL[n_Integer?Positive, R_?RingoidQ] := GL[R,n]

GL[n_Integer?Positive, k_Integer?Positive] := GL[Z[k, Structure -> Ring],n]

GeneralLinear[args__] := GL[args]

GeneralLinearGroup[args__] := GL[args]

SL[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> SL, AnotherTest -> SLQ[R,#],
	Operation -> Multiplication]

SL[n_Integer?Positive, R_?RingoidQ] := SL[R,n]

SL[n_Integer?Positive, k_Integer?Positive] := SL[Z[k, Structure -> Ring],n]

SpecialLinear[args__] := SL[args]

SpecialLinearGroup[args__] := SL[args]

Diag[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> Diag, AnotherTest -> DiagQ[R,#], 
	Operation -> Multiplication]

Diag[n_Integer?Positive, R_?RingoidQ] := Diag[R,n]

DiagonalMatrices[args__] := Diag[args]

UT[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> UT, AnotherTest -> UTQ[R,#], 
	Operation -> Addition]

UT[n_Integer?Positive, R_?RingoidQ] := UT[R,n]

LT[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> LT, AnotherTest -> LTQ[R,#],
	Operation -> Addition]

LT[n_Integer?Positive, R_?RingoidQ] := LT[R,n]

UTD[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> UTD, AnotherTest -> UTDQ[R,#]]

UTD[n_Integer?Positive, R_?RingoidQ] := UTD[R,n]

LTD[R_?RingoidQ, n_Integer?Positive] := 
	MatricesOver[R, {n,n}, MatrixType -> LTD, AnotherTest -> LTDQ[R,#]]

LTD[n_Integer?Positive, R_?RingoidQ] := LTD[R,n]

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
tests for types
:[font = input; initialization; preserveAspect; endGroup]
*)
GoodElementsDimensionsQ[A_List, els_, {m_,n_}] := 
	MatrixQ[A, MemberQ[els,#]&] && Take[Dimensions[A],2]==={m,n}

DiagQ[R_?RingoidQ, A_?squareQ] := 
	Union[LowerTriangleElements[A], UpperTriangleElements[A]] === {Zero[R]} &&
	GLQ[R, A]

UTQ[R_?RingoidQ, A_?squareQ] := Union[LowerTriangleElements[A], 
	DiagonalElements[A]] === {Zero[R]}

UTDQ[R_?RingoidQ, A_?squareQ] := LowerTriangleElements[A] === {Zero[R]} &&
	GLQ[R, A]

LTQ[R_?RingoidQ, A_?squareQ] := Union[UpperTriangleElements[A], 
	DiagonalElements[A]] === {Zero[R]}

LTDQ[R_?RingoidQ, A_?squareQ] := UpperTriangleElements[A] === {Zero[R]} &&
	GLQ[R, A]

GLQ[R_?RingoidQ, A_?squareQ] := UnitQ[R,Det[R, A]]

SLQ[R_?RingoidQ, A_?squareQ] := Det[R, A] == Unity[R]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Operations on matrices and extensions
:[font = input; initialization; preserveAspect; rightWrapOffset = 558; endGroup; endGroup]
*)
SizeOfMatrices[RingExtension[Matrices,R_,{m_, n_},test_, tom_, 
	op_]] := {m,n}
	
MatrixOperation[RingExtension[Matrices,R_,{m_, n_},test_, tom_, 
	op_]] := op

Addition[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_]] := 
	If[test[#1] && test[#2],
		Block[{m1 = Flatten[#1,1], m2 = Flatten[#2,1]},
			MapThread[(Addition[R][#1,#2])&,{m1,m2}]//Partition[#,n]&],
		Message[MemberQ::elmnts, {#1, #2},"the ring of matrices"]; 
		$Failed]&

Addition[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_], 
	A_List, B_List] := 
	Addition[RingExtension[Matrices,R,{m,n},test,tom, op]][A, B]
	
Addition[R_?StructuredSetQ, A_List, B_List] := 
	Addition[MatricesOver[R, Take[Dimensions[A],2]]][A, B]

Multiplication[RingExtension[Matrices,R_,{n_, n_},test_, tom_, 
		op_]]:=
	If[test[#1] && test[#2],
  	Block[{a = #1, b = Transpose[#2],j,k},
    	Table[Dot[R,a[[j]],b[[k]]],{j,1,n},{k,1,n}]],
		Message[MemberQ::elmnts, {#1, #2},"the ring of matrices"]; 
		$Failed]&

Multiplication[RingExtension[Matrices,R_,{n_, n_},test_, tom_,
		op_], A_List, B_List] := 
	Multiplication[RingExtension[Matrices,R,{n,n},test,tom, op]][A, B]
	
Multiplication[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_], 
	A_List, B_List] := Multiplication[R, A, B]
	
Multiplication[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_]]:=
	Multiplication[R, A, B]

Multiplication[R_?StructuredSetQ, A_List, B_List]:= Module[{dimok, elsok, a = A, 
		b = Transpose[B], dim1, dim2, j,k, ra,ca,rb, cb},
	dimok = Length[dim1 = Take[Dimensions[A],2]]==2 && 
		Length[dim2 = Take[Dimensions[B],2]] ==2 &&
		(rb=First[dim2]) === (ca=Last[dim1]);
	elsok = ElementsQ[Union[Flatten[Join[A,B]]],R];
	If[dimok,
		If[elsok,
    	Table[Dot[R,a[[j]],b[[k]]],{j,1,First[dim1]},{k,1,Last[dim2]}],
			Message[MemberQ::elmnts, {A, B},"the ring of matrices"]; $Failed],
		Message[Multiplication::fail,First[dim1],ca,rb,Last[dim2]]; $Failed]]

Unprotect[MatrixPower, IdentityMatrix];

RingExtension /: IdentityMatrix[RingExtension[Matrices,R_,{n_Integer?Positive, n_Integer?Positive},
		t_, tom_, op_]] := 
	Unity[RingExtension[Matrices,R,{n,n},t,tom, op]] 
	
RingExtension /: IdentityMatrix[RingExtension[Matrices,R_,{m_Integer?Positive, n_Integer?Positive},
		t_, tom_, op_]] := 
	(Message[Identity::nonsquare]; $Failed)
	
AbstractAlgebra`Core`Private`ringoid /: 
	IdentityMatrix[R_AbstractAlgebra`Core`Private`ringoid, n_Integer?Positive] := 
	Unity[MatricesOver[R,{n,n}]]  
	
RingExtension /: MatrixPower[RingExtension[Matrices,R_,{n_, n_},t_, 
tom_, op_], A_List, 0] := 
	IdentityMatrix[RingExtension[Matrices,R,{n,n},t,tom, op]]
	
AbstractAlgebra`Core`Private`ringoid /: 
MatrixPower[R_AbstractAlgebra`Core`Private`ringoid, 
	A_?squareQ, 0] := 
	IdentityMatrix[R,First[Dimensions[A]]]
	
RingExtension /: MatrixPower[RingExtension[Matrices,R_,{n_, n_},t_, tom_, op_], 
	A_List, 1] := A
	
AbstractAlgebra`Core`Private`ringoid /: 
MatrixPower[R_AbstractAlgebra`Core`Private`ringoid, A_?squareQ, 1] := A
	
AbstractAlgebra`Core`Private`ringoid /:
MatrixPower[R_AbstractAlgebra`Core`Private`ringoid, A_?squareQ,
	k_Integer?Positive] :=
	Fold[Multiplication[R,#1, #2]&, A, Table[A, {k-1}]]
	
AbstractAlgebra`Core`Private`ringoid /: 
MatrixPower[R_AbstractAlgebra`Core`Private`ringoid, 
	A_?squareQ, k_Integer?Negative] :=
	Module[{n = First[Dimensions[A]], B},
		B = MultiplicativeInverse[MatricesOver[R,Take[Dimensions[A],2]], A];
		Fold[Multiplication[R,#1, #2]&, B, Table[B, {Abs[k]-1}]]]
		
RingExtension /: MatrixPower[RingExtension[Matrices,R_,{n_, n_},t_, tom_, op_], 
	A_List, -1] := 
	MultiplicativeInverse[RingExtension[Matrices,R,{n,n},t,tom, op], A]
	
AbstractAlgebra`Core`Private`ringoid /: 
MatrixPower[R_AbstractAlgebra`Core`Private`ringoid, A_?squareQ, -1] := 
	MultiplicativeInverse[MatricesOver[R,Take[Dimensions[A],2]], A]

RingExtension /: MatrixPower[RingExtension[Matrices,R_,{n_, n_},t_, tom_, op_], A_List, 
k_Integer] :=
	If[k < 0,
		Module[{B = MultiplicativeInverse[RingExtension[Matrices,R,{n,n},t,tom, op], A]},
			Fold[Multiplication[RingExtension[Matrices,R,{n,n},t,tom, op]], B, Table[B, {Abs[k]-1}]]],
	If[k > 0,
		Fold[Multiplication[RingExtension[Matrices,R,{n, n},t,tom, op]], A, 
			Table[A, {k-1}]]]]

Protect[MatrixPower,IdentityMatrix];

HasZeroQ[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_]] := HasZeroQ[R]

Zero[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_]] := 
	If[HasZeroQ[R], 
		Table[Zero[R],{m},{n}],
		Message[RingExtension::NoZero]; $Failed]

WithUnityQ[RingExtension[Matrices,R_,{n_,n_},test_, tom_, op_]] := 
	HasZeroQ[R] && WithUnityQ[R]

Unity[RingExtension[Matrices,R_,{n_, n_},test_, tom_, op_]] := 
		Unity[RingExtension[Matrices,R,{n,n},test,tom, op]] =
	If[HasZeroQ[R] && WithUnityQ[R],
		IdentityMatrix[n]/.{0->Zero[R],1->Unity[R]},
		Message[RingExtension::NoUnity]; $Failed]

HasNegativeQ[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_], A_] /; test[A] :=
	Module[{ng = Apply[And,Map[HasNegativeQ[R,#]&,Flatten[A,1]]]},
		If[ng===True, True,False]]

HasNegativeQ[R_?RingoidQ, A_] :=
	HasNegativeQ[MatricesOver[R,Take[Dimensions[A],2]],A]

NegationOf[RingExtension[Matrices,R_,{m_, n_},test_, tom_, op_], A_] :=
	If[HasNegativeQ[RingExtension[Matrices,R,{m,n},test,tom, op],A], Map[NegationOf[R,#]&,A,{2}],
		Message[RingExtension::NoNegat];$Failed]

NegationOf[R_?RingoidQ, A_] :=
	NegationOf[MatricesOver[R,Take[Dimensions[A],2]],A]

UnitQ[RingExtension[Matrices,R_,{n_,n_},t_, tom_, op_], A_] := 
		UnitQ[RingExtension[Matrices,R,{nn},t,tom, op], A] =
	If[t[A],UnitQ[R, Det[RingExtension[Matrices,R,{n,n},t,tom, op],A]],
		Message[MemberQ::elmnt, A,"the extension ring"]; False]

UnitQ[R_?RingoidQ, A_?squareQ] := UnitQ[R, A] =
	UnitQ[MatricesOver[R,Take[Dimensions[A],2]],A]
	
MultiplicativeInverse[RingExtension[Matrices, R_,  {n_,n_},  t_, tom_, op_], A_?squareQ] := 
	If[(Take[Dimensions[A],2]==={n,n}) && UnitQ[RingExtension[Matrices,R,{n,n},t,tom, op], A], 
		Block[{ B,  f,  i, j,  a,  b,  RT},
		Off[ExtendedGCD::egcd];
			B =(Inverse[Array[ f, { n,  n}]]) /. 
				{Power[a__,-1]:>MultiplicativeInverse[RT, a]} /.
				{-(( a_)*( b___)) :> NegationOf[RT, a]* b} /. 
				{( a_)*( b__) :> Fold[Multiplication[RT][#1,#2]&,a,{b}]} /. 
				{( a_) + ( b__) :> Fold[Addition[ RT][#1, #2] & ,  a,{b}]};
		On[ExtendedGCD::egcd];
      B /. { f[ i_,  j_] :> A[[ i, j]]} /. { RT ->  R}], 
	Message[Inverse::fail,A,"this extension ring"];$Failed];   
       
MultiplicativeInverse[R_?RingoidQ, A_?squareQ] := 
	MultiplicativeInverse[MatricesOver[R,Take[Dimensions[A],2]],A]
	
Unprotect[Inverse];

AbstractAlgebra`Core`Private`ringoid /: 
	Inverse[R_AbstractAlgebra`Core`Private`ringoid, A_?squareQ] := 
	MultiplicativeInverse[MatricesOver[R,Take[Dimensions[A],2]],A]

Protect[Inverse];

ZeroDivisorQ[RingExtension[Matrices,R_,{n_,n_},t_, tom_, op_], A_]:=
	If[t[A], Not[UnitQ[R, Det[RingExtension[Matrices,R,{n,n},t,tom, op],A]]] &&
			(A =!= Zero[RingExtension[Matrices,R,n,t,tom, op]]),
		Message[MemberQ::elmnt, A,"the extension ring"]; False]
		

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Dot/Det
:[font = input; initialization; preserveAspect; endGroup]
*)
Unprotect[Dot, Det];

AbstractAlgebra`Core`Private`ringoid /: Dot[R_AbstractAlgebra`Core`Private`ringoid,
	 A_List, B_List]:=
	If[Length[A]===Length[B] && Length[Dimensions[A]]==1,
		MapThread[Multiplication[R],{A,B},1]//Fold[Addition[R],
			First[#],Rest[#]]&,
		Message[Dot::DimErr]; $Failed]

negationOf[R_?RingoidQ, r_] := negationOf[R,r] = 
	If[ElementQ[r,R],
		GroupInverse[FormGroupoid[Elements[R], R[[2]]],r]]

ZQn[R_?StructuredSetQ] := AbstractAlgebra`RingProperties`Private`ZRingoidQn[R]
		
squareQ[A_List] := Equal@@Take[Dimensions[A],2]

AbstractAlgebra`Core`Private`ringoid /: 
	Det[R_AbstractAlgebra`Core`Private`ringoid, A_?squareQ]:=
	Module[{F,f,i,j,a,b,RT,m,n,zq,index},
		{m,n} = Take[Dimensions[A],2];
		{zq, index} = ZQn[R];
		If[zq, Mod[Det[A],index],
			If[m == n && CommutativeQ[R],
				F=((Det[Array[f,{n,n}]]/.{Times[-1,a_,b___]:>
					Times[negationOf[RT,a],b]})/.
						{Times[a_,b__]:>Fold[(Multiplication[RT][#1,#2])&,a,{b}]})/.
						{Plus[a_,b__]:>Fold[(Addition[RT][#1,#2])&,a,{b}]};
				F/.{f[i_,j_]:>A[[i,j]]}/.{RT->R}]]]

RingExtension /: Det[RingExtension[Matrices,R_,
	{n_,n_},t_, tom_, op_], A_]:=
	If[Take[Dimensions[A],2]=={n,n}, Det[R, A]]

Protect[Dot, Det];

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Working with elements
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
extracting parts of a matrix
:[font = input; initialization; preserveAspect; endGroup]
*)
LowerTriangleElements[A_?squareQ] := Module[{n = Length[A]},
	Flatten[Table[Take[A[[i]], {1, i-1}], {i, 2, n}],1]//Union]
	
UpperTriangleElements[A_?squareQ] := Module[{n = Length[A]},
	Flatten[Table[Take[A[[i]], {i+1, n}], {i, 1, n-1}],1]//Union]
	
DiagonalElements[A_?squareQ] := Module[{n = Length[A]},
	Flatten[Table[A[[i,i]], {i, n}],1]//Union]	
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Random matrices
:[font = input; initialization; preserveAspect; endGroup]
*)
RandomElement[RingExtension[Matrices,R_,{n_,n_},t_, tom_, op_]]:=
	RandomMatrix[R, n, MatrixType -> tom]

RandomElement[RingExtension[Matrices,R_,{m_,n_},t_, tom_, op_], opts___?OptionQ]:=
	Module[{sel = SelectBaseElementsFrom/.Flatten[{opts, Options[RandomElement]}],
		randels},
	randels = RandomElements[R, m*n, SelectFrom->sel];
	If[randels =!= $Failed, Partition[randels,n], $Failed]]

RandomElements[RingExtension[Matrices,R_,{m_,n_},t_, tom_, op_], k_Integer?Positive, 
		opts___?OptionQ]:=
	Module[{sel = SelectBaseElementsFrom/.Flatten[{opts, Options[RandomElements]}]},
		Table[RandomElement[RingExtension[Matrices,R,{m,n},t, tom, op], opts],{k}]]

RandomMatrix[R_?RingoidQ, n_Integer] := RandomMatrix[R,n,MatrixType -> All]

RandomMatrix[R_?RingoidQ, n_Integer, MatrixType -> type_] := 
	Switch[type,
		All, RandomAll[R,n],
		GL, RandomGL[R,n],
		SL, RandomSL[R,n],
		Diag, RandomDiag[R,n],
		UTD, RandomUTDiag[R,n],
		LTD, RandomLTDiag[R,n],
		UT, RandomUT[R,n],
		LT, RandomLT[R,n],
		_, Message[Random::notype, type];$Failed]

RandomGL[R_?RingoidQ,n_Integer] := Module[{els = Elements[R], A, 
		toomany = False, count = 0},
	A = RandomElements[els, n^2]//Partition[#, n]&;
	count++;
	While[Not[GLQ[R, A]] && Not[toomany],
		A = RandomElements[els, n^2]//Partition[#, n]&;
		count++;
		toomany = count > 500];
	If[toomany, Message[Random::toomany];$Failed, A]]
	
RandomSL[R_?RingoidQ,n_Integer] := Module[{A, det},
	A = RandomGL[R,n];
	If[Not[SLQ[R, A]],
		det = Det[R,A];
		A = MapAt[Multiplication[R][MultiplicativeInverse[R,det],
			#]&, A, Table[{1,k},{k,Length[A]}]]];
	A]

RandomDiag[R_?RingoidQ,n_Integer] := 
		Module[{toomany = False, count = 0, A, zero = Zero[R]},
	A = Table[Join[Table[zero,{i-1}],{RandomElement[Units[R]]}, 
		Table[zero,{j,i+1,n}]],{i,n}];
	count++;
	While[Not[GLQ[R, A]] && Not[toomany],
		A = Table[Join[Table[zero,{i-1}],{RandomElement[Units[R]]}, 
			Table[zero,{j,i+1,n}]],{i,n}];
		count++;
		toomany = count > 500];
	If[toomany, Message[Random::toomany];$Failed, A]]

RandomUTDiag[R_?RingoidQ,n_Integer] := 
		Module[{A, els = Elements[R],toomany=False, count = 0,
			zero = Zero[R],mat},
	mat := Table[Join[Table[zero,{i-1}],{RandomElement[Units[R]]},
		RandomElements[els, n-i]],{i,n}];
	A = mat;
	count++;
	While[Not[GLQ[R, A]] && Not[toomany],
		A = mat;
		count++;
		toomany = count > 500];
	If[toomany, Message[Random::toomany];$Failed, A]]

RandomLTDiag[R_?RingoidQ,n_Integer] := 
		Module[{A, els = Elements[R], toomany=False, count = 0,
			zero = Zero[R],mat},
	mat := Table[Join[RandomElements[els, i-1],{RandomElement[Units[R]]},
		Table[zero,{n-i}]],{i,n}];
	A = mat;
	count++;
	While[Not[GLQ[R, A]] && Not[toomany],
		A = mat;
		count++;
		toomany = count > 500];
	If[toomany, Message[Random::toomany];$Failed, A]]
	
RandomLT[R_?RingoidQ,n_Integer] := Module[{els = Elements[R], zero = Zero[R]},
	Table[Join[RandomElements[els, i-1], Table[zero,{n-i+1}]],{i,n}]]
		
RandomUT[R_?RingoidQ,n_Integer] := Module[{els = Elements[R],zero = Zero[R]},
	Table[Join[Table[zero,{i}], RandomElements[els, n-i]],{i,n}]]
		
RandomAll[R_?RingoidQ,n_Integer] := 
	Table[RandomElements[R, n],{i,n}]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Size & Elements
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
MakeMatrices[els_List,m_,n_] := MakeMatrices[els, m, n] = Module[{f},
	Map[Partition[#,n]&, Flatten[Outer[f,Sequence@@Table[els,{m * n}]]]]/.f->List
	]
	
Size[RingExtension[Matrices, R_?RingoidQ, {m_,n_}, test_, All,_]] := Size[R]^(m*n)

Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, GL,_]] := Module[{q = Size[R]},
	If[FieldQ[R], q^(n(n-1)/2)*Product[q^i - 1, {i, 1, n}], -1 (* not computed *)]]
	
Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, SL,_]] := Module[{q = Size[R]},
	If[FieldQ[R], q^(n(n-1)/2)*Product[q^i - 1, {i, 2, n}], -1(* not computed *)]]

Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, Diag,_]] := Length[Units[R]]^n

Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, UT,_]] := Size[R]^((n-1)n/2)

Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, LT,_]] := Size[R]^((n-1)n/2)

Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, LTD,_]] := Length[Units[R]]^n *
	Size[R]^((n-1)n/2)
	
Size[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, UTD,_]] := Length[Units[R]]^n *
	Size[R]^((n-1)n/2)

Options[Elements] := {SizeLimit -> 1500}

Elements[RingExtension[Matrices, R_?RingoidQ, {m_,n_}, test_,tom_, op_], opts___?OptionQ] := 
	Elements[RingExtension[Matrices, R, {m,n}, test,tom, op], opts] =
	Module[{size = Size[RingExtension[Matrices, R, {m,n}, test,tom, op]], sl = 
		SizeLimit/.Flatten[{opts, Options[Elements]}]},
	If[size < sl && size > 0,
		Switch[tom, 
			All, MakeMatrices[Elements[R],m,n], 
			GL, Select[MakeMatrices[Elements[R],m,n], GLQ[R,#]&],
			SL, Select[Elements[RingExtension[Matrices,R,{m,n},test,GL,Multiplication]], SLQ[R,#]&],
			Diag, Select[Elements[RingExtension[Matrices,R,{m,n},test,GL,Multiplication]], DiagQ[R,#]&],
			UTD, Select[Elements[RingExtension[Matrices,R,{m,n},test,GL,Multiplication]], UTDQ[R,#]&],
			LTD, Select[Elements[RingExtension[Matrices,R,{m,n},test,GL,Multiplication]], LTDQ[R,#]&],
			LT, Select[MakeMatrices[Elements[R],m,n], LTQ[R,#]&],
			UT, Select[MakeMatrices[Elements[R],m,n], UTQ[R,#]&]
			],
		Message[SizeLimit::toobig]; $Failed]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
General Matrix Functionality
:[font = input; initialization; preserveAspect; endGroup]
*)
CommutingMatricesQ[A_?MatrixQ, B_?MatrixQ] := A.B === B.A

CommutingMatricesQ[R_?RingoidQ, A_?MatrixQ, B_?MatrixQ] := Multiplication[R, A, B] === 
	Multiplication[R, B, A]
	
CommutingMatricesQ[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, tom_, op_], A_List, 
	B_List] := If[test[A] && test[B], Multiplication[R, A, B] === 
	Multiplication[R, B, A]]
	
AntiCommutingMatricesQ[A_?MatrixQ, B_?MatrixQ] := A.B === -(B.A)

AntiCommutingMatricesQ[R_?RingoidQ, A_?MatrixQ, B_?MatrixQ] := Multiplication[R, A, B] === 
	NegationOf[R,Multiplication[R, B, A]]
	
AntiCommutingMatricesQ[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, tom_, op_], A_List, 
	B_List] := If[test[A] && test[B], Multiplication[R, A, B] === 
	NegationOf[R,Multiplication[R, B, A]]]
	
MatrixTrace[A_?squareQ] := Sum[A[[i,i]], {i, Length[A]}]

MatrixTrace[R_?RingoidQ, A_?squareQ] := Fold[Addition[R],
			A[[1,1]], Table[A[[i,i]], {i, 2, Length[A]}]]

SymmetricQ[A_?squareQ] := A === Transpose[A]

SymmetricQ[R_?RingoidQ, A_?squareQ] := SymmetricQ[A]

SkewSymmetricQ[A_?squareQ] := A === - Transpose[A]

SkewSymmetricQ[R_?RingoidQ, A_?squareQ] := A === NegationOf[R,Transpose[A]]

Unprotect[Conjugate];

Conjugate[A_?MatrixQ] := Map[Conjugate, A, {2}]

Protect[Conjugate];

MatrixConjugate[A_?MatrixQ] := Map[Conjugate, A, {2}]

MatrixDelete[A_?MatrixQ, {i_Integer?Positive, j_Integer?Positive}] :=
	Module[{k, {m,n} = Take[Dimensions[A],2]},
		Drop[Table[Join[Take[A[[k]], {1, i-1}],Take[A[[k]], {i+1, n}]], 
			{k,m}],{j}]]
			
DetAdjoint[A_?squareQ] := Module[{},
	Table[(-1)^(i+j) Det[Transpose[MatrixDelete[A,{i,j}]]],{i,Length[A]},
		{j, Length[A]}]]

Adjoint[A_?squareQ] := Transpose[MatrixConjugate[A]]

HermitianQ[A_?squareQ] := A === Adjoint[A]

SkewHermitianQ[A_?squareQ] := A === -Adjoint[A]

IntegerMatrixQ[A_?MatrixQ] := And@@Flatten[Map[IntegerQ, A, {2}],1]

RationalMatrixQ[A_?MatrixQ] := And@@Flatten[Map[(IntegerQ[#] || Head[#]===Rational)&, 
	A, {2}],1]
	
RealMatrixQ[A_?MatrixQ] := And@@Flatten[Map[(IntegerQ[#] || Head[#]===Real)&, 
	N[A], {2}],1]
	
ComplexMatrixQ[A_?MatrixQ] := And@@Flatten[Map[(Head[#]===Real || 
	IntegerQ[#] || Head[#] === Complex)&, N[A], {2}],1]
	
MatrixOverQ[R_?RingoidQ, A_?MatrixQ] := ElementsQ[Flatten[A,1],R]
	
OrthogonalQ[A_?squareQ] := RealMatrixQ[A] && Transpose[A].A === IdentityMatrix[Length[A]]

OrthogonalQ[R_?RingoidQ, A_?squareQ] :=  MatrixOverQ[R, A] && 
	Multiplication[R,Transpose[A],A] === IdentityMatrix[R,Length[A]]

UnitaryQ[A_?squareQ] := A.Adjoint[A] === IdentityMatrix[Length[A]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
ToGroupoid/ToRingoid
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[ToRingoid] = {SizeLimit -> 1000};

ToRingoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, All, 
	Both], opts___?OptionQ] := 
		Module[{size, G, AG,
			ext = RingExtension[Matrices, R, {n,n}, test, All, Both]},
	If[(size = Size[ext]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormRingoid[Elements[ext], Addition[ext][#1,#2]&,
			Multiplication[ext][#1,#2]&, {"+","*"},
			WideElements -> True, 
			RingoidDescription -> ToString[n]<>" by "<>ToString[n]<>
				" matrices over "<>RingoidName[R], 
			RingoidName -> 
				SequenceForm["-",Subscripted["Mat"["("<>ToString[n]<>")"]],
	"("<>RingoidName[R]<>")-"], MaxElementsToList -> 32];
		Unity[G] = IdentityMatrix[R, n];
		WithUnityQ[G] = True;
		AssociativeQ[G] = True;
		DistributiveQ[G] = DistributiveQ[R];
		AG = AGroupoid[G];
		HasIdentityQ[AG] = HasZeroQ[R];
		AssociativeQ[AG] = True;
		AbstractAlgebra`Core`Private`inverseFunction[MGroupoid[G]] = 
			MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]
		
ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, All, 
	Multiplication], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, All, Multiplication]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, All,_]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, All,Multiplication]][#1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["Mat"["("<>ToString[n]<>")"]],
	"("<>RingoidName[R]<>")-"], MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]
			
ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {m_,n_}, test_, All, Addition], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {m,n}, test, All,Addition]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {m,n}, test, All,_]],
			Addition[RingExtension[Matrices, R, {m,n}, test, All,Addition]][#1,#2]&, "+",
			WideElements -> True, GroupoidDescription -> ToString[m]<>" by "<>ToString[n]<>
			" matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["Mat"["("<>ToString[m]<>","<>ToString[n]<>")"]],
	"("<>RingoidName[R]<>")-"], MaxElementsToList -> 32];
		GroupIdentity[G] = Zero[RingExtension[Matrices,R,{m, n},test, LT, Addition]];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = NegationOf[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, All, 
	Both], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, All, Both]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, All,_]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, All,Multiplication]][#1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["Mat"["("<>ToString[n]<>")"]],
	"("<>RingoidName[R]<>")-"], MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {m_,n_}, test_, GenA, Addition], 
	opts___?OptionQ] := ToGroupoid[RingExtension[Matrices, R, {m,n}, test, All, Addition], 
	opts]
	
ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {m_,n_}, test_, GenM, Multiplication], 
	opts___?OptionQ] := ToGroupoid[RingExtension[Matrices, R, {m,n}, test, All, Multiplication], 
	opts]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, GL, Multiplication], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, 
			GL,Multiplication]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, GL,_]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, GL,Multiplication], #1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" invertible matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["GL"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, SL, Multiplication], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, SL,
			Multiplication]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, SL,_]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, SL,Multiplication]][#1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" invertible matrices over "<>RingoidName[R]<>" with Det(A) = 1", GroupoidName -> 
			SequenceForm["-",Subscripted["SL"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, Diag, Multiplication], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, Diag,
			Multiplication]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, Diag,Multiplication]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, Diag,Multiplication]][#1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" diagonal matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["Diag"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, UT, Addition], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, UT, Addition]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, UT, Addition]],
			Addition[RingExtension[Matrices, R, {n,n}, test, UT, Addition]][#1,#2]&, "+",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" upper triangular matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["UT"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = Zero[RingExtension[Matrices,R,{n, n},test, LT, Addition]];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = NegationOf[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, LT, Addition], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, LT, Addition]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, LT, Addition]],
			Addition[RingExtension[Matrices, R, {n,n}, test, LT, Addition]][#1,#2]&, "+",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" lower triangular matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["LT"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = Zero[RingExtension[Matrices,R,{n, n},test, LT, Addition]];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = NegationOf[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, UTD, Multiplication], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, UTD, Multiplication]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, UTD, Multiplication]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, UTD, Multiplication]][#1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" upper triangular (with diagonal) matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["UTD"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]

ToGroupoid[RingExtension[Matrices, R_?RingoidQ, {n_,n_}, test_, LTD, Multiplication], opts___?OptionQ] := 
		Module[{size,G},
	If[(size = Size[RingExtension[Matrices, R, {n,n}, test, LTD, Multiplication]]) < 
			SizeLimit/.Flatten[{opts, Options[Elements]}],
		G = FormGroupoid[Elements[RingExtension[Matrices, R, {n,n}, test, LTD, Multiplication]],
			Multiplication[RingExtension[Matrices, R, {n,n}, test, LTD, Multiplication]][#1,#2]&, "*",
			WideElements -> True, GroupoidDescription -> ToString[n]<>" by "<>ToString[n]<>
			" lower triangular (with diagonal) matrices over "<>RingoidName[R], GroupoidName -> 
			SequenceForm["-",Subscripted["LTD"[ToString[n]]],"("<>RingoidName[R]<>")-"],
			MaxElementsToList -> 32];
		GroupIdentity[G] = IdentityMatrix[R, n];
		HasIdentityQ[G] = True;AssociativeQ[G] = True;
		AbstractAlgebra`Core`Private`inverseFunction[G] = MultiplicativeInverse[R, #]&;
		G,
		Message[SizeLimit::toobig]; $Failed]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Later
:[font = input; preserveAspect; endGroup]
(*RandomElement[Mat[n_Integer?Positive, Z],max_:100] :=
	Table[Random[Integer,{-max,max}],{n},{n}]
		
RandomElement[Mat[n_Integer?Positive, k_Integer?Positive]] :=
	Table[Random[Integer,{0,k-1}],{n},{n}]
	
RandomElements[Mat[n_Integer?Positive, Z],max_:100, num_Integer?Positive] :=
	Table[RandomElement[Mat[n,Z],max],{num}]
		
RandomElements[Mat[n_Integer?Positive, k_Integer?Positive], num_Integer?Positive] :=
	Table[RandomElement[Mat[n,k]],{num}]  
	
Mat[n_,2] := With[{ma = MatA[n,2]},
	FormRingoid[Elements[ma],Operation[ma],Operation[MatM[n,2]],
	WideElements->True]]
	
Mat[n_,3] := With[{ma = MatA[n,3]},
	FormRingoid[Elements[ma],Operation[ma],Operation[MatM[n,3]],
	WideElements->True]]*)                      
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Wrapup AbstractAlgebra`Matrices
:[font = input; initialization; preserveAspect]
*)
End[];
EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
