(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Ringoids` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`Ringoids *)

(* :Context: AbstractAlgebra`Ringoids` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)


(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Startup AbstractAlgebra`Ringoids
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Ringoids`",
{"AbstractAlgebra`Core`",
"Graphics`Graphics`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];

Off[AppendTo::rvalue];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
BooleanRing::usage = "BooleanRing[n] constructs the Boolean Ring
consisting of the set of subsets of {1, 2, ..., n} with the operations
symmetric difference and intersection. BooleanRing[B] constructs the
ring with subsets of the list B.";

FormRingoidByTable::usage = "FormRingoidByTable[list, additiontab,
multiplicationtab, opts] is a command for generating a Ringoid
consisting of the elements in list and governed by the operations
implicit in the Cayley tables additiontab and multiplicationtab. The
options for opts can be: WideElements, IsARing, RingoidDescription,
RingoidName, FormatOperator, FormatElements, MaxElementsToList, KeyForm,
and CayleyForm. See each of these individually for more information.";

LatticeRing::usage = "LatticeRing[n] returns the Ringoid of divisors of
n with LCM/GCD for addition and GCD for multiplication.";

TrivialZR::usage = "TrivialZR[n] returns the ring of integers mod n with
mod n addition but a multiplication with all products being zero.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
(* Dot::DimErr="Dimensions of parameters to Dot fail to match.";*)

FormRingoid::diffels = "In forming a Ringoid in this fashion, the list
of elements in the first Groupoid, `1`, must match those in the second
Groupoid, `2`.";

FormRingoid::size = "The index for this structure needs to be less than `1`,
which `2` is not.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Begin private
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Misc. startup code
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
general
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Formation of Ringoids
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 Another FormRingoid
:[font = input; initialization; preserveAspect; endGroup]
*)
FormRingoid[G1_?GroupoidQ, G2_?GroupoidQ, opts___?OptionQ] :=
	If[SameSetQ[Elements[G1], Elements[G2]],
		FormRingoid[Elements[G1], Operation[G1], Operation[G2], 
			opts],
		Message[FormRingoid::diffels, Elements[G1], Elements[G2]]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.3 FormRingoidByTable
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
FormRingoidByTable[list_List,additiontab_List, multiplicationtab_List,
		opsymbols_List:{"+","*"}, opts___?OptionQ] :=
	Module[{R,wideq,ringq,genset,rngdesc,rngnm,optional,formop,
	formels,maxshow,keyForm,cayleyForm, ei, add, mult},
		wideq = WideElements/.Flatten[{opts, Options[FormRingoid]}];
		ei = AbstractAlgebra`Core`Private`ExtraInformation/.Flatten[{opts, 
			Options[AbstractAlgebra`Core`Private`FormRingoidExtra]}];
		ringq = IsARing/.Flatten[{opts, Options[FormRingoid]}];
		rngdesc = RingoidDescription/.Flatten[{opts, Options[FormRingoid]}];
		rngnm = RingoidName/.Flatten[{opts, Options[FormRingoid]}];
		formop = FormatOperator/.Flatten[{opts, Options[FormRingoid]}];
		keyForm = KeyForm/.Flatten[{opts, Options[FormRingoid]}];
		cayleyForm = CayleyForm/.Flatten[{opts, Options[FormRingoid]}];
		formels = FormatElements/.Flatten[{opts, Options[FormRingoid]}];
		maxshow = MaxElementsToList/.Flatten[{opts, Options[FormRingoid]}];
		add = (additiontab[[#1//Position[list,#]&//First,
    	#2//Position[list,#]&//First]]//Flatten//First)&;
    mult = (multiplicationtab[[#1//Position[list,#]&//First,
			#2//Position[list,#]&//First]]//Flatten//First)&;
		AppendTo[ei, {opts}];
		R = AbstractAlgebra`Core`Private`ringoid[list, add, mult, ei];
		AbstractAlgebra`Core`Private`FormatOpQ[R] = formop;
		AbstractAlgebra`Core`Private`FormatElsQ[R] = If[Length[list] > maxshow, True, formels];
		AbstractAlgebra`Core`Private`WideElementsQ[R] = wideq;
		KeyForm[R] = keyForm;
		CayleyForm[R] = cayleyForm;
		If[ringq,ringQ[R] = ringq];
		RingoidDescription[R] = rngdesc;
		RingoidName[R] = If[rngnm === "", "TheRing", rngnm];
		If[AbstractAlgebra`Core`Private`untestedQ[RingInfo[R]],
			RingInfo[R] = {};
			If[rngnm =!= "", AppendTo[RingInfo[R],rngnm]];
			If[rngdesc =!= "", AppendTo[RingInfo[R],rngdesc]];
			];
		(* start tracking info about groupoid if not yet started *)
		PlusSymbol[R] = opsymbols[[1]];
		TimesSymbol[R] = opsymbols[[2]];
		R]
(* note that the R created is a ringoid not Ringoid *)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Construction of basic rings
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[TrivialZR] = {};

TrivialZR[n_/;(n >= 2)] := TrivialZR[n] = Module[{R},
	R = FormRingoid[Range[0, n-1], Mod[#1 + #2,n]&, 0&, {"+","0"},
		RingoidName -> "Trivial["<>ToString[n]<>"]", RingoidDescription -> 
		"the trivial Ring mod "<>ToString[n]];
	R]

BooleanRing[n_Integer?NonNegative/;n<=6] := BooleanRing[n]=
   FormRingoid[Range[2^n,2^(n+1)-1]//
          Map[IntegerDigits[#,2]&,#]&//
          Map[Rest,#]&//
          Map[(Range[1,n]*#)&,#]&//
          Map[Select[#,(#>0)&]&,#]&,
          Union[Complement[#1,#2],Complement[#2,#1]]&,
          Intersection[#1,#2]&,
          RingoidName -> "Bool["<>ToString[n]<>"]",
          RingoidDescription -> "the boolean Ring on {1,...,"<>ToString[n]<>"}",
          WideElements->True]

BooleanRing[n_Integer?NonNegative] := (Message[FormRingoid::size, 7, n]; $Failed)

BooleanRing[B_List] := BooleanRing[B] =
				FormRingoid[Elements[BooleanRing[Length[B]]//
           MapAt[(#/.Inner[Rule,Range[1,Length[B]],Sort[B],List])&,
                  #,1]&],
           Union[Complement[#1,#2],Complement[#2,#1]]&,
          Intersection[#1,#2]&,
          RingoidName -> "Bool["<>ToString[B]<>"]",
          RingoidDescription -> "Boolean Ring on "<>ToString[Sort[B]],
          WideElements->True]      
                      
LatticeRing[n_/;(n>=2)] := FormRingoid[Divisors[n],
	(LCM[#1,#2]/GCD[#1,#2])&, GCD[#1,#2]&, RingoidName -> 
	"Lattice["<>ToString[n]<>"]", RingoidDescription -> 
	"the lattice Ring of divisors of "<>ToString[n]];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Wrapup AbstractAlgebra`Ringoids
:[font = input; initialization; preserveAspect]
*)
End[];

EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
