(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 1. Using symmetry to uncover a group
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
There are no prerequisites for this lab.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
In this lab, we will try to discover some of the basic properties of a group by considering the symmetries of a regular triangle.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.3 Getting started? - begin here
:[font = text; inactive; preserveAspect; nohscroll; ]
In most of the labs in Exploring Abstract Algebra with Mathematica, one needs to first read in the Mathematica packages necessary to provide the functionality within the lab. This is done using a Needs statement, as below. (By opening the AbstractAlgebra`Master` package, any function will be available.) Upon opening this notebook, you were likely asked "Do you want to automatically evaluate all the initialization cells in the Notebook?". If you answered affirmatively, then you do not need to evaluate the following cell (but it doesn't hurt to do so). If you answered negatively, then you need to evaluate this cell.
:[font = input; initialization; preserveAspect; endGroup; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.4 A symmetry of an equilateral triangle
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we consider an equilateral triangle with its vertices labeled with the numbers 1, 2, and 3 as below. (Evaluate the cell, but do not worry about the parameters 3, {1,2,3}, and "D.")
:[font = input; preserveAspect; nowordwrap; ]
triangle = ShowFigure[3, {1, 2, 3}, "D"];
:[font = text; inactive; preserveAspect; nohscroll; ]
We might think about how we can "move" this triangle so that after the "movement," it appears as if it was not moved at all, except for a new ordering of the labels on the vertices. For example, suppose we draw an imaginary line from the vertex labeled 3 perpendicularly to the side opposite and then reflect the triangle in (across) this line, as seen below. (Evaluate the following cell.)
:[font = input; preserveAspect; nowordwrap; ]
Show[triangle, Epilog -> {Blue, Line[{{0, -1.5},
{0, 2.0}}]}];
:[font = text; inactive; preserveAspect; nohscroll; ]
After reflecting the triangle across the blue line, we have the following result (evaluate):
:[font = input; preserveAspect; nowordwrap; ]
ShowPermutation[{1 -> 2, 2 -> 1, 3 -> 3}]
:[font = text; inactive; preserveAspect; nohscroll; ]
This reflection is an example of a (geometric) transformation called a symmetry. Note that there are changes in the location of the vertices: vertex 1 went to the previous location of vertex 2, vertex 2 went to vertex 1, and vertex 3 went back to itself. This is called a permutation of the vertices. One way to represent this permutation in Mathematica is by 
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
{1 -> 2, 2 -> 1, 3 -> 3}. 
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that even though vertex 3 went to itself, it needs to be included in the permutation list. Observe that braces are used to contain the whole list. Let's denote this first permutation by p[1]. It is defined below (yes, evaluate it): 
:[font = input; preserveAspect; endGroup; nowordwrap; ]
Clear[p]
p[1] = {1 -> 2, 2 -> 1, 3 -> 3}
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5 Are there other symmetries?
:[font = text; inactive; preserveAspect; nohscroll; ]
What other symmetries (permutations) are there? Let's label each of the others p[2], p[3], etc., and create the rules to form them. (Note that the rule symbol -> is a hyphen followed by a greater-than sign.) As you discover each permutation, type p[k] = {1 -> x, 2 -> y, 3 -> z}, where you supply appropriate values for k, x, y, and z. We will give you one more.
:[font = input; preserveAspect; nowordwrap; ]
p[2] = {1 -> 2, 2 -> 3, 3 -> 1}
:[font = text; inactive; preserveAspect; nohscroll; ]
To test if p[k] is really a valid permutation of this triangle, and to see the result geometrically, type ShowPermutation[p[k]]. 
:[font = input; preserveAspect; nowordwrap; ]
ShowPermutation[p[2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that the permutation {1 -> 2, 2 -> 3, 3 -> 1} can also be determined by considering only the second "coordinates" of each rule (x -> y), since the first coordinates are always the same for each of these permutations. Here is a matrix view of this permutation:
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[{1 -> 2, 2 -> 3, 3 -> 1}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note how each column represents a rule of the form x -> y. Therefore, the list {2, 3, 1} can also be used to represent p[2] = {1 -> 2, 2 -> 3, 3 -> 1}. So one could type
:[font = input; preserveAspect; nowordwrap; ]
p[2] = {2, 3, 1}
:[font = text; inactive; preserveAspect; nohscroll; ]
and then 
:[font = input; preserveAspect; nowordwrap; ]
ShowPermutation[p[2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
would give the same result. (You have been evaluating each input cell as you read along, right?)
:[font = text; inactive; preserveAspect; nohscroll; ]
The function ShowPermutation is set up to accept either notation.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Describe geometrically what the permutation p[2], as illustrated above, does to the triangle.
:[font = special2; inactive; preserveAspect; nohscroll; backColorRed = 49344; backColorGreen = 49344; backColorBlue = 49344; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 65535; plain; fontName = "Times New Roman"; fontSize = 12; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. How many other symmetries of the triangle (in permutation form) can you find? Label them p[3] etc., as indicated above, and test each one (with ShowPermutation) to see if the symmetry does what you thought. As you define each p[k], place in (* comments *) (or in a text-type cell) a geometric description of what the symmetry does to the triangle.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. How many (distinct and unique) symmetries have you found altogether (including p[1] and p[2])?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.6 Multiplying our transformations
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we would like to know the interrelationships, if any, between these various symmetries. For instance, suppose we first applied the symmetry given by permutation p[1] and then followed this with the symmetry given by p[2]. What would the figure look like? Is there a permutation in your list that would give this "product"? 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Take a moment and see if you can figure out what this product of p[1] followed by p[2] would be. If you have an answer, how did you come up with it?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Later we will learn more of the details of how we "multiply" permutations, but for now just assume that it can be done and allow Mathematica to do it for you. We will use the function MultiplyPermutations to do this. (If you do know how to do this, we assume the product works from right to left.) For the particular question posed above, evaluate the following to obtain the result. (First, we review the definitions of the permutations p[2] and p[1].)
:[font = input; preserveAspect; nowordwrap; ]
p[1]

p[2]
:[font = input; preserveAspect; nowordwrap; ]
prod = MultiplyPermutations[p[2], p[1], Mode -> Textual]
:[font = text; inactive; preserveAspect; nohscroll; ]
This yields the permutation that is the product of p[1] followed by p[2]. (Note the order of the arguments in MultiplyPermutations.) Now evaluate the following cell:
:[font = input; preserveAspect; nowordwrap; ]
ShowPermutation[prod]
:[font = text; inactive; preserveAspect; nohscroll; ]
This draws the original triangle and the triangle resulting from the product of p[1] followed by p[2]. How does the second triangle compare to the first and how does the answer given above for prod (which should have been {3, 2, 1}) relate to the transformation that changes the first triangle into the second? 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Does the permutation given by {3, 2, 1} represent a symmetry of the triangle? If so, describe the symmetry geometrically. Is it among the list of permutations that you found in question 2?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.7 Are there any commuters?
:[font = text; inactive; preserveAspect; nohscroll; ]
Evaluate the following:
:[font = input; preserveAspect; nowordwrap; ]
MultiplyPermutations[p[1], p[2], Mode -> Textual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Did you get the same result as when you did MultiplyPermutations[p[2], p[1]]? Why or why not? What does this say about the operation of multiplying permutations? Can you think of a mathematical term used to describe this?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.8 Is it always bad to be closed-minded?
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we want to set up a complete "multiplication" table of all possible products, as you did with addition and multiplication when a student in elementary school. Set up your table as follows:
:[font = text; inactive; preserveAspect; nohscroll; ]
         p[1]          p[2]         p[3]      ...            
p[1]

p[2]

p[3]
  .
  .
  .
  
:[font = text; inactive; preserveAspect; nohscroll; ]
The top row and left column simply act as labels for the table. The body of the table is filled in by multiplying the row entries by the column entries. For example, the entry in row three, column two can be obtained by evaluating 
:[font = input; preserveAspect; nowordwrap; ]
MultiplyPermutations[p[3], p[2]]

(* note that this product only makes sense if you have
already defined p[3] as a permutation *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Note the order: the entry in position (i, j) (row i, column j) results from first performing the permutation corresponding to the one in column j followed by the one in row i, but when one enters this into the function MultiplyPermutations, the order is reversed. (You might wonder why this is the case. It will become clearer when you study permutations in more detail, but for now consider as a hint that a permutation is really a function and multiplying permutations is actually composing functions, usually done from right to left.)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Complete the table given above (using p[i] notation for each product, where possible).
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
If you find that you obtain a product that is not in your original list, perhaps you need to look over your list and possibly make changes to it. Eventually, your list should terminate and the result of the product of any two should be one that is already in your list. In this case, the body of the table should consist of only the elements listed in the column or row headings. We then say that the set of elements (symmetries of the triangle, as represented by the permutations, in this case) is said to be closed under this product.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.9 We should try to find our identity
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. When we consider addition of real numbers, we have r + 0 = 0 + r = r for all real numbers r. Similarly, with multiplication of real numbers, we have r * 1 = 1 * r = r. Does an analogous situation occur with the symmetries of the triangle? Is there any symmetry (say, permutation p[j]) which, when followed by another symmetry (p[i]), yields the product consisting of simply the second symmetry (p[i]) (i.e., MultiplyPermutations[p[i], p[j]] = p[i])? If so, what is this p[j] and what is special about it? Do we have a name for such objects as 0, 1, and p[j]?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.10 Is it perverse to not have an inverse?
:[font = text; inactive; preserveAspect; nohscroll; ]
In the section above we found an identity (or should have) that takes every vertex of the triangle back to itself (i.e., leaves the triangle unchanged). Recall that with addition of real numbers, since 0 is the additive identity, for any real number r, there is another real number called -r such that r + (-r) = (-r) + r = 0. Similarly, with multiplication of real numbers, for any r not equal to 0, there exists 1/r such that r * 1/r = (1/r) * r = 1 (and recall that 1 is the multiplicative identity).
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Given a symmetry (permutation) p[i], is there another symmetry p[j] such that MultiplyPermutations[p[i], p[j]] yields this identity found above? If so, then we say p[j] is the inverse of p[i] (and p[i] is the inverse of p[j]). Does every symmetry found (when answering question 7) have an inverse? For each of the symmetries, determine the inverse (where possible). Below, list the elements and their corresponding inverses? Any observations?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.11 Should we associate together?
:[font = text; inactive; preserveAspect; nohscroll; ]
Again, appealing to addition and multiplication of real numbers, recall that 
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
(a + b) + c = a + (b + c)  and 
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
(a b) c = a (b c) 
:[font = text; inactive; preserveAspect; nohscroll; ]
for all real numbers a, b, and c. These equations say that both addition and multiplication of real numbers satisfy the associative property. 
:[font = text; inactive; preserveAspect; nohscroll; ]
Another question one might ask is whether we have associativity of permutations. In other words, is it true that MultiplyPermutations[p[i], MultiplyPermutations[p[j], p[k]]] = MultiplyPermutations[MultiplyPermutations[p[i], p[j]], p[k]] for all i, j, and k? This is comparable to asking if a + (b + c) = (a + b) + c. (Convince yourself of this.) Below is the Mathematica code to determine this. You have a choice of checking every possibility or you can choose to do a certain number of random checks. Do one test or the other. (If you check every possibility, in this case this amounts to 6^3 = 216 possibilities. Do you know why?)
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
 test every possibility
:[font = text; inactive; preserveAspect; nohscroll; ]
To do the test below, it is assumed that you found exactly six permutations (which is how many there are) and that you have defined them in the variables p[1], p[2], ..., p[5], p[6].
:[font = input; preserveAspect; endGroup; nowordwrap; ]
assoc = True;
Do[temp = MultiplyPermutations[p[i], 
	MultiplyPermutations[p[j], p[k] ] ] === 
	MultiplyPermutations[ MultiplyPermutations[p[i],
		p[j] ], p[k] ];
	(* let temp indicate whether or not we have associativity
	for the three indices i, j, and k *)
	assoc = And[assoc,temp], 
	(* if temp is ever False, assoc becomes False *)
	{i, 6}, {j, 6}, {k, 6}];
	
assoc
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
 test a random number of times
:[font = text; inactive; preserveAspect; nohscroll; ]
To do the test below, it is assumed that you found exactly six permutations (which is how many there are) and that you have defined them in the variables p[1], p[2], ..., p[5], p[6].
:[font = input; preserveAspect; endGroup; nowordwrap; ]
checkThisMany = 32; (* how many times do you want to test? *)

randfn[_] := Random[Integer, {1, 6}]

assoc = True;
Do[index1 = randfn[1]; index2 = randfn[2]; index3 = randfn[3];
	temp = MultiplyPermutations[p[index1], 
	MultiplyPermutations[p[index2], p[index3] ] ] ===
	MultiplyPermutations[ MultiplyPermutations[p[index1], 
	p[index2] ], p[index3] ];
	(* let temp indicate whether or not we have associativity
	for the three indices index1, index2, and index3 *)
	assoc = And[assoc,temp], 
	(* if temp is ever False, assoc becomes False *)
{checkThisMany}];
assoc
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
 now the question:
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Do you think that multiplication of these symmetries (permutations) is associative? Why or why not?
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.12 What else?
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. What other observations, if any, can you make from these explorations?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.13 Let's group it all together
:[font = text; inactive; preserveAspect; nohscroll; ]
The collection of the six symmetries of the triangle---you found all six, right?---with the product of one transformation followed by another (but here viewed as six permutations with multiplication of the permutations) is an example of a set with a binary operation. Below is a formal definition of what we have been investigating.
:[font = text; inactive; preserveAspect; nohscroll; ]
Given a set G and an operation *, if

1. this set is closed under this operation (i.e., g * h is in G for all g and h in G);

2. among the elements there exists an identity (i.e., there exists an e in G such that e * g = g * e = g for all g in G);

3. each element has an inverse among the set of elements (i.e., for all g in G, there exists h in G such that g * h = e);

4. the operation is associative (i.e., f * (g * h) = (f * g) * h for all f, g, and h in G),
 
then we call G a group. Furthermore, if we have g * h = h * g for all g and h in G, we call G a commutative (or Abelian) group. We will be studying the properties of groups in this course.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Is the set of six symmetries (permutations) with the operation of following one transformation by another (i.e., multiplying the permutations) an example of a group? Why or why not? Is it Abelian? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Can you think of another example of a set with an operation that might be a group?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.14 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Needs
:[font = input; preserveAspect; nowordwrap; ]
?SwitchStructureTo
:[font = input; preserveAspect; nowordwrap; ]
?ShowPermutation
:[font = input; preserveAspect; nowordwrap; ]
?Clear
:[font = input; preserveAspect; nowordwrap; ]
?PermutationMatrix
:[font = input; preserveAspect; nowordwrap; ]
?MultiplyPermutations
:[font = input; preserveAspect; nowordwrap; ]
?Mode
:[font = input; preserveAspect; nowordwrap; ]
?Textual
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Random
^*)