(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 2. Determining the symmetry group of a given figure
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Though not absolutely necessary, it would be useful if you completed Group Lab 1 before attempting this lab.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
In this lab, we will continue to look at symmetries. This will resume where Lab One left off. The goal is to find the complete list of symmetries (via permutations) for a variety of (more or less) random figures. When "complete," this list should comprise the "symmetry group" of the object.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3 Symmetries and how to find them
:[font = text; inactive; preserveAspect; nohscroll; ]
To start this lab, the following package needs to be read into Mathematica. 
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the following array of figures.
:[font = postscript; inactive; locked; output; preserveAspect; BITMAP; PostScript; pictureLeft = 35; pictureTop = 0; pictureWidth = 492; pictureHeight = 244; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119048 0.47619 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.0119048 0.477324 0.238662 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.25 0.190476 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
.74 .99 .79 r
.02 w
.88095 .44048 m
.88095 .05952 L
.11905 .44048 L
.11905 .05952 L
s
P
p
[(1)] .97619 .4881 0 0 Mshowa
[(2)] .97619 .0119 0 0 Mshowa
[(3)] .02381 .0119 0 0 Mshowa
[(4)] .02381 .4881 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.88095 .44048 Mdot
P
p
0 1 0 r
.035 w
.88095 .05952 Mdot
P
p
0 0 1 r
.035 w
.11905 .05952 Mdot
P
p
1 1 0 r
.035 w
.11905 .44048 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119048 0.97619 0.238662 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.400557 0.459434 0.400557 [
[ 0 0 0 0 ]
[ 1 .98355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .98355 L
0 .98355 L
closepath
clip
newpath
p
p
p
.74 .99 .79 r
.88095 .58321 m
.73544 .13538 L
.26456 .13538 L
.11905 .58321 L
.5 .85999 L
F
P
p
0 0 0 r
.004 w
.88095 .58321 m
.73544 .13538 L
.26456 .13538 L
.11905 .58321 L
.5 .85999 L
.88095 .58321 L
s
P
P
p
[(1)] .97619 .61416 0 0 Mshowa
[(2)] .7943 .05436 0 0 Mshowa
[(3)] .2057 .05436 0 0 Mshowa
[(4)] .02381 .61416 0 0 Mshowa
[(5)] .5 .96013 0 0 Mshowa
P
p
.004 w
.73544 .13538 m
.69906 .02342 L
s
.26456 .13538 m
.14684 .13538 L
s
.11905 .58321 m
.08267 .69517 L
s
.5 .85999 m
.59524 .92919 L
s
.88095 .58321 m
.97619 .51402 L
s
P
p
p
1 0 0 r
.035 w
.88095 .58321 Mdot
P
p
0 1 0 r
.035 w
.73544 .13538 Mdot
P
p
0 0 1 r
.035 w
.26456 .13538 Mdot
P
p
1 1 0 r
.035 w
.11905 .58321 Mdot
P
p
.628 .126 .941 r
.035 w
.5 .85999 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.261338 0.477324 0.488095 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.25 0.190476 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
.74 .99 .79 r
.88095 .44048 m
.88095 .05952 L
.11905 .05952 L
.11905 .44048 L
F
P
p
[(1)] .97619 .4881 0 0 Mshowa
[(2)] .97619 .0119 0 0 Mshowa
[(3)] .02381 .0119 0 0 Mshowa
[(4)] .02381 .4881 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.88095 .44048 Mdot
P
p
0 1 0 r
.035 w
.88095 .05952 Mdot
P
p
0 0 1 r
.035 w
.11905 .05952 Mdot
P
p
1 1 0 r
.035 w
.11905 .44048 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.261338 0.97619 0.488095 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.386829 0.477823 0.386829 [
[ 0 0 0 0 ]
[ 1 .98481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .98481 L
0 .98481 L
closepath
clip
newpath
p
p
p
.74 .99 .79 r
.74865 .77415 m
.88095 .545 L
.835 .28441 L
.6323 .11432 L
.3677 .11432 L
.165 .28441 L
.11905 .545 L
.25135 .77415 L
.5 .86465 L
F
P
p
0 0 0 r
.004 w
.74865 .77415 m
.88095 .545 L
.835 .28441 L
.6323 .11432 L
.3677 .11432 L
.165 .28441 L
.11905 .545 L
.25135 .77415 L
.5 .86465 L
.74865 .77415 L
s
P
P
p
[(1)] .81081 .84823 0 0 Mshowa
[(2)] .97619 .56179 0 0 Mshowa
[(3)] .91875 .23606 0 0 Mshowa
[(4)] .66538 .02345 0 0 Mshowa
[(5)] .33462 .02345 0 0 Mshowa
[(6)] .08125 .23606 0 0 Mshowa
[(7)] .02381 .56179 0 0 Mshowa
[(8)] .18919 .84823 0 0 Mshowa
[(9)] .5 .96136 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.74865 .77415 Mdot
P
p
0 1 0 r
.035 w
.88095 .545 Mdot
P
p
0 0 1 r
.035 w
.835 .28441 Mdot
P
p
1 1 0 r
.035 w
.6323 .11432 Mdot
P
p
.628 .126 .941 r
.035 w
.3677 .11432 Mdot
P
p
1 .5 0 r
.035 w
.165 .28441 Mdot
P
p
.251 .878 .816 r
.035 w
.11905 .545 Mdot
P
p
.69 .188 .377 r
.035 w
.25135 .77415 Mdot
P
p
0 0 .502 r
.035 w
.5 .86465 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; nohscroll; ]
When we look for the "symmetry group" of any one of these objects, we are looking for a complete list of symmetries for the object. (Technically, a symmetry of an object F is an isometry  that maps F onto itself, with distances being preserved. Since an isometry is actually a function, the "natural" way of combining symmetries is to use function composition.) 

Symmetries can come in several varieties. Often these involve rotations about a certain point (the "center"), through some angle. For example, in the figure in the upper left, if we rotate about the center of the rectangle (where the diagonals intersect) through an angle of 180 degrees, this will place the figure back onto itself. Note that the figure does NOT include the colored and labeled dots used to mark the vertices; these are only tags to help coordinate the movements. With the rotation just described, observe that vertices 1 and 3 are interchanged, as are vertices 2 and 4. We can describe this by
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
{1 -> 3, 2 -> 4, 3 -> 1, 4 -> 2}
:[font = text; inactive; preserveAspect; nohscroll; ]
or, in block permutation notation,
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[{1 -> 3, 2 -> 4, 3 -> 1, 4 -> 2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
or, as you may recall from the last lab, this can also be written as {3, 4, 1, 2} which constitutes the second coordinates or row of the representations above. Each of these is a representation for the permutation of the vertices that corresponds to the described rotational symmetry. Thus, we can say that the permutation {3, 4, 1, 2} represents one of the symmetries of this figure. (What are the others?) 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the rectangle again. If we imagine a horizontal line parallel to the base and through the center and consider this as a line of reflection, then we have another common type of symmetry: the reflection. In this case, we could also describe the symmetry by what happens to the vertices. We would say
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
{1 -> 2, 2 -> 1, 3 -> 4, 4 -> 3}
:[font = text; inactive; preserveAspect; nohscroll; ]
or,
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[{1 -> 2, 2 -> 1, 3 -> 4, 4 -> 3}]
:[font = text; inactive; preserveAspect; nohscroll; ]
or, {2, 1, 4, 3} describes the permutation of the vertices that corresponds to this reflectional symmetry.
:[font = text; inactive; preserveAspect; nohscroll; ]
There are several questions you may ask yourself. Is every symmetry either a rotation or a reflection? (You might consider the case of a finite object, such as above, in contrast with an infinite object, such as as infinitely long wall-papered wall.) You might also wonder if every object has both rotational and reflectional symmetries. For this, consider the lower right figure that has extra "wings" off the edges. 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3.1 Getting started 
:[font = text; inactive; preserveAspect; nohscroll; ]
Evaluate the cell below to see the figure that you will first consider.
:[font = input; preserveAspect; nowordwrap; ]
firstfig = ShowOne[Lab2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Your task is to determine the symmetry group for this figure, using permutations as the elements. In other words, as in the first lab, you are to determine the symmetries (transformations) in the form of a permutation that will move the figure onto itself. 
:[font = text; inactive; preserveAspect; nohscroll; ]
As before, you may express your permutation either in the form {a,b,c,...} or {1 -> a, 2 -> b, 3 -> c,...}. Also, as in Lab 1, use p[1] = {a,b,c...} or p[1] = {1 -> a, 2 -> b, 3 -> c, ...} to define your first permutation, p[2] for your second and so on. 
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Below is a list of functions that can be used for bookkeeping and testing while determining the permutations in the symmetry group.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3.2 Functions/variables to use in this lab 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
functions from the last lab:
:[font = text; inactive; preserveAspect; nohscroll; ]
You should already be familiar with how the functions ShowPermutation and MultiplyPermutations work; to refresh yourself, simply type ? followed by the command, as below.
:[font = input; preserveAspect; nowordwrap; ]
?ShowPermutation
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?MultiplyPermutations
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
ShowOne[Lab2]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is how you started this lab. Type ShowOne[Lab2] to get a figure with which to work.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?ShowOne
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
AddPermToGroup[p[i]]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you are fully confident that p[i] is indeed a permutation of the vertices and is a symmetry, then type AddPermToGroup[p[i]], which will add it to the list of all your symmetries.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?AddPermToGroup
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
DropPermFromGroup[p[i]]
:[font = text; inactive; preserveAspect; nohscroll; ]
DropPermFromGroup[p[i]] removes the permutation p[i] from the accumulated list of symmetries.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?DropPermFromGroup
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
MySymmetryGroup
:[font = text; inactive; preserveAspect; nohscroll; ]
To see the list of symmetries accumulated thus far by these previous two functions, type MySymmetryGroup. 
:[font = input; preserveAspect; endGroup; nowordwrap; ]
MySymmetryGroup
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
TestPermutationQ[p[i]]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you have a permutation p[i] that you believe is a symmetry, but you want to check to be sure, type TestPermutationQ[p[i]] and either True or False will be returned.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?TestPermutationQ
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
GoodGroupElementsQ[]
:[font = text; inactive; preserveAspect; nohscroll; ]
To determine if the accumulated permutations (as found in MySymmetryGroup) are all proper elements of the symmetry group of the figure, calling GoodGroupElementsQ[] answers with True or False.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?GoodGroupElementsQ
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
CompleteGroupQ[]
:[font = text; inactive; preserveAspect; nohscroll; ]
When you believe that you have found all the symmetries and have added them to MySymmetryGroup via AddPermToGroup, then you may check to see if your group is correct (complete) by typing CompleteGroupQ[], which will return True or False, and possibly additional information. 
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?CompleteGroupQ
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
ShowPossiblePermutations[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you get stuck trying to think of what other possible permutations might yield a symmetry, type ShowPossiblePermutations[n] (n being the number of vertices if a regular n-gon is shown, or 2 if a zee or rectangle is shown). You will be given a list of ALL possible permutations.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?ShowPossiblePermutations
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
ShowPossiblePermsAsRules[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is the same as the last function except the permutations are listed as rules, which may be helpful in using the RestrictList function described below.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?ShowPossiblePermsAsRules
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
RestrictList[r]
:[font = text; inactive; preserveAspect; nohscroll; ]
This function can be used to restrict the list produced by ShowPossiblePermsAsRules when you know that you want one vertex to go to another specific vertex, but want to explore what can happen with the other vertices. Note that r should be in the form i->j, {i->j}, or as a list of either of these.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
?RestrictList
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
all together now
:[font = text; inactive; preserveAspect; nohscroll; ]
It is easy to forget this list of functions. By typing AvailableFunctions (after evaluating the following), you can have the list of names always available.
:[font = input; initialization; preserveAspect; endGroup; endGroup; endGroup; nowordwrap; ]
*)
AvailableFunctions := {ShowPermutation, MultiplyPermutations,
	ShowOne, AddPermToGroup, DropPermFromGroup,
	"MySymmetryGroup", TestPermutationQ, GoodGroupElementsQ,
	CompleteGroupQ, ShowPossiblePermutations,
	ShowPossiblePermsAsRules, RestrictList};
	
AvailableFunctions
(*
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.4 Now your turn
:[font = text; inactive; preserveAspect; nohscroll; ]
To see the figure again for the first exercise, evaluate the cell below. (Note: you should have already viewed it once when evaluating firstfig = ShowOne[Lab2] in the Getting Started section above.)
:[font = input; preserveAspect; nowordwrap; ]
firstfig[[1]]//Show;
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Using the information found in "Functions/variables to use in this lab" above, determine the complete list of all the symmetries (in the form of permutations) for the figure above. Use p[i] notation for each one (or ppp[i] if used by one of the functions described above). Show all work below in establishing this list.
:[font = input; preserveAspect; nowordwrap; ]
AvailableFunctions 
(* evaluate to be reminded what functions are available *)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Use the function MultiplyPermutations as in the previous lab (MultiplyPermutations[p[i], p[j]] determines the permutation of p[j] followed by p[i]) to determine the Cayley table for the symmetry group of this figure.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Repeat the steps in Q1 and Q2 above with secondfig, determined below. 
:[font = input; preserveAspect; nowordwrap; ]
Clear[p, ppp]
secondfig = ShowOne[Lab2]
:[font = input; preserveAspect; nowordwrap; ]
AvailableFunctions 
(* evaluate to be reminded what functions are available *)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Repeat the steps in Q1 and Q2 above again. 
:[font = input; preserveAspect; nowordwrap; ]
Clear[p, ppp]
thirdfig = ShowOne[Lab2]
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?PermutationMatrix
:[font = input; preserveAspect; nowordwrap; ]
?ShowOne
:[font = input; preserveAspect; nowordwrap; ]
?ShowPermutation
:[font = input; preserveAspect; nowordwrap; ]
?MultiplyPermutations
:[font = input; preserveAspect; nowordwrap; ]
?AddPermToGroup
:[font = input; preserveAspect; nowordwrap; ]
?DropPermFromGroup
:[font = input; preserveAspect; nowordwrap; ]
?TestPermutationQ
:[font = input; preserveAspect; nowordwrap; ]
?GoodGroupElementsQ
:[font = input; preserveAspect; nowordwrap; ]
?CompleteGroupQ
:[font = input; preserveAspect; nowordwrap; ]
?ShowPossiblePermutations
:[font = input; preserveAspect; nowordwrap; ]
?ShowPossiblePermsAsRules
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?RestrictList
^*)