(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 3. Is this a group?
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should have already seen the definition of a group and be familiar with the basic group properties: being closed, identity, inverse, and associativity (and commutativity).
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Given a set of elements, and some operation on the elements, will this form a group? This lab will explore a number of pairs consisting of a set and an operation. A Cayley table for the set and operation is presented and the user is asked which of the defining properties of a group hold for this pair.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.3 When do we have a group?
:[font = text; inactive; preserveAspect; nohscroll; ]
We know that before we can call a set with an operation a group, it must satisfy certain properties. Namely, the set must be closed under the operation, there must be an identity element, each element must have an inverse and the operation needs to be associative. Our goal is to determine which, if any, of the above properties hold when presented a set with an operation. Before we begin, we need to read in the necessary code used in this lab:
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
When you evaluate ShowOne[Lab3] to obtain the first problem, you will be shown something similar to what is given below:
:[font = input; inactive; preserveAspect; startGroup; Cclosed; nowordwrap; ]
ShowOne[Lab3] (* DON'T evaluate - just open up *)
:[font = print; inactive; locked; preserveAspect; nowordwrap; ]
The alleged group consists of the set of elements
{4, 0, 1, 3, 2}
 and the operator is myPower. This is case number 15. Below is the
 Cayley table for this alleged group.
:[font = postscript; inactive; locked; output; preserveAspect; endGroup; BITMAP; PostScript; pictureLeft = 32; pictureTop = 0; pictureWidth = 264; pictureHeight = 287; nowordwrap; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1.085 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0274206 0.15873 [
[ 0 0 0 0 ]
[ 1 1.085 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 1.085 L
0 1.085 L
closepath
clip
newpath
p
p
p
p
1 1 0 r
p
.5 .66234 m
.5 .82107 L
.65873 .82107 L
.65873 .66234 L
F
P
P
p
1 .753 .796 r
p
.18254 .66234 m
.18254 .82107 L
.34127 .82107 L
.34127 .66234 L
F
.5 .50361 m
.5 .66234 L
.65873 .66234 L
.65873 .50361 L
F
P
P
p
1 .5 0 r
p
.81746 .66234 m
.81746 .82107 L
.97619 .82107 L
.97619 .66234 L
F
.81746 .50361 m
.81746 .66234 L
.97619 .66234 L
.97619 .50361 L
F
.18254 .34488 m
.18254 .50361 L
.34127 .50361 L
.34127 .34488 L
F
.34127 .34488 m
.34127 .50361 L
.5 .50361 L
.5 .34488 L
F
.5 .34488 m
.5 .50361 L
.65873 .50361 L
.65873 .34488 L
F
.65873 .34488 m
.65873 .50361 L
.81746 .50361 L
.81746 .34488 L
F
.81746 .34488 m
.81746 .50361 L
.97619 .50361 L
.97619 .34488 L
F
.81746 .18615 m
.81746 .34488 L
.97619 .34488 L
.97619 .18615 L
F
P
P
p
.74 .99 .79 r
p
.5 .18615 m
.5 .34488 L
.65873 .34488 L
.65873 .18615 L
F
P
P
p
.678 .847 .902 r
p
.18254 .02742 m
.18254 .18615 L
.34127 .18615 L
.34127 .02742 L
F
.34127 .02742 m
.34127 .18615 L
.5 .18615 L
.5 .02742 L
F
.5 .02742 m
.5 .18615 L
.65873 .18615 L
.65873 .02742 L
F
.65873 .02742 m
.65873 .18615 L
.81746 .18615 L
.81746 .02742 L
F
P
P
P
p
p
1 1 0 r
.18254 .82107 m
.18254 .9798 L
.34127 .9798 L
.34127 .82107 L
F
P
p
1 .753 .796 r
.34127 .82107 m
.34127 .9798 L
.5 .9798 L
.5 .82107 L
F
P
p
1 .5 0 r
.5 .82107 m
.5 .9798 L
.65873 .9798 L
.65873 .82107 L
F
P
p
.74 .99 .79 r
.65873 .82107 m
.65873 .9798 L
.81746 .9798 L
.81746 .82107 L
F
P
p
.678 .847 .902 r
.81746 .82107 m
.81746 .9798 L
.97619 .9798 L
.97619 .82107 L
F
P
p
1 1 0 r
.02381 .66234 m
.02381 .82107 L
.18254 .82107 L
.18254 .66234 L
F
P
p
1 .753 .796 r
.02381 .50361 m
.02381 .66234 L
.18254 .66234 L
.18254 .50361 L
F
P
p
1 .5 0 r
.02381 .34488 m
.02381 .50361 L
.18254 .50361 L
.18254 .34488 L
F
P
p
.74 .99 .79 r
.02381 .18615 m
.02381 .34488 L
.18254 .34488 L
.18254 .18615 L
F
P
p
.678 .847 .902 r
.02381 .02742 m
.02381 .18615 L
.18254 .18615 L
.18254 .02742 L
F
P
P
P
p
p
1 1 1 r
.008 w
.18095 .02583 Mdot
P
p
p
1 Mabswid
.02381 .02742 m
.02381 .9798 L
s
.02381 .02742 m
.97619 .02742 L
s
.02381 .18615 m
.97619 .18615 L
s
.02381 .34488 m
.97619 .34488 L
s
.02381 .50361 m
.97619 .50361 L
s
.02381 .66234 m
.97619 .66234 L
s
.02381 .82107 m
.97619 .82107 L
s
.02381 .9798 m
.97619 .9798 L
s
.18254 .02742 m
.18254 .9798 L
s
.34127 .02742 m
.34127 .9798 L
s
.5 .02742 m
.5 .9798 L
s
.65873 .02742 m
.65873 .9798 L
s
.81746 .02742 m
.81746 .9798 L
s
.97619 .02742 m
.97619 .9798 L
s
P
P
p
2.6 Mabswid
.18254 .02742 m
.18254 .9798 L
s
.02381 .82107 m
.97619 .82107 L
s
P
P
p
p
[(4)] .2619 .74171 0 0 Mshowa
[(16)] .42063 .74171 0 0 Mshowa
[(2)] .57937 .74171 0 0 Mshowa
[(8)] .7381 .74171 0 0 Mshowa
[(1)] .89683 .74171 0 0 Mshowa
[(16)] .2619 .58298 0 0 Mshowa
[(256)] .42063 .58298 0 0 Mshowa
[(4)] .57937 .58298 0 0 Mshowa
[(64)] .7381 .58298 0 0 Mshowa
[(1)] .89683 .58298 0 0 Mshowa
[(1)] .2619 .42425 0 0 Mshowa
[(1)] .42063 .42425 0 0 Mshowa
[(1)] .57937 .42425 0 0 Mshowa
[(1)] .7381 .42425 0 0 Mshowa
[(1)] .89683 .42425 0 0 Mshowa
[(9)] .2619 .26552 0 0 Mshowa
[(81)] .42063 .26552 0 0 Mshowa
[(3)] .57937 .26552 0 0 Mshowa
[(27)] .7381 .26552 0 0 Mshowa
[(1)] .89683 .26552 0 0 Mshowa
[(0)] .2619 .10679 0 0 Mshowa
[(0)] .42063 .10679 0 0 Mshowa
[(0)] .57937 .10679 0 0 Mshowa
[(0)] .7381 .10679 0 0 Mshowa
[(Ind)] .89683 .10679 0 0 Mshowa
P
p
[(2)] .10317 .74171 0 0 Mshowa
[(4)] .10317 .58298 0 0 Mshowa
[(1)] .10317 .42425 0 0 Mshowa
[(3)] .10317 .26552 0 0 Mshowa
[(0)] .10317 .10679 0 0 Mshowa
P
p
[(2)] .2619 .90044 0 0 Mshowa
[(4)] .42063 .90044 0 0 Mshowa
[(1)] .57937 .90044 0 0 Mshowa
[(3)] .7381 .90044 0 0 Mshowa
[(0)] .89683 .90044 0 0 Mshowa
P
p
P
[(^)] .10317 .90044 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; nohscroll; ]
Note that the Cayley table may have the elements (in the headings) in a different order than stated in the written description. (Before making the table, they are randomized---for this lab only.) The properties of closure, identity and inverses should be readily observable from this Cayley table. Associativity is a little more difficult. We will use a function that randomly tests for associativity, testing 25 triples by default. Since what is shown above is identified as "case number 15", the argument to our function is LG[15] (for Lab Groupoid number 15.). Evaluate the cell below.
:[font = input; preserveAspect; nowordwrap; ]
RandomAssociativeQ[LG[15]]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to change the number of tests, add this number as the second argument as shown below:
:[font = input; preserveAspect; endGroup; nowordwrap; ]
RandomAssociativeQ[LG[15], 30]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.4 Now your turn
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Use ShowOne[Lab3] to bring up an alleged group. With careful examination of the Cayley table, you should be able to answer the following. (First, indicate the "case number" of the alleged group.)

(a) Determine if the set is closed under the given operation; if so, why is it, and if not, why not. 

(b) Determine if there is an identity element; if so, state it, and if not, why not. 

(c) Determine the inverse of each element, for those where one exists. 

(d) Use the associativity test to make a conjecture whether the operation is associative or not. (Remember to specify the particular case number in the argument of LG[].)

(e) Although not a required property to be a group, determine if this operation is commutative.

(f) Finally, determine whether the set with the operation is indeed a group. (Guess, if you are not fully convinced about the associativity.)
:[font = input; preserveAspect; nowordwrap; ]
ShowOne[Lab3]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Repeat the instructions from Question 1. (Again, indicate the "case number" of the alleged group for this question.)
:[font = input; preserveAspect; nowordwrap; ]
ShowOne[Lab3]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Repeat the instructions from Question 1. (Again, indicate the "case number" of the alleged group for this question.)
:[font = input; preserveAspect; nowordwrap; ]
ShowOne[Lab3]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Repeat the instructions from Question 1. (Again, indicate the "case number" of the alleged group for this question.)
:[font = input; preserveAspect; nowordwrap; ]
ShowOne[Lab3]
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?ShowOne
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?RandomAssociativeQ
^*)