(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 6. Cycling through the groups
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Other than the basic definitions related to a group, there are no prerequisites.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
We first look at what it means for a group to be cyclic and try to determine the generators when it is. We will try to classify the cyclicity of the groups Z[n], Dihedral[n], and U[n], and determine the set of generators when they are cyclic. Next, we consider the case when the direct product of Z[m] and Z[n] yields a cyclic group. Finally, we look at some of the cyclic subgroups of the infinite additive group of integers, Z.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.3 What, when, how and why about cyclic groups
:[font = text; inactive; preserveAspect; nohscroll; ]
We need to read in the Master package inside the AbstractAlgebra directory to conduct this lab:
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that we say a group G is cyclic if there exists an element g in G such that G = {g^k | k in Z}. In this case, we call g a generator of G and denote this relationship by <g> = G. 

Which groups, if any, are cyclic?

First let's consider a random group Z[n], for n in [6, 14].
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 14}]
G = Z[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
Is this group cyclic? How can we find out? Recalling the definition of being cyclic (which was written for multiplicative groups), we need to see if there is an element g in G such that the set of multiples of g constitutes the whole group. Let's generate multiples of each element and find out if G is cyclic. Note that since our group G is finite with order n, we only need to consider a finite number of multiples.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Why is it true that we only need to consider a finite number of multiples? Explain your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
So let's take a look at some multiples of each of the elements in G.
:[font = input; preserveAspect; nowordwrap; ]
els = Elements[G]
TableForm[multiples = Table[j els[[i]], {i, n}, {j, n}],
	TableHeadings -> {Table["multiples of "<>ToString[i]<>":",
	{i, 0, n-1}], None}, TableSpacing -> {0, 1}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Whoops! These don't all look like elements in G. What did we forget?
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[Mod[#, n]&, multiples],
	TableHeadings -> {Table["multiples of "<>ToString[i]<>":",
	{i, 0, n-1}], None}, TableSpacing -> {0, 1}]
:[font = text; inactive; preserveAspect; nohscroll; ]
The first list of numbers represents multiples of 0, the second list represents multiples of 1, the third list has the multiples of 2 and so on; the last row represents multiples of (n - 1).
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Do any of these lists represent G? Is G cyclic? What had you expected? If G is cyclic, what are the generators? Does this list of generators surprise you? (Record the group G that was given to you.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
We can get similar results by using a function called SubgroupGenerated:
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupGenerated
:[font = input; preserveAspect; nowordwrap; ]
Table[Elements[SubgroupGenerated[G, g]], 
	{g, 0, n - 1}]//ColumnForm
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's focus on G = Z[12] for the moment. (If this is the group that was randomly generated for you, pardon the redundancy.)
:[font = input; preserveAspect; nowordwrap; ]
G = Z[12]
:[font = text; inactive; preserveAspect; nohscroll; ]
Does the element 5 generate the whole group? Let's find out.
:[font = input; preserveAspect; nowordwrap; ]
SubgroupGenerated[G, 5]
:[font = text; inactive; preserveAspect; nohscroll; ]
The list, as given, is the order in which the elements are generated. To see this with a little more explanation, try the following:
:[font = input; preserveAspect; nowordwrap; ]
SubgroupGenerated[G, 5, Mode -> Textual]
:[font = text; inactive; preserveAspect; nohscroll; ]
A visual perspective might also be useful. Evaluate the following cell and then double-click on any graphic cell (perhaps closing the enclosing cell bracket first) and then adjust the speed by typing a number from 1 (slow) to 9 (fast). Or you can step through the animation with the (up/down) arrow keys.
:[font = input; preserveAspect; nowordwrap; ]
SubgroupGenerated[G, 5, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
What follows is another visual way of seeing the subgroup generated by 5. In this case, the colors indicate the order in which the multiples (powers) occur, following the rainbow; the key at the bottom helps by listing the element in the colored box and the multiple (power) above.
:[font = input; preserveAspect; nowordwrap; ]
SubgroupGenerated[G, 5, Mode -> Visual2]
:[font = text; inactive; preserveAspect; nohscroll; ]
These illustrations show that indeed Z[12] is cyclic. If there is a Thomas in the crowd, he/she can also try
:[font = input; preserveAspect; nowordwrap; ]
CyclicQ[Z[12]]
:[font = text; inactive; preserveAspect; nohscroll; ]
It is not only interesting to know whether a group is cyclic, but it is also interesting to know what (other) elements generate the whole group. Try the following:
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[G, Mode -> Textual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. What are the generators of Z[12]? How do you know? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Using an idea similar to what we saw above, we can also approach this visually:
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[G, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Look at this table. What observations can you make? Can you explain any of these observations?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's consider the group Z[15].
:[font = input; preserveAspect; nowordwrap; ]
G = Z[15]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Determine if Z[15] is cyclic. If so, specify the generators; if not, explain why not.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. What about Z[17]?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's check out the cyclicity of some other Z[n].
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[{n, CyclicQ[Z[n]]}, {n, 2, 25}],
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 2}, 
	TableHeadings -> {None, {"n", "cyclic?\n"}}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. What conclusion can you infer about the cyclicity of Z[n]? Prove your statement, if you can.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. For an arbitrary n, what elements are the generators of Z[n]? You should be able to be very specific with a description here. Can you also specify (as a function of n), the number of generators for Z[n]?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's think about some other groups. What about the dihedral family? We will start our index at 1.
:[font = input; preserveAspect; nowordwrap; ]
CyclicQ[Dihedral[1]]
:[font = input; preserveAspect; nowordwrap; ]
CyclicQ[Dihedral[2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Or if you wish to see this visually, try
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[Dihedral[2], Mode -> Visual]
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[Dihedral[3], Mode -> Visual]
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[Dihedral[4], Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Table allows us to quickly look at a few more examples
:[font = input; preserveAspect; nowordwrap; ]
Table[{n, CyclicQ[Dihedral[n]]}, {n, 5, 8}]//TableForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. What do you suppose is true about Dihedral[n] being cyclic? Justify your answer. Can you prove it?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
What about the group U[n]? Let's consider a few examples.
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[U[15], Mode -> Visual]
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[U[14], Mode -> Visual]
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[U[13], Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Is U[n] cyclic for all n? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Considering only whether U[n] is cyclic or not, we can use Table and CyclicQ. The following is already generated -- do not evaluate the cell again.
:[font = input; inactive; preserveAspect; startGroup; Cclosed; nowordwrap; ]
TableForm[Table[{n, CyclicQ[U[n]]}, {n, 3, 50}],
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
(* ALREADY EVALUATED - SIMPLY OPEN UP *)
:[font = output; inactive; locked; formatted; output; preserveAspect; endGroup; nowordwrap; ]
TableForm[{{3, True}, {4, True}, {5, True}, {6, True}, {7, True}, 
 {8, False}, {9, True}, {10, True}, {11, True}, {12, False}, 
 {13, True}, {14, True}, {15, False}, {16, False}, {17, True}, 
 {18, True}, {19, True}, {20, False}, {21, False}, {22, True}, 
 {23, True}, {24, False}, {25, True}, {26, True}, {27, True}, 
 {28, False}, {29, True}, {30, False}, {31, True}, {32, False}, 
 {33, False}, {34, True}, {35, False}, {36, False}, {37, True}, 
 {38, True}, {39, False}, {40, False}, {41, True}, {42, False}, 
 {43, True}, {44, False}, {45, False}, {46, True}, {47, True}, 
 {48, False}, {49, True}, {50, True}}]








;[o]
3    True

4    True

5    True

6    True

7    True

8    False

9    True

10   True

11   True

12   False

13   True

14   True

15   False

16   False

17   True

18   True

19   True

20   False

21   False

22   True

23   True

24   False

25   True

26   True

27   True

28   False

29   True

30   False

31   True

32   False

33   False

34   True

35   False

36   False

37   True

38   True

39   False

40   False

41   True

42   False

43   True

44   False

45   False

46   True

47   True

48   False

49   True

50   True
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is another list, that it is also already generated -- do not evaluate the cell again.
:[font = input; inactive; preserveAspect; startGroup; Cclosed; nowordwrap; ]
TableForm[Table[{n, CyclicQ[U[n]]}, {n, 51, 100}],
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 3}]
(* ALREADY EVALUATED - SIMPLY OPEN UP *)
:[font = output; inactive; locked; formatted; output; preserveAspect; endGroup; nowordwrap; ]
TableForm[{{51, False}, {52, False}, {53, True}, {54, True}, 
 {55, False}, {56, False}, {57, False}, {58, True}, {59, True}, 
 {60, False}, {61, True}, {62, True}, {63, False}, {64, False}, 
 {65, False}, {66, False}, {67, True}, {68, False}, {69, False}, 
 {70, False}, {71, True}, {72, False}, {73, True}, {74, True}, 
 {75, False}, {76, False}, {77, False}, {78, False}, {79, True}, 
 {80, False}, {81, True}, {82, True}, {83, True}, {84, False}, 
 {85, False}, {86, True}, {87, False}, {88, False}, {89, True}, 
 {90, False}, {91, False}, {92, False}, {93, False}, {94, True}, 
 {95, False}, {96, False}, {97, True}, {98, True}, {99, False}, 
 {100, False}}, TableSpacing -> {0, 3}]








;[o]
51    False
52    False
53    True
54    True
55    False
56    False
57    False
58    True
59    True
60    False
61    True
62    True
63    False
64    False
65    False
66    False
67    True
68    False
69    False
70    False
71    True
72    False
73    True
74    True
75    False
76    False
77    False
78    False
79    True
80    False
81    True
82    True
83    True
84    False
85    False
86    True
87    False
88    False
89    True
90    False
91    False
92    False
93    False
94    True
95    False
96    False
97    True
98    True
99    False
100   False
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. For what values of n is U[n] cyclic? (Think about the answer---you do not need to list them.) Can you see any patterns? What conclusions can you make?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.4 Cyclicity of Z[m] + Z[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
We are quite familiar with the Z[n] groups. Suppose we consider pairing up two (possibly the same) Z[n] groups and make a new group from the pairs. For example, consider Z[2] and Z[3] and form all pairs (x, y) where the x comes from Z[2] and the y comes from Z[3]: G = {(x, y) | x in Z[2] and y in Z[3]}. What are the elements in G? This is called the direct sum (also called direct product) of Z[2] and Z[3], denoted here simply by Z[2] + Z[3].
:[font = input; preserveAspect; nowordwrap; ]
Elements[DirectSum[Z[2], Z[3]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that all the first elements in the pairs are either 0 or 1 and the second elements are 0, 1, or 2, exactly as specified. So what operation do we use? There is a "natural" one to consider. Suppose (x, y) and (a, b) are generic elements. Then we say (x, y) + (a, b) = ((x + a) mod 2, (y + b) mod 3). In other words, we treat each dimension (component or coordinate) as we did before joining them, using the operation of the contributing group for that part.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Do some calculations in the above setting: 
(0, 1) + (1, 0) = ?
(1, 1) + (1, 1) = ?
(1, 0) + (1, 2) = ?
(0, 1) + (0, 2) = ?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the Cayley table of the above group:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[DirectSum[Z[2], Z[3]], Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
Since the elements do not fit very well in the limited space in the table, you need to use the Key to guide you.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Check your answers to the previous question. Were they right? Is this group Abelian? Why? What is the identity? Is the group cyclic? How do you know?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
So, when is Z[m] + Z[n] cyclic? The following produces a table for various m and n (and is already evaluated -- simply open it up).
:[font = input; preserveAspect; startGroup; Cclosed; nowordwrap; ]
Flatten[Table[G = DirectSum[Z[m], Z[n]]; {m, n, CyclicQ[G]}, 
	{m, 2, 7}, {n, 2, 7}], 1]//TableForm[#, TableHeadings -> 
	{None, {"m", "n", "cyclic?\n"}}, TableSpacing -> 
	{If[$VersionNumber > 2.5, 0.5, 0], 2}]&
	(* ALREADY EVALUATED - SIMPLY OPEN UP *)
:[font = output; inactive; locked; formatted; output; preserveAspect; endGroup; nowordwrap; ]
TableForm[{{2, 2, False}, {2, 3, True}, {2, 4, False}, {2, 5, True}, 
 {2, 6, False}, {2, 7, True}, {3, 2, True}, {3, 3, False}, {3, 4, True}, 
 {3, 5, True}, {3, 6, False}, {3, 7, True}, {4, 2, False}, {4, 3, True}, 
 {4, 4, False}, {4, 5, True}, {4, 6, False}, {4, 7, True}, {5, 2, True}, 
 {5, 3, True}, {5, 4, True}, {5, 5, False}, {5, 6, True}, {5, 7, True}, 
 {6, 2, False}, {6, 3, False}, {6, 4, False}, {6, 5, True}, 
 {6, 6, False}, {6, 7, True}, {7, 2, True}, {7, 3, True}, {7, 4, True}, 
 {7, 5, True}, {7, 6, True}, {7, 7, False}}, 
 TableHeadings -> {None, {"m", "n", "cyclic?\n"}}, 
 TableSpacing -> {0, 2}]








;[o]
   m  n  cyclic?

   2  2  False
   2  3  True
   2  4  False
   2  5  True
   2  6  False
   2  7  True
   3  2  True
   3  3  False
   3  4  True
   3  5  True
   3  6  False
   3  7  True
   4  2  False
   4  3  True
   4  4  False
   4  5  True
   4  6  False
   4  7  True
   5  2  True
   5  3  True
   5  4  True
   5  5  False
   5  6  True
   5  7  True
   6  2  False
   6  3  False
   6  4  False
   6  5  True
   6  6  False
   6  7  True
   7  2  True
   7  3  True
   7  4  True
   7  5  True
   7  6  True
   7  7  False
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Give a conjecture about the necessary conditions for Z[m] + Z[n] to be cyclic. How might a proof go?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.5 Structure of intersections of subgroups of Z
:[font = text; inactive; preserveAspect; nohscroll; ]
For any integer m, the subgroup <m> is a cyclic subgroup of the integers Z. Given two such subgroups, <m> and <n>, we know that the intersection of these two subgroups is another subgroup (as is the intersection of any two subgroups from the same group). Furthermore, we know that it is another subgroup of the form <p>.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Why must this intersection look like <p> for some integer p?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at some examples. Since these subgroups are all infinite, all we can do is look at a finite swath, but this should be sufficient to build our intuition.

Consider H = <4> and K = <10>:
:[font = input; preserveAspect; nowordwrap; ]
leftAndRight = 15;
H = Table[4 i, {i, -leftAndRight, leftAndRight}]
K = Table[10 i, {i, -leftAndRight, leftAndRight}]
Intersection[H, K]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. What does the intersection appear to be? What connection, if any, is there between your answer and the fact that H = <4> and K = <10>?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider H = <4> and K = <11>:
:[font = input; preserveAspect; nowordwrap; ]
leftAndRight = 22;
H = Table[4 i, {i, -leftAndRight, leftAndRight}]
:[font = input; preserveAspect; nowordwrap; ]
K = Table[11 i, {i, -leftAndRight, leftAndRight}]
:[font = input; preserveAspect; nowordwrap; ]
Intersection[H, K]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. What does the intersection appear to be? What connection, if any, is there between your answer and the fact that H = <4> and K = <11>?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider H = <4> and K = <12>:
:[font = input; preserveAspect; nowordwrap; ]
leftAndRight = 15;
H = Table[4 i, {i, -leftAndRight, leftAndRight}]
K = Table[12 i, {i, -leftAndRight, leftAndRight}]
Intersection[H, K]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. What does the intersection appear to be? What connection, if any, is there between your answer and the fact that H = <4> and K = <12>?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q19. Can you give a conjecture? Test it with a few more examples. Try to prove it.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.6 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?Map
:[font = input; preserveAspect; nowordwrap; ]
?Mod
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupGenerated
:[font = input; preserveAspect; nowordwrap; ]
?CyclicQ
:[font = input; preserveAspect; nowordwrap; ]
?OrderOfAllElements
:[font = input; preserveAspect; nowordwrap; ]
?Dihedral
:[font = input; preserveAspect; nowordwrap; ]
?U
:[font = input; preserveAspect; nowordwrap; ]
?DirectSum
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?DirectProduct
^*)