(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 7. Permutations
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should have a good understanding of functions, including "right to left" composition. It is not necessary to have completed any previous labs to attempt this one.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
We will look at the notion of a permutation and how a group can be formed with permutations. Additionally, we will look at properties of permutations and consider different ways of rewriting a permutation to gain insights regarding products and orders.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.3 What is a permutation?
:[font = text; inactive; preserveAspect; nohscroll; ]
We need to read in the following Mathematica code to work through this lab:
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
What is a permutation? Suppose we had 5 colored squares labeled 1 through 5:
:[font = input; preserveAspect; nowordwrap; ]
RandomColoredSquares[5];
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose further that we decide we wish to change the order in which these squares appear. Let's say we want square 1 to go to the second location, square 2 to the third location, square 3 to the first, square 4 to the fifth and square 5 to the fourth:
:[font = input; preserveAspect; nowordwrap; ]
PermuteColoredSquares[{1 -> 2, 2 -> 3, 3 -> 1, 4 -> 5,
	5 -> 4}];
:[font = text; inactive; preserveAspect; nohscroll; ]
Note how the first square went to the second location (1 -> 2), the second square went to the third position (2 -> 3), the third square went to the first position (3 -> 1) and so on. Here we say that the second row of squares is a permutation of the squares in the first row. 

Technically, a permutation of a set X is a function g from X to X that is both one-to-one and onto. In the case above, we could define g : X -> X by g(1) = 2, g(2) = 3, g(3) = 1, g(4) = 5, and g(5) = 4, where X = {1, 2, 3, 4}. This is often represented by a matrix as follows:
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[{1 -> 2, 2 -> 3, 3 -> 1, 4 -> 5, 5 -> 4}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that the domain occurs in the first row and the corresponding range elements in the second row. (Note also that the range, or second row in the matrix, is NOT the same as the numbers in the second row of labeled squares shown above. There is a connection, however; can you see it?)
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Since permutations are functions, we can combine two permutations by using function composition; this will be shown below. Using this binary operation, the set of all permutations of a set X is called the permutation group of the set X. If X is the set of integers {1, 2, ...,  n}, then we call this group the symmetric group of degree n (denoted S[n]). If the set X is some other collection of n elements, we can simply (re-)label the elements 1 through n and still consider the group of permutations as the symmetry group S[n].
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.4 Computations with permutations
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we have two permutations as shown:
:[font = input; preserveAspect; nowordwrap; ]
p = {1 -> 2, 2 -> 4, 3 -> 3, 4 -> 5, 5 -> 1}
q = {1 -> 5, 2 -> 4, 3 -> 1, 4 -> 2, 5 -> 3}
:[font = text; inactive; preserveAspect; nohscroll; ]
We can view each permutation as a matrix.
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[p]
PermutationMatrix[q]
:[font = text; inactive; preserveAspect; nohscroll; ]
To perform the product of p followed by q (note the order here and below), it may help to think of these as side-by-side matrices:
:[font = input; preserveAspect; nowordwrap; ]
SideBySideMatrices[q, p]
:[font = text; inactive; preserveAspect; nohscroll; ]
Observe that q is on the left and p is on the right. We start by first considering the right-hand side. Observe that p maps 1 to 2. Since q follows p, we note that q takes 2 to 4. Therefore, the composition of p followed by q takes 1 to 2 to 4, or simply 1 to 4. Let's try another. Note that p takes 5 to the element 1 and that q takes the element 1 to the element 5. Therefore the composition of p followed by q takes 5 to 1 to 5 (and thus 5 is said to be fixed under this composition).

The complete product is shown below.
:[font = input; preserveAspect; nowordwrap; ]
MultiplyPermutations[q, p]//PermutationMatrix
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Suppose we have two permutations s and t given by s = { 1 -> 2, 2 -> 3, 3 -> 1, 4 -> 4} and t = {1 -> 2, 2 -> 3, 3 -> 4, 4 -> 1}. Determine the two compositions: (i) s followed by t and (ii) t followed by s (indicating which is which). First do your work on paper and then verify it using the Mathematica functions. What property does S[4] not have, as illustrated here?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
When we viewed the permutation p in matrix form, it looked like
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[p]
:[font = text; inactive; preserveAspect; nohscroll; ]
You may have noticed that this form always has the top row being the first consecutive n integers and the bottom row captures the images of the top row under the function defined by the permutation. Therefore, it is really the bottom row that holds the important information. Consequently, we will frequently refer to a permutation by simply using the bottom row, as illustrated below:
:[font = input; preserveAspect; nowordwrap; ]
MultiplyPermutations[{2, 3, 1, 4}, {4, 2, 3, 1}, 
	Mode -> Textual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Determine the product of {2, 3, 4, 1} followed by {1, 3, 2, 4}.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the following permutation and its illustration using colored squares.
:[font = input; preserveAspect; nowordwrap; ]
p = {3, 1, 2, 5, 4, 6}
ShowColoredPermutation[p];
:[font = text; inactive; preserveAspect; nohscroll; ]
Study the permutation (and/or its colored representation). Note that elements in the set {1, 2, 3} permute among themselves, as do the elements in the sets {4, 5} and {6}. In particular, note that p(1) = 3, p(p(1)) = p(3) = 2, and p(p(p(1))) = p(p(3)) = p(2) = 1. Therefore, these elements cycle through as 1 -> 3 -> 2 -> 1. We say that the (ordered) subset {1, 3, 2} is a cycle of the permutation p. Furthermore, {4, 5} and {6} are also cycles. The standard way to denote these cycles is by the notation (1, 3, 2), (4, 5), and (6) respectively. (Often the commas are dropped, if only single digits are used.) Since Mathematica only allows parentheses to be used as grouping symbols (and not delimeters), we use Cycle[1, 3, 2] to denote the cycle (1, 3, 2); the leading word Cycle should make it clear that a cycle is under discussion, and not a permutation. Frequently it is convenient to rewrite permutations into disjoint cycles. (The three cycles (1, 3, 2), (4, 5) and (6) are said to be disjoint since the intersection of any pair is empty.) The following command will do this:
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[p]
:[font = text; inactive; preserveAspect; nohscroll; ]
The following takes us back:
:[font = input; preserveAspect; nowordwrap; ]
FromCycles[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
The cycle (3, 2, 5, 4, 1) is different from the permutation {3, 2, 5, 4, 1}. Study the following until you see how these differ.
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[{3, 2, 5, 4, 1}]
(* viewing the permutation *)
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[FromCycles[{Cycle[3, 2, 5, 4, 1]}]]
(* viewing the cycle, the output is the cycle
converted to a permutation. Note how 3 -> 2 -> 5 ->
4 -> 1 -> 3. *)
:[font = text; inactive; preserveAspect; nohscroll; ]
You should read in your text for further details about working with cycles; in particular, determine how to multiply permutations represented in cycle notation.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Suppose the permutation p is given as a product of disjoint cycles as 
p = (1, 2, 5) (3, 6) (4) and q is given by q = (2, 5, 6) (3, 1, 4). Determine the product of p followed by q.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.5 Applications of permutations
:[font = text; inactive; preserveAspect; nohscroll; ]
You may recall working with permutations in labs 1 and 2. There, we had figures such as what is given below:
:[font = input; preserveAspect; nowordwrap; ]
ShowFigure[4, {1, 2, 3, 4}, "D"];
:[font = text; inactive; preserveAspect; nohscroll; ]
In those labs, you were supposed to find all the symmetries of a figure and determine the group of symmetries. You may realize now that this figure's group of symmetries consists of four rotations and four reflections, the dihedral group D[4]. Using Rot to represent the lowest order rotation, 90 degrees in this case, and Ref for any reflection, the group is given by
:[font = input; preserveAspect; nowordwrap; ]
Dihedral[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
This representation of D[4] is useful in some contexts. However, viewing it in terms of the permutations of the four vertices to accomplish these symmetries might be more useful at the moment, as well as reminding us of what we did in earlier labs:
:[font = input; preserveAspect; nowordwrap; ]
G = Dihedral[4, Form -> Permutations]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at just the elements:
:[font = input; preserveAspect; nowordwrap; ]
els = Elements[G]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. As already indicated, we know that D[4] consists of 4 rotations and 4 reflections. Match up the elements when using Rot and Ref form with the elements corresponding to permutations.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's randomly choose one of these permutations and show the result of applying it to our figure:
:[font = input; preserveAspect; nowordwrap; ]
ShowPermutation[els[[Random[Integer, {1, 8}]]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the permutation
:[font = input; preserveAspect; nowordwrap; ]
p = {1, 2, 4, 3}
:[font = text; inactive; preserveAspect; nohscroll; ]
and its effect on our square:
:[font = input; preserveAspect; nowordwrap; ]
ShowPermutation[p]
:[font = text; inactive; preserveAspect; nohscroll; ]
What symmetry is this? Note that vertices 1 and 2 both stayed fixed. A rotation only fixes one point (which one?), so this can not be a rotation. A reflection moves all points except those on the line of reflection. But using a line of reflection through vertices 1 and 2 would not land this square back onto itself again. Furthermore, it would not transpose vertices 3 and 4. Therefore, this is not a symmetry of the square. 

So what is it? It is just a permutation of the vertices that can not be obtained by a symmetry. 

Recall that we use S[4] to denote the group of all permutations of four objects. This group is given below.
:[font = input; preserveAspect; nowordwrap; ]
Symmetric[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
How many elements are there in S[4]? The order of a group is precisely that number.
:[font = input; preserveAspect; nowordwrap; ]
Order[Symmetric[4]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. For any given n, what is the order of S[n]? Why?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.6 Questions about permutations
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the following permutation:
:[font = input; preserveAspect; nowordwrap; ]
p1 = {3, 1, 2, 5, 4, 6}
:[font = text; inactive; preserveAspect; nohscroll; ]
We might want to know how to write this as a product of disjoint cycles. This is something you want to learn how to do without the computer, but for now, let's use Mathematica.
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[p1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since there are three cycles, let's call them a, b, and c:
:[font = input; preserveAspect; nowordwrap; ]
{a, b, c} = ToCycles[p1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that cycle notation is not to be read in the same way as a permutation. We can determine the permutation for any one of these as follows:
:[font = input; preserveAspect; nowordwrap; ]
ToPermutation[a, 6]
ToPermutation[b, 6]
ToPermutation[c, 6]
:[font = text; inactive; preserveAspect; nohscroll; ]
The second parameter 6 is used to indicate that we want to think of these cycles as permutations living inside S[6] (i.e., permutations of length 6). Without this we get slightly different results:
:[font = input; preserveAspect; nowordwrap; ]
ToPermutation[a]
ToPermutation[b]
:[font = text; inactive; preserveAspect; nohscroll; ]
As usual, when a new function is encountered, it is good to learn more about it:
:[font = input; preserveAspect; nowordwrap; ]
?ToPermutation
:[font = text; inactive; preserveAspect; nohscroll; ]
Since the cycles a, b, and c are really permutations in S[6], it makes sense to multiply these:
:[font = input; preserveAspect; nowordwrap; ]
MultiplyCycles[a, b]
MultiplyCycles[b, a]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here's a shortcut for multiplying cycles:
:[font = input; preserveAspect; nowordwrap; ]
a @ b
b @ a
:[font = text; inactive; preserveAspect; nohscroll; ]
What happens if we multiply two cycles from another permutation. Evaluate the following lines of code until you get a cycle representation consisting of at least two cycles, each of which has length at least 2.
:[font = input; preserveAspect; nowordwrap; ]
p2 = RandomPermutation[9]
ToCycles[p2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Multiply the two cycles by hand. Confirm your work with Mathematica.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the following permutation in S[8]:
:[font = input; preserveAspect; nowordwrap; ]
q = {1, 2, 3, 4, 5, 7, 6, 8}
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's view this in matrix form.
:[font = input; preserveAspect; nowordwrap; ]
PermutationMatrix[q]
:[font = text; inactive; preserveAspect; nohscroll; ]
It is clear that the only "action" in the permutation is that 6 goes to 7 and 7 goes to 6; everything else goes to itself. What happens when we view this using cycles?
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[q]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Give a reasonable explanation why the cycles (1), (2), (3), (4) and (5) are omitted in this cycle list. Additionally, explain why (8) is included.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
When do two cycles commute? Try the following.
:[font = input; preserveAspect; nowordwrap; ]
Cycle[2, 3, 4] @ Cycle[5, 6]
Cycle[5, 6] @ Cycle[2, 3, 4]
:[font = input; preserveAspect; nowordwrap; ]
Cycle[2, 3, 4] @ Cycle[3, 6]
Cycle[3, 6] @ Cycle[2, 3, 4]
:[font = text; inactive; preserveAspect; nohscroll; ]
The following picks a random permutation from S[6], converts it to cycles and then grabs the first cycle and calls it a. This is repeated to obtain b. These are then multiplied, in both orders (a * b and b * a).
:[font = input; preserveAspect; nowordwrap; ]
a = First[ToCycles[RandomPermutation[6]]]
b = First[ToCycles[RandomPermutation[6]]]
MultiplyCycles[a, b]
MultiplyCycles[b, a]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Keep evaluating the above code until you can make a conjecture regarding when two cycles will commute. (Evaluate it 5 times at a minimum.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's pick a cycle from some permutation in S[6].
:[font = input; preserveAspect; nowordwrap; ]
a = First[ToCycles[RandomPermutation[6]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
What is the order of this element? (Recall that the order of an element g in a finite group G is the least positive integer n such that g^n is the identity of the group. In S[6], the identity is {1, 2, 3, 4, 5, 6}.)
:[font = input; preserveAspect; nowordwrap; ]
OrderOfElement[S[6], ToPermutation[a, 6]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try this again:
:[font = input; preserveAspect; nowordwrap; ]
a = First[ToCycles[RandomPermutation[6]]]
OrderOfElement[S[6], ToPermutation[a, 6]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Keep evaluating the above code until you can make a conjecture regarding the order of a cycle. How might a proof go?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now that we know how to find the order of any cycle, and we know that all permutations can be written as a product of disjoint cycles, let's see if we can determine the order of an arbitrary permutation.
:[font = input; preserveAspect; nowordwrap; ]
p = RandomPermutation[7]
ToCycles[p]
OrderOfElement[S[7], p]
(* read the following question next *)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Why do you think this first warning message is given?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
We will try again, following the instructions.
:[font = input; preserveAspect; nowordwrap; ]
p = RandomPermutation[7]
ToCycles[p]
OrderOfElement[S[7, IndexLimit -> 7], p]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Keep evaluating the above code until you can make a conjecture regarding the order of a permutation. Make sure you get some permutations with two or more cycles before forming a conjecture.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we want to think about permutations in terms of 2-cycles (not to be confused with bicycles---here we mean cycles of length two), which are also called transpositions. 
:[font = text; inactive; preserveAspect; nohscroll; ]
Before continuing on that thread, an observation needs to be made, if not already observed. Note that when a permutation is given in cycle notation, sometimes singleton cycles (cycles of length 1) show up, as below:
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[{2, 1, 3}]
:[font = text; inactive; preserveAspect; nohscroll; ]
In this case, the permutation can really be thought of just as the transposition (1, 2) since the 1-cycle (3) really acts like the identity permutation---the three goes to itself and everything is fixed! Keep this in mind as we continue below.
:[font = text; inactive; preserveAspect; nohscroll; ]
First we will pick a random permutation, convert it to cycles and pick one of these cycles at random. The code in the next cell might look a little confusing, but it is set up to give a cycle with length at least 3.
:[font = input; preserveAspect; nowordwrap; ]
long = False;
While[Not[long],
		a = First[Randomize[ToCycles[p = RandomPermutation[7]]]];
		long = Length[a] >= 3]
a
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we convert this cycle to a product of transpositions. It is important to note that these transpositions are not disjoint.
:[font = input; preserveAspect; nowordwrap; ]
transp = ToTranspositions[a]
:[font = text; inactive; preserveAspect; nohscroll; ]
If we multiply these cycles together,
:[font = input; preserveAspect; nowordwrap; ]
MultiplyCycles[transp]
:[font = text; inactive; preserveAspect; nohscroll; ]
we get a permutation as the output, and so we can convert it back to cycle notation:
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now this should be where we started out. Therefore, converting to transpositions is a safe operation and one that can be undone by multiplying them out. What can be obtained by writing a cycle as a product of transpositions?
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's pick two random cycles from two random permutations, convert them to a product of transpositions and look at the number of transpositions obtained from each cycle:
:[font = input; preserveAspect; nowordwrap; ]
a = First[Randomize[ToCycles[RandomPermutation[7]]]]
b = First[Randomize[ToCycles[RandomPermutation[7]]]]
:[font = input; preserveAspect; nowordwrap; ]
transpa = ToTranspositions[a]
transpb = ToTranspositions[b]
:[font = input; preserveAspect; nowordwrap; ]
Length[transpa]
Length[transpb]
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we form the product of the two cycles we found above and convert it back to cycle notation. Now we want to convert this list of cycles into transpositions, so we apply the function ToTranspositions to each cycle in the list (this is what the second line does). Since this has extra levels of {}'s, we "flatten" out the unnecessary levels and then count how many are in the list.
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[MultiplyCycles[a, b]]
Map[ToTranspositions, %]
:[font = input; preserveAspect; nowordwrap; ]
Flatten[%, 1]
Length[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
Compare this length with the two lengths above it. We will look at this process again, this time suppressing all output except the counts:
:[font = input; preserveAspect; nowordwrap; ]
a = First[Randomize[ToCycles[RandomPermutation[7]]]];
b = First[Randomize[ToCycles[RandomPermutation[7]]]];
transpa = ToTranspositions[a];
transpb = ToTranspositions[b];
Length[transpa]
Length[transpb]
:[font = input; preserveAspect; nowordwrap; ]
ToCycles[MultiplyCycles[a, b]];
Map[ToTranspositions, %];
Flatten[%, 1];
Length[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
The first value is the number of transpositions in the first cycle, the second value is the number of transpositions in the second cycle, and the third value is the number of transpositions in the product of the two cycles.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Keep evaluating the above code until you can make a conjecture regarding a relationship between the number of transpositions in the product (the last number) and the number of transpositions in the two factors. Hint: do not try to be too specific.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
There is another function that we can apply to permutations, the Parity function. Let's see how this works.
:[font = input; preserveAspect; nowordwrap; ]
p = RandomPermutation[7]
ToTranspositions[p]
:[font = input; preserveAspect; nowordwrap; ]
Length[%]
Parity[p]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Keep evaluating the above code until you can make a conjecture regarding a relationship between the number of transpositions in a permutation and its parity.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's resume our pursuit that preceded question 12. Here we pick random cycles a and b, form the product and call it p. We convert each of these to transpositions and count these; the first triple is the number of transpositions of each in the list {a, b, p}. Then we also calculate the parity of each and this is reflected in the second triple.
:[font = input; preserveAspect; nowordwrap; ]
a = First[Randomize[ToCycles[RandomPermutation[7]]]];
b = First[Randomize[ToCycles[RandomPermutation[7]]]];
transpa = ToTranspositions[a];
transpb = ToTranspositions[b];
p = MultiplyCycles[a, b];
ToTranspositions[p];
{Length[transpa], Length[transpb], Length[%]}
{Parity[ToPermutation[a, 7]], 
	Parity[ToPermutation[b, 7]], Parity[p]}
:[font = text; inactive; preserveAspect; nohscroll; ]
The output is {# transp. in a, # transp. in b, # transp. in a*b} followed by {parity of a, parity of b, parity of a*b}.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Keep evaluating the above code until you can make a conjecture regarding a relationship between the parity of a product and the parity of its factors. Now go back to questions 12 and 13 and see if you have any changes to make; if so, state them here.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
A permutation with parity 1 is called an even permutation and if the parity is -1, we call it an odd permutation. We have two functions to test evenness and oddness of permutations:
:[font = input; preserveAspect; nowordwrap; ]
p = RandomPermutation[6]
:[font = input; preserveAspect; nowordwrap; ]
OddPermutationQ[p]
EvenPermutationQ[p]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Using your knowledge about sums of odd and even integers and how products result from various combinations of -1 and 1, do you see any connection between parity and the number of transpositions? State them.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
7.7 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?PermutationMatrix
:[font = input; preserveAspect; nowordwrap; ]
?MultiplyPermutations
:[font = input; preserveAspect; nowordwrap; ]
?ToCycles
:[font = input; preserveAspect; nowordwrap; ]
?FromCycles
:[font = input; preserveAspect; nowordwrap; ]
?ToPermutation
:[font = input; preserveAspect; nowordwrap; ]
?MultiplyCycles
:[font = input; preserveAspect; nowordwrap; ]
?RandomPermutation
:[font = input; preserveAspect; nowordwrap; ]
?OrderOfElement
:[font = input; preserveAspect; nowordwrap; ]
?S
:[font = input; preserveAspect; nowordwrap; ]
?Length
:[font = input; preserveAspect; nowordwrap; ]
?ToTranspositions
:[font = input; preserveAspect; nowordwrap; ]
?Parity
:[font = input; preserveAspect; nowordwrap; ]
?ToTranspositions
:[font = input; preserveAspect; nowordwrap; ]
?OddPermutationQ
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?EvenPermutationQ
^*)