(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 8. Isomorphisms
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should be familiar with the basic properties of groups to be able to compare the various pairs of groups that you will be asked to examine. No previous labs are necessary.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab explores the notion of isomorphisms. First we define an isomorphism and then we see how one can be constructed. Next, we explore when two groups are isomorphic.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.3 What is an isomorphism?
:[font = text; inactive; preserveAspect; nohscroll; ]
Before beginning, we read in the necessary code for this lab:
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's consider two groups, G1 and G2 as defined below.
:[font = input; preserveAspect; nowordwrap; ]
G1 = U[10]
G2 = Z[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
An important question in abstract algebra (and in mathematics in general) is "When are two objects the 'same' by some appropriate measurement?". In this case, are groups G1 and G2 the same? Clearly they have different elements and different operations, so they are not identical. They do, however, both have 4 elements and in this way they are the same. Therefore, we can construct a one-to-one, onto function (bijection) from G1 to G2. In fact, there are 24 different ways of setting up such functions.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Explain how one comes up with 24 different bijections from G1 to G2. How many functions (bijections or not) from G1 to G2?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
If we only consider the number of elements (four in each, in our case), we ignore a large portion of the richness of groups. When we only consider this, the operation is being ignored altogether. Since each group has a special element, the identity, it may be reasonable to want to match these up.
:[font = input; preserveAspect; nowordwrap; ]
GroupIdentity[G1]
GroupIdentity[G2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Thus, if we want to define a function f : G1 -> G2 that somehow illustrates "sameness," we might want to define f(1) = 0.
:[font = input; preserveAspect; nowordwrap; ]
Clear[f]
f[1] = 0
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. With this assumption, how many different bijections are there from G1 to G2?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
We need three more matches to make a bijection. Consider the element 3 in G1. To what should it be mapped? Is there any special property related to 3 that should also exist with the element in G2 to which it will be mapped? What about the order of 3?
:[font = input; preserveAspect; nowordwrap; ]
OrderOfElement[G1, 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
It would seem reasonable to want to map this to an element in G2 of the same order. What are the orders of the elements in G2?
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[G2]
:[font = text; inactive; preserveAspect; nohscroll; ]
If the output is not clear, ask about the function:
:[font = input; preserveAspect; nowordwrap; ]
?OrderOfAllElements
:[font = text; inactive; preserveAspect; nohscroll; ]
So we see that the two elements 1 and 3 in G2 both have order 4. (Of course, you may have already known this, but this illustrates a general process one might take.) Suppose that we map 3 in G1 to 1 in G2.
:[font = input; preserveAspect; nowordwrap; ]
f[3] = 1
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. With this assumption, now how many different bijections are there from G1 to G2?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we are mapping 3 to 1, it might be reasonable to map the inverse of 3 in G1 to the inverse of 1 in G2. (Again, you should already know the results of the following, but this illustrates a general procedure.)
:[font = input; preserveAspect; nowordwrap; ]
GroupInverse[G1, 3]
GroupInverse[G2, 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
So we will map 7 in G1 to 3 in G2:
:[font = input; preserveAspect; nowordwrap; ]
f[7] = 3
:[font = text; inactive; preserveAspect; nohscroll; ]
Since |g| = |g^(-1)|, we know that the orders in this assignment match. The two remaining elements are put together by default:
:[font = input; preserveAspect; nowordwrap; ]
f[9] = 2
:[font = text; inactive; preserveAspect; nohscroll; ]
Do the orders match in this case?
:[font = input; preserveAspect; nowordwrap; ]
OrderOfElement[G1, 9]
OrderOfElement[G2, 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Indeed. If all we care about is whether orders match up, we are done and we might call these two groups the same. 

There might be other issues to consider, however. In G1, when we multiply 7 by 9 we get 3:
:[font = input; preserveAspect; nowordwrap; ]
op1 = Operation[G1];
op1[7, 9]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's review our definition of f:
:[font = input; preserveAspect; nowordwrap; ]
?f
:[font = text; inactive; preserveAspect; nohscroll; ]
We see that 7 is mapped to 3 and 9 is mapped to 2. What happens if we add 3 (the image of 7) and 2 (the image of 9) in G2? Surely we get 1.
:[font = input; preserveAspect; nowordwrap; ]
op2 = Operation[G2];
op2[3, 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
More importantly, observe that 1 = 3 + 2 = f(7) + f(9) but also 1 = f(3) = f(7 * 9). In other words, 
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
f(7 * 9) = f(7) + f(9).
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that on the left-hand side, the operation inside the parentheses is taking place inside G1 (the domain of f), while the operation on the right-hand side is taking place inside G2. In this case, we say f is "operation preserving" for the elements 7 and 9. What about other pairs? We can make a table and check all possibilities:
:[font = input; preserveAspect; nowordwrap; ]
els = Elements[G1]
Table[f[op1[Part[els, i], Part[els, j]]] == 
	op2[f[Part[els, i]], f[Part[els, j]]], {i, 4}, {j, 4}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Or if you want to see more details:
:[font = input; preserveAspect; nowordwrap; ]
ListOperationPreservingElements[f, G1, G2]
:[font = text; inactive; preserveAspect; nohscroll; ]
This shows that the function f is operation preserving for all the elements in G1. This is when algebraists are satisfied with calling two groups G1 and G2 the same: there exists a bijection f : G1 -> G2 that is operation-preserving in the sense that 
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
f(x * y) = f(x) * f(y)
:[font = text; inactive; preserveAspect; nohscroll; ]
for all elements x and y in G1 (with the understanding that on the left-hand side the operation taking place between x and y is the operation in G1 and the operation taking place on the right-hand side between f(x) and f(y) is taking place in G2). In such a case, the two groups are said to be isomorphic and the defining function f is said to be an isomorphism.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Change G1 to U[8] and determine if U[8] and Z[4] are isomorphic. If so, provide the isomorphism; if not, indicate why not. (Clear[f] before beginning.)
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.4 Creating Morphoids
:[font = text; inactive; preserveAspect; nohscroll; ]
In previous labs, we have used a structure called a Groupoid when we to worked with groups. Now we use a structure called a Morphoid to work with morphisms, including homomorphisms and isomorphisms. Recall from the previous section that an isomorphism f between two groups is a bijective (one-to-one and onto) mapping such that f(x * y) = f(x) * f(y) for all elements x and y in the domain. If we relax the condition that f is bijective, and only require the "operation-preserving" part, we have a homomorphism. A Morphoid is a structure that has the potential of being a homomorphism (and therefore potentially also an isomorphism).

Recall that our function f was defined as follows:
:[font = input; preserveAspect; nowordwrap; ]
Clear[f];
f[1] = 0;
f[3] = 1;
f[7] = 3;
f[9] = 2;
:[font = text; inactive; preserveAspect; nohscroll; ]
We can use FormMorphoid to create a Morphoid based on f.
:[font = input; preserveAspect; nowordwrap; ]
func1 = FormMorphoid[f, U[10], Z[4]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Alternatively we can set up a list of rules that are equivalent to f.
:[font = input; preserveAspect; nowordwrap; ]
rules = Map[Rule[#, f[#]]&, Elements[U[10]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The FormMorphoid function can also handle a list of rules to create a Morphoid.
:[font = input; preserveAspect; nowordwrap; ]
func1alt = FormMorphoid[rules, U[10], Z[4]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The two Morphoids func1 and func1alt appear to be different, but they are really the same. Morphoids can be defined either by a list of rules or a function. If the underlying correspondences between the elements of the Groupoids are the same, the Morphoids are considered to be equal.
:[font = input; preserveAspect; nowordwrap; ]
EqualMorphoidQ[func1, func1alt]
:[font = text; inactive; preserveAspect; nohscroll; ]
We already know (from above) that func1 is an isomorphism. Let's set this knowledge aside for the moment (for the sake of learning how to use some of the available tools in situations where we don't know if we have an isomorphism). What we want to know is whether, for any given pair of elements in G1, the operations are preserved?

First we will take a specific pair, 9 and 3.
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[func1, {9, 3}, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
In this case, we see that f(9 * 3) does equal f(9) + f(3), since 9 * 3 is 7 in G1 and the image of 7 is 3, which happens to be the sum of 2 (the image of 9) and 1 (the image of 3). Note that the operation in G1 is multiplication (hence, *), whereas it is addition in G2 (and so + is used).

Let's pick two random elements and check out whether the operations of G1 and G2 are preserved under the Morphoid func1 (based on f).
:[font = input; preserveAspect; nowordwrap; ]
{g, h} = RandomElements[G1, 2]
PreservesQ[func1, {g, h}, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Run the two lines of code again several times. Did you find any case where the operations were not preserved? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that PreservesQ is used when one wishes to explore whether a function is operation preserving for a particular pair of elements. More generally, we are interested in doing this for all possible pairs. The function MorphismQ does this for us. Here we use it in the Visual mode; pairs that are preserved are colored at their point of intersection in the table.
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[func1, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
One can also check to see if func1 is an isomorphism, besides being a homomorphism:
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[func1]
:[font = text; inactive; preserveAspect; nohscroll; ]
In case one begins to think that having a homomorphism happens naturally, let's take a look at an example where not all the elements preserve the operation. Below we define a Morphoid func2 that has Z[4] as its domain and Z[5] for its codomain and the rule to get from the domain to the codomain is to take an element from Z[4], add 1, and then reduce this result mod 5.
:[font = input; preserveAspect; nowordwrap; ]
func2 = FormMorphoid[Mod[# + 1, 5]&, Z[4], Z[5]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's check out which elements preserve the operations:
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[func2, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
We see that some do and some do not. In particular, since the entry at the intersection of the row headed by 1 and column headed by 2 is not colored, func2 is not operation-preserving for the pair (1,2). Let's look at this in detail.
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[func2, {1, 2}, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Explain in your own words how and why this failed. Why did the operations not get preserved?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
As you work with homomorphisms in greater detail, you will learn about the kernel and the image of a homomorphism. For the two Morphoids created above, we illustrate how to obtain the kernel and image.
:[font = input; preserveAspect; nowordwrap; ]
K1 = Kernel[func1]
I1 = Image[func1]
:[font = input; preserveAspect; nowordwrap; ]
K2 = Kernel[func2]
I2 = Image[func2]
:[font = text; inactive; preserveAspect; nohscroll; ]
The operations of these Groupoids are
:[font = input; preserveAspect; nowordwrap; ]
Map[Operation, {K1, I1, K2, I2}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Which of these four (the two kernels and the two images) are groups? Justify your answer.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.5 Seeing isomorphisms
:[font = text; inactive; preserveAspect; nohscroll; ]
Often, by looking at appropriate data, one can almost literally "see" an isomorphism at hand. Here we look at some examples.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.5.1 example 1
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the example with which we first started:
:[font = input; preserveAspect; nowordwrap; ]
G1 = U[10]
G2 = Z[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at the Cayley tables of these two groups:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[{G1, G2}, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
Above we showed that these two groups were isomorphic. Wouldn't one think, then, that their Cayley tables should be identical? Think about why they are not. 

Perhaps if we ordered the elements in the second table in the order corresponding to the first (via our isomorphism), we might obtain different results:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[{{G1}, {G2, TheSet -> {0, 1, 3, 2}}}, 
	Mode -> Visual];
	(* note that each group, with its options, needs to
	be in its own list *)
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This looks better. Now the isomorphism is clear.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.5.2 example 2
:[font = text; inactive; preserveAspect; nohscroll; ]
We will now consider U[10] and another group of order 4:
:[font = input; preserveAspect; nowordwrap; ]
G1 = U[10]
G2 = U[12]
:[font = text; inactive; preserveAspect; nohscroll; ]
Are these two isomorphic?
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[{G1, G2}, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
Certainly the two tables do not look alike, but we know that this does not necessarily mean that the two groups are not isomorphic. Below we rearrange the elements of U[10].
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[{{G1, TheSet -> {1, 9, 3, 7}}, {G2}}, 
	Mode -> Visual];
	(* note that each group, with its options, needs to
	be in its own list *)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Try other arrangements for the elements in U[10] until you show the two groups are isomorphic or conclude that they are not isomorphic. If they are isomorphic, describe how the isomorphism map works; if they are not isomorphic, explain why not.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.5.3 example 3
:[font = text; inactive; preserveAspect; nohscroll; ]
We now consider the group D[2] and its Cayley table.
:[font = input; preserveAspect; nowordwrap; ]
G1 = Dihedral[2]

CayleyTable[G1, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
We have seen several other groups of order four. Find one that is isomorphic to D[2]. Define it below and then show the Cayley tables side by side.
:[font = input; preserveAspect; nowordwrap; ]
G2 = (* <--- fill in your group here *)
:[font = input; preserveAspect; nowordwrap; ]
(* make sure G2 has been defined above before preceding *)
CayleyTable[{G1, G2}, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
If the elements in G2 are not arranged to properly reflect the isomorphism, do so below.
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[{{G1},
  {G2, TheSet->{(* fill in the ordered set here *)}}}, 
	Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. What is the other group to which Dihedral[2] is isomorphic and what are the details of the isomorphism? (Specify which elements are mapped to which.)
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.5.4 example 4
:[font = text; inactive; preserveAspect; nohscroll; ]
Below are several groups of order 6.
:[font = input; preserveAspect; nowordwrap; ]
SL22 = FormGroupoid[{{{0, 1}, {1, 0}}, {{0, 1}, {1, 1}}, 
	{{1, 0}, {0, 1}}, {{1, 0}, {1, 1}}, {{1, 1}, {0, 1}}, 
	{{1, 1}, {1, 0}}}, Mod[#1.#2, 2]&, WideElements -> True,
	GroupoidName -> "SL[2, 2]"];
	(* two-by-two matrices with entries from Z[2] and determinant 1*)

G1 = U[9]
G2 = Z[6]
G3 = Symmetric[3]
G4 = Dihedral[3]
G5 = SL22 
G6 = DirectSum[Z[2], Z[3]] (* pairs {x, y} with x from Z[2] and
	y from Z[3] - operation is done component-wise *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Are any of these isomorphic to one another? Below are some tools that you may wish to employ:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[{G1, G2, G3, G4, G5, G6}, Mode -> Visual];
(* after evaluating this, you may wish to enlarge the 
graphic by selecting it and then dragging from a corner *)
:[font = input; preserveAspect; nowordwrap; ]
AbelianQ[{G1, G2, G3, G4, G5, G6}]
:[font = input; preserveAspect; nowordwrap; ]
CyclicQ[{G1, G2, G3, G4, G5, G6}]
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[{G1, G2, G3, G4, G5, G6}]//TableForm[#, 
	TableDepth -> 1]&
:[font = input; preserveAspect; nowordwrap; ]
OrderOfAllElements[{G1, G2, G3, G4, G5, G6}, Mode ->Textual];
:[font = input; preserveAspect; nowordwrap; ]
?GroupCenter
:[font = input; preserveAspect; nowordwrap; ]
Map[GroupCenter, {G1, G2, G3, G4, G5, G6}]//ColumnForm
:[font = input; preserveAspect; nowordwrap; ]
?CommutatorSubgroup
:[font = input; preserveAspect; nowordwrap; ]
Map[Elements[CommutatorSubgroup[#]]&,
	{G1, G2, G3, G4, G5, G6}]//ColumnForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. For every pair (Gi, Gj) of groups in {G1, G2, G3, G4, G5, G6}, determine whether Gi is ismorphic to Gj. Note: there are "six-choose-two" such pairs to consider.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. You probably found that D[3] was isomorphic to at least one of the other groups. Below, we use the variable otherGroup to denote the group you had in mind; change G4 to the group you have in mind and evaluate the following cell. You will now see the list of elements in your chosen group. Between the {} on the right-hand side of orderedElementsOfOtherGroup, place the elements of your chosen group matched up according to the elements of D[3]. After double-checking your ordering, evaluate the cell and the cell that defines the rules for this isomorphism, as well as the Morphoid f itself. Now use the tools illustrated above and verify that f is indeed an isomorphism (assuming you correctly found an isomorphic group).
:[font = input; preserveAspect; nowordwrap; ]
otherGroup = G4
Elements[otherGroup]
Elements[Dihedral[3]]
:[font = input; preserveAspect; nowordwrap; ]
orderedElementsOfOtherGroup = {}
:[font = input; preserveAspect; nowordwrap; ]
rules = Transpose[{Elements[Dihedral[3]],
	orderedElementsOfOtherGroup}]/.{x_, y_} -> Rule[x, y]
	
f = FormMorphoid[rules, Dihedral[3], otherGroup]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Consider the set H = {1, Rot, Rot^2}, which is a subgroup of Dihedral[3]. What is the image of H under f? (You may wish to use the line below.) Is this also a subgroup of the image of Dihedral[3]?
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
Image[f, {1, Rot, Rot^2}]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.6 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?GroupIdentity
:[font = input; preserveAspect; nowordwrap; ]
?OrderOfElement
:[font = input; preserveAspect; nowordwrap; ]
?OrderOfAllElements
:[font = input; preserveAspect; nowordwrap; ]
?GroupInverse
:[font = input; preserveAspect; nowordwrap; ]
?Operation
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?FormMorphoid
:[font = input; preserveAspect; nowordwrap; ]
?EqualMorphoidQ
:[font = input; preserveAspect; nowordwrap; ]
?PreservesQ
:[font = input; preserveAspect; nowordwrap; ]
?RandomElements
:[font = input; preserveAspect; nowordwrap; ]
?MorphismQ
:[font = input; preserveAspect; nowordwrap; ]
?IsomorphismQ
:[font = input; preserveAspect; nowordwrap; ]
?Kernel
:[font = input; preserveAspect; nowordwrap; ]
?Image
:[font = input; preserveAspect; nowordwrap; ]
?CayleyTable
:[font = input; preserveAspect; nowordwrap; ]
?TheSet
:[font = input; preserveAspect; nowordwrap; ]
?Symmetric
:[font = input; preserveAspect; nowordwrap; ]
?DirectSum
:[font = input; preserveAspect; nowordwrap; ]
?AbelianQ
:[font = input; preserveAspect; nowordwrap; ]
?CyclicQ
:[font = input; preserveAspect; nowordwrap; ]
?GroupCenter
:[font = input; preserveAspect; nowordwrap; ]
?CommutatorSubgroup
:[font = input; preserveAspect; nowordwrap; ]
?ToRules
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?InnerAutomorphismGroup
^*)