(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 11. Cosets
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab is self-contained. No prior labs need to be completed to attempt this one. One should be familiar with the basic groups such as Z[n], U[n] and Dihedral[n].
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab explores the notion of cosets. We will look at how cosets are determined, the different types of cosets and some of the properties of cosets.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.3 Cosets, left and right
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we start with some group G, say the dihedral group of order 8, D4. (First, we read in the necessary Mathematica code.)
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect; nowordwrap; ]
G = Dihedral[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider a subgroup of G, say H = {1, Rot^2}, consisting of the identity and the 180 degree rotation (when we view D4 as the symmetries of the square).
:[font = input; preserveAspect; nowordwrap; ]
H = {1, Rot^2}
:[font = text; inactive; preserveAspect; nohscroll; ]
We would like to take another element g from G and multiply it by all the elements in H. Suppose we choose one of the reflections, say Ref. Before multiplying, we need to first choose on which side to multiply Ref, since this group is not Abelian. We also need to find a way of calculating this product in Mathematica. 

If one has a function f of two variables (such as f(x, y) = x^2 + y^2), and one wants to hold one variable fixed and let the other roam over some fixed set, one can do this using the Map function as follows:
:[font = input; preserveAspect; nowordwrap; ]
Clear[f, x, y]
f[x_, y_] := x^2 + y^2
Map[f[2, #]&, {-2, -1, 0, 1, 2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
The expression f[2, #]& indicates that all the elements in the list {-2, -1, 0, 1, 2} should, one at a time, be placed in for the # and then f can be properly evaluated with the two arguments (the first always being 2, in this example). Think about what the following will return; don't evaluate it until you have made some (educated) guess.
:[font = input; preserveAspect; nowordwrap; ]
Map[f[#, 1]&, {-2, -1, 0, 1, 2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
We will use this mapping principle to calculate our product of Ref times the elements in H. First we need the group's operation, which is a function of two variables. The following allows us to use op as a short name for the operation. (The semicolon suppresses the actual definition, since its details are not important.)
:[font = input; preserveAspect; nowordwrap; ]
op = Operation[G];
(* the ; suppresses any output, so don't expect any *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we will use op to do the calculations, placing Ref on the left (as the first operand).
:[font = input; preserveAspect; nowordwrap; ]
Map[op[Ref, #]&, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
This result is called the left coset of H in G containing g (where H = {1, Rot^2} and g = Ref). In general, we denote the left coset of H in G containing g by the notation gH. This coset is the set {g * h | h in H}. We define the right coset of H in G containing g in a similar fashion: Hg = {h * g | h in H}. (Note that when a group is written additively, we denote these cosets by g + H and H + g.) We can calculate the right coset in a similar fashion.
:[font = input; preserveAspect; nowordwrap; ]
Map[op[#, Ref]&, H]
(* note that Ref is now the second, or right, operand *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Observe that, in this case, the right coset and the left coset are the same. Suppose we use a new element, g = Rot^2 Ref. 

A technical Mathematica note might be useful here, since in Mathematica we enter Rot^2 Ref as Rot^2 ** Ref. In Mathematica, multiplication is denoted either by juxtaposition, 6 7, or by using the asterisk, 6 * 7.
:[font = input; preserveAspect; nowordwrap; ]
6 7
6 * 7
:[font = input; preserveAspect; nowordwrap; ]
Clear[g, h]
g * h
h * g
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that both g * h and h * g return g h. In other words, by default Mathematica assumes that the multiplication * is commutative and the elements are returned in some canonical order (alphabetically in this case). To force a non-commutative multiplication we use **. 
:[font = input; preserveAspect; nowordwrap; ]
g ** h
h ** g
:[font = text; inactive; preserveAspect; nohscroll; ]
One further note is needed (ONLY for version 2.2). Consider the following.
:[font = input; preserveAspect; nowordwrap; ]
h^2 * g
h^2 ** g
:[font = text; inactive; preserveAspect; nohscroll; ]
You can ignore the following technical jargon, but you need to heed the moral given at the end. Note that ** has higher precedence than ^, while * has lower precedence than ^. This can be seen above because h^2 ** g becomes h^(2 ** g) since ** acted first and took its two arguments, 2 and g, and then ^ was allowed to act and take its one argument, 2 ** g. On the other hand, with h^2 * g we have the * having lower precedence and so ^ acts first taking the 2 and then * acts taking its two arguments, h^2 and g. A canonical ordering (alphabetical here) takes place and this becomes g h^2. MORAL OF THE STORY: When you write elements such as Rot^2 Ref, they must be written (in Mathematica) as (Rot^2) ** Ref (with parentheses to override natural precedence). Again, note that this is ONLY for version 2 since in version 3 Mathematica switches the precedence order on these two.

Now let's try calculating the left coset of H in G containing Rot^2 Ref.
:[font = input; preserveAspect; nowordwrap; ]
Map[op[(Rot^2) ** Ref, #]&, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this is the same result (as sets they don't need to be in the same order) as what we had for the left coset of H in G containing Ref.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Calculate both the left and right cosets of H in G containing Rot. Are they the same?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since this is a somewhat awkward way of calculating cosets (though it conveys exactly what is happening), let's use another method. We have functions LeftCoset and RightCoset that give us what we want:
:[font = input; preserveAspect; nowordwrap; ]
?LeftCoset
:[font = input; preserveAspect; nowordwrap; ]
LeftCoset[G, H, (Rot^2) ** Ref]
RightCoset[G, H, (Rot^2) ** Ref]
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we consider another group, say Z[8], and let H = {0, 2, 4, 6}.
:[font = input; preserveAspect; nowordwrap; ]
G = Z[8]
H = {0, 2, 4, 6}
SubgroupQ[H, G]
:[font = text; inactive; preserveAspect; nohscroll; ]
(SubgroupQ is a function that one can use to test to see if a set is truly a subgroup or not. We want to make sure that H is a subgroup before we try making cosets.)

Let's try some cosets.
:[font = input; preserveAspect; nowordwrap; ]
LeftCoset[G, H, 0]
LeftCoset[G, H, 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
For a little more information, try the Textual mode:
:[font = input; preserveAspect; nowordwrap; ]
LeftCoset[G, H, 1, Mode -> Textual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is this last coset from another perspective:
:[font = input; preserveAspect; nowordwrap; ]
LeftCoset[G, H, 1, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
To get all the cosets, we can use our Map function and map the LeftCoset function across the whole set of elements of G.
:[font = input; preserveAspect; nowordwrap; ]
Map[LeftCoset[G, H, #]&, Elements[G]]
:[font = text; inactive; preserveAspect; nohscroll; ]
This can be understood better, perhaps, by viewing both the coset and the element that generates the coset; try the following.
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, LeftCoset[G, H, #]}&, Elements[G]]//ColumnForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. What observations can you make about these cosets? If you can't think of anything, try the following (but try to think of something first).
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, Sort[LeftCoset[G, H, #]]}&, Elements[G]]//ColumnForm
:[font = text; inactive; preserveAspect; nohscroll; ]
Now compare the left cosets and the right cosets of H = {0, 2, 4, 6} in G = Z8.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "g + H", "H + g\n"}}, 
	TableDepth -> 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
In each row, the first element is the element that we are multiplying by (adding to, in this case) our set H. (This element is usually called a coset representative.) The second item is the left coset and the third is the corresponding right coset.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. What observations can you make about the relationship between these left and right cosets?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Lest you jump to a false conclusion, let's consider another example.
:[font = input; preserveAspect; nowordwrap; ]
G = Symmetric[3]
H = {{1, 2, 3}, {1, 3, 2}}
SubgroupQ[H, G]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now that we know that H is a subgroup of G, we can consider the various left and right cosets.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "gH", "Hg\n"}}, 
	TableDepth -> 2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. What observations can you make about the relationship between these left and right cosets?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.4 Properties of cosets
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look for some common properties among the three collections of cosets found above.
:[font = input; preserveAspect; nowordwrap; ]
G = Dihedral[4];
H = {1, Rot^2};
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "gH", "Hg\n"}}, 
	TableDepth -> 2, TableSpacing -> {0,1}]
:[font = input; preserveAspect; nowordwrap; ]
G = Z[8];
H = {0, 2, 4, 6};
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "g + H", "H + g\n"}}, 
	TableDepth -> 2]
:[font = input; preserveAspect; nowordwrap; ]
G = Symmetric[3];
H = {{1, 2, 3}, {1, 3, 2}};
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableHeadings -> {None, {"g", "gH", "Hg\n"}}, 
	TableDepth -> 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
For each of the following questions, consider the examples above and see if you can provide an answer. (Note that in the following questions we use gH and Hg generically, independent of whether the group G writes the cosets additively or multiplicatively.)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Recall that when we talk about the left (or right) coset of H in G containing g, we call the element g the coset representative of gH (or Hg). Does it appear that g is one of the elements in gH and Hg? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. As you look at the cosets above, when is it the case that gH or Hg actually is the set H? Why is this the case?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Pick any two elements x and y in G. What can you say about the two cosets xH and yH (or, for that matter, the corresponding right cosets)? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. How many different cosets are there for a given group G and subgroup H? Why is this the case?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Although there is only limited evidence (you could produce more, however), what can you say about when we might have the left coset gH equal to the right coset Hg?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. When is the left coset gH (or right coset Hg) a subgroup of G? Are there any conditions that guarantee it?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's consider two more examples of cosets. Instead of using the Map function to get our cosets, we can use the functions LeftCosets and RightCosets
:[font = input; preserveAspect; nowordwrap; ]
?LeftCosets
:[font = input; preserveAspect; nowordwrap; ]
G = U[35];
H = {4, 16, 29, 11, 9, 1};
SubgroupQ[H, G]
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[G, H]
RightCosets[G, H]
:[font = input; preserveAspect; nowordwrap; ]
G = Z[35];
H = {5, 10, 15, 20, 25, 30, 0};
SubgroupQ[H, G]
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[G, H]
RightCosets[G, H]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. For each of the groups above, count the number of cosets (either left or right), and calculate the orders of H and G. Now offer a conjecture.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Suppose G = Z (the integers) and H = 2 Z, the even integers. Verify that H is a subgroup of G. Describe the coset 3 + H.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]

Q13. Suppose G = Z (the integers) and H = 5 Z, the multiples of 5. Suppose x and y are the scores of two opponents playing table tennis. There is a change of service whenever the sum of the scores x and y is a multiple of 5 (and so in H). Each score belongs to one of the following cosets: H, 1 + H, 2 + H, 3 + H or 4 + H. (Why?) Is there any relationship between the coset to which x belongs and the one to which -y belongs at the time of the change of service? Can you give a reasonable explanation for this?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Suppose G = U[5] x Z[4] and H ={{2,2}, {4,0},{3,2}, {1,0}} is a subgroup. Determine the other left cosets by hand. See if you can use Mathematica to confirm your answer.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Dihedral
:[font = input; preserveAspect; nowordwrap; ]
?Map
:[font = input; preserveAspect; nowordwrap; ]
?Operation
:[font = input; preserveAspect; nowordwrap; ]
?NonCommutativeMultiply
:[font = input; preserveAspect; nowordwrap; ]
?LeftCoset
:[font = input; preserveAspect; nowordwrap; ]
?RightCoset
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupQ
:[font = input; preserveAspect; nowordwrap; ]
?Textual
:[font = input; preserveAspect; nowordwrap; ]
?Visual
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?Symmetric
:[font = input; preserveAspect; nowordwrap; ]
?LeftCosets
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?RightCosets
^*)