(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 14: Rotational groups of regular polyhedra
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should know how a group can be generated from a set of elements and a binary operation. You should also be familiar with Euler angles (see the Rotations Lab on the CD for a review) and group actions.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to show how to generate the rotational groups of polyhedra.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.3 Example - the Tetrahedron
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.3.1 Statement of the problem, first rotation
:[font = text; inactive; preserveAspect; nohscroll; ]
First, let's read in the packages and definitions that we will need for this lab. Evaluate the following subsection in entirety.
:[font = subsubsection; inactive; startGroup; Cclosed; nohscroll; ]
Evaluate this section
:[font = input; initialization; preserveAspect; endGroup; nowordwrap; ]
*)
Needs["Graphics`Polyhedra`"];
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
Needs["Geometry`Rotations`"];
Needs["Graphics`Shapes`"];
Needs["NumberTheory`Recognize`"];

wireFrame::usage="wireFrame[polyhedron] draws a labeled wireframe
picture of the polyhedron.";
 
wireFrame[obj_]:=Graphics3D[
  Map[Text[ToString[#],Vertices[obj][[#]]]&,
        Range[1,Length[Vertices[obj]]]]]//
        Show[{WireFrame[obj[]],#},DefaultFont->{"Times",36}]&;

Exact::usage="Exact[x_Real] converts x to an exact number involving
integers and roots (square and cube roots only).";

Exact=Module[{x,t},
   If[Abs[#]<=0.00000001,
         0,
         ((x=#)//Recognize[x,3,t]&//Solve[#==0,t]&//(t/.#)&//
           Select[#,(Abs[x-N[#]]<=0.000001)&]&//First)]]&;

ActionOn::usage="ActionOn[obj, g] is the 3D-graphics object obtained
when rotation matrix g acts on 3D-graphics object obj. This is accomplished
by multiplying every triple of numbers appearing in obj by g.";

ActionOn[obj_,g_]:=
 obj/.{{a_,b_,c_}/;And@@NumberQ/@{a,b,c}:>g.{a,b,c}};

disp::usage="disp[obj] displays list of 3D graphics primitives
in a standard display mode.";

disp=Show[Graphics3D[#],PlotRange->{{-2,2},{-2,2},{-2,2}}]& ;

Compare::usage="Compare[obj, g] displays the 3D-graphics objects
obj and ActionOn[obj, g] side by side.";

Compare=Show[GraphicsArray[
         {Graphics3D[#1,PlotRange->{{-2,2},{-2,2},{-2,2}}],
          Graphics3D[ActionOn[#1,#2],PlotRange->{{-2,2},{-2,2},{-2,2}}]}]]& ;


(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the tetrahedron.
:[font = input; preserveAspect; nowordwrap; ]
object = Tetrahedron[];
object//disp
:[font = text; inactive; preserveAspect; nohscroll; ]
We will be examining certain rotation matrices that act on graphics objects like the Tetrahedron. The function ActionOn will be used extensively in this lab.
:[font = input; preserveAspect; nowordwrap; ]
?ActionOn
:[font = text; inactive; preserveAspect; nohscroll; ]
We want to consider the rotations that make up the so-called rotational group of the tetrahedron, specifically the ones that rotate a tetrahedron so that it occupies the same space as the original object. We can use the function Compare to visually confirm whether a rotation is in the rotation group.
:[font = input; preserveAspect; nowordwrap; ]
?Compare
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is an example of a rotation that we will not want to consider, because the matrix clearly does not return the object to its original position. 
:[font = input; preserveAspect; nowordwrap; ]
Compare[object, RotationMatrix3D[Pi/6, Pi/4, Pi/8]]
:[font = text; inactive; preserveAspect; nohscroll; ]
One example of an element in the rotational group of this tetrahedron is RotationMatrix3D[2Pi/3, 0, 0]. The specific Euler angles that describe this matrix are dependent on the position of the tetrahedron. One of the faces of our object lies on a plane that is parallel to the x-y plane and so a 2Pi/3 rotation about the z-axis is in the rotation group. Also, it is important to note that the tetrahedron needs to be centered about the origin. All polyhedra in the standard Mathematica package Polyhedra.m are centered about the origin.
:[font = input; preserveAspect; nowordwrap; ]
r1 = RotationMatrix3D[2Pi/3, 0, 0];
r1//MatrixForm
:[font = input; preserveAspect; endGroup; nowordwrap; ]
Compare[object, r1]
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.3.2 Generation of more rotations
:[font = text; inactive; preserveAspect; nohscroll; ]
It is not too difficult to identify r1 as a member of the rotational group, but how do we identify more complicated rotations? One way is by multiplying rotations. Given any set of rotations, we can generate a group.
:[font = input; preserveAspect; nowordwrap; ]
G1 = GenerateGroupoid[{r1}, Simplify[#1.#2]&]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is a cyclic subgroup of order three. 
:[font = input; preserveAspect; nowordwrap; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 0; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; bold; fontName = "Courier New"; fontSize = 12; ]
Order[G1]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Is this the whole rotation group? Based on the fact that the faces of a tetrahedron are four identical equilateral triangles, how many elements would you expect to find in its rotational group?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.3.3 Procedure for finding more complicated rotations
:[font = text; inactive; preserveAspect; nohscroll; ]
Although it may be clear that there are more elements, it is probably not obvious what the other rotation matrices are. At this point, we outline a systematic process to find these matrices.

Let's look at a labeled wire-frame picture of the object.
:[font = input; preserveAspect; nowordwrap; ]
?wireFrame
:[font = input; preserveAspect; nowordwrap; ]
wireFrame[Tetrahedron];
:[font = text; inactive; preserveAspect; nohscroll; ]
The first rotation that we identified, r1, maps the (ordered) face {1, 3, 4} into the face {1, 2, 3} and by applying it again, into {1, 4, 2}. Now suppose that we want to map, for example, {1, 3, 4} into {4, 3, 2}. Let R be the unknown matrix.
:[font = input; preserveAspect; nowordwrap; ]
R = Array[r, {3, 3}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Before setting up a system of equations to solve for the rotation matrix, we need to take the vertex coordinates given in the Mathematica Polyhedra package and make them exact. For this we use the function Exact. This function is not very sophisticated, but it will work for the kinds of numbers that we will use.
:[font = input; preserveAspect; nowordwrap; ]
?Exact
:[font = text; inactive; preserveAspect; nohscroll; ]
Here are the vertices given in the package.
:[font = input; preserveAspect; nowordwrap; ]
Vertices[Tetrahedron]
:[font = text; inactive; preserveAspect; nohscroll; ]
The following are exact values.
:[font = input; preserveAspect; nowordwrap; ]
Xvertices = Map[Exact, Vertices[Tetrahedron], {2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Although a system can be generated more efficiently, here we write it out a bit more descriptively.
:[font = input; preserveAspect; nowordwrap; ]
sys = 
{R.Xvertices[[1]]==Xvertices[[4]]  (* vertex 1 maps to vertex 4 *),
R.Xvertices[[3]]==Xvertices[[3]]  (* vertex 3 maps to vertex 3 *),
R.Xvertices[[4]]==Xvertices[[2]]  (* vertex 4 maps to vertex 2 *)}
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we solve the system, use the rules to get values for R, pick out the one and only solution and, finally, simplify the solution.
:[font = input; preserveAspect; nowordwrap; ]
r2 = (R /. Solve[sys, Flatten[R]])//First//Simplify
:[font = text; inactive; preserveAspect; nohscroll; ]
Now the moment of truth: is r2 in the rotational group?
:[font = input; preserveAspect; nowordwrap; ]
Compare[object, r2]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is the rotation matrix that we were looking for. It would be nice to know the values of phi, theta and psi that produce r2.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Determining Euler Angles from a Rotation Matrix:
Determine the values of phi, theta and psi for which RotationMatrix3D[phi, theta, psi] is equal to r2. Hint: To equate two matrices, A and B, and convert to a list of equations, you can use code something like (A == B)//Thread[#]&//Map[Thread[#]&,#]&//Flatten.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now that we have two distinct rotations of the tetrahedron, we might be able to generate a larger group.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
G2 = GenerateGroupoid[{r1, r2}, Simplify[#1.#2]&];
Order[G2]
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.3.4 Verification that we have the complete rotational group
:[font = text; inactive; preserveAspect; nohscroll; ]
This should be the whole group for which we are searching. Now, to demonstrate how the group generates all the rotations, we mark one face and a vertex of the tetrahedron. 
:[font = input; preserveAspect; nowordwrap; ]
markedFace = object[[2]]//
         {#,
         RGBColor[0.022, 0.688, 0.717],
         Thickness[0.01],
         Line[{Apply[Plus, object[[2, 1]]]/3, 1.1 #[[1,1]]}],
         RGBColor[0.701, 0.038, 0.038],
         PointSize[0.03],
         Point[1.1 #[[1, 1]]]}&//disp;
:[font = text; inactive; preserveAspect; nohscroll; ]
First, we look at the individual effects of each group element on this face. You may want to enlarge the graphic that you get here.
:[font = input; preserveAspect; nowordwrap; ]
Map[ActionOn[markedFace, #]&, First[G2]]//
	Partition[#, 4]&//GraphicsArray//Show;
:[font = text; inactive; preserveAspect; nohscroll; ]
Taken together, we get a single tetrahedron with three marks on each face. 
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
Map[ActionOn[markedFace, #]&, First[G2]]//Show;

:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.4 Further exercises
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Rotational Group of the Cube:
(a) How many elements would you expect to find in the group of rotations of the cube?
(b) Generate the group of rotations of Cube[] that is contained in the Polyhedra package. 
:[font = input; preserveAspect; nowordwrap; ]
wireFrame[Cube];
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Rotational Group of the Icosahedron:
(a) How many elements would you expect to find in the group of rotations of the icosahedron?
(b) Generate the group of rotations of Icosahedron[] that is contained in the Polyhedra package. 
:[font = input; preserveAspect; nowordwrap; ]
wireFrame[Icosahedron];
(*Enlarge the graphic if it's too small *)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Rotational Groups of the Octahedron and Dodecahedron:
The octahedron is the dual of the cube. If each face of the cube is replaced with a point at its center and points that are derived from adjacent faces are connected, then the wire frame of an octahedron will appear. Explain why the rotational group of the octahedron should be isomorphic to that of the cube. The icosahedron and dodecahedron pair up in the same way.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. The cuboctahedron can be formed by taking a cube and slicing its six corners off so that the exposed triangular faces just barely meet at one point. It can also be created in the same way starting with an octahedron, thus its name. Determine the number of elements in the rotational group of the cuboctahedron. Is it isomorphic to a group that you've already seen?
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
(* This cell must be evaluated to add
 Cuboctahedron to the Polyhedra list *)
AppendTo[Polyhedra, Cuboctahedron];
Cuboctahedron[Graphics`Polyhedra`Private`opts___] := 
  Polyhedron[Cuboctahedron, Graphics`Polyhedra`Private`opts][[1]]
Vertices[Cuboctahedron]^=
Map[N,{{0, -2^(-1/2), -2^(-1/2)}, {0, -2^(-1/2), 2^(-1/2)}, 
 {0, 2^(-1/2), -2^(-1/2)}, {0, 2^(-1/2), 2^(-1/2)}, 
 {-2^(-1/2), 0, -2^(-1/2)}, {-2^(-1/2), 0, 2^(-1/2)}, 
 {-2^(-1/2), -2^(-1/2), 0}, {-2^(-1/2), 2^(-1/2), 0}, 
 {2^(-1/2), 0, -2^(-1/2)}, {2^(-1/2), 0, 2^(-1/2)}, 
 {2^(-1/2), -2^(-1/2), 0}, {2^(-1/2), 2^(-1/2), 0}}, {2}];
Faces[Cuboctahedron]^={{2, 6, 7}, {2, 6, 4, 10}, {2, 10, 11},
{2, 11, 1, 7}, {11, 10, 12, 9}, {6, 8, 5, 7}, {4, 6, 8}, {3, 5, 8},
{1, 5, 3, 9}, {4, 8, 3, 12}, {4, 10, 12}, {1, 11, 9}, {1, 5, 7}, {3, 9, 12}};
(*
:[font = input; preserveAspect; nowordwrap; ]
wireFrame[Cuboctahedron];
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Why should the method of finding rotation matrices used above work? Let T be a triangle in three dimensional real space whose vertices are linearly independent. Prove that if R is a three by three matrix with the property that the triangle R.T (i.e., Dot[R,T]) is congruent to T, then R is a rotation matrix.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
14.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Tetrahedron
:[font = input; preserveAspect; nowordwrap; ]
?Polyhedra
:[font = input; preserveAspect; nowordwrap; ]
?Vertices
:[font = input; preserveAspect; nowordwrap; ]
?RotationMatrix3D
:[font = input; preserveAspect; nowordwrap; ]
?GenerateGroupoid
:[font = input; preserveAspect; nowordwrap; ]
?Order
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Solve
^*)