(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 4. What does Z[i]/<a+bi> look like?
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Prior to working on this lab, you should be familiar with the term ideal through discussions in class or from Ring Lab 3: An ideal part of rings. One should also be familiar with an integral domain, field, and the characteristic of a ring.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to explore the quotient structure of the Gaussian integers modulo an ideal generated by an arbitrary Gaussian integer.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.3 First example
:[font = text; inactive; preserveAspect; nohscroll; ]
To work on this lab, we need to load the necessary packages.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the problem of investigating the ideal J = <2 + 2i> in the Gaussian integers, Z[i]. In particular, what does the quotient ring Z[i]/<2 + 2i> look like?

First, recall that the set of Gaussian integers is the set {a + b i | a, b in Z}. This forms a lattice in the plane:
:[font = input; preserveAspect; nowordwrap; ]
gr = IntegerLatticeGrid[{-6, 6}, {-6, 6}, 
	AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider the ideal generated by z = 2 + 2i.
:[font = input; preserveAspect; nowordwrap; ]
z = 2 + 2 I
:[font = text; inactive; preserveAspect; nohscroll; ]
What elements are in this ideal? We know, by definition, that all elements of the form r z (where r is in Z[i]) are in this ideal. Suppose we consider r to be an (ordinary) integer and multiply this by z. We might as well try a number of integers at a time.
:[font = input; preserveAspect; nowordwrap; ]
someMultipliers = Table[k, {k, -3, 3}]
:[font = input; preserveAspect; nowordwrap; ]
idealList = someMultipliers z
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's plot these on our lattice. To use ListPlot, we need to convert these complex numbers to ordered pairs.
:[font = input; preserveAspect; nowordwrap; ]
plotOfIdeals = ListPlot[Map[ComplexToPoint, idealList],
	PlotStyle -> {PointSize[0.030], RGBColor[1, 0, 0]},
	DisplayFunction -> Identity];
	
Show[{gr, plotOfIdeals}];
:[font = text; inactive; preserveAspect; nohscroll; ]
What other multiples should we consider? We could multiply by multiples of i.
:[font = input; preserveAspect; nowordwrap; ]
addToIdealList = Table[k I, {k, -3, 3}] z
:[font = input; preserveAspect; nowordwrap; ]
idealList = Join[idealList, addToIdealList]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now look at the set of multiples that we have so far.
:[font = input; preserveAspect; nowordwrap; ]
plotOfIdeals = ListPlot[Map[ComplexToPoint, idealList],
	PlotStyle -> {PointSize[0.030], RGBColor[1, 0, 0]},
	AspectRatio -> Automatic,
	DisplayFunction -> Identity];
	
Show[{gr, plotOfIdeals}];
:[font = text; inactive; preserveAspect; nohscroll; ]
To make sense of this picture, recall that multiplying a complex number by i has the effect of increasing the argument of the complex number (the angle between it and the positive x-axis) by 90 degrees. This explains why the original diagonal is rotated to give us the pattern above.

There are still quite a few elements in the ideal that reside in this rectangle that are not being shown. Perhaps we should multiply all the complex numbers in this grid by z, and then plot all the products that are still within the grid.
:[font = input; preserveAspect; nowordwrap; ]
g = 6; (* our grid window is 6 by 6 *)

pts = Table[{i, j},{i, -g, g}, {j, -g, g}]//Flatten[#, 1]&; 
(* find all integer lattice points in this window *)

cpts = Map[Apply[Complex, #]&, pts]; 
(* convert to the corresponding complex numbers *)

idealList = Intersection[cpts, z cpts] 
(* calculate the product of z times all the points 
determined in cpts and then keeps those still
within the grid (thus the Intersection) *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is the new plot.
:[font = input; preserveAspect; nowordwrap; ]
plotOfIdeals = ListPlot[Map[ComplexToPoint, idealList],
	PlotStyle -> {PointSize[0.030], RGBColor[1, 0, 0]},
	AspectRatio -> Automatic, DisplayFunction -> Identity];
			
Show[{gr, plotOfIdeals}];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. We now see all the elements in J = <2+2i> that are within the window shown. How many elements are there in Z[i]/J? In other words, how many other cosets do you think there are (and then add 1 to account for J)? Note that in the code above, the variable pts records the lattice points and the variable idealList records the members of J, so perhaps these may be useful in helping to answer this question. What do you think is the size of Z[i]/J? Why?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's refer to the list of points in idealList by a different variable so that we can more efficiently do the bookkeeping as we try finding the other cosets. Suppose we use J[0].
:[font = input; preserveAspect; nowordwrap; ]
Clear[J]
J[0] = idealList
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we need to find the other cosets. We will be adding elements to the ideal, as opposed to multiplying, to generate the other cosets. Since we have defined J to be J[0], and we know all cosets are of the form r + J, finding another coset will not be too difficult. We just need to pick another ring element and add it to the elements in J[0]. Which ring element should we add? 

Since we clearly want to pick one that is not already in J, we may need to look at our picture again.
:[font = input; preserveAspect; nowordwrap; ]
Show[{gr, plotOfIdeals}];
:[font = text; inactive; preserveAspect; nohscroll; ]
How about using 1?
:[font = input; preserveAspect; nowordwrap; ]
J[1] = 1 + J[0] 
(* this conveniently adds 1 to every element in J[0] -
This works well since we are dealing with complex numbers.
Equivalently, one could use J[1] = Map[(# + 1)&, J[0]] *)
:[font = text; inactive; preserveAspect; nohscroll; ]
This returns all the elements of J[0] with 1 added to them. In other words, we are building (part of) another coset. Here is a graph showing what we have so far.
:[font = input; preserveAspect; nowordwrap; ]
cosetPlot[2] = ListPlot[Map[ComplexToPoint, J[1]],
	PlotStyle -> {PointSize[0.030], Hue[1/9]}, 
	AspectRatio -> Automatic, DisplayFunction -> Identity];
			
Show[{gr, plotOfIdeals, cosetPlot[2]}];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. How does this graph reflect that J[1] = 1 + J[0]?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Do you want to modify your guess regarding how many cosets there will be? What is your current response?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's pick another element to help find another coset. Additionally, let's begin to automate our process by using the variable index to keep track of the count of the cosets.

Suppose we choose 2 for our new element.
:[font = input; preserveAspect; nowordwrap; ]
newElement = 2  (* place the element here *)
index = 2 			(* use index to record the current count *)
J[index] = newElement + J[0]
(* now calculate the new J[index] by adding newElement *)
:[font = text; inactive; preserveAspect; nohscroll; ]
We now have calculated our third coset, J[2]. (Recall that the first was J[0] and the second was J[1].) Now let's show a graph of our current situation.
:[font = input; preserveAspect; nowordwrap; ]
cosetPlot[index + 1] = ListPlot[Map[ComplexToPoint, J[index]],
	PlotStyle -> {PointSize[0.030], Hue[index/9]}, 
	AspectRatio -> Automatic, DisplayFunction -> Identity];
	
Show[Join[{gr, plotOfIdeals}, Table[cosetPlot[k + 1], {k, 1, index}]]];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Do you want to modify your guess regarding how many cosets there will be? What is your current response?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. By choosing a value for newElement, step through the code below until you have found all the cosets. A suggestion for choosing newElement: pick an uncolored point that is "closest" to the x-axis (where you measure the distance by the absolute value of the angle from the x-axis to the point), but also within a circle of radius |2 + 2i| = 2(2^(1/2)). Keep track of your elements.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
newElement = (* <---- enter new elements here - use I not i *)

index += 1   (* index is automatically updated for you *)

J[index] = newElement + J[0]

cosetPlot[index + 1] = ListPlot[Map[ComplexToPoint, J[index]],
		PlotStyle -> {PointSize[0.030], Hue[index/9]}, 
		AspectRatio -> Automatic, DisplayFunction -> Identity];
		
Show[Join[{gr, plotOfIdeals}, Table[cosetPlot[k + 1], {k, 1, index}]]];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. How many cosets are there? List them.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.3.1 What ring is it?
:[font = text; inactive; preserveAspect; nohscroll; ]
Now that you have found your cosets, let's explore what ring this quotient Z[i]/<2 + 2 i> might be. Since each coset can have one of many different names (or representatives, in the sense that 2 + <5> and 7 + <5> are the same cosets in Z/<5>, but use different representatives), we should first agree on what names to use, so that we can use the same language. (Technically, this is not necessary, but it will be convenient.) Therefore, here is one choice.
:[font = input; preserveAspect; nowordwrap; ]
cosetReps = {0, 1, 2, 2 - I, 2 + I, 1 - I, 1 + I, 1 - 2 I}

cosetRepsPlot = ListPlot[Map[ComplexToPoint, cosetReps],
	PlotStyle -> {PointSize[0.030], Hue[0]}, 
	AspectRatio -> Automatic, DisplayFunction -> Identity];
	
Show[{gr, cosetRepsPlot,
	Graphics[Circle[{0, 0}, Abs[2 + 2I]]]}];
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is another choice, with a different visualization. We will use this choice.
:[font = input; preserveAspect; nowordwrap; ]
QuotientRing[Z[I], 2 + 2I, Mode -> Visual, 
	Form -> Representatives]
:[font = text; inactive; preserveAspect; nohscroll; ]
The representatives are the elements listed in this Ringoid. Additionally, these elements can be found within and on the bold square. In general, the corners of the square are different representatives of the same coset. Also, any element that appears on a side of a square will have a second representative of the same coset on the opposite side of the square.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. There are more Gaussian integers within or on this bold square than there are coset representations in this quotient ring. Which ones are not included in the quotient ring? How are these "extras" related to those in the quotient ring?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Give an explanation for the role that the collection of squares is playing. In particular, address how the other squares relate to the bold one.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we have found all the cosets, we should consider how to add and multiply these cosets. We know that if we add the cosets 4 + 5i + J and 8 + 9i + J, we get 12 + 14i + J. Similarly, the product is -13 + 76i + J. (Double check each of these calculations.) We would, however, like to have these represented by elements of the form z + J, where z is a representative in our quotient ring. First, let's look at another version of the quotient ring, where the elements are given in the form z + J.
:[font = input; preserveAspect; nowordwrap; ]
QR = QuotientRing[Z[I], 2 + 2I]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we can look at the sum and product.
:[font = input; preserveAspect; nowordwrap; ]
Addition[QR][4 + 5I + J, 8 + 9I + J]
Multiplication[QR][4 + 5I + J, 8 + 9I + J]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. From these computations, we see that (4 + 5i + J) + (8 + 9i + J) = 2 + J and (4 + 5i + J) * (8 + 9i + J) = 3 + J. Why is this the case? Look again at the plot given above in the visualization of the quotient ring.

(i) First, find the representatives in the bold square for both 4 + 5i + J and 8 + 9i + J. (The second one may take a little ingenuity with this graph, but you can do it.) 

(ii) Now, add and multiply (by hand) these two representatives. What are these results (before reducing mod <2 + 2i>)?

(iii) Finally, reduce these mod <2 + 2i> so you can find the corresponding representative in the bold square. Are you convinced of these results?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
By looking at the Cayley table, we should be able to answer some questions regarding this ring. (You may wish to enlarge the graphics so you can view them better.)
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[QR, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Is QR a field? Why or why not? Is J = <2 + 2i> a maximal ideal? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Is QR an integral domain? Why or why not? Is J = <2 + 2i> a prime ideal? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. What is the characteristic of QR?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Since the additive group of this ring has order eight, what are the candidates for a group that is isomorphic to this? In other words, what are the groups of order eight?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Which one is this? What group is isomorphic to the additive group of this ring?
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.4 A second example
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we now let J = <3 + i> and consider the quotient ring Z[i]/J. As before, let's view this visually as well.
:[font = input; preserveAspect; nowordwrap; ]
QuotientRing[Z[I], 3 + I, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Try the following to see how this graphic image is built up in stages. (Note: the following cell uses a lot of memory; you may wish to delete previous graphics cells first.)
:[font = input; preserveAspect; nowordwrap; ]
QuotientRing[Z[I], 3 + I, Mode -> Visual, Staged -> All];
:[font = text; inactive; preserveAspect; nohscroll; ]
You can now double-click on any one of the cells and animate the graphics. The speed can be controlled by typing a number from 1 to 9 (1 slow, 9 fast). If you want to see just one stage at a time, the following is an alternative. (If you have limited memory, you may wish to first clear the graphics just generated.)
:[font = input; preserveAspect; nowordwrap; ]
QuotientRing[Z[I], 3 + I, Mode -> Visual, Staged -> True];
:[font = text; inactive; preserveAspect; nohscroll; ]
Now use NextStage to advance (or PreviousStage, if you wish to reverse):
:[font = input; preserveAspect; nowordwrap; ]
NextStage[QuotientRing]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. How many cosets are there?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. What can you say about this quotient ring? What is the size? Is it a field? Is it an integral domain?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Below are some Gaussian integers. You may recall that the absolute value of a complex number a + bi is the length of the vector starting at the origin and terminating at the point (a, b), having the value (a^2 + b^2)^(1/2).
:[font = input; preserveAspect; nowordwrap; ]
someTestCases = {2 + I, 2, 3 + I, 3 + 2I, 2I, 4 - 3I, 7-I}
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, Abs[#], Size[QuotientRing[Z[I], #, Form ->
	Representatives]]}&, someTestCases], TableHeadings -> 
	{None, {"z", "|z|", "|Z[i]/<z>|\n"}}]
:[font = text; inactive; preserveAspect; nohscroll; ]
The output consists of a complex number z, the absolute value of z, followed by the size of the quotient ring formed by Z[i]/<z> (i.e., the number of cosets).
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. Can you make a conjecture regarding the sizes measured above?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. Try to prove your conjecture.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q19. Which of the above do you think are fields? Integral domains? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
You may be interested in trying the following.
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, PrimeQ[#, GaussianIntegers -> True]}&, someTestCases]
:[font = input; preserveAspect; endGroup; nowordwrap; ]
Map[QuotientRing[Z[I], #, Form -> Representatives, 
	Mode -> Visual]&, someTestCases];
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
4.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?IntegerLatticeGrid
:[font = input; preserveAspect; nowordwrap; ]
?ListPlot
:[font = input; preserveAspect; nowordwrap; ]
?Map
:[font = input; preserveAspect; nowordwrap; ]
?ComplexToPoint
:[font = input; preserveAspect; nowordwrap; ]
?Show
:[font = input; preserveAspect; nowordwrap; ]
?Table
:[font = input; preserveAspect; nowordwrap; ]
?QuotientRing
:[font = input; preserveAspect; nowordwrap; ]
?Form
:[font = input; preserveAspect; nowordwrap; ]
?Representatives
:[font = input; preserveAspect; nowordwrap; ]
?Cosets
:[font = input; preserveAspect; nowordwrap; ]
?Addition
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?CayleyTables
:[font = input; preserveAspect; nowordwrap; ]
?Staged
:[font = input; preserveAspect; nowordwrap; ]
?PrimeQ
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?GaussianIntegers
^*)