(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; backColorRed = 49344; backColorGreen = 49344; backColorBlue = 49344; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 65535; plain; fontName = "Times New Roman"; fontSize = 12; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 8. Roots of unity
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
No other lab needs to be completed before attempting this lab. However, experience with cyclic groups (see Group Lab 6) may prove beneficial.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The main goal of this lab is to become familiar with the roots of unity, the roots of polynomials of the form x^n - 1.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.3 An introduction
:[font = text; inactive; preserveAspect; nohscroll; ]
This whole lab will focus on the polynomial x^n - 1 (for a positive integer n) or factors thereof. This is a fairly simple polynomial. For n = 2 and n = 3, you first saw these in first-year algebra.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Quick! Do you remember how to factor x^3 - 1 (over Q)? How is it done?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we will employ Mathematica for higher powers, let's get it started here to check your answer.
:[font = input; preserveAspect; nowordwrap; ]
Clear[x]
Factor[x^3 - 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Was your answer correct? What about other values of n? Let's make a table.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[Factor[x^n - 1], {n, 1, 17}],
	TableSpacing -> {0, 0}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. What observations can you make from this table?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Modify the Table command above to get a listing of values from 18 to some higher value. Do your observations still hold? Do you have any new ones or modifications?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at x^ 63 - 1 and consider some questions regarding it.
:[font = input; preserveAspect; nowordwrap; ]
Factor[x^63 - 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
What things might be of interest? Consider the following list, for starters. 

1. How many factors are there? 
2. What coefficients are used? 
3. What is the highest degree of any factor?
4. What is the list of all the degrees that occur among the factors?

The Factor command easily factors this polynomial, but what is returned is just the product of all the factors with no way of accessing the pieces of the factorization. The function FactorList gives us a list of the factors, so we can access the them:
:[font = input; preserveAspect; nowordwrap; ]
FactorList[x^63 - 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this returns pairs of the form {g(x), m} where f(x) is a factor of the polynomial and m is an integer. This integer represents the multiplicity of the factor. This is just a fancy term for expressing how many times a factor occurs in the factorization. For an example, the following should illustrate the concept of multiplicity.
:[font = input; preserveAspect; nowordwrap; ]
FactorList[Expand[(x-3)^4 (x+1) (x+2)^3 x^8]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at this using MatrixForm.
:[font = input; preserveAspect; nowordwrap; ]
FactorList[Expand[(x-3)^4 (x+1) (x+2)^3 x^8]]//MatrixForm
:[font = text; inactive; preserveAspect; nohscroll; ]
To get at just the factors, we need to transpose the list so that the factors are in the first row rather than the first column. We can then ask for the first row. Here is our result for the polynomial x^63 - 1:
:[font = input; preserveAspect; nowordwrap; ]
factors = First[Transpose[FactorList[x^63 - 1]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we can pursue some of the questions mentioned above. One of the questions was to count the number of factors. For x^63 - 1, of course, we can simply step through and count, but we want to look for a way of doing this in Mathematica. What we really want to know is how many elements there are in the list factors, which can be measured by the Length function.
:[font = input; preserveAspect; nowordwrap; ]
Length[factors]
:[font = text; inactive; preserveAspect; nohscroll; ]
Another question related to the coefficients. The function CoefficientList does exactly what we want.
:[font = input; preserveAspect; nowordwrap; ]
CoefficientList[factors, x]
:[font = text; inactive; preserveAspect; nohscroll; ]
It may of interest to remove any duplicates and not distinguish from which factor the values were obtained. The Flatten function puts these all into one list.
:[font = input; preserveAspect; nowordwrap; ]
Flatten[CoefficientList[factors, x]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now, we will use the Union function which will sort them and remove any duplicates.
:[font = input; preserveAspect; nowordwrap; ]
Union[Flatten[CoefficientList[factors, x]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The next two questions deal with the degree of the factors, namely what is the highest degree of all the factors and what is the degree of each factor. The latter can be easily answered with the Exponent function.
:[font = input; preserveAspect; nowordwrap; ]
Exponent[factors, x]
:[font = text; inactive; preserveAspect; nohscroll; ]
Once we have this list, it is easy to find the maximum by applying the Max function.
:[font = input; preserveAspect; nowordwrap; ]
Exponent[factors, x]//Max
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's put all of these steps into one function:
:[font = input; preserveAspect; nowordwrap; ]
PolyInfo[x^n_Integer?Positive - 1] := PolyInfo[x^n - 1] = 
	Module[{factors,exps},
factors = First[Transpose[FactorList[x^n - 1]]];
exps = Exponent[factors,x];
{n, 
Length[factors],
Union[Flatten[CoefficientList[factors,x]]],
Max[exps],
Union[exps]}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is a test of this function.
:[font = input; preserveAspect; nowordwrap; ]
FactorList[x^12 - 1]
:[font = input; preserveAspect; nowordwrap; ]
PolyInfo[x^12 - 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that the information is in the form {n, # factors, coefficients used, highest degree, all degrees}. Here is a table showing some results.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[PolyInfo[x^n - 1], {n, 2, 37}], TableDepth -> 2,
	TableSpacing -> {0, 2}, TableHeadings -> {None, {"n", 
	"#fac", "coefs", "max deg", "degrees\n"}}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. In question 2, you were asked what observations you could make from what you had seen? Do you have any additions, corrections, or comments? Make some conjectures. 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Change the range of values for n in the Table command to test your conjectures with more data. In particular, make sure you test your conjectures with values of n that exceed 100 (examples to consider might be n = 210 or n = 165). (Hint: if testing n = 210, do not test from n = 2 to n = 210, but use a smaller range, centered at 210.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. What is the relationship between n and the number of factors of x^n - 1?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. What is the relationship between the degrees of the factors and the highest degree among the factors?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. What conclusion(s) can you make about the highest degree of a factor of x^n - 1 and n?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.4 A closer look -- graphically
:[font = text; inactive; preserveAspect; nohscroll; ]
For the moment, we focus on x^6 - 1.
:[font = input; preserveAspect; nowordwrap; ]
factors = First[Transpose[FactorList[x^6 - 1]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
As we have seen, zeros are intimately related to factors. The first two factors have the zeros 1 and -1 associated with them. What about the last two factors? What are the zeros? Let's check out the second quadratic factor (the fourth factor in the list) by using the Solve command.
:[font = input; preserveAspect; nowordwrap; ]
solns = Solve[factors[[4]] == 0]
:[font = text; inactive; preserveAspect; nohscroll; ]
These are complex zeros. What are the real and imaginary parts of these zeros?
:[font = input; preserveAspect; nowordwrap; ]
Map[{Re[#], Im[#]}&, x /. solns]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. These numbers, in pairs, should look familiar. To what are they related or where have you seen them before? Find the zeros for the third factor and find the real and imaginary parts as above. 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Look again at the factorization of x^6 - 1. The first two factors (together) yielded 2 zeros and the last two factors had two zeros each, yielding a total of 6 zeros. Graph (not necessarily with Mathematica) these six zeros in the complex plane, using the vertical axis as the imaginary axis and the horizontal for the real axis. In other words, the complex number a + bi is to be mapped to the point (a, b) in the plane. Can you give a precise description of the resulting graph?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Perhaps it may be worth looking at the zeros of other polynomials. Here we use the Solve command on several others.
:[font = input; preserveAspect; nowordwrap; ]
Solve[x^8 - 1 == 0]
Solve[x^10 - 1 == 0]
Solve[x^16 - 1 == 0]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since the exact answers may not be so informative, let's use NSolve instead, resulting in approximate decimal answers.
:[font = input; preserveAspect; nowordwrap; ]
NSolve[x^8 - 1 == 0]
NSolve[x^10 - 1 == 0]
NSolve[x^16 - 1 == 0]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's plot the zeros of this last equation. First, we need our list of zeros.
:[font = input; preserveAspect; nowordwrap; ]
zeros = x /. NSolve[x^16 - 1 == 0]
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we need to convert each zero to its real and imaginary part and make them Mathematica graphics-type points. Finally, we graph them. Do not concern yourself with the Mathematica details.
:[font = input; preserveAspect; nowordwrap; ]
Show[Graphics[{RGBColor[0, 0, 1], PointSize[0.025],
	Map[Point[{Re[#], Im[#]}]&, zeros]}], Axes -> True,
	AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect; nohscroll; ]
This sure looks beautiful! Note, however, that this graph has not considered the individual factors in the factorization of the polynomial x^16 - 1:
:[font = input; preserveAspect; nowordwrap; ]
FactorList[x^16 - 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
How do the zeros plotted above relate to the individual factors just given? What we would like to do is find the zeros for each factor and then plot these so that we can discriminate them from each other. We need to slightly modify the code used above. We will write a function that can take any positive integer n as input and output a graph of the zeros of the nth roots of unity, colored by factor. (Again, don't concern yourself with the Mathematica details.)
:[font = input; preserveAspect; nowordwrap; ]
RootsOfUnityZeros[n_Integer?Positive] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.2, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors, {p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[Map[Flatten,sizedpts]], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n]]]
(* no output - just a definition *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try this on a few examples. Depending on the memory of your Mathematica Front End, you may want to expand or narrow the range of values in the following loop by adjusting the values of lowk and highk. (Note: you may wish to delete all previous graphics cells before continuing, if you are getting low on memory.)
:[font = input; preserveAspect; nowordwrap; ]
lowk = 4;
highk = 11;
Do[RootsOfUnityZeros[k], {k, lowk, highk}]
:[font = text; inactive; nohscroll; ]
In each graph, dots of the same color come from the same factor.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. What observations can you make from these graphs?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Do you see any groups (or a ring) lurking behind the scenes?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
When we find the roots of the polynomial x^n - 1, we are finding the solutions (zeros) to the equation x^n - 1 = 0 or, more simply, x^n = 1. In other words, we are finding all the nth roots of 1, the unity; hence, the nth roots of unity. Since 1 is always a solution, starting with 1, let's number the roots and work counter-clockwise, labeling the first with 0. (You might ask yourself why we start counting/labeling with 0.) Below we slightly modify our code from above to reflect the numbering/counting scheme.
:[font = input; preserveAspect; nowordwrap; ]
RootsOfUnityZeros[n_Integer?Positive, powers] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.3, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors,{p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[{Map[Flatten,sizedpts],{RGBColor[0,0,1],Table[Text[i, 
	1.2{Cos[i/n 2Pi],Sin[i/n 2Pi]}],{i,0,n - 1}]}}], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's try it out. (Note: you again may wish to delete all previous graphics cells before continuing, if you are getting low on memory.)
:[font = input; preserveAspect; nowordwrap; ]
(* adjust lowk and/or highk depending on memory *)
lowk = 4;
highk = 11;
Do[RootsOfUnityZeros[k, powers], {k, lowk, highk}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. You should be seeing two distinct groups. Can you name them? Do you now know why we started counting at 0?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Instead of simply labeling the points 0 through n-1, let's use these numbers but divide them by n, which is the number of roots (and the degree of the polynomial). Here we slightly modify the code again to reflect this change.
:[font = input; preserveAspect; nowordwrap; ]
RootsOfUnityZeros[n_Integer?Positive, fractions] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.3, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors,{p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[{Map[Flatten,sizedpts],{RGBColor[0,0,1],
	Table[Text[InputForm[i/n], 
	1.2{Cos[i/n 2Pi],Sin[i/n 2Pi]}],{i,0,n - 1}]}}], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try it out one more time. (Note: you again may wish to delete all previous graphics cells before continuing, if you are getting low on memory.)
:[font = input; preserveAspect; nowordwrap; ]
(* adjust lowk and/or highk depending on memory *)
lowk = 4;
highk = 11;
Do[RootsOfUnityZeros[k, fractions], {k, lowk, highk}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Can you find any connections between the fractions used and the colors of the dots to which they correspond? (You may wish to try another range of values.)
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.5 Another look -- algebraically
:[font = text; inactive; preserveAspect; nohscroll; ]
Above we used the function FactorList, but often had to manipulate it to get just the list of factors. Since we wish to do this often, let's write a function to do it for us.
:[font = input; preserveAspect; nowordwrap; ]
FactorsOfUnity[n_Integer?Positive] := 
	First[Transpose[FactorList[x^n - 1]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is how it works.
:[font = input; preserveAspect; nowordwrap; ]
FactorsOfUnity[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try a few others:
:[font = input; preserveAspect; nowordwrap; ]
Map[FactorsOfUnity, {2, 4, 8, 16, 32}]//ColumnForm
(* here n = 2, 4, 8, 16, 32 *)
:[font = input; preserveAspect; nowordwrap; ]
Map[FactorsOfUnity, {3, 6, 18, 36}]//ColumnForm
:[font = input; preserveAspect; nowordwrap; ]
Map[FactorsOfUnity, {5, 20}]//ColumnForm
:[font = input; preserveAspect; nowordwrap; ]
Map[FactorsOfUnity, {14, 28}]//ColumnForm
:[font = input; preserveAspect; nowordwrap; ]
Map[FactorsOfUnity, {3, 6, 12, 24}]//ColumnForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Look at the relationship(s) between the numbers which FactorsOfUnity is acting on and the results of the factorizations given. What conjectures or conclusions can you make? Can you give any explanations for these conclusions?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Note: some of the ideas for this lab came from chapter 17 of Exploring Mathematics with Mathematica by Theodore W. Gray and Jerry Glynn.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
8.6 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Factor
:[font = input; preserveAspect; nowordwrap; ]
?Table
:[font = input; preserveAspect; nowordwrap; ]
?FactorList
:[font = input; preserveAspect; nowordwrap; ]
?Length
:[font = input; preserveAspect; nowordwrap; ]
?CoefficientList
:[font = input; preserveAspect; nowordwrap; ]
?Flatten
:[font = input; preserveAspect; nowordwrap; ]
?Union
:[font = input; preserveAspect; nowordwrap; ]
?Exponent
:[font = input; preserveAspect; nowordwrap; ]
?Solve
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?NSolve
^*)