(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; backColorRed = 49344; backColorGreen = 49344; backColorBlue = 49344; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 65535; plain; fontName = "Times New Roman"; fontSize = 12; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 9. Cyclotomic polynomials
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Before working on this lab, you should have completed Ring Lab 8, on roots of unity.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal for this lab is to formulate recursive and non-recursive definitions of the cyclotomic polynomials and discover some of the properties of these polynomials. 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.3 An introduction
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that in Ring Lab 8 we focused on the polynomial x^n - 1 (for a positive integer n). Here, we will continue to have this (or more accurately, factors of it) be our focus.

First, let's remind ourselves what the factorizations of these polynomials look like.
:[font = input; preserveAspect; nowordwrap; ]
Clear[x]
Table[{n, Factor[x^n - 1]}, {n, 1, 11}]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
We also redefine two functions that we created in the last lab:
:[font = input; preserveAspect; nowordwrap; ]
RootsOfUnityZeros[n_Integer?Positive, fractions,opts___?OptionQ] := 
	Module[{factors = First[Transpose[FactorList[x^n - 1]]],
	zeros,len,pts,sizedpts, width = 1.3, p = Cyclotomic[n,x]}, 
factors = Join[Complement[factors,{p}],{p}];
zeros = x /. Map[NSolve[# == 0]&, factors];
len = Length[zeros];
pts = Map[Map[Point[{Re[#],Im[#]}]&,#]&, zeros,2];
sizedpts = Transpose[{Table[{Hue[i/len],PointSize[0.015 + 
	i*0.008]},{i,len}],pts}];
Show[Graphics[{Map[Flatten,sizedpts],{RGBColor[0,0,1],
	Table[Text[InputForm[i/n], 
	1.2{Cos[i/n 2Pi],Sin[i/n 2Pi]}],{i,0,n - 1}]}}], Axes -> True,
	AspectRatio -> Automatic, PlotRange -> {{-width,width},
	{-width,width}}, PlotLabel -> "n = "<>ToString[n],opts]]
	
UnityFactors[n_Integer?Positive] := 
	First[Transpose[FactorList[x^n - 1]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Also, we remind ourselves of how the zeros of these polynomials are distributed:
:[font = input; preserveAspect; nowordwrap; ]
Do[RootsOfUnityZeros[k, fractions], {k, 2, 11}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Our goal is to consider what is called a cyclotomic polynomial. For each positive integer n, there is a polynomial F_n(x) called the nth cyclotomic polynomial. (Often the polynomial is denoted not with a capital F but a capital Phi.)
:[font = text; inactive; preserveAspect; nohscroll; ]
Since cyclotomic polynomials are quite important, there is a built-in function for them in Mathematica. Here are the fifth and sixth cyclotomic polynomials:
:[font = input; preserveAspect; nowordwrap; ]
{Cyclotomic[5, x], Cyclotomic[6, x]}
(* x simply indicates with what indeterminate to express
the polynomial *)
:[font = text; inactive; preserveAspect; nohscroll; ]
The cyclotomic polynomials are related to the roots of unity. We were reminded above that these numbers are all on the unit circle. (Note that cyclo refers to a circle and tomic indicates a cutting.) The nth roots of unity take the form u(n, k) = cos(2pi k/n) + i sin(2pi k/n) = e^(2 i pi k/n), where k = 0, 1, 2, ..., n-1. 

If you have ever browsed through The Mathematica Book, you may have stumbled across the description of the cyclotomic polynomials. The description is that the nth cyclotomic polynomial in x is the product of all linear factors of the form x - u(n, k) for which k is relatively prime to n (i.e., GCD[n, k] = 1). These are the factors corresponding to the so-called "primitive nth roots of unity" that are labeled red in the graphs above.
:[font = input; preserveAspect; nowordwrap; ]
u[n_, k_] := Cos[2Pi k/n] + I Sin[2Pi k/n]
:[font = text; inactive; preserveAspect; nohscroll; ]
For example, there are two primitive 6th roots of unity, u(6, 1) and u(6, 5).
:[font = input; preserveAspect; nowordwrap; ]
{Expand[(x - u[6, 1]) (x - u[6, 5])], Cyclotomic[6, x]}
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. (a) Determine F_8(x), the 8th cyclotomic polynomial in x, by expanding the proper linear factors.

(b) Without generating F_128(x) itself, determine its degree. 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Our goal at this point is to develop an alternate way of building the cyclotomic polynomials without using the complex numbers. We will be asking you to look at many patterns to see if you can come up with this alternate definition. First, let's compare x^n - 1 and the nth cyclotomic polynomial in tandem. Note that the output consists of n, then the factorization of x^n - 1, followed by Cyclotomic[n, x].
:[font = input; preserveAspect; nowordwrap; ]
Table[{{n, Factor[x^n - 1], Cyclotomic[n, x],
	"--------------------------"}}, {n, 1, 11}]//TableForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. At least one observation regarding the relationship between F_n(x) and the factorization of x^n - 1 should be obvious. What is it?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Suppose that n is a prime number. How can you formulate F_n(x) in terms of x^n - 1?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
In the last question, you should have found a method of formulating F_n(x) in terms of x^n - 1, when n is prime. What if n is composite? Note: we simply define F_1(x) to be x - 1, just as we define 0! to be 1.) Let's extend our table and make some more comparisons.
:[font = input; preserveAspect; nowordwrap; ]
Table[{{n, Factor[x^n - 1], Cyclotomic[n, x],
	"--------------------------"}}, {n, 12, 30}]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
It appears as if Cyclotomic[n, x] is a factor of x^n - 1. Recall from the last lab that UnityFactors gave just the list of factors of the polynomial x^n - 1. Let's test some random indices and see if Cyclotomic[n, x] really is a factor of x^n - 1. (We use MemberQ to see if Cyclotomic[n, x] belongs to the list of factors of x^n - 1.)
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {31, 120}]
MemberQ[UnityFactors[n], Cyclotomic[n, x]]
:[font = text; inactive; preserveAspect; nohscroll; ]
We should perhaps try this a number of times.
:[font = input; preserveAspect; nowordwrap; ]
Table[{n = Random[Integer,{31, 120}],
	MemberQ[UnityFactors[n], Cyclotomic[n, x]]}, {20}]
:[font = text; inactive; preserveAspect; nohscroll; ]
One more time with other values of n.
:[font = input; preserveAspect; nowordwrap; ]
Table[{n = Random[Integer, {121, 180}],
	MemberQ[UnityFactors[n], Cyclotomic[n, x]]}, {15}]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is not a proof, but the evidence seems quite indicative that F_n(x) divides x^n - 1. Let's assume that this is the case and that there exists some function (depending on n), g_n(x), such that F_n(x) g_n(x) = x^n - 1. We already know that g_n(x) = x - 1 when n is prime. What about when n is composite?
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Although premature for any definitive solution, do you have any thoughts on the nature of g_n(x) for composite n?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.4 The search for g_n(x)
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we are assuming that we have F_n(x) g_n(x) = x^n - 1, perhaps we should solve for g_n(x) and explore the quotient of the two pieces we can calculate. (Note, of course, that Mathematica knows F_n(x), but we do not, yet.) Let's consider this with n = 6.
:[font = input; preserveAspect; nowordwrap; ]
Simplify[(x^6 - 1)/Cyclotomic[6, x]]
:[font = text; inactive; preserveAspect; nohscroll; ]
We want to factor this, so we can know what the pieces look like.
:[font = input; preserveAspect; nowordwrap; ]
Factor[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
We should define a function to do all of these steps at once and then try it out.
:[font = input; preserveAspect; nowordwrap; ]
gFunction[n_] := 
	Factor[Simplify[(x^n - 1)/Cyclotomic[n, x]]]
:[font = input; preserveAspect; nowordwrap; ]
Table[{n, gFunction[n]}, {n, 1, 14}]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
This may not be so revealing. Perhaps we should also add the nth cyclotomic polynomial to the table. Study the following results and look for patterns.
:[font = input; preserveAspect; nowordwrap; ]
Table[{{n, gFunction[n], Cyclotomic[n, x],
	"--------------------------"}}, {n, 1, 14}]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
Extend the table, if you wish, by looking at six more cases (in conjunction with the previous ones).
:[font = input; preserveAspect; nowordwrap; ]
Table[{{n, gFunction[n], Cyclotomic[n, x],
	"--------------------------"}}, {n, 15, 20}]//TableForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. What is the nature of g_n(x) for composite n? For a hint, given an index n, consider the (proper) divisors d of n and the corresponding collection of F_d(x). Can these be used to construct gn(x)? Look carefully at the first 15 examples and apply the hint and see what you can come up with.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Now we want to give a recursive definition for F_n(x). In other words, you should be able to write F_n(x) = RHS, where the RHS depends on F_k(x) for one or more values of k that are less than n.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5 Some properties of F_n(x)
:[font = text; inactive; preserveAspect; nohscroll; ]
We now consider some properties of the cyclotomic polynomials. First, we remind ourselves of some of these polynomials and precede each with its degree.
:[font = input; preserveAspect; nowordwrap; ]
Table[{{n, Exponent[p = Cyclotomic[n, x], x], p,
	"----------------------"}}, {n, 2, 15}]//TableForm
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.1 Each cyclotomic polynomial is monic
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Based on what you know about the function F_n(x), why is the nth cyclotomic polynomial monic? (Recall that monic means that the leading coefficient, the one associated with the term of highest degree, has the value of 1.)
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.2 The degrees of the cyclotomic polynomials
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Compare the index n of the function F_n(x) with its degree. You should be able to see an interesting relationship and be able to express the degree of F_n(x) as a "nice" function of n. What is it?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.3 The irreducibility of the cyclotomic polynomial
:[font = text; inactive; preserveAspect; nohscroll; ]
In a previous lab, we explored the notion of irreducibility. Which, if any, of the cyclotomic polynomials are irreducible over the rationals? Try the following to factor a random cyclotomic polynomial.
:[font = input; preserveAspect; nowordwrap; ]
Table[{n = Random[Integer, {2, 50}],
	Factor[Cyclotomic[n, x]]}, {10}]//TableForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Repeat and/or modify the range of the random index until you are ready to make a conjecture regarding when (i.e., for what n) F_n(x) is irreducible over the rationals.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's choose a prime, say 29, and consider F_n(x) for n = 29. We will call the polynomial h for this example.
:[font = input; preserveAspect; nowordwrap; ]
Clear[h]
h[x_] = Cyclotomic[29, x]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider h(x + 1).
:[font = input; preserveAspect; nowordwrap; ]
h[x + 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Of course we knew that we wanted this polynomial expanded, but we need to tell Mathematica explicitly to do so.
:[font = input; preserveAspect; nowordwrap; ]
Expand[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now examine the coefficients more closely.
:[font = input; preserveAspect; nowordwrap; ]
coeffs = CoefficientList[%, x]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since h(x) is monic, so is h(x + 1). Therefore the leading coefficient is 1. Is there any significance to the rest of the coefficients. Suppose we ignore the last (ie., leading) coefficient and ask for the greatest common divisor of the balance.
:[font = input; preserveAspect; nowordwrap; ]
Apply[GCD, Drop[coeffs, -1]]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This says that 29 divides each of the coefficients, except the leading one. Note further that 29^2 does not divide the constant term, 29. We can now use Eisenstein's Criterion to conclude that the polynomial h(x + 1) is irreducible over the rationals. Consequently, the polynomial h(x) is also irreducible over the rationals. This illustrates that a cyclotomic polynomial with prime index is irreducible. It is also true for composite indices, but the proof requires some understanding of extension fields. (See Ring Lab 11 for an introduction to quadratic extension fields.)
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.4 Graphs of roots of the cyclotomic polynomial
:[font = text; inactive; preserveAspect; nohscroll; ]
As we saw in the previous section, the cyclotomic polynomial is irreducible over the rationals. It is, of course, reducible over the complex numbers. In fact, we saw this in the last lab. As was pointed out earlier, the zeros of the nth cyclotomic polynomial are a subset of the whole set of nth roots of unity.

Let's remind ourselves what these roots look like. The roots of the cyclotomic polynomial are the red ones plotted in the complex plane. (You may wish to delete previous graphics cells to release memory.)
:[font = input; preserveAspect; nowordwrap; ]
Do[RootsOfUnityZeros[k, fractions], {k, 5, 20, 3}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. The zeros of the cyclotomic polynomials (the red dots) are labeled with fractions of the form k/n for certain values of k. What are the k values? How do they relate to n? You may wish to modify the cell above to see more examples.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. In each of the graphs above, the full collection of zeros forms a group under multiplication. To what group is this naturally isomorphic? What is the relationship between the zeros of the cyclotomic polynomials and this group?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
As a noted earlier, the roots of the nth cyclotomic polynomial are often called the primitive nth roots of unity. Can you imagine why?
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.5 F_n(x) and F_2n(x) for odd n
:[font = text; inactive; preserveAspect; nohscroll; ]
Here we wish to look for a relationship, if any, between F_n(x) and F_2n(x). First we look at a table listing some pairs.
:[font = input; preserveAspect; nowordwrap; ]
Table[{{k, Cyclotomic[k, x], 2k, Cyclotomic[2k, x],
	"-----------------------------", " "}}, 
	{k, 3, 13, 2}]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
You may wish to expand this table to encompass other values. A plot of an example might also be revealing. You may wish to modify your value of n to see other plots. F_n is plotted in red and F_2n in blue.
:[font = input; preserveAspect; nowordwrap; ]
n = 9;
Plot[Evaluate[{Cyclotomic[n, x], Cyclotomic[2n, x]}], {x, -2, 2},
	PlotStyle -> {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}];
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this plot reveals that there are no real zeros (at least in the domain shown). We can still, however, compare the complex zeros. You may need to enlarge the output below to view it. 
:[font = input; preserveAspect; nowordwrap; ]
n = 11;
gr1 = RootsOfUnityZeros[11, fractions, DisplayFunction -> Identity];
gr2 = RootsOfUnityZeros[22, fractions, DisplayFunction -> Identity];
Show[GraphicsArray[{gr1, gr2}]];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. What conclusion(s), if any, can you make about how F_n(x) and F_2n(x) are related?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.6 F_p(x) and F_(p^k)(x) for prime p
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose p is a prime and k is an integer with k not equal to 1. We wish to compare F_p(x) and F_(p^k)(x) for various primes p. Below we make a table consisting of a 5-tuple {p, k, p^k, F_p(x), F_(p^k)(x)} where p runs through the first 6 primes and k is a random integer between 2 and 4. Study the results.
:[font = input; preserveAspect; nowordwrap; ]
Table[k = Random[Integer, {2, 4}];
	{{p = Prime[n], k, p^k, Cyclotomic[p, x], Cyclotomic[p^k, x], 
	"----------------------"}}, {n, 1, 6}]//TableForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Since k is generated randomly, you may wish to evaluate the above cell again if it is not clear what relationship is being expressed. Determine how you can express F_(p^k)(x) in terms of the pth cyclotomic polynomial, if possible.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.7 F_n(x) and F_m(x) where m and n have similar prime decompositions
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose m is an integer whose prime-power decomposition is given as p_1 p_2 ... p_k and n is an integer whose prime-power decomposition is given as (p_1)^(e_1) (p_2)^(e_2) ... (p_k)^(e_k) where e_1, e_2, ..., e_k are the positive integral exponents belonging to primes p_1 through p_k. We wish to compare F_m(x) and F_n(x).

For investigative purposes, suppose m = (2)(3)(5) and n = 2^a3^b5^c for some powers a, b, and c. Below we make a table consisting of a 4-tuple {{a, b, c}, n, F_m(x), F_n(x)} where a, b, c are random integers between 2 and 4. Study the results.
:[font = input; preserveAspect; nowordwrap; ]
m = 2 3 5;
Table[{a, b, c} = Table[Random[Integer, {2, 4}], {3}]; 
n = 2^a 3^b 5^c; {{{"a = "<>ToString[a], "b = " <> ToString[b],
"c = " <> ToString[c]}, "2^" <> ToString[a] <> " 3^" <>
ToString[b] <> " 5^" <> ToString[c] <> " = " <> ToString[n],
 Cyclotomic[m, x], Cyclotomic[n, x],
"--------------------"}}, {6}]//TableForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Since a, b, and c are generated randomly, you may wish to evaluate the above cell again if it is not clear what relationship is being expressed. What relationship is there between F_n(x) and F_m(x) for the n as obtained above and m = 30. Generalize for arbitrary m and n satisfying the hypothesis given at the beginning of this section.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.8 F_n(1)
:[font = text; inactive; preserveAspect; nohscroll; ]
We have seen many cyclotomic polynomials F_n(x) and even seen a few plotted, but we haven't investigated viewing them as polynomial functions and evaluating them at specific points. Here we consider F_n(1) for various values of n. Consider the table of values of F_n(1) for n generated randomly between 1 and 150. Study the results.
:[font = input; preserveAspect; nowordwrap; ]
Table[n = Random[Integer, {1, 150}];
	{n, Cyclotomic[n, x]/. x -> 1}, {20}]//TableForm[#, 
	TableHeadings -> {None,
	{"n", "Fn(1)\n"}}, TableSpacing -> {0, 3}]&
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. What conclusions can you make? State this as a conjecture.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Evaluate the cell below.
:[font = input; preserveAspect; nowordwrap; ]
Table[{n, Cyclotomic[n, x]/. x -> 1},
{n, 1, 25}]//TableForm[#, TableHeadings -> {None,
	{"n", "Fn(1)\n"}}, TableSpacing -> {0, 3}]&
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. Does this confirm or deny your previous conjecture? Reformulate, if necessary.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.9 How F_n(x) is related to the Moebius function, yielding a non-recursive definition
:[font = text; inactive; preserveAspect; nohscroll; ]
The Moebius function (often denoted with the lower-case Greek letter mu) is a number-theoretic function defined as follows: 
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
mu(n) = 1, if n = 1;
mu(n) = (-1)k, if n is a product of k distinct primes;
mu(n) = 0, if p^2 divides n for some prime p.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. For n = 1, 2, 3, 4, 6, and 12, calculate mu(n). (Note that these are all divisors of 12.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since the Moebius function is quite important for various parts of mathematics, it is a built-in function in Mathematica. The following table can be used to confirm your answers to the previous question.
:[font = input; preserveAspect; nowordwrap; ]
Map[MoebiusMu, {1, 2, 3, 4, 6, 12}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Applying the MoebiusMu function to the divisors of an integer will prove itself useful below. In Mathematica, we can obtain the list of divisors of an integer using the Divisors function.
:[font = input; preserveAspect; nowordwrap; ]
Divisors[12]
:[font = text; inactive; preserveAspect; nohscroll; ]
With n = 12, what we now want to do is raise the polynomial x^(12/d) -1 to the power mu(d) for each divisor d. Below is one way of doing this.
:[font = input; preserveAspect; nowordwrap; ]
n = 12;
polys = Map[(x^(n/#) - 1)^MoebiusMu[#]&, Divisors[n]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we want to multiply these together.
:[font = input; preserveAspect; nowordwrap; ]
Apply[Times, polys]
:[font = input; preserveAspect; nowordwrap; ]
Simplify[%]
:[font = input; preserveAspect; nowordwrap; ]
Cyclotomic[n, x]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. In the previous few input cells, replace the 12 with 20 and evaluate each of the cells. What is your result? Any conjectures? Try it again with another value or two.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q19. In a previous section we found a recursive definition for F_n(x). Now give a non-recursive definition.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5.10 Disclaimer/warning
:[font = text; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
You are not finished! Nearly all the conclusions that you have reached in this lab were based on looking at patterns and formulating conjectures. Your next step should be to prove at least some of your conjectures. Your instructors may, no doubt, assign at least some of these proofs to you.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.6 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Table
:[font = input; preserveAspect; nowordwrap; ]
?Cyclotomic
:[font = input; preserveAspect; nowordwrap; ]
?Factor
:[font = input; preserveAspect; nowordwrap; ]
?Random
:[font = input; preserveAspect; nowordwrap; ]
?MemberQ
:[font = input; preserveAspect; nowordwrap; ]
?Simplify
:[font = input; preserveAspect; nowordwrap; ]
?Exponent
:[font = input; preserveAspect; nowordwrap; ]
?Expand
:[font = input; preserveAspect; nowordwrap; ]
?Apply
:[font = input; preserveAspect; nowordwrap; ]
?GCD
:[font = input; preserveAspect; nowordwrap; ]
?Drop
:[font = input; preserveAspect; nowordwrap; ]
?MoebiusMu
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Divisors
^*)