(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; backColorRed = 49344; backColorGreen = 49344; backColorBlue = 49344; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 65535; plain; fontName = "Times New Roman"; fontSize = 12; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 10. Quotient rings of polynomials
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should be familiar with the ring of polynomials over a field, the division property for polynomials over a field, and the definitions of homomorphism, kernel, and ideal. Finally, you should be familiar with the First Isomorphism Theorem for ring homomorphisms (Ring Lab 5). 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Extensions of finite fields are generally motivated by the need to solve polynomial equations. These extensions are actually quite concrete in the sense that they arise from quotient rings, where the ideal from which cosets are formed is the kernel of a familiar homomorphism. In this case, the homomorphism is the remainder function for division by a fixed polynomial (the modulus). In this lab we will introduce quotient rings, and in Ring Lab 11 we will explore how they are used to construct roots of polynomials.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.3 Polynomials over a field
:[font = text; inactive; preserveAspect; nohscroll; ]
First, we read in the necessary Mathematica code that we will need for this lab.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Given any field, F, we will ultimately want to be able to solve any polynomial equation over it. For example, F might be the integers modulo 3.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
F = Z[3]
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
It is clear, by simple hand-evaluation of m(x) = x^2 + x + 2, that none of the elements of F are roots of m(x). This can also be done using just the built-in Mathematica functions. First, define the function:
:[font = input; preserveAspect; nowordwrap; ]
Clear[m1, x]
m1[x_] := x^2 + x + 2
(* we call it m1 here because we will use m below *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Then evaluate the function at each element in F:
:[font = input; preserveAspect; nowordwrap; ]
{m1[0], m1[1], m1[2]}
:[font = text; inactive; preserveAspect; nohscroll; ]
For larger fields, it may be easier to do this another way:
:[font = input; preserveAspect; nowordwrap; ]
Map[m1, Elements[F]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Reducing mod 3 (recall what ring we are in), we get:
:[font = input; preserveAspect; nowordwrap; ]
Mod[%, 3]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Why does this show that m(x) does not have any roots in F?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer 
:[font = text; inactive; preserveAspect; nohscroll; ]
One can also use the functions built into the packages that were read in. First, define the polynomial over F using the Poly function.
:[font = input; preserveAspect; nowordwrap; ]
m = Poly[F, x^2 + x + 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Then use the PolynomialEvaluation function on the domain elements.
:[font = input; preserveAspect; nowordwrap; ]
Map[PolynomialEvaluation[m, #]&, Elements[F]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Does the polynomial m(x) - 1 (which is really m(x) + 2) have any roots in F?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer 
:[font = text; inactive; preserveAspect; nohscroll; ]
We conclude that the field F does not contain the roots of m(x). In this lab we will concentrate on the construction of a field that will contain the roots of m(x). In the next lab we will discuss the factorization of m(x) in this new field, along with other issues involving finite field extensions. 

We will use V to denote the smallest extension of F that contains all the roots of m(x). The first step in constructing V is to consider the whole ring of polynomials over F.
:[font = input; preserveAspect; nowordwrap; ]
P = PolynomialsOver[F]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. In the packages that these labs are based upon, a Ringoid has three arguments: the list of elements, the addition function, and the multiplication function. Why isn't P a Ringoid in this sense? Is P a ring?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.4 A Homomorphism based on PolynomialRemainder
:[font = text; inactive; preserveAspect; nohscroll; ]
The homomorphism, theta, that we consider below depends on m(x). If the definition of m(x) is altered, a different homomorphism and, at least superficially, a different extension will be constructed. Generally, the smallest degree that we consider for the polynomial function m(x) is two, as we have in this example.
:[font = text; inactive; preserveAspect; nohscroll; ]
The function theta takes any polynomial in P and returns the polynomial that is the remainder upon division by m(x) (our polynomial x^2 + x + 2). 
:[font = input; preserveAspect; nowordwrap; ]
theta = PolynomialRemainder[P, #, m]&
:[font = text; inactive; preserveAspect; nohscroll; ]
You may wish to remind yourself how the function PolynomialRemainder works:
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialRemainder
:[font = text; inactive; preserveAspect; nohscroll; ]
For a quick test of theta, let's apply it to m and also to m + 1 = x^2 + x . (Think about the answer before evaluating.)
:[font = input; preserveAspect; nowordwrap; ]
theta[m]
theta[Poly[F, x^2 + x]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. (a) What happens when we apply theta to m * x + 2 = x^3 + x^2 + 2x + 2? Think about it and then calculate it.

(b) What happens when we apply theta to m * (x + 2) + x? Think about it and then calculate it.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
The division property of polynomials over a field assures us that the remainder (the value of our function theta) will have its degree less than the divisor's degree. So in our examples, the remainders are all linear polynomials. To illustrate this with a computation, we take some of the elements of P, the ones of degree three or less, and map the PolynomialRemainder function theta over them. Note: if your computer is relatively slow, you may want to change the expression below to SomePolynomials = PolynomialsUpToDegreeN[F, 2], generating only polynomials of degree two or less.
:[font = input; preserveAspect; nowordwrap; ]
SomePolynomials = PolynomialsUpToDegreeN[F, 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we map theta over this list. Duplicate images are removed and we can verify by examination that all nine linear polynomials over Z[3] are in this list.
:[font = input; preserveAspect; nowordwrap; ]
thetaRange = Map[theta, SomePolynomials]//Union
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Why are there 9 possible remainders? If m(x) were a cubic polynomial (instead of a quadratic), how many different elements would be in the range of theta? (In other words, how many different remainders would there be if m(x) were a cubic?)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's review what we have done. Since the set of all polynomials over F (which we call P) is infinite in size, we can not apply our function theta to the whole of P. So we took a finite subset of P (SomePolynomials -- those of degree less than four) and applied theta to this subset, to get a sense of how theta worked. The result over this set is the set we called thetaRange. We now rename this set linPolys, which is the set of linear polynomials over F.
:[font = input; preserveAspect; nowordwrap; ]
linPolys = thetaRange
:[font = text; inactive; preserveAspect; nohscroll; ]
By considering theta as a function from P into the linear polynomials (linPolys), we want to establish theta as a homomorphism. For theta to be a homomorphism, more fundamental than showing the operations are preserved, we need to make sure that both the domain and codomain are rings. The domain is clearly a ring -- it is the ring of polynomials over Z[3]. It is not so clear that the set of remainders, linPolys, is also a ring. How should addition and multiplication be defined? 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Consider the set of remainders from division by m(x), linPolys. Why can't the usual polynomial multiplication be used on linPolys to form a ring?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer 
:[font = text; inactive; preserveAspect; nohscroll; ]
The First Homomorphism Theorem gives us a clue how to operate in linPolys. This is because the range is isomorphic to P/K, where K is the kernel of theta. Recall that given an isomorphism f: R -> S, the inverse map (which exists, since f is a bijection), f^(-1): S -> R, is also an isomorphism. We want to consider this inverse isomorphism, the function that maps an element g in linPolys to the coset g + K in P/K. 

Here are the elements of K that come from the list SomePolynomials. Note that these are obtained by selecting those whose image under theta is the zero of P.
:[font = input; preserveAspect; nowordwrap; ]
partialK = Select[SomePolynomials, (theta[#] == Zero[P])&]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. What do these polynomials all have in common? For a hint, take one of these polynomials over F (remember, they were all formed with Poly) and try the PolynomialDivision function on it with of m(x). (See below.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer 
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialDivision
:[font = input; preserveAspect; nowordwrap; ]
p = partialK[[1]] (* take the first element, for starters *)
PolynomialDivision[p, m]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's take a pair of elements from P and form two cosets from them. We select polynomials that are also in linPolys so that the sum and product of their cosets will give us a hint at how addition and multiplication are defined in linPolys.
:[font = input; preserveAspect; nowordwrap; ]
p = Poly[F, x + 1]
q = Poly[F, 2x + 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since K is infinite (you should ask yourself why this is true), we can not form the full coset p + K, but we can form a portion of p + K by using partialK.
:[font = input; preserveAspect; nowordwrap; ]
pCoset = Map[Addition[P][p, #]&, partialK]
:[font = text; inactive; preserveAspect; nohscroll; ]
We do the same for q + K.
:[font = input; preserveAspect; nowordwrap; ]
qCoset = Map[Addition[P][q, #]&, partialK]
:[font = text; inactive; preserveAspect; nohscroll; ]
We add the two cosets by adding arbitrary representatives of pcoset and qcoset. There are many possibilities here, but the easiest pair to add is p and q.
:[font = input; preserveAspect; nowordwrap; ]
sum = Addition[P][p, q]
theta[sum]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we pick random representatives and go through the same process.
:[font = input; preserveAspect; nowordwrap; ]
Print["Rep. from pCoset: ",pRep = RandomElement[pCoset]]
Print["Rep. from qCoset: ",qRep = RandomElement[qCoset]]
Print["Sum in P: ",sum = Addition[P][pRep, qRep]]
Print["Image of this sum under theta: ",theta[sum]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Consider three more pairs of representatives from pCoset and from qCoset by evaluating the above cell three more times. What do you observe?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. By changing Addition to Multiplication (see below), multiply several random pairs of representatives as in the previous exercise. What do you observe? Do the same using p and q as representatives.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = input; preserveAspect; nowordwrap; ]
Print["Rep. from pCoset: ",pRep = RandomElement[pCoset]]
Print["Rep. from qCoset: ",qRep = RandomElement[qCoset]]
Print["Product in P: ",prod = Multiplication[P][pRep, qRep]]
Print["Image of this product under theta: ",theta[prod]]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
It can be proven that the observations that you (hopefully) made above are not coincidence. It is reasonable to consider the sum of p and q is 2 and their product is an "obvious value." The general definitions of the operations on linPolys are based on these observations.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.5 Defining a Quotient Ring of Polynomials
:[font = text; inactive; preserveAspect; nohscroll; ]
For any polynomial m = Poly[R, a_n x^n + a_(n-1) x^(n-1) + ... + a_2 x^2 + a_1 x + a_0], with each a_i in some Ringoid R with unity, the expression QuotientRing[R, m] generates a quotient ring of R with modulus m. The elements of the ring are the polynomials of degree less than the degree of m. With m and F defined above, we define V to be the quotient ring of F mod m:
:[font = input; preserveAspect; nowordwrap; ]
V = QuotientRing[F, m]
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.5.1 Addition
:[font = text; inactive; preserveAspect; nohscroll; ]
Addition in V is simply addition of polynomials. 
:[font = input; preserveAspect; nowordwrap; ]
{p, q} = {Poly[F, 2x+1], Poly[F, 2x]}
:[font = input; preserveAspect; nowordwrap; ]
Addition[V][p, q]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try this addition with a few random pairs.
:[font = input; preserveAspect; nowordwrap; ]
{p, q} = RandomElements[V, 2]
Addition[V][p, q]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Why is V closed under the usual addition of polynomials?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.5.2 Multiplication
:[font = text; inactive; preserveAspect; nohscroll; ]
Multiplication in V is much like multiplication on the integers mod n. To multiply polynomials p and q, you perform the usual multiplication (as in P) and then divide by the modulus, retaining the remainder for the value of the product. In other words, you apply theta to the product. For example,
:[font = input; preserveAspect; nowordwrap; ]
p = Poly[F, x + 1]
q = Poly[F, x+ 2]
r = Multiplication[P][p, q]
:[font = input; preserveAspect; nowordwrap; ]
theta[r]
:[font = text; inactive; preserveAspect; nohscroll; ]
This last result, of course, can also be done as follows:
:[font = input; preserveAspect; nowordwrap; ]
Multiplication[V][p, q]
:[font = text; inactive; preserveAspect; nohscroll; ]
Remember, theta[r] is computed by dividing the product, r, by m and then returning the remainder. The complete division result, quotient and remainder, is given by PolynomialDivision. (However, only the remainder is used for the product in V.)
:[font = input; preserveAspect; nowordwrap; ]
PolynomialDivision[P, r, m, Mode -> Textual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Compute the following in V:
(a) (2x + 1) + (x + 2)
(b) x x= x2 
(c) x x x x = x4 
(d) x x x x x x x x = x8
(e) The multiplicative inverse of 2x + 1.
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.6 The PolynomialRemainder function theta is indeed a homomorphism
:[font = text; inactive; preserveAspect; nohscroll; ]
Now that we have established the operations on V, we can verify that theta is indeed a homomorphism. Here we will only verify that the homomorphism properties are true for a pair of random degree 3 elements in P.
:[font = input; preserveAspect; nowordwrap; ]
{p, q} = Table[RandomElement[P,3], {2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
First the addition property:
:[font = input; preserveAspect; nowordwrap; ]
theta[ Addition[P][p, q] ] == Addition[V][theta[p], theta[q]]
:[font = text; inactive; preserveAspect; nohscroll; ]
and then the multiplication property:
:[font = input; preserveAspect; nowordwrap; ]
theta[ Multiplication[P][p, q] ] == Multiplication[V][theta[p], theta[q]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Repeat the above steps several times. Are you convinced that theta is a homomorphism? Why?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Suppose that the definition of multiplication on V was defined to be Multiplication[V][p, q] = 0 for all p and q (with no change to the addition). Would theta still be a homomorphism? 
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.7 Is V a field?
:[font = text; inactive; preserveAspect; nohscroll; ]
You probably have seen a theorem that states that the range or image of a (commutative) ring under a homomorphism is a (commutative) ring. Therefore, V is a commutative ring. To show that it is also a field, we need to verify that it has a unity and that every nonzero element has an inverse. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Does V have a unity? If so, what is it and why is it the unity? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. While we are at it, does V have a zero? If so, what is it and why is it the zero? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
Therefore, we know that V has most of the field properties. The multiplication table for V can answer the question regarding multiplicative inverses.
:[font = input; preserveAspect; nowordwrap; ]
MultiplicationTable[V, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. Is V a field? On what do you base your conclusion?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.8 Is V what we claimed?
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that at the outset we claimed we would find a field (and call it V) that would be the smallest field containing all the roots of m(x) = x^2 + x + 2. We have defined V above, but we have not yet shown that it contains any roots of m.

It is also true that we were able to do addition and multiplication in V. So then we should be able to take any element in V, square it, add this to itself, and then add the constant polynomial 2 to this result. In other words, one should be able to do arithmetic in this field.

Next, we define a function f that does what we indicated in the previous paragraph:
:[font = input; preserveAspect; nowordwrap; ]
Clear[f, y]
f[y_] := Multiplication[V][y, y] + y + Poly[F, 2, 
	Indeterminate -> x]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. What connection is there between the polynomial function m = x^2 + x + 2 defined at the outset and f defined above? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we want to evaluate f at each of the elements in V. In other words, we want to Map f over V. We form pairs of the form {x, f[x]} so we can see the domain elements that create the range elements.
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, f[#]}&, Elements[V]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that two elements, Poly[F, x] and Poly[F, 2x + 2] yield zero.
:[font = input; preserveAspect; nowordwrap; ]
root1 = Poly[F, x]
root2 = Poly[F, 2x + 2]
:[font = input; preserveAspect; nowordwrap; ]
f[root1]
f[root2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. Does the V we created have all the roots of m? Could m have more than two roots over V? (Remember that V is an integral domain, since it is a field.) Is it possible that a smaller field contains these roots? Justify your answers.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
10.9 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?Mod
:[font = input; preserveAspect; nowordwrap; ]
?Poly
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialEvaluation
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialsOver
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialRemainder
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialsUpToDegreeN
:[font = input; preserveAspect; nowordwrap; ]
?Map
:[font = input; preserveAspect; nowordwrap; ]
?Select
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialDivision
:[font = input; preserveAspect; nowordwrap; ]
?Addition
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?RandomElement
:[font = input; preserveAspect; nowordwrap; ]
?RandomElements
:[font = input; preserveAspect; nowordwrap; ]
?QuotientRing
:[font = input; preserveAspect; nowordwrap; ]
?MultiplicationTable
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Indeterminate
^*)