(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    137650,       3958]*)
(*NotebookOutlinePosition[    197177,       5457]*)
(*  CellTagsIndexPosition[    195609,       5401]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "7. Information about ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[CellGroupData[{

Cell["7.1 Overview of EAAM", "Section",
  CellTags->{"i:6", "overview"}],

Cell[TextData[{
  "While the collection of packages in ",
  StyleBox["AbstractAlgebra", "MR"],
  " can be used on their own, their creation was motivated by the development \
of a series of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " labs that can be used in group, ring and field theory. These labs are now \
available in book entitled ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  " (EAAM) published by Springer Verlag, authored by Al Hibbard and Ken \
Levasseur.\nThe EAAM book is intended for anyone trying to learn (or teach) \
abstract algebra (a difficult course for some students). Perhaps one of the \
reasons this course is often challenging is because of its formal and \
abstract nature. While some people are quite adept at thinking abstractly, \
many are helped by also thinking visually or geometrically. To this end, \
where possible, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " labs are designed to appeal to visualization of various algebraic ideas \
(as pioneered by Ladnor Geissinger in his software package Exploring Small \
Groups). Additionally, the nature of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks encourages an exploratory environment in which one can make and \
test conjectures. Viewing the notebooks as interactive texts allows an \
environment that can not be replicated by lecture alone. While many of the \
labs are designed to prepare the way for in-class discussion/lecture, they  \
can also be used to extend  examples seen in class."
}], "Text",
  CellTags->"overview"],

Cell[TextData[{
  "There is no assumption about being able to program in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; users only need  to  know  the basic concepts of using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", which are reviewed in Lab 0. Every lab starts with a set of goals as \
well as prerequisites, listing both mathematical assumptions as well as any \
assumptions about having used previous labs. Most labs are independent, \
though a few assume some experience with a previous lab. Although the labs \
are presented with the ring labs following the group labs, they can be just \
as easily used by those who prefer to do rings first (as one of us does). \
Questions are interspersed through the lab at the points where it is natural \
to ask. As with any text, one does not need to complete every question \
(although a few have dependency on previous questions). While the length of \
the labs vary from 40 minutes to 90 minutes in length, they typically require \
about 60 minutes. (Of course, this is a function of how many of the questions \
are assigned.) For adopters of the book, there are provisions for suggested \
minimal questions to be included, as well as which ones could be considered \
optional. Additionally, notebooks containing just the questions are \
available, as are partial solutions upon request by an instructor. Finally, a \
number of palettes for 3.x users are available to facilitate the use of the \
labs and the implementation of the packages."
}], "Text",
  CellTags->"overview"],

Cell["\<\
The book comes with a CD containing all the labs, the packages, \
additional palettes and other related materials. It will be ready for use for \
the spring semester of 1999. Note: the labs make no assumptions about what \
main text is being used; they should be suitable to accompany any text. See \
below how a number of standard texts can be used with EAAM.\
\>", "Text",
  CellTags->"overview"],

Cell[TextData[{
  "For more details concerning the text, go to our EAAM homepage ",
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"overview"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.2 Summaries of group labs", "Section",
  CellTags->"grplb"],

Cell[TextData[{
  "Group Lab 1. ",
  StyleBox["Using symmetry to uncover a group",
    FontSlant->"Italic"],
  " -- ",
  StyleBox[
  "This lab explores the underlying definitions of a group by looking at the \
symmetries of an equilateral triangle.",
    Evaluatable->False],
  "\nGroup Lab 2. ",
  StyleBox["Determining the symmetry group of a given figure",
    FontSlant->"Italic"],
  " -- ",
  StyleBox[
  "The focus of this lab is to determine the symmetry group of a figure \
chosen randomly from a list of regular polygons and \"cyclic\" objects.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 3. ",
  StyleBox["Is this a group?",
    FontSlant->"Italic"],
  " -- ",
  StyleBox[
  "This lab randomly presents a Cayley table of one of 20 \"possible \
groups.\" The goal is to determine which of the defining properties of a \
group are reflected in the Cayley table to see if it represents a group.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 4. ",
  StyleBox["Let's get these orders straight!",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- This lab looks at the order of an element and its inverse, the \
distribution of the orders of the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[", investigates the probability that an element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" has order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" and also explores the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[" (the units in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 5. ",
  StyleBox["Subversively grouping our elements",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- This lab explores the notion of a subgroup, including looking at the \
subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[", calculating the probability that a random subset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[
  " is a subgroup and determining what elements in a subset are necessary so \
that the closure yields the whole group.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 6. ",
  StyleBox["Cycling through the groups",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- Here we focus on the notion of a cyclic group and its subgroup \
structure. We also look at the determining when the direct sum of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" yields a cyclic group.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 7. ",
  StyleBox["Permutations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- This lab looks at the definition of a permutation, how to perform \
computations and explore properties. We also look at some applications of \
permutations.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 8. ",
  StyleBox["Isomorphisms",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- Here we look at the definition of an isomorphism and then use various \
visual mechanisms to try to determine when two groups are or are not \
isomorphic.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 9. ",
  StyleBox["Automorphisms",
    FontSlant->"Italic"],
  " -- In this lab, w",
  StyleBox["e look at the group of automorphisms of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" and also look at inner automorphisms.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 10. ",
  StyleBox["Direct Products",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- The notion of direct products (sums) are introduced and we determine \
the order of elements in a direct product. We also try to determine when the \
direct product of cyclic groups is still cyclic. We also look for \
isomorphisms between some ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[" groups.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 11. ",
  StyleBox["Cosets",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" -- This lab explores the definition and properties of cosets.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 12. ",
  StyleBox["Normality and Factor groups",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " -- A normal group is defined and explored and then used to define and \
explore factor groups.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 13. ",
  StyleBox["Homomorphisms",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" -- This lab explores group homomorphisms.",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\nGroup Lab 14: ",
  StyleBox["Rotational groups of regular polyhedra",
    FontSlant->"Italic"],
  " -- Here we look at how to generate the rotational groups of several \
polyhedra."
}], "Text",
  CellTags->"grplb"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3 Contents of group labs", "Section",
  CellTags->"gtoc"],

Cell[CellGroupData[{

Cell["7.3.0 READ ME FIRST", "Subsection",
  CellTags->"gtoc0"],

Cell[TextData[{
  "Note that what is given below is a table of contents for all of the group \
labs in the text ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  ". For users of this book, the links are operative and will take you \
directly to the portion of the lab selected if the directory \"GroupLabs\" is \
inside \"AbstractAlgebra\"; for those who have only downloaded the packages, \
the links will not work without the files that accompany the book."
}], "Text",
  CellTags->{"gtoc", "gtoc0"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.3.1 Group Lab 1", "Subsection",
  CellTags->"gtoc1"],

Cell[TextData[ButtonBox["Group Lab 1. Using symmetry to uncover a group",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.1"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox[
"1.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.2.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.3.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.4.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.3 Getting started? - begin here",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.5.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.4 A symmetry of an equilateral triangle",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.6.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.5 Are there other symmetries?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.7.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.6 Multiplying our transformations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.8.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.7 Are there any commuters?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.9.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.8 Is it always bad to be closed-minded?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.10.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.9 We should try to find our identity",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.11.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.10 Is it perverse to not have an inverse?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.12.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.11 Should we associate together?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.13.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["test every possibility",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.13.2.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["test a random number of times",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.13.3.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["now the question:",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.13.4.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.12 What else?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.14.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.13 Let's group it all together",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.15.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}],

Cell[TextData[ButtonBox["1.14 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab01.nb"}], "a:1.16.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.2 Group Lab 2", "Subsection",
  CellTags->"gtoc2"],

Cell[TextData[ButtonBox[
"Group Lab 2. Determining the symmetry group of a given figure",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], None},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox[
"2.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], None},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.4.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.5.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.3 Symmetries and how to find them",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.6.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.3.1 Getting started",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.6.3.2"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.3.2 Functions/variables to use in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.6.4.2"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.4 Now your turn",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.7.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc2"}],

Cell[TextData[ButtonBox["2.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab02.nb"}], "a:2.8.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.3 Group Lab 3", "Subsection",
  CellTags->"gtoc3"],

Cell[TextData[ButtonBox["Group Lab 3. Is this a group?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.3"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc3"}],

Cell[TextData[ButtonBox[
"3.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.4.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc3"}],

Cell[TextData[ButtonBox["3.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.5.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc3"}],

Cell[TextData[ButtonBox["3.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.6.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc3"}],

Cell[TextData[ButtonBox["3.3 When do we have a group?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.7.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc3"}],

Cell[TextData[ButtonBox["3.4 Now your turn",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.8.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc3"}],

Cell[TextData[ButtonBox["3.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab03.nb"}], "a:3.9.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.4 Group Lab 4", "Subsection",
  CellTags->"gtoc4"],

Cell[TextData[ButtonBox["Group Lab 4. Let's get these orders straight",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab04.nb"}], "a:4.4"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[ButtonBox[
"4.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab04.nb"}], "a:4.5.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[ButtonBox["4.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab04.nb"}], "a:4.6.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[ButtonBox["4.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab04.nb"}], "a:4.7.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(4.3\ Order\ of\ \), 
            FormBox["g",
              "TraditionalForm"], \(\ and\ its\ inverse\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab04.nb"}], "a:4.8.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
          \(4.4\ Distribution\ of\ the\ orders\ of\ elements\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab04.nb"}], "a:4.9.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[ButtonBox["4.5 Another look at orders",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab04.nb"}], "a:4.10.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(4.6\ What\ is\ \), 
            FormBox[\(P(\(\(|g\) | \) = n)\),
              "TraditionalForm"], \(\ for\ \), 
            FormBox["g",
              "TraditionalForm"], \(\  \[Element] \ \), 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"], "?"}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab04.nb"}], "a:4.11.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(4.7\ More\ questions\ about\ \), 
            FormBox[\(U\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab04.nb"}], "a:4.12.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc4"}],

Cell[TextData[ButtonBox["4.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab04.nb"}], "a:4.13.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.5 Group Lab 5", "Subsection",
  CellTags->"gtoc5"],

Cell[TextData[ButtonBox["Group Lab 5. Subversively grouping our elements",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.5"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[ButtonBox[
"5.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.6.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[ButtonBox["5.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.7.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[ButtonBox["5.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.8.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[ButtonBox["5.3 When do we have a subgroup?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.9.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(5.4\ Subgroups\ of\ \), 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab05.nb"}], "a:5.10.5"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(5.5\ \), 
            FormBox[\(P(H < G)\),
              "TraditionalForm"], \(\ for\ a\ random\ subset\ \), 
            FormBox["H",
              "TraditionalForm"], \(\ of\ \), 
            FormBox[\(G = \[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab05.nb"}], "a:5.11.5"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[ButtonBox["5.6 Necessary elements for full closure",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.12.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(5.7\ Subgroups\ of\ \), 
            FormBox[\(U\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab05.nb"}], "a:5.13.5"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc5"}],

Cell[TextData[ButtonBox["5.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab05.nb"}], "a:5.14.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.6 Group Lab 6", "Subsection",
  CellTags->"gtoc6"],

Cell[TextData[ButtonBox["Group Lab 6. Cycling through the groups",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.6"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[ButtonBox[
"6.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.7.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[ButtonBox["6.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.8.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[ButtonBox["6.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.9.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[ButtonBox["6.3 What, when, how and why about cyclic groups",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.10.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(6.4\ Cyclicity\ of\ \), 
            
            FormBox[\(\[DoubleStruckCapitalZ]\_m
                  \[CirclePlus]\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab06.nb"}], "a:6.11.6"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[ButtonBox["6.5 Structure of intersections of subgroups of ",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.12.6"},
  ButtonStyle->"Hyperlink"],
ButtonBox["\[DoubleStruckCapitalZ]",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.12.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc6"}],

Cell[TextData[ButtonBox["6.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab06.nb"}], "a:6.13.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.7 Group Lab 7", "Subsection",
  CellTags->"gtoc7"],

Cell[TextData[ButtonBox["Group Lab 7. Permutations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.7"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox[
"7.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.8.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.9.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.10.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.3 What is a permutation?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.11.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.4 Computations with permutations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.12.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.5 Applications of permutations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.13.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.6 Questions about permutations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.14.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}],

Cell[TextData[ButtonBox["7.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab07.nb"}], "a:7.15.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.8 Group Lab 8", "Subsection",
  CellTags->"gtoc8"],

Cell[TextData[ButtonBox["Group Lab 8. Isomorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.8"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox[
"8.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.9.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.10.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.11.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.3 What is an isomorphism?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.12.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.4 Creating Morphoids",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.13.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.5 Seeing isomorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.14.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.5.1 example 1",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.14.9.8"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.5.2 example 2",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.14.10.8"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.5.3 example 3",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.14.11.8"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.5.4 example 4",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.14.12.8"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc8"}],

Cell[TextData[ButtonBox["8.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab08.nb"}], "a:8.15.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.9 Group Lab 9", "Subsection",
  CellTags->"gtoc9"],

Cell[TextData[ButtonBox["Group Lab 9. Automorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab09.nb"}], "a:9.9"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc9"}],

Cell[TextData[ButtonBox[
"9.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab09.nb"}], "a:9.10.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc9"}],

Cell[TextData[ButtonBox["9.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab09.nb"}], "a:9.11.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc9"}],

Cell[TextData[ButtonBox["9.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab09.nb"}], "a:9.12.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(9.3\ Automorphisms\ on\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab09.nb"}], "a:9.13.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc9"}],

Cell[TextData[ButtonBox["9.4 Inner automorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab09.nb"}], "a:9.14.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc9"}],

Cell[TextData[ButtonBox["9.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab09.nb"}], "a:9.15.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.10 Group Lab 10", "Subsection",
  CellTags->"gtoc10"],

Cell[TextData[ButtonBox["Group Lab 10. Direct products",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.10"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox[
"10.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.11.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox["10.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.12.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox["10.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.13.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox["10.3 What is a direct product?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.14.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox["10.4 Order of an element in a direct product",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.15.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox[
"10.5 When is a direct product of cyclic groups cyclic?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.16.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox[
"What are the generators of a cyclic direct product?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.16.11.10"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(10.6\ Isomorphisms\ among\ \), 
            FormBox[\(U\_n\),
              "TraditionalForm"], \(\ groups\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "GroupLabs", "GrpLab10.nb"}], "a:10.17.10"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"gtoc", "gtoc10"}],

Cell[TextData[ButtonBox["10.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab10.nb"}], "a:10.18.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.11 Group Lab 11", "Subsection",
  CellTags->"gtoc11"],

Cell[TextData[ButtonBox["Group Lab 11. Cosets",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.11"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc11"}],

Cell[TextData[ButtonBox[
"11.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.12.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc11"}],

Cell[TextData[ButtonBox["11.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.13.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc11"}],

Cell[TextData[ButtonBox["11.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.14.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc11"}],

Cell[TextData[ButtonBox["11.3 Cosets, left and right",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.15.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc11"}],

Cell[TextData[ButtonBox["11.4 Properties of cosets",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.16.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc11"}],

Cell[TextData[ButtonBox["11.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab11.nb"}], "a:11.17.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.12 Group Lab 12", "Subsection",
  CellTags->"gtoc12"],

Cell[TextData[ButtonBox["Group Lab 12. Normality and factor groups",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.12"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox[
"12.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.13.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox["12.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.14.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox["12.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.15.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox["12.3 Normal subgroups",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.16.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox["12.4 Making a new group",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.17.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox["12.5 Factor groups",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.18.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}],

Cell[TextData[ButtonBox["12.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab12.nb"}], "a:12.19.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.13 Group Lab 13", "Subsection",
  CellTags->"gtoc13"],

Cell[TextData[ButtonBox["Group Lab 13. Group homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.13"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox[
"13.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.14.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.15.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.16.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.3 What is a group homomorphism?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.17.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.4 The kernel and image",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.18.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.4.1 The kernel",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.18.14.13"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.4.2 The image",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.18.15.13"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox[
"13.5 Properties that are preserved by homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.19.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.6 The kernel is normal",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.20.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.7 The First Homomorphism Theorem",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.21.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.7.1 Example 2",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.21.14.13"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.7.2 Example 3",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.21.15.13"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.8 The alternating group -- parity as a morphism",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.22.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}],

Cell[TextData[ButtonBox["13.9 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab13.nb"}], "a:13.23.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3.14 Group Lab 14", "Subsection",
  CellTags->"gtoc14"],

Cell[TextData[ButtonBox[
"Group Lab 14: Rotational groups of regular polyhedra",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.14"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox[
"14.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.15.14"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.16.14"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.17.14"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.3 Example - the Tetrahedron",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.18.14"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.3.1 Statement of the problem, first rotation",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.18.15.14"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.3.2 Generation of more rotations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.18.16.14"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox[
"14.3.3 Procedure for finding more complicated rotations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.18.17.14"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox[
"14.3.4 Verification that we have the complete rotational group",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.18.18.14"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.4 Further exercises",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.19.14"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc14"}],

Cell[TextData[ButtonBox["14.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "GroupLabs",
       "GrpLab14.nb"}], "a:14.20.14"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"gtoc", "gtoc14"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["7.4 Summaries of ring labs", "Section",
  CellTags->"rnglb"],

Cell[TextData[{
  "Ring Lab 1. ",
  StyleBox["An Introduction to Ringoids and Rings",
    FontSlant->"Italic"],
  " -- This introduces some of the definitions and properties of rings.\nRing \
Lab 2. ",
  StyleBox["An Introduction to Rings: part two --",
    FontSlant->"Italic"],
  " Guess what this is about!\nRing Lab 3. ",
  StyleBox["An ideal part of rings",
    FontSlant->"Italic"],
  " -- This explores the notion of an ideal and properties related to it.\n\
Ring Lab 4. ",
  StyleBox["What does ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][i]/
        \[LeftAngleBracket]a + b\ i\[RightAngleBracket]\)]],
  StyleBox[" look like?",
    FontSlant->"Italic"],
  " -- This lab focuses on the Gaussian integers mod an ideal generated by \
some Gaussian integer.\nRing Lab 5. ",
  StyleBox["Ring homomorphisms",
    FontSlant->"Italic"],
  " -- This lab looks at ring homomorphisms, the First Isomorphism Theorem, \
and the Chinese Remainder Theorem.\nRing Lab 6. ",
  StyleBox["Polynomial rings",
    FontSlant->"Italic"],
  " -- Some basic properties of polynomial rings are introduced and explored.\
\nRing Lab 7. ",
  StyleBox["Factoring and irreducibility",
    FontSlant->"Italic"],
  " -- What does it mean to factor a polynomial? Various definitions and \
techniques are introduced. \nRing Lab 8. ",
  StyleBox["Roots of unity",
    FontSlant->"Italic"],
  " -- This lab focuses on the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  " and explores graphically the zeros of this polynomial, in particular \
seeing how the zeros are related to the factors and how the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " springs out of this.\nRing Lab 9. ",
  StyleBox["Cyclotomic polynomials",
    FontSlant->"Italic"],
  " -- This lab focuses on cyclotomic polynomials and the many properties \
related to them.\nRing Lab 10. ",
  StyleBox["Quotient rings of polynomials",
    FontSlant->"Italic"],
  " -- The notion of a quotient ring over a polynomial is introduced in this \
lab.\nRing Lab 11. ",
  StyleBox["Quadratic field extensions",
    FontSlant->"Italic"],
  " -- This lab continues the last by looking more closely at quotient rings \
modulo a quadratic polynomial where the result is a field.\nRing Lab 12. ",
  StyleBox["Factoring in",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[DoubleStruckCapitalZ][\@d\),
            "TraditionalForm"], "]"}], TraditionalForm]]],
  " -- This lab focuses on the rings ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[DoubleStruckCapitalZ][\@d\),
            "TraditionalForm"], "]"}], TraditionalForm]]],
  " and pursues the notion of divisibility and factoring in such rings. \
Several rings are illustrated as failing being a UFD.\nRing Lab 13. ",
  StyleBox["Finite Fields",
    FontSlant->"Italic"],
  " -- This lab continues the ideas formulated in lab 11 by looking at Galois \
fields and properties related to them."
}], "Text",
  CellTags->"rnglb"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5 Contents of ring labs", "Section",
  CellTags->"rtoc"],

Cell[CellGroupData[{

Cell["7.5.0 READ ME FIRST", "Subsection",
  CellTags->{"rtoc", "rtoc0"}],

Cell[TextData[{
  "Note that what is given below is a table of contents for all of the ring \
labs in the text ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  ". For users of this book, the links are operative and will take you \
directly to the portion of the lab selected if the directory \"RingLabs\" is \
in \"AbstractAlgebra\"; for those who have only downloaded the packages, the \
links will not work without the files that accompany the book."
}], "Text",
  CellTags->{"rtoc", "rtoc0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.1 Ring Lab 1", "Subsection",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["Ring Lab 1. An introduction to rings and Ringoids",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.1"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox[
"1.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.2.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.3.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.4.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.3 Getting started? Begin here",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.5.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.4 Ringoids and rings",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.6.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.5 Properties of rings",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.7.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.5.1 Additive properties",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.7.2.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.5.2 Multiplicative properties",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.7.3.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.5.3 Distributive property",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.7.4.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.5.4 Is the Ringoid a ring?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.7.5.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.5.5 \"Optional\" properties",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.7.6.1"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.6 Additional exercises",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.8.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}],

Cell[TextData[ButtonBox["1.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab01.nb"}], "a:1.9.1"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.2 Ring Lab 2", "Subsection",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["Ring Lab 2. An introduction to rings: part two",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.2"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox[
"2.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.3.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.4.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.5.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.3 Units & zero divisors",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.6.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.3.1 Units of a ring",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.6.3.2"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.3.2 Zero divisors of a ring",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.6.4.2"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.3.3 Working with zero divisors",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.6.5.2"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.4 Integral domains",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.7.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.5 Fields",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.8.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.6 Additional exercises",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.9.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}],

Cell[TextData[ButtonBox["2.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab02.nb"}], "a:2.10.2"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.3 Ring Lab 3", "Subsection",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["Ring Lab 3. An ideal part of rings",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.3"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox[
"3.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.4.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.5.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.6.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.3 What is the ideal part of a ring?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.7.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.3.1 The definition:",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.7.4.3"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.3.2 Another ring",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.7.5.3"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.4 Ideals factor into other ring properties",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.8.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc3"}],

Cell[TextData[ButtonBox["3.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab03.nb"}], "a:3.9.3"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.4 Ring Lab 4", "Subsection",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(Ring\ Lab\ 4.\), " ", \(What\ does\ \), 
            
            FormBox[\(\[DoubleStruckCapitalZ][i]/
                \[LeftAngleBracket]a\  + \ b\ i\[RightAngleBracket]\),
              "TraditionalForm"], \(\ look\ \(like?\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab04.nb"}], "a:4.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "ContentsSection",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox[
"4.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.5.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox["4.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.6.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox["4.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.7.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox["4.3 First example",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.8.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox["4.3.1 What ring is it?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.8.5.4"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox["4.4 A second example",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.9.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc4"}],

Cell[TextData[ButtonBox["4.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab04.nb"}, CharacterEncoding -> "MacintoshRoman"], "a:4.10.4"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.5 Ring Lab 5", "Subsection",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["Ring Lab 5. Ring homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.5"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox[
"5.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.6.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.7.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.8.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.3 Morphoids on rings",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.9.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.4 Ring homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.10.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.5 The kernel and image",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.11.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.5.1 The kernel",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.11.6.5"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.5.2 The image",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.11.7.5"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.6 The kernel is an ideal",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.12.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.6.1 Example 1",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.12.6.5"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.6.2 The First Isomorphism Theorem (for rings)",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.12.7.5"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.6.3 Example 2",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.12.8.5"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.7 One rule Morphoids",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.13.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.8 The Chinese Remainder Theorem",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.14.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}],

Cell[TextData[ButtonBox["5.9 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab05.nb"}], "a:5.15.5"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.6 Ring Lab 6", "Subsection",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["Ring Lab 6. Polynomial rings",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.6"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox[
"6.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.7.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.8.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.9.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.3 An introduction to polynomials",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.10.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.4 Divide and conquer",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.11.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.4.1 The Euclidean Algorithm",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.11.7.6"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.4.2 Another approach",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.11.8.6"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc6"}],

Cell[TextData[ButtonBox["6.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab06.nb"}], "a:6.12.6"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.7 Ring Lab 7", "Subsection",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["Ring Lab 7. Factoring and irreducibility",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.7"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox[
"7.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.8.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["7.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.9.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["7.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.10.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox[
"7.3 An introduction to factoring and irreducibility",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.11.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox[
"7.4 Some techniques on testing the irreducibility of polynomials",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.12.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4 .1\ Polynomials\ over\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_p\),
              "TraditionalForm"], 
            StyleBox[" ",
              AspectRatioFixed->True,
              FontVariations->{"CompatibilityType"->"Subscript"}], 
            StyleBox[\(\(--Theorem\)\ 1\),
              AspectRatioFixed->True]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.8.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4 .2\ \),
              AspectRatioFixed->True], 
            FormBox[\(2 x^3\  + \ 3 x^2\  - \ 1\),
              "TraditionalForm"], 
            \(over\ \(\[DoubleStruckCapitalQ]\ --\)\ Rational\ Root\ Theorem
              \)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.9.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4 .3\ \),
              AspectRatioFixed->True], 
            FormBox[\(x^4\  - \ 2 x^3\  - \ 7\ x^2\  - \ 11/3 x\  - \ 4/3\),
              "TraditionalForm"], \(\ over\ \), 
            FormBox["\[DoubleStruckCapitalQ]",
              "TraditionalForm"], \(\ \(--\ Mod\)\ \), 
            FormBox["p",
              "TraditionalForm"], \(\ Irreducibility\ Test\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.10.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4 .4\ \),
              AspectRatioFixed->True], 
            FormBox[\(x^4\  - \ 3 x^2\  + \ 2 x\  + \ 1\),
              "TraditionalForm"], 
            \(over\ \(\[DoubleStruckCapitalQ]\ --\)\ how\ to\ handle\ quartics
              \)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.11.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4 .5\ \), 
            FormBox[\(2 x^4 - 2 x^3 - 17 x^2 + 25 x - 7\),
              "TraditionalForm"], 
            \(over\ \(\[DoubleStruckCapitalZ]\ --\) Theorem\ 2\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.12.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4 .6\ \), 
            FormBox[\(3 x^8\  - \ 4 x^6\  + \ 8 x^5\  - \ 10 x\  + \ 6\),
              "TraditionalForm"], \(\ over\ \), 
            FormBox["\[DoubleStruckCapitalQ]",
              "TraditionalForm"], \(\ \(--\ Eisenstein\)' s\ Criterion\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.13.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4 .7\ \), 
            FormBox[\(x^4\  + \ 4\),
              "TraditionalForm"], 
            StyleBox[\(\ over\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_7\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.14.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4 .8\ \), 
            FormBox[\(x^4\  - \ 2 x^3\  + \ x^2\  + \ 1\),
              "TraditionalForm"], \(\ over\ \[DoubleStruckCapitalR]\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab07.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.15.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["7.5 More polynomials for practice",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.13.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["7.6 Toolbox of theorems",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.14.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["7.7 A final perspective",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.15.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}],

Cell[TextData[ButtonBox["7.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab07.nb"}], "a:7.16.7"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.8 Ring Lab 8", "Subsection",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["Ring Lab 8. Roots of unity",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.8"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox[
"8.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.9.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["8.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.10.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["8.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.11.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["8.3 An introduction",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.12.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["8.4 A closer look -- graphically",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.13.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["8.5 Another look -- algebraically",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.14.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}],

Cell[TextData[ButtonBox["8.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab08.nb"}], "a:8.15.8"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.9 Ring Lab 9", "Subsection",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["Ring Lab 9. Cyclotomic polynomials",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.9"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox[
"9.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.10.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.11.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.12.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.3 An introduction",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.13.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(9.4\ The\ search\ for\ \),
              AspectRatioFixed->True], 
            FormBox[\(\(g\_n\)(x)\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.14.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(9.5\ Some\ properties\ of\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.5.1 Each cyclotomic polynomial is monic",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.15.10.9"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.5.2 The degrees of the cyclotomic polynomials",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.15.11.9"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox[
"9.5.3 The irreducibility of the cyclotomic polynomial",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.15.12.9"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.5.4 Graphs of roots of the cyclotomic polynomial",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.15.13.9"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5 .5\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], \(2 n\)], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ for\ odd\ \),
              AspectRatioFixed->True], 
            FormBox["n",
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.14.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5 .6\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "p"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], \(p\^k\)], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ for\ prime\ \),
              AspectRatioFixed->True], 
            FormBox["p",
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.15.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5 .7\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "m"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ where\ \),
              AspectRatioFixed->True], 
            FormBox["m",
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox["n",
              "TraditionalForm"], 
            StyleBox[\(\ have\ similar\ prime\ decompositions\),
              AspectRatioFixed->True]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.16.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5 .8\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "1", ")"}],
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.17.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5 .9\ \), 
            StyleBox[\(How\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"], 
            
            StyleBox[\(\ is\ related\ to\ the\ Moebius\ function, 
              yielding\ a\ non - recursive\ definition\),
              AspectRatioFixed->True]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab09.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.18.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.5.10 Disclaimer/warning",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.15.19.9"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc9"}],

Cell[TextData[ButtonBox["9.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab09.nb"}], "a:9.16.9"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.10 Ring Lab 10", "Subsection",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["Ring Lab 10. Quotient rings of polynomials",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.10"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox[
"10.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.11.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.12.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.13.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.3 Polynomials over a field",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.14.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.4 A homomorphism based on PolynomialRemainder",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.15.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.5 Defining a quotient ring of polynomials",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.16.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.5.1 Addition",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.16.11.10"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.5.2 Multiplication",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.16.12.10"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.6 The PolynomialRemainder function ",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.17.10"},
  ButtonStyle->"Hyperlink"],
ButtonBox["\[Theta]",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.17.10"},
  ButtonStyle->"Hyperlink"],
ButtonBox[" is indeed a homomorphism",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.17.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.7 Is V a field?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.18.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.8 Is V what we claimed?",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.19.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}],

Cell[TextData[ButtonBox["10.9 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab10.nb"}], "a:10.20.10"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.11 Ring Lab 11", "Subsection",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["Ring Lab 11. Quadratic field extensions",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.11"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox[
"11.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.12.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["11.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.13.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["11.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.14.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["11.3 The general problem",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.15.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["11.3.1 Example",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.15.12.11"},
  ButtonStyle->"Hyperlink"]], "Index",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(11.4\ An\ extension\ of\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_3\ \),
              "TraditionalForm"], 
            StyleBox[\(using\ \),
              AspectRatioFixed->True], 
            StyleBox["Mathematica",
              AspectRatioFixed->True,
              FontSlant->"Italic"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab11.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:11.16.11"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["11.5 Theorems that are motivated from this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.17.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc11"}],

Cell[TextData[ButtonBox["11.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab11.nb"}], "a:11.18.11"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.12 Ring Lab 12", "Subsection",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(Ring\ Lab\ 12.\ Factoring\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ][\[Sqrt]d]\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab12.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:12.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "ContentsSection",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[ButtonBox[
"12.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab12.nb"}], "a:12.13.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[ButtonBox["12.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab12.nb"}], "a:12.14.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[ButtonBox["12.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab12.nb"}], "a:12.15.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[ButtonBox["12.3 An introduction to divisibility",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab12.nb"}], "a:12.16.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[ButtonBox["12.4 Associates, irreducibility and norms",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab12.nb"}], "a:12.17.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(12.5\ \),
              AspectRatioFixed->True], \(Units\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ][\[Sqrt]d]\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab12.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:12.18.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(12.6\ \),
              AspectRatioFixed->True], \(Factoring\ 46\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ][\[Sqrt]\((\(-5\))\)]\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab12.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:12.19.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(12.7\ \),
              AspectRatioFixed->True], \(Is\ \), 
            FormBox[\(\[DoubleStruckCapitalZ][\[Sqrt]\((\(-6\))\)]\),
              "TraditionalForm"], \(\ a\ \(UFD?\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          FrontEnd`FileName[
           {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
            "RingLabs", "RngLab12.nb"}, CharacterEncoding -> 
            "MacintoshRoman"], "a:12.20.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents",
  CellTags->{"rtoc", "rtoc12"}],

Cell[TextData[ButtonBox["12.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab12.nb"}], "a:12.21.12"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5.13 Ring Lab 13", "Subsection",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox["Ring Lab 13. Finite fields",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.13"},
  ButtonStyle->"Hyperlink"]], "ContentsSection",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox[
"13.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.14.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox["13.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.15.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox["13.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.16.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox["13.3 Creation of finite fields",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.17.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox["13.4 Finite field theorems and illustrations",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.18.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc13"}],

Cell[TextData[ButtonBox["13.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[
     {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", "RingLabs", 
      "RngLab13.nb"}], "a:13.19.13"},
  ButtonStyle->"Hyperlink"]], "Contents",
  CellTags->{"rtoc", "rtoc13"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.6 Palettes available for users of ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[CellGroupData[{

Cell["7.6.1 Palette introduction", "Subsection",
  CellTags->"palintro"],

Cell[TextData[{
  "The palettes described below accompany the text ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". For users of this text, one can click on the blue palette name (link) to \
bring up the given palette.\nNote that pink buttons provide information, \
green buttons cause an action to be executed, but no pasting, gray cells \
bring up palettes or paste a function name, and yellow buttons paste function \
options."
}], "Text",
  CellTags->"palintro"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.2 AbstractAlgebra", "Subsection",
  CellTags->"AbstractAlgebraPalette"],

Cell[TextData[{
  ButtonBox["AbstractAlgebra palette",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "AbstractAlgebraPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - from this main palette, all other palettes can be obtained.  Ideally, \
this should be located in the Palettes directory of the FrontEnd directory in \
the Configuration directory, which will allow it to be accessible from the \
File/Palettes menu. (If it is not already there, you may wish to make a copy \
of it to this location.)"
}], "Text",
  CellTags->"AbstractAlgebraPalette"],

Cell[TextData[{
  "This palette contains the following buttons, whose purpose follows the \
button name:\n\[Bullet] Needs[\"AbstractAlgebra`Master`\"] -\.08loads the \
Master package to begin working with the AbstractAlgebra packages\n\[Bullet] \
SwitchStructureTo[Group] - specifies that groups are the default structures \
for future operations\n\[Bullet] SwitchStructureTo[Ring] - specifies that \
rings are the default structures for future operations\n\[Bullet] Help with \
the palettes - brings up a notebook\.08giving additional details regarding \
how to use these palettes\n\[Bullet] Groupoids - brings up a palette listing \
many of the common built-in Groupoids\n\[Bullet] Ringoids and Morphoids \
-brings up a palette listing many of the common built-in Ringoids and \
Morphoids\n\[Bullet] General AA functions - functions that are applicable \
generally or apply to both Groupoids and Ringoids\n\[Bullet] Group functions \
- functions for working with Groupoids\n\[Bullet] Permutations functions - \
functions for working with permutations\n\[Bullet] Morphism functions - \
functions for working with Morphoids\n\[Bullet] Ring functions - functions \
for working with Ringoids\n\[Bullet] Polynomial functions - functions for \
working with polynomials over various rings\n\[Bullet] Matrix functions - \
functions for working with matrices over various rings\n\[Bullet] Galois \
field functions - functions for working with Galois fields\n\[Bullet] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  " functions - functions for working with ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  " rings\n\[Bullet] palettes for working with groups/rings - brings up a \
notebook containing a place to enter a group or a ring and oppotunities to \
explore this group or ring - see below for further details\n\[Bullet] All AA \
palettes - brings up a narrow, scrollable notebook containing all of the \
palettes that are listed above, except for the last one"
}], "Text",
  CellTags->"AbstractAlgebraPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.3 Groupoids", "Subsection",
  CellTags->"GroupoidsPalette"],

Cell[TextData[{
  ButtonBox["Groupoids",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "GroupoidsPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - brings up a palette listing many of the common built-in Groupoids"
}], "Text",
  CellTags->"GroupoidsPalette"]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.6.4 Ringoids and Morphoids", "Subsection",
  CellTags->"RingoidsPalette"],

Cell[TextData[{
  ButtonBox["Ringoids and Morphoids",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "RingoidsMorphoidsPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - brings up a palette listing many of the common built-in Ringoids and \
Morphoids"
}], "Text",
  CellTags->"RingoidsPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.5 General AbstractAlgebra", "Subsection",
  CellTags->"GeneralPalette"],

Cell[TextData[{
  ButtonBox["General AA functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "GeneralPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions that are applicable generally or apply to both Groupoids and \
Ringoids"
}], "Text",
  CellTags->"GeneralPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.6 Group functions", "Subsection",
  CellTags->"GroupPalette"],

Cell[TextData[{
  ButtonBox["Group functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "GroupPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with Groupoids"
}], "Text",
  CellTags->"GroupPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.7 Permutation functions", "Subsection",
  CellTags->"PermutationPalette"],

Cell[TextData[{
  ButtonBox["Permutations functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "PermutationsPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with permutations"
}], "Text",
  CellTags->"PermutationPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.8 Morphism functions", "Subsection",
  CellTags->"MorphismPalette"],

Cell[TextData[{
  ButtonBox["Morphism functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "MorphismPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with Morphoids"
}], "Text",
  CellTags->"MorphismPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.9 Ring functions", "Subsection",
  CellTags->"RingPalette"],

Cell[TextData[{
  ButtonBox["Ring functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "RingPalette.nb"}, CharacterEncoding -> "MacintoshRoman"],
       None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with Ringoids"
}], "Text",
  CellTags->"RingPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.10 Polynomial functions", "Subsection",
  CellTags->"PolynomialPalette"],

Cell[TextData[{
  ButtonBox["Polynomial functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "PolynomialPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with polynomials over various rings"
}], "Text",
  CellTags->"PolynomialPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.11 Matrix functions", "Subsection",
  CellTags->"MatrixPalette"],

Cell[TextData[{
  ButtonBox["Matrix functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "MatrixPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with matrices over various rings"
}], "Text",
  CellTags->"MatrixPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.12 Galois field functions", "Subsection",
  CellTags->"GaloisPalette"],

Cell[TextData[{
  ButtonBox["Galois field functions",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "GaloisFieldPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - functions for working with Galois fields"
}], "Text",
  CellTags->"GaloisPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.6.13 ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  " functions"
}], "Subsection",
  CellTags->"ZdPalette"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        ButtonBox[
          RowBox[{
            FormBox[\(\[DoubleStruckCapitalZ][\@d]\),
              "TraditionalForm"], " ", "functions"}],
          ButtonData:>{
            FrontEnd`FileName[
             {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
              "Palettes", "ZdPalette.nb"}, CharacterEncoding -> 
              "MacintoshRoman"], None},
          ButtonStyle->"Hyperlink"], TraditionalForm]]],
  " - functions for working with ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  " rings"
}], "Text",
  CellTags->"ZdPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.14 Group (ring) properties and calculations", "Subsection",
  CellTags->"MultiPalette"],

Cell[TextData[{
  ButtonBox["Group (ring) properties and calculations",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "MultiPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - brings up a notebook containing a place to enter a group or a ring and \
oppotunities to explore this group or ring with the following choices:\n\
\[Bullet] create a palette with a button for each element\n\[Bullet] create \
GroupCalculator, a calculator for performing some group calculations\n\
\[Bullet] test properties of the elements in the chosen Groupoid or Ringoid\n\
\[Bullet] test properties of the chosen Groupoid or Ringoid"
}], "Text",
  CellTags->"MultiPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.15 All AbstractAlgebra palettes", "Subsection",
  CellTags->"AllPalette"],

Cell[TextData[{
  ButtonBox["All AA palettes ",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "AAPalettes.nb"}, CharacterEncoding -> "MacintoshRoman"], 
      None},
    ButtonStyle->"Hyperlink"],
  " - brings up a narrow, scrollable notebook containing all of the palettes \
that are listed above, except for the last one"
}], "Text",
  CellTags->"AllPalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6.16 Group Lab Two", "Subsection",
  CellTags->"GLab2Palette"],

Cell[TextData[{
  ButtonBox["Group Lab Two",
    ButtonData:>{
      FrontEnd`FileName[
       {$TopDirectory, "AddOns", "Applications", "AbstractAlgebra", 
        "Palettes", "GroupLabTwoPalette.nb"}, CharacterEncoding -> 
        "MacintoshRoman"], None},
    ButtonStyle->"Hyperlink"],
  " - brings up a palette used in the second group lab"
}], "Text",
  CellTags->"GLab2Palette"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"AllBrackets",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{494, 420},
WindowMargins->{{67, Automatic}, {Automatic, 1}},
ShowGroupOpenCloseIcon->True,
TaggingRules:>{"NextIndexingNumber" -> 7, "IndexEntries" -> {{"i:1", 
  "Installation instructions"}, {"i:2", "Version-specific notes"}, {"i:3", 
  "Bibliography"}, {"i:3", "References"}, {"i:6", {
  StyleBox[ "Exploring Abstract Algebra with", FontSlant -> "Italic"], " ", 
  StyleBox[ "Mathematica", FontSlant -> "Italic"]}}, {"i:4", 
  "Objects in AbstractAlgebra", "Alphabetically"}, {"i:5", 
  "Objects in AbstractAlgebra", "by packages"}}},
StyleDefinitions -> "Manual.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "i:6"->{
    Cell[1941, 62, 72, 1, 68, "Section",
      CellTags->{"i:6", "overview"}]},
  "overview"->{
    Cell[1941, 62, 72, 1, 68, "Section",
      CellTags->{"i:6", "overview"}],
    Cell[2016, 65, 1615, 31, 285, "Text",
      CellTags->"overview"],
    Cell[3634, 98, 1557, 25, 286, "Text",
      CellTags->"overview"],
    Cell[5194, 125, 408, 7, 90, "Text",
      CellTags->"overview"],
    Cell[5605, 134, 277, 8, 58, "Text",
      CellTags->"overview"]},
  "grplb"->{
    Cell[5919, 147, 67, 1, 42, "Section",
      CellTags->"grplb"],
    Cell[5989, 150, 6313, 193, 716, "Text",
      CellTags->"grplb"]},
  "gtoc"->{
    Cell[12339, 348, 65, 1, 42, "Section",
      CellTags->"gtoc"],
    Cell[12494, 356, 541, 10, 96, "Text",
      CellTags->{"gtoc", "gtoc0"}],
    Cell[13135, 374, 305, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[13443, 382, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[13763, 391, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14037, 399, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14316, 407, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14606, 415, 295, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14904, 423, 285, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[15192, 431, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[15484, 439, 282, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[15769, 447, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16068, 455, 293, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16364, 463, 298, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16665, 471, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16957, 479, 276, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[17236, 487, 283, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[17522, 495, 271, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[17796, 503, 270, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[18069, 511, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[18359, 519, 297, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[18756, 533, 318, 7, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19077, 542, 312, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19392, 551, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19666, 559, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19945, 567, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[20237, 575, 274, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[20514, 583, 297, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[20814, 591, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[21088, 599, 295, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[21483, 613, 288, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[21774, 621, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22094, 630, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22368, 638, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22647, 646, 282, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22932, 654, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[23206, 662, 295, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[23601, 676, 303, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[23907, 684, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[24227, 693, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[24501, 701, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[24780, 709, 725, 19, 20, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[25508, 730, 776, 20, 21, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[26287, 752, 281, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[26571, 760, 908, 23, 21, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[27482, 785, 719, 19, 21, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[28204, 806, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[28600, 820, 306, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[28909, 828, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[29229, 837, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[29503, 845, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[29782, 853, 285, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[30070, 861, 732, 19, 21, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[30805, 882, 894, 23, 21, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[31702, 907, 294, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[31999, 915, 710, 19, 21, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[32712, 936, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[33108, 950, 298, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[33409, 958, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[33729, 967, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[34003, 975, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[34282, 983, 302, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[34587, 991, 803, 21, 21, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[35393, 1014, 523, 12, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[35919, 1028, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[36315, 1042, 284, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[36602, 1050, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[36922, 1059, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[37196, 1067, 277, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[37476, 1075, 281, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[37760, 1083, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[38052, 1091, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[38342, 1099, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[38632, 1107, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[39028, 1121, 284, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[39315, 1129, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[39635, 1138, 272, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[39910, 1146, 277, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[40190, 1154, 282, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[40475, 1162, 277, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[40755, 1170, 278, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41036, 1178, 269, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41308, 1186, 270, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41581, 1194, 270, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41854, 1202, 270, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[42127, 1210, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[42523, 1224, 285, 6, 106, "ContentsSection",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[42811, 1232, 318, 7, 134, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[43132, 1241, 272, 6, 106, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[43407, 1249, 277, 6, 106, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[43687, 1257, 797, 21, 414, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[44487, 1280, 278, 6, 106, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[44768, 1288, 296, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[45167, 1302, 291, 6, 106, "ContentsSection",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[45461, 1310, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[45786, 1319, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46065, 1327, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46349, 1335, 288, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46640, 1343, 302, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46945, 1351, 313, 7, 134, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[47261, 1360, 310, 7, 134, "Index",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[47574, 1369, 734, 19, 400, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[48311, 1390, 300, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[48714, 1404, 282, 6, 106, "ContentsSection",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[48999, 1412, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[49324, 1421, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[49603, 1429, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[49887, 1437, 285, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[50175, 1445, 283, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[50461, 1453, 300, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[50864, 1467, 303, 6, 120, "ContentsSection",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[51170, 1475, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[51495, 1484, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[51774, 1492, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52058, 1500, 279, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52340, 1508, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52624, 1516, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52903, 1524, 300, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[53306, 1538, 295, 6, 120, "ContentsSection",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[53604, 1546, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[53929, 1555, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[54208, 1563, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[54492, 1571, 292, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[54787, 1579, 283, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55073, 1587, 275, 6, 120, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55351, 1595, 274, 6, 120, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55628, 1603, 310, 7, 134, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55941, 1612, 283, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[56227, 1620, 293, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[56523, 1628, 274, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[56800, 1636, 274, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[57077, 1644, 308, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[57388, 1652, 300, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[57791, 1666, 315, 7, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58109, 1675, 322, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58434, 1684, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58713, 1692, 281, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58997, 1700, 288, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[59288, 1708, 305, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[59596, 1716, 293, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[59892, 1724, 314, 7, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[60209, 1733, 321, 7, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[60533, 1742, 280, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[60816, 1750, 300, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}]},
  "gtoc0"->{
    Cell[12429, 353, 62, 1, 54, "Subsection",
      CellTags->"gtoc0"],
    Cell[12494, 356, 541, 10, 96, "Text",
      CellTags->{"gtoc", "gtoc0"}]},
  "gtoc1"->{
    Cell[13072, 371, 60, 1, 54, "Subsection",
      CellTags->"gtoc1"],
    Cell[13135, 374, 305, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[13443, 382, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[13763, 391, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14037, 399, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14316, 407, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14606, 415, 295, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[14904, 423, 285, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[15192, 431, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[15484, 439, 282, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[15769, 447, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16068, 455, 293, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16364, 463, 298, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16665, 471, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[16957, 479, 276, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[17236, 487, 283, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[17522, 495, 271, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[17796, 503, 270, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[18069, 511, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}],
    Cell[18359, 519, 297, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc1"}]},
  "gtoc2"->{
    Cell[18693, 530, 60, 1, 28, "Subsection",
      CellTags->"gtoc2"],
    Cell[18756, 533, 318, 7, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19077, 542, 312, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19392, 551, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19666, 559, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[19945, 567, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[20237, 575, 274, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[20514, 583, 297, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[20814, 591, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}],
    Cell[21088, 599, 295, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc2"}]},
  "gtoc3"->{
    Cell[21420, 610, 60, 1, 28, "Subsection",
      CellTags->"gtoc3"],
    Cell[21483, 613, 288, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[21774, 621, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22094, 630, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22368, 638, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22647, 646, 282, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[22932, 654, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}],
    Cell[23206, 662, 295, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc3"}]},
  "gtoc4"->{
    Cell[23538, 673, 60, 1, 28, "Subsection",
      CellTags->"gtoc4"],
    Cell[23601, 676, 303, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[23907, 684, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[24227, 693, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[24501, 701, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[24780, 709, 725, 19, 20, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[25508, 730, 776, 20, 21, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[26287, 752, 281, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[26571, 760, 908, 23, 21, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[27482, 785, 719, 19, 21, "Contents",
      CellTags->{"gtoc", "gtoc4"}],
    Cell[28204, 806, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc4"}]},
  "gtoc5"->{
    Cell[28537, 817, 60, 1, 28, "Subsection",
      CellTags->"gtoc5"],
    Cell[28600, 820, 306, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[28909, 828, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[29229, 837, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[29503, 845, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[29782, 853, 285, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[30070, 861, 732, 19, 21, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[30805, 882, 894, 23, 21, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[31702, 907, 294, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[31999, 915, 710, 19, 21, "Contents",
      CellTags->{"gtoc", "gtoc5"}],
    Cell[32712, 936, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc5"}]},
  "gtoc6"->{
    Cell[33045, 947, 60, 1, 28, "Subsection",
      CellTags->"gtoc6"],
    Cell[33108, 950, 298, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[33409, 958, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[33729, 967, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[34003, 975, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[34282, 983, 302, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[34587, 991, 803, 21, 21, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[35393, 1014, 523, 12, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}],
    Cell[35919, 1028, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc6"}]},
  "gtoc7"->{
    Cell[36252, 1039, 60, 1, 28, "Subsection",
      CellTags->"gtoc7"],
    Cell[36315, 1042, 284, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[36602, 1050, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[36922, 1059, 271, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[37196, 1067, 277, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[37476, 1075, 281, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[37760, 1083, 289, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[38052, 1091, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[38342, 1099, 287, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}],
    Cell[38632, 1107, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc7"}]},
  "gtoc8"->{
    Cell[38965, 1118, 60, 1, 28, "Subsection",
      CellTags->"gtoc8"],
    Cell[39028, 1121, 284, 6, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[39315, 1129, 317, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[39635, 1138, 272, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[39910, 1146, 277, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[40190, 1154, 282, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[40475, 1162, 277, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[40755, 1170, 278, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41036, 1178, 269, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41308, 1186, 270, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41581, 1194, 270, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[41854, 1202, 270, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc8"}],
    Cell[42127, 1210, 296, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc8"}]},
  "gtoc9"->{
    Cell[42460, 1221, 60, 1, 28, "Subsection",
      CellTags->"gtoc9"],
    Cell[42523, 1224, 285, 6, 106, "ContentsSection",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[42811, 1232, 318, 7, 134, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[43132, 1241, 272, 6, 106, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[43407, 1249, 277, 6, 106, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[43687, 1257, 797, 21, 414, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[44487, 1280, 278, 6, 106, "Contents",
      CellTags->{"gtoc", "gtoc9"}],
    Cell[44768, 1288, 296, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc9"}]},
  "gtoc10"->{
    Cell[45101, 1299, 63, 1, 28, "Subsection",
      CellTags->"gtoc10"],
    Cell[45167, 1302, 291, 6, 106, "ContentsSection",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[45461, 1310, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[45786, 1319, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46065, 1327, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46349, 1335, 288, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46640, 1343, 302, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[46945, 1351, 313, 7, 134, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[47261, 1360, 310, 7, 134, "Index",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[47574, 1369, 734, 19, 400, "Contents",
      CellTags->{"gtoc", "gtoc10"}],
    Cell[48311, 1390, 300, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc10"}]},
  "gtoc11"->{
    Cell[48648, 1401, 63, 1, 28, "Subsection",
      CellTags->"gtoc11"],
    Cell[48714, 1404, 282, 6, 106, "ContentsSection",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[48999, 1412, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[49324, 1421, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[49603, 1429, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[49887, 1437, 285, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[50175, 1445, 283, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc11"}],
    Cell[50461, 1453, 300, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc11"}]},
  "gtoc12"->{
    Cell[50798, 1464, 63, 1, 28, "Subsection",
      CellTags->"gtoc12"],
    Cell[50864, 1467, 303, 6, 120, "ContentsSection",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[51170, 1475, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[51495, 1484, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[51774, 1492, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52058, 1500, 279, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52340, 1508, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52624, 1516, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc12"}],
    Cell[52903, 1524, 300, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc12"}]},
  "gtoc13"->{
    Cell[53240, 1535, 63, 1, 28, "Subsection",
      CellTags->"gtoc13"],
    Cell[53306, 1538, 295, 6, 120, "ContentsSection",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[53604, 1546, 322, 7, 148, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[53929, 1555, 276, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[54208, 1563, 281, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[54492, 1571, 292, 6, 134, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[54787, 1579, 283, 6, 120, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55073, 1587, 275, 6, 120, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55351, 1595, 274, 6, 120, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55628, 1603, 310, 7, 134, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[55941, 1612, 283, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[56227, 1620, 293, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[56523, 1628, 274, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[56800, 1636, 274, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[57077, 1644, 308, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}],
    Cell[57388, 1652, 300, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc13"}]},
  "gtoc14"->{
    Cell[57725, 1663, 63, 1, 28, "Subsection",
      CellTags->"gtoc14"],
    Cell[57791, 1666, 315, 7, 36, "ContentsSection",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58109, 1675, 322, 7, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58434, 1684, 276, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58713, 1692, 281, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[58997, 1700, 288, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[59288, 1708, 305, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[59596, 1716, 293, 6, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[59892, 1724, 314, 7, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[60209, 1733, 321, 7, 14, "Index",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[60533, 1742, 280, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}],
    Cell[60816, 1750, 300, 6, 22, "Contents",
      CellTags->{"gtoc", "gtoc14"}]},
  "rnglb"->{
    Cell[61165, 1762, 66, 1, 42, "Section",
      CellTags->"rnglb"],
    Cell[61234, 1765, 3090, 78, 548, "Text",
      CellTags->"rnglb"]},
  "rtoc"->{
    Cell[64361, 1848, 64, 1, 42, "Section",
      CellTags->"rtoc"],
    Cell[64450, 1853, 72, 1, 54, "Subsection",
      CellTags->{"rtoc", "rtoc0"}],
    Cell[64525, 1856, 535, 10, 96, "Text",
      CellTags->{"rtoc", "rtoc0"}],
    Cell[65097, 1871, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[65169, 1874, 307, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[65479, 1882, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[65798, 1891, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66071, 1899, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66349, 1907, 284, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66636, 1915, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66914, 1923, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[67193, 1931, 277, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[67473, 1939, 283, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[67759, 1947, 279, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68041, 1955, 280, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68324, 1963, 281, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68608, 1971, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68888, 1979, 294, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[69219, 1990, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[69291, 1993, 304, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[69598, 2001, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[69917, 2010, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[70190, 2018, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[70468, 2026, 278, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[70749, 2034, 273, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71025, 2042, 281, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71309, 2050, 284, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71596, 2058, 273, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71872, 2066, 263, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[72138, 2074, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[72418, 2082, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[72750, 2093, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[72822, 2096, 292, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73117, 2104, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73436, 2113, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73709, 2121, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73987, 2129, 290, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[74280, 2137, 273, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[74556, 2145, 270, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[74829, 2153, 297, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[75129, 2161, 294, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[75460, 2172, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[75532, 2175, 856, 21, 34, "ContentsSection",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[76391, 2198, 355, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[76749, 2207, 309, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[77061, 2215, 314, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[77378, 2223, 309, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[77690, 2231, 313, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[78006, 2239, 312, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[78321, 2247, 334, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[78692, 2258, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[78764, 2261, 288, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79055, 2269, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79374, 2278, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79647, 2286, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79925, 2294, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[80203, 2302, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[80482, 2310, 278, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[80763, 2318, 269, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81035, 2326, 268, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81306, 2334, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81589, 2342, 268, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81860, 2350, 300, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[82163, 2358, 268, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[82434, 2366, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[82713, 2374, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[83003, 2382, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[83335, 2393, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[83407, 2396, 286, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[83696, 2404, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84015, 2413, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84288, 2421, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84566, 2429, 288, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84857, 2437, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[85136, 2445, 282, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[85421, 2453, 275, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[85699, 2461, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[86031, 2472, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86103, 2475, 298, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86404, 2483, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86723, 2492, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86996, 2500, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[87275, 2508, 306, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[87584, 2517, 319, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[87906, 2526, 1065, 27, 13, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[88974, 2555, 926, 24, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[89903, 2581, 1062, 26, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[90968, 2609, 937, 24, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[91908, 2635, 845, 21, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[92756, 2658, 929, 22, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[93688, 2682, 918, 24, 13, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[94609, 2708, 815, 20, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[95427, 2730, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[95717, 2738, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[95997, 2746, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[96277, 2754, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[96609, 2765, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[96681, 2768, 284, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[96968, 2776, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[97287, 2785, 271, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[97561, 2793, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[97840, 2801, 273, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[98116, 2809, 286, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[98405, 2817, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[98695, 2825, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[99027, 2836, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99099, 2839, 292, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99394, 2847, 317, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99714, 2856, 271, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99988, 2864, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[100267, 2872, 273, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[100543, 2880, 832, 22, 21, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[101378, 2904, 985, 26, 23, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[102366, 2932, 295, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[102664, 2940, 301, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[102968, 2948, 308, 7, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[103279, 2957, 304, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[103586, 2965, 1343, 36, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[104932, 3003, 1346, 36, 16, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[106281, 3041, 1575, 42, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[107859, 3085, 905, 24, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[108767, 3111, 1155, 30, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[109925, 3143, 279, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[110207, 3151, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[110539, 3162, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[110614, 3165, 303, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[110920, 3173, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[111244, 3182, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[111522, 3190, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[111805, 3198, 286, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112094, 3206, 305, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112402, 3214, 301, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112706, 3222, 272, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112981, 3230, 278, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[113262, 3238, 726, 18, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[113991, 3258, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[114269, 3266, 283, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[114555, 3274, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[114891, 3285, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[114966, 3288, 300, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[115269, 3296, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[115593, 3305, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[115871, 3313, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[116154, 3321, 281, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[116438, 3329, 271, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[116712, 3337, 1039, 27, 21, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[117754, 3366, 303, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[118060, 3374, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[118396, 3385, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[118471, 3388, 808, 20, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[119282, 3410, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[119606, 3419, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[119884, 3427, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[120167, 3435, 293, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[120463, 3443, 298, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[120764, 3451, 857, 22, 25, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[121624, 3475, 876, 22, 25, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[122503, 3499, 880, 22, 25, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[123386, 3523, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[123722, 3534, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[123797, 3537, 287, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124087, 3545, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124411, 3554, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124689, 3562, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124972, 3570, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[125262, 3578, 301, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[125566, 3586, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}]},
  "rtoc0"->{
    Cell[64450, 1853, 72, 1, 54, "Subsection",
      CellTags->{"rtoc", "rtoc0"}],
    Cell[64525, 1856, 535, 10, 96, "Text",
      CellTags->{"rtoc", "rtoc0"}]},
  "rtoc1"->{
    Cell[65097, 1871, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[65169, 1874, 307, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[65479, 1882, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[65798, 1891, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66071, 1899, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66349, 1907, 284, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66636, 1915, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[66914, 1923, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[67193, 1931, 277, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[67473, 1939, 283, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[67759, 1947, 279, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68041, 1955, 280, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68324, 1963, 281, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68608, 1971, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}],
    Cell[68888, 1979, 294, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc1"}]},
  "rtoc2"->{
    Cell[69219, 1990, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[69291, 1993, 304, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[69598, 2001, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[69917, 2010, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[70190, 2018, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[70468, 2026, 278, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[70749, 2034, 273, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71025, 2042, 281, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71309, 2050, 284, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71596, 2058, 273, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[71872, 2066, 263, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[72138, 2074, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}],
    Cell[72418, 2082, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc2"}]},
  "rtoc3"->{
    Cell[72750, 2093, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[72822, 2096, 292, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73117, 2104, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73436, 2113, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73709, 2121, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[73987, 2129, 290, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[74280, 2137, 273, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[74556, 2145, 270, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[74829, 2153, 297, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}],
    Cell[75129, 2161, 294, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc3"}]},
  "rtoc4"->{
    Cell[75460, 2172, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[75532, 2175, 856, 21, 34, "ContentsSection",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[76391, 2198, 355, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[76749, 2207, 309, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[77061, 2215, 314, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[77378, 2223, 309, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[77690, 2231, 313, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[78006, 2239, 312, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}],
    Cell[78321, 2247, 334, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc4"}]},
  "rtoc5"->{
    Cell[78692, 2258, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[78764, 2261, 288, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79055, 2269, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79374, 2278, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79647, 2286, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[79925, 2294, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[80203, 2302, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[80482, 2310, 278, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[80763, 2318, 269, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81035, 2326, 268, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81306, 2334, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81589, 2342, 268, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[81860, 2350, 300, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[82163, 2358, 268, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[82434, 2366, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[82713, 2374, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}],
    Cell[83003, 2382, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc5"}]},
  "rtoc6"->{
    Cell[83335, 2393, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[83407, 2396, 286, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[83696, 2404, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84015, 2413, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84288, 2421, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84566, 2429, 288, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[84857, 2437, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[85136, 2445, 282, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[85421, 2453, 275, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc6"}],
    Cell[85699, 2461, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc6"}]},
  "rtoc7"->{
    Cell[86031, 2472, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86103, 2475, 298, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86404, 2483, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86723, 2492, 270, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[86996, 2500, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[87275, 2508, 306, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[87584, 2517, 319, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[87906, 2526, 1065, 27, 13, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[88974, 2555, 926, 24, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[89903, 2581, 1062, 26, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[90968, 2609, 937, 24, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[91908, 2635, 845, 21, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[92756, 2658, 929, 22, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[93688, 2682, 918, 24, 13, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[94609, 2708, 815, 20, 12, "Index",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[95427, 2730, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[95717, 2738, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[95997, 2746, 277, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}],
    Cell[96277, 2754, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc7"}]},
  "rtoc8"->{
    Cell[96609, 2765, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[96681, 2768, 284, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[96968, 2776, 316, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[97287, 2785, 271, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[97561, 2793, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[97840, 2801, 273, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[98116, 2809, 286, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[98405, 2817, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}],
    Cell[98695, 2825, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc8"}]},
  "rtoc9"->{
    Cell[99027, 2836, 69, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99099, 2839, 292, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99394, 2847, 317, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99714, 2856, 271, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[99988, 2864, 276, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[100267, 2872, 273, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[100543, 2880, 832, 22, 21, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[101378, 2904, 985, 26, 23, "Contents",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[102366, 2932, 295, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[102664, 2940, 301, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[102968, 2948, 308, 7, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[103279, 2957, 304, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[103586, 2965, 1343, 36, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[104932, 3003, 1346, 36, 16, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[106281, 3041, 1575, 42, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[107859, 3085, 905, 24, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[108767, 3111, 1155, 30, 15, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[109925, 3143, 279, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc9"}],
    Cell[110207, 3151, 295, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc9"}]},
  "rtoc10"->{
    Cell[110539, 3162, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[110614, 3165, 303, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[110920, 3173, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[111244, 3182, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[111522, 3190, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[111805, 3198, 286, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112094, 3206, 305, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112402, 3214, 301, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112706, 3222, 272, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[112981, 3230, 278, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[113262, 3238, 726, 18, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[113991, 3258, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[114269, 3266, 283, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}],
    Cell[114555, 3274, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc10"}]},
  "rtoc11"->{
    Cell[114891, 3285, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[114966, 3288, 300, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[115269, 3296, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[115593, 3305, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[115871, 3313, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[116154, 3321, 281, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[116438, 3329, 271, 6, 14, "Index",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[116712, 3337, 1039, 27, 21, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[117754, 3366, 303, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}],
    Cell[118060, 3374, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc11"}]},
  "rtoc12"->{
    Cell[118396, 3385, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[118471, 3388, 808, 20, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[119282, 3410, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[119606, 3419, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[119884, 3427, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[120167, 3435, 293, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[120463, 3443, 298, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[120764, 3451, 857, 22, 25, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[121624, 3475, 876, 22, 25, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[122503, 3499, 880, 22, 25, "Contents",
      CellTags->{"rtoc", "rtoc12"}],
    Cell[123386, 3523, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc12"}]},
  "rtoc13"->{
    Cell[123722, 3534, 72, 1, 28, "Subsection",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[123797, 3537, 287, 6, 36, "ContentsSection",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124087, 3545, 321, 7, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124411, 3554, 275, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124689, 3562, 280, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[124972, 3570, 287, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[125262, 3578, 301, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}],
    Cell[125566, 3586, 299, 6, 22, "Contents",
      CellTags->{"rtoc", "rtoc13"}]},
  "palintro"->{
    Cell[126141, 3609, 72, 1, 54, "Subsection",
      CellTags->"palintro"],
    Cell[126216, 3612, 556, 13, 121, "Text",
      CellTags->"palintro"]},
  "AbstractAlgebraPalette"->{
    Cell[126809, 3630, 81, 1, 28, "Subsection",
      CellTags->"AbstractAlgebraPalette"],
    Cell[126893, 3633, 693, 14, 78, "Text",
      CellTags->"AbstractAlgebraPalette"],
    Cell[127589, 3649, 2073, 31, 589, "Text",
      CellTags->"AbstractAlgebraPalette"]},
  "GroupoidsPalette"->{
    Cell[129699, 3685, 69, 1, 28, "Subsection",
      CellTags->"GroupoidsPalette"],
    Cell[129771, 3688, 400, 10, 30, "Text",
      CellTags->"GroupoidsPalette"]},
  "RingoidsPalette"->{
    Cell[130208, 3703, 81, 1, 54, "Subsection",
      CellTags->"RingoidsPalette"],
    Cell[130292, 3706, 435, 11, 46, "Text",
      CellTags->"RingoidsPalette"]},
  "GeneralPalette"->{
    Cell[130764, 3722, 81, 1, 28, "Subsection",
      CellTags->"GeneralPalette"],
    Cell[130848, 3725, 423, 11, 46, "Text",
      CellTags->"GeneralPalette"]},
  "GroupPalette"->{
    Cell[131308, 3741, 71, 1, 28, "Subsection",
      CellTags->"GroupPalette"],
    Cell[131382, 3744, 369, 10, 30, "Text",
      CellTags->"GroupPalette"]},
  "PermutationPalette"->{
    Cell[131788, 3759, 83, 1, 28, "Subsection",
      CellTags->"PermutationPalette"],
    Cell[131874, 3762, 392, 10, 30, "Text",
      CellTags->"PermutationPalette"]},
  "MorphismPalette"->{
    Cell[132303, 3777, 77, 1, 28, "Subsection",
      CellTags->"MorphismPalette"],
    Cell[132383, 3780, 378, 10, 30, "Text",
      CellTags->"MorphismPalette"]},
  "RingPalette"->{
    Cell[132798, 3795, 69, 1, 28, "Subsection",
      CellTags->"RingPalette"],
    Cell[132870, 3798, 363, 10, 30, "Text",
      CellTags->"RingPalette"]},
  "PolynomialPalette"->{
    Cell[133270, 3813, 82, 1, 28, "Subsection",
      CellTags->"PolynomialPalette"],
    Cell[133355, 3816, 405, 10, 30, "Text",
      CellTags->"PolynomialPalette"]},
  "MatrixPalette"->{
    Cell[133797, 3831, 74, 1, 28, "Subsection",
      CellTags->"MatrixPalette"],
    Cell[133874, 3834, 390, 10, 30, "Text",
      CellTags->"MatrixPalette"]},
  "GaloisPalette"->{
    Cell[134301, 3849, 80, 1, 28, "Subsection",
      CellTags->"GaloisPalette"],
    Cell[134384, 3852, 387, 10, 30, "Text",
      CellTags->"GaloisPalette"]},
  "ZdPalette"->{
    Cell[134808, 3867, 161, 6, 32, "Subsection",
      CellTags->"ZdPalette"],
    Cell[134972, 3875, 643, 18, 52, "Text",
      CellTags->"ZdPalette"]},
  "MultiPalette"->{
    Cell[135652, 3898, 97, 1, 28, "Subsection",
      CellTags->"MultiPalette"],
    Cell[135752, 3901, 793, 15, 160, "Text",
      CellTags->"MultiPalette"]},
  "AllPalette"->{
    Cell[136582, 3921, 83, 1, 28, "Subsection",
      CellTags->"AllPalette"],
    Cell[136668, 3924, 447, 11, 46, "Text",
      CellTags->"AllPalette"]},
  "GLab2Palette"->{
    Cell[137152, 3940, 70, 1, 28, "Subsection",
      CellTags->"GLab2Palette"],
    Cell[137225, 3943, 385, 10, 30, "Text",
      CellTags->"GLab2Palette"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"i:6", 139051, 3990},
  {"overview", 139147, 3993},
  {"grplb", 139520, 4004},
  {"gtoc", 139671, 4009},
  {"gtoc0", 151561, 4298},
  {"gtoc1", 151725, 4303},
  {"gtoc2", 153348, 4344},
  {"gtoc3", 154164, 4365},
  {"gtoc4", 154824, 4382},
  {"gtoc5", 155731, 4405},
  {"gtoc6", 156637, 4428},
  {"gtoc7", 157382, 4447},
  {"gtoc8", 158214, 4468},
  {"gtoc9", 159280, 4495},
  {"gtoc10", 159957, 4512},
  {"gtoc11", 160891, 4535},
  {"gtoc12", 161575, 4552},
  {"gtoc13", 162343, 4571},
  {"gtoc14", 163681, 4604},
  {"rnglb", 164677, 4629},
  {"rtoc", 164831, 4634},
  {"rtoc0", 178640, 4969},
  {"rtoc1", 178816, 4974},
  {"rtoc2", 180053, 5005},
  {"rtoc3", 181132, 5032},
  {"rtoc4", 181968, 5053},
  {"rtoc5", 182726, 5072},
  {"rtoc6", 184127, 5107},
  {"rtoc7", 184963, 5128},
  {"rtoc8", 186529, 5167},
  {"rtoc9", 187289, 5186},
  {"rtoc10", 188865, 5225},
  {"rtoc11", 190059, 5254},
  {"rtoc12", 190921, 5275},
  {"rtoc13", 191872, 5298},
  {"palintro", 192569, 5315},
  {"AbstractAlgebraPalette", 192751, 5320},
  {"GroupoidsPalette", 193043, 5327},
  {"RingoidsPalette", 193233, 5332},
  {"GeneralPalette", 193420, 5337},
  {"GroupPalette", 193603, 5342},
  {"PermutationPalette", 193788, 5347},
  {"MorphismPalette", 193982, 5352},
  {"RingPalette", 194166, 5357},
  {"PolynomialPalette", 194348, 5362},
  {"MatrixPalette", 194538, 5367},
  {"GaloisPalette", 194720, 5372},
  {"ZdPalette", 194898, 5377},
  {"MultiPalette", 195072, 5382},
  {"AllPalette", 195250, 5387},
  {"GLab2Palette", 195425, 5392}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 185, 7, 212, "Title"],

Cell[CellGroupData[{
Cell[1941, 62, 72, 1, 68, "Section",
  CellTags->{"i:6", "overview"}],
Cell[2016, 65, 1615, 31, 285, "Text",
  CellTags->"overview"],
Cell[3634, 98, 1557, 25, 286, "Text",
  CellTags->"overview"],
Cell[5194, 125, 408, 7, 90, "Text",
  CellTags->"overview"],
Cell[5605, 134, 277, 8, 58, "Text",
  CellTags->"overview"]
}, Closed]],

Cell[CellGroupData[{
Cell[5919, 147, 67, 1, 42, "Section",
  CellTags->"grplb"],
Cell[5989, 150, 6313, 193, 716, "Text",
  CellTags->"grplb"]
}, Closed]],

Cell[CellGroupData[{
Cell[12339, 348, 65, 1, 42, "Section",
  CellTags->"gtoc"],

Cell[CellGroupData[{
Cell[12429, 353, 62, 1, 54, "Subsection",
  CellTags->"gtoc0"],
Cell[12494, 356, 541, 10, 96, "Text",
  CellTags->{"gtoc", "gtoc0"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13072, 371, 60, 1, 54, "Subsection",
  CellTags->"gtoc1"],
Cell[13135, 374, 305, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc1"}],
Cell[13443, 382, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[13763, 391, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[14037, 399, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[14316, 407, 287, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[14606, 415, 295, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[14904, 423, 285, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[15192, 431, 289, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[15484, 439, 282, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[15769, 447, 296, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[16068, 455, 293, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[16364, 463, 298, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[16665, 471, 289, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[16957, 479, 276, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc1"}],
Cell[17236, 487, 283, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc1"}],
Cell[17522, 495, 271, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc1"}],
Cell[17796, 503, 270, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[18069, 511, 287, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}],
Cell[18359, 519, 297, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[18693, 530, 60, 1, 28, "Subsection",
  CellTags->"gtoc2"],
Cell[18756, 533, 318, 7, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc2"}],
Cell[19077, 542, 312, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc2"}],
Cell[19392, 551, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc2"}],
Cell[19666, 559, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc2"}],
Cell[19945, 567, 289, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc2"}],
Cell[20237, 575, 274, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc2"}],
Cell[20514, 583, 297, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc2"}],
Cell[20814, 591, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc2"}],
Cell[21088, 599, 295, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc2"}]
}, Closed]],

Cell[CellGroupData[{
Cell[21420, 610, 60, 1, 28, "Subsection",
  CellTags->"gtoc3"],
Cell[21483, 613, 288, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc3"}],
Cell[21774, 621, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc3"}],
Cell[22094, 630, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc3"}],
Cell[22368, 638, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc3"}],
Cell[22647, 646, 282, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc3"}],
Cell[22932, 654, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc3"}],
Cell[23206, 662, 295, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[23538, 673, 60, 1, 28, "Subsection",
  CellTags->"gtoc4"],
Cell[23601, 676, 303, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc4"}],
Cell[23907, 684, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[24227, 693, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[24501, 701, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[24780, 709, 725, 19, 20, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[25508, 730, 776, 20, 21, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[26287, 752, 281, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[26571, 760, 908, 23, 21, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[27482, 785, 719, 19, 21, "Contents",
  CellTags->{"gtoc", "gtoc4"}],
Cell[28204, 806, 296, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc4"}]
}, Closed]],

Cell[CellGroupData[{
Cell[28537, 817, 60, 1, 28, "Subsection",
  CellTags->"gtoc5"],
Cell[28600, 820, 306, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc5"}],
Cell[28909, 828, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[29229, 837, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[29503, 845, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[29782, 853, 285, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[30070, 861, 732, 19, 21, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[30805, 882, 894, 23, 21, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[31702, 907, 294, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[31999, 915, 710, 19, 21, "Contents",
  CellTags->{"gtoc", "gtoc5"}],
Cell[32712, 936, 296, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[33045, 947, 60, 1, 28, "Subsection",
  CellTags->"gtoc6"],
Cell[33108, 950, 298, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc6"}],
Cell[33409, 958, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc6"}],
Cell[33729, 967, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc6"}],
Cell[34003, 975, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc6"}],
Cell[34282, 983, 302, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc6"}],
Cell[34587, 991, 803, 21, 21, "Contents",
  CellTags->{"gtoc", "gtoc6"}],
Cell[35393, 1014, 523, 12, 22, "Contents",
  CellTags->{"gtoc", "gtoc6"}],
Cell[35919, 1028, 296, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc6"}]
}, Closed]],

Cell[CellGroupData[{
Cell[36252, 1039, 60, 1, 28, "Subsection",
  CellTags->"gtoc7"],
Cell[36315, 1042, 284, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc7"}],
Cell[36602, 1050, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[36922, 1059, 271, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[37196, 1067, 277, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[37476, 1075, 281, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[37760, 1083, 289, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[38052, 1091, 287, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[38342, 1099, 287, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}],
Cell[38632, 1107, 296, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc7"}]
}, Closed]],

Cell[CellGroupData[{
Cell[38965, 1118, 60, 1, 28, "Subsection",
  CellTags->"gtoc8"],
Cell[39028, 1121, 284, 6, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc8"}],
Cell[39315, 1129, 317, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}],
Cell[39635, 1138, 272, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}],
Cell[39910, 1146, 277, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}],
Cell[40190, 1154, 282, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}],
Cell[40475, 1162, 277, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}],
Cell[40755, 1170, 278, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}],
Cell[41036, 1178, 269, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc8"}],
Cell[41308, 1186, 270, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc8"}],
Cell[41581, 1194, 270, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc8"}],
Cell[41854, 1202, 270, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc8"}],
Cell[42127, 1210, 296, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc8"}]
}, Closed]],

Cell[CellGroupData[{
Cell[42460, 1221, 60, 1, 28, "Subsection",
  CellTags->"gtoc9"],
Cell[42523, 1224, 285, 6, 106, "ContentsSection",
  CellTags->{"gtoc", "gtoc9"}],
Cell[42811, 1232, 318, 7, 134, "Contents",
  CellTags->{"gtoc", "gtoc9"}],
Cell[43132, 1241, 272, 6, 106, "Contents",
  CellTags->{"gtoc", "gtoc9"}],
Cell[43407, 1249, 277, 6, 106, "Contents",
  CellTags->{"gtoc", "gtoc9"}],
Cell[43687, 1257, 797, 21, 414, "Contents",
  CellTags->{"gtoc", "gtoc9"}],
Cell[44487, 1280, 278, 6, 106, "Contents",
  CellTags->{"gtoc", "gtoc9"}],
Cell[44768, 1288, 296, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc9"}]
}, Closed]],

Cell[CellGroupData[{
Cell[45101, 1299, 63, 1, 28, "Subsection",
  CellTags->"gtoc10"],
Cell[45167, 1302, 291, 6, 106, "ContentsSection",
  CellTags->{"gtoc", "gtoc10"}],
Cell[45461, 1310, 322, 7, 148, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[45786, 1319, 276, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[46065, 1327, 281, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[46349, 1335, 288, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[46640, 1343, 302, 6, 134, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[46945, 1351, 313, 7, 134, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[47261, 1360, 310, 7, 134, "Index",
  CellTags->{"gtoc", "gtoc10"}],
Cell[47574, 1369, 734, 19, 400, "Contents",
  CellTags->{"gtoc", "gtoc10"}],
Cell[48311, 1390, 300, 6, 134, "Contents",
  CellTags->{"gtoc", "gtoc10"}]
}, Closed]],

Cell[CellGroupData[{
Cell[48648, 1401, 63, 1, 28, "Subsection",
  CellTags->"gtoc11"],
Cell[48714, 1404, 282, 6, 106, "ContentsSection",
  CellTags->{"gtoc", "gtoc11"}],
Cell[48999, 1412, 322, 7, 148, "Contents",
  CellTags->{"gtoc", "gtoc11"}],
Cell[49324, 1421, 276, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc11"}],
Cell[49603, 1429, 281, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc11"}],
Cell[49887, 1437, 285, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc11"}],
Cell[50175, 1445, 283, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc11"}],
Cell[50461, 1453, 300, 6, 134, "Contents",
  CellTags->{"gtoc", "gtoc11"}]
}, Closed]],

Cell[CellGroupData[{
Cell[50798, 1464, 63, 1, 28, "Subsection",
  CellTags->"gtoc12"],
Cell[50864, 1467, 303, 6, 120, "ContentsSection",
  CellTags->{"gtoc", "gtoc12"}],
Cell[51170, 1475, 322, 7, 148, "Contents",
  CellTags->{"gtoc", "gtoc12"}],
Cell[51495, 1484, 276, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc12"}],
Cell[51774, 1492, 281, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc12"}],
Cell[52058, 1500, 279, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc12"}],
Cell[52340, 1508, 281, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc12"}],
Cell[52624, 1516, 276, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc12"}],
Cell[52903, 1524, 300, 6, 134, "Contents",
  CellTags->{"gtoc", "gtoc12"}]
}, Closed]],

Cell[CellGroupData[{
Cell[53240, 1535, 63, 1, 28, "Subsection",
  CellTags->"gtoc13"],
Cell[53306, 1538, 295, 6, 120, "ContentsSection",
  CellTags->{"gtoc", "gtoc13"}],
Cell[53604, 1546, 322, 7, 148, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[53929, 1555, 276, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[54208, 1563, 281, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[54492, 1571, 292, 6, 134, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[54787, 1579, 283, 6, 120, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[55073, 1587, 275, 6, 120, "Index",
  CellTags->{"gtoc", "gtoc13"}],
Cell[55351, 1595, 274, 6, 120, "Index",
  CellTags->{"gtoc", "gtoc13"}],
Cell[55628, 1603, 310, 7, 134, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[55941, 1612, 283, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[56227, 1620, 293, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[56523, 1628, 274, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc13"}],
Cell[56800, 1636, 274, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc13"}],
Cell[57077, 1644, 308, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc13"}],
Cell[57388, 1652, 300, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc13"}]
}, Closed]],

Cell[CellGroupData[{
Cell[57725, 1663, 63, 1, 28, "Subsection",
  CellTags->"gtoc14"],
Cell[57791, 1666, 315, 7, 36, "ContentsSection",
  CellTags->{"gtoc", "gtoc14"}],
Cell[58109, 1675, 322, 7, 22, "Contents",
  CellTags->{"gtoc", "gtoc14"}],
Cell[58434, 1684, 276, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc14"}],
Cell[58713, 1692, 281, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc14"}],
Cell[58997, 1700, 288, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc14"}],
Cell[59288, 1708, 305, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc14"}],
Cell[59596, 1716, 293, 6, 14, "Index",
  CellTags->{"gtoc", "gtoc14"}],
Cell[59892, 1724, 314, 7, 14, "Index",
  CellTags->{"gtoc", "gtoc14"}],
Cell[60209, 1733, 321, 7, 14, "Index",
  CellTags->{"gtoc", "gtoc14"}],
Cell[60533, 1742, 280, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc14"}],
Cell[60816, 1750, 300, 6, 22, "Contents",
  CellTags->{"gtoc", "gtoc14"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[61165, 1762, 66, 1, 42, "Section",
  CellTags->"rnglb"],
Cell[61234, 1765, 3090, 78, 548, "Text",
  CellTags->"rnglb"]
}, Closed]],

Cell[CellGroupData[{
Cell[64361, 1848, 64, 1, 42, "Section",
  CellTags->"rtoc"],

Cell[CellGroupData[{
Cell[64450, 1853, 72, 1, 54, "Subsection",
  CellTags->{"rtoc", "rtoc0"}],
Cell[64525, 1856, 535, 10, 96, "Text",
  CellTags->{"rtoc", "rtoc0"}]
}, Closed]],

Cell[CellGroupData[{
Cell[65097, 1871, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc1"}],
Cell[65169, 1874, 307, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc1"}],
Cell[65479, 1882, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[65798, 1891, 270, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[66071, 1899, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[66349, 1907, 284, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[66636, 1915, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[66914, 1923, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[67193, 1931, 277, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc1"}],
Cell[67473, 1939, 283, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc1"}],
Cell[67759, 1947, 279, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc1"}],
Cell[68041, 1955, 280, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc1"}],
Cell[68324, 1963, 281, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc1"}],
Cell[68608, 1971, 277, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}],
Cell[68888, 1979, 294, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[69219, 1990, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc2"}],
Cell[69291, 1993, 304, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc2"}],
Cell[69598, 2001, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[69917, 2010, 270, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[70190, 2018, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[70468, 2026, 278, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[70749, 2034, 273, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc2"}],
Cell[71025, 2042, 281, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc2"}],
Cell[71309, 2050, 284, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc2"}],
Cell[71596, 2058, 273, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[71872, 2066, 263, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[72138, 2074, 277, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}],
Cell[72418, 2082, 295, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc2"}]
}, Closed]],

Cell[CellGroupData[{
Cell[72750, 2093, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc3"}],
Cell[72822, 2096, 292, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc3"}],
Cell[73117, 2104, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc3"}],
Cell[73436, 2113, 270, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc3"}],
Cell[73709, 2121, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc3"}],
Cell[73987, 2129, 290, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc3"}],
Cell[74280, 2137, 273, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc3"}],
Cell[74556, 2145, 270, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc3"}],
Cell[74829, 2153, 297, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc3"}],
Cell[75129, 2161, 294, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[75460, 2172, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc4"}],
Cell[75532, 2175, 856, 21, 34, "ContentsSection",
  CellTags->{"rtoc", "rtoc4"}],
Cell[76391, 2198, 355, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc4"}],
Cell[76749, 2207, 309, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc4"}],
Cell[77061, 2215, 314, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc4"}],
Cell[77378, 2223, 309, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc4"}],
Cell[77690, 2231, 313, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc4"}],
Cell[78006, 2239, 312, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc4"}],
Cell[78321, 2247, 334, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc4"}]
}, Closed]],

Cell[CellGroupData[{
Cell[78692, 2258, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc5"}],
Cell[78764, 2261, 288, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc5"}],
Cell[79055, 2269, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[79374, 2278, 270, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[79647, 2286, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[79925, 2294, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[80203, 2302, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[80482, 2310, 278, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[80763, 2318, 269, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc5"}],
Cell[81035, 2326, 268, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc5"}],
Cell[81306, 2334, 280, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[81589, 2342, 268, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc5"}],
Cell[81860, 2350, 300, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc5"}],
Cell[82163, 2358, 268, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc5"}],
Cell[82434, 2366, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[82713, 2374, 287, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}],
Cell[83003, 2382, 295, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[83335, 2393, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc6"}],
Cell[83407, 2396, 286, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc6"}],
Cell[83696, 2404, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc6"}],
Cell[84015, 2413, 270, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc6"}],
Cell[84288, 2421, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc6"}],
Cell[84566, 2429, 288, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc6"}],
Cell[84857, 2437, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc6"}],
Cell[85136, 2445, 282, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc6"}],
Cell[85421, 2453, 275, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc6"}],
Cell[85699, 2461, 295, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc6"}]
}, Closed]],

Cell[CellGroupData[{
Cell[86031, 2472, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc7"}],
Cell[86103, 2475, 298, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc7"}],
Cell[86404, 2483, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[86723, 2492, 270, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[86996, 2500, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[87275, 2508, 306, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[87584, 2517, 319, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[87906, 2526, 1065, 27, 13, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[88974, 2555, 926, 24, 12, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[89903, 2581, 1062, 26, 12, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[90968, 2609, 937, 24, 12, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[91908, 2635, 845, 21, 12, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[92756, 2658, 929, 22, 12, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[93688, 2682, 918, 24, 13, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[94609, 2708, 815, 20, 12, "Index",
  CellTags->{"rtoc", "rtoc7"}],
Cell[95427, 2730, 287, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[95717, 2738, 277, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[95997, 2746, 277, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}],
Cell[96277, 2754, 295, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc7"}]
}, Closed]],

Cell[CellGroupData[{
Cell[96609, 2765, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc8"}],
Cell[96681, 2768, 284, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc8"}],
Cell[96968, 2776, 316, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}],
Cell[97287, 2785, 271, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}],
Cell[97561, 2793, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}],
Cell[97840, 2801, 273, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}],
Cell[98116, 2809, 286, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}],
Cell[98405, 2817, 287, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}],
Cell[98695, 2825, 295, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc8"}]
}, Closed]],

Cell[CellGroupData[{
Cell[99027, 2836, 69, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc9"}],
Cell[99099, 2839, 292, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc9"}],
Cell[99394, 2847, 317, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc9"}],
Cell[99714, 2856, 271, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc9"}],
Cell[99988, 2864, 276, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc9"}],
Cell[100267, 2872, 273, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc9"}],
Cell[100543, 2880, 832, 22, 21, "Contents",
  CellTags->{"rtoc", "rtoc9"}],
Cell[101378, 2904, 985, 26, 23, "Contents",
  CellTags->{"rtoc", "rtoc9"}],
Cell[102366, 2932, 295, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[102664, 2940, 301, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[102968, 2948, 308, 7, 14, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[103279, 2957, 304, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[103586, 2965, 1343, 36, 15, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[104932, 3003, 1346, 36, 16, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[106281, 3041, 1575, 42, 15, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[107859, 3085, 905, 24, 15, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[108767, 3111, 1155, 30, 15, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[109925, 3143, 279, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc9"}],
Cell[110207, 3151, 295, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc9"}]
}, Closed]],

Cell[CellGroupData[{
Cell[110539, 3162, 72, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc10"}],
Cell[110614, 3165, 303, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc10"}],
Cell[110920, 3173, 321, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[111244, 3182, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[111522, 3190, 280, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[111805, 3198, 286, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[112094, 3206, 305, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[112402, 3214, 301, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[112706, 3222, 272, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc10"}],
Cell[112981, 3230, 278, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc10"}],
Cell[113262, 3238, 726, 18, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[113991, 3258, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[114269, 3266, 283, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}],
Cell[114555, 3274, 299, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc10"}]
}, Closed]],

Cell[CellGroupData[{
Cell[114891, 3285, 72, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc11"}],
Cell[114966, 3288, 300, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc11"}],
Cell[115269, 3296, 321, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc11"}],
Cell[115593, 3305, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc11"}],
Cell[115871, 3313, 280, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc11"}],
Cell[116154, 3321, 281, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc11"}],
Cell[116438, 3329, 271, 6, 14, "Index",
  CellTags->{"rtoc", "rtoc11"}],
Cell[116712, 3337, 1039, 27, 21, "Contents",
  CellTags->{"rtoc", "rtoc11"}],
Cell[117754, 3366, 303, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc11"}],
Cell[118060, 3374, 299, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc11"}]
}, Closed]],

Cell[CellGroupData[{
Cell[118396, 3385, 72, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc12"}],
Cell[118471, 3388, 808, 20, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc12"}],
Cell[119282, 3410, 321, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[119606, 3419, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[119884, 3427, 280, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[120167, 3435, 293, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[120463, 3443, 298, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[120764, 3451, 857, 22, 25, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[121624, 3475, 876, 22, 25, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[122503, 3499, 880, 22, 25, "Contents",
  CellTags->{"rtoc", "rtoc12"}],
Cell[123386, 3523, 299, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc12"}]
}, Closed]],

Cell[CellGroupData[{
Cell[123722, 3534, 72, 1, 28, "Subsection",
  CellTags->{"rtoc", "rtoc13"}],
Cell[123797, 3537, 287, 6, 36, "ContentsSection",
  CellTags->{"rtoc", "rtoc13"}],
Cell[124087, 3545, 321, 7, 22, "Contents",
  CellTags->{"rtoc", "rtoc13"}],
Cell[124411, 3554, 275, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc13"}],
Cell[124689, 3562, 280, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc13"}],
Cell[124972, 3570, 287, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc13"}],
Cell[125262, 3578, 301, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc13"}],
Cell[125566, 3586, 299, 6, 22, "Contents",
  CellTags->{"rtoc", "rtoc13"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[125914, 3598, 202, 7, 86, "Section"],

Cell[CellGroupData[{
Cell[126141, 3609, 72, 1, 54, "Subsection",
  CellTags->"palintro"],
Cell[126216, 3612, 556, 13, 121, "Text",
  CellTags->"palintro"]
}, Closed]],

Cell[CellGroupData[{
Cell[126809, 3630, 81, 1, 28, "Subsection",
  CellTags->"AbstractAlgebraPalette"],
Cell[126893, 3633, 693, 14, 78, "Text",
  CellTags->"AbstractAlgebraPalette"],
Cell[127589, 3649, 2073, 31, 589, "Text",
  CellTags->"AbstractAlgebraPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[129699, 3685, 69, 1, 28, "Subsection",
  CellTags->"GroupoidsPalette"],
Cell[129771, 3688, 400, 10, 30, "Text",
  CellTags->"GroupoidsPalette"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130208, 3703, 81, 1, 54, "Subsection",
  CellTags->"RingoidsPalette"],
Cell[130292, 3706, 435, 11, 46, "Text",
  CellTags->"RingoidsPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[130764, 3722, 81, 1, 28, "Subsection",
  CellTags->"GeneralPalette"],
Cell[130848, 3725, 423, 11, 46, "Text",
  CellTags->"GeneralPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[131308, 3741, 71, 1, 28, "Subsection",
  CellTags->"GroupPalette"],
Cell[131382, 3744, 369, 10, 30, "Text",
  CellTags->"GroupPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[131788, 3759, 83, 1, 28, "Subsection",
  CellTags->"PermutationPalette"],
Cell[131874, 3762, 392, 10, 30, "Text",
  CellTags->"PermutationPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[132303, 3777, 77, 1, 28, "Subsection",
  CellTags->"MorphismPalette"],
Cell[132383, 3780, 378, 10, 30, "Text",
  CellTags->"MorphismPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[132798, 3795, 69, 1, 28, "Subsection",
  CellTags->"RingPalette"],
Cell[132870, 3798, 363, 10, 30, "Text",
  CellTags->"RingPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[133270, 3813, 82, 1, 28, "Subsection",
  CellTags->"PolynomialPalette"],
Cell[133355, 3816, 405, 10, 30, "Text",
  CellTags->"PolynomialPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[133797, 3831, 74, 1, 28, "Subsection",
  CellTags->"MatrixPalette"],
Cell[133874, 3834, 390, 10, 30, "Text",
  CellTags->"MatrixPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[134301, 3849, 80, 1, 28, "Subsection",
  CellTags->"GaloisPalette"],
Cell[134384, 3852, 387, 10, 30, "Text",
  CellTags->"GaloisPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[134808, 3867, 161, 6, 32, "Subsection",
  CellTags->"ZdPalette"],
Cell[134972, 3875, 643, 18, 52, "Text",
  CellTags->"ZdPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[135652, 3898, 97, 1, 28, "Subsection",
  CellTags->"MultiPalette"],
Cell[135752, 3901, 793, 15, 160, "Text",
  CellTags->"MultiPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[136582, 3921, 83, 1, 28, "Subsection",
  CellTags->"AllPalette"],
Cell[136668, 3924, 447, 11, 46, "Text",
  CellTags->"AllPalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[137152, 3940, 70, 1, 28, "Subsection",
  CellTags->"GLab2Palette"],
Cell[137225, 3943, 385, 10, 30, "Text",
  CellTags->"GLab2Palette"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

