(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    558359,      13522]*)
(*NotebookOutlinePosition[    578022,      14083]*)
(*  CellTagsIndexPosition[    577400,      14057]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Chapter 1",
    FontSize->18],
  "\nIntroduction to ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"]
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True,
  CellTags->{"Intro", "Contents"}],

Cell[TextData[{
  "This guide is written with the assumption that the reader has at least \
minimal familiarity with groups, rings, and homomorphisms; consult an \
abstract algebra text for details of any unfamiliar algebraic concept. A \
bibliography in the Appendix contains some suggested references. The purpose \
of this guide is to provide details for (and illustrations of) many of the \
structures and functions used in the packages in ",
  StyleBox["AbstractAlgebra", "MR"],
  ". Many of these structures and functions are also used in the laboratory \
notebooks in ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  ". You may wish to consult the web page ",
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  " for updates to this guide, updates to the packages, as well as other \
related resources. This web site is also mirrored at ",
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Intro", "i:1"}],

Cell["1.0 Read me first", "Subsection",
  CellTags->"First"],

Cell[TextData[{
  "To evaluate any of the ",
  StyleBox["Input", "MR"],
  " cells in this chapter, the following cell should be evaluated first."
}], "Text",
  CellTags->"First"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Master`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"First"],

Cell["\<\
In this chapter we primarily focus on groups, so we indicate this \
default structure as follows.\
\>", "Text",
  CellTags->"First"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Group]\)], "Input",
  CellLabel->"In[2]:=",
  GeneratedCell->True,
  CellTags->"First"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"First"]
}, Open  ]],

Cell[TextData[{
  "1.1 Packages in ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"]
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[TextData[{
  "Typically, to use a function from ",
  StyleBox["AbstractAlgebra", "MR"],
  ", the ",
  StyleBox["Master", "MR"],
  " package needs to be evaluated. This loads all the ",
  StyleBox["names",
    FontSlant->"Italic"],
  " of the functions that are found in the packages and is done as follows."
}], "Text",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Master`\>"]\)], "Input",
  CellLabel->"In[3]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[TextData[{
  "Reading in the ",
  StyleBox["Master", "MR"],
  " package causes all the names in all the packages to be recognized. When a \
particular function is used, the appropriate package is then called. For \
example, if we want to know the orders of the elements in the dihedral group \
",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  ", we provide as input ",
  StyleBox["Orders[Dihedral[3]]", "MR"],
  "."
}], "Text",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orders[Dihedral[3]]\)], "Input",
  CellLabel->"In[4]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[BoxData[
    \({{1, 1}, {Rot, 3}, {Rot\^2, 3}, {Ref, 2}, {Rot**Ref, 2}, {Rot\^2**Ref, 
        2}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Packages"]
}, Open  ]],

Cell[TextData[{
  "The function to form the dihedral group ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  " is found in the ",
  StyleBox["Groupoids", "MR"],
  " package, while the function to calculate the orders is found in the ",
  StyleBox["GroupProperties", "MR"],
  " package. They both call the ",
  StyleBox["Core", "MR"],
  " package (as well as several standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages). This is all intended to be transparent to the user. The \
packages are organized to minimize the amount of code that needs to be read \
in and retained in memory. Consequently, this guide follows the ",
  StyleBox["logical",
    FontSlant->"Italic"],
  " structure, not the ",
  StyleBox["physical",
    FontSlant->"Italic"],
  " structure, of the packages. For those interested, however, the following \
describes the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages included in ",
  StyleBox["AbstractAlgebra", "MR"],
  ", including dependencies; by reading in any one of these packages, the \
packages on which it depends are called automatically."
}], "Text",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox["Core",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(basic\ collection\ of\ functions\ that\ are\ used\ throughout
                \ the\ other\ packages\ \),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["FiniteFields",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[\(functions\ to\ work\ with\ finite\ fields, \ 
                constructed\ as\ \(quotient\ \)\),
                SingleLetterItalics->False], 
              StyleBox["rings",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    RowBox[{\(\[DoubleStruckCapitalZ]\_n\), "[", 
                      StyleBox["x",
                        FontSlant->"Italic"], "]"}], "/", 
                    RowBox[{"\[LeftAngleBracket]", 
                      StyleBox[\(p(x)\),
                        FontSlant->"Italic"], "\[RightAngleBracket]"}]}],
                  "TraditionalForm"],
                "Text"], 
              StyleBox["\[LongDash]calls",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["RingExtensions",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox["Groupoids",
              "MR"], 
            RowBox[{"built\[Hyphen]in", " ", 
              StyleBox[
                RowBox[{"groupoids", 
                  StyleBox["\[LongDash]",
                    SingleLetterItalics->False], "calls"}]], " ", 
              StyleBox["Core",
                "MR"]}]},
          {
            StyleBox[
              FormBox["GroupProperties",
                "StandardForm"],
              "Text"], 
            RowBox[{
            "functions", " ", "to", " ", "work", " ", "specifically", " ", 
              "with", " ", 
              StyleBox[
                RowBox[{"groups", 
                  StyleBox["\[LongDash]",
                    SingleLetterItalics->False], "calls"}]], " ", 
              StyleBox["Core",
                "MR"]}]},
          {
            StyleBox[
              FormBox["Joint",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["functions",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["useful",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["both",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groups",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rings\[LongDash]calls",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Core",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox[
                StyleBox[
                  FormBox["LabCode",
                    "StandardForm"],
                  "Text"],
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[
                \(specialized\ functions\ that\ are\ used\ only\ in\ the\ 
                  group\ and\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["ring",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["labs",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Exploring",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["Abstract",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["Algebra",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["with",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{
                    StyleBox["Mathematica",
                      FontSlant->"Italic"], 
                    StyleBox["\[LongDash]",
                      SingleLetterItalics->False]}]]}], "\n", 
              RowBox[{
                RowBox[{"calls", " ", 
                  StyleBox["GroupProperties",
                    "MR"]}], ",", " ", 
                StyleBox["Groupoids",
                  "MR"], ",", " ", 
                RowBox[{"and", " ", 
                  StyleBox["Joint",
                    "MR"]}]}]}]},
          {
            StyleBox[
              FormBox["Matrices",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[
                \(functions\ to\ work\ with\ matrices\ over\ both\ standard\ 
                  rings\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \((\[DoubleStruckCapitalZ], \ \[DoubleStruckCapitalQ], \ 
                  \[DoubleStruckCapitalR], \ and\ \[DoubleStruckCapitalC])\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["arbitrary",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rings\[LongDash]calls",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["RingExtensions",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox["Morphisms",
              "MR"], 
            RowBox[{
              StyleBox["functions",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["work",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["homomorphisms",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["between",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groups",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rings\[LongDash]calls",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Joint",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["GroupProperties",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox["Permutations",
              "MR"], 
            RowBox[{
            \(functions\ to\ work\ with\ permutations\), ",", " ", "cycles", 
              ",", " ", 
              RowBox[{"and", " ", "permutation", " ", 
                StyleBox[
                  RowBox[{"groups", 
                    StyleBox["\[LongDash]",
                      SingleLetterItalics->False], "calls"}]], " ", 
                StyleBox["Core",
                  "MR"]}]}]},
          {
            StyleBox["RingExtensions",
              "MR"], 
            RowBox[{
            \(functions\ to\ work\ with\ ring\ extensions, \ including\), 
              " ", "polynomials", " ", "and", " ", "functions", " ", "over", 
              " ", "a", " ", 
              StyleBox[
                RowBox[{"ring", 
                  StyleBox["\[LongDash]",
                    SingleLetterItalics->False], "calls"}]], " ", 
              StyleBox["RingProperties",
                "MR"]}]},
          {
            StyleBox["Ringoids",
              "MR"], 
            RowBox[{"built\[Hyphen]in", " ", 
              StyleBox[
                RowBox[{"ringoids", 
                  StyleBox["\[LongDash]",
                    SingleLetterItalics->False], "calls"}]], " ", 
              StyleBox["Core",
                "MR"]}]},
          {
            StyleBox["RingProperties",
              "MR"], 
            RowBox[{
              StyleBox["functions",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["work",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["specifically",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rings\[LongDash]calls",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Joint",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox["Zd",
              "MR"], 
            RowBox[{
            "functions", " ", "to", " ", "work", " ", "with", " ", 
              "divisibility\[Hyphen]related", " ", "issues", " ", "in", " ", 
              RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                SqrtBox[
                  StyleBox["d",
                    FontSlant->"Italic"]], "]"}], 
              StyleBox[
                RowBox[{
                  StyleBox["\[LongDash]",
                    SingleLetterItalics->False], "calls"}]], " ", 
              StyleBox["Core",
                "MR"]}]}
          }], NotebookDefault]], "DefinitionBox",
  ShowGroupOpenCloseIcon->True,
  GridBoxOptions->{ColumnWidths->{0.26, 0.74}},
  CellTags->{"Packages", "i:3"}],

Cell[TextData[{
  "Packages in the ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " directory."
}], "Caption",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[TextData[{
  "Although loading the ",
  StyleBox["Master", "MR"],
  " package is recommended, and this guide assumes that it is loaded, \
individual packages can be loaded and their specific functions used."
}], "Text",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[TextData[{
  "Suppose we want to load the ",
  StyleBox["Zd", "MR"],
  " package."
}], "MathCaption",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Zd`\>"]\)], "Input",
  CellLabel->"In[5]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell["\<\
To obtain the list of names in this package, evaluate the \
following.\
\>", "MathCaption",
  ShowGroupOpenCloseIcon->True,
  CellTags->{"Packages", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Names["\<AbstractAlgebra`Zd`*\>"]\)], "Input",
  CellLabel->"In[6]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[BoxData[
    \({"Associates", "Combine", "DividesQ", "DivisorsComplete", 
      "IntegerDivisors", "Negations", "NonTrivialOnly", "Products", 
      "Radical", "ValuesHavingGivenNorm", "ZdAssociatesQ", 
      "ZdCombineAssociates", "ZdConjugate", "ZdDivide", "ZdDividesQ", 
      "ZdDivisors", "ZdIrreducibleQ", "ZdNorm", "ZdPossibleNormQ", 
      "ZdPossibleNorms", "ZdQ", "ZdUnitQ"}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Packages"]
}, Open  ]],

Cell[TextData[{
  "To learn about the ",
  StyleBox["ZdDivisors", "MR"],
  " function, use the ? approach (or, of course, read the pertinent portion \
of this documentation)."
}], "MathCaption",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ZdDivisors\)\)], "Input",
  CellLabel->"In[7]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"Packages"],

Cell[BoxData[
    \("ZdDivisors[d, x, (opts)], when d is negative, returns all the divisors \
of the number x in Z[Sqrt[d]]. When d is positive, ZdDivisors[d, x, max] \
returns all divisors of x in Z[Sqrt[d]] whose norm is less than or equal to \
the norm of the integer max. Available options are Combine, NonTrivialOnly, \
and DivisorsComplete. See them for more details."\)], "Print",
  CellTags->"Packages"]
}, Open  ]],

Cell[TextData[{
  "1.2 Basic structures used in ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Structures"],

Cell["1.2.1 Overview", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Structures"],

Cell[TextData[{
  StyleBox["The goal of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is to provide an environment for working with groups, rings, fields, and \
homomorphisms. The fundamental structures are called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoids", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox[
  "These structures need not necessarily represent bona fide groups, rings, \
or morphisms. A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" consists of a set (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["List", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[") of elements followed by an operation, whereas a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" consists of a set of elements followed by two operations. A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " consists of a function (or list of rules) followed by the domain and \
codomain, which are either both groupoids or both ringoids. In this guide, we \
use the term ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " when referring to the mathematical structure consisting of a set and an \
operation and use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" when we refer to the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " structure that embodies the mathematical groupoid. We make a similar \
distinction between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["; the mathematical underpinnings for a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " is simply a function between two groupoids or two ringoids. Note that the \
operations in a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " need not be binary operations in the usual mathematical sense (where \
given a pair of inputs from a set, the image also is required to belong to \
the set).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  CellTags->{"Structures", "i:5"}],

Cell[TextData[{
  StyleBox[
  "For an example of a groupoid, consider the set {2, 3, 4} and the built-in \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" operator ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Plus", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[", which performs addition.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "MathCaption",
  Evaluatable->False,
  CellTags->{"Structures", "i:6"}],

Cell[CellGroupData[{

Cell["G = Groupoid[{2, 3, 4}, Plus]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"Structures"],

Cell[BoxData[
    \(Groupoid[{2, 3, 4}, Plus]\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"Structures"]
}, Open  ]],

Cell[TextData[{
  "This structure, defined as ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", constitutes a groupoid, although it clearly does not form a group. Also, \
",
  StyleBox["Plus", "MR"],
  " is not a binary operation (over this set) in the normal sense of the \
word, since ",
  Cell[BoxData[
      \(TraditionalForm\`2\  + \ 3\  = \ 5\)]],
  " and 5 is not a member of the underlying set {2, 3, 4}."
}], "Text",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[TextData[{
  "Similarly, we can form a ringoid as follows. Again, the operations in a ",
  StyleBox["Ringoid", "MR"],
  " do not need to be binary operations in the normal sense, as illustrated \
here."
}], "MathCaption",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[CellGroupData[{

Cell["R = Ringoid[{2, 3, 4}, Plus, Times]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"Structures"],

Cell[BoxData[
    \(Ringoid[{2, 3, 4}, Plus, Times]\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"Structures"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Consider the function from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  StyleBox[" by sending ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\ mod\ 6\)]],
  StyleBox[". Here is an example of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" based on this function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "MathCaption",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[CellGroupData[{

Cell["f = Morphoid[Mod[#, 6]&, Z[12], Z[6]]", "Input",
  CellLabel->"In[10]:=",
  CellTags->"Structures"],

Cell[BoxData[
    \(Morphoid[Mod[#1, 6]&, 
      Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, Mod[#1 + #2, 12]&], 
      Groupoid[{0, 1, 2, 3, 4, 5}, Mod[#1 + #2, 6]&]]\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"Structures"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Note that this returns a structure of type ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " and three arguments consisting of the function and the two groups. (We \
could have made this a ring morphism by indicating that we intended ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  StyleBox[" to be ringoids.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[TextData[{
  "A better (and strongly recommended) mechanism to form either a ",
  StyleBox["Groupoid", "MR"],
  ", a",
  " ",
  StyleBox["Ringoid", "MR"],
  " or a ",
  StyleBox["Morphoid", "MR"],
  " is given in section 1.2.2."
}], "Text",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[TextData[{
  "1.2.2 How to form ",
  StyleBox["Groupoids",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Ringoids",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Morphoids",
    FontFamily->"Courier"]
}], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"i:7", "Form"}],

Cell[TextData[{
  "In section 1.2.1 we formed the ",
  StyleBox["Groupoid", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->{"i:8", "Form"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(G = Groupoid[{2, 3, 4}, Plus]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Groupoid[{2, 3, 4}, Plus]\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "The recommended method is to use the ",
  StyleBox["FormGroupoid", "MR"],
  " function as follows."
}], "Text",
  Evaluatable->False,
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G = FormGroupoid[{2, 3, 4}, Plus]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Groupoid[{2, 3, 4}, "-Operation-"]\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Although the output is often the same (though not quite, in this case), \
there are some internal steps that are taken when the ",
  StyleBox["FormGroupoid", "MR"],
  " function is called that may later prove useful. Additionally, one can add \
options to the ",
  StyleBox["FormGroupoid", "MR"],
  " function that provide information about the groupoid being formed. The \
syntax for the ",
  StyleBox["FormGroupoid", "MR"],
  " function requires the first parameter to be a list of elements and the \
second parameter to be the (binary) operation used. An optional third \
parameter indicates the symbol used to represent the operation; the default \
value is *, if none is given. After these parameters, a variety of options \
can be added, as indicated in what follows."
}], "Text",
  Evaluatable->False,
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FormGroupoid\)\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"Form"],

Cell[BoxData[
    \("FormGroupoid[els, op, opsym, opts] is the basic command for forming a \
Groupoid consisting of the list els governed by the operation op. The symbol \
opsym defaults to '*' if not specified. The available options for opts are \
WideElements, IsAGroup, Generators, GroupoidDescription, GroupoidName, \
FormatOperator, FormatElements, MaxElementsToList, KeyForm, and CayleyForm. \
See each one for more information. \n\nThis function, rather than just \
wrapping Groupoid around a list and an operation, is strongly \
recommended."\)], "Print",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Each of the options for ",
  StyleBox["FormGroupoid", "MR"],
  " has default values in these packages, but any of them can be overridden \
with other values, or other default values can be defined. Although we \
discuss in detail the options and illustrate how they are used in ",
  ButtonBox["chapter 2",
    ButtonData:>{"FormGroupoid", "FormGroupoid"},
    ButtonStyle->"AddOnsLink"],
  ", we now briefly illustrate the use of a few of these options."
}], "Text",
  Evaluatable->False,
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[FormGroupoid]\)], "Input",
  CellLabel->"In[14]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \({CayleyForm \[Rule] OutputForm, FormatElements \[Rule] False, 
      FormatOperator \[Rule] True, Generators \[Rule] {}, 
      GroupoidDescription \[Rule] "", GroupoidName \[Rule] "TheGroup", 
      IsAGroup \[Rule] False, KeyForm \[Rule] InputForm, 
      MaxElementsToList \[Rule] 50, WideElements \[Rule] False}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Suppose we want to define the group of integers mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", the group denoted ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalZ]\_n . \)\)]],
  " It is already built into the packages, defined under the name ",
  StyleBox["Z", "MR"],
  "; here we call our new version ",
  StyleBox["newZ", "MR"],
  ". This is how we might define it."
}], "MathCaption",
  CellTags->"Form"],

Cell[BoxData[
    \(newZ[n_Integer?Positive]\  := \n\t\t
      FormGroupoid[Range[0, n - 1], \ Mod[#1\  + \ #2, n]&, "\<+\>", 
        IsAGroup\  \[Rule] \ True, \ FormatOperator\  \[Rule] False, \ 
        Generators\  \[Rule] \ {1}, \n\t
        GroupoidDescription\  \[Rule] \ "\<Integers under addition mod n\>", 
        GroupoidName\  \[Rule] StringJoin["\<Z[\>", ToString[n], "\<]\>"]]
        \)], "Input",
  CellLabel->"In[15]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[TextData[{
  "To form ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalZ]\_5, \)\)]],
  " we could use the following."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = \ newZ[5]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Since ",
  StyleBox["FormatOperator", "MR"],
  " is set to ",
  StyleBox["False", "MR"],
  ", the binary operator ",
  StyleBox["Mod[#1 + #2, 5]&", "MR"],
  " is given, instead of hiding behind ",
  StyleBox["-Operation-", "MR"],
  ", as seen earlier. The ",
  StyleBox["IsAGroup", "MR"],
  " option indicates that any tests to see if it is a group can be skipped \
and ",
  StyleBox["True", "MR"],
  " will be immediately returned by ",
  StyleBox["GroupQ", "MR"],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupQ[G]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "The value of the option ",
  StyleBox["GroupoidName", "MR"],
  " shows up when we view a Cayley table."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[G, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"Form"],

Cell[BoxData[
    \("For each element, a different color is used. The entries in the table \
corresponding to the elements are then colored and labeled accordingly."\)], 
  "Print",
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 0 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
.81746 .50198 m
.81746 .66071 L
.97619 .66071 L
.97619 .50198 L
F
.65873 .34325 m
.65873 .50198 L
.81746 .50198 L
.81746 .34325 L
F
.5 .18452 m
.5 .34325 L
.65873 .34325 L
.65873 .18452 L
F
.34127 .02579 m
.34127 .18452 L
.5 .18452 L
.5 .02579 L
F
1 .5 0 r
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.81746 .34325 m
.81746 .50198 L
.97619 .50198 L
.97619 .34325 L
F
.65873 .18452 m
.65873 .34325 L
.81746 .34325 L
.81746 .18452 L
F
.5 .02579 m
.5 .18452 L
.65873 .18452 L
.65873 .02579 L
F
.56 .37 .6 r
.5 .66071 m
.5 .81944 L
.65873 .81944 L
.65873 .66071 L
F
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
.18254 .34325 m
.18254 .50198 L
.34127 .50198 L
.34127 .34325 L
F
.81746 .18452 m
.81746 .34325 L
.97619 .34325 L
.97619 .18452 L
F
.65873 .02579 m
.65873 .18452 L
.81746 .18452 L
.81746 .02579 L
F
0 0 1 r
.65873 .66071 m
.65873 .81944 L
.81746 .81944 L
.81746 .66071 L
F
.5 .50198 m
.5 .66071 L
.65873 .66071 L
.65873 .50198 L
F
.34127 .34325 m
.34127 .50198 L
.5 .50198 L
.5 .34325 L
F
.18254 .18452 m
.18254 .34325 L
.34127 .34325 L
.34127 .18452 L
F
.81746 .02579 m
.81746 .18452 L
.97619 .18452 L
.97619 .02579 L
F
.74 .99 .79 r
.81746 .66071 m
.81746 .81944 L
.97619 .81944 L
.97619 .66071 L
F
.65873 .50198 m
.65873 .66071 L
.81746 .66071 L
.81746 .50198 L
F
.5 .34325 m
.5 .50198 L
.65873 .50198 L
.65873 .34325 L
F
.34127 .18452 m
.34127 .34325 L
.5 .34325 L
.5 .18452 L
F
.18254 .02579 m
.18254 .18452 L
.34127 .18452 L
.34127 .02579 L
F
1 1 0 r
.18254 .81944 m
.18254 .97817 L
.34127 .97817 L
.34127 .81944 L
F
1 .5 0 r
.34127 .81944 m
.34127 .97817 L
.5 .97817 L
.5 .81944 L
F
.56 .37 .6 r
.5 .81944 m
.5 .97817 L
.65873 .97817 L
.65873 .81944 L
F
0 0 1 r
.65873 .81944 m
.65873 .97817 L
.81746 .97817 L
.81746 .81944 L
F
.74 .99 .79 r
.81746 .81944 m
.81746 .97817 L
.97619 .97817 L
.97619 .81944 L
F
1 1 0 r
.02381 .66071 m
.02381 .81944 L
.18254 .81944 L
.18254 .66071 L
F
1 .5 0 r
.02381 .50198 m
.02381 .66071 L
.18254 .66071 L
.18254 .50198 L
F
.56 .37 .6 r
.02381 .34325 m
.02381 .50198 L
.18254 .50198 L
.18254 .34325 L
F
0 0 1 r
.02381 .18452 m
.02381 .34325 L
.18254 .34325 L
.18254 .18452 L
F
.74 .99 .79 r
.02381 .02579 m
.02381 .18452 L
.18254 .18452 L
.18254 .02579 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
[(0)] .2619 .74008 0 0 Mshowa
[(1)] .42063 .74008 0 0 Mshowa
[(2)] .57937 .74008 0 0 Mshowa
[(3)] .7381 .74008 0 0 Mshowa
[(4)] .89683 .74008 0 0 Mshowa
[(1)] .2619 .58135 0 0 Mshowa
[(2)] .42063 .58135 0 0 Mshowa
[(3)] .57937 .58135 0 0 Mshowa
[(4)] .7381 .58135 0 0 Mshowa
[(0)] .89683 .58135 0 0 Mshowa
[(2)] .2619 .42262 0 0 Mshowa
[(3)] .42063 .42262 0 0 Mshowa
[(4)] .57937 .42262 0 0 Mshowa
[(0)] .7381 .42262 0 0 Mshowa
[(1)] .89683 .42262 0 0 Mshowa
[(3)] .2619 .26389 0 0 Mshowa
[(4)] .42063 .26389 0 0 Mshowa
[(0)] .57937 .26389 0 0 Mshowa
[(1)] .7381 .26389 0 0 Mshowa
[(2)] .89683 .26389 0 0 Mshowa
[(4)] .2619 .10516 0 0 Mshowa
[(0)] .42063 .10516 0 0 Mshowa
[(1)] .57937 .10516 0 0 Mshowa
[(2)] .7381 .10516 0 0 Mshowa
[(3)] .89683 .10516 0 0 Mshowa
[(0)] .10317 .74008 0 0 Mshowa
[(1)] .10317 .58135 0 0 Mshowa
[(2)] .10317 .42262 0 0 Mshowa
[(3)] .10317 .26389 0 0 Mshowa
[(4)] .10317 .10516 0 0 Mshowa
[(0)] .2619 .89881 0 0 Mshowa
[(1)] .42063 .89881 0 0 Mshowa
[(2)] .57937 .89881 0 0 Mshowa
[(3)] .7381 .89881 0 0 Mshowa
[(4)] .89683 .89881 0 0 Mshowa
[(Z[5])] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[18]:=",
  ImageSize->{265.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P0000H0oOl600001P00:Ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C00;o02X34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0olYg`1E
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@003o`0000@00006000Yomh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?NobWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U000?o0000100000H002Wo0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`02o`0Z0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`?o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D000ol0
000400001P00:OoN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o02[N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lYg`1EoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lo`0Y@003o`0000@00006000Yo`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<00_l0:P<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3obWO05GoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH;o02U000?o0000100000H002WogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0`02o`0ZgP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mko:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D000ol0000400001P00:Ol34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C00;o02X34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0olYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@003o`0000@0
0006000Yomh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?NobWO05GoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_co02U000?o0000100000H002Wo0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`02o`0Z0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o:Ml0EOnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aP_l0:D000ol0000400001P00:OoN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh300;o02[N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
g_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@003o`0000@00006000Yo`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<00_l0:P<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<3obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U000?o0000100000H0
02WogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0`02o`0ZgP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0
:D000ol0000400001P00:Ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C00;o
02X34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0olYg`1EoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62o`0Y@003o`0000@00006000Yomh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?NobWO
05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U000?o0000100000H002Wo0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`02o`0Z0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`?o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D000ol0000400001P00:OoN
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o02[N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@003
o`0000@00006000Yo`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<00_l0:P<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3obWO05GoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH;o02U000?o0000100000H002WogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0`02o`0ZgP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko:Ml0EOnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D000ol0000400001P005?l34`<C0a<34`<C0a<34`<C0a<3
0ol04P<C0a<34`<C0a<34`<C0a<34`;o01<34`<C0a<34`<C0a<34`<C0a<300?o01@34`<C0a<34`<C
0a<34`<C0a<3oa?O0_lDg`0CoimOWenOGimOWenOGimOWenOG`03o`0WGimOWenOGimOWenOGimOWenO
GiooPW62LH9aPW62LH9aPW62LH9a00Co01B2LH9aPW62LH9aPW62LH9aPW62oa900olD@003o`0000@0
0006000Yomh3gP?N0mh3gP?N0mh3gP?N0mh3o`?N0mh3gP?N0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3
gP?N0mh3gP?N0mh3o`?N0mh3gP?N0mh3gP?N0mh3gP?Noa;O00Cogmoo4ml0EOnOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;loob2o8;lP_b2o8;l
P_b2o8;lP_b2o?l05D000om0@00A@003o`0000@00006000Co`<C0a<34`<C0a<34`<C0a<34`04o`0B
0a<34`<C0a<34`<C0a<34`<C0_l04P<C0a<34`<C0a<34`<C0a<34`Co01@34`<C0a<34`<C0a<34`<C
0a<3oa;O00Cogmoo4ml0EOnOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWon2
LH9aPW62LH9aPW62LH9aPW62LOmaPW62LH9aPW62LH9aPW62LH9aP_l05D000om0@00A@003o`0000@0
0006000Yomh3gP?N0mh3gP?N0mh3gP?N0ol3o`?N0mh3gP?N0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3
gP?N0mh3gP?N0ol3o`?N0mh3gP?N0mh3gP?N0mh3gP?Noa;O00Cogmoo4ml0EOnOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_coo8;lP_b2o8;l
P_b2o8;lP_b2o?l04d02oaA000?o0000100000H002Wo0a<34`<C0a<34`<C0a<34`<Coa?o4`<C0a<3
4`<C0a<34`<C0a<34`02o`0Z0a<34`<C0a<34`<C0a<34`<Coa?o4`<C0a<34`<C0a<34`<C0a<34`?o
4]l01?oOgolCg`1EoimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOoh9aPW62
LH9aPW62LH9aPW62LOmaP_n2LH9aPW62LH9aPW62LH9aPW62o`0E@003od10015000?o0000100000H0
01CogP?N0mh3gP?N0mh3gP?N0mh3gP;o01<3gP?N0mh3gP?N0mh3gP?N0mh300;o01?N0mh3gP?N0mh3
gP?N0mh3gP?N00;o01D3gP?N0mh3gP?N0mh3gP?N0mh3g_l04ml2oaCO01?oWenOGimOWenOGimOWenO
GimO00;o02VOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o002o`0EP_b2o8;l
P_b2o8;lP_b2o8;lP_co01900olD@003o`0000@00006000Yo`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<00_l0:P<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<3obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U000?o0000100000H002WogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0`02o`0ZgP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mko:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D000ol000040000
1P00:Ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C00;o02X34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0olYg`1EoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
o`0Y@003o`0000@00006000Yomh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<0
0_l0:]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?NobWO05GoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_co02U000?o0000100000H002Wo0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`02o`0Z0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o
:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D000ol0000400001P00:OoN0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o02[N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3g_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@003o`0000@00006000Y
o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<00_l0:P<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U0
00?o0000100000H002WogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0`02o`0Z
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko:Ml0EOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o?l0:D000ol0000400001P00:Ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C00;o02X34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0olYg`1E
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@003o`0000@00006000Yomh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?NobWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U000?o0000100000H002Wo0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`02o`0Z0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`?o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D000ol0
000400001P00:OoN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o02[N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lYg`1EoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lo`0Y@003o`0000@00006000Yo`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<00_l0:P<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3obWO05GoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH;o02U000?o0000100000H002WogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0`02o`0ZgP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mko:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D000ol0000400001P00:Ol34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C00;o02X34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0olYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@003o`0000@0
0006000Yomh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0:]h3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?NobWO05GoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_co02U000?o0000100000H002Wo0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`02o`0Z0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o:Ml0EOnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aP_l0:D000ol0000400001P3mo`H000060003od1002I00_lY@00[o`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`1EoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62o`0600001P000om0@00V@0;o:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3g_l0:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWool
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l01P0000H000?o@4009T02obU0
02_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO05GoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH;o00H000060003od1002I00_lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0600001P000om0
@00V@0;o:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml0EOnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aP_l01P0000H000?o@4009T02obU002_ogP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00H0
00060003od1002I00_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
o`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0600001P000om0@00V@0;o:D00:ooN0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0:Ml0EOnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o?l01P0000H000?o@4009T02obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`?o02WO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00H000060003od1002I00_lY@00[
omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`1EoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lo`0600001P000om0@00V@0;o:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0ol0:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l01P0000H000?o@400
9T02obU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO05GoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_co00H000060003od1002I00_lY@00[o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`060000
1P000om0@00V@0;o:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0
:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l01P0000H000?o@4009T02obU002_o0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO05GoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH;o00H000060003od1002I00_lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?No`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0600001P000om0@00V@0;o:D00:ol3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml0EOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aP_l01P0000H000?o@4009T02obU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mko02WO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Giooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00H000060003od100110
0olC@0;o4T03oaA001Co0a<34`<C0a<34`<C0a<34`<C0`?o01@34`<C0a<34`<C0a<34`<C0a<3oa?O
0_lDg`0CoimOWenOGimOWenOGimOWenOG`03o`0WGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62
LH9aPW62LH9a00Co01B2LH9aPW62LH9aPW62LH9aPW62o`H000060003od1001=000?o@4004402oaE0
00?o@4004D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0ol3gP?N0mh3gP?N0mh3gP?N0mh3g_l04]l01?oO
golCg`1EoimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;l
P_b2o8;lP_coo8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0600001P000om0@00C@003od1001100_lE@003
od10015001?o0a<34`<C0a<34`<C0a<34`<C00Co01@34`<C0a<34`<C0a<34`<C0a<3oa;O00Cogmoo
4ml0EOnOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62
LH9aPW62LOmaPW62LH9aPW62LH9aPW62LH9aP_l01P0000H000?o@4004D02oa=00_lC@0;o5400:ooN
0mh3gP?N0mh3gP?N0mh3gP?o0ol3gP?N0mh3gP?N0mh3gP?N0mh3g_l04]l01?oOgolCg`1EoimOWenO
GimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o?ol
P_b2o8;lP_b2o8;lP_b2o8;lo`0600001P000om0@00C@003od1001100_lE@003od10015002_o0a<3
4`<C0a<34`<C0a<34`<Coa?o4`<C0a<34`<C0a<34`<C0a<34`?o01;O00Cogmoo4ml0EOnOGimOWenO
GimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW7oLH;oPW62
LH9aPW62LH9aPW62LH9aP_l01P0000H000?o@4004403oa=00_lB@0?o54005?oN0mh3gP?N0mh3gP?N
0mh3gP?N0_l05@?N0mh3gP?N0mh3gP?N0mh3gP?No`0Cg`;o5=l04onOGimOWenOGimOWenOGimOWel0
0_l0:ImOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;l00;o01F2o8;lP_b2o8;l
P_b2o8;lP_b2o?l01P0000H000?o@4009T02obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`?o02WO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00H000060003od1002I0
0_lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`1EoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lo`0600001P000om0@00V@0;o:D00:ol34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l01P0000H0
00?o@4009T02obU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO
05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00H000060003od1002I00_lY@00[o`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
o`0600001P000om0@00V@0;o:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3g_l0:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l01P0000H000?o@4009T02obU002_o0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO05GoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH;o00H000060003od1002I00_lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?No`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0600001P000om0@00V@0;o
:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml0EOnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aP_l01P0000H000?o@4009T02obU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00H000060003
od1002I00_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`1E
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0600001P000om0@00V@0;o:D00:ooN0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0
1P0000H000?o@4009T02obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`?o02WO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00H000060003od1002I00_lY@00[omh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`1EoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lo`0600001P000om0@00V@0;o:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0ol0:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l01P0000H000?o@4009T02obU0
02_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO05GoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_co00H000060003od1002I00_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<3o`0Yg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0600001P3mo`H0
0006000Yoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l0:X9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`?o02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000Yoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o880
0_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO02_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000Yoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW400_l0:X9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU0
02_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO02_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Yoob2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO
02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Yoh9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l0:X9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`?o02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000Yoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l0:_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000Yoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW40
0_l0:X9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO02_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000Yoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8800_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU0
02_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO02_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Yoh9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l0:X9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO
02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Yoob2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mko02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000Yoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l0:X9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`?o02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000Yoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o880
0_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO02_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000Yoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW400_l0:X9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU0
02_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO02_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Yoob2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO
02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Yoh9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l0:X9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`?o02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000Yoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l0:_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO02_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000Yoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW40
0_l0:X9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO02_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000Yoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8800_l0:_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU0
02_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO02_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000Coh9aPW62LH9aPW62LH9aPW62
L@04o`0BPW62LH9aPW62LH9aPW62LH9a0_l04X9aPW62LH9aPW62LH9aPW62L@Co01B2LH9aPW62LH9a
PW62LH9aPW62oa900olD@00Do`<C0a<34`<C0a<34`<C0a<34`<3o`0D0a<34`<C0a<34`<C0a<34`<C
0olCg`;o5=l04onOGimOWenOGimOWenOGimOWel00ol05EnOGimOWenOGimOWenOGimOWenOo`060000
1P00:OolP_b2o8;lP_b2o8;lP_b2o8;loob2o8;lP_b2o8;lP_b2o8;lP_b200;o02[lP_b2o8;lP_b2
o8;lP_b2o8;loob2o8;lP_b2o8;lP_b2o8;lP_b2o?lE@003od10015002_ogP?N0mh3gP?N0mh3gP?N
0mh3gP?o0mh3gP?N0mh3gP?N0mh3gP?N0mko01;O00Cogmoo4ml0:onOGimOWenOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOGimOWol01P0000H002WoPW62LH9aPW62LH9aPW62LH9aPW7oLH9aPW62
LH9aPW62LH9aPW62L@02o`0ZPW62LH9aPW62LH9aPW62LH9aPW7oLH9aPW62LH9aPW62LH9aPW62LH;o
5D000om0@00A@00Co`<C0a<34`<C0a<34`<C0a<34`04o`0D0a<34`<C0a<34`<C0a<34`<C0olBg`04
omoOoa?O02_oWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGioo00H00006000Y
oob2o8;lP_b2o8;lP_b2o8;lP_b2o?olP_b2o8;lP_b2o8;lP_b2o8800_l0:_b2o8;lP_b2o8;lP_b2
o8;lP_b2o?olP_b2o8;lP_b2o8;lP_b2o8;loa=00_lD@00[omh3gP?N0mh3gP?N0mh3gP?N0ol3o`?N
0mh3gP?N0mh3gP?N0mh3gP?No`0Bg`04omoOoa?O02_oWenOGimOWenOGimOWenOGimOWonOGimOWenO
GimOWenOGimOWenOGioo00H00006000Yoh9aPW62LH9aPW62LH9aPW62LOmaP_n2LH9aPW62LH9aPW62
LH9aPW400_l0:X9aPW62LH9aPW62LH9aPW62LOmaP_n2LH9aPW62LH9aPW62LH9aPW62oaE000?o@400
4D00:ol34`<C0a<34`<C0a<34`<C0a?o4olC0a<34`<C0a<34`<C0a<34`<C0ol04]l01?oOgolCg`0[
oimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOo`0600001P005?olP_b2o8;l
P_b2o8;lP_b2o8;l0_l04h;lP_b2o8;lP_b2o8;lP_b2o8800_l04ob2o8;lP_b2o8;lP_b2o8;lP_`0
0_l05H;lP_b2o8;lP_b2o8;lP_b2o8;lo`0B@0?o54005?oN0mh3gP?N0mh3gP?N0mh3gP?N0_l05@?N
0mh3gP?N0mh3gP?N0mh3gP?No`0Cg`;o5=l04onOGimOWenOGimOWenOGimOWel00_l05YmOWenOGimO
WenOGimOWenOGimOWol600001P00:On2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9a00;o02Z2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`0[oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:OolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b200;o02[lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`0[oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:On2LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02Z2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
o`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:Ool
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b200;o02[lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?No`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00:On2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02Z2LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00:OolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b200;o02[lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`0[oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:On2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9a00;o02Z2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
P_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`0[oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:OolP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b200;o02[lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
o`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:On2
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02Z2LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<3o`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00:OolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b200;o02[lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00:On2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9a00;o02Z2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`0[oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:OolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b200;o02[lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`0[oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:On2LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02Z2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
o`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:Ool
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b200;o02[lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?No`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00:On2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02Z2LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`0[oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00:OolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b200;o02[lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`0[oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00:On2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9a00;o02Z2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
P_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`0[oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P3mo`H00006000YoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO00?o0000
100000H002WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1DWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_co:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3g_l0:Ml00ol0000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o05BOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<3o`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO00?o0000100000H002WoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o
:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml00ol000040000
1P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
o`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`?o02WO00?o0000100000H002WoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co:D00:ooN0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0:Ml00ol0000400001P00:OnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[
o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`03o`0000@00006000Y
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO
00?o0000100000H002WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1D
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH;o:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0ol0:Ml00ol0000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO00?o0000100000H002WoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_co:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0:Ml00ol0
000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<3o`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO00?o0000100000H002WoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o:D00:ol34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml00ol0000400001P00:OnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`03o`0000@0
0006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`?o02WO00?o0000100000H001?oWenOGimOWenOGimOWenOGimO00?o01=OWenOGimOWenOGimOWenO
GimO00;o01:OGimOWenOGimOWenOGimOWel3o`0WGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;l
P_b2o8;lP_b200Co01ClP_b2o8;lP_b2o8;lP_b2o8;loa900olD@00Domh3gP?N0mh3gP?N0mh3gP?N
0mh3o`0DgP?N0mh3gP?N0mh3gP?N0mh3g_lCg`;o5=l00ol0000400001P00:OnOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62oh9aPW62LH9aPW62LH9aPW62LH9aP_lE@003
od10015002_o0a<34`<C0a<34`<C0a<34`<C0a?o4`<C0a<34`<C0a<34`<C0a<34`?o01;O00Cogmoo
4ml00ol0000400001P00:OnOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO00;o
05BOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2
o8;lP_n2o8;lP_b2o8;lP_b2o8;lP_b2o?lE@003od10015001?ogP?N0mh3gP?N0mh3gP?N0mh300Co
01CN0mh3gP?N0mh3gP?N0mh3gP?Noa;O00Cogmoo4ml00ol0000400001P00:OnOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH;oPW62LH9aPW62LH9aPW62LH9aP_lC@0;o
5400:ol34`<C0a<34`<C0a<34`<C0a?o4olC0a<34`<C0a<34`<C0a<34`<C0ol04]l01?oOgolCg`03
o`0000@00006000YoimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWel00_l0E9mO
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_n2
o?olP_b2o8;lP_b2o8;lP_b2o8;loaE000?o@4004D00:ooN0mh3gP?N0mh3gP?N0mh3gP?o0ol3gP?N
0mh3gP?N0mh3gP?N0mh3g_l04]l01?oOgolCg`03o`0000@00006000CoimOWenOGimOWenOGimOWenO
G`02o`0DWenOGimOWenOGimOWenOGimOWel2o`0BWenOGimOWenOGimOWenOGimO0_l0:ImOWenOGimO
WenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW6200;o01EaPW62LH9aPW62LH9aPW62LH9aP_l0
4T03oaA001Co0a<34`<C0a<34`<C0a<34`<C0`;o01DC0a<34`<C0a<34`<C0a<34`<C0ol04ml2oaCO
00?o0000100000H002WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1D
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3g_l0:Ml00ol0000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO00?o0000100000H002WoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH;o:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml00ol0
000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?No`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU002_o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`?o02WO00?o0000100000H002WoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co:D00:ooN0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0:Ml00ol0000400001P00:OnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
P_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0Yg`03o`0000@0
0006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mko02WO00?o0000100000H002WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`1DWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0ol0:Ml00ol0000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`03o`0000@00006000YoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obU0
02_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o02WO00?o0000100000H0
02WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_co:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0
:Ml00ol0000400001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
05BOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lY@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<3o`0Yg`03o`0000@00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0E9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobU002_ogP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko02WO00?o0000100000H002WoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`1DWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o:D00:ol3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0:Ml00ol0000400001P00:OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o05BOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o?lY@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0Yg`03
o`0000@000060?go1P0000H000?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U0
02_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003omoO02KO
0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<3o`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H0
00?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o00H000060003omoO02KO0_lYg`1EoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
o`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000?ogml09]l2obWO05GoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mko00H000060003omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[
o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ooOg`0Vg`;o
:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o00H000060003
omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol0
1P0000H000?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Giooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003omoO02KO0_lYg`1EoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<3o`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?ogml09]l2obWO
05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`?o00H000060003omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
o`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0600001P000ooO
g`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000?ogml04Ml2oa?O0_lCg`;o5=l04onOGimOWenO
GimOWenOGimOWel00ol09enOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lPP04o`0D
o8;lP_b2o8;lP_b2o8;lP_b2o?lB@0?o54005?oN0mh3gP?N0mh3gP?N0mh3gP?N0ol05=h3gP?N0mh3
gP?N0mh3gP?N0mko1P0000H000?ogml04=l01?oOgolBg`;o4]l01?oOgolCg`1EoimOWenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH;oPW62LH9aPW62
LH9aPW62LH9aPW62o`0E@003od10015002_o0a<34`<C0a<34`<C0a<34`<C0a?o4`<C0a<34`<C0a<3
4`<C0a<34`?o00H000060003omoO013O00Cogmoo4]l2oa;O00Cogmoo4ml0EOnOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_n2o8;lP_b2o8;l
P_b2o8;lP_b2o?l05D000om0@00A@00Comh3gP?N0mh3gP?N0mh3gP?N0`04o`0DgP?N0mh3gP?N0mh3
gP?N0mh3g_l600001P000ooOg`0@g`04omoOoa;O0_lBg`04omoOoa?O05GoWenOGimOWenOGimOWenO
GimOWonOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62oh9aPW62LH9aPW62
LH9aPW62LH;o01=00_lD@00[o`<C0a<34`<C0a<34`<C0a<34olCoa<34`<C0a<34`<C0a<34`<C0a<3
o`0600001P000ooOg`0@g`04omoOoa;O0_lBg`04omoOoa?O05GoWenOGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2oh;loob2o8;lP_b2o8;lP_b2o8;l
P_co01E000?o@4004D00:ooN0mh3gP?N0mh3gP?N0mh3gP?o0ol3gP?N0mh3gP?N0mh3gP?N0mh3g_l0
1P0000H000?ogml04Ml2oa?O0_lCg`;o5=l04onOGimOWenOGimOWenOGimOWel00_l0:ImOWenOGimO
WenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW6200;o01EaPW62LH9aPW62LH9aPW62LH9aP_l0
4T03oaA001Co0a<34`<C0a<34`<C0a<34`<C0`;o01DC0a<34`<C0a<34`<C0a<34`<C0ol01P0000H0
00?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003omoO02KO0_lYg`1EoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
o`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?ogml09]l2obWO05GoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`?o00H000060003omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[
omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0600001P000ooOg`0Vg`;o
:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0ol01P0000H000?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_co02U002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003
omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0
1P0000H000?ogml09]l2obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o00H000060003omoO02KO0_lYg`1EoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?No`0600001P000ooOg`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000?ogml09]l2obWO
05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mko00H000060003omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
o`0Y@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ooO
g`0Vg`;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?ogml09]l2obWO05GoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o00H0
00060003omoO02KO0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0600001@3no`H000050?ko1P0000H000?o0000
9@03obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`?o00H000060003o`0002@000Co0?oo:Ml0EOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0
1P0000H000?o00008`000ol00002obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o00H000060003o`00028000Co0000
0_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?No`0600001P000ol0000Q0003o`0000800_lYg`1EoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
o`0600001P000ol0000P0003o`0000<00_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[
omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?No`0600001P000ol0000O0003
o`0000@00_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ol0000N0003o`0000D00_lYg`1EoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?No`0600001P000ol0000M0003o`0000H00_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
o`0Y@00[o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ol0
000800;o00<0ool03`000ol0000700;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?o00002@000ol0
o`0?0003o`0000P00_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ol0000:0003o`0000d000?o0000
2@02obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003o`0000T000?o0?l03@000ol0000:00;o:Ml0EOnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0ol01P0000H000?o00002002o`030?oo00/000?o00002`02obWO05GoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mko00H000060003o`0001L000?o00003002obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o02U0
02_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o00H000060003o`0001H0
00?o00003@02obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003o`0001D000?o00003P02obWO05GoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`?o00H000060003o`0001@000?o00003`02oa?O0_lDg`0CoimOWenOGimOWenOGimOWenO
G`03o`0WGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b200Co01ClP_b2o8;lP_b2
o8;lP_b2o8;loa900olD@00Domh3gP?N0mh3gP?N0mh3gP?N0mh3o`0DgP?N0mh3gP?N0mh3gP?N0mh3
g_l600001P000ol0000C0003o`0001000_lBg`04omoOoa?O05GoWenOGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aP_n2LH9aPW62LH9aPW62LH9aPW62
LH;o01E000?o@4004D00:ol34`<C0a<34`<C0a<34`<C0a<34olC0a<34`<C0a<34`<C0a<34`<C0ol0
1P0000H000?o00004P000ol0000A00;o4]l01?oOgolCg`1EoimOWenOGimOWenOGimOWenOGiooWenO
GimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2oh;lP_b2o8;lP_b2o8;lP_b2o8;l
o`0E@003od10015001?ogP?N0mh3gP?N0mh3gP?N0mh300Co01CN0mh3gP?N0mh3gP?N0mh3gP?No`H0
00060003o`00014000?o00004P02oa;O00Cogmoo4ml0EOnOGimOWenOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH;oPW62LH9aPW62LH9aPW62LH9aP_l0
4d02oaA002_o0a<34`<C0a<34`<C0a<34`<Coa?o4`<C0a<34`<C0a<34`<C0a<34`?o00H000060003
o`00010000?o00004`02oa;O00Cogmoo4ml0EOnOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenO
GimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;oP_coo8;lP_b2o8;lP_b2o8;lP_b2o?l05D000om0
@00A@00[omh3gP?N0mh3gP?N0mh3gP?N0ol3o`?N0mh3gP?N0mh3gP?N0mh3gP?No`0600001P000ol0
000?0003o`0001@00_lCg`;o5=l04onOGimOWenOGimOWenOGimOWel00_l0:ImOWenOGimOWenOGimO
WenOGimOWon2LH9aPW62LH9aPW62LH9aPW6200;o01EaPW62LH9aPW62LH9aPW62LH9aP_l04T03oaA0
01Co0a<34`<C0a<34`<C0a<34`<C0`;o01DC0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000?o0000
3P000ol0000800?o2P02obWO05GoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Giooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co02U002_ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H000060003o`0000d000?o00002P000ol0
000900;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000?o000030000ol0000<0003o`0000P00_lYg`1E
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?No`0600001P000ol0000;0003o`0000d000?o00002002obWO05GoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH;o02U002_o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`?o00H000060003o`0000X000?o00003@000ol0o`0900;o:Ml0EOnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H0
00?o00002@000ol0000>0003o`3o00T00_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[
o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P000ol000080003
o`0000h00_l00`3oo`0800;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?o00001`000ol0000L00;o
:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0ol01P0000H000?o00001P000ol0000M00;o:Ml0EOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l0
1P0000H000?o00001@000ol0000N00;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000?o000010000ol0
000O00;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000?o00000`000ol0000P00;o:Ml0EOnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0ol01P0000H000?o00000P000ol0000Q00;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0
:D00:ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_l01P0000H000Go0000
o`0T00;o:Ml0EOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0:D00:ol34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0ol01P0000H000Co003o9@02obWO05GoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_co02U002_ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko00H0
00060003o`3o02H00_lYg`1EoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0Y@00[o`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3o`0600001P02obL00_lYg`1EoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lo`0Y@00[omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
o`0600001P3mo`H0000_00;of0000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P0000h00_l:00;o
gP03o``0000>0003o`0000X000?o0000g@000ol0000;00001`04o`<000?o00000P03o`D000?o0000
a002o`030?oo00X000?o000020000ol0000:000020000ol0o`030003o`0000D000?o00000P000ol0
00350003o`3o00/000?o000020000ol0000:000020000ol000030003o`0000D000?o00000P000ol0
00360003o`0000P01Ol70003o`3o00/000090003o`00008000?o00000P03o`D000?o0000a@000ol0
o`0;0003o`0000L000?o0?l02`0000L000?o0?l010000ol000020003o`0000D000?o0000a002o`03
0?oo00X000?o00001P02o`030?oo00X0000700Co0`02o`<01?l300;ok@000?l02P000?l02P000?l0
2P000001\
\>"],
  ImageRangeCache->{{{0, 264.812}, {287, 0}} -> {-1.15003, -0.16397, 
  0.0237907, 0.0237907}},
  CellTags->"Form"],

Cell[BoxData[
    \({{0, 1, 2, 3, 4}, {1, 2, 3, 4, 0}, {2, 3, 4, 0, 1}, {3, 4, 0, 1, 2}, {
        4, 0, 1, 2, 3}}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "This name also shows up when asking for information learned about ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", as does the description and the results of some tests performed on ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". We use the ",
  StyleBox["GroupInfo", "MR"],
  " command to retrieve this information."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupInfo[G]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"Form"],

Cell[BoxData[
    \({"Z[5]", "Integers under addition mod n", "this is a group"}\)], 
  "Output",
  CellLabel->"Out[19]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "There are several other means for forming groupoids, including ",
  StyleBox["GenerateGroupoid", "MR"],
  " and ",
  StyleBox["FormGroupoidByTable", "MR"],
  ". They are discussed in detail in ",
  ButtonBox["chapter 2",
    ButtonData:>{"GenerateGroupoid", "GenerateGroupoid"},
    ButtonStyle->"AddOnsLink"],
  ", but we give a brief illustration here. ",
  StyleBox["GenerateGroupoid", "MR"],
  " is used by giving a set of generators and a binary operator, while ",
  StyleBox["FormGroupoidByTable", "MR"],
  " requires a list of elements followed by the Cayley table."
}], "Text",
  CellTags->"Form"],

Cell[TextData[{
  "Here is an illustration of ",
  StyleBox["GenerateGroupoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G2\  = 
      GenerateGroupoid[{{{1, \ 0}, \ {0, \ 7}}, \ {{4, \ 0}, \ {0, \ 1}}}, \ 
        Mod[#1\  . \ #2, \ 9]&, \ WideElements\  \[Rule] \ True, \ 
        FormatElements\  \[Rule] \ True, \ 
        GroupoidName\  \[Rule] \ "\<What am I?\>", \ \ 
        GroupoidDescription\  \[Rule] \ 
          "\<generated by two 2-by-2 matrices under matrix multiplication mod \
9\>"]\)], "Input",
  CellLabel->"In[20]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \(Groupoid[{"-Elements-"}, "-Operation-"]\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Here is an example of ",
  StyleBox["FormGroupoidByTable", "MR"],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[a, \ b, \ c]\), 
    \(G3\  = \ 
      FormGroupoidByTable[{a, \ b, \ c}, 
        \ {{a, \ c, \ b}, \ {b, \ a, \ c}, \ {c, \ b, a}}]\)}], "Input",
  CellLabel->"In[21]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \(Groupoid[{a, b, c}, "-Operation-"]\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"Form"]
}, Open  ]],

Cell["\<\
We can view the Cayley tables of these two groupoids. Are either of \
these groups?\
\>", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[{G2, \ G3}, \ Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[23]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \("KEY for What am I?: label used \[Rule] element: {g1 \[Rule] {{1, 0}, \
{0, 1}}, g2 \[Rule] {{1, 0}, {0, 4}}, g3 \[Rule] {{1, 0}, {0, 7}}, g4 \[Rule] \
{{4, 0}, {0, 1}}, g5 \[Rule] {{4, 0}, {0, 4}}, g6 \[Rule] {{4, 0}, {0, 7}}, \
g7 \[Rule] {{7, 0}, {0, 1}}, g8 \[Rule] {{7, 0}, {0, 4}}, g9 \[Rule] {{7, 0}, \
{0, 7}}}"\)], "Print",
  CellTags->"Form"],

Cell[BoxData[
    \("For each element, a different color is used. The entries in the table \
corresponding to the elements are then colored and labeled accordingly."\)], 
  "Print",
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119048 0.47619 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119048 0.477324 0.488095 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.119048 0.0952381 0.025 0.0952381 [
[ 0 0 0 0 ]
[ 1 1.05 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05 L
0 1.05 L
closepath
clip
newpath
1 1 0 r
.11905 .7869 m
.11905 .88214 L
.21429 .88214 L
.21429 .7869 L
F
.30952 .69167 m
.30952 .7869 L
.40476 .7869 L
.40476 .69167 L
F
.21429 .59643 m
.21429 .69167 L
.30952 .69167 L
.30952 .59643 L
F
.69048 .50119 m
.69048 .59643 L
.78571 .59643 L
.78571 .50119 L
F
.88095 .40595 m
.88095 .50119 L
.97619 .50119 L
.97619 .40595 L
F
.78571 .31071 m
.78571 .40595 L
.88095 .40595 L
.88095 .31071 L
F
.40476 .21548 m
.40476 .31071 L
.5 .31071 L
.5 .21548 L
F
.59524 .12024 m
.59524 .21548 L
.69048 .21548 L
.69048 .12024 L
F
.5 .025 m
.5 .12024 L
.59524 .12024 L
.59524 .025 L
F
1 .5 0 r
.21429 .7869 m
.21429 .88214 L
.30952 .88214 L
.30952 .7869 L
F
.11905 .69167 m
.11905 .7869 L
.21429 .7869 L
.21429 .69167 L
F
.30952 .59643 m
.30952 .69167 L
.40476 .69167 L
.40476 .59643 L
F
.78571 .50119 m
.78571 .59643 L
.88095 .59643 L
.88095 .50119 L
F
.69048 .40595 m
.69048 .50119 L
.78571 .50119 L
.78571 .40595 L
F
.88095 .31071 m
.88095 .40595 L
.97619 .40595 L
.97619 .31071 L
F
.5 .21548 m
.5 .31071 L
.59524 .31071 L
.59524 .21548 L
F
.40476 .12024 m
.40476 .21548 L
.5 .21548 L
.5 .12024 L
F
.59524 .025 m
.59524 .12024 L
.69048 .12024 L
.69048 .025 L
F
.56 .37 .6 r
.30952 .7869 m
.30952 .88214 L
.40476 .88214 L
.40476 .7869 L
F
.21429 .69167 m
.21429 .7869 L
.30952 .7869 L
.30952 .69167 L
F
.11905 .59643 m
.11905 .69167 L
.21429 .69167 L
.21429 .59643 L
F
.88095 .50119 m
.88095 .59643 L
.97619 .59643 L
.97619 .50119 L
F
.78571 .40595 m
.78571 .50119 L
.88095 .50119 L
.88095 .40595 L
F
.69048 .31071 m
.69048 .40595 L
.78571 .40595 L
.78571 .31071 L
F
.59524 .21548 m
.59524 .31071 L
.69048 .31071 L
.69048 .21548 L
F
.5 .12024 m
.5 .21548 L
.59524 .21548 L
.59524 .12024 L
F
.40476 .025 m
.40476 .12024 L
.5 .12024 L
.5 .025 L
F
0 0 1 r
.40476 .7869 m
.40476 .88214 L
.5 .88214 L
.5 .7869 L
F
.59524 .69167 m
.59524 .7869 L
.69048 .7869 L
.69048 .69167 L
F
.5 .59643 m
.5 .69167 L
.59524 .69167 L
.59524 .59643 L
F
.11905 .50119 m
.11905 .59643 L
.21429 .59643 L
.21429 .50119 L
F
.30952 .40595 m
.30952 .50119 L
.40476 .50119 L
.40476 .40595 L
F
.21429 .31071 m
.21429 .40595 L
.30952 .40595 L
.30952 .31071 L
F
.69048 .21548 m
.69048 .31071 L
.78571 .31071 L
.78571 .21548 L
F
.88095 .12024 m
.88095 .21548 L
.97619 .21548 L
.97619 .12024 L
F
.78571 .025 m
.78571 .12024 L
.88095 .12024 L
.88095 .025 L
F
.74 .99 .79 r
.5 .7869 m
.5 .88214 L
.59524 .88214 L
.59524 .7869 L
F
.40476 .69167 m
.40476 .7869 L
.5 .7869 L
.5 .69167 L
F
.59524 .59643 m
.59524 .69167 L
.69048 .69167 L
.69048 .59643 L
F
.21429 .50119 m
.21429 .59643 L
.30952 .59643 L
.30952 .50119 L
F
.11905 .40595 m
.11905 .50119 L
.21429 .50119 L
.21429 .40595 L
F
.30952 .31071 m
.30952 .40595 L
.40476 .40595 L
.40476 .31071 L
F
.78571 .21548 m
.78571 .31071 L
.88095 .31071 L
.88095 .21548 L
F
.69048 .12024 m
.69048 .21548 L
.78571 .21548 L
.78571 .12024 L
F
.88095 .025 m
.88095 .12024 L
.97619 .12024 L
.97619 .025 L
F
.251 .878 .816 r
.59524 .7869 m
.59524 .88214 L
.69048 .88214 L
.69048 .7869 L
F
.5 .69167 m
.5 .7869 L
.59524 .7869 L
.59524 .69167 L
F
.40476 .59643 m
.40476 .69167 L
.5 .69167 L
.5 .59643 L
F
.30952 .50119 m
.30952 .59643 L
.40476 .59643 L
.40476 .50119 L
F
.21429 .40595 m
.21429 .50119 L
.30952 .50119 L
.30952 .40595 L
F
.11905 .31071 m
.11905 .40595 L
.21429 .40595 L
.21429 .31071 L
F
.88095 .21548 m
.88095 .31071 L
.97619 .31071 L
.97619 .21548 L
F
.78571 .12024 m
.78571 .21548 L
.88095 .21548 L
.88095 .12024 L
F
.69048 .025 m
.69048 .12024 L
.78571 .12024 L
.78571 .025 L
F
0 .79 .34 r
.69048 .7869 m
.69048 .88214 L
.78571 .88214 L
.78571 .7869 L
F
.88095 .69167 m
.88095 .7869 L
.97619 .7869 L
.97619 .69167 L
F
.78571 .59643 m
.78571 .69167 L
.88095 .69167 L
.88095 .59643 L
F
.40476 .50119 m
.40476 .59643 L
.5 .59643 L
.5 .50119 L
F
.59524 .40595 m
.59524 .50119 L
.69048 .50119 L
.69048 .40595 L
F
.5 .31071 m
.5 .40595 L
.59524 .40595 L
.59524 .31071 L
F
.11905 .21548 m
.11905 .31071 L
.21429 .31071 L
.21429 .21548 L
F
.30952 .12024 m
.30952 .21548 L
.40476 .21548 L
.40476 .12024 L
F
.21429 .025 m
.21429 .12024 L
.30952 .12024 L
.30952 .025 L
F
0 .392 0 r
.78571 .7869 m
.78571 .88214 L
.88095 .88214 L
.88095 .7869 L
F
.69048 .69167 m
.69048 .7869 L
.78571 .7869 L
.78571 .69167 L
F
.88095 .59643 m
.88095 .69167 L
.97619 .69167 L
.97619 .59643 L
F
.5 .50119 m
.5 .59643 L
.59524 .59643 L
.59524 .50119 L
F
.40476 .40595 m
.40476 .50119 L
.5 .50119 L
.5 .40595 L
F
.59524 .31071 m
.59524 .40595 L
.69048 .40595 L
.69048 .31071 L
F
.21429 .21548 m
.21429 .31071 L
.30952 .31071 L
.30952 .21548 L
F
.11905 .12024 m
.11905 .21548 L
.21429 .21548 L
.21429 .12024 L
F
.30952 .025 m
.30952 .12024 L
.40476 .12024 L
.40476 .025 L
F
1 .753 .796 r
.88095 .7869 m
.88095 .88214 L
.97619 .88214 L
.97619 .7869 L
F
.78571 .69167 m
.78571 .7869 L
.88095 .7869 L
.88095 .69167 L
F
.69048 .59643 m
.69048 .69167 L
.78571 .69167 L
.78571 .59643 L
F
.59524 .50119 m
.59524 .59643 L
.69048 .59643 L
.69048 .50119 L
F
.5 .40595 m
.5 .50119 L
.59524 .50119 L
.59524 .40595 L
F
.40476 .31071 m
.40476 .40595 L
.5 .40595 L
.5 .31071 L
F
.30952 .21548 m
.30952 .31071 L
.40476 .31071 L
.40476 .21548 L
F
.21429 .12024 m
.21429 .21548 L
.30952 .21548 L
.30952 .12024 L
F
.11905 .025 m
.11905 .12024 L
.21429 .12024 L
.21429 .025 L
F
1 1 0 r
.11905 .88214 m
.11905 .97738 L
.21429 .97738 L
.21429 .88214 L
F
1 .5 0 r
.21429 .88214 m
.21429 .97738 L
.30952 .97738 L
.30952 .88214 L
F
.56 .37 .6 r
.30952 .88214 m
.30952 .97738 L
.40476 .97738 L
.40476 .88214 L
F
0 0 1 r
.40476 .88214 m
.40476 .97738 L
.5 .97738 L
.5 .88214 L
F
.74 .99 .79 r
.5 .88214 m
.5 .97738 L
.59524 .97738 L
.59524 .88214 L
F
.251 .878 .816 r
.59524 .88214 m
.59524 .97738 L
.69048 .97738 L
.69048 .88214 L
F
0 .79 .34 r
.69048 .88214 m
.69048 .97738 L
.78571 .97738 L
.78571 .88214 L
F
0 .392 0 r
.78571 .88214 m
.78571 .97738 L
.88095 .97738 L
.88095 .88214 L
F
1 .753 .796 r
.88095 .88214 m
.88095 .97738 L
.97619 .97738 L
.97619 .88214 L
F
1 1 0 r
.02381 .7869 m
.02381 .88214 L
.11905 .88214 L
.11905 .7869 L
F
1 .5 0 r
.02381 .69167 m
.02381 .7869 L
.11905 .7869 L
.11905 .69167 L
F
.56 .37 .6 r
.02381 .59643 m
.02381 .69167 L
.11905 .69167 L
.11905 .59643 L
F
0 0 1 r
.02381 .50119 m
.02381 .59643 L
.11905 .59643 L
.11905 .50119 L
F
.74 .99 .79 r
.02381 .40595 m
.02381 .50119 L
.11905 .50119 L
.11905 .40595 L
F
.251 .878 .816 r
.02381 .31071 m
.02381 .40595 L
.11905 .40595 L
.11905 .31071 L
F
0 .79 .34 r
.02381 .21548 m
.02381 .31071 L
.11905 .31071 L
.11905 .21548 L
F
0 .392 0 r
.02381 .12024 m
.02381 .21548 L
.11905 .21548 L
.11905 .12024 L
F
1 .753 .796 r
.02381 .025 m
.02381 .12024 L
.11905 .12024 L
.11905 .025 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .025 m
.02381 .97738 L
s
.02381 .025 m
.97619 .025 L
s
.02381 .12024 m
.97619 .12024 L
s
.02381 .21548 m
.97619 .21548 L
s
.02381 .31071 m
.97619 .31071 L
s
.02381 .40595 m
.97619 .40595 L
s
.02381 .50119 m
.97619 .50119 L
s
.02381 .59643 m
.97619 .59643 L
s
.02381 .69167 m
.97619 .69167 L
s
.02381 .7869 m
.97619 .7869 L
s
.02381 .88214 m
.97619 .88214 L
s
.02381 .97738 m
.97619 .97738 L
s
.11905 .025 m
.11905 .97738 L
s
.21429 .025 m
.21429 .97738 L
s
.30952 .025 m
.30952 .97738 L
s
.40476 .025 m
.40476 .97738 L
s
.5 .025 m
.5 .97738 L
s
.59524 .025 m
.59524 .97738 L
s
.69048 .025 m
.69048 .97738 L
s
.78571 .025 m
.78571 .97738 L
s
.88095 .025 m
.88095 .97738 L
s
.97619 .025 m
.97619 .97738 L
s
.02381 .97738 m
.11905 .88214 L
s
2.6 Mabswid
.11905 .025 m
.11905 .97738 L
s
.02381 .88214 m
.97619 .88214 L
s
[(g1)] .16667 .83452 0 0 Mshowa
[(g2)] .2619 .83452 0 0 Mshowa
[(g3)] .35714 .83452 0 0 Mshowa
[(g4)] .45238 .83452 0 0 Mshowa
[(g5)] .54762 .83452 0 0 Mshowa
[(g6)] .64286 .83452 0 0 Mshowa
[(g7)] .7381 .83452 0 0 Mshowa
[(g8)] .83333 .83452 0 0 Mshowa
[(g9)] .92857 .83452 0 0 Mshowa
[(g2)] .16667 .73929 0 0 Mshowa
[(g3)] .2619 .73929 0 0 Mshowa
[(g1)] .35714 .73929 0 0 Mshowa
[(g5)] .45238 .73929 0 0 Mshowa
[(g6)] .54762 .73929 0 0 Mshowa
[(g4)] .64286 .73929 0 0 Mshowa
[(g8)] .7381 .73929 0 0 Mshowa
[(g9)] .83333 .73929 0 0 Mshowa
[(g7)] .92857 .73929 0 0 Mshowa
[(g3)] .16667 .64405 0 0 Mshowa
[(g1)] .2619 .64405 0 0 Mshowa
[(g2)] .35714 .64405 0 0 Mshowa
[(g6)] .45238 .64405 0 0 Mshowa
[(g4)] .54762 .64405 0 0 Mshowa
[(g5)] .64286 .64405 0 0 Mshowa
[(g9)] .7381 .64405 0 0 Mshowa
[(g7)] .83333 .64405 0 0 Mshowa
[(g8)] .92857 .64405 0 0 Mshowa
[(g4)] .16667 .54881 0 0 Mshowa
[(g5)] .2619 .54881 0 0 Mshowa
[(g6)] .35714 .54881 0 0 Mshowa
[(g7)] .45238 .54881 0 0 Mshowa
[(g8)] .54762 .54881 0 0 Mshowa
[(g9)] .64286 .54881 0 0 Mshowa
[(g1)] .7381 .54881 0 0 Mshowa
[(g2)] .83333 .54881 0 0 Mshowa
[(g3)] .92857 .54881 0 0 Mshowa
[(g5)] .16667 .45357 0 0 Mshowa
[(g6)] .2619 .45357 0 0 Mshowa
[(g4)] .35714 .45357 0 0 Mshowa
[(g8)] .45238 .45357 0 0 Mshowa
[(g9)] .54762 .45357 0 0 Mshowa
[(g7)] .64286 .45357 0 0 Mshowa
[(g2)] .7381 .45357 0 0 Mshowa
[(g3)] .83333 .45357 0 0 Mshowa
[(g1)] .92857 .45357 0 0 Mshowa
[(g6)] .16667 .35833 0 0 Mshowa
[(g4)] .2619 .35833 0 0 Mshowa
[(g5)] .35714 .35833 0 0 Mshowa
[(g9)] .45238 .35833 0 0 Mshowa
[(g7)] .54762 .35833 0 0 Mshowa
[(g8)] .64286 .35833 0 0 Mshowa
[(g3)] .7381 .35833 0 0 Mshowa
[(g1)] .83333 .35833 0 0 Mshowa
[(g2)] .92857 .35833 0 0 Mshowa
[(g7)] .16667 .2631 0 0 Mshowa
[(g8)] .2619 .2631 0 0 Mshowa
[(g9)] .35714 .2631 0 0 Mshowa
[(g1)] .45238 .2631 0 0 Mshowa
[(g2)] .54762 .2631 0 0 Mshowa
[(g3)] .64286 .2631 0 0 Mshowa
[(g4)] .7381 .2631 0 0 Mshowa
[(g5)] .83333 .2631 0 0 Mshowa
[(g6)] .92857 .2631 0 0 Mshowa
[(g8)] .16667 .16786 0 0 Mshowa
[(g9)] .2619 .16786 0 0 Mshowa
[(g7)] .35714 .16786 0 0 Mshowa
[(g2)] .45238 .16786 0 0 Mshowa
[(g3)] .54762 .16786 0 0 Mshowa
[(g1)] .64286 .16786 0 0 Mshowa
[(g5)] .7381 .16786 0 0 Mshowa
[(g6)] .83333 .16786 0 0 Mshowa
[(g4)] .92857 .16786 0 0 Mshowa
[(g9)] .16667 .07262 0 0 Mshowa
[(g7)] .2619 .07262 0 0 Mshowa
[(g8)] .35714 .07262 0 0 Mshowa
[(g3)] .45238 .07262 0 0 Mshowa
[(g1)] .54762 .07262 0 0 Mshowa
[(g2)] .64286 .07262 0 0 Mshowa
[(g6)] .7381 .07262 0 0 Mshowa
[(g4)] .83333 .07262 0 0 Mshowa
[(g5)] .92857 .07262 0 0 Mshowa
[(g1)] .07143 .83452 0 0 Mshowa
[(g2)] .07143 .73929 0 0 Mshowa
[(g3)] .07143 .64405 0 0 Mshowa
[(g4)] .07143 .54881 0 0 Mshowa
[(g5)] .07143 .45357 0 0 Mshowa
[(g6)] .07143 .35833 0 0 Mshowa
[(g7)] .07143 .2631 0 0 Mshowa
[(g8)] .07143 .16786 0 0 Mshowa
[(g9)] .07143 .07262 0 0 Mshowa
[(g1)] .16667 .92976 0 0 Mshowa
[(g2)] .2619 .92976 0 0 Mshowa
[(g3)] .35714 .92976 0 0 Mshowa
[(g4)] .45238 .92976 0 0 Mshowa
[(g5)] .54762 .92976 0 0 Mshowa
[(g6)] .64286 .92976 0 0 Mshowa
[(g7)] .7381 .92976 0 0 Mshowa
[(g8)] .83333 .92976 0 0 Mshowa
[(g9)] .92857 .92976 0 0 Mshowa
[(What am I?)] .02381 1.025 -1 0 Mshowa
gsave
.97619 1.025 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05619 .91357 0 0 Mshowa
[(y)] .09524 .94881 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119048 0.97619 0.488095 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 .5 0 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.56 .37 .6 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(a)] .38095 .62202 0 0 Mshowa
[(c)] .61905 .62202 0 0 Mshowa
[(b)] .85714 .62202 0 0 Mshowa
[(b)] .38095 .38393 0 0 Mshowa
[(a)] .61905 .38393 0 0 Mshowa
[(c)] .85714 .38393 0 0 Mshowa
[(c)] .38095 .14583 0 0 Mshowa
[(b)] .61905 .14583 0 0 Mshowa
[(a)] .85714 .14583 0 0 Mshowa
[(a)] .14286 .62202 0 0 Mshowa
[(b)] .14286 .38393 0 0 Mshowa
[(c)] .14286 .14583 0 0 Mshowa
[(a)] .38095 .86012 0 0 Mshowa
[(b)] .61905 .86012 0 0 Mshowa
[(c)] .85714 .86012 0 0 Mshowa
[(TheGroup)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lG07Co3`0000X000_ok[o^_njok[o^_`02o`0bk[o^_njok[o^_njo
on2Ph:3PX>2Ph:3Poe2@D91@T52@D91@og62LH9aPW62LH9aP_l;g`0JoimOWenOGimOWenOoo4BlA;a
4_4BlA;a4_l;@00=oa<34`<C0a<34`<Co`0G000Kog62LH9aPW62LH9aPW62LH9aPW62LH9aPW6200;o
03YaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7=l00ol0000=00002P000onoo`02o`06_fjoK[m^0_l03[oooonoK[m^_fjoK_nP0ol02J3PX>2Ph:3o
D003o`M@00?oP_l00_l02X;lP_b2o8;loml3o`OO00?oWol00_l02YmOWenOGioo/183o`094[0B/1:`
4_m000?o1d000ol3o`02o`080mh3gP?N0olG000Koh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l00;o
03Z2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7=l00ol0000=00002P002oo^_njooko^_njo00;o03;^_njooko^_njok[ooh:3PX?nPh:3PX>3oD91@
T?n@D91@T53oLH9aP_n2LH9aPW62o`CO00?ogml01=l06_nOGimOoenOGimOWooa4_4BlOoa4_4BlA;o
14000om0@004@00=oa<34`?o0a<34`<Co`0G000Kog62LH9aPW62LH9aPW62LH9aPW62LH9aPW6200;o
03YaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7=l00ol0000=00002P000onoo`03o`05K_ooofh00_l00kooo`02o`09K_ooofjoK_nP00Co00SPX?nP
h:3oD0Co0U02o`9@00?oP_l00ol02OcoooolP_cog`04o`04goooo`;O00?oWol00ol00eooo`02o`04
Won`4PCo00R`4_oo/1;o@0Co0T03o`03@?l300Co00ONoooogP?o01L001_oP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_`00_l0>X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenO
GimOWenOGimOWenOGolLg`03o`0000d0000:00;o00Rok[oo_njokPCo00^ok[oo_njok_o^_`02o`0:
X>2Poj3Pon2Ph0;o00Z@D93oT?n@D?m@0_l02h9aP_n2LH9aog6200;o0ml01?oOgol3g`;o01MOWeoo
GiooWenOoo7olA;aoo7olA;o4P02o`=000Go@410o`02@0;o00/34`?o0a<34olCo`0G000Kog62LH9a
PW62LH9aPW62LH9aPW62LH9aPW6200;o03YaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo7=l00ol0000=00002P02o`06K[m^ofjo1_l01VjoK_m^_`?o
00joK_ooh:3Pon2Ph?oPX0;o0e000om@o`02D00?oe3ooob2o?olP_b2oh;l00;o0ml01?oOgol3g`;o
01MOWeooGimOoenOok3o/1:`ok3o/1;o4P02o`=000?o@?l00ol03T3oomh3g_oN0mh3o`?o5`006on2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002o`0jP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?o00003@0000X00_l02;o^_onooko^1?l02ko^
_onooko^onjo00;o00ZPh:3oX>2Poj3P0_l01Y1@T?n@D0;o00Z@D?ooPW62oh9a0_l00h9aPP02o`?O
00Cogmoo0ml2o`0BGimOoenOGiooWooaoo4BlOoa0ol01?4Bool3@005od3o@?l00T02o`050a<3o`<0
0ol00`<Co`0G000Kog62LH9aPW62LH9aPW62LH9aPW62LH9aPW6200;o03YaPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ol0000=00002P000ono
o`05o`03K[oo00;o00>oool01?l01fjookm^oj001Ol01j3PX?nPoe001_l2D004oe3oPPGo00R2o8;o
P_cog`Go00?Ooml00]l00onOo`05o`07GiooWon`4P06o`06/1:`4_m01_l01T3o@43o0`Ko00GN0mh3
o`0G000Koh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l00;o03Z2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ol0000=00002P002?o^_njok[o^
0_l02[ooonjok[o^_nh2o`0:_njoon2Ph:3PX0Co00WPoe2@D91@T5000_l02I1@og62LH9aPP03o`04
PW62o`KO0_l3g`08oimOWenOGil2o`0;GioolA;a4_4BlA800ol00a;o@006@0;o0T001olC0a<34`<0
1?l00a?o000F000Kog62LH9aPW62LH9aPW62LH9aPW62LH9aPW6200;o03YaPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ol0000=00002P002ono
K[m^_fjoK[m^00;o01VoK[m^_fjoK[m^_fkoX>2Ph:3PX>2Ph:3o00]@00koP_b2o8;lP_b2o8;lo`_O
01[oWenOGimOWenOGioo/1:`4[0B/1:`4[0Bo`]000go0mh3gP?N0mh3gP?o01L001_oP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_`00_l0>X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolLg`03o`0000d0000:000;onjok[o^_njok[l00_l0<^jok[o^_njo
k[o^_ooPX>2Ph:3PX>2Ph?m@T52@D91@T52@D?maPW62LH9aPW62LH;o2ml06_nOGimOWenOGimOWooa
4_4BlA;a4_4BlA;o2d003OlC0a<34`<C0a<34ol05`006omaPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PP02o`0jLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoacO00?o00003@0000X000_o_fjoK[m^_fjoKP02o`0I_fjoK[m^_fjoK[m^oj3PX>2Ph:3PX>2P
o`0;D00>oh;lP_b2o8;lP_b2o?l;g`0JoimOWenOGimOWenOok0B/1:`4[0B/1:`4_l;@00=o`?N0mh3
gP?N0mh3o`0G000Koh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l00;o03Z2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ol0000=00002P1loaL0
00goLH9aPW62LH9aPW6200?o00^2LH9aPW62LH9aPP02o`0=LH9aPW62LH9aPW62L@03o`0ILH9aPW62
LH9aPW62oimOWenOGimOWenOG`04o`0=WenOGimOWenOGimOo`0<g`Go2ml00ol0000=00002P000om@
D008D0;o3500<_m^_fjoK[m^_fjoK_nPh:3PX>2Ph:3PX?mOWenOGimOWenOGiooo8;lP_b2o8;lP_co
2ml06_oN0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1;o2d000ol0000E000Koh;lP_b2o8;lP_b2oh;lP_n2
o8;lP_b2o8;l00;o03Z2o8;lP_b2o8;lP_coo8;loob2o8;lP_b2o8;loimOWenOGimOWenOGomOWeoo
GimOWenOGimOWeoo3=l01?oOgol<g`03o`0000d0000:0003oi3o00;o00J@D91@T502o`0>T?oooi1@
T52@D91@okl3o`09_njok[o^_ooP00?o00WPX>2Ph:3Poel00ol02UnOGimOWenOoh83o`09PW62LH9a
P_oO00?o1ml00ol34`03o`094`<C0a<34olB00?o00TBlA;a4_4Bod000ol7@003o`0001D001_oLH9a
PW62LH9aPW7oLH9aPW62LH9aPW62LH800_l0>W62LH9aPW62LH9aP_n2LH9aPW62LH9aPW62LH;oWenO
GimOWenOGimOoenOGomOWenOGimOWenOGol<g`Co3=l00ol0000=00002P000om@D002D003oe1@00=@
0_l4D003oe1@00E@03;oK[m^_onoK[m^_fkoX>2Ph?oPX>2Ph:3oGimOWonOGimOWenOoob2o8;oP_b2
o8;lo`CO00?ogml01=l06_oN0mh3g_oN0mh3gP?o4[0B/?n`4[0B/1;o14000om0@004@003o`0001D0
01_oP_b2o8;lP_b2o8;oP_b2oh;lP_b2o8;lP_`00_l0>X;lP_b2o8;lP_b2o?olP_coo8;lP_b2o8;l
P_coWenOGimOWenOGimOoenOGomOWenOGimOWenOGol?g`03omoO00[O00?o00003@0000X000?oT?l0
0ol01E2@oom@00;o00>@ool00_l02E2@oom@T53o_`04o`08k_ooonjoon04o`08X>3oh:3Poel4o`03
Wooo00;o00AOWon21?l0277ooomaP_oO1?l01=ooool2g`03o`<C00Co00P3oooo0a?o4PCo00Sa4_oo
lA;o@0Co0T03o`03@?l001H000goLH9aPW62LH9aPW6200Co00YaPW62LH9aPW620_l03G62LH9aPW62
LH9aPW401?l0689aPW62LH9aPW62oimOWenOGimOWenOG`Co00fOGimOWenOGimOWeoo00gO0ol<g`03
o`0000d0000:00;o0e000om@o`02D0Co0e000om@o`02D003oe1@00;o00ZoK[oo_fjoK_m^0_l02^2P
h?oPX?nPh:02o`0;WenOoimOoenOGil00_l02X;lP_n2o8;loo`2o`?O00Cogmoo0ml03OoNomh3g_oN
0mh3o`<00_l02[0B/?n`ok0Boa82o`=000Go@410o`02@003o`0001D001_oP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_`00_l0>X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOoenO
GimOWenOGimOWenOGolLg`03o`0000d0000:00;o00Q@T53oD?m@T0Co00]@T53oD?m@T?n@D002o`06
k[o^onjo0ol03Koooj3PX?nPh:3oX>000_l02imOWonOGiooWenO00;o00YaPW7oLH9aP_n20_l3g`04
omoOo`?O00go0ol34`?o0a<34olC00;o00[a4_7olOoa4_lB0_l3@003od3o00?o00=0o`005P006oma
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPP02o`0XLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nO
GimOWenOGimOW`;o011OWenOGimOWenOGimOWeoo7=l00ol0000=00002P02o`=@00?oD5000_l0153o
ool3D003oe1@00;o0e02o`0:_fjookoo_fkoKP;o00[PX>3oh:3Pon2P0_l02imOWonOGimOoenO00;o
00J2o8;oP_`2o`04P_coo`?O00Cogmoo0ml02?oNomh3g_oN0ol02Mh3oon`4[3o/003o`04/1;oo`=0
00Go@?m0o`02@003o`0001D001_oP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`00_l0>X;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03o`0000d0
000:0003oi3o00Go00=@T?l00_l00i3oo`04o`07D93oT53o_`06o`06k[oo_ooP1Ol01n2Ph?oPoel0
1_l01imOoenOoh801Ol01h9aP_n2oml01Ol00moog`02g`03o`<C00Ko00H34`<Coa86o`06lA;a4_m0
1_l01D3o@43o01L001_oLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH800_l0>W62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH;oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03o`0000d0000:0003
oe1@00E@0_l00e3oo`07D0;o0e002?m^_fjoK[m^0_l02Km^oj3PX>2Ph004o`09X?mOWenOGimO00;o
00ZOGiooo8;lP_b20ol00h;lo`06g`;o0ml02?oN0mh3gP?N1?l02@?o4[0B/1:`4P03o`034_m000I0
0_l2@003o`0001D001_oP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`00_l0>X;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03o`0000d0000:000;
oi1@T52@D91@T5000_l0?Y1@T52@D91@T52@D?nok[o^_njok[o^_ooPX>2Ph:3PX>2Ph?mOWenOGimO
WenOGiooPW62LH9aPW62LH;o2ml06_l34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;o2d000ol0000E000K
og62LH9aPW62LH9aPW62LH9aPW62LH9aPW6200;o03YaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ol0000=00002P000om@D008D0;o3500<_m^
_fjoK[m^_fjoK_nPh:3PX>2Ph:3PX?mOWenOGimOWenOGiooo8;lP_b2o8;lP_co2ml06_oN0mh3gP?N
0mh3gP?o4[0B/1:`4[0B/1;o2d000ol0000E000Koh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l00;o
03Z2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7=l00ol0000=00002P1loaL001_oLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH800_l0>W62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH;oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03o`0000d0
000:000;on2Ph:3PX>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l02e003Om^_fjoK[m^_fjoK_l03=l06OnO
GimOWenOGimOWoolP_b2o8;lP_b2o?l034006Ol3gP?N0mh3gP?N0olB/1:`4[0B/1:`4_l05`006on2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002o`0jP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?o00003@0000X000?oX?l00_l01Z3PX>2Ph0;o
00jPooooX>2Ph:3PX>3oD0?o00U@T52@D91@okl00ol02Ko^_njok[oog`03o`SO00?oWol00_l02ImO
WenOGiooPP03o`08PW62LH9aP_l2@0?o1d000olCo`02o`094`<C0a<34olB00?o00PBlA;a4_4BoaL0
01_oLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH800_l0>W62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH;oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03o`0000d0000:000;on2Ph:3oX>2Ph:00
0_l03N2Ph:3oX>2Ph:3PX?l015000om@D004D00=ofjoK[oo_fjoK[m^o`04g`03omoO00GO01WoWenO
GomOWenOGiooo8;lP_n2o8;lP_co00E000?o@40014006Ol3gP?Nomh3gP?N0olB/1:`ok0B/1:`4_l0
5`006on2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002o`0jP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?o00003@0000X000?oX?l00ol01N2P
oj3P00;o00>Pool00_l02N2Poj3PX>3oD004o`08T53ooi1@okl4o`08k_ooonjooml4o`04goooo`?O
00?oWol00ol00eooo`02o`03Won200Co00MaooooLH;o00901?l2@0?o00=0oa<01?l020?oool34olB
1?l01o4Boooa4_l05`1do`l0000:00;o00VPh:3oX>3oh:000ol02j3PX?nPh?oPX>2P00;o0e000om@
o`02D00>oe3ookm^_onoK[m^ofh2o`?O00Cogmoo1=l2o`0:GimOoenOoimOW`;o00f2o8;oP_b2o?ol
od3o00=000Go@410o`02@0;o00[N0mkogP?N0ol30_l02k0B/?n`ok0Boa;o01L001_oGimOWenOGimO
WenOGimOWenOGimOWenOGil00_l07EnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO01koP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l?00002P02o`09h:3Pon2Ph?oP00?o00_PX>3oh:3Pon2P
h002o`0:T52@oi3oT53oD0;o00K^_nkok[l3o`03_ooo00?O00Cogmoo1=l2o`0:GimOoenOGomOW`;o
00eaPW7oLH9aP_n2od3o00=000?o@?l00ol03D3oo`<C0ol34`<Coa<00_l02o4BlOoaoo4Boa;o01L0
01_oGimOWenOGimOWenOGimOWenOGimOWenOGil00_l07EnOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo01cO01koLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l?00002P02o`09X>2Poj3PX?nP00?o
00^Ph:3oX>2Poj3PX002o`=@00?oD5000_l2D0;o00ZoK[oo_onoK_m^0_l3g`04omoOo`CO0_l02UnO
GomOWenOoil2o`06P_b2oh;l0_l01H;lod3o00=000Go@?m0o`02@0;o00GN0mkogP03o`09gP?ook0B
/?n`00?o00>`4_l05`006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0MGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol07=l07_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`l0000:0003
oj3o00Co00>Ph:000ol00j3oo`03o`08X>2Poj3Poe06o`06T53oD?no1_l01^jookoog`Go00?Ooml0
0ml00onOo`05o`06GiooWon21Ol01X9aP_n2o`901_l01T3o@43o4`Ko00H34`<Coa86o`05lA;a4_l0
5`006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0MGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol07=l07_maPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`l0000:0007on2Ph:3PX006o`06
h:3PX>2P1?l00n2Po`07D0;o0U002?m^_fjoK[m^0_l00km^o`06g`;o1=l02?nOGimOWenO0_l02EnO
oob2o8;lPP03o`03P_co00Q00_l2@007o`?N0mh3gP04o`090olB/1:`4[0B00?o00<Bo`005P006omO
WenOGimOWenOGimOWenOGimOWenOGimOW`02o`0MGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
7=l07_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`l0000:000;oj3PX>2Ph:3PX>000_l09J3P
X>2Ph:3PX>2Ph?m@T52@D91@T52@D?nok[o^_njok[o^_ol03=l06OnOGimOWenOGimOWon2LH9aPW62
LH9aP_l034006OlC0a<34`<C0a<34olBlA;a4_4BlA;a4_l05`006omOWenOGimOWenOGimOWenOGimO
WenOGimOW`02o`0MGimOWenOGimOWenOGimOWenOGimOWenOGimOWol07=l07_maPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62o`l0000:000;on2Ph:3PX>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l02e003Om^
_fjoK[m^_fjoK_l03=l06OnOGimOWenOGimOWoolP_b2o8;lP_b2o?l034006Ol3gP?N0mh3gP?N0olB
/1:`4[0B/1:`4_l05`006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0MGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol07=l07_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`l0000:07co
5`006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0MGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol07=l07_maPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`l0000:000;ok0B/1:`4[0B/180
0_l03K0B/1:`4[0B/1:`4_l02d009_l3gP?N0mh3gP?N0om^_fjoK[m^_fjoK[ooh:3PX>2Ph:3PX>3o
2e003_olP_b2o8;lP_b2o8;o2ml03OmOWenOGimOWenOGol05`006omOWenOGimOWenOGimOWenOGimO
WenOGimOW`02o`0MGimOWenOGimOWenOGimOWenOGimOWenOGimOWol07=l07_n2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lo`l0000:0003oo7o00;o00Ka4_4BlA82o`0>lOoooo4BlA;a4_4Bod03o`M0
00?o4ol00_l02A<34`<C0a?o_`03o`0:_njok[o^_nkoX0?o00VPh:3PX>2Poi000ol02Y1@T52@D93o
PW43o`09LH9aPW62LOoO00?o1ml00omOo`02o`08GimOWenOGolG000KoenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0Nog62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH;o3`0000X000_o/1:`4_lB/1:`4P02o`0=/1:`4_lB/1:`4[0Bo`04@003
od1000A002Ko0mh3g_oN0mh3gP?oK[m^_onoK[m^_fjoon2Ph:3oX>2Ph:3Po`A@00?oD50015003_ol
P_b2o?olP_b2o8;o1=l00ooOg`04g`0=oenOGiooWenOGimOo`0G000KoenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0Noh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_co3`0000X000?olOl00ol01A;aoolB00;o00?aool00_l02A;aoolBlA;o
@004o`900ol00d3o4`04o`080oooo`<Cokl4o`09k_ooonjok_nP00Co00SPX?nPh:3oT0Co00U@T?oo
D93oPW401?l028;ooon2LOoO1?l01=ooool2g`03oeoo00?o00>Oool00_l00eoo000F000<oenOGimO
WenOGimO1?l02imOWenOGimOWenO00;o00aOWenOGimOWenOGil4o`0=GimOWenOGimOWenOo`0<g`Go
2ml03_maPW62LH9aPW62LH9a0ol03G62LH9aPW62LH9aP_l03`0000X00_l021:`4_lBoa:`1?l02a:`
4_lBoa:`ok0B00;o0d001Om0@43o00900_l02]h3g_oN0mh3o`<2o`0;_fjookm^_fkoK[l00_l02Z3P
X?nPh?oPX>02o`=@00?oD?l00U003om@oocoo8;loob2o8;oPP02o`?O00Cogmoo0ml2o`0;WenOoimO
oenOGol05`006omOWenOGimOWenOGomOWeooGimOWenOGimOW`02o`0MGimOWenOGimOWenOoimOWonO
GimOWenOGimOWol03=l01?oOgol<g`0Noh;lP_b2o8;lP_b2o?olP_coo8;lP_b2o8;lP_co3`0000X0
0_l021;a4_lBoa;a1?l02a;a4_lBoa;aoo4B00;o0d000om0o`03o`0=@?oo0a<3o`<C0a?o4`02o`06
k[o^onjo0ol03[o^oooPX>3oh:3Pon2P0_l05e2@D?m@oe2@oi3oP_n2LH;oPW62LOma00;o0ml01?oO
gol3g`;o00^OGiooWenOoimOo`0G000KoenOGimOWenOGimOoenOGomOWenOGimOWenO00;o01eOWenO
GimOWenOGiooWenOoimOWenOGimOWenOo`0<g`Co3=l07_maPW62LH9aPW62LH;oPW62LH9aPW62LH9a
PW62o`l0000:00;o00DB/1;o4P03o`094_oooa:`4_lB00?o00<B/1800_l3@005od3o@?l00T02o`05
gP?Nomh00ol03mh3oonoK[oo_onoK_m^_`02o`0:X>2Poj3PX?nPh0;o0e000om@D002o`9@00Woo?ol
P_coo8800_l01?b2ool3g`04omoOo`?O0_l02imOWonOGimOoeoo01L001_oGimOWenOGimOWeooGimO
oenOGimOWenOGil00_l07EnOGimOWenOGimOWonOGiooWenOGimOWenOGioo00oO00?ogml02]l07_n2
o8;lP_b2o8;lP_coo8;loob2o8;lP_b2o8;lo`l0000:0003oo7o00Go00<BlA800_l00o7oo`04o`07
4_4BlA;o@006o`06@?m0@?lC1_l01P<C0a?o_`Ko00O^_onok_nP00Go00NPh:3oX?n@00Ko00M@T?n@
oh9a00Go00MaPW7oLOoO00Go00?Ooml00]l00omOo`05o`05WeooGol05`003?mOWenOGimOWenOG`Co
00^OGimOWenOGimOW`02o`0<GimOWenOGimOWenO1?l03EnOGimOWenOGimOWol03Ml3o`cO00koLH9a
PW62LH9aPW62L@Co00b2LH9aPW62LH9aP_l?00002P002?n`4[0B/1:`1Ol01k0B/1:`4[000ol00k0B
o`07@0;o0T001ol3gP?N0mh01?l02@?oK[m^_fjoKP02o`0:_fjoon2Ph:3PX0Co00?Poe001U02o`9@
00Soo8;lP_b2o0?o00?lP_l01]l2o`?O00SoGimOWenOG`;o00>OGol05`006omOWenOGimOWenOGomO
WenOGimOWenOGimOW`02o`0MGimOWenOGimOWenOoimOWenOGimOWenOGimOWol07=l07_n2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`l0000:000;oo4BlA;a4_4BlA800_l03O4BlA;a4_4BlA;a4_l0
2d00?olC0a<34`<C0a<34onok[o^_njok[o^_nkoX>2Ph:3PX>2Ph:3oT52@D91@T52@D93oPW62LH9a
PW62LH9ao`0;g`0=oenOGimOWenOGimOo`0G000;oenOGimOWenOGil00_l03UnOGimOWenOGimOWenO
0_l02enOGimOWenOGimO00;o012OGimOWenOGimOWenOGioo7=l07_maPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62o`l0000:000;ok0B/1:`4[0B/1800_l03K0B/1:`4[0B/1:`4_l02d009_l3gP?N0mh3
gP?N0om^_fjoK[m^_fjoK[ooh:3PX>2Ph:3PX>3o2e003_olP_b2o8;lP_b2o8;o2ml03OmOWenOGimO
WenOGol05`006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0MGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol07=l07_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`l0000:000;oo4BlA;a
4_4BlA800_l03O4BlA;a4_4BlA;a4_l02d00?olC0a<34`<C0a<34onok[o^_njok[o^_nkoX>2Ph:3P
X>2Ph:3oT52@D91@T52@D93oPW62LH9aPW62LH9ao`0;g`0=oenOGimOWenOGimOo`0G000KoenOGimO
WenOGimOWenOGimOWenOGimOWenO00;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0N
og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o3`0000X0O?lG000KoenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0Noh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_co3`0000X000_o0a<34`<C0a<34`02o`0I0a<34`<C0a<34`<Coa;a4_4B
lA;a4_4Bo`0;@00ooe2@D91@T52@D91@T?o^_njok[o^_njok_nPh:3PX>2Ph:3PX?nOGimOWenOGimO
WeooLH9aPW62LH9aPW7o00_O00?o00005@006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0M
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol07=l07_maPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62o`l0000:0003omko00;o00KN0mh3gP<2o`0>g_ooomh3gP?N0mh3oa83o`094[0B/1:`4_m000?o
1d000om@o`02o`Q@00?o_ol00_l02Km^_fjoK[ooh003o`0:h:3PX>2Ph?nOG`?o00UOWenOGimOoh80
0ol02H;lP_b2o8;og`03o`OO00?o00005@006omOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0M
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol07=l07_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lo`l0000:000;o`<C0a?o4`<C0a<00_l06@<C0a?o4`<C0a<34olBlA;aoo4BlA;a4_l014000om0
@004@00ooe2@D93oT52@D91@T?o^_njooko^_njok_nPh:3Pon2Ph:3PX?nOGimOWonOGimOWeooLH9a
P_n2LH9aPW7o00CO00?ogml01=l00ol0000E000KoenOGimOWenOGimOWenOGimOWenOGimOWenO00;o
01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0Nog62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH;o3`0000X000?og_l00ol01@?oool300;o00?Nool00_l02@?oool3gP?o4P04o`08/1;ook0B
od04o`900ol00d3oD004o`9@0_l3D003okoo00?o00Q^ooooK[ooh0Co00VPh?oPX>3oWel01?l00ioo
o`02o`03Gon200Co00Slooooo8;og`Co00COoooo0]l00ol0000E000KoenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0Noh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_co3`0000X00_l021<34olC0a<31?l02a<34olC0a<3o`<C00;o00[a4_7o
lOoa4_lB0_l3@005od10@?l00T02o`0;T52@oi3oT53oD9000_l02[o^_onok[o^onh2o`0Gh:3Pon2P
oj3PX?nOoimOWonOGomOWel00_l02X9aP_n2LH9aog42o`?O00Cogmoo0ml00ol0000E000KoenOGimO
WenOGimOWenOGimOWenOGimOWenO00;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0N
og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o3`0000X00_l020?N0ol3gP?N1?l02`?N0ol3gP?N
omh300;o00Z`4[3o/?n`4_lB0_l3@003od3o00?o00=0ool00e000om@o`02D003oe1@00;o00I^_fko
K[l3o`0J_oooX>2Poj3PX?nPh?nOoimOWonOGiooWel2o`0:o8;loob2o8;oPP;o0ml01?oOgol3g`03
o`0001D001_oGimOWenOGimOWenOGimOWenOGimOWenOGil00_l07EnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01cO01koP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l?00002P02o`054`<Coa<0
0ol02A?ooolC0a?o4`03o`034`<C00;o00Ga4_7ol@03o`04lA;oo`=000Go@?m0o`02@0;o00J@D93o
T502o`03T52@00;o00Zok[oo_onok_o^0_l05n2Ph?oPX>3oh:3oWonOGiooWenOGomO00;o00J2LH;o
PW42o`04PW7oo`?O00Cogmoo0ml00ol0000E000KoenOGimOWenOGimOWenOGimOWenOGimOWenO00;o
01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0Nog62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH;o3`0000X000?og_l01Ol00`?N0`02o`03g_oo00Co00L3gP?N0olB00Ko00J`4[0Bod06o`06
@?m0@?m@1_l2D005oe1@okl01_l01Vjookooh0Go00SPX>3oh?nOG`Ko00JOGomOoh85o`07P_b2oh;o
g`05o`03gooO00;O00?o00005@1do`l0000:0007o`<C0a<34`06o`060a<34`<C1?l02P<Coa;a4_4B
lA83o`034_m000I00_l2@008oe2@D91@T502o`0;T52@onjok[o^_nh00_l02Ko^oj3PX>2Ph004o`0:
X?nOGimOWenOG`;o00VOGomaPW62LH800ol00h9ao`06g`;o0ml00ol0000E0003omoO01SO0_lLg`0k
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
3`0000X000_ogP?N0mh3gP?N0`02o`0IgP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0Bo`0;@003oe1@00Y@
03;o_fjoK[m^_fjoK[ooh:3PX>2Ph:3PX>3oWenOGimOWenOGimOoh;lP_b2o8;lP_b2o`_O00?o0000
5@000ooOg`0Hg`;o7=l0>oolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00l0000:000;o`<C0a<34`<C0a<00_l06@<C0a<34`<C0a<34olBlA;a4_4B
lA;a4_l02d00?om@T52@D91@T52@D93ok[o^_njok[o^_nkoX>2Ph:3PX>2Ph:3oWenOGimOWenOGimO
og62LH9aPW62LH9ao`0;g`03o`0001D000?ogml06=l2oacO03_oPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0?00002P1loaL000?ogml06=l2oacO
03_oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_mOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0?00002P000om0@008@0;o3400?_lC0a<34`<C0a<34olBlA;a4_4BlA;a4_oPX>2Ph:3PX>2Ph:3o
T52@D91@T52@D93ok[o^_njok[o^_nko3=l06OmOWenOGimOWenOGomaPW62LH9aPW62LOl05`000ooO
g`0Hg`;o7=l0>on2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00l0000:0003od3o00;o1T02o`04@?ooo`Q000?o0ol00_l02@?N0mh3gP?o4P03o`09
4[0B/1:`4_nP00?o00ZPh:3PX>2Ph?m@0ol7D003okoo00;o00RoK[m^_fjoo`;O0ol7g`03oeoo00;o
00UOWenOGimOoh800ol028;lP_b2o8;o5`000ooOg`0Hg`;o7=l0>oolP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00l0000:0003od10009000?o@400
0d02o`A000?o@4001D00?_lC0a<3o`<C0a<34olBlA;aoo4BlA;a4_oPX>2Poj3PX>2Ph:3oT52@D?m@
T52@D93ok[o^_onok[o^_nko1Ml00ooOg`04g`0IoenOGiooWenOGimOog62LH;oPW62LH9ao`0G0003
omoO01SO0_lLg`0koh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7oGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol03`0000X000?o@?l00ol2@0Go00=0ool00_l2@0?o0T000ol3o`03o`08g_ooomh3
oa84o`08/1;ook0Boj04o`09h:3oX>2Ph?m@00Co0U02o`9@00?o_ol00ol01fkooom^_ol00]l4o`04
goooo`;O00?oGol00ol00iooo`02o`03Gon200Co00Olooooo8;o01L000?ogml06=l2oacO03_oo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0?0000
2P02o`=000Ko@410od03o`=000Go@410o`03@0;o00X34`?o0a<34olC0_l02_4BlOoaoo4Boa82o`0;
X>2Poj3Pon2Ph:000_l02U2@D?m@oe2@oi02o`0=_njooko^_nkok_oOo`03g`04omoOo`?O0_l02YmO
WonOGomOWel2o`0;PW62oh9aPW7oLOl05`000ooOg`0Hg`;o7=l0>on2LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00l0000:00;o0d000om0o`06o`=0
00?o@?l00ol2@0;o00[N0mkogP?N0ol30_l02[0B/?n`ok0Boa82o`0;h:3Pon2Ph?oPX>000_l3D003
oe3o009@00[oD?ooK[m^ofjo0ol01;oogol3g`04omoOo`?O0_l02YmOWonOGiooWel2o`0;o8;loob2
o8;oP_l05`000ooOg`0Hg`;o7=l0>oolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00l0000:00;o0d001_m0od3o@0?o0d001Om0od3o00=00_l01@<C
0ol300?o00T34ooolA;aoo400ol03o4BoonPh:3oX>2Poj3PX002o`06D91@oe2@0_l04E2@oonok[oo
_onok_o^omoo00?O00Cogmoo0ml2o`0:WenOoimOWeooG`;o00J2LH;oPW42o`03PW7o01L000?ogml0
6=l2oacO03_oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOmOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0?00002P000om0o`05o`03@?m000;o00=0ool01?l00d3o@002@003o`?o00Go00KN0mh3
oa86o`06/1:`4_nP1Ol02:3PX?nPh?m@1_l2D004oe3o_`Ko00E^_onoo`02g`Go00?Ooml00]l00omO
o`05o`06WeooGon21Ol01X;lP_n2oaL000?ogml02Ml5o`[O0_l<g`Go2ml03_olP_b2o8;lP_b2o8;l
0ol06Ob2o8;lP_b2o8;lP_mOWenOGimOWenOGil01?l03EnOGimOWenOGimOWol03`0000X000?o@400
1D02o`03@?oo00M00_l3@007oa<34`<C0`04o`094olBlA;a4_4B00?o00PBon2Ph:3PX0Co00[PX?n@
D91@T52@0_l02U2@onjok[o^_nh2o`03_nko00OO0_l3g`08oenOGimOWel2o`09WeooLH9aPW6200?o
00>2LOl05`000ooOg`09g`04omoOo`_O0_l<g`04omoOo`cO03_oPW62LH9aPW62LH9aog62LOmaPW62
LH9aPW62LOmOWenOGimOWenOGiooWenOoimOWenOGimOWenOo`0?00002P000om0@008@0;o34009_l3
gP?N0mh3gP?N0olB/1:`4[0B/1:`4_nPh:3PX>2Ph:3PX>3o2e003OnoK[m^_fjoK[m^_ol03=l06OmO
WenOGimOWenOGon2o8;lP_b2o8;lP_l05`000ooOg`09g`Co2ml2o`cO1?l<g`0koob2o8;lP_b2o8;l
P_n2o8;lP_b2o8;lP_b2o8;oGimOWenOGimOWenOoimOWonOGimOWenOGimOWol03`0000X000?o@400
2402o`a003ko4`<C0a<34`<C0a?o4_4BlA;a4_4BlA;oh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@onjo
k[o^_njok[o^o`cO01WoGimOWenOGimOWeooLH9aPW62LH9aPW7o01L000?ogml03=l00ooOg`09g`;o
3ml00ooOg`0:g`0koh9aPW62LH9aPW62LOmaPW7oLH9aPW62LH9aPW7oGimOWenOGimOWenOoimOWonO
GimOWenOGimOWol03`0000X0O?lG0003omoO00[O0ol;g`;o3Ml3o`cO00koo8;lP_b2o8;lP_b2o0Co
01R2o8;lP_b2o8;lP_mOWenOGimOWenOGil4o`0=GimOWenOGimOWenOo`0?00002P002on2LH9aPW62
LH9a00;o00f2LH9aPW62LH9aPW7o00_O01[oGimOWenOGimOWeoo4_4BlA;a4_4BlA;ao`]003;o0a<3
4`<C0a<34`?ok[o^_njok[o^_njoon2Ph:3PX>2Ph:3Poe2@D91@T52@D91@oaL000?ogml06=l2oacO
03_oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOmOWenOGimOWenOGiooWenOGimOWenOGimOWenO
o`0?00002P000oolo`02o`06o8;lP_b20_l03_coooolP_b2o8;lP_oO0ol7g`03oeoo00;o00UOWenO
GimOoa800ol02Q:`4[0B/1:`od03o`M000?og_l00_l02]h3gP?N0mko_fh3o`09K[m^_fjoK_nP00?o
00VPh:3PX>2Poe000ol7D003o`0001D000?ogml06=l2oacO02Woo8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_mOWenOGimOWenOG`02o`0@WenOGimOWenOGimOWenOo`l0000:000;oh9aPW7oLH9aPW40
0_l03H9aPW7oLH9aPW62LOl01=l00ooOg`04g`0JoenOGiooWenOGimOoa;a4_7olA;a4_4BlOl4@003
od1000A003;o0a<34olC0a<34`?ok[o^_nkok[o^_njoon2Ph:3oX>2Ph:3Poe2@D93oT52@D91@oaL0
00?ogml06=l2oacO03_oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOmOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0?00002P000oolo`03o`05P_oooh800_l00ocoo`02o`09P_oooh;lP_oO00Co
00COoooo0]l00omOo`03o`03Wooo00;o00=Ooa801?l02K0Boon`4[3o@004o`900ol00d3ogP04o`09
0oooo`?Nokm^00Co00Rooooo_fkoX0Co00SPX?nPh:3oD0Co0U02o`9@00?o00005@000ooOg`0Hg`;o
7=l0>oolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00l0000:00;o00QaPW7oLH9aPPCo00]aPW7oLH9aP_n2L@02o`?O00Cogmoo0ml2o`0:WenOoimO
oenOG`;o00_a4_7olOoa4_lBl@02o`=000Go@410o`02@0;o01LC0a?o4`<C0ol3onkok[o^onjok[oo
_`02o`0:X>2Poj3Pon2Ph0;o00^@D93oT?n@D?m@o`0G0003omoO01SO0_lLg`0koh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol03`0000X00_l028;l
P_n2o8;l1?l02h;lP_n2o8;loob200;o0ml01?oOgol3g`;o00ZOGiooWenOoimO0_l02k0B/?n`ok0B
oa:`00;o0d000om0o`03o`0F@?oo0mh3o`?N0mkog_nookm^_onoKP?o00e^oooPX>3oh:3Pon2P00;o
0e000om@o`02D003oe3o01L000?ogml06=l2oacO03_oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0?00002P02o`06LH9aog620_l02W7ooomaPW7o
LH82o`03LH9a00;o0ml01?oOgol3g`;o00ZOGiooWenOGomO0_l01O4BlOoa00?o00?a4_400_l3@005
od3o@?l00T02o`054`<Coa<00ol03a<3onkok[o^onkok[oo_`02o`0:X>2Poj3PX?nPh0;o00J@D93o
T502o`03T53o01L000?ogml06=l2oacO03_oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOmOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0?00002P000oolo`04o`03o8;l00?o00?lool00ol02?b2
o?olP_oO1Ol00moog`02g`03oeoo00Go00JOGomOoa86o`07/1:`4[3o@006o`06@?m0@?oN1_l01`?N
0mko_fh01_l01[m^ofkoX0Go00NPh:3oX?m@00Ko0U000om@o`0G0003omoO01SO0_lLg`0koob2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol03`0000X0
00OoPW62LH9a00?o00Uaoon2LH9aPW400ol01762LOl6g`;o0ml02?mOWenOGimO0_l02YmOoa;a4_4B
lA83o`034_7o00M00_l2@007o`<C0a<34`04o`0:0oo^_njok[o^_`;o00W^_ooPX>2Ph:001?l02N3o
D91@T52@D002o`03T53o01L000?ogml06=l2oacO03_oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0?00002P002oolP_b2o8;lP_b200;o00glP_b2
o8;lP_b2o8;o00_O01[oGimOWenOGimOWeoo4[0B/1:`4[0B/1:`o`]002KogP?N0mh3gP?N0mko_fjo
K[m^_fjoK[m^oj3PX>2Ph:3PX>2Po`]@00?o00005@000ooOg`0Hg`;o7=l0>oolP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00l0000:000;oh9aPW62
LH9aPW400_l03H9aPW62LH9aPW62LOl02ml06_mOWenOGimOWenOGolBlA;a4_4BlA;a4_7o2d00<_l3
4`<C0a<34`<C0oo^_njok[o^_njok[ooh:3PX>2Ph:3PX>3oD91@T52@D91@T53o5`000ooOg`0Hg`;o
7=l0>on2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00l0000:000;oob2o8;lP_b2o8800_l03Ob2o8;lP_b2o8;lP_l02ml06_mOWenOGimOWenOGolB
/1:`4[0B/1:`4[3o2d009_oN0mh3gP?N0mh3g_noK[m^_fjoK[m^_fkoX>2Ph:3PX>2Ph:3o2e000ol0
000E0003omoO01SO0_lLg`0koob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;oGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol03`0000X0O?lF07Go3`0000X000_oWenOGimOWenOG`02o`0IWenOGimO
WenOGimOoh;lP_b2o8;lP_b2o`0;g`0Jo`?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/?l;@003oe1@00Y@
01WoK[m^_fjoK[m^_fkoX>2Ph:3PX>2Ph:3o01H0MOl?00002P000onOo`02o`06WenOGimO0_l03Yoo
oonOGimOWenOGoma0ol02G62LH9aPW7og`03o`OO00?o4ol00_l02Q<34`<C0a<3oo43o`09lA;a4_4B
lOm000?o1d000on@D003o`09D91@T52@D?no00?o00Vok[o^_njoon000ol02>2Ph:3PX>3o5`000ol0
000G00?o7=l0>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH;o00l0000:000;oimOWeooGimOWel00_l06ImOWeooGimOWenOGon2o8;loob2o8;lP_l0
1=l00ooOg`04g`0Jo`?N0mkogP?N0mh3g_n`4[0Boa:`4[0B/?l4@003od1000A000?oD5000e000om@
D004D00IofjoK[oo_fjoK[m^oj3PX>3oh:3PX>2Po`0G0003o`0001H000Co0?oo7=l0>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:0003
oioo00?o00=Oool01?l00iooo`02o`03Gooo00;o00BOGoma1?l028;ooon2LOoO1?l01=ooool2g`03
oa?o00?o00T3oooo0a<3oo401?l021;aoolBlOm01?l2@0?o00A0oi1@1?l0291@oon@D?no1?l02>ko
ooo^_ooP1?l01j3Pon2Ph?l05`000ol0000E0003o`0000;o7=l0>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00l0000:00;o00UOWeooGiooWel0
0ol02enOGomOWonOGimO00;o00[lP_coo8;lP_n20_l3g`04omoOo`?O0_l02mh3g_oN0mh3o`?N00;o
00XB/1;o4_lB/?n`0_l3@005od10@?l00T000om@o`03D003oe3o009@00koD?oo_fjookm^_fkoKP;o
00_PX>3oh:3oX>2Po`0G0003o`0001@000Co00000_lLg`0koimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l03`0000X00_l02EnOGomOWeooG`03o`0;
GimOoenOGomOWel00_l02X9aP_n2LH9aog42o`?O00Cogmoo0ml2o`0;0a<3o`<C0a?o4`<00_l02Q;a
4_lBoa;aoo42o`=000?o@?l00ol03T3oT?n@D93oT?n@D?m@0_l01^jok_o^_`?o00jooonPh:3oX>2P
oj3PoaL000?o00004`000ol0000200;o7=l0>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00l0000:00;o00QOWeooGimOW`Co00]OWeooGimOWonO
G`02o`06o8;loob20_l01?b2ool3g`04omoOo`?O0_l01Mh3g_oN00?o00?N0mh00_l01A:`4_lB00?o
00@B/?oo0d001Om0od3o009000?oD?l00e000om@D002o`9@0_l02[m^_onookm^ofh2o`0;h:3Pon2P
h?oPX?l05`000ol0000300;o00<0ool02P000ol0000300;o7=l0>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:0003oioo00Go00=OWol0
0_l00iooo`04o`07GiooWeooL@05o`07LH9aog7og`05o`03gooO00;O00?o4ol01Ol01`<C0a<3oo40
1_l01Q;a4_7o@0Ko00M0od10oi1@00Ko00J@D?m@okl6o`06k[oo_ooP1Ol01^2Ph?oPoaL000?o0000
10000ol0o`0:0003o`0000@00_lLg`0koimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aP_l03`0000X000SoWenOGimOW`;o00YOoonOGimOWenO0_l02UnO
Gon2o8;lP_`3o`03o8;o00KO0_l3g`07o`?N0mh3gP04o`0:0mko/1:`4[0B/0?o00>`od001T02o`90
00?oD5001U02o`9@00SoK[m^_fjoKP;o00VoK_nPh:3PX>001?l00j3o000F0003o`0000D000?o0000
20000ol0000500;o7=l0>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_co00l0000:000;oimOWenOGimOWel00_l06ImOWenOGimOWenOGomaPW62LH9a
PW62LOl02ml06_lC0a<34`<C0a<34`?olA;a4_4BlA;a4_7o2d009_n@D91@T52@D91@T53o_njok[o^
_njok[ooh:3PX>2Ph:3PX>3o5`000ol000040003o`3o00P000?o00001P02oacO03_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0?00002P002onO
GimOWenOGimO00;o01VOGimOWenOGimOWeooP_b2o8;lP_b2o8;o00_O01[o0mh3gP?N0mh3gP?Nok0B
/1:`4[0B/1:`o`]000?oD5002U006Om^_fjoK[m^_fjoK_nPh:3PX>2Ph:3PX?l05`000ol0000300;o
00<0ool01P000ol0000700;o7=l0>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:07co5`000ol0000=0003o`0000P00_l<g`Go2ml03OnO
GimOWenOGimOWel01?l06YmOWenOGimOWenOGomaPW62LH9aPW62LH9a0ol03G62LH9aPW62LH9aP_l0
3`0000X000?ogml02=l2o`cO01WoGimOWenOGimOWeooP_b2o8;lP_b2o8;o00a002KogP?N0mh3gP?N
0mko/1:`4[0B/1:`4[3oh:3PX>2Ph:3PX>2Po`]@00goK[m^_fjoK[m^_fko01L000?o000030000ol0
000900;o3=l01?oOgol<g`0koimOWenOGimOWenOGomOWeooGimOWenOGimOWeooP_b2o8;lP_b2o8;l
oob2o?olP_b2o8;lP_b2o?l03`0000X000?ogol00_l6g`;o00COoooo2=l00omOo`02o`09GimOWenO
Goma00?o00UaPW62LH9aod000ol8@003o`?o00;o00T34`<C0a<3oo400ol02_4BlA;a4_7oX>03o`09
h:3PX>2Ph?m@00?o00U@T52@D91@okl00ol02;o^_njok[oo5`000ol0000;0003o`0000X00_l<g`Co
3=l0>onOGimOWenOGimOWeooGimOoenOGimOWenOGimOog62LH9aPW62LH9aP_n2LH9aPW62LH9aPW62
LH;o00l0000:0003omoO00;O00?ogml00ml2o`CO00?ogml01Ml06OmOWenOoimOWenOGon2o8;loob2
o8;lP_l014000om0@005@00Vomh3gP?o0mh3gP?Nok0B/1;o4[0B/1:`on2Ph:3Pon2Ph:3PX?l4D003
oe1@00A@00goK[m^_onoK[m^_fko01L000?o00002P000ol0000;00;o3ml00ooOg`0:g`0koimOWenO
GimOWenOGomOWeooGimOWenOGimOWeooP_b2o8;lP_b2o8;loob2o?olP_b2o8;lP_b2o?l03`0000X0
00?ogol00ol01MoooooO00;o00?Oool00_l01=ooool3g`03oeoo00?o00>Oool00_l00eooL@04o`08
P_oooh9aod04o`900ol2@003o`?o00?o00PCoooo4`?ol@Co00TBlOoo4_7oX>001?l02:3Pon2Ph?m@
1?l0291@oon@D?no1?l01nkoooo^_ol05`000ol000090003o`0000<00ol600;o3Ml3o`cO00goWenO
GimOWenOGimO00Co01ZOGimOWenOGimOWeooLH9aPW62LH9aPW62L@Co00b2LH9aPW62LH9aP_l?0000
2P02o`?O00Cogmoo0]l3o`?O00Cogmoo1=l2o`0:WenOoimOoenOG`;o00[lP_coo8;lP_n20_l3@005
od10@?l00d02o`0:0mh3o`?N0mkogP;o01LB/1;o4_lB/?n`on3oh:3Pon2Poj3PX002o`=@00?oD?l0
0U003om@oonoK[oo_fjoK_m^o`0G0003o`0000P000?o00001@000ol0000500;o7=l0>onOGimOWenO
GimOWeooGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:00;o
0ml01?oOgol2g`?o0ml01?oOgol4g`;o00ZOGiooWenOoimO0_l02X9aP_n2LH9aog42o`=000?o@?l0
0ol2@0;o00XC0a?o4`<C0ol30_l05a;a4_lBoa;aoo7oX?nPh:3oX>2Poj3P00;o00Z@D93oT?n@D?m@
0_l01^jok_o^_`?o00>oo`005P000ol000070003o`0000L000?o00001002oacO00coWenOGimOWenO
Gil2o`0]GimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00l0000:00;o
0ml01?oOgol2g`?o0ml01?oOgol4g`;o00ZOGiooWenOGomO0_l01_b2o?olPP;o00ClP_oo0d001Om0
od3o00=00_l01@?N0ol300?o00T3g_oo4[0Boa800ol03a:`on3oh:3Pon2Ph?oPX002o`=@00?oD500
0_l2D0;o00^oK[oo_onoK_m^o`0G0003o`0000H000?o000020000ol0000400;o7=l0>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:0003
omoo00Co00COomoO0_l00mooo`03o`03gooO00?O00?oGol01Ol01YmOoeooL@Go00MaPW7oLOm000Ko
00=0od000T000ol3o`05o`064`<C0ooa1_l01a;a4_7oX>001Ol01n2Ph?oPoe001_l01Y1@oe3o_`Ko
00G^_onoo`0G0003o`0000D000?o000020000ol0o`0500;o7=l0>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00l0000:0003omoO00CO0_l2g`;o
1]l2o`CO00SoGimOWenOG`;o00VOGon2o8;lP_`00ol00ob2o`07@0;o0d001ooN0mh3gP<01?l02Mko
/1:`4[0B/003o`09/?oPX>2Ph:3P00Co00>Poe001U02o`9@00SoK[m^_fjoKP;o00>oK_l05`000ol0
00040003o`0000T000?o0?l01@02oacO03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0?00002P000ooOg`08g`;o3=l06OmOWenOGimOWenOGoma
PW62LH9aPW62LOl03400?_l34`<C0a<34`<C0ooa4_4BlA;a4_4BlOnPh:3PX>2Ph:3PX>3oD91@T52@
D91@T53o_njok[o^_njok[oo5`000ol000030003o`0000T00_l00`3oo`0400;o7=l0>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00l0000:0003
omoO00SO0_l<g`0IoenOGimOWenOGimOoh;lP_b2o8;lP_b2o`0<@00Vomh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`on2Ph:3PX>2Ph:3PX?l;D00=ofjoK[m^_fjoK[m^o`0G0003o`00008000?o00004`02oacO
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
o`0?00002@1moaL000Go0000o`0F00;o7=l0>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00l0000907go5`001?l00?lG00;o7=l0>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:00?o
00<0ool01@02o`cO01WoGimOWenOGimOWeooLH9aPW62LH9aPW7o00a003ko0a<34`<C0a<34`?olA;a
4_4BlA;a4_7oX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@oko^_njok[o^_njooaL000?o0?l06002oacO
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
o`0?00002P001Ol0o`3o00D00ol01=ooool8g`03oeoo00;o00UOWenOGimOoh800ol02H;lP_b2o8;o
@003o`Q000?og_l00_l02Mh3gP?N0mko/003o`0:/1:`4[0B/?oPX0?o00VPh:3PX>2Poe000ol7D003
ofko00;o00Q^_fjoK[m^oaL00_lI00;o7=l0>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00l0000:0004o`00o`D000Co0?oo1=l00ooOg`05g`0I
oenOGiooWenOGimOog62LH;oPW62LH9ao`04@003od1000E003ko0a<34olC0a<34`?olA;a4_lBlA;a
4_7oX>2Ph:3oX>2Ph:3Poe2@D93oT52@D91@oko^_nkok[o^_njooaL0M?l?00002P001_l0o`3o00?o
0P02o`03gooo00;o00COoooo0ml00omOo`03o`03Wooo00;o00=Ooh801?l02?coooolP_m01?l2@0?o
0T000ooNo`03o`080oooo`?Nok04o`094[3ooa:`on2P00Co00SPX?nPh:3oD0Co0U02o`9@00?oK_l0
0ol01koooonoK_l0<P02ofH0000:00?o00D0ool0o`0300?o0ml01?oOgol4g`;o00ZOGiooWeooGimO
0_l02X9aP_n2LH9aog42o`=000Go@410o`03@0;o00XC0a?o4`<C0ol30_l05a;a4_lBoa;aoo7oX?nP
h:3oX>3oh:3P00;o00Z@D93oT?n@D?m@0_l02njok_o^_njookoo09X0000:0003o`0000<000?o0?l0
0P03o`?O00Cogmoo1=l2o`0:WenOoimOWonOG`;o00[lP_coo8;lP_n20_l3@003od3o00?o0T02o`0:
0mh3o`?N0mkogP;o01LB/1;o4_lB/?n`on3oh:3Pon2Ph?oPX002o`=@00?oD?l00U002_m@oonoK[oo
_fh3o`03K_l009T0000:0003o`00008000Co003o0P03o`?O00Cogmoo1=l2o`0:WenOoimOWeooG`;o
00J2LH;oPW42o`04PW7oo`=000Go@?m0o`03@0;o00DC0a?o4`03o`094`?ooa;a4_lB00?o00lBlOnP
oj3PX?nPh:3oX>000_l01Y1@T?n@D0;o00n@D?ook[o^onkok[oo_ol0VP0000X000Go0000o`020004
o`3o00;o00?Oool00ol00moog`03g`03oeoo00Go00JOGomOoh85o`07P_b2oh;o@006o`03@?m00090
00?og_l01Ol01P?N0mko/0Ko00LB/1:`on2P00Go00NPh:3oX?m@00Ko0U001?m@ofh6o`05_fkoK_l0
VP0000X000Co003o0`001?l0o`02o`KO0_l4g`08oenOGimOWel2o`09WeooLH9aPW6200?o00>2LOl0
1d02o`=000Oo0a<34`<C00Co00T3oo4BlA;a4_400ol02O7oX>2Ph:3PX004o`09h?m@T52@D91@00;o
00Z@D?nok[o^_njo0_l00njoo`2J00002P000ol0o`0300;o00<0ool00_l<g`0IoenOGimOWenOGimO
oh;lP_b2o8;lP_b2o`0<@00Vomh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`on2Ph:3PX>2Ph:3PX?l;D00=
ofjoK[m^_fjoK[m^o`2J00002P02o`T00_l<g`0IoenOGimOWenOGimOog62LH9aPW62LH9ao`0<@00n
o`<C0a<34`<C0a<3oo4BlA;a4_4BlA;aoj3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D?nok[o^_njok[o^
_onJ00002P1loiX0000E00;oo`0:0000O@03odL01?lm00?o5@0007h000?o0000A`000ol0000n0003
o`0001@0000;0004o`00o`800_l0103oo`05o`800ol800Go00H0o`3o0?l700Go0P02ob400_l00`3o
o`090003o`3o00T000?o00007@03o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`801Ol00`3o
o`02ob@00_l00`3oo`090003o`3o00T000?o00004`0000/000Co003o0P001?l00?l20004o`00o`<0
00Co003o1`001?l00?l20005o`3o0?l02@000ol0000200;o8P000ol0o`0;0003o`0000P000?o0000
7P001Ol0003o008000Co003o10001Ol0003o00<000?o00000P001ol0003o0?l00P001?l00?l30003
o`00028000?o0?l02`000ol000080003o`0001<0000;00Co0P001?l00?l200Co0`000ol0000800Co
0P001Ol0o`3o00T000?o00009`000ol0000800Go1`000ol0o`0O0005o`000?l00P000ol00006o`04
0?ooo`<000?o00000P001ol0003o0?l00P001?l00?l30003o`0002<000?o00002005o`L000?o0?l0
500000/000Co0?oo0P001?l00?l50005o`000?l03@002?l00?l0o`3o2@000ol000030003o`000200
00?o0?l02`000ol000070003o`3o01d000Oo0?l0o`3o008000Co003o0`02o`L00_l30007o`000?l0
o`020004o`00o`<000?o00008P000ol0o`0;0003o`0000L000?o0?l0500000/000Co003o0P04o`<0
0ol200Co2@03o`030?oo00Co2@001Ol0003o008000?o00007P02o`030?oo01<00_l00`3oo`0L0006
o`3o0?l01?l300?o00<0o`000P000ol00002o`030?oo00800ol0103oo`02o`030?oo00?o9002o`03
0?oo01<00_l00`3oo`0C00002P02o`800_l00`3o000;0003o`0001X01Ol00`3oo`02oeT01Ol00`3o
000:00CoK00001000_l<0003o`0008800_mk0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-0.0536819, -0.0250054, 
  0.00734274, 0.00734274}, {{7.3125, 137}, {139.562, 
  3.375}} -> {-1.84211, -0.541504, 0.0809647, 0.0809647}, {{149.938, 
  279.688}, {139.562, 3.375}} -> {-6.45296, -0.231788, 0.0346952, 
  0.0346952}},
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Note that a key is given (for ",
  StyleBox["G2", "MR"],
  ") since the option ",
  StyleBox["WideElements \[Rule] True", "MR"],
  " indicates that the elements should not be placed in the table. In this \
case, a key is set up, associating shorter generic labels with the elements \
in the groupoid. "
}], "Text",
  CellTags->"Form"],

Cell[TextData[{
  "Another way of seeing the elements of the first ",
  StyleBox["Groupoid", "MR"],
  " is to simply ask for them with the ",
  StyleBox["Elements", "MR"],
  " function."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[MatrixForm, Elements[G2]]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"Form"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0"},
                {"0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0"},
                {"0", "4"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0"},
                {"0", "7"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "0"},
                {"0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "0"},
                {"0", "4"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "0"},
                {"0", "7"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"7", "0"},
                {"0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"7", "0"},
                {"0", "4"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"7", "0"},
                {"0", "7"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[24]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Forming ringoids is very similar to forming groupoids. Analogous to ",
  StyleBox["FormGroupoid", "MR"],
  " is ",
  StyleBox["FormRingoid", "MR"],
  ". More details can be found in the ",
  ButtonBox["chapter 3",
    ButtonData:>{"FormRingoid", "FormRingoid"},
    ButtonStyle->"AddOnsLink"],
  "."
}], "Text",
  CellTags->{"i:9", "Form"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FormRingoid\)\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"Form"],

Cell[BoxData[
    \("FormRingoid[list, addition, multiplication, {plussym, multsymb}, opts] \
is the basic command for forming a Ringoid consisting of the list of elements \
found in list governed by the operations addition and multiplication. The \
symbol plussym defaults to '+' and the multsymb defaults to '*', if not \
specified. The options for opts can be WideElements, IsARing, \
RingoidDescription, RingoidName, FormatOperator, FormatElements, \
MaxElementsToList, KeyForm, and CayleyForm. See each one for more \
information. Alternatively, FormRingoid[AG, MG, opts] forms the Ringoid using \
the Groupoid AG for the additive part and the Groupoid MG for the \
multiplicative part (assuming the same elements are used).\n\n This function, \
rather than just wrapping Ringoid around a list and the operations, is \
strongly recommended."\)], "Print",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "The default values for the options are similar to those for ",
  StyleBox["FormGroupoid", "MR"],
  ", as is the method of using them. Here is an illustration."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(R1\  = \ 
      FormRingoid[{\(-1\), \ 0, \ 1}, \ Plus, \ Times, \ 
        FormatOperator\  \[Rule] \ False, \ 
        RingoidName\  \[Rule] \ "\<Ringoid example\>"]\)], "Input",
  CellLabel->"In[26]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \(Ringoid[{\(-1\), 0, 1}, Plus, Times]\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"Form"]
}, Open  ]],

Cell["\<\
By looking at the Cayley tables, we can try to determine if this is \
a ring.\
\>", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTables[R1, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[27]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
1 .5 0 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.56 .37 .6 r
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(-2)] .38095 .62202 0 0 Mshowa
[(-1)] .61905 .62202 0 0 Mshowa
[(0)] .85714 .62202 0 0 Mshowa
[(-1)] .38095 .38393 0 0 Mshowa
[(0)] .61905 .38393 0 0 Mshowa
[(1)] .85714 .38393 0 0 Mshowa
[(0)] .38095 .14583 0 0 Mshowa
[(1)] .61905 .14583 0 0 Mshowa
[(2)] .85714 .14583 0 0 Mshowa
[(-1)] .14286 .62202 0 0 Mshowa
[(0)] .14286 .38393 0 0 Mshowa
[(1)] .14286 .14583 0 0 Mshowa
[(-1)] .38095 .86012 0 0 Mshowa
[(0)] .61905 .86012 0 0 Mshowa
[(1)] .85714 .86012 0 0 Mshowa
[(Addition)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.56 .37 .6 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(1)] .38095 .62202 0 0 Mshowa
[(0)] .61905 .62202 0 0 Mshowa
[(-1)] .85714 .62202 0 0 Mshowa
[(0)] .38095 .38393 0 0 Mshowa
[(0)] .61905 .38393 0 0 Mshowa
[(0)] .85714 .38393 0 0 Mshowa
[(-1)] .38095 .14583 0 0 Mshowa
[(0)] .61905 .14583 0 0 Mshowa
[(1)] .85714 .14583 0 0 Mshowa
[(-1)] .14286 .62202 0 0 Mshowa
[(0)] .14286 .38393 0 0 Mshowa
[(1)] .14286 .14583 0 0 Mshowa
[(-1)] .38095 .86012 0 0 Mshowa
[(0)] .61905 .86012 0 0 Mshowa
[(1)] .85714 .86012 0 0 Mshowa
[(Multiplication)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X001koPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH82o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LOlM0003o`00014001goLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPP02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0
2`0000X001koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lM0003o`00014001goP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X001koPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH82o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LOlM0003o`00014001goLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PP02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aP_l02`0000X001koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`2o`0nGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lM0003
o`00014001goP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X001koPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH82o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlM0003o`00014001goLH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPP02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X001koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_`2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_lM0003o`00014001goP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l0
2`0000X001koPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH82o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlM0003o`00014001goLH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPP02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X001koo8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_`2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_lM0003o`00014001goP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o?l02`0000X001koPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH82o`0nGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlM0003
o`00014001goLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPP02oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X001koo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lM0003o`00014001goP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X001koPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH82o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LOlM0003o`00014001goLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPP02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l0
2`0000X001koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lM0003o`00014001goP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X001koPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH82o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LOlM0003o`00014001goLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PP02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aP_l02`0000X000goo8;lP_b2o8;lP_b200?o00j2o8;lP_b2o8;lP_b2o0;o00eOWenO
GimOWenOGimO00;o01bOGimOWenOGimOWenOGiooo8;lP_b2o8;lP_b20ol048;lP_b2o8;lP_b2o8;l
P_l<00Co3@000ol0000A000=oh;lP_b2o8;lP_b2o003o`0=o8;lP_b2o8;lP_b2o002oa3O0ol;g`0?
oimOWenOGimOWenOGimO00;o01bOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b20ol03h;lP_b2o8;l
P_b2o8;lo`0;00002P007_n2LH9aPW62LH9aPW62oh9aPW62LH9aPW62LH9aPP;o03iOWenOGimOWenO
GiooWeooGimOWenOGimOWenOGiooPW62LH9aPW62LH9aP_n2LH9aPW62LH9aPW62LH9ao`d000?o0000
3@000ol0000A000Mog62LH9aPW62LH9aPW7oLH9aPW62LH9aPW62LH800_lAg`03omoO00[O03ooWenO
GimOWenOGimOWonOGomOWenOGimOWenOGimOog62LH9aPW62LH9aPW62oh9aPW62LH9aPW62LH9aP_l0
2`0000X001koo8;lP_b2o8;lP_b2o?olP_b2o8;lP_b2o8;lP_`2o`0nGimOWenOGimOWenOoimOoenO
GimOWenOGimOWenOoob2o8;lP_b2o8;lP_coo8;lP_b2o8;lP_b2o8;lP_l>0003o`0000`000?o0000
4@007On2o8;lP_b2o8;lP_b2oh;lP_b2o8;lP_b2o8;l00;o2]l5o`;O00?ogml02]l0?onOGimOWenO
GimOWenOoimOoenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_coo8;lP_b2o8;lP_b2o8;lo`0;0000
2P007_n2LH9aPW62LH9aPW62oh9aPW62LH9aPW62LH9aPP;o03iOWenOGimOWenOGiooWeooGimOWenO
GimOWenOGiooPW62LH9aPW62LH9aP_n2LH9aPW62LH9aPW62LH9ao`l000?o00002`000ol0000A000M
og62LH9aPW62LH9aPW7oLH9aPW62LH9aPW62LH800_lAg`03omoO00[O03ooWenOGimOWenOGimOWonO
GomOWenOGimOWenOGimOog62LH9aPW62LH9aPW62oh9aPW62LH9aPW62LH9aP_l02`0000X001koo8;l
P_b2o8;lP_b2o?olP_b2o8;lP_b2o8;lP_`2o`0nGimOWenOGimOWenOoimOoenOGimOWenOGimOWenO
oob2o8;lP_b2o8;lP_coo8;lP_b2o8;lP_b2o8;lP_l<0004o`00o`d000?o00004@007On2o8;lP_b2
o8;lP_b2oh;lP_b2o8;lP_b2o8;l00;o4Ml00ooOg`0:g`0ooimOWenOGimOWenOGiooWeooGimOWenO
GimOWenOGon2o8;lP_b2o8;lP_b2o?olP_b2o8;lP_b2o8;lP_co00/0000:000=oh9aPW62LH9aPW62
L@02o`0?PW62LH9aPW62LH9aPW6200;o00eOWenOGimOWenOGimO00;o01bOGimOWenOGimOWenOGioo
PW62LH9aPW62LH9a0_l04H9aPW62LH9aPW62LH9aPW7o00d00_l>0003o`00014000goLH9aPW62LH9a
PW6200;o00iaPW62LH9aPW62LH9aPP;o4=l2o`cO00ooWenOGimOWenOGimOWel00_l079mOWenOGimO
WenOGimOog62LH9aPW62LH9aPW42o`0@PW62LH9aPW62LH9aPW62o`/0000:000Noob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;l0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o7@000ol0000A000Moh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_`00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_co00/0000:000Noh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW620_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o
7@000ol0000A000Mog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH800_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00/0000:000N
oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o7@000ol0000A000Moh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_`00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00/0000:000Noh9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW620_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW7o7@000ol0000A000Mog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH800_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH;o00/0000:000Noob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o7@000ol0000A000M
oh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00/0000:000Noh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW620_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon2LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW7o7@000ol0000A000Mog62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH800_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH;o00/0000:000Noob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o
7@000ol0000A000Moh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00/0000:000N
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW620_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o7@000ol0000A000Mog62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH800_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00/0000:000Noob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;l0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;o7@000ol0000A000Moh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_`00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_co00/0000:000Noh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW620_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWon2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o7@000ol0000A000M
og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH800_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00/0000:000Noob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;l0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o7@000ol0000A000Moh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_`00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_co00/0000:07co4`1lo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_lC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_l0GEnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW7o4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o05eOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2oa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`1MGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LOlC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_l0GEnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;o4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o05eOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aoa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`1MGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_lC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_l0GEnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o
4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o05eOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa<0
01goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`1MGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlC000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_l0GEnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4`007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o05eOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoa<001goGimO
WenOGimOWenOGimOWenOGimOWenOGimOW`02o`1MGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lC000MoenOGimO
WenOGimOWenOGimOWenOGimOWenOGil00_l0GEnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0;00002P003_nOGimOWenOGimOWenO0_l03UnOGimOWenOGimOWenO0_l?g`?o3=l03_nOGimOWenO
GimOWenO0_l075nOGimOWenOGimOWenOGomaPW62LH9aPW62LH83o`0?PW62LH9aPW62LH9aPW7o01<0
00koGimOWenOGimOWenOG`;o00fOGimOWenOGimOWenO00;o00iOWenOGimOWenOGimOW`;o01eOWenO
GimOWenOGimOWonOGimOWenOGimOWenOG`02o`0MWenOGimOWenOGimOWeooGimOWenOGimOWenOGil0
0_l03enOGimOWenOGimOWenOo`0;00002P007_nOGimOWenOGimOWeooGiooWenOGimOWenOGimOW`;o
4=l00ooOg`0;g`0noimOWenOGimOWenOGomOWonOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2oh;l
P_b2o8;lP_b2o8;lP_lC000MoenOGimOWenOGimOWonOGomOWenOGimOWenOGil00_l0GEnOGimOWenO
GimOWeooGiooWenOGimOWenOGimOWonOGimOWenOGimOWenOoimOoenOGimOWenOGimOWeooGimOWenO
GimOWenOGomOWonOGimOWenOGimOWenOo`0;00002P007_nOGimOWenOGimOWeooGiooWenOGimOWenO
GimOW`;o2Ml5o`;O00?ogml02ml0?_nOGimOWenOGimOWeooGiooWenOGimOWenOGimOWeooLH9aPW62
LH9aPW62LOmaPW62LH9aPW62LH9aPW7o4`007OmOWenOGimOWenOGiooWeooGimOWenOGimOWenO00;o
05eOWenOGimOWenOGimOoenOoimOWenOGimOWenOGiooWenOGimOWenOGimOWonOGomOWenOGimOWenO
GimOoenOGimOWenOGimOWeooGiooWenOGimOWenOGimOWol02`0000X001koWenOGimOWenOGimOoenO
oimOWenOGimOWenOGil2oa3O00?ogml02ml0?_nOGimOWenOGimOWeooGiooWenOGimOWenOGimOWeoo
P_b2o8;lP_b2o8;lP_n2o8;lP_b2o8;lP_b2o8;o4`007OmOWenOGimOWenOGiooWeooGimOWenOGimO
WenO00;o05eOWenOGimOWenOGimOoenOoimOWenOGimOWenOGiooWenOGimOWenOGimOWonOGomOWenO
GimOWenOGimOoenOGimOWenOGimOWeooGiooWenOGimOWenOGimOWol02`0000X001koWenOGimOWenO
GimOoenOoimOWenOGimOWenOGil2oa3O00?ogml02ml0?_nOGimOWenOGimOWeooGiooWenOGimOWenO
GimOWeooLH9aPW62LH9aPW62LOmaPW62LH9aPW62LH9aPW7o4`007OmOWenOGimOWenOGiooWeooGimO
WenOGimOWenO00;o05eOWenOGimOWenOGimOoenOoimOWenOGimOWenOGiooWenOGimOWenOGimOWonO
GomOWenOGimOWenOGimOoenOGimOWenOGimOWeooGiooWenOGimOWenOGimOWol02`0000X000koWenO
GimOWenOGimOW`;o00iOWenOGimOWenOGimOW`;o3ml2o`gO00koWenOGimOWenOGimOW`;o01aOWenO
GimOWenOGimOWeooP_b2o8;lP_b2o8;l0_l048;lP_b2o8;lP_b2o8;lP_lC000>oenOGimOWenOGimO
Wel2o`0=WenOGimOWenOGimOW`02o`0>GimOWenOGimOWenOGil2o`0MGimOWenOGimOWenOGiooWenO
GimOWenOGimOWel00_l07ImOWenOGimOWenOGimOoenOGimOWenOGimOWenO00;o00mOWenOGimOWenO
GimOWol02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoa<001goGimO
WenOGimOWenOGimOWenOGimOWenOGimOW`02o`1MGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lC000MoenOGimO
WenOGimOWenOGimOWenOGimOWenOGil00_l0GEnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4`007OmOWenOGimO
WenOGimOWenOGimOWenOGimOWenO00;o05eOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
2`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa<001goGimOWenOGimO
WenOGimOWenOGimOWenOGimOW`02o`1MGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0
000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlC000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_l0GEnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;0000
2P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4`007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o05eOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X0
01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoa<001goGimOWenOGimOWenOGimO
WenOGimOWenOGimOW`02o`1MGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lC000MoenOGimOWenOGimOWenOGimO
WenOGimOWenOGil00_l0GEnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4`007OmOWenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o05eOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa<001goGimOWenOGimOWenOGimOWenOGimO
WenOGimOW`02o`1MGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlC000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_l0GEnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P1loa<0O?l;0000
2P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003
omoO01[O0_l0?W62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o
7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?W62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0C0003omoO01[O0_l0?X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0O
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?W62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol000090000
2P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003
omoO01[O0_l0?X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?W62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o
7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?X;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0C0003omoO01[O0_l0?W62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0O
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?X;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol000090000
2P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003
omoO01[O0_l0?W62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o7P000ooOg`0Lg`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?X;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7]l00ol0000900002P000ooOg`0Kg`;o
7P000ooOg`0Lg`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003omoO01[O0_l0?W62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7]l00ol0000900002P000ooOg`0=g`?o2ml2o`l01?l;0003omoO00gO0ol<g`0>oenOGimOWenOGimO
Wel2o`0?WenOGimOWenOGimOWeoo01<000?ogml03Ml3o`[O0_l03H;lP_b2o8;lP_b2o8800ol07H;l
P_b2o8;lP_b2o8;loimOWenOGimOWenOGimO00;o00nOGimOWenOGimOWenOGol04=l3o`_O00?o0000
2@0000X000?ogml03]l00ooOg`0:g`;o40000ol0000;0003omoO00kO00?ogml02ml07omOWenOGimO
WenOGiooWeooGimOWenOGimOWenOGol04`000ooOg`0>g`03omoO00WO0_l0?W62LH9aPW62LH9aPW62
oh9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOoimOoenOGimOWenOGimOWeoo4Ml00ooOg`0:g`03
o`0000T0000:0003omoO00OO1Ol2g`03omoO00[O0_l900Go0`000ol0000:0003omoO00OO1Ol2g`03
omoO00_O01ooGimOWenOGimOWenOoimOoenOGimOWenOGimOWeoo01<000?ogml01ml5o`;O00?ogml0
2Ml2o`0nP_b2o8;lP_b2o8;lP_coo8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGiooWeooGimOWenO
GimOWenOGol:g`Go0]l00ooOg`0:g`03o`0000T0000:0003omoO00kO00?ogml02]l2oa8000?o0000
2@000ooOg`0>g`03omoO00_O01ooGimOWenOGimOWenOoimOoenOGimOWenOGimOWeoo01<000?ogml0
3]l00ooOg`09g`;o03iaPW62LH9aPW62LH9aP_n2LH9aPW62LH9aPW62LH;oWenOGimOWenOGimOWonO
GomOWenOGimOWenOGimOoa7O00?ogml02]l00ol0000900002P000ooOg`0>g`03omoO00[O0_l?0004
o`00o`/000?ogml03]l00ooOg`0;g`0OoenOGimOWenOGimOWonOGomOWenOGimOWenOGimOo`0C0003
omoO00kO00?ogml02Ml2o`0nP_b2o8;lP_b2o8;lP_coo8;lP_b2o8;lP_b2o8;loimOWenOGimOWenO
GiooWeooGimOWenOGimOWenOGolAg`03omoO00[O00?o00002@0000X000?ogml03Ml2o`cO0_l@00;o
30000ooOg`0=g`;o3Ml03_mOWenOGimOWenOGimO0_l03imOWenOGimOWenOGimOo`0C0003omoO00gO
0_l;g`;o00eaPW62LH9aPW62LH9a00;o01j2LH9aPW62LH9aPW62LH;oWenOGimOWenOGimOWel2o`0?
WenOGimOWenOGimOWeoo013O0_l<g`03o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000:0003
omoO01_O0_lN0003omoO01cO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml0
6]l2o`0nLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGolNg`03o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000:0003omoO01_O0_lN0003
omoO01cO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nLH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03
o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<000?ogml06]l2o`0nP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nLH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000:0003
omoO01_O0_lN0003omoO01cO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml0
6]l2o`0nP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGolNg`03o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000:0003omoO01_O0_lN0003
omoO01cO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03
o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<000?ogml06]l2o`0nLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000:0003omoO01_O0_lN0003omoO01cO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000?ogml06]l2o`0nP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolNg`03o`0000T0000907go
4P1mo`/0000907go4P1mo`/0000:0003o`0001X00olNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlC0003o`0001X00_lNg`0ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00/0
000:0003o`0001T000Co0?oo7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4`000ol0000I00?o7]l0?onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0;00002P000ol0000H0003
o`0000;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW7o4`000ol0000H0004o`3ooakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X000?o00005`001?l00002oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2oa<000?o00005`000ol00002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X000?o00005P000ol0000200;o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o
4`000ol0000F0004o`0000;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0;00002P000ol0000E0003o`0000<00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lC0003
o`0001D000?o00000P02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X000?o00001002o`030?oo00/000?o00001002oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aoa<000?o00001002o`030?oo00/000?o00000`02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X000?o00001@000ol0
o`0;0003o`0000D00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_lC0003o`0000D000?o0?l02`000ol0000400;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0;0000
2P000ol000060003o`0000T000?o00001P02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoa<000?o00001P000ol000090003o`0000D0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH;o00/0000:0003o`0000D000?o0?l02@000ol0000700;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4`000ol000050003
o`3o00T000?o00001P02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X000?o00001002o`030?oo00L000?o00002002oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aoa<000?o00001002o`030?oo00L000?o00001`02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X000?o00003`000ol0
000900;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;o4`000ol0000?0003o`0000P00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co00/0000:0003o`0000h000?o0000
2P02o`oO0ol<g`0>oimOWenOGimOWenOGil2o`0LGimOWenOGimOWenOGimOog62LH9aPW62LH9aPP?o
00n2LH9aPW62LH9aPW62LOl04`000ol0000>0003o`0000T00_l@g`?o2ml03onOGimOWenOGimOWenO
G`02o`0LWenOGimOWenOGimOWeooLH9aPW62LH9aPW62L@?o00maPW62LH9aPW62LH9aP_l02`0000X0
00?o00003@000ol0000;00;o4=l00ooOg`0;g`0noimOWenOGimOWenOGomOWonOGimOWenOGimOWenO
Gon2o8;lP_b2o8;lP_b2oh;lP_b2o8;lP_b2o8;lP_lC0003o`0000d000?o00002P02oa7O00?ogml0
2]l0?onOGimOWenOGimOWenOoimOoenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_coo8;lP_b2o8;l
P_b2o8;lo`0;00002P000ol0000<0003o`0000`00_l9g`Go0]l00ooOg`0;g`0noimOWenOGimOWenO
GomOWonOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aog62LH9aPW62LH9aPW62LOlC0003o`0000`0
00?o00002`02o`[O1Ol2g`03omoO00[O03ooWenOGimOWenOGimOWonOGomOWenOGimOWenOGimOog62
LH9aPW62LH9aPW62oh9aPW62LH9aPW62LH9aP_l02`0000X000?o00002`000ol0000=00;o4=l00ooO
g`0;g`0noimOWenOGimOWenOGomOWonOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2oh;lP_b2o8;l
P_b2o8;lP_lC0003o`0000/000?o00003002oa7O00?ogml02]l0?onOGimOWenOGimOWenOoimOoenO
GimOWenOGimOWeooP_b2o8;lP_b2o8;lP_coo8;lP_b2o8;lP_b2o8;lo`0;00002P000ol0000:0003
o`0000@00ol700;o4=l00ooOg`0;g`0noimOWenOGimOWenOGomOWonOGimOWenOGimOWenOGomaPW62
LH9aPW62LH9aog62LH9aPW62LH9aPW62LOlC0003o`0000X000?o00001003o`H00_lAg`03omoO00[O
03ooWenOGimOWenOGimOWonOGomOWenOGimOWenOGimOog62LH9aPW62LH9aPW62oh9aPW62LH9aPW62
LH9aP_l02`0000X000?o00002@000ol000060003o`0000H00_l?g`;o3Ml03_nOGimOWenOGimOWenO
0_l075nOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_`2o`0@P_b2o8;lP_b2o8;lP_b2oa<000?o0000
2@000ol000060003o`0000D00_l@g`;o3=l03onOGimOWenOGimOWenOG`02o`0LWenOGimOWenOGimO
WeooP_b2o8;lP_b2o8;lPP;o013lP_b2o8;lP_b2o8;lP_co2`0000X000?o000020000ol000080003
o`0000D00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LOlC0003o`0000P000?o000020000ol0000400;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0;00002P000ol0
00070003o`0000T000?o00001@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa<000?o00001`000ol000090003o`0000@00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_co00/0000:0003o`0000H000?o00002@000ol0o`0600;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4`000ol000060003o`0000T0
00?o0?l01@02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aP_l02`0000X000?o00001@000ol0000:0003o`3o00H00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lC0003
o`0000D000?o00002P000ol0o`0500;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0;00002P000ol000040003o`0000X00_l00`3o
o`0500;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW7o4`000ol000040003o`0000X00_l00`3oo`0400;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62o`0;00002P000ol0
00030003o`0001D00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_lC0003o`0000<000?o00005002oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?l02`0000X000?o0000
0P000ol0000F00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW7o4`000ol000020003o`0001D00_lNg`0ooimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o00/0000:0005o`000?l0
6@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2oa<000Go0000o`0H00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0;00002P001?l00?lJ00;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4`001?l0
0?lI00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62o`0;00002P000ol0o`0K00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4`000ol0o`0J00;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lo`0;0000
2P02oa`00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LOlC00;o6`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_l02`0000X0O?lC07co2`0002P00_n<00;oJ0000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0007d00olg00Co
D@03oa40001n0003o`0003L000?o0000DP000ol0000@00002P02o`030?oo00<01Ol00`3oo`08o`80
0ol200Go0P03o`800_l00`3oo`0[00;o00<0ool02P000ol000080003o`0001P000Ko0000o`05o`03
0?oo00?o0P03o`801Ol00`3oo`02o`801Ol00`3oo`03o`800ol200Go0P03o`801Ol200?o0P02o`03
0?oo00L00_l00`3oo`090003o`3o00T000?o00003`0000/000?o0?l00`001ol0003o0?l00`001Ol0
003o00@000Co003o0`001Ol0003o00<000?o0?l00P000ol0000[0003o`3o00/000?o000020000ol0
000H0007o`000?l0o`020003o`00008000?o00000P001?l00?l30005o`000?l00`001Ol0003o00D0
00Go0000o`030003o`3o008000Go0000o`020005o`000?l00`001ol0003o0?l00P000ol000070003
o`3o00/000?o000020000ol0000?00002`03o`<000Oo0000o`3o00<000Go0000o`040003o`0000@0
00Go0000o`030003o`3o008000?o0000;0000ol0000800Go1`000ol0o`0I0007o`3o0?l0o`020003
o`00008000?o00000P000ol000040005o`000?l00`001Ol0003o00D000Go0000o`0500Co0`000ol0
00040005o`000?l00`000ol0o`020003o`0000P000?o00002005o`L000?o0?l0400000/000?o0?l0
0`001ol0003o0?l00`001Ol0003o00@000?o000010001Ol0003o00<000?o0?l00P000ol0000[0003
o`3o00/000?o00001`000ol0o`0I0007o`3o0?l0o`020003o`00008000?o00000P000ol000040005
o`000?l00`001Ol0003o00D000Go0000o`030003o`00008000Go0000o`060005o`000?l00`000ol0
o`020003o`0000L000?o0?l02`000ol000070003o`3o0100000<0003o`0000<01?l200Co0P02o`<0
1?l300;o1003o`030?oo00?o;002o`030?oo00X000?o00001P02o`030?oo01P00_l00`3oo`02o`03
0?oo00@000Co00001?l300;o0P05o`@000?o00000P02o`@01?l200?o0P04o`<00_l400?o00<0ool0
0ol800;o00<0ool04`02o`030?oo00l0000;00;o20000ol000030003o`0000H000?o0000LP02o`<0
0_l80003o`00008000?o000040000ol0000D0003o`0004H0000D00;o1002o`<000?o00000P000ol0
00040003o`0007P00ol40003o`0000@000?o00001`03o`D000?o00003P000ol000040003o`0003l0
003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-5.95503, -0.231915, 0.0323772, 
  0.0323772}},
  CellTags->"Form"],

Cell[BoxData[
    \({{{\(-2\), \(-1\), 0}, {\(-1\), 0, 1}, {0, 1, 2}}, {{1, 0, \(-1\)}, {0, 
          0, 0}, {\(-1\), 0, 1}}}\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["RingQ", "MR"],
  " function can confirm our suspicion."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RingQ[R1]\)], "Input",
  CellLabel->"In[28]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Similar to ",
  StyleBox["GroupInfo", "MR"],
  ", ",
  StyleBox["RingInfo", "MR"],
  " returns what has been learned about a ringoid."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RingInfo[R1]\)], "Input",
  CellLabel->"In[29]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \({"Ringoid example", "the set is not closed under this addition", 
      "the set is closed under multiplication", "this is NOT a ring"}\)], 
  "Output",
  CellLabel->"Out[29]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "While individual groups or rings can be studied by examining the set of \
elements, often additional results can be learned by considering \
homomorphisms from one group (or ring) to another. In these packages, \
homomorphisms are simply called morphisms and the ",
  StyleBox["Morphoid", "MR"],
  " is the underlying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " structure for working with these. There are several ways of using the ",
  StyleBox["FormMorphoid", "MR"],
  " function, which is the standard means of constructing morphisms."
}], "Text",
  CellTags->{"i:10", "Form"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FormMorphoid\)\)], "Input",
  CellLabel->"In[30]:=",
  GeneratedCell->True,
  CellTags->"Form"],

Cell[BoxData[
    \("FormMorphoid[f, S1, S2, (opts)] is the standard means for creating a \
Morphoid. Here, S1 and S2 are Groupoids or Ringoids, and f is either a list \
of Rules, a Function, or a Symbol. In the special case where S1 is a cyclic \
Groupoid, f can consist of just one rule that sets up the morphism. \
Additionally, if S1 consists of n elements and S2 consists of m elements, \
then FormMorphoid[{p1, p2, ... pn}, S1, S2] forms the Morphoid by sending the \
first element in S1 to the element in S2 in position p1, the second element \
in S1 to the element in position p2 in S2, until finally the nth element goes \
to the element in position pn in S2. FormMorphoidSetup may be useful in using \
this method. The options opts can consist of setting the Mode or the value of \
FormatFunction (default is False), which determines if the function should be \
formatted or not."\)], "Print",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "The default values of the options for ",
  StyleBox["FormMorphoid", "MR"],
  " are as follows."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[FormMorphoid]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"Form"],

Cell[BoxData[
    \({Mode \[Rule] Computational, FormatFunction \[Rule] False}\)], "Output",\

  CellLabel->"Out[31]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "In ",
  ButtonBox["chapter 4",
    ButtonData:>{"Forming Morphoids", "Forming Morphoids"},
    ButtonStyle->"AddOnsLink"],
  "  we look at the details of these options as well as the various means of \
forming ",
  StyleBox["Morphoids", "MR"],
  ". Here let\[CloseCurlyQuote]s construct several ",
  StyleBox["Morphoids", "MR"],
  " to illustrate the possibilities. If a specific function can be easily \
specified, then using this function is often the easiest method of forming a \
",
  StyleBox["Morphoid", "MR"],
  ". "
}], "Text",
  CellTags->"Form"],

Cell[TextData[{
  "For example, consider the groups ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  ", and the function that takes ",
  Cell[BoxData[
      \(TraditionalForm\`x\  \[Element] \ \[DoubleStruckCapitalZ]\_6\)]],
  " and maps it to ",
  Cell[BoxData[
      \(TraditionalForm\`x\ mod\ 3\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f1\  = \ 
      FormMorphoid[Mod[#, \ 3]&, \ Z[6, \ Structure\  \[Rule] \ Group], \ 
        Z[3, \ Structure\  \[Rule] \ Group]]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[Mod[#1, 3]&, "-Z[6]-", "-Z[3]-"]\)], "Output",
  CellLabel->"Out[32]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "We can specify the same morphism by using a list of rules of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] y\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is in the domain and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is in the codomain."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f2\  = \ 
      FormMorphoid[{0\  \[Rule] \ 0, \ 1\  \[Rule] \ 1, \ 2\  \[Rule] \ 2, \ 
          3\  \[Rule] \ 0, \ 4\  \[Rule] \ 1, \ 5\  \[Rule] \ 2}, \ 
        Z[6, \ Structure\  \[Rule] \ Group], \ 
        Z[3, \ Structure\  \[Rule] \ Group]]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 0, 1 \[Rule] 1, 2 \[Rule] 2, 3 \[Rule] 0, 
        4 \[Rule] 1, 5 \[Rule] 2}, "-Z[6]-", "-Z[3]-"]\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "While the method of defining these ",
  StyleBox["Morphoids", "MR"],
  " is different, as ",
  StyleBox["Morphoids", "MR"],
  " they are equal."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EqualMorphoidQ[f1, \ f2]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Note that we can convert a ",
  StyleBox["Morphoid", "MR"],
  " created by a function to one created by rules."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f3\  = \ ToRules[f1]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 0, 1 \[Rule] 1, 2 \[Rule] 2, 3 \[Rule] 0, 
        4 \[Rule] 1, 5 \[Rule] 2}, "-Z[6]-", "-Z[3]-"]\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "We can also start from scratch in defining a ",
  StyleBox["Morphoid", "MR"],
  " by first defining the underlying function."
}], "MathCaption",
  CellTags->"Form"],

Cell[BoxData[{
    \(Clear[g, \ x]\), 
    \(g[x_]\  := \ Mod[x, \ 3]\)}], "Input",
  CellLabel->"In[36]:=",
  CellTags->"Form"],

Cell[TextData[{
  "Now we use ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " to define the morphism."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f4\  = \ 
      FormMorphoid[g, \ \ Z[6, \ Structure\  \[Rule] \ Group], \ 
        Z[3, \ Structure\  \[Rule] \ Group]]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[g[#1]&, "-Z[6]-", "-Z[3]-"]\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Since we know that ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  " is isomorphic to ",
  Cell[BoxData[
      \(TraditionalForm\`\(S\_3, \)\)]],
  " we may want to set up a specific isomorphism to reflect this. The \
function ",
  StyleBox["FormMorphoidSetup", "MR"],
  " helps us do so. (We will see later how to exploit the output of this \
function to set up a morphism.)"
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FormMorphoidSetup[Dihedral[3], \ Symmetric[3]]; \),
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input",
  CellLabel->"In[39]:=",
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.05 0.25 0.05 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .05 m
.5 .45 L
s
[(Domain)] .2 .4 0 0 Mshowa
[(Codomain)] .8 .4 0 0 Mshowa
[(1)] .2 .35 0 0 Mshowa
[(1)] .45 .35 0 0 Mshowa
[(Rot)] .2 .3 0 0 Mshowa
[(2)] .45 .3 0 0 Mshowa
[(Rot^2)] .2 .25 0 0 Mshowa
[(3)] .45 .25 0 0 Mshowa
[(Ref)] .2 .2 0 0 Mshowa
[(4)] .45 .2 0 0 Mshowa
[(Rot**Ref)] .2 .15 0 0 Mshowa
[(5)] .45 .15 0 0 Mshowa
[(Rot^2**Ref)] .2 .1 0 0 Mshowa
[(6)] .45 .1 0 0 Mshowa
[({1, 2, 3})] .8 .35 0 0 Mshowa
[(1)] .55 .35 0 0 Mshowa
[({1, 3, 2})] .8 .3 0 0 Mshowa
[(2)] .55 .3 0 0 Mshowa
[({2, 1, 3})] .8 .25 0 0 Mshowa
[(3)] .55 .25 0 0 Mshowa
[({2, 3, 1})] .8 .2 0 0 Mshowa
[(4)] .55 .2 0 0 Mshowa
[({3, 1, 2})] .8 .15 0 0 Mshowa
[(5)] .55 .15 0 0 Mshowa
[({3, 2, 1})] .8 .1 0 0 Mshowa
[(6)] .55 .1 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[39]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000>P02obd00_lS0000S`000ol0000j0003o`0000T000?o00003`000ol0000?0003
o`000240000K00;o0P02o`800ol300?o2004o`d00_l200;o0P04o`030?oo00;o:P02o`d000?o0000
2P02obh000?o00000P03o`@000?o00002004o`<000?o00002003o`@000?o00008@0001`000Co0?oo
0P001Ol0003o008000Co003o20000ol0000>0004o`3oo`8000?o000010000ol0000Y0004o`00o``0
00?o00002@001?l00?l]0003o`0000D000?o00000P000ol000080003o`0000@000?o000020000ol0
00030003o`000240000L00?o0`001Ol0003o008000?o00002P000ol000020003o`3o00<000?o0?l0
0P03o`<01Ol20003o`0002T000Co003o30000ol000090004o`00ob`000?o00001P000ol0000>0003
o`0000h000?o000010000ol0000P000070001?l00?l20005o`000?l00P000ol0000;0003o`000080
00?o00000`001Ol0003o008000Co003o0`001?l00?l[00?o3@000ol0000900?o;P000ol0000300;o
4P000ol0000=0003o`0000<000?o00008@0001`000Co003o0`03o`801?l80004o`00o`801Ol00`3o
o`03o`050?l00?l00`03o`801?lY0003o`0000d000?o00002@000ol0000^0003o`0000D000?o0000
30001?l00?l?0003o`0000<000?o00008@0001/01?l:0003o`00008000?o0?l01002o`D000?o0000
0`000ol00004o`X000?o0000:P03o``000?o00002P03obd00_l300?o4002o`l00_l400;o8`0002T0
00?o00000`000ol0000Q00?o>@000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0000j00;o;@02ob<0002?0003o`0003X0
00?o00002@000ol0000?0003o`0000l000?o00008@0002400_l200;o0P03o`<00ol=00;o0P02o`80
1?l00`3oo`02obl00ol=0003o`0000T00ol^0003o`0000800ol40003o`0000P00ol40003o`0000P0
1?l30003o`000240000R0004o`3oo`8000Go0000o`020004o`00o`d000Co0?oo0P000ol000040003
o`00038000?o00002P000ol0000<0003o`0002/000?o00001@000ol000020003o`0000P000?o0000
10000ol000080003o`0000<000?o00008@0002800ol30005o`000?l00P000ol000030003o`3o00<0
00?o0?l00P03o`<01Ol20003o`00038000?o00002P000ol0000<0003o`0002X000?o00001P000ol0
000=0003o`00010000?o00000`000ol0000P00008P001?l00?l20005o`000?l00P000ol000040003
o`0000<000Go0000o`020004o`00o`<000Co003o<@03o`d000?o00002@03obh000?o00000`02oa00
00?o00004@001Ol0003o02<0000R0004o`00o`<00ol200Co0P05o`030?oo00?o00D0o`00o`0300?o
0P04obl000?o00003@000ol000090003o`0002h000?o00001@000ol0000=0003o`0000h000Co003o
0`000ol0000Q00008@04o`X000?o000010000ol000030003o`0000Co2P000ol0000_00Co30000ol0
000900Co;@02o`<00ol?00;o4@02o`<00_lS0000;`000ol0000K00?o?`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0000j00;o;@02ob<0002?0003o`0003X000?o00002@000ol0000?0003o`0000l0
00?o00008@0003000_l200;o0P04o`030?oo00;o?`03o``000?o00002P03obd000?o00000P04o`<0
00?o00002003o`@000?o00002003o`@000?o00008@00034000Co0?oo0P000ol000040003o`000400
00?o00002`000ol0000;0003o`0002`000?o00000`000ol000040003o`0000X000?o00000P000ol0
00080003o`0000<000?o00008@0003400ol300Go0P000ol0000n00Co30000ol0000900Co;0000ol0
00050003o`00010000?o00003@000ol000040003o`000200000a0004o`00o`8000Go0000o`020003
o`0003h000?o0?l03@000ol000090003o`3o02h000?o00001@000ol0000=00;o40000ol000030003
o`000240000a0004o`00o`<00ol200Co?P000ol0o`0=0003o`0000T000?o0?l0;P000ol000020004
o`00oa4000?o00003@000ol000030003o`000240000`00Co2P000ol0000o00;o3@000ol0000:00;o
;P02o`@00_l?00?o3`02o`@00_lS0000?P03odh000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000>P02obd00_lS0000
S`000ol0000j0003o`0000T000?o00003`000ol0000?0003o`000240000Z00;o0P02o`800ol300?o
2004ocP00ol=0003o`0000T00ol^0003o`0000801?l30003o`0000P00ol40003o`0000P00ol40003
o`000240000[0004o`3oo`8000Go0000o`020004o`00o`P000?o0000>`000ol0000:0003o`0000`0
00?o0000:`000ol000030003o`0000@000?o000020000ol000040003o`0000X000Go0000o`0S0000
:`03o`<000Go0000o`020003o`0000X000?o0000>P000ol0000:0003o`0000`000?o0000:P000ol0
00050003o`0000h000?o00004@000ol000020003o`000200000[0004o`00o`8000Go0000o`020003
o`0000/000?o0000=`02o`d000?o00002P02obh000?o00001@000ol0000=0003o`0000l00_l40003
o`000240000[0004o`00o`<00ol200Co20001?l00?lk0003o`0000X000?o000030000ol0000[0003
o`00008000Co003o3`000ol0000A0005o`000?l08`0002X01?l:0003o`00008000?o0?l01002ocT0
0ol=0003o`0000T00ol^00;o1002o`l00_l@00?o0`02ob<0000h0003o`0000<000?o0000CP000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0000j00;o;@02ob<0002?0003o`0003X000?o00002@000ol0000?0003o`0000l0
00?o00008@0003000_l200;o0P03o`<00oln00Co30000ol0000900Co;@000ol0000200?o10000ol0
000800?o10000ol0000800Co0`000ol0000Q0000<@001?l0ool20005o`000?l00P001?l00?ln0003
o`0000`000?o00002P000ol0000]0003o`0000<000?o000010000ol0000:0003o`00008000?o0000
20000ol000030003o`000240000a00?o0`001Ol0003o008000?o0000@0000ol0000;0003o`0000/0
00?o0000:`000ol000040003o`00014000?o00003P000ol000030003o`000200000a0004o`00o`80
00Go0000o`020003o`00044000?o00002P000ol0000<0003o`0002/000?o00000`000ol0000?00;o
4P001Ol0003o02<0000a0004o`00o`<00ol200Co?P001?l00?l<0003o`0000T000Co003o;@000ol0
00030003o`00014000?o000030001?l00?l30003o`000240000`00Co2P000ol0000o00;o3@000ol0
000:00;o;P02o`<00_l@00?o4002o`<00_lS0000?P000ol0001>0003o`0008h0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0003X00_l]00;o8`0008l000?o0000>P000ol000090003o`0000l000?o00003`000ol0
000Q0000=`03odD00ol=0003o`0000T00ol^0003o`0000800ol40003o`0000P01?l30003o`0000P0
0ol40003o`000240000h0003o`0004D000?o000030000ol0000:0003o`0002d000?o00000`000ol0
00040003o`0000P000?o000010000ol0000:0005o`000?l08`0003P000?o0000A@000ol0000<0003
o`0000X000?o0000;0000ol000040003o`00010000?o000040000ol000020003o`000200000h0003
o`0004D000?o000030000ol0000:0003o`0002d000?o00000`000ol0000A0003o`0000d00_l40003
o`000240000h0003o`0004D000?o000030000ol0000:0003o`0002d000?o00000`000ol0000>0004
o`00oa4000Go0000o`0S0000=`02odH00_l>0003o`0000T00_l_00;o0`02oa400_l?00?o0`02ob<0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0000W00Go0`03o`8000Ko0?l0o`05o`03
0?oo00?o00@0ool00_m40003o`0003`01?l300?o0`05o`040?ooo`8000Ko0?l0o`05o`030?oo00?o
00@0ool00_lS0000:0001ol0003o0?l00`002Ol0o`3o0?l0o`020003o`00008000Go0000o`020003
o`0004<000?o0000>`000ol000040007o`000?l0o`030003o`3o00<000Wo0?l0o`3o0?l00P000ol0
00020005o`000?l00P000ol0000R0000:0001ol0003o0?l00`002?l0o`3o0?l01?l40005o`000?l0
0P000ol000130003o`0003/000?o000010001ol0003o0?l00`000ol0o`030008o`3o0?l0o`04o`@0
00Go0000o`020003o`000280000X0007o`000?l0o`030007o`3o0?l0o`040003o`00008000Go0000
o`020003o`0004<000?o0000>`000ol000040007o`000?l0o`030003o`3o00<000Oo0?l0o`3o00@0
00?o00000P001Ol0003o008000?o00008P0002P000Go0000o`0200?o00<0ool01?l200?o0`02o`80
1Om50003o`0003/000Go0000o`0300?o0`04o`800ol00`3oo`04o`800ol300;o0P05ob@0000W00Go
H`000ol0000l00Co30000ol0000o0000@P000ol0001:0003o`0004/00_lE0003o`0002T0002?0003
o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003
o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-10.0351, -5.00005, 0.0699308, 
  0.0699308}},
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "1.3 How to use a ",
  StyleBox["Mode",
    FontFamily->"Courier"]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Mode", "i:11"}],

Cell[TextData[{
  "One common thread that weaves through many of the functions in ",
  StyleBox["AbstractAlgebra", "MR"],
  " is the use of the ",
  StyleBox["Mode", "MR"],
  " option. By default, functions are set to use the ",
  StyleBox["Computational", "MR"],
  " mode (though this can be changed for some functions). This means that the \
function simply produces the desired computation, with no further \
elaboration. As has been illustrated, adding ",
  StyleBox["Mode \[Rule] Visual", "MR"],
  " to some functions adds a visual or graphical image, as well as the \
computation. In addition to the ",
  StyleBox["Visual", "MR"],
  " mode, there is often a ",
  StyleBox["Textual", "MR"],
  " mode and sometimes a ",
  StyleBox["Visual2", "MR"],
  " mode. "
}], "Text",
  CellTags->"Mode"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox["Computational",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["default",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["mode",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["for",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["all",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["functions",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["(",
                        SingleLetterItalics->False], 
                      RowBox[{
                        StyleBox["unless",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["modified",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["by",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["the",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["user",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], "\n", 
                        StyleBox["with",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["SetOptions",
                          "MR"]}], 
                      StyleBox[")",
                        SingleLetterItalics->False]}]}], ";", " ", 
                  RowBox[{
                    StyleBox[
                      RowBox[{"i", 
                        StyleBox["n",
                          SingleLetterItalics->False]}]], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["this",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["mode",
                      SingleLetterItalics->False]}]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(the\ output\ is\ simply\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox[\(the\ result\ of\ the\ computation\),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["Textual",
                "StandardForm"],
              "Text"], 
            
            StyleBox[\(when\ available, \ 
              provides\ additional\ printed\ information\ about\ \nthe\ 
                function, \ 
              often\ providing\ a\ general\ definition\ of\ the\ function\ as
                \ well\ as\ information\ about\ the\ specific\ application\ 
                involving\ the\ given\ parameters\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Visual",
                "StandardForm"],
              "Text"], 
            
            StyleBox[\(when\ available, \ 
              provides\ additional\ visual\ or\ graphical\ \ninformation\ 
                about\ the\ algebraic\ concept\ represented\ by\ the\ \n
                \(function . \)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Visual2",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(if\ there\ is\ a\ second\ visualization\ for\ a\ function, \ 
              this\ mode\ is\ used\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.26, 0.74}},
  CellTags->"Mode"],

Cell[TextData[{
  "Values for the ",
  StyleBox["Mode",
    FontFamily->"Courier"],
  " option."
}], "Caption",
  CellTags->"Mode"],

Cell[TextData[{
  "Consider the following example that illustrates the use of the various \
modes. Here we use the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_25\)]],
  ", which consists of the positive integers less than 25 that are relatively \
prime to 25, under multiplication mod 25. The group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " can also be considered as the group of units in the ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ". "
}], "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(U[25]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"Mode"],

Cell[BoxData[
    \(Groupoid[{1, 2, 3, 4, 6, 7, 8, 9, 11, 12, 13, 14, 16, 17, 18, 19, 21, 
        22, 23, 24}, Mod[#1\ #2, 25]&]\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"Mode"]
}, Open  ]],

Cell[TextData[{
  "Here we use the ",
  StyleBox["Computational", "MR"],
  " mode (the default) for both forming ",
  Cell[BoxData[
      \(TraditionalForm\`U\_25\)]],
  " and testing if it is cyclic."
}], "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclicQ[\ U[25]\ ]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"Mode"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"Mode"]
}, Open  ]],

Cell[TextData[{
  "By specifying the mode to be ",
  StyleBox["Textual", "MR"],
  ", we obtain information in addition to the result of the ",
  StyleBox["Computational", "MR"],
  " output."
}], "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclicQ[\ U[25], \ Mode\  \[Rule] \ Textual\ ]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"Mode"],

Cell[BoxData[
    \("A Groupoid G is said to be cyclic if there exists an element g in G \
such that for all h in G there exists an integer n such that h = g^n."\)], 
  "Print",
  CellTags->"Mode"],

Cell[BoxData[
    \("In this case, U[25] is indeed cyclic, being generated by 2."\)], 
  "Print",
  CellTags->"Mode"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"Mode"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode works similarly; both here and with the ",
  StyleBox["Textual", "MR"],
  " mode, the output is ",
  StyleBox["True", "MR"],
  ", as given in the ",
  StyleBox["Computational", "MR"],
  " mode."
}], "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclicQ[\ U[25], \ Mode\  \[Rule] \ Visual\ ]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"Mode"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.11905 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.069161 0.0453515 0.117347 0.0453515 [
[ 0 0 0 0 ]
[ 1 1.11905 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.11905 L
0 1.11905 L
closepath
clip
newpath
.8 g
.02381 .93367 m
.02381 .97902 L
.06916 .97902 L
.06916 .93367 L
F
1 0 0 r
.06916 .93367 m
.06916 .97902 L
.11451 .97902 L
.11451 .93367 L
F
1 .3 0 r
.11451 .93367 m
.11451 .97902 L
.15986 .97902 L
.15986 .93367 L
F
1 .6 0 r
.20522 .93367 m
.20522 .97902 L
.25057 .97902 L
.25057 .93367 L
F
1 .9 0 r
.34127 .93367 m
.34127 .97902 L
.38662 .97902 L
.38662 .93367 L
F
.8 1 0 r
.61338 .93367 m
.61338 .97902 L
.65873 .97902 L
.65873 .93367 L
F
.5 1 0 r
.29592 .93367 m
.29592 .97902 L
.34127 .97902 L
.34127 .93367 L
F
.2 1 0 r
.56803 .93367 m
.56803 .97902 L
.61338 .97902 L
.61338 .93367 L
F
0 1 .1 r
.15986 .93367 m
.15986 .97902 L
.20522 .97902 L
.20522 .93367 L
F
0 1 .4 r
.25057 .93367 m
.25057 .97902 L
.29592 .97902 L
.29592 .93367 L
F
0 1 .7 r
.47732 .93367 m
.47732 .97902 L
.52268 .97902 L
.52268 .93367 L
F
0 1 1 r
.93084 .93367 m
.93084 .97902 L
.97619 .97902 L
.97619 .93367 L
F
0 .7 1 r
.88549 .93367 m
.88549 .97902 L
.93084 .97902 L
.93084 .93367 L
F
0 .4 1 r
.79478 .93367 m
.79478 .97902 L
.84014 .97902 L
.84014 .93367 L
F
0 .1 1 r
.65873 .93367 m
.65873 .97902 L
.70408 .97902 L
.70408 .93367 L
F
.2 0 1 r
.38662 .93367 m
.38662 .97902 L
.43197 .97902 L
.43197 .93367 L
F
.5 0 1 r
.70408 .93367 m
.70408 .97902 L
.74943 .97902 L
.74943 .93367 L
F
.8 0 1 r
.43197 .93367 m
.43197 .97902 L
.47732 .97902 L
.47732 .93367 L
F
1 0 .9 r
.84014 .93367 m
.84014 .97902 L
.88549 .97902 L
.88549 .93367 L
F
1 0 .6 r
.74943 .93367 m
.74943 .97902 L
.79478 .97902 L
.79478 .93367 L
F
1 0 .3 r
.52268 .93367 m
.52268 .97902 L
.56803 .97902 L
.56803 .93367 L
F
1 0 0 r
.06916 .02664 m
.06916 .072 L
.11451 .072 L
.11451 .02664 L
F
1 .3 0 r
.11451 .02664 m
.11451 .072 L
.15986 .072 L
.15986 .02664 L
F
1 .6 0 r
.15986 .02664 m
.15986 .072 L
.20522 .072 L
.20522 .02664 L
F
1 .9 0 r
.20522 .02664 m
.20522 .072 L
.25057 .072 L
.25057 .02664 L
F
.8 1 0 r
.25057 .02664 m
.25057 .072 L
.29592 .072 L
.29592 .02664 L
F
.5 1 0 r
.29592 .02664 m
.29592 .072 L
.34127 .072 L
.34127 .02664 L
F
.2 1 0 r
.34127 .02664 m
.34127 .072 L
.38662 .072 L
.38662 .02664 L
F
0 1 .1 r
.38662 .02664 m
.38662 .072 L
.43197 .072 L
.43197 .02664 L
F
0 1 .4 r
.43197 .02664 m
.43197 .072 L
.47732 .072 L
.47732 .02664 L
F
0 1 .7 r
.47732 .02664 m
.47732 .072 L
.52268 .072 L
.52268 .02664 L
F
0 1 1 r
.52268 .02664 m
.52268 .072 L
.56803 .072 L
.56803 .02664 L
F
0 .7 1 r
.56803 .02664 m
.56803 .072 L
.61338 .072 L
.61338 .02664 L
F
0 .4 1 r
.61338 .02664 m
.61338 .072 L
.65873 .072 L
.65873 .02664 L
F
0 .1 1 r
.65873 .02664 m
.65873 .072 L
.70408 .072 L
.70408 .02664 L
F
.2 0 1 r
.70408 .02664 m
.70408 .072 L
.74943 .072 L
.74943 .02664 L
F
.5 0 1 r
.74943 .02664 m
.74943 .072 L
.79478 .072 L
.79478 .02664 L
F
.8 0 1 r
.79478 .02664 m
.79478 .072 L
.84014 .072 L
.84014 .02664 L
F
1 0 .9 r
.84014 .02664 m
.84014 .072 L
.88549 .072 L
.88549 .02664 L
F
1 0 .6 r
.88549 .02664 m
.88549 .072 L
.93084 .072 L
.93084 .02664 L
F
1 0 .3 r
.93084 .02664 m
.93084 .072 L
.97619 .072 L
.97619 .02664 L
F
0 g
[(1)] .09184 .09014 0 0 Mshowa
[(2)] .13719 .09014 0 0 Mshowa
[(3)] .18254 .09014 0 0 Mshowa
[(4)] .22789 .09014 0 0 Mshowa
[(5)] .27324 .09014 0 0 Mshowa
[(6)] .31859 .09014 0 0 Mshowa
[(7)] .36395 .09014 0 0 Mshowa
[(8)] .4093 .09014 0 0 Mshowa
[(9)] .45465 .09014 0 0 Mshowa
[(10)] .5 .09014 0 0 Mshowa
[(11)] .54535 .09014 0 0 Mshowa
[(12)] .5907 .09014 0 0 Mshowa
[(13)] .63605 .09014 0 0 Mshowa
[(14)] .68141 .09014 0 0 Mshowa
[(15)] .72676 .09014 0 0 Mshowa
[(16)] .77211 .09014 0 0 Mshowa
[(17)] .81746 .09014 0 0 Mshowa
[(18)] .86281 .09014 0 0 Mshowa
[(19)] .90816 .09014 0 0 Mshowa
[(20)] .95351 .09014 0 0 Mshowa
[(2)] .09184 .04932 0 0 Mshowa
[(4)] .13719 .04932 0 0 Mshowa
[(8)] .18254 .04932 0 0 Mshowa
[(16)] .22789 .04932 0 0 Mshowa
[(7)] .27324 .04932 0 0 Mshowa
[(14)] .31859 .04932 0 0 Mshowa
[(3)] .36395 .04932 0 0 Mshowa
[(6)] .4093 .04932 0 0 Mshowa
[(12)] .45465 .04932 0 0 Mshowa
[(24)] .5 .04932 0 0 Mshowa
[(23)] .54535 .04932 0 0 Mshowa
[(21)] .5907 .04932 0 0 Mshowa
[(17)] .63605 .04932 0 0 Mshowa
[(9)] .68141 .04932 0 0 Mshowa
[(18)] .72676 .04932 0 0 Mshowa
[(11)] .77211 .04932 0 0 Mshowa
[(22)] .81746 .04932 0 0 Mshowa
[(19)] .86281 .04932 0 0 Mshowa
[(13)] .90816 .04932 0 0 Mshowa
[(1)] .95351 .04932 0 0 Mshowa
[(n)] .04649 .09014 0 0 Mshowa
[(g^n)] .04649 .04932 0 0 Mshowa
[(1)] .09184 1.0017 0 0 Mshowa
[(2)] .13719 1.0017 0 0 Mshowa
[(3)] .18254 1.0017 0 0 Mshowa
[(4)] .22789 1.0017 0 0 Mshowa
[(6)] .27324 1.0017 0 0 Mshowa
[(7)] .31859 1.0017 0 0 Mshowa
[(8)] .36395 1.0017 0 0 Mshowa
[(9)] .4093 1.0017 0 0 Mshowa
[(11)] .45465 1.0017 0 0 Mshowa
[(12)] .5 1.0017 0 0 Mshowa
[(13)] .54535 1.0017 0 0 Mshowa
[(14)] .5907 1.0017 0 0 Mshowa
[(16)] .63605 1.0017 0 0 Mshowa
[(17)] .68141 1.0017 0 0 Mshowa
[(18)] .72676 1.0017 0 0 Mshowa
[(19)] .77211 1.0017 0 0 Mshowa
[(21)] .81746 1.0017 0 0 Mshowa
[(22)] .86281 1.0017 0 0 Mshowa
[(23)] .90816 1.0017 0 0 Mshowa
[(24)] .95351 1.0017 0 0 Mshowa
[(2)] .09184 .95635 0 0 Mshowa
[(4)] .13719 .95635 0 0 Mshowa
[(6)] .18254 .95635 0 0 Mshowa
[(8)] .22789 .95635 0 0 Mshowa
[(12)] .27324 .95635 0 0 Mshowa
[(14)] .31859 .95635 0 0 Mshowa
[(16)] .36395 .95635 0 0 Mshowa
[(18)] .4093 .95635 0 0 Mshowa
[(22)] .45465 .95635 0 0 Mshowa
[(24)] .5 .95635 0 0 Mshowa
[(1)] .54535 .95635 0 0 Mshowa
[(3)] .5907 .95635 0 0 Mshowa
[(7)] .63605 .95635 0 0 Mshowa
[(9)] .68141 .95635 0 0 Mshowa
[(11)] .72676 .95635 0 0 Mshowa
[(13)] .77211 .95635 0 0 Mshowa
[(17)] .81746 .95635 0 0 Mshowa
[(19)] .86281 .95635 0 0 Mshowa
[(21)] .90816 .95635 0 0 Mshowa
[(23)] .95351 .95635 0 0 Mshowa
[(3)] .09184 .911 0 0 Mshowa
[(6)] .13719 .911 0 0 Mshowa
[(9)] .18254 .911 0 0 Mshowa
[(12)] .22789 .911 0 0 Mshowa
[(18)] .27324 .911 0 0 Mshowa
[(21)] .31859 .911 0 0 Mshowa
[(24)] .36395 .911 0 0 Mshowa
[(2)] .4093 .911 0 0 Mshowa
[(8)] .45465 .911 0 0 Mshowa
[(11)] .5 .911 0 0 Mshowa
[(14)] .54535 .911 0 0 Mshowa
[(17)] .5907 .911 0 0 Mshowa
[(23)] .63605 .911 0 0 Mshowa
[(1)] .68141 .911 0 0 Mshowa
[(4)] .72676 .911 0 0 Mshowa
[(7)] .77211 .911 0 0 Mshowa
[(13)] .81746 .911 0 0 Mshowa
[(16)] .86281 .911 0 0 Mshowa
[(19)] .90816 .911 0 0 Mshowa
[(22)] .95351 .911 0 0 Mshowa
[(4)] .09184 .86565 0 0 Mshowa
[(8)] .13719 .86565 0 0 Mshowa
[(12)] .18254 .86565 0 0 Mshowa
[(16)] .22789 .86565 0 0 Mshowa
[(24)] .27324 .86565 0 0 Mshowa
[(3)] .31859 .86565 0 0 Mshowa
[(7)] .36395 .86565 0 0 Mshowa
[(11)] .4093 .86565 0 0 Mshowa
[(19)] .45465 .86565 0 0 Mshowa
[(23)] .5 .86565 0 0 Mshowa
[(2)] .54535 .86565 0 0 Mshowa
[(6)] .5907 .86565 0 0 Mshowa
[(14)] .63605 .86565 0 0 Mshowa
[(18)] .68141 .86565 0 0 Mshowa
[(22)] .72676 .86565 0 0 Mshowa
[(1)] .77211 .86565 0 0 Mshowa
[(9)] .81746 .86565 0 0 Mshowa
[(13)] .86281 .86565 0 0 Mshowa
[(17)] .90816 .86565 0 0 Mshowa
[(21)] .95351 .86565 0 0 Mshowa
[(6)] .09184 .82029 0 0 Mshowa
[(12)] .13719 .82029 0 0 Mshowa
[(18)] .18254 .82029 0 0 Mshowa
[(24)] .22789 .82029 0 0 Mshowa
[(11)] .27324 .82029 0 0 Mshowa
[(17)] .31859 .82029 0 0 Mshowa
[(23)] .36395 .82029 0 0 Mshowa
[(4)] .4093 .82029 0 0 Mshowa
[(16)] .45465 .82029 0 0 Mshowa
[(22)] .5 .82029 0 0 Mshowa
[(3)] .54535 .82029 0 0 Mshowa
[(9)] .5907 .82029 0 0 Mshowa
[(21)] .63605 .82029 0 0 Mshowa
[(2)] .68141 .82029 0 0 Mshowa
[(8)] .72676 .82029 0 0 Mshowa
[(14)] .77211 .82029 0 0 Mshowa
[(1)] .81746 .82029 0 0 Mshowa
[(7)] .86281 .82029 0 0 Mshowa
[(13)] .90816 .82029 0 0 Mshowa
[(19)] .95351 .82029 0 0 Mshowa
[(7)] .09184 .77494 0 0 Mshowa
[(14)] .13719 .77494 0 0 Mshowa
[(21)] .18254 .77494 0 0 Mshowa
[(3)] .22789 .77494 0 0 Mshowa
[(17)] .27324 .77494 0 0 Mshowa
[(24)] .31859 .77494 0 0 Mshowa
[(6)] .36395 .77494 0 0 Mshowa
[(13)] .4093 .77494 0 0 Mshowa
[(2)] .45465 .77494 0 0 Mshowa
[(9)] .5 .77494 0 0 Mshowa
[(16)] .54535 .77494 0 0 Mshowa
[(23)] .5907 .77494 0 0 Mshowa
[(12)] .63605 .77494 0 0 Mshowa
[(19)] .68141 .77494 0 0 Mshowa
[(1)] .72676 .77494 0 0 Mshowa
[(8)] .77211 .77494 0 0 Mshowa
[(22)] .81746 .77494 0 0 Mshowa
[(4)] .86281 .77494 0 0 Mshowa
[(11)] .90816 .77494 0 0 Mshowa
[(18)] .95351 .77494 0 0 Mshowa
[(8)] .09184 .72959 0 0 Mshowa
[(16)] .13719 .72959 0 0 Mshowa
[(24)] .18254 .72959 0 0 Mshowa
[(7)] .22789 .72959 0 0 Mshowa
[(23)] .27324 .72959 0 0 Mshowa
[(6)] .31859 .72959 0 0 Mshowa
[(14)] .36395 .72959 0 0 Mshowa
[(22)] .4093 .72959 0 0 Mshowa
[(13)] .45465 .72959 0 0 Mshowa
[(21)] .5 .72959 0 0 Mshowa
[(4)] .54535 .72959 0 0 Mshowa
[(12)] .5907 .72959 0 0 Mshowa
[(3)] .63605 .72959 0 0 Mshowa
[(11)] .68141 .72959 0 0 Mshowa
[(19)] .72676 .72959 0 0 Mshowa
[(2)] .77211 .72959 0 0 Mshowa
[(18)] .81746 .72959 0 0 Mshowa
[(1)] .86281 .72959 0 0 Mshowa
[(9)] .90816 .72959 0 0 Mshowa
[(17)] .95351 .72959 0 0 Mshowa
[(9)] .09184 .68424 0 0 Mshowa
[(18)] .13719 .68424 0 0 Mshowa
[(2)] .18254 .68424 0 0 Mshowa
[(11)] .22789 .68424 0 0 Mshowa
[(4)] .27324 .68424 0 0 Mshowa
[(13)] .31859 .68424 0 0 Mshowa
[(22)] .36395 .68424 0 0 Mshowa
[(6)] .4093 .68424 0 0 Mshowa
[(24)] .45465 .68424 0 0 Mshowa
[(8)] .5 .68424 0 0 Mshowa
[(17)] .54535 .68424 0 0 Mshowa
[(1)] .5907 .68424 0 0 Mshowa
[(19)] .63605 .68424 0 0 Mshowa
[(3)] .68141 .68424 0 0 Mshowa
[(12)] .72676 .68424 0 0 Mshowa
[(21)] .77211 .68424 0 0 Mshowa
[(14)] .81746 .68424 0 0 Mshowa
[(23)] .86281 .68424 0 0 Mshowa
[(7)] .90816 .68424 0 0 Mshowa
[(16)] .95351 .68424 0 0 Mshowa
[(11)] .09184 .63889 0 0 Mshowa
[(22)] .13719 .63889 0 0 Mshowa
[(8)] .18254 .63889 0 0 Mshowa
[(19)] .22789 .63889 0 0 Mshowa
[(16)] .27324 .63889 0 0 Mshowa
[(2)] .31859 .63889 0 0 Mshowa
[(13)] .36395 .63889 0 0 Mshowa
[(24)] .4093 .63889 0 0 Mshowa
[(21)] .45465 .63889 0 0 Mshowa
[(7)] .5 .63889 0 0 Mshowa
[(18)] .54535 .63889 0 0 Mshowa
[(4)] .5907 .63889 0 0 Mshowa
[(1)] .63605 .63889 0 0 Mshowa
[(12)] .68141 .63889 0 0 Mshowa
[(23)] .72676 .63889 0 0 Mshowa
[(9)] .77211 .63889 0 0 Mshowa
[(6)] .81746 .63889 0 0 Mshowa
[(17)] .86281 .63889 0 0 Mshowa
[(3)] .90816 .63889 0 0 Mshowa
[(14)] .95351 .63889 0 0 Mshowa
[(12)] .09184 .59354 0 0 Mshowa
[(24)] .13719 .59354 0 0 Mshowa
[(11)] .18254 .59354 0 0 Mshowa
[(23)] .22789 .59354 0 0 Mshowa
[(22)] .27324 .59354 0 0 Mshowa
[(9)] .31859 .59354 0 0 Mshowa
[(21)] .36395 .59354 0 0 Mshowa
[(8)] .4093 .59354 0 0 Mshowa
[(7)] .45465 .59354 0 0 Mshowa
[(19)] .5 .59354 0 0 Mshowa
[(6)] .54535 .59354 0 0 Mshowa
[(18)] .5907 .59354 0 0 Mshowa
[(17)] .63605 .59354 0 0 Mshowa
[(4)] .68141 .59354 0 0 Mshowa
[(16)] .72676 .59354 0 0 Mshowa
[(3)] .77211 .59354 0 0 Mshowa
[(2)] .81746 .59354 0 0 Mshowa
[(14)] .86281 .59354 0 0 Mshowa
[(1)] .90816 .59354 0 0 Mshowa
[(13)] .95351 .59354 0 0 Mshowa
[(13)] .09184 .54819 0 0 Mshowa
[(1)] .13719 .54819 0 0 Mshowa
[(14)] .18254 .54819 0 0 Mshowa
[(2)] .22789 .54819 0 0 Mshowa
[(3)] .27324 .54819 0 0 Mshowa
[(16)] .31859 .54819 0 0 Mshowa
[(4)] .36395 .54819 0 0 Mshowa
[(17)] .4093 .54819 0 0 Mshowa
[(18)] .45465 .54819 0 0 Mshowa
[(6)] .5 .54819 0 0 Mshowa
[(19)] .54535 .54819 0 0 Mshowa
[(7)] .5907 .54819 0 0 Mshowa
[(8)] .63605 .54819 0 0 Mshowa
[(21)] .68141 .54819 0 0 Mshowa
[(9)] .72676 .54819 0 0 Mshowa
[(22)] .77211 .54819 0 0 Mshowa
[(23)] .81746 .54819 0 0 Mshowa
[(11)] .86281 .54819 0 0 Mshowa
[(24)] .90816 .54819 0 0 Mshowa
[(12)] .95351 .54819 0 0 Mshowa
[(14)] .09184 .50283 0 0 Mshowa
[(3)] .13719 .50283 0 0 Mshowa
[(17)] .18254 .50283 0 0 Mshowa
[(6)] .22789 .50283 0 0 Mshowa
[(9)] .27324 .50283 0 0 Mshowa
[(23)] .31859 .50283 0 0 Mshowa
[(12)] .36395 .50283 0 0 Mshowa
[(1)] .4093 .50283 0 0 Mshowa
[(4)] .45465 .50283 0 0 Mshowa
[(18)] .5 .50283 0 0 Mshowa
[(7)] .54535 .50283 0 0 Mshowa
[(21)] .5907 .50283 0 0 Mshowa
[(24)] .63605 .50283 0 0 Mshowa
[(13)] .68141 .50283 0 0 Mshowa
[(2)] .72676 .50283 0 0 Mshowa
[(16)] .77211 .50283 0 0 Mshowa
[(19)] .81746 .50283 0 0 Mshowa
[(8)] .86281 .50283 0 0 Mshowa
[(22)] .90816 .50283 0 0 Mshowa
[(11)] .95351 .50283 0 0 Mshowa
[(16)] .09184 .45748 0 0 Mshowa
[(7)] .13719 .45748 0 0 Mshowa
[(23)] .18254 .45748 0 0 Mshowa
[(14)] .22789 .45748 0 0 Mshowa
[(21)] .27324 .45748 0 0 Mshowa
[(12)] .31859 .45748 0 0 Mshowa
[(3)] .36395 .45748 0 0 Mshowa
[(19)] .4093 .45748 0 0 Mshowa
[(1)] .45465 .45748 0 0 Mshowa
[(17)] .5 .45748 0 0 Mshowa
[(8)] .54535 .45748 0 0 Mshowa
[(24)] .5907 .45748 0 0 Mshowa
[(6)] .63605 .45748 0 0 Mshowa
[(22)] .68141 .45748 0 0 Mshowa
[(13)] .72676 .45748 0 0 Mshowa
[(4)] .77211 .45748 0 0 Mshowa
[(11)] .81746 .45748 0 0 Mshowa
[(2)] .86281 .45748 0 0 Mshowa
[(18)] .90816 .45748 0 0 Mshowa
[(9)] .95351 .45748 0 0 Mshowa
[(17)] .09184 .41213 0 0 Mshowa
[(9)] .13719 .41213 0 0 Mshowa
[(1)] .18254 .41213 0 0 Mshowa
[(18)] .22789 .41213 0 0 Mshowa
[(2)] .27324 .41213 0 0 Mshowa
[(19)] .31859 .41213 0 0 Mshowa
[(11)] .36395 .41213 0 0 Mshowa
[(3)] .4093 .41213 0 0 Mshowa
[(12)] .45465 .41213 0 0 Mshowa
[(4)] .5 .41213 0 0 Mshowa
[(21)] .54535 .41213 0 0 Mshowa
[(13)] .5907 .41213 0 0 Mshowa
[(22)] .63605 .41213 0 0 Mshowa
[(14)] .68141 .41213 0 0 Mshowa
[(6)] .72676 .41213 0 0 Mshowa
[(23)] .77211 .41213 0 0 Mshowa
[(7)] .81746 .41213 0 0 Mshowa
[(24)] .86281 .41213 0 0 Mshowa
[(16)] .90816 .41213 0 0 Mshowa
[(8)] .95351 .41213 0 0 Mshowa
[(18)] .09184 .36678 0 0 Mshowa
[(11)] .13719 .36678 0 0 Mshowa
[(4)] .18254 .36678 0 0 Mshowa
[(22)] .22789 .36678 0 0 Mshowa
[(8)] .27324 .36678 0 0 Mshowa
[(1)] .31859 .36678 0 0 Mshowa
[(19)] .36395 .36678 0 0 Mshowa
[(12)] .4093 .36678 0 0 Mshowa
[(23)] .45465 .36678 0 0 Mshowa
[(16)] .5 .36678 0 0 Mshowa
[(9)] .54535 .36678 0 0 Mshowa
[(2)] .5907 .36678 0 0 Mshowa
[(13)] .63605 .36678 0 0 Mshowa
[(6)] .68141 .36678 0 0 Mshowa
[(24)] .72676 .36678 0 0 Mshowa
[(17)] .77211 .36678 0 0 Mshowa
[(3)] .81746 .36678 0 0 Mshowa
[(21)] .86281 .36678 0 0 Mshowa
[(14)] .90816 .36678 0 0 Mshowa
[(7)] .95351 .36678 0 0 Mshowa
[(19)] .09184 .32143 0 0 Mshowa
[(13)] .13719 .32143 0 0 Mshowa
[(7)] .18254 .32143 0 0 Mshowa
[(1)] .22789 .32143 0 0 Mshowa
[(14)] .27324 .32143 0 0 Mshowa
[(8)] .31859 .32143 0 0 Mshowa
[(2)] .36395 .32143 0 0 Mshowa
[(21)] .4093 .32143 0 0 Mshowa
[(9)] .45465 .32143 0 0 Mshowa
[(3)] .5 .32143 0 0 Mshowa
[(22)] .54535 .32143 0 0 Mshowa
[(16)] .5907 .32143 0 0 Mshowa
[(4)] .63605 .32143 0 0 Mshowa
[(23)] .68141 .32143 0 0 Mshowa
[(17)] .72676 .32143 0 0 Mshowa
[(11)] .77211 .32143 0 0 Mshowa
[(24)] .81746 .32143 0 0 Mshowa
[(18)] .86281 .32143 0 0 Mshowa
[(12)] .90816 .32143 0 0 Mshowa
[(6)] .95351 .32143 0 0 Mshowa
[(21)] .09184 .27608 0 0 Mshowa
[(17)] .13719 .27608 0 0 Mshowa
[(13)] .18254 .27608 0 0 Mshowa
[(9)] .22789 .27608 0 0 Mshowa
[(1)] .27324 .27608 0 0 Mshowa
[(22)] .31859 .27608 0 0 Mshowa
[(18)] .36395 .27608 0 0 Mshowa
[(14)] .4093 .27608 0 0 Mshowa
[(6)] .45465 .27608 0 0 Mshowa
[(2)] .5 .27608 0 0 Mshowa
[(23)] .54535 .27608 0 0 Mshowa
[(19)] .5907 .27608 0 0 Mshowa
[(11)] .63605 .27608 0 0 Mshowa
[(7)] .68141 .27608 0 0 Mshowa
[(3)] .72676 .27608 0 0 Mshowa
[(24)] .77211 .27608 0 0 Mshowa
[(16)] .81746 .27608 0 0 Mshowa
[(12)] .86281 .27608 0 0 Mshowa
[(8)] .90816 .27608 0 0 Mshowa
[(4)] .95351 .27608 0 0 Mshowa
[(22)] .09184 .23073 0 0 Mshowa
[(19)] .13719 .23073 0 0 Mshowa
[(16)] .18254 .23073 0 0 Mshowa
[(13)] .22789 .23073 0 0 Mshowa
[(7)] .27324 .23073 0 0 Mshowa
[(4)] .31859 .23073 0 0 Mshowa
[(1)] .36395 .23073 0 0 Mshowa
[(23)] .4093 .23073 0 0 Mshowa
[(17)] .45465 .23073 0 0 Mshowa
[(14)] .5 .23073 0 0 Mshowa
[(11)] .54535 .23073 0 0 Mshowa
[(8)] .5907 .23073 0 0 Mshowa
[(2)] .63605 .23073 0 0 Mshowa
[(24)] .68141 .23073 0 0 Mshowa
[(21)] .72676 .23073 0 0 Mshowa
[(18)] .77211 .23073 0 0 Mshowa
[(12)] .81746 .23073 0 0 Mshowa
[(9)] .86281 .23073 0 0 Mshowa
[(6)] .90816 .23073 0 0 Mshowa
[(3)] .95351 .23073 0 0 Mshowa
[(23)] .09184 .18537 0 0 Mshowa
[(21)] .13719 .18537 0 0 Mshowa
[(19)] .18254 .18537 0 0 Mshowa
[(17)] .22789 .18537 0 0 Mshowa
[(13)] .27324 .18537 0 0 Mshowa
[(11)] .31859 .18537 0 0 Mshowa
[(9)] .36395 .18537 0 0 Mshowa
[(7)] .4093 .18537 0 0 Mshowa
[(3)] .45465 .18537 0 0 Mshowa
[(1)] .5 .18537 0 0 Mshowa
[(24)] .54535 .18537 0 0 Mshowa
[(22)] .5907 .18537 0 0 Mshowa
[(18)] .63605 .18537 0 0 Mshowa
[(16)] .68141 .18537 0 0 Mshowa
[(14)] .72676 .18537 0 0 Mshowa
[(12)] .77211 .18537 0 0 Mshowa
[(8)] .81746 .18537 0 0 Mshowa
[(6)] .86281 .18537 0 0 Mshowa
[(4)] .90816 .18537 0 0 Mshowa
[(2)] .95351 .18537 0 0 Mshowa
[(24)] .09184 .14002 0 0 Mshowa
[(23)] .13719 .14002 0 0 Mshowa
[(22)] .18254 .14002 0 0 Mshowa
[(21)] .22789 .14002 0 0 Mshowa
[(19)] .27324 .14002 0 0 Mshowa
[(18)] .31859 .14002 0 0 Mshowa
[(17)] .36395 .14002 0 0 Mshowa
[(16)] .4093 .14002 0 0 Mshowa
[(14)] .45465 .14002 0 0 Mshowa
[(13)] .5 .14002 0 0 Mshowa
[(12)] .54535 .14002 0 0 Mshowa
[(11)] .5907 .14002 0 0 Mshowa
[(9)] .63605 .14002 0 0 Mshowa
[(8)] .68141 .14002 0 0 Mshowa
[(7)] .72676 .14002 0 0 Mshowa
[(6)] .77211 .14002 0 0 Mshowa
[(4)] .81746 .14002 0 0 Mshowa
[(3)] .86281 .14002 0 0 Mshowa
[(2)] .90816 .14002 0 0 Mshowa
[(1)] .95351 .14002 0 0 Mshowa
[(1)] .04649 1.0017 0 0 Mshowa
[(2)] .04649 .95635 0 0 Mshowa
[(3)] .04649 .911 0 0 Mshowa
[(4)] .04649 .86565 0 0 Mshowa
[(6)] .04649 .82029 0 0 Mshowa
[(7)] .04649 .77494 0 0 Mshowa
[(8)] .04649 .72959 0 0 Mshowa
[(9)] .04649 .68424 0 0 Mshowa
[(11)] .04649 .63889 0 0 Mshowa
[(12)] .04649 .59354 0 0 Mshowa
[(13)] .04649 .54819 0 0 Mshowa
[(14)] .04649 .50283 0 0 Mshowa
[(16)] .04649 .45748 0 0 Mshowa
[(17)] .04649 .41213 0 0 Mshowa
[(18)] .04649 .36678 0 0 Mshowa
[(19)] .04649 .32143 0 0 Mshowa
[(21)] .04649 .27608 0 0 Mshowa
[(22)] .04649 .23073 0 0 Mshowa
[(23)] .04649 .18537 0 0 Mshowa
[(24)] .04649 .14002 0 0 Mshowa
[(1)] .09184 1.04705 0 0 Mshowa
[(2)] .13719 1.04705 0 0 Mshowa
[(3)] .18254 1.04705 0 0 Mshowa
[(4)] .22789 1.04705 0 0 Mshowa
[(6)] .27324 1.04705 0 0 Mshowa
[(7)] .31859 1.04705 0 0 Mshowa
[(8)] .36395 1.04705 0 0 Mshowa
[(9)] .4093 1.04705 0 0 Mshowa
[(11)] .45465 1.04705 0 0 Mshowa
[(12)] .5 1.04705 0 0 Mshowa
[(13)] .54535 1.04705 0 0 Mshowa
[(14)] .5907 1.04705 0 0 Mshowa
[(16)] .63605 1.04705 0 0 Mshowa
[(17)] .68141 1.04705 0 0 Mshowa
[(18)] .72676 1.04705 0 0 Mshowa
[(19)] .77211 1.04705 0 0 Mshowa
[(21)] .81746 1.04705 0 0 Mshowa
[(22)] .86281 1.04705 0 0 Mshowa
[(23)] .90816 1.04705 0 0 Mshowa
[(24)] .95351 1.04705 0 0 Mshowa
[(U[25])] .02381 1.0924 -1 0 Mshowa
gsave
.97619 1.0924 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .03923 1.03934 0 0 Mshowa
[(y)] .05782 1.05612 0 0 Mshowa
1 Mabswid
[ ] 0 setdash
.02381 .11735 m
.02381 1.06973 L
s
.02381 .11735 m
.97619 .11735 L
s
.02381 .1627 m
.97619 .1627 L
s
.02381 .20805 m
.97619 .20805 L
s
.02381 .2534 m
.97619 .2534 L
s
.02381 .29875 m
.97619 .29875 L
s
.02381 .3441 m
.97619 .3441 L
s
.02381 .38946 m
.97619 .38946 L
s
.02381 .43481 m
.97619 .43481 L
s
.02381 .48016 m
.97619 .48016 L
s
.02381 .52551 m
.97619 .52551 L
s
.02381 .57086 m
.97619 .57086 L
s
.02381 .61621 m
.97619 .61621 L
s
.02381 .66156 m
.97619 .66156 L
s
.02381 .70692 m
.97619 .70692 L
s
.02381 .75227 m
.97619 .75227 L
s
.02381 .79762 m
.97619 .79762 L
s
.02381 .84297 m
.97619 .84297 L
s
.02381 .88832 m
.97619 .88832 L
s
.02381 .93367 m
.97619 .93367 L
s
.02381 .97902 m
.97619 .97902 L
s
.02381 1.02438 m
.97619 1.02438 L
s
.02381 1.06973 m
.97619 1.06973 L
s
.06916 .11735 m
.06916 1.06973 L
s
.11451 .11735 m
.11451 1.06973 L
s
.15986 .11735 m
.15986 1.06973 L
s
.20522 .11735 m
.20522 1.06973 L
s
.25057 .11735 m
.25057 1.06973 L
s
.29592 .11735 m
.29592 1.06973 L
s
.34127 .11735 m
.34127 1.06973 L
s
.38662 .11735 m
.38662 1.06973 L
s
.43197 .11735 m
.43197 1.06973 L
s
.47732 .11735 m
.47732 1.06973 L
s
.52268 .11735 m
.52268 1.06973 L
s
.56803 .11735 m
.56803 1.06973 L
s
.61338 .11735 m
.61338 1.06973 L
s
.65873 .11735 m
.65873 1.06973 L
s
.70408 .11735 m
.70408 1.06973 L
s
.74943 .11735 m
.74943 1.06973 L
s
.79478 .11735 m
.79478 1.06973 L
s
.84014 .11735 m
.84014 1.06973 L
s
.88549 .11735 m
.88549 1.06973 L
s
.93084 .11735 m
.93084 1.06973 L
s
.97619 .11735 m
.97619 1.06973 L
s
.02381 1.06973 m
.06916 1.02438 L
s
2.6 Mabswid
.06916 .11735 m
.06916 1.06973 L
s
.02381 1.02438 m
.97619 1.02438 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[43]:=",
  ImageSize->{257.312, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400041000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l00P000?l00P000?l00P000?l00P000?l0
0P000?l00P000?l00P000?l00P00014032<;G`0<WenOGimOWenOGimO3Ml05N;Oh]oRgn;Oh]oRdN;A
h]7RdN;AhP02d@0:d=7@dM3Ad=7@d@c@00_P2>08h0SP2>08h00<20`13L002X30P<20`830P<0=@00:
@D11@450@D11@09101EB@E91DT5B@E91DTmBCe9?DTmBCe8034l02cl_?blo;cl_?blo00d_1`0000@0
0ol:00`S2el<W`0FgioOWmnOgioOWmnOh]oRgn;Oh]oRg`;R027Ah]7RdN;Ah]7RdM3Ad=7@dM3Ad=7@
dN3@h=3Pd>3@h=003N0;20`13<0;P00i@810P420@810P420@D11@450@D11@450@E91DT5B@E91DT5?
DTmBCe9?DTmBCe8oCcm??dloCcm?00do32l700001`000ol0000700`S2el039mOWenOGimOWenOG`gO
01GRgn;Oh]oRgn;Oh]7RdN;Ah]7RdN800]402]3Ad=7@dM3Ad=4<d00;h0SP2>08h0SP2>0030P<0@g0
00Z0`830P<20`8303D002T50@D11@450@D02@@0EDT5B@E91DT5B@E9?DTmBCe9?DTmB00a?00/o;cl_
?blo;cl_?`0=;`L0000400Co1`02o`048ooo8`Co12<5G`?o0el5W`;o1Il02=oooooOWmnO0_l03=nO
h]oRgn;oh]oRg`;R0ol01>;Ah]43o`05dM3Ad=400ol02M7@dM3Ah=3Pd002o`04h=3Pd0;P0ol3h0Co
00?P2?l00ol320?o00<1ool00_l20@?o0P400l3oo`02o`;00ol2`004P?ooo`B000OoP810P42000?o
00J0@810P443o`04@D11@0;o00=1@?l00_l00e91DP03o`03DT5?00Co00=BCol00ol00e8oo`02o`03
?dlo00?o0Sl3o`<o0ol2?`@_0ol5;`L000030005o`000?l01`001?l08ol38`03ob<S00@S1Ul00omO
G`02G`0<WenOGomOWonOGimO0]l00ooOg`02g`04omoOo`;O01GRgn;OomoRgn;Oh]7odN;Ah]7Ron80
0]402]3Ad=7@dOoAd=44d004om3@o`C@00_P2?l8h0SP2?l8h0032003o`P800@800Go2041o`070@05
o`70`?l01L000oo0`002`00:P?n0`830P?n0`0M000?o@4000d002T7o@D11@?m0@Ol2@@0Eod5B@E91
od5B@E9?odmBCe9?odmB00=?00?oCdl01Dl03?lo;ol_?blo;cl_o`H_00?o;bl012l700000`001Ol0
003o00L000Co02?o12<00olS8`038`AO1?l3G`BO00CoWioo19l05]nOoioOWmoogiooWn;Oh]oRgooO
h]l2hP06dOoAh]7R1?l05m7@dM3Ad=7@om3Ad=7Pd>3oh=3od>3@00?P00?oh>001>000ooPh0032004
o`P820Co0`400ol10@040@03o`7000;000?o`<000/001?o0`<02P003oh2000B000OoP420@81000?o
02m0P420@D3o@450@Om1@?m0@Om1DT5B@Om1DT5?DTooCe9?DTooCe8oCom??dloC`03o`8o00?o?cl0
1Cl00olo;`04;`03obl_00@_1`0000<000Go0000o`070004o`0So`DS00?o8b<00R<4G`03oeoo00AO
00FOGimOW`02o`05GimOWel00]l00ooOg`02g`?o0ml05N;Oh]oRon;Oh]oRdOoAh]7Ron;ohP02d@04
d=7@d@;o00C@dM3A1=03o`G@00_P2?l8h0SP2>08o`052007o`P8o`So20040@04o`410@;o0P44`005
ol30`?l01<002X3oP<20`830ol04@004od10o`E000M1od50@D1100;o01Q0@D7o@E91DT7o@E91DTmB
Com?DTmBCol3C`03odm?009?00coCdoo?boo;cl_?bl2o`03?bl_00@_00?o;bl012l700001005o`D0
1Ol28`04ob<So`@S15l00omOo`04G`BO00CoWioo19l05]nOoioOWmoogioOWn;Oh]oRgn;oh]l2hP0Q
dOoAh]7Ron;oh]7@dM3Ad=7@om3Ad=7Pd>3oh=3Pd>3@00?P00?oh>000^001ooPh?oP2?l00PP02Ol8
2?l8o`P1o`020@03o`4100<100Co0L3o0/001Oo0`<3o00?00X000on0P005P00kod20@83oP43o@810
P450od11@47o@D3o@47o@E91DT7o@E91Com?D_mBCom?D_mB?dooCcm??oloCol00Sl00olo?`05?`03
ocl_00@_00?o;bl012l700002@000ol0o`0500DS0_l58`EO0_l4G`05WenOGil00_l01UnOGimOg`;o
1Ml3o`;O00?Rgn801?l01=oRgn82o`05dN;Ah]400_l01^;AdM3Ad0?o00C@dM3A1M03o`C@00SPool8
h0SP20;o00CP20P80_l420;o00<80@400_l30@?o0P42`0;o0l02o`C00_l01830P<04o`E00_l6@0;o
00E1@450@@02o`08@47ood5B@E82o`05@E91DTl00_l0159?DTl2o`03DTm?00;o1Dl2o`08Ccoooblo
;cl3o`03?bl_00<_0_l6;`L0000:0003o`0000@032<;G`bO01KOWmnOgioOWmnOgioRgn;Oh]oRgn;O
0^808M7RdN;Ah]7RdN;Ad=7@dM3Ad=7@dM3Ah=3Pd>3@h=3Pd00=h0/8304<`0^003U0P420@810P420
@811@450@D11@450@D11DT5B@E91DT5B@DmBCe9?DTmBCe9?DSm??dloCcm??dl03Cl<;`L0000A00`S
2el039mOWenOGimOWenOG`gO01GRgn;Oh]oRgn;Oh]7RdN;Ah]7RdN800]402]3Ad=7@dM3Ad=4<d00;
h0SP2>08h0SP2>0030P<0@g000Z0`830P<20`8303D002T50@D11@450@D02@@0EDT5B@E91DT5B@E9?
DTmBCe9?DTmB00a?00/o;cl_?blo;cl_?`0=;`L0000A00`S2el<W`0FgioOWmnOgioOWmnOh]oRgn;O
h]oRg`;R027Ah]7RdN;Ah]7RdM3Ad=7@dM3Ad=7@dN3@h=3Pd>3@h=003N0;20`13<0;P00i@810P420
@810P420@D11@450@D11@450@E91DT5B@E91DT5?DTmBCe9?DTmBCe8oCcm??dloCcm?00do32l70000
o`020000o`0200002@02o`030?oo00L00ol900Co1`03o`X00ol800?o2@02o`X000?o00002002o`T0
0ol600?o1002o`800ol300?o0`03o`<01?l200?o0`03o`800ol400?o0P03o`<00ol200?o1002o`<0
0ol40003o`0000800ol400;o0P03o`<00ol300Co0`02o`T000090004o`00o`T000?o00002@000ol0
000:0003o`0000P000?o00002P000ol000050004o`00o`T000?o00001`001?l00?l;0003o`0000@0
00?o00000P001?l00?l20003o`0000<000?o00000`000ol000030003o`0000<000?o00001@001?l0
0?l60003o`00008000?o00001@001?l00?l40004o`00o`<000?o00000`000ol000030003o`000080
00Co003o0P000ol000050005o`000?l010001?l00?l800002@001?l00?l90003o`0000X000?o0000
2@000ol0000600Co2`000ol000050004o`00o`X000?o00001P001?l00?l900?o1P000ol000020004
o`00o`8000?o00000`000ol000030003o`0000@000?o00000P000ol000050004o`00o`@01?l30003
o`0000D000Co003o10001?l00?l30003o`0000@000?o00000P000ol000020004o`00o`8000?o0000
0`03o`@000Go0000o`020003o`0000H000090004o`00o`T000?o00002`000ol0000600;o2@000ol0
o`0900?o2003o`/000?o00001`02o`T000Co003o1P000ol000020004o`00o`8000?o00000`000ol0
00030003o`0000D000Go0000o`0500;o0`000ol000020003o`3o00@000?o00000P03o`<000?o0000
0P03o`@000?o000010000ol000020003o`0000<00_l30003o`00008000Co003o1@001?l00?l20003
o`0000H0000800Go2@000ol000080004o`00o`X000?o00001P000ol0o`090003o`0000P000?o0000
30000ol000050004o`00o`P000Co003o1P000ol000020004o`00o`8000?o00000`000ol000030003
o`00008000Co003o0`000ol000050004o`00o`@000?o0?l010000ol000020003o`0000<000?o0000
0P000ol000040003o`0000D000Go0000o`040004o`00o`8000?o00000P001?l00?l20004o`00o`80
00Co003o200001D00_l;00;o2003o`X00_l900Co2003o`P01?l800;o2P02o`H00_l500;o0P02o`@0
0_l400;o1@02o`<00_l400?o0P02o`D00_l300;o1004o`030?oo00D00ol200;o1004o`800_l500;o
0P02o`D00_l400;o1002o`T0003o0080003o0080003o008000060?Go1P0000H000?o00001`02o`/0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000@0000600Co0`09o`<00ol00`3oo`03o`80
0ol00`3oo`03o`801?l00`3oo`03o`800ol200Co0`03o`030?oo00;o1002o`801?l40004o`0000?o
1002o`801?l400?o00<0ool00_l300?o00<0ool00_l300Co00<0ool00_l300?o0P001?l00003o`@0
00?o00000P02o`D000?o00000P000ol000040004o`0000;o1@000ol0000200?o10001?l00003o`@0
00Co00001?l40004o`0000?o1@000ol0000400001P02o`H000Ko0?oo0?l60006o`00o`3o1`02o`03
0?l000@000Oo0000o`3o00D000Oo0000o`3o00L00_l00`3o00030008o`00o`3o0?l50004o`0000;o
10002?l00?l0o`3o1P001_l00?l0o`L00_l00`3o00040007o`000?l0o`050005o`000?l01P001Ol0
003o00<000Co003o10000ol000020003o`0000@000Co003o0P000ol000020003o`0000<000?o0000
0`000ol000040005o`000?l010000ol000040003o`00008000?o000010000ol0000400001P000ol0
o`0300Ko0P001?l00004o`050?l00?l01P02o`8000?o00000`001?l00?l20003o`00008000Oo0000
o`3o00D01?l00`3o00030008o`00o`3o0?l60003o`0000;o10002?l00?l0o`3o1004o`040?l0o`L0
0_l00`3o00050006o`00o`3o1@001Ol0003o00@00ol30005o`000?l00P000ol000020003o`0000<0
00?o00000`001?l00?l20003o`00008000Co00001?l40003o`0000@000Go0000o`050003o`0000<0
00?o00000P000ol000040003o`0000@000060004o`00o`8000Co0?l00_l30006o`00o`3o0P001Ol0
003o00<00_l00`3o00020003o`0000<000?o0?l00`001Ol0003o00<000?o0?l010000ol00002o`03
0?l000@00_l20003o`3o00H000?o00000_l400?o0P000ol0o`040003o`3o008000?o0?l01@02o`04
0?l0o`L000Go0?l0o`050005o`000?l00`001?l00?l30003o`0000800_l50003o`0000<000?o0000
0`000ol00003o`D000Oo0000o`3o00D000?o00000P02o`@000?o000010000ol000020003o`000080
00?o000010000ol0000400001P001?l00?l20004o`3o00?o0P001_l00?l0o`800_l20003o`0000<0
0ol20004o`00o`8000Co0?oo0P001Ol0003o00<000?o0?l010000ol00002o`030?l000<000So003o
0?l0o`L000Co0?oo10000ol000020003o`3o00@000?o0?l00P000ol0o`0700;o00<0o`000`002?l0
0?l0o`3o1@001Ol0003o00<000Co003o0`001Ol0003o008000?o00000P000ol000040003o`000080
00Co003o1`001ol0003o0?l01@000ol000040005o`000?l00`001?l00?l40003o`00008000?o0000
10000ol0000400001P03o`@00_l0103oo`02o`@00_l20004o`3oo`<00ol00`3o0002o`@00_l20004
o`3oo`<00_l300?o1@02o`040?ooo`D00_l200?o1004o`030?oo00D00ol0103oool500;o0P03o`@0
0ol0103oool500;o0P03o`@00_l30003o`0000800_l40003o`0000800_l50004o`0000Co10001?l0
0003o`@000?o00000P02o`D000Co00000ol40003o`0000800_l50004o`0000;o1P000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060003
o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H0mOl60000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060003
o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H000?o0000
1`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P04o`800ol00`3o
o`04o`800ol200Go0P03o`030?oo00;o0`03o`801?l40004o`0000Co0`03o`030?oo00;o0`03o`80
00Co00000ol50005o`000?l01P001?l00003o`D000Co00000ol400Go0`03o`030?oo00?o0P04o`03
0?oo00;o1002o`030?oo00;o1002o`801?l400?o00@0oooo0`04o`030?l000<00_l50003o`000080
0_l40003o`0000800ol40004o`0000Co10000ol0000400001P02o`L00ol00`3o00060005o`3o0?l0
1@001_l00?l0o`L000Go0?l0o`050007o`000?l0o`0700;o00<0o`0010001Ol0003o00H000?o0000
0P001Ol0003o00H000?o000010000ol000020003o`00008000?o00000`000ol0o`060006o`00o`3o
1@001ol0003o0?l010000ol00002o`030?l000<000So003o0?l0o`H000?o00000_l50005o`000?l0
0`001?l00?l40005o`000?l00P001Ol0003o00D000?o00000`000ol000020003o`0000@000?o0000
100000H000?o0?l01P03o`8000?o000010000ol0o`020003o`00008000Ko003o0?l500?o00@0o`3o
1P001_l00?l0o`L00_l00`3o00040005o`000?l01003o`@000?o00000P000ol000030003o`0000@0
00?o00000P000ol000020003o`0000<000Co003o0`04o`050?l00?l01@001_l00?l0o`@000?o0000
0_l00`3o00030008o`00o`3o0?l400Co00<0ool01P001?l00?l30004o`00o`@000Go0000o`020005
o`000?l00`04o`@000?o00000`000ol000030003o`0000@000060004o`00o`<00_l00`3oo`030004
o`0000;o0P001Ol0003o00<000Ko003o0?l40008o`00o`3o0?l60006o`00o`3o1@02o`040?l0o`D0
00Go0000o`030004o`00o`@000?o00000P000ol000030003o`0000800_l50003o`00008000?o0000
0`001Ol0003o008000?o0?l00P001Ol0003o00D000Go0?l0o`0500;o00@0o`3o1003o`8000?o0?l0
10000ol0o`0200;o1`000ol0o`0400;o1@001?l00003o`@000Oo0000o`3o00D000?o000010000ol0
00020003o`0000@000060004o`00o`D01?l20003o`0000<000Co0?oo0P001Ol0003o008000?o0?l0
10002?l00?l0o`3o1`001Ol0o`3o00L00_l00`3o00040005o`000?l00`001?l00?l40003o`0000<0
00?o00000P000ol000040003o`00008000?o00000P000ol0000300;o0P001_l00?l0o`800_l20004
o`00o`8000Go0?l0o`040003o`0000;o00<0o`000`000ol000020003o`3o00@000?o0?l00P02o`@0
00Ko003o0?l30004o`00o`@000Go0000o`060007o`000?l0o`050005o`000?l00P000ol000020003
o`0000@0000600?o0`03o`040?oo00;o0`03o`8000Co0?oo0`02o`800ol500;o0P03o`@01?l0103o
ool400?o00@0oooo1002o`<000?o00000P02o`D000?o00001?l40004o`0000?o1@001?l00002o`D0
00Co0?oo1002o`8000Co0?oo1002o`800ol500;o00@0oooo1@03o`040?ooo`D00_l200;o1@02o`80
00?o00000P02o`D000?o00000P03o`<000?o00000P02o`D000?o00000P02o`D000?o0000100000H0
00?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0
000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol0
00080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060?Go1P0000H0
00?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0
000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol0
00080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L0
0_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol0
00080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H01?l200[o0P04o`03
0?oo00;o0`03o`030?oo00;o1002o`801?l300?o0P000ol000020003o`0000<000?o00000P03o`@0
00Co00000ol500Co0P03o`801?l40004o`0000Co1007o`<00ol20003o`0000800_l50004o`0000Co
0`05o`<00ol00`3oo`03o`800ol200?o1002o`801?l300Co00<0o`000P03o`@000?o00000P02o`D0
00Co00000ol50003o`0000@0000600;o1@000ol00002o`030?l000@000Oo0000o`3o00L00_l00`3o
00030008o`00o`3o0?l70003o`3o00@000?o00000`000ol000030003o`0000<000?o00000P000ol0
000400;o1`001Ol0o`3o00D000Oo0000o`3o00H000Go0?l0o`050005o`000?l00`001?l00?l40003
o`00008000?o00000`000ol0o`060006o`00o`3o1@001?l00002o`@000So003o0?l0o`D000Go0000
o`060005o`000?l00`001?l00?l40003o`0000@000?o00000P000ol0000400001P000ol0o`050004
o`3oo`8000?o00000`001_l00?l0o`D01?l00`3o00030008o`00o`3o0?l70003o`3o00D000?o0000
0P001?l00004o`@000?o00000P000ol000040003o`3o00H000Go0?l0o`060006o`00o`3o1005o`03
0?l000@000Go0000o`030004o`00o`@000?o00000`000ol000020004o`00o`<01?l01@3o003o00@0
00Co00000_l40008o`00o`3o0?l60004o`00o`@00ol30005o`000?l00P000ol000020003o`0000@0
00?o00000P000ol0000400001P001?l00?l500?o0`000ol000030005o`3o0?l010000ol00002o`03
0?l000<00ol20003o`3o00D00_l20003o`0000<000?o00000P001ol0003o0?l01@000ol000020003
o`0000@000Co003o0`02o`8000?o0?l01P001_l00?l0o`@000Oo0?l0o`3o00D000Go0000o`0400;o
1@000ol000040005o`000?l00`001_l00?l0o`8000Go0000o`030004o`0000;o1@02o`8000?o0?l0
1`000ol0o`030004o`00o`<000Co00000ol50003o`0000800_l50003o`0000@000060004o`00o`80
00?o00001?l20004o`00o`8000Go0?l0o`040003o`0000;o00<0o`000`000ol000020003o`3o00L0
00?o0?l01P001Ol0003o00<000?o0?l01@000ol000020003o`0000@000Co003o1@001Ol0o`3o00L0
00Go0?l0o`040007o`3o0?l0o`050005o`000?l00`001?l00?l40005o`000?l00P001?l00002o`80
00Ko003o0?l200;o0P001Ol0003o00<00_l40008o`00o`3o0?l40006o`00o`3o0`001?l00?l30005
o`000?l01`000ol000040003o`00008000?o0000100000H00ol400;o00@0ool00_l400;o0P03o`D0
0_l0103oool500?o00@0oooo1003o`8000Co00001?l30003o`0000800_l50004o`0000;o1P03o`<0
0ol200?o1004o`040?ooo`D00_l0103oool400;o0`000ol0000200;o1@000ol0000200;o10001?l0
ool400;o0P001?l0ool300;o0`02o`D00_l200?o1@02o`8000?o00000P02o`@000?o00000P03o`@0
00Co00000ol50003o`0000@000060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003
o`0000T000?o0000100000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o0000
2@000ol0000400001P3eo`H000060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003
o`0000T000?o0000100000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o0000
2@000ol0000400001P04o`800ol00`3oo`04o`800ol200Co10000ol00004o`<00ol20004o`0000?o
1@001?l00003o`@01Ol200Co00<0ool00_l400;o0P03o`@00ol00`3o000300;o1@001?l00004o`<0
1Ol200?o0P04o`<00ol200Co0`03o`030?l000<000?o000010001?l00003o`D01?l300?o00<0ool0
0_l400;o0P04o`<01Ol400;o1@000ol0000200?o10000ol0000400001P02o`D000?o00000_l00`3o
00040007o`000?l0o`050006o`00o`3o1`000ol0o`060003o`00008000?o00000P000ol000030003
o`3o00D000Oo0000o`3o00@000Go003o0002o`H000Co003o0`001?l00?l40003o`00008000?o0000
0`000ol0o`070005o`3o0?l01`001Ol0o`3o00D000Co003o10000ol000040003o`0000@000?o0000
0P02o`H000Ko003o0?l40008o`00o`3o0?l50004o`00o`<000Co003o10000ol000030003o`0000<0
00?o0000100000H000?o0?l010000ol00002o`8000?o00000P001ol0003o0?l01P001Ol0o`3o00L0
00?o0?l01003o`@000?o00000P000ol000030004o`00o`D000Ko003o0?l40005o`00o`000_l400Co
00<0o`000P001?l00?l40003o`0000<000?o00000P001?l00?l60005o`3o0?l01@03o`040?l0o`D0
00Co003o1@000ol000030003o`0000@000?o00000P000ol0o`0300Co00@0o`3o10002?l00?l0o`3o
1P000ol0o`030004o`00o`@000Co00001?l40003o`0000@000060004o`00o`<000?o00000_l30005
o`000?l00`000ol0o`060005o`3o0?l01@02o`8000Go0000o`020003o`00008000?o00000P000ol0
00030005o`000?l01@001Ol0o`3o00D00_l200;o10000ol0o`020004o`0000?o1@000ol000040005
o`000?l00`001?l00002o`8000?o0?l010002?l00?l0o`3o1@001?l00?l50003o`0000<000?o0000
0P02o`D000Co003o0P000ol0o`020003o`3o00@00ol20003o`3o00L00_l400;o1@001ol0003o0?l0
1@000ol0000400001P001?l00?l30003o`0000?o0P001Ol0003o00<000?o0?l01`02o`030?l000H0
00?o0?l00`001?l00?l40003o`00008000?o00000`02o`8000Co003o0P001Ol0o`3o00@000Go003o
0002o`@000?o0?l00P001Ol0003o00L000Go0000o`020004o`0000;o0P000ol000030005o`3o0?l0
10002?l00?l0o`3o1@001?l00?l60003o`00008000?o000010000ol000020004o`00o`8000?o0?l0
0P000ol0o`040003o`00008000?o0?l010000ol00002o`<000Co003o10001ol0003o0?l01@000ol0
000400001P03o`<00_l200;o00<0ool00`02o`<00ol400Oo1003o`8000?o00000P02o`D000Co0000
0_l50004o`3oo`@00_l200?o1@02o`800_l500;o0P000ol0000200?o10000ol0000200;o10001?l0
ool300?o0P03o`D00_l200?o1002o`8000Co00001?l40004o`0000?o1@03o`@00_l200?o1@03o`04
0?ooo`D00_l00`3o000300;o1@000ol0000200;o1@000ol0000400001P000ol0000700;o2`000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o0000100000H0mOl600001P000ol0000700;o2`000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o0000100000H000?o00001`02o`/000?o000020000ol0
00090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00080003o`0000T000?o00002@000ol0000400001P03o`<00ol00`3oo`03o`<00ol200Co0`03o`03
0?l000<000?o000010001?l00003o`D01?l400Co1002o`D000Co00001?l400Co0P03o`8000Co0000
0ol50004o`0000?o1005o`801?l00`3oo`02o`@00_l20003o`0000800ol300Go0P03o`801?l40004
o`0000?o0`03o`801Ol300?o00<0ool00_l400;o00<0ool00_l300Co00<0o`000`02o`D000?o0000
100000H00_l700?o00<0o`001P001Ol0o`3o00L00_l40003o`0000@000?o00000P000ol000040003
o`3o00H000?o0?l00`001?l00?l40003o`00008000?o00001002o`D000Go0000o`060003o`000080
00?o000010001ol0003o0?l01@001ol0003o0?l010001_l00?l0o`D000?o00000P000ol0o`070005
o`3o0?l01@001?l00002o`D000Oo0000o`3o00H000Ko003o0?l40003o`0000;o00<0o`0010001Ol0
003o00<000Co003o10000ol0000400001P02o`D01Ol00`3o000400?o00@0o`3o1`02o`D000?o0000
0`000ol000020003o`0000@000?o0?l01005o`<000Co003o10000ol000030003o`0000<000?o0?l0
10001Ol0003o00@00ol40003o`0000@000Go0000o`020003o`0000<000Ko003o0?l40006o`00o`3o
0`04o`<000Co003o1P001Ol0o`3o00H000?o00000_l50005o`000?l00P001?l00004o`040?l0o`@0
00?o00000_l00`3o00050004o`00o`<000Co003o10000ol0000400001P02o`@000?o00000ol00`3o
00030008o`00o`3o0?l500;o00<0o`0010000ol000030003o`00008000?o000010000ol0o`040005
o`3o0?l01002o`D000?o000010000ol000020004o`00o`<000Go0000o`030004o`00o`@000?o0000
0P02o`@000Go0000o`050005o`3o0?l01003o`8000Oo0000o`3o00@000Go0000o`0300;o0P000ol0
o`060003o`0000;o1@001Ol0003o00<000Ko003o0?l20003o`3o00D00_l0103o0?l70003o`3o00<0
0ol50003o`0000@0000600;o10000ol00003o`030?l000<000So003o0?l0o`L00_l60003o`000080
00?o00000P000ol000040003o`3o00@000Go0?l0o`030004o`00o`@000Go0000o`020003o`000080
00Co003o0`001Ol0003o00<000Co003o10000ol000040004o`0000;o0P001?l00?l20005o`3o0?l0
10000ol000020007o`000?l0o`0400;o0P000ol000030005o`3o0?l01`001?l0ool50004o`0000;o
0P001_l00?l0o`8000?o0?l010000ol00002o`030?l000<000Ko003o0?l30003o`0000D000?o0000
100000H00_l500;o00<0ool00_l500;o0P03o`@00ol00`3o000200Co10001?l00002o`H00ol500;o
00<0o`000`02o`D000?o00000P02o`D00ol300;o0`000ol0000200;o1@001?l00003o`@000Co0?oo
1002o`800ol500?o00<0o`000`02o`@000Co0?oo0`03o`800ol400Co00<0ool01002o`<000Co0?oo
1002o`800ol500;o00@0oooo1@02o`8000?o00000P03o`@000?o0000100000H000?o00001`02o`/0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000@000060?Go1P0000H000?o00001`02o`/0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o000020000ol000090003o`0000T000?o0000100000H00ol400;o00<0ool00ol400;o0P04o`<0
0ol00`3o000300?o1005o`801?l00`3o000300;o10001?l00003o`D01?l300?o0P03o`<01?l00`3o
o`03o`800ol200Co1002o`030?l000800ol50004o`0000Co1004o`<00ol00`3o000300;o1@05o`<0
0ol0103oool40005o`000?l00`03o`D01Ol200?o00<0ool00_l400?o00<0o`000`000ol000040003
o`0000@0000600;o10000ol00003o`030?l000<000So003o0?l0o`D000Co003o1@000ol000030003
o`3o00D000Go0000o`030004o`00o`<000?o00000P000ol000040003o`3o00L000Co0?oo1@001ol0
003o0?l01`001Ol0o`3o00@000?o00000_l60003o`00008000?o00000P000ol000040003o`3o00L0
0_l30004o`00o`@000?o0?l01P000ol00002o`D000Go0000o`060003o`00008000?o0?l01@001_l0
0?l0o`H000Co003o10000ol000040003o`0000@0000600;o10000ol00003o`030?l000<000So003o
0?l0o`D000Co003o0`04o`@000Co003o1@001?l00?l30004o`00o`<000?o00000P000ol000040003
o`3o00D00ol00`3oo`060004o`00o`8000?o000010001Ol0o`3o00@000?o00000_l400?o10000ol0
00030003o`0000<000?o0?l01`02o`<000Co003o10001?l00?l300Co00<0ool01P001?l00?l60003
o`00008000Co003o10001_l00?l0o`@01?l00`3o00040003o`0000<000?o0000100000H00_l500;o
00D0ool0o`0500;o0P000ol0o`050004o`00o`<000?o0?l01@001Ol0003o00D000?o0?l01002o`@0
00?o00000P000ol000040003o`3o00@000Go003o0002o`L000?o0?l00`001?l00002o`8000?o0?l0
1003o`030?l0008000Co003o10000ol000040003o`00008000?o0?l01@02o`030?l000800ol50005
o`000?l00P000ol0o`0200;o1P001?l00?l400;o1@001Ol0003o00<000Ko003o0?l40003o`3o0080
00?o00000`000ol000030003o`0000@0000600;o10000ol00003o`030?l000<000So003o0?l0o`D0
00Co003o0`000ol0o`0500;o0P001?l00?l20003o`3o00<000Co003o0`000ol000020003o`0000@0
00?o0?l010001Ol00?l000;o10001Ol00?l000;o0P000ol000030005o`3o0?l010001Ol0003o00<0
00Co003o10001Ol0003o008000?o00000P000ol0o`0700;o0`000ol0000500;o0P001_l00?l0o`80
0_l70003o`3o00H000?o00000P02o`8000Go0000o`020003o`3o00@000?o0?l00P000ol000040003
o`00008000?o0000100000H00_l500;o00<0ool00_l500;o0P03o`@00_l20003o`0000800_l50004
o`3oo`@00_l20003o`0000800_l40004o`0000;o1P03o`D00_l200;o1@02o`8000Co0?oo0`03o`80
0ol500Co1002o`D000?o00000P02o`D00ol400?o00<0o`000`03o`@000Co0?oo1002o`800_l400Co
00<0o`000P03o`D000Co0?oo0`02o`800ol500;o0P001?l00004o`@000?o0000100000H000?o0000
1`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P3eo`H000060003
o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H000?o0000
1`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o
2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000@0000600?o10000ol00005o`@0
00Go0000o`0300?o10001?l00003o`D01?l400;o0P001?l00004o`<01?l300?o0P04o`<00ol20003
o`0000?o1@04o`<01?l00`3o000300?o0`05o`800ol200Co0`03o`801Ol200So1003o`030?l000<0
0_l500Co0P03o`8000?o00000P000ol0000400Go0`07o`@00_l20003o`0000800_l50003o`0000@0
000600;o1@000ol00002o`030?l000@000Go0000o`060005o`000?l010000ol000040003o`3o00@0
00Ko003o0?l40003o`0000<000?o0?l01`001Ol0o`3o00D000Go0000o`050003o`00008000?o0?l0
1@001Ol0003o00D000?o00000P000ol0o`050007o`000?l0o`070005o`3o0?l01@001_l00?l0o`H0
00Co003o0`001?l00?l400;o1`000ol0o`040003o`0000@000?o0?l01P001Ol0o`3o00@000Ko003o
0?l30004o`00o`@000?o0000100000H00_l60006o`3oo`3o1P001?l00?l400?o0`000ol000020003
o`0000@000?o0?l010001_l00?l0o`D000?o00000P000ol0o`0500?o00@0o`3o1@001Ol0003o00D0
00?o00000P000ol0o`060004o`00o`<01?l30004o`00o`@000Oo0000o`3o00L000?o0?l00P000ol0
00030005o`3o0?l01004o`030?l0008000Co003o10000ol0o`060003o`3o00D000?o00000`001?l0
0?l300Go00<0o`000`001_l00?l0o`<000Co003o10000ol0000400001P02o`H000Ko0?oo0?l60004
o`00o`<000Co003o0`000ol000020003o`0000@000?o0?l01@02o`8000?o000010001ol0003o0?l0
10002?l00?l0o`3o1@001Ol0003o00<00_l50003o`3o00L000?o0?l00`000ol0o`040005o`000?l0
0`001ol0003o0?l01@02o`8000Go0000o`0500;o00<0o`000`000ol0o`020004o`0000?o1@001?l0
0?l300;o0P000ol000030003o`0000<000Go0000o`020007o`3o0?l0o`0400?o0P000ol0000200;o
1@000ol0000400001P02o`L00ol00`3o00060003o`3o00<000Co003o0`000ol000020003o`0000@0
00?o0?l010001_l00?l0o`<000Co003o0`000ol0o`040008o`00o`3o0?l50005o`000?l01@000ol0
00020003o`3o00@000Ko003o0?l30003o`3o00@00_l20005o`000?l00`000ol0o`070004o`3oo`80
00Co003o0P02o`030?l000<000?o0?l00P001Ol0003o00L000Co003o1@000ol0o`060003o`000080
0_l2000:o`00o`3o0?l0o`@000?o00000P001Ol0003o008000?o00000P000ol0000400001P02o`@0
2?l400Co00<0o`000`02o`@000Co00000_l600?o1@02o`8000?o00000P02o`@00ol500;o0P03o`@0
0_l30003o`0000?o1@03o`D00_l20003o`0000800_l40004o`3oo`<00_l300?o1003o`8000Co0?oo
1002o`040?ooo`D00_l20003o`0000800ol400?o0`03o`8000Co00001?l40004o`3oo`@00_l0103o
ool500?o00<0o`000`02o`D000?o0000100000H000?o00001`02o`/000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o0000
2@000ol000090003o`0000@000060?Go1P0000H000?o00001`02o`/000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o0000
2@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003
o`0000T000?o0000100000H00ol400;o00<0ool00ol400;o0P000ol000020003o`0000<01Ol200?o
0P04o`@00ol00`3oo`03o`800ol00`3oo`02o`<01?l00`3o000200?o1@03o`<00ol20004o`0000?o
1@04o`@000Co003o1002o`D01Ol300?o00<0o`000`02o`@01Ol200Co00<0ool00_l300?o0P001?l0
0003o`@01?l300?o0P001?l00004o`<01?l400;o0P001?l00003o`D000?o0000100000H00_l40003
o`0000?o00<0o`000`001_l00?l0o`@000?o00000`000ol0o`070005o`3o0?l01P001_l00?l0o`D0
00Ko003o0?l50005o`000?l01P000ol0000200;o1`000ol0o`040003o`0000@000?o0?l01@001?l0
0?l30004o`00o`@000?o0?l01P001?l00?l30004o`00o`<000?o0?l01@001ol0003o0?l01`000ol0
o`040003o`0000<000?o0?l01@001Ol0003o00@000?o00000`000ol0o`040006o`00o`3o1P000ol0
00020003o`0000@0000600;o10000ol00003o`030?l000<000Ko003o0?l50003o`00008000Co003o
1P001Ol0o`3o00@01?l01@3o003o00@000Ko003o0?l60004o`00o`H000?o00000P02o`D00ol00`3o
00030003o`0000@000?o0?l01P000ol0o`030004o`00o`@000Co003o0`04o`030?l0008000Co003o
0`001?l00?l50006o`00o`3o1`000ol0o`0200Co10000ol0o`050005o`000?l01@000ol000020003
o`3o00@000Ko003o0?l400?o10000ol0000400001P02o`@00ol01@3oo`3o00@00ol20003o`0000<0
00?o00000P001Ol0003o00<00_l20003o`3o00@000?o0?l00P001Ol0003o00<000Ko003o0?l70003
o`3o00@00_l500;o10001_l00?l0o`@000?o000010000ol0o`060003o`3o00@00_l50005o`000?l0
0P000ol0o`020004o`0000?o10001Ol0003o00D000Go0?l0o`0500;o0P001_l00?l0o`D000?o0?l0
1@001Ol0003o00H000Oo0000o`3o00D00_l20005o`000?l00P000ol000020003o`0000@0000600;o
10001?l00002o`030?l000<000?o00000P000ol000040004o`0000;o0P000ol000030005o`3o0?l0
10000ol0o`0200;o0P001Ol0003o008000?o0?l010001_l00?l0o`H000?o00000P02o`@000Ko003o
0?l40003o`0000@000?o0?l01`02o`<000Co003o1002o`8000Ko003o0?l20005o`000?l01P02o`80
00Co003o0P001Ol0o`3o00L000?o0?l00P000ol0o`050003o`3o00D000Go0000o`030004o`00o`<0
00?o0?l010001_l00?l0o`<000Co003o10000ol0000400001P02o`D01ol500?o00<0o`000P04o`<0
00Co0?oo0`03o`800ol500;o0P001?l0ool300;o0P03o`D00_l20004o`0000?o1@02o`D00_l20004
o`0000;o1P03o`@01Ol400;o1@001?l0ool400;o0P000ol0000200?o0`001?l0ool400;o0P03o`@0
0ol20004o`0000;o1@03o`@00_l30003o`0000800_l400?o1@02o`8000?o00000P02o`D000?o0000
100000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060?Go
1P0000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@0000600?o
1008o`@00ol00`3o000200?o1004o`@000Go0000o`0400;o1@001?l00003o`@01Ol200?o0P04o`<0
1?l0103o0003o`D000?o00000P03o`@01?l400;o00<0o`000`000ol0000400Go0P03o`801Ol300Oo
0`03o`8000Co00001?l400?o1002o`801?l300?o0P000ol0000200;o1005o`801?l00`3oo`02o`<0
0ol20003o`0000@0000600;o1P001_l0ool0o`H000Co003o1P001ol0003o0?l01@001Ol0003o00<0
00Co003o10000ol000040007o`000?l0o`070005o`3o0?l01@001Ol0003o00<000?o000010000ol0
00030003o`0000<000?o0?l010000ol00002o`@000?o000010000ol0o`050007o`000?l0o`060005
o`3o0?l01`000ol0o`040003o`0000@00_l40008o`00o`3o0?l70003o`3o00<000Co003o0`000ol0
o`050007o`000?l0o`050005o`000?l01P0000H00_l400Ko00<0o`000`04o`030?l000D000Oo0000
o`3o00H000Co003o0`001?l00?l40003o`0000800ol30004o`00o`H000Go0?l0o`060004o`00o`<0
00?o000010001?l00004o`@000?o0?l010000ol00002o`D000?o00000`001?l00?l40005o`000?l0
0P001?l00005o`030?l000H000?o0?l01@000ol0000300;o10002?l00?l0o`3o1@03o`030?l00080
00Co003o0`001?l00?l50006o`00o`3o1@001Ol0003o00H0000600;o10001?l0o`02o`030?l000<0
00?o0?l00P000ol0000200;o10000ol0o`060004o`00o`<00ol50005o`000?l00P001Ol0003o00<0
00Co00000_l20003o`3o00L000?o0?l00`000ol000040007o`000?l0o`050003o`3o00D00_l00`3o
00040003o`0000<000Go0000o`030005o`000?l00`002_l00?l0o`3o0?l500;o0P000ol000040003
o`0000800_l400?o0P000ol0o`040006o`00o`3o1002o`@000Go0000o`050005o`3o0?l01@001Ol0
003o00H0000600;o10001?l0o`02o`030?l000<000?o0?l00P000ol000040007o`000?l0o`070003
o`3o00<000?o00001@001Ol0003o008000Co00000_l20003o`0000<000Go0?l0o`040006o`00o`3o
0`000ol000040007o`000?l0o`050003o`3o00@000?o00000_l60003o`0000800_l20005o`000?l0
0`02o`8000[o003o0?l0o`3o1`000ol0o`030004o`00o`@00_l40003o`00008000?o0?l010001_l0
0?l0o`<000Co003o0`02o`8000Co003o0P001Ol0o`3o00D000Go0000o`0600001P02o`D00_l00`3o
o`02o`D00_l20004o`0000?o1003o`@01?l00`3o000300?o10000ol0000200;o10001?l0ool300?o
0P03o`D00_l20003o`0000;o1P000ol0000200;o1@03o`D00_l00`3o000200Co10001?l0ool300;o
0`001?l0ool400;o00@0oooo1003o`8000?o00000P02o`D00_l500?o00@0oooo1@02o`8000?o0000
0P02o`@000Co0?oo1002o`800ol400;o0`000ol0000400001P000ol0000700;o2`000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o0000100000H0mOl600001P000ol0000700;o2`000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o0000100000H000?o00001`02o`/000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol0000400001P03o`<00ol00`3oo`03o`<00ol20004o`0000?o1004o`@0
0ol00`3o000200Co10001?l00003o`@01?l400;o0P000ol0000200?o1003o`@000Co00001?l400;o
0P000ol0000200;o1004o`<00ol20003o`00008000?o000010000ol0000200;o1005o`800ol20004
o`0000?o1@04o`801?l00`3oo`03o`800ol200Co0`03o`030?oo00?o0`03o`030?oo00;o0`04o`03
0?l000D0000600;o1`03o`030?l000H000?o0?l010000ol000030003o`3o00H000Co003o10000ol0
00040003o`0000@000Oo0000o`3o00@000Ko003o0?l50003o`0000<00_l50007o`000?l0o`040006
o`00o`3o0`001?l00?l30003o`3o00L000?o0?l010000ol000040005o`000?l00P001ol0003o0?l0
1@001Ol0003o00H000?o00000P02o`D000Oo0000o`3o00L000Go0?l0o`050006o`00o`3o1P001_l0
0?l0o`D000Go0000o`0600001P02o`L00ol00`3o00060003o`3o00@000?o00000`000ol0o`0400Co
00<0o`0010000ol000030003o`0000@000Oo0000o`3o00@000Ko003o0?l300Co1002o`H000Ko003o
0?l40006o`00o`3o0`001?l00?l30003o`3o00D00ol00`3o00040003o`0000<000Go0000o`020005
o`000?l00P000ol000020005o`000?l01003o`@000?o0?l01@001?l00?l20003o`0000@000Go0?l0
o`050004o`00o`8000Co00001?l0103o0?l60004o`00o`H0000600;o1@02o`050?oo0?l01@02o`80
00?o00000P000ol000030003o`3o00@000?o0?l00P000ol000040003o`00008000?o00000P02o`@0
00?o0?l01003o`8000Oo0000o`3o00D00_l60006o`00o`3o1@02o`8000Co00000ol40003o`3o00@0
00Ko003o0?l50003o`0000<000?o00000P02o`@000Go0000o`030005o`000?l00`001?l00?l40004
o`00o`D000?o0?l00`001?l00002o`8000?o0?l01@001?l00?l30006o`00o`3o0P000ol0o`070003
o`3o00H0000600;o1`03o`030?l000H000?o0?l010000ol000030003o`3o00@000?o0?l00P001Ol0
003o008000?o00000P000ol000040007o`000?l0o`040003o`00008000Oo0000o`3o00D00_l70005
o`3o0?l010001_l00?l0o`<000?o000010000ol0o`040006o`00o`3o1P000ol000020005o`000?l0
0P001?l00002o`8000Go0000o`030005o`000?l00P000ol000020004o`00o`8000Go003o0002o`80
00?o00000`001Ol0o`3o00D000?o00000_l20006o`00o`3o0P000ol0o`040006o`00o`3o1P0000H0
0_l400?o00<0ool00_l400?o0P001?l00002o`D00ol500;o0P000ol0000200;o1@001?l00003o`@0
0ol500?o00<0o`000`02o`D00_l400Co00@0oooo1@02o`8000?o00000P03o`<00ol500;o0P001?l0
0004o`@000?o00000P02o`@000Co0?oo0`02o`<000?o00000P02o`D00ol400;o0P001?l0ool300?o
0P03o`@00_l20004o`3oo`@00_l200?o1@02o`8000?o0000100000H000?o00001`02o`/000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000@000060?Go1P0000H000?o00001`02o`/000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o2`000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o0000100000H00ol300Wo0`04o`030?oo00?o0`07o`<00ol200Go
0P03o`801Ol200Go0`03o`D01Ol200?o0P001?l00002o`D000?o00000P000ol0000400Co0`03o`03
0?l000<00_l500Co1002o`801?l40004o`00o`@00ol400Co1002o`8000?o00000ol50004o`0000Co
1004o`@01?l300?o1@04o`<00ol20003o`0000@0000600;o1@000ol00002o`030?l000@000Oo0000
o`3o00H000Go0?l0o`050007o`000?l0o`070005o`3o0?l01@001?l00?l60003o`00008000?o0?l0
1@001Ol0003o008000Co003o10000ol000020003o`0000@000?o0?l01`02o`<000Co003o10000ol0
o`040008o`00o`3o0?l50004o`00o`D000?o00000`000ol0o`040006o`00o`3o1@000ol000020003
o`00008000?o000010000ol0o`060003o`3o00@000?o000010000ol0o`070003o`3o00H0000600;o
1P001_l0ool0o`H000Co003o0P001?l00005o`030?l000@000Go0000o`020003o`0000@000?o0?l0
0P000ol000030003o`3o00@00ol40004o`00o`@000Go0000o`020004o`00o`@000?o00000`000ol0
00030003o`3o00D01?l30004o`00o`@000?o0?l010002?l00?l0o`3o1P000ol0o`0300Co10000ol0
o`040006o`00o`3o1@000ol000020003o`0000<000?o00000`000ol0o`0400Go10000ol000040003
o`3o00L000?o0?l01P0000H00_l700?o00<0o`001P000ol0o`03000:o`00o`3o0?l0o`D000Go0000
o`030004o`0000;o0P001Ol0003o00D00_l30004o`00o`@000Go0000o`030005o`000?l00`02o`D0
00?o00000`000ol000030003o`3o00@000?o00000_l300?o1@000ol0o`0500;o0P000ol0o`060003
o`3o00<000?o0?l01@000ol0o`0400?o0P001?l00002o`D000?o000010000ol000020003o`3o00@0
00Go0?l0o`040003o`0000@000?o0?l01@02o`8000?o0000100000H00_l40003o`0000?o00<0o`00
0`001Ol00?l000;o0P002_l00?l0o`3o0?l50004o`0000;o0P000ol000030004o`3oo`8000Co003o
0P02o`<000Co003o1002o`8000Go0000o`030004o`00o`8000?o00000P000ol000040003o`000080
00?o0?l010000ol00002o`<000?o00001@000ol0o`040008o`00o`3o0?l700;o0`000ol0o`050003
o`3o00@000?o00000P000ol000030003o`00008000Go0000o`020003o`00008000?o0?l010001Ol0
o`3o00@000?o000010000ol0o`070003o`3o00H0000600;o1@02o`030?oo00;o1@02o`8000Co0?oo
1002o`040?ooo`@00_l30004o`3oo`<00ol20004o`3oo`@00_l00`3o000300;o1@001?l0ool300;o
0`001?l00002o`D000Co00001?l400?o1@02o`030?l000<00ol400?o1@02o`800ol400Go1002o`D0
0ol500?o00@0o`000ol50003o`0000800_l500?o1@02o`030?l000800_l600?o1003o`8000?o0000
100000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060?Go
1P0000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@0000600?o
0`03o`030?oo00?o0`03o`801Ol200Go1002o`D01?l300?o0P04o`@00_l00`3o000200Co1004o`<0
0ol200Co0`03o`030?oo00?o0P03o`8000?o00000P000ol0000300Co1002o`8000?o00000P03o`@0
00Co00000ol400Co0`04o`030?oo00?o0P03o`8000?o00000ol50003o`0000800_l500Co10001?l0
0?l300?o1@04o`@00ol00`3o000500001P02o`D000?o00000_l00`3o00040007o`000?l0o`050004
o`00o`<000Co003o10000ol0o`070005o`3o0?l010000ol00002o`@000?o000010000ol0o`070004
o`3oo`H000Ko003o0?l50005o`000?l010000ol000030003o`3o00@000Ko003o0?l50003o`0000<0
00?o00000P000ol000030003o`3o00D000Oo0000o`3o00L000?o0?l01@000ol000020005o`000?l0
0P000ol000020003o`3o00D000Co003o1P000ol000020003o`3o00H000Co003o1P0000H00_l50003
o`0000;o00<0o`0010001Ol0003o008000?o00000`000ol0o`030004o`00o`@000?o0?l01@03o`04
0?l0o`@000?o00000_l50003o`0000<000?o0?l01`001Ol0o`3o00<01?l01@3o003o00@000Go0000
o`050003o`00008000?o0?l010001_l00?l0o`<01?l40003o`00008000?o00000`000ol0o`060004
o`00o`8000?o000010000ol0o`0300?o10001Ol0003o008000?o00000P000ol0o`060003o`3o00H0
00?o00000P000ol0o`0400Co00<0o`001@0000H00_l50003o`0000;o00<0o`0010001Ol0003o00<0
00?o00000`02o`@00_l50003o`3o00@000So003o0?l0o`@00ol00`3o00050003o`00008000?o0?l0
1@02o`8000Co003o0P000ol0o`020005o`000?l00`001Ol0003o00D000?o00000P000ol0o`0500;o
0P001ol0003o0?l01@000ol000020003o`0000<000?o0?l01`000ol0o`030004o`0000;o0P001?l0
0?l20003o`00008000Co00000ol50003o`3o00H000?o0?l01002o`D000?o0?l010000ol0o`020003
o`0000@0000600;o1@000ol00002o`030?l000@000Co00000_l20004o`00o`800_l30004o`00o`@0
00?o0?l010002?l00?l0o`3o10001Ol0003o00<000Co003o10000ol0o`070003o`3o008000Ko003o
0?l200;o0P001Ol0003o00<000?o000010001ol0003o0?l010001_l00?l0o`<000?o0?l01@000ol0
00020003o`0000<000?o0?l010001Ol00?l000;o0P000ol000030003o`3o008000Co003o10001Ol0
003o00L000?o0?l01`02o`H000?o00000P000ol0o`040003o`3o008000?o0000100000H00_l400;o
0P04o`@00_l30004o`3oo`@00_l00`3o000300;o1@03o`D00_l200?o1@04o`@00_l500?o1003o`80
0ol400;o0P001?l0ool300;o0`001?l00004o`<00ol500;o0P000ol0000200;o1@001?l00002o`D0
0ol500;o0P001?l0ool300?o0P001?l00002o`D000?o00000P03o`@00ol400Go0`03o`D00ol500;o
0P000ol0000400001P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003
o`0000@000060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000
100000H0mOl600001P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003
o`0000@000060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000
100000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol00003o`@00_l300?o1@04o`@00_l00`3o000200Co1004o`<00ol20003o`0000800ol300Co
0`03o`801Ol200Co00<0o`000P02o`D01Ol300?o00<0o`000`02o`@01?l40005o`000?l00`03o`D0
1?l300?o00<0o`000P03o`D01?l300Co00<0ool00_l200?o0P04o`@00ol00`3oo`03o`800ol00`3o
00030003o`0000@01?l400;o0P000ol0000400001P000ol000030004o`0000;o1P000ol000020003
o`3o00@000?o00000_l40003o`0000@000?o0?l01@001Ol0003o00D000?o00000P000ol0o`070005
o`3o0?l01@001Ol0003o008000Co003o10000ol0o`060004o`00o`<000Co003o0`000ol0o`050005
o`000?l010000ol000040003o`3o00L00_l60003o`00008000?o0?l01@001?l00002o`D000Oo0000
o`3o00H000Ko003o0?l700;o10000ol000040003o`3o00@000Ko003o0?l600001P001?l00003o`<0
0_l400?o10000ol0o`040003o`0000;o1@000ol000030003o`3o00D000Go0000o`0300Co0`000ol0
o`070003o`3o008000?o00000`001?l00?l20004o`00o`@000Co003o0`04o`030?l0008000Co003o
0`000ol0o`060004o`00o`@000?o000010000ol0o`0500Co1P000ol000020003o`3o00H000Ko003o
0?l40007o`000?l0o`0400Co00D0o`00o`0600;o1@000ol000030003o`3o00@000Ko003o0?l60000
1P001?l00?l20004o`0000;o0`001?l00?l40003o`3o00D00_l00`3o00050003o`00008000?o0?l0
1@001Ol0003o00<000?o0?l010000ol0o`0500;o0P001Ol0003o00D000?o0?l00P03o`D000Go0000
o`020003o`3o008000?o00000P02o`@000?o0?l01P001?l00?l40003o`0000@000?o0?l010000ol0
0002o`@00_l50003o`3o00L000?o0?l00P001Ol0003o00<000?o0?l010000ol0o`020005o`000?l0
0`02o`030?l000@000?o00000`000ol0o`0400?o0P000ol0000400001P001?l00?l20004o`0000;o
0`001?l00?l40003o`3o00@000?o00000_l30004o`00o`@000?o0?l01@001Ol0003o00<000?o0?l0
10000ol0o`070004o`3oo`8000Co003o0P000ol0o`020003o`0000D00_l20006o`00o`3o0P001Ol0
003o008000Oo0000o`3o00L000?o0?l010000ol000040003o`3o00@000?o00000_l60003o`000080
00?o0?l010001_l00?l0o`8000Go0000o`030003o`3o00@000?o0?l00P02o`8000?o00000`02o`H0
00?o00000P000ol0o`040003o`00008000?o0000100000H000Co00000_l400;o1002o`D00ol500;o
00<0o`000`02o`D00ol400;o0`000ol0000200;o1003o`@00ol20004o`3oo`@00_l20004o`0000?o
10001?l0ool400;o0P000ol0000200;o1003o`@01?l00`3o000200;o1P03o`D00_l00`3o000200?o
1@03o`D00_l200?o0`02o`<00ol500;o0P001?l0ool300?o00<0o`000P04o`@00ol500?o00<0o`00
1@0000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060?Go
1P0000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000040000
1P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060003
o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H000Co0000
0_l400;o1002o`D01?l400;o00<0ool00ol300?o00<0o`000`000ol0000400Go0P03o`030?l000<0
0_l500Co1003o`030?oo00;o0P04o`030?oo00;o0`03o`801Ol200?o00<0o`000`03o`@01?l300Co
00<0o`000P03o`@01?l300?o0P04o`<00ol20003o`0000Co1004o`@00_l20004o`0000?o10001?l0
0003o`D01?l40005o`000?l01P0000H000Co003o0P001?l00002o`<000Co003o10000ol0o`040003
o`0000;o00<0o`001@001?l00?l40003o`0000@000?o0?l01`02o`<000Co003o10000ol0o`060003
o`0000;o1@001ol0003o0?l01`001Ol0o`3o00D000Co003o1@000ol000030003o`3o00D000Go0000
o`060007o`000?l0o`050007o`000?l0o`070003o`3o00<000?o000010000ol0o`040006o`00o`3o
10000ol000030003o`0000@000?o00000P000ol0o`050005o`000?l01P0000H000Co003o0P001?l0
0002o`<000Co003o10000ol0o`040003o`0000;o0P001?l00004o`030?l000@000?o00000`001?l0
0?l600;o0`001?l00?l40003o`3o00@01?l0103o0?l50006o`00o`3o1`000ol0o`020003o`000080
00Co003o0`04o`@000?o0?l01P001?l00?l60007o`000?l0o`050007o`000?l0o`0500?o00<0o`00
0`000ol000030003o`3o00@000Ko003o0?l40003o`0000<000?o00000P03o`@000?o0?l01P001?l0
0?l600001P001?l00002o`@00_l400;o1@000ol0o`0400?o00<0o`000P001_l00?l0o`8000?o0000
0`000ol000030005o`000?l00`02o`030?l000800ol50003o`3o00@000?o0?l00P001?l00?l50005
o`3o0?l01@02o`8000Go0000o`030004o`00o`<000?o0?l01@000ol0o`070003o`3o00@00_l40003
o`3o00D000Oo0000o`3o00@000Ko003o0?l50003o`00008000?o0?l01@02o`8000?o00000P000ol0
00030005o`000?l00P000ol000020003o`3o00H000Co003o1P0000H000Co003o0P001?l00002o`<0
00Co003o10000ol0o`040004o`0000;o0P001_l00?l0o`8000?o000010000ol0000200;o0P000ol0
000300;o0`000ol000050003o`3o00@000?o0?l00P001?l00?l20008o`00o`3o0?l70004o`3oo`80
00Go0000o`020007o`000?l0o`050003o`3o00@000Ko003o0?l60007o`000?l0o`050007o`000?l0
o`040006o`00o`3o0P001?l00?l40003o`3o00@000Ko003o0?l40003o`0000<000Go0000o`020003
o`00008000?o0?l01`000ol0o`0600001P001?l00002o`@00_l400;o1@03o`D01?l00`3oo`0400;o
0P001?l00004o`@000Co0?oo0`03o`030?l000<00ol400?o1@02o`800ol400;o0P03o`@00ol20004
o`3oo`<00_l20003o`0000800_l500?o1@02o`8000Co00000ol400?o1002o`<00ol500;o0P001?l0
0002o`D00ol500;o0P001?l00002o`D000?o00000P02o`D00ol400Co00<0o`001@0000H000?o0000
1`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P3eo`H000060003
o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
2@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H000?o0000
1`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003
o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P000ol0000700;o
2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060005o`000?l01@02o`@0
00?o00001004o`@02?l200?o0P001?l00003o`D01?l40003o`0000Go0`03o`030?l000<00_l500?o
0`03o`8000Co00001?l40004o`0000?o1004o`@00_l200Go0P03o`801?l300So0`03o`8000Co0000
0ol50004o`0000;o1@05o`801?l00`3o000300?o0`04o`<00ol200Co1002o`8000?o0000100000H0
00Go0000o`0500;o10000ol000040003o`3o00H000Go0?l0o`050005o`000?l01P000ol000020003
o`3o00D000Ko003o0?l60004o`00o`<000Co003o1002o`L000?o0?l010000ol000040003o`0000@0
00Oo0000o`3o00@000So003o0?l0o`L000Go0?l0o`050006o`00o`3o1`000ol0o`040003o`0000@0
00Co003o0P000ol000020003o`3o00D000Go0000o`050003o`00008000?o0?l01@001ol0003o0?l0
10001_l00?l0o`H000060003o`00008000?o00000P02o`D000?o00000`000ol0o`0400Go0P000ol0
00020005o`000?l01P000ol000020003o`3o00H000?o0?l00P001?l00004o`030?l0008000Co003o
1002o`L000?o0?l01@000ol000030003o`0000800ol30003o`3o00@000Ko003o0?l20003o`0000@0
00Go0?l0o`060005o`3o0?l01@03o`030?l000<000?o000010001?l00?l20003o`00008000Co003o
1@001?l00?l300Co0`000ol0o`050007o`000?l0o`040006o`00o`3o1P0000H000?o00000P000ol0
000200;o1@000ol000030003o`3o00@000Go0?l0o`030005o`000?l00`000ol0000200;o1@000ol0
o`060003o`3o00<000Ko003o0?l20004o`0000?o1@02o`D00_l20003o`0000@000?o00000P001Ol0
003o008000Oo0000o`3o00@00ol20005o`000?l00`02o`8000?o0?l01`02o`030?l000<000Ko003o
0?l40003o`0000@000Co00000_l50005o`000?l01@000ol0o`030003o`3o00@000?o0?l01@001ol0
003o0?l01@02o`8000?o0000100000H000?o00000`001?l00002o`H000?o00000P000ol0o`040004
o`3o00;o0P001Ol0003o00<000?o000010000ol000020003o`3o00L00ol20006o`00o`3o0P001Ol0
003o00L00_l70003o`3o00<000Co003o10001Ol0003o008000Oo0000o`3o00@000?o00000P02o`80
00?o00000`001Ol0o`3o00@000?o00000_l00`3o00030006o`00o`3o10000ol000040004o`00o`80
00?o00000P02o`8000Co003o0P000ol0o`030003o`3o00@000?o0?l01@001ol0003o0?l010001_l0
0?l0o`H000060003o`0000Co0`02o`<01?l400?o1@02o`030?l000;o0`02o`<000Co00000ol500?o
1005o`030?oo00@00_l20003o`0000800ol400;o1003o`8000?o00000P02o`D000?o00000P02o`@0
0ol500?o00<0o`000_l300?o0P03o`D00_l0103oool500;o0P001?l00002o`H000Co00000_l50004
o`3oo`@00_l20003o`0000800_l400?o1002o`<00ol500;o0P000ol0000400001P000ol0000700;o
2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o000020000ol000090003o`0000T000?o0000100000H0mOl600001P000ol0000700;o
2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o0000
20000ol000090003o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003
o`0000T000?o000020000ol000090003o`0000T000?o0000100000H000?o00001`02o`/000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000080003o`0000T000?o00002@000ol0000400001P001?l00002o`@00_l400;o1@04o`<0
2?l400;o0P05o`<00ol00`3oo`02o`<00ol00`3oo`02o`@000Co00001Ol200?o0P001?l00003o`@0
1?l400;o0P05o`801Ol300?o1@001?l00003o`D01Ol200?o00<0o`000P04o`@000?o00000P02o`D0
0ol400?o00<0o`000P03o`D000?o00000P000ol0000300Co0`03o`801?l300?o0P000ol000040000
1P001?l00?l20004o`0000;o0`001?l00?l40003o`3o00D000Ko003o0?l40008o`00o`3o0?l60006
o`00o`3o1@001_l00?l0o`D000Oo0000o`3o00L000?o0?l010000ol000030003o`3o00@000So003o
0?l0o`D000Co003o1P000ol000020003o`0000@000?o00000P000ol0o`050004o`00o`@000?o0000
10001Ol0003o008000?o00000P02o`H000Co003o10000ol000040003o`00008000?o00000`000ol0
o`070005o`3o0?l01`000ol0o`0600001P001?l00?l20004o`0000;o0`001?l00?l40003o`3o00H0
00Go0?l0o`040006o`00o`3o0P001?l00004o`040?l0o`D000Ko003o0?l60004o`00o`8000?o0000
10000ol0o`0200Co10000ol0o`040006o`00o`3o0P000ol000030003o`3o00H000?o00000P000ol0
000200?o10001?l00?l40004o`00o`D000?o00000`001Ol0003o008000?o00000P02o`@01?l00`3o
00030003o`0000@000?o00000`000ol000020003o`3o00L000Go0?l0o`0500?o00<0o`001@0000H0
00?o00000ol400;o0`03o`D000?o0?l01`02o`030?l000@00_l20005o`000?l00P000ol0o`020003
o`3o00D000Ko003o0?l60004o`00o`<000Co00000_l20006o`00o`3o1@000ol0o`0400?o0P001Ol0
003o00D00_l400;o1@001Ol0003o008000?o00000P001Ol0003o00<000Co003o1P000ol000020003
o`0000800_l500;o10000ol0o`020003o`00008000?o000010000ol000030003o`00008000?o0?l0
1@02o`8000?o0?l010001_l00?l0o`H000060004o`00o`H00_l30003o`0000D000?o0?l010000ol0
0002o`030?l000<000Go003o0002o`8000Ko003o0?l20003o`3o00D000Ko003o0?l70004o`3oo`80
00?o00000`000ol0o`020003o`3o00D000?o0?l010000ol0000200;o0P001?l00?l200;o1P000ol0
00020005o`000?l00P000ol0000200;o0P001Ol0003o008000Go0000o`020003o`00008000Go0000
o`020003o`0000800_l40003o`3o008000?o00000P000ol000040003o`0000@000Oo0000o`3o00L0
00Go0?l0o`040006o`00o`3o1P0000H000Co00000ol300;o1003o`@00ol500;o00@0oooo1@02o`80
00Co0?oo1002o`800ol400;o0P03o`@01?l00`3o0002o`<00ol20004o`0000;o1@03o`D00ol00`3o
0002o`@00_l00`3o000200?o1@000ol0000200;o1@001?l0ool300;o0P000ol0000200;o1@000ol0
000200;o1@02o`D00_l20004o`0000;o1P001?l00004o`<00ol400?o0P03o`D00_l20003o`0000@0
00060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H0
00?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P3eo`H0
00060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H0
00?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P001?l0
0003o`<00_l400?o10000ol0000200;o1004o`<01?l00`3oo`02o`@00_l200Go0`04o`<00ol50003
o`00008000?o00001003o`<00ol200Co0`03o`801Ol200?o00<0o`000P04o`@000?o00000P02o`D0
1?l400Oo1002o`801Ol200Co00@0o`000ol50004o`0000?o1@04o`<00ol00`3oo`02o`@000Co0000
1Ol200?o0P000ol0000400001P000ol000020003o`0000800_l50003o`0000<000Go0000o`020007
o`000?l0o`050007o`000?l0o`040008o`00o`3o0?l60003o`3o00H000?o00000P000ol000020003
o`0000@00_l50007o`000?l0o`070005o`3o0?l01`02o`@000?o000010001Ol0003o008000?o0000
0P000ol0o`060005o`3o0?l010002?l00?l0o`3o1@001Ol0003o00<000?o000010000ol000040003
o`00008000?o0?l01`02o`030?l000@000Oo0000o`3o00D000Go0000o`0600001P000ol00004o`<0
0_l300Co10001Ol0003o008000Oo0000o`3o00H000Ko003o0?l40006o`00o`3o0P001?l00005o`H0
00?o00000P000ol000030003o`0000<00_l50007o`000?l0o`0500?o00D0o`00o`0600;o1@000ol0
00030005o`000?l00P000ol000020003o`3o00@01Ol00`3o00030006o`00o`3o0P000ol000030004
o`00o`<000?o000010000ol0000200?o10000ol0o`0700;o00<0o`001@001?l00?l20003o`000080
00Go0000o`0600001P001_l00?l0o`@00_l30003o`3o00D000?o00000P02o`@000?o0?l01`001Ol0
o`3o00@00ol20005o`000?l00P001Ol0o`3o00@00_l50003o`0000<000?o00000`02o`D000Oo0000
o`3o00@000Ko003o0?l30004o`0000;o00<0o`001@000ol000020004o`0000?o1@000ol0o`040007
o`3o0?l0o`0500;o0P001Ol0003o00D000?o0?l00`000ol000040005o`000?l00P000ol000020003
o`3o00D00_l0103o0?l60004o`00o`<000Go0000o`030003o`0000@000060006o`00o`3o1002o`<0
00?o0?l01@001Ol0003o008000Oo0000o`3o00@000So003o0?l0o`@000?o00000P02o`8000So003o
0?l0o`H000?o00000P000ol000040003o`0000800_l50007o`000?l0o`040005o`00o`000_l20003
o`0000<00_l30004o`00o`@000Go0000o`070003o`3o00@000Oo0?l0o`3o00@000Go003o0002o`80
00Co003o0P000ol0o`030003o`0000@000Go0000o`020003o`00008000?o0?l01`02o`030?l000H0
00Co0?oo0P001Ol0003o00<000?o0000100000H000Co00000_l400;o1002o`D000?o00000P02o`@0
0ol500;o0P03o`D00ol00`3o0002o`@00_l00`3o000200?o1@001?l00004o`@00_l400;o0`03o`D0
0_l20004o`3oo`<00ol00`3o000300;o1@000ol0000200?o1003o`D00_l0103oool500;o0P001?l0
ool400;o0P000ol00002o`H000?o00000P02o`D00ol400?o00@0oooo1004o`030?l000;o0`02o`<0
00?o0000100000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0
000400001P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@0
00060?Go1P0000H000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0
000400001P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000@0
00060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H0
00?o00000ol400;o0`03o`D000?o00000P02o`@000Co00000ol500Co0`04o`030?oo00;o1002o`03
0?oo00?o0P03o`801Ol300?o00@0o`001?l40003o`0000800_l500Co0`03o`030?oo00;o1003o`03
0?oo00;o10001?l00005o`800ol00`3o000200?o1@000ol0000200?o10001Ol0003o00H01?l300?o
0P04o`@00_l00`3oo`02o`<00ol200Go0P04o`030?l000D000060003o`0000<000Co00000_l60003
o`00008000Go0000o`020005o`000?l01P000ol000020003o`3o00D000Oo0000o`3o00@000?o0000
0_l00`3o00040007o`000?l0o`060004o`00o`<000?o000010001Ol0003o008000?o00000P000ol0
o`050006o`00o`3o1P001_l00?l0o`D000Oo0000o`3o00L00_l40003o`0000@000?o00000`000ol0
00030005o`000?l01P000ol0o`070005o`3o0?l010000ol00002o`030?l000H000Go0?l0o`050005
o`000?l01P0000H000?o00000`001?l00002o`H000?o00000P001Ol0003o008000Go0000o`0400?o
10000ol0o`060006o`00o`3o10000ol00002o`8000?o00000P001Ol0003o008000Co00001?l00`3o
00030003o`0000<000Go0000o`020003o`00008000?o0?l01@001_l00?l0o`@01?l0103o0?l60004
o`00o`8000?o00001002o`@000?o000010001?l00004o`@000?o00000P000ol000030003o`3o00L0
00Go0?l0o`040003o`0000;o00<0o`001003o`050?l00?l01@001?l00?l600001P001?l00002o`@0
0_l400;o1@001?l00003o`@000Go0000o`020003o`00008000?o0?l01`001Ol0o`3o00D00_l00`3o
00020005o`000?l00`001Ol0003o008000?o0?l00P000ol000030003o`00008000?o00000P02o`D0
00?o0?l01@001_l00?l0o`@000?o0?l00P000ol0o`060004o`00o`<000Co00000_l00`3o00030003
o`0000@000Oo0000o`3o00D000?o00000P000ol000030003o`3o00D00_l20003o`3o00@00ol0103o
0?l40006o`00o`3o0`000ol000030003o`3o00H000060003o`0000<000Co00000_l60003o`000080
00Go0000o`060005o`000?l00P000ol000020003o`3o00@000So003o0?l0o`@000?o00000ol20005
o`000?l00`02o`8000Ko003o0?l20004o`00o`8000?o00000P001Ol0003o008000?o00000P000ol0
o`050006o`00o`3o10000ol0o`020003o`3o00L000Co0?oo0P000ol0000300;o10000ol000040007
o`000?l0o`050003o`0000<000?o00000P000ol0o`070005o`3o0?l010001ol0003o0?l010001Ol0
0?l000;o0P001?l00?l20003o`3o00H000060003o`0000?o1002o`<00ol50003o`0000800ol30003
o`0000800_l500?o1@02o`800ol500;o00<0o`000_l300;o0`001?l0ool400;o0P001?l00002o`D0
00?o00000P02o`D00ol400;o0P03o`D00_l200?o1004o`030?l000;o0`03o`030?l000800_l60003
o`0000800_l50003o`0000Co1003o`@00ol200?o1@06o`D00_l20004o`3oo`@00_l20003o`0000@0
00060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T000?o0000100000H0
00?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0000400001P3eo`H0
00060003ofi^00M^0_l;8`03oemO00QO00goh=3Pd>3@h=3Pd>3o00^O00?oh>002>00<?oAh]7RdN;A
h]7RdOoOWmnOgioOWmnOgom1@450@D11@450odmBCe9?DTmBCe9?o`X800?o;bl02Bl0<?oAd=7@dM3A
d=7@dOoRgn;Oh]oRgn;Ooh10P420@810P420oe91DT5B@E91DT5Bo`Xo00?oP8002H003?m??dloCcm?
?dloo`_000?o0@402@400ol0000400001P000om^KP07KP;o2b<00omOG`08G`03om3@00W@02CoGimO
WenOGimOWeoo2>08h0SP2>08h?oAh]7RdN;Ah]7RdOl;g`0Hod11@450@D11@47oDTmBCe9?DTmBCe;o
2PP00ol_;`09;`0Hom3Ad=7@dM3Ad=7@omoRgn;Oh]oRgn;o2d009?mB@E91DT5B@E91D_l_?blo;cl_
?blooh30P<20`830P<20o`Y?00?o`<002L000ol10@090@03o`0000@000060003ofi^00M^0_l;8`03
oemO00QO00goh=3Pd>3@h=3Pd>3o00^O00?oh>002>00<?oAh]7RdN;Ah]7RdOoOWmnOgioOWmnOgom1
@450@D11@450odmBCe9?DTmBCe9?o`X800?o;bl02Bl0<?oAd=7@dM3Ad=7@dOoRgn;Oh]oRgn;Ooh10
P420@810P420oe91DT5B@E91DT5Bo`Xo00?oP8002H003?m??dloCcm??dloo`_000?o0@402@400ol0
000400001P000om^KP04o`=^0_l38`Co12<00omOG`02G`?o0el00oo@d002d0;o1M001OmOWenO00;o
00EOWenOG`04o`03h0SP00So00CRdN;A0ol00m7oo`02o`CO0_l2g`?o00A0@D110_l00d11o`04o`03
DToo00?o00=Bool00ol320Co0bl3o`D_00Cod=7@0ol04M3Ad=7@omoRgn;oh]oRgn;o00=00ol5@0Co
00=1DT400ol00d5Bo`02o`03;cl_00?o00<_?ol00ol02<20`83oP<201?l3C`?o00=?ool00ol2`0?o
0/05o`810ol20@03o`0000@000060005ofi^K_l01Fh2o`@S00?o8b<012<00omOG`03G`03oemO009O
00goh=3Pon3@om3Pd>3o00>O00CoWioo19l00ooPo`05h00Kon3Pom7odN;Ah]7Ron;AomoogioOWonO
gooO00;o01Q0@D11od50od3oCom?DTmBCom?DToo2?l62003o`So00@_00?o;bl012l0;ooAd=7@dM3o
d=7@dOoRgn;OomoRgn;Ooh10P420@?m0P420oe;oDT5B@E;oDT5B00;o1cl01Olooh3o00F000koP820
odooCcm??dloC`;o00?0ol001<001oo0`<3o0Ol01`400ol1o`0600001P000om^KP02KP03ofi^009^
0_l58`03ob<S00<S00CoGemO1?l3G`05om3@d?l00]000oo@d002d00NoenOGomOWonOGimOo`So2>08
h0SPon3odOoAh]7R1?l01=7ogol4g`05omoOoml00_l05T50@D3o@47o@OmBCom?DTmBCom?D_l22004
o`P820Go12l00ol_;`04;`0Hom3Ad=7@dOoAd=7@omoRgn;OomoRgn;o1403o`A000coD_mB@E91D_mB
@E82o`0H?blo;cl_?olooh3oP<20`830ol20odoo1Dl4o`;000?o`<000/001Oo0`<3o008100?o0@40
10400ol1o`0600001P000om^KP03KP04ofi^KP;o1R<00olS8`028`07oemOGomOo`04G`04on3@h0?o
00KPd>3@h?l4W`;o1Il00ooPo`07h0;o01;Aom7RdN;oh_oRdOoOomnOgil3o`09Wmoood11@45000;o
00m1@?m?DTooCe9?DTooCol00`P02?l82?l8o`So12l00ol_;`04;`05om7@dM000_l0:=7@dM3Aon;O
h]oRon;Oh]ooP420oh10od20@83oD_mB@E91D_mB@E82o`Do0_l2?`03oh3o00J000goP83oCom??dlo
ocm?00;o0l001Oo0`<3o00?000Go0@41o`030@;o0P400ol0000400001P001?m^K_l2KP04ofi^KP;o
0b<01?lS8ol48`07oemOGomOo`04G`05om3@d?l01m005_mOWeooGiooWenOGol8o`SP2>3oh0P2o`0>
dOoAh]7Ron;oh]7ogol4g`03omoO00;O0_l02D50@D3o@47o@@02o`0:Ce;oDTooCe;oDP;o0PP02?l8
2?l8o`So12l00ol_;`04;`0Hom3Ad=7@dOoAd=7@omoRgn;Oh_oRgn;o0d001?m0@?l4@00<oe;oDT5B
@E;oDT5B0_l063l_?blo;coo?on0oh30P<20`83oP?m?o`A?00?oCdl00ol2`005ol30`?l00l02o`81
00?o0@400`400ol1o`0600001P001?m^KVh2o`A^0_l48`;o1B<00omOG`02G`;o15l01OoPd>3@00?o
00G@h=3Po`04W`;o1Il3o`GP0_l02N3ooooAh]7Rd@02o`03h]7o00;o00GOWmnOg`03o`08gooo@450
@D02o`04@D3oC`;o00ABCe9?0_l0159?o`P2o`@80_l00`So;`02;`;o1Rl01?oAd=43o`09dM3Ad=7o
h]oR00Co00SOh]ooP420@0;o00F0@810P003o`04DT5B@@;o00=B@E800_l4?`?o0Sl3o`B01?l02H3o
oom??dloC`02o`03?oo000;o0l02o`?000Co0Ooo0`43o`8100?o0000100000H000?oKVh01fh2o`/S
00?oGel025l00oo@d009d00ToenOGimOWenOGimOo`SP2>08h0SP2>3odN;Ah]7RdN;Ah]7o2ml06?m0
@D11@450@D11oe9?DTmBCe9?DTmBo`X800?o;bl02Bl06?o@dM3Ad=7@dM3Ad?oOh]oRgn;Oh]oRo`]0
02CoDT5B@E91DT5B@E;o;cl_?blo;cl_?on0`830P<20`830P?l:C`03ol3000W000?o0@402@400ol0
000400001P000om^KP07KP;o2b<00omOG`08G`0=on3@h=3Pd>3@h=3Po`0;W`03on3P00SP033odN;A
h]7RdN;Ah]7ogioOWmnOgioOWmoo@D11@450@D11@?m?DTmBCe9?DTmBCol:2003obl_00T_033odM3A
d=7@dM3Ad=7oh]oRgn;Oh]oRgon0@810P420@810P?mB@E91DT5B@E91D_l:?`03oh2000V000coCcm?
?dloCcm??ol;`003o`4100T100?o0000100000H0mOl600001P000ol0000700;o2`000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000@000060003o`0000L00_l;0003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o0000100000H000?o00000ol400;o0`03o`D000Co00001?l30004
o`0000?o1@000ol0000200?o10000ol0000200;o10000ol000020003o`0000@000?o00000P02o`D0
00?o00000ol500Co0`03o`801?l300So0`03o`801?l400?o00<0ool00_l400;o00<0ool00_l40004
o`0000Co1002o`800ol300?o0P05o`800ol200Go0P09o`800ol200Go0`03o`030?l000D000060005
o`000?l01@02o`@000?o000010000ol000020003o`0000<000?o000010000ol000020003o`0000<0
00?o00000`001Ol0003o008000Go0000o`040003o`0000@000Go0000o`020003o`00008000?o0000
0`000ol000020003o`3o00D000Oo0000o`3o00D000Ko003o0?l70005o`3o0?l01P001_l00?l0o`@0
00?o00000_l00`3o00040007o`000?l0o`040005o`00o`000_l70005o`3o0?l01@001ol0003o0?l0
1@001_l00?l0o`L000Go0?l0o`060004o`00o`H000060005o`000?l01@02o`@000?o000010000ol0
00030003o`00008000?o000010000ol000020004o`0000Co10001Ol0003o008000Go0000o`050003
o`0000<000Go0000o`020003o`00008000Co00000ol40003o`3o00D000Oo0000o`3o00H000Go0?l0
o`070005o`3o0?l01004o`040?l0o`@000?o00000_l00`3o00050006o`00o`3o10001Ol00?l000;o
1@03o`050?l00?l010001Ol0003o008000?o00000`000ol0o`020003o`0000@000?o0?l00P001?l0
0004o`030?l000D000060005o`000?l01@02o`@000?o000010000ol000040005o`000?l01002o`D0
00Oo0000o`3o00D000Co00000ol40003o`0000<000?o00000`000ol0000200;o1@001?l00?l20003
o`00008000?o0?l01@001ol0003o0?l01`02o`030?l000@00_l20003o`3o00@000?o0?l00P000ol0
o`0400?o00@0o`3o1P001_l00?l0o`D00_l200;o10001_l00?l0o`<000Go0000o`030005o`000?l0
1@02o`<000Co00000_l20005o`000?l00P000ol0o`020003o`0000@000060005o`000?l01@02o`@0
00?o000010001Ol0003o008000Go0000o`060003o`00008000Oo0000o`3o00D000Go0000o`060003
o`0000@000?o00000P001Ol0003o008000?o00000P001?l00?l20003o`00008000?o0?l01@001ol0
003o0?l010000ol00002o`030?l000H000Go0?l0o`040003o`3o008000?o0?l010001ol0003o0?l0
1`001Ol0o`3o00@000Go003o0002o`@000Go003o0002o`8000Go0000o`0300;o0P001?l00?l200?o
0P000ol000030004o`3oo`8000Ko003o0?l20003o`0000@000060003o`0000;o1@02o`<00_l60003
o`0000800_l40004o`0000?o1@000ol0000200;o1@000ol0000200?o0`001?l00004o`@000?o0000
0P02o`D000Co00000_l500?o1002o`<00ol500;o00@0oooo1003o`800ol500;o0P03o`D01_l400Co
00@0oooo1@02o`800_l500;o0P001?l0ool300;o0`001?l0ool400;o00<0o`000_l300?o0P001?l0
ool400;o0P000ol0000400001P000ol0000700;o2`000ol000080003o`0000T000?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o00002@000ol0
00090003o`0000@000060003o`0000L00_l;0003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol000090003o`0000T0
00?o0000100000D0m_l600001@3fo`H0000600?o00<0ool01002o`/000?o000020000ol000090003
o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol0000400001P001Ol0o`3o00@00ol;0003o`0000P000?o00002@000ol0
00090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o000020000ol0
00090003o`0000T000?o0000100000H000Go003o0004o`030?oo00<00ol50004o`0000Co0`001?l0
0003o`D000?o00000P03o`@000?o00000P02o`@000?o00000P000ol000040003o`0000800_l50003
o`0000?o1@04o`<00ol200Co0`08o`<00ol200Co1003o`030?oo00;o1002o`030?oo00;o10001?l0
0004o`@00_l200?o0`03o`801Ol200?o0P05o`802Ol200?o0P05o`<00ol00`3o000500001P001_l0
o`3o00;o0P02o`@000?o000010000ol000020003o`0000<000?o000010000ol000020003o`0000<0
00?o00000`001Ol0003o008000Go0000o`040003o`0000@000Go0000o`020003o`00008000?o0000
0`000ol000020003o`3o00D000Oo0000o`3o00D000Ko003o0?l70005o`3o0?l01P001_l00?l0o`@0
00?o00000_l00`3o00040007o`000?l0o`040005o`00o`000_l70005o`3o0?l01@001ol0003o0?l0
1@001_l00?l0o`L000Go0?l0o`060004o`00o`H0000600?o00<0ool00_l200;o10000ol000040003
o`0000<000?o00000P000ol000040003o`00008000Co00001?l40005o`000?l00P001Ol0003o00D0
00?o00000`001Ol0003o008000?o00000P001?l00003o`@000?o0?l01@001ol0003o0?l01P001Ol0
o`3o00L000Go0?l0o`0400Co00@0o`3o10000ol00002o`030?l000D000Ko003o0?l40005o`00o`00
0_l500?o00D0o`00o`040005o`000?l00P000ol000030003o`3o008000?o000010000ol0o`020004
o`0000Co00<0o`001@0000H000?o00000P000ol0o`0200;o10000ol000040003o`0000@000Go0000
o`0400;o1@001ol0003o0?l01@001?l00003o`@000?o00000`000ol000030003o`0000800_l50004
o`00o`8000?o00000P000ol0o`050007o`000?l0o`0700;o00<0o`001002o`8000?o0?l010000ol0
o`020003o`3o00@00ol0103o0?l60006o`00o`3o1@02o`800_l40006o`00o`3o0`001Ol0003o00<0
00Go0000o`0500;o0`001?l00002o`8000Go0000o`020003o`3o008000?o0000100000H000[o0000
o`3o0?l00_l40003o`0000@000Go0000o`020005o`000?l01P000ol000020007o`000?l0o`050005
o`000?l01P000ol000040003o`00008000Go0000o`020003o`00008000Co003o0P000ol000020003
o`3o00D000Oo0000o`3o00@000?o00000_l00`3o00060005o`3o0?l010000ol0o`020003o`3o00@0
00Oo0000o`3o00L000Go0?l0o`040005o`00o`000_l40005o`00o`000_l20005o`000?l00`02o`80
00Co003o0P03o`8000?o00000`001?l0ool20006o`00o`3o0P000ol0000400001P001?l00?l20004
o`3o00;o0`02o`H000?o00000P02o`@000Co00000ol50003o`0000800_l50003o`0000800ol30004
o`0000Co10000ol0000200;o1@001?l00002o`D00ol400;o0`03o`D00_l0103oool400?o0P03o`D0
0_l200?o1@06o`@01?l0103oool500;o0P02o`D00_l20004o`3oo`<00_l30004o`3oo`@00_l00`3o
0002o`<00ol20004o`3oo`@00_l20003o`0000@000060003o`3o00800_l00`3oo`02o`/000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o0000
2@000ol000080003o`0000T000?o00002@000ol0000400001P02o`P00_l;0003o`0000P000?o0000
2@000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000T000?o0000
20000ol000090003o`0000T000?o0000100000H0mOl600004002onl0000>00;o4002om000ol<0000
3P000ol0000@0003o`000<l000?o00002`0000P00_l40003o`0000801?l200?o1@000ol0002f00;o
00<0ool02@000ol0o`090003o`0000X000070004o`00o`<000?o00000`000ol000050003o`000080
00?o0000]`000ol0o`0;0003o`0000P000?o00002P0000L000Co003o0`000ol000040003o`0000@0
00?o00000P000ol0002h0003o`0000P01Ol70003o`3o00/000070004o`00o`<000?o00001@000ol0
0003o`D000?o0000]`000ol0o`0;0003o`0000L000?o0?l02`0000L000Co003o0`000ol000020004
o`00o`8000?o00001@000ol0002f00;o00<0ool04`02o`030?oo00X0000600;o0P02o`800_l400;o
0`04o`<00_oO0000o`020000o`020000o`020000\
\>"],
  ImageRangeCache->{{{0, 256.312}, {287, 0}} -> {-1.52511, -2.59509, 
  0.0860286, 0.0860286}},
  CellTags->"Mode"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"Mode"]
}, Open  ]],

Cell[TextData[{
  "If a function does not support a particular mode, the user is notified, \
either with a message or, as in standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " usage, by returning the request."
}], "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaxTaker[5, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"Mode"],

Cell[BoxData[
    \(Mode::"notavail" \( : \ \) 
      "The function \!\(MaxTaker\) does not support the \!\(Visual\) \
mode."\)], "Message",
  CellTags->"Mode"],

Cell[BoxData[
    \(Groupoid[{1, 2, 3, 4, 5}, Max]\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"Mode"]
}, Open  ]],

Cell[TextData[{
  "1.4 Using ",
  StyleBox["Visual",
    FontFamily->"Courier"],
  " mode with \[OpenCurlyDoubleQuote]large\[CloseCurlyDoubleQuote] elements"
}], "Subsection",
  CellTags->{"Visual", "i:12"}],

Cell[TextData[{
  "The elements in some groupoids or ringoids are typographically larger than \
in other structures. For example, when working with permutations in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  ", the elements are too large to fit easily into the graphical Cayley \
table. In such situations, a key is set up to convert from generic elements \
in the table to the actual elements in the groupoid or ringoid."
}], "Text",
  CellTags->"Visual"],

Cell[TextData[{
  "Note the list of rules that define the key, associating generic elements ",
  
  Cell[BoxData[
      \(TraditionalForm\`g\_i\)]],
  " with the various permutations."
}], "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[G\  = Symmetric[3], \ Mode\  \[Rule] \ Visual]; \)\)], 
  "Input",
  CellLabel->"In[45]:=",
  CellTags->"Visual"],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {1, 2, 3}, g2 \
\[Rule] {1, 3, 2}, g3 \[Rule] {2, 1, 3}, g4 \[Rule] {2, 3, 1}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"Visual"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
1 .5 0 r
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.56 .37 .6 r
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
0 0 1 r
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.70408 .16156 m
.70408 .29762 L
.84014 .29762 L
.84014 .16156 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
.74 .99 .79 r
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
.251 .878 .816 r
.84014 .70578 m
.84014 .84184 L
.97619 .84184 L
.97619 .70578 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.15986 .02551 m
.15986 .16156 L
.29592 .16156 L
.29592 .02551 L
F
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
1 .5 0 r
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.56 .37 .6 r
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
0 0 1 r
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.74 .99 .79 r
.70408 .84184 m
.70408 .97789 L
.84014 .97789 L
.84014 .84184 L
F
.251 .878 .816 r
.84014 .84184 m
.84014 .97789 L
.97619 .97789 L
.97619 .84184 L
F
1 1 0 r
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 .5 0 r
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.56 .37 .6 r
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
0 0 1 r
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
.74 .99 .79 r
.02381 .16156 m
.02381 .29762 L
.15986 .29762 L
.15986 .16156 L
F
.251 .878 .816 r
.02381 .02551 m
.02381 .16156 L
.15986 .16156 L
.15986 .02551 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g1)] .22789 .77381 0 0 Mshowa
[(g2)] .36395 .77381 0 0 Mshowa
[(g3)] .5 .77381 0 0 Mshowa
[(g4)] .63605 .77381 0 0 Mshowa
[(g5)] .77211 .77381 0 0 Mshowa
[(g6)] .90816 .77381 0 0 Mshowa
[(g2)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g5)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g3)] .77211 .63776 0 0 Mshowa
[(g4)] .90816 .63776 0 0 Mshowa
[(g3)] .22789 .5017 0 0 Mshowa
[(g4)] .36395 .5017 0 0 Mshowa
[(g1)] .5 .5017 0 0 Mshowa
[(g2)] .63605 .5017 0 0 Mshowa
[(g6)] .77211 .5017 0 0 Mshowa
[(g5)] .90816 .5017 0 0 Mshowa
[(g4)] .22789 .36565 0 0 Mshowa
[(g3)] .36395 .36565 0 0 Mshowa
[(g6)] .5 .36565 0 0 Mshowa
[(g5)] .63605 .36565 0 0 Mshowa
[(g1)] .77211 .36565 0 0 Mshowa
[(g2)] .90816 .36565 0 0 Mshowa
[(g5)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g2)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g4)] .77211 .22959 0 0 Mshowa
[(g3)] .90816 .22959 0 0 Mshowa
[(g6)] .22789 .09354 0 0 Mshowa
[(g5)] .36395 .09354 0 0 Mshowa
[(g4)] .5 .09354 0 0 Mshowa
[(g3)] .63605 .09354 0 0 Mshowa
[(g2)] .77211 .09354 0 0 Mshowa
[(g1)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[45]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H00006000Soo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA800_l0BO4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_lC0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34ol09400BOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol09=l00ol0000400001P008on`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B00;o04V`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1;o0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o02A004Woo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo02CO00?o0000100000H002?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4P02o`19lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<Co`0T@019oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Tg`03o`0000@00006000Sok0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1800_l0BK0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol09400BOolP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol09=l00ol0000400001P008ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B00;o
04Wa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o4`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a?o02A004WoPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo02CO00?o0000100000H002?o/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4P02o`19/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0Bo`?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3o`0T@019oob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0Tg`03o`0000@00006000Soo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA800_l0BO4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_lC0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34ol09400BOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol09=l00ol0000400001P008on`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B00;o04V`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1;o0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o02A004Woo8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo02CO
00?o0000100000H002?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4P02o`19lA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<Co`0T@019oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0Tg`03o`0000@00006000Sok0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1800_l0BK0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol09400BOolP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol09=l00ol0
000400001P008ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B00;o04Wa4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a?o02A004WoPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo02CO00?o0000100000H002?o/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4P02o`19/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0Bo`?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3o`0T@019oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Tg`03o`0000@0
0006000Soo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA800_l0BO4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_lC0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34ol0
9400BOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol09=l00ol0000400001P008on`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B00;o04V`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;o0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o02A004Woo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo02CO00?o0000100000H0
00kolA;a4_4BlA;a4_4Bl@?o01;a4_4BlA;a4_4BlA;a4_4BlA82o`0>lA;a4_4BlA;a4_4BlA83o`0Q
4_4BlA;a4_4BlA;a4_4BlA;a4_lC0a<34`<C0a<34`<C00?o01@C0a<34`<C0a<34`<C0a<34`<Co`e0
0olD@00>oh9aPW62LH9aPW62LH83o`0QPW62LH9aPW62LH9aPW62LH9aP_nOGimOWenOGimOWenO00?o
01BOGimOWenOGimOWenOGimOWenOo`kO0olCg`03o`0000@00006000Sok0B/1:`4[0B/1:`4[0B/1;o
4[0B/1:`4[0B/1:`4[0B/1800_l0BK0B/1:`4[0B/1:`4[0B/1:`ok0B/1:`4[0B/1:`4[0B/1:`4_l3
gP?N0mh3gP?N0mh3gP?Nomh3gP?N0mh3gP?N0mh3gP?N0ol044000om0@00A@019oob2o8;lP_b2o8;l
P_b2o8;oP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
o`0Ag`03omoO013O00?o0000100000H000kolA;a4_4BlA;a4_4Bl@Co014BlOoo4_4BlA;a4_4BlA;a
4P02o`0>lA;a4_4BlA;a4_4BlA84o`0PlA;ooo4BlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a<4o`0C
0oooo`<C0a<34`<C0a<34`<Co`0=@0Co0T03o`i000koPW62LH9aPW62LH9aPPCo021aooooLH9aPW62
LH9aPW62LH;oWenOGimOWenOGimOW`Co00=Oool00_l03YmOWenOGimOWenOGioo3]l4o`04goooo`kO
00?o0000100000H002?o/1:`4[0B/1:`4[0Boa:`4_lBoa:`ok0B/1:`4[0B/1:`4P02o`19/1:`4[0B
/1:`4[0B/?n`4[3o/?n`4_lB/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3g_oN0mkogP?N0ol3gP?N0mh3
gP?N0mh3o`0<@005od10@?l00d000om0@00=@019oob2o8;lP_b2o8;lP_n2o8;oP_b2o?olP_b2o8;l
P_b2o8;loimOWenOGimOWenOGomOWeooGiooWenOGimOWenOGimOWenOo`0=g`05omoOgol00]l00ooO
g`0=g`03o`0000@00006000Soo4BlA;a4_4BlA;a4_lBlA;o4_lBlOoa4_4BlA;a4_4BlA800_l0BO4B
lA;a4_4BlA;a4_7olA;aoo7olA;o4_4BlA;a4_4BlA;a4_lC0a<34`<C0a<34`?o0a<3o`<C0a?o4`<C
0a<34`<C0a<34ol034001_m0@43o@0Co3T00BOn2LH9aPW62LH9aPW7oLH9aog62LH;oPW62LH9aPW62
LH9aP_nOGimOWenOGimOWeooGimOoenOGomOWenOGimOWenOGimOWol03Ml01OoOgmoo00;O00?ogml0
3Ml00ol0000400001P004on`4[0B/1:`4[0B/1;o4[0Boa800ol03A:`4[0B/1:`4[0B/1800_l04k0B
/1:`4[0B/1:`4[3o/1:`ok000ol08K0B/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3g_oN0mkogP03o`0?
gP?N0mh3gP?N0mh3gP?o00a000Wo@410od3o@?l03d005?olP_b2o8;lP_b2o8;oP_b2oh;l0_l0<h;l
P_b2o8;lP_b2o8;loimOWenOGimOWenOGomOWeooGimOWonOGimOWenOGimOWenOo`0=g`05omoOgol0
0]l00ooOg`0=g`03o`0000@00006000>oo4BlA;a4_4BlA;a4_46o`0?4_4BlA;a4_4BlA;a4_4B00;o
00ka4_4BlA;a4_4BlA;a4PKo01ka4_4BlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a<6o`0A0a<34`<C
0a<34`<C0a<34ol03D06o`03@?m000i000koPW62LH9aPW62LH9aPPGo01n2LH;oPW62LH9aPW62LH9a
P_nOGimOWenOGimOWenO00Ko015OWonOGimOWenOGimOWenOo`0>g`Go00?Ooml03]l00ol000040000
1P005?n`4[0B/1:`4[0B/1:`4[0B/1:`0ol03;0B/1:`4[0B/1:`4P;o01B`4[0B/1:`4[0B/1:`4[0B
/1:`4P?o020B/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?N0mh3gPCo00h3gP?N0mh3gP?N0mh3oa=0
0_l?@00Coob2o8;lP_b2o8;lP_b2o8;lPP03o`0RP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenO
GimOW`;o00mOWenOGimOWenOGimOWol04ml2o`oO00?o0000100000H002?olA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4P02o`19lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
oa<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<Co`0T@019oh9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Tg`03
o`0000@00006000Sok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1800_l0BK0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0ol09400BOolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol09=l00ol0000400001P008ooa4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4B00;o04Wa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o4`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o02A004WoPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH;oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo02CO00?o0000
100000H002?o/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4P02o`19/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
o`0T@019oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0Tg`03o`0000@00006000Soo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA800_l0BO4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_lC0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34ol09400BOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aP_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol09=l00ol000040000
1P008on`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B00;o04V`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1;o0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o02A0
04Woo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo02CO00?o0000100000H002?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4P02o`19lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<Co`0T@019oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Tg`03o`0000@00006000S
ok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1800_l0BK0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol09400BOol
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol09=l00ol0000400001P008ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4B00;o04Wa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o4`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a?o02A004WoPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH;oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo02CO00?o0000100000H002?o/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4P02o`19/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3o`0T@019oob2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;loimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0Tg`03o`0000@00006000Soo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA80
0_l0BO4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_lC0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34ol09400BOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol09=l00ol0000400001P008on`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B00;o04V`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1;o0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o02A004Woo8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_coWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo02CO00?o0000100000H002?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4P02o`19
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<Co`0T@019oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Tg`03o`0000@00006000Sok0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1800_l0BK0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol09400BOolP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
9=l00ol0000400001P3oo`7o1P0000H002?ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0`02o`1^gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0BoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolSg`03
od10025002Koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o`H00006000So`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<00_l0KP<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34olBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo8ml00om0@00Q@00Voh9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LOl600001P008ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o
06kN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOob?O00?o@400
8D009_olP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o1P0000H002?o0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`02o`1^0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<Coa;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolSg`03od10025002KoPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9ao`H00006000Somh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0K]h3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0olB/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo8ml00om0@00Q@00V
oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l600001P008ol34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C00;o06h34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a?o4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOob?O00?o@4008D009_n2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW7o1P0000H002?ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0`02o`1^gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0BoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolSg`03od10025002Koo8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o`H00006000So`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<00_l0KP<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34olB
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo8ml00om0@00Q@00Voh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62
LOl600001P008ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o06kN0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOob?O00?o@4008D009_olP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o1P0000H002?o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`02o`1^0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<Coa;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolSg`03od10025002KoPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9ao`H0
0006000Somh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0K]h3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0olB/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo8ml00om0@00Q@00Voob2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l600001P008ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C00;o06h34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOob?O00?o@4008D009_n2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o1P0000H0
02?ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0`02o`1^gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0BoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolSg`03od10025002Koo8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o`H00006000>o`<C0a<34`<C0a<34`<3o`0B0a<34`<C0a<34`<C
0a<34`<C0_l03P<C0a<34`<C0a<34`<C0ol08A<34`<C0a<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a
4P03o`0Q4_4BlA;a4_4BlA;a4_4BlA;a4_mOWenOGimOWenOGimO00?o01EOWenOGimOWenOGimOWenO
GimOWol03Ml3oa?O00?o@4002d03oa=000ooPW62LH9aPW62LH9aPW400ol05762LH9aPW62LH9aPW62
LH9aPW7o1P0000H002?ogP?N0mh3gP?N0mh3gP?N0ol3gP?N0mh3gP?N0mh3gP?N0`02o`1^gP?N0mh3
gP?N0mh3gP?N0mkogP?N0mh3gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1:`4[3o/1:`4[0B/1:`4[0B
/1:`4[0BoenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWol@g`03omoO013O00?o@400
3T000om0@00@@00Voob2o8;lP_b2o8;lP_b2o8;loob2o8;lP_b2o8;lP_b2o8;lP_l600001P003_l3
4`<C0a<34`<C0a<31?l04A?ooolC0a<34`<C0a<34`<C00;o00h34`<C0a<34`<C0a<34`Co0203oooo
0a<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4PCo023a4_oolA;a4_4BlA;a4_4BlA;oGimOWenOGimO
WenOG`Co00>Oool00_l03enOGimOWenOGimOWenOo`0=g`Co00COoooo3]l00om0@00;@0Co0T03o`e0
00ooPW62LH9aPW62LH9aPW401?l04h;ooon2LH9aPW62LH9aPW62LOl01P0000H002?ogP?N0mh3gP?N
0mh3o`?N0ol3gP?Nomh3gP?N0mh3gP?N0`02o`1^gP?N0mh3gP?N0mh3g_oN0mkogP?N0ol3gP?N0mh3
gP?N0mh3oa:`4[0B/1:`4[0B/?n`4[3o/?n`4_lB/1:`4[0B/1:`4[0BoenOGimOWenOGimOWonOGioo
WeooGimOWenOGimOWenOGimOWol<g`05omoOgol00]l00ooOg`0=g`03od1000Y000Go@410o`03@003
od1000a002Koo8;lP_b2o8;lP_b2o?olP_coo8;lP_n2o8;lP_b2o8;lP_b2o`H00006000So`<C0a<3
4`<C0a<34olC0a?o4`<C0ol34`<C0a<34`<C0a<00_l0KP<C0a<34`<C0a<34`?o0a<3o`<C0a?o4`<C
0a<34`<C0a<34olBlA;a4_4BlA;a4_7olA;aoo7olA;o4_4BlA;a4_4BlA;a4_mOWenOGimOWenOGioo
WenOoimOWonOGimOWenOGimOWenOGioo3=l01OoOgmoo00;O00?ogml03Ml00om0@00:@006od10@?m0
1?l=@00Voh9aPW62LH9aPW62LH;oPW62oh9aPW7oLH9aPW62LH9aPW62LOl600001P004ooN0mh3gP?N
0mh3gP?o0mh3o`<00ol03@?N0mh3gP?N0mh3gP<00_l04mh3gP?N0mh3gP?N0mkogP?Nomh00ol08Mh3
gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/?n`4[3o/003o`0d/1:`4[0B/1:`4[0B/1;oGimOWenOGimO
WenOoimOWonOGimOoenOGimOWenOGimOWenOo`cO00GogmoOo`02g`03omoO00gO00?o@4002T002Om0
@43o@?m0o`0>@00Eoob2o8;lP_b2o8;lP_coo8;loob200;o00olP_b2o8;lP_b2o8;lP_l01P0000H0
00ko0a<34`<C0a<34`<C0`Ko00lC0a<34`<C0a<34`<C0a<00_l03P<C0a<34`<C0a<34`<C1_l07P<C
0a<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4PKo01ka4_4BlA;a4_4BlA;a4_4BoenOGimOWenOGimO
Wel6o`0BWeooGimOWenOGimOWenOGioo3Ml5o`03gooO00kO00?o@4002d06o`03@?m000e000ooPW62
LH9aPW62LH9aPW401Ol04W62LOmaPW62LH9aPW62LH9ao`H00006000Comh3gP?N0mh3gP?N0mh3gP?N
0`04o`0<gP?N0mh3gP?N0mh30_l04mh3gP?N0mh3gP?N0mh3gP?N0mh01?l08@?N0mh3gP?N0mh3gP?o
4[0B/1:`4[0B/1:`4[0B/1:`4P03o`0Q4[0B/1:`4[0B/1:`4_mOWenOGimOWenOGimOWenOGimO00;o
012OGimOWenOGimOWenOGioo4]l2o`oO00?o@4004D02o`i001Coo8;lP_b2o8;lP_b2o8;lP_b2o0?o
00olP_b2o8;lP_b2o8;lP_l01P0000H002?o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`02o`1^0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolSg`03
od10025002KoPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9ao`H00006000Somh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP<00_l0K]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0olB/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo8ml00om0@00Q@00Voob2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_l600001P008ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C00;o
06h34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOob?O00?o@400
8D009_n2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o1P0000H002?ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0`02o`1^gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3oa:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0BoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolSg`03od10025002Koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o`H00006000So`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<00_l0KP<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34olBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo8ml00om0@00Q@00V
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOl600001P008ooN0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh300;o06kN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?o4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOob?O00?o@4008D009_olP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;o1P0000H002?o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`02o`1^0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolSg`03od10025002KoPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9ao`H00006000Somh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP<00_l0K]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0olB
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo8ml00om0@00Q@00Voob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_l600001P008ol34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C00;o06h34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOob?O00?o@4008D009_n2LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o1P0000H002?ogP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0`02o`1^gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3oa:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0BoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolSg`03od10025002Koo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o`H0
0006000So`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<00_l0KP<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34olBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo8ml00om0@00Q@00Voh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOl600001P008ooN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh300;o06kN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOob?O00?o@4008D009_olP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o1P0000H0
02?o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`02o`1^0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolSg`03od10025002KoPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9ao`H00006000Somh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP<00_l0K]h3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0olB/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
8ml00om0@00Q@00Voob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l600001P3oo`7o
1P0000H000?o@4008402obA006koP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?Nob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H000060003
od1002100_lT@01^og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aoa;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0olSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P000om0@00P@0;o
9400K_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lB/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko8ml09_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H000?o@4008402obA006koLH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3ob?O02KoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOo`H000060003od1002100_lT@01^oh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lSg`0VoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGol600001P000om0@00P@0;o9400K_maPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo1P0000H000?o@4008402obA006koP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;o4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?Nob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOo`H000060003od1002100_lT@01^og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
oa;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0olSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol60000
1P000om0@00P@0;o9400K_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lB/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mko8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H000?o@400
8402obA006koLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3ob?O
02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H000060003od1002100_lT@01^
oh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lSg`0VoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P000om0@00P@0;o9400K_maPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_7o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o8ml09_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo1P0000H000?o@4008402obA006koP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nob?O02KoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOo`H000060003od1000]00olB@0;o3T03oa=000koLH9aPW62LH9aPW62L@?o
025aPW62LH9aPW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlA800ol08Q;a4_4BlA;a4_4BlA;a4_4BlA;a
o`<C0a<34`<C0a<34`<3o`0D0a<34`<C0a<34`<C0a<34`<C0ol=g`?o4ml03onOGimOWenOGimOWenO
G`03o`0DGimOWenOGimOWenOGimOWenOGol600001P000om0@00>@003od1000m00_lA@003od100110
06koP_b2o8;lP_b2o8;lP_b2o?olP_b2o8;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`4[0B/?n`4[0B
/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh3gP?o0mh3gP?N0mh3gP?N0mh3gP?Noa3O00?ogml0
4=l09_nOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWeoo1P0000H000?o@4002d04o`90
0ol<@0;o3T04o`900ol=@00>og62LH9aPW62LH9aPW44o`0PP_oooh9aPW62LH9aPW62LH9aoa;a4_4B
lA;a4_4BlA84o`0QlA;ooo4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<300Co01<Coooo4`<C0a<3
4`<C0a<34`?o00gO1?l01=ooool>g`0?oimOWenOGimOWenOGimO00Co00>Oool00_l03UnOGimOWenO
GimOWeoo1P0000H000?o@4002T001Om0@43o00=000?o@4002d02o`e000Go@410o`03@003od1000a0
06koP_b2o8;lP_b2o8;loob2o?olP_b2oh;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`ok0B/?n`ok0B
oa:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0ol3gP?o0mh3g_oN0mh3gP?N0mh3gP?No`cO00GogmoO
o`02g`03omoO00gO02KoWenOGimOWenOGimOWonOGiooWeooGimOWenOGimOWenOGimOo`H000060003
od1000Y000Ko@410od04o`a00_l=@006od10@?m01?l=@01^og62LH9aPW62LH9aP_n2LH;oPW62LOma
PW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlOoa4_7olOoa4_lBlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C
0a?o4`<Coa<34`?o0a<34`<C0a<34`<C0ol<g`05omoOgol00]l00ooOg`0=g`0VoimOWenOGimOWenO
GiooWenOoimOWonOGimOWenOGimOWenOGol600001P000om0@00:@009od10@?m0od3o00e00_l=@009
od10@?m0od3o00i001CoP_b2o8;lP_b2o8;loob2o?olPP;o027lP_b2o8;lP_b2o8;lP_lB/1:`4[0B
/1:`4[3o/1:`ok000ol08[0B/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?o0mh3o`<3o`0?0mh3gP?N
0mh3gP?N0mko00cO00GogmoOo`02g`03omoO00gO02KoWenOGimOWenOGimOWonOGiooWenOGomOWenO
GimOWenOGimOo`H000060003od1000]01_l00d3o@00<@0;o3T06o`03@?m000e000koLH9aPW62LH9a
PW62L@Go01maPW7oLH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_4B00Ko01oa4_4BlA;a4_4BlA;a4_4B
lOl34`<C0a<34`<C0a<300Ko014C0a<34`<C0a<34`<C0a<3o`0=g`Go00?Ooml03]l03onOGimOWenO
GimOWenOG`06o`0AWeooGimOWenOGimOWenOGol01P0000H000?o@4004D02o`e00_lD@0;o3T004on2
o8;lP_b2o8;lP_b2o8;lP_`00ol08_b2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/1:`4[0B/183o`0Q
4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP?N0mh300Co00kN0mh3gP?N0mh3gP?Noa;O0_l?g`0E
oimOWenOGimOWenOGimOWenOGimO00;o00nOGimOWenOGimOWenOGol01P0000H000?o@4008402obA0
06koLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3ob?O02KoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H000060003od1002100_lT@01^oh;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lSg`0VoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol600001P000om0@00P@0;o9400K_maPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o8ml09_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo1P0000H000?o@4008402obA006koP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOo`H000060003od1002100_lT@01^og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aoa;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0olSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gol600001P000om0@00P@0;o9400K_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_lB
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mko8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H0
00?o@4008402obA006koLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<3ob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H000060003od100210
0_lT@01^oh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_lSg`0V
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P000om0@00P@0;o9400K_ma
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_7o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o8ml09_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H000?o@4008402obA006koP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nob?O02KoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOo`H000060003od1002100_lT@01^og62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0olSg`0VoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGol600001P000om0@00P@0;o9400K_n2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_lB/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo1P0000H000?o@4008402obA006koLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW7o4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<3ob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H0
00060003od1002100_lT@01^oh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2oa:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3g_lSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P000om0
@00P@0;o9400K_maPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?o
8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H0ool1o`H00006000S
oh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l09H9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LOl08d000ooOg`0Rg`1^oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34ol600001P008oolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b200;o02GlP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o02=000?ogml08]l0K_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o1P0000H002?oPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62L@02o`0UPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9ao`0S@003omoO02;O06koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GioolA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<Co`H00006000Soob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o880
0_l09Ob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l08d000ooOg`0Rg`1^oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol600001P008on2LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02F2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW7o02=000?ogml08]l0K_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWooa
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a?o1P0000H002?oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lPP02o`0U
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o`0S@003omoO02;O06koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[3ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3o`H00006000Soh9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l09H9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LOl08d000ooOg`0Rg`1^oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoo4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34ol600001P008oolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b200;o02GlP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o02=000?ogml08]l0K_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWon`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/?oN
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o1P0000H002?oPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9aPW62L@02o`0UPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
o`0S@003omoO02;O06koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioolA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<Co`H00006000Soob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l09Ob2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l08d000ooOg`0Rg`1^oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol600001P008on2LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW62LH9a00;o02F2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o02=0
00?ogml08]l0K_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWooa4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o
1P0000H002?oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lPP02o`0Uo8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o`0S@003omoO02;O06koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3o`H00006000Soh9aPW62LH9aPW62LH9aPW62LH9aPW62
LH9aPW62LH9aPW400_l09H9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOl08d000ooO
g`0Rg`1^oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoo4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34ol60000
1P003_olP_b2o8;lP_b2o8;l0ol04_b2o8;lP_b2o8;lP_b2o8;lPP;o00klP_b2o8;lP_b2o8;lPP?o
01B2o8;lP_b2o8;lP_b2o8;lP_b2o`e00olC@003omoO00_O0olDg`0>oimOWenOGimOWenOGil3o`0Q
WenOGimOWenOGimOWenOGimOWon`4[0B/1:`4[0B/1:`00?o02:`4[0B/1:`4[0B/1:`4[0B/1:`omh3
gP?N0mh3gP?N0mh30ol050?N0mh3gP?N0mh3gP?N0mh3gP?o1P0000H002?oPW62LH9aPW62LH9aPW62
LOmaPW62LH9aPW62LH9aPW62L@02o`0UPW62LH9aPW62LH9aPW62LH;oPW62LH9aPW62LH9aPW62LH9a
o`0@@003od10011000?ogml03]l00ooOg`0Ag`1^oimOWenOGimOWenOGimOWeooGimOWenOGimOWenO
GimOWenOoo4BlA;a4_4BlA;a4_4BlA;o4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`<C0a<3
o`<C0a<34`<C0a<34`<C0a<34ol600001P003_olP_b2o8;lP_b2o8;l1?l04H;ooon2o8;lP_b2o8;l
P_b200;o00klP_b2o8;lP_b2o8;lPPCo01?looooo8;lP_b2o8;lP_b2o8;o00e01?l2@0?o3D000ooO
g`0;g`Co00COoooo3ml03_nOGimOWenOGimOWenO1?l00eooo`02o`0KWenOGimOWenOGimOWon`4[0B
/1:`4[0B/1:`00Co024B/?oo4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP<01?l04mkooooN0mh3
gP?N0mh3gP?N0ol01P0000H002?oPW62LH9aPW62LH9aog62LOmaPW62oh9aPW62LH9aPW62L@02o`0U
PW62LH9aPW62LH9aP_n2LH;oPW62LOmaPW62LH9aPW62LH9ao`0<@005od10@?l00d000om0@00<@003
omoO00[O00GogmoOo`02g`03omoO00kO06koWenOGimOWenOGimOoenOGomOWonOGimOWenOGimOWenO
GioolA;a4_4BlA;a4_4Boa;a4_lBoa;aoo4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<C0ol34`?o0a<3
4olC0a<34`<C0a<34`<Co`H00006000Soob2o8;lP_b2o8;lP_n2o8;oP_b2o?olP_b2o8;lP_b2o880
0_l09Ob2o8;lP_b2o8;lP_coo8;loob2o8;oP_b2o8;lP_b2o8;lP_l034001_m0@43o@0Co3D000ooO
g`0:g`05omoOgol00]l00ooOg`0>g`1^oimOWenOGimOWenOGomOWeooGimOoenOGimOWenOGimOWenO
ok0B/1:`4[0B/1:`4_lB/1;o4_lB/?n`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mkogP?Nomh3gP?o
0mh3gP?N0mh3gP?N0ol600001P005?n2LH9aPW62LH9aPW7oLH9aog620_l03G62LH9aPW62LH9aPW40
0_l0589aPW62LH9aPW62LH;oPW62oh9a0_l03h9aPW62LH9aPW62LH9ao`0<@009od10@?m0od3o00i0
00?ogml02]l01OoOgmoo00;O00?ogml03]l0=onOGimOWenOGimOWeooGimOoenOGiooWenOGimOWenO
GimOWooa4_4BlA;a4_4BlA;o4_4Boa800ol08Q;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`?o0a<3
o`<3o`0?0a<34`<C0a<34`<C0a?o00H00006000>oob2o8;lP_b2o8;lP_`5o`0@o8;loob2o8;lP_b2
o8;lPP;o00klP_b2o8;lP_b2o8;lPPGo01:2o8;oP_b2o8;lP_b2o8;lP_l=@0Ko00=0od003D000ooO
g`0;g`Go00?Ooml03ml03_nOGimOWenOGimOWenO1_l07UnOoimOWenOGimOWenOGioo/1:`4[0B/1:`
4[0B/0Ko01lB/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh300Ko017N0mh3gP?N0mh3gP?N0mh3
o`0600001P004on2LH9aPW62LH9aPW62LH9aPW400ol03G62LH9aPW62LH9aPW400_l04h9aPW62LH9a
PW62LH9aPW62LH800ol03h9aPW62LH9aPW62LH9ao`0C@0;o3T000ooOg`0@g`;o4=l05?nOGimOWenO
GimOWenOGimOWenO0_l08UnOGimOWenOGimOWenOoo4BlA;a4_4BlA;a4_4BlA;a4_43o`0QlA;a4_4B
lA;a4_4BlOl34`<C0a<34`<C0a<34`<C0a<300Co00hC0a<34`<C0a<34`<Co`H00006000Soob2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8800_l09Ob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_l08d000ooOg`0Rg`1^oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
ok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0ol600001P008on2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o
02F2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o02=000?ogml08]l0K_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlOl34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o1P0000H002?oo8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lPP02o`0Uo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o`0S@003omoO02;O06koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3o`H00006000Soh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l09H9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LOl08d000ooOg`0Rg`1^oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34ol600001P008oolP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8;lP_b200;o02GlP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;o02=000?ogml08]l0K_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?o1P0000H002?oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62L@02o`0UPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9ao`0S@003omoO02;O06koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioolA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<Co`H00006000Soob2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lP_b2o8800_l09Ob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l0
8d000ooOg`0Rg`1^oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOok0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0ol600001P008on2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02F2LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW7o02=000?ogml08]l0K_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a?o1P0000H002?oo8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b2o8;lPP02o`0Uo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o`0S@003
omoO02;O06koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3o`H0
0006000Soh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW400_l09H9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LOl08d000ooOg`0Rg`1^oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34ol600001P008oolP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8;lP_b200;o02GlP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;o02=000?ogml0
8]l0K_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWon`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?o1P0000H0
02?oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62L@02o`0UPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9ao`0S@003omoO02;O06koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioolA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<Co`H00006000Soob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;l
P_b2o8800_l09Ob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_l08d000ooOg`0Rg`1^
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0ol600001P008on2
LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a00;o02F2LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW7o02=000?ogml08]l0K_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a?o1P0000H0ool1o`H00006000SoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l09ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol08ml0K_lC
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_7oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o94000ol000040000
1P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o02FOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo02?O06ko0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`oob2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lobA000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02o`0UWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0Sg`1^oa<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lT@003o`0000@00006000S
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l09ImOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol08ml0K_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_co94000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o02FOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo02?O06ko4`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;aoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obA000?o0000100000H002?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0UWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0Sg`1^o`?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/?olP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o?lT@003o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l09ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol08ml0K_lC0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7o
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o94000ol0000400001P008onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o02FOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo02?O06ko0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lobA000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0U
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0Sg`1^oa<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOn2LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lT@003o`0000@00006000SoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l09ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol08ml0K_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co
94000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o02FOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo02?O06ko4`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;aoh9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obA000?o0000100000H002?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`0UWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0Sg`1^o`?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B
/1:`4[0B/1:`4[0B/1:`4[0B/?olP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lT@003
o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l09ImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol08ml0K_lC0a<34`<C0a<34`<C0a<34`<C0a<34`<C
0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7oPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH;o94000ol0000400001P003_nOGimOWenOGimOWenO0ol04YmO
WenOGimOWenOGimOWenOG`;o00jOGimOWenOGimOWenOG`?o01AOWenOGimOWenOGimOWenOGimOo`gO
0olCg`0>o`?N0mh3gP?N0mh3gP<3o`0R0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/0?o
026`4[0B/1:`4[0B/1:`4[0B/1:`oob2o8;lP_b2o8;lP_`00ol05?b2o8;lP_b2o8;lP_b2o8;lP_co
3T03oa=000?o0000100000H002?oWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOG`02o`0U
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOo`0@g`03omoO013O06ko4`<C0a<34`<C
0a<34`<C0ol34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;o4_4BlA;a4_4BlA;a4_4B
lA;aoh9aPW62LH9aPW62LH9aPW7oLH9aPW62LH9aPW62LH9aPW62oa5000?o@40044000ol000040000
1P003_nOGimOWenOGimOWenO1?l00eooo`02o`0<WenOGimOWenOGimO0_l03YmOWenOGimOWenOGimO
1?l00iooo`02o`0>GimOWenOGimOWenOGol=g`Co00COoooo3]l03_l3gP?N0mh3gP?N0mh31?l08Mko
oooN0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/004o`0P4[3ooa:`4[0B/1:`4[0B/1:`oob2o8;l
P_b2o8;lP_`4o`0CP_oooh;lP_b2o8;lP_b2o8;lo`0>@0Co0T03o`e000?o0000100000H002?oWenO
GimOWenOGimOoenOGomOWonOGimOWenOGimOWenOG`02o`0UWenOGimOWenOGimOWonOGiooWeooGimO
WenOGimOWenOGimOo`0<g`05omoOgol00]l00ooOg`0=g`1^oa<34`<C0a<34`<C0ol34`?o0a<34olC
0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;o4_4Boa;o4_7olA;a4_4BlA;a4_4BlOn2LH9aPW62LH9a
PW7oLH9aog62LH;oPW62LH9aPW62LH9aP_l=@005od10@?l00d000om0@00<@003o`0000@00006000S
oimOWenOGimOWenOGomOWeooGimOoenOGimOWenOGimOWel00_l09ImOWenOGimOWenOGiooWenOoimO
WonOGimOWenOGimOWenOGol03=l01OoOgmoo00;O00?ogml03Ml0K_l3gP?N0mh3gP?N0mkogP?Nomh3
gP?o0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0Boa:`4_lBoa:`ok0B/1:`4[0B/1:`4[3oo8;lP_b2
o8;lP_b2oh;lP_n2o8;loob2o8;lP_b2o8;lP_co3D001_m0@43o@0Co3D000ol0000400001P008onO
GimOWenOGimOWeooGimOoenOGiooWenOGimOWenOGimO00;o02FOGimOWenOGimOWenOoimOWonOGimO
oenOGimOWenOGimOWeoo00cO00GogmoOo`02g`03omoO00gO01?o4`<C0a<34`<C0a<3o`<C0ol300?o
02834`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4Boa;a4_lB0ol08Q;a4_4BlA;a4_4BlA;aoh9aPW62
LH9aPW62LOmaPW7oLH82o`0?LH9aPW62LH9aPW62LH;o00e000Wo@410od3o@?l03T000ol000040000
1P003_nOGimOWenOGimOWenO1_l03enOoimOWenOGimOWenOG`02o`0>WenOGimOWenOGimOWel6o`0A
WeooGimOWenOGimOWenOGol03Ml5o`03gooO00kO00ko0mh3gP?N0mh3gP?N0`Ko01oN0mh3gP?N0mh3
gP?N0mh3g_n`4[0B/1:`4[0B/1:`00Ko01hB/1:`4[0B/1:`4[0B/1:`oob2o8;lP_b2o8;lP_`5o`0B
o8;loob2o8;lP_b2o8;lP_co3T06o`03@?m000e000?o0000100000H001CoWenOGimOWenOGimOWenO
GimOW`;o00eOWenOGimOWenOGimO00;o01BOGimOWenOGimOWenOGimOWenOG`;o00nOGimOWenOGimO
WenOGol04]l2o`oO01?o4`<C0a<34`<C0a<34`<C0a<300Co028C0a<34`<C0a<34`<C0ooa4_4BlA;a
4_4BlA;a4_4BlA;a0ol08?4BlA;a4_4BlA;a4_7oPW62LH9aPW62LH9aPW62LH9a0ol03g62LH9aPW62
LH9aPW62o`0D@0;o3T000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o02FOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo02?O06ko0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B
/1:`oob2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobA000?o0000100000H002?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0UWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0Sg`1^oa<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aP_lT@003o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l09ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol08ml0K_l3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3o
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co94000ol0000400001P008onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o02FOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo02?O06ko4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;aoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62obA000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0U
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0Sg`1^o`?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/?olP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lT@003o`0000@00006000SoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l09ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol08ml0K_lC0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlA;a4_7oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o
94000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o02FOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo02?O06ko0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`oob2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lobA000?o0000100000H002?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`0UWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0Sg`1^oa<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;a4_4BlOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lT@003
o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l09ImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol08ml0K_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3oo8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co94000ol0000400001P008onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o02FOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo02?O
06ko4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_4BlA;aoh9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62obA000?o0000
100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0UWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0Sg`1^o`?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/?olP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o?lT@003o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l09ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol08ml0K_lC
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlA;a4_7oPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o94000ol000040000
1P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o02FOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo02?O06ko0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3
gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`oob2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lobA000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02o`0UWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0Sg`1^oa<34`<C
0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4B
lA;a4_4BlOn2LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lT@003o`0000@00006000S
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l09ImOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol08ml0K_l3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko
/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[3oo8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_co94000ol0000400001P3oo`7o1P0000H000?ogml08=l2obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lob=004[ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0Bo`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lS@01:
o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co8d00B_oN0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1;o1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H0
00060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ooO
g`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH;o8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?ogml08=l2obCO
04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lob=004[ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0Bo`H000060003omoO023O0_lTg`1:oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aP_lS@01:o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co
8d00B_oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1;o1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4Bo`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o8d00B_l34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H0
00?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lob=004[ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0Bo`H000060003omoO00_O
0olBg`;o3]l3oa?O00koGimOWenOGimOWenOG`?o025OWenOGimOWenOGimOWenOGimOog62LH9aPW62
LH9aPW400ol05G62LH9aPW62LH9aPW62LH9aPW62o`0=@0?o4d003_l34`<C0a<34`<C0a<30ol08P<C
0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA83o`0D4_4BlA;a4_4BlA;a4_4BlA;a4_l60000
1P000ooOg`0>g`03omoO00oO0_lAg`03omoO013O04[oGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWeooP_b2o8;lP_b2o8;lP_b2o?olP_b2o8;lP_b2o8;lP_b2o8;loa1000?o@4004400B_oN
0mh3gP?N0mh3gP?N0mh3o`?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/?n`4[0B/1:`
4[0B/1:`4[0B/1;o1P0000H000?ogml02ml4o`04goooo`gO0_l>g`Co00COoooo3]l03_mOWenOGimO
WenOGimO1?l00iooo`02o`0KGimOWenOGimOWenOGomaPW62LH9aPW62LH9a00Co01B2ooooPW62LH9a
PW62LH9aPW62o`e01?l2@0?o3D003_l34`<C0a<34`<C0a<31?l08A?ooolC0a<34`<C0a<34`<C0ooa
4_4BlA;a4_4BlA;a4P04o`0ClA;ooo4BlA;a4_4BlA;a4_4Bo`0600001P000ooOg`0:g`05omoOgol0
0]l00ooOg`0<g`;o3Ml01OoOgmoo00;O00?ogml03Ml0B_mOWenOGimOWenOGiooWenOoimOoenOGimO
WenOGimOWenOGon2o8;lP_b2o8;lP_coo8;loob2o8;oP_b2o8;lP_b2o8;lP_co34001Om0@43o00=0
00?o@4003400B_oN0mh3gP?N0mh3gP?o0mh3o`?N0mkogP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`
ok0B/?n`ok0Boa:`4[0B/1:`4[0B/1;o1P0000H000?ogml02]l01OoOgmoo00;O00?ogml03=l2o`gO
00GogmoOo`02g`03omoO00gO04[oGimOWenOGimOWenOoimOWonOGiooWenOGimOWenOGimOWeooLH9a
PW62LH9aPW62oh9aP_n2LH9aog62LH9aPW62LH9aPW62o`a000Ko@410od04o`e004[o0a<34`<C0a<3
4`<Coa<34olC0a<3o`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlOoa4_7olOoa4_lBlA;a4_4BlA;a
4_4Bo`H000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=g`05omoOgol00]l00ooOg`0=g`0h
oenOGimOWenOGimOWonOGiooWenOGomOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o?olP_coo882o`0@
o8;lP_b2o8;lP_b2o8;lo`a000Wo@410od3o@?l03T004ooN0mh3gP?N0mh3gP?o0mh3o`<00ol08P?N
0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[3o/1:`ok03o`0?/1:`4[0B/1:`4[0B/1;o00H000060003
omoO00_O1Ol00moog`0=g`;o3]l5o`03gooO00kO00koGimOWenOGimOWenOG`Ko01jOGomOWenOGimO
WenOGimOog62LH9aPW62LH9aPW45o`0CLH9aog62LH9aPW62LH9aPW62o`0=@0Ko00=0od003D003_l3
4`<C0a<34`<C0a<31_l07a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA801_l04O4BlA;a4_4B
lA;a4_4BlA;o00H000060003omoO013O0_l>g`;o4ml2o`oO01CoGimOWenOGimOWenOGimOWenOG`;o
026OGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_`00ol04?b2o8;lP_b2o8;lP_b2o?lC@0;o
3T004ooN0mh3gP?N0mh3gP?N0mh3gP<01?l08]h3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B
/183o`0>4[0B/1:`4[0B/1:`4_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o8d00B_l3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;o1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lob=004[ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0Bo`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lS@01:o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_l60000
1P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co8d00B_oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;o1P0000H000?ogml0
8=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H000060003omoO023O0_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH;o8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lob=0
04[ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0Bo`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lS@01:o`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co8d00B_oN0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;o
1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H000060003
omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ooOg`0Pg`;o
9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH;o8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?ogml08=l2obCO04[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lob=004[ogP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0Bo`H000050?oo0_l600001@3oo`;o1P0000H000?o0000
7`03obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H000060003o`0001h000Co0?oo
9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_co8d00B_oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;o1P0000H000?o00007@000ol00002obCO
04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`?olA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H000060003o`0001`000Co00000_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ol0000K0003o`0000800_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aP_lS@01:o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_l600001P000ol0000J0003o`0000<00_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ol0000I0003o`0000@00_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aP_lS@01:o`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_l600001P000ol0000H0003o`0000D00_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ol0000600;o00<0ool030000ol0
000600;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH;o8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?o00001`000ol0
o`0<0003o`0000L00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ol0
00080003o`0000X000?o00002002obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H0
00060003o`0000L000?o0?l02P000ol0000900;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co8d00B_oN0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1;o1P0000H000?o00001P02o`030?oo00P000?o00002P02o`kO0olCg`0>oenOGimOWenOGimO
Wel3o`0QGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9a00?o01EaPW62LH9aPW62LH9aPW62
LH9aP_l03D03oa=000ko0a<34`<C0a<34`<C0`?o02834`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4B
lA;a4_4B0ol051;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?o00004P000ol0000;00;o4Ml00ooO
g`0@g`1:oenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_co
o8;lP_b2o8;lP_b2o8;lP_b2o?l@@003od10011004[ogP?N0mh3gP?N0mh3gP?N0ol3gP?N0mh3gP?N
0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[3o/1:`4[0B/1:`4[0B/1:`4[0Bo`H000060003o`000140
00?o00003002o`kO1?l01=ooool>g`0>oenOGimOWenOGimOWel4o`03Wooo00;o01]OWenOGimOWenO
GimOog62LH9aPW62LH9aPW401?l058;ooon2LH9aPW62LH9aPW62LH;o3D04o`900ol=@00>o`<C0a<3
4`<C0a<34`<4o`0Q4ooooa<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4B00Co01?a4_oolA;a4_4B
lA;a4_4BlA;o00H000060003o`00010000?o00003@02o`gO00GogmoOo`02g`03omoO00gO04[oGimO
WenOGimOWenOoimOWonOGomOWenOGimOWenOGimOWeooP_b2o8;lP_b2o8;loob2o?olP_b2oh;lP_b2
o8;lP_b2o8;lo`a000Go@410o`03@003od1000a004[ogP?N0mh3gP?N0mh3o`?N0ol3gP?Nomh3gP?N
0mh3gP?N0mko/1:`4[0B/1:`4[0B/?n`4[3o/?n`4_lB/1:`4[0B/1:`4[0Bo`H000060003o`0000l0
00?o00003P02o`gO00GogmoOo`02g`03omoO00gO04[oGimOWenOGimOWenOoimOWonOGiooWenOGimO
WenOGimOWeooLH9aPW62LH9aPW62oh9aP_n2LH9aog62LH9aPW62LH9aPW62o`a000Ko@410od04o`e0
04[o0a<34`<C0a<34`<Coa<34olC0a<3o`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlOoa4_7olOoa
4_lBlA;a4_4BlA;a4_4Bo`H000060003o`0000h000?o00003`02o`gO00GogmoOo`02g`03omoO00gO
03SoGimOWenOGimOWenOoimOWonOGimOoenOGimOWenOGimOWeooP_b2o8;lP_b2o8;loob2o?olPP;o
013lP_b2o8;lP_b2o8;lP_co34002Om0@43o@?m0o`0>@00Comh3gP?N0mh3gP?N0ol3gP?o0`03o`0R
0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?n`4[3o/0?o00n`4[0B/1:`4[0B/1:`4_l01P0000H0
00?o00003@000ol0000@00;o3]l5o`03gooO00kO00koGimOWenOGimOWenOG`Ko01jOGomOWenOGimO
WenOGimOog62LH9aPW62LH9aPW45o`0CLH9aog62LH9aPW62LH9aPW62o`0=@0Ko00=0od003D003_l3
4`<C0a<34`<C0a<31_l07a<34`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA801_l04O4BlA;a4_4B
lA;a4_4BlA;o00H000060003o`0000`000?o00001P03o`P00_lCg`;o3ml05?mOWenOGimOWenOGimO
WenOGimO0_l08ImOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;lP_b2o003o`0@o8;lP_b2o8;lP_b2
o8;loa=00_l>@00Comh3gP?N0mh3gP?N0mh3gP?N0`04o`0RgP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B
/1:`4[0B/1:`4P?o00hB/1:`4[0B/1:`4[0Bo`H000060003o`0000/000?o000020000ol0000700;o
9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9a
PW62LH9aPW62LH9aPW62LH;o8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa
4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?o00002P000ol0000:0003
o`0000H00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P000ol000090003
o`0000/000?o00001P02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLH9a
PW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62ob=004[o0a<34`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4Bo`H000060003
o`0000P000?o00002`000ol0o`0700;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co8d00B_oN0mh3gP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1;o
1P0000H000?o00001`000ol0000<0003o`3o00L00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lS@01:o`<C0a<3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_l600001P000ol000060003o`0000`00_l00`3oo`0600;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co
8d00B_oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1;o1P0000H000?o00001@000ol0000H00;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o
8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?o000010000ol0000I00;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co
8d00B_oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1;o1P0000H000?o00000`000ol0000J00;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o
8d00B_l34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;a4_4BlA;o1P0000H000?o00000P000ol0000K00;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGon2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_co
8d00B_oN0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3g_n`4[0B/1:`4[0B/1:`4[0B/1:`
4[0B/1:`4[0B/1:`4[0B/1;o1P0000H000Go0000o`0N00;o9=l0B_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH;o8d00B_l3
4`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0a<34`<C0ooa4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a
4_4BlA;a4_4BlA;o1P0000H000Co003o7`02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o8;lob=004[ogP?N0mh3gP?N
0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`
4[0Bo`H000060003o`3o02000_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aPW62LH9aP_lS@01:o`<C0a<34`<C0a<34`<C0a<3
4`<C0a<34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_4BlA;a4_l60000
1P02ob400_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoh;lP_b2o8;lP_b2
o8;lP_b2o8;lP_b2o8;lP_b2o8;lP_b2o?lS@01:omh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N0mh3gP?N
0mh3gP?Nok0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4[0B/1:`4_l600001P3oo`7o1P0002T0
0_oQ0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000
o`0=0000o`0=0000o`0=0000o`0=00003P02o`X00_oQ00?o300000h000?o00002P000ol0003P0003
o`0000/0000700?o10000ol0000200?o1@000ol0003700;o00<0ool02@000ol0o`090003o`0000X0
00070004o`00o`<000?o00001@000ol000020003o`000<P000?o0?l02`000ol000080003o`0000X0
000900;o0`000ol000050003o`00008000?o0000b@000ol0000800Go1`000ol0o`0;00001`02o`D0
00?o00000`02o`D000?o0000b0000ol0o`0;0003o`0000L000?o0?l02`0000L000Co003o0`000ol0
00050003o`00008000?o0000a`02o`030?oo01<00_l00`3oo`0:00002003o`<00_l300?o1002oo00
003o00d0003o00d0003o00d00000\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"Visual"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ElementToKey",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["el",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                
                StyleBox[\(return\ the\ key\ value\ used\ for\ the\ element\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox["el",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["structure",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["G",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(when\ a\ key\ is\ set\ up\ for\ functions\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["such",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["CayleyTable",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["KeyToElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["key",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ element\ in\ the\ structure\ \),
                  SingleLetterItalics->False], 
                FormBox["G",
                  "TraditionalForm"], 
                StyleBox[\(\ that\ corresponds\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox["key",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->"Visual"],

Cell["Interacting with the key.", "Caption",
  CellTags->"Visual"],

Cell[TextData[{
  "The key corresponding to the permutation {3, 2, 1} is ",
  StyleBox["g6", "MR"],
  "."
}], "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ElementToKey[G, \ {3, 2, 1}]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"Visual"],

Cell[BoxData[
    \("g6"\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->"Visual"]
}, Open  ]],

Cell[TextData[{
  "To reverse the direction, we can specify the key and obtain the \
corresponding element. The key can be given as a symbol or a string. Since it \
is possible that the symbol ",
  StyleBox["g6", "MR"],
  " already has a value (from a previous computation), using a string is \
generally better. Note that if the symbol has already been defined, its value \
is returned."
}], "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{

Cell[BoxData[
    \({KeyToElement[G, \ g6], KeyToElement[G, \ "\<g6\>"], \ g6\  = \ 8, \ 
      KeyToElement[G, \ g6]}\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"Visual"],

Cell[BoxData[
    \({{3, 2, 1}, {3, 2, 1}, 8, "8"}\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"Visual"]
}, Open  ]],

Cell[TextData[{
  "Generally, when the key is displayed, the elements are written using ",
  StyleBox["InputForm", "MR"],
  "."
}], "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[GF[8], \ Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"Visual"],

Cell[BoxData[
    \("KEY for Add(GF[8]): label used \[Rule] element: {g1 \[Rule] 0, g2 \
\[Rule] x^2, g3 \[Rule] x, g4 \[Rule] x + x^2, g5 \[Rule] 1, g6 \[Rule] 1 + \
x^2, g7 \[Rule] 1 + x, g8 \[Rule] 1 + x + x^2}"\)], "Print",
  CellTags->"Visual"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50265 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119678 0.47619 [
[ 0 0 0 0 ]
[ 1 .50265 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .50265 L
0 .50265 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119678 0.477324 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 .5 0 r
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.56 .37 .6 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
0 0 1 r
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.74 .99 .79 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.251 .878 .816 r
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .79 .34 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
0 .392 0 r
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g2)] .28836 .81878 0 0 Mshowa
[(g3)] .39418 .81878 0 0 Mshowa
[(g4)] .5 .81878 0 0 Mshowa
[(g5)] .60582 .81878 0 0 Mshowa
[(g6)] .71164 .81878 0 0 Mshowa
[(g7)] .81746 .81878 0 0 Mshowa
[(g8)] .92328 .81878 0 0 Mshowa
[(g2)] .18254 .71296 0 0 Mshowa
[(g1)] .28836 .71296 0 0 Mshowa
[(g4)] .39418 .71296 0 0 Mshowa
[(g3)] .5 .71296 0 0 Mshowa
[(g6)] .60582 .71296 0 0 Mshowa
[(g5)] .71164 .71296 0 0 Mshowa
[(g8)] .81746 .71296 0 0 Mshowa
[(g7)] .92328 .71296 0 0 Mshowa
[(g3)] .18254 .60714 0 0 Mshowa
[(g4)] .28836 .60714 0 0 Mshowa
[(g1)] .39418 .60714 0 0 Mshowa
[(g2)] .5 .60714 0 0 Mshowa
[(g7)] .60582 .60714 0 0 Mshowa
[(g8)] .71164 .60714 0 0 Mshowa
[(g5)] .81746 .60714 0 0 Mshowa
[(g6)] .92328 .60714 0 0 Mshowa
[(g4)] .18254 .50132 0 0 Mshowa
[(g3)] .28836 .50132 0 0 Mshowa
[(g2)] .39418 .50132 0 0 Mshowa
[(g1)] .5 .50132 0 0 Mshowa
[(g8)] .60582 .50132 0 0 Mshowa
[(g7)] .71164 .50132 0 0 Mshowa
[(g6)] .81746 .50132 0 0 Mshowa
[(g5)] .92328 .50132 0 0 Mshowa
[(g5)] .18254 .3955 0 0 Mshowa
[(g6)] .28836 .3955 0 0 Mshowa
[(g7)] .39418 .3955 0 0 Mshowa
[(g8)] .5 .3955 0 0 Mshowa
[(g1)] .60582 .3955 0 0 Mshowa
[(g2)] .71164 .3955 0 0 Mshowa
[(g3)] .81746 .3955 0 0 Mshowa
[(g4)] .92328 .3955 0 0 Mshowa
[(g6)] .18254 .28968 0 0 Mshowa
[(g5)] .28836 .28968 0 0 Mshowa
[(g8)] .39418 .28968 0 0 Mshowa
[(g7)] .5 .28968 0 0 Mshowa
[(g2)] .60582 .28968 0 0 Mshowa
[(g1)] .71164 .28968 0 0 Mshowa
[(g4)] .81746 .28968 0 0 Mshowa
[(g3)] .92328 .28968 0 0 Mshowa
[(g7)] .18254 .18386 0 0 Mshowa
[(g8)] .28836 .18386 0 0 Mshowa
[(g5)] .39418 .18386 0 0 Mshowa
[(g6)] .5 .18386 0 0 Mshowa
[(g3)] .60582 .18386 0 0 Mshowa
[(g4)] .71164 .18386 0 0 Mshowa
[(g1)] .81746 .18386 0 0 Mshowa
[(g2)] .92328 .18386 0 0 Mshowa
[(g8)] .18254 .07804 0 0 Mshowa
[(g7)] .28836 .07804 0 0 Mshowa
[(g6)] .39418 .07804 0 0 Mshowa
[(g5)] .5 .07804 0 0 Mshowa
[(g4)] .60582 .07804 0 0 Mshowa
[(g3)] .71164 .07804 0 0 Mshowa
[(g2)] .81746 .07804 0 0 Mshowa
[(g1)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Addition)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119678 0.97619 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 .5 0 r
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.56 .37 .6 r
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 0 1 r
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.74 .99 .79 r
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.251 .878 .816 r
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
0 .79 .34 r
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .392 0 r
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g1)] .28836 .81878 0 0 Mshowa
[(g1)] .39418 .81878 0 0 Mshowa
[(g1)] .5 .81878 0 0 Mshowa
[(g1)] .60582 .81878 0 0 Mshowa
[(g1)] .71164 .81878 0 0 Mshowa
[(g1)] .81746 .81878 0 0 Mshowa
[(g1)] .92328 .81878 0 0 Mshowa
[(g1)] .18254 .71296 0 0 Mshowa
[(g8)] .28836 .71296 0 0 Mshowa
[(g6)] .39418 .71296 0 0 Mshowa
[(g3)] .5 .71296 0 0 Mshowa
[(g2)] .60582 .71296 0 0 Mshowa
[(g7)] .71164 .71296 0 0 Mshowa
[(g5)] .81746 .71296 0 0 Mshowa
[(g4)] .92328 .71296 0 0 Mshowa
[(g1)] .18254 .60714 0 0 Mshowa
[(g6)] .28836 .60714 0 0 Mshowa
[(g2)] .39418 .60714 0 0 Mshowa
[(g5)] .5 .60714 0 0 Mshowa
[(g3)] .60582 .60714 0 0 Mshowa
[(g8)] .71164 .60714 0 0 Mshowa
[(g4)] .81746 .60714 0 0 Mshowa
[(g7)] .92328 .60714 0 0 Mshowa
[(g1)] .18254 .50132 0 0 Mshowa
[(g3)] .28836 .50132 0 0 Mshowa
[(g5)] .39418 .50132 0 0 Mshowa
[(g7)] .5 .50132 0 0 Mshowa
[(g4)] .60582 .50132 0 0 Mshowa
[(g2)] .71164 .50132 0 0 Mshowa
[(g8)] .81746 .50132 0 0 Mshowa
[(g6)] .92328 .50132 0 0 Mshowa
[(g1)] .18254 .3955 0 0 Mshowa
[(g2)] .28836 .3955 0 0 Mshowa
[(g3)] .39418 .3955 0 0 Mshowa
[(g4)] .5 .3955 0 0 Mshowa
[(g5)] .60582 .3955 0 0 Mshowa
[(g6)] .71164 .3955 0 0 Mshowa
[(g7)] .81746 .3955 0 0 Mshowa
[(g8)] .92328 .3955 0 0 Mshowa
[(g1)] .18254 .28968 0 0 Mshowa
[(g7)] .28836 .28968 0 0 Mshowa
[(g8)] .39418 .28968 0 0 Mshowa
[(g2)] .5 .28968 0 0 Mshowa
[(g6)] .60582 .28968 0 0 Mshowa
[(g4)] .71164 .28968 0 0 Mshowa
[(g3)] .81746 .28968 0 0 Mshowa
[(g5)] .92328 .28968 0 0 Mshowa
[(g1)] .18254 .18386 0 0 Mshowa
[(g5)] .28836 .18386 0 0 Mshowa
[(g4)] .39418 .18386 0 0 Mshowa
[(g8)] .5 .18386 0 0 Mshowa
[(g7)] .60582 .18386 0 0 Mshowa
[(g3)] .71164 .18386 0 0 Mshowa
[(g6)] .81746 .18386 0 0 Mshowa
[(g2)] .92328 .18386 0 0 Mshowa
[(g1)] .18254 .07804 0 0 Mshowa
[(g4)] .28836 .07804 0 0 Mshowa
[(g7)] .39418 .07804 0 0 Mshowa
[(g6)] .5 .07804 0 0 Mshowa
[(g8)] .60582 .07804 0 0 Mshowa
[(g5)] .71164 .07804 0 0 Mshowa
[(g2)] .81746 .07804 0 0 Mshowa
[(g3)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Multiplication)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 144.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0000X0O?lC07co2`0000X000?oD5002U02o`a@02_oX>2Ph:3PX>2Ph:3PX?lB/1:`4[0B
/1:`4[0Bo`?N0mh3gP?N0mh3gP?o00a001goo8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOo`0<g`03
o`00014000?oD5002E02o`gO00?o@4002d007?oPX>2Ph:3PX>2Ph:3o4[0B/1:`4[0B/1:`4_l=D00Z
o`?N0mh3gP?N0mh3gP?oGimOWenOGimOWenOoob2o8;lP_b2o8;lP_co2`0000X000goT52@D91@T52@
D91@00;o03N@D91@T52@D91@T53oh:3PX>2Ph:3PX>2Ph?lBlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C
0a?o00a001goPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOo`0<g`03o`00014000coD91@T52@D91@
T502o`gO00?o@4002d00DonPh:3PX>2Ph:3PX>3o4_4BlA;a4_4BlA;a4_m@T52@D91@T52@D91@oa<3
4`<C0a<34`<C0a?oGimOWenOGimOWenOoh9aPW62LH9aPW62LH;o00/0000:0003oe1@00?o1e02o`04
D?ooo`Q@00?oX>000ol02n2Ph:3PX>2Poa:`00?o00^`4[0B/1:`4_l3gP03o`0:gP?N0mh3gP?o@0?o
24000oolPP03o`0;P_b2o8;lP_coWel00ol02EnOGimOWenOo`02g`?o1ml00ol0000A0003oe3o00;o
1e02o`;O0ol8g`03od1000?o24000ooPX003o`0:X>2Ph:3PX?lB/0?o00V`4[0B/1:`4_l00U03o`Q@
00?o0mh00ol02]h3gP?N0mh3oel3o`0;GimOWenOGiooo8800ol02H;lP_b2o8;lo`0;00002P003On@
D91@T?n@D91@T5000_l0=i1@T53oD91@T52@D?oPX>2Ph?oPX>2Ph:3Poa;a4_4Boa;a4_4BlA;o4`<C
0a?o4`<C0a<34ol014000om0@005@00Moh9aPW62oh9aPW62LH;oWenOGiooWenOGimOWol01Ml00ooO
g`04g`03o`00014000coD91@T?n@D91@T502o`GO00?ogml01Ml00om0@003@003od1000E005?oX>2P
h:3oX>2Ph:3Poa;a4_4Boa;a4_4BlA;oD91@T53oD91@T52@D?lC0a<34olC0a<34`<CoenOGiooWenO
GimOWon2LH9aP_n2LH9aPW62o`0;00002P000om@D004o`9@0_l2D0;o00=@ool00_l2D0;o0e000onP
h004o`0:X>3oh:3PX?lB/0Co00XB/?oo4[0Bo`?N1?l02@?oool3gP?o@004o`900ol2@003oob200Co
00[looooo8;loimO1?l00iooo`02o`03Gioo00;O1?l01=ooool2g`03o`00014000?oD?l00ol2D0;o
0U02o`;O1?l01=ooool3g`03od1000Co0T03o`9000?oh:001?l02N2Poj3PX?lB/004o`084[3ooa:`
4_l2D0Co0U02o`=@00?o0mh01?l02@?oool3gP?oG`04o`03Wooo00;o00EOWoolPP04o`08o?oooob2
o?l;00002P003On@oi1@T?n@oi1@oe000ol0=E2@D?m@oe2@oi1@on3oh:3Pon2Poj3PX>3o4_lBlA;o
4_lBlOoa4_lCoa<34olC0a<3o`<C00;o0d001Om0@43o00=001ooP_n2LH;oPW62LOmaP_nOoimOWonO
GomOWenOomoo00?O00Cogmoo0ml00ol0000A00;o00Z@D93oT?n@D?m@0_l00moog`02g`04omoOo`CO
00?o@?l00d001Om0@43o00=003OoX?nPh:3oX>3oh:3Poa;o4_4Boa;o4_7olA;oD?m@T53oD?m@T?n@
D?lCoa<34olC0a<3o`<C00;o01ZOGiooWeooGimOWon2oh9aP_n2LH9aog62o`/0000:0003oe3o00=@
00?oD?l00U000om@o`02o`=@00?oD?l00U00;Om@D?nPoj3PX?nPh:3oX>2Poa;o4[0Boa;o4[3o/1;o
0ol3gP?o0mh3g_oN0`02o`=000?o@?l00ol2@00Ooocoo8;loob2o8;oP_coWonOGiooWenOoimOWooO
o`03g`04omoOo`?O00?o00004@02o`=@00?oD?l00U001_m@oooOo`?O00Cogmoo1=l00om0o`03@003
od3o00?o0T007_oPon2Ph?oPX>3oh:3o4_lB/1;o4_lB/?n`4_m@o`=@00?oD?l00U004Om@D?l3o`?N
0ol3gP?Nomh300;o01ZOGiooWenOoimOWooloob2o?olP_b2oh;lo`/0000:0009oi3oT52@oi1@00;o
00>@D?l00_l01U2@D?m@T0;o01U@T53oh?oPX>3oh:3Pon2Ph?lBoa;a4_lB00?o00/BlA;o4olC0a?o
4`03o`034`<C00;o0d001Om0od3o00=000WoP_n2LH;oPW400_l0589aP_nOoimOWonOGimOoenOomoo
0ml01?oOgol3g`03o`0001400_l01Y1@T?n@D0;o00J@D?oogol3g`04omoOo`CO00?o@?l00d001Om0
od3o00=001GoX?nPh:3oX>2Poj3Poa;o4_4Boa800ol031;a4_m@oe2@D?m@T0;o00]@T53o4olC0a?o
4`03o`034`<C00;o01BOGiooWenOGomOWon2oh9aP_n2L@;o00B2LH;o2`0000X000?oD5001_l2D005
oe3ooe001_l2D006oe1@oj3P1Ol02N2Ph?oPX?lB/006o`084[0B/1;o0mh6o`070mh3gP?o@006o`03
@?m0009000?oo8801Ol02H;lP_n2o?nOG`06o`06WeooGioo0]l5o`03gooO00;O00?o00004@000om@
o`05o`9@00CoD?oo0]l5o`03gooO00?O00?o@4001_l00d3o@002@003on2P00Go00RPh:3oX?lB/0Ko
00HB/1:`4_l2D0Ko0U001_m@D?l3gPKo00L3gP?N0omO00Ko00ROGomOWoolPPGo00N2o8;oP_co00/0
000:0009oi1@T52@D91@00;o00^@D?ooT52@D91@T002o`0;D91@on2Ph:3PX>001?l02j3Poa;a4_4B
lA;a00?o00[a4_lC0a<34`<C1?l00`<Co`07@0;o0d002?n2LH9aPW620ol0389aP_nOGimOWenOG`;o
00BOGioo1ml2o`?O00?o00004@002?m@T52@D91@0_l0191@ool7g`;o1=l00om0@006@0;o0d002?nP
h:3PX>2P1?l02^3o4_4BlA;a4_43o`0;lA;oD91@T52@D9000_l02e2@D?lC0a<34`<C00Co00X34omO
WenOGimO0_l02imOWon2LH9aPW6200?o00B2LH;o2`0000X000?oD5002U02o`a@02_oX>2Ph:3PX>2P
h:3PX?lB/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?o00a001goo8;lP_b2o8;lP_b2o?nOGimOWenO
GimOWenOo`0<g`03o`00014000?oD5002E02o`gO00?o@4002d007?oPX>2Ph:3PX>2Ph:3o4[0B/1:`
4[0B/1:`4_l=D00Zo`?N0mh3gP?N0mh3gP?oGimOWenOGimOWenOoob2o8;lP_b2o8;lP_co2`0000X0
00goT52@D91@T52@D91@00;o03N@D91@T52@D91@T53oh:3PX>2Ph:3PX>2Ph?lBlA;a4_4BlA;a4_4B
oa<34`<C0a<34`<C0a?o00a001goPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOo`0<g`03o`000140
00coD91@T52@D91@T502o`gO00?o@4002d00DonPh:3PX>2Ph:3PX>3o4_4BlA;a4_4BlA;a4_m@T52@
D91@T52@D91@oa<34`<C0a<34`<C0a?oGimOWenOGimOWenOoh9aPW62LH9aPW62LH;o00/0000:0003
oe1@00Y@0_l<D00[oj3PX>2Ph:3PX>2Ph:3o4[0B/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3o`0<@00M
oob2o8;lP_b2o8;lP_coWenOGimOWenOGimOWol03=l00ol0000A0003oe1@00U@0_l=g`03od1000]0
01coh:3PX>2Ph:3PX>2Poa:`4[0B/1:`4[0B/1;o3E00:_l3gP?N0mh3gP?N0mh3oenOGimOWenOGimO
WoolP_b2o8;lP_b2o8;lo`/0000:07co4`1lo`/0000:000=on2Ph:3PX>2Ph:3PX002o`0=h:3PX>2P
h:3PX>2Po`0=D00Zo`?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4_n2o8;lP_b2o8;lP_co3D000ooO
g`0;g`0>oimOWenOGimOWenOGolC000<oj3PX>2Ph:3PX>2P0_l=g`0?omh3gP?N0mh3gP?N0mko00a0
00?oD5002e00>?nPh:3PX>2Ph:3PX>2Poh;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`oimOWenOGimO
WenOGioo2`0000X000goX>2Ph:3PX>2Ph:3P00;o04BPh:3PX>2Ph:3PX>3oD91@T52@D91@T52@D?lC
0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;oLH9aPW62LH9aPW62o`e000?ogml02ml03_nOGimOWenO
GimOWeoo4`003?oPX>2Ph:3PX>2Ph0;o3Ml03ol34`<C0a<34`<C0a<3o`0<@016oe2@D91@T52@D91@
T53oh:3PX>2Ph:3PX>2Ph?maPW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlOnOGimOWenOGimOWenOo`/0
000:0003on2P00?o00NPh:3PX>2P00;o00gPooooh:3PX>2Ph:3o009@0ol8D003o`?N00?o00_N0mh3
gP?N0olB/003o`0:/1:`4[0B/1;oPP?o00V2o8;lP_b2o?l00T03o`Q000?ogml00ol8g`03oimO00?o
00QOWenOGimOoa<000?oX?l00_l01j3PX>2Ph:000_l2g`?o2=l00ooN0`03o`090mh3gP?N0mko0090
0ol7@003oe1@00?o25000onPh003o`0;h:3PX>2Ph:3oP_`00ol02_b2o8;lP_b2oa83o`0;4[0B/1:`
4[3oWel00ol02EnOGimOWenOo`0;00002P003OnPh:3PX?nPh:3PX>000_l0A:3PX>3oh:3PX>2Ph?m@
T52@D?m@T52@D91@oa<34`<Coa<34`<C0a?o4_4BlA;o4_4BlA;a4_maPW62oh9aPW62LH;o1D000om0
@005@003omoO00?O00?ogml01Ml03_nOGimOWonOGimOWeoo4`003?oPX>2Poj3PX>2Ph0;o1Ml00ooO
g`05g`0?o`<C0a<3o`<C0a<34`?o00E000?o@4001400A_m@T52@D?m@T52@D91@on2Ph:3Pon2Ph:3P
X>3oLH9aPW7oLH9aPW62LOlBlA;aoo4BlA;a4_7oWenOGiooWenOGimOWol;00002P000ooPX004o`06
h:3oX>2P0_l00n3oo`02o`08X>3oh:3PX?l2D0Co0U02o`=@00?o0mh01?l02P?oool3gP?o4[04o`09
4[3ooa:`4_n200Co00Slooooo8;lo`901?l2@0?o0T000ooOg`04o`04goooo`?O00?oWel01?l00ioo
o`02o`03Gol0018000?oX?l00ol01^2Poj3PX0;o0]l4o`04goooo`?O00?ogP<01?l02=kooooN0mko
0T04o`900ol0143oD504o`9@0_l3D003oj3P00Co00ZPh?oPX>2Poh;l1?l02H;ooon2o8;o4P04o`0:
/1;ook0B/?nOG`Co00>Oool00_l00enOo`0;00002P003OnPoj3PX?nPh?oPX>000ol0=N2Ph?oPX?nP
h:3Poe3oD91@oe3oD93oT53o4olC0a?o4`<C0ol34olBoa;a4_lBoa;aoo4B00;o00j2LH;oPW62LOma
P_m0o`=000Go@410o`03@003omoo00?O00Cogmoo1=l03_nOoimOWonOGomOWeoo4`02o`0:X>2Poj3P
on2Ph0;o00?Ooml00]l01?oOgol4g`0Ao`?o0a<3o`<C0a?o4`?o@?l00d001Om0@43o009002[oD?m@
T53oD?m@T?n@D?oPon2Ph?oPX?nPh:3Pog7oLH9aog62LH;oPW42o`0JlA;aoo7olA;o4_7oWonOGioo
WeooGimOWol;00002P003OoPon2Ph?oPX>3oh:000ol03Z3PX?nPh:3oX>2Poe3o0e000om@o`02D00O
oe1@o`?o0mh3o`?N0mkogP?o4_lB/1;o4_lB/?n`4P02o`0>o8;loob2o8;oP_co@?l3@003od3o00?o
0T000ooOo`03g`04omoOo`CO00koWonOGiooWenOoimOoa<00_l02^2Ph?oPX>3oh:02o`03gooO00;O
00Cogmoo1=l04OoNomh3g_oN0mh3o`?Nod3o00=000?o@?l00ol0143oD?l3D003oe3o009@01ooD53o
X?nPh:3oX>2Poj3PX?n2oh;lP_n2o8;loob200;o01Z`4[3o/?n`4_lB/?nOoimOWonOGiooWenOo`/0
000:000=oj3oX>2Poj3PX?nPh003o`0Dh:3Pon2Ph?oPX>3oD?m@T53oD902o`0;D91@oa?o4`<Coa<0
0ol02a<34olBoa;a4_lB00?o00<BlA800_l01X9aP_n2L@;o00J2LH;o@?l3@005od3o@?l00d000ooO
o`03g`04omoOo`CO00koWonOGiooWenOGomOoa<00_l02Z3PX?nPh:3oX>02o`03gooO00;O00Cogmoo
1=l02?l3o`<C0ol30ol01P<C0om0o`=000Go@?m0o`02@009oe3oD91@oe2@00;o01Y@T53oh?oPX>3o
h:3Pon2Ph?maog62LOmaPP;o00=aPW400_l01O4BlOoa00?o01;a4_7oWonOGiooWenOGomOWol;0000
2P000ooPX005o`05X>2Poj000_l00n3oo`03o`07h:3Pon2Po`02D0Ko0U001_m@D?l3gPKo00P3gP?N
0olB/0Ko00LB/1:`4_n200Go00N2o8;oP_co00901_l00d3o@002@003omoO00Go00?Ooml00ml00onO
G`06o`05WeooGol04`000onPo`04o`05X>2Poj000_l2g`Go00?Ooml00ml00ooN0`06o`06gP?N0mko
0T06o`05@?m0@?l00U06o`9@00KoD53oX>05o`09h:3Pon2Poh;l00Go00SlP_coo8;o4PKo00R`4[0B
/?nOG`Ko00JOGomOWol;00002P002?nPh:3PX>2P1?l02N3ooj3PX>2Ph004o`0;X>3oD91@T52@D900
0_l02e2@D?lC0a<34`<C00Co00/34olBlA;a4_4Bl@03o`09lA;oLH9aPW6200?o00B2LH;o2402o`=0
00?ogml01Ml2o`CO00WoWenOGimOWel00_l00imOo`0C0007on2Ph:3PX004o`03h?oo00OO0_l4g`08
o`<C0a<34`<4o`034`?o00Q00_l2@009oe2@D91@T52@00;o00]@T53oh:3PX>2Ph004o`0:X>3oLH9a
PW62L@?o00]aPW7o4_4BlA;a4P03o`0;4_7oWenOGimOWel00_l019mOWol;00002P003OoPX>2Ph:3P
X>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E00:_l3gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1;oP_b2
o8;lP_b2o8;lo`e000?ogml02ml03_nOGimOWenOGimOWeoo4`003?nPh:3PX>2Ph:3PX0;o3Ml03ooN
0mh3gP?N0mh3gP?No`0<@003oe1@00]@03SoX>2Ph:3PX>2Ph:3PX?n2o8;lP_b2o8;lP_b2oa:`4[0B
/1:`4[0B/?nOGimOWenOGimOWenOo`/0000:000=oj3PX>2Ph:3PX>2Ph002o`14X>2Ph:3PX>2Ph:3P
oe2@D91@T52@D91@T53o4`<C0a<34`<C0a<34olBlA;a4_4BlA;a4_4Bog62LH9aPW62LH9aP_l=@003
omoO00_O00koWenOGimOWenOGimOoa<000coh:3PX>2Ph:3PX>02o`gO00oo0a<34`<C0a<34`<C0ol0
3400A_m@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>3oLH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_7o
WenOGimOWenOGimOWol;00002P003OoPX>2Ph:3PX>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E00:_l3
gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1;oP_b2o8;lP_b2o8;lo`e000?ogml02ml03_nOGimOWenO
GimOWeoo4`003?nPh:3PX>2Ph:3PX0;o3Ml03ooN0mh3gP?N0mh3gP?No`0<@003oe1@00]@03SoX>2P
h:3PX>2Ph:3PX?n2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/?nOGimOWenOGimOWenOo`/0000:07co
4`1lo`/0000:000=ok0B/1:`4[0B/1:`4P02o`0K/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?o00e@
01coX>2Ph:3PX>2Ph:3PX?mOWenOGimOWenOGioo3Ml00om0@00;@00>oob2o8;lP_b2o8;lP_lC000<
oa:`4[0B/1:`4[0B0_l=g`0?on2Ph:3PX>2Ph:3PX>3o00a@01goGimOWenOGimOWenOGolB/1:`4[0B
/1:`4[0Bo`0=@00Loh;lP_b2o8;lP_b2o?oN0mh3gP?N0mh3gP?No`/0000:000=oo4BlA;a4_4BlA;a
4P02o`14lA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a?oD91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3P
oenOGimOWenOGimOWol=g`03od1000]000koPW62LH9aPW62LH9aoa<000co4_4BlA;a4_4BlA82o`gO
03SoX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53oGimOWenOGimOWenOGolBlA;a4_4BlA;a4_4Bo`e0
01coLH9aPW62LH9aPW62o`<C0a<34`<C0a<34`?o2`0000X000?o/1800ol01a:`4[0B/1800_l03k3o
oon`4[0B/1:`4_l3gP03o`09gP?N0mh3gP?o009@0ol8D003oj3P00?o00[PX>2Ph:3PX?mO0ol02EnO
GimOWenOo`02g`?o2=l00om0@003o`Q000?oo8800ol028;lP_b2o8;o4`000olBo`02o`074[0B/1:`
4P02o`;O0ol8g`03on2P00?o00VPh:3PX>2Ph?l00U03o`M@00?oGil00ol02imOWenOGimOoa:`00?o
00V`4[0B/1:`4_l00T03o`Q000?oP_l00_l02h;lP_b2o8;lomh300?o00T3gP?N0mh3g_l02`0000X0
00golA;a4_7olA;a4_4B00;o04Ca4_4Boa;a4_4BlA;o4`<C0a?o4`<C0a<34om@T52@D?m@T52@D91@
on2Ph:3Pon2Ph:3PX>3oGimOWonOGimOWenOo`GO00?ogml01Ml00om0@003@003od1000E000koPW62
LH;oPW62LH9aoa<000co4_4BlOoa4_4BlA82o`GO00?ogml01Ml0>?nPh:3PX?nPh:3PX>2Poi1@T52@
oi1@T52@D?mOWenOGomOWenOGimOoa;a4_4Boa;a4_4BlA;o1D000om0@005@00Log62LH;oPW62LH9a
P_l34`<C0ol34`<C0a<3o`/0000:0003ok0B00Co00J`4_oo/182o`03/?oo00;o00XB/?oo4[0Bo`?N
1?l020?oool3gP?o0U04o`9@0_l3D003oj3P00Co00VPh?oPX>2Poel01?l00iooo`02o`03Gioo00;O
1?l01=ooool3g`03od1000Co0T03o`9000?oo8801?l01ocoooolP_l04`000olBo`03o`06/1;ook0B
0_l2g`Co00COoooo0ml00ooPX004o`08h:3oX>2Ph?l2D0Co0U02o`9@00?oGil01?l00eooo`02o`05
Weoo4[001?l021:`oolB/1;o0T04o`900ol2@003oh;o00?o00[looooo8;lomh31?l02=kooooN0mko
2`0000X000golOoa4_7olOoa4_lB00?o03DBlA;o4_lBlOoa4_lCoa<34olC0a<3o`<Coe3oD91@oe3o
D93oT53oh?oPX>3oh:3oX>2Ph002o`0>WenOoimOoenOGioogol3g`04omoOo`CO00?o@?l00d001Om0
@43o00=000koP_n2LH;oPW62LOmaoa<00_l02_4BlOoaoo4Boa82o`03gooO00;O00Cogmoo1=l0>_nP
oj3PX?nPh?oPX>2Poi3oT52@oi3oT53oD?mOoenOGomOWonOGimOoa;o4_4Boa;o4_7olA;o@?l3@005
od10@?l00d02o`0JPW62oh9aPW7oLH;o0ol34`?o0a<34olC0ol;00002P003On`ok0B/?n`ok0Boa80
0ol071:`4_lBoa:`ok0Bo`?o0mh3o`?N0mkogP?oD?l3D003oe3o009@017oD53oX?nPh:3oX>2Poj3P
X002o`0>WenOoimOWonOGioogol3g`04omoOo`CO00?o@?l00d000om0o`03o`9000koo?olP_coo8;l
P_n2oa<00_l02[0B/?n`ok0Boa82o`03gooO00;O00Cogmoo1=l04OoPon2Ph?oPX>3oh:3Poe3o00=@
00?oD?l00U008Om@oeooGimOoenOGomOWeoo4_lB/1;o4_lB/?n`4_m0o`03@003od3o00?o0T02o`0J
o8;loob2o8;oP_cog_oN0mkogP?N0ol3g_l;00002P002?oaoo4BlOoa0ol00o4Bo`02o`054_4Boa80
0ol02a;a4_lCoa<34olC00?o00`C0a?oD?m@T53oD902o`0AD91@on3oh:3Pon2Ph?oPX>000_l03YmO
WonOGimOoenOomoo0ml01?oOgol4g`03od3o00=000Go@?m0o`03@009oh;oPW62oh9a00;o00>2LOl0
4`02o`05lA;aoo400ol01_4BoooOo`?O00Cogmoo1=l05onPoj3PX?nPh:3oX>2Poi3oT52@oi1@00;o
01R@D?mOoenOGomOWenOoimOoa;o4_4Boa83o`064_4Bod3o0d001Om0od3o00=00_l01X9aP_n2L@;o
00^2LH;o0ol34`?o0`03o`040a<3o`/0000:0003ok0B00Ko00B`4[0B0_l00k3oo`04o`084[0B/1;o
0mh6o`060mh3gP?o0U06o`9@00KoD53oX>05o`08h:3Pon2Poel6o`06WeooGioo0]l5o`03gooO00?O
00?o@4001_l00d3o@002@003oob200Go00J2o8;oP_lC0003oa;o00Go00B`4[0B0_l2g`Go00?Ooml0
0ml00ooPX005o`07X>2Poj3Po`02D0Ko0U001Om@oenO00Ko00QOWonOGolB/0Ko00HB/1:`4_l2@0Ko
00=0od000T000on2o`04o`09P_b2oh;lomh300Ko00KN0mh3g_l;00002P002Ooa4_4BlA;a4P03o`0:
4_oolA;a4_4Bl@?o00[a4_lC0a<34`<C1?l02`<Coe2@D91@T52@00;o00]@T53oh:3PX>2Ph004o`0:
X>3oGimOWenOG`;o00BOGioo1ml2o`CO00?o@4001T02o`=000SoPW62LH9aPP?o00>2LOl04`002?lB
lA;a4_4B0ol00a;oo`07g`;o1=l02?nPh:3PX>2P1?l02n2Poi1@T52@D91@00;o00^@D?mOWenOGimO
W`02o`0<GimOoa;a4_4BlA;a0ol00o4Bo`08@0;o0d001omaPW62LH800ol02h9aP_l34`<C0a<300Co
00<C0ol02`0000X000go/1:`4[0B/1:`4[0B00;o01^`4[0B/1:`4[0B/1;o0mh3gP?N0mh3gP?N0ol0
3E007?nPh:3PX>2Ph:3PX>2PoenOGimOWenOGimOWol=g`03od1000]000koo8;lP_b2o8;lP_b2oa<0
00co4[0B/1:`4[0B/182o`gO00ooh:3PX>2Ph:3PX>2Ph?l035007OmOWenOGimOWenOGimOoa:`4[0B
/1:`4[0B/1;o00e001coP_b2o8;lP_b2o8;lomh3gP?N0mh3gP?N0mko2`0000X000golA;a4_4BlA;a
4_4B00;o04Ca4_4BlA;a4_4BlA;o4`<C0a<34`<C0a<34om@T52@D91@T52@D91@on2Ph:3PX>2Ph:3P
X>3oGimOWenOGimOWenOo`gO00?o@4002d003_n2LH9aPW62LH9aPW7o4`003?lBlA;a4_4BlA;a4P;o
3Ml0>?nPh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?mOWenOGimOWenOGimOoa;a4_4BlA;a4_4BlA;o
3D007?maPW62LH9aPW62LH;o0a<34`<C0a<34`<C0ol;00002P003On`4[0B/1:`4[0B/1800_l06k0B
/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3o`0=D00Loj3PX>2Ph:3PX>2Ph:3oGimOWenOGimOWenOo`gO
00?o@4002d003_olP_b2o8;lP_b2o8;o4`003?lB/1:`4[0B/1:`4P;o3Ml03ooPX>2Ph:3PX>2Ph:3P
o`0<D00MoenOGimOWenOGimOWeoo4[0B/1:`4[0B/1:`4_l03D007?n2o8;lP_b2o8;lP_cogP?N0mh3
gP?N0mh3g_l;00002P1loa<0O?l;00002P003OoN0mh3gP?N0mh3gP<00_l0:Mh3gP?N0mh3gP?N0olB
/1:`4[0B/1:`4[0Boj3PX>2Ph:3PX>2Ph:3o00e@00?ogml02]l07OnOGimOWenOGimOWenOoob2o8;l
P_b2o8;lP_co00a000?o00004@003?l3gP?N0mh3gP?N0`;o3Ml07?nOGimOWenOGimOWenOoob2o8;l
P_b2o8;lP_l=@00Zo`?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4_nPh:3PX>2Ph:3PX>3o3E000ol0
000900002P000ol34`03o`074`<C0a<34`02o`0?0oooo`<C0a<34`<Coa;a00?o00_a4_4BlA;a4_oP
X003o`0;X>2Ph:3PX>3oD9000ol02Y1@T52@D91@oml3o`SO00?oWel00ol02enOGimOWenOoh9a00?o
00UaPW62LH9aP_l00T03o`M000?o00004@000olCo`02o`074`<C0a<34`02o`;O0ol8g`03oimO00?o
00]OWenOGimOWon2L@03o`08LH9aPW62LOl2@0?o24000olC0`03o`0;0a<34`<C0a?o4_400ol02_4B
lA;a4_4Bon03o`0;h:3PX>2Ph:3oT5000ol02E2@D91@T52@o`0;00002P003OoN0mh3g_oN0mh3gP<0
0_l0:Mh3gP?o0mh3gP?N0olB/1:`4_lB/1:`4[0Boj3PX>2Poj3PX>2Ph:3o00E@00?oD5001E000ooO
g`02g`03omoO00GO01goWenOGiooWenOGimOWoolP_b2o?olP_b2o8;lo`05@003od1000A000?o0000
4@003?l3gP?Nomh3gP?N0`;o1Ml00ooOg`05g`0LoimOWenOoimOWenOGiooo8;lP_coo8;lP_b2o`E0
00?o@4001D00:_l3gP?N0ol3gP?N0mh3oa:`4[0Boa:`4[0B/1;oX>2Ph?oPX>2Ph:3Po`E@00?oD500
1E000ol0000900002P000ol34`04o`060oooo`<C0_l00`?oo`02o`0:4ooooa<34olBl@Co00XBlOoo
4_4Bon2P1?l02^2Poj3PX>3oD904o`09D93ooe2@D?oO00Co00COoooo0ml00onOG`04o`03Wooo00;o
00EOWon2L@04o`08P_oooh9aP_l2@0Co0T03o`03@?l0018000?o4ol00ol01P?oool34`;o0]l4o`04
goooo`?O00?oWel01?l00iooo`02o`05GiooPW401?l01h;ooon2LOl00T04o`900ol2@003oa<300Co
00XCoooo4`<Coa;a1?l02A;aoolBlA;oh004o`0:X>3oh:3PX?n@D0Co00R@D?ooT52@o`/0000:000=
omkogP?Nomh3gP?o0`03o`0Z0mh3o`?N0mkogP?o4_lB/1;o4_lB/?n`4_nPoj3PX?nPh?oPX>2Poe3o
0e000om@o`02D003oe1@00;o0ml01?oOgol4g`0OoiooWenOoimOoenOGiooo?olP_coo8;lP_n2o?m0
o`03@005od10@?l00T000ol0000A00;o00[N0mkogP?N0ol30_l00moog`02g`04omoOo`CO01koWonO
GiooWeooGimOWooloob2o?olP_b2oh;o@?l3@005od10@?l00d007?l3o`?N0ol3gP?Nomh3oa;o4[0B
oa;o4[3o/182o`0>h:3Pon2Poj3PX>3oD?l3D003oe3o009@00CoD53o2`0000X000go0ol34`?o0a<3
4olC00?o03DC0a?o4`<C0ol34olBoa;a4_lBoa;aoo4Bon3oh:3Pon2Ph?oPX>3oD?m@T53oD?m@T?n@
D002o`?O00Cogmoo1=l07onOoimOWonOGiooWenOoh;oPW62oh9aPW7oLH;o@?l00d000om0o`03o`03
@?l001800_l02P<C0ol34`<Coa<2o`03gooO00;O00Cogmoo1=l07_nOoimOWonOGiooWenOoh;oPW62
oh9aPW7oLOm0o`=000?o@?l00ol2@00Loa?o4`<Coa<34`?o0a?o4_lBlA;o4_lBlOoa4P;o01ZPh:3o
X>2Poj3PX?n@oi1@T?n@oi1@oe2@o`/0000:0008omkogP?Nomh3o`03gP?o00;o00D3gP?o0`03o`0;
0mh3oa;o4[0Boa800ol051:`4_nPoj3PX?nPh:3oX>2Poe3o0e000om@D002o`=@0_l3g`04omoOo`CO
01OoWonOGiooWenOGomOWooloob2o?olPP02o`06o8;lod3o0d001Om0od3o009000?o00004@02o`05
gP?Nomh00ol01]h3oooOo`?O00Cogmoo1=l05onOoimOWonOGimOoenOoocoo8;loob200;o00GlP_m0
o`03@005od3o@?l00d002?l3o`?N0ol30ol02`?N0olBoa:`4_lB00?o00<B/1800_l03^2Ph?oPX>3o
h:3Poe3o0e000om@D002o`=@00?o00002@0000X000?o0a<01_l010<C0a<2o`030ooo00Co00PC0a<3
4olBl@Ko00PBlA;a4_oPX0Go00VPh:3oX>3oD9001_l01e2@oi1@oml01Ol00moog`03g`03oimO00Ko
00ROGomOWon2L@Go00MaPW7oLH;o00901_l01D3o@43o01<000?o4ol01Ol010<C0a<2o`;O1Ol00moo
g`03g`03oimO00Ko00ROGomOWon2L@Go00IaPW7oLOl2@0Ko00=0od000T000olC0`06o`084`<C0a?o
4_46o`074_4BlA;oh005o`09h:3Pon2Poi1@00Ko00J@D?m@T?l;00002P002?oN0mh3gP?N1?l02@?o
omh3gP?N0`04o`0;gP?o4[0B/1:`4[000ol02[0Boj3PX>2Ph:04o`03h:3o00Q@0_l3D003omoO00CO
0_l4g`09oimOWenOGimO00;o00^OGiooo8;lP_b2o003o`04o8;lo`Q00_l2@003o`00014000Oo0mh3
gP?N00Co00<3ool01ml2o`CO00WoWenOGimOWel00_l02imOWoolP_b2o8;l00?o00?lP_l02402o`=0
00So0mh3gP?N0`Co00_N0olB/1:`4[0B/003o`09/1;oX>2Ph:3P00Co00>Ph?l02502o`=@00?o0000
2@0000X000go0a<34`<C0a<34`<C00;o03L34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_oPX>2Ph:3P
X>2Ph:3Poe2@D91@T52@D91@T53o00cO01goWenOGimOWenOGimOWon2LH9aPW62LH9aPW62o`0<@003
o`00014000co4`<C0a<34`<C0a<2o`gO01coWenOGimOWenOGimOWon2LH9aPW62LH9aPW7o3D00>?lC
0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;oh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o2`0000X0
00gogP?N0mh3gP?N0mh300;o02WN0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4_nPh:3PX>2Ph:3PX>2P
o`0=D003omoO00[O01goWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lo`0<@003o`00014000co0mh3
gP?N0mh3gP<2o`gO01coWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;o3D00:_l3gP?N0mh3gP?N0mh3
oa:`4[0B/1:`4[0B/1;oX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000go0a<34`<C0a<34`<C00;o
03L34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_oPX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T53o00cO
01goWenOGimOWenOGimOWon2LH9aPW62LH9aPW62o`0<@003o`00014000co4`<C0a<34`<C0a<2o`gO
01coWenOGimOWenOGimOWon2LH9aPW62LH9aPW7o3D00>?lC0a<34`<C0a<34`<Coa;a4_4BlA;a4_4B
lA;oh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o2`0000X0O?lC07co2`0000X000?o@4002T02o`a0
01goLH9aPW62LH9aPW62LOmOWenOGimOWenOGimOo`0=g`0goe2@D91@T52@D91@T?nPh:3PX>2Ph:3P
X>2Poo4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<Co`0C0003od1000U00_l=g`0Zoh9aPW62LH9aPW62
LH;o0a<34`<C0a<34`<Con2Ph:3PX>2Ph:3PX>3o3D00:_mOWenOGimOWenOGimOoe2@D91@T52@D91@
T?oa4_4BlA;a4_4BlA;ao`/0000:0003od1000Y00_l<@00Moh;lP_b2o8;lP_b2o8;oGimOWenOGimO
WenOGol03Ml00om@D00:D00Zon2Ph:3PX>2Ph:3PX>3o/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?o
4`000om0@009@0;o3Ml0:_olP_b2o8;lP_b2o8;lomh3gP?N0mh3gP?N0onPh:3PX>2Ph:3PX>2Po`e0
00ooGimOWenOGimOWenOGol035003on`4[0B/1:`4[0B/1:`o`0;00002P000om0@003o`M00_l0143o
ool8@003og6200?o00^2LH9aPW62LOmOW`03o`09WenOGimOWeoo00;O0ol8g`03oe3o00;o00]@T52@
D91@T?nPh003o`0;h:3PX>2Ph:3olA800ol02a;a4_4BlA;ao`<C00?o00PC0a<34`<Coa<000?o@?l0
0_l7@0;o0]l3o`SO00?oPW400ol02g62LH9aPW62o`<C00?o00XC0a<34`<Con2P0ol02J3PX>2Ph:3P
o`02@0?o24000omOW`03o`0:WenOGimOWeooD0?o00]@T52@D91@T?oa4P03o`094_4BlA;a4_7o00/0
000:0003od1000=000?o@4001402o`A000?o@4001D007On2o8;lP_n2o8;lP_b2oenOGimOoenOGimO
Weoo00GO00?ogml01Ml00om@D002D003oe1@00E@02[oh:3PX>3oh:3PX>2Ph?n`4[0B/?n`4[0B/1:`
omh3gP?Nomh3gP?N0olC0003od10009000?o@4001402o`GO00?ogml01Ml0:_olP_b2o?olP_b2o8;l
omh3gP?Nomh3gP?N0onPh:3PX?nPh:3PX>2Po`E000?o@4001D003omOWenOGomOWenOGimOo`04D003
oe1@00E@00oo/1:`4[3o/1:`4[0B/?l02`0000X000?o@4001?l2@0?o00A0oom01?l2@0?o0T000oma
PP04o`0:LOooog62LOmOW`Co00=Oool00_l00imOo`02g`Co00COoooo0ml00om@o`03o`0:T53ooi1@
T?nPh0Co00ZPh?oPX>2Poo4B1?l02_4Boooa4_7o0a<4o`070oooo`<Co`0C0003od3o00?o0T03o`03
@?oo00;O1?l01=ooool3g`03oh9a00Co00Z2ooooPW62o`<C1?l02@?oool34ooPX004o`08h:3oX>2P
h?l2@0Co0T03o`9000?oGil01?l00eooo`02o`04WeooD0Co00Z@D?ooT52@oo4B1?l02?4Boooa4_7o
2`0000X000?o@?l00d001Om0@43o00900ol3@005od10@?l00d007on2oh;lP_n2o8;loob2oeooGimO
oenOoimOWeoogol00ml01?oOgol4g`;o0e000om@o`02D00]oe1@on3oh:3Pon2Poj3PX>3o/?n`4[3o
/?n`4_lB/?oNomh3g_oN0mh3o`?o01<00_l3@005od10@?l00T02o`03gooO00;O00Cogmoo1=l0;?ol
oob2o?olP_b2oh;lomkogP?Nomh3gP?o0onPoj3PX?nPh?oPX>2Pod3o0d001Om0@43o00=000koGomO
WeooGiooWenOG`;o0e000om@o`02D00Boe1@ok3o/1:`ok3o/1;o4[3o2`0000X000?o@?l00d000om0
o`03o`04@?ooo`=000?o@?l00ol2@00Oog7oLH9aog62LH;oPW7oGomOWeooGimOoenOGooOo`03g`04
omoOo`CO0_l0=I1@T?n@oi1@oe2@oj3oX>2Poj3PX?nPh:3olOoa4_7olOoa4_lBlOl3o`<C0ol34`<C
oa?o01<00_l3@003od3o00?o00E0oooOo`03g`04omoOo`CO02coP_n2LH;oPW62LOmaP_l3o`<C0ol3
4`<Coa?oh?oPX>3oh:3Pon2Ph?m0o`=000?o@?l00ol2@00>oeooGimOoenOGomOWel2o`0JT52@oi3o
T53oD93olOoa4_7olOoa4_lBlOl;00002P000om0o`03@005od3o@?l00T03o`=000Go@?m0o`03@009
oh;oP_b2oh;l00;o01B2o8;oGomOWeooGimOWonOGooOo`?O00Cogmoo1=l2o`=@00?oD5000_l3D00F
on3oh:3Pon2Ph?oPX>3o/?n`4[3o/0?o00^`4[3og_oN0mkogP03o`03gP?o01<00_l3@005od3o@?l0
0T02o`03gooO00;O00Cogmoo1=l02Ooloob2o?olPP02o`0;o8;lomkogP?Nomh00ol04mh3oj3oX>2P
oj3PX?nPh:3o@?l00d001Om0od3o00=000koGomOWeooGimOWonOG`;o0e000om@D002o`=@00So/?n`
4[3o/0?o00B`4[3o2`0000X000?o@4001_l0143o@402o`03@?oo00Co00=0od000T000omaPP05o`09
PW62oh9aoenO00Ko00IOWonOGol2g`Go00?Ooml00ml00om@o`05o`08T53oD93oX>05o`09h:3Pon2P
oo4B00Ko00Sa4_4BlOl34`Ko00D34`<Co`0C0003od3o00Go00A0od100_l2g`Go00?Ooml00ml00on2
L@05o`09LH9aog62o`<C00Ko00L34`<Con2P00Go00NPh:3oX>3o00901_l00d3o@002@003oenO00Ko
00MOWonOGom@00Ko00R@D?m@T?oa4PKo00Ka4_4BlOl;00002P000om0@006@0;o0T02o`M00_l3@008
oh;lP_b2o883o`0<P_b2oenOGimOWenO0_l015nOGol7g`;o1=l00om@D005D0;o0e002?oPX>2Ph:3P
1?l02j3Pok0B/1:`4[0B00?o00XB/?oN0mh3gP?N1?l00`?o000B0003od1000E00_l2@0;o1ml2o`CO
00Soo8;lP_b2o0?o00_lP_cogP?N0mh3gP04o`090onPh:3PX>2P00Co00?PX?l02402o`=000WoGimO
WenOGil00_l015nOGol7D0;o0e002On`4[0B/1:`4P03o`034[3o00/0000:0003od1000Y00_l<@00M
og62LH9aPW62LH9aPW7oGimOWenOGimOWenOGol03Ml0=om@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3P
X?oa4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34ol04`000om0@009@0;o3Ml0:_n2LH9aPW62LH9aPW62
o`<C0a<34`<C0a<34ooPX>2Ph:3PX>2Ph:3Po`e002[oGimOWenOGimOWenOGom@T52@D91@T52@D93o
lA;a4_4BlA;a4_4BlOl;00002P000om0@00:@0;o34007On2o8;lP_b2o8;lP_b2oenOGimOWenOGimO
Weoo00gO00?oD5002U00:_oPX>2Ph:3PX>2Ph:3Pok0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3oa<0
00?o@4002D02o`gO02[oo8;lP_b2o8;lP_b2o?oN0mh3gP?N0mh3gP?oX>2Ph:3PX>2Ph:3PX?l=@00?
oenOGimOWenOGimOWeoo00a@00oo/1:`4[0B/1:`4[0B/?l02`0000X000?o@4002T02o`a001goLH9a
PW62LH9aPW62LOmOWenOGimOWenOGimOo`0=g`0goe2@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Poo4B
lA;a4_4BlA;a4_7o0a<34`<C0a<34`<Co`0C0003od1000U00_l=g`0Zoh9aPW62LH9aPW62LH;o0a<3
4`<C0a<34`<Con2Ph:3PX>2Ph:3PX>3o3D00:_mOWenOGimOWenOGimOoe2@D91@T52@D91@T?oa4_4B
lA;a4_4BlA;ao`/0000:07co4`1lo`/0000:000=oh9aPW62LH9aPW62L@02o`0=PW62LH9aPW62LH9a
o`0=@003omoO00_O04GoGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l34`<C
0a<34`<C0a<3oo4BlA;a4_4BlA;a4_l04`003?maPW62LH9aPW62L@;o3Ml0A_oa4_4BlA;a4_4BlA;a
oimOWenOGimOWenOGolC0a<34`<C0a<34`<Cog62LH9aPW62LH9aPW7oD91@T52@D91@T52@D?l<@00?
oj3PX>2Ph:3PX>2Ph:3o00/0000:000=oob2o8;lP_b2o8;lPP02o`0=o8;lP_b2o8;lP_b2o`0=@003
omoO00_O01coGimOWenOGimOWenOGonPh:3PX>2Ph:3PX>3o3E007?oN0mh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`4_lC000<oh;lP_b2o8;lP_b20_l=g`0hok0B/1:`4[0B/1:`4[3oWenOGimOWenOGimOo`?N
0mh3gP?N0mh3gP?oP_b2o8;lP_b2o8;lP_l=D003od1000Y000ooh:3PX>2Ph:3PX>2Ph?l02`0000X0
00?oPW400ol01g62LH9aPW400_l03H;ooon2LH9aPW62LOl00T03o`Q000?ogml00ol8g`03oenO00?o
00ZOGimOWenOGooP0ol02n2Ph:3PX>2Poi1@00?o00]@T52@D91@T?l34`03o`0;4`<C0a<34`?olA80
0ol021;a4_4BlA;o4`000omao`02o`07LH9aPW62L@02o`;O0ol8g`03oo4B00?o00/BlA;a4_4BlOnO
G`03o`0:GimOWenOGolC0`?o00/34`<C0a<34omaPP03o`0;PW62LH9aPW7oD9000ol02Y1@T52@D91@
od03o`Q000?oX>000ol02N2Ph:3PX>2Po`0;00002P003OolP_b2o?olP_b2o8800_l03Ob2o8;oP_b2
o8;lP_l01D000om0@005@003omoO00?O00?ogml01Ml07?mOWenOGomOWenOGimOoj3PX>3oh:3PX>2P
h?l5D003oe1@00E@01cogP?N0mkogP?N0mh3g_n`4[0B/?n`4[0B/1;o4`003?n2o8;loob2o8;lPP;o
1Ml00ooOg`05g`0hok0B/1:`ok0B/1:`4[3oWenOGiooWenOGimOo`?N0mh3o`?N0mh3gP?oP_b2o8;o
P_b2o8;lP_l5D003oe1@00E@00?o@4000T000om0@005@00?on2Ph:3Pon2Ph:3PX>3o00/0000:0003
oh9a00Co00J2ooooPW42o`03P_oo00;o00QaooooLH9ao`901?l2@0?o0T000ooOg`04o`04goooo`?O
00?oGil01?l00eooo`02o`04Weooh0Co00ZPh?oPX>2Poi1@1?l02Y1@oon@D93o0a<4o`0:0oooo`<C
0ooa4PCo00Oa4_oolA;o01<000?oLOl00ol01X;ooon2L@;o0]l4o`04goooo`?O00?olA801?l02_4B
oooa4_7oWel4o`03Wooo00;o00AOoa<31?l02Q?ooolC0a?oLH84o`0:LOooog62LOm@T0Co00U@T?oo
D91@od001?l2@0?o0T000onPh004o`08X>3oh:3PX?l;00002P003Ooloob2o?olP_b2oh800ol03X;l
P_n2o8;loob2od3o0d001Om0@43o00=000?ogol00ml01?oOgol4g`0>oeooGimOoenOoimOWel2o`0>
h:3Pon2Poj3PX>3oD?l3D003oe3o009@01ooD53og_oN0mkogP?N0ol3g_n`ok0B/?n`ok0Boa;o01<0
0_l02_b2o?olP_b2oh82o`03gooO00;O00Cogmoo1=l0>_n`ok0B/?n`ok0Boa:`oiooWenOoimOoenO
Gol3o`?N0ol3gP?Nomh3oh;oP_b2oh;lP_coo8;oD?l3D003oe3o009@00?oD5000_l3@005od10@?l0
0d003ooPon2Ph?oPX?nPh:3Po`0;00002P003On2oh9aP_n2LH9aog400ol03W62LOmaPW62oh9aod3o
0d000om0o`03o`9000?ogol00ml01?oOgol4g`0>oeooGimOoenOGomOWel2o`0eX>2Poj3PX?nPh:3o
T?n@D93oT?n@D?m@T?l3o`<C0ol34`<Coa<3oo7olA;aoo7olA;o4_l04`02o`0:PW62oh9aPW7oL@;o
00?Ooml00]l01?oOgol4g`15oo7olA;aoo7olA;o4_7oWonOGiooWenOoimOoa?o4`<Coa<34`?o0a?o
LOmaPW7oLH9aP_n2LOm@oe2@D?m@oe2@oi1@00;o0d000om0o`03o`9000ooX?nPh:3oX>2Poj3PX?l0
2`0000X000Woo?olP_coo8800_l00ob2o`02o`06P_b2oh;l0_l01X;lP_m0o`=000Go@?m0o`03@003
omoo00?O00Cogmoo1=l03_mOoenOGomOWenOoimO0_l03^2Ph?oPX>3oh:3Poe3o0e000om@D002o`=@
00Sog_oN0mkogP?o00_N0mko/?n`4[3o/003o`03/1;o01<00_l01_b2o?olPP;o00KlP_oogol3g`04
omoOo`CO00So/?n`4[3o/0?o01R`4[3oWonOGiooWenOGomOo`?o0mh3o`<3o`0<0mh3oh;oP_b2oh;l
0_l01X;lP_m@o`=@00?oD5000_l3D0;o0d001Om0od3o00=000ooh?oPX>3oh:3Pon2Ph?l02`0000X0
00?oPW401Ol01G62LOma00;o00>2ool00ol01h9aP_n2LOl00T06o`03@?m0009000?ogml01Ol00moo
g`03g`03oenO00Ko00MOWonOGooP00Go00WPX>3oh:3oT5001_l0291@oe2@o`<C1_l020<C0a<3oo4B
1_l01O4BlA;o01<000?oLOl01?l01G62LOma00;o0]l5o`03gooO00?O00?olA801_l02?4BlA;aoimO
1_l01imOoeoo4`<01_l021<34`<Cog621Ol02H9aP_n2LOm@T006o`07D93oT53o@006o`03@?m00090
00?oX>001Ol01n2Ph?oPX?l02`0000X000Soo8;lP_b2o0?o00[lP_ooo8;lP_b20ol018;lP_l8@0;o
0d000ooOg`05g`;o1=l02OmOWenOGimOW`02o`0:GimOoj3PX>2Ph0Co00>Ph?l02502o`=@00SogP?N
0mh3gPCo00/3g_n`4[0B/1:`4P03o`034_l0018000OoP_b2o8;l00?o00ClP_oo1ml2o`CO00Wo/1:`
4[0B/1800ol02a:`oimOWenOGimO00;o00ZOGol3gP?N0mh31?l02]h3oh;lP_b2o883o`04P_b2o`Q@
0_l3D003od1000E00_l3@008on2Ph:3PX>04o`03X>3o00/0000:000=oh9aPW62LH9aPW62L@02o`0=
PW62LH9aPW62LH9ao`0=@003omoO00_O04GoGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3oT52@D91@
T52@D91@T?l34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_l04`003?maPW62LH9aPW62L@;o3Ml0A_oa
4_4BlA;a4_4BlA;aoimOWenOGimOWenOGolC0a<34`<C0a<34`<Cog62LH9aPW62LH9aPW7oD91@T52@
D91@T52@D?l<@00?oj3PX>2Ph:3PX>2Ph:3o00/0000:000=oob2o8;lP_b2o8;lPP02o`0=o8;lP_b2
o8;lP_b2o`0=@003omoO00_O01coGimOWenOGimOWenOGonPh:3PX>2Ph:3PX>3o3E007?oN0mh3gP?N
0mh3gP?Nok0B/1:`4[0B/1:`4_lC000<oh;lP_b2o8;lP_b20_l=g`0hok0B/1:`4[0B/1:`4[3oWenO
GimOWenOGimOo`?N0mh3gP?N0mh3gP?oP_b2o8;lP_b2o8;lP_l=D003od1000Y000ooh:3PX>2Ph:3P
X>2Ph?l02`0000X000goPW62LH9aPW62LH9a00;o00f2LH9aPW62LH9aPW7o00e000?ogml02ml0AOmO
WenOGimOWenOGimOon2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@o`<C0a<34`<C0a<34`?olA;a4_4B
lA;a4_4Bo`0C000<og62LH9aPW62LH9a0_l=g`16oo4BlA;a4_4BlA;a4_7oWenOGimOWenOGimOoa<3
4`<C0a<34`<C0a?oLH9aPW62LH9aPW62LOm@T52@D91@T52@D91@o`a000ooX>2Ph:3PX>2Ph:3PX?l0
2`0000X0O?lC07co2`0000X000goWenOGimOWenOGimO00;o00fOGimOWenOGimOWeoo00gO00?o@400
2d00AOmaPW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<3oi1@T52@D91@T52@D93o
X>2Ph:3PX>2Ph:3Po`0C000<oenOGimOWenOGimO0_l=g`1Coi1@T52@D91@T52@D93olA;a4_4BlA;a
4_4Bog62LH9aPW62LH9aPW7oGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3Poa<34`<C0a<34`<C0ol0
3D000ol0000900002P003OnOGimOWenOGimOWel00_l03ImOWenOGimOWenOGol03Ml00om0@00;@00Z
oh;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mko3E003_oPX>2Ph:3PX>2Ph:3o
4`003?mOWenOGimOWenOG`;o3Ml00om@D00;D015ok0B/1:`4[0B/1:`4_n2o8;lP_b2o8;lP_b2oenO
GimOWenOGimOWeooX>2Ph:3PX>2Ph:3PX?l3gP?N0mh3gP?N0mko00e000?o00002@0000X000?oWel0
0ol01enOGimOWel00_l03IoooonOGimOWenOGol00]l3o`SO00?o@4000ol8@003og6200?o00Z2LH9a
PW62LOlB0ol02a;a4_4BlA;ao`<C00?o00/C0a<34`<C0on@D003o`0;D91@T52@D93oX>000ol02>2P
h:3PX>3o4`000omOo`02o`07GimOWenOG`02o`;O0ol8g`03oi1@00?o00]@T52@D91@T?oa4P03o`0:
4_4BlA;a4_maPP?o00^2LH9aPW62LOmOW`03o`0;WenOGimOWeooh:000ol02Z3PX>2Ph:3Poa<3o`09
4`<C0a<34`?o00900ol8@003o`0000T0000:000=oimOWenOoimOWenOG`02o`0=WenOGomOWenOGimO
o`05g`03omoO00GO00?o@4000d000om0@005@00Zoh;lP_b2oh;lP_b2o8;o4[0B/?n`4[0B/1:`omh3
gP?Nomh3gP?N0mko1E000om@D005D00>on2Ph:3Pon2Ph:3PX?lC000<oenOGiooWenOGimO0_l5g`03
omoO00GO00?oD5000e000om@D005D015ok0B/1:`ok0B/1:`4_n2o8;lP_n2o8;lP_b2oenOGimOoenO
GimOWeooX>2Ph:3oX>2Ph:3PX?l3gP?Nomh3gP?N0mko00E000?o@4001D000ol0000900002P000onO
G`04o`03Wooo00;o00AOoonO1?l00eooo`02o`03Weoo00;O1?l01=ooool3g`03od1000Co0T03o`90
00?oLH801?l02G7ooomaPW7o4P04o`0:lA;ooo4BlOl34`Co00X3oooo0a<3oi1@1?l02Y1@oon@D93o
X>04o`07X>3oh:3Po`0C0003oeoo00?o00>Oool00_l00eooo`02g`Co00COoooo0ml00on@D004o`0:
T53ooi1@T?oa4PCo00Wa4_oolA;oLH801?l02W7ooomaPW7oGil4o`03Gooo00;o00FOGooPX004o`09
h:3oX>2Ph?lC00Co00P3oooo0a<3o`901?l2@0?o0T000ol0000900002P003OnOoimOWonOGomOWel0
0ol03UnOGomOWonOGimOomoo0ml01?oOgol4g`03od3o00=000Go@410o`03@00>oh;oP_b2oh;lP_co
o882o`0L/1:`ok3o/1;o4[3og_oN0mkogP?N0ol3g_m@o`=@00?oD?l00U004Om@D?oPon2Ph?oPX?nP
h:3o01<00_l02YmOWonOGomOWel2o`03gooO00;O00Cogmoo1=l00om@o`03D003oe3o009@03[oD53o
/?n`4[3o/?n`4_lBoh;oP_b2oh;lP_coo8;oGomOWeooGiooWenOGonPoj3PX?nPh?oPX>2P0_l03]h3
g_oN0mh3o`?Nod3o0d001Om0@43o00=000?o00002@0000X000goWonOGiooWenOoimO00?o00iOWeoo
GimOoenOGooOo`?O00Cogmoo1=l00om0o`03@003od3o00?o0T003_maog62LOmaPW62oh9a0_l0=O4B
lOoaoo4Boa;ao`?o0a<3o`<C0a?o4`?oT?n@D93oT?n@D?m@T?nPoj3PX?nPh:3oX>3o01<00_l02YmO
WonOGiooWel2o`03gooO00;O00Cogmoo1=l0AOn@oi1@T?n@oi1@oe2@oo7olA;aoo7olA;o4_maog62
LOmaPW62oh9aoeooGimOoenOGomOWeooh?oPX>3oh:3Pon2Ph002o`0>0a<3o`<C0a?o4`?o@?l3@003
od3o00?o0T000ol0000900002P003OnOoimOWonOGimOoel00ol03UnOGomOWenOoimOomoo0ml01?oO
gol4g`03od3o00=000Go@?m0o`03@009oh;oP_b2oh;l00;o00>2o8800_l01K0B/?n`00?o00^`4[3o
g_oN0mkogP03o`06gP?Noe3o0e000om@D002o`=@00koh?oPX>3oh:3Pon2Poa<00_l02YmOWonOGimO
oel2o`03gooO00;O00Cogmoo1=l00om@o`03D003oe1@00;o0e002?n`ok0B/?n`0ol02k0Boh;oP_b2
oh;l00;o01n2o8;oGomOWeooGimOWonOGonPoj3PX?nPh:3oX>2P00;o00GN0mkogP03o`06gP?Nod3o
0d001Om0od3o00=000?o00002@0000X000?oWel01_l019mOoel2o`03Wooo00Co00IOWonOGol2g`Go
00?Ooml00ml00om0@006o`03@?m0009000?oLH801Ol0289aP_n2LOlB1_l02?4BlA;ao`<C1_l020<C
0a<3oi1@1_l0291@oe2@oj3P1Ol01^2Ph?oPoa<000?oGol01Ol019mOoel2o`;O1Ol00moog`03g`03
oi1@00Ko00R@D?m@T?oa4PKo00Oa4_4Bog6200Go00V2LH;oPW7oGil01_l025nOoimOon2P1Ol02:3P
X?nPh?lC1_l01P<C0a<3o`901_l00d3o@002@003o`0000T0000:0009oimOWenOGimO00;o00^OGooo
WenOGimOW`02o`04GimOo`OO0_l4g`03od1000I00_l3@008oh;lP_b2o883o`0;P_b2oa:`4[0B/180
0ol02Q:`omh3gP?N0mh4o`030mko00Q@0_l3D008on2Ph:3PX>04o`03X?l0018000SoGimOWenOG`;o
00BOGooo1ml2o`CO00?oD5001U02o`=@00Wo/1:`4[0B/1800ol02A;oP_b2o8;lPP03o`0<P_b2oenO
GimOWenO0_l02enOGonPh:3PX>2P00Co00WPX?l3gP?N0mh01?l00`?No`08@0;o0d000ol000090000
2P003OnOGimOWenOGimOWel00_l03ImOWenOGimOWenOGol03Ml00om0@00;@015og62LH9aPW62LH9a
PW7o4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`?oT52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>3o01<0
00coGimOWenOGimOWel2o`gO05?oT52@D91@T52@D91@T?oa4_4BlA;a4_4BlA;oLH9aPW62LH9aPW62
LOmOWenOGimOWenOGimOon2Ph:3PX>2Ph:3PX>3o4`<C0a<34`<C0a<3o`0=@003o`0000T0000:000=
oimOWenOGimOWenOG`02o`0=WenOGimOWenOGimOo`0=g`03od1000]002[oP_b2o8;lP_b2o8;lP_lB
/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3g_l=D00>on2Ph:3PX>2Ph:3PX?lC000<oenOGimOWenOGimO
0_l=g`03oe1@00]@04Go/1:`4[0B/1:`4[0Boh;lP_b2o8;lP_b2o8;oGimOWenOGimOWenOGonPh:3P
X>2Ph:3PX>2Po`?N0mh3gP?N0mh3g_l03D000ol0000900002P003OnOGimOWenOGimOWel00_l03ImO
WenOGimOWenOGol03Ml00om0@00;@015og62LH9aPW62LH9aPW7o4_4BlA;a4_4BlA;ao`<C0a<34`<C
0a<34`?oT52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>3o01<000coGimOWenOGimOWel2o`gO05?oT52@
D91@T52@D91@T?oa4_4BlA;a4_4BlA;oLH9aPW62LH9aPW62LOmOWenOGimOWenOGimOon2Ph:3PX>2P
h:3PX>3o4`<C0a<34`<C0a<3o`0=@003o`0000T0000:07co4`1lo`/0000:0003omoO00[O0_l<g`0M
oenOGimOWenOGimOWeooLH9aPW62LH9aPW62LOl03D00=olC0a<34`<C0a<34`?olA;a4_4BlA;a4_4B
lOnPh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?l04`000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O
00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO00?o
1ml2o`04goooo`SO00?oGil00ol02imOWenOGimOoh;l00?o00WlP_b2o8;lP_l00T03o`Q000?o0ol0
0_l02`?N0mh3gP?Nok0B00?o00/B/1:`4[0B/?oPX003o`09X>2Ph:3PX>3o009@0ol7D003o`000140
00?ogol00_l7g`;o0]l3o`SO00?ogml00ol8g`03omoO00?o1ml00ooOg`03o`SO00?ogml00ol8g`03
omoO00?o2=l00ooOo`02o`SO00?ogml00ol8g`03o`0000T0000:0003omoO00?O00?ogml01=l2o`CO
00?ogml01Ml07OmOWenOGomOWenOGimOog62LH9aog62LH9aPW7o00E000?o@4001D00=olC0a<3o`<C
0a<34`?olA;a4_7olA;a4_4BlOnPh:3PX?nPh:3PX>2Poi1@T52@oi1@T52@D?l04`000ooOg`02g`03
omoO00CO0_l5g`03omoO00GO00?ogml00ml00ooOg`05g`03omoO00?O00?ogml01=l00ooOg`03g`03
omoO00GO00?ogml00ml00ooOg`05g`03omoO00?O00?ogml01Ml00ooOg`02g`03omoO00GO00?ogml0
0ml00ooOg`05g`03o`0000T0000:0003omoO00Co00COoooo0]l2o`03gooo00;o00COoooo0ml00omO
W`04o`03Gooo00;o00FOGon2o004o`08P_oooh;lP_l2@0Co0T03o`9000?o0ol00ol02]kooooN0mko
/184o`0:/1;ook0B/?oPX0Co00SPX?nPh:3Po`9@1?l2D0;o0U000ol0000A0003omoo00?o00COoooo
0]l2o`;O1?l01=ooool3g`03omoO00Co00COoooo0ml00ooOg`04o`04goooo`;O00?ogml01?l01=oo
ool3g`03omoO00Co00COoooo0ml00ooOg`04o`04goooo`?O00?ogol00ol01=ooool3g`03omoO00Co
00COoooo0ml00ol0000900002P000ooOo`03g`04omoOo`?O0ol3g`04omoOo`CO01ooGomOWeooGioo
WenOGomaog62LOmaPW62oh9aod3o00=000Go@410o`03@0;o03D34`?o0a<34olC0ooaoo4BlOoaoo4B
oa;aoj3oX>2Poj3Pon2Ph:3oT?n@D93oT?n@D?m@o`0C00;o0ml01?oOgol3g`;o00?Ooml00]l01?oO
gol4g`03omoo00?O00Cogmoo1=l00ooOo`03g`04omoOo`?O00?ogol00ml01?oOgol4g`03omoo00?O
00Cogmoo1=l00ooOo`03g`04omoOo`CO0_l3g`04omoOo`CO00?ogol00ml01?oOgol4g`03o`0000T0
000:0003omoo00?O00Cogmoo0ml3o`?O00Cogmoo1=l07omOoenOGomOWeooGimOoh;oP_b2oh;lP_co
o8;o@?l00d000om0o`03o`900_l0:]h3g_oN0mh3o`?Nok3o/1:`ok3o/1;o4[3oh?oPX>3oh:3Pon2P
h?m@o`=@00?oD?l00U000om@o`0C00;o0ml01?oOgol3g`;o00?Ooml00]l01?oOgol4g`03omoo00?O
00Cogmoo1=l00ooOo`03g`04omoOo`?O00?ogol00ml01?oOgol4g`03omoo00?O00Cogmoo1=l00ooO
o`03g`04omoOo`CO0_l3g`04omoOo`CO00?ogol00ml01?oOgol4g`03o`0000T0000:0003omoo00?O
00Cogmoo0ml3o`?O00Cogmoo1=l05omOoenOGomOWenOoimOog7oLH9aog6200;o00IaPW7o@?l3@005
od3o@?l00d02o`050a<3o`<00ol02`<C0ooaoo4BlOoa00?o01[a4_7oX?nPh:3oX>2Poj3PX?n@oi1@
T?n@D0;o00>@D?l04`02o`?O00Cogmoo0ml2o`03gooO00;O00Cogmoo1=l00ooOo`03g`04omoOo`CO
00?ogol00ml01?oOgol3g`03omoo00?O00Cogmoo1=l00ooOo`03g`04omoOo`CO00?ogol00ml01?oO
gol4g`;o0ml01?oOgol4g`03omoo00?O00Cogmoo1=l00ol0000900002P000ooOg`05o`03gooO00;O
0_l00mooo`03o`03gooO00?O00?oGil01_l025nOoimOoh;l1Ol01ob2o?olP_l00T06o`03@?m00090
00?o0ol01Ol02=h3gP?Nok0B1_l02;0B/1:`on2P1Ol01j3PX?nPh?l00U06o`9@00?oD?l04`000ooO
o`04o`03gooO00;O0_l2g`Go00?Ooml00ml00ooOg`05o`03gooO00?O00?ogml01Ol00moog`02g`03
omoO00Go00?Ooml00ml00ooOg`05o`03gooO00?O00?ogml01Ol00moog`03g`03omoo00Co00?Ooml0
0ml00ooOg`05o`03gooO00?O00?o00002@0000X000?ogml01Ml2o`?O0_l6g`;o1=l02OmOWenOGimO
W`02o`0;GimOog62LH9aPW400ol01762LOl8@0;o0d001olC0a<34`<01?l02a<3oo4BlA;a4_4B00?o
00XBlOnPh:3PX>2P1?l02n2Poi1@T52@D91@00;o00>@D?l04`000ooOg`04g`;o0ml2o`OO0_l4g`03
omoO00GO0_l4g`03omoO00GO0_l3g`03omoO00GO0_l4g`03omoO00GO0_l4g`03omoO00GO0_l4g`03
omoO00CO0_l4g`03omoO00GO0_l4g`03o`0000T0000:0003omoO00[O0_l<g`0MoenOGimOWenOGimO
WeooP_b2o8;lP_b2o8;lP_l03D00:_l3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?oPX>2Ph:3PX>2P
h:3Po`a@00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03
omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO00[O0_l<g`0MoenOGimOWenOGimO
WeooLH9aPW62LH9aPW62LOl03D00=olC0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlOnPh:3PX>2Ph:3P
X>2Poi1@T52@D91@T52@D?l04`000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooO
g`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO00[O0_l<g`0MoenOGimO
WenOGimOWeooP_b2o8;lP_b2o8;lP_l03D00:_l3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?oPX>2P
h:3PX>2Ph:3Po`a@00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooO
g`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000907go4P1mo`/0000907go4P1mo`/0
000:0003o`0000T00ol<g`0MoenOGimOWenOGimOWeooLH9aPW62LH9aPW62LOl03D00=olC0a<34`<C
0a<34`?olA;a4_4BlA;a4_4BlOnPh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?l04`000ol0000900;o
3Ml07?nOGimOWenOGimOWenOoh9aPW62LH9aPW62LOl=@00hoa<34`<C0a<34`<C0a?o4_4BlA;a4_4B
lA;a4_oPX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l;00002P001Ol0ool000;o10001Ol0oooO00?o
2=l00omOW`03o`0;WenOGimOWeooP_`00ol02Ob2o8;lP_b2o`02@0?o24000ol3o`02o`0;0mh3gP?N
0mko/1800ol02a:`4[0B/1:`on2P00?o00VPh:3PX>2Ph?l00U03o`M@00?o00004@03o`030?oo00D0
0ol2g`?o2=l00onOG`03o`0;GimOWenOGiooo8800ol028;lP_b2o8;o0T03o`Q000?o0mh00ol02mh3
gP?N0mh3oa:`00?o00Z`4[0B/1:`4_nP0ol02J3PX>2Ph:3Po`02D0?o25000ol0000900002P001_l0
0?l0o`@000?o00000_l4g`03omoO00GO01goGimOWeooGimOWenOGomaPW62LOmaPW62LH9ao`05@003
od1000E003Oo4`<C0ol34`<C0a<3oo4BlA;aoo4BlA;a4_7oX>2Ph:3oX>2Ph:3PX?n@D91@T?n@D91@
T53o01<000Go0?l0o`050004o`3oo`GO00?ogml01Ml07?nOGimOWonOGimOWenOoh9aPW62oh9aPW62
LOl5@003od1000E003So4`<C0a?o4`<C0a<34olBlA;a4_lBlA;a4_4Bon2Ph:3oX>2Ph:3PX?n@D91@
T?n@D91@T52@o`/0000:0005o`000?l010001?l00002o`03gooo00;o00COoooo0ml00omOW`04o`03
Gooo00;o00FOGon2o004o`08P_oooh;lP_l2@0Co0T03o`9000?o0ol00ol02]kooooN0mko/184o`0:
/1;ook0B/?oPX0Co00SPX?nPh:3Po`9@1?l2D0;o0U000ol0000A0004o`00o`D000?o00000_l2g`Co
00COoooo0ml00onOG`04o`03Wooo00;o00EOWoolPP04o`07o?oooob2o`02@0Co0T03o`9000?o0mh0
1?l02P?oool3gP?o4[04o`094[3ooa:`4_nP00Co00SPX?nPh:3Po`9@1?l2D0;o0e000ol000090000
2P001ol00?l0o`000ol300?o0ml01?oOgol4g`0OoeooGimOoenOoimOWeooLOmaPW7oLH9aP_n2LOm0
o`03@005od10@?l00d02o`0e0a<3o`<C0a?o4`?olOoa4_7olOoa4_lBlOnPoj3PX?nPh?oPX>2Poi3o
T52@oi3oT53oD?l04`001Ol0o`3o00800ol200;o00?Ooml00]l01?oOgol4g`0NoiooWenOoimOoenO
GiooP_n2LH;oPW62LOmaod3o0d001Om0@43o00=001co4olC0a?o4`<C0ol34olBoa;a4_lBoa;aoo4B
0_l06Z3PX?nPh?oPX>2Poi3oT52@oi3oT53oD93o2`0000X000Go0?oo0004o`@00ol3g`04omoOo`CO
01ooGomOWeooGimOoenOGon2oh;lP_n2o8;loob2od3o00=000?o@?l00ol2@0;o02[N0mkogP?N0ol3
g_n`ok0B/?n`ok0Boa:`on3oh:3Pon2Ph?oPX>3oD?l3D003oe3o009@00?oD?l04`03o`040?oo00;o
0`02o`03gooO00;O00Cogmoo1=l07_nOoimOWonOGiooWenOoocoo8;loob2o8;oP_m0o`=000?o@?l0
0ol2@00Lo`?o0mh3o`?N0mkogP?o4_lB/1;o4_lB/?n`4P;o00kPX>3oh:3Pon2Ph?m@o`=@00?oD?l0
0U001?m@D?l;00002P000ol000030004o`00o`<00ol3g`04omoOo`CO01OoGomOWeooGimOWonOGoma
og62LOmaPP02o`06LH9aod3o0d001Om0od3o00=00_l01@<C0ol300?o00/34`?olOoa4_7ol@03o`0J
lA;aoj3oX>2Poj3PX?nPh:3oT?n@D93oT502o`03T53o01<000?o00000`001?l00?l200;o00?Ooml0
0]l01?oOgol4g`0GoiooWenOoimOWeooGiooP_n2LH;oPW400_l01H9aod3o00=000Go@?m0o`03@008
oa?o4`<Coa<3o`0;4`<Coa;o4_4Boa800ol00a;a4P02o`0DX>2Poj3PX?nPh:3oT?n@D93oT502o`04
T52@o`/0000:0003o`00008000Go0000o`0300;o00?Oool00ol00moog`03g`03oenO00Ko00QOWonO
Gon2o0Go00OlP_coo8;o00901_l00d3o@002@003o`?o00Go00SN0mh3g_n`4PKo00R`4[0B/?oPX0Go
00NPh:3oX>3o009@1_l2D003oe3o01<000?o00000P001Ol0003o00800_l2g`Go00?Ooml00ml00onO
G`06o`08WeooGiooo885o`06P_b2oh;o0T06o`03@?m0009000?o0mh01_l020?N0mh3oa:`1_l01a:`
4[0Boj001Ol01j3PX?nPh?l00U06o`9@00CoD53o2`0000X000Go0000o`030003o`3o00800_l6g`;o
1=l02OmOWenOGimOW`02o`0;GimOog62LH9aPW400ol01762LOl8@0;o0d001olC0a<34`<01?l02a<3
oo4BlA;a4_4B00?o00XBlOnPh:3PX>2P1?l02n2Poi1@T52@D91@00;o00>@D?l04`001Ol0003o00<0
00Co0?l00_l7g`;o1=l02OnOGimOWenOG`02o`0;WenOoh9aPW62LH800ol00h9ao`08@0;o0d002?lC
0a<34`<C1?l02`<Coa;a4_4BlA;a00?o00Wa4_oPX>2Ph:001?l02n2Poi1@T52@D91@00;o00B@D93o
2`0000X000Co003o10000ol0o`0200;o3=l07OmOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;o00e0
02[o0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[3oh:3PX>2Ph:3PX>2Ph?l<D003o`00014000Co003o
10001?l0o`02o`gO01coWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;o3D00:_l3gP?N0mh3gP?N0mh3
oa:`4[0B/1:`4[0B/1;oX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000?o0?l01002o`040?oo00;o
3=l07OmOWenOGimOWenOGimOog62LH9aPW62LH9aPW7o00e003Oo4`<C0a<34`<C0a<3oo4BlA;a4_4B
lA;a4_7oX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53o01<000?o0?l01002o`030?oo00;o3Ml07?nO
GimOWenOGimOWenOoh9aPW62LH9aPW62LOl=@00hoa<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_oP
X>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l;00002P02o`/00_l<g`0MoenOGimOWenOGimOWeooP_b2
o8;lP_b2o8;lP_l03D00:_l3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?oPX>2Ph:3PX>2Ph:3Po`a@
00?o00004@02o`X00_l=g`0LoimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o`e002[o0mh3gP?N0mh3
gP?N0olB/1:`4[0B/1:`4[0Boj3PX>2Ph:3PX>2Ph?l=D003o`0000T0000:07co4`1lo`/0000G00;o
S002ogT0003o0240001m00?o=`04oe400olA0000OP000ol0000g0003o`00058000?o0000400000X0
0_l00`3oo`0300Go00<0ool02?l200?o0P05o`800ol200;o00<0ool0:`02o`030?oo00X000?o0000
20000ol0000H0006o`000?l01Ol00`3oo`03o`800ol200Go00<0ool00_l200Go00<0ool00ol200?o
0P05o`800ol200Go0P03o`800_l00`3oo`0700;o00<0ool02@000ol0o`090003o`0000l0000;0003
o`3o00<000Oo0000o`3o00<000Go0000o`040004o`00o`<000Go0000o`030003o`3o008000?o0000
:`000ol0o`0;0003o`0000P000?o000060001ol0003o0?l00P000ol000020003o`00008000Co003o
0`001Ol0003o00<000Go0000o`050005o`000?l00`000ol0o`020005o`000?l00P001Ol0003o00<0
00Oo0000o`3o008000?o00001`000ol0o`0;0003o`0000P000?o00003`0000/00ol30007o`000?l0
o`030005o`000?l010000ol000040005o`000?l00`000ol0o`020003o`0002`000?o00002005o`L0
00?o0?l06@001ol0o`3o0?l00P000ol000020003o`00008000?o000010001Ol0003o00<000Go0000
o`050005o`000?l01@04o`<000?o000010001Ol0003o00<000?o0?l00P000ol000080003o`0000P0
1Ol70003o`3o0100000;0003o`3o00<000Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000
o`030003o`3o008000?o0000:`000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l00P000ol0
00020003o`00008000?o000010001Ol0003o00<000Go0000o`050005o`000?l00`000ol000020005
o`000?l01P001Ol0003o00<000?o0?l00P000ol000070003o`3o00/000?o00001`000ol0o`0@0000
30000ol0000300Co0P04o`800_l300Co0`02o`@00ol00`3oo`03ob`00_l00`3oo`0:0003o`0000H0
0_l00`3oo`0H00;o00<0ool00_l00`3oo`040004o`0000Co0`02o`801Ol40003o`0000800_l400Co
0P03o`801?l300;o1003o`030?oo00?o2002o`030?oo01<00_l00`3oo`0?00002`02o`P000?o0000
0`000ol000060003o`0007800_l300;o20000ol000020003o`00010000?o000050000ol000160000
5002o`@00_l30003o`00008000?o000010000ol0001h00?o10000ol000040003o`0000L00ol50003
o`0000h000?o000010000ol0000o0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143.75, 0}} -> {-0.0537398, -0.0251377, 
  0.00734314, 0.00734314}, {{7.3125, 137}, {140.312, 
  3.375}} -> {-1.7579, -0.489659, 0.0728683, 0.0728683}, {{149.938, 
  279.625}, {140.312, 3.375}} -> {-12.1507, -0.489659, 0.0728683, 
  0.0728683}},
  CellTags->"Visual"]
}, Open  ]],

Cell[TextData[{
  "We can override this default by using the ",
  StyleBox["KeyForm", "MR"],
  " option in ",
  StyleBox["CayleyTable", "MR"],
  "."
}], "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[GF[8], \ Mode\  \[Rule] \ Visual, \ 
      KeyForm\  \[Rule] \ StandardForm]; \)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Visual"],

Cell[BoxData[
    \("KEY for Add(GF[8]): label used \[Rule] element: {g1 \[Rule] \!\(0\), \
g2 \[Rule] \!\(x\^2\), g3 \[Rule] \!\(x\), g4 \[Rule] \!\(x + x\^2\), g5 \
\[Rule] \!\(1\), g6 \[Rule] \!\(1 + x\^2\), g7 \[Rule] \!\(1 + x\), g8 \
\[Rule] \!\(1 + x + x\^2\)}"\)], "Print",
  CellTags->"Visual"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50265 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119678 0.47619 [
[ 0 0 0 0 ]
[ 1 .50265 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .50265 L
0 .50265 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119678 0.477324 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 .5 0 r
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.56 .37 .6 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
0 0 1 r
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.74 .99 .79 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.251 .878 .816 r
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .79 .34 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
0 .392 0 r
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g2)] .28836 .81878 0 0 Mshowa
[(g3)] .39418 .81878 0 0 Mshowa
[(g4)] .5 .81878 0 0 Mshowa
[(g5)] .60582 .81878 0 0 Mshowa
[(g6)] .71164 .81878 0 0 Mshowa
[(g7)] .81746 .81878 0 0 Mshowa
[(g8)] .92328 .81878 0 0 Mshowa
[(g2)] .18254 .71296 0 0 Mshowa
[(g1)] .28836 .71296 0 0 Mshowa
[(g4)] .39418 .71296 0 0 Mshowa
[(g3)] .5 .71296 0 0 Mshowa
[(g6)] .60582 .71296 0 0 Mshowa
[(g5)] .71164 .71296 0 0 Mshowa
[(g8)] .81746 .71296 0 0 Mshowa
[(g7)] .92328 .71296 0 0 Mshowa
[(g3)] .18254 .60714 0 0 Mshowa
[(g4)] .28836 .60714 0 0 Mshowa
[(g1)] .39418 .60714 0 0 Mshowa
[(g2)] .5 .60714 0 0 Mshowa
[(g7)] .60582 .60714 0 0 Mshowa
[(g8)] .71164 .60714 0 0 Mshowa
[(g5)] .81746 .60714 0 0 Mshowa
[(g6)] .92328 .60714 0 0 Mshowa
[(g4)] .18254 .50132 0 0 Mshowa
[(g3)] .28836 .50132 0 0 Mshowa
[(g2)] .39418 .50132 0 0 Mshowa
[(g1)] .5 .50132 0 0 Mshowa
[(g8)] .60582 .50132 0 0 Mshowa
[(g7)] .71164 .50132 0 0 Mshowa
[(g6)] .81746 .50132 0 0 Mshowa
[(g5)] .92328 .50132 0 0 Mshowa
[(g5)] .18254 .3955 0 0 Mshowa
[(g6)] .28836 .3955 0 0 Mshowa
[(g7)] .39418 .3955 0 0 Mshowa
[(g8)] .5 .3955 0 0 Mshowa
[(g1)] .60582 .3955 0 0 Mshowa
[(g2)] .71164 .3955 0 0 Mshowa
[(g3)] .81746 .3955 0 0 Mshowa
[(g4)] .92328 .3955 0 0 Mshowa
[(g6)] .18254 .28968 0 0 Mshowa
[(g5)] .28836 .28968 0 0 Mshowa
[(g8)] .39418 .28968 0 0 Mshowa
[(g7)] .5 .28968 0 0 Mshowa
[(g2)] .60582 .28968 0 0 Mshowa
[(g1)] .71164 .28968 0 0 Mshowa
[(g4)] .81746 .28968 0 0 Mshowa
[(g3)] .92328 .28968 0 0 Mshowa
[(g7)] .18254 .18386 0 0 Mshowa
[(g8)] .28836 .18386 0 0 Mshowa
[(g5)] .39418 .18386 0 0 Mshowa
[(g6)] .5 .18386 0 0 Mshowa
[(g3)] .60582 .18386 0 0 Mshowa
[(g4)] .71164 .18386 0 0 Mshowa
[(g1)] .81746 .18386 0 0 Mshowa
[(g2)] .92328 .18386 0 0 Mshowa
[(g8)] .18254 .07804 0 0 Mshowa
[(g7)] .28836 .07804 0 0 Mshowa
[(g6)] .39418 .07804 0 0 Mshowa
[(g5)] .5 .07804 0 0 Mshowa
[(g4)] .60582 .07804 0 0 Mshowa
[(g3)] .71164 .07804 0 0 Mshowa
[(g2)] .81746 .07804 0 0 Mshowa
[(g1)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Addition)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119678 0.97619 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 .5 0 r
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.56 .37 .6 r
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 0 1 r
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.74 .99 .79 r
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.251 .878 .816 r
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
0 .79 .34 r
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .392 0 r
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g1)] .28836 .81878 0 0 Mshowa
[(g1)] .39418 .81878 0 0 Mshowa
[(g1)] .5 .81878 0 0 Mshowa
[(g1)] .60582 .81878 0 0 Mshowa
[(g1)] .71164 .81878 0 0 Mshowa
[(g1)] .81746 .81878 0 0 Mshowa
[(g1)] .92328 .81878 0 0 Mshowa
[(g1)] .18254 .71296 0 0 Mshowa
[(g8)] .28836 .71296 0 0 Mshowa
[(g6)] .39418 .71296 0 0 Mshowa
[(g3)] .5 .71296 0 0 Mshowa
[(g2)] .60582 .71296 0 0 Mshowa
[(g7)] .71164 .71296 0 0 Mshowa
[(g5)] .81746 .71296 0 0 Mshowa
[(g4)] .92328 .71296 0 0 Mshowa
[(g1)] .18254 .60714 0 0 Mshowa
[(g6)] .28836 .60714 0 0 Mshowa
[(g2)] .39418 .60714 0 0 Mshowa
[(g5)] .5 .60714 0 0 Mshowa
[(g3)] .60582 .60714 0 0 Mshowa
[(g8)] .71164 .60714 0 0 Mshowa
[(g4)] .81746 .60714 0 0 Mshowa
[(g7)] .92328 .60714 0 0 Mshowa
[(g1)] .18254 .50132 0 0 Mshowa
[(g3)] .28836 .50132 0 0 Mshowa
[(g5)] .39418 .50132 0 0 Mshowa
[(g7)] .5 .50132 0 0 Mshowa
[(g4)] .60582 .50132 0 0 Mshowa
[(g2)] .71164 .50132 0 0 Mshowa
[(g8)] .81746 .50132 0 0 Mshowa
[(g6)] .92328 .50132 0 0 Mshowa
[(g1)] .18254 .3955 0 0 Mshowa
[(g2)] .28836 .3955 0 0 Mshowa
[(g3)] .39418 .3955 0 0 Mshowa
[(g4)] .5 .3955 0 0 Mshowa
[(g5)] .60582 .3955 0 0 Mshowa
[(g6)] .71164 .3955 0 0 Mshowa
[(g7)] .81746 .3955 0 0 Mshowa
[(g8)] .92328 .3955 0 0 Mshowa
[(g1)] .18254 .28968 0 0 Mshowa
[(g7)] .28836 .28968 0 0 Mshowa
[(g8)] .39418 .28968 0 0 Mshowa
[(g2)] .5 .28968 0 0 Mshowa
[(g6)] .60582 .28968 0 0 Mshowa
[(g4)] .71164 .28968 0 0 Mshowa
[(g3)] .81746 .28968 0 0 Mshowa
[(g5)] .92328 .28968 0 0 Mshowa
[(g1)] .18254 .18386 0 0 Mshowa
[(g5)] .28836 .18386 0 0 Mshowa
[(g4)] .39418 .18386 0 0 Mshowa
[(g8)] .5 .18386 0 0 Mshowa
[(g7)] .60582 .18386 0 0 Mshowa
[(g3)] .71164 .18386 0 0 Mshowa
[(g6)] .81746 .18386 0 0 Mshowa
[(g2)] .92328 .18386 0 0 Mshowa
[(g1)] .18254 .07804 0 0 Mshowa
[(g4)] .28836 .07804 0 0 Mshowa
[(g7)] .39418 .07804 0 0 Mshowa
[(g6)] .5 .07804 0 0 Mshowa
[(g8)] .60582 .07804 0 0 Mshowa
[(g5)] .71164 .07804 0 0 Mshowa
[(g2)] .81746 .07804 0 0 Mshowa
[(g3)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Multiplication)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{288, 144.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0000X0O?lC07co2`0000X000?oD5002U02o`a@02_oX>2Ph:3PX>2Ph:3PX?lB/1:`4[0B
/1:`4[0Bo`?N0mh3gP?N0mh3gP?o00a001goo8;lP_b2o8;lP_b2o?nOGimOWenOGimOWenOo`0<g`03
o`00014000?oD5002E02o`gO00?o@4002d007?oPX>2Ph:3PX>2Ph:3o4[0B/1:`4[0B/1:`4_l=D00Z
o`?N0mh3gP?N0mh3gP?oGimOWenOGimOWenOoob2o8;lP_b2o8;lP_co2`0000X000goT52@D91@T52@
D91@00;o03N@D91@T52@D91@T53oh:3PX>2Ph:3PX>2Ph?lBlA;a4_4BlA;a4_4Boa<34`<C0a<34`<C
0a?o00a001goPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOo`0<g`03o`00014000coD91@T52@D91@
T502o`gO00?o@4002d00DonPh:3PX>2Ph:3PX>3o4_4BlA;a4_4BlA;a4_m@T52@D91@T52@D91@oa<3
4`<C0a<34`<C0a?oGimOWenOGimOWenOoh9aPW62LH9aPW62LH;o00/0000:0003oe1@00?o1e02o`04
D?ooo`Q@00?oX>000ol02n2Ph:3PX>2Poa:`00?o00^`4[0B/1:`4_l3gP03o`0:gP?N0mh3gP?o@0?o
24000oolPP03o`0;P_b2o8;lP_coWel00ol02EnOGimOWenOo`02g`?o1ml00ol0000A0003oe3o00;o
1e02o`;O0ol8g`03od1000?o24000ooPX003o`0:X>2Ph:3PX?lB/0?o00V`4[0B/1:`4_l00U03o`Q@
00?o0mh00ol02]h3gP?N0mh3oel3o`0;GimOWenOGiooo8800ol02H;lP_b2o8;lo`0;00002P003On@
D91@T?n@D91@T5000_l0=i1@T53oD91@T52@D?oPX>2Ph?oPX>2Ph:3Poa;a4_4Boa;a4_4BlA;o4`<C
0a?o4`<C0a<34ol014000om0@005@00Moh9aPW62oh9aPW62LH;oWenOGiooWenOGimOWol01Ml00ooO
g`04g`03o`00014000coD91@T?n@D91@T502o`GO00?ogml01Ml00om0@003@003od1000E005?oX>2P
h:3oX>2Ph:3Poa;a4_4Boa;a4_4BlA;oD91@T53oD91@T52@D?lC0a<34olC0a<34`<CoenOGiooWenO
GimOWon2LH9aP_n2LH9aPW62o`0;00002P000om@D004o`9@0_l2D0;o00=@ool00_l2D0;o0e000onP
h004o`0:X>3oh:3PX?lB/0Co00XB/?oo4[0Bo`?N1?l02@?oool3gP?o@004o`900ol2@003oob200Co
00[looooo8;loimO1?l00iooo`02o`03Gioo00;O1?l01=ooool2g`03o`00014000?oD?l00ol2D0;o
0U02o`;O1?l01=ooool3g`03od1000Co0T03o`9000?oh:001?l02N2Poj3PX?lB/004o`084[3ooa:`
4_l2D0Co0U02o`=@00?o0mh01?l02@?oool3gP?oG`04o`03Wooo00;o00EOWoolPP04o`08o?oooob2
o?l;00002P003On@oi1@T?n@oi1@oe000ol0=E2@D?m@oe2@oi1@on3oh:3Pon2Poj3PX>3o4_lBlA;o
4_lBlOoa4_lCoa<34olC0a<3o`<C00;o0d001Om0@43o00=001ooP_n2LH;oPW62LOmaP_nOoimOWonO
GomOWenOomoo00?O00Cogmoo0ml00ol0000A00;o00Z@D93oT?n@D?m@0_l00moog`02g`04omoOo`CO
00?o@?l00d001Om0@43o00=003OoX?nPh:3oX>3oh:3Poa;o4_4Boa;o4_7olA;oD?m@T53oD?m@T?n@
D?lCoa<34olC0a<3o`<C00;o01ZOGiooWeooGimOWon2oh9aP_n2LH9aog62o`/0000:0003oe3o00=@
00?oD?l00U000om@o`02o`=@00?oD?l00U00;Om@D?nPoj3PX?nPh:3oX>2Poa;o4[0Boa;o4[3o/1;o
0ol3gP?o0mh3g_oN0`02o`=000?o@?l00ol2@00Ooocoo8;loob2o8;oP_coWonOGiooWenOoimOWooO
o`03g`04omoOo`?O00?o00004@02o`=@00?oD?l00U001_m@oooOo`?O00Cogmoo1=l00om0o`03@003
od3o00?o0T007_oPon2Ph?oPX>3oh:3o4_lB/1;o4_lB/?n`4_m@o`=@00?oD?l00U004Om@D?l3o`?N
0ol3gP?Nomh300;o01ZOGiooWenOoimOWooloob2o?olP_b2oh;lo`/0000:0009oi3oT52@oi1@00;o
00>@D?l00_l01U2@D?m@T0;o01U@T53oh?oPX>3oh:3Pon2Ph?lBoa;a4_lB00?o00/BlA;o4olC0a?o
4`03o`034`<C00;o0d001Om0od3o00=000WoP_n2LH;oPW400_l0589aP_nOoimOWonOGimOoenOomoo
0ml01?oOgol3g`03o`0001400_l01Y1@T?n@D0;o00J@D?oogol3g`04omoOo`CO00?o@?l00d001Om0
od3o00=001GoX?nPh:3oX>2Poj3Poa;o4_4Boa800ol031;a4_m@oe2@D?m@T0;o00]@T53o4olC0a?o
4`03o`034`<C00;o01BOGiooWenOGomOWon2oh9aP_n2L@;o00B2LH;o2`0000X000?oD5001_l2D005
oe3ooe001_l2D006oe1@oj3P1Ol02N2Ph?oPX?lB/006o`084[0B/1;o0mh6o`070mh3gP?o@006o`03
@?m0009000?oo8801Ol02H;lP_n2o?nOG`06o`06WeooGioo0]l5o`03gooO00;O00?o00004@000om@
o`05o`9@00CoD?oo0]l5o`03gooO00?O00?o@4001_l00d3o@002@003on2P00Go00RPh:3oX?lB/0Ko
00HB/1:`4_l2D0Ko0U001_m@D?l3gPKo00L3gP?N0omO00Ko00ROGomOWoolPPGo00N2o8;oP_co00/0
000:0009oi1@T52@D91@00;o00^@D?ooT52@D91@T002o`0;D91@on2Ph:3PX>001?l02j3Poa;a4_4B
lA;a00?o00[a4_lC0a<34`<C1?l00`<Co`07@0;o0d002?n2LH9aPW620ol0389aP_nOGimOWenOG`;o
00BOGioo1ml2o`?O00?o00004@002?m@T52@D91@0_l0191@ool7g`;o1=l00om0@006@0;o0d002?nP
h:3PX>2P1?l02^3o4_4BlA;a4_43o`0;lA;oD91@T52@D9000_l02e2@D?lC0a<34`<C00Co00X34omO
WenOGimO0_l02imOWon2LH9aPW6200?o00B2LH;o2`0000X000?oD5002U02o`a@02_oX>2Ph:3PX>2P
h:3PX?lB/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?o00a001goo8;lP_b2o8;lP_b2o?nOGimOWenO
GimOWenOo`0<g`03o`00014000?oD5002E02o`gO00?o@4002d007?oPX>2Ph:3PX>2Ph:3o4[0B/1:`
4[0B/1:`4_l=D00Zo`?N0mh3gP?N0mh3gP?oGimOWenOGimOWenOoob2o8;lP_b2o8;lP_co2`0000X0
00goT52@D91@T52@D91@00;o03N@D91@T52@D91@T53oh:3PX>2Ph:3PX>2Ph?lBlA;a4_4BlA;a4_4B
oa<34`<C0a<34`<C0a?o00a001goPW62LH9aPW62LH9aP_nOGimOWenOGimOWenOo`0<g`03o`000140
00coD91@T52@D91@T502o`gO00?o@4002d00DonPh:3PX>2Ph:3PX>3o4_4BlA;a4_4BlA;a4_m@T52@
D91@T52@D91@oa<34`<C0a<34`<C0a?oGimOWenOGimOWenOoh9aPW62LH9aPW62LH;o00/0000:0003
oe1@00Y@0_l<D00[oj3PX>2Ph:3PX>2Ph:3o4[0B/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3o`0<@00M
oob2o8;lP_b2o8;lP_coWenOGimOWenOGimOWol03=l00ol0000A0003oe1@00U@0_l=g`03od1000]0
01coh:3PX>2Ph:3PX>2Poa:`4[0B/1:`4[0B/1;o3E00:_l3gP?N0mh3gP?N0mh3oenOGimOWenOGimO
WoolP_b2o8;lP_b2o8;lo`/0000:07co4`1lo`/0000:000=on2Ph:3PX>2Ph:3PX002o`0=h:3PX>2P
h:3PX>2Po`0=D00Zo`?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4_n2o8;lP_b2o8;lP_co3D000ooO
g`0;g`0>oimOWenOGimOWenOGolC000<oj3PX>2Ph:3PX>2P0_l=g`0?omh3gP?N0mh3gP?N0mko00a0
00?oD5002e00>?nPh:3PX>2Ph:3PX>2Poh;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`oimOWenOGimO
WenOGioo2`0000X000goX>2Ph:3PX>2Ph:3P00;o04BPh:3PX>2Ph:3PX>3oD91@T52@D91@T52@D?lC
0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;oLH9aPW62LH9aPW62o`e000?ogml02ml03_nOGimOWenO
GimOWeoo4`003?oPX>2Ph:3PX>2Ph0;o3Ml03ol34`<C0a<34`<C0a<3o`0<@016oe2@D91@T52@D91@
T53oh:3PX>2Ph:3PX>2Ph?maPW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlOnOGimOWenOGimOWenOo`/0
000:0003on2P00?o00NPh:3PX>2P00;o00gPooooh:3PX>2Ph:3o009@0ol8D003o`?N00?o00_N0mh3
gP?N0olB/003o`0:/1:`4[0B/1;oPP?o00V2o8;lP_b2o?l00T03o`Q000?ogml00ol8g`03oimO00?o
00QOWenOGimOoa<000?oX?l00_l01j3PX>2Ph:000_l2g`?o2=l00ooN0`03o`090mh3gP?N0mko0090
0ol7@003oe1@00?o25000onPh003o`0;h:3PX>2Ph:3oP_`00ol02_b2o8;lP_b2oa83o`0;4[0B/1:`
4[3oWel00ol02EnOGimOWenOo`0;00002P003OnPh:3PX?nPh:3PX>000_l0A:3PX>3oh:3PX>2Ph?m@
T52@D?m@T52@D91@oa<34`<Coa<34`<C0a?o4_4BlA;o4_4BlA;a4_maPW62oh9aPW62LH;o1D000om0
@005@003omoO00?O00?ogml01Ml03_nOGimOWonOGimOWeoo4`003?oPX>2Poj3PX>2Ph0;o1Ml00ooO
g`05g`0?o`<C0a<3o`<C0a<34`?o00E000?o@4001400A_m@T52@D?m@T52@D91@on2Ph:3Pon2Ph:3P
X>3oLH9aPW7oLH9aPW62LOlBlA;aoo4BlA;a4_7oWenOGiooWenOGimOWol;00002P000ooPX004o`06
h:3oX>2P0_l00n3oo`02o`08X>3oh:3PX?l2D0Co0U02o`=@00?o0mh01?l02P?oool3gP?o4[04o`09
4[3ooa:`4_n200Co00Slooooo8;lo`901?l2@0?o0T000ooOg`04o`04goooo`?O00?oWel01?l00ioo
o`02o`03Gol0018000?oX?l00ol01^2Poj3PX0;o0]l4o`04goooo`?O00?ogP<01?l02=kooooN0mko
0T04o`900ol0143oD504o`9@0_l3D003oj3P00Co00ZPh?oPX>2Poh;l1?l02H;ooon2o8;o4P04o`0:
/1;ook0B/?nOG`Co00>Oool00_l00enOo`0;00002P003OnPoj3PX?nPh?oPX>000ol0=N2Ph?oPX?nP
h:3Poe3oD91@oe3oD93oT53o4olC0a?o4`<C0ol34olBoa;a4_lBoa;aoo4B00;o00j2LH;oPW62LOma
P_m0o`=000Go@410o`03@003omoo00?O00Cogmoo1=l03_nOoimOWonOGomOWeoo4`02o`0:X>2Poj3P
on2Ph0;o00?Ooml00]l01?oOgol4g`0Ao`?o0a<3o`<C0a?o4`?o@?l00d001Om0@43o009002[oD?m@
T53oD?m@T?n@D?oPon2Ph?oPX?nPh:3Pog7oLH9aog62LH;oPW42o`0JlA;aoo7olA;o4_7oWonOGioo
WeooGimOWol;00002P003OoPon2Ph?oPX>3oh:000ol03Z3PX?nPh:3oX>2Poe3o0e000om@o`02D00O
oe1@o`?o0mh3o`?N0mkogP?o4_lB/1;o4_lB/?n`4P02o`0>o8;loob2o8;oP_co@?l3@003od3o00?o
0T000ooOo`03g`04omoOo`CO00koWonOGiooWenOoimOoa<00_l02^2Ph?oPX>3oh:02o`03gooO00;O
00Cogmoo1=l04OoNomh3g_oN0mh3o`?Nod3o00=000?o@?l00ol0143oD?l3D003oe3o009@01ooD53o
X?nPh:3oX>2Poj3PX?n2oh;lP_n2o8;loob200;o01Z`4[3o/?n`4_lB/?nOoimOWonOGiooWenOo`/0
000:000=oj3oX>2Poj3PX?nPh003o`0Dh:3Pon2Ph?oPX>3oD?m@T53oD902o`0;D91@oa?o4`<Coa<0
0ol02a<34olBoa;a4_lB00?o00<BlA800_l01X9aP_n2L@;o00J2LH;o@?l3@005od3o@?l00d000ooO
o`03g`04omoOo`CO00koWonOGiooWenOGomOoa<00_l02Z3PX?nPh:3oX>02o`03gooO00;O00Cogmoo
1=l02?l3o`<C0ol30ol01P<C0om0o`=000Go@?m0o`02@009oe3oD91@oe2@00;o01Y@T53oh?oPX>3o
h:3Pon2Ph?maog62LOmaPP;o00=aPW400_l01O4BlOoa00?o01;a4_7oWonOGiooWenOGomOWol;0000
2P000ooPX005o`05X>2Poj000_l00n3oo`03o`07h:3Pon2Po`02D0Ko0U001_m@D?l3gPKo00P3gP?N
0olB/0Ko00LB/1:`4_n200Go00N2o8;oP_co00901_l00d3o@002@003omoO00Go00?Ooml00ml00onO
G`06o`05WeooGol04`000onPo`04o`05X>2Poj000_l2g`Go00?Ooml00ml00ooN0`06o`06gP?N0mko
0T06o`05@?m0@?l00U06o`9@00KoD53oX>05o`09h:3Pon2Poh;l00Go00SlP_coo8;o4PKo00R`4[0B
/?nOG`Ko00JOGomOWol;00002P002?nPh:3PX>2P1?l02N3ooj3PX>2Ph004o`0;X>3oD91@T52@D900
0_l02e2@D?lC0a<34`<C00Co00/34olBlA;a4_4Bl@03o`09lA;oLH9aPW6200?o00B2LH;o2402o`=0
00?ogml01Ml2o`CO00WoWenOGimOWel00_l00imOo`0C0007on2Ph:3PX004o`03h?oo00OO0_l4g`08
o`<C0a<34`<4o`034`?o00Q00_l2@009oe2@D91@T52@00;o00]@T53oh:3PX>2Ph004o`0:X>3oLH9a
PW62L@?o00]aPW7o4_4BlA;a4P03o`0;4_7oWenOGimOWel00_l019mOWol;00002P003OoPX>2Ph:3P
X>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E00:_l3gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1;oP_b2
o8;lP_b2o8;lo`e000?ogml02ml03_nOGimOWenOGimOWeoo4`003?nPh:3PX>2Ph:3PX0;o3Ml03ooN
0mh3gP?N0mh3gP?No`0<@003oe1@00]@03SoX>2Ph:3PX>2Ph:3PX?n2o8;lP_b2o8;lP_b2oa:`4[0B
/1:`4[0B/?nOGimOWenOGimOWenOo`/0000:000=oj3PX>2Ph:3PX>2Ph002o`14X>2Ph:3PX>2Ph:3P
oe2@D91@T52@D91@T53o4`<C0a<34`<C0a<34olBlA;a4_4BlA;a4_4Bog62LH9aPW62LH9aP_l=@003
omoO00_O00koWenOGimOWenOGimOoa<000coh:3PX>2Ph:3PX>02o`gO00oo0a<34`<C0a<34`<C0ol0
3400A_m@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>3oLH9aPW62LH9aPW62LOlBlA;a4_4BlA;a4_7o
WenOGimOWenOGimOWol;00002P003OoPX>2Ph:3PX>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E00:_l3
gP?N0mh3gP?N0mh3oa:`4[0B/1:`4[0B/1;oP_b2o8;lP_b2o8;lo`e000?ogml02ml03_nOGimOWenO
GimOWeoo4`003?nPh:3PX>2Ph:3PX0;o3Ml03ooN0mh3gP?N0mh3gP?No`0<@003oe1@00]@03SoX>2P
h:3PX>2Ph:3PX?n2o8;lP_b2o8;lP_b2oa:`4[0B/1:`4[0B/?nOGimOWenOGimOWenOo`/0000:07co
4`1lo`/0000:000=ok0B/1:`4[0B/1:`4P02o`0K/1:`4[0B/1:`4[0Bo`?N0mh3gP?N0mh3gP?o00e@
01coX>2Ph:3PX>2Ph:3PX?mOWenOGimOWenOGioo3Ml00om0@00;@00>oob2o8;lP_b2o8;lP_lC000<
oa:`4[0B/1:`4[0B0_l=g`0?on2Ph:3PX>2Ph:3PX>3o00a@01goGimOWenOGimOWenOGolB/1:`4[0B
/1:`4[0Bo`0=@00Loh;lP_b2o8;lP_b2o?oN0mh3gP?N0mh3gP?No`/0000:000=oo4BlA;a4_4BlA;a
4P02o`14lA;a4_4BlA;a4_4Boa<34`<C0a<34`<C0a?oD91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3P
oenOGimOWenOGimOWol=g`03od1000]000koPW62LH9aPW62LH9aoa<000co4_4BlA;a4_4BlA82o`gO
03SoX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53oGimOWenOGimOWenOGolBlA;a4_4BlA;a4_4Bo`e0
01coLH9aPW62LH9aPW62o`<C0a<34`<C0a<34`?o2`0000X000?o/1800ol01a:`4[0B/1800_l03k3o
oon`4[0B/1:`4_l3gP03o`09gP?N0mh3gP?o009@0ol8D003oj3P00?o00[PX>2Ph:3PX?mO0ol02EnO
GimOWenOo`02g`?o2=l00om0@003o`Q000?oo8800ol028;lP_b2o8;o4`000olBo`02o`074[0B/1:`
4P02o`;O0ol8g`03on2P00?o00VPh:3PX>2Ph?l00U03o`M@00?oGil00ol02imOWenOGimOoa:`00?o
00V`4[0B/1:`4_l00T03o`Q000?oP_l00_l02h;lP_b2o8;lomh300?o00T3gP?N0mh3g_l02`0000X0
00golA;a4_7olA;a4_4B00;o04Ca4_4Boa;a4_4BlA;o4`<C0a?o4`<C0a<34om@T52@D?m@T52@D91@
on2Ph:3Pon2Ph:3PX>3oGimOWonOGimOWenOo`GO00?ogml01Ml00om0@003@003od1000E000koPW62
LH;oPW62LH9aoa<000co4_4BlOoa4_4BlA82o`GO00?ogml01Ml0>?nPh:3PX?nPh:3PX>2Poi1@T52@
oi1@T52@D?mOWenOGomOWenOGimOoa;a4_4Boa;a4_4BlA;o1D000om0@005@00Log62LH;oPW62LH9a
P_l34`<C0ol34`<C0a<3o`/0000:0003ok0B00Co00J`4_oo/182o`03/?oo00;o00XB/?oo4[0Bo`?N
1?l020?oool3gP?o0U04o`9@0_l3D003oj3P00Co00VPh?oPX>2Poel01?l00iooo`02o`03Gioo00;O
1?l01=ooool3g`03od1000Co0T03o`9000?oo8801?l01ocoooolP_l04`000olBo`03o`06/1;ook0B
0_l2g`Co00COoooo0ml00ooPX004o`08h:3oX>2Ph?l2D0Co0U02o`9@00?oGil01?l00eooo`02o`05
Weoo4[001?l021:`oolB/1;o0T04o`900ol2@003oh;o00?o00[looooo8;lomh31?l02=kooooN0mko
2`0000X000golOoa4_7olOoa4_lB00?o03DBlA;o4_lBlOoa4_lCoa<34olC0a<3o`<Coe3oD91@oe3o
D93oT53oh?oPX>3oh:3oX>2Ph002o`0>WenOoimOoenOGioogol3g`04omoOo`CO00?o@?l00d001Om0
@43o00=000koP_n2LH;oPW62LOmaoa<00_l02_4BlOoaoo4Boa82o`03gooO00;O00Cogmoo1=l0>_nP
oj3PX?nPh?oPX>2Poi3oT52@oi3oT53oD?mOoenOGomOWonOGimOoa;o4_4Boa;o4_7olA;o@?l3@005
od10@?l00d02o`0JPW62oh9aPW7oLH;o0ol34`?o0a<34olC0ol;00002P003On`ok0B/?n`ok0Boa80
0ol071:`4_lBoa:`ok0Bo`?o0mh3o`?N0mkogP?oD?l3D003oe3o009@017oD53oX?nPh:3oX>2Poj3P
X002o`0>WenOoimOWonOGioogol3g`04omoOo`CO00?o@?l00d000om0o`03o`9000koo?olP_coo8;l
P_n2oa<00_l02[0B/?n`ok0Boa82o`03gooO00;O00Cogmoo1=l04OoPon2Ph?oPX>3oh:3Poe3o00=@
00?oD?l00U008Om@oeooGimOoenOGomOWeoo4_lB/1;o4_lB/?n`4_m0o`03@003od3o00?o0T02o`0J
o8;loob2o8;oP_cog_oN0mkogP?N0ol3g_l;00002P002?oaoo4BlOoa0ol00o4Bo`02o`054_4Boa80
0ol02a;a4_lCoa<34olC00?o00`C0a?oD?m@T53oD902o`0AD91@on3oh:3Pon2Ph?oPX>000_l03YmO
WonOGimOoenOomoo0ml01?oOgol4g`03od3o00=000Go@?m0o`03@009oh;oPW62oh9a00;o00>2LOl0
4`02o`05lA;aoo400ol01_4BoooOo`?O00Cogmoo1=l05onPoj3PX?nPh:3oX>2Poi3oT52@oi1@00;o
01R@D?mOoenOGomOWenOoimOoa;o4_4Boa83o`064_4Bod3o0d001Om0od3o00=00_l01X9aP_n2L@;o
00^2LH;o0ol34`?o0`03o`040a<3o`/0000:0003ok0B00Ko00B`4[0B0_l00k3oo`04o`084[0B/1;o
0mh6o`060mh3gP?o0U06o`9@00KoD53oX>05o`08h:3Pon2Poel6o`06WeooGioo0]l5o`03gooO00?O
00?o@4001_l00d3o@002@003oob200Go00J2o8;oP_lC0003oa;o00Go00B`4[0B0_l2g`Go00?Ooml0
0ml00ooPX005o`07X>2Poj3Po`02D0Ko0U001Om@oenO00Ko00QOWonOGolB/0Ko00HB/1:`4_l2@0Ko
00=0od000T000on2o`04o`09P_b2oh;lomh300Ko00KN0mh3g_l;00002P002Ooa4_4BlA;a4P03o`0:
4_oolA;a4_4Bl@?o00[a4_lC0a<34`<C1?l02`<Coe2@D91@T52@00;o00]@T53oh:3PX>2Ph004o`0:
X>3oGimOWenOG`;o00BOGioo1ml2o`CO00?o@4001T02o`=000SoPW62LH9aPP?o00>2LOl04`002?lB
lA;a4_4B0ol00a;oo`07g`;o1=l02?nPh:3PX>2P1?l02n2Poi1@T52@D91@00;o00^@D?mOWenOGimO
W`02o`0<GimOoa;a4_4BlA;a0ol00o4Bo`08@0;o0d001omaPW62LH800ol02h9aP_l34`<C0a<300Co
00<C0ol02`0000X000go/1:`4[0B/1:`4[0B00;o01^`4[0B/1:`4[0B/1;o0mh3gP?N0mh3gP?N0ol0
3E007?nPh:3PX>2Ph:3PX>2PoenOGimOWenOGimOWol=g`03od1000]000koo8;lP_b2o8;lP_b2oa<0
00co4[0B/1:`4[0B/182o`gO00ooh:3PX>2Ph:3PX>2Ph?l035007OmOWenOGimOWenOGimOoa:`4[0B
/1:`4[0B/1;o00e001coP_b2o8;lP_b2o8;lomh3gP?N0mh3gP?N0mko2`0000X000golA;a4_4BlA;a
4_4B00;o04Ca4_4BlA;a4_4BlA;o4`<C0a<34`<C0a<34om@T52@D91@T52@D91@on2Ph:3PX>2Ph:3P
X>3oGimOWenOGimOWenOo`gO00?o@4002d003_n2LH9aPW62LH9aPW7o4`003?lBlA;a4_4BlA;a4P;o
3Ml0>?nPh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?mOWenOGimOWenOGimOoa;a4_4BlA;a4_4BlA;o
3D007?maPW62LH9aPW62LH;o0a<34`<C0a<34`<C0ol;00002P003On`4[0B/1:`4[0B/1800_l06k0B
/1:`4[0B/1:`4_l3gP?N0mh3gP?N0mh3o`0=D00Loj3PX>2Ph:3PX>2Ph:3oGimOWenOGimOWenOo`gO
00?o@4002d003_olP_b2o8;lP_b2o8;o4`003?lB/1:`4[0B/1:`4P;o3Ml03ooPX>2Ph:3PX>2Ph:3P
o`0<D00MoenOGimOWenOGimOWeoo4[0B/1:`4[0B/1:`4_l03D007?n2o8;lP_b2o8;lP_cogP?N0mh3
gP?N0mh3g_l;00002P1loa<0O?l;00002P003OoN0mh3gP?N0mh3gP<00_l0:Mh3gP?N0mh3gP?N0olB
/1:`4[0B/1:`4[0Boj3PX>2Ph:3PX>2Ph:3o00e@00?ogml02]l07OnOGimOWenOGimOWenOoob2o8;l
P_b2o8;lP_co00a000?o00004@003?l3gP?N0mh3gP?N0`;o3Ml07?nOGimOWenOGimOWenOoob2o8;l
P_b2o8;lP_l=@00Zo`?N0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4_nPh:3PX>2Ph:3PX>3o3E000ol0
000900002P000ol34`03o`074`<C0a<34`02o`0?0oooo`<C0a<34`<Coa;a00?o00_a4_4BlA;a4_oP
X003o`0;X>2Ph:3PX>3oD9000ol02Y1@T52@D91@oml3o`SO00?oWel00ol02enOGimOWenOoh9a00?o
00UaPW62LH9aP_l00T03o`M000?o00004@000olCo`02o`074`<C0a<34`02o`;O0ol8g`03oimO00?o
00]OWenOGimOWon2L@03o`08LH9aPW62LOl2@0?o24000olC0`03o`0;0a<34`<C0a?o4_400ol02_4B
lA;a4_4Bon03o`0;h:3PX>2Ph:3oT5000ol02E2@D91@T52@o`0;00002P003OoN0mh3g_oN0mh3gP<0
0_l0:Mh3gP?o0mh3gP?N0olB/1:`4_lB/1:`4[0Boj3PX>2Poj3PX>2Ph:3o00E@00?oD5001E000ooO
g`02g`03omoO00GO01goWenOGiooWenOGimOWoolP_b2o?olP_b2o8;lo`05@003od1000A000?o0000
4@003?l3gP?Nomh3gP?N0`;o1Ml00ooOg`05g`0LoimOWenOoimOWenOGiooo8;lP_coo8;lP_b2o`E0
00?o@4001D00:_l3gP?N0ol3gP?N0mh3oa:`4[0Boa:`4[0B/1;oX>2Ph?oPX>2Ph:3Po`E@00?oD500
1E000ol0000900002P000ol34`04o`060oooo`<C0_l00`?oo`02o`0:4ooooa<34olBl@Co00XBlOoo
4_4Bon2P1?l02^2Poj3PX>3oD904o`09D93ooe2@D?oO00Co00COoooo0ml00onOG`04o`03Wooo00;o
00EOWon2L@04o`08P_oooh9aP_l2@0Co0T03o`03@?l0018000?o4ol00ol01P?oool34`;o0]l4o`04
goooo`?O00?oWel01?l00iooo`02o`05GiooPW401?l01h;ooon2LOl00T04o`900ol2@003oa<300Co
00XCoooo4`<Coa;a1?l02A;aoolBlA;oh004o`0:X>3oh:3PX?n@D0Co00R@D?ooT52@o`/0000:000=
omkogP?Nomh3gP?o0`03o`0Z0mh3o`?N0mkogP?o4_lB/1;o4_lB/?n`4_nPoj3PX?nPh?oPX>2Poe3o
0e000om@o`02D003oe1@00;o0ml01?oOgol4g`0OoiooWenOoimOoenOGiooo?olP_coo8;lP_n2o?m0
o`03@005od10@?l00T000ol0000A00;o00[N0mkogP?N0ol30_l00moog`02g`04omoOo`CO01koWonO
GiooWeooGimOWooloob2o?olP_b2oh;o@?l3@005od10@?l00d007?l3o`?N0ol3gP?Nomh3oa;o4[0B
oa;o4[3o/182o`0>h:3Pon2Poj3PX>3oD?l3D003oe3o009@00CoD53o2`0000X000go0ol34`?o0a<3
4olC00?o03DC0a?o4`<C0ol34olBoa;a4_lBoa;aoo4Bon3oh:3Pon2Ph?oPX>3oD?m@T53oD?m@T?n@
D002o`?O00Cogmoo1=l07onOoimOWonOGiooWenOoh;oPW62oh9aPW7oLH;o@?l00d000om0o`03o`03
@?l001800_l02P<C0ol34`<Coa<2o`03gooO00;O00Cogmoo1=l07_nOoimOWonOGiooWenOoh;oPW62
oh9aPW7oLOm0o`=000?o@?l00ol2@00Loa?o4`<Coa<34`?o0a?o4_lBlA;o4_lBlOoa4P;o01ZPh:3o
X>2Poj3PX?n@oi1@T?n@oi1@oe2@o`/0000:0008omkogP?Nomh3o`03gP?o00;o00D3gP?o0`03o`0;
0mh3oa;o4[0Boa800ol051:`4_nPoj3PX?nPh:3oX>2Poe3o0e000om@D002o`=@0_l3g`04omoOo`CO
01OoWonOGiooWenOGomOWooloob2o?olPP02o`06o8;lod3o0d001Om0od3o009000?o00004@02o`05
gP?Nomh00ol01]h3oooOo`?O00Cogmoo1=l05onOoimOWonOGimOoenOoocoo8;loob200;o00GlP_m0
o`03@005od3o@?l00d002?l3o`?N0ol30ol02`?N0olBoa:`4_lB00?o00<B/1800_l03^2Ph?oPX>3o
h:3Poe3o0e000om@D002o`=@00?o00002@0000X000?o0a<01_l010<C0a<2o`030ooo00Co00PC0a<3
4olBl@Ko00PBlA;a4_oPX0Go00VPh:3oX>3oD9001_l01e2@oi1@oml01Ol00moog`03g`03oimO00Ko
00ROGomOWon2L@Go00MaPW7oLH;o00901_l01D3o@43o01<000?o4ol01Ol010<C0a<2o`;O1Ol00moo
g`03g`03oimO00Ko00ROGomOWon2L@Go00IaPW7oLOl2@0Ko00=0od000T000olC0`06o`084`<C0a?o
4_46o`074_4BlA;oh005o`09h:3Pon2Poi1@00Ko00J@D?m@T?l;00002P002?oN0mh3gP?N1?l02@?o
omh3gP?N0`04o`0;gP?o4[0B/1:`4[000ol02[0Boj3PX>2Ph:04o`03h:3o00Q@0_l3D003omoO00CO
0_l4g`09oimOWenOGimO00;o00^OGiooo8;lP_b2o003o`04o8;lo`Q00_l2@003o`00014000Oo0mh3
gP?N00Co00<3ool01ml2o`CO00WoWenOGimOWel00_l02imOWoolP_b2o8;l00?o00?lP_l02402o`=0
00So0mh3gP?N0`Co00_N0olB/1:`4[0B/003o`09/1;oX>2Ph:3P00Co00>Ph?l02502o`=@00?o0000
2@0000X000go0a<34`<C0a<34`<C00;o03L34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_oPX>2Ph:3P
X>2Ph:3Poe2@D91@T52@D91@T53o00cO01goWenOGimOWenOGimOWon2LH9aPW62LH9aPW62o`0<@003
o`00014000co4`<C0a<34`<C0a<2o`gO01coWenOGimOWenOGimOWon2LH9aPW62LH9aPW7o3D00>?lC
0a<34`<C0a<34`<Coa;a4_4BlA;a4_4BlA;oh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o2`0000X0
00gogP?N0mh3gP?N0mh300;o02WN0mh3gP?N0mh3gP?o4[0B/1:`4[0B/1:`4_nPh:3PX>2Ph:3PX>2P
o`0=D003omoO00[O01goWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;lo`0<@003o`00014000co0mh3
gP?N0mh3gP<2o`gO01coWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;o3D00:_l3gP?N0mh3gP?N0mh3
oa:`4[0B/1:`4[0B/1;oX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000go0a<34`<C0a<34`<C00;o
03L34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_oPX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T53o00cO
01goWenOGimOWenOGimOWon2LH9aPW62LH9aPW62o`0<@003o`00014000co4`<C0a<34`<C0a<2o`gO
01coWenOGimOWenOGimOWon2LH9aPW62LH9aPW7o3D00>?lC0a<34`<C0a<34`<Coa;a4_4BlA;a4_4B
lA;oh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o2`0000X0O?lC07co2`0000X000?o@4002T02o`a0
01goLH9aPW62LH9aPW62LOmOWenOGimOWenOGimOo`0=g`0goe2@D91@T52@D91@T?nPh:3PX>2Ph:3P
X>2Poo4BlA;a4_4BlA;a4_7o0a<34`<C0a<34`<Co`0C0003od1000U00_l=g`0Zoh9aPW62LH9aPW62
LH;o0a<34`<C0a<34`<Con2Ph:3PX>2Ph:3PX>3o3D00:_mOWenOGimOWenOGimOoe2@D91@T52@D91@
T?oa4_4BlA;a4_4BlA;ao`/0000:0003od1000Y00_l<@00Moh;lP_b2o8;lP_b2o8;oGimOWenOGimO
WenOGol03Ml00om@D00:D00Zon2Ph:3PX>2Ph:3PX>3o/1:`4[0B/1:`4[0B/?oN0mh3gP?N0mh3gP?o
4`000om0@009@0;o3Ml0:_olP_b2o8;lP_b2o8;lomh3gP?N0mh3gP?N0onPh:3PX>2Ph:3PX>2Po`e0
00ooGimOWenOGimOWenOGol035003on`4[0B/1:`4[0B/1:`o`0;00002P000om0@003o`M00_l0143o
ool8@003og6200?o00^2LH9aPW62LOmOW`03o`09WenOGimOWeoo00;O0ol8g`03oe3o00;o00]@T52@
D91@T?nPh003o`0;h:3PX>2Ph:3olA800ol02a;a4_4BlA;ao`<C00?o00PC0a<34`<Coa<000?o@?l0
0_l7@0;o0]l3o`SO00?oPW400ol02g62LH9aPW62o`<C00?o00XC0a<34`<Con2P0ol02J3PX>2Ph:3P
o`02@0?o24000omOW`03o`0:WenOGimOWeooD0?o00]@T52@D91@T?oa4P03o`094_4BlA;a4_7o00/0
000:0003od1000=000?o@4001402o`A000?o@4001D007On2o8;lP_n2o8;lP_b2oenOGimOoenOGimO
Weoo00GO00?ogml01Ml00om@D002D003oe1@00E@02[oh:3PX>3oh:3PX>2Ph?n`4[0B/?n`4[0B/1:`
omh3gP?Nomh3gP?N0olC0003od10009000?o@4001402o`GO00?ogml01Ml0:_olP_b2o?olP_b2o8;l
omh3gP?Nomh3gP?N0onPh:3PX?nPh:3PX>2Po`E000?o@4001D003omOWenOGomOWenOGimOo`04D003
oe1@00E@00oo/1:`4[3o/1:`4[0B/?l02`0000X000?o@4001?l2@0?o00A0oom01?l2@0?o0T000oma
PP04o`0:LOooog62LOmOW`Co00=Oool00_l00imOo`02g`Co00COoooo0ml00om@o`03o`0:T53ooi1@
T?nPh0Co00ZPh?oPX>2Poo4B1?l02_4Boooa4_7o0a<4o`070oooo`<Co`0C0003od3o00?o0T03o`03
@?oo00;O1?l01=ooool3g`03oh9a00Co00Z2ooooPW62o`<C1?l02@?oool34ooPX004o`08h:3oX>2P
h?l2@0Co0T03o`9000?oGil01?l00eooo`02o`04WeooD0Co00Z@D?ooT52@oo4B1?l02?4Boooa4_7o
2`0000X000?o@?l00d001Om0@43o00900ol3@005od10@?l00d007on2oh;lP_n2o8;loob2oeooGimO
oenOoimOWeoogol00ml01?oOgol4g`;o0e000om@o`02D00]oe1@on3oh:3Pon2Poj3PX>3o/?n`4[3o
/?n`4_lB/?oNomh3g_oN0mh3o`?o01<00_l3@005od10@?l00T02o`03gooO00;O00Cogmoo1=l0;?ol
oob2o?olP_b2oh;lomkogP?Nomh3gP?o0onPoj3PX?nPh?oPX>2Pod3o0d001Om0@43o00=000koGomO
WeooGiooWenOG`;o0e000om@o`02D00Boe1@ok3o/1:`ok3o/1;o4[3o2`0000X000?o@?l00d000om0
o`03o`04@?ooo`=000?o@?l00ol2@00Oog7oLH9aog62LH;oPW7oGomOWeooGimOoenOGooOo`03g`04
omoOo`CO0_l0=I1@T?n@oi1@oe2@oj3oX>2Poj3PX?nPh:3olOoa4_7olOoa4_lBlOl3o`<C0ol34`<C
oa?o01<00_l3@003od3o00?o00E0oooOo`03g`04omoOo`CO02coP_n2LH;oPW62LOmaP_l3o`<C0ol3
4`<Coa?oh?oPX>3oh:3Pon2Ph?m0o`=000?o@?l00ol2@00>oeooGimOoenOGomOWel2o`0JT52@oi3o
T53oD93olOoa4_7olOoa4_lBlOl;00002P000om0o`03@005od3o@?l00T03o`=000Go@?m0o`03@009
oh;oP_b2oh;l00;o01B2o8;oGomOWeooGimOWonOGooOo`?O00Cogmoo1=l2o`=@00?oD5000_l3D00F
on3oh:3Pon2Ph?oPX>3o/?n`4[3o/0?o00^`4[3og_oN0mkogP03o`03gP?o01<00_l3@005od3o@?l0
0T02o`03gooO00;O00Cogmoo1=l02Ooloob2o?olPP02o`0;o8;lomkogP?Nomh00ol04mh3oj3oX>2P
oj3PX?nPh:3o@?l00d001Om0od3o00=000koGomOWeooGimOWonOG`;o0e000om@D002o`=@00So/?n`
4[3o/0?o00B`4[3o2`0000X000?o@4001_l0143o@402o`03@?oo00Co00=0od000T000omaPP05o`09
PW62oh9aoenO00Ko00IOWonOGol2g`Go00?Ooml00ml00om@o`05o`08T53oD93oX>05o`09h:3Pon2P
oo4B00Ko00Sa4_4BlOl34`Ko00D34`<Co`0C0003od3o00Go00A0od100_l2g`Go00?Ooml00ml00on2
L@05o`09LH9aog62o`<C00Ko00L34`<Con2P00Go00NPh:3oX>3o00901_l00d3o@002@003oenO00Ko
00MOWonOGom@00Ko00R@D?m@T?oa4PKo00Ka4_4BlOl;00002P000om0@006@0;o0T02o`M00_l3@008
oh;lP_b2o883o`0<P_b2oenOGimOWenO0_l015nOGol7g`;o1=l00om@D005D0;o0e002?oPX>2Ph:3P
1?l02j3Pok0B/1:`4[0B00?o00XB/?oN0mh3gP?N1?l00`?o000B0003od1000E00_l2@0;o1ml2o`CO
00Soo8;lP_b2o0?o00_lP_cogP?N0mh3gP04o`090onPh:3PX>2P00Co00?PX?l02402o`=000WoGimO
WenOGil00_l015nOGol7D0;o0e002On`4[0B/1:`4P03o`034[3o00/0000:0003od1000Y00_l<@00M
og62LH9aPW62LH9aPW7oGimOWenOGimOWenOGol03Ml0=om@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3P
X?oa4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34ol04`000om0@009@0;o3Ml0:_n2LH9aPW62LH9aPW62
o`<C0a<34`<C0a<34ooPX>2Ph:3PX>2Ph:3Po`e002[oGimOWenOGimOWenOGom@T52@D91@T52@D93o
lA;a4_4BlA;a4_4BlOl;00002P000om0@00:@0;o34007On2o8;lP_b2o8;lP_b2oenOGimOWenOGimO
Weoo00gO00?oD5002U00:_oPX>2Ph:3PX>2Ph:3Pok0B/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3oa<0
00?o@4002D02o`gO02[oo8;lP_b2o8;lP_b2o?oN0mh3gP?N0mh3gP?oX>2Ph:3PX>2Ph:3PX?l=@00?
oenOGimOWenOGimOWeoo00a@00oo/1:`4[0B/1:`4[0B/?l02`0000X000?o@4002T02o`a001goLH9a
PW62LH9aPW62LOmOWenOGimOWenOGimOo`0=g`0goe2@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Poo4B
lA;a4_4BlA;a4_7o0a<34`<C0a<34`<Co`0C0003od1000U00_l=g`0Zoh9aPW62LH9aPW62LH;o0a<3
4`<C0a<34`<Con2Ph:3PX>2Ph:3PX>3o3D00:_mOWenOGimOWenOGimOoe2@D91@T52@D91@T?oa4_4B
lA;a4_4BlA;ao`/0000:07co4`1lo`/0000:000=oh9aPW62LH9aPW62L@02o`0=PW62LH9aPW62LH9a
o`0=@003omoO00_O04GoGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l34`<C
0a<34`<C0a<3oo4BlA;a4_4BlA;a4_l04`003?maPW62LH9aPW62L@;o3Ml0A_oa4_4BlA;a4_4BlA;a
oimOWenOGimOWenOGolC0a<34`<C0a<34`<Cog62LH9aPW62LH9aPW7oD91@T52@D91@T52@D?l<@00?
oj3PX>2Ph:3PX>2Ph:3o00/0000:000=oob2o8;lP_b2o8;lPP02o`0=o8;lP_b2o8;lP_b2o`0=@003
omoO00_O01coGimOWenOGimOWenOGonPh:3PX>2Ph:3PX>3o3E007?oN0mh3gP?N0mh3gP?Nok0B/1:`
4[0B/1:`4_lC000<oh;lP_b2o8;lP_b20_l=g`0hok0B/1:`4[0B/1:`4[3oWenOGimOWenOGimOo`?N
0mh3gP?N0mh3gP?oP_b2o8;lP_b2o8;lP_l=D003od1000Y000ooh:3PX>2Ph:3PX>2Ph?l02`0000X0
00?oPW400ol01g62LH9aPW400_l03H;ooon2LH9aPW62LOl00T03o`Q000?ogml00ol8g`03oenO00?o
00ZOGimOWenOGooP0ol02n2Ph:3PX>2Poi1@00?o00]@T52@D91@T?l34`03o`0;4`<C0a<34`?olA80
0ol021;a4_4BlA;o4`000omao`02o`07LH9aPW62L@02o`;O0ol8g`03oo4B00?o00/BlA;a4_4BlOnO
G`03o`0:GimOWenOGolC0`?o00/34`<C0a<34omaPP03o`0;PW62LH9aPW7oD9000ol02Y1@T52@D91@
od03o`Q000?oX>000ol02N2Ph:3PX>2Po`0;00002P003OolP_b2o?olP_b2o8800_l03Ob2o8;oP_b2
o8;lP_l01D000om0@005@003omoO00?O00?ogml01Ml07?mOWenOGomOWenOGimOoj3PX>3oh:3PX>2P
h?l5D003oe1@00E@01cogP?N0mkogP?N0mh3g_n`4[0B/?n`4[0B/1;o4`003?n2o8;loob2o8;lPP;o
1Ml00ooOg`05g`0hok0B/1:`ok0B/1:`4[3oWenOGiooWenOGimOo`?N0mh3o`?N0mh3gP?oP_b2o8;o
P_b2o8;lP_l5D003oe1@00E@00?o@4000T000om0@005@00?on2Ph:3Pon2Ph:3PX>3o00/0000:0003
oh9a00Co00J2ooooPW42o`03P_oo00;o00QaooooLH9ao`901?l2@0?o0T000ooOg`04o`04goooo`?O
00?oGil01?l00eooo`02o`04Weooh0Co00ZPh?oPX>2Poi1@1?l02Y1@oon@D93o0a<4o`0:0oooo`<C
0ooa4PCo00Oa4_oolA;o01<000?oLOl00ol01X;ooon2L@;o0]l4o`04goooo`?O00?olA801?l02_4B
oooa4_7oWel4o`03Wooo00;o00AOoa<31?l02Q?ooolC0a?oLH84o`0:LOooog62LOm@T0Co00U@T?oo
D91@od001?l2@0?o0T000onPh004o`08X>3oh:3PX?l;00002P003Ooloob2o?olP_b2oh800ol03X;l
P_n2o8;loob2od3o0d001Om0@43o00=000?ogol00ml01?oOgol4g`0>oeooGimOoenOoimOWel2o`0>
h:3Pon2Poj3PX>3oD?l3D003oe3o009@01ooD53og_oN0mkogP?N0ol3g_n`ok0B/?n`ok0Boa;o01<0
0_l02_b2o?olP_b2oh82o`03gooO00;O00Cogmoo1=l0>_n`ok0B/?n`ok0Boa:`oiooWenOoimOoenO
Gol3o`?N0ol3gP?Nomh3oh;oP_b2oh;lP_coo8;oD?l3D003oe3o009@00?oD5000_l3@005od10@?l0
0d003ooPon2Ph?oPX?nPh:3Po`0;00002P003On2oh9aP_n2LH9aog400ol03W62LOmaPW62oh9aod3o
0d000om0o`03o`9000?ogol00ml01?oOgol4g`0>oeooGimOoenOGomOWel2o`0eX>2Poj3PX?nPh:3o
T?n@D93oT?n@D?m@T?l3o`<C0ol34`<Coa<3oo7olA;aoo7olA;o4_l04`02o`0:PW62oh9aPW7oL@;o
00?Ooml00]l01?oOgol4g`15oo7olA;aoo7olA;o4_7oWonOGiooWenOoimOoa?o4`<Coa<34`?o0a?o
LOmaPW7oLH9aP_n2LOm@oe2@D?m@oe2@oi1@00;o0d000om0o`03o`9000ooX?nPh:3oX>2Poj3PX?l0
2`0000X000Woo?olP_coo8800_l00ob2o`02o`06P_b2oh;l0_l01X;lP_m0o`=000Go@?m0o`03@003
omoo00?O00Cogmoo1=l03_mOoenOGomOWenOoimO0_l03^2Ph?oPX>3oh:3Poe3o0e000om@D002o`=@
00Sog_oN0mkogP?o00_N0mko/?n`4[3o/003o`03/1;o01<00_l01_b2o?olPP;o00KlP_oogol3g`04
omoOo`CO00So/?n`4[3o/0?o01R`4[3oWonOGiooWenOGomOo`?o0mh3o`<3o`0<0mh3oh;oP_b2oh;l
0_l01X;lP_m@o`=@00?oD5000_l3D0;o0d001Om0od3o00=000ooh?oPX>3oh:3Pon2Ph?l02`0000X0
00?oPW401Ol01G62LOma00;o00>2ool00ol01h9aP_n2LOl00T06o`03@?m0009000?ogml01Ol00moo
g`03g`03oenO00Ko00MOWonOGooP00Go00WPX>3oh:3oT5001_l0291@oe2@o`<C1_l020<C0a<3oo4B
1_l01O4BlA;o01<000?oLOl01?l01G62LOma00;o0]l5o`03gooO00?O00?olA801_l02?4BlA;aoimO
1_l01imOoeoo4`<01_l021<34`<Cog621Ol02H9aP_n2LOm@T006o`07D93oT53o@006o`03@?m00090
00?oX>001Ol01n2Ph?oPX?l02`0000X000Soo8;lP_b2o0?o00[lP_ooo8;lP_b20ol018;lP_l8@0;o
0d000ooOg`05g`;o1=l02OmOWenOGimOW`02o`0:GimOoj3PX>2Ph0Co00>Ph?l02502o`=@00SogP?N
0mh3gPCo00/3g_n`4[0B/1:`4P03o`034_l0018000OoP_b2o8;l00?o00ClP_oo1ml2o`CO00Wo/1:`
4[0B/1800ol02a:`oimOWenOGimO00;o00ZOGol3gP?N0mh31?l02]h3oh;lP_b2o883o`04P_b2o`Q@
0_l3D003od1000E00_l3@008on2Ph:3PX>04o`03X>3o00/0000:000=oh9aPW62LH9aPW62L@02o`0=
PW62LH9aPW62LH9ao`0=@003omoO00_O04GoGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3oT52@D91@
T52@D91@T?l34`<C0a<34`<C0a<3oo4BlA;a4_4BlA;a4_l04`003?maPW62LH9aPW62L@;o3Ml0A_oa
4_4BlA;a4_4BlA;aoimOWenOGimOWenOGolC0a<34`<C0a<34`<Cog62LH9aPW62LH9aPW7oD91@T52@
D91@T52@D?l<@00?oj3PX>2Ph:3PX>2Ph:3o00/0000:000=oob2o8;lP_b2o8;lPP02o`0=o8;lP_b2
o8;lP_b2o`0=@003omoO00_O01coGimOWenOGimOWenOGonPh:3PX>2Ph:3PX>3o3E007?oN0mh3gP?N
0mh3gP?Nok0B/1:`4[0B/1:`4_lC000<oh;lP_b2o8;lP_b20_l=g`0hok0B/1:`4[0B/1:`4[3oWenO
GimOWenOGimOo`?N0mh3gP?N0mh3gP?oP_b2o8;lP_b2o8;lP_l=D003od1000Y000ooh:3PX>2Ph:3P
X>2Ph?l02`0000X000goPW62LH9aPW62LH9a00;o00f2LH9aPW62LH9aPW7o00e000?ogml02ml0AOmO
WenOGimOWenOGimOon2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@o`<C0a<34`<C0a<34`?olA;a4_4B
lA;a4_4Bo`0C000<og62LH9aPW62LH9a0_l=g`16oo4BlA;a4_4BlA;a4_7oWenOGimOWenOGimOoa<3
4`<C0a<34`<C0a?oLH9aPW62LH9aPW62LOm@T52@D91@T52@D91@o`a000ooX>2Ph:3PX>2Ph:3PX?l0
2`0000X0O?lC07co2`0000X000goWenOGimOWenOGimO00;o00fOGimOWenOGimOWeoo00gO00?o@400
2d00AOmaPW62LH9aPW62LH9aoa;a4_4BlA;a4_4BlOl34`<C0a<34`<C0a<3oi1@T52@D91@T52@D93o
X>2Ph:3PX>2Ph:3Po`0C000<oenOGimOWenOGimO0_l=g`1Coi1@T52@D91@T52@D93olA;a4_4BlA;a
4_4Bog62LH9aPW62LH9aPW7oGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3Poa<34`<C0a<34`<C0ol0
3D000ol0000900002P003OnOGimOWenOGimOWel00_l03ImOWenOGimOWenOGol03Ml00om0@00;@00Z
oh;lP_b2o8;lP_b2o8;o4[0B/1:`4[0B/1:`omh3gP?N0mh3gP?N0mko3E003_oPX>2Ph:3PX>2Ph:3o
4`003?mOWenOGimOWenOG`;o3Ml00om@D00;D015ok0B/1:`4[0B/1:`4_n2o8;lP_b2o8;lP_b2oenO
GimOWenOGimOWeooX>2Ph:3PX>2Ph:3PX?l3gP?N0mh3gP?N0mko00e000?o00002@0000X000?oWel0
0ol01enOGimOWel00_l03IoooonOGimOWenOGol00]l3o`SO00?o@4000ol8@003og6200?o00Z2LH9a
PW62LOlB0ol02a;a4_4BlA;ao`<C00?o00/C0a<34`<C0on@D003o`0;D91@T52@D93oX>000ol02>2P
h:3PX>3o4`000omOo`02o`07GimOWenOG`02o`;O0ol8g`03oi1@00?o00]@T52@D91@T?oa4P03o`0:
4_4BlA;a4_maPP?o00^2LH9aPW62LOmOW`03o`0;WenOGimOWeooh:000ol02Z3PX>2Ph:3Poa<3o`09
4`<C0a<34`?o00900ol8@003o`0000T0000:000=oimOWenOoimOWenOG`02o`0=WenOGomOWenOGimO
o`05g`03omoO00GO00?o@4000d000om0@005@00Zoh;lP_b2oh;lP_b2o8;o4[0B/?n`4[0B/1:`omh3
gP?Nomh3gP?N0mko1E000om@D005D00>on2Ph:3Pon2Ph:3PX?lC000<oenOGiooWenOGimO0_l5g`03
omoO00GO00?oD5000e000om@D005D015ok0B/1:`ok0B/1:`4_n2o8;lP_n2o8;lP_b2oenOGimOoenO
GimOWeooX>2Ph:3oX>2Ph:3PX?l3gP?Nomh3gP?N0mko00E000?o@4001D000ol0000900002P000onO
G`04o`03Wooo00;o00AOoonO1?l00eooo`02o`03Weoo00;O1?l01=ooool3g`03od1000Co0T03o`90
00?oLH801?l02G7ooomaPW7o4P04o`0:lA;ooo4BlOl34`Co00X3oooo0a<3oi1@1?l02Y1@oon@D93o
X>04o`07X>3oh:3Po`0C0003oeoo00?o00>Oool00_l00eooo`02g`Co00COoooo0ml00on@D004o`0:
T53ooi1@T?oa4PCo00Wa4_oolA;oLH801?l02W7ooomaPW7oGil4o`03Gooo00;o00FOGooPX004o`09
h:3oX>2Ph?lC00Co00P3oooo0a<3o`901?l2@0?o0T000ol0000900002P003OnOoimOWonOGomOWel0
0ol03UnOGomOWonOGimOomoo0ml01?oOgol4g`03od3o00=000Go@410o`03@00>oh;oP_b2oh;lP_co
o882o`0L/1:`ok3o/1;o4[3og_oN0mkogP?N0ol3g_m@o`=@00?oD?l00U004Om@D?oPon2Ph?oPX?nP
h:3o01<00_l02YmOWonOGomOWel2o`03gooO00;O00Cogmoo1=l00om@o`03D003oe3o009@03[oD53o
/?n`4[3o/?n`4_lBoh;oP_b2oh;lP_coo8;oGomOWeooGiooWenOGonPoj3PX?nPh?oPX>2P0_l03]h3
g_oN0mh3o`?Nod3o0d001Om0@43o00=000?o00002@0000X000goWonOGiooWenOoimO00?o00iOWeoo
GimOoenOGooOo`?O00Cogmoo1=l00om0o`03@003od3o00?o0T003_maog62LOmaPW62oh9a0_l0=O4B
lOoaoo4Boa;ao`?o0a<3o`<C0a?o4`?oT?n@D93oT?n@D?m@T?nPoj3PX?nPh:3oX>3o01<00_l02YmO
WonOGiooWel2o`03gooO00;O00Cogmoo1=l0AOn@oi1@T?n@oi1@oe2@oo7olA;aoo7olA;o4_maog62
LOmaPW62oh9aoeooGimOoenOGomOWeooh?oPX>3oh:3Pon2Ph002o`0>0a<3o`<C0a?o4`?o@?l3@003
od3o00?o0T000ol0000900002P003OnOoimOWonOGimOoel00ol03UnOGomOWenOoimOomoo0ml01?oO
gol4g`03od3o00=000Go@?m0o`03@009oh;oP_b2oh;l00;o00>2o8800_l01K0B/?n`00?o00^`4[3o
g_oN0mkogP03o`06gP?Noe3o0e000om@D002o`=@00koh?oPX>3oh:3Pon2Poa<00_l02YmOWonOGimO
oel2o`03gooO00;O00Cogmoo1=l00om@o`03D003oe1@00;o0e002?n`ok0B/?n`0ol02k0Boh;oP_b2
oh;l00;o01n2o8;oGomOWeooGimOWonOGonPoj3PX?nPh:3oX>2P00;o00GN0mkogP03o`06gP?Nod3o
0d001Om0od3o00=000?o00002@0000X000?oWel01_l019mOoel2o`03Wooo00Co00IOWonOGol2g`Go
00?Ooml00ml00om0@006o`03@?m0009000?oLH801Ol0289aP_n2LOlB1_l02?4BlA;ao`<C1_l020<C
0a<3oi1@1_l0291@oe2@oj3P1Ol01^2Ph?oPoa<000?oGol01Ol019mOoel2o`;O1Ol00moog`03g`03
oi1@00Ko00R@D?m@T?oa4PKo00Oa4_4Bog6200Go00V2LH;oPW7oGil01_l025nOoimOon2P1Ol02:3P
X?nPh?lC1_l01P<C0a<3o`901_l00d3o@002@003o`0000T0000:0009oimOWenOGimO00;o00^OGooo
WenOGimOW`02o`04GimOo`OO0_l4g`03od1000I00_l3@008oh;lP_b2o883o`0;P_b2oa:`4[0B/180
0ol02Q:`omh3gP?N0mh4o`030mko00Q@0_l3D008on2Ph:3PX>04o`03X?l0018000SoGimOWenOG`;o
00BOGooo1ml2o`CO00?oD5001U02o`=@00Wo/1:`4[0B/1800ol02A;oP_b2o8;lPP03o`0<P_b2oenO
GimOWenO0_l02enOGonPh:3PX>2P00Co00WPX?l3gP?N0mh01?l00`?No`08@0;o0d000ol000090000
2P003OnOGimOWenOGimOWel00_l03ImOWenOGimOWenOGol03Ml00om0@00;@015og62LH9aPW62LH9a
PW7o4_4BlA;a4_4BlA;ao`<C0a<34`<C0a<34`?oT52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>3o01<0
00coGimOWenOGimOWel2o`gO05?oT52@D91@T52@D91@T?oa4_4BlA;a4_4BlA;oLH9aPW62LH9aPW62
LOmOWenOGimOWenOGimOon2Ph:3PX>2Ph:3PX>3o4`<C0a<34`<C0a<3o`0=@003o`0000T0000:000=
oimOWenOGimOWenOG`02o`0=WenOGimOWenOGimOo`0=g`03od1000]002[oP_b2o8;lP_b2o8;lP_lB
/1:`4[0B/1:`4[3ogP?N0mh3gP?N0mh3g_l=D00>on2Ph:3PX>2Ph:3PX?lC000<oenOGimOWenOGimO
0_l=g`03oe1@00]@04Go/1:`4[0B/1:`4[0Boh;lP_b2o8;lP_b2o8;oGimOWenOGimOWenOGonPh:3P
X>2Ph:3PX>2Po`?N0mh3gP?N0mh3g_l03D000ol0000900002P003OnOGimOWenOGimOWel00_l03ImO
WenOGimOWenOGol03Ml00om0@00;@015og62LH9aPW62LH9aPW7o4_4BlA;a4_4BlA;ao`<C0a<34`<C
0a<34`?oT52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>3o01<000coGimOWenOGimOWel2o`gO05?oT52@
D91@T52@D91@T?oa4_4BlA;a4_4BlA;oLH9aPW62LH9aPW62LOmOWenOGimOWenOGimOon2Ph:3PX>2P
h:3PX>3o4`<C0a<34`<C0a<3o`0=@003o`0000T0000:07co4`1lo`/0000:0003omoO00[O0_l<g`0M
oenOGimOWenOGimOWeooLH9aPW62LH9aPW62LOl03D00=olC0a<34`<C0a<34`?olA;a4_4BlA;a4_4B
lOnPh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?l04`000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O
00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO00?o
1ml2o`04goooo`SO00?oGil00ol02imOWenOGimOoh;l00?o00WlP_b2o8;lP_l00T03o`Q000?o0ol0
0_l02`?N0mh3gP?Nok0B00?o00/B/1:`4[0B/?oPX003o`09X>2Ph:3PX>3o009@0ol7D003o`000140
00?ogol00_l7g`;o0]l3o`SO00?ogml00ol8g`03omoO00?o1ml00ooOg`03o`SO00?ogml00ol8g`03
omoO00?o2=l00ooOo`02o`SO00?ogml00ol8g`03o`0000T0000:0003omoO00?O00?ogml01=l2o`CO
00?ogml01Ml07OmOWenOGomOWenOGimOog62LH9aog62LH9aPW7o00E000?o@4001D00=olC0a<3o`<C
0a<34`?olA;a4_7olA;a4_4BlOnPh:3PX?nPh:3PX>2Poi1@T52@oi1@T52@D?l04`000ooOg`02g`03
omoO00CO0_l5g`03omoO00GO00?ogml00ml00ooOg`05g`03omoO00?O00?ogml01=l00ooOg`03g`03
omoO00GO00?ogml00ml00ooOg`05g`03omoO00?O00?ogml01Ml00ooOg`02g`03omoO00GO00?ogml0
0ml00ooOg`05g`03o`0000T0000:0003omoO00Co00COoooo0]l2o`03gooo00;o00COoooo0ml00omO
W`04o`03Gooo00;o00FOGon2o004o`08P_oooh;lP_l2@0Co0T03o`9000?o0ol00ol02]kooooN0mko
/184o`0:/1;ook0B/?oPX0Co00SPX?nPh:3Po`9@1?l2D0;o0U000ol0000A0003omoo00?o00COoooo
0]l2o`;O1?l01=ooool3g`03omoO00Co00COoooo0ml00ooOg`04o`04goooo`;O00?ogml01?l01=oo
ool3g`03omoO00Co00COoooo0ml00ooOg`04o`04goooo`?O00?ogol00ol01=ooool3g`03omoO00Co
00COoooo0ml00ol0000900002P000ooOo`03g`04omoOo`?O0ol3g`04omoOo`CO01ooGomOWeooGioo
WenOGomaog62LOmaPW62oh9aod3o00=000Go@410o`03@0;o03D34`?o0a<34olC0ooaoo4BlOoaoo4B
oa;aoj3oX>2Poj3Pon2Ph:3oT?n@D93oT?n@D?m@o`0C00;o0ml01?oOgol3g`;o00?Ooml00]l01?oO
gol4g`03omoo00?O00Cogmoo1=l00ooOo`03g`04omoOo`?O00?ogol00ml01?oOgol4g`03omoo00?O
00Cogmoo1=l00ooOo`03g`04omoOo`CO0_l3g`04omoOo`CO00?ogol00ml01?oOgol4g`03o`0000T0
000:0003omoo00?O00Cogmoo0ml3o`?O00Cogmoo1=l07omOoenOGomOWeooGimOoh;oP_b2oh;lP_co
o8;o@?l00d000om0o`03o`900_l0:]h3g_oN0mh3o`?Nok3o/1:`ok3o/1;o4[3oh?oPX>3oh:3Pon2P
h?m@o`=@00?oD?l00U000om@o`0C00;o0ml01?oOgol3g`;o00?Ooml00]l01?oOgol4g`03omoo00?O
00Cogmoo1=l00ooOo`03g`04omoOo`?O00?ogol00ml01?oOgol4g`03omoo00?O00Cogmoo1=l00ooO
o`03g`04omoOo`CO0_l3g`04omoOo`CO00?ogol00ml01?oOgol4g`03o`0000T0000:0003omoo00?O
00Cogmoo0ml3o`?O00Cogmoo1=l05omOoenOGomOWenOoimOog7oLH9aog6200;o00IaPW7o@?l3@005
od3o@?l00d02o`050a<3o`<00ol02`<C0ooaoo4BlOoa00?o01[a4_7oX?nPh:3oX>2Poj3PX?n@oi1@
T?n@D0;o00>@D?l04`02o`?O00Cogmoo0ml2o`03gooO00;O00Cogmoo1=l00ooOo`03g`04omoOo`CO
00?ogol00ml01?oOgol3g`03omoo00?O00Cogmoo1=l00ooOo`03g`04omoOo`CO00?ogol00ml01?oO
gol4g`;o0ml01?oOgol4g`03omoo00?O00Cogmoo1=l00ol0000900002P000ooOg`05o`03gooO00;O
0_l00mooo`03o`03gooO00?O00?oGil01_l025nOoimOoh;l1Ol01ob2o?olP_l00T06o`03@?m00090
00?o0ol01Ol02=h3gP?Nok0B1_l02;0B/1:`on2P1Ol01j3PX?nPh?l00U06o`9@00?oD?l04`000ooO
o`04o`03gooO00;O0_l2g`Go00?Ooml00ml00ooOg`05o`03gooO00?O00?ogml01Ol00moog`02g`03
omoO00Go00?Ooml00ml00ooOg`05o`03gooO00?O00?ogml01Ol00moog`03g`03omoo00Co00?Ooml0
0ml00ooOg`05o`03gooO00?O00?o00002@0000X000?ogml01Ml2o`?O0_l6g`;o1=l02OmOWenOGimO
W`02o`0;GimOog62LH9aPW400ol01762LOl8@0;o0d001olC0a<34`<01?l02a<3oo4BlA;a4_4B00?o
00XBlOnPh:3PX>2P1?l02n2Poi1@T52@D91@00;o00>@D?l04`000ooOg`04g`;o0ml2o`OO0_l4g`03
omoO00GO0_l4g`03omoO00GO0_l3g`03omoO00GO0_l4g`03omoO00GO0_l4g`03omoO00GO0_l4g`03
omoO00CO0_l4g`03omoO00GO0_l4g`03o`0000T0000:0003omoO00[O0_l<g`0MoenOGimOWenOGimO
WeooP_b2o8;lP_b2o8;lP_l03D00:_l3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?oPX>2Ph:3PX>2P
h:3Po`a@00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03
omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO00[O0_l<g`0MoenOGimOWenOGimO
WeooLH9aPW62LH9aPW62LOl03D00=olC0a<34`<C0a<34`?olA;a4_4BlA;a4_4BlOnPh:3PX>2Ph:3P
X>2Poi1@T52@D91@T52@D?l04`000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooO
g`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO00[O0_l<g`0MoenOGimO
WenOGimOWeooP_b2o8;lP_b2o8;lP_l03D00:_l3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?oPX>2P
h:3PX>2Ph:3Po`a@00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooO
g`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000907go4P1mo`/0000907go4P1mo`/0
000:0003o`0000T00ol<g`0MoenOGimOWenOGimOWeooLH9aPW62LH9aPW62LOl03D00=olC0a<34`<C
0a<34`?olA;a4_4BlA;a4_4BlOnPh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?l04`000ol0000900;o
3Ml07?nOGimOWenOGimOWenOoh9aPW62LH9aPW62LOl=@00hoa<34`<C0a<34`<C0a?o4_4BlA;a4_4B
lA;a4_oPX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l;00002P001Ol0ool000;o10001Ol0oooO00?o
2=l00omOW`03o`0;WenOGimOWeooP_`00ol02Ob2o8;lP_b2o`02@0?o24000ol3o`02o`0;0mh3gP?N
0mko/1800ol02a:`4[0B/1:`on2P00?o00VPh:3PX>2Ph?l00U03o`M@00?o00004@03o`030?oo00D0
0ol2g`?o2=l00onOG`03o`0;GimOWenOGiooo8800ol028;lP_b2o8;o0T03o`Q000?o0mh00ol02mh3
gP?N0mh3oa:`00?o00Z`4[0B/1:`4_nP0ol02J3PX>2Ph:3Po`02D0?o25000ol0000900002P001_l0
0?l0o`@000?o00000_l4g`03omoO00GO01goGimOWeooGimOWenOGomaPW62LOmaPW62LH9ao`05@003
od1000E003Oo4`<C0ol34`<C0a<3oo4BlA;aoo4BlA;a4_7oX>2Ph:3oX>2Ph:3PX?n@D91@T?n@D91@
T53o01<000Go0?l0o`050004o`3oo`GO00?ogml01Ml07?nOGimOWonOGimOWenOoh9aPW62oh9aPW62
LOl5@003od1000E003So4`<C0a?o4`<C0a<34olBlA;a4_lBlA;a4_4Bon2Ph:3oX>2Ph:3PX?n@D91@
T?n@D91@T52@o`/0000:0005o`000?l010001?l00002o`03gooo00;o00COoooo0ml00omOW`04o`03
Gooo00;o00FOGon2o004o`08P_oooh;lP_l2@0Co0T03o`9000?o0ol00ol02]kooooN0mko/184o`0:
/1;ook0B/?oPX0Co00SPX?nPh:3Po`9@1?l2D0;o0U000ol0000A0004o`00o`D000?o00000_l2g`Co
00COoooo0ml00onOG`04o`03Wooo00;o00EOWoolPP04o`07o?oooob2o`02@0Co0T03o`9000?o0mh0
1?l02P?oool3gP?o4[04o`094[3ooa:`4_nP00Co00SPX?nPh:3Po`9@1?l2D0;o0e000ol000090000
2P001ol00?l0o`000ol300?o0ml01?oOgol4g`0OoeooGimOoenOoimOWeooLOmaPW7oLH9aP_n2LOm0
o`03@005od10@?l00d02o`0e0a<3o`<C0a?o4`?olOoa4_7olOoa4_lBlOnPoj3PX?nPh?oPX>2Poi3o
T52@oi3oT53oD?l04`001Ol0o`3o00800ol200;o00?Ooml00]l01?oOgol4g`0NoiooWenOoimOoenO
GiooP_n2LH;oPW62LOmaod3o0d001Om0@43o00=001co4olC0a?o4`<C0ol34olBoa;a4_lBoa;aoo4B
0_l06Z3PX?nPh?oPX>2Poi3oT52@oi3oT53oD93o2`0000X000Go0?oo0004o`@00ol3g`04omoOo`CO
01ooGomOWeooGimOoenOGon2oh;lP_n2o8;loob2od3o00=000?o@?l00ol2@0;o02[N0mkogP?N0ol3
g_n`ok0B/?n`ok0Boa:`on3oh:3Pon2Ph?oPX>3oD?l3D003oe3o009@00?oD?l04`03o`040?oo00;o
0`02o`03gooO00;O00Cogmoo1=l07_nOoimOWonOGiooWenOoocoo8;loob2o8;oP_m0o`=000?o@?l0
0ol2@00Lo`?o0mh3o`?N0mkogP?o4_lB/1;o4_lB/?n`4P;o00kPX>3oh:3Pon2Ph?m@o`=@00?oD?l0
0U001?m@D?l;00002P000ol000030004o`00o`<00ol3g`04omoOo`CO01OoGomOWeooGimOWonOGoma
og62LOmaPP02o`06LH9aod3o0d001Om0od3o00=00_l01@<C0ol300?o00/34`?olOoa4_7ol@03o`0J
lA;aoj3oX>2Poj3PX?nPh:3oT?n@D93oT502o`03T53o01<000?o00000`001?l00?l200;o00?Ooml0
0]l01?oOgol4g`0GoiooWenOoimOWeooGiooP_n2LH;oPW400_l01H9aod3o00=000Go@?m0o`03@008
oa?o4`<Coa<3o`0;4`<Coa;o4_4Boa800ol00a;a4P02o`0DX>2Poj3PX?nPh:3oT?n@D93oT502o`04
T52@o`/0000:0003o`00008000Go0000o`0300;o00?Oool00ol00moog`03g`03oenO00Ko00QOWonO
Gon2o0Go00OlP_coo8;o00901_l00d3o@002@003o`?o00Go00SN0mh3g_n`4PKo00R`4[0B/?oPX0Go
00NPh:3oX>3o009@1_l2D003oe3o01<000?o00000P001Ol0003o00800_l2g`Go00?Ooml00ml00onO
G`06o`08WeooGiooo885o`06P_b2oh;o0T06o`03@?m0009000?o0mh01_l020?N0mh3oa:`1_l01a:`
4[0Boj001Ol01j3PX?nPh?l00U06o`9@00CoD53o2`0000X000Go0000o`030003o`3o00800_l6g`;o
1=l02OmOWenOGimOW`02o`0;GimOog62LH9aPW400ol01762LOl8@0;o0d001olC0a<34`<01?l02a<3
oo4BlA;a4_4B00?o00XBlOnPh:3PX>2P1?l02n2Poi1@T52@D91@00;o00>@D?l04`001Ol0003o00<0
00Co0?l00_l7g`;o1=l02OnOGimOWenOG`02o`0;WenOoh9aPW62LH800ol00h9ao`08@0;o0d002?lC
0a<34`<C1?l02`<Coa;a4_4BlA;a00?o00Wa4_oPX>2Ph:001?l02n2Poi1@T52@D91@00;o00B@D93o
2`0000X000Co003o10000ol0o`0200;o3=l07OmOWenOGimOWenOGimOoh;lP_b2o8;lP_b2o8;o00e0
02[o0mh3gP?N0mh3gP?Nok0B/1:`4[0B/1:`4[3oh:3PX>2Ph:3PX>2Ph?l<D003o`00014000Co003o
10001?l0o`02o`gO01coWenOGimOWenOGimOWoolP_b2o8;lP_b2o8;o3D00:_l3gP?N0mh3gP?N0mh3
oa:`4[0B/1:`4[0B/1;oX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000?o0?l01002o`040?oo00;o
3=l07OmOWenOGimOWenOGimOog62LH9aPW62LH9aPW7o00e003Oo4`<C0a<34`<C0a<3oo4BlA;a4_4B
lA;a4_7oX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53o01<000?o0?l01002o`030?oo00;o3Ml07?nO
GimOWenOGimOWenOoh9aPW62LH9aPW62LOl=@00hoa<34`<C0a<34`<C0a?o4_4BlA;a4_4BlA;a4_oP
X>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l;00002P02o`/00_l<g`0MoenOGimOWenOGimOWeooP_b2
o8;lP_b2o8;lP_l03D00:_l3gP?N0mh3gP?N0mko/1:`4[0B/1:`4[0B/?oPX>2Ph:3PX>2Ph:3Po`a@
00?o00004@02o`X00_l=g`0LoimOWenOGimOWenOGiooo8;lP_b2o8;lP_b2o`e002[o0mh3gP?N0mh3
gP?N0olB/1:`4[0B/1:`4[0Boj3PX>2Ph:3PX>2Ph?l=D003o`0000T0000:07co4`1lo`/0000G00;o
S002ogT0003o0240001m00?o=`04oe400olA0000OP000ol0000g0003o`00058000?o0000400000X0
0_l00`3oo`0300Go00<0ool02?l200?o0P05o`800ol200;o00<0ool0:`02o`030?oo00X000?o0000
20000ol0000H0006o`000?l01Ol00`3oo`03o`800ol200Go00<0ool00_l200Go00<0ool00ol200?o
0P05o`800ol200Go0P03o`800_l00`3oo`0700;o00<0ool02@000ol0o`090003o`0000l0000;0003
o`3o00<000Oo0000o`3o00<000Go0000o`040004o`00o`<000Go0000o`030003o`3o008000?o0000
:`000ol0o`0;0003o`0000P000?o000060001ol0003o0?l00P000ol000020003o`00008000Co003o
0`001Ol0003o00<000Go0000o`050005o`000?l00`000ol0o`020005o`000?l00P001Ol0003o00<0
00Oo0000o`3o008000?o00001`000ol0o`0;0003o`0000P000?o00003`0000/00ol30007o`000?l0
o`030005o`000?l010000ol000040005o`000?l00`000ol0o`020003o`0002`000?o00002005o`L0
00?o0?l06@001ol0o`3o0?l00P000ol000020003o`00008000?o000010001Ol0003o00<000Go0000
o`050005o`000?l01@04o`<000?o000010001Ol0003o00<000?o0?l00P000ol000080003o`0000P0
1Ol70003o`3o0100000;0003o`3o00<000Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000
o`030003o`3o008000?o0000:`000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l00P000ol0
00020003o`00008000?o000010001Ol0003o00<000Go0000o`050005o`000?l00`000ol000020005
o`000?l01P001Ol0003o00<000?o0?l00P000ol000070003o`3o00/000?o00001`000ol0o`0@0000
30000ol0000300Co0P04o`800_l300Co0`02o`@00ol00`3oo`03ob`00_l00`3oo`0:0003o`0000H0
0_l00`3oo`0H00;o00<0ool00_l00`3oo`040004o`0000Co0`02o`801Ol40003o`0000800_l400Co
0P03o`801?l300;o1003o`030?oo00?o2002o`030?oo01<00_l00`3oo`0?00002`02o`P000?o0000
0`000ol000060003o`0007800_l300;o20000ol000020003o`00010000?o000050000ol000160000
5002o`@00_l30003o`00008000?o000010000ol0001h00?o10000ol000040003o`0000L00ol50003
o`0000h000?o000010000ol0000o0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143.75, 0}} -> {-0.0537398, -0.0251377, 
  0.00734314, 0.00734314}, {{7.3125, 137}, {140.312, 
  3.375}} -> {-1.7579, -0.489659, 0.0728683, 0.0728683}, {{149.938, 
  279.625}, {140.312, 3.375}} -> {-12.1507, -0.489659, 0.0728683, 
  0.0728683}},
  CellTags->"Visual"]
}, Open  ]],

Cell[TextData[{
  "1.5 How to change the ",
  StyleBox["Structure",
    FontFamily->"Courier"]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"How", "i:13"}],

Cell[TextData[{
  "There are several functions whose usage overlaps both groups and rings. \
For example, depending on the context, we can view ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " as either a group or a ring. Accordingly, when working with groups, the \
option ",
  StyleBox["Structure", "MR"],
  " defaults to the value ",
  StyleBox["Group", "MR"],
  " when defining ",
  StyleBox["Z", "MR"],
  ", but defaults to the value ",
  StyleBox["Ring", "MR"],
  " when working with rings. At any point, it has a value of either ",
  StyleBox["Group", "MR"],
  " or ",
  StyleBox["Ring", "MR"],
  ". "
}], "Text",
  CellTags->"How"],

Cell[TextData[{
  "The global variable ",
  StyleBox["DefaultStructure", "MR"],
  " holds the current value."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefaultStructure\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->"How"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(SwitchStructureTo[Group]\),
              "MR"], 
            RowBox[{
              StyleBox["DefaultStructure",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["becomes",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Group",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["work",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoids",
                SingleLetterItalics->False]}]},
          {
            StyleBox[\(SwitchStructureTo[Ring]\),
              "MR"], 
            RowBox[{
              StyleBox["DefaultStructure",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["becomes",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Ring",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["work",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoids",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.37, 0.63}},
  CellTags->"How"],

Cell["Switching structures.", "Caption",
  CellTags->"How"],

Cell[TextData[{
  "We can change the value of ",
  StyleBox["DefaultStructure", "MR"],
  " (as well as some other values) by using the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Ring]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Ring\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "If the default value is the desired value, then we can use ",
  StyleBox["Z", "MR"],
  " without mention of the intended structure."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[5]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Ringoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&, Mod[#1\ #2, 5]&]\)], "Output",\

  CellLabel->"Out[52]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "If, however, we are in the ",
  StyleBox["Rings", "MR"],
  " context and wish to use ",
  StyleBox["Z", "MR"],
  " to create a group, we simply add the option ",
  StyleBox["Structure \[Rule] Group", "MR"],
  "."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[5, \ Structure\  \[Rule] \ Group]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&]\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "This method is fine for one evaluation, but there are other approaches for \
multiple evaluations. If only ",
  StyleBox["Z", "MR"],
  " (or some other function) is affected, use the ",
  StyleBox["SetOptions", "MR"],
  " command. For example, if the default is ",
  StyleBox["Ring", "MR"],
  " and we wish to consider the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", we use the following."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[Z, Structure\  \[Rule] \ Group]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"How"],

Cell[BoxData[
    \({Mode \[Rule] Computational, Structure \[Rule] Group}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "Now we do not need to add the ",
  StyleBox["Structure", "MR"],
  " option to obtain a group."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[5]\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&]\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "We are still in the ",
  StyleBox["Rings", "MR"],
  " environment, however."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefaultStructure\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Ring\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "If the focus is to switch from considering rings to considering groups, \
use the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Group]\)], "Input",
  CellLabel->"In[57]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[57]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Structure", "MR"],
  " option works similarly for variations of the ",
  StyleBox["Z", "MR"],
  " function."
}], "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[10, \ 2, \ Structure\  \[Rule] \ Ring]\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->"How"],

Cell[BoxData[
    \(Ringoid[{0, 2, 4, 6, 8}, Mod[#1 + #2, 10]&, Mod[#1\ #2, 10]&]\)], 
  "Output",
  CellLabel->"Out[58]=",
  CellTags->"How"]
}, Open  ]],

Cell[TextData[{
  "Although the only acceptable values for the ",
  StyleBox["Structure", "MR"],
  " option of ",
  StyleBox["Z", "MR"],
  " and other functions are ",
  StyleBox["Group", "MR"],
  " and ",
  StyleBox["Ring", "MR"],
  ", the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function allows the variants ",
  StyleBox["Groups", "MR"],
  ", ",
  StyleBox["Groupoid", "MR"],
  ", ",
  StyleBox["Rings", "MR"],
  ", and ",
  StyleBox["Ringoid", "MR"],
  "."
}], "Text",
  CellTags->"How"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
WindowSize->{500, 400},
WindowMargins->{{13, Automatic}, {Automatic, 2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
TaggingRules:>{"NextIndexingNumber" -> 14, "IndexEntries" -> {{"i:1", 
  "web page"}, {"i:12", "\"Large\" elements and Visual Mode"}, {"i:13", 
  "SwitchStructureTo"}, {"i:3", "EAAM packages"}, {"i:4", 
  "Names in a package"}, {"i:5", "Overview of EAAM"}, {"i:7", 
  "Formation of EAAM objects"}, {"i:10", "Morphoid", "formation"}, {"i:11", 
  "Mode", "how to use"}, {"i:13", "DefaultStructure", "how to change"}, {
  "i:13", "Structure", "how to change"}, {"i:3", "Packages", "EAAM"}, {"i:8", 
  "Groupoid", "formation"}, {"i:9", "Ringoid", "formation"}, {"i:2", 
  "Loading all packages", "", ""}}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
AVU/IFiQKFD000000nM<00?WE=0000000<[B80?G^6P0AP1Y06`0I@1^0643id`0
0nMDl0000000b]800mNhJ00000000000000000?WC00000000000000000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Intro"->{
    Cell[2564, 83, 286, 11, 103, "Section",
      Evaluatable->False,
      CellTags->{"Intro", "Contents"}],
    Cell[2853, 96, 1259, 27, 191, "Text",
      Evaluatable->False,
      CellTags->{"Intro", "i:1"}]},
  "Contents"->{
    Cell[2564, 83, 286, 11, 103, "Section",
      Evaluatable->False,
      CellTags->{"Intro", "Contents"}]},
  "i:1"->{
    Cell[2853, 96, 1259, 27, 191, "Text",
      Evaluatable->False,
      CellTags->{"Intro", "i:1"}]},
  "First"->{
    Cell[4115, 125, 60, 1, 68, "Subsection",
      CellTags->"First"],
    Cell[4178, 128, 178, 5, 59, "Text",
      CellTags->"First"],
    Cell[4359, 135, 146, 4, 39, "Input",
      CellTags->"First"],
    Cell[4508, 141, 142, 4, 58, "Text",
      CellTags->"First"],
    Cell[4675, 149, 125, 4, 39, "Input",
      CellTags->"First"],
    Cell[4803, 155, 84, 3, 38, "Output",
      CellTags->"First"]},
  "Packages"->{
    Cell[4902, 161, 168, 6, 68, "Subsection",
      CellTags->"Packages"],
    Cell[5073, 169, 380, 11, 77, "Text",
      CellTags->"Packages"],
    Cell[5456, 182, 149, 4, 39, "Input",
      CellTags->"Packages"],
    Cell[5608, 188, 495, 14, 93, "Text",
      CellTags->"Packages"],
    Cell[6128, 206, 132, 4, 39, "Input",
      CellTags->"Packages"],
    Cell[6263, 212, 165, 4, 57, "Output",
      CellTags->"Packages"],
    Cell[6443, 219, 1189, 31, 179, "Text",
      CellTags->"Packages"],
    Cell[7635, 252, 12800, 350, 428, "DefinitionBox",
      CellTags->{"Packages", "i:3"}],
    Cell[20438, 604, 182, 7, 26, "Caption",
      CellTags->"Packages"],
    Cell[20623, 613, 280, 7, 59, "Text",
      CellTags->"Packages"],
    Cell[20906, 622, 162, 6, 41, "MathCaption",
      CellTags->"Packages"],
    Cell[21071, 630, 145, 4, 39, "Input",
      CellTags->"Packages"],
    Cell[21219, 636, 166, 5, 40, "MathCaption",
      CellTags->{"Packages", "i:4"}],
    Cell[21410, 645, 146, 4, 39, "Input",
      CellTags->"Packages"],
    Cell[21559, 651, 451, 8, 113, "Output",
      CellTags->"Packages"],
    Cell[22025, 662, 250, 7, 55, "MathCaption",
      CellTags->"Packages"],
    Cell[22300, 673, 128, 4, 39, "Input",
      CellTags->"Packages"],
    Cell[22431, 679, 411, 6, 139, "Print",
      CellTags->"Packages"]},
  "i:3"->{
    Cell[7635, 252, 12800, 350, 428, "DefinitionBox",
      CellTags->{"Packages", "i:3"}]},
  "i:4"->{
    Cell[21219, 636, 166, 5, 40, "MathCaption",
      CellTags->{"Packages", "i:4"}]},
  "Structures"->{
    Cell[22857, 688, 199, 7, 68, "Subsection",
      Evaluatable->False,
      CellTags->"Structures"],
    Cell[23059, 697, 113, 3, 60, "Subsubsection",
      Evaluatable->False,
      CellTags->"Structures"],
    Cell[23175, 702, 3788, 126, 281, "Text",
      Evaluatable->False,
      CellTags->{"Structures", "i:5"}],
    Cell[26966, 830, 591, 21, 58, "MathCaption",
      Evaluatable->False,
      CellTags->{"Structures", "i:6"}],
    Cell[27582, 855, 96, 2, 39, "Input",
      CellTags->"Structures"],
    Cell[27681, 859, 109, 3, 38, "Output",
      CellTags->"Structures"],
    Cell[27805, 865, 479, 14, 75, "Text",
      Evaluatable->False,
      CellTags->"Structures"],
    Cell[28287, 881, 274, 7, 70, "MathCaption",
      Evaluatable->False,
      CellTags->"Structures"],
    Cell[28586, 892, 102, 2, 39, "Input",
      CellTags->"Structures"],
    Cell[28691, 896, 115, 3, 38, "Output",
      CellTags->"Structures"],
    Cell[28821, 902, 919, 32, 55, "MathCaption",
      Evaluatable->False,
      CellTags->"Structures"],
    Cell[29765, 938, 105, 2, 39, "Input",
      CellTags->"Structures"],
    Cell[29873, 942, 237, 5, 68, "Output",
      CellTags->"Structures"],
    Cell[30125, 950, 785, 24, 75, "Text",
      Evaluatable->False,
      CellTags->"Structures"],
    Cell[30913, 976, 293, 11, 60, "Text",
      Evaluatable->False,
      CellTags->"Structures"]},
  "i:5"->{
    Cell[23175, 702, 3788, 126, 281, "Text",
      Evaluatable->False,
      CellTags->{"Structures", "i:5"}]},
  "i:6"->{
    Cell[26966, 830, 591, 21, 58, "MathCaption",
      Evaluatable->False,
      CellTags->{"Structures", "i:6"}]},
  "i:7"->{
    Cell[31209, 989, 310, 13, 60, "Subsubsection",
      Evaluatable->False,
      CellTags->{"i:7", "Form"}]},
  "Form"->{
    Cell[31209, 989, 310, 13, 60, "Subsubsection",
      Evaluatable->False,
      CellTags->{"i:7", "Form"}],
    Cell[31522, 1004, 208, 9, 43, "Text",
      Evaluatable->False,
      CellTags->{"i:8", "Form"}],
    Cell[31755, 1017, 107, 3, 39, "Input",
      CellTags->"Form"],
    Cell[31865, 1022, 104, 3, 38, "Output",
      CellTags->"Form"],
    Cell[31984, 1028, 172, 6, 43, "Text",
      Evaluatable->False,
      CellTags->"Form"],
    Cell[32181, 1038, 111, 3, 39, "Input",
      CellTags->"Form"],
    Cell[32295, 1043, 113, 3, 38, "Output",
      CellTags->"Form"],
    Cell[32423, 1049, 847, 17, 158, "Text",
      Evaluatable->False,
      CellTags->"Form"],
    Cell[33295, 1070, 95, 3, 39, "Input",
      CellTags->"Form"],
    Cell[33393, 1075, 583, 9, 229, "Print",
      CellTags->"Form"],
    Cell[33991, 1087, 527, 12, 93, "Text",
      Evaluatable->False,
      CellTags->"Form"],
    Cell[34543, 1103, 122, 4, 39, "Input",
      CellTags->"Form"],
    Cell[34668, 1109, 394, 7, 98, "Output",
      CellTags->"Form"],
    Cell[35077, 1119, 459, 13, 70, "MathCaption",
      CellTags->"Form"],
    Cell[35539, 1134, 482, 10, 151, "Input",
      CellTags->"Form"],
    Cell[36024, 1146, 180, 6, 40, "MathCaption",
      CellTags->"Form"],
    Cell[36229, 1156, 93, 3, 39, "Input",
      CellTags->"Form"],
    Cell[36325, 1161, 122, 3, 38, "Output",
      CellTags->"Form"],
    Cell[36462, 1167, 529, 18, 86, "MathCaption",
      CellTags->"Form"],
    Cell[37016, 1189, 87, 3, 39, "Input",
      CellTags->"Form"],
    Cell[37106, 1194, 83, 3, 38, "Output",
      CellTags->"Form"],
    Cell[37204, 1200, 161, 5, 55, "MathCaption",
      CellTags->"Form"],
    Cell[37390, 1209, 119, 3, 39, "Input",
      CellTags->"Form"],
    Cell[37512, 1214, 201, 4, 79, "Print",
      CellTags->"Form"],
    Cell[37716, 1220, 67609, 1145, 308, 6397, 383, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Form"],
    Cell[105328, 2367, 173, 4, 53, "Output",
      CellTags->"Form"],
    Cell[105516, 2374, 390, 11, 69, "MathCaption",
      CellTags->"Form"],
    Cell[105931, 2389, 90, 3, 39, "Input",
      CellTags->"Form"],
    Cell[106024, 2394, 142, 4, 38, "Output",
      CellTags->"Form"],
    Cell[106181, 2401, 624, 15, 110, "Text",
      CellTags->"Form"],
    Cell[106808, 2418, 131, 5, 41, "MathCaption",
      CellTags->"Form"],
    Cell[106964, 2427, 481, 11, 135, "Input",
      CellTags->"Form"],
    Cell[107448, 2440, 118, 3, 38, "Output",
      CellTags->"Form"],
    Cell[107581, 2446, 129, 5, 41, "MathCaption",
      CellTags->"Form"],
    Cell[107735, 2455, 242, 7, 71, "Input",
      CellTags->"Form"],
    Cell[107980, 2464, 113, 3, 38, "Output",
      CellTags->"Form"],
    Cell[108108, 2470, 134, 4, 54, "MathCaption",
      CellTags->"Form"],
    Cell[108267, 2478, 157, 4, 39, "Input",
      CellTags->"Form"],
    Cell[108427, 2484, 372, 6, 109, "Print",
      CellTags->"Form"],
    Cell[108802, 2492, 201, 4, 79, "Print",
      CellTags->"Form"],
    Cell[109006, 2498, 54992, 1534, 164, 17451, 1064, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Form"],
    Cell[164013, 4035, 353, 9, 75, "Text",
      CellTags->"Form"],
    Cell[164369, 4046, 225, 7, 56, "MathCaption",
      CellTags->"Form"],
    Cell[164619, 4057, 107, 3, 39, "Input",
      CellTags->"Form"],
    Cell[164729, 4062, 1608, 58, 85, "Output",
      CellTags->"Form"],
    Cell[166352, 4123, 359, 11, 60, "Text",
      CellTags->{"i:9", "Form"}],
    Cell[166736, 4138, 94, 3, 39, "Input",
      CellTags->"Form"],
    Cell[166833, 4143, 879, 13, 319, "Print",
      CellTags->"Form"],
    Cell[167727, 4159, 217, 5, 56, "MathCaption",
      CellTags->"Form"],
    Cell[167969, 4168, 268, 7, 71, "Input",
      CellTags->"Form"],
    Cell[168240, 4177, 115, 3, 38, "Output",
      CellTags->"Form"],
    Cell[168370, 4183, 128, 4, 40, "MathCaption",
      CellTags->"Form"],
    Cell[168523, 4191, 144, 4, 39, "Input",
      CellTags->"Form"],
    Cell[168670, 4197, 44177, 941, 175, 8685, 496, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Form"],
    Cell[212850, 5140, 185, 4, 53, "Output",
      CellTags->"Form"],
    Cell[213050, 5147, 132, 5, 41, "MathCaption",
      CellTags->"Form"],
    Cell[213207, 5156, 110, 4, 39, "Input",
      CellTags->"Form"],
    Cell[213320, 5162, 84, 3, 38, "Output",
      CellTags->"Form"],
    Cell[213419, 5168, 192, 7, 55, "MathCaption",
      CellTags->"Form"],
    Cell[213636, 5179, 113, 4, 39, "Input",
      CellTags->"Form"],
    Cell[213752, 5185, 217, 5, 83, "Output",
      CellTags->"Form"],
    Cell[213984, 5193, 614, 13, 125, "Text",
      CellTags->{"i:10", "Form"}],
    Cell[214623, 5210, 118, 4, 39, "Input",
      CellTags->"Form"],
    Cell[214744, 5216, 923, 13, 304, "Print",
      CellTags->"Form"],
    Cell[215682, 5232, 153, 5, 41, "MathCaption",
      CellTags->"Form"],
    Cell[215860, 5241, 99, 3, 39, "Input",
      CellTags->"Form"],
    Cell[215962, 5246, 139, 4, 38, "Output",
      CellTags->"Form"],
    Cell[216116, 5253, 574, 16, 93, "Text",
      CellTags->"Form"],
    Cell[216693, 5271, 542, 18, 54, "MathCaption",
      CellTags->"Form"],
    Cell[217260, 5293, 207, 5, 71, "Input",
      CellTags->"Form"],
    Cell[217470, 5300, 120, 3, 38, "Output",
      CellTags->"Form"],
    Cell[217605, 5306, 351, 12, 54, "MathCaption",
      CellTags->"Form"],
    Cell[217981, 5322, 327, 7, 87, "Input",
      CellTags->"Form"],
    Cell[218311, 5331, 196, 4, 53, "Output",
      CellTags->"Form"],
    Cell[218522, 5338, 202, 7, 56, "MathCaption",
      CellTags->"Form"],
    Cell[218749, 5349, 102, 3, 39, "Input",
      CellTags->"Form"],
    Cell[218854, 5354, 83, 3, 38, "Output",
      CellTags->"Form"],
    Cell[218952, 5360, 169, 5, 55, "MathCaption",
      CellTags->"Form"],
    Cell[219146, 5369, 98, 3, 39, "Input",
      CellTags->"Form"],
    Cell[219247, 5374, 196, 4, 53, "Output",
      CellTags->"Form"],
    Cell[219458, 5381, 183, 5, 55, "MathCaption",
      CellTags->"Form"],
    Cell[219644, 5388, 128, 4, 55, "Input",
      CellTags->"Form"],
    Cell[219775, 5394, 148, 6, 40, "MathCaption",
      CellTags->"Form"],
    Cell[219948, 5404, 198, 5, 55, "Input",
      CellTags->"Form"],
    Cell[220149, 5411, 115, 3, 38, "Output",
      CellTags->"Form"],
    Cell[220279, 5417, 442, 13, 83, "MathCaption",
      CellTags->"Form"],
    Cell[220746, 5434, 191, 5, 39, "Input",
      CellTags->"Form"],
    Cell[220940, 5441, 9811, 179, 164, 1318, 68, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Form"]},
  "i:8"->{
    Cell[31522, 1004, 208, 9, 43, "Text",
      Evaluatable->False,
      CellTags->{"i:8", "Form"}]},
  "i:9"->{
    Cell[166352, 4123, 359, 11, 60, "Text",
      CellTags->{"i:9", "Form"}]},
  "i:10"->{
    Cell[213984, 5193, 614, 13, 125, "Text",
      CellTags->{"i:10", "Form"}]},
  "Mode"->{
    Cell[230766, 5623, 180, 7, 68, "Subsection",
      Evaluatable->False,
      CellTags->{"Mode", "i:11"}],
    Cell[230949, 5632, 796, 20, 143, "Text",
      CellTags->"Mode"],
    Cell[231748, 5654, 5073, 124, 218, "DefinitionBox",
      CellTags->"Mode"],
    Cell[236824, 5780, 131, 6, 26, "Caption",
      CellTags->"Mode"],
    Cell[236958, 5788, 544, 14, 82, "MathCaption",
      CellTags->"Mode"],
    Cell[237527, 5806, 83, 3, 39, "Input",
      CellTags->"Mode"],
    Cell[237613, 5811, 188, 4, 68, "Output",
      CellTags->"Mode"],
    Cell[237816, 5818, 240, 8, 55, "MathCaption",
      CellTags->"Mode"],
    Cell[238081, 5830, 96, 3, 39, "Input",
      CellTags->"Mode"],
    Cell[238180, 5835, 83, 3, 38, "Output",
      CellTags->"Mode"],
    Cell[238278, 5841, 229, 7, 56, "MathCaption",
      CellTags->"Mode"],
    Cell[238532, 5852, 124, 3, 39, "Input",
      CellTags->"Mode"],
    Cell[238659, 5857, 197, 4, 64, "Print",
      CellTags->"Mode"],
    Cell[238859, 5863, 117, 3, 49, "Print",
      CellTags->"Mode"],
    Cell[238979, 5868, 83, 3, 38, "Output",
      CellTags->"Mode"],
    Cell[239077, 5874, 296, 11, 56, "MathCaption",
      CellTags->"Mode"],
    Cell[239398, 5889, 123, 3, 39, "Input",
      CellTags->"Mode"],
    Cell[239524, 5894, 95626, 1890, 308, 22070, 976, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Mode"],
    Cell[335153, 7786, 83, 3, 38, "Output",
      CellTags->"Mode"],
    Cell[335251, 7792, 265, 7, 70, "MathCaption",
      CellTags->"Mode"],
    Cell[335541, 7803, 116, 3, 39, "Input",
      CellTags->"Mode"],
    Cell[335660, 7808, 160, 4, 51, "Message",
      CellTags->"Mode"],
    Cell[335823, 7814, 109, 3, 38, "Output",
      CellTags->"Mode"]},
  "i:11"->{
    Cell[230766, 5623, 180, 7, 68, "Subsection",
      Evaluatable->False,
      CellTags->{"Mode", "i:11"}]},
  "Visual"->{
    Cell[335947, 7820, 207, 6, 68, "Subsection",
      CellTags->{"Visual", "i:12"}],
    Cell[336157, 7828, 468, 9, 90, "Text",
      CellTags->"Visual"],
    Cell[336628, 7839, 225, 7, 54, "MathCaption",
      CellTags->"Visual"],
    Cell[336878, 7850, 147, 4, 39, "Input",
      CellTags->"Visual"],
    Cell[337028, 7856, 235, 4, 64, "Print",
      CellTags->"Visual"],
    Cell[337266, 7862, 76755, 1326, 308, 7909, 470, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Visual"],
    Cell[414036, 9191, 3135, 90, 85, "DefinitionBox",
      CellTags->"Visual"],
    Cell[417174, 9283, 66, 1, 15, "Caption",
      CellTags->"Visual"],
    Cell[417243, 9286, 146, 5, 29, "MathCaption",
      CellTags->"Visual"],
    Cell[417414, 9295, 108, 3, 26, "Input",
      CellTags->"Visual"],
    Cell[417525, 9300, 85, 3, 20, "Output",
      CellTags->"Visual"],
    Cell[417625, 9306, 429, 9, 85, "MathCaption",
      CellTags->"Visual"],
    Cell[418079, 9319, 178, 4, 42, "Input",
      CellTags->"Visual"],
    Cell[418260, 9325, 111, 3, 20, "Output",
      CellTags->"Visual"],
    Cell[418386, 9331, 168, 5, 29, "MathCaption",
      CellTags->"Visual"],
    Cell[418579, 9340, 132, 3, 26, "Input",
      CellTags->"Visual"],
    Cell[418714, 9345, 249, 4, 50, "Print",
      CellTags->"Visual"],
    Cell[418966, 9351, 65298, 1908, 151, 22736, 1376, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Visual"],
    Cell[484279, 11262, 189, 7, 29, "MathCaption",
      CellTags->"Visual"],
    Cell[484493, 11273, 174, 4, 42, "Input",
      CellTags->"Visual"],
    Cell[484670, 11279, 303, 5, 54, "Print",
      CellTags->"Visual"],
    Cell[484976, 11286, 65303, 1908, 151, 22742, 1376, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Visual"]},
  "i:12"->{
    Cell[335947, 7820, 207, 6, 68, "Subsection",
      CellTags->{"Visual", "i:12"}]},
  "How"->{
    Cell[550294, 13197, 189, 7, 36, "Subsection",
      Evaluatable->False,
      CellTags->{"How", "i:13"}],
    Cell[550486, 13206, 670, 20, 66, "Text",
      CellTags->"How"],
    Cell[551159, 13228, 147, 5, 29, "MathCaption",
      CellTags->"How"],
    Cell[551331, 13237, 93, 3, 26, "Input",
      CellTags->"How"],
    Cell[551427, 13242, 83, 3, 20, "Output",
      CellTags->"How"],
    Cell[551525, 13248, 2368, 66, 86, "DefinitionBox",
      CellTags->"How"],
    Cell[553896, 13316, 59, 1, 15, "Caption",
      CellTags->"How"],
    Cell[553958, 13319, 229, 7, 44, "MathCaption",
      CellTags->"How"],
    Cell[554212, 13330, 100, 3, 26, "Input",
      CellTags->"How"],
    Cell[554315, 13335, 82, 3, 20, "Output",
      CellTags->"How"],
    Cell[554412, 13341, 189, 5, 43, "MathCaption",
      CellTags->"How"],
    Cell[554626, 13350, 81, 3, 26, "Input",
      CellTags->"How"],
    Cell[554710, 13355, 139, 4, 20, "Output",
      CellTags->"How"],
    Cell[554864, 13362, 269, 9, 44, "MathCaption",
      CellTags->"How"],
    Cell[555158, 13375, 112, 3, 26, "Input",
      CellTags->"How"],
    Cell[555273, 13380, 121, 3, 20, "Output",
      CellTags->"How"],
    Cell[555409, 13386, 489, 13, 72, "MathCaption",
      CellTags->"How"],
    Cell[555923, 13403, 119, 3, 26, "Input",
      CellTags->"How"],
    Cell[556045, 13408, 131, 3, 20, "Output",
      CellTags->"How"],
    Cell[556191, 13414, 151, 5, 29, "MathCaption",
      CellTags->"How"],
    Cell[556367, 13423, 81, 3, 26, "Input",
      CellTags->"How"],
    Cell[556451, 13428, 121, 3, 20, "Output",
      CellTags->"How"],
    Cell[556587, 13434, 133, 5, 29, "MathCaption",
      CellTags->"How"],
    Cell[556745, 13443, 93, 3, 26, "Input",
      CellTags->"How"],
    Cell[556841, 13448, 82, 3, 20, "Output",
      CellTags->"How"],
    Cell[556938, 13454, 195, 6, 44, "MathCaption",
      CellTags->"How"],
    Cell[557158, 13464, 101, 3, 26, "Input",
      CellTags->"How"],
    Cell[557262, 13469, 83, 3, 20, "Output",
      CellTags->"How"],
    Cell[557360, 13475, 184, 7, 29, "MathCaption",
      CellTags->"How"],
    Cell[557569, 13486, 117, 3, 26, "Input",
      CellTags->"How"],
    Cell[557689, 13491, 142, 4, 20, "Output",
      CellTags->"How"],
    Cell[557846, 13498, 497, 21, 53, "Text",
      CellTags->"How"]},
  "i:13"->{
    Cell[550294, 13197, 189, 7, 36, "Subsection",
      Evaluatable->False,
      CellTags->{"How", "i:13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Intro", 560045, 13560},
  {"Contents", 560275, 13567},
  {"i:1", 560397, 13571},
  {"First", 560514, 13575},
  {"Packages", 560935, 13588},
  {"i:3", 562278, 13625},
  {"i:4", 562382, 13628},
  {"Structures", 562487, 13631},
  {"i:5", 563884, 13671},
  {"i:6", 564007, 13675},
  {"i:7", 564134, 13679},
  {"Form", 564258, 13683},
  {"i:8", 570864, 13869},
  {"i:9", 570978, 13873},
  {"i:10", 571069, 13876},
  {"Mode", 571162, 13879},
  {"i:11", 572908, 13928},
  {"Visual", 573033, 13932},
  {"i:12", 574837, 13980},
  {"How", 574935, 13983},
  {"i:13", 577264, 14049}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 830, 30, 118, "Subsubtitle",
  Evaluatable->False],
Cell[2564, 83, 286, 11, 103, "Section",
  Evaluatable->False,
  CellTags->{"Intro", "Contents"}],
Cell[2853, 96, 1259, 27, 191, "Text",
  Evaluatable->False,
  CellTags->{"Intro", "i:1"}],
Cell[4115, 125, 60, 1, 68, "Subsection",
  CellTags->"First"],
Cell[4178, 128, 178, 5, 59, "Text",
  CellTags->"First"],
Cell[4359, 135, 146, 4, 39, "Input",
  CellTags->"First"],
Cell[4508, 141, 142, 4, 58, "Text",
  CellTags->"First"],

Cell[CellGroupData[{
Cell[4675, 149, 125, 4, 39, "Input",
  CellTags->"First"],
Cell[4803, 155, 84, 3, 38, "Output",
  CellTags->"First"]
}, Open  ]],
Cell[4902, 161, 168, 6, 68, "Subsection",
  CellTags->"Packages"],
Cell[5073, 169, 380, 11, 77, "Text",
  CellTags->"Packages"],
Cell[5456, 182, 149, 4, 39, "Input",
  CellTags->"Packages"],
Cell[5608, 188, 495, 14, 93, "Text",
  CellTags->"Packages"],

Cell[CellGroupData[{
Cell[6128, 206, 132, 4, 39, "Input",
  CellTags->"Packages"],
Cell[6263, 212, 165, 4, 57, "Output",
  CellTags->"Packages"]
}, Open  ]],
Cell[6443, 219, 1189, 31, 179, "Text",
  CellTags->"Packages"],
Cell[7635, 252, 12800, 350, 428, "DefinitionBox",
  CellTags->{"Packages", "i:3"}],
Cell[20438, 604, 182, 7, 26, "Caption",
  CellTags->"Packages"],
Cell[20623, 613, 280, 7, 59, "Text",
  CellTags->"Packages"],
Cell[20906, 622, 162, 6, 41, "MathCaption",
  CellTags->"Packages"],
Cell[21071, 630, 145, 4, 39, "Input",
  CellTags->"Packages"],
Cell[21219, 636, 166, 5, 40, "MathCaption",
  CellTags->{"Packages", "i:4"}],

Cell[CellGroupData[{
Cell[21410, 645, 146, 4, 39, "Input",
  CellTags->"Packages"],
Cell[21559, 651, 451, 8, 113, "Output",
  CellTags->"Packages"]
}, Open  ]],
Cell[22025, 662, 250, 7, 55, "MathCaption",
  CellTags->"Packages"],

Cell[CellGroupData[{
Cell[22300, 673, 128, 4, 39, "Input",
  CellTags->"Packages"],
Cell[22431, 679, 411, 6, 139, "Print",
  CellTags->"Packages"]
}, Open  ]],
Cell[22857, 688, 199, 7, 68, "Subsection",
  Evaluatable->False,
  CellTags->"Structures"],
Cell[23059, 697, 113, 3, 60, "Subsubsection",
  Evaluatable->False,
  CellTags->"Structures"],
Cell[23175, 702, 3788, 126, 281, "Text",
  Evaluatable->False,
  CellTags->{"Structures", "i:5"}],
Cell[26966, 830, 591, 21, 58, "MathCaption",
  Evaluatable->False,
  CellTags->{"Structures", "i:6"}],

Cell[CellGroupData[{
Cell[27582, 855, 96, 2, 39, "Input",
  CellTags->"Structures"],
Cell[27681, 859, 109, 3, 38, "Output",
  CellTags->"Structures"]
}, Open  ]],
Cell[27805, 865, 479, 14, 75, "Text",
  Evaluatable->False,
  CellTags->"Structures"],
Cell[28287, 881, 274, 7, 70, "MathCaption",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[CellGroupData[{
Cell[28586, 892, 102, 2, 39, "Input",
  CellTags->"Structures"],
Cell[28691, 896, 115, 3, 38, "Output",
  CellTags->"Structures"]
}, Open  ]],
Cell[28821, 902, 919, 32, 55, "MathCaption",
  Evaluatable->False,
  CellTags->"Structures"],

Cell[CellGroupData[{
Cell[29765, 938, 105, 2, 39, "Input",
  CellTags->"Structures"],
Cell[29873, 942, 237, 5, 68, "Output",
  CellTags->"Structures"]
}, Open  ]],
Cell[30125, 950, 785, 24, 75, "Text",
  Evaluatable->False,
  CellTags->"Structures"],
Cell[30913, 976, 293, 11, 60, "Text",
  Evaluatable->False,
  CellTags->"Structures"],
Cell[31209, 989, 310, 13, 60, "Subsubsection",
  Evaluatable->False,
  CellTags->{"i:7", "Form"}],
Cell[31522, 1004, 208, 9, 43, "Text",
  Evaluatable->False,
  CellTags->{"i:8", "Form"}],

Cell[CellGroupData[{
Cell[31755, 1017, 107, 3, 39, "Input",
  CellTags->"Form"],
Cell[31865, 1022, 104, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[31984, 1028, 172, 6, 43, "Text",
  Evaluatable->False,
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[32181, 1038, 111, 3, 39, "Input",
  CellTags->"Form"],
Cell[32295, 1043, 113, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[32423, 1049, 847, 17, 158, "Text",
  Evaluatable->False,
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[33295, 1070, 95, 3, 39, "Input",
  CellTags->"Form"],
Cell[33393, 1075, 583, 9, 229, "Print",
  CellTags->"Form"]
}, Open  ]],
Cell[33991, 1087, 527, 12, 93, "Text",
  Evaluatable->False,
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[34543, 1103, 122, 4, 39, "Input",
  CellTags->"Form"],
Cell[34668, 1109, 394, 7, 98, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[35077, 1119, 459, 13, 70, "MathCaption",
  CellTags->"Form"],
Cell[35539, 1134, 482, 10, 151, "Input",
  CellTags->"Form"],
Cell[36024, 1146, 180, 6, 40, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[36229, 1156, 93, 3, 39, "Input",
  CellTags->"Form"],
Cell[36325, 1161, 122, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[36462, 1167, 529, 18, 86, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[37016, 1189, 87, 3, 39, "Input",
  CellTags->"Form"],
Cell[37106, 1194, 83, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[37204, 1200, 161, 5, 55, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[37390, 1209, 119, 3, 39, "Input",
  CellTags->"Form"],
Cell[37512, 1214, 201, 4, 79, "Print",
  CellTags->"Form"],
Cell[37716, 1220, 67609, 1145, 308, 6397, 383, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Form"],
Cell[105328, 2367, 173, 4, 53, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[105516, 2374, 390, 11, 69, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[105931, 2389, 90, 3, 39, "Input",
  CellTags->"Form"],
Cell[106024, 2394, 142, 4, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[106181, 2401, 624, 15, 110, "Text",
  CellTags->"Form"],
Cell[106808, 2418, 131, 5, 41, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[106964, 2427, 481, 11, 135, "Input",
  CellTags->"Form"],
Cell[107448, 2440, 118, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[107581, 2446, 129, 5, 41, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[107735, 2455, 242, 7, 71, "Input",
  CellTags->"Form"],
Cell[107980, 2464, 113, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[108108, 2470, 134, 4, 54, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[108267, 2478, 157, 4, 39, "Input",
  CellTags->"Form"],
Cell[108427, 2484, 372, 6, 109, "Print",
  CellTags->"Form"],
Cell[108802, 2492, 201, 4, 79, "Print",
  CellTags->"Form"],
Cell[109006, 2498, 54992, 1534, 164, 17451, 1064, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Form"]
}, Open  ]],
Cell[164013, 4035, 353, 9, 75, "Text",
  CellTags->"Form"],
Cell[164369, 4046, 225, 7, 56, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[164619, 4057, 107, 3, 39, "Input",
  CellTags->"Form"],
Cell[164729, 4062, 1608, 58, 85, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[166352, 4123, 359, 11, 60, "Text",
  CellTags->{"i:9", "Form"}],

Cell[CellGroupData[{
Cell[166736, 4138, 94, 3, 39, "Input",
  CellTags->"Form"],
Cell[166833, 4143, 879, 13, 319, "Print",
  CellTags->"Form"]
}, Open  ]],
Cell[167727, 4159, 217, 5, 56, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[167969, 4168, 268, 7, 71, "Input",
  CellTags->"Form"],
Cell[168240, 4177, 115, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[168370, 4183, 128, 4, 40, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[168523, 4191, 144, 4, 39, "Input",
  CellTags->"Form"],
Cell[168670, 4197, 44177, 941, 175, 8685, 496, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Form"],
Cell[212850, 5140, 185, 4, 53, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[213050, 5147, 132, 5, 41, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[213207, 5156, 110, 4, 39, "Input",
  CellTags->"Form"],
Cell[213320, 5162, 84, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[213419, 5168, 192, 7, 55, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[213636, 5179, 113, 4, 39, "Input",
  CellTags->"Form"],
Cell[213752, 5185, 217, 5, 83, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[213984, 5193, 614, 13, 125, "Text",
  CellTags->{"i:10", "Form"}],

Cell[CellGroupData[{
Cell[214623, 5210, 118, 4, 39, "Input",
  CellTags->"Form"],
Cell[214744, 5216, 923, 13, 304, "Print",
  CellTags->"Form"]
}, Open  ]],
Cell[215682, 5232, 153, 5, 41, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[215860, 5241, 99, 3, 39, "Input",
  CellTags->"Form"],
Cell[215962, 5246, 139, 4, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[216116, 5253, 574, 16, 93, "Text",
  CellTags->"Form"],
Cell[216693, 5271, 542, 18, 54, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[217260, 5293, 207, 5, 71, "Input",
  CellTags->"Form"],
Cell[217470, 5300, 120, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[217605, 5306, 351, 12, 54, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[217981, 5322, 327, 7, 87, "Input",
  CellTags->"Form"],
Cell[218311, 5331, 196, 4, 53, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[218522, 5338, 202, 7, 56, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[218749, 5349, 102, 3, 39, "Input",
  CellTags->"Form"],
Cell[218854, 5354, 83, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[218952, 5360, 169, 5, 55, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[219146, 5369, 98, 3, 39, "Input",
  CellTags->"Form"],
Cell[219247, 5374, 196, 4, 53, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[219458, 5381, 183, 5, 55, "MathCaption",
  CellTags->"Form"],
Cell[219644, 5388, 128, 4, 55, "Input",
  CellTags->"Form"],
Cell[219775, 5394, 148, 6, 40, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[219948, 5404, 198, 5, 55, "Input",
  CellTags->"Form"],
Cell[220149, 5411, 115, 3, 38, "Output",
  CellTags->"Form"]
}, Open  ]],
Cell[220279, 5417, 442, 13, 83, "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{
Cell[220746, 5434, 191, 5, 39, "Input",
  CellTags->"Form"],
Cell[220940, 5441, 9811, 179, 164, 1318, 68, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Form"]
}, Open  ]],
Cell[230766, 5623, 180, 7, 68, "Subsection",
  Evaluatable->False,
  CellTags->{"Mode", "i:11"}],
Cell[230949, 5632, 796, 20, 143, "Text",
  CellTags->"Mode"],
Cell[231748, 5654, 5073, 124, 218, "DefinitionBox",
  CellTags->"Mode"],
Cell[236824, 5780, 131, 6, 26, "Caption",
  CellTags->"Mode"],
Cell[236958, 5788, 544, 14, 82, "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{
Cell[237527, 5806, 83, 3, 39, "Input",
  CellTags->"Mode"],
Cell[237613, 5811, 188, 4, 68, "Output",
  CellTags->"Mode"]
}, Open  ]],
Cell[237816, 5818, 240, 8, 55, "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{
Cell[238081, 5830, 96, 3, 39, "Input",
  CellTags->"Mode"],
Cell[238180, 5835, 83, 3, 38, "Output",
  CellTags->"Mode"]
}, Open  ]],
Cell[238278, 5841, 229, 7, 56, "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{
Cell[238532, 5852, 124, 3, 39, "Input",
  CellTags->"Mode"],
Cell[238659, 5857, 197, 4, 64, "Print",
  CellTags->"Mode"],
Cell[238859, 5863, 117, 3, 49, "Print",
  CellTags->"Mode"],
Cell[238979, 5868, 83, 3, 38, "Output",
  CellTags->"Mode"]
}, Open  ]],
Cell[239077, 5874, 296, 11, 56, "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{
Cell[239398, 5889, 123, 3, 39, "Input",
  CellTags->"Mode"],
Cell[239524, 5894, 95626, 1890, 308, 22070, 976, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Mode"],
Cell[335153, 7786, 83, 3, 38, "Output",
  CellTags->"Mode"]
}, Open  ]],
Cell[335251, 7792, 265, 7, 70, "MathCaption",
  CellTags->"Mode"],

Cell[CellGroupData[{
Cell[335541, 7803, 116, 3, 39, "Input",
  CellTags->"Mode"],
Cell[335660, 7808, 160, 4, 51, "Message",
  CellTags->"Mode"],
Cell[335823, 7814, 109, 3, 38, "Output",
  CellTags->"Mode"]
}, Open  ]],
Cell[335947, 7820, 207, 6, 68, "Subsection",
  CellTags->{"Visual", "i:12"}],
Cell[336157, 7828, 468, 9, 90, "Text",
  CellTags->"Visual"],
Cell[336628, 7839, 225, 7, 54, "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{
Cell[336878, 7850, 147, 4, 39, "Input",
  CellTags->"Visual"],
Cell[337028, 7856, 235, 4, 64, "Print",
  CellTags->"Visual"],
Cell[337266, 7862, 76755, 1326, 308, 7909, 470, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Visual"]
}, Open  ]],
Cell[414036, 9191, 3135, 90, 85, "DefinitionBox",
  CellTags->"Visual"],
Cell[417174, 9283, 66, 1, 15, "Caption",
  CellTags->"Visual"],
Cell[417243, 9286, 146, 5, 29, "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{
Cell[417414, 9295, 108, 3, 26, "Input",
  CellTags->"Visual"],
Cell[417525, 9300, 85, 3, 20, "Output",
  CellTags->"Visual"]
}, Open  ]],
Cell[417625, 9306, 429, 9, 85, "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{
Cell[418079, 9319, 178, 4, 42, "Input",
  CellTags->"Visual"],
Cell[418260, 9325, 111, 3, 20, "Output",
  CellTags->"Visual"]
}, Open  ]],
Cell[418386, 9331, 168, 5, 29, "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{
Cell[418579, 9340, 132, 3, 26, "Input",
  CellTags->"Visual"],
Cell[418714, 9345, 249, 4, 50, "Print",
  CellTags->"Visual"],
Cell[418966, 9351, 65298, 1908, 151, 22736, 1376, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Visual"]
}, Open  ]],
Cell[484279, 11262, 189, 7, 29, "MathCaption",
  CellTags->"Visual"],

Cell[CellGroupData[{
Cell[484493, 11273, 174, 4, 42, "Input",
  CellTags->"Visual"],
Cell[484670, 11279, 303, 5, 54, "Print",
  CellTags->"Visual"],
Cell[484976, 11286, 65303, 1908, 151, 22742, 1376, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Visual"]
}, Open  ]],
Cell[550294, 13197, 189, 7, 36, "Subsection",
  Evaluatable->False,
  CellTags->{"How", "i:13"}],
Cell[550486, 13206, 670, 20, 66, "Text",
  CellTags->"How"],
Cell[551159, 13228, 147, 5, 29, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[551331, 13237, 93, 3, 26, "Input",
  CellTags->"How"],
Cell[551427, 13242, 83, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[551525, 13248, 2368, 66, 86, "DefinitionBox",
  CellTags->"How"],
Cell[553896, 13316, 59, 1, 15, "Caption",
  CellTags->"How"],
Cell[553958, 13319, 229, 7, 44, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[554212, 13330, 100, 3, 26, "Input",
  CellTags->"How"],
Cell[554315, 13335, 82, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[554412, 13341, 189, 5, 43, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[554626, 13350, 81, 3, 26, "Input",
  CellTags->"How"],
Cell[554710, 13355, 139, 4, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[554864, 13362, 269, 9, 44, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[555158, 13375, 112, 3, 26, "Input",
  CellTags->"How"],
Cell[555273, 13380, 121, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[555409, 13386, 489, 13, 72, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[555923, 13403, 119, 3, 26, "Input",
  CellTags->"How"],
Cell[556045, 13408, 131, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[556191, 13414, 151, 5, 29, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[556367, 13423, 81, 3, 26, "Input",
  CellTags->"How"],
Cell[556451, 13428, 121, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[556587, 13434, 133, 5, 29, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[556745, 13443, 93, 3, 26, "Input",
  CellTags->"How"],
Cell[556841, 13448, 82, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[556938, 13454, 195, 6, 44, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[557158, 13464, 101, 3, 26, "Input",
  CellTags->"How"],
Cell[557262, 13469, 83, 3, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[557360, 13475, 184, 7, 29, "MathCaption",
  CellTags->"How"],

Cell[CellGroupData[{
Cell[557569, 13486, 117, 3, 26, "Input",
  CellTags->"How"],
Cell[557689, 13491, 142, 4, 20, "Output",
  CellTags->"How"]
}, Open  ]],
Cell[557846, 13498, 497, 21, 53, "Text",
  CellTags->"How"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

