(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    889169,      21243]*)
(*NotebookOutlinePosition[    917736,      21984]*)
(*  CellTagsIndexPosition[    916778,      21947]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Chapter 2",
    FontSize->18],
  "\n",
  StyleBox["Groupoids",
    FontFamily->"Courier"]
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  CellTags->"FormGroupoid"],

Cell["2.0 Read me first", "Subsection",
  CellTags->"First"],

Cell[TextData[{
  "To evaluate any of the ",
  StyleBox["Input", "MR"],
  " cells in this chapter, the following cell should be evaluated first."
}], "Text",
  CellTags->"First"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Master`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"First"],

Cell[TextData[{
  "Since we wish to focus on groups, we use the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function."
}], "Text",
  CellTags->"First"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Group]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"First"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"First"]
}, Open  ]],

Cell[TextData[{
  "2.1 Forming ",
  StyleBox["Groupoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "As we saw in ",
  ButtonBox["chapter 1",
    ButtonData:>{"How to form Structures", "How to form Structures"},
    ButtonStyle->"AddOnsLink"],
  ", there are several means by which ",
  StyleBox["Groupoids", "MR"],
  " can be formed. Here we consider these methods in detail and consider all \
the available options."
}], "Text",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FormGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(use\ when\ the\ list\ of\ elements\ and\ the\ operation\ are\ 
                known\),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["GenerateGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "gens", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(use\ when\ a\ list\ of\ generators\ and\ the\ operation\ are\ 
                known\),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["FormGroupoidByTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"row1", 
                        StyleBox[",",
                          "MR"], " ", "row2", 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(use\ when\ the\ list\ of\ elements\ and\ the\ Cayley\ table\ 
                are\ known\),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["FormGroupoidFromCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], "cycles", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(use\ when\ a\ list\ of\ permutations\ written\ as\ cycles\ is
                \ known\),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["RandomGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["use",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["when",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["random",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["order",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["n",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["desired",
                    SingleLetterItalics->False], 
                  StyleBox[";",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["k",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["takes",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["on",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["value",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["from",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["1",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["to",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["3",
                      SingleLetterItalics->False]}]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(specifying\ the\ level\ of\ randomness\),
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"FormGroupoid", "i:1"}],

Cell[TextData[{
  "Methods of forming ",
  StyleBox["Groupoids",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "2.1.1 ",
  StyleBox["FormGroupoid",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->{"FormGroupoid", "i:2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FormGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Groupoid",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                StyleBox["els",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["op",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\<\"*\"\>",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["FormGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["sym",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Groupoid",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                StyleBox["els",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["op",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sym",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["FormGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Groupoid",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                StyleBox["els",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["op",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["given",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                SingleLetterItalics->False,
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["FormGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["sym",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Groupoid",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                StyleBox["els",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["op",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sym",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                SingleLetterItalics->False,
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "Variations in using ",
  StyleBox["FormGroupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "The syntax for the ",
  StyleBox["FormGroupoid", "MR"],
  " function requires the first parameter to be a list of elements and the \
second parameter to be the (binary) operation. An optional third parameter is \
used to indicate the symbol used to represent the operation; the default \
value is * if none is given. After these parameters, we can add a variety of \
options."
}], "Text",
  CellTags->"FormGroupoid"],

Cell["The third parameter is optional and defaults to *.", "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({OperatorSymbol[\ FormGroupoid[{2, \ 3}, \ Plus]], \n
      OperatorSymbol[\ FormGroupoid[{2, \ 3}, \ Plus, \ "\<+\>"]]}\)], "Input",\

  CellLabel->"In[3]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \({"*", "+"}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[\(default\ value\),
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["CayleyForm",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["OutputForm",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ how\ to\ format\ elements\ appearing\ in\ a\ Cayley
                \ table\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["FormatElements",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["displays",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["formats",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["them",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], " ", 
              StyleBox["\[Hyphen]Elements\[Hyphen]",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["FormatOperator",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["displays",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["formats",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["it",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\[Hyphen]Operation\[Hyphen]",
                "MR",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["Generators",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[\({}\),
                "StandardForm"],
              "Text"], 
            
            StyleBox[\(list\ of\ generators\ of\ the\ groupoid, \ 
              if\ known\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["GroupoidDescription",
                "StandardForm"],
              "Text"], 
            StyleBox["\"\<\>\"",
              "Text"], 
            StyleBox[\(brief\ description\ of\ the\ groupoid\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["GroupoidName",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["\"\<TheGroup\>\"",
                "StandardForm"],
              "Text"], 
            StyleBox[\(name\ of\ the\ groupoid, \ if\ available\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["IsAGroup",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["we",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["can",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["assume",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["group",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["KeyForm",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["InputForm",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["specifies",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["how",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["format",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["appearing",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["key",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cayley",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["formed",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["has",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["WideElements",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["set",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"]}]},
          {
            StyleBox[
              FormBox["MaxElementsToList",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["50",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ the\ number\ of\ elements\ to\ list\ before\ the\ 
                elements\ are\ automatically\ formatted\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["WideElements",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ whether\ the\ elements\ are\ \nconsidered\ too\ 
                wide\ to\ fit\ into\ a\ Cayley\ \ntable, \ 
              initiating\ a\ key\ to\ be\ set\ up\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.26, 0.2, 0.54},
  RowLines->{True, False}},
  CellTags->{"FormGroupoid", "i:3"}],

Cell[TextData[{
  "Options for ",
  StyleBox["FormGroupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "Typically, we want the elements of a groupoid formatted if there are too \
many elements to list or the elements themselves are large and take a lot of \
space to display. ",
  StyleBox["MaxElementsToList", "MR"],
  " handles the first problem and is illustrated later. When a groupoid is \
defined, we need to determine case by case whether the listing of the \
elements should be suppressed. In this example, we unnecessarily suppress the \
elements."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G1\  = \ 
      FormGroupoid[{2, 4, 6}, \ Plus, \ "\<+\>", \ 
        FormatElements\  \[Rule] \ True, \ FormatOperator\  \[Rule] \ False, 
        \ GroupoidName\  \[Rule] \ "\<ex. 1\>", \ 
        GroupoidDescription\  \[Rule] \ "\<illustrates suppressed elements\>"]
        \)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(Groupoid[{"-Elements-"}, Plus]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["InnerAutomorphismGroup", "MR"],
  " is used, the elements are usually formatted."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G2\  = \ InnerAutomorphismGroup[Dihedral[4]]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(Groupoid[{"-Elements-"}, "-Operation-"]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "We can always view the elements by using the ",
  StyleBox["Elements", "MR"],
  " function."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Elements[G2]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \({Morphoid["Conjugation by 1", "-D[4]-", "-D[4]-"], 
      Morphoid["Conjugation by Rot", "-D[4]-", "-D[4]-"], 
      Morphoid["Conjugation by Ref", "-D[4]-", "-D[4]-"], 
      Morphoid["Conjugation by Rot**Ref", "-D[4]-", "-D[4]-"]}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "Although ",
  StyleBox["FormatElements", "MR"],
  " defaults to ",
  StyleBox["False", "MR"],
  ", if the number of elements exceeds ",
  StyleBox["MaxElementsToList", "MR"],
  ", the list of elements is formatted. For some groups with wider elements \
(permutations, for example), it may be desirable to set the default value \
lower than 50."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell["{Z[50], Z[51]}", "Input",
  CellLabel->"In[7]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \({Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
          17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
          34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}, 
        Mod[#1 + #2, 50]&], Groupoid[{"-Elements-"}, Mod[#1 + #2, 51]&]}\)], 
  "Output",
  CellLabel->"Out[7]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Every ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " needs to be formed with at least a set of elements and an operation. \
Sometimes the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " representation of the binary operation conveys insight into how the \
operation works. For example, when we consider ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[", the operation is shown as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mod[#1 + #2, 5]&", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[". Even if we do not know that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["&", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " indicates that a pure function is being used and that #1 and #2 indicate \
locations for formal parameters, it should be fairly clear that we are \
combining two inputs under mod 5 addition.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell["Z[5]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&]\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  StyleBox["On the other hand, there are occasions where the actual ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " definition is only a distraction to understanding the operation. For \
example, consider the following direct product of the groups ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_4\)]],
  StyleBox[". Here the operation is suppressed.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell["G3 = DirectProduct[Z[5], U[4]]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(Groupoid[{{0, 1}, {0, 3}, {1, 1}, {1, 3}, {2, 1}, {2, 3}, {3, 1}, {3, 
          3}, {4, 1}, {4, 3}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "W can view the operation by using the ",
  StyleBox["Operation", "MR"],
  " function; it should be clear why the operation is suppressed in this \
case."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell["Operation[G3]", "Input",
  CellLabel->"In[10]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(MapThread[#1[#2, #3]&, {
          Operation/@{Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&], 
              Groupoid[{1, 3}, Mod[#1\ #2, 4]&]}, #1, #2}]&\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "By default, when a groupoid does not have ",
  StyleBox["WideElements", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  ", the actual elements appear in the body of the Cayley table (and are \
colored according to the elements listed on the top and left sides)."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[TextData["CayleyTable[G1, Mode \[Rule] Visual]"], "Input",
  CellLabel->"In[11]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \("For each element, a different color is used. The entries in the table \
corresponding to the elements are then colored and labeled accordingly."\)], 
  "Print",
  CellTags->"FormGroupoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 .5 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.56 .37 .6 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(4)] .38095 .62202 0 0 Mshowa
[(6)] .61905 .62202 0 0 Mshowa
[(8)] .85714 .62202 0 0 Mshowa
[(6)] .38095 .38393 0 0 Mshowa
[(8)] .61905 .38393 0 0 Mshowa
[(10)] .85714 .38393 0 0 Mshowa
[(8)] .38095 .14583 0 0 Mshowa
[(10)] .61905 .14583 0 0 Mshowa
[(12)] .85714 .14583 0 0 Mshowa
[(2)] .14286 .62202 0 0 Mshowa
[(4)] .14286 .38393 0 0 Mshowa
[(6)] .14286 .14583 0 0 Mshowa
[(2)] .38095 .86012 0 0 Mshowa
[(4)] .61905 .86012 0 0 Mshowa
[(6)] .85714 .86012 0 0 Mshowa
[(ex. 1)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  ImageSize->{256, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400040000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l00@000?l00@000?l00@000?l00@000?l0
0@000?l00@000?l00@0000H0lol700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?0000ol0000j0003o`0003T000?o00001@0000H0
03_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02oc`000?o0000>P000ol0000i0003o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_ll0003o`0003X000?o0000>@000ol0
000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o?0000ol0000j0003o`0003T000?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02oc`000?o0000>P000ol0
000i0003o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_ll0003o`0003X000?o0000>@000ol0000500001P00>omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?0000ol0
000j0003o`0003T000?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02oc`000?o0000>P000ol0000i0003o`0000D00006000k
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW40
0_ll0003o`0003X000?o0000>@000ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?0000ol0000j0003o`0003T000?o0000
1@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02oc`000?o0000>P000ol0000i0003o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_ll0003o`0003X000?o0000
>@000ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGia00;o?0000ol0000j0003o`0003T000?o00001@0000H003_om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02oc`000?o0000
>P000ol0000i0003o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_ll0003o`0003X000?o0000>@000ol0000500001P00>ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o
?0000ol0000j0003o`0003T000?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02oc`000?o0000>P000ol0000i0003o`0000D0
0006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_ll0003o`0003X000?o0000>@000ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?0000ol0000j0003o`0003T0
00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02oc`000?o0000>P000ol0000i0003o`0000D00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_ll0003o`0003X0
00?o0000>@000ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?0000ol0000j0003o`0003T000?o00001@0000H003_oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02oc`0
00?o0000>P000ol0000i0003o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_ll0003o`0003X000?o0000>@000ol000050000
1P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia00;o?0000ol0000j0003o`0003T000?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02oc`000?o0000>P000ol0000i0003
o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW400_ll0003o`0003X000?o0000>@000ol0000500001P00>oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?0000ol0000j0003
o`0003T000?o00001@0000H001goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`0LOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nL@;o7@02oad000?o00005P03o`@00_lK0003o`0001H00ol300Co
6@000ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7koO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_An00;o70001?l00?lL0003o`0001L000?o00000P001?l00?lJ0003o`0001L0
00?o00000`000ol0000I0003o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mn
LOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_lL0004o`00oa`000?o00005`000ol000020004
o`00oaX000?o00005`000ol000040003o`0001P000?o00001@0000H001com7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0ol07?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h2oad00_lM0003o`0001L0
00?o00000P001?l00?lJ0003o`0001L000?o00001@000ol0000G0003o`0000D00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_lL0004
o`00oa`000?o00005`000ol000020004o`00oaX000?o00005`000ol000020004o`00oaT000?o0000
1@0000H001gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP03o`0KO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o7@02oad000?o00005P02o`D00_lK0003o`0001H00_l500;o6P000ol000050000
1P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia00;o?0000ol0000j0003o`0003T000?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02oc`000?o0000>P000ol0000i0003
o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW400_ll0003o`0003X000?o0000>@000ol0000500001P00>oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?0000ol0000j0003
o`0003T000?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@02oc`000?o0000>P000ol0000i0003o`0000D00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_ll0003
o`0003X000?o0000>@000ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?0000ol0000j0003o`0003T000?o00001@0000H0
03_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02oc`000?o0000>P000ol0000i0003o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_ll0003o`0003X000?o0000>@000ol0
000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o?0000ol0000j0003o`0003T000?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02oc`000?o0000>P000ol0
000i0003o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_ll0003o`0003X000?o0000>@000ol0000500001P00>omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?0000ol0
000j0003o`0003T000?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02oc`000?o0000>P000ol0000i0003o`0000D00006000k
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW40
0_ll0003o`0003X000?o0000>@000ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?0000ol0000j0003o`0003T000?o0000
1@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02oc`000?o0000>P000ol0000i0003o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_ll0003o`0003X000?o0000
>@000ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGia00;o?0000ol0000j0003o`0003T000?o00001@0000H003_om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02oc`000?o0000
>P000ol0000i0003o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_ll0003o`0003X000?o0000>@000ol0000500001P00>ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o
?0000ol0000j0003o`0003T000?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02oc`000?o0000>P000ol0000i0003o`0000D0
0006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_ll0003o`0003X000?o0000>@000ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?0000ol0000j0003o`0003T0
00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02oc`000?o0000>P000ol0000i0003o`0000D000060??o1`0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0l0003o`0003T000?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0l0003o`0003T000?o00001@0000H001goWenOGimOWenOGimOWenOGimOWenOGimOWenOG`03o`0K
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o01enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OP02o`0NLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7002oah000?o00005P03o`@00_lJ0003
o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Com7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l06`001?l00?lM0003o`0001L000?o00000P001?l00?lI0003o`0000D0
0006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`Co01]OWenOGimOWenOGimOWenOGimOWenO
GimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGkoOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl06`001?l00?lM0003o`0001L000?o00000P001?l00?lI0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWonOoimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l07?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h3o`0NO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko7002oah000?o00005`000ol000020004o`00oaT000?o00001@0000H003_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOoiooWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`0mOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0K0004
o`00oad000?o00005`000ol000020004o`00oaT000?o00001@0000H001goWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0LWenOGimOWenOGimOWenOGimOWenOGimOWenOG`;o01gdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm003o`0Mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l07002oah0
00?o00005P02o`D00_lJ0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l0?0000ol0000i0003o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?0000ol0000i0003o`0000D000060??o
1`0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>`000ol000050000
1P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lk0003o`0000D000060003
omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc/000?o00001@0000H000?ogml0
>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>`000ol0000500001P000ooOg`0hg`;o
07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lk0003o`0000D000060003omoO03SO0_l0NYmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lk0003
o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc/000?o0000
1@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>`000ol000050000
1P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lk0003o`0000D000060003
omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc/000?o00001@0000H000?ogml0
>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>`000ol0000500001P000ooOg`0hg`;o
07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lk0003o`0000D000060003omoO03SO0_l0NYmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc/000?o00001@0000H000?ogml06Ml4oa_O0_l07ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00?o03VOGimOWenOGimOWenOGimOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l07002oad000?o00001@0000H000?ogml06]l00ooOg`0Kg`;o07ZOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaog5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noa/000Co003o70000ol0
000500001P000ooOg`0Kg`03omoO01[O0_l079mOWenOGimOWenOGimOWenOGimOWenOGimOWel4o`1J
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Co
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co6`001?l00?lL0003o`0000D000060003omoO01cO
00?ogml06Ml2o`1HWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@?o01maOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko01`00_lM0003o`0000D000060003omoO01WO00Cogmoo6ml2o`1jWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lK0004
o`00oa`000?o00001@0000H000?ogml06]l2oacO0_l07ImOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o03YOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0ol07WiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noa`00_lM0003o`0000D000060003
omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc/000?o00001@0000H000?ogml0
>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>`000ol0000500001P000ooOg`0hg`;o
07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lk0003o`0000D000060003omoO03SO0_l0NYmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lk0003
o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc/000?o0000
1@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>`000ol000050000
1P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lk0003o`0000D000060003
omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc/000?o00001@0000H000?ogml0
>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lk0003o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>`000ol0000500001P000ooOg`0hg`;o
07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lk0003o`0000D000060003omoO03SO0_l0NYmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc/000?o00001@0000H000?ogml0>=l2o`1jWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lk0003
o`0000D000060003omoO03SO0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>`000ol0000500001P000ooOg`0hg`;o07ZOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc/000?o0000
1@0000H000?ogml0>=l2o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lk0003o`0000D000050?Co1`0000D0m?l700001P000ol0000g00?o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H000?o0000=P001?l0oollg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000e0003o`0000;o?=l0N_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
1`0000H000?o0000=0001?l00002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0003<000?o00000P02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`00038000?o00000`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`00034000?o00001002occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`00030000?o00001@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0002l000?o00001P02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0002h000?o00001`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0002d000?o00002002occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0002`000?o00002@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0002/000?o00002P02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0002X000?o00002`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0002T000?o00003002occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0002P000?o00003@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000h00_l00`3oo`0D0003o`0000h0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000?0003o`3o01@000?o00003`02occO07[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`000100
00?o00004P000ol0000@00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00003`000ol0o`0B0003o`0001400_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol0000>00;o00<0ool040000ol0000B00;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00008P000ol0
000C00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1`0000H000?o00008@000ol0000D00;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o000080000ol0
000E00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1`0000H000?o00007`000ol0000F00;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00007P000ol0
000G00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1`0000H000?o00007@000ol0000H00;o7=l4oacO01goGimOWenOGimOWenOGimO
WenOGimOWenOGimOW`03o`0jWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nL@;o01inLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000L0003o`0001T00_lMg`03omoO01cO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001/000?o00006P02oakO00?ogml0
6ml07?mOWenOGimOWenOGimOWenOGimOWenOGimOWel4o`1JWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H000?o00006P000ol0000K00;o7ml00ooOg`0Jg`1IoenOGimOWenOGimOWenOGimO
WenOGimOWenOGomOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_@00ol07_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001T0
00?o00007002oacO00Cogmoo7=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooGomOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o000060000ol0000M00;o7Ml2oagO01goGimO
WenOGimOWenOGimOWenOGimOWenOGimOW`02o`0kGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00ol07GkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00L000060003o`0001L000?o00007P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0001H000?o00007`02occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`L000060003o`0001D000?o00008002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0001@000?o00008@02occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`L000060003o`0001<000?o00004@03o`h00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000B0003o`0001<0
00?o00003@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdo`L000060003o`00014000?o00005@000ol0000<00;o?=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H0
00?o000040000ol0000F0003o`0000`00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000?0003o`0001H000?o0?l0
3@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5no`L000060003o`0000h000?o00005`000ol0o`0=00;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o0000
3@000ol0000G00;o00<0ool03002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000`000?o0000:@02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060003o`0000/000?o0000:P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000X000?o0000:`02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060003o`0000T000?o0000;002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000P000?o0000;@02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060003o`0000L000?o0000;P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000H000?o0000;`02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060003o`0000D000?o0000<002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000@000?o0000<@02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060003o`0000<000?o0000<P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`00008000?o0000<`02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060005o`000?l0=P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060004o`00ocL00_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0o`0h00;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H00_li00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H0lol70000@@02okd0003o0040003o0040003o0040
003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040
003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040
003o0040003o0040003`00?o3@000?4000?o0000300000P01_l00`3oo`0300;o2@03okH00_l00`3o
o`0:0003o`0000P000?o00002`0000L000?o00000`000ol0o`0400;o2P000ol0002f0003o`3o00/0
00?o000020000ol0000;00001`05o`8000?o00003`000ol0002g0003o`0000P01Ol70003o`3o00`0
00070009o`000?l0o`3o010000?o0000]P000ol0o`0;0003o`0000L000?o0?l0300000P00ol0103o
o`02o`l000?o0000]@02o`030?oo00X000?o00001P02o`030?oo00/0000O00;og`000?l00@000?l0
0@000?l00@000001\
\>"],
  ImageRangeCache->{{{0, 255}, {287, 0}} -> {-1.10002, -0.113553, 0.0164708, 
  0.0164708}},
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \({{4, 6, 8}, {6, 8, 10}, {8, 10, 12}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "When direct products are formed, the option ",
  StyleBox["WideElements \[Rule] True", "MR"],
  " is automatically added, which causes a key to be used when ",
  StyleBox["CayleyTable", "MR"],
  " is called."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[TextData["CayleyTable[G3, Mode \[Rule] Visual];"], "Input",
  CellLabel->"In[12]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \("KEY for Z[5] x U[4]: label used \[Rule] element: {g1 \[Rule] {0, 1}, \
g2 \[Rule] {0, 3}, g3 \[Rule] {1, 1}, g4 \[Rule] {1, 3}, g5 \[Rule] {2, 1}, \
g6 \[Rule] {2, 3}, g7 \[Rule] {3, 1}, g8 \[Rule] {3, 3}, g9 \[Rule] {4, 1}, \
g10 \[Rule] {4, 3}}"\)], "Print",
  CellTags->"FormGroupoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.04545 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.11039 0.0865801 0.0248918 0.0865801 [
[ 0 0 0 0 ]
[ 1 1.04545 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04545 L
0 1.04545 L
closepath
clip
newpath
1 1 0 r
.11039 .80411 m
.11039 .89069 L
.19697 .89069 L
.19697 .80411 L
F
.19697 .71753 m
.19697 .80411 L
.28355 .80411 L
.28355 .71753 L
F
.80303 .63095 m
.80303 .71753 L
.88961 .71753 L
.88961 .63095 L
F
.88961 .54437 m
.88961 .63095 L
.97619 .63095 L
.97619 .54437 L
F
.62987 .45779 m
.62987 .54437 L
.71645 .54437 L
.71645 .45779 L
F
.71645 .37121 m
.71645 .45779 L
.80303 .45779 L
.80303 .37121 L
F
.45671 .28463 m
.45671 .37121 L
.54329 .37121 L
.54329 .28463 L
F
.54329 .19805 m
.54329 .28463 L
.62987 .28463 L
.62987 .19805 L
F
.28355 .11147 m
.28355 .19805 L
.37013 .19805 L
.37013 .11147 L
F
.37013 .02489 m
.37013 .11147 L
.45671 .11147 L
.45671 .02489 L
F
1 .5 0 r
.19697 .80411 m
.19697 .89069 L
.28355 .89069 L
.28355 .80411 L
F
.11039 .71753 m
.11039 .80411 L
.19697 .80411 L
.19697 .71753 L
F
.88961 .63095 m
.88961 .71753 L
.97619 .71753 L
.97619 .63095 L
F
.80303 .54437 m
.80303 .63095 L
.88961 .63095 L
.88961 .54437 L
F
.71645 .45779 m
.71645 .54437 L
.80303 .54437 L
.80303 .45779 L
F
.62987 .37121 m
.62987 .45779 L
.71645 .45779 L
.71645 .37121 L
F
.54329 .28463 m
.54329 .37121 L
.62987 .37121 L
.62987 .28463 L
F
.45671 .19805 m
.45671 .28463 L
.54329 .28463 L
.54329 .19805 L
F
.37013 .11147 m
.37013 .19805 L
.45671 .19805 L
.45671 .11147 L
F
.28355 .02489 m
.28355 .11147 L
.37013 .11147 L
.37013 .02489 L
F
.56 .37 .6 r
.28355 .80411 m
.28355 .89069 L
.37013 .89069 L
.37013 .80411 L
F
.37013 .71753 m
.37013 .80411 L
.45671 .80411 L
.45671 .71753 L
F
.11039 .63095 m
.11039 .71753 L
.19697 .71753 L
.19697 .63095 L
F
.19697 .54437 m
.19697 .63095 L
.28355 .63095 L
.28355 .54437 L
F
.80303 .45779 m
.80303 .54437 L
.88961 .54437 L
.88961 .45779 L
F
.88961 .37121 m
.88961 .45779 L
.97619 .45779 L
.97619 .37121 L
F
.62987 .28463 m
.62987 .37121 L
.71645 .37121 L
.71645 .28463 L
F
.71645 .19805 m
.71645 .28463 L
.80303 .28463 L
.80303 .19805 L
F
.45671 .11147 m
.45671 .19805 L
.54329 .19805 L
.54329 .11147 L
F
.54329 .02489 m
.54329 .11147 L
.62987 .11147 L
.62987 .02489 L
F
0 0 1 r
.37013 .80411 m
.37013 .89069 L
.45671 .89069 L
.45671 .80411 L
F
.28355 .71753 m
.28355 .80411 L
.37013 .80411 L
.37013 .71753 L
F
.19697 .63095 m
.19697 .71753 L
.28355 .71753 L
.28355 .63095 L
F
.11039 .54437 m
.11039 .63095 L
.19697 .63095 L
.19697 .54437 L
F
.88961 .45779 m
.88961 .54437 L
.97619 .54437 L
.97619 .45779 L
F
.80303 .37121 m
.80303 .45779 L
.88961 .45779 L
.88961 .37121 L
F
.71645 .28463 m
.71645 .37121 L
.80303 .37121 L
.80303 .28463 L
F
.62987 .19805 m
.62987 .28463 L
.71645 .28463 L
.71645 .19805 L
F
.54329 .11147 m
.54329 .19805 L
.62987 .19805 L
.62987 .11147 L
F
.45671 .02489 m
.45671 .11147 L
.54329 .11147 L
.54329 .02489 L
F
.74 .99 .79 r
.45671 .80411 m
.45671 .89069 L
.54329 .89069 L
.54329 .80411 L
F
.54329 .71753 m
.54329 .80411 L
.62987 .80411 L
.62987 .71753 L
F
.28355 .63095 m
.28355 .71753 L
.37013 .71753 L
.37013 .63095 L
F
.37013 .54437 m
.37013 .63095 L
.45671 .63095 L
.45671 .54437 L
F
.11039 .45779 m
.11039 .54437 L
.19697 .54437 L
.19697 .45779 L
F
.19697 .37121 m
.19697 .45779 L
.28355 .45779 L
.28355 .37121 L
F
.80303 .28463 m
.80303 .37121 L
.88961 .37121 L
.88961 .28463 L
F
.88961 .19805 m
.88961 .28463 L
.97619 .28463 L
.97619 .19805 L
F
.62987 .11147 m
.62987 .19805 L
.71645 .19805 L
.71645 .11147 L
F
.71645 .02489 m
.71645 .11147 L
.80303 .11147 L
.80303 .02489 L
F
.251 .878 .816 r
.54329 .80411 m
.54329 .89069 L
.62987 .89069 L
.62987 .80411 L
F
.45671 .71753 m
.45671 .80411 L
.54329 .80411 L
.54329 .71753 L
F
.37013 .63095 m
.37013 .71753 L
.45671 .71753 L
.45671 .63095 L
F
.28355 .54437 m
.28355 .63095 L
.37013 .63095 L
.37013 .54437 L
F
.19697 .45779 m
.19697 .54437 L
.28355 .54437 L
.28355 .45779 L
F
.11039 .37121 m
.11039 .45779 L
.19697 .45779 L
.19697 .37121 L
F
.88961 .28463 m
.88961 .37121 L
.97619 .37121 L
.97619 .28463 L
F
.80303 .19805 m
.80303 .28463 L
.88961 .28463 L
.88961 .19805 L
F
.71645 .11147 m
.71645 .19805 L
.80303 .19805 L
.80303 .11147 L
F
.62987 .02489 m
.62987 .11147 L
.71645 .11147 L
.71645 .02489 L
F
0 .79 .34 r
.62987 .80411 m
.62987 .89069 L
.71645 .89069 L
.71645 .80411 L
F
.71645 .71753 m
.71645 .80411 L
.80303 .80411 L
.80303 .71753 L
F
.45671 .63095 m
.45671 .71753 L
.54329 .71753 L
.54329 .63095 L
F
.54329 .54437 m
.54329 .63095 L
.62987 .63095 L
.62987 .54437 L
F
.28355 .45779 m
.28355 .54437 L
.37013 .54437 L
.37013 .45779 L
F
.37013 .37121 m
.37013 .45779 L
.45671 .45779 L
.45671 .37121 L
F
.11039 .28463 m
.11039 .37121 L
.19697 .37121 L
.19697 .28463 L
F
.19697 .19805 m
.19697 .28463 L
.28355 .28463 L
.28355 .19805 L
F
.80303 .11147 m
.80303 .19805 L
.88961 .19805 L
.88961 .11147 L
F
.88961 .02489 m
.88961 .11147 L
.97619 .11147 L
.97619 .02489 L
F
0 .392 0 r
.71645 .80411 m
.71645 .89069 L
.80303 .89069 L
.80303 .80411 L
F
.62987 .71753 m
.62987 .80411 L
.71645 .80411 L
.71645 .71753 L
F
.54329 .63095 m
.54329 .71753 L
.62987 .71753 L
.62987 .63095 L
F
.45671 .54437 m
.45671 .63095 L
.54329 .63095 L
.54329 .54437 L
F
.37013 .45779 m
.37013 .54437 L
.45671 .54437 L
.45671 .45779 L
F
.28355 .37121 m
.28355 .45779 L
.37013 .45779 L
.37013 .37121 L
F
.19697 .28463 m
.19697 .37121 L
.28355 .37121 L
.28355 .28463 L
F
.11039 .19805 m
.11039 .28463 L
.19697 .28463 L
.19697 .19805 L
F
.88961 .11147 m
.88961 .19805 L
.97619 .19805 L
.97619 .11147 L
F
.80303 .02489 m
.80303 .11147 L
.88961 .11147 L
.88961 .02489 L
F
1 .753 .796 r
.80303 .80411 m
.80303 .89069 L
.88961 .89069 L
.88961 .80411 L
F
.88961 .71753 m
.88961 .80411 L
.97619 .80411 L
.97619 .71753 L
F
.62987 .63095 m
.62987 .71753 L
.71645 .71753 L
.71645 .63095 L
F
.71645 .54437 m
.71645 .63095 L
.80303 .63095 L
.80303 .54437 L
F
.45671 .45779 m
.45671 .54437 L
.54329 .54437 L
.54329 .45779 L
F
.54329 .37121 m
.54329 .45779 L
.62987 .45779 L
.62987 .37121 L
F
.28355 .28463 m
.28355 .37121 L
.37013 .37121 L
.37013 .28463 L
F
.37013 .19805 m
.37013 .28463 L
.45671 .28463 L
.45671 .19805 L
F
.11039 .11147 m
.11039 .19805 L
.19697 .19805 L
.19697 .11147 L
F
.19697 .02489 m
.19697 .11147 L
.28355 .11147 L
.28355 .02489 L
F
.678 .847 .902 r
.88961 .80411 m
.88961 .89069 L
.97619 .89069 L
.97619 .80411 L
F
.80303 .71753 m
.80303 .80411 L
.88961 .80411 L
.88961 .71753 L
F
.71645 .63095 m
.71645 .71753 L
.80303 .71753 L
.80303 .63095 L
F
.62987 .54437 m
.62987 .63095 L
.71645 .63095 L
.71645 .54437 L
F
.54329 .45779 m
.54329 .54437 L
.62987 .54437 L
.62987 .45779 L
F
.45671 .37121 m
.45671 .45779 L
.54329 .45779 L
.54329 .37121 L
F
.37013 .28463 m
.37013 .37121 L
.45671 .37121 L
.45671 .28463 L
F
.28355 .19805 m
.28355 .28463 L
.37013 .28463 L
.37013 .19805 L
F
.19697 .11147 m
.19697 .19805 L
.28355 .19805 L
.28355 .11147 L
F
.11039 .02489 m
.11039 .11147 L
.19697 .11147 L
.19697 .02489 L
F
1 1 0 r
.11039 .89069 m
.11039 .97727 L
.19697 .97727 L
.19697 .89069 L
F
1 .5 0 r
.19697 .89069 m
.19697 .97727 L
.28355 .97727 L
.28355 .89069 L
F
.56 .37 .6 r
.28355 .89069 m
.28355 .97727 L
.37013 .97727 L
.37013 .89069 L
F
0 0 1 r
.37013 .89069 m
.37013 .97727 L
.45671 .97727 L
.45671 .89069 L
F
.74 .99 .79 r
.45671 .89069 m
.45671 .97727 L
.54329 .97727 L
.54329 .89069 L
F
.251 .878 .816 r
.54329 .89069 m
.54329 .97727 L
.62987 .97727 L
.62987 .89069 L
F
0 .79 .34 r
.62987 .89069 m
.62987 .97727 L
.71645 .97727 L
.71645 .89069 L
F
0 .392 0 r
.71645 .89069 m
.71645 .97727 L
.80303 .97727 L
.80303 .89069 L
F
1 .753 .796 r
.80303 .89069 m
.80303 .97727 L
.88961 .97727 L
.88961 .89069 L
F
.678 .847 .902 r
.88961 .89069 m
.88961 .97727 L
.97619 .97727 L
.97619 .89069 L
F
1 1 0 r
.02381 .80411 m
.02381 .89069 L
.11039 .89069 L
.11039 .80411 L
F
1 .5 0 r
.02381 .71753 m
.02381 .80411 L
.11039 .80411 L
.11039 .71753 L
F
.56 .37 .6 r
.02381 .63095 m
.02381 .71753 L
.11039 .71753 L
.11039 .63095 L
F
0 0 1 r
.02381 .54437 m
.02381 .63095 L
.11039 .63095 L
.11039 .54437 L
F
.74 .99 .79 r
.02381 .45779 m
.02381 .54437 L
.11039 .54437 L
.11039 .45779 L
F
.251 .878 .816 r
.02381 .37121 m
.02381 .45779 L
.11039 .45779 L
.11039 .37121 L
F
0 .79 .34 r
.02381 .28463 m
.02381 .37121 L
.11039 .37121 L
.11039 .28463 L
F
0 .392 0 r
.02381 .19805 m
.02381 .28463 L
.11039 .28463 L
.11039 .19805 L
F
1 .753 .796 r
.02381 .11147 m
.02381 .19805 L
.11039 .19805 L
.11039 .11147 L
F
.678 .847 .902 r
.02381 .02489 m
.02381 .11147 L
.11039 .11147 L
.11039 .02489 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02489 m
.02381 .97727 L
s
.02381 .02489 m
.97619 .02489 L
s
.02381 .11147 m
.97619 .11147 L
s
.02381 .19805 m
.97619 .19805 L
s
.02381 .28463 m
.97619 .28463 L
s
.02381 .37121 m
.97619 .37121 L
s
.02381 .45779 m
.97619 .45779 L
s
.02381 .54437 m
.97619 .54437 L
s
.02381 .63095 m
.97619 .63095 L
s
.02381 .71753 m
.97619 .71753 L
s
.02381 .80411 m
.97619 .80411 L
s
.02381 .89069 m
.97619 .89069 L
s
.02381 .97727 m
.97619 .97727 L
s
.11039 .02489 m
.11039 .97727 L
s
.19697 .02489 m
.19697 .97727 L
s
.28355 .02489 m
.28355 .97727 L
s
.37013 .02489 m
.37013 .97727 L
s
.45671 .02489 m
.45671 .97727 L
s
.54329 .02489 m
.54329 .97727 L
s
.62987 .02489 m
.62987 .97727 L
s
.71645 .02489 m
.71645 .97727 L
s
.80303 .02489 m
.80303 .97727 L
s
.88961 .02489 m
.88961 .97727 L
s
.97619 .02489 m
.97619 .97727 L
s
.02381 .97727 m
.11039 .89069 L
s
2.6 Mabswid
.11039 .02489 m
.11039 .97727 L
s
.02381 .89069 m
.97619 .89069 L
s
[(g1)] .15368 .8474 0 0 Mshowa
[(g2)] .24026 .8474 0 0 Mshowa
[(g3)] .32684 .8474 0 0 Mshowa
[(g4)] .41342 .8474 0 0 Mshowa
[(g5)] .5 .8474 0 0 Mshowa
[(g6)] .58658 .8474 0 0 Mshowa
[(g7)] .67316 .8474 0 0 Mshowa
[(g8)] .75974 .8474 0 0 Mshowa
[(g9)] .84632 .8474 0 0 Mshowa
[(g10)] .9329 .8474 0 0 Mshowa
[(g2)] .15368 .76082 0 0 Mshowa
[(g1)] .24026 .76082 0 0 Mshowa
[(g4)] .32684 .76082 0 0 Mshowa
[(g3)] .41342 .76082 0 0 Mshowa
[(g6)] .5 .76082 0 0 Mshowa
[(g5)] .58658 .76082 0 0 Mshowa
[(g8)] .67316 .76082 0 0 Mshowa
[(g7)] .75974 .76082 0 0 Mshowa
[(g10)] .84632 .76082 0 0 Mshowa
[(g9)] .9329 .76082 0 0 Mshowa
[(g3)] .15368 .67424 0 0 Mshowa
[(g4)] .24026 .67424 0 0 Mshowa
[(g5)] .32684 .67424 0 0 Mshowa
[(g6)] .41342 .67424 0 0 Mshowa
[(g7)] .5 .67424 0 0 Mshowa
[(g8)] .58658 .67424 0 0 Mshowa
[(g9)] .67316 .67424 0 0 Mshowa
[(g10)] .75974 .67424 0 0 Mshowa
[(g1)] .84632 .67424 0 0 Mshowa
[(g2)] .9329 .67424 0 0 Mshowa
[(g4)] .15368 .58766 0 0 Mshowa
[(g3)] .24026 .58766 0 0 Mshowa
[(g6)] .32684 .58766 0 0 Mshowa
[(g5)] .41342 .58766 0 0 Mshowa
[(g8)] .5 .58766 0 0 Mshowa
[(g7)] .58658 .58766 0 0 Mshowa
[(g10)] .67316 .58766 0 0 Mshowa
[(g9)] .75974 .58766 0 0 Mshowa
[(g2)] .84632 .58766 0 0 Mshowa
[(g1)] .9329 .58766 0 0 Mshowa
[(g5)] .15368 .50108 0 0 Mshowa
[(g6)] .24026 .50108 0 0 Mshowa
[(g7)] .32684 .50108 0 0 Mshowa
[(g8)] .41342 .50108 0 0 Mshowa
[(g9)] .5 .50108 0 0 Mshowa
[(g10)] .58658 .50108 0 0 Mshowa
[(g1)] .67316 .50108 0 0 Mshowa
[(g2)] .75974 .50108 0 0 Mshowa
[(g3)] .84632 .50108 0 0 Mshowa
[(g4)] .9329 .50108 0 0 Mshowa
[(g6)] .15368 .4145 0 0 Mshowa
[(g5)] .24026 .4145 0 0 Mshowa
[(g8)] .32684 .4145 0 0 Mshowa
[(g7)] .41342 .4145 0 0 Mshowa
[(g10)] .5 .4145 0 0 Mshowa
[(g9)] .58658 .4145 0 0 Mshowa
[(g2)] .67316 .4145 0 0 Mshowa
[(g1)] .75974 .4145 0 0 Mshowa
[(g4)] .84632 .4145 0 0 Mshowa
[(g3)] .9329 .4145 0 0 Mshowa
[(g7)] .15368 .32792 0 0 Mshowa
[(g8)] .24026 .32792 0 0 Mshowa
[(g9)] .32684 .32792 0 0 Mshowa
[(g10)] .41342 .32792 0 0 Mshowa
[(g1)] .5 .32792 0 0 Mshowa
[(g2)] .58658 .32792 0 0 Mshowa
[(g3)] .67316 .32792 0 0 Mshowa
[(g4)] .75974 .32792 0 0 Mshowa
[(g5)] .84632 .32792 0 0 Mshowa
[(g6)] .9329 .32792 0 0 Mshowa
[(g8)] .15368 .24134 0 0 Mshowa
[(g7)] .24026 .24134 0 0 Mshowa
[(g10)] .32684 .24134 0 0 Mshowa
[(g9)] .41342 .24134 0 0 Mshowa
[(g2)] .5 .24134 0 0 Mshowa
[(g1)] .58658 .24134 0 0 Mshowa
[(g4)] .67316 .24134 0 0 Mshowa
[(g3)] .75974 .24134 0 0 Mshowa
[(g6)] .84632 .24134 0 0 Mshowa
[(g5)] .9329 .24134 0 0 Mshowa
[(g9)] .15368 .15476 0 0 Mshowa
[(g10)] .24026 .15476 0 0 Mshowa
[(g1)] .32684 .15476 0 0 Mshowa
[(g2)] .41342 .15476 0 0 Mshowa
[(g3)] .5 .15476 0 0 Mshowa
[(g4)] .58658 .15476 0 0 Mshowa
[(g5)] .67316 .15476 0 0 Mshowa
[(g6)] .75974 .15476 0 0 Mshowa
[(g7)] .84632 .15476 0 0 Mshowa
[(g8)] .9329 .15476 0 0 Mshowa
[(g10)] .15368 .06818 0 0 Mshowa
[(g9)] .24026 .06818 0 0 Mshowa
[(g2)] .32684 .06818 0 0 Mshowa
[(g1)] .41342 .06818 0 0 Mshowa
[(g4)] .5 .06818 0 0 Mshowa
[(g3)] .58658 .06818 0 0 Mshowa
[(g6)] .67316 .06818 0 0 Mshowa
[(g5)] .75974 .06818 0 0 Mshowa
[(g8)] .84632 .06818 0 0 Mshowa
[(g7)] .9329 .06818 0 0 Mshowa
[(g1)] .0671 .8474 0 0 Mshowa
[(g2)] .0671 .76082 0 0 Mshowa
[(g3)] .0671 .67424 0 0 Mshowa
[(g4)] .0671 .58766 0 0 Mshowa
[(g5)] .0671 .50108 0 0 Mshowa
[(g6)] .0671 .4145 0 0 Mshowa
[(g7)] .0671 .32792 0 0 Mshowa
[(g8)] .0671 .24134 0 0 Mshowa
[(g9)] .0671 .15476 0 0 Mshowa
[(g10)] .0671 .06818 0 0 Mshowa
[(g1)] .15368 .93398 0 0 Mshowa
[(g2)] .24026 .93398 0 0 Mshowa
[(g3)] .32684 .93398 0 0 Mshowa
[(g4)] .41342 .93398 0 0 Mshowa
[(g5)] .5 .93398 0 0 Mshowa
[(g6)] .58658 .93398 0 0 Mshowa
[(g7)] .67316 .93398 0 0 Mshowa
[(g8)] .75974 .93398 0 0 Mshowa
[(g9)] .84632 .93398 0 0 Mshowa
[(g10)] .9329 .93398 0 0 Mshowa
[(Z[5] x U[4])] .02381 1.02056 -1 0 Mshowa
gsave
.97619 1.02056 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05325 .91926 0 0 Mshowa
[(y)] .08874 .9513 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{275.438, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004C000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l050000?l050000?l050000?l050000?l0
50000?l050000?l0500000H0ool7o`L00006000Go`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0A`o>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[ooGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?oC4`05D`0MomaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka3_4>l@ka3_4>
l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@oj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00L00006000GooD?m@oe3oD?m@oe3oD?m@oe3oD?m@l00_l0AoD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJoI[mV_fJoI[mV_fKoGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?oC4`05D`0B?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FoaM@01Soh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X?l700001P005ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>00;o04L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJooenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03oda<01E<
07OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?
0`l33`<?0`l33`<?0on@D91@T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
o`0700001P005ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o04Oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
mOnoI[mV_fJoI[mV_fJoI[mV_fJoI[mVoenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03oda<01E<
04SoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3
eP?F0mH3eP?F0mH3e_lGD00Hon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o1`0000H001Oo3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cP02o`173lh?cPo>3lh?cPo>3lh?cPo>3lh?cPooi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_omOWenOGimOWenOGimOWenOGimOWenOGol05ml00om<C00EC01gog5nLGiaOW5nLGiaOW5nLGia
OW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@D91@
T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l01`0000H001Oom@oe3oD?m@oe
3oD?m@oe3oD?m@oe3`02o`17m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI_mOWenOGimOWenOGimOWenOGimOWenOGol05ml00om<C00EC018ogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo5e006?oP
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`L00006000Go`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0A`o>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[ooGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?oC4`05D`0MomaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka3_4>l@ka3_4>
l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@oj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00L000060005ooD?m@l00ol03`oe3oD?m@oe3oD?m@oe3`02o`04
m@oe3`?o01L?m@oe3oD?m@oe3oD?m@oeokmV_fJoIP03o`0EI[mV_fJoI[mV_fJoI_mOWenOGimO00?o
00iOWenOGimOWenOGimOo`OO0ol=g`03oda<00E<0ol=C007ogkdO_Anm003o`0Em7kdO_Anm7kdO_An
m?n`3[0>/0j`00?o01F`3[0>/0j`3[0>/0j`omH3eP?F0mH00ol03]H3eP?F0mH3eP?F0mKo1e03o`e@
00Soh:3PX>2Ph0?o00gPX>2Ph:3PX>2Ph:3o00L00006000Go`o>3lh?cPoo3lh?cPo>3lh?cPo>3lh0
0_l0A`o>3lh?cPoo3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi_oV_nJoi[oV_nJoi[ooGimOWenOGimO
WonOGimOWenOGimOWeoo00[O00?ogml02]l00om<C008C003oda<00Y<07OoLGiaOW5nLGiaog5nLGia
OW5nLGiaO_oa3_4>l@ka3_4>o`ka3_4>l@ka3_4>lOl33`<?0`l33`<?o`l33`<?0`l33`<?0on@D91@
T52@D91@oe2@D91@T52@D91@T?nPh:3PX>2Ph:3Pon2Ph:3PX>2Ph:3Po`0700001P001Ooe3oD?00Co
00Seoooom@oe3`;o00Ce3oD?0_l01?D?m@l4o`08mOooooD?m@l2o`0<m@oe3oGo_fJoI[mV1?l05;oo
oonoI[mV_fJoI_mOWenOGimO1?l00iooo`02o`08GimOWenOGol7g`Co00COoooo2=l00om<C005C0Co
0T`3o`M<00OoO_Anm7kd00Co01AnooooO_Anm7kdO_Co/0j`3[0>/0Co01@>/?oo3[0>/0j`3[3oeP?F
0mH3ePCo00d3oooo0mH3eP?F0mKo00M@1?l2D0;o25002?oPX>2Ph:3P1?l03:3Pon2Ph:3PX>2Po`L0
0006000Go`o>3ol?cPoo3lkocPo>3ol?c_o>3lh00_l0A`o>3ol?cPoo3lkocPo>3ol?c_o>3lh?onJo
i[oVonJoi_oV_nJookoV_nJoi[ooGimOWenOoimOWonOGomOWenOGimOWeoo00KO00GogmoOo`02g`03
omoO00OO00?oC4`014`01Om<C4co00=<00?oC4`01T`0MomaOW5nLOmaOW7oLGiaO_mnLGiaOW5noo4>
l@ka3_l>l@ko3_l>lOoa3_4>l@kao`<?0`l33ol?0`oo3`<?0ol33`<?0`l3oi1@T52@D?m@T53oD?m@
T?n@D91@T52@oj3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>3o00L00006000GooD?mOoe3oGom@oo3oD?mOoe
3ol?m@l00_l09?D?mOoe3oGom@oo3oD?mOoe3ol?m@oeokmV_fJookmV_onoIP?o021V_fJoI[mVoenO
GimOWonOGiooWenOoimOWenOGimOo`KO00GogmoOo`02g`03omoO00OO00?oC4`014`01_m<C4coC0Co
1d`0B?mnm7kdO_mnm7koO_Anm?odO_Anm7kdok0>/0j`3_l>/0ko3_l>/?n`3[0>/0j`omH3eP?F0ol3
eP?o0mH3e_oF0mH3eP?Fo`I@00OoD51@oe3o009@00?oD5001E006?oPX>2Ph:3oX>2Poj3PX?nPh:3P
X>2Po`L00006000Go`o>3ol?cPoo3lkocPo>3ol?c_o>3lh00_l0A`o>3ol?cPoo3lkocPo>3ol?c_o>
3lh?onJoi[oVonJoi_oVonJookoV_nJoi[ooGimOWenOoimOWonOGimOoenOGimOWeoo00KO00GogmoO
o`02g`03omoO00OO00?oC4`014`02Om<C4coC?m<o`08C00=og5nLGiaog5nLOmaOP02o`0ELGiaOW5n
LGkol@ka3_4>o`ka3_l>00?o01D>l@ka3_4>lOl33`<?0`oo3`<?o`l00ol05Pl33`<?0`l3oi1@T52@
D?m@T53oD902o`0PD91@T52@D93oX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph?l700001P001Ooe3oD?00Go
00d?o`oe3oGom@oo3oD?00;o00Ce3oD?1Ol05@oo3oD?mOoe3ol?m@oeokmV_fJoIP06o`0B_fKoI[mV
_fJoI_mOWenOGimO1_l02imOoenOGimOWeoo00OO1Ol00moog`08g`03oda<00E<1_l00dcoC007C007
ogkdO_Anm005o`0Cm7kdooAnm7kdO_Co/0j`3[0>/006o`0B3[0>/0j`3[0>/?oF0mH3eP?F1_l02`?F
0mH3eP?F0mKo00M@1_l2D003oe1@00E@00Soh:3PX>2Ph0Go00_PX>3oh:3PX>2Po`0700001P002_l?
cPo>3lh?cPl2o`05cPo>3lh00_l010o>3lh2o`093lh?cPo>3lh?00;o00G>3lh?cP02o`0B3lh?cPoo
i[oV_nJoi[oV_nJo0_l05^Joi[oV_nJooenOGimOWenOGimOWel2o`09WenOGimOWeoo00cO0_l9g`03
oda<00]<0_l8C00<og5nLGiaOW5nLGia0ol05W5nLGiaOW5noo4>l@ka3_4>l@ka3_43o`0Dl@ka3_4>
lOl33`<?0`l33`<?0`l4o`0E0`l33`<?0on@D91@T52@D91@T52@00;o01E@T52@D91@T?nPh:3PX>2P
h:3PX>001?l01j3PX>2Ph?l01`0000H001Oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3`02o`17m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oGo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_mOWenOGimOWenOGimOWenOGimO
WenOGol05ml00om<C00EC018ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo5e006?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`L0
0006000Go`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0A`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJo
i[oV_nJoi[oV_nJoi[oV_nJoi[ooGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?oC4`05D`0Moma
OW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?
0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00L0
0006000GooD?m@oe3oD?m@oe3oD?m@oe3oD?m@l00_l0AoD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV
_fJoI[mV_fJoI[mV_fJoI[mV_fKoGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?oC4`05D`0B?mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?FoaM@01Soh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l700001P005ol?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>00;o04L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJo
oenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03oda<01E<07OoLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0on@D91@T52@D91@
T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0700001P005ooe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?00;o04Oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?mOnoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
oenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03oda<01E<04SoO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_lGD00Hon2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3o1`0000H001Oo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cP02o`173lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPooi[oV_nJoi[oV_nJoi[oV_nJoi[oV_omOWenOGimOWenOGimOWenOGimO
WenOGol05ml00om<C00EC01gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?l01`0000H001Oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3`02o`17m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oGo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_mOWenOGimOWenOGimOWenOGimO
WenOGol05ml00om<C00EC018ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo5e006?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`L0
0006000Go`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0A`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJo
i[oV_nJoi[oV_nJoi[oV_nJoi[ooGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?oC4`05D`0Moma
OW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?
0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00L0
00060?oo1ol700001P005ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o02oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi_l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Gg`0aoenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0FC01Po`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@
D91@T53o1`0000H001Oo_fJoI[mV_fJoI[mV_fJoI[mV_fJoIP02o`0__fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol05ml0<OmOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05T`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l05U000ol0000500001P005ooV
_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o02oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>o`0Gg`0aoenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0FC01Po`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T53o1`0000H001Oo_fJo
I[mV_fJoI[mV_fJoI[mV_fJoIP02o`0__fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?
m@oe3oD?m@oe3ol05ml0<OmOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l05T`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oP
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l05U000ol0000500001P005ooV_nJoi[oV_nJoi[oV_nJoi[oV
_nJo00;o02oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Gg`0a
oenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0FC01Po`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T53o1`0000H001Oo_fJoI[mV_fJoI[mV_fJoI[mV_fJo
IP02o`0__fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol05ml0<OmO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05T`0BOoF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oPX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?l05U000ol0000500001P005ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o02oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Gg`0aoenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0FC01Po`<?0`l33`<?0`l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@
D91@T52@D91@T53o1`0000H000So_fJoI[mV_`?o00boI[mV_fJoI[mV_fH2o`07_fJoI[mV_`03o`0A
_fJoI[mV_fJoI[mV_ooe3oD00ol04OD?m@oe3oD?m@oe3oD?m@oo00OO0ol=g`08oenOGimOWel3o`0E
GimOWenOGimOWenOGomnm7kdO_An00?o00inm7kdO_Anm7kdO_Ano`I<0ol=C008omH3eP?F0mH3o`0E
eP?F0mH3eP?F0mH3e_n`3[0>/0j`00?o01F`3[0>/0j`3[0>/0j`on2Ph:3PX>000ol03^2Ph:3PX>2P
h:3PX>3o1e03o`a@00?o00001@0000H001Ooi[oV_nJoi[oV_onoi[oV_nJoi[oV_`02o`0_i[oV_nJo
i[oV_onoi[oV_nJoi[oV_nKo3lh?cPo>olh?cPo>3lh?cPo>3lh?c_l02]l00ooOg`0:g`0aoenOGimO
WenOGiooWenOGimOWenOGimOog5nLGiaOW5nLGkoOW5nLGiaOW5nLGiao`09C003oda<00Y<063o0`l3
3`<?0`l33ol?0`l33`<?0`l33`?ol@ka3_4>l@ka3_l>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph?oPX>2P
h:3PX>2Ph:3oT52@D91@T52@D?m@T52@D91@T52@D?l700001P002?noI[mV_fJo1?l02fKooomV_fJo
I[mV00;o00NoI[mV_fJo00Co011VooooI[mV_fJoI[oom@oe1?l020ooool?m@oe0_l01Poe3oD?o`OO
1?l01=ooool8g`08oenOGimOWel4o`03Wooo00;o00mOWenOGimOogkdO_Anm7h01?l03OCoooodO_An
m7kdO_l01T`4o`9<0ol7C008omH3eP?F0mH4o`0D0oooo`?F0mH3eP?Fok0>/0j`3[04o`0D3[3oo`j`
3[0>/0j`on2Ph:3PX>04o`0=X>3oh:3PX>2Ph:3Po`07D0Co0U02o`M@00?o00001@0000H001Ooi[oV
_nJookoV_onoi[oVonJoi[oV_`02o`0_i[oV_nJookoV_onoi[oVonJoi[oV_nKo3lkocPo>olh?o`o>
3lkocPoo3lh?c_l01]l01OoOgmoo00;O00?ogml01ml0<OmOWenOGiooWenOoimOoenOGimOWenOGoma
OW5nLGkoOW5nogiaOW7oLGiaOW5nLOl01D`01Om<C4co00=<00?oC4`01T`0H?l33`<?0`oo3`<?o`l3
3`?o0`l33`<?0ooa3_4>l@ko3_4>o`ko3_7ol@ka3_4>lOnPh:3PX>3oh:3Pon2Poj3PX>2Ph:3PX?n@
D91@T53oD91@oe3oD93oT52@D91@o`L00006000>okmV_fJoI_mV_fKoI[l3o`06_fJoI[mV0_l03KmV
_fJoI_mV_fKoI[l00ol07kmV_fJoI[oom@oo3oD?o`oeooD?m@oo3oGom@oe3ol01]l01OoOgmoo00;O
00?ogml01ml0<OmOWenOGiooWenOoimOWonOGimOWenOGomnm7kdO_Com7kdooAnm7koO_Anm7kdO_l0
1D`01_m<C4coC0Co1d`0BOoF0mH3eP?o0mH3o`?F0mKoeP?F0mH3e_n`3[0>/0ko3[0>o`ko3[3o/0j`
3[0>/?oPX>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph?l01U001om@D53oD?l00U000om@D004D003o`0000D0
0006000GonJoi[oV_onoi[oo_onoi_oV_nJoi[l00_l0;nJoi[oV_onoi[oo_onoi_oV_nJoi[oVo`o>
olh?c_o>3ol?cPo>olh?o`o>3lko00KO00GogmoOo`02g`03omoO00OO02KoGimOWenOoimOWonOGimO
oenOGimOWeooLGiaOW5nogiaO_mnL@;o00UnLGiaOW5nLOl01D`02Om<C4coC?m<o`08C00=o`<?0`l3
3ol?0`oo3`03o`0E3`<?0`l33`?ol@ka3_4>o`ka3_l>00?o02h>l@ka3_4>lOnPh:3PX>3oh:3Pon2P
h?oPX>2Ph:3PX?n@D91@T53oD91@oe2@0_l0252@D91@T53o1`0000H000So_fJoI[mV_`Ko00UV_ono
I[mV_fH00_l01kmV_fJoI[l01_l03VJookmV_fJoI[oom@oe1Ol03oGom@oe3ol?mOoe3oD?o`07g`Go
00?Ooml02=l02?mOWenOGimO1_l04YmOoenOGimOWeooO_Anm7kdOPGo00anm7koO_Anm7kdO_l6C0Ko
00=<od`01d`02?oF0mH3eP?F1_l04P?F0mH3eP?F0mKo/0j`3[0>/0Ko018>/0j`3[0>/0j`on2Ph:3P
X>05o`0<h:3Pon2Ph:3PX>3o1e06o`9@00?oD50015000ol0000500001P003_oV_nJoi[oV_nJoi[oV
0_l01koV_nJoi[l00_l03NJoi[oV_nJoi[oV_nH00_l04KoV_nJoi[oVo`o>3lh?cPo>00;o00D?cPo>
3`02o`06cPo>3lko3=l2o`WO00koGimOWenOGimOWenOG`;o01FOGimOWenOGomaOW5nLGiaOW5nLGh0
0ol02GiaOW5nLGiao`0<C0;o24`03Ol33`<?0`l33`<?0`l01?l05@<?0`l33`?ol@ka3_4>l@ka3_4>
l@03o`0Dl@ka3_4>lOnPh:3PX>2Ph:3PX>04o`0EX>2Ph:3PX?n@D91@T52@D91@T52@00;o00Q@T52@
D91@o`L00006000GokmV_fJoI[mV_fJoI[mV_fJoI[mV_fH00_l0;kmV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo01OO037oGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7ko01I<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01I@00?o00001@0000H001Ooi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_`02o`0_i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>
3lh?cPo>3lh?c_l05ml0<OmOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl05T`0H?l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@o`L00006000GokmV_fJo
I[mV_fJoI[mV_fJoI[mV_fH00_l0;kmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoooD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oo01OO037oGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01I<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01I@00?o00001@0000H001Ooi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_`02o`0_i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l05ml0<OmO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05T`0H?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?n@D91@T52@D91@T52@D91@T52@D91@o`L00006000GokmV_fJoI[mV_fJoI[mV_fJoI[mV_fH0
0_l0;kmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo01OO037oGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01I<04WoeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>3o01I@00?o00001@0000H001Ooi[oV_nJoi[oV_nJoi[oV_nJoi[oV_`02o`0_i[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l05ml0<OmOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05T`0H?l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@
D91@T52@D91@o`L00006000GokmV_fJoI[mV_fJoI[mV_fJoI[mV_fH00_l0;kmV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo01OO037oGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01I<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01I@00?o00001@0000H0
01Ooi[oV_nJoi[oV_nJoi[oV_nJoi[oV_`02o`0_i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>
3lh?cPo>3lh?cPo>3lh?c_l05ml0<OmOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl05T`0H?l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@o`L000060?oo
1ol700001P005on@D91@T52@D91@T52@D91@T52@D91@00;o07N@D91@T52@D91@T52@D91@T52@D91@
T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Polh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>okoV_nJoi[oV_nJo
i[oV_nJoi[oV_nJooenOGimOWenOGimOWenOGimOWenOGimOo`0Fg`03oda<01E<04SoOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l3
3ol700001P000om@D00DD0;o5e00H?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVoenOGimOWenOGimOWenOGimOWenOGimOoaKO
00?oC4`05D`0B?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`L00006000Goi1@T52@D91@T52@D91@T52@D91@T5000_l0Mi1@
T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3ocPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lko_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[ooGimOWenOGimOWenOGimOWenOGimOWeoo01KO
00?oC4`05D`0B?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl3
3`<?0`l33`<?0`l33`<?0`l33`<?o`L000060003oe1@01A@0_lGD01Pon2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@ooI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKoGimOWenO
GimOWenOGimOWenOGimOWeoo5]l00om<C00EC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1`0000H001OoT52@D91@T52@
D91@T52@D91@T52@D002o`1gT52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_noi[oV_nJoi[oV_nJoi[oV_nJoi[oV_omOWenOGimO
WenOGimOWenOGimOWenOGol05]l00om<C00EC018ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`oo1`0000H000?oD5005502oaM@
063oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3omV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI_mOWenOGimOWenOGimOWenOGimOWenOGolFg`03oda<01E<04Som7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0ol700001P005on@D91@T52@D91@T52@D91@T52@D91@00;o07N@D91@T52@D91@T52@D91@T52@D91@
T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Polh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>okoV_nJoi[oV_nJo
i[oV_nJoi[oV_nJooenOGimOWenOGimOWenOGimOWenOGimOo`0Fg`03oda<01E<04SoOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l3
3ol700001P000om@D005D0?o3502o`M@0ol=D007on2Ph:3PX003o`0BX>2Ph:3PX>2Ph:3PX?l?m@oe
0ol06?D?m@oe3oD?m@oe3oD?m@ooI[mV_fJoIP?o01EV_fJoI[mV_fJoI[mVoenOGimOWel00ol03UnO
GimOWenOGimOWeoo1]l3o`gO00?oC4`01D`3o`e<00Som7kdO_Anm0?o01GdO_Anm7kdO_Anm7kdok0>
/0j`3[000ol05K0>/0j`3[0>/0j`3[3oeP?F0mH3eP03o`0=eP?F0mH3eP?F0mH3o`0700001P005on@
D91@T52@D91@oe2@D91@T52@D91@00;o07N@D91@T52@D91@oe2@D91@T52@D91@T?nPh:3PX>2Ph:3o
X>2Ph:3PX>2Ph:3Polh?cPo>3lkocPo>3lh?cPo>3lh?cPo>okoV_nJoi[oV_nKoi[oV_nJoi[oV_nJo
oenOGimOWenOGiooWenOGimOWenOGimOo`09g`03omoO00[O00?oC4`024`00om<C00:C018ogiaOW5n
LGiaOW7oLGiaOW5nLGiaOW5noo4>l@ka3_4>l@ko3_4>l@ka3_4>l@kao`<?0`l33`<?0`oo3`<?0`l3
3`<?0`oo1`0000H000?oD5001E04o`9@0_l7D0;o1e04o`9@0_l8D007on2Ph:3PX004o`0Ah:3oX>2P
h:3PX>2Po`oe3oD01?l020ooool?m@oe0_l03@oe3oD?ofJoI[mV_fH01?l05;oooonoI[mV_fJoI_mO
WenOGimO1?l00iooo`02o`08GimOWenOGol6g`Co00COoooo2=l00om<C005C0Co0T`3o`M<00Som7kd
O_Anm0Co01AnooooO_Anm7kdO_Co/0j`3[0>/0Co01@>/?oo3[0>/0j`3[3oeP?F0mH3ePCo00`3oooo
0mH3eP?F0ol700001P005on@D91@T53oD91@oe3oD93oT52@D91@00;o07N@D91@T53oD91@oe3oD93o
T52@D91@T?nPh:3PX?nPh:3oX>3oh:3PX>2Ph:3Polh?c_o>3lkocPoo3lh?c_o>3ol?cPo>okoV_nJo
i_oV_nKoi[oV_onoi[oV_nJooenOGimOWonOGiooWeooGimOWenOGimOo`05g`05omoOgol00]l00ooO
g`07g`03oda<00A<00GoC4a<o`03C003oda<00I<04SoOW5nLGiaog5nLOmaOW5nogiaOW5nLGkol@ka
3_4>o`ka3_l>o`kaoo4>l@ka3_7o0`l33`<?o`l33ol?0`l3o`<?0`l33ol700001P000om@D004D007
oe1@D?m@o`02D003oe1@00A@0_l6D007oe1@D?m@o`02D003oe1@00E@03goh:3PX>3oh:3Pon2Ph?oP
X>2Ph:3PX?l?m@oo3oD?o`oeooD?m@oo3oGom@oe3omV_fJoI[oo_fJookmV00?o021V_fJoI[mVoenO
GimOWonOGiooWenOoimOWenOGimOo`GO00GogmoOo`02g`03omoO00OO00?oC4`014`01_m<C4coC0Co
1d`0B?odO_Anm7koO_AnogkdO_Com7kdO_Anm?n`3[0>/0ko3[0>o`ko3[3o/0j`3[0>/?oF0mH3eP?o
0mH3o`?F0mKoeP?F0mH3o`L00006000>oi1@T52@D?m@T53oD902o`07D91@T52@D002o`0=T52@D91@
oe2@D?m@T002o`1XD91@T52@D93oX>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph?o>3lkocPo>olh?o`o>3lko
cPoo3lh?c_noi[oV_nKoi[oVonKoi[oo_nJoi[oV_omOWenOGiooWenOoimOWeooGimOWenOGol5g`05
omoOgol00]l00ooOg`07g`03oda<00A<00WoC4a<odcoC?l024`03_mnLGiaOW7oLGiaog5n0_l05G5n
LGiaOW5noo4>l@ka3_l>l@ko3P03o`0E3_4>l@ka3_7o0`l33`<?o`l33ol?00?o00P?0`l33`<?o`L0
00060003oe1@00E@1_l2D003oe1@00A@0_l7D0Ko0U000om@D005D007on2Ph:3PX005o`0@X>2Poj3P
X>2Ph:3o3oD?m@Go01KeooD?m@oo3oGom@oe3omV_fJoI[mV1_l04[mVofJoI[mV_fKoGimOWenOG`Ko
00^OGomOWenOGimOo`06g`Go00?Ooml02=l00om<C005C0Ko00=<od`01d`02?odO_Anm7kd1Ol04oAn
m?odO_Anm7kdok0>/0j`3[001_l04Pj`3[0>/0j`3[3oeP?F0mH3ePKo00X3eP?F0mH3eP?o1`0000H0
00koT52@D91@T52@D91@T0;o00M@T52@D91@00;o00f@D91@T52@D91@T52@00;o01A@T52@D91@T?nP
h:3PX>2Ph:3PX0Co017PX>2Ph:3Polh?cPo>3lh?cP02o`053lh?cPl00_l04lh?cPo>okoV_nJoi[oV
_nJoi[l00_l05^Joi[oV_nJooenOGimOWenOGimOWel2o`09WenOGimOWeoo00_O0_l9g`03oda<00]<
0_l8C00=ogiaOW5nLGiaOW5nL@03o`0FLGiaOW5nLGkol@ka3_4>l@ka3_4>l@?o01Ca3_4>l@kao`<?
0`l33`<?0`l33`Co00L33`<?0`oo00L000060003oe1@01A@0_lGD01Pon2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@ooI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKoGimOWenO
GimOWenOGimOWenOGimOWeoo5]l00om<C00EC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1`0000H001OoT52@D91@T52@
D91@T52@D91@T52@D002o`1gT52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_noi[oV_nJoi[oV_nJoi[oV_nJoi[oV_omOWenOGimO
WenOGimOWenOGimOWenOGol05]l00om<C00EC018ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`oo1`0000H000?oD5005502oaM@
063oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3omV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI_mOWenOGimOWenOGimOWenOGimOWenOGolFg`03oda<01E<04Som7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0ol700001P005on@D91@T52@D91@T52@D91@T52@D91@00;o07N@D91@T52@D91@T52@D91@T52@D91@
T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Polh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>okoV_nJoi[oV_nJo
i[oV_nJoi[oV_nJooenOGimOWenOGimOWenOGimOWenOGimOo`0Fg`03oda<01E<04SoOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l3
3ol700001P000om@D00DD0;o5e00H?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVoenOGimOWenOGimOWenOGimOWenOGimOoaKO
00?oC4`05D`0B?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`L00006000Goi1@T52@D91@T52@D91@T52@D91@T5000_l0Mi1@
T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3ocPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lko_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[ooGimOWenOGimOWenOGimOWenOGimOWeoo01KO
00?oC4`05D`0B?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl3
3`<?0`l33`<?0`l33`<?0`l33`<?o`L000060003oe1@01A@0_lGD01Pon2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@ooI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKoGimOWenO
GimOWenOGimOWenOGimOWeoo5]l00om<C00EC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1`0000H001OoT52@D91@T52@
D91@T52@D91@T52@D002o`1gT52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_noi[oV_nJoi[oV_nJoi[oV_nJoi[oV_omOWenOGimO
WenOGimOWenOGimOWenOGol05]l00om<C00EC018ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`oo1`0000H0ool7o`L00006000G
oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>000_l0Gj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@
T52@D91@T52@D91@T53o_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oocPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lko01OO033oGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lGC00`
o`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1`0000H001Ooh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX002o`0Hh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o5U00<OmV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI_l?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol05ml0<?mOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaM<033oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l700001P005onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P00;o
05nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@okoV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoolh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Gg`0`oenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko5d`0<?l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`L00006000Gon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:000_l06>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoaI@037oI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oo01OO033oGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lGC00`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
1`0000H001OoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph002o`1OX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o
T52@D91@T52@D91@T52@D91@T52@D?noi[oV_nJoi[oV_nJoi[oV_nJoi[oV_oo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?c_l05ml0<?mOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noaM<033o0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l70000
1P005ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P00;o01SPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?lFD00a
ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVo`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Gg`0`oenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co5d`0<?oF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`L00006000Goj3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>000_l0Gj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T53o_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko01OO033oGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lGC00`o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1`0000H000Soh:3PX>2Ph0?o00cPX>2Ph:3PX>2P
h:02o`07h:3PX>2Ph003o`0>h:3PX>2Ph:3PX>2Ph?l6D0?o3E002?mV_fJoI[mV0ol04VJoI[mV_fJo
I[mV_fKo3oD?m@?o017e3oD?m@oe3oD?m@oe3oD?o`07g`?o3Ml01omOWenOGil00ol05ImOWenOGimO
WenOGioom7kdO_Anm003o`0>m7kdO_Anm7kdO_Anm?l7C0?o3D`02?oF0mH3eP?F0ol05MH3eP?F0mH3
eP?F0mKo/0j`3[0>/003o`0=/0j`3[0>/0j`3[0>o`0700001P005onPh:3PX>2Ph:3Pon2Ph:3PX>2P
h:3P00;o05nPh:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX?n@D91@T52@D93oT52@D91@T52@D91@okoV_nJo
i[oV_nKoi[oV_nJoi[oV_nJoolh?cPo>3lkocPo>3lh?cPo>3lh?cPo>o`0:g`03omoO00[O033oGimO
WenOGimOoenOGimOWenOGimOWomnLGiaOW5nLGiaog5nLGiaOW5nLGiaO_l:C003oda<00Y<033o0`l3
3`<?0`l33ol?0`l33`<?0`l33`?ol@ka3_4>l@ka3_l>l@ka3_4>l@ka3_l700001P002?oPX>2Ph:3P
1?l02j3Pon2Ph:3PX>2P00;o00OPX>2Ph:3P00Co00fPh?oPX>2Ph:3PX>3o00I@1?l2D0;o25002?mV
_fJoI[mV1?l04KoooonoI[mV_fJoI_l?m@oe00Co00P?oooo3oD?m@;o00H?m@oe3ol7g`Co00COoooo
2=l01omOWenOGil01?l00eooo`02o`0?WenOGimOWoodO_Anm7kd00Co00enooooO_Anm7kdO_Co00M<
1?l2C0?o1d`02?oF0mH3eP?F1?l050?oool3eP?F0mH3e_n`3[0>/0j`1?l030j`ool>/0j`3[0>o`L0
0006000Goj3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>000_l0Gj3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>2Poi1@
T52@oi1@T?n@oi1@oe2@D91@T53o_nJoi[oVonJoi_oV_nJookoV_nJoi[oocPo>olh?c_o>3ol?cPo>
olh?o`o>3lko00KO00GogmoOo`02g`03omoO00OO033oGimOWeooGimOoenOoimOWenOGimOWomnLGia
OW7oLGiaog5nLGkoOW5nLGiaO_l6C005oda<C?l00d`00om<C006C00`o`<?0`l33ol?0`oo3`<?0ol3
3`<?0`l3oo4>l@ka3_l>l@ko3_l>lOoa3_4>l@ko1`0000H001Ooh:3PX>2Poj3PX?nPh:3oX>2Ph:3P
X002o`0Hh:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>3o1E001om@D53oD?l00U000om@D005D00>ofJoI[mV
_onoI[oo_fH3o`0PI[mV_fJoI_l?m@oo3oD?o`oeooD?m@oo3oGom@oe3ol6g`05omoOgol00]l00ooO
g`07g`0`oenOGimOoenOGomOWeooGimOWenOGioom7kdO_AnogkdO_mnm7kdooAnm7kdO_Co1T`01_m<
C4coC0Co1d`0<?oF0mH3eP?o0mH3o`?F0mKoeP?F0mH3e_n`3[0>/0ko3[0>o`ko3[3o/0j`3[0>o`L0
0006000Goj3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>000_l09:3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>2Poi1@
T52@oi1@T?n@D0;o03V@D91@T52@D?noi[oV_nKoi[oVonKoi[oo_nJoi[oV_oo>3lkocPo>olh?o`o>
3lkocPoo3lh?c_l01]l01OoOgmoo00;O00?ogml01ml09OmOWenOGomOWeooGimOWonOGimOWenOogia
OW5nLOmaOW7oLGh00_l02G5nLGiaOW5no`06C009oda<C?m<odco00Q<00go0`l33`<?o`l33ol?00?o
01D?0`l33`<?0ooa3_4>l@ko3_4>o`h00ol020ka3_4>l@ko1`0000H000Soh:3PX>2Ph0Go00[PX>3o
h:3PX>2P0_l01n2Ph:3PX>001Ol03>2Ph?oPX>2Ph:3Po`I@1_l2D003oe1@00E@00SoI[mV_fJoIPKo
00noI_mV_fJoI[mVo`oe3oD01Ol03oGom@oe3ol?mOoe3oD?o`07g`Go00?Ooml02=l01omOWenOGil0
1_l04UnOoimOWenOGioom7kdO_Anm0Go00cdO_Com7kdO_Anm?l7C0Ko00=<od`01d`02?oF0mH3eP?F
1_l04P?F0mH3eP?F0mKo/0j`3[0>/0Ko00X>/0j`3[0>/0ko1`0000H000goX>2Ph:3PX>2Ph:3P00Co
00JPh:3PX>02o`0<X>2Ph:3PX>2Ph:3P1?l05:3PX>2Ph:3oT52@D91@T52@D91@0_l05Y1@T52@D91@
okoV_nJoi[oV_nJoi[l2o`0Bi[oV_nJoi[oocPo>3lh?cPo>0_l01@o>3lh?00;o00K>3lh?c_l<g`;o
2Ml03OmOWenOGimOWenOGil00_l05EnOGimOWenOogiaOW5nLGiaOW5nL@03o`09LGiaOW5nLGko00e<
0_l8C00=o`<?0`l33`<?0`l33`04o`0E0`l33`<?0ooa3_4>l@ka3_4>l@ka00?o00Oa3_4>l@ko00L0
0006000Gon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:000_l06>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoaI@
037oI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo01OO033oGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lGC00`omH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1`0000H001OoX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph002o`1OX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D?no
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l05ml0<?mOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaM<033o0`l33`<?0`l33`<?0`l3
3`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l700001P005ooPX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2P00;o01SPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?lFD00aofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
o`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Gg`0`oenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co5d`0<?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>o`L00006000Goj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>000_l0Gj3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T53o_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oocPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lko01OO033oGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lGC00`o`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ko1`0000H001Ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX002o`0Hh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>3o5U00<OmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol0
5ml0<?mOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaM<033oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l700001P005onPh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3P00;o05nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@
T52@D91@okoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoolh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Gg`0`
oenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko5d`0<?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`L00006000Gon2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:000_l06>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoaI@037oI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fKo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo01OO033oGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lGC00`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0ko1`0000H0ool7o`L00006000Gok0>/0j`3[0>/0j`3[0>/0j`3[0>/0h0
0_l0;k0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01M@063oX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@ooI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_onOGimOWenOGimOWenOGimOWenOGimOWolGg`03oda<01E<01Som7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_l700001P005ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o0:Ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?oe2@D91@T52@D91@T52@D91@T52@D91@on2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Polh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>okoV_nJoi[oV_nJoi[oV_nJo
i[oV_nKoWenOGimOWenOGimOWenOGimOWenOGioo5ml00om<C00EC00HogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o1`0000H001Oo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02o`0_/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol05e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3omV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimO
WenOGimOWenOoaOO00?oC4`05D`06?odO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`L00006000Goo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@h00_l0Y_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?
0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@T53oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3ocPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lko_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_nOGimOWenOGimOWenOGimO
WenOGimOWolGg`03oda<01E<01SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl700001P005on`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>00;o02n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`0GD01Poj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[ooWenOGimOWenOGimOWenOGimOWenOGioo5ml00om<C00EC00H
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7ko1`0000H001Ool@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02o`2V
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l33om@T52@D91@T52@D91@
T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_no
i[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOoaOO00?oC4`05D`06?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiao`L00006000Gok0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_l0;k0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01M@063oX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@ooI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_onOGimOWenOGimOWenOGimOWenOGimOWolGg`03oda<01E<01Som7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_l700001P002?oa3_4>l@ka0ol03?4>l@ka3_4>l@ka3P;o00Oa3_4>l@ka00?o01Ca3_4>l@ka3_4>
l@kao`<?0`l33`?o01D?0`l33`<?0`l33`<?oe2@D91@T5000ol05E2@D91@T52@D91@T53oh:3PX>2P
h003o`0Bh:3PX>2Ph:3PX>2Ph?o>3lh?0ol05`o>3lh?cPo>3lh?cPo>3lko_nJoi[oV00?o01GV_nJo
i[oV_nJoi[oVoimOWenOGil00ol03YmOWenOGimOWenOGioo1ml3o`gO00?oC4`01D`3o`e<00SoOW5n
LGiaOP?o00enLGiaOW5nLGiaOW7o00L00006000Gok0>/0j`3[0>/0ko3[0>/0j`3[0>/0h00_l0;k0>
/0j`3[0>/0ko3[0>/0j`3[0>/0j`omH3eP?F0mH3e_oF0mH3eP?F0mH3eP?o00Y@00?oD5002U00H?nP
h:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX?l?m@oe3oD?o`oe3oD?m@oe3oD?m@oe3omV_fJoI[mV_fKoI[mV
_fJoI[mV_fJooimOWenOGimOWeooGimOWenOGimOWenOo`[O00?ogml02]l00om<C008C003oda<00Y<
01Som7kdO_Anm7kdO_mnm7kdO_Anm7kdO_l700001P002?oa3_4>l@ka1?l02`kaool>l@ka3_4>00;o
00Oa3_4>l@ka00Co01<>lOoo3_4>l@ka3_7o0`l33`<?00Co01@3oooo0`l33`<?0`ooD91@T52@D0Co
01B@D?ooT52@D91@T53oh:3PX>2Ph0Co016Ph?oPX>2Ph:3PX>3ocPo>3`04o`08c_ooolh?cPl2o`0<
cPo>3lko_nJoi[oV1?l05;oooonoi[oV_nJoi_nOGimOWenO1?l00eooo`02o`08WenOGimOWol7g`Co
00COoooo2=l00om<C005C0Co0T`3o`M<00SoOW5nLGiaOPCo00aaooooLGiaOW5nLOl700001P005on`
3[0>/0ko3[0>o`ko3[3o/0j`3[0>00;o02n`3[0>/0ko3[0>o`ko3[3o/0j`3[0>/?oF0mH3e_oF0mKo
eP?F0ol3eP?F0mH3o`06D007oe1@D?m@o`02D003oe1@00E@063oX>2Ph:3Pon2Ph?oPX?nPh:3PX>2P
h:3o3oD?o`oe3ol?mOoe3oD?o`oeooD?m@ooI[mV_fKoI[mVofJoI[oo_fJoI[mV_onOGimOWeooGimO
oenOoimOWenOGimOWol6g`05omoOgol00]l00ooOg`07g`03oda<00A<00GoC4a<o`03C003oda<00I<
01Som7kdO_AnogkdO_mnm7kdooAnm7kdO_l700001P005ooa3_4>l@ko3_4>o`ko3_7ol@ka3_4>00;o
08?a3_4>l@ko3_4>o`ko3_7ol@ka3_4>lOl33`<?0ol33`?o0`l33ol?0`l33`<?oe2@D91@T?n@D93o
T?n@D?m@T52@D91@on2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3Polh?c_o>3lkocPoo3lh?c_o>3ol?cPo>
okoV_nJookoV_onoiP03o`0Pi[oV_nJoi_nOGimOWeooGimOoenOGomOWenOGimOWol6g`05omoOgol0
0]l00ooOg`07g`03oda<00A<00KoC4a<od`4o`M<01SoOW5nLGiaog5nLOmaOW5nogiaOW5nLOl70000
1P003On`3[0>/0ko3[0>o`h00ol01`j`3[0>/0h00_l03;0>/0j`3_l>/0ko3P?o01@>/0j`3[0>/?oF
0mH3e_oF0mKoeP?o00WF0mH3eP?F0ol01U001Om@D53o009@0_l8D01Poj3PX>2Ph?oPX>3oh:3Pon2P
h:3PX>2Po`oe3ol?m@oo3oGom@oe3ol?mOoe3oD?ofJoI[mVofJoI_mVofJookmV_fJoI[ooWenOGimO
oenOGomOWenOoimOWenOGioo1]l01OoOgmoo00;O00?ogml01ml00om<C004C009oda<C?m<odco00Q<
00kom7kdO_AnogkdO_mnm0;o00Qnm7kdO_Ano`L000060008oo4>l@ka3_46o`093_4>l@ka3_4>00;o
00Oa3_4>l@ka00Ko014>l@ka3_4>l@kao`<?0`l33`06o`0B0`l33`<?0`l33om@T52@D91@1_l04Y1@
oe2@D91@T53oh:3PX>2Ph0Go013PX>3oh:3PX>2Ph?o>3lh?1Ol05@oo3lh?c_o>3ol?cPo>okoV_nJo
iP06o`0B_nKoi[oV_nJoi_nOGimOWenO1_l02enOoimOWenOGioo00OO1Ol00moog`08g`03oda<00E<
1_l00dcoC007C008ogiaOW5nLGh5o`0;OW5nogiaOW5nLOl01`0000H000ko/0j`3[0>/0j`3[0>/0?o
00J`3[0>/0h2o`0=/0j`3[0>/0j`3[0>/003o`0C/0j`3[0>/?oF0mH3eP?F0mH3eP04o`080mH3eP?F
0ol=D0;o25003OnPh:3PX>2Ph:3PX>001?l04J3PX>2Ph:3o3oD?m@oe3oD?00;o00Ge3oD?m@02o`0B
3oD?m@ooI[mV_fJoI[mV_fJo0_l05VJoI[mV_fJooimOWenOGimOWenOGil2o`09GimOWenOGioo00cO
0_l9g`03oda<00]<0_l8C00=ooAnm7kdO_Anm7kdOP03o`08O_Anm7kdO_l700001P005ooa3_4>l@ka
3_4>l@ka3_4>l@ka3_4>00;o0:Ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?
0`l33`<?oe2@D91@T52@D91@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Polh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>okoV_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenOGimO
WenOGioo5ml00om<C00EC00HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o1`0000H001Oo/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3P02o`0_/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3
eP?F0ol05e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3omV
_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOoaOO00?oC4`05D`06?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Ano`L00006000Goo4>l@ka3_4>l@ka3_4>l@ka3_4>l@h00_l0Y_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@
T52@D91@T53oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3ocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi_nOGimOWenOGimOWenOGimOWenOGimOWolGg`03oda<01E<01SoOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOl700001P005on`3[0>/0j`3[0>/0j`3[0>/0j`3[0>00;o02n`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0GD01Poj3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Po`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[oo
WenOGimOWenOGimOWenOGimOWenOGioo5ml00om<C00EC00HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7ko
1`0000H001Ool@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02o`2Vl@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o
0`l33`<?0`l33`<?0`l33`<?0`l33om@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph?o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_noi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimO
WenOGimOWenOGimOWenOGimOWenOoaOO00?oC4`05D`06?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiao`L0
0006000Gok0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_l0;k0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?o01M@063oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@ooI[mV_fJoI[mV_fJoI[mV_fJoI[mV_onOGimOWenOGimOWenOGimOWenOGimO
WolGg`03oda<01E<01Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l700001P005ooa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>00;o0:Ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?
oe2@D91@T52@D91@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Polh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>okoV_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenOGimOWenOGioo
5ml00om<C00EC00HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o1`0000H001Oo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3P02o`0_/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0
5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3omV_fJoI[mV
_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOoaOO00?oC4`05D`06?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Ano`L000060?oo1ol700001P005ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o
04OF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Po`0GD00`ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVo`oe3oD?m@oe3oD?m@oe3oD?
m@oe3oGo5ml0<OnOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
5T`00ol0000500001P005ol33`<?0`l33`<?0`l33`<?0`l33`<?00;o08h33`<?0`l33`<?0`l33`<?
0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@
T52@D91@T52@D91@T52@D91@okoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoolh?cPo>3lh?cPo>3lh?cPo>
3lh?cPoo5ml0<OnOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
5T`00ol0000500001P005ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o04OF0mH3eP?F0mH3eP?F0mH3
eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`0GD00`
ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVo`oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo5ml0<OnOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l05T`00ol0000500001P005ol3
3`<?0`l33`<?0`l33`<?0`l33`<?00;o08h33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>
l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D91@
okoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoolh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo5ml0<OnOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l05T`00ol0000500001P005ooF
0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o04OF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`0GD00`ofJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mVo`oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo5ml0<OnOGimOWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l05T`00ol0000500001P005ol33`<?0`l33`<?0`l33`<?0`l3
3`<?00;o08h33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D91@okoV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoolh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo5ml0<OnOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l05T`00ol0000500001P005ooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH300;o04OF0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Po`0GD00`ofJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVo`oe3oD?m@oe3oD?
m@oe3oD?m@oe3oGo5ml0<OnOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l05T`00ol0000500001P002?l33`<?0`l30ol030<?0`l33`<?0`l33`;o00L33`<?0`l300?o
01@33`<?0`l33`<?0`l3oo4>l@ka3P?o01D>l@ka3_4>l@ka3_4>on2Ph:3PX>000ol05N2Ph:3PX>2P
h:3PX>3oD91@T52@D003o`0ED91@T52@D91@T52@D?noi[oV_nJo00?o016oi[oV_nJoi[oV_nJoolh?
cP03o`0AcPo>3lh?cPo>3lh?cPo>3ol01ml3o`gO00SoWenOGimOW`?o01FOGimOWenOGimOWenOogia
OW5nLGh00ol03WiaOW5nLGiaOW5nLGko1d`3o`a<00?o00001@0000H001OoeP?F0mH3eP?F0ol3eP?F
0mH3eP?F0`02o`17eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mKo/0j`3[0>/0j`ok0>/0j`3[0>/0j`3_nP
h:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX?l02U000om@D00:D00`ofJoI[mV_fJoI[oo_fJoI[mV_fJoI[mV
o`oe3oD?mOoe3oD?m@oe3oD?m@oe3oGo2]l00ooOg`0:g`0aoimOWenOGimOWeooGimOWenOGimOWenO
ooAnm7kdO_Anm7koO_Anm7kdO_Anm7kdo`0:C003oda<00U<00?o00001@0000H000So0`l33`<?0`Co
00/?oooo3`<?0`l33`02o`070`l33`<?0`04o`0C3oooo`l33`<?0`l3oo4>l@ka3P04o`0Dl@kooo4>
l@ka3_4>on2Ph:3PX>04o`0DX>3oh:3PX>2Ph:3Poe2@D91@T504o`0DT53ooi1@T52@D91@okoV_nJo
i[l4o`0@i_ooonJoi[oV_nJoolh?cPCo00P?oooo3lh?cP;o00H?cPo>3ol7g`Co00COoooo2=l02?nO
GimOWenO1?l00eooo`02o`0?WenOGimOWomnLGiaOW5n00Co00eaooooLGiaOW5nLGko00M<1?l2C0?o
1T`00ol0000500001P005ooF0mH3eP?o0mH3o`?F0mKoeP?F0mH300;o04OF0mH3eP?o0mH3o`?F0mKo
eP?F0mH3e_n`3[0>/?n`3[3o/?n`3_l>/0j`3[0>oj3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>2Po`06D007
oe1@D?m@o`02D003oe1@00E@033oI[mV_fJookmV_onoI[mVofJoI[mV_fKo3oGom@oeooD?o`oe3oGo
m@oo3oD?mOl6g`05omoOgol00]l00ooOg`07g`0aoimOWenOGomOWeooGiooWenOGimOWenOooAnm7kd
O_mnm7koO_Anm?odO_Anm7kdo`06C005oda<C?l00d`00om<C005C003o`0000D00006000Go`<?0`l3
3ol?0`oo3`<?0ol33`<?0`l00_l0K0<?0`l33ol?0`oo3`<?0ol33`<?0`l3oo4>l@kaoo4>lOoaoo4>
o`ka3_4>l@koh:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>3oD91@T52@oi1@T?n@oi1@oe2@D91@T53o_nJo
i[oVonJoi_oV_`?o01noi[oV_nJoolh?o`o>3ol?c_o>3lh?o`o>olh?cPoo00KO00GogmoOo`02g`03
omoO00OO037oWenOGimOoenOGomOWeooGimOWenOGiooOW5nLGiaog5nLOmaOW5nogiaOW5nLGko00I<
00KoC4a<od`4o`I<00?o00001@0000H000goeP?F0mH3o`?F0ol300?o00L3eP?F0mH300;o00cF0mH3
eP?o0mH3o`<3o`0D0mH3eP?F0mKo/0j`3[3o/0j`ok03o`0Q/0j`3[0>/0koX>2Ph:3Pon2Ph?oPX>3o
h:3PX>2Ph:3o00I@00GoD51@o`02D0;o2500<?mV_fJoI[oo_fJookoo_fKoI[mV_fJoI_l?mOoe3oGo
m@oo3oD?mOoe3ol?m@oeo`KO00GogmoOo`02g`03omoO00OO02KoWenOGimOoenOGomOWenOoimOWenO
Gioom7kdO_AnogkdO_mnm0;o00Unm7kdO_Anm?l01T`02Om<C4coC?m<o`07C003o`0000D000060008
o`<?0`l33`<6o`093`<?0`l33`<?00;o00L33`<?0`l300Ko014?0`l33`<?0`l3oo4>l@ka3P06o`0B
l@ka3_4>l@ka3_oPX>2Ph:3P1Ol04n2Ph?oPX>2Ph:3Poe2@D91@T5001_l04Y1@oe2@D91@T53o_nJo
i[oV_`Ko00kV_onoi[oV_nJoolh?cPGo00o>olh?cPoo3lkocPo>3ol01ml5o`03gooO00SO00SoWenO
GimOW`Ko019OWonOGimOWenOogiaOW5nLGh5o`0<OW5nogiaOW5nLGko1d`6o`03C?m<00I<00?o0000
1@0000H000goeP?F0mH3eP?F0mH300Co00KF0mH3eP<2o`0<eP?F0mH3eP?F0mH31?l05=H3eP?F0mKo
/0j`3[0>/0j`3[0>0ol050j`3[0>/0koX>2Ph:3PX>2Ph:3P1?l02:3PX>2Ph:3o3E02o`Q@00koI[mV
_fJoI[mV_fJoIP;o016oI[mV_fJoI_l?m@oe3oD?m@02o`053oD?m@l00_l01_D?m@oeo`cO0_l9g`0>
oimOWenOGimOWenOGil2o`0EGimOWenOGioom7kdO_Anm7kdO_An00?o00Unm7kdO_Anm?l03D`2o`M<
00?o00001@0000H001Oo0`l33`<?0`l33`<?0`l33`<?0`l33`02o`2>0`l33`<?0`l33`<?0`l33`<?
0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?m@T52@D91@
T52@D91@T52@D91@T52@D?noi[oV_nJoi[oV_nJoi[oV_nJoi[oV_oo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?oaOO037oWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01I<
00?o00001@0000H001OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`17eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l05e00<?mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l?m@oe3oD?m@oe3oD?m@oe3oD?m@oeoaOO037oWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01I<00?o00001@0000H001Oo0`l3
3`<?0`l33`<?0`l33`<?0`l33`02o`2>0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D91@T52@D91@T52@D?no
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?oaOO037oWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01I<00?o00001@0000H001OoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0`02o`17eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l05e00<?mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI_l?m@oe3oD?m@oe3oD?m@oe3oD?m@oeoaOO037oWenOGimOWenOGimOWenOGimOWenOGioom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co01I<00?o00001@0000H001Oo0`l33`<?0`l33`<?0`l33`<?0`l3
3`02o`2>0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D91@T52@D91@T52@D?noi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?oaOO037oWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko01I<00?o00001@0000H001OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0`02o`17eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX?l05e00<?mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l?m@oe3oD?m@oe3oD?
m@oe3oD?m@oeoaOO037oWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co01I<00?o00001@0000H001Oo0`l33`<?0`l33`<?0`l33`<?0`l33`02o`2>0`l33`<?0`l33`<?
0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?m@
T52@D91@T52@D91@T52@D91@T52@D?noi[oV_nJoi[oV_nJoi[oV_nJoi[oV_oo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?oaOO037oWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko01I<00?o00001@0000H001OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`17eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l0
5e00<?mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l?m@oe3oD?m@oe3oD?m@oe3oD?m@oeoaOO037oWenO
GimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01I<00?o00001@0000H0
ool7o`L000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimO
WenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`054`2oaM<0;ooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33om@T52@
D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOo`0Fg`03
o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimO
WenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`054`2oaM<0;ooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33om@T52@
D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOo`0Fg`03
o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimO
WenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`054`2oaM<0;ooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33om@T52@
D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOo`0Fg`03
o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimO
WenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`01D`3o`a<0_l7C0?o3D`01omnLGiaOW40
0ol05G5nLGiaOW5nLGiaOW7o3_4>l@ka3P03o`0E3_4>l@ka3_4>l@ka3_l?0`l33`<?00?o01D?0`l3
3`<?0`l33`<?oe2@D91@T5000ol0552@D91@T52@D91@T53oh:3PX>2P0ol04Z3PX>2Ph:3PX>2Ph:3o
3lh?cP?o01S>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nH3o`0Ei[oV_nJoi[oV_nJoi_nOGimOWenO00?o
00jOGimOWenOGimOWenOo`OO0ol<g`03o`0000D000060003oda<00Q<00?oC4`02D`2o`Y<00?oC4`0
2T`0B?odO_Anm7kdO_Com7kdO_Anm7kdO_Ano`j`3[0>/0j`3[3o/0j`3[0>/0j`3[0>o`?F0mH3eP?F
0mKoeP?F0mH3eP?F0mH3o`Y@00?oD5002U00H?nPh:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PooD?m@oe3oGo
m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fKoI[mV_fJoI[mV_fJooimOWenOGimOWeooGimOWenOGimO
WenOo`[O00?ogml02Ml00ol0000500001P000om<C005C0Co0T`3o`I<0_l7C0Co0T`3o`M<00OoOW5n
LGia00Co01AnooooOW5nLGiaOW7o3_4>l@ka3PCo01Ca3_ool@ka3_4>l@ko3`<?0`l33`Co01@3oooo
0`l33`<?0`ooD91@T52@D0Co01>@D?ooT52@D91@T53oh:3PX>2P00Co017PX?nPh:3PX>2Ph:3o3lh?
cP04o`083oooo`o>3lh2o`0=3lh?cPooi[oV_nJoiP04o`0D_ooookoV_nJoi[oVoimOWenOGil4o`03
Gooo00;o00ROGimOWenOo`OO1?l01=ooool7g`03o`0000D000060003oda<00A<00GoC4a<o`03C003
oda<00E<0_l6C005oda<C?l00d`00om<C006C018ooAnm7kdooAnm?odO_AnogkdO_Anm7ko3[0>/0j`
ok0>/?n`ok0>o`j`3[0>/0ko0mH3eP?FomH3e_oF0mH3o`?F0mH3eP?o1U001om@D53oD?l00U000om@
D005D01Poj3PX>2Poj3PX?nPh?oPX>2Ph:3PX>3om@oeooD?mOoe3ol?m@oeooD?o`oe3oGo_fJoI[mV
ofJoI_mV_fJookmV_fJoI[ooWenOGimOoenOGomOWonOGimOWenOGioo1]l01OoOgmoo00;O00?ogml0
1]l00ol0000500001P000om<C004C006oda<C?m<1?l6C0;o1T`01_m<C4coC0Co1d`0W?mnLGiaO_mn
LGkoOW5nLOmaOW5nLGiao`ka3_4>lOoa3_7olOoa3_l>l@ka3_4>o`l33`<?0ol33`?o0`l33ol?0`l3
3`<?oe2@D91@T?n@D93oT?n@D?m@T52@D91@on2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3o3lh?o`o>3ol?
c_o>3lh?o`o>olh?cPooi[oV_nJookoV_onoiP?o023V_nJoi[oVoimOWenOGomOWeooGimOoenOGimO
WenOo`KO00GogmoOo`02g`03omoO00KO00?o00001@0000H000?oC4`014`02Om<C4coC?m<o`07C0;o
1T`02Om<C4coC?m<o`08C00=ooAnm7kdooAnm?odOP02o`0Em7kdO_Anm7ko3[0>/0j`ok0>/?n`00?o
01F`3[0>/0j`3_l3eP?F0mKoeP?FomH00ol02MH3eP?F0mH3o`06D005oe1@D?l00U02o`Q@063oX>2P
h:3oX>2Poj3PX?nPh:3PX>2Ph?oe3oGom@oeooD?o`oe3oGom@oo3oD?mOnoI[mV_fKoI[mVofKoI[oo
_fJoI[mV_onOGimOWeooGimOoenOGiooWenOGimOWol6g`05omoOgol00]l00ooOg`06g`03o`0000D0
00060003oda<00E<1_l00dcoC006C0;o1d`6o`03C?m<00M<00OoOW5nLGia00Go01=aOW7oLGiaOW5n
LOl>l@ka3_4>00Ko01;a3_4>l@ka3_4>o`l33`<?0`l6o`0B0`l33`<?0`l33om@T52@D91@1_l04I1@
oe2@D91@T53oh:3PX>2P00Go012Ph:3oX>2Ph:3PX?l?cPo>1Ol05/kocPo>3ol?c_o>3lh?onJoi[oV
_nH6o`0B_nKoi[oV_nJoi_nOGimOWenO1_l02enOoimOWenOGioo00OO1Ol00moog`07g`03o`0000D0
00060003oda<00]<0_l7C0;o3D`2o`Q<00com7kdO_Anm7kdO_@3o`0Fm7kdO_Anm7ko3[0>/0j`3[0>
/0j`3P?o01@>/0j`3[0>o`?F0mH3eP?F0mH3ePCo00P3eP?F0mH3o`e@0_l8D00<oj3PX>2Ph:3PX>2P
1?l04N2Ph:3PX>3om@oe3oD?m@oe00;o00D?m@oe3`02o`0Cm@oe3oGo_fJoI[mV_fJoI[mV_`02o`0F
I[mV_fJoI[ooWenOGimOWenOGimOW`;o00UOWenOGimOWol03=l2o`SO00?o00001@0000H000?oC4`0
54`2oaM<0;ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l3
3`<?0`l33`<?0`l33`<?0`l33om@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenO
GimOWenOGimOWenOGimOWenOo`0Fg`03o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV
_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`0
54`2oaM<0;ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l3
3`<?0`l33`<?0`l33`<?0`l33om@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenO
GimOWenOGimOWenOGimOWenOo`0Fg`03o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV
_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`0
54`2oaM<0;ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l3
3`<?0`l33`<?0`l33`<?0`l33om@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenO
GimOWenOGimOWenOGimOWenOo`0Fg`03o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV
_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOoaKO00?o00001@0000H000?oC4`0
54`2oaM<0;ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l3
3`<?0`l33`<?0`l33`<?0`l33om@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenO
GimOWenOGimOWenOGimOWenOo`0Fg`03o`0000D000060003oda<01A<0_lGC018ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
5e00H?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV
_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOoaKO00?o00001@0000H0ool7o`L0
0006000GooAnm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l06?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaI<
04Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3o01I@037o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oGo01OO01SoWenOGimOWenOGimOWenOGimOWenOGol700001P005omnLGiaOW5nLGiaOW5n
LGiaOW5nLGia00;o01QnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC02@o`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@
T52@D91@T52@D91@T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPoo5ml06?nOGimOWenOGimOWenOGimOWenOGimOo`L00006000GooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_l06?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaI<04Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o01I@037o_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo01OO01SoWenOGimOWenO
GimOWenOGimOWenOGol700001P005omnLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o01QnLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lFC02@o`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D93oi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo5ml06?nOGimOWenOGimOWenO
GimOWenOGimOo`L00006000GooAnm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l06?Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoaI<04Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o01I@037o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oGo01OO01SoWenOGimOWenOGimOWenOGimOWenOGol700001P005omn
LGiaOW5nLGiaOW5nLGiaOW5nLGia00;o01QnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC02@o`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPoo5ml06?nOGimOWenOGimOWenOGimOWenOGimOo`L00006000GooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_l06?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaI<04Wo0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3o01I@037o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo01OO
01SoWenOGimOWenOGimOWenOGimOWenOGol700001P002?mnLGiaOW5n0ol037iaOW5nLGiaOW5nL@;o
00MnLGiaOW5n00?o00inLGiaOW5nLGiaOW5no`I<0ol=C008o`l33`<?0`l3o`0E3`<?0`l33`<?0`l3
3ol>l@ka3_4>00?o01D>l@ka3_4>l@ka3_4>on2Ph:3PX>000ol05>2Ph:3PX>2Ph:3PX>3oD91@T52@
0ol05I1@T52@D91@T52@D93oi[oV_nJoiP03o`0Bi[oV_nJoi[oV_nJoi_l?cPo>0ol04Lh?cPo>3lh?
cPo>3lh?cPoo00OO0ol=g`08oimOWenOGil3o`0=WenOGimOWenOGimOo`0700001P005oodO_Anm7kd
O_AnogkdO_Anm7kdO_An00;o01SdO_Anm7kdO_AnogkdO_Anm7kdO_Anm?l9C003oda<00Y<04Wo0mH3
eP?F0mH3e_oF0mH3eP?F0mH3eP?o3[0>/0j`3[0>/?n`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph?oPX>2P
h:3PX>2Ph:3o00U@00?oD5002U00<OnoI[mV_fJoI[mVofJoI[mV_fJoI[mV_ooe3oD?m@oeooD?m@oe
3oD?m@oe3oD?mOl02]l00ooOg`0:g`0HoimOWenOGimOWeooGimOWenOGimOWeoo1`0000H000SoOW5n
LGiaOPCo00]aooooLGiaOW5nL@02o`07OW5nLGiaOP04o`0=LOooog5nLGiaOW5no`06C0Co0T`3o`M<
00So3`<?0`l33`Co01@3oooo0`l33`<?0`oo3_4>l@ka3PCo01Ca3_ool@ka3_4>l@koh:3PX>2Ph0Co
01>Ph?oPX>2Ph:3PX>3oD91@T52@00Co01A@T?ooD91@T52@D93oi[oV_nJoiPCo016ooooo_nJoi[oV
_nKo3lh?cP04o`083oooo`o>3lh2o`063lh?cPoo1ml4o`04goooo`SO00SoWenOGimOW`Co00=Oool0
0_l01imOWenOGol01`0000H001Oom7kdO_AnogkdO_mnm7kdooAnm7kdOP02o`0Hm7kdO_AnogkdO_mn
m7kdooAnm7kdO_Co1D`01Om<C4co00=<00?oC4`01T`0BOl3eP?F0mKoeP?FomH3eP?o0mH3eP?F0ol>
/0j`3[3o/0j`ok3o/0ko3[0>/0j`3_nPh:3PX>3oh:3Pon2Poj3PX>2Ph:3PX?l01E001om@D53oD?l0
0U000om@D005D00aokmV_fJoI_mV_fKoI[mV_onoI[mV_fJoooD?mOoe3oGom@oo3oD?mOoe3ol?m@oe
o`06g`05omoOgol00]l00ooOg`07g`0HoimOWenOGomOWeooGiooWenOGimOWeoo1`0000H001OoOW5n
LGiaog5nLOmaOW5nogiaOW5nL@02o`0HOW5nLGiaog5nLOmaOW5nogiaOW5nLGko1D`01_m<C4coC0Co
1d`0KOl?0`l33`?o0`l3o`<?0`oo3`<?0`l33ol>l@ka3_7ol@kaoo7ol@ko3_4>l@ka3_oPX>2Ph:3o
X>2Poj3PX?nPh:3PX>2Ph?m@T52@D?m@T53oD?m@T?n@D91@T52@onJoi[oV_onoi[oo_nH00ol08>Jo
i[oV_nKo3lh?o`o>3ol?c_o>3lh?o`o>olh?cPoo1]l01OoOgmoo00;O00?ogml01ml06?nOGimOWeoo
GimOoenOGomOWenOGimOo`L00006000>ooAnm7kdO_mnm7koO_@2o`07O_Anm7kdOP02o`0=m7kdO_An
ogkdO_mnm002o`09O_Anm7kdO_Co00E<00WoC4a<odcoC?l024`03Ol3eP?F0mKoeP?FomH00ol05MH3
eP?F0mH3o`j`3[0>/?n`3[3o/003o`0Q/0j`3[0>/0koX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3o00E@
00GoD51@o`02D0;o2500<OnoI[mV_fKoI[mVofKoI[oo_fJoI[mV_ooe3oGom@oeooD?o`oe3oGom@oo
3oD?mOl01]l01OoOgmoo00;O00?ogml01ml06?nOGimOWeooGimOoenOGiooWenOGimOo`L000060008
ogiaOW5nLGh5o`0:OW5nogiaOW5nL@;o00MnLGiaOW5n00Go00anLGkoOW5nLGiaO_l6C0Ko00=<od`0
1d`02?l?0`l33`<?1_l04P<?0`l33`<?0`oo3_4>l@ka3PKo01;a3_4>l@ka3_4>on2Ph:3PX>05o`0B
h:3Pon2Ph:3PX>3oD91@T52@1_l04U2@oi1@T52@D93oi[oV_nJoiPKo00noi_oV_nJoi[oVo`o>3lh0
1Ol03lkocPo>3ol?c_o>3lh?o`07g`Go00?Ooml02=l02?nOGimOWenO1_l02UnOoimOWenOGol70000
1P003OodO_Anm7kdO_Anm7h00ol01gkdO_Anm7h00_l03?Anm7kdO_Anm7kdOP?o00Unm7kdO_Anm?l0
34`2o`Q<00go0mH3eP?F0mH3eP?F00Co01D3eP?F0mH3o`j`3[0>/0j`3[0>/0h00ol050j`3[0>/0ko
X>2Ph:3PX>2Ph:3P1?l02:3PX>2Ph:3o3502o`Q@00ko_fJoI[mV_fJoI[mV_`;o019V_fJoI[mV_ooe
3oD?m@oe3oD2o`053oD?m@l00_l01_D?m@oeo`cO0_l9g`0>oimOWenOGimOWenOGil2o`08GimOWenO
Gol700001P005omnLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o01QnLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lFC02@o`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D93oi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo5ml06?nOGimOWenOGimOWenOGimOWenOGimOo`L0
0006000GooAnm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l06?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaI<
04Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3o01I@037o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oGo01OO01SoWenOGimOWenOGimOWenOGimOWenOGol700001P005omnLGiaOW5nLGiaOW5n
LGiaOW5nLGia00;o01QnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC02@o`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@
T52@D91@T52@D91@T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPoo5ml06?nOGimOWenOGimOWenOGimOWenOGimOo`L00006000GooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_l06?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaI<04Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o01I@037o_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo01OO01SoWenOGimOWenO
GimOWenOGimOWenOGol700001P005omnLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o01QnLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lFC02@o`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D93oi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo5ml06?nOGimOWenOGimOWenO
GimOWenOGimOo`L00006000GooAnm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l06?Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoaI<04Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o01I@037o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oGo01OO01SoWenOGimOWenOGimOWenOGimOWenOGol700001P005omn
LGiaOW5nLGiaOW5nLGiaOW5nLGia00;o01QnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC02@o`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPoo5ml06?nOGimOWenOGimOWenOGimOWenOGimOo`L000060?oo1ol70000
1P005onOGimOWenOGimOWenOGimOWenOGimO00;o01ROGimOWenOGimOWenOGimOWenOGimOWolFg`03
oda<01E<0:OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?
0`l33`<?0`l33`<?0`l33`<?0on@D91@T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX?l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJoo`070000
1P005onOGimOWenOGimOWenOGimOWenOGimO00;o01ROGimOWenOGimOWenOGimOWenOGimOWolFg`03
oda<01E<04SoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3
eP?F0mH3eP?F0mH3eP?F0mH3e_lGD018on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PooD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJoI[mV_fJoI[mV_fKo1`0000H001OoWenOGimOWenOGimOWenO
GimOWenOG`02o`0HWenOGimOWenOGimOWenOGimOWenOGioo5]l00om<C00EC02Wog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?0`l33`<?0`l33`?o
T52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPooi[oV_nJoi[oV_nJoi[oV_nJoi[oV_ol01`0000H001OoWenOGimOWenOGimOWenO
GimOWenOG`02o`0HWenOGimOWenOGimOWenOGimOWenOGioo5]l00om<C00EC018ogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo
5e00B?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?mOnoI[mV_fJo
I[mV_fJoI[mV_fJoI[mVo`L00006000GoimOWenOGimOWenOGimOWenOGimOWel00_l069mOWenOGimO
WenOGimOWenOGimOWenOoaKO00?oC4`05D`0YomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@
T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oo00L00006000GoimOWenOGimOWenOGimOWenOGimOWel00_l069mOWenOGimO
WenOGimOWenOGimOWenOoaKO00?oC4`05D`0B?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?FoaM@04Soh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>3om@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l70000
1P005onOGimOWenOGimOWenOGimOWenOGimO00;o01ROGimOWenOGimOWenOGimOWenOGimOWolFg`03
oda<01E<0:OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?
0`l33`<?0`l33`<?0`l33`<?0on@D91@T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX?l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJoo`070000
1P002?nOGimOWenO0ol039mOWenOGimOWenOG`;o00NOGimOWenO00?o00jOGimOWenOGimOWenOo`KO
0ol=g`03oda<00E<0ol=C008ogkdO_Anm7h3o`0EO_Anm7kdO_Anm7kdO_l>/0j`3[0>00?o01@>/0j`
3[0>/0j`3[0>o`?F0mH3eP?o00kF0mH3eP?F0mH3eP?Fo`M@0ol=D008on2Ph:3PX>03o`0Bh:3PX>2P
h:3PX>2Ph?oe3oD?0ol060oe3oD?m@oe3oD?m@oe3oGo_fJoI[mV_`?o00foI[mV_fJoI[mV_fKo00L0
0006000GoimOWenOGimOWeooGimOWenOGimOWel00_l069mOWenOGimOWeooGimOWenOGimOWenOo`WO
00?ogml02]l00om<C008C003oda<00Y<0:OoLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW7o3_4>l@ka3_4>
lOoa3_4>l@ka3_4>l@ko3`<?0`l33`<?o`l33`<?0`l33`<?0on@D91@T52@D91@oe2@D91@T52@D91@
T?nPh:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX?l?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3ooV_nJoi[oV_nJo
okoV_nJoi[oV_nJoo`0700001P002?nOGimOWenO1?l00eooo`02o`06WenOGimO0_l01imOWenOGil0
1?l00eooo`02o`08WenOGimOWol6g`Co00COoooo2=l00om<C005C0Co0T`3o`M<00SoO_Anm7kdOPCo
01Cdoooom7kdO_Anm7ko3[0>/0j`3PCo01>`3_oo/0j`3[0>/0ko0mH3eP?F00Co00d3oooo0mH3eP?F
0mKo00M@1?l2D0;o25002?oPX>2Ph:3P1?l04J3Pon2Ph:3PX>2Ph?oe3oD?00Co00Seoooom@oe3`;o
00ge3oD?mOnoI[mV_fJo00Co00aVooooI[mV_fJoI_l700001P005onOGimOWeooGimOoenOoimOWenO
GimO00;o01ROGimOWeooGimOoenOoimOWenOGimOWol5g`05omoOgol00]l00ooOg`07g`03oda<00A<
00GoC4a<o`03C003oda<00I<0:OoLGiaOW5nogiaO_mnLGiaog5nLGiaOW7o3_4>l@kaoo4>lOoaoo4>
o`ka3_4>l@ko3`<?0`oo3`<?o`l33`?o0`l33`<?0on@D91@T53oD91@oe3oD93oT52@D91@T?nPh:3P
X>3oh:3Pon2Poj3PX>2Ph:3PX?l?cPoo3lh?o`o>olh?cPoo3lkocPo>3ooV_nJoi[oo_nJookoV_nKo
i[oV_nJoo`0700001P005onOGimOWeooGimOoenOGomOWenOGimO00;o01ROGimOWeooGimOoenOGomO
WenOGimOWol5g`05omoOgol00]l00ooOg`07g`03oda<00A<00KoC4a<od`4o`M<04SoO_Anm7kdooAn
m?odO_AnogkdO_Anm7ko3[0>/0j`ok0>/?n`ok0>o`j`3[0>/0ko0mH3eP?o0mH3o`?F0mKoeP?F0mH3
e_l6D007oe1@D?m@o`02D003oe1@00E@03koh:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>3om@oeooD?mOoe
3ol?m@oeooD?o`oe3oGo_fJoI[mVofJoI_mV_`?o00NoI[mV_fKo00L00006000GoimOWenOGomOWeoo
GimOWonOGimOWel00_l069mOWenOGomOWeooGimOWonOGimOWenOo`GO00GogmoOo`02g`03omoO00OO
00?oC4`014`02Om<C4coC?m<o`08C00>og5nLGiaO_mnLGkoOW42o`0EOW5nLGiaOW7o3_4>l@kaoo4>
lOoa00?o01Ca3_4>l@ka3_l?0`l33ol?0`oo3`?o01H?0`l33`<?0on@D91@T53oD91@oe2@0_l0D52@
D91@T52@oj3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>2Po`o>3ol?cPoo3lkocPo>3ol?c_o>3lh?onJoi[oV
_onoi[oo_onoi_oV_nJoi[oo1`0000H000SoWenOGimOW`Ko00UOWonOGimOWel00_l01imOWenOGil0
1_l02enOoimOWenOGioo00KO1Ol00moog`08g`03oda<00E<1_l00dcoC007C008ogkdO_Anm7h5o`0C
O_AnogkdO_Anm7ko3[0>/0j`3P06o`0A/0j`3[0>/0j`3_l3eP?F0mH01_l02`?F0mH3eP?F0mKo00M@
1_l2D003oe1@00E@00Soh:3PX>2Ph0Go013PX>3oh:3PX>2Ph?oe3oD?1Ol05Poo3oD?mOoe3ol?m@oe
okmV_fJoI[l6o`0:I[oo_fJoI[mVo`L00006000>oimOWenOGimOWenOGil2o`07GimOWenOG`02o`0=
WenOGimOWenOGimOW`02o`09GimOWenOGioo00_O0_l9g`03oda<00]<0_l8C00=og5nLGiaOW5nLGia
OP03o`0FOW5nLGiaOW7o3_4>l@ka3_4>l@ka3P?o01<>l@ka3_4>o`l33`<?0`l33`<?00Co01D33`<?
0`l3oi1@T52@D91@T52@D9000_l05E2@D91@T52@oj3PX>2Ph:3PX>2Ph004o`0AX>2Ph:3PX?l?cPo>
3lh?cPl00_l01Lh?cPo>00;o01<?cPo>3ooV_nJoi[oV_nJoi[oV00;o00Roi[oV_nJoo`L00006000G
oimOWenOGimOWenOGimOWenOGimOWel00_l069mOWenOGimOWenOGimOWenOGimOWenOoaKO00?oC4`0
5D`0B?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3
eP?F0mH3eP?F0mH3eP?FoaM@04Soh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3om@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oGo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l700001P005onOGimOWenOGimOWenOGimOWenO
GimO00;o01ROGimOWenOGimOWenOGimOWenOGimOWolFg`03oda<01E<0:OoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?0`l33`<?0`l33`<?0`l33`<?0on@D91@
T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJoo`0700001P005onOGimOWenOGimOWenOGimOWenO
GimO00;o01ROGimOWenOGimOWenOGimOWenOGimOWolFg`03oda<01E<04SoO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_lGD018
on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeokmV_fJoI[mV_fJo
I[mV_fJoI[mV_fKo1`0000H001OoWenOGimOWenOGimOWenOGimOWenOG`02o`0HWenOGimOWenOGimO
WenOGimOWenOGioo5]l00om<C00EC02Wog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@D91@T52@D91@T52@D91@T52@D93o
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPooi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_ol01`0000H001OoWenOGimOWenOGimOWenOGimOWenOG`02o`0HWenOGimOWenOGimO
WenOGimOWenOGioo5]l00om<C00EC018ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo5e00B?oPX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?mOnoI[mV_fJoI[mV_fJoI[mV_fJoI[mVo`L00006000G
oimOWenOGimOWenOGimOWenOGimOWel00_l069mOWenOGimOWenOGimOWenOGimOWenOoaKO00?oC4`0
5D`0YomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?
0`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Po`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oo00L00006000G
oimOWenOGimOWenOGimOWenOGimOWel00_l069mOWenOGimOWenOGimOWenOGimOWenOoaKO00?oC4`0
5D`0B?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3
eP?F0mH3eP?F0mH3eP?FoaM@04Soh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3om@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oGo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_l700001P005onOGimOWenOGimOWenOGimOWenO
GimO00;o01ROGimOWenOGimOWenOGimOWenOGimOWolFg`03oda<01E<0:OoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?0`l33`<?0`l33`<?0`l33`<?0on@D91@
T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3ooV_nJoi[oV_nJoi[oV_nJoi[oV_nJoo`0700001P3oo`Oo1`0000H000?ogml05=l2oaOO
033oWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC02?o`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>
3lh?cPo>3lh?cPo>3lh?c_l01`0000H000?ogml05=l2oaOO033oWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC018o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>
/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o5e00<?noI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003omoO01CO0_lGg`0`oimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5d`0Sol?0`l33`<?0`l33`<?
0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@
T52@D91@T52@D91@T52@D91@T52@onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVo`o>3lh?cPo>3lh?cPo>
3lh?cPo>3lko00L000060003omoO01CO0_lGg`0`oimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko5d`0B?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoaM@033o_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol700001P000ooOg`0Dg`;o5ml0<?nOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaM<08oo3`<?0`l33`<?0`l33`<?0`l33`<?
0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@
T52@D91@T52@D91@T?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
o`0700001P000ooOg`0Dg`;o5ml0<?nOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoaM<04So0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?lGD00`okmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoooD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oo1`0000H000?ogml05=l2oaOO033oWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC02?o`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>
l@ka3_4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@
T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l01`0000H0
00?ogml01Ml3o`cO0_l7g`?o3Ml01onOGimOWel00ol05EnOGimOWenOGimOWeooO_Anm7kdOP03o`0>
O_Anm7kdO_Anm7kdO_l7C0?o3D`02?l3eP?F0mH30ol050?F0mH3eP?F0mH3eP?o3[0>/0j`0ol05K0>
/0j`3[0>/0j`3[3oh:3PX>2Ph003o`0>h:3PX>2Ph:3PX>2Ph?l7D0?o3E002?noI[mV_fJo0ol04[mV
_fJoI[mV_fJoI[oom@oe3`?o010?m@oe3oD?m@oe3oD?m@oo1`0000H000?ogml02=l00ooOg`09g`;o
2]l00ooOg`0:g`0`oimOWenOGimOWonOGimOWenOGimOWeooLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW7o
2T`00om<C00:C02?o`l33`<?0`l33`?o0`l33`<?0`l33`<?o`ka3_4>l@ka3_l>l@ka3_4>l@ka3_7o
X>2Ph:3PX>2Ph?oPX>2Ph:3PX>2Ph:3oT52@D91@T52@D?m@T52@D91@T52@D93oi[oV_nJoi[oV_ono
i[oV_nJoi[oV_nKo3lh?cPo>3ol?cPo>3lh?cPo>3lh?c_l01`0000H000?ogml01Ml4o`04goooo`OO
0_l7g`Co00COoooo2=l01onOGimOWel01?l00iooo`02o`0?GimOWenOGomnm7kdO_An00Co00gdoooo
m7kdO_Anm7ko00M<1?l2C0?o1d`02?l3eP?F0mH31?l04mKooooF0mH3eP?F0ol>/0j`3[001?l050j`
ool>/0j`3[0>/?oPX>2Ph:3P1?l03J3Pon2Ph:3PX>2Ph?l01e04o`9@0_l8D008okmV_fJoI[l4o`0A
I_ooofJoI[mV_fJoooD?m@l01?l02?Gooooe3oD?0_l01OD?m@oo00L000060003omoO00CO00GogmoO
o`02g`03omoO00KO0_l6g`05omoOgol00]l00ooOg`07g`0`oimOWenOoimOWonOGomOWenOGimOWeoo
LGiaOW5nogiaO_mnLGiaog5nLGiaOW7o1T`01Om<C4co00=<00?oC4`01T`0Sol?0`l33`?o0`l3o`<?
0`oo3`<?0`l33ol>l@ka3_l>l@ko3_l>lOoa3_4>l@kaoj3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>2Poi1@
T52@D?m@T53oD?m@T?n@D91@T52@onJoi[oV_onoi[oo_nJoi_oV_nJoi[oVo`o>3ol?cPoo3lkocPo>
3ol?c_o>3lko00L000060003omoO00CO00GogmoOo`02g`03omoO00KO0_l6g`05omoOgol00]l00ooO
g`07g`0`oimOWenOoimOWonOGiooWenOGimOWeooO_Anm7kdooAnm?odO_AnogkdO_Anm7ko1T`01_m<
C4coC0Co1d`0B?l3eP?F0mKoeP?FomH3eP?o0mH3eP?F0ol>/0j`3_l>/0ko3_l>/?n`3[0>/0j`on2P
h:3PX?nPh:3oX>2Poj3PX>2Ph:3Po`I@00OoD51@oe3o009@00?oD5001E003_noI[mV_fKoI[mVofJo
0ol07kmV_fJoI[oom@oeooD?mOoe3ol?m@oeooD?o`oe3ol01`0000H000?ogml01=l01OoOgmoo00;O
00?ogml01]l2o`KO00GogmoOo`02g`03omoO00OO02GoWenOGiooWenOoimOWeooGimOWenOGomaOW5n
LGkoOW5nogia00;o00UnLGiaOW5nLOl01T`02Om<C4coC?m<o`08C00=o`l33`<?0ol33`?o0`03o`0D
0`l33`<?0`oo3_4>l@ko3_4>o`h3o`0^3_4>l@ka3_7oX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3oT52@
D91@oe2@D?m@T0;o03Q@T52@D91@T?oV_nJoi[oo_nJookoo_nKoi[oV_nJoi_l?cPoo3lh?o`o>olh?
cPoo3lkocPo>o`L000060003omoO00GO1Ol00moog`07g`;o1ml5o`03gooO00SO00OoWenOGimO00Ko
01:OGomOWenOGimOogkdO_Anm7h5o`0<O_AnogkdO_Anm7ko1d`6o`03C?m<00M<00So0mH3eP?F0`Ko
017F0mH3eP?F0mH3o`j`3[0>/006o`0B3[0>/0j`3[0>/?oPX>2Ph:3P1Ol03>2Ph?oPX>2Ph:3Po`M@
1_l2D003oe1@00E@00So_fJoI[mV_`Ko00mV_onoI[mV_fJoooD?m@l01Ol03Poo3oD?mOoe3ol?m@oo
1`0000H000?ogml02]l2o`SO0_l<g`;o2Ml03OnOGimOWenOGimOWel00_l05ImOWenOGimOog5nLGia
OW5nLGiaOP03o`09OW5nLGiaOW7o00e<0_l8C00=o`l33`<?0`l33`<?0`04o`0D3`<?0`l33ol>l@ka
3_4>l@ka3_43o`0Dl@ka3_4>lOnPh:3PX>2Ph:3PX>04o`0EX>2Ph:3PX?n@D91@T52@D91@T52@00;o
01I@T52@D91@T?oV_nJoi[oV_nJoi[oV0_l04[oV_nJoi[oVo`o>3lh?cPo>3`;o00G>3lh?cP02o`05
3lh?c_l01`0000H000?ogml05=l2oaOO033oWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lGC018o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o5e00<?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_ooe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003omoO01CO0_lGg`0`oimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5d`0Sol?0`l33`<?0`l33`<?0`l33`<?0`l33ol>
l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@
T52@D91@T52@onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVo`o>3lh?cPo>3lh?cPo>3lh?cPo>3lko00L0
00060003omoO01CO0_lGg`0`oimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko5d`0B?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`on2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoaM@033o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe
3oD?m@oe3oD?m@oe3ol700001P000ooOg`0Dg`;o5ml0<?nOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaM<08oo3`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>
l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@
T?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0700001P000ooO
g`0Dg`;o5ml0<?nOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaM<
04So0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oPX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph?lGD00`okmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoooD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oo1`0000H000?ogml05=l2oaOO033oWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlGC02?o`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>
l@ka3_7oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D93oi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l01`0000H000?ogml05=l2oaOO
033oWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC018o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>3o5e00<?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L0
00060003omoO01CO0_lGg`0`oimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o5d`0Sol?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@onJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oVo`o>3lh?cPo>3lh?cPo>3lh?cPo>3lko00L000050?oo2?l700001@3oo`So1`0000H0
00?o00004`03oaOO033oWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lGC018o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>3o5e00<?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_ooe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?o`L000060003o`00018000Co0?oo5ml0<?nOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaM<08oo3`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>
l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@
T?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0700001P000ol0
000A0003o`0000;o5ml0<?nOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoaM<04So0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oPX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph?lGD00`okmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoooD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oo1`0000H000?o000040001?l00002oaOO033oWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC02?o`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>
l@ka3_4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@
T52@D93oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l01`0000H0
00?o00000P02o`030?oo00P000?o00000P02oaOO033oWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lGC018o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>
/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o5e00<?noI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`0000<000?o0?l020000ol0000300;o
5ml0<?nOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaM<08oo3`<?
0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@T?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>o`0700001P000ol000040003o`0000H000?o00001002o`OO0ol=g`07
oimOWenOG`03o`0EGimOWenOGimOWenOGomnm7kdO_An00?o00inm7kdO_Anm7kdO_Ano`M<0ol=C008
o`?F0mH3eP<3o`0D0mH3eP?F0mH3eP?F0ol>/0j`3[03o`0E/0j`3[0>/0j`3[0>/?oPX>2Ph:3P00?o
00kPX>2Ph:3PX>2Ph:3Po`M@0ol=D008okmV_fJoI[l3o`0B_fJoI[mV_fJoI[mV_ooe3oD?0ol040oe
3oD?m@oe3oD?m@oe3ol700001P000ol000030003o`3o00H000?o00001@02o`[O00?ogml02]l0<?nO
GimOWenOGiooWenOGimOWenOGimOog5nLGiaOW5nLGkoOW5nLGiaOW5nLGiao`Y<00?oC4`02T`0Sol?
0`l33`<?0`l3o`<?0`l33`<?0`l33ol>l@ka3_4>l@ko3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>3oh:3P
X>2Ph:3PX>2Poi1@T52@D91@T53oD91@T52@D91@T52@onJoi[oV_nJoi[oo_nJoi[oV_nJoi[oVo`o>
3lh?cPoo3lh?cPo>3lh?cPo>3lko00L000060003o`0000800_l00`3oo`040003o`0000H00_l7g`Co
00COoooo2=l01onOGimOWel01?l00iooo`02o`0?GimOWenOGomnm7kdO_An00Co00gdoooom7kdO_An
m7ko00M<1?l2C0?o1d`02?l3eP?F0mH31?l04mKooooF0mH3eP?F0ol>/0j`3[001?l050j`ool>/0j`
3[0>/?oPX>2Ph:3P1?l03J3Pon2Ph:3PX>2Ph?l01e04o`9@0_l8D008okmV_fJoI[l4o`0AI_ooofJo
I[mV_fJoooD?m@l01?l02?Gooooe3oD?0_l01OD?m@oo00L000060003o`0000X000?o00001`02o`KO
00GogmoOo`02g`03omoO00OO033oWenOGiooWenOoimOoenOGimOWenOGomaOW5nLGkoOW5nogiaOW7o
LGiaOW5nLOl6C005oda<C?l00d`00om<C006C02?o`l33`<?0ol33`?o0`l33ol?0`l33`<?o`ka3_4>
o`ka3_l>o`kaoo4>l@ka3_7oX>2Ph:3Pon2Ph?oPX?nPh:3PX>2Ph:3oT52@D91@oe2@D?m@oe2@oi1@
T52@D93oi[oV_nJookoV_onoi[oVonJoi[oV_nKo3lh?o`o>3ol?c_o>3lh?o`o>olh?c_l01`0000H0
00?o00002@000ol0000800;o1]l01OoOgmoo00;O00?ogml01ml0<?nOGimOWonOGiooWenOoimOWenO
GimOogkdO_Anm?odO_Com7kdO_mnm7kdO_Ano`I<00KoC4a<od`4o`M<04So0mH3eP?FomH3e_oF0mH3
o`?F0mH3eP?o3[0>/0ko3[0>o`ko3[3o/0j`3[0>/?oPX>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph?l6D007
oe1@D?m@o`02D003oe1@00E@00ko_fJoI[mVofJoI_mV_`?o01noI[mV_fJoooD?mOoe3oGom@oo3oD?
mOoe3ol?m@oo00L000060003o`0000P000Co00000ol500;o1]l01OoOgmoo00;O00?ogml01ml09OnO
GimOWonOGiooWenOGomOWenOGimOog5nLGiaO_mnLGkoOW400_l02GiaOW5nLGiao`06C009oda<C?m<
odco00Q<00go3`<?0`l3o`<?0ol300?o01@33`<?0`l33ol>l@ka3_l>l@ko3P?o02h>l@ka3_4>lOnP
h:3PX>3oh:3Pon2Ph?oPX>2Ph:3PX?n@D91@T53oD91@oe2@0_l0>52@D91@T52@onJoi[oV_onoi[oo
_onoi_oV_nJoi[oVo`o>3ol?cPoo3lkocPo>3ol?c_o>3lko1`0000H000?o00001`000ol000030003
o`0000@00_l7g`Go00?Ooml02=l01onOGimOWel01_l04YmOoenOGimOWeooO_Anm7kdOPGo00anm7ko
O_Anm7kdO_l7C0Ko00=<od`01d`02?l3eP?F0mH31_l04MH3eP?F0mH3eP?o3[0>/0j`00Ko018>/0j`
3[0>/0j`on2Ph:3PX>05o`0<h:3Pon2Ph:3PX>3o1e06o`9@00?oD5001E002?noI[mV_fJo1_l03fJo
okmV_fJoI[oom@oe3`05o`0>3ol?m@oeooD?o`oe3ol700001P000ol000060003o`0000D000?o0000
0`02o`cO0_l9g`0=oimOWenOGimOWenOG`02o`0EWenOGimOWeooLGiaOW5nLGiaOW5n00?o00UnLGia
OW5nLOl03D`2o`Q<00go3`<?0`l33`<?0`l300Co01@?0`l33`<?o`ka3_4>l@ka3_4>l@?o01Ca3_4>
l@kaoj3PX>2Ph:3PX>2Ph0Co01FPh:3PX>2Poi1@T52@D91@T52@D9000_l05U2@D91@T52@onJoi[oV
_nJoi[oV_nH2o`0B_nJoi[oV_nKo3lh?cPo>3lh?0_l01Lh?cPo>00;o00D?cPo>o`0700001P000ol0
00050003o`0000H000?o00000`02oaOO033oWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lGC018o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o5e00<?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_ooe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`0000@000?o00001P000ol0o`0400;o5ml0<?nO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaM<08oo3`<?0`l33`<?
0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X?n@D91@T52@D91@T52@D91@T52@D91@T?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_l?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>o`0700001P000ol000030003o`0000L000?o0?l01002oaOO033oWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC018o`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o5e00<?no
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`000080
00?o00001`02o`030?oo00<00_lGg`0`oimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o5d`0Sol?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>
l@kaoj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@onJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oVo`o>3lh?cPo>3lh?cPo>3lh?cPo>3lko00L000060005o`000?l04P02oaOO
033oWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC018o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>3o5e00<?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L0
00060004o`00oa<00_lGg`0`oimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o5d`0Sol?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@onJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oVo`o>3lh?cPo>3lh?cPo>3lh?cPo>3lko00L000060003o`3o01@00_lGg`0`oimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko5d`0B?l3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoaM@
033o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oom@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol700001P02oaD0
0_lGg`0`oimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5d`0Sol?
0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVo`o>
3lh?cPo>3lh?cPo>3lh?cPo>3lko00L000060?oo1ol700007@02oo@0003o01@0003o01@0003o01@0
003o01@0003o01@0003o01@0000>00;o2P02oa`00_l:00;o_@03o`d0000>0003o`0000X000?o0000
6P000ol0000:0003o`000;`000?o0000300000L01?l30003o`0000800ol50003o`0000H00_l00`3o
o`0900;o10000ol0000300?o10000ol0002S00;o00<0ool02@000ol0o`090003o`0000/000080003
o`3o00<000?o00001@000ol000020003o`0000L000?o0?l02@001?l00?l30003o`0000@000?o0000
0`000ol0002T0003o`3o00/000?o000020000ol0000;000020000ol000030003o`0000D000?o0000
0P000ol000080003o`0000P000Co003o0`000ol0000200Co10000ol0002U0003o`0000P01Ol70003
o`3o00`000090003o`00008000?o00000P03o`D000?o00001`000ol0o`090004o`00o`<000?o0000
0P000ol0o`050003o`000:@000?o0?l02`000ol000070003o`3o00`000070003o`3o00@000?o0000
0P000ol000050003o`0000H00_l00`3oo`080004o`00o`<000?o00000P000ol0o`050003o`000:<0
0_l00`3oo`0C00;o00<0ool02`0000L01?l300;o0`04o`<00_lD00;o0P02o`800_l400;o1002old0
003o01@0003o01@0003o01@00000\
\>"],
  ImageRangeCache->{{{0, 274.438}, {287, 0}} -> {-1.27506, -0.28944, 
  0.0420865, 0.0420865}},
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "We add the option ",
  StyleBox["WideElements ", "MR"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" True", "MR"],
  " whenever a groupoid is being formed whose elements may be too wide to fit \
in the table. Here we form a new groupoid, ",
  StyleBox["G4", "MR"],
  ", based on the elements of the symmetric group ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " but with a twisted operation: given two triples (permutations in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " are given as ordered triples), the result of this operation is the triple \
{maximum of the elements in the first coordinate, minimum of the second \
coordinates, add 1 to the absolute value of the difference of the third \
coordinates}."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[TextData[
"CayleyTable[(G4 = FormGroupoid[Elements[Symmetric[3]], {Max[First[#1], \
First[#2]], Min[#1[[2]], #2[[2]]], Abs[Last[#1] - Last[#2]]+1}&, WideElements \
\[Rule] True]), Mode \[Rule] Visual]"], "Input",
  CellLabel->"In[13]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \("KEY for TheGroup: label used \[Rule] element: {g1 \[Rule] {1, 2, 3}, \
g2 \[Rule] {1, 3, 2}, g3 \[Rule] {2, 1, 3}, g4 \[Rule] {2, 3, 1}, g5 \[Rule] \
{3, 1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \("MIA indicates that an element is not in the domain, so it cannot be \
keyed; see output for actual values."\)], "Print",
  CellTags->"FormGroupoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
.56 .37 .6 r
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
0 0 1 r
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.74 .99 .79 r
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.251 .878 .816 r
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
1 .5 0 r
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.56 .37 .6 r
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
0 0 1 r
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.74 .99 .79 r
.70408 .84184 m
.70408 .97789 L
.84014 .97789 L
.84014 .84184 L
F
.251 .878 .816 r
.84014 .84184 m
.84014 .97789 L
.97619 .97789 L
.97619 .84184 L
F
1 1 0 r
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 .5 0 r
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.56 .37 .6 r
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
0 0 1 r
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
.74 .99 .79 r
.02381 .16156 m
.02381 .29762 L
.15986 .29762 L
.15986 .16156 L
F
.251 .878 .816 r
.02381 .02551 m
.02381 .16156 L
.15986 .16156 L
.15986 .02551 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(MIA)] .22789 .77381 0 0 Mshowa
[(MIA)] .36395 .77381 0 0 Mshowa
[(MIA)] .5 .77381 0 0 Mshowa
[(MIA)] .63605 .77381 0 0 Mshowa
[(g5)] .77211 .77381 0 0 Mshowa
[(MIA)] .90816 .77381 0 0 Mshowa
[(MIA)] .22789 .63776 0 0 Mshowa
[(MIA)] .36395 .63776 0 0 Mshowa
[(MIA)] .5 .63776 0 0 Mshowa
[(MIA)] .63605 .63776 0 0 Mshowa
[(MIA)] .77211 .63776 0 0 Mshowa
[(MIA)] .90816 .63776 0 0 Mshowa
[(MIA)] .22789 .5017 0 0 Mshowa
[(MIA)] .36395 .5017 0 0 Mshowa
[(MIA)] .5 .5017 0 0 Mshowa
[(g3)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(MIA)] .90816 .5017 0 0 Mshowa
[(MIA)] .22789 .36565 0 0 Mshowa
[(MIA)] .36395 .36565 0 0 Mshowa
[(g3)] .5 .36565 0 0 Mshowa
[(g4)] .63605 .36565 0 0 Mshowa
[(g5)] .77211 .36565 0 0 Mshowa
[(g6)] .90816 .36565 0 0 Mshowa
[(g5)] .22789 .22959 0 0 Mshowa
[(MIA)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g5)] .63605 .22959 0 0 Mshowa
[(MIA)] .77211 .22959 0 0 Mshowa
[(g5)] .90816 .22959 0 0 Mshowa
[(MIA)] .22789 .09354 0 0 Mshowa
[(MIA)] .36395 .09354 0 0 Mshowa
[(MIA)] .5 .09354 0 0 Mshowa
[(g6)] .63605 .09354 0 0 Mshowa
[(g5)] .77211 .09354 0 0 Mshowa
[(g6)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(TheGroup)] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@h00_lT0003o`00024000?o00008P00K_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ko1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3P02ob@000?o00008@000ol0000R001^ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_l600001P008ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o
90000ol0000Q0003o`00028006kol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>o`H00006000Sok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_lT0003
o`00024000?o00008P00K_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0ko1P0000H002?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02ob@000?o0000
8@000ol0000R001^oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_l600001P008on`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>00;o90000ol0000Q0003
o`00028006ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H0
0006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@h00_lT0003o`00024000?o0000
8P00K_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H0
02?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02ob@000?o00008@000ol0000R001^
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P008ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o90000ol0000Q0003o`00028006kol@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H00006000Sok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_lT0003o`00024000?o00008P00K_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H002?ol@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02ob@000?o00008@000ol0000R001^oo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P008on`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>00;o90000ol0000Q0003o`00028006ko/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@h00_lT0003o`00024000?o00008P00K_oa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3P02ob@000?o00008@000ol0000R001^ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P003_oa3_4>l@ka3_4>l@ka0ol04_4>l@ka3_4>
l@ka3_4>l@ka3P;o90000ol0000Q0003o`00028000kol@ka3_4>l@ka3_4>l@?o027a3_4>l@ka3_4>
l@ka3_4>l@kao`<?0`l33`<?0`l33`<00ol08P<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>
l@h3o`0D3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P008on`3[0>/0j`3[0>/0j`3[0>o`j`3[0>/0j`
3[0>/0j`3[0>00;o90000ol0000Q0003o`00028006ko/0j`3[0>/0j`3[0>/0j`3_l>/0j`3[0>/0j`
3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[3o/0j`3[0>/0j`3[0>/0j`3[0>o`H00006000>oo4>l@ka3_4>l@ka3_44o`0A3_7oo`ka3_4>l@ka
3_4>l@h00_l:0006o`000?l01ol00`3oo`0:0003o`0000L000Ko0000o`07o`030?oo00X000?o0000
1`001_l0003o00Oo00<0ool02`003_oa3_4>l@ka3_4>l@ka1?l080kaool>l@ka3_4>l@ka3_4>lOl3
3`<?0`l33`<?0`l31?l08@ooool?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3P04o`0Cl@kooo4>
l@ka3_4>l@ka3_4>o`0600001P008on`3[0>/0j`3[0>/0ko3[0>o`ko3[3o/0j`3[0>/0j`3[0>00;o
2P001Ol0003o00<000Oo0000o`3o00/000?o00001`001Ol0003o00<000Oo0000o`3o00/000?o0000
1`001Ol0003o00<000Oo0000o`3o00`006ko/0j`3[0>/0j`3[0>o`j`3_l>o`j`ok0>/0j`3[0>/0j`
3[3oeP?F0mH3eP?F0mH3o`?F0ol3eP?FomH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/?n`3[3o/?n`
3_l>/0j`3[0>/0j`3[0>o`H00006000Soo4>l@ka3_4>l@ka3_l>l@ko3_l>lOoa3_4>l@ka3_4>l@h0
0_l:0005o`3o0?l00`001?l00003o`/000?o00001`001Ol0o`3o00<000Co00000ol;0003o`0000L0
00Go0?l0o`030004o`0000?o3000K_oa3_4>l@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@ka3_4>lOl3
3`<?0`l33`<?0`oo3`<?o`l33`?o0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kaoo4>lOoaoo4>o`ka
3_4>l@ka3_4>l@ko1P0000H001?o/0j`3[0>/0j`3[0>o`j`3_l>00?o00d>/0j`3[0>/0j`3[0>00;o
2P001Ol0o`3o00<000Oo0000o`3o00/000?o00001`001Ol0o`3o00<000Oo0000o`3o00/000?o0000
1`001Ol0o`3o00<000Oo0000o`3o00`001?o/0j`3[0>/0j`3[0>o`j`3_l>00?o024>/0j`3[0>/0j`
3[0>/?oF0mH3eP?F0mH3eP?o0mH3o`<00ol08P?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[3o/0j`
ok03o`0?/0j`3[0>/0j`3[0>/0ko00H00006000>oo4>l@ka3_4>l@ka3_46o`0?3_4>l@ka3_4>l@ka
3_4>00;o2P02o`030?oo00<000?o00000P000ol0000:0003o`0000L00_l00`3oo`030003o`000080
00?o00002P000ol0000700;o00<0ool00`000ol000020003o`0000/000kol@ka3_4>l@ka3_4>l@Ko
01h>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<6o`0O3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka
3_4>l@ka3P06o`0Al@ka3_4>l@ka3_4>l@ka3_l01P0000H001Co/0j`3[0>/0j`3[0>/0j`3[0>/0?o
00b`3[0>/0j`3[0>/0h2o`T00_l300Oo00<0ool030000ol0000600;o0`07o`030?oo00`000?o0000
1P02o`<01ol00`3oo`0=000Dok0>/0j`3[0>/0j`3[0>/0j`3[03o`0P/0j`3[0>/0j`3[0>/?oF0mH3
eP?F0mH3eP?F0mH3eP<4o`0ReP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3P?o00h>/0j`
3[0>/0j`3[0>o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@h00_lT0003
o`00024000?o00008P00K_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ko1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02ob@000?o0000
8@000ol0000R001^ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3_l600001P008ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o90000ol0000Q0003
o`00028006kol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H0
0006000Sok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_lT0003o`00024000?o0000
8P00K_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0
02?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02ob@000?o00008@000ol0000R001^
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P008on`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>00;o90000ol0000Q0003o`00028006ko/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H00006000Soo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@h00_lT0003o`00024000?o00008P00K_oa3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H002?o/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02ob@000?o00008@000ol0000R001^ok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P008ooa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o90000ol0000Q0003o`00028006kol@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H00006000Sok0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0h00_lT0003o`00024000?o00008P00K_n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H002?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3P02ob@000?o00008@000ol0000R001^oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P008on`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>00;o90000ol0000Q0003o`00028006ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@h00_lT0003o`00024000?o00008P00K_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ko1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3P02ob@000?o00008@000ol0000R001^ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_l600001P3oo`7o1P0000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0`02o`0UeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0S001:o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3e_lS000VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P008ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o02D33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`oo02<004[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3ob<002Ko0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?o`H00006000SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<0
0_l09MH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol08`00B_l3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo
8`009_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H002?o0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02o`0U0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`0S001:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0olS000Vo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol600001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o02GF0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02<004[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fob<002KoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000So`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l00_l09@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0
8`00B_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`?o8`009_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo
1P0000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`0UeP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0S001:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_lS000VomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P008ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?00;o02D33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02<004[o3`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l3ob<002Ko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000S
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_l09MH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0ol08`00B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo8`009_oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?o1P0000H002?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`02o`0U0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0S001:o`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0olS000Vo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P008ooF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o02GF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?o02<004[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FomH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fob<002KoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3o`H00006000So`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l09@<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol08`00B_l?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o8`009_l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H002?oeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0`02o`0UeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
o`0S001:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3e_lS000VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0ol600001P003_l33`<?0`l33`<?0`l30ol04P<?0`l33`<?0`l33`<?0`l33`;o00h33`<?0`l33`<?
0`l33`?o01@?0`l33`<?0`l33`<?0`l33`<?ob<000ko3`<?0`l33`<?0`l33`?o028?0`l33`<?0`l3
3`<?0`l33`<?0ol33`<?0`l33`<?0`l30ol050<?0`l33`<?0`l33`<?0`l33`?o8`003ol33`<?0`l3
3`<?0`l33`03o`0D3`<?0`l33`<?0`l33`<?0`l33ol600001P008ooF0mH3eP?F0mH3eP?F0mH3o`?F
0mH3eP?F0mH3eP?F0mH300;o02GF0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP?o02<0
04[o0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3eP?o0mH3
eP?F0mH3eP?F0mH3eP?Fob<002KoeP?F0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH3o`H0
0006000>o`<?0`l33`<?0`l33`<4o`0A3oooo`l33`<?0`l33`<?0`l00_l03P<?0`l33`<?0`l33`<?
1?l04`?oool33`<?0`l33`<?0`l33ol02@001_l0003o00Oo00<0ool02P003_l?0`l33`<?0`l33`<?
1?l08@?oool33`<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?0`04o`0C3oooo`l33`<?0`l33`<?0`l3
o`090006o`000?l01ol00`3oo`0:000?o`<?0`l33`<?0`l33`<?00Co01<3oooo0`l33`<?0`l33`<?
0`oo00H00006000SomH3eP?F0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mH3eP<00_l09MH3eP?F0mH3
eP?F0mKoeP?FomH3eP?o0mH3eP?F0mH3eP?F0ol02@001Ol0003o00<000Oo0000o`3o00/004[o0mH3
eP?F0mH3eP?FomH3e_oF0mH3o`?F0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0ol3eP?o0mH3e_oF0mH3
eP?F0mH3eP?Fo`T000Go0000o`030007o`000?l0o`0;000VomH3eP?F0mH3eP?F0mKoeP?FomH3eP?o
0mH3eP?F0mH3eP?F0ol600001P008ol33`<?0`l33`<?0`oo3`<?o`l33`?o0`l33`<?0`l33`<?00;o
02D33`<?0`l33`<?0`l3o`<?0ol33`<?o`l33`<?0`l33`<?0`oo00T000Go0?l0o`030004o`0000?o
2`00B_l?0`l33`<?0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?o`l33ol?
0`l3o`<?0`l33`<?0`l33`?o2@001Ol0o`3o00<000Co00000ol;000Vo`<?0`l33`<?0`l33`?o0`l3
o`<?0`oo3`<?0`l33`<?0`l33ol600001P004ooF0mH3eP?F0mH3eP?o0mH3o`<00ol03@?F0mH3eP?F
0mH3eP<00_l04mH3eP?F0mH3eP?F0mKoeP?FomH00ol03mH3eP?F0mH3eP?F0mH3o`090005o`3o0?l0
0`001ol0003o0?l02`004ol3eP?F0mH3eP?F0mKoeP?FomH00ol08]H3eP?F0mH3eP?F0mH3e_oF0mH3
eP?F0mH3eP?o0mH3o`<3o`0?0mH3eP?F0mH3eP?F0mKo00T000Go0?l0o`030007o`000?l0o`0;000D
omH3eP?F0mH3eP?F0mKoeP?FomH3o`0?eP?F0mH3eP?F0mH3eP?o00H00006000>o`<?0`l33`<?0`l3
3`<6o`0?3`<?0`l33`<?0`l33`<?00;o00h33`<?0`l33`<?0`l33`Ko01433`<?0`l33`<?0`l33`<?
o`0900;o00<0ool00`000ol000020003o`0000X000ko3`<?0`l33`<?0`l33`Ko01l33`<?0`l33`<?
0`l33`<?0ol33`<?0`l33`<?0`l300Ko014?0`l33`<?0`l33`<?0`l3o`0900;o00<0ool00`000ol0
00020003o`0000X000oo0`l33`<?0`l33`<?0`l01_l04@<?0`l33`<?0`l33`<?0`oo00H00006000C
omH3eP?F0mH3eP?F0mH3eP?F0`04o`0<eP?F0mH3eP?F0mH30_l04mH3eP?F0mH3eP?F0mH3eP?F0mH0
1?l03P?F0mH3eP?F0mH3eP?o2002o`<01ol00`3oo`0<000Co`?F0mH3eP?F0mH3eP?F0mH3eP04o`0Q
0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH300Co00kF0mH3eP?F0mH3eP?Fo`P00_l300Oo
00<0ool030005?oF0mH3eP?F0mH3eP?F0mH3eP?F1?l03P?F0mH3eP?F0mH3eP?o1P0000H002?o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02o`0U0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`0S001:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0olS000Vo`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ol600001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o
02GF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02<004[o0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fob<0
02KoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000So`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l09@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33ol08`00B_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`?o8`009_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo1P0000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`0UeP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0S001:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_lS000VomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P008ol33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?00;o02D33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02<0
04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l3ob<002Ko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H0
0006000SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_l09MH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol08`00B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo8`009_oF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H002?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`02o`0U0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0S001:o`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0olS000Vo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P008ooF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o02GF0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o02<004[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FomH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fob<002KoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3o`H00006000So`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l0
0_l09@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol08`00B_l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o
8`009_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H002?oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`0UeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`0S001:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_lS000VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0ol600001P008ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o02D33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02<004[o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3ob<002Ko0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000SomH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP<00_l09MH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0
8`00B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mKo8`009_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
1P0000H002?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02o`0U0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0S001:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0olS000Vo`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH300;o02GF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02<004[o0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?Fob<002KoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H000060?oo
0Ol600001P000om<C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<
C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o90000ol0
000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o90000ol0000Q000VogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<
C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0
000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_l600001P000om<C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<
C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_l600001P000om<C00;C0?o4T`2ob@000?o00008@003_maOW5nLGiaOW5nLGia
0ol05G5nLGiaOW5nLGiaOW5nLGiaOW5no`0=C0?o4d`03_l33`<?0`l33`<?0`l30ol08P<?0`l33`<?
0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@h3o`0D3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<
C00>C003oda<00m<0_lT0003o`00024002KoO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_An
m7kdoa1<00?oC4`044`0B_oF0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/?n`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?oC4`02d`4o`9<0ol<C0;o2P001_l0
003o00Oo00<0ool02P000ol000070006o`000?l01ol00`3oo`0:000>og5nLGiaOW5nLGiaOW44o`0D
O_ooogiaOW5nLGiaOW5nLGiaO_l=C0Co0T`3o`e<00ko0`l33`<?0`l33`<?0`Co024?oooo3`<?0`l3
3`<?0`l33`?ol@ka3_4>l@ka3_4>l@h01?l04o4>oooa3_4>l@ka3_4>l@ka3_l01P0000H000?oC4`0
2T`01Om<C4co00=<00?oC4`02d`2o`X000Go0000o`030007o`000?l0o`0;0003o`0000L000Go0000
o`030007o`000?l0o`0;000VogkdO_Anm7kdO_Anm?odO_Com7kdO_mnm7kdO_Anm7kdO_Anm?l<C005
oda<C?l00d`00om<C00<C01:omH3eP?F0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[3o/0j`ok3o/0ko3[0>/0j`3[0>/0j`3_l600001P000om<C00:C006oda<C?m<1?l<C0;o
2P001Ol0o`3o00<000Co00000ol;0003o`0000L000Go0?l0o`030004o`0000?o2`009_maOW5nLGia
OW5nLGkoOW5nogiaOW7oLGiaOW5nLGiaOW5nLGko34`01_m<C4coC0Co3D`0B_l33`<?0`l33`<?0`oo
3`<?o`l33`?o0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kaoo4>lOoaoo4>o`ka3_4>l@ka3_4>l@ko
1P0000H000?oC4`02T`02Om<C4coC?m<o`0=C0;o2P001Ol0o`3o00<000Oo0000o`3o00/000?o0000
1`001Ol0o`3o00<000Oo0000o`3o00/001CoO_Anm7kdO_Anm7kdooAnm?odOP;o013dO_Anm7kdO_An
m7kdO_Co34`02Om<C4coC?m<o`0>C00ComH3eP?F0mH3eP?F0ol3eP?o0`03o`0R0mH3eP?F0mH3eP?F
0mKo/0j`3[0>/0j`3[0>/?n`3[3o/0?o00n`3[0>/0j`3[0>/0j`3_l01P0000H000?oC4`02d`6o`03
C?m<00a<0_l:00;o00<0ool00`000ol000020003o`0000X000?o00001`02o`030?oo00<000?o0000
0P000ol0000:000>og5nLGiaOW5nLGiaOW45o`0CLGiaog5nLGiaOW5nLGiaOW5no`0=C0Ko00=<od`0
3D`03_l33`<?0`l33`<?0`l31_l07`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@h01_l04O4>
l@ka3_4>l@ka3_4>l@ko00H000060003oda<015<0_l=C0;o2@02o`<01ol00`3oo`0<0003o`0000H0
0_l300Oo00<0ool030004omnm7kdO_Anm7kdO_Anm7kdO_@00ol04?Anm7kdO_Anm7kdO_Anm?lCC0;o
3T`04ooF0mH3eP?F0mH3eP?F0mH3eP<01?l08]H3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>
/0h3o`0>3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o
90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o90000ol0000Q000V
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l60000
1P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o
90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_l600001P000om<C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000V
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l60000
1P000om<C00PC0;o90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o
90000ol0000Q000VogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l600001P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000om<C00PC0;o90000ol0000Q000V
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l60000
1P000om<C00PC0;o90000ol0000Q000Vog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P3oo`7o1P0000H002?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02ob@000?o00008@000ol0000R0019ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003o`0000@0
0006000SooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_lT0003o`00024000?o0000
8P00BOodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l090000ol0000400001P008omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGia00;o90000ol0000Q0003o`00028004WoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02@000?o0000100000H0
02?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02ob@000?o00008@000ol0000R0019
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`0T0003o`0000@00006000SogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW400_lT0003o`00024000?o00008P00BOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P008ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o90000ol0000Q0003o`00028004Wom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mKo02@000?o0000100000H002?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
L@02ob@000?o00008@000ol0000R0019ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003o`0000@00006000SooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_lT0003o`00024000?o00008P00BOodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P008omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o
90000ol0000Q0003o`00028004WoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02@000?o0000100000H002?om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02ob@000?o00008@000ol0000R0019ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
o`0T0003o`0000@00006000SogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_lT0003
o`00024000?o00008P00BOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P008oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_An00;o90000ol0000Q0003o`00028004Wom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02@0
00?o0000100000H002?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02ob@000?o0000
8@000ol0000R0019ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003o`0000@00006000>ooAnm7kdO_Anm7kdO_@3o`0B
m7kdO_Anm7kdO_Anm7kdO_An0_lT0003o`00024000?o00008P003_odO_Anm7kdO_Anm7kd0ol08OAn
m7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP03o`0DeP?F0mH3eP?F0mH3eP?F0mH3e_lT0003
o`0000@00006000SogiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW400_lT0003o`000240
00?o00008P00BOmnLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l3
3`<?o`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P003_odO_Anm7kdO_Anm7kd1?l04Gko
oomnm7kdO_Anm7kdO_An00;o2P001_l0003o00Oo00<0ool02P000ol000070006o`000?l01ol00`3o
o`0:0003o`0000L000Ko0000o`07o`030?oo00/000kom7kdO_Anm7kdO_Anm0Co021nooooO_Anm7kd
O_Anm7kdO_CoeP?F0mH3eP?F0mH3ePCo01<3oooo0mH3eP?F0mH3eP?F0mKo00X000Ko0000o`07o`03
0?oo00X000?o0000100000H002?oOW5nLGiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW5nL@02o`X0
00Go0000o`030007o`000?l0o`0;0003o`0000L000Go0000o`030007o`000?l0o`0;0003o`0000L0
00Go0000o`030007o`000?l0o`0<0019ogiaOW5nLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGiaOW5n
o`<?0`l33`<?0`l33ol?0`oo3`<?0ol33`<?0`l33`<?0`l3o`0:0005o`000?l00`001ol0003o0?l0
2`000ol0000400001P008oodO_Anm7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdO_An00;o2P001Ol0
o`3o00<000Co00000ol;0003o`0000L000Go0?l0o`030004o`0000?o2`000ol000070005o`3o0?l0
0`001?l00003o``004Wom7kdO_Anm7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm7kdO_CoeP?F0mH3eP?F
0mH3o`?F0ol3eP?FomH3eP?F0mH3eP?F0mKo00X000Go0?l0o`030004o`0000?o2`000ol000040000
1P005?mnLGiaOW5nLGiaOW7oLGiaog5n0_l03G5nLGiaOW5nLGiaOW400_l:0005o`3o0?l00`001ol0
003o0?l02`000ol000070005o`3o0?l00`001ol0003o0?l02`000ol000070005o`3o0?l00`001ol0
003o0?l030005?mnLGiaOW5nLGiaOW7oLGiaog5n0_l08G5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l3
3ol?0`oo3`03o`0?3`<?0`l33`<?0`l33`?o00X000Go0?l0o`030007o`000?l0o`0;0003o`0000@0
0006000>ooAnm7kdO_Anm7kdO_@5o`0@m7kdooAnm7kdO_Anm7kdOP;o2P02o`030?oo00<000?o0000
0P000ol0000:0003o`0000L00_l00`3oo`030003o`00008000?o00002P000ol0000700;o00<0ool0
0`000ol000020003o`0000/000kom7kdO_Anm7kdO_Anm0Go01odO_Com7kdO_Anm7kdO_Anm?oF0mH3
eP?F0mH3eP?F00Ko0143eP?F0mH3eP?F0mH3eP?Fo`0:00;o00<0ool00`000ol000020003o`0000X0
00?o0000100000H001?oOW5nLGiaOW5nLGiaOW5nLGia00?o00eaOW5nLGiaOW5nLGia00;o2@02o`<0
1ol00`3oo`0<0003o`0000H00_l300Oo00<0ool030000ol0000600;o0`07o`030?oo00d001?oOW5n
LGiaOW5nLGiaOW5nLGia00?o025aOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l01?l03P<?
0`l33`<?0`l33`?o2@02o`<01ol00`3oo`0<0003o`0000@00006000SooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_lT0003o`00024000?o00008P00BOodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l090000ol0
000400001P008omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o90000ol0000Q0003
o`00028004WoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`?o02@000?o0000100000H002?om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02ob@000?o00008@000ol0000R0019ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@0
0006000SogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_lT0003o`00024000?o0000
8P00BOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ol090000ol0000400001P008oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o90000ol0000Q0003o`00028004Wom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02@000?o0000100000H0
02?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02ob@000?o00008@000ol0000R0019
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3o`0T0003o`0000@00006000SooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_lT0003o`00024000?o00008P00BOodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l090000ol0000400001P008omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o90000ol0000Q0003o`00028004WoOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o02@000?o0000100000H002?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02ob@000?o00008@000ol0000R0019ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@00006000SogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_lT0003o`00024000?o00008P00BOmnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0ol090000ol0000400001P008oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o
90000ol0000Q0003o`00028004Wom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02@000?o0000100000H002?oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02ob@000?o00008@000ol0000R0019ogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
o`0T0003o`0000@00006000SooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_lT0003
o`00024000?o00008P00BOodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l090000ol0000400001P008omnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGia00;o90000ol0000Q0003o`00028004WoOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02@0
00?o0000100000H0ool1o`H00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P008onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
0006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P008onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@00006000SoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H002?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P003_nOGimOWenOGimOWenO
0ol04YmOWenOGimOWenOGimOWenOG`;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H002?oWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOG`02ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@00006000>oimOWenO
GimOWenOGil4o`03Gooo00;o00bOGimOWenOGimOWel2o`X000Ko0000o`07o`030?oo00X000?o0000
1`001_l0003o00Oo00<0ool02P000ol000070006o`000?l01ol00`3oo`0;0003o`0000L000Ko0000
o`07o`030?oo00X000?o00001`001_l0003o00Oo00<0ool02P000ol000080006o`000?l01ol00`3o
o`0:0003o`0000@00006000SoimOWenOGimOWenOGomOWeooGiooWenOGimOWenOGimOWel00_l:0005
o`000?l00`001ol0003o0?l02`000ol000070005o`000?l00`001ol0003o0?l02`000ol000070005
o`000?l00`001ol0003o0?l030000ol000070005o`000?l00`001ol0003o0?l02`000ol000070005
o`000?l00`001ol0003o0?l02`000ol000080005o`000?l00`001ol0003o0?l02`000ol000040000
1P008onOGimOWenOGimOWeooGimOoenOGomOWenOGimOWenOGimO00;o2P001Ol0o`3o00<000Co0000
0ol;0003o`0000L000Go0?l0o`030004o`0000?o2`000ol000070005o`3o0?l00`001?l00003o``0
00?o00001`001Ol0o`3o00<000Co00000ol;0003o`0000L000Go0?l0o`030004o`0000?o2`000ol0
00080005o`3o0?l00`001?l00003o`/000?o0000100000H002?oWenOGimOWenOGimOoenOGomOWenO
oimOWenOGimOWenOG`02o`X000Go0?l0o`030007o`000?l0o`0;0003o`0000L000Go0?l0o`030007
o`000?l0o`0;0003o`0000L000Go0?l0o`030007o`000?l0o`0<0003o`0000L000Go0?l0o`030007
o`000?l0o`0;0003o`0000L000Go0?l0o`030007o`000?l0o`0;0003o`0000P000Go0?l0o`030007
o`000?l0o`0;0003o`0000@00006000>oimOWenOGimOWenOGil6o`0?GiooWenOGimOWenOGimO00;o
2P02o`030?oo00<000?o00000P000ol0000:0003o`0000L00_l00`3oo`030003o`00008000?o0000
2P000ol0000700;o00<0ool00`000ol000020003o`0000/000?o00001`02o`030?oo00<000?o0000
0P000ol0000:0003o`0000L00_l00`3oo`030003o`00008000?o00002P000ol0000800;o00<0ool0
0`000ol000020003o`0000X000?o0000100000H001CoWenOGimOWenOGimOWenOGimOW`;o00eOWenO
GimOWenOGimO00;o2@02o`<01ol00`3oo`0<0003o`0000H00_l300Oo00<0ool030000ol0000600;o
0`07o`030?oo00d000?o00001P02o`<01ol00`3oo`0<0003o`0000H00_l300Oo00<0ool030000ol0
000700;o0`07o`030?oo00`000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
0006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P008onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@00006000SoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H002?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P008onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@00006000SoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
ool1o`H000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO023O0_lT0003o`000240
00?o00008P000ol0000Q000Uo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003
o`0000@000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO023O0_lT0003o`000240
00?o00008P000ol0000Q000Uo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003
o`0000@000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO023O0_lT0003o`000240
00?o00008P000ol0000Q000Uo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003
o`0000@000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO023O0_lT0003o`000240
00?o00008P000ol0000Q000Uo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003
o`0000@000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO023O0_lT0003o`000240
00?o00008P000ol0000Q000Uo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003
o`0000@000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO023O0_lT0003o`000240
00?o00008P000ol0000Q000Uo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0T0003
o`0000@000060003omoO023O0_lT0003o`00024000?o00008P000ol0000Q000UomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO00_O0olBg`;o90000ol0
000Q0003o`00028000?o00008@003_l33`<?0`l33`<?0`l30ol050<?0`l33`<?0`l33`<?0`l33`?o
90000ol0000400001P000ooOg`0>g`03omoO00oO0_lT0003o`00024000?o00008P000ol0000Q000U
omH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?Fo`0T0003o`0000@000060003omoO00_O
1?l01=ooool=g`;o2P001_l0003o00Oo00<0ool02P000ol000070006o`000?l01ol00`3oo`0:0003
o`0000L000Ko0000o`07o`030?oo00/000?o00001`001_l0003o00Oo00<0ool02P003_l33`<?0`l3
3`<?0`l31?l04`ooool?0`l33`<?0`l33`<?0ol02P001_l0003o00Oo00<0ool02P000ol000040000
1P000ooOg`0:g`05omoOgol00]l00ooOg`0<g`;o2P001Ol0003o00<000Oo0000o`3o00/000?o0000
1`001Ol0003o00<000Oo0000o`3o00/000?o00001`001Ol0003o00<000Oo0000o`3o00`000?o0000
1`001Ol0003o00<000Oo0000o`3o00/002GoeP?F0mH3eP?F0mH3o`?F0ol3eP?FomH3eP?F0mH3eP?F
0mKo00X000Go0000o`030007o`000?l0o`0;0003o`0000@000060003omoO00[O00GogmoOo`02g`03
omoO00cO0_l:0005o`3o0?l00`001?l00003o`/000?o00001`001Ol0o`3o00<000Co00000ol;0003
o`0000L000Go0?l0o`030004o`0000?o30000ol000070005o`3o0?l00`001?l00003o`/002Go0`l3
3`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0`l33`?o00X000Go0?l0o`030004o`0000?o2`000ol0
000400001P000ooOg`0:g`05omoOgol00]l00ooOg`0<g`;o2P001Ol0o`3o00<000Oo0000o`3o00/0
00?o00001`001Ol0o`3o00<000Oo0000o`3o00/000?o00001`001Ol0o`3o00<000Oo0000o`3o00`0
00?o00001`001Ol0o`3o00<000Oo0000o`3o00/001?oeP?F0mH3eP?F0mH3o`?F0ol300?o00l3eP?F
0mH3eP?F0mH3e_l02P001Ol0o`3o00<000Oo0000o`3o00/000?o0000100000H000?ogml02ml5o`03
gooO00gO0_l:00;o00<0ool00`000ol000020003o`0000X000?o00001`02o`030?oo00<000?o0000
0P000ol0000:0003o`0000L00_l00`3oo`030003o`00008000?o00002`000ol0000700;o00<0ool0
0`000ol000020003o`0000X000ko0`l33`<?0`l33`<?0`Ko014?0`l33`<?0`l33`<?0`l3o`0:00;o
00<0ool00`000ol000020003o`0000X000?o0000100000H000?ogml04=l2o`kO0_l900;o0`07o`03
0?oo00`000?o00001P02o`<01ol00`3oo`0<0003o`0000H00_l300Oo00<0ool03@000ol0000600;o
0`07o`030?oo00`001?oeP?F0mH3eP?F0mH3eP?F0mH300Co00kF0mH3eP?F0mH3eP?Fo`T00_l300Oo
00<0ool030000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001P000ooOg`0Pg`;o90000ol0000Q0003o`00028000?o00008@009Ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol090000ol0000400001P000ooOg`0Pg`;o
90000ol0000Q0003o`00028000?o00008@009OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l090000ol0000400001@3oo`;o1P0000D0ool2o`H000060003o`0001l00olTg`1:oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ol0000N0004o`3oobCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003o`0001d000?o00000_lTg`1:oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ol0000L0004o`0000;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o00006`000ol0000200;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?o00006P000ol0000300;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o00006@000ol0000400;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?o000060000ol0000500;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o00001P02o`030?oo00`000?o00001P02obCO04[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003o`0000L000?o0?l030000ol0000700;o
9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o000020000ol0000:0003
o`0000P00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ol000070003
o`3o00X000?o00002@02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003
o`0000H00_l00`3oo`080003o`0000X00_l>g`?o4ml03_mOWenOGimOWenOGimO0ol08EnOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nL@03o`0ELGiaOW5nLGiaOW5nLGiaOW5nLGko00e<0olCC00>
o`<?0`l33`<?0`l33`<3o`0R0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3P?o01@>l@ka
3_4>l@ka3_4>l@ka3_4>o`H000060003o`00018000?o00002`02oa7O00?ogml04=l0B_mOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_An
m7kdO_Co44`00om<C00@C01:omH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0j`ok0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ol0000A0003o`0000`00_l>g`Co
00COoooo3]l03_mOWenOGimOWenOGimO1?l00iooo`02o`0KGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGia00Co01AnooooOW5nLGiaOW5nLGiaOW5no`e<1?l2C0?o3D`03_l33`<?0`l33`<?0`l31?l08@oo
ool?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3P04o`0Cl@kooo4>l@ka3_4>l@ka3_4>o`060000
1P000ol0000@0003o`0000d00_l=g`05omoOgol00]l00ooOg`0=g`1:oenOGimOWenOGimOWonOGioo
WeooGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?odO_Com7kdO_mnm7kdO_Anm7kdO_Anm?l<C005
oda<C?l00d`00om<C00<C01:omH3eP?F0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[3o/0j`ok3o/0ko3[0>/0j`3[0>/0j`3_l600001P000ol0000?0003o`0000h00_l=g`05
omoOgol00]l00ooOg`0=g`1:oenOGimOWenOGimOWonOGiooWenOoimOWenOGimOWenOGimOog5nLGia
OW5nLGiaO_mnLGkoOW5nLOmaOW5nLGiaOW5nLGiaO_l<C006oda<C?m<1?l=C01:o`<?0`l33`<?0`l3
3ol?0`oo3`<?0ol33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_7ol@kaoo7ol@ko3_4>l@ka3_4>l@ka
3_l600001P000ol0000>0003o`0000l00_l=g`05omoOgol00]l00ooOg`0=g`0hoenOGimOWenOGimO
WonOGiooWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?odO_Com7h2o`0@m7kdO_Anm7kdO_An
m7kdo`a<00WoC4a<odcoC?l03T`04ooF0mH3eP?F0mH3eP?o0mH3o`<00ol08P?F0mH3eP?F0mH3eP?F
ok0>/0j`3[0>/0j`3[3o/0j`ok03o`0?/0j`3[0>/0j`3[0>/0ko00H000060003o`0000d000?o0000
4002o`kO1Ol00moog`0>g`0>oenOGimOWenOGimOWel6o`0NWeooGimOWenOGimOWenOGomaOW5nLGia
OW5nLGia1Ol04g5nLOmaOW5nLGiaOW5nLGiaO_l03D`6o`03C?m<00e<00ko0`l33`<?0`l33`<?0`Ko
01l?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>00Ko017a3_4>l@ka3_4>l@ka3_4>o`060000
1P000ol0000<0003o`0000H00ol800;o4ml2o`oO01CoGimOWenOGimOWenOGimOWenOG`;o026OGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_@00ol04?Anm7kdO_Anm7kdO_Anm?lCC0;o3T`04ooF
0mH3eP?F0mH3eP?F0mH3eP<01?l08]H3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0h3o`0>
3[0>/0j`3[0>/0j`3_l600001P000ol0000;0003o`0000P000?o00001`02obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003o`0000X000?o00002P000ol0000600;o9=l0B_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o00002@000ol0000;0003o`0000H0
0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ol000080003o`0000/0
00?o0?l01`02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003o`0000L0
00?o000030000ol0o`0700;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H0
00?o00001P000ol0000<00;o00<0ool01P02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>o`H000060003o`0000D000?o00006002obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>o`H000060003o`0000@000?o00006@02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>o`H000060003o`0000<000?o00006P02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>o`H000060003o`00008000?o00006`02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>o`H000060005o`000?l07P02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H0
00060004o`00oal00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ol0
o`0P00;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H00_lQ00;o9=l0B_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0ool1o`H0000Y00;oh@000?l03@000?l0
3@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@0003001?o900?o3000034000?o0000bP000ol0000;00002003o`800_l00`3oo`0200Co
00<0ool00_l200Co0`03o`801Ol00`3oo`02ok000_l00`3oo`090003o`3o00T000?o00002P0000T0
00Go0000o`020004o`00o`@000Go0000o`030003o`00008000Oo0000o`3o008000Co003o0`000ol0
002^0003o`3o00/000?o000020000ol0000:00002@001Ol0003o008000?o00001_l0103oool30003
o`00008000Oo0000o`3o008000Co003o0`000ol0002_0003o`0000P01Ol70003o`3o00/000070007
o`3o0?l0o`020004o`00o`<00_l700;o0`001ol0003o0?l00P001?l00?l30003o`000:h000?o0?l0
2`000ol000070003o`3o00/000070006o`3o0?l01?l300?o00<0o`000P000ol00002o`030?oo0080
0ol0103oo`02o`030?oo00?o/002o`030?oo01<00_l00`3oo`0:00001`05o`030?l000X01?o_0000
3002ooh0003o00d0003o00d00000\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \({{{1, 2, 1}, {1, 2, 2}, {2, 1, 1}, {2, 2, 3}, {3, 1, 2}, {3, 2, 3}}, {{
          1, 2, 2}, {1, 3, 1}, {2, 1, 2}, {2, 3, 2}, {3, 1, 1}, {3, 2, 2}}, {{
          2, 1, 1}, {2, 1, 2}, {2, 1, 1}, {2, 1, 3}, {3, 1, 2}, {3, 1, 3}}, {{
          2, 2, 3}, {2, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 1}}, {{
          3, 1, 2}, {3, 1, 1}, {3, 1, 2}, {3, 1, 2}, {3, 1, 1}, {3, 1, 2}}, {{
          3, 2, 3}, {3, 2, 2}, {3, 1, 3}, {3, 2, 1}, {3, 1, 2}, {3, 2, 1}}}
      \)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell["\<\
While the Cayley table makes it clear that this is not a group, we \
can also ask whether it is.\
\>", "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupQ[G4]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "When forming a groupoid, if it is known that the structure is a group, we \
can specify it by using the ",
  StyleBox["IsAGroup", "MR"],
  " option. This may save time for future operations that require testing \
whether the structure is indeed a group."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Timing[
        GroupQ[FormGroupoid[{1, \ \(-1\), \ I, \ \(-I\)}, \ Times, \ 
            IsAGroup\  \[Rule] \ True]]], \n
      Timing[GroupQ[FormGroupoid[{1, \ \(-1\), \ I, \ \(-I\)}, \ Times]]]}
      \)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \({{0.133333333333332859`\ Second, True}, {0.350000000000001421`\ Second, 
        True}}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "When a groupoid is formed and ",
  StyleBox["WideElements", "MR"],
  " is set to ",
  StyleBox["True", "MR"],
  ", we may also wish to consider the form the key should take. Usually the \
default of ",
  StyleBox["InputForm", "MR"],
  " works well, though occasionally ",
  StyleBox["OutputForm", "MR"],
  " is better."
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G5\  = \ 
      FormGroupoid[{{{1, 0}, {0, 1}}, {{1, 0}, {0, 2}}, {{1, 0}, {0, 3}}, {{
              1, 0}, {0, 4}}, {{4, 0}, {0, 1}}, {{4, 0}, {0, 2}}, {{4, 0}, {
              0, 3}}, {{4, 0}, {0, 4}}}, \ Mod[#1 . #2, \ 5]&, \ 
        WideElements\  \[Rule] \ True, \ KeyForm\  \[Rule] \ TeXForm]\)], 
  "Input",
  CellLabel->"In[16]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \(Groupoid[{{{1, 0}, {0, 1}}, {{1, 0}, {0, 2}}, {{1, 0}, {0, 3}}, {{1, 
            0}, {0, 4}}, {{4, 0}, {0, 1}}, {{4, 0}, {0, 2}}, {{4, 0}, {0, 
            3}}, {{4, 0}, {0, 4}}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "Rarely would we use ",
  StyleBox["KeyForm \[Rule]", "MR"],
  " ",
  StyleBox["MatrixForm", "MR"],
  ", even if matrices are involved; ",
  StyleBox["TeXForm", "MR"],
  " is even worse. Is ",
  StyleBox["G5", "MR"],
  " a group? If so, to what group is it isomorphic?"
}], "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[G5, \ Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"FormGroupoid"],

Cell[BoxData[
    \("KEY for TheGroup: label used \[Rule] element: {g1 \[Rule] \\{ \\{ \
1,0\\} ,\\{ 0,1\\} \\} , g2 \[Rule] \\{ \\{ 1,0\\} ,\\{ 0,2\\} \\} , g3 \
\[Rule] \\{ \\{ 1,0\\} ,\\{ 0,3\\} \\} , g4 \[Rule] \\{ \\{ 1,0\\} ,\\{ \
0,4\\} \\} , g5 \[Rule] \\{ \\{ 4,0\\} ,\\{ 0,1\\} \\} , g6 \[Rule] \\{ \\{ \
4,0\\} ,\\{ 0,2\\} \\} , g7 \[Rule] \\{ \\{ 4,0\\} ,\\{ 0,3\\} \\} , g8 \
\[Rule] \\{ \\{ 4,0\\} ,\\{ 0,4\\} \\} }"\)], "Print",
  CellTags->"FormGroupoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 .5 0 r
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.56 .37 .6 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
0 0 1 r
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.74 .99 .79 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.251 .878 .816 r
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .79 .34 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
0 .392 0 r
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g2)] .28836 .81878 0 0 Mshowa
[(g3)] .39418 .81878 0 0 Mshowa
[(g4)] .5 .81878 0 0 Mshowa
[(g5)] .60582 .81878 0 0 Mshowa
[(g6)] .71164 .81878 0 0 Mshowa
[(g7)] .81746 .81878 0 0 Mshowa
[(g8)] .92328 .81878 0 0 Mshowa
[(g2)] .18254 .71296 0 0 Mshowa
[(g4)] .28836 .71296 0 0 Mshowa
[(g1)] .39418 .71296 0 0 Mshowa
[(g3)] .5 .71296 0 0 Mshowa
[(g6)] .60582 .71296 0 0 Mshowa
[(g8)] .71164 .71296 0 0 Mshowa
[(g5)] .81746 .71296 0 0 Mshowa
[(g7)] .92328 .71296 0 0 Mshowa
[(g3)] .18254 .60714 0 0 Mshowa
[(g1)] .28836 .60714 0 0 Mshowa
[(g4)] .39418 .60714 0 0 Mshowa
[(g2)] .5 .60714 0 0 Mshowa
[(g7)] .60582 .60714 0 0 Mshowa
[(g5)] .71164 .60714 0 0 Mshowa
[(g8)] .81746 .60714 0 0 Mshowa
[(g6)] .92328 .60714 0 0 Mshowa
[(g4)] .18254 .50132 0 0 Mshowa
[(g3)] .28836 .50132 0 0 Mshowa
[(g2)] .39418 .50132 0 0 Mshowa
[(g1)] .5 .50132 0 0 Mshowa
[(g8)] .60582 .50132 0 0 Mshowa
[(g7)] .71164 .50132 0 0 Mshowa
[(g6)] .81746 .50132 0 0 Mshowa
[(g5)] .92328 .50132 0 0 Mshowa
[(g5)] .18254 .3955 0 0 Mshowa
[(g6)] .28836 .3955 0 0 Mshowa
[(g7)] .39418 .3955 0 0 Mshowa
[(g8)] .5 .3955 0 0 Mshowa
[(g1)] .60582 .3955 0 0 Mshowa
[(g2)] .71164 .3955 0 0 Mshowa
[(g3)] .81746 .3955 0 0 Mshowa
[(g4)] .92328 .3955 0 0 Mshowa
[(g6)] .18254 .28968 0 0 Mshowa
[(g8)] .28836 .28968 0 0 Mshowa
[(g5)] .39418 .28968 0 0 Mshowa
[(g7)] .5 .28968 0 0 Mshowa
[(g2)] .60582 .28968 0 0 Mshowa
[(g4)] .71164 .28968 0 0 Mshowa
[(g1)] .81746 .28968 0 0 Mshowa
[(g3)] .92328 .28968 0 0 Mshowa
[(g7)] .18254 .18386 0 0 Mshowa
[(g5)] .28836 .18386 0 0 Mshowa
[(g8)] .39418 .18386 0 0 Mshowa
[(g6)] .5 .18386 0 0 Mshowa
[(g3)] .60582 .18386 0 0 Mshowa
[(g1)] .71164 .18386 0 0 Mshowa
[(g4)] .81746 .18386 0 0 Mshowa
[(g2)] .92328 .18386 0 0 Mshowa
[(g8)] .18254 .07804 0 0 Mshowa
[(g7)] .28836 .07804 0 0 Mshowa
[(g6)] .39418 .07804 0 0 Mshowa
[(g5)] .5 .07804 0 0 Mshowa
[(g4)] .60582 .07804 0 0 Mshowa
[(g3)] .71164 .07804 0 0 Mshowa
[(g2)] .81746 .07804 0 0 Mshowa
[(g1)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(TheGroup)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{272.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l04@000?l04@000?l04@000?l04@000?l0
4@000?l04@000?l04@0000H0ool5o`H00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o
07=@T52@D91@T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?oa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o01a<
03[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
7=l00ol0000400001P000om@D00ID0;o7500EooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0LC00j
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO
00?o0000100000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_l0Le2@D91@T52@D91@T52@
D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ko3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol074`0>_maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@000060003
oe1@01U@0_lLD01Gon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo01a<03[oO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?n@
D91@T52@D91@T52@D91@T52@D91@T52@D902o`1cD91@T52@D91@T52@D91@T52@D91@T52@D91@T?nP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0LC00jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H000?oD5006E02oaa@05Ooh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Pok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l074`0>_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000Loi1@T52@D91@T52@D91@T52@
D91@T52@D91@T0;o07=@T52@D91@T52@D91@T52@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o01a<03[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo7=l00ol0000400001P000om@D00ID0;o7500EooPX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>3o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fo`0LC00jogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoacO00?o0000100000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_l0Le2@
D91@T52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol074`0>_ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03
o`0000@000060003oe1@01U@0_lLD01Gon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo01a<03[oO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0
000400001P002_n@D91@T52@D903o`0?T52@D91@T52@D91@T52@00;o00U@T52@D91@T5000ol06U2@
D91@T52@D91@T52@D93oX>2Ph:3PX>2P0ol06Z3PX>2Ph:3PX>2Ph:3PX?oa3_4>l@ka3_4>0ol06@ka
3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l00ol04@l33`<?0`l33`<?0`l33`?o00U<0ol@C00:og5nLGia
OW5nL@?o01YaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOW`?o012OGimOWenOGimOWenOGioo2Ml3oa3O
00?o0000100000H000?oD5002U000om@D00<D0;o35000om@D00=D01Gon2Ph:3PX>2Ph:3PX?nPh:3P
X>2Ph:3PX>2Ph?n`3[0>/0j`3[0>/0j`ok0>/0j`3[0>/0j`3[0>o`?F0mH3eP?F0mH3e_oF0mH3eP?F
0mH3eP?F0mKo00a<00?oC4`03D`0>_mnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7koGimOWenOGimO
WenOGomOWenOGimOWenOGimOWol<g`03omoO00gO00?o0000100000H000[oT52@D91@T52@1?l03U2@
oom@T52@D91@T52@0_l02E2@D91@T52@D004o`0IT53ooi1@T52@D91@T52@oj3PX>2Ph:3PX004o`0I
h:3oX>2Ph:3PX>2Ph:3ol@ka3_4>l@ka3P04o`0Hl@kooo4>l@ka3_4>l@ko3`<?0`l33`<?1?l040?o
ool33`<?0`l33`<?0ol9C0Co0T`3o`Y<00[oLGiaOW5nLGia1?l06GkooomnLGiaOW5nLGiaoenOGimO
WenOGil01?l00eooo`02o`0:WenOGimOWenOo`WO1?l01=ooool;g`03o`0000@000060003oe1@00I@
00OoD51@oe3o009@00?oD5001e02o`Q@00OoD51@oe3o009@00?oD5002500EooPX>2Ph:3PX?nPh:3o
X>3oh:3PX>2Ph:3PX>3o/0j`3[0>/0j`ok0>/?n`ok0>o`j`3[0>/0j`3_l3eP?F0mH3e_oF0mKoeP?F
0ol3eP?F0mH3eP?Fo`08C005oda<C?l00d`00om<C009C00jogkdO_Anm7kdooAnm?odO_AnogkdO_An
m7kdO_mOWenOGimOWeooGimOoenOoimOWenOGimOWenOo`SO00GogmoOo`02g`03omoO00[O00?o0000
100000H001coT52@D91@T53oD91@oe3oD93oT52@D91@T52@0_l0Le2@D91@T52@oi1@T?n@oi1@oe2@
D91@T52@D93oX>2Ph:3PX>3oh:3Pon2Ph?oPX>2Ph:3PX>2Poo4>l@ka3_4>lOoa3_7olOoa3_l>l@ka
3_4>l@ko3`<?0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?0ol024`01_m<C4coC0Co2T`0>_maOW5nLGia
O_mnLGkoOW5nLOmaOW5nLGiaOW7oGimOWenOGimOoenOGomOWeooGimOWenOGimOWol8g`05omoOgol0
0]l00ooOg`0:g`03o`0000@000060003oe1@00I@00GoD51@o`02D0;o2U02o`Q@00GoD51@o`02D0;o
2e00;?oPX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>3o/0j`3[0>/0j`ok0>/?n`0ol06K0>/0j`3[0>
/0ko0mH3eP?F0mKoeP?FomH00ol03=H3eP?F0mH3eP?Fo`Q<00WoC4a<odcoC?l02d`04?mnm7kdO_An
m?odO_Com7h2o`0Xm7kdO_Anm7kdO_mOWenOGimOWeooGimOoenOGiooWenOGimOWenOo`SO00GogmoO
o`02g`03omoO00[O00?o0000100000H000[oT52@D91@T52@1_l0352@oi1@T52@D91@T0;o00U@T52@
D91@T5001_l05i1@oe2@D91@T52@D93oX>2Ph:3PX>2P00Go01RPh:3oX>2Ph:3PX>2Poo4>l@ka3_4>
l@h6o`0Fl@ka3_4>l@ka3_4>o`l33`<?0`l33`Ko00h33`<?0`l33`<?0`l3o`U<1_l00dcoC00:C00:
og5nLGiaOW5nL@Go01QaOW7oLGiaOW5nLGiaoenOGimOWenOGil6o`0=GiooWenOGimOWenOo`09g`Go
00?Ooml02ml00ol0000400001P000om@D00=D0;o2U02o`m@0_l;D00?on2Ph:3PX>2Ph:3PX>2P00Co
01[PX>2Ph:3PX>3o/0j`3[0>/0j`3[0>/0j`3P?o01P>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH4o`0;
0mH3eP?F0mH3e_l03d`2o`]<00ooO_Anm7kdO_Anm7kdO_@00ol06oAnm7kdO_Anm7koGimOWenOGimO
WenOGimOW`02o`0;GimOWenOGimOWol03]l2o`cO00?o0000100000H001coT52@D91@T52@D91@T52@
D91@T52@D91@T52@0_l0Le2@D91@T52@D91@T52@D91@T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0ol074`0>_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWolLg`03o`0000@000060003oe1@01U@0_lLD01Gon2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mKo01a<03[oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo7=l00ol0000400001P007?n@D91@T52@D91@T52@D91@T52@D91@T52@D902o`1c
D91@T52@D91@T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3ol@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0LC00j
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO
00?o0000100000H000?oD5006E02oaa@05Ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Pok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l074`0>_mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03
o`0000@00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o07=@T52@D91@T52@D91@T52@
D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?oa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o01a<03[oLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P000om@
D00ID0;o7500EooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0LC00jogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H001coT52@
D91@T52@D91@T52@D91@T52@D91@T52@0_l0Le2@D91@T52@D91@T52@D91@T52@D91@T52@D93oX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko3`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0ol074`0>_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@000060003oe1@01U@0_lLD01Gon2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mKo01a<03[oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?n@D91@T52@D91@T52@D91@T52@
D91@T52@D902o`1cD91@T52@D91@T52@D91@T52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`0LC00jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoacO00?o0000100000H000?oD5006E02oaa@05Ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Pok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l074`0>_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolLg`03o`0000@000060?oo1Ol600001P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>02o`0iX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo01a@03_o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?odO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Ano`0Kg`03oda<01Y<01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:02o`2@h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6ml00om<
C00JC00NoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H001coh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3P0_l0>J3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`0LD00ko`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3om7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l06ml00om<C00JC00NoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
1P0000H001coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P0_l0T>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@
D91@T53o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa_O00?oC4`06T`07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000Lon2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o03VPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l07500>ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01_O00?oC4`06T`07_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOo`H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o093PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Po`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0on@D91@T52@D91@T52@
D91@T52@D91@T52@D91@o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlKg`03oda<01Y<01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol60000
1P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>02o`0iX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo01a@03_o3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0Kg`03oda<01Y<01koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGol600001P007?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:02o`2@
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@
D91@T52@D91@T52@D91@T52@D91@T52@D?l>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6ml00om<C00JC00NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo1P0000H001coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P0_l0>J3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0LD00ko`j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[3om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l06ml00om<C00JC00N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H001coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2P0_l0T>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa_O00?oC4`06T`07_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOo`H00006000:on2Ph:3PX>2Ph0?o00oPX>2Ph:3PX>2Ph:3PX>000_l02J3P
X>2Ph:3PX003o`0JX>2Ph:3PX>2Ph:3PX>2Ph?oF0mH3eP?F0mH3o`0@eP?F0mH3eP?F0mH3eP?Fo`Y@
0ol?D00:o`j`3[0>/0j`3P?o01X>/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm0?o017dO_Anm7kdO_An
m7kdO_Ano`09g`?o3ml00om<C008C0?o3d`02_nOGimOWenOGil3o`0AWenOGimOWenOGimOWenOGol0
1P0000H001coX>2Ph:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX>2P0_l0T>2Ph:3PX>2Ph:3PX?nPh:3PX>2P
h:3PX>2Ph:3o0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D93oT52@D91@T52@
D91@T53o3_4>l@ka3_4>l@kaoo4>l@ka3_4>l@ka3_4>lOmnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5n
LGiao`cO00?ogml03=l00om<C00;C003oda<00a<01koWenOGimOWenOGimOoenOGimOWenOGimOWenO
Gol600001P002_oPX>2Ph:3PX>04o`0>X>3oh:3PX>2Ph:3PX>02o`09X>2Ph:3PX>2P00Co01WPX?nP
h:3PX>2Ph:3PX>3oeP?F0mH3eP?F00Co00l3oooo0mH3eP?F0mH3e_l02U04o`9@0_l:D00:o`j`3[0>
/0j`3PCo01V`3_oo/0j`3[0>/0j`3[3om7kdO_Anm7kd00Co011nooooO_Anm7kdO_Anm7ko2Ml4o`04
goooo`[O00?oC4`024`4o`9<0ol9C00:oimOWenOGimOW`Co00=Oool00_l02imOWenOGimOWeoo00H0
0006000Loj3PX>2Ph:3Pon2Ph?oPX?nPh:3PX>2Ph:3PX0;o093PX>2Ph:3PX?nPh:3oX>3oh:3PX>2P
h:3PX>2Po`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0on@D91@T52@D93oT52@oi3oT53oD91@T52@
D91@o`ka3_4>l@kaoo4>lOoaoo4>o`ka3_4>l@ka3_7oOW5nLGiaOW7oLGiaog5nLGkoOW5nLGiaOW5n
LOl8g`05omoOgol00]l00ooOg`09g`03oda<00M<00GoC4a<o`03C003oda<00Q<01koWenOGimOWeoo
GimOoenOoimOWenOGimOWenOGol600001P007?oPX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>02o`0i
X>2Ph:3PX>3oh:3Pon2Ph?oPX>2Ph:3PX>2Ph?oF0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mKo00U@
00OoD51@oe3o009@00?oD5001e00>ol>/0j`3[0>/?n`3[3o/?n`3_l>/0j`3[0>/0j`ooAnm7kdO_An
ogkdO_mnm7kdooAnm7kdO_Anm7ko00SO00GogmoOo`02g`03omoO00WO00?oC4`01d`01_m<C4coC0Co
2D`07_nOGimOWenOGomOWeooGimOoenOGimOWenOGimOo`H00006000Loj3PX>2Ph:3Pon2Ph?oPX>3o
h:3PX>2Ph:3PX0;o02_PX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>2Po`<?0`l33`<?o`l33ol?00?o
01/?0`l33`<?0`l3oi1@T52@D91@T?n@D93oT5000_l06I1@T52@D91@T53o3_4>l@ka3_7ol@kaoo40
0ol06o4>l@ka3_4>l@kaogiaOW5nLGiaog5nLOmaOP02o`0<LGiaOW5nLGiaOW7o2=l01OoOgmoo00;O
00?ogml02Ml00om<C007C009oda<C?m<odco00Y<01koWenOGimOWeooGimOoenOGiooWenOGimOWenO
Gol600001P002_oPX>2Ph:3PX>05o`0=h:3Pon2Ph:3PX>2Ph002o`09X>2Ph:3PX>2P00Go01RPh:3o
X>2Ph:3PX>2Ph?oF0mH3eP?F0mH6o`0=0mH3eP?F0mH3eP?Fo`0:D0Ko0U000om@D007D00:o`j`3[0>
/0j`3PKo01N`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm005o`0?m7kdooAnm7kdO_Anm7ko00WO1Ol00moo
g`0:g`03oda<00Q<1_l00dcoC009C00:oimOWenOGimOW`Ko00iOWonOGimOWenOGimOo`H00006000?
oj3PX>2Ph:3PX>2Ph:3P00Co00VPh:3PX>2Ph:000_l03^2Ph:3PX>2Ph:3PX>2P1?l06N2Ph:3PX>2P
h:3o0`l33`<?0`l33`<?0`l01?l06P<?0`l33`<?0on@D91@T52@D91@T52@D91@0_l06Y1@T52@D91@
T53o3_4>l@ka3_4>l@ka3_4>0ol06@ka3_4>l@ka3_7oOW5nLGiaOW5nLGiaOW400ol0375nLGiaOW5n
LGiao`kO0_l;g`03oda<00i<0_l:C00@oimOWenOGimOWenOGimOW`;o00aOWenOGimOWenOGol60000
1P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>02o`0iX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo01a@03_o3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0Kg`03oda<01Y<01koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGol600001P007?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:02o`2@
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@
D91@T52@D91@T52@D91@T52@D91@T52@D?l>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6ml00om<C00JC00NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo1P0000H001coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P0_l0>J3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0LD00ko`j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[3om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l06ml00om<C00JC00N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H001coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2P0_l0T>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa_O00?oC4`06T`07_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOo`H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o03VPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l07500>ol>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01_O
00?oC4`06T`07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000Loj3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX0;o093PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0on@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_7oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlKg`03oda<01Y<01koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>02o`0iX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo01a@03_o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?odO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Ano`0Kg`03oda<01Y<01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:02o`2@h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6ml00om<
C00JC00NoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H001coh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3P0_l0>J3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`0LD00ko`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3om7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l06ml00om<C00JC00NoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
1P0000H001coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P0_l0T>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oi1@T52@D91@T52@D91@T52@D91@T52@
D91@T53o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa_O00?oC4`06T`07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H000060?oo1Ol60000
1P007?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_42o`2@3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOn@D91@T52@D91@T52@D91@T52@D91@T52@D93o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
6d`00ooOg`0Jg`0NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o1P0000H001co/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`0_l07@j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o01]@05SoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo6d`00ooOg`0Jg`0NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko1P0000H001col@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka0_l0T0ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_7oT52@D91@T52@D91@T52@D91@T52@D91@T52@o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoa]<00?ogml06]l07_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H00006000L
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o01d>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
o`0KD01HomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa]<00?ogml06]l07_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Ano`H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o090>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoi1@T52@D91@T52@D91@T52@D91@T52@D91@T?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolKC003omoO01[O01koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl600001P007?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[02o`0M3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/?l06e00F?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolKC003omoO01[O01kom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l600001P007?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_42o`2@3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@D91@T52@D91@T52@
D93o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo6d`00ooOg`0Jg`0NogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o1P0000H001co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`0_l07@j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[3o01]@05SoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo6d`00ooO
g`0Jg`0NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H001col@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka0_l0T0ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oT52@D91@T52@D91@T52@
D91@T52@D91@T52@o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa]<00?ogml06]l07_mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiao`H00006000:ok0>/0j`3[0>/0?o00n`3[0>/0j`3[0>/0j`3[00
0_l02@j`3[0>/0j`3P03o`0A3[0>/0j`3[0>/0j`3[0>/?l02E03o`m@00_oeP?F0mH3eP?F0`03o`0I
0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX003o`0JX>2Ph:3PX>2Ph:3PX>2Ph?nOGimOWenOGil3o`0A
WenOGimOWenOGimOWenOGol02D`3o`m<00?ogml02=l3o`oO00[om7kdO_Anm7kd0ol04OAnm7kdO_An
m7kdO_Anm7ko00H00006000Loo4>l@ka3_4>l@ka3_l>l@ka3_4>l@ka3_4>l@;o090>l@ka3_4>l@ka
3_7ol@ka3_4>l@ka3_4>l@kaoi1@T52@D91@T52@D?m@T52@D91@T52@D91@T?l33`<?0`l33`<?0`l3
o`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX?nPh:3PX>2Ph:3PX>2Ph:3oWenOGimOWenOGimOoenO
GimOWenOGimOWenOGol<C003oda<00a<00?ogml02ml00ooOg`0<g`0NogiaOW5nLGiaOW5nLOmaOW5n
LGiaOW5nLGiaOW7o1P0000H000[o/0j`3[0>/0j`1?l03Pj`ool>/0j`3[0>/0j`0_l02@j`3[0>/0j`
3P04o`0@/0kook0>/0j`3[0>/0j`o`U@1?l2D0;o2U002ooF0mH3eP?F0mH300Co01SFooooeP?F0mH3
eP?F0onPh:3PX>2Ph:04o`0Ih:3oX>2Ph:3PX>2Ph:3PoimOWenOGimOW`04o`03Gooo00;o00^OGimO
WenOGimOo`09C0Co0T`3o`U<00?ogml02=l4o`04goooo`[O00[om7kdO_Anm7kd1?l047kooomnm7kd
O_Anm7kdO_l600001P007?oa3_4>l@ka3_l>l@ko3_l>lOoa3_4>l@ka3_42o`2@3_4>l@ka3_7ol@ka
oo7ol@ko3_4>l@ka3_4>lOn@D91@T52@D?m@T53oD?m@T?n@D91@T52@D93o0`l33`<?0`l3o`<?0ol3
3`<?o`l33`<?0`l33ooPX>2Ph:3PX?nPh:3oX>3oh:3PX>2Ph:3PX>2PoimOWenOGimOoenOGomOWonO
GimOWenOGimOWeoo24`01Om<C4co00=<00?oC4`024`00ooOg`07g`05omoOgol00]l00ooOg`09g`0N
ogiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW7o1P0000H001co/0j`3[0>/0ko3[0>o`ko3[3o/0j`
3[0>/0j`0_l07@j`3[0>/0j`ok0>/?n`ok0>o`j`3[0>/0j`3[3o00Q@00OoD51@oe3o009@00?oD500
1e00F?oF0mH3eP?F0mKoeP?FomH3eP?o0mH3eP?F0mH3oj3PX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3P
X>3oWenOGimOWeooGimOoenOGomOWenOGimOWenOGol8C006oda<C?m<1?l9C003omoO00OO00GogmoO
o`02g`03omoO00WO01kom7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdO_l600001P003ooa3_4>l@ka
3_l>l@ko3P03o`0:3_4>l@ka3_4>l@;o00h>l@ka3_4>lOoa3_7ol@?o01_a3_4>l@ka3_4>lOn@D91@
T52@D?m@T53oD9000_l06U2@D91@T52@D93o0`l33`<?0`l3o`<?0ol30ol0A@<?0`l33`<?0`ooh:3P
X>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph:3PX?nOGimOWenOGomOWeooGimOWonOGimOWenOGimOo`08C009
oda<C?m<odco00Y<00?ogml01ml01OoOgmoo00;O00?ogml02Ml04?mnLGiaOW5nLOmaOW7oLGh2o`0<
LGiaOW5nLGiaOW7o1P0000H000[o/0j`3[0>/0j`1_l030j`3[0>/0j`3[0>/0;o00T>/0j`3[0>/0h0
1_l03[0>/0j`3[0>/0j`3[3o2E06o`9@00?oD5001e002ooF0mH3eP?F0mH300Ko01KF0mH3eP?F0mH3
eP?oX>2Ph:3PX>2P1Ol06:3PX?nPh:3PX>2Ph:3PoimOWenOGimOW`Ko00iOWonOGimOWenOGimOo`U<
1_l00dcoC009C003omoO00SO1Ol00moog`0:g`0:ooAnm7kdO_Anm0Go00odO_Com7kdO_Anm7kdO_l0
1P0000H0013ol@ka3_4>l@ka3_4>l@ka0ol02O4>l@ka3_4>l@02o`0?3_4>l@ka3_4>l@ka3_4>00?o
01X>l@ka3_4>l@kaoi1@T52@D91@T52@D91@T0;o01Y@T52@D91@T52@o`<?0`l33`<?0`l33`<?0`Co
01P?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph:04o`0Jh:3PX>2Ph:3PX?nOGimOWenOGimOWenOGil2o`0<
GimOWenOGimOWeoo3d`2o`Y<00?ogml03Ml2o`_O00ooOW5nLGiaOW5nLGiaOW400ol0375nLGiaOW5n
LGiao`H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o01d>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`o`0KD01HomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa]<00?ogml06]l07_od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@;o090>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoi1@T52@D91@T52@D91@T52@D91@T52@
D91@T?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolKC003omoO01[O01koOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOl600001P007?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[02o`0M3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l06e00F?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolKC003
omoO01[O01kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l600001P007?oa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_42o`2@3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@
D91@T52@D91@T52@D93o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo6d`00ooOg`0Jg`0NogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o1P0000H001co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
0_l07@j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o01]@05SoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo6d`00ooOg`0Jg`0NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H001col@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka0_l0T0ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oT52@
D91@T52@D91@T52@D91@T52@D91@T52@o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa]<00?ogml0
6]l07_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H00006000Lok0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0;o01d>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`o`0KD01HomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoa]<00?ogml06]l07_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`H0
0006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o090>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@kaoi1@T52@D91@T52@D91@T52@D91@T52@D91@T?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolKC003omoO01[O01koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl600001P007?n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[02o`0M3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l06e00F?oF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolKC003omoO01[O01kom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_l600001P007?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_42o`2@3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@D91@T52@D91@T52@D93o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo6d`00ooOg`0Jg`0NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o1P0000H0
01co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`0_l07@j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[3o01]@05SoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo6d`00ooOg`0Jg`0NooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko1P0000H0ool5o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o05H3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poaa@00?ogml06]l0>_mOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@00006000L
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`;o07<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@
D91@T52@D91@T52@D91@T52@D91@T52@D93o01cO03[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko74`00ol0000400001P007?oF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH2o`1F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?lLD003omoO01[O03[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co74`00ol0
000400001P007?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2o`1c3`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph?m@T52@D91@T52@D91@T52@D91@T52@D91@T52@o`0Lg`0joenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaa<00?o0000100000H001coeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0_l0EP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o75000ooO
g`0Jg`0joenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoaa<00?o0000100000H001co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l30_l0L`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>3oD91@T52@D91@T52@D91@T52@D91@T52@D91@T?l07=l0>_mOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@0
0006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP;o05H3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Poaa@00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lLC003o`0000@00006000Lo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`;o
07<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D91@T52@D93o01cO
03[oGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
74`00ol0000400001P007?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH2o`1F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX?lLD003omoO01[O03[oGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co74`00ol0000400001P002_l33`<?0`l33`<3o`0?0`l33`<?
0`l33`<?0`l300;o00T?0`l33`<?0`l00ol06Pl33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka0ol06_4>
l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3P0ol06N2Ph:3PX>2Ph:3PX>2Ph?m@T52@D91@T5000ol04E2@
D91@T52@D91@T52@D93o00WO0ol@g`0:oenOGimOWenOG`?o01YOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOP?o011nLGiaOW5nLGiaOW5nLGko2D`3oa1<00?o0000100000H001coeP?F0mH3eP?F0mH3o`?F
0mH3eP?F0mH3eP?F0_l0EP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>o`j`
3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3oh:3PX>2Ph:3PX>2Ph:3o35000om@D00=D003omoO00[O
00?ogml03Ml0>_mOWenOGimOWenOGiooWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7kdO_An
m7kdO_Anm?l<C003oda<00e<00?o0000100000H000[o0`l33`<?0`l31?l03Pooool?0`l33`<?0`l3
0_l02@l33`<?0`l33`04o`0I0oooo`<?0`l33`<?0`l3oo4>l@ka3_4>l@04o`0I3_7oo`ka3_4>l@ka
3_7oX>2Ph:3PX>2Ph004o`0HX>3oh:3PX>2Ph:3PX>3oD91@T52@D91@1?l0491@oon@D91@T52@D91@
T?l9g`Co00COoooo2ml02_mOWenOGimOWel4o`03Wooo00;o01AOWenOGimOWeooLGiaOW5nLGiaOPCo
00maooooLGiaOW5nLGiaO_l02D`4o`9<0ol:C003o`0000@00006000LomH3eP?F0mH3o`?F0ol3eP?F
omH3eP?F0mH3eP;o05H3eP?F0mH3e_oF0mKoeP?F0ol3eP?F0mH3eP?Fok0>/0j`3[0>o`j`3_l>o`j`
ok0>/0j`3[0>/?oPX>2Ph:3PX>3oh:3Pon2Poj3PX>2Ph:3PX>2Po`Q@00OoD51@oe3o009@00?oD500
25000ooOg`06g`05omoOgol00]l00ooOg`0:g`0joenOGimOWenOoimOWonOGomOWenOGimOWenOGomn
m7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdo`Q<00GoC4a<o`03C003oda<00U<00?o0000100000H0
01co0`l33`<?0`oo3`<?o`l33`?o0`l33`<?0`l30_l0L`l33`<?0`l3o`<?0ol33`<?o`l33`<?0`l3
3`?ol@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@kaoj3PX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>3o
D91@T52@D93oT52@oi3oT53oD91@T52@D91@T?l02=l01OoOgmoo00;O00?ogml02]l0>_mOWenOGimO
WonOGiooWenOoimOWenOGimOWeooLGiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaO_l8C006oda<C?m<
1?l:C003o`0000@00006000?omH3eP?F0mH3o`?F0ol300?o00X3eP?F0mH3eP?F0_l03P?F0mH3eP?F
omH3e_oF0ol06]H3eP?F0mH3eP?Fok0>/0j`3[0>o`j`3_l>0ol0:0j`3[0>/0j`3[3oh:3PX>2Ph:3P
on2Ph?oPX>3oh:3PX>2Ph:3PX?l8D005oe1@D?l00U02o`]@00?ogml01]l01OoOgmoo00;O00?ogml0
2]l0;OmOWenOGimOWonOGiooWenOGomOWenOGimOWeooO_Anm7kdO_AnogkdO_mnm002o`0;O_Anm7kd
O_Anm?l024`02Om<C4coC?m<o`0;C003o`0000@00006000:o`<?0`l33`<?0`Ko00`?0`l33`<?0`l3
3`<2o`093`<?0`l33`<?00Ko01L33`<?0`l33`<?0`l3oo4>l@ka3_4>l@06o`0G3_4>l@ka3_4>l@ka
oj3PX>2Ph:3PX>001Ol05n2Ph?oPX>2Ph:3PX>3oD91@T52@D91@00Ko00j@D?m@T52@D91@T52@o`WO
1Ol00moog`0;g`0:oenOGimOWenOG`Ko01NOGomOWenOGimOWeooLGiaOW5nLGiaOP05o`0>OW5nogia
OW5nLGiaO_l9C0Ko00=<od`02T`00ol0000400001P003ooF0mH3eP?F0mH3eP?F0`04o`09eP?F0mH3
eP?F00;o00h3eP?F0mH3eP?F0mH3ePCo01X3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0?o01V`3[0>
/0j`3[3oh:3PX>2Ph:3PX>2Ph:3P00Co00ZPh:3PX>2Ph:3o3e02o`]@00?ogml03=l2o`cO013oGimO
WenOGimOWenOGimO0_l06YmOWenOGimOWeooO_Anm7kdO_Anm7kdO_An0ol02gkdO_Anm7kdO_Co00m<
0_l;C003o`0000@00006000Lo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`;o07<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@D91@T52@D91@T52@D93o01cO03[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko74`00ol000040000
1P007?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH2o`1F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X?lLD003omoO01[O03[oGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co74`00ol0000400001P007?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2o`1c
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D91@T52@D91@T52@D91@T52@o`0Lg`0j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaa<
00?o0000100000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0_l0EP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3o75000ooOg`0Jg`0joenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoaa<00?o0000100000H001co0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l30_l0L`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@kaoj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oD91@T52@D91@T52@D91@T52@D91@T52@
D91@T?l07=l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lLC003o`0000@00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP;o05H3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oPX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poaa@00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@00006000Lo`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`;o07<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>lOnPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T52@
D91@T52@D91@T52@D93o01cO03[oGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko74`00ol0000400001P007?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH2o`1F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?lLD003omoO01[O03[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co74`00ol0000400001P007?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2o`1c3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?m@T52@
D91@T52@D91@T52@D91@T52@D91@T52@o`0Lg`0joenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaa<00?o0000100000H001coeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0_l0EP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o75000ooOg`0Jg`0joenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaa<00?o0000
100000H0ool5o`H000060003oda<01U<0_lLC00jooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?oD5006U00EonPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`0600001P000om<C00IC0;o74`0>_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolLg`1doi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P000om<C00IC0;o74`0>_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03oe1@01Y@05OoX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol01P0000H000?oC4`06D`2oaa<03[oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l0M?n@D91@T52@D91@T52@
D91@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H000?oC4`06D`2oaa<
03[om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7=l00om@D00JD01Goj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o00H000060003oda<01U<0_lLC00j
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoacO
07CoT52@D91@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H0
00060003oda<01U<0_lLC00jooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoacO00?oD5006U00EonPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`060000
1P000om<C00IC0;o74`0>_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGolLg`1doi1@T52@D91@T52@D91@T52@D91@T52@D91@T53oh:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ol600001P000om<C00IC0;o74`0>_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03oe1@01Y@05OoX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol01P0000H000?oC4`06D`2oaa<03[oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l0M?n@D91@T52@D91@T52@D91@T52@D91@T52@
D91@on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H000?oC4`01d`3o`m<0_l9C0?o44`02_od
O_Anm7kdO_@3o`0Jm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWel3o`0@GimOWenOGimOWenOGimOo`WO
0ol@g`03oe1@00M@0ol@D00:oj3PX>2Ph:3PX0?o01ZPh:3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0?o
01V`3[0>/0j`3[0>/0j`3[3oeP?F0mH3eP?F00?o017F0mH3eP?F0mH3eP?F0mH3o`0600001P000om<
C00:C003oda<00a<0_l<C003oda<00e<03[oOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5noimOWenO
GimOWenOGiooWenOGimOWenOGimOWeoo3=l00ooOg`0=g`1doi1@T52@D91@T52@D?m@T52@D91@T52@
D91@T53oh:3PX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_4>l@ko3_4>l@ka3_4>l@ka
3_7o0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l33ol600001P000om<C007C0Co0T`3o`U<0_l9C0Co
0T`3o`Y<00[om7kdO_Anm7kd1?l06Gkooomnm7kdO_Anm7kdoimOWenOGimOWel01?l00iooo`02o`0:
GimOWenOGimOo`WO1?l01=ooool;g`03oe1@00M@1?l2D0;o2e002_nPh:3PX>2Ph:04o`0Ih:3oX>2P
h:3PX>2Ph:3o3[0>/0j`3[0>/004o`0H3[3oo`j`3[0>/0j`3[3oeP?F0mH3eP?F1?l040?oool3eP?F
0mH3eP?F0ol600001P000om<C006C005oda<C?l00d`00om<C008C0;o24`01Om<C4co00=<00?oC4`0
2D`0>_mnLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGkoWenOGimOWenOoimOWonOGomOWenOGimOWenO
Gol8g`05omoOgol00]l00ooOg`0:g`1doi1@T52@D91@oe2@D?m@oe2@oi1@T52@D91@T53oh:3PX>2P
h:3oX>2Poj3Pon2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_l>l@ko3_l>lOoa3_4>l@ka3_7o0`l33`<?0`oo
3`<?o`l33`?o0`l33`<?0`l33ol600001P000om<C006C006oda<C?m<1?l9C0;o24`01_m<C4coC0Co
2T`0>_odO_Anm7kdO_mnm7koO_Anm?odO_Anm7kdO_CoWenOGimOWenOoimOWonOGiooWenOGimOWenO
Gol8g`05omoOgol00]l00ooOg`0:g`03oe1@00I@00OoD51@oe3o009@00?oD5002500EonPh:3PX>2P
h?oPX>3oh:3Pon2Ph:3PX>2Ph:3o3[0>/0j`3[0>o`j`3_l>o`j`ok0>/0j`3[0>/?oF0mH3eP?F0ol3
eP?o0mH3e_oF0mH3eP?F0mH3o`0600001P000om<C006C009oda<C?m<odco00Y<0_l8C009oda<C?m<
odco00]<013oOW5nLGiaOW7oLGiaog5n0_l0:75nLGiaOW5nLGkoWenOGimOWenOoimOWonOGimOoenO
GimOWenOGol8g`05omoOgol00]l00ooOg`0:g`0@oi1@T52@D91@oe2@D?m@T0;o03M@T52@D91@T52@
D?oPX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>3o3_4>l@ka3_4>o`ka3_l>00?o01T>l@ka3_4>l@ka
o`<?0`l33`<?o`l33ol?00?o00`?0`l33`<?0`l33ol600001P000om<C007C0Ko00=<od`02D`2o`U<
1_l00dcoC00:C00:ooAnm7kdO_Anm0Go01SdO_Com7kdO_Anm7kdoimOWenOGimOWel6o`0=WeooGimO
WenOGimOo`09g`Go00?Ooml02ml00om@D007D0Ko0U000om@D008D00:oj3PX>2Ph:3PX0Go01RPh:3o
X>2Ph:3PX>2Po`j`3[0>/0j`3[06o`0F3[0>/0j`3[0>/0j`omH3eP?F0mH3ePKo00h3eP?F0mH3eP?F
0mH3o`H000060003oda<00e<0_l:C0;o3d`2o`]<00ooOW5nLGiaOW5nLGiaOW400ol06g5nLGiaOW5n
LGkoWenOGimOWenOGimOWenOG`02o`0;WenOGimOWenOGol03]l2o`cO013oT52@D91@T52@D91@T52@
0_l06U2@D91@T52@D91@on2Ph:3PX>2Ph:3PX>2P1?l06^2Ph:3PX>2Ph?l>l@ka3_4>l@ka3_4>l@ka
0ol06?4>l@ka3_4>lOl33`<?0`l33`<?0`l33`Co00/33`<?0`l33`<?o`0600001P000om<C00IC0;o
74`0>_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolLg`03oe1@01Y@05OoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[3oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol01P0000H000?oC4`06D`2oaa<
03[oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
7=l0M?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h?l>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo
1P0000H000?oC4`06D`2oaa<03[om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo7=l00om@D00JD01Goj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o00H0
00060003oda<01U<0_lLC00jogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoacO07CoT52@D91@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>3o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?o`H000060003oda<01U<0_lLC00jooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?oD5006U00EonPh:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3o`0600001P000om<C00IC0;o74`0>_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGkoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`1doi1@T52@D91@T52@D91@T52@D91@T52@
D91@T53oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_7o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P000om<C00IC0;o74`0>_odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03oe1@01Y@
05OoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol01P0000H000?oC4`06D`2oaa<03[oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l0M?n@D91@T52@
D91@T52@D91@T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H000?oC4`0
6D`2oaa<03[om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo7=l00om@D00JD01Goj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o00H000060003oda<01U<
0_lLC00jogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoacO07CoT52@D91@T52@D91@T52@D91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>3o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?o`H000060?oo1Ol600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l06ml00om<C00JC02AoenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`ooD91@T52@D91@T52@D91@T52@D91@T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l06ml00om<C00JC01GoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l06ml00om<C00JC02AoenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l06ml00om<C00JC01GoenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l06ml00om<C00JC02A
oenOGimOWenOGimOWenOGimOWenOGimOWenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@T52@D91@T?oa3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l06ml00om<C00JC01GoenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
6ml00om<C00JC02AoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@
T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l06ml00om<C00JC01G
oenOGimOWenOGimOWenOGimOWenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l06ml00om<C00JC02AoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@
T52@D91@T52@D91@T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0600001P007?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
6ml00om<C00JC01GoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_l600001P002_mnLGiaOW5nLGh3o`0?OW5nLGiaOW5nLGiaOW5n00;o00UaOW5n
LGiaOW400ol04G5nLGiaOW5nLGiaOW5nLGko00WO0ol?g`03oda<00Q<0ol?C00:oenOGimOWenOG`?o
01YOWenOGimOWenOGimOWenOoj3PX>2Ph:3PX0?o01ZPh:3PX>2Ph:3PX>2Ph:3Po`l33`<?0`l33`?o
01X?0`l33`<?0`l33`<?0`ooD91@T52@D91@T0?o01V@D91@T52@D91@T52@D93ol@ka3_4>l@ka00?o
017a3_4>l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_@2o`0M
O_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm?l03=l00ooOg`0<g`03oda<00]<00?oC4`034`0EomO
WenOGimOWenOGiooWenOGimOWenOGimOWenOon2Ph:3PX>2Ph:3PX?nPh:3PX>2Ph:3PX>2Ph:3o0mH3
eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3o`0=D003oe1@00a@01ko/0j`3[0>/0j`3[0>o`j`3[0>/0j`
3[0>/0j`3_l600001P002_mnLGiaOW5nLGh4o`0>LOooog5nLGiaOW5nLGh2o`09LGiaOW5nLGia00Co
011nooooOW5nLGiaOW5nLGko2Ml4o`04goooo`[O00?oC4`024`4o`9<0ol9C00:oenOGimOWenOG`Co
00>Oool00_l055nOGimOWenOGiooX>2Ph:3PX>2P1?l06N2Poj3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l0
1?l06@?oool33`<?0`l33`<?oe2@D91@T52@D9001?l0652@oom@T52@D91@T52@oo4>l@ka3_4>l@Co
010>lOoo3_4>l@ka3_4>l@ko1P0000H001com7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kd0_l07Gkd
O_Anm7kdooAnm?odO_AnogkdO_Anm7kdO_Co00SO00GogmoOo`02g`03omoO00WO00?oC4`01d`01Om<
C4co00=<00?oC4`024`0EomOWenOGimOWonOGiooWeooGimOWenOGimOWenOon2Ph:3PX>2Poj3PX?nP
h?oPX>2Ph:3PX>2Ph:3o0mH3eP?F0mKoeP?FomH3eP?o0mH3eP?F0mH3o`09D007oe1@D?m@o`02D003
oe1@00M@01ko/0j`3[0>/0ko3[0>o`ko3[3o/0j`3[0>/0j`3_l600001P007?mnLGiaOW5nLOmaOW7o
LGiaO_mnLGiaOW5nLGh2o`0MLGiaOW5nLGkoOW5nogiaOW7oLGiaOW5nLGiaO_l02=l01OoOgmoo00;O
00?ogml02Ml00om<C007C006oda<C?m<1?l9C02AoenOGimOWenOoimOWonOGiooWenOGimOWenOGioo
X>2Ph:3PX>3oh:3Pon2Ph?oPX>2Ph:3PX>2Ph?l?0`l33`<?0ol33`?o0`l33ol?0`l33`<?0`ooD91@
T52@D91@oe2@D?m@oe2@oi1@T52@D91@T?oa3_4>l@ka3_l>l@ko3_l>lOoa3_4>l@ka3_4>o`060000
1P004?odO_Anm7kdO_mnm7koO_@2o`0:O_Anm7kdO_Anm0;o00mnm7kdO_Anm?odO_Com7h00_l03?An
m7kdO_Anm7kdo`SO00GogmoOo`02g`03omoO00WO00?oC4`01d`02Om<C4coC?m<o`0:C019oenOGimO
WenOoimOWonOGimOoenOGimOWenOGiooh:3PX>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph:3PX?l3eP?F0mH3
e_oF0mKoeP03o`0;eP?F0mH3eP?F0ol02E001Om@D53o009@0_l:D00?ok0>/0j`3[0>o`j`3_l>00?o
00`>/0j`3[0>/0j`3_l600001P002_mnLGiaOW5nLGh5o`0=OW5nogiaOW5nLGiaOP02o`09LGiaOW5n
LGia00Go00maOW7oLGiaOW5nLGiaO_l02Ml5o`03gooO00[O00?oC4`024`6o`03C?m<00U<00[oGimO
WenOGimO1_l05imOoenOGimOWenOGiooX>2Ph:3PX>2P00Go01RPh:3oX>2Ph:3PX>2Ph?l?0`l33`<?
0`l6o`0G0`l33`<?0`l33`<?oe2@D91@T52@D9001_l05U2@oi1@T52@D91@T?oa3_4>l@ka3_46o`0>
3_4>l@ka3_4>l@ka3_l600001P003oodO_Anm7kdO_Anm7kdOP03o`0:O_Anm7kdO_Anm0;o00inm7kd
O_Anm7kdO_Anm0?o00cdO_Anm7kdO_Anm?l>g`;o2ml00om<C00>C0;o2T`04?mOWenOGimOWenOGimO
Wel2o`0JWenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:04o`0Ih:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3
eP04o`0:0mH3eP?F0mH3oa1@0_l:D00@ok0>/0j`3[0>/0j`3[0>/0?o00^`3[0>/0j`3[0>o`060000
1P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l06ml00om<C00JC02AoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@
T52@D91@T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l06ml00om<
C00JC01GoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l06ml00om<C00JC02AoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@
T52@D91@T52@D91@T52@D91@T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`060000
1P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l06ml00om<C00JC01GoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooh:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0M
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l06ml00om<C00JC02AoenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@T52@D91@T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l06ml00om<C00JC01GoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@
01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l06ml00om<C00JC02AoenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@T52@D91@T?oa3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0M
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l06ml00om<C00JC01GoenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0MLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l06ml00om<
C00JC02AoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D91@T52@D91@T52@D91@
T?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l06ml00om<C00JC01GoenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?o01a@01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l60000
1P3oo`Go1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l07EnOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01]<00?ogml06]l0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko01]@03_o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`0600001P007?nOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0MGimOWenOGimOWenOGimOWenOGimOWenOGimOWol06d`00ooOg`0Jg`2Aog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@
T52@D91@T52@D91@T52@D91@T53o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Po`0600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0M
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol06d`00ooOg`0Jg`0kogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l06e00>ol3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?Fon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000LoimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0KC003
omoO01[O097oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>oe2@D91@T52@D91@T52@D91@T52@D91@T52@D?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l3oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00H00006000LoimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0KC003omoO01[O03_oO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0KD00k
o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l0
1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l07EnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01]<00?ogml06]l0TOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@koD91@T52@D91@T52@D91@T52@D91@T52@D91@o`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l01P0000H001coWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l07EnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01]<
00?ogml06]l0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0ko01]@03_o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Po`0600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0MGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol06d`00ooOg`0Jg`2Aog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@T52@D91@T52@D91@T52@D91@
T53o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
o`0600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0MGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol06d`00ooOg`0Jg`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l06e00>ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fon2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000:oimOWenOGimOW`?o00nOGimOWenOGimO
WenOGil00_l02EnOGimOWenOG`03o`0AGimOWenOGimOWenOGimOWol02D`3o`m<00?ogml02=l3o`oO
00[oLGiaOW5nLGia0ol06W5nLGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka0ol06_4>l@ka3_4>l@ka3_4>
l@koD91@T52@D91@0ol06U2@D91@T52@D91@T52@D?l?0`l33`<?0`l30ol06@<?0`l33`<?0`l33`<?
0onPh:3PX>2Ph:000ol04J3PX>2Ph:3PX>2Ph:3PX>3o00H00006000LoimOWenOGimOWenOGomOWenO
GimOWenOGimOW`;o01eOWenOGimOWenOGiooWenOGimOWenOGimOWenOo`0<C003oda<00a<00?ogml0
2ml00ooOg`0<g`0kogkdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>o`j`3[0>
/0j`3[0>/0j`3_l035000om@D00<D00ko`?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mKoh:3PX>2P
h:3PX>2Poj3PX>2Ph:3PX>2Ph:3PX?l01P0000H000[oWenOGimOWenO1?l00eooo`02o`09WenOGimO
WenO00;o00UOWenOGimOWel01?l00iooo`02o`0;GimOWenOGimOWol02D`4o`9<0ol9C003omoO00SO
1?l01=ooool:g`0:og5nLGiaOW5nL@Co01UnooooOW5nLGiaOW5nLGkol@ka3_4>l@ka00Co01T>lOoo
3_4>l@ka3_4>l@koD91@T52@D91@00Co01V@D?ooT52@D91@T52@D?l?0`l33`<?0`l300Co01P?oooo
3`<?0`l33`<?0onPh:3PX>2Ph:04o`0@h:3oX>2Ph:3PX>2Ph:3Po`H00006000LoimOWenOGimOoenO
GomOWonOGimOWenOGimOW`;o01eOWenOGimOWonOGiooWeooGimOWenOGimOWenOo`08C005oda<C?l0
0d`00om<C008C003omoO00OO00GogmoOo`02g`03omoO00WO03_oO_Anm7kdO_Com7kdooAnm7koO_An
m7kdO_Anm?n`3[0>/0j`3_l>/0ko3_l>/?n`3[0>/0j`3[0>o`08D007oe1@D?m@o`02D003oe1@00M@
03_o0mH3eP?F0mH3o`?F0ol3eP?FomH3eP?F0mH3e_oPX>2Ph:3PX?nPh:3oX>3oh:3PX>2Ph:3PX>2P
o`0600001P007?nOGimOWenOGomOWeooGimOoenOGimOWenOGil2o`0MGimOWenOGiooWenOoimOWonO
GimOWenOGimOWol024`01_m<C4coC0Co2D`00ooOg`07g`05omoOgol00]l00ooOg`09g`2Aog5nLGia
OW5nogiaO_mnLGiaog5nLGiaOW5nLGkol@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@ka3_m@T52@D91@
T?n@D93oT?n@D?m@T52@D91@T53o3`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0onPh:3PX>2Ph?oP
X>3oh:3Pon2Ph:3PX>2Ph:3Po`0600001P007?nOGimOWenOGomOWeooGimOWonOGimOWenOGil2o`0M
GimOWenOGiooWenOoimOWeooGimOWenOGimOWol024`02Om<C4coC?m<o`0:C003omoO00OO00GogmoO
o`02g`03omoO00WO013oO_Anm7kdO_Com7kdooAn0_l06_Anm7kdO_Anm7kdok0>/0j`3[0>o`j`3_l>
0ol030j`3[0>/0j`3[0>o`Q@00GoD51@o`02D0;o2U004?l3eP?F0mH3eP?o0mH3o`<3o`0X0mH3eP?F
0mH3e_oPX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>2Po`H00006000:oimOWenOGimOW`Ko00aOWonO
GimOWenOGil2o`09GimOWenOGimO00Ko00jOGomOWenOGimOWenOo`U<1_l00dcoC009C003omoO00SO
1Ol00moog`0:g`0:og5nLGiaOW5nL@Go01QaOW7oLGiaOW5nLGiaO_oa3_4>l@ka3_46o`0G3_4>l@ka
3_4>l@ka3_m@T52@D91@T5001_l05i1@oe2@D91@T52@D?l?0`l33`<?0`l300Ko01H?0`l33`<?0`l3
3`?oX>2Ph:3PX>2P1Ol03j3PX?nPh:3PX>2Ph:3Po`0600001P004?nOGimOWenOGimOWenOGil2o`0:
GimOWenOGimOW`;o00mOWenOGimOWenOGimOWel00_l039mOWenOGimOWenOo`m<0_l:C003omoO00gO
0_l;g`0?ogkdO_Anm7kdO_Anm7kd00?o01_dO_Anm7kdO_Anm?n`3[0>/0j`3[0>/0j`3[000ol02k0>
/0j`3[0>/0ko00m@0_l:D00@o`?F0mH3eP?F0mH3eP?F0`Co01SF0mH3eP?F0mKoh:3PX>2Ph:3PX>2P
h:04o`0;h:3PX>2Ph:3PX?l01P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l07EnO
GimOWenOGimOWenOGimOWenOGimOWenOGioo01]<00?ogml06]l0TOmaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koD91@T52@D91@T52@D91@T52@D91@
T52@D91@o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?l01P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l07EnOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01]<00?ogml06]l0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko01]@03_o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`0600001P007?nOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0MGimOWenOGimOWenOGimOWenOGimOWenOGimOWol06d`00ooOg`0Jg`2Aog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@
T52@D91@T52@D91@T52@D91@T53o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Po`0600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0M
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol06d`00ooOg`0Jg`0kogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l06e00>ol3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?Fon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000LoimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0KC003
omoO01[O097oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>oe2@D91@T52@D91@T52@D91@T52@D91@T52@D?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l3oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00H00006000LoimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0KC003omoO01[O03_oO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0KD00k
o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l0
1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l07EnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01]<00?ogml06]l0TOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noo4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@koD91@T52@D91@T52@D91@T52@D91@T52@D91@o`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l01P0000H001coWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l07EnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01]<
00?ogml06]l0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdok0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0ko01]@03_o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Po`0600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0MGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol06d`00ooOg`0Jg`2Aog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGkol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@T52@D91@T52@D91@T52@D91@
T53o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
o`0600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0MGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol06d`00ooOg`0Jg`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l06e00>ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fon2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000LoimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o01eOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0KC003omoO01[O097oLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>oe2@D91@T52@D91@
T52@D91@T52@D91@T52@D?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oj3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3o00H000060?oo1Ol600001P000ooOg`0Ig`;o7=l0>_nOGimOWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ooOg`0Ig`;o
7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H000?ogml06Ml2oacO
03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o
1P0000H000?ogml06Ml2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@0
00060003omoO01WO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@
D91@T52@D91@T52@D91@o`H000060003omoO01WO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?l075000ol0000400001P000ooOg`0Ig`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ooOg`0Ig`;o7=l0>_nOGimOWenO
GimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H000?ogml06Ml2oacO03[oWenOGimOWenO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H000?ogml0
1ml3o`oO0_l9g`?o4=l02_nOGimOWenOGil3o`0JWenOGimOWenOGimOWenOooAnm7kdO_Anm7h3o`0@
O_Anm7kdO_Anm7kdO_Ano`U<0ol@C00:omH3eP?F0mH3eP?o01[F0mH3eP?F0mH3eP?F0mH3o`j`3[0>
/0j`3P?o01X>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph0?o013PX>2Ph:3PX>2Ph:3PX>3o2E03oa1@
00?o0000100000H000?ogml02]l00ooOg`0<g`;o3=l00ooOg`0=g`0joimOWenOGimOWenOGomOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiao`a<00?oC4`03D`0M?l33`<?0`l3
3`<?0`oo3`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>lOoa3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P
h:3Pon2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D?m@T52@D91@T52@D91@T53o1P0000H000?ogml0
1ml4o`04goooo`[O0_l9g`Co00COoooo2ml02_nOGimOWenOGil4o`03Gooo00;o01BOGimOWenOGioo
m7kdO_Anm7kdOPCo00odoooom7kdO_Anm7kdO_l02D`4o`9<0ol:C00:omH3eP?F0mH3ePCo01T3oooo
0mH3eP?F0mH3eP?o3[0>/0j`3[0>00Co01V`3_oo/0j`3[0>/0j`3_nPh:3PX>2Ph:3P00Co00nPh?oP
X>2Ph:3PX>2Ph?l02E04o`9@0_l;D003o`0000@000060003omoO00KO00GogmoOo`02g`03omoO00WO
0_l8g`05omoOgol00]l00ooOg`0:g`0joimOWenOGimOoenOGomOWonOGimOWenOGimOWomnLGiaOW5n
LGkoOW5nogiaOW7oLGiaOW5nLGiao`Q<00GoC4a<o`03C003oda<00U<07Co0`l33`<?0`oo3`<?o`l3
3`?o0`l33`<?0`l33ol>l@ka3_4>lOoa3_7olOoa3_l>l@ka3_4>l@koh:3PX>2Ph:3Pon2Ph?oPX?nP
h:3PX>2Ph:3PX?n@D91@T52@D?m@T53oD?m@T?n@D91@T52@D91@o`H000060003omoO00KO00GogmoO
o`02g`03omoO00WO0_l8g`05omoOgol00]l00ooOg`0:g`0joimOWenOGimOoenOGomOWeooGimOWenO
GimOWoodO_Anm7kdO_Com7kdooAnm7koO_Anm7kdO_Ano`Q<00KoC4a<od`4o`Y<05OoeP?F0mH3eP?o
0mH3o`?F0mKoeP?F0mH3eP?F0ol>/0j`3[0>/?n`3[3o/?n`3_l>/0j`3[0>/0koX>2Ph:3PX>2Poj3P
X?nPh:3oX>2Ph:3PX>2Ph?l025001om@D53oD?l00U000om@D008D003o`0000@000060003omoO00KO
00GogmoOo`02g`03omoO00WO0_l8g`05omoOgol00]l00ooOg`0:g`0]oimOWenOGimOoenOGomOWenO
oimOWenOGimOWomnLGiaOW5nLGkoOW5nogia00;o00]nLGiaOW5nLGiao`08C009oda<C?m<odco00]<
00oo0`l33`<?0`oo3`<?o`l00ol06Pl33`<?0`l33`<?o`ka3_4>l@kaoo4>lOoa0ol0=o4>l@ka3_4>
l@koh:3PX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3PX?n@D91@T52@D?m@T53oD9000_l0352@D91@T52@
D91@o`H000060003omoO00OO1Ol00moog`0:g`;o2Ml5o`03gooO00_O00[oWenOGimOWenO1_l05enO
oimOWenOGimOWoodO_Anm7kdO_An00Go00inm7koO_Anm7kdO_Ano`U<1_l00dcoC00:C00:omH3eP?F
0mH3ePKo01L3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3P06o`0G/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>00
1Ol03^2Ph?oPX>2Ph:3PX>3o2E06o`9@00?oD50025000ol0000400001P000ooOg`0<g`;o2ml2o`kO
0_l<g`0@oimOWenOGimOWenOGimOW`;o01YOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOP?o00]nLGia
OW5nLGiao`0?C0;o2d`03ol33`<?0`l33`<?0`l33`04o`0J0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>
l@h3o`0I3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph004o`0IX>2Ph:3PX>2Poi1@T52@D91@T52@D91@
T002o`0<D91@T52@D91@T53o1P0000H000?ogml06Ml2oacO03[oWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Po`0LD003o`0000@000060003omoO01WO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003omoO01WO0_lLg`0joimOWenO
GimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ooOg`0Ig`;o7=l0>_nOGimOWenO
GimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ooO
g`0Ig`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H000?ogml0
6Ml2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@
D91@T53o1P0000H000?ogml06Ml2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003
o`0000@000060003omoO01WO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@
D91@T52@D91@T52@D91@T52@D91@o`H000060003omoO01WO0_lLg`0joimOWenOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph?l075000ol0000400001P000ooOg`0Ig`;o7=l0>_nOGimOWenOGimOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001@3oo`Ko1P0000D0ool6o`H0
00060003o`0001P00olLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol000040000
1P000ol0000G0004o`3ooacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@
D91@T52@D91@T52@D91@T53o1P0000H000?o00005P000ol00002oacO03[oWenOGimOWenOGimOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`0001D000Co00000_lLg`0joimOWenOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003o`0001@0
00?o00000P02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003
o`0001<000?o00000`02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@
D91@T52@D91@T52@D91@T53o1P0000H000?o00001002o`030?oo00T000?o00001002oacO03[oWenO
GimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`0000D000?o0?l02@000ol0
000500;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@
D91@T52@D?l600001P000ol000060003o`0000L000?o00001P02oacO03[oWenOGimOWenOGimOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`0000D000?o0?l01`000ol0000700;o2Ml3oa3O
00[oWenOGimOWenO0ol06YmOWenOGimOWenOGimOWomnLGiaOW5nLGia0ol0475nLGiaOW5nLGiaOW5n
LOl9C0?o44`02_l33`<?0`l33`<3o`0J0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@h3o`0J3_4>l@ka
3_4>l@ka3_4>on2Ph:3PX>2Ph:03o`0IX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T003o`0AT52@D91@
T52@D91@T52@D?l01P0000H000?o00001002o`030?oo00D000?o00002002o`cO00?ogml03Ml0>_nO
GimOWenOGimOWeooGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_l<C003
oda<00e<05OoeP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[3o/0j`3[0>/0j`
3[0>/0koX>2Ph:3PX>2Ph:3PX?nPh:3PX>2Ph:3PX>2Ph?l035000om@D00=D003o`0000@000060003
o`0000d000?o00002@02o`WO1?l01=ooool;g`0:oimOWenOGimOW`Co00=Oool00_l059mOWenOGimO
WomnLGiaOW5nLGia1?l03gkooomnLGiaOW5nLGiao`09C0Co0T`3o`Y<00[o0`l33`<?0`l31?l06@oo
ool?0`l33`<?0`l33ol>l@ka3_4>l@h01?l06O4>oooa3_4>l@ka3_4>on2Ph:3PX>2Ph:001?l06>2P
oj3PX>2Ph:3PX>2Poi1@T52@D91@T0Co011@T?ooD91@T52@D91@T53o1P0000H000?o000030000ol0
000:00;o2=l01OoOgmoo00;O00?ogml02]l0>_nOGimOWenOGomOWeooGiooWenOGimOWenOGioom7kd
O_Anm7kdooAnm?odO_AnogkdO_Anm7kdO_l8C005oda<C?l00d`00om<C009C01GomH3eP?F0mH3o`?F
0ol3eP?FomH3eP?F0mH3eP?o3[0>/0j`3[3o/0j`ok3o/0ko3[0>/0j`3[0>oj3PX>2Ph:3PX?nPh:3o
X>3oh:3PX>2Ph:3PX>3o00Q@00OoD51@oe3o009@00?oD50025000ol0000400001P000ol0000;0003
o`0000/00_l8g`05omoOgol00]l00ooOg`0:g`0joimOWenOGimOoenOGomOWeooGimOWenOGimOWomn
LGiaOW5nLGkoOW5nogiaOW7oLGiaOW5nLGiao`Q<00KoC4a<od`4o`Y<07Co0`l33`<?0`oo3`<?o`l3
3`?o0`l33`<?0`l33ol>l@ka3_4>lOoa3_7olOoa3_l>l@ka3_4>l@koh:3PX>2Ph:3Pon2Ph?oPX>3o
h:3PX>2Ph:3PX?n@D91@T52@D?m@T53oD?m@T?n@D91@T52@D91@o`H000060003o`0000X000?o0000
3002o`SO00GogmoOo`02g`03omoO00[O02goWenOGimOWeooGimOoenOGiooWenOGimOWenOooAnm7kd
O_Anm?odO_Com7h00_l02oAnm7kdO_Anm7ko00Q<00WoC4a<odcoC?l02d`03ooF0mH3eP?F0ol3eP?o
0`03o`0J0mH3eP?F0mH3eP?o3[0>/0j`3[3o/0j`ok03o`0X/0j`3[0>/0j`3_nPh:3PX>2Ph:3oX>2P
oj3PX?nPh:3PX>2Ph:3Po`Q@00GoD51@o`02D0;o2e000ol0000400001P000ol000090003o`0000@0
0ol600;o2Ml5o`03gooO00_O00[oWenOGimOWenO1_l05enOoimOWenOGimOWomnLGiaOW5nLGia00Go
00iaOW7oLGiaOW5nLGiao`U<1_l00dcoC00:C00:o`<?0`l33`<?0`Ko01L?0`l33`<?0`l33`<?o`ka
3_4>l@ka3P06o`0Gl@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:001Ol05j3PX?nPh:3PX>2Ph:3oT52@D91@
T52@00Ko00i@T?n@D91@T52@D91@o`H000060003o`0000P000?o00001P000ol0000500;o3]l2o`cO
013oWenOGimOWenOGimOWenO0_l06UnOGimOWenOGioom7kdO_Anm7kdO_Anm7kd0ol02oAnm7kdO_An
m7ko00m<0_l;C00?omH3eP?F0mH3eP?F0mH300Co01[F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3P?o
01T>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2P00Co00[PX>2Ph:3PX>3o3e02o`]@00?o0000100000H0
00?o00001`000ol000080003o`0000@00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@
D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003o`0000H000?o00002@000ol0000400;o
7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H000?o00001@000ol0
00090003o`3o00D00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@
D91@T52@D91@T52@D91@o`H000060003o`0000@000?o00002P000ol0o`0500;o7=l0>_nOGimOWenO
GimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H000?o00000`000ol0000:00;o00<0ool0
1002oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@
D91@T53o1P0000H000?o00000P000ol0000D00;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>3o01a@00?o0000100000H000Go0000o`0G00;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P001?l00?lH00;o7=l0>_nOGimOWenO
GimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H000?o0?l06@02oacO03[oWenOGimOWenO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H00_lJ00;o
7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H0ool5o`H0000R00;o
k0000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@000300
1?o=00?o3000034000?o0000cP000ol0000;00002003o`800_l00`3oo`0200Co00<0ool00_l200Co
0`03o`801Ol00`3oo`02ok@00_l00`3oo`090003o`3o00T000?o00002P0000T000Go0000o`020004
o`00o`@000Go0000o`030003o`00008000Oo0000o`3o008000Co003o0`000ol0002b0003o`3o00/0
00?o000020000ol0000:00002@001Ol0003o008000?o00001_l0103oool30003o`00008000Oo0000
o`3o008000Co003o0`000ol0002c0003o`0000P01Ol70003o`3o00/000070007o`3o0?l0o`020004
o`00o`<00_l700;o0`001ol0003o0?l00P001?l00?l30003o`000;8000?o0?l02`000ol000070003
o`3o00/000070006o`3o0?l01?l300?o00<0o`000P000ol00002o`030?oo00800ol0103oo`02o`03
0?oo00?o]002o`030?oo01<00_l00`3oo`0:00001`05o`030?l000X01?oc00003002ool00`000?l0
4@000?l04@000001\
\>"],
  ImageRangeCache->{{{0, 271.812}, {287, 0}} -> {-1.22505, -0.239038, 
  0.034767, 0.034767}},
  CellTags->"FormGroupoid"]
}, Open  ]],

Cell[TextData[{
  "2.1.2 ",
  StyleBox["GenerateGroupoid",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->{"GenerateGroupoid", "i:4"}],

Cell[TextData[{
  "In addition to the ",
  StyleBox["FormGroupoid", "MR"],
  " function, there are two other general means of forming groupoids. These \
are ",
  StyleBox["GenerateGroupoid", "MR"],
  " and ",
  StyleBox["FormGroupoidByTable", "MR"],
  "."
}], "Text",
  CellTags->"GenerateGroupoid"],

Cell[TextData[{
  "In contrast to ",
  StyleBox["FormGroupoid", "MR"],
  ", for which we provide a list of elements and an operation, ",
  StyleBox["GenerateGroupoid", "MR"],
  " requires a list of generators and an operation. The cyclic and dihedral \
groups are formed using this function. The syntax for ",
  StyleBox["GenerateGroupoid", "MR"],
  " is similar to that for ",
  StyleBox["FormGroupoid", "MR"],
  ". "
}], "Text",
  CellTags->"GenerateGroupoid"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GenerateGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      StyleBox["gens",
                        FontSlant->"Italic"], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Groupoid",
                  "MR",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["generators",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["{",
                    SingleLetterItalics->False], 
                  StyleBox["gens",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    SingleLetterItalics->False]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["op",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["using",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\<\"*\"\>",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operator",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["GenerateGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      StyleBox["gens",
                        FontSlant->"Italic"], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["op",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["sym",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Groupoid",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["generators",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                StyleBox["gens",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["op",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sym",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                SingleLetterItalics->False,
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->"GenerateGroupoid"],

Cell[TextData[{
  "Variations in using ",
  StyleBox["GenerateGroupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"GenerateGroupoid"],

Cell[TextData[{
  "The options for ",
  StyleBox["GenerateGroupoid", "MR"],
  " are also similar to those for ",
  StyleBox["FormGroupoid", "MR"],
  ", with one additional option."
}], "Text",
  CellTags->"GenerateGroupoid"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[\(default\ value\),
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox["SizeLimit",
              "MR"], 
            StyleBox["25",
              "MR"], 
            \(specifies\ the\ maximum\ number\ of\ elements\ that\ will\ be\ 
              generated\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{True, False}},
  CellTags->{"GenerateGroupoid", "i:5"}],

Cell[TextData[{
  "Additional option for ",
  StyleBox["GenerateGroupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"GenerateGroupoid"],

Cell[TextData[{
  "If, while generating a groupoid, the size of the set exceeds the bound ",
  StyleBox["SizeLimit", "MR"],
  ", the process is aborted. The motive for this option is to avoid \
inadvertently creating arbitrarily large sets."
}], "Text",
  CellTags->"GenerateGroupoid"],

Cell[TextData[{
  "We could define ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " using ",
  StyleBox["GenerateGroupoid", "MR"],
  " (but ",
  StyleBox["FormGroupoid", "MR"],
  " is actually used)."
}], "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newZ[n_]\  := \ GenerateGroupoid[{1}, \ Mod[#1\  + \ #2, n]&]; \n
    newZ[5]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"GenerateGroupoid"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4}, "-Operation-"]\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"GenerateGroupoid"]
}, Open  ]],

Cell[TextData[{
  "For another example, first observe that ",
  Cell[BoxData[
      \(TraditionalForm\`U\_20\)]],
  " is not cyclic."
}], "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({U[20], CyclicQ[U[20]]}\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"GenerateGroupoid"],

Cell[BoxData[
    \({Groupoid[{1, 3, 7, 9, 11, 13, 17, 19}, Mod[#1\ #2, 20]&], False}\)], 
  "Output",
  CellLabel->"Out[19]=",
  CellTags->"GenerateGroupoid"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`U\_20\)]],
  ", however, can be generated by the elements 3 and 11, but ",
  StyleBox["not",
    FontSlant->"Italic"],
  " by the elements 3 and 7."
}], "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Elements[GenerateGroupoid[{3, 11}, \ Mod[#1\ \ #2, 20]&]]\  === \ 
        Elements[U[20]], \n
      GenerateGroupoid[{3, 7}, \ Mod[#1\ \ #2, 20]&, \ 
        FormatOperator\  \[Rule] \ False]}\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"GenerateGroupoid"],

Cell[BoxData[
    \({True, Groupoid[{1, 3, 7, 9}, Mod[#1\ #2, 20]&]}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"GenerateGroupoid"]
}, Open  ]],

Cell["To what group is the following isomorphic?", "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenerateGroupoid[{{{1, 0}, {0, 7}}, \ {{4, 0}, {0, 1}}}, \ 
      Mod[#1 . #2, \ 9]&]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"GenerateGroupoid"],

Cell[BoxData[
    \(Groupoid[{{{1, 0}, {0, 1}}, {{1, 0}, {0, 4}}, {{1, 0}, {0, 7}}, {{4, 
            0}, {0, 1}}, {{4, 0}, {0, 4}}, {{4, 0}, {0, 7}}, {{7, 0}, {0, 
            1}}, {{7, 0}, {0, 4}}, {{7, 0}, {0, 7}}}, "-Operation-"]\)], 
  "Output",
  CellLabel->"Out[21]=",
  CellTags->"GenerateGroupoid"]
}, Open  ]],

Cell[TextData[{
  "2.1.3 ",
  StyleBox["FormGroupoidByTable",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->"FormGroupoidByTable"],

Cell[TextData[{
  "The third general means of forming a groupoid is with the ",
  StyleBox["FormGroupoidByTable", "MR"],
  " function. As the name implies, this function takes as inputs a set of \
elements and a Cayley table (as opposed to an operation). This is useful when \
the operation of the groupoid can be more easily represented by a table then \
by a specific function of two variables."
}], "Text",
  CellTags->"FormGroupoidByTable"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FormGroupoidByTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], "els", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["table",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["{",
                    SingleLetterItalics->False], 
                  StyleBox["els",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operation",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["implicit",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["table",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(using\ "*"\ as\ the\ operator\ symbol\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox[\(FormGroupoid ByTable\),
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], "els", 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["table",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["sym",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["{",
                    SingleLetterItalics->False], 
                  StyleBox["els",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operation",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["implicit",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["table",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["using",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["sym",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["as",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["operator",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["symbol",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["options",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"FormGroupoidByTable", "i:6"}],

Cell[TextData[{
  "Variations in using ",
  StyleBox["FormGroupoidByTable",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormGroupoidByTable"],

Cell[TextData[{
  " For example, if we wish to consider the Klein 4 group using the elements \
",
  Cell[BoxData[
      \(TraditionalForm\`{e, \ a, \ b, \ c}\)]],
  ", then it is easier to give the table to reflect the operation than to \
devise a function that establishes it. Indeed, the built-in group ",
  StyleBox["Klein4", "MR"],
  " is done in this manner."
}], "MathCaption",
  CellTags->"FormGroupoidByTable"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = Klein4\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"FormGroupoidByTable"],

Cell[BoxData[
    \(Klein4::"warning" \( : \ \) 
      "The elements e, a, b, c are considered strings and thus need to have \
double quotes around them when being used."\)], "Message",
  CellTags->"FormGroupoidByTable"],

Cell[BoxData[
    \(Groupoid[{"e", "a", "b", "c"}, "-Operation-"]\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"FormGroupoidByTable"]
}, Open  ]],

Cell[TextData[{
  "The foregoing warning simply instructs the user to treat the elements as \
strings when using them in functions. Thus, if we wish to determine the \
inverse of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " in this group, we would need to enter it as \"",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  "\"."
}], "MathCaption",
  CellTags->"FormGroupoidByTable"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupInverse[G, \ "\<b\>"]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"FormGroupoidByTable"],

Cell[BoxData[
    \("b"\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"FormGroupoidByTable"]
}, Open  ]],

Cell[TextData[{
  "The options for ",
  StyleBox["FormGroupoidByTable", "MR"],
  " are similar to those of ",
  StyleBox["FormGroupoid", "MR"],
  "; here is an illustration using some options."
}], "MathCaption",
  CellTags->"FormGroupoidByTable"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[
      FormGroupoidByTable[{2, 3, 6}, \ {{2, 3, 3}, {3, 2, 6}, {6, 6, 2}}, \ 
        "\<+\>", \ GroupoidName\  \[Rule] \ "\<example\>", \ 
        IsAGroup\  \[Rule] \ False], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"FormGroupoidByTable"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.56 .37 .6 r
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(2)] .38095 .62202 0 0 Mshowa
[(3)] .61905 .62202 0 0 Mshowa
[(3)] .85714 .62202 0 0 Mshowa
[(3)] .38095 .38393 0 0 Mshowa
[(2)] .61905 .38393 0 0 Mshowa
[(6)] .85714 .38393 0 0 Mshowa
[(6)] .38095 .14583 0 0 Mshowa
[(6)] .61905 .14583 0 0 Mshowa
[(2)] .85714 .14583 0 0 Mshowa
[(2)] .14286 .62202 0 0 Mshowa
[(3)] .14286 .38393 0 0 Mshowa
[(6)] .14286 .14583 0 0 Mshowa
[(2)] .38095 .86012 0 0 Mshowa
[(3)] .61905 .86012 0 0 Mshowa
[(6)] .85714 .86012 0 0 Mshowa
[(example)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[24]:=",
  ImageSize->{256, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400040000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l00@000?l00@000?l00@000?l00@000?l0
0@000?l00@000?l00@0000H0lol700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`1jm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03
o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW400_l0NWiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o07[dO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`1j
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lkg`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H0
03_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02o`1jm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lkg`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o07[dO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o0000
1@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02o`1jOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O
00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02o`1jm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o
07[dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoc_O00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@02o`1jOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol000050000
1P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia00;o07YnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc_O00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`1jm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0
000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o07[dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`1jOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0N_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
>ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGia00;o07YnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`1jm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000k
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW40
0_l0NWiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko>ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_An00;o07[dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H001goOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02o`0LOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@;o01enLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOP02o`0jLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01_O
1?lLg`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Com7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Com7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co7=l00ooOg`0Lg`03o`0000D00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_mnLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko7Ml00ooO
g`0Kg`03o`0000D00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0?o01cdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_An0_l07?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h3o`0iO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00?o01mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO00?ogml06]l00ol0000500001P00>omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noa_O
00Cogmoo7=l00ol0000500001P007OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00?o01]nm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l07OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00?o
03WdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@0
0ol07_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoacO0_lMg`03o`0000D00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
>ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_An00;o07[dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`1jOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000k
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h0
0_l0N_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co>ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`1jm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D0
0006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW400_l0NWiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko>ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o07[dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`1jOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03
o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`1j
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lkg`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o07[dO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H0
03_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
L@02o`1jOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lkg`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>omnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o07YnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o0000
1@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02o`1jm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o07[dO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O
00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02o`1jOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0N_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o
07YnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc_O00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOP02o`1jm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0NWiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol000050000
1P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_An00;o07[dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc_O00?o00001@0000H0lol700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
?=l0?OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01`0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0700001P007?nOGimOWenOGimOWenOGimOWenOGimOWenO
Gil3o`0LWenOGimOWenOGimOWenOGimOWenOGimOWenOG`;o01bOGimOWenOGimOWenOGimOWenOGimO
WenOGimO0ol07UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa_O1?lMg`0MogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW400_l07WiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0?ImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol07=l00ooOg`0Mg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01gO00?ogml07=l0?OmnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkoOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01`0000H001goWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`0LWenOGimOWenOGimOWenOGimOWenOGimOWenOG`;o
01fOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02o`0NGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo7]l00ooOg`0Kg`0LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0?o01kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01_O00Cogmoo7Ml0?OmnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01`0000H001coWenO
GimOWenOGimOWenOGimOWenOGimOWenO0ol079mOWenOGimOWenOGimOWenOGimOWenOGimOWel2o`0L
WenOGimOWenOGimOWenOGimOWenOGimOWenOG`?o01iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolLg`;o7]l07OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00?o01enm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OmnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OmnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OmnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OmnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo03cO03goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0?=l0?OodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01`0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`0mWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0lg`0mogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0700001P3co`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooO
g`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol70000
1P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003
omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L0
00060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0
>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H0
00?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOo`L000060003omoO01WO1?lKg`;o7=l4oacO01coGimOWenOGimOWenOGimO
WenOGimOWenOGimO0ol0>UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenO
GimOWenOGimOWenOGil3o`0NWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0
6]l00ooOg`0Kg`;o7Ml00ooOg`0Lg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0Kg`03omoO01[O0_lNg`03omoO01_O
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimO
WenOo`L000060003omoO01cO00?ogml06Ml2oaoO00?ogml06]l07OmOWenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o03]OWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`0NWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0
6Ml01?oOgolKg`;o7=l01?oOgolLg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0Jg`;o7=l2oagO0_lMg`0LoenOGimO
WenOGimOWenOGimOWenOGimOWenOG`?o03YOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenO
GimOWenOGimOWenOGimOWenOGimOWenO0ol07YmOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L0
00060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0
>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H0
00?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o?=l0N_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooOg`0hg`;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol700001P000ooO
g`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol70000
1P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO0_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000060003omoO03SO
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWol700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo1`0000H000?ogml0>=l2occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`L000050?Co
1`0000D0m?l700001P000ol0000g00?o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o0000=P001?l0oollg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l70000
1P000ol0000e0003o`0000;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o0000=0001?l00002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0003<000?o00000P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`00038000?o00000`02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`00034000?o00001002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`00030000?o00001@02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0002l000?o00001P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0002h000?o00001`02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0002d000?o00002002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0002`000?o00002@02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0002/000?o00002P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0002X000?o00002`02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0002T000?o00003002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0002P000?o00003@02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0000h00_l00`3oo`0D0003o`0000h00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000?0003o`3o01@000?o0000
3`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`L000060003o`00010000?o00004P000ol0000@00;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o0000
3`000ol0o`0B0003o`0001400_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000>00;o00<0ool040000ol0000B00;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H000?o00008P000ol0000C00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00008@000ol0000D00;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H000?o000080000ol0000E00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00007`000ol0000F00;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H000?o00007P000ol0000G00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00007@000ol0000H00;o
7=l4oacO01coGimOWenOGimOWenOGimOWenOGimOWenOGimO0ol0>enOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o01inLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol0000L0003o`0001T00_lMg`03omoO01cO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0001/000?o00006P02oakO00?ogml06ml0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogia
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00006P000ol0000K00;o7ml00ooO
g`0Jg`0MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_l0>UnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@3o`0Nm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1`0000H000?o00006@000ol0000L00;o7=l01?oOgolLg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000H0003o`0001d00_lMg`;o7Ml07?mOWenOGimOWenOGimOWenOGimOWenOGimOWel3o`0kGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00ol07Gkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00L000060003o`0001L000?o00007P02occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0001H000?o00007`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001D000?o00008002occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0001@000?o00008@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001<000?o00004@03o`h00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_l700001P000ol0000B0003o`0001<000?o00003@02occO07[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`00014000?o0000
5@000ol0000<00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o000040000ol0000F0003o`0000`00_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l70000
1P000ol0000?0003o`0001H000?o0?l03@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000h000?o00005`000ol0
o`0=00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1`0000H000?o00003@000ol0000G00;o00<0ool03002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0000`000?o0000:@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000/000?o0000:P02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0000X000?o0000:`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000T000?o0000;002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0000P000?o0000;@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000L000?o0000;P02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0000H000?o0000;`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000D000?o0000<002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0000@000?o0000<@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000<000?o0000<P02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`00008000?o0000<`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060005o`000?l0=P02occO07[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060004o`00ocL0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l700001P000ol0o`0h00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H00_li00;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H0lol70000
@@02okd0003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040
003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040003o0040
003o0040003o0040003o0040003o0040003o0040003o0040000N00CocP03o`d0000O0003o`000<l0
00?o0000300000P01_l00`3oo`0200Go00L0o`3o0?l000Co0P05o`801?nX00;o00<0ool02P000ol0
00080003o`0000/000070003o`0000<000?o0?l00`001?l00?l20007o`3o0?l0o`030005o`000?l0
0`000ol0002[0003o`3o00/000?o000020000ol0000;00001`05o`8000?o00000P04o`8000Oo0?l0
o`3o00<000Go0000o`0300GoZP000ol0000800Go1`000ol0o`0<00001`002Ol0003o0?l0o`06000:
o`00o`3o0?l0o`<000Go0000o`030005o`000?l0Z@000ol0o`0;0003o`0000L000?o0?l0300000P0
0ol0103oo`02o`<00ol00`3oo`09o`@000?o00000P03ojT00_l00`3oo`0:0003o`0000H00_l00`3o
o`0;00009`000ol0003F00009@03omP0003o0040003o00400000\
\>"],
  ImageRangeCache->{{{0, 255}, {287, 0}} -> {-1.10002, -0.113553, 0.0164708, 
  0.0164708}},
  CellTags->"FormGroupoidByTable"],

Cell[BoxData[
    \({{2, 3, 3}, {3, 2, 6}, {6, 6, 2}}\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"FormGroupoidByTable"]
}, Open  ]],

Cell[TextData[{
  "2.1.4 ",
  StyleBox["FormGroupoidFromCycles",
    FontFamily->"Courier"],
  " and ",
  StyleBox["RandomGroupoid",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->{"OtherForm", "i:7"}],

Cell[TextData[{
  "There are two other means of forming groupoids, both having specialized \
uses. The first is ",
  StyleBox["FormGroupoidFromCycles", "MR"],
  " and the second is ",
  StyleBox["RandomGroupoid", "MR"],
  "."
}], "Text",
  CellTags->"OtherForm"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FormGroupoidFromCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  StyleBox["cycles",
                    "TI"],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["o",
                    SingleLetterItalics->False], "f"}]], " ", "permutations", 
              " ", "based", " ", "on", " ", "the", " ", "list", " ", "of", 
              " ", "cycles", " ", \((or\ products\ of\ cycles)\), " ", "in", 
              " ", 
              StyleBox["cycles",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["given",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                SingleLetterItalics->False,
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->"OtherForm"],

Cell[TextData[{
  "Using ",
  StyleBox["FormGroupoidFromCycles",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"OtherForm"],

Cell[TextData[{
  "The options for ",
  StyleBox["FormGroupoidFromCycles", "MR"],
  " are similar to ",
  StyleBox["FormGroupoid", "MR"],
  ", with the addition of the ",
  StyleBox["ProductOrder", "MR"],
  " option, since we are working with permutations."
}], "Text",
  CellTags->"OtherForm"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[\(default\ value\),
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox["ProductOrder",
              "MR"], 
            StyleBox["RightToLeft",
              "MR"], 
            \(specifies\ the\ direction\ in\ which\ the\ permutations\ should
              \ be\ multiplied\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.22, 0.26, 0.52},
  RowLines->{True, False}},
  CellTags->{"OtherForm", "i:8"}],

Cell[TextData[{
  "Additional option for ",
  StyleBox["FormGroupoidFromCycles",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"OtherForm"],

Cell["\<\
Here we form a groupoid by listing the elements as either cycles or \
products of cycles (using @ as an infix operator for multiplying \
cycles).\
\>", "MathCaption",
  CellTags->"OtherForm"],

Cell[CellGroupData[{

Cell["\<\
G = FormGroupoidFromCycles[{Cycle[1], Cycle[1,3,2] @ Cycle[4,6,5] @ \
Cycle[7,8], Cycle[1,3,2] @ Cycle[4,6,5] @ Cycle[8], Cycle[1,2,3] @ \
Cycle[4,5,6] @ Cycle[8], Cycle[1,2,3] @ Cycle[4,5,6] @ Cycle[7,8],
Cycle[7,8]}]\
\>", "Input",
  CellLabel->"In[25]:=",
  CellTags->"OtherForm"],

Cell[BoxData[
    \(Groupoid[{{1, 2, 3, 4, 5, 6, 7, 8}, {3, 1, 2, 6, 4, 5, 8, 7}, {3, 1, 2, 
          6, 4, 5, 7, 8}, {2, 3, 1, 5, 6, 4, 7, 8}, {2, 3, 1, 5, 6, 4, 8, 
          7}, {1, 2, 3, 4, 5, 6, 8, 7}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"OtherForm"]
}, Open  ]],

Cell[TextData[{
  "If we use a random check on associativity (using ",
  StyleBox["RandomAssociativeQ", "MR"],
  "), the function ",
  StyleBox["ProbableGroupQ", "MR"],
  " checks to see if ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is (probably) a group."
}], "MathCaption",
  CellTags->"OtherForm"],

Cell[CellGroupData[{

Cell["{ProbableGroupQ[G], GroupInfo[G]}", "Input",
  CellLabel->"In[26]:=",
  CellTags->"OtherForm"],

Cell[BoxData[
    \({True, {"TheGroup", "this is a group of permutations", 
        "the set is closed under the operation", 
        "the left identity is {1, 2, 3, 4, 5, 6, 7, 8}", 
        "the right identity is {1, 2, 3, 4, 5, 6, 7, 8}", 
        "the identity is {1, 2, 3, 4, 5, 6, 7, 8}", 
        "every element has an inverse", 
        "the operation is probably associative with these elements", 
        "this is (probably) a group"}}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"OtherForm"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RandomGroupoid", "MR"],
  " can be used to generate groupoids of various random orders and \
characteristics."
}], "Text",
  CellTags->{"OtherForm", "i:9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RandomGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox["1",
                      "TI",
                      FontSlant->"Plain"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["o",
                    SingleLetterItalics->False], "f"}]], " ", "order", " ", 
              StyleBox["n",
                FontSlant->"Italic"], " ", "based", " ", "on", " ", "a", " ", 
              "random", 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              SuperscriptBox[
                StyleBox["n",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], "2"], "elements", " ", "from", " ", 
              "the", " ", "list", " ", "of", " ", "generic", " ", "elements", 
              " ", 
              RowBox[{"{", 
                RowBox[{
                \(g\_1\), ",", " ", \(g\_2\), ",", " ", "...", ",", " ", 
                  SubscriptBox["g", 
                    StyleBox["n",
                      FontSlant->"Italic"]]}], "}"}]}]},
          {
            RowBox[{
              StyleBox["RandomGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox["2",
                      "TI",
                      FontSlant->"Plain"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["random",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], " ", "order", " ", 
              StyleBox["n",
                FontSlant->"Italic"], " ", "where", " ", "each", " ", "row", 
              " ", "is", " ", "a", " ", "permutation", " ", "of", " ", 
              StyleBox["n",
                FontSlant->"Italic"], " ", "elements"}]},
          {
            RowBox[{
              StyleBox["RandomGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox["3",
                      "TI",
                      FontSlant->"Plain"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["random",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], " ", "order", " ", 
              StyleBox["n",
                FontSlant->"Italic"], " ", "where", " ", "each", " ", 
              "column", " ", "is", " ", "a", " ", "permutation", " ", "of", 
              " ", 
              StyleBox["n",
                FontSlant->"Italic"], " ", "elements"}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->"OtherForm"],

Cell[TextData[{
  "Variations in using ",
  StyleBox["RandomGroupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"OtherForm"],

Cell["\<\
Here we illustrate the differences among the three types of random \
groupoids of order three available with this function.\
\>", "MathCaption",
  CellTags->"OtherForm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[{RandomGroupoid[3, \ 1], RandomGroupoid[3, \ 2], \ 
        RandomGroupoid[3, \ 3]}, \ Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"OtherForm"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .35156 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00837054 0.31746 [
[ 0 0 0 0 ]
[ 1 .35156 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .35156 L
0 .35156 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00837054 0.321429 0.343192 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(g2)] .38095 .62202 0 0 Mshowa
[(g3)] .61905 .62202 0 0 Mshowa
[(g3)] .85714 .62202 0 0 Mshowa
[(g1)] .38095 .38393 0 0 Mshowa
[(g2)] .61905 .38393 0 0 Mshowa
[(g3)] .85714 .38393 0 0 Mshowa
[(g3)] .38095 .14583 0 0 Mshowa
[(g1)] .61905 .14583 0 0 Mshowa
[(g2)] .85714 .14583 0 0 Mshowa
[(g1)] .14286 .62202 0 0 Mshowa
[(g2)] .14286 .38393 0 0 Mshowa
[(g3)] .14286 .14583 0 0 Mshowa
[(g1)] .38095 .86012 0 0 Mshowa
[(g2)] .61905 .86012 0 0 Mshowa
[(g3)] .85714 .86012 0 0 Mshowa
[(Random1)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00837054 0.64881 0.343192 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(g1)] .38095 .62202 0 0 Mshowa
[(g2)] .61905 .62202 0 0 Mshowa
[(g3)] .85714 .62202 0 0 Mshowa
[(g1)] .38095 .38393 0 0 Mshowa
[(g3)] .61905 .38393 0 0 Mshowa
[(g2)] .85714 .38393 0 0 Mshowa
[(g2)] .38095 .14583 0 0 Mshowa
[(g1)] .61905 .14583 0 0 Mshowa
[(g3)] .85714 .14583 0 0 Mshowa
[(g1)] .14286 .62202 0 0 Mshowa
[(g2)] .14286 .38393 0 0 Mshowa
[(g3)] .14286 .14583 0 0 Mshowa
[(g1)] .38095 .86012 0 0 Mshowa
[(g2)] .61905 .86012 0 0 Mshowa
[(g3)] .85714 .86012 0 0 Mshowa
[(Random2)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00837054 0.97619 0.343192 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
1 .5 0 r
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.56 .37 .6 r
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(g1)] .38095 .62202 0 0 Mshowa
[(g1)] .61905 .62202 0 0 Mshowa
[(g1)] .85714 .62202 0 0 Mshowa
[(g2)] .38095 .38393 0 0 Mshowa
[(g3)] .61905 .38393 0 0 Mshowa
[(g2)] .85714 .38393 0 0 Mshowa
[(g3)] .38095 .14583 0 0 Mshowa
[(g2)] .61905 .14583 0 0 Mshowa
[(g3)] .85714 .14583 0 0 Mshowa
[(g1)] .14286 .62202 0 0 Mshowa
[(g2)] .14286 .38393 0 0 Mshowa
[(g3)] .14286 .14583 0 0 Mshowa
[(g1)] .38095 .86012 0 0 Mshowa
[(g2)] .61905 .86012 0 0 Mshowa
[(g3)] .85714 .86012 0 0 Mshowa
[(Random3)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{288, 101.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000I@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@0000T0D_l<057o301Bo`X00009000CogkdO_Anm7kdO_Anm7kdO_Anm002o`0EO_Anm7kdO_Anm7kd
O_Anm7kdO_Co01?O01GoWenOGimOWenOGimOWenOGimOWol030004omnm7kdO_Anm7kdO_Anm7kdO_@0
0_l055nOGimOWenOGimOWenOGimOWeoo4ml05Omnm7kdO_Anm7kdO_Anm7kdO_Ano`0<000CooAnm7kd
O_Anm7kdO_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Ano`0:00002@004omaOW5nLGiaOW5nLGiaOW5nLGh00_l05G5nLGiaOW5n
LGiaOW5nLGiaOW5no`0Cg`0EoimOWenOGimOWenOGimOWenOGioo00`001?oLGiaOW5nLGiaOW5nLGia
OW5n00;o01AOWenOGimOWenOGimOWenOGimOoa?O01GoLGiaOW5nLGiaOW5nLGiaOW5nLOl030004omn
LGiaOW5nLGiaOW5nLGiaOW400_l0?GiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimO
WomnLGiaOW5nLGiaOW5nLGiaOW5nLOl02P0000T001?oO_Anm7kdO_Anm7kdO_Anm7kd00;o01Enm7kd
O_Anm7kdO_Anm7kdO_Anm?l04ml05OnOGimOWenOGimOWenOGimOWenOo`0<000CogkdO_Anm7kdO_An
m7kdO_Anm002o`0DGimOWenOGimOWenOGimOWenOGolCg`0EogkdO_Anm7kdO_Anm7kdO_Anm7ko00`0
01?om7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7ko00X00009000Cog5nLGiaOW5nLGiaOW5nLGiaOP02o`0E
LGiaOW5nLGiaOW5nLGiaOW5nLGko01?O01GoWenOGimOWenOGimOWenOGimOWol030004omaOW5nLGia
OW5nLGiaOW5nLGh00_l055nOGimOWenOGimOWenOGimOWeoo4ml05OmaOW5nLGiaOW5nLGiaOW5nLGia
o`0<000CogiaOW5nLGiaOW5nLGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiao`0:00002@004omnm7kdO_Anm7kdO_Anm7kdO_@0
0_l05GkdO_Anm7kdO_Anm7kdO_Anm7kdo`0Cg`0EoimOWenOGimOWenOGimOWenOGioo00`001?oO_An
m7kdO_Anm7kdO_Anm7kd00;o01AOWenOGimOWenOGimOWenOGimOoa?O01GoO_Anm7kdO_Anm7kdO_An
m7kdO_l030004oodO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_Anm7kdO_Anm7kdO_CoWenOGimO
WenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_l02P0000T000KoLGiaOW43o`0:LGiaOW5n
LGiaOP;o00IaOW5nLGh3o`0<OW5nLGiaOW5nLGko1Ml3o`_O00KoWenOGil3o`0<WenOGimOWenOGioo
30001_maOW5nL@?o00YaOW5nLGiaOW5n0_l01EnOGimO00?o00aOWenOGimOWenOGol5g`?o2ml01_ma
OW5nL@?o00aaOW5nLGiaOW5nLOl<0006ogiaOW5n0ol02WiaOW5nLGiaOW42o`05OW5nLGh00ol04Gia
OW5nLGiaOW5noimOWenO00?o01:OGimOWenOGimOWomnLGiaOW43o`0<LGiaOW5nLGiaOW7o2P0000T0
01?oO_Anm7kdO_Com7kdO_Anm7kd00;o01Enm7kdO_Anm7koO_Anm7kdO_Anm?l02=l00ooOg`08g`0E
oimOWenOGimOoenOGimOWenOGioo00`001?oO_Anm7kdO_Com7kdO_Anm7kd00;o01AOWenOGimOWonO
GimOWenOGimOo`SO00?ogml02=l05Omnm7kdO_Anm?odO_Anm7kdO_Ano`0<000CooAnm7kdO_Anogkd
O_Anm7kdOP02o`0mm7kdO_Anm7koO_Anm7kdO_Anm?nOGimOWenOGomOWenOGimOWenOooAnm7kdO_An
m?odO_Anm7kdO_Ano`0:00002@001_maOW5nL@Co00UnooooOW5nLGh00_l01W5nLGiaOPCo00]aoooo
LGiaOW5no`05g`Co00COoooo1]l01_nOGimOW`Co00=Oool00_l01YmOWenOo``000KoLGiaOW44o`09
O_ooogiaOW5n00;o00EOWenOG`04o`03Wooo00;o00IOWenOGol5g`Co00COoooo1]l01_maOW5nL@Co
00]nooooOW5nLGiao`0<0006ogiaOW5n1?l02G7ooomaOW5nL@02o`05OW5nLGh01?l0477ooomaOW5n
LGkoWenOGil4o`03Gooo00;o00bOGimOWomnLGiaOW44o`0;O_ooogiaOW5nLOl02P0000T001?oO_An
m?odO_Com7kdO_mnm7kd00;o01Enm7kdO_mnm7koO_Anm?odO_Anm?l01=l01OoOgmoo00;O00?ogml0
1Ml05OnOGimOoenOGomOWonOGimOWenOo`0<000CogkdO_Com7kdooAnm7koO_Anm002o`0DGimOWonO
GiooWeooGimOWenOGol4g`05omoOgol00]l00ooOg`05g`0EogkdO_Com7kdooAnm7koO_Anm7ko00`0
01?om7kdO_mnm7koO_Anm?odO_An00;o03gdO_AnogkdO_mnm7kdooAnm7kdoimOWeooGimOoenOoimO
WenOGioom7kdO_Com7kdooAnm7koO_Anm7ko00X00009000Cog5nLGkoOW5nogiaOW7oLGiaOP02o`0E
LGiaOW7oLGiaog5nLGkoOW5nLGko00CO00GogmoOo`02g`03omoO00GO01GoWenOGomOWeooGimOoenO
GimOWol030004omaOW5nogiaO_mnLGiaog5nLGh00_l055nOGiooWenOoimOWonOGimOWeoo1=l01OoO
gmoo00;O00?ogml01Ml05OmaOW5nogiaO_mnLGiaog5nLGiao`0<000CogiaOW7oLGiaog5nLGkoOW5n
L@02o`0mOW5nLOmaOW7oLGiaO_mnLGiaO_nOGimOoenOGomOWeooGimOWenOogiaOW5nogiaO_mnLGia
og5nLGiao`0:00002@003?mnm7kdooAnm?odOP;o00GdO_Anm002o`0<O_Anm7koO_Anogkd0_l01gkd
O_Anm?l01=l01OoOgmoo00;O00?ogml01Ml05OnOGimOoenOGomOWenOoimOWenOo`0<000<ogkdO_Co
m7kdooAn0_l01OAnm7kd00;o01AOWenOoimOWonOGimOoenOGimOo`CO00GogmoOo`02g`03omoO00GO
00coO_Anm?odO_Com7h2o`07m7kdO_Ano`0<000<ooAnm7koO_Anogkd0_l01GkdO_An00;o00_dO_An
ogkdO_mnm002o`0WO_Anm7kdoimOWeooGimOoenOGiooWenOGioom7kdO_Com7kdooAn00;o00OdO_An
m7ko00X000090006og5nLGia1Ol0275nLOmaOW5n0_l01W5nLGiaOPGo00YnLGkoOW5nLGko1Ml5o`03
gooO00KO00KoWenOGil6o`09GiooWenOGioo00`000KoLGiaOW45o`08LGiaog5nLGh2o`05GimOWel0
1_l02ImOoenOGimOo`05g`Go00?Ooml01]l01_maOW5nL@Go00YaOW7oLGiaOW7o30001_mnLGiaOPGo
00QnLGkoOW5nL@;o00EnLGiaOP05o`0?OW5nogiaOW5noimOWenO00Ko00mOWonOGimOWomnLGiaOW40
1Ol02W5nLOmaOW5nLOl:00002@002omnm7kdO_Anm7kd00?o00GdO_Anm002o`0;O_Anm7kdO_Anm7h0
0ol01gkdO_Anm?l02]l2o`OO00coWenOGimOWenOGil2o`07GimOWenOo`0<000;ogkdO_Anm7kdO_@0
0ol01OAnm7kd00;o00]OWenOGimOWenOG`02o`07WenOGimOo`0:g`;o1ml02omnm7kdO_Anm7kd00?o
00OdO_Anm7ko00`000_om7kdO_Anm7kdOP03o`05O_Anm7h00_l02_Anm7kdO_Anm7h3o`0BO_Anm7kd
oimOWenOGimOWenO0_l04UnOGimOWoodO_Anm7kdO_Anm0?o00OdO_Anm7ko00X00009000Cog5nLGia
OW5nLGiaOW5nLGiaOP02o`0ELGiaOW5nLGiaOW5nLGiaOW5nLGko01?O01GoWenOGimOWenOGimOWenO
GimOWol030004omaOW5nLGiaOW5nLGiaOW5nLGh00_l055nOGimOWenOGimOWenOGimOWeoo4ml05Oma
OW5nLGiaOW5nLGiaOW5nLGiao`0<000CogiaOW5nLGiaOW5nLGiaOW5nL@02o`0mOW5nLGiaOW5nLGia
OW5nLGiaO_nOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiao`0:00002@004omn
m7kdO_Anm7kdO_Anm7kdO_@00_l05GkdO_Anm7kdO_Anm7kdO_Anm7kdo`0Cg`0EoimOWenOGimOWenO
GimOWenOGioo00`001?oO_Anm7kdO_Anm7kdO_Anm7kd00;o01AOWenOGimOWenOGimOWenOGimOoa?O
01GoO_Anm7kdO_Anm7kdO_Anm7kdO_l030004oodO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_An
m7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_l02P0000T0
01?oLGiaOW5nLGiaOW5nLGiaOW5n00;o01EaOW5nLGiaOW5nLGiaOW5nLGiaO_l04ml05OnOGimOWenO
GimOWenOGimOWenOo`0<000Cog5nLGiaOW5nLGiaOW5nLGiaOP02o`0DGimOWenOGimOWenOGimOWenO
GolCg`0Eog5nLGiaOW5nLGiaOW5nLGiaOW7o00`001?oOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGia
OW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW7o00X0
0009000CogkdO_Anm7kdO_Anm7kdO_Anm002o`0EO_Anm7kdO_Anm7kdO_Anm7kdO_Co01?O01GoWenO
GimOWenOGimOWenOGimOWol030004omnm7kdO_Anm7kdO_Anm7kdO_@00_l055nOGimOWenOGimOWenO
GimOWeoo4ml05Omnm7kdO_Anm7kdO_Anm7kdO_Ano`0<000CooAnm7kdO_Anm7kdO_Anm7kdOP02o`0m
m7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
o`0:00002@004omaOW5nLGiaOW5nLGiaOW5nLGh00_l05G5nLGiaOW5nLGiaOW5nLGiaOW5no`0Cg`0E
oimOWenOGimOWenOGimOWenOGioo00`001?oLGiaOW5nLGiaOW5nLGiaOW5n00;o01AOWenOGimOWenO
GimOWenOGimOoa?O01GoLGiaOW5nLGiaOW5nLGiaOW5nLOl030004omnLGiaOW5nLGiaOW5nLGiaOW40
0_l0?GiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGia
OW5nLOl02P0000T001?oO_Anm7kdO_Anm7kdO_Anm7kd00;o01Enm7kdO_Anm7kdO_Anm7kdO_Anm?l0
4ml05OnOGimOWenOGimOWenOGimOWenOo`0<000CogkdO_Anm7kdO_Anm7kdO_Anm002o`0DGimOWenO
GimOWenOGimOWenOGolCg`0EogkdO_Anm7kdO_Anm7kdO_Anm7ko00`001?om7kdO_Anm7kdO_Anm7kd
O_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7ko00X0000905;o301Ao``0D_l:00002@004omOWenOGimOWenOGimOWenOGil00_lDg`0Y
oimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm?l030004omOWenOGimOWenOGimO
WenOGil00_lCg`0YogkdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGol030004onO
GimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_An
m?nOGimOWenOGimOWenOGimOWenOGol02P0000T001?oGimOWenOGimOWenOGimOWenO00;o5=l0:OnO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGko00`001?oGimOWenOGimOWenOGimO
WenO00;o4ml0:OmaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWeoo00`001?oWenO
GimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGko
WenOGimOWenOGimOWenOGimOWeoo00X00009000CoenOGimOWenOGimOWenOGimOW`02oaCO02WoWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdo`0<000CoenOGimOWenOGimOWenOGimO
W`02oa?O02WoO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOo`0<000CoimOWenO
GimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdoimO
WenOGimOWenOGimOWenOGimOo`0:00002@004omOWenOGimOWenOGimOWenOGil00_lDg`0YoimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaO_l030004omOWenOGimOWenOGimOWenOGil0
0_lCg`0Yog5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGol030004onOGimOWenO
GimOWenOGimOWel00_l0?ImOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimO
WenOGimOWenOGimOWenOGol02P0000T001?oGimOWenOGimOWenOGimOWenO00;o5=l0:OnOGimOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Co00`001?oGimOWenOGimOWenOGimOWenO00;o
4ml0:Omnm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWeoo00`001?oWenOGimOWenO
GimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_CoWenOGimO
WenOGimOWenOGimOWeoo00X000090006oenOGimO0ol02UnOGimOWenOGil2o`KO0ol;g`06oimOWenO
0ol04ImOWenOGimOWenOogiaOW5n00?o00anLGiaOW5nLGiaO_l<0006oenOGimO0ol02UnOGimOWenO
Gil2o`GO0ol;g`06og5nLGia0ol04G5nLGiaOW5nLGiaoenOGimO00?o00aOWenOGimOWenOGol<0006
oimOWenO0ol02YmOWenOGimOWel2o`05WenOGil00ol04ImOWenOGimOWenOogiaOW5n00?o019nLGia
OW5nLGiaO_nOGimOWel3o`0<GimOWenOGimOWeoo2P0000T001?oGimOWenOGiooWenOGimOWenO00;o
2Ml00ooOg`08g`0YoimOWenOGimOoenOGimOWenOGioom7kdO_Anm7koO_Anm7kdO_Anm?l030004omO
WenOGimOWonOGimOWenOGil00_l8g`03omoO00SO02WoO_Anm7kdO_Com7kdO_Anm7kdO_mOWenOGimO
WonOGimOWenOGimOo`0<000CoimOWenOGimOoenOGimOWenOG`02o`0mWenOGimOWeooGimOWenOGimO
WoodO_Anm7kdO_mnm7kdO_Anm7kdoimOWenOGimOWonOGimOWenOGimOo`0:00002@001_mOWenOG`Co
00>Oool00_l015nOGil2o`KO1?l01=ooool6g`06oimOWenO1?l00eooo`02o`0;WenOGiooOW5nLGh0
1?l02g7ooomaOW5nLGko00`000KoGimOWel4o`03Wooo00;o00AOWenO0_l5g`Co00COoooo1]l01_ma
OW5nL@Co011nooooOW5nLGiaoenOGimO1?l00iooo`02o`06GimOWeoo30001_nOGimOW`Co00=Oool0
0_l019mOWel2o`05WenOGil01?l00eooo`02o`0;WenOGiooOW5nLGh01?l04G7ooomaOW5nLGkoWenO
GimO00Co00>Oool00_l01UnOGimOo`X00009000CoenOGiooWenOoimOoenOGimOW`02o`GO00GogmoO
o`02g`03omoO00GO02WoWenOGomOWeooGiooWenOGimOWoodO_AnogkdO_mnm7kdooAnm7kdo`0<000C
oenOGiooWenOoimOoenOGimOW`02o`CO00GogmoOo`02g`03omoO00GO02WoO_Anm?odO_Com7kdO_mn
m7kdO_mOWenOoimOWonOGomOWenOGimOo`0<000CoimOWeooGimOoenOoimOWenOG`02o`0mWenOGomO
WeooGiooWenOGimOWoodO_AnogkdO_mnm7kdooAnm7kdoimOWenOoimOWonOGomOWenOGimOo`0:0000
2@004omOWenOoimOWonOGiooWenOGil00_l5g`05omoOgol00]l00ooOg`05g`0YoimOWeooGimOoenO
GomOWenOGiooOW5nLOmaOW7oLGiaO_mnLGiaO_l030004omOWenOoimOWonOGiooWenOGil00_l4g`05
omoOgol00]l00ooOg`05g`0Yog5nLGkoOW5nogiaOW7oLGiaOW7oGimOWonOGiooWenOoimOWenOGol0
30004onOGimOoenOGomOWeooGimOWel00_l0?ImOWeooGimOoenOGomOWenOGiooOW5nLOmaOW7oLGia
O_mnLGiaO_nOGimOWonOGiooWenOoimOWenOGol02P0000T001?oGimOWonOGiooWenOGomOWenO00;o
1Ml01OoOgmoo00;O00?ogml01Ml08?nOGimOoenOGomOWenOoimOWenOooAnm7koO_Anogkd0_l01gkd
O_Anm?l030004omOWenOoimOWonOGimOoenOGil00_l4g`05omoOgol00]l00ooOg`05g`0<ogkdO_Co
m7kdooAn0_l06oAnm7kdO_mOWenOoimOWonOGimOoenOGimOo`0<000CoimOWeooGimOoenOGiooWenO
G`02o`0OWenOGomOWeooGimOWonOGimOWoodO_AnogkdO_mnm002o`0LO_Anm7kdoimOWenOoimOWonO
GimOoenOGimOo`X000090006oenOGimO1_l01imOoenOGil00_l6g`Go00?Ooml01]l01_nOGimOW`Ko
00iOWonOGimOWomnLGiaOPGo00YnLGkoOW5nLGko30001_mOWenOG`Ko00NOGomOWenO00;o1Ml5o`03
gooO00KO00KoLGiaOW45o`0?LGiaog5nLGiaoenOGimO00Ko00VOGomOWenOGol030001_nOGimOW`Ko
00MOWonOGimO00;o00FOGimOW`06o`0>GiooWenOGiooOW5nLGh5o`0@OW5nogiaOW5noimOWenOG`Ko
00VOGomOWenOGol02P0000T000coGimOWenOGimOWel2o`05WenOGil00_l;g`;o1ml03?nOGimOWenO
GimOW`;o015OWenOGioom7kdO_Anm7kdOP03o`07O_Anm7kdo`0<000<oenOGimOWenOGimO0_l01ImO
WenO00;o2]l2o`OO00_oO_Anm7kdO_Anm003o`0Bm7kdO_AnoenOGimOWenOGimO0_l01imOWenOGol0
30003?nOGimOWenOGimOW`;o00EOWenOG`02o`0;WenOGimOWenOGil00_l04EnOGimOWoodO_Anm7kd
O_An00?o01=nm7kdO_CoWenOGimOWenOGimO00;o00NOGimOWeoo00X00009000CoenOGimOWenOGimO
WenOGimOW`02oaCO02WoWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5no`0<000C
oenOGimOWenOGimOWenOGimOW`02oa?O02WoLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimO
WenOGimOo`0<000CoimOWenOGimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOo`0:00002@004omOWenOGimOWenOGimO
WenOGil00_lDg`0YoimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm?l030004omO
WenOGimOWenOGimOWenOGil00_lCg`0YogkdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGol030004onOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGol02P0000T001?oGimOWenOGimOWenOGimO
WenO00;o5=l0:OnOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGko00`001?oGimO
WenOGimOWenOGimOWenO00;o4ml0:OmaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimO
Weoo00`001?oWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWeoo00X00009000CoenOGimOWenOGimOWenOGimO
W`02oaCO02WoWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdo`0<000CoenOGimO
WenOGimOWenOGimOW`02oa?O02WoO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimO
o`0<000CoimOWenOGimOWenOGimOWenOG`02o`0mWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOo`0:00002@004omOWenOGimOWenOGimOWenOGil0
0_lDg`0YoimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaO_l030004omOWenOGimO
WenOGimOWenOGil00_lCg`0Yog5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGol0
30004onOGimOWenOGimOWenOGimOWel00_l0?ImOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGol02P0000T001?oGimOWenOGimOWenOGimOWenO00;o
5=l0:OnOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Co00`001?oGimOWenOGimO
WenOGimOWenO00;o4ml0:Omnm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWeoo00`0
01?oWenOGimOWenOGimOWenOGimO00;o03fOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_CoWenOGimOWenOGimOWenOGimOWeoo00X0000905;o301Ao``0D_l:00002@000ooOg`0@g`;o
03eOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kd
O_Co00`000?ogml04=l2oa?O02WoGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
o`0<0003omoO013O0_lCg`03omoO017O00?ogml04]l00ol0000800002@000ooOg`0@g`;o03eOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGko00`0
00?ogml04=l2oa?O02WoGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiao`0<0003
omoO013O0_lCg`03omoO017O00?ogml04]l00ol0000800002@000ooOg`0@g`;o03eOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Co00`000?ogml0
4=l2oa?O02WoGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Ano`0<0003omoO013O
0_lCg`03omoO017O00?ogml04]l00ol0000800002@000ooOg`0@g`;o03eOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGko00`000?ogml04=l2oa?O
02WoGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiao`0<0003omoO013O0_lCg`03
omoO017O00?ogml04]l00ol0000800002@000ooOg`0@g`;o03eOWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Co00`000?ogml04=l2oa?O02WoGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Ano`0<0003omoO013O0_lCg`03omoO017O
00?ogml04]l00ol0000800002@000ooOg`03g`?o2]l2o`06GimOWenO0ol04ImOWenOGimOWenOogia
OW5n00?o015nLGiaOW5nLGiaO_mnLGiaOP03o`0<OW5nLGiaOW5nLGko30000ooOg`03g`?o2]l2o`GO
0ol;g`06oenOGimO0ol04EnOGimOWenOGimOog5nLGia00?o00aaOW5nLGiaOW5nLOl<0003omoO00?O
0ol:g`;o1Ml3o`_O00?ogml00ml3o`_O00?ogml01=l3o`_O00?o0000200000T000?ogml01]l00ooO
g`07g`;o03eOWenOGimOWeooGimOWenOGimOWoodO_Anm7kdO_mnm7kdO_Anm7kdooAnm7kdO_Anogkd
O_Anm7kdO_Co00`000?ogml01]l00ooOg`07g`;o2=l00ooOg`08g`0YoenOGimOWenOoimOWenOGimO
WeooO_Anm7kdO_Com7kdO_Anm7kdO_l030000ooOg`06g`03omoO00OO0_l8g`03omoO00SO00?ogml0
1]l00ooOg`08g`03omoO00OO00?ogml02=l00ol0000800002@000ooOg`03g`Co00COoooo1Ml2o`06
GimOWenO1?l00eooo`02o`0;WenOGiooOW5nLGh01?l0477ooomaOW5nLGkoOW5nLGh4o`0;LOooog5n
LGiaO_l030000ooOg`03g`Co00COoooo1Ml2o`GO1?l01=ooool6g`06oenOGimO1?l00iooo`02o`0;
GimOWeooLGiaOW401?l02gkooomnLGiaOW7o00`000?ogml00ml4o`04goooo`GO0_l5g`Co00COoooo
1]l00ooOg`03g`Co00COoooo1]l00ooOg`04g`Co00COoooo1]l00ol0000800002@000ooOg`02g`05
omoOgol00]l00ooOg`04g`;o03eOWenOGomOWeooGiooWenOGimOWoodO_AnogkdO_mnm7kdooAnm7kd
ooAnm7koO_AnogkdO_Com7kdO_Co00`000?ogml00]l01OoOgmoo00;O00?ogml01=l2o`CO00GogmoO
o`02g`03omoO00GO02WoGimOWonOGiooWeooGimOWenOGomnm7kdooAnm?odO_AnogkdO_Ano`0<0003
omoO00;O00GogmoOo`02g`03omoO00CO0_l4g`05omoOgol00]l00ooOg`05g`03omoO00;O00GogmoO
o`02g`03omoO00GO00?ogml00ml01OoOgmoo00;O00?ogml01Ml00ol0000800002@000ooOg`02g`05
omoOgol00]l00ooOg`04g`;o03eOWenOGomOWeooGimOoenOGimOWomnLGiaog5nLOmaOW5nogiaOW5n
ogiaOW7oLGiaog5nLGkoOW5nLGko00`000?ogml00]l01OoOgmoo00;O00?ogml01=l2o`CO00GogmoO
o`02g`03omoO00GO02WoGimOWonOGiooWenOoimOWenOGomaOW5nogiaO_mnLGiaog5nLGiao`0<0003
omoO00;O00GogmoOo`02g`03omoO00CO0_l4g`05omoOgol00]l00ooOg`05g`03omoO00;O00GogmoO
o`02g`03omoO00GO00?ogml00ml01OoOgmoo00;O00?ogml01Ml00ol0000800002@000ooOg`02g`05
omoOgol00]l00ooOg`04g`;o021OWenOGomOWeooGimOWonOGimOWoodO_AnogkdO_mnm0;o019nm7kd
O_Com7kdO_mnm7koO_@2o`07O_Anm7kdo`0<0003omoO00;O00GogmoOo`02g`03omoO00CO0_l4g`05
omoOgol00]l00ooOg`05g`0PoenOGiooWenOoimOWeooGimOWeooO_Anm?odO_Com7h2o`07m7kdO_An
o`0<0003omoO00;O00GogmoOo`02g`03omoO00CO0_l4g`05omoOgol00]l00ooOg`05g`03omoO00;O
00GogmoOo`02g`03omoO00GO00?ogml00ml01OoOgmoo00;O00?ogml01Ml00ol0000800002@000ooO
g`03g`Go00?Ooml01Ml2o`06GimOWenO1_l03UnOoimOWenOogiaOW5n1Ol03giaO_mnLGiaO_mnLGia
OP05o`0:OW5nogiaOW5no``000?ogml00ml5o`03gooO00GO0_l5g`Go00?Ooml01]l01_mOWenOG`Ko
00jOGomOWenOGomaOW5nL@Go00YaOW7oLGiaOW7o30000ooOg`03g`Go00?Ooml01Ml2o`GO1Ol00moo
g`06g`03omoO00?O1Ol00moog`06g`03omoO00CO1Ol00moog`06g`03o`0000P000090003omoO00SO
0_l6g`;o00aOWenOGimOWenOGil2o`0AGimOWenOooAnm7kdO_Anm7h00ol04GkdO_Anm?odO_Anm7kd
O_An00?o00Mnm7kdO_Co00`000?ogml02=l2o`KO0_l:g`;o1ml03?mOWenOGimOWenOG`;o016OGimO
WeooO_Anm7kdO_Anm003o`07m7kdO_Ano`0<0003omoO00SO0_l6g`;o2]l2o`OO00?ogml02=l2o`OO
00?ogml02Ml2o`OO00?o0000200000T000?ogml04=l2o`0mGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5no`0<0003omoO013O0_lCg`0YoenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLOl030000ooOg`0@g`;o4ml00ooOg`0Ag`03
omoO01;O00?o0000200000T000?ogml04=l2o`0mGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdo`0<0003omoO013O0_lCg`0YoenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_l030000ooOg`0@g`;o4ml00ooOg`0Ag`03omoO01;O
00?o0000200000T000?ogml04=l2o`0mGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5n
LGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5no`0<0003omoO013O0_lCg`0YoenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLOl030000ooOg`0@g`;o4ml00ooOg`0Ag`03omoO01;O00?o0000
200000T000?ogml04=l2o`0mGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm?od
O_Anm7kdO_Anm7kdO_Anm7kdo`0<0003omoO013O0_lCg`0YoenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_l030000ooOg`0@g`;o4ml00ooOg`0Ag`03omoO01;O00?o0000200000T0
00?ogml04=l2o`0mGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5n
LGiaOW5nLGiaOW5no`0<0003omoO013O0_lCg`0YoenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLOl030000ooOg`0@g`;o4ml00ooOg`0Ag`03omoO01;O00?o0000200000T000?ogml0
4=l2o`0mGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kd
O_Anm7kdo`0<0003omoO013O0_lCg`0YoenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_l030000ooOg`0@g`;o4ml00ooOg`0Ag`03omoO01;O00?o0000200000T000?ogml04=l2o`0m
GimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5n
o`0<0003omoO013O0_lCg`0YoenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLOl0
30000ooOg`0@g`;o4ml00ooOg`0Ag`03omoO01;O00?o0000200000P0Dol;05;o2`1Co`X0000805?o
2`1Bo`/0Dol:00002@000ol0000?00?o5=l0:OnOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Co00`000?o00003`03oa?O02WoGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Ano`0<0003o`0000l00olCg`0ZoimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kd
O_Anm7ko2P0000T000?o00003P001?l0oolDg`0YoimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaO_l030000ol0000>0004o`3ooa?O02WoGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiao`0<0003o`0000h000Co0?oo4ml0:_nOGimOWenOGimOWenOGimOWenOogiaOW5n
LGiaOW5nLGiaOW5nLGiao`X000090004o`0000;o00<0ool01`000ol00002oaCO02WoWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdo`0<0003o`0000;o00<0ool020000ol00002oa?O
02WoGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Ano`0<0004o`0000;o00<0ool0
1`000ol00002oa?O02[oWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_l:0000
2@000ol000020003o`3o00L000Co00000_lDg`0YoimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaO_l030001ol0003o0?l020001?l00002oa?O02WoGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiao`0<0003o`00008000?o0?l01`001?l00002oa?O02[oWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLOl:00002@000ol000030003o`0000D000?o0000
0P02o`KO0ol;g`06oimOWenO0ol04ImOWenOGimOWenOooAnm7kd00?o00cdO_Anm7kdO_Anm?l<0003
o`00008000?o00001P000ol0000200;o1Ml3o`_O00KoGimOWel3o`0AGimOWenOGimOWeooO_Anm7h0
0ol037kdO_Anm7kdO_Ano``000?o00000`000ol000050003o`0000800_l5g`?o2ml01_nOGimOW`?o
01:OGimOWenOGimOWoodO_Anm7h3o`0<O_Anm7kdO_Anm7ko2P0000T000?o00000P000ol0o`050003
o`0000<00_l9g`03omoO00SO02WoWenOGimOWeooGimOWenOGimOWomnLGiaOW5nLOmaOW5nLGiaOW5n
o`0<0007o`000?l0o`060003o`0000<00_l8g`03omoO00SO02WoGimOWenOGiooWenOGimOWenOGoma
OW5nLGiaO_mnLGiaOW5nLGiao`0<0003o`00008000?o0?l01@000ol0000300;o2=l00ooOg`08g`0Z
oimOWenOGimOoenOGimOWenOGiooOW5nLGiaOW5nogiaOW5nLGiaOW7o2P0000T000Co00000_l00`3o
o`030003o`0000@00_l6g`Co00COoooo1]l01_nOGimOW`Co00=Oool00_l02imOWenOooAnm7kd00Co
00]nooooO_Anm7kdo`0<0003o`0000;o00<0ool010000ol0000400;o1Ml4o`04goooo`KO00KoGimO
Wel4o`03Wooo00;o00]OWenOGomnm7kdOP04o`0;m?ooooAnm7kdO_l030001?l00002o`030?oo00<0
00?o00001002o`GO1?l01=ooool6g`06oimOWenO1?l00eooo`02o`0<WenOGioom7kdO_An1?l02oCo
ooodO_Anm7ko00X000090003o`0000P000?o00001@02o`GO00GogmoOo`02g`03omoO00GO02WoWenO
GomOWeooGiooWenOGimOWomnLGiaog5nLOmaOW5nogiaOW5no`0<0003o`0000P000?o00001@02o`CO
00GogmoOo`02g`03omoO00GO02WoGimOWonOGiooWeooGimOWenOGomaOW5nogiaO_mnLGiaog5nLGia
o`0<0003o`0000P000?o00001@02o`CO00GogmoOo`02g`03omoO00GO02[oWenOGomOWeooGiooWenO
GimOWomnLGiaO_mnLGkoOW5nLOmaOW5nLOl:00002@000ol000070003o`3o00;o1002o`GO00GogmoO
o`02g`03omoO00GO02WoWenOGomOWeooGimOoenOGimOWoodO_AnogkdO_mnm7kdooAnm7kdo`0<0003
o`0000L000?o0?l00_l400;o1=l01OoOgmoo00;O00?ogml01Ml0:OmOWenOoimOWonOGiooWenOGimO
ogkdO_Com7kdooAnm7koO_Anm7ko00`000?o00001`000ol0o`02o`@00_l4g`05omoOgol00]l00ooO
g`05g`0ZoimOWeooGimOoenOGomOWenOGioom7kdO_Com7kdooAnm7koO_Anm7ko2P0000T000?o0000
1P001Ol0003o00D00_l5g`05omoOgol00]l00ooOg`05g`0PoimOWeooGimOoenOGiooWenOGiooOW5n
LOmaOW7oLGh2o`07LGiaOW5no`0<0003o`0000H000Go0000o`0500;o1=l01OoOgmoo00;O00?ogml0
1Ml08?mOWenOoimOWonOGimOoenOGimOog5nLGkoOW5nogia0_l01giaOW5nLOl030000ol000060005
o`000?l01@02o`CO00GogmoOo`02g`03omoO00GO027oWenOGomOWeooGimOWonOGimOWomnLGiaO_mn
LGkoOW400_l01giaOW5nLOl02P0000T000?o00001@000ol000030003o`0000800_l6g`Go00?Ooml0
1]l01_nOGimOW`Ko00iOWonOGimOWoodO_Anm0Go00[dO_Com7kdO_Co30000ol000050003o`0000<0
00?o00000P02o`GO1Ol00moog`06g`06oenOGimO1_l03YmOoenOGimOogkdO_An1Ol02WkdO_mnm7kd
O_l<0003o`0000D000?o00000`000ol0000200;o1Ml5o`03gooO00KO00KoWenOGil6o`0?GiooWenO
Gioom7kdO_An00Go00Ynm7koO_Anm7ko2P0000T000?o000010000ol000040003o`0000800_l;g`;o
1ml03?nOGimOWenOGimOW`;o015OWenOGiooOW5nLGiaOW5nL@03o`07LGiaOW5no`0<0003o`0000@0
00?o000010000ol0000200;o2]l2o`OO00coGimOWenOGimOWel2o`0AWenOGimOog5nLGiaOW5nLGh0
0ol01giaOW5nLOl030000ol000040003o`0000@000?o00000P02o`[O0_l7g`0<oimOWenOGimOWenO
0_l04UnOGimOWomnLGiaOW5nLGiaOP?o00MnLGiaOW7o00X000090003o`0000<000?o000010000ol0
o`0300;o5=l0:OnOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Co00`000?o0000
0`000ol000040003o`3o00<00_lCg`0YoenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_l030000ol000030003o`0000@000?o0?l00`02oa?O02[oWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdO_l:00002@000ol000020003o`0000D000?o0?l00`02oaCO02WoWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5no`0<0003o`00008000?o00001@000ol0
o`0300;o4ml0:OmOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW7o00`000?o0000
0P000ol000050003o`3o00<00_lCg`0ZoimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5n
LGiaOW7o2P0000T000Go0000o`0700;o00<0ool00P02oaCO02WoWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdo`0<0005o`000?l01`02o`030?oo00800_lCg`0YoenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_l030001Ol0003o00L00_l00`3oo`0200;o4ml0:_nO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Ano`X000090004o`00o`l00_lDg`0Y
oimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaO_l030001?l00?l?00;o4ml0:OmO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW7o00`000Co003o3`02oa?O02[oWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLOl:00002@000ol0o`0@00;o5=l0:OnO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Co00`000?o0?l04002oa?O02WoGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Ano`0<0003o`3o01000_lCg`0ZoimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7ko2P0000T00_lA00;o5=l0:OnOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGko00`00_lA00;o4ml0:OmOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW7o00`00_lA00;o4ml0:_nOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiao`X0000905;o301Ao``0D_l:00007002oe`00_mK00;oA`000?l0
8@000?l08@000?l08@000?l08@0005800omJ00?oF`03oa00001C0003o`0005X000?o0000F`000ol0
000?00002@02o`800_l00`3oo`03o`040?oo00;o0P05o`040?ooo`8000Ko0?l0o`03o`T00_l00`3o
o`090003o`3o00T000?o00004002o`800_l00`3oo`03o`040?oo00;o0P05o`040?ooo`8000Ko0?l0
o`04o`L00_l00`3oo`090003o`3o00T000?o00004002o`800_l00`3oo`03o`040?oo00;o0P05o`04
0?ooo`8000Ko0?l0o`03o`T00_l00`3oo`090003o`3o00T000?o00003P0000X000Co0?oo0P001?l0
0?l20004o`00o`8000Oo0000o`3o00<000Oo0?l0o`3o008000?o00002@000ol0o`0;0003o`0000P0
00?o00004@001?l0ool20004o`00o`8000Co003o0P001ol0003o0?l00`001ol0o`3o0?l00P000ol0
00080003o`3o00/000?o000020000ol0000A0004o`3oo`8000Co003o0P001?l00?l20007o`000?l0
o`030007o`3o0?l0o`040003o`0000L000?o0?l02`000ol000080003o`0000h0000:00?o0`04o`80
00Co003o0P001ol0003o0?l00`001ol0o`3o0?l00P000ol0000:0003o`0000P01Ol70003o`3o0180
0ol300Co0P001?l00?l20007o`000?l0o`030007o`3o0?l0o`030003o`0000P000?o00002005o`L0
00?o0?l04P03o`<01?l20004o`00o`8000Oo0000o`3o00<000Oo0?l0o`3o00@000?o000020000ol0
000800Go1`000ol0o`0?00002P001?l00?l50004o`00o`8000Co003o0`000ol0o`030007o`3o0?l0
o`020003o`0000T000?o0?l02`000ol000070003o`3o018000Co003o1@001?l00?l20004o`00o`<0
00?o0?l00`001ol0o`3o0?l010000ol000060003o`3o00/000?o00001`000ol0o`0B0004o`00o`D0
00Co003o0P001?l00?l30003o`3o00<000Oo0?l0o`3o00800_l:0003o`3o00/000?o00001`000ol0
o`0?00002P001?l00?l300?o00<0ool00ol300Co0P03o`030?oo00Co0P000ol0000800;o00<0ool0
4`02o`030?oo014000Co003o0`03o`030?oo00?o0`04o`800ol00`3oo`04o`050?l00?l01`02o`03
0?oo01<00_l00`3oo`0A0004o`00o`<00ol00`3oo`03o`<01?l200?o00<0ool01?l40003o`0000H0
0_l00`3oo`0C00;o00<0ool03P0000T01?lC0003o`0000/00_lg00Co4`000ol0000<00;o=@04oa<0
00?o00002`03oc@0000O00;oG002oe/00_m40000\
\>"],
  ImageRangeCache->{{{0, 287}, {100.188, 0}} -> {-0.086165, -0.0263672, 
  0.0110534, 0.0110534}, {{7.75, 92.5625}, {97.75, 
  2.375}} -> {-1.48483, -0.233282, 0.0495418, 0.0495418}, {{101.062, 
  185.875}, {97.75, 2.375}} -> {-6.1077, -0.233282, 0.0495418, 0.0495418}, {{
  194.375, 279.188}, {97.75, 2.375}} -> {-10.7306, -0.233282, 0.0495418, 
  0.0495418}},
  CellTags->"OtherForm"]
}, Open  ]],

Cell[TextData[{
  "2.2 Structure of ",
  StyleBox["Groupoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->{"Structure", "i:10"}],

Cell[TextData[{
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" equivalent of a groupoid is an object whose head is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " and has two arguments. The first argument is the list of elements, and \
the second is the operation for the groupoid. (Actually, there is a third \
argument that is appended on creation that is suppressed and is used for \
internal purposes. This is further impetus for defining groupoids with one of \
the functions designed for this purpose. While giving true confessions, the \
real head is the symbol ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[", which is private to the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Core", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" package, but is formatted to look like ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".) ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  CellTags->"Structure"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Elements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Elements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox[
                      FormBox[\({G\_1\),
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[\(G\_2\),
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["\[Ellipsis]",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[\(G\_n}\),
                          "TraditionalForm"],
                        "Text"]}]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoids", 
                StyleBox[
                  FormBox[\({G\_1\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(G\_2\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["\[Ellipsis]",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_n}\),
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Domain",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["Elements",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["G",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["Operation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Operation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox[
                      FormBox[\({G\_1\),
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[\(G\_2\),
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["\[Ellipsis]",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[\(G\_n}\),
                          "TraditionalForm"],
                        "Text"]}]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]]}], " ", 
              RowBox[{
                RowBox[{"groupoids", " ", 
                  StyleBox[
                    FormBox[\({G\_1\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(G\_2\),
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(G\_n}\),
                      "TraditionalForm"],
                    "Text"]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Structure", "i:11"}],

Cell[TextData[{
  "Functions for working with the structure of a ",
  StyleBox["Groupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Structure"],

Cell["The elements in any groupoid are easily retrieved.", "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Elements[AlternatingGroup[4]]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({{1, 2, 3, 4}, {1, 3, 4, 2}, {1, 4, 2, 3}, {2, 1, 4, 3}, {2, 3, 1, 4}, {
        2, 4, 3, 1}, {3, 1, 2, 4}, {3, 2, 4, 1}, {3, 4, 1, 2}, {4, 1, 3, 2}, {
        4, 2, 1, 3}, {4, 3, 2, 1}}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "For two or more groupoids, simply provide a list of groupoids to either ",
  StyleBox["Elements", "MR"],
  " or ",
  StyleBox["Operation", "MR"],
  ". (Many functions in ",
  StyleBox["AbstractAlgebra", "MR"],
  " can take a list of arguments like this.)"
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Elements[{Dihedral[3], \ TwistedZ[13]}], Operation[{Z[9], \ U[12]}]}
      \)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({{{1, Rot, Rot\^2, Ref, Rot**Ref, Rot\^2**Ref}, {0, 1, 2, 3, 4, 5, 6, 
          7, 8, 9, 10, 11}}, {Mod[#1 + #2, 9]&, Mod[#1\ #2, 12]&}}\)], 
  "Output",
  CellLabel->"Out[29]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Although the data structure ",
  StyleBox["Groupoid", "MR"],
  " consists of just elements and an operation, there are several other \
functions related to the structure of a groupoid."
}], "Text",
  CellTags->"Structure"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GroupoidName",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["name",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["OperatorSymbol",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(return\ the\ symbol\ used\ for\ the\ operator\ of\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["G",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["SortGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sorted",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["according",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Sort",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["function",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ReorderGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["newOrder",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["order",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["given",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["newOrder",
                FontSlant->"Italic"]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["ElementQ",
                      "MR"], 
                    StyleBox["[",
                      "MR"], \(x, \ G\), 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{"give", " ", 
                StyleBox["True",
                  "MR"], " ", "if", 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "is", " ", "an", " ", "element", 
                " ", "of", " ", "the", " ", "groupoid", " ", 
                StyleBox["G",
                  FontSlant->"Italic"]}], ",", " ", 
              RowBox[{"and", " ", 
                StyleBox["False",
                  "MR"], " ", "otherwise"}]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["ElementsQ",
                      "MR"], 
                    StyleBox["[",
                      "MR"], \(els, \ G\), 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{"give", " ", 
                StyleBox["True",
                  "MR"], " ", "if", " ", "all", " ", "members", " ", "of", 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["els",
                  FontSlant->"Italic"], " ", "are", " ", "elements", " ", 
                "of"}], " ", 
              RowBox[{
                RowBox[{"the", " ", "groupoid", " ", 
                  StyleBox["G",
                    FontSlant->"Italic"]}], ",", " ", 
                RowBox[{"and", " ", 
                  StyleBox["False",
                    "MR"], " ", "otherwise"}]}]}]},
          {
            RowBox[{
              StyleBox["GeneratingSet",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
              "give", " ", "a", " ", "set", " ", "of", " ", "generators", 
                " ", "for", " ", "determining", " ", 
                StyleBox["G",
                  FontSlant->"Italic"]}], ",", " ", \(if\ known\), ",", " ", 
              \(and\ {}\ otherwise\)}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Structure", "i:12"}],

Cell["Functions related to the structure of a groupoid.", "Caption",
  CellTags->"Structure"],

Cell[TextData[{
  "Every ",
  StyleBox["Groupoid", "MR"],
  " has a name, even if it is the generic name ",
  StyleBox["TheGroup", "MR"],
  "."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[GroupoidName, \ 
      someGroupoids\  = 
        \ {Z[10], \ DihedralGroup[5], \ RootsOfUnity[8], \ MinTaker[5], \ 
          FormGroupoid[{3, \ 4}, \ Plus]}]\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({"Z[10]", "D[5]", "RootsOfUnity[8]", "MinTaker[5]", "TheGroup"}\)], 
  "Output",
  CellLabel->"Out[30]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Additionally, every ",
  StyleBox["Groupoid", "MR"],
  " has a symbol for its operator, defaulting to * if not specified."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[OperatorSymbol, \ someGroupoids]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({"+", "*", "*", "*", "*"}\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "While ",
  StyleBox["SubgroupGenerated", "MR"],
  " returns its list of elements in the order they are generated, applying ",
  StyleBox["SortGroupoid", "MR"],
  " to the result reorders them."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({G\  = \ SubgroupGenerated[U[7], \ 3], \ SortGroupoid[G]}\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({Groupoid[{3, 2, 6, 4, 5, 1}, Mod[#1\ #2, 7]&], 
      Groupoid[{1, 2, 3, 4, 5, 6}, Mod[#1\ #2, 7]&]}\)], "Output",
  CellLabel->"Out[32]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "If we want the elements to appear in some other order, it can always be \
arranged with the ",
  StyleBox["ReorderGroupoid", "MR"],
  " function. Note that this function only changes the order in which the \
elements appear; there is no structural change to the mathematical object."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({H = \ Randomize[{1, 2, 3, 4, 5, 6}], ReorderGroupoid[G, H]}\)], "Input",\

  CellLabel->"In[33]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({{3, 2, 5, 4, 6, 1}, Groupoid[{3, 2, 5, 4, 6, 1}, Mod[#1\ #2, 7]&]}\)], 
  "Output",
  CellLabel->"Out[33]=",
  CellTags->"Structure"]
}, Open  ]],

Cell["\<\
Given any object (or list of objects), we can determine if it \
belongs to some groupoid.\
\>", "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ElementQ[23, U[99]], \ ElementsQ[{23, \ 33}, U[99]]}\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Here we see the generating sets for the group ",
  Cell[BoxData[
      \(TraditionalForm\`D\_5\)]],
  " when it is formed in two different ways."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      GeneratingSet, {DihedralGroup[5, Form \[Rule] Permutations], 
        DihedralGroup[5]}]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({{{2, 3, 4, 5, 1}, {5, 4, 3, 2, 1}}, {Rot, Ref}}\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"Structure"]
}, Open  ]],

Cell["2.3 Testing the defining properties of a group", "Subsection",
  CellTags->"FourStandard"],

Cell["2.3.1 The four standard functions", "Subsubsection",
  CellTags->{"FourStandard", "i:13"}],

Cell[TextData[{
  "The standard definition of a group is that it is a set of elements with an \
operation such that the set of elements is closed under this operation \
(commonly stated as being a ",
  StyleBox["binary",
    FontSlant->"Italic"],
  " ",
  StyleBox["operation",
    FontSlant->"Italic"],
  "), there is an identity element, every element has an inverse, and the \
operation is associative. There are Boolean functions corresponding to each \
of these requirements."
}], "Text",
  CellTags->"FourStandard"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["closed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["under",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(its\ operation\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{\(G\_1\), 
                      StyleBox[",",
                        "MR"], " ", \(G\_2\), 
                      StyleBox[",",
                        "MR"], " ", "\[Ellipsis]", 
                      StyleBox[",",
                        "MR"], " ", \(G\_n\)}], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["values",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["depending",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["values",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["ClosedQ",
                      "MR"], "[", \(G\_i\), "]"}],
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["HasIdentityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["has",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["identity",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["HasInversesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["every",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["element",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], " ", "groupoid", " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["has",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[\(an\ inverse\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["AssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], " ", "groupoid", " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["associative",
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"FourStandard", "i:14"}],

Cell["Functions for testing the basic properties of a groupoid.", "Caption",
  CellTags->"FourStandard"],

Cell[TextData[{
  "As with ",
  StyleBox["ClosedQ", "MR"],
  ", the functions ",
  StyleBox["HasIdentityQ", "MR"],
  ", ",
  StyleBox["HasInversesQ", "MR"],
  ", and ",
  StyleBox["AssociativeQ", "MR"],
  " can also take a list of groupoids and return a list of Boolean values \
corresponding to the values of the function on each groupoid."
}], "Text",
  CellTags->"FourStandard"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["Mode",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Computational",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(\(specifies\ what\ type\ of\ information, \ 
                if\ any \(, \ \) should\) \(\ 
                be\ given\ in\ addition\ to\ the\ result\ of\ the\ computation
                  \)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Structure",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Group",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ if\ the\ underlying\ structure\ is\ considered\ as
                \ a\ groupoid\ or\ a\ ringoid\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.17, 0.25, 0.58},
  RowLines->{True, False}},
  CellTags->{"FourStandard", "i:15"}],

Cell["\<\
Options for the four property-defining functions when working with \
groupoids.\
\>", "Caption",
  CellTags->"FourStandard"],

Cell[TextData[{
  "The ",
  StyleBox["Textual", "MR"],
  " and ",
  StyleBox["Visual", "MR"],
  " modes are available for each of these four functions. Generally, we do \
not need to add the ",
  StyleBox["Structure", "MR"],
  " option; while working with groups the ",
  StyleBox["Group", "MR"],
  " value is automatically used, and when working with rings the ",
  StyleBox["Ring", "MR"],
  " value is used. (This option affects only the ",
  StyleBox["Textual", "MR"],
  " mode.)"
}], "Text",
  CellTags->"FourStandard"],

Cell["Consider the following groupoids.", "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[G]\), 
    \({G\_1\  = \ FormGroupoid[{1, 2, 3, 4}, \ Plus, \ "\<+\>"], \n
      G\_2\  = \ 
        FormGroupoidByTable[{\[Alpha], \ \[Beta], \ \[Gamma]}, 
          \ {{\[Gamma], \ \[Alpha], \ \[Beta]}, 
            \ {\[Alpha], \ \[Beta], \ \[Gamma]}, {\ \[Alpha], \ \[Gamma], \ 
              \[Beta]}}, \ CayleyForm\  \[Rule] \ StandardForm]}\)}], "Input",\

  CellLabel->"In[36]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \({Groupoid[{1, 2, 3, 4}, "-Operation-"], 
      Groupoid[{\[Alpha], \[Beta], \[Gamma]}, "-Operation-"]}\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "The groupoid ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " is not closed under the operation ",
  StyleBox["Plus", "MR"],
  ". When using the ",
  StyleBox["Textual", "MR"],
  " mode, an example illustrating nonclosure is given when the result is ",
  StyleBox["False", "MR"],
  "."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[G\_1, \ Mode\  \[Rule] \ Textual]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("We say a set S is closed under an operation op if whenever we have x \
and y in S, we also have op[x,y] (or x~op~y) in S."\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("In this case, the Groupoid TheGroup is NOT closed. For example, since \
1 + 4 = 5 (which is not in the set), it is clear that it is not closed."\)], 
  "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "When using the ",
  StyleBox["Visual", "MR"],
  " mode with ",
  StyleBox["ClosedQ", "MR"],
  ", the products in the table are colored yellow if they belong to the \
groupoid, and red otherwise."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[G\_1, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("All the elements marked with yellow are original elements in the set. \
Those in red are from outside."\)], "Print",
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
1 0 0 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(2)] .30952 .69286 0 0 Mshowa
[(3)] .5 .69286 0 0 Mshowa
[(4)] .69048 .69286 0 0 Mshowa
[(5)] .88095 .69286 0 0 Mshowa
[(3)] .30952 .50238 0 0 Mshowa
[(4)] .5 .50238 0 0 Mshowa
[(5)] .69048 .50238 0 0 Mshowa
[(6)] .88095 .50238 0 0 Mshowa
[(4)] .30952 .3119 0 0 Mshowa
[(5)] .5 .3119 0 0 Mshowa
[(6)] .69048 .3119 0 0 Mshowa
[(7)] .88095 .3119 0 0 Mshowa
[(5)] .30952 .12143 0 0 Mshowa
[(6)] .5 .12143 0 0 Mshowa
[(7)] .69048 .12143 0 0 Mshowa
[(8)] .88095 .12143 0 0 Mshowa
[(1)] .11905 .69286 0 0 Mshowa
[(2)] .11905 .50238 0 0 Mshowa
[(3)] .11905 .3119 0 0 Mshowa
[(4)] .11905 .12143 0 0 Mshowa
[(1)] .30952 .88333 0 0 Mshowa
[(2)] .5 .88333 0 0 Mshowa
[(3)] .69048 .88333 0 0 Mshowa
[(4)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[39]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P0000H0nOl600001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Al00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0Eg`?o5Ml2oaHO0olH7`03oalO01DO0_lH7`03oalO01DO00?o7al05Ql00olO7`0E7`;o
61l00ol0000400001P000ooOg`0Fg`03omoO01CO0_lI7`03oalO01DO00?o7al051l01?lO7olG7`03
oalO01DO00?o7al05Ql00olO7`0D7`04oalOoaLO00?o0000100000H000?ogml05=l4oaGO0_lI7`03
oalO01DO00?o7al051l01?lO7olG7`03oalO01HO00?o7al05Al00olO7`0D7`04oalOoaLO00?o0000
100000H000?ogml05=l00ooOo`0Fg`;o5Ql3oaPO00?o7al051l3oaPO00?o7al05Ql00olO7`0E7`03
oalO01DO0_lH7`03o`0000@000060003omoO01CO00?ogol05]l2oaHO00?o7al061l00olO7`0D7`03
oalO01PO00?o7al05al00olO7`0D7`03oalO01@O00Co7aoo5al00ol0000400001P000ooOg`0Eg`;o
5]l2oaHO1?lG7`03oalO01DO0olG7`03oalO01@O1?lF7`03oalO01DO0_lH7`03o`0000@000060003
omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03
oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03
oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03
oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03
oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_la7`03oalO02lO00?o7al0;Ql00olO7`0_7`03o`0000@000060?Wo1P0000H000?ogml0
;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0
;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0
;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0
;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0
;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?o7al0;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?o7al0
;al00olO7`0^7`03oalO02lO00?o0000100000H000?ogml05=l3oaKO0_lGg`?o5ml00olO7`0D7`?o
61l00olO7`0E7`;o5al00olO7`0E7`03oalO01LO00?o0000100000H000?ogml05ml00ooOg`0Cg`;o
6=l00ooOg`0Fg`03oalO01LO00?o7al05Al00olO7`0D7`04oalOoaHO00?o7al05Al00olO7`0G7`03
o`0000@000060003omoO01OO00?ogml04ml2oaKO1?lGg`03oalO01LO00?o7al05Al00olO7`0D7`04
oalOoaHO00?o7al05Ql00olO7`0F7`03o`0000@000060003omoO01GO0_lFg`;o5]l00ooOo`0Hg`03
oalO01@O0olH7`03oalO01@O0olG7`03oalO01HO00?o7al05Ql00ol0000400001P000ooOg`0Gg`03
omoO01?O0_lFg`03omoo01SO00?o7al051l00olO7`0H7`03oalO01@O00?o7al05al00olO7`0G7`03
oalO01DO00?o0000100000H000?ogml05=l3oaKO0_lGg`;o6=l00olO7`0D7`Co5al00olO7`0E7`?o
5Ql00olO7`0D7`Co5al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00olO7`0_7`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00olO7`0_7`03oalO02hO00?o7al0
;al00ol0000400001P3io`H000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0
;Ql00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?o7al0;Ql00olO7`0_7`03o`0000@000060003
omoO01CO1?lEg`;o5]l3oaSO00?ogml05Ml3oaOO00?o7al051l3oaLO00?o7al05Al2oaPO00?o0000
100000H000?ogml05Ml00ooOg`0Eg`;o6Ml00ooOg`0Eg`03omoO01KO00?ogml05]l00olO7`0G7`03
oalO01@O00?o7al051l01?lO7olG7`03o`0000@000060003omoO01KO00?ogml05=l2oaWO00?ogml0
5Ml00ooOg`0Dg`Co5ml00olO7`0G7`03oalO01@O00?o7al051l01?lO7olG7`03o`0000@000060003
omoO01OO00?ogml04ml2oaOO0_lHg`03omoO01CO00?ogol06=l00olO7`0D7`?o5al00olO7`0D7`?o
61l00ol0000400001P000ooOg`0Dg`04omoOoaGO0_lIg`03omoO01GO00?ogml05=l00ooOo`0Hg`03
oalO01@O00?o7al05al00olO7`0D7`03oalO01PO00?o0000100000H000?ogml05Ml2oaKO0_lFg`?o
6=l00ooOg`0Eg`;o6=l00olO7`0D7`Co5Ql00olO7`0E7`?o5al00ol0000400001P000ooOg`0]g`;o
<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o
<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03
oalO02hO00?o7al0;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0
;al00ol0000400001P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol000040000
1P000ooOg`0]g`;o<Ml00ooOg`0_g`03oalO02hO00?o7al0;al00ol0000400001P3io`H000060003
omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0
;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0
;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0
;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0
;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03
o`0000@000060003omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003
omoO02gO0_lag`03omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO02gO0_lag`03
omoO02oO00?ogml0;]l00olO7`0_7`03o`0000@000060003omoO01CO0olFg`;o5]l4oaOO00?ogml0
5=l3oaSO00?ogml05Ml3oaKO00?o7al051l3oaPO00?o0000100000H000?ogml05Ml00ooOg`0Eg`;o
5ml00ooOg`0Gg`03omoO01OO00?ogml05Ml00ooOg`0Fg`03omoO01GO00?o7al05al00olO7`0E7`03
o`0000@000060003omoO01GO00?ogml05Ml2oaSO00?ogml05]l00ooOg`0Gg`03omoO01GO00?ogml0
5=l4oaKO00?o7al05al00olO7`0E7`03o`0000@000060003omoO01GO00?ogml05Ml2oaWO00?ogml0
5Ml00ooOg`0Eg`;o6=l00ooOg`0Dg`03omoo01OO00?o7al051l3oaPO00?o0000100000H000?ogml0
5Ml00ooOg`0Eg`;o5]l01?oOgolGg`03omoO01OO00?ogml05Ml00ooOg`0Dg`03omoo01OO00?o7al0
51l00olO7`0H7`03o`0000@000060003omoO01CO0_lGg`;o5ml2oaSO00?ogml05=l3oaSO00?ogml0
5Ml2oaOO00?o7al051l4oaLO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0
;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0
;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0
;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03
oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000
100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0
;Ml2oc7O00?ogml0;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0
;ml00ooOg`0^g`03oalO02lO00?o0000100000H000?ogml0;Ml2oc7O00?ogml0;ml00ooOg`0^g`03
oalO02lO00?o0000100000D0n_l600001@3jo`H000060003o`0002d00_lag`03omoO02oO00?ogml0
;]l00ooOg`0_g`03o`0000@000060003o`0002`00olag`03omoO02oO00?ogml0;]l00ooOg`0_g`03
o`0000@000060003o`0002/000Co0?oo<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol000040000
1P000ol0000Z0003o`0000;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0
000Y0004o`0000;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0000X0003
o`0000800_lag`03omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0002L000?o0000
0`02oc7O00?ogml0;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o00009P000ol0000400;o
<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0000U0003o`0000D00_lag`03
omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0002@000?o00001P02oc7O00?ogml0
;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o00008`000ol0000700;o<Ml00ooOg`0_g`03
omoO02kO00?ogml0;ml00ol0000400001P000ol0000R0003o`0000P00_lag`03omoO02oO00?ogml0
;]l00ooOg`0_g`03o`0000@000060003o`0000/00_l00`3oo`0A0003o`0000T00_lag`03omoO02oO
00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0000`000?o0?l04@000ol0000:00;o<Ml00ooO
g`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0000=0003o`0000l000?o00002`02oc7O
00?ogml0;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o000030000ol0o`0?0003o`0000`0
0_lag`03omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0000/00_l00`3oo`0=0003
o`0000d00_lag`03omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0001`000?o0000
3P02oc7O00?ogml0;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o00006`000ol0000?00;o
<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0000J0003o`0001000_lag`03
omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0001T000?o00004@02oc7O00?ogml0
;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o000060000ol0000B00;o5]l3oaSO00?ogml0
5=l4oaOO00?ogml05=l3oaOO00?ogml05Ml3oaOO00?o0000100000H000?o00005`000ol0000C00;o
5ml00ooOg`0Gg`03omoO01GO00?ogml05ml00ooOg`0Gg`03omoO01CO00?ogml05]l00ooOg`0Fg`03
o`0000@000060003o`0001H000?o00005002oaOO00?ogml05ml00ooOg`0Fg`03omoO01KO00?ogml0
5ml00ooOg`0Dg`03omoO01CO1?lGg`03o`0000@000060003o`0001D000?o00005@02oaOO00?ogml0
5ml00ooOg`0Gg`03omoO01GO00?ogml05Ml2oaOO00?ogml05=l00ooOo`0Hg`03o`0000@000060003
o`0001@000?o00005P02oaOO00?ogml05ml00ooOg`0Dg`04omoOoaOO00?ogml05ml00ooOg`0Dg`03
omoO01CO00?ogol06=l00ol0000400001P000ol0000C0003o`0001L00_lFg`;o6Ml00ooOg`0Eg`;o
6=l00ooOg`0Dg`?o5ml00ooOg`0Eg`;o6=l00ol0000400001P000ol0000B0003o`0001P00_lag`03
omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`00014000?o00006@02oc7O00?ogml0
;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o000040000ol0000<00?o2`02oc7O00?ogml0
;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o00003`000ol0000>0003o`0000X00_lag`03
omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0000h000?o000040000ol0000900;o
<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0000=0003o`00014000?o0000
2@02oc7O00?ogml0;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o000030000ol0000A0003
o`3o00X00_lag`03omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0000/000?o0000
4P000ol0o`0:00;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0000:0003
o`0001800_l00`3oo`0900;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol0
00090003o`0002400_lag`03omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0000P0
00?o00008P02oc7O00?ogml0;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o00001`000ol0
000S00;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol000060003o`0002@0
0_lag`03omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`0000D000?o00009@02oc7O
00?ogml0;ml00ooOg`0^g`03omoO02oO00?o0000100000H000?o000010000ol0000V00;o<Ml00ooO
g`0_g`03omoO02kO00?ogml0;ml00ol0000400001P000ol000030003o`0002L00_lag`03omoO02oO
00?ogml0;]l00ooOg`0_g`03o`0000@000060003o`00008000?o0000:002oc7O00?ogml0;ml00ooO
g`0^g`03omoO02oO00?o0000100000H000Go0000o`0[00;o<Ml00ooOg`0_g`03omoO02kO00?ogml0
;ml00ol0000400001P001?l00?l/00;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol000040000
1P000ol0o`0]00;o<Ml00ooOg`0_g`03omoO02kO00?ogml0;ml00ol0000400001P02obh00_lag`03
omoO02oO00?ogml0;]l00ooOg`0_g`03o`0000@000060?Wo1P0003H00_o=0000o`060000o`060000
o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000
o`060000o`060000o`060000o`060000o`060000o`060000o`060000<004ol800ol<0000<@000ol0
00330003o`0000/0000800?o0P02o`030?oo00801?l00`3oo`02o`801?l300?o0P05o`030?oo00;o
Z@02o`030?oo00T000?o0?l02@000ol0000:00002@001Ol0003o008000Co003o10001Ol0003o00<0
00?o00000P001ol0003o0?l00P001?l00?l30003o`000:L000?o0?l02`000ol000080003o`0000X0
00090005o`000?l00P000ol00006o`040?ooo`<000?o00000P001ol0003o0?l00P001?l00?l30003
o`000:P000?o00002005o`L000?o0?l02`0000L000Oo0?l0o`3o008000Co003o0`02o`L00_l30007
o`000?l0o`020004o`00o`<000?o0000Y`000ol0o`0;0003o`0000L000?o0?l02`0000L000Ko0?l0
o`04o`<00ol00`3o00020003o`0000;o00<0ool00P03o`040?oo00;o00<0ool00onY00;o00<0ool0
4`02o`030?oo00X0000700Go00<0o`002P04onP0000<00;om`000?l01P000?l01P000001\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"FourStandard"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "When the ",
  StyleBox["Visual", "MR"],
  " mode is used with multiple groupoids, the graphics are arranged with ",
  StyleBox["GraphicsArray", "MR"],
  "."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[{G\_1, \ G\_2, \ U[15], \ Zx[8]}, \ Mode\  \[Rule] \ Visual]
      \)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("All the elements marked with yellow are original elements in the set. \
Those in red are from outside."\)], "Print",
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0261905 0.47619 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0261905 0.477324 0.525057 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(1)] .18254 .81878 0 0 Mshowa
[(2)] .28836 .81878 0 0 Mshowa
[(4)] .39418 .81878 0 0 Mshowa
[(7)] .5 .81878 0 0 Mshowa
[(8)] .60582 .81878 0 0 Mshowa
[(11)] .71164 .81878 0 0 Mshowa
[(13)] .81746 .81878 0 0 Mshowa
[(14)] .92328 .81878 0 0 Mshowa
[(2)] .18254 .71296 0 0 Mshowa
[(4)] .28836 .71296 0 0 Mshowa
[(8)] .39418 .71296 0 0 Mshowa
[(14)] .5 .71296 0 0 Mshowa
[(1)] .60582 .71296 0 0 Mshowa
[(7)] .71164 .71296 0 0 Mshowa
[(11)] .81746 .71296 0 0 Mshowa
[(13)] .92328 .71296 0 0 Mshowa
[(4)] .18254 .60714 0 0 Mshowa
[(8)] .28836 .60714 0 0 Mshowa
[(1)] .39418 .60714 0 0 Mshowa
[(13)] .5 .60714 0 0 Mshowa
[(2)] .60582 .60714 0 0 Mshowa
[(14)] .71164 .60714 0 0 Mshowa
[(7)] .81746 .60714 0 0 Mshowa
[(11)] .92328 .60714 0 0 Mshowa
[(7)] .18254 .50132 0 0 Mshowa
[(14)] .28836 .50132 0 0 Mshowa
[(13)] .39418 .50132 0 0 Mshowa
[(4)] .5 .50132 0 0 Mshowa
[(11)] .60582 .50132 0 0 Mshowa
[(2)] .71164 .50132 0 0 Mshowa
[(1)] .81746 .50132 0 0 Mshowa
[(8)] .92328 .50132 0 0 Mshowa
[(8)] .18254 .3955 0 0 Mshowa
[(1)] .28836 .3955 0 0 Mshowa
[(2)] .39418 .3955 0 0 Mshowa
[(11)] .5 .3955 0 0 Mshowa
[(4)] .60582 .3955 0 0 Mshowa
[(13)] .71164 .3955 0 0 Mshowa
[(14)] .81746 .3955 0 0 Mshowa
[(7)] .92328 .3955 0 0 Mshowa
[(11)] .18254 .28968 0 0 Mshowa
[(7)] .28836 .28968 0 0 Mshowa
[(14)] .39418 .28968 0 0 Mshowa
[(2)] .5 .28968 0 0 Mshowa
[(13)] .60582 .28968 0 0 Mshowa
[(1)] .71164 .28968 0 0 Mshowa
[(8)] .81746 .28968 0 0 Mshowa
[(4)] .92328 .28968 0 0 Mshowa
[(13)] .18254 .18386 0 0 Mshowa
[(11)] .28836 .18386 0 0 Mshowa
[(7)] .39418 .18386 0 0 Mshowa
[(1)] .5 .18386 0 0 Mshowa
[(14)] .60582 .18386 0 0 Mshowa
[(8)] .71164 .18386 0 0 Mshowa
[(4)] .81746 .18386 0 0 Mshowa
[(2)] .92328 .18386 0 0 Mshowa
[(14)] .18254 .07804 0 0 Mshowa
[(13)] .28836 .07804 0 0 Mshowa
[(11)] .39418 .07804 0 0 Mshowa
[(8)] .5 .07804 0 0 Mshowa
[(7)] .60582 .07804 0 0 Mshowa
[(4)] .71164 .07804 0 0 Mshowa
[(2)] .81746 .07804 0 0 Mshowa
[(1)] .92328 .07804 0 0 Mshowa
[(1)] .07672 .81878 0 0 Mshowa
[(2)] .07672 .71296 0 0 Mshowa
[(4)] .07672 .60714 0 0 Mshowa
[(7)] .07672 .50132 0 0 Mshowa
[(8)] .07672 .3955 0 0 Mshowa
[(11)] .07672 .28968 0 0 Mshowa
[(13)] .07672 .18386 0 0 Mshowa
[(14)] .07672 .07804 0 0 Mshowa
[(1)] .18254 .9246 0 0 Mshowa
[(2)] .28836 .9246 0 0 Mshowa
[(4)] .39418 .9246 0 0 Mshowa
[(7)] .5 .9246 0 0 Mshowa
[(8)] .60582 .9246 0 0 Mshowa
[(11)] .71164 .9246 0 0 Mshowa
[(13)] .81746 .9246 0 0 Mshowa
[(14)] .92328 .9246 0 0 Mshowa
[(U[15])] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0261905 0.97619 0.525057 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(0)] .18254 .81878 0 0 Mshowa
[(0)] .28836 .81878 0 0 Mshowa
[(0)] .39418 .81878 0 0 Mshowa
[(0)] .5 .81878 0 0 Mshowa
[(0)] .60582 .81878 0 0 Mshowa
[(0)] .71164 .81878 0 0 Mshowa
[(0)] .81746 .81878 0 0 Mshowa
[(0)] .92328 .81878 0 0 Mshowa
[(0)] .18254 .71296 0 0 Mshowa
[(1)] .28836 .71296 0 0 Mshowa
[(2)] .39418 .71296 0 0 Mshowa
[(3)] .5 .71296 0 0 Mshowa
[(4)] .60582 .71296 0 0 Mshowa
[(5)] .71164 .71296 0 0 Mshowa
[(6)] .81746 .71296 0 0 Mshowa
[(7)] .92328 .71296 0 0 Mshowa
[(0)] .18254 .60714 0 0 Mshowa
[(2)] .28836 .60714 0 0 Mshowa
[(4)] .39418 .60714 0 0 Mshowa
[(6)] .5 .60714 0 0 Mshowa
[(0)] .60582 .60714 0 0 Mshowa
[(2)] .71164 .60714 0 0 Mshowa
[(4)] .81746 .60714 0 0 Mshowa
[(6)] .92328 .60714 0 0 Mshowa
[(0)] .18254 .50132 0 0 Mshowa
[(3)] .28836 .50132 0 0 Mshowa
[(6)] .39418 .50132 0 0 Mshowa
[(1)] .5 .50132 0 0 Mshowa
[(4)] .60582 .50132 0 0 Mshowa
[(7)] .71164 .50132 0 0 Mshowa
[(2)] .81746 .50132 0 0 Mshowa
[(5)] .92328 .50132 0 0 Mshowa
[(0)] .18254 .3955 0 0 Mshowa
[(4)] .28836 .3955 0 0 Mshowa
[(0)] .39418 .3955 0 0 Mshowa
[(4)] .5 .3955 0 0 Mshowa
[(0)] .60582 .3955 0 0 Mshowa
[(4)] .71164 .3955 0 0 Mshowa
[(0)] .81746 .3955 0 0 Mshowa
[(4)] .92328 .3955 0 0 Mshowa
[(0)] .18254 .28968 0 0 Mshowa
[(5)] .28836 .28968 0 0 Mshowa
[(2)] .39418 .28968 0 0 Mshowa
[(7)] .5 .28968 0 0 Mshowa
[(4)] .60582 .28968 0 0 Mshowa
[(1)] .71164 .28968 0 0 Mshowa
[(6)] .81746 .28968 0 0 Mshowa
[(3)] .92328 .28968 0 0 Mshowa
[(0)] .18254 .18386 0 0 Mshowa
[(6)] .28836 .18386 0 0 Mshowa
[(4)] .39418 .18386 0 0 Mshowa
[(2)] .5 .18386 0 0 Mshowa
[(0)] .60582 .18386 0 0 Mshowa
[(6)] .71164 .18386 0 0 Mshowa
[(4)] .81746 .18386 0 0 Mshowa
[(2)] .92328 .18386 0 0 Mshowa
[(0)] .18254 .07804 0 0 Mshowa
[(7)] .28836 .07804 0 0 Mshowa
[(6)] .39418 .07804 0 0 Mshowa
[(5)] .5 .07804 0 0 Mshowa
[(4)] .60582 .07804 0 0 Mshowa
[(3)] .71164 .07804 0 0 Mshowa
[(2)] .81746 .07804 0 0 Mshowa
[(1)] .92328 .07804 0 0 Mshowa
[(0)] .07672 .81878 0 0 Mshowa
[(1)] .07672 .71296 0 0 Mshowa
[(2)] .07672 .60714 0 0 Mshowa
[(3)] .07672 .50132 0 0 Mshowa
[(4)] .07672 .3955 0 0 Mshowa
[(5)] .07672 .28968 0 0 Mshowa
[(6)] .07672 .18386 0 0 Mshowa
[(7)] .07672 .07804 0 0 Mshowa
[(0)] .18254 .9246 0 0 Mshowa
[(1)] .28836 .9246 0 0 Mshowa
[(2)] .39418 .9246 0 0 Mshowa
[(3)] .5 .9246 0 0 Mshowa
[(4)] .60582 .9246 0 0 Mshowa
[(5)] .71164 .9246 0 0 Mshowa
[(6)] .81746 .9246 0 0 Mshowa
[(7)] .92328 .9246 0 0 Mshowa
[(Zx[8])] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.574943 0.477324 1.07381 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
1 0 0 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(2)] .30952 .69286 0 0 Mshowa
[(3)] .5 .69286 0 0 Mshowa
[(4)] .69048 .69286 0 0 Mshowa
[(5)] .88095 .69286 0 0 Mshowa
[(3)] .30952 .50238 0 0 Mshowa
[(4)] .5 .50238 0 0 Mshowa
[(5)] .69048 .50238 0 0 Mshowa
[(6)] .88095 .50238 0 0 Mshowa
[(4)] .30952 .3119 0 0 Mshowa
[(5)] .5 .3119 0 0 Mshowa
[(6)] .69048 .3119 0 0 Mshowa
[(7)] .88095 .3119 0 0 Mshowa
[(5)] .30952 .12143 0 0 Mshowa
[(6)] .5 .12143 0 0 Mshowa
[(7)] .69048 .12143 0 0 Mshowa
[(8)] .88095 .12143 0 0 Mshowa
[(1)] .11905 .69286 0 0 Mshowa
[(2)] .11905 .50238 0 0 Mshowa
[(3)] .11905 .3119 0 0 Mshowa
[(4)] .11905 .12143 0 0 Mshowa
[(1)] .30952 .88333 0 0 Mshowa
[(2)] .5 .88333 0 0 Mshowa
[(3)] .69048 .88333 0 0 Mshowa
[(4)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.574943 0.97619 1.07381 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
gsave
.38095 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.61905 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.38095 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.61905 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.38095 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.61905 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.38095 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.61905 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
[(TheGroup)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[40]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P0000T0LOlA077o
2@0000T000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03
omoO00[O00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03
omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T000?ogml02=l2o`cO00?ogml0
2Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003
omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03
omoO00WO00?o00001`0000T000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml0
2]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO00?ogml0
2]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T01?l4g`So
1=l3o`;O1?l3g`?o0]l4o`?O0ol3g`03omoO00;O0_l5g`03omoO00;O00?ogml01Ml00ooOg`02g`?o
1=l01?oOgml4o`GO00CogmoO0ol5g`03o`0000l000?ogml00]l00ooOg`03g`;o1=l2o`KO00?ogml0
0]l00ooOg`04g`03omoO00;O0_l6g`04omoOg`?o1Ml00ooOg`02g`?o1Ml01?oOgml3o`GO00CogmoO
1?l5g`04omoOg`?o1Ml00ol0000700002@000ooOo`06g`06omooomoo1]l01ooOgmoogol01ml01OoO
omoo00GO00?ogml00]l01OoOgmoo00;O00?ogml00]l00ooOg`02g`03omoO00GO00?ogml00ml00ooO
g`03g`03omoO00;O00?ogml01Ml00ooOg`02g`03omoO00CO00?o00003`000ooOg`02g`03omoO00?O
0_l3g`04omoOo`GO00?ogml00]l00ooOg`04g`05omoOgol00]l00ooOg`03g`03omoO00CO00?ogml0
0]l00ooOg`03g`03omoO00CO00?ogml01=l00ooOg`02g`03omoO00;O00?ogml01Ml00ooOg`02g`03
omoO00CO00?o00001`0000T000?ogol01=l6o`03gooO00?O1?l2g`03omoo00OO00GogooOo`05g`03
omoO00;O00GogmoOo`02g`03omoO00;O00?ogml00ml00ooOg`04g`04omoOg`Co1=l00ooOg`03g`03
omoO00CO00?ogml00]l00ooOg`04g`03o`0000l000?ogml00ml00ooOg`02g`;o0ml01?oOgol5g`03
omoO00?O00?ogml00ml01OoOgmoo00;O00?ogml00ml00ooOg`04g`03omoO00;O00CogmoO1?l5g`03
omoO00CO00?ogml00]l00ooOg`03g`03omoO00CO00?ogml00]l00ooOg`04g`03o`0000L000090003
omoo00CO00CogooO0_l00moog`03g`03omoo00?O00?ogol01Ml2o`;O00?ogol01Ml00ooOg`02g`03
omoO00;O0_l5g`03omoO00?O00?ogml01=l01ooOgmoogol01Ml00ooOg`04g`03omoO00?O00?ogml0
0]l00ooOg`04g`03o`0000l000?ogml00ml00ooOg`02g`;o0ml01?oOgol5g`03omoO00?O00?ogml0
0ml01?oOgml3o`KO00CogmoO0ol5g`07omoOgooOo`06g`03omoO00;O0_l5g`03omoO00CO00?ogml0
0ml00ooOg`02g`03omoO00CO00?o00001`0000T000?ogol01=l01?oOoml2o`03gooO00?O00?ogol0
0ml00ooOo`07g`05omoogol01Ml00ooOg`02g`05omoOgol00]l00ooOg`02g`03omoO00CO00?ogml0
0ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`03omoO00CO00?o00003`000ooO
g`04g`04omoOg`;o0ml01?oOgol5g`03omoO00CO00?ogml00]l01OoOgmoo00SO00GogmoOo`07g`07
omoOgooOo`06g`03omoO00CO00?ogml00]l01OoOgmoo00;O00?ogml00ml00ooOg`02g`03omoO00CO
00?o00001`0000T00ol5g`;o00?Oool00_l5g`;o0ml3o`CO0ol2g`?o1=l2o`CO00?ogml00]l2o`GO
00CogmoO1?l5g`03omoO00;O0_l5g`03omoO00;O0_l6g`04omoOg`;o1]l00ol0000?0004omoOg`Co
0ml2o`CO0_l6g`04omoOg`Co1=l00ooOg`02g`?o1Ml01?oOgml4o`CO00?ogml00]l2o`KO00CogmoO
0ol5g`03omoO00;O0_l6g`04omoOg`;o1]l00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03
omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml0
2=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml0
2Ml00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03
omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03
omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooOg`08g`;o
3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03
o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03
omoO00[O00?ogml02Ml00ol0000700002@1aoa40LOl900002@000ooOg`08g`;o3=l00ooOg`09g`03
omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml0
2=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml0
2Ml00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03
omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03
omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooOg`08g`;o
3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03
o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03
omoO00[O00?ogml02Ml00ol0000700002@04o`?O0ol00mooo`03o`?O0ol3g`Co0ml3o`;O00?ogml0
0]l00ooOg`05g`04omoOg`?o1Ml4o`CO0ol2g`03omoO00;O0_l5g`03omoO00;O0ol5g`04omoOg`Co
1=l00ol0000?0003omoO00;O0_l4g`;o1=l2o`KO00?ogml00]l2o`GO00?ogml00]l3o`GO00CogmoO
1?l4g`03omoO00;O0_l6g`03omoO00;O0_l5g`03omoO00;O0ol5g`04omoOg`Co1=l00ol000070000
2@000ooOo`07g`?o00?Ooml01]l01_oOgooOo`GO00GogmoOo`04g`03omoO00GO00?ogml00]l00ooO
g`04g`03omoo00KO00GogmoOo`03g`04omoOo`CO00?ogml00ml00ooOg`04g`03omoO00;O00?ogml0
1=l00ol0000?0005omoOgol00]l01?oOgml2o`?O00Cogmoo1Ml01OoOgmoo00;O00?ogml00]l00ooO
g`03g`03omoO00CO00?ogml00]l00ooOg`04g`05omoOgol00]l00ooOg`03g`05omoOgol00]l00ooO
g`02g`03omoO00?O00?ogml01=l00ooOg`02g`03omoO00CO00?o00001`0000T000?ogol01ml3o`03
gooO00KO00Kogmoogol5g`05omoOgol01Ml00ooOg`04g`03omoO00;O00?ogml01=l00ooOo`04g`Co
0]l01OoOgmoo00;O00?ogml00]l01?oOgml4o`GO00?ogml00ml00ooOg`03g`03o`0000l000GogmoO
o`02g`04omoOg`;o0ml01?oOgol5g`05omoOgol00]l00ooOg`02g`04omoOg`Co1Ml00ooOg`03g`03
omoO00?O00GogmoOo`02g`03omoO00?O00GogmoOo`02g`03omoO00;O00CogmoO1?l5g`03omoO00?O
00?ogml00ml00ol0000700002@000ooOo`05g`;o00GOoooOo`05g`;o0ml00ooOo`05g`05omoOgol0
1Ml00ooOg`04g`03omoO00;O00?ogml01=l00ooOo`04g`03omoo00?O00?ogml00]l2o`GO00OogmoO
omoo00KO00?ogml01=l00ooOg`02g`03o`0000l000CogmoO0ol4g`;o0ml01?oOgol5g`04omoOg`?o
1Ml01ooOgmoogol01]l00ooOg`04g`03omoO00;O00GogmoOo`02g`03omoO00?O00CogmoO0ol5g`07
omoOgooOo`06g`03omoO00CO00?ogml00]l00ol0000700002@000ooOo`07g`?o00?Ooml01]l01_oO
gooOo`GO00GogmoOo`06g`03omoO00?O00?ogml00]l00ooOg`04g`03omoo00CO00?ogol00ml01OoO
gmoo00;O00?ogml00]l01ooOgmoogol01]l01OoOgmoo00;O00?ogml00]l00ol0000?0005omoOgol0
1]l2o`?O00Cogmoo1Ml01OoOgmoo00OO00OogmoOomoo00KO00GogmoOo`02g`03omoO00;O00GogmoO
o`02g`03omoO00?O00GogmoOo`07g`07omoOgooOo`06g`05omoOgol00]l00ooOg`02g`03o`0000L0
000900?o1=l3o`03gooo00;o1=l3o`?O0ol4g`;o0ml01?oOgml4o`GO00CogmoO0_l6g`?o1Ml2o`?O
00?ogml00]l2o`GO00?ogml00]l2o`KO00?ogml00]l2o`GO00?o00003`000ooOg`02g`?o0ml2o`CO
0_l6g`03omoO00;O0ol4g`03omoO00;O0_l6g`03omoO00;O0_l5g`03omoO00;O0_l6g`03omoO00;O
0ol4g`03omoO00;O0_l6g`03omoO00;O0_l5g`03o`0000L000090003omoO00SO0_l<g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`000ooO
g`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooO
g`09g`03o`0000L000090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L00009077o4@1ao`T0
00090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L000090003omoO00SO0_l<g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`000ooO
g`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooO
g`09g`03o`0000L000090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L0000900Co0ml3o`03
gooo00?o0ml3o`?O00?ogml00]l00ooOg`04g`Co1=l3o`;O00CogmoO1?l4g`Co0ml3o`?O00CogmoO
0ol5g`03omoO00;O0_l6g`03omoO00;O0ol4g`03o`0000l000CogmoO0ol4g`;o1=l2o`KO00CogmoO
0ol5g`04omoOg`Co1Ml00ooOg`02g`03omoO00CO00?ogml00]l3o`GO00CogmoO0ol5g`03omoO00;O
0_l6g`04omoOg`?o1Ml00ol0000700002@000ooOo`05g`03omoO00;o00?Ooml01=l00ooOg`02g`03
omoO00;O00?ogml01=l00ooOo`06g`05omoOgol01=l00ooOg`04g`03omoo00OO00Cogmoo1=l00ooO
g`04g`05omoOgol00]l00ooOg`03g`03omoO00?O00?ogml00ml00ol0000?0003omoO00CO00CogmoO
0_l3g`04omoOo`GO00?ogml01=l00ooOg`02g`03omoO00;O00?ogml01Ml00ooOg`02g`03omoO00CO
00?ogml00ml00ooOg`04g`03omoO00;O00?ogml01=l01OoOgmoo00;O00?ogml00ml00ooOg`04g`03
omoO00;O00?o00001`0000T000?ogol01Ml00ooOg`02o`03gooO00CO00?ogml00]l00ooOg`03g`03
omoO00?O00?ogol01=l4o`;O00?ogml00ml00ooOg`03g`03omoo00OO00Cogmoo1=l00ooOg`04g`05
omoOgol00]l00ooOg`03g`04omoOg`Co1=l00ol0000?0003omoO00CO00CogmoO0_l3g`04omoOo`GO
00?ogml01=l00ooOg`02g`03omoO00?O00?ogml01=l00ooOg`03g`03omoO00?O00CogmoO1?l5g`03
omoO00;O00?ogml01=l01OoOgmoo00;O00?ogml00ml00ooOg`04g`03omoO00;O00?o00001`0000T0
00?ogol01Ml00ooOg`02o`03gooO00CO00?ogml00]l00ooOg`03g`03omoO00?O00?ogol01=l00ooO
o`03g`03omoO00CO00?ogml00]l00ooOo`05g`;o0ml00ooOg`02g`03omoO00CO00?ogml00]l2o`KO
00OogmoOomoo00GO00?o00003`001?oOgml3o`CO0_l3g`04omoOo`GO00CogmoO0ol5g`03omoO00CO
00?ogml00ml00ooOg`03g`03omoO00?O00OogmoOomoo00KO00?ogml00]l00ooOg`04g`04omoOg`?o
1]l00ooOg`02g`;o1Ml00ol0000700002@000ooOo`05g`03omoO00;o00?Ooml01=l00ooOg`02g`03
omoO00CO00?ogml00]l00ooOo`04g`03omoo00?O00GogmoOo`02g`03omoO00;O00?ogol01ml01?oO
gol4g`03omoO00CO00GogmoOo`02g`03omoO00?O00OogmoOomoo00GO00?o00003`001OoOgmoo00KO
0_l3g`04omoOo`GO00GogmoOo`07g`05omoOgol00]l00ooOg`03g`03omoO00CO00?ogml00]l01ooO
gmoogol01]l00ooOg`02g`03omoO00CO00GogmoOo`08g`03omoO00CO00?ogml00]l00ol000070000
2@03o`CO0_l2g`Co1=l2o`CO00CogmoO1?l4g`?o1Ml2o`?O00?ogml00]l2o`GO0ol4g`?o0ml01?oO
gml2o`KO00?ogml00]l2o`KO00?ogml00]l2o`GO00?o00003`001?oOgml4o`?O0_l4g`;o1]l01?oO
gml4o`CO00?ogml00]l2o`KO00CogmoO1?l4g`03omoO00;O0_l6g`04omoOg`;o1]l00ooOg`02g`?o
1Ml01?oOgml3o`GO00?o00001`0000T000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO
0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?o00001`0000T0LOlA077o2@0000T000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO
0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?o00001`0000T000?ogml00]l2o`CO0_l4g`;o1]l01?oOgml3o`GO00CogmoO1?l5g`Co0ml3o`;O
00?ogml00]l3o`GO1?l3g`?o0]l4o`CO0ol2g`03omoO00;O00?ogml01=l00ol0000?0003omoO00;O
0ol3g`;o1=l2o`KO00?ogml00]l3o`CO00?ogml00]l2o`KO00?ogml00]l3o`CO00?ogml00]l2o`KO
00?ogml00]l3o`CO00?ogml00]l2o`KO00?ogml00]l3o`CO00?o00001`0000T000GogmoOo`02g`04
omoOg`;o0ml01?oOgol5g`03omoO00;O00?ogml01=l00ooOg`02g`03omoO00GO00?ogol01Ml01OoO
gmoo00GO00?ogml01=l00ooOo`07g`05omoogol01]l01OoOgmoo00CO00?ogml01=l00ol0000?0003
omoO00?O00?ogml00]l2o`?O00Cogmoo1Ml00ooOg`03g`03omoO00?O00GogmoOo`02g`03omoO00?O
00?ogml00ml00ooOg`03g`05omoOgol00]l00ooOg`03g`03omoO00?O00?ogml00ml01OoOgmoo00;O
00?ogml00ml00ooOg`03g`03omoO00?O00?o00001`0000T000GogmoOo`02g`04omoOg`;o0ml01?oO
gol5g`03omoO00;O00?ogml01=l00ooOg`03g`03omoO00CO00?ogol01Ml01OoOgmoo00?O1?l5g`03
omoo00OO00GogooOo`04g`Co0]l00ooOg`03g`03omoO00?O00?o00003`001?oOgml4o`?O0_l3g`04
omoOo`GO00CogmoO1?l4g`05omoOgol00]l00ooOg`03g`04omoOg`Co1=l01OoOgmoo00;O00?ogml0
0ml01?oOgml4o`CO00GogmoOo`02g`03omoO00?O00CogmoO1?l4g`03o`0000L000090003omoO00;O
0_l4g`;o1=l2o`KO00?ogml00]l00ooOg`04g`03omoO00CO00?ogml00ml00ooOo`05g`05omoOgol0
0ml00ooOo`06g`03omoo00GO0_l2g`03omoo00CO00?ogol00ml00ooOg`03g`03omoO00?O00?o0000
3`001ooOgmoogol01=l2o`?O00Cogmoo1Ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml00ml01ooO
gmoogol01Ml01OoOgmoo00;O00?ogml00ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml00ml01ooO
gmoogol01Ml00ol0000700002@001OoOgmoo00;O00CogmoO0_l3g`04omoOo`GO00?ogml00]l00ooO
g`04g`05omoOgol00]l00ooOg`03g`03omoo00GO00GogmoOo`03g`03omoo00KO00?ogol01ml01OoO
omoo00CO00?ogol00ml00ooOg`04g`03omoO00;O00?o00003`001ooOgmoogol01=l2o`?O00Cogmoo
1Ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml00ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml0
0ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml00ml01ooOgmoogol01Ml00ol0000700002@000ooO
g`02g`;o1=l2o`CO0_l6g`04omoOg`;o1]l00ooOg`02g`;o1]l3o`CO0_l3g`03omoO00;O0_l6g`?o
1=l3o`;O0ol5g`;o0ml01?oOgml4o`CO00?o00003`000ooOg`02g`;o1=l2o`CO0_l6g`03omoO00;O
0_l5g`03omoO00;O0_l6g`03omoO00;O0_l5g`03omoO00;O0_l6g`03omoO00;O0_l5g`03omoO00;O
0_l6g`03omoO00;O0_l5g`03o`0000L000090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L0
00090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L00009077o4@1ao`T000090003omoO00SO
0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?o00003`000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03o`0000L000090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L0
00090003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?o00003`000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000L000090003omoO00;O00?ogml00ml2o`CO
00?ogml01Ml4o`CO0ol00mooo`02o`?O0ol3g`03omoO00;O0ol4g`Co0ml3o`?O00CogmoO1?l4g`04
omoOg`?o1]l00ooOg`02g`;o1Ml00ol0000?0004omoOg`?o1=l2o`CO0_l6g`04omoOg`?o1Ml00ooO
g`02g`;o1]l01?oOgml3o`GO00?ogml00]l3o`GO00?ogml00]l00ooOg`04g`04omoOg`Co1Ml01?oO
gml3o`GO00?o00001`0000T000?ogml00]l00ooOg`03g`;o1=l00ooOg`05g`03omoo00KO00Kogmoo
gol7g`04omoOo`GO00?ogml00ml00ooOo`05g`03omoO00;O00?ogml00]l00ooOg`04g`03omoO00;O
00?ogml01Ml01OoOgmoo00;O00?ogml00]l00ol0000?0003omoO00CO00CogmoO0_l3g`04omoOo`GO
00?ogml01=l00ooOg`02g`05omoOgol00]l00ooOg`03g`03omoO00;O00?ogml01=l00ooOg`03g`03
omoO00CO00?ogml00]l00ooOg`04g`03omoO00;O00?ogml01Ml00ooOg`04g`03omoO00;O00?o0000
1`0000T000?ogml00ml00ooOg`02g`;o1Ml00ooOg`04g`03omoo00CO1?l01=oogol7g`04omoOo`?O
1?l4g`03omoo00GO00?ogml00]l00ooOg`03g`03omoO00?O00?ogml00]l00ooOg`05g`05omoOgol0
0]l00ooOg`02g`03o`0000l000?ogml01=l01?oOgml2o`?O00Cogmoo1Ml00ooOg`04g`03omoO00;O
00GogmoOo`02g`03omoO00?O00?ogml00]l00ooOg`04g`04omoOg`Co1Ml00ooOg`03g`03omoO00?O
00?ogml00ml00ooOg`04g`03omoO00CO00?ogml00]l00ol0000700002@000ooOg`03g`03omoO00;O
0_l5g`03omoO00CO00?ogol01=l00ooOo`02g`03omoo00GO0_l3g`07omoOgooOo`05g`03omoo00GO
00?ogml00]l00ooOg`04g`03omoO00;O00?ogml00]l00ooOg`05g`03omoO00;O0_l5g`03o`0000l0
00?ogml00]l2o`CO0_l3g`04omoOo`GO00?ogml00]l2o`GO00CogmoO0ol6g`03omoO00;O00?ogml0
1=l01ooOgmoogol01]l00ooOg`03g`03omoO00?O00?ogml01=l00ooOg`03g`04omoOg`?o1Ml00ol0
000700002@000ooOg`04g`04omoOg`;o1]l00ooOg`03g`03omoo00CO00?ogol00]l00ooOo`07g`04
omoOo`?O00?ogol01Ml00ooOo`05g`03omoO00;O00GogmoOo`02g`03omoO00;O00?ogml00]l00ooO
g`05g`05omoOgol00]l00ooOg`02g`03o`0000l000?ogml01=l01?oOgml2o`?O00Cogmoo1Ml00ooO
g`04g`03omoO00;O00GogmoOo`08g`03omoO00;O00?ogml01=l01ooOgmoogol01]l00ooOg`04g`03
omoO00;O00GogmoOo`02g`03omoO00?O00GogmoOo`07g`03o`0000L000090004omoOg`Co0ml2o`?O
1?l5g`?o1Ml2o`;O0ol4g`?o0ml00ooOg`02g`;o1Ml3o`CO0_l4g`03omoO00;O0_l5g`04omoOg`;o
1ml00ooOg`02g`;o1Ml00ol0000?0004omoOg`?o1=l2o`CO0_l6g`04omoOg`?o1Ml00ooOg`02g`?o
1Ml01?oOgml2o`KO00?ogml00]l2o`KO00CogmoO1?l4g`03omoO00;O0_l6g`04omoOg`Co1=l00ol0
000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooOg`08g`;o3=l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@1aoa40
LOl900002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooOg`08g`;o3=l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooO
g`02g`?o0ml2o`CO0ol5g`03omoO00;O0_l5g`04omoOg`?o1]l4o`?O0ol2g`04omoOg`Co1Ml4o`CO
0ol00moog`03g`03omoO00GO1?l3g`?o0]l00ol0000?0004omoOg`Co0ml2o`CO0_l6g`04omoOg`Co
1=l00ooOg`02g`?o1Ml00ooOg`02g`;o1Ml00ooOg`02g`;o1]l01?oOgml4o`CO00?ogml00]l3o`GO
00?ogml00]l2o`GO00?o00001`0000T000?ogml00ml00ooOg`02g`;o1Ml00ooOg`04g`05omoOgol0
0]l00ooOg`02g`03omoO00;O00?ogml01Ml00ooOo`07g`03omoo00CO00?ogml01Ml00ooOo`06g`04
omoOo`CO00?ogml01Ml00ooOo`05g`05omoOgol04@000ooOg`02g`03omoO00?O0_l3g`04omoOo`GO
00?ogml00]l00ooOg`04g`03omoO00?O00?ogml01=l01OoOgmoo00;O00?ogml00]l01OoOgmoo00;O
00?ogml00ml00ooOg`02g`03omoO00CO00?ogml00ml00ooOg`04g`05omoOgol00]l00ooOg`02g`03
o`0000L000090004omoOg`Co0ml2o`?O1?l5g`05omoOgol00]l00ooOg`02g`03omoO00;O00?ogml0
1Ml00ooOo`07g`03omoo00GO00?ogml01=l00ooOo`04g`Co00?Ooml01=l00ooOg`04g`03omoo00GO
00GogmoOo`0A0003omoO00?O00?ogml00]l2o`?O00Cogmoo1Ml00ooOg`03g`03omoO00?O00CogmoO
1?l5g`05omoOgol00]l00ooOg`02g`05omoOgol00]l00ooOg`03g`03omoO00?O00?ogml00ml01?oO
gml4o`GO00GogmoOo`02g`03omoO00;O00?o00001`0000T000OogmoOomoo00CO0_l3g`03omoo00KO
00?ogml00]l2o`GO00?ogml00]l00ooOg`05g`03omoo00GO0_l2g`03omoO00CO00?ogml00ml00ooO
o`04g`03omoo00;O00?ogml00ml00ooOg`04g`03omoo00GO00GogmoOo`0A0003omoO00CO00CogmoO
0_l3g`04omoOo`GO00?ogml01=l00ooOg`02g`07omoOgooOo`06g`04omoOg`?o1Ml01OoOgmoo00;O
00?ogml00ml00ooOg`04g`03omoO00;O00OogmoOomoo00KO00CogmoO0ol5g`03o`0000L000090007
omoOgooOo`04g`;o0ml00ooOo`06g`05omoOgol00]l00ooOg`02g`03omoO00;O00?ogml01Ml00ooO
o`07g`03omoo00?O00Cogmoo1Ml00ooOo`04g`03omoo00;O00?ogml01=l00ooOg`03g`03omoo00GO
00GogmoOo`0A0005omoOgol00]l01?oOgml2o`?O00Cogmoo1Ml01OoOgmoo00;O00?ogml00]l01ooO
gmoogol01]l01OoOgmoo00OO00GogmoOo`02g`03omoO00?O00GogmoOo`02g`03omoO00;O00OogmoO
omoo00KO00GogmoOo`07g`03o`0000L000090003omoO00;O0_l4g`;o1=l2o`KO00?ogml00]l2o`GO
00CogmoO0_l7g`?o1=l3o`;O00?ogml00]l2o`KO0ol5g`;o0]l01?oOgml4o`GO0ol4g`;o0ml00ol0
000?0003omoO00;O0_l4g`;o1=l2o`KO00?ogml00]l2o`GO00?ogml00]l2o`KO00?ogml00]l3o`CO
00?ogml00]l2o`KO00?ogml00]l2o`GO00?ogml00]l2o`KO00?ogml00]l3o`CO00?o00001`0000T0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO
0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?o00001`0000T0LOlA077o2@0000T000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000?0003omoO00SO0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003omoO00SO
0_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?o00001`0000T000CogmoO1?l3g`;o0ml4o`GO00?ogml00]l3o`CO00?ogml00]l2o`KO1?l4g`?o
00?Ooml00]l3o`KO00?ogml00]l00ooOg`04g`Co0ml3o`?O1?l3g`?o0]l00ol0000?0004omoOg`?o
1=l2o`CO0_l6g`04omoOg`?o1Ml01?oOgml4o`GO00CogmoO0ol5g`03omoO00;O0ol5g`04omoOg`?o
1Ml00ooOg`02g`;o1]l00ooOg`02g`03omoO00CO00?o00001`0000T000?ogml00]l00ooOg`03g`;o
1=l00ooOg`05g`03omoO00?O00?ogml00ml01OoOgmoo00;O00?ogml00ml00ooOo`06g`04omoOo`CO
00?ogml01Ml00ooOg`02g`03omoO00CO00?ogol01Ml00ooOg`02g`03omoo00OO00?ogol04@000ooO
g`02g`03omoO00?O0_l3g`04omoOo`GO00?ogml00]l00ooOg`04g`03omoO00;O00?ogml01Ml00ooO
g`04g`03omoO00;O00?ogml00ml00ooOg`04g`03omoO00CO00?ogml00]l01OoOgmoo00;O00?ogml0
0ml00ooOg`02g`03omoO00CO00?o00001`0000T000?ogml00ml00ooOg`02g`;o1Ml00ooOg`04g`04
omoOg`Co1=l01OoOgmoo00;O00?ogml00ml00ooOo`04g`Co00?Ooml00ml00ooOg`05g`03omoO00?O
00?ogml00ml00ooOo`05g`03omoO00;O00?ogol01ml00ooOo`0A0003omoO00;O00?ogml00ml2o`?O
00Cogmoo1Ml00ooOg`02g`03omoO00CO00?ogml00ml00ooOg`04g`03omoO00CO00?ogml00]l01?oO
gml4o`GO00?ogml01=l00ooOg`02g`05omoOgol00]l00ooOg`03g`03omoO00?O00?ogml00ml00ol0
000700002@000ooOg`04g`04omoOg`;o1]l00ooOg`03g`07omoOgooOo`05g`03omoO00;O0_l6g`03
omoo00CO00?ogol00]l00ooOg`02g`03omoO00GO00?ogml00ml00ooOg`03g`03omoo00GO00?ogml0
0]l00ooOo`05g`;o0]l00ol0000?0003omoO00;O00?ogml00ml2o`?O00Cogmoo1Ml00ooOg`02g`03
omoO00CO00?ogml01=l00ooOg`03g`03omoO00;O0_l5g`07omoOgooOo`06g`04omoOg`?o1Ml01?oO
gml3o`KO00?ogml00ml00ooOg`03g`03o`0000L000090005omoOgol00]l01?oOgml2o`?O00Cogmoo
1Ml01ooOgmoogol01Ml01OoOgmoo00;O00?ogml00ml00ooOo`04g`03omoo00;O00?ogml00]l00ooO
g`05g`03omoO00CO00?ogml00]l00ooOo`05g`03omoO00;O00?ogol01ml00ooOo`0A0003omoO00;O
00?ogml00ml2o`?O00Cogmoo1Ml00ooOg`02g`03omoO00CO00GogmoOo`02g`03omoO00?O00?ogml0
1=l00ooOg`02g`07omoOgooOo`06g`05omoOgol01ml01OoOgmoo00SO00?ogml01=l00ooOg`02g`03
o`0000L000090003omoO00;O0_l4g`;o1=l2o`KO00?ogml00]l2o`GO00?ogml00]l2o`KO0ol5g`;o
0]l01?oOgml2o`OO00CogmoO1?l4g`?o1=l2o`CO0ol4g`?o0]l00ol0000?0004omoOg`;o1Ml2o`CO
0_l6g`04omoOg`;o1]l00ooOg`02g`;o1]l01?oOgml3o`GO00?ogml00]l2o`KO00CogmoO1?l4g`03
omoO00;O0ol5g`04omoOg`Co1=l00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0
000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooOg`08g`;o3=l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000700002@1aoa40LOl900002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0
000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooOg`08g`;o3=l00ooO
g`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l0
00?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ol0000700002@001?oOgml3o`CO0_l3g`?o1]l01?oOgml4o`CO00?ogml00]l3o`GO
00?ogml00]l00ooOg`04g`03omoO00;O0_l6g`Co0ml3o`;O1?l3g`?o0ml4o`CO0ol00moo000@0003
omoO00;O0_l4g`;o1=l2o`KO00?ogml00]l2o`GO00?ogml00]l2o`KO00?ogml00]l2o`GO00?ogml0
0]l2o`KO00?ogml00]l2o`GO00?ogml00]l2o`KO00?ogml00]l2o`GO00?o00001`0000T000?ogml0
0]l00ooOg`03g`;o1=l00ooOg`05g`03omoO00;O00?ogml01=l00ooOg`03g`03omoO00CO00?ogml0
0]l00ooOg`04g`05omoOgol00]l00ooOg`03g`03omoo00GO00OogmoOomoo00OO00Kogmoogol6g`04
omoOoa4000GogmoOo`02g`04omoOg`;o0ml01?oOgol5g`05omoOgol00]l00ooOg`02g`05omoOgol0
0]l00ooOg`03g`05omoOgol00]l00ooOg`02g`05omoOgol00]l00ooOg`03g`05omoOgol00]l00ooO
g`02g`05omoOgol00]l00ooOg`03g`05omoOgol00]l00ooOg`02g`03o`0000L000090003omoO00;O
00?ogml00ml2o`CO00?ogml01Ml00ooOg`03g`03omoO00?O00CogmoO1?l5g`03omoO00?O00?ogml0
0ml01OoOgmoo00;O00?ogml00ml00ooOo`05g`07omoOgooOo`07g`06omoOomoo1=l4o`03gol00100
00GogmoOo`02g`04omoOg`;o0ml01?oOgol5g`05omoOgol00]l00ooOg`02g`05omoOgol00]l00ooO
g`03g`05omoOgol00]l00ooOg`02g`05omoOgol00]l00ooOg`03g`05omoOgol00]l00ooOg`02g`05
omoOgol00]l00ooOg`03g`05omoOgol00]l00ooOg`02g`03o`0000L000090003omoO00;O00?ogml0
0ml2o`CO00?ogml01Ml00ooOg`04g`03omoO00;O00OogmoOomoo00KO00?ogml00ml00ooOg`03g`03
omoO00;O0_l6g`03omoo00GO00OogmoOomoo00GO0_l3g`03omoo00CO00?ogol00]l00ol0000?0005
omoOgol00]l01?oOgml2o`?O00Cogmoo1Ml01OoOgmoo00;O00?ogml00]l01OoOgmoo00;O00?ogml0
0ml01OoOgmoo00;O00?ogml00]l01OoOgmoo00;O00?ogml00ml01OoOgmoo00;O00?ogml00]l01OoO
gmoo00;O00?ogml00ml01OoOgmoo00;O00?ogml00]l00ol0000700002@000ooOg`02g`03omoO00?O
0_l4g`03omoO00GO00GogmoOo`02g`03omoO00;O00OogmoOomoo00KO00?ogml01=l00ooOg`02g`05
omoOgol00]l00ooOg`03g`03omoo00GO00OogmoOomoo00OO00Kogmoogol4g`03omoo00;O00?o0000
3`001OoOgmoo00;O00CogmoO0_l3g`04omoOo`GO00GogmoOo`02g`03omoO00;O00GogmoOo`02g`03
omoO00?O00GogmoOo`02g`03omoO00;O00GogmoOo`02g`03omoO00?O00GogmoOo`02g`03omoO00;O
00GogmoOo`02g`03omoO00?O00GogmoOo`02g`03omoO00;O00?o00001`0000T000CogmoO0_l5g`;o
0ml2o`OO00?ogml00]l2o`GO00?ogml00]l2o`KO00CogmoO1?l4g`03omoO00;O0_l6g`?o1=l2o`?O
0ol4g`?o0ml3o`GO0_l2g`03o`0000l000?ogml00]l2o`CO0_l4g`;o1]l00ooOg`02g`;o1Ml00ooO
g`02g`;o1]l00ooOg`02g`;o1Ml00ooOg`02g`;o1]l00ooOg`02g`;o1Ml00ooOg`02g`;o1]l00ooO
g`02g`;o1Ml00ol0000700002@000ooOg`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooO
g`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000700002@000ooO
g`08g`;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooO
g`09g`03o`0000l000?ogml02=l2o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooO
g`09g`03omoO00[O00?ogml02Ml00ol000070000201boa00L_l90000201boa00L_l900002@03o`03
0?oo00D00_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03
omoO00WO00?o00003`03o`030?oo00D00_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T000Go0?l0o`0500?o3=l00ooOg`09g`03
omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03o`0000l000Go0?l0
o`0500?o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooO
g`09g`03o`0000L000090004o`00o`D000Co0?oo0ml3o`KO00CogmoO1?l4g`03omoO00;O0ol5g`03
omoO00;O00?ogml01=l00ooOg`02g`;o1]l4o`?O0ol2g`Co0ml3o`?O1?l4g`?o00?Oo`0040001?l0
0?l50004o`3oo`CO0_l6g`04omoOg`?o1Ml01?oOgml4o`GO00CogmoO0ol5g`03omoO00;O0ol5g`04
omoOg`?o1Ml00ooOg`02g`;o1]l00ooOg`02g`03omoO00CO00?o00001`0000T000Ko0?l0o`03o`80
0_l4g`03omoO00GO00?ogml00]l00ooOg`04g`03omoO00?O00?ogml01=l00ooOg`02g`03omoO00CO
00GogmoOo`02g`03omoO00?O00?ogol01Ml01ooOgmoogol01ml01_oOgooOo`KO00Cogmoo4@001_l0
o`3o00?o0P02o`?O00Cogmoo1Ml00ooOg`02g`03omoO00CO00?ogml00]l00ooOg`05g`03omoO00CO
00?ogml00]l00ooOg`03g`03omoO00CO00?ogml01=l00ooOg`02g`05omoOgol00]l00ooOg`03g`03
omoO00;O00?ogml01=l00ol0000700002@03o`050?oo0?l00`02o`CO00?ogml01Ml00ooOg`03g`03
omoO00?O00CogmoO1?l5g`03omoO00?O00?ogml00ml01OoOgmoo00;O00?ogml00ml00ooOo`05g`07
omoOgooOo`07g`06omoOomoo1=l4o`03gol001000ol01@3oo`3o00<00_l3g`04omoOo`GO00?ogml0
0]l00ooOg`04g`03omoO00?O00?ogml01=l00ooOg`04g`03omoO00;O00CogmoO1?l5g`03omoO00CO
00?ogml00]l01OoOgmoo00;O00?ogml00ml00ooOg`03g`03omoO00?O00?o00001`0000T000?o0000
0`000ol0o`0200;o1=l00ooOg`05g`03omoO00CO00?ogml00]l01ooOgmoogol01]l00ooOg`03g`03
omoO00?O00?ogml00]l2o`KO00?ogol01Ml01ooOgmoogol01Ml2o`?O00?ogol01=l00ooOo`02g`03
o`0000l000?o00000`000ol0o`0200;o0ml01?oOgol5g`03omoO00;O00?ogml01=l00ooOg`04g`03
omoO00?O00?ogml00]l2o`GO00OogmoOomoo00KO00CogmoO0ol5g`04omoOg`?o1]l00ooOg`03g`03
omoO00?O00?o00001`0000T000?o00000P001?l00?l200;o1=l00ooOg`05g`05omoOgol00]l00ooO
g`02g`07omoOgooOo`06g`03omoO00CO00?ogml00]l01OoOgmoo00;O00?ogml00ml00ooOo`05g`07
omoOgooOo`07g`06omoOomoo1=l00ooOo`02g`03o`0000l000?o00000P001?l00?l200;o0ml01?oO
gol5g`03omoO00;O00?ogml01=l01OoOgmoo00;O00?ogml00ml00ooOg`04g`03omoO00;O00OogmoO
omoo00KO00GogmoOo`07g`05omoOgol02=l00ooOg`04g`03omoO00;O00?o00001`0000T000Go0000
o`020004o`3o00;o0ml2o`OO00?ogml00]l2o`GO00?ogml00]l2o`KO00CogmoO1?l4g`03omoO00;O
0_l6g`?o1=l2o`?O0ol4g`?o0ml3o`GO0_l2g`03o`0000l000Go0000o`020004o`3o00;o1=l2o`KO
00CogmoO0_l6g`03omoO00;O0_l6g`04omoOg`?o1Ml00ooOg`02g`;o1]l01?oOgml4o`CO00?ogml0
0]l3o`GO00CogmoO1?l4g`03o`0000L000090004o`00o`<000Co0?l00_l<g`03omoO00WO00?ogml0
2]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00003`001?l00?l30004
o`3o00;o3=l00ooOg`09g`03omoO00[O00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooO
g`09g`03o`0000L000090003o`3o00<00_l00`3oo`02o`cO00?ogml02Ml00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0000?0003o`3o00<00_l00`3oo`02o`cO
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ol0
000700002@02o`T00_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O00?ogml02Ml00ooO
g`0:g`03omoO00WO00?o00003`02o`T00_l<g`03omoO00WO00?ogml02]l00ooOg`09g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?o00001`0000T0LOlA077o2@0001@00_n000;oK@000140
0_l@00;oC003obD00_l:00;oC003o`l0000A0003o`00010000?o0000B`000ol0000T0003o`0000X0
00?o0000B`000ol0000>00002`02o`@000?o00000P03o`<00ol50003o`0003800_l00`3oo`090003
o`3o00T000?o00005P04o`040?oo00;o0`000ol0000300;o1@000ol0000b00;o00<0ool02@000ol0
o`090003o`0000d0000:0004o`00o`<000?o00000`000ol000050003o`00008000?o0000<`000ol0
o`0;0003o`0000P000?o00005`000ol0o`020003o`3o00@000?o00000P001?l00?l40003o`0003<0
00?o0?l02`000ol000080003o`0000d0000:0004o`00o`<000?o00000`000ol000050003o`000080
00?o0000=0000ol0000800Go1`000ol0o`0H0003o`0000<000?o00000`000ol000020004o`00o`@0
00?o0000=0000ol0000800Go1`000ol0o`0>00002P001?l00?l30003o`0000<000?o00000P03o`D0
00?o0000<`000ol0o`0;0003o`0000L000?o0?l06@001ol0003o0?l010000ol0000300;o1@000ol0
000c0003o`3o00/000?o00001`000ol0o`0>00002P001?l00?l30003o`0000<000?o00000P000ol0
00050003o`0003800_l00`3oo`0C00;o00<0ool05P000ol0o`0200;o00<0ool00`000ol000020004
o`00o`@000?o0000<P02o`030?oo01<00_l00`3oo`0=00002@02o`800_l200;o0`02o`@01?l300;o
I`04o`T00_l400;o1002oeh0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0
003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0
003o00H00009077o4P1_o`X000090003omoO01;O0_lF7`03oalO01<O00?o7al051l00olO7`0C7`03
o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lF7`03
oalO01<O00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03
o`0000P000090003omoO01;O0_lF7`03oalO01<O00?o7al051l00olO7`0C7`03o`00010000?ogml0
5ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lF7`03oalO01<O00?o7al0
51l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003
omoO01;O0_lF7`03oalO01<O00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml0
6=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lF7`03oalO01<O00?o7al051l00olO7`0C7`03
o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lF7`03
oalO01<O00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03
o`0000P000090003omoO01;O0_lF7`03oalO01<O00?o7al051l00olO7`0C7`03o`00010000?ogml0
5ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO00OO0ol8g`;o21l3o`/O00?o7al0
1al2o`XO00?o7al01al00olO7`0:7`03oalO00LO0_l:7`03o`00010000?ogml05ml2oa_O00?ogml0
6=l00ooOg`0Ig`03o`0000P000090003omoO00SO00?ogml01ml2o`/O00?o7al021l00olO7`067`04
oalOo`TO00?o7al01al00olO7`0:7`03oalO00HO00Co7aoo2Al00ol0000@0003omoO00WO0_l<g`;o
6ml00ooOg`09g`;o3Ml00ooOg`08g`03omoO00kO00?o0000200000T000?ogml01]l4o`SO0_l;7`03
oalO00PO00?o7al01Ql01?lO7ol97`03oalO00PO00?o7al02Al00olO7`067`04oalOo`TO00?o0000
40000ooOg`09g`03omoo00_O0_l;g`;o00?Ooml02ml00ooOg`09g`03omoo00cO00?ogml02=l01?oO
ool=g`03o`0000P000090003omoO00KO00?ogol02Ml2o`PO0ol;7`03oalO00HO0ol:7`03oalO00PO
00?o7al02Al00olO7`077`;o2Ql00ol0000@0003omoO00[O0_l;g`;o2]l01?oOgol=g`03omoO00[O
0_l<g`03omoO00WO00Cogmoo3=l00ol0000800002@000ooOg`06g`03omoo00WO0_l87`03oalO00/O
00?o7al01Ql00olO7`0:7`03oalO00TO00?o7al021l00olO7`067`04oalOo`TO00?o000040000ooO
g`0:g`;o2ml2o`[O00Cogmoo3Ml00ooOg`0:g`;o3=l00ooOg`09g`04omoOo`cO00?o0000200000T0
00?ogml01ml2o`WO0_l87`Co2Ql00olO7`077`?o2Al00olO7`067`Co2Ql00olO7`077`;o2Ql00ol0
000@0003omoO00WO0_l00moog`09g`;o2]l01?oOgol=g`03omoO00WO0_l00moog`0:g`03omoO00WO
00?ogol03Ml00ol0000800002@000ooOg`0Bg`;o5Ql00olO7`0C7`03oalO01@O00?o7al04al00ol0
000@0003omoO00OO0_l4g`03omoO00OO0_l;g`;o00?Ooml02ml00ooOg`07g`;o1=l00ooOg`08g`03
omoO00WO00Cogmoo3=l00ol0000800002@000ooOg`0Bg`;o5Ql00olO7`0C7`03oalO01@O00?o7al0
4al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml02]l2o`gO00?o0000200000T000?ogml0
4]l2oaHO00?o7al04al00olO7`0D7`03oalO01<O00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03
omoO01WO00?o0000200000T000?ogml04]l2oaHO00?o7al04al00olO7`0D7`03oalO01<O00?o0000
40000ooOg`0Gg`;o6ml00ooOg`0Hg`03omoO01WO00?o0000200000T000?ogml04]l2oaHO00?o7al0
4al00olO7`0D7`03oalO01<O00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03omoO01WO00?o0000
200000T000?ogml04]l2oaHO00?o7al04al00olO7`0D7`03oalO01<O00?o000040000ooOg`0Gg`;o
6ml00ooOg`0Hg`03omoO01WO00?o0000200000T000?ogml04]l2oaHO00?o7al04al00olO7`0D7`03
oalO01<O00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03omoO01WO00?o0000200000T0LOlB0003
omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00olO7`0C7`03
oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol000080000
2@000ooOg`0Bg`;o5]l00olO7`0C7`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03
omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00olO7`0C7`03oalO01@O00?o7al0
4al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o
5]l00olO7`0C7`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml0
6Ml00ol0000800002@000ooOg`0Bg`;o5]l00olO7`0C7`03oalO01@O00?o7al04al00ol0000@06oo
2P0000T000?ogml04]l2oaKO00?o7al04al00olO7`0D7`03oalO01<O00?o000040000ooOg`0Gg`;o
6ml00ooOg`0Hg`03omoO01WO00?o0000200000T000?ogml04]l2oaKO00?o7al04al00olO7`0D7`03
oalO01<O00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03omoO01WO00?o0000200000T000?ogml0
4]l2oaKO00?o7al04al00olO7`0D7`03oalO01<O00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03
omoO01WO00?o0000200000T000?ogml01]l3o`WO0_l9g`?o2]l00olO7`067`?o2Ql00olO7`077`;o
2al00olO7`077`03oalO00TO00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03omoO01WO00?o0000
200000T000?ogml02Ml00ooOg`06g`;o2]l00ooOg`09g`03oalO00TO00?o7al01al00olO7`067`04
oalOo`XO00?o7al01al00olO7`097`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03
o`0000P000090003omoO00WO00?ogml01]l2o`SO1?l:g`03oalO00TO00?o7al01al00olO7`067`04
oalOo`XO00?o7al021l00olO7`087`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03
o`0000P000090003omoO00OO0_l9g`;o2=l00ooOo`0;g`03oalO00HO0ol:7`03oalO00HO0ol;7`03
oalO00PO00?o7al021l00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol000080000
2@000ooOg`09g`03omoO00KO0_l8g`03omoo00_O00?o7al01Ql00olO7`0:7`03oalO00HO00?o7al0
2al00olO7`097`03oalO00LO00?o000040000ooOg`0Gg`;o6ml00ooOg`0Hg`03omoO01WO00?o0000
200000T000?ogml01]l3o`WO0_l9g`;o2ml00olO7`067`Co2Al00olO7`077`?o2Ql00olO7`067`Co
2Al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o
5]l00olO7`0C7`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml0
6Ml00ol0000800002@000ooOg`0Bg`;o5]l00olO7`0C7`03oalO01@O00?o7al04al00ol0000@0003
omoO00SO00?ogml03=l2oa_O00?ogml02=l00ooOg`0=g`03omoO00WO0_l>g`03o`0000P000090003
omoO01;O0_lFg`03oalO01<O00?o7al051l00olO7`0C7`03o`00010000?ogml02=l01?oOool;g`;o
2ml2o`03gooO00_O00?ogml02=l01?oOool<g`03omoO00WO00?ogol03Ml00ol0000800002@000ooO
g`0Bg`;o5]l00olO7`0C7`03oalO01@O00?o7al04al00ol0000@0003omoO00WO00Cogmoo2]l2o`[O
00Cogmoo3Ml00ooOg`09g`04omoOo`_O00?ogml02]l2o`gO00?o0000200000T000?ogml04]l2oaKO
00?o7al04al00olO7`0D7`03oalO01<O00?o000040000ooOg`09g`04omoOo`[O0_l:g`04omoOo`gO
00?ogml02Ml01?oOgol;g`03omoO00[O0_l=g`03o`0000P000090003omoO01;O0_lFg`03oalO01<O
00?o7al051l00olO7`0C7`03o`00010000?ogml02Ml00ooOo`0;g`;o2]l01?oOgol=g`03omoO00WO
00?ogol03=l00ooOg`09g`;o00?Ooml02ml00ol0000800002@000ooOg`0Bg`;o5]l00olO7`0C7`03
oalO01@O00?o7al04al00ol0000@0003omoO00WO00Cogmoo2]l2o`_O0_l00moog`0;g`03omoO00WO
00Cogmoo2ml00ooOg`07g`;o1=l00ooOg`09g`03o`0000P000090003omoO01;O0_lFg`03oalO01<O
00?o7al051l00olO7`0C7`03o`00010000?ogml02]l2o`_O0_lKg`03omoO00[O0_l<g`03omoO01WO
00?o0000200000T0LOlB0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooO
g`0Bg`;o5]l00ooOg`0Cg`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO
00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03oalO01@O00?o7al04al00ol0
000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooO
g`0Cg`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0
000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03oalO01@O00?o7al04al00ol0000@0003omoO01OO
0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03oalO01@O
00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooO
g`0Bg`;o5]l00ooOg`0Cg`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO
00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03oalO01@O00?o7al04al00ol0
000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooO
g`0Cg`03oalO01@O00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0
000800002@000ooOg`06g`Co2=l2o`SO0ol;g`03omoO00OO0ol9g`03oalO00HO0ol;7`03oalO00LO
0_l:7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO00OO
00?ogml02=l2o`_O00?ogml02=l00ooOg`08g`03omoO00SO00?o7al02Al00olO7`087`03oalO00HO
00Co7aoo2Al00ol0000@06oo2P0000T000?ogml02=l00ooOg`07g`;o2ml00ooOg`08g`03omoO00KO
1?l9g`03oalO00TO00?o7al021l00olO7`067`04oalOo`TO00?o000040000ooOg`0Gg`;o6ml00ooO
g`0Hg`03omoO01WO00?o0000200000T000?ogml02Ml00ooOg`06g`;o2Ml2o`_O00?ogml01]l00ooO
o`0:g`03oalO00HO0ol;7`03oalO00HO0ol:7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooO
g`0Ig`03o`0000P000090003omoO00KO00Cogmoo2=l2o`_O00?ogml02=l00ooOg`06g`03omoo00[O
00?o7al01Ql00olO7`0;7`03oalO00HO00?o7al02Ql00ol0000@0003omoO01OO0_lKg`03omoO01SO
00?ogml06Ml00ol0000800002@000ooOg`07g`;o2Ml2o`SO0ol;g`03omoO00OO0_l:g`03oalO00HO
1?l:7`03oalO00LO0ol97`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P0
00090003omoO01;O0_lFg`03omoO01?O00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2oa_O
00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lFg`03omoO01?O00?o7al051l00olO
7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O
0_lFg`03omoO01?O00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooO
g`0Ig`03o`0000P000090003omoO01;O0_lFg`03omoO01?O00?o7al051l00olO7`0C7`03o`000100
00?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lFg`03omoO01?O
00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P0
00090003omoO01;O0_lFg`03omoO01?O00?o7al051l00olO7`0C7`03o`00010000?ogml05ml2o`_O
0_l>g`03omoO01SO00?ogml02=l00ooOg`0>g`03o`0000P000090003omoO01;O0_lFg`03omoO01?O
00?o7al051l00olO7`0C7`03o`00010000?ogml02Ml2o`03gooO00WO0_l;g`03omoo00gO00?ogml0
2Ml2o`03gooO00[O00?ogml02=l01?oOool=g`03o`0000P00009077o4P000ooOg`08g`04omoOo`_O
0_l<g`;o3Ml00ooOg`08g`04omoOo`cO00?ogml02Ml01?oOgol<g`03o`0000P000090003omoO01;O
0_lFg`03omoO01?O00?ogml05=l00olO7`0C7`03o`00010000?ogml02=l01?oOgol;g`;o3=l2o`gO
00?ogml02=l01?oOgol<g`03omoO00WO00Cogmoo3=l00ol0000800002@000ooOg`0Bg`;o5]l00ooO
g`0Cg`03omoO01CO00?o7al04al00ol0000@0003omoO00SO00Cogmoo2ml2o`_O0_l00moog`0;g`03
omoO00SO00Cogmoo3=l00ooOg`09g`03omoo00gO00?o0000200000T000?ogml04]l2oaKO00?ogml0
4ml00ooOg`0Dg`03oalO01<O00?o000040000ooOg`09g`;o00?Ooml02Ml2o`WO0_l4g`03omoO00WO
00?ogml02Ml2o`03gooO00[O00?ogml02Ml01?oOgol<g`03o`0000P000090003omoO01;O0_lFg`03
omoO01?O00?ogml05=l00olO7`0C7`03o`00010000?ogml05ml2oa_O00?ogml06=l00ooOg`0:g`;o
3Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03omoO01CO00?o7al04al00ol0000@0003
omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03
omoO01CO00?o7al04al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol000080000
2@000ooOg`0Bg`;o5]l00ooOg`0Cg`03omoO01CO00?o7al04al00ol0000@0003omoO01OO0_lKg`03
omoO01SO00?ogml06Ml00ol0000800002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03omoO01CO00?o7al0
4al00ol0000@0003omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`06g`?o
2Ml2o`SO1?l:g`03omoO00KO0ol:g`03omoO00OO0ol:g`03oalO00HO0ol:7`03o`00010000?ogml0
5ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO00OO00?ogml02=l2o`WO00?ogml0
2]l00ooOg`09g`03omoO00OO00?ogml02=l00ooOg`09g`03oalO00TO00?o7al01al00ol0000@0003
omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`07g`03omoO00SO0_l:g`03
omoO00WO00?ogml02Ml00ooOg`07g`03omoO00KO1?l:g`03oalO00TO00?o7al01al00ol0000@0003
omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`07g`03omoO00SO0_l;g`03
omoO00SO00?ogml01ml2o`[O00?ogml01]l00ooOo`0;g`03oalO00HO0ol:7`03o`00010000?ogml0
5ml2oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO00OO00?ogml02=l2o`SO00Cogmoo
2]l00ooOg`09g`03omoO00OO00?ogml01]l00ooOo`0;g`03oalO00HO00?o7al02Ql00ol0000@0003
omoO01OO0_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ooOg`06g`;o2]l2o`WO0_l;g`03
omoO00KO0ol:g`03omoO00OO0_l;g`03oalO00HO1?l97`03o`00010000?ogml05ml2oa_O00?ogml0
6=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lFg`03omoO01?O00?ogml05=l00olO7`0C7`03
o`0000l0L?l:00002@000ooOg`0Bg`;o5]l00ooOg`0Cg`03omoO01CO00?o7al04al00ol0000?073o
2P0000T000?ogml04]l2oaKO00?ogml04ml00ooOg`0Dg`03oalO01<O00?o000040000ol0000G00;o
6ml00ooOg`0Hg`03omoO01WO00?o0000200000T000?ogml04]l2oaKO00?ogml04ml00ooOg`0Dg`03
oalO01<O00?o000040000ol0000F00?o6ml00ooOg`0Hg`03omoO01WO00?o0000200000T000?ogml0
4]l2oaKO00?ogml04ml00ooOg`0Dg`03oalO01<O00?o000040000ol0000E0004o`3ooa_O00?ogml0
6=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lFg`03omoO01?O00?ogml05=l00olO7`0C7`03
o`00010000?o000050000ol00002oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003omoO01;O
0_lFg`03omoO01?O00?ogml05=l00olO7`0C7`03o`00010000?o00004`001?l00002oa_O00?ogml0
6=l00ooOg`0Ig`03o`0000P000090003omoO01;O0_lFg`03omoO01?O00?ogml05=l00olO7`0C7`03
o`00010000?o00000`02o`030?oo00X000?o00000P02oa_O00?ogml06=l00ooOg`0Ig`03o`0000P0
000807;o4P000ol000040003o`3o00X000?o00000`02oa_O00?ogml06=l00ooOg`0Ig`03o`0000P0
000807;o4P000ol000050003o`0000P000?o00001002oa_O00?ogml06=l00ooOg`0Ig`03o`0000P0
00090003o`0001400olFg`03omoO01?O00?ogml05=l00ooOg`0Cg`03o`00010000?o000010000ol0
o`080003o`0000D00_lKg`03omoO01SO00?ogml06Ml00ol0000800002@000ol0000@0004o`3ooaKO
00?ogml04ml00ooOg`0Dg`03omoO01?O00?o000040000ol0000300;o00<0ool01P000ol0000600;o
6ml00ooOg`08g`03omoO00gO00?ogml02Ml2o`kO00?o0000200000T000?o00003`000ol00002oaKO
00?ogml04ml00ooOg`0Dg`03omoO01?O00?o000040000ol0000=0003o`0000L00_l;g`;o00?Ooml0
2ml00ooOg`08g`04omooo`cO00?ogml02Ml00ooOo`0=g`03o`0000P000090004o`0000;o00<0ool0
20001?l00002oaKO00?ogml04ml00ooOg`0Dg`03omoO01?O00?o000040000ol0000<0003o`0000P0
0_l:g`04omoOo`gO00?ogml02Ml01?oOgol;g`03omoO00[O0_l=g`03o`0000P000090003o`000080
00?o0?l020000ol0000200;o5]l00ooOg`0Cg`03omoO01CO00?ogml04ml00ol0000@0003o`0000/0
00?o00002@02o`[O00Cogmoo3Ml00ooOg`09g`04omoOo`_O00?ogml02]l2o`gO00?o0000200000T0
00?o00000`000ol000060003o`0000<00_lFg`03omoO01?O00?ogml05=l00ooOg`0Cg`03o`000100
00?o00002P000ol0000:00;o2]l01?oOgol=g`03omoO00WO00?ogol03=l00ooOg`09g`;o00?Ooml0
2ml00ol0000800002@000ol000020003o`3o00H000?o00001002oaKO00?ogml04ml00ooOg`0Dg`03
omoO01?O00?o000040000ol000090003o`0000<00ol500;o2ml2o`03gooO00_O00?ogml02Ml01?oO
gol;g`03omoO00OO0_l4g`03omoO00WO00?o0000200000T000Co00000_l00`3oo`040003o`0000D0
0_l8g`?o2ml00ooOg`06g`Co2Ml00ooOg`06g`?o2ml00ooOg`07g`?o2Ml00ol0000@0003o`0000P0
00?o00001@000ol0000400;o6ml00ooOg`0:g`;o3=l00ooOg`0Ig`03o`0000P000090003o`0000T0
00?o00001P02o`WO00?ogml02]l00ooOg`07g`03omoO00WO00?ogml02Ml00ooOg`08g`03omoO00SO
00?ogml02=l00ol0000@0003o`0000L000?o00001`000ol0000300;o6ml00ooOg`0Hg`03omoO01WO
00?o0000200000T000?o000020000ol0000700;o2Ml00ooOg`0:g`03omoO00SO00?ogml02=l00ooO
g`09g`03omoO00SO00?ogml01]l4o`WO00?o000040000ol000060003o`0000P000?o00000`02oa_O
00?ogml06=l00ooOg`0Ig`03o`0000P000090003o`0000L000?o00000ol500;o2Ml00ooOg`0:g`03
omoO00WO00?ogml01ml00ooOg`07g`;o2ml00ooOg`06g`03omoo00[O00?o000040000ol000050003
o`0000P000?o0?l01002oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003o`0000H000?o0000
0P000ol0000400;o2Ml00ooOg`0:g`03omoO00KO00Cogmoo2Ml00ooOg`09g`03omoO00SO00?ogml0
1]l00ooOo`0:g`03o`00010000?o000010000ol000090003o`3o00@00_lKg`03omoO01SO00?ogml0
6Ml00ol0000800002@000ol000050003o`0000@000?o00000`02o`SO0_l<g`03omoO00OO0_l:g`03
omoO00KO0ol;g`03omoO00OO0_l:g`03o`00010000?o00000`000ol0000900;o00<0ool00`02oa_O
00?ogml06=l00ooOg`0Ig`03o`0000P000090003o`0000@000?o00001@000ol0000300;o5]l00ooO
g`0Cg`03omoO01CO00?ogml04ml00ol0000@0003o`00008000?o00004P02oa_O00?ogml06=l00ooO
g`0Ig`03o`0000P000090003o`0000<000?o00001@000ol0o`0400;o5]l00ooOg`0Cg`03omoO01CO
00?ogml04ml00ol0000@0005o`000?l05@02oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003
o`00008000?o00001P000ol0o`0400;o5]l00ooOg`0Cg`03omoO01CO00?ogml04ml00ol0000@0004
o`00oaH00_lKg`03omoO01SO00?ogml06Ml00ol0000800002@001Ol0003o00P00_l00`3oo`0300;o
5]l00ooOg`0Cg`03omoO01CO00?ogml04ml00ol0000@0003o`3o01L00_lKg`03omoO01SO00?ogml0
6Ml00ol0000800002@001?l00?lA00;o5]l00ooOg`0Cg`03omoO01CO00?ogml04ml00ol0000@00;o
6002oa_O00?ogml06=l00ooOg`0Ig`03o`0000P000090003o`3o01800_lFg`03omoO01?O00?ogml0
5=l00ooOg`0Cg`03o`000100Kol:00002@02oa<00_lFg`03omoO01?O00?ogml05=l00ooOg`0Cg`03
o`0002X00_mM00002@1aoh/0000N00;oi@000?l01P000?l01P000?l01P000?l01P000?l01P000?l0
1P0003<01?lj00?o@P04ocP00ol@0000=0000ol0000k0003o`00048000?o0000>@000ol0000?0000
2`03o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`801Ol00`3oo`02ob400_l00`3oo`090003
o`3o00T000?o00006003o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`801Ol00`3oo`02oal0
0_l00`3oo`090003o`3o00T000?o00003P0000`000Go0000o`020004o`00o`@000Go0000o`030003
o`00008000Oo0000o`3o008000Co003o0`000ol0000O0003o`3o00/000?o000020000ol0000I0005
o`000?l00P001?l00?l40005o`000?l00`000ol000020007o`000?l0o`020004o`00o`<000?o0000
7@000ol0o`0;0003o`0000P000?o00003P0000`000Go0000o`020003o`0000Ko00@0oooo0`000ol0
00020007o`000?l0o`020004o`00o`<000?o000080000ol0000800Go1`000ol0o`0J0005o`000?l0
0P000ol00006o`040?ooo`<000?o00000P001ol0003o0?l00P001?l00?l30003o`0001h000?o0000
2005o`L000?o0?l03`0000X000Oo0?l0o`3o008000Co003o0`02o`L00_l30007o`000?l0o`020004
o`00o`<000?o00007`000ol0o`0;0003o`0000L000?o0?l060001ol0o`3o0?l00P001?l00?l300;o
1`02o`<000Oo0000o`3o008000Co003o0`000ol0000M0003o`3o00/000?o00001`000ol0o`0?0000
2P001_l0o`3o00Co0`03o`030?l0008000?o00000_l00`3oo`0200?o00@0ool00_l00`3oo`03ob40
0_l00`3oo`0C00;o00<0ool05`001_l0o`3o00Co0`03o`030?l0008000?o00000_l00`3oo`0200?o
00@0ool00_l00`3oo`03oal00_l00`3oo`0C00;o00<0ool03P0000X01Ol00`3o000:00CoK@05o`03
0?l000X01?mR00003`02oh400_ma0000o`060000o`060000o`060000o`060000o`060000\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-0.0500105, -0.0554394, 
  0.00805185, 0.00805185}, {{6.1875, 124.438}, {280.062, 
  150}} -> {-1.71953, -1.00145, 0.0799163, 0.0799163}, {{136.312, 254.562}, {
  280.062, 150}} -> {-12.1186, -1.00145, 0.0799163, 0.0799163}, {{6.1875, 
  124.438}, {136.938, 6.875}} -> {-1.40002, -6.80064, 0.0444022, 
  0.0444022}, {{136.312, 254.562}, {136.938, 6.875}} -> {-6.10007, -5.56416, 
  0.0363291, 0.0363291}},
  CellTags->"FourStandard"],

Cell[BoxData[
    \({False, True, True, True}\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell["\<\
A group identity must be both a left identity and a right identity. \
Warning messages may give additional information in case of failure.\
\>", 
  "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasIdentityQ[{G\_1, \ G\_2}]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(Identity::"lfail" \( : \ \) 
      "\!\(\"TheGroup\"\) does not have a left identity."\)], "Message",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(Identity::"rfail" \( : \ \) 
      "\!\(\"TheGroup\"\) does not have a right identity."\)], "Message",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(Identity::"fail" \( : \ \) 
      "\!\(\"TheGroup\"\) does not have an identity."\)], "Message",
  CellTags->"FourStandard"],

Cell[BoxData[
    \({False, True}\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "While the ",
  StyleBox["Textual", "MR"],
  " mode of ",
  StyleBox["HasIdentityQ", "MR"],
  " reveals the identity, if it exists, the identity can also be obtained \
with the ",
  StyleBox["Identity", "MR"],
  " function."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Identity[G\_2, \ Mode\  \[Rule] \ Textual]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("We say a Groupoid G has an identity e if for all other elements g in G \
we have e * g = g * e = g (where * indicates the operation)."\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("In this case, TheGroup has the identity \[Beta]."\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(\[Beta]\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode illustrates how an identity is both a left and right identity."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasIdentityQ[MinTaker[4], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .57143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0136054 0.47619 [
[ 0 0 0 0 ]
[ 1 .57143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .57143 L
0 .57143 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0136054 0.477324 0.557823 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.12381 0.190476 [
[ 0 0 0 0 ]
[ 1 1.2 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.2 L
0 1.2 L
closepath
clip
newpath
1 1 0 r
.21429 .12381 m
.21429 .31429 L
.40476 .31429 L
.40476 .12381 L
F
.40476 .12381 m
.40476 .31429 L
.59524 .31429 L
.59524 .12381 L
F
.59524 .12381 m
.59524 .31429 L
.78571 .31429 L
.78571 .12381 L
F
.78571 .12381 m
.78571 .31429 L
.97619 .31429 L
.97619 .12381 L
F
.21429 .88571 m
.21429 1.07619 L
.97619 1.07619 L
.97619 .88571 L
F
0 g
[(red->left identity)] .04286 .02857 -1 0 Mshowa
1 0 0 r
.02381 .12381 m
.02381 .31429 L
.21429 .31429 L
.21429 .12381 L
F
1 1 0 r
.78571 .12381 m
.78571 .31429 L
.97619 .31429 L
.97619 .12381 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .12381 m
.02381 1.07619 L
s
.02381 .12381 m
.97619 .12381 L
s
.02381 .31429 m
.97619 .31429 L
s
.02381 .50476 m
.97619 .50476 L
s
.02381 .69524 m
.97619 .69524 L
s
.02381 .88571 m
.97619 .88571 L
s
.02381 1.07619 m
.97619 1.07619 L
s
.21429 .12381 m
.21429 1.07619 L
s
.40476 .12381 m
.40476 1.07619 L
s
.59524 .12381 m
.59524 1.07619 L
s
.78571 .12381 m
.78571 1.07619 L
s
.97619 .12381 m
.97619 1.07619 L
s
.02381 1.07619 m
.21429 .88571 L
s
2.6 Mabswid
.21429 .12381 m
.21429 1.07619 L
s
.02381 .88571 m
.97619 .88571 L
s
[(1)] .30952 .79048 0 0 Mshowa
[(1)] .5 .79048 0 0 Mshowa
[(1)] .69048 .79048 0 0 Mshowa
[(1)] .88095 .79048 0 0 Mshowa
[(1)] .30952 .6 0 0 Mshowa
[(2)] .5 .6 0 0 Mshowa
[(2)] .69048 .6 0 0 Mshowa
[(2)] .88095 .6 0 0 Mshowa
[(1)] .30952 .40952 0 0 Mshowa
[(2)] .5 .40952 0 0 Mshowa
[(3)] .69048 .40952 0 0 Mshowa
[(3)] .88095 .40952 0 0 Mshowa
[(1)] .30952 .21905 0 0 Mshowa
[(2)] .5 .21905 0 0 Mshowa
[(3)] .69048 .21905 0 0 Mshowa
[(4)] .88095 .21905 0 0 Mshowa
[(1)] .11905 .79048 0 0 Mshowa
[(2)] .11905 .6 0 0 Mshowa
[(3)] .11905 .40952 0 0 Mshowa
[(4)] .11905 .21905 0 0 Mshowa
[(1)] .30952 .98095 0 0 Mshowa
[(2)] .5 .98095 0 0 Mshowa
[(3)] .69048 .98095 0 0 Mshowa
[(4)] .88095 .98095 0 0 Mshowa
[(MinTaker[4])] .02381 1.17143 -1 0 Mshowa
gsave
.97619 1.17143 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .94857 0 0 Mshowa
[(y)] .16667 1.01905 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0136054 0.97619 0.557823 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.12381 0.190476 [
[ 0 0 0 0 ]
[ 1 1.2 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.2 L
0 1.2 L
closepath
clip
newpath
0 1 1 r
.78571 .69524 m
.78571 .88571 L
.97619 .88571 L
.97619 .69524 L
F
.78571 .50476 m
.78571 .69524 L
.97619 .69524 L
.97619 .50476 L
F
.78571 .31429 m
.78571 .50476 L
.97619 .50476 L
.97619 .31429 L
F
.78571 .12381 m
.78571 .31429 L
.97619 .31429 L
.97619 .12381 L
F
0 g
[(red->right identity)] .04286 .02857 -1 0 Mshowa
0 1 1 r
.02381 .12381 m
.02381 .88571 L
.21429 .88571 L
.21429 .12381 L
F
1 0 0 r
.78571 .88571 m
.78571 1.07619 L
.97619 1.07619 L
.97619 .88571 L
F
0 1 1 r
.78571 .12381 m
.78571 .31429 L
.97619 .31429 L
.97619 .12381 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .12381 m
.02381 1.07619 L
s
.02381 .12381 m
.97619 .12381 L
s
.02381 .31429 m
.97619 .31429 L
s
.02381 .50476 m
.97619 .50476 L
s
.02381 .69524 m
.97619 .69524 L
s
.02381 .88571 m
.97619 .88571 L
s
.02381 1.07619 m
.97619 1.07619 L
s
.21429 .12381 m
.21429 1.07619 L
s
.40476 .12381 m
.40476 1.07619 L
s
.59524 .12381 m
.59524 1.07619 L
s
.78571 .12381 m
.78571 1.07619 L
s
.97619 .12381 m
.97619 1.07619 L
s
.02381 1.07619 m
.21429 .88571 L
s
2.6 Mabswid
.21429 .12381 m
.21429 1.07619 L
s
.02381 .88571 m
.97619 .88571 L
s
[(1)] .30952 .79048 0 0 Mshowa
[(1)] .5 .79048 0 0 Mshowa
[(1)] .69048 .79048 0 0 Mshowa
[(1)] .88095 .79048 0 0 Mshowa
[(1)] .30952 .6 0 0 Mshowa
[(2)] .5 .6 0 0 Mshowa
[(2)] .69048 .6 0 0 Mshowa
[(2)] .88095 .6 0 0 Mshowa
[(1)] .30952 .40952 0 0 Mshowa
[(2)] .5 .40952 0 0 Mshowa
[(3)] .69048 .40952 0 0 Mshowa
[(3)] .88095 .40952 0 0 Mshowa
[(1)] .30952 .21905 0 0 Mshowa
[(2)] .5 .21905 0 0 Mshowa
[(3)] .69048 .21905 0 0 Mshowa
[(4)] .88095 .21905 0 0 Mshowa
[(1)] .11905 .79048 0 0 Mshowa
[(2)] .11905 .6 0 0 Mshowa
[(3)] .11905 .40952 0 0 Mshowa
[(4)] .11905 .21905 0 0 Mshowa
[(1)] .30952 .98095 0 0 Mshowa
[(2)] .5 .98095 0 0 Mshowa
[(3)] .69048 .98095 0 0 Mshowa
[(4)] .88095 .98095 0 0 Mshowa
[(MinTaker[4])] .02381 1.17143 -1 0 Mshowa
gsave
.97619 1.17143 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .94857 0 0 Mshowa
[(y)] .16667 1.01905 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[43]:=",
  ImageSize->{288, 164.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000Y0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000780
0omB00?o?@03oaH0001c0003o`0005@000?o0000>`000ol0000E00003@04o`<01?l200Go3005o`80
1?l00`3oo`02o`<00ol800Go0P05o`030?oo00;o00@0ool00_l200?o0P05o`800ol30003o`0002D0
1?l300Co0P05o``01?l200Go0P04o`040?oo00;o0P03o`P01Ol200Go00<0ool00_l0103oo`02o`80
0ol200Go0P03o`<000?o0000500000h000?o00000P000ol000030005o`000?l01P02o`L000Go0000
o`060003o`0000<000Co003o2@001Ol0003o00<000?o0?l01@001?l00?l30004o`00o`<000?o0000
0P001?l00?l20003o`0002H000?o00000P000ol000030005o`000?l01P02o`H000?o000010001Ol0
003o00<000?o0?l00P001Ol0003o008000?o00001`001Ol0003o00<000?o0?l01@001?l00?l30004
o`00o`<000?o00000P001?l00?l20003o`0001@0000>0003o`0000801Ol00`3o00020003o`3o00Co
0P02o`D000Co00001Ol20003o`0000<000?o00002P001Ol0003o00<000?o0?l01?l01@3o003o00<0
00?o000010000ol000020003o`00008000?o0?l09`000ol0000200Go00<0o`000P000ol0o`04o`80
0_l40003o`0000@000Go0000o`030003o`3o008000Go0000o`0<0005o`000?l00`000ol0o`04o`05
0?l00?l00`000ol000040003o`00008000?o00000P000ol0o`0E00003P02o`<000Oo0000o`3o00<0
00?o000020000ol000020005o`000?l00`001?l00?l50003o`0000X000Go0000o`030003o`3o00<0
00?o0?l00P001Ol0003o00H000?o00000P000ol000020003o`3o02L00_l30007o`000?l0o`030003
o`0000P000Co00000_l50005o`000?l00`000ol0o`020005o`000?l030001Ol0003o00<000?o0?l0
0`000ol0o`020005o`000?l01P000ol000020003o`00008000?o0?l05@0000d00_l00`3oo`0200?o
0`04o`P00_l50003o`0000800ol200Co0P04o`T00_l400Co0P03o`030?oo00?o0P04o`<00_l300Co
00@0ool00_lU00;o00<0ool00P03o`<01?l800;o0`02o`030?oo00800_l400Wo0P04o`T00_l400Co
0P03o`030?oo00?o0P04o`<00_l300Co00@0ool00_lD00007@000ol0000400;o1`000ol000080003
o`0000<000?o00004P000ol0000<0003o`0000T000?o0000>`000ol0000400;o5`000ol000040003
o`00018000?o000030000ol000090003o`0001X0000L00;o3@03o`X00ol30003o`0000X000?o0000
1002o`h000?o000010000ol000020003o`0003X00_lE0003o`0000H00_l60003o`0000X000?o0000
1002o`h000?o000010000ol000020003o`0001X0003o0240003o0240003o0240003o0240003o0240
003o0240003o0240000:07co4`1lo`/0000:0003oalO01DO0_lGg`03omoO01KO00?ogml05]l00ooO
g`0Eg`03o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X0
00?o7al05Al2oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol10@0D0@;o60000ol0
000F0003o`0001D000?o0@405P400ol0000900002P000olO7`0E7`;o5ml00ooOg`0Fg`03omoO01KO
00?ogml05Ml00ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0
000:0003oalO01DO0_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`00014000?o0@405042oaP0
00?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o7al05Al2oaOO00?ogml05]l00ooO
g`0Fg`03omoO01GO00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0
000900002P000olO7`0E7`;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`4101@1
0_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003oalO01DO0_lGg`03omoO01KO
00?ogml05]l00ooOg`0Eg`03o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H1
00?o00002@0000X000?o7al05Al2oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol1
0@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000olO7`0E7`;o5ml00ooO
g`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:0003oalO00PO0ol:7`;o2Ml3o`_O00?ogml02=l4o`[O00?ogml01ml3o`cO
00?ogml02=l3o`[O00?o00004@000ol10@080@?o2@42o`X00ol;0003o`0000L01?l;0003o`0000L0
0ol;0003o`4100T10ol:0@03o`0000T0000:0003oalO00TO00?o7al02Al2o`[O00?ogml02]l00ooO
g`09g`03omoO00[O00?ogml02]l00ooOg`09g`03omoO00WO00?ogml02Ml00ol0000A0003o`4100T1
00?o0@402042o`/000?o00002P000ol000080003o`0000/000?o00002P000ol000080003o`4100X1
00?o0@402@400ol0000900002P000olO7`077`Co2Ql2o`[O00?ogml02]l00ooOg`0:g`03omoO00WO
00?ogml02]l00ooOg`09g`03omoO00OO1?l:g`03o`00014000?o0@401`44o`T10_l;0003o`0000X0
00?o00002@000ol0000:0003o`0000X000?o000020000ol10@080@Co2P400ol0000900002P000olO
7`077`03oaoo00/O0_l:g`03omoO00[O00?ogml02ml00ooOg`08g`03omoO00SO0_l<g`03omoO00OO
00?ogol02ml00ol0000A0003o`4100L100?o0Ol02P42o`/000?o00002P000ol0000:0003o`0000T0
00?o00002002o`/000?o0@4020400ol1o`0;0@03o`0000T0000:0003oalO00LO00?o7ol02al2o`[O
00?ogml02]l00ooOg`08g`04omoOo`[O00?ogml02]l00ooOg`09g`03omoO00OO00?ogol02ml00ol0
000A0003o`4100L100?o0Ol02P42o`/000?o00002P000ol000070004o`00o`/000?o00002P000ol0
00080003o`4100P100?o0Ol02`400ol0000900002P000olO7`087`;o2al2o`WO0_l<g`03omoO00WO
0_l;g`03omoO00OO0ol<g`03omoO00SO0_l;g`03o`00014000?o0@402042o`X10_l:00;o30000ol0
000800;o30000ol0000700?o2`000ol10@090@;o2`400ol0000900002P000olO7`0E7`;o5ml00ooO
g`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:0003oalO01DO0_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`000140
00?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o7al05Al2oaOO
00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D0
00?o0@405P400ol0000900002P000olO7`0E7`;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0
000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003oalO01DO
0_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`00014000?o0@405042oaP000?o00005P000ol0
000E0003o`4101H100?o00002@0000X000?o7al05Al2oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO
00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000olO
7`0E7`;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`4101@10_lH0003o`0001H0
00?o00005@000ol10@0F0@03o`0000T0000:0003oalO01DO0_lGg`03omoO01KO00?ogml05]l00ooO
g`0Eg`03o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X0
00?o7al05Al2oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol10@0D0@;o60000ol0
000F0003o`0001D000?o0@405P400ol0000900002P1loa<0O?l;00002P000ol0000E00;o5`000ol0
000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`000140
00?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o00005@02oaL0
00?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D0
00?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0
000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D0
0_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0
000E0003o`4101H100?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D0
00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0
000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H0
00?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0
000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X0
00?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0
000F0003o`0001D000?o0@405P400ol0000900002P000ol0000700?o2`02o`T00ol;0003o`0000P0
1?l:0003o`0000L00ol<0003o`0000L00ol;0003o`00014000?o0@401`43o`X10_l:00?o2`000ol0
000700Co2`000ol0000700?o2`000ol10@080@?o2`400ol0000900002P000ol0000:0003o`0000P0
0_l:0003o`0000X000?o00002@000ol0000:0003o`0000X000?o00002@000ol0000:0003o`0000P0
00?o00004@000ol10@0:0@03o`4100L10_l;0003o`0000X000?o000020000ol0000;0003o`0000X0
00?o000020000ol10@0;0@03o`4100P100?o00002@0000X000?o00002P000ol0000800;o2P000ol0
000:0003o`0000X000?o00002@000ol0000:0003o`0000T000?o00002P000ol000080003o`000140
00?o0@402P400ol10@070@;o2`000ol0000:0003o`0000T000?o00002P000ol0000:0003o`0000P0
00?o0@402`400ol10@080@03o`0000T0000:0003o`0000P00_l;00;o2P000ol0000:0003o`0000/0
00?o000020000ol0000800;o30000ol0000800;o2`000ol0000A0003o`4100P10_l:0@;o2`000ol0
000:0003o`0000X000?o00002@000ol0000800;o2`000ol10@090@;o2`400ol0000900002P000ol0
000:0003o`0000P00_l:0003o`0000X000?o000020001?l00?l:0003o`0000X000?o00002@000ol0
000:0003o`0000P000?o00004@000ol10@0:0@03o`4100L10_l;0003o`0000X000?o00001`001?l0
0?l;0003o`0000X000?o000020000ol10@0;0@03o`4100P100?o00002@0000X000?o00001`03o`/0
0_l900;o30000ol0000900;o2`000ol0000700?o30000ol0000700?o2`000ol0000A0003o`4100L1
0ol:0@;o2P02o``000?o00002002o``000?o00001`03o`/000?o0@402043o`/100?o00002@0000X0
00?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0
000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H0
00?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0
000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP0
00?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o00005@02oaL000?o00005P000ol0
000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0
000900002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0000A0003o`4101@1
0_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H0
00?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H1
00?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol1
0@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0
000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:07co4`1lo`/0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0
000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X0
00?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0
000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H0
00?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0
000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP0
00?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o00005@02oaL000?o00005P000ol0
000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0
000900002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0000A0003o`4101@1
0_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H0
00?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H1
00?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol1
0@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0
000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`000140
00?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o00001`04o`X0
0_l900?o2`000ol0000800Co2P000ol0000700Co2`000ol0000700Co2P000ol0000A0003o`4100L1
1?l90@;o2P03o`/000?o00001`04o`/000?o00001`04o`X000?o0@402044o`X100?o00002@0000X0
00?o000020000ol0000:00;o2P000ol0000:0003o`0000T000?o00002P000ol000080003o`0000/0
00?o000020000ol0000:0003o`00014000?o0@4020400ol10@090@;o2`000ol0000:0003o`0000P0
00?o00002`000ol000080003o`0000X000?o0@402@400ol10@0:0@03o`0000T0000:0003o`0000T0
00?o00002@02o`X000?o00002P000ol0000:0003o`0000T000?o00002@000ol0000:0003o`0000T0
00?o00002@000ol0000A0003o`4100T100?o0@402042o`/000?o00002P000ol000090003o`0000X0
00?o00002@000ol000090003o`4100X100?o0@402@400ol0000900002P000ol0000:0003o`0000P0
0_l:0003o`0000X000?o00002`000ol000080003o`0000X000?o00002@000ol0000:0003o`0000P0
00?o00004@000ol10@0:0@03o`4100L10_l;0003o`0000X000?o00002P000ol000090003o`0000X0
00?o000020000ol10@0;0@03o`4100P100?o00002@0000X000?o00001`001?l00?l:00;o2P000ol0
000:0003o`0000P000Co003o2P000ol000070004o`00o`/000?o00001`001?l00?l:0003o`000140
00?o0@401`401?l10Ol90@;o2`000ol0000:0003o`0000L000Co003o2`000ol000070004o`00o`X0
00?o0@4020401?l10Ol:0@03o`0000T0000:0003o`0000P00_l;00;o2@02o``000?o00002@02o`/0
00?o00002002o``000?o00002002o`/000?o00004@000ol10@080@;o2P42o`X00_l<0003o`0000P0
0_l<0003o`0000P00_l;0003o`4100T10_l;0@03o`0000T0000:0003o`0001D00_lG0003o`0001H0
00?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H1
00?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol1
0@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0
000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`000140
00?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o00005@02oaL0
00?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D0
00?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0
000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D0
0_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0
000E0003o`4101H100?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D0
00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P1loa<0
O?l;00002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0000A0003o`4101@1
0_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H0
00?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H1
00?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol1
0@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0
000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol1
0@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`000140
00?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X000?o00005@02oaL0
00?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D0
00?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0
000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D0
0_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0
000E0003o`4101H100?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D0
00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0
000700?o2`02o`T00ol;0003o`0000P00ol;0003o`0000L00ol<0003o`0000L00ol;0003o`000140
00?o0@401`43o`X10_l:00?o2`000ol0000700?o30000ol0000700?o2`000ol10@080@?o2`400ol0
000900002P000ol000080003o`0000X00_l:0003o`0000X000?o00002@000ol0000:0003o`0000P0
00?o00002`000ol000080003o`0000X000?o00004@000ol10@080@03o`4100T10_l;0003o`0000X0
00?o000020000ol0000;0003o`0000P000?o00002P000ol10@090@03o`4100X100?o00002@0000X0
00?o000020000ol0000:00;o2P000ol0000:0003o`0000T000?o00002P000ol000080003o`0000/0
00?o000020000ol0000:0003o`00014000?o0@4020400ol10@090@;o2`000ol0000:0003o`0000P0
00?o00002`000ol000080003o`0000X000?o0@402@400ol10@0:0@03o`0000T0000:0003o`0000P0
00?o00002P02o`X000?o00002P000ol000090003o`0000X000?o000020000ol0000;0003o`0000P0
00?o00002P000ol0000A0003o`4100P100?o0@402@42o`/000?o00002P000ol000080003o`0000/0
00?o000020000ol0000:0003o`4100T100?o0@402P400ol0000900002P000ol000080003o`0000X0
0_l:0003o`0000X000?o00002@000ol0000:0003o`0000P000?o00002`000ol000080003o`0000X0
00?o00004@000ol10@080@03o`4100T10_l;0003o`0000X000?o000020000ol0000;0003o`0000P0
00?o00002P000ol10@090@03o`4100X100?o00002@0000X000?o00001`02o``00_l900;o30000ol0
000800;o30000ol0000700;o3@000ol0000700;o30000ol0000A0003o`4100L10_l;0@;o2P02o``0
00?o00001`02o`d000?o00001`02o``000?o0@402042o``100?o00002@0000X000?o00005@02oaL0
00?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D0
00?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0
000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D0
0_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP000?o00005P000ol0
000E0003o`4101H100?o00002@0000X000?o00005@02oaL000?o00005P000ol0000F0003o`0001D0
00?o00004@000ol10@0D0@;o60000ol0000F0003o`0001D000?o0@405P400ol0000900002P000ol0
000E00;o5`000ol0000F0003o`0001H000?o00005@000ol0000A0003o`4101@10_lH0003o`0001H0
00?o00005@000ol10@0F0@03o`0000T0000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0
000E0003o`00014000?o0@405042oaP000?o00005P000ol0000E0003o`4101H100?o00002@0000X0
00?o00005@02oaL000?o00005P000ol0000F0003o`0001D000?o00004@000ol10@0D0@;o60000ol0
000F0003o`0001D000?o0@405P400ol0000900002P000ol0000E00;o5`000ol0000F0003o`0001H0
00?o00005@000ol0000A0003o`4101@10_lH0003o`0001H000?o00005@000ol10@0F0@03o`0000T0
000:0003o`0001D00_lG0003o`0001H000?o00005P000ol0000E0003o`00014000?o0@405042oaP0
00?o00005P000ol0000E0003o`4101H100?o00002@0000T0OOlB07go2`0000T0OOlB07go2`0000X0
00?o00005003oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol0000D00;o60000ol0
000F0003o`0001D000?o7al05Ql00ol0000900002P000ol0000C0004o`3ooaOO00?ogml05]l00ooO
g`0Fg`03omoO01GO00?o00004@000ol0000C00?o60000ol0000F0003o`0001D000?o7al05Ql00ol0
000900002P000ol0000B0003o`0000;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003
o`00018000Co0?oo60000ol0000F0003o`0001D000?o7al05Ql00ol0000900002P000ol0000A0004
o`0000;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`00014000?o00000_lH0003
o`0001H000?o00005@000olO7`0F7`03o`0000T0000:0003o`0000800_l00`3oo`090003o`000080
0_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`00014000?o00000P02o`030?oo00T000Co0000
0_lH0003o`0001H000?o00005@000olO7`0F7`03o`0000T0000:0003o`0000<000?o0?l02@000ol0
000300;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`0000<000?o0?l02@000ol0
000200;o60000ol0000F0003o`0001D000?o7al05Ql00ol0000900002P000ol000040003o`0000L0
00?o00001002oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol000040003o`0000L0
00?o00000`02oaP000?o00005P000ol0000E0003oalO01HO00?o00002@0000X000?o00000`000ol0
o`070003o`0000D00_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`00014000?o00000`000ol0
o`070003o`0000@00_lH0003o`0001H000?o00005@000olO7`0F7`03o`0000T0000:0003o`000080
0_l00`3oo`050003o`0000H00_l9g`?o2ml00ooOg`08g`Co2]l00ooOg`07g`?o3=l00ooOg`08g`?o
2]l00ol0000A0003o`0000800_l00`3oo`050003o`0000D00_l:00?o2`000ol0000700Co2`000ol0
000700?o2`000olO7`097`?o2Ql00ol0000900002P000ol0000;0003o`0000L00_l:g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00[O00?ogml02Ml00ooOg`09g`03omoO00WO00?o00004@000ol0
000;0003o`0000H00_l;0003o`0000X000?o000020000ol0000;0003o`0000X000?o000020000olO
7`0:7`03oalO00TO00?o00002@0000X000?o00002P000ol0000800;o2]l00ooOg`0:g`03omoO00[O
00?ogml02Ml00ooOg`0:g`03omoO00WO00?ogml01ml4o`[O00?o00004@000ol0000:0003o`0000L0
0_l;0003o`0000X000?o00002@000ol0000:0003o`0000X000?o000020000olO7`087`Co2Ql00ol0
000900002P000ol000090003o`0000?o1P02o`[O00?ogml02]l00ooOg`0;g`03omoO00SO00?ogml0
2=l2o`cO00?ogml01ml00ooOo`0;g`03o`00014000?o00002@000ol00003o`D00_l;0003o`0000X0
00?o00002P000ol000090003o`0000P00_l;0003oalO00PO00?o7ol02al00ol0000900002P000ol0
00080003o`00008000?o00001@02o`[O00?ogml02]l00ooOg`08g`04omoOo`[O00?ogml02]l00ooO
g`09g`03omoO00OO00?ogol02ml00ol0000A0003o`0000P000?o00000P000ol0000400;o2`000ol0
000:0003o`0000L000Co003o2`000ol0000:0003o`0000P000?o7al021l00olOo`0;7`03o`0000T0
000:0003o`0000L000?o000010000ol0000400;o2Ml2o`cO00?ogml02Ml2o`_O00?ogml01ml3o`cO
00?ogml02=l2o`_O00?o00004@000ol000070003o`0000@000?o00000`02o`X00_l<0003o`0000P0
0_l<0003o`0000L00ol;0003oalO00TO0_l;7`03o`0000T0000:0003o`0000H000?o00001@000ol0
000400;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`0000H000?o00001@000ol0
000300;o60000ol0000F0003o`0001D000?o7al05Ql00ol0000900002P000ol000050003o`0000D0
00?o0?l01@02oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO00?o00004@000ol000050003o`0000D0
00?o0?l01002oaP000?o00005P000ol0000E0003oalO01HO00?o00002@0000X000?o000010000ol0
00060003o`3o00D00_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`00014000?o000010000ol0
00060003o`3o00@00_lH0003o`0001H000?o00005@000olO7`0F7`03o`0000T0000:0003o`0000<0
00?o00001P02o`030?oo00@00_lGg`03omoO01KO00?ogml05]l00ooOg`0Eg`03o`00014000?o0000
0`000ol0000600;o00<0ool00`02oaP000?o00005P000ol0000E0003oalO01HO00?o00002@0000X0
00?o00000P000ol0000@00;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`000080
00?o00003`02oaP000?o00005P000ol0000E0003oalO01HO00?o00002@0000X000Go0000o`0C00;o
5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0005o`000?l04P02oaP000?o00005P000ol0
000E0003oalO01HO00?o00002@0000X000Co003o5002oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO
00?o00004@001?l00?lC00;o60000ol0000F0003o`0001D000?o7al05Ql00ol0000900002P000ol0
o`0E00;o5ml00ooOg`0Fg`03omoO01KO00?ogml05Ml00ol0000A0003o`3o01@00_lH0003o`0001H0
00?o00005@000olO7`0F7`03o`0000T0000:00;o5P02oaOO00?ogml05]l00ooOg`0Fg`03omoO01GO
00?o00004@02oaD00_lH0003o`0001H000?o00005@000olO7`0F7`03o`0000T0000:07co4`1lo`/0
000R00;oS002ofh0003o0240003o0240003o0240003o0240003o0240003o0240000l00;o2P02oc<0
0om;00;o2P02oc<00olA0000?0000ol0000:0003o`00038000?o0000BP000ol0000:0003o`000380
00?o0000400000/000Ko0000o`05o`040?oo00;o0P03o`801Ol00`3o0002o`<01?l00`3oo`02o`<0
00?o00000`03o`@000?o00006@02o`030?oo00T000?o0?l02@000ol0000H0006o`000?l01Ol0103o
o`02o`800ol200Go00<0o`000_l300Co00<0ool00_l30003o`0000<00ol40003o`0001T00_l00`3o
o`090003o`3o00T000?o00003`0000/000Go0000o`030005o`000?l00P000ol000020005o`000?l0
0P001_l00?l0o`<000?o000010000ol000030003o`0000@000?o00000`000ol0000J0003o`3o00/0
00?o000020000ol0000H0005o`000?l00`001Ol0003o008000?o00000P001Ol0003o008000Ko003o
0?l30003o`0000@000?o00000`000ol000040003o`0000<000?o00006P000ol0o`0;0003o`0000P0
00?o00003`0000/000Go0?l0o`030005o`000?l00P000ol000020004o`0000Co0P03o`<01Ol20003
o`0000<000?o00000P04o`@000?o00006`000ol0000800Go1`000ol0o`0I0005o`3o0?l00`001Ol0
003o008000?o00000P001?l00004o`800ol300Go0P000ol000030003o`0000801?l40003o`0001/0
00?o00002005o`L000?o0?l0400000/000Go0?l0o`030005o`000?l00P002?l00?l0o`3o10001_l0
0?l0o`<000Go0000o`0200;o10000ol000020003o`3o00D000?o00006P000ol0o`0;0003o`0000L0
00?o0?l06@001Ol0o`3o00<000Go0000o`020008o`00o`3o0?l40006o`00o`3o0`001Ol0003o0080
0_l40003o`00008000?o0?l01@000ol0000J0003o`3o00/000?o00001`000ol0o`0@00002`02o`03
0?oo00800_l200Go0P001Ol0o`3o00800ol20004o`3oo`<00ol200;o00<0ool00P000ol000020003
o`3o00D000?o00006@02o`030?oo01<00_l00`3oo`0H00;o00<0ool00P02o`801Ol20005o`3o0?l0
0P03o`8000Co0?oo0`03o`800_l00`3oo`020003o`00008000?o0?l01@000ol0000I00;o00<0ool0
4`02o`030?oo00l0000:00;o0`02o``01Ol70003o`0001000_l400;o1002odl00_l300;o3005o`L0
00?o00004002o`@00_l400;oA`0001<000?o00004P02ogP000?o00004P02ofL0003o0240003o0240
003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {163.562, 0}} -> {-0.0528217, -0.0285774, 
  0.00733674, 0.00733674}, {{7.1875, 137}, {159.625, 
  3.875}} -> {-1.41618, -0.809306, 0.0404499, 0.0404499}, {{149.938, 
  279.75}, {159.625, 3.875}} -> {-7.1904, -0.809306, 0.0404499, 0.0404499}},
  CellTags->"FourStandard"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FirstTaker", "MR"],
  " is a groupoid with multiple right identities but no left identity."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasIdentityQ[FirstTaker[5]]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(Identity::"lfail" \( : \ \) 
      "\!\(\"FirstTaker[5]\"\) does not have a left identity."\)], "Message",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(Identity::"rmultiple" \( : \ \) 
      "\!\(\"FirstTaker[5]\"\) has the following right identities: \!\({1, 2, \
3, 4, 5}\)."\)], "Message",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "When a groupoid fails to have an inverse for all of its elements, the ",
  StyleBox["Textual", "MR"],
  " mode of ",
  StyleBox["HasInversesQ", "MR"],
  " reveals an example of such an element."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasInversesQ[G\_2, \ Mode\  \[Rule] \ Textual]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("Given a Groupoid G, we say an element g in G has an inverse h if G has \
an identity e and g * h = h * g = e (where * indicates the operation)."\)], 
  "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("The Groupoid TheGroup contains some elements without inverses. For \
example, \[Alpha] does NOT have an inverse."\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["HasInversesQ", "MR"],
  " connects elements that are inverses of each other, using a loop for \
self-inversive elements. Which, if any, of these groups are isomorphic?"
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasInversesQ[{U[8], \ U[10], \ U[12], \ Z[4]}, \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0238095 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0238095 0.477324 0.477324 MathSubStart
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.008 w
.5 .5 Mdot
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.8663 .5 Mdot
.5 .1337 Mdot
.1337 .5 Mdot
0 g
gsave
.5 .95788 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.95788 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 .04212 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(7) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.04212 .5 -69 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(11) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 .165 .165 r
2 Mabswid
newpath
.5 .8956 .02564 0 365.73 arc
s
newpath
.8956 .5 .02564 0 365.73 arc
s
newpath
.5 .1044 .02564 0 365.73 arc
s
newpath
.1044 .5 .02564 0 365.73 arc
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0238095 0.97619 0.477324 MathSubStart
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.008 w
.5 .5 Mdot
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.8663 .5 Mdot
.5 .1337 Mdot
.1337 .5 Mdot
0 g
gsave
.5 .95788 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.95788 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 .04212 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.04212 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 .165 .165 r
2 Mabswid
newpath
.5 .8956 .02564 0 365.73 arc
s
.8663 .5 m
.1337 .5 L
s
newpath
.5 .1044 .02564 0 365.73 arc
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.522676 0.477324 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.008 w
.5 .5 Mdot
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.8663 .5 Mdot
.5 .1337 Mdot
.1337 .5 Mdot
0 g
gsave
.5 .95788 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.95788 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 .04212 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.04212 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(7) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 .165 .165 r
2 Mabswid
newpath
.5 .8956 .02564 0 365.73 arc
s
newpath
.8956 .5 .02564 0 365.73 arc
s
newpath
.5 .1044 .02564 0 365.73 arc
s
newpath
.1044 .5 .02564 0 365.73 arc
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.522676 0.97619 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.008 w
.5 .5 Mdot
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.8663 .5 Mdot
.5 .1337 Mdot
.1337 .5 Mdot
0 g
gsave
.5 .95788 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.95788 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 .04212 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(7) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.04212 .5 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(9) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 .165 .165 r
2 Mabswid
newpath
.5 .8956 .02564 0 365.73 arc
s
.8663 .5 m
.5 .1337 L
s
newpath
.1044 .5 .02564 0 365.73 arc
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[46]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@0004H000?o0000S004odL000160003o`0008d0
00?o0000A`0004L000?o0000S@000ol000160000A`000ol0002>0003o`0004D000180003o`0008X0
00Co003oA`0004D01?n=00;oB0000?l08@000?l08@0004@000HNM1id7WB90006M1id7W@NA`0004@0
00OC7m<OdaoC08P000LOdaoC7m<O04H000130003M1id00<000=d7P00QP000aid7P0300037W@004D0
001300037m<000<000<Odal0QP000m<O00030003daoC04D000130003M1h000=<00<07W@0QP0011id
0003C003M1h004@0001300097m<OddcC7m<O08H000WC7m<OC1oC7m<0A@0004@000LNM1id7W@N08P0
00Qd7W@NM1idC4D0000n0006CXi>STj>0T`00m<Od`02C007STj>CXi>SP1k000;STj>CXi>ST`Odal0
0d`01Xi>STj>CSl0000l0003?Th000D01d`70003?Th007H000=>?P001P07C0H000=>?P00?00003L0
00F>CXi>SP0900E<2P001Dj>CXi>06d000E>STj>CP0:00E<2@001Hi>STj>03P0000e0003CSh000h0
0d`@0003CSh006P000<nCP003`03C0l000<nCP00=@0003<000>>CP009@000hi>001T0003CXh002D0
00=>SP00<`00034000=>?P00:@000dhn001P0003?Th002T000<nCP00<@0002l000>>CP00;@000hi>
001L0003CXh002d000=>SP00;`0002h000<n0000<0000dh0001I0003CP00030000<n0000;@0002d0
00>>0000<P000dh0001G0003CP00038000>>0000;00002/000=>?P00=@000dhn001D0003?Th003D0
00<nCP00:`0002X000=>0000>0000hh0001A0003SP0003P000=>0000:@0002T000=>0000>P000ch0
001?0003?P0003X000=>0000:00002L000>>CP00?@000hi>001<0003CXh003d000=>SP009`0002H0
00<n0000@0000dh000190003CP00040000<n00009@0002D000>>0000@@000hh000190003SP000440
00>>0000900002@000<n0000@`000ch000170003?P0004<000<n00008`0002@000=>0000A0000hh0
00150003SP0004@000=>00008`0002<000=>0000AP000ch000130003?P0004H000=>00008P000280
00=>0000A`000dh000130003CP0004L000=>00008@00024000=>0000B@000dh000110003CP0004T0
00=>00008000024000>>0000BP000dh0000o0003CP0004X000>>00008000020000<n0000C0000dh0
000m0003CP0004`000<n00007`00020000=>0000C0000hh0000m0003SP0004`000=>00007`0001l0
00=>0000CP000ch0000k0003?P0004h000=>00007P0001l000>>0000CP000dh0000k0003CP0004h0
00>>00007P0001h000<n0000D0000dh0000i0003CP00050000<n00007@0001d000>>0000D@000hh0
000i0003SP00054000>>0000700001`000<n0000D`000ch0000g0003?P0005<000<n00006`0001`0
00=>0000D`000dh0000g0003CP0005<000=>00006`0001/000=>0000E@000dh0000e0003CP0005@0
00<n00006`0001/000>>0000E@000hh0000e0003SP0005@000=>00006`0001/000=>0000EP000ch0
000c0003?P0005H000=>00006P0001/000>>0000EP000dh0000c0003CP0005H000>>00006P0001X0
00<n0000F0000dh0000a0003CP0005P000<n00006@0001X000=>0000F0000hh0000a0003SP0005P0
00=>00006@0001T000=>0000FP000ch0000_0003?P0005X000=>0000600001T000>>0000FP000dh0
000_0003CP0005X000>>0000600001T000=>0000FP000ch0000_0003?P0005X000=>0000600001T0
00>>0000FP000dh0000_0003CP0005X000>>0000600001T000=>0000FP000ch0000_0003?P0005X0
00=>0000600001P000=>0000G0000hh0000]0003SP0005`000=>00005`0001P000<n0000G0000dh0
000]0003CP0005`000<n00005`0001P000=>0000G0000hh0000]0003SP0005`000=>00005`0001P0
00<n0000G0000dh0000]0003CP0005`000<n00005`0000L00ol300?o0P001M<Odal000=<G003C004
7m<Od`@00olE00?o2P03C5`00d`800?o3@0000P000?o00000`002Ol007@NM1id7P04C5X00d`01Qid
7W@NM0H000?o00005@000ol0000600E<FP05C0P000?o0000300000P000?o00000`001Ol001oC0080
00<Odd`014aH00A<00KC7d`0dal60003o`0001D000?o00001@07C5P01d`70003o`0000`000080003
o`0000<000Go01id7P020003M1id00A<F003C008M1idC00NM1h200?o5P02o`P00T`0HAid7W@NM1id
7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1id
7W@NM1id7W@NM1id7W@NM1id7W@NM1id7W@NM1h00d`70003o`0000`000080003o`0000<000Co0=<O
0`000dcC7`04C5P00d`011oCC4`200057m<00?l06P000ol00005009<067C7m<OdaoC7m<OdaoC7m<O
daoC7m<OdaoC7m<OdaoC7m<OdaoC7m<OdaoC7m<OdaoC7m<OdaoC7m<OdaoC7m<OdaoC7m<OdaoC7m<O
daoC7m<OdaoC7m<OdaoC7m<OdaoC00=<1`000ol0000<00001`02o`@00_l00`0NM0030003M1id00=<
FP02C003M1i<008000<NM1h00P04oa@00ol900E<FP05C0L00_l>000040001m<OdaoC7m<00daL0008
C1oC7m<OdalX00=<G003C1P0000@00097W@NM1id7P0n05h000Md7W@NM1id02T000=>0000G0000ch0
000G00004`000aoC00020003CP0005`000F>003C7`0[0003SP0005`000=>00005`0001P000<n0000
G0000dh0000]0003CP0005`000<n00005`0001P000=>0000G0000hh0000]0003SP0005`000=>0000
5`0001P000<n0000G0000dh0000]0003CP0005`000<n00005`0001P000=>0000G0000hh0000]0003
SP0005`000=>00005`0001T000=>0000FP000ch0000_0003?P0005X000=>0000600001T000>>0000
FP000dh0000_0003CP0005X000>>0000600001T000=>0000FP000ch0000_0003?P0005X000=>0000
600001T000>>0000FP000dh0000_0003CP0005X000>>0000600001X000<n0000F0000dh0000a0003
CP0005P000<n00006@0001X000=>0000F0000hh0000a0003SP0005P000=>00006@0001/000=>0000
EP000ch0000c0003?P0005H000=>00006P0001/000>>0000EP000dh0000c0003CP0005H000>>0000
6P0001/000=>0000EP000ch0000c0003?P0005H000=>00006P0001/000>>0000E@000hh0000e0003
SP0005@000=>00006`0001/000=>0000E@000dh0000e0003CP0005@000<n00006`0001`000=>0000
D`000dh0000g0003CP0005<000=>00006`0001d000=>0000DP000ch0000g0003?P00058000=>0000
700001h000=>0000D0000hh0000i0003SP00050000=>00007@0001h000<n0000D0000dh0000i0003
CP00050000<n00007@0001l000>>0000CP000dh0000k0003CP0004h000>>00007P0001l000=>0000
CP000ch0000k0003?P0004h000=>00007P00020000=>0000C0000hh0000m0003SP0004`000=>0000
7`00020000<n0000B`000ch0000o0003?P0004/000<n00007`00024000>>0000B@000hh000110003
SP0004T000>>00008000028000<n0000B0000dh000110003CP0004P000<n00008@0002<000>>0000
AP000dh000130003CP0004H000>>00008P0002<000=>0000A@000dh000150003CP0004D000=>0000
8P0002@000=>0000@`000dh000170003CP0004<000=>00008`0002D000=>0000@P000ch000170003
?P00048000=>0000900002H000=>SP00?`000dj>001:0003STh003l000>>CP009P0002P000<n0000
?0000dh0001=0003CP0003`000<n00009`0002T000>>0000>P000dh0001?0003CP0003X000>>0000
:00002X000<nCP00=`000ci>001B0003CSh003L000=>?P00:P0002`000=>SP00<`000dj>001F0003
STh003<000>>CP00;00002h000<n0000<0000dh0001I0003CP00030000<n0000;@0002l000>>0000
;P000dh0001K0003CP0002h000>>0000;P00030000<nCP00:`000ci>001N0003CSh002/000=>?P00
<000038000=>SP009`000dj>001R0003STh002L000>>CP00<P0003@000<nCP008`000ci>001V0003
CSh002<000=>?P00=00003H000=>SP003@03C0l000=>SP00JP000hi>000>00=<3P000hi>000f0000
>0001Ci>?Thn00P01D`90005CSi>?Th0K`001DhnCSi>00T01D`80005?ThnCSh0>@0003d000B>CXi>
0`07C0@000B>CXi>N@001Dj>CXi>00<01d`30004CXi>SSh000110003CSi>00M<00A>?ThnPP000dhn
CP07C003CSi>048000140007daoC7m<OC02800067m<OdaoC0Ta50000A0001aid7W@NM1h0R0001g@N
M1id7W@0AP0004<000<Odal00d`00aoC00260004daoC009<00?C7`00A@0004<000=d7P000`000g@N
M02600037W@000<000<NM1h0A@0004<000<Od`0010000m<O00250003dal000@000<Od`00A00004<0
00Ud7W@N01id7W@0QP002Aid7W@0M1id7P150000A0001m<OdaoC7m<0R0001aoC7m<Odal0AP0004H0
00<NM1h0S0000g@NM0180000A@03ohh00_m80000AP000ol0002<0004o`00odL000160003o`0008`0
00Co003oA`0004H000?o0000S0001?l00?m70000AP000ol0002<0004o`00odL0001500;oS`02odP0
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240001500?oSP000ol0
00170000B0000ol0002;0003o`0004L000180003o`0008`000?o0000AP0004D00on?0003o`0004H0
00150003o`00090000?o0000A@0004D01?n<00CoA`000?l08@000?l08@0004H000CC7m<OeP0004@0
00LNM1id7W@N0=D000140003daoC008000<Od`00e00004<000=d7W@00`000g@NM03D0000@`000aoC
0003C0030=<O08X00da70000@`0017@NM1h2C003M1id08T01Da60000A0001m<OdaoC7m<0R@07C4D0
00100004?ThnCP9<00XNM1id7ThnCSi>P00013i>?Th2C0037WA<009<00A>?Thn@@0003`000A>STj>
1007C0D000A>STj>M`001Hi>STj>00@00T`00m<OC002C0@000B>CXi>?@0003L000E>?ThnCP0900E<
2P001Ci>?Thn06d000DnCSi>?P0:0005C1id7T`02@001DhnCSi>03P0000e0003STh000h00d`@0003
STh006P000=>SP003`0014`Odal>0003CXh003D0000c0003CSh002D000=>?P00I0000ci>000C0003
7W@N00l000<nCP00<`00034000>>CP00:@000hi>001P0003CXh001H000<Odal040000dj>000a0000
<0000ch0000/0003CP0005d000=>000060000aid7P0A0003?P0002l0000_0003SP0002h000=>0000
F`000dh0000J00037m<O014000>>0000;P0002d000=>?P00<@000dhn001H0003?Th001d000<NM1h0
4@000ci>000]0000:`000hi>000e0003STh005@000=>SP0080000aoC7`0B0003CXh002/0000Z0003
?P0003P000=>0000D@000dh0000R00037W@N01<000<n0000:@0002T000>>0000>P000dh0001?0003
CP0002@000<Odal04`000hh0000X00009`000dhn000m0003CP0004`000<nCP009`000aid7P0C0003
?P0002L0000V0003CP0003l000=>0000BP000hh0000Y00037m<O01<000>>00009P0002D000=>0000
@@000dh000190003CP0002X000<NM1h04`000ci>000U000090000dh000130003CP0004L000=>0000
;0000aoC7`0D0003CP0002<0000T0003?P0004@000=>0000A@000dh0000^00037W@N01<000<n0000
8`0002<000>>0000AP000dh000130003CP00030000<Odal04`000hh0000R00008P000ch000170003
?P0004<000<n0000<@000aid7P0C0003?P000240000Q0003SP0004T000>>0000@@000hh0000c0003
7m<O01<000>>00008000024000=>0000BP000ch0000o0003?P0003D000<NM1h04P000dh0000P0000
80000dh0001<0003SP0003d000>>0000=`000aoC7`0B0003CP0001l0000P0003?P0004`000=>0000
?@000dh0000h00037W@N014000<n00007`0001l000>>0000CP000dh0000k0003CP0003X000<Odal0
4@000hh0000N00007`000dh0001>0003?P0003/000<n0000>`000aid7P0@0003CP0001h0000N0003
CP00050000>>0000>@000hh0000m00037m<O010000=>00007@0001d000=>0000D@000dh0000i0003
CP0003h000<NM1h040000dh0000L000070000dh0001C0003CP0003L000=>0000@0000aoC7`0@0003
CP0001/0000L0003?P0005<000<n0000=`000ch0001100037W@N00l000<n00006`0001/000>>0000
E@000hh0000e0003SP0004<000<Odal03P000dh0000K00006`000dh0001E0003CP0003D000=>0000
A0000aid7P0=0003?P0001/0000K0003SP0005H000=>0000<`000dh0001600037m<O00d000>>0000
6P0001/000=>0000EP000ch0000c0003?P0004L000<NM1h030000dh0000J00006P000dh0001H0003
SP00034000>>0000B@000aoC7`0<0003CP0001T0000J0003?P0005P000=>0000<@000dh0001:0003
7W@N00/000<n00006@0001X000=>0000F0000hh0000a0003SP0004/000<Odal02P000dh0000I0000
6@000dh0001J0003?P0002l000<n0000C@000aid7P0:0003CP0001P0000I0003SP0005X000=>0000
;`000dh0001>00037m<O00T000>>0000600001T000=>0000FP000ch0000_0003?P0004l000<NM1h0
20000dh0000H00006@000hh0001J0003CP0002l000=>0000D0000aoC7`070003SP0001P0000H0003
?P0005`000=>0000;@000dh0001B00037W@N00L000<n00005`0001P000=>0000G0000hh0000]0003
SP0005<000<Odal01P000dh0000G000060000ch0001L0003CP0002d000=>0000E0000aid7P050003
?P0001L0000H0003CP0005`000>>0000;@000hh0001E00037m<O00@000=>00005`00018000@NM1id
0P000ch0001L0006CP1d7W@N90001g@NM1id04h0F0000aid7P030003?P0001L0000;0003o`0000<0
00HOdaoC7m<3C5`00T`01]<OdaoC7`<00olE00?o10001m<OdaoC7m<00TaH00047m<O00=<2003o`d0
000;0003o`0000<000Id7P00M1h4C5X00d`01Qid000NM0H000?o00005@001_l0000NM0<000=d7T`0
0TaH00037W@N00A<2P000ol0000:000030001ol0003C7m<00P000aoC7`04C5P00d`021oC7d`0daoC
1@000ol0000C00?o0P000aoC7`020003C1oC00A<F0000aoC7`04C0T000?o00002P0000`000Ko0000
7W@30003C1id00A<F003C004M1i<C08000=d7P000P02oaD000Co003o0P000g@N00020003C7@N00A<
F00014`NM1h3C0L00_l=00003@001Ol00=<O00<000=<dal014aH00=<00@Odda<0P000aoC00040003
o`00018000Co003o0P000aoC7`020003C1oC00A<F002C0037m=<009<2@000ol0000:00002P04o`80
00PNM1id7W@NM0=<FP02C008M1id7W@NM1h200?o5P02o`@000LNM1id7W@N00=<FP05C0L00ol=0000
40001m<OdaoC7m<00daL0008C1oC7m<OdalR0006daoC7m<O0daL00=<600001<000=d7P000P000ch0
001L0005CP007W@09P000aid00020003CP0005`000<n00005`0001P000=>0000G0000hh0000]0003
SP0005`000=>00005`0001P000<n0000G0000dh0000]0003CP0005`000<n00005`0001P000=>0000
G0000hh0000]0003SP0005`000=>00005`0001P000<n0000G0000dh0000]0003CP0005`000<n0000
5`0001T000>>0000FP000dh0000_0003CP0005X000>>0000600001T000=>0000FP000ch0000_0003
?P0005X000=>0000600001T000>>0000FP000dh0000_0003CP0005X000>>0000600001T000=>0000
FP000ch0000_0003?P0005X000=>0000600001X000=>0000F0000hh0000a0003SP0005P000=>0000
6@0001X000<n0000F0000dh0000a0003CP0005P000<n00006@0001X000=>0000F0000hh0000a0003
SP0005P000=>00006@0001/000=>0000EP000ch0000c0003?P0005H000=>00006P0001/000>>0000
EP000dh0000c0003CP0005H000>>00006P0001/000=>0000E@000dh0000e0003CP0005@000<n0000
6`0001/000>>0000E@000hh0000e0003SP0005@000=>00006`0001`000<n0000D`000ch0000g0003
?P0005<000<n00006`0001d000>>0000DP000dh0000g0003CP00058000>>0000700001h000<n0000
D0000dh0000i0003CP00050000<n00007@0001h000=>0000D0000hh0000i0003SP00050000=>0000
7@0001l000=>0000CP000ch0000k0003?P0004h000=>00007P0001l000>>0000CP000dh0000k0003
CP0004h000>>00007P00020000<n0000C0000dh0000m0003CP0004`000<n00007`00020000=>0000
B`000dh0000o0003CP0004/000=>00007`00024000=>0000B@000dh000110003CP0004T000=>0000
8000028000=>0000B0000hh000110003SP0004P000=>00008@0002<000=>0000AP000ch000130003
?P0004H000=>00008P0002<000>>0000A@000hh000150003SP0004D000>>00008P0002@000<n0000
@`000ch000170003?P0004<000<n00008`0002D000>>0000@P000dh000170003CP00048000>>0000
900002H000<nCP00?`000ci>001:0003CSh003l000=>?P009P0002P000=>0000?0000hh0001=0003
SP0003`000=>00009`0002T000=>0000>P000ch0001?0003?P0003X000=>0000:00002X000=>SP00
=`000dj>001B0003STh003L000>>CP00:P0002`000<n0000=0000dh0001E0003CP0003@000<n0000
:`0002d000>>0000<P000dh0001G0003CP00038000>>0000;00002h000<nCP00;`000ci>001J0003
CSh002l000=>?P00;P00030000=>SP00:`000dj>001N0003STh002/000>>CP00<000038000<nCP00
9`000ci>001R0003CSh002L000=>?P00<P0003@000=>SP008`000dj>001V0003STh002<000>>CP00
=00003H000<nCP003@03C0l000<nCP00JP000dhn000>00=<3P000dhn000f0000>0000dj>000:00E<
30000dj>001^0003STj>00/01D`;0003STh003P0000j0005?ThnCSh01@07C0H000E>?ThnCP1d0004
?ThnCPH01d`50005?ThnCSh0>`0003l000F>CXi>SP07C006STj>CXi>O@001Tj>CXi>SPM<00F>CXi>
SP100000A002C0057W@NM4`0R@001Dad7W@N009<A@0004@000OC7m<OdaoC08P000LOdaoC7m<O04H0
001400037W@N009<00=d7P00Q`000g@NM002C0037W@004D0001300037m<O00<000<Odal0QP000m<O
d`030003daoC04D000130003M1h000@000<NM000Q@000aid00040003M1h004@0001300097m<Od`3C
7m<O08H000WC7m<O01oC7m<0A@0004@000LNM1id7W@N08P000Md7W@NM1id04H000160003daoC08`0
00<Odal0B00004D00on=00?oB00004H000?o0000S@000ol000170000AP000ol0002=0003o`0004L0
00160003o`0008d000?o0000A`0004H000?o0000S@000ol000170000A@02ohh00_m90000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.0500105, -0.0500105, 
  0.00731715, 0.00731715}, {{6.8125, 136.938}, {280.125, 
  150}} -> {-1.50794, -1.50925, 0.0209801, 0.0209801}, {{150, 280.125}, {
  280.125, 150}} -> {-4.51202, -1.50925, 0.0209801, 0.0209801}, {{6.8125, 
  136.938}, {136.938, 6.8125}} -> {-1.50794, -4.51334, 0.0209801, 
  0.0209801}, {{150, 280.125}, {136.938, 6.8125}} -> {-4.51202, -4.51334, 
  0.0209801, 0.0209801}},
  CellTags->"FourStandard"],

Cell[BoxData[
    \({True, True, True, True}\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "When a groupoid is not associative, the ",
  StyleBox["Textual", "MR"],
  " mode illustrates triples that do not obey this property."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AssociativeQ[G\_2, \ Mode\  \[Rule] \ Textual]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("Given a structured set S (Groupoid or Ringoid), we say the operation * \
is associative if for every g, h, and k in S we have (g*h)*k = g*(h*k), where \
* is the operation."\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("In this case, TheGroup is NOT associative since we have (\[Alpha]*\
\[Alpha])*\[Alpha] = \[Alpha], which is not equal to \[Beta] = \[Alpha]*(\
\[Alpha]*\[Alpha])!"\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \("Consider the following table illustrating triples that do not \
associate. Pay attention to the last two columns."\)], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"i\"\>", "\<\"j\"\>", "\<\"k\"\>", "\<\"(i*j)*k\"\>", 
            \("i*(j*k)\n"\)},
          {"\[Alpha]", "\[Alpha]", "\[Alpha]", "\[Alpha]", "\[Beta]"},
          {"\[Alpha]", "\[Alpha]", "\[Gamma]", "\[Beta]", "\[Alpha]"},
          {"\[Alpha]", "\[Gamma]", "\[Alpha]", "\[Alpha]", "\[Gamma]"},
          {"\[Alpha]", "\[Gamma]", "\[Gamma]", "\[Gamma]", "\[Alpha]"},
          {"\[Gamma]", "\[Alpha]", "\[Alpha]", "\[Gamma]", "\[Beta]"},
          {"\[Gamma]", "\[Alpha]", "\[Gamma]", "\[Beta]", "\[Gamma]"}
          },
        RowSpacings->0.5,
        ColumnSpacings->2,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0.5, 2}, TableDepth -> 2, 
        TableHeadings -> {None, {"i", "j", "k", "(i*j)*k", 
        "i*(j*k)\n"}}]&)]], "Print",
  CellTags->"FourStandard"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["AssociativeQ", "MR"],
  " chooses a triple of elements at random and illustrates how and whether \
the operation is associative with this triple."
}], "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AssociativeQ[U[8], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"FourStandard"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a * \\(b *  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a * b\\) * c)] .27778 .44444 0 0 Mshowa
.5 Mabswid
[ ] 0 setdash
.61111 .22222 m
.72222 .33333 L
s
.83333 .22222 m
.72222 .33333 L
s
.77778 .11111 m
.83333 .22222 L
s
.88889 .11111 m
.83333 .22222 L
s
.38889 .22222 m
.27778 .33333 L
s
.16667 .22222 m
.27778 .33333 L
s
.22222 .11111 m
.16667 .22222 L
s
.11111 .11111 m
.16667 .22222 L
s
.747 .885 .977 r
.61111 .22222 m
.61111 .22222 .04444 0 365.73 arc
F
.83333 .22222 m
.83333 .22222 .04444 0 365.73 arc
F
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.77778 .11111 m
.77778 .11111 .04444 0 365.73 arc
F
.88889 .11111 m
.88889 .11111 .04444 0 365.73 arc
F
.38889 .22222 m
.38889 .22222 .04444 0 365.73 arc
F
.16667 .22222 m
.16667 .22222 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
.22222 .11111 m
.22222 .11111 .04444 0 365.73 arc
F
.11111 .11111 m
.11111 .11111 .04444 0 365.73 arc
F
0 0 0 r
[(5)] .61111 .22222 0 0 Mshowa
[(*)] .83333 .22222 0 0 Mshowa
[(*)] .72222 .33333 0 0 Mshowa
[(7)] .77778 .11111 0 0 Mshowa
[(3)] .88889 .11111 0 0 Mshowa
[(3)] .38889 .22222 0 0 Mshowa
[(*)] .16667 .22222 0 0 Mshowa
[(*)] .27778 .33333 0 0 Mshowa
[(7)] .22222 .11111 0 0 Mshowa
[(5)] .11111 .11111 0 0 Mshowa
[(Elements a, b, and c chosen at random.)] .5 .05556 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0005/000?o0000
3`000ol0002`00007@05o`801Ol200Co00H0o`3o0?l200Co00@0ool00_l200?o0P04o`P01Ol20003
o`0000P01?l30003o`0000P01Ol0103oo`02o`801Ol700?o2@03o`800_l00`3oo`0200?o0P04o`<0
1?l0103oo`02o`L01Ol200?o2004o`801Ol0103oo`02o`801Ol0103oool20005o`3o0?l00P02ob40
000N0003o`0000D000Go0000o`050007o`3o0?l0o`050004o`00o`<000Co003o10000ol000060004
o`00o`@000?o00001`001Ol0003o00<000?o00001`001?l00?l20004o`00o`8000Go0000o`070005
o`000?l01`001ol0003o0?l00P001?l00?l30003o`00008000Co003o1@001?l00?l80004o`00o`<0
00Co003o20000ol000020004o`00o`8000Co003o0P001ol0003o0?l00`001ol0o`3o0?l00P02ob40
000N0003o`0000D000Co00001Ol01`3o0?l0o`001Ol01@3o003o00<000?o00000P04o`P01?l>0005
o`000?l03@04o`8000Co003o0P001Ol0003o00L000?o00002@000ol000030004o`00o`8000Ko0000
o`04o`801Ol01@3o003o00P01?l30003o`0000T000?o00000P04o`8000Co003o0P001ol0003o0?l0
0`001ol0o`3o0?l09@0001h00ol50005o`000?l00`002Ol0o`3o0?l0o`030003o`3o008000Go0000
o`040003o`0000`000?o000030001Ol0003o010000Co003o0P001?l00?l30003o`0000D000Go0000
o`070007o`000?l0o`020004o`00o`<000?o0?l01@001ol0003o0?l00P000ol000090005o`000?l0
2`02o`H000Co003o0P001?l00?l30003o`3o00<000Oo0?l0o`3o02D0000N0003o`0000D000?o0000
0P03o`030?oo00Co0P03o`030?oo00?o0P04o`801?l900?o3P04o`l00ol00`3oo`03o`<01?l800Co
2004o`030?oo00;o0`03o`801?l300?o00<0ool00ol900?o0P04o`P00_l00`3oo`0200?o00<0ool0
0ol300Co0P03o`030?oo00Co9@0001d01Ol40003o`0001X000?o000080000ol0000O0003o`0001L0
00?o0000:0000ol0000N0003o`0002l0000T00?o70000ol0000O00;o8002oaP00_lZ0003o`0001d0
0_la00006`002hH?QPn63hH?QPn601D000Z63hH?QPn63hH?U0002hH?QPn63hH?QPn601D000^63hH?
QPn63hH?QP0L00006@003`o?3ll?c`o?3ll?c`o?3`0A000>3ll?c`o?3ll?c`o?3lnA000>c`o?3ll?
c`o?3ll?c`lB000>c`o?3ll?c`o?3ll?c`lJ000060004@n63hH?QPn63hH?QPn63hH?00l0010?QPn6
3hH?QPn63hH?QPn6S`0048H?QPn63hH?QPn63hH?QPl@000@QPn63hH?QPn63hH?QPn63aT0000G000C
3ll?c`o?3ll?c`o?3ll?c`o?3`0=000B3ll?c`o?3ll?c`o?3ll?c`o?S@004/l?c`o?3ll?c`o?3ll?
c`o?3`h001;?3ll?c`o?3ll?c`o?3ll?c`lH00005`004hH?QPn63hH?QPn63hH?QPn63hH0300050n6
3hH?QPn63hH?QPn63hH?QPn6R`0058H?QPn63hH?QPn63hH?QPn63hH?30004hH?QPn63hH?QPn63hH?
QPn63hH0600001H001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll02P005Po?3ll?c`o?3ll?c`o?3ll?c`o?
3ln9000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3`X001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll05`0001D0
01J63hH?QPn63hH?QPn63hH?QPn63hH?2P005XH?QPn63hH?QPn63hH?QPn63hH?QPn9000F3hH?QPn6
3hH?QPn63hH?QPn63hH?QPX001D?QPn63hH?QPn63hH?QPn63hH?QPl05`0001@001S?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?c`l8000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?Q`0060o?3ll?c`o?3ll?c`o?
3ll?c`o?3ll?c`P001L?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3`0F0000500060n63hH?QPn63hH?QPn6
3hH?QPn63hH?QPP001P?QPn63hH?QPn63hH?QPn63hH?QPn63hJ7000HQPn63hH?QPn63hH?QPn63hH?
QPn63hH?20005hH?QPn63hH?QPn63hH?QPn63hH?QPn601H0000C000;3ll?c`o?3ll?c`l00ol02`o?
3ll?c`o?3ll?00L001T?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll?08H001W?3ll?c`o?3ll?coo?3ll?
c`o?3ll?c`o?00L000[?3ll?c`o?3ll?0ol02`o?3ll?c`o?3ll?01H0000C000IQPn63hH?QPn63hH?
QPoo3hH?QPn63hH?QP07000IQPn63hH?QPn63hH?o`n63hH?QPn63hH?QP26000I3hH?QPn63hH?QPoo
3hH?QPn63hH?QPn63`07000I3hH?QPn63hH?QPn63ol?QPn63hH?QPn63`0E00004`006@o?3ll?c`o?
3ll?c`o?oll?c`o?3ll?c`l01`006@o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`l0QP006Ll?c`o?3ll?
c`o?3ol?c`o?3ll?c`o?3ll01`006Ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll05@0001<000^63hH?
QPn63hH?QP03o`0;QPn63hH?QPn63hH01`006HH?QPn63hH?QPn63hKoQPn63hH?QPn63hH0QP006@n6
3hH?QPn63hH?Q_n63hH?QPn63hH?QPl01`002`n63hH?QPn63hH?00;o00b63hH?QPn63hH?QPlE0000
4`006@o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?c`l01`006@o?3ll?c`o?3ll?c`o?oll?c`o?3ll?c`l0
QP006Ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll01`006Ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll0
5@0001<000^63hH?QPn63hH?QP04o`0:3hH?QPn63hH?QPL000^63hH?QPn63hH?QP04o`0:3hH?QPn6
3hH?QXH000X?QPn63hH?QPn61?l02`n63hH?QPn63hH?00L000X?QPn63hH?QPn60ol038H?QPn63hH?
QPn63aD0000D000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?20006<l?c`o?3ll?c`o?3ll?c`o?3ll?
c`o?3hL001P?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll7000Ic`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?
c`0E0000500060n63hH?QPn63hH?QPn63hH?QPn63hH?QPP001P?QPn63hH?QPn63hH?QPn63hH?QPn6
3hJ7000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?1`006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl0
5@0001@001O?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`09000Gc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll0
R0005`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?00P001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`lF0000
5@005XH?QPn63hH?QPn63hH?QPn63hH?QPl:000FQPn63hH?QPn63hH?QPn63hH?QPn63hT001H?QPn6
3hH?QPn63hH?QPn63hH?QPn62@005hH?QPn63hH?QPn63hH?QPn63hH?QPn601H0000E000E3ll?c`o?
3ll?c`o?3ll?c`o?3ll?00/001D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0RP005Ll?c`o?3ll?c`o?3ll?
c`o?3ll?c`0;000Ec`o?3ll?c`o?3ll?c`o?3ll?c`o?01L0000F000D3hH?QPn63hH?QPn63hH?QPn6
3hH<000C3hH?QPn63hH?QPn63hH?QPn63`2<000CQPn63hH?QPn63hH?QPn63hH?QP0=000CQPn63hH?
QPn63hH?QPn63hH?QP0H00005`004Po?3ll?c`o?3ll?c`o?3ll?c`h0014?c`o?3ll?c`o?3ll?c`o?
3`2>000Ac`o?3ll?c`o?3ll?c`o?3ll03`004Ll?c`o?3ll?c`o?3ll?c`o?01T0000H000@3hH?QPn6
3hH?QPn63hH?QQ0000l?QPn63hH?QPn63hH?QPl0T0003hH?QPn63hH?QPn63hH?QP0A000?QPn63hH?
QPn63hH?QPn601X0000K000<3ll?c`o?3ll?c`oo4`002ll?c`o?3ll?c`o?09@000`?c`o?3ll?c`o?
3olC000<o`o?3ll?c`o?3ll?700001d000J63hH?QPl30003o`00014000Wo00263hH?QPl0V@001Pn6
3hH?QP8000?o00004@002_l008H?QPn63hHN00009`000ol0000?0003o`000:T000?o00003`000ol0
000V00009`000ol0000?0003o`000:T000?o00003`000ol0000V0000:0000ol0000=0003o`000:/0
00?o00003@000ol0000W0000:0000ol0000=0003o`000:/000?o00003@000ol0000W0000:@000ol0
000;0003o`000:d000?o00002`000ol0000X0000:@000ol0000;0003o`000:d000?o00002`000ol0
000X0000:P002Ol000o?3ll?c`030003o`0003@000H?c`o?3lli0006c`o?3ll?=P002_l0003?3ll?
c`l20003o`0002T0000Z000=ohH?QPn63hH?QPl0o`0c000;3hH?QPn63hH?QPl0=@002`n63hH?QPn6
3hH?03<000goQPn63hH?QPn63hKo02/0000Y000?3ll?c`o?3ll?c`o?3ll?034000h?c`o?3ll?c`o?
3ll?cc4000o?3ll?c`o?3ll?c`o?3ll0<@003/l?c`o?3ll?c`o?3ll?:P0002P0010?QPn63hH?QPn6
3hH?QPn6<00040n63hH?QPn63hH?QPn63hH_000AQPn63hH?QPn63hH?QPn63hH0;`0048H?QPn63hH?
QPn63hH?QPlY00009`004Po?3ll?c`o?3ll?c`o?3ll?cbd001??3ll?c`o?3ll?c`o?3ll?c`o?02d0
01??3ll?c`o?3ll?c`o?3ll?c`o?02`001<?c`o?3ll?c`o?3ll?c`o?3ll?02P0000V000D3hH?QPn6
3hH?QPn63hH?QPn63hH[000DQPn63hH?QPn63hH?QPn63hH?QPl/000DQPn63hH?QPn63hH?QPn63hH?
QPl[000D3hH?QPn63hH?QPn63hH?QPn63hHX00009P005Ll?c`o?3ll?c`o?3ll?c`o?3ll?c`0Z000E
3ll?c`o?3ll?c`o?3ll?c`o?3ll?02/001D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0:P005Ll?c`o?3ll?
c`o?3ll?c`o?3ll?c`0W00009@005XH?QPn63hH?QPn63hH?QPn63hH?QPlY000F3hH?QPn63hH?QPn6
3hH?QPn63hH?QRX001H?QPn63hH?QPn63hH?QPn63hH?QPn6:@005XH?QPn63hH?QPn63hH?QPn63hH?
QPlW000090006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3bP001O?3ll?c`o?3ll?c`o?3ll?c`o?3ll?
c`0X000H3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?:0005`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?02H0
000T000H3hH?QPn63hH?QPn63hH?QPn63hH?QPn6:0005`n63hH?QPn63hH?QPn63hH?QPn63hH?02P0
01R63hH?QPn63hH?QPn63hH?QPn63hH?QPlX000GQPn63hH?QPn63hH?QPn63hH?QPn63hH09P0002<0
01T?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?02L000X?c`o?3ll?c`o?0ol03<l?c`o?3ll?c`o?3bH0
00_?3ll?c`o?3ll?c`03o`0;c`o?3ll?c`o?3ll09`006Ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll0
9@0002<001V63hH?QPn63hH?QPn63hH?QPn63hH?QPn602L001V63hH?QPn63hH?QPn6ohH?QPn63hH?
QPn602H001T?QPn63hH?QPn63hH?Q_n63hH?QPn63hH?02L001T?QPn63hH?QPn63hH?QPn63hH?QPn6
3hH?02D0000S000I3ll?c`o?3ll?c`o?olooc`o?3ll?c`o?3`0W000I3ll?c`o?3ll?c`o?3ol?c`o?
3ll?c`o?3`0V000Ic`o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`0W000Ic`o?3ll?c`o?3loocoo?3ll?
c`o?3ll?c`0U00008`006HH?QPn63hH?QPn63hKoQPn63hH?QPn63hH09`002hH?QPn63hH?QPn600;o
00`?QPn63hH?QPn63hHV000;3hH?QPn63hH?QPl00ol02`n63hH?QPn63hH?02L001T?QPn63hH?QPn6
3hKoQPn63hH?QPn63hH?02D0000S000;3ll?c`o?3ll?c`l01Ol02@o?3ll?c`o?3`0W000I3ll?c`o?
3ll?c`o?3ol?c`o?3ll?c`o?3`0V000Ic`o?3ll?c`o?3looc`o?3ll?c`o?3ll?c`0W000:c`o?3ll?
c`o?3`Go00X?c`o?3ll?c`o?9@0002<001V63hH?QPn63hH?QPn6ohH?QPn63hH?QPn602L000Z63hH?
QPn63hH?0ol030n63hH?QPn63hH?QRH000/?QPn63hH?QPn63`04o`0:QPn63hH?QPn63bL001T?QPn6
3hH?QPn63hKoQPn63hH?QPn63hH?02D0000T000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?9`006@o?
3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`l09`0060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cbL001W?3ll?
c`o?3ll?c`o?3ll?c`o?3ll?c`o?02D0000T000H3hH?QPn63hH?QPn63hH?QPn63hH?QPn69`006HH?
QPn63hH?QPn63hH?QPn63hH?QPn63hH09`0068H?QPn63hH?QPn63hH?QPn63hH?QPn63bL001T?QPn6
3hH?QPn63hH?QPn63hH?QPn63hH?02D0000U000F3ll?c`o?3ll?c`o?3ll?c`o?3ll?cbT001O?3ll?
c`o?3ll?c`o?3ll?c`o?3ll?c`0Y000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3bT001L?c`o?3ll?c`o?
3ll?c`o?3ll?c`o?3`0V00009@005XH?QPn63hH?QPn63hH?QPn63hH?QPlY000G3hH?QPn63hH?QPn6
3hH?QPn63hH?QPl0:@005Pn63hH?QPn63hH?QPn63hH?QPn63hHY000GQPn63hH?QPn63hH?QPn63hH?
QPn63hH09P0002D001D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0:`005@o?3ll?c`o?3ll?c`o?3ll?c`o?
3`0Z000Ec`o?3ll?c`o?3ll?c`o?3ll?c`o?02/001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll09`0002H0
01@?QPn63hH?QPn63hH?QPn63hH?QR`001<?QPn63hH?QPn63hH?QPn63hH?02`001B63hH?QPn63hH?
QPn63hH?QPn63b`001>63hH?QPn63hH?QPn63hH?QPn602P0000X000Bc`o?3ll?c`o?3ll?c`o?3loo
:`004ol00<l?c`o?3ll?c`o?3ll?c`l0;`004`o?3ll?c`o?3ll?c`o?3ll?0?l0:`004_l03ll?c`o?
3ll?c`o?3ll?cbT0000Y000?QPn63hH?QPn63hH?QPn6008000?o00009`000ol00002000>QPn63hH?
QPn63hH?QPlb000>QPn63hH?QPn63hH?QPl30003o`0002L001;o00003hH?QPn63hH?QPn63hHZ0000
:P003<l?c`o?3ll?c`o?3`D000?o00009@000ol00004000;c`o?3ll?c`o?3ll0=@002ll?c`o?3ll?
c`o?00H000?o00009@000ol00003000;3ll?c`o?3ll?c`l0;00002l000B63hH?2@000ol0000S0003
o`0000X000B63hH?>`0010n63hH:0003o`0002<000?o00002@0010n63hH^0000?@000ol0000Q0003
o`0005T000?o00008@000ol0000l0000?P000ol0000O0003o`0005/000?o00007`000ol0000m0000
?`000ol0000M0003o`0005d000?o00007@000ol0000n0000@0000ol0000K0003o`0005l000?o0000
6`000ol0000o0000@@000ol0000I0003o`00064000?o00006@000ol000100000@P000ol0000G0003
o`0006<000?o00005`000ol000110000@`000ol0000700063ll?c`o?20000ol0001U0003o`0000H0
00K?3ll?c`l90003o`00048000140003o`0000<000/?QPn63hH?QPn63`050003o`0006L000?o0000
0`002Pn63hH?QPn63hH60003o`0004<00015000Bo`00c`o?3ll?c`o?3ll?c`o?0P000ol0001Y000A
o`0?c`o?3ll?c`o?3ll?c`l00`000ol000140000AP004on63hH?QPn63hH?QPn63hH?Q_l0K@004`n6
3hH?QPn63hH?QPn63hH?0?l0A`0004H001??3ll?c`o?3ll?c`o?3ll?c`o?06`001<?c`o?3ll?c`o?
3ll?c`o?3ll?04P00015000EQPn63hH?QPn63hH?QPn63hH?QPn606X001D?QPn63hH?QPn63hH?QPn6
3hH?QPl0A`0004D001H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?J@005/l?c`o?3ll?c`o?3ll?c`o?3ll?
c`m60000A0005`n63hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?QPn63hH?QPn63hH?
QP160000A0006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?3ll?c`o?3ll?c`o?
3lm50000@`006HH?QPn63hH?QPn63hH?QPn63hH?QPn63hH0IP006@n63hH?QPn63hH?QPn63hH?QPn6
3hH?QPl0A@0004<001T?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?06H001W?3ll?c`o?3ll?c`o?3ll?
c`o?3ll?c`o?04D00013000IQPn63hH?QPn63hH?QPn63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn6
3hH?QPn63hH?QPn63`150000@`006@o?3ll?c`o?3ll?o`oo3ll?c`o?3ll?c`l0IP006Ll?c`o?3ll?
c`o?3ol?o`o?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?QPoo3hH?QPn63hH?QPn606H001T?QPn6
3hH?QPn63hH?o`n63hH?QPn63hH?04D00013000:3ll?c`o?3ll?c`Go00[?3ll?c`o?3ll?IP002ll?
c`o?3ll?c`o?00Go00W?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?QPoo3hH?QPn63hH?QPn606H0
01T?QPn63hH?QPn63hH?o`n63hH?QPn63hH?04D00014000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?
I`0060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cdD00014000G3hH?QPn63hH?QPn63hH?QPn63hH?QPl0
J0005hH?QPn63hH?QPn63hH?QPn63hH?QPn604H00015000F3ll?c`o?3ll?c`o?3ll?c`o?3ll?cfT0
01K?3ll?c`o?3ll?c`o?3ll?c`o?3ll?AP0004D001J63hH?QPn63hH?QPn63hH?QPn63hH?J@005Pn6
3hH?QPn63hH?QPn63hH?QPn63hI60000AP005<l?c`o?3ll?c`o?3ll?c`o?3ll?J`0050o?3ll?c`o?
3ll?c`o?3ll?c`o?A`0004L001:63hH?QPn63hH?QPn63hH?QPm]000B3hH?QPn63hH?QPn63hH?QPn6
B00004P0013?3ll?c`o?3ll?c`o?3ll?K`0040o?3ll?c`o?3ll?c`o?3lm90000BP003@n63hH?QPn6
3hH?QPl0LP003HH?QPn63hH?QPn63hH0BP0004d000P?c`o?3ll?cgL000S?3ll?c`o?3d`0001?0003
QPl007`000<?QP00C`000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@00034000?o000080000ol0001_0003
o`0002H000?o0000;P00030000?o00008P000ol0001]0003o`0002P000?o0000;@00030000?o0000
0P05oa<01?l40003o`0001@00olm00Go50000ol0000200Co6`03o`@000?o0000;@00030000?o0000
0P001?l00?lD0005o`000?l00`000ol0000C0005o`000?l0?0001?l00?lE0003o`00008000Go0000
o`0I0005o`000?l00`000ol0000]0000<0000ol0000200Co2@000ol0o`080005o`000?l00`000ol0
00080003o`3o00P000?o0000?P04o`T000?o0?l02@000ol000020005o`000?l020000ol0o`0>0003
o`0000D000?o0000;@00030000?o00001@000ol000080003o`0000L000Go0000o`030003o`0000T0
00?o00001`001Ol0003o03l000?o000020000ol000080003o`00008000Go0000o`090003o`0000d0
00Go0000o`030003o`0002d0000`0003o`0000<00ol800Go1`04o`@000?o00001`05o`P01?lm00?o
2005o`P000?o00000P04o`P01Ol>00Co0`000ol0000]0000<@000ol0000?0003o`0000L000?o0000
10000ol0000:0003o`0005H000?o00002@001Ol0003o00d000?o000050000ol0000^0000C002og/0
0_mE0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a * \\(b *  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a * b\\) * c)] .27778 .44444 0 0 Mshowa
.5 Mabswid
[ ] 0 setdash
.61111 .22222 m
.72222 .33333 L
s
.83333 .22222 m
.72222 .33333 L
s
.38889 .22222 m
.27778 .33333 L
s
.16667 .22222 m
.27778 .33333 L
s
.747 .885 .977 r
.61111 .22222 m
.61111 .22222 .04444 0 365.73 arc
F
.83333 .22222 m
.83333 .22222 .04444 0 365.73 arc
F
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.38889 .22222 m
.38889 .22222 .04444 0 365.73 arc
F
.16667 .22222 m
.16667 .22222 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(5)] .61111 .22222 0 0 Mshowa
[(7*3)] .83333 .22222 0 0 Mshowa
[(*)] .72222 .33333 0 0 Mshowa
[(3)] .38889 .22222 0 0 Mshowa
[(5*7)] .16667 .22222 0 0 Mshowa
[(*)] .27778 .33333 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0002d000H?c`o?3llj0006
3ll?c`o?>@001/l?c`o?3cX000K?3ll?c`l^0000:`002XH?QPn63hH?QPle000;3hH?QPn63hH?QPl0
=@002`n63hH?QPn63hH?03@000^63hH?QPn63hH?QP0/0000:@003`o?3ll?c`o?3ll?c`o?3`0a000>
3ll?c`o?3ll?c`o?3lla000?c`o?3ll?c`o?3ll?c`o?034000k?3ll?c`o?3ll?c`o?3bX0000X000@
3hH?QPn63hH?QPn63hH?QS00010?QPn63hH?QPn63hH?QPn6;`004HH?QPn63hH?QPn63hH?QPn602l0
01263hH?QPn63hH?QPn63hH?:@0002L0018?c`o?3ll?c`o?3ll?c`o?3ll]000Cc`o?3ll?c`o?3ll?
c`o?3ll?c`0]000Cc`o?3ll?c`o?3ll?c`o?3ll?c`0/000C3ll?c`o?3ll?c`o?3ll?c`o?3`0X0000
9P0050n63hH?QPn63hH?QPn63hH?QPn6:`0058H?QPn63hH?QPn63hH?QPn63hH?;00058H?QPn63hH?
QPn63hH?QPn63hH?:`0050n63hH?QPn63hH?QPn63hH?QPn6:00002H001G?3ll?c`o?3ll?c`o?3ll?
c`o?3ll0:P005@o?3ll?c`o?3ll?c`o?3ll?c`o?3`0[000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02X0
01G?3ll?c`o?3ll?c`o?3ll?c`o?3ll09`0002D001J63hH?QPn63hH?QPn63hH?QPn63hH?:@005Pn6
3hH?QPn63hH?QPn63hH?QPn63hHZ000F3hH?QPn63hH?QPn63hH?QPn63hH?QRT001J63hH?QPn63hH?
QPn63hH?QPn63hH?9`0002@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`lX000Gc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll0:00060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cbP001L?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3`0V0000900060n63hH?QPn63hH?QPn63hH?QPn63hH?QRP001L?QPn63hH?QPn63hH?QPn6
3hH?QPn63`0X000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?:0005hH?QPn63hH?QPn63hH?QPn63hH?
QPn602H0000S00053ll?c`l00ol04@o?3ll?c`o?3looc`o?3ll?02L000X?c`o?3ll?c`o?0ol03<l?
c`o?3ll?c`o?3bH000_?3ll?c`o?3ll?c`03o`0;c`o?3ll?c`o?3ll09`004<l?c`o?oll?c`o?3ll?
c`l3o`063ll?c`o?9@0002<001V63hH?QPn63ol?QPn63hH?QPoo3hH?QPn602L001V63hH?QPn63hH?
QPn6ohH?QPn63hH?QPn602H001T?QPn63hH?QPn63hH?Q_n63hH?QPn63hH?02L001T?QPn63ol?QPn6
3hH?QPn63hH?o`n63hH?02D0000S000I3ll?c`o?3looc`o?olooc`o?3ol?c`o?3`0W000I3ll?c`o?
3ll?c`o?3ol?c`o?3ll?c`o?3`0V000Ic`o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`0W000Ic`o?3ll?
o`o?3loocoo?3ll?coo?3ll?c`0U00008`001HH?QPn600?o01663hH?Q_n63hH?Q_n63hH?QP0W000;
QPn63hH?QPn63hH00_l030n63hH?QPn63hH?QRH000/?QPn63hH?QPn63`03o`0;3hH?QPn63hH?QPl0
9`004@n63hH?Q_n63hH?Q_n63hH?00;o00J63hH?QPlU00008`002`o?3ll?o`o?3ll?00Go00T?c`o?
oll?c`l09`006@o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`l09P006Ll?c`o?3ll?c`o?oll?c`o?3ll?
c`o?3ll09`002/l?c`o?3looc`l5o`0:3ll?coo?3ll?cbD0000S0005QPn63hH01?l020n63hKoQPn6
1?l010n63hHW000:QPn63hH?QPn63`?o00`?QPn63hH?QPn63hHV000;3hH?QPn63hH?QPl01?l02XH?
QPn63hH?QPlW00043hH?QPCo00P?QPn6ohH?QP?o00J63hH?QPlU000090006<l?c`o?3ll?c`o?3ll?
c`o?3ll?c`o?3bL001T?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?02L001P?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3llW000Ic`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`0U0000900060n63hH?QPn63hH?QPn6
3hH?QPn63hH?QRL001V63hH?QPn63hH?QPn63hH?QPn63hH?QPn602L001R63hH?QPn63hH?QPn63hH?
QPn63hH?QPlW000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`0U00009@005Po?3ll?c`o?3ll?c`o?
3ll?c`o?3llY000Gc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll0:@005/l?c`o?3ll?c`o?3ll?c`o?3ll?
c`lY000G3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`l09P0002D001J63hH?QPn63hH?QPn63hH?QPn63hH?
:@005`n63hH?QPn63hH?QPn63hH?QPn63hH?02T001H?QPn63hH?QPn63hH?QPn63hH?QPn6:@005hH?
QPn63hH?QPn63hH?QPn63hH?QPn602H0000U000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02/001D?c`o?
3ll?c`o?3ll?c`o?3ll?c`l0:P005Ll?c`o?3ll?c`o?3ll?c`o?3ll?c`0[000Ec`o?3ll?c`o?3ll?
c`o?3ll?c`o?02L0000V000D3hH?QPn63hH?QPn63hH?QPn63hH/000C3hH?QPn63hH?QPn63hH?QPn6
3`0/000DQPn63hH?QPn63hH?QPn63hH?QPl/000CQPn63hH?QPn63hH?QPn63hH?QP0X0000:0004/l?
c`o?3ll?c`o?3ll?c`o?ob/001?o003?3ll?c`o?3ll?c`o?3ll?02l001<?c`o?3ll?c`o?3ll?c`o?
3`3o02/001;o00o?3ll?c`o?3ll?c`o?3llY0000:@003hH?QPn63hH?QPn63hH?QP020003o`0002L0
00?o00000P003XH?QPn63hH?QPn63hH?<P003XH?QPn63hH?QPn63hH?0`000ol0000W000Bo`0000n6
3hH?QPn63hH?QPn6:P0002X000c?3ll?c`o?3ll?c`l50003o`0002D000?o000010002ll?c`o?3ll?
c`o?03D000_?3ll?c`o?3ll?c`060003o`0002D000?o00000`002`o?3ll?c`o?3ll?02`0000_0004
QPn63`T000?o00008`000ol0000:0004QPn63c/000@?QPn62P000ol0000S0003o`0000T000@?QPn6
;P0003d000?o00008@000ol0001I0003o`00024000?o0000?00003h000?o00007`000ol0001K0003
o`0001l000?o0000?@0003l000?o00007@000ol0001M0003o`0001d000?o0000?P00040000?o0000
6`000ol0001O0003o`0001/000?o0000?`00044000?o00006@000ol0001Q0003o`0001T000?o0000
@000048000?o00005`000ol0001S0003o`0001L000?o0000@@0004<000?o00001`001Po?3ll?c`P0
00?o0000I@000ol000060006c`o?3ll?2@000ol000120000A0000ol00003000;3hH?QPn63hH?QPl0
1@000ol0001W0003o`0000<000X?QPn63hH?QPn61P000ol000130000A@004_l00<l?c`o?3ll?c`o?
3ll?c`8000?o0000J@004Ol03ll?c`o?3ll?c`o?3ll?00<000?o0000A00004H001?oQPn63hH?QPn6
3hH?QPn63hKo06d001<?QPn63hH?QPn63hH?QPn63`3o04L00016000Cc`o?3ll?c`o?3ll?c`o?3ll?
c`1/000C3ll?c`o?3ll?c`o?3ll?c`o?3`180000A@005HH?QPn63hH?QPn63hH?QPn63hH?QP1Z000E
3hH?QPn63hH?QPn63hH?QPn63hH?04L00015000F3ll?c`o?3ll?c`o?3ll?c`o?3ll?cfT001K?3ll?
c`o?3ll?c`o?3ll?c`o?3ll?AP0004@001L?QPn63hH?QPn63hH?QPn63hH?QPn63`1X000GQPn63hH?
QPn63hH?QPn63hH?QPn63hH0AP0004@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`mW000H3ll?c`o?
3ll?c`o?3ll?c`o?3ll?c`o?A@0004<001V63hH?QPn63hH?QPn63hH?QPn63hH?QPn606H001T?QPn6
3hH?QPn63hH?QPn63hH?QPn63hH?04D00013000I3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3`1V000I
c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`150000@`006HH?QPn63hH?QPn63hH?QPn63hH?QPn63hH0
IP006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl0A@0004<001T?c`o?3ll?c`o?3ol?o`o?3ll?c`o?
3ll?06H001W?3ll?c`o?3ll?c`oo3ol?c`o?3ll?c`o?04D00013000IQPn63hH?QPn63hH?o`n63hH?
QPn63hH?QP1V000I3hH?QPn63hH?QPn63ol?QPn63hH?QPn63`150000@`002Po?3ll?c`o?3ll5o`0:
c`o?3ll?c`o?3fH000_?3ll?c`o?3ll?c`05o`09c`o?3ll?c`o?04D00013000IQPn63hH?QPn63hH?
o`n63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn63ol?QPn63hH?QPn63`150000A0006<l?c`o?3ll?
c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3lm50000A0005`n63hH?QPn6
3hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?QPn63hH?QPn63hH?QP160000A@005Po?3ll?c`o?
3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3dH00015000FQPn63hH?QPn63hH?
QPn63hH?QPn63fT001H?QPn63hH?QPn63hH?QPn63hH?QPn6AP0004H001C?3ll?c`o?3ll?c`o?3ll?
c`o?3f/001@?c`o?3ll?c`o?3ll?c`o?3ll?cdL00017000BQPn63hH?QPn63hH?QPn63hH?K@004Pn6
3hH?QPn63hH?QPn63hH?QTP00018000@c`o?3ll?c`o?3ll?c`o?3fl0010?c`o?3ll?c`o?3ll?c`o?
B@0004X000d?QPn63hH?QPn63hH?078000f63hH?QPn63hH?QPn604X0001=00083ll?c`o?3lmg0008
c`o?3ll?c`m<0000C`000hH?001l00033hH004l0003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240000a0003
o`00020000?o0000K`000ol0000V0003o`0002h0000`0003o`00028000?o0000K@000ol0000X0003
o`0002d0000`0003o`0000801OlC00Co10000ol0000D00?o?@05oa@000?o00000P04oa/00ol40003
o`0002d0000`0003o`00008000Co003o50001Ol0003o00<000?o00004`001Ol0003o03`000Co003o
5@000ol000020005o`000?l06@001Ol0003o00<000?o0000;@00030000?o00000P04o`T000?o0?l0
20001Ol0003o00<000?o000020000ol0o`080003o`0003h01?l90003o`3o00T000?o00000P001Ol0
003o00P000?o0?l03P000ol000050003o`0002d0000`0003o`0000D000?o000020000ol000070005
o`000?l00`000ol000090003o`0000L000Go0000o`0o0003o`0000P000?o000020000ol000020005
o`000?l02@000ol0000=0005o`000?l00`000ol0000]0000<0000ol0000300?o2005o`L01?l40003
o`0000L01Ol800Co?@03o`P01Ol80003o`0000801?l800Go3P04o`<000?o0000;@00034000?o0000
3`000ol000070003o`0000@000?o00002P000ol0001F0003o`0000T000Go0000o`0=0003o`0001@0
00?o0000;P0004`00_mk00;oE@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a * \\(b *  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a * b\\) * c)] .27778 .44444 0 0 Mshowa
.5 Mabswid
[ ] 0 setdash
.61111 .22222 m
.72222 .33333 L
s
.83333 .22222 m
.72222 .33333 L
s
.38889 .22222 m
.27778 .33333 L
s
.16667 .22222 m
.27778 .33333 L
s
.747 .885 .977 r
.61111 .22222 m
.61111 .22222 .04444 0 365.73 arc
F
.83333 .22222 m
.83333 .22222 .04444 0 365.73 arc
F
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.38889 .22222 m
.38889 .22222 .04444 0 365.73 arc
F
.16667 .22222 m
.16667 .22222 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(5)] .61111 .22222 0 0 Mshowa
[(5)] .83333 .22222 0 0 Mshowa
[(*)] .72222 .33333 0 0 Mshowa
[(3)] .38889 .22222 0 0 Mshowa
[(3)] .16667 .22222 0 0 Mshowa
[(*)] .27778 .33333 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0002d000H?c`o?3llj0006
3ll?c`o?>@001/l?c`o?3cX000K?3ll?c`l^0000:`002XH?QPn63hH?QPle000;3hH?QPn63hH?QPl0
=@002`n63hH?QPn63hH?03@000^63hH?QPn63hH?QP0/0000:@003`o?3ll?c`o?3ll?c`o?3`0a000>
3ll?c`o?3ll?c`o?3lla000?c`o?3ll?c`o?3ll?c`o?034000k?3ll?c`o?3ll?c`o?3bX0000X000@
3hH?QPn63hH?QPn63hH?QS00010?QPn63hH?QPn63hH?QPn6;`004HH?QPn63hH?QPn63hH?QPn602l0
01263hH?QPn63hH?QPn63hH?:@0002L0018?c`o?3ll?c`o?3ll?c`o?3ll]000Cc`o?3ll?c`o?3ll?
c`o?3ll?c`0]000Cc`o?3ll?c`o?3ll?c`o?3ll?c`0/000C3ll?c`o?3ll?c`o?3ll?c`o?3`0X0000
9P0050n63hH?QPn63hH?QPn63hH?QPn6:`0058H?QPn63hH?QPn63hH?QPn63hH?;00058H?QPn63hH?
QPn63hH?QPn63hH?:`0050n63hH?QPn63hH?QPn63hH?QPn6:00002H001G?3ll?c`o?3ll?c`o?3ll?
c`o?3ll0:P005@o?3ll?c`o?3ll?c`o?3ll?c`o?3`0[000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02X0
01G?3ll?c`o?3ll?c`o?3ll?c`o?3ll09`0002D001J63hH?QPn63hH?QPn63hH?QPn63hH?:@005Pn6
3hH?QPn63hH?QPn63hH?QPn63hHZ000F3hH?QPn63hH?QPn63hH?QPn63hH?QRT001J63hH?QPn63hH?
QPn63hH?QPn63hH?9`0002@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`lX000Gc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll0:00060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cbP001L?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3`0V0000900060n63hH?QPn63hH?QPn63hH?QPn63hH?QRP001L?QPn63hH?QPn63hH?QPn6
3hH?QPn63`0X000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?:0005hH?QPn63hH?QPn63hH?QPn63hH?
QPn602H0000S000;3ll?c`o?3ll?c`l00ol02`o?3ll?c`o?3ll?02L000X?c`o?3ll?c`o?0ol03<l?
c`o?3ll?c`o?3bH000_?3ll?c`o?3ll?c`03o`0;c`o?3ll?c`o?3ll09`002/l?c`o?3ll?c`l3o`0<
3ll?c`o?3ll?c`o?9@0002<001V63hH?QPn63hH?QPn63ol?QPn63hH?QPn602L001V63hH?QPn63hH?
QPn6ohH?QPn63hH?QPn602H001T?QPn63hH?QPn63hH?Q_n63hH?QPn63hH?02L001T?QPn63hH?QPn6
3hH?o`n63hH?QPn63hH?02D0000S000I3ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3`0W000I3ll?c`o?
3ll?c`o?3ol?c`o?3ll?c`o?3`0V000Ic`o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`0W000Ic`o?3ll?
c`o?3ll?coo?3ll?c`o?3ll?c`0U00008`0038H?QPn63hH?QPn63`;o00^63hH?QPn63hH?QP0W000;
QPn63hH?QPn63hH00_l030n63hH?QPn63hH?QRH000/?QPn63hH?QPn63`03o`0;3hH?QPn63hH?QPl0
9`002Pn63hH?QPn63hH3o`0<QPn63hH?QPn63hH?9@0002<001T?c`o?3ll?c`o?3ll?coo?3ll?c`o?
3ll?02L001T?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?02H001W?3ll?c`o?3ll?coo?3ll?c`o?3ll?
c`o?02L001W?3ll?c`o?3ll?o`o?3ll?c`o?3ll?c`o?02D0000S000;QPn63hH?QPn63hH00ol02hH?
QPn63hH?QPn602L000Z63hH?QPn63hH?0ol030n63hH?QPn63hH?QRH000/?QPn63hH?QPn63`04o`0:
QPn63hH?QPn63bL000X?QPn63hH?QPn61?l02`n63hH?QPn63hH?02D0000T000Hc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?9`006@o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`l09`0060o?3ll?c`o?3ll?c`o?
3ll?c`o?3ll?cbL001W?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?02D0000T000H3hH?QPn63hH?QPn6
3hH?QPn63hH?QPn69`006HH?QPn63hH?QPn63hH?QPn63hH?QPn63hH09`0068H?QPn63hH?QPn63hH?
QPn63hH?QPn63bL001T?QPn63hH?QPn63hH?QPn63hH?QPn63hH?02D0000U000F3ll?c`o?3ll?c`o?
3ll?c`o?3ll?cbT001O?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`0Y000Fc`o?3ll?c`o?3ll?c`o?3ll?
c`o?3bT001L?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3`0V00009@005XH?QPn63hH?QPn63hH?QPn63hH?
QPlY000G3hH?QPn63hH?QPn63hH?QPn63hH?QPl0:@005Pn63hH?QPn63hH?QPn63hH?QPn63hHY000G
QPn63hH?QPn63hH?QPn63hH?QPn63hH09P0002D001D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0:`005@o?
3ll?c`o?3ll?c`o?3ll?c`o?3`0Z000Ec`o?3ll?c`o?3ll?c`o?3ll?c`o?02/001G?3ll?c`o?3ll?
c`o?3ll?c`o?3ll09`0002H001@?QPn63hH?QPn63hH?QPn63hH?QR`001<?QPn63hH?QPn63hH?QPn6
3hH?02`001B63hH?QPn63hH?QPn63hH?QPn63b`001>63hH?QPn63hH?QPn63hH?QPn602P0000X000B
c`o?3ll?c`o?3ll?c`o?3loo:`004ol00<l?c`o?3ll?c`o?3ll?c`l0;`004`o?3ll?c`o?3ll?c`o?
3ll?0?l0:`004_l03ll?c`o?3ll?c`o?3ll?cbT0000Y000?QPn63hH?QPn63hH?QPn6008000?o0000
9`000ol00002000>QPn63hH?QPn63hH?QPlb000>QPn63hH?QPn63hH?QPl30003o`0002L001;o0000
3hH?QPn63hH?QPn63hHZ0000:P003<l?c`o?3ll?c`o?3`D000?o00009@000ol00004000;c`o?3ll?
c`o?3ll0=@002ll?c`o?3ll?c`o?00H000?o00009@000ol00003000;3ll?c`o?3ll?c`l0;00002l0
00B63hH?2@000ol0000S0003o`0000X000B63hH?>`0010n63hH:0003o`0002<000?o00002@0010n6
3hH^0000?@000ol0000Q0003o`0005T000?o00008@000ol0000l0000?P000ol0000O0003o`0005/0
00?o00007`000ol0000m0000?`000ol0000M0003o`0005d000?o00007@000ol0000n0000@0000ol0
000K0003o`0005l000?o00006`000ol0000o0000@@000ol0000I0003o`00064000?o00006@000ol0
00100000@P000ol0000G0003o`0006<000?o00005`000ol000110000@`000ol0000700063ll?c`o?
20000ol0001U0003o`0000H000K?3ll?c`l90003o`00048000140003o`0000<000/?QPn63hH?QPn6
3`050003o`0006L000?o00000`002Pn63hH?QPn63hH60003o`0004<00015000Bo`00c`o?3ll?c`o?
3ll?c`o?0P000ol0001Y000Ao`0?c`o?3ll?c`o?3ll?c`l00`000ol000140000AP004on63hH?QPn6
3hH?QPn63hH?Q_l0K@004`n63hH?QPn63hH?QPn63hH?0?l0A`0004H001??3ll?c`o?3ll?c`o?3ll?
c`o?06`001<?c`o?3ll?c`o?3ll?c`o?3ll?04P00015000EQPn63hH?QPn63hH?QPn63hH?QPn606X0
01D?QPn63hH?QPn63hH?QPn63hH?QPl0A`0004D001H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?J@005/l?
c`o?3ll?c`o?3ll?c`o?3ll?c`m60000A0005`n63hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?
QPn63hH?QPn63hH?QPn63hH?QP160000A0006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?
3ll?c`o?3ll?c`o?3ll?c`o?3lm50000@`006HH?QPn63hH?QPn63hH?QPn63hH?QPn63hH0IP006@n6
3hH?QPn63hH?QPn63hH?QPn63hH?QPl0A@0004<001T?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?06H0
01W?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?04D00013000IQPn63hH?QPn63hH?QPn63hH?QPn63hH?
QP1V000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`150000@`006@o?3ll?c`o?3ll?o`oo3ll?c`o?
3ll?c`l0IP006Ll?c`o?3ll?c`o?3ol?o`o?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?QPoo3hH?
QPn63hH?QPn606H001T?QPn63hH?QPn63hH?o`n63hH?QPn63hH?04D00013000:3ll?c`o?3ll?c`Go
00[?3ll?c`o?3ll?IP002ll?c`o?3ll?c`o?00Go00W?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?
QPoo3hH?QPn63hH?QPn606H001T?QPn63hH?QPn63hH?o`n63hH?QPn63hH?04D00014000Hc`o?3ll?
c`o?3ll?c`o?3ll?c`o?3ll?I`0060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cdD00014000G3hH?QPn6
3hH?QPn63hH?QPn63hH?QPl0J0005hH?QPn63hH?QPn63hH?QPn63hH?QPn604H00015000F3ll?c`o?
3ll?c`o?3ll?c`o?3ll?cfT001K?3ll?c`o?3ll?c`o?3ll?c`o?3ll?AP0004D001J63hH?QPn63hH?
QPn63hH?QPn63hH?J@005Pn63hH?QPn63hH?QPn63hH?QPn63hI60000AP005<l?c`o?3ll?c`o?3ll?
c`o?3ll?J`0050o?3ll?c`o?3ll?c`o?3ll?c`o?A`0004L001:63hH?QPn63hH?QPn63hH?QPm]000B
3hH?QPn63hH?QPn63hH?QPn6B00004P0013?3ll?c`o?3ll?c`o?3ll?K`0040o?3ll?c`o?3ll?c`o?
3lm90000BP003@n63hH?QPn63hH?QPl0LP003HH?QPn63hH?QPn63hH0BP0004d000P?c`o?3ll?cgL0
00S?3ll?c`o?3d`0001?0003QPl007`000<?QP00C`000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000340
00?o000080000ol0001_0003o`0002H000?o0000;P00030000?o00008P000ol0001]0003o`0002P0
00?o0000;@00030000?o00000P05oa<01?l40003o`0001@00olm00Go50000ol0000200Co6`03o`@0
00?o0000;@00030000?o00000P001?l00?lD0005o`000?l00`000ol0000C0005o`000?l0?0001?l0
0?lE0003o`00008000Go0000o`0I0005o`000?l00`000ol0000]0000<0000ol0000200Co2@000ol0
o`080005o`000?l00`000ol000080003o`3o00P000?o0000?P04o`T000?o0?l02@000ol000020005
o`000?l020000ol0o`0>0003o`0000D000?o0000;@00030000?o00001@000ol000080003o`0000L0
00Go0000o`030003o`0000T000?o00001`001Ol0003o03l000?o000020000ol000080003o`000080
00Go0000o`090003o`0000d000Go0000o`030003o`0002d0000`0003o`0000<00ol800Go1`04o`@0
00?o00001`05o`P01?lm00?o2005o`P000?o00000P04o`P01Ol>00Co0`000ol0000]0000<@000ol0
000?0003o`0000L000?o000010000ol0000:0003o`0005H000?o00002@001Ol0003o00d000?o0000
50000ol0000^0000C002og/00_mE0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a * \\(b *  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a * b\\) * c)] .27778 .44444 0 0 Mshowa
.747 .885 .977 r
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(5*5)] .72222 .33333 0 0 Mshowa
[(3*3)] .27778 .33333 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0004d0
00H?c`o?3lmi0006c`o?3ll?CP0004X000/?QPn63hH?QPn63`1e000:3hH?QPn63hH?QT`00018000?
c`o?3ll?c`o?3ll?c`o?070000l?c`o?3ll?c`o?3ll?c`l0BP0004L001663hH?QPn63hH?QPn63hH?
QP1^000A3hH?QPn63hH?QPn63hH?QPl0B@0004H001??3ll?c`o?3ll?c`o?3ll?c`o?06`001<?c`o?
3ll?c`o?3ll?c`o?3ll?04P00015000EQPn63hH?QPn63hH?QPn63hH?QPn606X001D?QPn63hH?QPn6
3hH?QPn63hH?QPl0A`0004D001H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?J@005/l?c`o?3ll?c`o?3ll?
c`o?3ll?c`m60000A0005`n63hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?QPn63hH?
QPn63hH?QP160000A0006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3lm50000@`006HH?QPn63hH?QPn63hH?QPn63hH?QPn63hH0IP006@n63hH?QPn63hH?QPn6
3hH?QPn63hH?QPl0A@0004<000@?c`o?0ol02Ll?c`o?3ll?c`03o`06c`o?3ll?IP001Ll?c`o?00?o
00W?3ll?c`o?3ll00ol01Ll?c`o?04D00013000IQPn63hH?Q_n63hH?QPn63hH?Q_n63hH?QP1V000I
3hH?QPn63hKoQPn63hH?QPn63hKoQPn63`150000@`006@o?3ll?c`oo3ll?o`oo3ll?c`oo3ll?c`l0
IP006Ll?c`o?3ll?o`o?3ol?o`o?3ll?o`o?3ll0A@0004<000F63hH?QP02o`0:3hH?QPoo3hH?QP;o
00H?QPn63hIV00053hH?QPl00ol02@n63hH?o`n63`03o`053hH?QPl0A@0004<000X?c`o?3ll?o`o?
1Ol02/l?c`oo3ll?c`mV000;c`o?3looc`o?3ll01Ol02Looc`o?3ll?c`150000@`0018H?QPl3o`09
3hH?QPoo3hH?00?o00H?QPn63hIV00053hH?QPl01?l028H?QPoo3hH?1?l018H?QPm50000A0006<l?
c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3lm50000A0005`n6
3hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?QPn63hH?QPn63hH?QP160000A@005Po?
3ll?c`o?3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3dH00015000FQPn63hH?
QPn63hH?QPn63hH?QPn63fT001H?QPn63hH?QPn63hH?QPn63hH?QPn6AP0004H001C?3ll?c`o?3ll?
c`o?3ll?c`o?3f/001@?c`o?3ll?c`o?3ll?c`o?3ll?cdL00017000BQPn63hH?QPn63hH?QPn63hH?
K@004Pn63hH?QPn63hH?QPn63hH?QTP00018000@c`o?3ll?c`o?3ll?c`o?3fl0010?c`o?3ll?c`o?
3ll?c`o?B@0004X000d?QPn63hH?QPn63hH?078000f63hH?QPn63hH?QPn604X0001=00083ll?c`o?
3lmg0008c`o?3ll?c`m<0000C`000hH?001l00033hH004l0003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
000a0003o`00020000?o0000K`000ol0000V0003o`0002h0000`0003o`00028000?o0000K@000ol0
000X0003o`0002d0000`0003o`0000801OlC00Co10000ol0000D00?o?@05oa@000?o00000P04oa/0
0ol40003o`0002d0000`0003o`00008000Co003o50001Ol0003o00<000?o00004`001Ol0003o03`0
00Co003o5@000ol000020005o`000?l06@001Ol0003o00<000?o0000;@00030000?o00000P04o`T0
00?o0?l020001Ol0003o00<000?o000020000ol0o`080003o`0003h01?l90003o`3o00T000?o0000
0P001Ol0003o00P000?o0?l03P000ol000050003o`0002d0000`0003o`0000D000?o000020000ol0
00070005o`000?l00`000ol000090003o`0000L000Go0000o`0o0003o`0000P000?o000020000ol0
00020005o`000?l02@000ol0000=0005o`000?l00`000ol0000]0000<0000ol0000300?o2005o`L0
1?l40003o`0000L01Ol800Co?@03o`P01Ol80003o`0000801?l800Go3P04o`<000?o0000;@000340
00?o00003`000ol000070003o`0000@000?o00002P000ol0001F0003o`0000T000Go0000o`0=0003
o`0001@000?o0000;P0004`00_mk00;oE@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"FourStandard"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a * \\(b *  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a * b\\) * c)] .27778 .44444 0 0 Mshowa
.747 .885 .977 r
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(1)] .72222 .33333 0 0 Mshowa
[(1)] .27778 .33333 0 0 Mshowa
[(The two results are equal.)] .5 .25556 0 0 Mshowa
[( Associativity is possible.)] .5 .2 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008`0
0olK00CoLP0008d000?o00006`000ol0001b0000A002o`030?oo00801?l200Co0`03o`<00ol200Go
00<0ool00ol200?o0P05o`800_l300Go0P03o`<000?o00002005o`030?oo00;o2004o`<00ol200Co
0P04o`801Ol00`3oo`02o`801Ol200Co0P02od8000150003o`3o00H000?o00000`001?l00?l30003
o`3o00<000Go0000o`030004o`00o`<000Co003o0`000ol0000200;o1@000ol000020004o`00o`80
00?o00002P000ol000040003o`0000H000Oo0000o`3o00<000?o00000P000ol000030003o`000080
00Go0000o`030005o`000?l00`000ol0000400;o@P0004D00ol300Co0P04o`8000Oo0000o`3o00L0
00Co00001?l30003o`0000@000Ko0000o`02o`@000?o00000P000ol000020003o`3o00/000Co0000
1?l80007o`000?l0o`030003o`3o00?o0P04o`@000Go0000o`030005o`000?l00`05odH000150003
o`3o00<000?o00000`000ol000030007o`000?l0o`030005o`000?l01P001Ol0003o00H000Go0000
o`020003o`00008000?o00000P000ol000020003o`3o00/000Go0000o`0;0007o`000?l0o`030003
o`3o00D000?o00001@001Ol0003o00<000Go0000o`030005o`000?l0AP0004H000?o00000P04o`80
1?l300?o0`04o`800_l400?o0P04o`<00_l200;o0P02o`800_l300Co00@0ool00_l900;o0`04o`L0
1Ol300?o0P04o`801?l300;o0`04o`@000?o00000P03odL0001500;o:@000ol0000E0003o`0003h0
00?o00001@000ol0001<0000I@000ol000080003o`0000@000?o00002@000ol000020003o`000100
00?o00009`000ol00002o`D00om>0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000`P04oeX000340003o`0005T0001300?o0P02o`030?oo00801?l800?o0P001?l00?l300?o
2004o`<01?l00`3oo`02o`801Ol00`3oo`03o`800ol200Co2005o`030?oo00;o0`04o`P01?l200Co
00<0ool00ol00`3oo`03o`030?oo00?o0P02odD000140005o`000?l00P001?l00?l<0005o`00o`00
1?l20005o`000?l020000ol000020003o`0000H000Co003o0P000ol000020003o`00008000Co003o
10000ol000060004o`00o`<000?o00000P000ol000090003o`0000<000Oo0000o`3o008000Co003o
0P000ol000020003o`0000800_m50000A0001Ol0003o008000?o00001Ol80003o`0000801?l20005
o`000?l020000ol0000200Go00<0ool00_l20004o`00o`@000?o00000P000ol0000200Co2004o`<0
00?o00000P05o`L01Ol00`3o00020003o`3o008000?o00001?l40003o`0004T000120007o`3o0?l0
o`020004o`00o`<000?o00001P000ol000020004o`00o`8000Go0000o`0800;o0`001ol0003o0?l0
1@001?l00?l40003o`00008000?o00000P000ol0000<0004o`0000;o0`001Ol0003o00L000Oo0000
o`3o00<000?o0?l00P000ol000030003o`00008000?o0000B@00048000Ko0?l0o`04o`<00ol800Co
00<0ool00P02o`800ol800;o00<0ool00P03o`801?l0103oo`02o`@000Co00001?l200Co2@03o`80
0_l00`3oo`0200?o2@03o`<01_l00`3oo`0300?o10000ol000190000@P05o`030?l0014000?o0000
;P000ol000020003o`00040000?o0000B@0004L00_lB0003o`0002`00ol40003o`0003h00om;0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000C@001Po?3ll?cgT000K?3ll?c`m>0000BP002`n6
3hH?QPn63hH?07D000X?QPn63hH?QPn6C00004P000o?3ll?c`o?3ll?c`o?3ll0L0003`o?3ll?c`o?
3ll?c`o?3`1:0000A`004HH?QPn63hH?QPn63hH?QPn606h0014?QPn63hH?QPn63hH?QPn63`190000
AP004ll?c`o?3ll?c`o?3ll?c`o?3ll0K0004`o?3ll?c`o?3ll?c`o?3ll?c`l0B00004D001F63hH?
QPn63hH?QPn63hH?QPn63hH0JP005@n63hH?QPn63hH?QPn63hH?QPn63`170000A@005Po?3ll?c`o?
3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3dH00014000G3hH?QPn63hH?QPn6
3hH?QPn63hH?QPl0J0005hH?QPn63hH?QPn63hH?QPn63hH?QPn604H00014000Hc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?I`0060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cdD00013000IQPn63hH?QPn63hH?
QPn63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`150000@`002Po?3ll?c`o?
3ll3o`0<c`o?3ll?c`o?3ll?IP002ll?c`o?3ll?c`o?00?o00_?3ll?c`o?3ll?c`150000@`006HH?
QPn63hH?QPn6ohH?QPn63hH?QPn63hH0IP006@n63hH?QPn63hH?Q_n63hH?QPn63hH?QPl0A@0004<0
01T?c`o?3ll?c`o?3ol?c`o?3ll?c`o?3ll?06H001W?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`o?04D0
0013000IQPn63hH?QPn63hKoQPn63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn6ohH?QPn63hH?QPn6
3`150000@`006@o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?c`l0IP006Ll?c`o?3ll?c`o?3ol?c`o?3ll?
c`o?3ll0A@0004<000Z63hH?QPn63hH?0_l03HH?QPn63hH?QPn63hH0IP002`n63hH?QPn63hH?00;o
00b63hH?QPn63hH?QPm50000A0006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?
3ll?c`o?3ll?c`o?3lm50000A0005`n63hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?
QPn63hH?QPn63hH?QP160000A@005Po?3ll?c`o?3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3dH00015000FQPn63hH?QPn63hH?QPn63hH?QPn63fT001H?QPn63hH?QPn63hH?QPn6
3hH?QPn6AP0004H001C?3ll?c`o?3ll?c`o?3ll?c`o?3f/001@?c`o?3ll?c`o?3ll?c`o?3ll?cdL0
0017000BQPn63hH?QPn63hH?QPn63hH?K@004Pn63hH?QPn63hH?QPn63hH?QTP00018000@c`o?3ll?
c`o?3ll?c`o?3fl0010?c`o?3ll?c`o?3ll?c`o?B@0004X000d?QPn63hH?QPn63hH?078000f63hH?
QPn63hH?QPn604X0001=00083ll?c`o?3lmg0008c`o?3ll?c`m<0000C`000hH?001l00033hH004l0
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240000a0003o`00020000?o0000K`000ol0000V0003o`0002h0
000`0003o`00028000?o0000K@000ol0000X0003o`0002d0000`0003o`0000801OlC00Co10000ol0
000D00?o?@05oa@000?o00000P04oa/00ol40003o`0002d0000`0003o`00008000Co003o50001Ol0
003o00<000?o00004`001Ol0003o03`000Co003o5@000ol000020005o`000?l06@001Ol0003o00<0
00?o0000;@00030000?o00000P04o`T000?o0?l020001Ol0003o00<000?o000020000ol0o`080003
o`0003h01?l90003o`3o00T000?o00000P001Ol0003o00P000?o0?l03P000ol000050003o`0002d0
000`0003o`0000D000?o000020000ol000070005o`000?l00`000ol000090003o`0000L000Go0000
o`0o0003o`0000P000?o000020000ol000020005o`000?l02@000ol0000=0005o`000?l00`000ol0
000]0000<0000ol0000300?o2005o`L01?l40003o`0000L01Ol800Co?@03o`P01Ol80003o`000080
1?l800Go3P04o`<000?o0000;@00034000?o00003`000ol000070003o`0000@000?o00002P000ol0
001F0003o`0000T000Go0000o`0=0003o`0001@000?o0000;P0004`00_mk00;oE@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000001
\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"FourStandard"]
}, Open  ]],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->"FourStandard"]
}, Open  ]],

Cell["2.3.2 Related functions", "Subsubsection",
  CellTags->"Related"],

Cell[TextData[{
  "There are a number of functions related to the four functions that handle \
the defining properties of a group. Many of these functions have ",
  StyleBox["Textual", "MR"],
  " and/or ",
  StyleBox["Visual", "MR"],
  " modes."
}], "Text",
  CellTags->"Related"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["H",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR",
                  SingleLetterItalics->False], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["closed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subset",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["under",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["operation",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["G",
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Related", "i:16"}],

Cell[TextData[{
  "Function related to ",
  StyleBox["ClosedQ",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Related"],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["ClosedQ", "MR"],
  ", when used with a subset, illustrates why the result is ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  " by coloring the products (sums) that are in the subset yellow and those \
that are not red."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[Z[6], \ {0, 2}, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->"Related"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(0)] .22789 .77381 0 0 Mshowa
[(2)] .36395 .77381 0 0 Mshowa
[(1)] .5 .77381 0 0 Mshowa
[(3)] .63605 .77381 0 0 Mshowa
[(4)] .77211 .77381 0 0 Mshowa
[(5)] .90816 .77381 0 0 Mshowa
[(2)] .22789 .63776 0 0 Mshowa
[(4)] .36395 .63776 0 0 Mshowa
[(3)] .5 .63776 0 0 Mshowa
[(5)] .63605 .63776 0 0 Mshowa
[(0)] .77211 .63776 0 0 Mshowa
[(1)] .90816 .63776 0 0 Mshowa
[(1)] .22789 .5017 0 0 Mshowa
[(3)] .36395 .5017 0 0 Mshowa
[(2)] .5 .5017 0 0 Mshowa
[(4)] .63605 .5017 0 0 Mshowa
[(5)] .77211 .5017 0 0 Mshowa
[(0)] .90816 .5017 0 0 Mshowa
[(3)] .22789 .36565 0 0 Mshowa
[(5)] .36395 .36565 0 0 Mshowa
[(4)] .5 .36565 0 0 Mshowa
[(0)] .63605 .36565 0 0 Mshowa
[(1)] .77211 .36565 0 0 Mshowa
[(2)] .90816 .36565 0 0 Mshowa
[(4)] .22789 .22959 0 0 Mshowa
[(0)] .36395 .22959 0 0 Mshowa
[(5)] .5 .22959 0 0 Mshowa
[(1)] .63605 .22959 0 0 Mshowa
[(2)] .77211 .22959 0 0 Mshowa
[(3)] .90816 .22959 0 0 Mshowa
[(5)] .22789 .09354 0 0 Mshowa
[(1)] .36395 .09354 0 0 Mshowa
[(0)] .5 .09354 0 0 Mshowa
[(2)] .63605 .09354 0 0 Mshowa
[(3)] .77211 .09354 0 0 Mshowa
[(4)] .90816 .09354 0 0 Mshowa
[(0)] .09184 .77381 0 0 Mshowa
[(2)] .09184 .63776 0 0 Mshowa
[(1)] .09184 .5017 0 0 Mshowa
[(3)] .09184 .36565 0 0 Mshowa
[(4)] .09184 .22959 0 0 Mshowa
[(5)] .09184 .09354 0 0 Mshowa
[(0)] .22789 .90986 0 0 Mshowa
[(2)] .36395 .90986 0 0 Mshowa
[(1)] .5 .90986 0 0 Mshowa
[(3)] .63605 .90986 0 0 Mshowa
[(4)] .77211 .90986 0 0 Mshowa
[(5)] .90816 .90986 0 0 Mshowa
[(Z[6])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -95 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
75.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[49]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000=00?o4002oa000olA0003o`0000d0
0olA0003o`0000h00_lB0003o`0000d01?l@0003o`0000d00olA0003o`0000l00ol@0003o`0000@0
00060003o`00010000?o00003@02oa<000?o00003P000ol0000>0003o`00010000?o00003@001?l0
0?lA0003o`0000h000?o000040000ol0000@0003o`0000h000?o000040000ol0000?0003o`0000@0
00060003o`00010000?o00003@02oa<000?o00003P000ol0000>0003o`00010000?o00003@001?l0
0?lA0003o`0000l000?o00003`000ol0000@0003o`0000h000?o00003P04oa0000?o0000100000H0
00?o00003@03oa000_l@00?o4@000ol0000>0003o`00010000?o00003@001?l00?lA0003o`000100
00?o00003P000ol0000>00;o4@000ol0000>0003o`3o014000?o0000100000H000?o00003@000ol0
000@00;o40000ol0000A0003o`0000h000?o000040000ol0000=0004o`00oa4000?o00003@001?l0
0?l@0003o`00010000?o00003P000ol0000>0003o`3o014000?o0000100000H000?o00003@04o`l0
0_l@00Co40000ol0000=00;o4P000ol0000>00;o4P000ol0000>00;o4@000ol0000=00?o4@000ol0
000?00;o4@000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000>00?o3`02oa400ol@0003o`0000h00_lA0003
o`0000d00olB0003o`0000d00olA0003o`0000d01?l@0003o`0000h00olA0003o`0000@000060003
o`0000l000?o00003P02oa8000?o00003`000ol0000=0004o`00oa0000?o000040000ol0000?0003
o`0000h000?o000040000ol0000>0003o`00010000?o00004@000ol0000>0003o`0000@000060003
o`0000d01?l?00;o4004oa0000?o00003@001?l00?l@0003o`00010000?o00003`000ol0000>0003
o`00010000?o00003`000ol0000?0003o`00014000?o00003P000ol0000400001P000ol0000=0003
o`3o01000_l@0003o`3o014000?o00003@001?l00?l@0003o`0000d00olB0003o`0000h000?o0000
40000ol0000@0003o`0000h000?o00003`02oa4000?o0000100000H000?o00003@000ol0o`0@00;o
40000ol0o`0A0003o`0000d000Co003o40000ol0000=0003o`00018000?o00003P000ol0000@0003
o`0000d000Co003o40000ol0000A0003o`0000h000?o0000100000H000?o00003P02oa000_lA00;o
4@000ol0000>00;o4@000ol0000=00Co4@000ol0000=00;o4P000ol0000>00;o4@000ol0000>00?o
4@000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060?oo0Ol600001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000=00?o4002oa000olA0003o`0000d00olA0003o`0000h0
0olA0003o`0000h00_lA0003o`0000d00olA0003o`0000h01?l@0003o`0000@000060003o`000100
00?o00003@02oa<000?o00003P000ol0000@0003o`0000h000?o00003`000ol0000@0003o`0000d0
00Co003o40000ol0000>0003o`00010000?o00003`000ol0000@0003o`0000@000060003o`000100
00?o00003@02oa<000?o00003P000ol0000@0003o`0000h000?o00003@04oa4000?o00003@001?l0
0?l@0003o`0000h000?o000040000ol0000@0003o`0000l000?o0000100000H000?o00003P02oa00
0_lA00;o4@000ol0000=00?o4@000ol0000=0003o`3o018000?o00003@001?l00?l@0003o`0000h0
00?o000040000ol0000A0003o`0000h000?o0000100000H000?o000040000ol0000=00;o4`000ol0
000>0003o`0000d000?o00004@000ol0000=0003o`3o018000?o00003@001?l00?l@0003o`0000h0
00?o000040000ol0000>0004o`00oa0000?o0000100000H000?o00003@03oa000_l@00?o4@000ol0
000=00Co40000ol0000>00;o4P000ol0000>00;o4@000ol0000=00;o4P000ol0000?00;o4@000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P3oo`7o1P0000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00003@03oa000_l@00?o4@000ol0000=00?o4@000ol0000=00Co
4@000ol0000>00?o40000ol0000=00?o4@000ol0000?00;o4@000ol0000400001P000ol0000>0003
o`0000l00_lA0003o`00010000?o000040000ol0000>0003o`0000h000?o00004@000ol0000?0003
o`0000l000?o000040000ol0000>0003o`0000h000Co003o40000ol0000400001P000ol0000>0003
o`0000l00_lA0003o`00010000?o000040000ol0000>0003o`0000l000?o000040000ol0000=00Co
40000ol0000@0003o`0000h000?o00003P001?l00?l@0003o`0000@000060003o`0000h000?o0000
3`02oa4000?o000040000ol0000>00;o4@000ol0000@0003o`0000l000?o00003@000ol0o`0A0003
o`0000d00olA0003o`0000h000Co003o40000ol0000400001P000ol0000>0003o`0000l00_lA0003
o`00010000?o000040000ol0000>0003o`0000d000Co003o4@000ol0000=0003o`3o014000?o0000
3@000ol0000A0003o`0000h000Co003o40000ol0000400001P000ol0000=00;o4@02oa000_lB0003
o`0000d00olA0003o`0000h00_lB0003o`0000h00_lA0003o`0000d01?l@0003o`0000l00_lA0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H0ool1o`H000060003omoO023O0_lTg`03oalO024O00?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olO7`0Q7`03o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o7al08Al00ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03oalO024O00?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olO7`0Q7`03o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o7al08Al00ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03oalO024O
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olO
7`0Q7`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO
00?o7al08Al00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O
0_lTg`03oalO024O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooO
g`0Pg`;o9=l00olO7`0Q7`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?ogml08=l2obCO00?o7al08Al00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003omoO023O0_lTg`03oalO024O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ooOg`0Pg`;o9=l00olO7`0Q7`03o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?ogml08=l2obCO00?o7al08Al00ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003omoO00gO1?l?g`;o4=l4oa3O00?o7al03Ql3oa0O00?o00003@03oa80
00?o00003@03oa4000?o00003P02oa4000?o00003P03oa4000?o0000100000H000?ogml03]l00ooO
g`0?g`;o4Ml00ooOg`0@g`03oalO00lO00?o7al03al00ol0000@0003o`0000l000?o000040000ol0
000>0003o`0000d000Co003o40000ol0000?0003o`00010000?o0000100000H000?ogml03ml00ooO
g`0>g`;o4]l00ooOg`0?g`03oalO00dO1?l@7`03o`00010000?o00003`000ol0000@0003o`0000h0
00?o00003@001?l00?l@0003o`0000l000?o000040000ol0000400001P000ooOg`0@g`03omoO00gO
0_lCg`03omoO00kO00?o7al03Al00olOo`0A7`03o`0000h00_lB0003o`0000d00olA0003o`0000d0
00Co003o40000ol0000?0003o`00010000?o0000100000H000?ogml03Ml01?oOgol?g`;o4=l01?oO
gol@g`03oalO00dO00?o7ol04Al00ol0000@0003o`0000l000?o00003@000ol0000A0003o`0000d0
00Co003o40000ol0000?0003o`00010000?o0000100000H000?ogml03]l2oa3O0_lAg`;o4Ml00olO
7`0>7`;o4Al00ol0000=00?o4P000ol0000=00Co40000ol0000>00;o4@000ol0000>00;o4P000ol0
000400001P000ooOg`0Pg`;o9=l00olO7`0Q7`03o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?ogml08=l2obCO00?o7al08Al00ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003omoO023O0_lTg`03oalO024O00?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olO7`0Q7`03o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o7al08Al00ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03oalO024O00?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olO7`0Q7`03o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o7al08Al00ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03oalO024O
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olO
7`0Q7`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO
00?o7al08Al00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O
0_lTg`03oalO024O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooO
g`0Pg`;o9=l00olO7`0Q7`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?ogml08=l2obCO00?o7al08Al00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003omoO023O0_lTg`03oalO024O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P3oo`7o1P0000H000?ogml08=l2obCO00?ogml08Ml00ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003omoO023O0_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00ooOg`0Qg`03o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?ogml08Ml00ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03omoO027O00?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00ooOg`0Qg`03
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03
omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o
9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml0
8=l2obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
omoO023O0_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ooOg`0Pg`;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?ogml08=l2obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003omoO023O0_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ooOg`0Pg`;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?ogml03]l2oa3O0_lAg`;o4Ml00ooOg`0=g`Co4=l00ol0000=00?o
4P000ol0000=00?o4@000ol0000>00?o40000ol0000>00?o4@000ol0000400001P000ooOg`0=g`04
omoOo`oO0_l@g`04omoOoa3O00?ogml03]l00ooOg`0@g`03o`0000h000?o00004@000ol0000@0003
o`0000h000?o00003`000ol0000?0003o`00014000?o00003P000ol0000400001P000ooOg`0=g`04
omoOo`oO0_l@g`04omoOoa3O00?ogml03ml00ooOg`0?g`03o`0000h000?o00004@000ol0000@0003
o`0000h000?o00003@04oa0000?o00004@000ol0000>0003o`0000@000060003omoO00gO00Cogmoo
3ml2oa3O00Cogmoo4=l00ooOg`0@g`03omoO00kO00?o00003P000ol0000A0003o`0000h00_lA0003
o`0000d000?o0?l04@000ol0000>00?o4@000ol0000400001P000ooOg`0=g`04omoOo`oO0_l@g`04
omoOoa3O00?ogml03Ml01?oOgol@g`03o`0000h000?o00004@000ol0000@0003o`0000h000?o0000
3@000ol0o`0A0003o`0000h000?o00004@000ol0000400001P000ooOg`0>g`;o4=l2oa7O0_lAg`03
omoO00kO0_lAg`03o`0000d00_lC0003o`0000d00olA0003o`0000h00_lA0003o`0000h01?l@0003
o`0000@000060003omoO023O0_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ooOg`0Pg`;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?ogml08=l2obCO00?ogml08Ml00ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003omoO023O0_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00ooOg`0Qg`03o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?ogml08Ml00ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03omoO027O00?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00ooOg`0Qg`03
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03
omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o
9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml0
8=l2obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
omoO023O0_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ooOg`0Pg`;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000D0ool2o`H000050?oo0_l600001P000ol0000O00?o9=l00ooOg`0Qg`03o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00007P001?l0oolTg`03omoO027O00?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000M0003o`0000;o9=l00ooO
g`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o000070001?l0
0002obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0001/000?o00000P02obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0001X000?o00000`02obCO00?ogml08Ml00ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0001T000?o00001002obCO00?ogml08Ml00ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0001P000?o00001@02obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000H00_l00`3o
o`0<0003o`0000H00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000070003o`3o00`000?o00001`02obCO00?ogml08Ml00ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0000P000?o00002P000ol0000800;o9=l00ooO
g`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001`000ol0
o`0:0003o`0000T00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000600;o00<0ool020000ol0000:00;o9=l00ooOg`0Qg`03o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00004P000ol0000;00;o9=l00ooOg`0Qg`03
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00004@000ol0000<00;o
4Ml2oa7O00?ogml03Ml4oa3O00?o00003@03oa8000?o00003@03oa4000?o00003P03oa0000?o0000
3P03oa4000?o0000100000H000?o000040000ol0000=00;o4=l01?oOgol@g`03omoO00kO00?ogml0
4=l00ol0000>0003o`00014000?o000040000ol0000>0003o`0000l000?o00003`000ol0000A0003
o`0000h000?o0000100000H000?o00003`000ol0000>00;o4=l01?oOgol@g`03omoO00oO00?ogml0
3ml00ol0000>0003o`00014000?o000040000ol0000>0003o`0000d01?l@0003o`00014000?o0000
3P000ol0000400001P000ol0000>0003o`0000l00_l@g`04omoOoa3O00?ogml04=l00ooOg`0>g`03
o`0000h000?o00004@000ol0000>00;o4@000ol0000=0003o`3o014000?o00003P03oa4000?o0000
100000H000?o00003@000ol0000@00;o4=l01?oOgol@g`03omoO00gO00Cogmoo4=l00ol0000>0003
o`00014000?o000040000ol0000>0003o`0000d000?o0?l04@000ol0000>0003o`00014000?o0000
100000H000?o000030000ol0000600?o2002oa7O0_lAg`03omoO00kO0_lAg`03o`0000d00_lC0003
o`0000d00olA0003o`0000h00_lA0003o`0000h01?l@0003o`0000@000060003o`0000/000?o0000
20000ol0000700;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00002P000ol0000:0003o`0000H00_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol000090003o`0000/000?o00001P02obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000P000?o0000
2`000ol0o`0700;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00001`000ol0000<0003o`3o00L00_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol000060003o`0000`00_l00`3oo`0600;o9=l00ooO
g`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001@000ol0
000H00;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o000010000ol0000I00;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00000`000ol0000J00;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00000P000ol0000K00;o9=l00ooOg`0Qg`03o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000Go0000o`0N00;o9=l00ooOg`0Qg`03
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000Co003o7`02obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`3o02000_lTg`03
omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P02ob400_lTg`03
omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P3oo`7o1P0002T0
0_oQ0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000
o`0=0000o`0=0000o`0=0000o`0=00003P02o`X00_oQ00?o300000h000?o00002P000ol0003P0003
o`0000/0000700Co0`000ol0000300;o1@000ol0003700;o00<0ool02@000ol0o`090003o`0000X0
00080003o`3o00<000?o00000P001?l00?l40003o`000<P000?o0?l02`000ol000080003o`0000X0
00080003o`0000<000?o00000P001?l00?l40003o`000<T000?o00002005o`L000?o0?l02`0000T0
00?o00000P000ol0000200?o1@000ol000380003o`3o00/000?o00001`000ol0o`0;00001`000ol0
o`040003o`00008000?o00001@000ol0003700;o00<0ool04`02o`030?oo00X0000700Co0`02o`@0
0ol300;ol0000?l03@000?l03@000?l03@000001\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"Related"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["HasIdentityQ", "MR"],
  " function checks for a two-sided identity. One-sided identity functions \
are also available."
}], "Text",
  CellTags->{"Related", "i:17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["HasLeftIdentityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["contains",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(a\ left\ identity\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["HasRightIdentityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], " ", "groupoid", " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["contains",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(a\ right\ identity\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["LeftIdentity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["identity",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(if\ it\ exists\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["RightIdentity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["right",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["identity",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], 
                    StyleBox["e",
                      "Text"]}]], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["groupoid",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(if\ it\ exists\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["GroupIdentity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((two\[Hyphen]sided)\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["identity",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], 
                    StyleBox["e",
                      "Text"]}]], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["groupoid",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(if\ it\ exists\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["Identity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["GroupIdentity",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["G",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Related", "i:18"}],

Cell[TextData[{
  "Functions related to ",
  StyleBox["HasIdentityQ",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Related"],

Cell[TextData[{
  "The ",
  StyleBox["FirstTaker", "MR"],
  " function does not have a left identity."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftIdentity[FirstTaker[5]]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"Related"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "Although there are a number of right identities, the ",
  StyleBox["RightIdentity", "MR"],
  " function takes the \[OpenCurlyDoubleQuote]first\[CloseCurlyDoubleQuote] \
one."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \({RightIdentity[FirstTaker[5]], \ GroupIdentity[FirstTaker[5]]}\)], 
  "Input",
  CellLabel->"In[51]:=",
  CellTags->"Related"],

Cell[BoxData[
    \({1, $Failed}\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["HasInversesQ", "MR"],
  " function checks for a two-sided inverse; checking for the one-sided \
variety requires one of the following functions."
}], "Text",
  CellTags->{"Related", "i:19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["LeftInvertibleQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["contains",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["inverse",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["element",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["g",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["LeftInverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["left",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inverse",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["g",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(if\ it\ exists\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["$Failed",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["RightInvertibleQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], 
                  StyleBox["e",
                    "Text"]}]], 
              StyleBox[" ",
                "Text"], 
              StyleBox["groupoid",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["contains",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["right",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inverse",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["RightInverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ right\ inverse\ of\ the\ element\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(if\ it\ exists\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["$Failed",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["InvertibleQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["contains",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]]}], " ", 
              RowBox[{"(", 
                StyleBox["two\[Hyphen]sided",
                  SingleLetterItalics->False], 
                StyleBox[")",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inverse",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(\(g, \)\ \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["GroupInverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["g",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((two\[Hyphen]sided)\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["inverse",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["element",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]]}], " ", "\n", 
              RowBox[{
                RowBox[{"groupoid", " ", 
                  StyleBox[
                    FormBox["G",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(if\ it\ exists\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["Inverses",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["pairs",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{"{", 
                      RowBox[{"g", ",", " ", 
                        FormBox[
                          SuperscriptBox["g", 
                            StyleBox[\(-1\),
                              SingleLetterItalics->False]],
                          "TraditionalForm"]}], "}"}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[\(\ when\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(has\ an\ inverse\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["or",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["{",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox[
                        FormBox["g",
                          "TraditionalForm"],
                        "Text"], 
                      StyleBox[\(\(, \ "no inverse"}\)\ if\ \),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox["g",
                          "TraditionalForm"],
                        "Text"], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["does",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["not",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["have",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["an",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["inverse",
                        SingleLetterItalics->False]}]}]}]}]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["Inverse",
                      "MR"], 
                    StyleBox["[",
                      "MR"], "G", 
                    StyleBox[",",
                      "MR"], " ", "g", 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{"identical", " ", "to", " ", 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{
                      StyleBox["GroupInverse",
                        "MR"], 
                      StyleBox["[",
                        "MR"], "G", 
                      StyleBox[",",
                        "MR"], " ", "g", "]"}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Related", "i:20"}],

Cell[TextData[{
  "Functions related to ",
  StyleBox["HasInversesQ",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Related"],

Cell[TextData[{
  "To determine if the element ",
  Cell[BoxData[
      \(TraditionalForm\`g\^2\)]],
  " has a left inverse in the cyclic group of order 5, the following is used. \
(Note that the default generator ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " is a string and is thus enclosed in quotes.)"
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftInvertibleQ[CyclicGroup[5], \ "\<g\>"\^2]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"Related"]
}, Open  ]],

Cell["\<\
Considering the element {{-1, 0}, {0, -1}} in the quaternion group \
(represented as matrices), we confirm that it is invertible.\
\>", 
  "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InvertibleQ[QuaternionGroup[Form\  \[Rule] \ AsMatrices], 
      \ {{\(-1\), 0}, {0, \(-1\)}}]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "Since the element ",
  Cell[BoxData[
      \(TraditionalForm\`Rot\^2**\ Ref\)]],
  " is a reflection in ",
  Cell[BoxData[
      \(TraditionalForm\`D\_5\)]],
  ", its right inverse is itself."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RightInverse[DihedralGroup[5], \ Rot\^2**Ref]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(Rot\^2**Ref\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of the ",
  StyleBox["Inverses", "MR"],
  " function uses loops for self-inversive elements and line segments to \
connect pairs of elements that are inverses to each other."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverses[QuaternionGroup[Form\  \[Rule] \ AsSymbols], \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"Related"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.008 w
.5 .5 Mdot
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.75901 .75901 Mdot
.8663 .5 Mdot
.75901 .24099 Mdot
.5 .1337 Mdot
.24099 .24099 Mdot
.1337 .5 Mdot
.24099 .75901 Mdot
0 g
gsave
.5 .95788 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.82377 .82377 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.95788 .5 -72 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
75.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.82377 .17623 -72 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
75.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 .04212 -66 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.17623 .17623 -69 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(ba) show
75.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.04212 .5 -75 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(ba) show
75.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.17623 .82377 -75 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 20.000000 moveto
 558.000000 20.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 20.000000 lineto
closepath
clip newpath
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(ba) show
75.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
87.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 .165 .165 r
2 Mabswid
.75901 .75901 m
.75901 .24099 L
s
newpath
.8956 .5 .02564 0 365.73 arc
s
.5 .1337 m
.1337 .5 L
s
.24099 .24099 m
.24099 .75901 L
s
newpath
.5 .8956 .02564 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[55]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@0008d01?n?0000S@001Ol0003o08h0002=0005
o`000?l0SP0008d000Go0000o`2>0000S@04ohl0002=0003o`000900002<00;oTP000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@0008d01Db>0000R`09C8`0002:00]<R`0008T03Db:0000R@0=C8X0
002800m<R@0008P03db90000Q00014j>CXh6C003dam<00I<00F>CXi>SP240000O00023i>?ThnCSi>
1005C003M1id00M<1@0023i>?ThnCSi>O00007T000>>CXh03004C003daoC00Q<3@000dj>001i0000
M0001Ci>?Thn01000T`00g@NM008C10000DnCSi>?P1e0000LP000dj>000D0004C=<Od`U<5@000hi>
SP1b0000K@001DhnCSi>01L000=d7W@02D`I0005?ThnCSh0K@0006X000=>STh06`000m<Od`09C1l0
00>>CP00JP0006P000<nCP0070000g@NM00300E<8`000dhnCP1X0000I@000hi>SP0N0003daoC02l0
00=>SP00I@0002d01?l200Go:`000dhn000O0003M1id038000<nCSh09`05o`L00ol]0000;@001ol0
003o0?l00P000ol0000W0003CXi>024000?C7m<0=P000hi>000T0004o`00o`/000?o0000:P0002d0
00Ko0000o`04obP000=>00008@000g@NM00i0003CP0002801?l;0003o`0002X0000]0005o`000?l0
10000ol0000U0003CP00024000?C7m<0>`000dh0000T0003o`0000L00_l]0000;@04o`<00olU0003
?Th0028000=d7W@0?@000dhnCP0Q00?o2`000ol0000Z0000;@000ol0000Y0003STj>02@000?C7m<0
@@000dj>000S0003o`3o00<00ol]0000;002obX000<n000090000g@NM0140003?P00028000?o0000
<P0005L000>>000090000m<Od`160003SP0005H0001E0003CSh002D000=d7W@0B0000ci>001E0000
E0000dh0000U0003daoC04/000=>0000D`0005<000=>00009@000g@NM01=0003CP000580001A0003
STh002H000?C7m<0C`000dj>001A0000C`000dhn000W0003M1id058000<nCP00C`0004h000=>0000
9`000m<Od`1E0003CP0004d0001<0003?Th002P000=d7W@0E`000dhn001<0000@P05C0@000>>0000
:0000m<Od`1J0004SP0000E<A00004002D`00`0n000Y0003M1id05`000<nC4`01da20000?`0;C2X0
00?C7m<0G@0;C440000n00e<:0000g@NM01M00e<@00003h03D`W0003daoC05h03Da00000?@0?C2D0
00=d7W@0GP0?C3l0000m00m<90000m<Od`1O00m<?`0003d01d`00aidC005C2<000=d7W@0H006C003
7WA<00I<?`0003d01d`00m<OC005C28000?C7m<0H@06C003dam<00I<?`0003d01d`00aidC005C240
00=d7W@0HP06C0037WA<00I<?`0003h01T`00m<OC004C24000?C7m<0I005C003dam<00E<@00003h0
1T`00aidC004C20000=d7W@0I@05C0037WA<00E<@00003l01D`00m<OC003C20000?C7m<0I`04C003
dam<00A<00>>0000?P0003h000<n04`00d`00aidC002C20000=d7W@0J@03C0037WA<00=<0P000ch0
000m0000?P0014h00002C003dam<024000?C7m<0K0000dcC7`02C0@000=>0000?@0003d000=>0000
10000aid000P0003M1id06h000<NM0001P000dh0000l0000?@000hh000040003dal001l000?C7m<0
K`000m<O00060003SP0003`0000l0003?P0000D000<NM0007P000g@NM01`00037W@000L000<n0000
>`0003/000>>00001P000m<O000M0003daoC074000?C7`0020000hh0000j0000>`000dh000060003
7W@001`000=d7W@0LP000aid00080003CP0003X0000j0003CP0000L000?C7`006`000m<Od`1c0003
dal000T000=>0000>@0003T000=>000020000aid000J0003M1id07@000<NM0002P000dh0000h0000
>0000dh000090003dal001T000?C7m<0M@000m<O000;0003CP0003L0000h0003?P0000T000<NM000
60000g@NM01f00037W@000/000<n0000=`0003L000>>00002P000m<O000G0003daoC07L000?C7`00
30000hh0000f0000=P000ch0000;00037W@001H000=d7W@0N0000aid000=0003?P0003D0000e0003
SP0000`000?C7`005@000m<Od`1i0003dal000h000>>0000=00003D000=>000030000aid000D0003
M1id07X000<NM0003P000dh0000d0000=0000dh0000=0003dal001<000?C7m<0N`000m<O000?0003
CP0003<0000d0003?P0000d000<NM0004P000g@NM01l00037W@000l000<n0000<`0003<000>>0000
3P000m<O000A0003daoC07d000?C7`0040000hh0000b0000<`000dh0000>00037W@0010000=d7W@0
OP000aid000@0003CP000380000b0003CP0000l000?C7`003`000m<Od`1o0003dal0014000=>0000
<@00034000=>000040000aid000>0003M1id080000<NM0004P000dh0000`0000<@000hh0000@0003
dal000d000?C7m<0P@000m<O000B0003SP000300000`0003?P00014000<NM00030000g@NM0220003
7W@001<000<n0000;`00030000=>00004@000m<O000;0003daoC08<000?C7`004`000dh0000_0000
;`000dh0000B00037W@000X000=d7W@0Q0000aid000D0003CP0002h0000_0003SP00018000?C7`00
2@000m<Od`250003dal001@000>>0000;P0002l000=>00004P000aid00080003M1id08H000<NM000
50000dh0000^0000;P000dh0000C0003dal000L000?C7m<0Q`000m<O000E0003CP0002d0000^0003
?P0001<000<NM0001P000g@NM02800037W@001D000<n0000;@0002d000>>000050000m<O00050003
daoC08T000?C7`005P000hh0000/0000;@000dh0000D00037W@000@000=d7W@0RP000aid000F0003
CP0002`0000]0003SP0001@000?C7`000`000m<Od`2;0003dal001H000>>0000;00002`000<n0000
5@000aid00020003M1id08`000<NM0005`000ch0000[0000;0000dh0000E0007dal00=<Od`2=0003
dal001L000=>0000:`0002/000=>00005P001Qid07@NM8h000<NM00060000dh0000Z0000:`000hh0
000F0005daoC7m<0S`000m<O000H0003SP0002X0000[0003CP0001H000@NM1idT0000aid000H0003
CP0002X0000[0003SP0001H000?C7m<0T@000m<O000H0003SP0002X0000[0003CP0001D000=d7W@0
TP000aid000H0003CP0002X0000Z0003CP0001D000CC7m<OTP000m<O000I0003CP0002T0000Z0003
?P0001@000Ed7W@NM02B00037W@001T000<n0000:@0002X000=>00004`001]<Od`3C7i8000?C7`00
6@000dh0000Y0000:@000dh0000C0003M1id008000<NM000T@000aid000J0003CP0002P0000Y0003
SP00018000?C7m<00`000m<O002A0003dal001X000>>0000:00002T000=>00004@000g@NM0040003
7W@0094000<NM0006P000dh0000X0000:@000hh0000@0003daoC00D000?C7`00T@000m<O000J0003
SP0002P0000Y0003CP0000l000=d7W@01P000aid002A00037W@001X000=>0000:00002P000=>0000
3`000m<Od`070003dal0094000?C7`006`000dh0000W0000:0000ch0000>0003M1id00P000<NM000
T@000aid000K0003?P0002L0000W0003SP0000h000?C7m<02@000m<O002A0003dal001`000>>0000
9P0002L000=>00003@000g@NM00:00037W@0094000<NM00070000dh0000V00009`000hh0000<0003
daoC00/000?C7`00T@000m<O000L0003SP0002H0000W0003CP0000/000=d7W@030000aid002A0003
7W@001`000=>00009P0002L000>>00002P000m<Od`0=0003dal0094000?C7`0070000hh0000V0000
9`000dh000090003M1id00h000<NM000T@000aid000L0003CP0002H0000W0003SP0000P000?C7m<0
3`000m<O002A0003dal001`000>>00009P0002L000=>00001`000g@NM00@00037W@0094000<NM000
70000dh0000V00009P000dh000070003daoC014000?C7`00T@000m<O000M0003CP0002D0000V0003
?P0000H000=d7W@04P000aid002A00037W@001d000<n00009@0002H000=>00001@000m<Od`0C0003
dal0094000?C7`007@000dh0000U00009P000ch000040003M1id01@000<NM000T@000aid000M0003
?P0002D0000S00E<10000m<Od`0E0003dal0094000?C7`006`05C00:0=<OdaoC7m<Oda/0000Q00U<
00@0M1id5P000aid002A00037W@001T01d`02g@NM1id7W@NM1id01X0000P00Y<00?C7m<05`000m<O
002A0003dal001P024`00aoCC0060003daoC01T0000O00Y<00=d7W@060000aid002A00037W@001L0
24`00aid7P02C0H000=d7P00600000030?oo00;o0P05o`L01?l800U<00CC7m=<60000m<O002A0003
dal001L01d`00aoC7`03C0H000<Odal00P05o`L01?l6000000<0o`000P000ol0o`020003o`0000L0
00?o00001`09C003M1id00=<5`000aid002A00037W@001H024`00g@NC004C0H000DNM1h0o`020003
o`0000L000?o00001P0000030?l0008000?o0?l00ol:0003o`0000H024`00m<Od`04C1L000?C7`00
T@000m<O000F00M<00?C7m<01D`700037m<000Co2P000ol00005000000<0o`000P000ol000020003
o`0000T000?o00001@07C003M1id00E<5`000aid002A00037W@001H01d`00aidC005C0L000=d7P00
0`000ol000090003o`0000@000000`3oo`02o`<00ol80004o`00o`L01d`00aoCC005C1L000?C7`00
T@000m<O000F00M<00?C7d`01D`700047m<000?o20001?l00?l6000000<0o`002P000ol0o`0400;o
200?C1L000<NM000T@000aid000F00M<00<NM1h01D`600037W@N00L000?o0?l01002o`L00002o``0
00?o00003P0=C1P000?C7`00T@000m<O000G00M<00<Odd`00d`70003dal000P000?o0000300001l0
3D`H00037W@0094000<NM0005`07C003M1i<00=<1`000aid000G0000800;C1T000?C7`00T@000m<O
000H00I<00DOdaoCC0060004daoC7aP0000Q00U<6P000aid002A00037W@001T01T`011id7W@50004
M1id7QT0000S00E<70000m<O002A0003dal001/01D`02P3C7m<OdaoC7m<K00009P000ch0000K0003
7W@0094000<NM0007@000ch000020007M1id7W@NM00L00009P000dh0000K0003dal0094000?C7`00
7@000dh0000U00009P000ch0000K00037W@0094000<NM0007@000ch0000U00009P000dh0000K0003
dal0094000?C7`007@000dh0000U00009`000dh0000J00037W@0094000<NM00070000dh0000V0000
9`000hh0000J0003dal0094000?C7`0070000hh0000V00009`000dh0000J00037W@0094000<NM000
70000dh0000V00009`000hh0000J0003dal0094000?C7`0070000hh0000V00009`000dh0000J0003
7W@0094000<NM00070000dh0000V00009`000hh0000J0003dal0094000?C7`0070000hh0000V0000
9`000dh0000J00037W@0094000<NM00070000dh0000V00009`000hh0000J0003dal0094000?C7`00
70000hh0000V0000:0000ch0000I00037W@0094000<NM0006`000ch0000W0000:0000dh0000I0003
dal0094000?C7`006`000dh0000W0000:0000ch0000I00037W@0094000<NM0006`000ch0000W0000
:@000hh0000H0003dal0094000?C7`006P000hh0000X0000:@000dh0000H00037W@0094000<NM000
6P000dh0000X0000:@000hh0000H0003dal0094000?C7`006P000hh0000X0000:@000dh0000H0003
7W@0094000<NM0006P000dh0000X0000:@000hh0000H0003dal0094000?C7`006P000hh0000X0000
:P000ch0000G00037W@0094000<NM0006@000ch0000Y0000:P000dh0000G0003dal0094000?C7`00
6@000dh0000Y0000:`000dh0000F00037W@0094000<NM00060000dh0000Z0000:`000hh0000F0003
dal0094000?C7`0060000hh0000Z0000:`000dh0000F00037W@0094000<NM00060000dh0000Z0000
:`000hh0000F0003dal0094000?C7`0060000hh0000Z0000:`000dh0000F00037W@0094000<NM000
60000dh0000Z0000;0000dh0000E0003dal0094000?C7`005`000dh0000[0000;0000ch0000E0003
7W@0094000<NM0005`000ch0000[0000;0000dh0000E0003dal0094000?C7`005`000dh0000[0000
;@000dh0000D00037W@0094000<NM0005P000dh0000/0000;@000hh0000D0003dal0094000?C7`00
5P000hh0000/0000;P000ch0000C00037W@0094000<NM0005@000ch0000]0000;P000dh0000C0003
dal0094000?C7`005@000dh0000]0000;P000ch0000C00037W@0094000<NM0005@000ch0000]0000
;`000hh0000B0003dal0094000?C7`0050000hh0000^0000;`000dh0000B00037W@0094000<NM000
50000dh0000^0000<0000dh0000A0003dal0094000?C7`004`000dh0000_0000<0000ch0000A0003
7W@0094000<NM0004`000ch0000_0000<0000dh0000A0003dal0094000?C7`004`000dh0000_0000
<@000dh0000@00037W@0094000<NM0004P000dh0000`0000<P000dh0000?0003dal0094000?C7`00
4@000dh0000a0000<`000dh0000>00037W@0094000<NM00040000dh0000b0000<`000hh0000>0003
dal0094000?C7`0040000hh0000b0000=0000ch0000=00037W@0094000<NM0003`000ch0000c0000
=0000dh0000=0003dal0094000?C7`003`000dh0000c0000=0000ch0000=00037W@0094000<NM000
3`000ch0000c0000=@000hh0000<0003dal0094000?C7`003P000hh0000d0000=P000ch0000;0003
7W@0094000<NM0003@000ch0000e0000=`000hh0000:0003dal0094000?C7`0030000hh0000f0000
=`000dh0000:00037W@0094000<NM00030000dh0000f0000>0000dh000090003dal0094000?C7`00
2`000dh0000g0000>@000dh0000800037W@0094000<NM0002P000dh0000h0000>P000dh000070003
dal0094000?C7`002@000dh0000i0000>P000ch0000700037W@0094000<NM0002@000ch0000i0000
>`000hh000060003dal0094000?C7`0020000hh0000j0000>`000dh0000600037W@0094000<NM000
20000dh0000j0000?0000dh000050003dal0094000?C7`001`000dh0000k0000?@000dh000040003
7W@0094000<NM0001P000dh0000l0000?@000hh000040003dal0094000?C7`001P000hh0000l0000
?P0013h00002C0037WA<090000=<7W@00T`40003?P0003d0000o0003STa<009<00?C7d`00Tb<00=<
00?C7d`00d`00`2>000o0000?`05C0037WA<00=<RP04C0037WA<00A<@@0003h01T`00m<OC004C8P0
1D`00m<OC005C400000n00I<00<NM4`014b800E<00<NM4`01Da00000?@07C003dam<00E<QP06C003
dam<00I<?`0003d01d`00aidC005C8H01T`00aidC006C3l0000m00M<00?C7d`01Db600I<00?C7d`0
1T`o0000?@0?C8H03d`o0000?@0?C8H03d`o0000?P0=C8P03Da00000?P0=C8P03Da00000?`0;C003
?P0008L02da10000@009C08000>>CP00Q0000dj>0009C480001200E<1P000dhn00200003?Th000@0
1Da40000C`000hh0001m0003SP0004h0001@0003?Th007X000=>?P00D000058000=>0000M`000dh0
001A0000D`000dh0001e0003CP000580001D0003CXh0078000>>CP00E00005H000<n0000K`000ch0
001E0000E`000hh0001]0003SP0005H0000W00Co0P05o`L00olL0003?Th006X000=>?P008P05oc40
000W0007o`000?l0o`020003o`0000T000?o00006`000dj>CP1V0003STh002@000Co003o<P0002L0
00Ko0000o`04o`/000?o00007P000dh0001Q0003CSh002H01?lb00009`001Ol0003o00@000?o0000
1`02ob8000=>0000G`000dh0000Z0003o`000300000W00Co0`03o`/000?o000080000dhn001L0003
?Th002X00olb00009`000ol000090003o`3o00<00olU0003STj>05P000=>SP00H@0002H00_l<0003
o`0002d000<nCP00DP000dhnCP1T0000IP000dj>CP1>0003STh006H0001Y0003CSh004P000<nCSh0
J@0006/000>>CXh07`05C20000=>SP00J`0006h000DnCSi>?P0H00U<6@001DhnCSi>06h0001c0003
STh001@02d`E0003CXi>07<0001e0005CSi>?Th03`0=C0l000E>?ThnCP1f0000NP000dj>CP0<00e<
3@000hi>001j0000O@0024hnCSi>?Thn0`0?C0@000Q>?ThnCSi>?Wd000250003STj>00m<00B>CXi>
Q@0008P01T`011id7W@5C8T0002800=<00TOdaoC7m<Odal00db90000R0001dad7W@NM1h00T`017@N
M1h2C8T000280004daoC7`M<00<Odal0RP0008L000=d7W@02T`00aid00290000Q`000aoC000:C003
daoC08T000270004M1h000U<00<0M1h0R@0008L000<Od`000`05C0<000<Od`00R00008L000=d7P00
2`000g@N00280000Q`000aoC000;00037m<008P000270003M1h000/000=d7P00R00008L000<Od`00
2`000aoC00280000Q`000g@NM00:00037W@N08T000280004daoC7`H000CC7m<ORP0008T000ad7W@N
M1h07W@NM1j;0000R`0021oC7m<OdaoCS@0008h000<NM1h0S`000?l08@000?l08@000?l08@000?l0
8@000?l08@0008h01?n>0000S@000ol0002@0000S@05ohh0002=0005o`000?l0SP0008h00on?0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.36502, -1.36502, 0.0095123, 
  0.0095123}},
  CellTags->"Related"],

Cell[BoxData[
    \({{"e", "e"}, {"a", "a^3"}, {"a^2", "a^2"}, {"b", "ba^2"}, {"ba", 
        "ba^3"}}\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[
"When an element does not have an inverse, it is paired with \
\[OpenCurlyDoubleQuote]no inverse.\[CloseCurlyDoubleQuote]"], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverses[Zx[6]]\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"Related"],

Cell[BoxData[
    \({{0, "no inverse"}, {1, 1}, {2, "no inverse"}, {3, "no inverse"}, {4, 
        "no inverse"}, {5, 5}}\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Since the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AssociativeQ", "MR",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " function checks all possible triples in the groupoid, the time it takes \
to check grows in proportion to the cube of the order of the groupoid. There \
are faster methods, such as the Light test, that rely on using a generating \
set, but they are not currently implemented in these packages. In most cases, \
if an operation is not associative, the property is violated by a large \
percentage of the possible triples.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  CellTags->{"Related", "i:21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RandomAssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["satisfies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["associative",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              
              StyleBox[\(property\ after\ testing\ 25\ triples\ at\ random, \ 
                and\),
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["False",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["otherwise",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["RandomAssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["satisfies",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["associative",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["property",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["after",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["testing",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ triples\ at\ random, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["NonAssociatingTriples",
                      "MR"], 
                    StyleBox["[",
                      "MR"], "G", 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
            "give", " ", "a", " ", "list", " ", "of", " ", "triples", " ", 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"a", 
                        StyleBox[",",
                          "MR"], " ", "b", 
                        StyleBox[",",
                          "MR"], " ", "c"}], 
                      StyleBox["}",
                        "MR"]}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"], " ", "such", " ", "that", " ", 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{\(\((a\ b)\)\ c\), " ", 
                      StyleBox["\[NotEqual]",
                        FontSlant->"Plain"], " ", \(a\ \((b\ c)\)\)}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Related", "i:22"}],

Cell[TextData[{
  "Functions related to ",
  StyleBox["AssociativeQ",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Related"],

Cell["\<\
Lack of associativity is detected quite easily for the following \
groupoid, even by testing only one triple.\
\>", "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomAssociativeQ[G\  = \ FormGroupoid[{2, 3, 4}, Subtract], 1]\)], 
  "Input",
  CellLabel->"In[57]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[57]=",
  CellTags->"Related"]
}, Open  ]],

Cell["\<\
The foregoing example works so well because all 27 possible triples \
fail associativity.\
\>", "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \({nat\  = \ NonAssociatingTriples[G], \ Length[nat]}\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->"Related"],

Cell[BoxData[
    \({{{2, 2, 2}, {2, 2, 3}, {2, 2, 4}, {2, 3, 2}, {2, 3, 3}, {2, 3, 4}, {2, 
          4, 2}, {2, 4, 3}, {2, 4, 4}, {3, 2, 2}, {3, 2, 3}, {3, 2, 4}, {3, 
          3, 2}, {3, 3, 3}, {3, 3, 4}, {3, 4, 2}, {3, 4, 3}, {3, 4, 4}, {4, 
          2, 2}, {4, 2, 3}, {4, 2, 4}, {4, 3, 2}, {4, 3, 3}, {4, 3, 4}, {4, 
          4, 2}, {4, 4, 3}, {4, 4, 4}}, 27}\)], "Output",
  CellLabel->"Out[58]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "We have seen how to test individual properties of being a group. With one \
test, we can check to see if a groupoid is indeed a group or not. If the \
groupoid is large, we can use the random approach using ",
  StyleBox["ProbableGroupQ", "MR"],
  ", which uses ",
  StyleBox["RandomAssociativeQ", "MR"],
  ". Additionally, there are structures called semigroups and monoids that \
have some of the group properties; each of them can also be tested."
}], "Text",
  CellTags->{"Related", "i:23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GroupQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["satisfies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["properties",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(a\ group\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["ProbableGroupQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["G",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["satisfies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["properties",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(of\ a\ group\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["using",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["RandomAssociativeQ",
                          "MR"], 
                        StyleBox["[",
                          "MR"], 
                        StyleBox["G",
                          "TI"], 
                        StyleBox["]",
                          "MR"]}],
                      "StandardForm"],
                    "Text"], 
                  StyleBox[\(\ for\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        RowBox[{
                          StyleBox["AssociativeQ",
                            "MR"], 
                          StyleBox["[",
                            "MR"], 
                          StyleBox["G",
                            "TI"], 
                          StyleBox["]",
                            "TI"]}], 
                        StyleBox[",",
                          "TI"]}],
                      "StandardForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["SemiGroupQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["G",
                  "Text",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["satisfies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["properties",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                
                StyleBox[
                  \(of\ a\ semigroup\ \((closed\ and\ associative)\)\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["MonoidQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["G",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["satisfies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["properties",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                
                StyleBox[
                  \(of\ a\ monoid\ 
                    \((closed, \ associative, \ and\ having\ an\ identity)
                      \)\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["GroupInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["accumulated",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["facts",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["about",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["G",
                  FontSlant->"Italic"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                
                StyleBox[
                  \((prefaced\ with\ name\ and\ description, \ if\ available)
                    \),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["determined",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["from",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["various",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["tests",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], "done", " ", 
                  StyleBox["on",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["G",
                    FontSlant->"Italic"]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"Related", "i:24"}],

Cell["Related functions.", "Caption",
  CellTags->"Related"],

Cell[TextData[{
  "When ",
  StyleBox["GroupQ", "MR"],
  " is called, it first tests to see whether the set is closed under the \
operation, next whether there is an identity, then whether every element has \
an inverse, and finally whether the operation is associative. On the first \
failure of a test, it returns ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->"Related"],

Cell[TextData[{
  "The ",
  StyleBox["GroupQ", "MR"],
  " function tests the four basic properties for being a group and returns ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  " accordingly."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupQ[TwistedZ[13]]\)], "Input",
  CellLabel->"In[59]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "Either by adding ",
  StyleBox["Mode \[Rule] Textual", "MR"],
  " to the ",
  StyleBox["GroupQ", "MR"],
  " function, or by using ",
  StyleBox["GroupInfo", "MR"],
  " afterwards, we can learn details about the result of testing the four \
group properties."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupInfo[TwistedZ[13]]\)], "Input",
  CellLabel->"In[60]:=",
  CellTags->"Related"],

Cell[BoxData[
    \({"TwistedZ[13]", "the set is closed under the operation", 
      "the left identity is 0", "the right identity is 0", 
      "the identity is 0", "every element has an inverse", 
      "the operation is associative with these elements", "this is a group"}
      \)], "Output",
  CellLabel->"Out[60]=",
  CellTags->"Related"]
}, Open  ]],

Cell[TextData[{
  "Replacing ",
  StyleBox["AssociativeQ", "MR"],
  " with ",
  StyleBox["RandomAssociativeQ", "MR"],
  ", ",
  StyleBox["ProbableGroupQ", "MR"],
  " is comparable to ",
  StyleBox["GroupQ", "MR"],
  "."
}], "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProbableGroupQ[TwistedZ[12]]\)], "Input",
  CellLabel->"In[61]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[61]=",
  CellTags->"Related"]
}, Open  ]],

Cell["Consider the following groupoid.", "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = \ FormGroupoid[{\(-1\), \ 0, \ 1}, \ Times]\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->"Related"],

Cell[BoxData[
    \(Groupoid[{\(-1\), 0, 1}, "-Operation-"]\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->"Related"]
}, Open  ]],

Cell["What kind of structure is it?", "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{

Cell[BoxData[
    \({GroupQ[G], \ MonoidQ[G], \ SemiGroupQ[G]}\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->"Related"],

Cell[BoxData[
    \({False, True, True}\)], "Output",
  CellLabel->"Out[63]=",
  CellTags->"Related"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"Working",
WindowSize->{500, 400},
WindowMargins->{{9, Automatic}, {Automatic, 1}},
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "FormGroupoid"->{
    Cell[2564, 83, 233, 10, 75, "Section",
      Evaluatable->False,
      CellTags->"FormGroupoid"],
    Cell[3575, 131, 130, 5, 36, "Subsection",
      CellTags->"FormGroupoid"],
    Cell[3708, 138, 376, 10, 37, "Text",
      CellTags->"FormGroupoid"],
    Cell[4087, 150, 7800, 223, 213, "DefinitionBox",
      CellTags->{"FormGroupoid", "i:1"}],
    Cell[11890, 375, 141, 6, 26, "Caption",
      CellTags->"FormGroupoid"],
    Cell[12034, 383, 139, 5, 60, "Subsubsection",
      CellTags->{"FormGroupoid", "i:2"}],
    Cell[12176, 390, 13920, 395, 179, "DefinitionBox",
      CellTags->"FormGroupoid"],
    Cell[26099, 787, 145, 6, 26, "Caption",
      CellTags->"FormGroupoid"],
    Cell[26247, 795, 435, 9, 91, "Text",
      CellTags->"FormGroupoid"],
    Cell[26685, 806, 101, 1, 40, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[26811, 811, 207, 5, 71, "Input",
      CellTags->"FormGroupoid"],
    Cell[27021, 818, 96, 3, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[27132, 824, 10869, 313, 400, "DefinitionBox3Col",
      CellTags->{"FormGroupoid", "i:3"}],
    Cell[38004, 1139, 137, 6, 14, "Caption",
      CellTags->"FormGroupoid"],
    Cell[38144, 1147, 519, 10, 99, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[38688, 1161, 363, 8, 107, "Input",
      CellTags->"FormGroupoid"],
    Cell[39054, 1171, 116, 3, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[39185, 1177, 167, 5, 55, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[39377, 1186, 129, 3, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[39509, 1191, 125, 3, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[39649, 1197, 158, 5, 41, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[39832, 1206, 97, 3, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[39932, 1211, 318, 6, 83, "Output",
      CellTags->"FormGroupoid"],
    Cell[40265, 1220, 410, 11, 84, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[40700, 1235, 83, 2, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[40786, 1239, 386, 7, 98, "Output",
      CellTags->"FormGroupoid"],
    Cell[41187, 1249, 1361, 42, 129, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[42573, 1295, 73, 2, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[42649, 1299, 129, 3, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[42793, 1305, 793, 24, 84, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[43611, 1333, 99, 2, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[43713, 1337, 202, 4, 68, "Output",
      CellTags->"FormGroupoid"],
    Cell[43930, 1344, 219, 6, 55, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[44174, 1354, 83, 2, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[44260, 1358, 239, 5, 83, "Output",
      CellTags->"FormGroupoid"],
    Cell[44514, 1366, 329, 8, 69, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[44868, 1378, 116, 2, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[44987, 1382, 209, 4, 79, "Print",
      CellTags->"FormGroupoid"],
    Cell[45199, 1388, 50213, 792, 308, 3896, 214, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormGroupoid"],
    Cell[95415, 2182, 123, 3, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[95553, 2188, 274, 7, 71, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[95852, 2199, 117, 2, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[95972, 2203, 309, 5, 79, "Print",
      CellTags->"FormGroupoid"],
    Cell[96284, 2210, 97345, 1956, 308, 15369, 938, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormGroupoid"],
    Cell[193644, 4169, 818, 20, 126, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[194487, 4193, 270, 5, 99, "Input",
      CellTags->"FormGroupoid"],
    Cell[194760, 4200, 245, 4, 64, "Print",
      CellTags->"FormGroupoid"],
    Cell[195008, 4206, 169, 3, 64, "Print",
      CellTags->"FormGroupoid"],
    Cell[195180, 4211, 62523, 1056, 308, 6469, 358, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormGroupoid"],
    Cell[257706, 5269, 557, 9, 143, "Output",
      CellTags->"FormGroupoid"],
    Cell[258278, 5281, 155, 4, 54, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[258458, 5289, 96, 3, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[258557, 5294, 92, 3, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[258664, 5300, 320, 7, 83, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[259009, 5311, 291, 7, 87, "Input",
      CellTags->"FormGroupoid"],
    Cell[259303, 5320, 174, 4, 38, "Output",
      CellTags->"FormGroupoid"],
    Cell[259492, 5327, 385, 12, 71, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[259902, 5343, 388, 8, 119, "Input",
      CellTags->"FormGroupoid"],
    Cell[260293, 5353, 282, 5, 83, "Output",
      CellTags->"FormGroupoid"],
    Cell[260590, 5361, 334, 11, 70, "MathCaption",
      CellTags->"FormGroupoid"],
    Cell[260949, 5376, 134, 3, 39, "Input",
      CellTags->"FormGroupoid"],
    Cell[261086, 5381, 471, 7, 124, "Print",
      CellTags->"FormGroupoid"],
    Cell[261560, 5390, 85990, 1609, 308, 11236, 680, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormGroupoid"]},
  "First"->{
    Cell[2800, 95, 60, 1, 36, "Subsection",
      CellTags->"First"],
    Cell[2863, 98, 178, 5, 23, "Text",
      CellTags->"First"],
    Cell[3044, 105, 146, 4, 26, "Input",
      CellTags->"First"],
    Cell[3193, 111, 153, 5, 23, "Text",
      CellTags->"First"],
    Cell[3371, 120, 102, 3, 26, "Input",
      CellTags->"First"],
    Cell[3476, 125, 84, 3, 20, "Output",
      CellTags->"First"]},
  "i:1"->{
    Cell[4087, 150, 7800, 223, 213, "DefinitionBox",
      CellTags->{"FormGroupoid", "i:1"}]},
  "i:2"->{
    Cell[12034, 383, 139, 5, 60, "Subsubsection",
      CellTags->{"FormGroupoid", "i:2"}]},
  "i:3"->{
    Cell[27132, 824, 10869, 313, 400, "DefinitionBox3Col",
      CellTags->{"FormGroupoid", "i:3"}]},
  "GenerateGroupoid"->{
    Cell[347565, 7002, 147, 5, 60, "Subsubsection",
      CellTags->{"GenerateGroupoid", "i:4"}],
    Cell[347715, 7009, 299, 10, 60, "Text",
      CellTags->"GenerateGroupoid"],
    Cell[348017, 7021, 462, 12, 94, "Text",
      CellTags->"GenerateGroupoid"],
    Cell[348482, 7035, 7668, 213, 111, "DefinitionBox",
      CellTags->"GenerateGroupoid"],
    Cell[356153, 7250, 153, 6, 26, "Caption",
      CellTags->"GenerateGroupoid"],
    Cell[356309, 7258, 224, 7, 59, "Text",
      CellTags->"GenerateGroupoid"],
    Cell[356536, 7267, 705, 22, 84, "DefinitionBox3Col",
      CellTags->{"GenerateGroupoid", "i:5"}],
    Cell[357244, 7291, 155, 6, 26, "Caption",
      CellTags->"GenerateGroupoid"],
    Cell[357402, 7299, 285, 6, 75, "Text",
      CellTags->"GenerateGroupoid"],
    Cell[357690, 7307, 282, 10, 55, "MathCaption",
      CellTags->"GenerateGroupoid"],
    Cell[357997, 7321, 167, 4, 71, "Input",
      CellTags->"GenerateGroupoid"],
    Cell[358167, 7327, 131, 3, 38, "Output",
      CellTags->"GenerateGroupoid"],
    Cell[358313, 7333, 184, 6, 40, "MathCaption",
      CellTags->"GenerateGroupoid"],
    Cell[358522, 7343, 113, 3, 39, "Input",
      CellTags->"GenerateGroupoid"],
    Cell[358638, 7348, 159, 4, 53, "Output",
      CellTags->"GenerateGroupoid"],
    Cell[358812, 7355, 256, 8, 56, "MathCaption",
      CellTags->"GenerateGroupoid"],
    Cell[359093, 7367, 284, 6, 87, "Input",
      CellTags->"GenerateGroupoid"],
    Cell[359380, 7375, 139, 3, 38, "Output",
      CellTags->"GenerateGroupoid"],
    Cell[359534, 7381, 97, 1, 40, "MathCaption",
      CellTags->"GenerateGroupoid"],
    Cell[359656, 7386, 175, 4, 71, "Input",
      CellTags->"GenerateGroupoid"],
    Cell[359834, 7392, 307, 6, 98, "Output",
      CellTags->"GenerateGroupoid"]},
  "i:4"->{
    Cell[347565, 7002, 147, 5, 60, "Subsubsection",
      CellTags->{"GenerateGroupoid", "i:4"}]},
  "i:5"->{
    Cell[356536, 7267, 705, 22, 84, "DefinitionBox3Col",
      CellTags->{"GenerateGroupoid", "i:5"}]},
  "FormGroupoidByTable"->{
    Cell[360156, 7401, 144, 5, 60, "Subsubsection",
      CellTags->"FormGroupoidByTable"],
    Cell[360303, 7408, 444, 8, 107, "Text",
      CellTags->"FormGroupoidByTable"],
    Cell[360750, 7418, 8024, 215, 111, "DefinitionBox",
      CellTags->{"FormGroupoidByTable", "i:6"}],
    Cell[368777, 7635, 159, 6, 26, "Caption",
      CellTags->"FormGroupoidByTable"],
    Cell[368939, 7643, 418, 10, 83, "MathCaption",
      CellTags->"FormGroupoidByTable"],
    Cell[369382, 7657, 105, 3, 39, "Input",
      CellTags->"FormGroupoidByTable"],
    Cell[369490, 7662, 220, 4, 67, "Message",
      CellTags->"FormGroupoidByTable"],
    Cell[369713, 7668, 139, 3, 38, "Output",
      CellTags->"FormGroupoidByTable"],
    Cell[369867, 7674, 392, 11, 68, "MathCaption",
      CellTags->"FormGroupoidByTable"],
    Cell[370284, 7689, 119, 3, 39, "Input",
      CellTags->"FormGroupoidByTable"],
    Cell[370406, 7694, 97, 3, 38, "Output",
      CellTags->"FormGroupoidByTable"],
    Cell[370518, 7700, 247, 7, 56, "MathCaption",
      CellTags->"FormGroupoidByTable"],
    Cell[370790, 7711, 308, 6, 87, "Input",
      CellTags->"FormGroupoidByTable"],
    Cell[371101, 7719, 62770, 973, 308, 4260, 245, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormGroupoidByTable"],
    Cell[433874, 8694, 127, 3, 38, "Output",
      CellTags->"FormGroupoidByTable"]},
  "i:6"->{
    Cell[360750, 7418, 8024, 215, 111, "DefinitionBox",
      CellTags->{"FormGroupoidByTable", "i:6"}]},
  "OtherForm"->{
    Cell[434016, 8700, 214, 8, 60, "Subsubsection",
      CellTags->{"OtherForm", "i:7"}],
    Cell[434233, 8710, 262, 8, 59, "Text",
      CellTags->"OtherForm"],
    Cell[434498, 8720, 2436, 68, 77, "DefinitionBox",
      CellTags->"OtherForm"],
    Cell[436937, 8790, 138, 6, 26, "Caption",
      CellTags->"OtherForm"],
    Cell[437078, 8798, 294, 9, 60, "Text",
      CellTags->"OtherForm"],
    Cell[437375, 8809, 753, 23, 84, "DefinitionBox3Col",
      CellTags->{"OtherForm", "i:8"}],
    Cell[438131, 8834, 154, 6, 26, "Caption",
      CellTags->"OtherForm"],
    Cell[438288, 8842, 201, 5, 54, "MathCaption",
      CellTags->"OtherForm"],
    Cell[438514, 8851, 293, 7, 114, "Input",
      CellTags->"OtherForm"],
    Cell[438810, 8860, 287, 5, 98, "Output",
      CellTags->"OtherForm"],
    Cell[439112, 8868, 312, 10, 70, "MathCaption",
      CellTags->"OtherForm"],
    Cell[439449, 8882, 100, 2, 39, "Input",
      CellTags->"OtherForm"],
    Cell[439552, 8886, 509, 10, 143, "Output",
      CellTags->"OtherForm"],
    Cell[440076, 8899, 184, 5, 59, "Text",
      CellTags->{"OtherForm", "i:9"}],
    Cell[440263, 8906, 5449, 153, 147, "DefinitionBox",
      CellTags->"OtherForm"],
    Cell[445715, 9061, 144, 6, 26, "Caption",
      CellTags->"OtherForm"],
    Cell[445862, 9069, 179, 4, 54, "MathCaption",
      CellTags->"OtherForm"],
    Cell[446066, 9077, 212, 4, 71, "Input",
      CellTags->"OtherForm"],
    Cell[446281, 9083, 40426, 1087, 122, 12931, 741, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherForm"]},
  "i:7"->{
    Cell[434016, 8700, 214, 8, 60, "Subsubsection",
      CellTags->{"OtherForm", "i:7"}]},
  "i:8"->{
    Cell[437375, 8809, 753, 23, 84, "DefinitionBox3Col",
      CellTags->{"OtherForm", "i:8"}]},
  "i:9"->{
    Cell[440076, 8899, 184, 5, 59, "Text",
      CellTags->{"OtherForm", "i:9"}]},
  "Structure"->{
    Cell[486722, 10173, 142, 5, 68, "Subsection",
      CellTags->{"Structure", "i:10"}],
    Cell[486867, 10180, 1423, 42, 142, "Text",
      CellTags->"Structure"],
    Cell[488293, 10224, 10223, 290, 155, "DefinitionBox",
      CellTags->{"Structure", "i:11"}],
    Cell[498519, 10516, 164, 6, 26, "Caption",
      CellTags->"Structure"],
    Cell[498686, 10524, 98, 1, 40, "MathCaption",
      CellTags->"Structure"],
    Cell[498809, 10529, 112, 3, 39, "Input",
      CellTags->"Structure"],
    Cell[498924, 10534, 270, 5, 68, "Output",
      CellTags->"Structure"],
    Cell[499209, 10542, 318, 9, 70, "MathCaption",
      CellTags->"Structure"],
    Cell[499552, 10555, 159, 4, 55, "Input",
      CellTags->"Structure"],
    Cell[499714, 10561, 224, 5, 70, "Output",
      CellTags->"Structure"],
    Cell[499953, 10569, 241, 6, 59, "Text",
      CellTags->"Structure"],
    Cell[500197, 10577, 9108, 266, 238, "DefinitionBox",
      CellTags->{"Structure", "i:12"}],
    Cell[509308, 10845, 93, 1, 26, "Caption",
      CellTags->"Structure"],
    Cell[509404, 10848, 187, 7, 41, "MathCaption",
      CellTags->"Structure"],
    Cell[509616, 10859, 246, 6, 71, "Input",
      CellTags->"Structure"],
    Cell[509865, 10867, 150, 4, 38, "Output",
      CellTags->"Structure"],
    Cell[510030, 10874, 185, 5, 55, "MathCaption",
      CellTags->"Structure"],
    Cell[510240, 10883, 119, 3, 39, "Input",
      CellTags->"Structure"],
    Cell[510362, 10888, 109, 3, 38, "Output",
      CellTags->"Structure"],
    Cell[510486, 10894, 256, 7, 56, "MathCaption",
      CellTags->"Structure"],
    Cell[510767, 10905, 140, 3, 39, "Input",
      CellTags->"Structure"],
    Cell[510910, 10910, 185, 4, 53, "Output",
      CellTags->"Structure"],
    Cell[511110, 10917, 346, 7, 83, "MathCaption",
      CellTags->"Structure"],
    Cell[511481, 10928, 145, 4, 55, "Input",
      CellTags->"Structure"],
    Cell[511629, 10934, 154, 4, 53, "Output",
      CellTags->"Structure"],
    Cell[511798, 10941, 145, 4, 54, "MathCaption",
      CellTags->"Structure"],
    Cell[511968, 10949, 136, 3, 39, "Input",
      CellTags->"Structure"],
    Cell[512107, 10954, 97, 3, 38, "Output",
      CellTags->"Structure"],
    Cell[512219, 10960, 208, 6, 54, "MathCaption",
      CellTags->"Structure"],
    Cell[512452, 10970, 182, 5, 71, "Input",
      CellTags->"Structure"],
    Cell[512637, 10977, 132, 3, 38, "Output",
      CellTags->"Structure"]},
  "i:10"->{
    Cell[486722, 10173, 142, 5, 68, "Subsection",
      CellTags->{"Structure", "i:10"}]},
  "i:11"->{
    Cell[488293, 10224, 10223, 290, 155, "DefinitionBox",
      CellTags->{"Structure", "i:11"}]},
  "i:12"->{
    Cell[500197, 10577, 9108, 266, 238, "DefinitionBox",
      CellTags->{"Structure", "i:12"}]},
  "FourStandard"->{
    Cell[512784, 10983, 96, 1, 68, "Subsection",
      CellTags->"FourStandard"],
    Cell[512883, 10986, 96, 1, 60, "Subsubsection",
      CellTags->{"FourStandard", "i:13"}],
    Cell[512982, 10989, 521, 13, 94, "Text",
      CellTags->"FourStandard"],
    Cell[513506, 11004, 11321, 320, 200, "DefinitionBox",
      CellTags->{"FourStandard", "i:14"}],
    Cell[524830, 11326, 104, 1, 26, "Caption",
      CellTags->"FourStandard"],
    Cell[524937, 11329, 381, 12, 76, "Text",
      CellTags->"FourStandard"],
    Cell[525321, 11343, 1424, 44, 131, "DefinitionBox3Col",
      CellTags->{"FourStandard", "i:15"}],
    Cell[526748, 11389, 134, 4, 26, "Caption",
      CellTags->"FourStandard"],
    Cell[526885, 11395, 523, 16, 94, "Text",
      CellTags->"FourStandard"],
    Cell[527411, 11413, 84, 1, 40, "MathCaption",
      CellTags->"FourStandard"],
    Cell[527520, 11418, 443, 10, 103, "Input",
      CellTags->"FourStandard"],
    Cell[527966, 11430, 189, 4, 53, "Output",
      CellTags->"FourStandard"],
    Cell[528170, 11437, 360, 12, 71, "MathCaption",
      CellTags->"FourStandard"],
    Cell[528555, 11453, 127, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[528685, 11458, 184, 3, 64, "Print",
      CellTags->"FourStandard"],
    Cell[528872, 11463, 209, 4, 79, "Print",
      CellTags->"FourStandard"],
    Cell[529084, 11469, 92, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[529191, 11475, 261, 8, 55, "MathCaption",
      CellTags->"FourStandard"],
    Cell[529477, 11487, 126, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[529606, 11492, 165, 3, 64, "Print",
      CellTags->"FourStandard"],
    Cell[529774, 11497, 25078, 549, 308, 5184, 298, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[554855, 12048, 92, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[554962, 12054, 222, 7, 56, "MathCaption",
      CellTags->"FourStandard"],
    Cell[555209, 12065, 161, 4, 39, "Input",
      CellTags->"FourStandard"],
    Cell[555373, 12071, 165, 3, 64, "Print",
      CellTags->"FourStandard"],
    Cell[555541, 12076, 90427, 2928, 308, 42068, 2325, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[645971, 15006, 112, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[646098, 15012, 200, 5, 54, "MathCaption",
      CellTags->"FourStandard"],
    Cell[646323, 15021, 114, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[646440, 15026, 149, 3, 51, "Message",
      CellTags->"FourStandard"],
    Cell[646592, 15031, 150, 3, 51, "Message",
      CellTags->"FourStandard"],
    Cell[646745, 15036, 144, 3, 35, "Message",
      CellTags->"FourStandard"],
    Cell[646892, 15041, 100, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[647007, 15047, 289, 10, 56, "MathCaption",
      CellTags->"FourStandard"],
    Cell[647321, 15061, 128, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[647452, 15066, 196, 3, 64, "Print",
      CellTags->"FourStandard"],
    Cell[647651, 15071, 111, 2, 34, "Print",
      CellTags->"FourStandard"],
    Cell[647765, 15075, 94, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[647874, 15081, 173, 5, 55, "MathCaption",
      CellTags->"FourStandard"],
    Cell[648072, 15090, 138, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[648213, 15095, 31655, 740, 185, 8565, 449, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[679871, 15837, 91, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[679977, 15843, 166, 4, 55, "MathCaption",
      CellTags->"FourStandard"],
    Cell[680168, 15851, 113, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[680284, 15856, 154, 3, 51, "Message",
      CellTags->"FourStandard"],
    Cell[680441, 15861, 188, 4, 51, "Message",
      CellTags->"FourStandard"],
    Cell[680632, 15867, 92, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[680739, 15873, 260, 7, 70, "MathCaption",
      CellTags->"FourStandard"],
    Cell[681024, 15884, 132, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[681159, 15889, 209, 4, 64, "Print",
      CellTags->"FourStandard"],
    Cell[681371, 15895, 175, 3, 64, "Print",
      CellTags->"FourStandard"],
    Cell[681549, 15900, 92, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[681656, 15906, 296, 8, 69, "MathCaption",
      CellTags->"FourStandard"],
    Cell[681977, 15918, 166, 4, 55, "Input",
      CellTags->"FourStandard"],
    Cell[682146, 15924, 30512, 991, 308, 15701, 802, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[712661, 16917, 111, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[712787, 16923, 199, 5, 55, "MathCaption",
      CellTags->"FourStandard"],
    Cell[713011, 16932, 132, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[713146, 16937, 235, 4, 79, "Print",
      CellTags->"FourStandard"],
    Cell[713384, 16943, 225, 4, 64, "Print",
      CellTags->"FourStandard"],
    Cell[713612, 16949, 176, 3, 64, "Print",
      CellTags->"FourStandard"],
    Cell[713791, 16954, 885, 18, 127, "Print",
      CellTags->"FourStandard"],
    Cell[714679, 16974, 92, 3, 38, "Output",
      CellTags->"FourStandard"],
    Cell[714786, 16980, 274, 8, 69, "MathCaption",
      CellTags->"FourStandard"],
    Cell[715085, 16992, 131, 3, 39, "Input",
      CellTags->"FourStandard"],
    Cell[715241, 16999, 15640, 284, 164, 1886, 108, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[730884, 17285, 10114, 193, 164, 1358, 79, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[741001, 17480, 10110, 193, 164, 1354, 79, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[751114, 17675, 5822, 116, 164, 865, 49, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[756939, 17793, 8058, 145, 164, 962, 51, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FourStandard"],
    Cell[765012, 17941, 91, 3, 38, "Output",
      CellTags->"FourStandard"]},
  "i:13"->{
    Cell[512883, 10986, 96, 1, 60, "Subsubsection",
      CellTags->{"FourStandard", "i:13"}]},
  "i:14"->{
    Cell[513506, 11004, 11321, 320, 200, "DefinitionBox",
      CellTags->{"FourStandard", "i:14"}]},
  "i:15"->{
    Cell[525321, 11343, 1424, 44, 131, "DefinitionBox3Col",
      CellTags->{"FourStandard", "i:15"}]},
  "Related"->{
    Cell[765118, 17947, 71, 1, 60, "Subsubsection",
      CellTags->"Related"],
    Cell[765192, 17950, 280, 8, 59, "Text",
      CellTags->"Related"],
    Cell[765475, 17960, 4041, 109, 64, "DefinitionBox",
      CellTags->{"Related", "i:16"}],
    Cell[769519, 18071, 135, 6, 26, "Caption",
      CellTags->"Related"],
    Cell[769657, 18079, 362, 12, 70, "MathCaption",
      CellTags->"Related"],
    Cell[770044, 18095, 131, 3, 39, "Input",
      CellTags->"Related"],
    Cell[770178, 18100, 31445, 586, 308, 5030, 254, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Related"],
    Cell[801626, 18688, 87, 3, 38, "Output",
      CellTags->"Related"],
    Cell[801728, 18694, 202, 6, 59, "Text",
      CellTags->{"Related", "i:17"}],
    Cell[801933, 18702, 11137, 320, 219, "DefinitionBox",
      CellTags->{"Related", "i:18"}],
    Cell[813073, 19024, 141, 6, 26, "Caption",
      CellTags->"Related"],
    Cell[813217, 19032, 144, 5, 41, "MathCaption",
      CellTags->"Related"],
    Cell[813386, 19041, 108, 3, 39, "Input",
      CellTags->"Related"],
    Cell[813497, 19046, 89, 3, 38, "Output",
      CellTags->"Related"],
    Cell[813601, 19052, 235, 6, 55, "MathCaption",
      CellTags->"Related"],
    Cell[813861, 19062, 146, 4, 55, "Input",
      CellTags->"Related"],
    Cell[814010, 19068, 94, 3, 38, "Output",
      CellTags->"Related"],
    Cell[814119, 19074, 228, 6, 59, "Text",
      CellTags->{"Related", "i:19"}],
    Cell[814350, 19082, 21281, 598, 290, "DefinitionBox",
      CellTags->{"Related", "i:20"}],
    Cell[835634, 19682, 141, 6, 26, "Caption",
      CellTags->"Related"],
    Cell[835778, 19690, 356, 10, 70, "MathCaption",
      CellTags->"Related"],
    Cell[836159, 19704, 126, 3, 43, "Input",
      CellTags->"Related"],
    Cell[836288, 19709, 86, 3, 38, "Output",
      CellTags->"Related"],
    Cell[836389, 19715, 186, 5, 54, "MathCaption",
      CellTags->"Related"],
    Cell[836600, 19724, 175, 4, 43, "Input",
      CellTags->"Related"],
    Cell[836778, 19730, 86, 3, 26, "Output",
      CellTags->"Related"],
    Cell[836879, 19736, 253, 9, 44, "MathCaption",
      CellTags->"Related"],
    Cell[837157, 19749, 126, 3, 31, "Input",
      CellTags->"Related"],
    Cell[837286, 19754, 93, 3, 28, "Output",
      CellTags->"Related"],
    Cell[837394, 19760, 279, 8, 57, "MathCaption",
      CellTags->"Related"],
    Cell[837698, 19772, 168, 4, 43, "Input",
      CellTags->"Related"],
    Cell[837869, 19778, 25417, 680, 296, 12162, 510, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Related"],
    Cell[863289, 20460, 164, 4, 38, "Output",
      CellTags->"Related"],
    Cell[863468, 20467, 177, 3, 40, "MathCaption",
      CellTags->"Related"],
    Cell[863670, 20474, 96, 3, 39, "Input",
      CellTags->"Related"],
    Cell[863769, 20479, 183, 4, 53, "Output",
      CellTags->"Related"],
    Cell[863967, 20486, 715, 17, 107, "Text",
      CellTags->{"Related", "i:21"}],
    Cell[864685, 20505, 5957, 170, 158, "DefinitionBox",
      CellTags->{"Related", "i:22"}],
    Cell[870645, 20677, 141, 6, 26, "Caption",
      CellTags->"Related"],
    Cell[870789, 20685, 163, 4, 54, "MathCaption",
      CellTags->"Related"],
    Cell[870977, 20693, 148, 4, 55, "Input",
      CellTags->"Related"],
    Cell[871128, 20699, 87, 3, 38, "Output",
      CellTags->"Related"],
    Cell[871230, 20705, 143, 4, 54, "MathCaption",
      CellTags->"Related"],
    Cell[871398, 20713, 132, 3, 39, "Input",
      CellTags->"Related"],
    Cell[871533, 20718, 429, 7, 128, "Output",
      CellTags->"Related"],
    Cell[871977, 20728, 514, 10, 108, "Text",
      CellTags->{"Related", "i:23"}],
    Cell[872494, 20740, 13699, 374, 252, "DefinitionBox",
      CellTags->{"Related", "i:24"}],
    Cell[886196, 21116, 60, 1, 26, "Caption",
      CellTags->"Related"],
    Cell[886259, 21119, 386, 10, 76, "Text",
      CellTags->"Related"],
    Cell[886648, 21131, 254, 9, 56, "MathCaption",
      CellTags->"Related"],
    Cell[886927, 21144, 101, 3, 39, "Input",
      CellTags->"Related"],
    Cell[887031, 21149, 86, 3, 38, "Output",
      CellTags->"Related"],
    Cell[887132, 21155, 319, 10, 70, "MathCaption",
      CellTags->"Related"],
    Cell[887476, 21169, 104, 3, 39, "Input",
      CellTags->"Related"],
    Cell[887583, 21174, 344, 7, 98, "Output",
      CellTags->"Related"],
    Cell[887942, 21184, 261, 11, 56, "MathCaption",
      CellTags->"Related"],
    Cell[888228, 21199, 109, 3, 39, "Input",
      CellTags->"Related"],
    Cell[888340, 21204, 87, 3, 38, "Output",
      CellTags->"Related"],
    Cell[888442, 21210, 78, 1, 40, "MathCaption",
      CellTags->"Related"],
    Cell[888545, 21215, 130, 3, 39, "Input",
      CellTags->"Related"],
    Cell[888678, 21220, 121, 3, 38, "Output",
      CellTags->"Related"],
    Cell[888814, 21226, 75, 1, 40, "MathCaption",
      CellTags->"Related"],
    Cell[888914, 21231, 123, 3, 27, "Input",
      CellTags->"Related"],
    Cell[889040, 21236, 101, 3, 26, "Output",
      CellTags->"Related"]},
  "i:16"->{
    Cell[765475, 17960, 4041, 109, 64, "DefinitionBox",
      CellTags->{"Related", "i:16"}]},
  "i:17"->{
    Cell[801728, 18694, 202, 6, 59, "Text",
      CellTags->{"Related", "i:17"}]},
  "i:18"->{
    Cell[801933, 18702, 11137, 320, 219, "DefinitionBox",
      CellTags->{"Related", "i:18"}]},
  "i:19"->{
    Cell[814119, 19074, 228, 6, 59, "Text",
      CellTags->{"Related", "i:19"}]},
  "i:20"->{
    Cell[814350, 19082, 21281, 598, 290, "DefinitionBox",
      CellTags->{"Related", "i:20"}]},
  "i:21"->{
    Cell[863967, 20486, 715, 17, 107, "Text",
      CellTags->{"Related", "i:21"}]},
  "i:22"->{
    Cell[864685, 20505, 5957, 170, 158, "DefinitionBox",
      CellTags->{"Related", "i:22"}]},
  "i:23"->{
    Cell[871977, 20728, 514, 10, 108, "Text",
      CellTags->{"Related", "i:23"}]},
  "i:24"->{
    Cell[872494, 20740, 13699, 374, 252, "DefinitionBox",
      CellTags->{"Related", "i:24"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"FormGroupoid", 890033, 21265},
  {"First", 895282, 21397},
  {"i:1", 895696, 21410},
  {"i:2", 895803, 21413},
  {"i:3", 895907, 21416},
  {"GenerateGroupoid", 896033, 21419},
  {"i:4", 897827, 21462},
  {"i:5", 897937, 21465},
  {"FormGroupoidByTable", 898068, 21468},
  {"i:6", 899449, 21500},
  {"OtherForm", 899572, 21503},
  {"i:7", 901143, 21543},
  {"i:8", 901246, 21546},
  {"i:9", 901354, 21549},
  {"Structure", 901454, 21552},
  {"i:10", 903910, 21615},
  {"i:11", 904013, 21618},
  {"i:12", 904124, 21621},
  {"FourStandard", 904242, 21624},
  {"i:13", 910439, 21776},
  {"i:14", 910547, 21779},
  {"i:15", 910661, 21782},
  {"Related", 910780, 21785},
  {"i:16", 915839, 21916},
  {"i:17", 915946, 21919},
  {"i:18", 916041, 21922},
  {"i:19", 916150, 21925},
  {"i:20", 916245, 21928},
  {"i:21", 916354, 21931},
  {"i:22", 916451, 21934},
  {"i:23", 916559, 21937},
  {"i:24", 916656, 21940}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 830, 30, 94, "Subsubtitle",
  Evaluatable->False],
Cell[2564, 83, 233, 10, 75, "Section",
  Evaluatable->False,
  CellTags->"FormGroupoid"],
Cell[2800, 95, 60, 1, 36, "Subsection",
  CellTags->"First"],
Cell[2863, 98, 178, 5, 23, "Text",
  CellTags->"First"],
Cell[3044, 105, 146, 4, 26, "Input",
  CellTags->"First"],
Cell[3193, 111, 153, 5, 23, "Text",
  CellTags->"First"],

Cell[CellGroupData[{
Cell[3371, 120, 102, 3, 26, "Input",
  CellTags->"First"],
Cell[3476, 125, 84, 3, 20, "Output",
  CellTags->"First"]
}, Open  ]],
Cell[3575, 131, 130, 5, 36, "Subsection",
  CellTags->"FormGroupoid"],
Cell[3708, 138, 376, 10, 37, "Text",
  CellTags->"FormGroupoid"],
Cell[4087, 150, 7800, 223, 213, "DefinitionBox",
  CellTags->{"FormGroupoid", "i:1"}],
Cell[11890, 375, 141, 6, 26, "Caption",
  CellTags->"FormGroupoid"],
Cell[12034, 383, 139, 5, 60, "Subsubsection",
  CellTags->{"FormGroupoid", "i:2"}],
Cell[12176, 390, 13920, 395, 179, "DefinitionBox",
  CellTags->"FormGroupoid"],
Cell[26099, 787, 145, 6, 26, "Caption",
  CellTags->"FormGroupoid"],
Cell[26247, 795, 435, 9, 91, "Text",
  CellTags->"FormGroupoid"],
Cell[26685, 806, 101, 1, 40, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[26811, 811, 207, 5, 71, "Input",
  CellTags->"FormGroupoid"],
Cell[27021, 818, 96, 3, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[27132, 824, 10869, 313, 400, "DefinitionBox3Col",
  CellTags->{"FormGroupoid", "i:3"}],
Cell[38004, 1139, 137, 6, 14, "Caption",
  CellTags->"FormGroupoid"],
Cell[38144, 1147, 519, 10, 99, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[38688, 1161, 363, 8, 107, "Input",
  CellTags->"FormGroupoid"],
Cell[39054, 1171, 116, 3, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[39185, 1177, 167, 5, 55, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[39377, 1186, 129, 3, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[39509, 1191, 125, 3, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[39649, 1197, 158, 5, 41, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[39832, 1206, 97, 3, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[39932, 1211, 318, 6, 83, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[40265, 1220, 410, 11, 84, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[40700, 1235, 83, 2, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[40786, 1239, 386, 7, 98, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[41187, 1249, 1361, 42, 129, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[42573, 1295, 73, 2, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[42649, 1299, 129, 3, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[42793, 1305, 793, 24, 84, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[43611, 1333, 99, 2, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[43713, 1337, 202, 4, 68, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[43930, 1344, 219, 6, 55, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[44174, 1354, 83, 2, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[44260, 1358, 239, 5, 83, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[44514, 1366, 329, 8, 69, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[44868, 1378, 116, 2, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[44987, 1382, 209, 4, 79, "Print",
  CellTags->"FormGroupoid"],
Cell[45199, 1388, 50213, 792, 308, 3896, 214, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormGroupoid"],
Cell[95415, 2182, 123, 3, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[95553, 2188, 274, 7, 71, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[95852, 2199, 117, 2, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[95972, 2203, 309, 5, 79, "Print",
  CellTags->"FormGroupoid"],
Cell[96284, 2210, 97345, 1956, 308, 15369, 938, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[193644, 4169, 818, 20, 126, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[194487, 4193, 270, 5, 99, "Input",
  CellTags->"FormGroupoid"],
Cell[194760, 4200, 245, 4, 64, "Print",
  CellTags->"FormGroupoid"],
Cell[195008, 4206, 169, 3, 64, "Print",
  CellTags->"FormGroupoid"],
Cell[195180, 4211, 62523, 1056, 308, 6469, 358, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormGroupoid"],
Cell[257706, 5269, 557, 9, 143, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[258278, 5281, 155, 4, 54, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[258458, 5289, 96, 3, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[258557, 5294, 92, 3, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[258664, 5300, 320, 7, 83, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[259009, 5311, 291, 7, 87, "Input",
  CellTags->"FormGroupoid"],
Cell[259303, 5320, 174, 4, 38, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[259492, 5327, 385, 12, 71, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[259902, 5343, 388, 8, 119, "Input",
  CellTags->"FormGroupoid"],
Cell[260293, 5353, 282, 5, 83, "Output",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[260590, 5361, 334, 11, 70, "MathCaption",
  CellTags->"FormGroupoid"],

Cell[CellGroupData[{
Cell[260949, 5376, 134, 3, 39, "Input",
  CellTags->"FormGroupoid"],
Cell[261086, 5381, 471, 7, 124, "Print",
  CellTags->"FormGroupoid"],
Cell[261560, 5390, 85990, 1609, 308, 11236, 680, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormGroupoid"]
}, Open  ]],
Cell[347565, 7002, 147, 5, 60, "Subsubsection",
  CellTags->{"GenerateGroupoid", "i:4"}],
Cell[347715, 7009, 299, 10, 60, "Text",
  CellTags->"GenerateGroupoid"],
Cell[348017, 7021, 462, 12, 94, "Text",
  CellTags->"GenerateGroupoid"],
Cell[348482, 7035, 7668, 213, 111, "DefinitionBox",
  CellTags->"GenerateGroupoid"],
Cell[356153, 7250, 153, 6, 26, "Caption",
  CellTags->"GenerateGroupoid"],
Cell[356309, 7258, 224, 7, 59, "Text",
  CellTags->"GenerateGroupoid"],
Cell[356536, 7267, 705, 22, 84, "DefinitionBox3Col",
  CellTags->{"GenerateGroupoid", "i:5"}],
Cell[357244, 7291, 155, 6, 26, "Caption",
  CellTags->"GenerateGroupoid"],
Cell[357402, 7299, 285, 6, 75, "Text",
  CellTags->"GenerateGroupoid"],
Cell[357690, 7307, 282, 10, 55, "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{
Cell[357997, 7321, 167, 4, 71, "Input",
  CellTags->"GenerateGroupoid"],
Cell[358167, 7327, 131, 3, 38, "Output",
  CellTags->"GenerateGroupoid"]
}, Open  ]],
Cell[358313, 7333, 184, 6, 40, "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{
Cell[358522, 7343, 113, 3, 39, "Input",
  CellTags->"GenerateGroupoid"],
Cell[358638, 7348, 159, 4, 53, "Output",
  CellTags->"GenerateGroupoid"]
}, Open  ]],
Cell[358812, 7355, 256, 8, 56, "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{
Cell[359093, 7367, 284, 6, 87, "Input",
  CellTags->"GenerateGroupoid"],
Cell[359380, 7375, 139, 3, 38, "Output",
  CellTags->"GenerateGroupoid"]
}, Open  ]],
Cell[359534, 7381, 97, 1, 40, "MathCaption",
  CellTags->"GenerateGroupoid"],

Cell[CellGroupData[{
Cell[359656, 7386, 175, 4, 71, "Input",
  CellTags->"GenerateGroupoid"],
Cell[359834, 7392, 307, 6, 98, "Output",
  CellTags->"GenerateGroupoid"]
}, Open  ]],
Cell[360156, 7401, 144, 5, 60, "Subsubsection",
  CellTags->"FormGroupoidByTable"],
Cell[360303, 7408, 444, 8, 107, "Text",
  CellTags->"FormGroupoidByTable"],
Cell[360750, 7418, 8024, 215, 111, "DefinitionBox",
  CellTags->{"FormGroupoidByTable", "i:6"}],
Cell[368777, 7635, 159, 6, 26, "Caption",
  CellTags->"FormGroupoidByTable"],
Cell[368939, 7643, 418, 10, 83, "MathCaption",
  CellTags->"FormGroupoidByTable"],

Cell[CellGroupData[{
Cell[369382, 7657, 105, 3, 39, "Input",
  CellTags->"FormGroupoidByTable"],
Cell[369490, 7662, 220, 4, 67, "Message",
  CellTags->"FormGroupoidByTable"],
Cell[369713, 7668, 139, 3, 38, "Output",
  CellTags->"FormGroupoidByTable"]
}, Open  ]],
Cell[369867, 7674, 392, 11, 68, "MathCaption",
  CellTags->"FormGroupoidByTable"],

Cell[CellGroupData[{
Cell[370284, 7689, 119, 3, 39, "Input",
  CellTags->"FormGroupoidByTable"],
Cell[370406, 7694, 97, 3, 38, "Output",
  CellTags->"FormGroupoidByTable"]
}, Open  ]],
Cell[370518, 7700, 247, 7, 56, "MathCaption",
  CellTags->"FormGroupoidByTable"],

Cell[CellGroupData[{
Cell[370790, 7711, 308, 6, 87, "Input",
  CellTags->"FormGroupoidByTable"],
Cell[371101, 7719, 62770, 973, 308, 4260, 245, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormGroupoidByTable"],
Cell[433874, 8694, 127, 3, 38, "Output",
  CellTags->"FormGroupoidByTable"]
}, Open  ]],
Cell[434016, 8700, 214, 8, 60, "Subsubsection",
  CellTags->{"OtherForm", "i:7"}],
Cell[434233, 8710, 262, 8, 59, "Text",
  CellTags->"OtherForm"],
Cell[434498, 8720, 2436, 68, 77, "DefinitionBox",
  CellTags->"OtherForm"],
Cell[436937, 8790, 138, 6, 26, "Caption",
  CellTags->"OtherForm"],
Cell[437078, 8798, 294, 9, 60, "Text",
  CellTags->"OtherForm"],
Cell[437375, 8809, 753, 23, 84, "DefinitionBox3Col",
  CellTags->{"OtherForm", "i:8"}],
Cell[438131, 8834, 154, 6, 26, "Caption",
  CellTags->"OtherForm"],
Cell[438288, 8842, 201, 5, 54, "MathCaption",
  CellTags->"OtherForm"],

Cell[CellGroupData[{
Cell[438514, 8851, 293, 7, 114, "Input",
  CellTags->"OtherForm"],
Cell[438810, 8860, 287, 5, 98, "Output",
  CellTags->"OtherForm"]
}, Open  ]],
Cell[439112, 8868, 312, 10, 70, "MathCaption",
  CellTags->"OtherForm"],

Cell[CellGroupData[{
Cell[439449, 8882, 100, 2, 39, "Input",
  CellTags->"OtherForm"],
Cell[439552, 8886, 509, 10, 143, "Output",
  CellTags->"OtherForm"]
}, Open  ]],
Cell[440076, 8899, 184, 5, 59, "Text",
  CellTags->{"OtherForm", "i:9"}],
Cell[440263, 8906, 5449, 153, 147, "DefinitionBox",
  CellTags->"OtherForm"],
Cell[445715, 9061, 144, 6, 26, "Caption",
  CellTags->"OtherForm"],
Cell[445862, 9069, 179, 4, 54, "MathCaption",
  CellTags->"OtherForm"],

Cell[CellGroupData[{
Cell[446066, 9077, 212, 4, 71, "Input",
  CellTags->"OtherForm"],
Cell[446281, 9083, 40426, 1087, 122, 12931, 741, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherForm"]
}, Open  ]],
Cell[486722, 10173, 142, 5, 68, "Subsection",
  CellTags->{"Structure", "i:10"}],
Cell[486867, 10180, 1423, 42, 142, "Text",
  CellTags->"Structure"],
Cell[488293, 10224, 10223, 290, 155, "DefinitionBox",
  CellTags->{"Structure", "i:11"}],
Cell[498519, 10516, 164, 6, 26, "Caption",
  CellTags->"Structure"],
Cell[498686, 10524, 98, 1, 40, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[498809, 10529, 112, 3, 39, "Input",
  CellTags->"Structure"],
Cell[498924, 10534, 270, 5, 68, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[499209, 10542, 318, 9, 70, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[499552, 10555, 159, 4, 55, "Input",
  CellTags->"Structure"],
Cell[499714, 10561, 224, 5, 70, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[499953, 10569, 241, 6, 59, "Text",
  CellTags->"Structure"],
Cell[500197, 10577, 9108, 266, 238, "DefinitionBox",
  CellTags->{"Structure", "i:12"}],
Cell[509308, 10845, 93, 1, 26, "Caption",
  CellTags->"Structure"],
Cell[509404, 10848, 187, 7, 41, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[509616, 10859, 246, 6, 71, "Input",
  CellTags->"Structure"],
Cell[509865, 10867, 150, 4, 38, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[510030, 10874, 185, 5, 55, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[510240, 10883, 119, 3, 39, "Input",
  CellTags->"Structure"],
Cell[510362, 10888, 109, 3, 38, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[510486, 10894, 256, 7, 56, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[510767, 10905, 140, 3, 39, "Input",
  CellTags->"Structure"],
Cell[510910, 10910, 185, 4, 53, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[511110, 10917, 346, 7, 83, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[511481, 10928, 145, 4, 55, "Input",
  CellTags->"Structure"],
Cell[511629, 10934, 154, 4, 53, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[511798, 10941, 145, 4, 54, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[511968, 10949, 136, 3, 39, "Input",
  CellTags->"Structure"],
Cell[512107, 10954, 97, 3, 38, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[512219, 10960, 208, 6, 54, "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{
Cell[512452, 10970, 182, 5, 71, "Input",
  CellTags->"Structure"],
Cell[512637, 10977, 132, 3, 38, "Output",
  CellTags->"Structure"]
}, Open  ]],
Cell[512784, 10983, 96, 1, 68, "Subsection",
  CellTags->"FourStandard"],
Cell[512883, 10986, 96, 1, 60, "Subsubsection",
  CellTags->{"FourStandard", "i:13"}],
Cell[512982, 10989, 521, 13, 94, "Text",
  CellTags->"FourStandard"],
Cell[513506, 11004, 11321, 320, 200, "DefinitionBox",
  CellTags->{"FourStandard", "i:14"}],
Cell[524830, 11326, 104, 1, 26, "Caption",
  CellTags->"FourStandard"],
Cell[524937, 11329, 381, 12, 76, "Text",
  CellTags->"FourStandard"],
Cell[525321, 11343, 1424, 44, 131, "DefinitionBox3Col",
  CellTags->{"FourStandard", "i:15"}],
Cell[526748, 11389, 134, 4, 26, "Caption",
  CellTags->"FourStandard"],
Cell[526885, 11395, 523, 16, 94, "Text",
  CellTags->"FourStandard"],
Cell[527411, 11413, 84, 1, 40, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[527520, 11418, 443, 10, 103, "Input",
  CellTags->"FourStandard"],
Cell[527966, 11430, 189, 4, 53, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[528170, 11437, 360, 12, 71, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[528555, 11453, 127, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[528685, 11458, 184, 3, 64, "Print",
  CellTags->"FourStandard"],
Cell[528872, 11463, 209, 4, 79, "Print",
  CellTags->"FourStandard"],
Cell[529084, 11469, 92, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[529191, 11475, 261, 8, 55, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[529477, 11487, 126, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[529606, 11492, 165, 3, 64, "Print",
  CellTags->"FourStandard"],
Cell[529774, 11497, 25078, 549, 308, 5184, 298, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[554855, 12048, 92, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[554962, 12054, 222, 7, 56, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[555209, 12065, 161, 4, 39, "Input",
  CellTags->"FourStandard"],
Cell[555373, 12071, 165, 3, 64, "Print",
  CellTags->"FourStandard"],
Cell[555541, 12076, 90427, 2928, 308, 42068, 2325, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[645971, 15006, 112, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[646098, 15012, 200, 5, 54, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[646323, 15021, 114, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[646440, 15026, 149, 3, 51, "Message",
  CellTags->"FourStandard"],
Cell[646592, 15031, 150, 3, 51, "Message",
  CellTags->"FourStandard"],
Cell[646745, 15036, 144, 3, 35, "Message",
  CellTags->"FourStandard"],
Cell[646892, 15041, 100, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[647007, 15047, 289, 10, 56, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[647321, 15061, 128, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[647452, 15066, 196, 3, 64, "Print",
  CellTags->"FourStandard"],
Cell[647651, 15071, 111, 2, 34, "Print",
  CellTags->"FourStandard"],
Cell[647765, 15075, 94, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[647874, 15081, 173, 5, 55, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[648072, 15090, 138, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[648213, 15095, 31655, 740, 185, 8565, 449, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[679871, 15837, 91, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[679977, 15843, 166, 4, 55, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[680168, 15851, 113, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[680284, 15856, 154, 3, 51, "Message",
  CellTags->"FourStandard"],
Cell[680441, 15861, 188, 4, 51, "Message",
  CellTags->"FourStandard"],
Cell[680632, 15867, 92, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[680739, 15873, 260, 7, 70, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[681024, 15884, 132, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[681159, 15889, 209, 4, 64, "Print",
  CellTags->"FourStandard"],
Cell[681371, 15895, 175, 3, 64, "Print",
  CellTags->"FourStandard"],
Cell[681549, 15900, 92, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[681656, 15906, 296, 8, 69, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[681977, 15918, 166, 4, 55, "Input",
  CellTags->"FourStandard"],
Cell[682146, 15924, 30512, 991, 308, 15701, 802, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[712661, 16917, 111, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[712787, 16923, 199, 5, 55, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[713011, 16932, 132, 3, 39, "Input",
  CellTags->"FourStandard"],
Cell[713146, 16937, 235, 4, 79, "Print",
  CellTags->"FourStandard"],
Cell[713384, 16943, 225, 4, 64, "Print",
  CellTags->"FourStandard"],
Cell[713612, 16949, 176, 3, 64, "Print",
  CellTags->"FourStandard"],
Cell[713791, 16954, 885, 18, 127, "Print",
  CellTags->"FourStandard"],
Cell[714679, 16974, 92, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[714786, 16980, 274, 8, 69, "MathCaption",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[715085, 16992, 131, 3, 39, "Input",
  CellTags->"FourStandard"],

Cell[CellGroupData[{
Cell[715241, 16999, 15640, 284, 164, 1886, 108, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[730884, 17285, 10114, 193, 164, 1358, 79, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[741001, 17480, 10110, 193, 164, 1354, 79, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[751114, 17675, 5822, 116, 164, 865, 49, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"],
Cell[756939, 17793, 8058, 145, 164, 962, 51, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[765012, 17941, 91, 3, 38, "Output",
  CellTags->"FourStandard"]
}, Open  ]],
Cell[765118, 17947, 71, 1, 60, "Subsubsection",
  CellTags->"Related"],
Cell[765192, 17950, 280, 8, 59, "Text",
  CellTags->"Related"],
Cell[765475, 17960, 4041, 109, 64, "DefinitionBox",
  CellTags->{"Related", "i:16"}],
Cell[769519, 18071, 135, 6, 26, "Caption",
  CellTags->"Related"],
Cell[769657, 18079, 362, 12, 70, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[770044, 18095, 131, 3, 39, "Input",
  CellTags->"Related"],
Cell[770178, 18100, 31445, 586, 308, 5030, 254, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Related"],
Cell[801626, 18688, 87, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[801728, 18694, 202, 6, 59, "Text",
  CellTags->{"Related", "i:17"}],
Cell[801933, 18702, 11137, 320, 219, "DefinitionBox",
  CellTags->{"Related", "i:18"}],
Cell[813073, 19024, 141, 6, 26, "Caption",
  CellTags->"Related"],
Cell[813217, 19032, 144, 5, 41, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[813386, 19041, 108, 3, 39, "Input",
  CellTags->"Related"],
Cell[813497, 19046, 89, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[813601, 19052, 235, 6, 55, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[813861, 19062, 146, 4, 55, "Input",
  CellTags->"Related"],
Cell[814010, 19068, 94, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[814119, 19074, 228, 6, 59, "Text",
  CellTags->{"Related", "i:19"}],
Cell[814350, 19082, 21281, 598, 290, "DefinitionBox",
  CellTags->{"Related", "i:20"}],
Cell[835634, 19682, 141, 6, 26, "Caption",
  CellTags->"Related"],
Cell[835778, 19690, 356, 10, 70, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[836159, 19704, 126, 3, 43, "Input",
  CellTags->"Related"],
Cell[836288, 19709, 86, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[836389, 19715, 186, 5, 54, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[836600, 19724, 175, 4, 43, "Input",
  CellTags->"Related"],
Cell[836778, 19730, 86, 3, 26, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[836879, 19736, 253, 9, 44, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[837157, 19749, 126, 3, 31, "Input",
  CellTags->"Related"],
Cell[837286, 19754, 93, 3, 28, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[837394, 19760, 279, 8, 57, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[837698, 19772, 168, 4, 43, "Input",
  CellTags->"Related"],
Cell[837869, 19778, 25417, 680, 296, 12162, 510, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Related"],
Cell[863289, 20460, 164, 4, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[863468, 20467, 177, 3, 40, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[863670, 20474, 96, 3, 39, "Input",
  CellTags->"Related"],
Cell[863769, 20479, 183, 4, 53, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[863967, 20486, 715, 17, 107, "Text",
  CellTags->{"Related", "i:21"}],
Cell[864685, 20505, 5957, 170, 158, "DefinitionBox",
  CellTags->{"Related", "i:22"}],
Cell[870645, 20677, 141, 6, 26, "Caption",
  CellTags->"Related"],
Cell[870789, 20685, 163, 4, 54, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[870977, 20693, 148, 4, 55, "Input",
  CellTags->"Related"],
Cell[871128, 20699, 87, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[871230, 20705, 143, 4, 54, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[871398, 20713, 132, 3, 39, "Input",
  CellTags->"Related"],
Cell[871533, 20718, 429, 7, 128, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[871977, 20728, 514, 10, 108, "Text",
  CellTags->{"Related", "i:23"}],
Cell[872494, 20740, 13699, 374, 252, "DefinitionBox",
  CellTags->{"Related", "i:24"}],
Cell[886196, 21116, 60, 1, 26, "Caption",
  CellTags->"Related"],
Cell[886259, 21119, 386, 10, 76, "Text",
  CellTags->"Related"],
Cell[886648, 21131, 254, 9, 56, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[886927, 21144, 101, 3, 39, "Input",
  CellTags->"Related"],
Cell[887031, 21149, 86, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[887132, 21155, 319, 10, 70, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[887476, 21169, 104, 3, 39, "Input",
  CellTags->"Related"],
Cell[887583, 21174, 344, 7, 98, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[887942, 21184, 261, 11, 56, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[888228, 21199, 109, 3, 39, "Input",
  CellTags->"Related"],
Cell[888340, 21204, 87, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[888442, 21210, 78, 1, 40, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[888545, 21215, 130, 3, 39, "Input",
  CellTags->"Related"],
Cell[888678, 21220, 121, 3, 38, "Output",
  CellTags->"Related"]
}, Open  ]],
Cell[888814, 21226, 75, 1, 40, "MathCaption",
  CellTags->"Related"],

Cell[CellGroupData[{
Cell[888914, 21231, 123, 3, 27, "Input",
  CellTags->"Related"],
Cell[889040, 21236, 101, 3, 26, "Output",
  CellTags->"Related"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

