(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1165895,      26856]*)
(*NotebookOutlinePosition[   1192821,      27559]*)
(*  CellTagsIndexPosition[   1191896,      27523]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  "Chapter 2\n",
  StyleBox["Groupoids",
    FontFamily->"Courier"]
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell["2.6 Building other structures", "Subsection",
  CellTags->{"DirectProducts", "i:1"}],

Cell["\<\
When given an algebraic structure, such as a group, three questions \
naturally arise.\
\>", "Text",
  CellTags->"DirectProducts"],

Cell[TextData[{
  "1. Can we take two structures, ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ", and build a new structure based on them? \n2. Given a structure ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and a subset ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of this structure, under what conditions is ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " itself a structure of the same type?\n3. Given a structure ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and a structure ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " that is also a subset of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", can we form a quotient structure ",
  Cell[BoxData[
      \(TraditionalForm\`G/H\)]],
  "?"
}], "Text",
  CellMargins->{{36, 36}, {Inherited, Inherited}}],

Cell["In this section we explore these three questions.", "Text"],

Cell["2.6.1 Direct products", "Subsubsection",
  CellTags->{"DirectProducts", "i:2"}],

Cell["\<\
For groups, the answer to the first question is to form the direct \
product or direct sum of the groups.\
\>", "Text",
  CellTags->"DirectProducts"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DirectProduct",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", "\[Ellipsis]", 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(G\_n\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["direct",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["product",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], " ", "groupoids", 
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(G\_n\),
                      "TraditionalForm"],
                    "Text"]}]}]}]},
          {
            RowBox[{
              StyleBox["DirectSum",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", "\[Ellipsis]", 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(G\_n\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["DirectProduct",
                    "MR"], 
                  StyleBox["[",
                    "Text"], 
                  RowBox[{
                    StyleBox[
                      FormBox[\(G\_1\),
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[\(G\_2\),
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[\(\(\ \(\[Ellipsis], \)\)\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[\(G\_n\),
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox["]",
                    SingleLetterItalics->False]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"DirectProducts", "i:3"}],

Cell["How to form the direct product of several groupoids.", "Caption",
  CellTags->"DirectProducts"],

Cell[TextData[{
  "Consider the following groupoids. Note that ",
  StyleBox["DirectSum", "MR"],
  " and ",
  StyleBox["DirectProduct", "MR"],
  " are functionally equivalent."
}], "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \({G1 = DirectSum[Z[4], Z[4, 2]], \nG2 = DirectProduct[Z[3], Z[2, I]]}
      \)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \({Groupoid[{{0, 0}, {0, 2}, {1, 0}, {1, 2}, {2, 0}, {2, 2}, {3, 0}, {3, 
            2}}, "-Operation-"], 
      Groupoid[{{0, 0}, {0, I}, {0, 1}, {0, 1 + I}, {1, 0}, {1, I}, {1, 1}, {
            1, 1 + I}, {2, 0}, {2, I}, {2, 1}, {2, 1 + I}}, "-Operation-"]}
      \)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s pick two elements at random from ",
  StyleBox["G1", "MR"],
  "."
}], "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, \ b}\  = \ RandomElements[G1, \ 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \({{0, 2}, {1, 2}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell[TextData[{
  "The operation of a direct product uses the operation of groupoid ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " in the ",
  StyleBox["i",
    FontSlant->"Italic"],
  "th coordinate."
}], "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Operation[G1]\)[a, b]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \({1, 0}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell["\<\
When the Cayley table of a direct product is formed, the elements \
are automatically considered as being wide, thus invoking a key.\
\>", 
  "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[G2, \ Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \("KEY for Z[3] x Z[2, I]: label used \[Rule] element: {g1 \[Rule] {0, \
0}, g2 \[Rule] {0, I}, g3 \[Rule] {0, 1}, g4 \[Rule] {0, 1 + I}, g5 \[Rule] \
{1, 0}, g6 \[Rule] {1, I}, g7 \[Rule] {1, 1}, g8 \[Rule] {1, 1 + I}, g9 \
\[Rule] {2, 0}, g10 \[Rule] {2, I}, g11 \[Rule] {2, 1}, g12 \[Rule] {2, 1 + \
I}}"\)], "Print",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \("For each element, a different color is used. The entries in the table \
corresponding to the elements are then colored and labeled accordingly."\)], 
  "Print",
  CellTags->"DirectProducts"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03846 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0970696 0.0732601 0.0247253 0.0732601 [
[ 0 0 0 0 ]
[ 1 1.03846 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.03846 L
0 1.03846 L
closepath
clip
newpath
1 1 0 r
.09707 .83059 m
.09707 .90385 L
.17033 .90385 L
.17033 .83059 L
F
.17033 .75733 m
.17033 .83059 L
.24359 .83059 L
.24359 .75733 L
F
.24359 .68407 m
.24359 .75733 L
.31685 .75733 L
.31685 .68407 L
F
.31685 .61081 m
.31685 .68407 L
.39011 .68407 L
.39011 .61081 L
F
.68315 .53755 m
.68315 .61081 L
.75641 .61081 L
.75641 .53755 L
F
.75641 .46429 m
.75641 .53755 L
.82967 .53755 L
.82967 .46429 L
F
.82967 .39103 m
.82967 .46429 L
.90293 .46429 L
.90293 .39103 L
F
.90293 .31777 m
.90293 .39103 L
.97619 .39103 L
.97619 .31777 L
F
.39011 .24451 m
.39011 .31777 L
.46337 .31777 L
.46337 .24451 L
F
.46337 .17125 m
.46337 .24451 L
.53663 .24451 L
.53663 .17125 L
F
.53663 .09799 m
.53663 .17125 L
.60989 .17125 L
.60989 .09799 L
F
.60989 .02473 m
.60989 .09799 L
.68315 .09799 L
.68315 .02473 L
F
1 .5 0 r
.17033 .83059 m
.17033 .90385 L
.24359 .90385 L
.24359 .83059 L
F
.09707 .75733 m
.09707 .83059 L
.17033 .83059 L
.17033 .75733 L
F
.31685 .68407 m
.31685 .75733 L
.39011 .75733 L
.39011 .68407 L
F
.24359 .61081 m
.24359 .68407 L
.31685 .68407 L
.31685 .61081 L
F
.75641 .53755 m
.75641 .61081 L
.82967 .61081 L
.82967 .53755 L
F
.68315 .46429 m
.68315 .53755 L
.75641 .53755 L
.75641 .46429 L
F
.90293 .39103 m
.90293 .46429 L
.97619 .46429 L
.97619 .39103 L
F
.82967 .31777 m
.82967 .39103 L
.90293 .39103 L
.90293 .31777 L
F
.46337 .24451 m
.46337 .31777 L
.53663 .31777 L
.53663 .24451 L
F
.39011 .17125 m
.39011 .24451 L
.46337 .24451 L
.46337 .17125 L
F
.60989 .09799 m
.60989 .17125 L
.68315 .17125 L
.68315 .09799 L
F
.53663 .02473 m
.53663 .09799 L
.60989 .09799 L
.60989 .02473 L
F
.56 .37 .6 r
.24359 .83059 m
.24359 .90385 L
.31685 .90385 L
.31685 .83059 L
F
.31685 .75733 m
.31685 .83059 L
.39011 .83059 L
.39011 .75733 L
F
.09707 .68407 m
.09707 .75733 L
.17033 .75733 L
.17033 .68407 L
F
.17033 .61081 m
.17033 .68407 L
.24359 .68407 L
.24359 .61081 L
F
.82967 .53755 m
.82967 .61081 L
.90293 .61081 L
.90293 .53755 L
F
.90293 .46429 m
.90293 .53755 L
.97619 .53755 L
.97619 .46429 L
F
.68315 .39103 m
.68315 .46429 L
.75641 .46429 L
.75641 .39103 L
F
.75641 .31777 m
.75641 .39103 L
.82967 .39103 L
.82967 .31777 L
F
.53663 .24451 m
.53663 .31777 L
.60989 .31777 L
.60989 .24451 L
F
.60989 .17125 m
.60989 .24451 L
.68315 .24451 L
.68315 .17125 L
F
.39011 .09799 m
.39011 .17125 L
.46337 .17125 L
.46337 .09799 L
F
.46337 .02473 m
.46337 .09799 L
.53663 .09799 L
.53663 .02473 L
F
0 0 1 r
.31685 .83059 m
.31685 .90385 L
.39011 .90385 L
.39011 .83059 L
F
.24359 .75733 m
.24359 .83059 L
.31685 .83059 L
.31685 .75733 L
F
.17033 .68407 m
.17033 .75733 L
.24359 .75733 L
.24359 .68407 L
F
.09707 .61081 m
.09707 .68407 L
.17033 .68407 L
.17033 .61081 L
F
.90293 .53755 m
.90293 .61081 L
.97619 .61081 L
.97619 .53755 L
F
.82967 .46429 m
.82967 .53755 L
.90293 .53755 L
.90293 .46429 L
F
.75641 .39103 m
.75641 .46429 L
.82967 .46429 L
.82967 .39103 L
F
.68315 .31777 m
.68315 .39103 L
.75641 .39103 L
.75641 .31777 L
F
.60989 .24451 m
.60989 .31777 L
.68315 .31777 L
.68315 .24451 L
F
.53663 .17125 m
.53663 .24451 L
.60989 .24451 L
.60989 .17125 L
F
.46337 .09799 m
.46337 .17125 L
.53663 .17125 L
.53663 .09799 L
F
.39011 .02473 m
.39011 .09799 L
.46337 .09799 L
.46337 .02473 L
F
.74 .99 .79 r
.39011 .83059 m
.39011 .90385 L
.46337 .90385 L
.46337 .83059 L
F
.46337 .75733 m
.46337 .83059 L
.53663 .83059 L
.53663 .75733 L
F
.53663 .68407 m
.53663 .75733 L
.60989 .75733 L
.60989 .68407 L
F
.60989 .61081 m
.60989 .68407 L
.68315 .68407 L
.68315 .61081 L
F
.09707 .53755 m
.09707 .61081 L
.17033 .61081 L
.17033 .53755 L
F
.17033 .46429 m
.17033 .53755 L
.24359 .53755 L
.24359 .46429 L
F
.24359 .39103 m
.24359 .46429 L
.31685 .46429 L
.31685 .39103 L
F
.31685 .31777 m
.31685 .39103 L
.39011 .39103 L
.39011 .31777 L
F
.68315 .24451 m
.68315 .31777 L
.75641 .31777 L
.75641 .24451 L
F
.75641 .17125 m
.75641 .24451 L
.82967 .24451 L
.82967 .17125 L
F
.82967 .09799 m
.82967 .17125 L
.90293 .17125 L
.90293 .09799 L
F
.90293 .02473 m
.90293 .09799 L
.97619 .09799 L
.97619 .02473 L
F
.251 .878 .816 r
.46337 .83059 m
.46337 .90385 L
.53663 .90385 L
.53663 .83059 L
F
.39011 .75733 m
.39011 .83059 L
.46337 .83059 L
.46337 .75733 L
F
.60989 .68407 m
.60989 .75733 L
.68315 .75733 L
.68315 .68407 L
F
.53663 .61081 m
.53663 .68407 L
.60989 .68407 L
.60989 .61081 L
F
.17033 .53755 m
.17033 .61081 L
.24359 .61081 L
.24359 .53755 L
F
.09707 .46429 m
.09707 .53755 L
.17033 .53755 L
.17033 .46429 L
F
.31685 .39103 m
.31685 .46429 L
.39011 .46429 L
.39011 .39103 L
F
.24359 .31777 m
.24359 .39103 L
.31685 .39103 L
.31685 .31777 L
F
.75641 .24451 m
.75641 .31777 L
.82967 .31777 L
.82967 .24451 L
F
.68315 .17125 m
.68315 .24451 L
.75641 .24451 L
.75641 .17125 L
F
.90293 .09799 m
.90293 .17125 L
.97619 .17125 L
.97619 .09799 L
F
.82967 .02473 m
.82967 .09799 L
.90293 .09799 L
.90293 .02473 L
F
0 .79 .34 r
.53663 .83059 m
.53663 .90385 L
.60989 .90385 L
.60989 .83059 L
F
.60989 .75733 m
.60989 .83059 L
.68315 .83059 L
.68315 .75733 L
F
.39011 .68407 m
.39011 .75733 L
.46337 .75733 L
.46337 .68407 L
F
.46337 .61081 m
.46337 .68407 L
.53663 .68407 L
.53663 .61081 L
F
.24359 .53755 m
.24359 .61081 L
.31685 .61081 L
.31685 .53755 L
F
.31685 .46429 m
.31685 .53755 L
.39011 .53755 L
.39011 .46429 L
F
.09707 .39103 m
.09707 .46429 L
.17033 .46429 L
.17033 .39103 L
F
.17033 .31777 m
.17033 .39103 L
.24359 .39103 L
.24359 .31777 L
F
.82967 .24451 m
.82967 .31777 L
.90293 .31777 L
.90293 .24451 L
F
.90293 .17125 m
.90293 .24451 L
.97619 .24451 L
.97619 .17125 L
F
.68315 .09799 m
.68315 .17125 L
.75641 .17125 L
.75641 .09799 L
F
.75641 .02473 m
.75641 .09799 L
.82967 .09799 L
.82967 .02473 L
F
0 .392 0 r
.60989 .83059 m
.60989 .90385 L
.68315 .90385 L
.68315 .83059 L
F
.53663 .75733 m
.53663 .83059 L
.60989 .83059 L
.60989 .75733 L
F
.46337 .68407 m
.46337 .75733 L
.53663 .75733 L
.53663 .68407 L
F
.39011 .61081 m
.39011 .68407 L
.46337 .68407 L
.46337 .61081 L
F
.31685 .53755 m
.31685 .61081 L
.39011 .61081 L
.39011 .53755 L
F
.24359 .46429 m
.24359 .53755 L
.31685 .53755 L
.31685 .46429 L
F
.17033 .39103 m
.17033 .46429 L
.24359 .46429 L
.24359 .39103 L
F
.09707 .31777 m
.09707 .39103 L
.17033 .39103 L
.17033 .31777 L
F
.90293 .24451 m
.90293 .31777 L
.97619 .31777 L
.97619 .24451 L
F
.82967 .17125 m
.82967 .24451 L
.90293 .24451 L
.90293 .17125 L
F
.75641 .09799 m
.75641 .17125 L
.82967 .17125 L
.82967 .09799 L
F
.68315 .02473 m
.68315 .09799 L
.75641 .09799 L
.75641 .02473 L
F
1 .753 .796 r
.68315 .83059 m
.68315 .90385 L
.75641 .90385 L
.75641 .83059 L
F
.75641 .75733 m
.75641 .83059 L
.82967 .83059 L
.82967 .75733 L
F
.82967 .68407 m
.82967 .75733 L
.90293 .75733 L
.90293 .68407 L
F
.90293 .61081 m
.90293 .68407 L
.97619 .68407 L
.97619 .61081 L
F
.39011 .53755 m
.39011 .61081 L
.46337 .61081 L
.46337 .53755 L
F
.46337 .46429 m
.46337 .53755 L
.53663 .53755 L
.53663 .46429 L
F
.53663 .39103 m
.53663 .46429 L
.60989 .46429 L
.60989 .39103 L
F
.60989 .31777 m
.60989 .39103 L
.68315 .39103 L
.68315 .31777 L
F
.09707 .24451 m
.09707 .31777 L
.17033 .31777 L
.17033 .24451 L
F
.17033 .17125 m
.17033 .24451 L
.24359 .24451 L
.24359 .17125 L
F
.24359 .09799 m
.24359 .17125 L
.31685 .17125 L
.31685 .09799 L
F
.31685 .02473 m
.31685 .09799 L
.39011 .09799 L
.39011 .02473 L
F
.678 .847 .902 r
.75641 .83059 m
.75641 .90385 L
.82967 .90385 L
.82967 .83059 L
F
.68315 .75733 m
.68315 .83059 L
.75641 .83059 L
.75641 .75733 L
F
.90293 .68407 m
.90293 .75733 L
.97619 .75733 L
.97619 .68407 L
F
.82967 .61081 m
.82967 .68407 L
.90293 .68407 L
.90293 .61081 L
F
.46337 .53755 m
.46337 .61081 L
.53663 .61081 L
.53663 .53755 L
F
.39011 .46429 m
.39011 .53755 L
.46337 .53755 L
.46337 .46429 L
F
.60989 .39103 m
.60989 .46429 L
.68315 .46429 L
.68315 .39103 L
F
.53663 .31777 m
.53663 .39103 L
.60989 .39103 L
.60989 .31777 L
F
.17033 .24451 m
.17033 .31777 L
.24359 .31777 L
.24359 .24451 L
F
.09707 .17125 m
.09707 .24451 L
.17033 .24451 L
.17033 .17125 L
F
.31685 .09799 m
.31685 .17125 L
.39011 .17125 L
.39011 .09799 L
F
.24359 .02473 m
.24359 .09799 L
.31685 .09799 L
.31685 .02473 L
F
.89 .81 .34 r
.82967 .83059 m
.82967 .90385 L
.90293 .90385 L
.90293 .83059 L
F
.90293 .75733 m
.90293 .83059 L
.97619 .83059 L
.97619 .75733 L
F
.68315 .68407 m
.68315 .75733 L
.75641 .75733 L
.75641 .68407 L
F
.75641 .61081 m
.75641 .68407 L
.82967 .68407 L
.82967 .61081 L
F
.53663 .53755 m
.53663 .61081 L
.60989 .61081 L
.60989 .53755 L
F
.60989 .46429 m
.60989 .53755 L
.68315 .53755 L
.68315 .46429 L
F
.39011 .39103 m
.39011 .46429 L
.46337 .46429 L
.46337 .39103 L
F
.46337 .31777 m
.46337 .39103 L
.53663 .39103 L
.53663 .31777 L
F
.24359 .24451 m
.24359 .31777 L
.31685 .31777 L
.31685 .24451 L
F
.31685 .17125 m
.31685 .24451 L
.39011 .24451 L
.39011 .17125 L
F
.09707 .09799 m
.09707 .17125 L
.17033 .17125 L
.17033 .09799 L
F
.17033 .02473 m
.17033 .09799 L
.24359 .09799 L
.24359 .02473 L
F
0 1 0 r
.90293 .83059 m
.90293 .90385 L
.97619 .90385 L
.97619 .83059 L
F
.82967 .75733 m
.82967 .83059 L
.90293 .83059 L
.90293 .75733 L
F
.75641 .68407 m
.75641 .75733 L
.82967 .75733 L
.82967 .68407 L
F
.68315 .61081 m
.68315 .68407 L
.75641 .68407 L
.75641 .61081 L
F
.60989 .53755 m
.60989 .61081 L
.68315 .61081 L
.68315 .53755 L
F
.53663 .46429 m
.53663 .53755 L
.60989 .53755 L
.60989 .46429 L
F
.46337 .39103 m
.46337 .46429 L
.53663 .46429 L
.53663 .39103 L
F
.39011 .31777 m
.39011 .39103 L
.46337 .39103 L
.46337 .31777 L
F
.31685 .24451 m
.31685 .31777 L
.39011 .31777 L
.39011 .24451 L
F
.24359 .17125 m
.24359 .24451 L
.31685 .24451 L
.31685 .17125 L
F
.17033 .09799 m
.17033 .17125 L
.24359 .17125 L
.24359 .09799 L
F
.09707 .02473 m
.09707 .09799 L
.17033 .09799 L
.17033 .02473 L
F
1 1 0 r
.09707 .90385 m
.09707 .97711 L
.17033 .97711 L
.17033 .90385 L
F
1 .5 0 r
.17033 .90385 m
.17033 .97711 L
.24359 .97711 L
.24359 .90385 L
F
.56 .37 .6 r
.24359 .90385 m
.24359 .97711 L
.31685 .97711 L
.31685 .90385 L
F
0 0 1 r
.31685 .90385 m
.31685 .97711 L
.39011 .97711 L
.39011 .90385 L
F
.74 .99 .79 r
.39011 .90385 m
.39011 .97711 L
.46337 .97711 L
.46337 .90385 L
F
.251 .878 .816 r
.46337 .90385 m
.46337 .97711 L
.53663 .97711 L
.53663 .90385 L
F
0 .79 .34 r
.53663 .90385 m
.53663 .97711 L
.60989 .97711 L
.60989 .90385 L
F
0 .392 0 r
.60989 .90385 m
.60989 .97711 L
.68315 .97711 L
.68315 .90385 L
F
1 .753 .796 r
.68315 .90385 m
.68315 .97711 L
.75641 .97711 L
.75641 .90385 L
F
.678 .847 .902 r
.75641 .90385 m
.75641 .97711 L
.82967 .97711 L
.82967 .90385 L
F
.89 .81 .34 r
.82967 .90385 m
.82967 .97711 L
.90293 .97711 L
.90293 .90385 L
F
0 1 0 r
.90293 .90385 m
.90293 .97711 L
.97619 .97711 L
.97619 .90385 L
F
1 1 0 r
.02381 .83059 m
.02381 .90385 L
.09707 .90385 L
.09707 .83059 L
F
1 .5 0 r
.02381 .75733 m
.02381 .83059 L
.09707 .83059 L
.09707 .75733 L
F
.56 .37 .6 r
.02381 .68407 m
.02381 .75733 L
.09707 .75733 L
.09707 .68407 L
F
0 0 1 r
.02381 .61081 m
.02381 .68407 L
.09707 .68407 L
.09707 .61081 L
F
.74 .99 .79 r
.02381 .53755 m
.02381 .61081 L
.09707 .61081 L
.09707 .53755 L
F
.251 .878 .816 r
.02381 .46429 m
.02381 .53755 L
.09707 .53755 L
.09707 .46429 L
F
0 .79 .34 r
.02381 .39103 m
.02381 .46429 L
.09707 .46429 L
.09707 .39103 L
F
0 .392 0 r
.02381 .31777 m
.02381 .39103 L
.09707 .39103 L
.09707 .31777 L
F
1 .753 .796 r
.02381 .24451 m
.02381 .31777 L
.09707 .31777 L
.09707 .24451 L
F
.678 .847 .902 r
.02381 .17125 m
.02381 .24451 L
.09707 .24451 L
.09707 .17125 L
F
.89 .81 .34 r
.02381 .09799 m
.02381 .17125 L
.09707 .17125 L
.09707 .09799 L
F
0 1 0 r
.02381 .02473 m
.02381 .09799 L
.09707 .09799 L
.09707 .02473 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02473 m
.02381 .97711 L
s
.02381 .02473 m
.97619 .02473 L
s
.02381 .09799 m
.97619 .09799 L
s
.02381 .17125 m
.97619 .17125 L
s
.02381 .24451 m
.97619 .24451 L
s
.02381 .31777 m
.97619 .31777 L
s
.02381 .39103 m
.97619 .39103 L
s
.02381 .46429 m
.97619 .46429 L
s
.02381 .53755 m
.97619 .53755 L
s
.02381 .61081 m
.97619 .61081 L
s
.02381 .68407 m
.97619 .68407 L
s
.02381 .75733 m
.97619 .75733 L
s
.02381 .83059 m
.97619 .83059 L
s
.02381 .90385 m
.97619 .90385 L
s
.02381 .97711 m
.97619 .97711 L
s
.09707 .02473 m
.09707 .97711 L
s
.17033 .02473 m
.17033 .97711 L
s
.24359 .02473 m
.24359 .97711 L
s
.31685 .02473 m
.31685 .97711 L
s
.39011 .02473 m
.39011 .97711 L
s
.46337 .02473 m
.46337 .97711 L
s
.53663 .02473 m
.53663 .97711 L
s
.60989 .02473 m
.60989 .97711 L
s
.68315 .02473 m
.68315 .97711 L
s
.75641 .02473 m
.75641 .97711 L
s
.82967 .02473 m
.82967 .97711 L
s
.90293 .02473 m
.90293 .97711 L
s
.97619 .02473 m
.97619 .97711 L
s
.02381 .97711 m
.09707 .90385 L
s
2.6 Mabswid
.09707 .02473 m
.09707 .97711 L
s
.02381 .90385 m
.97619 .90385 L
s
[(g1)] .1337 .86722 0 0 Mshowa
[(g2)] .20696 .86722 0 0 Mshowa
[(g3)] .28022 .86722 0 0 Mshowa
[(g4)] .35348 .86722 0 0 Mshowa
[(g5)] .42674 .86722 0 0 Mshowa
[(g6)] .5 .86722 0 0 Mshowa
[(g7)] .57326 .86722 0 0 Mshowa
[(g8)] .64652 .86722 0 0 Mshowa
[(g9)] .71978 .86722 0 0 Mshowa
[(g10)] .79304 .86722 0 0 Mshowa
[(g11)] .8663 .86722 0 0 Mshowa
[(g12)] .93956 .86722 0 0 Mshowa
[(g2)] .1337 .79396 0 0 Mshowa
[(g1)] .20696 .79396 0 0 Mshowa
[(g4)] .28022 .79396 0 0 Mshowa
[(g3)] .35348 .79396 0 0 Mshowa
[(g6)] .42674 .79396 0 0 Mshowa
[(g5)] .5 .79396 0 0 Mshowa
[(g8)] .57326 .79396 0 0 Mshowa
[(g7)] .64652 .79396 0 0 Mshowa
[(g10)] .71978 .79396 0 0 Mshowa
[(g9)] .79304 .79396 0 0 Mshowa
[(g12)] .8663 .79396 0 0 Mshowa
[(g11)] .93956 .79396 0 0 Mshowa
[(g3)] .1337 .7207 0 0 Mshowa
[(g4)] .20696 .7207 0 0 Mshowa
[(g1)] .28022 .7207 0 0 Mshowa
[(g2)] .35348 .7207 0 0 Mshowa
[(g7)] .42674 .7207 0 0 Mshowa
[(g8)] .5 .7207 0 0 Mshowa
[(g5)] .57326 .7207 0 0 Mshowa
[(g6)] .64652 .7207 0 0 Mshowa
[(g11)] .71978 .7207 0 0 Mshowa
[(g12)] .79304 .7207 0 0 Mshowa
[(g9)] .8663 .7207 0 0 Mshowa
[(g10)] .93956 .7207 0 0 Mshowa
[(g4)] .1337 .64744 0 0 Mshowa
[(g3)] .20696 .64744 0 0 Mshowa
[(g2)] .28022 .64744 0 0 Mshowa
[(g1)] .35348 .64744 0 0 Mshowa
[(g8)] .42674 .64744 0 0 Mshowa
[(g7)] .5 .64744 0 0 Mshowa
[(g6)] .57326 .64744 0 0 Mshowa
[(g5)] .64652 .64744 0 0 Mshowa
[(g12)] .71978 .64744 0 0 Mshowa
[(g11)] .79304 .64744 0 0 Mshowa
[(g10)] .8663 .64744 0 0 Mshowa
[(g9)] .93956 .64744 0 0 Mshowa
[(g5)] .1337 .57418 0 0 Mshowa
[(g6)] .20696 .57418 0 0 Mshowa
[(g7)] .28022 .57418 0 0 Mshowa
[(g8)] .35348 .57418 0 0 Mshowa
[(g9)] .42674 .57418 0 0 Mshowa
[(g10)] .5 .57418 0 0 Mshowa
[(g11)] .57326 .57418 0 0 Mshowa
[(g12)] .64652 .57418 0 0 Mshowa
[(g1)] .71978 .57418 0 0 Mshowa
[(g2)] .79304 .57418 0 0 Mshowa
[(g3)] .8663 .57418 0 0 Mshowa
[(g4)] .93956 .57418 0 0 Mshowa
[(g6)] .1337 .50092 0 0 Mshowa
[(g5)] .20696 .50092 0 0 Mshowa
[(g8)] .28022 .50092 0 0 Mshowa
[(g7)] .35348 .50092 0 0 Mshowa
[(g10)] .42674 .50092 0 0 Mshowa
[(g9)] .5 .50092 0 0 Mshowa
[(g12)] .57326 .50092 0 0 Mshowa
[(g11)] .64652 .50092 0 0 Mshowa
[(g2)] .71978 .50092 0 0 Mshowa
[(g1)] .79304 .50092 0 0 Mshowa
[(g4)] .8663 .50092 0 0 Mshowa
[(g3)] .93956 .50092 0 0 Mshowa
[(g7)] .1337 .42766 0 0 Mshowa
[(g8)] .20696 .42766 0 0 Mshowa
[(g5)] .28022 .42766 0 0 Mshowa
[(g6)] .35348 .42766 0 0 Mshowa
[(g11)] .42674 .42766 0 0 Mshowa
[(g12)] .5 .42766 0 0 Mshowa
[(g9)] .57326 .42766 0 0 Mshowa
[(g10)] .64652 .42766 0 0 Mshowa
[(g3)] .71978 .42766 0 0 Mshowa
[(g4)] .79304 .42766 0 0 Mshowa
[(g1)] .8663 .42766 0 0 Mshowa
[(g2)] .93956 .42766 0 0 Mshowa
[(g8)] .1337 .3544 0 0 Mshowa
[(g7)] .20696 .3544 0 0 Mshowa
[(g6)] .28022 .3544 0 0 Mshowa
[(g5)] .35348 .3544 0 0 Mshowa
[(g12)] .42674 .3544 0 0 Mshowa
[(g11)] .5 .3544 0 0 Mshowa
[(g10)] .57326 .3544 0 0 Mshowa
[(g9)] .64652 .3544 0 0 Mshowa
[(g4)] .71978 .3544 0 0 Mshowa
[(g3)] .79304 .3544 0 0 Mshowa
[(g2)] .8663 .3544 0 0 Mshowa
[(g1)] .93956 .3544 0 0 Mshowa
[(g9)] .1337 .28114 0 0 Mshowa
[(g10)] .20696 .28114 0 0 Mshowa
[(g11)] .28022 .28114 0 0 Mshowa
[(g12)] .35348 .28114 0 0 Mshowa
[(g1)] .42674 .28114 0 0 Mshowa
[(g2)] .5 .28114 0 0 Mshowa
[(g3)] .57326 .28114 0 0 Mshowa
[(g4)] .64652 .28114 0 0 Mshowa
[(g5)] .71978 .28114 0 0 Mshowa
[(g6)] .79304 .28114 0 0 Mshowa
[(g7)] .8663 .28114 0 0 Mshowa
[(g8)] .93956 .28114 0 0 Mshowa
[(g10)] .1337 .20788 0 0 Mshowa
[(g9)] .20696 .20788 0 0 Mshowa
[(g12)] .28022 .20788 0 0 Mshowa
[(g11)] .35348 .20788 0 0 Mshowa
[(g2)] .42674 .20788 0 0 Mshowa
[(g1)] .5 .20788 0 0 Mshowa
[(g4)] .57326 .20788 0 0 Mshowa
[(g3)] .64652 .20788 0 0 Mshowa
[(g6)] .71978 .20788 0 0 Mshowa
[(g5)] .79304 .20788 0 0 Mshowa
[(g8)] .8663 .20788 0 0 Mshowa
[(g7)] .93956 .20788 0 0 Mshowa
[(g11)] .1337 .13462 0 0 Mshowa
[(g12)] .20696 .13462 0 0 Mshowa
[(g9)] .28022 .13462 0 0 Mshowa
[(g10)] .35348 .13462 0 0 Mshowa
[(g3)] .42674 .13462 0 0 Mshowa
[(g4)] .5 .13462 0 0 Mshowa
[(g1)] .57326 .13462 0 0 Mshowa
[(g2)] .64652 .13462 0 0 Mshowa
[(g7)] .71978 .13462 0 0 Mshowa
[(g8)] .79304 .13462 0 0 Mshowa
[(g5)] .8663 .13462 0 0 Mshowa
[(g6)] .93956 .13462 0 0 Mshowa
[(g12)] .1337 .06136 0 0 Mshowa
[(g11)] .20696 .06136 0 0 Mshowa
[(g10)] .28022 .06136 0 0 Mshowa
[(g9)] .35348 .06136 0 0 Mshowa
[(g4)] .42674 .06136 0 0 Mshowa
[(g3)] .5 .06136 0 0 Mshowa
[(g2)] .57326 .06136 0 0 Mshowa
[(g1)] .64652 .06136 0 0 Mshowa
[(g8)] .71978 .06136 0 0 Mshowa
[(g7)] .79304 .06136 0 0 Mshowa
[(g6)] .8663 .06136 0 0 Mshowa
[(g5)] .93956 .06136 0 0 Mshowa
[(g1)] .06044 .86722 0 0 Mshowa
[(g2)] .06044 .79396 0 0 Mshowa
[(g3)] .06044 .7207 0 0 Mshowa
[(g4)] .06044 .64744 0 0 Mshowa
[(g5)] .06044 .57418 0 0 Mshowa
[(g6)] .06044 .50092 0 0 Mshowa
[(g7)] .06044 .42766 0 0 Mshowa
[(g8)] .06044 .3544 0 0 Mshowa
[(g9)] .06044 .28114 0 0 Mshowa
[(g10)] .06044 .20788 0 0 Mshowa
[(g11)] .06044 .13462 0 0 Mshowa
[(g12)] .06044 .06136 0 0 Mshowa
[(g1)] .1337 .94048 0 0 Mshowa
[(g2)] .20696 .94048 0 0 Mshowa
[(g3)] .28022 .94048 0 0 Mshowa
[(g4)] .35348 .94048 0 0 Mshowa
[(g5)] .42674 .94048 0 0 Mshowa
[(g6)] .5 .94048 0 0 Mshowa
[(g7)] .57326 .94048 0 0 Mshowa
[(g8)] .64652 .94048 0 0 Mshowa
[(g9)] .71978 .94048 0 0 Mshowa
[(g10)] .79304 .94048 0 0 Mshowa
[(g11)] .8663 .94048 0 0 Mshowa
[(g12)] .93956 .94048 0 0 Mshowa
[(Z[3] x Z[2, I])] .02381 1.01374 -1 0 Mshowa
gsave
.97619 1.01374 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .04872 .92802 0 0 Mshowa
[(y)] .07875 .95513 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{277.312, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l05P000?l05P000?l05P000?l05P000?l0
5P000?l05P000?l05P0000H0ool9o`L000060003omcL013L0_lDg00monn_kjo_[nn_kjo_[nn_kjo_
[noocPo>3lh?cPo>3lh?cPo>3lh?c_lC0A<14`4C0A<14`4C0A<14`4Co`0DdP0Eogj0OX1nP7j0OX1n
P7j0OX1nP7ko01<A00?ogml04Ml0D_nLdIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/[>b/k:c/[>b/
k:c/og88LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?oPon3oh?oPon3ol700001P000ooLg00@g0;o
5=`0?On_kZo^[nj_kZo^[nj_kZo^[nj_o`oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<1
4`4C0Ol05=80:OmEHUEREF9EHUEREF9EHUEREF9EoelAGa5O4ElAGa5O4ElAGa5O4Eoo01?O00?oG5`0
4U`0?On/k:c/[>b/k:c/[>b/k:c/[>b/oi5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kne_kFo]Kn
e_kFo_l01`0000H000?og=`04=`2oaCL03gokjo_[nn_kjo_[nn_kjo_[nn_koo>3lh?cPo>3lh?cPo>
3lh?cPo>oa<14`4C0A<14`4C0A<14`4C0A?o01CB01GoOX1nP7j0OX1nP7j0OX1nP7j0O_l04a400ooO
g`0Ag`1BoicAW=6LdIcAW=6LdIcAW=6LdIcAonb/k:c/[>b/k:c/[>b/k:c/[>coLPQb2788LPQb2788
LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?o`L000060003omcL013L0_lDg00mojo^[nj_kZo^[nj_
kZo^[nj_kZoo3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1o`0DdP0YoeEREF9E
HUEREF9EHUEREF9EHUGoGa5O4ElAGa5O4ElAGa5O4ElAGol04ml00omLG00BG00mojc/[>b/k:c/[>b/
k:c/[>b/k:coTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kFo]Kne_kFo]Kno`0700001P000ooL
g00@g0;o5=`0?Oo_[nn_kjo_[nn_kjo_[nn_kjo_olh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C
0A<14`4C0A<14ol05=805OmnP7j0OX1nP7j0OX1nP7j0OX1no`0C4@03omoO017O05;oW=6LdIcAW=6L
dIcAW=6LdIcAW=7ok:c/[>b/k:c/[>b/k:c/[>b/k?mb2788LPQb2788LPQb2788LPQbo`on3oh?oPon
3oh?oPon3oh?oPoo1`0000H000?og=`00ol=g0;o0]`3o`oL00?o[nh00ol04Nj_kZo^[nj_kZo^[nj_
o`oe00?o01Ce3oD?m@oe3oD?m@oe3ol14`4C0@?o00`14`4C0A<14`4C0Ol5dP?o3=801_mEHUERE@?o
015EHUEREF9EHUEREOmO4ElAG`03o`0<Ga5O4ElAGa5O4Eoo1Ml3o`_O00?oG5`00e`3o`aL00Ko[>b/
k:`3o`0A[>b/k:c/[>b/k:coTG:ALY400ol04I5bTG:ALY5bTG:AookFo]Kn00?o00cne_kFo]Kne_kF
o_l700001P000ooLg003g003omcL00[L0_l5g003omcL00cL03gokjo_[nookjo_[nn_kjo_[nn_koo>
3lh?c_o>3lh?cPo>3lh?cPo>oa<14`4C0A<1o`4C0A<14`4C0A?o00SB00?od]802M805OmnP7j0OX1n
P?n0OX1nP7j0OX1no`084@03oa4A00PA00?ogml01]l00ooOg`08g`1BoicAW=6LdIcAom6LdIcAW=6L
dIcAonb/k:c/[>b/ojc/[>b/k:c/[>coLPQb2788LPSo2788LPQb2788L_l?oPon3oh?o_on3oh?oPon
3oh?o`L000060003omcL00Co00CLoooo0m`4o`03g?oo00;L1?l01=coool3g0Co0m`00on_kP04o`07
[oooojo^[`03o`06[nj_o`oe1?l020ooool?m@oe0_l02@oe3ol14`4C0@04o`0;4ooooa<14`4C0Ol0
1M84o`;B0ol6dP06oeEREF9E1?l046;ooomREF9EHUGoGa5O4El4o`034Ooo00;o00IO4ElAGol5g`Co
00COoooo1]l00omLG003G0Co0U`2o`ML00Ko[>b/k:`4o`0@k:co[>b/k:c/[?nALY5bT@Co011bTOoo
LY5bTG:AookFo]Kn1?l02mKooooFo]Kne_ko00L000060003omco00?L00Cog=co1M`01?oLg=`2o`03
g?oL00;L00Cog=co1M`00ooLg003g00monookjo_onn_ojo_[nn_ojo_[nooc_o>3lkocPoo3lh?c_o>
3ol?c_lC0A<1o`4C0Ol14`4Coa<14`4Co`04dP05om;Bd_l00m800ooBdP05dP0Eogj0OX3oP7j0oh1n
P7koOX1nP7ko00@A00Go4A4Ao`024@03oa4A00DA00?ogml00]l01OoOgmoo00;O00?ogml01Ml0D_nL
dIcAom6LdOoAom6LoicAW=6LdOo/[>b/ojc/[?n/k?o/[>b/k:c/og88LPSo2788o`So27;oLPQb27;o
3oh?o_on3okooPon3ol?oPon3ol700001P000ooLo`03g004omcLo`KL00?og=`00_l00mcog002g004
omcLo`KL00?og=`00]`0=?n_ojo^[on_k_o^[nj_k_o^[nj_o`oo3oD?o`oeooD?m@oo3oGom@oo0A<1
4olC0A?o4`43o`060A<14`7o1=801_oBd];odPCo1]80:OmEHUERof9EH_mREF9EoeEREF9EoelAGa7o
4ElAoa5O4OlAGa5O4Eoo00CO00GogmoOo`02g`03omoO00GO00?oG5`00U`01omLG5coG?l00U`00omL
G004G00mojc/[>cok:c/onb/k?o/[>b/k:coTG:AL_mbTG;oL_mbTOnALY5bTOone_kFomKne_oFo]Kn
ookFo]Kno`0700001P000ooLo`03g004omcLo`OL00Kog?oog?l3g004omcLo`OL047og=cLonookjo_
onn_ojo_[nn_ojo_[nooc_o>3lkocPoo3lh?c_o>3ol?c_lC0A<1o`4C0Ol1o`4Coa<14`4Co`04dP09
om;Bd_oBom;o00OB00coOX1nP?n0OX3oP7h2o`07P7j0OX1no`044@05oa4A4Ol011400olA4@034@03
omoO00;O00GogmoOo`02g`03omoO00GO00coW=6LdOoAW=7odI`2o`0VdIcAW=6LdOo/[>b/ojc/[?n/
k:co[>b/k:c/og88LPSo2788o`P3o`0A2788LPQbo`on3okooPonooh00ol01oh?oPon3ol01`0000H0
00?og=`01Ol00mcog003g005omcLom`00_l2g0Go00?Lom`00m`01?oLg?l3g003ojo^00Go00o^onj_
kZo^onj_kZoo3oD01Ol04_Gom@oe3ol?mOoe3ol14`4C0@Ko00TC0Ol14`4C0Ol01M86o`03d_oB00KB
00KoEF9EHUD5o`0?EF9EoeEREF9EoelAGa5O00Ko00TAGomO4ElAGol01Ml5o`03gooO00KO00?oG5`0
0e`6o`9L00?oG5`015`01_n/k:c/[0Go00n/k:co[>b/k:coTG:ALY401_l03W:ALY5bTG:AookFo]Kn
1_l02MKne_kFo]Kno`0700001P000ooLg005g0;o1M`2o`;L0_l7g0;o1M`2o`CL00Sokjo_[nn_k`;o
00B_kjo_0_l03:o_[noocPo>3lh?cP;o00D?cPo>3`02o`0?cPo>oa<14`4C0A<14`4C00;o00L14`4C
0A?o00_B0_l7dP0;ogj0OX1nP7j0OX000ol01h1nP7j0O_l02a42o`HA00?ogml02=l2o`OO00coW=6L
dIcAW=6LdI`2o`0BdIcAW=6LdOo/[>b/k:c/[>b/1?l04Nb/k:c/og88LPQb2788LPQb00?o011b2788
L_l?oPon3oh?oPon1?l01Pon3oh?o`L000060003omcL013L0_lDg00mojo^[nj_kZo^[nj_kZo^[nj_
kZoo3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1o`0DdP0YoeEREF9EHUEREF9E
HUEREF9EHUGoGa5O4ElAGa5O4ElAGa5O4ElAGol04ml00omLG00BG00mojc/[>b/k:c/[>b/k:c/[>b/
k:coTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kFo]Kne_kFo]Kno`0700001P000ooLg00@g0;o
5=`0?Oo_[nn_kjo_[nn_kjo_[nn_kjo_olh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C0A<14`4C
0A<14ol05=805OmnP7j0OX1nP7j0OX1nP7j0OX1no`0C4@03omoO017O05;oW=6LdIcAW=6LdIcAW=6L
dIcAW=7ok:c/[>b/k:c/[>b/k:c/[>b/k?mb2788LPQb2788LPQb2788LPQbo`on3oh?oPon3oh?oPon
3oh?oPoo1`0000H000?og=`04=`2oaCL03go[nj_kZo^[nj_kZo^[nj_kZo^[ol?m@oe3oD?m@oe3oD?
m@oe3oD?o`4C0A<14`4C0A<14`4C0A<14`7o01CB02WoEF9EHUEREF9EHUEREF9EHUEREOmO4ElAGa5O
4ElAGa5O4ElAGa5Oo`0Cg`03oeaL019L03go[>b/k:c/[>b/k:c/[>b/k:c/[?nALY5bTG:ALY5bTG:A
LY5bTG:AookFo]Kne_kFo]Kne_kFo]Kne_ko00L000060003omcL013L0_lDg00monn_kjo_[nn_kjo_
[nn_kjo_[noocPo>3lh?cPo>3lh?cPo>3lh?c_lC0A<14`4C0A<14`4C0A<14`4Co`0DdP0Eogj0OX1n
P7j0OX1nP7j0OX1nP7ko01<A00?ogml04Ml0D_nLdIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/[>b/
k:c/[>b/k:c/og88LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?oPon3oh?oPon3ol700001P000ooL
g00@g0;o5=`0?On_kZo^[nj_kZo^[nj_kZo^[nj_o`oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<1
4`4C0A<14`4C0Ol05=80:OmEHUEREF9EHUEREF9EHUEREF9EoelAGa5O4ElAGa5O4ElAGa5O4Eoo01?O
00?oG5`04U`0?On/k:c/[>b/k:c/[>b/k:c/[>b/oi5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kn
e_kFo]Kne_kFo_l01`0000H000?og=`04=`2oaCL03gokjo_[nn_kjo_[nn_kjo_[nn_koo>3lh?cPo>
3lh?cPo>3lh?cPo>oa<14`4C0A<14`4C0A<14`4C0A?o01CB01GoOX1nP7j0OX1nP7j0OX1nP7j0O_l0
4a400ooOg`0Ag`1BoicAW=6LdIcAW=6LdIcAW=6LdIcAonb/k:c/[>b/k:c/[>b/k:c/[>coLPQb2788
LPQb2788LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?o`L000060003omcL013L0_lDg00mojo^[nj_
kZo^[nj_kZo^[nj_kZoo3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1o`0DdP0Y
oeEREF9EHUEREF9EHUEREF9EHUGoGa5O4ElAGa5O4ElAGa5O4ElAGol04ml00omLG00BG00mojc/[>b/
k:c/[>b/k:c/[>b/k:coTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kFo]Kne_kFo]Kno`070000
1P3oo`Wo1`0000H001?okZo^[nj_kZo^[nj_kZo^[nj_00;o01G^[nj_kZo^[nj_kZo^[nj_kZo^[ol0
4m`0?_l14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@ooHUEREF9EHUEREF9EHUER
EF9EHUGo4m800ooOg`0Ag`0ZoelAGa5O4ElAGa5O4ElAGa5O4Eook:c/[>b/k:c/[>b/k:c/[>b/k:co
4e`0:Oone_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:ALY5bTG:ALY5bTG:ALY7o00L00006000Cojo_[nn_
kjo_[nn_kjo_[nn_k`02o`0E[nn_kjo_[nn_kjo_[nn_kjo_[noo01?L03ko4`4C0A<14`4C0A<14`4C
0A<14oo>3lh?cPo>3lh?cPo>3lh?cPo>oh1nP7j0OX1nP7j0OX1nP7j0OX1noa?B00?ogml04Ml00olA
4@0A4@1Bojc/[>b/k:c/[>b/k:c/[>b/k:c/om6LdIcAW=6LdIcAW=6LdIcAW=7o3oh?oPon3oh?oPon
3oh?oPon3omb2788LPQb2788LPQb2788LPQbo`L00006000Conj_kZo^[nj_kZo^[nj_kZo^[`02o`0E
kZo^[nj_kZo^[nj_kZo^[nj_kZoo01?L03ko0A<14`4C0A<14`4C0A<14`4C0Ol?m@oe3oD?m@oe3oD?
m@oe3oD?of9EHUEREF9EHUEREF9EHUEREF9Eoa?B00?ogml04Ml0:_mO4ElAGa5O4ElAGa5O4ElAGa5O
onb/k:c/[>b/k:c/[>b/k:c/[>b/oa=L02Woo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:A
LY5bTG:Ao`0700001P004on_kjo_[nn_kjo_[nn_kjo_[nl00_l05Jo_[nn_kjo_[nn_kjo_[nn_kjo_
o`0Cg00noa<14`4C0A<14`4C0A<14`4C0A?ocPo>3lh?cPo>3lh?cPo>3lh?c_n0OX1nP7j0OX1nP7j0
OX1nP7j0O_lCdP03omoO017O00?o4A404A40D_n/k:c/[>b/k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6L
dIcAW=6LdIcAo`on3oh?oPon3oh?oPon3oh?oPooLPQb2788LPQb2788LPQb2788L_l700001P004oo^
[nj_kZo^[nj_kZo^[nj_kZl00_l05Nj_kZo^[nj_kZo^[nj_kZo^[nj_o`0Cg00no`4C0A<14`4C0A<1
4`4C0A<14`7o3oD?m@oe3oD?m@oe3oD?m@oe3omREF9EHUEREF9EHUEREF9EHUEREOlCdP03omoO017O
02[oGa5O4ElAGa5O4ElAGa5O4ElAGoo/[>b/k:c/[>b/k:c/[>b/k:c/[?lCG00YookFo]Kne_kFo]Kn
e_kFo]Kne_koTG:ALY5bTG:ALY5bTG:ALY5bTOl01`0000H000?o[nl00ol03Nn_kjo_[nn_kjo_[nl0
0_l00jo_o`02o`0@kjo_[nn_kjo_[nn_kjo_o`;L0ol>g006oa<14`4C0ol03Q<14`4C0A<14`4Colh?
0ol050o>3lh?cPo>3lh?cPo>oh1nP7j00ol03H1nP7j0OX1nP7j0O_l01M83o`_B00?ogml00ml3o`_O
00?o4A400a43o`/A00Ko[>b/k:`3o`0B[>b/k:c/[>b/k:c/om6LdIcA0ol04M6LdIcAW=6LdIcAo`on
3oh?00?o014?oPon3oh?oPon3omb2788LP03o`0<LPQb2788LPQb27;o1`0000H001?okZo^[nkokZo^
[nj_kZo^[nj_00;o01G^[nj_k_o^[nj_kZo^[nj_kZo^[ol01M`00ooLg00;g00no`4C0A<14`4Coa<1
4`4C0A<14`7o3oD?m@oo3oD?m@oe3oD?m@oe3omREF9EHUEREOmEHUEREF9EHUEREOl8dP03om;B00SB
00?ogml01]l00ooOg`08g`0ZoelAGa5O4ElAoa5O4ElAGa5O4Eook:c/[>b/k:co[>b/k:c/[>b/k:co
25`00omLG008G00YookFo]Kne_kFomKne_kFo]Kne_koTG:ALY5bTG;oLY5bTG:ALY5bTOl01`0000H0
00?o[nl01?l01joooon_kjl00ol01Zo_oon_k`Co00N_oooo[nn_00?o00F_kjo_o`02g0Co00CLoooo
0m`4o`;L00Ko4`4C0A<4o`0=0Oooo`4C0A<14oo>3`04o`08c_ooolh?cPl2o`09cPo>oh1nP7j000Co
00anooooOX1nP7j0O_l5dPCo0]83o`GB00?ogml00ml4o`04goooo`KO00?o4A400a44o`034Ooo00;o
1A401_n/k:c/[0Co017/[?n/k:c/[>b/k?oAW=6Ld@04o`0@W=7ooicAW=6LdOl?oPon3`Co013noooo
oPon3oh?og88LPQb1?l02`Qbool8LPQb27;o00L00006000ConkokZo^onj_ojo^[nj_ojo^[`02o`0G
k_o^[nkokZoo[nj_kZoo[nj_kZoog?l00m`01?oLg?l5g003omcL00;L03ko0A<14olC0A?o4`4C0Ol1
4`4C0Ol?o`oe3ol?mOoe3oD?o`oeooD?of9EHUGoEF9EoeEREF;oHUEREF9Eo`CB00God];Bo`03dP03
om;B00CB00?ogml00]l01OoOgmoo00;O00?ogml01Ml0:_mO4ElAoa5O4OlAGomO4ElAGa5Oonb/k:co
[>b/ojc/onb/k:c/[>b/o`AL00OoG5aLoeco009L00?oG5`00e`0:Oone_kFomKne_oFo]KnookFo]Kn
oi5bTG;oLY5bog;oLY7oTG:ALY7o00L00006000Cojoo[nn_ojo_onn_kjo_onn_k`02o`0G[on_kjoo
[nookjo_[nookjo_[noog?l00m`01?oLg?l6g00@omcLg?lC0A<1o`4C0Ol14`?o02lC0A<14oo>olh?
c_o>3ol?cPo>olh?o`o>oh1nP7koOX1nogj0OX3oP7j0OX1no`04dP06om;Bd_oB1?l5dP03omoO00;O
00GogmoOo`02g`03omoO00GO00?o4A400Q401OlA4A7o00<A00?o4A401140D_n/k:c/onb/k?o/[>co
k:c/[>b/k?oAW=6LoicAW?nLoicAom6LdIcAo`on3okooPonooh?oPoo3oh?oPooLPQb2?l8LPSo2?l8
L_mb2788L_l700001P004oo^onj_k_o^[on_kZo^[on_kZl00_l05nkokZo^onj_ojo^[nj_ojo^[nj_
omco00?L00Cog=co1m`0=ooLg?l14`4Coa<14olCoa<1o`4C0A<1o`oo3oD?o`oeooD?m@oo3oGom@oo
HUEREOmEHUGoEF800_l025EREF9EHUGo1=802OoBd];od_oBo`06dP03omoO00;O00GogmoOo`02g`03
omoO00GO02[oGa5O4OlAGa7o4ElAGomO4ElAGoo/[>b/ojc/[?n/k:co[>b/k:c/[?l4G005oeaLG?l0
0U`2o`IL00_oo]Kne_oFo]KoeP03o`0Ae_kFo]Knoi5bTG;oLY5bog800ol01g:ALY5bTOl01`0000H0
00?o[nl01Ol02nookjo_[nookjo_00;o00>_kol01?l03^ookjo_[nookjo_[noo0]`5o`03g?oL00?L
00Cog=co0]`01_lC0A<14`Ko00/14olC0A<14oo>3`05o`0B3ol?cPo>olh?o`o>oh1nP7j01Ol02h1n
P?n0OX1nP7ko00GB1_l00m;odP05dP03omoO00?O1Ol00moog`06g`03oa4A00<A1_l24@03oa4A00<A
00Ko[>b/k:`5o`0@[>b/ojc/[>b/k?oAW=6Ld@Ko00jLdOoAW=6LdOl?oPon3`Ko00kn3oh?oPon3omb
2788LPKo00T8LPQb2788L_l01`0000H000SokZo^[nj_kP;o00B_kZo^0_l00jo^[`02o`07kZo^[nj_
kP02o`04[nj_kP;o00J_kZo^[ol7g0;o1M`2o`?L00co0A<14`4C0A<14`42o`0>4`4C0A<1o`oe3oD?
m@l2o`05m@oe3oD00_l03Poe3omREF9EHUEREF9E0ol025EREF9EHUGo2m82o`KB00?ogml02=l2o`OO
00coGa5O4ElAGa5O4El2o`0A4ElAGa5Oonb/k:c/[>b/k:`01?l01nb/k:c/[?l02e`2o`IL00_oo]Kn
e_kFo]KneP04o`0Ao]Kne_koTG:ALY5bTG:ALY400ol01Y5bTG:Ao`L00006000Cojo_[nn_kjo_[nn_
kjo_[nn_k`02o`0E[nn_kjo_[nn_kjo_[nn_kjo_[noo01?L03ko4`4C0A<14`4C0A<14`4C0A<14oo>
3lh?cPo>3lh?cPo>3lh?cPo>oh1nP7j0OX1nP7j0OX1nP7j0OX1noa?B00?ogml04Ml00olA4@0A4@1B
ojc/[>b/k:c/[>b/k:c/[>b/k:c/om6LdIcAW=6LdIcAW=6LdIcAW=7o3oh?oPon3oh?oPon3oh?oPon
3omb2788LPQb2788LPQb2788LPQbo`L00006000Conj_kZo^[nj_kZo^[nj_kZo^[`02o`0EkZo^[nj_
kZo^[nj_kZo^[nj_kZoo01?L03ko0A<14`4C0A<14`4C0A<14`4C0Ol?m@oe3oD?m@oe3oD?m@oe3oD?
of9EHUEREF9EHUEREF9EHUEREF9Eoa?B00?ogml04Ml0:_mO4ElAGa5O4ElAGa5O4ElAGa5Oonb/k:c/
[>b/k:c/[>b/k:c/[>b/oa=L02Woo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:ALY5bTG:A
o`0700001P004on_kjo_[nn_kjo_[nn_kjo_[nl00_l05Jo_[nn_kjo_[nn_kjo_[nn_kjo_o`0Cg00n
oa<14`4C0A<14`4C0A<14`4C0A?ocPo>3lh?cPo>3lh?cPo>3lh?c_n0OX1nP7j0OX1nP7j0OX1nP7j0
O_lCdP03omoO017O00?o4A404A40D_n/k:c/[>b/k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6LdIcAW=6L
dIcAo`on3oh?oPon3oh?oPon3oh?oPooLPQb2788LPQb2788LPQb2788L_l700001P004oo^[nj_kZo^
[nj_kZo^[nj_kZl00_l05Nj_kZo^[nj_kZo^[nj_kZo^[nj_o`0Cg00no`4C0A<14`4C0A<14`4C0A<1
4`7o3oD?m@oe3oD?m@oe3oD?m@oe3omREF9EHUEREF9EHUEREF9EHUEREOlCdP03omoO017O02[oGa5O
4ElAGa5O4ElAGa5O4ElAGoo/[>b/k:c/[>b/k:c/[>b/k:c/[?lCG00YookFo]Kne_kFo]Kne_kFo]Kn
e_koTG:ALY5bTG:ALY5bTG:ALY5bTOl01`0000H001?o[nn_kjo_[nn_kjo_[nn_kjo_00;o01F_kjo_
[nn_kjo_[nn_kjo_[nn_kol04m`0?_lC0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>
3lkoP7j0OX1nP7j0OX1nP7j0OX1nP7ko4m800ooOg`0Ag`03oa4A014A05;o[>b/k:c/[>b/k:c/[>b/
k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb2788
LPQb27;o1`0000H001?okZo^[nj_kZo^[nj_kZo^[nj_00;o01G^[nj_kZo^[nj_kZo^[nj_kZo^[ol0
4m`0?_l14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@ooHUEREF9EHUEREF9EHUER
EF9EHUGo4m800ooOg`0Ag`0ZoelAGa5O4ElAGa5O4ElAGa5O4Eook:c/[>b/k:c/[>b/k:c/[>b/k:co
4e`0:Oone_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:ALY5bTG:ALY5bTG:ALY7o00L000060?oo2Ol70000
1P004ooe3oD?m@oe3oD?m@oe3oD?m@l00_l0:OD?m@oe3oD?m@oe3oD?m@oe3oD?o`4C0A<14`4C0A<1
4`4C0A<14`7o01?L02[o[nj_kZo^[nj_kZo^[nj_kZo^[olAGa5O4ElAGa5O4ElAGa5O4ElAGolCg`03
om;B017B03koEF9EHUEREF9EHUEREF9EHUEREOmbTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kF
o]Kne_kFo]Knoa=L01Go[>b/k:c/[>b/k:c/[>b/k:c/[?l01`0000H001?o3lh?cPo>3lh?cPo>3lh?
cPo>00;o02T?cPo>3lh?cPo>3lh?cPo>3lh?c_lC0A<14`4C0A<14`4C0A<14`4Co`0Cg00Eonn_kjo_
[nn_kjo_[nn_kjo_[noo01@A00?ogml04Ml00ooBdP0AdP1Vogj0OX1nP7j0OX1nP7j0OX1nP7ko2788
LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?oPon3oh?oPon3ooAW=6LdIcAW=6LdIcAW=6LdIcAonb/
k:c/[>b/k:c/[>b/k:c/[>co1`0000H001?om@oe3oD?m@oe3oD?m@oe3oD?00;o02We3oD?m@oe3oD?
m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1o`0Cg00Zojo^[nj_kZo^[nj_kZo^[nj_kZoo4ElA
Ga5O4ElAGa5O4ElAGa5O4Eoo4ml00ooBdP0AdP0noeEREF9EHUEREF9EHUEREF9EHUGoLY5bTG:ALY5b
TG:ALY5bTG:ALY7oo]Kne_kFo]Kne_kFo]Kne_kFo_lCG00Eojc/[>b/k:c/[>b/k:c/[>b/k:co00L0
0006000Co`o>3lh?cPo>3lh?cPo>3lh?cP02o`0Y3lh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C
0A<14`4C0A<14ol04m`05Oo_[nn_kjo_[nn_kjo_[nn_kjo_o`0D4@03omoO017O00?od]804M80I_mn
P7j0OX1nP7j0OX1nP7j0OX1no`Qb2788LPQb2788LPQb2788LPQbo`on3oh?oPon3oh?oPon3oh?oPoo
dIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/[>b/k:c/[>b/k:c/o`L00006000CooD?m@oe3oD?m@oe
3oD?m@oe3`02o`0Ym@oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<14`4C0Ol04m`0:_n_
kZo^[nj_kZo^[nj_kZo^[nj_oa5O4ElAGa5O4ElAGa5O4ElAGa5Ooa?O00?od]804M80?_mEHUEREF9E
HUEREF9EHUEREF9Eog:ALY5bTG:ALY5bTG:ALY5bTG:AookFo]Kne_kFo]Kne_kFo]Kne_ko4e`05On/
k:c/[>b/k:c/[>b/k:c/[>b/o`0700001P000ol?cP03o`0=cPo>3lh?cPo>3lh?cP02o`033lko00;o
01G>3lh?cPo>3lh?cPo>3lko4`4C0A<00ol031<14`4C0A<14`4Co`;L0ol>g003onn_00?o00n_kjo_
[nn_kjo_[nn_kol01A43o``A00?ogml00ml3o`_O00?od]800m83o`_B00KoOX1nP7h3o`0AOX1nP7j0
OX1nP7ko2788LPP00ol04PQb2788LPQb2788L_l?oPon3`?o014?oPon3oh?oPon3ooAW=6Ld@03o`0A
dIcAW=6LdIcAW=7ok:c/[>`00ol03>b/k:c/[>b/k:c/o`L00006000CooD?m@oeooD?m@oe3oD?m@oe
3`02o`0Ym@oe3oGom@oe3oD?m@oe3oD?m@oo0A<14`4C0A?o4`4C0A<14`4C0Ol01M`00ooLg00;g00Z
ojo^[nj_ojo^[nj_kZo^[nj_kZoo4ElAGa5O4EooGa5O4ElAGa5O4Eoo2=l00ooOg`08g`03om;B00KB
00?od]802=80?_mEHUEREF9EH_mREF9EHUEREF9Eog:ALY5bTG:Aoi5bTG:ALY5bTG:AookFo]Kne_kF
omKne_kFo]Kne_ko25`00omLG008G00Eojc/[>b/k:c/onb/k:c/[>b/k:co00L000060003o`o>00Co
00P?oooo3lh?cP;o00H?c_oo3lh4o`083oooo`o>3lh2o`0:3lh?c_lC0A<14`Co00/1oooo0A<14`4C
o`02g0Co00CLoooo0m`4o`;L00?okjl01?l01nooooo_[nl00ol01>n_kol54@Co00<Aool00_l64@03
omoO00?O1?l01=ooool6g`03om;B00?B1?l2dP?o1M801_mnP7j0OPCo0120ooooP7j0OX1no`Qb2788
1?l04G88oomb2788LPQbo`on3oh?00Co013noooooPon3oh?om6LdIcA1?l049cAoonLdIcAW=7ok:c/
[>`4o`0;[>cok:c/[>b/k?l01`0000H001?omOoe3oGom@oo3oD?mOoe3ol?00;o02_eooD?mOoe3ol?
m@oeooD?o`oe3ol14`4Coa<14olC0A<1o`4C0A<1omco00?L00Cog=co1M`00ooLg002g00Zojoo[nj_
ojo^onj_kZo^onj_kZoo4ElAGomO4EooGa7o4ElAGa5O4Eoo1=l01OoOgmoo00;O00?ogml01Ml00ooB
dP02dP05om;Bd_l00m800ooBdP04dP0noeEREF;oHUERof9EHUGoEF9EHUGoLY5bTOnALY7oTOnAL_mb
TG:ALY7oo]Kne_oFo]Koe_kFo_one_kFo_l4G007oeaLG?mLo`02G003oeaL00=L01Go[>b/k?o/[>co
k:co[>b/k:c/[?l01`0000H001?o3ol?cPoo3lkocPo>3ol?c_o>00;o020?o`o>3ol?c_o>3lh?o`o>
olh?c_lC0A<1o`4C0Ol14`?o00PC0A<14ooLo`?L00Cog=co1]`06OoLg=cokoo_[nookjoo[nn_kjoo
[nn_kol011401OlA4A7o00<A00?o4A401A400ooOg`02g`05omoOgol00]l00ooOg`05g`03om;B00;B
00Kod];Bom84o`GB06KoOX1nP?n0OX3oP7j0O_mnP7j0O_l8LPQbog88L_mbog88o`Qb2788L_l?oPon
ooh?o_on3oh?o`on3oh?om6LdIcoW=6LoicoW=7odIcAW=7ok:c/[?n/k:co[>b/ojc/[>b/k?l70000
1P004ooeooD?mOoe3ol?m@oeooD?o`l00_l0:oGom@oeooD?o`oe3oGom@oo3oD?o`4C0A?o4`4Coa?o
4`7o0A<14`7og?l00m`01?oLg?l7g00]omcLojoo[nj_ojo^onj_kZo^onj_kZoo4ElAGomO4EooGa5O
4OlAGa5O4Eoo00CO00GogmoOo`02g`03omoO00GO00?od]800]802OoBd];od_oBo`06dP0<oeEREF;o
HUERof9E0_l04F9EHUEREOmbTG:Aoi5bTOnA00?o01:ALY5bTG:AookFo]Koe_kFomH3o`07e_kFo]Kn
o`04G005oeaLG?l00U`2o`IL01Go[>b/k?o/[>cok:c/onb/k:c/[?l01`0000H000?o3lh01Ol02lko
cPo>3ol?c_o>00;o00<?c_l01?l04lkocPo>3ol?c_o>3lko4`4C0A<01_l02@4Coa<14`4Co`02g0Go
00?Lom`00m`01?oLg?l2g003onn_00Go00f_ojo_[nn_ojo_[noo00DA1_l24@03oa4A00@A00?ogml0
0ml5o`03gooO00KO00?od]800m86o`03d_oB00GB00KoOX1nP7h5o`0?OX1nogj0OX1no`Qb278800Ko
00mb2788LPQb27;o3oh?oPl01_l03_h?oPon3oh?om6LdIcA1_l03YcAom6LdIcAonb/k:c/1Ol02^b/
k?o/[>b/k?l700001P002?oe3oD?m@oe0_l01@oe3oD?00;o00_e3ooom@oe3oD?m@02o`053oD?m@l0
0_l04?D?m@oo0A<14`4C0A<14`42o`074`4C0A<1o`07g0;o1M`2o`?L00So[nj_kZo^[`;o00C^[nj_
0_l04>j_kZoo4ElAGa5O4ElAGa42o`08Ga5O4ElAGol:g`;o1ml00ooBdP09dP;o1]802omEHUEREF9E
HUER00?o019REF9EHUGoLY5bTG:ALY5bTG83o`0ALY5bTG:AookFo]Kne_kFo]H01?l01_kFo]Kno`]L
0_l6G00;ojc/[>b/k:c/[>`01?l01Zc/[>b/o`L00006000Co`o>3lh?cPo>3lh?cPo>3lh?cP02o`0Y
3lh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C0A<14`4C0A<14ol04m`05Oo_[nn_kjo_[nn_kjo_
[nn_kjo_o`0D4@03omoO017O00?od]804M80I_mnP7j0OX1nP7j0OX1nP7j0OX1no`Qb2788LPQb2788
LPQb2788LPQbo`on3oh?oPon3oh?oPon3oh?oPoodIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/[>b/
k:c/[>b/k:c/o`L00006000CooD?m@oe3oD?m@oe3oD?m@oe3`02o`0Ym@oe3oD?m@oe3oD?m@oe3oD?
m@oo0A<14`4C0A<14`4C0A<14`4C0Ol04m`0:_n_kZo^[nj_kZo^[nj_kZo^[nj_oa5O4ElAGa5O4ElA
Ga5O4ElAGa5Ooa?O00?od]804M80?_mEHUEREF9EHUEREF9EHUEREF9Eog:ALY5bTG:ALY5bTG:ALY5b
TG:AookFo]Kne_kFo]Kne_kFo]Kne_ko4e`05On/k:c/[>b/k:c/[>b/k:c/[>b/o`0700001P004ol?
cPo>3lh?cPo>3lh?cPo>3lh00_l0:@o>3lh?cPo>3lh?cPo>3lh?cPo>oa<14`4C0A<14`4C0A<14`4C
0A?o01?L01Gokjo_[nn_kjo_[nn_kjo_[nn_kol051400ooOg`0Ag`03om;B017B06KoOX1nP7j0OX1n
P7j0OX1nP7j0O_l8LPQb2788LPQb2788LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?om6LdIcAW=6L
dIcAW=6LdIcAW=7ok:c/[>b/k:c/[>b/k:c/[>b/k?l700001P004ooe3oD?m@oe3oD?m@oe3oD?m@l0
0_l0:OD?m@oe3oD?m@oe3oD?m@oe3oD?o`4C0A<14`4C0A<14`4C0A<14`7o01?L02[o[nj_kZo^[nj_
kZo^[nj_kZo^[olAGa5O4ElAGa5O4ElAGa5O4ElAGolCg`03om;B017B03koEF9EHUEREF9EHUEREF9E
HUEREOmbTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kFo]Kne_kFo]Knoa=L01Go[>b/k:c/[>b/
k:c/[>b/k:c/[?l01`0000H001?o3lh?cPo>3lh?cPo>3lh?cPo>00;o02T?cPo>3lh?cPo>3lh?cPo>
3lh?c_lC0A<14`4C0A<14`4C0A<14`4Co`0Cg00Eonn_kjo_[nn_kjo_[nn_kjo_[noo01@A00?ogml0
4Ml00ooBdP0AdP1Vogj0OX1nP7j0OX1nP7j0OX1nP7ko2788LPQb2788LPQb2788LPQb27;o3oh?oPon
3oh?oPon3oh?oPon3ooAW=6LdIcAW=6LdIcAW=6LdIcAonb/k:c/[>b/k:c/[>b/k:c/[>co1`0000H0
01?om@oe3oD?m@oe3oD?m@oe3oD?00;o02We3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<1
4`4C0A<1o`0Cg00Zojo^[nj_kZo^[nj_kZo^[nj_kZoo4ElAGa5O4ElAGa5O4ElAGa5O4Eoo4ml00ooB
dP0AdP0noeEREF9EHUEREF9EHUEREF9EHUGoLY5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kne_kF
o]Kne_kFo_lCG00Eojc/[>b/k:c/[>b/k:c/[>b/k:co00L000060?oo2Ol700001P004olC0A<14`4C
0A<14`4C0A<14`400_l0?A<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_
kZo^[nj_kZo^[nj_kZo^[ol04m`00ooOg`0Bg`0YoelAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9E
HUEREF9EHUEREOl04m80?_oFo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:ALY5bTG:Aojc/
[>b/k:c/[>b/k:c/[>b/k:co4e`00ol0000500001P004ol14`4C0A<14`4C0A<14`4C0A<00_l0?@4C
0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>3lkokjo_[nn_kjo_[nn_kjo_[nn_kol0
4m`00ooOg`0Bg`03oa4A014A01GoOX1nP7j0OX1nP7j0OX1nP7j0O_l04m80D_on3oh?oPon3oh?oPon
3oh?oPon3omb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6L
dIcAW=6LdOl700001P004olC0A<14`4C0A<14`4C0A<14`400_l0?A<14`4C0A<14`4C0A<14`4C0A<1
o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_kZo^[ol04m`00ooOg`0Bg`0YoelAGa5O
4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREOl04m80?_oFo]Kne_kFo]Kne_kFo]Kne_kF
o_nALY5bTG:ALY5bTG:ALY5bTG:Aojc/[>b/k:c/[>b/k:c/[>b/k:co4e`00ol0000500001P004ol1
4`4C0A<14`4C0A<14`4C0A<00_l0?@4C0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>
3lkokjo_[nn_kjo_[nn_kjo_[nn_kol04m`00ooOg`0Bg`03oa4A014A01GoOX1nP7j0OX1nP7j0OX1n
P7j0O_l04m80D_on3oh?oPon3oh?oPon3oh?oPon3omb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/
k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl700001P004olC0A<14`4C0A<14`4C0A<14`40
0_l0?A<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_
kZo^[ol04m`00ooOg`0Bg`0YoelAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREOl0
4m80?_oFo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:ALY5bTG:Aojc/[>b/k:c/[>b/k:c/
[>b/k:co4e`00ol0000500001P001_l14`4C0@?o00X14`4C0A<14`4C0_l01@4C0A<100?o00l14`4C
0A<14`4C0A?ocPl00ol04@o>3lh?cPo>3lh?cPo>onn_00?o00n_kjo_[nn_kjo_[nn_kol00]`3o`kL
00?ogml00ml3o`cO00?o4A400a43o`/A00KoOX1nP7h3o`0<OX1nP7j0OX1nP7ko1M83o`_B00KooPon
3oh3o`0BoPon3oh?oPon3oh?og88LPQb0ol04G88LPQb2788LPQbonb/k:c/00?o017/[>b/k:c/[>b/
k?oAW=6Ld@03o`0<dIcAW=6LdIcAW=7o1`0000H001?o4`4C0A<14`7o0A<14`4C0A<100;o03dC0A<1
4`4C0Ol14`4C0A<14`4C0Ol?m@oe3ol?m@oe3oD?m@oe3oD?ojo^[nj_ojo^[nj_kZo^[nj_kZoo00GL
00?og=`02m`00ooOg`06g`03omoO00WO02WoGa5O4ElAGa7o4ElAGa5O4ElAGomEHUEREF9EH_mREF9E
HUEREF9Eo`08dP03om;B00SB03koe_kFo]Kne_koo]Kne_kFo]Kne_koTG:ALY5bTG;oLY5bTG:ALY5b
TOn/k:c/[>b/k?o/[>b/k:c/[>b/o`QL00?oG5`025`00ol0000500001P001_l14`4C0@Co00TCoooo
4`4C0A<00_l01@4C0A<100Co00hCoooo4`4C0A<14oo>3`Co00S>oooocPo>3`;o00K>3lkokjl4o`07
koooonn_k`03o`04kjo_o`;L1?l01=coool3g0Co0]`00ooOg`03g`Co00COoooo1ml00olA4@034@Co
00<Aool00_l54@06ogj0OX1n1?l02h3ooon0OX1nP7ko00GB1?l2dP?o1M801_on3oh?oPCo014?oooo
3oh?oPon3omb2788LP04o`0@27;oo`Qb2788L_o/[>b/k0Co012/k?o/[>b/k:c/om6LdIcA1?l02icA
oonLdIcAW=7o00L00006000Coa<14`7o0A<1o`4C0A?o4`4C0@02o`0o4`4C0Ol14`7o0A<14olC0A<1
4`7o3ol?m@oo3oGom@oe3ol?mOoe3on_ojo^[on_k_o^[nj_k_o^[nj_omco00?L00Cog=co1M`00ooL
g002g003omoO00;O00GogmoOo`02g`03omoO00KO02WoGa5O4OlAGa7o4EooGa5O4ElAGomEHUERof9E
H_mREF9EoeEREF9Eo`04dP05om;Bd_l00m800ooBdP04dP0nomKne_koo]KnookFo]Koe_kFo]Knoi5b
TG;oLY5bog;oLY7oTG:ALY7o[>b/k?o/[>cok:co[>b/k:c/[?l4G007oeaLG?mLo`02G003oeaL00=L
00?o00001@0000H000co0A<14olC0A?o4`43o`040A<14`;o00/14`4Coa<14olC0@03o`0a0A<14`4C
olkocPo>olh?o`o>3lkocPoo3lkokoo_[nookjoo[nn_kjoo[nn_kooLo`03g004omcLo`KL00Gog=cL
o`04g`05omoOgol00]l00ooOg`06g`03oa4A008A00Go4A4Ao`034@03oa4A00@A01GoOX1nP?n0OX3o
P7j0O_mnP7j0O_l01=801_oBd];odPCo1M80D_on3oh?o`on3ol?oPonooh?oPon3omb2788o`Qb2?l8
o`Qbog88LPQbonb/k:co[>b/ojc/[?n/k:c/[>codIcAW?nLdIcoW?nLdOoAW=6LdOl700001P004olC
0A<1o`4C0Ol1o`4Coa<14`400_l0?a<14`7o0A<1o`7o0A?o4`4C0A<1o`oo3oD?o`oeooD?m@oo3oGo
m@oo[on_kZoo[nkokZo^[nkokZo^[ooLo`03g004omcLo`OL00Cog=co1=l01OoOgmoo00;O00?ogml0
1]l08?mO4ElAoa5O4OlAGa5OoelAGa5OoeEREF;oHUERof9E0_l01f9EHUEREOl01=802OoBd];od_oB
o`06dP0;omKne_koo]Knooh00ol04_kFo]Kne_koTG:AL_mbTG;oLP?o01]bTG:ALY7o[>b/k?o/[>co
k:c/onb/k:c/[?l015`01OmLG5co009L0_l6G003o`0000D000060006o`4C0A<11_l01a<1o`4C0A<0
0_l01@4C0A<100Ko00`C0Ol14`4C0A?ocPl5o`0?3ol?cPo>olh?o`o>onn_00Go00f_ojo_[nn_ojo_
[noo00;L1Ol00mcog003g004omcLo`;L00?ogml00ml5o`03gooO00OO00?o4A400a46o`8A00?o4A40
0a401_mnP7j0OPGo00YnP7koOX1nP7ko1M86o`03d_oB00GB00KooPon3oh6o`0?3oh?oPon3oh?og88
LPQb00Ko00h8LPQb2788L_o/[>b/k0Go00o/[>cok:c/[>codIcAW=401_l02IcAom6LdIcAo`070000
1P003?lC0A<14`4C0A<14`;o00D14`4C0@02o`0;4`4C0A<14`4C0A<00_l03`4C0A<14`7o3oD?m@oe
3`02o`05m@oe3oD00_l02`oe3on_kZo^[nj_00;o00C^[nj_0_l01Nj_kZoo00OL0_l5g0;o0m`00ooO
g`08g`;o2=l03?mO4ElAGa5O4ElAG`;o014AGa5O4EooEF9EHUEREF9EHP03o`07HUEREF9Eo`0;dP;o
1]802ooFo]Kne_kFo]Kn00Co01;Fo]Kne_koTG:ALY5bTG:ALY43o`0@TG:ALY7o[>b/k:c/[>b/k0Co
00J/k:c/[?l;G0;o1U`00ol0000500001P004ol14`4C0A<14`4C0A<14`4C0A<00_l0?@4C0A<14`4C
0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>3lkokjo_[nn_kjo_[nn_kjo_[nn_kol04m`00ooO
g`0Bg`03oa4A014A01GoOX1nP7j0OX1nP7j0OX1nP7j0O_l04m80D_on3oh?oPon3oh?oPon3oh?oPon
3omb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6L
dOl700001P004olC0A<14`4C0A<14`4C0A<14`400_l0?A<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?
m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_kZo^[ol04m`00ooOg`0Bg`0YoelAGa5O4ElAGa5O
4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREOl04m80?_oFo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5b
TG:ALY5bTG:ALY5bTG:Aojc/[>b/k:c/[>b/k:c/[>b/k:co4e`00ol0000500001P004ol14`4C0A<1
4`4C0A<14`4C0A<00_l0?@4C0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>3lkokjo_
[nn_kjo_[nn_kjo_[nn_kol04m`00ooOg`0Bg`03oa4A014A01GoOX1nP7j0OX1nP7j0OX1nP7j0O_l0
4m80D_on3oh?oPon3oh?oPon3oh?oPon3omb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/k:c/[>b/
k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl700001P004olC0A<14`4C0A<14`4C0A<14`400_l0?A<1
4`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_kZo^[ol0
4m`00ooOg`0Bg`0YoelAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREOl04m80?_oF
o]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:ALY5bTG:Aojc/[>b/k:c/[>b/k:c/[>b/k:co
4e`00ol0000500001P004ol14`4C0A<14`4C0A<14`4C0A<00_l0?@4C0A<14`4C0A<14`4C0A<14`4C
olh?cPo>3lh?cPo>3lh?cPo>3lkokjo_[nn_kjo_[nn_kjo_[nn_kol04m`00ooOg`0Bg`03oa4A014A
01GoOX1nP7j0OX1nP7j0OX1nP7j0O_l04m80D_on3oh?oPon3oh?oPon3oh?oPon3omb2788LPQb2788
LPQb2788LPQbonb/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl700001P004olC
0A<14`4C0A<14`4C0A<14`400_l0?A<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?
m@oo[nj_kZo^[nj_kZo^[nj_kZo^[ol04m`00ooOg`0Bg`0YoelAGa5O4ElAGa5O4ElAGa5O4EooEF9E
HUEREF9EHUEREF9EHUEREOl04m80?_oFo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:ALY5b
TG:Aojc/[>b/k:c/[>b/k:c/[>b/k:co4e`00ol0000500001P3oo`Wo1`0000H000?oG5`045`2oaAL
03go[>b/k:c/[>b/k:c/[>b/k:c/[?nALY5bTG:ALY5bTG:ALY5bTG:AookFo]Kne_kFo]Kne_kFo]Kn
e_ko01CL03gokZo^[nj_kZo^[nj_kZo^[nj_k_oe3oD?m@oe3oD?m@oe3oD?m@oeoa<14`4C0A<14`4C
0A<14`4C0A?o01CB02WoHUEREF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAo`0Cg`03
o`0000D00006000CoicAW=6LdIcAW=6LdIcAW=6Ld@02o`1AW=6LdIcAW=6LdIcAW=6LdIcAW=7ok:c/
[>b/k:c/[>b/k:c/[>b/k?mb2788LPQb2788LPQb2788LPQbo`on3oh?oPon3oh?oPon3oh?oPoo01CL
03go[nn_kjo_[nn_kjo_[nn_kjo_[ol?cPo>3lh?cPo>3lh?cPo>3lh?o`4C0A<14`4C0A<14`4C0A<1
4`7o01CB01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l04a400ooOg`0Ag`03o`0000D000060003oeaL011L
0_lDG00mojc/[>b/k:c/[>b/k:c/[>b/k:coTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kFo]Kn
e_kFo]Kno`0Dg00monj_kZo^[nj_kZo^[nj_kZo^[nkom@oe3oD?m@oe3oD?m@oe3oD?mOlC0A<14`4C
0A<14`4C0A<14`4Co`0DdP0Yof9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4Ol0
4ml00ol0000500001P004onLdIcAW=6LdIcAW=6LdIcAW=400_l0DIcAW=6LdIcAW=6LdIcAW=6LdIcA
onb/k:c/[>b/k:c/[>b/k:c/[>coLPQb2788LPQb2788LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?
o`0Dg00mojo_[nn_kjo_[nn_kjo_[nn_kjoo3lh?cPo>3lh?cPo>3lh?cPo>3ol14`4C0A<14`4C0A<1
4`4C0A<1o`0DdP0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01<A00?ogml04Ml00ol0000500001P000omL
G00@G0;o55`0?On/k:c/[>b/k:c/[>b/k:c/[>b/oi5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kn
e_kFo]Kne_kFo_l05=`0?Oo^[nj_kZo^[nj_kZo^[nj_kZo^ooD?m@oe3oD?m@oe3oD?m@oe3oGo4`4C
0A<14`4C0A<14`4C0A<14ol05=80:OmREF9EHUEREF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4ElA
Ga7o01?O00?o00001@0000H000KoW=6LdI`3o`0:W=6LdIcAW=6Ld@;o00FLdIcAW003o`0BW=6LdIcA
W=6LdIcAonb/k:c/0ol04Nb/k:c/[>b/k:c/og88LPQb00?o015b2788LPQb2788L_l?oPon3`03o`0<
3oh?oPon3oh?oPoo0]`3o`oL00?o[nl00ol04Nn_kjo_[nn_kjo_[nn_o`o>00?o01C>3lh?cPo>3lh?
cPo>3ol14`4C0@?o00`14`4C0A<14`4C0Ol5dP?o3=801_n0OX1nP0?o00b0OX1nP7j0OX1nP?l54@?o
2a400ooOg`03g`?o2ml00ol0000500001P000omLG006G003oeaL00ML0_l8G003oeaL00UL03go[>b/
k:c/[>cok:c/[>b/k:c/[?nALY5bTG:AL_mbTG:ALY5bTG:AookFo]Kne_kFomKne_kFo]Kne_ko00GL
00?og=`03=`0?Oo^[nj_k_o^[nj_kZo^[nj_kZo^ooD?m@oeooD?m@oe3oD?m@oe3oGo4`4C0A<14`7o
0A<14`4C0A<14ol02=800ooBdP09dP0Yof9EHUEREF9EoeEREF9EHUEREF;o4ElAGa5O4EooGa5O4ElA
Ga5O4Ol02=l00ooOg`08g`03o`0000D000060006oicAW=6L1?l02M6LoooAW=6Ld@02o`05W=6LdI`0
1?l04M6LoooAW=6LdIcAonb/k:c/00Co012/k?o/[>b/k:c/og88LPQb1?l040Qbool8LPQb27;o3oh?
oPl4o`0;o_ooooh?oPon3ol00]`4o`04g?ooo`?L1?l3g003ojo_00Co00N_oooo[nn_00?o00J_kjoo
3lh4o`083oooo`o>3lh2o`093lh?o`4C0A<100Co00/Coooo4`4C0A<1o`05dPCo0]83o`KB00KoP7j0
OX04o`0;O_ooogj0OX1nP?l01A44o`034Ooo00;o1A400ooOg`03g`Co00COoooo1]l00ol000050000
1P000omLG002G007oeaLG?mLo`02G003oeaL009L0_l4G007oeaLG?mLo`02G003oeaL00AL03oo[>b/
k?o/[>cok:co[>b/k:c/[?nALY5bog:AL_mbog:Aoi5bTG:AookFo]Koe_kFomKne_koo]Kne_kog?l0
0m`01?oLg?l5g003omcL00?L03gok_o^[nkokZoo[nj_kZoo[nj_k_oeooD?mOoe3ol?m@oeooD?o`oe
oa<14`7o0A<1o`4C0A?o4`4C0A?o00CB00God];Bo`03dP03om;B00GB02WoHUEREOmEHUGoEF9EH_mR
EF9EH_lAGa5OoelAGomO4OlAGa5O4ElAo`04g`05omoOgol00]l00ooOg`05g`03o`0000D00006000C
oicAW=7odIcAom7odIcoW=6Ld@02o`1CW=6LdOoAW=7odOoAW?nLdIcAW=7ok:c/[?n/k:co[>b/ojc/
[>b/k?mb2788o`Qb2?l8o`Qbog88LPQbo`on3okooPonooh?oPoo3oh?oPoog?l00m`01?oLg?l6g003
omcL00;L03Co[on_kjoo[nookjo_[nookjo_[ol?o`o>3ol?c_o>3lh?o`o>olh?o`4C0A?o4`4Coa<1
0ol01P4C0A<1o`CB00Kod];Bom84o`KB01GoP7j0O_mnP7koOX1nP?n0OX1nP?l011401OlA4A7o00<A
00?o4A4011400ooOg`02g`05omoOgol00]l00ooOg`05g`03o`0000D000060003oeaL009L00GoG5aL
o`02G0;o1E`2o`AL00GoG5aLo`02G0;o1e`07on/k:c/onb/k?o/[>cok:c/[>b/oi5bTG;oLY5bog80
0ol04G:ALY5bTOone_kFomKne_oF00?o00WFo]Kne_kog?l00m`01?oLg?l7g011omcLg?o^onj_k_o^
[on_kZo^[on_kZo^ooGom@oeooD?o`oe3oGom@oo3oGo4`4C0Ol14`7o0Ol14olC0A<14ol01=802OoB
d];od_oBo`07dP0<of9EHUGoEF9EoeER0_l06eEREF9EH_lAGa5OoelAGomO4ElAoa5O4ElAo`04g`05
omoOgol00]l00ooOg`05g`03o`0000D000060006oicAW=6L1_l01m6LoicAW=400_l01IcAW=6L00Ko
00oAW?nLdIcAW=7ok:c/[>`01Ol03nb/k?o/[>b/k?mb2788LP06o`0>2788LPQb27;o3oh?oPl6o`09
oPon3oh?oPoo00;L1Ol00mcog003g004omcLo`?L00?o[nl01Ol03nookjo_[nookjo_[ol?cP05o`0B
c_o>3lh?o`o>olh?o`4C0A<11_l02A<1o`4C0A<1o`05dPKo00?Bom801]801_n0OX1nP0Go00Z0OX3o
P7j0OX3o1A46o`8A00?o4A400a400ooOg`03g`Go00?Ooml01]l00ol0000500001P000omLG009G0;o
1E`2o`]L0_l7G00;ojc/[>b/k:c/[>`01?l04Jc/[>b/oi5bTG:ALY5bTG:A00?o012ALY5bTOone_kF
o]Kne_kF1?l01_kFo]Kno`OL0_l5g0;o1=`02?o^[nj_kZo^0_l01:o^[nh2o`0<[nj_k_oe3oD?m@oe
0_l01@oe3oD?00;o00oe3oGo4`4C0A<14`4C0A<00_l01`4C0A<14ol02m82o`OB00_oHUEREF9EHUER
E@03o`0BEF9EHUERoa5O4ElAGa5O4ElA0_l01elAGa5O4Ol02]l2o`OO00?o00001@0000H001?oW=6L
dIcAW=6LdIcAW=6LdIcA00;o056LdIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/[>b/k:c/[>b/k:c/
og88LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?oPon3oh?oPon3ol05=`0?On_kjo_[nn_kjo_[nn_
kjo_[nn_o`o>3lh?cPo>3lh?cPo>3lh?cPoo0A<14`4C0A<14`4C0A<14`4C0Ol05=805On0OX1nP7j0
OX1nP7j0OX1nP7j0o`0C4@03omoO017O00?o00001@0000H000?oG5`045`2oaAL03go[>b/k:c/[>b/
k:c/[>b/k:c/[?nALY5bTG:ALY5bTG:ALY5bTG:AookFo]Kne_kFo]Kne_kFo]Kne_ko01CL03gokZo^
[nj_kZo^[nj_kZo^[nj_k_oe3oD?m@oe3oD?m@oe3oD?m@oeoa<14`4C0A<14`4C0A<14`4C0A?o01CB
02WoHUEREF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAo`0Cg`03o`0000D00006000C
oicAW=6LdIcAW=6LdIcAW=6Ld@02o`1AW=6LdIcAW=6LdIcAW=6LdIcAW=7ok:c/[>b/k:c/[>b/k:c/
[>b/k?mb2788LPQb2788LPQb2788LPQbo`on3oh?oPon3oh?oPon3oh?oPoo01CL03go[nn_kjo_[nn_
kjo_[nn_kjo_[ol?cPo>3lh?cPo>3lh?cPo>3lh?o`4C0A<14`4C0A<14`4C0A<14`7o01CB01GoP7j0
OX1nP7j0OX1nP7j0OX1nP?l04a400ooOg`0Ag`03o`0000D000060003oeaL011L0_lDG00mojc/[>b/
k:c/[>b/k:c/[>b/k:coTG:ALY5bTG:ALY5bTG:ALY5bTOone_kFo]Kne_kFo]Kne_kFo]Kno`0Dg00m
onj_kZo^[nj_kZo^[nj_kZo^[nkom@oe3oD?m@oe3oD?m@oe3oD?mOlC0A<14`4C0A<14`4C0A<14`4C
o`0DdP0Yof9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4Ol04ml00ol000050000
1P004onLdIcAW=6LdIcAW=6LdIcAW=400_l0DIcAW=6LdIcAW=6LdIcAW=6LdIcAonb/k:c/[>b/k:c/
[>b/k:c/[>coLPQb2788LPQb2788LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?o`0Dg00mojo_[nn_
kjo_[nn_kjo_[nn_kjoo3lh?cPo>3lh?cPo>3lh?cPo>3ol14`4C0A<14`4C0A<14`4C0A<1o`0DdP0E
oh1nP7j0OX1nP7j0OX1nP7j0OX3o01<A00?ogml04Ml00ol0000500001P000omLG00@G0;o55`0?On/
k:c/[>b/k:c/[>b/k:c/[>b/oi5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kne_kFo]Kne_kFo_l0
5=`0?Oo^[nj_kZo^[nj_kZo^[nj_kZo^ooD?m@oe3oD?m@oe3oD?m@oe3oGo4`4C0A<14`4C0A<14`4C
0A<14ol05=80:OmREF9EHUEREF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4ElAGa7o01?O00?o0000
1@0000H001?oW=6LdIcAW=6LdIcAW=6LdIcA00;o056LdIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/
[>b/k:c/[>b/k:c/og88LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?oPon3oh?oPon3ol05=`0?On_
kjo_[nn_kjo_[nn_kjo_[nn_o`o>3lh?cPo>3lh?cPo>3lh?cPoo0A<14`4C0A<14`4C0A<14`4C0Ol0
5=805On0OX1nP7j0OX1nP7j0OX1nP7j0o`0C4@03omoO017O00?o00001@0000H0ool9o`L00006000C
ojc/[>b/k:c/[>b/k:c/[>b/k002o`1V[>b/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcA
W=6LdOl?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb2788LPQb27;okjo_[nn_kjo_[nn_kjo_
[nn_kjoo4m`0?_l14`4C0A<14`4C0A<14`4C0A<1o`o>3lh?cPo>3lh?cPo>3lh?cPooOX1nP7j0OX1n
P7j0OX1nP7j0OX3o4m800ooOg`0Ag`03oa4A014A00?o00001@0000H001?ok:c/[>b/k:c/[>b/k:c/
[>b/00;o01G/[>b/k:c/[>b/k:c/[>b/k:c/[?l04e`0?_one_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:A
LY5bTG:ALY5bTG:ALY7o[nj_kZo^[nj_kZo^[nj_kZo^[nko4m`0?_lC0A<14`4C0A<14`4C0A<14`4C
ooD?m@oe3oD?m@oe3oD?m@oe3oGoEF9EHUEREF9EHUEREF9EHUEREF;o4m800ooOg`0Ag`0Eoa5O4ElA
Ga5O4ElAGa5O4ElAGa7o00L00006000Cojc/[>b/k:c/[>b/k:c/[>b/k002o`1V[>b/k:c/[>b/k:c/
[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb
2788LPQb27;okjo_[nn_kjo_[nn_kjo_[nn_kjoo4m`0?_l14`4C0A<14`4C0A<14`4C0A<1o`o>3lh?
cPo>3lh?cPo>3lh?cPooOX1nP7j0OX1nP7j0OX1nP7j0OX3o4m800ooOg`0Ag`03oa4A014A00?o0000
1@0000H001?ok:c/[>b/k:c/[>b/k:c/[>b/00;o01G/[>b/k:c/[>b/k:c/[>b/k:c/[?l04e`0?_on
e_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:ALY5bTG:ALY5bTG:ALY7o[nj_kZo^[nj_kZo^[nj_kZo^[nko
4m`0?_lC0A<14`4C0A<14`4C0A<14`4CooD?m@oe3oD?m@oe3oD?m@oe3oGoEF9EHUEREF9EHUEREF9E
HUEREF;o4m800ooOg`0Ag`0Eoa5O4ElAGa5O4ElAGa5O4ElAGa7o00L00006000Cojc/[>b/k:c/[>b/
k:c/[>b/k002o`1V[>b/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl?oPon3oh?
oPon3oh?oPon3oh?og88LPQb2788LPQb2788LPQb27;okjo_[nn_kjo_[nn_kjo_[nn_kjoo4m`0?_l1
4`4C0A<14`4C0A<14`4C0A<1o`o>3lh?cPo>3lh?cPo>3lh?cPooOX1nP7j0OX1nP7j0OX1nP7j0OX3o
4m800ooOg`0Ag`03oa4A014A00?o00001@0000H000Kok:c/[>`3o`0:k:c/[>b/k:c/[0;o00G/[>b/
k003o`0=k:c/[>b/k:c/[>b/o`05G0?o2e`01_one_kFoP?o017ne_kFo]Kne_kFo_nALY5bT@03o`0>
TG:ALY5bTG:ALY7o[nh3o`0@kZo^[nj_kZo^[nj_kZo^o`;L0ol>g006oa<14`4C0ol03Q<14`4C0A<1
4`4CooD?0ol050oe3oD?m@oe3oD?m@oeoeEREF9E0ol03EEREF9EHUEREF9EH_l01M83o`_B00?ogml0
0ml3o`_O00Ko4ElAGa43o`0<4ElAGa5O4ElAGa7o1`0000H001?o[>b/k:c/[>cok:c/[>b/k:c/00;o
06J/k:c/[>b/k?o/[>b/k:c/[>b/k?oAW=6LdIcAW?nLdIcAW=6LdIcAo`on3oh?oPonooh?oPon3oh?
oPooLPQb2788LPSo2788LPQb2788L_o_[nn_koo_[nn_kjo_[nn_kjo_[ol5g003omcL00_L03ko0A<1
4`4C0A?o4`4C0A<14`4C0Ol?cPo>3ol?cPo>3lh?cPo>3lh?ogj0OX1nP7j0oh1nP7j0OX1nP7j0o`SB
00?od]802=800ooOg`06g`03omoO00SO00?o4A401Q400olA4@084@03o`0000D000060006onb/k:c/
1?l02Jc/onb/k:c/[002o`05k:c/[>`01?l03:c/onb/k:c/[>b/o`EL1?l2G0;o1U`01_one_kFoPCo
013Fooooe_kFo]Knoi5bTG:A1?l03G:AoombTG:ALY7o[nh01?l01joooon_kZl00ol01Jo^[nko00;L
1?l01=coool3g0Co0]`01_lC0A<14`Co00d1oooo0A<14`4CooD?00Co00Seoooom@oe3`;o00We3oGo
EF9EHUD01?l036;ooomREF9EHUERo`GB1?l2dP?o1M800ooOg`03g`Co00COoooo1]l01_lAGa5O4@Co
00=Oool00_l01Q5O4ElAo`L00006000Cojc/[>cok:c/onb/ojc/[>b/k002o`1X[>b/k?o/[>cok:co
[>b/k:c/[>codIcAW?nLdIcoW?nLdOoAW=6LdOl?oPonooh?o_on3oh?o`on3oh?og88LPSo2788o`So
27;oLPQb27;okoo_[nookjoo[nn_kjoo[nn_kjoog?l3g004omcLo`GL00?og=`00]`0?_l14`4Coa<1
4olC0A<1o`4C0A<1o`oo3lh?o`o>olh?cPoo3lkocPooOX1nP?n0OX3oP7j0O_mnP7j0OX3o1=801OoB
d];o00?B00?od]801=800ooOg`02g`05omoOgol00]l00ooOg`05g`03oa4A008A00Go4A4Ao`024@03
oa4A00DA00?o00001@0000H001?ok:c/[?n/k:co[>b/ojc/[>b/00;o01G/[>b/ojc/[?n/k:co[>b/
k:c/[?l015`01omLG5coG?l00U`00omLG003G010ookFo]Koe_kFomKne_koo]Kne_koTG:AL_mbTG;o
L_mbTOnALY5bTOn_ojo^[on_k_o^[nj_k_o^[nj_k_oLo`?L00Cog=co1]`04?oLg=co4`4C0Ol14`7o
0A<3o`0_4`4C0A?omOoe3oGom@oo3oD?mOoe3ol?mOmEHUERof9EH_mREF9EoeEREF9EH_l01=801_oB
d];odPCo1M800ooOg`02g`05omoOgol00]l00ooOg`05g`0Eoa5O4EooGa5OoelAGomO4ElAGa7o00L0
0006000Cojc/[>cok:c/onb/k?o/[>b/k002o`0P[>b/k?o/[>cok:c/onb/k:c/[>codIcAW?nLdIco
W=42o`0AW=6LdIcAo`on3okooPonooh00ol04Oh?oPon3omb2788o`Qb2?l800?o01h8LPQb27;okoo_
[nookjoo[nn_kjoo[nn_kjoog?l3g004omcLo`OL03Oog=co0A<14olC0A?o4olC0Ol14`4C0Ol?o`o>
3ol?c_o>3lh?o`o>olh?ogj0OX3oP7j0oh1n00;o00R0OX1nP7j0o`CB00Wod];Bom;od_l01]800ooO
g`02g`05omoOgol00]l00ooOg`05g`03oa4A008A00Go4A4Ao`044@03oa4A00<A00?o00001@0000H0
00Kok:c/[>`5o`08k:c/onb/k:`2o`05k:c/[>`01Ol02nb/k?o/[>b/k:co00EL1_l2G003oeaL00=L
00Koo]Kne_h6o`0>e_kFo]Kne_koTG:ALY46o`0;LY5bTG:ALY7o[nh01Ol03^kokZo^[nkokZo^[nko
0]`5o`03g?oL00?L00Cog=co0]`01_lC0A<14`Ko00/14olC0A<14ooe3`05o`0B3ol?m@oeooD?o`oe
oeEREF9E1Ol02eEREOmEHUEREF;o00GB1_l00m;odP05dP03omoO00?O1Ol00moog`06g`06oa5O4ElA
1_l02ElAoa5O4ElAo`0700001P002on/k:c/[>b/k:c/00Co00B/k:c/0_l02Zc/[>b/k:c/[>`4o`0B
[>b/k:c/om6LdIcAW=6LdIcA0_l04IcAW=6LdOl?oPon3oh?oPon00Co014?oPon3omb2788LPQb2788
LP03o`0=LPQb27;okjo_[nn_k`02o`04[nn_k`;o00J_kjo_[ol7g0;o1M`2o`?L00co0A<14`4C0A<1
4`42o`0>4`4C0A<1o`o>3lh?cPl2o`05cPo>3lh00_l03Po>3omnP7j0OX1nP7j00ol0281nP7j0OX3o
2m82o`KB00?ogml02=l2o`OO00?o4A402A42o`HA00?o00001@0000H001?ok:c/[>b/k:c/[>b/k:c/
[>b/00;o01G/[>b/k:c/[>b/k:c/[>b/k:c/[?l04e`0?_one_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:A
LY5bTG:ALY5bTG:ALY7o[nj_kZo^[nj_kZo^[nj_kZo^[nko4m`0?_lC0A<14`4C0A<14`4C0A<14`4C
ooD?m@oe3oD?m@oe3oD?m@oe3oGoEF9EHUEREF9EHUEREF9EHUEREF;o4m800ooOg`0Ag`0Eoa5O4ElA
Ga5O4ElAGa5O4ElAGa7o00L00006000Cojc/[>b/k:c/[>b/k:c/[>b/k002o`1V[>b/k:c/[>b/k:c/
[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb
2788LPQb27;okjo_[nn_kjo_[nn_kjo_[nn_kjoo4m`0?_l14`4C0A<14`4C0A<14`4C0A<1o`o>3lh?
cPo>3lh?cPo>3lh?cPooOX1nP7j0OX1nP7j0OX1nP7j0OX3o4m800ooOg`0Ag`03oa4A014A00?o0000
1@0000H001?ok:c/[>b/k:c/[>b/k:c/[>b/00;o01G/[>b/k:c/[>b/k:c/[>b/k:c/[?l04e`0?_on
e_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:ALY5bTG:ALY5bTG:ALY7o[nj_kZo^[nj_kZo^[nj_kZo^[nko
4m`0?_lC0A<14`4C0A<14`4C0A<14`4CooD?m@oe3oD?m@oe3oD?m@oe3oGoEF9EHUEREF9EHUEREF9E
HUEREF;o4m800ooOg`0Ag`0Eoa5O4ElAGa5O4ElAGa5O4ElAGa7o00L00006000Cojc/[>b/k:c/[>b/
k:c/[>b/k002o`1V[>b/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOl?oPon3oh?
oPon3oh?oPon3oh?og88LPQb2788LPQb2788LPQb27;okjo_[nn_kjo_[nn_kjo_[nn_kjoo4m`0?_l1
4`4C0A<14`4C0A<14`4C0A<1o`o>3lh?cPo>3lh?cPo>3lh?cPooOX1nP7j0OX1nP7j0OX1nP7j0OX3o
4m800ooOg`0Ag`03oa4A014A00?o00001@0000H001?ok:c/[>b/k:c/[>b/k:c/[>b/00;o01G/[>b/
k:c/[>b/k:c/[>b/k:c/[?l04e`0?_one_kFo]Kne_kFo]Kne_kFo]Knoi5bTG:ALY5bTG:ALY5bTG:A
LY7o[nj_kZo^[nj_kZo^[nj_kZo^[nko4m`0?_lC0A<14`4C0A<14`4C0A<14`4CooD?m@oe3oD?m@oe
3oD?m@oe3oGoEF9EHUEREF9EHUEREF9EHUEREF;o4m800ooOg`0Ag`0Eoa5O4ElAGa5O4ElAGa5O4ElA
Ga7o00L00006000Cojc/[>b/k:c/[>b/k:c/[>b/k002o`1V[>b/k:c/[>b/k:c/[>b/k:c/[>codIcA
W=6LdIcAW=6LdIcAW=6LdOl?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb2788LPQb27;okjo_
[nn_kjo_[nn_kjo_[nn_kjoo4m`0?_l14`4C0A<14`4C0A<14`4C0A<1o`o>3lh?cPo>3lh?cPo>3lh?
cPooOX1nP7j0OX1nP7j0OX1nP7j0OX3o4m800ooOg`0Ag`03oa4A014A00?o00001@0000H0ool9o`L0
0006000Co`Qb2788LPQb2788LPQb2788LP02o`1j2788LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?
oPon3oh?oPon3ooAW=6LdIcAW=6LdIcAW=6LdIcAonb/k:c/[>b/k:c/[>b/k:c/[>cocPo>3lh?cPo>
3lh?cPo>3lh?cPoo0A<14`4C0A<14`4C0A<14`4C0OlCg00Eojo_[nn_kjo_[nn_kjo_[nn_kjoo01@A
00?ogml04Ml00ooBdP0AdP0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o00L00006000Cog:ALY5bTG:ALY5b
TG:ALY5bT@02o`0YLY5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kne_kFo]Kne_kFo_l04e`0?_n/
k:c/[>b/k:c/[>b/k:c/[>b/o`oe3oD?m@oe3oD?m@oe3oD?m@oeoa<14`4C0A<14`4C0A<14`4C0A?o
4m`0:_o^[nj_kZo^[nj_kZo^[nj_kZo^oelAGa5O4ElAGa5O4ElAGa5O4ElAoa?O00?od]804M805OmR
EF9EHUEREF9EHUEREF9EHUERo`0700001P004ol8LPQb2788LPQb2788LPQb27800_l0NPQb2788LPQb
2788LPQb2788LPQbo`on3oh?oPon3oh?oPon3oh?oPoodIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/
[>b/k:c/[>b/k:c/olh?cPo>3lh?cPo>3lh?cPo>3lh?o`4C0A<14`4C0A<14`4C0A<14`7o4m`05On_
kjo_[nn_kjo_[nn_kjo_[nn_o`0D4@03omoO017O00?od]804M805On0OX1nP7j0OX1nP7j0OX1nP7j0
o`0700001P004ombTG:ALY5bTG:ALY5bTG:ALY400_l0:G:ALY5bTG:ALY5bTG:ALY5bTG:AookFo]Kn
e_kFo]Kne_kFo]Kne_ko01=L03ko[>b/k:c/[>b/k:c/[>b/k:c/[?l?m@oe3oD?m@oe3oD?m@oe3oD?
mOlC0A<14`4C0A<14`4C0A<14`4Coa?L02[okZo^[nj_kZo^[nj_kZo^[nj_k_mO4ElAGa5O4ElAGa5O
4ElAGa5O4OlCg`03om;B017B01GoHUEREF9EHUEREF9EHUEREF9EH_l01`0000H001?o2788LPQb2788
LPQb2788LPQb00;o07X8LPQb2788LPQb2788LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?om6LdIcA
W=6LdIcAW=6LdIcAW=7ok:c/[>b/k:c/[>b/k:c/[>b/k?o>3lh?cPo>3lh?cPo>3lh?cPo>3ol14`4C
0A<14`4C0A<14`4C0A<1oa?L01Go[nn_kjo_[nn_kjo_[nn_kjo_[ol051400ooOg`0Ag`03om;B017B
01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l01`0000H000KoLY5bTG83o`0:LY5bTG:ALY5bT@;o00EbTG:A
LP03o`0BLY5bTG:ALY5bTG:AookFo]Kn0ol03?kFo]Kne_kFo]Kno`EL0ol;G006ojc/[>b/0ol03Zc/
[>b/k:c/[>b/o`oe0ol05OD?m@oe3oD?m@oe3oD?mOlC0A<14`03o`0<4`4C0A<14`4C0A?o0]`3o`kL
00?okZl00ol05:o^[nj_kZo^[nj_kZo^oelAGa5O0ol03ElAGa5O4ElAGa5O4Ol01Ml3o`_O00?od]80
0m83o`_B00KoHUEREF83o`0<HUEREF9EHUEREF;o1`0000H001?o2788LPQb27;oLPQb2788LPQb00;o
07X8LPQb2788L_mb2788LPQb2788L_l?oPon3oh?o_on3oh?oPon3oh?om6LdIcAW=6LoicAW=6LdIcA
W=7ok:c/[>b/k:co[>b/k:c/[>b/k?o>3lh?c_o>3lh?cPo>3lh?cPo>3ol14`4C0A<14olC0A<14`4C
0A<1o`GL00?og=`02m`05On_kjo_[on_kjo_[nn_kjo_[nn_o`084@03oa4A00TA00?ogml01]l00ooO
g`08g`03om;B00KB00?od]802=805On0OX1nP7j0O_mnP7j0OX1nP7j0o`0700001P001_mbTG:ALPCo
00VAL_ooTG:ALY400_l01G:ALY5b00Co016AL_ooTG:ALY5bTOone_kFoP04o`0;e_ooomKne_kFo_l0
1E`4o`9L0_l6G006ojc/[>b/1?l03Nb/ojc/[>b/k:co3oD01?l020ooool?m@oe0_l02Poe3oGo4`4C
0A<4o`0;0Oooo`4C0A<14ol00]`4o`04g?ooo`?L1?l2g003onj_00Co00O^ooookZo^00?o00W^[nko
Ga5O4El01?l00a7oo`02o`07Ga5O4ElAo`05g`Co00COoooo1]l00ooBdP03dPCo0]83o`GB00KoHUER
EF84o`0;EOoooeEREF9EH_l01`0000H001?o2788L_mb27;oL_mb2?l8LPQb00;o07`8LPQbog88L_mb
og88o`Qb2788L_l?oPonooh?o_on3oh?o`on3oh?om6LdIcoW=6LoicoW=7odIcAW=7ok:c/[?n/k:co
[>cok:c/[>b/k?o>olh?c_o>3ol?cPo>olh?o`o>3ol14`4Coa<14olC0A<1o`4C0A<1omco0m`01?oL
g?l5g003omcL00;L01Go[on_kjoo[nookjo_[nookjo_[ol011401OlA4A7o008A00?o4A401Q400ooO
g`02g`05omoOgol00]l00ooOg`05g`03om;B00;B00God];Bo`03dP03om;B00CB01GoP7j0O_mnP7ko
OX1nP?n0OX1nP?l01`0000H001?oLY5bTOnALY7oTOnAL_mbTG:A00;o02UbTG:Aoi5bTOnAoi5bog:A
LY5bTOone_kFomKne_oFo]KnookFo]Kno`04G007oeaLG?mLo`02G003oeaL00=L03Go[>b/k?o/[>co
k:c/onb/k:c/[?l?o`oe3ol?mOoe3oD?o`oeooD?mOlC0A<1o`4C0Ol14`03o`084`4C0A?og?l3g004
omcLo`KL02kog=cLonkokZo^onj_ojo^[nj_ojo^[nkoGa5O4OlAGa7o4ElAoa5O4ElAGa7o1=l01OoO
gmoo00;O00?ogml01Ml00ooBdP02dP06om;Bd_oB1?l5dP0Eof9EHUGoEF9EoeEREF;oHUEREF;o00L0
0006000;o`Qb27;oLPQbog800ol01G88LPQb00;o00X8LPQbog88L_mb0ol04W88LPQb27;o3oh?o_on
3okooP?o01;n3oh?oPoodIcAW?nLdIcoW=42o`16W=6LdIcAonb/k:co[>b/ojc/[?n/k:c/[>coc_o>
3lkocPoo3lh?c_o>3ol?cPoo0A<14olC0A?o4olC0Ol14`4C0OoLo`?L00Cog=co1m`06?oLg?n_ojo_
[on_koo_[nn_koo_[nn_o`@A00Go4A4Ao`044@03oa4A00@A00?ogml00]l01OoOgmoo00;O00?ogml0
1Ml00ooBdP02dP09om;Bd_oBom;o00KB00coP7j0O_mnP7koOX02o`07OX1nP7j0o`0700001P001_mb
TG:ALPKo00NALY5bTG:A00;o00EbTG:ALP06o`0?TG:ALY5bTG:AookFo]Kn00Ko00WFo]Kne_kFo_l0
1E`6o`9L00?oG5`00e`01_n/k:c/[0Go00b/k:co[>b/k:co3oD5o`0CmOoe3oD?o`oeooD?mOlC0A<1
4`06o`090A?o4`4C0A?o00;L1Ol00mcog003g004omcLo`;L00?okZl01Ol04Zoo[nj_kZoo[nj_k_mO
4ElAG`Ko00XAGomO4ElAGa7o1Ml5o`03gooO00KO00?od]800m86o`03d_oB00GB00KoHUEREF85o`0:
HUERof9EHUERo`L00006000<o`Qb2788LPQb27880ol010Qb2782o`0;2788LPQb2788LPP00ol04@Qb
2788L_l?oPon3oh?oPon00Co014?oPon3ooAW=6LdIcAW=6Ld@02o`0AW=6LdIcAonb/k:c/[>b/k:`0
1?l03Nb/k:c/olh?cPo>3lh00_l01@o>3lh?00;o013>3lh?o`4C0A<14`4C0A<10_l01a<14`4C0Ol0
1m`2o`GL0_l3g008ojo_[nn_kjl2o`04kjo_[`;o00G_[nn_o`0;4@;o1a400ooOg`08g`;o1ml00ooB
dP09dP;o1]802on0OX1nP7j0OX1n00?o00MnP7j0OX3o00L00006000Cog:ALY5bTG:ALY5bTG:ALY5b
T@02o`0YLY5bTG:ALY5bTG:ALY5bTG:ALY7oo]Kne_kFo]Kne_kFo]Kne_kFo_l04e`0?_n/k:c/[>b/
k:c/[>b/k:c/[>b/o`oe3oD?m@oe3oD?m@oe3oD?m@oeoa<14`4C0A<14`4C0A<14`4C0A?o4m`0:_o^
[nj_kZo^[nj_kZo^[nj_kZo^oelAGa5O4ElAGa5O4ElAGa5O4ElAoa?O00?od]804M805OmREF9EHUER
EF9EHUEREF9EHUERo`0700001P004ol8LPQb2788LPQb2788LPQb27800_l0NPQb2788LPQb2788LPQb
2788LPQbo`on3oh?oPon3oh?oPon3oh?oPoodIcAW=6LdIcAW=6LdIcAW=6LdOo/[>b/k:c/[>b/k:c/
[>b/k:c/olh?cPo>3lh?cPo>3lh?cPo>3lh?o`4C0A<14`4C0A<14`4C0A<14`7o4m`05On_kjo_[nn_
kjo_[nn_kjo_[nn_o`0D4@03omoO017O00?od]804M805On0OX1nP7j0OX1nP7j0OX1nP7j0o`070000
1P004ombTG:ALY5bTG:ALY5bTG:ALY400_l0:G:ALY5bTG:ALY5bTG:ALY5bTG:AookFo]Kne_kFo]Kn
e_kFo]Kne_ko01=L03ko[>b/k:c/[>b/k:c/[>b/k:c/[?l?m@oe3oD?m@oe3oD?m@oe3oD?mOlC0A<1
4`4C0A<14`4C0A<14`4Coa?L02[okZo^[nj_kZo^[nj_kZo^[nj_k_mO4ElAGa5O4ElAGa5O4ElAGa5O
4OlCg`03om;B017B01GoHUEREF9EHUEREF9EHUEREF9EH_l01`0000H001?o2788LPQb2788LPQb2788
LPQb00;o07X8LPQb2788LPQb2788LPQb2788L_l?oPon3oh?oPon3oh?oPon3oh?om6LdIcAW=6LdIcA
W=6LdIcAW=7ok:c/[>b/k:c/[>b/k:c/[>b/k?o>3lh?cPo>3lh?cPo>3lh?cPo>3ol14`4C0A<14`4C
0A<14`4C0A<1oa?L01Go[nn_kjo_[nn_kjo_[nn_kjo_[ol051400ooOg`0Ag`03om;B017B01GoP7j0
OX1nP7j0OX1nP7j0OX1nP?l01`0000H001?oLY5bTG:ALY5bTG:ALY5bTG:A00;o02UbTG:ALY5bTG:A
LY5bTG:ALY5bTOone_kFo]Kne_kFo]Kne_kFo]Kno`0CG00nojc/[>b/k:c/[>b/k:c/[>b/k:co3oD?
m@oe3oD?m@oe3oD?m@oe3oGo4`4C0A<14`4C0A<14`4C0A<14olCg00Zonj_kZo^[nj_kZo^[nj_kZo^
[nkoGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ml00ooBdP0AdP0Eof9EHUEREF9EHUEREF9EHUEREF;o00L0
0006000Co`Qb2788LPQb2788LPQb2788LP02o`1j2788LPQb2788LPQb2788LPQb27;o3oh?oPon3oh?
oPon3oh?oPon3ooAW=6LdIcAW=6LdIcAW=6LdIcAonb/k:c/[>b/k:c/[>b/k:c/[>cocPo>3lh?cPo>
3lh?cPo>3lh?cPoo0A<14`4C0A<14`4C0A<14`4C0OlCg00Eojo_[nn_kjo_[nn_kjo_[nn_kjoo01@A
00?ogml04Ml00ooBdP0AdP0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o00L000060?oo2Ol700001P004oon
3oh?oPon3oh?oPon3oh?oPl00_l0S_h?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb2788LPQb
27;ok:c/[>b/k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6LdIcAW=6LdIcAoa<14`4C0A<14`4C0A<14`4C
0A<1o`o>3lh?cPo>3lh?cPo>3lh?cPoo[nn_kjo_[nn_kjo_[nn_kjo_[olCg003omoO01;O00?o4A40
4A405On0OX1nP7j0OX1nP7j0OX1nP7j0o`0CdP03o`0000D00006000ComKne_kFo]Kne_kFo]Kne_kF
oP02o`0me_kFo]Kne_kFo]Kne_kFo]Kne_koTG:ALY5bTG:ALY5bTG:ALY5bTOn/k:c/[>b/k:c/[>b/
k:c/[>b/o`0CG00no`4C0A<14`4C0A<14`4C0A<14`4CooD?m@oe3oD?m@oe3oD?m@oe3oGokZo^[nj_
kZo^[nj_kZo^[nj_k_lCg003omoO01;O02Wo4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUER
EF9EHUERo`0CdP03o`0000D00006000Cooh?oPon3oh?oPon3oh?oPon3`02o`2>oPon3oh?oPon3oh?
oPon3oh?oPooLPQb2788LPQb2788LPQb2788L_o/[>b/k:c/[>b/k:c/[>b/k:c/om6LdIcAW=6LdIcA
W=6LdIcAW=7o4`4C0A<14`4C0A<14`4C0A<14`7o3lh?cPo>3lh?cPo>3lh?cPo>3on_kjo_[nn_kjo_
[nn_kjo_[nn_oa?L00?ogml04]l00olA4@0A4@0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01?B00?o0000
1@0000H001?oe_kFo]Kne_kFo]Kne_kFo]Kn00;o03gFo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:A
LY5bTG:ALY5bTG:Aojc/[>b/k:c/[>b/k:c/[>b/k:co01=L03ko0A<14`4C0A<14`4C0A<14`4C0A?o
m@oe3oD?m@oe3oD?m@oe3oD?mOo^[nj_kZo^[nj_kZo^[nj_kZo^oa?L00?ogml04]l0:OlAGa5O4ElA
Ga5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF;o01?B00?o00001@0000H001?ooPon3oh?oPon
3oh?oPon3oh?00;o08kn3oh?oPon3oh?oPon3oh?oPon3omb2788LPQb2788LPQb2788LPQbonb/k:c/
[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdOlC0A<14`4C0A<14`4C0A<14`4C0Ol?cPo>
3lh?cPo>3lh?cPo>3lh?ojo_[nn_kjo_[nn_kjo_[nn_kjoo4m`00ooOg`0Bg`03oa4A014A01GoP7j0
OX1nP7j0OX1nP7j0OX1nP?l04m800ol0000500001P001_oFo]KneP?o00[Fo]Kne_kFo]Kn0_l01MKn
e_kF00?o01;Fo]Kne_kFo]Kne_koTG:ALY43o`0ATG:ALY5bTG:ALY7o[>b/k:`00ol03:c/[>b/k:c/
[>b/o`EL0ol;G006o`4C0A<10ol03`4C0A<14`4C0A<14ooe3`03o`0A3oD?m@oe3oD?m@oe3oGokZl0
0ol03jo^[nj_kZo^[nj_kZo^o`02g0?o3]`00ooOg`03g`?o3=l01_lAGa5O4@?o014AGa5O4ElAGa5O
4OmREF9EHP03o`0<HUEREF9EHUEREF;o1M83o`_B00?o00001@0000H001?ooPon3oh?oPoo3oh?oPon
3oh?00;o08kn3oh?oPon3ol?oPon3oh?oPon3omb2788LPQb2?l8LPQb2788LPQbonb/k:c/[>b/ojc/
[>b/k:c/[>codIcAW=6LdIcoW=6LdIcAW=6LdOlC0A<14`4C0Ol14`4C0A<14`4C0Ol?cPo>3ol?cPo>
3lh?cPo>3lh?ojo_[nn_ojo_[nn_kjo_[nn_kjoo1M`00ooLg00;g003omoO00KO00?ogml02Ml00olA
4@064@03oa4A00PA01GoP7j0OX1nP7koOX1nP7j0OX1nP?l02=800ooBdP08dP03o`0000D000060006
omKne_kF1?l02Okoooone_kFoP02o`05e_kFo]H01?l04Okoooone_kFo]Knoi5bTG:A00Co011bTOoo
LY5bTG:Aojc/[>b/1?l02nb/ojc/[>b/k:co00EL1?l2G0;o1U`01_l14`4C0@Co00hCoooo4`4C0A<1
4ooe3`Co00Seoooom@oe3`;o00Ke3oGokZl4o`07k_ooonj_kP03o`04kZo^o`;L1?l01=coool3g0Co
0]`00ooOg`03g`Co00COoooo1ml01_lAGa5O4@Co00=Oool00_l02a5O4ElAof9EHUER00Co00]Eoooo
EF9EHUERo`05dPCo0]83o`GB00?o00001@0000H001?ooPon3ol?oPoo3oh?o_on3oh?00;o093n3oh?
o`on3ol?oPonooh?oPon3omb2788o`Qb2?l8o`Qbog88LPQbonb/k:co[>b/ojc/onb/k:c/[>codIcA
W?nLdIcoW?nLdOoAW=6LdOlC0A<1o`4C0Ol14`4Coa<14`4C0Ol?o`o>3ol?c_o>3lh?o`o>olh?ojoo
[nn_ojo_onn_kjo_onn_kjoog?l3g004omcLo`GL00?og=`00]`00ooOg`02g`05omoOgol00]l00ooO
g`06g`03oa4A008A00Go4A4Ao`024@03oa4A00DA01GoP7j0O_mnP7koOX1nP?n0OX1nP?l01=801OoB
d];o00?B00?od]801=800ol0000500001P004ooFo]KnookFo_one_kFomKne_h00_l0?MKne_koo]Kn
ookFo]Koe_kFo]Knoi5bTG;oLY5bog;oLY7oTG:ALY7o[>b/k?o/[>cok:c/onb/k:c/[?l015`01omL
G5coG?l00U`00omLG003G00<o`4C0A?o4`4Coa<10ol0<@4C0A<14ooeooD?mOoe3ol?m@oeooD?o`oe
onkokZo^onj_ojo^[nj_ojo^[nkog?l00m`01?oLg?l6g005omcLg?l01=l01OoOgmoo00;O00?ogml0
1]l0:OlAGa5OoelAGomO4EooGa5O4ElAof9EHUGoEF9EoeEREF;oHUEREF;o00CB00Kod];Bom84o`GB
00?o00001@0000H000_ooPon3ol?oPoo3`03o`053oh?oPl00_l02_h?oPoo3oh?o`l3o`0B3oh?oPon
3omb2788o`Qb2?l80ol09PQb2788L_o/[>b/ojc/[?n/k:co[>b/k:c/om6LdIcoW=6LoicA0_l0AYcA
W=6LdOlC0A<1o`4C0Ol1o`4Coa<14`4C0Ol?o`o>3ol?c_o>3lh?o`o>olh?ojoo[nn_ojo_onn_kjo_
onn_kjoog?l3g004omcLo`OL00Cog=co1=l01OoOgmoo00;O00?ogml01]l00olA4@024@05oa4A4Ol0
11400olA4@034@0<oh1nP7koOX1nogj00_l01gj0OX1nP?l01=802OoBd];od_oBo`06dP03o`0000D0
00060006omKne_kF1_l01okFo]Kne_h00_l01MKne_kF00Ko00one_kFo]Kne_koTG:ALY401_l03W:A
LY5bTG:Aojc/[>b/1Ol02Zc/[?n/k:c/[?l5G0Ko0U`00omLG003G006o`4C0A<11_l031<1o`4C0A<1
4ooe3`Go00l?o`oe3oGom@oo3oGokZl01Ol03Joo[nj_kZoo[nj_k_l00]`5o`03g?oL00?L00Cog=co
0]`00ooOg`03g`Go00?Ooml01ml01_lAGa5O4@Ko00iO4OlAGa5O4OmREF9EHPGo00YREF;oHUEREF;o
1M86o`03d_oB00GB00?o00001@0000H000_ooPon3oh?oPon3`04o`04oPon3`;o00[n3oh?oPon3oh?
1?l04_h?oPon3omb2788LPQb2788LP?o011b2788L_o/[>b/k:c/[>b/1?l04Nb/k:c/om6LdIcAW=6L
dIcA00;o01:LdIcAW=7o4`4C0A<14`4C0A<2o`0?0A<14`4C0Ol?cPo>3lh?00;o00G>3lh?cP02o`0;
3lh?ojo_[nn_kjl00_l01>n_kjl2o`05kjo_[ol01m`2o`GL0_l3g003omoO00SO0_l8g`03oa4A00TA
0_l64@0;oh1nP7j0OX1nP7h00ol01gj0OX1nP?l02m82o`KB00?o00001@0000H001?oe_kFo]Kne_kF
o]Kne_kFo]Kn00;o03gFo]Kne_kFo]Kne_kFo]Kne_kFo_nALY5bTG:ALY5bTG:ALY5bTG:Aojc/[>b/
k:c/[>b/k:c/[>b/k:co01=L03ko0A<14`4C0A<14`4C0A<14`4C0A?om@oe3oD?m@oe3oD?m@oe3oD?
mOo^[nj_kZo^[nj_kZo^[nj_kZo^oa?L00?ogml04]l0:OlAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUER
EF9EHUEREF9EHUEREF;o01?B00?o00001@0000H001?ooPon3oh?oPon3oh?oPon3oh?00;o08kn3oh?
oPon3oh?oPon3oh?oPon3omb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/k:c/[>b/k:c/[>codIcA
W=6LdIcAW=6LdIcAW=6LdOlC0A<14`4C0A<14`4C0A<14`4C0Ol?cPo>3lh?cPo>3lh?cPo>3lh?ojo_
[nn_kjo_[nn_kjo_[nn_kjoo4m`00ooOg`0Bg`03oa4A014A01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l0
4m800ol0000500001P004ooFo]Kne_kFo]Kne_kFo]Kne_h00_l0?MKne_kFo]Kne_kFo]Kne_kFo]Kn
oi5bTG:ALY5bTG:ALY5bTG:ALY7o[>b/k:c/[>b/k:c/[>b/k:c/[?l04e`0?_l14`4C0A<14`4C0A<1
4`4C0A<14ooe3oD?m@oe3oD?m@oe3oD?m@oeonj_kZo^[nj_kZo^[nj_kZo^[nko4m`00ooOg`0Bg`0Y
oa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EH_l04m800ol0000500001P004oon
3oh?oPon3oh?oPon3oh?oPl00_l0S_h?oPon3oh?oPon3oh?oPon3oh?og88LPQb2788LPQb2788LPQb
27;ok:c/[>b/k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6LdIcAW=6LdIcAoa<14`4C0A<14`4C0A<14`4C
0A<1o`o>3lh?cPo>3lh?cPo>3lh?cPoo[nn_kjo_[nn_kjo_[nn_kjo_[olCg003omoO01;O00?o4A40
4A405On0OX1nP7j0OX1nP7j0OX1nP7j0o`0CdP03o`0000D00006000ComKne_kFo]Kne_kFo]Kne_kF
oP02o`0me_kFo]Kne_kFo]Kne_kFo]Kne_koTG:ALY5bTG:ALY5bTG:ALY5bTOn/k:c/[>b/k:c/[>b/
k:c/[>b/o`0CG00no`4C0A<14`4C0A<14`4C0A<14`4CooD?m@oe3oD?m@oe3oD?m@oe3oGokZo^[nj_
kZo^[nj_kZo^[nj_k_lCg003omoO01;O02Wo4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUER
EF9EHUERo`0CdP03o`0000D00006000Cooh?oPon3oh?oPon3oh?oPon3`02o`2>oPon3oh?oPon3oh?
oPon3oh?oPooLPQb2788LPQb2788LPQb2788L_o/[>b/k:c/[>b/k:c/[>b/k:c/om6LdIcAW=6LdIcA
W=6LdIcAW=7o4`4C0A<14`4C0A<14`4C0A<14`7o3lh?cPo>3lh?cPo>3lh?cPo>3on_kjo_[nn_kjo_
[nn_kjo_[nn_oa?L00?ogml04]l00olA4@0A4@0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01?B00?o0000
1@0000H0ool9o`L000060003om;B013B0_lDdP0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01<A00?ogml0
4Ml0D_oAW=6LdIcAW=6LdIcAW=6LdIcAW?n/k:c/[>b/k:c/[>b/k:c/[>b/o`Qb2788LPQb2788LPQb
2788LPSooPon3oh?oPon3oh?oPon3oh?o_lDg00monn_kjo_[nn_kjo_[nn_kjo_[noocPo>3lh?cPo>
3lh?cPo>3lh?c_lC0A<14`4C0A<14`4C0A<14`4Co`0700001P000ooBdP0@dP;o5=80:OmREF9EHUER
EF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4ElAGa7o01?O00?oG5`04U`0?Oo/[>b/k:c/[>b/k:c/
[>b/k:c/og:ALY5bTG:ALY5bTG:ALY5bTG;oe_kFo]Kne_kFo]Kne_kFo]Kne_l05=`0?On_kZo^[nj_
kZo^[nj_kZo^[nj_o`oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<14`4C0Ol01`0000H0
00?od]804=82oaCB01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l04a400ooOg`0Ag`1Bom6LdIcAW=6LdIcA
W=6LdIcAW=6Lojc/[>b/k:c/[>b/k:c/[>b/k:co2788LPQb2788LPQb2788LPQb2?on3oh?oPon3oh?
oPon3oh?oPonoaCL03gokjo_[nn_kjo_[nn_kjo_[nn_koo>3lh?cPo>3lh?cPo>3lh?cPo>oa<14`4C
0A<14`4C0A<14`4C0A?o00L000060003om;B013B0_lDdP0Yof9EHUEREF9EHUEREF9EHUEREF;o4ElA
Ga5O4ElAGa5O4ElAGa5O4Ol04ml00omLG00BG00monb/k:c/[>b/k:c/[>b/k:c/[>coLY5bTG:ALY5b
TG:ALY5bTG:AL_oFo]Kne_kFo]Kne_kFo]Kne_kFo`0Dg00mojo^[nj_kZo^[nj_kZo^[nj_kZoo3oD?
m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1o`0700001P000ooBdP0@dP;o5=805On0
OX1nP7j0OX1nP7j0OX1nP7j0o`0C4@03omoO017O05;odIcAW=6LdIcAW=6LdIcAW=6LdIco[>b/k:c/
[>b/k:c/[>b/k:c/[?l8LPQb2788LPQb2788LPQb2788ooh?oPon3oh?oPon3oh?oPon3oko5=`0?Oo_
[nn_kjo_[nn_kjo_[nn_kjo_olh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C0A<14`4C0A<14ol0
1`0000H000?od]800m83o`[B0_l5dP?o3=801_mREF9EHP?o015REF9EHUEREF9EH_lAGa5O4@03o`0<
4ElAGa5O4ElAGa7o1Ml3o`_O00?oG5`00e`3o`aL00Kok:c/[>`3o`0Ak:c/[>b/k:c/[>coLY5bTG80
0ol04G:ALY5bTG:ALY5bomKne_kF00?o00cFo]Kne_kFo]Kne_l2g0?o3m`00on_kP03o`0AkZo^[nj_
kZo^[nj_kZoo3oD00ol05?D?m@oe3oD?m@oe3oD?o`4C0A<10ol0304C0A<14`4C0A<1o`L000060003
om;B00KB00?od]801m82o`SB00?od]802M805On0OX1nP7j0O_mnP7j0OX1nP7j0o`084@03oa4A00PA
00?ogml01]l00ooOg`08g`1Bom6LdIcAW=6LoicAW=6LdIcAW=6Lojc/[>b/k:c/onb/k:c/[>b/k:co
2788LPQb27;oLPQb2788LPQb2?on3oh?oPon3ol?oPon3oh?oPono`GL00?og=`03=`0?Oo_[nn_koo_
[nn_kjo_[nn_kjo_olh?cPo>olh?cPo>3lh?cPo>3lko4`4C0A<14`7o0A<14`4C0A<14ol01`0000H0
00?od]800m84o`;B0ol4dP;o1M84o`;B0ol6dP06of9EHUER1?l045GooomEHUEREF;o4ElAGa44o`03
Gooo00;o00HAGa5O4Ol5g`Co00COoooo1]l00omLG003G0Co0U`2o`ML00Kok:c/[>`4o`0@[>cok:c/
[>b/k?mbTG:ALPCo012AL_ooTG:ALY5bomKne_kF1?l02okoooone_kFo]Ko00;L1?l01=coool3g0Co
0m`00on_kP04o`07[oooojo^[`03o`06[nj_o`oe1?l020ooool?m@oe0_l02@oe3ol14`4C0@04o`0;
4ooooa<14`4C0Ol01`0000H000?od]800]801OoBd];o00?B00?od]800m82o`CB00God];Bo`03dP03
om;B00GB01GoP7j0O_mnP7koOX1nP?n0OX1nP?l011401OlA4A7o008A00?o4A401A400ooOg`02g`05
omoOgol00]l00ooOg`05g`1Dom6LdIcoW=6LoicoW=7odIcAW=6Lojc/[>cok:c/onb/ojc/[>b/k:co
2788L_mb27;oL_mb2?l8LPQb2?on3oh?o`on3ol?oPonooh?oPonomco0m`01?oLg?l5g003omcL00?L
03gokoo_[nookjoo[nn_kjoo[nn_koo>olh?c_o>3ol?cPo>olh?o`o>oa<14`7o0A<1o`4C0A?o4`4C
0A?o00L000060003om;B00;B00Kod];Bom84o`CB0_l4dP06om;Bd_oB1?l6dP0Yof9EHUGoEF9EoeER
EF;oHUEREF;o4ElAGomO4EooGa5OoelAGa5O4Ol01=l01OoOgmoo00;O00?ogml01Ml00omLG002G007
oeaLG?mLo`02G003oeaL00AL03ook:c/[?n/k:co[>b/ojc/[>b/k?mbTG:Aoi5bTOnAoi5bog:ALY5b
omKne_koo]KnookFo]Koe_kFo]Kog?l00m`01?oLg?l6g003omcL00;L03Co[on_kZoo[nkokZo^[nko
kZo^[ol?o`oe3ol?mOoe3oD?o`oeooD?o`4C0A?o4`4Coa<10ol01P4C0A<1o`L000060003om;B00;B
00Wod];Bom;od_l01M82o`CB00Wod];Bom;od_l01m803?n0OX1nogj0O_mnP0;o00MnP7j0OX3o00@A
00Go4A4Ao`044@03oa4A00<A00?ogml00]l01OoOgmoo00;O00?ogml01Ml03?oAW=6LoicAW?nLd@;o
02JLdIcAW=6Lojc/[>cok:c/onb/k?o/[>b/k:co2788L_mb27;oLP?o015b2788LPSooPon3ol?oPoo
3`03o`093oh?oPonomco00?L00Cog=co1m`0@OoLg=cokoo_[nookjoo[nn_kjoo[nn_koo>olh?c_o>
3ol?cPo>olh?o`o>oa<14`7o0A<1o`7o0A?o4`4C0A?o00L000060003om;B00?B1_l00m;odP04dP;o
1M86o`03d_oB00KB00KoHUEREF85o`0?HUERof9EHUERoa5O4ElA00Ko00UO4OlAGa5O4Ol01Ml5o`03
gooO00KO00?oG5`00e`6o`9L00?oG5`015`01_o/[>b/k0Go00o/[>cok:c/[>coLY5bTG801_l03Y5b
TG:ALY5bomKne_kF1_l02OkFo]Kne_kFo`02g0Go00?Lom`00m`01?oLg?l3g003ojo^00Go00o^onj_
kZo^onj_kZoo3oD01Ol04_Gom@oe3ol?mOoe3ol14`4C0@Ko00TC0Ol14`4C0Ol01`0000H000?od]80
2M82o`GB0_l;dP;o1m802on0OX1nP7j0OX1n00?o00MnP7j0OX3o00/A0_l64@03omoO00SO0_l7g`0<
om6LdIcAW=6LdIcA0_l04YcAW=6LdIco[>b/k:c/[>b/k0Co016/k:c/[?l8LPQb2788LPQb2003o`0@
2788LPSooPon3oh?oPon3`Co00Kn3oh?o_l7g0;o1M`2o`CL00Sokjo_[nn_k`;o00B_kjo_0_l03:o_
[noocPo>3lh?cP;o00D?cPo>3`02o`0?cPo>oa<14`4C0A<14`4C00;o00L14`4C0A?o00L000060003
om;B013B0_lDdP0Yof9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4Ol04ml00omL
G00BG00monb/k:c/[>b/k:c/[>b/k:c/[>coLY5bTG:ALY5bTG:ALY5bTG:AL_oFo]Kne_kFo]Kne_kF
o]Kne_kFo`0Dg00mojo^[nj_kZo^[nj_kZo^[nj_kZoo3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<1
4`4C0A<14`4C0A<1o`0700001P000ooBdP0@dP;o5=805On0OX1nP7j0OX1nP7j0OX1nP7j0o`0C4@03
omoO017O05;odIcAW=6LdIcAW=6LdIcAW=6LdIco[>b/k:c/[>b/k:c/[>b/k:c/[?l8LPQb2788LPQb
2788LPQb2788ooh?oPon3oh?oPon3oh?oPon3oko5=`0?Oo_[nn_kjo_[nn_kjo_[nn_kjo_olh?cPo>
3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C0A<14`4C0A<14ol01`0000H000?od]804=82oaCB02WoHUER
EF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAo`0Cg`03oeaL019L03gok:c/[>b/k:c/
[>b/k:c/[>b/k?mbTG:ALY5bTG:ALY5bTG:ALY5bomKne_kFo]Kne_kFo]Kne_kFo]Ko01CL03go[nj_
kZo^[nj_kZo^[nj_kZo^[ol?m@oe3oD?m@oe3oD?m@oe3oD?o`4C0A<14`4C0A<14`4C0A<14`7o00L0
00060003om;B013B0_lDdP0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01<A00?ogml04Ml0D_oAW=6LdIcA
W=6LdIcAW=6LdIcAW?n/k:c/[>b/k:c/[>b/k:c/[>b/o`Qb2788LPQb2788LPQb2788LPSooPon3oh?
oPon3oh?oPon3oh?o_lDg00monn_kjo_[nn_kjo_[nn_kjo_[noocPo>3lh?cPo>3lh?cPo>3lh?c_lC
0A<14`4C0A<14`4C0A<14`4Co`0700001P000ooBdP0@dP;o5=80:OmREF9EHUEREF9EHUEREF9EHUER
oa5O4ElAGa5O4ElAGa5O4ElAGa7o01?O00?oG5`04U`0?Oo/[>b/k:c/[>b/k:c/[>b/k:c/og:ALY5b
TG:ALY5bTG:ALY5bTG;oe_kFo]Kne_kFo]Kne_kFo]Kne_l05=`0?On_kZo^[nj_kZo^[nj_kZo^[nj_
o`oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<14`4C0Ol01`0000H000?od]804=82oaCB
01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l04a400ooOg`0Ag`1Bom6LdIcAW=6LdIcAW=6LdIcAW=6Lojc/
[>b/k:c/[>b/k:c/[>b/k:co2788LPQb2788LPQb2788LPQb2?on3oh?oPon3oh?oPon3oh?oPonoaCL
03gokjo_[nn_kjo_[nn_kjo_[nn_koo>3lh?cPo>3lh?cPo>3lh?cPo>oa<14`4C0A<14`4C0A<14`4C
0A?o00L000060003om;B013B0_lDdP0Yof9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElA
Ga5O4Ol04ml00omLG00BG00monb/k:c/[>b/k:c/[>b/k:c/[>coLY5bTG:ALY5bTG:ALY5bTG:AL_oF
o]Kne_kFo]Kne_kFo]Kne_kFo`0Dg00mojo^[nj_kZo^[nj_kZo^[nj_kZoo3oD?m@oe3oD?m@oe3oD?
m@oe3ol14`4C0A<14`4C0A<14`4C0A<1o`0700001P3oo`Wo1`0000H001?oEF9EHUEREF9EHUEREF9E
HUER00;o01EEHUEREF9EHUEREF9EHUEREF9EH_l04m800ooOg`0Ag`0Zoa5O4ElAGa5O4ElAGa5O4ElA
Ga7o[>b/k:c/[>b/k:c/[>b/k:c/[>co4e`0?_oFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5b
TG:ALY5bTG;okZo^[nj_kZo^[nj_kZo^[nj_kZoo4m`0:Ol14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?
m@oe3oD?m@oe3oD?m@oo00L00006000Cogj0OX1nP7j0OX1nP7j0OX1nP002o`0EOX1nP7j0OX1nP7j0
OX1nP7j0OX3o01?B00?ogml04Ml00olA4@0A4@1Wonb/k:c/[>b/k:c/[>b/k:c/[>b/oicAW=6LdIcA
W=6LdIcAW=6LdIcooPon3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788ojo_[nn_kjo_
[nn_kjo_[nn_kjo_o`0Cg00Yoa<14`4C0A<14`4C0A<14`4C0A?ocPo>3lh?cPo>3lh?cPo>3lh?c_l0
1`0000H001?oEF9EHUEREF9EHUEREF9EHUER00;o01EEHUEREF9EHUEREF9EHUEREF9EH_l04m800ooO
g`0Ag`0Zoa5O4ElAGa5O4ElAGa5O4ElAGa7o[>b/k:c/[>b/k:c/[>b/k:c/[>co4e`0?_oFo]Kne_kF
o]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG;okZo^[nj_kZo^[nj_kZo^[nj_kZoo4m`0:Ol1
4`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo00L00006000Cogj0OX1nP7j0OX1n
P7j0OX1nP002o`0EOX1nP7j0OX1nP7j0OX1nP7j0OX3o01?B00?ogml04Ml00olA4@0A4@1Wonb/k:c/
[>b/k:c/[>b/k:c/[>b/oicAW=6LdIcAW=6LdIcAW=6LdIcooPon3oh?oPon3oh?oPon3oh?o_l8LPQb
2788LPQb2788LPQb2788ojo_[nn_kjo_[nn_kjo_[nn_kjo_o`0Cg00Yoa<14`4C0A<14`4C0A<14`4C
0A?ocPo>3lh?cPo>3lh?cPo>3lh?c_l01`0000H001?oEF9EHUEREF9EHUEREF9EHUER00;o01EEHUER
EF9EHUEREF9EHUEREF9EH_l04m800ooOg`0Ag`0Zoa5O4ElAGa5O4ElAGa5O4ElAGa7o[>b/k:c/[>b/
k:c/[>b/k:c/[>co4e`0?_oFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG;okZo^
[nj_kZo^[nj_kZo^[nj_kZoo4m`0:Ol14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?
m@oo00L000060006ogj0OX1n0ol02Wj0OX1nP7j0OX02o`05OX1nP7h00ol03Gj0OX1nP7j0OX1nP?l0
1M83o`_B00?ogml00ml3o`_O00?o4A400a43o`/A00Kok:c/[>`3o`0Bk:c/[>b/k:c/[>b/oicAW=6L
0ol04IcAW=6LdIcAW=6Looh?oPon00?o017n3oh?oPon3oh?o_l8LPQb2003o`0>2788LPQb2788LPSo
[nl3o`0@kjo_[nn_kjo_[nn_kjo_o`;L0ol>g006oa<14`4C0ol03Q<14`4C0A<14`4Colh?0ol03`o>
3lh?cPo>3lh?cPo>o`0700001P004omEHUEREF9EH_mREF9EHUEREF800_l05EEREF9EHUERof9EHUER
EF9EHUERo`08dP03om;B00SB00?ogml01]l00ooOg`08g`0Zoa5O4ElAGa5OoelAGa5O4ElAGa7o[>b/
k:c/[>cok:c/[>b/k:c/[>co25`00omLG008G00nomKne_kFo]KnookFo]Kne_kFo]KoLY5bTG:ALY7o
TG:ALY5bTG:AL_o^[nj_k_o^[nj_kZo^[nj_kZo^[ol5g003omcL00_L02Wo0A<14`4C0A?o4`4C0A<1
4`4C0Ol?m@oe3ol?m@oe3oD?m@oe3oD?o`0700001P001_mnP7j0OPCo00V0ooooP7j0OX000_l01Gj0
OX1n00Co00b0ooooP7j0OX1nP?l5dPCo0]83o`GB00?ogml00ml4o`04goooo`KO00?o4A400a44o`03
4Ooo00;o1A401_o/[>b/k0Co016/k?o/[>b/k:c/[?nLdIcAW004o`0@dIcoom6LdIcAW?on3oh?oPCo
010?oooo3oh?oPono`Qb27881?l03G88oomb2788LPSo[nl01?l01joooon_kjl00ol01Jo_[noo00;L
1?l01=coool3g0Co0]`01_lC0A<14`Co00d1oooo0A<14`4Colh?00Co00S>oooocPo>3`;o00C>3lko
1`0000H001?oEF9EH_mREF;oHUEREOmEHUER00;o01EEHUERof9EH_mREF9EoeEREF9EH_l01=801OoB
d];o00?B00?od]801=800ooOg`02g`05omoOgol00]l00ooOg`05g`0Zoa5O4EooGa5OoelAoa5O4ElA
Ga7o[>b/k?o/[>cok:co[>b/k:c/[>co15`01omLG5coG?l00U`00omLG003G010omKne_koo]KnookF
o]Koe_kFo]KoLY5bTOnALY7oTOnAL_mbTG:AL_o^onj_k_o^[on_kZo^[on_kZo^[ooLo`?L00Cog=co
1M`00ooLg002g00Yo`4C0A?o4`4Coa<14`7o0A<14`7o3ol?m@oo3oGom@oe3ol?mOoe3ol01`0000H0
01?oOX1nP?n0OX3oP7j0O_mnP7j000;o01EnP7j0oh1nP?n0OX1nogj0OX1nP?l01=801_oBd];odPCo
1M800ooOg`02g`05omoOgol00]l00ooOg`05g`03oa4A008A00Go4A4Ao`034@03oa4A00@A06Wok:c/
[?n/k:co[>b/ojc/[>b/k:coW=6LdOoAW=7odOoAW?nLdIcAW?on3oh?o`on3ol?oPonooh?oPono`Qb
27;oLPQbog;oLPSo2788LPSo[on_kjoo[nookjo_[nookjo_[noog?l00m`01?oLg?l6g00@omcLg?lC
0A<1o`4C0Ol14`?o01XC0A<14oo>olh?c_o>3ol?cPo>olh?o`o>o`L00006000<oeEREF;oHUERof9E
0_l01F9EHUER00;o00]EHUERof9EH_mRE@02o`08HUEREF9EH_l4dP09om;Bd_oBom;o00KB00?ogml0
0]l01OoOgmoo00;O00?ogml01Ml0:_lAGa5OoelAGomO4ElAoa5O4ElAojc/[>cok:c/onb/k?o/[>b/
k:c/o`AL00GoG5aLo`02G0;o1U`02ooFo]KnookFo_on00?o017ne_kFo]KoLY5bTOnALY7oT@03o`0N
TG:ALY5bonkokZo^onj_ojo^[nj_ojo^[nj_omco0m`01?oLg?l7g00/omcLo`4C0A?o4`4Coa?o4`7o
0A<14`7o3ol?m@oo3oGom@oe3ol?mOoe3ol700001P001_mnP7j0OPGo00QnP7koOX1nP0;o00EnP7j0
OP05o`0;OX1nogj0OX1nP?l01M86o`03d_oB00GB00?ogml00ml5o`03gooO00KO00?o4A400a46o`8A
00?o4A400a401_o/[>b/k0Go013/[>cok:c/[>b/oicAW=6L1_l03]6LoicAW=6Looh?oPon1_l03Pon
3oh?oPono`Qb27881_l02g88LPQb2788ojo_00Go00k_onn_kjo_onn_kjo_o`;L1Ol00mcog003g004
omcLo`;L00Ko4`4C0A<6o`0;0A?o4`4C0A?ocPl01Ol03@oo3lh?c_o>3ol?c_l01`0000H000_oEF9E
HUEREF9EHP03o`05HUEREF800_l02UEREF9EHUEREF83o`08HUEREF9EH_l;dP;o1]800ooOg`08g`;o
1ml03?lAGa5O4ElAGa5O4@;o015O4ElAGa7o[>b/k:c/[>b/k004o`07[>b/k:c/o`0;G0;o1U`02ooF
o]Kne_kFo]Kn00Co017Fo]Kne_mbTG:ALY5bTG:ALP03o`0=LY5bTG;okZo^[nj_kP02o`04[nj_kP;o
00J_kZo^[ol7g0;o1M`2o`?L00co0A<14`4C0A<14`42o`0>4`4C0A<1o`oe3oD?m@l2o`05m@oe3oD0
0_l010oe3ol700001P004omnP7j0OX1nP7j0OX1nP7j0OX000_l05Gj0OX1nP7j0OX1nP7j0OX1nP7j0
o`0CdP03omoO017O00?o4A404A40Ioo/[>b/k:c/[>b/k:c/[>b/k:c/[?nLdIcAW=6LdIcAW=6LdIcA
W=6Looh?oPon3oh?oPon3oh?oPon3oko2788LPQb2788LPQb2788LPQb2?n_kjo_[nn_kjo_[nn_kjo_
[nn_kol04m`0:OlC0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>3lko00L00006000C
oeEREF9EHUEREF9EHUEREF9EHP02o`0EEF9EHUEREF9EHUEREF9EHUEREF;o01?B00?ogml04Ml0:_lA
Ga5O4ElAGa5O4ElAGa5O4ElAojc/[>b/k:c/[>b/k:c/[>b/k:c/oa=L03koe_kFo]Kne_kFo]Kne_kF
o]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5bonj_kZo^[nj_kZo^[nj_kZo^[nj_oa?L02Wo0A<14`4C0A<1
4`4C0A<14`4C0Ol?m@oe3oD?m@oe3oD?m@oe3oD?o`0700001P004omnP7j0OX1nP7j0OX1nP7j0OX00
0_l05Gj0OX1nP7j0OX1nP7j0OX1nP7j0o`0CdP03omoO017O00?o4A404A40Ioo/[>b/k:c/[>b/k:c/
[>b/k:c/[?nLdIcAW=6LdIcAW=6LdIcAW=6Looh?oPon3oh?oPon3oh?oPon3oko2788LPQb2788LPQb
2788LPQb2?n_kjo_[nn_kjo_[nn_kjo_[nn_kol04m`0:OlC0A<14`4C0A<14`4C0A<14`4Colh?cPo>
3lh?cPo>3lh?cPo>3lko00L00006000CoeEREF9EHUEREF9EHUEREF9EHP02o`0EEF9EHUEREF9EHUER
EF9EHUEREF;o01?B00?ogml04Ml0:_lAGa5O4ElAGa5O4ElAGa5O4ElAojc/[>b/k:c/[>b/k:c/[>b/
k:c/oa=L03koe_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5bonj_kZo^[nj_kZo^
[nj_kZo^[nj_oa?L02Wo0A<14`4C0A<14`4C0A<14`4C0Ol?m@oe3oD?m@oe3oD?m@oe3oD?o`070000
1P004omnP7j0OX1nP7j0OX1nP7j0OX000_l05Gj0OX1nP7j0OX1nP7j0OX1nP7j0o`0CdP03omoO017O
00?o4A404A40Ioo/[>b/k:c/[>b/k:c/[>b/k:c/[?nLdIcAW=6LdIcAW=6LdIcAW=6Looh?oPon3oh?
oPon3oh?oPon3oko2788LPQb2788LPQb2788LPQb2?n_kjo_[nn_kjo_[nn_kjo_[nn_kol04m`0:OlC
0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>3lko00L00006000CoeEREF9EHUEREF9E
HUEREF9EHP02o`0EEF9EHUEREF9EHUEREF9EHUEREF;o01?B00?ogml04Ml0:_lAGa5O4ElAGa5O4ElA
Ga5O4ElAojc/[>b/k:c/[>b/k:c/[>b/k:c/oa=L03koe_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5b
TG:ALY5bTG:ALY5bonj_kZo^[nj_kZo^[nj_kZo^[nj_oa?L02Wo0A<14`4C0A<14`4C0A<14`4C0Ol?
m@oe3oD?m@oe3oD?m@oe3oD?o`0700001P3oo`Wo1`0000H001?oGa5O4ElAGa5O4ElAGa5O4ElA00;o
01EO4ElAGa5O4ElAGa5O4ElAGa5O4Ol04ml00ooBdP0AdP0nof9EHUEREF9EHUEREF9EHUEREF;oTG:A
LY5bTG:ALY5bTG:ALY5bTG;oe_kFo]Kne_kFo]Kne_kFo]Kne_lCG00nonb/k:c/[>b/k:c/[>b/k:c/
[>com@oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<14`4C0OlCg00Eojo^[nj_kZo^[nj_
kZo^[nj_kZoo00L000060003oa4A010A0_lD4@03omoO017O00?od]804M80Son0OX1nP7j0OX1nP7j0
OX1nP7j0og88LPQb2788LPQb2788LPQb2788ooh?oPon3oh?oPon3oh?oPon3okoW=6LdIcAW=6LdIcA
W=6LdIcAW?n/k:c/[>b/k:c/[>b/k:c/[>b/o`o>3lh?cPo>3lh?cPo>3lh?cPo>oa<14`4C0A<14`4C
0A<14`4C0A?o01?L01Gokjo_[nn_kjo_[nn_kjo_[nn_kol01`0000H001?oGa5O4ElAGa5O4ElAGa5O
4ElA00;o01EO4ElAGa5O4ElAGa5O4ElAGa5O4Ol04ml00ooBdP0AdP0nof9EHUEREF9EHUEREF9EHUER
EF;oTG:ALY5bTG:ALY5bTG:ALY5bTG;oe_kFo]Kne_kFo]Kne_kFo]Kne_lCG00nonb/k:c/[>b/k:c/
[>b/k:c/[>com@oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<14`4C0OlCg00Eojo^[nj_
kZo^[nj_kZo^[nj_kZoo00L000060003oa4A010A0_lD4@03omoO017O00?od]804M80Son0OX1nP7j0
OX1nP7j0OX1nP7j0og88LPQb2788LPQb2788LPQb2788ooh?oPon3oh?oPon3oh?oPon3okoW=6LdIcA
W=6LdIcAW=6LdIcAW?n/k:c/[>b/k:c/[>b/k:c/[>b/o`o>3lh?cPo>3lh?cPo>3lh?cPo>oa<14`4C
0A<14`4C0A<14`4C0A?o01?L01Gokjo_[nn_kjo_[nn_kjo_[nn_kol01`0000H001?oGa5O4ElAGa5O
4ElAGa5O4ElA00;o01EO4ElAGa5O4ElAGa5O4ElAGa5O4Ol04ml00ooBdP0AdP0nof9EHUEREF9EHUER
EF9EHUEREF;oTG:ALY5bTG:ALY5bTG:ALY5bTG;oe_kFo]Kne_kFo]Kne_kFo]Kne_lCG00nonb/k:c/
[>b/k:c/[>b/k:c/[>com@oe3oD?m@oe3oD?m@oe3oD?m@oo0A<14`4C0A<14`4C0A<14`4C0OlCg00E
ojo^[nj_kZo^[nj_kZo^[nj_kZoo00L000060003oa4A00<A0ol:4@;o1A43o``A00?ogml00ml3o`_O
00?od]800m83o`_B00KoP7j0OX03o`0AP7j0OX1nP7j0OX3oLPQb27800ol04W88LPQb2788LPQb2?on
3oh?oP?o017n3oh?oPon3oh?o_nLdIcAW003o`0AW=6LdIcAW=6LdIco[>b/k:`00ol03Zc/[>b/k:c/
[>b/o`o>0ol05Lh?cPo>3lh?cPo>3lh?c_lC0A<14`03o`0<4`4C0A<14`4C0A?o0]`3o`kL00?okjl0
0ol03jo_[nn_kjo_[nn_kjo_o`0700001P004omO4ElAGa5O4OlAGa5O4ElAGa400_l05ElAGa5O4ElA
oa5O4ElAGa5O4ElAo`08g`03omoO00SO00?od]801]800ooBdP08dP0nof9EHUEREF9EoeEREF9EHUER
EF;oTG:ALY5bTG;oLY5bTG:ALY5bTG;oe_kFo]Kne_koo]Kne_kFo]Kne_l8G003oeaL00QL03kok:c/
[>b/k:co[>b/k:c/[>b/k?oe3oD?mOoe3oD?m@oe3oD?m@oe3ol14`4C0A<14olC0A<14`4C0A<1o`GL
00?og=`02m`05On_kZo^[on_kZo^[nj_kZo^[nj_o`0700001P000olA4@034@Co00<Aool00_l44@;o
1A44o`034Ooo00;o1Q400ooOg`03g`Co00COoooo1]l00ooBdP03dPCo0]83o`GB00KoP7j0OX04o`0@
O_ooogj0OX1nP?mb2788LPCo0148L_oo2788LPQb2?on3oh?oP04o`0@3oooo`on3oh?o_nLdIcAW0Co
013AW?oodIcAW=6Lojc/[>b/1?l03Nb/ojc/[>b/k:co3lh01?l020ooool?cPo>0_l02Po>3lko4`4C
0A<4o`0;0Oooo`4C0A<14ol00]`4o`04g?ooo`?L1?l2g003onn_00Co00O_ooookjo_00?o00C_[noo
1`0000H001?oGa5O4OlAGa7o4EooGa5O4ElA00;o01EO4ElAoa5O4OlAGomO4ElAGa5O4Ol01=l01OoO
gmoo00;O00?ogml01Ml00ooBdP02dP05om;Bd_l00m800ooBdP04dP0nof9EHUGoEF9EoeEREF;oHUER
EF;oTG:AL_mbTG;oL_mbTOnALY5bTG;oe_kFo_one_koo]Kne_oFo]Kne_l4G007oeaLG?mLo`02G003
oeaL00=L043ok:c/[?n/k:co[>cok:c/[>b/k?oeooD?mOoe3ol?m@oeooD?o`oe3ol14`4Coa<14olC
0A<1o`4C0A<1omco0m`01?oLg?l5g003omcL00;L01Go[on_kZoo[nkokZo^[nkokZo^[ol01`0000H0
00?o4A400Q401OlA4A7o00<A00?o4A400a42o`@A00Go4A4Ao`034@03oa4A00DA00?ogml00]l01OoO
gmoo00;O00?ogml01Ml00ooBdP02dP06om;Bd_oB1?l5dP26oh1nP7koOX1nogj0OX3oP7j0OX3oLPQb
2?l8LPSo2?l8L_mb2788LPSooPon3ol?oPoo3oh?o_on3oh?o_nLdIcAom6LdOoAom6LoicAW=6Lojc/
[>cok:c/onb/k?o/[>b/k:co3ol?cPoo3lkocPo>3ol?c_o>3lko4`4C0Ol14`7o0A<3o`084`4C0A?o
g?l3g004omcLo`KL01Wog=cLonookjo_onn_ojo_[nn_ojo_[noo00L00006000CoelAGa7o4ElAoa5O
4EooGa5O4@02o`0EGa5O4OlAGa7o4ElAGomO4ElAGa7o00CO00GogmoOo`02g`03omoO00GO00?od]80
0]802OoBd];od_oBo`06dP0<of9EHUGoEF9EoeER0_l04EEREF9EH_nALY5bog:AL_mb00?o019bTG:A
LY5bomKne_koo]Knooh3o`07o]Kne_kFo`04G005oeaLG?l00U`2o`IL043ok:c/[?n/k:co[>b/ojc/
[>b/k?oeooD?mOoe3ol?m@oeooD?o`oe3ol14`4Coa<14olCoa<1o`4C0A<1omco0m`01?oLg?l7g00H
omcLojoo[nj_ojo^onj_kZo^onj_kZoo1`0000H000?o4A400a46o`8A00?o4A400Q42o`DA1_l24@03
oa4A00@A00?ogml00ml5o`03gooO00KO00?od]800m86o`03d_oB00GB00KoP7j0OX05o`0?P7j0oh1n
P7j0og88LPQb00Ko00l8LPQb2788LPSooPon3oh01_l03Pon3oh?oPonoicAW=6L1_l03]6LoicAW=6L
ojc/[>b/1Ol03:c/[?n/k:c/[?l?cPGo01?>olh?cPoo3lkocPo>oa<14`4C00Ko00T14olC0A<14ol0
0]`5o`03g?oL00?L00Cog=co0]`00oo_[`05o`0=[on_kjo_[on_kjo_o`0700001P003?mO4ElAGa5O
4ElAG`;o00DAGa5O4@02o`0;Ga5O4ElAGa5O4El00_l0215O4ElAGa7o2]l2o`OO00?od]802M82o`KB
00_oHUEREF9EHUERE@03o`0BEF9EHUERoi5bTG:ALY5bTG:A0ol04I5bTG:AL_oFo]Kne_kFo]Kn00Co
00KFo]Kne_l;G0;o1U`02oo/[>b/k:c/[>b/00Co00g/[>b/k?oe3oD?m@oe00;o00D?m@oe3`02o`0@
m@oe3ol14`4C0A<14`4C0@;o00LC0A<14`7o00OL0_l5g0;o0m`02?n_kZo^[nj_0_l01>j_kZl2o`05
kZo^[ol01`0000H000?o4A404142oa@A00?ogml04Ml00ooBdP0AdP2?oh1nP7j0OX1nP7j0OX1nP7j0
OX3oLPQb2788LPQb2788LPQb2788LPSooPon3oh?oPon3oh?oPon3oh?o_nLdIcAW=6LdIcAW=6LdIcA
W=6Lojc/[>b/k:c/[>b/k:c/[>b/k:co3lh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C0A<14`4C
0A<14ol04m`05Oo_[nn_kjo_[nn_kjo_[nn_kjo_o`0700001P004omO4ElAGa5O4ElAGa5O4ElAGa40
0_l05ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0Cg`03om;B017B03koHUEREF9EHUEREF9EHUEREF9EH_nA
LY5bTG:ALY5bTG:ALY5bTG:AL_oFo]Kne_kFo]Kne_kFo]Kne_kFoa=L03kok:c/[>b/k:c/[>b/k:c/
[>b/k?oe3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1oa?L01Go[nj_kZo^[nj_
kZo^[nj_kZo^[ol01`0000H000?o4A404142oa@A00?ogml04Ml00ooBdP0AdP2?oh1nP7j0OX1nP7j0
OX1nP7j0OX3oLPQb2788LPQb2788LPQb2788LPSooPon3oh?oPon3oh?oPon3oh?o_nLdIcAW=6LdIcA
W=6LdIcAW=6Lojc/[>b/k:c/[>b/k:c/[>b/k:co3lh?cPo>3lh?cPo>3lh?cPo>3lko4`4C0A<14`4C
0A<14`4C0A<14ol04m`05Oo_[nn_kjo_[nn_kjo_[nn_kjo_o`0700001P004omO4ElAGa5O4ElAGa5O
4ElAGa400_l05ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0Cg`03om;B017B03koHUEREF9EHUEREF9EHUER
EF9EH_nALY5bTG:ALY5bTG:ALY5bTG:AL_oFo]Kne_kFo]Kne_kFo]Kne_kFoa=L03kok:c/[>b/k:c/
[>b/k:c/[>b/k?oe3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1oa?L01Go[nj_
kZo^[nj_kZo^[nj_kZo^[ol01`0000H000?o4A404142oa@A00?ogml04Ml00ooBdP0AdP2?oh1nP7j0
OX1nP7j0OX1nP7j0OX3oLPQb2788LPQb2788LPQb2788LPSooPon3oh?oPon3oh?oPon3oh?o_nLdIcA
W=6LdIcAW=6LdIcAW=6Lojc/[>b/k:c/[>b/k:c/[>b/k:co3lh?cPo>3lh?cPo>3lh?cPo>3lko4`4C
0A<14`4C0A<14`4C0A<14ol04m`05Oo_[nn_kjo_[nn_kjo_[nn_kjo_o`0700001P004omO4ElAGa5O
4ElAGa5O4ElAGa400_l05ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0Cg`03om;B017B03koHUEREF9EHUER
EF9EHUEREF9EH_nALY5bTG:ALY5bTG:ALY5bTG:AL_oFo]Kne_kFo]Kne_kFo]Kne_kFoa=L03kok:c/
[>b/k:c/[>b/k:c/[>b/k?oe3oD?m@oe3oD?m@oe3oD?m@oe3ol14`4C0A<14`4C0A<14`4C0A<1oa?L
01Go[nj_kZo^[nj_kZo^[nj_kZo^[ol01`0000H0ool9o`L000060003omoO013O0_lDg`0Yoa5O4ElA
Ga5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EH_l04m80?_one_kFo]Kne_kFo]Kne_kFo]Kn
e_mbTG:ALY5bTG:ALY5bTG:ALY5bonb/k:c/[>b/k:c/[>b/k:c/[>co4e`0?_lC0A<14`4C0A<14`4C
0A<14`4C0Ol?m@oe3oD?m@oe3oD?m@oe3oD?ojo^[nj_kZo^[nj_kZo^[nj_kZoo4m`00ol000050000
1P000ooOg`0@g`;o5=l00olA4@0A4@0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01?B08oo3oh?oPon3oh?
oPon3oh?oPon3oko2788LPQb2788LPQb2788LPQb2?n/k:c/[>b/k:c/[>b/k:c/[>b/oicAW=6LdIcA
W=6LdIcAW=6LdIco0A<14`4C0A<14`4C0A<14`4C0A?ocPo>3lh?cPo>3lh?cPo>3lh?c_o_[nn_kjo_
[nn_kjo_[nn_kjo_o`0Cg003o`0000D000060003omoO013O0_lDg`0Yoa5O4ElAGa5O4ElAGa5O4ElA
Ga7oHUEREF9EHUEREF9EHUEREF9EH_l04m80?_one_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:A
LY5bTG:ALY5bonb/k:c/[>b/k:c/[>b/k:c/[>co4e`0?_lC0A<14`4C0A<14`4C0A<14`4C0Ol?m@oe
3oD?m@oe3oD?m@oe3oD?ojo^[nj_kZo^[nj_kZo^[nj_kZoo4m`00ol0000500001P000ooOg`0@g`;o
5=l00olA4@0A4@0Eoh1nP7j0OX1nP7j0OX1nP7j0OX3o01?B08oo3oh?oPon3oh?oPon3oh?oPon3oko
2788LPQb2788LPQb2788LPQb2?n/k:c/[>b/k:c/[>b/k:c/[>b/oicAW=6LdIcAW=6LdIcAW=6LdIco
0A<14`4C0A<14`4C0A<14`4C0A?ocPo>3lh?cPo>3lh?cPo>3lh?c_o_[nn_kjo_[nn_kjo_[nn_kjo_
o`0Cg003o`0000D000060003omoO013O0_lDg`0Yoa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUER
EF9EHUEREF9EH_l04m80?_one_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5bonb/
k:c/[>b/k:c/[>b/k:c/[>co4e`0?_lC0A<14`4C0A<14`4C0A<14`4C0Ol?m@oe3oD?m@oe3oD?m@oe
3oD?ojo^[nj_kZo^[nj_kZo^[nj_kZoo4m`00ol0000500001P000ooOg`03g`?o2]l2o`GO0ol<g`03
oa4A00<A0ol;4@06oh1nP7j00ol0381nP7j0OX1nP7j0o`GB0ol;dP06o`on3oh?0ol04Pon3oh?oPon
3oh?o_l8LPQb20?o0148LPQb2788LPQb2?n/k:c/[003o`0A[>b/k:c/[>b/k:coW=6LdI`00ol04IcA
W=6LdIcAW=6Lo`4C0A<100?o00l14`4C0A<14`4C0A?ocPl00ol04@o>3lh?cPo>3lh?cPo>onn_00?o
00n_kjo_[nn_kjo_[nn_kol00]`3o`kL00?o00001@0000H000?ogml01]l00ooOg`07g`;o2=l00ooO
g`09g`0Yoa5O4ElAGa5OoelAGa5O4ElAGa7oHUEREF9EHUGoEF9EHUEREF9EH_l02=800ooBdP08dP0n
ookFo]Kne_kFomKne_kFo]Kne_kFog:ALY5bTG:Aoi5bTG:ALY5bTG;ok:c/[>b/k:co[>b/k:c/[>b/
k?l8G003oeaL00QL03ko4`4C0A<14`7o0A<14`4C0A<14`7o3oD?m@oo3oD?m@oe3oD?m@oe3on_kZo^
[on_kZo^[nj_kZo^[nj_o`GL00?og=`02m`00ol0000500001P000ooOg`03g`Co00COoooo1Ml2o`GO
1?l01=ooool7g`03oa4A00<A1?l00a7oo`02o`DA00KoP7j0OX04o`0;O_ooogj0OX1nP?l01M84o`;B
0ol5dP06o`on3oh?1?l04Okoooon3oh?oPono`Qb278800Co011b2?ooLPQb2788ojc/[>b/1?l04>b/
ojc/[>b/k:coW=6LdI`4o`0@dIcoom6LdIcAW?l14`4C0@Co00hCoooo4`4C0A<14oo>3`Co00S>oooo
cPo>3`;o00K>3lkokjl4o`07koooonn_k`03o`04kjo_o`;L1?l01=coool3g0Co0]`00ol000050000
1P000ooOg`02g`05omoOgol00]l00ooOg`04g`;o1=l01OoOgmoo00;O00?ogml01]l0:OlAGa5OoelA
GomO4OlAGa5O4ElAof9EHUGoEF9EoeEREF;oHUEREF;o00CB00God];Bo`03dP03om;B00CB03koo]Kn
e_oFo]Koe_kFo_one_kFo]KoLY5bTOnALY7oTOnAL_mbTG:AL_o/[>b/ojc/[?n/k?o/[>b/k:c/o`AL
00OoG5aLoeco009L00?oG5`00e`0@?lC0A<1o`4C0Ol14`4Coa<14`4C0Ol?o`oe3ol?mOoe3oD?o`oe
ooD?ojoo[nj_ojo^onj_kZo^onj_kZoog?l3g004omcLo`GL00?og=`00]`00ol0000500001P000ooO
g`02g`05omoOgol00]l00ooOg`04g`;o1=l01OoOgmoo00;O00?ogml01]l00olA4@024@05oa4A4Ol0
0a400olA4@044@0Eoh1nP7koOX1nogj0OX3oP7j0OX3o00CB00Kod];Bom84o`GB05go3oh?o_on3oko
oPon3ol?oPon3oko2788L_mb27;oL_mb2?l8LPQb2?n/k:c/onb/k?o/[>cok:c/[>b/oicAW=7odIcA
om7odIcoW=6LdIco0A<14olC0A?o4`400ol0<@4C0A<14oo>olh?c_o>3ol?cPo>olh?o`o>onookjo_
onn_ojo_[nn_ojo_[noog?l00m`01?oLg?l6g005omcLg?l01`0000H000?ogml00]l01OoOgmoo00;O
00?ogml01=l2o`CO00GogmoOo`02g`03omoO00KO023o4ElAGomO4EooGa5O4OlAGa5O4OmREF9EoeER
EOmEHP;o00MEHUEREF;o00CB00Wod];Bom;od_l01]802oone_kFomKne_oF00?o01;Fo]Kne_kFog:A
LY7oTG:Aoi43o`0KTG:ALY5bonb/k:co[>b/ojc/[?n/k:c/[>co00AL00GoG5aLo`02G0;o1U`0@?lC
0A<1o`4C0Ol1o`4Coa<14`4C0Ol?o`oe3ol?mOoe3oD?o`oeooD?ojoo[nj_ojo^onj_kZo^onj_kZoo
g?l3g004omcLo`OL00Cog=co1`0000H000?ogml00ml5o`03gooO00GO0_l5g`Go00?Ooml01ml00olA
4@034@Ko0Q400olA4@034@06oh1nP7j01Ol02X1nP?n0OX1nP?l5dPKo00?Bom801M801_l?oPon3`Ko
00on3oh?oPon3oko2788LPP01_l03W88LPQb2788ojc/[>b/1Ol03jc/[?n/k:c/[?nLdIcAW006o`0>
dIcoW=6LdIco0A<14`46o`0<4`7o0A<14`4Colh?1Ol03`oo3lh?c_o>3ol?c_o_[`05o`0=[on_kjo_
[on_kjo_o`02g0Go00?Lom`00m`01?oLg?l2g003o`0000D000060003omoO00SO0_l6g`;o2]l2o`SO
00co4ElAGa5O4ElAGa42o`0AGa5O4ElAof9EHUEREF9EHUD00ol01eEREF9EH_l02m82o`KB00_oo]Kn
e_kFo]KneP04o`0Bo]Kne_kFog:ALY5bTG:ALY5b0ol047:ALY5bonb/k:c/[>b/k:`4o`06k:c/[>co
2e`2o`IL00co4`4C0A<14`4C0A<2o`0?0A<14`4C0Ol?m@oe3oD?00;o00Ge3oD?m@02o`0;3oD?ojo^
[nj_kZl00_l01>j_kZl2o`05kZo^[ol01m`2o`GL0_l3g003o`0000D000060003omoO013O0_lDg`03
oa4A014A01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l04m80Sol?oPon3oh?oPon3oh?oPon3oh?o_l8LPQb
2788LPQb2788LPQb2788ojc/[>b/k:c/[>b/k:c/[>b/k:coW=6LdIcAW=6LdIcAW=6LdIcAW?l14`4C
0A<14`4C0A<14`4C0A<14oo>3lh?cPo>3lh?cPo>3lh?cPo>onn_kjo_[nn_kjo_[nn_kjo_[noo01?L
00?o00001@0000H000?ogml04=l2oaCO02Wo4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUER
EF9EHUERo`0CdP0nookFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG;ok:c/[>b/
k:c/[>b/k:c/[>b/k?lCG00noa<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo
[nj_kZo^[nj_kZo^[nj_kZo^[olCg003o`0000D000060003omoO013O0_lDg`03oa4A014A01GoP7j0
OX1nP7j0OX1nP7j0OX1nP?l04m80Sol?oPon3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb
2788ojc/[>b/k:c/[>b/k:c/[>b/k:coW=6LdIcAW=6LdIcAW=6LdIcAW?l14`4C0A<14`4C0A<14`4C
0A<14oo>3lh?cPo>3lh?cPo>3lh?cPo>onn_kjo_[nn_kjo_[nn_kjo_[noo01?L00?o00001@0000H0
00?ogml04=l2oaCO02Wo4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUERo`0CdP0n
ookFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG;ok:c/[>b/k:c/[>b/k:c/[>b/
k?lCG00noa<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^
[nj_kZo^[olCg003o`0000D000060003omoO013O0_lDg`03oa4A014A01GoP7j0OX1nP7j0OX1nP7j0
OX1nP?l04m80Sol?oPon3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788ojc/[>b/k:c/
[>b/k:c/[>b/k:coW=6LdIcAW=6LdIcAW=6LdIcAW?l14`4C0A<14`4C0A<14`4C0A<14oo>3lh?cPo>
3lh?cPo>3lh?cPo>onn_kjo_[nn_kjo_[nn_kjo_[noo01?L00?o00001@0000H000?ogml04=l2oaCO
02Wo4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUERo`0CdP0nookFo]Kne_kFo]Kn
e_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG;ok:c/[>b/k:c/[>b/k:c/[>b/k?lCG00noa<14`4C
0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_kZo^[olCg003
o`0000D000050?oo2_l700001@3oo`[o1`0000H000?o00004002oaCO00?o4A404A405On0OX1nP7j0
OX1nP7j0OX1nP7j0o`0CdP2?o`on3oh?oPon3oh?oPon3oh?oPono`Qb2788LPQb2788LPQb2788LPSo
[>b/k:c/[>b/k:c/[>b/k:c/[?nLdIcAW=6LdIcAW=6LdIcAW=6Lo`4C0A<14`4C0A<14`4C0A<14`4C
olh?cPo>3lh?cPo>3lh?cPo>3lkokjo_[nn_kjo_[nn_kjo_[nn_kol04m`00ol0000500001P000ol0
000?00?o5=l0:OlAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF;o01?B03koo]Kn
e_kFo]Kne_kFo]Kne_kFo]KoLY5bTG:ALY5bTG:ALY5bTG:AL_o/[>b/k:c/[>b/k:c/[>b/k:c/oa=L
03ko4`4C0A<14`4C0A<14`4C0A<14`7o3oD?m@oe3oD?m@oe3oD?m@oe3on_kZo^[nj_kZo^[nj_kZo^
[nj_oa?L00?o00001@0000H000?o00003P001?l0oolDg`03oa4A014A01GoP7j0OX1nP7j0OX1nP7j0
OX1nP?l04m80Sol?oPon3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788ojc/[>b/k:c/
[>b/k:c/[>b/k:coW=6LdIcAW=6LdIcAW=6LdIcAW?l14`4C0A<14`4C0A<14`4C0A<14oo>3lh?cPo>
3lh?cPo>3lh?cPo>onn_kjo_[nn_kjo_[nn_kjo_[noo01?L00?o00001@0000H000Co00000_l00`3o
o`070003o`0000;o5=l0:OlAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF;o01?B
03koo]Kne_kFo]Kne_kFo]Kne_kFo]KoLY5bTG:ALY5bTG:ALY5bTG:AL_o/[>b/k:c/[>b/k:c/[>b/
k:c/oa=L03ko4`4C0A<14`4C0A<14`4C0A<14`7o3oD?m@oe3oD?m@oe3oD?m@oe3on_kZo^[nj_kZo^
[nj_kZo^[nj_oa?L00?o00001@0000H000?o00000P000ol0o`070004o`0000;o1Ml3o`cO00?o4A40
0a43o`/A00KoP7j0OX03o`0<P7j0OX1nP7j0OX3o1M83o`_B00Ko3oh?oPl3o`0B3oh?oPon3oh?oPon
o`Qb27880ol04@Qb2788LPQb2788ojc/[>b/00?o016/k:c/[>b/k:c/[?nLdIcAW003o`0AW=6LdIcA
W=6LdIco0A<14`400ol03`4C0A<14`4C0A<14oo>3`03o`0A3lh?cPo>3lh?cPo>3lkokjl00ol03jo_
[nn_kjo_[nn_kjo_o`02g0?o3]`00ol0000500001P000ol000030003o`0000D000?o00000P02o`SO
00?ogml02Ml0:OlAGa5O4ElAGomO4ElAGa5O4ElAof9EHUEREF9EoeEREF9EHUEREF;o00SB00?od]80
2=80?_one_kFo]Kne_oFo]Kne_kFo]Kne_mbTG:ALY5bTOnALY5bTG:ALY5bonb/k:c/[>b/ojc/[>b/
k:c/[>co25`00omLG008G00noa<14`4C0A<1o`4C0A<14`4C0A<1o`oe3oD?o`oe3oD?m@oe3oD?m@oo
[nj_kZoo[nj_kZo^[nj_kZo^[ol5g003omcL00_L00?o00001@0000H000?o00000P000ol0o`050003
o`0000<00_l5g`Co00COoooo1ml00olA4@034@Co00<Aool00_l54@06oh1nP7j01?l02gkooomnP7j0
OX3o00GB1?l2dP?o1M801_l?oPon3`Co017noooooPon3oh?o_l8LPQb2004o`0@LPSoog88LPQb2?n/
k:c/[0Co013/[?n/k:c/[>b/oicAW=6L1?l04=6LoooAW=6LdIco0A<14`44o`0>4ooooa<14`4C0A?o
cPl4o`08c_ooolh?cPl2o`06cPo>onn_1?l01nooooo_[nl00ol01>n_kol2g0Co00CLoooo0m`4o`;L
00?o00001@0000H000Co00000_l00`3oo`030003o`0000@00_l4g`05omoOgol00]l00ooOg`06g`0Y
oa5O4EooGa5OoelAoa5O4ElAGa7oHUEREOmEHUGoEF9EH_mREF9EH_l01=801OoBd];o00?B00?od]80
1=80?_one_kFomKne_oFo]KnookFo]Kne_mbTG:Aoi5bTOnAoi5bog:ALY5bonb/k:co[>b/ojc/onb/
k:c/[>co15`01omLG5coG?l00U`00omLG003G010oa<14`7o0A<1o`4C0A?o4`4C0A<1o`oo3oD?o`oe
ooD?m@oo3oGom@oo[on_kZoo[nkokZo^[nkokZo^[ooLo`?L00Cog=co1M`00ooLg002g003o`0000D0
00060003o`0000P01?l400;o1=l01OoOgmoo00;O00?ogml01]l00olA4@024@05oa4A4Ol00a400olA
4@044@0Eoh1nP7koOX1nogj0OX3oP7j0OX3o00CB00Kod];Bom84o`GB05go3oh?o_on3okooPon3ol?
oPon3oko2788L_mb27;oL_mb2?l8LPQb2?n/k:c/onb/k?o/[>cok:c/[>b/oicAW=7odIcAom7odIco
W=6LdIco0A<14olC0A?o4`400ol0<@4C0A<14oo>olh?c_o>3ol?cPo>olh?o`o>onookjo_onn_ojo_
[nn_ojo_[noog?l00m`01?oLg?l6g005omcLg?l01`0000H000?o00001`001?l00?l500;o1=l01OoO
gmoo00;O00?ogml01]l08?lAGa5OoelAGomO4ElAoa5O4ElAof9EHUGoEF9EoeER0_l01eEREF9EH_l0
1=802OoBd];od_oBo`06dP0;ookFo]Koe_kFomH00ol04]Kne_kFo]KoLY5bTOnALY7oT@?o01^ALY5b
TG;ok:c/[?n/k:co[>b/ojc/[>b/k?l015`01OmLG5co009L0_l6G010oa<14`7o0A<1o`7o0A?o4`4C
0A<1o`oo3oD?o`oeooD?m@oo3oGom@oo[on_kZoo[nkokZo^[nkokZo^[ooLo`?L00Cog=co1m`01?oL
g?l700001P000ol000060003o`00008000?o00000P02o`GO1Ol00moog`07g`03oa4A00<A1_l24@03
oa4A00<A00KoP7j0OX05o`0:P7j0oh1nP7j0o`GB1_l00m;odP05dP06o`on3oh?1_l03oh?oPon3oh?
o_l8LPQb2006o`0>LPQb2788LPSo[>b/k:`5o`0?[>b/ojc/[>b/oicAW=6L00Ko00kAW?nLdIcAW?l1
4`4C0@Ko00`C0Ol14`4C0A?ocPl5o`0?3ol?cPo>olh?o`o>onn_00Go00f_ojo_[nn_ojo_[noo00;L
1Ol00mcog003g004omcLo`;L00?o00001@0000H000?o00001@000ol000030003o`0000800_l:g`;o
2=l03?lAGa5O4ElAGa5O4@;o015O4ElAGa7oHUEREF9EHUERE@03o`07EF9EHUERo`0;dP;o1]802oon
e_kFo]Kne_kF00Co01;ne_kFo]KoLY5bTG:ALY5bTG83o`0@LY5bTG;ok:c/[>b/k:c/[0Co00K/[>b/
k?l;G0;o1U`03?lC0A<14`4C0A<14`;o00l14`4C0A<1o`oe3oD?m@l00_l01OD?m@oe00;o00/?m@oo
[nj_kZo^[`02o`04kZo^[`;o00G^[nj_o`07g0;o1M`2o`?L00?o00001@0000H000?o000010000ol0
00030003o`3o00<00_lDg`03oa4A014A01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l04m80Sol?oPon3oh?
oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788ojc/[>b/k:c/[>b/k:c/[>b/k:coW=6LdIcA
W=6LdIcAW=6LdIcAW?l14`4C0A<14`4C0A<14`4C0A<14oo>3lh?cPo>3lh?cPo>3lh?cPo>onn_kjo_
[nn_kjo_[nn_kjo_[noo01?L00?o00001@0000H000?o00000`000ol000040003o`3o00<00_lDg`0Y
oa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EH_l04m80?_one_kFo]Kne_kFo]Kn
e_kFo]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5bonb/k:c/[>b/k:c/[>b/k:c/[>co4e`0?_lC0A<14`4C
0A<14`4C0A<14`4C0Ol?m@oe3oD?m@oe3oD?m@oe3oD?ojo^[nj_kZo^[nj_kZo^[nj_kZoo4m`00ol0
000500001P000ol000020003o`0000@00_l00`3oo`0200;o5=l00olA4@0A4@0Eoh1nP7j0OX1nP7j0
OX1nP7j0OX3o01?B08oo3oh?oPon3oh?oPon3oh?oPon3oko2788LPQb2788LPQb2788LPQb2?n/k:c/
[>b/k:c/[>b/k:c/[>b/oicAW=6LdIcAW=6LdIcAW=6LdIco0A<14`4C0A<14`4C0A<14`4C0A?ocPo>
3lh?cPo>3lh?cPo>3lh?c_o_[nn_kjo_[nn_kjo_[nn_kjo_o`0Cg003o`0000D000060005o`000?l0
3P02oaCO02Wo4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUERo`0CdP0nookFo]Kn
e_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG;ok:c/[>b/k:c/[>b/k:c/[>b/k?lCG00n
oa<14`4C0A<14`4C0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_kZo^
[olCg003o`0000D000060004o`00o`l00_lDg`03oa4A014A01GoP7j0OX1nP7j0OX1nP7j0OX1nP?l0
4m80Sol?oPon3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788ojc/[>b/k:c/[>b/k:c/
[>b/k:coW=6LdIcAW=6LdIcAW=6LdIcAW?l14`4C0A<14`4C0A<14`4C0A<14oo>3lh?cPo>3lh?cPo>
3lh?cPo>onn_kjo_[nn_kjo_[nn_kjo_[noo01?L00?o00001@0000H000?o0?l04002oaCO02Wo4ElA
Ga5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUERo`0CdP0nookFo]Kne_kFo]Kne_kFo]Kn
e_kFog:ALY5bTG:ALY5bTG:ALY5bTG;ok:c/[>b/k:c/[>b/k:c/[>b/k?lCG00noa<14`4C0A<14`4C
0A<14`4C0A<1o`oe3oD?m@oe3oD?m@oe3oD?m@oo[nj_kZo^[nj_kZo^[nj_kZo^[olCg003o`0000D0
000600;o4@02oaCO00?o4A404A405On0OX1nP7j0OX1nP7j0OX1nP7j0o`0CdP2?o`on3oh?oPon3oh?
oPon3oh?oPono`Qb2788LPQb2788LPQb2788LPSo[>b/k:c/[>b/k:c/[>b/k:c/[?nLdIcAW=6LdIcA
W=6LdIcAW=6Lo`4C0A<14`4C0A<14`4C0A<14`4Colh?cPo>3lh?cPo>3lh?cPo>3lkokjo_[nn_kjo_
[nn_kjo_[nn_kol04m`00ol0000500001P3oo`Wo1`0001T00_oj0000o`0F0000o`0F0000o`0F0000
o`0F00003P02o`X00_lL00;o7002ojd00ol=00003P000ol0000:0003o`0001X000?o00002@000ol0
000@0003o`000:`000?o0000300000L01?l30003o`0000800ol50003o`0000H00_l00`3oo`0800Co
0`000ol0000200Co0`000ol0000800Go0`000ol0002C00;o00<0ool02@000ol0o`090003o`0000/0
00080003o`3o00<000?o00001@000ol000020003o`0000L000?o0?l02P000ol0o`030003o`0000<0
00?o000010000ol000090003o`0000<000?o0000U0000ol0o`0;0003o`0000P000?o00002`0000P0
00?o00000`000ol000050003o`00008000?o000020000ol000090003o`0000<000?o000010000ol0
000?0003o`0000<000?o0000U@000ol0000800Go1`000ol0o`0<00002@000ol000020003o`0000<0
0_l50003o`0000L000?o0?l02`000ol000020003o`0000D000?o00003P000ol000030003o`0009@0
00?o0?l02`000ol000070003o`3o00`000070003o`3o00@000?o00001@000ol000020003o`0000H0
0_l00`3oo`080003o`3o00@000?o00000P001?l00?l@0003o`0000<000?o0000T`02o`030?oo01<0
0_l00`3oo`0;00001`04o`<00_l300?o1002oaD01?l300;o1002o`l01Ol200;o_@000?l05P000?l0
5P000?l05P000001\
\>"],
  ImageRangeCache->{{{0, 276.312}, {287, 0}} -> {-1.32507, -0.339066, 
  0.0494011, 0.0494011}},
  CellTags->"DirectProducts"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["DirectSum", "MR"],
  " and ",
  StyleBox["DirectProduct", "MR"],
  " functions can act on any number of arguments."
}], "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell["DirectSum[Z[2], Z[2], Z[2], Z[2]]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \(Groupoid[{{0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 1, 1}, {0, 
          1, 0, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 1}, {1, 0, 0, 0}, {
          1, 0, 0, 1}, {1, 0, 1, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}, {1, 1, 0, 
          1}, {1, 1, 1, 0}, {1, 1, 1, 1}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell["2.6.2 Subgroups", "Subsubsection",
  CellTags->{"Subgroups", "i:4"}],

Cell[TextData[{
  "We now pursue the second question given at the outset of this section. \
Given a groupoid ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and a subset ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", we can form a new groupoid using the elements from ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " and the operation from ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  CellTags->"Subgroups"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Subgroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subset",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]]}], " ", 
              RowBox[{
                RowBox[{"groupoid", 
                  StyleBox[
                    FormBox["G",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(return\ the\ groupoid\ with\ elements\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["H",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Subgroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], \(H\_1\), 
                      StyleBox[",",
                        "MR"], " ", \(H\_2\), 
                      StyleBox[",",
                        "MR"], " ", "\[Ellipsis]", 
                      StyleBox[",",
                        "MR"], " ", \(H\_n\), 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox[\(given\ a\ collection\ of\ subsets\ \),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[\({H\_1\),
                          "TraditionalForm"],
                        "Text"], 
                      StyleBox[",",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[\(H\_2\),
                          "TraditionalForm"],
                        "Text"], 
                      StyleBox[",",
                        SingleLetterItalics->False], 
                      StyleBox[\(\(\ \(\[Ellipsis], \)\)\ \),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[\(H\_n\),
                          "TraditionalForm"],
                        "Text"]}], 
                    StyleBox["}",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["elements",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    RowBox[{
                      StyleBox["th",
                        SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                  " ", 
                  StyleBox[
                    FormBox["G",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], " ", 
                StyleBox[\(return\ the\ list\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoids",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_i\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Subgroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    StyleBox["{",
                      "MR"], \(G\_1\), 
                    StyleBox[",",
                      "MR"], " ", \(H\_1\), 
                    StyleBox["}",
                      "MR"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["{",
                      "MR"], \(G\_2\), 
                    StyleBox[",",
                      "MR"], " ", \(H\_2\), 
                    StyleBox["}",
                      "MR"], 
                    StyleBox[",",
                      "MR"], " ", "\[Ellipsis]", 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["{",
                      "MR"], \(G\_n\), 
                    StyleBox[",",
                      "MR"], " ", \(H\_n\), 
                    StyleBox["}",
                      "MR"], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(given\ that\ the\ subset\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(H\_i\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["subset",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["groupoid",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    "Text"], 
                  StyleBox[
                    FormBox[\(G\_i\),
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox[\(return\ the\ list\ of\),
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["groupoids",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["with",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["elements",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["from",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(H\_i\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["operation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["from",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(G\_i\),
                      "TraditionalForm"],
                    "Text"]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"Subgroups", "i:5"}],

Cell[TextData[{
  "Variations for the function ",
  StyleBox["Subgroupoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Subgroups"],

Cell["\<\
Given a subset of a groupoid, we can form a new groupoid from the \
old.\
\>", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G1\  = \ Subgroupoid[Z[9], \ {0, \ 4}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{0, 4}, Mod[#1 + #2, 9]&]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "We can now use ",
  StyleBox["GroupQ", "MR"],
  " to determine if this is a subgroup."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupQ[G1]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Alternatively, we can use ",
  StyleBox["SubgroupQ", "MR"],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[\ {0, \ 4}, Z[9]]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "How often will a random set of elements from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_9\)]],
  " be a subgroup? Here we form 10 subgroupoids and then list the elements \
and whether this set forms a group or not. For ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_9\)]],
  ", what is the probability that three randomly chosen elements form a \
subgroup?"
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(subs\  = \ 
      Subgroupoid[Z[9], \ 
        Table[RandomElements[Z[9], \ Random[Integer, {1, 9}], \ 
            Replacement\  \[Rule] \ False], \ {10}]]; \n
    Map[{Elements[#], \ GroupQ[#]}&, \ subs] // ColumnForm\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({{4, 7, 2, 5, 8, 3, 1, 0}, False}\)},
          {\({{5, 6, 7, 3, 4, 1}, False}\)},
          {\({{5}, False}\)},
          {\({{5, 3, 2, 4, 6}, False}\)},
          {\({{1, 5, 4, 3, 7, 2}, False}\)},
          {\({{5, 7}, False}\)},
          {\({{1}, False}\)},
          {\({{7}, False}\)},
          {\({{7}, False}\)},
          {\({{4, 8, 5, 0}, False}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{{4, 7, 2, 5, 8, 3, 1, 0}, False}, {{5, 6, 7, 3, 4, 1}, 
        False}, {{5}, False}, {{5, 3, 2, 4, 6}, False}, {{1, 5, 4, 3, 7, 2}, 
        False}, {{5, 7}, False}, {{1}, False}, {{7}, False}, {{7}, False}, {{
        4, 8, 5, 0}, False}}],
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["\<\
We can form several subgroupoids at once, as well as viewing \
visually what it means for the subset to be a subgroup.\
\>", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subgroupoid[{{U[15], \ {1, 2}}, \ {Dihedral[3], \ {Rot, \ Ref}}}, \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("All the elements marked with yellow are original elements in the set. \
Those in red are from outside."\)], "Print",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("KEY for D[3]: label used \[Rule] element: {g1 \[Rule] Rot, g2 \[Rule] \
Ref, g3 \[Rule] 1, g4 \[Rule] Rot^2, g5 \[Rule] Rot**Ref, g6 \[Rule] \
Rot^2**Ref}"\)], "Print",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50265 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119678 0.47619 [
[ 0 0 0 0 ]
[ 1 .50265 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .50265 L
0 .50265 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119678 0.477324 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
1 0 0 r
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(1)] .18254 .81878 0 0 Mshowa
[(2)] .28836 .81878 0 0 Mshowa
[(4)] .39418 .81878 0 0 Mshowa
[(7)] .5 .81878 0 0 Mshowa
[(8)] .60582 .81878 0 0 Mshowa
[(11)] .71164 .81878 0 0 Mshowa
[(13)] .81746 .81878 0 0 Mshowa
[(14)] .92328 .81878 0 0 Mshowa
[(2)] .18254 .71296 0 0 Mshowa
[(4)] .28836 .71296 0 0 Mshowa
[(8)] .39418 .71296 0 0 Mshowa
[(14)] .5 .71296 0 0 Mshowa
[(1)] .60582 .71296 0 0 Mshowa
[(7)] .71164 .71296 0 0 Mshowa
[(11)] .81746 .71296 0 0 Mshowa
[(13)] .92328 .71296 0 0 Mshowa
[(4)] .18254 .60714 0 0 Mshowa
[(8)] .28836 .60714 0 0 Mshowa
[(1)] .39418 .60714 0 0 Mshowa
[(13)] .5 .60714 0 0 Mshowa
[(2)] .60582 .60714 0 0 Mshowa
[(14)] .71164 .60714 0 0 Mshowa
[(7)] .81746 .60714 0 0 Mshowa
[(11)] .92328 .60714 0 0 Mshowa
[(7)] .18254 .50132 0 0 Mshowa
[(14)] .28836 .50132 0 0 Mshowa
[(13)] .39418 .50132 0 0 Mshowa
[(4)] .5 .50132 0 0 Mshowa
[(11)] .60582 .50132 0 0 Mshowa
[(2)] .71164 .50132 0 0 Mshowa
[(1)] .81746 .50132 0 0 Mshowa
[(8)] .92328 .50132 0 0 Mshowa
[(8)] .18254 .3955 0 0 Mshowa
[(1)] .28836 .3955 0 0 Mshowa
[(2)] .39418 .3955 0 0 Mshowa
[(11)] .5 .3955 0 0 Mshowa
[(4)] .60582 .3955 0 0 Mshowa
[(13)] .71164 .3955 0 0 Mshowa
[(14)] .81746 .3955 0 0 Mshowa
[(7)] .92328 .3955 0 0 Mshowa
[(11)] .18254 .28968 0 0 Mshowa
[(7)] .28836 .28968 0 0 Mshowa
[(14)] .39418 .28968 0 0 Mshowa
[(2)] .5 .28968 0 0 Mshowa
[(13)] .60582 .28968 0 0 Mshowa
[(1)] .71164 .28968 0 0 Mshowa
[(8)] .81746 .28968 0 0 Mshowa
[(4)] .92328 .28968 0 0 Mshowa
[(13)] .18254 .18386 0 0 Mshowa
[(11)] .28836 .18386 0 0 Mshowa
[(7)] .39418 .18386 0 0 Mshowa
[(1)] .5 .18386 0 0 Mshowa
[(14)] .60582 .18386 0 0 Mshowa
[(8)] .71164 .18386 0 0 Mshowa
[(4)] .81746 .18386 0 0 Mshowa
[(2)] .92328 .18386 0 0 Mshowa
[(14)] .18254 .07804 0 0 Mshowa
[(13)] .28836 .07804 0 0 Mshowa
[(11)] .39418 .07804 0 0 Mshowa
[(8)] .5 .07804 0 0 Mshowa
[(7)] .60582 .07804 0 0 Mshowa
[(4)] .71164 .07804 0 0 Mshowa
[(2)] .81746 .07804 0 0 Mshowa
[(1)] .92328 .07804 0 0 Mshowa
[(1)] .07672 .81878 0 0 Mshowa
[(2)] .07672 .71296 0 0 Mshowa
[(4)] .07672 .60714 0 0 Mshowa
[(7)] .07672 .50132 0 0 Mshowa
[(8)] .07672 .3955 0 0 Mshowa
[(11)] .07672 .28968 0 0 Mshowa
[(13)] .07672 .18386 0 0 Mshowa
[(14)] .07672 .07804 0 0 Mshowa
[(1)] .18254 .9246 0 0 Mshowa
[(2)] .28836 .9246 0 0 Mshowa
[(4)] .39418 .9246 0 0 Mshowa
[(7)] .5 .9246 0 0 Mshowa
[(8)] .60582 .9246 0 0 Mshowa
[(11)] .71164 .9246 0 0 Mshowa
[(13)] .81746 .9246 0 0 Mshowa
[(14)] .92328 .9246 0 0 Mshowa
[(U[15])] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119678 0.97619 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g4)] .22789 .77381 0 0 Mshowa
[(g5)] .36395 .77381 0 0 Mshowa
[(g1)] .5 .77381 0 0 Mshowa
[(g3)] .63605 .77381 0 0 Mshowa
[(g6)] .77211 .77381 0 0 Mshowa
[(g2)] .90816 .77381 0 0 Mshowa
[(g6)] .22789 .63776 0 0 Mshowa
[(g3)] .36395 .63776 0 0 Mshowa
[(g2)] .5 .63776 0 0 Mshowa
[(g5)] .63605 .63776 0 0 Mshowa
[(g4)] .77211 .63776 0 0 Mshowa
[(g1)] .90816 .63776 0 0 Mshowa
[(g1)] .22789 .5017 0 0 Mshowa
[(g2)] .36395 .5017 0 0 Mshowa
[(g3)] .5 .5017 0 0 Mshowa
[(g4)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(g6)] .90816 .5017 0 0 Mshowa
[(g3)] .22789 .36565 0 0 Mshowa
[(g6)] .36395 .36565 0 0 Mshowa
[(g4)] .5 .36565 0 0 Mshowa
[(g1)] .63605 .36565 0 0 Mshowa
[(g2)] .77211 .36565 0 0 Mshowa
[(g5)] .90816 .36565 0 0 Mshowa
[(g2)] .22789 .22959 0 0 Mshowa
[(g1)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g6)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g4)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g4)] .36395 .09354 0 0 Mshowa
[(g6)] .5 .09354 0 0 Mshowa
[(g2)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g3)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(D[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 144.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0000X0O?lC07_o300000X000?o00002P02o``000?o00002`000ol0000;0003o`0000/0
00?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`0000h00_l@0003o`0000l0
00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0000:00;o30000ol0
000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003o`000140
00?o00003P02oa0000?o00003`000ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0
000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0
000;0003o`0000X000?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o00003P000ol0
000?0003o`0000h000?o00002P0000X000?o00002P02o``000?o00002`000ol0000;0003o`0000/0
00?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`0000h00_l@0003o`0000l0
00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0o`02o`@00ol00`3o
o`03o`@00ol20003o`3o00;o0`03o`<000?o0?l00_l300?o0`000ol0000300;o1P000ol000020003
o`0000D000?o00000`03o`D000?o00000P04o`D000?o00000P03o`D000?o00004@000ol0000200?o
2@02o`@00ol90003o`0000800ol:0004o`0000?o2P000ol0000200?o2@000ol0000200?o2P001?l0
0003o`X000?o00002P0000X000Co003o1P000ol00002o`030?l000D000Go0000o`020003o`0000D0
00Co003o0P000ol000030003o`00008000?o00000P001?l00?l50003o`00008000?o00001@000ol0
00040003o`0000@000?o00000`000ol000050003o`0000<000?o000010000ol0000A0003o`0000D0
00?o00001P02o`L000?o00001P000ol000050003o`0000L000?o000010000ol000070003o`0000D0
00?o00001P000ol000050003o`0000L000?o000010000ol000070003o`0000X0000:0004o`00o`@0
1?l01@3oo`3o00@01?l20004o`00o`L000Co003o0P000ol000030003o`00008000?o00000P001?l0
0?l50003o`0000<000?o000010000ol0000200Co1@000ol000040003o`0000@000?o00000`000ol0
00040003o`00014000?o00000P04o`800_l400;o1004o`040?ooo`@000?o00000P04o`800ol40004
o`0000Co0P02o`D000?o00000P04o`030?oo00;o0`000ol0000200Co00@0oooo1@001?l00004o`04
0?ooo`D000?o00002P0000X000Co003o10000ol0o`0200;o00<0o`000`000ol0o`030004o`00o`D0
0_l30004o`00o`D000?o00000P000ol0000300;o1P000ol000030003o`0000@000?o00000P000ol0
o`060003o`0000D000?o00000`000ol000030003o`0000@000?o00004@001Ol0003o00<000?o0?l0
0P001?l00002o`<000Go0000o`040005o`000?l00`001Ol0003o00<000?o00000`001?l00?l30003
o`3o008000?o00000P001Ol0003o00<000Co003o1@001Ol0003o00<000Co003o1P001?l00?l30003
o`00008000?o00000P000ol0000:00002P001?l00?l40003o`3o00800_l00`3o00030003o`3o00<0
00Co003o1`001?l00?l20003o`0000<000?o00000P000ol000020004o`00o`D000?o000010000ol0
00030003o`00008000?o0?l01P000ol000020004o`00o`D000?o00000`000ol000040003o`000140
00Go0000o`030003o`3o008000Co00000_l30005o`000?l010001Ol0003o00<000Ko0000o`04o`@0
00Co003o0`000ol0o`020003o`00008000Go0000o`030005o`000?l010001Ol0003o00<000Co003o
1P001?l00?l30003o`00008000?o00000P000ol0000:00002P001?l0ool500;o0P04o`D00_l30004
o`3oo`@00ol30004o`3oo`@00_l40003o`0000<00_l60004o`0000Co1@000ol0000300;o1P000ol0
000300;o1P000ol0000200;o1P000ol0000A0005o`000?l00`000ol0o`02o`@00_l30006o`000?l0
0ol40005o`000?l00`001Ol0o`3o00D000Co003o0`000ol0o`02o`D000Go0000o`030003o`000080
00Go0000o`030005o`000?l00P000ol000040004o`00o`<000?o00000_l50003o`0000X0000:0003
o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003
o`0000X000?o00004@000ol0000200Ko1P02o`@01_l60003o`0000801_l00`3o00040004o`0000Ko
1`000ol0000200Ko0P001Ol0003o00@01Ol00`3o00050004o`0000Go0`000ol000020003o`0000X0
000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0
000;0003o`0000X000?o00004@000ol0000800?o0`02o`T01?l30003o`0000P00_l50003o`0000L0
0ol40003o`0000P00_l40003o`0000L00_l60003o`0000H00ol50003o`0000X0000:0003o`0000X0
0_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000X0
00?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o00003P000ol0000?0003o`0000h0
00?o00002P0000X0O?lC0003o`0000h00_l@0003o`0000l000?o00003P000ol0000>0003o`0000l0
00?o00003P000ol0000:00002P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0
000:0003o`0000/000?o00002`000ol0000:0003o`00014000?o00003P02oa0000?o00003`000ol0
000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0003o`0000X00_l<0003o`0000/0
00?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@000ol0
000>00;o40000ol0000?0003o`0000h000?o00003P000ol0000?0003o`0000h000?o00002P0000X0
00?o00002P02o``000?o00002`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/0
00?o00002P000ol0000A0003o`0000h00_l@0003o`0000l000?o00003P000ol0000>0003o`0000l0
00?o00003P000ol0000:00002P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0
000:0003o`0000/000?o00002`000ol0000:0003o`000140Nol<00002P000ol0o`02o`<00ol200Go
0`03o`<000?o0?l00_l300?o0`000ol000030003o`0000D000?o00000P03o`H01?l400?o0P000ol0
000300;o1P000ol0000300?o1@000ol0000200Co10000ol0000A0003o`0000h00_l@0003o`0000l0
00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P001?l00?l70006o`3oo`3o
1`001?l00?l20003o`0000<000?o00000P000ol000030003o`0000D000?o00000`000ol000050003
o`3o00H000Go0000o`040004o`00o`D000?o000010000ol000040003o`0000<000?o000010000ol0
000A0003o`0000h00_l@0003o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0
000:00002P001?l00?l70006o`3oo`3o1`001?l00?l20003o`0000<000?o00000P000ol000040003
o`0000@000?o00000`000ol000050003o`3o00@01?l20003o`00008000Co003o1@000ol0000200Co
1@000ol000040003o`0000<000?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o0000
3P000ol0000?0003o`0000h000?o00002P0000X000Co003o1@02o`800_l00`3o000400;o0`001?l0
0?l50003o`00008000?o000010000ol000040003o`0000<000?o00001@000ol0o`040003o`3o00<0
00?o00000`02o`H000?o00000P000ol0o`060003o`0000D000?o00000P000ol0000A0003o`0000h0
0_l@0003o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P001?l0
0?l70006o`3oo`3o1`001?l00?l20003o`0000<000?o00000P000ol000050003o`0000<000?o0000
0`000ol000050003o`3o00@000?o0?l00`000ol000020004o`00o`D000?o00000P000ol0o`060003
o`00008000Co003o10000ol0000A0003o`0000800ol900;o1003o`T000?o00000P03o`X000Co0000
0ol:0003o`0000800ol90003o`0000800ol:0004o`0000?o2P000ol0000:00002P001?l0ool400?o
0P04o`@00ol30004o`3oo`@00_l40003o`0000801?l50003o`0000800_l700?o1@02o`<000?o0000
0`02o`H000?o00000`02o`H000?o00000`02o`D000?o00004@000ol000050003o`0000H00_l70003
o`0000H000?o00001@000ol000070003o`0000@000?o00001`000ol000050003o`0000H000?o0000
1@000ol000070003o`0000@000?o00001`000ol0000:00002P000ol0000:00;o30000ol0000;0003
o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003o`00014000?o0000
0P04o`040?ooo`@00_l400Co00<0ool00_l30003o`0000801?l0103oool50004o`0000Co00@0oooo
1@000ol0000200Co0P02o`@000?o00000P04o`040?ooo`D000Co00001?l200?o10000ol0000:0000
2P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o0000
2`000ol0000:0003o`00014000Go0000o`030003o`00008000Co00000_l30005o`000?l00P000ol0
00030005o`000?l00`001?l00?l60004o`00o`<000?o00000P000ol000020005o`000?l00`000ol0
o`020005o`000?l00`001Ol0003o00@000?o00000P001?l00?l30005o`000?l01@000ol0000:0000
2P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o0000
2`000ol0000:0003o`00014000Go0000o`030003o`00008000Co00000_l30005o`000?l00`000ol0
00020005o`000?l00`001?l00?l60004o`00o`<000?o00000P000ol000020005o`000?l00`000ol0
o`020005o`000?l00`001Ol0003o00@000?o00000P001?l00?l30003o`3o00?o10000ol0000:0000
2P1loa<000Go0000o`030003o`3o00;o1002o`<000Go0000o`040005o`000?l00`001Ol0003o0080
00?o000010001?l00?l30003o`3o00;o1@001Ol0003o00<000?o0?l00_l40005o`000?l00`000ol0
0002o`D000Co003o0`001Ol0o`3o00D000?o00002P0000X000?o00002P02o``000?o00002`000ol0
000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`000080
1_l600;o1006o`8000Go0000o`0400Go00<0o`001@001?l00006o`L000?o00000P06o`H000?o0000
0P05o`<000?o00000P001?l00006o`030?l000@000?o00002P0000X000?o00002P02o``000?o0000
2`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003
o`0000L01?l300;o2P02o`@000?o00001`02o`H000?o00001P04o`@000?o00002003o`<000?o0000
1`03o`D000?o00001`02o`D000?o00002P0000X000?o00002P02o``000?o00002`000ol0000;0003
o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`0000h00_l@0003
o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0000:00;o
30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003
o`00014000?o00003P02oa0000?o00003`000ol0000>0003o`0000h000?o00003`000ol0000>0003
o`0000X0000:0003o`3o00;o0`03o`801Ol300?o0`000ol000030003o`0000D000?o0?l00_l400?o
0P000ol0000200Co1@04o`<00ol30003o`0000800ol60003o`0000<00_l60003o`0000<00ol40003
o`00014000?o00003P02oa0000?o00003`000ol0000>0003o`0000h000?o00003`000ol0000>0003
o`0000X0000:0004o`00o`D000Co00000_l00`3o00040003o`00008000?o00000`000ol000050004
o`00o`H000Go0000o`050003o`0000D000?o0?l01`001?l00?l50003o`0000D000?o00000P001?l0
0?l50003o`0000@000?o00000`000ol0000A0003o`0000h00_l@0003o`0000l000?o00003P000ol0
000>0003o`0000l000?o00003P000ol0000:00002P001?l00?l50004o`0000;o00<0o`0010000ol0
00020003o`0000@000?o000010001?l00?l400Co0P000ol000040003o`0000@000?o0?l01`001?l0
0?l50003o`0000D000?o00000P001?l00?l50003o`0000801?l40003o`000140Nol<00002P001?l0
0?l50004o`0000;o00<0o`0010000ol000020003o`0000@000?o000010001?l00?l40003o`3o00<0
00?o00001@000ol000030003o`3o00D00_l30003o`0000<000?o00001@000ol0000300;o1P000ol0
00020003o`3o00D000?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o00003P000ol0
000?0003o`0000h000?o00002P0000X000Co003o1@001?l00002o`030?l000@000?o00000P000ol0
00050003o`0000<000Co003o10000ol0o`030003o`00008000Co003o1@000ol0o`070004o`00o`D0
00?o00001@000ol000020004o`00o`D000?o00000P000ol0o`050003o`00014000?o00003P02oa00
00?o00003`000ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0004o`3oo`@0
0_l300Co1002o`@000?o00000P04o`D000Co0?oo1@02o`<000?o00000`02o`H00ol400?o0`000ol0
000200;o1`000ol0000300;o1P000ol0000300;o1@000ol0000A0003o`0000h00_l@0003o`0000l0
00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0000:00;o30000ol0
000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003o`000140
00?o00003P02oa0000?o00003`000ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0
000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0
000;0003o`0000X000?o00004@000ol0000200?o2@02o`@00ol90003o`0000800ol:0004o`0000?o
2P000ol0000200?o2@000ol0000200?o2P001?l00003o`X000?o00002P0000X000?o00002P02o``0
00?o00002`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0
000A0003o`0000D000?o00001P02o`L000?o00001P000ol000050003o`0000L000?o000010000ol0
00070003o`0000D000?o00001P000ol000050003o`0000L000?o000010000ol000070003o`0000X0
000:07co4`000ol0000200Co0P03o`<00_l400Co00@0oooo10000ol0000200Co0P02o`D000Co0000
1?l200?o10000ol0000200Co00@0oooo10000ol0000200Co00<0ool00_l40004o`0000Co00@0oooo
1@000ol0000:00002P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003
o`0000/000?o00002`000ol0000:0003o`00014000Go0000o`030005o`000?l01002o`<000Go0000
o`040005o`000?l00`001ol0003o0?l00P000ol000020004o`00o`<000Go0000o`050005o`000?l0
0`001?l00?l50005o`000?l00`001?l00?l60004o`00o`<000?o00000P000ol000020003o`0000X0
000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0
000;0003o`0000X000?o00004@001Ol0003o00<000?o0?l00ol300;o0`001Ol0003o00@000Go0000
o`030007o`000?l0o`020003o`00008000Co003o0`000ol0o`03o`@000Go0000o`030004o`00o`D0
00Go0000o`030005o`000?l01@001?l00?l30003o`00008000?o00000P000ol0000:00002P000ol0
000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0
000:0003o`00014000Go0000o`030005o`3o0?l01002o`<000Go0000o`0200;o10001Ol0003o00<0
00?o0?l00_l50004o`00o`<000Go0?l0o`050005o`000?l00`001?l00?l50005o`000?l00`000ol0
00020003o`00008000Co003o0`000ol0o`02o`D000?o00002P0000X000?o00000`02o`D00_l400;o
1P000ol0000200?o1P000ol0000200Co1@000ol0o`02o`<00ol30003o`0000800ol50003o`3o00;o
0`03o`<000?o0?l00_l400?o0P000ol000030003o`0000@000?o00004@000ol0000200Ko00<0o`00
0`02o`@01Ol30005o`000?l01006o`L000Co00001_l00`3o00040003o`0000801Ol00`3o00040003
o`0000801_l20003o`00008000Co00001_l70003o`0000X0000:0003o`00008000Co003o1002o`<0
00Co003o1@000ol000030003o`0000D000?o00000`000ol000050004o`00o`D000?o00000P000ol0
00030003o`0000@000Co003o1`001?l00?l20003o`0000@000Go0000o`050003o`0000@000?o0000
4@000ol0000800;o1002o`T00ol40003o`0000P00ol40003o`0000L00_l50003o`0000L00_l50003
o`0000P00_l50003o`0000H01?l40003o`0000X0000:0003o`00008000Co003o1002o`<000Co003o
1@000ol000030003o`0000D000?o000010000ol000040004o`00o`D000?o00000P001?l00004o`D0
00Co003o1`001?l00?l20003o`0000801?l20003o`0000@000?o00000`000ol0000A0003o`0000h0
0_l@0003o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0
000300;o1@02o`@00_l60003o`0000<000?o00001@000ol000050003o`0000<000Co003o1@000ol0
00020007o`000?l0o`060004o`00o`D00_l30004o`00o`@000?o0?l00`000ol000040003o`0000<0
00?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o00003P000ol0000?0003o`0000h0
00?o00002P0000X000?o00000P001?l00?l400;o0`001?l00?l50003o`0000<000?o00001@000ol0
00020004o`00o`D000Co003o1@000ol000020007o`000?l0o`060004o`00o`L000Co003o0P000ol0
00020003o`3o00<000?o00001@000ol000020003o`00014000?o00003P02oa0000?o00003`000ol0
000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0003o`0000<00_l500;o1002o`H0
00?o00000P02o`L000?o00000`02o`H000Co0?oo1002o`@000?o00000P02o`H000Co0?oo1003o`<0
00Co0?oo1@02o`<000?o00000P04o`@000?o00004@000ol0000>00;o40000ol0000?0003o`0000h0
00?o00003P000ol0000?0003o`0000h000?o00002P0000X000?o00002P02o``000?o00002`000ol0
000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`0000h0
0_l@0003o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0
000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0
000:0003o`000140Nol<00002P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0
000:0003o`0000/000?o00002`000ol0000:0003o`00014000?o00003P02oa0000?o00003`000ol0
000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:07co4`000ol0000>00;o40000ol0
000?0003o`0000h000?o00003P000ol0000?0003o`0000h000?o00002P0000X000?o00002P02o``0
00?o00002`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0
000A0003o`0000h00_l@0003o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0
000:00002P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/0
00?o00002`000ol0000:0003o`00014000?o00000P03o`T00_l400?o2@000ol0000200?o2P001?l0
0003o`X000?o00000P03o`T000?o00000P03o`X000Co00000ol:0003o`0000X0000:0003o`0000X0
0_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000X0
00?o00004@000ol000050003o`0000H00_l70003o`0000H000?o00001@000ol000070003o`0000@0
00?o00001`000ol000050003o`0000H000?o00001@000ol000070003o`0000@000?o00001`000ol0
000:00002P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/0
00?o00002`000ol0000:0003o`00014000?o00000P04o`040?ooo`@00_l400Co00@0oooo10000ol0
000200Co00<0ool00_l40004o`0000Co00@0oooo1@000ol0000200Co0P03o`<000?o00000P04o`04
0?ooo`D000Co00001?l200;o1@000ol0000:00002P000ol000030003o`0000@00_l40003o`0000D0
00?o0?l00_l400?o0P000ol0o`02o`<00ol30003o`0000<00ol500Co0`03o`<000?o00000P04o`D0
00?o00000P03o`H000?o00000`02o`D000?o00004@001Ol0003o00<000?o00000P001?l00002o`<0
00Go0000o`020003o`0000<000Go0000o`030004o`00o`H000Co003o0`000ol000020003o`000080
00Go0000o`030005o`000?l010001Ol0003o00<000?o00000P000ol000020004o`00o`<000?o0?l0
0P000ol000020003o`0000X0000:0003o`0000<000?o00001002o`@000?o00001@001?l00?l60005
o`000?l00P000ol000050004o`00o`H000?o000010000ol0o`050003o`00008000?o00000`000ol0
00050003o`0000<000?o00001@000ol000020004o`00o`@000?o00004@001Ol0003o00<000?o0000
0P001?l00002o`<000Go0000o`020003o`0000<000Go0000o`030005o`000?l01@001?l00?l30003
o`00008000?o00000P001Ol0003o00<000?o0?l00ol30005o`000?l00`000ol000020003o`000080
00Co003o0`000ol0o`020003o`00008000?o00002P0000X000?o000010000ol0000300;o1@000ol0
00040004o`00o`@01?l20004o`00o`L000Co003o1004o`D000?o0?l01@000ol000020003o`0000@0
00?o000010000ol000030003o`0000D000?o00000P001?l00?l40003o`00014000Go0000o`030003
o`0000;o1002o`<000Go0000o`020003o`0000<000Go0000o`030003o`00008000?o00000P001?l0
0?l30003o`0000;o1@001Ol0003o00<000Go0?l0o`040005o`000?l00`000ol0o`02o`D000Co003o
0`000ol0o`02o`D000?o00002P0000X000?o000010000ol0000300;o1@000ol000040004o`00o`@0
00?o0?l00`001?l00?l500;o0`000ol000020003o`3o00H000?o0?l01@000ol000020003o`0000D0
00?o00000`000ol000030003o`0000D000?o00000`02o`D000?o00004@000ol0000200Go0`001?l0
0002o`@01Ol00`3o00040003o`0000801_l20003o`00008000Co00001Ol30003o`00008000?o0000
0P06o`030?l000<000?o00000P06o`L000Co00001_l70003o`0000X0000:0003o`0000D000?o0000
0P02o`H000?o00000`001?l00?l40003o`3o00<000Co003o1`001?l00?l40003o`3o00H000?o0?l0
1@000ol000020003o`00008000Co003o1@000ol000030003o`0000D000?o00000P001?l00?l40003
o`00014000?o00001`03o`@00_l900;o1@000ol0000800;o1@000ol0000600?o1@000ol0000800;o
10000ol0000700Co10000ol0000700?o10000ol0000:00002P000ol0000200Co1002o`<01?l50004
o`3oo`D00_l30004o`3oo`@00ol30003o`0000<00_l600?o1002o`@000?o00000`02o`H000?o0000
0P02o`L000?o00000`02o`D000?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o0000
3P000ol0000?0003o`0000h000?o00002P0000X000?o00002P02o``000?o00002`000ol0000;0003
o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`0000h00_l@0003
o`0000l000?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0000:00;o
30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003
o`00014000?o00003P02oa0000?o00003`000ol0000>0003o`0000h000?o00003`000ol0000>0003
o`0000X0000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o0000
2`000ol0000;0003o`0000X000?o00004@000ol0000>00;o40000ol0000?0003o`0000h000?o0000
3P000ol0000?0003o`0000h000?o00002P0000X0O?lC0003o`0000h00_l@0003o`0000l000?o0000
3P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ol0000:00;o30000ol0000;0003
o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003o`000140Nol<0000
2P000ol0000:00;o30000ol0000;0003o`0000/000?o00002`000ol0000:0003o`0000/000?o0000
2`000ol0000:0003o`00014000?ogml03]l2oa0S00?o8b<03b<00ol0000>0003o`0000h000?o0000
3`000ol0000>0003o`0000X0000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003
o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@000ooOg`0>g`;o42<00olS8`0?8`03
o`0000h000?o00003P000ol0000?0003o`0000h000?o00002P0000X000?o00002P02o``000?o0000
2`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003
omoO00kO0_l@8`03ob<S00lS00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:0000
2P000ol0000300?o1002o`@00ol50003o`0000<00_l60003o`0000800ol60003o`3o00;o0`03o`<0
00Co00001?l50003o`3o00;o1003o`8000?o00000`000ol000050003o`3o00;o0`03o`8000?o0000
4@000ooOg`0>g`;o42<00olS8`0?8`03o`0000h000?o00003P000ol0000?0003o`0000h000?o0000
2P0000X000?o000010000ol0000300;o1@000ol000040003o`00008000Co003o1@000ol000030003
o`0000D000Co003o1`001?l00?l40003o`0000D000Co003o1P001Ol0003o00D000?o00001@001?l0
0?l50005o`000?l04`000ooOg`02g`?o2Ml2o`@S0ol98`03ob<S008S0ol:8`04o`0000?o2P000ol0
000200?o2@000ol0000200?o2P001?l00003o`X000?o00002P0000X000?o00000P04o`@00_l300Co
1@000ol000020004o`00o`D000?o00000`000ol000050004o`00o`L000Co003o1@000ol000040004
o`00o`@01?l20003o`0000@000?o000010001?l00?l50005o`000?l04`000ooOg`05g`03omoO00KO
0_l78`03ob<S00HS00?o8b<01B<00olS8`078`03o`0000@000?o00001`000ol000050003o`0000H0
00?o00001@000ol000070003o`0000@000?o00001`000ol0000:00002P000ol000020003o`3o00D0
0_l30003o`3o00H000?o00000`02o`H000?o00000`000ol000050004o`00o`D00_l30003o`0000@0
00?o00000`001?l00?l40003o`3o00<000?o000010000ol000040004o`00o`D000Go0000o`0C0003
omoO00;O1?l00mooo`02o`?O0_l48`Co0R<2o`@S00?o8b<00R<4o`048oooo`DS00Co00001?l00`3o
o`02o`@000?o00000P04o`040?ooo`@000?o00000P04o`800ol40004o`0000Co00@0oooo1@000ol0
000:00002P000ol000020003o`3o00D00_l30003o`3o00H000?o00000P001?l00?l50003o`0000<0
00?o00001@001?l00?l70004o`00o`<000Co003o1@001?l00?l40003o`3o00<000?o00001@000ol0
00030004o`00o`D000Go0000o`0C0005omoOgol00ml01?oOgol5g`;o0b<01olS8b?o8ol00R<01OlS
8b?o00<S00Go8b<So`048`03ob<S008S00Co003o0`001?l00?l60005o`000?l00`000ol000020005
o`000?l00`001Ol0003o00<000?o00000`001?l00?l30004o`00o`H000?o00002P0000X000?o0000
0`02o`D00_l400;o1P000ol0000300;o1P000ol0000200;o1`001?l0ool400?o0`000ol0000200;o
1P001?l0ool500;o0`000ol0000200Co1@001?l0ool400;o0`000ol0000A0005omoOgol00ml01OoO
gmoo00CO0_l38`07ob<S8olSo`028`05ob<S8ol00b<01OlS8b?o00@S00?o8b<00R<01?l00?l30005
o`000?l01@001Ol0003o00<000?o00000P001Ol0003o00<000Ko0000o`04o`@000Co003o0`001?l0
0?l60003o`0000X0000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X0
00?o00002`000ol0000;0003o`0000X000?o00004@001OoOgmoo00?O00?ogml00]l01?oOgml2o`<S
00Ko8b<Sob<3o`@S00Go8b<So`038`03ob<S00;o1B<01?l00?l30003o`00008000?o00000P001Ol0
003o00<000?o0?l00_l40005o`000?l00`001Ol0o`3o00D000Co003o0`001?l00?l60003o`0000X0
000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0
000;0003o`0000X000?o00004@000ooOg`02g`Ko0]l01?oOgml2o`@S1_l68`03ob<S008S1Ol38`03
ob<S008S00Co00001_l20003o`00008000?o00000P06o`H000?o00000P06o`030?l000@000Co0000
1Ol00`3o00050003o`0000X0000:0003o`0000X00_l<0003o`0000/000?o00002`000ol0000;0003
o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@000ooOg`08g`;o1=l2o`XS0ol38`03
ob<S00LS0ol58`03o`0000L00_l50003o`0000L01?l30003o`0000P00_l50003o`0000H00_l60003
o`0000X0000:07co4`000ooOg`0>g`;o42<00olS8`0?8`03o`0000h000?o00003P000ol0000?0003
o`0000h000?o00002P0000X000?ogml02]l2o`cO00?o8b<02b<00ol0000;0003o`0000/000?o0000
2P000ol0000;0003o`0000/000?o00002P000ol0000A0003omoO00kO0_l@8`03ob<S00lS00?o0000
3P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ooOg`0:g`;o3=l00olS8`0;8`03
o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003o`00014000?ogml0
3]l2oa0S00?o8b<03b<00ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0003
omoO00[O0_l<g`03ob<S00/S00?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003
o`0000X000?o00004@000ooOg`0>g`;o42<00olS8`0?8`03o`0000h000?o00003P000ol0000?0003
o`0000h000?o00002P0000X000?ogml02]l2o`cO00?o8b<02b<00ol0000;0003o`0000/000?o0000
2P000ol0000;0003o`0000/000?o00002P000ol0000A07_o300000X000?ogml00]l4o`CO0_l3g`Co
1Ml00olS8`038`?o1B<00ol0000300;o1P000ol0o`02o`@00ol20004o`0000?o1P000ol000030003
o`0000D000?o0?l00_l300?o0`000ol0o`02o`<00ol20003o`00014000?ogml03]l2oa0S00?o8b<0
3b<00ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0003omoO00?O00?ogml0
1=l2o`CO00?ogml01Ml00olS8`048`03ob<S00@S00?o00000P001?l00?l50004o`00o`H000Go0000
o`040003o`0000D000?o00000`000ol000050004o`00o`D000?o00000P001?l00?l70003o`3o01<0
00?ogml03]l2oa0S00?o8b<03b<00ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0
000:0003omoO00CO00?ogml00ml2o`GO00?ogml01=l00olS8`028`Co1B<00ol000020004o`00o`D0
00Co003o1004o`8000?o00000P000ol000050003o`0000@000?o000010001?l00?l50003o`000080
00Co003o1`000ol0o`0C0003omoO00kO0_l@8`03ob<S00lS00?o00003P000ol0000>0003o`0000l0
00?o00003P000ol0000:00002P000ooOg`05g`03omoO00;O0_l6g`03omoO00?O00?o8b<00R<00olS
o`068`03o`0000<00_l60004o`00o`@000?o0?l00`000ol000020003o`0000D000?o000010000ol0
00040004o`00o`D000?o00000P001?l00?l500;o0P000ol0000A0003omoO00kO0_l@8`03ob<S00lS
00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P000ooOg`02g`04omoOo`CO
0_l3g`04omoOo`GO00?o8b<00R<00olSo`068`03o`00008000Co003o1@001?l00?l40003o`3o00<0
00?o00000P000ol000050003o`0000D000?o00000`001?l00?l50003o`00008000Co003o1`000ol0
o`0C0003omoO00;O0ol9g`;o12<3o`TS00?o8b<00R<3o`XS00Co00000ol:0003o`0000800ol90003
o`0000800ol:0004o`0000?o2P000ol0000:00002P000ooOg`03g`;o1Ml2o`CO0_l6g`03ob<S00<S
0_l68`03o`0000<00_l60004o`3oo`D00_l30004o`0000;o1`000ol0000200Co1@001?l0ool400;o
10001?l0ool400?o0P000ol0000A0003omoO00GO00?ogml01]l2o`LS00?o8b<01R<00olS8`058`03
ob<S00LS00?o000010000ol000070003o`0000D000?o00001P000ol000050003o`0000L000?o0000
10000ol000070003o`0000X0000:0003omoO00[O0_l<g`03ob<S00/S00?o00002`000ol0000;0003
o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@000ooOg`02g`Co00COoooo1=l2o`@S
1?l28`?o0b<00olS8`028`Co00@Soooo1B<01?l00004o`040?ooo`D000?o00000P04o`040?ooo`@0
00?o00000P04o`800_l50004o`0000Co00<0ool00_l40003o`0000X0000:0003omoO00[O0_l<g`03
ob<S00/S00?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000X000?o0000
4@001OoOgmoo00?O00Cogmoo1Ml2o`<S00Go8b<So`038`03ob<S008S00Go8b<So`038`03ob<S008S
00?o8b<00R<01?l00?l30004o`00o`H000Go0000o`030003o`00008000Go0000o`030007o`000?l0
o`020003o`00008000Co003o0`001?l00?l60003o`0000X0000:0003omoO00[O0_l<g`03ob<S00/S
00?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@001OoO
gmoo00?O00Cogmoo1Ml2o`<S00Ko8b<Sob<4o`<S00Go8b<So`038`03ob<S008S00?o8b<00R<01?l0
0?l30004o`00o`H000Go0000o`030003o`00008000Go0000o`030007o`000?l0o`020003o`000080
00Co003o0`001Ol0003o00D000?o00002P0000X0O?lC0005omoOgol00ml01?oOgol5g`;o0b<02OlS
8b?o8olSo`048`05ob<S8ol00b<00olSo`02o`DS00Co003o0`001?l00?l60005o`000?l00`000ol0
0002o`@000Go0000o`030003o`3o00;o1@001?l00?l30003o`00008000?o00000P000ol0000:0000
2P000ooOg`0:g`;o3=l00ooOg`0;g`03o`0000/000?o00002`000ol0000:0003o`0000/000?o0000
2`000ol0000:0003o`00014000?ogml00]l5o`03gooO00CO0_l48`Ko00<Sob<00b<00olS8`028`Ko
1b<01?l00005o`030?l000D000?o00000P05o`<000Go0000o`0400Ko1`001?l00006o`8000?o0000
0P000ol0000:00002P000ooOg`0:g`;o3=l00ooOg`0;g`03o`0000/000?o00002`000ol0000:0003
o`0000/000?o00002`000ol0000:0003o`00014000?ogml01ml2o`GO0_l:8`;o12<00olS8`078`Co
12<00ol0000600;o1P000ol0000700?o10000ol0000800?o10000ol0000700;o1@000ol0000:0000
2P000ooOg`0:g`;o3=l00ooOg`0;g`03o`0000/000?o00002`000ol0000:0003o`0000/000?o0000
2`000ol0000:0003o`00014000?ogml03]l2oa0S00?o8b<03b<00ol0000>0003o`0000h000?o0000
3`000ol0000>0003o`0000X0000:0003omoO00;O0ol5g`;o0ml3o`KO00?ogml00]l4o`GO00?o0000
0`03o`D000?o00000`000ol000050003o`0000800_l60003o`3o00;o0`03o`<000?o0?l00_l300?o
0`000ol0o`02o`@00ol00`3o000B0003omoO00kO0_l@8`03ob<S00lS00?o00003P000ol0000>0003
o`0000l000?o00003P000ol0000:00002P000ooOg`03g`03omoO00CO0_l4g`03omoO00GO00?ogml0
0ml00ooOg`05g`03o`0000@000?o000010000ol000030003o`0000D000Go0000o`020003o`0000<0
00Co003o1@000ol000020004o`00o`L000Co003o0P000ol000040004o`00oa<000?ogml03]l2oa0S
00?o8b<03b<00ol0000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0003omoO00?O
00?ogml01=l2o`CO00?ogml01Ml00ooOg`04g`03omoO00CO00?o00000P04o`D000?o000010000ol0
00040005o`000?l00P000ol000030004o`00o`D000?o00000P001?l00?l70004o`00o`8000?o0000
0P04o`030?l0018000?ogml03]l2oa0S00?o8b<03b<00ol0000>0003o`0000h000?o00003`000ol0
000>0003o`0000X0000:0003omoO00?O00?ogml01=l2o`CO00?ogml01Ml00ooOg`05g`03omoO00?O
00?o00000P000ol0o`060003o`0000@000?o000010000ol0000200;o1P001?l00?l50003o`000080
00Co003o1@02o`<000Co003o10000ol0o`020003o`00014000?ogml03]l2oa0S00?o8b<03b<00ol0
000>0003o`0000h000?o00003`000ol0000>0003o`0000X0000:0003omoO00?O00?ogml01=l2o`CO
00?ogml01Ml00ooOg`02g`04omoOo`GO00?o00000P000ol0o`060003o`0000D000?o00000`001Ol0
003o008000?o00000`001?l00?l50003o`00008000Co003o1`001?l00?l20003o`00008000?o0?l0
0P000ol0000@07co300000X000?ogml00]l2o`KO0_l3g`;o1ml00ooOg`03g`;o1]l00ol0000300;o
1P000ol0000200Co1@000ol0000200;o1P001?l0ool400;o10001?l0ool400?o0`001?l0ool500;o
0P000ol0000@07co300000X000?ogml02]l2o`cO00?ogml02ml00ol0000;0003o`0000/000?o0000
2P000ol0000;0003o`0000/000?o00002P000ol0000A0003o`0000`000Co0?oo4=l00ooOg`0?g`03
o`0000h000?o00003P000ol0000?0003o`0000h000?o00002P0000X000?ogml02]l2o`cO00?ogml0
2ml00ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000A0003
o`0000/000?o00000_l@g`03omoO00oO00?o00003P000ol0000>0003o`0000l000?o00003P000ol0
000:00002P000ooOg`0:g`;o3=l00ooOg`0;g`03o`0000/000?o00002`000ol0000:0003o`0000/0
00?o00002`000ol0000:0003o`00014000?o00000_l00`3oo`050004o`0000;o1=l3o`WO00?ogml0
0]l3o`[O00Co00000ol:0003o`0000800ol90003o`0000800ol:0004o`0000?o2P000ol0000:0000
2@1moa<000Oo0000o`3o00D000?o00000P02o`OO00?ogml01]l00ooOg`05g`03omoO00OO00?o0000
10000ol000070003o`0000D000?o00001P000ol000050003o`0000L000?o000010000ol000070003
o`0000X0000907go4`000ol000020003o`0000<000?o00000`02o`CO1?l01=ooool4g`03omoO00;O
1?l00mooo`02o`CO00Co00001?l0103oool50003o`0000801?l200?o0`000ol0000200Co00@0oooo
1@001?l00004o`800_l50003o`0000X0000:0003o`0000T00ol<g`03omoO00_O00?o00002`000ol0
000;0003o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@001ol0003o0?l00`000ol0
000400;o0ml01OoOgmoo00;O00?ogml00ml01OoOgmoo00?O00Cogmoo1]l01?l00?l30003o`000080
00?o00000P001Ol0003o00<000Go0000o`040005o`000?l00`000ol000020003o`00008000Co003o
0`000ol0o`020003o`00008000?o00002P0000X000Go0?oo0002o`@000Co0?oo3=l00ooOg`0;g`03
o`0000/000?o00002`000ol0000:0003o`0000/000?o00002`000ol0000:0003o`00014000?o0000
0_l0103oo`04o`@00_l3g`05omoOgol00]l00ooOg`03g`05omoOgol00ml01OoOgmoo00GO00Co003o
0`000ol000020003o`00008000Go0000o`030003o`3o00?o0`001Ol0003o00<000?o00000P000ol0
00020004o`00o`<000?o0?l00P000ol000020003o`0000X0000:0006o`00o`3o10000ol00002o`cO
00?ogml02ml00ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0
000A0003o`0000D000Co003o1@02o`?O00GogmoOo`02g`03omoO00?O00GogmoOo`03g`03omoO00;O
00?ogml00]l01?l00?l30003o`0000;o1@001Ol0003o00<000Go0?l0o`040005o`000?l00`000ol0
o`02o`D000Co003o0`000ol0o`02o`D000?o00002P0000X000Go0000o`040004o`0000;o0ml3o`KO
00?ogml00]l4o`GO00?o00000`03o`D000?o00000`000ol000050003o`0000800_l60003o`3o00;o
0`03o`<000?o0?l00_l300?o0`000ol0o`02o`@00ol00`3o000B0003o`0000@000?o00000P000ol0
000200;o1=l5o`03gooO00CO00?ogml00]l6o`;O00?ogml00]l01?l00005o`<000?o00000P000ol0
000200Ko00<0o`000`000ol0000200Ko1`001?l00006o`L000?o00002P0000X000Oo003o0?l000?o
0`02o`CO00?ogml01Ml00ooOg`03g`03omoO00GO00?o000010000ol000040003o`0000<000?o0000
1@001Ol0003o008000?o00000`001?l00?l50003o`00008000Co003o1`001?l00?l20003o`0000@0
00Co003o4`000ol000030003o`0000<000?o00000P02o`WO0_l5g`03omoO00SO0_l5g`03o`0000H0
0ol50003o`0000P00_l40003o`0000L01?l40003o`0000L00ol40003o`0000X0000:0005o`3oo`00
1?l400;o1=l00ooOg`05g`03omoO00CO00?ogml01=l00ol0000200Co1@000ol000040003o`0000@0
00Go0000o`020003o`0000<000Co003o1@000ol000020004o`00o`L000Co003o0P000ol0000200Co
00<0o`004P000ol000020003o`0000<000?o0?l00`02oa3O00?ogml03ml00ol0000>0003o`0000h0
00?o00003`000ol0000>0003o`0000X0000:0003o`0000<000Co003o0`02o`CO00?ogml01Ml00ooO
g`05g`03omoO00?O00?o00000P000ol0o`060003o`0000@000?o000010000ol0000200;o1P001?l0
0?l50003o`00008000Co003o1@02o`<000Co003o10000ol0o`020003o`00014000Go0000o`060003
o`3o00<00_l@g`03omoO00oO00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:0000
2P000ol000020005o`000?l00`02o`CO00?ogml01Ml00ooOg`02g`04omoOo`GO00?o00000P000ol0
o`060003o`0000D000?o00000`001Ol0003o008000?o00000`001?l00?l50003o`00008000Co003o
1`001?l00?l20003o`00008000?o0?l00P000ol0000A0004o`00o`H00_l00`3oo`0200;o4=l00ooO
g`0?g`03o`0000h000?o00003P000ol0000?0003o`0000h000?o00002P0000X000Go0000o`030003
o`3o00800_l3g`;o1ml00ooOg`03g`;o1]l00ol0000300;o1P000ol0000200Co1@000ol0000200;o
1P001?l0ool400;o10001?l0ool400?o0`001?l0ool500;o0P000ol0000A0003o`3o00h00_l@g`03
omoO00oO00?o00003P000ol0000>0003o`0000l000?o00003P000ol0000:00002P001?l00?l40003
o`3o00800_l<g`03omoO00_O00?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003
o`0000X000?o00004@02o`l00_l@g`03omoO00oO00?o00003P000ol0000>0003o`0000l000?o0000
3P000ol0000:00002P000ol0o`0400;o00@0ool00_l<g`03omoO00_O00?o00002`000ol0000;0003
o`0000X000?o00002`000ol0000;0003o`0000X000?o00004@1ko``0000:00;o2`02o`cO00?ogml0
2ml00ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000R00;o
M00000X0O?nJ00005`02ool020000?l08@0001800_l@00;oE`03ob400_l:00;oG003oa80000B0003
o`00010000?o0000EP000ol0000P0003o`0000X000?o0000F`000ol0000A00003002o`@000?o0000
0P03o`<00ol50003o`0003d00_l00`3oo`090003o`3o00T000?o00005`05o`<000?o00000P03o`D0
00?o0000@P02o`030?oo00T000?o0?l02@000ol0000@00002`001?l00?l30003o`0000<000?o0000
1@000ol000020003o`0003h000?o0?l02`000ol000080003o`0001P000Go0000o`020003o`0000D0
00?o00000P000ol000130003o`3o00/000?o000020000ol0000@00002`001?l00?l30003o`0000<0
00?o00001@000ol000020003o`0003l000?o00002005o`L000?o0?l06@001Ol0003o008000?o0000
1@000ol000020003o`0004@000?o00002005o`L000?o0?l04@0000/000Co003o0`000ol000030003
o`0000800ol50003o`0003h000?o0?l02`000ol000070003o`3o01T000Go0000o`020003o`0000<0
0_l50003o`0004<000?o0?l02`000ol000070003o`3o0140000;0004o`00o`<000?o00000`000ol0
00020003o`0000D000?o0000?@02o`030?oo01<00_l00`3oo`0H0005o`000?l00P000ol000050003
o`00008000?o0000@P02o`030?oo01<00_l00`3oo`0@00002P02o`800_l200;o0`02o`@01?l300;o
L`05o`<00_l300?o1002og40003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {143.75, 0}} -> {-0.0537398, -0.0251377, 
  0.00734314, 0.00734314}, {{7.3125, 137}, {140.312, 
  3.375}} -> {-1.7579, -0.489659, 0.0728683, 0.0728683}, {{149.938, 
  279.625}, {140.312, 3.375}} -> {-9.85181, -0.385226, 0.0575088, 
  0.0575088}},
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1, 2}, Mod[#1\ #2, 15]&], 
      Groupoid[{Rot, Ref}, "-Operation-"]}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "The syntax for the ",
  StyleBox["SubgroupQ", "MR"],
  " function is similar to ",
  StyleBox["Subgroupoid", "MR"],
  ", but the order of the arguments is reversed. This is because the notation \
",
  Cell[BoxData[
      \(TraditionalForm\`H < G\)]],
  " is frequently used to indicate that ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". Following are the basic forms; each of these can handle the standard \
modes, as well as ",
  StyleBox["Visual2.", "MR"]
}], "Text",
  CellTags->{"Subgroups", "i:6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SubgroupQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(H, \ G\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ subset\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["th",
                        SingleLetterItalics->False], "e"}]], " ", 
                  "groupoid", 
                  StyleBox[
                    FormBox["G",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["SubgroupQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{\(H\_1\), 
                        StyleBox[",",
                          "MR"], " ", \(H\_2\), 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]"}], 
                      StyleBox["}",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["G",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ a\ list\ of\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["depending",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subset",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_i\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroup",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["SubgroupQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      RowBox[{
                        StyleBox["{",
                          "MR"], 
                        RowBox[{
                          SubscriptBox[
                            StyleBox["H",
                              "TI"], "1"], 
                          StyleBox[",",
                            "MR"], " ", 
                          SubscriptBox[
                            StyleBox["G",
                              "TI"], "1"]}], 
                        StyleBox["}",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], " ", 
                      RowBox[{
                        StyleBox["{",
                          "MR"], 
                        RowBox[{
                          SubscriptBox[
                            StyleBox["H",
                              "TI"], "2"], 
                          StyleBox[",",
                            "MR"], " ", 
                          SubscriptBox[
                            StyleBox["G",
                              "TI"], "2"]}], 
                        StyleBox["}",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], " ", "\[Ellipsis]"}], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ a\ list\ of\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["depending",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subset",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_i\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroup",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], " ", "groupoid", " ", 
              StyleBox[
                FormBox[\(G\_i\),
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"Subgroups", "i:7"}],

Cell[TextData[{
  "Variations of the ",
  StyleBox["SubgroupQ",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"Subgroups"],

Cell[TextData[{
  "The ",
  StyleBox["TwistedZ", "MR"],
  " groupoid was introduced earlier. Is the set {0, 2, 8} a subgroup of ",
  StyleBox["TwistedZ[13]", "MR"],
  "?"
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[\ {0, \ 2\ , \ 8}, TwistedZ[13]]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s pick some random sets of elements from ",
  StyleBox["TwistedZ[7]", "MR"],
  " and see which of these are subgroups."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[\ 
      Table[RandomElements[TwistedZ[7], \ 
          Random[Integer, {1, \ Size[TwistedZ[7]]}], \ 
          Replacement\  \[Rule] \ False], \ {4}], TwistedZ[7], \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("All the elements marked with yellow are original elements in the set. \
Those in red are from outside."\)], "Print",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0255102 0.47619 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0255102 0.477324 0.511419 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(0)] .22789 .77381 0 0 Mshowa
[(4)] .36395 .77381 0 0 Mshowa
[(1)] .5 .77381 0 0 Mshowa
[(2)] .63605 .77381 0 0 Mshowa
[(3)] .77211 .77381 0 0 Mshowa
[(5)] .90816 .77381 0 0 Mshowa
[(4)] .22789 .63776 0 0 Mshowa
[(3)] .36395 .63776 0 0 Mshowa
[(2)] .5 .63776 0 0 Mshowa
[(0)] .63605 .63776 0 0 Mshowa
[(5)] .77211 .63776 0 0 Mshowa
[(1)] .90816 .63776 0 0 Mshowa
[(1)] .22789 .5017 0 0 Mshowa
[(2)] .36395 .5017 0 0 Mshowa
[(3)] .5 .5017 0 0 Mshowa
[(5)] .63605 .5017 0 0 Mshowa
[(0)] .77211 .5017 0 0 Mshowa
[(4)] .90816 .5017 0 0 Mshowa
[(2)] .22789 .36565 0 0 Mshowa
[(0)] .36395 .36565 0 0 Mshowa
[(5)] .5 .36565 0 0 Mshowa
[(1)] .63605 .36565 0 0 Mshowa
[(4)] .77211 .36565 0 0 Mshowa
[(3)] .90816 .36565 0 0 Mshowa
[(3)] .22789 .22959 0 0 Mshowa
[(5)] .36395 .22959 0 0 Mshowa
[(0)] .5 .22959 0 0 Mshowa
[(4)] .63605 .22959 0 0 Mshowa
[(1)] .77211 .22959 0 0 Mshowa
[(2)] .90816 .22959 0 0 Mshowa
[(5)] .22789 .09354 0 0 Mshowa
[(1)] .36395 .09354 0 0 Mshowa
[(4)] .5 .09354 0 0 Mshowa
[(3)] .63605 .09354 0 0 Mshowa
[(2)] .77211 .09354 0 0 Mshowa
[(0)] .90816 .09354 0 0 Mshowa
[(0)] .09184 .77381 0 0 Mshowa
[(4)] .09184 .63776 0 0 Mshowa
[(1)] .09184 .5017 0 0 Mshowa
[(2)] .09184 .36565 0 0 Mshowa
[(3)] .09184 .22959 0 0 Mshowa
[(5)] .09184 .09354 0 0 Mshowa
[(0)] .22789 .90986 0 0 Mshowa
[(4)] .36395 .90986 0 0 Mshowa
[(1)] .5 .90986 0 0 Mshowa
[(2)] .63605 .90986 0 0 Mshowa
[(3)] .77211 .90986 0 0 Mshowa
[(5)] .90816 .90986 0 0 Mshowa
[(TwistedZ[7])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0255102 0.97619 0.511419 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 0 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(1)] .22789 .77381 0 0 Mshowa
[(2)] .36395 .77381 0 0 Mshowa
[(5)] .5 .77381 0 0 Mshowa
[(4)] .63605 .77381 0 0 Mshowa
[(0)] .77211 .77381 0 0 Mshowa
[(3)] .90816 .77381 0 0 Mshowa
[(2)] .22789 .63776 0 0 Mshowa
[(0)] .36395 .63776 0 0 Mshowa
[(1)] .5 .63776 0 0 Mshowa
[(3)] .63605 .63776 0 0 Mshowa
[(4)] .77211 .63776 0 0 Mshowa
[(5)] .90816 .63776 0 0 Mshowa
[(5)] .22789 .5017 0 0 Mshowa
[(1)] .36395 .5017 0 0 Mshowa
[(3)] .5 .5017 0 0 Mshowa
[(0)] .63605 .5017 0 0 Mshowa
[(2)] .77211 .5017 0 0 Mshowa
[(4)] .90816 .5017 0 0 Mshowa
[(4)] .22789 .36565 0 0 Mshowa
[(3)] .36395 .36565 0 0 Mshowa
[(0)] .5 .36565 0 0 Mshowa
[(1)] .63605 .36565 0 0 Mshowa
[(5)] .77211 .36565 0 0 Mshowa
[(2)] .90816 .36565 0 0 Mshowa
[(0)] .22789 .22959 0 0 Mshowa
[(4)] .36395 .22959 0 0 Mshowa
[(2)] .5 .22959 0 0 Mshowa
[(5)] .63605 .22959 0 0 Mshowa
[(3)] .77211 .22959 0 0 Mshowa
[(1)] .90816 .22959 0 0 Mshowa
[(3)] .22789 .09354 0 0 Mshowa
[(5)] .36395 .09354 0 0 Mshowa
[(4)] .5 .09354 0 0 Mshowa
[(2)] .63605 .09354 0 0 Mshowa
[(1)] .77211 .09354 0 0 Mshowa
[(0)] .90816 .09354 0 0 Mshowa
[(2)] .09184 .77381 0 0 Mshowa
[(0)] .09184 .63776 0 0 Mshowa
[(1)] .09184 .5017 0 0 Mshowa
[(3)] .09184 .36565 0 0 Mshowa
[(4)] .09184 .22959 0 0 Mshowa
[(5)] .09184 .09354 0 0 Mshowa
[(2)] .22789 .90986 0 0 Mshowa
[(0)] .36395 .90986 0 0 Mshowa
[(1)] .5 .90986 0 0 Mshowa
[(3)] .63605 .90986 0 0 Mshowa
[(4)] .77211 .90986 0 0 Mshowa
[(5)] .90816 .90986 0 0 Mshowa
[(TwistedZ[7])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.56001 0.477324 1.04592 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.84014 .70578 m
.84014 .84184 L
.97619 .84184 L
.97619 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.70408 .16156 m
.70408 .29762 L
.84014 .29762 L
.84014 .16156 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.15986 .02551 m
.15986 .16156 L
.29592 .16156 L
.29592 .02551 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.70408 .84184 m
.70408 .97789 L
.84014 .97789 L
.84014 .84184 L
F
.84014 .84184 m
.84014 .97789 L
.97619 .97789 L
.97619 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
.02381 .16156 m
.02381 .29762 L
.15986 .29762 L
.15986 .16156 L
F
.02381 .02551 m
.02381 .16156 L
.15986 .16156 L
.15986 .02551 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(3)] .22789 .77381 0 0 Mshowa
[(0)] .36395 .77381 0 0 Mshowa
[(2)] .5 .77381 0 0 Mshowa
[(4)] .63605 .77381 0 0 Mshowa
[(1)] .77211 .77381 0 0 Mshowa
[(5)] .90816 .77381 0 0 Mshowa
[(0)] .22789 .63776 0 0 Mshowa
[(1)] .36395 .63776 0 0 Mshowa
[(5)] .5 .63776 0 0 Mshowa
[(2)] .63605 .63776 0 0 Mshowa
[(3)] .77211 .63776 0 0 Mshowa
[(4)] .90816 .63776 0 0 Mshowa
[(2)] .22789 .5017 0 0 Mshowa
[(5)] .36395 .5017 0 0 Mshowa
[(3)] .5 .5017 0 0 Mshowa
[(1)] .63605 .5017 0 0 Mshowa
[(4)] .77211 .5017 0 0 Mshowa
[(0)] .90816 .5017 0 0 Mshowa
[(4)] .22789 .36565 0 0 Mshowa
[(2)] .36395 .36565 0 0 Mshowa
[(1)] .5 .36565 0 0 Mshowa
[(0)] .63605 .36565 0 0 Mshowa
[(5)] .77211 .36565 0 0 Mshowa
[(3)] .90816 .36565 0 0 Mshowa
[(1)] .22789 .22959 0 0 Mshowa
[(3)] .36395 .22959 0 0 Mshowa
[(4)] .5 .22959 0 0 Mshowa
[(5)] .63605 .22959 0 0 Mshowa
[(0)] .77211 .22959 0 0 Mshowa
[(2)] .90816 .22959 0 0 Mshowa
[(5)] .22789 .09354 0 0 Mshowa
[(4)] .36395 .09354 0 0 Mshowa
[(0)] .5 .09354 0 0 Mshowa
[(3)] .63605 .09354 0 0 Mshowa
[(2)] .77211 .09354 0 0 Mshowa
[(1)] .90816 .09354 0 0 Mshowa
[(1)] .09184 .77381 0 0 Mshowa
[(3)] .09184 .63776 0 0 Mshowa
[(4)] .09184 .5017 0 0 Mshowa
[(5)] .09184 .36565 0 0 Mshowa
[(0)] .09184 .22959 0 0 Mshowa
[(2)] .09184 .09354 0 0 Mshowa
[(1)] .22789 .90986 0 0 Mshowa
[(3)] .36395 .90986 0 0 Mshowa
[(4)] .5 .90986 0 0 Mshowa
[(5)] .63605 .90986 0 0 Mshowa
[(0)] .77211 .90986 0 0 Mshowa
[(2)] .90816 .90986 0 0 Mshowa
[(TwistedZ[7])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.56001 0.97619 1.04592 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
1 0 0 r
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(1)] .22789 .77381 0 0 Mshowa
[(3)] .36395 .77381 0 0 Mshowa
[(5)] .5 .77381 0 0 Mshowa
[(0)] .63605 .77381 0 0 Mshowa
[(4)] .77211 .77381 0 0 Mshowa
[(2)] .90816 .77381 0 0 Mshowa
[(3)] .22789 .63776 0 0 Mshowa
[(0)] .36395 .63776 0 0 Mshowa
[(4)] .5 .63776 0 0 Mshowa
[(1)] .63605 .63776 0 0 Mshowa
[(2)] .77211 .63776 0 0 Mshowa
[(5)] .90816 .63776 0 0 Mshowa
[(5)] .22789 .5017 0 0 Mshowa
[(4)] .36395 .5017 0 0 Mshowa
[(3)] .5 .5017 0 0 Mshowa
[(2)] .63605 .5017 0 0 Mshowa
[(0)] .77211 .5017 0 0 Mshowa
[(1)] .90816 .5017 0 0 Mshowa
[(0)] .22789 .36565 0 0 Mshowa
[(1)] .36395 .36565 0 0 Mshowa
[(2)] .5 .36565 0 0 Mshowa
[(3)] .63605 .36565 0 0 Mshowa
[(5)] .77211 .36565 0 0 Mshowa
[(4)] .90816 .36565 0 0 Mshowa
[(4)] .22789 .22959 0 0 Mshowa
[(2)] .36395 .22959 0 0 Mshowa
[(0)] .5 .22959 0 0 Mshowa
[(5)] .63605 .22959 0 0 Mshowa
[(1)] .77211 .22959 0 0 Mshowa
[(3)] .90816 .22959 0 0 Mshowa
[(2)] .22789 .09354 0 0 Mshowa
[(5)] .36395 .09354 0 0 Mshowa
[(1)] .5 .09354 0 0 Mshowa
[(4)] .63605 .09354 0 0 Mshowa
[(3)] .77211 .09354 0 0 Mshowa
[(0)] .90816 .09354 0 0 Mshowa
[(3)] .09184 .77381 0 0 Mshowa
[(0)] .09184 .63776 0 0 Mshowa
[(4)] .09184 .5017 0 0 Mshowa
[(1)] .09184 .36565 0 0 Mshowa
[(2)] .09184 .22959 0 0 Mshowa
[(5)] .09184 .09354 0 0 Mshowa
[(3)] .22789 .90986 0 0 Mshowa
[(0)] .36395 .90986 0 0 Mshowa
[(4)] .5 .90986 0 0 Mshowa
[(1)] .63605 .90986 0 0 Mshowa
[(2)] .77211 .90986 0 0 Mshowa
[(5)] .90816 .90986 0 0 Mshowa
[(TwistedZ[7])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@0000T0M?lA07Go2@0000T000?o0000
3002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o0000
3@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003
o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol000070000
2@000ol0000<00;o40000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T000?o00003002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L000090003o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000700002@000ol0000300?o1P02o`H00ol70003o`0000<00ol70003o`0000D00ol60003
o`0000<00ol70003o`0000@01?l60003o`0000@00_l70003o`0000l000?o00001003o`H00_l500?o
1`000ol0000400?o1`000ol0000400?o1P000ol0000400Co1P000ol0000300?o1`000ol0000500;o
1`000ol0000700002@000ol000060003o`0000<00_l90003o`0000@000?o000010000ol000060003
o`0000H000?o00001@000ol000060003o`0000@000?o00001@000ol000060003o`0000<000Co003o
1P000ol0000?0003o`0000L000?o00000`02o`P000?o000010000ol000070003o`0000@000?o0000
1@000ol000050003o`0000D000?o00001P000ol000040003o`0000H000?o000010001?l00?l60003
o`0000L000090003o`0000H000?o00000`02o`T000?o000010000ol000040003o`0000H000?o0000
1004o`H000?o00001P000ol000040003o`0000H000?o00001@000ol000030004o`00o`H000?o0000
3`000ol000070003o`0000<00_l80003o`0000@000?o00001`000ol000040003o`0000<01?l60003
o`0000H000?o00001@000ol000040003o`0000H000?o000010001?l00?l60003o`0000L000090003
o`0000<00ol600;o1P03o`L000?o000010000ol000060003o`0000@000?o0?l01`000ol0000400;o
1`000ol000070003o`0000@000?o00000`001?l00?l60003o`0000l000?o00001003o`H00_l600;o
1`000ol0000400?o1`000ol000030003o`3o00L000?o00001`000ol000040003o`0000@000?o0000
1P000ol000040004o`00o`H000?o00001`0000T000?o00000`000ol0000600;o1P000ol000070003
o`0000@000?o00001P000ol000040003o`3o00L000?o00001P000ol000040003o`0000@000Co003o
1P000ol000030004o`00o`H000?o00003`000ol000040003o`0000H00_l80003o`0000@000?o0000
10000ol000070003o`0000<000?o0?l01`000ol000040004o`00o`H000?o000010000ol000060003
o`0000@000Co003o1P000ol0000700002@000ol0000300Co1@02o`H01?l60003o`0000<00_l80003
o`0000D00_l70003o`0000<00ol70003o`0000D00_l70003o`0000@00_l70003o`0000l000?o0000
1004o`D00_l500?o1`000ol0000400Co1P000ol0000400;o1`000ol0000500;o1`000ol0000300;o
20000ol0000500;o1`000ol0000700002@000ol0000<00;o40000ol0000=0003o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00001`0000T000?o00003002oa0000?o00003@000ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000l000?o00003@02o`l000?o00003P000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000L000090003o`0000`00_l@0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000?0003o`0000d00_l?0003o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ol0000<00;o40000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T0M?lA07Go2@0000T000?o0000
3002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o0000
3@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003
o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol000070000
2@000ol0000<00;o40000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T000?o00003002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L000090003o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000700002@000ol0000300?o1P02o`H00ol70003o`0000<00ol70003o`0000D00_l70003
o`0000@00ol60003o`0000@00ol70003o`0000<01?l60003o`0000l000?o00001@03o`D00_l600;o
1`000ol0000500?o1P000ol0000300Co1P000ol0000400?o1`000ol0000300?o1`000ol0000400?o
1`000ol0000700002@000ol000060003o`0000<00_l90003o`0000@000?o00001P000ol000040003
o`0000@000Co003o1P000ol000050003o`0000D000?o00001@000ol000060003o`0000@000?o0000
1P000ol0000?0003o`0000H000?o00001002o`D000Co003o1P000ol000060003o`0000D000?o0000
10000ol000060003o`0000L000?o000010000ol000060003o`0000@000?o00001@000ol000060003
o`0000L000090003o`0000H000?o00000`02o`T000?o000010000ol000060003o`0000@000?o0000
10001?l00?l60003o`0000<01?l60003o`0000D000?o00001P000ol000050003o`0000D000?o0000
3`000ol0000400Co1@02o`D000Co003o1P000ol0000400Co1P000ol000050003o`0000D000?o0000
1`000ol000040003o`0000H000?o000010000ol000050003o`0000H000?o00001`0000T000?o0000
1002o`H00_l700;o1`000ol0000300?o1`000ol000040004o`00o`H000?o00000`000ol0o`070003
o`0000D000?o00001P000ol000060003o`0000@000?o00003`000ol000040003o`3o00H00_l50004
o`00o`H000?o000010000ol0o`070003o`0000H000?o000010000ol0000400?o1`000ol0000400;o
1`000ol000050003o`0000H000?o00001`0000T000?o00001P000ol0000300;o2@000ol000040003
o`0000<000?o00001`000ol000040004o`00o`H000?o00000`000ol0o`070003o`0000D000?o0000
1P000ol000030004o`00o`H000?o00003`000ol000040003o`3o00H00_l50004o`00o`H000?o0000
10000ol0o`070003o`0000<000Co003o1P000ol000040003o`0000L000?o00001P000ol000040003
o`0000D000?o00001P000ol0000700002@000ol0000300?o1P02o`H00ol70003o`0000<01?l60003
o`0000D00_l70003o`0000@00_l70003o`0000@00_l80003o`0000@00_l70003o`0000l000?o0000
1@02o`H00_l600;o1`000ol0000500;o1`000ol0000400;o1`000ol0000400Co1P000ol0000300?o
1`000ol0000400;o20000ol0000700002@000ol0000<00;o40000ol0000=0003o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00001`0000T000?o00003002oa0000?o00003@000ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000l000?o00003@02o`l000?o00003P000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000L000090003o`0000`00_l@0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000?0003o`0000d00_l?0003o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ol0000<00;o40000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T000?o00003002oa0000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o00003@02o`l000?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L0000907Co4@1eo`T000090003
o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol000070000
2@000ol0000<00;o40000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T000?o00003002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L000090003o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000700002@000ol0000<00;o40000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000h000?o00001`0000T000?o00000`04o`D00_l600Co1P000ol0000400;o1`000ol0000400?o
1`000ol0000300?o1`000ol0000500?o1P000ol0000300?o1`000ol0000?0003o`0000@00ol600;o
1P03o`H000?o00001003o`L000?o00001002o`L000?o00001003o`L000?o00000`03o`L000?o0000
1004o`H000?o00001`0000T000?o000010000ol0000500;o1`000ol000060003o`0000<000Co003o
1P000ol000070003o`0000@000?o000010000ol000060003o`0000H000?o00001@000ol000060003
o`0000@000?o00003`000ol000070003o`0000<00_l70003o`0000D000?o00001`000ol000040003
o`0000<000Co003o1P000ol000050003o`0000H000?o00001P000ol000040003o`0000D000?o0000
1P000ol0000700002@000ol000050003o`0000@00_l80003o`0000D000?o00000`001?l00?l60003
o`0000L000?o000010000ol000040003o`0000H000?o00001004o`H000?o00001P000ol000040003
o`0000l000?o00001`000ol0000300;o1@04o`H000?o00001`000ol000040003o`0000<000Co003o
1P000ol000050003o`0000H000?o00001P000ol000040003o`0000H000?o00001@000ol000070000
2@000ol000060003o`0000<00_l90003o`0000@000?o00000`001?l00?l60003o`0000@00ol70003
o`0000@000?o00001P000ol000040003o`3o00L000?o00001002o`L000?o00003`000ol0000500;o
1P02o`D000?o0?l01`000ol0000500;o1`000ol000030004o`00o`H000?o00001@000ol000060003
o`0000<00ol70003o`0000L000?o000010000ol0000700002@000ol000030004o`00o`D00_l60004
o`00o`H000?o00000`001?l00?l60003o`0000@000?o00001`000ol000040003o`0000H000?o0000
10000ol0o`070003o`0000H000?o000010000ol0000?0003o`0000L000?o00000`02o`D000?o0?l0
1`000ol000070003o`0000@000?o00000`001?l00?l60003o`0000D000?o00001P000ol000030003
o`0000L000?o000010001?l00?l60003o`0000L000090003o`0000@00_l600;o1`02o`L000?o0000
1002o`L000?o00001004o`H000?o00000`02o`P000?o00001@02o`L000?o00000`03o`L000?o0000
3`000ol0000400?o1P02o`H00_l70003o`0000@00ol70003o`0000@00_l70003o`0000@00_l80003
o`0000<01?l60003o`0000D00_l70003o`0000L000090003o`0000`00_l@0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000?0003o`0000d00_l?0003o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ol0000<00;o40000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T000?o00003002oa0000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o00003@02o`l000?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003o`0000`00_l@0003
o`0000d000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003o`0000d00_l?0003
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@1doa40MOl90000
2@000ol0000<00;o40000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T000?o00003002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L000090003o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000700002@000ol0000<00;o40000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000h000?o00001`0000T000?o00003002oa0000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000>0003o`0000L000090003o`0000<00ol600;o1P03o`L000?o00000`04o`H000?o0000
1003o`L000?o00000`03o`L000?o00001@02o`L000?o00001003o`H000?o00003`000ol0000400?o
1P02o`D00ol70003o`0000@00ol70003o`0000<00ol70003o`0000D00_l70003o`0000<01?l60003
o`0000D00ol60003o`0000L000090003o`0000@000?o00001@02o`L000?o00001P000ol000040003
o`0000H000?o00001`000ol000040003o`0000H000?o000010000ol000040004o`00o`H000?o0000
1@000ol000050003o`0000l000?o00001@000ol0000500;o20000ol000040003o`0000D000?o0000
1P000ol000060003o`0000@000?o000010001?l00?l60003o`0000@000?o00001P000ol000060003
o`0000D000?o00001`0000T000?o000010000ol0000500;o1`000ol000060003o`0000D000?o0000
1@000ol000070003o`0000@000?o00001P000ol000040003o`0000@000Co003o1P000ol0000300Co
1P000ol0000?0003o`0000D000?o00001@02o`P000?o000010000ol000050003o`0000H000?o0000
1P000ol000040003o`0000@000Co003o1P000ol000050003o`0000D000?o00001004o`H000?o0000
1`0000T000?o000010000ol0000500;o1`000ol000060003o`0000H000?o000010000ol0000500;o
1`000ol0000300?o1`000ol000040004o`00o`H000?o00000`000ol0o`070003o`0000l000?o0000
1@000ol0000500;o1@03o`L000?o00001@000ol000060003o`0000@00_l70003o`0000@000Co003o
1P000ol000060003o`0000@000?o000010000ol0o`070003o`0000L000090003o`0000@000?o0000
1@02o`L000?o00001P000ol000030004o`00o`H000?o00001`000ol000040003o`0000<000?o0000
1`000ol000040004o`00o`H000?o00000`000ol0o`070003o`0000l000?o00001@000ol0000500;o
1@000ol000070003o`0000D000?o00001P000ol000060003o`0000@000?o000010001?l00?l60003
o`0000<000Co003o1P000ol000040003o`3o00L000?o00001`0000T000?o00000`02o`L00_l600;o
20000ol0000400;o1`000ol0000400?o1`000ol0000300Co1P000ol0000500;o1`000ol0000400;o
1`000ol0000?0003o`0000@00_l700;o1@04o`H000?o00001002o`P000?o00000`03o`L000?o0000
1@02o`L000?o00001002o`L000?o00001@02o`L000?o00001`0000T000?o00003002oa0000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o00003@02o`l000?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003o`0000`00_l@0003
o`0000d000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003o`0000d00_l?0003
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ol0000<00;o
40000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003`000ol0000=00;o
3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T000?o0000
3002oa0000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o0000
3@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003
o`0000`00_l@0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol000070000
2@1doa40MOl900002@000ooOg`0<g`;o4=l00olS8`0=8`03o`0000h000?o00003@000ol0000>0003
o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000h000?o00001`0000T000?ogml03=l2oa3O00?o8b<03B<00ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03ob<S00dS00?o00003P000ol0000=0003
o`0000h000?o00003@000ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003
o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00olS8`0=8`03o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O00?o8b<03B<00ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000l000?o00003@02o`l000?o00003P000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000L000090003omoO00CO0ol5g`;o1ml3o`KO00?o8b<0
0b<3o`LS00?o00001004o`H000?o00001002o`L000?o00001003o`L000?o00000`03o`L000?o0000
3`000ol0000500;o1P02o`D01?l60003o`0000D00_l70003o`0000<00ol70003o`0000@00ol70003
o`0000@00ol60003o`0000@00ol70003o`0000L000090003omoO00GO00?ogml01=l2o`SO00?ogml0
1Ml00olS8`068`03ob<S00@S00?o00001@000ol000060003o`0000<000Co003o1P000ol000070003
o`0000@000?o000010000ol000060003o`0000l000?o000010001?l00?l500;o1P000ol000060003
o`0000@000Co003o1P000ol000040003o`0000H000?o00001`000ol000040003o`0000D000?o0000
1@000ol000070003o`0000@000?o00001`0000T000?ogml00ml4o`GO0_l6g`Co1]l00olS8`068`03
ob<S00@S00?o00001P000ol000050003o`0000<000Co003o1P000ol000070003o`0000@000?o0000
10000ol000060003o`0000l000?o000010001?l00?l500;o1`000ol000050003o`0000@000Co003o
1P000ol000040003o`0000H000?o00001`000ol000040003o`0000<01?l60003o`0000L000?o0000
10000ol0000700002@000ooOg`03g`03omoo00KO0_l6g`03omoo00OO00?o8b<012<2o`LS00?o0000
1`000ol000040003o`0000<000Co003o1P000ol0000400?o1`000ol000040003o`0000H000?o0000
3`000ol000040004o`00o`D00_l80003o`0000@000?o000010001?l00?l60003o`0000@000?o0000
1P000ol0000500;o1`000ol000030003o`3o00L000?o00001003o`L000?o00001`0000T000?ogml0
0ml00ooOo`06g`;o1]l00ooOo`07g`03ob<S00HS00?o8b<012<00ol000040004o`00o`H000?o0000
0`001?l00?l60003o`0000@000?o00001`000ol000040003o`0000H000?o00003`000ol000040004
o`00o`D00_l50004o`00o`H000?o000010001?l00?l60003o`0000@000?o00001P000ol000070003
o`0000@000?o00000`000ol0o`070003o`0000@000?o00001`000ol0000700002@000ooOg`04g`;o
1]l2o`OO0_l7g`03ob<S00<S0ol78`03o`0000D00_l70003o`0000@00_l70003o`0000@01?l60003
o`0000<00_l80003o`0000l000?o00001@02o`H00_l600;o1`000ol0000500;o1`000ol0000300;o
20000ol0000400?o1`000ol0000400;o1`000ol0000400Co1P000ol0000700002@000ooOg`0<g`;o
4=l00olS8`0=8`03o`0000h000?o00003@000ol0000>0003o`0000d000?o00003`000ol0000=00;o
3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T000?ogml0
3=l2oa3O00?o8b<03B<00ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o0000
3@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003
omoO00cO0_l@g`03ob<S00dS00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol000070000
2@000ooOg`0<g`;o4=l00olS8`0=8`03o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T0M?lA07Go2@0000T000?ogml03=l2oa3O00?ogml03Ml00ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000l000?ogml03Ml2o`lS00?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?o00003P000ol0000=0003
o`0000h000?o00003@000ol0000?0003omoO00gO0_l?8`03o`0000h000?o00003@000ol0000>0003
o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003`000ooOg`0=g`;o3b<00ol0000>0003o`0000d000?o0000
3P000ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ol0000>0003
o`0000d000?o00003P000ol0000=0003o`0000l000?ogml03Ml2o`lS00?o00003P000ol0000=0003
o`0000h000?o00003@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?o0000
3P000ol0000=0003o`0000h000?o00003@000ol0000?0003omoO00gO0_l?8`03o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ooOg`04g`;o1]l2o`OO0_l7g`03
omoO00CO0ol6g`03o`0000@00ol70003o`0000<01?l60003o`0000@00ol70003o`0000<00ol70003
o`0000l000?ogml01=l4o`GO0_l58`?o1b<00ol0000400Co1P000ol0000300?o1`000ol0000500?o
1P000ol0000400;o1`000ol0000400?o1`000ol0000700002@000ooOg`03g`04omoOo`GO0_l6g`04
omoOo`KO00?ogml01Ml00ooOg`05g`03o`0000D000?o00001P000ol000040003o`0000H000?o0000
1`000ol000040003o`0000H000?o000010000ol0000?0003omoO00GO00?ogml01Ml2o`HS00?o8b<0
1R<00ol000050003o`0000H000?o00001P000ol000040003o`0000H000?o00001@000ol000030004
o`00o`H000?o00001`000ol000040003o`0000L000090003omoO00?O00Cogmoo1Ml2o`KO00Cogmoo
1]l00ooOg`03g`Co1]l00ol000050003o`0000H000?o00001@000ol000050003o`0000L000?o0000
10000ol000060003o`0000@000?o00003`000ooOg`06g`03omoO00CO0_l68`03ob<S00HS00?o0000
1P000ol000050003o`0000H000?o000010000ol0000400Co1P000ol000030004o`00o`H000?o0000
1`000ol000040003o`0000L000090003omoO00?O00Cogmoo1Ml2o`KO00Cogmoo1]l00ooOg`03g`03
omoo00OO00?o00001@000ol000060003o`0000H000?o000010000ol0000500;o1`000ol0000300?o
1`000ol0000?0003omoO00OO00?ogml00ml2o`HS00?o8b<01R<00ol000070003o`0000@000?o0000
0`03o`L000?o000010000ol0o`070003o`0000<000Co003o1P000ol0000500;o1`000ol000070000
2@000ooOg`03g`04omoOo`GO0_l6g`04omoOo`KO00?ogml00ml00ooOo`07g`03o`0000D000?o0000
1P000ol000030004o`00o`H000?o00001`000ol000040003o`0000<000?o00001`000ol0000?0003
omoO00CO00Cogmoo1Ml2o`HS00?o8b<01R<00ol000040004o`00o`H000?o00000`000ol000070003
o`0000@000?o0?l01`000ol000030004o`00o`H000?o00001`000ol000040003o`0000L000090003
omoO00CO0_l6g`;o1ml2o`OO00?ogml01=l2o`OO00?o00001002o`P000?o00001002o`L000?o0000
1003o`L000?o00000`04o`H000?o00003`000ooOg`05g`;o1]l2o`DS0_l88`03o`0000D00_l70003
o`0000<01?l60003o`0000D00_l70003o`0000@00_l70003o`0000@00ol70003o`0000L000090003
omoO00cO0_l@g`03omoO00gO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
omoO00gO0_l?8`03o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol000070000
2@000ooOg`0<g`;o4=l00ooOg`0=g`03o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3`000ooOg`0=g`;o3b<00ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T000?ogml03=l2oa3O00?ogml03Ml00ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000l000?ogml03Ml2o`lS00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L000090003omoO00cO0_l@g`03omoO00gO00?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?0003omoO00gO0_l?8`03o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03o`0000h000?o00003@000ol0000>0003
o`0000d000?o00003`000ooOg`0=g`;o3b<00ol0000>0003o`0000d000?o00003P000ol0000=0003
o`0000h000?o00001`0000P0MOl@07Ko2@0000P0MOl@07Ko2@0000T000?o00002`03oa3O00?ogml0
3Ml00ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000l000?o00002`001?l0ool?g`03
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@001Ol0ool000;o
1P001?l0ool@g`03omoO00gO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003
o`0000;o00<0ool01@000ol00002o`oO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0
000>0003o`0000L000090006o`00o`3o1P000ol00002oa3O00?ogml03Ml00ol0000>0003o`0000d0
00?o00003P000ol0000=0003o`0000l000Oo0000o`3o00D000Co00000_l?g`03o`0000h000?o0000
3@000ol0000>0003o`0000d000?o00003P000ol0000700002@001Ol0003o00H000Co00000_l@g`03
omoO00gO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0003o`00008000?o0000
0`000ol0000200;o3ml00ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o0000
1`0000T000Ko003o0?l40003o`0000800_l7g`;o1ml00ooOg`04g`?o1]l00ol0000400?o1`000ol0
000300Co1P000ol0000400?o1`000ol0000300?o1`000ol0000?0007o`000?l0o`030003o`0000<0
0_l5g`Co1]l00ol0000500;o1`000ol0000300?o1`000ol0000400?o1`000ol0000400?o1P000ol0
000400?o1`000ol0000700002@001Ol0ool000;o0P03o`<00_l6g`04omoOo`KO00?ogml01Ml00ooO
g`05g`03o`0000D000?o00001P000ol000040003o`0000H000?o00001`000ol000040003o`0000H0
00?o000010000ol0000?0003o`0000;o00@0ool01?l300;o1]l00ooOg`06g`03o`0000@000Co003o
1P000ol000040003o`0000H000?o00001`000ol000040003o`0000D000?o00001@000ol000070003
o`0000@000?o00001`0000T000?o00001@000ol0o`0400;o1]l01?oOgol6g`03omoO00?O1?l6g`03
o`0000D000?o00001P000ol000050003o`0000D000?o00001`000ol000040003o`0000H000?o0000
10000ol0000?0003o`0000D000Co003o1002o`OO00?ogml01Ml00ol000040004o`00o`H000?o0000
10000ol000060003o`0000L000?o000010000ol0000300Co1P000ol000070003o`0000@000?o0000
1`0000T000?o000010001Ol0003o00<00_l6g`04omoOo`KO00?ogml00ml00ooOo`07g`03o`0000D0
00?o00001P000ol000060003o`0000@000?o00001@02o`L000?o00000`03o`L000?o00003`000ol0
00040003o`00008000Co00000_l8g`03omoO00CO00?o000010001?l00?l60003o`0000@000?o0000
1P000ol0000500;o1`000ol000030003o`3o00L000?o00001003o`L000?o00001`0000T000?o0000
0`000ol000020004o`0000;o1]l01?oOgol6g`03omoO00?O00?ogol01ml00ol000050003o`0000H0
00?o00000`001?l00?l60003o`0000L000?o000010000ol000030003o`0000L000?o00003`000ol0
00030003o`0000<000Co00000_l5g`04omoOo`KO00?o000010001?l00?l60003o`0000@000?o0000
1P000ol000070003o`0000@000?o00000`000ol0o`070003o`0000@000?o00001`000ol000070000
2@000ol000020003o`00008000?o0?l00P02o`OO0_l7g`03omoO00CO0_l7g`03o`0000@00_l80003
o`0000@00_l70003o`0000@00ol70003o`0000<01?l60003o`0000l000?o00000P000ol000030003
o`3o00800_l6g`;o1ml00ol0000500;o1`000ol0000300;o20000ol0000400?o1`000ol0000400;o
1`000ol0000400Co1P000ol0000700002@001Ol0003o00D000?o0?l00P02oa3O00?ogml03Ml00ol0
000>0003o`0000d000?o00003P000ol0000=0003o`0000l000Go0000o`060003o`3o00800_l?g`03
o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@001?l00?l500;o
00@0ool00_l@g`03omoO00gO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000?0004
o`00o`H00_l0103oo`02o`oO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L000090003o`3o00`00_l@g`03omoO00gO00?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?0003o`3o00d00_l?g`03o`0000h000?o00003@000ol0000>0003o`0000d000?o0000
3P000ol0000700002@02o`d00_l@g`03omoO00gO00?o00003P000ol0000=0003o`0000h000?o0000
3@000ol0000?00;o3P02o`oO00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003
o`0000L0000907Co4@1eo`T0000H00;oQ002of`0003o00d0003o00d0000k00;o2P02ob/00om900;o
2P02ob`00ol?0000>`000ol0000:0003o`0002X000?o0000B0000ol0000:0003o`0002/000?o0000
3P0000/00ol20004o`00o`801Ol00`3oo`02o`<00ol300Co0P09o`<000?o00000`000ol000040003
o`0001400_l00`3oo`090003o`3o00T000?o00005`03o`8000Co003o0P05o`030?oo00;o0`03o`<0
1?l200Wo0`000ol000030003o`0000@000?o00004P02o`030?oo00T000?o0?l02@000ol0000=0000
30001?l00004o`@000?o000010001Ol0003o008000?o0?l01@001Ol0003o008000?o0?l00`000ol0
00030003o`0000@000?o00004P000ol0o`0;0003o`0000P000?o000060001?l00004o`@000?o0000
10001Ol0003o008000?o0?l01@001Ol0003o008000?o0?l00`000ol000030003o`0000@000?o0000
4`000ol0o`0;0003o`0000P000?o00003@0000`000Co00001?l40004o`0000Co0`000ol0000200Go
00<0o`000P001?l00?l50003o`0000@000?o00000`000ol0000C0003o`0000P01Ol70003o`3o01T0
00Co00001?l40004o`0000Co0`000ol0000200Go00<0o`000P001?l00?l50003o`0000@000?o0000
0`000ol0000D0003o`0000P01Ol70003o`3o00h0000:0007o`3o0?l0o`020003o`00008000Go0000
o`060003o`00008000Oo0000o`3o00<000Go0000o`040003o`0000@000?o00000`000ol0000B0003
o`3o00/000?o00001`000ol0o`0G0007o`3o0?l0o`020003o`00008000Go0000o`060003o`000080
00Oo0000o`3o00<000Go0000o`040003o`0000@000?o00000`000ol0000C0003o`3o00/000?o0000
1`000ol0o`0>00002P001?l0o`03o`800_l200;o0`04o`801?l300?o0`04o`040?l0o`@000?o0000
1@000ol000020003o`0001400_l00`3oo`0C00;o00<0ool05P001?l0o`03o`800_l200;o0`04o`80
1?l300?o0`04o`040?l0o`@000?o00001@000ol000020003o`0001800_l00`3oo`0C00;o00<0ool0
3@0000X01OlD0003o`0000`000?o0?l00ol300;o0`04o`<00_m600Go50000ol0000<0003o`3o00?o
0`02o`<01?l300;o?P0001P000?o000020000ol0000;00;oJP000ol000080003o`0000/00_mD0000
o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000o`0=0000
o`0=0000o`0=0000o`0=0000o`0=0000o`0=00002@1doa40MOl900002@000ooOg`0<g`;o4=l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0000=00;o3`000ol0
000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?o00003@02o`l0
00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003omoO00cO
0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003o`0000d0
0_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ooO
g`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0
000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T0
00?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l0
00?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L0
00090003omoO00?O1?l5g`;o1]l3o`OO00?ogml01=l3o`KO00?ogml01Ml2o`OO00?ogml00ml3o`OO
00?ogml01=l4o`KO00?ogml00ml3o`OO00?o00003`000ol0000400?o1P02o`D01?l60003o`0000@0
0ol70003o`0000<00ol70003o`0000D00ol60003o`0000<00ol70003o`0000D00_l70003o`0000L0
00090003omoO00CO00?ogml01Ml2o`WO00?ogml01=l00ooOg`05g`03omoO00GO00?ogml01=l01?oO
gol6g`03omoO00KO00?ogml01=l00ooOg`05g`03omoO00KO00?ogml01=l00ooOg`06g`03o`0000l0
00?o00001`000ol0000300;o1P000ol000060003o`0000L000?o000010000ol000040003o`0000H0
00?o00001P000ol000050003o`0000H000?o000010000ol000040004o`00o`H000?o00001`0000T0
00?ogml01Ml00ooOg`04g`;o2Ml00ooOg`04g`03omoO00?O1?l6g`03omoO00CO00Cogmoo1]l00ooO
g`06g`03omoO00CO00?ogml01]l00ooOg`05g`03omoO00CO00?ogml01]l00ol0000?0003o`0000L0
00?o00000`02o`L000?o00001@000ol000070003o`0000@000?o000010000ol000060003o`0000@0
1?l60003o`0000H000?o000010000ol000040004o`00o`H000?o00001`0000T000?ogml01]l00ooO
g`03g`;o1]l3o`OO00?ogml00ml00ooOo`07g`03omoO00CO00Cogmoo1]l00ooOg`04g`;o1ml00ooO
g`07g`03omoO00CO00?ogml01=l00ooOg`06g`03o`0000l000?o00001003o`H00_l80003o`0000@0
00?o00001003o`L000?o000010000ol000060003o`0000@000?o0?l01`000ol0000400;o1`000ol0
00040004o`00o`H000?o00001`0000T000?ogml00ml01?oOgol5g`;o1]l00ooOg`07g`03omoO00?O
00?ogol01ml00ooOg`04g`04omoOo`KO00?ogml01]l00ooOg`04g`03omoO00CO00Cogmoo1]l00ooO
g`04g`03omoO00KO00?o00003`000ol000040003o`0000H00_l50004o`00o`H000?o000010000ol0
00070003o`0000@000?o00001P000ol000040003o`3o00L000?o00001P000ol000040003o`0000@0
00Co003o1P000ol0000700002@000ooOg`04g`;o1]l2o`KO1?l6g`03omoO00CO0_l7g`03omoO00GO
0_l7g`03omoO00?O0ol7g`03omoO00GO0_l7g`03omoO00?O0_l8g`03o`0000l000?o00001004o`D0
0_l600;o1`000ol0000400Co1P000ol0000300;o20000ol0000500;o1`000ol0000300?o1`000ol0
000500;o1`000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooO
g`0>g`03omoO00gO00?o00003`000ol0000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0
000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO
00?ogml03]l00ooOg`0=g`03o`0000l000?o00003@02o`l000?o00003P000ol0000=0003o`0000h0
00?o00003@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0
000>0003o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0000=00;o3`000ol0000>0003o`0000d0
00?o00003P000ol0000=0003o`0000h000?o00001`0000T0M?lA07Go2@0000T000?ogml03=l2oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?o00003@02o`l0
00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003omoO00cO
0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003o`0000d0
0_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ooO
g`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0
000=00;o3`000ol0000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T0
00?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l0
00?o00003@02o`l000?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000L0
00090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0
000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0
000700002@000ooOg`04g`;o1]l2o`KO0ol7g`03omoO00?O0ol7g`03omoO00GO0ol6g`03omoO00?O
0ol7g`03omoO00GO0_l7g`03omoO00?O1?l6g`03o`0000l000?o00001004o`D00_l600?o1P000ol0
000400Co1P000ol0000400;o1`000ol0000400?o1`000ol0000300?o1`000ol0000400?o1`000ol0
000700002@000ooOg`03g`04omoOo`GO0_l7g`03omoO00KO00?ogml01]l00ooOg`04g`03omoO00KO
00?ogml01Ml00ooOg`06g`03omoO00CO00?ogml01=l01?oOgol6g`03omoO00CO00?ogml01]l00ol0
000?0003o`0000D000?o00001@02o`L000?o00001@000ol000050003o`0000H000?o00000`001?l0
0?l60003o`0000L000?o000010000ol000040003o`0000H000?o00001`000ol000040003o`0000L0
00090003omoO00?O00Cogmoo1Ml2o`OO00?ogml01]l00ooOg`06g`03omoO00CO00?ogml01=l4o`KO
00?ogml01]l00ooOg`04g`03omoO00CO00Cogmoo1]l00ooOg`05g`03omoO00GO00?o00003`000ol0
00060003o`0000@00_l500Co1P000ol000060003o`0000D000?o00000`001?l00?l60003o`0000L0
00?o000010000ol000040003o`0000H000?o00001`000ol000040003o`0000L000090003omoO00?O
00Cogmoo1Ml2o`OO00?ogml01]l00ooOg`04g`;o1ml00ooOg`04g`03omoo00OO00?ogml00ml3o`OO
00?ogml01=l01?oOgol6g`03omoO00KO00?ogml01=l00ol0000?0003o`0000L000?o00000`02o`D0
00?o0?l01`000ol000070003o`0000@000?o00000`001?l00?l60003o`0000@00ol70003o`0000@0
00?o00001P000ol0000500;o1`000ol0000700002@000ooOg`03g`04omoOo`GO0_l7g`03omoO00KO
00?ogml01]l00ooOg`04g`03omoO00CO00?ogol01ml00ooOg`03g`03omoO00OO00?ogml01=l01?oO
gol6g`03omoO00?O00Cogmoo1]l00ol0000?0003o`0000@000Co003o1@02o`D000?o0?l01`000ol0
00040004o`00o`H000?o00000`001?l00?l60003o`0000@000?o00001`000ol000040003o`0000H0
00?o00001`000ol000040003o`0000L000090003omoO00CO0_l6g`;o1]l2o`SO00?ogml00ml3o`OO
00?ogml01Ml2o`OO00?ogml00ml4o`KO00?ogml01Ml2o`OO00?ogml01=l2o`OO00?o00003`000ol0
000500;o1P02o`H00_l70003o`0000D00_l70003o`0000@00_l70003o`0000@01?l60003o`0000<0
0_l80003o`0000@00ol70003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ol0000?0003o`0000d00_l?0003o`0000h000?o00003@000ol0
000>0003o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0000=00;o3`000ol0000>0003o`0000d0
00?o00003P000ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooO
g`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?o00003@02o`l000?o00003P000ol0
000=0003o`0000h000?o00003@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO
00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003o`0000d00_l?0003o`0000h0
00?o00003@000ol0000>0003o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0000=00;o3`000ol0
000>0003o`0000d000?o00003P000ol0000=0003o`0000h000?o00001`0000T0M?lA07Go2@0000T0
00?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l0
00?ogml03Ml2o`oO00?ogml03]l00olS8`0=8`03omoO00kO00?o00003@000ol0000>0003o`0000L0
00090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0
000?0003omoO00gO0_l?g`03omoO00kO00?o8b<03B<00ooOg`0>g`03o`0000d000?o00003P000ol0
000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO
00?o00003`000ooOg`0=g`;o3ml00ooOg`0>g`03ob<S00dS00?ogml03]l00ol0000=0003o`0000h0
00?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooO
g`0=g`03o`0000l000?ogml03Ml2o`oO00?ogml03]l00olS8`0=8`03omoO00kO00?o00003@000ol0
000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ol0000?0003omoO00gO0_l?g`03omoO00kO00?o8b<03B<00ooOg`0>g`03o`0000d0
00?o00003P000ol0000700002@000ooOg`03g`?o1]l2o`OO0ol6g`03omoO00?O1?l6g`03omoO00CO
0ol7g`03omoO00CO0_l7g`03omoO00CO0ol7g`03omoO00?O0ol7g`03o`0000l000?ogml01=l3o`KO
0_l6g`;o1ml00ooOg`04g`?o1ml00olS8`038`Co1R<00ooOg`04g`?o1ml00ol0000300?o1`000ol0
000500?o1P000ol0000700002@000ooOg`06g`03omoO00?O0_l8g`03omoO00GO00?ogml01=l00ooO
g`06g`03omoO00GO00?ogml01]l00ooOg`03g`04omoOo`KO00?ogml01ml00ooOg`04g`03omoO00KO
00?ogml01=l00ol0000?0003omoO00GO00?ogml01Ml2o`GO00Cogmoo1]l00ooOg`05g`03omoO00KO
00?o8b<012<00olS8`068`03omoO00OO00?ogml01=l00ol000060003o`0000@000?o00001P000ol0
00050003o`0000L000090003omoO00KO00?ogml00ml2o`KO1?l6g`03omoO00GO00?ogml01Ml00ooO
g`05g`03omoO00KO00?ogml00ml01?oOgol6g`03omoO00OO00?ogml01=l00ooOg`06g`03omoO00CO
00?o00003`000ooOg`05g`03omoO00GO0_l5g`04omoOo`KO00?ogml01Ml00ooOg`06g`03ob<S00DS
00?o8b<01B<00ooOg`07g`03omoO00CO00?o00001P000ol000040003o`0000@01?l60003o`0000L0
00090003omoO00?O0ol6g`;o1]l00ooOo`07g`03omoO00KO00?ogml01=l00ooOg`05g`03omoO00KO
00?ogml00ml01?oOgol6g`03omoO00CO0ol7g`03omoO00CO0_l7g`03o`0000l000?ogml01Ml00ooO
g`05g`;o1Ml01?oOgol6g`03omoO00GO00?ogml01]l00olS8`068`03ob<S00@S00?ogml01Ml2o`OO
00?o00000`03o`L000?o000010000ol0o`070003o`0000L000090003omoO00?O00?ogml01]l2o`KO
00?ogol01ml00ooOg`03g`04omoOo`KO00?ogml01Ml00ooOg`06g`03omoO00?O00Cogmoo1]l00ooO
g`04g`03omoO00OO00?ogml01]l00ooOg`04g`03o`0000l000?ogml01Ml00ooOg`05g`;o1Ml01?oO
gol6g`03omoO00GO00?ogml01]l00olS8`038`04ob<So`HS00?ogml01ml00ooOg`04g`03o`0000<0
00?o00001`000ol000040003o`3o00L000?o00001`0000T000?ogml00ml4o`GO0_l7g`;o1ml00ooO
g`04g`;o1ml00ooOg`04g`;o2=l00ooOg`04g`;o1ml00ooOg`04g`Co1]l00ooOg`03g`?o1ml00ol0
000?0003omoO00CO0_l7g`;o1]l2o`OO00?ogml01=l2o`SO00?o8b<012<2o`LS00?ogml01=l3o`OO
00?o00000`04o`H000?o00001@02o`L000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooO
g`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`oO00?ogml03]l00olS
8`0=8`03omoO00kO00?o00003@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO
00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003omoO00gO0_l?g`03omoO00kO
00?o8b<03B<00ooOg`0>g`03o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ooOg`0=g`;o3ml00ooO
g`0>g`03ob<S00dS00?ogml03]l00ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`oO
00?ogml03]l00olS8`0=8`03omoO00kO00?o00003@000ol0000>0003o`0000L0000907Co4@1eo`T0
00090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0
000?0003omoO00gO0_l?8`03omoO00kO00?ogml03Ml00olS8`0>8`03o`0000d000?o00003P000ol0
000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO
00?o00003`000ooOg`0=g`;o3b<00ooOg`0>g`03omoO00gO00?o8b<03R<00ol0000=0003o`0000h0
00?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooO
g`0=g`03o`0000l000?ogml03Ml2o`lS00?ogml03]l00ooOg`0=g`03ob<S00hS00?o00003@000ol0
000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ol0000?0003omoO00gO0_l?8`03omoO00kO00?ogml03Ml00olS8`0>8`03o`0000d0
00?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooO
g`0>g`03omoO00gO00?o00003`000ooOg`0=g`;o3b<00ooOg`0>g`03omoO00gO00?o8b<03R<00ol0
000=0003o`0000h000?o00001`0000T000?ogml01=l3o`GO0_l6g`Co1]l00ooOg`03g`?o1ml00ooO
g`04g`?o1ml00ooOg`03g`?o1ml00ooOg`05g`?o1]l00ooOg`04g`;o1ml00ol0000?0003omoO00GO
0ol5g`;o1B<3o`LS00?ogml01Ml3o`KO00?ogml00ml3o`OO00?o8b<012<4o`HS00?o00001002o`L0
00?o00001003o`L000?o00001`0000T000?ogml01Ml00ooOg`04g`;o1ml00ooOg`06g`03omoO00KO
00?ogml01=l00ooOg`07g`03omoO00CO00?ogml01=l00ooOg`06g`03omoO00KO00?ogml01Ml00ooO
g`03g`04omoOo`KO00?o00003`000ooOg`06g`03omoO00CO0_l88`03ob<S00@S00?ogml01]l00ooO
g`05g`03omoO00KO00?ogml01=l00olS8`058`03ob<S00HS00?o00000`001?l00?l60003o`0000D0
00?o00001P000ol0000700002@000ooOg`03g`Co1Ml2o`SO00?ogml01Ml00ooOg`06g`03omoO00CO
00?ogml01ml00ooOg`04g`03omoO00CO00?ogml01]l00ooOg`04g`Co1]l00ooOg`03g`04omoOo`KO
00?o00003`000ooOg`04g`Co1Ml2o`PS00?o8b<012<00ooOg`04g`Co1]l00ooOg`06g`03omoO00CO
00?o8b<01R<00olS8`058`03o`0000<000Co003o1P000ol000050003o`0000H000?o00001`0000T0
00?ogml00ml00ooOo`06g`;o2Ml00ooOg`04g`03omoO00?O0ol7g`03omoO00GO0_l7g`03omoO00CO
00?ogml01]l00ooOg`04g`03omoo00OO00?ogml00ml01?oOgol6g`03o`0000l000?ogml01=l00ooO
o`06g`;o1B<3o`LS00?ogml01=l00ooOo`07g`03omoO00CO0_l7g`03ob<S00LS00?o8b<012<00ol0
00030004o`00o`H000?o00001@000ol000060003o`0000L000090003omoO00?O00?ogol01]l2o`KO
00Cogmoo1]l00ooOg`03g`03omoO00OO00?ogml01ml00ooOg`04g`03omoO00CO00?ogml01]l00ooO
g`04g`03omoo00OO00?ogml00ml01?oOgol6g`03o`0000l000?ogml01=l00ooOo`06g`;o1B<00olS
8`078`03omoO00CO00?ogol01ml00ooOg`06g`03omoO00CO00?o8b<012<01?lS8ol68`03o`0000<0
00Co003o1P000ol000050003o`0000H000?o00001`0000T000?ogml01=l2o`KO0_l7g`;o1ml00ooO
g`03g`Co1]l00ooOg`04g`?o1ml00ooOg`03g`;o2=l00ooOg`05g`;o1ml00ooOg`04g`;o1ml00ol0
000?0003omoO00GO0_l6g`;o1B<4o`HS00?ogml01Ml2o`OO00?ogml00ml3o`OO00?o8b<01B<2o`LS
00?o00001002o`L000?o00001002o`P000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooO
g`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`lS00?ogml03]l00ooO
g`0=g`03ob<S00hS00?o00003@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO
00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003omoO00gO0_l?8`03omoO00kO
00?ogml03Ml00olS8`0>8`03o`0000d000?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ooOg`0=g`;o3b<00ooO
g`0>g`03omoO00gO00?o8b<03R<00ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`lS
00?ogml03]l00ooOg`0=g`03ob<S00hS00?o00003@000ol0000>0003o`0000L000090003omoO00cO
0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003omoO00gO
0_l?8`03omoO00kO00?ogml03Ml00olS8`0>8`03o`0000d000?o00003P000ol0000700002@1doa40
MOl900002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO
00?o00003`000ooOg`0=g`;o3ml00ooOg`0>g`03omoO00gO00?ogml03]l00ol0000=0003o`0000h0
00?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooO
g`0=g`03o`0000l000?ogml03Ml2o`oO00?ogml03]l00ooOg`0=g`03omoO00kO00?o00003@000ol0
000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ol0000?0003omoO00gO0_l?g`03omoO00kO00?ogml03Ml00ooOg`0>g`03o`0000d0
00?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooO
g`0>g`03omoO00gO00?o00003`000ooOg`0=g`;o3ml00ooOg`0>g`03omoO00gO00?ogml03]l00ol0
000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO
00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`oO00?ogml03]l00ooOg`0=g`03omoO00kO
00?o00003@000ol0000>0003o`0000L000090003omoO00?O0ol6g`;o1ml2o`OO00?ogml00ml3o`OO
00?ogml01=l3o`OO00?ogml00ml4o`KO00?ogml01=l3o`OO00?ogml01=l3o`KO00?o00003`000ooO
g`05g`;o1]l2o`GO0ol7g`03omoO00GO0_l7g`03omoO00CO0ol6g`03omoO00CO0ol7g`03o`0000<0
1?l60003o`0000@00ol70003o`0000L000090003omoO00KO00?ogml00ml2o`KO00Cogmoo1]l00ooO
g`04g`03omoO00KO00?ogml01ml00ooOg`04g`03omoO00CO00?ogml01]l00ooOg`07g`03omoO00CO
00?ogml01Ml00ooOg`05g`03o`0000l000?ogml01=l01?oOgol5g`;o2=l00ooOg`04g`03omoO00CO
00Cogmoo1]l00ooOg`05g`03omoO00GO00?ogml01Ml00ooOg`06g`03o`0000@000?o00001P000ol0
00070003o`0000@000?o00001`0000T000?ogml01]l00ooOg`03g`;o1]l01?oOgol6g`03omoO00CO
00?ogml01]l00ooOg`07g`03omoO00CO00?ogml01Ml00ooOg`05g`03omoO00OO00?ogml01=l00ooO
g`03g`Co1]l00ol0000?0003omoO00CO00Cogmoo1Ml2o`SO00?ogml01=l00ooOg`04g`04omoOo`KO
00?ogml00ml4o`KO00?ogml01Ml00ooOg`06g`03o`0000D000?o00001@000ol000070003o`0000@0
00?o00001`0000T000?ogml01=l2o`KO0_l6g`04omoOo`KO00?ogml01=l00ooOg`06g`03omoO00CO
0ol7g`03omoO00KO00?ogml01=l00ooOg`05g`;o1ml00ooOg`03g`03omoo00OO00?o00003`000ooO
g`04g`04omoOo`GO0_l6g`;o1ml00ooOg`04g`04omoOo`KO00?ogml00ml00ooOo`07g`03omoO00GO
00?ogml01]l00ol000060003o`0000@000?o00001003o`L000?o00001`0000T000?ogml01]l00ooO
g`03g`;o1]l01?oOgol6g`03omoO00CO00?ogml01]l00ooOg`04g`03omoO00OO00?ogml00ml01?oO
gol6g`03omoO00OO00?ogml01=l00ooOg`03g`03omoo00OO00?o00003`000ooOg`04g`04omoOo`GO
0_l8g`03omoO00CO00?ogml01=l01?oOgol6g`03omoO00?O00?ogol01ml00ooOg`05g`03omoO00KO
00?o00000`001?l00?l60003o`0000@000?o00001`000ol0000700002@000ooOg`03g`?o1]l2o`OO
0_l7g`03omoO00?O0_l8g`03omoO00CO1?l6g`03omoO00CO0_l7g`03omoO00CO0ol7g`03omoO00CO
0_l7g`03o`0000l000?ogml01Ml2o`KO0_l5g`?o1ml00ooOg`05g`;o1ml00ooOg`04g`;o1ml00ooO
g`04g`;o2=l00ol0000400;o1`000ol0000400Co1P000ol0000700002@000ooOg`0<g`;o4=l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ooOg`0=g`;o3ml00ooO
g`0>g`03omoO00gO00?ogml03]l00ol0000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`oO
00?ogml03]l00ooOg`0=g`03omoO00kO00?o00003@000ol0000>0003o`0000L000090003omoO00cO
0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003omoO00gO
0_l?g`03omoO00kO00?ogml03Ml00ooOg`0>g`03o`0000d000?o00003P000ol0000700002@000ooO
g`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ooO
g`0=g`;o3ml00ooOg`0>g`03omoO00gO00?ogml03]l00ol0000=0003o`0000h000?o00001`0000T0
M?lA07Go2@0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooO
g`0=g`03o`0000l000?ogml03Ml2o`oO00?ogml03]l00olS8`0=8`03omoO00kO00?o00003@000ol0
000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ol0000?0003omoO00gO0_l?g`03omoO00kO00?o8b<03B<00ooOg`0>g`03o`0000d0
00?o00003P000ol0000700002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooO
g`0>g`03omoO00gO00?o00003`000ooOg`0=g`;o3ml00ooOg`0>g`03ob<S00dS00?ogml03]l00ol0
000=0003o`0000h000?o00001`0000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO
00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`oO00?ogml03]l00olS8`0=8`03omoO00kO
00?o00003@000ol0000>0003o`0000L000090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooO
g`0=g`03omoO00kO00?ogml03Ml00ol0000?0003omoO00gO0_l?g`03omoO00kO00?o8b<03B<00ooO
g`0>g`03o`0000d000?o00003P000ol0000700002@000ooOg`03g`?o1]l2o`KO0ol7g`03omoO00CO
0_l7g`03omoO00CO1?l6g`03omoO00CO0ol6g`03omoO00CO0ol7g`03omoO00?O0ol7g`03o`0000l0
00?ogml01=l3o`KO0_l5g`?o1ml00ooOg`04g`?o1ml00olS8`038`?o1b<00ooOg`05g`;o1ml00ol0
000400?o1P000ol0000400Co1P000ol0000700002@000ooOg`04g`03omoO00GO0_l9g`03omoO00CO
00?ogml00ml01?oOgol6g`03omoO00GO00?ogml01]l00ooOg`05g`03omoO00GO00?ogml01Ml00ooO
g`06g`03omoO00KO00?ogml01=l00ol0000?0003omoO00OO00?ogml00ml2o`KO00?ogml01]l00ooO
g`07g`03omoO00CO00?o8b<01R<00olS8`048`03omoO00CO00Cogmoo1]l00ol000050003o`0000D0
00?o00001@000ol000060003o`0000L000090003omoO00CO00?ogml01Ml2o`WO00?ogml01=l00ooO
g`03g`04omoOo`KO00?ogml01]l00ooOg`05g`03omoO00?O1?l6g`03omoO00GO00?ogml01]l00ooO
g`06g`03omoO00CO00?o00003`000ooOg`07g`03omoO00?O0_l6g`03omoO00KO00?ogml01ml00ooO
g`04g`03ob<S00HS00?o8b<012<00ooOg`04g`04omoOo`KO00?o00000`04o`H000?o00001P000ol0
00050003o`0000L000090003omoO00CO00?ogml01Ml2o`OO0_l7g`03omoO00?O00Cogmoo1]l00ooO
g`07g`03omoO00CO00?ogml00ml00ooOo`07g`03omoO00GO00?ogml01]l00ooOg`03g`?o1ml00ol0
000?0003omoO00GO0_l6g`;o1]l00ooOg`06g`03omoO00GO0_l7g`03ob<S00<S0ol78`03omoO00CO
00Cogmoo1]l00ol000030003o`3o00L000?o00001`000ol000040003o`0000L000090003omoO00CO
00?ogml01Ml2o`WO00?ogml01=l00ooOg`03g`04omoOo`KO00?ogml01=l01?oOgol6g`03omoO00?O
00?ogol01ml00ooOg`05g`03omoO00KO00?ogml00ml00ooOg`07g`03o`0000l000?ogml01ml00ooO
g`03g`;o1]l00ooOg`06g`03omoO00OO00?ogml01=l00olS8`038`03ob<S00LS00?ogml01=l01?oO
gol6g`03o`0000<000?o0?l01`000ol000040004o`00o`H000?o00001`0000T000?ogml00ml2o`OO
0_l6g`?o1ml00ooOg`04g`;o1ml00ooOg`05g`;o1ml00ooOg`04g`;o1ml00ooOg`04g`;o2=l00ooO
g`03g`Co1]l00ol0000?0003omoO00CO0ol6g`;o1Ml2o`SO00?ogml01=l3o`OO00?o8b<00b<4o`HS
00?ogml01Ml2o`OO00?o00001002o`L000?o00001@02o`L000?o00001`0000T000?ogml03=l2oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?ogml03Ml2o`oO
00?ogml03]l00olS8`0=8`03omoO00kO00?o00003@000ol0000>0003o`0000L000090003omoO00cO
0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0000?0003omoO00gO
0_l?g`03omoO00kO00?o8b<03B<00ooOg`0>g`03o`0000d000?o00003P000ol0000700002@000ooO
g`0<g`;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ooO
g`0=g`;o3ml00ooOg`0>g`03ob<S00dS00?ogml03]l00ol0000=0003o`0000h000?o00001`0000T0
00?ogml03=l2oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l0
00?ogml03Ml2o`oO00?ogml03]l00olS8`0=8`03omoO00kO00?o00003@000ol0000>0003o`0000L0
00090003omoO00cO0_l@g`03omoO00gO00?ogml03]l00ooOg`0=g`03omoO00kO00?ogml03Ml00ol0
000?0003omoO00gO0_l?g`03omoO00kO00?o8b<03B<00ooOg`0>g`03o`0000d000?o00003P000ol0
00070000201eoa00M_l90000201eoa00M_l900002@000ol0000;00?o4=l00ooOg`0=g`03omoO00kO
00?ogml03Ml00ooOg`0>g`03omoO00gO00?o00003`000ol0000;0004o`3oo`oO00?ogml03]l00ooO
g`0=g`03omoO00kO00?o00003@000ol0000>0003o`0000L000090005o`3oo`000_l60004o`3ooa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?o00000_l00`3o
o`050003o`0000;o3ml00ooOg`0>g`03omoO00gO00?ogml03]l00ol0000=0003o`0000h000?o0000
1`0000T000Ko003o0?l60003o`0000;o4=l00ooOg`0=g`03omoO00kO00?ogml03Ml00ooOg`0>g`03
omoO00gO00?o00003`001ol0003o0?l01@001?l00002o`oO00?ogml03]l00ooOg`0=g`03omoO00kO
00?o00003@000ol0000>0003o`0000L000090005o`000?l01P001?l00002oa3O00?ogml03Ml00ooO
g`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000?o00000P000ol000030003o`000080
0_l?g`03omoO00kO00?ogml03Ml00ooOg`0>g`03o`0000d000?o00003P000ol0000700002@001_l0
0?l0o`@000?o00000P02o`KO0ol7g`03omoO00?O0ol7g`03omoO00GO0ol6g`03omoO00?O0ol7g`03
omoO00GO0_l7g`03omoO00?O1?l6g`03o`0000l000Oo0000o`3o00<000?o00000`02o`GO0ol7g`03
omoO00GO0_l7g`03omoO00CO0ol6g`03omoO00CO0ol7g`03o`0000<01?l60003o`0000@00ol70003
o`0000L000090005o`3oo`000_l200?o0`02o`OO00?ogml01]l00ooOg`06g`03omoO00CO00?ogml0
1]l00ooOg`05g`03omoO00KO00?ogml01=l00ooOg`04g`04omoOo`KO00?ogml01=l00ooOg`06g`03
o`0000l000?o00000_l0103oo`04o`<00_l8g`03omoO00CO00?ogml01=l01?oOgol6g`03omoO00GO
00?ogml01Ml00ooOg`05g`03omoO00KO00?o000010000ol000060003o`0000L000?o000010000ol0
000700002@000ol000050003o`3o00@00_l7g`03omoO00KO00?ogml01]l00ooOg`04g`03omoO00CO
1?l6g`03omoO00KO00?ogml01=l00ooOg`04g`04omoOo`KO00?ogml01Ml00ooOg`05g`03o`0000l0
00?o00001@001?l00?l400;o2=l00ooOg`04g`03omoO00CO00Cogmoo1]l00ooOg`03g`Co1]l00ooO
g`05g`03omoO00KO00?o00001@000ol000050003o`0000L000?o000010000ol0000700002@000ol0
00040005o`000?l00`02o`OO00?ogml01]l00ooOg`04g`;o1ml00ooOg`04g`03omoo00OO00?ogml0
0ml3o`OO00?ogml01=l01?oOgol6g`03omoO00KO00?ogml01=l00ol0000?0003o`0000@000?o0000
0P001?l00002o`KO0_l7g`03omoO00CO00Cogmoo1]l00ooOg`03g`03omoo00OO00?ogml01Ml00ooO
g`06g`03o`0000H000?o000010000ol0000400?o1`000ol0000700002@000ol000030003o`000080
00Co00000_l7g`03omoO00KO00?ogml01]l00ooOg`04g`03omoO00CO00?ogol01ml00ooOg`03g`03
omoO00OO00?ogml01=l01?oOgol6g`03omoO00?O00Cogmoo1]l00ol0000?0003o`0000<000?o0000
0`001?l00002o`SO00?ogml01=l00ooOg`04g`04omoOo`KO00?ogml00ml00ooOo`07g`03omoO00GO
00?ogml01]l00ol000030004o`00o`H000?o000010000ol000070003o`0000L000090003o`000080
00?o00000P000ol0o`0200;o1]l2o`SO00?ogml00ml3o`OO00?ogml01Ml2o`OO00?ogml00ml4o`KO
00?ogml01Ml2o`OO00?ogml01=l2o`OO00?o00003`000ol000020003o`0000<000?o0?l00P02o`GO
0ol7g`03omoO00GO0_l7g`03omoO00CO0_l7g`03omoO00CO0_l8g`03o`0000@00_l70003o`0000@0
1?l60003o`0000L000090005o`000?l01@000ol0o`0200;o4=l00ooOg`0=g`03omoO00kO00?ogml0
3Ml00ooOg`0>g`03omoO00gO00?o00003`001Ol0003o00H000?o0?l00P02o`oO00?ogml03]l00ooO
g`0=g`03omoO00kO00?o00003@000ol0000>0003o`0000L000090004o`00o`D00_l0103oo`02oa3O
00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l000Co003o1P02o`04
0?oo00;o3ml00ooOg`0>g`03omoO00gO00?ogml03]l00ol0000=0003o`0000h000?o00001`0000T0
00?o0?l03002oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l0
00?o0?l03@02o`oO00?ogml03]l00ooOg`0=g`03omoO00kO00?o00003@000ol0000>0003o`0000L0
000900;o3@02oa3O00?ogml03Ml00ooOg`0>g`03omoO00gO00?ogml03]l00ooOg`0=g`03o`0000l0
0_l>00;o3ml00ooOg`0>g`03omoO00gO00?ogml03]l00ol0000=0003o`0000h000?o00001`0000T0
M?lA07Go2@0001P00_n400;oK0000?l03@000?l03@000?l03@0003/00_l:00;o:`03odT00_l:00;o
;003o`l0000k0003o`0000X000?o0000:P000ol000180003o`0000X000?o0000:`000ol0000>0000
2`03o`8000Co003o0P05o`030?oo00;o0`03o`<01?l200Wo0`000ol000030003o`0000@000?o0000
4@02o`030?oo00T000?o0?l02@000ol0000G00?o0P001?l00?l200Go00<0ool00_l300?o0`04o`80
2Ol30003o`0000<000?o000010000ol0000B00;o00<0ool02@000ol0o`090003o`0000d0000<0004
o`0000Co10000ol000040005o`000?l00P000ol0o`050005o`000?l00P000ol0o`030003o`0000<0
00?o000010000ol0000B0003o`3o00/000?o000020000ol0000H0004o`0000Co10000ol000040005
o`000?l00P000ol0o`050005o`000?l00P000ol0o`030003o`0000<000?o000010000ol0000C0003
o`3o00/000?o000020000ol0000=000030001?l00004o`@000Co00001?l30003o`0000801Ol00`3o
00020004o`00o`D000?o000010000ol000030003o`0001<000?o00002005o`L000?o0?l06@001?l0
0004o`@000Co00001?l30003o`0000801Ol00`3o00020004o`00o`D000?o000010000ol000030003
o`0001@000?o00002005o`L000?o0?l03P0000X000Oo0?l0o`3o008000?o00000P001Ol0003o00H0
00?o00000P001ol0003o0?l00`001Ol0003o00@000?o000010000ol000030003o`00018000?o0?l0
2`000ol000070003o`3o01L000Oo0?l0o`3o008000?o00000P001Ol0003o00H000?o00000P001ol0
003o0?l00`001Ol0003o00@000?o000010000ol000030003o`0001<000?o0?l02`000ol000070003
o`3o00h0000:0004o`3o00?o0P02o`800_l300Co0P04o`<00ol300Co00@0o`3o10000ol000050003
o`00008000?o00004@02o`030?oo01<00_l00`3oo`0F0004o`3o00?o0P02o`800_l300Co0P04o`<0
0ol300Co00@0o`3o10000ol000050003o`00008000?o00004P02o`030?oo01<00_l00`3oo`0=0000
2P05oa@000?o000030000ol0o`03o`<00_l300Co0`02odH01OlD0003o`0000`000?o0?l00ol300;o
0`04o`<00_ln000060000ol000080003o`0000/00_mZ0003o`0000P000?o00002`02oe@0003o00d0
003o00d0003o00d0003o00d0003o00d00000\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-0.0500105, -0.0540714, 
  0.00784322, 0.00784322}, {{6.375, 127.75}, {280.062, 
  150}} -> {-1.56109, -0.608189, 0.0605569, 0.0605569}, {{139.938, 261.375}, {
  280.062, 150}} -> {-9.64947, -0.607596, 0.0605487, 0.0605487}, {{6.375, 
  127.75}, {136.938, 6.875}} -> {-1.56109, -9.2754, 0.0605569, 0.0605569}, {{
  139.938, 261.375}, {136.938, 6.875}} -> {-9.64947, -9.27363, 0.0605487, 
  0.0605487}},
  CellTags->"Subgroups"],

Cell[BoxData[
    \({True, False, False, False}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Before we can ask if {0, 4} is a subgroup of ",
  Cell[BoxData[
      StyleBox[\(TwistedZ[6]\),
        "MR"]], "Input",
    GeneratedCell->True],
  ", we need this parent groupoid to be a group itself."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[{0, \ 4}, \ TwistedZ[6]]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Group::"fail" \( : \ \) 
      "The Groupoid \!\(\"TwistedZ[6]\"\) fails at least one of the tests for \
being a group, which is needed for this function."\)], "Message",
  CellTags->"Subgroups"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["We can check several distinct groups at once for subgroups.", 
  "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[{{\ {0, 3}, Z[5]}, \ {\ {1, 4}, U[9]}}, \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .51587 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0122827 0.47619 [
[ 0 0 0 0 ]
[ 1 .51587 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .51587 L
0 .51587 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0122827 0.477324 0.50359 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 0 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.18254 .81944 m
.18254 .97817 L
.34127 .97817 L
.34127 .81944 L
F
.34127 .81944 m
.34127 .97817 L
.5 .97817 L
.5 .81944 L
F
.02381 .66071 m
.02381 .81944 L
.18254 .81944 L
.18254 .66071 L
F
.02381 .50198 m
.02381 .66071 L
.18254 .66071 L
.18254 .50198 L
F
1 0 0 r
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
[(0)] .2619 .74008 0 0 Mshowa
[(3)] .42063 .74008 0 0 Mshowa
[(1)] .57937 .74008 0 0 Mshowa
[(2)] .7381 .74008 0 0 Mshowa
[(4)] .89683 .74008 0 0 Mshowa
[(3)] .2619 .58135 0 0 Mshowa
[(1)] .42063 .58135 0 0 Mshowa
[(4)] .57937 .58135 0 0 Mshowa
[(0)] .7381 .58135 0 0 Mshowa
[(2)] .89683 .58135 0 0 Mshowa
[(1)] .2619 .42262 0 0 Mshowa
[(4)] .42063 .42262 0 0 Mshowa
[(2)] .57937 .42262 0 0 Mshowa
[(3)] .7381 .42262 0 0 Mshowa
[(0)] .89683 .42262 0 0 Mshowa
[(2)] .2619 .26389 0 0 Mshowa
[(0)] .42063 .26389 0 0 Mshowa
[(3)] .57937 .26389 0 0 Mshowa
[(4)] .7381 .26389 0 0 Mshowa
[(1)] .89683 .26389 0 0 Mshowa
[(4)] .2619 .10516 0 0 Mshowa
[(2)] .42063 .10516 0 0 Mshowa
[(0)] .57937 .10516 0 0 Mshowa
[(1)] .7381 .10516 0 0 Mshowa
[(3)] .89683 .10516 0 0 Mshowa
[(0)] .10317 .74008 0 0 Mshowa
[(3)] .10317 .58135 0 0 Mshowa
[(1)] .10317 .42262 0 0 Mshowa
[(2)] .10317 .26389 0 0 Mshowa
[(4)] .10317 .10516 0 0 Mshowa
[(0)] .2619 .89881 0 0 Mshowa
[(3)] .42063 .89881 0 0 Mshowa
[(1)] .57937 .89881 0 0 Mshowa
[(2)] .7381 .89881 0 0 Mshowa
[(4)] .89683 .89881 0 0 Mshowa
[(Z[5])] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0122827 0.97619 0.50359 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(1)] .22789 .77381 0 0 Mshowa
[(4)] .36395 .77381 0 0 Mshowa
[(2)] .5 .77381 0 0 Mshowa
[(5)] .63605 .77381 0 0 Mshowa
[(7)] .77211 .77381 0 0 Mshowa
[(8)] .90816 .77381 0 0 Mshowa
[(4)] .22789 .63776 0 0 Mshowa
[(7)] .36395 .63776 0 0 Mshowa
[(8)] .5 .63776 0 0 Mshowa
[(2)] .63605 .63776 0 0 Mshowa
[(1)] .77211 .63776 0 0 Mshowa
[(5)] .90816 .63776 0 0 Mshowa
[(2)] .22789 .5017 0 0 Mshowa
[(8)] .36395 .5017 0 0 Mshowa
[(4)] .5 .5017 0 0 Mshowa
[(1)] .63605 .5017 0 0 Mshowa
[(5)] .77211 .5017 0 0 Mshowa
[(7)] .90816 .5017 0 0 Mshowa
[(5)] .22789 .36565 0 0 Mshowa
[(2)] .36395 .36565 0 0 Mshowa
[(1)] .5 .36565 0 0 Mshowa
[(7)] .63605 .36565 0 0 Mshowa
[(8)] .77211 .36565 0 0 Mshowa
[(4)] .90816 .36565 0 0 Mshowa
[(7)] .22789 .22959 0 0 Mshowa
[(1)] .36395 .22959 0 0 Mshowa
[(5)] .5 .22959 0 0 Mshowa
[(8)] .63605 .22959 0 0 Mshowa
[(4)] .77211 .22959 0 0 Mshowa
[(2)] .90816 .22959 0 0 Mshowa
[(8)] .22789 .09354 0 0 Mshowa
[(5)] .36395 .09354 0 0 Mshowa
[(7)] .5 .09354 0 0 Mshowa
[(4)] .63605 .09354 0 0 Mshowa
[(2)] .77211 .09354 0 0 Mshowa
[(1)] .90816 .09354 0 0 Mshowa
[(1)] .09184 .77381 0 0 Mshowa
[(4)] .09184 .63776 0 0 Mshowa
[(2)] .09184 .5017 0 0 Mshowa
[(5)] .09184 .36565 0 0 Mshowa
[(7)] .09184 .22959 0 0 Mshowa
[(8)] .09184 .09354 0 0 Mshowa
[(1)] .22789 .90986 0 0 Mshowa
[(4)] .36395 .90986 0 0 Mshowa
[(2)] .5 .90986 0 0 Mshowa
[(5)] .63605 .90986 0 0 Mshowa
[(7)] .77211 .90986 0 0 Mshowa
[(8)] .90816 .90986 0 0 Mshowa
[(U[9])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{288, 148.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000U0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?nJ00002P000ol0000@00;o50000ol0000B0003o`00014000?o0000
4P000ol0000A0003o`000140O?l;00002P000ol0000@00;o50000ol0000B0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o0000
3P000ol0000?0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o00003`000ol0000>0003
o`0000l000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003o`0000h000?o0000
3`000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003
o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o00003P000ol0000?0003
o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000=00;o4@000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o0000
2@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003
o`0000@00_l700;o1`02o`P000?o00001003o`L000?o00001@000ol000070003o`0000D00ol70003
o`0000@01?l60003o`0000@00ol80003o`0000T0000:0003o`0000H00ol700;o2@03o`P000?o0000
1@04o`T000?o00001P02o`T000?o00001P03o`T000?o00001@03o`T000?o00004@000ol000030004
o`00o`H00_l60004o`00o`L000?o00001`000ol000040003o`0000D000?o00001`000ol000060003
o`0000H000?o00001@000ol000060003o`0000D000?o00001`000ol0000900002P000ol000070003
o`0000H00_l:0003o`0000L000?o00001P000ol000090003o`0000D000Co003o20000ol000070003
o`0000P000?o000020000ol000060003o`00014000?o00000`001?l00?l600;o1P001?l00?l70003
o`0000L000?o000010000ol000060003o`0000H000?o00001004o`L000?o00001P000ol000050003
o`0000D000?o00001`000ol0000900002P000ol0000500Co1`02o`P01?l80003o`0000L000?o0000
20000ol000050004o`00o`P000?o00001`000ol000080003o`0000P000?o00001P000ol0000A0003
o`0000@00_l700;o1`02o`P000?o00001003o`L000?o00001P000ol000060003o`0000@000?o0?l0
20000ol000070003o`0000@000?o00001@000ol000070003o`0000T0000:0003o`0000D000?o0?l0
2002o`P000?o0?l02@000ol000080003o`0000L000?o00001@001?l00?l80003o`0000L000?o0000
20000ol0000600;o2@000ol0000A0003o`0000<000Co003o1P02o`H000Co003o1`000ol000040003
o`0000L000?o00001`000ol000050003o`0000@000?o0?l020000ol000040004o`00o`H000?o0000
1@000ol000070003o`0000T0000:0003o`0000D000?o0?l02002o`P000?o0?l02@000ol000050004
o`00o`T000?o00001@001?l00?l80003o`0000L000?o000020000ol000080003o`0000H000?o0000
4@000ol0000400;o1`02o`L00_l80003o`0000@01?l60003o`0000@01?l70003o`0000D00_l80003
o`0000D00_l70003o`0000@00_l90003o`0000T0000:0003o`0000H00_l800;o2@02o`T000?o0000
1P02o`X000?o00001P02o`T000?o00001P02o`X000?o00001@03o`T000?o00004@000ol0000=00;o
4@000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?o0000
4002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`0000d00_lA0003
o`0000h000?o00003`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ol0000@00;o
50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o00003@02oa4000?o0000
3P000ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003o`0001000_lD0003
o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol0000=00;o4@000ol0000>0003
o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?o00004002oa@000?o0000
4P000ol0000A0003o`00018000?o00004@000ol0000A0003o`0000d00_lA0003o`0000h000?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ol0000@00;o50000ol0000B0003
o`00014000?o00004P000ol0000A0003o`000140O?l;00002P000ol0000@00;o50000ol0000B0003
o`00014000?o00004P000ol0000A0003o`00014000?o00003@02oa4000?o00003P000ol0000?0003
o`0000l000?o00003P000ol0000?0003o`0000T0000:07co4`000ol0000=00;o4@000ol0000>0003
o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?o00004002oa@000?o0000
4P000ol0000A0003o`00018000?o00004@000ol0000A0003o`0000d00_lA0003o`0000h000?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ol0000@00;o50000ol0000B0003
o`00014000?o00004P000ol0000A0003o`00014000?o00003@02oa4000?o00003P000ol0000?0003
o`0000l000?o00003P000ol0000?0003o`0000T0000:0003o`0001000_lD0003o`00018000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o0000
3`000ol0000>0003o`0000l000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003
o`00018000?o00004@000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003
o`0000h000?o00003`000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o0000
4P000ol0000A0003o`00014000?o000010000ol0000600;o1`000ol000070003o`0000@00ol70003
o`0000@00ol80003o`0000D00_l80003o`0000D00ol60003o`0000@01?l70003o`0000T0000:0003
o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol000040003
o`0000H00_l70003o`0000L000?o00001@000ol000060003o`0000L000?o00001@000ol000040004
o`00o`L000?o00001P000ol000050003o`0000D000?o00001`000ol0000900002P000ol0000@00;o
50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o00001@000ol0000500;o
20000ol000060003o`0000D000?o00001P000ol000070003o`0000D000?o000010001?l00?l70003
o`0000@01?l60003o`0000H000?o00001P000ol0000900002P000ol0000@00;o50000ol0000B0003
o`00014000?o00004P000ol0000A0003o`00014000?o00001@000ol0000500;o20000ol000060003
o`0000D000?o00001P000ol0000400?o20000ol0000500;o20000ol000040003o`3o00L000?o0000
1`000ol000050003o`0000T0000:0003o`0000D01?l700;o2004o`P000?o00001P02o`X000?o0000
1@03o`T000?o00001`03o`P000?o00001@03o`T000?o00004@000ol000060003o`0000@00_l90003
o`0000D000?o00001@000ol000060003o`0000@000?o000020000ol000040004o`00o`L000?o0000
10000ol0o`070003o`0000@000Co003o1`000ol0000900002P000ol000060003o`0000L00_l90003
o`0000P000?o00001@001?l00?l90003o`0000P000?o00001P000ol000080003o`0000L000?o0000
1P000ol000080003o`00014000?o00000`04o`H00_l600Co1`000ol0000400;o20000ol0000400Co
1`000ol0000500;o20000ol0000500;o1`000ol0000500;o20000ol0000900002P000ol000070003
o`0000H00_l:0003o`0000L000?o00001@001?l00?l90003o`0000P000?o00001P000ol0000600Co
20000ol000060003o`0000P000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o0000
3`000ol0000>0003o`0000l000?o00002@0000X000?o000020000ol0000500;o2`000ol000060003
o`0000D000Co003o2@000ol0000600;o2@000ol000060003o`3o00T000?o00001P000ol000080003
o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o00003P000ol0000?0003
o`0000T0000:0003o`0000D000Co003o1`02o`P000Co003o20000ol000050004o`00o`T000?o0000
20000ol000060003o`0000H000?o0?l02@000ol000060003o`0000P000?o00004@000ol0000=00;o
4@000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?o0000
1P02o`P00_l900;o2@000ol0000600;o2P000ol0000500?o2@000ol0000700;o2@000ol0000500;o
2P000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003o`0000h000?o0000
3`000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003
o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o00003P000ol0000?0003
o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o0000
4@1lo`/0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000=00;o4@000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o0000
2@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003
o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003o`0000h000?o00003`000ol000090000
2P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
3@02oa4000?o00003P000ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003
o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol0000=00;o
4@000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X0O?lC0003
o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003o`0000h000?o00003`000ol000090000
2P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
3@02oa4000?o00003P000ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003
o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol0000300?o
1`02o`H00ol80003o`0000@01?l60003o`0000@00ol80003o`0000D000?o00001`000ol0000500;o
1`000ol0000500?o1`000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00001P000ol0000400;o2@000ol000050003o`0000D000?o0000
1P000ol000050003o`0000L000?o00001@000ol000070003o`0000@000Co003o1P000ol000060003
o`0000H000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`0000H000?o00001002o`T000?o00001@000ol000060003o`0000D000?o0000
1@000ol000070003o`0000H000?o00001P000ol000040004o`00o`H000?o00001004o`L000?o0000
2@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003
o`0000<00ol700;o1P03o`P000?o00001`000ol000040003o`0000D000?o00001`000ol000060003
o`0000H000?o00001@02o`L000?o000010000ol0o`080003o`0000T0000:0003o`0001000_lD0003
o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol000030003o`0000L00_l60003
o`0000P000?o000010001?l00?l60003o`0000D000?o00001`000ol000070003o`0000D000?o0000
10001?l00?l60003o`0000@000?o0?l020000ol0000900002P000ol0000@00;o50000ol0000B0003
o`00014000?o00004P000ol0000A0003o`00014000?o00000`04o`H00_l600Co1`000ol0000500;o
1`000ol0000400;o2@000ol0000400Co1`000ol0000500;o1`000ol0000500;o20000ol000090000
2P000ol0000500?o2002o`P00ol90003o`0000H00ol90003o`0000D01?l80003o`0000H00ol90003
o`0000H00_l90003o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o0000
3P000ol0000?0003o`0000T0000:0003o`0000H000?o00001`02o`T000?o000020000ol000070003
o`0000P000?o00001P000ol000080003o`0000T000?o00001P000ol000050004o`00o`P000?o0000
4@000ol0000=00;o4@000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o0000
2@0000X000?o00001P000ol0000700;o2@000ol000080003o`0000D01?l90003o`0000L000?o0000
1`000ol000090003o`0000H000?o00001@001?l00?l80003o`00014000?o00003@02oa4000?o0000
3P000ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003o`0000H000?o0000
1`02o`T000?o000020000ol000050003o`3o00X000?o000020000ol000060003o`0000L00_l90003
o`0000D000Co003o20000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003
o`0000h000?o00003`000ol0000900002P000ol000060003o`0000L00_l90003o`0000P000?o0000
1@000ol0o`0:0003o`0000D000Co003o20000ol000090003o`0000H000?o00001@001?l00?l80003
o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o00003P000ol0000?0003
o`0000T0000:0003o`0000D00_l900;o2002o`X000?o00001P02o`X000?o00001P02o`T000?o0000
1P03o`T000?o00001P02o`T000?o00004@1lo`/0000:0003o`0001000_lD0003o`00018000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o0000
3`000ol0000>0003o`0000l000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003
o`00018000?o00004@000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003
o`0000h000?o00003`000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o0000
3P000ol0000?0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o00003`000ol0000>0003
o`0000l000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003o`0000h000?o0000
3`000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003
o`00014000?o00000`04o`H00_l600Co1`000ol0000500;o1`000ol0000500?o1`000ol0000400?o
20000ol0000400?o1`000ol000050003o`0000L000?o00002@0000X000?o00004002oa@000?o0000
4P000ol0000A0003o`00018000?o00004@000ol0000A0003o`0000@000?o00001P02o`L000?o0000
1`000ol000040004o`00o`H000?o00001P000ol000060003o`0000D000?o00001`000ol000070003
o`0000@000?o00001@000ol000070003o`0000T0000:07co4`000ol000050003o`0000D00_l80003
o`0000H000?o000010001?l00?l60003o`0000@01?l70003o`0000D000?o00001`000ol000070003
o`0000@000?o00001P000ol000060003o`0000T0000:0003omoO013O0_lDg`03ob<S018S00?o0000
4@000ol0000B0003o`00014000?o00004@000ol000060003o`0000@00_l90003o`0000D000?o0000
1@02o`L000?o000010000ol0o`080003o`0000D000?o00001`000ol0000400?o1`000ol000060003
o`0000H000?o00002@0000X000?ogml04=l2oaCO00?o8b<04R<00ol0000A0003o`00018000?o0000
4@000ol0000A0003o`0000<000Co003o1P02o`H000Co003o1`000ol000040004o`00o`H000?o0000
10000ol0o`080003o`0000D000?o00001`000ol000040003o`0000L000?o00001`000ol000050003
o`0000T0000:0003omoO013O0_lDg`03ob<S018S00?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000400;o1`02o`L00_l80003o`0000D00_l70003o`0000D00_l80003o`0000@00_l90003
o`0000@01?l60003o`0000@01?l70003o`0000T0000:0003omoO013O0_lDg`03ob<S018S00?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o0000
3`000ol0000>0003o`0000l000?o00002@0000X000?ogml04=l2oaCO00?o8b<04R<00ol0000A0003
o`00018000?o00004@000ol0000A0003o`0000d00_lA0003o`0000h000?o00003`000ol0000?0003
o`0000h000?o00003`000ol0000900002P000ooOg`0@g`;o5=l00olS8`0B8`03o`00014000?o0000
4P000ol0000A0003o`00014000?o00003@02oa4000?o00003P000ol0000?0003o`0000l000?o0000
3P000ol0000?0003o`0000T0000:0003omoO013O0_lDg`03ob<S018S00?o00004@000ol0000B0003
o`00014000?o00004@000ol0000=00;o4@000ol0000>0003o`0000l000?o00003`000ol0000>0003
o`0000l000?o00002@0000X000?ogml01Ml3o`SO0_l8g`?o2Ml00olS8`058`?o2R<00ol0000600?o
20000ol0000700;o2@000ol0000500Co20000ol0000A0003o`0000d00_lA0003o`0000h000?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ooOg`08g`03omoO00GO0_l;g`03
omoO00KO00?o8b<01R<00olS8`098`03o`0000L000?o00001`000ol000060004o`00o`P000?o0000
1P000ol000080003o`000140O?l;00002P000ooOg`08g`03omoO00GO0_l;g`03omoO00KO00?o8b<0
1R<00olS8`098`03o`0000D01?l80003o`0000H000Co003o20000ol000070003o`0000L000?o0000
4@000ooOg`0=g`;o4Ml00olS8`0>8`03o`0000l000?o00003`000ol0000>0003o`0000l000?o0000
2@0000X000?ogml01]l2o`SO0_l9g`;o2Ml00olS8`068`03ob<S00TS00?o00001@000ol0o`090003
o`0000H000Co003o20000ol000080003o`0000H000?o00004@000ooOg`0=g`;o4Ml00olS8`0>8`03
o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?ogml02=l00ooOg`05g`;o
2ml00ooOg`06g`03ob<S00HS00?o8b<02B<00ol000050003o`3o00T000?o00001P001?l00?l80003
o`0000D000Co003o20000ol0000A0003omoO00gO0_lAg`03ob<S00hS00?o00003`000ol0000?0003
o`0000h000?o00003`000ol0000900002P000ooOg`05g`?o2=l2o`SO0ol9g`03ob<S00DS0_l;8`03
o`0000H00_l90003o`0000L00_l90003o`0000H00_l90003o`00014000?ogml03Ml2oa7O00?o8b<0
3R<00ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003omoO013O0_lDg`03
ob<S018S00?o00004@000ol0000B0003o`00014000?o00004@000ooOg`0=g`;o4Ml00olS8`0>8`03
o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?ogml04=l2oaCO00?o8b<0
4R<00ol0000A0003o`00018000?o00004@000ol0000A0003omoO00gO0_lAg`03ob<S00hS00?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ooOg`0@g`;o5=l00olS8`0B8`03
o`00014000?o00004P000ol0000A0003o`00014000?ogml01=l3o`KO0_l7g`?o1ml00olS8`058`03
ob<S00HS00?o00001@02o`P000?o00001004o`L000?o00001003o`L000?o00001003o`P000?o0000
2@0000X000?ogml04=l2oaCO00?o8b<04R<00ol0000A0003o`00018000?o00004@000ol0000A0003
omoO00GO00?ogml01Ml2o`SO00?ogml01]l00olS8`058`03ob<S00HS00?o000010001?l00?l70003
o`0000D000?o00001`000ol000050003o`0000H000?o00001`000ol000050003o`0000T0000:0003
omoO013O0_lDg`03ob<S018S00?o00004@000ol0000B0003o`00014000?o00004@000ooOg`03g`Co
1]l2o`KO1?l7g`03ob<S00HS00?o8b<01B<00ol000040004o`00o`L000?o00001P000ol000060003
o`0000D000?o00001P000ol000070003o`0000D000?o00002@0000X000?ogml04=l2oaCO00?o8b<0
4R<00ol0000A0003o`00018000?o00004@000ol0000A0003omoO00?O00?ogol01ml2o`KO00?ogol0
2=l00olS8`068`03ob<S00DS00?o00001@02o`P000?o00001`000ol000050003o`0000D000?o0000
1P000ol0000400?o20000ol0000900002P1loa<000?ogml00ml00ooOo`07g`;o1]l00ooOo`08g`03
ob<S00LS00?o8b<012<00ol000040004o`00o`L000?o000010001?l00?l70003o`0000D000?o0000
1P000ol000040003o`0000P000?o00002@0000X000?ogml04=l2oaCO00?ogml04]l00ol0000A0003
o`00018000?o00004@000ol0000A0003omoO00CO0_l7g`;o1ml2o`SO00?o8b<012<4o`HS00?o0000
1@02o`P000?o00001@02o`P000?o00001002o`P000?o00001004o`L000?o00002@0000X000?ogml0
4=l2oaCO00?ogml04]l00ol0000A0003o`00018000?o00004@000ol0000A0003omoO00gO0_lAg`03
ob<S00hS00?o00003`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ooOg`0@g`;o
5=l00ooOg`0Bg`03o`00014000?o00004P000ol0000A0003o`00014000?ogml03Ml2oa7O00?o8b<0
3R<00ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003omoO013O0_lDg`03
omoO01;O00?o00004@000ol0000B0003o`00014000?o00004@000ooOg`0=g`;o4Ml00olS8`0>8`03
o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?ogml04=l2oaCO00?ogml0
4]l00ol0000A0003o`00018000?o00004@000ol0000A0003omoO00gO0_lAg`03ob<S00hS00?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ooOg`0@g`;o5=l00ooOg`0Bg`03
o`00014000?o00004P000ol0000A0003o`00014000?ogml03Ml2oa7O00?o8b<03R<00ol0000?0003
o`0000l000?o00003P000ol0000?0003o`0000T0000:0003omoO013O0_lDg`03omoO01;O00?o0000
4@000ol0000B0003o`00014000?o00004@1lo`/0000:0003omoO00KO0_l8g`;o2Ml2o`WO00?ogml0
1Ml3o`[O00?o00001@03o`T000?o00001P04o`P000?o00001P03o`P000?o00004@000ooOg`0=g`;o
4Ml00ooOg`0>g`03o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?ogml0
1Ml01?oOgol7g`;o2=l01?oOgol8g`03omoO00SO00?ogml01ml00ol000060003o`0000P000?o0000
1`000ol000080003o`0000L000?o00001`000ol0000A0003omoO00gO0_lAg`03omoO00kO00?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ooOg`05g`04omoOo`OO0_l8g`04
omoOo`SO00?ogml02=l00ooOg`07g`03o`0000H000?o000020000ol000080003o`0000L000?o0000
1@04o`P000?o00004@000ooOg`0=g`;o4Ml00ooOg`0>g`03o`0000l000?o00003`000ol0000>0003
o`0000l000?o00002@0000X000?ogml01Ml01?oOgol7g`;o2=l01?oOgol8g`03omoO00KO0_l:g`03
o`0000H000?o000020000ol000090003o`0000H000?o00001@000ol0o`090003o`00014000?ogml0
3Ml2oa7O00?ogml03]l00ol0000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:0003
omoO00GO00Cogmoo1ml2o`SO00Cogmoo2=l00ooOg`08g`03omoO00OO00?o00001P000ol000080003
o`0000H000Co003o20000ol000050003o`3o00T000?o00004@000ooOg`0=g`;o4Ml00ooOg`0>g`03
o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X000?ogml01]l2o`SO0_l9g`;o
2Ml00ooOg`05g`?o2]l00ol0000500;o2P000ol0000700;o2@000ol0000600;o2@000ol0000A0003
omoO00gO0_lAg`03omoO00kO00?o00003`000ol0000?0003o`0000h000?o00003`000ol000090000
2P000ooOg`0@g`;o5=l00ooOg`0Bg`03o`00014000?o00004P000ol0000A0003o`00014000?ogml0
0ml3o`OO0_l6g`?o2=l00ooOg`05g`?o1]l00ol0000400Co1`000ol0000400?o20000ol000050003
o`0000H000?o00001@02o`P000?o00002@0000X000?ogml04=l2oaCO00?ogml04]l00ol0000A0003
o`00018000?o00004@000ol0000A0003omoO00CO00?ogml01]l2o`OO00?ogml01ml00ooOg`06g`03
omoO00GO00?o00001@000ol000070003o`0000L000?o00001@000ol000050003o`0000H000?o0000
10001?l00?l70003o`0000T0000:0003omoO013O0_lDg`03omoO01;O00?o00004@000ol0000B0003
o`00014000?o00004@000ooOg`04g`03omoO00KO0_l7g`03omoO00OO00?ogml01=l4o`KO00?o0000
1P000ol000060003o`0000L000?o00001@000ol000060003o`0000D000?o000010001?l00?l70003
o`0000T0000:0003omoO013O0_lDg`03omoO01;O00?o00004@000ol0000B0003o`00014000?o0000
4@000ooOg`04g`03omoO00KO0_l7g`03omoO00OO00?ogml01=l00ooOo`07g`03o`0000L000?o0000
1@000ol0000400?o20000ol000060003o`0000D000?o00001@02o`P000?o00002@0000X000?ogml0
4=l2oaCO00?ogml04]l00ol0000A0003o`00018000?o00004@000ol0000A0003omoO00CO00?ogml0
1]l2o`OO00?ogml01ml00ooOg`04g`03omoo00OO00?o000010001?l00?l70003o`0000@000?o0000
20000ol000070003o`0000@000?o000010001?l00?l70003o`0000T0000:0003omoO013O0_lDg`03
omoO01;O00?o00004@000ol0000B0003o`00014000?o00004@000ooOg`03g`;o2=l2o`KO0_l9g`03
omoO00GO0_l7g`03o`0000D00_l80003o`0000@01?l70003o`0000@01?l60003o`0000D00_l80003
o`0000T0000:0003omoO013O0_lDg`03omoO01;O00?o00004@000ol0000B0003o`00014000?o0000
4@000ooOg`0=g`;o4Ml00ooOg`0>g`03o`0000l000?o00003`000ol0000>0003o`0000l000?o0000
2@0000T0OOlC0003omoO00gO0_lAg`03omoO00kO00?o00003`000ol0000?0003o`0000h000?o0000
3`000ol0000900002@1moa<000?ogml03Ml2oa7O00?ogml03]l00ol0000?0003o`0000l000?o0000
3P000ol0000?0003o`0000T0000:0003o`0000l00olDg`03omoO01;O00?o00004@000ol0000B0003
o`00014000?o00004@000ooOg`0=g`;o4Ml00ooOg`0>g`03o`0000l000?o00003`000ol0000>0003
o`0000l000?o00002@0000X000?o00003P001?l0oolDg`03omoO01;O00?o00004@000ol0000B0003
o`00014000?o0000401mo`/0000:0003o`0000d000?o00000_lDg`03omoO01;O00?o00004@000ol0
000B0003o`00014000?o0000401mo`/0000:0004o`0000;o00<0ool01P001?l00002oaCO00?ogml0
4]l00ol0000A0003o`00018000?o00004@000ol0000A0003o`0000d00_lAg`03omoO00kO00?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ol000020003o`3o00H000?o0000
0P02oaCO00?ogml04]l00ol0000A0003o`00018000?o00004@000ol0000A0003o`0000`00olAg`03
omoO00kO00?o00003`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ol000030003
o`0000@000?o00000`02oaCO00?ogml04]l00ol0000A0003o`00018000?o00004@000ol0000A0003
o`0000;o00<0ool01P001?l0oolAg`03omoO00kO00?o00003`000ol0000?0003o`0000h000?o0000
3`000ol0000900002P000ol000020003o`3o00@000?o00001002o`WO0_l9g`03omoO00GO0ol:g`03
o`0000D00ol90003o`0000H01?l80003o`0000H00ol80003o`00014000Oo0000o`3o00H000?o0000
0_lAg`03omoO00kO00?o00003`000ol0000?0003o`0000h000?o00003`000ol0000900002P001?l0
0002o`030?oo008000?o00001@02o`SO00Cogmoo2=l00ooOg`08g`03omoO00OO00?o00001P000ol0
00080003o`0000L000?o000020000ol000070003o`0000L000?o00004@000ol000020003o`0000@0
00Co00000_lAg`03omoO00kO00?o00003`000ol0000?0003o`0000h000?o00003`000ol000090000
2P000ol000070003o`3o00;o1002o`SO00Cogmoo2=l00ooOg`08g`03omoO00OO00?o00001P000ol0
00080003o`0000P000?o00001`000ol0000500Co20000ol0000A0007o`000?l0o`040003o`000080
0_l6g`?o2=l00ooOg`05g`?o1]l00ol0000400Co1`000ol0000400?o20000ol000050003o`0000H0
00?o00001@02o`P000?o00002@0000X000?o00001P001Ol0003o00D00_l8g`04omoOo`SO00?ogml0
1]l2o`[O00?o00001P000ol000080003o`0000T000?o00001P000ol000050003o`3o00T000?o0000
4@000ol00002o`030?oo008000?o00000`02o`OO00?ogml01ml00ooOg`06g`03omoO00GO00?o0000
1@000ol000070003o`0000L000?o00001@000ol000050003o`0000H000?o000010001?l00?l70003
o`0000T0000:0003o`0000D000?o00000`000ol0000200;o2=l01?oOgol8g`03omoO00SO00?ogml0
1ml00ol000060003o`0000P000?o00001P001?l00?l80003o`0000D000?o0?l02@000ol0000A0003
o`0000H01?l300;o1ml00ooOg`07g`03omoO00CO1?l6g`03o`0000H000?o00001P000ol000070003
o`0000D000?o00001P000ol000050003o`0000@000Co003o1`000ol0000900002P000ol000040003
o`0000@000?o00000P02o`WO0_l9g`03omoO00GO0ol:g`03o`0000D00_l:0003o`0000L00_l90003
o`0000H00_l90003o`00014000?o00001@001?l00?l400;o1ml00ooOg`07g`03omoO00CO00?ogol0
1ml00ol000070003o`0000D000?o00001003o`P000?o00001P000ol000050003o`0000D00_l80003
o`0000T0000:0003o`0000<000?o000010000ol0o`0300;o5=l00ooOg`0Bg`03o`00014000?o0000
4P000ol0000A0003o`00014000?o000010000ol000020004o`0000;o1ml00ooOg`07g`03omoO00CO
00?ogol01ml00ol000040004o`00o`L000?o000010000ol000080003o`0000L000?o000010000ol0
00040004o`00o`L000?o00002@0000X000?o00000P000ol000050003o`3o00<00_lDg`03omoO01;O
00?o00004@000ol0000B0003o`00014000?o00004@000ol000030003o`0000<000Co00000_l6g`;o
2Ml00ooOg`05g`;o1ml00ol0000500;o20000ol0000400Co1`000ol0000400Co1P000ol0000500;o
20000ol0000900002P001Ol0003o00L00_l00`3oo`0200;o5=l00ooOg`0Bg`03o`00014000?o0000
4P000ol0000A0003o`00014000?o00000P000ol000030003o`3o00800_lAg`03omoO00kO00?o0000
3`000ol0000?0003o`0000h000?o00003`000ol0000900002P001?l00?l?00;o5=l00ooOg`0Bg`03
o`00014000?o00004P000ol0000A0003o`00014000Go0000o`060003o`3o00800_lAg`03omoO00kO
00?o00003`000ol0000?0003o`0000h000?o00003`000ol0000900002P000ol0o`0@00;o5=l00ooO
g`0Bg`03o`00014000?o00004P000ol0000A0003o`00014000Co003o1P02o`040?oo00;o4Ml00ooO
g`0>g`03o`0000l000?o00003`000ol0000>0003o`0000l000?o00002@0000X00_lA00;o5=l00ooO
g`0Bg`03o`00014000?o00004P000ol0000A0003o`00014000?o0?l03@02oa7O00?ogml03]l00ol0
000?0003o`0000l000?o00003P000ol0000?0003o`0000T0000:07co4`02o`h00_lAg`03omoO00kO
00?o00003`000ol0000?0003o`0000h000?o00003`000ol0000900007@02ogX0O?l;0000Z@02ogD0
003o0240003o0240003o0240002Q00;o2P02oed00olA00004P02o`X00_mM00?o8@000ol0000:0003
o`0005`000?o00004000018000?o00002P000ol0001L0003o`0001X00_l40003o`0000800ol50003
o`0004<00_l00`3oo`090003o`3o00T000?o00003`0000/01?l30003o`0000800ol50003o`0004<0
0_l00`3oo`0:0003o`0000P000?o000060001?l00?l30003o`0000D000?o00000P000ol000140003
o`3o00/000?o000020000ol0000?000030000ol0o`030003o`0000D000?o00000P000ol000140003
o`3o00/000?o000020000ol0000H0004o`00o`<000?o00000`03o`@000?o0000A@000ol0000800Go
1`000ol0o`0@000030000ol000030003o`0000D000?o00000P000ol000150003o`0000P01Ol70003
o`3o01T000Co003o0`000ol000020004o`00o`@000?o0000A0000ol0o`0;0003o`0000L000?o0?l0
400000d000?o00000P000ol0000200?o1@000ol000140003o`3o00/000?o00001`000ol0o`0I0004
o`00o`<000?o00000P001?l00?l40003o`0004<00_l00`3oo`0C00;o00<0ool03`0000/000?o0?l0
10000ol000020003o`0000D000?o0000@`02o`030?oo00X000?o00001P02o`030?oo01L00_l200;o
0P02o`@00_l400;oL@0000/01?l300;o0`04o`<00_oo0040003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {147.562, 0}} -> {-0.0535128, -0.0257991, 
  0.00734156, 0.00734156}, {{7.25, 137}, {144, 3.5}} -> {-1.50361, -0.33559, 
  0.0485769, 0.0485769}, {{149.938, 279.688}, {144, 
  3.5}} -> {-9.66872, -0.431324, 0.0566481, 0.0566481}},
  CellTags->"Subgroups"],

Cell[BoxData[
    \({False, False}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual2", "MR"],
  " mode requires that the subset be a subgroup to illustrate its \
visualization."
}], "MathCaption",
  CellTags->{"Subgroups", "i:8"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[{{{0, 3}, Z[5]}, \ {{1, 4, \ 7}, U[9]}}, \ 
      Mode\  \[Rule] \ Visual2]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(MemberQ::"sbgrp" \( : \ \) 
      "\!\({0, 3}\) is not a subgroup of \!\(\"Z[5]\"\)."\)], "Message",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("All the elements marked with yellow are elements in the subgroup. The \
others are colored according to the various left cosets of the subgroup in \
the group."\)], "Print",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5119 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0121882 0.47619 [
[ 0 0 0 0 ]
[ 1 .5119 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5119 L
0 .5119 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0121882 0.477324 0.499717 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.573214 0.47619 [
[ 0 0 0 0 ]
[ 1 1.075 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.075 L
0 1.075 L
closepath
clip
newpath
1 0 0 r
.015 w
[ ] 0 setdash
newpath
.5 .57321 .47619 0 365.73 arc
s
0 0 0 r
.16328 .2365 m
.83672 .90993 L
s
0 g
[(Graphics Error)] .5 .0256 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0121882 0.97619 0.499717 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
1 .5 0 r
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.70408 .84184 m
.70408 .97789 L
.84014 .97789 L
.84014 .84184 L
F
.84014 .84184 m
.84014 .97789 L
.97619 .97789 L
.97619 .84184 L
F
1 1 0 r
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
1 .5 0 r
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
.02381 .16156 m
.02381 .29762 L
.15986 .29762 L
.15986 .16156 L
F
.02381 .02551 m
.02381 .16156 L
.15986 .16156 L
.15986 .02551 L
F
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
1 .5 0 r
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.84014 .70578 m
.84014 .84184 L
.97619 .84184 L
.97619 .70578 L
F
1 1 0 r
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
1 .5 0 r
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
1 1 0 r
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
1 .5 0 r
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
1 1 0 r
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
1 .5 0 r
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
1 1 0 r
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.70408 .16156 m
.70408 .29762 L
.84014 .29762 L
.84014 .16156 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
1 .5 0 r
.15986 .02551 m
.15986 .16156 L
.29592 .16156 L
.29592 .02551 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
1 1 0 r
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(1)] .22789 .77381 0 0 Mshowa
[(4)] .36395 .77381 0 0 Mshowa
[(7)] .5 .77381 0 0 Mshowa
[(2)] .63605 .77381 0 0 Mshowa
[(8)] .77211 .77381 0 0 Mshowa
[(5)] .90816 .77381 0 0 Mshowa
[(4)] .22789 .63776 0 0 Mshowa
[(7)] .36395 .63776 0 0 Mshowa
[(1)] .5 .63776 0 0 Mshowa
[(8)] .63605 .63776 0 0 Mshowa
[(5)] .77211 .63776 0 0 Mshowa
[(2)] .90816 .63776 0 0 Mshowa
[(7)] .22789 .5017 0 0 Mshowa
[(1)] .36395 .5017 0 0 Mshowa
[(4)] .5 .5017 0 0 Mshowa
[(5)] .63605 .5017 0 0 Mshowa
[(2)] .77211 .5017 0 0 Mshowa
[(8)] .90816 .5017 0 0 Mshowa
[(2)] .22789 .36565 0 0 Mshowa
[(8)] .36395 .36565 0 0 Mshowa
[(5)] .5 .36565 0 0 Mshowa
[(4)] .63605 .36565 0 0 Mshowa
[(7)] .77211 .36565 0 0 Mshowa
[(1)] .90816 .36565 0 0 Mshowa
[(8)] .22789 .22959 0 0 Mshowa
[(5)] .36395 .22959 0 0 Mshowa
[(2)] .5 .22959 0 0 Mshowa
[(7)] .63605 .22959 0 0 Mshowa
[(1)] .77211 .22959 0 0 Mshowa
[(4)] .90816 .22959 0 0 Mshowa
[(5)] .22789 .09354 0 0 Mshowa
[(2)] .36395 .09354 0 0 Mshowa
[(8)] .5 .09354 0 0 Mshowa
[(1)] .63605 .09354 0 0 Mshowa
[(4)] .77211 .09354 0 0 Mshowa
[(7)] .90816 .09354 0 0 Mshowa
[(1)] .09184 .77381 0 0 Mshowa
[(4)] .09184 .63776 0 0 Mshowa
[(7)] .09184 .5017 0 0 Mshowa
[(2)] .09184 .36565 0 0 Mshowa
[(8)] .09184 .22959 0 0 Mshowa
[(5)] .09184 .09354 0 0 Mshowa
[(1)] .22789 .90986 0 0 Mshowa
[(4)] .36395 .90986 0 0 Mshowa
[(7)] .5 .90986 0 0 Mshowa
[(2)] .63605 .90986 0 0 Mshowa
[(8)] .77211 .90986 0 0 Mshowa
[(5)] .90816 .90986 0 0 Mshowa
[(U[9])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{288, 147.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T`P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@0003001?o/0000
<@000ol0003/00007`04o`801?l200Go00<0ool00_l200;o00@0ool01Ol200?o0P04o`L01Ol200Co
0P04o`<00ol200Co[`0001h000Go0000o`030003o`00008000Co003o0P001ol0003o0?l00P000ol0
00020005o`000?l00`000ol000020003o`0000H000?o000010000ol000030003o`00008000Go0000
o`020003o`000:l0000N0003o`3o00;o0`000ol0000200Co0P001ol0003o0?l00P000ol000020005
o`000?l01@04o`P000?o000010000ol000030003o`00008000Go0000o`020003o`0002P0O?l;0000
7P000ol0000500;o1P001?l00?l30003o`3o008000?o00000P001Ol0003o00<000?o0?l02`03o`@0
0_l400;o0`001Ol0003o00800_lY000@oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElAGa5O4ElAGa5O4ElA
GomO4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAo`0Ag`03omoO00kO00?ogml03ml00ol0
000900007P001Ol0003o00800_l00`3oo`0200?o00<0ool00ol200Co0`02o`@01?l00`3oo`02o`P0
00?o00000`02o`040?oo00;o00<0ool00P03o`800_l00`3oo`0W0003oa4A00dA0_lA4@03oa4A00hA
00?o4A403a400ooOg`0?g`03omoO00kO00?ogml03ml00ol0000900007`04oa@000?o00006P05od00
013o4ElAGa5O4ElAGa5O4ElA0_l0=ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa7o4ElA
Ga5O4ElAGa5O4ElAGa7o017O00?ogml03]l00ooOg`0?g`03o`0000T0000f00;o1`000ol0001G0003
oa4A00dA0_lA4@03oa4A00hA00?o4A403a400ooOg`0?g`03omoO00kO00?ogml03ml00ol000090000
V@004?lAGa5O4ElAGa5O4ElAGa42o`0eGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4OlA
Ga5O4ElAGa5O4ElAGa5O4Ol04Ml00ooOg`0>g`03omoO00oO00?o00002@0009T000?o4A403A42oa4A
00?o4A403Q400olA4@0?4@03omoO00oO00?ogml03]l00ooOg`0?g`03o`0000T0002I0006oa5O4ElA
0ol01a5O4ElAGa400_l01UlAGa5O4@?o00lAGa5O4ElAGomO4ElAGa401?l03UlAGa5O4OlAGa5O4ElA
0_l02ElAGa5O4ElAo`06g`?o2=l00ooOg`05g`?o1]l00ooOg`05g`03omoO00OO00?o00002@0009T0
00?o4A401Q400olA4@044@;o2A400olA4@054@03oa4A00DA00?o4A401Q400olA4@044@04oa4Ao`LA
00?ogml01Ml00ooOg`07g`03omoO00KO00?ogml01Ml00ooOg`05g`03omoO00OO00?o00002@000480
32=;000@oa5O4ElAGa5OoelAGa5O4@;o03EO4ElAGa5O4EooGa5O4ElAGomO4ElAGa5O4OlAGa5O4ElA
oa5O4ElAGomO4OlAGa5O4ElAo`07g`03omoO00OO00?ogml01=l4o`KO00?ogml01]l00ooOg`06g`03
o`0000T0000l00HS30078d@000?o4A400a43o`LA0_l64@?o21400olA4@074@03oa4A00@A00?o4A40
1A42o`PA00?ogml01Ml00ooOg`07g`03omoO00CO00?ogol01ml00ooOg`06g`03omoO00KO00?o0000
2@0003T00b<I00<S@@004?lAGa5O4OlAGa5O4ElAGa42o`0eGa5O4ElAoa5O4ElAGa5O4EooGa5O4ElA
oa5OoelAGa5O4OlAGa5O4EooGa7o4ElAGa5O4Ol01ml00ooOg`07g`03omoO00CO00?ogol01ml00ooO
g`07g`03omoO00GO00?o00002@0003<01R<O00HS>`000olA4@034@Co1Q42o`HA1?l74@03oa4A00DA
0_l74@03oa4A00DA0_l84@03omoO00CO0_l9g`03omoO00GO0_l7g`03omoO00CO1?l7g`03o`0000T0
000`00<S:`028cT0013o4ElAGa5O4ElAGa5O4ElA0_l0=ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElA
Ga5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa7o017O00?ogml03]l00ooOg`0?g`03o`0000T0000_0003
8`0002h000<S0000=P000olA4@0=4@;o4A400olA4@0>4@03oa4A00lA00?ogml03ml00ooOg`0>g`03
omoO00oO00?o00002@0002d00R<b00<S=@004?lAGa5O4ElAGa5O4ElAGa42o`0eGa5O4ElAGa5O4ElA
Ga5O4EooGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4Ol04Ml00ooOg`0>g`03omoO00oO
00?o00002@0002X00b<g00<S<P000olA4@0=4@;o4A400olA4@0>4@03oa4A00lA00?ogml03ml00ooO
g`0>g`03omoO00oO00?o00002@0002P00R<m00038`0002l0013o4ElAGa5O4ElAGa5O4ElA0_l0=ElA
Ga5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa7o017O00?ogml0
3]l00ooOg`0?g`03o`0000T0000W00038`0003h000<S0000;P1lo`/0000V00038`0004000R<^000@
oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAoa5O4ElA
Ga5O4ElAGa5O4ElAo`0Ag`03omoO00kO00?ogml03ml00ol0000900009@000b<0001300038`0002/0
00?o4A403A42oa4A00?o4A403Q400olA4@0?4@03omoO00oO00?ogml03]l00ooOg`0?g`03o`0000T0
000S008SA`000b<0000Z000@oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElAGa5O4ElAGa5O4ElAGomO4ElA
Ga5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAo`0Ag`03omoO00kO00?ogml03ml00ol000090000
8P000b<0001800038`0002T000?o4A403A42oa4A00?o4A403Q400olA4@0?4@03omoO00oO00?ogml0
3]l00ooOg`0?g`03o`0000T0000Q00038`0004X00R<Y000@oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElA
Ga5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAo`0Ag`03omoO00kO
00?ogml03ml00ol00009000080000b<0001=00038`0002H000?o4A403A42oa4A00?o4A403Q400olA
4@0?4@03omoO00oO00?ogml03]l00ooOg`0?g`03o`0000T0000O00038`0004l000<S00009@001olA
Ga5O4El00_l01a5O4ElAGa400_l01elAGa5O4El00_l03a5O4ElAGa5OoelAGa5O4@03o`0>4ElAGa5O
4OlAGa5O4El4o`084ElAGa5O4Ol7g`03omoO00OO00?ogml01=l3o`OO00?ogml01Ml3o`OO00?o0000
2@0001h000<S0000D@000b<0000T0003oa4A00<A00Co4A7o1Q42o`HA00Co4A7o1a400olA4@074@03
oa4A00@A00?o4A401A400olA4@074@03omoO00GO00?ogml01ml00ooOg`05g`03omoO00KO00?ogml0
1]l00ooOg`06g`03o`0000T0000L0003ob<005@000<S00008`004?lAGa5O4OlAGomO4ElAGa42o`0e
Ga5O4ElAoa5OoelAGa5O4EooGa5O4ElAGa5OoelAGa5O4OlAGa5O4ElAGomO4ElAGa5O4Ol02=l00ooO
g`06g`03omoO00GO00?ogml01]l00ooOg`04g`Co1ml00ol0000900006`000b?o001F00038`000280
00?o4A401142o`LA0_l74@;o21400olA4@044@?o1a400olA4@074@03oa4A00DA00?ogml01]l00ooO
g`06g`03omoO00GO00?ogml01]l00ooOg`04g`03omoo00SO00?o00002@0001X000@S003oE`000b<0
000Q000@oa5O4ElAoa5OoelAGa5O4@;o03EO4ElAGa7o4EooGa5O4ElAGomO4ElAGa7o4ElAGa5O4ElA
oa5O4ElAGomO4OlAGa5O4ElAo`09g`03omoO00GO00?ogml01Ml00ooOg`06g`03omoO00CO00?ogol0
2=l00ol0000900006@000b<000020003o`0005D000<S000080000olA4@044@;o1a42o`LA0_l84@03
oa4A00@A1?l64@03oa4A00DA0_l84@03omoO00CO1?l7g`03omoO00CO0_l8g`03omoO00GO0_l8g`03
o`0000T0000H00038`0000@000?o0000E@000b<0000O000@oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElA
Ga5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAo`0Ag`03omoO00kO
00?ogml03ml00ol00009000060000b<000050003o`0005@000<S00007`000olA4@0=4@;o4A400olA
4@0>4@03oa4A00lA00?ogml03ml00ooOg`0>g`03omoO00oO00?o00002@0001L000<S00001`000ol0
001D00038`0001h0013o4ElAGa5O4ElAGa5O4ElA0_l0=ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElA
Ga5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa7o017O00?ogml03]l00ooOg`0?g`03o`0000T0000F0003
8`0000T000?o0000E0000b<0000M0003oa4A00dA0_lA4@03oa4A00hA00?o4A403a400ooOg`0?g`03
omoO00kO00?ogml03ml00ol0000900005P000b<0000:0003o`0005@000<S0000701lo`/0000E0003
8`0000`000?o0000E0000b<0000K0003oa4A00dA0_lA4@03oa4A00hA00?o4A403a400ooOg`0?g`03
omoO00kO00?ogml03ml00ol0000900005@000b<0000=0003o`0005<000<S00006`004?lAGa5O4ElA
Ga5O4ElAGa42o`0eGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElA
Ga5O4Ol04Ml00ooOg`0>g`03omoO00oO00?o00002@0001@000<S00003`000ol0001C00038`0001X0
00?o4A403A42oa4A00?o4A403Q400olA4@0?4@03omoO00oO00?ogml03]l00ooOg`0?g`03o`0000T0
000C00038`00014000?o0000DP000b<0000J000@oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElAGa5O4ElA
Ga5O4ElAGomO4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAo`0Ag`03omoO00kO00?ogml0
3ml00ol0000900004P000b<0000C0003o`00058000<S00006@000olA4@0=4@;o4A400olA4@0>4@03
oa4A00lA00?ogml03ml00ooOg`0>g`03omoO00oO00?o00002@00014000<S00005@000ol0001B0003
8`0001P0013o4ElAGa5O4ElAGa5O4ElA0_l0=ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElA
Ga7o4ElAGa5O4ElAGa5O4ElAGa7o017O00?ogml03]l00ooOg`0?g`03o`0000T0000A00038`0001H0
00?o0000D@000b<0000H0003oa4A00<A1?l64@;o1Q44o`LA00?o4A401A42o`LA00?o4A401143o`PA
00?ogml01Ml3o`OO00?ogml01Ml00ooOg`06g`03omoO00CO0ol8g`03o`0000T0000@00038`0001P0
00?o0000D@000b<0000G000@oa5O4ElAGomO4ElAGa5O4@;o03EO4ElAGa5OoelAGa5O4ElAGomO4ElA
Ga7o4EooGa5O4ElAoa5O4ElAGa5O4OlAGa5O4ElAo`08g`03omoO00KO00?ogml01Ml00ooOg`06g`03
omoO00GO00?ogml01ml00ol00009000040000b<0000I0003o`00050000<S00005`000olA4@054@03
oa4A00DA0_l84@03oa4A00HA00?o4A4011401?lA4Ol64@03oa4A00LA00?o4A401A400ooOg`04g`Co
1ml00ooOg`06g`03omoO00GO00?ogml01Ml00ooOg`07g`03o`0000T0000@00038`0001X000?o0000
C`000b<0000G000@oa5O4ElAGa5OoelAGa5O4@;o01UO4ElAGa5O4EooGa5O4ElAGomO4ElAGa5O00;o
00hAGa5O4ElAoa5O4ElAG`?o00UO4ElAGa5O4Ol01]l00ooOo`08g`03omoO00KO00?ogml01Ml00ooO
g`05g`03omoO00OO00?o00002@0000l000<S000070000ol0001?00038`0001H000?o4A400a401?lA
4Ol64@;o1Q401?lA4Ol74@03oa4A00@A00Co4A7o1Q400olA4@044@03oa4A00PA00?ogml01=l00ooO
o`08g`03omoO00OO00?ogml01=l00ooOg`05g`03omoO00OO00?o00002@0000l000<S00007@000ol0
001?00038`0001D000Oo4ElAGa5O00;o00LAGa5O4ElA00;o00MO4ElAGa5O00;o010AGa5O4ElAGomO
4ElAGa5O0_l03Q5O4ElAGa7o4ElAGa5O1?l0215O4ElAGa7o1ml2o`SO00?ogml01=l4o`KO00?ogml0
1=l2o`WO00?o00002@0000l000<S00007P000ol0001>00038`0001D000?o4A403A42oa4A00?o4A40
3Q400olA4@0?4@03omoO00oO00?ogml03]l00ooOg`0?g`03o`0000T0000>00038`00020000?o0000
CP000b<0000D000@oa5O4ElAGa5O4ElAGa5O4@;o03EO4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElA
Ga5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAo`0Ag`03omoO00kO00?ogml03ml00ol0000900003P000b<0
000Q0003o`0004d000<S000050000olA4@0=4@;o4A400olA4@0>4@03oa4A00lA00?ogml03ml00ooO
g`0>g`03omoO00oO00?o00002@0000h000<S00008P000ol0001<00038`0001@0013o4ElAGa5O4ElA
Ga5O4ElA0_l0=ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElA
Ga7o017O00?ogml03]l00ooOg`0?g`03o`0000T0000=00038`0002@000?o0000C0000b<0000C0003
oa4A00dA0_lA4@03oa4A00hA00?o4A403a400ooOg`0?g`03omoO00kO00?ogml03ml00ol000090000
3@000b<0000U0003o`0004/000<S00004`1lo`/0000=00038`0002H000?o0000BP000b<0000C0003
omoO00gO0_lAg`03omoO00kO00?ogml03ml00olA4@0?4@03oa4A00hA00?o4A403a400ol000090000
30000b<0000X0003o`0004X000<S00004P000ooOg`0=g`;o4Ml00ooOg`0>g`03omoO00oO03Ko4ElA
Ga5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGol;000030000b<0
000Y0003o`0004T000<S00004P000ooOg`0=g`;o4Ml00ooOg`0>g`03omoO00oO00?o4A403a400olA
4@0>4@03oa4A00lA00?o00002@0000`000<S0000:P000ol0001800038`00018000?ogml03Ml2oa7O
00?ogml03]l00ooOg`0?g`0foa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4EooGa5O4ElA
Ga5O4ElAGa5O4Eoo2`0000/000<S0000;0000ol0001700038`00018000?ogml03Ml2oa7O00?ogml0
3]l00ooOg`0?g`03oa4A00lA00?o4A403Q400olA4@0?4@03o`0000T0000;00038`0002d000?o0000
AP000b<0000B0003omoO00gO0_lAg`03omoO00kO00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlA
Ga5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5Oo`/0000;00038`0002h000?o0000A@000b<0
000B0003omoO00CO00?ogml01]l2o`OO00?ogml01ml00ooOg`04g`?o1ml00ooOg`05g`?o1ml00olA
4@044@?o21400olA4@044@Co1Q400olA4@054@;o21400ol0000900002`000b<0000_0003o`0004@0
00<S00004P000ooOg`04g`03omoO00KO0_l7g`03omoO00OO00?ogml01Ml00ooOg`06g`03omoO00KO
00?ogml01]l0=_lAGa5O4ElAGa7o4ElAGa5O4OlAGa5O4ElAoa5O4ElAGa5OoelAGa5O4OlAGomO4ElA
Ga5Oo`/0000;00038`00030000?o0000A0000b<0000A0003omoO00GO00?ogml01Ml2o`SO00?ogml0
1]l00ooOg`05g`03omoO00KO00?ogml01=l4o`OO00?o4A401a400olA4@054@03oa4A00HA00?o4A40
1A400olA4@044@04oa4Ao`LA00?o00002@0000X000<S0000<P000ol0001300038`00014000?ogml0
1Ml00ooOg`05g`;o2=l00ooOg`06g`03omoO00GO00?ogml01]l00ooOg`04g`03omoo00SO00Oo4ElA
Ga5O00?o025O4ElAGa5O4OlAGa5O4ElAGa7o4ElAGa5OoelAGa5O4El00_l02A5O4ElAGa5Oo`0;0000
2P000b<0000c0003o`00048000<S00004@000ooOg`06g`03omoO00CO0_l9g`03omoO00GO00?ogml0
1Ml00ooOg`06g`03omoO00CO00?ogol02=l00olA4@044@03oa4A00PA00?o4A4011401?lA4Ol64@03
oa4A00@A00Co4A7o1a400ol0000900002P000b<0000d0003o`00044000<S00004@000ooOg`03g`Co
1]l2o`KO1?l7g`03omoO00CO0_l8g`03omoO00GO0_l8g`07oa5O4ElAG`04o`0?4ElAGa5O4OlAGa5O
4ElA00;o00mO4ElAGa5OoelAGa5O4El00_l02A5O4ElAGa5Oo`0;00002P000b<0000e0003o`000400
00<S00004@000ooOg`0=g`;o4Ml00ooOg`0>g`03omoO00oO00?o4A403a400olA4@0>4@03oa4A00lA
00?o00002@0000X000<S0000=P000ol0000o00038`00014000?ogml03Ml2oa7O00?ogml03]l00ooO
g`0?g`0foa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4Eoo
2`0000X000<S0000=`000ol0000n00038`00014000?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`03
oa4A00lA00?o4A403Q400olA4@0?4@03o`0000T0000:00038`0003P000?o0000?@000b<0000A0003
omoO00gO0_lAg`03omoO00kO00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElA
Ga5OoelAGa5O4ElAGa5O4ElAGa5Oo`/0000:00038`0003T000?o0000?0000b<0000A0003omoO00gO
0_lAg`03omoO00kO00?ogml03ml00olA4@0?4@03oa4A00hA00?o4A403a400ol0000900002P000b<0
000j0003o`0003/000<S00004@1lo`/0000:00038`0003/000?o0000>P000b<0000A0003omoO00gO
0_lAg`03omoO00kO00?ogml03ml00olA4@0?4@03oa4A00hA00?o4A403a400ol0000900002P000b<0
000l0003o`0003T000<S00004@000ooOg`0=g`;o4Ml00ooOg`0>g`03omoO00oO03Ko4ElAGa5O4ElA
Ga5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGol;00002P000b<0000m0003
o`0003P000<S00004@000ooOg`0=g`;o4Ml00ooOg`0>g`03omoO00oO00?o4A403a400olA4@0>4@03
oa4A00lA00?o00002@0000X000<S0000?P000ol0000g00038`00014000?ogml03Ml2oa7O00?ogml0
3]l00ooOg`0?g`0foa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElA
Ga5O4Eoo2`0000X000<S0000?`000ol0000f00038`00014000?ogml03Ml2oa7O00?ogml03]l00ooO
g`0?g`03oa4A00lA00?o4A403Q400olA4@0?4@03o`0000T0000:00038`00040000?o0000=@000b<0
000A0003omoO00gO0_lAg`03omoO00kO00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElA
Ga5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5Oo`/0000:00038`00044000?o0000=0000b<0000A0003
omoO00CO0ol6g`;o1ml3o`OO00?ogml01Ml00ooOg`06g`03omoO00CO0ol8g`03oa4A00DA0_l84@03
oa4A00@A0ol74@03oa4A00@A1?l74@03o`0000T0000:00038`00048000?o0000<`000b<0000A0003
omoO00GO00?ogml01Ml2o`SO00?ogml01]l00ooOg`05g`03omoO00KO00?ogml01Ml00ooOg`07g`0f
oa5O4ElAGomO4OlAGa5O4ElAoa5O4ElAGa5O4OlAGa5O4EooGa5O4ElAGomO4ElAGa5O4Eoo2`0000/0
00<S0000@P000ol0000b00038`00014000?ogml00ml4o`KO0_l6g`Co1ml00ooOg`06g`03omoO00GO
00?ogml01Ml00ooOg`07g`03oa4A00@A00Co4A7o1a400olA4@074@03oa4A00@A00?o4A401Q400olA
4@064@03o`0000T0000;00038`0004<000?o0000<@000b<0000A0003omoO00?O00?ogol01ml2o`KO
00?ogol02=l00ooOg`06g`03omoO00GO00?ogml01Ml00ooOg`07g`08oa5O4ElAGa42o`0?Ga5O4ElA
Ga7o4ElAGa5O00?o01YO4ElAGa5OoelAGa5O4ElAGomO4ElAGa5Oo`/0000;00038`0004@000?o0000
;`000b<0000B0003omoO00?O00?ogol01ml2o`KO00?ogol02=l00ooOg`07g`03omoO00CO00?ogml0
1Ml00ooOg`07g`03oa4A00@A00Co4A7o1a400olA4@044@03oa4A00LA00?o4A4011401?lA4Ol74@03
o`0000T0000;00038`0004D000?o0000;P000b<0000B0003omoO00CO0_l7g`;o1ml2o`SO00?ogml0
1=l4o`KO00?ogml01=l2o`WO00So4ElAGa5O4@;o00mO4ElAGa5O4OlAGa5O4El01?l03Q5O4ElAGomO
4ElAGa5O0_l02A5O4ElAGa5Oo`0;00002`000b<000160003o`0002d000<S00004P000ooOg`0=g`;o
4Ml00ooOg`0>g`03omoO00oO00?o4A403a400olA4@0>4@03oa4A00lA00?o00002@0000`000<S0000
AP000ol0000/00038`00018000?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`0foa5O4ElAGa5O4ElA
Ga5O4ElAoa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4Eoo2`0000`000<S0000A`000ol0
000[00038`00018000?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`03oa4A00lA00?o4A403Q400olA
4@0?4@03o`0000T0000<00038`0004P000?o0000:P000b<0000B0003omoO00gO0_lAg`03omoO00kO
00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElA
Ga5Oo`/0000=00038`0004P000?o0000:0000b<0000C07co2`0000d000<S0000B@000ol0000W0003
8`0001<000?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`0foa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElA
Ga5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4Eoo2`0000d000<S0000BP000ol0000V00038`0001<0
00?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`03oa4A00lA00?o4A403Q400olA4@0?4@03o`0000T0
000>00038`0004X000?o000090000b<0000D0003omoO00gO0_lAg`03omoO00kO00?ogml03ml0=_lA
Ga5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5Oo`/0000>0003
8`0004/000?o00008`000b<0000D0003omoO00gO0_lAg`03omoO00kO00?ogml03ml00olA4@0?4@03
oa4A00hA00?o4A403a400ol0000900003P000b<0001<0003o`00028000<S000050000ooOg`0=g`;o
4Ml00ooOg`0>g`03omoO00oO03Ko4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGomO4ElA
Ga5O4ElAGa5O4ElAGol;00003`000b<0001<0003o`00020000<S00005@000ooOg`0=g`;o4Ml00ooO
g`0>g`03omoO00oO00?o4A403a400olA4@0>4@03oa4A00lA00?o00002@0000l000<S0000C@000ol0
000O00038`0001D000?ogml00ml3o`OO0_l6g`?o2=l00ooOg`05g`?o1]l00ooOg`05g`03omoO00OO
00Oo4ElAGa5O00Co00lAGa5O4ElAoa5O4ElAGa400_l03UlAGa5O4EooGa5O4ElA0ol02A5O4ElAGa5O
o`0;00003`000b<0001>0003o`0001h000<S00005@000ooOg`04g`03omoO00KO0_l7g`03omoO00OO
00?ogml01]l00ooOg`05g`03omoO00GO00?ogml01ml00olA4@054@03oa4A00LA00?o4A4011401?lA
4Ol64@03oa4A00LA00?o4A401A400ol00009000040000b<0001>0003o`0001`000<S00005P000ooO
g`04g`03omoO00KO0_l7g`03omoO00OO00?ogml01=l4o`KO00?ogml01]l00ooOg`06g`0foa5O4ElA
Ga5OoelAGa5O4ElAoa5O4ElAGomO4OlAGa5O4EooGa5O4ElAGa5OoelAGa5O4Eoo2`00010000<S0000
C`000ol0000J00038`0001L000?ogml01=l00ooOg`06g`;o1ml00ooOg`07g`03omoO00CO00?ogol0
1ml00ooOg`06g`03omoO00KO00?o4A401a400olA4@054@03oa4A00DA0_l74@03oa4A00@A0ol84@03
o`0000T0000@00038`00050000?o00006@000b<0000G0003omoO00CO00?ogml01]l2o`OO00?ogml0
1ml00ooOg`04g`03omoo00OO00?ogml01ml00ooOg`05g`0foa5O4ElAGomO4OlAGa5O4ElAoa5O4ElA
GomO4OlAGa5O4EooGa5O4ElAoa5O4ElAGa5O4Eoo2`00014000<S0000D0000ol0000G00038`0001P0
00?ogml00ml2o`SO0_l6g`;o2Ml00ooOg`05g`;o1ml00ooOg`04g`Co1ml00olA4@054@;o21400olA
4@054@;o1a400olA4@044@Co1a400ol0000900004@000b<0001A0003o`0001H000<S000060000ooO
g`0=g`;o4Ml00ooOg`0>g`03omoO00oO03Ko4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElA
GomO4ElAGa5O4ElAGa5O4ElAGol;00004P000b<0001A0003o`0001@000<S00006@000ooOg`0=g`;o
4Ml00ooOg`0>g`03omoO00oO00?o4A403a400olA4@0>4@03oa4A00lA00?o00002@0001<000<S0000
D@000ol0000B00038`0001X000?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`0foa5O4ElAGa5O4ElA
Ga5O4ElAoa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4Eoo2`0001<000<S0000DP000ol0
000A00038`0001X000?ogml03Ml2oa7O00?ogml03]l00ooOg`0?g`03oa4A00lA00?o4A403Q400olA
4@0?4@03o`0000T0000D00038`00058000?o00003`000b<0000K0003omoO00gO0_lAg`03omoO00kO
00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElA
Ga5Oo`/0000E00038`00058000?o00003P000b<0000J07go2`0001D000<S0000D`000ol0000<0003
8`0001/0OOl;00005P000b<0001C0003o`0000X000<S00007@000ol0000=00;o4Ml00ooOg`0>g`03
omoO00oO00?o4A403a400olA4@0>4@03oa4A00lA00?o00002@0001H000<S0000E0000ol000090003
8`0001d000?o00003003oa7O00?ogml03]l00ooOg`0?g`0foa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElA
Ga5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4Eoo2`0001L000<S0000E0000ol0000700038`0001h0
00?o00000_l00`3oo`060004o`3ooa7O00?ogml03]l00ooOg`0?g`03oa4A00lA00?o4A403Q400olA
4@0?4@03o`0000T0000H00038`0005@000?o00001@000b<0000O0007o`000?l0o`060003o`0000;o
4Ml00ooOg`0>g`03omoO00oO03Ko4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGomO4ElA
Ga5O4ElAGa5O4ElAGol;00006@000b<0001D0003o`0000<000<S000080000ol000020003o`0000@0
00Co00000_lAg`03omoO00kO00?ogml03ml00olA4@0?4@03oa4A00hA00?o4A403a400ol000090000
6P028eD000Go00008`0S0007o`000?l0o`040003o`0000800_l6g`?o2=l00ooOg`05g`?o1]l00ooO
g`05g`03omoO00OO00Oo4ElAGa5O00Co00lAGa5O4ElAoa5O4ElAGa400_l03UlAGa5O4EooGa5O4ElA
0ol02A5O4ElAGa5Oo`0;000070000b<0001C0003o`0S02@000?o00000_l00`3oo`0200?o0`02o`OO
00?ogml01ml00ooOg`06g`03omoO00GO00?ogml01Ml00ooOg`07g`03oa4A00DA00?o4A401a400olA
4@044@04oa4Ao`HA00?o4A401a400olA4@054@03o`0000T0000M00038`0005<000?o00008`000ol0
00060003o`3o00@00_l7g`03omoO00OO00?ogml01=l4o`KO00?ogml01]l00ooOg`06g`0foa5O4ElA
Ga5OoelAGa5O4ElAoa5O4ElAGomO4OlAGa5O4EooGa5O4ElAGa5OoelAGa5O4Eoo2`0001h000<S0000
D@000b<0000T0003o`0000D000Go0000o`0300;o1ml00ooOg`07g`03omoO00CO00?ogol01ml00ooO
g`06g`03omoO00KO00?o4A401a400olA4@054@03oa4A00DA0_l74@03oa4A00@A0ol84@03o`0000T0
000O00038`0004h00R<W0003o`0000@000?o00000P001?l00002o`OO00?ogml01ml00ooOg`04g`03
omoo00OO00?ogml01ml00ooOg`05g`0foa5O4ElAGomO4OlAGa5O4ElAoa5O4ElAGomO4OlAGa5O4Eoo
Ga5O4ElAoa5O4ElAGa5O4Eoo2`00020000<S0000C0000b<0000W0003o`0000<000?o00000P000ol0
o`0200;o1]l2o`WO00?ogml01Ml2o`OO00?ogml01=l4o`OO00?o4A401A42o`PA00?o4A401A42o`LA
00?o4A401144o`LA00?o00002@0002400R=;00038`0002P000?o00000P000ol000030003o`3o0080
0_lAg`03omoO00kO00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5OoelA
Ga5O4ElAGa5O4ElAGa5Oo`/0000S00038`0004L000<S0000:@001Ol0003o00D00_l0103oo`02oa7O
00?ogml03]l00ooOg`0?g`03oa4A00lA00?o4A403Q400olA4@0?4@03o`0000T0000T00038`0004@0
0R</0004o`00o``00_lAg`03omoO00kO00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElA
Ga5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5Oo`/0000U00038`00048000<S0000;0000ol0o`0=00;o
4Ml00ooOg`0>g`03omoO00oO00?o4A403a400olA4@0>4@03oa4A00lA00?o00002@0002H00b<o008S
;`02o`h00_lAg`03omoO00kO00?ogml03ml0=_lAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElA
Ga5OoelAGa5O4ElAGa5O4ElAGa5Oo`/0000Y00038`0003X00R<a07co2`0002X000<S0000>0000b<0
001100;oM@0002/00b<e008S^`0002h00b<_00<S_@0003400R<Z00<S`00003<000<S00009P000b<0
001200;o2P02oed00olA0000=0068ad01B=50003o`0000X000?o0000G0000ol0000@0000>P038aL0
0b=400;o10000ol0000200?o1@000ol0001300;o00<0ool02@000ol0o`090003o`0000l0000m00HS
2P078dH000Co003o0`000ol000050003o`00008000?o0000A0000ol0o`0;0003o`0000P000?o0000
3`0004<02R==0004o`00o`<000?o00000`03o`@000?o0000A@000ol0000800Go1`000ol0o`0@0000
VP001?l00?l30003o`00008000Co003o10000ol000140003o`3o00/000?o00001`000ol0o`0@0000
VP001?l00?l30003o`00008000Co003o10000ol0001300;o00<0ool04`02o`030?oo00l0002I00;o
0P02o`800_l400;o1002og40003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {146.375, 0}} -> {-0.0538863, -0.0256006, 
  0.00734416, 0.00734416}, {{7.3125, 137}, {142.875, 
  3.4375}} -> {-1.16842, -1.26063, 0.0161929, 0.0161929}, {{149.938, 
  279.625}, {142.875, 3.4375}} -> {-9.67282, -0.399688, 0.0566754, 
  0.0566754}},
  CellTags->"Subgroups"],

Cell[BoxData[
    \({False, True}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Although not every subset ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of a group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is a subgroup, the ",
  StyleBox["closure",
    FontSlant->"Italic"],
  " of every subset is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". "
}], "Text",
  CellTags->"Subgroups"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Closure",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subset",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["generated",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Closure",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(given\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["H",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["as",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["subset",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["elements",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  RowBox[{
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      RowBox[{
                        StyleBox["th",
                          SingleLetterItalics->False], "e"}]], " ", 
                    StyleBox["groupoid",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[\(\nG\),
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], " ", 
                  StyleBox[\(return\ the\ groupoid\),
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["generated",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["according",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["to",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["options",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["specified",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["opts",
                    FontSlant->"Italic"]}]}]}]},
          {
            RowBox[{
              StyleBox["SubgroupClosure",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Closure",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["G",
                        "TI"], 
                      StyleBox[",",
                        SingleLetterItalics->False], " ", 
                      StyleBox["H",
                        "TI"], 
                      StyleBox[",",
                        SingleLetterItalics->False], " ", 
                      StyleBox["opts",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Subgroups", "i:9"}],

Cell[TextData[{
  "Use of ",
  StyleBox["Closure",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Subgroups"],

Cell["\<\
Starting with the elements 1 and 4, we see that the element 7 is \
needed to complete the list before we have a subgroup.\
\>", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = \ Closure[U[9], \ {1, \ 4}]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{1, 4, 7}, Mod[#1\ #2, 9]&]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "We can confirm that this is indeed a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_9\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[\ G, U[9]]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "In addition to the standard ",
  StyleBox["Mode", "MR"],
  " option, several other options for this function are available."
}], "Text",
  CellTags->"Subgroups"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["ReportIterations",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", " ", 
                StyleBox["whether",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["results",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["each",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["iteration",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              
              StyleBox[\(should\ be\ reported, \ 
                in\ addition\ to\ the\ final\ closure\),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["Sort",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["closure",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sorted",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["output",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["Staged",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", ",", " ", 
                RowBox[{"when", " ", "the", " ", "mode", " ", "is", " ", 
                  StyleBox["Visual",
                    "MR"]}], ",", " ", \(whether\ the\)}], " ", "\n", 
              \(results\ of\ each\ iteration\ should\ be\ reported\ visually\ 
                one\ step\ at\ a\ time\ or\ all\ at\ once\)}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.18, 0.62},
  RowLines->{True, False}},
  CellTags->{"Subgroups", "i:10"}],

Cell[TextData[{
  "Options for ",
  StyleBox["Closure",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Subgroups"],

Cell[TextData[{
  "When ",
  StyleBox["ReportIterations", "MR"],
  " is set to ",
  StyleBox["True", "MR"],
  ", a list of the form {closure, number of iterations, result at each \
iteration} is returned."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Closure[Z[9], \ {1, \ 4}, \ ReportIterations\  \[Rule] \ True]\)], 
  "Input",
  CellLabel->"In[18]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1, 4, 2, 5, 8, 3, 6, 0, 7}, Mod[#1 + #2, 9]&], {
        3, {{1, 4}, {1, 4, 2, 5, 8}, {1, 4, 2, 5, 8, 3, 6, 0, 7}}}}\)], 
  "Output",
  CellLabel->"Out[18]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "When the option ",
  StyleBox["Sort", "MR"],
  " is set to ",
  StyleBox["True", "MR"],
  ", the elements are sorted by the ",
  StyleBox["Sort", "MR"],
  " function before being returned."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Closure[Z[9], \ {1, \ 4}, \ Sort\  \[Rule] \ True]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8}, Mod[#1 + #2, 9]&]\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "When the ",
  StyleBox["Visual", "MR"],
  " mode is used without ",
  StyleBox["Staged", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  ", a visualization for each iteration is returned, ready for animation, if \
desired."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupClosure[Symmetric[3], \ {{2, 3, 1}}, \ Mode\  \[Rule] \ Visual]
      \)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {2, 3, 1}, g2 \
\[Rule] {1, 2, 3}, g3 \[Rule] {1, 3, 2}, g4 \[Rule] {2, 1, 3}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 0 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g5)] .22789 .77381 0 0 Mshowa
[(g1)] .36395 .77381 0 0 Mshowa
[(g4)] .5 .77381 0 0 Mshowa
[(g6)] .63605 .77381 0 0 Mshowa
[(g2)] .77211 .77381 0 0 Mshowa
[(g3)] .90816 .77381 0 0 Mshowa
[(g1)] .22789 .63776 0 0 Mshowa
[(g2)] .36395 .63776 0 0 Mshowa
[(g3)] .5 .63776 0 0 Mshowa
[(g4)] .63605 .63776 0 0 Mshowa
[(g5)] .77211 .63776 0 0 Mshowa
[(g6)] .90816 .63776 0 0 Mshowa
[(g6)] .22789 .5017 0 0 Mshowa
[(g3)] .36395 .5017 0 0 Mshowa
[(g2)] .5 .5017 0 0 Mshowa
[(g5)] .63605 .5017 0 0 Mshowa
[(g4)] .77211 .5017 0 0 Mshowa
[(g1)] .90816 .5017 0 0 Mshowa
[(g3)] .22789 .36565 0 0 Mshowa
[(g4)] .36395 .36565 0 0 Mshowa
[(g1)] .5 .36565 0 0 Mshowa
[(g2)] .63605 .36565 0 0 Mshowa
[(g6)] .77211 .36565 0 0 Mshowa
[(g5)] .90816 .36565 0 0 Mshowa
[(g2)] .22789 .22959 0 0 Mshowa
[(g5)] .36395 .22959 0 0 Mshowa
[(g6)] .5 .22959 0 0 Mshowa
[(g3)] .63605 .22959 0 0 Mshowa
[(g1)] .77211 .22959 0 0 Mshowa
[(g4)] .90816 .22959 0 0 Mshowa
[(g4)] .22789 .09354 0 0 Mshowa
[(g6)] .36395 .09354 0 0 Mshowa
[(g5)] .5 .09354 0 0 Mshowa
[(g1)] .63605 .09354 0 0 Mshowa
[(g3)] .77211 .09354 0 0 Mshowa
[(g2)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[58]:=",
  ImageSize->{160.938, 172.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002P0000[0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000:00002P0000X0000:00000309[o0`0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0
000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<0
00?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00001003o`/00_l600?o30000ol0000400?o30000ol0
000300?o30000ol0000400?o30000ol0000400?o30000ol0000400?o30000ol0000100000`000ol0
00070003o`0000P00_l90003o`0000T000?o00001`000ol000090003o`0000H000?o00002@000ol0
00070003o`0000T000?o00001`000ol000090003o`0000L000?o00002@000ol0000100000`000ol0
000400Co0P02o`H00_l600Co0P03o`H000?o00001004o`800_l70003o`0000<01?l0103oool70003
o`0000@01?l0103oool70003o`0000@01?l0103oool70003o`0000@01?l00`3oo`02o`H000?o0000
0@0000<000?o00000`001ol0003o0?l00P000ol0000300;o1@001Ol0003o00<000?o00001@000ol0
00030007o`000?l0o`020003o`0000@000?o00000P001Ol0003o00@000?o000010000ol000030005
o`000?l00P000ol000060003o`0000<000Go0000o`040003o`0000@000?o00000`001Ol0003o0080
00?o00001P000ol0000100000`000ol000030007o`000?l0o`020003o`0000<00_l50006o`000?l0
1?l60003o`0000<000Oo0000o`3o008000?o000010000ol000020005o`000?l010000ol000040003
o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@000?o000010000ol000030005
o`000?l00`000ol000050003o`00004000030003o`0000<000Ko0000o`03o`H00_l50009o`000?l0
o`3o00L000?o00000`001_l0003o00?o1`000ol000020006o`000?l00ol70003o`0000<000Go0000
o`020003o`0000H000?o00000`001Ol0003o00800_l70003o`0000<000Go0000o`040003o`0000@0
00?o00000@0000<000?o00001006o`P00_l600Ko00<0o`001P000ol0000400Ko2@000ol0000300Ko
2@000ol0000400Go00<0o`001`000ol0000400Go0`000ol000040003o`0000@01_l20003o`0000@0
00?o00000@0000<000?o00002P03o`D00_l<00;o1`000ol0000:00?o1P000ol0000800Co1P000ol0
000900;o20000ol0000900?o1`000ol0000:00;o1`000ol0000100000`000ol0000B00;o5@000ol0
000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD0
00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000400?o2`02o`H0
0ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003o`0000@00ol<0003o`0000@0
0ol<0003o`00004000030003o`0000L000?o00002002o`T000?o00002@000ol000070003o`0000T0
00?o00001P000ol000090003o`0000L000?o00002@000ol000070003o`0000T000?o00001`000ol0
00090003o`00004000030003o`0000@01?l0103oool600;o1P04o`030?oo00;o1P000ol0000400Co
00@0oooo1`000ol0000300Co0P02o`L000?o00001004o`040?ooo`L000?o00001004o`040?ooo`L0
00?o00001004o`800ol60003o`00004000030003o`0000<000Go0000o`040003o`0000<00_l50005
o`000?l00P000ol000060003o`0000<000Go0000o`040003o`0000@000?o00000P001ol0003o0?l0
0P000ol000040003o`0000<000Go0000o`040003o`0000@000?o00000`001Ol0003o008000?o0000
1P000ol000030005o`000?l00`000ol000050003o`00004000030003o`0000<000Go0000o`040003
o`0000<00_l50005o`000?l00`000ol000050003o`0000<000Go0000o`040003o`0000@000?o0000
0P001ol0003o0?l00P000ol000040003o`0000<000Go0000o`040003o`0000@000?o00000`001Ol0
003o008000?o00001P000ol000030006o`000?l01?l60003o`00004000030003o`0000<000Ko0000
o`03o`H00_l50005o`000?l010000ol000040003o`0000<000Ko0000o`03o`L000?o00000P001_l0
003o00?o1`000ol000030005o`000?l00P02o`L000?o00000`001Ol0003o008000?o00001P000ol0
00030009o`000?l0o`3o00L000?o00000@0000<000?o00001006o`P00_l600Ko0P000ol000040003
o`0000@01_l90003o`0000<01_l90003o`0000@01Ol30003o`0000@000?o00001005o`030?l000L0
00?o00001006o`030?l000H000?o00000@0000<000?o00002@04o`D00_l<00;o1`000ol0000900Co
1P000ol0000900?o1P000ol0000900?o1`000ol0000900;o20000ol0000:00;o1`000ol000010000
0`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o0000
0@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003
o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o0000
4`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003
o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o0000
4`000ol0000C0003o`0001<000?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o0000
4`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003
o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o
5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0000
4P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003
o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol000010000
0`000ol0000400?o2`02o`H00ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003
o`0000@00ol<0003o`0000@00ol<0003o`00004000030003o`0000L000?o00002002o`T000?o0000
2@000ol000070003o`0000T000?o00001P000ol000090003o`0000L000?o00002@000ol000070003
o`0000T000?o00001`000ol000090003o`00004000030003o`0000@01?l200?o1@02o`H01?l0103o
ool70003o`0000@01?l200?o1P000ol0000300Co00@0oooo1`000ol0000400Co00<0ool00_l60003
o`0000@01?l200;o1`000ol0000400Co00@0oooo1`000ol0000100000`000ol000030005o`000?l0
0`000ol0000400;o1@001Ol0003o00@000?o000010000ol000030005o`000?l00`000ol000050003
o`00008000Go0000o`020003o`0000H000?o00000`001Ol0003o008000?o00001P000ol000030007
o`000?l0o`020003o`0000@000?o00000`001Ol0003o00@000?o000010000ol0000100000`000ol0
00030006o`000?l01?l500;o1@001Ol0003o00@000?o000010000ol000030006o`000?l01?l60003
o`00008000Go0000o`020003o`0000H000?o00000`001Ol0003o00<000?o00001@000ol000030007
o`000?l0o`020003o`0000@000?o00000`001Ol0003o00@000?o000010000ol0000100000`000ol0
00030009o`000?l0o`3o00H00_l50005o`000?l00P02o`L000?o00000`002Ol0003o0?l0o`070003
o`00008000Go0000o`020003o`0000H000?o00000`001Ol0003o00@000?o000010000ol000030006
o`000?l00ol70003o`0000<000Ko0000o`03o`L000?o00000@0000<000?o00001006o`030?l000D0
0_l600Go0`000ol000040003o`0000@01_l00`3o00060003o`0000<01Ol00`3o00070003o`0000@0
1_l20003o`0000@000?o00001006o`T000?o00001006o`T000?o00000@0000<000?o00002P02o`H0
0_l;00?o1`000ol0000:00;o1`000ol0000800;o20000ol0000:00;o1`000ol0000:00?o1P000ol0
000900Co1P000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`2Jo`<000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0
000C0003o`00004000030003o`0000@00ol;00;o1P03o``000?o00001003o``000?o00000`03o``0
00?o00001003o``000?o00001003o``000?o00001003o``000?o00000@0000<000?o00001`000ol0
000800;o2@000ol000090003o`0000L000?o00002@000ol000060003o`0000T000?o00001`000ol0
00090003o`0000L000?o00002@000ol000070003o`0000T000?o00000@0000<000?o00001004o`04
0?ooo`H00_l600Co0P02o`L000?o00001004o`040?ooo`L000?o00000`04o`030?oo00;o1P000ol0
000400Co00@0oooo1`000ol0000400Co0P03o`H000?o00001004o`040?ooo`L000?o00000@0000<0
00?o00000`001Ol0003o00@000?o00000`02o`D000Oo0000o`3o008000?o000010000ol000030005
o`000?l010000ol000040003o`00008000Go0000o`020003o`0000H000?o00000`001Ol0003o00@0
00?o000010000ol000030005o`000?l00`000ol000050003o`0000<000Go0000o`020003o`0000H0
00?o00000@0000<000?o00000`001Ol0003o00@000?o00000`02o`D000Oo0000o`3o008000?o0000
10000ol000030005o`000?l010000ol000040003o`00008000Go0000o`030003o`0000D000?o0000
0`001Ol0003o00@000?o000010000ol000030006o`000?l01?l60003o`0000<000Go0000o`020003
o`0000H000?o00000@0000<000?o00000`001Ol0003o00800_l600;o1@001_l0003o00?o1`000ol0
00030005o`000?l00P02o`L000?o00000P001Ol0003o00@000?o000010000ol000030006o`000?l0
0ol70003o`0000<000Wo0000o`3o0?l01`000ol000030005o`000?l00P000ol000060003o`000040
00030003o`0000@01Ol30003o`0000<00_l600Ko2@000ol0000400Go0`000ol000040003o`0000<0
1_l20003o`0000@000?o00001006o`T000?o00001006o`030?l000H000?o00001005o`030?l000L0
00?o00000@0000<000?o00002@03o`H00_l<00?o1P000ol0000900?o1`000ol0000900;o1`000ol0
000900Co1P000ol0000:00;o1`000ol0000900;o20000ol0000100000`000ol0000B00;o5@000ol0
000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD0
00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000400?o2`02o`H0
0ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003o`0000@00ol<0003o`0000@0
0ol<0003o`00004000030003o`0000L000?o00002002o`T000?o00002@000ol000070003o`0000T0
00?o00001P000ol000090003o`0000L000?o00002@000ol000070003o`0000T000?o00001`000ol0
00090003o`00004000030003o`0000@01?l00`3oo`02o`D00_l600Co00@0oooo1`000ol0000400Co
00<0ool00_l60003o`0000<01?l0103oool70003o`0000@01?l200?o1P000ol0000400Co00@0oooo
1`000ol0000400Co0P02o`L000?o00000@0000<000?o00000`001Ol0003o008000?o00001@02o`D0
00Go0000o`020003o`0000H000?o00000`001Ol0003o008000?o00001P000ol000020005o`000?l0
10000ol000040003o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o00@000?o0000
10000ol000030007o`000?l0o`020003o`0000@000?o00000@0000<000?o00000`001Ol0003o00<0
00?o00001002o`D000Go0000o`020003o`0000H000?o00000`001Ol0003o00<000?o00001@000ol0
00020005o`000?l010000ol000040003o`0000<000Ko0000o`04o`H000?o00000`001Ol0003o00@0
00?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000@0000<000?o00000`001Ol0
003o00@000?o00000`02o`D000Go0000o`020003o`0000H000?o00000`001Ol0003o00@000?o0000
10000ol000020005o`000?l00P02o`L000?o00000`002Ol0003o0?l0o`070003o`0000<000Ko0000
o`03o`L000?o00000`001_l0003o00?o1`000ol0000100000`000ol0000400Ko0P000ol0000300;o
1P05o`030?l000L000?o00001006o`8000?o000010000ol0000300Go0`000ol000040003o`0000@0
1_l00`3o00060003o`0000@01_l90003o`0000@01_l90003o`00004000030003o`0000X00_l600;o
2`02o`P000?o00002P02o`L000?o00002003o`L000?o00002P02o`L000?o00002@04o`H000?o0000
2P03o`H000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o0000
4`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003
o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o0000
4`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003
o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o0000
4P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o0000
4`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040000309[o0`0000<000?ogml0
4]l2oaDS00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003
omoO01;O0_lE8`03o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol000010000
0`000ooOg`0Bg`;o5B<00ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o0000
0@0000<000?ogml04]l2oaDS00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003omoO01;O0_lE8`03o`0001<000?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ooOg`0Bg`;o5B<00ol0000C0003o`00018000?o00004`000ol0000C0003
o`0001<000?o00000@0000<000?ogml01=l3o`_O0_l68`?o32<00ol0000400?o30000ol0000300?o
30000ol0000400?o30000ol0000400?o30000ol0000400?o30000ol0000100000`000ooOg`07g`03
omoO00SO0_l98`03ob<S00TS00?o00001`000ol000090003o`0000H000?o00002@000ol000070003
o`0000T000?o00001`000ol000090003o`0000L000?o00002@000ol0000100000`000ooOg`04g`Co
00COoooo1]l2o`HS1?l012?oool78`03o`0000@01?l0103oool70003o`0000<01?l200?o1P000ol0
000400Co0P02o`L000?o00001004o`030?oo00;o1P000ol0000400Co00@0oooo1`000ol000010000
0`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1B<01OlS8b?o00@S00?o8b<012<00ol000030005
o`000?l00P000ol000060003o`00008000Go0000o`030003o`0000D000?o00000`001ol0003o0?l0
0P000ol000040003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@000?o0000
10000ol0000100000`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1B<01OlS8b?o00@S00?o8b<0
12<00ol000030005o`000?l00P000ol000060003o`00008000Ko0000o`04o`H000?o00000`001ol0
003o0?l00P000ol000040003o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o00@0
00?o000010000ol0000100000`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1B<01_lS8b?o8`?o
1b<00ol000030005o`000?l00P000ol000060003o`00008000Wo0000o`3o0?l01`000ol000030006
o`000?l00ol70003o`0000<000Go0000o`040003o`0000@000?o00000`001Ol0003o00800_l70003
o`00004000030003omoO00CO1Ol00moog`06g`;o1R<6o`TS00?o00001005o`030?l000L000?o0000
0`06o`030?l000H000?o00001006o`T000?o00001006o`8000?o000010000ol0000400Go0`000ol0
00040003o`00004000030003omoO00WO0_l7g`;o2b<4o`HS00?o00002@02o`P000?o00002@02o`L0
00?o00002P03o`H000?o00002P02o`L000?o00002@03o`L000?o00000@0000<000?ogml04]l2oaDS
00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O
0_lE8`03o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ooO
g`0Bg`;o5B<00ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?ogml04]l2oaDS00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003omoO01;O0_lE8`03o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ooOg`0Bg`;o5B<00ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?ogml04]l2oaDS00?o00004`000ol0000B0003o`0001<000?o00004`000ol0
000C0003o`000040000209_o0`000080Vol300000`000ol0000A00?o5Ml00ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o000040001?l0oolEg`03o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000?0003o`0000;o
5Ml00ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0000
0P02o`030?oo00L000Co00000_lEg`03o`0001<000?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ol000030003o`3o00L000?o00000P02oaGO00?o00004`000ol0000B0003
o`0001<000?o00004`000ol0000C0003o`00004000030003o`0000@000?o00001@000ol0000300;o
1]l3o`cO00?o00001003o``000?o00000`03o``000?o00001003o``000?o00001003o``000?o0000
1003o``000?o00000@0000<000?o00000`000ol0o`050003o`0000@00_l9g`03omoO00WO00?o0000
1`000ol000090003o`0000H000?o00002@000ol000070003o`0000T000?o00001`000ol000090003
o`0000L000?o00002@000ol0000100000`000ol0000200;o00<0ool00`000ol0000500;o1]l4o`04
goooo`OO00?o00001004o`030?oo00;o1P000ol0000300Co00@0oooo1`000ol0000400Co0P03o`H0
00?o00001004o`040?ooo`L000?o00001004o`800_l70003o`00004000030003o`0000T000?o0000
1P02o`GO00GogmoOo`02g`03omoO00KO00?o00000`001Ol0003o008000?o00001P000ol000020005
o`000?l010000ol000040003o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o00@0
00?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000@0000<000?o000020000ol0
0003o`@00_l5g`05omoOgol00]l00ooOg`06g`03o`0000<000Go0000o`030003o`0000D000?o0000
0P001Ol0003o00@000?o000010000ol000030006o`000?l01?l60003o`0000<000Go0000o`040003
o`0000@000?o00000`001ol0003o0?l00P000ol000040003o`00004000030003o`0000L000?o0000
0P000ol0000300;o1Ml01OoOgmoo00;O00?ogml01]l00ol000030005o`000?l010000ol000040003
o`00008000Go0000o`0200;o1`000ol000030009o`000?l0o`3o00L000?o00000`001_l0003o00?o
1`000ol000030006o`000?l00ol70003o`00004000030003o`0000H000?o000010000ol0000200;o
1]l5o`03gooO00OO00?o00001006o`8000?o000010000ol0000300Go0`000ol000040003o`0000@0
1_l00`3o00060003o`0000@01_l90003o`0000@01_l90003o`00004000030003o`0000D000?o0000
1@000ol0000200;o2ml2o`SO00?o00002P02o`L000?o00002003o`L000?o00002P02o`L000?o0000
2@04o`H000?o00002P03o`H000?o00000@0000<000?o000010000ol000050003o`3o00<00_lEg`03
o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol000030003
o`0000H000?o0?l00`02oaGO00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003o`00008000?o00001P02o`030?oo00800_lEg`03o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`001Ol0003o01000_lEg`03o`0001<000?o0000
4P000ol0000C0003o`0001<000?o00004`000ol0000100000`001?l00?lA00;o5Ml00ol0000C0003
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0?l04P02oaGO00?o0000
4`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040000300;o4`02oaGO00?o0000
4`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040000309[o0`0001P00_n60000
X0000:00002P0000X00000/00_l:00;oN`03o`T0000;0003o`0000X000?o0000NP000ol000080000
1003o`@000?o00000P03o`D000?o0000H@02o`030?oo00T000?o0?l02@000ol00007000010001?l0
0?l30003o`0000D000?o00000P000ol0001R0003o`3o00/000?o000020000ol0000700001P02o`<0
00?o00001@000ol000020003o`0006<000?o00002005o`L000?o0?l0200000@00_l50003o`0000<0
0_l50003o`00068000?o0?l02`000ol000070003o`3o00P000040004o`00o`<000?o00001@000ol0
00020003o`0006400_l00`3oo`0C00;o00<0ool01`0000D00ol300;o0`03o`@00_n70000X0000001
\
\>"],
  ImageRangeCache->{{{0, 159.938}, {171.375, 0}} -> {-1.17504, -0.187842, 
  0.0459561, 0.0459561}},
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g2)] .22789 .77381 0 0 Mshowa
[(g3)] .36395 .77381 0 0 Mshowa
[(g1)] .5 .77381 0 0 Mshowa
[(g5)] .63605 .77381 0 0 Mshowa
[(g6)] .77211 .77381 0 0 Mshowa
[(g4)] .90816 .77381 0 0 Mshowa
[(g3)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g2)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g4)] .77211 .63776 0 0 Mshowa
[(g5)] .90816 .63776 0 0 Mshowa
[(g1)] .22789 .5017 0 0 Mshowa
[(g2)] .36395 .5017 0 0 Mshowa
[(g3)] .5 .5017 0 0 Mshowa
[(g4)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(g6)] .90816 .5017 0 0 Mshowa
[(g6)] .22789 .36565 0 0 Mshowa
[(g5)] .36395 .36565 0 0 Mshowa
[(g4)] .5 .36565 0 0 Mshowa
[(g3)] .63605 .36565 0 0 Mshowa
[(g2)] .77211 .36565 0 0 Mshowa
[(g1)] .90816 .36565 0 0 Mshowa
[(g4)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g2)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g4)] .36395 .09354 0 0 Mshowa
[(g6)] .5 .09354 0 0 Mshowa
[(g2)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g3)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[58]:=",
  ImageSize->{160.938, 172.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002P0000[0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000:00002P0000X0000:00000309[o0`0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0
000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<0
00?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00001003o`/00_l600?o30000ol0000400?o30000ol0
000300?o30000ol0000400?o30000ol0000400?o30000ol0000400?o30000ol0000100000`000ol0
00070003o`0000P00_l90003o`0000T000?o00001`000ol000090003o`0000H000?o00002@000ol0
00070003o`0000T000?o00001`000ol000090003o`0000L000?o00002@000ol0000100000`000ol0
000400Co0P02o`H00_l600Co00@0oooo1`000ol0000400Co0P03o`H000?o00000`04o`800_l70003
o`0000@01?l00`3oo`02o`H000?o00001004o`040?ooo`L000?o00001004o`040?ooo`L000?o0000
0@0000<000?o00000`001ol0003o0?l00P000ol0000300;o1@001Ol0003o00@000?o000010000ol0
00030005o`000?l00`000ol000050003o`00008000Oo0000o`3o008000?o000010000ol000030005
o`000?l00P000ol000060003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@0
00?o000010000ol0000100000`000ol000030007o`000?l0o`020003o`0000<00_l50005o`000?l0
10000ol000040003o`0000<000Ko0000o`04o`H000?o00000P001ol0003o0?l00P000ol000040003
o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o008000?o00001P000ol000030005
o`000?l010000ol000040003o`00004000030003o`0000<000Ko0000o`03o`H00_l50006o`000?l0
0ol70003o`0000<000Wo0000o`3o0?l01`000ol000020006o`000?l00ol70003o`0000<000Go0000
o`040003o`0000@000?o00000`001Ol0003o008000?o00001P000ol000030005o`000?l00P02o`L0
00?o00000@0000<000?o00001006o`P00_l600Ko2@000ol0000400Ko00<0o`001P000ol0000300Ko
2@000ol0000400Ko0P000ol000040003o`0000@01Ol00`3o00070003o`0000@01Ol30003o`0000@0
00?o00000@0000<000?o00002P03o`D00_l;00Co1P000ol0000:00;o1`000ol0000900?o1P000ol0
000:00;o1`000ol0000900;o20000ol0000900?o1`000ol0000100000`000ol0000B00;o5@000ol0
000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD0
00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000400?o2`02o`H0
0ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003o`0000@00ol<0003o`0000@0
0ol<0003o`00004000030003o`0000L000?o00002002o`T000?o00002@000ol000070003o`0000T0
00?o00001P000ol000090003o`0000L000?o00002@000ol000070003o`0000T000?o00001`000ol0
00090003o`00004000030003o`0000@01?l0103oool600;o1P04o`800ol60003o`0000@01?l200;o
1`000ol0000300Co00@0oooo1`000ol0000400Co00@0oooo1`000ol0000400Co00@0oooo1`000ol0
000400Co00<0ool00_l60003o`00004000030003o`0000<000Go0000o`040003o`0000<00_l50005
o`000?l00`000ol000050003o`0000<000Oo0000o`3o008000?o000010000ol000020005o`000?l0
10000ol000040003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@000?o0000
10000ol000030005o`000?l00P000ol000060003o`00004000030003o`0000<000Go0000o`040003
o`0000<00_l50006o`000?l01?l60003o`0000<000Oo0000o`3o008000?o000010000ol000020005
o`000?l010000ol000040003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@0
00?o000010000ol000030005o`000?l00`000ol000050003o`00004000030003o`0000<000Ko0000
o`03o`H00_l50009o`000?l0o`3o00L000?o00000`001_l0003o00?o1`000ol000020006o`000?l0
0ol70003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00800_l70003o`0000<0
00Go0000o`040003o`0000@000?o00000@0000<000?o00001006o`P00_l600Ko00<0o`001P000ol0
000400Ko2@000ol0000300Ko2@000ol0000400Go00<0o`001`000ol0000400Go0`000ol000040003
o`0000@01_l20003o`0000@000?o00000@0000<000?o00002@04o`D00_l<00;o1`000ol0000:00?o
1P000ol0000800Co1P000ol0000900;o20000ol0000900?o1`000ol0000:00;o1`000ol000010000
0`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o0000
0@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003
o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o0000
4`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003
o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o0000
4`000ol0000C0003o`0001<000?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o0000
4`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003
o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o
5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0000
4P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003
o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol000010000
0`000ol0000400?o2`02o`H00ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003
o`0000@00ol<0003o`0000@00ol<0003o`00004000030003o`0000L000?o00002002o`T000?o0000
2@000ol000070003o`0000T000?o00001P000ol000090003o`0000L000?o00002@000ol000070003
o`0000T000?o00001`000ol000090003o`00004000030003o`0000@01?l200?o1@02o`H01?l200;o
1`000ol0000400Co00@0oooo1`000ol0000300Co0P03o`H000?o00001004o`040?ooo`L000?o0000
1004o`030?oo00;o1P000ol0000400Co00@0oooo1`000ol0000100000`000ol000030005o`000?l0
0`000ol0000400;o1@001ol0003o0?l00P000ol000040003o`0000<000Go0000o`040003o`0000@0
00?o00000P001Ol0003o00<000?o00001@000ol000030005o`000?l010000ol000040003o`0000<0
00Go0000o`020003o`0000H000?o00000`001Ol0003o008000?o00001P000ol0000100000`000ol0
00030006o`000?l01?l500;o1@001ol0003o0?l00P000ol000040003o`0000<000Go0000o`040003
o`0000@000?o00000P001_l0003o00Co1P000ol000030005o`000?l010000ol000040003o`0000<0
00Go0000o`030003o`0000D000?o00000`001Ol0003o008000?o00001P000ol0000100000`000ol0
00030009o`000?l0o`3o00H00_l50006o`000?l00ol70003o`0000<000Ko0000o`03o`L000?o0000
0P002Ol0003o0?l0o`070003o`0000<000Go0000o`0200;o1`000ol000030005o`000?l010000ol0
00040003o`0000<000Go0000o`020003o`0000H000?o00000@0000<000?o00001006o`030?l000D0
0_l600Ko2@000ol0000400Ko2@000ol0000300Ko00<0o`001P000ol0000400Go0`000ol000040003
o`0000@01_l20003o`0000@000?o00001005o`030?l000L000?o00000@0000<000?o00002P02o`H0
0_l<00?o1P000ol0000900Co1P000ol0000900;o1`000ol0000900?o1`000ol0000:00;o1`000ol0
000900;o20000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`2Jo`<000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0
000C0003o`00004000030003o`0000@00ol;00;o1P03o``000?o00001003o``000?o00000`03o``0
00?o00001003o``000?o00001003o``000?o00001003o``000?o00000@0000<000?o00001`000ol0
000800;o2@000ol000090003o`0000L000?o00002@000ol000060003o`0000T000?o00001`000ol0
00090003o`0000L000?o00002@000ol000070003o`0000T000?o00000@0000<000?o00001004o`04
0?ooo`H00_l600Co00@0oooo1`000ol0000400Co00<0ool00_l60003o`0000<01?l0103oool70003
o`0000@01?l200?o1P000ol0000400Co00@0oooo1`000ol0000400Co0P02o`L000?o00000@0000<0
00?o00000`001Ol0003o00@000?o00000`02o`D000Go0000o`020003o`0000H000?o00000`001Ol0
003o008000?o00001P000ol000020005o`000?l010000ol000040003o`0000<000Go0000o`030003
o`0000D000?o00000`001Ol0003o00@000?o000010000ol000030007o`000?l0o`020003o`0000@0
00?o00000@0000<000?o00000`001Ol0003o00@000?o00000`02o`D000Go0000o`020003o`0000H0
00?o00000`001Ol0003o00<000?o00001@000ol000020005o`000?l010000ol000040003o`0000<0
00Ko0000o`04o`H000?o00000`001Ol0003o00@000?o000010000ol000030007o`000?l0o`020003
o`0000@000?o00000@0000<000?o00000`001Ol0003o00800_l600;o1@001Ol0003o008000?o0000
1P000ol000030005o`000?l010000ol000040003o`00008000Go0000o`0200;o1`000ol000030009
o`000?l0o`3o00L000?o00000`001_l0003o00?o1`000ol000030006o`000?l00ol70003o`000040
00030003o`0000@01Ol30003o`0000<00_l600Go00<0o`001`000ol0000400Ko0P000ol000040003
o`0000<01Ol30003o`0000@000?o00001006o`030?l000H000?o00001006o`T000?o00001006o`T0
00?o00000@0000<000?o00002@03o`H00_l;00;o20000ol0000:00;o1`000ol0000800?o1`000ol0
000:00;o1`000ol0000900Co1P000ol0000:00?o1P000ol0000100000`000ol0000B00;o5@000ol0
000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD0
00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<0V_l300000`000ooOg`0Bg`;o5B<00ooOg`0Cg`03o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?ogml04]l2oaDS00?ogml04ml00ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003omoO01;O0_lE8`03omoO01?O00?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ooOg`0Bg`;o5B<00ooOg`0Cg`03o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaDS00?ogml04ml00ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O0_lE8`03omoO01?O
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ooOg`04g`?o2ml2o`HS
0ol<8`03omoO00CO0ol<g`03o`0000<00ol<0003o`0000@00ol<0003o`0000@00ol<0003o`0000@0
0ol<0003o`00004000030003omoO00OO00?ogml02=l2o`TS00?o8b<02B<00ooOg`07g`03omoO00WO
00?o00001P000ol000090003o`0000L000?o00002@000ol000070003o`0000T000?o00001`000ol0
00090003o`00004000030003omoO00CO1?l00mooo`02o`GO0_l68`Co00@Soooo1b<00ooOg`04g`Co
00COoooo1ml00ol0000300Co00<0ool00_l60003o`0000@01?l200;o1`000ol0000400Co0P03o`H0
00?o00001004o`040?ooo`L000?o00000@0000<000?ogml00ml01OoOgmoo00;O00?ogml01Ml2o`DS
00Go8b<So`048`03ob<S00@S00?ogml00ml01OoOgmoo00;O00?ogml01]l00ol000020005o`000?l0
0P000ol000060003o`0000<000Oo0000o`3o008000?o000010000ol000030005o`000?l00`000ol0
00050003o`0000<000Go0000o`040003o`0000@000?o00000@0000<000?ogml00ml01OoOgmoo00?O
00?ogml01=l2o`DS00Go8b<So`048`03ob<S00@S00?ogml00ml01OoOgmoo00;O00?ogml01]l00ol0
00020005o`000?l00`000ol000050003o`0000<000Oo0000o`3o008000?o000010000ol000030006
o`000?l01?l60003o`0000<000Go0000o`040003o`0000@000?o00000@0000<000?ogml00ml01OoO
gmoo00CO00?ogml00ml2o`DS00Go8b<So`028`;o1b<00ooOg`03g`05omoOgol00]l00ooOg`06g`03
o`00008000Go0000o`040003o`0000@000?o00000`001_l0003o00?o1`000ol000030009o`000?l0
o`3o00L000?o00000`001_l0003o00?o1`000ol0000100000`000ooOg`04g`Ko0]l00ooOg`03g`;o
1R<5o`<S00?o8b<012<00ooOg`04g`Go00?Ooml01ml00ol0000300Ko0P000ol000040003o`0000@0
1_l90003o`0000@01_l00`3o00060003o`0000@01_l90003o`00004000030003omoO00[O0_l6g`;o
2b<3o`LS00?ogml02Ml2o`SO00?o00002@02o`L000?o00002P03o`H000?o00002P02o`L000?o0000
2@04o`H000?o00000@0000<000?ogml04]l2oaDS00?ogml04ml00ol0000B0003o`0001<000?o0000
4`000ol0000C0003o`00004000030003omoO01;O0_lE8`03omoO01?O00?o00004P000ol0000C0003
o`0001<000?o00004`000ol0000100000`000ooOg`0Bg`;o5B<00ooOg`0Cg`03o`00018000?o0000
4`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaDS00?ogml04ml00ol0000B0003
o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O0_lE8`03omoO01?O00?o0000
4P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ooOg`0Bg`;o5B<00ooOg`0Cg`03
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaDS00?ogml0
4ml00ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040000309[o0`0000<000?ogml0
4]l2oaGO00?o8b<04b<00ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003
omoO01;O0_lEg`03ob<S01<S00?o00004P000ol0000C0003o`0001<000?o00004`000ol000010000
0`000ooOg`0Bg`;o5Ml00olS8`0C8`03o`00018000?o00004`000ol0000C0003o`0001<000?o0000
0@0000<000?ogml04]l2oaGO00?o8b<04b<00ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003omoO01;O0_lEg`03ob<S01<S00?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ooOg`0Bg`;o5Ml00olS8`0C8`03o`00018000?o00004`000ol0000C0003
o`0001<000?o00000@0000<000?ogml01=l3o`_O0_l6g`?o3=l00olS8`048`?o32<00ol0000300?o
30000ol0000400?o30000ol0000400?o30000ol0000400?o30000ol0000100000`000ooOg`07g`03
omoO00SO0_l9g`03omoO00WO00?o8b<01b<00olS8`098`03o`0000H000?o00002@000ol000070003
o`0000T000?o00001`000ol000090003o`0000L000?o00002@000ol0000100000`000ooOg`04g`Co
00COoooo1]l2o`KO1?l00mooo`02o`KO00?o8b<012<4o`048oooo`LS00?o00000`04o`040?ooo`L0
00?o00001004o`040?ooo`L000?o00001004o`800_l70003o`0000@01?l200?o1P000ol000010000
0`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1Ml01OoOgmoo00;O00?ogml01]l00olS8`038`05
ob<S8ol012<00olS8`048`03o`00008000Go0000o`020003o`0000H000?o00000`001Ol0003o00@0
00?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000`001Ol0003o00<000?o0000
1@000ol0000100000`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1Ml01OoOgmoo00?O00?ogml0
1Ml00olS8`038`05ob<S8ol012<00olS8`048`03o`00008000Go0000o`020003o`0000H000?o0000
0`001Ol0003o00@000?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000`001_l0
003o00Co1P000ol0000100000`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1Ml01OoOgmoo00CO
00?ogml01=l00olS8`038`05ob<S8ol00R<2o`LS00?o00000P001Ol0003o008000?o00001P000ol0
00030006o`000?l00ol70003o`0000<000Ko0000o`03o`L000?o00000`002Ol0003o0?l0o`070003
o`00004000030003omoO00CO1Ol00moog`06g`;o1]l6o`;O00?ogml01=l00olS8`048`Go0b<00olS
8`048`03o`0000<01Ol00`3o00070003o`0000@01_l90003o`0000@01_l90003o`0000@01_l00`3o
00060003o`00004000030003omoO00WO0_l7g`;o3=l2o`OO00?o8b<02B<3o`LS00?o00002002o`P0
00?o00002@04o`H000?o00002P03o`H000?o00002P02o`L000?o00000@0000<000?ogml04]l2oaGO
00?o8b<04b<00ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O
0_lEg`03ob<S01<S00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ooO
g`0Bg`;o5Ml00olS8`0C8`03o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?ogml04]l2oaGO00?o8b<04b<00ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003omoO01;O0_lEg`03ob<S01<S00?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ooOg`0Bg`;o5Ml00olS8`0C8`03o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?ogml04]l2oaGO00?o8b<04b<00ol0000B0003o`0001<000?o00004`000ol0
000C0003o`000040000209_o0`000080Vol300000`000ol0000A00?o5Ml00ooOg`0Cg`03o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o000040001?l0oolEg`03omoO01?O
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000?0003o`0000;o
5Ml00ooOg`0Cg`03o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0000
0P02o`030?oo00L000Co00000_lEg`03omoO01?O00?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ol000030003o`3o00L000?o00000P02oaGO00?ogml04ml00ol0000B0003
o`0001<000?o00004`000ol0000C0003o`00004000030003o`0000@000?o00001@000ol0000300;o
1]l3o`cO00?ogml01=l3o`cO00?o00000`03o``000?o00001003o``000?o00001003o``000?o0000
1003o``000?o00000@0000<000?o00000`000ol0o`050003o`0000@00_l9g`03omoO00WO00?ogml0
1ml00ooOg`09g`03o`0000H000?o00002@000ol000070003o`0000T000?o00001`000ol000090003
o`0000L000?o00002@000ol0000100000`000ol0000200;o00<0ool00`000ol0000500;o1]l4o`04
goooo`OO00?ogml01=l4o`03gooo00;o1]l00ol0000300Co00@0oooo1`000ol0000400Co0P03o`H0
00?o00001004o`040?ooo`L000?o00001004o`800_l70003o`00004000030003o`0000T000?o0000
1P02o`GO00GogmoOo`02g`03omoO00KO00?ogml00ml01OoOgmoo00;O00?ogml01]l00ol000020005
o`000?l010000ol000040003o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o00@0
00?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000@0000<000?o000020000ol0
0003o`@00_l5g`05omoOgol00]l00ooOg`06g`03omoO00?O00GogmoOo`03g`03omoO00GO00?o0000
0P001Ol0003o00@000?o000010000ol000030006o`000?l01?l60003o`0000<000Go0000o`040003
o`0000@000?o00000`001ol0003o0?l00P000ol000040003o`00004000030003o`0000L000?o0000
0P000ol0000300;o1Ml01OoOgmoo00;O00?ogml01]l00ooOg`03g`05omoOgol01=l00ooOg`04g`03
o`00008000Go0000o`0200;o1`000ol000030009o`000?l0o`3o00L000?o00000`001_l0003o00?o
1`000ol000030006o`000?l00ol70003o`00004000030003o`0000H000?o000010000ol0000200;o
1]l5o`03gooO00OO00?ogml01=l6o`;O00?ogml01=l00ol0000300Go0`000ol000040003o`0000@0
1_l00`3o00060003o`0000@01_l90003o`0000@01_l90003o`00004000030003o`0000D000?o0000
1@000ol0000200;o2ml2o`SO00?ogml02]l2o`OO00?o00002003o`L000?o00002P02o`L000?o0000
2@04o`H000?o00002P03o`H000?o00000@0000<000?o000010000ol000050003o`3o00<00_lEg`03
omoO01?O00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol000030003
o`0000H000?o0?l00`02oaGO00?ogml04ml00ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003o`00008000?o00001P02o`030?oo00800_lEg`03omoO01?O00?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`001Ol0003o01000_lEg`03omoO01?O00?o0000
4P000ol0000C0003o`0001<000?o00004`000ol0000100000`001?l00?lA00;o5Ml00ooOg`0Cg`03
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0?l04P02oaGO00?ogml0
4ml00ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040000300;o4`02oaGO00?ogml0
4ml00ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040000309[o0`0001P00_n60000
X0000:00002P0000X00000/00_l:00;oN`03o`T0000;0003o`0000X000?o0000NP000ol000080000
1003o`@000?o00000P03o`D000?o0000H@02o`030?oo00T000?o0?l02@000ol00007000010001?l0
0?l30003o`0000D000?o00000P000ol0001R0003o`3o00/000?o000020000ol0000700001P02o`<0
00?o00001@000ol000020003o`0006<000?o00002005o`L000?o0?l0200000@00_l50003o`0000<0
0_l50003o`00068000?o0?l02`000ol000070003o`3o00P000040004o`00o`<000?o00001@000ol0
00020003o`0006400_l00`3oo`0C00;o00<0ool01`0000D00ol300;o0`03o`@00_n70000X0000001
\
\>"],
  ImageRangeCache->{{{0, 159.938}, {171.375, 0}} -> {-1.17504, -0.187842, 
  0.0459561, 0.0459561}},
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g2)] .22789 .77381 0 0 Mshowa
[(g3)] .36395 .77381 0 0 Mshowa
[(g1)] .5 .77381 0 0 Mshowa
[(g5)] .63605 .77381 0 0 Mshowa
[(g6)] .77211 .77381 0 0 Mshowa
[(g4)] .90816 .77381 0 0 Mshowa
[(g3)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g2)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g4)] .77211 .63776 0 0 Mshowa
[(g5)] .90816 .63776 0 0 Mshowa
[(g1)] .22789 .5017 0 0 Mshowa
[(g2)] .36395 .5017 0 0 Mshowa
[(g3)] .5 .5017 0 0 Mshowa
[(g4)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(g6)] .90816 .5017 0 0 Mshowa
[(g6)] .22789 .36565 0 0 Mshowa
[(g5)] .36395 .36565 0 0 Mshowa
[(g4)] .5 .36565 0 0 Mshowa
[(g3)] .63605 .36565 0 0 Mshowa
[(g2)] .77211 .36565 0 0 Mshowa
[(g1)] .90816 .36565 0 0 Mshowa
[(g4)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g2)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g4)] .36395 .09354 0 0 Mshowa
[(g6)] .5 .09354 0 0 Mshowa
[(g2)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g3)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[58]:=",
  ImageSize->{160.938, 172.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002P0000[0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000:00002P0000X0000:00000309[o0`0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0
000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<0
00?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00001003o`/00_l600?o30000ol0000400?o30000ol0
000300?o30000ol0000400?o30000ol0000400?o30000ol0000400?o30000ol0000100000`000ol0
00070003o`0000P00_l90003o`0000T000?o00001`000ol000090003o`0000H000?o00002@000ol0
00070003o`0000T000?o00001`000ol000090003o`0000L000?o00002@000ol0000100000`000ol0
000400Co0P02o`H00_l600Co00@0oooo1`000ol0000400Co0P03o`H000?o00000`04o`800_l70003
o`0000@01?l00`3oo`02o`H000?o00001004o`040?ooo`L000?o00001004o`040?ooo`L000?o0000
0@0000<000?o00000`001ol0003o0?l00P000ol0000300;o1@001Ol0003o00@000?o000010000ol0
00030005o`000?l00`000ol000050003o`00008000Oo0000o`3o008000?o000010000ol000030005
o`000?l00P000ol000060003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@0
00?o000010000ol0000100000`000ol000030007o`000?l0o`020003o`0000<00_l50005o`000?l0
10000ol000040003o`0000<000Ko0000o`04o`H000?o00000P001ol0003o0?l00P000ol000040003
o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o008000?o00001P000ol000030005
o`000?l010000ol000040003o`00004000030003o`0000<000Ko0000o`03o`H00_l50006o`000?l0
0ol70003o`0000<000Wo0000o`3o0?l01`000ol000020006o`000?l00ol70003o`0000<000Go0000
o`040003o`0000@000?o00000`001Ol0003o008000?o00001P000ol000030005o`000?l00P02o`L0
00?o00000@0000<000?o00001006o`P00_l600Ko2@000ol0000400Ko00<0o`001P000ol0000300Ko
2@000ol0000400Ko0P000ol000040003o`0000@01Ol00`3o00070003o`0000@01Ol30003o`0000@0
00?o00000@0000<000?o00002P03o`D00_l;00Co1P000ol0000:00;o1`000ol0000900?o1P000ol0
000:00;o1`000ol0000900;o20000ol0000900?o1`000ol0000100000`000ol0000B00;o5@000ol0
000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD0
00?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`000180
0_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0
000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`000040
00030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0
000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<0
00?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000400?o2`02o`H0
0ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003o`0000@00ol<0003o`0000@0
0ol<0003o`00004000030003o`0000L000?o00002002o`T000?o00002@000ol000070003o`0000T0
00?o00001P000ol000090003o`0000L000?o00002@000ol000070003o`0000T000?o00001`000ol0
00090003o`00004000030003o`0000@01?l0103oool600;o1P04o`800ol60003o`0000@01?l200;o
1`000ol0000300Co00@0oooo1`000ol0000400Co00@0oooo1`000ol0000400Co00@0oooo1`000ol0
000400Co00<0ool00_l60003o`00004000030003o`0000<000Go0000o`040003o`0000<00_l50005
o`000?l00`000ol000050003o`0000<000Oo0000o`3o008000?o000010000ol000020005o`000?l0
10000ol000040003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@000?o0000
10000ol000030005o`000?l00P000ol000060003o`00004000030003o`0000<000Go0000o`040003
o`0000<00_l50006o`000?l01?l60003o`0000<000Oo0000o`3o008000?o000010000ol000020005
o`000?l010000ol000040003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00@0
00?o000010000ol000030005o`000?l00`000ol000050003o`00004000030003o`0000<000Ko0000
o`03o`H00_l50009o`000?l0o`3o00L000?o00000`001_l0003o00?o1`000ol000020006o`000?l0
0ol70003o`0000<000Go0000o`020003o`0000H000?o00000`001Ol0003o00800_l70003o`0000<0
00Go0000o`040003o`0000@000?o00000@0000<000?o00001006o`P00_l600Ko00<0o`001P000ol0
000400Ko2@000ol0000300Ko2@000ol0000400Go00<0o`001`000ol0000400Go0`000ol000040003
o`0000@01_l20003o`0000@000?o00000@0000<000?o00002@04o`D00_l<00;o1`000ol0000:00?o
1P000ol0000800Co1P000ol0000900;o20000ol0000900?o1`000ol0000:00;o1`000ol000010000
0`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o0000
0@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003
o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0000C0003
o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<000?o0000
4`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0000C0003
o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o0000
4`000ol0000C0003o`0001<000?o00000@0000<0V_l300000`000ol0000B00;o5@000ol0000C0003
o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o0000
4`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003
o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o
5@000ol0000C0003o`00018000?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0000
4P02oaD000?o00004`000ol0000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003
o`0001800_lE0003o`0001<000?o00004P000ol0000C0003o`0001<000?o00004`000ol000010000
0`000ol0000400?o2`02o`H00ol<0003o`0000@00ol<0003o`0000<00ol<0003o`0000@00ol<0003
o`0000@00ol<0003o`0000@00ol<0003o`00004000030003o`0000L000?o00002002o`T000?o0000
2@000ol000070003o`0000T000?o00001P000ol000090003o`0000L000?o00002@000ol000070003
o`0000T000?o00001`000ol000090003o`00004000030003o`0000@01?l200?o1@02o`H01?l200;o
1`000ol0000400Co00@0oooo1`000ol0000300Co0P03o`H000?o00001004o`040?ooo`L000?o0000
1004o`030?oo00;o1P000ol0000400Co00@0oooo1`000ol0000100000`000ol000030005o`000?l0
0`000ol0000400;o1@001ol0003o0?l00P000ol000040003o`0000<000Go0000o`040003o`0000@0
00?o00000P001Ol0003o00<000?o00001@000ol000030005o`000?l010000ol000040003o`0000<0
00Go0000o`020003o`0000H000?o00000`001Ol0003o008000?o00001P000ol0000100000`000ol0
00030006o`000?l01?l500;o1@001ol0003o0?l00P000ol000040003o`0000<000Go0000o`040003
o`0000@000?o00000P001_l0003o00Co1P000ol000030005o`000?l010000ol000040003o`0000<0
00Go0000o`030003o`0000D000?o00000`001Ol0003o008000?o00001P000ol0000100000`000ol0
00030009o`000?l0o`3o00H00_l50006o`000?l00ol70003o`0000<000Ko0000o`03o`L000?o0000
0P002Ol0003o0?l0o`070003o`0000<000Go0000o`0200;o1`000ol000030005o`000?l010000ol0
00040003o`0000<000Go0000o`020003o`0000H000?o00000@0000<000?o00001006o`030?l000D0
0_l600Ko2@000ol0000400Ko2@000ol0000300Ko00<0o`001P000ol0000400Go0`000ol000040003
o`0000@01_l20003o`0000@000?o00001005o`030?l000L000?o00000@0000<000?o00002P02o`H0
0_l<00?o1P000ol0000900Co1P000ol0000900;o1`000ol0000900?o1`000ol0000:00;o1`000ol0
000900;o20000ol0000100000`000ol0000B00;o5@000ol0000C0003o`00018000?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0000B0003o`0001<0
00?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<000?o00004P000ol0
000C0003o`0001<000?o00004`000ol0000100000`000ol0000B00;o5@000ol0000C0003o`000180
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o00004P02oaD000?o00004`000ol0
000B0003o`0001<000?o00004`000ol0000C0003o`00004000030003o`0001800_lE0003o`0001<0
00?o00004P000ol0000C0003o`0001<000?o00004`000ol0000100000`2Jo`<000030003omoO01;O
0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ooO
g`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`000040
00030003omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0
000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0
000C0003o`00004000030003omoO00CO0ol;g`;o1]l3o`cO00?ogml01=l3o`cO00?ogml00ml3o`cO
00?o00001003o``000?o00001003o``000?o00001003o``000?o00000@0000<000?ogml01ml00ooO
g`08g`;o2Ml00ooOg`09g`03omoO00OO00?ogml02Ml00ooOg`06g`03omoO00WO00?o00001`000ol0
00090003o`0000L000?o00002@000ol000070003o`0000T000?o00000@0000<000?ogml01=l4o`04
goooo`KO0_l6g`Co00COoooo1ml00ooOg`04g`Co00?Oool00_l6g`03omoO00?O1?l01=ooool7g`03
o`0000@01?l200?o1P000ol0000400Co00@0oooo1`000ol0000400Co0P02o`L000?o00000@0000<0
00?ogml00ml01OoOgmoo00CO00?ogml00ml2o`GO00GogmoOo`02g`03omoO00KO00?ogml00ml01OoO
gmoo00;O00?ogml01]l00ooOg`02g`05omoOgol01=l00ooOg`04g`03o`0000<000Go0000o`030003
o`0000D000?o00000`001Ol0003o00@000?o000010000ol000030007o`000?l0o`020003o`0000@0
00?o00000@0000<000?ogml00ml01OoOgmoo00CO00?ogml00ml2o`GO00GogmoOo`02g`03omoO00KO
00?ogml00ml01OoOgmoo00?O00?ogml01Ml00ooOg`02g`05omoOgol01=l00ooOg`04g`03o`0000<0
00Ko0000o`04o`H000?o00000`001Ol0003o00@000?o000010000ol000030007o`000?l0o`020003
o`0000@000?o00000@0000<000?ogml00ml01OoOgmoo00;O0_l6g`;o1Ml01OoOgmoo00;O00?ogml0
1]l00ooOg`03g`05omoOgol01=l00ooOg`04g`03omoO00;O00GogmoOo`02g`;o1ml00ol000030009
o`000?l0o`3o00L000?o00000`001_l0003o00?o1`000ol000030006o`000?l00ol70003o`000040
00030003omoO00CO1Ol3g`03omoO00?O0_l6g`Go00?Ooml01ml00ooOg`04g`Ko0]l00ooOg`04g`03
omoO00?O1Ol3g`03omoO00CO00?o00001006o`030?l000H000?o00001006o`T000?o00001006o`T0
00?o00000@0000<000?ogml02Ml3o`KO0_l;g`;o2=l00ooOg`0:g`;o1ml00ooOg`08g`?o1ml00ol0
000:00;o1`000ol0000900Co1P000ol0000:00?o1P000ol0000100000`000ooOg`0Bg`;o5Ml00ooO
g`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaGO
00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O
0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ooO
g`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`000040
00030003omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0
000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<0
00?o00000@0000<0V_l300000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0
000C0003o`0001<000?o00000@0000<000?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<0
00?o00004`000ol0000C0003o`00004000030003omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0
000C0003o`0001<000?o00004`000ol0000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaGO00?ogml04ml00ooO
g`0Bg`03o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O0_lEg`03omoO01?O
00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ooOg`04g`?o2ml2o`KO
0ol<g`03omoO00CO0ol<g`03omoO00?O0ol<g`03o`0000@00ol<0003o`0000@00ol<0003o`0000@0
0ol<0003o`00004000030003omoO00OO00?ogml02=l2o`WO00?ogml02Ml00ooOg`07g`03omoO00WO
00?ogml01]l00ooOg`09g`03o`0000L000?o00002@000ol000070003o`0000T000?o00001`000ol0
00090003o`00004000030003omoO00CO1?l00mooo`02o`GO0_l6g`Co00COoooo1ml00ooOg`04g`Co
00COoooo1ml00ooOg`03g`Co00?Oool00_l6g`03o`0000@01?l200;o1`000ol0000400Co0P03o`H0
00?o00001004o`040?ooo`L000?o00000@0000<000?ogml00ml01OoOgmoo00;O00?ogml01Ml2o`GO
00GogmoOo`04g`03omoO00CO00?ogml00ml01OoOgmoo00;O00?ogml01]l00ooOg`02g`05omoOgol0
0]l00ooOg`06g`03o`0000<000Oo0000o`3o008000?o000010000ol000030005o`000?l00`000ol0
00050003o`0000<000Go0000o`040003o`0000@000?o00000@0000<000?ogml00ml01OoOgmoo00?O
00?ogml01=l2o`GO00GogmoOo`04g`03omoO00CO00?ogml00ml01OoOgmoo00;O00?ogml01]l00ooO
g`02g`05omoOgol00ml00ooOg`05g`03o`0000<000Oo0000o`3o008000?o000010000ol000030006
o`000?l01?l60003o`0000<000Go0000o`040003o`0000@000?o00000@0000<000?ogml00ml01OoO
gmoo00CO00?ogml00ml2o`GO00GogmoOo`02g`;o1ml00ooOg`03g`05omoOgol00]l00ooOg`06g`03
omoO00;O00GogmoOo`04g`03omoO00CO00?o00000`001_l0003o00?o1`000ol000030009o`000?l0
o`3o00L000?o00000`001_l0003o00?o1`000ol0000100000`000ooOg`04g`Ko0]l00ooOg`03g`;o
1]l5o`?O00?ogml01=l00ooOg`04g`Go00?Ooml01ml00ooOg`03g`Ko0]l00ooOg`04g`03o`0000@0
1_l90003o`0000@01_l00`3o00060003o`0000@01_l90003o`00004000030003omoO00[O0_l6g`;o
2ml3o`OO00?ogml02Ml2o`SO00?ogml02Ml2o`OO00?o00002P03o`H000?o00002P02o`L000?o0000
2@04o`H000?o00000@0000<000?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o0000
4`000ol0000C0003o`00004000030003omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0000C0003
o`0001<000?o00004`000ol0000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o0000
4`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03
o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O0_lEg`03omoO01?O00?ogml0
4]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03
omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?ogml04]l2oaGO00?ogml0
4ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`000040000309[o0`0000<000?ogml0
4]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`00004000030003
omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol000010000
0`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<000?o0000
0@0000<000?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003
o`00004000030003omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003
o`0001<000?o00000@0000<000?ogml01=l3o`_O0_l6g`?o3=l00ooOg`04g`?o3=l00ooOg`03g`?o
3=l00ol0000400?o30000ol0000400?o30000ol0000400?o30000ol0000100000`000ooOg`07g`03
omoO00SO0_l9g`03omoO00WO00?ogml01ml00ooOg`09g`03omoO00KO00?ogml02Ml00ol000070003
o`0000T000?o00001`000ol000090003o`0000L000?o00002@000ol0000100000`000ooOg`04g`Co
00COoooo1]l2o`KO1?l00mooo`02o`KO00?ogml01=l4o`04goooo`OO00?ogml00ml4o`04goooo`OO
00?o00001004o`040?ooo`L000?o00001004o`800_l70003o`0000@01?l200?o1P000ol000010000
0`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1Ml01OoOgmoo00;O00?ogml01]l00ooOg`03g`05
omoOgol01=l00ooOg`04g`03omoO00;O00GogmoOo`02g`03omoO00KO00?o00000`001Ol0003o00@0
00?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000`001Ol0003o00<000?o0000
1@000ol0000100000`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1Ml01OoOgmoo00?O00?ogml0
1Ml00ooOg`03g`05omoOgol01=l00ooOg`04g`03omoO00;O00GogmoOo`02g`03omoO00KO00?o0000
0`001Ol0003o00@000?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000`001_l0
003o00Co1P000ol0000100000`000ooOg`03g`05omoOgol00]l00ooOg`05g`;o1Ml01OoOgmoo00CO
00?ogml01=l00ooOg`03g`05omoOgol00]l2o`OO00?ogml00]l01OoOgmoo00;O00?ogml01]l00ol0
00030006o`000?l00ol70003o`0000<000Ko0000o`03o`L000?o00000`002Ol0003o0?l0o`070003
o`00004000030003omoO00CO1Ol00moog`06g`;o1]l6o`;O00?ogml01=l00ooOg`04g`Go0ml00ooO
g`04g`03omoO00?O1Ol00moog`07g`03o`0000@01_l90003o`0000@01_l90003o`0000@01_l00`3o
00060003o`00004000030003omoO00WO0_l7g`;o3=l2o`OO00?ogml02Ml3o`OO00?ogml02=l2o`SO
00?o00002@04o`H000?o00002P03o`H000?o00002P02o`L000?o00000@0000<000?ogml04]l2oaGO
00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`00004000030003omoO01;O
0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ooO
g`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<0
00?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`000040
00030003omoO01;O0_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0
000100000`000ooOg`0Bg`;o5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<0
00?o00000@0000<000?ogml04]l2oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0
000C0003o`000040000209_o0`000080Vol300000`000ol0000A00?o5Ml00ooOg`0Cg`03omoO01;O
00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o000040001?l0oolEg`03omoO01?O
00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ol0000?0003o`0000;o
5Ml00ooOg`0Cg`03omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0000
0P02o`030?oo00L000Co00000_lEg`03omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o0000
4`000ol0000100000`000ol000030003o`3o00L000?o00000P02oaGO00?ogml04ml00ooOg`0Bg`03
o`0001<000?o00004`000ol0000C0003o`00004000030003o`0000@000?o00001@000ol0000300;o
1]l3o`cO00?ogml01=l3o`cO00?ogml00ml3o`cO00?o00001003o``000?o00001003o``000?o0000
1003o``000?o00000@0000<000?o00000`000ol0o`050003o`0000@00_l9g`03omoO00WO00?ogml0
1ml00ooOg`09g`03omoO00KO00?ogml02Ml00ol000070003o`0000T000?o00001`000ol000090003
o`0000L000?o00002@000ol0000100000`000ol0000200;o00<0ool00`000ol0000500;o1]l4o`04
goooo`OO00?ogml01=l4o`03gooo00;o1]l00ooOg`03g`Co00COoooo1ml00ol0000400Co0P03o`H0
00?o00001004o`040?ooo`L000?o00001004o`800_l70003o`00004000030003o`0000T000?o0000
1P02o`GO00GogmoOo`02g`03omoO00KO00?ogml00ml01OoOgmoo00;O00?ogml01]l00ooOg`02g`05
omoOgol01=l00ooOg`04g`03o`0000<000Go0000o`030003o`0000D000?o00000`001Ol0003o00@0
00?o000010000ol000030007o`000?l0o`020003o`0000@000?o00000@0000<000?o000020000ol0
0003o`@00_l5g`05omoOgol00]l00ooOg`06g`03omoO00?O00GogmoOo`03g`03omoO00GO00?ogml0
0]l01OoOgmoo00CO00?ogml01=l00ol000030006o`000?l01?l60003o`0000<000Go0000o`040003
o`0000@000?o00000`001ol0003o0?l00P000ol000040003o`00004000030003o`0000L000?o0000
0P000ol0000300;o1Ml01OoOgmoo00;O00?ogml01]l00ooOg`03g`05omoOgol01=l00ooOg`04g`03
omoO00;O00GogmoOo`02g`;o1ml00ol000030009o`000?l0o`3o00L000?o00000`001_l0003o00?o
1`000ol000030006o`000?l00ol70003o`00004000030003o`0000H000?o000010000ol0000200;o
1]l5o`03gooO00OO00?ogml01=l6o`;O00?ogml01=l00ooOg`03g`Go0ml00ooOg`04g`03o`0000@0
1_l00`3o00060003o`0000@01_l90003o`0000@01_l90003o`00004000030003o`0000D000?o0000
1@000ol0000200;o2ml2o`SO00?ogml02]l2o`OO00?ogml02=l3o`OO00?o00002P02o`L000?o0000
2@04o`H000?o00002P03o`H000?o00000@0000<000?o000010000ol000050003o`3o00<00_lEg`03
omoO01?O00?ogml04]l00ol0000C0003o`0001<000?o00004`000ol0000100000`000ol000030003
o`0000H000?o0?l00`02oaGO00?ogml04ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003
o`00004000030003o`00008000?o00001P02o`030?oo00800_lEg`03omoO01?O00?ogml04]l00ol0
000C0003o`0001<000?o00004`000ol0000100000`001Ol0003o01000_lEg`03omoO01?O00?ogml0
4]l00ol0000C0003o`0001<000?o00004`000ol0000100000`001?l00?lA00;o5Ml00ooOg`0Cg`03
omoO01;O00?o00004`000ol0000C0003o`0001<000?o00000@0000<000?o0?l04P02oaGO00?ogml0
4ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`000040000300;o4`02oaGO00?ogml0
4ml00ooOg`0Bg`03o`0001<000?o00004`000ol0000C0003o`000040000309[o0`0001P00_n60000
X0000:00002P0000X00000/00_l:00;oN`03o`T0000;0003o`0000X000?o0000NP000ol000080000
1003o`@000?o00000P03o`D000?o0000H@02o`030?oo00T000?o0?l02@000ol00007000010001?l0
0?l30003o`0000D000?o00000P000ol0001R0003o`3o00/000?o000020000ol0000700001P02o`<0
00?o00001@000ol000020003o`0006<000?o00002005o`L000?o0?l0200000@00_l50003o`0000<0
0_l50003o`00068000?o0?l02`000ol000070003o`3o00P000040004o`00o`<000?o00001@000ol0
00020003o`0006400_l00`3oo`0C00;o00<0ool01`0000D00ol300;o0`03o`@00_n70000X0000001
\
\>"],
  ImageRangeCache->{{{0, 159.938}, {171.375, 0}} -> {-1.17504, -0.187842, 
  0.0459561, 0.0459561}},
  CellTags->"Subgroups"]
}, Open  ]],

Cell[BoxData[
    \(Groupoid[{{2, 3, 1}, {3, 1, 2}, {1, 2, 3}}, "-Operation-"]\)], "Output",\

  CellLabel->"Out[20]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "When the ",
  StyleBox["Visual", "MR"],
  " mode is used without ",
  StyleBox["Staged", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  ", a visualization for each iteration is returned, ready for animation, if \
desired."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SubgroupClosure[Symmetric[3], \ {{2, 3, 1}}, \ 
      Mode\  \[Rule] \ Visual, \ Output \[Rule] GraphicsArray]; \)\)], "Input",\

  CellLabel->"In[20]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {2, 3, 1}, g2 \
\[Rule] {1, 2, 3}, g3 \[Rule] {1, 3, 2}, g4 \[Rule] {2, 1, 3}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33482 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00797194 0.31746 [
[ 0 0 0 0 ]
[ 1 .33482 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .33482 L
0 .33482 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00797194 0.321429 0.326849 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 0 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g5)] .22789 .77381 0 0 Mshowa
[(g1)] .36395 .77381 0 0 Mshowa
[(g4)] .5 .77381 0 0 Mshowa
[(g6)] .63605 .77381 0 0 Mshowa
[(g2)] .77211 .77381 0 0 Mshowa
[(g3)] .90816 .77381 0 0 Mshowa
[(g1)] .22789 .63776 0 0 Mshowa
[(g2)] .36395 .63776 0 0 Mshowa
[(g3)] .5 .63776 0 0 Mshowa
[(g4)] .63605 .63776 0 0 Mshowa
[(g5)] .77211 .63776 0 0 Mshowa
[(g6)] .90816 .63776 0 0 Mshowa
[(g6)] .22789 .5017 0 0 Mshowa
[(g3)] .36395 .5017 0 0 Mshowa
[(g2)] .5 .5017 0 0 Mshowa
[(g5)] .63605 .5017 0 0 Mshowa
[(g4)] .77211 .5017 0 0 Mshowa
[(g1)] .90816 .5017 0 0 Mshowa
[(g3)] .22789 .36565 0 0 Mshowa
[(g4)] .36395 .36565 0 0 Mshowa
[(g1)] .5 .36565 0 0 Mshowa
[(g2)] .63605 .36565 0 0 Mshowa
[(g6)] .77211 .36565 0 0 Mshowa
[(g5)] .90816 .36565 0 0 Mshowa
[(g2)] .22789 .22959 0 0 Mshowa
[(g5)] .36395 .22959 0 0 Mshowa
[(g6)] .5 .22959 0 0 Mshowa
[(g3)] .63605 .22959 0 0 Mshowa
[(g1)] .77211 .22959 0 0 Mshowa
[(g4)] .90816 .22959 0 0 Mshowa
[(g4)] .22789 .09354 0 0 Mshowa
[(g6)] .36395 .09354 0 0 Mshowa
[(g5)] .5 .09354 0 0 Mshowa
[(g1)] .63605 .09354 0 0 Mshowa
[(g3)] .77211 .09354 0 0 Mshowa
[(g2)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00797194 0.64881 0.326849 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g2)] .22789 .77381 0 0 Mshowa
[(g3)] .36395 .77381 0 0 Mshowa
[(g1)] .5 .77381 0 0 Mshowa
[(g5)] .63605 .77381 0 0 Mshowa
[(g6)] .77211 .77381 0 0 Mshowa
[(g4)] .90816 .77381 0 0 Mshowa
[(g3)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g2)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g4)] .77211 .63776 0 0 Mshowa
[(g5)] .90816 .63776 0 0 Mshowa
[(g1)] .22789 .5017 0 0 Mshowa
[(g2)] .36395 .5017 0 0 Mshowa
[(g3)] .5 .5017 0 0 Mshowa
[(g4)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(g6)] .90816 .5017 0 0 Mshowa
[(g6)] .22789 .36565 0 0 Mshowa
[(g5)] .36395 .36565 0 0 Mshowa
[(g4)] .5 .36565 0 0 Mshowa
[(g3)] .63605 .36565 0 0 Mshowa
[(g2)] .77211 .36565 0 0 Mshowa
[(g1)] .90816 .36565 0 0 Mshowa
[(g4)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g2)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g4)] .36395 .09354 0 0 Mshowa
[(g6)] .5 .09354 0 0 Mshowa
[(g2)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g3)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00797194 0.97619 0.326849 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g2)] .22789 .77381 0 0 Mshowa
[(g3)] .36395 .77381 0 0 Mshowa
[(g1)] .5 .77381 0 0 Mshowa
[(g5)] .63605 .77381 0 0 Mshowa
[(g6)] .77211 .77381 0 0 Mshowa
[(g4)] .90816 .77381 0 0 Mshowa
[(g3)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g2)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g4)] .77211 .63776 0 0 Mshowa
[(g5)] .90816 .63776 0 0 Mshowa
[(g1)] .22789 .5017 0 0 Mshowa
[(g2)] .36395 .5017 0 0 Mshowa
[(g3)] .5 .5017 0 0 Mshowa
[(g4)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(g6)] .90816 .5017 0 0 Mshowa
[(g6)] .22789 .36565 0 0 Mshowa
[(g5)] .36395 .36565 0 0 Mshowa
[(g4)] .5 .36565 0 0 Mshowa
[(g3)] .63605 .36565 0 0 Mshowa
[(g2)] .77211 .36565 0 0 Mshowa
[(g1)] .90816 .36565 0 0 Mshowa
[(g4)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g2)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g4)] .36395 .09354 0 0 Mshowa
[(g6)] .5 .09354 0 0 Mshowa
[(g2)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g3)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[59]:=",
  ImageSize->{288, 96.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@0000T0D_l<057o301Bo`X000090003o`3o00;o1P02o`040?ooo`H000?o0?l00_l70003o`3o00;o
1P000ol0o`02o`L000?o0?l00_l700Co1`000ol0000:00Co1P02o`040?ooo`L01?l70003o`3o00;o
1`000ol0o`02o`H000?o0?l00_l70003o`3o00;o1P000ol0000:0003o`3o00;o1@02o`040?ooo`L0
00?o0?l00_l60003o`3o00;o1`000ol0o`02o`L01?l70003o`3o00;o1`000ol0000800002@000ol0
00020003o`0000<00_l40003o`0000<000?o00000P000ol000040003o`00008000?o00000`000ol0
00020003o`0000@000?o00000P000ol000040005o`000?l01P000ol0000:0005o`000?l01@02o`@0
00?o000010001Ol0003o00H000?o00000P000ol000040003o`00008000?o00000`000ol000020003
o`0000@000?o00000P000ol000030003o`0000X000?o00000P000ol0000200;o10000ol000040003
o`00008000?o00000`000ol000020003o`0000@000?o00000P000ol000040005o`000?l01P000ol0
00020003o`0000@000?o0000200000T000?o0?l00ol200;o00@0ool01?l200Co00<0ool00_l200;o
0P000ol0o`03o`070?ooo`3o0004o`040?ooo`8000?o0?l00ol0103oool200Go00<0ool00_l00`3o
000;00Go0P02o`040?oo00Co00@0oooo0P05o`800ol00`3o0004o`800_l20003o`3o00?o00<0ool0
0ol00`3oo`02o`040?ooo`8000?o0?l00ol01P3oool0o``000?o0?l00ol200Co00<0ool00_l0103o
ool20003o`3o00?o0P04o`030?oo00;o0P02o`8000?o0?l00ol00`3oo`02o`030?oo00?o00@0oooo
0P000ol0o`03o`040?ooo`8000?o0000200000T00_l30003o`3o00801?l30006o`000?l00_l30003
o`3o008000Co0?oo0`000ol0000200?o0`001?l00?l300;o0`000ol000020003o`3o00<000Co003o
0`000ol0000:0007o`000?l0o`0200Co0`000ol000020003o`3o00<000Go0000o`0200;o0`000ol0
o`020004o`3oo`<000Co003o0P02o`<000Co003o0`02o`<000?o00000P02o``00_l30003o`3o0080
0ol30003o`00008000Co0?oo0`001_l0003o00;o0`000ol0o`020004o`3oo`<000Co003o0`001Ol0
003o008000Co00000_l30003o`00008000?o0?l02P0000T00_l30003o`3o00801?l30003o`3o00Go
0`000ol0o`020004o`3oo`<000?o00000P03o`<000Co003o0`02o`<000?o00000P000ol0o`030005
o`000?l00P000ol0000:0007o`000?l0o`0200Co0`000ol000020003o`3o00<000?o0?l00ol00`3o
o`030003o`3o008000Co0?oo0`001_l0003o00;o0`001?l00?l300;o0`000ol0000200;o3002o`<0
00?o0?l00P03o`<000?o00000P001?l0ool30003o`3o00Go0`000ol0o`020004o`3oo`<000Go0000
o`020005o`000?l00P001?l00002o`<000?o00000P000ol0o`0:00002@02o`<000?o0?l00_l0103o
ool30006o`3o0?l00_l30003o`3o00;o0P02o`<000?o0?l00_l00`3oo`030004o`00o`<00_l30003
o`0000;o0P001Ol0003o00@000?o0?l030001_l0003o00?o00@0oooo0`000ol0o`02o`8000Wo0000
o`3o0?l00P02o`<000?o0?l00_l200;o0`000ol0000200?o0`001?l00?l300;o0`000ol00002o`03
0?l000/00_l30003o`3o00Go0`000ol0o`02o`800_l30006o`3o0?l00_l30003o`3o00;o0P02o`<0
00?o00000P000ol0o`030004o`00o`<00_l30003o`0000;o0P000ol0000800002@000ol0o`05o`<0
0_l00`3oo`04o`050?l0o`001_l40003o`3o00Go0`000ol0o`04o`030?l0008000?o0?l01?l30003
o`3o00Ko0P000ol0o`0<00Oo0`02o`030?oo00Co1007o`060?l00?l01_l40003o`3o00Go0P02o`03
0?oo00?o00<0o`000P000ol0o`04o`<00_l<0003o`3o00Go0P02o`030?oo00Co10000ol0o`05o`05
0?l0o`001_l40003o`3o00Go0P000ol0o`05o`030?l0008000?o0?l01?l30003o`3o00X000090003
o`0000D01Ol700;o00<0o`001P03o`030?l000D01Ol600;o0`000ol0000400?o0P000ol0000400;o
0P000ol0000:0003o`0000@01Ol600Co00<0o`001@02o`8000?o00001@03o`030?l000H00_l00`3o
000500;o0`000ol0000400?o00<0o`002`000ol0000500Co1P04o`030?l000H00_l00`3o000600?o
00<0o`001P02o`8000?o00000`02o`<000?o00001003o`8000?o0000200000T000?o00002002o`X0
00?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000X000?o00001`02o`/0
00?o000020000ol000090003o`0000P000?o00002@000ol000080003o`0000X000?o00001`02o`/0
00?o000020000ol000090003o`0000T000?o000020000ol000090003o`0000P000090003o`0000P0
0_l:0003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0000:0003o`0000L0
0_l;0003o`0000P000?o00002@000ol000080003o`0000T000?o000020000ol0000:0003o`0000L0
0_l;0003o`0000P000?o00002@000ol000090003o`0000P000?o00002@000ol0000800002@1Bo``0
DOl<05;o2P0000T000?o00002002o`X000?o00002@000ol000080003o`0000T000?o00002@000ol0
00080003o`0000X000?o00001`02o`/000?o000020000ol000090003o`0000P000?o00002@000ol0
00080003o`0000X000?o00001`02o`/000?o000020000ol000090003o`0000T000?o000020000ol0
00090003o`0000P000090003o`3o00;o1P02o`040?ooo`H000?o0?l00_l70003o`3o00;o1P000ol0
o`02o`L000?o0?l00_l700Co1`000ol0000:00Co1P02o`040?ooo`L01?l70003o`3o00;o1`000ol0
o`02o`H000?o0?l00_l70003o`3o00;o1P000ol0000:0003o`3o00;o1@02o`040?ooo`L000?o0?l0
0_l60003o`3o00;o1`000ol0o`02o`L01?l70003o`3o00;o1`000ol0000800002@000ol000020003
o`0000<00_l40003o`0000<000?o00000P000ol000040003o`00008000?o00000`000ol000020003
o`0000@000?o00000P000ol000040005o`000?l01P000ol0000:0005o`000?l01@02o`@000?o0000
10001Ol0003o00H000?o00000P000ol000040003o`00008000?o00000`000ol000020003o`0000@0
00?o00000P000ol000030003o`0000X000?o00000P000ol0000200;o10000ol000040003o`000080
00?o00000`000ol000020003o`0000@000?o00000P000ol000040005o`000?l01P000ol000020003
o`0000@000?o0000200000T000?o0?l00ol01@3oool000;o00<0ool00_l00`3oo`03o`030?oo00;o
00@0oooo0P000ol0o`03o`800_l00`3o0004o`040?ooo`8000?o0?l00ol0103oool200Go0P03o`03
0?l000/01Ol01@3oool000;o00<0ool00_l200?o00<0ool00ol200;o0P000ol0o`03o`040?ooo`80
00?o0?l00ol01`3oool0o`001?l0103oool20003o`3o00?o00<0ool00ol<0003o`3o00?o00<0ool0
0ol00`3oo`02o`800ol00`3o0004o`800_l00`3o0004o`040?ooo`8000?o0?l00ol0103oool200Go
00@0oooo0P000ol0o`03o`030?oo00;o00<0o`002@0000T00_l30003o`0000801?l30004o`00o`80
0_l30003o`00008000Co0?oo0`000ol0o`0200?o0`000ol000020004o`3oo`<000Co003o0`001Ol0
003o00<000Co003o30001Ol0003o00@01?l30005o`000?l00P001ol0003o0?l00P001?l0ool30003
o`00008000Co0?oo0`001?l00?l200;o0`000ol000020004o`3oo`<000Co003o0P000ol0000:00;o
0`000ol0000200?o0`001Ol0003o00800_l30003o`3o00800ol30003o`00008000Co0?oo0`001?l0
0?l30005o`000?l010001?l0ool30004o`00o`<000?o0000200000T00_l30003o`0000801?l30006
o`000?l00_l30003o`00008000Co0?oo0`000ol0o`0200?o0`000ol000020004o`3oo`<000Co003o
0`001_l0003o00Co00<0o`002`001Ol0003o00@01?l30003o`3o00?o00<0o`000P000ol0o`020004
o`3oo`<000?o00000P001?l0ool30004o`00o`800_l30003o`00008000Co0?oo0`001ol0003o0?l0
3002o`<000?o00000P03o`<000?o0?l00ol00`3oo`030003o`3o00800ol30003o`00008000Co0?oo
0`001?l00?l30005o`000?l010001?l0ool30005o`000?l00P000ol0000800002@02o`<000?o0?l0
0_l0103oool30003o`0000800ol30003o`3o00;o0P02o`<000?o0?l00_l00`3oo`030003o`0000;o
0P02o`<000Co003o0`002Ol0003o0?l0o`020003o`0000X000Ko0000o`03o`040?ooo`<000Go0?l0
o`020006o`000?l00ol200;o0`000ol0o`02o`800_l30004o`00o`800_l30003o`0000;o0P02o`<0
00?o00000P02o``00_l30003o`3o00Go0`001Ol0o`3o00800_l30003o`3o00;o00<0ool00`000ol0
o`02o`800_l30004o`00o`<000Go0000o`0200;o0P02o`<000?o00000P000ol0o`0:00002@000ol0
o`05o`<00_l00`3oo`04o`800_l00`3oo`04o`@000?o0?l01Ol30003o`3o00Co0`001?l0o`05o`03
0?l000801ol01@3o003o00`01ol300;o00<0ool01?l0103o0007o`@000?o0?l01Ol40003o`3o00Co
00H0o`00o`05o`<000Co0?l01_l200;o30000ol0o`05o`800_l00`3oo`04o`060?l00?l01_l30003
o`3o00Go10000ol0o`04o`030?l000801_l30004o`3o00Ko0P000ol0o`0:00002@000ol0000400Ko
1`02o`030?l000D01?l00`3o000600Co1P03o`8000?o00001002o`<000?o00001002o`8000?o0000
2P000ol0000300Ko1`02o`8000?o00001003o`030?l000D01?l00`3o000500;o0P000ol0000400?o
0P000ol0000500;o00<0o`002`000ol0000400Go1`02o`8000?o00001@04o`H01?l00`3o000500;o
0`000ol0000300?o0P000ol0000500;o0P000ol0000800002@000ol0000800;o2P000ol000090003
o`0000P000?o00002@000ol000090003o`0000P000?o00002P000ol0000700;o2`000ol000080003
o`0000T000?o000020000ol000090003o`0000P000?o00002P000ol0000700;o2`000ol000080003
o`0000T000?o00002@000ol000080003o`0000T000?o0000200000T000?o00002002o`X000?o0000
2@000ol000080003o`0000T000?o00002@000ol000080003o`0000X000?o00001`02o`/000?o0000
20000ol000090003o`0000P000?o00002@000ol000080003o`0000X000?o00001`02o`/000?o0000
20000ol000090003o`0000T000?o000020000ol000090003o`0000P0000905;o301Ao``0D_l:0000
2@000ol0o`02o`H00_l0103oool60003o`3o00;o1`000ol0o`02o`H000?o0?l00_l70003o`3o00;o
1`04o`L000?o00002P04o`H00_l0103oool700Co1`000ol0o`02o`L000?o0?l00_l60003o`3o00;o
1`000ol0o`02o`H000?o00002P000ol0o`02o`D00_l0103oool70003o`3o00;o1P000ol0o`02o`L0
00?o0?l00_l700Co1`000ol0o`02o`L000?o0000200000T000?o00000P000ol0000300;o10000ol0
00030003o`00008000?o000010000ol000020003o`0000<000?o00000P000ol000040003o`000080
00?o000010001Ol0003o00H000?o00002P001Ol0003o00D00_l40003o`0000@000Go0000o`060003
o`00008000?o000010000ol000020003o`0000<000?o00000P000ol000040003o`00008000?o0000
0`000ol0000:0003o`00008000?o00000P02o`@000?o000010000ol000020003o`0000<000?o0000
0P000ol000040003o`00008000?o000010001Ol0003o00H000?o00000P000ol000040003o`0000P0
00090003o`3o00?o0P05o`030?oo00;o00L0oooo0?l000Co0P03o`030?l000Co00L0oooo0?l000Co
00<0ool00_l00`3o0004o`800_l200Go00@0oooo0P000ol0000:00Go0P05o`030?oo00;o0P02o`80
1Ol0103oool20003o`3o00?o0P03o`030?l000Co00L0oooo0?l000Co00<0ool00_l00`3o0004o`06
0?ooo`3o30000ol0o`03o`801?l00`3oo`02o`800_l20003o`3o00?o00L0oooo0?l000Co0P03o`03
0?l000Co00@0oooo0P05o`030?oo00;o00<0o`001?l0103oool20003o`0000P0000900;o0`001_l0
003o00?o0`000ol0000200?o0`001Ol0003o00800_l30004o`00o`800_l30004o`00o`<00_l30003
o`3o008000?o0?l00`000ol000020003o`3o00`000Go0000o`030003o`3o00;o0`000ol0o`020003
o`3o00<000?o00000P001?l0ool30005o`000?l00P02o`<000?o00000P03o`<000Co003o0`02o`<0
00Co003o0P000ol0000:00;o0`001?l00004o`<000?o0?l00P001?l0ool30003o`0000800ol30005
o`000?l00P02o`<000?o00000P000ol0o`030004o`00o`<00_l30004o`00o`<000?o0000200000T0
0_l30003o`3o00Ko0`000ol0000200?o0`000ol0o`03o`030?oo00<000Co003o0P02o`<000Go0000
o`0200;o0`000ol0o`020003o`3o00<000?o00000P000ol0o`0<0006o`000?l01ol30003o`3o0080
00?o0?l00`000ol000020004o`3oo`<000?o0?l00ol00`3oo`030003o`0000800ol30005o`000?l0
0P02o`<000Co003o0P000ol0000:00;o0`000ol0o`05o`<000?o0?l00P001?l0ool30003o`000080
0ol30003o`3o00?o00<0ool00`000ol000020003o`3o00<000Go0000o`0200;o0`001?l00?l30003
o`0000P0000900;o0`001_l0o`3o00?o0`000ol00002o`030?oo00<000Go0?l0o`0200;o0`001?l0
0?l200;o0`000ol000020004o`3oo`<000?o0?l00_l20006o`000?l00ol20003o`0000X000[o0000
o`3o0?l00ol30003o`3o00;o0P001_l0003o00?o0P02o`<000Go0?l0o`0200;o0`000ol00002o`03
0?oo00<000?o00000P001?l0ool30004o`00o`8000?o00002P02o`<000Co0?l01?l30003o`3o00;o
0P02o`<000?o0?l00_l00`3oo`030005o`3o0?l00P02o`<000?o00000_l20005o`000?l010001?l0
ool30004o`00o`<000?o0000200000T000?o0?l01Ol00`3o0002o`030?oo00?o0`02o`030?oo00Co
00H0o`00o`05o`060?l00?l01_l20004o`3o00Ko1007o`@000?o00002P07o`030?l000;o00<0ool0
1?l400Oo10000ol0o`05o`060?l00?l01Ol300;o00<0ool01?l20004o`3o00Go00D0o`00o`0<0003
o`3o00Go00D0oooo0006o`@000?o0?l01Ol30003o`3o00Go00H0o`00o`05o`<000?o0?l01_l20004
o`3o00Go00<0o`000P000ol0000800002@000ol0000500;o00<0ool01P03o`030?l000H00_l20003
o`0000@00_l20003o`0000D00_l20003o`0000D00ol00`3o000400Co00<0o`002`000ol0000400;o
00<0ool01`03o`030?l000@01?l00`3o000600;o0P000ol0000400?o00<0o`001P02o`8000?o0000
1002o`8000?o00002P000ol0000500Co1`03o`030?l000D01Ol700;o0P000ol0000400?o0P000ol0
000400;o0P000ol0000400;o0`000ol0000800002@000ol0000800;o2P000ol000090003o`0000P0
00?o00002@000ol000090003o`0000P000?o00002P000ol0000700;o2`000ol000080003o`0000T0
00?o000020000ol000090003o`0000P000?o00002P000ol0000700;o2`000ol000080003o`0000T0
00?o00002@000ol000080003o`0000T000?o0000200000T000?o00002002o`X000?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000X000?o00001`02o`/000?o000020000ol0
00090003o`0000P000?o00002@000ol000080003o`0000X000?o00001`02o`/000?o000020000ol0
00090003o`0000T000?o000020000ol000090003o`0000P0000905;o301Ao``0D_l:00002@000ol0
000800;o2P000ol000090003o`0000P000?o00002@000ol000090003o`0000P000?o00002P000ol0
000700;o2`000ol000080003o`0000T000?o000020000ol000090003o`0000P000?o00002P000ooO
g`07g`;o2ml00ooOg`08g`03omoO00WO00?o00002@000ol000080003o`0000T000?o0000200000T0
00?o0?l00_l600;o00@0oooo1P000ol0o`02o`L000?o0?l00_l60003o`3o00;o1`000ol0o`02o`L0
1?l70003o`0000X01?l600;o00@0oooo1`04o`L000?o0?l00_l70003o`3o00;o1P000ol0o`02o`L0
00?o0?l00_l60003o`0000X000?ogol00_l5g`;o00COoooo1ml00ooOo`02o`KO00?ogol00_l7g`03
o`3o00;o1`04o`L000?o0?l00_l70003o`0000P000090003o`00008000?o00000`02o`@000?o0000
0`000ol000020003o`0000@000?o00000P000ol000030003o`00008000?o000010000ol000020003
o`0000@000Go0000o`060003o`0000X000Go0000o`0500;o10000ol000040005o`000?l01P000ol0
00020003o`0000@000?o00000P000ol000030003o`00008000?o000010000ol000020003o`0000<0
00?o00002P000ooOg`02g`03omoO00;O0_l4g`03omoO00CO00?ogml00]l00ooOg`03g`03omoO00;O
00?ogml01=l00ol000020003o`0000@000Go0000o`060003o`00008000?o000010000ol000080000
2@000ol0o`03o`050?ooo`000_l00`3oo`02o`800_l00`3o0004o`040?ooo`8000?o0?l00ol00`3o
o`03o`030?oo00;o00@0oooo0P000ol0o`03o`800ol00`3oo`03o`040?ooo`8000?o00002P05o`05
0?ooo`000_l00`3oo`02o`040?ooo`801Ol00`3oo`02o`030?l000Co00@0oooo0P000ol0o`03o`80
1?l00`3oo`02o`040?ooo`8000?o0?l00ol200;o00<0o`002`000ooOo`03o`03gooo00?o00?Oool0
0_l01=ooool2g`03omoo00?o00?Oool00ol00mooo`02o`04goooo`;O00?o0?l00ol200?o00<0ool0
0ol0103oool20003o`3o00?o0P02o`8000?o0000200000T00_l30003o`0000801?l30003o`3o0080
0ol30003o`00008000Co0?oo0`001?l00?l200;o0`000ol000020004o`3oo`<000Go0000o`020005
o`000?l00P001Ol0003o00`000Go0000o`0400Co0`001?l00?l30005o`000?l00P001?l00002o`<0
00?o00000P001?l0ool30006o`000?l00_l30003o`00008000Co0?oo0`000ol0o`0200;o3002o`?O
00?ogml00]l3o`?O00Cogmoo0ml2o`?O00Cogmoo0]l2o`?O00?ogml00]l01?oOool30005o`000?l0
0P001Ol0003o00@000Co0?oo0`000ol0o`020003o`3o00X0000900;o0`000ol0000200Co0`000ol0
o`0200?o0`000ol000020004o`3oo`<000Ko0000o`02o`<000?o00000P001?l0ool30003o`3o00?o
00<0o`000P001?l00?l30003o`0000X000Go0000o`0400Co0`001?l00?l30005o`000?l00`000ol0
0002o`<000?o00000P001?l0ool30003o`3o00Go0`000ol000020004o`3oo`<000?o0?l00P02o``0
0_l3g`03omoO00;O0ol3g`04omoOo`?O0_l3g`06omoOgooO0_l3g`03omoO00;O00Cogooo0`000ol0
o`03o`030?l0008000?o00000P001?l0ool30003o`3o008000?o0?l02P0000T00_l30003o`0000;o
00@0oooo0`000ol0o`02o`030?oo00<000?o00000_l200;o0`000ol0000200?o0`000ol0o`02o`80
0_l30005o`3o0?l00P001Ol0003o008000Go0000o`0<0005o`000?l00P02o`040?ooo`<000Co003o
0`001Ol0003o00@000Co0?oo0`000ol00002o`800_l30006o`3o0?l00_l30003o`3o00;o0P02o`<0
00?o0?l00_l00`3o000;00;o0ml00ooOg`05o`?O00Cogmoo0ml2o`?O00?ogml00]l3o`?O00?ogml0
0_l2g`;o0`001Ol0o`3o008000Ko0000o`03o`800_l30003o`3o00;o0P000ol0000800002@000ol0
o`04o`<00ol00`3oo`04o`<000?o0?l01?l30004o`3o00Ko0P02o`030?oo00Co10000ol0o`05o`04
0?l000Ko00<0o`000P000ol0000:00Ko0`03o`030?oo00?o00<0o`000P07o`8000Co0?l01Ol30004
o`3o00Ko00D0o`3o0006o`@000?o0?l01Ol30003o`0000X000?ogol01?l3g`;o00?Oool00ol00moo
g`02g`03omoo00Go0]l2o`03gooo00?o0ml01?oOo`06o`040?l000Oo10000ol0o`05o`@000?o0000
200000T000?o00001003o`030?oo00L01?l600?o0P000ol0000500;o00<0o`001@04o`030?l000H0
0_l20003o`0000<00_l30003o`0000X000?o00000`03o`030?oo00H00_l30003o`0000@00_l20003
o`0000@00ol20003o`0000D00_l00`3o000500Co00<0o`001P04o``000?ogml01=l5o`KO0_l3g`03
omoO00GO0_l00moog`05g`?o0]l00ol0000500;o0P000ol0000300Co00<0o`001P03o`030?l000T0
00090003o`0000P00_l:0003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
000:0003o`0000L00_l;0003o`0000P000?o00002@000ol000080003o`0000T000?o000020000ol0
000:0003omoO00OO0_l;g`03omoO00SO00?ogml02Ml00ol000090003o`0000P000?o00002@000ol0
000800002@000ol0000800;o2P000ol000090003o`0000P000?o00002@000ol000090003o`0000P0
00?o00002P000ol0000700;o2`000ol000080003o`0000T000?o000020000ol000090003o`0000P0
00?o00002P000ooOg`07g`;o2ml00ooOg`08g`03omoO00WO00?o00002@000ol000080003o`0000T0
00?o0000200000T0D_l<057o301Bo`X000090003o`3o00;o1P02o`040?ooo`H000?o0?l00_l70003
o`3o00;o1P000ol0o`02o`L000?o0?l00_l700Co1`000ol0000:00Co1]l2o`048oooo`LS1?l7g`03
o`3o00;o1`000ol0o`02o`H000?o0?l00_l70003o`3o00;o1P000ol0000:0003omoo00;o1Ml2o`04
goooo`OO00?ogol00_l6g`03omoo00;o1ml00ol0o`02o`L01?l70003o`3o00;o1`000ol000080000
2@000ol000020003o`0000<00_l40003o`0000<000?o00000P000ol000040003o`00008000?o0000
0`000ol000020003o`0000@000?o00000P000ol000040005o`000?l01P000ol0000:0005omoOgol0
1Ml2o`@S00?o8b<012<01OoOgmoo00KO00?o00000P000ol000040003o`00008000?o00000`000ol0
00020003o`0000@000?o00000P000ol000030003o`0000X000?ogml00]l00ooOg`02g`;o1=l00ooO
g`04g`03omoO00;O00?ogml00ml00ooOg`02g`03omoO00CO00?o00000P000ol000040005o`000?l0
1P000ol000020003o`0000@000?o0000200000T000?o0?l00ol00`3oo`04o`030?oo00;o00L0oooo
0?l000Co00<0ool00_l00`3o0004o`070?ooo`3o0004o`800ol00`3o0004o`040?ooo`801Ol200;o
0P000ol0000:00Go00?Oool01?l00b?oo`02o`048oooo`8S1Ol01=ooool2g`03o`3o00?o00<0ool0
0_l00`3o0004o`800_l00`3o0004o`800ol00`3o0004o`060?ooo`3o30000ooOo`03o`03gooo00?o
00?Oool00_l01=ooool2g`03omoo00?o00OOoooogooO00Co00?Oool00_l00moo0004o`800_l200Go
0P03o`030?l000Co00@0oooo0P000ol0000800002@02o`<000Co003o0P03o`<000Co003o0P02o`<0
00Co003o0`02o`<000?o00000P03o`<000Go0000o`0200;o0`000ol000020003o`3o00<000?o0?l0
0P000ol0o`0<0005omoOgol00]l00ooOg`03o`<S00?o8b<00R<00olSo`03g`04omoOo`?O0_l30004
o`00o`<00_l30003o`3o00800ol30005o`000?l00P02o`<000?o00000P02o``00_l3g`05omoOoml0
0ol3g`03omoO00;O00Cogooo0ml01?oOgol2g`;o0ml01?oOgol3g`;o0`000ol0o`020003o`3o00<0
00Go0000o`0200;o0`000ol000020003o`3o00X0000900;o0`001_l0003o00?o0`001?l00?l200;o
0`001Ol0003o00800_l30003o`0000800ol30003o`3o00?o00<0ool00`000ol000020003o`3o00<0
00?o0?l00P000ol0o`0<0005omoOgol00ml00ooOo`02o`<S00?o8b<00R<00olSo`03g`04omoOo`?O
0_l30005o`000?l00P02o`<000?o0?l00P03o`<000?o0?l00ol00`3oo`030003o`0000800_l<00;o
0ml01?oOgml4o`?O00?ogml00]l01?oOool3g`04omoOo`;O0_l3g`05omoOgol00]l2o`<000?o0?l0
0P000ol0o`030003o`3o00?o00<0ool00`000ol000020003o`3o00X0000900;o0`000ol0000200Co
0`001?l00?l200;o0`000ol000020004o`3oo`<000?o00000_l00`3oo`030005o`3o0?l00P02o`<0
00?o0?l00_l20006o`000?l00ol20003o`0000X000GogmoOo`04g`Co0b<00olS8`02o`8S00GogmoO
o`02g`04omoOg`;o0`000ol000020004o`3oo`<000?o0?l00_l00`3oo`030005o`3o0?l00P02o`<0
00?o0?l00_l00`3o000;00;o0ml00ooOg`02g`?o0ml00ooOg`02o`;O0_l3g`04omoOo`;O0_l3g`03
omoO00;O00Cogooo0`000ol0o`02o`8000Wo0000o`3o0?l00P02o`<000?o0?l00_l20003o`0000P0
00090003o`3o00Go0P03o`030?oo00?o00H0o`00o`06o`8000Co0?l01Ol300;o00<0ool01?l01P3o
003o00Ko1007o`@000?o00002P07o`;O0ol00b?oo`03o`<S00?o8ol01Ol00moog`02g`03o`3o00Go
0P001?l0o`06o`<000?o0?l01Ol01P3o003o00Ko0`000ol0000:0003omoo00Go0]l2o`03gooo00?o
0ml01?oOoml5o`06gooOgooO1_l2g`04omoo00Ko1007o`060?l00?l01_l40003o`0000P000090003
o`0000D00_l00`3oo`0600;o0P000ol0000500;o0P000ol0000400?o00<0o`001P02o`8000?o0000
1004o`030?l000D00ol00`3o000;0003omoO00CO0_l00mooo`068`?o0R<00ooOg`03g`;o0ml00ol0
000500;o0P000ol0000500Co1`02o`8000?o00001005o``000?ogml01Ml4o`KO0ol2g`03omoO00CO
0_l2g`03omoO00GO0_l2g`03o`0000D00ol00`3o000500;o0P000ol0000400Co00<0o`002@0000T0
00?o00002002o`X000?o00002@000ol000080003o`0000T000?o00002@000ol000080003o`0000X0
00?ogml01ml2o`/S00?ogml02=l00ol000090003o`0000P000?o00002@000ol000080003o`0000X0
00?ogml01ml2o`_O00?ogml02=l00ooOg`09g`03o`0000T000?o000020000ol000090003o`0000P0
00090003o`0000P00_l:0003o`0000T000?o000020000ol000090003o`0000T000?o000020000ol0
000:0003omoO00OO0_l;8`03omoO00SO00?o00002@000ol000080003o`0000T000?o000020000ol0
000:0003omoO00OO0_l;g`03omoO00SO00?ogml02Ml00ol000090003o`0000P000?o00002@000ol0
000800002@1Bo``0DOl<05;o2P0000T000?ogml02=l2o`XS00?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000X000?ogml01ml2o`_O00?o8b<022<00ol000090003o`0000P0
00?o00002@000ol000080003o`0000X000?ogml01ml2o`_O00?ogml02=l00ooOg`09g`03o`0000T0
00?o000020000ol000090003o`0000P000090003omoo00;o1]l2o`048oooo`HS00?o0?l00_l70003
o`3o00;o1P000ol0o`02o`L000?o0?l00_l700Co1`000ol0000:00Co1]l2o`04goooo`OO1?l78`03
o`3o00;o1`000ol0o`02o`H000?o0?l00_l70003o`3o00;o1P000ol0000:0003omoo00;o1Ml2o`04
goooo`OO00?ogol00_l6g`03omoo00;o1ml00ol0o`02o`L01?l70003o`3o00;o1`000ol000080000
2@000ooOg`02g`03omoO00?O0_l48`03ob<S00<S00?o00000P000ol000040003o`00008000?o0000
0`000ol000020003o`0000@000?o00000P000ol000040005o`000?l01P000ol0000:0005omoOgol0
1Ml2o`CO00?ogml01=l01OlS8b?o00HS00?o00000P000ol000040003o`00008000?o00000`000ol0
00020003o`0000@000?o00000P000ol000030003o`0000X000?ogml00]l00ooOg`02g`;o1=l00ooO
g`04g`03omoO00;O00?ogml00ml00ooOg`02g`03omoO00CO00?o00000P000ol000040005o`000?l0
1P000ol000020003o`0000@000?o0000200000T000?ogol00ol01MoooooO00;o00<Sool00_l01b?o
oolSo`001?l0103oool20003o`3o00?o0P04o`030?oo00;o0P02o`8000?o0?l00ol00`3oo`02o`03
0?oo00?o00@0oooo0P000ol0000:00Go00GOoooog`02o`03gooo00;o00?Oool00_l00mooo`03o`04
8oooo`8S00?o0?l00ol0103oool20003o`3o00?o00L0oooo0?l000Co0P02o`8000?o0?l00ol200Co
30000ooOo`03o`03gooo00?o00?Oool00_l00mooo`02o`03gooO00Co00OOoooogooO00Co00COoooo
0]l00ol0o`03o`040?ooo`801Ol200;o0P000ol0o`03o`800ol00`3o000900002@02o`?O00Cogmoo
0]l3o`<S00?o8b<00R<3o`<000Co003o0`02o`<000Ko0000o`02o`<000?o0?l00P001?l0ool30004
o`00o`<000Go0000o`040003o`3o00`000GogmoOo`02g`03omoO00?o0ml01?oOgol3g`05ob<S8ol0
12<01?lSool30004o`00o`<00_l30003o`0000800ol30003o`3o008000Co0?oo0`001ol0003o0?l0
3002o`?O00Gogmoog`03o`?O00Cogmoo0ml2o`?O00?ogml00]l3o`?O00Cogmoo0ml2o`<000?o0000
0P000ol0o`030003o`3o008000Co0?oo0`001Ol0003o008000?o0000200000T00_l3g`04omoOo`;O
0ol38`03ob<S008S0ol30004o`00o`<00_l30003o`3o00Go0`000ol0o`020004o`3oo`<000Go0000
o`020005o`000?l010000ol0o`0<0005omoOgol00]l00ooOg`03o`?O00GogmoOo`02g`05ob<S8ol0
12<01?lSool30004o`00o`<00_l30003o`0000800ol30003o`3o008000Co0?oo0`000ol0o`04o``0
0_l3g`05omoOoml00ol3g`05omoOgol00]l2o`?O00?ogml00]l3o`?O00Cogmoo0ml2o`<000?o0000
0P000ol0o`030003o`3o008000Co0?oo0`000ol0o`03o`030?l000T0000900;o0ml01?oOgol2g`?o
0b<00olSo`02o`038ooo00<000Co003o0`02o`<000Ko0?l0o`02o`<000?o0?l00_l200;o0`000ol0
00020003o`3o00<000?o00000_l20003o`0000X000GogmoOo`02g`03omoO00?o0ml00ooOg`02g`03
omoo00<S00?o8b<00_l28`;o0`001?l00?l300;o0`000ol0o`02o`030?oo00<000?o0?l00_l200;o
0`001ol0o`3o0?l03002o`?O00Gogmoog`03o`?O00?ogml00]l01?oOool3g`03omoO00;o00?Oool0
0ml01?oOgol3g`;o0`000ol0o`02o`8000Ko0000o`03o`800_l30005o`3o0?l00P000ol000080000
2@000ooOo`04o`04gooOg`;o00<Sool01?l38`03o`3o00Co00<0o`000P000ol0o`05o`050?l0o`00
1_l40003o`3o00Go0P000ol0o`05o`<000?o0?l03006o`04gooOg`;o00?Oool01?l2g`03omoo00Go
0b<01?lSo`05o`030?l0008000?o0?l01Ol30003o`3o00Go10000ol0o`05o`040?l0o``000?ogol0
1?l00moog`02o`03gooo00Co0]l01?oOoml5o`?O0_l00mooo`03o`03gooO00;O00?o0?l01Ol400Oo
10000ol0o`05o`050?l00?l02P0000T000?ogml01=l2o`;O0_l68`Go1P02o`<000?o00001@02o`03
0?l000H00ol00`3o000600;o0P000ol0000300?o0P000ol0000:0003omoO00?O0_l2g`;o1ml2o`;O
00?o8b<00b<3o`8S00?o00001002o`<000?o00001005o`L00ol00`3o000600;o00<0o`002`000ooO
g`04g`;o00?Oool01ml2o`;O00?ogml01=l3o`03gooO00GO0_l3g`03o`0000@01?l00`3o000500?o
00<0o`001P02o`8000?o0000200000T000?ogml02=l2o`XS00?o00002@000ol000080003o`0000T0
00?o00002@000ol000080003o`0000X000?ogml01ml2o`_O00?o8b<022<00ol000090003o`0000P0
00?o00002@000ol000080003o`0000X000?ogml01ml2o`_O00?ogml02=l00ooOg`09g`03o`0000T0
00?o000020000ol000090003o`0000P000090003omoO00SO0_l:8`03o`0000T000?o000020000ol0
00090003o`0000T000?o000020000ol0000:0003omoO00OO0_l;g`03ob<S00PS00?o00002@000ol0
00080003o`0000T000?o000020000ol0000:0003omoO00OO0_l;g`03omoO00SO00?ogml02Ml00ol0
00090003o`0000P000?o00002@000ol000080000201Co`/0D_l;05?o2P0000P0Dol;05;o2`1Co`X0
000900?o00<0ool00`001Ol0oooO00?o1]l00ol0o`02o`L000?o0?l00_l60003o`3o00;o1`000ol0
o`02o`L01?l70003o`0000X00ol00`3oo`0300?o00COoooo1ml4o`OO00?o0?l00_l70003o`3o00;o
1P000ol0o`02o`L000?o0?l00_l60003o`0000X00ol00`3oo`0300?o00COoooo1ml00ooOo`02o`KO
00?ogol00_l7g`03o`3o00;o1`04o`L000?o0?l00_l70003o`0000P000090005o`3o0?l00`000ol0
0002o`CO00?ogml00ml00ol000020003o`0000@000?o00000P000ol000030003o`00008000?o0000
10000ol000020003o`0000@000Go0000o`060003o`0000X000Go0?l0o`030004o`3oo`CO00?ogml0
1=l01OoOgmoo00KO00?o00000P000ol000040003o`00008000?o00000`000ol000020003o`0000@0
00?o00000P000ol000030003o`0000X000Go0?l0o`030004o`3oo`CO00?ogml01=l00ooOg`02g`03
omoO00?O00?ogml00]l00ooOg`04g`03o`00008000?o000010001Ol0003o00H000?o00000P000ol0
00040003o`0000P000090004o`00o`800ol200;o00?Oool00_l01moooooOo`001?l00`3oo`02o`03
0?l000Co00L0oooo0?l000Co0P03o`030?l000Co00@0oooo0P05o`800_l20003o`0000X000Go003o
0003o`800_l00mooo`02o`04goooo`;O1Ol00mooo`02o`03gol000Co00@0oooo0P000ol0o`03o`80
1?l00`3oo`02o`040?ooo`8000?o0?l00ol200;o00<0o`002`001?l00?l200?o00@0oooO1?l01=oo
ool2g`03omoo00?o00?Oool00ol00mooo`02o`04goooo`;O00?o0?l00ol200?o00<0ool00ol0103o
ool20003o`3o00?o0P02o`8000?o0000200000T000Ko0?l0o`02o`<00ol3g`04omoOo`;O0_l30004
o`00o`<00_l30003o`0000800ol30005o`000?l00P02o`<000?o00000P000ol0o`030003o`3o0080
00?o0?l030001ol0o`3o0?l00`03o`?O00Cogmoo0ml01OoOgmoo00;O00CogmoO0_l30003o`000080
00Co0?oo0`001_l0003o00;o0`000ol000020004o`3oo`<000?o0?l00P02o``000Ko0?l0o`02o`80
0ol3g`04omoOo`?O0_l3g`04omoOo`;O0_l3g`03omoO00;O00Cogooo0`001Ol0003o008000Go0000
o`040004o`3oo`<000?o0?l00P000ol0o`0:00002@03o`030?oo008000?o00000ol3g`04omoOo`;O
0_l30005o`000?l00P02o`<000?o00000P03o`<000?o0?l00ol00`3oo`030003o`00008000?o0?l0
0`000ol0o`020003o`3o00`00ol01@3oo`3o00800ol3g`04omoOo`?O00GogmoOo`03g`03omoO00;o
0`000ol000020004o`3oo`<000?o0?l01Ol30003o`00008000Co0?oo0`000ol0o`0200;o3003o`03
0?oo008000?o0?l00_l3g`04omoOo`?O0_l3g`06omoOgooO0_l3g`03omoO00;O00Cogooo0`000ol0
o`03o`030?l0008000?o00000P001?l0ool30003o`3o008000?o0?l02P0000T000Go0000o`030003
o`0000?o0ml01?oOgol2g`;o0`000ol000020004o`3oo`<000?o00000_l00`3oo`030005o`3o0?l0
0P02o`<000?o0?l00_l20006o`000?l00ol20003o`0000X000Go0000o`020003o`0000?o0ml01?oO
gol3g`05omoOgol01=l01?oOool30003o`0000;o0P02o`<000Ko0?l0o`02o`<000?o0?l00_l200;o
0`000ol0o`02o`030?l000/000Go0000o`030003o`3o00;o0ml01?oOgol3g`;o0ml00ooOg`02g`?o
0ml00ooOg`02o`;O0_l30005o`3o0?l00P001_l0003o00?o0P02o`<000?o0?l00_l20003o`0000P0
00090004o`00o`<000Co0?l00_l00mooo`03o`06gooOgol01_l20004o`3o00Go0`02o`030?oo00Co
00H0o`00o`06o`@01ol40003o`0000X000Co003o0P001?l0o`02o`03gooo00?o00?Ooml00]l7o`;O
00Cogol01Ol30004o`3o00Ko00D0o`3o0006o`@000?o0?l01Ol30003o`0000X000Co003o0`000ol0
o`02o`03gooo00?o00?Ooml00]l00ooOo`05o`;O0_l00mooo`03o`?O00Cogol01_l0103o0007o`@0
00?o0?l01Ol40003o`0000P000090003o`3o00@000Co0?l00_l6g`;o0]l00ol0000500;o0P000ol0
000400?o00<0o`001P02o`8000?o00001004o`030?l000D00ol00`3o000;0003o`3o00<000Co0?l0
0_l6g`;o0ml00ooOg`04g`;o0]l00ol0000400?o0P000ol0000500;o00<0o`001@04o`030?l000H0
1?l<0003o`3o00@000?o0?l00_l6g`;o0ml00ooOg`05g`;o00?Ooml01Ml3o`;O00?o00001@02o`80
00?o00000`04o`030?l000H00ol00`3o000900002@02o`@00_l00`3oo`02o`[O00?o00002@000ol0
00080003o`0000T000?o00002@000ol000080003o`0000X00_l300;o00<0ool00_l;g`03omoO00SO
00?o00002@000ol000080003o`0000T000?o000020000ol0000:00;o1002o`040?ooo`_O00?ogml0
2=l00ooOg`09g`03o`0000T000?o000020000ol000090003o`0000P0000905;o301Ao``0D_l:0000
5002oe/00_mK00;oD00001400_l:00;o<`03oaX00_l:00;o<P03oaX00_l:00;o<`03oa00000A0003
o`0000X000?o0000<P000ol0000I0003o`0000X000?o0000<@000ol0000I0003o`0000X000?o0000
<P000ol0000?00002P03o`@000?o00000P03o`D000?o00006@02o`030?oo00T000?o0?l02@000ol0
000A00?o10000ol0000200?o1@000ol0000H00;o00<0ool02@000ol0o`090003o`0001400ol40003
o`0000800ol50003o`0001T00_l00`3oo`090003o`3o00T000?o00003P0000X000Co003o0`000ol0
00050003o`00008000?o00006P000ol0o`0;0003o`0000P000?o00004@001?l00?l30003o`0000D0
00?o00000P000ol0000I0003o`3o00/000?o000020000ol0000A0004o`00o`<000?o00001@000ol0
00020003o`0001X000?o0?l02`000ol000080003o`0000h0000<00;o0`000ol000050003o`000080
00?o00006`000ol0000800Go1`000ol0o`0D00;o0`000ol000050003o`00008000?o00006P000ol0
000800Go1`000ol0o`0D00;o0`000ol000050003o`00008000?o00006`000ol0000800Go1`000ol0
o`0?00002P02o`D000?o00000`02o`D000?o00006P000ol0o`0;0003o`0000L000?o0?l04P02o`D0
00?o00000`02o`D000?o00006@000ol0o`0;0003o`0000L000?o0?l04P02o`D000?o00000`02o`D0
00?o00006P000ol0o`0;0003o`0000L000?o0?l03`0000X000Co003o0`000ol000050003o`000080
00?o00006@02o`030?oo01<00_l00`3oo`0A0004o`00o`<000?o00001@000ol000020003o`0001P0
0_l00`3oo`0C00;o00<0ool04@001?l00?l30003o`0000D000?o00000P000ol0000I00;o00<0ool0
4`02o`030?oo00h0000;00?o0`02o`<00ol400;oBP03o`<00_l300?o1002odT00ol300;o0`03o`@0
0_m60000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {95.375, 0}} -> {-0.0868784, -0.0251169, 
  0.0110584, 0.0110584}, {{7.8125, 92.625}, {93.0625, 
  2.25}} -> {-1.85488, -0.388076, 0.0867184, 0.0867184}, {{101.062, 
  185.875}, {93.0625, 2.25}} -> {-9.94137, -0.388076, 0.0867184, 
  0.0867184}, {{194.312, 279.125}, {93.0625, 2.25}} -> {-18.0279, -0.388076, 
  0.0867184, 0.0867184}},
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Staged", "MR"],
  " option to ",
  StyleBox["Closure", "MR"],
  " causes all the graphics to be generated, but only the first iteration is \
displayed (at first)."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupClosure[Symmetric[3], \ {{2, 3, 1}}, \ Mode\  \[Rule] \ Visual, 
      \ Staged\  \[Rule] \ True]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {2, 3, 1}, g2 \
\[Rule] {1, 2, 3}, g3 \[Rule] {1, 3, 2}, g4 \[Rule] {2, 1, 3}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 0 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g5)] .22789 .77381 0 0 Mshowa
[(g1)] .36395 .77381 0 0 Mshowa
[(g4)] .5 .77381 0 0 Mshowa
[(g6)] .63605 .77381 0 0 Mshowa
[(g2)] .77211 .77381 0 0 Mshowa
[(g3)] .90816 .77381 0 0 Mshowa
[(g1)] .22789 .63776 0 0 Mshowa
[(g2)] .36395 .63776 0 0 Mshowa
[(g3)] .5 .63776 0 0 Mshowa
[(g4)] .63605 .63776 0 0 Mshowa
[(g5)] .77211 .63776 0 0 Mshowa
[(g6)] .90816 .63776 0 0 Mshowa
[(g6)] .22789 .5017 0 0 Mshowa
[(g3)] .36395 .5017 0 0 Mshowa
[(g2)] .5 .5017 0 0 Mshowa
[(g5)] .63605 .5017 0 0 Mshowa
[(g4)] .77211 .5017 0 0 Mshowa
[(g1)] .90816 .5017 0 0 Mshowa
[(g3)] .22789 .36565 0 0 Mshowa
[(g4)] .36395 .36565 0 0 Mshowa
[(g1)] .5 .36565 0 0 Mshowa
[(g2)] .63605 .36565 0 0 Mshowa
[(g6)] .77211 .36565 0 0 Mshowa
[(g5)] .90816 .36565 0 0 Mshowa
[(g2)] .22789 .22959 0 0 Mshowa
[(g5)] .36395 .22959 0 0 Mshowa
[(g6)] .5 .22959 0 0 Mshowa
[(g3)] .63605 .22959 0 0 Mshowa
[(g1)] .77211 .22959 0 0 Mshowa
[(g4)] .90816 .22959 0 0 Mshowa
[(g4)] .22789 .09354 0 0 Mshowa
[(g6)] .36395 .09354 0 0 Mshowa
[(g5)] .5 .09354 0 0 Mshowa
[(g1)] .63605 .09354 0 0 Mshowa
[(g3)] .77211 .09354 0 0 Mshowa
[(g2)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00002`03oa800_l>00?o4`000ol0000;00?o4`000ol0
000;00?o50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o4`000ol0000400001P000ol0
000>0003o`0000l00_lA0003o`00010000?o00003P000ol0000@0003o`0000h000?o00004@000ol0
000>0003o`00010000?o00003P000ol0000@0003o`0000l000?o000040000ol0000400001P000ol0
000;00Co0P02o`d00_l>00Co0P03o`d000?o00002`04o`800_l>0003o`0000/01?l0103oool?0003
o`0000/01?l0103oool>0003o`0000/01?l0103oool>0003o`0000`01?l00`3oo`02o`d000?o0000
100000H000?o00002P001ol0003o0?l00P000ol0000:00;o3@001Ol0003o00<000?o000030000ol0
000:0007o`000?l0o`020003o`0000/000?o00002P001Ol0003o00@000?o000030000ol0000:0005
o`000?l00P000ol0000=0003o`0000X000Go0000o`040003o`0000/000?o00002`001Ol0003o0080
00?o00003@000ol0000400001P000ol0000:0007o`000?l0o`020003o`0000X00_l=0006o`000?l0
1?l=0003o`0000X000Oo0000o`3o008000?o00002`000ol0000:0005o`000?l010000ol0000<0003
o`0000X000Go0000o`020003o`0000d000?o00002P001Ol0003o00@000?o00002`000ol0000;0005
o`000?l00`000ol0000<0003o`0000@000060003o`0000X000Ko0000o`03o`d00_l=0009o`000?l0
o`3o00h000?o00002P001_l0003o00?o3P000ol0000:0006o`000?l00ol?0003o`0000X000Go0000
o`020003o`0000d000?o00002P001Ol0003o00800_l>0003o`0000/000Go0000o`040003o`0000/0
00?o0000100000H000?o00002`06o`l00_l>00Ko00<0o`003@000ol0000;00Ko40000ol0000;00Ko
4@000ol0000;00Go00<0o`003P000ol0000;00Go0`000ol0000;0003o`0000`01_l20003o`0000/0
00?o0000100000H000?o00004@03o``00_lD00;o3P000ol0000A00?o3@000ol0000@00Co3P000ol0
000@00;o3`000ol0000@00?o3P000ol0000B00;o3P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00002`03oa800_l>00?o
4`000ol0000;00?o4`000ol0000;00?o50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o
4`000ol0000400001P000ol0000>0003o`0000l00_lA0003o`00010000?o00003P000ol0000@0003
o`0000h000?o00004@000ol0000>0003o`00010000?o00003P000ol0000@0003o`0000l000?o0000
40000ol0000400001P000ol0000;00Co00@0oooo3@02o`h01?l00`3oo`02o`d000?o00002`04o`04
0?ooo`h000?o00002`04o`800_l?0003o`0000/01?l0103oool>0003o`0000/01?l0103oool>0003
o`0000`01?l200?o3@000ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o3@001Ol0
003o008000?o00003@000ol0000:0005o`000?l010000ol0000;0003o`0000X000Oo0000o`3o0080
00?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000X000Go0000o`020003o`0000d0
00?o00002`001Ol0003o00<000?o000030000ol0000400001P000ol0000:0005o`000?l010000ol0
000:00;o3@001Ol0003o00<000?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000X0
00Oo0000o`3o008000?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000X000Go0000
o`020003o`0000d000?o00002`001_l0003o00Co3@000ol0000400001P000ol0000:0006o`000?l0
0ol=00;o3@001Ol0003o00@000?o00002`000ol0000:0006o`000?l00ol>0003o`0000X000Ko0000
o`03o`l000?o00002P001Ol0003o00800_l>0003o`0000X000Go0000o`020003o`0000d000?o0000
2`002Ol0003o0?l0o`0>0003o`0000@000060003o`0000/01_l?00;o3P06o`8000?o00002`000ol0
000;00Ko40000ol0000;00Ko4@000ol0000;00Go0`000ol0000;0003o`0000/01Ol00`3o000>0003
o`0000`01_l00`3o000=0003o`0000@000060003o`0001001?l<00;o5002o`h000?o00004004o`d0
00?o00004@03o`h000?o00004003o`h000?o00004002o`l000?o00004P02o`h000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P3oo`7o
1P0000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0000/00olB00;o3P03oa<000?o00002`03oa<000?o00002`03oa@000?o00002`03oa<000?o0000
2`03oa<000?o00003003oa<000?o0000100000H000?o00003P000ol0000?00;o4@000ol0000@0003
o`0000h000?o000040000ol0000>0003o`00014000?o00003P000ol0000@0003o`0000h000?o0000
40000ol0000?0003o`00010000?o0000100000H000?o00002`04o`800ol<00;o3P04o`040?ooo`h0
00?o00002`04o`800ol=0003o`0000/01?l0103oool?0003o`0000/01?l00`3oo`02o`d000?o0000
2`04o`800_l>0003o`0000`01?l0103oool>0003o`0000@000060003o`0000X000Go0000o`030003
o`0000/00_l=0005o`000?l010000ol0000;0003o`0000X000Go0000o`030003o`0000`000?o0000
2P001Ol0003o008000?o00003P000ol0000:0005o`000?l00P000ol0000=0003o`0000X000Oo0000
o`3o008000?o00002`000ol0000;0005o`000?l010000ol0000;0003o`0000@000060003o`0000X0
00Ko0000o`04o``00_l=0005o`000?l010000ol0000;0003o`0000X000Ko0000o`04o`d000?o0000
2P001Ol0003o008000?o00003P000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Oo0000
o`3o008000?o00002`000ol0000;0005o`000?l010000ol0000;0003o`0000@000060003o`0000X0
00Wo0000o`3o0?l03@02o`d000Go0000o`0200;o3P000ol0000:0009o`000?l0o`3o00h000?o0000
2P001Ol0003o008000?o00003P000ol0000:0005o`000?l010000ol0000;0003o`0000X000Ko0000
o`03o`h000?o00002`001_l0003o00?o3P000ol0000400001P000ol0000;00Ko00<0o`003002o`h0
1Ol30003o`0000/000?o00002`06o`030?l000d000?o00002`05o`030?l000l000?o00002`06o`80
00?o00002`000ol0000;00Ko40000ol0000<00Ko40000ol0000400001P000ol0000A00;o3@02oa<0
0ol>0003o`0001400_l>0003o`0001000_l@0003o`0001400_l>0003o`0001400ol=0003o`000140
1?l=0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00002`03oa800_l>00?o4`000ol0000;00?o4`000ol0000;00?o
50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o4`000ol0000400001P000ol0000>0003
o`0000l00_lA0003o`00010000?o00003P000ol0000@0003o`0000h000?o00004@000ol0000>0003
o`00010000?o00003P000ol0000@0003o`0000l000?o000040000ol0000400001P000ol0000;00Co
00@0oooo3@02o`h01?l200;o3P000ol0000;00Co00@0oooo3P000ol0000;00Co00<0ool00_l>0003
o`0000/01?l0103oool>0003o`0000/01?l200?o3@000ol0000<00Co00@0oooo3P000ol000040000
1P000ol0000:0005o`000?l010000ol0000:00;o3@001ol0003o0?l00P000ol0000;0003o`0000X0
00Go0000o`040003o`0000/000?o00002P001Ol0003o008000?o00003P000ol0000:0005o`000?l0
10000ol0000;0003o`0000X000Go0000o`030003o`0000`000?o00002`001Ol0003o008000?o0000
3@000ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o3@001ol0003o0?l00P000ol0
000;0003o`0000X000Go0000o`040003o`0000/000?o00002P001Ol0003o00<000?o00003@000ol0
000:0005o`000?l010000ol0000;0003o`0000X000Ko0000o`04o`d000?o00002`001Ol0003o0080
00?o00003@000ol0000400001P000ol0000:0005o`000?l00P02o`d00_l=0006o`000?l00ol>0003
o`0000X000Go0000o`0200;o3P000ol0000:0005o`000?l010000ol0000<0003o`0000X000Ko0000
o`03o`h000?o00002P002Ol0003o0?l0o`0>0003o`0000/000Go0000o`020003o`0000d000?o0000
100000H000?o00002`05o`<000?o00002P02o`h01_l@0003o`0000/01Ol30003o`0000/000?o0000
2`06o`8000?o000030000ol0000;00Ko40000ol0000;00Ko00<0o`003@000ol0000<00Go00<0o`00
3P000ol0000400001P000ol0000@00?o3@02oa@00ol=0003o`0001000ol>0003o`0001400_l?0003
o`0001001?l=0003o`0001400_l>0003o`0001400_l?0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0ool1o`H000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000;00?o4P02o`h0
0olC0003o`0000/00olC0003o`0000/00olD0003o`0000/00olC0003o`0000/00olC0003o`0000`0
0olC0003o`0000@000060003o`0000h000?o00003`02oa4000?o000040000ol0000>0003o`000100
00?o00003P000ol0000A0003o`0000h000?o000040000ol0000>0003o`00010000?o00003`000ol0
000@0003o`0000@000060003o`0000/01?l00`3oo`02o``00_l>00Co00@0oooo3P000ol0000;00Co
00<0ool00_l=0003o`0000/01?l0103oool?0003o`0000/01?l200?o3@000ol0000;00Co00@0oooo
3P000ol0000<00Co0P02o`h000?o0000100000H000?o00002P001Ol0003o008000?o00003002o`d0
00Go0000o`020003o`0000d000?o00002P001Ol0003o008000?o00003@000ol0000:0005o`000?l0
10000ol0000<0003o`0000X000Go0000o`030003o`0000`000?o00002P001Ol0003o00@000?o0000
2`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00002P001Ol0003o00<0
00?o00002`02o`d000Go0000o`020003o`0000d000?o00002P001Ol0003o00<000?o000030000ol0
000:0005o`000?l010000ol0000<0003o`0000X000Ko0000o`04o`d000?o00002P001Ol0003o00@0
00?o00002`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00002P001Ol0
003o00@000?o00002P02o`d000Go0000o`020003o`0000d000?o00002P001Ol0003o00@000?o0000
2`000ol0000:0005o`000?l00P02o`l000?o00002P002Ol0003o0?l0o`0>0003o`0000X000Ko0000
o`03o`h000?o00002`001_l0003o00?o3P000ol0000400001P000ol0000;00Ko0P000ol0000:00;o
3P05o`030?l000h000?o00002`06o`8000?o00002`000ol0000;00Go0`000ol0000<0003o`0000/0
1_l00`3o000=0003o`0000/01_l@0003o`0000`01_l@0003o`0000@000060003o`0001400_l=00;o
4`02o`l000?o00004@02o`h000?o00004003o`l000?o00004@02o`h000?o00004004o`d000?o0000
4P03o`d000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H0ool1o`H000060003omoO023O0_lT8`03o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O
0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooO
g`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ooOg`0;g`?o4]l2o`hS0olC8`03o`0000/00olC0003o`0000/0
0olD0003o`0000/00olC0003o`0000/00olC0003o`0000`00olC0003o`0000@000060003omoO00kO
00?ogml03ml2oa4S00?o8b<042<00ol0000>0003o`00010000?o00003P000ol0000A0003o`0000h0
00?o000040000ol0000>0003o`00010000?o00003`000ol0000@0003o`0000@000060003omoO00_O
1?l01=ooool=g`;o3R<4o`048oooo`hS00?o00002`04o`040?ooo`h000?o00002`04o`800ol>0003
o`0000/01?l200;o3P000ol0000;00Co00<0ool00_l=0003o`0000`01?l0103oool>0003o`0000@0
00060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=8`05ob<S8ol012<00olS8`0;8`03o`0000X0
00Go0000o`020003o`0000d000?o00002P001Ol0003o00<000?o00003@000ol0000:0007o`000?l0
o`020003o`0000/000?o00002P001Ol0003o008000?o00003@000ol0000;0005o`000?l010000ol0
000;0003o`0000@000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=8`05ob<S8ol012<00olS
8`0;8`03o`0000X000Go0000o`020003o`0000d000?o00002P001_l0003o00Co3P000ol0000:0007
o`000?l0o`020003o`0000/000?o00002P001Ol0003o00<000?o000030000ol0000;0005o`000?l0
10000ol0000;0003o`0000@000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=8`06ob<S8olS
0ol>8`03o`0000X000Go0000o`020003o`0000d000?o00002P002Ol0003o0?l0o`0?0003o`0000X0
00Ko0000o`03o`h000?o00002P001Ol0003o00@000?o00002`000ol0000;0005o`000?l00P02o`h0
00?o0000100000H000?ogml02ml5o`03gooO00gO0_l>8`Ko42<00ol0000;00Go00<0o`003P000ol0
000;00Ko00<0o`003P000ol0000;00Ko40000ol0000;00Ko0P000ol0000;0003o`0000`01Ol30003
o`0000/000?o0000100000H000?ogml04=l2o`kO0_lC8`Co3B<00ol0000@00;o3`000ol0000A00;o
3`000ol0000A00?o3@000ol0000A00;o3P000ol0000A00?o3P000ol0000400001P000ooOg`0Pg`;o
92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml0
8=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000050?oo0_l600001@3oo`;o
1P0000H000?o00007`03obCO00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0001h000Co0?oo9=l00ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00007@000ol00002obCO00?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0001`000Co00000_lTg`03o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000K0003o`0000800_lTg`03
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000J0003
o`0000<00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000I0003o`0000@00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000H0003o`0000D00_lTg`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000600;o00<0ool030000ol0000600;o9=l00ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001`000ol0
o`0<0003o`0000L00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000080003o`0000X000?o00002002obCO00?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0000L000?o0?l02P000ol0000900;o9=l00ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001P02o`03
0?oo00P000?o00002P02o`kO0olCg`03o`0000/00olC0003o`0000/00olD0003o`0000/00olC0003
o`0000/00olC0003o`0000`00olC0003o`0000@000060003o`00018000?o00002`02oa7O00?ogml0
4=l00ol0000>0003o`00010000?o00003P000ol0000A0003o`0000h000?o000040000ol0000>0003
o`00010000?o00003`000ol0000@0003o`0000@000060003o`00014000?o00003002o`kO1?l01=oo
ool>g`03o`0000/01?l00`3oo`02o`d000?o00002`04o`040?ooo`l000?o00002`04o`800ol=0003
o`0000/01?l0103oool>0003o`0000`01?l200;o3P000ol0000400001P000ol0000@0003o`0000d0
0_l=g`05omoOgol00]l00ooOg`0=g`03o`0000X000Go0000o`020003o`0000d000?o00002P001Ol0
003o00@000?o000030000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Go0000o`040003
o`0000/000?o00002`001ol0003o0?l00P000ol0000;0003o`0000@000060003o`0000l000?o0000
3P02o`gO00GogmoOo`02g`03omoO00gO00?o00002P001Ol0003o00<000?o000030000ol0000:0005
o`000?l010000ol0000<0003o`0000X000Ko0000o`04o`d000?o00002P001Ol0003o00@000?o0000
2`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00003P000ol0000?00;o
3Ml01OoOgmoo00;O00?ogml03Ml00ol0000:0005o`000?l010000ol0000;0003o`0000X000Go0000
o`0200;o3`000ol0000:0009o`000?l0o`3o00h000?o00002P001_l0003o00?o3P000ol0000;0006
o`000?l00ol>0003o`0000@000060003o`0000d000?o00004002o`kO1Ol00moog`0>g`03o`0000/0
1_l20003o`0000/000?o00002`05o`<000?o000030000ol0000;00Ko00<0o`003@000ol0000;00Ko
40000ol0000<00Ko40000ol0000400001P000ol0000<0003o`0000H00ol800;o4ml2o`oO00?o0000
4@02o`h000?o00004003o`l000?o00004@02o`h000?o00004004o`d000?o00004P03o`d000?o0000
100000H000?o00002`000ol000080003o`0000L00_lTg`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000:0003o`0000X000?o00001P02obCO00?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000T000?o0000
2`000ol0000600;o9=l00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o000020000ol0000;0003o`3o00L00_lTg`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol000070003o`0000`000?o0?l01`02obCO00?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000H000?o0000
3002o`030?oo00H00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000050003o`0001P00_lTg`03o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol000040003o`0001T00_lTg`03o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol000030003o`0001X00_lTg`03o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol000020003o`0001/0
0_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P001Ol0
003o01h00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P001?l00?lO00;o9=l00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o0?l08002obCO00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@0000600;o8@02obCO00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060?oo0Ol60000:@02on40003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0
003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0000>00;o2P02on400ol<0000
3P000ol0000:0003o`000>0000?o00002`0000L00ol40003o`0000800ol50003o`000<L00_l00`3o
o`090003o`3o00T000?o00002P0000L000Co003o0`000ol000050003o`00008000?o0000b0000ol0
o`0;0003o`0000P000?o00002P0000T00_l30003o`0000D000?o00000P000ol000390003o`0000P0
1Ol70003o`3o00/0000700;o1@000ol0000300;o1@000ol000380003o`3o00/000?o00001`000ol0
o`0;00001`001?l00?l30003o`0000D000?o00000P000ol0003700;o00<0ool04`02o`030?oo00X0
000800?o0`02o`<00ol400;ol0000?l03@000?l03@000?l03@000001\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{{2, 3, 1}, {3, 1, 2}, {1, 2, 3}}, "-Operation-"]\)], "Output",\

  CellLabel->"Out[21]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["NextStage", "MR"],
  " and ",
  StyleBox["PreviousStage", "MR"],
  " functions are used to rotate through the cycle of iterations when the ",
  StyleBox["Staged", "MR"],
  " option is used. (Note: A second argument, consisting of a positive \
integer, can be added to specify how many steps forward or backwards to \
take.)"
}], "Text",
  CellTags->{"Subgroups", "i:11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(NextStage[Closure]\),
              "MR"], 
            RowBox[{
              RowBox[{
                RowBox[{"when", " ", 
                  StyleBox["used",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["with",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["Staged",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["option",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(show\ the\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["visualization",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["next",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["iteration",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Closure",
                  "MR"]}]}]},
          {
            StyleBox[\(PreviousStage[Closure]\),
              "MR"], 
            RowBox[{
              RowBox[{"when", " ", 
                StyleBox["used",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Staged",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["option",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["show",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["visualization",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["previous",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["iteration",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Closure",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Subgroups", "i:12"}],

Cell[TextData[{
  "Functions to be used with the ",
  StyleBox["Staged",
    FontFamily->"Courier"],
  " option of ",
  StyleBox["Closure",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Subgroups"],

Cell[TextData[{
  "Use the ",
  StyleBox["NextStage", "MR"],
  " function, with ",
  StyleBox["Closure", "MR"],
  " as its argument, to see the next iteration."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NextStage[Closure]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 0 0 r
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g2)] .22789 .77381 0 0 Mshowa
[(g3)] .36395 .77381 0 0 Mshowa
[(g1)] .5 .77381 0 0 Mshowa
[(g5)] .63605 .77381 0 0 Mshowa
[(g6)] .77211 .77381 0 0 Mshowa
[(g4)] .90816 .77381 0 0 Mshowa
[(g3)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g2)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g4)] .77211 .63776 0 0 Mshowa
[(g5)] .90816 .63776 0 0 Mshowa
[(g1)] .22789 .5017 0 0 Mshowa
[(g2)] .36395 .5017 0 0 Mshowa
[(g3)] .5 .5017 0 0 Mshowa
[(g4)] .63605 .5017 0 0 Mshowa
[(g5)] .77211 .5017 0 0 Mshowa
[(g6)] .90816 .5017 0 0 Mshowa
[(g6)] .22789 .36565 0 0 Mshowa
[(g5)] .36395 .36565 0 0 Mshowa
[(g4)] .5 .36565 0 0 Mshowa
[(g3)] .63605 .36565 0 0 Mshowa
[(g2)] .77211 .36565 0 0 Mshowa
[(g1)] .90816 .36565 0 0 Mshowa
[(g4)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g5)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g2)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g4)] .36395 .09354 0 0 Mshowa
[(g6)] .5 .09354 0 0 Mshowa
[(g2)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g3)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[22]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00002`03oa800_l>00?o4`000ol0000;00?o4`000ol0
000;00?o50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o4`000ol0000400001P000ol0
000>0003o`0000l00_lA0003o`00010000?o00003P000ol0000@0003o`0000h000?o00004@000ol0
000>0003o`00010000?o00003P000ol0000@0003o`0000l000?o000040000ol0000400001P000ol0
000;00Co0P02o`d00_l>00Co00@0oooo3P000ol0000;00Co0P03o`d000?o00002`04o`800_l?0003
o`0000/01?l00`3oo`02o`d000?o00002`04o`040?ooo`h000?o00003004o`040?ooo`h000?o0000
100000H000?o00002P001ol0003o0?l00P000ol0000:00;o3@001Ol0003o00@000?o00002`000ol0
000:0005o`000?l00`000ol0000<0003o`0000X000Oo0000o`3o008000?o000030000ol0000:0005
o`000?l00P000ol0000=0003o`0000X000Go0000o`020003o`0000d000?o00002`001Ol0003o00@0
00?o00002`000ol0000400001P000ol0000:0007o`000?l0o`020003o`0000X00_l=0005o`000?l0
10000ol0000;0003o`0000X000Ko0000o`04o`d000?o00002P001ol0003o0?l00P000ol0000<0003
o`0000X000Go0000o`030003o`0000`000?o00002P001Ol0003o008000?o00003@000ol0000;0005
o`000?l010000ol0000;0003o`0000@000060003o`0000X000Ko0000o`03o`d00_l=0006o`000?l0
0ol>0003o`0000X000Wo0000o`3o0?l03P000ol0000:0006o`000?l00ol?0003o`0000X000Go0000
o`040003o`0000/000?o00002P001Ol0003o008000?o00003@000ol0000;0005o`000?l00P02o`h0
00?o0000100000H000?o00002`06o`l00_l>00Ko40000ol0000;00Ko00<0o`003@000ol0000;00Ko
4@000ol0000;00Ko0P000ol0000;0003o`0000/01Ol00`3o000>0003o`0000`01Ol30003o`0000/0
00?o0000100000H000?o00004@03o``00_lC00Co3@000ol0000A00;o3P000ol0000A00?o3P000ol0
000A00;o3P000ol0000@00;o3`000ol0000A00?o3P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00002`03oa800_l>00?o
4`000ol0000;00?o4`000ol0000;00?o50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o
4`000ol0000400001P000ol0000>0003o`0000l00_lA0003o`00010000?o00003P000ol0000@0003
o`0000h000?o00004@000ol0000>0003o`00010000?o00003P000ol0000@0003o`0000l000?o0000
40000ol0000400001P000ol0000;00Co00@0oooo3@02o`h01?l200?o3@000ol0000;00Co0P02o`h0
00?o00002`04o`040?ooo`l000?o00002`04o`040?ooo`h000?o00002`04o`040?ooo`h000?o0000
3004o`030?oo00;o3@000ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o3@001Ol0
003o00<000?o000030000ol0000:0007o`000?l0o`020003o`0000/000?o00002P001Ol0003o00@0
00?o000030000ol0000:0005o`000?l00P000ol0000=0003o`0000X000Go0000o`040003o`0000/0
00?o00002`001Ol0003o008000?o00003@000ol0000400001P000ol0000:0005o`000?l010000ol0
000:00;o3@001_l0003o00Co3@000ol0000:0007o`000?l0o`020003o`0000/000?o00002P001Ol0
003o00@000?o000030000ol0000:0005o`000?l00P000ol0000=0003o`0000X000Go0000o`040003
o`0000/000?o00002`001Ol0003o00<000?o000030000ol0000400001P000ol0000:0006o`000?l0
0ol=00;o3@002Ol0003o0?l0o`0>0003o`0000X000Ko0000o`03o`h000?o00002P001_l0003o00?o
3`000ol0000:0005o`000?l00P000ol0000=0003o`0000X000Go0000o`0200;o3P000ol0000;0005
o`000?l010000ol0000;0003o`0000@000060003o`0000/01_l?00;o3P06o`030?l000d000?o0000
2`06oa0000?o00002`06oa4000?o00002`05o`030?l000h000?o00002`05o`<000?o00002`000ol0
000<00Ko0P000ol0000;0003o`0000@000060003o`0001001?l<00;o5002o`h000?o00004@03o`d0
00?o00004004o`h000?o00004002o`l000?o00004003o`h000?o00004P02o`h000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P3oo`7o
1P0000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0000/00olB00;o3P03oa<000?o00002`03oa<000?o00002`03oa@000?o00002`03oa<000?o0000
2`03oa<000?o00003003oa<000?o0000100000H000?o00003P000ol0000?00;o4@000ol0000@0003
o`0000h000?o000040000ol0000>0003o`00014000?o00003P000ol0000@0003o`0000h000?o0000
40000ol0000?0003o`00010000?o0000100000H000?o00002`04o`800ol<00;o3P04o`800_l>0003
o`0000/01?l0103oool>0003o`0000/01?l200?o3P000ol0000;00Co00@0oooo3P000ol0000;00Co
00<0ool00_l=0003o`0000`01?l0103oool>0003o`0000@000060003o`0000X000Go0000o`030003
o`0000/00_l=0007o`000?l0o`020003o`0000/000?o00002P001Ol0003o00@000?o00002`000ol0
000:0005o`000?l00`000ol0000=0003o`0000X000Go0000o`040003o`0000/000?o00002P001Ol0
003o008000?o00003@000ol0000;0005o`000?l00P000ol0000=0003o`0000@000060003o`0000X0
00Ko0000o`04o``00_l=0007o`000?l0o`020003o`0000/000?o00002P001Ol0003o00@000?o0000
2`000ol0000:0006o`000?l01?l>0003o`0000X000Go0000o`040003o`0000/000?o00002P001Ol0
003o00<000?o000030000ol0000;0005o`000?l00P000ol0000=0003o`0000@000060003o`0000X0
00Wo0000o`3o0?l03@02o`d000Ko0000o`03o`h000?o00002P001_l0003o00?o3P000ol0000:0009
o`000?l0o`3o00l000?o00002P001Ol0003o00800_l>0003o`0000X000Go0000o`040003o`0000/0
00?o00002`001Ol0003o008000?o00003@000ol0000400001P000ol0000;00Ko00<0o`003002o`h0
1_l@0003o`0000/01_l@0003o`0000/01_l00`3o000>0003o`0000/01Ol30003o`0000/000?o0000
2`06o`8000?o00002`000ol0000<00Go00<0o`003P000ol0000400001P000ol0000A00;o3@02oa@0
0ol=0003o`0001001?l=0003o`0001400_l?0003o`0001000ol>0003o`0001400_l>0003o`000140
0_l?0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00002`03oa800_l>00?o4`000ol0000;00?o4`000ol0000;00?o
50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o4`000ol0000400001P000ol0000>0003
o`0000l00_lA0003o`00010000?o00003P000ol0000@0003o`0000h000?o00004@000ol0000>0003
o`00010000?o00003P000ol0000@0003o`0000l000?o000040000ol0000400001P000ol0000;00Co
00@0oooo3@02o`h01?l0103oool>0003o`0000/01?l00`3oo`02o`d000?o00002`04o`040?ooo`l0
00?o00002`04o`800ol=0003o`0000/01?l0103oool>0003o`0000`01?l200;o3P000ol000040000
1P000ol0000:0005o`000?l010000ol0000:00;o3@001Ol0003o008000?o00003@000ol0000:0005
o`000?l00P000ol0000=0003o`0000X000Go0000o`040003o`0000`000?o00002P001Ol0003o00<0
00?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000/000Oo0000o`3o008000?o0000
2`000ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o3@001Ol0003o008000?o0000
3@000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Go0000o`040003o`0000`000?o0000
2P001_l0003o00Co3@000ol0000:0005o`000?l010000ol0000;0003o`0000/000Oo0000o`3o0080
00?o00002`000ol0000400001P000ol0000:0005o`000?l00P02o`d00_l=0005o`000?l00P000ol0
000=0003o`0000X000Go0000o`040003o`0000/000?o00002P001Ol0003o00800_l?0003o`0000X0
00Wo0000o`3o0?l03P000ol0000:0006o`000?l00ol>0003o`0000/000Ko0000o`03o`h000?o0000
100000H000?o00002`05o`<000?o00002P02o`h01Ol00`3o000>0003o`0000/01_l20003o`0000/0
00?o00002`05o`<000?o000030000ol0000;00Ko00<0o`003@000ol0000;00Ko40000ol0000<00Ko
40000ol0000400001P000ol0000@00?o3@02oa<00_l?0003o`0001400_l>0003o`0001000ol?0003
o`0001400_l>0003o`0001001?l=0003o`0001800ol=0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0ool1o`H000060003omoO023O
0_lT8`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooO
g`0Pg`;o92<00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?ogml08=l2ob@S00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003omoO023O0_lT8`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ooOg`0Pg`;o92<00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?ogml08=l2ob@S00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003omoO023O0_lT8`03omoO027O00?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ooOg`0Qg`03o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?ogml08Ml00ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03omoO027O00?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ooOg`0Qg`03o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?ogml08Ml00ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03omoO027O
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0;g`?o4]l2o`hS
0olC8`03omoO00_O0olCg`03o`0000/00olD0003o`0000/00olC0003o`0000/00olC0003o`0000`0
0olC0003o`0000@000060003omoO00kO00?ogml03ml2oa4S00?o8b<042<00ooOg`0>g`03omoO013O
00?o00003P000ol0000A0003o`0000h000?o000040000ol0000>0003o`00010000?o00003`000ol0
000@0003o`0000@000060003omoO00_O1?l00mooo`02o`cO0_l>8`Co00@Soooo3R<00ooOg`0;g`Co
00COoooo3]l00ol0000;00Co00<0ool00_l>0003o`0000/01?l200;o3P000ol0000;00Co0P03o`d0
00?o00003004o`040?ooo`h000?o0000100000H000?ogml02]l01OoOgmoo00;O00?ogml03=l2o`dS
00Go8b<So`048`03ob<S00/S00?ogml02]l01OoOgmoo00;O00?ogml03Ml00ol0000:0005o`000?l0
0P000ol0000>0003o`0000X000Oo0000o`3o008000?o00002`000ol0000:0005o`000?l00`000ol0
000<0003o`0000/000Go0000o`040003o`0000/000?o0000100000H000?ogml02]l01OoOgmoo00?O
00?ogml02ml2o`dS00Go8b<So`048`03ob<S00/S00?ogml02]l01OoOgmoo00;O00?ogml03Ml00ol0
000:0005o`000?l00`000ol0000=0003o`0000X000Oo0000o`3o008000?o00002`000ol0000:0006
o`000?l01?l=0003o`0000/000Go0000o`040003o`0000/000?o0000100000H000?ogml02]l01OoO
gmoo00CO00?ogml02]l2o`dS00Go8b<So`028`;o3R<00ooOg`0:g`05omoOgol00]l00ooOg`0=g`03
o`0000X000Go0000o`040003o`0000`000?o00002P001_l0003o00?o3P000ol0000:0009o`000?l0
o`3o00h000?o00002`001_l0003o00?o3P000ol0000400001P000ooOg`0;g`Ko0]l00ooOg`0:g`;o
3R<5o`<S00?o8b<02b<00ooOg`0;g`Go00?Ooml03]l00ol0000;00Ko0P000ol0000<0003o`0000/0
1_l@0003o`0000/01_l00`3o000=0003o`0000`01_l@0003o`0000@000060003omoO017O0_l=g`;o
4b<3o`hS00?ogml04=l2o`oO00?o00004@02o`l000?o00004@03o`d000?o00004@02o`h000?o0000
4@04o`d000?o0000100000H000?ogml08=l2ob@S00?ogml08Ml00ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003omoO023O0_lT8`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ooOg`0Qg`03o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?ogml08Ml00ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03omoO027O00?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ooOg`0Qg`03
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03
omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o
92<00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml0
8=l2ob@S00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
omoO023O0_lT8`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ooOg`0Pg`;o92<00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?ogml08=l2ob@S00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003omoO023O0_lT8`03omoO027O00?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ooOg`0Pg`;o92<00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H0ool1o`H000060003omoO023O0_lTg`03ob<S024S00?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olS8`0Q8`03o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o8b<08B<00ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03ob<S024S
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olS
8`0Q8`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO
00?o8b<08B<00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O
0_lTg`03ob<S024S00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooO
g`0Pg`;o9=l00olS8`0Q8`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?ogml08=l2obCO00?o8b<08B<00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003omoO023O0_lTg`03ob<S024S00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ooOg`0Pg`;o9=l00olS8`0Q8`03o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?ogml08=l2obCO00?o8b<08B<00ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003omoO023O0_lTg`03ob<S024S00?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ooOg`0;g`?o4]l2o`kO0olCg`03ob<S00/S0olC8`03o`0000/0
0olD0003o`0000/00olC0003o`0000/00olC0003o`0000`00olC0003o`0000@000060003omoO00kO
00?ogml03ml2oa7O00?ogml04=l00olS8`0>8`03ob<S010S00?o00003P000ol0000A0003o`0000h0
00?o000040000ol0000>0003o`00010000?o00003`000ol0000@0003o`0000@000060003omoO00_O
1?l01=ooool=g`;o3]l4o`03gooo00;o3Ml00olS8`0;8`Co00@Soooo3R<00ol0000;00Co00@0oooo
3`000ol0000;00Co00@0oooo3P000ol0000;00Co0P02o`h000?o00003004o`800ol=0003o`0000@0
00060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=g`05omoOgol00]l00ooOg`0=g`03ob<S00XS
00Go8b<So`048`03ob<S00/S00?o00002P001Ol0003o008000?o00003P000ol0000:0005o`000?l0
10000ol0000;0003o`0000X000Oo0000o`3o008000?o00002`000ol0000;0005o`000?l00`000ol0
000<0003o`0000@000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=g`05omoOgol00ml00ooO
g`0<g`03ob<S00XS00Go8b<So`048`03ob<S00/S00?o00002P001Ol0003o008000?o00003P000ol0
000:0005o`000?l010000ol0000;0003o`0000X000Oo0000o`3o008000?o00002`000ol0000;0006
o`000?l01?l=0003o`0000@000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=g`05omoOgol0
1=l00ooOg`0;g`03ob<S00XS00Go8b<So`028`;o3R<00ol0000:0005o`000?l00P000ol0000>0003
o`0000X000Ko0000o`03o`h000?o00002P001_l0003o00?o3P000ol0000;0009o`000?l0o`3o00h0
00?o0000100000H000?ogml02ml5o`03gooO00gO0_l>g`Ko0]l00ooOg`0;g`03ob<S00/S1Ol38`03
ob<S00/S00?o00002`05o`030?l000l000?o00002`06oa0000?o00002`06oa0000?o00003006o`03
0?l000d000?o0000100000H000?ogml04=l2o`kO0_lDg`;o3]l00olS8`0@8`?o3R<00ol0000@00;o
40000ol0000@00Co3@000ol0000A00?o3@000ol0000B00;o3P000ol0000400001P000ooOg`0Pg`;o
9=l00olS8`0Q8`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml0
8=l2obCO00?o8b<08B<00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
omoO023O0_lTg`03ob<S024S00?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ooOg`0Pg`;o9=l00olS8`0Q8`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?ogml08=l2obCO00?o8b<08B<00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003omoO023O0_lTg`03ob<S024S00?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ooOg`0Pg`;o9=l00olS8`0Q8`03o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?ogml08=l2obCO00?o8b<08B<00ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003omoO023O0_lTg`03ob<S024S00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olS8`0Q8`03o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o8b<08B<00ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lTg`03ob<S024S00?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o9=l00olS8`0Q8`03
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2obCO00?o8b<0
8B<00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000050?oo0_l600001@3oo`;o
1P0000H000?o00007`03obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0001h000Co0?oo9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00007@000ol00002obCO00?ogml08Ml00ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0001`000Co00000_lTg`03omoO027O00?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000K0003o`0000800_lTg`03
omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000J0003
o`0000<00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000I0003o`0000@00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000H0003o`0000D00_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000600;o00<0ool030000ol0000600;o9=l00ooO
g`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001`000ol0
o`0<0003o`0000L00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000080003o`0000X000?o00002002obCO00?ogml08Ml00ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0000L000?o0?l02P000ol0000900;o9=l00ooO
g`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001P02o`03
0?oo00P000?o00002P02o`kO0olCg`03omoO00_O0olCg`03o`0000/00olD0003o`0000/00olC0003
o`0000/00olC0003o`0000`00olC0003o`0000@000060003o`00018000?o00002`02oa7O00?ogml0
4=l00ooOg`0>g`03omoO013O00?o00003P000ol0000A0003o`0000h000?o000040000ol0000>0003
o`00010000?o00003`000ol0000@0003o`0000@000060003o`00014000?o00003002o`kO1?l01=oo
ool>g`03omoO00_O1?l00mooo`02o`gO00?o00002`04o`040?ooo`l000?o00002`04o`800ol=0003
o`0000/01?l0103oool>0003o`0000`01?l200;o3P000ol0000400001P000ol0000@0003o`0000d0
0_l=g`05omoOgol00]l00ooOg`0=g`03omoO00[O00GogmoOo`02g`03omoO00gO00?o00002P001Ol0
003o00@000?o000030000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Go0000o`040003
o`0000/000?o00002`001ol0003o0?l00P000ol0000;0003o`0000@000060003o`0000l000?o0000
3P02o`gO00GogmoOo`02g`03omoO00gO00?ogml02]l01OoOgmoo00?O00?ogml03=l00ol0000:0005
o`000?l010000ol0000<0003o`0000X000Ko0000o`04o`d000?o00002P001Ol0003o00@000?o0000
2`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00003P000ol0000?00;o
3Ml01OoOgmoo00;O00?ogml03Ml00ooOg`0:g`05omoOgol01=l00ooOg`0;g`03o`0000X000Go0000
o`0200;o3`000ol0000:0009o`000?l0o`3o00h000?o00002P001_l0003o00?o3P000ol0000;0006
o`000?l00ol>0003o`0000@000060003o`0000d000?o00004002o`kO1Ol00moog`0>g`03omoO00_O
1_l2g`03omoO00_O00?o00002`05o`<000?o000030000ol0000;00Ko00<0o`003@000ol0000;00Ko
40000ol0000<00Ko40000ol0000400001P000ol0000<0003o`0000H00ol800;o4ml2o`oO00?ogml0
4Ml2o`kO00?o00004003o`l000?o00004@02o`h000?o00004004o`d000?o00004P03o`d000?o0000
100000H000?o00002`000ol000080003o`0000L00_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000:0003o`0000X000?o00001P02obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000T000?o0000
2`000ol0000600;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o000020000ol0000;0003o`3o00L00_lTg`03omoO027O00?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol000070003o`0000`000?o0?l01`02obCO00?ogml0
8Ml00ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000H000?o0000
3002o`030?oo00H00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000050003o`0001P00_lTg`03omoO027O00?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol000040003o`0001T00_lTg`03omoO027O00?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol000030003o`0001X00_lTg`03omoO027O
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol000020003o`0001/0
0_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P001Ol0
003o01h00_lTg`03omoO027O00?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P001?l00?lO00;o9=l00ooOg`0Qg`03o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o0?l08002obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@0000600;o8@02obCO00?ogml08Ml00ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060?oo0Ol60000:@02on40003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0
003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0000>00;o2P02on400ol<0000
3P000ol0000:0003o`000>0000?o00002`0000L00ol40003o`0000800ol50003o`000<L00_l00`3o
o`090003o`3o00T000?o00002P0000L000Co003o0`000ol000050003o`00008000?o0000b0000ol0
o`0;0003o`0000P000?o00002P0000T00_l30003o`0000D000?o00000P000ol000390003o`0000P0
1Ol70003o`3o00/0000700;o1@000ol0000300;o1@000ol000380003o`3o00/000?o00001`000ol0
o`0;00001`001?l00?l30003o`0000D000?o00000P000ol0003700;o00<0ool04`02o`030?oo00X0
000800?o0`02o`<00ol400;ol0000?l03@000?l03@000?l03@000001\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"Subgroups"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[22]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Use the ",
  StyleBox["PreviousStage", "MR"],
  " function, with ",
  StyleBox["Closure", "MR"],
  " as its argument, to see the previous iteration."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PreviousStage[Closure]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 0 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g5)] .22789 .77381 0 0 Mshowa
[(g1)] .36395 .77381 0 0 Mshowa
[(g4)] .5 .77381 0 0 Mshowa
[(g6)] .63605 .77381 0 0 Mshowa
[(g2)] .77211 .77381 0 0 Mshowa
[(g3)] .90816 .77381 0 0 Mshowa
[(g1)] .22789 .63776 0 0 Mshowa
[(g2)] .36395 .63776 0 0 Mshowa
[(g3)] .5 .63776 0 0 Mshowa
[(g4)] .63605 .63776 0 0 Mshowa
[(g5)] .77211 .63776 0 0 Mshowa
[(g6)] .90816 .63776 0 0 Mshowa
[(g6)] .22789 .5017 0 0 Mshowa
[(g3)] .36395 .5017 0 0 Mshowa
[(g2)] .5 .5017 0 0 Mshowa
[(g5)] .63605 .5017 0 0 Mshowa
[(g4)] .77211 .5017 0 0 Mshowa
[(g1)] .90816 .5017 0 0 Mshowa
[(g3)] .22789 .36565 0 0 Mshowa
[(g4)] .36395 .36565 0 0 Mshowa
[(g1)] .5 .36565 0 0 Mshowa
[(g2)] .63605 .36565 0 0 Mshowa
[(g6)] .77211 .36565 0 0 Mshowa
[(g5)] .90816 .36565 0 0 Mshowa
[(g2)] .22789 .22959 0 0 Mshowa
[(g5)] .36395 .22959 0 0 Mshowa
[(g6)] .5 .22959 0 0 Mshowa
[(g3)] .63605 .22959 0 0 Mshowa
[(g1)] .77211 .22959 0 0 Mshowa
[(g4)] .90816 .22959 0 0 Mshowa
[(g4)] .22789 .09354 0 0 Mshowa
[(g6)] .36395 .09354 0 0 Mshowa
[(g5)] .5 .09354 0 0 Mshowa
[(g1)] .63605 .09354 0 0 Mshowa
[(g3)] .77211 .09354 0 0 Mshowa
[(g2)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00002`03oa800_l>00?o4`000ol0000;00?o4`000ol0
000;00?o50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o4`000ol0000400001P000ol0
000>0003o`0000l00_lA0003o`00010000?o00003P000ol0000@0003o`0000h000?o00004@000ol0
000>0003o`00010000?o00003P000ol0000@0003o`0000l000?o000040000ol0000400001P000ol0
000;00Co0P02o`d00_l>00Co0P03o`d000?o00002`04o`800_l>0003o`0000/01?l0103oool?0003
o`0000/01?l0103oool>0003o`0000/01?l0103oool>0003o`0000`01?l00`3oo`02o`d000?o0000
100000H000?o00002P001ol0003o0?l00P000ol0000:00;o3@001Ol0003o00<000?o000030000ol0
000:0007o`000?l0o`020003o`0000/000?o00002P001Ol0003o00@000?o000030000ol0000:0005
o`000?l00P000ol0000=0003o`0000X000Go0000o`040003o`0000/000?o00002`001Ol0003o0080
00?o00003@000ol0000400001P000ol0000:0007o`000?l0o`020003o`0000X00_l=0006o`000?l0
1?l=0003o`0000X000Oo0000o`3o008000?o00002`000ol0000:0005o`000?l010000ol0000<0003
o`0000X000Go0000o`020003o`0000d000?o00002P001Ol0003o00@000?o00002`000ol0000;0005
o`000?l00`000ol0000<0003o`0000@000060003o`0000X000Ko0000o`03o`d00_l=0009o`000?l0
o`3o00h000?o00002P001_l0003o00?o3P000ol0000:0006o`000?l00ol?0003o`0000X000Go0000
o`020003o`0000d000?o00002P001Ol0003o00800_l>0003o`0000/000Go0000o`040003o`0000/0
00?o0000100000H000?o00002`06o`l00_l>00Ko00<0o`003@000ol0000;00Ko40000ol0000;00Ko
4@000ol0000;00Go00<0o`003P000ol0000;00Go0`000ol0000;0003o`0000`01_l20003o`0000/0
00?o0000100000H000?o00004@03o``00_lD00;o3P000ol0000A00?o3@000ol0000@00Co3P000ol0
000@00;o3`000ol0000@00?o3P000ol0000B00;o3P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00002`03oa800_l>00?o
4`000ol0000;00?o4`000ol0000;00?o50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o
4`000ol0000400001P000ol0000>0003o`0000l00_lA0003o`00010000?o00003P000ol0000@0003
o`0000h000?o00004@000ol0000>0003o`00010000?o00003P000ol0000@0003o`0000l000?o0000
40000ol0000400001P000ol0000;00Co00@0oooo3@02o`h01?l00`3oo`02o`d000?o00002`04o`04
0?ooo`h000?o00002`04o`800_l?0003o`0000/01?l0103oool>0003o`0000/01?l0103oool>0003
o`0000`01?l200?o3@000ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o3@001Ol0
003o008000?o00003@000ol0000:0005o`000?l010000ol0000;0003o`0000X000Oo0000o`3o0080
00?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000X000Go0000o`020003o`0000d0
00?o00002`001Ol0003o00<000?o000030000ol0000400001P000ol0000:0005o`000?l010000ol0
000:00;o3@001Ol0003o00<000?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000X0
00Oo0000o`3o008000?o000030000ol0000:0005o`000?l010000ol0000;0003o`0000X000Go0000
o`020003o`0000d000?o00002`001_l0003o00Co3@000ol0000400001P000ol0000:0006o`000?l0
0ol=00;o3@001Ol0003o00@000?o00002`000ol0000:0006o`000?l00ol>0003o`0000X000Ko0000
o`03o`l000?o00002P001Ol0003o00800_l>0003o`0000X000Go0000o`020003o`0000d000?o0000
2`002Ol0003o0?l0o`0>0003o`0000@000060003o`0000/01_l?00;o3P06o`8000?o00002`000ol0
000;00Ko40000ol0000;00Ko4@000ol0000;00Go0`000ol0000;0003o`0000/01Ol00`3o000>0003
o`0000`01_l00`3o000=0003o`0000@000060003o`0001001?l<00;o5002o`h000?o00004004o`d0
00?o00004@03o`h000?o00004003o`h000?o00004002o`l000?o00004P02o`h000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P3oo`7o
1P0000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0000/00olB00;o3P03oa<000?o00002`03oa<000?o00002`03oa@000?o00002`03oa<000?o0000
2`03oa<000?o00003003oa<000?o0000100000H000?o00003P000ol0000?00;o4@000ol0000@0003
o`0000h000?o000040000ol0000>0003o`00014000?o00003P000ol0000@0003o`0000h000?o0000
40000ol0000?0003o`00010000?o0000100000H000?o00002`04o`800ol<00;o3P04o`040?ooo`h0
00?o00002`04o`800ol=0003o`0000/01?l0103oool?0003o`0000/01?l00`3oo`02o`d000?o0000
2`04o`800_l>0003o`0000`01?l0103oool>0003o`0000@000060003o`0000X000Go0000o`030003
o`0000/00_l=0005o`000?l010000ol0000;0003o`0000X000Go0000o`030003o`0000`000?o0000
2P001Ol0003o008000?o00003P000ol0000:0005o`000?l00P000ol0000=0003o`0000X000Oo0000
o`3o008000?o00002`000ol0000;0005o`000?l010000ol0000;0003o`0000@000060003o`0000X0
00Ko0000o`04o``00_l=0005o`000?l010000ol0000;0003o`0000X000Ko0000o`04o`d000?o0000
2P001Ol0003o008000?o00003P000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Oo0000
o`3o008000?o00002`000ol0000;0005o`000?l010000ol0000;0003o`0000@000060003o`0000X0
00Wo0000o`3o0?l03@02o`d000Go0000o`0200;o3P000ol0000:0009o`000?l0o`3o00h000?o0000
2P001Ol0003o008000?o00003P000ol0000:0005o`000?l010000ol0000;0003o`0000X000Ko0000
o`03o`h000?o00002`001_l0003o00?o3P000ol0000400001P000ol0000;00Ko00<0o`003002o`h0
1Ol30003o`0000/000?o00002`06o`030?l000d000?o00002`05o`030?l000l000?o00002`06o`80
00?o00002`000ol0000;00Ko40000ol0000<00Ko40000ol0000400001P000ol0000A00;o3@02oa<0
0ol>0003o`0001400_l>0003o`0001000_l@0003o`0001400_l>0003o`0001400ol=0003o`000140
1?l=0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060?oo0Ol600001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00002`03oa800_l>00?o4`000ol0000;00?o4`000ol0000;00?o
50000ol0000;00?o4`000ol0000;00?o4`000ol0000<00?o4`000ol0000400001P000ol0000>0003
o`0000l00_lA0003o`00010000?o00003P000ol0000@0003o`0000h000?o00004@000ol0000>0003
o`00010000?o00003P000ol0000@0003o`0000l000?o000040000ol0000400001P000ol0000;00Co
00@0oooo3@02o`h01?l200;o3P000ol0000;00Co00@0oooo3P000ol0000;00Co00<0ool00_l>0003
o`0000/01?l0103oool>0003o`0000/01?l200?o3@000ol0000<00Co00@0oooo3P000ol000040000
1P000ol0000:0005o`000?l010000ol0000:00;o3@001ol0003o0?l00P000ol0000;0003o`0000X0
00Go0000o`040003o`0000/000?o00002P001Ol0003o008000?o00003P000ol0000:0005o`000?l0
10000ol0000;0003o`0000X000Go0000o`030003o`0000`000?o00002`001Ol0003o008000?o0000
3@000ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o3@001ol0003o0?l00P000ol0
000;0003o`0000X000Go0000o`040003o`0000/000?o00002P001Ol0003o00<000?o00003@000ol0
000:0005o`000?l010000ol0000;0003o`0000X000Ko0000o`04o`d000?o00002`001Ol0003o0080
00?o00003@000ol0000400001P000ol0000:0005o`000?l00P02o`d00_l=0006o`000?l00ol>0003
o`0000X000Go0000o`0200;o3P000ol0000:0005o`000?l010000ol0000<0003o`0000X000Ko0000
o`03o`h000?o00002P002Ol0003o0?l0o`0>0003o`0000/000Go0000o`020003o`0000d000?o0000
100000H000?o00002`05o`<000?o00002P02o`h01_l@0003o`0000/01Ol30003o`0000/000?o0000
2`06o`8000?o000030000ol0000;00Ko40000ol0000;00Ko00<0o`003@000ol0000<00Go00<0o`00
3P000ol0000400001P000ol0000@00?o3@02oa@00ol=0003o`0001000ol>0003o`0001400_l?0003
o`0001001?l=0003o`0001400_l>0003o`0001400_l?0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0ool1o`H000060003o`000200
0_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0
000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000;00?o4P02o`h0
0olC0003o`0000/00olC0003o`0000/00olD0003o`0000/00olC0003o`0000/00olC0003o`0000`0
0olC0003o`0000@000060003o`0000h000?o00003`02oa4000?o000040000ol0000>0003o`000100
00?o00003P000ol0000A0003o`0000h000?o000040000ol0000>0003o`00010000?o00003`000ol0
000@0003o`0000@000060003o`0000/01?l00`3oo`02o``00_l>00Co00@0oooo3P000ol0000;00Co
00<0ool00_l=0003o`0000/01?l0103oool?0003o`0000/01?l200?o3@000ol0000;00Co00@0oooo
3P000ol0000<00Co0P02o`h000?o0000100000H000?o00002P001Ol0003o008000?o00003002o`d0
00Go0000o`020003o`0000d000?o00002P001Ol0003o008000?o00003@000ol0000:0005o`000?l0
10000ol0000<0003o`0000X000Go0000o`030003o`0000`000?o00002P001Ol0003o00@000?o0000
2`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00002P001Ol0003o00<0
00?o00002`02o`d000Go0000o`020003o`0000d000?o00002P001Ol0003o00<000?o000030000ol0
000:0005o`000?l010000ol0000<0003o`0000X000Ko0000o`04o`d000?o00002P001Ol0003o00@0
00?o00002`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00002P001Ol0
003o00@000?o00002P02o`d000Go0000o`020003o`0000d000?o00002P001Ol0003o00@000?o0000
2`000ol0000:0005o`000?l00P02o`l000?o00002P002Ol0003o0?l0o`0>0003o`0000X000Ko0000
o`03o`h000?o00002`001_l0003o00?o3P000ol0000400001P000ol0000;00Ko0P000ol0000:00;o
3P05o`030?l000h000?o00002`06o`8000?o00002`000ol0000;00Go0`000ol0000<0003o`0000/0
1_l00`3o000=0003o`0000/01_l@0003o`0000`01_l@0003o`0000@000060003o`0001400_l=00;o
4`02o`l000?o00004@02o`h000?o00004003o`l000?o00004@02o`h000?o00004004o`d000?o0000
4P03o`d000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00008002ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0002000_lT0003
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000P00;o
90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o0000
8002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00008002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0002000_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H0ool1o`H000060003omoO023O0_lT8`03o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`000280
00?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O
0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooO
g`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H0
00?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`000280
00?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ooOg`0;g`?o4]l2o`hS0olC8`03o`0000/00olC0003o`0000/0
0olD0003o`0000/00olC0003o`0000/00olC0003o`0000`00olC0003o`0000@000060003omoO00kO
00?ogml03ml2oa4S00?o8b<042<00ol0000>0003o`00010000?o00003P000ol0000A0003o`0000h0
00?o000040000ol0000>0003o`00010000?o00003`000ol0000@0003o`0000@000060003omoO00_O
1?l01=ooool=g`;o3R<4o`048oooo`hS00?o00002`04o`040?ooo`h000?o00002`04o`800ol>0003
o`0000/01?l200;o3P000ol0000;00Co00<0ool00_l=0003o`0000`01?l0103oool>0003o`0000@0
00060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=8`05ob<S8ol012<00olS8`0;8`03o`0000X0
00Go0000o`020003o`0000d000?o00002P001Ol0003o00<000?o00003@000ol0000:0007o`000?l0
o`020003o`0000/000?o00002P001Ol0003o008000?o00003@000ol0000;0005o`000?l010000ol0
000;0003o`0000@000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=8`05ob<S8ol012<00olS
8`0;8`03o`0000X000Go0000o`020003o`0000d000?o00002P001_l0003o00Co3P000ol0000:0007
o`000?l0o`020003o`0000/000?o00002P001Ol0003o00<000?o000030000ol0000;0005o`000?l0
10000ol0000;0003o`0000@000060003omoO00[O00GogmoOo`02g`03omoO00cO0_l=8`06ob<S8olS
0ol>8`03o`0000X000Go0000o`020003o`0000d000?o00002P002Ol0003o0?l0o`0?0003o`0000X0
00Ko0000o`03o`h000?o00002P001Ol0003o00@000?o00002`000ol0000;0005o`000?l00P02o`h0
00?o0000100000H000?ogml02ml5o`03gooO00gO0_l>8`Ko42<00ol0000;00Go00<0o`003P000ol0
000;00Ko00<0o`003P000ol0000;00Ko40000ol0000;00Ko0P000ol0000;0003o`0000`01Ol30003
o`0000/000?o0000100000H000?ogml04=l2o`kO0_lC8`Co3B<00ol0000@00;o3`000ol0000A00;o
3`000ol0000A00?o3@000ol0000A00;o3P000ol0000A00?o3P000ol0000400001P000ooOg`0Pg`;o
92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml0
8=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003omoO023O0_lT8`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003o`00028000?o0000
8@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003omoO023O0_lT8`03o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ooOg`0Pg`;o92<00ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?ogml08=l2ob@S00?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000050?oo0_l600001@3oo`;o
1P0000H000?o00007`03obCO00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0001h000Co0?oo9=l00ol0000Q0003o`00028000?o00008@000ol0000Q0003
o`00028000?o0000100000H000?o00007@000ol00002obCO00?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0001`000Co00000_lTg`03o`00024000?o0000
8P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000K0003o`0000800_lTg`03
o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000J0003
o`0000<00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0000I0003o`0000@00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000H0003o`0000D00_lTg`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000600;o00<0ool030000ol0000600;o9=l00ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001`000ol0
o`0<0003o`0000L00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000080003o`0000X000?o00002002obCO00?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0000L000?o0?l02P000ol0000900;o9=l00ol0
000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001P02o`03
0?oo00P000?o00002P02o`kO0olCg`03o`0000/00olC0003o`0000/00olD0003o`0000/00olC0003
o`0000/00olC0003o`0000`00olC0003o`0000@000060003o`00018000?o00002`02oa7O00?ogml0
4=l00ol0000>0003o`00010000?o00003P000ol0000A0003o`0000h000?o000040000ol0000>0003
o`00010000?o00003`000ol0000@0003o`0000@000060003o`00014000?o00003002o`kO1?l01=oo
ool>g`03o`0000/01?l00`3oo`02o`d000?o00002`04o`040?ooo`l000?o00002`04o`800ol=0003
o`0000/01?l0103oool>0003o`0000`01?l200;o3P000ol0000400001P000ol0000@0003o`0000d0
0_l=g`05omoOgol00]l00ooOg`0=g`03o`0000X000Go0000o`020003o`0000d000?o00002P001Ol0
003o00@000?o000030000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Go0000o`040003
o`0000/000?o00002`001ol0003o0?l00P000ol0000;0003o`0000@000060003o`0000l000?o0000
3P02o`gO00GogmoOo`02g`03omoO00gO00?o00002P001Ol0003o00<000?o000030000ol0000:0005
o`000?l010000ol0000<0003o`0000X000Ko0000o`04o`d000?o00002P001Ol0003o00@000?o0000
2`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00003P000ol0000?00;o
3Ml01OoOgmoo00;O00?ogml03Ml00ol0000:0005o`000?l010000ol0000;0003o`0000X000Go0000
o`0200;o3`000ol0000:0009o`000?l0o`3o00h000?o00002P001_l0003o00?o3P000ol0000;0006
o`000?l00ol>0003o`0000@000060003o`0000d000?o00004002o`kO1Ol00moog`0>g`03o`0000/0
1_l20003o`0000/000?o00002`05o`<000?o000030000ol0000;00Ko00<0o`003@000ol0000;00Ko
40000ol0000<00Ko40000ol0000400001P000ol0000<0003o`0000H00ol800;o4ml2o`oO00?o0000
4@02o`h000?o00004003o`l000?o00004@02o`h000?o00004004o`d000?o00004P03o`d000?o0000
100000H000?o00002`000ol000080003o`0000L00_lTg`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol0000:0003o`0000X000?o00001P02obCO00?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000T000?o0000
2`000ol0000600;o9=l00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o000020000ol0000;0003o`3o00L00_lTg`03o`00024000?o00008P000ol0000Q0003
o`00024000?o00008P000ol0000400001P000ol000070003o`0000`000?o0?l01`02obCO00?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0000H000?o0000
3002o`030?oo00H00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0
000400001P000ol000050003o`0001P00_lTg`03o`00024000?o00008P000ol0000Q0003o`000240
00?o00008P000ol0000400001P000ol000040003o`0001T00_lTg`03o`00024000?o00008P000ol0
000Q0003o`00024000?o00008P000ol0000400001P000ol000030003o`0001X00_lTg`03o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol000020003o`0001/0
0_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P001Ol0
003o01h00_lTg`03o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P001?l00?lO00;o9=l00ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o0?l08002obCO00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@0000600;o8@02obCO00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060?oo0Ol60000:@02on40003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0
003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0003o00d0000>00;o2P02on400ol<0000
3P000ol0000:0003o`000>0000?o00002`0000L00ol40003o`0000800ol50003o`000<L00_l00`3o
o`090003o`3o00T000?o00002P0000L000Co003o0`000ol000050003o`00008000?o0000b0000ol0
o`0;0003o`0000P000?o00002P0000T00_l30003o`0000D000?o00000P000ol000390003o`0000P0
1Ol70003o`3o00/0000700;o1@000ol0000300;o1@000ol000380003o`3o00/000?o00001`000ol0
o`0;00001`001?l00?l30003o`0000D000?o00000P000ol0003700;o00<0ool04`02o`030?oo00X0
000800?o0`02o`<00ol400;ol0000?l03@000?l03@000?l03@000001\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Another function for working with individual subgroups is the ",
  StyleBox["SubgroupGenerated", "MR"],
  " function."
}], "Text",
  CellTags->"Subgroups"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SubgroupGenerated",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ an\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ from\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[\(\ give\ the\ subgroup\ generated\ \(by\ \)\),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[\(\ \[LeftAngleBracket]\),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox["\[RightAngleBracket]",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.4, 0.6}},
  CellTags->{"Subgroups", "i:13"}],

Cell[TextData[{
  "The ",
  StyleBox["SubgroupGenerated", "MR"],
  " function also reveals the order of an element, indicated by the number of \
elements in the subgroup that is generated."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupGenerated[Alternating[4], \ {2, 3, 1, 4}]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{{2, 3, 1, 4}, {3, 1, 2, 4}, {1, 2, 3, 4}}, "-Operation-"]\)], 
  "Output",
  CellLabel->"Out[24]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Use of the ",
  StyleBox["Textual", "MR"],
  " mode gives additional information about how this subgroup is generated."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupGenerated[U[25], \ 4, \ Mode\  \[Rule] \ Textual]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \("The group U[25] has the subgroup <4> given as"\)], "Print",
  CellTags->"Subgroups"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"index\"\>", "\<\"powers\"\>", \("simplified\n"\)},
          {"1", "\<\"(4)^1\"\>", 
            InterpretationBox[
              StyleBox["4",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 4],
              Editable->True,
              AutoDelete->True]},
          {"2", "\<\"(4)^2\"\>", 
            InterpretationBox[
              StyleBox["16",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 16],
              Editable->True,
              AutoDelete->True]},
          {"3", "\<\"(4)^3\"\>", 
            InterpretationBox[
              StyleBox["14",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 14],
              Editable->True,
              AutoDelete->True]},
          {"4", "\<\"(4)^4\"\>", 
            InterpretationBox[
              StyleBox["6",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 6],
              Editable->True,
              AutoDelete->True]},
          {"5", "\<\"(4)^5\"\>", 
            InterpretationBox[
              StyleBox["24",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 24],
              Editable->True,
              AutoDelete->True]},
          {"6", "\<\"(4)^6\"\>", 
            InterpretationBox[
              StyleBox["21",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 21],
              Editable->True,
              AutoDelete->True]},
          {"7", "\<\"(4)^7\"\>", 
            InterpretationBox[
              StyleBox["9",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 9],
              Editable->True,
              AutoDelete->True]},
          {"8", "\<\"(4)^8\"\>", 
            InterpretationBox[
              StyleBox["11",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 11],
              Editable->True,
              AutoDelete->True]},
          {"9", "\<\"(4)^9\"\>", 
            InterpretationBox[
              StyleBox["19",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 19],
              Editable->True,
              AutoDelete->True]},
          {"10", "\<\"(4)^10\"\>", 
            InterpretationBox[
              StyleBox["1",
                ShowStringCharacters->True,
                NumberMarks->True],
              InputForm[ 1],
              Editable->True,
              AutoDelete->True]}
          },
        RowSpacings->0.5,
        ColumnSpacings->7,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"index", "powers", 
        "simplified\n"}}, TableSpacing -> {0.5, 7}]&)]], "Print",
  CellTags->"Subgroups"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"as generated:\"\>", "4", "16", "14", "6", "24", "21", "9", 
            "11", "19", "1"},
          {"\<\"sorted:\"\>", "1", "4", "6", "9", "11", "14", "16", "19", 
            "21", "24"}
          },
        RowSpacings->0,
        ColumnSpacings->2,
        RowAlignments->Center,
        ColumnAlignments->{"Bottom"}],
      (TableForm[ #, TableHeadings -> {{"as generated:", "sorted:"}, None}, 
        TableAlignments -> {Bottom, Center}, TableSpacing -> {0, 2}]&)]], 
  "Print",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{4, 16, 14, 6, 24, 21, 9, 11, 19, 1}, Mod[#1\ #2, 25]&]\)], 
  "Output",
  CellLabel->"Out[25]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["\<\
There are two visual modes for this function. This one is best \
viewed as an animation after it is generated.\
\>", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SubgroupGenerated[Z[8], \ 6, \ Mode\  \[Rule] \ Visual]; \)\)], 
  "Input",
  CellLabel->"In[26]:=",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
1 0 0 r
.03 w
.16667 .5 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[26]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008d01M:>0000R`09dX`0
002:00_BR`0008T03M::0000R@0=dXX0002800oBR@0008P03m:90000P00024iPCV1>H4iP3m802F1>
H4iPCV1>H0200000N`001F5>HDiQ00P03m890004CV5>HG`0001f0005CV1>H4h03@0?dPd000E>H4iP
CP1g0000M0000diQ000B00gB4`000f5>001d0000L00014iPCV0E00gB5@001F1>H4iP0700001]0003
HDiQ01X02m8K0003CV4006d0001[0003H4h001d02M8N0003CV0006/0001Y0003HDh002401M8R0003
CV4006T0001W0003H4h004`000=>H4h0I`0006D000=QCP00D@000f5>001T0000HP000diPCP1F0003
H4h00680001P0003CV4005X000=QCP00H00005h000=>H000GP000f1>001N0000G@000f40001Q0003
H@0005`0001L0003CP0006<000=>0000F`0005X000=>H@00IP000f5>001J0000F0000diP001Z0003
H4h005P0001G0003H@0006d000=Q0000EP0005H000=>0000K`000dh0001E0000E0000diQ001b0003
HDh005@0001C0003H00007D000=P0000DP0004T01M850003H@0003P00olk0004CP0000GBB`0004L0
2M800`1PCP0l0003o`0003/000=Pd]801m990000AP0;dS`01?ll00_BB00004D03M8k0003o`3o03`0
3M970000A@0=dS/000?o0?l0?00=dTL0001400oB>`02oc/03m960000A00?dWP03m960000A00?dWP0
3m960000A00?dWP03m960000A00?dWP03m960000A@0=dWX03M970000A@0=dWX03M970000AP0;dW`0
2m980000A@000f00dP08dWh02M800`1>H0160000A0000dh0000200GBPP05dPD000=>0000@`0004@0
00=>0000T`000dh000130000@`000f40002E0003H@00048000120003CP0009L000=>0000@@000440
00=Q0000V@000f4000100000@@000f00002I0003H000040000100003CP0009/000=>0000?`000400
00=>00005`03of<00olK0003CP0003l0000o0003H@0001/000?o0000H`000ol0000I0003H@0003h0
000n0003CP0001`000?o0000H`000ol0000J0003CP0003d0000m0003H@0001X00omT00;o7P000f40
000l0000?@000f00000J0003o`0006H000?o00006`000f00000l0000?0000dh0000K00CoHP03oal0
00=>0000>`0003`000=>0000X`000dh0000k0000>`000f40002U0003H@0003X0000k0003H0000:D0
00=P0000>P0003X000=>0000Y`000dh0000i0000>P000dh0002W0003CP0003T0000i0003H@000:T0
00=Q0000>00003T000=P0000Z@000f00000h0000>0000dh0002Z0003H@0003P0000h0003CP000:/0
00=>0000=`0003P000=>0000Z`000dh0000g0000=`000f00002]0003H00003H0000g0003H@000:d0
00=Q0000=P0003H000=>0000[`000dh0000e0000=P000dh0002_0003CP0003D0000e0003H0000;40
00=P0000=00003D000=Q0000/@000f40000d0000=0000dh0002c0003CP0003<0000d0003CP000;<0
00=>0000<`0003@000=>0000/`000dh0000c0000=0000dh0002c0003CP0003<0000d0003CP000;<0
00=>0000<`0003<000=Q0000]@000f40000b0000<`000f00002e0003H0000380000b0003CP000;L0
00=>0000<@00038000=>0000]`000dh0000a0000<P000dh0002g0003CP000340000b0003CP000;L0
00=>0000<@00038000=>0000]`000dh0000a0000<@000f00002i0003H0000300000a0003H@000;T0
00=Q0000<000034000=P0000^@000f00000`0000<@000f40002i0003H@000300000`0003CP000;/0
00=>0000;`00030000=>0000^`000dh0000_0000<0000dh0002k0003CP0002l0000`0003CP000;/0
00=>0000;`00030000=>0000^`000dh0000_0000<0000dh0002k0003CP0002l0000`0003CP000;/0
00=>0000;`00030000=>0000^`000dh0000_0000;@05d[X01M8_0000:`09d[H02M8]0000:P0;d[@0
2m8/0000:@0=d[803M8[0000:@05dP@S1=:b00gB:`0000l00ol40003o`3o00<00_l:00GB1R<4dPl0
0_n=00Co3P0?dRX0000@0003o`0000@000Go0000o`020003o`0000L01=888`?B3P001?l00?n=0003
o`0000h03m8Z000040000ol0000200Go00D0o`00o`0900CB22<3dPh000Co003oSP000ol0000=00oB
:P00010000?o000010001?l00003o`X01=888`?B3P03oi0000?o0000300?dRX0000@0003o`0000P0
00?o00002P04dPPS0m8>0003o`0008d000Co003o3P0?dRX0000?00;o2`03o`X01=868`?B4003ohd0
0_l@00gB:`0002T01M848`CB/P0=dR/0000Z00_B]00;dR`0000[00WB]P09dRd0000]00GB^P05dRl0
000`0003CP000;/000=>0000;`00030000=>0000^`000dh0000_0000<0000dh0002k0003CP0002l0
000`0003CP000;/000=>0000;`00030000=>0000^`000dh0000_0000<0000dh0002k0003CP0002l0
000`0003CP000;/000=>0000;`00030000=>0000^`000dh0000_0000<@000f40002i0003H@000300
000a0003H0000;T000=P0000<000034000=Q0000^@000f40000`0000<@000f00002i0003H0000300
000a0003H@000;T000=Q0000<000038000=>0000]`000dh0000a0000<P000dh0002g0003CP000340
000b0003CP000;L000=>0000<@00038000=>0000]`000dh0000a0000<P000dh0002g0003CP000340
000c0003H@000;D000=Q0000<P0003<000=P0000]@000f00000b0000=0000dh0002c0003CP0003<0
000d0003CP000;<000=>0000<`0003@000=>0000/`000dh0000c0000=0000dh0002c0003CP0003<0
000e0003H@000;4000=Q0000=00003D000=P0000/@000f00000d0000=@000f40002a0003H@0003@0
000f0003CP000:l000=>0000=@0003H000=>0000[`000dh0000e0000=`000f00002]0003H00003H0
000g0003H@000:d000=Q0000=P0003P000=>0000Z`000dh0000g0000>0000dh0002[0003CP0003L0
000i0003H0000:T000=P0000>00003T000=Q0000Z@000f40000h0000>P000dh0002X0003H00003P0
000j0003CP000:L000=>0000>@0003X000=>0000Y`000dh0000i0000>`000f40002U0003H@0003X0
000k0003H0000:D000=P0000>P0003`000=>0000X`000dh0000k0000?0000dh0000L0003o`000680
0olO0003CP0003/0000m0003H@0001/000?o0000H`000ol0000M0003H@0003`0000n0003CP0001/0
00?o0000HP000ol0000L0003CP0003d0000o0003H@0001X000?o0000HP000ol0000K0003H@0003h0
000o0003H00001/000?o0000H@000ol0000K0003H00003h000100003CP0001L01?mR00;o70000dh0
000o0000@0000dh0002K0003CP0003l000110003H@0009T000=Q0000@000048000=>0000U`000dh0
00110000@`000f40002E0003H@00048000130003H00009D000=P0000@P0004@000=>H@00TP000f5>
00140000AP000dh00005dX801M830003CP0004D000160003C];B00OBOP09dP0304h004H0001600_B
O00;dTP0001500gBNP0=dTL0001500gBNP0=dTL0001400oBN00?dTH0001400oBN00?dTH0001400oB
N00?dTH0001400oBN00?dTH0001400oB>`02oc/03m960000A@0=dS/000Co003o>`0=dTL0001500gB
>`001?l00?lk00gBA`0004H02m800`1>000i0004o`00oc/000=>d]802M980000A`09dP8000=>0000
>0001?l00?lk0003CP3B00SBB@0004T01M850003H4h003P00_lj0003CV0000<01M9;0000E@000f40
001a0003H@0005@0001F0003CP0006l000=>0000E@0005L000=QCP00K0000diQ001G0000F@000f1>
001X0003CV0005T0001K0003H@0006D000=Q0000FP0005`000=>0000H`000dh0001K0000G@000f5>
001P0003CV4005d0001O0003H4h005`000=>H000G`00064000=QCP00F0000diQ001Q0000H`000f1>
001D0003CV0006<0001U0003HDiQ050000=>H@00I@0006P000=>H000BP000f1>H01X0000JP000diQ
00160003HDh006X0001/0003CV0001h01M8O0003H4h006`0001^0003CV5>01X02M8K0003HDh006h0
001a0004H4iPCQD02m8E0005CV1>H4h0L@0007D000=QCP004@0=dQ8000=>H@00M@0007L000EPCV1>
H00=00gB3@001F1>H4iP07P0001l0005CV5>HDh01`0?dPP000AQCV5>O@00084000MPCV1>H4iP00oB
00QPCV1>H4iPCX40002800oBR@0008P03m:90000R00?dXT0002900gBRP0008T03M::0000RP0;dX/0
002;00WBS00008d01M:>0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.50002, -1.50002, 0.0104531, 
  0.0104531}},
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
.5 .165 .165 r
.5 Mabswid
.5 .16667 m
.16667 .5 L
s
1 0 0 r
.03 w
.16667 .5 Mdot
.0425 w
.5 .16667 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .08333 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[26]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008L01?l30003o`3o00<0
0_n:0000R0000ol000040005o`000?l00P000ol000270000R@001?l00005o`050?l00?l0R@0008X0
00?o00000P001?l00003ohX000270004o`00o`P000?o0000RP0008P00_l:00?oR@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0008d01M:>0000R`02dP@S0m:<0000RP000m8S8`068`;BR`0008T000?B8b<0
22<2dXX000290003dR<S00PS0]::0000R0000m8S8`0:8`;BR@0008P000?B8b<02R<2dXT000200009
CV1>H4iPCV3B00`S0]802F1>H4iPCV1>H0200000N`001F5>HDiQ00P000?B8b<02R<2dPT000A>HDiQ
O00007H000E>H4iPCP0=00;B2R<3dPd000E>H4iPCP1g0000M0000diQ000B0003dR<S00PS0]8C0003
HDh007@0001`0004CV1>H1D000?Bdb<01b<3dQD000EPCV1>H01`0000K@000f5>H@0I00047];BdP@S
1=8K0003CV4006d0001[0003H4h001X000?C00002M8N0003CV0006/0001Y0003HDh001/000<N0000
0`05dR8000=>H@00J@0006L000=PCP0070000m<0000]0003CV1>06L0001U0003HDh001d000<N0000
<@000f5>001T0000HP000diPCP0O0003d`0003@000=PCP00HP00060000=>H@0080000ah0000g0003
HDh00600001N0003CV00024000?C0000>P000f1>001N0000G@000f40000Q00037P0003d000=Q0000
G00005`000=>00008@000m<0000o0003CP0005/0001J0003CV40028000<N0000@@000f5>001J0000
F0000diP000S0003d`0004@000=PCP00F00005L000=Q00008`000ah000170003H@0005H0001F0003
CP0002<000?C0000B@000dh0001E0000E0000diQ000T00037P0004/000=QCP00E00005<000=P0000
90000m<0001>0003H0000580001900GB1@000f40000S00037P0001800olk0004CP0000GBB`0004L0
2M800`1PCP0U0003d`0001@000?o0000>`000f3BdP07dTT0001600_B9P000ah0000C00Co?00;dTP0
001500gB90000m<0000D0003o`3o03`03M970000A@0=dR<000<N00005@000ol0o`0l00gBA`0004@0
3m8Q0003d`0001L00_lk00oBAP0004@03m8P00037P0005D03m960000A00?dQl000?C0000EP0?dTH0
001400oB7P000ah0001G00oBAP0004@03m8M0003d`0005P03m960000A@0=dQd000<N0000FP0=dTL0
001500gB70000m<0001K00gBA`0004H02m8L00037P0005d02m980000A@000f00dP08dQ`000?C0000
G`09dP0304iP04H000140003CP0000801M8M00037P0006801M850003CP0004<000140003CP0002<0
00?C0000K@000dh000130000@`000f40000S00037P0006l000=Q0000@P00048000=>00008`000m<0
001a0003CP00044000110003H@0002<000<N0000L`000f4000100000@@000f00000R0003d`0007@0
00=P0000@000040000=>00008P000ah0001f0003CP0003l000100003CP0001L00ol70003d`0005T0
0olK0003CP0003l0000o0003H@0001/000?o00000`000ah0001M0003o`0001T000=Q0000?P0003h0
00=>000070000ol000020003d`0005h000?o00006P000dh0000m0000?@000f40000J00?o10000ah0
001M00;o7P000f40000l0000?@000f00000J0003o`0000<000?C0000H0000ol0000K0003H00003`0
000l0003CP0001/01?l00`0N001O00?o7`000dh0000k0000?0000dh0000O0003d`00084000=>0000
>`0003/000=Q00007`000ah000230003H@0003X0000k0003H00001h000?C0000Q0000f00000j0000
>P000dh0000N00037P0008H000=>0000>@0003X000=>00007@000m<000270003CP0003T0000i0003
H@0001d000<N0000R@000f40000h0000>@000f00000L0003d`0008X000=P0000>00003P000=>0000
70000ah0002;0003H@0003P0000h0003CP0001/000?C0000S@000dh0000g0000>0000dh0000J0003
7P0008h000=>0000=`0003L000=P00006P000m<0002@0003H00003H0000g0003H@0001T000<N0000
T@000f40000f0000=P000dh0000I0003d`0009<000=>0000=@0003H000=>000060000ah0002D0003
CP0003D0000e0003H00001P000?C0000UP000f00000d0000=@000f40000G00037P0009L000=Q0000
=00003@000=>00005`000m<0002I0003CP0003<0000d0003CP0001H000<N0000VP000dh0000c0000
=0000dh0000E0003d`0009/000=>0000<`0003@000=>000050000ah0002L0003CP0003<0000d0003
CP0001<000?C0000W@000dh0000c0000<`000f40000C00037P0009l000=Q0000<P0003<000=P0000
4P000m<0002P0003H0000380000b0003CP00018000<N0000XP000dh0000a0000<P000dh0000A0003
d`000:<000=>0000<@00038000=>000040000ah0002T0003CP000340000b0003CP0000l000?C0000
Y@000dh0000a0000<P000dh0000>00037P000:H000=>0000<@00034000=P00003P000m<0002X0003
H0000300000a0003H@0000d000<N0000Z@000f40000`0000<@000f00000<0003d`000:X000=P0000
<000034000=Q00002`000ah0002[0003H@000300000`0003CP0000/000?C0000[@000dh0000_0000
<0000dh0000:00037P000:h000=>0000;`00030000=>00002@000m<0002_0003CP0002l0000`0003
CP0000P000<N0000/0000dh0000_0000<0000dh000070003d`000;4000=>0000;`00030000=>0000
1P000ah0002b0003CP0002l0000`0003CP0000D000?C0000/`000dh0000_0000<0000dh000040003
7P000;@000=>0000;`0002d01M840003d`000;<01M8_0000:`09dP0301h00;<02M8]0000:P0:dP03
d`000;802m8/0000:@0:dP037];B0;803M8[0000:@05dP@S00CCd];B/P0=dR/0000?00?o10000ol0
o`0300;o2P05dPHS1=8?00;oS@04o`h03m8Z000040000ol000040005o`000?l00P000ol0000700CB
22<3dPh000Co003oS@000ol0000>00oB:P00010000?o00000P05o`050?l00?l02@04dPPS0m8>0004
o`00ohh000?o00003@0?dRX0000@0003o`0000@000Co00000ol:00CB22<3dPh00on@0003o`0000`0
3m8Z000040000ol000080003o`0000X01=888`?B3P000ol0002=0004o`00o`h03m8Z00003`02o`/0
0ol:00CB1R<3dQ000on=00;o400=dR/0000Y00GB12<4d[803M8[0000:P0;d[@02m8/0000:`09d[H0
2M8]0000;@05d[X01M8_0000<0000dh0002k0003CP0002l0000`0003CP000;/000=>0000;`000300
00=>0000^`000dh0000_0000<0000dh0002k0003CP0002l0000`0003CP000;/000=>0000;`000300
00=>0000^`000dh0000_0000<0000dh0002k0003CP0002l0000`0003CP000;/000=>0000;`000340
00=Q0000^@000f40000`0000<@000f00002i0003H0000300000a0003H@000;T000=Q0000<0000340
00=P0000^@000f00000`0000<@000f40002i0003H@000300000b0003CP000;L000=>0000<@000380
00=>0000]`000dh0000a0000<P000dh0002g0003CP000340000b0003CP000;L000=>0000<@000380
00=>0000]`000dh0000a0000<`000f40002e0003H@000380000c0003H0000;D000=P0000<P0003@0
00=>0000/`000dh0000c0000=0000dh0002c0003CP0003<0000d0003CP000;<000=>0000<`0003@0
00=>0000/`000dh0000c0000=@000f40002a0003H@0003@0000e0003H0000;4000=P0000=00003D0
00=Q0000/@000f40000d0000=P000dh0002_0003CP0003D0000f0003CP000:l000=>0000=@0003L0
00=P0000[@000f00000f0000=`000f40002]0003H@0003H0000h0003CP000:/000=>0000=`0003P0
00=>0000Z`000dh0000g0000>@000f00002Y0003H00003P0000i0003H@000:T000=Q0000>00003X0
00=>0000Z0000f00000h0000>P000dh0002W0003CP0003T0000j0003CP000:L000=>0000>@0003/0
00=Q0000Y@000f40000j0000>`000f00002U0003H00003X0000l0003CP000:<000=>0000>`0003`0
00=>000070000ol0001R00?o7`000dh0000k0000?@000f40000K0003o`0006<000?o00007@000f40
000l0000?P000dh0000K0003o`00068000?o000070000dh0000m0000?`000f40000J0003o`000680
00?o00006`000f40000n0000?`000f00000K0003o`00064000?o00006`000f00000n0000@0000dh0
000G00CoHP02oa`000=>0000?`00040000=>0000V`000dh0000o0000@@000f40002I0003H@000400
00120003CP0009L000=>0000@@0004<000=Q0000U@000f4000120000@`000f00002E0003H0000480
00140003CV40098000=QCP00A00004H000=>00001M:200GB0`000dh000150000AP000dkBdP07dWh0
2M800`1>00160000AP0;dW`02m980000A@0=dWX03M970000A@0=dWX03M970000A00?dWP03m960000
A00?dWP03m960000A00?dWP03m960000A00?dWP03m960000A00?dS/00_lk00oBAP0004D03M8k0004
o`00oc/03M970000A@0=dS/000Co003o>`0=dTL0001600_B00<0CP00>@001?l00?lk0003C];B00WB
B00004L02M820003CP0003P000Co003o>`000dh0dP08dTT0001900GB1@000f1>000h00;o>P000diP
000300GBB`0005D000=Q0000L@000f40001D0000EP000dh0001_0003CP0005D0001G0003HDh006`0
00=>H@00E`0005T000=PCP00J0000diP001I0000F`000f40001U0003H@0005X0001L0003CP0006<0
00=>0000F`0005d000=QCP00H0000diQ001M0000G`000f1>001L0003CV0005l0001Q0003HDh005P0
00=>H@00H@0006<000=PCP00E0000diP001S0000I@000f5>H@1@0003CV4006D0001X0003CV0004X0
00=PCV00J00006X000=>H@00AP000f5>001Z0000K0000diP000N00GB7`000f1>001/0000KP000diQ
CP0J00WB6`000f5>001^0000L@00161>H4hE00_B5@001DiPCV1>0740001e0003HDh001403M8B0003
CV4007D0001g0005H4iPCV003@0=dPd000EPCV1>H01h0000O0001DiQCV5>00L03m880004HDiQCWd0
00210007H4iPCV1>H00?dP08H4iPCV1>H4j10000R00?dXT0002800oBR@0008P03m:90000R@0=dXX0
002900gBRP0008X02m:;0000R`09dX`0002=00GBSP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.50002, -1.50002, 0.0104531, 
  0.0104531}},
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
.5 .165 .165 r
.5 Mabswid
.5 .16667 m
.16667 .5 L
s
.83333 .5 m
.5 .16667 L
s
1 0 0 r
.03 w
.16667 .5 Mdot
.0425 w
.5 .16667 Mdot
.055 w
.83333 .5 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .08333 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.91667 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[26]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008L01?l30003o`3o00<0
0_n:0000R0000ol000040005o`000?l00P000ol000270000R@001?l00005o`050?l00?l0R@0008X0
00?o00000P001?l00003ohX000270004o`00o`P000?o0000RP0008P00_l:00?oR@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0008d01M:>0000R`02dP@S0m:<0000RP000m8S8`068`;BR`0008T000?B8b<0
22<2dXX000290003dR<S00PS0]::0000R0000m8S8`0:8`;BR@0008P000?B8b<02R<2dXT000200009
CV1>H4iPCV3B00`S0]802F1>H4iPCV1>H0200000N`001F5>HDiQ00P000?B8b<02R<2dPT000A>HDiQ
O00007H000E>H4iPCP0=00;B2R<3dPd000E>H4iPCP1g0000M0000diQ000B0003dR<S00PS0]8C0003
HDh007@0001`0004CV1>H1D000?Bdb<01b<00m;CdP0E0005H4iPCV00L00006d000=QCV406@0011kB
d]848`CB00<N000060000diQ001]0000J`000f1>000J0003d`0000WB0P000m<0000I0003CV0006/0
001Y0003HDh001/000<N00000`05dPD000<N00006P000diQ001Y0000I`000f1>000L0003d`0000l0
00?C00006`000diPCP1W0000I@000f5>000M00037P00014000<N00007@000f5>001T0000HP000diP
CP0O0003d`0001<000?C00007P000f1>001R0000H0000diQ000P00037P0001D000<N00007`000f5>
001P0000GP000diP000Q0003d`0001L000?C000080000f1>001N0000G@000f40000Q00037P0001T0
00<N00008@000f40001L0000G0000dh0000Q0003d`0001/000?C00008@000dh0001K0000FP000diQ
000R00037P0001d000<N00008@000f5>001J0000F0000diP000S0003d`0001l000?C00008P000f1>
001H0000E`000f40000S00037P00024000<N00008`000f40001F0000EP000dh0000S0003d`0002<0
00?C00008`000dh0001E0000E0000diQ000T00037P0002D000<N00008`000f5>001D0000D`000f00
000T0003d`0002L000?C000090000f00001B0000B@05dPD000=Q00008`000ah0000B00?o50000ah0
000T0004CP0000GBB`0004L02M800`1PCP0U0003d`0001@000?o000050000m<0000T0003H=;B00OB
B@0004H02m8V00037P0001<01?lF00037P0002<02m980000A@0=dR@000?C000050000ol0o`0H0003
d`0002403M970000A@0=dR<000<N00005@000ol0o`0I00037P0002003M970000A00?dR4000?C0000
5`02oaX000?C00007P0?dTH0001400oB80000ah0000e00037P0001d03m960000A00?dQl000?C0000
=`000m<0000L00oBAP0004@03m8N00037P0003T000<N00006`0?dTH0001400oB7@000m<0000k0003
d`0001X03m960000A@0=dQd000<N0000?@000ah0000J00gBA`0004D03M8L0003d`0003l000?C0000
6@0=dTL0001600_B70000ah0001100037P0001T02m980000A@000f00dP08dQ`000?C0000@`000m<0
000I00WB00<0CV00AP0004@000=>00000P05dQd000<N0000A@000ah0000J00GB1@000dh000130000
A0000dh0000S0003d`0004L000?C00008`000dh000130000@`000f40000S00037P0004T000<N0000
8`000f4000120000@P000dh0000S0003d`0004/000?C00008`000dh000110000@@000f40000S0003
7P0004d000<N00008`000f4000100000@@000f00000R0003d`0004l000?C00008P000f0000100000
@0000dh0000R00037P00054000<N00008P000dh0000o0000@0000dh0000G00?o1`000m<0001C0003
d`0000<00olK0003CP0003l0000o0003H@0001/000?o00000`000ah0001E00037P0000D000?o0000
6@000f40000n0000?P000dh0000L0003o`00008000?C0000E`000m<000040003o`0001X000=>0000
?@0003d000=Q00006P03o`@000<N0000F@0011h00002oah000=Q0000?00003d000=P00006P000ol0
00030003d`0005/000?C00000P000ol0000K0003H00003`0000l0003CP0001/01?l00`0N001N0004
7_oooal000=>0000>`0003`000=>00007`000m<0001O0003d`0001l000=>0000>`0003/000=Q0000
7`000ah0001Q00037P0001l000=Q0000>P0003/000=P00007P000m<0001S0003d`0001h000=P0000
>P0003X000=>00007P000ah0001U00037P0001h000=>0000>@0003X000=>00007@000m<0001W0003
d`0001d000=>0000>@0003T000=Q00007@000ah0001Y00037P0001d000=Q0000>00003T000=P0000
70000m<0001[0003d`0001`000=P0000>00003P000=>000070000ah0001]00037P0001/000=Q0000
>00003P000=>00006`000m<0001_0003d`0001/000=>0000=`0003P000=>00006P000ah0001a0003
7P0001X000=>0000=`0003L000=P00006P000m<0001c0003d`0001X000=P0000=P0003L000=Q0000
6@000ah0001e00037P0001T000=Q0000=P0003H000=>00006@000m<0001g0003d`0001T000=>0000
=@0003H000=>000060000ah0001i00037P0001P000=>0000=@0003D000=P000060000m<0001k0003
d`0001P000=P0000=00003D000=Q00005`000ah0001m00037P0001L000=Q0000=00003@000=>0000
5`000m<0001o0003d`0001L000=>0000<`0003@000=>00005P000ah0002100037P0001H000=>0000
<`0003@000=>00005@000m<000230003d`0001D000=>0000<`0003@000=>000050000ah000250003
7P0001@000=>0000<`0003@000=>00004`000m<000270003d`0001<000=>0000<`0003<000=Q0000
4`000ah0002900037P0001<000=Q0000<P0003<000=P00004P000m<0002;0003d`00018000=P0000
<P00038000=>00004P000ah0002=00037P00018000=>0000<@00038000=>00004@000m<0002?0003
d`00014000=>0000<@00038000=>000040000ah0002A00037P00010000=>0000<@00038000=>0000
3`000m<0002C0003d`0000l000=>0000<@00038000=>00003P000ah0002E00037P0000h000=>0000
<@00034000=P00003P000m<0002G0003d`0000h000=P0000<000034000=Q00003@000ah0002I0003
7P0000d000=Q0000<000034000=P000030000m<0002K0003d`0000`000=P0000<000034000=Q0000
2`000ah0002M00037P0000/000=Q0000<000030000=>00002`000m<0002O0003d`0000/000=>0000
;`00030000=>00002P000ah0002Q00037P0000X000=>0000;`00030000=>00002@000m<0002S0003
d`0000T000=>0000;`00030000=>000020000ah0002U00037P0000P000=>0000;`00030000=>0000
1`000m<0002W0003d`0000L000=>0000;`00030000=>00001P000ah0002Y00037P0000H000=>0000
;`00030000=>00001@000m<0002[0003d`0000D000=>0000;`00030000=>000010000ah0002]0003
7P0000@000=>0000;`0002d01M840003d`000:l000CC00001B<_0000:`09dP0301h00;8000<N8b<0
1b<]0000:P0:dP03d`000;802b</0000:@0:dP037];B0;803B<[0000:@05dP@S00CCd];B/P0=8b/0
000?00?o10000ol0o`0300;o2P05dPHS1=8?00;oS@04o`h03b<900?o10000ol0o`0300;o4P000100
00?o000010001Ol0003o008000?o00001`04dPPS0m8>0004o`00ohd000?o00003P0?8``000?o0000
0P001Ol0003o008000?o00003`00010000?o00000P05o`050?l00?l02@04dPPS0m8>0004o`00ohh0
00?o00003@0?8``000?o00001Ol01@3o003o0140000@0003o`0000@000Co00000ol:00CB22<3dPh0
0on@0003o`0000`03b<:00;o1@001?l00003oa80000@0003o`0000P000?o00002P04dPPS0m8>0003
o`0008d000Co003o3P0?8``000?o00001P000ol0000B00003`02o`/00ol:00CB1R<3dQ000on=00;o
400=8`X00ol:00?o4@0002T01M848`CB/P0=8b/0000Z00_B]00;8b`0000[00WB]P098bd0000]00GB
^P058bl0000`0003CP000;/000=>0000;`00030000=>0000^`000dh0000_0000<0000dh0002k0003
CP0002l0000`0003CP000;/000=>0000;`00030000=>0000^`000dh0000_0000<0000dh0002k0003
CP0002l0000`0003CP000;/000=>0000;`00030000=>0000^`000dh0000_0000<@000f40002i0003
H@000300000a0003H0000;T000=P0000<000034000=Q0000^@000f40000`0000<@000f00002i0003
H0000300000a0003H@000;T000=Q0000<000038000=>0000]`000dh0000a0000<P000dh0002g0003
CP000340000b0003CP000;L000=>0000<@00038000=>0000]`000dh0000a0000<P000dh0002g0003
CP000340000c0003H@000;D000=Q0000<P0003<000=P0000]@000f00000b0000=0000dh0002c0003
CP0003<0000d0003CP000;<000=>0000<`0003@000=>0000/`000dh0000c0000=0000dh0002c0003
CP0003<0000e0003H@000;4000=Q0000=00003D000=P0000/@000f00000d0000=@000f40002a0003
H@0003@0000f0003CP000:l000=>0000=@0003H000=>0000[`000dh0000e0000=`000f00002]0003
H00003H0000g0003H@000:d000=Q0000=P0003P000=>0000Z`000dh0000g0000>0000dh0002[0003
CP0003L0000i0003H0000:T000=P0000>00003T000=Q0000Z@000f40000h0000>P000dh0002X0003
H00003P0000j0003CP000:L000=>0000>@0003X000=>0000Y`000dh0000i0000>`000f40002U0003
H@0003X0000k0003H0000:D000=P0000>P0003`000=>0000X`000dh0000k0000?0000dh0000L0003
o`0006800olO0003CP0003/0000m0003H@0001/000?o0000H`000ol0000M0003H@0003`0000n0003
CP0001/000?o0000HP000ol0000L0003CP0003d0000o0003H@0001X000?o0000HP000ol0000K0003
H@0003h0000o0003H00001/000?o0000H@000ol0000K0003H00003h000100003CP0001L01?mR00;o
70000dh0000o0000@0000dh0002K0003CP0003l000110003H@0009T000=Q0000@000048000=>0000
U`000dh000110000@`000f40002E0003H@00048000130003H00009D000=P0000@P0004@000=>H@00
TP000f5>00140000AP000dh00005dX801M830003CP0004D000160003C];B00OBOP09dP0304h004H0
001600_BO00;dTP0001500gBNP0=dTL0001500gBNP0=dTL0001400oBN00?dTH0001400oBN00?dTH0
001400oBN00?dTH0001400oBN00?dTH0001400oB>`02oc/03m960000A@0=dS/000Co003o>`0=dTL0
001500gB>`001?l00?lk00gBA`0004H02m800`1>000i0004o`00oc/000=>d]802M980000A`09dP80
00=>0000>0001?l00?lk0003CP3B00SBB@0004T01M850003H4h003P00_lj0003CV0000<01M9;0000
E@000f40001a0003H@0005@0001F0003CP0006l000=>0000E@0005L000=QCP00K0000diQ001G0000
F@000f1>001X0003CV0005T0001K0003H@0006D000=Q0000FP0005`000=>0000H`000dh0001K0000
G@000f5>001P0003CV4005d0001O0003H4h005`000=>H000G`00064000=QCP00F0000diQ001Q0000
H`000f1>001D0003CV0006<0001U0003HDiQ050000=>H@00I@0006P000=>H000BP000f1>H01X0000
JP000diQ00160003HDh006X0001/0003CV0001h01M8O0003H4h006`0001^0003CV5>01X02M8K0003
HDh006h0001a0004H4iPCQD02m8E0005CV1>H4h0L@0007D000=QCP004@0=dQ8000=>H@00M@0007L0
00EPCV1>H00=00gB3@001F1>H4iP07P0001l0005CV5>HDh01`0?dPP000AQCV5>O@00084000MPCV1>
H4iP00oB00QPCV1>H4iPCX40002800oBR@0008P03m:90000R00?dXT0002900gBRP0008T03M::0000
RP0;dX/0002;00WBS00008d01M:>0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.50002, -1.50002, 0.0104531, 
  0.0104531}},
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
.5 .165 .165 r
.5 Mabswid
.5 .16667 m
.16667 .5 L
s
.83333 .5 m
.5 .16667 L
s
.5 .83333 m
.83333 .5 L
s
.16667 .5 m
.5 .83333 L
s
1 0 0 r
.03 w
.16667 .5 Mdot
.0425 w
.5 .16667 Mdot
.055 w
.83333 .5 Mdot
.0675 w
.5 .83333 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .08333 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.91667 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .91667 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[26]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008L01?l30003o`3o00<0
0_n:0000R0000ol000040005o`000?l00P000ol000270000R@001?l00005o`050?l00?l0R@0008X0
00?o00000P001?l00003ohX000270004o`00o`P000?o0000RP0008P00_l:00?oR@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0008d01M:>0000R`02dP@S0m:<0000RP000m8S8`068`;BR`0008T000?B8b<0
22<2dXX000290003dR<S00PS0]::0000R0000m8S8`0:8`;BR@0008P000?B8b<02R<2dXT000200009
CV1>H4iPCV3B00`S0]802F1>H4iPCV1>H0200000N`001F5>HDiQ00P000?B8b<02R<2dPT000A>HDiQ
O00007H000E>H4iPCP0=00;B2R<3dPd000E>H4iPCP1g0000M0000diQ000B0003dR<S00PS0]8C0003
HDh007@0001`0004CV1>H1D000?Bdb<01b<00m;CdP0E0005H4iPCV00L00006d000=QCV406@0011kB
d]848`CB00<N000060000diQ001]0000J`000f1>000J0003d`0000WB0P000m<0000I0003CV0006/0
001Y0003HDh001/000<N00000`05dPD000<N00006P000diQ001Y0000I`000f1>000L0003d`0000l0
00?C00006`000diPCP1W0000I@000f5>000M00037P00014000<N00007@000f5>001T0000HP000diP
CP0O0003d`0001<000?C00007P000f1>001R0000H0000diQ000P00037P0001D000<N00007`000f5>
001P0000GP000diP000Q0003d`0001L000?C000080000f1>001N0000G@000f40000Q00037P0001T0
00<N00008@000f40001L0000G0000dh0000Q0003d`0001/000?C00008@000dh0001K0000FP000diQ
000R00037P0001d000<N00008@000f5>001J0000F0000diP000S0003d`0001l000?C00008P000f1>
001H0000E`000f40000S00037P00024000<N00008`000f40001F0000EP000dh0000S0003d`0002<0
00?C00008`000dh0001E0000E0000diQ000T00037P0002D000<N00008`000f5>001D0000D`000f00
000T0003d`0002L000?C000090000f00001B0000B@05dPD000=Q00008`000ah0000B00?o50000ah0
000T0004CP0000GBB`0004L02M800`1PCP0U0003d`0001@000?o000050000m<0000T0003H=;B00OB
B@0004H02m8V00037P0001<01?lF00037P0002<02m980000A@0=dR@000?C000050000ol0o`0H0003
d`0002403M970000A@0=dR<000<N00005@000ol0o`0I00037P0002003M970000A00?dR4000?C0000
5`02oaX000?C00007P0?dTH0001400oB80000ah0000e00037P0001d03m960000A00?dQl000?C0000
=`000m<0000L00oBAP0004@03m8N00037P0003T000<N00006`0?dTH0001400oB7@000m<0000k0003
d`0001X03m960000A@0=dQd000<N0000?@000ah0000J00gBA`0004D03M8L0003d`0003l000?C0000
6@0=dTL0001600_B70000ah0001100037P0001T02m980000A@000f00dP08dQ`000?C0000@`000m<0
000I00WB00<0CV00AP0004@000=>00000P05dQd000<N0000A@000ah0000J00GB1@000dh000130000
A0000dh0000S0003d`0004L000?C00008`000dh000130000@`000f40000S00037P0004T000<N0000
8`000f4000120000@P000dh0000S0003d`0004/000?C00008`000dh000110000@@000f40000S0003
7P0004d000<N00008`000f4000100000@@000f00000R0003d`0004l000?C00008P000f0000100000
@0000dh0000R00037P00054000<N00008P000dh0000o0000@0000dh0000G00?o1`000m<0001C0003
d`0000<00olK0003CP0003l0000o0003H@0001/000?o00000`000ah0001E00037P0000D000?o0000
6@000f40000n0000?P000dh0000L0003o`00008000?C0000E`000m<000040003o`0001X000=>0000
?@0003d000=Q00006P03o`@000<N0000F@0011h00002oah000=Q0000?00003d000=P00006P000ol0
00030003d`0005/000?C00000P000ol0000K0003H00003`0000l0003CP0001/01?l00`0N001N0004
7_oooal000=>0000>`0003`000=>00007`000m<0001O0003d`0001l000=>0000>`0003/000=Q0000
7`000ah0001Q00037P0001l000=Q0000>P0003/000=P00007P000m<0001S0003d`0001h000=P0000
>P0003X000=>00007P000ah0001U00037P0001h000=>0000>@0003X000=>00007@000m<0001W0003
d`0001d000=>0000>@0003T000=Q00007@000ah0001Y00037P0001d000=Q0000>00003T000=P0000
70000m<0001[0003d`0001`000=P0000>00003P000=>000070000ah0001]00037P0001/000=Q0000
>00003P000=>00006`000m<0001_0003d`0001/000=>0000=`0003P000=>00006P000ah0001a0003
7P0001X000=>0000=`0003L000=P00006P000m<0001c0003d`0001X000=P0000=P0003L000=Q0000
6@000ah0001e00037P0001T000=Q0000=P0003H000=>00006@000m<0001g0003d`0001T000=>0000
=@0003H000=>000060000ah0001i00037P0001P000=>0000=@0003D000=P000060000m<0001k0003
d`0001P000=P0000=00003D000=Q00005`000ah0001m00037P0001L000=Q0000=00003@000=>0000
5`000m<0001o0003d`0001L000=>0000<`0003@000=>00005P000ah0002100037P0001H000=>0000
<`0003@000=>00005@000m<000230003d`0001D000=>0000<`0003@000=>000050000ah000250003
7P0001@000=>0000<`0003@000=>00004`000m<000270003d`0001<000=>0000<`0003<000=Q0000
4`000ah0002900037P0001<000=Q0000<P0003<000=P00004P000m<0002;0003d`00018000=P0000
<P00038000=>00004P000ah0002=00037P00018000=>0000<@00038000=>00004@000m<0002?0003
d`00014000=>0000<@00038000=>000040000ah0002A00037P00010000=>0000<@00038000=>0000
3`000m<0002C0003d`0000l000=>0000<@00038000=>00003P000ah0002E00037P0000h000=>0000
<@00034000=P00003P000m<0002G0003d`0000h000=P0000<000034000=Q00003@000ah0002I0003
7P0000d000=Q0000<000034000=P000030000m<0002K0003d`0000`000=P0000<000034000=Q0000
2`000ah0002M00037P0000/000=Q0000<000030000=>00002`000m<0002O0003d`0000/000=>0000
;`00030000=>00002P000ah0002Q00037P0000X000=>0000;`00030000=>00002@000m<0002S0003
d`0000T000=>0000;`00030000=>000020000ah0002U00037P0000P000=>0000;`00030000=>0000
1`000m<0002W0003d`0000L000=>0000;`00030000=>00001P000ah0002Y00037P0000H000=>0000
;`00030000=>00001@000m<0002[0003d`0000D000=>0000;`00030000=>000010000ah0002]0003
7P0000@000=>0000;`0002d01M840003d`000:l000CC00001B<_0000:`09dP0301h00;8000<N8b<0
1b<]0000:P0:dP03d`000;802b</0000:@0:dP037];B0;803B<[0000:@05dP@S00CCd];B/P0=8b/0
000?00?o10000ol0o`0300;o2P05dPHS1=8?00;oS@04o`h03b<900?o10000ol0o`0300;o4P000100
00?o000010001Ol0003o008000?o00001`04dPPS0m8>0004o`00ohd000?o00003P0?8``000?o0000
0P001Ol0003o008000?o00003`00010000?o00000P05o`050?l00?l02@04dPPS0m8>0004o`00ohh0
00?o00003@0?8``000?o00001Ol01@3o003o0140000@0003o`0000@000Co00000ol:00CB22<3dPh0
0on@0003o`0000`03b<:00;o1@001?l00003oa80000@0003o`0000P000?o00002P04dPPS0m8>0003
o`0008d000Co003o3P0?8``000?o00001P000ol0000B00003`02o`/00ol:00CB1R<3dQ000on=00;o
400=8`X00ol:00?o4@0002T01M848`04dQkBd[803B<[0000:P0:dP03d`000;802b</0000:`09dP03
01h00;8000<N8b<01b<]0000;@05dP@000?C0000[`001=<000058bl0000`0003CP0000@000<N0000
[@000ah000040003CP0002l0000`0003CP0000D000?C0000Z`000m<000050003CP0002l0000`0003
CP0000H000<N0000Z@000ah000060003CP0002l0000`0003CP0000L000?C0000Y`000m<000070003
CP0002l0000`0003CP0000P000<N0000Y@000ah000080003CP0002l0000`0003CP0000T000?C0000
X`000m<000090003CP0002l0000`0003CP0000X000<N0000X@000ah0000:0003CP0002l0000`0003
CP0000/000?C0000W`000m<0000;0003CP0002l0000a0003H@0000/000<N0000W@000ah0000;0003
H@000300000a0003H00000`000?C0000V`000m<0000<0003H0000300000a0003H@0000d000<N0000
V@000ah0000=0003H@000300000a0003H00000h000?C0000U`000m<0000>0003H0000300000a0003
H@0000l000<N0000U@000ah0000?0003H@000300000b0003CP0000l000?C0000T`000m<0000?0003
CP000340000b0003CP00010000<N0000T@000ah0000@0003CP000340000b0003CP00014000?C0000
S`000m<0000A0003CP000340000b0003CP00018000<N0000S@000ah0000B0003CP000340000b0003
CP0001<000?C0000R`000m<0000C0003CP000340000c0003H@0001<000<N0000R@000ah0000C0003
H@000380000c0003H00001@000?C0000Q`000m<0000D0003H0000380000d0003CP0001@000<N0000
Q@000ah0000D0003CP0003<0000d0003CP0001D000?C0000P`000m<0000E0003CP0003<0000d0003
CP0001H000<N0000P@000ah0000F0003CP0003<0000d0003CP0001L000?C0000O`000m<0000G0003
CP0003<0000e0003H@0001L000<N0000O@000ah0000G0003H@0003@0000e0003H00001P000?C0000
N`000m<0000H0003H00003@0000e0003H@0001T000<N0000N@000ah0000I0003H@0003@0000f0003
CP0001T000?C0000M`000m<0000I0003CP0003D0000f0003CP0001X000<N0000M@000ah0000J0003
CP0003D0000g0003H00001X000?C0000L`000m<0000J0003H00003H0000g0003H@0001/000<N0000
L@000ah0000K0003H@0003H0000h0003CP0001/000?C0000K`000m<0000K0003CP0003L0000h0003
CP0001`000<N0000K@000ah0000L0003CP0003L0000i0003H00001`000?C0000J`000m<0000L0003
H00003P0000i0003H@0001d000<N0000J@000ah0000M0003H@0003P0000j0003CP0001d000?C0000
I`000m<0000N0003H00003P0000j0003CP0001h000<N0000I@000ah0000N0003CP0003T0000j0003
CP0001l000?C0000H`000m<0000O0003CP0003T0000k0003H@0001l000<N0000H@000ah0000O0003
H@0003X0000k0003H000020000?C0000G`000m<0000P0003H00003X0000l0003CP00020000<N0000
G@000ah0000P0003CP0003/0000l0003CP0001`000?o00000P000m<0001K0003d`3o00;o7`000dh0
000k0000?@000f40000K0003o`0000<000<N0000F@001Ah0003o01l000=Q0000?00003h000=>0000
6`000ol000030003d`0005L000?C00000P000ol0000L0003CP0003d0000o0003H@0001X000?o0000
10000ah0001E00037P0000<000?o00006`000f40000n0000?`000f00000K0003o`0000@000?C0000
D`000m<000040003o`0001/000=P0000?P00040000=>00005`04o`L000<N0000D@000ah0000400;o
70000dh0000o0000@0000dh0000S0003d`0004l000?C00008`000dh0000o0000@@000f40000S0003
7P0004d000<N00008`000f4000100000@P000dh0000S0003d`0004/000?C00008`000dh000110000
@`000f40000S00037P0004T000<N00008`000f4000120000@`000f00000T0003d`0004L000?C0000
90000f0000120000A0000diQ000T00037P0004D000<N00008`000f5>00140000AP000dh00005dQh0
00?C0000@`000m<0000K00GB0`000dh000150000AP000dkBdP07dQd000<N0000@@000ah0000J00WB
00<0CP00AP0004H02m8M0003d`0003l000?C00006P0;dTP0001500gB7@000ah0000m00037P0001X0
3M970000A@0=dQh000?C0000>`000m<0000K00gBA`0004@03m8N00037P0003T000<N00006`0?dTH0
001400oB7`000m<0000g0003d`0001`03m960000A00?dR0000<N0000=@000ah0000M00oBAP0004@0
3m8Q0003d`0003<000?C00007P0?dTH0001400oB8P000ah0000F00;o6@000ah0000O00oBAP0004D0
3M8T0003d`0001@000Co003o5`000m<0000Q00gBA`0004D03M8U00037P0001<000Co003o5P000ah0
000R00gBA`0004H02m800`1>000T0003d`00018000Co003o5@000m<0000S0003C];B00WBB00004L0
2M820003CP0002@000<N00004@001?l00?lD00037P0002@000=>0=802=990000B@05dPD000=PCP00
90000m<0000A00;o50000m<0000S0003CV0000<01M9;0000E@000f40000S00037P0002D000<N0000
8`000f40001D0000EP000dh0000S0003d`0002<000?C00008`000dh0001E0000E`000f5>000S0003
7P00024000<N00008P000diQ001G0000F@000f1>000R0003d`0001l000?C00008@000diP001I0000
F`000f40000Q00037P0001d000<N00008@000f40001J0000G0000dh0000Q0003d`0001/000?C0000
8@000dh0001K0000G@000f5>000Q00037P0001T000<N000080000diQ001M0000G`000f1>000P0003
d`0001L000?C00007`000diP001O0000H@000f5>000O00037P0001D000<N00007P000diQ001Q0000
H`000f1>000N0003d`0001<000?C00007@000diP001S0000I@000f5>H@0M00037P00014000<N0000
70000diQ001U0000J0000diP000K0003d`0000<01b<50003d`0001X000=PCV00J00006X000=>H@00
6P000ah0000;8`8000<N00006@000f5>001Z0000K0000diP000I0003db<S00/S00?C000060000f1>
001/0000KP000diQCP0G00lS60000f5>001^0000L@00161>H4hB014S4P001DiPCV1>0740001e0003
HDh000l04B<@0003CV4007D0001g0005H4iPCV002P0C8`X000EPCV1>H01h0000O0001DiQCV5>00D0
4b<60004HDiQCWd000210005H4iPCV004b<01V1>H4iPCX40002601<SQ`0008H04b>70000QP0C8hL0
002601<SQ`0008L04B>80000Q`0A8hP0002800lSR@0008T03B>:0000RP0;8h/0002<00LSS@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0008P00ol30003o`3o00<00_n:0000R@000ol000030005o`000?l00P000ol000270000
Q`04o`801Ol01@3o003o08T000270003o`3o00D000Co00000on:0000Q`000ol0o`090003o`0008X0
002800;o2P03ohT0003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.50002, -1.50002, 0.0104531, 
  0.0104531}},
  CellTags->"Subgroups"]
}, Open  ]]
}, Open  ]],

Cell["Here is an alternate approach to creating an animation.", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupGenerated[Z[8], \ 6, \ Mode\  \[Rule] \ Visual, \ 
      Output\  \[Rule] \ GraphicsArray]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"Subgroups"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0238095 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0238095 0.477324 0.477324 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
.5 .165 .165 r
.5 Mabswid
.5 .16667 m
.16667 .5 L
s
.83333 .5 m
.5 .16667 L
s
1 0 0 r
.03 w
.16667 .5 Mdot
.0425 w
.5 .16667 Mdot
.055 w
.83333 .5 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .08333 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.91667 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0238095 0.97619 0.477324 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
.5 .165 .165 r
.5 Mabswid
.5 .16667 m
.16667 .5 L
s
.83333 .5 m
.5 .16667 L
s
.5 .83333 m
.83333 .5 L
s
.16667 .5 m
.5 .83333 L
s
1 0 0 r
.03 w
.16667 .5 Mdot
.0425 w
.5 .16667 Mdot
.055 w
.83333 .5 Mdot
.0675 w
.5 .83333 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .08333 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.91667 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .91667 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.522676 0.477324 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
1 0 0 r
.03 w
.16667 .5 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.522676 0.97619 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.06667 .06667 m
.06667 .93333 L
.93333 .93333 L
.93333 .06667 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.5 .83333 Mdot
.7357 .7357 Mdot
.83333 .5 Mdot
.7357 .2643 Mdot
.5 .16667 Mdot
.2643 .2643 Mdot
.16667 .5 Mdot
.2643 .7357 Mdot
0 g
[(0)] .5 .75 0 0 Mshowa
[(1)] .67678 .67678 0 0 Mshowa
[(2)] .75 .5 0 0 Mshowa
[(3)] .67678 .32322 0 0 Mshowa
[(4)] .5 .25 0 0 Mshowa
[(5)] .32322 .32322 0 0 Mshowa
[(6)] .25 .5 0 0 Mshowa
[(7)] .32322 .67678 0 0 Mshowa
.5 .165 .165 r
.5 Mabswid
.5 .16667 m
.16667 .5 L
s
1 0 0 r
.03 w
.16667 .5 Mdot
.0425 w
.5 .16667 Mdot
0 g
gsave
.08333 .5 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.5 .08333 -90 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
87.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
99.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0003l01?l30003o`3o00<00_n100Co0`000ol0o`0300;o@P00040000?o000010001Ol0
003o008000?o0000O`000ol000040005o`000?l00P000ol0000o0000@@001?l00005o`050?l00?l0
PP001?l00005o`050?l00?l0@@00048000?o00000P001?l00003oh@000?o00000P001?l00003od80
000o0004o`00o`P000?o0000P@001?l00?l80003o`000480001000;o2P03oh400_l:00?o@@000?l0
8@000?l08@000?l08@000?l08@0004H00m:=00?BA`0004D000GB8b<SdP2;00<S0]960000A0000m8S
8`038`03dP0008L01B<2dTD000110004H4iPdPDS00GBH4iPCP210004CV1>H0DS0]800f1>H0120000
?@00165>HDh30003dR<S00<S00?B00000P00165>HDii0004CV5>H@@01B<2dP<000A>HDiQ?P0003T0
00APCV1>20001T0S8b?Bd`P000APCV1>L@0014iPCV080006db<S8m90200014iPCV0j0000=`000f5>
000:0003E03B00;B0P000ah000090003HDh006`000=>H@002P000ah00003dP0305@000X000=>H@00
=`0003D000=PCP002`000d0000060003d`0000X000=PCP00J0000diP000;0003d`0000H000=00000
2P000diP000e0000<`000f5>000<0003E00000P000<N00002`000f5>001T0003CV4000`000<N0000
20000e@0000;0003CV4003<0000a0003H4h000d000=000002P000m<0000<0003H4h0060000=>H000
3@000m<0000:0003@00000`000=>H000<@0002l000=QCP003P000e@0000<00037P0000d000=QCP00
G0000diQ000>00037P0000`000=D00003@000diQ000_0000;P000dh0000>0003@00000h000?C0000
3P000f00001I0003H00000h000?C00003P000d00000>0003CP0002d0000]0003H@0000h000=D0000
1@03o`P000<N00003@000f40001I0003H@0000d000<N00001P03o`L000=D00003P000f40000/0000
:003dP0304h000l000=000001`000ol000080003d`0000d000=>H0000m9?00?B00<0H4h03`000m<0
00080003o`0000L000=000003P000dh0dP02dRT0000W00GB40000e@0000600Co2P000ah0000>00GB
C@05dQ0000<N00001`04o`T000=D00003P05dRP0000V00OB3P000d0000070003o`3o00`000?C0000
3007dT/01m8>0003d`0000P000?o0?l02`000d00000<00OB9`0002H01m8=0003E00000P000?o0?l0
3@000ah0000;00OBB`07dPd000<N00002@000ol0o`0<0003E00000/01m8W00009P07dP`000=00000
2P02o`h000?C00002P07dT/01m8<0003d`0000/00_l=0003@00000X01m8W00009`05dP`000=D0000
70000ah0000:00GBC@05dP`000<N000070000e@0000:00GB:00002H000=>0=800]8<0003@00001h0
00?C00002P03dP03060004X000=P0=800]8<0003d`0001h000=000002P03dP0304h002H0000U0003
H@0000h000=D000080000ah0000>0003CP0004L000=>00003P000ah0000P0003E00000h000=Q0000
900002D000=P00001P03o`@000=000008P000m<0o`02o`/000=>0000A`000dh0000700?o0`000m<0
000R0003@00000?o2P000f00000T000090000dh0000:0004o`00E2H000DN0000o`0;0003H@0004D0
00=Q00002`000ol07P0V0003E000008000?o000020000dh0000S00008`000f00000;0003o`1002P0
00CC003o2`000f0000150003H00000/000?od`009`001D00003o00/000=P00008P00028000=>0000
2@03o`0305@002T000<No`0030000dh000130003CP0000T00ol00ah0000X0003E?oo00d000=>0000
8@00028000=>00002@001?l0040/0003dol000/000=>0000@P000f00000:0003o`3C02`000=00?l0
30000dh0000Q00008@000f40000:00;o00=Do`00:@03o`037P0000/000=Q0000@0000dh0000;0004
oakoobX00_l00e@0000<0003H@000200000Q0003H00000/000=00000;P000m<0000:0003H0000400
00=>00002`000m<0000^0003@00000/000=P00008000020000=>00002`000e@0000`00037P0000X0
00=>0000?P000f40000;00037P00030000=D00002`000dh0000O000080000dh0000:0003@0000380
00?C00002@000dh0000n0003H00000X000?C0000<P000d00000:0003CP0001l0000O0003H@0000X0
00=D0000=0000ah000090003H@0003d000=Q00002@000ah0000d0003E00000X000=Q00007P0001l0
00=P00002@000d00000f0003d`0000P000=P0000?@000f0000080003d`0003H000=000002@000f00
000N00007`000f4000080003E00003P000<N000020000dh0000k0003CP0000P000<N0000>0000e@0
00080003H@0001h0000O0003H00000L000=00000>P000m<000070003CP0003/000=>00001`000m<0
000j0003@00000L000=P00007P0001h000=>00001`000e@0000l00037P0000L000=Q0000>@000f40
000700037P0003`000=D00001`000dh0000M00007P000dh000060003@00003h000?C00001P000f00
000i0003H00000H000?C0000?P000d0000060003CP0001d0000M0003H@0000H000=D0000@0000ah0
00050003H@0003T000=Q00001@000ah000100003E00000H000=Q0000700001d000=P00001@000d00
00120003d`0000@000=P0000>@000f0000040003d`00048000=000001@000f00000L00007@000f40
00040003E00004@000<N000010000dh0000g0003CP0000@000<N0000A0000e@000040003H@0001`0
000M0003H00000<000=00000AP000m<000030003CP0003L000=>00000`000m<000160003@00000<0
00=P0000700001`000=>00000`000e@0001800037P00008000=>0000=`000dh0000200037P0004P0
00=D00000P000f40000L000070000dh000020003@00004X000GC0000CP0i0005CP000=<0C0001D00
001P01h0000L0005CP0005@0CP001Ah0001Q03L000EQ00007P1>0005E00004h07@0001/00m800`10
001?0003d`0S008S=@03dP030=<004l000=002<00R<L00002@03o`@000?o0?l00`02o`801=800e@0
000500;o?P04o`L01B<3o`@000?o0?l00`02oa<00ol40003o`3o00<00_l200CB00<N00001@02och0
1?l700DS0ol40003o`3o00<00_l<00002P000ol000040005o`000?l00P000ooBdP02dP03@=;B00D0
00Co003o?P000ol0000600LS0P000ol000020005o`000?l00P000ol0000A0003o`0000@000Go0000
o`020003om;B00;B00?Cd]801@001?l00?ln0003o`0000H01b<20003o`00008000Go0000o`020003
o`0000T0000:0003o`0000801Ol01@3o003o00;B0b<2dPD000Co003o?`000ol0000500LS0P000ol0
0005o`050?l00?l04`000ol0000200Go00D0o`00o`02dP<S0]850004o`00ocl000?o00001@078`80
00?o00001Ol01@3o003o00/0000:0003o`0000@000Co00000ol00`3BdP038`;B1@03od4000?o0000
10078`;o1@001?l00003oa@000?o000010001?l00003o`030=;B00<S0]8500?o@@000ol0000400LS
0_l50004o`0000?o300000X000?o000020000ol000020005dR<S8m801P000ol0000n0004o`00o`L0
1B<30003o`0000H000?o000050000ol000080003o`00008000GB8b<S7P060003o`0003h000Co003o
1`058`<000?o00001P000ol0000<00002@02o`/00ol200?B2003och00_l900<S00@0oooo2P03oa80
0_l;00?o0P03dP030=<000D00oln00;o20001M<S8b<000?o2P03o`/0000L0003CP0005@000=Q0000
=@001F40000N04l000@N001>7@0001`000=>0000E0000f00000e0003H000008000?C0000B`001M<0
001>01d0000L0003CP0005@000=Q0000=@000f40000300037P0004T000<N00000P000dh0000K0000
70000dh0001C0003CP0003L000=>00000`000m<000170003d`00008000=P0000700001`000=>0000
D`000dh0000g0003CP0000@000<N0000A@000ah000030003H@0001`0000M0003H000058000=>0000
=`000dh000050003d`0004<000?C000010000f00000L00007@000f40001B0003CP0003L000=>0000
1P000ah0001100037P0000D000=Q0000700001d000=P0000D@000f00000i0003H00000H000?C0000
?`000m<000060003H00001`0000M0003H@00054000=Q0000>@000f40000700037P0003d000<N0000
1`000f40000L00007P000dh0001@0003H00003T000=P000020000m<0000k0003d`0000L000=>0000
7@0001h000=>0000D0000f40000i0003H@0000T000<N0000>@000ah000080003CP0001d0000O0003
H00004h000=>0000>`000dh000090003d`0003L000?C000020000f00000N00007`000f40001>0003
CP0003/000=>00002P000ah0000e00037P0000T000=Q00007P0001l000=P0000C@000f00000m0003
H00000X000?C0000<`000m<0000:0003H00001h0000O0003H@0004d000=Q0000?@000f40000;0003
7P00034000<N00002`000f40000N000080000dh0001;0003CP0003h000=P000030000m<0000_0003
d`0000/000=>00007`00020000=>0000B`000dh0000n0003H@0000d000<N0000;@000ah0000<0003
CP0001l0000Q0003H00000/000?o0000:P03o`h000=P0000@0000dh0000<0003om<002X00_l00m<0
000<0003H0000200000Q0003H@0000/000?o0000:`000ol0000=0003H@00044000=Q00002`000ol0
7P0[00037P0000d000=Q00008000028000=>00002`000ol0000Z0003o`0000`000=>0000@`000dh0
000;0003o`3C02T000?Co`003@000dh0000Q00008`000f40000:0003o`0002X000?o000030000dh0
00130003CP0000/000Co000N9`000ah0o`0=0003H@000280000T0003CP0000X000?o0000:@000ol0
000;0003H00004D000=P00002`001?l00=<U0004d`00o``000=>00008`0002@000=>00001`04obX0
0_l=0003H@0004D000=Q00002004o`<000<N00008@000ah00002o``000=>00008`0002D000=P0000
@P000dh000170003CP0000l000?C00007`000m<0000>0003H00002@0000V0003CP3B00;B>P03dP03
064004X000=Q0=800]8=00037P0001d000<N00002P03dP0304h002H0000W00GB>005dTd01M8=0003
d`0001/000?C00002P05dRP0000V00OB=P07dT/01m8=00037P0001T000<N00002P07dRL0000V00OB
6@02oa/01m9;00OB3P000m<0000900;o30000m<0000;00OB9`0002H01m8H0004o`00oaX01m9;00OB
3`000ah000070004o`00o`X000<N00003007dRL0000W00GB6@001?l00?lJ0003H=;B00?BC@05dP03
H00000h000?C00001P001?l00?l90003d`0000h01M8X0000:003dP0304h001L000Co003o6@000dh0
0003dTl00m820003CP0000h000<N00001@001?l00?l800037P0000h000=>0=800]8Y0000;@000f00
000E0004o`00oaT000=>0000E`000dh0000?0003d`0000@000Co003o1`000m<0000>0003H00002`0
000^0003CV4001D00_lH0003CV4005X000=QCP003`000ah0000400;o1`000ah0000=0003HDh002h0
000`0003CV0002/000=>H000GP000f1>000>0003d`0000/000?C000030000f1>000`0000<P000diQ
000W0003CV40068000=QCP003@000ah0000900037P0000/000=QCP00<P0003@000=>H0008`000diP
001V0003H4h000`000?C00001`000m<0000:0003H4h003@0000f0003CV4001l000=>H@00JP000f5>
000;00037P0000D000<N00002@000f5>000f0000>0000diP000;00?B3@000diP001^0003H4h000X0
00?C8b<00R<00`3C00090003H4h003P0000j0004CV5>H@L01M880004CV5>HG<000AQCV5>1`068`L0
00AQCV5>>`0003h000I>H4iPCV07dP0704iPCV1>H01k0006H4iPCV1>22<01V1>H4iPCSl0001400OB
00=Q0000Q@088dD0001400OBR0088dD0001500GBR@088dD0001600?BR`068dH0003E00@SA`000?l0
8@000?l08@000?l08@000?l08@000=000ol30003o`3o00<00_m20000d@000ol000030005o`000?l0
0P000ol0000o0000c`04o`801Ol01@3o003o0440003?0003o`3o00D000Co00000om20000c`000ol0
o`090003o`000480003@00;o2P03od40003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003?00Co0`000ol0o`0300;o@P000=0000?o000010001Ol0003o008000?o0000
?`000=4000Co00001Ol01@3o003o0440003B0003o`00008000Co00000om20000c`001?l00?l80003
o`000480003@00;o2P03od40003o0240003o0240003o0240003o0240001600?BS@03dTL0001500GB
R`038`;BAP0004@01m:900DS0]950000@`000f7BdP05dP03HDh008@000=>HB<012<2dP03H@000480
000m0007H4iPCV1>0007dP8000IPCV1>H4ii0006CV1>H4iP0P058`;B00L0CV1>H4iP03h0000k0003
HDh000L01M890003HDh007@000=>H@0020038`;B20000diQ000k0000=`00161>H4h;00?B3000161>
H4i]0004CV1>H0X000?C0=800]8;0004CV1>H3P0000e0003HDh0024000=QCP00J0000diQ000<0003
7P00018000=>H@00=@0003<000=PCP009@000f1>001T0003CV0000d000?C00005@000diP000c0000
<@000f5>000Y0003HDh0060000=>H@003P000ah0000H0003CV400340000_0003H4h002d000=PCP00
G0000diP000?0003d`0001/000=>H000;`0002h000=>0000<0000f40001I0003H@0000l000<N0000
7P000dh0000]0000;@000f00000F00?o60000f00001I0003H00000h000?C00001@03oaP000=P0000
;00002P00m800`1>000I0003o`0001P000=>H@000m9?00?B00<0HDh040000ah000070003o`0001P0
00=>0=800]8Y00009`05dQT01?lK00GBC@05dQ4000?C00001P04oaX01M8X00009P07dQP000?o0?l0
6`07dT/01m8?00037P0000L000?o0?l06P07dRL0000V00OB60000ol0o`0K00OBB`07dPh000?C0000
20000ol0o`0J00OB9`0002H01m8I00;o6`07dT/01m8=00037P0000X00_lJ00OB9`0002L01M8h00GB
C@05dPd000?C0000:005dRP0000V0003CP3B00;B>P03dP03064004X000=Q0=800]8=00037P0002X0
0m800`1>000V00009@000f0000120003CP0004L000=>00003`000m<0000`0003H00002@0000U0003
H@00048000=>0000A`000dh0000>00037P00034000=Q0000900002@000=>00001`03ob/00ol<0003
H00004D000=P00002003o`<000?C00009@03o`/000=>00008`0002<000=Q00002`000ol0000[0003
o`0000T000=Q0000A@000f40000;0003o`0N02/000?o00002@000f40000R00008P000dh0000<0003
o`0002/000?o00002P000dh000130003CP0000`000?od`00:`000ol0000:0003CP000240000R0003
CP0000T00ol/00;o3@000dh000120003H@0000X00ol00ah0000Y00;o3@000dh0000Q00008@000f00
000:0003o`0002h000?o00002`000f0000100003CP0000/000?o0=<0;P000ol0000;0003H0000200
000Q0003H@0000X01?lZ00?o3P000f4000100003CP0000/000Co7_oo:P03o`h000=Q000080000200
00=>0000B`000dh0000n0003H00000`000?C0000?@000dh0000O000080000dh0001;0003CP0003h0
00=Q00002`000ah0000n0003CP0001l0000O0003H00004d000=P0000?@000f00000:0003d`000400
00=P00007P0001l000=Q0000C@000f40000m0003H@0000T000<N0000@@000f40000N00007`000f00
001>0003CP0003/000=>00002@000m<000120003H00001h0000O0003H@0004h000=>0000>`000dh0
000800037P0004<000=Q00007P0001h000=>0000D0000f00000i0003H00000P000?C0000A@000dh0
000M00007P000dh0001@0003H@0003T000=Q00001`000ah000160003CP0001d0000M0003H0000540
00=P0000>@000f0000060003d`0004P000=P0000700001d000=Q0000D@000f40000i0003H@0000D0
00<N0000B@000f40000L00007@000f00001B0003CP0003L000=>00001@000m<0001:0003H00001`0
000M0003H@00058000=>0000=`000dh0000400037P0004/000=Q0000700001`000=>0000D`000dh0
000g0003CP0000<000?C0000C0000f00000L000070000dh0001C0003CP0003L000=>00000P000ah0
001=0003H@0001`0000L0003CP0005@000=P0000=@000f0000020003d`0004l000=>00006`0001`0
00=>0000E0000f40000e0005H@0001h0DP000dh0000K00006`03dU@00m8e00?B00<0d`00D@03dQ`0
000900?o10000ol0o`0300;o0P05dPL00_ln00Co1`05dR800ol40003o`3o00<00_l200CB00<N0000
1@02och01?l700GB6`0000X000?o000010001Ol0003o008000?od]800b<2dPD000Co003o?P000ol0
000600OB8P000ol000040005o`000?l00P000ooBdP038`;B1@001?l00?ln0003o`0000H01m8J0000
2P000ol0000200Go00D0o`00o`02dP<S0]850004o`00ocl000?o00001@07dR8000?o00000P05o`05
0?l00?l00]838`;B1@001?l00?lo0003o`0000D01m8J00002P000ol000040004o`0000?o00<0d]80
0b<2dPD00om10003o`0000@01m8R0003o`0000@000Co00000ol00`3BdP038`;B1@03od4000?o0000
1007dQX0000:0003o`0000P000?o00000P05dPH000?o0000?P001?l00?l700GB8`000ol000080003
o`0000801M860003o`0003h000Co003o1`05dQ/0000900;o2`03o`800m8800?o?P02o`T00m8S00;o
2`03o`800m8800?o?P02o`T00m8L000070000dh0001D0003H@0003D000=Q0000E0000dh0000K0000
70000dh0001D0003H00003D000=P0000E0000dh0000K000070000dh0001C0003CP0003L000=>0000
DP000f40000L000070000dh0001C0003CP0003L000=>0000DP000f00000L00007@000f40001B0003
CP0003L000=>0000DP000f40000L00007@000f00001B0003CP0003L000=>0000DP000f00000L0000
7@000f40001A0003H@0003T000=Q0000D@000f40000L00007@000f00001A0003H00003T000=P0000
D@000f00000L00007P000dh0001@0003H@0003T000=Q0000D0000dh0000M00007P000dh0001@0003
H00003T000=P0000D0000dh0000M00007`000f40001>0003CP0003/000=>0000CP000f40000N0000
7`000f00001>0003CP0003/000=>0000CP000f00000N00007`000f40001=0003H@0003d000=Q0000
C@000f40000N00007`000f00001=0003H00003d000=P0000C@000f00000N000080000dh0001;0003
CP0003h000=Q0000C0000dh0000O000080000dh0001;0003CP0003h000=P0000C0000dh0000O0000
8@000f4000190003H@00040000=>0000BP000f40000P00008@000f00000;0003o`0002X00ol>0003
H000044000=P00002`000ol0000Z00?o3P000f00000P00008P000dh0000:0003o`0002/000?o0000
30000dh000130003CP0000X000?o0000:`000ol0000<0003CP000240000S0003H00000X000?o0000
:P000ol0000<0003CP0004<000=>00002`000ol0000Z0003o`0000/000=P00008P0002@000=>0000
2@000ol0000Z0003o`0000/000=Q0000A@000f40000:0003o`0002X000?o00002P000dh0000S0000
90000dh0000:0003o`0002T000?o00002`000f0000150003H00000/000?o0000:@000ol0000:0003
CP0002<0000U0003H@0000H01?lZ00;o30000dh000170003CP0000L01?lZ00;o2`000f40000T0000
9P000dh0dP02dSX00m820003CP0004P000=P0=800]8j00?B0P000f00000T00009`05dSP01M800f40
001:00GB>005dP03CP0002D0000V00OB=P07dT/01m8f00OB9`0002H01m8I00;o6`07dT/01m8J00;o
6P07dRL0000V00OB60001?l00?lJ00OBB`07dQT000Co003o6@07dRL0000W00GB6@001?l00?lK00GB
C@05dQX000Co003o6P05dRP0000X00?B00=P00005`001?l00?lJ0003H03B00;BC`03dP03060001P0
00Co003o6P00163Bd]8Y0000;0000diQ000F0004o`00oaT000=>0000E`000dh0000F0004o`00oaP0
00=QCP00;00002h000=>H0005@02oaP000=>H000FP000f1>000F00;o5`000f1>000^0000<0000diQ
000[0003CV4005h000=QCP00:`000f5>000`0000<P000diP000W0003CV00068000=PCP009`000f1>
000b0000=0000diQ000S0003CV4006H000=QCP008`000f5>000d0000=P000diP000O0003CV0006X0
00=PCP007`000f1>000f0000>0000diQ000;00?B3@000diQ001^0003HDh000`00m8<0003HDh003P0
000j0004CV1>H0L01M880004CV1>H7<000APCV1>2005dPL000APCV1>>`0003h000A>HDiQ0P07dP<0
00A>HDiQN`00165>HDh300OB0P00165>HDho0000@P000diPdP06dP03H4iP08<000=PCV001m800f1>
00120000A007dXT01m950000A@05dX/01M960000AP03dXd00m970000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.0500105, -0.0500105, 
  0.00731715, 0.00731715}, {{6.8125, 136.938}, {280.125, 
  150}} -> {-1.65708, -1.65852, 0.023055, 0.023055}, {{150, 280.125}, {
  280.125, 150}} -> {-4.95827, -1.65852, 0.023055, 0.023055}, {{6.8125, 
  136.938}, {136.938, 6.8125}} -> {-1.65708, -4.95971, 0.023055, 0.023055}, {{
  150, 280.125}, {136.938, 6.8125}} -> {-4.95827, -4.95971, 0.023055, 
  0.023055}},
  CellTags->"Subgroups"]
}, Open  ]],

Cell["\<\
This second visual mode uses the context of the Cayley table to \
illustrate the subgroup that is generated.\
\>", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupGenerated[U[11], \ 4, \ Mode\  \[Rule] \ Visual2]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"Subgroups", "i:14"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.22727 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.11039 0.0865801 0.202381 0.0865801 [
[ 0 0 0 0 ]
[ 1 1.22727 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.22727 L
0 1.22727 L
closepath
clip
newpath
.8 g
.02381 .72186 m
.02381 .80844 L
.11039 .80844 L
.11039 .72186 L
F
1 0 0 r
.11039 .72186 m
.11039 .80844 L
.19697 .80844 L
.19697 .72186 L
F
.8 1 0 r
.37013 .72186 m
.37013 .80844 L
.45671 .80844 L
.45671 .72186 L
F
0 1 .4 r
.45671 .72186 m
.45671 .80844 L
.54329 .80844 L
.54329 .72186 L
F
0 .4 1 r
.80303 .72186 m
.80303 .80844 L
.88961 .80844 L
.88961 .72186 L
F
.8 0 1 r
.28355 .72186 m
.28355 .80844 L
.37013 .80844 L
.37013 .72186 L
F
1 0 0 r
.11039 .02922 m
.11039 .1158 L
.19697 .1158 L
.19697 .02922 L
F
.8 1 0 r
.19697 .02922 m
.19697 .1158 L
.28355 .1158 L
.28355 .02922 L
F
0 1 .4 r
.28355 .02922 m
.28355 .1158 L
.37013 .1158 L
.37013 .02922 L
F
0 .4 1 r
.37013 .02922 m
.37013 .1158 L
.45671 .1158 L
.45671 .02922 L
F
.8 0 1 r
.45671 .02922 m
.45671 .1158 L
.54329 .1158 L
.54329 .02922 L
F
0 g
[(1)] .15368 .15043 0 0 Mshowa
[(2)] .24026 .15043 0 0 Mshowa
[(3)] .32684 .15043 0 0 Mshowa
[(4)] .41342 .15043 0 0 Mshowa
[(5)] .5 .15043 0 0 Mshowa
[(4)] .15368 .07251 0 0 Mshowa
[(5)] .24026 .07251 0 0 Mshowa
[(9)] .32684 .07251 0 0 Mshowa
[(3)] .41342 .07251 0 0 Mshowa
[(1)] .5 .07251 0 0 Mshowa
[(n)] .0671 .15043 0 0 Mshowa
[(g^n)] .0671 .07251 0 0 Mshowa
[(1)] .15368 1.02489 0 0 Mshowa
[(2)] .24026 1.02489 0 0 Mshowa
[(3)] .32684 1.02489 0 0 Mshowa
[(4)] .41342 1.02489 0 0 Mshowa
[(5)] .5 1.02489 0 0 Mshowa
[(6)] .58658 1.02489 0 0 Mshowa
[(7)] .67316 1.02489 0 0 Mshowa
[(8)] .75974 1.02489 0 0 Mshowa
[(9)] .84632 1.02489 0 0 Mshowa
[(10)] .9329 1.02489 0 0 Mshowa
[(2)] .15368 .93831 0 0 Mshowa
[(4)] .24026 .93831 0 0 Mshowa
[(6)] .32684 .93831 0 0 Mshowa
[(8)] .41342 .93831 0 0 Mshowa
[(10)] .5 .93831 0 0 Mshowa
[(1)] .58658 .93831 0 0 Mshowa
[(3)] .67316 .93831 0 0 Mshowa
[(5)] .75974 .93831 0 0 Mshowa
[(7)] .84632 .93831 0 0 Mshowa
[(9)] .9329 .93831 0 0 Mshowa
[(3)] .15368 .85173 0 0 Mshowa
[(6)] .24026 .85173 0 0 Mshowa
[(9)] .32684 .85173 0 0 Mshowa
[(1)] .41342 .85173 0 0 Mshowa
[(4)] .5 .85173 0 0 Mshowa
[(7)] .58658 .85173 0 0 Mshowa
[(10)] .67316 .85173 0 0 Mshowa
[(2)] .75974 .85173 0 0 Mshowa
[(5)] .84632 .85173 0 0 Mshowa
[(8)] .9329 .85173 0 0 Mshowa
[(4)] .15368 .76515 0 0 Mshowa
[(8)] .24026 .76515 0 0 Mshowa
[(1)] .32684 .76515 0 0 Mshowa
[(5)] .41342 .76515 0 0 Mshowa
[(9)] .5 .76515 0 0 Mshowa
[(2)] .58658 .76515 0 0 Mshowa
[(6)] .67316 .76515 0 0 Mshowa
[(10)] .75974 .76515 0 0 Mshowa
[(3)] .84632 .76515 0 0 Mshowa
[(7)] .9329 .76515 0 0 Mshowa
[(5)] .15368 .67857 0 0 Mshowa
[(10)] .24026 .67857 0 0 Mshowa
[(4)] .32684 .67857 0 0 Mshowa
[(9)] .41342 .67857 0 0 Mshowa
[(3)] .5 .67857 0 0 Mshowa
[(8)] .58658 .67857 0 0 Mshowa
[(2)] .67316 .67857 0 0 Mshowa
[(7)] .75974 .67857 0 0 Mshowa
[(1)] .84632 .67857 0 0 Mshowa
[(6)] .9329 .67857 0 0 Mshowa
[(6)] .15368 .59199 0 0 Mshowa
[(1)] .24026 .59199 0 0 Mshowa
[(7)] .32684 .59199 0 0 Mshowa
[(2)] .41342 .59199 0 0 Mshowa
[(8)] .5 .59199 0 0 Mshowa
[(3)] .58658 .59199 0 0 Mshowa
[(9)] .67316 .59199 0 0 Mshowa
[(4)] .75974 .59199 0 0 Mshowa
[(10)] .84632 .59199 0 0 Mshowa
[(5)] .9329 .59199 0 0 Mshowa
[(7)] .15368 .50541 0 0 Mshowa
[(3)] .24026 .50541 0 0 Mshowa
[(10)] .32684 .50541 0 0 Mshowa
[(6)] .41342 .50541 0 0 Mshowa
[(2)] .5 .50541 0 0 Mshowa
[(9)] .58658 .50541 0 0 Mshowa
[(5)] .67316 .50541 0 0 Mshowa
[(1)] .75974 .50541 0 0 Mshowa
[(8)] .84632 .50541 0 0 Mshowa
[(4)] .9329 .50541 0 0 Mshowa
[(8)] .15368 .41883 0 0 Mshowa
[(5)] .24026 .41883 0 0 Mshowa
[(2)] .32684 .41883 0 0 Mshowa
[(10)] .41342 .41883 0 0 Mshowa
[(7)] .5 .41883 0 0 Mshowa
[(4)] .58658 .41883 0 0 Mshowa
[(1)] .67316 .41883 0 0 Mshowa
[(9)] .75974 .41883 0 0 Mshowa
[(6)] .84632 .41883 0 0 Mshowa
[(3)] .9329 .41883 0 0 Mshowa
[(9)] .15368 .33225 0 0 Mshowa
[(7)] .24026 .33225 0 0 Mshowa
[(5)] .32684 .33225 0 0 Mshowa
[(3)] .41342 .33225 0 0 Mshowa
[(1)] .5 .33225 0 0 Mshowa
[(10)] .58658 .33225 0 0 Mshowa
[(8)] .67316 .33225 0 0 Mshowa
[(6)] .75974 .33225 0 0 Mshowa
[(4)] .84632 .33225 0 0 Mshowa
[(2)] .9329 .33225 0 0 Mshowa
[(10)] .15368 .24567 0 0 Mshowa
[(9)] .24026 .24567 0 0 Mshowa
[(8)] .32684 .24567 0 0 Mshowa
[(7)] .41342 .24567 0 0 Mshowa
[(6)] .5 .24567 0 0 Mshowa
[(5)] .58658 .24567 0 0 Mshowa
[(4)] .67316 .24567 0 0 Mshowa
[(3)] .75974 .24567 0 0 Mshowa
[(2)] .84632 .24567 0 0 Mshowa
[(1)] .9329 .24567 0 0 Mshowa
[(1)] .0671 1.02489 0 0 Mshowa
[(2)] .0671 .93831 0 0 Mshowa
[(3)] .0671 .85173 0 0 Mshowa
[(4)] .0671 .76515 0 0 Mshowa
[(5)] .0671 .67857 0 0 Mshowa
[(6)] .0671 .59199 0 0 Mshowa
[(7)] .0671 .50541 0 0 Mshowa
[(8)] .0671 .41883 0 0 Mshowa
[(9)] .0671 .33225 0 0 Mshowa
[(10)] .0671 .24567 0 0 Mshowa
[(1)] .15368 1.11147 0 0 Mshowa
[(2)] .24026 1.11147 0 0 Mshowa
[(3)] .32684 1.11147 0 0 Mshowa
[(4)] .41342 1.11147 0 0 Mshowa
[(5)] .5 1.11147 0 0 Mshowa
[(6)] .58658 1.11147 0 0 Mshowa
[(7)] .67316 1.11147 0 0 Mshowa
[(8)] .75974 1.11147 0 0 Mshowa
[(9)] .84632 1.11147 0 0 Mshowa
[(10)] .9329 1.11147 0 0 Mshowa
[(U[11])] .02381 1.19805 -1 0 Mshowa
gsave
.97619 1.19805 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05325 1.09675 0 0 Mshowa
[(y)] .08874 1.12879 0 0 Mshowa
1 Mabswid
[ ] 0 setdash
.02381 .20238 m
.02381 1.15476 L
s
.02381 .20238 m
.97619 .20238 L
s
.02381 .28896 m
.97619 .28896 L
s
.02381 .37554 m
.97619 .37554 L
s
.02381 .46212 m
.97619 .46212 L
s
.02381 .5487 m
.97619 .5487 L
s
.02381 .63528 m
.97619 .63528 L
s
.02381 .72186 m
.97619 .72186 L
s
.02381 .80844 m
.97619 .80844 L
s
.02381 .89502 m
.97619 .89502 L
s
.02381 .9816 m
.97619 .9816 L
s
.02381 1.06818 m
.97619 1.06818 L
s
.02381 1.15476 m
.97619 1.15476 L
s
.11039 .20238 m
.11039 1.15476 L
s
.19697 .20238 m
.19697 1.15476 L
s
.28355 .20238 m
.28355 1.15476 L
s
.37013 .20238 m
.37013 1.15476 L
s
.45671 .20238 m
.45671 1.15476 L
s
.54329 .20238 m
.54329 1.15476 L
s
.62987 .20238 m
.62987 1.15476 L
s
.71645 .20238 m
.71645 1.15476 L
s
.80303 .20238 m
.80303 1.15476 L
s
.88961 .20238 m
.88961 1.15476 L
s
.97619 .20238 m
.97619 1.15476 L
s
.02381 1.15476 m
.11039 1.06818 L
s
2.6 Mabswid
.11039 .20238 m
.11039 1.15476 L
s
.02381 1.06818 m
.97619 1.06818 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[28]:=",
  ImageSize->{234.625, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003Z000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000>X0003Z0000jP000>X0003Z0000jP000>X0
003Z00006@0E8`0lgmkOg]oNgmkOg]oNgmkOg]oNgmk/2>`8k0S/2>`8k0S/2>`8k0S/28c0S<2<`8c0
S<2<`8c0S<2<`8c0549/00006@0E8`0Dg]oNgmkOg]oNgmkOg]oNgmkOg]lDk1B<549/00006@0E8`0l
gmkOg]oNgmkOg]oNgmkOg]oNgmk/2>`8k0S/2>`8k0S/2>`8k0S/28c0S<2<`8c0S<2<`8c0S<2<`8c0
549/00006@0E8`0Dg]oNgmkOg]oNgmkOg]oNgmkOg]lDk1B<549/00006@0E8`0lgmkOg]oNgmkOg]oN
gmkOg]oNgmk/2>`8k0S/2>`8k0S/2>`8k0S/28c0S<2<`8c0S<2<`8c0S<2<`8c0549/00006@0E8`0D
g]oNgmkOg]oNgmkOg]oNgmkOg]lDk1B<549/00002003o`h05B<0?=oNgmkOg]oNgmkOg]oNgmkOg]oN
k0S/2>`8k0S/2>`8k0S/2>`8k0R<`8c0S<2<`8c0S<2<`8c0S<2<`1A2K00000/000?o00002`0E8`0D
g]oNgmkOg]oNgmkOg]oNgmkOg]lDk1B<549/00002004o`L00_l0103oo`098`?o2B<02=oNgmkOg]oN
0ol04MkOg]oNgmkOg^`8k0S/2>`800?o0148k0S/2>`8k0R<`8c0S<2<`003o`09`8c0S<2<`8c000Q2
0ol9@V`000070005o`000?l01`001?l00?l200XS00?o8b<022<05=kOg]oNgmkOg]oNomkOg]oNgmkO
2n`00oo/k006k0^<00?oS8`01X`9@P03od9200Q2K00000L000Go0000o`070004o`00o`8022<4o`TS
01gOg]oNgmkOg]oNgooOg]oNgmkOg^`8k0S/2>`8k003o`0Lk0S/2>`8k0R<`8c0S<2<`8c0S?n<`8c0
S<2<`0U200?o@T80249/00001`001Ol0003o00L000Co003o0P088`03ob?o00XS00SNgmkOg]oNg`?o
00WOg]oNgmkOg]l02>`01?o/k?l8k0V<0_l9S0U200?o@T80249/00002005o`D01Ol200PS00?o8ol0
2R<0?=oNgmkOg]oNomkOg]oNgmkOg]oNk0S/2>`8k0So2>cok0S/2>`8k0R<`8c0S<2<`8c0S?n<`8c0
S<2<`0U200?o@T80249/00003@000ol0o`0900TS0_l:8`08g]oNgmkOg]l4o`08g]oNgmkOg]l9k0;o
2N`8S0?o2H`8@P;o2T9/00003P000ol0000801DS03cOg]oNgmkOg]oNgmkOg]oNgmkOg^`8k0S/2>`8
k0S/2>`8k0S/2>`8S<2<`8c0S<2<`8c0S<2<`8c0S<0D@V`0000I01DS01CNgmkOg]oNgmkOg]oNgmkO
g]oNgaC/58`D@V`0000I01DS03cOg]oNgmkOg]oNgmkOg]oNgmkOg^`8k0S/2>`8k0S/2>`8k0S/2>`8
S<2<`8c0S<2<`8c0S<2<`8c0S<0D@V`0000I01DS01CNgmkOg]oNgmkOg]oNgmkOg]oNgaC/58`D@V`0
000I01DS03cOg]oNgmkOg]oNgmkOg]oNgmkOg^`8k0S/2>`8k0S/2>`8k0S/2>`8S<2<`8c0S<2<`8c0
S<2<`8c0S<0D@V`0000I01DS01CNgmkOg]oNgmkOg]oNgmkOg]oNgaC/58`D@V`0000I01DS03cOg]oN
gmkOg]oNgmkOg]oNgmkOg^`8k0S/2>`8k0S/2>`8k0S/2>`8S<2<`8c0S<2<`8c0S<2<`8c0S<0D@V`0
003Z0000jP000>X0003Z0000jP0000d00_l00`3oo`0?00?o4P04oa000olB00?o4003ogD0000=0004
o`00oa4000?o00004P000ol0000C0003o`00010000?o00004P000ol0001b00003@001?l00?lA0003
o`0001<000?o00004P000ol0000>00Co4`000ol0001b00003@001?l00?lA0003o`0001@000?o0000
3`02oa4000?o0?l04@03ogD0000<00Go4@000ol0000A0004o`00oa<000?o00003P000ol0o`0A0003
o`0007D0000Q00;o5002oa400olB00;o4@04og@0003Z0000jP000>X0003Z0000jP000>X0003Z0000
jP0000D0h?l500001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000200?o1002o`D00_l400?o1002o`L000?o0000
1@03o`T000?o00001P02o`T000?o00001P000ol000080003o`0000H00_l90003o`0000H00ol90003
o`0000H00ol80003o`0000D00ol90003o`0000D01?l80003o`0000D00ol:0003o`0000<000050003
o`0000<000?o00000P001?l00?l400;o1@000ol000020004o`00o`H000?o000020000ol000060003
o`0000D000Co003o20000ol000060003o`0000P000?o00001@001?l00?l80003o`0000T000?o0000
1P000ol000070003o`0000L000?o000020000ol000060003o`0000H000?o000020000ol000060003
o`0000T000?o00000`0000D000?o00000`000ol000020004o`00o`@00_l50003o`00008000Co003o
1P000ol0000600?o20000ol000050004o`00o`P000?o00001`000ol000070003o`0000D000Co003o
20000ol000090003o`0000H000?o00001@04o`P000?o000020000ol000060003o`0000L000?o0000
1`000ol000060003o`0000T000?o00000`0000D000?o00000`000ol000020004o`00o`@00_l50003
o`00008000Co003o1P000ol000050004o`00o`P000?o00001P02o`T000?o00001`000ol000070003
o`0000D00ol90003o`0000H00ol90003o`0000D000?o0?l02@000ol0000600;o2@000ol000080003
o`0000H000?o00001P000ol000090003o`0000<000050003o`0000<000?o00000P001?l00?l400;o
1@000ol000020004o`00o`H000?o00001@001?l00?l80003o`0000D000Co003o20000ol000080003
o`0000H000?o00001@000ol000090003o`0000H000?o00002@000ol000050003o`3o00T000?o0000
20000ol000060003o`0000D000Co003o20000ol000060003o`0000T000?o00000`0000D000?o0000
0P02o`D00_l500;o1002o`D00_l70003o`0000H00_l90003o`0000H00_l90003o`0000D01?l80003
o`0000H00ol80003o`0000H01?l80003o`0000H00_l90003o`0000D00ol90003o`0000H00_l90003
o`0000D00_l;0003o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003
o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003
o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003
o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050>3o
1@0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00001@03o`P00_l700?o2P000ol000060003o`0000P000?o0000
1@03o`T000?o00001@03o`T000?o00001@03o`T000?o00000`03o`@00_l60003o`0000H00_l90003
o`0000H00_l90003o`0000H00ol80003o`0000D01?l90003o`0000<000050003o`0000P000?o0000
1@02o`X000?o00001`000ol000060003o`0000P000?o000020000ol000060003o`0000P000?o0000
1P000ol000060003o`0000P000?o000010000ol000020004o`00o`D000?o00001@001?l00?l80003
o`0000D000Co003o20000ol000070003o`0000L000?o00001P000ol000090003o`0000<000050003
o`0000H00ol700;o2003o`T000?o00001`000ol000070003o`0000P000?o00001P000ol000080003
o`0000H000?o00001P000ol000080003o`0000@000?o00000P001?l00?l50003o`0000D000Co003o
20000ol000050004o`00o`P000?o00001@04o`P000?o00001`000ol000080003o`0000<000050003
o`0000D000Co003o1`02o`L000Co003o2@000ol000070003o`0000L000?o00001@03o`T000?o0000
1P02o`T000?o00001P000ol000080003o`0000@000?o00000P001?l00?l50003o`0000H00_l90003
o`0000D00ol90003o`0000D000?o0?l02@000ol000080003o`0000L000?o00000`0000D000?o0000
1@001?l00?l700;o1`001?l00?l90003o`0000P000?o00001P000ol000050003o`0000T000?o0000
20000ol000060003o`0000H000?o000020000ol000040003o`00008000Co003o1@000ol000050004
o`00o`P000?o00001@000ol000090003o`0000D000?o0?l02@000ol000050004o`00o`T000?o0000
0`0000D000?o00001P02o`P00_l800;o2P000ol0000500Co20000ol0000500Co20000ol0000500?o
2@000ol0000500;o2P000ol0000300;o1@02o`H000?o00001P02o`T000?o00001P03o`P000?o0000
1P02o`T000?o00001P02o`X000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D0h?l500001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000600;o2002o`P00_l:0003o`0000D00ol90003
o`0000D01?l80003o`0000800ol400;o1P000ol000060003o`0000P000?o00001`03o`P000?o0000
1@03o`T000?o00001@03o`T000?o00001P02o`T000?o00001@03o`X000?o00000`0000D000?o0000
1@001?l00?l700;o1`001?l00?l90003o`0000P000?o00001P000ol000060003o`0000P000?o0000
0`000ol000020004o`00o`D000?o00001P000ol000080003o`0000P000?o00001`000ol000060003
o`0000P000?o000020000ol000060003o`0000D000Co003o20000ol000080003o`0000L000?o0000
0`0000D000?o00001@001?l00?l700;o1`001?l00?l90003o`0000P000?o00001P000ol000070003
o`0000L000?o00000`000ol000020004o`00o`D000?o00001`000ol000070003o`0000H01?l80003
o`0000H000?o000020000ol0000600?o20000ol000050004o`00o`P000?o000020000ol000070003
o`0000<000050003o`0000H00_l800;o2002o`X000?o00001@03o`T000?o000020000ol000060003
o`0000<000?o00000P001?l00?l50003o`0000L000?o00001`000ol000060003o`3o00T000?o0000
1P000ol000080003o`0000D000Co003o20000ol0000500?o2@000ol0000600;o2P000ol000030000
1@000ol000050004o`00o`L00_l70004o`00o`T000?o00001@000ol000090003o`0000D000Co003o
20000ol000030003o`00008000Co003o1@000ol000080003o`0000H000?o00001P000ol0o`090003
o`0000H000?o000020000ol000050004o`00o`P000?o00001@000ol000090003o`0000P000?o0000
1`000ol0000300001@000ol0000600;o2002o`P00_l:0003o`0000D01?l80003o`0000H00_l90003
o`0000800_l500;o1P000ol0000500Co20000ol0000700;o2@000ol0000500;o2P000ol0000600;o
2@000ol0000600?o20000ol0000500?o2P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@3Po`D000050003
o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003
o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003
o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003
o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003
o`0000<000050003o`0000H000?o00001`02o`P000?o00002@000ol0000500?o2@000ol0000200?o
1002o`H000?o00001P02o`T000?o00001@04o`P000?o00001P03o`T000?o00001@03o`T000?o0000
1@03o`T000?o00001P02o`T000?o00001P03o`T000?o00000`0000D000?o00001P000ol0000700;o
20000ol000090003o`0000P000?o00001P000ol000030003o`00008000Co003o1@000ol000050004
o`00o`P000?o00001P000ol000080003o`0000T000?o00001P000ol000080003o`0000H000?o0000
1P000ol000080003o`0000D000Co003o20000ol000070003o`0000P000?o00000`0000D000?o0000
1`000ol0000600;o2@000ol000080003o`0000P000?o00001P000ol000030003o`00008000Co003o
1@000ol000050004o`00o`P000?o00001`000ol000070003o`0000L00ol80003o`0000P000?o0000
1P000ol000060003o`0000P000?o00001@001?l00?l80003o`0000D01?l90003o`0000<000050003
o`0000L000?o00001P02o`T000?o000020000ol0000600;o2@000ol000030003o`00008000Co003o
1@000ol0000500?o2@000ol000080003o`0000H000?o00001P001?l00?l80003o`0000D00ol90003
o`0000H000?o000020000ol0000600;o2@000ol000050003o`3o00X000?o00000`0000D000?o0000
20000ol0000500;o2P000ol000070003o`0000P000?o00001P000ol000030003o`00008000Co003o
1@000ol000050003o`0000T000?o00001@001?l00?l80003o`0000H000Co003o20000ol000050003
o`0000T000?o00001P000ol000080003o`0000D000Co003o20000ol000050003o`3o00X000?o0000
0`0000D000?o00001@04o`L00_l700Co2@000ol0000500?o2@000ol0000200;o1@02o`H000?o0000
1P03o`P000?o00001P02o`T000?o00001`02o`T000?o00001@04o`P000?o00001@02o`X000?o0000
1P02o`T000?o00001P02o`X000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D0h?l500001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000600;o2002o`P00_l:0003o`0000D00ol90003
o`0000H000?o000020000ol0000500Co20000ol0000600;o2@000ol0000600?o2@000ol0000500?o
2@000ol0000600?o20000ol0000200?o1002o`H000?o00001@03o`X000?o00000`0000D000?o0000
1@001?l00?l700;o1`001?l00?l90003o`0000H000?o000020000ol000060003o`0000P000?o0000
1P000ol000080003o`0000D000Co003o20000ol000090003o`0000H000?o000020000ol000060003
o`0000L000?o00001`000ol000030003o`00008000Co003o1@000ol000080003o`0000L000?o0000
0`0000D000?o00001@001?l00?l700;o1`001?l00?l90003o`0000H000?o000020000ol000070003
o`0000L000?o00001`000ol000070003o`0000D000Co003o20000ol000090003o`0000H000?o0000
1P03o`P000?o00001@04o`P000?o00000`000ol000020004o`00o`D000?o000020000ol000070003
o`0000<000050003o`0000D00ol800;o1`03o`X000?o00001P000ol000080003o`0000L000?o0000
1`000ol000080003o`0000H000?o00001P02o`T000?o00001`02o`T000?o00001@001?l00?l80003
o`0000D000?o0?l02@000ol000030003o`00008000Co003o1@000ol0000500?o2P000ol000030000
1@000ol000050003o`0000P00_l70003o`0000X000?o00001P000ol000080003o`0000P000?o0000
1P000ol000050004o`00o`P000?o00001@001?l00?l80003o`0000T000?o00001P000ol000050004
o`00o`P000?o00001@000ol0o`090003o`0000<000?o00000P001?l00?l50003o`0000D000?o0000
2P000ol0000300001@000ol0000600?o1`02o`P00ol90003o`0000D00_l:0003o`0000D01?l80003
o`0000H00_l90003o`0000H00_l90003o`0000H00ol90003o`0000H00_l90003o`0000H00_l90003
o`0000800_l500;o1P000ol0000500Co2@000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@3Po`D000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003
o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003
o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003
o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003
o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`0000D00ol800;o1`03o`X000?o0000
0P03o`@00_l60003o`0000H00ol80003o`0000D00ol90003o`0000D00ol90003o`0000L00_l90003
o`0000D01?l80003o`0000H000?o000020000ol0000500?o2@000ol0000600;o2P000ol000030000
1@000ol000080003o`0000D00_l:0003o`0000L000?o00000`000ol000020004o`00o`D000?o0000
1`000ol000070003o`0000P000?o00001P000ol000080003o`0000H000?o00001P001?l00?l80003
o`0000H000?o000020000ol000060003o`0000P000?o00001P000ol000080003o`0000D000Co003o
2@000ol0000300001@000ol000080003o`0000D00_l:0003o`0000L000?o00000`000ol000020004
o`00o`D000?o00001@04o`P000?o00001P03o`P000?o000020000ol000060003o`0000H000Co003o
20000ol000070003o`0000L000?o00001`000ol000070003o`0000H000?o000020000ol000050004
o`00o`T000?o00000`0000D000?o00001@03o`P00_l700?o2P000ol000030003o`00008000Co003o
1@000ol000050003o`3o00T000?o00001@001?l00?l80003o`0000H00_l90003o`0000L00_l90003
o`0000P000?o00001P000ol000070003o`0000L000?o00001P000ol000080003o`0000D00ol:0003
o`0000<000050003o`0000D000?o00002002o`L000?o00002P000ol000030003o`00008000Co003o
1@000ol000050003o`3o00T000?o00001@001?l00?l80003o`0000P000?o00001P000ol000060004
o`00o`P000?o00001@001?l00?l80003o`0000P000?o00001P000ol000060003o`0000P000?o0000
1@000ol0000:0003o`0000<000050003o`0000D01?l700;o1`04o`T000?o00000P02o`D00_l60003
o`0000H00_l90003o`0000H00_l90003o`0000D00ol90003o`0000L00_l90003o`0000H00_l90003
o`0000D01?l80003o`0000D00_l:0003o`0000H00ol90003o`0000<000050003o`0001000_lD0003
o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003
o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003o`00014000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003
o`0000<000050003o`0001000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000A0003o`00014000?o00004@000ol0000B0003o`0000<000050003o`0001000_lD0003
o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`0000<000050>3o1@0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0Y
omkOg]oNgmkOg]oNgmkOg]oNgmko2>`8k0S/2>`8k0S/2>`8k0S/2?l050000ol0000A0003o`000140
01GoS<2<`8c0S<2<`8c0S<2<`8c0S?l050000ol0000300001@000omVIP0@IP;o52<00ol0000A0003
od92015201GogmkOg]oNgmkOg]oNgmkOg]oNgol04n`00ol0000B0003o`00014000?o00004@000on<
S00AS003o`00018000?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0YomkOg]oN
gmkOg]oNgmkOg]oNgmko2>`8k0S/2>`8k0S/2>`8k0S/2?l050000ol0000A0003o`00014001GoS<2<
`8c0S<2<`8c0S<2<`8c0S?l050000ol0000300001@000omVIP0@IP;o52<00ol0000A0003od920152
01GogmkOg]oNgmkOg]oNgmkOg]oNgol04n`00ol0000B0003o`00014000?o00004@000on<S00AS003
o`00018000?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0YomkOg]oNgmkOg]oN
gmkOg]oNgmko2>`8k0S/2>`8k0S/2>`8k0S/2?l050000ol0000A0003o`00014001GoS<2<`8c0S<2<
`8c0S<2<`8c0S?l050000ol0000300001@000omVIP0@IP;o52<00ol0000A0003od92015201GogmkO
g]oNgmkOg]oNgmkOg]oNgol04n`00ol0000B0003o`00014000?o00004@000on<S00AS003o`000180
00?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0YomkOg]oNgmkOg]oNgmkOg]oN
gmko2>`8k0S/2>`8k0S/2>`8k0S/2?l050000ol0000A0003o`00014001GoS<2<`8c0S<2<`8c0S<2<
`8c0S?l050000ol0000300001@000omVIP06IP?o1fH2o`PS0ol98`03o`0000H00_l90003od9200E2
0ol9@P08omoNgmkOg]l3o`0:gmkOg]oNgmkOo`O/0ol9k003o`0000H01?l80003o`0000H00_l90003
o`0000800ol400;o1P000on<S005S0?o2H`00ol000060003o`0000T000?o00000`0000D000?oIVH0
1fH00omVIP06IP;o2B<00olS8`088`03o`0000D000Co003o20000om2@P06@P03od9200Q202Wog]oN
gmkOg]oNgooOg]oNgmkOg_l8k0S/2>`8k0S/on`8k0S/2>`8o`090003o`0000P000?o00001@001?l0
0?l80003o`0000<000?o00000P001?l00?l5000Eohc0S<2<`8c0S<3o`8c0S<2<`8co00P000?o0000
2@000ol0000300001@000omVIP05IPCo1fH2o`LS1?l98`03o`0000D000Co003o20000om2@P06@P03
od9200Q201GogmkOg]oNgmkOg_oNgmkOg]oNgol02>`3o`S/00?o000020000ol000070003o`0000D0
00Co003o20000ol000030003o`00008000Co003o1@000on<S008S003ohb<00J<00?o00001`000ol0
00080003o`0000<000050003ofIV00EV00?oI_l026H2o`LS00?o8ol02R<00ol0000600;o2@000om2
@P06@P03od9200Q200Sog]oNgmkOgP?o01kNgmkOg]oNgmko2>`8k0S/2?l8k?o/2>`8k0S/2?l;0003
o`0000H000?o00001@03o`T000?o00000`000ol000020004o`00o`D000WoS<2<`8c0S<000_l02Xc0
S<2<`8c0S?l90003o`0000P000?o00000`0000D000?oIVH01FH00omVo`08IP;o1b<00olSo`0:8`03
o`0000D000Co003o20000om2@P06@P03od9200Q201GogmkOg]oNgooOg]oNgmkOg]oNgol01n`01?o/
k?l8k003o`0000H000Co003o20000ol000050003o`0000T000?o00000`000ol000020004o`00o`D0
00?oS8`028`00on<S006S003o`0000P000?o00001`000ol0000300001@000omVIP06IP;o26H2o`PS
0_l:8`03o`0000H00_l90003od9200E20_l:@P08omkOg]oNgmh4o`0AgmkOg]oNgmko2>`8k0S/2>`0
0_l02PS/2>`8k0S/2?l900;o2@000ol0000600?o20000ol0000200;o1@02o`H000SoS<2<`8c0S0?o
00Z<`8c0S<2<`8co1`04o`T000?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0E
omoNgmkOg]oNgmkOg]oNgmkOg]oo01?/00?o00004P000ol0000A0003o`00014000?oS8`04H`00ol0
000B0003o`0000<000050003ofIV011V0_lD8`03o`00014000?o@T804D80:OoNgmkOg]oNgmkOg]oN
gmkOg]oNo`S/2>`8k0S/2>`8k0S/2>`8k0So01@000?o00004@000ol0000A000Eohc0S<2<`8c0S<2<
`8c0S<2<`8co01@000?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0EomoNgmkO
g]oNgmkOg]oNgmkOg]oo01?/00?o00004P000ol0000A0003o`00014000?oS8`04H`00ol0000B0003
o`0000<000050003ofIV011V0_lD8`03o`00014000?o@T804D80:OoNgmkOg]oNgmkOg]oNgmkOg]oN
o`S/2>`8k0S/2>`8k0S/2>`8k0So01@000?o00004@000ol0000A000Eohc0S<2<`8c0S<2<`8c0S<2<
`8co01@000?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0EomoNgmkOg]oNgmkO
g]oNgmkOg]oo01?/00?o00004P000ol0000A0003o`00014000?oS8`04H`00ol0000B0003o`0000<0
00050003ofIV011V0_lD8`03o`00014000?o@T804D80:OoNgmkOg]oNgmkOg]oNgmkOg]oNo`S/2>`8
k0S/2>`8k0S/2>`8k0So01@000?o00004@000ol0000A000Eohc0S<2<`8c0S<2<`8c0S<2<`8co01@0
00?o00000`0000D000?oIVH046H2oa@S00?o00004@000om2@P0A@P0EomoNgmkOg]oNgmkOg]oNgmkO
g]oo01?/00?o00004P000ol0000A0003o`00014000?oS8`04H`00ol0000B0003o`0000<000050>3o
1@0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00001@03o`P00_l700?o2P000ol0000600;o2@000ol0000500?o
2@000ol0000500?o2@000ol0000600?o20000ol000070003o`0000P000?o00000P03o`@00_l60003
o`0000D01?l80003o`0000D00ol90003o`0000H00_l:0003o`0000<000050003o`0000P000?o0000
1@02o`X000?o00001`000ol000050004o`00o`P000?o000020000ol000060003o`0000H000?o0000
20000ol000070003o`0000L000?o00001`000ol000080003o`0000<000?o00000P001?l00?l50003
o`0000H000?o000020000ol000080003o`0000H000?o00001@001?l00?l90003o`0000<000050003
o`0000P000?o00001@02o`X000?o00001`000ol000050004o`00o`P000?o00001P03o`P000?o0000
1P000ol000080003o`0000D01?l80003o`0000P000?o00001`000ol000030003o`00008000Co003o
1@000ol000070003o`0000L000?o000020000ol000060003o`0000D000Co003o2@000ol000030000
1@000ol0000600;o2002o`P00_l:0003o`0000D00ol90003o`0000D000Co003o20000ol000060003
o`0000P000?o00001@000ol0o`090003o`0000P000?o00001`000ol000030003o`00008000Co003o
1@000ol000080003o`0000H000?o00001@03o`T000?o00001P02o`X000?o00000`0000D000?o0000
20000ol0000500;o2P000ol000070003o`0000D000?o00002@000ol000050004o`00o`P000?o0000
1P000ol000080003o`0000D000?o0?l02@000ol000090003o`0000H000?o00000`000ol000020004
o`00o`D000?o00001@001?l00?l80003o`0000D000?o00002@000ol000050004o`00o`T000?o0000
0`0000D000?o00001@03o`P00_l700?o2P000ol0000600?o20000ol0000600;o2@000ol0000500;o
2P000ol0000600;o2@000ol0000600Co20000ol0000200;o1@02o`H000?o00001P02o`T000?o0000
1@04o`P000?o00001P02o`X000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D0h?l500001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000500Co1`02o`L01?l90003o`0000H00ol80003
o`0000H00_l90003o`0000H00_l90003o`0000800ol400;o1P000ol0000600?o2@000ol0000500?o
2@000ol0000500?o2@000ol000060003o`0000P000?o00001@03o`X000?o00000`0000D000?o0000
1P000ol0000700;o20000ol000090003o`0000L000?o00001`000ol000050004o`00o`P000?o0000
1@001?l00?l80003o`0000<000?o00000P001?l00?l50003o`0000L000?o000020000ol000080003
o`0000H000?o000020000ol000060003o`0000H000?o000020000ol000080003o`0000L000?o0000
0`0000D000?o00001`000ol0000600;o2@000ol000080003o`0000D01?l80003o`0000D000Co003o
20000ol000050004o`00o`P000?o00000`000ol000020004o`00o`D000?o00001`000ol000080003
o`0000P000?o00001P000ol000080003o`0000H000?o00001`000ol000070003o`0000H00ol90003
o`0000<000050003o`0000P000?o00001@02o`X000?o00001`000ol000050003o`3o00T000?o0000
1@03o`T000?o00001P02o`T000?o00000`000ol000020004o`00o`D000?o00001`000ol000080003
o`0000H00_l90003o`0000D00ol90003o`0000L000?o00001`000ol000050004o`00o`T000?o0000
0`0000D000?o00001@001?l00?l700;o1`001?l00?l90003o`0000D000?o0?l02@000ol000050003
o`0000T000?o00001@001?l00?l80003o`0000<000?o00000P001?l00?l50003o`0000L000?o0000
20000ol000080003o`0000H000?o00001@000ol000090003o`0000P000?o00001P000ol000050004
o`00o`T000?o00000`0000D000?o00001P02o`P00_l800;o2P000ol0000600;o2@000ol0000600?o
20000ol0000600;o2@000ol0000200;o1@02o`H000?o00001P02o`X000?o00001@03o`T000?o0000
1@04o`P000?o00001@04o`P000?o00001P02o`X000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D0h?l500001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003
o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o0000
4P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000@00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0000@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000@00;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000300001@000ol0000500?o2002o`L00ol:0003
o`0000D01?l80003o`0000D00ol90003o`0000H00ol80003o`0000D00ol90003o`0000L00_l90003
o`0000H000?o000020000ol0000600;o2@000ol0000500?o2@000ol0000200?o1002o`L000?o0000
0`0000D000?o00001P000ol0000700;o20000ol000090003o`0000H000?o000020000ol000080003
o`0000H000?o00001`000ol000070003o`0000P000?o00001P000ol000060004o`00o`P000?o0000
1P000ol000080003o`0000D000Co003o20000ol000080003o`0000H000?o00000`000ol000020004
o`00o`H000?o00000`0000D000?o00001P000ol0000700;o20000ol000090003o`0000L000?o0000
1`000ol000080003o`0000H000?o00001@04o`P000?o000020000ol000060003o`0000H000Co003o
20000ol000070003o`0000L000?o00001@001?l00?l80003o`0000H00ol80003o`0000<000?o0000
0P001?l00?l60003o`0000<000050003o`0000H000?o00001`02o`P000?o00002@000ol000080003
o`0000H000?o00001P02o`T000?o00001@000ol0o`090003o`0000D00ol90003o`0000H00ol90003
o`0000L000?o00001`000ol0000600;o2@000ol000050004o`00o`P000?o00000`000ol000020004
o`00o`H000?o00000`0000D000?o00001P000ol0000700;o20000ol000090003o`0000D000Co003o
20000ol000080003o`0000H000?o00001@000ol0o`090003o`0000D000?o00002@000ol000060003
o`0000T000?o000020000ol000060003o`0000D000Co003o20000ol000050004o`00o`P000?o0000
0`000ol000020004o`00o`H000?o00000`0000D000?o00001@02o`T00_l700;o2`000ol0000600;o
2@000ol0000500?o2@000ol0000600;o2@000ol0000500Co20000ol0000700?o20000ol0000500Co
20000ol0000600;o2@000ol0000600;o2@000ol0000200;o1@02o`L000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003
o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o0000
0`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003
o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o00004002oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00004002oa@000?o00004@000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`00014000?o00004@000ol0000A0003o`00018000?o00000`0000D000?o0000
4002oa@000?o00004@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00000`0000@0hOl50000103Qo`D000050003o`0000l00olD0003
o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o0000
4@000ol0000B0003o`0000<000050003o`0000h000Co0?oo50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@000ol0000=0003o`0000;o50000ol0000A0003o`00014000?o00004@000ol0000A0003o`000180
00?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@001?l00002o`030?oo00H0
00Co00000_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050003o`00008000?o0?l01P000ol0000200;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol000030003o`0000@000?o00000`02oa@000?o0000
4@000ol0000A0003o`00014000?o00004@000ol0000B0003o`00014000?o00004@000ol0000A0003
o`00018000?o00000`0000D000?o00000P000ol0o`040003o`0000@00_l700?o2P000ol0000500Co
20000ol0000500?o2@000ol0000600?o20000ol0000500?o2@000ol0000700;o2@000ol000060003
o`0000P000?o00001P02o`T000?o00001@03o`T000?o00000P03o`@00_l70003o`0000<000050004
o`0000;o00<0ool00P000ol0000500;o20000ol000090003o`0000H000?o000020000ol000080003
o`0000H000?o00001`000ol000070003o`0000P000?o00001P000ol000060004o`00o`P000?o0000
1P000ol000080003o`0000D000Co003o20000ol000080003o`0000H000?o00000`000ol000020004
o`00o`H000?o00000`0000D000?o00001`000ol0o`02o`@00_l80003o`0000T000?o00001`000ol0
00070003o`0000P000?o00001P000ol0000500Co20000ol000080003o`0000H000?o00001P001?l0
0?l80003o`0000L000?o00001`000ol000050004o`00o`P000?o00001P03o`P000?o00000`000ol0
00020004o`00o`H000?o00000`0000D000?o00001P001Ol0003o00D00_l80003o`0000T000?o0000
20000ol000060003o`0000H00_l90003o`0000D000?o0?l02@000ol0000500?o2@000ol0000600?o
2@000ol000070003o`0000L000?o00001P02o`T000?o00001@001?l00?l80003o`0000<000?o0000
0P001?l00?l60003o`0000<000050003o`0000D000?o00000`000ol0000200;o20000ol000090003
o`0000D000Co003o20000ol000080003o`0000H000?o00001@000ol0o`090003o`0000D000?o0000
2@000ol000060003o`0000T000?o000020000ol000060003o`0000D000Co003o20000ol000050004
o`00o`P000?o00000`000ol000020004o`00o`H000?o00000`0000D000?o000010000ol000040003
o`0000800_l700;o2`000ol0000600;o2@000ol0000500?o2@000ol0000600;o2@000ol0000500Co
20000ol0000700?o20000ol0000500Co20000ol0000600;o2@000ol0000600;o2@000ol0000200;o
1@02o`L000?o00000`0000D000?o00000`000ol000040003o`3o00<00_lD0003o`00014000?o0000
4@000ol0000A0003o`00014000?o00004P000ol0000A0003o`00014000?o00004@000ol0000B0003
o`0000<000050003o`00008000?o00001@000ol0o`0300;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@001Ol0003o00L00_l00`3oo`0200;o50000ol0000A0003o`00014000?o00004@000ol0000A0003
o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol0000300001@001?l00?l?00;o
50000ol0000A0003o`00014000?o00004@000ol0000A0003o`00018000?o00004@000ol0000A0003
o`00014000?o00004P000ol0000300001@000ol0o`0@00;o50000ol0000A0003o`00014000?o0000
4@000ol0000A0003o`00018000?o00004@000ol0000A0003o`00014000?o00004P000ol000030000
1@02oa400_lD0003o`00014000?o00004@000ol0000A0003o`00014000?o00004P000ol0000A0003
o`00014000?o00004@000ol0000B0003o`0000<000050>3o1@0001P00_o@0000jP000>X0003Z0000
jP000>X0000=00;o4002ok/00ol;00003@000ol0000@0003o`000;X000?o00002P0000L00_l40003
o`0000800ol300?o1@000ol0002Q00;o00<0ool02@000ol0o`090003o`0000T000060004o`00o`<0
00?o00000`000ol000030003o`0000@000?o0000XP000ol0o`0;0003o`0000P000?o00002@0000H0
00Co003o0`000ol000030003o`0000<000?o000010000ol0002S0003o`0000P01Ol70003o`3o00X0
00060004o`00o`<000?o00000`000ol000030003o`0000@000?o0000XP000ol0o`0;0003o`0000L0
00?o0?l02P0000H000Co003o0`000ol000030003o`0000<000?o000010000ol0002Q00;o00<0ool0
4`02o`030?oo00T0000500;o0P02o`800_l300;o1002o`D00_o90000jP000>X0003Z0000\
\>"],
  ImageRangeCache->{{{0, 233.625}, {287, 0}} -> {-1.27506, -2.34447, 
  0.0494387, 0.0494387}},
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{4, 5, 9, 3, 1}, Mod[#1\ #2, 11]&]\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["\<\
Sometimes we are interested in finding all the subgroups of a \
group.\
\>", "Text",
  CellTags->"Subgroups"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["CyclicSubgroups",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["cyclic",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroups",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Subgroups",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroups",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"Subgroups", "i:15"}],

Cell["Functions to obtain subgroups.", "Caption",
  CellTags->"Subgroups"],

Cell[TextData[{
  "Here we generate all the cyclic subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclicSubgroups[D[3]]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1}, "-Operation-"], Groupoid[{1, Ref}, "-Operation-"], 
      Groupoid[{1, Rot**Ref}, "-Operation-"], 
      Groupoid[{1, Rot\^2**Ref}, "-Operation-"], 
      Groupoid[{1, Rot, Rot\^2}, "-Operation-"]}\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Note the addition when we ask for ",
  StyleBox["all",
    FontSlant->"Italic"],
  " the subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subgroups[D[3]]\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1}, "-Operation-"], Groupoid[{1, Ref}, "-Operation-"], 
      Groupoid[{1, Rot**Ref}, "-Operation-"], 
      Groupoid[{1, Rot\^2**Ref}, "-Operation-"], 
      Groupoid[{1, Rot, Rot\^2}, "-Operation-"], 
      Groupoid[{1, Rot, Rot\^2, Ref, Rot**Ref, Rot\^2**Ref}, "-Operation-"]}
      \)], "Output",
  CellLabel->"Out[30]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["\<\
There are several other functions for working with subgroups.\
\>", 
  "Text",
  CellTags->{"Subgroups", "i:16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SubgroupIntersection",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(given\ a\ group\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ subgroups\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(\(H\_2, \)\ \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ determined\ by\ the\ intersection\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_2\),
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["SubgroupJoin",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(given\ a\ group\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ subgroups\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(\(H\_2, \)\ \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ generated\ by\ the\ elements\ in\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_2\),
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["SubgroupProduct",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ a\ group\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ subgroups\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(H\_1\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(\(H\_2, \)\ \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subgroupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{"{", \(h\_1\), " ", \(h\_2\), " ", 
                      StyleBox["|",
                        SingleLetterItalics->False], " ", \(h\_1\), " ", 
                      StyleBox["\[Element]",
                        SingleLetterItalics->False], " ", \(H\_1\), \(, \ \), 
                      \(h\_2\), " ", 
                      StyleBox["\[Element]",
                        SingleLetterItalics->False], " ", \(H\_2\), 
                      \(}\ \)}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                "Text"]}]},
          {
            RowBox[{
              StyleBox["SubgroupUnion",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(H\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(given\ a\ group\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ subgroups\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(\(H\_2, \)\ \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ determined\ by\ the\ union\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(H\_2\),
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Subgroups", "i:17"}],

Cell["Various functions to combine two subgroups of a group.", "Caption",
  CellTags->"Subgroups"],

Cell[TextData[{
  "Consider the subgroups \[LeftAngleBracket]2\[RightAngleBracket] and \
\[LeftAngleBracket]3\[RightAngleBracket] in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_18\)]],
  ". Here is the groupoid formed by their intersection."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G1\  = \ 
      SubgroupIntersection[Z[18], \ H1 = SubgroupGenerated[Z[18], 2], \ 
        H2 = SubgroupGenerated[Z[18], 3]]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{0, 6, 12}, Mod[#1 + #2, 18]&]\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["\<\
Using the same group and subgroups, here is the groupoid formed by \
their union.\
\>", "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G2\  = \ SubgroupUnion[Z[18], H1, \ H2]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \(Groupoid[{0, 2, 3, 4, 6, 8, 9, 10, 12, 14, 15, 16}, Mod[#1 + #2, 18]&]
      \)], "Output",
  CellLabel->"Out[32]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "We can see which of these two groupoids are subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_18\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[{G1, \ G2}, Z[18]]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Here we form the ",
  StyleBox["SubgroupJoin", "MR"],
  " of two subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_24\)]],
  " and also the join of two subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \({G1, \ G2}\  = 
      \ {SubgroupJoin[U[24], \ {1, \ 17}, \ {1, \ 13}], \ 
        SubgroupJoin[Symmetric[3], \ {{1, 2, 3}, {2, 1, 3}}, 
          \ {{1, 2, 3}, {3, 2, 1}}]}\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1, 5, 13, 17}, Mod[#1\ #2, 24]&], 
      Groupoid[{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 
            1}}, "-Operation-"]}\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Note that both these ",
  StyleBox["SubgroupJoin", "MR"],
  "s are subgroups (the first being a proper subgroup)."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[{{\ G1, U[24]}, \ {\ G2, Symmetric[3]}}]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({True, True}\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Now we form the ",
  StyleBox["SubgroupProduct", "MR"],
  " of the same subgroups in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_24\)]],
  " and also the same subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \({G1, \ G2}\  = 
      \ {SubgroupProduct[U[24], \ {1, \ 17}, \ {1, \ 13}], \ 
        SubgroupProduct[Symmetric[3], \ {{1, 2, 3}, {2, 1, 3}}, 
          \ {{1, 2, 3}, {3, 2, 1}}]}\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1, 5, 13, 17}, Mod[#1\ #2, 24]&], 
      Groupoid[{{1, 2, 3}, {2, 1, 3}, {3, 1, 2}, {3, 2, 1}}, "-Operation-"]}
      \)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Note that these are not both subgroups (and that the product is different \
from the join in the ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " case)."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[{{\ G1, U[24]}, \ {\ G2, Symmetric[3]}}]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell[TextData[{
  "Here is one way to generate a noncyclic subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  "."
}], "MathCaption",
  CellTags->"Subgroups"],

Cell[CellGroupData[{

Cell["\<\
{G = SubgroupJoin[Dihedral[4], SubgroupGenerated[Dihedral[4], Ref], \
SubgroupGenerated[Dihedral[4], Rot^2]], CyclicQ[G]}\
\>", "Input",
  CellLabel->"In[38]:=",
  CellTags->"Subgroups"],

Cell[BoxData[
    \({Groupoid[{1, Ref, Rot\^2, Rot\^2**Ref}, "-Operation-"], False}\)], 
  "Output",
  CellLabel->"Out[38]=",
  CellTags->"Subgroups"]
}, Open  ]],

Cell["2.6.3 Quotient groups", "Subsubsection",
  CellTags->{"Quotients", "i:18"}],

Cell[TextData[{
  "The third question deals with quotient structures. The fundamental \
function related to this for groupoids is ",
  StyleBox["QuotientGroup", "MR"],
  ". There is a number of related functions, as well as a number of options \
to consider for this function. Since a quotient group requires a normal \
subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " (from some group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ") for its construction, and a normal subgroup is one in which every left \
coset ",
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  " is equal to the right coset ",
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  " (where ",
  Cell[BoxData[
      \(TraditionalForm\`g\  \[Element] \ G\)]],
  "), we start this section by considering cosets."
}], "Text",
  CellTags->{"Quotients", "i:19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["LeftCoset",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ a\ group\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["H",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["element",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coset",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ containing\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["RightCoset",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ a\ group\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["H",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["element",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["right",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coset",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ containing\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"Quotients", "i:20"}],

Cell["Functions to create cosets.", "Caption",
  CellTags->"Quotients"],

Cell[TextData[{
  "The left coset of the subgroup {0, 4} in the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  " containing 7 is the set 7 + {0, 4}."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftCoset[Z[8], \ {0, \ 4}, \ 7]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \({7, 3}\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode is intended to illustrate how this coset is derived."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftCoset[Z[8], \ {0, \ 4}, \ 7, \ Mode\  \[Rule] \ Visual]\)], "Input",\

  CellLabel->"In[40]:=",
  CellTags->"Quotients"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.25 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.25 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.25 L
0 1.25 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.01 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.01 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 1 r
.2619 .98214 m
.2619 1.22024 L
.5 1.22024 L
.5 .98214 L
F
.5 .98214 m
.5 1.22024 L
.7381 1.22024 L
.7381 .98214 L
F
0 1 1 r
.2619 .26786 m
.2619 .50595 L
.5 .50595 L
.5 .26786 L
F
.5 .26786 m
.5 .50595 L
.7381 .50595 L
.7381 .26786 L
F
1 1 1 r
.02381 .98214 m
.02381 1.22024 L
.2619 1.22024 L
.2619 .98214 L
F
.7381 .98214 m
.7381 1.22024 L
.97619 1.22024 L
.97619 .98214 L
F
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.2619 .26786 m
.7381 .26786 L
s
.2619 .50595 m
.7381 .50595 L
s
.2619 .74405 m
.7381 .74405 L
s
.2619 .98214 m
.7381 .98214 L
s
.2619 1.22024 m
.7381 1.22024 L
s
.2619 .26786 m
.2619 1.22024 L
s
.5 .26786 m
.5 1.22024 L
s
.7381 .26786 m
.7381 1.22024 L
s
[(0)] .38095 1.10119 0 0 Mshowa
[(4)] .61905 1.10119 0 0 Mshowa
[(1)] .38095 .8631 0 0 Mshowa
[(5)] .61905 .8631 0 0 Mshowa
[(2)] .38095 .625 0 0 Mshowa
[(6)] .61905 .625 0 0 Mshowa
[(3)] .38095 .3869 0 0 Mshowa
[(7)] .61905 .3869 0 0 Mshowa
1 0 1 r
.2619 .14881 m
.2619 .24405 L
.5 .24405 L
.5 .14881 L
F
0 1 1 r
.2619 .02976 m
.2619 .125 L
.5 .125 L
.5 .02976 L
F
0 0 0 r
[(subgroup)] .52381 .19643 -1 0 Mshowa
[(coset)] .52381 .07738 -1 0 Mshowa
0 g
[(7 +)] .20238 1.10119 1 0 Mshowa
0 0 1 r
.7619 1.10119 m
.85714 1.10119 L
.85714 .3869 L
s
.85714 .3869 m
.7619 .3869 L
s
% Start of user PostScript
2.5 0.5 2.1 0.5 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[40]:=",
  ImageSize->{230.375, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003V000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000>H0003V0000iP000>H0003V0000iP000>H0
003V0000?00f3G@0000l03H=M00003`0=Ped0000?00f3G@0000l03H=M00003`0=Ped0000?00f3G@0
000l03H=M00003`0=Pd800?o0`03o`801?l300Co0P03oe40000l03H=1`001ol0003o0?l00`000ol0
00020004o`00o`H000Co003oD00003`0=Pd70003o`0000<000Ko0000o`04o`801Ol20003o`000540
000l03H=1`001ol0003o0?l00`000ol0o`050005o`000?l00P000ol0001A0000?00f3@P01?l200?o
0P04o`<00ol200CoD@0003`0=PdP0003o`000540000l03H=80000ol0001A0000?00f3G@0000l03H=
M00003`0=Ped0000?00f3G@0000l03H=M00003`0=Ped0000?00f3G@0003V0000iP000>H0003V0000
iP000>H0000l03I?M00003`0=Tmd0000?00fCg@0000l03I?M00003`0=Tmd0000?00fCg@0000l03I?
6P03oa<01?m00000?00fCad000?o00004@000ol000100000?00fC`L01?l200Go00<0ool00_l300Co
00<0ool00_l300?o0P05o`030?oo00;o?`0003`0=Tl:0004o`00o`8000Co003o0`000ol0o`030004
o`00o`@000Oo0000o`3o008000Co003o0`000ol0000l0000?00fC`L01?l20004o`00o`8000Oo0000
o`3o00<000Co003o10001ol0003o0?l00P001?l00?l30003o`0003`0000l03I?1`000ol000030004
o`00o`8000Oo0000o`3o00<000?o00000_l30007o`000?l0o`020004o`00o`<000?o0000?00003`0
=Tl700Co00@0ool00_l200Co0`07o`030?oo00800ol0103oo`02o`030?oo00?o?`0003`0=TlC0003
o`0005h0000l03I?4P02of00000l03I?M00003`0=Tmd0000?00fCg@0000l03I?M00003`0=Tmd0000
?00fCg@0000l03I?M0000>H0003V0000iP000>H0000l06ko?00003`000?o3@d0<`d00ol=3@0d3@03
o`0003X0000l0003o`d=03<=00?o3@d0=0d00ol0000j0000?0000ol=3@0c3@03o`d=03@=00?o0000
>P0003`000?o3@d0<`d00ol=3@0d3@03o`0003X0000l0003o`d=03<=00?o3@d0=0d00ol0000j0000
?0000ol=3@0c3@03o`d=03@=00?o0000>P0003`000?o3@d0<`d00ol=3@0d3@03o`0003X0000l0003
o`d=03<=00?o3@d0=0d00ol0000j0000?0000ol=3@0c3@03o`d=03@=00?o0000>P0003`000?o3@d0
<`d00ol=3@0d3@03o`0003X0000l0003o`d=03<=00?o3@d0=0d00ol0000j0000?0000ol=3@0c3@03
o`d=03@=00?o0000>P0003`000?o3@d0<`d00ol=3@0d3@03o`0003X0000l0003o`d=03<=00?o3@d0
=0d00ol0000j0000?0000ol=3@0c3@03o`d=03@=00?o0000>P0003`000?o3@d0<`d00ol=3@0d3@03
o`0003X0000l0003o`d=03<=00?o3@d0=0d00ol0000j0000?0000ol=3@0c3@03o`d=03@=00?o0000
>P0003`000?o3@d0<`d00ol=3@0d3@03o`0003X0000l0003o`d=03<=00?o3@d0=0d00ol0000j0000
?0000ol=3@0c3@03o`d=03@=00?o0000>P0003`000?o3@d0<`d00ol=3@0d3@03o`0003X0000l0003
o`d=03<=00?o3@d0=0d00ol0000j0000?0000ol=3@0c3@03o`d=03@=00?o0000>P0003`000?o3@d0
5Pd3oaX=00?o3@d05`d00ol=3@0J3@03o`0000/01=8[0000?0000ol=3@0I3@03o`d=01L=00?o3@d0
5`d00ol=3@0J3@03o`0000D01m8^0000?0000ol=3@0I3@03o`d=01L=00?o3@d060d00ol=3@0I3@03
o`0000805m8Q0000?0000ol=3@0G3@;o6Pd00ol=3@0H3@03o`d=01T=00?o00001@06dPd000?B0000
7`0003`000?o3@d06@d00ol=3@0G3@03o`d=01T=00?o3@d060d00ol0000900GB2P000m80000O0000
?0000ol=3@0F3@?o6Pd00ol=3@0F3@Co6Pd00ol0000=00;B2@000m80000O0000?0000ol=3@0c3@03
o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000
?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o0000
60000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03
o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000
?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o0000
60000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03
o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000
?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o0000
60000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03
o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000
?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o0000
60000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03
o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000
?0000ol=3@0c3@03o`d=03@=00?o000060000m80000O0000?0000ol=3@0c3@03o`d=03@=00?o0000
60000m80000O0000?01^oaX000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
5P04oaT000?o00005`02oa/000?o000060000m80000O0000?0000ol0000G0003o`0001T000?o0000
5P001?l00?lJ0003o`0001P000?B00007`0003`000?o000060000ol0000H0003o`0001H000Co003o
6P000ol0000H0003dP0001l0000l0003o`0001T000?o00005`000ol0000F00?o6`000ol0000H0003
dP0001l0000l0003o`0001H000Co003o6@000ol0000F0003o`0001/000?o000060000m80000O0000
?0000ol0000G00;o6P000ol0000G00?o6P000ol0000H0003dP0001l0000l0003o`0003<000?o0000
=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003
o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003
dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000
=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003
o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003
dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000
=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003
o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003
dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000
=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003
o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003
dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000
=0000ol0000H0003dP0001l0000l0003o`0003<000?o0000=0000ol0000H0003dP0001l0000l0003
o`0003<000?o0000=0000ol0000H0003dP0001l0000l06ko6P000m80000O0000?0000ol0000c0003
o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000
?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o0000
60000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003
o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000
?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o0000
60000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003
o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000
?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o0000
60000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003
o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000
?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o0000
60000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003
o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000
?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000c0003o`0003@000?o0000
60000m80000O0000?0000ol0000c0003o`0003@000?o000060000m80000O0000?0000ol0000F00?o
6P000ol0000F00?o6`000ol0000H0003dP0001l0000l0003o`0001L000?o00006@000ol0000I0003
o`0001P000?o000060000m80000O0000?0000ol0000G0003o`0001T000?o00006@000ol0000H0003
o`0001P000?B00007`0003`000?o00005`000ol0000I0003o`0001H00olK0003o`0001P000?B0000
7`0003`000?o00005`000ol0000I0003o`0001H000?o00006`000ol0000H0003dP0001l0000l0003
o`0001H00_lK0003o`0001H01?lJ0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B0000
7`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000<`000ol0000d0003
o`0001P000?B00007`0003`000?o0000<`000ol0000d0003o`0001P000?B00007`0003`000?o0000
<`000ol0000d0003o`0001P000?B00007`0003`0K_lJ0003dP0001l0000l0003odm?03=?00?oCdl0
=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003
odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003
dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0
=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003
odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003
dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0
=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003
odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003
dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0
=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003
odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003
dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0
=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003
odm?03=?00?oCdl0=4l00ol0000H0003dP0001l0000l0003odm?03=?00?oCdl0=4l00ol0000H0003
dP0001l0000N0003o`0000X000?o00003P000om?C`0GC`;o6Tl00om?C`0GC`?o6Tl00ol0000H0003
dP0001l0000N0003o`0000X000?o00003P000om?C`0FC`04odm?oaU?00?oCdl064l00om?C`0IC`03
o`0001P000?B00007`0001l000?o00001`05o`h000?oCdl05Tl01?m?ColIC`03odm?01I?1?lJC`03
o`0000805m8Q00007`000ol000090003o`0000h000?oCdl05Tl01?m?ColIC`03odm?01I?00?oCol0
6dl00ol0000j000080000ol000080003o`0000h000?oCdl05Tl01?m?ColIC`03odm?01I?00?oCol0
6dl00ol0000j00007@04oa/000?oCdl05dl2oaY?00?oCdl05dl2oa]?00?o0000>P0003`000?oCdl0
<dl00om?C`0dC`03o`0003X0000l0003odm?03=?00?oCdl0=4l00ol0000j0000?0000om?C`0cC`03
odm?03A?00?o0000>P0003`000?oCdl0<dl00om?C`0dC`03o`0003X0000l0003odm?03=?00?oCdl0
=4l00ol0000j0000?0000om?C`0cC`03odm?03A?00?o0000>P0003`000?oCdl0<dl00om?C`0dC`03
o`0003X0000l0003odm?03=?00?oCdl0=4l00ol0000j0000?0000om?C`0cC`03odm?03A?00?o0000
>P0003`000?oCdl0<dl00om?C`0dC`03o`0003X0000l0003odm?03=?00?oCdl0=4l00ol0000j0000
?0000om?C`0cC`03odm?03A?00?o0000>P0003`000?oCdl0<dl00om?C`0dC`03o`0003X0000l0003
odm?03=?00?oCdl0=4l00ol0000j0000?0000om?C`0cC`03odm?03A?00?o0000>P0003`000?oCdl0
<dl00om?C`0dC`03o`0003X0000l0003odm?03=?00?oCdl0=4l00ol0000j0000?0000om?C`0cC`03
odm?03A?00?o0000>P0003`000?oCdl0<dl00om?C`0dC`03o`0003X0000l0003odm?03=?00?oCdl0
=4l00ol0000j0000?0000om?C`0cC`03odm?03A?00?o0000>P0003`000?oCdl0<dl00om?C`0dC`03
o`0003X0000l0003odm?03=?00?oCdl0=4l00ol0000j0000?0000om?C`0cC`03odm?03A?00?o0000
>P0003`0K_ll0000iP000>H0003V0000iP000>H0003V0000\
\>"],
  ImageRangeCache->{{{0, 229.375}, {287, 0}} -> {-1.10002, -1.1276, 
  0.0183108, 0.0183108}},
  CellTags->"Quotients"],

Cell[BoxData[
    \({7, 3}\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Textual", "MR"],
  " mode walks through the calculation."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftCoset[Z[8], \ {0, \ 4}, \ 7, \ Mode\  \[Rule] \ Textual]\)], "Input",\

  CellLabel->"In[41]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \("Given an element g in a Groupoid G and a subgroup H of G, the left \
coset of H in G containing g is the set of all elements gH = {g h | h in H}. \
"\)], "Print",
  CellTags->"Quotients"],

Cell[BoxData[
    \("In this case, the left coset of {0, 4} in Z[8] containing 7 is given \
by {7, 3}. This can be seen as follows: "\)], "Print",
  CellTags->"Quotients"],

Cell[BoxData[
    \("7 + {0, 4}"\)], "Print",
  CellTags->"Quotients"],

Cell[BoxData[
    \("= {7 + 0, 7 + 4}"\)], "Print",
  CellTags->"Quotients"],

Cell[BoxData[
    \("= {7, 3}"\)], "Print",
  CellTags->"Quotients"],

Cell[BoxData[
    \({7, 3}\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "Note that the subgroup for the second argument can be given as a list or \
as a groupoid. The coset ",
  Cell[BoxData[
      \(TraditionalForm\`H\  + \ g\)]],
  " may happen to be the subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " itself."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RightCoset[U[11], \ SubgroupGenerated[U[11], \ 3], \ 3, \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"Quotients"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .42857 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.146259 0.136054 [
[ 0 0 0 0 ]
[ 1 .42857 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .42857 L
0 .42857 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.01 0 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.01 0 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 1 r
.15986 .28231 m
.15986 .41837 L
.29592 .41837 L
.29592 .28231 L
F
.29592 .28231 m
.29592 .41837 L
.43197 .41837 L
.43197 .28231 L
F
.43197 .28231 m
.43197 .41837 L
.56803 .41837 L
.56803 .28231 L
F
.56803 .28231 m
.56803 .41837 L
.70408 .41837 L
.70408 .28231 L
F
.70408 .28231 m
.70408 .41837 L
.84014 .41837 L
.84014 .28231 L
F
0 1 1 r
.15986 .28231 m
.15986 .35034 L
.29592 .35034 L
.29592 .28231 L
F
.29592 .28231 m
.29592 .35034 L
.43197 .35034 L
.43197 .28231 L
F
.43197 .28231 m
.43197 .35034 L
.56803 .35034 L
.56803 .28231 L
F
.56803 .28231 m
.56803 .35034 L
.70408 .35034 L
.70408 .28231 L
F
.70408 .28231 m
.70408 .35034 L
.84014 .35034 L
.84014 .28231 L
F
1 1 1 r
.02381 .28231 m
.02381 .41837 L
.15986 .41837 L
.15986 .28231 L
F
.84014 .28231 m
.84014 .41837 L
.97619 .41837 L
.97619 .28231 L
F
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.15986 .14626 m
.84014 .14626 L
s
.15986 .28231 m
.84014 .28231 L
s
.15986 .41837 m
.84014 .41837 L
s
.15986 .14626 m
.15986 .41837 L
s
.29592 .14626 m
.29592 .41837 L
s
.43197 .14626 m
.43197 .41837 L
s
.56803 .14626 m
.56803 .41837 L
s
.70408 .14626 m
.70408 .41837 L
s
.84014 .14626 m
.84014 .41837 L
s
[(3)] .22789 .35034 0 0 Mshowa
[(9)] .36395 .35034 0 0 Mshowa
[(5)] .5 .35034 0 0 Mshowa
[(4)] .63605 .35034 0 0 Mshowa
[(1)] .77211 .35034 0 0 Mshowa
[(6)] .22789 .21429 0 0 Mshowa
[(7)] .36395 .21429 0 0 Mshowa
[(10)] .5 .21429 0 0 Mshowa
[(8)] .63605 .21429 0 0 Mshowa
[(2)] .77211 .21429 0 0 Mshowa
1 0 1 r
.15986 .07823 m
.15986 .13265 L
.29592 .13265 L
.29592 .07823 L
F
0 1 1 r
.15986 .0102 m
.15986 .06463 L
.29592 .06463 L
.29592 .0102 L
F
0 0 0 r
[(subgroup)] .30952 .10544 -1 0 Mshowa
[(coset)] .30952 .03741 -1 0 Mshowa
0 g
[(* 3)] .87415 .35034 -1 0 Mshowa
0 0 1 r
.14626 .37755 m
.09184 .37755 L
.09184 .32313 L
s
.09184 .32313 m
.14626 .32313 L
s
% Start of user PostScript
-0.5 1.3 -0.1 1.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[42]:=",
  ImageSize->{288, 123.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N`P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@0002h0
9`g;0000;P0W3L/0000^02L=b`0002h09`g;0000;P0W3L/0000^02L=1P03o`<00ol200Co0`04o`80
0onZ0000;P0W3@D000Oo0000o`3o00<000?o00000P001?l00?l60004o`00ojT0000^02L=1@000ol0
00030006o`000?l01?l200Go0P000ol0002Z0000;P0W3@D000Oo0000o`3o00<000?o0?l01@001Ol0
003o008000?o0000ZP0002h09`d600Co0P03o`801?l300?o0P04ojX0000^02L=7P000ol0002Z0000
;P0W3Ah000?o0000ZP0002h09`g;0000;P0W3L/0000^02L=b`0002h09`g;0000o`0Q0000o`0Q0000
o`0Q0000;P0WCl/0000^02M?b`0002h09do;0000;P0WCaP00olC00CoV@0002h09dlK0003o`000140
00?o0000V@0002h09dl500Co0P05o`030?oo00;o0`04o`030?oo00;o0`03o`801Ol00`3oo`02oiP0
000^02M?20001?l00?l20004o`00o`<000?o0?l00`001?l00?l40007o`000?l0o`020004o`00o`<0
00?o0000U@0002h09dl500Co0P001?l00?l20007o`000?l0o`030004o`00o`@000Oo0000o`3o0080
00Co003o0`000ol0002E0000;P0WC`D000?o00000`001?l00?l20007o`000?l0o`030003o`0000;o
0`001ol0003o0?l00P001?l00?l30003o`0009D0000^02M?1@04o`040?oo00;o0P04o`<01ol00`3o
o`0200?o00@0ool00_l00`3oo`03oiP0000^02M?4@000ol0002g0000;P0WCa000_ni0000;P0WCl/0
000^02M?b`0002h09do;0000;P0WCl/0003o0240003o0240003o0240000^0<?o;`0002h000?o0000
90000ol0000T0003o`0002<000?o000090000ol0000T0003o`0002d0000^0003o`0002@000?o0000
90000ol0000S0003o`0002@000?o000090000ol0000]0000;P000ol0000T0003o`0002@000?o0000
8`000ol0000T0003o`0002@000?o0000;@0002h000?o000090000ol0000T0003o`0002<000?o0000
90000ol0000T0003o`0002d0000^0003o`0002@000?o000090000ol0000S0003o`0002@000?o0000
90000ol0000]0000;P000ol0000T0003o`0002@000?o00008`000ol0000T0003o`0002@000?o0000
;@0002h000?o000090000ol0000T0003o`0002<000?o000090000ol0000T0003o`0002d0000^0003
o`0002@000?o000090000ol0000S0003o`0002@000?o000090000ol0000]0000;P000ol0000T0003
o`0002@000?o00008`000ol0000T0003o`0002@000?o0000;@0002h000?o000090000ol0000T0003
o`0002<000?o000090000ol0000T0003o`0002d0000^0003o`0002@000?o000090000ol0000S0003
o`0002@000?o000090000ol0000]0000;P000ol0000T0003o`0002@000?o00008`000ol0000T0003
o`0002@000?o0000;@0002h000?o000090000ol0000T0003o`0002<000?o000090000ol0000T0003
o`0002d0000^0003o`0002@000?o000090000ol0000S0003o`0002@000?o000090000ol0000]0000
;P000ol0000T0003o`0002@000?o00008`000ol0000T0003o`0002@000?o0000;@0002h000?o0000
90000ol0000T0003o`0002<000?o000090000ol0000T0003o`0002d0000^0003o`0000l00_lC0003
o`0000l000?o00004P000ol0000;00?o1002o`l000?o00004002oa8000?o00003`04oa4000?o0000
;@0002h000?o00003P001?l00?lB0003o`0000l000?o00004P000ol0000<0003o`00008000Co003o
3P000ol0000?0004o`00oa4000?o000040000ol0000A0003o`0002d0000^0003o`0000h000Co003o
4P000ol0000@0003o`00014000?o000030000ol000020004o`00o`h000?o00003`001?l00?lA0003
o`00014000?o000040000ol0000]0000;P000ol0000>00?o4`000ol0000@0003o`00014000?o0000
30000ol000020004o`00o`h000?o00004002oa8000?o00004P000ol0000?0003o`0002d0000^0003
o`0000h000?o00004`000ol0000A0003o`00010000?o000030000ol000020004o`00o`h000?o0000
3`001?l00?lA0003o`0000l000Co003o4@000ol0000]0000;P000ol0000?00?o4P000ol0000>00Co
4P000ol0000;00;o1@02o`l000?o00004002oa8000?o00004002oa8000?o0000;@0002h000?o0000
90000ol0000T0003o`0002<000?o000090000ol0000T0003o`0002d0000^0003o`0002@000?o0000
90000ol0000S0003o`0002@000?o000090000ol0000]0000;P000ol0000T0003o`0002@000?o0000
8`000ol0000T0003o`0002@000?o0000;@0002h000?o000090000ol0000T0003o`0002<000?o0000
90000ol0000T0003o`0002d0000^0003o`0002@000?o000090000ol0000S0003o`0002@000?o0000
90000ol0000]0000;P000ol0000T0003o`0002@000?o00008`000ol0000T0003o`0002@000?o0000
;@0002h000?o000090000ol0000T0003o`0002<000?o000090000ol0000T0003o`0002d0000^0003
o`0002@000?o000090000ol0000S0003o`0002@000?o000090000ol0000]0000;P000ol0000T0003
o`0002@000?o00008`000ol0000T0003o`0002@000?o0000;@0002h000?o000090000ol0000T0003
o`0002<000?o000090000ol0000T0003o`0002d0000^0003o`0002@000?o000090000ol0000S0003
o`0002@000?o000090000ol0000]0000;P000ol0000T0003o`0002@000?o00008`000ol0000T0003
o`0002@000?o0000;@0002h000?o000090000ol0000T0003o`0002<000?o000090000ol0000T0003
o`0002d0000^0003o`0002@000?o000090000ol0000S0003o`0002@000?o000090000ol0000]0000
;P000ol0000T0003o`0002@000?o00008`000ol0000T0003o`0002@000?o0000;@0002h000?o0000
90000ol0000T0003o`0002<000?o000090000ol0000T0003o`0002d0000^0<?o;`0002h000?o3@d0
90d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000^0003o`d=02@=00?o3@d0
90d00ol=3@0S3@03o`d=02@=00?o3@d090d00ol0000]0000;P000ol=3@0T3@03o`d=02@=00?o3@d0
8`d00ol=3@0T3@03o`d=02@=00?o0000;@0002h000?o3@d090d00ol=3@0T3@03o`d=02<=00?o3@d0
90d00ol=3@0T3@03o`0002d0000^0003o`d=02@=00?o3@d090d00ol=3@0S3@03o`d=02@=00?o3@d0
90d00ol0000]0000;P000ol=3@0T3@03o`d=02@=00?o3@d08`d00ol=3@0T3@03o`d=02@=00?o0000
;@0002h000?o3@d090d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000L00?B
3`000ol=3@0T3@03o`d=02@=00?o3@d08`d00ol=3@0T3@03o`d=02@=00?o0000;@0001l01M8:0003
o`d=02@=00?o3@d090d00ol=3@0S3@03o`d=02@=00?o3@d090d00ol0000]00008`06dPD000?o3@d0
90d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000J017B0`000ol=3@0T3@03
o`d=02@=00?o3@d08`d00ol=3@0T3@03o`d=02@=00?o0000;@0001X000?B00001P05dPH000?o3@d0
90d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000J0003dP0000<01M890003
o`d=02@=00?o3@d090d00ol=3@0S3@03o`d=02@=00?o3@d090d00ol0000]00006P000m800004dPd0
00?o3@d090d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000J0004dP3BdQ00
00?o3@d090d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000J0003dP000140
00?o3@d090d00ol=3@0T3@03o`d=02<=00?o3@d090d00ol=3@0T3@03o`0002d0000J0003dP000140
00?o3@d03Pd3oa<=00?o3@d03Pd3oa<=00?o3@d03Pd3oa8=00?o3@d040d3oa4=00?o3@d03`d3oa8=
00?o00005003oaH0000J0003dP00014000?o3@d04@d00ol=3@0@3@03o`d=014=00?o3@d040d00ol=
3@0A3@03o`d=00l=00?o3@d04@d00ol=3@0@3@03o`d=010=00?o3@d04@d00ol0000G0003o`0001<0
000J0003dP00014000?o3@d04@d00ol=3@0@3@03o`d=00l=0olB3@03o`d=014=00?o3@d03`d00ol=
3@0?3@Co4@d00ol=3@0@3@03o`d=014=00?o00002@000ol0o`0;0003o`0001<0000J0003dP000140
00?oCdl03dl2oa=?00?oCdl03Tl01?m?ColBC`03odm?00i?0olBC`03odm?00m?00?oCol04Tl00om?
C`0@C`03odm?015?00?o00002P000ol0000800;o5P0001X000?B00004@000om?C`0AC`03odm?011?
00?oCdl03Tl01?m?ColBC`03odm?00i?00?oCdl04Tl00om?C`0?C`03odoo019?00?oCdl044l00om?
C`0AC`03o`0000P01Ol:0003o`0001<0000J0003dP00014000?oCdl03Tl3oa=?00?oCdl03dl2oa=?
00?oCdl03Tl4oa5?00?oCdl044l2oa9?00?oCdl03dl2oa=?00?o00002P000ol0000700?o5P0001X0
00?B00004@000om?C`0TC`03odm?02A?00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0001X0
00?B00004@000om?C`0TC`03odm?02A?00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0001X0
00?B00004@000om?C`0TC`03odm?02A?00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0001X0
00?B00004@000om?C`0TC`03odm?02A?00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0001X0
4M830003odm?02A?00?oCdl094l00om?C`0SC`03odm?02A?00?oCdl094l00ol0000]0000;P000om?
C`0TC`03odm?02A?00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0002h000?oCdl094l00om?
C`0TC`03odm?02=?00?oCdl094l00om?C`0TC`03o`0002d0000^0003odm?02A?00?oCdl094l00om?
C`0SC`03odm?02A?00?oCdl094l00ol0000]0000;P000om?C`0TC`03odm?02A?00?oCdl08dl00om?
C`0TC`03odm?02A?00?o0000;@0002h000?oCdl094l00om?C`0TC`03odm?02=?00?oCdl094l00om?
C`0TC`03o`0002d0000^0003odm?02A?00?oCdl094l00om?C`0SC`03odm?02A?00?oCdl094l00ol0
000]0000;P000om?C`0TC`03odm?02A?00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0002h0
00?oCdl094l00om?C`0TC`03odm?02=?00?oCdl094l00om?C`0TC`03o`0002d0000^0003odm?02A?
00?oCdl094l00om?C`0SC`03odm?02A?00?oCdl094l00ol0000]0000;P000om?C`0TC`03odm?02A?
00?oCdl08dl00om?C`0TC`03odm?02A?00?o0000;@0002h000?oCdl094l00om?C`0TC`03odm?02=?
00?oCdl094l00om?C`0TC`03o`0002d0000^0<?o;`000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {122.375, 0}} -> {-1.1938, -1.07502, 
  0.0257408, 0.0257408}},
  CellTags->"Quotients"],

Cell[BoxData[
    \({9, 5, 4, 1, 3}\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell["\<\
The examples shown thus far have been Abelian, so the distinction \
between left and right cosets is blurred.\
\>", "Text",
  CellTags->"Quotients"],

Cell["\<\
For this nonabelian group with this subgroup and element, we get \
different results depending on whether we use left or right cosets.\
\>", 
  "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(H\  = \ SubgroupGenerated[Symmetric[3], \ {3, \ 2, \ 1}]; {
      LeftCoset[Symmetric[3], H\ , \ {3, \ 1, \ 2}], \ 
      RightCoset[Symmetric[3], \ H, \ {3, \ 1, \ 2}]}\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \({{{2, 1, 3}, {3, 1, 2}}, {{1, 3, 2}, {3, 1, 2}}}\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["LeftCosets",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], " ", "and", " ", 
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cosets",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["RightCosets",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], " ", "and", " ", 
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["right",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cosets",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["H",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"Quotients", "i:21"}],

Cell["Functions to list all of the cosets.", "Caption",
  CellTags->"Quotients"],

Cell[TextData[{
  "Given a group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and a subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", Lagrange\[CloseCurlyQuote]s Theorem indicates that the number of cosets \
is ",
  Cell[BoxData[
      \(TraditionalForm\`| G | \(/\( | H | \)\)\)]],
  "."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftCosets[Z[8], \ {0, \ 4}]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \({{0, 4}, {1, 5}, {2, 6}, {3, 7}}\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode attempts to make a Cayley table of these cosets. Note: ",
  StyleBox["Output \[Rule] Graphics", "MR"],
  " causes the normal output to be suppressed so that the graphic image is \
the output. This is saved here and shown again."
}], "MathCaption",
  CellTags->{"Quotients", "i:22"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(gr1\  = \ 
      RightCosets[Z[8], \ {0, \ 4}, \ Mode\  \[Rule] \ Visual, \ 
        Output\  \[Rule] \ Graphics]; \)\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"Quotients"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
1 .5 0 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.56 .37 .6 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 0 1 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
1 .5 0 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.56 .37 .6 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 0 1 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
1 .5 0 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.56 .37 .6 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 0 1 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(0)] .18254 .81878 0 0 Mshowa
[(4)] .28836 .81878 0 0 Mshowa
[(1)] .39418 .81878 0 0 Mshowa
[(5)] .5 .81878 0 0 Mshowa
[(2)] .60582 .81878 0 0 Mshowa
[(6)] .71164 .81878 0 0 Mshowa
[(3)] .81746 .81878 0 0 Mshowa
[(7)] .92328 .81878 0 0 Mshowa
[(4)] .18254 .71296 0 0 Mshowa
[(0)] .28836 .71296 0 0 Mshowa
[(5)] .39418 .71296 0 0 Mshowa
[(1)] .5 .71296 0 0 Mshowa
[(6)] .60582 .71296 0 0 Mshowa
[(2)] .71164 .71296 0 0 Mshowa
[(7)] .81746 .71296 0 0 Mshowa
[(3)] .92328 .71296 0 0 Mshowa
[(1)] .18254 .60714 0 0 Mshowa
[(5)] .28836 .60714 0 0 Mshowa
[(2)] .39418 .60714 0 0 Mshowa
[(6)] .5 .60714 0 0 Mshowa
[(3)] .60582 .60714 0 0 Mshowa
[(7)] .71164 .60714 0 0 Mshowa
[(4)] .81746 .60714 0 0 Mshowa
[(0)] .92328 .60714 0 0 Mshowa
[(5)] .18254 .50132 0 0 Mshowa
[(1)] .28836 .50132 0 0 Mshowa
[(6)] .39418 .50132 0 0 Mshowa
[(2)] .5 .50132 0 0 Mshowa
[(7)] .60582 .50132 0 0 Mshowa
[(3)] .71164 .50132 0 0 Mshowa
[(0)] .81746 .50132 0 0 Mshowa
[(4)] .92328 .50132 0 0 Mshowa
[(2)] .18254 .3955 0 0 Mshowa
[(6)] .28836 .3955 0 0 Mshowa
[(3)] .39418 .3955 0 0 Mshowa
[(7)] .5 .3955 0 0 Mshowa
[(4)] .60582 .3955 0 0 Mshowa
[(0)] .71164 .3955 0 0 Mshowa
[(5)] .81746 .3955 0 0 Mshowa
[(1)] .92328 .3955 0 0 Mshowa
[(6)] .18254 .28968 0 0 Mshowa
[(2)] .28836 .28968 0 0 Mshowa
[(7)] .39418 .28968 0 0 Mshowa
[(3)] .5 .28968 0 0 Mshowa
[(0)] .60582 .28968 0 0 Mshowa
[(4)] .71164 .28968 0 0 Mshowa
[(1)] .81746 .28968 0 0 Mshowa
[(5)] .92328 .28968 0 0 Mshowa
[(3)] .18254 .18386 0 0 Mshowa
[(7)] .28836 .18386 0 0 Mshowa
[(4)] .39418 .18386 0 0 Mshowa
[(0)] .5 .18386 0 0 Mshowa
[(5)] .60582 .18386 0 0 Mshowa
[(1)] .71164 .18386 0 0 Mshowa
[(6)] .81746 .18386 0 0 Mshowa
[(2)] .92328 .18386 0 0 Mshowa
[(7)] .18254 .07804 0 0 Mshowa
[(3)] .28836 .07804 0 0 Mshowa
[(0)] .39418 .07804 0 0 Mshowa
[(4)] .5 .07804 0 0 Mshowa
[(1)] .60582 .07804 0 0 Mshowa
[(5)] .71164 .07804 0 0 Mshowa
[(2)] .81746 .07804 0 0 Mshowa
[(6)] .92328 .07804 0 0 Mshowa
[(0)] .07672 .81878 0 0 Mshowa
[(4)] .07672 .71296 0 0 Mshowa
[(1)] .07672 .60714 0 0 Mshowa
[(5)] .07672 .50132 0 0 Mshowa
[(2)] .07672 .3955 0 0 Mshowa
[(6)] .07672 .28968 0 0 Mshowa
[(3)] .07672 .18386 0 0 Mshowa
[(7)] .07672 .07804 0 0 Mshowa
[(0)] .18254 .9246 0 0 Mshowa
[(4)] .28836 .9246 0 0 Mshowa
[(1)] .39418 .9246 0 0 Mshowa
[(5)] .5 .9246 0 0 Mshowa
[(2)] .60582 .9246 0 0 Mshowa
[(6)] .71164 .9246 0 0 Mshowa
[(3)] .81746 .9246 0 0 Mshowa
[(7)] .92328 .9246 0 0 Mshowa
[(Z[8])] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[45]:=",
  ImageSize->{272.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l04@000?l04@000?l04@000?l04@000?l0
4@000?l04@000?l04@0000H0ool5o`H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooO
g`0Jg`03oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooO
g`0Jg`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
H_l600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O00?ogml06]l00olA4@0J4@03oa4A01TA
03_oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
o`0600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O00?ogml06]l0M?mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o1P0000H000?od]806M82oacB
00?od]806M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l01P0000H000?od]806M82oacB
00?od]806M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUERo`H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooO
g`0Jg`03oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooO
g`0Jg`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
H_l600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O00?ogml06]l00olA4@0J4@03oa4A01TA
03_oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
o`0600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O00?ogml06]l0M?mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o1P0000H000?od]806M82oacB
00?od]806M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l01P0000H000?od]806M82oacB
00?od]806M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUERo`H000060003om;B00[B00?od]803=82o`cB00?od]803M800ooB
dP09dP?o3M800ooOg`0;g`;o3Ml00ooOg`0:g`?o3Ml00olA4@094@?o3Q400olA4@094@?o3A403On0
OX1nP7j0OX1nP7h01?l06H1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX000_l03gj0OX1nP7j0OX1nP7j0
o`0600001P000ooBdP0:dP03om;B00cB0_l<dP03om;B00gB00?od]803=800ooBdP0:dP03omoO00[O
00Cogmoo3=l00ooOg`0;g`03omoO00cO07CoGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4OlAGa5O
4ElAGa5O4ElAGomO4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREOmEHUEREF9E
HUEREOmEH_mREF9EHUEREF9EHUERo`H000060003om;B00_B00?od]802m82o`gB00?od]803=800ooB
dP0<dP03om;B00[B00?ogml02]l01?oOgol<g`03omoO00WO1?l=g`03oa4A00XA00?o4A403A400olA
4@0<4@03oa4A00XA03_oP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0O_mnP?n0
OX1nP7j0OX1nP7j0o`0600001P000ooBdP0;dP03om;B00_B0_l=dP03om;B00cB00?od]802]82o`gB
00?ogml02]l01?oOgol<g`03omoO00WO00?ogol03]l0:OmO4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O
4ElAoa5O4ElAGa5O4ElA00?o03HAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EH_mREF9EHUEREF9E
HUGoEF9EHUEREF9EHUD3o`0?EF9EHUEREF9EHUEREF;o00H000060003om;B00cB00?od]802]82o`kB
00?od]802m800ooBdP0<dP03om;B00[B00?ogml02]l01?oOgol<g`03omoO00WO00?ogol03]l00olA
4@0:4@03oa4A00dA00?o4A402A400olA4@0=4@0koh1nP7j0OX1nP7j0O_mnP?n0OX1nP7j0OX1nP7ko
OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP?l01P0000H000?od]802M84o`cB0_l;dPCo3M800ooB
dP09dP?o3M800ooOg`0;g`;o3Ml00ooOg`0:g`;o3]l03?mO4ElAGa5O4ElAG`;o01/AGa5O4ElAGa5O
4ElAGa7o4ElAGa5O4ElAGa401?l06UlAGa5O4ElAGa5O4OmREF9EHUEREF9EHUER0_l06UEREF9EHUER
EF9EHUGoEF9EHUEREF9EHUER0ol03V9EHUEREF9EHUEREF;o1P0000H000?od]806M82oacB00?od]80
6M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l01P0000H000?od]806M82oacB00?od]80
6M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUERo`H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`03
oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`1d
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l60000
1P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O00?ogml06]l00olA4@0J4@03oa4A01TA03_oP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`060000
1P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O00?ogml06]l0M?mO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o1P0000H000?od]806M82oacB00?od]80
6M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l01P0000H000?od]806M82oacB00?od]80
6M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUERo`H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`03
oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`1d
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l60000
1P3oo`Go1P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERo`H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`03oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l00olA4@0J4@03oa4A01TA03_oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o1P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA
4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP?l01P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERo`H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`03oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l00olA4@0J4@03oa4A01TA03_oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o1P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA
4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP?l01P0000H000?od]802M83o`gB0_l;dP?o3]800ooBdP0:dP03om;B00cB00?ogml02ml3o`cO
00?ogml02]l2o`kO00coGa5O4ElAGa5O4El3o`0JGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa43o`0K
4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUER00;o01UEHUEREF9EHUEREF9EoeEREF9EHUEREF9E00Co
00iREF9EHUEREF9EHUERo`H000060003om;B00cB00?od]802]82o`kB00?od]802m800ooBdP0:dP03
om;B00cB00?ogml03=l00ooOg`0;g`03omoO00WO00Cogmoo3Ml00olA4@0<4@03oa4A00/A00?o4A40
2Q400olA4@0<4@0koh1nP7j0OX1nP7j0O_mnP?n0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0oh1nP7j0
OX1nP7j0OX1nP?l01P0000H000?od]803=800ooBdP0:dP;o3]800ooBdP0;dP03om;B00_B00?od]80
2m800ooOg`0:g`Co3=l00ooOg`09g`04omoOo`gO07CoGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O
4OlAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EoeERof9EHUEREF9EHUEREOmE
HUEREF9EHUEREF9EoeEREF9EHUEREF9EHUERo`H000060003om;B00[B0_l=dP;o3=82o`kB00?od]80
2m800ooBdP0;dP03omoO00[O00?ogol03Ml00ooOg`09g`04omoOo`gO00?o4A402A43o`hA00?o4A40
2Q400olA4@0<4@0=oh1nP7j0OX1nP7j0OP03o`0[OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP?n0
OX1nP7j0OX1nP7j0o`0600001P000ooBdP0<dP03om;B00[B0_l>dP03om;B00_B00?od]803=800ooB
dP0:dP03omoO00[O00?ogol03Ml00ooOg`09g`04omoOo`gO07CoGa5O4ElAGa5O4EooGa5O4ElAGa5O
4ElAGa5O4OlAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EoeEREF9EHUEREF9E
HUEREOmEHUEREF9EHUEREOmEH_mREF9EHUEREF9EHUERo`H000060003om;B00WB0ol=dP;o2m83o`kB
00?od]802M84o`cB00?ogml02ml2o`gO00?ogml02]l2o`kO00?o4A402A44o`dA00?o4A402A42o`hA
00koP7j0OX1nP7j0OX1nP0?o01V0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j000;o00mnP7j0OX1nP7j0
OX1nP?l01P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERo`H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`03oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l00olA4@0J4@03oa4A01TA03_oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o1P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O00?o4A406Q400olA
4@0I4@0koh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP?l01P0000H000?od]806M82oacB00?od]806M800ooOg`0Jg`03omoO01[O07CoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERo`H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`03oa4A01XA00?o4A406A40>on0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o00H000060003om;B01WB
0_lLdP03om;B01WB00?ogml06]l00ooOg`0Jg`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l600001P000ooBdP0IdP;o7=800ooBdP0IdP03omoO01[O
00?ogml06]l00olA4@0J4@03oa4A01TA03_oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0600001P3oo`Go1P0000H001coOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1n0_l0>H1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1no`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`03oa4A01XA00?o4A406Q400ol0
000400001P007?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0iHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806]800ooOg`0Jg`03
omoO01WO03_o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAo`0600001P007?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806]800ooO
g`0Jg`03omoO01WO00?o4A406Q400olA4@0J4@03o`0000@00006000LoeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUERE@;o03UREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREOl07=800ooBdP0JdP03omoO01[O00?ogml06Ml0>olAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o00H00006000Logj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OP;o03V0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0JdP03omoO01[O00?ogml06Ml00olA4@0J4@03oa4A01XA
00?o0000100000H001coEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0>F9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01[B00?ogml0
6]l00ooOg`0Ig`0koa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4Ol01P0000H001coOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0>H1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01[B
00?ogml06]l00ooOg`0Ig`03oa4A01XA00?o4A406Q400ol0000400001P007?mEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUD2o`0iHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUGo01cB00?od]806]800ooOg`0Jg`03omoO01WO03_o4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0600001P007?mnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806]800ooOg`0Jg`03omoO01WO00?o4A406Q400olA
4@0J4@03o`0000@00006000LoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o03UREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooBdP0JdP03
omoO01[O00?ogml06Ml0>olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa7o00H00006000Logj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03V0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07=800ooB
dP0JdP03omoO01[O00?ogml06Ml00olA4@0J4@03oa4A01XA00?o0000100000H000goEF9EHUEREF9E
HUER00;o00eEHUEREF9EHUEREF9E00;o00aREF9EHUEREF9EHUD2o`0JHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUD4o`0=HUEREF9EHUEREF9Eo`0=dP03om;B00cB00?od]802M83o`kB00?ogml02]l2o`kO
00?ogml02]l3o`cO00go4ElAGa5O4ElAGa5O00?o01UO4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O00?o
00mO4ElAGa5O4ElAGa5O4Ol01P0000H001coOX1nP7j0OX1nP7koOX3oP7j0OX1nP7j0OX1n0_l0>H1n
P7j0OX1nP7j0oh1nogj0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1no`0=dP03
om;B00cB00?od]803=800ooBdP0;dP03omoO00WO00Cogmoo3Ml00ooOg`0;g`03omoO00_O00?o4A40
2a400olA4@0<4@03oa4A00`A00?o4A402a400ol0000400001P007?mEHUEREF9EHUEREOmEH_mREF9E
HUEREF9EHUD2o`0iHUEREF9EHUEREF;oHUGoEF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EoeEREF9E
HUEREF9EHUGo00kB00?od]802m800ooBdP0<dP03om;B00_B00?ogml02Ml01?oOgol=g`03omoO00WO
1?l<g`0koa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElA
Ga5O4Ol01P0000H000coOX1nP7j0OX1nP7h3o`0=OX1nP7j0OX1nP7j0OP02o`0;P7j0OX1nP7j0OX00
0ol0:h1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0O_l03]800ooBdP0;dP03
om;B00[B0_l>dP03omoO00WO00Cogmoo3Ml00ooOg`09g`03omoo00gO00?o4A402a400olA4@0<4@03
oa4A00TA0ol>4@03o`0000@00006000LoeEREF9EHUEREF9EoeEREF9EHUEREF9EHUERE@;o03UREF9E
HUEREF9EH_mREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EoeERof9EHUEREF9EHUEREOl03m800ooB
dP0:dP03om;B00cB00?od]802m800ooOg`09g`04omoOo`gO00?ogml02Ml00ooOo`0=g`0koa5O4ElA
Ga5O4ElAGa7o4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4Ol01P0000H0
00goOX1nP7j0OX1nP7j000?o00b0OX1nP7j0OX1nP7h2o`0<P7j0OX1nP7j0OX1n0ol06Wj0OX1nP7j0
OX1nP7koOX1nP7j0OX1nP7j00_l03Wj0OX1nP7j0OX1nP7ko3=84o`cB00?od]802M83o`kB00?ogml0
2]l2o`kO00?ogml02]l2o`gO00?o4A402Q42o`hA00?o4A402A44o`dA00?o0000100000H001coEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0>F9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`0koa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Ol01P0000H0
01coOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0>H1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`03
oa4A01XA00?o4A406Q400ol0000400001P007?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0i
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB
00?od]806]800ooOg`0Jg`03omoO01WO03_o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0600001P007?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7h2o`0iP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7ko01cB00?od]806]800ooOg`0Jg`03omoO01WO00?o4A406Q400olA4@0J4@03o`0000@00006000L
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o03UREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooBdP0JdP03omoO01[O00?ogml06Ml0>olA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o00H0
0006000Logj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03V0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0JdP03omoO01[O00?ogml0
6Ml00olA4@0J4@03oa4A01XA00?o0000100000H001coEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
0_l0>F9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`0koa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Ol01P0000H001coOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1n0_l0>H1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1no`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`03oa4A01XA00?o4A406Q400ol000040000
1P007?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0iHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806]800ooOg`0Jg`03omoO01WO
03_o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
o`0600001P007?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806]800ooOg`0Jg`03
omoO01WO00?o4A406Q400olA4@0J4@03o`0000@00006000LoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUERE@;o03UREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREOl07=800ooBdP0JdP03omoO01[O00?ogml06Ml0>olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o00H000060?oo1Ol600001P007?mEHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUD2o`0iHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806]800ooOg`0Jg`03omoO01WO03_o4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0600001P007?mn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806]800ooOg`0Jg`03omoO01WO00?o4A40
6Q400olA4@0J4@03o`0000@00006000LoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o03UREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooB
dP0JdP03omoO01[O00?ogml06Ml0>olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa7o00H00006000Logj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o
03V0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l0
7=800ooBdP0JdP03omoO01[O00?ogml06Ml00olA4@0J4@03oa4A01XA00?o0000100000H001coEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0>F9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`0koa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Ol01P0000H0
01coOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0>H1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`03
oa4A01XA00?o4A406Q400ol0000400001P007?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0i
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB
00?od]806]800ooOg`0Jg`03omoO01WO03_o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0600001P007?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7h2o`0iP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7ko01cB00?od]806]800ooOg`0Jg`03omoO01WO00?o4A406Q400olA4@0J4@03o`0000@00006000L
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o03UREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooBdP0JdP03omoO01[O00?ogml06Ml0>olA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o00H0
0006000Logj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03V0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0JdP03omoO01[O00?ogml0
6Ml00olA4@0J4@03oa4A01XA00?o0000100000H001coEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
0_l0>F9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`0koa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Ol01P0000H000coOX1nP7j0OX1nP7h4o`0<P7j0OX1n
P7j0OX1n0_l02h1nP7j0OX1nP7j000Co01YnP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP0;o00inP7j0
OX1nP7j0OX1no`cB0ol=dP03om;B00[B00?od]803M800ooOg`0:g`?o3Ml00ooOg`0:g`;o3Ml00olA
4@0:4@?o3A400olA4@094@?o3Q400ol0000400001P007?mEHUEREF9EHUEREF;oHUEREF9EHUEREF9E
HUD2o`0iHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREOmEH_mREF9EHUEREF9E
HUGo00oB00?od]802]800ooBdP0:dP03om;B00gB00?ogml02ml00ooOg`0<g`03omoO00WO00Cogmoo
3=l0>olAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElA
Ga7o00H00006000Logj0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OP;o03V0OX1nP7j0OX1nP7j0oh1n
P7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nogj0oh1nP7j0OX1nP7j0O_l03m800ooBdP0:dP03om;B00_B
00?od]803=800ooOg`09g`Co3Ml00ooOg`09g`04omoOo`cO00?o4A403A400olA4@0:4@03oa4A00XA
00?o4A403A400ol0000400001P007?mEHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUD2o`0XHUEREF9E
HUEREF9EHUGoEF9EHUEREF9EHUEREOmEHUEREF9EHUERE@?o00iEHUEREF9EHUEREF9Eo`gB0_l=dP03
om;B00_B00?od]803=800ooOg`09g`03omoo00kO00?ogml02Ml01?oOgol<g`0=oa5O4ElAGa5O4ElA
G`03o`0[Ga5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAo`0600001P007?mn
P7j0OX1nP7j0O_mnP?n0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX3oP7koOX1nP7j0OX1nP7j0O_mn
P7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7ko00oB00?od]802]800ooBdP0<dP03om;B00_B00?ogml0
2Ml00ooOo`0>g`03omoO00WO00Cogmoo3=l00olA4@0:4@03oa4A00dA00?o4A402Q400olA4@0=4@03
o`0000@00006000=oeEREF9EHUEREF9EHP02o`0=EF9EHUEREF9EHUERE@02o`0<HUEREF9EHUEREF9E
0_l06f9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHP03o`0=HUEREF9EHUEREF9Eo`0<dP?o3M800ooB
dP09dPCo3M800ooOg`0:g`;o3]l00ooOg`0:g`;o3Ml03OlAGa5O4ElAGa5O4El01?l0615O4ElAGa5O
4ElAGomO4ElAGa5O4ElAG`;o010AGa5O4ElAGa5O4ElAGa7o1P0000H001coOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1n0_l0>H1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1no`0LdP03om;B01[B00?ogml06]l00ooOg`0Ig`03oa4A01XA00?o4A406Q400ol0
000400001P007?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0iHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806]800ooOg`0Jg`03
omoO01WO03_o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAo`0600001P007?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806]800ooO
g`0Jg`03omoO01WO00?o4A406Q400olA4@0J4@03o`0000@00006000LoeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUERE@;o03UREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREOl07=800ooBdP0JdP03omoO01[O00?ogml06Ml0>olAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o00H00006000Logj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OP;o03V0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0JdP03omoO01[O00?ogml06Ml00olA4@0J4@03oa4A01XA
00?o0000100000H001coEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0>F9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01[B00?ogml0
6]l00ooOg`0Ig`0koa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4Ol01P0000H001coOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0>H1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01[B
00?ogml06]l00ooOg`0Ig`03oa4A01XA00?o4A406Q400ol0000400001P007?mEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUD2o`0iHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUGo01cB00?od]806]800ooOg`0Jg`03omoO01WO03_o4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`0600001P007?mnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0iP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806]800ooOg`0Jg`03omoO01WO00?o4A406Q400olA
4@0J4@03o`0000@00006000LoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o03UREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooBdP0JdP03
omoO01[O00?ogml06Ml0>olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa7o00H000060?oo1Ol600001P007?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4El2o`1c4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@000060003oa4A01TA0_lL4@03oa4A01TA
03_oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
o`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@00006000LoelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUGo01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H000?o4A406A42oa`A
00?o4A406A40>omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7ko01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H001coGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O0_l0La5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOl07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P000olA
4@0I4@;o71400olA4@0I4@0kogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P007?mO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4El2o`1c4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@0
00060003oa4A01TA0_lL4@03oa4A01TA03_oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@0
0006000LoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806M800ooOg`0Jg`03omoO01[O
00?o0000100000H000?o4A406A42oa`A00?o4A406A40>omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806M800ooOg`0Jg`03omoO01[O
00?o0000100000H001coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O0_l0La5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooBdP0IdP03omoO01[O
00?ogml06]l00ol0000400001P000olA4@0I4@;o71400olA4@0I4@0kogj0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0IdP03omoO01[O
00?ogml06]l00ol0000400001P003?mO4ElAGa5O4ElAG`?o00eO4ElAGa5O4ElAGa5O00;o00/AGa5O
4ElAGa5O4@03o`0J4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4El3o`0KGa5O4ElAGa5O4ElAGomEHUER
EF9EHUEREF9E00;o01UREF9EHUEREF9EHUERof9EHUEREF9EHUER00Co00iEHUEREF9EHUEREF9Eo`cB
00?od]803M800ooBdP09dP?o3M800ooOg`0;g`;o3Ml00ooOg`0:g`?o3Ml00ol0000400001P000olA
4@0<4@03oa4A00XA0_l>4@03oa4A00/A00?o4A402Q400olA4@0<4@0kogj0OX1nP7j0OX1nP?n0O_mn
P7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0O_l03=800ooBdP0=dP03om;B00cB
00?od]802]800ooOg`0:g`04omoOo`cO00?ogml02ml00ooOg`0<g`03o`0000@00006000LoelAGa5O
4ElAGa5O4ElAoa5O4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5OoelAGa5O
4ElAGa5O4OlAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF;oHUGoEF9EHUEREF9EHUERof9EHUEREF9E
HUEREF;oHUEREF9EHUEREF9EHUGo00gB00?od]803=800ooBdP0<dP03om;B00[B00?ogml02]l01?oO
gol<g`03omoO00WO1?l=g`03o`0000@000060003oa4A00TA0ol=4@;o2a43o`hA00?o4A402Q400olA
4@0<4@0=ogj0OX1nP7j0OX1nP003o`0[P7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0O_mnP7j0OX1n
P7j0OX1no`0=dP03om;B00cB00?od]802]82o`gB00?ogml02]l01?oOgol<g`03omoO00WO00?ogol0
3]l00ol0000400001P007?mO4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4El2o`1c4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUERof9E
HUEREF9EHUEREF9EH_mREF9EHUEREF9EH_mREOmEHUEREF9EHUEREF9Eo`0>dP03om;B00_B00?od]80
3=800ooBdP0:dP03omoO00[O00Cogmoo3=l00ooOg`09g`03omoo00kO00?o0000100000H000?o4A40
2A44o``A0_l;4@Co3A400olA4@094@;o3Q403_mnP7j0OX1nP7j0OX1n0ol06Gj0OX1nP7j0OX1nP?n0
OX1nP7j0OX1nP7h00_l03h1nP7j0OX1nP7j0OX1no`0;dPCo3M800ooBdP09dP?o3M800ooOg`0;g`;o
3Ml00ooOg`0:g`;o3]l00ol0000400001P007?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4El2o`1c
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03
om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@000060003oa4A01TA0_lL4@03oa4A01TA03_oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03
om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@00006000LoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAG`;o07<AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUGo01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H000?o4A406A42oa`A00?o4A40
6A40>omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7ko01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H001coGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O0_l0La5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREOl07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P000olA4@0I4@;o
71400olA4@0I4@0kogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P007?mO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4El2o`1c4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@000060003
oa4A01TA0_lL4@03oa4A01TA03_oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@00006000L
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000
100000H000?o4A406A42oa`A00?o4A406A40>omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000
100000H0ool5o`H000060003oa4A01TA0_lL4@03oa4A01TA03_oOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03om;B01WB00?ogml06]l00ooO
g`0Jg`03o`0000@00006000LoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo01cB00?od]806M800ooO
g`0Jg`03omoO01[O00?o0000100000H000?o4A406A42oa`A00?o4A406A40>omnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806M800ooO
g`0Jg`03omoO01[O00?o0000100000H001coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O0_l0La5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooB
dP0IdP03omoO01[O00?ogml06]l00ol0000400001P000olA4@0I4@;o71400olA4@0I4@0kogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07=800ooB
dP0IdP03omoO01[O00?ogml06]l00ol0000400001P007?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4El2o`1c4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@000060003oa4A01TA0_lL4@03oa4A01TA
03_oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
o`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@00006000LoelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUGo01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H000?o4A406A42oa`A
00?o4A406A40>omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7ko01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H001coGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O0_l0La5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOl07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P000olA
4@0I4@;o71400olA4@0I4@0kogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P007?mO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4El2o`1c4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@0
00060003oa4A00TA0ol=4@;o2a43o`hA00?o4A402A43o`dA00goOX1nP7j0OX1nP7j000Co01UnP7j0
OX1nP7j0OX3oP7j0OX1nP7j0OX1n00;o00n0OX1nP7j0OX1nP7j0O_l02m83o`kB00?od]802]800ooB
dP0<dP03omoO00_O0ol<g`03omoO00[O0_l>g`03o`0000@00006000LoelAGa5O4ElAGa5O4OlAGa5O
4ElAGa5O4ElAG`;o07<AGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAoa5O
4ElAGa5O4ElAGomEHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUERof9EHUEREF9EHUERof9EoeEREF9E
HUEREF9EHUGo00kB00?od]802m800ooBdP0:dP03om;B00cB00?ogml03=l00ooOg`0;g`03omoO00WO
00Cogmoo3Ml00ol0000400001P000olA4@0:4@03oa4A00`A0_l<4@03oa4A00dA00?o4A4031400olA
4@0:4@0kogj0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX3oP7koOX1nP7j0OX1n
P7j0O_l03]800ooBdP0;dP03om;B00_B00?od]802m800ooOg`0:g`Co3=l00ooOg`09g`04omoOo`gO
00?o0000100000H001coGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O0_l0:15O4ElAGa5O4ElAGomO
4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4El3o`0fGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUGo
EF9EHUEREF9EHUERof9EHUEREF9EHUER0ol03f9EHUEREF9EHUEREF9Eo`0<dP;o3]800ooBdP0;dP03
om;B00_B00?ogml02]l00ooOo`0=g`03omoO00WO00Cogmoo3Ml00ol0000400001P000olA4@0:4@03
oa4A00`A0_l<4@03oa4A00dA00?o4A402A400olA4@0=4@0kogj0OX1nP7j0OX1nP?n0O_mnP7j0OX1n
P7j0OX3oP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0O_l03]800ooBdP0;dP03om;B00cB00?od]80
2]800ooOg`0:g`03omoo00gO00?ogml02Ml01?oOgol=g`03o`0000@00006000<oelAGa5O4ElAGa5O
0_l03Q5O4ElAGa5O4ElAGa5O0_l02a5O4ElAGa5O4ElA00;o01]O4ElAGa5O4ElAGa5O4EooGa5O4ElA
Ga5O4El01?l06Q5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9E0_l06V9EHUEREF9EHUEREF;oHUEREF9E
HUEREF9E0ol03UEREF9EHUEREF9EHUGo2m83o`kB00?od]802M84o`cB00?ogml02ml2o`gO00?ogml0
2]l2o`kO00?o0000100000H000?o4A406A42oa`A00?o4A406A40>omnP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01cB00?od]806M800ooOg`0Jg`03
omoO01[O00?o0000100000H001coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O0_l0La5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07=800ooBdP0IdP03
omoO01[O00?ogml06]l00ol0000400001P000olA4@0I4@;o71400olA4@0I4@0kogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07=800ooBdP0IdP03
omoO01[O00?ogml06]l00ol0000400001P007?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4El2o`1c
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0LdP03
om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@000060003oa4A01TA0_lL4@03oa4A01TA03_oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0LdP03
om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@00006000LoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAG`;o07<AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUGo01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H000?o4A406A42oa`A00?o4A40
6A40>omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7ko01cB00?od]806M800ooOg`0Jg`03omoO01[O00?o0000100000H001coGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O0_l0La5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREOl07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P000olA4@0I4@;o
71400olA4@0I4@0kogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l07=800ooBdP0IdP03omoO01[O00?ogml06]l00ol0000400001P007?mO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4El2o`1c4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9Eo`0LdP03om;B01WB00?ogml06]l00ooOg`0Jg`03o`0000@000060?oo
1Ol600001P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO
00?ogml06Ml00olA4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO0_lLg`03
omoO01WO07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUERoacB00?od]806]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA00?o4A40
6Q40>_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P?lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@0
00060003omoO01WO0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]806]800ol000040000
1P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml0
6Ml00olA4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO0_lLg`03omoO01WO
07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB
00?od]806]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA00?o4A406Q40>_mn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03
om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@000060003
omoO00[O0ol<g`;o3=l3o`gO00?ogml02]l2o`gO00?o4A402Q43o`dA00?o4A402A43o`hA00goOX1n
P7j0OX1nP7j000;o01YnP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP0Co00enP7j0OX1nP7j0OX3o00gB
00?od]803=800ooBdP09dP?o3]800ol0000400001P000ooOg`0;g`03omoO00_O0_l=g`03omoO00cO
00?ogml02Ml01?oOgol<g`1doelAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O
oelAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREOmEH_mREF9EHUEREF9EHUERof9EHUEREF9EHUEREOmE
HUEREF9EHUEREF9EH_l=dP03om;B00cB00?od]803=800ooBdP0;dP03o`0000@000060003omoO00WO
1?l<g`;o2ml4o`gO00?ogml02Ml01?oOgol<g`03oa4A00dA00?o4A402Q400olA4@0:4@03oa4A00dA
03[oOX1nP7j0OX1nP7koOX3oP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX3o
3]800ooBdP0;dP03om;B00cB00?od]802m800ol0000400001P000ooOg`09g`03omoo00gO0_l;g`03
omoo00kO00?ogml02Ml01?oOgol<g`0=oelAGa5O4ElAGa5O4@03o`0f4ElAGa5O4ElAGa5O4OlAGa5O
4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9E0ol0:eEREF9EHUEREF9EHUERof9EHUER
EF9EHUEREF9EoeEREF9EHUEREF9EH_l03]800ooBdP0;dP03om;B00[B0_l>dP03o`0000@000060003
omoO00WO00?ogol03Ml2o`_O00?ogol03]l00ooOg`09g`04omoOo`cO00?o4A402Q400olA4@0=4@03
oa4A00XA00?o4A403A40>_mnP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0oh1n
ogj0OX1nP7j0OX1nP?l?dP03om;B00[B00?od]803=800ooBdP0;dP03o`0000@000060003omoO00[O
0_l=g`;o3=l2o`kO00?ogml02]l2o`gO00goGa5O4ElAGa5O4ElA00Co01QO4ElAGa5O4ElAGa7o4ElA
Ga5O4ElAGa42o`0LGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHP?o01YREF9EHUEREF9EHUERof9E
HUEREF9EHUERE@;o00iREF9EHUEREF9EHUERo`cB1?l<dP03om;B00WB0ol>dP03o`0000@000060003
omoO01WO0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]806]800ol0000400001P000ooO
g`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00olA
4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO0_lLg`03omoO01WO07CoGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB00?od]80
6]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA00?o4A406Q40>_mnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03om;B01[B
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
H_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@000060003omoO01WO
0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]806]800ol0000400001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00olA4@0J4@03
oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO0_lLg`03omoO01WO07CoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB00?od]806]800ol0
000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA00?o4A406Q40>_mnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03om;B01[B00?o0000
100000H0ool5o`H000060003omoO01WO0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]80
6]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml0
6Ml2oacO00?ogml06Ml00olA4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO
0_lLg`03omoO01WO07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUERoacB00?od]806]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA
00?o4A406Q40>_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP?lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?mO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03
o`0000@000060003omoO01WO0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]806]800ol0
000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO
00?ogml06Ml00olA4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO0_lLg`03
omoO01WO07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUERoacB00?od]806]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA00?o4A40
6Q40>_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P?lLdP03om;B01[B00?o0000100000H000?ogml02]l2o`gO0_l<g`;o3]l00ooOg`0:g`?o3=l03OmO
4ElAGa5O4ElAGa400ol06A5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa400ol06Q5O4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9E1?l06V9EHUEREF9EHUEREF;oHUEREF9EHUEREF9E0_l03V9EHUEREF9EHUEREF;o
3=83o`gB00?od]802]800ooBdP0=dP03o`0000@000060003omoO00WO00Cogmoo3=l2o`_O00Cogmoo
3Ml00ooOg`0;g`03omoO00_O00?o4A402a400olA4@0<4@03oa4A00`A00?o4A402a40>_mnP7j0OX1n
P7j0OX3oP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0oh1nogj0OX1nP7j0OX1nP?l?dP03om;B00[B
00?od]802]800ooBdP0=dP03o`0000@000060003omoO00WO00Cogmoo3=l2o`_O00Cogmoo3Ml00ooO
g`09g`Co3=l0M?mO4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5OoelAGa5O
4ElAGa5O4EooEF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EH_mREF9EHUEREF9EH_mREOmEHUEREF9E
HUEREF;o3m800ooBdP0:dP03om;B00_B00?od]803=800ol0000400001P000ooOg`09g`04omoOo`cO
0_l;g`04omoOo`gO00?ogml02Ml00ooOo`0=g`03oa4A00/A00?o4A4031400olA4@094@?o3Q40:Omn
P7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j000?o00j0OX1nP7j0OX1nP7j0o`gB
0_l=dP03om;B00_B00?od]803=800ol0000400001P000ooOg`09g`04omoOo`cO0_l;g`04omoOo`gO
00?ogml02Ml00ooOo`0=g`1doelAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa7o
4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREOmEH_mREF9EHUEREF9EHUERof9EHUEREF9EHUERof9E
HUEREF9EHUEREF9EH_l?dP03om;B00[B00?od]803=800ooBdP0;dP03o`0000@000060003omoO00[O
0_l=g`;o3=l2o`kO00?ogml02]l2o`gO00?o4A402Q42o`hA00?o4A402A44o`dA00goOX1nP7j0OX1n
P7j000;o01]nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7h00ol03Gj0OX1nP7j0OX1nP?l03=83o`gB
00?od]802M84o`gB00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@0
00060003omoO01WO0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]806]800ol000040000
1P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml0
6Ml00olA4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003omoO01WO0_lLg`03omoO01WO
07CoGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB
00?od]806]800ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03oa4A01XA00?o4A406Q40>_mn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03
om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@000060003
omoO01WO0_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB00?od]806]800ol0000400001P000ooO
g`0Ig`;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00olA
4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000050?oo1_l600001@3oo`Ko1P0000H000?o0000
6003oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@000060003o`0001L000Co0?oo7=l00ooOg`0Ig`03
oa4A01XA00?o4A406Q40>_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP?lLdP03om;B01[B00?o0000100000H000?o00005P000ol00002oacO00?ogml0
6Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o
7=800ooBdP0JdP03o`0000@000060003o`0001D000Co00000_lLg`03omoO01WO00?o4A406Q400olA
4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0oacB00?od]806]800ol0000400001P000ol0000D0003o`0000800_lLg`03omoO01WO07CoGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB00?od]80
6]800ol0000400001P000ol0000C0003o`0000<00_lLg`03omoO01WO00?o4A406Q400olA4@0J4@0j
ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oacB
00?od]806]800ol0000400001P000ol0000400;o00<0ool02@000ol0000400;o7=l00ooOg`0Ig`1d
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomE
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_lLdP03
om;B01[B00?o0000100000H000?o00001@000ol0o`090003o`0000D00_lLg`03omoO01WO00?o4A40
6Q400olA4@0J4@0jogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0oacB00?od]806]800ol0000400001P000ol000060003o`0000L000?o00001P02oacO
00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o7=800ooBdP0JdP03o`0000@000060003o`0000D000?o0?l01`000ol0000700;o7=l00ooO
g`0Ig`03oa4A01XA00?o4A406Q40>_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03om;B01[B00?o0000100000H000?o00001002o`030?oo00D0
00?o00002002oacO00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF;o7=800ooBdP0JdP03o`0000@000060003o`0000d000?o00002@02o`cO
0_l>g`03omoO00[O0ol<g`03oa4A00XA0ol=4@03oa4A00TA0ol>4@0<ogj0OX1nP7j0OX1n1?l06X1n
P7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1n0_l03X1nP7j0OX1nP7j0OX3o3=83o`gB00?od]802]800ooB
dP0=dP03o`0000@000060003o`0000`000?o00002P02o`_O00Cogmoo3Ml00ooOg`0;g`03omoO00_O
07CoGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF;oHUGoEF9EHUEREF9EHUERo`oB
00?od]802]800ooBdP0:dP03om;B00gB00?o0000100000H000?o00002`000ol0000;00;o2ml01?oO
gol=g`03omoO00WO1?l<g`03oa4A00/A00?o4A4031400olA4@0<4@03oa4A00/A03[oOX1nP7j0OX1n
P7j0O_mnP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP?n0O_mnP7j0OX1nP7j0OX3o3m800ooBdP0:dP03
om;B00_B00?od]803=800ol0000400001P000ol0000:0003o`0000`00_l;g`04omoOo`gO00?ogml0
2Ml00ooOo`0=g`0YoelAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa400ol0=a5O
4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF;oHUEREF9EHUEREF800ol03V9E
HUEREF9EHUEREF;o3M82o`gB00?od]802m800ooBdP0<dP03o`0000@000060003o`0000T000?o0000
1003o`H00_l;g`04omoOo`gO00?ogml02Ml00ooOo`0=g`03oa4A00/A00?o4A4031400olA4@094@03
oa4A00hA03[oOX1nP7j0OX1nP7koOX3oP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP?n0OX1nP7j0OX1n
P7j0OX3o3m800ooBdP0:dP03om;B00cB00?od]802m800ol0000400001P000ol000080003o`0000H0
00?o00001@02o`cO0_l>g`03omoO00[O0_l=g`0=oelAGa5O4ElAGa5O4@02o`0JGa5O4ElAGa5O4ElA
Ga7o4ElAGa5O4ElAGa44o`0JGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF82o`0KEF9EHUEREF9EHUER
EF;oHUEREF9EHUEREF9E00?o00eEHUEREF9EHUEREF;o00cB0ol=dP03om;B00WB1?l=dP03o`0000@0
00060003o`0000L000?o000020000ol0000400;o7=l00ooOg`0Ig`03oa4A01XA00?o4A406Q40>_mn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03
om;B01[B00?o0000100000H000?o00001P000ol000090003o`0000@00_lLg`03omoO01WO07CoGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB00?od]80
6]800ol0000400001P000ol000050003o`0000T000?o0?l01@02oacO00?ogml06Ml00olA4@0J4@03
oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX3o7=800ooBdP0JdP03o`0000@000060003o`0000@000?o00002P000ol0o`0500;o7=l00ooO
g`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
H_lLdP03om;B01[B00?o0000100000H000?o00000`000ol0000:00;o00<0ool01002oacO00?ogml0
6Ml00olA4@0J4@03oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3o7=800ooBdP0JdP03o`0000@000060003o`00008000?o00005002oacO
00?ogml06Ml0M?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o7=800ooBdP0JdP03o`0000@000060005o`000?l05`02oacO00?ogml06Ml00olA4@0J4@03
oa4A01XA03[oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX3o7=800ooBdP0JdP03o`0000@000060004o`00oaP00_lLg`03omoO01WO07CoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoacB00?od]806]800ol0
000400001P000ol0o`0I00;o7=l00ooOg`0Ig`03oa4A01XA00?o4A406Q40>_mnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?lLdP03om;B01[B00?o0000
100000H00_lJ00;o7=l00ooOg`0Ig`1doelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EH_lLdP03om;B01[B00?o0000100000H0ool5o`H0000R00;ok0000?l0
4@000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@000?l04@0000h00_l:00;o
i@03o``0000>0003o`0000X000?o0000i0000ol0000;00001`04o`<000?o00000`02o`D000?o0000
b`02o`030?oo00X000?o000020000ol0000:000020000ol0o`030003o`00008000Co003o10000ol0
003<0003o`3o00/000?o000020000ol0000:000020000ol000030003o`00008000Co003o10000ol0
003=0003o`0000P01Ol70003o`3o00/000090003o`00008000?o00000`02o`D000?o0000c0000ol0
o`0;0003o`0000L000?o0?l02`0000L000?o0?l010000ol000020004o`00o`@000?o0000b`02o`03
0?oo00X000?o00001P02o`030?oo00X0000700Co0`02o`@00_l400;om0000?l04@000?l04@000?l0
4@000001\
\>"],
  ImageRangeCache->{{{0, 271.812}, {287, 0}} -> {-1.22505, -0.239038, 
  0.034767, 0.034767}},
  CellTags->"Quotients"]
}, Open  ]],

Cell["Compare the previous image to the following one.", "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(gr2\  = \ 
      CayleyTable[Z[4], \ Mode\  \[Rule] \ Visual, \ 
        Output\  \[Rule] \ Graphics]; \)\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \("For each element, a different color is used. The entries in the table \
corresponding to the elements are then colored and labeled accordingly."\)], 
  "Print",
  CellTags->"Quotients"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(0)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(2)] .69048 .69286 0 0 Mshowa
[(3)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(2)] .5 .50238 0 0 Mshowa
[(3)] .69048 .50238 0 0 Mshowa
[(0)] .88095 .50238 0 0 Mshowa
[(2)] .30952 .3119 0 0 Mshowa
[(3)] .5 .3119 0 0 Mshowa
[(0)] .69048 .3119 0 0 Mshowa
[(1)] .88095 .3119 0 0 Mshowa
[(3)] .30952 .12143 0 0 Mshowa
[(0)] .5 .12143 0 0 Mshowa
[(1)] .69048 .12143 0 0 Mshowa
[(2)] .88095 .12143 0 0 Mshowa
[(0)] .11905 .69286 0 0 Mshowa
[(1)] .11905 .50238 0 0 Mshowa
[(2)] .11905 .3119 0 0 Mshowa
[(3)] .11905 .12143 0 0 Mshowa
[(0)] .30952 .88333 0 0 Mshowa
[(1)] .5 .88333 0 0 Mshowa
[(2)] .69048 .88333 0 0 Mshowa
[(3)] .88095 .88333 0 0 Mshowa
[(Z[4])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[46]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P0000H0nOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80
;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl60000
1P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03
oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l0
1P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0
;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o
<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80
;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl60000
1P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03
oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l0
1P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0
;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o
<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80
;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl60000
1P000ooBdP0DdP?o5]82oaKB0olHdP03omoO01GO0_lHg`03oa4A01@A0olG4@0Gogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX001?l067j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`H000060003om;B01OB00?od]80
4m82oaWB00?od]805M800ooOg`0Dg`04omoOoaOO06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUER
EF9EHUEREF9EHUGo1P0000H000?od]805m800ooBdP0CdP;o6M800ooBdP0EdP03omoO01CO00Cogmoo
5ml00olA4@0E4@03oa4A01HA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l01P0000H000?od]805M82oaKB0_lGdP;o6=800ooOg`0Dg`04omoOoaOO06Co4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUER
EF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUGo1P0000H000?od]805m800ooBdP0CdP;o
6M800ooBdP0EdP03omoO01CO00Cogmoo5ml00olA4@0E4@03oa4A01HA03?oOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP?n0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]805=83oaKB0_lFdP?o
6=800ooOg`0Eg`;o6=l05olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O00;o030AGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0IHUEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooO
g`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B
00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooB
dP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA
03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H0
00?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooO
g`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B
00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooB
dP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l01P0000H000?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA
03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H0
00?od]80;M82oc7B00?ogml0;ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EOl600001P000ooBdP0]dP;o<M800ooOg`0_g`03oa4A02hA03?oOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l01P0000H0nOl600001P00<?mnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03:0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oc7B00?ogml0;]l00olA4@0_4@03o`0000@00006000`
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0<V9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<M800ooOg`0^g`0coelAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo00H00006000`ogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o<M800ooOg`0^g`03oa4A02lA00?o0000
100000H0033oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0b
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_ladP03omoO02kO
03?oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol01P0000H0
033oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0bP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?ladP03omoO02kO00?o4A40
;a400ol0000400001P00<?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUERE@;o039REF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoc7B
00?ogml0;]l0<omO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
o`0600001P00<?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o
03:0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oc7B00?ogml0
;]l00olA4@0_4@03o`0000@00006000`oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9E0_l0<V9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o<M800ooOg`0^g`0coelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4Eoo00H00006000`ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o
<M800ooOg`0^g`03oa4A02lA00?o0000100000H0033oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUD2o`0bHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EH_ladP03omoO02kO03?oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGol01P0000H0033oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7h2o`0bP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP?ladP03omoO02kO00?o4A40;a400ol0000400001P00<?mEHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o039REF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUERoc7B00?ogml0;]l0<omO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0600001P00<?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03:0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0oc7B00?ogml0;]l00olA4@0_4@03o`0000@00006000`oeEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0<V9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<M800ooOg`0^g`0coelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo00H00006000`ogj0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o<M800ooOg`0^g`03oa4A02lA00?o0000100000H0033oEF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0bHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_ladP03omoO02kO03?oGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol01P0000H0033oOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0bP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?ladP03omoO02kO00?o4A40;a400ol000040000
1P00<?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o039REF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoc7B00?ogml0;]l0<omO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0600001P00<?mn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03:0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oc7B00?ogml0;]l00olA4@0_4@03
o`0000@00006000`oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
0_l0<V9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<M800ooO
g`0^g`0coelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo00H0
0006000`ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0<X1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o<M800ooOg`0^g`03
oa4A02lA00?o0000100000H0033oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUD2o`0bHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
H_ladP03omoO02kO03?oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGol01P0000H001OoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP004o`0EOX1nP7j0OX1nP7j0OX1nP7j0
OX1n00;o01J0OX1nP7j0OX1nP7j0OX1nP7j0OX1n1?l0681nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oaKB
0olHdP03omoO01GO0_lGg`03oa4A01@A0olH4@03o`0000@00006000`oeEREF9EHUEREF9EHUEREF9E
HUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0<V9EHUEREF9EHUEREF9EHUEREF9EHUERof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;o6M800ooBdP0EdP03omoO01CO00Cogmoo5]l0<omO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0600001P00<?mnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03:0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oaWB00?od]805M800ooOg`0Dg`04omoOoaKO
00?o4A405A400olA4@0G4@03o`0000@00006000`oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9E
HUEREF9EHUEREF9EHUEREF9E0_l0<V9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9E
HUEREF9EHUEREF;o5m82oaSB00?ogml05=l01?oOgolFg`0coelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo00H00006000`ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX3o
P7koOX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX3oP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3o6M800ooBdP0EdP03omoO01CO00Cogmoo5]l00olA4@0E4@03oa4A01LA
00?o0000100000H001SoEF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0FHUEREF9EHUEREF9EHUEREF9E
HUERE@;o01MREF9EHUEREF9EHUEREF9EHUEREF9EHP02o`0IEF9EHUEREF9EHUEREF9EHUEREF9EHUER
o`0FdP?o6=800ooOg`0Eg`;o5ml05omO4ElAGa5O4ElAGa5O4ElAGa5O4ElA00;o01YO4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5Oo`H00006000`ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX3o<M800ooOg`0^g`03oa4A02lA00?o0000100000H0033oEF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0bHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EH_ladP03omoO02kO03?oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol01P0000H0033oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0bP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP?ladP03omoO02kO00?o4A40;a400ol0000400001P00<?mEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o039REF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoc7B00?ogml0;]l0<omO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0600001P00<?mnP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03:0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0oc7B00?ogml0;]l00olA4@0_4@03o`0000@00006000`oeEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0<V9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<M800ooOg`0^g`0coelAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo00H00006000`ogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o<M800ooOg`0^g`03oa4A02lA00?o0000100000H0
033oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0bHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_ladP03omoO02kO03?oGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol01P0000H0033oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0bP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?ladP03omoO02kO00?o4A40;a400ol0
000400001P00<?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERE@;o
039REF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoc7B00?ogml0
;]l0<omO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`060000
1P00<?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP;o03:0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oc7B00?ogml0;]l00olA
4@0_4@03o`0000@00006000`oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9E0_l0<V9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o
<M800ooOg`0^g`0coelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4Eoo00H00006000`ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o<M800ooO
g`0^g`03oa4A02lA00?o0000100000H0033oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUD2o`0bHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EH_ladP03omoO02kO03?oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGol01P0000H0033oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7h2o`0bP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P?ladP03omoO02kO00?o4A40;a400ol0000400001P00<?mEHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUERE@;o039REF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUERoc7B00?ogml0;]l0<omO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5Oo`0600001P00<?mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OP;o03:0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0oc7B00?ogml0;]l00olA4@0_4@03o`0000@00006000`oeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E0_l0<V9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;o<M800ooOg`0^g`0coelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo00H00006000`ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n0_l0<X1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX3o<M800ooOg`0^g`03oa4A02lA00?o0000100000H0033oEF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUD2o`0bHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_ladP03omoO02kO03?oGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol01P0000H0033oOX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7h2o`0bP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?ladP03omoO02kO00?o4A40;a400ol0000400001P3io`H0
00060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA
0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B
00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooO
g`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0
000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o
06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@0
00060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA
0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B
00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooO
g`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0
000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o
06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@0
00060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A01@A0olF4@;o5Q43oaPA01OoP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OP04o`0HP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o5]83oaOB00?ogml05Ml2oaSO
00?o0000100000H0033oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4El2o`1T4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9E
HUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUERoaWB00?od]805=800ooO
g`0Dg`04omoOoaOO00?o0000100000H000?o4A405A400olA4@0E4@;o5a400olA4@0G4@0coh1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o01WB00?od]805=800ooO
g`0Dg`04omoOoaOO00?o0000100000H0033oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4El2o`1T4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUERoaOB
0_lGdP03omoO01CO00Cogmoo5ml00ol0000400001P000olA4@0E4@03oa4A01DA0_lG4@03oa4A01LA
03?oP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l06M800ooB
dP0DdP03omoO01CO00Cogmoo5ml00ol0000400001P005omO4ElAGa5O4ElAGa5O4ElAGa5O4ElA00;o
01MO4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`02o`0F4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o034AGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUER00;o01UEHUEREF9EHUER
EF9EHUEREF9EHUEREF;o01KB0olGdP03omoO01GO0_lHg`03o`0000@000060003oa4A02dA0_la4@0c
oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0
;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03
o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol000040000
1P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003
oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o
<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0c
oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0
;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03
o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol000040000
1P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060003
oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o
<=800ooOg`0_g`03o`0000@000060003oa4A02dA0_la4@0coh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o033B00?ogml0;ml00ol0000400001P00<?mO4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`;o06@AGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF;o<=800ooOg`0_g`03o`0000@000060?Wo1P0000H000?ogml0
;Ml2oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmR
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol000040000
1P000ooOg`0]g`;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003omoO02gO0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H000?ogml0;Ml2oc7O00?o4A40;a40<_n0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol000040000
1P000ooOg`0]g`;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03
o`0000@000060003omoO02gO0_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?ogml0;Ml2oc7O06Co4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0000400001P000ooOg`0]g`;o<Ml00olA
4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03
o`0000@000060003omoO02gO0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9Eoc7B00?o0000100000H000?ogml0;Ml2oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol0000400001P000ooOg`0]g`;o<Ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003omoO02gO
0_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1noc7B00?o0000100000H000?ogml0;Ml2oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUGo<M800ol0000400001P000ooOg`0]g`;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003omoO02gO
0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H0
00?ogml0;Ml2oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7ko<M800ol0000400001P000ooOg`0]g`;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003omoO02gO0_lag`03oa4A02lA03;oP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H0
00?ogml0;Ml2oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0
000400001P000ooOg`0]g`;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003omoO02gO0_lag`1Toa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H000?ogml0;Ml2oc7O00?o4A40
;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol0
000400001P000ooOg`0Eg`;o5]l2oaOO0_lHg`0Goa5O4ElAGa5O4ElAGa5O4ElAGa5O4El00ol0;elA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9E00Co01MREF9EHUEREF9E
HUEREF9EHUEREF9Eo`0FdP?o6=800ol0000400001P000ooOg`0Dg`04omoOoaGO0_lFg`04omoOoaOO
00?o4A405A400olA4@0G4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0O_lIdP03om;B01GB00?o0000100000H000?ogml05=l01?oOgolEg`;o5]l01?oOgolGg`1T
oa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUER
EF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EoaWB00?od]805M800ol000040000
1P000ooOg`0Dg`04omoOoaGO0_lFg`04omoOoaOO00?o4A405A400olA4@0G4@0boh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_lGdP;o6=800ol0000400001P000ooO
g`0Dg`04omoOoaGO0_lFg`04omoOoaOO06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EoeERof9EHUEREF9EHUEREF9EHUER
EF9EHUGo6M800ooBdP0EdP03o`0000@000060003omoO01GO0_lFg`;o5ml2oaSO00?o4A405142oaTA
01SoP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX02o`0HOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko5]83oaSB
00?o0000100000H000?ogml0;Ml2oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUGo<M800ol0000400001P000ooOg`0]g`;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003omoO02gO0_lag`1T
oa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H000?ogml0
;Ml2oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7ko<M800ol0000400001P000ooOg`0]g`;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREOladP03o`0000@000060003omoO02gO0_lag`03oa4A02lA03;oP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?ogml0
;Ml2oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmR
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol000040000
1P000ooOg`0]g`;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003omoO02gO0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H000?ogml0;Ml2oc7O00?o4A40;a40<_n0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol000040000
1P000ooOg`0]g`;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03
o`0000@000060003omoO02gO0_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?ogml0;Ml2oc7O06Co4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0000400001P000ooOg`0]g`;o<Ml00olA
4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03
o`0000@000060003omoO02gO0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9Eoc7B00?o0000100000H000?ogml0;Ml2oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol0000400001P000ooOg`0]g`;o<Ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003omoO02gO
0_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1noc7B00?o0000100000H000?ogml0;Ml2oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUGo<M800ol0000400001P000ooOg`0]g`;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003omoO02gO
0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000D0
n_l600001@3jo`H000060003o`0002d00_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?o0000;003oc7O06Co4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0000400001P000ol0000[0004
o`3ooc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7ko<M800ol0000400001P000ol0000Z0003o`0000;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003o`0002T000Co00000_lag`03oa4A02lA
03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000
100000H000?o0000:0000ol0000200;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREOladP03o`0000@000060003o`0002L000?o00000`02oc7O00?o4A40;a40<_n0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol0000400001P000ol0
000V0003o`0000@00_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B
00?o0000100000H000?o00009@000ol0000500;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003o`0002@000?o0000
1P02oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmR
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol000040000
1P000ol0000S0003o`0000L00_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?o00008P000ol0000800;o<Ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003o`0000/0
0_l00`3oo`0A0003o`0000T00_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?o000030000ol0o`0A0003o`0000X0
0_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H0
00?o00003@000ol0000?0003o`0000/00_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?o000030000ol0o`0?0003
o`0000`00_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000
100000H000?o00002`02o`030?oo00d000?o00003@02oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko<M800ol0000400001P000ol0000L0003
o`0000h00_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000
100000H000?o00006`000ol0000?00;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003o`0001X000?o00004002oc7O
06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0000400001P000ol0
000I0003o`0001400_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?o000060000ol0000B00;o5ml2oaSO01Oo4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAG`03o`0_Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUER
EF9EHUEREF9EHUD01?l05f9EHUEREF9EHUEREF9EHUEREF9EHUGo01KB0olHdP03o`0000@000060003
o`0001L000?o00004`02oaKO00Cogmoo5ml00olA4@0E4@03oa4A01LA03;oP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noaWB00?od]805M800ol0000400001P000ol0
000F0003o`0001@00_lFg`04omoOoaOO06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUER
EF9EHUGo6M800ooBdP0EdP03o`0000@000060003o`0001D000?o00005@02oaKO00Cogmoo5ml00olA
4@0E4@03oa4A01LA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0
OX1noaOB0_lHdP03o`0000@000060003o`0001@000?o00005P02oaKO00Cogmoo5ml0I?lAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF9EHUER
EF9EHUGoEF;oHUEREF9EHUEREF9EHUEREF9EHUEREOlIdP03om;B01GB00?o0000100000H000?o0000
4`000ol0000G00;o5ml2oaSO00?o4A405142oaTA01SoP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX02o`0H
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko5]83oaSB00?o0000100000H000?o00004P000ol0000H00;o
<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003
o`00014000?o00006@02oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7ko<M800ol0000400001P000ol0000@0003o`0000`00ol;00;o<Ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003o`0000l0
00?o00003P000ol0000:00;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003o`0000h000?o000040000ol0000900;o
<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003
o`0000d000?o00004@000ol0000900;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003o`0000`000?o00004@000ol0
o`0:00;o<Ml0I?lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
of9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@0
00060003o`0000/000?o00004P000ol0o`0:00;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003o`0000X000?o0000
4P02o`030?oo00T00_lag`1Toa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B
00?o0000100000H000?o00002@000ol0000Q00;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@000060003o`0000P000?o0000
8P02oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmR
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol000040000
1P000ol000070003o`0002<00_lag`03oa4A02lA03;oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H000?o00001P000ol0000T00;o<Ml0I?lA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOladP03o`0000@000060003o`0000D0
00?o00009@02oc7O00?o4A40;a40<_n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7ko<M800ol0000400001P000ol000040003o`0002H00_lag`1Toa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eoc7B00?o0000100000H000?o00000`000ol0000W00;o
<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
O_ladP03o`0000@000060003o`00008000?o0000:002oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUGo<M800ol0000400001P001Ol0003o02/00_lag`03oa4A02lA03;oP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noc7B00?o0000100000H0
00Co003o;002oc7O06Co4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0
000400001P000ol0o`0]00;o<Ml00olA4@0_4@0boh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0O_ladP03o`0000@0000600;o;P02oc7O06Co4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUGo<M800ol0000400001P3io`H0000f00;oc@000?l01P000?l0
1P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P0000h00_l:00;ofP03o``0
000>0003o`0000X000?o0000f@000ol0000;00001`04o`<000?o00000`03o`@000?o0000`002o`03
0?oo00X000?o000020000ol0000:000020000ol0o`030003o`0000@000?o00000`000ol000310003
o`3o00/000?o000020000ol0000:000020000ol000030003o`0000801?l40003o`000<8000?o0000
2005o`L000?o0?l02`0000T000?o00000P000ol000020003o`3o00D000?o0000`@000ol0o`0;0003
o`0000L000?o0?l02`0000L000?o0?l010000ol000020003o`3o00D000?o0000`002o`030?oo00X0
00?o00001P02o`030?oo00X0000700Co0`02o`@00_l400;oj@000?l01P000?l01P000?l01P000001
\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "Putting the two graphics side by side adds great insight into the nature \
of the quotient group. (The first image was initially inspired by Ladnor \
Geissinger\[CloseCurlyQuote]s work in his pioneering program ",
  StyleBox["Exploring Small Groups",
    FontSlant->"Italic"],
  ".)"
}], "MathCaption",
  CellTags->{"Quotients", "i:23"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[GraphicsArray[{gr1, \ gr2}]]; \)\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"Quotients"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50265 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119678 0.47619 [
[ 0 0 0 0 ]
[ 1 .50265 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .50265 L
0 .50265 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119678 0.477324 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
1 .5 0 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.56 .37 .6 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 0 1 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
1 .5 0 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.56 .37 .6 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 0 1 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
1 .5 0 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.56 .37 .6 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 0 1 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(0)] .18254 .81878 0 0 Mshowa
[(4)] .28836 .81878 0 0 Mshowa
[(1)] .39418 .81878 0 0 Mshowa
[(5)] .5 .81878 0 0 Mshowa
[(2)] .60582 .81878 0 0 Mshowa
[(6)] .71164 .81878 0 0 Mshowa
[(3)] .81746 .81878 0 0 Mshowa
[(7)] .92328 .81878 0 0 Mshowa
[(4)] .18254 .71296 0 0 Mshowa
[(0)] .28836 .71296 0 0 Mshowa
[(5)] .39418 .71296 0 0 Mshowa
[(1)] .5 .71296 0 0 Mshowa
[(6)] .60582 .71296 0 0 Mshowa
[(2)] .71164 .71296 0 0 Mshowa
[(7)] .81746 .71296 0 0 Mshowa
[(3)] .92328 .71296 0 0 Mshowa
[(1)] .18254 .60714 0 0 Mshowa
[(5)] .28836 .60714 0 0 Mshowa
[(2)] .39418 .60714 0 0 Mshowa
[(6)] .5 .60714 0 0 Mshowa
[(3)] .60582 .60714 0 0 Mshowa
[(7)] .71164 .60714 0 0 Mshowa
[(4)] .81746 .60714 0 0 Mshowa
[(0)] .92328 .60714 0 0 Mshowa
[(5)] .18254 .50132 0 0 Mshowa
[(1)] .28836 .50132 0 0 Mshowa
[(6)] .39418 .50132 0 0 Mshowa
[(2)] .5 .50132 0 0 Mshowa
[(7)] .60582 .50132 0 0 Mshowa
[(3)] .71164 .50132 0 0 Mshowa
[(0)] .81746 .50132 0 0 Mshowa
[(4)] .92328 .50132 0 0 Mshowa
[(2)] .18254 .3955 0 0 Mshowa
[(6)] .28836 .3955 0 0 Mshowa
[(3)] .39418 .3955 0 0 Mshowa
[(7)] .5 .3955 0 0 Mshowa
[(4)] .60582 .3955 0 0 Mshowa
[(0)] .71164 .3955 0 0 Mshowa
[(5)] .81746 .3955 0 0 Mshowa
[(1)] .92328 .3955 0 0 Mshowa
[(6)] .18254 .28968 0 0 Mshowa
[(2)] .28836 .28968 0 0 Mshowa
[(7)] .39418 .28968 0 0 Mshowa
[(3)] .5 .28968 0 0 Mshowa
[(0)] .60582 .28968 0 0 Mshowa
[(4)] .71164 .28968 0 0 Mshowa
[(1)] .81746 .28968 0 0 Mshowa
[(5)] .92328 .28968 0 0 Mshowa
[(3)] .18254 .18386 0 0 Mshowa
[(7)] .28836 .18386 0 0 Mshowa
[(4)] .39418 .18386 0 0 Mshowa
[(0)] .5 .18386 0 0 Mshowa
[(5)] .60582 .18386 0 0 Mshowa
[(1)] .71164 .18386 0 0 Mshowa
[(6)] .81746 .18386 0 0 Mshowa
[(2)] .92328 .18386 0 0 Mshowa
[(7)] .18254 .07804 0 0 Mshowa
[(3)] .28836 .07804 0 0 Mshowa
[(0)] .39418 .07804 0 0 Mshowa
[(4)] .5 .07804 0 0 Mshowa
[(1)] .60582 .07804 0 0 Mshowa
[(5)] .71164 .07804 0 0 Mshowa
[(2)] .81746 .07804 0 0 Mshowa
[(6)] .92328 .07804 0 0 Mshowa
[(0)] .07672 .81878 0 0 Mshowa
[(4)] .07672 .71296 0 0 Mshowa
[(1)] .07672 .60714 0 0 Mshowa
[(5)] .07672 .50132 0 0 Mshowa
[(2)] .07672 .3955 0 0 Mshowa
[(6)] .07672 .28968 0 0 Mshowa
[(3)] .07672 .18386 0 0 Mshowa
[(7)] .07672 .07804 0 0 Mshowa
[(0)] .18254 .9246 0 0 Mshowa
[(4)] .28836 .9246 0 0 Mshowa
[(1)] .39418 .9246 0 0 Mshowa
[(5)] .5 .9246 0 0 Mshowa
[(2)] .60582 .9246 0 0 Mshowa
[(6)] .71164 .9246 0 0 Mshowa
[(3)] .81746 .9246 0 0 Mshowa
[(7)] .92328 .9246 0 0 Mshowa
[(Z[8])] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119678 0.97619 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(0)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(2)] .69048 .69286 0 0 Mshowa
[(3)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(2)] .5 .50238 0 0 Mshowa
[(3)] .69048 .50238 0 0 Mshowa
[(0)] .88095 .50238 0 0 Mshowa
[(2)] .30952 .3119 0 0 Mshowa
[(3)] .5 .3119 0 0 Mshowa
[(0)] .69048 .3119 0 0 Mshowa
[(1)] .88095 .3119 0 0 Mshowa
[(3)] .30952 .12143 0 0 Mshowa
[(0)] .5 .12143 0 0 Mshowa
[(1)] .69048 .12143 0 0 Mshowa
[(2)] .88095 .12143 0 0 Mshowa
[(0)] .11905 .69286 0 0 Mshowa
[(1)] .11905 .50238 0 0 Mshowa
[(2)] .11905 .3119 0 0 Mshowa
[(3)] .11905 .12143 0 0 Mshowa
[(0)] .30952 .88333 0 0 Mshowa
[(1)] .5 .88333 0 0 Mshowa
[(2)] .69048 .88333 0 0 Mshowa
[(3)] .88095 .88333 0 0 Mshowa
[(Z[4])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[47]:=",
  ImageSize->{288, 144.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0000X0O?lE07So3@0000X000?od]802]82o`cB00?od]802m800ooOg`0;g`03omoO00_O
03Oo4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREOmEHUEREF9EHUEREF;o01D0
00?od]805=82oaKB00?ogml05Ml0<OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9E
HUEREF9EHUEREOl03@0000X000?od]802]82o`cB00?od]802m800ooOg`0;g`03omoO00_O00?o4A40
2Q400olA4@0;4@0Logj0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0oaD000?od]805=82oaKB00?ogml0
5Ml00olA4@0E4@0Iogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0=00002P000ooBdP0:dP;o3=800ooB
dP0;dP03omoO00_O00?ogml02ml0=olAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGomEHUEREF9EHUER
EF9EoeEREF9EHUEREF9EH_l05@000ooBdP0DdP;o5]800ooOg`0Eg`0aoelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0=00002P000ooBdP0:dP;o3=800ooBdP0;dP03
omoO00_O00?ogml02ml00olA4@0:4@03oa4A00/A01coOX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX3o
5@000ooBdP0DdP;o5]800ooOg`0Eg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko00d0
000:0003om;B00?B00?od]801=82o`CB00?od]801M800ooBdP02dP?o1]800ooOg`03g`;o1]l00ooO
g`03g`?o1Ml01?lAGa43o`0;4ElAGa5OoelAGa400ol02a5O4ElAGomEHUER00Co00]EHUEREOmEHUER
E@02o`06HUEREF;o5@000ooBdP0DdP;o5]800ooOg`0Eg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0=00002P000ooBdP03dP03om;B00CB0_l4dP03om;B00GB
00?od]801M800ooBdP03dP03omoO00;O00Cogmoo1Ml00ooOg`04g`03omoO00CO00?o4A400Q400olA
4@054@03oa4A00DA00?o4A400a407?mnP7j0O_mnP7j0OX1nogj0OX3oP7koOX1nP?lE0003om;B01CB
0_lFdP03omoO01GO00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l03@0000X000?od]80
1=800ooBdP03dP;o1M800ooBdP04dP03om;B00GB00?od]800m800ooOg`02g`04omoOo`GO00?ogml0
0]l4o`GO03Oo4ElAGomO4ElAGa5OoelAGa5O4EooGa5O4EooEF9EHUERof9EHUEREOmEHUERof9EoeER
EF;o01D000?od]805=82oaKB00?ogml05Ml0<OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9E
HUEREF9EHUEREF9EHUEREOl03@0000X000?od]801=800ooBdP03dP;o1M800ooBdP04dP03om;B00?B
0_l6dP03omoO00;O00Cogmoo1Ml00ooOg`02g`03omoo00KO00?o4A400Q400olA4@054@03oa4A008A
0ol64@0Cogj0OX1nP7koOX1nP7koOX1nP003o`06P7j0OX3o5@000ooBdP0DdP;o5]800ooOg`0Eg`03
oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko00d0000:0003om;B00GB00?od]800]82o`KB
00?od]800m800ooBdP05dP03om;B00?B00?ogml00]l01?oOgol5g`03omoO00;O00?ogol01]l0=olA
Ga5OoelAGa5O4EooGa5O4OlAGa5O4ElAGomEHUERof9EoeEREF9EoeEREF;oHUEREF9EH_l05@000ooB
dP0DdP;o5]800ooOg`0Eg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9E
HUEREF9Eo`0=00002P000ooBdP02dPCo1=82o`?B1?l5dP03om;B00;B0ol6dP03omoO00?O0_l6g`03
omoO00?O0_l6g`04oa4A4@;o1a400olA4@024@Co1A401_mnP7j0OP;o00b0OX1nP7koOX1nP7h3o`05
OX1nP?l05@000ooBdP07dP?o2]82o`WB0ol:dP03omoO00SO0_l;g`03oa4A00LA0ol;4@0:ogj0OX1n
P7j0OPCo00^0OX1nP7j0OX1no`0=00002P000ooBdP0:dP;o3=800ooBdP0;dP03omoO00_O00?ogml0
2ml0=olAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EoeEREF9EHUEREF9EH_l0
5@000ooBdP0:dP03om;B00OB0_l<dP03om;B00OB00?ogml01ml01?oOgol:g`0aoelAGa5O4ElAGa7o
4ElAGa5O4ElAGa5OoeEREF9EHUEREF;oHUEREF9EHUEREF9Eo`0=00002P000ooBdP0:dP;o3=800ooB
dP0;dP03omoO00_O00?ogml02ml00olA4@0:4@03oa4A00/A01coOX1nP7j0OX1nP7j0O_mnP7j0OX1n
P7j0OX3o5@000ooBdP0:dP03om;B00OB0_l<dP03om;B00OB00?ogml01ml01?oOgol:g`03oa4A00PA
00?o4A402Q406OmnP7j0OX1nP7j0O_mnP7j0OX1nP7j0O_l03@0000X000?od]802]82o`cB00?od]80
2m800ooOg`0;g`03omoO00_O03Oo4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4EooEF9EHUEREF9EHUER
EOmEHUEREF9EHUEREF;o01D000?od]802=82o`[B0_l:dP;o2]800ooOg`07g`04omoOo`[O037oGa5O
4ElAGa5O4OlAGa5O4ElAGa5O4EooEF9EHUEREF9EHUERof9EHUEREF9EHUGo00d0000:07co5@000ooB
dP0:dP03om;B00OB0_l<dP03om;B00OB00?ogml01ml01?oOgol:g`03oa4A00PA00?o4A402Q406Omn
P7j0OX1nP7koOX3oP7j0OX1nP7j0O_l03@0000X000?od]802]82o`cB00?od]802m800ooOg`0;g`03
omoO00_O03Oo4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREOmEHUEREF9EHUER
EF;o01D000?od]801m83o`[B0_l9dP?o2]800ooOg`08g`;o2ml02_mO4ElAGa5O4El2o`0G4ElAGa5O
4ElAGa5OoeEREF9EHUEREF800_l035EREF9EHUEREF9Eo`d0000:0003om;B00[B0_l<dP03om;B00_B
00?ogml02ml00ooOg`0;g`03oa4A00XA00?o4A402a407?mnP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1n
P?lE0003om;B01CB0_lFdP03omoO01GO00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l0
3@0000X000?od]802]82o`cB00?od]802m800ooOg`0;g`03omoO00_O03Oo4ElAGa5O4ElAGa5OoelA
Ga5O4ElAGa5O4EooEF9EHUEREF9EHUEREOmEHUEREF9EHUEREF;o01D000?od]805=82oaKB00?ogml0
5Ml0<OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREOl03@0000X0
00?od]802]82o`cB00?od]802m800ooOg`0;g`03omoO00_O00?o4A402Q400olA4@0;4@0Logj0OX1n
P7j0OX1nP7koOX1nP7j0OX1nP7j0oaD000?od]805=82oaKB00?ogml05Ml00olA4@0E4@0Iogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1no`0=00002P000ooBdP02dP?o1M82o`?B0ol6dP03om;B00?B00?od]80
1M800ooOg`03g`?o1Ml00ooOg`03g`;o1]l01?lAGa43o`0;4ElAGa5OoelAGa400ol0315O4ElAGomE
HUERE@;o00]REF9EHUGoEF9EHP04o`05EF9EH_l05@000ooBdP0DdP;o5]800ooOg`0Eg`0aoelAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0=00002P000ooBdP05dP03
om;B00;B0_l6dP03om;B00?B00?od]800m800ooBdP05dP03omoO00CO00?ogml01=l00ooOg`02g`04
omoOo`GO00?o4A4011400olA4@034@03oa4A00<A00?o4A401A407?mnP7j0oh1nogj0OX1nogj0OX1n
ogj0OX1nP?lE0003om;B01CB0_lFdP03omoO01GO00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1n
P7j0O_l03@0000X000?od]801M800ooBdP02dP;o1]800ooBdP03dP03om;B00CB00?od]801=800ooO
g`02g`Co1Ml00ooOg`02g`04omoOo`GO03Oo4ElAGa5OoelAGa5OoelAGa5OoelAGa5O4EooEF9EH_mR
EOmEHUEREOmEHUEREF;oHUEREF;o01D000?od]805=82oaKB00?ogml05Ml0<OmO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREOl03@0000X000?od]800m82o`GB0_l4dP;o
1]800ooBdP04dP03om;B00CB00?ogml00]l00ooOo`06g`03omoO00;O00Cogmoo1Ml01?lA4A43o`HA
00?o4A400a400olA4@054@05ogj0OX000ol0581nP7j0O_mnP7j0OX1nogj0OX3o5@000ooBdP0DdP;o
5]800ooOg`0Eg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko00d0000:0003om;B00GB
00?od]800]82o`KB00?od]800m800ooBdP05dP03om;B00?B00?ogml00]l00ooOo`06g`03omoO00;O
00Cogmoo1Ml0=olAGa7o4ElAGa5O4EooGa5O4EooGa5O4ElAGomEHUERof9EHUEREF9EoeEREF;oHUGo
EF9EH_l05@000ooBdP0DdP;o5]800ooOg`0Eg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9E
HUEREF9EHUEREF9EHUEREF9Eo`0=00002P000ooBdP02dP?o1M82o`?B0ol6dP03om;B00;B1?l5dP03
omoO00?O0_l6g`03omoO00?O0_l6g`04oa4A4@Co1A400olA4@024@;o1a401_mnP7j0OP?o00]nP7j0
O_mnP7j0OP02o`06P7j0OX3o5@1ho`d0000:0003om;B00[B0_l<dP03om;B00_B00?ogml02ml00ooO
g`0;g`0goa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUGoEF9EHUEREF9EHUER
o`0E000Gof9EHUEREF9EHUEREF9EHUEREF9EHUD00_l05f9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB
00?ogml05Ml06OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol03@0000X000?od]802]82o`cB00?od]80
2m800ooOg`0;g`03omoO00_O00?o4A402Q400olA4@0;4@0Logj0OX1nP7j0OX1nP7koOX1nP7j0OX1n
P7j0oaD001OoP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP02o`0GP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l0
5m800ooOg`0Eg`03oa4A01DA00?o00002`0000X000?od]802]82o`cB00?od]802m800ooOg`0;g`03
omoO00_O03Oo4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREOmEHUEREF9EHUER
EF;o01D001OoHUEREF9EHUEREF9EHUEREF9EHUERE@02o`0GHUEREF9EHUEREF9EHUEREF9EHUEREOl0
5m800ooOg`0Eg`0IoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0=00002P1loaD001OoP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OP02o`0GP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ooOg`0Eg`03oa4A01DA
00?o00002`0000X000goEF9EHUEREF9EHUER00;o01]EHUEREF9EHUEREF;oHUEREF9EHUEREF9EH_l0
3M800ooBdP0;dP03omoO00[O00?ogml02ml07?mO4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4OlE000G
of9EHUEREF9EHUEREF9EHUEREF9EHUD00_l05f9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?ogml0
5Ml06OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol03@0000X000goOX1nP7j0OX1nP7j000;o01]nP7j0
OX1nP7j0OX3oP7j0OX1nP7j0OX1nP?l03M800ooBdP0;dP03omoO00[O00?ogml02ml00olA4@0;4@03
oa4A00XA00?o00004`005on0OX1nP7j0OX1nP7j0OX1nP7j0OX1n00;o01N0OX1nP7j0OX1nP7j0OX1n
P7j0OX1no`0GdP03omoO01GO00?o4A405A400ol0000;00002P003OmEHUEREF9EHUEREF800_l06eER
EF9EHUEREF9EH_mREF9EHUEREF9EHUERo`0=dP03om;B00_B00?ogml02]l00ooOg`0;g`0LoelAGa5O
4ElAGa5O4EooGa5O4ElAGa5O4ElAoaD001OoHUEREF9EHUEREF9EHUEREF9EHUERE@02o`0GHUEREF9E
HUEREF9EHUEREF9EHUEREOl05m800ooOg`0Eg`0IoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0=0000
2P003OmnP7j0OX1nP7j0OX000_l06gj0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0o`0=dP03om;B00_B
00?ogml02]l00ooOg`0;g`03oa4A00/A00?o4A402Q400ol0000C000Goh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7h00_l05h1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?ogml05Ml00olA4@0E4@03o`0000/0
000:0006oeEREF9E0_l01F9EHUER00;o00AEHUER0_l02eEREF9EH_mREF9E00Co00IREF9EH_l5dP03
om;B00GB00?od]800]83o`KB00?ogml00]l2o`KO00?ogml00ml3o`GO00GoGa5O4@03o`0;4ElAGa5O
oelAGa400ol01Q5O4ElAoaD001OoHUEREF9EHUEREF9EHUEREF9EHUERE@02o`0GHUEREF9EHUEREF9E
HUEREF9EHUEREOl05m800ooOg`0Eg`0IoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oo`0=00002P003Omn
P7j0oh1nogj0OX000_l06gj0O_mnP?n0OX1nP?n0OX1nP?n0OX1nP7j0o`05dP03om;B00GB00?od]80
1M800ooBdP03dP05omoOgol00]l00ooOg`03g`03omoO00CO00?ogml01=l00olA4@034@03oa4A00DA
00?o4A401A400olA4@024@03o`0001<000[oP7j0OX1nP7j01?l02Gj0OX1nP7j0OP02o`09P7j0OX1n
P7j000Co00YnP7j0OX1nP7ko2M83o`_B00?ogml02=l2o`_O00?o4A401a43o`/A00?o00002`0000X0
00goEF9EH_mREOmEHUER00;o01]EHUGoEF;oHUEREF;oHUEREF9EoeEREF9EH_l01]800ooBdP04dP03
om;B00GB00?od]800m801OoOgmoo00;O00?ogml00ml00ooOg`02g`Co1Ml07?mO4ElAGomO4ElAGa5O
oelAGa5O4EooGa5O4OlE000Gof9EHUEREF9EHUGoEF9EHUEREF9EHUD00_l05f9EHUEREF9EHUGoEF9E
HUEREF9EHUGo00cB00?od]802=800ooOg`07g`04omoOo`[O01WoGa5O4ElAGa5O4OlAGa5O4ElAGa5O
4Eoo00d0000:0005ogj0OX000ol01H1nP7j000;o00=nP7h00ol05Gj0OX1nP?n0OX1nP7j0oh1nP7j0
o`06dP03om;B00CB00?od]800m82o`KB00GogmoOo`02g`03omoO00?O00?ogml00]l00ooOo`06g`03
oa4A00<A00?o4A401A400olA4@024@?o1A400ol0000C000Goh1nP7j0OX1nP7j0oh1nP7j0OX1nP7h0
0_l05h1nP7j0OX1nP7j0oh1nP7j0OX1nP7ko00cB00?od]802=800ooOg`07g`04omoOo`[O00?o4A40
21400olA4@0:4@03o`0000/0000:000=oeEREF;oHUEREF9EHP02o`0KEF9EoeEREF9EHUERof9EHUGo
EF;oHUEREF;o00OB00?od]800m800ooBdP05dP03om;B00?B00GogmoOo`02g`03omoO00?O00?ogml0
0]l00ooOo`06g`0LoelAGa5OoelAGa5O4EooGa5O4OlAGa5O4ElAoaD001OoHUEREF9EHUEREF9EoeER
EF9EHUERE@02o`0GHUEREF9EHUEREF9EoeEREF9EHUEREOl02]82o`_B00?ogml01ml01?oOgol:g`0I
oelAGa5O4ElAGa7o4ElAGa5O4ElAGa5Oo`0=00002P001_mnP7j0OP?o00AnP7j00_l017j0OX03o`0;
P7j0OX3oP7j0OX000_l01gj0OX1nP?l01=84o`GB00?od]800]83o`KB00?ogml00]l2o`KO00?ogml0
0ml2o`KO00?o4A400Q42o`LA00?o4A400Q44o`@A00?o00004`005on0OX1nP7j0OX3oP7koOX1nP7j0
OX1n00;o01N0OX1nP7j0OX3oP7koOX1nP7j0OX1no`0<dP03om;B00SB00?ogml01ml01?oOgol:g`03
oa4A00PA00?o4A402Q400ol0000;00002P003OmEHUEREF9EHUEREF800_l06eEREF9EHUEREF9EH_mR
EF9EHUEREF9EHUERo`0=dP03om;B00_B00?ogml02]l00ooOg`0;g`0LoelAGa5O4ElAGa5O4EooGa5O
4ElAGa5O4ElAoaD000_oHUEREF9EHUERE@02o`0:HUEREF9EHUERE@;o00YREF9EHUEREF9E0_l02f9E
HUEREF9EHUGo00WB0ol;dP03omoO00SO0_l;g`0:oelAGa5O4ElAG`;o00dAGa5O4ElAGa5O4Eoo00d0
000:000=ogj0OX1nP7j0OX1nP002o`0KOX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX3o00gB00?od]80
2m800ooOg`0:g`03omoO00_O00?o4A402a400olA4@0:4@03o`0001<001OoP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OP02o`0GP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ooOg`0Eg`03oa4A01DA00?o0000
2`0000X000goEF9EHUEREF9EHUER00;o01]EHUEREF9EHUEREF;oHUEREF9EHUEREF9EH_l03M800ooB
dP0;dP03omoO00[O00?ogml02ml07?mO4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4OlE000Gof9EHUER
EF9EHUEREF9EHUEREF9EHUD00_l05f9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?ogml05Ml06OmO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol03@0000X0O?lE000Goh1nP7j0OX1nP7j0OX1nP7j0OX1nP7h0
0_l05h1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?ogml05Ml00olA4@0E4@03o`0000/0000:000=
oeEREF9EHUEREF9EHP02o`0KEF9EHUEREF9EHUERof9EHUEREF9EHUEREF;o00gB00?od]802m800ooO
g`0:g`03omoO00_O01coGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa7o5@005omREF9EHUEREF9EHUER
EF9EHUEREF9E00;o01MREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03omoO01GO01WoGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4Eoo00d0000:000=ogj0OX1nP7j0OX1nP002o`0KOX1nP7j0OX1nP7j0oh1nP7j0
OX1nP7j0OX3o00gB00?od]802m800ooOg`0:g`03omoO00_O00?o4A402a400olA4@0:4@03o`0001<0
01OoP7j0OX1nP7j0OX1nP7j0OX1nP7j0OP02o`0GP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ooO
g`0Eg`03oa4A01DA00?o00002`0000X000goEF9EHUEREF9EHUER00;o01]EHUEREF9EHUEREF;oHUER
EF9EHUEREF9EH_l03M800ooBdP0;dP03omoO00[O00?ogml02ml07?mO4ElAGa5O4ElAGa5OoelAGa5O
4ElAGa5O4OlE000Gof9EHUEREF9EHUEREF9EHUEREF9EHUD00_l05f9EHUEREF9EHUEREF9EHUEREF9E
HUGo01OB00?ogml05Ml06OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGol03@0000X000GoOX1nP004o`04
OX1nP0;o00=nP7h01?l02h1nP7j0oh1nP7j000;o00MnP7j0OX3o00CB0ol6dP03om;B00?B00?od]80
1M800ooOg`02g`?o1Ml00ooOg`03g`;o1]l00olA4@024@?o1Q400olA4@024@?o1A400ol0000C000G
oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7h00_l05h1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?ogml0
5Ml00olA4@0E4@03o`0000/0000:000=oeEREF9EoeEREF9EHP02o`0KEF9EH_mREF9EHUERof9EHUGo
EF;oHUEREF;o00OB00?od]800m800ooBdP03dP03om;B00GB00?ogml00ml00ooOg`04g`03omoO00;O
00Cogmoo1Ml07?mO4ElAGa5OoelAGa5OoelAGa5OoelAGa5O4OlE000Gof9EHUEREF9EHUEREF9EHUER
EF9EHUD00_l05f9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?ogml05Ml06OmO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGol03@0000X000goOX1nP7j0oh1nP7j000;o01]nP7j0O_mnP7j0OX3oP7j0O_mnP?n0
OX1nP?l01m800ooBdP03dP03om;B00CB00?od]801=801?oOgml4o`GO00?ogml00]l01?oOgol5g`03
oa4A00DA00?o4A400a400olA4@034@03oa4A00@A00?o00004`1ho`d0000:000=oeEREF9EHUGoEF9E
HP02o`0AEF9EHUERof9EHUERof9EHUD00ol01eEREF9EH_l01M82o`KB00?od]801=800ooBdP04dP07
omoOgooOo`06g`03omoO00;O00Cogmoo1Ml01OmO4ElA00?o01@AGa5O4EooGa5O4EooGa5O4ElAoaD0
01Oo4ElAGa5O4ElAGa5O4ElAGa5O4ElAG`02o`0_4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9E
HUEREF9EHUEREF9EHUEREOl05m800ooOg`0Eg`03o`0000/0000:000=ogj0OX3oP7koOX1nP002o`0K
OX1nogj0oh1nP7j0oh1nP7koOX1nP7j0OX3o00OB00?od]800m800ooBdP05dP03om;B00?B00OogmoO
omoo00KO00?ogml00]l01?oOgol5g`03oa4A008A00?o4A401Q400olA4@034@03oa4A00@A00?o0000
4`000olA4@0D4@;o5Q406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ooOg`0Eg`03o`0000/0
000:0006oeEREF9E0_l01F9EHUER00;o00AEHUER0_l035EREF9EH_mREF9EHP?o00IREF9EH_l4dP?o
1]800ooBdP02dPCo1M800ooOg`02g`;o1]l00ooOg`03g`;o1]l01OmO4ElA00Co00YO4ElAGomO4ElA
0_l01elAGa5O4Ol05@005olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O00;o02lAGa5O4ElAGa5O4ElAGa5O
4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03omoO01GO00?o00002`0000X000goOX1n
P7j0OX1nP7j000;o01]nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP?l03M800ooBdP0;dP03omoO00[O
00?ogml02ml00olA4@0;4@03oa4A00XA00?o00004`000olA4@0D4@;o5Q406OmnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l05m800ooOg`0Eg`03o`0000/0000:000=oeEREF9EHUEREF9EHP02o`0KEF9EHUER
EF9EHUERof9EHUEREF9EHUEREF;o00gB00?od]802m800ooOg`0:g`03omoO00_O01coGa5O4ElAGa5O
4ElAGomO4ElAGa5O4ElAGa7o5@005olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O00;o02lAGa5O4ElAGa5O
4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03omoO01GO00?o00002`0000X0
00goOX1nP7j0OX1nP7j000;o01]nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP?l03M800ooBdP0;dP03
omoO00[O00?ogml02ml00olA4@0;4@03oa4A00XA00?o00004`000olA4@0D4@;o5Q406OmnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0O_l05m800ooOg`0Eg`03o`0000/0000:07co5@005olAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O00;o02lAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0GdP03omoO01GO00?o00002`0000X000?o4A402Q42o``A00?o4A402a407On0OX1nP7j0OX1nP7j0
oh1nP7j0OX1nP7j0OX3o00cB00?od]802m800ooOg`0;g`03omoO00[O00?o00004`000olA4@0D4@;o
5Q406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ooOg`0Eg`03o`0000/0000:000=oelAGa5O
4ElAGa5O4@02o`0gGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EH_mREF9EHUER
EF9EHUERo`0<dP03om;B00_B00?ogml02ml00ooOg`0:g`03o`0001<001Oo4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAG`02o`0_4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREOl0
5m800ooOg`0Eg`03o`0000/0000:0003oa4A00XA0_l<4@03oa4A00/A01goP7j0OX1nP7j0OX1nP?n0
OX1nP7j0OX1nP7j0o`0<dP03om;B00_B00?ogml02ml00ooOg`0:g`03o`0001<000?o4A401a43o`XA
0_l94@?o2Q402_mnP7j0OX1nP7h4o`0;P7j0OX1nP7j0O_l02M83o`_B00?ogml02=l2o`_O00?o0000
2`0000X000goGa5O4ElAGa5O4ElA00;o03MO4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4OmREF9EHUER
EF9EHUERof9EHUEREF9EHUEREF;o00cB00?od]802m800ooOg`0;g`03omoO00[O00?o00004`005olA
Ga5O4ElAGa5OoelAGa5O4ElAGa5O00;o02lAGa5O4ElAGa5OoelAGa5O4ElAGa5OoeEREF9EHUEREF;o
HUEREF9EHUEREF9Eo`0<dP03om;B00SB00?ogml01ml01?oOgol:g`03o`0000/0000:0003oa4A008A
0ol54@;o0a43o`HA00?o4A400Q43o`HA00KoP7j0OX02o`0;OX1nP7j0oh1nP7h01?l01X1nP7j0o`CB
00?od]801M800ooBdP02dP?o1]800ooOg`03g`;o1]l00ooOg`03g`?o1=l00ol0000C0003oa4A00PA
00?o4A402A42o`XA00?o4A402A406OmnP7j0OX1nP7j0O_mnP7j0OX1nP7j0O_l03=800ooBdP08dP03
omoO00OO00Cogmoo2]l00ol0000;00002P003OmO4ElAGa5OoelAGa400_l0=elAGa5O4OlAGa5O4OlA
Ga5O4OlAGa5O4ElAof9EHUGoEF;oHUEREF;oHUEREF;oHUEREF9EH_l01=800ooBdP05dP03om;B00GB
00?od]800m800ooOg`02g`04omoOo`GO00?ogml01=l00ooOg`03g`03o`0001<001Oo4ElAGa5O4ElA
GomO4ElAGa5O4ElAG`02o`0_4ElAGa5O4ElAGomO4ElAGa5O4ElAGomEHUEREF9EHUEREF;oHUEREF9E
HUEREOl02]82o`_B00?ogml01ml01?oOgol:g`03o`0000/0000:0003oa4A00DA00?o4A400Q42o`HA
00?o4A400a400olA4@034@03oa4A00DA01goP7j0O_mnP?n0OX1nP?n0OX1nP7koOX1nP7j0o`05dP03
om;B00CB00?od]801M800ooBdP03dP03omoO00;O00Cogmoo1Ml00ooOg`02g`Co1=l00ol0000C0003
oa4A00PA00?o4A402A42o`XA00?o4A402A406OmnP7j0OX1nP7koOX3oP7j0OX1nP7j0O_l03=800ooB
dP08dP03omoO00OO00Cogmoo2]l00ol0000;00002P001OmO4ElA00?o00DAGa5O4@02o`03Ga5O00?o
01UO4ElAGa7o4ElAGa7o4ElAGa5O4OmREF9E00?o01EEHUEREF;oHUEREF9EH_mREF9EH_l01M800ooB
dP04dP03om;B00?B0_l6dP03omoO00;O00Cogmoo1Ml00ooOg`02g`03omoo00GO00?o00004`002_lA
Ga5O4ElAGa42o`0;Ga5O4ElAGa5O4El00_l02A5O4ElAGa5O4@02o`0FGa5O4ElAGa5O4EooEF9EHUER
EF9EHP;o00aEHUEREF9EHUEREOl9dP?o2m800ooOg`08g`;o2ml00ol0000;00002P000olA4@024@03
oa4A00DA0_l34@03oa4A00HA00?o4A400a400olA4@054@0Moh1nP7koOX1nP7j0OX3oP7j0O_mnP?n0
OX1nP?l01]800ooBdP03dP03om;B00GB00?od]800m800ooOg`02g`04omoOo`GO00?ogml00]l00ooO
o`05g`03o`0001<000?o4A405142oaHA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?ogml0
5Ml00ol0000;00002P001OmO4ElA00Co00AO4ElA0_l00elAG`04o`0:4ElAGa7o4ElAG`;o00dAGa5O
4ElAof9EHUER00?o00]REF9EH_mREF9EHP02o`07EF9EHUERo`03dPCo1M800ooBdP02dP?o1]800ooO
g`03g`;o1]l00ooOg`03g`;o1Ml00ol0000C000Goa5O4ElAGa5O4ElAGa5O4ElAGa5O4El00_l0;a5O
4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?ogml05Ml00ol0
000;00002P000olA4@0:4@;o31400olA4@0;4@0Moh1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP?l0
3=800ooBdP0;dP03omoO00_O00?ogml02]l00ol0000C0003oa4A01@A0_lF4@0Iogj0OX1nP7j0OX1n
P7j0OX1nP7j0OX1no`0GdP03omoO01GO00?o00002`0000X000goGa5O4ElAGa5O4ElA00;o03MO4ElA
Ga5O4ElAGa7o4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUERof9EHUEREF9EHUEREF;o00cB00?od]80
2m800ooOg`0;g`03omoO00[O00?o00004`005olAGa5O4ElAGa5O4ElAGa5O4ElAGa5O00;o02lAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03omoO01GO00?o0000
2`0000X000?o4A402Q42o``A00?o4A402a407On0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX3o00cB
00?od]802m800ooOg`0;g`03omoO00[O00?o00004`000olA4@0D4@;o5Q406OmnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0O_l05m800ooOg`0Eg`03o`0000/0000:07co5@005olAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O00;o02lAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03
omoO01GO00?o00002`0000X000?o4A402Q42o``A00?o4A402a407On0OX1nP7j0OX1nP7j0oh1nP7j0
OX1nP7j0OX3o00cB00?od]802m800ooOg`0;g`03omoO00[O00?o00004`000olA4@0D4@;o5Q406Omn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ooOg`0Eg`03o`0000/0000:000=oelAGa5O4ElAGa5O
4@02o`0gGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUER
o`0<dP03om;B00_B00?ogml02ml00ooOg`0:g`03o`0001<001Oo4ElAGa5O4ElAGa5O4ElAGa5O4ElA
G`02o`0_4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREOl05m800ooO
g`0Eg`03o`0000/0000:0003oa4A00XA0_l<4@03oa4A00/A01goP7j0OX1nP7j0OX1nP?n0OX1nP7j0
OX1nP7j0o`0<dP03om;B00_B00?ogml02ml00ooOg`0:g`03o`0001<0N?l=00002P003OmO4ElAGa5O
4ElAGa400_l0=elAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREF;oHUEREF9EHUER
EF9EH_l03=800ooBdP0;dP03omoO00_O00?ogml02]l00ol0000C0003omoO01CO0_lFg`0aoelAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03o`0000/0000:0003
oa4A008A0ol54@;o0a43o`HA00?o4A400Q43o`HA00GoP7j0OP04o`0;P7j0OX3oP7j0OX000_l01gj0
OX1nP?l00m83o`KB00?od]800m800ooBdP05dP03omoO00?O0ol5g`03omoO00?O0_l5g`03o`0001<0
00?ogml05=l2oaKO00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ol0000;0000
2P003OmO4ElAGomO4ElAGa400_l0=elAGa7o4ElAGa5O4OlAGa5O4ElAoa5O4ElAof9EHUERof9EHUER
EF;oHUEREOmEH_mREF9EH_l01]800ooBdP03dP03om;B00?B00?od]801M800ooOg`04g`03omoO00CO
00?ogml00]l01?oOgol4g`03o`0001<000?ogml05=l2oaKO037oGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?o00002`0000X000?o4A400a400olA4@044@;o
11400olA4@054@03oa4A00DA00?o4A400a407On0OX1nP7koOX1nP7j0oh1nP7koOX3oP7j0OX3o00KB
00?od]800m800ooBdP04dP03om;B00CB00?ogml00]l4o`GO00?ogml00]l01?oOgol4g`03o`0001<0
00?ogml05=l2oaKO00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ol0000;0000
2P003OmO4ElAGomO4ElAGa400_l04ElAGa7o4ElAGa5O4OlAGa5O00?o01UO4ElAGa7oHUEREF9EH_mR
EF9EH_mREF9E00?o00MEHUEREF;o00CB0_l6dP03om;B00CB00?od]801=800ooOg`02g`03omoo00KO
00?ogml00]l01?oOgol4g`03o`0001<000?ogml05=l2oaKO037oGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?o00002`0000X000?o4A400a400olA4@044@;o
11400olA4@054@03oa4A008A00?o4A401Q407On0OX1nogj0oh1nP7j0oh1nP7koOX1nP7j0OX3o00KB
00?od]800m800ooBdP05dP03om;B00?B00?ogml00]l00ooOo`06g`03omoO00;O00Cogmoo1=l00ol0
000C0003omoO01CO0_lFg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?o0000
2`0000X000GoGa5O4@02o`06Ga5O4ElA0_l00elAG`02o`0<4ElAGa5O4OlAGa5O1?l02a5O4ElAof9E
HUER00;o00aEHUEREF;oHUEREF83o`06HUEREF;o0m83o`KB00?od]800]84o`GB00?ogml00ml2o`KO
00?ogml00ml2o`GO00?o00004`000ooOg`0Dg`;o5]l0<OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomE
HUEREF9EHUEREF9EHUEREF9EHUEREOl05m800ol0000;00002P000olA4@0:4@;o31400olA4@0;4@0M
oh1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP?l03=800ooBdP0;dP03omoO00_O00?ogml02]l00ol0
000C0003omoO01CO0_lFg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?o0000
2`0000X000goGa5O4ElAGa5O4ElA00;o03MO4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4OmREF9EHUER
EF9EHUERof9EHUEREF9EHUEREF;o00cB00?od]802m800ooOg`0;g`03omoO00[O00?o00004`000ooO
g`08g`;o2]l2o`[O0_l:g`0:oelAGa5O4ElAG`?o01EO4ElAGa5O4ElAGomEHUEREF9EHUD01?l02f9E
HUEREF9EHUGo00WB0ol;dP03o`0000/0000:0003oa4A00XA0_l<4@03oa4A00/A01goP7j0OX1nP7j0
OX1nP?n0OX1nP7j0OX1nP7j0o`0<dP03om;B00_B00?ogml02ml00ooOg`0:g`03o`0001<000?ogml0
1ml01?oOgol9g`;o2Ml01?oOgol9g`03oa4A00PA00?o4A402Q406OmnP7j0OX1nP7j0oh1nP7j0OX1n
P7j0O_l03=800ooBdP08dP03o`0000/0000:07co5@000ooOg`07g`04omoOo`WO0_l9g`04omoOo`WO
037oGa5O4ElAGa5O4OlAGa5O4ElAGa5O4EooEF9EHUEREF9EHUGoEF9EHUEREF9EHUGo00cB00?od]80
2=800ol0000;00002P000ooOg`0:g`;o3=l00ooOg`0;g`03oa4A00/A00?o4A402a407?n0OX1nP7j0
OX1nP7koOX1nP7j0OX1nP7j0O_l=dP03om;B00[B00?o00004`000ooOg`07g`04omoOo`WO0_l9g`04
omoOo`WO00?o4A4021400olA4@0:4@0Iogj0OX1nP7j0OX1nP?n0OX1nP7j0OX1no`0:dP;o2m800ol0
000;00002P000ooOg`0:g`;o3=l00ooOg`0;g`0hoa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4OmR
EF9EHUEREF9EHUGoEF9EHUEREF9EHUEREOl=dP03om;B00[B00?o00004`000ooOg`07g`04omoOo`WO
0_l9g`04omoOo`WO037oGa5O4ElAGa5O4OlAGa5O4ElAGa5O4EooEF9EHUEREF9EoeERof9EHUEREF9E
HUGo00cB00?od]802=800ol0000;00002P000ooOg`0:g`;o3=l00ooOg`0;g`03oa4A00/A00?o4A40
2a407?n0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0O_l=dP03om;B00[B00?o00004`000ooOg`08g`;o
2]l2o`[O0_l:g`03oa4A00LA0_l<4@0;ogj0OX1nP7j0OX000_l037j0OX1nP7j0OX1no`WB0ol;dP03
o`0000/0000:0003omoO00[O0_l<g`03omoO00_O03So4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElA
of9EHUEREF9EHUEREOmEHUEREF9EHUEREF9Eo`gB00?od]802]800ol0000C0003omoO01CO0_lFg`0a
oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03o`0000/0
000:0003omoO00?O0ol4g`;o1=l3o`GO00?ogml00ml2o`KO00?o4A400Q43o`HA00?o4A400Q43o`HA
00GoP7j0OP02o`0;P7j0OX1nogj0OX001?l01Wj0OX1no`GB00?od]801M800ooBdP02dP?o1M800ol0
000C0003omoO01CO0_lFg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?o0000
2`0000X000?ogml01=l00ooOg`03g`;o1Ml00ooOg`04g`03omoO00;O00Cogmoo1Ml0>?lAGa5O4ElA
oa5O4ElAoa5O4ElAoa5O4ElAGa7oHUERof9EoeEREF9EoeEREF9EoeEREF9EHUGo1M800ooBdP05dP03
om;B00GB00?od]800]800ol0000C0003omoO01CO0_lFg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03o`0000/0000:0003omoO00;O1?l4g`;o0ml4o`GO
00?ogml00]l01?oOgol5g`03oa4A00DA00?o4A400a400olA4@034@03oa4A00DA01coP7j0oh1nogj0
OX1nogj0OX1nP?n0OX1nP7ko1]800ooBdP04dP03om;B00GB00?od]800]800ol0000C0003omoO01CO
0_lFg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?o00002`0000X000?ogml0
0]l00ooOo`05g`;o0ml00ooOo`06g`03omoO00;O00Cogmoo1Ml01OlAGa5O00?o01QO4ElAGa7o4ElA
Ga7o4ElAGa5O4OmREF83o`0EHUEREF9EoeEREF9EHUGoEF9EHUGo00KB00?od]801=800ooBdP03dP;o
1M800ol0000C0003omoO01CO0_lFg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9E
HUEREF9EHUEREF9Eo`0GdP03o`0000/0000:0003omoO00;O00?ogol01Ml2o`?O00?ogol01]l00ooO
g`02g`04omoOo`GO00?o4A400Q400olA4@064@03oa4A00<A00?o4A401A407?n0OX3oP7j0OX1nP7ko
OX1nP?n0O_mnP7j0O_l7dP03om;B00?B00?od]801M800ooBdP02dP03o`0001<000?ogml05=l2oaKO
00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ol0000;00002P000ooOg`03g`;o
1Ml2o`CO0_l6g`03omoO00?O0_l6g`05oa5O4El01?l02Q5O4ElAoa5O4El2o`0<4ElAGa5O4OmREF9E
0ol02eEREF9EoeEREF9E00;o00MREF9EHUGo00CB1?l5dP03om;B00;B0ol5dP03o`0001<000?ogml0
5=l2oaKO037oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB
00?o00002`0000X000?ogml02]l2o`cO00?ogml02ml00olA4@0;4@03oa4A00/A01coP7j0OX1nP7j0
OX1nogj0OX1nP7j0OX1nP7ko3M800ooBdP0:dP03o`0001<000?ogml05=l2oaKO00?o4A405A406Omn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ol0000;00002P000ooOg`0:g`;o3=l00ooOg`0;g`0h
oa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREOl=dP03
om;B00[B00?o00004P1io`d0000:0003omoO00[O0_l<g`03omoO00_O00?o4A402a400olA4@0;4@0L
oh1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1no`gB00?od]802]800ol0000B07Wo3@0000X0O?lE0003
o`0001<00olFg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9E
o`0GdP03o`0000/0000:0003omoO00[O0_l<g`03omoO00_O00?o4A402a400olA4@0;4@0Loh1nP7j0
OX1nP7j0O_mnP7j0OX1nP7j0OX1no`gB00?od]802]800ol0000C0003o`00018000Co0?oo5]l00olA
4@0E4@0Iogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0GdP03o`0000/0000:0003omoO00[O0_l<g`03
omoO00_O03So4ElAGa5O4ElAGa5O4OlAGa5O4ElAGa5O4ElAof9EHUEREF9EHUEREOmEHUEREF9EHUER
EF9Eo`gB00?od]802]800ol0000C0003o`00014000?o00000_lFg`0aoelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0GdP03o`0000/0000:0003omoO00[O0_l<g`03
omoO00_O00?o4A402a400olA4@0;4@0Loh1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1no`gB00?od]80
2]800ol0000C0003o`00010000Co00000_lFg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7ko01OB00?o00002`0000X000?ogml00ml2o`GO0_l4g`;o1]l00ooOg`03g`?o1Ml01OlAGa5O00?o
00]O4ElAGa7o4ElAG`03o`0:Ga5O4ElAof9EHPCo00]EHUEREOmEHUERE@02o`07HUEREF9Eo`04dP?o
1]800ooBdP03dP03om;B00CB00?o00004`000ol0000200;o00<0ool020000ol0000200;o5]l0<OmO
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREOl05m800ol0000;0000
2P000ooOg`02g`04omoOo`CO0_l3g`04omoOo`GO00?ogml01=l00ooOg`04g`03oa4A00<A00?o4A40
1A400olA4@054@03oa4A00<A01coP7j0O_mnP7j0OX1nogj0OX3oP7koOX1nP7ko1m800ooBdP03dP03
om;B00?B00?od]801=800ol0000C0003o`0000<000?o0?l020000ol0000300;o5]l00olA4@0E4@0I
ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0GdP03o`0000/0000:0003omoO00;O00Cogmoo1=l2o`?O
00Cogmoo1Ml00ooOg`02g`Co1Ml0>?lAGa5O4OlAGa5O4ElAoa5O4ElAGa7o4ElAGa7oHUEREF;oHUER
EF9EoeEREF;oHUGoEF9EHUGo1m800ooBdP03dP03om;B00CB00?od]800m800ol0000C0003o`0000@0
00?o00001P000ol0000400;o5]l0<OmO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9E
HUEREF9EHUEREOl05m800ol0000;00002P000ooOg`02g`04omoOo`CO0_l3g`04omoOo`GO00?ogml0
0]l00ooOo`06g`03oa4A00<A00?o4A401A400olA4@024@?o1Q404_n0OX1nP7koOX1nP7koOX1nP0?o
00N0OX1nP7ko00GB0_l6dP03om;B00CB00?od]800m800ol0000C0003o`0000<000?o0?l01P000ol0
000500;o5]l00olA4@0E4@0Iogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0GdP03o`0000/0000:0003
omoO00;O00Cogmoo1=l2o`?O00Cogmoo1Ml00ooOg`02g`03omoo00KO03So4ElAGa7o4ElAGa5O4OlA
Ga5OoelAGa5O4ElAof9EH_mREOmEHUEREOmEHUERof9EHUEREF9Eo`OB00?od]800m800ooBdP05dP03
om;B00;B00?o00004`000ol0000200;o00<0ool010000ol0000600;o2]l2o`[O00[oGa5O4ElAGa5O
0ol05ElAGa5O4ElAGa5OoeEREF9EHUERE@04o`0;HUEREF9EHUEREOl02M83o`_B00?o00002`0000X0
00?ogml00ml2o`GO0_l4g`;o1]l00ooOg`03g`;o1]l00olA4@024@;o1a400olA4@024@Co1A401On0
OX1n00;o00b0OX1nP7koOX1nP7h3o`06OX1nP7ko1=83o`KB00?od]800]84o`CB00?o00004`000ol0
000:0003o`0000L00_l9g`04omoOo`WO00?o4A4021400olA4@0:4@0Iogj0OX1nP7j0OX3oP7j0OX1n
P7j0OX1no`0<dP03om;B00SB00?o00002`0000X000?ogml02]l2o`cO00?ogml02ml0>?lAGa5O4ElA
Ga5O4ElAoa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUGo3M800ooBdP0:dP03
o`0001<000?o00002@000ol0000800;o2Ml01?oOgol9g`0aoelAGa5O4ElAGa7o4ElAGa5O4ElAGa5O
oeEREF9EHUEREF9EoeEREF9EHUEREF9Eo`0<dP03om;B00SB00?o00002`0000X000?ogml02]l2o`cO
00?ogml02ml00olA4@0;4@03oa4A00/A01coP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7ko3M800ooB
dP0:dP03o`0001<000?o000020001?l00003o`D00_l9g`04omoOo`WO00?o4A4021400olA4@0:4@0I
ogj0OX1nP7j0OX1nP?n0OX1nP7j0OX1no`0:dP;o2m800ol0000;00002P000ooOg`0:g`;o3=l00ooO
g`0;g`0hoa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4OmREF9EHUEREF9EHUGoEF9EHUEREF9EHUER
EOl=dP03om;B00[B00?o00004`000ol000070003o`0000<000?o00001002o`WO00Cogmoo2Ml0<OmO
4ElAGa5O4ElAoa5O4ElAGa5O4ElAGomEHUEREF9EHUGoEF;oHUEREF9EHUEREOl03=800ooBdP08dP03
o`0000/0000907go5@000ol000060003o`0000D000?o00000`02o`[O0_l:g`03oa4A00LA0_l<4@0;
ogj0OX1nP7j0OX000_l037j0OX1nP7j0OX1no`WB0ol;dP03o`0000/0000907go5@000ol000050003
o`0000H000?o00000`02oaKO037oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9E
HUEREF9EHUGo01OB00?o00002`0000X000?o00002@03o`cO00?ogml02ml00olA4@0;4@03oa4A00/A
01coP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7ko3M800ooBdP0:dP03o`0001<000?o000010000ol0
00060003o`3o00@00_lFg`03oa4A01DA01WoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01OB00?o0000
2`0000X000Go0?oo0002o`@000Co0?oo3=l00ooOg`0;g`0hoa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElA
Ga5O4OmREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREOl=dP03om;B00[B00?o00004`000ol000030003
o`0000L000?o0?l01002oaKO037oGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9E
HUEREF9EHUGo01OB00?o00002`0000X000Ko003o0?l40003o`0000;o3=l00ooOg`0;g`03oa4A00/A
00?o4A402a407?n0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0O_l=dP03om;B00[B00?o00004`000ol0
00020003o`0000L00_l00`3oo`0300;o5]l00olA4@0E4@0Iogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
o`0GdP03o`0000/0000:0005o`000?l010001?l00002o`CO0_l6g`03omoO00?O0ol5g`05oa5O4El0
0ol02elAGa5O4OlAGa5O00?o00YO4ElAGa7oHUER1?l02eEREF9EoeEREF9E00;o00MREF9EHUGo00CB
0ol6dP03om;B00?B00?od]801=800ol0000C0005o`000?l04P02oaKO037oGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUGo01OB00?o00002`0000X000Oo003o0?l000?o
0`02o`?O00Cogmoo1Ml00ooOg`04g`03omoO00CO00?o4A400a400olA4@054@03oa4A00DA00?o4A40
0a407?n0OX1nogj0OX1nP7koOX1nP?n0O_mnP7j0O_l7dP03om;B00?B00?od]800m800ooBdP04dP03
o`0001<000Co003o4`02oaKO00?o4A405A406OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l05m800ol0
000;00002P001Ol0ool000Co1002o`?O00Cogmoo1Ml00ooOg`02g`Co1Ml0>?lAGa5O4OlAGa5O4ElA
oa5O4ElAGa7o4ElAGa7oHUEREF;oHUEREF9EoeEREF;oHUGoEF9EHUGo1m800ooBdP03dP03om;B00CB
00?od]800m800ol0000C0003o`3o01@00_lFg`0aoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9E
HUEREF9EHUEREF9EHUEREF9Eo`0GdP03o`0000/0000:0003o`0000<000Co003o0`02o`?O00Cogmoo
1Ml00ooOg`02g`03omoo00KO00?o4A400a400olA4@054@03oa4A008A0ol64@0Boh1nP7j0O_mnP7j0
O_mnP7j00ol01h1nP7j0O_l01M82o`KB00?od]801=800ooBdP03dP03o`0001<00_lE00;o5]l00olA
4@0E4@0Iogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0GdP03o`0000/0000:0003o`00008000Go0000
o`0300;o0ml01?oOgol5g`03omoO00;O00?ogol01]l0>?lAGa5O4OlAGa5O4ElAoa5O4EooGa5O4ElA
Ga7oHUERof9EoeEREF9EoeEREF;oHUEREF9EHUGo1m800ooBdP03dP03om;B00GB00?od]800]800ol0
000C07So3@0000X000Go0000o`030003o`3o00800_l4g`;o1]l00ooOg`03g`;o1]l00olA4@024@;o
1a400olA4@024@Co1A401On0OX1n00;o00b0OX1nP7koOX1nP7h3o`06OX1nP7ko1=83o`KB00?od]80
0]84o`CB00?o0000:P02of`0000:0004o`00o`@000?o0?l00P02o`cO00?ogml02ml0>?lAGa5O4ElA
Ga5O4ElAoa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUGo3M800ooBdP0:dP03
o`0009P0000:0003o`3o00@00_l0103oo`02o`cO00?ogml02ml00olA4@0;4@03oa4A00/A01coP7j0
OX1nP7j0OX1nogj0OX1nP7j0OX1nP7ko3M800ooBdP0:dP03o`0009P0000:00;o2`02o`cO00?ogml0
2ml0>?lAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa7oHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUGo
3M800ooBdP0:dP03o`0009P0000:07coVP0001L00_oo00P0003o0240000B00;o2P02oed00olS00;o
2P02oeT00olC00004P000ol0000:0003o`0005`000?o00008P000ol0000:0003o`0005P000?o0000
4P0000/01?l30003o`0000<00_l50003o`0004<00_l00`3oo`0:0003o`0000P000?o00006P04o`<0
00?o00000`03o`@000?o0000?`02o`030?oo00X000?o000020000ol0000A000030000ol0o`030003
o`00008000Co003o10000ol000140003o`3o00/000?o000020000ol0000K0003o`3o00<000?o0000
10000ol000030003o`00040000?o0?l02`000ol000080003o`000140000<0003o`0000<000?o0000
0P001?l00?l40003o`0004D000?o00002005o`L000?o0?l070000ol000030003o`0000801?l40003
o`00044000?o00002005o`L000?o0?l04P0000d000?o00000P000ol0000300;o1@000ol000140003
o`3o00/000?o00001`000ol0o`0M0003o`00008000?o00000P000ol0o`050003o`00040000?o0?l0
2`000ol000070003o`3o0180000;0003o`3o00@000?o00000P001?l00?l40003o`0004<00_l00`3o
o`0:0003o`0000H00_l00`3oo`0J0003o`3o00@000?o00000P000ol0o`050003o`0003l00_l00`3o
o`0:0003o`0000H00_l00`3oo`0A00002`04o`<00_l400;o1002og`01?l300;o1002o`@00_m_0000
o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143.75, 0}} -> {-0.0537398, -0.0251377, 
  0.00734314, 0.00734314}, {{7.3125, 137}, {140.312, 
  3.375}} -> {-1.7579, -0.489659, 0.0728683, 0.0728683}, {{149.938, 
  279.625}, {140.312, 3.375}} -> {-7.55797, -0.282499, 0.042173, 0.042173}},
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "As indicated at the beginning of this section, a prerequisite to forming a \
quotient group is that the chosen subgroup be normal. The ",
  StyleBox["NormalQ", "MR"],
  " function is used to test this. Additionally, the ",
  StyleBox["Index", "MR"],
  " function measures the number of cosets, which in turn is also the size of \
the quotient group. Note that since we sometimes denote that the subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " is normal in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`N \[LeftTriangle] G\)]],
  ", the order of the arguments in this function reflect this notation."
}], "Text",
  CellTags->{"Quotients", "i:24"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NormalQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(N, \ G\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], " ", "and", " ", 
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    StyleBox["N",
                      "Text"],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    StyleBox["N",
                      "Text"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["normal",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              RowBox[{
                StyleBox["and",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["False",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["otherwise",
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Index",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["N",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], " ", "and", " ", 
                StyleBox["subgroup",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    StyleBox["N",
                      "Text"],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["number",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cosets",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    StyleBox["N",
                      "Text"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.27, 0.73}},
  CellTags->{"Quotients", "i:25"}],

Cell["Related coset functions.", "Caption",
  CellTags->"Quotients"],

Cell[TextData[{
  "The subgroup ",
  Cell[BoxData[
      \(TraditionalForm
      \`H\  = \ \[LeftAngleBracket]{3, \ 2, \ 1}\[RightAngleBracket]\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " is not a normal subgroup."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NormalQ[H\  = \ SubgroupGenerated[Symmetric[3], \ {3, \ 2, \ 1}], 
      Symmetric[3]]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell["We can still compute the index for this subgroup, however.", 
  "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Index[Symmetric[3], \ H\ ]\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"Quotients"]
}, Open  ]],

Cell[TextData[{
  "A quotient group is a group with a valid binary operation. The following \
shows why the lack of normality in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " prevents a quotient structure from being defined."
}], "MathCaption",
  CellTags->"Quotients"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LeftCosets[Symmetric[3], \ \ H, \ Mode\  \[Rule] \ Visual]; \)\)], 
  "Input",
  CellLabel->"In[50]:=",
  CellTags->"Quotients"],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {3, 2, 1}, g2 \
\[Rule] {1, 2, 3}, g3 \[Rule] {2, 3, 1}, g4 \[Rule] {1, 3, 2}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {2, 1, 3}}"\)], "Print",
  CellTags->"Quotients"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
1 .5 0 r
.84014 .70578 m
.84014 .84184 L
.97619 .84184 L
.97619 .70578 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.70408 .16156 m
.70408 .29762 L
.84014 .29762 L
.84014 .16156 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
.56 .37 .6 r
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.15986 .02551 m
.15986 .16156 L
.29592 .16156 L
.29592 .02551 L
F
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
1 .5 0 r
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.56 .37 .6 r
.70408 .84184 m
.70408 .97789 L
.84014 .97789 L
.84014 .84184 L
F
.84014 .84184 m
.84014 .97789 L
.97619 .97789 L
.97619 .84184 L
F
1 1 0 r
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
1 .5 0 r
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
.56 .37 .6 r
.02381 .16156 m
.02381 .29762 L
.15986 .29762 L
.15986 .16156 L
F
.02381 .02551 m
.02381 .16156 L
.15986 .16156 L
.15986 .02551 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(g2)] .22789 .77381 0 0 Mshowa
[(g1)] .36395 .77381 0 0 Mshowa
[(g6)] .5 .77381 0 0 Mshowa
[(g5)] .63605 .77381 0 0 Mshowa
[(g4)] .77211 .77381 0 0 Mshowa
[(g3)] .90816 .77381 0 0 Mshowa
[(g1)] .22789 .63776 0 0 Mshowa
[(g2)] .36395 .63776 0 0 Mshowa
[(g3)] .5 .63776 0 0 Mshowa
[(g4)] .63605 .63776 0 0 Mshowa
[(g5)] .77211 .63776 0 0 Mshowa
[(g6)] .90816 .63776 0 0 Mshowa
[(g4)] .22789 .5017 0 0 Mshowa
[(g3)] .36395 .5017 0 0 Mshowa
[(g5)] .5 .5017 0 0 Mshowa
[(g6)] .63605 .5017 0 0 Mshowa
[(g2)] .77211 .5017 0 0 Mshowa
[(g1)] .90816 .5017 0 0 Mshowa
[(g3)] .22789 .36565 0 0 Mshowa
[(g4)] .36395 .36565 0 0 Mshowa
[(g1)] .5 .36565 0 0 Mshowa
[(g2)] .63605 .36565 0 0 Mshowa
[(g6)] .77211 .36565 0 0 Mshowa
[(g5)] .90816 .36565 0 0 Mshowa
[(g6)] .22789 .22959 0 0 Mshowa
[(g5)] .36395 .22959 0 0 Mshowa
[(g2)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g3)] .77211 .22959 0 0 Mshowa
[(g4)] .90816 .22959 0 0 Mshowa
[(g5)] .22789 .09354 0 0 Mshowa
[(g6)] .36395 .09354 0 0 Mshowa
[(g4)] .5 .09354 0 0 Mshowa
[(g3)] .63605 .09354 0 0 Mshowa
[(g1)] .77211 .09354 0 0 Mshowa
[(g2)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[50]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H00006000Sogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX000_l0BGj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l091400olA4@0Q4@03omoO027O00?ogml08]l00ol000040000
1P008omEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER00;o099EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5Oob?O00?ogml08]l00ol0000400001P008omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j000;o04UnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o02@A00?o4A408A400ooOg`0Qg`03omoO02;O00?o0000
100000H002?oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHP02o`2BEF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
oa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGolSg`03omoO02;O00?o0000100000H002?oOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0T4@03oa4A024A00?ogml08Ml00ooOg`0Rg`03
o`0000@00006000SoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF800_l0TUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4Eoo8ml00ooOg`0Rg`03o`0000@00006000Sogj0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX000_l0BGj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l091400olA4@0Q4@03omoO027O00?ogml0
8]l00ol0000400001P008omEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER00;o099EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5Oob?O00?ogml08]l00ol0000400001P008omnP7j0OX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j000;o04UnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o02@A00?o4A408A400ooOg`0Qg`03
omoO02;O00?o0000100000H002?oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHP02o`2B
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGolSg`03omoO02;O00?o0000100000H002?oOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0T4@03oa4A024A00?ogml0
8Ml00ooOg`0Rg`03o`0000@00006000SoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF80
0_l0TUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo8ml00ooOg`0Rg`03o`0000@00006000Sogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX000_l0BGj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l091400olA4@0Q4@03
omoO027O00?ogml08]l00ol0000400001P008omEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUER00;o099EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oob?O00?ogml08]l00ol0000400001P003_mn
P7j0OX1nP7j0OX1n0ol04Wj0OX1nP7j0OX1nP7j0OX1nP0;o00inP7j0OX1nP7j0OX1nP0?o0260OX1n
P7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX000ol0581nP7j0OX1nP7j0OX1nP7j0OX3o3A43oa@A
00?o4A402a43oa<A00?ogml02ml3oa?O00?ogml03=l3oa?O00?o0000100000H002?oEF9EHUEREF9E
HUEREF9EH_mREF9EHUEREF9EHUEREF9EHP02o`2BEF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUER
EF9EHUERof9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4Eoo
Ga5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGol@g`03
omoO013O00?ogml03ml00ooOg`0@g`03o`0000@00006000>ogj0OX1nP7j0OX1nP7h4o`0AP7kooh1n
P7j0OX1nP7j0OX000_l03Wj0OX1nP7j0OX1nP7j01?l087kooomnP7j0OX1nP7j0OX1nP?n0OX1nP7j0
OX1nP7j01?l04gj0oomnP7j0OX1nP7j0OX1nP?l03A44o`8A0ol>4@03oa4A00/A1?l0117oool>4@03
omoO00_O1?l01=ooool>g`03omoO00cO1?l00mooo`02o`gO00?o0000100000H002?oEF9EHUEREF9E
HUERof9EH_mRof9EoeEREF9EHUEREF9EHP02o`2BEF9EHUEREF9EHUEREOmEHUGoEF9EH_mREF9EHUER
EF9EHUERof9EHUEREF9EHUEREOmEHUGoEOmEH_mREF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGomO4Eoo
Ga5OoelAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa7o4ElAoa5O4EooGa5O4ElAGa5O4ElAGol<g`05
omoOgol00]l00ooOg`0=g`03omoO00_O00GogmoOo`02g`03omoO00gO00?o0000100000H002?oOX1n
P7j0OX1nP7j0oh1nP?n0oh1nogj0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0O_mnP7koOX1nP?n0
OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0O_mnP7koO_mnP?n0OX1nP7j0OX1nP7j0o`0<4@06oa4A4OlA
1?l>4@03oa4A00XA00Go4A4Ao`044@03oa4A00/A00?ogml02]l01OoOgmoo00;O00?ogml03Ml00ooO
g`0;g`05omoOgol00ml00ooOg`0<g`03o`0000@00006000CoeEREF9EHUEREF9EH_mREF;oHP03o`0=
HUEREF9EHUEREF9EHP02o`0CEF9EHUEREF9EHUEREOmEHUGoE@03o`0QEF9EHUEREF9EHUEREF;oHUER
EF9EHUEREF9EoeEREOmE00?o04MEHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4EooGa5OoeooGomO4ElA
Ga5O4ElAGa5O4EooGa5O4ElAGa5O4ElAoa5O4OlAG`02o`0?4ElAGa5O4ElAGa5O4Eoo00cO00GogmoO
o`02g`03omoO00gO00?ogml02ml01OoOgmoo00CO00?ogml02ml00ol0000400001P003_mnP7j0OX1n
P7j0OX1n1_l03h1nP7j0OX1nP7j0OX1nP002o`0>OX1nP7j0OX1nP7j0OX06o`0NOX1nP7j0OX1nP7j0
OX1nP?n0OX1nP7j0OX1nP7j01_l04Gj0OX1nP7j0OX1nP7j0OX3o00dA1_l00a7o4@0>4@03oa4A00/A
1Ol34@03oa4A00/A00?ogml02ml5o`03gooO00kO00?ogml03=l6o`;O00?ogml02ml00ol000040000
1P005?mEHUEREF9EHUEREF9EHUEREF9E0ol035EREF9EHUEREF9EHP;o01=EHUEREF9EHUEREF9EHUER
EF9E00Co025REF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EHUEREF800ol08F9EHUEREF9EHUEREF;o
4ElAGa5O4ElAGa5O4ElAGa5O4@02o`0RGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4@?o
00lAGa5O4ElAGa5O4ElAGol04]l2o`oO00?ogml04]l2o`kO00?o0000100000H002?oOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0T4@03oa4A024A00?ogml0
8Ml00ooOg`0Rg`03o`0000@00006000SoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF80
0_l0TUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo8ml00ooOg`0Rg`03o`0000@00006000Sogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX000_l0BGj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l091400olA4@0Q4@03
omoO027O00?ogml08]l00ol0000400001P008omEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUER00;o099EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoelA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oob?O00?ogml08]l00ol0000400001P008omn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j000;o04UnP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o02@A00?o4A40
8A400ooOg`0Qg`03omoO02;O00?o0000100000H002?oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHP02o`2BEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
GomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGolSg`03omoO02;O00?o0000100000H0
02?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0T4@03
oa4A024A00?ogml08Ml00ooOg`0Rg`03o`0000@00006000SoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF800_l0TUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo8ml00ooOg`0Rg`03o`0000@0
0006000Sogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX000_l0BGj0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l0
91400olA4@0Q4@03omoO027O00?ogml08]l00ol0000400001P008omEHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUER00;o099EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5Oob?O00?ogml08]l00ol0
000400001P008omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j000;o04UnP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX3o02@A00?o4A408A400ooOg`0Qg`03omoO02;O00?o0000100000H002?oEF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHP02o`2BEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
of9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERoa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGolSg`03omoO02;O
00?o0000100000H002?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP002o`19OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0o`0T4@03oa4A024A00?ogml08Ml00ooOg`0Rg`03o`0000@00006000SoeEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUEREF800_l0TUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EH_mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_lAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Eoo8ml00ooO
g`0Rg`03o`0000@000060?oo0Ol600001P008omEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUER00;o04UEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF;o02CO00?ogml08Ml0B_mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o1P0000H002?oOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0Tg`03omoO027O
00?o4A408A400olA4@0R4@03o`0000@00006000SoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF800_l0BEEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EH_l09=l00ooOg`0Qg`1:oelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Ol600001P008omn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j000;o04UnP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o02CO00?ogml0
8Ml00olA4@0Q4@03oa4A028A00?o0000100000H002?oEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHP02o`19EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUERo`0Tg`03omoO027O04[oGa5O4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`H00006000S
ogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX000_l0BGj0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l09=l00ooO
g`0Qg`03oa4A024A00?o4A408Q400ol0000400001P008omEHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUER00;o04UEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o02CO00?ogml08Ml0B_mO4ElAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o1P0000H0
02?oOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP002o`19OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0Tg`03
omoO027O00?o4A408A400olA4@0R4@03o`0000@00006000SoeEREF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF800_l0BEEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_mREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l09=l00ooOg`0Qg`1:oelAGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4Ol60000
1P008omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j000;o04UnP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX3oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o02CO
00?ogml08Ml00olA4@0Q4@03oa4A028A00?o0000100000H002?oEF9EHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHP02o`19EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERof9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERo`0Tg`03omoO027O04[oGa5O4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAo`H0
0006000Sogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX000_l0BGj0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l0
9=l00ooOg`0Qg`03oa4A024A00?o4A408Q400ol0000400001P008omEHUEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUER00;o04UEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;oHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o02CO00?ogml08Ml0B_mO4ElAGa5O4ElAGa5O
4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa7o
1P0000H000koOX1nP7j0OX1nP7j0OP?o019nP7j0OX1nP7j0OX1nP7j0OX02o`0>OX1nP7j0OX1nP7j0
OX03o`0QP7j0OX1nP7j0OX1nP7j0OX1nP?n0OX1nP7j0OX1nP7j000?o01B0OX1nP7j0OX1nP7j0OX1n
P7j0o`gO0olDg`03omoO00_O0olCg`03oa4A00/A0olC4@03oa4A00`A0olC4@03o`0000@00006000S
oeEREF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUEREF800_l0BEEREF9EHUEREF9EHUEREF9EoeER
EF9EHUEREF9EHUEREF9EH_mREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EH_l04=l00ooO
g`0Ag`03omoO00kO00?ogml04=l0B_mO4ElAGa5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4ElAGomO
4ElAGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5O4ElAGa7o1P0000H000koOX1nP7j0OX1nP7j0OPCo
0160ooooP7j0OX1nP7j0OX1nP002o`0>OX1nP7j0OX1nP7j0OX04o`0POX3oogj0OX1nP7j0OX1nP7j0
oh1nP7j0OX1nP7j0OX04o`0CO_ooogj0OX1nP7j0OX1nP7j0o`0=g`Co00?Oool00_l>g`03omoO00_O
1?l01=ooool>g`03oa4A00/A1?l0117oool>4@03oa4A00`A1?l24@?o3A400ol0000400001P008omE
HUEREF9EHUEREF;oHUERof9EHUGoEF9EHUEREF9EHUER00;o04UEHUEREF9EHUEREF9EoeEREOmEoeER
of9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EoeEREOmEHUERof9EHUEREF9EHUEREF;o00cO00GogmoO
o`02g`03omoO00kO00?ogml02]l01OoOgmoo00;O00?ogml03Ml0B_mO4ElAGa5O4ElAGa7o4ElAoa5O
4EooGa5O4ElAGa5O4ElAGomO4ElAGa5O4ElAGa5OoelAGomO4EooGa