(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1160059,      37869]*)
(*NotebookOutlinePosition[   1244592,      39959]*)
(*  CellTagsIndexPosition[   1241226,      39844]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell["\<\
Chapter 3
Ringoids\
\>", "Section",
  ShowCellBracket->True,
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell["3.5 Using Cayley tables ", "Subsection",
  ShowCellBracket->True,
  CellTags->"Cayley"],

Cell[TextData[{
  "Both the additive and multiplicative Cayley tables are produced by the \
function ",
  StyleBox["CayleyTables",
    FontFamily->"Courier"],
  " and individually with ",
  StyleBox["CayleyTables",
    FontFamily->"Courier"],
  " or ",
  StyleBox["CayleyTable",
    FontFamily->"Courier"],
  " (using the ",
  StyleBox["Operation", "MR"],
  " option). ",
  StyleBox["MultiplicationTable", "Input",
    FontWeight->"Plain"],
  " can also be used to generate a multiplication table."
}], "Text",
  CellTags->"Cayley"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["CayleyTables",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cayley",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["tables",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((in\ double\ array\ form)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Addition",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Multiplication",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["R",
                "TI"]}]},
          {
            RowBox[{
              StyleBox["CayleyTables",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Mode\  \[Rule] \ Visual\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["PostScript",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rendition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Addition",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Multiplication",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["tables",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["R",
                "TI"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["addition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["double",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["array",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["form",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["CayleyTables",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[\(\(, \ \(Operation\  \[Rule] \)\)\ \),
                  "MR"], 
                StyleBox[
                  FormBox["op",
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cayley",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["tables",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["R",
                "TI",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["op",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["Addition",
                    "MR",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["or",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["Multiplication",
                    "MR"]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["MultiplicationTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Multiplication",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["R",
                "TI",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  CellTags->{"Cayley", "i:1"}],

Cell["Methods for generating Cayley tables of ringoids.", "Caption",
  CellTags->"Cayley"],

Cell["\<\
Here is the computational output for the Cayley tables of the ring \
of integers mod 3.\
\>", "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTables[Z[3]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Cayley"],

Cell[BoxData[
    \({{{0, 1, 2}, {1, 2, 0}, {2, 0, 1}}, {{0, 0, 0}, {0, 1, 2}, {0, 2, 1}}}
      \)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "Although the computational output is useful for further calculations, the \
",
  StyleBox["Visual", "MR"],
  " mode provides a result that is much easier to read."
}], "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTables[ZR[3], Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(1)] .61905 .62202 0 0 Mshowa
[(2)] .85714 .62202 0 0 Mshowa
[(1)] .38095 .38393 0 0 Mshowa
[(2)] .61905 .38393 0 0 Mshowa
[(0)] .85714 .38393 0 0 Mshowa
[(2)] .38095 .14583 0 0 Mshowa
[(0)] .61905 .14583 0 0 Mshowa
[(1)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(1)] .14286 .38393 0 0 Mshowa
[(2)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(1)] .61905 .86012 0 0 Mshowa
[(2)] .85714 .86012 0 0 Mshowa
[(Addition)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 .5 0 r
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(0)] .61905 .62202 0 0 Mshowa
[(0)] .85714 .62202 0 0 Mshowa
[(0)] .38095 .38393 0 0 Mshowa
[(1)] .61905 .38393 0 0 Mshowa
[(2)] .85714 .38393 0 0 Mshowa
[(0)] .38095 .14583 0 0 Mshowa
[(2)] .61905 .14583 0 0 Mshowa
[(1)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(1)] .14286 .38393 0 0 Mshowa
[(2)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(1)] .61905 .86012 0 0 Mshowa
[(2)] .85714 .86012 0 0 Mshowa
[(Multiplication)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0
000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO
03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000M
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;0000
2P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0o
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000=ooAnm7kd
O_Anm7kdOP04o`0=m7kdO_Anm7kdO_Anm002o`0<O_Anm7kdO_Anm7kd1?l03gkdO_Anm7kdO_Anm7kd
o`0=g`;o3ml03OmOWenOGimOWenOGil00ol03imOWenOGimOWenOGimOo`0C000=ogkdO_Anm7kdO_An
m004o`0<O_Anm7kdO_Anm7kd0_l>g`;o3]l03_odO_Anm7kdO_Anm7kd1?l06gkdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOG`03o`0?GimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5nLGkoOW5n
LGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaO_l03=l01?oOgol>g`0O
oenOGimOWenOGimOWeooGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW7oLGiaOW5nLGia
OW5nLGh00_l=g`04omoOo`gO03ooOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaoenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kd
O_@2o`0OO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdo`0<g`04omoOo`kO01ooGimOWenOGimO
WenOGomOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm002o`gO
00Cogmoo3Ml0?oodO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGiooWenO
GimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOP;o01maOW5n
LGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGko00cO00Cogmoo3]l07omOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5n00;o3Ml01?oOgol=g`0o
ogiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWonOGimOWenOGimOWenO
Gioo00/0000:000NooAnm7kdO_Anm7kdO_mnm?odO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm?od
O_mnm7kdO_Anm7kdO_Anm?l03=l01?oOgol>g`0OoenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
o`0C000MogkdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kdO_@00_l=g`04omoOo`gO03oom7kdO_Anm7kd
O_Anm?odO_mnm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWol02`0000X0
00koOW5nLGiaOW5nLGiaOP;o00iaOW5nLGiaOW5nLGiaOP;o00eaOW5nLGiaOW5nLGia00;o011nLGia
OW5nLGiaOW5nLGko3Ml2o`oO00goGimOWenOGimOWenO00;o011OWenOGimOWenOGimOWeoo4`003_ma
OW5nLGiaOW5nLGia0_l03GiaOW5nLGiaOW5nLGh00_l>g`;o3]l03omnLGiaOW5nLGiaOW5nL@02o`0L
OW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOG`;o012OGimOWenOGimOWenOGioo2`0000X001kom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;0000
2P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0o
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
7]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o
01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X0
01koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0;00002P1loa<0O?l;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P003OnOGimOWenOGimOWel00ol03UnOGimOWenOGimOWenO0_l035nOGimOWenOGimOW`?o
01bOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia1?l03giaOW5nLGiaOW5nLGiao`0=g`;o3]l00ol0
000A000=oenOGimOWenOGimOW`03o`0=WenOGimOWenOGimOW`02o`kO0_l>g`0>oimOWenOGimOWenO
Gil3o`0LWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nL@Co00inLGiaOW5nLGiaOW5no`/0000:000N
oimOWenOGimOWenOGiooWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWeooGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7ko3=l01?oOgol=g`03o`00014001goGimO
WenOGimOWenOGomOWenOGimOWenOGimOW`02o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenOGomOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenO
GimOWenOoimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOoenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiao`cO00Cogmoo3Ml00ol0000A000MoenOGimOWenOGimO
WeooGimOWenOGimOWenOGil00_l=g`04omoOo`gO03ooWenOGimOWenOGimOWeooGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaO_l02`0000X001koWenOGimOWenOGimOWonO
GimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm?odO_Anm7kdO_Anm7kdO_l<g`04omoOo`gO00?o00004@007OmOWenOGimOWenOGimOoenOGimO
WenOGimOWenO00;o3Ml01?oOgol=g`0ooimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGiooWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWeooGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7oLGkoOW5n
LGiaOW5nLGiaOW7o3=l01?oOgol=g`03o`00014001goGimOWenOGimOWenOGomOWenOGimOWenOGimO
W`02o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenOGomOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LOmaO_mnLGiaOW5nLGiaOW5no`0;00002P003OnOGimOWenOGimOWel00_l03imOWenOGimOWenOGimO
W`02o`0<GimOWenOGimOWenO0_l07UnOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm0;o011nm7kd
O_Anm7kdO_Anm7ko3Ml2o`kO00?o00004@003OmOWenOGimOWenOGil00_l03UnOGimOWenOGimOWenO
0_l>g`;o3]l03_nOGimOWenOGimOWenO0_l07UnOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm0;o
00mnm7kdO_Anm7kdO_Anm?l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0n
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X0
01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lMg`03o`00014001goGimOWenOGimO
WenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lMg`03o`000140
01goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X001koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimO
WenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0n
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X0
01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001goGimOWenOGimO
WenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`000140
01goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X001koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimO
WenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0n
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlMg`03o`00014001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X0
O?lC07co2`0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03
o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0
000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o0000
2@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0
000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol000090000
2P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X0
00?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003
omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml0
6ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO00_O0_l>g`;o
3Ml2o`oO00goWenOGimOWenOGimO00?o01aOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd1?l03Wkd
O_Anm7kdO_Anm7ko4`000ooOg`0;g`;o3Ml2o`kO0_l>g`03omoO00cO0_l>g`03omoO00cO0_l>g`03
o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l0?_nOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0:g`04omoOo`cO
0_l=g`04omoOo`gO00?ogml02ml01?oOgol=g`03omoO00_O00Cogmoo3Ml00ol0000900002P000ooO
g`0:g`04omoOo`gO0_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anoa<000?ogml02]l01?oOgol<g`;o3Ml01?oOgol=g`03
omoO00_O00Cogmoo3Ml00ooOg`0;g`04omoOo`gO00?o00002@0000X000?ogml02]l01?oOgol=g`;o
3=l01?oOgol>g`0noimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW7o
LGiaOW5nLGiaOW5nLOlC0003omoO00[O00Cogmoo3=l2o`gO00Cogmoo3Ml00ooOg`0;g`04omoOo`gO
00?ogml02ml01?oOgol=g`03o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l0?_nO
GimOWenOGimOWenOoimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdooAnogkdO_Anm7kdO_Anm7ko
4`000ooOg`0:g`04omoOo`cO0_l=g`04omoOo`gO00?ogml02ml01?oOgol=g`03omoO00_O00Cogmoo
3Ml00ol0000900002P000ooOg`0;g`;o3]l2o`gO0_l?g`0=oimOWenOGimOWenOG`02o`0NWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGia0_l03giaOW5nLGiaOW5nLGiao`0C0003omoO00_O0_l=g`;o
3]l2o`kO00?ogml03=l2o`kO00?ogml03=l2o`kO00?o00002@0000X000?ogml06ml2oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooO
g`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml0
6]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O
0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o
7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO
00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03
omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooO
g`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml0
7=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO
00?ogml07=l00ol0000900002@1moa80OOl;00002@1moa80OOl;00002P000ol0000J00?o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
4`000ol0000J00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000I0004o`3ooakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00006@03oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l02`0000X000?o000060000ol00002oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o000060001?l0oolNg`0ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0
000:0003o`0001L000Co00000_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0001L000?o00000_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003
o`0001H000?o00000P02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00005P001?l00002oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o0000
5@000ol0000300;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko4`000ol0000E0003o`0000800_lNg`0ooimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000@0
0_l00`3oo`0;0003o`0000@00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000@00_l00`3oo`0;0003o`0000<00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:0003o`0000D000?o0?l02`000ol0000500;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol000050003o`3o00/0
00?o00001002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00001P000ol000090003o`0000H00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
o`0000H000?o00002@000ol0000500;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000050003o`3o00T000?o0000
1`02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?o00001@000ol0o`090003o`0000H00_lNg`0ooimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000@0
0_l00`3oo`070003o`0000P00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000@00_l00`3oo`070003o`0000L00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:0003o`0000l000?o00002@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00003`000ol0000800;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P000ol0000>0003o`0000X00_l=g`;o3ml03OnOGimOWenOGimOWel00ol075nOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGh4o`0>LGiaOW5nLGiaOW5nLOlC0003o`0000h000?o00002@02o`kO
0_l>g`0>oimOWenOGimOWenOGil3o`0LWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nL@Co00inLGia
OW5nLGiaOW5no`/0000:0003o`0000d000?o00002`02o`cO00Cogmoo3]l0?_nOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7ko4`000ol0000=0003
o`0000X00_l=g`04omoOo`gO03ooWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdooAnm7kdO_Anm7kdO_Anm?l02`0000X000?o000030000ol0000<00;o3=l01?oOgol>g`0n
oimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5n
LOlC0003o`0000`000?o00002`02o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5no`0;00002P000ol0000;0003o`0000d0
0_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anoa<000?o00002`000ol0000<00;o3Ml01?oOgol=g`0ooimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co00/0000:0003
o`0000X000?o00001003o`L00_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaO_mnLOmaOW5nLGiaOW5nLGiaoa<000?o00002P000ol0000400?o1P02o`gO
00Cogmoo3Ml0?onOGimOWenOGimOWenOGomOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLOmaO_mn
LGiaOW5nLGiaOW5no`0;00002P000ol000090003o`0000H000?o00001P02o`gO0_l?g`0=oimOWenO
GimOWenOG`02o`0NWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An0_l03oAnm7kdO_Anm7kdO_An
o`0C0003o`0000T000?o00001P000ol0000500;o3]l2o`kO00koWenOGimOWenOGimOW`;o01iOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_@2o`0?O_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000P0
00?o000020000ol0000500;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000080003o`0000P000?o00001002oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o00001`000ol000090003o`0000D00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000L000?o00002@000ol0
000400;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P000ol000060003o`0000T000?o0?l01P02oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o0000
1P000ol000090003o`3o00D00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003o`0000D000?o00002P000ol0o`0600;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ol000050003o`0000X000?o0?l01@02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o000010000ol0
000:00;o00<0ool01@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o000010000ol0000:00;o00<0ool01002oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o00000`000ol0000E00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol000030003o`0001@00_lNg`0ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0
000:0003o`00008000?o00005P02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00000P000ol0000E00;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;0000
2P001Ol0003o01T00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lC0005o`000?l06002oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000Co003o6P02oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<000Co003o6@02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o0?l06`02oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o0?l06P02oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l02`0000X00_lL00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`02oa/00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:07co4`1lo`/0000X00;o
S002ofP0003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
001m00?o=`04oe400olA0000OP000ol0000g0003o`00058000?o0000400000X00_l00`3oo`0300Go
00<0ool02?l200?o0P05o`800ol200;o00<0ool0:`02o`030?oo00X000?o000020000ol0000H0006
o`000?l01Ol00`3oo`03o`800ol200Go00<0ool00_l200Go00<0ool00ol200?o0P05o`800ol200Go
0P03o`800_l00`3oo`0700;o00<0ool02@000ol0o`090003o`0000l0000;0003o`3o00<000Oo0000
o`3o00<000Go0000o`040004o`00o`<000Go0000o`030003o`3o008000?o0000:`000ol0o`0;0003
o`0000P000?o000060001ol0003o0?l00P000ol000020003o`00008000Co003o0`001Ol0003o00<0
00Go0000o`050005o`000?l00`000ol0o`020005o`000?l00P001Ol0003o00<000Oo0000o`3o0080
00?o00001`000ol0o`0;0003o`0000P000?o00003`0000/00ol30007o`000?l0o`030005o`000?l0
10000ol000040005o`000?l00`000ol0o`020003o`0002`000?o00002005o`L000?o0?l06@001ol0
o`3o0?l00P000ol000020003o`00008000?o000010001Ol0003o00<000Go0000o`050005o`000?l0
1@04o`<000?o000010001Ol0003o00<000?o0?l00P000ol000080003o`0000P01Ol70003o`3o0100
000;0003o`3o00<000Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000o`030003o`3o0080
00?o0000:`000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l00P000ol000020003o`000080
00?o000010001Ol0003o00<000Go0000o`050005o`000?l00`000ol000020005o`000?l01P001Ol0
003o00<000?o0?l00P000ol000070003o`3o00/000?o00001`000ol0o`0@000030000ol0000300Co
0P04o`800_l300Co0`02o`@00ol00`3oo`03ob`00_l00`3oo`0:0003o`0000H00_l00`3oo`0H00;o
00<0ool00_l00`3oo`040004o`0000Co0`02o`801Ol40003o`0000800_l400Co0P03o`801?l300;o
1003o`030?oo00?o2002o`030?oo01<00_l00`3oo`0?00002`02o`P000?o00000`000ol000060003
o`0007800_l300;o20000ol000020003o`00010000?o000050000ol0001600005002o`@00_l30003
o`00008000?o000010000ol0001h00?o10000ol000040003o`0000L00ol50003o`0000h000?o0000
10000ol0000o0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-5.95503, -0.231915, 0.0323772, 
  0.0323772}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{{0, 1, 2}, {1, 2, 0}, {2, 0, 1}}, {{0, 0, 0}, {0, 1, 2}, {0, 2, 1}}}
      \)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "Frequently, only the visual output from ",
  StyleBox["CayleyTables", "MR"],
  " is of interest; a semicolon at the end of the input will suppress the \
computational output."
}], "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultiplicationTable[BooleanRing[3], Mode \[Rule] Visual]; \)\)], 
  "Input",
  CellLabel->"In[3]:=",
  CellTags->"Cayley"],

Cell[BoxData[
    \("KEY for Mult(Bool[3]): label used \[Rule] element: {g1 \[Rule] {}, g2 \
\[Rule] {3}, g3 \[Rule] {2}, g4 \[Rule] {2, 3}, g5 \[Rule] {1}, g6 \[Rule] \
{1, 3}, g7 \[Rule] {1, 2}, g8 \[Rule] {1, 2, 3}}"\)], "Print",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 .5 0 r
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.56 .37 .6 r
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 0 1 r
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.74 .99 .79 r
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.251 .878 .816 r
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
0 .79 .34 r
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
0 .392 0 r
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g1)] .28836 .81878 0 0 Mshowa
[(g1)] .39418 .81878 0 0 Mshowa
[(g1)] .5 .81878 0 0 Mshowa
[(g1)] .60582 .81878 0 0 Mshowa
[(g1)] .71164 .81878 0 0 Mshowa
[(g1)] .81746 .81878 0 0 Mshowa
[(g1)] .92328 .81878 0 0 Mshowa
[(g1)] .18254 .71296 0 0 Mshowa
[(g2)] .28836 .71296 0 0 Mshowa
[(g1)] .39418 .71296 0 0 Mshowa
[(g2)] .5 .71296 0 0 Mshowa
[(g1)] .60582 .71296 0 0 Mshowa
[(g2)] .71164 .71296 0 0 Mshowa
[(g1)] .81746 .71296 0 0 Mshowa
[(g2)] .92328 .71296 0 0 Mshowa
[(g1)] .18254 .60714 0 0 Mshowa
[(g1)] .28836 .60714 0 0 Mshowa
[(g3)] .39418 .60714 0 0 Mshowa
[(g3)] .5 .60714 0 0 Mshowa
[(g1)] .60582 .60714 0 0 Mshowa
[(g1)] .71164 .60714 0 0 Mshowa
[(g3)] .81746 .60714 0 0 Mshowa
[(g3)] .92328 .60714 0 0 Mshowa
[(g1)] .18254 .50132 0 0 Mshowa
[(g2)] .28836 .50132 0 0 Mshowa
[(g3)] .39418 .50132 0 0 Mshowa
[(g4)] .5 .50132 0 0 Mshowa
[(g1)] .60582 .50132 0 0 Mshowa
[(g2)] .71164 .50132 0 0 Mshowa
[(g3)] .81746 .50132 0 0 Mshowa
[(g4)] .92328 .50132 0 0 Mshowa
[(g1)] .18254 .3955 0 0 Mshowa
[(g1)] .28836 .3955 0 0 Mshowa
[(g1)] .39418 .3955 0 0 Mshowa
[(g1)] .5 .3955 0 0 Mshowa
[(g5)] .60582 .3955 0 0 Mshowa
[(g5)] .71164 .3955 0 0 Mshowa
[(g5)] .81746 .3955 0 0 Mshowa
[(g5)] .92328 .3955 0 0 Mshowa
[(g1)] .18254 .28968 0 0 Mshowa
[(g2)] .28836 .28968 0 0 Mshowa
[(g1)] .39418 .28968 0 0 Mshowa
[(g2)] .5 .28968 0 0 Mshowa
[(g5)] .60582 .28968 0 0 Mshowa
[(g6)] .71164 .28968 0 0 Mshowa
[(g5)] .81746 .28968 0 0 Mshowa
[(g6)] .92328 .28968 0 0 Mshowa
[(g1)] .18254 .18386 0 0 Mshowa
[(g1)] .28836 .18386 0 0 Mshowa
[(g3)] .39418 .18386 0 0 Mshowa
[(g3)] .5 .18386 0 0 Mshowa
[(g5)] .60582 .18386 0 0 Mshowa
[(g5)] .71164 .18386 0 0 Mshowa
[(g7)] .81746 .18386 0 0 Mshowa
[(g7)] .92328 .18386 0 0 Mshowa
[(g1)] .18254 .07804 0 0 Mshowa
[(g2)] .28836 .07804 0 0 Mshowa
[(g3)] .39418 .07804 0 0 Mshowa
[(g4)] .5 .07804 0 0 Mshowa
[(g5)] .60582 .07804 0 0 Mshowa
[(g6)] .71164 .07804 0 0 Mshowa
[(g7)] .81746 .07804 0 0 Mshowa
[(g8)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(\\(Bool[3], x\\))] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{272.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l04@000?l04@000?l04@000?l04@000?l0
4@000?l04@000?l04@0000H0ool5o`H00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o
7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@
D?l600001P000om@D00ID0;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000
100000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_lLg`0joimOWenOGimOWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003oe1@01U@0_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<
05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P007?n@D91@T52@D91@T52@
D91@T52@D91@T52@D902oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@
D91@T52@D91@T52@D91@T53o1P0000H000?oD5006E02oacO03[oWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Po`0LD003o`0000@00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o7=l0>_nO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01d
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l60000
1P000om@D00ID0;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H0
01coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003oe1@01U@0_lLg`0joimOWenO
GimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P002_n@D91@T52@D903o`0?T52@D91@
T52@D91@T52@00;o2Ml3oa3O00[oWenOGimOWenO0ol06YmOWenOGimOWenOGimOWomnLGiaOW5nLGia
0ol0475nLGiaOW5nLGiaOW5nLOl9C0?o44`02_l33`<?0`l33`<3o`0J0`l33`<?0`l33`<?0`l33ol>
l@ka3_4>l@h3o`0J3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:03o`0IX>2Ph:3PX>2Ph:3PX>2Poi1@
T52@D91@T003o`0AT52@D91@T52@D91@T52@D?l01P0000H000?oD5002U000om@D00<D0;o3=l00ooO
g`0=g`0joimOWenOGimOWenOGomOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kd
O_Ano`a<00?oC4`03D`0EooF0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/?n`
3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3Po`0<D003oe1@00e@00?o0000
100000H000[oT52@D91@T52@1?l03U2@oom@T52@D91@T52@0_l9g`Co00COoooo2ml02_nOGimOWenO
Gil4o`03Gooo00;o01BOGimOWenOGiooOW5nLGiaOW5nL@Co00mnooooOW5nLGiaOW5nLOl02D`4o`9<
0ol:C00:o`<?0`l33`<?0`Co01T?oooo3`<?0`l33`<?0`oo3_4>l@ka3_4>00Co01Wa3_ool@ka3_4>
l@ka3_oPX>2Ph:3PX>2P00Co01SPX?nPh:3PX>2Ph:3PX?n@D91@T52@D904o`0@D93ooe2@D91@T52@
D91@o`H000060003oe1@00I@00OoD51@oe3o009@00?oD5001e02o`SO00GogmoOo`02g`03omoO00[O
03[oWenOGimOWeooGimOoenOoimOWenOGimOWenOooAnm7kdO_Anm?odO_Com7kdO_mnm7kdO_Anm7ko
24`01Om<C4co00=<00?oC4`02D`0EooF0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mH3o`j`3[0>/0j`
ok0>/?n`ok0>o`j`3[0>/0j`3_nPh:3PX>2Ph:3oX>2Poj3Pon2Ph:3PX>2Ph:3Po`08D007oe1@D?m@
o`02D003oe1@00Q@00?o0000100000H001coT52@D91@T53oD91@oe3oD93oT52@D91@T52@0_l8g`05
omoOgol00]l00ooOg`0:g`0joimOWenOGimOoenOGomOWeooGimOWenOGimOWomnLGiaOW5nLGkoOW5n
ogiaOW7oLGiaOW5nLGiao`Q<00KoC4a<od`4o`Y<07Co0`l33`<?0`oo3`<?o`l33`?o0`l33`<?0`l3
3ol>l@ka3_4>lOoa3_7olOoa3_l>l@ka3_4>l@koh:3PX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3PX?n@
D91@T52@D?m@T53oD?m@T?n@D91@T52@D91@o`H000060003oe1@00I@00GoD51@o`02D0;o2U02o`SO
00GogmoOo`02g`03omoO00[O02goWenOGimOWeooGimOoenOGiooWenOGimOWenOooAnm7kdO_Anm?od
O_Com7h00_l02oAnm7kdO_Anm7ko00Q<00WoC4a<odcoC?l02d`03ooF0mH3eP?F0ol3eP?o0`03o`0J
0mH3eP?F0mH3eP?o3[0>/0j`3[3o/0j`ok03o`0X/0j`3[0>/0j`3_nPh:3PX>2Ph:3oX>2Poj3PX?nP
h:3PX>2Ph:3Po`Q@00GoD51@o`02D0;o2e000ol0000400001P002_n@D91@T52@D906o`0<D93oT52@
D91@T52@0_l9g`Go00?Ooml02ml02_nOGimOWenOGil6o`0GGiooWenOGimOWenOogiaOW5nLGiaOW40
1Ol03W5nLOmaOW5nLGiaOW7o2D`6o`03C?m<00Y<00[o0`l33`<?0`l31_l05`l33`<?0`l33`<?0`oo
3_4>l@ka3_4>00Ko01Oa3_4>l@ka3_4>l@koh:3PX>2Ph:3PX005o`0GX>2Poj3PX>2Ph:3PX?n@D91@
T52@D9001_l03U2@oi1@T52@D91@T53o1P0000H000?oD5003E02o`Y@0_l>g`;o3=l04?nOGimOWenO
GimOWenOGil2o`0JGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_@3o`0;m7kdO_Anm7kdO_l03d`2o`]<
00ooeP?F0mH3eP?F0mH3eP<01?l06]H3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>0ol06@j`3[0>/0j`
3_nPh:3PX>2Ph:3PX>2Ph:001?l02^2Ph:3PX>2Ph?l?D0;o2e000ol0000400001P007?n@D91@T52@
D91@T52@D91@T52@D91@T52@D902oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@
D91@T52@D91@T52@D91@T52@D91@T53o1P0000H000?oD5006E02oacO03[oWenOGimOWenOGimOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3Po`0LD003o`0000@00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o
7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@
D?l600001P000om@D00ID0;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000
100000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_lLg`0joimOWenOGimOWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003oe1@01U@0_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<
05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P007?n@D91@T52@D91@T52@
D91@T52@D91@T52@D902oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@
D91@T52@D91@T52@D91@T53o1P0000H000?oD5006E02oacO03[oWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Po`0LD003o`0000@00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o7=l0>_nO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01d
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l60000
1P000om@D00ID0;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H0
ool5o`H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00ooOg`0Ig`2^ooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o1P0000H001coX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P0_lLg`03omoO01WO0:koOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l600001P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>02oacO00?ogml06Ml0[_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?oPX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Po`H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o7=l00ooO
g`0Ig`2^ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o
1P0000H001coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P0_lLg`03omoO01WO0:kom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l600001P007?nPh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:02oacO00?ogml06Ml0[_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph0;o7=l00ooOg`0Ig`2^ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3o1P0000H001coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P0_lLg`03omoO01WO
0:koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?on2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l60000
1P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>02oacO00?ogml06Ml0[_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`H00006000Loj3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX0;o7=l00ooOg`0Ig`2^ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poj3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o1P0000H000[oh:3PX>2Ph:3P0ol03n2Ph:3PX>2Ph:3PX>2P
h002o`WO0ol@g`03omoO00OO0ol?g`0;ooAnm7kdO_Anm7h00ol06GkdO_Anm7kdO_Anm7kdO_mnm7kd
O_Anm7h00ol06WkdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0ol06]H3eP?F0mH3eP?F0mH3eP?o0mH3
eP?F0mH30ol06P?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3P0ol06N2Ph:3PX>2Ph:3PX>2Ph?oPX>2P
h:3PX>000ol04N2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000Loj3PX>2Ph:3PX>2Ph?oPX>2Ph:3PX>2P
h:3PX0;o3=l00ooOg`0=g`03omoO00[O00?ogml03=l0[_mnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5n
LGiaog5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l3
3ol?0`l33`<?0`l33`?o0`l33`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph?oPX>2Ph:3PX>2Ph:3PX?nP
h:3PX>2Ph:3PX>3oh:3PX>2Ph:3PX>2Ph:3Po`H00006000:on2Ph:3PX>2Ph0Co00jPh?oPX>2Ph:3P
X>2Ph0;o2Ml4o`04goooo`_O00?ogml01ml4o`04goooo`[O00_om7kdO_Anm7kdOP04o`0Hm?ooooAn
m7kdO_Anm7koO_Anm7kdO_An1?l06OCoooodO_Anm7kdO_Anm?oF0mH3eP?F0mH01?l06@?oool3eP?F
0mH3eP?F0ol3eP?F0mH3eP<01?l06MKooooF0mH3eP?F0mH3oj3PX>2Ph:3PX>001?l06:3Pon2Ph:3P
X>2Ph:3Pon2Ph:3PX>2Ph0Co012Ph?oPX>2Ph:3PX>2Ph:3o1P0000H001coX>2Ph:3PX>3oh:3Pon2P
oj3PX>2Ph:3PX>2P0_l8g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO
0:koOW5nLGiaOW5nogiaO_mnLGiaog5nLGiaOW5nLOmaOW5nLGiaO_mnLGkoOW5nLOmaOW5nLGiaOW5n
o`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0`oo3`<?0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?on2P
h:3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>2Ph:3oX>2Ph:3PX>3oh:3Pon2Poj3PX>2Ph:3PX>2Ph?l60000
1P007?oPX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>02o`SO00GogmoOo`02g`03omoO00[O00?ogml0
1]l01OoOgmoo00;O00?ogml02Ml0[_odO_Anm7kdO_Com7kdooAnm7koO_Anm7kdO_AnogkdO_Anm7kd
ooAnm?odO_AnogkdO_Anm7kdO_CoeP?F0mH3eP?o0mH3o`?F0mKoeP?F0mH3eP?F0ol3eP?F0mH3e_oF
0mKoeP?F0ol3eP?F0mH3eP?oX>2Ph:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>2Ph?oPX>2Ph:3PX?nPh:3o
X>2Poj3PX>2Ph:3PX>2Po`H00006000Loj3PX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3PX0;o2=l01OoO
gmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`0AogiaOW5nLGiaO_mnLGkoOW40
0_l06WiaOW5nLGiaOW7oLGiaOW5nLGkoOW5nogia0_l06WiaOW5nLGiaOW5no`<?0`l33`<?o`l33ol?
0ol06Pl33`<?0`l33`<?o`l33`<?0`l3o`<?0ol30ol0A@<?0`l33`<?0`ooh:3PX>2Ph:3Pon2Ph?oP
X>3oh:3PX>2Ph:3PX?nPh:3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>2Ph:3Po`0600001P002_oPX>2Ph:3P
X>05o`0=h:3Pon2Ph:3PX>2Ph002o`WO1Ol00moog`0;g`03omoO00OO1Ol00moog`0:g`0;ooAnm7kd
O_Anm7h01Ol05gkdO_mnm7kdO_Anm7koO_Anm7kdO_An00Go01Qnm7koO_Anm7kdO_Anm?oF0mH3eP?F
0mH6o`0G0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP<01_l05mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3P00Go
01OPX>3oh:3PX>2Ph:3Pon2Ph:3PX>2Ph005o`0?h:3Pon2Ph:3PX>2Ph:3o00H00006000?oj3PX>2P
h:3PX>2Ph:3P00Co00VPh:3PX>2Ph:000_l>g`;o3=l00ooOg`0<g`;o2ml04?mnLGiaOW5nLGiaOW5n
LGh3o`0IOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOP03o`0JOW5nLGiaOW5nLGko0`l33`<?0`l33`<?
0`l4o`0I0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`04o`0I3`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2P
h004o`0HX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3P1?l02j3PX>2Ph:3PX>3o00H00006000Lon2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00ooOg`0Ig`2^ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o1P0000H001coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2P0_lLg`03omoO01WO0:koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph?l600001P007?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>02oacO00?ogml0
6Ml0[_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`H0
0006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o7=l00ooOg`0Ig`2^ogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o1P0000H001coh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3P0_lLg`03omoO01WO0:kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l600001P007?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:02oacO00?ogml06Ml0[_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3Po`H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00ooOg`0Ig`2^
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o1P0000H0
01coX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P0_lLg`03omoO01WO0:koOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l600001P007?oPX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>02oacO00?ogml06Ml0[_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?oPX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o
7=l00ooOg`0Ig`2^ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>3o1P0000H0ool5o`H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnO
GimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H0
0006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWooF0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H00006000Loo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o
7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0ko00H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H00006000Lok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO
097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ko00H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnOGimOWenO
GimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWooF0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H00006000L
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H00006000:ok0>/0j`3[0>/0?o00n`3[0>
/0j`3[0>/0j`3[000_l9g`?o4=l02_nOGimOWenOGil3o`0@WenOGimOWenOGimOWenOo`[O0ol?g`0:
oenOGimOWenOG`?o01YOWenOGimOWenOGimOWenOomH3eP?F0mH3eP?o01[F0mH3eP?F0mH3eP?F0mH3
o`j`3[0>/0j`3P?o01X>/0j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?o01WF0mH3eP?F0mH3eP?F0mKo
/0j`3[0>/0j`00?o016`3[0>/0j`3[0>/0j`3[0>o`0600001P007?oa3_4>l@ka3_4>l@ko3_4>l@ka
3_4>l@ka3_42o`cO00?ogml03Ml07OnOGimOWenOGimOWeooGimOWenOGimOWenOGioo00gO00?ogml0
3=l0TOmOWenOGimOWenOGiooWenOGimOWenOGimOWenOo`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?
0`oo3_4>l@ka3_4>l@kaoo4>l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`?o
l@ka3_4>l@ka3_4>o`ka3_4>l@ka3_4>l@ka3_l01P0000H000[o/0j`3[0>/0j`1?l03Pj`ool>/0j`
3[0>/0j`0_l9g`Co00COoooo2ml02_nOGimOWenOGil4o`03Gooo00;o00ZOGimOWenOGioo2]l4o`04
goooo`[O00[oGimOWenOGimO1?l00iooo`02o`0DGimOWenOGimOWooF0mH3eP?F0mH4o`0I0oooo`?F
0mH3eP?F0mH3o`j`3[0>/0j`3P04o`0I/0kook0>/0j`3[0>/0ko0mH3eP?F0mH3eP04o`0H0oooo`?F
0mH3eP?F0mKo/0j`3[0>/0j`1?l040j`ool>/0j`3[0>/0j`3_l600001P007?oa3_4>l@ka3_l>l@ko
3_l>lOoa3_4>l@ka3_42o`SO00GogmoOo`02g`03omoO00[O01goWenOGimOWeooGimOoenOoimOWenO
GimOWenOo`09g`05omoOgol00]l00ooOg`09g`2AoenOGimOWenOoimOWonOGomOWenOGimOWenOGioo
0`l33`<?0`oo3`<?o`l33`?o0`l33`<?0`l33ol>l@ka3_4>lOoa3_7olOoa3_l>l@ka3_4>l@ko3`<?
0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0ooa3_4>l@ka3_l>l@ko3_l>lOoa3_4>l@ka3_4>o`060000
1P007?n`3[0>/0j`3_l>/0ko3_l>/?n`3[0>/0j`3[02o`SO00GogmoOo`02g`03omoO00[O01goWenO
GimOWeooGimOoenOGomOWenOGimOWenOo`09g`05omoOgol00]l00ooOg`09g`2AoenOGimOWenOoimO
WonOGiooWenOGimOWenOGiooeP?F0mH3eP?o0mH3o`?F0mKoeP?F0mH3eP?F0ol>/0j`3[0>/?n`3[3o
/?n`3_l>/0j`3[0>/0ko0mH3eP?F0mH3o`?F0ol3eP?FomH3eP?F0mH3e_n`3[0>/0j`3_l>/0ko3_l>
/?n`3[0>/0j`3[0>o`0600001P003ooa3_4>l@ka3_l>l@ko3P03o`0:3_4>l@ka3_4>l@;o2=l01OoO
gmoo00;O00?ogml02]l07OnOGimOWenOGomOWeooGimOWonOGimOWenOGioo00WO00GogmoOo`02g`03
omoO00WO02coGimOWenOGiooWenOoimOWeooGimOWenOGimOWol33`<?0`l33ol?0`oo3`?o01X?0`l3
3`<?0`l33ol>l@ka3_4>lOoa3_7ol@?o01[a3_4>l@ka3_4>o`l33`<?0`l33ol?0`oo3`?o01T?0`l3
3`<?0`l3oo4>l@ka3_4>o`ka3_l>00?o00`>l@ka3_4>l@ka3_l600001P002_n`3[0>/0j`3[06o`0<
3[0>/0j`3[0>/0j`0_l9g`Go00?Ooml02ml02_nOGimOWenOGil6o`0=GiooWenOGimOWenOo`0:g`Go
00?Ooml02]l02_mOWenOGimOWel6o`0GWeooGimOWenOGimOWooF0mH3eP?F0mH01_l05`?F0mH3eP?F
0mH3eP?o3[0>/0j`3[0>00Ko01N`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP06o`0F0mH3eP?F0mH3eP?F
ok0>/0j`3[0>/0Ko00h>/0j`3[0>/0j`3[0>o`H00006000@oo4>l@ka3_4>l@ka3_4>l@?o00Wa3_4>
l@ka3_400_l>g`;o3=l04?nOGimOWenOGimOWenOGil2o`0;GimOWenOGimOWol03ml2o`_O013oGimO
WenOGimOWenOGimO0_l06YmOWenOGimOWenOo`<?0`l33`<?0`l33`<?1?l06P<?0`l33`<?0`oo3_4>
l@ka3_4>l@ka3_4>0ol06@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l01?l06@<?0`l33`<?0ooa3_4>
l@ka3_4>l@ka3_400ol02o4>l@ka3_4>l@ko00H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0ko00H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnOGimOWenO
GimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H00006000L
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H00006000Loo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ko00H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnO
GimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H0
0006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H00006000Lok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o
7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ko00H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l07OnOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWooF0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko00H00006000Loo4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO
097oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko00H00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO097oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0ko00H000060?oo1Ol600001P007?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH2oacO
00?ogml06Ml00ooOg`0Jg`03omoO01[O07CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000Lo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`;o
7=l00ooOg`0Ig`03omoO01[O00?ogml06]l0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`1domH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P007?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l0M?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H001co0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l30_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`1do`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P007?oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O07CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000Lo`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l0M?l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H001coeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`1domH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P002_l33`<?0`l33`<3o`0?
0`l33`<?0`l33`<?0`l300;o2Ml3oa3O00?ogml01ml3o`oO00?ogml02=l3o`oO00?ogml01ml3oa3O
00[o0`l33`<?0`l30ol06P<?0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0ol06Pl33`<?0`l33`<?0`l3
3ol?0`l33`<?0`l30ol06@<?0`l33`<?0`l33`<?0ol33`<?0`l33`<00ol04@<?0`l33`<?0`l33`<?
0`oo00H00006000LomH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP;o3=l00ooOg`0=g`03omoO00[O
00?ogml03=l00ooOg`0;g`03omoO00cO00?ogml02]l00ooOg`0=g`1domH3eP?F0mH3eP?F0ol3eP?F
0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?o0mH3eP?F
0mH3eP?F0mKoeP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0ol600001P002_l33`<?0`l33`<4o`0>
3oooo`l33`<?0`l33`<2o`WO1?l01=ooool;g`03omoO00OO1?l01=ooool:g`03omoO00SO1?l01=oo
ool:g`03omoO00OO1?l01=ooool;g`0:o`<?0`l33`<?0`Co01T?oooo3`<?0`l33`<?0`oo3`<?0`l3
3`<?00Co01T3oooo0`l33`<?0`l33ol?0`l33`<?0`l300Co01P?oooo3`<?0`l33`<?0ol33`<?0`l3
3`<4o`0@3oooo`l33`<?0`l33`<?o`H00006000LomH3eP?F0mH3o`?F0ol3eP?FomH3eP?F0mH3eP;o
2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`03omoO00OO00GogmoO
o`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O00?ogml02]l0M?oF0mH3eP?F0ol3eP?o0mH3e_oF
0mH3eP?F0mH3o`?F0mH3eP?FomH3e_oF0mH3o`?F0mH3eP?F0ol3eP?F0mH3eP?o0mH3o`?F0mKoeP?F
0mH3eP?FomH3eP?F0mH3o`?F0ol3eP?FomH3eP?F0mH3eP?o1P0000H001co0`l33`<?0`oo3`<?o`l3
3`?o0`l33`<?0`l30_l8g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO
00?ogml01ml01OoOgmoo00;O00?ogml02Ml00ooOg`06g`05omoOgol00]l00ooOg`0:g`1do`<?0`l3
3`<?o`l33ol?0`l3o`<?0`l33`<?0`oo3`<?0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?o`l33`<?0`l3
3ol?0`oo3`<?0ol33`<?0`l33`?o0`l33`<?0`oo3`<?o`l33`?o0`l33`<?0`l33ol600001P003ooF
0mH3eP?F0ol3eP?o0`03o`0:0mH3eP?F0mH3eP;o2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05
omoOgol00]l00ooOg`09g`03omoO00OO00GogmoOo`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O
00?ogml02]l03ooF0mH3eP?F0ol3eP?o0`03o`0J0mH3eP?F0mH3eP?o0mH3eP?F0mKoeP?FomH3o`0J
eP?F0mH3eP?F0ol3eP?F0mH3eP?o0mH3o`<3o`0I0mH3eP?F0mH3e_oF0mH3eP?F0ol3eP?o0`03o`0<
0mH3eP?F0mH3eP?o1P0000H000[o0`l33`<?0`l31_l030l33`<?0`l33`<?0`;o2Ml5o`03gooO00_O
00?ogml01ml5o`03gooO00[O00?ogml02=l5o`03gooO00[O00?ogml01ml5o`03gooO00_O00[o0`l3
3`<?0`l31_l05`l33`<?0`l33`<?0`oo3`<?0`l33`<?00Ko01L33`<?0`l33`<?0`oo3`<?0`l33`<?
0`06o`0F3`<?0`l33`<?0`l3o`<?0`l33`<?0`Ko00h?0`l33`<?0`l33`<?o`H00006000?omH3eP?F
0mH3eP?F0mH300Co00WF0mH3eP?F0mH00_l>g`;o3=l00ooOg`0<g`;o2ml00ooOg`0=g`;o2ml00ooO
g`0<g`;o3=l03ooF0mH3eP?F0mH3eP?F0`04o`0IeP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP04o`0I
0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0`04o`0HeP?F0mH3eP?FomH3eP?F0mH3eP?F0mH31?l02mH3
eP?F0mH3eP?o00H00006000Lo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`;o7=l00ooOg`0Ig`03
omoO01[O00?ogml06]l0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`oo1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0_lLg`03omoO01WO
00?ogml06]l00ooOg`0Jg`1domH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0ol600001P007?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2oacO00?ogml0
6Ml00ooOg`0Jg`03omoO01[O07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP;o7=l00ooO
g`0Ig`03omoO01[O00?ogml06]l0M?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?o1P0000H001co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l30_lLg`03
omoO01WO00?ogml06]l00ooOg`0Jg`1do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33ol600001P007?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH2oacO
00?ogml06Ml00ooOg`0Jg`03omoO01[O07CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000Lo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`;o
7=l00ooOg`0Ig`03omoO01[O00?ogml06]l0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`1domH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P007?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l0M?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H0ool5o`H000060003oda<01U<0_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<
00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?ogml06]l0>_mOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@000060003
oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?ogml06]l0>_mO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003
o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@000060003oda<01U<0_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<
00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?ogml06]l0>_mOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@000060003
oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?ogml06]l0>_mO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003
o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@000060003oda<00M<0ol?C0;o
2Ml3oa3O00[oWenOGimOWenO0ol06YmOWenOGimOWenOGimOWoodO_Anm7kdO_An0ol047kdO_Anm7kd
O_Anm7kdO_l9C0?o44`00ooOg`07g`?o4=l02_mOWenOGimOWel3o`0JGimOWenOGimOWenOGimOogkd
O_Anm7kdO_@3o`0@m7kdO_Anm7kdO_Anm7kdo`U<0ol@C003o`0000@000060003oda<00Y<00?oC4`0
34`2o`cO00?ogml03Ml0>_nOGimOWenOGimOWeooGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaO_mn
LGiaOW5nLGiaOW5nLOl<C003oda<00e<00?ogml02]l00ooOg`0=g`0joenOGimOWenOGimOWonOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5no`a<00?oC4`03D`00ol000040000
1P000om<C007C0Co0T`3o`U<0_l9g`Co00COoooo2ml02_nOGimOWenOGil4o`03Gooo00;o01BOGimO
WenOGioom7kdO_Anm7kdOPCo00odoooom7kdO_Anm7kdO_l02D`4o`9<0ol:C003omoO00OO1?l01=oo
ool;g`0:oenOGimOWenOG`Co00>Oool00_l055nOGimOWenOGomnm7kdO_Anm7kd1?l03gkooomnm7kd
O_Anm7kdo`09C0Co0T`3o`Y<00?o0000100000H000?oC4`01T`01Om<C4co00=<00?oC4`024`2o`SO
00GogmoOo`02g`03omoO00[O03[oWenOGimOWeooGimOoenOoimOWenOGimOWenOogiaOW5nLGiaO_mn
LGkoOW5nLOmaOW5nLGiaOW7o24`01Om<C4co00=<00?oC4`02D`00ooOg`06g`05omoOgol00]l00ooO
g`0:g`0joenOGimOWenOoimOWonOGomOWenOGimOWenOGomaOW5nLGiaOW7oLGiaog5nLGkoOW5nLGia
OW5no`Q<00GoC4a<o`03C003oda<00U<00?o0000100000H000?oC4`01T`01_m<C4coC0Co2D`2o`SO
00GogmoOo`02g`03omoO00[O03[oWenOGimOWeooGimOoenOGomOWenOGimOWenOooAnm7kdO_Anm?od
O_Com7kdO_mnm7kdO_Anm7ko24`01_m<C4coC0Co2T`00ooOg`06g`05omoOgol00]l00ooOg`0:g`0j
oenOGimOWenOoimOWonOGiooWenOGimOWenOGomnm7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdo`Q<
00KoC4a<od`4o`Y<00?o0000100000H000?oC4`01T`02Om<C4coC?m<o`0:C0;o2=l01OoOgmoo00;O
00?ogml02]l0;OnOGimOWenOGomOWeooGimOWonOGimOWenOGiooOW5nLGiaOW5nogiaO_mnL@02o`0;
OW5nLGiaOW5nLOl024`02Om<C4coC?m<o`0;C003omoO00KO00GogmoOo`02g`03omoO00[O02goGimO
WenOGiooWenOoimOWeooGimOWenOGimOog5nLGiaOW5nLOmaOW7oLGh00_l02g5nLGiaOW5nLGko00Q<
00WoC4a<odcoC?l02d`00ol0000400001P000om<C007C0Ko00=<od`02D`2o`WO1Ol00moog`0;g`0:
oimOWenOGimOW`Ko01MOWonOGimOWenOGioom7kdO_Anm7kdOP05o`0>O_AnogkdO_Anm7kdO_l9C0Ko
00=<od`02T`00ooOg`07g`Go00?Ooml02ml02_mOWenOGimOWel6o`0GWeooGimOWenOGimOogkdO_An
m7kdO_@01Ol03_Anm?odO_Anm7kdO_Co2D`6o`03C?m<00Y<00?o0000100000H000?oC4`03D`2o`Y<
0_l>g`;o3=l04?nOGimOWenOGimOWenOGil2o`0JGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGh3o`0;
OW5nLGiaOW5nLOl03d`2o`]<00?ogml03=l2o`cO013oGimOWenOGimOWenOGimO0_l06YmOWenOGimO
WeooLGiaOW5nLGiaOW5nLGia0ol02g5nLGiaOW5nLGko00m<0_l;C003o`0000@000060003oda<01U<
0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?ogml06]l0>_mOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@0
00060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenO
GimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?ogml0
6]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@000060003oda<01U<
0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?ogml06]l0>_mOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@0
00060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenO
GimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?ogml0
6]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lLC003o`0000@000060003oda<01U<0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@000060?oo1Ol60000
1P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO00?ogml06Ml0>omnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01cO00?ogml06Ml0>oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o00H0
0006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l00ooOg`0Ig`0kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07=l00ooOg`0Ig`0k
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
1P0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`03omoO01WO03_oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Lg`03omoO01WO
03_oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO00?ogml06Ml0>oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01cO00?ogml0
6Ml0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko00H00006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l00ooOg`0Ig`0kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07=l00ooO
g`0Ig`0kog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl01P0000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`03omoO01WO03_om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Lg`03
omoO01WO03_oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Ano`0600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO00?ogml06Ml0>omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01cO
00?ogml06Ml0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o00H00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l00ooOg`0Ig`0k
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
7=l00ooOg`0Ig`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l01P0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`03omoO01WO
03_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Lg`03omoO01WO03_oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO00?ogml0
6Ml0>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co01cO00?ogml06Ml0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko00H00006000:ogiaOW5nLGiaOP?o00mnLGiaOW5nLGiaOW5nLGh00_l9g`?o
4=l00ooOg`07g`?o3ml02omnLGiaOW5nLGia00?o01UaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGia00?o
015aOW5nLGiaOW5nLGiaOW5no`09g`?o4=l00ooOg`07g`?o3ml02omaOW5nLGiaOW5n00?o01UnLGia
OW5nLGiaOW5nLGkoOW5nLGiaOW5n00?o015nLGiaOW5nLGiaOW5nLGiao`0600001P007?odO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdO_@2o`cO00?ogml03Ml00ooOg`0:g`03omoO00cO03_om7kdO_Anm7kd
O_Anm?odO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdo`0<g`03omoO00gO
00?ogml02]l00ooOg`0<g`0kogkdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_An
ogkdO_Anm7kdO_Anm7kdO_l01P0000H000[oOW5nLGiaOW5n1?l03W7ooomaOW5nLGiaOW5n0_l9g`Co
00COoooo2ml00ooOg`07g`Co00COoooo2]l02omnLGiaOW5nLGia00Co01QnooooOW5nLGiaOW5nLOma
OW5nLGiaOW44o`0@O_ooogiaOW5nLGiaOW5no`WO1?l01=ooool;g`03omoO00OO1?l01=ooool:g`0;
og5nLGiaOW5nLGh01?l0677ooomaOW5nLGiaOW5nogiaOW5nLGiaOPCo011aooooLGiaOW5nLGiaOW7o
1P0000H001com7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kd0_l8g`05omoOgol00]l00ooOg`0:g`03
omoO00KO00GogmoOo`02g`03omoO00WO03_om7kdO_Anm7kdooAnm?odO_AnogkdO_Anm7kdO_mnm7kd
O_Anm?odO_Com7kdO_mnm7kdO_Anm7kdo`08g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoO
o`02g`03omoO00WO03_oO_Anm7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm?odO_Anm7kdO_mnm7koO_An
m?odO_Anm7kdO_Ano`0600001P007?mnLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGh2o`SO00GogmoO
o`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml02Ml0>omnLGiaOW5nLGkoOW5nogiaOW7o
LGiaOW5nLGiaog5nLGiaOW5nogiaO_mnLGiaog5nLGiaOW5nLGko00SO00GogmoOo`02g`03omoO00[O
00?ogml01]l01OoOgmoo00;O00?ogml02Ml0>omaOW5nLGiaOW7oLGiaog5nLGkoOW5nLGiaOW5nogia
OW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW7o00H00006000@ooAnm7kdO_AnogkdO_mnm0;o00Ynm7kd
O_Anm7kd0_l8g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO017om7kd
O_Anm7kdooAnm?odOP02o`0Jm7kdO_Anm7kdO_mnm7kdO_Anm?odO_Com7h2o`0<m7kdO_Anm7kdO_Co
2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`0AogkdO_Anm7kdO_mn
m7koO_@00_l06WkdO_Anm7kdO_Com7kdO_Anm7koO_Anogkd0_l037kdO_Anm7kdO_Ano`H00006000:
ogiaOW5nLGiaOPGo00enLGkoOW5nLGiaOW5n00;o2Ml5o`03gooO00_O00?ogml01ml5o`03gooO00[O
00_oOW5nLGiaOW5nL@05o`0GLGiaog5nLGiaOW5nLOmaOW5nLGiaOW401Ol03g5nLOmaOW5nLGiaOW5n
o`09g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02]l02omaOW5nLGiaOW5n00Go01MnLGkoOW5nLGia
OW5nogiaOW5nLGiaOP05o`0?OW5nogiaOW5nLGiaOW7o00H00006000?ooAnm7kdO_Anm7kdO_An00?o
00Ynm7kdO_Anm7kd0_l>g`;o3=l00ooOg`0<g`;o2ml04?odO_Anm7kdO_Anm7kdO_@3o`0Im7kdO_An
m7kdO_mnm7kdO_Anm7kdO_Anm003o`0<m7kdO_Anm7kdO_Co3]l2o`cO00?ogml03=l2o`_O013oO_An
m7kdO_Anm7kdO_An0ol06GkdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7h00ol037kdO_Anm7kdO_Ano`H0
0006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l00ooOg`0Ig`0kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07=l00ooOg`0Ig`0k
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
1P0000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`03omoO01WO03_om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Lg`03omoO01WO
03_oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO00?ogml06Ml0>omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01cO00?ogml0
6Ml0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o00H00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l00ooOg`0Ig`0kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07=l00ooO
g`0Ig`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l01P0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`03omoO01WO03_oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Lg`03
omoO01WO03_oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO00?ogml06Ml0>ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01cO
00?ogml06Ml0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko00H00006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l00ooOg`0Ig`0k
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
7=l00ooOg`0Ig`0kog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl01P0000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`03omoO01WO
03_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0Lg`03omoO01WO03_oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO00?ogml0
6Ml0>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko01cO00?ogml06Ml0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o00H00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l00ooO
g`0Ig`0kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l07=l00ooOg`0Ig`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l01P0000H0ool5o`H00006000LoimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO01koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWolLg`0MoenOGimOWenOGimOWenOGimOWenOGimOWenOGol07=l07_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOo`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO01koGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolLg`0MoenOGimOWenOGimOWenOGimOWenOGimOWenOGol07=l07_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOo`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnO
GimOWenOGimOWenOGimOWenOGimOWenOGioo01cO01koGimOWenOGimOWenOGimOWenOGimOWenOGimO
WolLg`0MoenOGimOWenOGimOWenOGimOWenOGimOWenOGol07=l07_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOo`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenO
GimOWenOGimOWenOGimOWenOGioo01cO01koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`0M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGol07=l07_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOo`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01cO01koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`0MoenOGimO
WenOGimOWenOGimOWenOGimOWenOGol07=l07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H0
0006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01cO01koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`0MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGol07=l07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000L
oimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo01cO01koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`0MoenOGimOWenOGimOWenOGimO
WenOGimOWenOGol07=l07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000LoimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO
01koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`0MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGol07=l07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000LoimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO01koGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolLg`0MoenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
7=l07_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000:oimOWenOGimOW`?o00nOGimO
WenOGimOWenOGil00_l9g`?o4=l02_nOGimOWenOGil3o`0@WenOGimOWenOGimOWenOo`[O0ol?g`0:
oenOGimOWenOG`?o015OWenOGimOWenOGimOWenOo`09g`?o4=l02_mOWenOGimOWel3o`0@GimOWenO
GimOWenOGimOo`[O0ol?g`0:oimOWenOGimOW`?o016OGimOWenOGimOWenOGimOo`0600001P007?nO
GimOWenOGimOWeooGimOWenOGimOWenOGil2o`cO00?ogml03Ml07OnOGimOWenOGimOWeooGimOWenO
GimOWenOGioo00gO00?ogml03=l07_mOWenOGimOWenOGiooWenOGimOWenOGimOWenOo`cO00?ogml0
3Ml07OmOWenOGimOWenOGiooWenOGimOWenOGimOWeoo00gO00?ogml03=l07_nOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOo`H00006000:oimOWenOGimOW`Co00=Oool00_l02ImOWenOGimOW`02o`WO
1?l01=ooool;g`0:oimOWenOGimOW`Co00=Oool00_l02YmOWenOGimOWol:g`Co00COoooo2]l02_mO
WenOGimOWel4o`03Wooo00;o00]OWenOGimOWenOo`09g`Co00COoooo2ml02_mOWenOGimOWel4o`03
Wooo00;o00YOWenOGimOWeoo2]l4o`04goooo`[O00[oWenOGimOWenO1?l00eooo`02o`0;WenOGimO
WenOGol01P0000H001coWenOGimOWeooGimOoenOoimOWenOGimOWenO0_l8g`05omoOgol00]l00ooO
g`0:g`0MoimOWenOGimOoenOGomOWonOGimOWenOGimOWol02Ml01OoOgmoo00;O00?ogml02Ml07_mO
WenOGimOWonOGiooWeooGimOWenOGimOWenOo`SO00GogmoOo`02g`03omoO00[O01goGimOWenOGioo
WenOoimOoenOGimOWenOGimOo`09g`05omoOgol00]l00ooOg`09g`0NoimOWenOGimOoenOGomOWonO
GimOWenOGimOWeoo1P0000H001coWenOGimOWeooGimOoenOGomOWenOGimOWenO0_l8g`05omoOgol0
0]l00ooOg`0:g`0MoimOWenOGimOoenOGomOWeooGimOWenOGimOWol02Ml01OoOgmoo00;O00?ogml0
2Ml07_mOWenOGimOWonOGiooWenOoimOWenOGimOWenOo`SO00GogmoOo`02g`03omoO00[O01goGimO
WenOGiooWenOoimOWonOGimOWenOGimOo`09g`05omoOgol00]l00ooOg`09g`0NoimOWenOGimOoenO
GomOWeooGimOWenOGimOWeoo1P0000H001coWenOGimOWeooGimOoenOGiooWenOGimOWenO0_l8g`05
omoOgol00]l00ooOg`0:g`0MoimOWenOGimOoenOGomOWenOoimOWenOGimOWol02Ml01OoOgmoo00;O
00?ogml02Ml07_mOWenOGimOWonOGiooWenOGomOWenOGimOWenOo`SO00GogmoOo`02g`03omoO00[O
01goGimOWenOGiooWenOoimOWeooGimOWenOGimOo`09g`05omoOgol00]l00ooOg`09g`0NoimOWenO
GimOoenOGomOWenOoimOWenOGimOWeoo1P0000H000[oWenOGimOWenO1_l035nOoimOWenOGimOW`;o
2Ml5o`03gooO00_O00[oWenOGimOWenO1_l03EnOoimOWenOGimOWol02]l5o`03gooO00[O00[oGimO
WenOGimO1_l03YmOoenOGimOWenOGioo2Ml5o`03gooO00_O00[oGimOWenOGimO1_l03ImOoenOGimO
WenOGol02]l5o`03gooO00[O00[oWenOGimOWenO1_l03UnOoimOWenOGimOWeoo1P0000H0013oWenO
GimOWenOGimOWenO0_l02UnOGimOWenOGil2o`kO0_l<g`0@oimOWenOGimOWenOGimOW`;o00]OWenO
GimOWenOo`0?g`;o2ml04?mOWenOGimOWenOGimOWel2o`0<WenOGimOWenOGioo3]l2o`cO013oGimO
WenOGimOWenOGimO0_l02imOWenOGimOWeoo00oO0_l;g`0@oimOWenOGimOWenOGimOW`;o00aOWenO
GimOWenOGol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l07OmO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO01koWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l07OmOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo01cO01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol60000
1P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l07OmOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo01cO01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l07OmOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo01cO01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nOGimOWenO
GimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0N
oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l07OmOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01cO01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nOGimOWenOGimOWenO
GimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo7=l07OmOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO
01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nOGimOWenOGimOWenOGimOWenO
GimOWenOGil2oacO01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo7=l07OmOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO01koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oacO01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo7=l07OmOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO01koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO
01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo7=l07OmOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO01koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
7=l07OmOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO01koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0Lg`0NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l07OmO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01cO01koWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gol600001P3oo`Go1P0000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml0
6]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03
omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003
omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03
omoO01[O00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml0
6]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03
omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003
omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03
omoO01[O00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml0
6]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03
omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003
omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03
omoO01[O00?o0000100000H000?ogml01ml3o`oO0_l9g`?o4=l00ooOg`07g`?o3ml00ooOg`08g`?o
3ml00ooOg`07g`?o4=l00ooOg`07g`?o4=l00ooOg`07g`?o3ml00ooOg`08g`?o3ml00ooOg`07g`?o
4=l00ol0000400001P000ooOg`0:g`03omoO00cO0_l<g`03omoO00gO00?ogml02]l00ooOg`0<g`03
omoO00_O00?ogml03=l00ooOg`0:g`03omoO00gO00?ogml02]l00ooOg`0=g`03omoO00[O00?ogml0
3=l00ooOg`0;g`03omoO00cO00?ogml02]l00ooOg`0=g`03o`0000@000060003omoO00OO1?l01=oo
ool:g`;o2Ml4o`04goooo`_O00?ogml01ml4o`04goooo`[O00?ogml02=l4o`04goooo`[O00?ogml0
1ml4o`04goooo`_O00?ogml01ml4o`04goooo`_O00?ogml01ml4o`04goooo`[O00?ogml02=l4o`04
goooo`[O00?ogml01ml4o`04goooo`_O00?o0000100000H000?ogml01]l01OoOgmoo00;O00?ogml0
2Ml2o`SO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml02Ml00ooOg`07g`05
omoOgol00]l00ooOg`09g`03omoO00KO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O
00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`03omoO00OO00GogmoOo`02g`03omoO00WO
00?ogml01]l01OoOgmoo00;O00?ogml02]l00ol0000400001P000ooOg`06g`05omoOgol00]l00ooO
g`09g`;o2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`03omoO00OO
00GogmoOo`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol0
0]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO00?ogml01ml01OoOgmoo00;O00?ogml0
2Ml00ooOg`06g`05omoOgol00]l00ooOg`0:g`03o`0000@000060003omoO00KO00GogmoOo`02g`03
omoO00WO0_l8g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO00?ogml0
1ml01OoOgmoo00;O00?ogml02Ml00ooOg`06g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoO
o`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml02Ml00ooOg`07g`05omoOgol00]l00ooO
g`09g`03omoO00KO00GogmoOo`02g`03omoO00[O00?o0000100000H000?ogml01ml5o`03gooO00[O
0_l9g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02]l00ooOg`08g`Go00?Ooml02]l00ooOg`07g`Go
00?Ooml02ml00ooOg`07g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02]l00ooOg`08g`Go00?Ooml0
2]l00ooOg`07g`Go00?Ooml02ml00ol0000400001P000ooOg`0<g`;o2ml2o`kO0_l<g`03omoO00cO
0_l;g`03omoO00gO0_l;g`03omoO00cO0_l<g`03omoO00cO0_l<g`03omoO00cO0_l;g`03omoO00gO
0_l;g`03omoO00cO0_l<g`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooO
g`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO
00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0
000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooO
g`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO
00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0
000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooO
g`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO
00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0
000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooO
g`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000D0ool6o`H000050?oo
1_l600001P000ol0000H00?o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000
100000H000?o00005`001?l0oolLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@
D91@T52@D91@T52@D91@T52@D91@o`H000060003o`0001H000?o00000_lLg`0joimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ol0000E0004o`0000;o7=l0>_nOGimOWenO
GimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ol0
000D0003o`0000800_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol000040000
1P000ol0000C0003o`0000<00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@
D91@T52@D91@T52@D91@T52@D91@o`H000060003o`0000@00_l00`3oo`090003o`0000@00_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<
05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ol000050003o`3o00T0
00?o00001@02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@
D91@T52@D91@T53o1P0000H000?o00001P000ol000070003o`0000H00_lLg`0joimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ol000050003o`3o00L000?o00001`02o`WO
0ol@g`0:oimOWenOGimOW`?o01ZOGimOWenOGimOWenOGiooOW5nLGiaOW5nL@?o011aOW5nLGiaOW5n
LGiaOW7o2D`3oa1<00[o0`l33`<?0`l30ol06P<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>0ol06Pka
3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P0ol06J3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D9000ol04I1@
T52@D91@T52@D91@T53o00H000060003o`0000@00_l00`3oo`050003o`0000P00_l<g`03omoO00gO
03[oWenOGimOWenOGimOoenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7ko
34`00om<C00=C01GomH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`ok0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>3o00a@00?oD5003E000ol000040000
1P000ol0000=0003o`0000T00_l9g`Co00COoooo2ml02_nOGimOWenOGil4o`03Gooo00;o01BOGimO
WenOGiooOW5nLGiaOW5nL@Co00mnooooOW5nLGiaOW5nLOl02D`4o`9<0ol:C00:o`<?0`l33`<?0`Co
01T?oooo3`<?0`l33`<?0`oo3_4>l@ka3_4>00Co01Wa3_ool@ka3_4>l@ka3_oPX>2Ph:3PX>2P00Co
01SPX?nPh:3PX>2Ph:3PX?n@D91@T52@D904o`0@D93ooe2@D91@T52@D91@o`H000060003o`0000`0
00?o00002P02o`SO00GogmoOo`02g`03omoO00[O03[oWenOGimOWeooGimOoenOoimOWenOGimOWenO
ooAnm7kdO_Anm?odO_Com7kdO_mnm7kdO_Anm7ko24`01Om<C4co00=<00?oC4`02D`0EooF0mH3eP?F
0ol3eP?o0mH3e_oF0mH3eP?F0mH3o`j`3[0>/0j`ok0>/?n`ok0>o`j`3[0>/0j`3_nPh:3PX>2Ph:3o
X>2Poj3Pon2Ph:3PX>2Ph:3Po`08D007oe1@D?m@o`02D003oe1@00Q@00?o0000100000H000?o0000
2`000ol0000;00;o2=l01OoOgmoo00;O00?ogml02]l0>_nOGimOWenOGomOWeooGimOoenOGimOWenO
GiooOW5nLGiaOW5nogiaO_mnLGiaog5nLGiaOW5nLOl8C006oda<C?m<1?l:C01do`<?0`l33`<?o`l3
3ol?0`l3o`<?0`l33`<?0`oo3_4>l@ka3_7ol@kaoo7ol@ko3_4>l@ka3_4>on2Ph:3PX>2Ph?oPX>3o
h:3Pon2Ph:3PX>2Ph:3oT52@D91@T53oD91@oe3oD93oT52@D91@T52@D?l600001P000ol0000:0003
o`0000`00_l8g`05omoOgol00]l00ooOg`0:g`0]oimOWenOGimOoenOGomOWenOoimOWenOGimOWood
O_Anm7kdO_Com7kdooAn00;o00_dO_Anm7kdO_Ano`08C009oda<C?m<odco00]<00ooeP?F0mH3eP?o
0mH3o`<00ol06P?F0mH3eP?F0mH3o`j`3[0>/0j`ok0>/?n`0ol0:;0>/0j`3[0>/0koX>2Ph:3PX>2P
oj3PX?nPh:3oX>2Ph:3PX>2Ph?l8D005oe1@D?l00U02o`]@00?o0000100000H000?o00002@000ol0
000400?o1P02o`WO1Ol00moog`0;g`0:oimOWenOGimOW`Ko01MOWonOGimOWenOGiooOW5nLGiaOW5n
L@05o`0>LGiaog5nLGiaOW5nLOl9C0Ko00=<od`02T`02_l33`<?0`l33`<6o`0G3`<?0`l33`<?0`l3
3ol>l@ka3_4>l@h01_l05o4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P00Go01NPh:3oX>2Ph:3PX>2Poi1@
T52@D91@T006o`0>D93oT52@D91@T52@D?l600001P000ol000080003o`0000H000?o00001@02o`kO
0_l<g`0@oimOWenOGimOWenOGimOW`;o01YOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm0?o00_dO_An
m7kdO_Ano`0?C0;o2d`03ooF0mH3eP?F0mH3eP?F0`04o`0JeP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>
/0h3o`0I3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX004o`0:h:3PX>2Ph:3Po`m@0_l;D003o`0000@0
00060003o`0000L000?o000020000ol0000400;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ol000060003o`0000T000?o0000
1002oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`0000D0
00?o00002@000ol0o`0500;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@
D91@T52@D91@T52@D91@T52@D?l600001P000ol000040003o`0000X000?o0?l01@02oacO03[oWenO
GimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`0000<000?o00002P02o`03
0?oo00@00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@
D91@T52@D91@o`H000060003o`00008000?o00005002oacO03[oWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3Po`0LD003o`0000@000060005o`000?l05`02oacO03[oWenOGimOWenOGimOWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H000Co003o6002oacO03[oWenO
GimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`3o01T00_lLg`0joimOWenO
GimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H0000600;o
6P02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060?oo1Ol60000
8P02on`0003o0140003o0140003o0140003o0140003o0140003o0140003o0140003o0140003o0140
00090003o`0001X00_l:00;o5P000ol0002d00?o300000P000?o00006`000ol0000:0003o`000080
00?o000040000ol0002d0003o`0000/000080004o`0000Co1003o`<00ol200Go0P000ol0000200?o
1@000ol000020003o`0000L00_l00`3oo`040003o`0009/00_l00`3oo`090003o`3o00T000?o0000
2P0000P000?o00000P001?l00?l20007o`000?l0o`030005o`000?l010000ol000050003o`000080
00?o00000`000ol000070003o`3o00D000?o0000W0000ol0o`0;0003o`0000P000?o00002P0000P0
00?o00000P001?l00?l20007o`000?l0o`030005o`000?l010000ol000050003o`00008000?o0000
3P000ol000040003o`0009d000?o00002005o`L000?o0?l02`0000P000?o00000P03o`<000Oo0000
o`3o00<000Go0000o`040003o`0000<00_l50003o`0000d000?o0?l01@000ol0002L0003o`3o00/0
00?o00001`000ol0o`0;000020000ol000020004o`00o`<00ol300?o10000ol000020003o`0000D0
00?o00000P000ol0000<00;o00<0ool010000ol0002K00;o00<0ool04`02o`030?oo00X000090003
o`0000Co4@000ol0000200;o0`03o`@00_lF0003o`000<<0000O00?okP000?l04@000?l04@000001
\
\>"],
  ImageRangeCache->{{{0, 271.812}, {287, 0}} -> {-1.22505, -0.239038, 
  0.034767, 0.034767}},
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "An alternative to using ",
  StyleBox["MultiplicationTable", "MR"],
  " is to use ",
  StyleBox["CayleyTables", "MR"],
  " with the option ",
  StyleBox["Operation", "MR"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["Multiplication", "MR"],
  ". To get just the addition table, use the value ",
  StyleBox["Addition", "MR"],
  " for this option. (Note: ",
  StyleBox["CayleyTable", "MR"],
  ", without the ending ",
  StyleBox["s", "MR"],
  ", can also be used when a single operation is chosen.)"
}], "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[ZR[3], Operation\  \[Rule] \ Addition, 
      Mode \[Rule] Visual]; \)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(1)] .61905 .62202 0 0 Mshowa
[(2)] .85714 .62202 0 0 Mshowa
[(1)] .38095 .38393 0 0 Mshowa
[(2)] .61905 .38393 0 0 Mshowa
[(0)] .85714 .38393 0 0 Mshowa
[(2)] .38095 .14583 0 0 Mshowa
[(0)] .61905 .14583 0 0 Mshowa
[(1)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(1)] .14286 .38393 0 0 Mshowa
[(2)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(1)] .61905 .86012 0 0 Mshowa
[(2)] .85714 .86012 0 0 Mshowa
[(\\(Z[3], +\\))] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{256, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400040000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l00@000?l00@000?l00@000?l00@000?l0
0@000?l00@000?l00@0000H0lol700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?GiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?GiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?GiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?GiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0?=l0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000LogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOPCo01]aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l077iaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW44o`0MOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl07=l2oakO
01coWenOGimOWenOGimOWenOGimOWenOGimOWenO0ol07YmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOo`L00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7h00_l0?OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l06ml01?oOgolMg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01_O00Cogmoo7Ml0?OnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0Kg`04omoOoagO03goWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_mnLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?GiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl06ml01?oOgolMg`0moimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`070000
1P007OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o01cdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_An0_l07OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01inm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lLg`;o7]l07?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0OGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?Gia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?Gia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?Gia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02o`0mOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiao`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o03gdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l0?Gia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02o`0mm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0lg`0moimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o03enLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o03cO03goWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00L00006000kooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l0?OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
?=l0?OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01`0000H0lol700001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D0
0006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03
o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1j
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o0000
1@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O
00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol000050000
1P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000koimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0
000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
>ml00ol0000500001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil3o`0LWenOGimOWenOGimO
WenOGimOWenOGimOWenOG`;o01bOGimOWenOGimOWenOGimOWenOGimOWenOGimO0ol0>EnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@04o`0NOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko7=l2oagO00?o00001@0000H003_oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lKg`04omoOoacO
00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lKg`04omoOoacO00?o00001@0000H003_oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lKg`04omoOoacO
00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaO_mnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lKg`04omoOoacO00?o00001@0000H001coWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l07EnOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o01bOGimOWenOGimO
WenOGimOWenOGimOWenOGimO0_l0>imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01cO
0_lMg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o0000
1@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol0000500001P00>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O
00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0000500001P00>onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko>ml00ol000050000
1P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000koimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co>ml00ol0
000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0NYmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc_O00?o00001@0000H003_oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lkg`03o`0000D0
0006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_l0NYmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko>ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o07ZOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc_O00?o00001@0000H003_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`1jWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lkg`03
o`0000D000060??o1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003omoO03SO0_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l70000
1P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003omoO03SO0_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003omoO03SO
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?ogml0>=l2occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?ogml0>=l2occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?ogml0>=l2occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?ogml0
>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5no`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ooOg`0hg`;o?=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H0
00?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ooOg`0hg`;o?=l0N_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ooOg`0hg`;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko1`0000H000?ogml06]l2oacO0_lMg`;o7Ml07?mOWenOGimOWenOGimOWenOGimOWenOGimO
Wel3o`0jGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0Co01enm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0700001P000ooOg`0Ig`04omoOoa_O
0_lLg`04omoOoacO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`L000060003omoO01WO00Cogmoo6ml2oacO00Cogmoo7=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H0
00?ogml06Ml01?oOgolKg`;o7=l01?oOgolLg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ooOg`0Ig`04omoOoa_O0_lLg`04
omoOoacO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`L000060003omoO01[O0_lLg`;o7Ml2oagO01coGimOWenOGimOWenOGimOWenOGimO
WenOGimO0_l0?9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nL@;o01inLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ooOg`0hg`;o
?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003omoO03SO0_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ooO
g`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003omoO03SO0_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l70000
1P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003omoO03SO0_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?ogml0>=l2occO07[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003omoO03SO
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?ogml0>=l2occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?ogml0>=l2occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L0
00060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?ogml0>=l2occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5no`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ooOg`0hg`;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?ogml0
>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ooOg`0hg`;o?=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H0
00?ogml0>=l2occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`L000060003omoO03SO0_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001@3do`L000050?Co1`0000H0
00?o0000=`03occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`L000060003o`0003H000Co0?oo?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o0000=@000ol0
0002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5no`L000060003o`0003@000Co00000_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000c0003o`000080
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000b0003o`0000<00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000a0003o`0000@0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000`0003o`0000D00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000_0003o`0000H0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000^0003o`0000L00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000]0003o`0000P0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000/0003o`0000T00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000[0003o`0000X0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000Z0003o`0000/00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000Y0003o`0000`0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P000ol0000X0003o`0000d00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000>00;o00<0ool0
50000ol0000>00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00003`000ol0o`0D0003o`0000l00_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l70000
1P000ol0000@0003o`00018000?o00004002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0000l000?o0?l04P000ol0
000A00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1`0000H000?o00003P02o`030?oo010000?o00004P02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`00028000?o00004`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`00024000?o00005002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`00020000?o00005@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001l000?o00005P02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0001h000?o00005`02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001d000?o00006002oagO0_lMg`0LoenOGimO
WenOGimOWenOGimOWenOGimOWenOG`?o03YOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n1?l07G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L0
00060003o`0001`000?o00006@02oacO00Cogmoo7=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00006`000ol0000J00;o
7=l01?oOgolLg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol0000J0003o`0001/00_lLg`04omoOoacO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0001T000?o00007002oacO00Cogmoo7=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogia
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o000060000ol0000M00;o7Ml2oagO
01coGimOWenOGimOWenOGimOWenOGimOWenOGimO0_l0?9mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP;o01kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l700001P000ol0000G0003o`0001h00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000F0003o`0001l0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l700001P000ol0000E0003o`0002000_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000D0003o`000240
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l700001P000ol0000C0003o`0001400ol>00;o?=l0N_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00004P000ol0
000C0003o`0000d00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000A0003o`0001D000?o00003002occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`00010000?o00005P000ol0000<00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00003`000ol0000F0003
o`3o00d00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol0000>0003o`0001L000?o0?l03@02occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003
o`0000d000?o00005`02o`030?oo00`00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000<0003o`0002T00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol0000;0003o`0002X00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000:0003o`0002/00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol000090003o`0002`00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol000080003o`0002d00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol000070003o`0002h00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol000060003o`0002l00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol000050003o`0003000_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol000040003o`0003400_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol000030003o`0003800_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol000020003o`0003<00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P001Ol0003o03H00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P001?l00?lg00;o?=l0N_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o0?l0
>002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5no`L0000600;o>@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060??o1`0004400_nm0000o`010000o`010000
o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000
o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000
o`010000o`010000o`0100002@000ol0000800;o2P02oaH000?o0000]@03o`d000080003o`0000T0
00?o00002P000ol000020003o`00010000?o0000]@000ol0000<000020000ol0000200Co0`000ol0
000200?o1@000ol000020003o`0000X000?o00000`000ol0002L00;o00<0ool02P000ol000080003
o`0000/000080003o`0000<000?o0?l00`000ol000050003o`00008000?o00000`000ol000090003
o`0000<000?o0000W@000ol0o`0;0003o`0000P000?o00002`0000P000?o00000`000ol000030003
o`0000D000?o00000P000ol0000=00Go0`000ol0002N0003o`0000P01Ol70003o`3o00`000080003
o`0000@000?o00000P000ol0000300;o1@000ol0000?0003o`0000<000?o0000W@000ol0o`0;0003
o`0000L000?o0?l0300000P000?o00000P000ol0o`040003o`0000D000?o00000P000ol0000?0003
o`0000<000?o0000W002o`030?oo00X000?o00001P02o`030?oo00/000090004o`0000Co0`02o`<0
0ol400;o5P000ol000350000o`010000o`010000o`010000\
\>"],
  ImageRangeCache->{{{0, 255}, {287, 0}} -> {-1.10002, -0.113553, 0.0164708, 
  0.0164708}},
  CellTags->"Cayley"]
}, Open  ]],

Cell["\<\
Sometimes a density plot is an effective alternative to the visual \
mode.\
\>", "MathCaption",
  CellTags->{"Cayley", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[MultiplicationTable[ZR[19]]]; \)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0506073 0.0192308 0.0506073 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.14575 -0.0125 -9 -9 ]
[.14575 -0.0125 9 0 ]
[.27227 -0.0125 -3 -9 ]
[.27227 -0.0125 3 0 ]
[.39879 -0.0125 -9 -9 ]
[.39879 -0.0125 9 0 ]
[.5253 -0.0125 -6 -9 ]
[.5253 -0.0125 6 0 ]
[.65182 -0.0125 -12 -9 ]
[.65182 -0.0125 12 0 ]
[.77834 -0.0125 -6 -9 ]
[.77834 -0.0125 6 0 ]
[.90486 -0.0125 -12 -9 ]
[.90486 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .14575 -18 -4.5 ]
[-0.0125 .14575 0 4.5 ]
[-0.0125 .27227 -6 -4.5 ]
[-0.0125 .27227 0 4.5 ]
[-0.0125 .39879 -18 -4.5 ]
[-0.0125 .39879 0 4.5 ]
[-0.0125 .5253 -12 -4.5 ]
[-0.0125 .5253 0 4.5 ]
[-0.0125 .65182 -24 -4.5 ]
[-0.0125 .65182 0 4.5 ]
[-0.0125 .77834 -12 -4.5 ]
[-0.0125 .77834 0 4.5 ]
[-0.0125 .90486 -24 -4.5 ]
[-0.0125 .90486 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.14575 0 m
.14575 .00625 L
s
[(2.5)] .14575 -0.0125 0 1 Mshowa
.27227 0 m
.27227 .00625 L
s
[(5)] .27227 -0.0125 0 1 Mshowa
.39879 0 m
.39879 .00625 L
s
[(7.5)] .39879 -0.0125 0 1 Mshowa
.5253 0 m
.5253 .00625 L
s
[(10)] .5253 -0.0125 0 1 Mshowa
.65182 0 m
.65182 .00625 L
s
[(12.5)] .65182 -0.0125 0 1 Mshowa
.77834 0 m
.77834 .00625 L
s
[(15)] .77834 -0.0125 0 1 Mshowa
.90486 0 m
.90486 .00625 L
s
[(17.5)] .90486 -0.0125 0 1 Mshowa
.125 Mabswid
.04453 0 m
.04453 .00375 L
s
.06984 0 m
.06984 .00375 L
s
.09514 0 m
.09514 .00375 L
s
.12045 0 m
.12045 .00375 L
s
.17105 0 m
.17105 .00375 L
s
.19636 0 m
.19636 .00375 L
s
.22166 0 m
.22166 .00375 L
s
.24696 0 m
.24696 .00375 L
s
.29757 0 m
.29757 .00375 L
s
.32287 0 m
.32287 .00375 L
s
.34818 0 m
.34818 .00375 L
s
.37348 0 m
.37348 .00375 L
s
.42409 0 m
.42409 .00375 L
s
.44939 0 m
.44939 .00375 L
s
.4747 0 m
.4747 .00375 L
s
.5 0 m
.5 .00375 L
s
.55061 0 m
.55061 .00375 L
s
.57591 0 m
.57591 .00375 L
s
.60121 0 m
.60121 .00375 L
s
.62652 0 m
.62652 .00375 L
s
.67713 0 m
.67713 .00375 L
s
.70243 0 m
.70243 .00375 L
s
.72773 0 m
.72773 .00375 L
s
.75304 0 m
.75304 .00375 L
s
.80364 0 m
.80364 .00375 L
s
.82895 0 m
.82895 .00375 L
s
.85425 0 m
.85425 .00375 L
s
.87955 0 m
.87955 .00375 L
s
.93016 0 m
.93016 .00375 L
s
.95547 0 m
.95547 .00375 L
s
.98077 0 m
.98077 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .14575 m
.00625 .14575 L
s
[(2.5)] -0.0125 .14575 1 0 Mshowa
0 .27227 m
.00625 .27227 L
s
[(5)] -0.0125 .27227 1 0 Mshowa
0 .39879 m
.00625 .39879 L
s
[(7.5)] -0.0125 .39879 1 0 Mshowa
0 .5253 m
.00625 .5253 L
s
[(10)] -0.0125 .5253 1 0 Mshowa
0 .65182 m
.00625 .65182 L
s
[(12.5)] -0.0125 .65182 1 0 Mshowa
0 .77834 m
.00625 .77834 L
s
[(15)] -0.0125 .77834 1 0 Mshowa
0 .90486 m
.00625 .90486 L
s
[(17.5)] -0.0125 .90486 1 0 Mshowa
.125 Mabswid
0 .04453 m
.00375 .04453 L
s
0 .06984 m
.00375 .06984 L
s
0 .09514 m
.00375 .09514 L
s
0 .12045 m
.00375 .12045 L
s
0 .17105 m
.00375 .17105 L
s
0 .19636 m
.00375 .19636 L
s
0 .22166 m
.00375 .22166 L
s
0 .24696 m
.00375 .24696 L
s
0 .29757 m
.00375 .29757 L
s
0 .32287 m
.00375 .32287 L
s
0 .34818 m
.00375 .34818 L
s
0 .37348 m
.00375 .37348 L
s
0 .42409 m
.00375 .42409 L
s
0 .44939 m
.00375 .44939 L
s
0 .4747 m
.00375 .4747 L
s
0 .5 m
.00375 .5 L
s
0 .55061 m
.00375 .55061 L
s
0 .57591 m
.00375 .57591 L
s
0 .60121 m
.00375 .60121 L
s
0 .62652 m
.00375 .62652 L
s
0 .67713 m
.00375 .67713 L
s
0 .70243 m
.00375 .70243 L
s
0 .72773 m
.00375 .72773 L
s
0 .75304 m
.00375 .75304 L
s
0 .80364 m
.00375 .80364 L
s
0 .82895 m
.00375 .82895 L
s
0 .85425 m
.00375 .85425 L
s
0 .87955 m
.00375 .87955 L
s
0 .93016 m
.00375 .93016 L
s
0 .95547 m
.00375 .95547 L
s
0 .98077 m
.00375 .98077 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.14575 .99375 m
.14575 1 L
s
.27227 .99375 m
.27227 1 L
s
.39879 .99375 m
.39879 1 L
s
.5253 .99375 m
.5253 1 L
s
.65182 .99375 m
.65182 1 L
s
.77834 .99375 m
.77834 1 L
s
.90486 .99375 m
.90486 1 L
s
.125 Mabswid
.04453 .99625 m
.04453 1 L
s
.06984 .99625 m
.06984 1 L
s
.09514 .99625 m
.09514 1 L
s
.12045 .99625 m
.12045 1 L
s
.17105 .99625 m
.17105 1 L
s
.19636 .99625 m
.19636 1 L
s
.22166 .99625 m
.22166 1 L
s
.24696 .99625 m
.24696 1 L
s
.29757 .99625 m
.29757 1 L
s
.32287 .99625 m
.32287 1 L
s
.34818 .99625 m
.34818 1 L
s
.37348 .99625 m
.37348 1 L
s
.42409 .99625 m
.42409 1 L
s
.44939 .99625 m
.44939 1 L
s
.4747 .99625 m
.4747 1 L
s
.5 .99625 m
.5 1 L
s
.55061 .99625 m
.55061 1 L
s
.57591 .99625 m
.57591 1 L
s
.60121 .99625 m
.60121 1 L
s
.62652 .99625 m
.62652 1 L
s
.67713 .99625 m
.67713 1 L
s
.70243 .99625 m
.70243 1 L
s
.72773 .99625 m
.72773 1 L
s
.75304 .99625 m
.75304 1 L
s
.80364 .99625 m
.80364 1 L
s
.82895 .99625 m
.82895 1 L
s
.85425 .99625 m
.85425 1 L
s
.87955 .99625 m
.87955 1 L
s
.93016 .99625 m
.93016 1 L
s
.95547 .99625 m
.95547 1 L
s
.98077 .99625 m
.98077 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .14575 m
1 .14575 L
s
.99375 .27227 m
1 .27227 L
s
.99375 .39879 m
1 .39879 L
s
.99375 .5253 m
1 .5253 L
s
.99375 .65182 m
1 .65182 L
s
.99375 .77834 m
1 .77834 L
s
.99375 .90486 m
1 .90486 L
s
.125 Mabswid
.99625 .04453 m
1 .04453 L
s
.99625 .06984 m
1 .06984 L
s
.99625 .09514 m
1 .09514 L
s
.99625 .12045 m
1 .12045 L
s
.99625 .17105 m
1 .17105 L
s
.99625 .19636 m
1 .19636 L
s
.99625 .22166 m
1 .22166 L
s
.99625 .24696 m
1 .24696 L
s
.99625 .29757 m
1 .29757 L
s
.99625 .32287 m
1 .32287 L
s
.99625 .34818 m
1 .34818 L
s
.99625 .37348 m
1 .37348 L
s
.99625 .42409 m
1 .42409 L
s
.99625 .44939 m
1 .44939 L
s
.99625 .4747 m
1 .4747 L
s
.99625 .5 m
1 .5 L
s
.99625 .55061 m
1 .55061 L
s
.99625 .57591 m
1 .57591 L
s
.99625 .60121 m
1 .60121 L
s
.99625 .62652 m
1 .62652 L
s
.99625 .67713 m
1 .67713 L
s
.99625 .70243 m
1 .70243 L
s
.99625 .72773 m
1 .72773 L
s
.99625 .75304 m
1 .75304 L
s
.99625 .80364 m
1 .80364 L
s
.99625 .82895 m
1 .82895 L
s
.99625 .85425 m
1 .85425 L
s
.99625 .87955 m
1 .87955 L
s
.99625 .93016 m
1 .93016 L
s
.99625 .95547 m
1 .95547 L
s
.99625 .98077 m
1 .98077 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
19 string
19 19 8 [19 0 0 19 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00000000000000000000000000000000000000
000E1C2A3847556371808E9CAAB8C7D5E3F1FF
001C3855718EAAC7E3FF0E2A4763809CB8D5F1
002A5580AAD5FF1C47719CC7F10E38638EB8E3
003871AAE30E4780B8F11C558EC7FF2A639CD5
00478ED50E559CE31C63AAF12A71B8FF3880C7
0055AAFF479CF1388EE32A80D51C71C70E63B8
0063C71C80E3389CFF55B80E71D52A8EF147AA
0071E347B81C8EFF63D538AA0E80F155C72A9C
0080FF71F163E355D547C738B82AAA1C9C0E8E
008E0E9C1CAA2AB838C747D555E363F171FF80
009C2AC755F1800EAA38D563FF8E1CB847E371
00AA47F18E2AD5710EB855FF9C38E3801CC763
00B8630EC7711CD5802AE38E38F19C47FFAA55
00C78038FFB8712AF1AA631CE39C550ED58E47
00D59C632AFFC78E551CF1B880470EE3AA7138
00E3B88E63380EF1C79C71471CFFD5AA80552A
00F1D5B89C8063472A0EFFE3C7AA8E7155381C
00FFF1E3D5C7B8AA9C8E8071635547382A1C0E
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.06984 .01923 m
.06984 .98077 L
s
.12045 .01923 m
.12045 .98077 L
s
.17105 .01923 m
.17105 .98077 L
s
.22166 .01923 m
.22166 .98077 L
s
.27227 .01923 m
.27227 .98077 L
s
.32287 .01923 m
.32287 .98077 L
s
.37348 .01923 m
.37348 .98077 L
s
.42409 .01923 m
.42409 .98077 L
s
.4747 .01923 m
.4747 .98077 L
s
.5253 .01923 m
.5253 .98077 L
s
.57591 .01923 m
.57591 .98077 L
s
.62652 .01923 m
.62652 .98077 L
s
.67713 .01923 m
.67713 .98077 L
s
.72773 .01923 m
.72773 .98077 L
s
.77834 .01923 m
.77834 .98077 L
s
.82895 .01923 m
.82895 .98077 L
s
.87955 .01923 m
.87955 .98077 L
s
.93016 .01923 m
.93016 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .06984 m
.98077 .06984 L
s
.01923 .12045 m
.98077 .12045 L
s
.01923 .17105 m
.98077 .17105 L
s
.01923 .22166 m
.98077 .22166 L
s
.01923 .27227 m
.98077 .27227 L
s
.01923 .32287 m
.98077 .32287 L
s
.01923 .37348 m
.98077 .37348 L
s
.01923 .42409 m
.98077 .42409 L
s
.01923 .4747 m
.98077 .4747 L
s
.01923 .5253 m
.98077 .5253 L
s
.01923 .57591 m
.98077 .57591 L
s
.01923 .62652 m
.98077 .62652 L
s
.01923 .67713 m
.98077 .67713 L
s
.01923 .72773 m
.98077 .72773 L
s
.01923 .77834 m
.98077 .77834 L
s
.01923 .82895 m
.98077 .82895 L
s
.01923 .87955 m
.98077 .87955 L
s
.01923 .93016 m
.98077 .93016 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@0001l00_lH00Co0`02o`<00olG00?o6@000ol0
000300;o0`03oaD00ol400;o4P03o`<01?l300;o0`03oa800ol300?o4P03o`@000?o00000`02o`<0
0ol@00007P001?l00?lH0003o`0000<00_l60003o`0001L000?o00005P000ol0000300;o1P000ol0
000C0003o`00008000Co003o4P000ol000030003o`0000<00_l60003o`00010000?o00001@000ol0
000@0003o`0000<000?o00000`02o`H000?o00003@0001h000Co003o6@000ol0000:0003o`0001L0
00?o00005`000ol0000:0003o`0001<000?o00000P001?l00?lB0003o`0000@000?o00002P000ol0
000@0003o`0000D000?o000040000ol000040003o`0000X000?o00003@0001h000Co003o6P000ol0
000600?o5`03oaX000?o00001`03oaH000?o00000P001?l00?lB0003o`0000D000?o00001P03oa<0
00?o00000P03oa<000?o000010000ol0000700?o400001h000Co003o5`001?l00?l80003o`0001L0
00?o00006`000ol000060003o`0001H000?o00000P001?l00?lB0003o`00008000Co003o20000ol0
000C0003o`00008000?o00004`000ol000050003o`0000H000?o0000400001l00_lI00;o2@04oaH0
1?lG00Co2004oa@00_l500;o4P02o`D00_l900Co4@02o`@01?lA00;o1004o`P01?l?0000o`0Q0000
o`0Q0000o`0Q0000o`0Q00006`3oo`Go0@0001/000?o00000P000ol000030003o`0000@000?o0000
0`000ol000040003o`0000@000?o00000`000ol000040003o`0000<000?o000010000ol000030003
o`0000@000?o000010000ol000030003o`0000@000?o00000`000ol000040003o`0000<000?o0000
10000ol000040003o`0000<000?o000010000ol000030003o`0000@000?o00000`000ol000040003
o`0000@000?o00000`000ol000040003o`0000<000?o000010000ol000030003o`0000@000?o0000
10000ol000030003o`0000@000?o00000`000ol000040003o`0000<000?o00000P01o`40000K0003
o`00008000?o00007P000ol0000M0003o`0001h000?o00007P000ol0000N0003o`0001h000?o0000
7P000ol0000E007o0@0001@00_l50003o`000?l00@01o`40000C0004o`00o`@000?o0000o`01007o
0@0001<000Co003o1002o`<0n_l300;o0@0001<000Co003o10000ol000020?[o1001o`40000C0004
o`00o`@000?o00000P3jo`@00Ol100005002o`D000?o00000P3jo`@00Ol100006`000ol000020?[o
1001o`40000K0003o`000080n_l4007o0@0001/000?o00000P3jo`@00Ol100006`02o`<0n_l300;o
0@0001/000?o00000P3jo`@00Ol100006`000ol000020?[o1001o`40000K0003o`000080n_l4007o
0@0001/000?o00000P3jo`@00Ol100006`000ol000020?[o1001o`40000K00;o0`3jo`<00_l10000
6`000ol0000200ko36<00onCT`0:T`03om?C00[C00?o10@02P@00om4A00;A003of5Q00YQ00?oZJT0
2ZT00oodm00:m003obXZ00XZ00?oIFD02VD00onUY@0:Y@03omGE00[E00<FoaH02QH00eKoEP0;EP03
ohJ600Z600?oa/H02/H00oofmP0:mP03o`0000X000?o00000P01o`40000K0003o`0000803_l<H`03
oi>C00ZC00?odm<02]<00ol4100:1003odA400]400?oHF402V400onYZ@0:Z@03ooCd00[d00?o:RX0
2RX00omUI@0:I@03ojFU00ZU00?oeMD02]D00aKo5P0:5P03E_mF00]F00?oQXH02XH00oo6aP0:aP03
ooKf00[f00?o00002P000ol00002007o0@0001/000?o00000P0>o`aS00?oTi<02Y<00ooCd`0:d`03
o`@400X400?oA4@02d@00omQH@0:H@03ojVY00ZY00?om?@02_@00olZ:P0::P03ofEU00YU00?oYJD0
2ZD00ooEe@0:e@035_lF00XF00=FoeH02eH00on6QP0:QP03olK600[600?om_H02_H00ol0000:0003
o`0000800Ol100006`000ol0000200ko36<00onCT`0:T`03om?C00[C00?o10@02P@00om4A00;A003
of5Q00YQ00?oZJT02ZT00oodm00:m003obXZ00XZ00?oIFD02VD00onUY@0:Y@03omGE00[E00<FoaH0
2QH00eKoEP0;EP03ohJ600Z600?oa/H02/H00oofmP0:mP03o`0000X000?o00000P01o`40000K0003
o`0000803_l<H`03oi>C00ZC00?odm<02]<00ol4100:1003odA400]400?oHF402V400onYZ@0:Z@03
ooCd00[d00?o:RX02RX00omUI@0:I@03ojFU00ZU00?oeMD02]D00aKo5P0:5P03E_mF00]F00?oQXH0
2XH00oo6aP0:aP03ooKf00[f00?o00002P000ol00002007o0@0001/000?o00000P0>o`aS00?oTi<0
2Y<00ooCd`0:d`03o`@400X400?oA4@02d@00omQH@0:H@03ojVY00ZY00?om?@02_@00olZ:P0::P03
ofEU00YU00?oYJD02ZD00ooEe@0:e@035_lF00XF00=FoeH02eH00on6QP0:QP03olK600[600?om_H0
2_H00ol0000:0003o`0000800Ol100006`02o`<03_l<H`03oi>C00ZC00?odm<02]<00ol4100:1003
odA400]400?oHF402V400onYZ@0:Z@03ooCd00[d00?o:RX02RX00omUI@0:I@03ojFU00ZU00?oeMD0
2]D00aKo5P0:5P03E_mF00]F00?oQXH02XH00oo6aP0:aP03ooKf00[f00?o00002P001?l00002o`40
000K0003o`0000803_l<H`03oi>C00ZC00?odm<02]<00ol4100:1003odA400]400?oHF402V400onY
Z@0:Z@03ooCd00[d00?o:RX02RX00omUI@0:I@03ojFU00ZU00?oeMD02]D00aKo5P0:5P03E_mF00]F
00?oQXH02XH00oo6aP0:aP03ooKf00[f00?o00002P000ol00002007o0@0001/000?o00000P0>o`aS
00?oTi<02Y<00ooCd`0:d`03o`@400X400?oA4@02d@00omQH@0:H@03ojVY00ZY00?om?@02_@00olZ
:P0::P03ofEU00YU00?oYJD02ZD00ooEe@0:e@035_lF00XF00=FoeH02eH00on6QP0:QP03olK600[6
00?om_H02_H00ol0000:0003o`0000800Ol100006`000ol0000200ko36<00onCT`0:T`03om?C00[C
00?o10@02P@00om4A00;A003of5Q00YQ00?oZJT02ZT00oodm00:m003obXZ00XZ00?oIFD02VD00onU
Y@0:Y@03omGE00[E00<FoaH02QH00eKoEP0;EP03ohJ600Z600?oa/H02/H00oofmP0:mP03o`0000X0
00?o00000P01o`40000K0003o`0000803_l<H`03oi>C00ZC00?odm<02]<00ol4100:1003odA400]4
00?oHF402V400onYZ@0:Z@03ooCd00[d00?o:RX02RX00omUI@0:I@03ojFU00ZU00?oeMD02]D00aKo
5P0:5P03E_mF00]F00?oQXH02XH00oo6aP0:aP03ooKf00[f00?o00002P000ol00002007o0@0001/0
00?o00000P0>o`aS00?oTi<02Y<00ooCd`0:d`03o`@400X400?oA4@02d@00omQH@0:H@03ojVY00ZY
00?om?@02_@00olZ:P0::P03ofEU00YU00?oYJD02ZD00ooEe@0:e@035_lF00XF00=FoeH02eH00on6
QP0:QP03olK600[600?om_H02_H00ol0000:0003o`0000800Ol100006`000ol0000200ko36<00onC
T`0:T`03om?C00[C00?o10@02P@00om4A00;A003of5Q00YQ00?oZJT02ZT00oodm00:m003obXZ00XZ
00?oIFD02VD00onUY@0:Y@03omGE00[E00<FoaH02QH00eKoEP0;EP03ohJ600Z600?oa/H02/H00oof
mP0:mP03o`0000X000?o00000P01o`40000K00;o0`3jo`<00_l100006`000ol0000200ko39<00ol4
100:1003of5Q00YQ00?om?@02_@00omUI@0;I@03omGE00[E00?oEUH02UH00oo6aP0:aP03o`0000X0
00?oHf<02V<00ooCd`0:d`03odA400Y400>YojT02ZT00b[o:P0;:P03ojFU00ZU00?o5QH02QH00on6
QP0:QP03ooKf00[f00?o00000P01o`40000K0003o`0000803_l<T`03o`@400X400?oHF402V400ood
m00:m003ofEU00]U00?oeMD02]D00omFEP0:EP03olK600[600?o00002P000omSH`0:H`03om?C00[C
00?oA4@02T@00jWoZ@0:Z@03:_lZ00/Z00?oYJD02ZD00olF5P0:5P03ohJ600Z600?om_H02_H00ol0
0002007o0@0001/000?o00000P0>o`bC00?o10@02P@00omQH@0:H@03ooCd00[d00?oIFD02fD00ooE
e@0:e@03oeIF00YF00?oa/H02/H00ol0000:0003of=S00YS00?odm<02]<00om4A00:A003ZOnY00ZY
00<ZobX02bX00onUY@0:Y@03oaHF00XF00?oQXH02XH00oofmP0:mP03o`0000800Ol100001`04o`<0
0_l300?o1@000ol0000200ko39<00ol4100:1003of5Q00YQ00?om?@02_@00omUI@0;I@03omGE00[E
00?oEUH02UH00oo6aP0:aP03o`0000X000?oHf<02V<00ooCd`0:d`03odA400Y400>YojT02ZT00b[o
:P0;:P03ojFU00ZU00?o5QH02QH00on6QP0:QP03ooKf00[f00?o00000P01o`4000080003o`0000<0
0_l60003o`00008000?o00000P0>o`bC00?o10@02P@00omQH@0:H@03ooCd00[d00?oIFD02fD00ooE
e@0:e@03oeIF00YF00?oa/H02/H00ol0000:0003of=S00YS00?odm<02]<00om4A00:A003ZOnY00ZY
00<ZobX02bX00onUY@0:Y@03oaHF00XF00?oQXH02XH00oofmP0:mP03o`0000800Ol100002@000ol0
000:0003o`0000800_l300ko39<00ol4100:1003of5Q00YQ00?om?@02_@00omUI@0;I@03omGE00[E
00?oEUH02UH00oo6aP0:aP03o`0000X000?oHf<02V<00ooCd`0:d`03odA400Y400>YojT02ZT00b[o
:P0;:P03ojFU00ZU00?o5QH02QH00on6QP0:QP03ooKf00[f00Co00000_l100002P000ol0000600?o
1@000ol0000200ko39<00ol4100:1003of5Q00YQ00?om?@02_@00omUI@0;I@03omGE00[E00?oEUH0
2UH00oo6aP0:aP03o`0000X000?oHf<02V<00ooCd`0:d`03odA400Y400>YojT02ZT00b[o:P0;:P03
ojFU00ZU00?o5QH02QH00on6QP0:QP03ooKf00[f00?o00000P01o`4000070004o`00o`P000?o0000
1@000ol0000200ko39<00ol4100:1003of5Q00YQ00?om?@02_@00omUI@0;I@03omGE00[E00?oEUH0
2UH00oo6aP0:aP03o`0000X000?oHf<02V<00ooCd`0:d`03odA400Y400>YojT02ZT00b[o:P0;:P03
ojFU00ZU00?o5QH02QH00on6QP0:QP03ooKf00[f00?o00000P01o`40000800;o2@04o`@000?o0000
0P0>o`bC00?o10@02P@00omQH@0:H@03ooCd00[d00?oIFD02fD00ooEe@0:e@03oeIF00YF00?oa/H0
2/H00ol0000:0003of=S00YS00?odm<02]<00om4A00:A003ZOnY00ZY00<ZobX02bX00onUY@0:Y@03
oaHF00XF00?oQXH02XH00oofmP0:mP03o`0000800Ol100006`000ol0000200ko39<00ol4100:1003
of5Q00YQ00?om?@02_@00omUI@0;I@03omGE00[E00?oEUH02UH00oo6aP0:aP03o`0000X000?oHf<0
2V<00ooCd`0:d`03odA400Y400>YojT02ZT00b[o:P0;:P03ojFU00ZU00?o5QH02QH00on6QP0:QP03
ooKf00[f00?o00000P01o`40000K0003o`0000803_l<T`03o`@400X400?oHF402V400oodm00:m003
ofEU00]U00?oeMD02]D00omFEP0:EP03olK600[600?o00002P000omSH`0:H`03om?C00[C00?oA4@0
2T@00jWoZ@0:Z@03:_lZ00/Z00?oYJD02ZD00olF5P0:5P03ohJ600Z600?om_H02_H00ol00002007o
0@0001/000?o00000P0>o`bC00?o10@02P@00omQH@0:H@03ooCd00[d00?oIFD02fD00ooEe@0:e@03
oeIF00YF00?oa/H02/H00ol0000:0003of=S00YS00?odm<02]<00om4A00:A003ZOnY00ZY00<ZobX0
2bX00onUY@0:Y@03oaHF00XF00?oQXH02XH00oofmP0:mP03o`0000800Ol100006`02o`<0n_l300;o
0@0001/000?o00000P0>o`cC00?oHF402V400olZ:P0::P03omGE00[E00?oQXH02hH00ol0000:0003
oi>C00ZC00?oA4@02T@00oodm00:m003ojFU00ZU00?oEUH02UH00oofmP0:mP03HomS00YS00<4o`@0
2`@00onYZ@0:Z@03ofEU00YU00?o5QH02QH00oo6aP0:aP03o`0000800Ol100006`000ol0000200ko
3=<00omQH@0:H@03obXZ00XZ00?oeMD02]D00on6QP0;QP03o`0000X000?oTi<02Y<00om4A00:A003
ooCd00[d00?oYJD02ZD00omFEP0:EP03ooKf00[f00=Sof<02V<00`Co100;1003ojVY00ZY00?oIFD0
2VD00olF5P0:5P03olK600[600?o00000P01o`40000K0003o`0000803_l<d`03of5Q00YQ00?o:RX0
2RX00ooEe@0:e@03ohJ600^600?o00002P000onCT`0:T`03odA400Y400?om?@02_@00onUY@0:Y@03
oeIF00YF00?om_H02_H00f?oH`0:H`031?l400/400?oZJT02ZT00omUI@0:I@03oaHF00XF00?oa/H0
2/H00ol00002007o0@0001/000?o00000P0>o`cC00?oHF402V400olZ:P0::P03omGE00[E00?oQXH0
2hH00ol0000:0003oi>C00ZC00?oA4@02T@00oodm00:m003ojFU00ZU00?oEUH02UH00oofmP0:mP03
HomS00YS00<4o`@02`@00onYZ@0:Z@03ofEU00YU00?o5QH02QH00oo6aP0:aP03o`0000800Ol10000
6`000ol0000200ko3=<00omQH@0:H@03obXZ00XZ00?oeMD02]D00on6QP0;QP03o`0000X000?oTi<0
2Y<00om4A00:A003ooCd00[d00?oYJD02ZD00omFEP0:EP03ooKf00[f00=Sof<02V<00`Co100;1003
ojVY00ZY00?oIFD02VD00olF5P0:5P03olK600[600?o00000P01o`40000K00;o0`0>o`cC00?oHF40
2V400olZ:P0::P03omGE00[E00?oQXH02hH00ol0000:0003oi>C00ZC00?oA4@02T@00oodm00:m003
ojFU00ZU00?oEUH02UH00oofmP0:mP03HomS00YS00<4o`@02`@00onYZ@0:Z@03ofEU00YU00?o5QH0
2QH00oo6aP0:aP04o`0000;o0@0001/000?o00000P0>o`cC00?oHF402V400olZ:P0::P03omGE00[E
00?oQXH02hH00ol0000:0003oi>C00ZC00?oA4@02T@00oodm00:m003ojFU00ZU00?oEUH02UH00oof
mP0:mP03HomS00YS00<4o`@02`@00onYZ@0:Z@03ofEU00YU00?o5QH02QH00oo6aP0:aP03o`000080
0Ol100006`000ol0000200ko3=<00omQH@0:H@03obXZ00XZ00?oeMD02]D00on6QP0;QP03o`0000X0
00?oTi<02Y<00om4A00:A003ooCd00[d00?oYJD02ZD00omFEP0:EP03ooKf00[f00=Sof<02V<00`Co
100;1003ojVY00ZY00?oIFD02VD00olF5P0:5P03olK600[600?o00000P01o`40000K0003o`000080
3_l<d`03of5Q00YQ00?o:RX02RX00ooEe@0:e@03ohJ600^600?o00002P000onCT`0:T`03odA400Y4
00?om?@02_@00onUY@0:Y@03oeIF00YF00?om_H02_H00f?oH`0:H`031?l400/400?oZJT02ZT00omU
I@0:I@03oaHF00XF00?oa/H02/H00ol00002007o0@0001/000?o00000P0>o`cC00?oHF402V400olZ
:P0::P03omGE00[E00?oQXH02hH00ol0000:0003oi>C00ZC00?oA4@02T@00oodm00:m003ojFU00ZU
00?oEUH02UH00oofmP0:mP03HomS00YS00<4o`@02`@00onYZ@0:Z@03ofEU00YU00?o5QH02QH00oo6
aP0:aP03o`0000800Ol100006`000ol0000200ko3=<00omQH@0:H@03obXZ00XZ00?oeMD02]D00on6
QP0;QP03o`0000X000?oTi<02Y<00om4A00:A003ooCd00[d00?oYJD02ZD00omFEP0:EP03ooKf00[f
00=Sof<02V<00`Co100;1003ojVY00ZY00?oIFD02VD00olF5P0:5P03olK600[600?o00000P01o`40
000K0003o`0000803_l<d`03of5Q00YQ00?o:RX02RX00ooEe@0:e@03ohJ600^600?o00002P000onC
T`0:T`03odA400Y400?om?@02_@00onUY@0:Y@03oeIF00YF00?om_H02_H00f?oH`0:H`031?l400/4
00?oZJT02ZT00omUI@0:I@03oaHF00XF00?oa/H02/H00ol00002007o0@0001/00_l30?[o0`02o`40
000K0003o`0000803_l<1003ooCd00[d00?oeMD02]D00oo6aP0:aP03of=S00]S00?oA4@02T@00olZ
:P0::P03oaHF00XF00?om_H02_H00onCT`0:T`03of5Q00YQ00?oIFD02VD00eKoEP0:EP030?l000/0
00?odm<02]<00onYZ@0:Z@03ojFU00ZU00?oQXH02XH00ol00002007o0@0001/000?o00000P0>o``4
00?om?@02_@00ooEe@0:e@03olK600[600?oHf<02f<00om4A00:A003obXZ00XZ00?o5QH02QH00oof
mP0:mP03oi>C00ZC00?oHF402V400omUI@0:I@03E_mF00YF00<0o`002`000ooCd`0:d`03ojVY00ZY
00?oYJD02ZD00on6QP0:QP03o`0000800Ol100006`000ol0000200ko30@00oodm00:m003omGE00[E
00?oa/H02/H00omSH`0;H`03odA400Y400?o:RX02RX00olF5P0:5P03ooKf00[f00?oTi<02Y<00omQ
H@0:H@03ofEU00YU00=FoeH02UH00`3o000;0003om?C00[C00?oZJT02ZT00onUY@0:Y@03ohJ600Z6
00?o00000P01o`40000K0003o`0000803_l<1003ooCd00[d00?oeMD02]D00oo6aP0:aP03of=S00]S
00?oA4@02T@00olZ:P0::P03oaHF00XF00?om_H02_H00onCT`0:T`03of5Q00YQ00?oIFD02VD00eKo
EP0:EP030?l000/000?odm<02]<00onYZ@0:Z@03ojFU00ZU00?oQXH02XH00ol00002007o0@0001/0
00?o00000P0>o``400?om?@02_@00ooEe@0:e@03olK600[600?oHf<02f<00om4A00:A003obXZ00XZ
00?o5QH02QH00oofmP0:mP03oi>C00ZC00?oHF402V400omUI@0:I@03E_mF00YF00<0o`002`000ooC
d`0:d`03ojVY00ZY00?oYJD02ZD00on6QP0:QP03o`0000800Ol100006`02o`<03_l<1003ooCd00[d
00?oeMD02]D00oo6aP0:aP03of=S00]S00?oA4@02T@00olZ:P0::P03oaHF00XF00?om_H02_H00onC
T`0:T`03of5Q00YQ00?oIFD02VD00eKoEP0:EP030?l000/000?odm<02]<00onYZ@0:Z@03ojFU00ZU
00?oQXH02XH01?l00002o`40000K0003o`0000803_l<1003ooCd00[d00?oeMD02]D00oo6aP0:aP03
of=S00]S00?oA4@02T@00olZ:P0::P03oaHF00XF00?om_H02_H00onCT`0:T`03of5Q00YQ00?oIFD0
2VD00eKoEP0:EP030?l000/000?odm<02]<00onYZ@0:Z@03ojFU00ZU00?oQXH02XH00ol00002007o
0@0001/000?o00000P0>o``400?om?@02_@00ooEe@0:e@03olK600[600?oHf<02f<00om4A00:A003
obXZ00XZ00?o5QH02QH00oofmP0:mP03oi>C00ZC00?oHF402V400omUI@0:I@03E_mF00YF00<0o`00
2`000ooCd`0:d`03ojVY00ZY00?oYJD02ZD00on6QP0:QP03o`0000800Ol100006`000ol0000200ko
30@00oodm00:m003omGE00[E00?oa/H02/H00omSH`0;H`03odA400Y400?o:RX02RX00olF5P0:5P03
ooKf00[f00?oTi<02Y<00omQH@0:H@03ofEU00YU00=FoeH02UH00`3o000;0003om?C00[C00?oZJT0
2ZT00onUY@0:Y@03ohJ600Z600?o00000P01o`40000K0003o`0000803_l<1003ooCd00[d00?oeMD0
2]D00oo6aP0:aP03of=S00]S00?oA4@02T@00olZ:P0::P03oaHF00XF00?om_H02_H00onCT`0:T`03
of5Q00YQ00?oIFD02VD00eKoEP0:EP030?l000/000?odm<02]<00onYZ@0:Z@03ojFU00ZU00?oQXH0
2XH00ol00002007o0@0001<00ol50003o`0000803_l<1003ooCd00[d00?oeMD02]D00oo6aP0:aP03
of=S00]S00?oA4@02T@00olZ:P0::P03oaHF00XF00?om_H02_H00onCT`0:T`03of5Q00YQ00?oIFD0
2VD00eKoEP0:EP030?l000/000?odm<02]<00onYZ@0:Z@03ojFU00ZU00?oQXH02XH00ol00002007o
0@0001H000?o00000P000ol0000200ko30@00oodm00:m003omGE00[E00?oa/H02/H00omSH`0;H`03
odA400Y400?o:RX02RX00olF5P0:5P03ooKf00[f00?oTi<02Y<00omQH@0:H@03ofEU00YU00=FoeH0
2UH00`3o000;0003om?C00[C00?oZJT02ZT00onUY@0:Y@03ohJ600Z600?o00000P01o`40000F0003
o`0000800_l30?[o0`02o`40000C00?o1@000ol0000200ko34@00omUI@0:I@03ohJ600Z600?oHf<0
2V<00omQH@0;H@03ojFU00ZU00?oa/H02/H00onCT`0:T`03ojVY00ZY00?oeMD02]D00oofmP0:mP03
om?C00[C00?doo@02_@00aKo5P0;5P03o`0000X000?o10@02P@00olZ:P0::P03oeIF00YF00?o0000
0P01o`40000C0003o`0000D000?o00000P0>o`a400?oIFD02VD00on6QP0:QP03of=S00YS00?oHF40
2f400onUY@0:Y@03olK600[600?oTi<02Y<00onYZ@0:Z@03omGE00[E00?om_H02_H00ooCd`0:d`03
m?od00[d00<FoaH02aH00ol0000:0003o`@400X400?o:RX02RX00omFEP0:EP03o`0000800Ol10000
4`04o`@000?o00000P0>o`a400?oIFD02VD00on6QP0:QP03of=S00YS00?oHF402f400onUY@0:Y@03
olK600[600?oTi<02Y<00onYZ@0:Z@03omGE00[E00?om_H02_H00ooCd`0:d`03m?od00[d00<FoaH0
2aH00ol0000:0003o`@400X400?o:RX02RX00omFEP0:EP03o`0000800Ol100006`000ol0000200ko
34@00omUI@0:I@03ohJ600Z600?oHf<02V<00omQH@0;H@03ojFU00ZU00?oa/H02/H00onCT`0:T`03
ojVY00ZY00?oeMD02]D00oofmP0:mP03om?C00[C00?doo@02_@00aKo5P0;5P03o`0000X000?o10@0
2P@00olZ:P0::P03oeIF00YF00?o00000P01o`40000K0003o`0000803_l<A003ofEU00YU00?oQXH0
2XH00omSH`0:H`03of5Q00]Q00?oYJD02ZD00oo6aP0:aP03oi>C00ZC00?oZJT02ZT00ooEe@0:e@03
ooKf00[f00?odm<02]<00oCom00:m0035_lF00/F00?o00002P000ol4100:1003obXZ00XZ00?oEUH0
2UH00ol00002007o0@0001/000?o00000P0>o`a400?oIFD02VD00on6QP0:QP03of=S00YS00?oHF40
2f400onUY@0:Y@03olK600[600?oTi<02Y<00onYZ@0:Z@03omGE00[E00?om_H02_H00ooCd`0:d`03
m?od00[d00<FoaH02aH00ol0000:0003o`@400X400?o:RX02RX00omFEP0:EP03o`0000800Ol10000
6`02o`<03_l<A003ofEU00YU00?oQXH02XH00omSH`0:H`03of5Q00]Q00?oYJD02ZD00oo6aP0:aP03
oi>C00ZC00?oZJT02ZT00ooEe@0:e@03ooKf00[f00?odm<02]<00oCom00:m0035_lF00/F00?o0000
2P000ol4100:1003obXZ00XZ00?oEUH02UH01?l00002o`40000K0003o`0000803_l<A003ofEU00YU
00?oQXH02XH00omSH`0:H`03of5Q00]Q00?oYJD02ZD00oo6aP0:aP03oi>C00ZC00?oZJT02ZT00ooE
e@0:e@03ooKf00[f00?odm<02]<00oCom00:m0035_lF00/F00?o00002P000ol4100:1003obXZ00XZ
00?oEUH02UH00ol00002007o0@0001/000?o00000P0>o`a400?oIFD02VD00on6QP0:QP03of=S00YS
00?oHF402f400onUY@0:Y@03olK600[600?oTi<02Y<00onYZ@0:Z@03omGE00[E00?om_H02_H00ooC
d`0:d`03m?od00[d00<FoaH02aH00ol0000:0003o`@400X400?o:RX02RX00omFEP0:EP03o`000080
0Ol100006`000ol0000200ko34@00omUI@0:I@03ohJ600Z600?oHf<02V<00omQH@0;H@03ojFU00ZU
00?oa/H02/H00onCT`0:T`03ojVY00ZY00?oeMD02]D00oofmP0:mP03om?C00[C00?doo@02_@00aKo
5P0;5P03o`0000X000?o10@02P@00olZ:P0::P03oeIF00YF00?o00000P01o`40000K0003o`000080
3_l<A003ofEU00YU00?oQXH02XH00omSH`0:H`03of5Q00]Q00?oYJD02ZD00oo6aP0:aP03oi>C00ZC
00?oZJT02ZT00ooEe@0:e@03ooKf00[f00?odm<02]<00oCom00:m0035_lF00/F00?o00002P000ol4
100:1003obXZ00XZ00?oEUH02UH00ol00002007o0@0001/000?o00000P0>o`a400?oIFD02VD00on6
QP0:QP03of=S00YS00?oHF402f400onUY@0:Y@03olK600[600?oTi<02Y<00onYZ@0:Z@03omGE00[E
00?om_H02_H00ooCd`0:d`03m?od00[d00<FoaH02aH00ol0000:0003o`@400X400?o:RX02RX00omF
EP0:EP03o`0000800Ol100006`02o`<0n_l300;o0@0001/000?o00000P0>o`aQ00?oeMD02]D00ol0
000:0003odA400Y400?oYJD02jD00oofmP0:mP03o`@400X400?oIFD02VD00oo6aP0:aP03om?C00[C
00?o:RX02RX00on6QP0:QP03TonC00ZC00?doo@02o@00omFEP0:EP03of=S00YS00?oZJT02ZT00olF
5P0:5P03o`0000800Ol100006`000ol0000200ko36400ooEe@0:e@03o`0000X000?oA4@02T@00onU
Y@0;Y@03ooKf00[f00?o10@02P@00omUI@0:I@03olK600[600?odm<02]<00olZ:P0::P03ohJ600Z6
00>Coi<02Y<00oCom00;m003oeIF00YF00?oHf<02V<00onYZ@0:Z@03oaHF00XF00?o00000P01o`40
000K0003o`0000803_l<H@03omGE00[E00?o00002P000om4A00:A003ojFU00^U00?om_H02_H00ol4
100:1003ofEU00YU00?oa/H02/H00ooCd`0:d`03obXZ00XZ00?oQXH02XH00i?oT`0:T`03m?od00_d
00?oEUH02UH00omSH`0:H`03ojVY00ZY00?o5QH02QH00ol00002007o0@0001/000?o00000P0>o`aQ
00?oeMD02]D00ol0000:0003odA400Y400?oYJD02jD00oofmP0:mP03o`@400X400?oIFD02VD00oo6
aP0:aP03om?C00[C00?o:RX02RX00on6QP0:QP03TonC00ZC00?doo@02o@00omFEP0:EP03of=S00YS
00?oZJT02ZT00olF5P0:5P03o`0000800Ol100006`000ol0000200ko36400ooEe@0:e@03o`0000X0
00?oA4@02T@00onUY@0;Y@03ooKf00[f00?o10@02P@00omUI@0:I@03olK600[600?odm<02]<00olZ
:P0::P03ohJ600Z600>Coi<02Y<00oCom00;m003oeIF00YF00?oHf<02V<00onYZ@0:Z@03oaHF00XF
00?o00000P01o`40000K0003o`0000803_l<H@03omGE00[E00?o00002P000om4A00:A003ojFU00^U
00?om_H02_H00ol4100:1003ofEU00YU00?oa/H02/H00ooCd`0:d`03obXZ00XZ00?oQXH02XH00i?o
T`0:T`03m?od00_d00?oEUH02UH00omSH`0:H`03ojVY00ZY00?o5QH02QH00ol00002007o0@0001/0
0_l300ko36400ooEe@0:e@03o`0000X000?oA4@02T@00onUY@0;Y@03ooKf00[f00?o10@02P@00omU
I@0:I@03olK600[600?odm<02]<00olZ:P0::P03ohJ600Z600>Coi<02Y<00oCom00;m003oeIF00YF
00?oHf<02V<00onYZ@0:Z@03oaHF00XF00Co00000_l100006`000ol0000200ko36400ooEe@0:e@03
o`0000X000?oA4@02T@00onUY@0;Y@03ooKf00[f00?o10@02P@00omUI@0:I@03olK600[600?odm<0
2]<00olZ:P0::P03ohJ600Z600>Coi<02Y<00oCom00;m003oeIF00YF00?oHf<02V<00onYZ@0:Z@03
oaHF00XF00?o00000P01o`40000K0003o`0000803_l<H@03omGE00[E00?o00002P000om4A00:A003
ojFU00^U00?om_H02_H00ol4100:1003ofEU00YU00?oa/H02/H00ooCd`0:d`03obXZ00XZ00?oQXH0
2XH00i?oT`0:T`03m?od00_d00?oEUH02UH00omSH`0:H`03ojVY00ZY00?o5QH02QH00ol00002007o
0@0001/000?o00000P0>o`aQ00?oeMD02]D00ol0000:0003odA400Y400?oYJD02jD00oofmP0:mP03
o`@400X400?oIFD02VD00oo6aP0:aP03om?C00[C00?o:RX02RX00on6QP0:QP03TonC00ZC00?doo@0
2o@00omFEP0:EP03of=S00YS00?oZJT02ZT00olF5P0:5P03o`0000800Ol100006`000ol0000200ko
36400ooEe@0:e@03o`0000X000?oA4@02T@00onUY@0;Y@03ooKf00[f00?o10@02P@00omUI@0:I@03
olK600[600?odm<02]<00olZ:P0::P03ohJ600Z600>Coi<02Y<00oCom00;m003oeIF00YF00?oHf<0
2V<00onYZ@0:Z@03oaHF00XF00?o00000P01o`40000K0003o`0000803_l<H@03omGE00[E00?o0000
2P000om4A00:A003ojFU00^U00?om_H02_H00ol4100:1003ofEU00YU00?oa/H02/H00ooCd`0:d`03
obXZ00XZ00?oQXH02XH00i?oT`0:T`03m?od00_d00?oEUH02UH00omSH`0:H`03ojVY00ZY00?o5QH0
2QH00ol00002007o0@0001/00_l30?[o0`02o`40000K0003o`0000803_l<Z@03oeIF00YF00?oTi<0
2Y<00olZ:P0::P03olK600_600?o10@02P@00onUY@0:Y@03o`0000X000?oHF402V400olF5P0:5P03
of=S00YS00?om?@02_@00hKoQP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03odA400Y400?oeMD0
2]D00ol00002007o0@0001/000?o00000P0>o`bY00?oEUH02UH00onCT`0:T`03obXZ00XZ00?oa/H0
2lH00ol4100:1003ojFU00ZU00?o00002P000omQH@0:H@03oaHF00XF00?oHf<02V<00oodm00:m003
Q_n600Z600?Com<02m<00omUI@0:I@03ooKf00[f00?oA4@02T@00ooEe@0:e@03o`0000800Ol10000
6`000ol0000200ko3:T00omFEP0:EP03oi>C00ZC00?o:RX02RX00oo6aP0;aP03o`@400X400?oYJD0
2ZD00ol0000:0003of5Q00YQ00?o5QH02QH00omSH`0:H`03ooCd00[d00>6ohH02XH00m?od`0;d`03
ofEU00YU00?om_H02_H00om4A00:A003omGE00[E00?o00000P01o`40000K0003o`0000803_l<Z@03
oeIF00YF00?oTi<02Y<00olZ:P0::P03olK600_600?o10@02P@00onUY@0:Y@03o`0000X000?oHF40
2V400olF5P0:5P03of=S00YS00?om?@02_@00hKoQP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03
odA400Y400?oeMD02]D00ol00002007o0@0000P000?o00000`02o`<00ol50003o`0000803_l<Z@03
oeIF00YF00?oTi<02Y<00olZ:P0::P03olK600_600?o10@02P@00onUY@0:Y@03o`0000X000?oHF40
2V400olF5P0:5P03of=S00YS00?om?@02_@00hKoQP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03
odA400Y400?oeMD02]D00ol00002007o0@0000P000?o00000`02o`H000?o00000P000ol0000200ko
3:T00omFEP0:EP03oi>C00ZC00?o:RX02RX00oo6aP0;aP03o`@400X400?oYJD02ZD00ol0000:0003
of5Q00YQ00?o5QH02QH00omSH`0:H`03ooCd00[d00>6ohH02XH00m?od`0;d`03ofEU00YU00?om_H0
2_H00om4A00:A003omGE00[E00?o00000P01o`4000090003o`0000X000?o00000P02o`<03_l<Z@03
oeIF00YF00?oTi<02Y<00olZ:P0::P03olK600_600?o10@02P@00onUY@0:Y@03o`0000X000?oHF40
2V400olF5P0:5P03of=S00YS00?om?@02_@00hKoQP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03
odA400Y400?oeMD02]D01?l00002o`4000090003o`0000L00ol50003o`0000803_l<Z@03oeIF00YF
00?oTi<02Y<00olZ:P0::P03olK600_600?o10@02P@00onUY@0:Y@03o`0000X000?oHF402V400olF
5P0:5P03of=S00YS00?om?@02_@00hKoQP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03odA400Y4
00?oeMD02]D00ol00002007o0@0000X000?o00001P000ol000050003o`0000803_l<Z@03oeIF00YF
00?oTi<02Y<00olZ:P0::P03olK600_600?o10@02P@00onUY@0:Y@03o`0000X000?oHF402V400olF
5P0:5P03of=S00YS00?om?@02_@00hKoQP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03odA400Y4
00?oeMD02]D00ol00002007o0@0000L01?l800Co10000ol0000200ko3:T00omFEP0:EP03oi>C00ZC
00?o:RX02RX00oo6aP0;aP03o`@400X400?oYJD02ZD00ol0000:0003of5Q00YQ00?o5QH02QH00omS
H`0:H`03ooCd00[d00>6ohH02XH00m?od`0;d`03ofEU00YU00?om_H02_H00om4A00:A003omGE00[E
00?o00000P01o`40000K0003o`0000803_l<Z@03oeIF00YF00?oTi<02Y<00olZ:P0::P03olK600_6
00?o10@02P@00onUY@0:Y@03o`0000X000?oHF402V400olF5P0:5P03of=S00YS00?om?@02_@00hKo
QP0:QP03dooC00_C00?oIFD02VD00oofmP0:mP03odA400Y400?oeMD02]D00ol00002007o0@0001/0
00?o00000P0>o`bY00?oEUH02UH00onCT`0:T`03obXZ00XZ00?oa/H02lH00ol4100:1003ojFU00ZU
00?o00002P000omQH@0:H@03oaHF00XF00?oHf<02V<00oodm00:m003Q_n600Z600?Com<02m<00omU
I@0:I@03ooKf00[f00?oA4@02T@00ooEe@0:e@03o`0000800Ol100006`02o`<0n_l300;o0@0001/0
00?o00000P0>o`cd00?oa/H02/H00om4A00:A003oaHF00XF00?oTi<02i<00omUI@0:I@03o`0000X0
00?oZJT02ZT00on6QP0:QP03o`@400X400?oeMD02]D00omSH`0:H`03:_lZ00XZ00?fooH02oH00omQ
H@0:H@03oeIF00YF00?odm<02]<00onUY@0:Y@03o`0000800Ol100006`000ol0000200ko3?@00oo6
aP0:aP03odA400Y400?o5QH02QH00onCT`0;T`03ofEU00YU00?o00002P000onYZ@0:Z@03ohJ600Z6
00?o10@02P@00ooEe@0:e@03of=S00YS00<ZobX02RX00oKomP0;mP03of5Q00YQ00?oEUH02UH00ooC
d`0:d`03ojFU00ZU00?o00000P01o`40000K0003o`0000803_l<m003olK600[600?oA4@02T@00olF
5P0:5P03oi>C00^C00?oIFD02VD00ol0000:0003ojVY00ZY00?oQXH02XH00ol4100:1003omGE00[E
00?oHf<02V<00b[o:P0::P03m_of00_f00?oHF402V400omFEP0:EP03om?C00[C00?oYJD02ZD00ol0
0002007o0@0001/000?o00000P0>o`cd00?oa/H02/H00om4A00:A003oaHF00XF00?oTi<02i<00omU
I@0:I@03o`0000X000?oZJT02ZT00on6QP0:QP03o`@400X400?oeMD02]D00omSH`0:H`03:_lZ00XZ
00?fooH02oH00omQH@0:H@03oeIF00YF00?odm<02]<00onUY@0:Y@03o`0000800Ol100006`000ol0
000200ko3?@00oo6aP0:aP03odA400Y400?o5QH02QH00onCT`0;T`03ofEU00YU00?o00002P000onY
Z@0:Z@03ohJ600Z600?o10@02P@00ooEe@0:e@03of=S00YS00<ZobX02RX00oKomP0;mP03of5Q00YQ
00?oEUH02UH00ooCd`0:d`03ojFU00ZU00?o00000P01o`40000K0003o`0000803_l<m003olK600[6
00?oA4@02T@00olF5P0:5P03oi>C00^C00?oIFD02VD00ol0000:0003ojVY00ZY00?oQXH02XH00ol4
100:1003omGE00[E00?oHf<02V<00b[o:P0::P03m_of00_f00?oHF402V400omFEP0:EP03om?C00[C
00?oYJD02ZD00ol00002007o0@0001/00_l300ko3?@00oo6aP0:aP03odA400Y400?o5QH02QH00onC
T`0;T`03ofEU00YU00?o00002P000onYZ@0:Z@03ohJ600Z600?o10@02P@00ooEe@0:e@03of=S00YS
00<ZobX02RX00oKomP0;mP03of5Q00YQ00?oEUH02UH00ooCd`0:d`03ojFU00ZU00Co00000_l10000
6`000ol0000200ko3?@00oo6aP0:aP03odA400Y400?o5QH02QH00onCT`0;T`03ofEU00YU00?o0000
2P000onYZ@0:Z@03ohJ600Z600?o10@02P@00ooEe@0:e@03of=S00YS00<ZobX02RX00oKomP0;mP03
of5Q00YQ00?oEUH02UH00ooCd`0:d`03ojFU00ZU00?o00000P01o`40000K0003o`0000803_l<m003
olK600[600?oA4@02T@00olF5P0:5P03oi>C00^C00?oIFD02VD00ol0000:0003ojVY00ZY00?oQXH0
2XH00ol4100:1003omGE00[E00?oHf<02V<00b[o:P0::P03m_of00_f00?oHF402V400omFEP0:EP03
om?C00[C00?oYJD02ZD00ol00002007o0@0001/000?o00000P0>o`cd00?oa/H02/H00om4A00:A003
oaHF00XF00?oTi<02i<00omUI@0:I@03o`0000X000?oZJT02ZT00on6QP0:QP03o`@400X400?oeMD0
2]D00omSH`0:H`03:_lZ00XZ00?fooH02oH00omQH@0:H@03oeIF00YF00?odm<02]<00onUY@0:Y@03
o`0000800Ol100006`000ol0000200ko3?@00oo6aP0:aP03odA400Y400?o5QH02QH00onCT`0;T`03
ofEU00YU00?o00002P000onYZ@0:Z@03ohJ600Z600?o10@02P@00ooEe@0:e@03of=S00YS00<ZobX0
2RX00oKomP0;mP03of5Q00YQ00?oEUH02UH00ooCd`0:d`03ojFU00ZU00?o00000P01o`40000K0003
o`0000803_l<m003olK600[600?oA4@02T@00olF5P0:5P03oi>C00^C00?oIFD02VD00ol0000:0003
ojVY00ZY00?oQXH02XH00ol4100:1003omGE00[E00?oHf<02V<00b[o:P0::P03m_of00_f00?oHF40
2V400omFEP0:EP03om?C00[C00?oYJD02ZD00ol00002007o0@0001/000?o00000P0>o`cd00?oa/H0
2/H00om4A00:A003oaHF00XF00?oTi<02i<00omUI@0:I@03o`0000X000?oZJT02ZT00on6QP0:QP03
o`@400X400?oeMD02]D00omSH`0:H`03:_lZ00XZ00?fooH02oH00omQH@0:H@03oeIF00YF00?odm<0
2]<00onUY@0:Y@03o`0000800Ol100006`02o`<0n_l300;o0@0001/000?o00000P0>o``Z00?o0000
2P000oodm00:m003ooKf00[f00?oZJT02jT00oo6aP0:aP03of5Q00YQ00?oQXH02XH00om4A00:A003
oeIF00YF00?o10@02P@00olF5P0:5P03dooC00[C00?EomD02mD00onCT`0:T`03ojFU00ZU00?oHf<0
2V<00omUI@0:I@03o`0000800Ol100006`000ol0000200ko32X00ol0000:0003ooCd00[d00?om_H0
2_H00onYZ@0;Z@03olK600[600?oHF402V400on6QP0:QP03odA400Y400?oEUH02UH00ol4100:1003
oaHF00XF00?Com<02]<00mGoe@0;e@03oi>C00ZC00?oYJD02ZD00omSH`0:H`03ofEU00YU00?o0000
0P01o`40000K0003o`0000803_l<:P03o`0000X000?om?@02_@00oofmP0:mP03ojVY00^Y00?oa/H0
2/H00omQH@0:H@03ohJ600Z600?oA4@02T@00omFEP0:EP03o`@400X400?o5QH02QH00m?od`0:d`03
eOoE00_E00?oTi<02Y<00onUY@0:Y@03of=S00YS00?oIFD02VD00ol00002007o0@0001/000?o0000
0P0>o``Z00?o00002P000oodm00:m003ooKf00[f00?oZJT02jT00oo6aP0:aP03of5Q00YQ00?oQXH0
2XH00om4A00:A003oeIF00YF00?o10@02P@00olF5P0:5P03dooC00[C00?EomD02mD00onCT`0:T`03
ojFU00ZU00?oHf<02V<00omUI@0:I@03o`0000800Ol100006`000ol0000200ko32X00ol0000:0003
ooCd00[d00?om_H02_H00onYZ@0;Z@03olK600[600?oHF402V400on6QP0:QP03odA400Y400?oEUH0
2UH00ol4100:1003oaHF00XF00?Com<02]<00mGoe@0;e@03oi>C00ZC00?oYJD02ZD00omSH`0:H`03
ofEU00YU00?o00000P01o`40000K00;o0`0>o``Z00?o00002P000oodm00:m003ooKf00[f00?oZJT0
2jT00oo6aP0:aP03of5Q00YQ00?oQXH02XH00om4A00:A003oeIF00YF00?o10@02P@00olF5P0:5P03
dooC00[C00?EomD02mD00onCT`0:T`03ojFU00ZU00?oHf<02V<00omUI@0:I@04o`0000;o0@0001/0
00?o00000P0>o``Z00?o00002P000oodm00:m003ooKf00[f00?oZJT02jT00oo6aP0:aP03of5Q00YQ
00?oQXH02XH00om4A00:A003oeIF00YF00?o10@02P@00olF5P0:5P03dooC00[C00?EomD02mD00onC
T`0:T`03ojFU00ZU00?oHf<02V<00omUI@0:I@03o`0000800Ol100006`000ol0000200ko32X00ol0
000:0003ooCd00[d00?om_H02_H00onYZ@0;Z@03olK600[600?oHF402V400on6QP0:QP03odA400Y4
00?oEUH02UH00ol4100:1003oaHF00XF00?Com<02]<00mGoe@0;e@03oi>C00ZC00?oYJD02ZD00omS
H`0:H`03ofEU00YU00?o00000P01o`40000K0003o`0000803_l<:P03o`0000X000?om?@02_@00oof
mP0:mP03ojVY00^Y00?oa/H02/H00omQH@0:H@03ohJ600Z600?oA4@02T@00omFEP0:EP03o`@400X4
00?o5QH02QH00m?od`0:d`03eOoE00_E00?oTi<02Y<00onUY@0:Y@03of=S00YS00?oIFD02VD00ol0
0002007o0@0001/000?o00000P0>o``Z00?o00002P000oodm00:m003ooKf00[f00?oZJT02jT00oo6
aP0:aP03of5Q00YQ00?oQXH02XH00om4A00:A003oeIF00YF00?o10@02P@00olF5P0:5P03dooC00[C
00?EomD02mD00onCT`0:T`03ojFU00ZU00?oHf<02V<00omUI@0:I@03o`0000800Ol100003@03o`@0
0_l50003o`0000803_l<:P03o`0000X000?om?@02_@00oofmP0:mP03ojVY00^Y00?oa/H02/H00omQ
H@0:H@03ohJ600Z600?oA4@02T@00omFEP0:EP03o`@400X400?o5QH02QH00m?od`0:d`03eOoE00_E
00?oTi<02Y<00onUY@0:Y@03of=S00YS00?oIFD02VD00ol00002007o0@0000h000?o00000P001?l0
0?l40003o`0000803_l<:P03o`0000X000?om?@02_@00oofmP0:mP03ojVY00^Y00?oa/H02/H00omQ
H@0:H@03ohJ600Z600?oA4@02T@00omFEP0:EP03o`@400X400?o5QH02QH00m?od`0:d`03eOoE00_E
00?oTi<02Y<00onUY@0:Y@03of=S00YS00?oIFD02VD00ol00002007o0@0000h000?o00000P001?l0
0?l400;o0`3jo`<00_l100003P000ol000020004o`00o`@000?o00000P0>o`aU00?oHf<02V<00onU
Y@0:Y@03oi>C00ZC00?oeMD02mD00ooCd`0:d`03oaHF00XF00?o10@02P@00omFEP0:EP03odA400Y4
00?oQXH02XH00omQH@0:H@03a_o600[600>YojT02jT00oofmP0:mP03ooCd00[d00?o00002P000olZ
:P0::P03o`0000800Ol100003P000ol000020004o`00o`@000?o00000P0>o`aU00?oHf<02V<00onU
Y@0:Y@03oi>C00ZC00?oeMD02mD00ooCd`0:d`03oaHF00XF00?o10@02P@00omFEP0:EP03odA400Y4
00?oQXH02XH00omQH@0:H@03a_o600[600>YojT02jT00oofmP0:mP03ooCd00[d00?o00002P000olZ
:P0::P03o`0000800Ol100003@02o`D00_l50003o`0000803_l<I@03of=S00YS00?oYJD02ZD00onC
T`0:T`03omGE00_E00?odm<02]<00olF5P0:5P03o`@400X400?oEUH02UH00om4A00:A003ohJ600Z6
00?oHF402V400lKoaP0:aP03ZOnY00^Y00?om_H02_H00oodm00:m003o`0000X000?o:RX02RX00ol0
0002007o0@0001/000?o00000P0>o`aU00?oHf<02V<00onUY@0:Y@03oi>C00ZC00?oeMD02mD00ooC
d`0:d`03oaHF00XF00?o10@02P@00omFEP0:EP03odA400Y400?oQXH02XH00omQH@0:H@03a_o600[6
00>YojT02jT00oofmP0:mP03ooCd00[d00?o00002P000olZ:P0::P03o`0000800Ol100006`000ol0
000200ko36D00omSH`0:H`03ojFU00ZU00?oTi<02Y<00ooEe@0;e@03om?C00[C00?o5QH02QH00ol4
100:1003oeIF00YF00?oA4@02T@00on6QP0:QP03of5Q00YQ00?6olH02/H00jWoZ@0;Z@03ooKf00[f
00?om?@02_@00ol0000:0003obXZ00XZ00?o00000P01o`40000K00;o0`0>o`aU00?oHf<02V<00onU
Y@0:Y@03oi>C00ZC00?oeMD02mD00ooCd`0:d`03oaHF00XF00?o10@02P@00omFEP0:EP03odA400Y4
00?oQXH02XH00omQH@0:H@03a_o600[600>YojT02jT00oofmP0:mP03ooCd00[d00?o00002P000olZ
:P0::P04o`0000;o0@0001/000?o00000P0>o`aU00?oHf<02V<00onUY@0:Y@03oi>C00ZC00?oeMD0
2mD00ooCd`0:d`03oaHF00XF00?o10@02P@00omFEP0:EP03odA400Y400?oQXH02XH00omQH@0:H@03
a_o600[600>YojT02jT00oofmP0:mP03ooCd00[d00?o00002P000olZ:P0::P03o`0000800Ol10000
6`000ol0000200ko36D00omSH`0:H`03ojFU00ZU00?oTi<02Y<00ooEe@0;e@03om?C00[C00?o5QH0
2QH00ol4100:1003oeIF00YF00?oA4@02T@00on6QP0:QP03of5Q00YQ00?6olH02/H00jWoZ@0;Z@03
ooKf00[f00?om?@02_@00ol0000:0003obXZ00XZ00?o00000P01o`40000K0003o`0000803_l<I@03
of=S00YS00?oYJD02ZD00onCT`0:T`03omGE00_E00?odm<02]<00olF5P0:5P03o`@400X400?oEUH0
2UH00om4A00:A003ohJ600Z600?oHF402V400lKoaP0:aP03ZOnY00^Y00?om_H02_H00oodm00:m003
o`0000X000?o:RX02RX00ol00002007o0@0001/000?o00000P0>o`aU00?oHf<02V<00onUY@0:Y@03
oi>C00ZC00?oeMD02mD00ooCd`0:d`03oaHF00XF00?o10@02P@00omFEP0:EP03odA400Y400?oQXH0
2XH00omQH@0:H@03a_o600[600>YojT02jT00oofmP0:mP03ooCd00[d00?o00002P000olZ:P0::P03
o`0000800Ol100006`000ol0000200ko36D00omSH`0:H`03ojFU00ZU00?oTi<02Y<00ooEe@0;e@03
om?C00[C00?o5QH02QH00ol4100:1003oeIF00YF00?oA4@02T@00on6QP0:QP03of5Q00YQ00?6olH0
2/H00jWoZ@0;Z@03ooKf00[f00?om?@02_@00ol0000:0003obXZ00XZ00?o00000P01o`40000K0003
o`0000803_l<I@03of=S00YS00?oYJD02ZD00onCT`0:T`03omGE00_E00?odm<02]<00olF5P0:5P03
o`@400X400?oEUH02UH00om4A00:A003ohJ600Z600?oHF402V400lKoaP0:aP03ZOnY00^Y00?om_H0
2_H00oodm00:m003o`0000X000?o:RX02RX00ol00002007o0@0001/00_l30?[o0`02o`40000K0003
o`0000803_l<Y@03om?C00[C00?oEUH02UH00omQH@0:H@03ooKf00_f00?o:RX02RX00omSH`0:H`03
omGE00[E00?o10@02P@00on6QP0:QP03ojVY00ZY00?o00002P000fGoI@0:I@03TonC00^C00?o5QH0
2QH00om4A00:A003olK600[600?om?@02_@00ol00002007o0@0001/000?o00000P0>o`bU00?odm<0
2]<00omFEP0:EP03of5Q00YQ00?om_H02oH00olZ:P0::P03of=S00YS00?oeMD02]D00ol4100:1003
ohJ600Z600?oZJT02ZT00ol0000:0003IOmU00YU00>Coi<02i<00olF5P0:5P03odA400Y400?oa/H0
2/H00oodm00:m003o`0000800Ol100006`000ol0000200ko3:D00ooCd`0:d`03oeIF00YF00?oHF40
2V400oofmP0;mP03obXZ00XZ00?oHf<02V<00ooEe@0:e@03o`@400X400?oQXH02XH00onYZ@0:Z@03
o`0000X000=UofD02VD00i?oT`0;T`03oaHF00XF00?oA4@02T@00oo6aP0:aP03ooCd00[d00?o0000
0P01o`40000K0003o`0000803_l<Y@03om?C00[C00?oEUH02UH00omQH@0:H@03ooKf00_f00?o:RX0
2RX00omSH`0:H`03omGE00[E00?o10@02P@00on6QP0:QP03ojVY00ZY00?o00002P000fGoI@0:I@03
TonC00^C00?o5QH02QH00om4A00:A003olK600[600?om?@02_@00ol00002007o0@0001/000?o0000
0P0>o`bU00?odm<02]<00omFEP0:EP03of5Q00YQ00?om_H02oH00olZ:P0::P03of=S00YS00?oeMD0
2]D00ol4100:1003ohJ600Z600?oZJT02ZT00ol0000:0003IOmU00YU00>Coi<02i<00olF5P0:5P03
odA400Y400?oa/H02/H00oodm00:m003o`0000800Ol100006`02o`<03_l<Y@03om?C00[C00?oEUH0
2UH00omQH@0:H@03ooKf00_f00?o:RX02RX00omSH`0:H`03omGE00[E00?o10@02P@00on6QP0:QP03
ojVY00ZY00?o00002P000fGoI@0:I@03TonC00^C00?o5QH02QH00om4A00:A003olK600[600?om?@0
2_@01?l00002o`40000K0003o`0000803_l<Y@03om?C00[C00?oEUH02UH00omQH@0:H@03ooKf00_f
00?o:RX02RX00omSH`0:H`03omGE00[E00?o10@02P@00on6QP0:QP03ojVY00ZY00?o00002P000fGo
I@0:I@03TonC00^C00?o5QH02QH00om4A00:A003olK600[600?om?@02_@00ol00002007o0@0001/0
00?o00000P0>o`bU00?odm<02]<00omFEP0:EP03of5Q00YQ00?om_H02oH00olZ:P0::P03of=S00YS
00?oeMD02]D00ol4100:1003ohJ600Z600?oZJT02ZT00ol0000:0003IOmU00YU00>Coi<02i<00olF
5P0:5P03odA400Y400?oa/H02/H00oodm00:m003o`0000800Ol100006`000ol0000200ko3:D00ooC
d`0:d`03oeIF00YF00?oHF402V400oofmP0;mP03obXZ00XZ00?oHf<02V<00ooEe@0:e@03o`@400X4
00?oQXH02XH00onYZ@0:Z@03o`0000X000=UofD02VD00i?oT`0;T`03oaHF00XF00?oA4@02T@00oo6
aP0:aP03ooCd00[d00?o00000P01o`40000K0003o`0000803_l<Y@03om?C00[C00?oEUH02UH00omQ
H@0:H@03ooKf00_f00?o:RX02RX00omSH`0:H`03omGE00[E00?o10@02P@00on6QP0:QP03ojVY00ZY
00?o00002P000fGoI@0:I@03TonC00^C00?o5QH02QH00om4A00:A003olK600[600?om?@02_@00ol0
0002007o0@0001/000?o00000P0>o`bU00?odm<02]<00omFEP0:EP03of5Q00YQ00?om_H02oH00olZ
:P0::P03of=S00YS00?oeMD02]D00ol4100:1003ohJ600Z600?oZJT02ZT00ol0000:0003IOmU00YU
00>Coi<02i<00olF5P0:5P03odA400Y400?oa/H02/H00oodm00:m003o`0000800Ol100006`000ol0
000200ko3:D00ooCd`0:d`03oeIF00YF00?oHF402V400oofmP0;mP03obXZ00XZ00?oHf<02V<00ooE
e@0:e@03o`@400X400?oQXH02XH00onYZ@0:Z@03o`0000X000=UofD02VD00i?oT`0;T`03oaHF00XF
00?oA4@02T@00oo6aP0:aP03ooCd00[d00?o00000P01o`40000K00;o0`3jo`<00_l100006`000ol0
000200ko3=D00om4A00:A003ooKf00[f00?oIFD02VD00ooCd`0;d`03ohJ600Z600?om?@02_@00omS
H`0:H`03oaHF00XF00?oHF402V400ol0000:0003ojFU00ZU00<4o`@02P@00lKoaP0;aP03obXZ00XZ
00?oTi<02Y<00omFEP0:EP03ojVY00ZY00?o00000P01o`40000K0003o`0000803_l<e@03odA400Y4
00?om_H02_H00omUI@0:I@03om?C00_C00?oQXH02XH00oodm00:m003of=S00YS00?o5QH02QH00omQ
H@0:H@03o`0000X000?oYJD02ZD00`Co100:1003a_o600_600?o:RX02RX00onCT`0:T`03oeIF00YF
00?oZJT02ZT00ol00002007o0@0001/000?o00000P0>o`cE00?oA4@02T@00oofmP0:mP03ofEU00YU
00?odm<02m<00on6QP0:QP03ooCd00[d00?oHf<02V<00olF5P0:5P03of5Q00YQ00?o00002P000onU
Y@0:Y@031?l400X400?6olH02lH00olZ:P0::P03oi>C00ZC00?oEUH02UH00onYZ@0:Z@03o`000080
0Ol100006`000ol0000200ko3=D00om4A00:A003ooKf00[f00?oIFD02VD00ooCd`0;d`03ohJ600Z6
00?om?@02_@00omSH`0:H`03oaHF00XF00?oHF402V400ol0000:0003ojFU00ZU00<4o`@02P@00lKo
aP0;aP03obXZ00XZ00?oTi<02Y<00omFEP0:EP03ojVY00ZY00?o00000P01o`400000103oool300Co
0`02o`<00ol50003o`0000803_l<e@03odA400Y400?om_H02_H00omUI@0:I@03om?C00_C00?oQXH0
2XH00oodm00:m003of=S00YS00?o5QH02QH00omQH@0:H@03o`0000X000?oYJD02ZD00`Co100:1003
a_o600_600?o:RX02RX00onCT`0:T`03oeIF00YF00?oZJT02ZT00ol00002007o0@00008000?o0000
0`000ol0000300;o1P000ol000020003o`0000803_l<e@03odA400Y400?om_H02_H00omUI@0:I@03
om?C00_C00?oQXH02XH00oodm00:m003of=S00YS00?o5QH02QH00omQH@0:H@03o`0000X000?oYJD0
2ZD00`Co100:1003a_o600_600?o:RX02RX00onCT`0:T`03oeIF00YF00?oZJT02ZT00ol00002007o
0@00008000?o000010000ol0000:0003o`0000800_l300ko3=D00om4A00:A003ooKf00[f00?oIFD0
2VD00ooCd`0;d`03ohJ600Z600?om?@02_@00omSH`0:H`03oaHF00XF00?oHF402V400ol0000:0003
ojFU00ZU00<4o`@02P@00lKoaP0;aP03obXZ00XZ00?oTi<02Y<00omFEP0:EP03ojVY00ZY00Co0000
0_l100000P000ol000050003o`0000H00ol50003o`0000803_l<e@03odA400Y400?om_H02_H00omU
I@0:I@03om?C00_C00?oQXH02XH00oodm00:m003of=S00YS00?o5QH02QH00omQH@0:H@03o`0000X0
00?oYJD02ZD00`Co100:1003a_o600_600?o:RX02RX00onCT`0:T`03oeIF00YF00?oZJT02ZT00ol0
0002007o0@00008000?o00000P001?l00?l80003o`0000D000?o00000P0>o`cE00?oA4@02T@00oof
mP0:mP03ofEU00YU00?odm<02m<00on6QP0:QP03ooCd00[d00?oHf<02V<00olF5P0:5P03of5Q00YQ
00?o00002P000onUY@0:Y@031?l400X400?6olH02lH00olZ:P0::P03oi>C00ZC00?oEUH02UH00onY
Z@0:Z@03o`0000800Ol1000000<0ool01@02o`T01?l40003o`0000803_l<e@03odA400Y400?om_H0
2_H00omUI@0:I@03om?C00_C00?oQXH02XH00oodm00:m003of=S00YS00?o5QH02QH00omQH@0:H@03
o`0000X000?oYJD02ZD00`Co100:1003a_o600_600?o:RX02RX00onCT`0:T`03oeIF00YF00?oZJT0
2ZT00ol00002007o0@0001/000?o00000P0>o`cE00?oA4@02T@00oofmP0:mP03ofEU00YU00?odm<0
2m<00on6QP0:QP03ooCd00[d00?oHf<02V<00olF5P0:5P03of5Q00YQ00?o00002P000onUY@0:Y@03
1?l400X400?6olH02lH00olZ:P0::P03oi>C00ZC00?oEUH02UH00onYZ@0:Z@03o`0000800Ol10000
6`000ol0000200ko3=D00om4A00:A003ooKf00[f00?oIFD02VD00ooCd`0;d`03ohJ600Z600?om?@0
2_@00omSH`0:H`03oaHF00XF00?oHF402V400ol0000:0003ojFU00ZU00<4o`@02P@00lKoaP0;aP03
obXZ00XZ00?oTi<02Y<00omFEP0:EP03ojVY00ZY00?o00000P01o`40000K00;o0`3jo`<00_l10000
6`000ol0000200ko31H00onYZ@0:Z@03of=S00YS00?oEUH02UH00oodm00;m003oi>C00ZC00?oQXH0
2XH00olZ:P0::P03om?C00[C00?oa/H02/H00omUI@0:I@03o`@400X400?fooH02_H00jGoY@0;Y@03
odA400Y400?o00002P000ooEe@0:e@03of5Q00YQ00?o00000P01o`40000K0003o`0000803_l<5P03
ojVY00ZY00?oHf<02V<00omFEP0:EP03ooCd00_d00?oTi<02Y<00on6QP0:QP03obXZ00XZ00?odm<0
2]<00oo6aP0:aP03ofEU00YU00?o10@02P@00oKomP0:mP03YOnU00^U00?oA4@02T@00ol0000:0003
omGE00[E00?oHF402V400ol00002007o0@0001/000?o00000P0>o``F00?oZJT02ZT00omSH`0:H`03
oeIF00YF00?om?@02o@00onCT`0:T`03ohJ600Z600?o:RX02RX00ooCd`0:d`03olK600[600?oIFD0
2VD00ol4100:1003m_of00[f00>UojD02jD00om4A00:A003o`0000X000?oeMD02]D00omQH@0:H@03
o`0000800Ol100006`000ol0000200ko31H00onYZ@0:Z@03of=S00YS00?oEUH02UH00oodm00;m003
oi>C00ZC00?oQXH02XH00olZ:P0::P03om?C00[C00?oa/H02/H00omUI@0:I@03o`@400X400?fooH0
2_H00jGoY@0;Y@03odA400Y400?o00002P000ooEe@0:e@03of5Q00YQ00?o00000P01o`40000K0003
o`0000803_l<5P03ojVY00ZY00?oHf<02V<00omFEP0:EP03ooCd00_d00?oTi<02Y<00on6QP0:QP03
obXZ00XZ00?odm<02]<00oo6aP0:aP03ofEU00YU00?o10@02P@00oKomP0:mP03YOnU00^U00?oA4@0
2T@00ol0000:0003omGE00[E00?oHF402V400ol00002007o0@0001/000?o00000P0>o``F00?oZJT0
2ZT00omSH`0:H`03oeIF00YF00?om?@02o@00onCT`0:T`03ohJ600Z600?o:RX02RX00ooCd`0:d`03
olK600[600?oIFD02VD00ol4100:1003m_of00[f00>UojD02jD00om4A00:A003o`0000X000?oeMD0
2]D00omQH@0:H@03o`0000800Ol100006`02o`<03_l<5P03ojVY00ZY00?oHf<02V<00omFEP0:EP03
ooCd00_d00?oTi<02Y<00on6QP0:QP03obXZ00XZ00?odm<02]<00oo6aP0:aP03ofEU00YU00?o10@0
2P@00oKomP0:mP03YOnU00^U00?oA4@02T@00ol0000:0003omGE00[E00?oHF402V401?l00002o`40
000K0003o`0000803_l<5P03ojVY00ZY00?oHf<02V<00omFEP0:EP03ooCd00_d00?oTi<02Y<00on6
QP0:QP03obXZ00XZ00?odm<02]<00oo6aP0:aP03ofEU00YU00?o10@02P@00oKomP0:mP03YOnU00^U
00?oA4@02T@00ol0000:0003omGE00[E00?oHF402V400ol00002007o0@0001/000?o00000P0>o``F
00?oZJT02ZT00omSH`0:H`03oeIF00YF00?om?@02o@00onCT`0:T`03ohJ600Z600?o:RX02RX00ooC
d`0:d`03olK600[600?oIFD02VD00ol4100:1003m_of00[f00>UojD02jD00om4A00:A003o`0000X0
00?oeMD02]D00omQH@0:H@03o`0000800Ol100006`000ol0000200ko31H00onYZ@0:Z@03of=S00YS
00?oEUH02UH00oodm00;m003oi>C00ZC00?oQXH02XH00olZ:P0::P03om?C00[C00?oa/H02/H00omU
I@0:I@03o`@400X400?fooH02_H00jGoY@0;Y@03odA400Y400?o00002P000ooEe@0:e@03of5Q00YQ
00?o00000P01o`40000K0003o`0000803_l<5P03ojVY00ZY00?oHf<02V<00omFEP0:EP03ooCd00_d
00?oTi<02Y<00on6QP0:QP03obXZ00XZ00?odm<02]<00oo6aP0:aP03ofEU00YU00?o10@02P@00oKo
mP0:mP03YOnU00^U00?oA4@02T@00ol0000:0003omGE00[E00?oHF402V400ol00002007o0@0001/0
00?o00000P0>o``F00?oZJT02ZT00omSH`0:H`03oeIF00YF00?om?@02o@00onCT`0:T`03ohJ600Z6
00?o:RX02RX00ooCd`0:d`03olK600[600?oIFD02VD00ol4100:1003m_of00[f00>UojD02jD00om4
A00:A003o`0000X000?oeMD02]D00omQH@0:H@03o`0000800Ol100006`02o`<0n_l300;o0@0001/0
00?o00000P0>o`aF00?o:RX02RX00ol4100:1003o`0000X000?o5QH02aH00oodm00:m003om?C00[C
00?om_H02_H00ooEe@0:e@03ojVY00ZY00?oTi<02Y<00oo6aP0:aP03YOnU00ZU00=Qof402f400omS
H`0:H`03ohJ600Z600?oIFD02VD00om4A00:A003o`0000800Ol100006`000ol0000200ko35H00olZ
:P0::P03o`@400X400?o00002P000olF5P0;5P03ooCd00[d00?odm<02]<00oofmP0:mP03omGE00[E
00?oZJT02ZT00onCT`0:T`03olK600[600>UojD02ZD00f7oH@0;H@03of=S00YS00?oQXH02XH00omU
I@0:I@03odA400Y400?o00000P01o`40000K0003o`0000803_l<EP03obXZ00XZ00?o10@02P@00ol0
000:0003oaHF00/F00?om?@02_@00ooCd`0:d`03ooKf00[f00?oeMD02]D00onYZ@0:Z@03oi>C00ZC
00?oa/H02/H00jGoY@0:Y@03HOmQ00]Q00?oHf<02V<00on6QP0:QP03ofEU00YU00?oA4@02T@00ol0
0002007o0@0001/000?o00000P0>o`aF00?o:RX02RX00ol4100:1003o`0000X000?o5QH02aH00ood
m00:m003om?C00[C00?om_H02_H00ooEe@0:e@03ojVY00ZY00?oTi<02Y<00oo6aP0:aP03YOnU00ZU
00=Qof402f400omSH`0:H`03ohJ600Z600?oIFD02VD00om4A00:A003o`0000800Ol100006`000ol0
000200ko35H00olZ:P0::P03o`@400X400?o00002P000olF5P0;5P03ooCd00[d00?odm<02]<00oof
mP0:mP03omGE00[E00?oZJT02ZT00onCT`0:T`03olK600[600>UojD02ZD00f7oH@0;H@03of=S00YS
00?oQXH02XH00omUI@0:I@03odA400Y400?o00000P01o`40000K0003o`0000803_l<EP03obXZ00XZ
00?o10@02P@00ol0000:0003oaHF00/F00?om?@02_@00ooCd`0:d`03ooKf00[f00?oeMD02]D00onY
Z@0:Z@03oi>C00ZC00?oa/H02/H00jGoY@0:Y@03HOmQ00]Q00?oHf<02V<00on6QP0:QP03ofEU00YU
00?oA4@02T@00ol00002007o0@0001/00_l300ko35H00olZ:P0::P03o`@400X400?o00002P000olF
5P0;5P03ooCd00[d00?odm<02]<00oofmP0:mP03omGE00[E00?oZJT02ZT00onCT`0:T`03olK600[6
00>UojD02ZD00f7oH@0;H@03of=S00YS00?oQXH02XH00omUI@0:I@03odA400Y400Co00000_l10000
6`000ol0000200ko35H00olZ:P0::P03o`@400X400?o00002P000olF5P0;5P03ooCd00[d00?odm<0
2]<00oofmP0:mP03omGE00[E00?oZJT02ZT00onCT`0:T`03olK600[600>UojD02ZD00f7oH@0;H@03
of=S00YS00?oQXH02XH00omUI@0:I@03odA400Y400?o00000P01o`40000K0003o`0000803_l<EP03
obXZ00XZ00?o10@02P@00ol0000:0003oaHF00/F00?om?@02_@00ooCd`0:d`03ooKf00[f00?oeMD0
2]D00onYZ@0:Z@03oi>C00ZC00?oa/H02/H00jGoY@0:Y@03HOmQ00]Q00?oHf<02V<00on6QP0:QP03
ofEU00YU00?oA4@02T@00ol00002007o0@0001/000?o00000P0>o`aF00?o:RX02RX00ol4100:1003
o`0000X000?o5QH02aH00oodm00:m003om?C00[C00?om_H02_H00ooEe@0:e@03ojVY00ZY00?oTi<0
2Y<00oo6aP0:aP03YOnU00ZU00=Qof402f400omSH`0:H`03ohJ600Z600?oIFD02VD00om4A00:A003
o`0000800Ol100003@03o`<00ol50003o`0000803_l<EP03obXZ00XZ00?o10@02P@00ol0000:0003
oaHF00/F00?om?@02_@00ooCd`0:d`03ooKf00[f00?oeMD02]D00onYZ@0:Z@03oi>C00ZC00?oa/H0
2/H00jGoY@0:Y@03HOmQ00]Q00?oHf<02V<00on6QP0:QP03ofEU00YU00?oA4@02T@00ol00002007o
0@0000h000?o00001@000ol000020003o`0000803_l<EP03obXZ00XZ00?o10@02P@00ol0000:0003
oaHF00/F00?om?@02_@00ooCd`0:d`03ooKf00[f00?oeMD02]D00onYZ@0:Z@03oi>C00ZC00?oa/H0
2/H00jGoY@0:Y@03HOmQ00]Q00?oHf<02V<00on6QP0:QP03ofEU00YU00?oA4@02T@00ol00002007o
0@0000h000?o00001@000ol0000200;o0`3jo`<00_l100003P000ol0000200?o1@000ol0000200ko
38H00onUY@0:Y@03ojVY00ZY00?odm<02]<00ol0000;0003oeIF00YF00?oIFD02VD00omQH@0:H@03
oi>C00ZC00?om_H02_H00olF5P0:5P03obXZ00XZ00=4od@02T@00f?oH`0;H`03olK600[600?oeMD0
2]D00oodm00:m003o`@400X400?o00000P01o`40000>0003o`00008000?o00001@000ol0000200ko
38H00onUY@0:Y@03ojVY00ZY00?odm<02]<00ol0000;0003oeIF00YF00?oIFD02VD00omQH@0:H@03
oi>C00ZC00?om_H02_H00olF5P0:5P03obXZ00XZ00=4od@02T@00f?oH`0;H`03olK600[600?oeMD0
2]D00oodm00:m003o`@400X400?o00000P01o`40000=00;o1004o`@000?o00000P0>o`b600?oYJD0
2ZD00onYZ@0:Z@03om?C00[C00?o00002`000omFEP0:EP03ofEU00YU00?oHF402V400onCT`0:T`03
ooKf00[f00?o5QH02QH00olZ:P0::P03A?m400Y400=Sof<02f<00oo6aP0:aP03omGE00[E00?om?@0
2_@00ol4100:1003o`0000800Ol100006`000ol0000200ko38H00onUY@0:Y@03ojVY00ZY00?odm<0
2]<00ol0000;0003oeIF00YF00?oIFD02VD00omQH@0:H@03oi>C00ZC00?om_H02_H00olF5P0:5P03
obXZ00XZ00=4od@02T@00f?oH`0;H`03olK600[600?oeMD02]D00oodm00:m003o`@400X400?o0000
0P01o`40000K0003o`0000803_l<QP03ojFU00ZU00?oZJT02ZT00ooCd`0:d`03o`0000/000?oEUH0
2UH00omUI@0:I@03of5Q00YQ00?oTi<02Y<00oofmP0:mP03oaHF00XF00?o:RX02RX00dCoA00:A003
HomS00]S00?oa/H02/H00ooEe@0:e@03ooCd00[d00?o10@02P@00ol00002007o0@0001/000?o0000
0P0>o`b600?oYJD02ZD00onYZ@0:Z@03om?C00[C00?o00002`000omFEP0:EP03ofEU00YU00?oHF40
2V400onCT`0:T`03ooKf00[f00?o5QH02QH00olZ:P0::P03A?m400Y400=Sof<02f<00oo6aP0:aP03
omGE00[E00?om?@02_@00ol4100:1003o`0000800Ol100006`02o`<03_l<QP03ojFU00ZU00?oZJT0
2ZT00ooCd`0:d`03o`0000/000?oEUH02UH00omUI@0:I@03of5Q00YQ00?oTi<02Y<00oofmP0:mP03
oaHF00XF00?o:RX02RX00dCoA00:A003HomS00]S00?oa/H02/H00ooEe@0:e@03ooCd00[d00?o10@0
2P@01?l00002o`40000K0003o`0000803_l<QP03ojFU00ZU00?oZJT02ZT00ooCd`0:d`03o`0000/0
00?oEUH02UH00omUI@0:I@03of5Q00YQ00?oTi<02Y<00oofmP0:mP03oaHF00XF00?o:RX02RX00dCo
A00:A003HomS00]S00?oa/H02/H00ooEe@0:e@03ooCd00[d00?o10@02P@00ol00002007o0@0001/0
00?o00000P0>o`b600?oYJD02ZD00onYZ@0:Z@03om?C00[C00?o00002`000omFEP0:EP03ofEU00YU
00?oHF402V400onCT`0:T`03ooKf00[f00?o5QH02QH00olZ:P0::P03A?m400Y400=Sof<02f<00oo6
aP0:aP03omGE00[E00?om?@02_@00ol4100:1003o`0000800Ol100006`000ol0000200ko38H00onU
Y@0:Y@03ojVY00ZY00?odm<02]<00ol0000;0003oeIF00YF00?oIFD02VD00omQH@0:H@03oi>C00ZC
00?om_H02_H00olF5P0:5P03obXZ00XZ00=4od@02T@00f?oH`0;H`03olK600[600?oeMD02]D00ood
m00:m003o`@400X400?o00000P01o`40000K0003o`0000803_l<QP03ojFU00ZU00?oZJT02ZT00ooC
d`0:d`03o`0000/000?oEUH02UH00omUI@0:I@03of5Q00YQ00?oTi<02Y<00oofmP0:mP03oaHF00XF
00?o:RX02RX00dCoA00:A003HomS00]S00?oa/H02/H00ooEe@0:e@03ooCd00[d00?o10@02P@00ol0
0002007o0@0001/000?o00000P0>o`b600?oYJD02ZD00onYZ@0:Z@03om?C00[C00?o00002`000omF
EP0:EP03ofEU00YU00?oHF402V400onCT`0:T`03ooKf00[f00?o5QH02QH00olZ:P0::P03A?m400Y4
00=Sof<02f<00oo6aP0:aP03omGE00[E00?om?@02_@00ol4100:1003o`0000800Ol100006`000ol0
000200ko38H00onUY@0:Y@03ojVY00ZY00?odm<02]<00ol0000;0003oeIF00YF00?oIFD02VD00omQ
H@0:H@03oi>C00ZC00?om_H02_H00olF5P0:5P03obXZ00XZ00=4od@02T@00f?oH`0;H`03olK600[6
00?oeMD02]D00oodm00:m003o`@400X400?o00000P01o`40000K00;o0`3jo`<00_l100006`000ol0
000200ko3<H00olF5P0:5P03ofEU00YU00?oZJT02ZT00ol4100;1003of=S00YS00?om_H02_H00omF
EP0:EP03ojFU00ZU00?om?@02_@00om4A00:A003oi>C00ZC00<0o`002P000hKoQP0;QP03omGE00[E
00?o:RX02RX00omQH@0:H@03om?C00[C00?o00000P01o`40000K0003o`0000803_l<aP03oaHF00XF
00?oIFD02VD00onYZ@0:Z@03o`@400/400?oHf<02V<00oofmP0:mP03oeIF00YF00?oYJD02ZD00ood
m00:m003odA400Y400?oTi<02Y<00`3o000:0003Q_n600^600?oeMD02]D00olZ:P0::P03of5Q00YQ
00?odm<02]<00ol00002007o0@0001/000?o00000P0>o`c600?o5QH02QH00omUI@0:I@03ojVY00ZY
00?o10@02`@00omSH`0:H`03ooKf00[f00?oEUH02UH00onUY@0:Y@03ooCd00[d00?oA4@02T@00onC
T`0:T`030?l000X000>6ohH02hH00ooEe@0:e@03obXZ00XZ00?oHF402V400ooCd`0:d`03o`000080
0Ol100006`000ol0000200ko3<H00olF5P0:5P03ofEU00YU00?oZJT02ZT00ol4100;1003of=S00YS
00?om_H02_H00omFEP0:EP03ojFU00ZU00?om?@02_@00om4A00:A003oi>C00ZC00<0o`002P000hKo
QP0;QP03omGE00[E00?o:RX02RX00omQH@0:H@03om?C00[C00?o00000P01o`40000K0003o`000080
3_l<aP03oaHF00XF00?oIFD02VD00onYZ@0:Z@03o`@400/400?oHf<02V<00oofmP0:mP03oeIF00YF
00?oYJD02ZD00oodm00:m003odA400Y400?oTi<02Y<00`3o000:0003Q_n600^600?oeMD02]D00olZ
:P0::P03of5Q00YQ00?odm<02]<00ol00002007o0@0001/00_l300ko3<H00olF5P0:5P03ofEU00YU
00?oZJT02ZT00ol4100;1003of=S00YS00?om_H02_H00omFEP0:EP03ojFU00ZU00?om?@02_@00om4
A00:A003oi>C00ZC00<0o`002P000hKoQP0;QP03omGE00[E00?o:RX02RX00omQH@0:H@03om?C00[C
00Co00000_l100006`000ol0000200ko3<H00olF5P0:5P03ofEU00YU00?oZJT02ZT00ol4100;1003
of=S00YS00?om_H02_H00omFEP0:EP03ojFU00ZU00?om?@02_@00om4A00:A003oi>C00ZC00<0o`00
2P000hKoQP0;QP03omGE00[E00?o:RX02RX00omQH@0:H@03om?C00[C00?o00000P01o`40000K0003
o`0000803_l<aP03oaHF00XF00?oIFD02VD00onYZ@0:Z@03o`@400/400?oHf<02V<00oofmP0:mP03
oeIF00YF00?oYJD02ZD00oodm00:m003odA400Y400?oTi<02Y<00`3o000:0003Q_n600^600?oeMD0
2]D00olZ:P0::P03of5Q00YQ00?odm<02]<00ol00002007o0@0001/000?o00000P0>o`c600?o5QH0
2QH00omUI@0:I@03ojVY00ZY00?o10@02`@00omSH`0:H`03ooKf00[f00?oEUH02UH00onUY@0:Y@03
ooCd00[d00?oA4@02T@00onCT`0:T`030?l000X000>6ohH02hH00ooEe@0:e@03obXZ00XZ00?oHF40
2V400ooCd`0:d`03o`0000800Ol100006`000ol0000200ko3<H00olF5P0:5P03ofEU00YU00?oZJT0
2ZT00ol4100;1003of=S00YS00?om_H02_H00omFEP0:EP03ojFU00ZU00?om?@02_@00om4A00:A003
oi>C00ZC00<0o`002P000hKoQP0;QP03omGE00[E00?o:RX02RX00omQH@0:H@03om?C00[C00?o0000
0P01o`40000K0003o`0000803_l<aP03oaHF00XF00?oIFD02VD00onYZ@0:Z@03o`@400/400?oHf<0
2V<00oofmP0:mP03oeIF00YF00?oYJD02ZD00oodm00:m003odA400Y400?oTi<02Y<00`3o000:0003
Q_n600^600?oeMD02]D00olZ:P0::P03of5Q00YQ00?odm<02]<00ol00002007o0@0001/000?o0000
0P0>o`c600?o5QH02QH00omUI@0:I@03ojVY00ZY00?o10@02`@00omSH`0:H`03ooKf00[f00?oEUH0
2UH00onUY@0:Y@03ooCd00[d00?oA4@02T@00onCT`0:T`030?l000X000>6ohH02hH00ooEe@0:e@03
obXZ00XZ00?oHF402V400ooCd`0:d`03o`0000800Ol100006`02o`<0n_l300;o0@0001/000?o0000
0P0>o`cf00?oQXH02XH00olF5P0:5P03ojFU00ZU00?o:RX02bX00onYZ@0:Z@03odA400Y400?odm<0
2]<00omSH`0:H`03o`0000X000?oa/H02/H00omFEP0:EP03eOoE00[E00=UofD02fD00oodm00:m003
of5Q00YQ00?o10@02P@00onCT`0:T`03o`0000800Ol100006`000ol0000200ko3?H00on6QP0:QP03
oaHF00XF00?oYJD02ZD00olZ:P0;:P03ojVY00ZY00?oA4@02T@00ooCd`0:d`03of=S00YS00?o0000
2P000oo6aP0:aP03oeIF00YF00?EomD02]D00fGoI@0;I@03ooCd00[d00?oHF402V400ol4100:1003
oi>C00ZC00?o00000P01o`40000K0003o`0000803_l<mP03ohJ600Z600?o5QH02QH00onUY@0:Y@03
obXZ00/Z00?oZJT02ZT00om4A00:A003om?C00[C00?oHf<02V<00ol0000:0003olK600[600?oEUH0
2UH00mGoe@0:e@03IOmU00]U00?om?@02_@00omQH@0:H@03o`@400X400?oTi<02Y<00ol00002007o
0@0000040?ooo`@000?o00000`02o`<00ol50003o`0000803_l<mP03ohJ600Z600?o5QH02QH00onU
Y@0:Y@03obXZ00/Z00?oZJT02ZT00om4A00:A003om?C00[C00?oHf<02V<00ol0000:0003olK600[6
00?oEUH02UH00mGoe@0:e@03IOmU00]U00?om?@02_@00omQH@0:H@03o`@400X400?oTi<02Y<00ol0
0002007o0@00008000?o00000`000ol0000300;o1P000ol000020003o`0000803_l<mP03ohJ600Z6
00?o5QH02QH00onUY@0:Y@03obXZ00/Z00?oZJT02ZT00om4A00:A003om?C00[C00?oHf<02V<00ol0
000:0003olK600[600?oEUH02UH00mGoe@0:e@03IOmU00]U00?om?@02_@00omQH@0:H@03o`@400X4
00?oTi<02Y<00ol00002007o0@00008000?o000010000ol0000:0003o`0000800_l300ko3?H00on6
QP0:QP03oaHF00XF00?oYJD02ZD00olZ:P0;:P03ojVY00ZY00?oA4@02T@00ooCd`0:d`03of=S00YS
00?o00002P000oo6aP0:aP03oeIF00YF00?EomD02]D00fGoI@0;I@03ooCd00[d00?oHF402V400ol4
100:1003oi>C00ZC00Co00000_l100000P000ol000040003o`0000L00ol50003o`0000803_l<mP03
ohJ600Z600?o5QH02QH00onUY@0:Y@03obXZ00/Z00?oZJT02ZT00om4A00:A003om?C00[C00?oHf<0
2V<00ol0000:0003olK600[600?oEUH02UH00mGoe@0:e@03IOmU00]U00?om?@02_@00omQH@0:H@03
o`@400X400?oTi<02Y<00ol00002007o0@00008000?o00001@000ol000060003o`0000D000?o0000
0P0>o`cf00?oQXH02XH00olF5P0:5P03ojFU00ZU00?o:RX02bX00onYZ@0:Z@03odA400Y400?odm<0
2]<00omSH`0:H`03o`0000X000?oa/H02/H00omFEP0:EP03eOoE00[E00=UofD02fD00oodm00:m003
of5Q00YQ00?o10@02P@00onCT`0:T`03o`0000800Ol1000000<0ool01004o`P01?l40003o`000080
3_l<mP03ohJ600Z600?o5QH02QH00onUY@0:Y@03obXZ00/Z00?oZJT02ZT00om4A00:A003om?C00[C
00?oHf<02V<00ol0000:0003olK600[600?oEUH02UH00mGoe@0:e@03IOmU00]U00?om?@02_@00omQ
H@0:H@03o`@400X400?oTi<02Y<00ol00002007o0@0001/000?o00000P0>o`cf00?oQXH02XH00olF
5P0:5P03ojFU00ZU00?o:RX02bX00onYZ@0:Z@03odA400Y400?odm<02]<00omSH`0:H`03o`0000X0
00?oa/H02/H00omFEP0:EP03eOoE00[E00=UofD02fD00oodm00:m003of5Q00YQ00?o10@02P@00onC
T`0:T`03o`0000800Ol100006`000ol0000200ko3?H00on6QP0:QP03oaHF00XF00?oYJD02ZD00olZ
:P0;:P03ojVY00ZY00?oA4@02T@00ooCd`0:d`03of=S00YS00?o00002P000oo6aP0:aP03oeIF00YF
00?EomD02]D00fGoI@0;I@03ooCd00[d00?oHF402V400ol4100:1003oi>C00ZC00?o00000P01o`40
000K0003o`0000803_l<mP03ohJ600Z600?o5QH02QH00onUY@0:Y@03obXZ00/Z00?oZJT02ZT00om4
A00:A003om?C00[C00?oHf<02V<00ol0000:0003olK600[600?oEUH02UH00mGoe@0:e@03IOmU00]U
00?om?@02_@00omQH@0:H@03o`@400X400?oTi<02Y<00ol00002007o0@0001/00_l30?[o0`02o`40
000K0003o`0000803_l<0003ooKf00[f00?oa/H02/H00on6QP0:QP03oeIF00]F00?o5QH02QH00ooE
e@0:e@03ojFU00ZU00?oIFD02VD00olZ:P0::P03ooCd00[d00?oZJT02ZT00f7oH@0:H@03A?m400]4
00?o10@02P@00ooCd`0:d`03oi>C00ZC00?oHf<02V<00ol00002007o0@0001/000?o00000P0>o``0
00?om_H02_H00oo6aP0:aP03ohJ600Z600?oEUH02eH00olF5P0:5P03omGE00[E00?oYJD02ZD00omU
I@0:I@03obXZ00XZ00?om?@02_@00onYZ@0:Z@03HOmQ00YQ00=4od@02d@00ol4100:1003om?C00[C
00?oTi<02Y<00omSH`0:H`03o`0000800Ol100006`000ol0000200ko30000oofmP0:mP03olK600[6
00?oQXH02XH00omFEP0;EP03oaHF00XF00?oeMD02]D00onUY@0:Y@03ofEU00YU00?o:RX02RX00ood
m00:m003ojVY00ZY00=Qof402V400dCoA00;A003o`@400X400?odm<02]<00onCT`0:T`03of=S00YS
00?o00000P01o`40000K0003o`0000803_l<0003ooKf00[f00?oa/H02/H00on6QP0:QP03oeIF00]F
00?o5QH02QH00ooEe@0:e@03ojFU00ZU00?oIFD02VD00olZ:P0::P03ooCd00[d00?oZJT02ZT00f7o
H@0:H@03A?m400]400?o10@02P@00ooCd`0:d`03oi>C00ZC00?oHf<02V<00ol00002007o0@0001/0
00?o00000P0>o``000?om_H02_H00oo6aP0:aP03ohJ600Z600?oEUH02eH00olF5P0:5P03omGE00[E
00?oYJD02ZD00omUI@0:I@03obXZ00XZ00?om?@02_@00onYZ@0:Z@03HOmQ00YQ00=4od@02d@00ol4
100:1003om?C00[C00?oTi<02Y<00omSH`0:H`03o`0000800Ol100006`02o`<03_l<0003ooKf00[f
00?oa/H02/H00on6QP0:QP03oeIF00]F00?o5QH02QH00ooEe@0:e@03ojFU00ZU00?oIFD02VD00olZ
:P0::P03ooCd00[d00?oZJT02ZT00f7oH@0:H@03A?m400]400?o10@02P@00ooCd`0:d`03oi>C00ZC
00?oHf<02V<01?l00002o`40000K0003o`0000803_l<0003ooKf00[f00?oa/H02/H00on6QP0:QP03
oeIF00]F00?o5QH02QH00ooEe@0:e@03ojFU00ZU00?oIFD02VD00olZ:P0::P03ooCd00[d00?oZJT0
2ZT00f7oH@0:H@03A?m400]400?o10@02P@00ooCd`0:d`03oi>C00ZC00?oHf<02V<00ol00002007o
0@0001/000?o00000P0>o``000?om_H02_H00oo6aP0:aP03ohJ600Z600?oEUH02eH00olF5P0:5P03
omGE00[E00?oYJD02ZD00omUI@0:I@03obXZ00XZ00?om?@02_@00onYZ@0:Z@03HOmQ00YQ00=4od@0
2d@00ol4100:1003om?C00[C00?oTi<02Y<00omSH`0:H`03o`0000800Ol100006`000ol0000200ko
30000oofmP0:mP03olK600[600?oQXH02XH00omFEP0;EP03oaHF00XF00?oeMD02]D00onUY@0:Y@03
ofEU00YU00?o:RX02RX00oodm00:m003ojVY00ZY00=Qof402V400dCoA00;A003o`@400X400?odm<0
2]<00onCT`0:T`03of=S00YS00?o00000P01o`40000K0003o`0000803_l<0003ooKf00[f00?oa/H0
2/H00on6QP0:QP03oeIF00]F00?o5QH02QH00ooEe@0:e@03ojFU00ZU00?oIFD02VD00olZ:P0::P03
ooCd00[d00?oZJT02ZT00f7oH@0:H@03A?m400]400?o10@02P@00ooCd`0:d`03oi>C00ZC00?oHf<0
2V<00ol00002007o0@0001/000?o00000P0>o``000?om_H02_H00oo6aP0:aP03ohJ600Z600?oEUH0
2eH00olF5P0:5P03omGE00[E00?oYJD02ZD00omUI@0:I@03obXZ00XZ00?om?@02_@00onYZ@0:Z@03
HOmQ00YQ00=4od@02d@00ol4100:1003om?C00[C00?oTi<02Y<00omSH`0:H`03o`0000800Ol10000
6`000ol0000200ko30000oofmP0:mP03olK600[600?oQXH02XH00omFEP0;EP03oaHF00XF00?oeMD0
2]D00onUY@0:Y@03ofEU00YU00?o:RX02RX00oodm00:m003ojVY00ZY00=Qof402V400dCoA00;A003
o`@400X400?odm<02]<00onCT`0:T`03of=S00YS00?o00000P01o`40000K00;o0`3jo`<00_l10000
6`000ol0003o00400Ol100006`000ol0003o00400Ol100006`000ol000020003o`0001h000?o0000
7@000ol0000N0003o`0001h000?o00007P000ol0000N0003o`0001h000?o00005@01o`40000K0003
o`00008000?o00000`000ol000040003o`0000<000?o000010000ol000040003o`0000<000?o0000
10000ol000030003o`0000@000?o00000`000ol000040003o`0000@000?o00000`000ol000040003
o`0000<000?o000010000ol000030003o`0000@000?o000010000ol000030003o`0000@000?o0000
0`000ol000040003o`0000<000?o000010000ol000040003o`0000<000?o000010000ol000030003
o`0000@000?o00000`000ol000040003o`0000@000?o00000`000ol000040003o`0000<000?o0000
10000ol000030003o`0000800Ol100006`3oo`Go0@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-2.45372, -1.88766, 0.0761092, 
  0.0761092}},
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "The options available to ",
  StyleBox["CayleyTables", "MR"],
  " are generally the same as those for ",
  StyleBox["CayleyTable", "MR"],
  ". See ",
  ButtonBox["section 2.5",
    ButtonData:>{"Guide2B.nb", "Cayley"},
    ButtonStyle->"Hyperlink"],
  " in chapter 2 for details."
}], "Text",
  CellTags->"Cayley"],

Cell[TextData[{
  "The Cayley tables of a ringoid are often not very readable if the set of \
elements is large (20 or more). Occasionally insight can be gained by looking \
at just the color patterns of the tables, without any labels. We can use the \
options ",
  StyleBox["ShowKey", "MR"],
  ", ",
  StyleBox["ShowBodyText", "MR"],
  ", and ",
  StyleBox["ShowSidesText", "MR"],
  " to suppress the printing of textual information."
}], "Text",
  CellTags->"Cayley"],

Cell["\<\
There are some interesting patterns that provide information even \
without seeing a key\
\>", "MathCaption",
  CellTags->{"Cayley", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[BooleanRing[5], Mode \[Rule] Visual, 
      ShowKey \[Rule] False, ShowBodyText \[Rule] False, 
      ShowSidesText \[Rule] False]; \)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .48341 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0115097 0.47619 [
[ 0 0 0 0 ]
[ 1 .48341 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .48341 L
0 .48341 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0115097 0.477324 0.471896 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0526696 0.02886 0.0241703 0.02886 [
[ 0 0 0 0 ]
[ 1 1.01515 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.01515 L
0 1.01515 L
closepath
clip
newpath
1 1 0 r
.05267 .91883 m
.05267 .94769 L
.08153 .94769 L
.08153 .91883 L
F
.08153 .88997 m
.08153 .91883 L
.11039 .91883 L
.11039 .88997 L
F
.11039 .86111 m
.11039 .88997 L
.13925 .88997 L
.13925 .86111 L
F
.13925 .83225 m
.13925 .86111 L
.16811 .86111 L
.16811 .83225 L
F
.16811 .80339 m
.16811 .83225 L
.19697 .83225 L
.19697 .80339 L
F
.19697 .77453 m
.19697 .80339 L
.22583 .80339 L
.22583 .77453 L
F
.22583 .74567 m
.22583 .77453 L
.25469 .77453 L
.25469 .74567 L
F
.25469 .71681 m
.25469 .74567 L
.28355 .74567 L
.28355 .71681 L
F
.28355 .68795 m
.28355 .71681 L
.31241 .71681 L
.31241 .68795 L
F
.31241 .65909 m
.31241 .68795 L
.34127 .68795 L
.34127 .65909 L
F
.34127 .63023 m
.34127 .65909 L
.37013 .65909 L
.37013 .63023 L
F
.37013 .60137 m
.37013 .63023 L
.39899 .63023 L
.39899 .60137 L
F
.39899 .57251 m
.39899 .60137 L
.42785 .60137 L
.42785 .57251 L
F
.42785 .54365 m
.42785 .57251 L
.45671 .57251 L
.45671 .54365 L
F
.45671 .51479 m
.45671 .54365 L
.48557 .54365 L
.48557 .51479 L
F
.48557 .48593 m
.48557 .51479 L
.51443 .51479 L
.51443 .48593 L
F
.51443 .45707 m
.51443 .48593 L
.54329 .48593 L
.54329 .45707 L
F
.54329 .42821 m
.54329 .45707 L
.57215 .45707 L
.57215 .42821 L
F
.57215 .39935 m
.57215 .42821 L
.60101 .42821 L
.60101 .39935 L
F
.60101 .37049 m
.60101 .39935 L
.62987 .39935 L
.62987 .37049 L
F
.62987 .34163 m
.62987 .37049 L
.65873 .37049 L
.65873 .34163 L
F
.65873 .31277 m
.65873 .34163 L
.68759 .34163 L
.68759 .31277 L
F
.68759 .28391 m
.68759 .31277 L
.71645 .31277 L
.71645 .28391 L
F
.71645 .25505 m
.71645 .28391 L
.74531 .28391 L
.74531 .25505 L
F
.74531 .22619 m
.74531 .25505 L
.77417 .25505 L
.77417 .22619 L
F
.77417 .19733 m
.77417 .22619 L
.80303 .22619 L
.80303 .19733 L
F
.80303 .16847 m
.80303 .19733 L
.83189 .19733 L
.83189 .16847 L
F
.83189 .13961 m
.83189 .16847 L
.86075 .16847 L
.86075 .13961 L
F
.86075 .11075 m
.86075 .13961 L
.88961 .13961 L
.88961 .11075 L
F
.88961 .08189 m
.88961 .11075 L
.91847 .11075 L
.91847 .08189 L
F
.91847 .05303 m
.91847 .08189 L
.94733 .08189 L
.94733 .05303 L
F
.94733 .02417 m
.94733 .05303 L
.97619 .05303 L
.97619 .02417 L
F
1 .5 0 r
.08153 .91883 m
.08153 .94769 L
.11039 .94769 L
.11039 .91883 L
F
.05267 .88997 m
.05267 .91883 L
.08153 .91883 L
.08153 .88997 L
F
.13925 .86111 m
.13925 .88997 L
.16811 .88997 L
.16811 .86111 L
F
.11039 .83225 m
.11039 .86111 L
.13925 .86111 L
.13925 .83225 L
F
.19697 .80339 m
.19697 .83225 L
.22583 .83225 L
.22583 .80339 L
F
.16811 .77453 m
.16811 .80339 L
.19697 .80339 L
.19697 .77453 L
F
.25469 .74567 m
.25469 .77453 L
.28355 .77453 L
.28355 .74567 L
F
.22583 .71681 m
.22583 .74567 L
.25469 .74567 L
.25469 .71681 L
F
.31241 .68795 m
.31241 .71681 L
.34127 .71681 L
.34127 .68795 L
F
.28355 .65909 m
.28355 .68795 L
.31241 .68795 L
.31241 .65909 L
F
.37013 .63023 m
.37013 .65909 L
.39899 .65909 L
.39899 .63023 L
F
.34127 .60137 m
.34127 .63023 L
.37013 .63023 L
.37013 .60137 L
F
.42785 .57251 m
.42785 .60137 L
.45671 .60137 L
.45671 .57251 L
F
.39899 .54365 m
.39899 .57251 L
.42785 .57251 L
.42785 .54365 L
F
.48557 .51479 m
.48557 .54365 L
.51443 .54365 L
.51443 .51479 L
F
.45671 .48593 m
.45671 .51479 L
.48557 .51479 L
.48557 .48593 L
F
.54329 .45707 m
.54329 .48593 L
.57215 .48593 L
.57215 .45707 L
F
.51443 .42821 m
.51443 .45707 L
.54329 .45707 L
.54329 .42821 L
F
.60101 .39935 m
.60101 .42821 L
.62987 .42821 L
.62987 .39935 L
F
.57215 .37049 m
.57215 .39935 L
.60101 .39935 L
.60101 .37049 L
F
.65873 .34163 m
.65873 .37049 L
.68759 .37049 L
.68759 .34163 L
F
.62987 .31277 m
.62987 .34163 L
.65873 .34163 L
.65873 .31277 L
F
.71645 .28391 m
.71645 .31277 L
.74531 .31277 L
.74531 .28391 L
F
.68759 .25505 m
.68759 .28391 L
.71645 .28391 L
.71645 .25505 L
F
.77417 .22619 m
.77417 .25505 L
.80303 .25505 L
.80303 .22619 L
F
.74531 .19733 m
.74531 .22619 L
.77417 .22619 L
.77417 .19733 L
F
.83189 .16847 m
.83189 .19733 L
.86075 .19733 L
.86075 .16847 L
F
.80303 .13961 m
.80303 .16847 L
.83189 .16847 L
.83189 .13961 L
F
.88961 .11075 m
.88961 .13961 L
.91847 .13961 L
.91847 .11075 L
F
.86075 .08189 m
.86075 .11075 L
.88961 .11075 L
.88961 .08189 L
F
.94733 .05303 m
.94733 .08189 L
.97619 .08189 L
.97619 .05303 L
F
.91847 .02417 m
.91847 .05303 L
.94733 .05303 L
.94733 .02417 L
F
.56 .37 .6 r
.11039 .91883 m
.11039 .94769 L
.13925 .94769 L
.13925 .91883 L
F
.13925 .88997 m
.13925 .91883 L
.16811 .91883 L
.16811 .88997 L
F
.05267 .86111 m
.05267 .88997 L
.08153 .88997 L
.08153 .86111 L
F
.08153 .83225 m
.08153 .86111 L
.11039 .86111 L
.11039 .83225 L
F
.22583 .80339 m
.22583 .83225 L
.25469 .83225 L
.25469 .80339 L
F
.25469 .77453 m
.25469 .80339 L
.28355 .80339 L
.28355 .77453 L
F
.16811 .74567 m
.16811 .77453 L
.19697 .77453 L
.19697 .74567 L
F
.19697 .71681 m
.19697 .74567 L
.22583 .74567 L
.22583 .71681 L
F
.34127 .68795 m
.34127 .71681 L
.37013 .71681 L
.37013 .68795 L
F
.37013 .65909 m
.37013 .68795 L
.39899 .68795 L
.39899 .65909 L
F
.28355 .63023 m
.28355 .65909 L
.31241 .65909 L
.31241 .63023 L
F
.31241 .60137 m
.31241 .63023 L
.34127 .63023 L
.34127 .60137 L
F
.45671 .57251 m
.45671 .60137 L
.48557 .60137 L
.48557 .57251 L
F
.48557 .54365 m
.48557 .57251 L
.51443 .57251 L
.51443 .54365 L
F
.39899 .51479 m
.39899 .54365 L
.42785 .54365 L
.42785 .51479 L
F
.42785 .48593 m
.42785 .51479 L
.45671 .51479 L
.45671 .48593 L
F
.57215 .45707 m
.57215 .48593 L
.60101 .48593 L
.60101 .45707 L
F
.60101 .42821 m
.60101 .45707 L
.62987 .45707 L
.62987 .42821 L
F
.51443 .39935 m
.51443 .42821 L
.54329 .42821 L
.54329 .39935 L
F
.54329 .37049 m
.54329 .39935 L
.57215 .39935 L
.57215 .37049 L
F
.68759 .34163 m
.68759 .37049 L
.71645 .37049 L
.71645 .34163 L
F
.71645 .31277 m
.71645 .34163 L
.74531 .34163 L
.74531 .31277 L
F
.62987 .28391 m
.62987 .31277 L
.65873 .31277 L
.65873 .28391 L
F
.65873 .25505 m
.65873 .28391 L
.68759 .28391 L
.68759 .25505 L
F
.80303 .22619 m
.80303 .25505 L
.83189 .25505 L
.83189 .22619 L
F
.83189 .19733 m
.83189 .22619 L
.86075 .22619 L
.86075 .19733 L
F
.74531 .16847 m
.74531 .19733 L
.77417 .19733 L
.77417 .16847 L
F
.77417 .13961 m
.77417 .16847 L
.80303 .16847 L
.80303 .13961 L
F
.91847 .11075 m
.91847 .13961 L
.94733 .13961 L
.94733 .11075 L
F
.94733 .08189 m
.94733 .11075 L
.97619 .11075 L
.97619 .08189 L
F
.86075 .05303 m
.86075 .08189 L
.88961 .08189 L
.88961 .05303 L
F
.88961 .02417 m
.88961 .05303 L
.91847 .05303 L
.91847 .02417 L
F
0 0 1 r
.13925 .91883 m
.13925 .94769 L
.16811 .94769 L
.16811 .91883 L
F
.11039 .88997 m
.11039 .91883 L
.13925 .91883 L
.13925 .88997 L
F
.08153 .86111 m
.08153 .88997 L
.11039 .88997 L
.11039 .86111 L
F
.05267 .83225 m
.05267 .86111 L
.08153 .86111 L
.08153 .83225 L
F
.25469 .80339 m
.25469 .83225 L
.28355 .83225 L
.28355 .80339 L
F
.22583 .77453 m
.22583 .80339 L
.25469 .80339 L
.25469 .77453 L
F
.19697 .74567 m
.19697 .77453 L
.22583 .77453 L
.22583 .74567 L
F
.16811 .71681 m
.16811 .74567 L
.19697 .74567 L
.19697 .71681 L
F
.37013 .68795 m
.37013 .71681 L
.39899 .71681 L
.39899 .68795 L
F
.34127 .65909 m
.34127 .68795 L
.37013 .68795 L
.37013 .65909 L
F
.31241 .63023 m
.31241 .65909 L
.34127 .65909 L
.34127 .63023 L
F
.28355 .60137 m
.28355 .63023 L
.31241 .63023 L
.31241 .60137 L
F
.48557 .57251 m
.48557 .60137 L
.51443 .60137 L
.51443 .57251 L
F
.45671 .54365 m
.45671 .57251 L
.48557 .57251 L
.48557 .54365 L
F
.42785 .51479 m
.42785 .54365 L
.45671 .54365 L
.45671 .51479 L
F
.39899 .48593 m
.39899 .51479 L
.42785 .51479 L
.42785 .48593 L
F
.60101 .45707 m
.60101 .48593 L
.62987 .48593 L
.62987 .45707 L
F
.57215 .42821 m
.57215 .45707 L
.60101 .45707 L
.60101 .42821 L
F
.54329 .39935 m
.54329 .42821 L
.57215 .42821 L
.57215 .39935 L
F
.51443 .37049 m
.51443 .39935 L
.54329 .39935 L
.54329 .37049 L
F
.71645 .34163 m
.71645 .37049 L
.74531 .37049 L
.74531 .34163 L
F
.68759 .31277 m
.68759 .34163 L
.71645 .34163 L
.71645 .31277 L
F
.65873 .28391 m
.65873 .31277 L
.68759 .31277 L
.68759 .28391 L
F
.62987 .25505 m
.62987 .28391 L
.65873 .28391 L
.65873 .25505 L
F
.83189 .22619 m
.83189 .25505 L
.86075 .25505 L
.86075 .22619 L
F
.80303 .19733 m
.80303 .22619 L
.83189 .22619 L
.83189 .19733 L
F
.77417 .16847 m
.77417 .19733 L
.80303 .19733 L
.80303 .16847 L
F
.74531 .13961 m
.74531 .16847 L
.77417 .16847 L
.77417 .13961 L
F
.94733 .11075 m
.94733 .13961 L
.97619 .13961 L
.97619 .11075 L
F
.91847 .08189 m
.91847 .11075 L
.94733 .11075 L
.94733 .08189 L
F
.88961 .05303 m
.88961 .08189 L
.91847 .08189 L
.91847 .05303 L
F
.86075 .02417 m
.86075 .05303 L
.88961 .05303 L
.88961 .02417 L
F
.74 .99 .79 r
.16811 .91883 m
.16811 .94769 L
.19697 .94769 L
.19697 .91883 L
F
.19697 .88997 m
.19697 .91883 L
.22583 .91883 L
.22583 .88997 L
F
.22583 .86111 m
.22583 .88997 L
.25469 .88997 L
.25469 .86111 L
F
.25469 .83225 m
.25469 .86111 L
.28355 .86111 L
.28355 .83225 L
F
.05267 .80339 m
.05267 .83225 L
.08153 .83225 L
.08153 .80339 L
F
.08153 .77453 m
.08153 .80339 L
.11039 .80339 L
.11039 .77453 L
F
.11039 .74567 m
.11039 .77453 L
.13925 .77453 L
.13925 .74567 L
F
.13925 .71681 m
.13925 .74567 L
.16811 .74567 L
.16811 .71681 L
F
.39899 .68795 m
.39899 .71681 L
.42785 .71681 L
.42785 .68795 L
F
.42785 .65909 m
.42785 .68795 L
.45671 .68795 L
.45671 .65909 L
F
.45671 .63023 m
.45671 .65909 L
.48557 .65909 L
.48557 .63023 L
F
.48557 .60137 m
.48557 .63023 L
.51443 .63023 L
.51443 .60137 L
F
.28355 .57251 m
.28355 .60137 L
.31241 .60137 L
.31241 .57251 L
F
.31241 .54365 m
.31241 .57251 L
.34127 .57251 L
.34127 .54365 L
F
.34127 .51479 m
.34127 .54365 L
.37013 .54365 L
.37013 .51479 L
F
.37013 .48593 m
.37013 .51479 L
.39899 .51479 L
.39899 .48593 L
F
.62987 .45707 m
.62987 .48593 L
.65873 .48593 L
.65873 .45707 L
F
.65873 .42821 m
.65873 .45707 L
.68759 .45707 L
.68759 .42821 L
F
.68759 .39935 m
.68759 .42821 L
.71645 .42821 L
.71645 .39935 L
F
.71645 .37049 m
.71645 .39935 L
.74531 .39935 L
.74531 .37049 L
F
.51443 .34163 m
.51443 .37049 L
.54329 .37049 L
.54329 .34163 L
F
.54329 .31277 m
.54329 .34163 L
.57215 .34163 L
.57215 .31277 L
F
.57215 .28391 m
.57215 .31277 L
.60101 .31277 L
.60101 .28391 L
F
.60101 .25505 m
.60101 .28391 L
.62987 .28391 L
.62987 .25505 L
F
.86075 .22619 m
.86075 .25505 L
.88961 .25505 L
.88961 .22619 L
F
.88961 .19733 m
.88961 .22619 L
.91847 .22619 L
.91847 .19733 L
F
.91847 .16847 m
.91847 .19733 L
.94733 .19733 L
.94733 .16847 L
F
.94733 .13961 m
.94733 .16847 L
.97619 .16847 L
.97619 .13961 L
F
.74531 .11075 m
.74531 .13961 L
.77417 .13961 L
.77417 .11075 L
F
.77417 .08189 m
.77417 .11075 L
.80303 .11075 L
.80303 .08189 L
F
.80303 .05303 m
.80303 .08189 L
.83189 .08189 L
.83189 .05303 L
F
.83189 .02417 m
.83189 .05303 L
.86075 .05303 L
.86075 .02417 L
F
.251 .878 .816 r
.19697 .91883 m
.19697 .94769 L
.22583 .94769 L
.22583 .91883 L
F
.16811 .88997 m
.16811 .91883 L
.19697 .91883 L
.19697 .88997 L
F
.25469 .86111 m
.25469 .88997 L
.28355 .88997 L
.28355 .86111 L
F
.22583 .83225 m
.22583 .86111 L
.25469 .86111 L
.25469 .83225 L
F
.08153 .80339 m
.08153 .83225 L
.11039 .83225 L
.11039 .80339 L
F
.05267 .77453 m
.05267 .80339 L
.08153 .80339 L
.08153 .77453 L
F
.13925 .74567 m
.13925 .77453 L
.16811 .77453 L
.16811 .74567 L
F
.11039 .71681 m
.11039 .74567 L
.13925 .74567 L
.13925 .71681 L
F
.42785 .68795 m
.42785 .71681 L
.45671 .71681 L
.45671 .68795 L
F
.39899 .65909 m
.39899 .68795 L
.42785 .68795 L
.42785 .65909 L
F
.48557 .63023 m
.48557 .65909 L
.51443 .65909 L
.51443 .63023 L
F
.45671 .60137 m
.45671 .63023 L
.48557 .63023 L
.48557 .60137 L
F
.31241 .57251 m
.31241 .60137 L
.34127 .60137 L
.34127 .57251 L
F
.28355 .54365 m
.28355 .57251 L
.31241 .57251 L
.31241 .54365 L
F
.37013 .51479 m
.37013 .54365 L
.39899 .54365 L
.39899 .51479 L
F
.34127 .48593 m
.34127 .51479 L
.37013 .51479 L
.37013 .48593 L
F
.65873 .45707 m
.65873 .48593 L
.68759 .48593 L
.68759 .45707 L
F
.62987 .42821 m
.62987 .45707 L
.65873 .45707 L
.65873 .42821 L
F
.71645 .39935 m
.71645 .42821 L
.74531 .42821 L
.74531 .39935 L
F
.68759 .37049 m
.68759 .39935 L
.71645 .39935 L
.71645 .37049 L
F
.54329 .34163 m
.54329 .37049 L
.57215 .37049 L
.57215 .34163 L
F
.51443 .31277 m
.51443 .34163 L
.54329 .34163 L
.54329 .31277 L
F
.60101 .28391 m
.60101 .31277 L
.62987 .31277 L
.62987 .28391 L
F
.57215 .25505 m
.57215 .28391 L
.60101 .28391 L
.60101 .25505 L
F
.88961 .22619 m
.88961 .25505 L
.91847 .25505 L
.91847 .22619 L
F
.86075 .19733 m
.86075 .22619 L
.88961 .22619 L
.88961 .19733 L
F
.94733 .16847 m
.94733 .19733 L
.97619 .19733 L
.97619 .16847 L
F
.91847 .13961 m
.91847 .16847 L
.94733 .16847 L
.94733 .13961 L
F
.77417 .11075 m
.77417 .13961 L
.80303 .13961 L
.80303 .11075 L
F
.74531 .08189 m
.74531 .11075 L
.77417 .11075 L
.77417 .08189 L
F
.83189 .05303 m
.83189 .08189 L
.86075 .08189 L
.86075 .05303 L
F
.80303 .02417 m
.80303 .05303 L
.83189 .05303 L
.83189 .02417 L
F
0 .79 .34 r
.22583 .91883 m
.22583 .94769 L
.25469 .94769 L
.25469 .91883 L
F
.25469 .88997 m
.25469 .91883 L
.28355 .91883 L
.28355 .88997 L
F
.16811 .86111 m
.16811 .88997 L
.19697 .88997 L
.19697 .86111 L
F
.19697 .83225 m
.19697 .86111 L
.22583 .86111 L
.22583 .83225 L
F
.11039 .80339 m
.11039 .83225 L
.13925 .83225 L
.13925 .80339 L
F
.13925 .77453 m
.13925 .80339 L
.16811 .80339 L
.16811 .77453 L
F
.05267 .74567 m
.05267 .77453 L
.08153 .77453 L
.08153 .74567 L
F
.08153 .71681 m
.08153 .74567 L
.11039 .74567 L
.11039 .71681 L
F
.45671 .68795 m
.45671 .71681 L
.48557 .71681 L
.48557 .68795 L
F
.48557 .65909 m
.48557 .68795 L
.51443 .68795 L
.51443 .65909 L
F
.39899 .63023 m
.39899 .65909 L
.42785 .65909 L
.42785 .63023 L
F
.42785 .60137 m
.42785 .63023 L
.45671 .63023 L
.45671 .60137 L
F
.34127 .57251 m
.34127 .60137 L
.37013 .60137 L
.37013 .57251 L
F
.37013 .54365 m
.37013 .57251 L
.39899 .57251 L
.39899 .54365 L
F
.28355 .51479 m
.28355 .54365 L
.31241 .54365 L
.31241 .51479 L
F
.31241 .48593 m
.31241 .51479 L
.34127 .51479 L
.34127 .48593 L
F
.68759 .45707 m
.68759 .48593 L
.71645 .48593 L
.71645 .45707 L
F
.71645 .42821 m
.71645 .45707 L
.74531 .45707 L
.74531 .42821 L
F
.62987 .39935 m
.62987 .42821 L
.65873 .42821 L
.65873 .39935 L
F
.65873 .37049 m
.65873 .39935 L
.68759 .39935 L
.68759 .37049 L
F
.57215 .34163 m
.57215 .37049 L
.60101 .37049 L
.60101 .34163 L
F
.60101 .31277 m
.60101 .34163 L
.62987 .34163 L
.62987 .31277 L
F
.51443 .28391 m
.51443 .31277 L
.54329 .31277 L
.54329 .28391 L
F
.54329 .25505 m
.54329 .28391 L
.57215 .28391 L
.57215 .25505 L
F
.91847 .22619 m
.91847 .25505 L
.94733 .25505 L
.94733 .22619 L
F
.94733 .19733 m
.94733 .22619 L
.97619 .22619 L
.97619 .19733 L
F
.86075 .16847 m
.86075 .19733 L
.88961 .19733 L
.88961 .16847 L
F
.88961 .13961 m
.88961 .16847 L
.91847 .16847 L
.91847 .13961 L
F
.80303 .11075 m
.80303 .13961 L
.83189 .13961 L
.83189 .11075 L
F
.83189 .08189 m
.83189 .11075 L
.86075 .11075 L
.86075 .08189 L
F
.74531 .05303 m
.74531 .08189 L
.77417 .08189 L
.77417 .05303 L
F
.77417 .02417 m
.77417 .05303 L
.80303 .05303 L
.80303 .02417 L
F
0 .392 0 r
.25469 .91883 m
.25469 .94769 L
.28355 .94769 L
.28355 .91883 L
F
.22583 .88997 m
.22583 .91883 L
.25469 .91883 L
.25469 .88997 L
F
.19697 .86111 m
.19697 .88997 L
.22583 .88997 L
.22583 .86111 L
F
.16811 .83225 m
.16811 .86111 L
.19697 .86111 L
.19697 .83225 L
F
.13925 .80339 m
.13925 .83225 L
.16811 .83225 L
.16811 .80339 L
F
.11039 .77453 m
.11039 .80339 L
.13925 .80339 L
.13925 .77453 L
F
.08153 .74567 m
.08153 .77453 L
.11039 .77453 L
.11039 .74567 L
F
.05267 .71681 m
.05267 .74567 L
.08153 .74567 L
.08153 .71681 L
F
.48557 .68795 m
.48557 .71681 L
.51443 .71681 L
.51443 .68795 L
F
.45671 .65909 m
.45671 .68795 L
.48557 .68795 L
.48557 .65909 L
F
.42785 .63023 m
.42785 .65909 L
.45671 .65909 L
.45671 .63023 L
F
.39899 .60137 m
.39899 .63023 L
.42785 .63023 L
.42785 .60137 L
F
.37013 .57251 m
.37013 .60137 L
.39899 .60137 L
.39899 .57251 L
F
.34127 .54365 m
.34127 .57251 L
.37013 .57251 L
.37013 .54365 L
F
.31241 .51479 m
.31241 .54365 L
.34127 .54365 L
.34127 .51479 L
F
.28355 .48593 m
.28355 .51479 L
.31241 .51479 L
.31241 .48593 L
F
.71645 .45707 m
.71645 .48593 L
.74531 .48593 L
.74531 .45707 L
F
.68759 .42821 m
.68759 .45707 L
.71645 .45707 L
.71645 .42821 L
F
.65873 .39935 m
.65873 .42821 L
.68759 .42821 L
.68759 .39935 L
F
.62987 .37049 m
.62987 .39935 L
.65873 .39935 L
.65873 .37049 L
F
.60101 .34163 m
.60101 .37049 L
.62987 .37049 L
.62987 .34163 L
F
.57215 .31277 m
.57215 .34163 L
.60101 .34163 L
.60101 .31277 L
F
.54329 .28391 m
.54329 .31277 L
.57215 .31277 L
.57215 .28391 L
F
.51443 .25505 m
.51443 .28391 L
.54329 .28391 L
.54329 .25505 L
F
.94733 .22619 m
.94733 .25505 L
.97619 .25505 L
.97619 .22619 L
F
.91847 .19733 m
.91847 .22619 L
.94733 .22619 L
.94733 .19733 L
F
.88961 .16847 m
.88961 .19733 L
.91847 .19733 L
.91847 .16847 L
F
.86075 .13961 m
.86075 .16847 L
.88961 .16847 L
.88961 .13961 L
F
.83189 .11075 m
.83189 .13961 L
.86075 .13961 L
.86075 .11075 L
F
.80303 .08189 m
.80303 .11075 L
.83189 .11075 L
.83189 .08189 L
F
.77417 .05303 m
.77417 .08189 L
.80303 .08189 L
.80303 .05303 L
F
.74531 .02417 m
.74531 .05303 L
.77417 .05303 L
.77417 .02417 L
F
1 .753 .796 r
.28355 .91883 m
.28355 .94769 L
.31241 .94769 L
.31241 .91883 L
F
.31241 .88997 m
.31241 .91883 L
.34127 .91883 L
.34127 .88997 L
F
.34127 .86111 m
.34127 .88997 L
.37013 .88997 L
.37013 .86111 L
F
.37013 .83225 m
.37013 .86111 L
.39899 .86111 L
.39899 .83225 L
F
.39899 .80339 m
.39899 .83225 L
.42785 .83225 L
.42785 .80339 L
F
.42785 .77453 m
.42785 .80339 L
.45671 .80339 L
.45671 .77453 L
F
.45671 .74567 m
.45671 .77453 L
.48557 .77453 L
.48557 .74567 L
F
.48557 .71681 m
.48557 .74567 L
.51443 .74567 L
.51443 .71681 L
F
.05267 .68795 m
.05267 .71681 L
.08153 .71681 L
.08153 .68795 L
F
.08153 .65909 m
.08153 .68795 L
.11039 .68795 L
.11039 .65909 L
F
.11039 .63023 m
.11039 .65909 L
.13925 .65909 L
.13925 .63023 L
F
.13925 .60137 m
.13925 .63023 L
.16811 .63023 L
.16811 .60137 L
F
.16811 .57251 m
.16811 .60137 L
.19697 .60137 L
.19697 .57251 L
F
.19697 .54365 m
.19697 .57251 L
.22583 .57251 L
.22583 .54365 L
F
.22583 .51479 m
.22583 .54365 L
.25469 .54365 L
.25469 .51479 L
F
.25469 .48593 m
.25469 .51479 L
.28355 .51479 L
.28355 .48593 L
F
.74531 .45707 m
.74531 .48593 L
.77417 .48593 L
.77417 .45707 L
F
.77417 .42821 m
.77417 .45707 L
.80303 .45707 L
.80303 .42821 L
F
.80303 .39935 m
.80303 .42821 L
.83189 .42821 L
.83189 .39935 L
F
.83189 .37049 m
.83189 .39935 L
.86075 .39935 L
.86075 .37049 L
F
.86075 .34163 m
.86075 .37049 L
.88961 .37049 L
.88961 .34163 L
F
.88961 .31277 m
.88961 .34163 L
.91847 .34163 L
.91847 .31277 L
F
.91847 .28391 m
.91847 .31277 L
.94733 .31277 L
.94733 .28391 L
F
.94733 .25505 m
.94733 .28391 L
.97619 .28391 L
.97619 .25505 L
F
.51443 .22619 m
.51443 .25505 L
.54329 .25505 L
.54329 .22619 L
F
.54329 .19733 m
.54329 .22619 L
.57215 .22619 L
.57215 .19733 L
F
.57215 .16847 m
.57215 .19733 L
.60101 .19733 L
.60101 .16847 L
F
.60101 .13961 m
.60101 .16847 L
.62987 .16847 L
.62987 .13961 L
F
.62987 .11075 m
.62987 .13961 L
.65873 .13961 L
.65873 .11075 L
F
.65873 .08189 m
.65873 .11075 L
.68759 .11075 L
.68759 .08189 L
F
.68759 .05303 m
.68759 .08189 L
.71645 .08189 L
.71645 .05303 L
F
.71645 .02417 m
.71645 .05303 L
.74531 .05303 L
.74531 .02417 L
F
.678 .847 .902 r
.31241 .91883 m
.31241 .94769 L
.34127 .94769 L
.34127 .91883 L
F
.28355 .88997 m
.28355 .91883 L
.31241 .91883 L
.31241 .88997 L
F
.37013 .86111 m
.37013 .88997 L
.39899 .88997 L
.39899 .86111 L
F
.34127 .83225 m
.34127 .86111 L
.37013 .86111 L
.37013 .83225 L
F
.42785 .80339 m
.42785 .83225 L
.45671 .83225 L
.45671 .80339 L
F
.39899 .77453 m
.39899 .80339 L
.42785 .80339 L
.42785 .77453 L
F
.48557 .74567 m
.48557 .77453 L
.51443 .77453 L
.51443 .74567 L
F
.45671 .71681 m
.45671 .74567 L
.48557 .74567 L
.48557 .71681 L
F
.08153 .68795 m
.08153 .71681 L
.11039 .71681 L
.11039 .68795 L
F
.05267 .65909 m
.05267 .68795 L
.08153 .68795 L
.08153 .65909 L
F
.13925 .63023 m
.13925 .65909 L
.16811 .65909 L
.16811 .63023 L
F
.11039 .60137 m
.11039 .63023 L
.13925 .63023 L
.13925 .60137 L
F
.19697 .57251 m
.19697 .60137 L
.22583 .60137 L
.22583 .57251 L
F
.16811 .54365 m
.16811 .57251 L
.19697 .57251 L
.19697 .54365 L
F
.25469 .51479 m
.25469 .54365 L
.28355 .54365 L
.28355 .51479 L
F
.22583 .48593 m
.22583 .51479 L
.25469 .51479 L
.25469 .48593 L
F
.77417 .45707 m
.77417 .48593 L
.80303 .48593 L
.80303 .45707 L
F
.74531 .42821 m
.74531 .45707 L
.77417 .45707 L
.77417 .42821 L
F
.83189 .39935 m
.83189 .42821 L
.86075 .42821 L
.86075 .39935 L
F
.80303 .37049 m
.80303 .39935 L
.83189 .39935 L
.83189 .37049 L
F
.88961 .34163 m
.88961 .37049 L
.91847 .37049 L
.91847 .34163 L
F
.86075 .31277 m
.86075 .34163 L
.88961 .34163 L
.88961 .31277 L
F
.94733 .28391 m
.94733 .31277 L
.97619 .31277 L
.97619 .28391 L
F
.91847 .25505 m
.91847 .28391 L
.94733 .28391 L
.94733 .25505 L
F
.54329 .22619 m
.54329 .25505 L
.57215 .25505 L
.57215 .22619 L
F
.51443 .19733 m
.51443 .22619 L
.54329 .22619 L
.54329 .19733 L
F
.60101 .16847 m
.60101 .19733 L
.62987 .19733 L
.62987 .16847 L
F
.57215 .13961 m
.57215 .16847 L
.60101 .16847 L
.60101 .13961 L
F
.65873 .11075 m
.65873 .13961 L
.68759 .13961 L
.68759 .11075 L
F
.62987 .08189 m
.62987 .11075 L
.65873 .11075 L
.65873 .08189 L
F
.71645 .05303 m
.71645 .08189 L
.74531 .08189 L
.74531 .05303 L
F
.68759 .02417 m
.68759 .05303 L
.71645 .05303 L
.71645 .02417 L
F
.89 .81 .34 r
.34127 .91883 m
.34127 .94769 L
.37013 .94769 L
.37013 .91883 L
F
.37013 .88997 m
.37013 .91883 L
.39899 .91883 L
.39899 .88997 L
F
.28355 .86111 m
.28355 .88997 L
.31241 .88997 L
.31241 .86111 L
F
.31241 .83225 m
.31241 .86111 L
.34127 .86111 L
.34127 .83225 L
F
.45671 .80339 m
.45671 .83225 L
.48557 .83225 L
.48557 .80339 L
F
.48557 .77453 m
.48557 .80339 L
.51443 .80339 L
.51443 .77453 L
F
.39899 .74567 m
.39899 .77453 L
.42785 .77453 L
.42785 .74567 L
F
.42785 .71681 m
.42785 .74567 L
.45671 .74567 L
.45671 .71681 L
F
.11039 .68795 m
.11039 .71681 L
.13925 .71681 L
.13925 .68795 L
F
.13925 .65909 m
.13925 .68795 L
.16811 .68795 L
.16811 .65909 L
F
.05267 .63023 m
.05267 .65909 L
.08153 .65909 L
.08153 .63023 L
F
.08153 .60137 m
.08153 .63023 L
.11039 .63023 L
.11039 .60137 L
F
.22583 .57251 m
.22583 .60137 L
.25469 .60137 L
.25469 .57251 L
F
.25469 .54365 m
.25469 .57251 L
.28355 .57251 L
.28355 .54365 L
F
.16811 .51479 m
.16811 .54365 L
.19697 .54365 L
.19697 .51479 L
F
.19697 .48593 m
.19697 .51479 L
.22583 .51479 L
.22583 .48593 L
F
.80303 .45707 m
.80303 .48593 L
.83189 .48593 L
.83189 .45707 L
F
.83189 .42821 m
.83189 .45707 L
.86075 .45707 L
.86075 .42821 L
F
.74531 .39935 m
.74531 .42821 L
.77417 .42821 L
.77417 .39935 L
F
.77417 .37049 m
.77417 .39935 L
.80303 .39935 L
.80303 .37049 L
F
.91847 .34163 m
.91847 .37049 L
.94733 .37049 L
.94733 .34163 L
F
.94733 .31277 m
.94733 .34163 L
.97619 .34163 L
.97619 .31277 L
F
.86075 .28391 m
.86075 .31277 L
.88961 .31277 L
.88961 .28391 L
F
.88961 .25505 m
.88961 .28391 L
.91847 .28391 L
.91847 .25505 L
F
.57215 .22619 m
.57215 .25505 L
.60101 .25505 L
.60101 .22619 L
F
.60101 .19733 m
.60101 .22619 L
.62987 .22619 L
.62987 .19733 L
F
.51443 .16847 m
.51443 .19733 L
.54329 .19733 L
.54329 .16847 L
F
.54329 .13961 m
.54329 .16847 L
.57215 .16847 L
.57215 .13961 L
F
.68759 .11075 m
.68759 .13961 L
.71645 .13961 L
.71645 .11075 L
F
.71645 .08189 m
.71645 .11075 L
.74531 .11075 L
.74531 .08189 L
F
.62987 .05303 m
.62987 .08189 L
.65873 .08189 L
.65873 .05303 L
F
.65873 .02417 m
.65873 .05303 L
.68759 .05303 L
.68759 .02417 L
F
0 1 0 r
.37013 .91883 m
.37013 .94769 L
.39899 .94769 L
.39899 .91883 L
F
.34127 .88997 m
.34127 .91883 L
.37013 .91883 L
.37013 .88997 L
F
.31241 .86111 m
.31241 .88997 L
.34127 .88997 L
.34127 .86111 L
F
.28355 .83225 m
.28355 .86111 L
.31241 .86111 L
.31241 .83225 L
F
.48557 .80339 m
.48557 .83225 L
.51443 .83225 L
.51443 .80339 L
F
.45671 .77453 m
.45671 .80339 L
.48557 .80339 L
.48557 .77453 L
F
.42785 .74567 m
.42785 .77453 L
.45671 .77453 L
.45671 .74567 L
F
.39899 .71681 m
.39899 .74567 L
.42785 .74567 L
.42785 .71681 L
F
.13925 .68795 m
.13925 .71681 L
.16811 .71681 L
.16811 .68795 L
F
.11039 .65909 m
.11039 .68795 L
.13925 .68795 L
.13925 .65909 L
F
.08153 .63023 m
.08153 .65909 L
.11039 .65909 L
.11039 .63023 L
F
.05267 .60137 m
.05267 .63023 L
.08153 .63023 L
.08153 .60137 L
F
.25469 .57251 m
.25469 .60137 L
.28355 .60137 L
.28355 .57251 L
F
.22583 .54365 m
.22583 .57251 L
.25469 .57251 L
.25469 .54365 L
F
.19697 .51479 m
.19697 .54365 L
.22583 .54365 L
.22583 .51479 L
F
.16811 .48593 m
.16811 .51479 L
.19697 .51479 L
.19697 .48593 L
F
.83189 .45707 m
.83189 .48593 L
.86075 .48593 L
.86075 .45707 L
F
.80303 .42821 m
.80303 .45707 L
.83189 .45707 L
.83189 .42821 L
F
.77417 .39935 m
.77417 .42821 L
.80303 .42821 L
.80303 .39935 L
F
.74531 .37049 m
.74531 .39935 L
.77417 .39935 L
.77417 .37049 L
F
.94733 .34163 m
.94733 .37049 L
.97619 .37049 L
.97619 .34163 L
F
.91847 .31277 m
.91847 .34163 L
.94733 .34163 L
.94733 .31277 L
F
.88961 .28391 m
.88961 .31277 L
.91847 .31277 L
.91847 .28391 L
F
.86075 .25505 m
.86075 .28391 L
.88961 .28391 L
.88961 .25505 L
F
.60101 .22619 m
.60101 .25505 L
.62987 .25505 L
.62987 .22619 L
F
.57215 .19733 m
.57215 .22619 L
.60101 .22619 L
.60101 .19733 L
F
.54329 .16847 m
.54329 .19733 L
.57215 .19733 L
.57215 .16847 L
F
.51443 .13961 m
.51443 .16847 L
.54329 .16847 L
.54329 .13961 L
F
.71645 .11075 m
.71645 .13961 L
.74531 .13961 L
.74531 .11075 L
F
.68759 .08189 m
.68759 .11075 L
.71645 .11075 L
.71645 .08189 L
F
.65873 .05303 m
.65873 .08189 L
.68759 .08189 L
.68759 .05303 L
F
.62987 .02417 m
.62987 .05303 L
.65873 .05303 L
.65873 .02417 L
F
.5 .165 .165 r
.39899 .91883 m
.39899 .94769 L
.42785 .94769 L
.42785 .91883 L
F
.42785 .88997 m
.42785 .91883 L
.45671 .91883 L
.45671 .88997 L
F
.45671 .86111 m
.45671 .88997 L
.48557 .88997 L
.48557 .86111 L
F
.48557 .83225 m
.48557 .86111 L
.51443 .86111 L
.51443 .83225 L
F
.28355 .80339 m
.28355 .83225 L
.31241 .83225 L
.31241 .80339 L
F
.31241 .77453 m
.31241 .80339 L
.34127 .80339 L
.34127 .77453 L
F
.34127 .74567 m
.34127 .77453 L
.37013 .77453 L
.37013 .74567 L
F
.37013 .71681 m
.37013 .74567 L
.39899 .74567 L
.39899 .71681 L
F
.16811 .68795 m
.16811 .71681 L
.19697 .71681 L
.19697 .68795 L
F
.19697 .65909 m
.19697 .68795 L
.22583 .68795 L
.22583 .65909 L
F
.22583 .63023 m
.22583 .65909 L
.25469 .65909 L
.25469 .63023 L
F
.25469 .60137 m
.25469 .63023 L
.28355 .63023 L
.28355 .60137 L
F
.05267 .57251 m
.05267 .60137 L
.08153 .60137 L
.08153 .57251 L
F
.08153 .54365 m
.08153 .57251 L
.11039 .57251 L
.11039 .54365 L
F
.11039 .51479 m
.11039 .54365 L
.13925 .54365 L
.13925 .51479 L
F
.13925 .48593 m
.13925 .51479 L
.16811 .51479 L
.16811 .48593 L
F
.86075 .45707 m
.86075 .48593 L
.88961 .48593 L
.88961 .45707 L
F
.88961 .42821 m
.88961 .45707 L
.91847 .45707 L
.91847 .42821 L
F
.91847 .39935 m
.91847 .42821 L
.94733 .42821 L
.94733 .39935 L
F
.94733 .37049 m
.94733 .39935 L
.97619 .39935 L
.97619 .37049 L
F
.74531 .34163 m
.74531 .37049 L
.77417 .37049 L
.77417 .34163 L
F
.77417 .31277 m
.77417 .34163 L
.80303 .34163 L
.80303 .31277 L
F
.80303 .28391 m
.80303 .31277 L
.83189 .31277 L
.83189 .28391 L
F
.83189 .25505 m
.83189 .28391 L
.86075 .28391 L
.86075 .25505 L
F
.62987 .22619 m
.62987 .25505 L
.65873 .25505 L
.65873 .22619 L
F
.65873 .19733 m
.65873 .22619 L
.68759 .22619 L
.68759 .19733 L
F
.68759 .16847 m
.68759 .19733 L
.71645 .19733 L
.71645 .16847 L
F
.71645 .13961 m
.71645 .16847 L
.74531 .16847 L
.74531 .13961 L
F
.51443 .11075 m
.51443 .13961 L
.54329 .13961 L
.54329 .11075 L
F
.54329 .08189 m
.54329 .11075 L
.57215 .11075 L
.57215 .08189 L
F
.57215 .05303 m
.57215 .08189 L
.60101 .08189 L
.60101 .05303 L
F
.60101 .02417 m
.60101 .05303 L
.62987 .05303 L
.62987 .02417 L
F
.753 .753 .753 r
.42785 .91883 m
.42785 .94769 L
.45671 .94769 L
.45671 .91883 L
F
.39899 .88997 m
.39899 .91883 L
.42785 .91883 L
.42785 .88997 L
F
.48557 .86111 m
.48557 .88997 L
.51443 .88997 L
.51443 .86111 L
F
.45671 .83225 m
.45671 .86111 L
.48557 .86111 L
.48557 .83225 L
F
.31241 .80339 m
.31241 .83225 L
.34127 .83225 L
.34127 .80339 L
F
.28355 .77453 m
.28355 .80339 L
.31241 .80339 L
.31241 .77453 L
F
.37013 .74567 m
.37013 .77453 L
.39899 .77453 L
.39899 .74567 L
F
.34127 .71681 m
.34127 .74567 L
.37013 .74567 L
.37013 .71681 L
F
.19697 .68795 m
.19697 .71681 L
.22583 .71681 L
.22583 .68795 L
F
.16811 .65909 m
.16811 .68795 L
.19697 .68795 L
.19697 .65909 L
F
.25469 .63023 m
.25469 .65909 L
.28355 .65909 L
.28355 .63023 L
F
.22583 .60137 m
.22583 .63023 L
.25469 .63023 L
.25469 .60137 L
F
.08153 .57251 m
.08153 .60137 L
.11039 .60137 L
.11039 .57251 L
F
.05267 .54365 m
.05267 .57251 L
.08153 .57251 L
.08153 .54365 L
F
.13925 .51479 m
.13925 .54365 L
.16811 .54365 L
.16811 .51479 L
F
.11039 .48593 m
.11039 .51479 L
.13925 .51479 L
.13925 .48593 L
F
.88961 .45707 m
.88961 .48593 L
.91847 .48593 L
.91847 .45707 L
F
.86075 .42821 m
.86075 .45707 L
.88961 .45707 L
.88961 .42821 L
F
.94733 .39935 m
.94733 .42821 L
.97619 .42821 L
.97619 .39935 L
F
.91847 .37049 m
.91847 .39935 L
.94733 .39935 L
.94733 .37049 L
F
.77417 .34163 m
.77417 .37049 L
.80303 .37049 L
.80303 .34163 L
F
.74531 .31277 m
.74531 .34163 L
.77417 .34163 L
.77417 .31277 L
F
.83189 .28391 m
.83189 .31277 L
.86075 .31277 L
.86075 .28391 L
F
.80303 .25505 m
.80303 .28391 L
.83189 .28391 L
.83189 .25505 L
F
.65873 .22619 m
.65873 .25505 L
.68759 .25505 L
.68759 .22619 L
F
.62987 .19733 m
.62987 .22619 L
.65873 .22619 L
.65873 .19733 L
F
.71645 .16847 m
.71645 .19733 L
.74531 .19733 L
.74531 .16847 L
F
.68759 .13961 m
.68759 .16847 L
.71645 .16847 L
.71645 .13961 L
F
.54329 .11075 m
.54329 .13961 L
.57215 .13961 L
.57215 .11075 L
F
.51443 .08189 m
.51443 .11075 L
.54329 .11075 L
.54329 .08189 L
F
.60101 .05303 m
.60101 .08189 L
.62987 .08189 L
.62987 .05303 L
F
.57215 .02417 m
.57215 .05303 L
.60101 .05303 L
.60101 .02417 L
F
1 0 0 r
.45671 .91883 m
.45671 .94769 L
.48557 .94769 L
.48557 .91883 L
F
.48557 .88997 m
.48557 .91883 L
.51443 .91883 L
.51443 .88997 L
F
.39899 .86111 m
.39899 .88997 L
.42785 .88997 L
.42785 .86111 L
F
.42785 .83225 m
.42785 .86111 L
.45671 .86111 L
.45671 .83225 L
F
.34127 .80339 m
.34127 .83225 L
.37013 .83225 L
.37013 .80339 L
F
.37013 .77453 m
.37013 .80339 L
.39899 .80339 L
.39899 .77453 L
F
.28355 .74567 m
.28355 .77453 L
.31241 .77453 L
.31241 .74567 L
F
.31241 .71681 m
.31241 .74567 L
.34127 .74567 L
.34127 .71681 L
F
.22583 .68795 m
.22583 .71681 L
.25469 .71681 L
.25469 .68795 L
F
.25469 .65909 m
.25469 .68795 L
.28355 .68795 L
.28355 .65909 L
F
.16811 .63023 m
.16811 .65909 L
.19697 .65909 L
.19697 .63023 L
F
.19697 .60137 m
.19697 .63023 L
.22583 .63023 L
.22583 .60137 L
F
.11039 .57251 m
.11039 .60137 L
.13925 .60137 L
.13925 .57251 L
F
.13925 .54365 m
.13925 .57251 L
.16811 .57251 L
.16811 .54365 L
F
.05267 .51479 m
.05267 .54365 L
.08153 .54365 L
.08153 .51479 L
F
.08153 .48593 m
.08153 .51479 L
.11039 .51479 L
.11039 .48593 L
F
.91847 .45707 m
.91847 .48593 L
.94733 .48593 L
.94733 .45707 L
F
.94733 .42821 m
.94733 .45707 L
.97619 .45707 L
.97619 .42821 L
F
.86075 .39935 m
.86075 .42821 L
.88961 .42821 L
.88961 .39935 L
F
.88961 .37049 m
.88961 .39935 L
.91847 .39935 L
.91847 .37049 L
F
.80303 .34163 m
.80303 .37049 L
.83189 .37049 L
.83189 .34163 L
F
.83189 .31277 m
.83189 .34163 L
.86075 .34163 L
.86075 .31277 L
F
.74531 .28391 m
.74531 .31277 L
.77417 .31277 L
.77417 .28391 L
F
.77417 .25505 m
.77417 .28391 L
.80303 .28391 L
.80303 .25505 L
F
.68759 .22619 m
.68759 .25505 L
.71645 .25505 L
.71645 .22619 L
F
.71645 .19733 m
.71645 .22619 L
.74531 .22619 L
.74531 .19733 L
F
.62987 .16847 m
.62987 .19733 L
.65873 .19733 L
.65873 .16847 L
F
.65873 .13961 m
.65873 .16847 L
.68759 .16847 L
.68759 .13961 L
F
.57215 .11075 m
.57215 .13961 L
.60101 .13961 L
.60101 .11075 L
F
.60101 .08189 m
.60101 .11075 L
.62987 .11075 L
.62987 .08189 L
F
.51443 .05303 m
.51443 .08189 L
.54329 .08189 L
.54329 .05303 L
F
.54329 .02417 m
.54329 .05303 L
.57215 .05303 L
.57215 .02417 L
F
.628 .126 .941 r
.48557 .91883 m
.48557 .94769 L
.51443 .94769 L
.51443 .91883 L
F
.45671 .88997 m
.45671 .91883 L
.48557 .91883 L
.48557 .88997 L
F
.42785 .86111 m
.42785 .88997 L
.45671 .88997 L
.45671 .86111 L
F
.39899 .83225 m
.39899 .86111 L
.42785 .86111 L
.42785 .83225 L
F
.37013 .80339 m
.37013 .83225 L
.39899 .83225 L
.39899 .80339 L
F
.34127 .77453 m
.34127 .80339 L
.37013 .80339 L
.37013 .77453 L
F
.31241 .74567 m
.31241 .77453 L
.34127 .77453 L
.34127 .74567 L
F
.28355 .71681 m
.28355 .74567 L
.31241 .74567 L
.31241 .71681 L
F
.25469 .68795 m
.25469 .71681 L
.28355 .71681 L
.28355 .68795 L
F
.22583 .65909 m
.22583 .68795 L
.25469 .68795 L
.25469 .65909 L
F
.19697 .63023 m
.19697 .65909 L
.22583 .65909 L
.22583 .63023 L
F
.16811 .60137 m
.16811 .63023 L
.19697 .63023 L
.19697 .60137 L
F
.13925 .57251 m
.13925 .60137 L
.16811 .60137 L
.16811 .57251 L
F
.11039 .54365 m
.11039 .57251 L
.13925 .57251 L
.13925 .54365 L
F
.08153 .51479 m
.08153 .54365 L
.11039 .54365 L
.11039 .51479 L
F
.05267 .48593 m
.05267 .51479 L
.08153 .51479 L
.08153 .48593 L
F
.94733 .45707 m
.94733 .48593 L
.97619 .48593 L
.97619 .45707 L
F
.91847 .42821 m
.91847 .45707 L
.94733 .45707 L
.94733 .42821 L
F
.88961 .39935 m
.88961 .42821 L
.91847 .42821 L
.91847 .39935 L
F
.86075 .37049 m
.86075 .39935 L
.88961 .39935 L
.88961 .37049 L
F
.83189 .34163 m
.83189 .37049 L
.86075 .37049 L
.86075 .34163 L
F
.80303 .31277 m
.80303 .34163 L
.83189 .34163 L
.83189 .31277 L
F
.77417 .28391 m
.77417 .31277 L
.80303 .31277 L
.80303 .28391 L
F
.74531 .25505 m
.74531 .28391 L
.77417 .28391 L
.77417 .25505 L
F
.71645 .22619 m
.71645 .25505 L
.74531 .25505 L
.74531 .22619 L
F
.68759 .19733 m
.68759 .22619 L
.71645 .22619 L
.71645 .19733 L
F
.65873 .16847 m
.65873 .19733 L
.68759 .19733 L
.68759 .16847 L
F
.62987 .13961 m
.62987 .16847 L
.65873 .16847 L
.65873 .13961 L
F
.60101 .11075 m
.60101 .13961 L
.62987 .13961 L
.62987 .11075 L
F
.57215 .08189 m
.57215 .11075 L
.60101 .11075 L
.60101 .08189 L
F
.54329 .05303 m
.54329 .08189 L
.57215 .08189 L
.57215 .05303 L
F
.51443 .02417 m
.51443 .05303 L
.54329 .05303 L
.54329 .02417 L
F
1 .6 .07 r
.51443 .91883 m
.51443 .94769 L
.54329 .94769 L
.54329 .91883 L
F
.54329 .88997 m
.54329 .91883 L
.57215 .91883 L
.57215 .88997 L
F
.57215 .86111 m
.57215 .88997 L
.60101 .88997 L
.60101 .86111 L
F
.60101 .83225 m
.60101 .86111 L
.62987 .86111 L
.62987 .83225 L
F
.62987 .80339 m
.62987 .83225 L
.65873 .83225 L
.65873 .80339 L
F
.65873 .77453 m
.65873 .80339 L
.68759 .80339 L
.68759 .77453 L
F
.68759 .74567 m
.68759 .77453 L
.71645 .77453 L
.71645 .74567 L
F
.71645 .71681 m
.71645 .74567 L
.74531 .74567 L
.74531 .71681 L
F
.74531 .68795 m
.74531 .71681 L
.77417 .71681 L
.77417 .68795 L
F
.77417 .65909 m
.77417 .68795 L
.80303 .68795 L
.80303 .65909 L
F
.80303 .63023 m
.80303 .65909 L
.83189 .65909 L
.83189 .63023 L
F
.83189 .60137 m
.83189 .63023 L
.86075 .63023 L
.86075 .60137 L
F
.86075 .57251 m
.86075 .60137 L
.88961 .60137 L
.88961 .57251 L
F
.88961 .54365 m
.88961 .57251 L
.91847 .57251 L
.91847 .54365 L
F
.91847 .51479 m
.91847 .54365 L
.94733 .54365 L
.94733 .51479 L
F
.94733 .48593 m
.94733 .51479 L
.97619 .51479 L
.97619 .48593 L
F
.05267 .45707 m
.05267 .48593 L
.08153 .48593 L
.08153 .45707 L
F
.08153 .42821 m
.08153 .45707 L
.11039 .45707 L
.11039 .42821 L
F
.11039 .39935 m
.11039 .42821 L
.13925 .42821 L
.13925 .39935 L
F
.13925 .37049 m
.13925 .39935 L
.16811 .39935 L
.16811 .37049 L
F
.16811 .34163 m
.16811 .37049 L
.19697 .37049 L
.19697 .34163 L
F
.19697 .31277 m
.19697 .34163 L
.22583 .34163 L
.22583 .31277 L
F
.22583 .28391 m
.22583 .31277 L
.25469 .31277 L
.25469 .28391 L
F
.25469 .25505 m
.25469 .28391 L
.28355 .28391 L
.28355 .25505 L
F
.28355 .22619 m
.28355 .25505 L
.31241 .25505 L
.31241 .22619 L
F
.31241 .19733 m
.31241 .22619 L
.34127 .22619 L
.34127 .19733 L
F
.34127 .16847 m
.34127 .19733 L
.37013 .19733 L
.37013 .16847 L
F
.37013 .13961 m
.37013 .16847 L
.39899 .16847 L
.39899 .13961 L
F
.39899 .11075 m
.39899 .13961 L
.42785 .13961 L
.42785 .11075 L
F
.42785 .08189 m
.42785 .11075 L
.45671 .11075 L
.45671 .08189 L
F
.45671 .05303 m
.45671 .08189 L
.48557 .08189 L
.48557 .05303 L
F
.48557 .02417 m
.48557 .05303 L
.51443 .05303 L
.51443 .02417 L
F
.69 .188 .377 r
.54329 .91883 m
.54329 .94769 L
.57215 .94769 L
.57215 .91883 L
F
.51443 .88997 m
.51443 .91883 L
.54329 .91883 L
.54329 .88997 L
F
.60101 .86111 m
.60101 .88997 L
.62987 .88997 L
.62987 .86111 L
F
.57215 .83225 m
.57215 .86111 L
.60101 .86111 L
.60101 .83225 L
F
.65873 .80339 m
.65873 .83225 L
.68759 .83225 L
.68759 .80339 L
F
.62987 .77453 m
.62987 .80339 L
.65873 .80339 L
.65873 .77453 L
F
.71645 .74567 m
.71645 .77453 L
.74531 .77453 L
.74531 .74567 L
F
.68759 .71681 m
.68759 .74567 L
.71645 .74567 L
.71645 .71681 L
F
.77417 .68795 m
.77417 .71681 L
.80303 .71681 L
.80303 .68795 L
F
.74531 .65909 m
.74531 .68795 L
.77417 .68795 L
.77417 .65909 L
F
.83189 .63023 m
.83189 .65909 L
.86075 .65909 L
.86075 .63023 L
F
.80303 .60137 m
.80303 .63023 L
.83189 .63023 L
.83189 .60137 L
F
.88961 .57251 m
.88961 .60137 L
.91847 .60137 L
.91847 .57251 L
F
.86075 .54365 m
.86075 .57251 L
.88961 .57251 L
.88961 .54365 L
F
.94733 .51479 m
.94733 .54365 L
.97619 .54365 L
.97619 .51479 L
F
.91847 .48593 m
.91847 .51479 L
.94733 .51479 L
.94733 .48593 L
F
.08153 .45707 m
.08153 .48593 L
.11039 .48593 L
.11039 .45707 L
F
.05267 .42821 m
.05267 .45707 L
.08153 .45707 L
.08153 .42821 L
F
.13925 .39935 m
.13925 .42821 L
.16811 .42821 L
.16811 .39935 L
F
.11039 .37049 m
.11039 .39935 L
.13925 .39935 L
.13925 .37049 L
F
.19697 .34163 m
.19697 .37049 L
.22583 .37049 L
.22583 .34163 L
F
.16811 .31277 m
.16811 .34163 L
.19697 .34163 L
.19697 .31277 L
F
.25469 .28391 m
.25469 .31277 L
.28355 .31277 L
.28355 .28391 L
F
.22583 .25505 m
.22583 .28391 L
.25469 .28391 L
.25469 .25505 L
F
.31241 .22619 m
.31241 .25505 L
.34127 .25505 L
.34127 .22619 L
F
.28355 .19733 m
.28355 .22619 L
.31241 .22619 L
.31241 .19733 L
F
.37013 .16847 m
.37013 .19733 L
.39899 .19733 L
.39899 .16847 L
F
.34127 .13961 m
.34127 .16847 L
.37013 .16847 L
.37013 .13961 L
F
.42785 .11075 m
.42785 .13961 L
.45671 .13961 L
.45671 .11075 L
F
.39899 .08189 m
.39899 .11075 L
.42785 .11075 L
.42785 .08189 L
F
.48557 .05303 m
.48557 .08189 L
.51443 .08189 L
.51443 .05303 L
F
.45671 .02417 m
.45671 .05303 L
.48557 .05303 L
.48557 .02417 L
F
0 0 .502 r
.57215 .91883 m
.57215 .94769 L
.60101 .94769 L
.60101 .91883 L
F
.60101 .88997 m
.60101 .91883 L
.62987 .91883 L
.62987 .88997 L
F
.51443 .86111 m
.51443 .88997 L
.54329 .88997 L
.54329 .86111 L
F
.54329 .83225 m
.54329 .86111 L
.57215 .86111 L
.57215 .83225 L
F
.68759 .80339 m
.68759 .83225 L
.71645 .83225 L
.71645 .80339 L
F
.71645 .77453 m
.71645 .80339 L
.74531 .80339 L
.74531 .77453 L
F
.62987 .74567 m
.62987 .77453 L
.65873 .77453 L
.65873 .74567 L
F
.65873 .71681 m
.65873 .74567 L
.68759 .74567 L
.68759 .71681 L
F
.80303 .68795 m
.80303 .71681 L
.83189 .71681 L
.83189 .68795 L
F
.83189 .65909 m
.83189 .68795 L
.86075 .68795 L
.86075 .65909 L
F
.74531 .63023 m
.74531 .65909 L
.77417 .65909 L
.77417 .63023 L
F
.77417 .60137 m
.77417 .63023 L
.80303 .63023 L
.80303 .60137 L
F
.91847 .57251 m
.91847 .60137 L
.94733 .60137 L
.94733 .57251 L
F
.94733 .54365 m
.94733 .57251 L
.97619 .57251 L
.97619 .54365 L
F
.86075 .51479 m
.86075 .54365 L
.88961 .54365 L
.88961 .51479 L
F
.88961 .48593 m
.88961 .51479 L
.91847 .51479 L
.91847 .48593 L
F
.11039 .45707 m
.11039 .48593 L
.13925 .48593 L
.13925 .45707 L
F
.13925 .42821 m
.13925 .45707 L
.16811 .45707 L
.16811 .42821 L
F
.05267 .39935 m
.05267 .42821 L
.08153 .42821 L
.08153 .39935 L
F
.08153 .37049 m
.08153 .39935 L
.11039 .39935 L
.11039 .37049 L
F
.22583 .34163 m
.22583 .37049 L
.25469 .37049 L
.25469 .34163 L
F
.25469 .31277 m
.25469 .34163 L
.28355 .34163 L
.28355 .31277 L
F
.16811 .28391 m
.16811 .31277 L
.19697 .31277 L
.19697 .28391 L
F
.19697 .25505 m
.19697 .28391 L
.22583 .28391 L
.22583 .25505 L
F
.34127 .22619 m
.34127 .25505 L
.37013 .25505 L
.37013 .22619 L
F
.37013 .19733 m
.37013 .22619 L
.39899 .22619 L
.39899 .19733 L
F
.28355 .16847 m
.28355 .19733 L
.31241 .19733 L
.31241 .16847 L
F
.31241 .13961 m
.31241 .16847 L
.34127 .16847 L
.34127 .13961 L
F
.45671 .11075 m
.45671 .13961 L
.48557 .13961 L
.48557 .11075 L
F
.48557 .08189 m
.48557 .11075 L
.51443 .11075 L
.51443 .08189 L
F
.39899 .05303 m
.39899 .08189 L
.42785 .08189 L
.42785 .05303 L
F
.42785 .02417 m
.42785 .05303 L
.45671 .05303 L
.45671 .02417 L
F
.98 .502 .447 r
.60101 .91883 m
.60101 .94769 L
.62987 .94769 L
.62987 .91883 L
F
.57215 .88997 m
.57215 .91883 L
.60101 .91883 L
.60101 .88997 L
F
.54329 .86111 m
.54329 .88997 L
.57215 .88997 L
.57215 .86111 L
F
.51443 .83225 m
.51443 .86111 L
.54329 .86111 L
.54329 .83225 L
F
.71645 .80339 m
.71645 .83225 L
.74531 .83225 L
.74531 .80339 L
F
.68759 .77453 m
.68759 .80339 L
.71645 .80339 L
.71645 .77453 L
F
.65873 .74567 m
.65873 .77453 L
.68759 .77453 L
.68759 .74567 L
F
.62987 .71681 m
.62987 .74567 L
.65873 .74567 L
.65873 .71681 L
F
.83189 .68795 m
.83189 .71681 L
.86075 .71681 L
.86075 .68795 L
F
.80303 .65909 m
.80303 .68795 L
.83189 .68795 L
.83189 .65909 L
F
.77417 .63023 m
.77417 .65909 L
.80303 .65909 L
.80303 .63023 L
F
.74531 .60137 m
.74531 .63023 L
.77417 .63023 L
.77417 .60137 L
F
.94733 .57251 m
.94733 .60137 L
.97619 .60137 L
.97619 .57251 L
F
.91847 .54365 m
.91847 .57251 L
.94733 .57251 L
.94733 .54365 L
F
.88961 .51479 m
.88961 .54365 L
.91847 .54365 L
.91847 .51479 L
F
.86075 .48593 m
.86075 .51479 L
.88961 .51479 L
.88961 .48593 L
F
.13925 .45707 m
.13925 .48593 L
.16811 .48593 L
.16811 .45707 L
F
.11039 .42821 m
.11039 .45707 L
.13925 .45707 L
.13925 .42821 L
F
.08153 .39935 m
.08153 .42821 L
.11039 .42821 L
.11039 .39935 L
F
.05267 .37049 m
.05267 .39935 L
.08153 .39935 L
.08153 .37049 L
F
.25469 .34163 m
.25469 .37049 L
.28355 .37049 L
.28355 .34163 L
F
.22583 .31277 m
.22583 .34163 L
.25469 .34163 L
.25469 .31277 L
F
.19697 .28391 m
.19697 .31277 L
.22583 .31277 L
.22583 .28391 L
F
.16811 .25505 m
.16811 .28391 L
.19697 .28391 L
.19697 .25505 L
F
.37013 .22619 m
.37013 .25505 L
.39899 .25505 L
.39899 .22619 L
F
.34127 .19733 m
.34127 .22619 L
.37013 .22619 L
.37013 .19733 L
F
.31241 .16847 m
.31241 .19733 L
.34127 .19733 L
.34127 .16847 L
F
.28355 .13961 m
.28355 .16847 L
.31241 .16847 L
.31241 .13961 L
F
.48557 .11075 m
.48557 .13961 L
.51443 .13961 L
.51443 .11075 L
F
.45671 .08189 m
.45671 .11075 L
.48557 .11075 L
.48557 .08189 L
F
.42785 .05303 m
.42785 .08189 L
.45671 .08189 L
.45671 .05303 L
F
.39899 .02417 m
.39899 .05303 L
.42785 .05303 L
.42785 .02417 L
F
.498 1 .831 r
.62987 .91883 m
.62987 .94769 L
.65873 .94769 L
.65873 .91883 L
F
.65873 .88997 m
.65873 .91883 L
.68759 .91883 L
.68759 .88997 L
F
.68759 .86111 m
.68759 .88997 L
.71645 .88997 L
.71645 .86111 L
F
.71645 .83225 m
.71645 .86111 L
.74531 .86111 L
.74531 .83225 L
F
.51443 .80339 m
.51443 .83225 L
.54329 .83225 L
.54329 .80339 L
F
.54329 .77453 m
.54329 .80339 L
.57215 .80339 L
.57215 .77453 L
F
.57215 .74567 m
.57215 .77453 L
.60101 .77453 L
.60101 .74567 L
F
.60101 .71681 m
.60101 .74567 L
.62987 .74567 L
.62987 .71681 L
F
.86075 .68795 m
.86075 .71681 L
.88961 .71681 L
.88961 .68795 L
F
.88961 .65909 m
.88961 .68795 L
.91847 .68795 L
.91847 .65909 L
F
.91847 .63023 m
.91847 .65909 L
.94733 .65909 L
.94733 .63023 L
F
.94733 .60137 m
.94733 .63023 L
.97619 .63023 L
.97619 .60137 L
F
.74531 .57251 m
.74531 .60137 L
.77417 .60137 L
.77417 .57251 L
F
.77417 .54365 m
.77417 .57251 L
.80303 .57251 L
.80303 .54365 L
F
.80303 .51479 m
.80303 .54365 L
.83189 .54365 L
.83189 .51479 L
F
.83189 .48593 m
.83189 .51479 L
.86075 .51479 L
.86075 .48593 L
F
.16811 .45707 m
.16811 .48593 L
.19697 .48593 L
.19697 .45707 L
F
.19697 .42821 m
.19697 .45707 L
.22583 .45707 L
.22583 .42821 L
F
.22583 .39935 m
.22583 .42821 L
.25469 .42821 L
.25469 .39935 L
F
.25469 .37049 m
.25469 .39935 L
.28355 .39935 L
.28355 .37049 L
F
.05267 .34163 m
.05267 .37049 L
.08153 .37049 L
.08153 .34163 L
F
.08153 .31277 m
.08153 .34163 L
.11039 .34163 L
.11039 .31277 L
F
.11039 .28391 m
.11039 .31277 L
.13925 .31277 L
.13925 .28391 L
F
.13925 .25505 m
.13925 .28391 L
.16811 .28391 L
.16811 .25505 L
F
.39899 .22619 m
.39899 .25505 L
.42785 .25505 L
.42785 .22619 L
F
.42785 .19733 m
.42785 .22619 L
.45671 .22619 L
.45671 .19733 L
F
.45671 .16847 m
.45671 .19733 L
.48557 .19733 L
.48557 .16847 L
F
.48557 .13961 m
.48557 .16847 L
.51443 .16847 L
.51443 .13961 L
F
.28355 .11075 m
.28355 .13961 L
.31241 .13961 L
.31241 .11075 L
F
.31241 .08189 m
.31241 .11075 L
.34127 .11075 L
.34127 .08189 L
F
.34127 .05303 m
.34127 .08189 L
.37013 .08189 L
.37013 .05303 L
F
.37013 .02417 m
.37013 .05303 L
.39899 .05303 L
.39899 .02417 L
F
.03 .18 .33 r
.65873 .91883 m
.65873 .94769 L
.68759 .94769 L
.68759 .91883 L
F
.62987 .88997 m
.62987 .91883 L
.65873 .91883 L
.65873 .88997 L
F
.71645 .86111 m
.71645 .88997 L
.74531 .88997 L
.74531 .86111 L
F
.68759 .83225 m
.68759 .86111 L
.71645 .86111 L
.71645 .83225 L
F
.54329 .80339 m
.54329 .83225 L
.57215 .83225 L
.57215 .80339 L
F
.51443 .77453 m
.51443 .80339 L
.54329 .80339 L
.54329 .77453 L
F
.60101 .74567 m
.60101 .77453 L
.62987 .77453 L
.62987 .74567 L
F
.57215 .71681 m
.57215 .74567 L
.60101 .74567 L
.60101 .71681 L
F
.88961 .68795 m
.88961 .71681 L
.91847 .71681 L
.91847 .68795 L
F
.86075 .65909 m
.86075 .68795 L
.88961 .68795 L
.88961 .65909 L
F
.94733 .63023 m
.94733 .65909 L
.97619 .65909 L
.97619 .63023 L
F
.91847 .60137 m
.91847 .63023 L
.94733 .63023 L
.94733 .60137 L
F
.77417 .57251 m
.77417 .60137 L
.80303 .60137 L
.80303 .57251 L
F
.74531 .54365 m
.74531 .57251 L
.77417 .57251 L
.77417 .54365 L
F
.83189 .51479 m
.83189 .54365 L
.86075 .54365 L
.86075 .51479 L
F
.80303 .48593 m
.80303 .51479 L
.83189 .51479 L
.83189 .48593 L
F
.19697 .45707 m
.19697 .48593 L
.22583 .48593 L
.22583 .45707 L
F
.16811 .42821 m
.16811 .45707 L
.19697 .45707 L
.19697 .42821 L
F
.25469 .39935 m
.25469 .42821 L
.28355 .42821 L
.28355 .39935 L
F
.22583 .37049 m
.22583 .39935 L
.25469 .39935 L
.25469 .37049 L
F
.08153 .34163 m
.08153 .37049 L
.11039 .37049 L
.11039 .34163 L
F
.05267 .31277 m
.05267 .34163 L
.08153 .34163 L
.08153 .31277 L
F
.13925 .28391 m
.13925 .31277 L
.16811 .31277 L
.16811 .28391 L
F
.11039 .25505 m
.11039 .28391 L
.13925 .28391 L
.13925 .25505 L
F
.42785 .22619 m
.42785 .25505 L
.45671 .25505 L
.45671 .22619 L
F
.39899 .19733 m
.39899 .22619 L
.42785 .22619 L
.42785 .19733 L
F
.48557 .16847 m
.48557 .19733 L
.51443 .19733 L
.51443 .16847 L
F
.45671 .13961 m
.45671 .16847 L
.48557 .16847 L
.48557 .13961 L
F
.31241 .11075 m
.31241 .13961 L
.34127 .13961 L
.34127 .11075 L
F
.28355 .08189 m
.28355 .11075 L
.31241 .11075 L
.31241 .08189 L
F
.37013 .05303 m
.37013 .08189 L
.39899 .08189 L
.39899 .05303 L
F
.34127 .02417 m
.34127 .05303 L
.37013 .05303 L
.37013 .02417 L
F
.902 .902 .98 r
.68759 .91883 m
.68759 .94769 L
.71645 .94769 L
.71645 .91883 L
F
.71645 .88997 m
.71645 .91883 L
.74531 .91883 L
.74531 .88997 L
F
.62987 .86111 m
.62987 .88997 L
.65873 .88997 L
.65873 .86111 L
F
.65873 .83225 m
.65873 .86111 L
.68759 .86111 L
.68759 .83225 L
F
.57215 .80339 m
.57215 .83225 L
.60101 .83225 L
.60101 .80339 L
F
.60101 .77453 m
.60101 .80339 L
.62987 .80339 L
.62987 .77453 L
F
.51443 .74567 m
.51443 .77453 L
.54329 .77453 L
.54329 .74567 L
F
.54329 .71681 m
.54329 .74567 L
.57215 .74567 L
.57215 .71681 L
F
.91847 .68795 m
.91847 .71681 L
.94733 .71681 L
.94733 .68795 L
F
.94733 .65909 m
.94733 .68795 L
.97619 .68795 L
.97619 .65909 L
F
.86075 .63023 m
.86075 .65909 L
.88961 .65909 L
.88961 .63023 L
F
.88961 .60137 m
.88961 .63023 L
.91847 .63023 L
.91847 .60137 L
F
.80303 .57251 m
.80303 .60137 L
.83189 .60137 L
.83189 .57251 L
F
.83189 .54365 m
.83189 .57251 L
.86075 .57251 L
.86075 .54365 L
F
.74531 .51479 m
.74531 .54365 L
.77417 .54365 L
.77417 .51479 L
F
.77417 .48593 m
.77417 .51479 L
.80303 .51479 L
.80303 .48593 L
F
.22583 .45707 m
.22583 .48593 L
.25469 .48593 L
.25469 .45707 L
F
.25469 .42821 m
.25469 .45707 L
.28355 .45707 L
.28355 .42821 L
F
.16811 .39935 m
.16811 .42821 L
.19697 .42821 L
.19697 .39935 L
F
.19697 .37049 m
.19697 .39935 L
.22583 .39935 L
.22583 .37049 L
F
.11039 .34163 m
.11039 .37049 L
.13925 .37049 L
.13925 .34163 L
F
.13925 .31277 m
.13925 .34163 L
.16811 .34163 L
.16811 .31277 L
F
.05267 .28391 m
.05267 .31277 L
.08153 .31277 L
.08153 .28391 L
F
.08153 .25505 m
.08153 .28391 L
.11039 .28391 L
.11039 .25505 L
F
.45671 .22619 m
.45671 .25505 L
.48557 .25505 L
.48557 .22619 L
F
.48557 .19733 m
.48557 .22619 L
.51443 .22619 L
.51443 .19733 L
F
.39899 .16847 m
.39899 .19733 L
.42785 .19733 L
.42785 .16847 L
F
.42785 .13961 m
.42785 .16847 L
.45671 .16847 L
.45671 .13961 L
F
.34127 .11075 m
.34127 .13961 L
.37013 .13961 L
.37013 .11075 L
F
.37013 .08189 m
.37013 .11075 L
.39899 .11075 L
.39899 .08189 L
F
.28355 .05303 m
.28355 .08189 L
.31241 .08189 L
.31241 .05303 L
F
.31241 .02417 m
.31241 .05303 L
.34127 .05303 L
.34127 .02417 L
F
.981 .922 .845 r
.71645 .91883 m
.71645 .94769 L
.74531 .94769 L
.74531 .91883 L
F
.68759 .88997 m
.68759 .91883 L
.71645 .91883 L
.71645 .88997 L
F
.65873 .86111 m
.65873 .88997 L
.68759 .88997 L
.68759 .86111 L
F
.62987 .83225 m
.62987 .86111 L
.65873 .86111 L
.65873 .83225 L
F
.60101 .80339 m
.60101 .83225 L
.62987 .83225 L
.62987 .80339 L
F
.57215 .77453 m
.57215 .80339 L
.60101 .80339 L
.60101 .77453 L
F
.54329 .74567 m
.54329 .77453 L
.57215 .77453 L
.57215 .74567 L
F
.51443 .71681 m
.51443 .74567 L
.54329 .74567 L
.54329 .71681 L
F
.94733 .68795 m
.94733 .71681 L
.97619 .71681 L
.97619 .68795 L
F
.91847 .65909 m
.91847 .68795 L
.94733 .68795 L
.94733 .65909 L
F
.88961 .63023 m
.88961 .65909 L
.91847 .65909 L
.91847 .63023 L
F
.86075 .60137 m
.86075 .63023 L
.88961 .63023 L
.88961 .60137 L
F
.83189 .57251 m
.83189 .60137 L
.86075 .60137 L
.86075 .57251 L
F
.80303 .54365 m
.80303 .57251 L
.83189 .57251 L
.83189 .54365 L
F
.77417 .51479 m
.77417 .54365 L
.80303 .54365 L
.80303 .51479 L
F
.74531 .48593 m
.74531 .51479 L
.77417 .51479 L
.77417 .48593 L
F
.25469 .45707 m
.25469 .48593 L
.28355 .48593 L
.28355 .45707 L
F
.22583 .42821 m
.22583 .45707 L
.25469 .45707 L
.25469 .42821 L
F
.19697 .39935 m
.19697 .42821 L
.22583 .42821 L
.22583 .39935 L
F
.16811 .37049 m
.16811 .39935 L
.19697 .39935 L
.19697 .37049 L
F
.13925 .34163 m
.13925 .37049 L
.16811 .37049 L
.16811 .34163 L
F
.11039 .31277 m
.11039 .34163 L
.13925 .34163 L
.13925 .31277 L
F
.08153 .28391 m
.08153 .31277 L
.11039 .31277 L
.11039 .28391 L
F
.05267 .25505 m
.05267 .28391 L
.08153 .28391 L
.08153 .25505 L
F
.48557 .22619 m
.48557 .25505 L
.51443 .25505 L
.51443 .22619 L
F
.45671 .19733 m
.45671 .22619 L
.48557 .22619 L
.48557 .19733 L
F
.42785 .16847 m
.42785 .19733 L
.45671 .19733 L
.45671 .16847 L
F
.39899 .13961 m
.39899 .16847 L
.42785 .16847 L
.42785 .13961 L
F
.37013 .11075 m
.37013 .13961 L
.39899 .13961 L
.39899 .11075 L
F
.34127 .08189 m
.34127 .11075 L
.37013 .11075 L
.37013 .08189 L
F
.31241 .05303 m
.31241 .08189 L
.34127 .08189 L
.34127 .05303 L
F
.28355 .02417 m
.28355 .05303 L
.31241 .05303 L
.31241 .02417 L
F
1 .898 .772 r
.74531 .91883 m
.74531 .94769 L
.77417 .94769 L
.77417 .91883 L
F
.77417 .88997 m
.77417 .91883 L
.80303 .91883 L
.80303 .88997 L
F
.80303 .86111 m
.80303 .88997 L
.83189 .88997 L
.83189 .86111 L
F
.83189 .83225 m
.83189 .86111 L
.86075 .86111 L
.86075 .83225 L
F
.86075 .80339 m
.86075 .83225 L
.88961 .83225 L
.88961 .80339 L
F
.88961 .77453 m
.88961 .80339 L
.91847 .80339 L
.91847 .77453 L
F
.91847 .74567 m
.91847 .77453 L
.94733 .77453 L
.94733 .74567 L
F
.94733 .71681 m
.94733 .74567 L
.97619 .74567 L
.97619 .71681 L
F
.51443 .68795 m
.51443 .71681 L
.54329 .71681 L
.54329 .68795 L
F
.54329 .65909 m
.54329 .68795 L
.57215 .68795 L
.57215 .65909 L
F
.57215 .63023 m
.57215 .65909 L
.60101 .65909 L
.60101 .63023 L
F
.60101 .60137 m
.60101 .63023 L
.62987 .63023 L
.62987 .60137 L
F
.62987 .57251 m
.62987 .60137 L
.65873 .60137 L
.65873 .57251 L
F
.65873 .54365 m
.65873 .57251 L
.68759 .57251 L
.68759 .54365 L
F
.68759 .51479 m
.68759 .54365 L
.71645 .54365 L
.71645 .51479 L
F
.71645 .48593 m
.71645 .51479 L
.74531 .51479 L
.74531 .48593 L
F
.28355 .45707 m
.28355 .48593 L
.31241 .48593 L
.31241 .45707 L
F
.31241 .42821 m
.31241 .45707 L
.34127 .45707 L
.34127 .42821 L
F
.34127 .39935 m
.34127 .42821 L
.37013 .42821 L
.37013 .39935 L
F
.37013 .37049 m
.37013 .39935 L
.39899 .39935 L
.39899 .37049 L
F
.39899 .34163 m
.39899 .37049 L
.42785 .37049 L
.42785 .34163 L
F
.42785 .31277 m
.42785 .34163 L
.45671 .34163 L
.45671 .31277 L
F
.45671 .28391 m
.45671 .31277 L
.48557 .31277 L
.48557 .28391 L
F
.48557 .25505 m
.48557 .28391 L
.51443 .28391 L
.51443 .25505 L
F
.05267 .22619 m
.05267 .25505 L
.08153 .25505 L
.08153 .22619 L
F
.08153 .19733 m
.08153 .22619 L
.11039 .22619 L
.11039 .19733 L
F
.11039 .16847 m
.11039 .19733 L
.13925 .19733 L
.13925 .16847 L
F
.13925 .13961 m
.13925 .16847 L
.16811 .16847 L
.16811 .13961 L
F
.16811 .11075 m
.16811 .13961 L
.19697 .13961 L
.19697 .11075 L
F
.19697 .08189 m
.19697 .11075 L
.22583 .11075 L
.22583 .08189 L
F
.22583 .05303 m
.22583 .08189 L
.25469 .08189 L
.25469 .05303 L
F
.25469 .02417 m
.25469 .05303 L
.28355 .05303 L
.28355 .02417 L
F
.871 .722 .529 r
.77417 .91883 m
.77417 .94769 L
.80303 .94769 L
.80303 .91883 L
F
.74531 .88997 m
.74531 .91883 L
.77417 .91883 L
.77417 .88997 L
F
.83189 .86111 m
.83189 .88997 L
.86075 .88997 L
.86075 .86111 L
F
.80303 .83225 m
.80303 .86111 L
.83189 .86111 L
.83189 .83225 L
F
.88961 .80339 m
.88961 .83225 L
.91847 .83225 L
.91847 .80339 L
F
.86075 .77453 m
.86075 .80339 L
.88961 .80339 L
.88961 .77453 L
F
.94733 .74567 m
.94733 .77453 L
.97619 .77453 L
.97619 .74567 L
F
.91847 .71681 m
.91847 .74567 L
.94733 .74567 L
.94733 .71681 L
F
.54329 .68795 m
.54329 .71681 L
.57215 .71681 L
.57215 .68795 L
F
.51443 .65909 m
.51443 .68795 L
.54329 .68795 L
.54329 .65909 L
F
.60101 .63023 m
.60101 .65909 L
.62987 .65909 L
.62987 .63023 L
F
.57215 .60137 m
.57215 .63023 L
.60101 .63023 L
.60101 .60137 L
F
.65873 .57251 m
.65873 .60137 L
.68759 .60137 L
.68759 .57251 L
F
.62987 .54365 m
.62987 .57251 L
.65873 .57251 L
.65873 .54365 L
F
.71645 .51479 m
.71645 .54365 L
.74531 .54365 L
.74531 .51479 L
F
.68759 .48593 m
.68759 .51479 L
.71645 .51479 L
.71645 .48593 L
F
.31241 .45707 m
.31241 .48593 L
.34127 .48593 L
.34127 .45707 L
F
.28355 .42821 m
.28355 .45707 L
.31241 .45707 L
.31241 .42821 L
F
.37013 .39935 m
.37013 .42821 L
.39899 .42821 L
.39899 .39935 L
F
.34127 .37049 m
.34127 .39935 L
.37013 .39935 L
.37013 .37049 L
F
.42785 .34163 m
.42785 .37049 L
.45671 .37049 L
.45671 .34163 L
F
.39899 .31277 m
.39899 .34163 L
.42785 .34163 L
.42785 .31277 L
F
.48557 .28391 m
.48557 .31277 L
.51443 .31277 L
.51443 .28391 L
F
.45671 .25505 m
.45671 .28391 L
.48557 .28391 L
.48557 .25505 L
F
.08153 .22619 m
.08153 .25505 L
.11039 .25505 L
.11039 .22619 L
F
.05267 .19733 m
.05267 .22619 L
.08153 .22619 L
.08153 .19733 L
F
.13925 .16847 m
.13925 .19733 L
.16811 .19733 L
.16811 .16847 L
F
.11039 .13961 m
.11039 .16847 L
.13925 .16847 L
.13925 .13961 L
F
.19697 .11075 m
.19697 .13961 L
.22583 .13961 L
.22583 .11075 L
F
.16811 .08189 m
.16811 .11075 L
.19697 .11075 L
.19697 .08189 L
F
.25469 .05303 m
.25469 .08189 L
.28355 .08189 L
.28355 .05303 L
F
.22583 .02417 m
.22583 .05303 L
.25469 .05303 L
.25469 .02417 L
F
.99 .9 .79 r
.80303 .91883 m
.80303 .94769 L
.83189 .94769 L
.83189 .91883 L
F
.83189 .88997 m
.83189 .91883 L
.86075 .91883 L
.86075 .88997 L
F
.74531 .86111 m
.74531 .88997 L
.77417 .88997 L
.77417 .86111 L
F
.77417 .83225 m
.77417 .86111 L
.80303 .86111 L
.80303 .83225 L
F
.91847 .80339 m
.91847 .83225 L
.94733 .83225 L
.94733 .80339 L
F
.94733 .77453 m
.94733 .80339 L
.97619 .80339 L
.97619 .77453 L
F
.86075 .74567 m
.86075 .77453 L
.88961 .77453 L
.88961 .74567 L
F
.88961 .71681 m
.88961 .74567 L
.91847 .74567 L
.91847 .71681 L
F
.57215 .68795 m
.57215 .71681 L
.60101 .71681 L
.60101 .68795 L
F
.60101 .65909 m
.60101 .68795 L
.62987 .68795 L
.62987 .65909 L
F
.51443 .63023 m
.51443 .65909 L
.54329 .65909 L
.54329 .63023 L
F
.54329 .60137 m
.54329 .63023 L
.57215 .63023 L
.57215 .60137 L
F
.68759 .57251 m
.68759 .60137 L
.71645 .60137 L
.71645 .57251 L
F
.71645 .54365 m
.71645 .57251 L
.74531 .57251 L
.74531 .54365 L
F
.62987 .51479 m
.62987 .54365 L
.65873 .54365 L
.65873 .51479 L
F
.65873 .48593 m
.65873 .51479 L
.68759 .51479 L
.68759 .48593 L
F
.34127 .45707 m
.34127 .48593 L
.37013 .48593 L
.37013 .45707 L
F
.37013 .42821 m
.37013 .45707 L
.39899 .45707 L
.39899 .42821 L
F
.28355 .39935 m
.28355 .42821 L
.31241 .42821 L
.31241 .39935 L
F
.31241 .37049 m
.31241 .39935 L
.34127 .39935 L
.34127 .37049 L
F
.45671 .34163 m
.45671 .37049 L
.48557 .37049 L
.48557 .34163 L
F
.48557 .31277 m
.48557 .34163 L
.51443 .34163 L
.51443 .31277 L
F
.39899 .28391 m
.39899 .31277 L
.42785 .31277 L
.42785 .28391 L
F
.42785 .25505 m
.42785 .28391 L
.45671 .28391 L
.45671 .25505 L
F
.11039 .22619 m
.11039 .25505 L
.13925 .25505 L
.13925 .22619 L
F
.13925 .19733 m
.13925 .22619 L
.16811 .22619 L
.16811 .19733 L
F
.05267 .16847 m
.05267 .19733 L
.08153 .19733 L
.08153 .16847 L
F
.08153 .13961 m
.08153 .16847 L
.11039 .16847 L
.11039 .13961 L
F
.22583 .11075 m
.22583 .13961 L
.25469 .13961 L
.25469 .11075 L
F
.25469 .08189 m
.25469 .11075 L
.28355 .11075 L
.28355 .08189 L
F
.16811 .05303 m
.16811 .08189 L
.19697 .08189 L
.19697 .05303 L
F
.19697 .02417 m
.19697 .05303 L
.22583 .05303 L
.22583 .02417 L
F
.941 .902 .549 r
.83189 .91883 m
.83189 .94769 L
.86075 .94769 L
.86075 .91883 L
F
.80303 .88997 m
.80303 .91883 L
.83189 .91883 L
.83189 .88997 L
F
.77417 .86111 m
.77417 .88997 L
.80303 .88997 L
.80303 .86111 L
F
.74531 .83225 m
.74531 .86111 L
.77417 .86111 L
.77417 .83225 L
F
.94733 .80339 m
.94733 .83225 L
.97619 .83225 L
.97619 .80339 L
F
.91847 .77453 m
.91847 .80339 L
.94733 .80339 L
.94733 .77453 L
F
.88961 .74567 m
.88961 .77453 L
.91847 .77453 L
.91847 .74567 L
F
.86075 .71681 m
.86075 .74567 L
.88961 .74567 L
.88961 .71681 L
F
.60101 .68795 m
.60101 .71681 L
.62987 .71681 L
.62987 .68795 L
F
.57215 .65909 m
.57215 .68795 L
.60101 .68795 L
.60101 .65909 L
F
.54329 .63023 m
.54329 .65909 L
.57215 .65909 L
.57215 .63023 L
F
.51443 .60137 m
.51443 .63023 L
.54329 .63023 L
.54329 .60137 L
F
.71645 .57251 m
.71645 .60137 L
.74531 .60137 L
.74531 .57251 L
F
.68759 .54365 m
.68759 .57251 L
.71645 .57251 L
.71645 .54365 L
F
.65873 .51479 m
.65873 .54365 L
.68759 .54365 L
.68759 .51479 L
F
.62987 .48593 m
.62987 .51479 L
.65873 .51479 L
.65873 .48593 L
F
.37013 .45707 m
.37013 .48593 L
.39899 .48593 L
.39899 .45707 L
F
.34127 .42821 m
.34127 .45707 L
.37013 .45707 L
.37013 .42821 L
F
.31241 .39935 m
.31241 .42821 L
.34127 .42821 L
.34127 .39935 L
F
.28355 .37049 m
.28355 .39935 L
.31241 .39935 L
.31241 .37049 L
F
.48557 .34163 m
.48557 .37049 L
.51443 .37049 L
.51443 .34163 L
F
.45671 .31277 m
.45671 .34163 L
.48557 .34163 L
.48557 .31277 L
F
.42785 .28391 m
.42785 .31277 L
.45671 .31277 L
.45671 .28391 L
F
.39899 .25505 m
.39899 .28391 L
.42785 .28391 L
.42785 .25505 L
F
.13925 .22619 m
.13925 .25505 L
.16811 .25505 L
.16811 .22619 L
F
.11039 .19733 m
.11039 .22619 L
.13925 .22619 L
.13925 .19733 L
F
.08153 .16847 m
.08153 .19733 L
.11039 .19733 L
.11039 .16847 L
F
.05267 .13961 m
.05267 .16847 L
.08153 .16847 L
.08153 .13961 L
F
.25469 .11075 m
.25469 .13961 L
.28355 .13961 L
.28355 .11075 L
F
.22583 .08189 m
.22583 .11075 L
.25469 .11075 L
.25469 .08189 L
F
.19697 .05303 m
.19697 .08189 L
.22583 .08189 L
.22583 .05303 L
F
.16811 .02417 m
.16811 .05303 L
.19697 .05303 L
.19697 .02417 L
F
.541 .169 .886 r
.86075 .91883 m
.86075 .94769 L
.88961 .94769 L
.88961 .91883 L
F
.88961 .88997 m
.88961 .91883 L
.91847 .91883 L
.91847 .88997 L
F
.91847 .86111 m
.91847 .88997 L
.94733 .88997 L
.94733 .86111 L
F
.94733 .83225 m
.94733 .86111 L
.97619 .86111 L
.97619 .83225 L
F
.74531 .80339 m
.74531 .83225 L
.77417 .83225 L
.77417 .80339 L
F
.77417 .77453 m
.77417 .80339 L
.80303 .80339 L
.80303 .77453 L
F
.80303 .74567 m
.80303 .77453 L
.83189 .77453 L
.83189 .74567 L
F
.83189 .71681 m
.83189 .74567 L
.86075 .74567 L
.86075 .71681 L
F
.62987 .68795 m
.62987 .71681 L
.65873 .71681 L
.65873 .68795 L
F
.65873 .65909 m
.65873 .68795 L
.68759 .68795 L
.68759 .65909 L
F
.68759 .63023 m
.68759 .65909 L
.71645 .65909 L
.71645 .63023 L
F
.71645 .60137 m
.71645 .63023 L
.74531 .63023 L
.74531 .60137 L
F
.51443 .57251 m
.51443 .60137 L
.54329 .60137 L
.54329 .57251 L
F
.54329 .54365 m
.54329 .57251 L
.57215 .57251 L
.57215 .54365 L
F
.57215 .51479 m
.57215 .54365 L
.60101 .54365 L
.60101 .51479 L
F
.60101 .48593 m
.60101 .51479 L
.62987 .51479 L
.62987 .48593 L
F
.39899 .45707 m
.39899 .48593 L
.42785 .48593 L
.42785 .45707 L
F
.42785 .42821 m
.42785 .45707 L
.45671 .45707 L
.45671 .42821 L
F
.45671 .39935 m
.45671 .42821 L
.48557 .42821 L
.48557 .39935 L
F
.48557 .37049 m
.48557 .39935 L
.51443 .39935 L
.51443 .37049 L
F
.28355 .34163 m
.28355 .37049 L
.31241 .37049 L
.31241 .34163 L
F
.31241 .31277 m
.31241 .34163 L
.34127 .34163 L
.34127 .31277 L
F
.34127 .28391 m
.34127 .31277 L
.37013 .31277 L
.37013 .28391 L
F
.37013 .25505 m
.37013 .28391 L
.39899 .28391 L
.39899 .25505 L
F
.16811 .22619 m
.16811 .25505 L
.19697 .25505 L
.19697 .22619 L
F
.19697 .19733 m
.19697 .22619 L
.22583 .22619 L
.22583 .19733 L
F
.22583 .16847 m
.22583 .19733 L
.25469 .19733 L
.25469 .16847 L
F
.25469 .13961 m
.25469 .16847 L
.28355 .16847 L
.28355 .13961 L
F
.05267 .11075 m
.05267 .13961 L
.08153 .13961 L
.08153 .11075 L
F
.08153 .08189 m
.08153 .11075 L
.11039 .11075 L
.11039 .08189 L
F
.11039 .05303 m
.11039 .08189 L
.13925 .08189 L
.13925 .05303 L
F
.13925 .02417 m
.13925 .05303 L
.16811 .05303 L
.16811 .02417 L
F
1 .38 .01 r
.88961 .91883 m
.88961 .94769 L
.91847 .94769 L
.91847 .91883 L
F
.86075 .88997 m
.86075 .91883 L
.88961 .91883 L
.88961 .88997 L
F
.94733 .86111 m
.94733 .88997 L
.97619 .88997 L
.97619 .86111 L
F
.91847 .83225 m
.91847 .86111 L
.94733 .86111 L
.94733 .83225 L
F
.77417 .80339 m
.77417 .83225 L
.80303 .83225 L
.80303 .80339 L
F
.74531 .77453 m
.74531 .80339 L
.77417 .80339 L
.77417 .77453 L
F
.83189 .74567 m
.83189 .77453 L
.86075 .77453 L
.86075 .74567 L
F
.80303 .71681 m
.80303 .74567 L
.83189 .74567 L
.83189 .71681 L
F
.65873 .68795 m
.65873 .71681 L
.68759 .71681 L
.68759 .68795 L
F
.62987 .65909 m
.62987 .68795 L
.65873 .68795 L
.65873 .65909 L
F
.71645 .63023 m
.71645 .65909 L
.74531 .65909 L
.74531 .63023 L
F
.68759 .60137 m
.68759 .63023 L
.71645 .63023 L
.71645 .60137 L
F
.54329 .57251 m
.54329 .60137 L
.57215 .60137 L
.57215 .57251 L
F
.51443 .54365 m
.51443 .57251 L
.54329 .57251 L
.54329 .54365 L
F
.60101 .51479 m
.60101 .54365 L
.62987 .54365 L
.62987 .51479 L
F
.57215 .48593 m
.57215 .51479 L
.60101 .51479 L
.60101 .48593 L
F
.42785 .45707 m
.42785 .48593 L
.45671 .48593 L
.45671 .45707 L
F
.39899 .42821 m
.39899 .45707 L
.42785 .45707 L
.42785 .42821 L
F
.48557 .39935 m
.48557 .42821 L
.51443 .42821 L
.51443 .39935 L
F
.45671 .37049 m
.45671 .39935 L
.48557 .39935 L
.48557 .37049 L
F
.31241 .34163 m
.31241 .37049 L
.34127 .37049 L
.34127 .34163 L
F
.28355 .31277 m
.28355 .34163 L
.31241 .34163 L
.31241 .31277 L
F
.37013 .28391 m
.37013 .31277 L
.39899 .31277 L
.39899 .28391 L
F
.34127 .25505 m
.34127 .28391 L
.37013 .28391 L
.37013 .25505 L
F
.19697 .22619 m
.19697 .25505 L
.22583 .25505 L
.22583 .22619 L
F
.16811 .19733 m
.16811 .22619 L
.19697 .22619 L
.19697 .19733 L
F
.25469 .16847 m
.25469 .19733 L
.28355 .19733 L
.28355 .16847 L
F
.22583 .13961 m
.22583 .16847 L
.25469 .16847 L
.25469 .13961 L
F
.08153 .11075 m
.08153 .13961 L
.11039 .13961 L
.11039 .11075 L
F
.05267 .08189 m
.05267 .11075 L
.08153 .11075 L
.08153 .08189 L
F
.13925 .05303 m
.13925 .08189 L
.16811 .08189 L
.16811 .05303 L
F
.11039 .02417 m
.11039 .05303 L
.13925 .05303 L
.13925 .02417 L
F
.89 .09 .05 r
.91847 .91883 m
.91847 .94769 L
.94733 .94769 L
.94733 .91883 L
F
.94733 .88997 m
.94733 .91883 L
.97619 .91883 L
.97619 .88997 L
F
.86075 .86111 m
.86075 .88997 L
.88961 .88997 L
.88961 .86111 L
F
.88961 .83225 m
.88961 .86111 L
.91847 .86111 L
.91847 .83225 L
F
.80303 .80339 m
.80303 .83225 L
.83189 .83225 L
.83189 .80339 L
F
.83189 .77453 m
.83189 .80339 L
.86075 .80339 L
.86075 .77453 L
F
.74531 .74567 m
.74531 .77453 L
.77417 .77453 L
.77417 .74567 L
F
.77417 .71681 m
.77417 .74567 L
.80303 .74567 L
.80303 .71681 L
F
.68759 .68795 m
.68759 .71681 L
.71645 .71681 L
.71645 .68795 L
F
.71645 .65909 m
.71645 .68795 L
.74531 .68795 L
.74531 .65909 L
F
.62987 .63023 m
.62987 .65909 L
.65873 .65909 L
.65873 .63023 L
F
.65873 .60137 m
.65873 .63023 L
.68759 .63023 L
.68759 .60137 L
F
.57215 .57251 m
.57215 .60137 L
.60101 .60137 L
.60101 .57251 L
F
.60101 .54365 m
.60101 .57251 L
.62987 .57251 L
.62987 .54365 L
F
.51443 .51479 m
.51443 .54365 L
.54329 .54365 L
.54329 .51479 L
F
.54329 .48593 m
.54329 .51479 L
.57215 .51479 L
.57215 .48593 L
F
.45671 .45707 m
.45671 .48593 L
.48557 .48593 L
.48557 .45707 L
F
.48557 .42821 m
.48557 .45707 L
.51443 .45707 L
.51443 .42821 L
F
.39899 .39935 m
.39899 .42821 L
.42785 .42821 L
.42785 .39935 L
F
.42785 .37049 m
.42785 .39935 L
.45671 .39935 L
.45671 .37049 L
F
.34127 .34163 m
.34127 .37049 L
.37013 .37049 L
.37013 .34163 L
F
.37013 .31277 m
.37013 .34163 L
.39899 .34163 L
.39899 .31277 L
F
.28355 .28391 m
.28355 .31277 L
.31241 .31277 L
.31241 .28391 L
F
.31241 .25505 m
.31241 .28391 L
.34127 .28391 L
.34127 .25505 L
F
.22583 .22619 m
.22583 .25505 L
.25469 .25505 L
.25469 .22619 L
F
.25469 .19733 m
.25469 .22619 L
.28355 .22619 L
.28355 .19733 L
F
.16811 .16847 m
.16811 .19733 L
.19697 .19733 L
.19697 .16847 L
F
.19697 .13961 m
.19697 .16847 L
.22583 .16847 L
.22583 .13961 L
F
.11039 .11075 m
.11039 .13961 L
.13925 .13961 L
.13925 .11075 L
F
.13925 .08189 m
.13925 .11075 L
.16811 .11075 L
.16811 .08189 L
F
.05267 .05303 m
.05267 .08189 L
.08153 .08189 L
.08153 .05303 L
F
.08153 .02417 m
.08153 .05303 L
.11039 .05303 L
.11039 .02417 L
F
.02 .72 .8 r
.94733 .91883 m
.94733 .94769 L
.97619 .94769 L
.97619 .91883 L
F
.91847 .88997 m
.91847 .91883 L
.94733 .91883 L
.94733 .88997 L
F
.88961 .86111 m
.88961 .88997 L
.91847 .88997 L
.91847 .86111 L
F
.86075 .83225 m
.86075 .86111 L
.88961 .86111 L
.88961 .83225 L
F
.83189 .80339 m
.83189 .83225 L
.86075 .83225 L
.86075 .80339 L
F
.80303 .77453 m
.80303 .80339 L
.83189 .80339 L
.83189 .77453 L
F
.77417 .74567 m
.77417 .77453 L
.80303 .77453 L
.80303 .74567 L
F
.74531 .71681 m
.74531 .74567 L
.77417 .74567 L
.77417 .71681 L
F
.71645 .68795 m
.71645 .71681 L
.74531 .71681 L
.74531 .68795 L
F
.68759 .65909 m
.68759 .68795 L
.71645 .68795 L
.71645 .65909 L
F
.65873 .63023 m
.65873 .65909 L
.68759 .65909 L
.68759 .63023 L
F
.62987 .60137 m
.62987 .63023 L
.65873 .63023 L
.65873 .60137 L
F
.60101 .57251 m
.60101 .60137 L
.62987 .60137 L
.62987 .57251 L
F
.57215 .54365 m
.57215 .57251 L
.60101 .57251 L
.60101 .54365 L
F
.54329 .51479 m
.54329 .54365 L
.57215 .54365 L
.57215 .51479 L
F
.51443 .48593 m
.51443 .51479 L
.54329 .51479 L
.54329 .48593 L
F
.48557 .45707 m
.48557 .48593 L
.51443 .48593 L
.51443 .45707 L
F
.45671 .42821 m
.45671 .45707 L
.48557 .45707 L
.48557 .42821 L
F
.42785 .39935 m
.42785 .42821 L
.45671 .42821 L
.45671 .39935 L
F
.39899 .37049 m
.39899 .39935 L
.42785 .39935 L
.42785 .37049 L
F
.37013 .34163 m
.37013 .37049 L
.39899 .37049 L
.39899 .34163 L
F
.34127 .31277 m
.34127 .34163 L
.37013 .34163 L
.37013 .31277 L
F
.31241 .28391 m
.31241 .31277 L
.34127 .31277 L
.34127 .28391 L
F
.28355 .25505 m
.28355 .28391 L
.31241 .28391 L
.31241 .25505 L
F
.25469 .22619 m
.25469 .25505 L
.28355 .25505 L
.28355 .22619 L
F
.22583 .19733 m
.22583 .22619 L
.25469 .22619 L
.25469 .19733 L
F
.19697 .16847 m
.19697 .19733 L
.22583 .19733 L
.22583 .16847 L
F
.16811 .13961 m
.16811 .16847 L
.19697 .16847 L
.19697 .13961 L
F
.13925 .11075 m
.13925 .13961 L
.16811 .13961 L
.16811 .11075 L
F
.11039 .08189 m
.11039 .11075 L
.13925 .11075 L
.13925 .08189 L
F
.08153 .05303 m
.08153 .08189 L
.11039 .08189 L
.11039 .05303 L
F
.05267 .02417 m
.05267 .05303 L
.08153 .05303 L
.08153 .02417 L
F
1 1 0 r
.05267 .94769 m
.05267 .97655 L
.08153 .97655 L
.08153 .94769 L
F
1 .5 0 r
.08153 .94769 m
.08153 .97655 L
.11039 .97655 L
.11039 .94769 L
F
.56 .37 .6 r
.11039 .94769 m
.11039 .97655 L
.13925 .97655 L
.13925 .94769 L
F
0 0 1 r
.13925 .94769 m
.13925 .97655 L
.16811 .97655 L
.16811 .94769 L
F
.74 .99 .79 r
.16811 .94769 m
.16811 .97655 L
.19697 .97655 L
.19697 .94769 L
F
.251 .878 .816 r
.19697 .94769 m
.19697 .97655 L
.22583 .97655 L
.22583 .94769 L
F
0 .79 .34 r
.22583 .94769 m
.22583 .97655 L
.25469 .97655 L
.25469 .94769 L
F
0 .392 0 r
.25469 .94769 m
.25469 .97655 L
.28355 .97655 L
.28355 .94769 L
F
1 .753 .796 r
.28355 .94769 m
.28355 .97655 L
.31241 .97655 L
.31241 .94769 L
F
.678 .847 .902 r
.31241 .94769 m
.31241 .97655 L
.34127 .97655 L
.34127 .94769 L
F
.89 .81 .34 r
.34127 .94769 m
.34127 .97655 L
.37013 .97655 L
.37013 .94769 L
F
0 1 0 r
.37013 .94769 m
.37013 .97655 L
.39899 .97655 L
.39899 .94769 L
F
.5 .165 .165 r
.39899 .94769 m
.39899 .97655 L
.42785 .97655 L
.42785 .94769 L
F
.753 .753 .753 r
.42785 .94769 m
.42785 .97655 L
.45671 .97655 L
.45671 .94769 L
F
1 0 0 r
.45671 .94769 m
.45671 .97655 L
.48557 .97655 L
.48557 .94769 L
F
.628 .126 .941 r
.48557 .94769 m
.48557 .97655 L
.51443 .97655 L
.51443 .94769 L
F
1 .6 .07 r
.51443 .94769 m
.51443 .97655 L
.54329 .97655 L
.54329 .94769 L
F
.69 .188 .377 r
.54329 .94769 m
.54329 .97655 L
.57215 .97655 L
.57215 .94769 L
F
0 0 .502 r
.57215 .94769 m
.57215 .97655 L
.60101 .97655 L
.60101 .94769 L
F
.98 .502 .447 r
.60101 .94769 m
.60101 .97655 L
.62987 .97655 L
.62987 .94769 L
F
.498 1 .831 r
.62987 .94769 m
.62987 .97655 L
.65873 .97655 L
.65873 .94769 L
F
.03 .18 .33 r
.65873 .94769 m
.65873 .97655 L
.68759 .97655 L
.68759 .94769 L
F
.902 .902 .98 r
.68759 .94769 m
.68759 .97655 L
.71645 .97655 L
.71645 .94769 L
F
.981 .922 .845 r
.71645 .94769 m
.71645 .97655 L
.74531 .97655 L
.74531 .94769 L
F
1 .898 .772 r
.74531 .94769 m
.74531 .97655 L
.77417 .97655 L
.77417 .94769 L
F
.871 .722 .529 r
.77417 .94769 m
.77417 .97655 L
.80303 .97655 L
.80303 .94769 L
F
.99 .9 .79 r
.80303 .94769 m
.80303 .97655 L
.83189 .97655 L
.83189 .94769 L
F
.941 .902 .549 r
.83189 .94769 m
.83189 .97655 L
.86075 .97655 L
.86075 .94769 L
F
.541 .169 .886 r
.86075 .94769 m
.86075 .97655 L
.88961 .97655 L
.88961 .94769 L
F
1 .38 .01 r
.88961 .94769 m
.88961 .97655 L
.91847 .97655 L
.91847 .94769 L
F
.89 .09 .05 r
.91847 .94769 m
.91847 .97655 L
.94733 .97655 L
.94733 .94769 L
F
.02 .72 .8 r
.94733 .94769 m
.94733 .97655 L
.97619 .97655 L
.97619 .94769 L
F
1 1 0 r
.02381 .91883 m
.02381 .94769 L
.05267 .94769 L
.05267 .91883 L
F
1 .5 0 r
.02381 .88997 m
.02381 .91883 L
.05267 .91883 L
.05267 .88997 L
F
.56 .37 .6 r
.02381 .86111 m
.02381 .88997 L
.05267 .88997 L
.05267 .86111 L
F
0 0 1 r
.02381 .83225 m
.02381 .86111 L
.05267 .86111 L
.05267 .83225 L
F
.74 .99 .79 r
.02381 .80339 m
.02381 .83225 L
.05267 .83225 L
.05267 .80339 L
F
.251 .878 .816 r
.02381 .77453 m
.02381 .80339 L
.05267 .80339 L
.05267 .77453 L
F
0 .79 .34 r
.02381 .74567 m
.02381 .77453 L
.05267 .77453 L
.05267 .74567 L
F
0 .392 0 r
.02381 .71681 m
.02381 .74567 L
.05267 .74567 L
.05267 .71681 L
F
1 .753 .796 r
.02381 .68795 m
.02381 .71681 L
.05267 .71681 L
.05267 .68795 L
F
.678 .847 .902 r
.02381 .65909 m
.02381 .68795 L
.05267 .68795 L
.05267 .65909 L
F
.89 .81 .34 r
.02381 .63023 m
.02381 .65909 L
.05267 .65909 L
.05267 .63023 L
F
0 1 0 r
.02381 .60137 m
.02381 .63023 L
.05267 .63023 L
.05267 .60137 L
F
.5 .165 .165 r
.02381 .57251 m
.02381 .60137 L
.05267 .60137 L
.05267 .57251 L
F
.753 .753 .753 r
.02381 .54365 m
.02381 .57251 L
.05267 .57251 L
.05267 .54365 L
F
1 0 0 r
.02381 .51479 m
.02381 .54365 L
.05267 .54365 L
.05267 .51479 L
F
.628 .126 .941 r
.02381 .48593 m
.02381 .51479 L
.05267 .51479 L
.05267 .48593 L
F
1 .6 .07 r
.02381 .45707 m
.02381 .48593 L
.05267 .48593 L
.05267 .45707 L
F
.69 .188 .377 r
.02381 .42821 m
.02381 .45707 L
.05267 .45707 L
.05267 .42821 L
F
0 0 .502 r
.02381 .39935 m
.02381 .42821 L
.05267 .42821 L
.05267 .39935 L
F
.98 .502 .447 r
.02381 .37049 m
.02381 .39935 L
.05267 .39935 L
.05267 .37049 L
F
.498 1 .831 r
.02381 .34163 m
.02381 .37049 L
.05267 .37049 L
.05267 .34163 L
F
.03 .18 .33 r
.02381 .31277 m
.02381 .34163 L
.05267 .34163 L
.05267 .31277 L
F
.902 .902 .98 r
.02381 .28391 m
.02381 .31277 L
.05267 .31277 L
.05267 .28391 L
F
.981 .922 .845 r
.02381 .25505 m
.02381 .28391 L
.05267 .28391 L
.05267 .25505 L
F
1 .898 .772 r
.02381 .22619 m
.02381 .25505 L
.05267 .25505 L
.05267 .22619 L
F
.871 .722 .529 r
.02381 .19733 m
.02381 .22619 L
.05267 .22619 L
.05267 .19733 L
F
.99 .9 .79 r
.02381 .16847 m
.02381 .19733 L
.05267 .19733 L
.05267 .16847 L
F
.941 .902 .549 r
.02381 .13961 m
.02381 .16847 L
.05267 .16847 L
.05267 .13961 L
F
.541 .169 .886 r
.02381 .11075 m
.02381 .13961 L
.05267 .13961 L
.05267 .11075 L
F
1 .38 .01 r
.02381 .08189 m
.02381 .11075 L
.05267 .11075 L
.05267 .08189 L
F
.89 .09 .05 r
.02381 .05303 m
.02381 .08189 L
.05267 .08189 L
.05267 .05303 L
F
.02 .72 .8 r
.02381 .02417 m
.02381 .05303 L
.05267 .05303 L
.05267 .02417 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02417 m
.02381 .97655 L
s
.02381 .02417 m
.97619 .02417 L
s
.02381 .05303 m
.97619 .05303 L
s
.02381 .08189 m
.97619 .08189 L
s
.02381 .11075 m
.97619 .11075 L
s
.02381 .13961 m
.97619 .13961 L
s
.02381 .16847 m
.97619 .16847 L
s
.02381 .19733 m
.97619 .19733 L
s
.02381 .22619 m
.97619 .22619 L
s
.02381 .25505 m
.97619 .25505 L
s
.02381 .28391 m
.97619 .28391 L
s
.02381 .31277 m
.97619 .31277 L
s
.02381 .34163 m
.97619 .34163 L
s
.02381 .37049 m
.97619 .37049 L
s
.02381 .39935 m
.97619 .39935 L
s
.02381 .42821 m
.97619 .42821 L
s
.02381 .45707 m
.97619 .45707 L
s
.02381 .48593 m
.97619 .48593 L
s
.02381 .51479 m
.97619 .51479 L
s
.02381 .54365 m
.97619 .54365 L
s
.02381 .57251 m
.97619 .57251 L
s
.02381 .60137 m
.97619 .60137 L
s
.02381 .63023 m
.97619 .63023 L
s
.02381 .65909 m
.97619 .65909 L
s
.02381 .68795 m
.97619 .68795 L
s
.02381 .71681 m
.97619 .71681 L
s
.02381 .74567 m
.97619 .74567 L
s
.02381 .77453 m
.97619 .77453 L
s
.02381 .80339 m
.97619 .80339 L
s
.02381 .83225 m
.97619 .83225 L
s
.02381 .86111 m
.97619 .86111 L
s
.02381 .88997 m
.97619 .88997 L
s
.02381 .91883 m
.97619 .91883 L
s
.02381 .94769 m
.97619 .94769 L
s
.02381 .97655 m
.97619 .97655 L
s
.05267 .02417 m
.05267 .97655 L
s
.08153 .02417 m
.08153 .97655 L
s
.11039 .02417 m
.11039 .97655 L
s
.13925 .02417 m
.13925 .97655 L
s
.16811 .02417 m
.16811 .97655 L
s
.19697 .02417 m
.19697 .97655 L
s
.22583 .02417 m
.22583 .97655 L
s
.25469 .02417 m
.25469 .97655 L
s
.28355 .02417 m
.28355 .97655 L
s
.31241 .02417 m
.31241 .97655 L
s
.34127 .02417 m
.34127 .97655 L
s
.37013 .02417 m
.37013 .97655 L
s
.39899 .02417 m
.39899 .97655 L
s
.42785 .02417 m
.42785 .97655 L
s
.45671 .02417 m
.45671 .97655 L
s
.48557 .02417 m
.48557 .97655 L
s
.51443 .02417 m
.51443 .97655 L
s
.54329 .02417 m
.54329 .97655 L
s
.57215 .02417 m
.57215 .97655 L
s
.60101 .02417 m
.60101 .97655 L
s
.62987 .02417 m
.62987 .97655 L
s
.65873 .02417 m
.65873 .97655 L
s
.68759 .02417 m
.68759 .97655 L
s
.71645 .02417 m
.71645 .97655 L
s
.74531 .02417 m
.74531 .97655 L
s
.77417 .02417 m
.77417 .97655 L
s
.80303 .02417 m
.80303 .97655 L
s
.83189 .02417 m
.83189 .97655 L
s
.86075 .02417 m
.86075 .97655 L
s
.88961 .02417 m
.88961 .97655 L
s
.91847 .02417 m
.91847 .97655 L
s
.94733 .02417 m
.94733 .97655 L
s
.97619 .02417 m
.97619 .97655 L
s
.02381 .97655 m
.05267 .94769 L
s
2.6 Mabswid
.05267 .02417 m
.05267 .97655 L
s
.02381 .94769 m
.97619 .94769 L
s
[(Addition)] .02381 .99098 -1 0 Mshowa
gsave
.97619 .99098 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .03362 .95722 0 0 Mshowa
[(y)] .04545 .96789 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0115097 0.97619 0.471896 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0526696 0.02886 0.0241703 0.02886 [
[ 0 0 0 0 ]
[ 1 1.01515 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.01515 L
0 1.01515 L
closepath
clip
newpath
1 1 0 r
.05267 .91883 m
.05267 .94769 L
.08153 .94769 L
.08153 .91883 L
F
.08153 .91883 m
.08153 .94769 L
.11039 .94769 L
.11039 .91883 L
F
.11039 .91883 m
.11039 .94769 L
.13925 .94769 L
.13925 .91883 L
F
.13925 .91883 m
.13925 .94769 L
.16811 .94769 L
.16811 .91883 L
F
.16811 .91883 m
.16811 .94769 L
.19697 .94769 L
.19697 .91883 L
F
.19697 .91883 m
.19697 .94769 L
.22583 .94769 L
.22583 .91883 L
F
.22583 .91883 m
.22583 .94769 L
.25469 .94769 L
.25469 .91883 L
F
.25469 .91883 m
.25469 .94769 L
.28355 .94769 L
.28355 .91883 L
F
.28355 .91883 m
.28355 .94769 L
.31241 .94769 L
.31241 .91883 L
F
.31241 .91883 m
.31241 .94769 L
.34127 .94769 L
.34127 .91883 L
F
.34127 .91883 m
.34127 .94769 L
.37013 .94769 L
.37013 .91883 L
F
.37013 .91883 m
.37013 .94769 L
.39899 .94769 L
.39899 .91883 L
F
.39899 .91883 m
.39899 .94769 L
.42785 .94769 L
.42785 .91883 L
F
.42785 .91883 m
.42785 .94769 L
.45671 .94769 L
.45671 .91883 L
F
.45671 .91883 m
.45671 .94769 L
.48557 .94769 L
.48557 .91883 L
F
.48557 .91883 m
.48557 .94769 L
.51443 .94769 L
.51443 .91883 L
F
.51443 .91883 m
.51443 .94769 L
.54329 .94769 L
.54329 .91883 L
F
.54329 .91883 m
.54329 .94769 L
.57215 .94769 L
.57215 .91883 L
F
.57215 .91883 m
.57215 .94769 L
.60101 .94769 L
.60101 .91883 L
F
.60101 .91883 m
.60101 .94769 L
.62987 .94769 L
.62987 .91883 L
F
.62987 .91883 m
.62987 .94769 L
.65873 .94769 L
.65873 .91883 L
F
.65873 .91883 m
.65873 .94769 L
.68759 .94769 L
.68759 .91883 L
F
.68759 .91883 m
.68759 .94769 L
.71645 .94769 L
.71645 .91883 L
F
.71645 .91883 m
.71645 .94769 L
.74531 .94769 L
.74531 .91883 L
F
.74531 .91883 m
.74531 .94769 L
.77417 .94769 L
.77417 .91883 L
F
.77417 .91883 m
.77417 .94769 L
.80303 .94769 L
.80303 .91883 L
F
.80303 .91883 m
.80303 .94769 L
.83189 .94769 L
.83189 .91883 L
F
.83189 .91883 m
.83189 .94769 L
.86075 .94769 L
.86075 .91883 L
F
.86075 .91883 m
.86075 .94769 L
.88961 .94769 L
.88961 .91883 L
F
.88961 .91883 m
.88961 .94769 L
.91847 .94769 L
.91847 .91883 L
F
.91847 .91883 m
.91847 .94769 L
.94733 .94769 L
.94733 .91883 L
F
.94733 .91883 m
.94733 .94769 L
.97619 .94769 L
.97619 .91883 L
F
.05267 .88997 m
.05267 .91883 L
.08153 .91883 L
.08153 .88997 L
F
.11039 .88997 m
.11039 .91883 L
.13925 .91883 L
.13925 .88997 L
F
.16811 .88997 m
.16811 .91883 L
.19697 .91883 L
.19697 .88997 L
F
.22583 .88997 m
.22583 .91883 L
.25469 .91883 L
.25469 .88997 L
F
.28355 .88997 m
.28355 .91883 L
.31241 .91883 L
.31241 .88997 L
F
.34127 .88997 m
.34127 .91883 L
.37013 .91883 L
.37013 .88997 L
F
.39899 .88997 m
.39899 .91883 L
.42785 .91883 L
.42785 .88997 L
F
.45671 .88997 m
.45671 .91883 L
.48557 .91883 L
.48557 .88997 L
F
.51443 .88997 m
.51443 .91883 L
.54329 .91883 L
.54329 .88997 L
F
.57215 .88997 m
.57215 .91883 L
.60101 .91883 L
.60101 .88997 L
F
.62987 .88997 m
.62987 .91883 L
.65873 .91883 L
.65873 .88997 L
F
.68759 .88997 m
.68759 .91883 L
.71645 .91883 L
.71645 .88997 L
F
.74531 .88997 m
.74531 .91883 L
.77417 .91883 L
.77417 .88997 L
F
.80303 .88997 m
.80303 .91883 L
.83189 .91883 L
.83189 .88997 L
F
.86075 .88997 m
.86075 .91883 L
.88961 .91883 L
.88961 .88997 L
F
.91847 .88997 m
.91847 .91883 L
.94733 .91883 L
.94733 .88997 L
F
.05267 .86111 m
.05267 .88997 L
.08153 .88997 L
.08153 .86111 L
F
.08153 .86111 m
.08153 .88997 L
.11039 .88997 L
.11039 .86111 L
F
.16811 .86111 m
.16811 .88997 L
.19697 .88997 L
.19697 .86111 L
F
.19697 .86111 m
.19697 .88997 L
.22583 .88997 L
.22583 .86111 L
F
.28355 .86111 m
.28355 .88997 L
.31241 .88997 L
.31241 .86111 L
F
.31241 .86111 m
.31241 .88997 L
.34127 .88997 L
.34127 .86111 L
F
.39899 .86111 m
.39899 .88997 L
.42785 .88997 L
.42785 .86111 L
F
.42785 .86111 m
.42785 .88997 L
.45671 .88997 L
.45671 .86111 L
F
.51443 .86111 m
.51443 .88997 L
.54329 .88997 L
.54329 .86111 L
F
.54329 .86111 m
.54329 .88997 L
.57215 .88997 L
.57215 .86111 L
F
.62987 .86111 m
.62987 .88997 L
.65873 .88997 L
.65873 .86111 L
F
.65873 .86111 m
.65873 .88997 L
.68759 .88997 L
.68759 .86111 L
F
.74531 .86111 m
.74531 .88997 L
.77417 .88997 L
.77417 .86111 L
F
.77417 .86111 m
.77417 .88997 L
.80303 .88997 L
.80303 .86111 L
F
.86075 .86111 m
.86075 .88997 L
.88961 .88997 L
.88961 .86111 L
F
.88961 .86111 m
.88961 .88997 L
.91847 .88997 L
.91847 .86111 L
F
.05267 .83225 m
.05267 .86111 L
.08153 .86111 L
.08153 .83225 L
F
.16811 .83225 m
.16811 .86111 L
.19697 .86111 L
.19697 .83225 L
F
.28355 .83225 m
.28355 .86111 L
.31241 .86111 L
.31241 .83225 L
F
.39899 .83225 m
.39899 .86111 L
.42785 .86111 L
.42785 .83225 L
F
.51443 .83225 m
.51443 .86111 L
.54329 .86111 L
.54329 .83225 L
F
.62987 .83225 m
.62987 .86111 L
.65873 .86111 L
.65873 .83225 L
F
.74531 .83225 m
.74531 .86111 L
.77417 .86111 L
.77417 .83225 L
F
.86075 .83225 m
.86075 .86111 L
.88961 .86111 L
.88961 .83225 L
F
.05267 .80339 m
.05267 .83225 L
.08153 .83225 L
.08153 .80339 L
F
.08153 .80339 m
.08153 .83225 L
.11039 .83225 L
.11039 .80339 L
F
.11039 .80339 m
.11039 .83225 L
.13925 .83225 L
.13925 .80339 L
F
.13925 .80339 m
.13925 .83225 L
.16811 .83225 L
.16811 .80339 L
F
.28355 .80339 m
.28355 .83225 L
.31241 .83225 L
.31241 .80339 L
F
.31241 .80339 m
.31241 .83225 L
.34127 .83225 L
.34127 .80339 L
F
.34127 .80339 m
.34127 .83225 L
.37013 .83225 L
.37013 .80339 L
F
.37013 .80339 m
.37013 .83225 L
.39899 .83225 L
.39899 .80339 L
F
.51443 .80339 m
.51443 .83225 L
.54329 .83225 L
.54329 .80339 L
F
.54329 .80339 m
.54329 .83225 L
.57215 .83225 L
.57215 .80339 L
F
.57215 .80339 m
.57215 .83225 L
.60101 .83225 L
.60101 .80339 L
F
.60101 .80339 m
.60101 .83225 L
.62987 .83225 L
.62987 .80339 L
F
.74531 .80339 m
.74531 .83225 L
.77417 .83225 L
.77417 .80339 L
F
.77417 .80339 m
.77417 .83225 L
.80303 .83225 L
.80303 .80339 L
F
.80303 .80339 m
.80303 .83225 L
.83189 .83225 L
.83189 .80339 L
F
.83189 .80339 m
.83189 .83225 L
.86075 .83225 L
.86075 .80339 L
F
.05267 .77453 m
.05267 .80339 L
.08153 .80339 L
.08153 .77453 L
F
.11039 .77453 m
.11039 .80339 L
.13925 .80339 L
.13925 .77453 L
F
.28355 .77453 m
.28355 .80339 L
.31241 .80339 L
.31241 .77453 L
F
.34127 .77453 m
.34127 .80339 L
.37013 .80339 L
.37013 .77453 L
F
.51443 .77453 m
.51443 .80339 L
.54329 .80339 L
.54329 .77453 L
F
.57215 .77453 m
.57215 .80339 L
.60101 .80339 L
.60101 .77453 L
F
.74531 .77453 m
.74531 .80339 L
.77417 .80339 L
.77417 .77453 L
F
.80303 .77453 m
.80303 .80339 L
.83189 .80339 L
.83189 .77453 L
F
.05267 .74567 m
.05267 .77453 L
.08153 .77453 L
.08153 .74567 L
F
.08153 .74567 m
.08153 .77453 L
.11039 .77453 L
.11039 .74567 L
F
.28355 .74567 m
.28355 .77453 L
.31241 .77453 L
.31241 .74567 L
F
.31241 .74567 m
.31241 .77453 L
.34127 .77453 L
.34127 .74567 L
F
.51443 .74567 m
.51443 .77453 L
.54329 .77453 L
.54329 .74567 L
F
.54329 .74567 m
.54329 .77453 L
.57215 .77453 L
.57215 .74567 L
F
.74531 .74567 m
.74531 .77453 L
.77417 .77453 L
.77417 .74567 L
F
.77417 .74567 m
.77417 .77453 L
.80303 .77453 L
.80303 .74567 L
F
.05267 .71681 m
.05267 .74567 L
.08153 .74567 L
.08153 .71681 L
F
.28355 .71681 m
.28355 .74567 L
.31241 .74567 L
.31241 .71681 L
F
.51443 .71681 m
.51443 .74567 L
.54329 .74567 L
.54329 .71681 L
F
.74531 .71681 m
.74531 .74567 L
.77417 .74567 L
.77417 .71681 L
F
.05267 .68795 m
.05267 .71681 L
.08153 .71681 L
.08153 .68795 L
F
.08153 .68795 m
.08153 .71681 L
.11039 .71681 L
.11039 .68795 L
F
.11039 .68795 m
.11039 .71681 L
.13925 .71681 L
.13925 .68795 L
F
.13925 .68795 m
.13925 .71681 L
.16811 .71681 L
.16811 .68795 L
F
.16811 .68795 m
.16811 .71681 L
.19697 .71681 L
.19697 .68795 L
F
.19697 .68795 m
.19697 .71681 L
.22583 .71681 L
.22583 .68795 L
F
.22583 .68795 m
.22583 .71681 L
.25469 .71681 L
.25469 .68795 L
F
.25469 .68795 m
.25469 .71681 L
.28355 .71681 L
.28355 .68795 L
F
.51443 .68795 m
.51443 .71681 L
.54329 .71681 L
.54329 .68795 L
F
.54329 .68795 m
.54329 .71681 L
.57215 .71681 L
.57215 .68795 L
F
.57215 .68795 m
.57215 .71681 L
.60101 .71681 L
.60101 .68795 L
F
.60101 .68795 m
.60101 .71681 L
.62987 .71681 L
.62987 .68795 L
F
.62987 .68795 m
.62987 .71681 L
.65873 .71681 L
.65873 .68795 L
F
.65873 .68795 m
.65873 .71681 L
.68759 .71681 L
.68759 .68795 L
F
.68759 .68795 m
.68759 .71681 L
.71645 .71681 L
.71645 .68795 L
F
.71645 .68795 m
.71645 .71681 L
.74531 .71681 L
.74531 .68795 L
F
.05267 .65909 m
.05267 .68795 L
.08153 .68795 L
.08153 .65909 L
F
.11039 .65909 m
.11039 .68795 L
.13925 .68795 L
.13925 .65909 L
F
.16811 .65909 m
.16811 .68795 L
.19697 .68795 L
.19697 .65909 L
F
.22583 .65909 m
.22583 .68795 L
.25469 .68795 L
.25469 .65909 L
F
.51443 .65909 m
.51443 .68795 L
.54329 .68795 L
.54329 .65909 L
F
.57215 .65909 m
.57215 .68795 L
.60101 .68795 L
.60101 .65909 L
F
.62987 .65909 m
.62987 .68795 L
.65873 .68795 L
.65873 .65909 L
F
.68759 .65909 m
.68759 .68795 L
.71645 .68795 L
.71645 .65909 L
F
.05267 .63023 m
.05267 .65909 L
.08153 .65909 L
.08153 .63023 L
F
.08153 .63023 m
.08153 .65909 L
.11039 .65909 L
.11039 .63023 L
F
.16811 .63023 m
.16811 .65909 L
.19697 .65909 L
.19697 .63023 L
F
.19697 .63023 m
.19697 .65909 L
.22583 .65909 L
.22583 .63023 L
F
.51443 .63023 m
.51443 .65909 L
.54329 .65909 L
.54329 .63023 L
F
.54329 .63023 m
.54329 .65909 L
.57215 .65909 L
.57215 .63023 L
F
.62987 .63023 m
.62987 .65909 L
.65873 .65909 L
.65873 .63023 L
F
.65873 .63023 m
.65873 .65909 L
.68759 .65909 L
.68759 .63023 L
F
.05267 .60137 m
.05267 .63023 L
.08153 .63023 L
.08153 .60137 L
F
.16811 .60137 m
.16811 .63023 L
.19697 .63023 L
.19697 .60137 L
F
.51443 .60137 m
.51443 .63023 L
.54329 .63023 L
.54329 .60137 L
F
.62987 .60137 m
.62987 .63023 L
.65873 .63023 L
.65873 .60137 L
F
.05267 .57251 m
.05267 .60137 L
.08153 .60137 L
.08153 .57251 L
F
.08153 .57251 m
.08153 .60137 L
.11039 .60137 L
.11039 .57251 L
F
.11039 .57251 m
.11039 .60137 L
.13925 .60137 L
.13925 .57251 L
F
.13925 .57251 m
.13925 .60137 L
.16811 .60137 L
.16811 .57251 L
F
.51443 .57251 m
.51443 .60137 L
.54329 .60137 L
.54329 .57251 L
F
.54329 .57251 m
.54329 .60137 L
.57215 .60137 L
.57215 .57251 L
F
.57215 .57251 m
.57215 .60137 L
.60101 .60137 L
.60101 .57251 L
F
.60101 .57251 m
.60101 .60137 L
.62987 .60137 L
.62987 .57251 L
F
.05267 .54365 m
.05267 .57251 L
.08153 .57251 L
.08153 .54365 L
F
.11039 .54365 m
.11039 .57251 L
.13925 .57251 L
.13925 .54365 L
F
.51443 .54365 m
.51443 .57251 L
.54329 .57251 L
.54329 .54365 L
F
.57215 .54365 m
.57215 .57251 L
.60101 .57251 L
.60101 .54365 L
F
.05267 .51479 m
.05267 .54365 L
.08153 .54365 L
.08153 .51479 L
F
.08153 .51479 m
.08153 .54365 L
.11039 .54365 L
.11039 .51479 L
F
.51443 .51479 m
.51443 .54365 L
.54329 .54365 L
.54329 .51479 L
F
.54329 .51479 m
.54329 .54365 L
.57215 .54365 L
.57215 .51479 L
F
.05267 .48593 m
.05267 .51479 L
.08153 .51479 L
.08153 .48593 L
F
.51443 .48593 m
.51443 .51479 L
.54329 .51479 L
.54329 .48593 L
F
.05267 .45707 m
.05267 .48593 L
.08153 .48593 L
.08153 .45707 L
F
.08153 .45707 m
.08153 .48593 L
.11039 .48593 L
.11039 .45707 L
F
.11039 .45707 m
.11039 .48593 L
.13925 .48593 L
.13925 .45707 L
F
.13925 .45707 m
.13925 .48593 L
.16811 .48593 L
.16811 .45707 L
F
.16811 .45707 m
.16811 .48593 L
.19697 .48593 L
.19697 .45707 L
F
.19697 .45707 m
.19697 .48593 L
.22583 .48593 L
.22583 .45707 L
F
.22583 .45707 m
.22583 .48593 L
.25469 .48593 L
.25469 .45707 L
F
.25469 .45707 m
.25469 .48593 L
.28355 .48593 L
.28355 .45707 L
F
.28355 .45707 m
.28355 .48593 L
.31241 .48593 L
.31241 .45707 L
F
.31241 .45707 m
.31241 .48593 L
.34127 .48593 L
.34127 .45707 L
F
.34127 .45707 m
.34127 .48593 L
.37013 .48593 L
.37013 .45707 L
F
.37013 .45707 m
.37013 .48593 L
.39899 .48593 L
.39899 .45707 L
F
.39899 .45707 m
.39899 .48593 L
.42785 .48593 L
.42785 .45707 L
F
.42785 .45707 m
.42785 .48593 L
.45671 .48593 L
.45671 .45707 L
F
.45671 .45707 m
.45671 .48593 L
.48557 .48593 L
.48557 .45707 L
F
.48557 .45707 m
.48557 .48593 L
.51443 .48593 L
.51443 .45707 L
F
.05267 .42821 m
.05267 .45707 L
.08153 .45707 L
.08153 .42821 L
F
.11039 .42821 m
.11039 .45707 L
.13925 .45707 L
.13925 .42821 L
F
.16811 .42821 m
.16811 .45707 L
.19697 .45707 L
.19697 .42821 L
F
.22583 .42821 m
.22583 .45707 L
.25469 .45707 L
.25469 .42821 L
F
.28355 .42821 m
.28355 .45707 L
.31241 .45707 L
.31241 .42821 L
F
.34127 .42821 m
.34127 .45707 L
.37013 .45707 L
.37013 .42821 L
F
.39899 .42821 m
.39899 .45707 L
.42785 .45707 L
.42785 .42821 L
F
.45671 .42821 m
.45671 .45707 L
.48557 .45707 L
.48557 .42821 L
F
.05267 .39935 m
.05267 .42821 L
.08153 .42821 L
.08153 .39935 L
F
.08153 .39935 m
.08153 .42821 L
.11039 .42821 L
.11039 .39935 L
F
.16811 .39935 m
.16811 .42821 L
.19697 .42821 L
.19697 .39935 L
F
.19697 .39935 m
.19697 .42821 L
.22583 .42821 L
.22583 .39935 L
F
.28355 .39935 m
.28355 .42821 L
.31241 .42821 L
.31241 .39935 L
F
.31241 .39935 m
.31241 .42821 L
.34127 .42821 L
.34127 .39935 L
F
.39899 .39935 m
.39899 .42821 L
.42785 .42821 L
.42785 .39935 L
F
.42785 .39935 m
.42785 .42821 L
.45671 .42821 L
.45671 .39935 L
F
.05267 .37049 m
.05267 .39935 L
.08153 .39935 L
.08153 .37049 L
F
.16811 .37049 m
.16811 .39935 L
.19697 .39935 L
.19697 .37049 L
F
.28355 .37049 m
.28355 .39935 L
.31241 .39935 L
.31241 .37049 L
F
.39899 .37049 m
.39899 .39935 L
.42785 .39935 L
.42785 .37049 L
F
.05267 .34163 m
.05267 .37049 L
.08153 .37049 L
.08153 .34163 L
F
.08153 .34163 m
.08153 .37049 L
.11039 .37049 L
.11039 .34163 L
F
.11039 .34163 m
.11039 .37049 L
.13925 .37049 L
.13925 .34163 L
F
.13925 .34163 m
.13925 .37049 L
.16811 .37049 L
.16811 .34163 L
F
.28355 .34163 m
.28355 .37049 L
.31241 .37049 L
.31241 .34163 L
F
.31241 .34163 m
.31241 .37049 L
.34127 .37049 L
.34127 .34163 L
F
.34127 .34163 m
.34127 .37049 L
.37013 .37049 L
.37013 .34163 L
F
.37013 .34163 m
.37013 .37049 L
.39899 .37049 L
.39899 .34163 L
F
.05267 .31277 m
.05267 .34163 L
.08153 .34163 L
.08153 .31277 L
F
.11039 .31277 m
.11039 .34163 L
.13925 .34163 L
.13925 .31277 L
F
.28355 .31277 m
.28355 .34163 L
.31241 .34163 L
.31241 .31277 L
F
.34127 .31277 m
.34127 .34163 L
.37013 .34163 L
.37013 .31277 L
F
.05267 .28391 m
.05267 .31277 L
.08153 .31277 L
.08153 .28391 L
F
.08153 .28391 m
.08153 .31277 L
.11039 .31277 L
.11039 .28391 L
F
.28355 .28391 m
.28355 .31277 L
.31241 .31277 L
.31241 .28391 L
F
.31241 .28391 m
.31241 .31277 L
.34127 .31277 L
.34127 .28391 L
F
.05267 .25505 m
.05267 .28391 L
.08153 .28391 L
.08153 .25505 L
F
.28355 .25505 m
.28355 .28391 L
.31241 .28391 L
.31241 .25505 L
F
.05267 .22619 m
.05267 .25505 L
.08153 .25505 L
.08153 .22619 L
F
.08153 .22619 m
.08153 .25505 L
.11039 .25505 L
.11039 .22619 L
F
.11039 .22619 m
.11039 .25505 L
.13925 .25505 L
.13925 .22619 L
F
.13925 .22619 m
.13925 .25505 L
.16811 .25505 L
.16811 .22619 L
F
.16811 .22619 m
.16811 .25505 L
.19697 .25505 L
.19697 .22619 L
F
.19697 .22619 m
.19697 .25505 L
.22583 .25505 L
.22583 .22619 L
F
.22583 .22619 m
.22583 .25505 L
.25469 .25505 L
.25469 .22619 L
F
.25469 .22619 m
.25469 .25505 L
.28355 .25505 L
.28355 .22619 L
F
.05267 .19733 m
.05267 .22619 L
.08153 .22619 L
.08153 .19733 L
F
.11039 .19733 m
.11039 .22619 L
.13925 .22619 L
.13925 .19733 L
F
.16811 .19733 m
.16811 .22619 L
.19697 .22619 L
.19697 .19733 L
F
.22583 .19733 m
.22583 .22619 L
.25469 .22619 L
.25469 .19733 L
F
.05267 .16847 m
.05267 .19733 L
.08153 .19733 L
.08153 .16847 L
F
.08153 .16847 m
.08153 .19733 L
.11039 .19733 L
.11039 .16847 L
F
.16811 .16847 m
.16811 .19733 L
.19697 .19733 L
.19697 .16847 L
F
.19697 .16847 m
.19697 .19733 L
.22583 .19733 L
.22583 .16847 L
F
.05267 .13961 m
.05267 .16847 L
.08153 .16847 L
.08153 .13961 L
F
.16811 .13961 m
.16811 .16847 L
.19697 .16847 L
.19697 .13961 L
F
.05267 .11075 m
.05267 .13961 L
.08153 .13961 L
.08153 .11075 L
F
.08153 .11075 m
.08153 .13961 L
.11039 .13961 L
.11039 .11075 L
F
.11039 .11075 m
.11039 .13961 L
.13925 .13961 L
.13925 .11075 L
F
.13925 .11075 m
.13925 .13961 L
.16811 .13961 L
.16811 .11075 L
F
.05267 .08189 m
.05267 .11075 L
.08153 .11075 L
.08153 .08189 L
F
.11039 .08189 m
.11039 .11075 L
.13925 .11075 L
.13925 .08189 L
F
.05267 .05303 m
.05267 .08189 L
.08153 .08189 L
.08153 .05303 L
F
.08153 .05303 m
.08153 .08189 L
.11039 .08189 L
.11039 .05303 L
F
.05267 .02417 m
.05267 .05303 L
.08153 .05303 L
.08153 .02417 L
F
1 .5 0 r
.08153 .88997 m
.08153 .91883 L
.11039 .91883 L
.11039 .88997 L
F
.13925 .88997 m
.13925 .91883 L
.16811 .91883 L
.16811 .88997 L
F
.19697 .88997 m
.19697 .91883 L
.22583 .91883 L
.22583 .88997 L
F
.25469 .88997 m
.25469 .91883 L
.28355 .91883 L
.28355 .88997 L
F
.31241 .88997 m
.31241 .91883 L
.34127 .91883 L
.34127 .88997 L
F
.37013 .88997 m
.37013 .91883 L
.39899 .91883 L
.39899 .88997 L
F
.42785 .88997 m
.42785 .91883 L
.45671 .91883 L
.45671 .88997 L
F
.48557 .88997 m
.48557 .91883 L
.51443 .91883 L
.51443 .88997 L
F
.54329 .88997 m
.54329 .91883 L
.57215 .91883 L
.57215 .88997 L
F
.60101 .88997 m
.60101 .91883 L
.62987 .91883 L
.62987 .88997 L
F
.65873 .88997 m
.65873 .91883 L
.68759 .91883 L
.68759 .88997 L
F
.71645 .88997 m
.71645 .91883 L
.74531 .91883 L
.74531 .88997 L
F
.77417 .88997 m
.77417 .91883 L
.80303 .91883 L
.80303 .88997 L
F
.83189 .88997 m
.83189 .91883 L
.86075 .91883 L
.86075 .88997 L
F
.88961 .88997 m
.88961 .91883 L
.91847 .91883 L
.91847 .88997 L
F
.94733 .88997 m
.94733 .91883 L
.97619 .91883 L
.97619 .88997 L
F
.08153 .83225 m
.08153 .86111 L
.11039 .86111 L
.11039 .83225 L
F
.19697 .83225 m
.19697 .86111 L
.22583 .86111 L
.22583 .83225 L
F
.31241 .83225 m
.31241 .86111 L
.34127 .86111 L
.34127 .83225 L
F
.42785 .83225 m
.42785 .86111 L
.45671 .86111 L
.45671 .83225 L
F
.54329 .83225 m
.54329 .86111 L
.57215 .86111 L
.57215 .83225 L
F
.65873 .83225 m
.65873 .86111 L
.68759 .86111 L
.68759 .83225 L
F
.77417 .83225 m
.77417 .86111 L
.80303 .86111 L
.80303 .83225 L
F
.88961 .83225 m
.88961 .86111 L
.91847 .86111 L
.91847 .83225 L
F
.08153 .77453 m
.08153 .80339 L
.11039 .80339 L
.11039 .77453 L
F
.13925 .77453 m
.13925 .80339 L
.16811 .80339 L
.16811 .77453 L
F
.31241 .77453 m
.31241 .80339 L
.34127 .80339 L
.34127 .77453 L
F
.37013 .77453 m
.37013 .80339 L
.39899 .80339 L
.39899 .77453 L
F
.54329 .77453 m
.54329 .80339 L
.57215 .80339 L
.57215 .77453 L
F
.60101 .77453 m
.60101 .80339 L
.62987 .80339 L
.62987 .77453 L
F
.77417 .77453 m
.77417 .80339 L
.80303 .80339 L
.80303 .77453 L
F
.83189 .77453 m
.83189 .80339 L
.86075 .80339 L
.86075 .77453 L
F
.08153 .71681 m
.08153 .74567 L
.11039 .74567 L
.11039 .71681 L
F
.31241 .71681 m
.31241 .74567 L
.34127 .74567 L
.34127 .71681 L
F
.54329 .71681 m
.54329 .74567 L
.57215 .74567 L
.57215 .71681 L
F
.77417 .71681 m
.77417 .74567 L
.80303 .74567 L
.80303 .71681 L
F
.08153 .65909 m
.08153 .68795 L
.11039 .68795 L
.11039 .65909 L
F
.13925 .65909 m
.13925 .68795 L
.16811 .68795 L
.16811 .65909 L
F
.19697 .65909 m
.19697 .68795 L
.22583 .68795 L
.22583 .65909 L
F
.25469 .65909 m
.25469 .68795 L
.28355 .68795 L
.28355 .65909 L
F
.54329 .65909 m
.54329 .68795 L
.57215 .68795 L
.57215 .65909 L
F
.60101 .65909 m
.60101 .68795 L
.62987 .68795 L
.62987 .65909 L
F
.65873 .65909 m
.65873 .68795 L
.68759 .68795 L
.68759 .65909 L
F
.71645 .65909 m
.71645 .68795 L
.74531 .68795 L
.74531 .65909 L
F
.08153 .60137 m
.08153 .63023 L
.11039 .63023 L
.11039 .60137 L
F
.19697 .60137 m
.19697 .63023 L
.22583 .63023 L
.22583 .60137 L
F
.54329 .60137 m
.54329 .63023 L
.57215 .63023 L
.57215 .60137 L
F
.65873 .60137 m
.65873 .63023 L
.68759 .63023 L
.68759 .60137 L
F
.08153 .54365 m
.08153 .57251 L
.11039 .57251 L
.11039 .54365 L
F
.13925 .54365 m
.13925 .57251 L
.16811 .57251 L
.16811 .54365 L
F
.54329 .54365 m
.54329 .57251 L
.57215 .57251 L
.57215 .54365 L
F
.60101 .54365 m
.60101 .57251 L
.62987 .57251 L
.62987 .54365 L
F
.08153 .48593 m
.08153 .51479 L
.11039 .51479 L
.11039 .48593 L
F
.54329 .48593 m
.54329 .51479 L
.57215 .51479 L
.57215 .48593 L
F
.08153 .42821 m
.08153 .45707 L
.11039 .45707 L
.11039 .42821 L
F
.13925 .42821 m
.13925 .45707 L
.16811 .45707 L
.16811 .42821 L
F
.19697 .42821 m
.19697 .45707 L
.22583 .45707 L
.22583 .42821 L
F
.25469 .42821 m
.25469 .45707 L
.28355 .45707 L
.28355 .42821 L
F
.31241 .42821 m
.31241 .45707 L
.34127 .45707 L
.34127 .42821 L
F
.37013 .42821 m
.37013 .45707 L
.39899 .45707 L
.39899 .42821 L
F
.42785 .42821 m
.42785 .45707 L
.45671 .45707 L
.45671 .42821 L
F
.48557 .42821 m
.48557 .45707 L
.51443 .45707 L
.51443 .42821 L
F
.08153 .37049 m
.08153 .39935 L
.11039 .39935 L
.11039 .37049 L
F
.19697 .37049 m
.19697 .39935 L
.22583 .39935 L
.22583 .37049 L
F
.31241 .37049 m
.31241 .39935 L
.34127 .39935 L
.34127 .37049 L
F
.42785 .37049 m
.42785 .39935 L
.45671 .39935 L
.45671 .37049 L
F
.08153 .31277 m
.08153 .34163 L
.11039 .34163 L
.11039 .31277 L
F
.13925 .31277 m
.13925 .34163 L
.16811 .34163 L
.16811 .31277 L
F
.31241 .31277 m
.31241 .34163 L
.34127 .34163 L
.34127 .31277 L
F
.37013 .31277 m
.37013 .34163 L
.39899 .34163 L
.39899 .31277 L
F
.08153 .25505 m
.08153 .28391 L
.11039 .28391 L
.11039 .25505 L
F
.31241 .25505 m
.31241 .28391 L
.34127 .28391 L
.34127 .25505 L
F
.08153 .19733 m
.08153 .22619 L
.11039 .22619 L
.11039 .19733 L
F
.13925 .19733 m
.13925 .22619 L
.16811 .22619 L
.16811 .19733 L
F
.19697 .19733 m
.19697 .22619 L
.22583 .22619 L
.22583 .19733 L
F
.25469 .19733 m
.25469 .22619 L
.28355 .22619 L
.28355 .19733 L
F
.08153 .13961 m
.08153 .16847 L
.11039 .16847 L
.11039 .13961 L
F
.19697 .13961 m
.19697 .16847 L
.22583 .16847 L
.22583 .13961 L
F
.08153 .08189 m
.08153 .11075 L
.11039 .11075 L
.11039 .08189 L
F
.13925 .08189 m
.13925 .11075 L
.16811 .11075 L
.16811 .08189 L
F
.08153 .02417 m
.08153 .05303 L
.11039 .05303 L
.11039 .02417 L
F
.56 .37 .6 r
.11039 .86111 m
.11039 .88997 L
.13925 .88997 L
.13925 .86111 L
F
.13925 .86111 m
.13925 .88997 L
.16811 .88997 L
.16811 .86111 L
F
.22583 .86111 m
.22583 .88997 L
.25469 .88997 L
.25469 .86111 L
F
.25469 .86111 m
.25469 .88997 L
.28355 .88997 L
.28355 .86111 L
F
.34127 .86111 m
.34127 .88997 L
.37013 .88997 L
.37013 .86111 L
F
.37013 .86111 m
.37013 .88997 L
.39899 .88997 L
.39899 .86111 L
F
.45671 .86111 m
.45671 .88997 L
.48557 .88997 L
.48557 .86111 L
F
.48557 .86111 m
.48557 .88997 L
.51443 .88997 L
.51443 .86111 L
F
.57215 .86111 m
.57215 .88997 L
.60101 .88997 L
.60101 .86111 L
F
.60101 .86111 m
.60101 .88997 L
.62987 .88997 L
.62987 .86111 L
F
.68759 .86111 m
.68759 .88997 L
.71645 .88997 L
.71645 .86111 L
F
.71645 .86111 m
.71645 .88997 L
.74531 .88997 L
.74531 .86111 L
F
.80303 .86111 m
.80303 .88997 L
.83189 .88997 L
.83189 .86111 L
F
.83189 .86111 m
.83189 .88997 L
.86075 .88997 L
.86075 .86111 L
F
.91847 .86111 m
.91847 .88997 L
.94733 .88997 L
.94733 .86111 L
F
.94733 .86111 m
.94733 .88997 L
.97619 .88997 L
.97619 .86111 L
F
.11039 .83225 m
.11039 .86111 L
.13925 .86111 L
.13925 .83225 L
F
.22583 .83225 m
.22583 .86111 L
.25469 .86111 L
.25469 .83225 L
F
.34127 .83225 m
.34127 .86111 L
.37013 .86111 L
.37013 .83225 L
F
.45671 .83225 m
.45671 .86111 L
.48557 .86111 L
.48557 .83225 L
F
.57215 .83225 m
.57215 .86111 L
.60101 .86111 L
.60101 .83225 L
F
.68759 .83225 m
.68759 .86111 L
.71645 .86111 L
.71645 .83225 L
F
.80303 .83225 m
.80303 .86111 L
.83189 .86111 L
.83189 .83225 L
F
.91847 .83225 m
.91847 .86111 L
.94733 .86111 L
.94733 .83225 L
F
.11039 .74567 m
.11039 .77453 L
.13925 .77453 L
.13925 .74567 L
F
.13925 .74567 m
.13925 .77453 L
.16811 .77453 L
.16811 .74567 L
F
.34127 .74567 m
.34127 .77453 L
.37013 .77453 L
.37013 .74567 L
F
.37013 .74567 m
.37013 .77453 L
.39899 .77453 L
.39899 .74567 L
F
.57215 .74567 m
.57215 .77453 L
.60101 .77453 L
.60101 .74567 L
F
.60101 .74567 m
.60101 .77453 L
.62987 .77453 L
.62987 .74567 L
F
.80303 .74567 m
.80303 .77453 L
.83189 .77453 L
.83189 .74567 L
F
.83189 .74567 m
.83189 .77453 L
.86075 .77453 L
.86075 .74567 L
F
.11039 .71681 m
.11039 .74567 L
.13925 .74567 L
.13925 .71681 L
F
.34127 .71681 m
.34127 .74567 L
.37013 .74567 L
.37013 .71681 L
F
.57215 .71681 m
.57215 .74567 L
.60101 .74567 L
.60101 .71681 L
F
.80303 .71681 m
.80303 .74567 L
.83189 .74567 L
.83189 .71681 L
F
.11039 .63023 m
.11039 .65909 L
.13925 .65909 L
.13925 .63023 L
F
.13925 .63023 m
.13925 .65909 L
.16811 .65909 L
.16811 .63023 L
F
.22583 .63023 m
.22583 .65909 L
.25469 .65909 L
.25469 .63023 L
F
.25469 .63023 m
.25469 .65909 L
.28355 .65909 L
.28355 .63023 L
F
.57215 .63023 m
.57215 .65909 L
.60101 .65909 L
.60101 .63023 L
F
.60101 .63023 m
.60101 .65909 L
.62987 .65909 L
.62987 .63023 L
F
.68759 .63023 m
.68759 .65909 L
.71645 .65909 L
.71645 .63023 L
F
.71645 .63023 m
.71645 .65909 L
.74531 .65909 L
.74531 .63023 L
F
.11039 .60137 m
.11039 .63023 L
.13925 .63023 L
.13925 .60137 L
F
.22583 .60137 m
.22583 .63023 L
.25469 .63023 L
.25469 .60137 L
F
.57215 .60137 m
.57215 .63023 L
.60101 .63023 L
.60101 .60137 L
F
.68759 .60137 m
.68759 .63023 L
.71645 .63023 L
.71645 .60137 L
F
.11039 .51479 m
.11039 .54365 L
.13925 .54365 L
.13925 .51479 L
F
.13925 .51479 m
.13925 .54365 L
.16811 .54365 L
.16811 .51479 L
F
.57215 .51479 m
.57215 .54365 L
.60101 .54365 L
.60101 .51479 L
F
.60101 .51479 m
.60101 .54365 L
.62987 .54365 L
.62987 .51479 L
F
.11039 .48593 m
.11039 .51479 L
.13925 .51479 L
.13925 .48593 L
F
.57215 .48593 m
.57215 .51479 L
.60101 .51479 L
.60101 .48593 L
F
.11039 .39935 m
.11039 .42821 L
.13925 .42821 L
.13925 .39935 L
F
.13925 .39935 m
.13925 .42821 L
.16811 .42821 L
.16811 .39935 L
F
.22583 .39935 m
.22583 .42821 L
.25469 .42821 L
.25469 .39935 L
F
.25469 .39935 m
.25469 .42821 L
.28355 .42821 L
.28355 .39935 L
F
.34127 .39935 m
.34127 .42821 L
.37013 .42821 L
.37013 .39935 L
F
.37013 .39935 m
.37013 .42821 L
.39899 .42821 L
.39899 .39935 L
F
.45671 .39935 m
.45671 .42821 L
.48557 .42821 L
.48557 .39935 L
F
.48557 .39935 m
.48557 .42821 L
.51443 .42821 L
.51443 .39935 L
F
.11039 .37049 m
.11039 .39935 L
.13925 .39935 L
.13925 .37049 L
F
.22583 .37049 m
.22583 .39935 L
.25469 .39935 L
.25469 .37049 L
F
.34127 .37049 m
.34127 .39935 L
.37013 .39935 L
.37013 .37049 L
F
.45671 .37049 m
.45671 .39935 L
.48557 .39935 L
.48557 .37049 L
F
.11039 .28391 m
.11039 .31277 L
.13925 .31277 L
.13925 .28391 L
F
.13925 .28391 m
.13925 .31277 L
.16811 .31277 L
.16811 .28391 L
F
.34127 .28391 m
.34127 .31277 L
.37013 .31277 L
.37013 .28391 L
F
.37013 .28391 m
.37013 .31277 L
.39899 .31277 L
.39899 .28391 L
F
.11039 .25505 m
.11039 .28391 L
.13925 .28391 L
.13925 .25505 L
F
.34127 .25505 m
.34127 .28391 L
.37013 .28391 L
.37013 .25505 L
F
.11039 .16847 m
.11039 .19733 L
.13925 .19733 L
.13925 .16847 L
F
.13925 .16847 m
.13925 .19733 L
.16811 .19733 L
.16811 .16847 L
F
.22583 .16847 m
.22583 .19733 L
.25469 .19733 L
.25469 .16847 L
F
.25469 .16847 m
.25469 .19733 L
.28355 .19733 L
.28355 .16847 L
F
.11039 .13961 m
.11039 .16847 L
.13925 .16847 L
.13925 .13961 L
F
.22583 .13961 m
.22583 .16847 L
.25469 .16847 L
.25469 .13961 L
F
.11039 .05303 m
.11039 .08189 L
.13925 .08189 L
.13925 .05303 L
F
.13925 .05303 m
.13925 .08189 L
.16811 .08189 L
.16811 .05303 L
F
.11039 .02417 m
.11039 .05303 L
.13925 .05303 L
.13925 .02417 L
F
0 0 1 r
.13925 .83225 m
.13925 .86111 L
.16811 .86111 L
.16811 .83225 L
F
.25469 .83225 m
.25469 .86111 L
.28355 .86111 L
.28355 .83225 L
F
.37013 .83225 m
.37013 .86111 L
.39899 .86111 L
.39899 .83225 L
F
.48557 .83225 m
.48557 .86111 L
.51443 .86111 L
.51443 .83225 L
F
.60101 .83225 m
.60101 .86111 L
.62987 .86111 L
.62987 .83225 L
F
.71645 .83225 m
.71645 .86111 L
.74531 .86111 L
.74531 .83225 L
F
.83189 .83225 m
.83189 .86111 L
.86075 .86111 L
.86075 .83225 L
F
.94733 .83225 m
.94733 .86111 L
.97619 .86111 L
.97619 .83225 L
F
.13925 .71681 m
.13925 .74567 L
.16811 .74567 L
.16811 .71681 L
F
.37013 .71681 m
.37013 .74567 L
.39899 .74567 L
.39899 .71681 L
F
.60101 .71681 m
.60101 .74567 L
.62987 .74567 L
.62987 .71681 L
F
.83189 .71681 m
.83189 .74567 L
.86075 .74567 L
.86075 .71681 L
F
.13925 .60137 m
.13925 .63023 L
.16811 .63023 L
.16811 .60137 L
F
.25469 .60137 m
.25469 .63023 L
.28355 .63023 L
.28355 .60137 L
F
.60101 .60137 m
.60101 .63023 L
.62987 .63023 L
.62987 .60137 L
F
.71645 .60137 m
.71645 .63023 L
.74531 .63023 L
.74531 .60137 L
F
.13925 .48593 m
.13925 .51479 L
.16811 .51479 L
.16811 .48593 L
F
.60101 .48593 m
.60101 .51479 L
.62987 .51479 L
.62987 .48593 L
F
.13925 .37049 m
.13925 .39935 L
.16811 .39935 L
.16811 .37049 L
F
.25469 .37049 m
.25469 .39935 L
.28355 .39935 L
.28355 .37049 L
F
.37013 .37049 m
.37013 .39935 L
.39899 .39935 L
.39899 .37049 L
F
.48557 .37049 m
.48557 .39935 L
.51443 .39935 L
.51443 .37049 L
F
.13925 .25505 m
.13925 .28391 L
.16811 .28391 L
.16811 .25505 L
F
.37013 .25505 m
.37013 .28391 L
.39899 .28391 L
.39899 .25505 L
F
.13925 .13961 m
.13925 .16847 L
.16811 .16847 L
.16811 .13961 L
F
.25469 .13961 m
.25469 .16847 L
.28355 .16847 L
.28355 .13961 L
F
.13925 .02417 m
.13925 .05303 L
.16811 .05303 L
.16811 .02417 L
F
.74 .99 .79 r
.16811 .80339 m
.16811 .83225 L
.19697 .83225 L
.19697 .80339 L
F
.19697 .80339 m
.19697 .83225 L
.22583 .83225 L
.22583 .80339 L
F
.22583 .80339 m
.22583 .83225 L
.25469 .83225 L
.25469 .80339 L
F
.25469 .80339 m
.25469 .83225 L
.28355 .83225 L
.28355 .80339 L
F
.39899 .80339 m
.39899 .83225 L
.42785 .83225 L
.42785 .80339 L
F
.42785 .80339 m
.42785 .83225 L
.45671 .83225 L
.45671 .80339 L
F
.45671 .80339 m
.45671 .83225 L
.48557 .83225 L
.48557 .80339 L
F
.48557 .80339 m
.48557 .83225 L
.51443 .83225 L
.51443 .80339 L
F
.62987 .80339 m
.62987 .83225 L
.65873 .83225 L
.65873 .80339 L
F
.65873 .80339 m
.65873 .83225 L
.68759 .83225 L
.68759 .80339 L
F
.68759 .80339 m
.68759 .83225 L
.71645 .83225 L
.71645 .80339 L
F
.71645 .80339 m
.71645 .83225 L
.74531 .83225 L
.74531 .80339 L
F
.86075 .80339 m
.86075 .83225 L
.88961 .83225 L
.88961 .80339 L
F
.88961 .80339 m
.88961 .83225 L
.91847 .83225 L
.91847 .80339 L
F
.91847 .80339 m
.91847 .83225 L
.94733 .83225 L
.94733 .80339 L
F
.94733 .80339 m
.94733 .83225 L
.97619 .83225 L
.97619 .80339 L
F
.16811 .77453 m
.16811 .80339 L
.19697 .80339 L
.19697 .77453 L
F
.22583 .77453 m
.22583 .80339 L
.25469 .80339 L
.25469 .77453 L
F
.39899 .77453 m
.39899 .80339 L
.42785 .80339 L
.42785 .77453 L
F
.45671 .77453 m
.45671 .80339 L
.48557 .80339 L
.48557 .77453 L
F
.62987 .77453 m
.62987 .80339 L
.65873 .80339 L
.65873 .77453 L
F
.68759 .77453 m
.68759 .80339 L
.71645 .80339 L
.71645 .77453 L
F
.86075 .77453 m
.86075 .80339 L
.88961 .80339 L
.88961 .77453 L
F
.91847 .77453 m
.91847 .80339 L
.94733 .80339 L
.94733 .77453 L
F
.16811 .74567 m
.16811 .77453 L
.19697 .77453 L
.19697 .74567 L
F
.19697 .74567 m
.19697 .77453 L
.22583 .77453 L
.22583 .74567 L
F
.39899 .74567 m
.39899 .77453 L
.42785 .77453 L
.42785 .74567 L
F
.42785 .74567 m
.42785 .77453 L
.45671 .77453 L
.45671 .74567 L
F
.62987 .74567 m
.62987 .77453 L
.65873 .77453 L
.65873 .74567 L
F
.65873 .74567 m
.65873 .77453 L
.68759 .77453 L
.68759 .74567 L
F
.86075 .74567 m
.86075 .77453 L
.88961 .77453 L
.88961 .74567 L
F
.88961 .74567 m
.88961 .77453 L
.91847 .77453 L
.91847 .74567 L
F
.16811 .71681 m
.16811 .74567 L
.19697 .74567 L
.19697 .71681 L
F
.39899 .71681 m
.39899 .74567 L
.42785 .74567 L
.42785 .71681 L
F
.62987 .71681 m
.62987 .74567 L
.65873 .74567 L
.65873 .71681 L
F
.86075 .71681 m
.86075 .74567 L
.88961 .74567 L
.88961 .71681 L
F
.16811 .57251 m
.16811 .60137 L
.19697 .60137 L
.19697 .57251 L
F
.19697 .57251 m
.19697 .60137 L
.22583 .60137 L
.22583 .57251 L
F
.22583 .57251 m
.22583 .60137 L
.25469 .60137 L
.25469 .57251 L
F
.25469 .57251 m
.25469 .60137 L
.28355 .60137 L
.28355 .57251 L
F
.62987 .57251 m
.62987 .60137 L
.65873 .60137 L
.65873 .57251 L
F
.65873 .57251 m
.65873 .60137 L
.68759 .60137 L
.68759 .57251 L
F
.68759 .57251 m
.68759 .60137 L
.71645 .60137 L
.71645 .57251 L
F
.71645 .57251 m
.71645 .60137 L
.74531 .60137 L
.74531 .57251 L
F
.16811 .54365 m
.16811 .57251 L
.19697 .57251 L
.19697 .54365 L
F
.22583 .54365 m
.22583 .57251 L
.25469 .57251 L
.25469 .54365 L
F
.62987 .54365 m
.62987 .57251 L
.65873 .57251 L
.65873 .54365 L
F
.68759 .54365 m
.68759 .57251 L
.71645 .57251 L
.71645 .54365 L
F
.16811 .51479 m
.16811 .54365 L
.19697 .54365 L
.19697 .51479 L
F
.19697 .51479 m
.19697 .54365 L
.22583 .54365 L
.22583 .51479 L
F
.62987 .51479 m
.62987 .54365 L
.65873 .54365 L
.65873 .51479 L
F
.65873 .51479 m
.65873 .54365 L
.68759 .54365 L
.68759 .51479 L
F
.16811 .48593 m
.16811 .51479 L
.19697 .51479 L
.19697 .48593 L
F
.62987 .48593 m
.62987 .51479 L
.65873 .51479 L
.65873 .48593 L
F
.16811 .34163 m
.16811 .37049 L
.19697 .37049 L
.19697 .34163 L
F
.19697 .34163 m
.19697 .37049 L
.22583 .37049 L
.22583 .34163 L
F
.22583 .34163 m
.22583 .37049 L
.25469 .37049 L
.25469 .34163 L
F
.25469 .34163 m
.25469 .37049 L
.28355 .37049 L
.28355 .34163 L
F
.39899 .34163 m
.39899 .37049 L
.42785 .37049 L
.42785 .34163 L
F
.42785 .34163 m
.42785 .37049 L
.45671 .37049 L
.45671 .34163 L
F
.45671 .34163 m
.45671 .37049 L
.48557 .37049 L
.48557 .34163 L
F
.48557 .34163 m
.48557 .37049 L
.51443 .37049 L
.51443 .34163 L
F
.16811 .31277 m
.16811 .34163 L
.19697 .34163 L
.19697 .31277 L
F
.22583 .31277 m
.22583 .34163 L
.25469 .34163 L
.25469 .31277 L
F
.39899 .31277 m
.39899 .34163 L
.42785 .34163 L
.42785 .31277 L
F
.45671 .31277 m
.45671 .34163 L
.48557 .34163 L
.48557 .31277 L
F
.16811 .28391 m
.16811 .31277 L
.19697 .31277 L
.19697 .28391 L
F
.19697 .28391 m
.19697 .31277 L
.22583 .31277 L
.22583 .28391 L
F
.39899 .28391 m
.39899 .31277 L
.42785 .31277 L
.42785 .28391 L
F
.42785 .28391 m
.42785 .31277 L
.45671 .31277 L
.45671 .28391 L
F
.16811 .25505 m
.16811 .28391 L
.19697 .28391 L
.19697 .25505 L
F
.39899 .25505 m
.39899 .28391 L
.42785 .28391 L
.42785 .25505 L
F
.16811 .11075 m
.16811 .13961 L
.19697 .13961 L
.19697 .11075 L
F
.19697 .11075 m
.19697 .13961 L
.22583 .13961 L
.22583 .11075 L
F
.22583 .11075 m
.22583 .13961 L
.25469 .13961 L
.25469 .11075 L
F
.25469 .11075 m
.25469 .13961 L
.28355 .13961 L
.28355 .11075 L
F
.16811 .08189 m
.16811 .11075 L
.19697 .11075 L
.19697 .08189 L
F
.22583 .08189 m
.22583 .11075 L
.25469 .11075 L
.25469 .08189 L
F
.16811 .05303 m
.16811 .08189 L
.19697 .08189 L
.19697 .05303 L
F
.19697 .05303 m
.19697 .08189 L
.22583 .08189 L
.22583 .05303 L
F
.16811 .02417 m
.16811 .05303 L
.19697 .05303 L
.19697 .02417 L
F
.251 .878 .816 r
.19697 .77453 m
.19697 .80339 L
.22583 .80339 L
.22583 .77453 L
F
.25469 .77453 m
.25469 .80339 L
.28355 .80339 L
.28355 .77453 L
F
.42785 .77453 m
.42785 .80339 L
.45671 .80339 L
.45671 .77453 L
F
.48557 .77453 m
.48557 .80339 L
.51443 .80339 L
.51443 .77453 L
F
.65873 .77453 m
.65873 .80339 L
.68759 .80339 L
.68759 .77453 L
F
.71645 .77453 m
.71645 .80339 L
.74531 .80339 L
.74531 .77453 L
F
.88961 .77453 m
.88961 .80339 L
.91847 .80339 L
.91847 .77453 L
F
.94733 .77453 m
.94733 .80339 L
.97619 .80339 L
.97619 .77453 L
F
.19697 .71681 m
.19697 .74567 L
.22583 .74567 L
.22583 .71681 L
F
.42785 .71681 m
.42785 .74567 L
.45671 .74567 L
.45671 .71681 L
F
.65873 .71681 m
.65873 .74567 L
.68759 .74567 L
.68759 .71681 L
F
.88961 .71681 m
.88961 .74567 L
.91847 .74567 L
.91847 .71681 L
F
.19697 .54365 m
.19697 .57251 L
.22583 .57251 L
.22583 .54365 L
F
.25469 .54365 m
.25469 .57251 L
.28355 .57251 L
.28355 .54365 L
F
.65873 .54365 m
.65873 .57251 L
.68759 .57251 L
.68759 .54365 L
F
.71645 .54365 m
.71645 .57251 L
.74531 .57251 L
.74531 .54365 L
F
.19697 .48593 m
.19697 .51479 L
.22583 .51479 L
.22583 .48593 L
F
.65873 .48593 m
.65873 .51479 L
.68759 .51479 L
.68759 .48593 L
F
.19697 .31277 m
.19697 .34163 L
.22583 .34163 L
.22583 .31277 L
F
.25469 .31277 m
.25469 .34163 L
.28355 .34163 L
.28355 .31277 L
F
.42785 .31277 m
.42785 .34163 L
.45671 .34163 L
.45671 .31277 L
F
.48557 .31277 m
.48557 .34163 L
.51443 .34163 L
.51443 .31277 L
F
.19697 .25505 m
.19697 .28391 L
.22583 .28391 L
.22583 .25505 L
F
.42785 .25505 m
.42785 .28391 L
.45671 .28391 L
.45671 .25505 L
F
.19697 .08189 m
.19697 .11075 L
.22583 .11075 L
.22583 .08189 L
F
.25469 .08189 m
.25469 .11075 L
.28355 .11075 L
.28355 .08189 L
F
.19697 .02417 m
.19697 .05303 L
.22583 .05303 L
.22583 .02417 L
F
0 .79 .34 r
.22583 .74567 m
.22583 .77453 L
.25469 .77453 L
.25469 .74567 L
F
.25469 .74567 m
.25469 .77453 L
.28355 .77453 L
.28355 .74567 L
F
.45671 .74567 m
.45671 .77453 L
.48557 .77453 L
.48557 .74567 L
F
.48557 .74567 m
.48557 .77453 L
.51443 .77453 L
.51443 .74567 L
F
.68759 .74567 m
.68759 .77453 L
.71645 .77453 L
.71645 .74567 L
F
.71645 .74567 m
.71645 .77453 L
.74531 .77453 L
.74531 .74567 L
F
.91847 .74567 m
.91847 .77453 L
.94733 .77453 L
.94733 .74567 L
F
.94733 .74567 m
.94733 .77453 L
.97619 .77453 L
.97619 .74567 L
F
.22583 .71681 m
.22583 .74567 L
.25469 .74567 L
.25469 .71681 L
F
.45671 .71681 m
.45671 .74567 L
.48557 .74567 L
.48557 .71681 L
F
.68759 .71681 m
.68759 .74567 L
.71645 .74567 L
.71645 .71681 L
F
.91847 .71681 m
.91847 .74567 L
.94733 .74567 L
.94733 .71681 L
F
.22583 .51479 m
.22583 .54365 L
.25469 .54365 L
.25469 .51479 L
F
.25469 .51479 m
.25469 .54365 L
.28355 .54365 L
.28355 .51479 L
F
.68759 .51479 m
.68759 .54365 L
.71645 .54365 L
.71645 .51479 L
F
.71645 .51479 m
.71645 .54365 L
.74531 .54365 L
.74531 .51479 L
F
.22583 .48593 m
.22583 .51479 L
.25469 .51479 L
.25469 .48593 L
F
.68759 .48593 m
.68759 .51479 L
.71645 .51479 L
.71645 .48593 L
F
.22583 .28391 m
.22583 .31277 L
.25469 .31277 L
.25469 .28391 L
F
.25469 .28391 m
.25469 .31277 L
.28355 .31277 L
.28355 .28391 L
F
.45671 .28391 m
.45671 .31277 L
.48557 .31277 L
.48557 .28391 L
F
.48557 .28391 m
.48557 .31277 L
.51443 .31277 L
.51443 .28391 L
F
.22583 .25505 m
.22583 .28391 L
.25469 .28391 L
.25469 .25505 L
F
.45671 .25505 m
.45671 .28391 L
.48557 .28391 L
.48557 .25505 L
F
.22583 .05303 m
.22583 .08189 L
.25469 .08189 L
.25469 .05303 L
F
.25469 .05303 m
.25469 .08189 L
.28355 .08189 L
.28355 .05303 L
F
.22583 .02417 m
.22583 .05303 L
.25469 .05303 L
.25469 .02417 L
F
0 .392 0 r
.25469 .71681 m
.25469 .74567 L
.28355 .74567 L
.28355 .71681 L
F
.48557 .71681 m
.48557 .74567 L
.51443 .74567 L
.51443 .71681 L
F
.71645 .71681 m
.71645 .74567 L
.74531 .74567 L
.74531 .71681 L
F
.94733 .71681 m
.94733 .74567 L
.97619 .74567 L
.97619 .71681 L
F
.25469 .48593 m
.25469 .51479 L
.28355 .51479 L
.28355 .48593 L
F
.71645 .48593 m
.71645 .51479 L
.74531 .51479 L
.74531 .48593 L
F
.25469 .25505 m
.25469 .28391 L
.28355 .28391 L
.28355 .25505 L
F
.48557 .25505 m
.48557 .28391 L
.51443 .28391 L
.51443 .25505 L
F
.25469 .02417 m
.25469 .05303 L
.28355 .05303 L
.28355 .02417 L
F
1 .753 .796 r
.28355 .68795 m
.28355 .71681 L
.31241 .71681 L
.31241 .68795 L
F
.31241 .68795 m
.31241 .71681 L
.34127 .71681 L
.34127 .68795 L
F
.34127 .68795 m
.34127 .71681 L
.37013 .71681 L
.37013 .68795 L
F
.37013 .68795 m
.37013 .71681 L
.39899 .71681 L
.39899 .68795 L
F
.39899 .68795 m
.39899 .71681 L
.42785 .71681 L
.42785 .68795 L
F
.42785 .68795 m
.42785 .71681 L
.45671 .71681 L
.45671 .68795 L
F
.45671 .68795 m
.45671 .71681 L
.48557 .71681 L
.48557 .68795 L
F
.48557 .68795 m
.48557 .71681 L
.51443 .71681 L
.51443 .68795 L
F
.74531 .68795 m
.74531 .71681 L
.77417 .71681 L
.77417 .68795 L
F
.77417 .68795 m
.77417 .71681 L
.80303 .71681 L
.80303 .68795 L
F
.80303 .68795 m
.80303 .71681 L
.83189 .71681 L
.83189 .68795 L
F
.83189 .68795 m
.83189 .71681 L
.86075 .71681 L
.86075 .68795 L
F
.86075 .68795 m
.86075 .71681 L
.88961 .71681 L
.88961 .68795 L
F
.88961 .68795 m
.88961 .71681 L
.91847 .71681 L
.91847 .68795 L
F
.91847 .68795 m
.91847 .71681 L
.94733 .71681 L
.94733 .68795 L
F
.94733 .68795 m
.94733 .71681 L
.97619 .71681 L
.97619 .68795 L
F
.28355 .65909 m
.28355 .68795 L
.31241 .68795 L
.31241 .65909 L
F
.34127 .65909 m
.34127 .68795 L
.37013 .68795 L
.37013 .65909 L
F
.39899 .65909 m
.39899 .68795 L
.42785 .68795 L
.42785 .65909 L
F
.45671 .65909 m
.45671 .68795 L
.48557 .68795 L
.48557 .65909 L
F
.74531 .65909 m
.74531 .68795 L
.77417 .68795 L
.77417 .65909 L
F
.80303 .65909 m
.80303 .68795 L
.83189 .68795 L
.83189 .65909 L
F
.86075 .65909 m
.86075 .68795 L
.88961 .68795 L
.88961 .65909 L
F
.91847 .65909 m
.91847 .68795 L
.94733 .68795 L
.94733 .65909 L
F
.28355 .63023 m
.28355 .65909 L
.31241 .65909 L
.31241 .63023 L
F
.31241 .63023 m
.31241 .65909 L
.34127 .65909 L
.34127 .63023 L
F
.39899 .63023 m
.39899 .65909 L
.42785 .65909 L
.42785 .63023 L
F
.42785 .63023 m
.42785 .65909 L
.45671 .65909 L
.45671 .63023 L
F
.74531 .63023 m
.74531 .65909 L
.77417 .65909 L
.77417 .63023 L
F
.77417 .63023 m
.77417 .65909 L
.80303 .65909 L
.80303 .63023 L
F
.86075 .63023 m
.86075 .65909 L
.88961 .65909 L
.88961 .63023 L
F
.88961 .63023 m
.88961 .65909 L
.91847 .65909 L
.91847 .63023 L
F
.28355 .60137 m
.28355 .63023 L
.31241 .63023 L
.31241 .60137 L
F
.39899 .60137 m
.39899 .63023 L
.42785 .63023 L
.42785 .60137 L
F
.74531 .60137 m
.74531 .63023 L
.77417 .63023 L
.77417 .60137 L
F
.86075 .60137 m
.86075 .63023 L
.88961 .63023 L
.88961 .60137 L
F
.28355 .57251 m
.28355 .60137 L
.31241 .60137 L
.31241 .57251 L
F
.31241 .57251 m
.31241 .60137 L
.34127 .60137 L
.34127 .57251 L
F
.34127 .57251 m
.34127 .60137 L
.37013 .60137 L
.37013 .57251 L
F
.37013 .57251 m
.37013 .60137 L
.39899 .60137 L
.39899 .57251 L
F
.74531 .57251 m
.74531 .60137 L
.77417 .60137 L
.77417 .57251 L
F
.77417 .57251 m
.77417 .60137 L
.80303 .60137 L
.80303 .57251 L
F
.80303 .57251 m
.80303 .60137 L
.83189 .60137 L
.83189 .57251 L
F
.83189 .57251 m
.83189 .60137 L
.86075 .60137 L
.86075 .57251 L
F
.28355 .54365 m
.28355 .57251 L
.31241 .57251 L
.31241 .54365 L
F
.34127 .54365 m
.34127 .57251 L
.37013 .57251 L
.37013 .54365 L
F
.74531 .54365 m
.74531 .57251 L
.77417 .57251 L
.77417 .54365 L
F
.80303 .54365 m
.80303 .57251 L
.83189 .57251 L
.83189 .54365 L
F
.28355 .51479 m
.28355 .54365 L
.31241 .54365 L
.31241 .51479 L
F
.31241 .51479 m
.31241 .54365 L
.34127 .54365 L
.34127 .51479 L
F
.74531 .51479 m
.74531 .54365 L
.77417 .54365 L
.77417 .51479 L
F
.77417 .51479 m
.77417 .54365 L
.80303 .54365 L
.80303 .51479 L
F
.28355 .48593 m
.28355 .51479 L
.31241 .51479 L
.31241 .48593 L
F
.74531 .48593 m
.74531 .51479 L
.77417 .51479 L
.77417 .48593 L
F
.28355 .22619 m
.28355 .25505 L
.31241 .25505 L
.31241 .22619 L
F
.31241 .22619 m
.31241 .25505 L
.34127 .25505 L
.34127 .22619 L
F
.34127 .22619 m
.34127 .25505 L
.37013 .25505 L
.37013 .22619 L
F
.37013 .22619 m
.37013 .25505 L
.39899 .25505 L
.39899 .22619 L
F
.39899 .22619 m
.39899 .25505 L
.42785 .25505 L
.42785 .22619 L
F
.42785 .22619 m
.42785 .25505 L
.45671 .25505 L
.45671 .22619 L
F
.45671 .22619 m
.45671 .25505 L
.48557 .25505 L
.48557 .22619 L
F
.48557 .22619 m
.48557 .25505 L
.51443 .25505 L
.51443 .22619 L
F
.28355 .19733 m
.28355 .22619 L
.31241 .22619 L
.31241 .19733 L
F
.34127 .19733 m
.34127 .22619 L
.37013 .22619 L
.37013 .19733 L
F
.39899 .19733 m
.39899 .22619 L
.42785 .22619 L
.42785 .19733 L
F
.45671 .19733 m
.45671 .22619 L
.48557 .22619 L
.48557 .19733 L
F
.28355 .16847 m
.28355 .19733 L
.31241 .19733 L
.31241 .16847 L
F
.31241 .16847 m
.31241 .19733 L
.34127 .19733 L
.34127 .16847 L
F
.39899 .16847 m
.39899 .19733 L
.42785 .19733 L
.42785 .16847 L
F
.42785 .16847 m
.42785 .19733 L
.45671 .19733 L
.45671 .16847 L
F
.28355 .13961 m
.28355 .16847 L
.31241 .16847 L
.31241 .13961 L
F
.39899 .13961 m
.39899 .16847 L
.42785 .16847 L
.42785 .13961 L
F
.28355 .11075 m
.28355 .13961 L
.31241 .13961 L
.31241 .11075 L
F
.31241 .11075 m
.31241 .13961 L
.34127 .13961 L
.34127 .11075 L
F
.34127 .11075 m
.34127 .13961 L
.37013 .13961 L
.37013 .11075 L
F
.37013 .11075 m
.37013 .13961 L
.39899 .13961 L
.39899 .11075 L
F
.28355 .08189 m
.28355 .11075 L
.31241 .11075 L
.31241 .08189 L
F
.34127 .08189 m
.34127 .11075 L
.37013 .11075 L
.37013 .08189 L
F
.28355 .05303 m
.28355 .08189 L
.31241 .08189 L
.31241 .05303 L
F
.31241 .05303 m
.31241 .08189 L
.34127 .08189 L
.34127 .05303 L
F
.28355 .02417 m
.28355 .05303 L
.31241 .05303 L
.31241 .02417 L
F
.678 .847 .902 r
.31241 .65909 m
.31241 .68795 L
.34127 .68795 L
.34127 .65909 L
F
.37013 .65909 m
.37013 .68795 L
.39899 .68795 L
.39899 .65909 L
F
.42785 .65909 m
.42785 .68795 L
.45671 .68795 L
.45671 .65909 L
F
.48557 .65909 m
.48557 .68795 L
.51443 .68795 L
.51443 .65909 L
F
.77417 .65909 m
.77417 .68795 L
.80303 .68795 L
.80303 .65909 L
F
.83189 .65909 m
.83189 .68795 L
.86075 .68795 L
.86075 .65909 L
F
.88961 .65909 m
.88961 .68795 L
.91847 .68795 L
.91847 .65909 L
F
.94733 .65909 m
.94733 .68795 L
.97619 .68795 L
.97619 .65909 L
F
.31241 .60137 m
.31241 .63023 L
.34127 .63023 L
.34127 .60137 L
F
.42785 .60137 m
.42785 .63023 L
.45671 .63023 L
.45671 .60137 L
F
.77417 .60137 m
.77417 .63023 L
.80303 .63023 L
.80303 .60137 L
F
.88961 .60137 m
.88961 .63023 L
.91847 .63023 L
.91847 .60137 L
F
.31241 .54365 m
.31241 .57251 L
.34127 .57251 L
.34127 .54365 L
F
.37013 .54365 m
.37013 .57251 L
.39899 .57251 L
.39899 .54365 L
F
.77417 .54365 m
.77417 .57251 L
.80303 .57251 L
.80303 .54365 L
F
.83189 .54365 m
.83189 .57251 L
.86075 .57251 L
.86075 .54365 L
F
.31241 .48593 m
.31241 .51479 L
.34127 .51479 L
.34127 .48593 L
F
.77417 .48593 m
.77417 .51479 L
.80303 .51479 L
.80303 .48593 L
F
.31241 .19733 m
.31241 .22619 L
.34127 .22619 L
.34127 .19733 L
F
.37013 .19733 m
.37013 .22619 L
.39899 .22619 L
.39899 .19733 L
F
.42785 .19733 m
.42785 .22619 L
.45671 .22619 L
.45671 .19733 L
F
.48557 .19733 m
.48557 .22619 L
.51443 .22619 L
.51443 .19733 L
F
.31241 .13961 m
.31241 .16847 L
.34127 .16847 L
.34127 .13961 L
F
.42785 .13961 m
.42785 .16847 L
.45671 .16847 L
.45671 .13961 L
F
.31241 .08189 m
.31241 .11075 L
.34127 .11075 L
.34127 .08189 L
F
.37013 .08189 m
.37013 .11075 L
.39899 .11075 L
.39899 .08189 L
F
.31241 .02417 m
.31241 .05303 L
.34127 .05303 L
.34127 .02417 L
F
.89 .81 .34 r
.34127 .63023 m
.34127 .65909 L
.37013 .65909 L
.37013 .63023 L
F
.37013 .63023 m
.37013 .65909 L
.39899 .65909 L
.39899 .63023 L
F
.45671 .63023 m
.45671 .65909 L
.48557 .65909 L
.48557 .63023 L
F
.48557 .63023 m
.48557 .65909 L
.51443 .65909 L
.51443 .63023 L
F
.80303 .63023 m
.80303 .65909 L
.83189 .65909 L
.83189 .63023 L
F
.83189 .63023 m
.83189 .65909 L
.86075 .65909 L
.86075 .63023 L
F
.91847 .63023 m
.91847 .65909 L
.94733 .65909 L
.94733 .63023 L
F
.94733 .63023 m
.94733 .65909 L
.97619 .65909 L
.97619 .63023 L
F
.34127 .60137 m
.34127 .63023 L
.37013 .63023 L
.37013 .60137 L
F
.45671 .60137 m
.45671 .63023 L
.48557 .63023 L
.48557 .60137 L
F
.80303 .60137 m
.80303 .63023 L
.83189 .63023 L
.83189 .60137 L
F
.91847 .60137 m
.91847 .63023 L
.94733 .63023 L
.94733 .60137 L
F
.34127 .51479 m
.34127 .54365 L
.37013 .54365 L
.37013 .51479 L
F
.37013 .51479 m
.37013 .54365 L
.39899 .54365 L
.39899 .51479 L
F
.80303 .51479 m
.80303 .54365 L
.83189 .54365 L
.83189 .51479 L
F
.83189 .51479 m
.83189 .54365 L
.86075 .54365 L
.86075 .51479 L
F
.34127 .48593 m
.34127 .51479 L
.37013 .51479 L
.37013 .48593 L
F
.80303 .48593 m
.80303 .51479 L
.83189 .51479 L
.83189 .48593 L
F
.34127 .16847 m
.34127 .19733 L
.37013 .19733 L
.37013 .16847 L
F
.37013 .16847 m
.37013 .19733 L
.39899 .19733 L
.39899 .16847 L
F
.45671 .16847 m
.45671 .19733 L
.48557 .19733 L
.48557 .16847 L
F
.48557 .16847 m
.48557 .19733 L
.51443 .19733 L
.51443 .16847 L
F
.34127 .13961 m
.34127 .16847 L
.37013 .16847 L
.37013 .13961 L
F
.45671 .13961 m
.45671 .16847 L
.48557 .16847 L
.48557 .13961 L
F
.34127 .05303 m
.34127 .08189 L
.37013 .08189 L
.37013 .05303 L
F
.37013 .05303 m
.37013 .08189 L
.39899 .08189 L
.39899 .05303 L
F
.34127 .02417 m
.34127 .05303 L
.37013 .05303 L
.37013 .02417 L
F
0 1 0 r
.37013 .60137 m
.37013 .63023 L
.39899 .63023 L
.39899 .60137 L
F
.48557 .60137 m
.48557 .63023 L
.51443 .63023 L
.51443 .60137 L
F
.83189 .60137 m
.83189 .63023 L
.86075 .63023 L
.86075 .60137 L
F
.94733 .60137 m
.94733 .63023 L
.97619 .63023 L
.97619 .60137 L
F
.37013 .48593 m
.37013 .51479 L
.39899 .51479 L
.39899 .48593 L
F
.83189 .48593 m
.83189 .51479 L
.86075 .51479 L
.86075 .48593 L
F
.37013 .13961 m
.37013 .16847 L
.39899 .16847 L
.39899 .13961 L
F
.48557 .13961 m
.48557 .16847 L
.51443 .16847 L
.51443 .13961 L
F
.37013 .02417 m
.37013 .05303 L
.39899 .05303 L
.39899 .02417 L
F
.5 .165 .165 r
.39899 .57251 m
.39899 .60137 L
.42785 .60137 L
.42785 .57251 L
F
.42785 .57251 m
.42785 .60137 L
.45671 .60137 L
.45671 .57251 L
F
.45671 .57251 m
.45671 .60137 L
.48557 .60137 L
.48557 .57251 L
F
.48557 .57251 m
.48557 .60137 L
.51443 .60137 L
.51443 .57251 L
F
.86075 .57251 m
.86075 .60137 L
.88961 .60137 L
.88961 .57251 L
F
.88961 .57251 m
.88961 .60137 L
.91847 .60137 L
.91847 .57251 L
F
.91847 .57251 m
.91847 .60137 L
.94733 .60137 L
.94733 .57251 L
F
.94733 .57251 m
.94733 .60137 L
.97619 .60137 L
.97619 .57251 L
F
.39899 .54365 m
.39899 .57251 L
.42785 .57251 L
.42785 .54365 L
F
.45671 .54365 m
.45671 .57251 L
.48557 .57251 L
.48557 .54365 L
F
.86075 .54365 m
.86075 .57251 L
.88961 .57251 L
.88961 .54365 L
F
.91847 .54365 m
.91847 .57251 L
.94733 .57251 L
.94733 .54365 L
F
.39899 .51479 m
.39899 .54365 L
.42785 .54365 L
.42785 .51479 L
F
.42785 .51479 m
.42785 .54365 L
.45671 .54365 L
.45671 .51479 L
F
.86075 .51479 m
.86075 .54365 L
.88961 .54365 L
.88961 .51479 L
F
.88961 .51479 m
.88961 .54365 L
.91847 .54365 L
.91847 .51479 L
F
.39899 .48593 m
.39899 .51479 L
.42785 .51479 L
.42785 .48593 L
F
.86075 .48593 m
.86075 .51479 L
.88961 .51479 L
.88961 .48593 L
F
.39899 .11075 m
.39899 .13961 L
.42785 .13961 L
.42785 .11075 L
F
.42785 .11075 m
.42785 .13961 L
.45671 .13961 L
.45671 .11075 L
F
.45671 .11075 m
.45671 .13961 L
.48557 .13961 L
.48557 .11075 L
F
.48557 .11075 m
.48557 .13961 L
.51443 .13961 L
.51443 .11075 L
F
.39899 .08189 m
.39899 .11075 L
.42785 .11075 L
.42785 .08189 L
F
.45671 .08189 m
.45671 .11075 L
.48557 .11075 L
.48557 .08189 L
F
.39899 .05303 m
.39899 .08189 L
.42785 .08189 L
.42785 .05303 L
F
.42785 .05303 m
.42785 .08189 L
.45671 .08189 L
.45671 .05303 L
F
.39899 .02417 m
.39899 .05303 L
.42785 .05303 L
.42785 .02417 L
F
.753 .753 .753 r
.42785 .54365 m
.42785 .57251 L
.45671 .57251 L
.45671 .54365 L
F
.48557 .54365 m
.48557 .57251 L
.51443 .57251 L
.51443 .54365 L
F
.88961 .54365 m
.88961 .57251 L
.91847 .57251 L
.91847 .54365 L
F
.94733 .54365 m
.94733 .57251 L
.97619 .57251 L
.97619 .54365 L
F
.42785 .48593 m
.42785 .51479 L
.45671 .51479 L
.45671 .48593 L
F
.88961 .48593 m
.88961 .51479 L
.91847 .51479 L
.91847 .48593 L
F
.42785 .08189 m
.42785 .11075 L
.45671 .11075 L
.45671 .08189 L
F
.48557 .08189 m
.48557 .11075 L
.51443 .11075 L
.51443 .08189 L
F
.42785 .02417 m
.42785 .05303 L
.45671 .05303 L
.45671 .02417 L
F
1 0 0 r
.45671 .51479 m
.45671 .54365 L
.48557 .54365 L
.48557 .51479 L
F
.48557 .51479 m
.48557 .54365 L
.51443 .54365 L
.51443 .51479 L
F
.91847 .51479 m
.91847 .54365 L
.94733 .54365 L
.94733 .51479 L
F
.94733 .51479 m
.94733 .54365 L
.97619 .54365 L
.97619 .51479 L
F
.45671 .48593 m
.45671 .51479 L
.48557 .51479 L
.48557 .48593 L
F
.91847 .48593 m
.91847 .51479 L
.94733 .51479 L
.94733 .48593 L
F
.45671 .05303 m
.45671 .08189 L
.48557 .08189 L
.48557 .05303 L
F
.48557 .05303 m
.48557 .08189 L
.51443 .08189 L
.51443 .05303 L
F
.45671 .02417 m
.45671 .05303 L
.48557 .05303 L
.48557 .02417 L
F
.628 .126 .941 r
.48557 .48593 m
.48557 .51479 L
.51443 .51479 L
.51443 .48593 L
F
.94733 .48593 m
.94733 .51479 L
.97619 .51479 L
.97619 .48593 L
F
.48557 .02417 m
.48557 .05303 L
.51443 .05303 L
.51443 .02417 L
F
1 .6 .07 r
.51443 .45707 m
.51443 .48593 L
.54329 .48593 L
.54329 .45707 L
F
.54329 .45707 m
.54329 .48593 L
.57215 .48593 L
.57215 .45707 L
F
.57215 .45707 m
.57215 .48593 L
.60101 .48593 L
.60101 .45707 L
F
.60101 .45707 m
.60101 .48593 L
.62987 .48593 L
.62987 .45707 L
F
.62987 .45707 m
.62987 .48593 L
.65873 .48593 L
.65873 .45707 L
F
.65873 .45707 m
.65873 .48593 L
.68759 .48593 L
.68759 .45707 L
F
.68759 .45707 m
.68759 .48593 L
.71645 .48593 L
.71645 .45707 L
F
.71645 .45707 m
.71645 .48593 L
.74531 .48593 L
.74531 .45707 L
F
.74531 .45707 m
.74531 .48593 L
.77417 .48593 L
.77417 .45707 L
F
.77417 .45707 m
.77417 .48593 L
.80303 .48593 L
.80303 .45707 L
F
.80303 .45707 m
.80303 .48593 L
.83189 .48593 L
.83189 .45707 L
F
.83189 .45707 m
.83189 .48593 L
.86075 .48593 L
.86075 .45707 L
F
.86075 .45707 m
.86075 .48593 L
.88961 .48593 L
.88961 .45707 L
F
.88961 .45707 m
.88961 .48593 L
.91847 .48593 L
.91847 .45707 L
F
.91847 .45707 m
.91847 .48593 L
.94733 .48593 L
.94733 .45707 L
F
.94733 .45707 m
.94733 .48593 L
.97619 .48593 L
.97619 .45707 L
F
.51443 .42821 m
.51443 .45707 L
.54329 .45707 L
.54329 .42821 L
F
.57215 .42821 m
.57215 .45707 L
.60101 .45707 L
.60101 .42821 L
F
.62987 .42821 m
.62987 .45707 L
.65873 .45707 L
.65873 .42821 L
F
.68759 .42821 m
.68759 .45707 L
.71645 .45707 L
.71645 .42821 L
F
.74531 .42821 m
.74531 .45707 L
.77417 .45707 L
.77417 .42821 L
F
.80303 .42821 m
.80303 .45707 L
.83189 .45707 L
.83189 .42821 L
F
.86075 .42821 m
.86075 .45707 L
.88961 .45707 L
.88961 .42821 L
F
.91847 .42821 m
.91847 .45707 L
.94733 .45707 L
.94733 .42821 L
F
.51443 .39935 m
.51443 .42821 L
.54329 .42821 L
.54329 .39935 L
F
.54329 .39935 m
.54329 .42821 L
.57215 .42821 L
.57215 .39935 L
F
.62987 .39935 m
.62987 .42821 L
.65873 .42821 L
.65873 .39935 L
F
.65873 .39935 m
.65873 .42821 L
.68759 .42821 L
.68759 .39935 L
F
.74531 .39935 m
.74531 .42821 L
.77417 .42821 L
.77417 .39935 L
F
.77417 .39935 m
.77417 .42821 L
.80303 .42821 L
.80303 .39935 L
F
.86075 .39935 m
.86075 .42821 L
.88961 .42821 L
.88961 .39935 L
F
.88961 .39935 m
.88961 .42821 L
.91847 .42821 L
.91847 .39935 L
F
.51443 .37049 m
.51443 .39935 L
.54329 .39935 L
.54329 .37049 L
F
.62987 .37049 m
.62987 .39935 L
.65873 .39935 L
.65873 .37049 L
F
.74531 .37049 m
.74531 .39935 L
.77417 .39935 L
.77417 .37049 L
F
.86075 .37049 m
.86075 .39935 L
.88961 .39935 L
.88961 .37049 L
F
.51443 .34163 m
.51443 .37049 L
.54329 .37049 L
.54329 .34163 L
F
.54329 .34163 m
.54329 .37049 L
.57215 .37049 L
.57215 .34163 L
F
.57215 .34163 m
.57215 .37049 L
.60101 .37049 L
.60101 .34163 L
F
.60101 .34163 m
.60101 .37049 L
.62987 .37049 L
.62987 .34163 L
F
.74531 .34163 m
.74531 .37049 L
.77417 .37049 L
.77417 .34163 L
F
.77417 .34163 m
.77417 .37049 L
.80303 .37049 L
.80303 .34163 L
F
.80303 .34163 m
.80303 .37049 L
.83189 .37049 L
.83189 .34163 L
F
.83189 .34163 m
.83189 .37049 L
.86075 .37049 L
.86075 .34163 L
F
.51443 .31277 m
.51443 .34163 L
.54329 .34163 L
.54329 .31277 L
F
.57215 .31277 m
.57215 .34163 L
.60101 .34163 L
.60101 .31277 L
F
.74531 .31277 m
.74531 .34163 L
.77417 .34163 L
.77417 .31277 L
F
.80303 .31277 m
.80303 .34163 L
.83189 .34163 L
.83189 .31277 L
F
.51443 .28391 m
.51443 .31277 L
.54329 .31277 L
.54329 .28391 L
F
.54329 .28391 m
.54329 .31277 L
.57215 .31277 L
.57215 .28391 L
F
.74531 .28391 m
.74531 .31277 L
.77417 .31277 L
.77417 .28391 L
F
.77417 .28391 m
.77417 .31277 L
.80303 .31277 L
.80303 .28391 L
F
.51443 .25505 m
.51443 .28391 L
.54329 .28391 L
.54329 .25505 L
F
.74531 .25505 m
.74531 .28391 L
.77417 .28391 L
.77417 .25505 L
F
.51443 .22619 m
.51443 .25505 L
.54329 .25505 L
.54329 .22619 L
F
.54329 .22619 m
.54329 .25505 L
.57215 .25505 L
.57215 .22619 L
F
.57215 .22619 m
.57215 .25505 L
.60101 .25505 L
.60101 .22619 L
F
.60101 .22619 m
.60101 .25505 L
.62987 .25505 L
.62987 .22619 L
F
.62987 .22619 m
.62987 .25505 L
.65873 .25505 L
.65873 .22619 L
F
.65873 .22619 m
.65873 .25505 L
.68759 .25505 L
.68759 .22619 L
F
.68759 .22619 m
.68759 .25505 L
.71645 .25505 L
.71645 .22619 L
F
.71645 .22619 m
.71645 .25505 L
.74531 .25505 L
.74531 .22619 L
F
.51443 .19733 m
.51443 .22619 L
.54329 .22619 L
.54329 .19733 L
F
.57215 .19733 m
.57215 .22619 L
.60101 .22619 L
.60101 .19733 L
F
.62987 .19733 m
.62987 .22619 L
.65873 .22619 L
.65873 .19733 L
F
.68759 .19733 m
.68759 .22619 L
.71645 .22619 L
.71645 .19733 L
F
.51443 .16847 m
.51443 .19733 L
.54329 .19733 L
.54329 .16847 L
F
.54329 .16847 m
.54329 .19733 L
.57215 .19733 L
.57215 .16847 L
F
.62987 .16847 m
.62987 .19733 L
.65873 .19733 L
.65873 .16847 L
F
.65873 .16847 m
.65873 .19733 L
.68759 .19733 L
.68759 .16847 L
F
.51443 .13961 m
.51443 .16847 L
.54329 .16847 L
.54329 .13961 L
F
.62987 .13961 m
.62987 .16847 L
.65873 .16847 L
.65873 .13961 L
F
.51443 .11075 m
.51443 .13961 L
.54329 .13961 L
.54329 .11075 L
F
.54329 .11075 m
.54329 .13961 L
.57215 .13961 L
.57215 .11075 L
F
.57215 .11075 m
.57215 .13961 L
.60101 .13961 L
.60101 .11075 L
F
.60101 .11075 m
.60101 .13961 L
.62987 .13961 L
.62987 .11075 L
F
.51443 .08189 m
.51443 .11075 L
.54329 .11075 L
.54329 .08189 L
F
.57215 .08189 m
.57215 .11075 L
.60101 .11075 L
.60101 .08189 L
F
.51443 .05303 m
.51443 .08189 L
.54329 .08189 L
.54329 .05303 L
F
.54329 .05303 m
.54329 .08189 L
.57215 .08189 L
.57215 .05303 L
F
.51443 .02417 m
.51443 .05303 L
.54329 .05303 L
.54329 .02417 L
F
.69 .188 .377 r
.54329 .42821 m
.54329 .45707 L
.57215 .45707 L
.57215 .42821 L
F
.60101 .42821 m
.60101 .45707 L
.62987 .45707 L
.62987 .42821 L
F
.65873 .42821 m
.65873 .45707 L
.68759 .45707 L
.68759 .42821 L
F
.71645 .42821 m
.71645 .45707 L
.74531 .45707 L
.74531 .42821 L
F
.77417 .42821 m
.77417 .45707 L
.80303 .45707 L
.80303 .42821 L
F
.83189 .42821 m
.83189 .45707 L
.86075 .45707 L
.86075 .42821 L
F
.88961 .42821 m
.88961 .45707 L
.91847 .45707 L
.91847 .42821 L
F
.94733 .42821 m
.94733 .45707 L
.97619 .45707 L
.97619 .42821 L
F
.54329 .37049 m
.54329 .39935 L
.57215 .39935 L
.57215 .37049 L
F
.65873 .37049 m
.65873 .39935 L
.68759 .39935 L
.68759 .37049 L
F
.77417 .37049 m
.77417 .39935 L
.80303 .39935 L
.80303 .37049 L
F
.88961 .37049 m
.88961 .39935 L
.91847 .39935 L
.91847 .37049 L
F
.54329 .31277 m
.54329 .34163 L
.57215 .34163 L
.57215 .31277 L
F
.60101 .31277 m
.60101 .34163 L
.62987 .34163 L
.62987 .31277 L
F
.77417 .31277 m
.77417 .34163 L
.80303 .34163 L
.80303 .31277 L
F
.83189 .31277 m
.83189 .34163 L
.86075 .34163 L
.86075 .31277 L
F
.54329 .25505 m
.54329 .28391 L
.57215 .28391 L
.57215 .25505 L
F
.77417 .25505 m
.77417 .28391 L
.80303 .28391 L
.80303 .25505 L
F
.54329 .19733 m
.54329 .22619 L
.57215 .22619 L
.57215 .19733 L
F
.60101 .19733 m
.60101 .22619 L
.62987 .22619 L
.62987 .19733 L
F
.65873 .19733 m
.65873 .22619 L
.68759 .22619 L
.68759 .19733 L
F
.71645 .19733 m
.71645 .22619 L
.74531 .22619 L
.74531 .19733 L
F
.54329 .13961 m
.54329 .16847 L
.57215 .16847 L
.57215 .13961 L
F
.65873 .13961 m
.65873 .16847 L
.68759 .16847 L
.68759 .13961 L
F
.54329 .08189 m
.54329 .11075 L
.57215 .11075 L
.57215 .08189 L
F
.60101 .08189 m
.60101 .11075 L
.62987 .11075 L
.62987 .08189 L
F
.54329 .02417 m
.54329 .05303 L
.57215 .05303 L
.57215 .02417 L
F
0 0 .502 r
.57215 .39935 m
.57215 .42821 L
.60101 .42821 L
.60101 .39935 L
F
.60101 .39935 m
.60101 .42821 L
.62987 .42821 L
.62987 .39935 L
F
.68759 .39935 m
.68759 .42821 L
.71645 .42821 L
.71645 .39935 L
F
.71645 .39935 m
.71645 .42821 L
.74531 .42821 L
.74531 .39935 L
F
.80303 .39935 m
.80303 .42821 L
.83189 .42821 L
.83189 .39935 L
F
.83189 .39935 m
.83189 .42821 L
.86075 .42821 L
.86075 .39935 L
F
.91847 .39935 m
.91847 .42821 L
.94733 .42821 L
.94733 .39935 L
F
.94733 .39935 m
.94733 .42821 L
.97619 .42821 L
.97619 .39935 L
F
.57215 .37049 m
.57215 .39935 L
.60101 .39935 L
.60101 .37049 L
F
.68759 .37049 m
.68759 .39935 L
.71645 .39935 L
.71645 .37049 L
F
.80303 .37049 m
.80303 .39935 L
.83189 .39935 L
.83189 .37049 L
F
.91847 .37049 m
.91847 .39935 L
.94733 .39935 L
.94733 .37049 L
F
.57215 .28391 m
.57215 .31277 L
.60101 .31277 L
.60101 .28391 L
F
.60101 .28391 m
.60101 .31277 L
.62987 .31277 L
.62987 .28391 L
F
.80303 .28391 m
.80303 .31277 L
.83189 .31277 L
.83189 .28391 L
F
.83189 .28391 m
.83189 .31277 L
.86075 .31277 L
.86075 .28391 L
F
.57215 .25505 m
.57215 .28391 L
.60101 .28391 L
.60101 .25505 L
F
.80303 .25505 m
.80303 .28391 L
.83189 .28391 L
.83189 .25505 L
F
.57215 .16847 m
.57215 .19733 L
.60101 .19733 L
.60101 .16847 L
F
.60101 .16847 m
.60101 .19733 L
.62987 .19733 L
.62987 .16847 L
F
.68759 .16847 m
.68759 .19733 L
.71645 .19733 L
.71645 .16847 L
F
.71645 .16847 m
.71645 .19733 L
.74531 .19733 L
.74531 .16847 L
F
.57215 .13961 m
.57215 .16847 L
.60101 .16847 L
.60101 .13961 L
F
.68759 .13961 m
.68759 .16847 L
.71645 .16847 L
.71645 .13961 L
F
.57215 .05303 m
.57215 .08189 L
.60101 .08189 L
.60101 .05303 L
F
.60101 .05303 m
.60101 .08189 L
.62987 .08189 L
.62987 .05303 L
F
.57215 .02417 m
.57215 .05303 L
.60101 .05303 L
.60101 .02417 L
F
.98 .502 .447 r
.60101 .37049 m
.60101 .39935 L
.62987 .39935 L
.62987 .37049 L
F
.71645 .37049 m
.71645 .39935 L
.74531 .39935 L
.74531 .37049 L
F
.83189 .37049 m
.83189 .39935 L
.86075 .39935 L
.86075 .37049 L
F
.94733 .37049 m
.94733 .39935 L
.97619 .39935 L
.97619 .37049 L
F
.60101 .25505 m
.60101 .28391 L
.62987 .28391 L
.62987 .25505 L
F
.83189 .25505 m
.83189 .28391 L
.86075 .28391 L
.86075 .25505 L
F
.60101 .13961 m
.60101 .16847 L
.62987 .16847 L
.62987 .13961 L
F
.71645 .13961 m
.71645 .16847 L
.74531 .16847 L
.74531 .13961 L
F
.60101 .02417 m
.60101 .05303 L
.62987 .05303 L
.62987 .02417 L
F
.498 1 .831 r
.62987 .34163 m
.62987 .37049 L
.65873 .37049 L
.65873 .34163 L
F
.65873 .34163 m
.65873 .37049 L
.68759 .37049 L
.68759 .34163 L
F
.68759 .34163 m
.68759 .37049 L
.71645 .37049 L
.71645 .34163 L
F
.71645 .34163 m
.71645 .37049 L
.74531 .37049 L
.74531 .34163 L
F
.86075 .34163 m
.86075 .37049 L
.88961 .37049 L
.88961 .34163 L
F
.88961 .34163 m
.88961 .37049 L
.91847 .37049 L
.91847 .34163 L
F
.91847 .34163 m
.91847 .37049 L
.94733 .37049 L
.94733 .34163 L
F
.94733 .34163 m
.94733 .37049 L
.97619 .37049 L
.97619 .34163 L
F
.62987 .31277 m
.62987 .34163 L
.65873 .34163 L
.65873 .31277 L
F
.68759 .31277 m
.68759 .34163 L
.71645 .34163 L
.71645 .31277 L
F
.86075 .31277 m
.86075 .34163 L
.88961 .34163 L
.88961 .31277 L
F
.91847 .31277 m
.91847 .34163 L
.94733 .34163 L
.94733 .31277 L
F
.62987 .28391 m
.62987 .31277 L
.65873 .31277 L
.65873 .28391 L
F
.65873 .28391 m
.65873 .31277 L
.68759 .31277 L
.68759 .28391 L
F
.86075 .28391 m
.86075 .31277 L
.88961 .31277 L
.88961 .28391 L
F
.88961 .28391 m
.88961 .31277 L
.91847 .31277 L
.91847 .28391 L
F
.62987 .25505 m
.62987 .28391 L
.65873 .28391 L
.65873 .25505 L
F
.86075 .25505 m
.86075 .28391 L
.88961 .28391 L
.88961 .25505 L
F
.62987 .11075 m
.62987 .13961 L
.65873 .13961 L
.65873 .11075 L
F
.65873 .11075 m
.65873 .13961 L
.68759 .13961 L
.68759 .11075 L
F
.68759 .11075 m
.68759 .13961 L
.71645 .13961 L
.71645 .11075 L
F
.71645 .11075 m
.71645 .13961 L
.74531 .13961 L
.74531 .11075 L
F
.62987 .08189 m
.62987 .11075 L
.65873 .11075 L
.65873 .08189 L
F
.68759 .08189 m
.68759 .11075 L
.71645 .11075 L
.71645 .08189 L
F
.62987 .05303 m
.62987 .08189 L
.65873 .08189 L
.65873 .05303 L
F
.65873 .05303 m
.65873 .08189 L
.68759 .08189 L
.68759 .05303 L
F
.62987 .02417 m
.62987 .05303 L
.65873 .05303 L
.65873 .02417 L
F
.03 .18 .33 r
.65873 .31277 m
.65873 .34163 L
.68759 .34163 L
.68759 .31277 L
F
.71645 .31277 m
.71645 .34163 L
.74531 .34163 L
.74531 .31277 L
F
.88961 .31277 m
.88961 .34163 L
.91847 .34163 L
.91847 .31277 L
F
.94733 .31277 m
.94733 .34163 L
.97619 .34163 L
.97619 .31277 L
F
.65873 .25505 m
.65873 .28391 L
.68759 .28391 L
.68759 .25505 L
F
.88961 .25505 m
.88961 .28391 L
.91847 .28391 L
.91847 .25505 L
F
.65873 .08189 m
.65873 .11075 L
.68759 .11075 L
.68759 .08189 L
F
.71645 .08189 m
.71645 .11075 L
.74531 .11075 L
.74531 .08189 L
F
.65873 .02417 m
.65873 .05303 L
.68759 .05303 L
.68759 .02417 L
F
.902 .902 .98 r
.68759 .28391 m
.68759 .31277 L
.71645 .31277 L
.71645 .28391 L
F
.71645 .28391 m
.71645 .31277 L
.74531 .31277 L
.74531 .28391 L
F
.91847 .28391 m
.91847 .31277 L
.94733 .31277 L
.94733 .28391 L
F
.94733 .28391 m
.94733 .31277 L
.97619 .31277 L
.97619 .28391 L
F
.68759 .25505 m
.68759 .28391 L
.71645 .28391 L
.71645 .25505 L
F
.91847 .25505 m
.91847 .28391 L
.94733 .28391 L
.94733 .25505 L
F
.68759 .05303 m
.68759 .08189 L
.71645 .08189 L
.71645 .05303 L
F
.71645 .05303 m
.71645 .08189 L
.74531 .08189 L
.74531 .05303 L
F
.68759 .02417 m
.68759 .05303 L
.71645 .05303 L
.71645 .02417 L
F
.981 .922 .845 r
.71645 .25505 m
.71645 .28391 L
.74531 .28391 L
.74531 .25505 L
F
.94733 .25505 m
.94733 .28391 L
.97619 .28391 L
.97619 .25505 L
F
.71645 .02417 m
.71645 .05303 L
.74531 .05303 L
.74531 .02417 L
F
1 .898 .772 r
.74531 .22619 m
.74531 .25505 L
.77417 .25505 L
.77417 .22619 L
F
.77417 .22619 m
.77417 .25505 L
.80303 .25505 L
.80303 .22619 L
F
.80303 .22619 m
.80303 .25505 L
.83189 .25505 L
.83189 .22619 L
F
.83189 .22619 m
.83189 .25505 L
.86075 .25505 L
.86075 .22619 L
F
.86075 .22619 m
.86075 .25505 L
.88961 .25505 L
.88961 .22619 L
F
.88961 .22619 m
.88961 .25505 L
.91847 .25505 L
.91847 .22619 L
F
.91847 .22619 m
.91847 .25505 L
.94733 .25505 L
.94733 .22619 L
F
.94733 .22619 m
.94733 .25505 L
.97619 .25505 L
.97619 .22619 L
F
.74531 .19733 m
.74531 .22619 L
.77417 .22619 L
.77417 .19733 L
F
.80303 .19733 m
.80303 .22619 L
.83189 .22619 L
.83189 .19733 L
F
.86075 .19733 m
.86075 .22619 L
.88961 .22619 L
.88961 .19733 L
F
.91847 .19733 m
.91847 .22619 L
.94733 .22619 L
.94733 .19733 L
F
.74531 .16847 m
.74531 .19733 L
.77417 .19733 L
.77417 .16847 L
F
.77417 .16847 m
.77417 .19733 L
.80303 .19733 L
.80303 .16847 L
F
.86075 .16847 m
.86075 .19733 L
.88961 .19733 L
.88961 .16847 L
F
.88961 .16847 m
.88961 .19733 L
.91847 .19733 L
.91847 .16847 L
F
.74531 .13961 m
.74531 .16847 L
.77417 .16847 L
.77417 .13961 L
F
.86075 .13961 m
.86075 .16847 L
.88961 .16847 L
.88961 .13961 L
F
.74531 .11075 m
.74531 .13961 L
.77417 .13961 L
.77417 .11075 L
F
.77417 .11075 m
.77417 .13961 L
.80303 .13961 L
.80303 .11075 L
F
.80303 .11075 m
.80303 .13961 L
.83189 .13961 L
.83189 .11075 L
F
.83189 .11075 m
.83189 .13961 L
.86075 .13961 L
.86075 .11075 L
F
.74531 .08189 m
.74531 .11075 L
.77417 .11075 L
.77417 .08189 L
F
.80303 .08189 m
.80303 .11075 L
.83189 .11075 L
.83189 .08189 L
F
.74531 .05303 m
.74531 .08189 L
.77417 .08189 L
.77417 .05303 L
F
.77417 .05303 m
.77417 .08189 L
.80303 .08189 L
.80303 .05303 L
F
.74531 .02417 m
.74531 .05303 L
.77417 .05303 L
.77417 .02417 L
F
.871 .722 .529 r
.77417 .19733 m
.77417 .22619 L
.80303 .22619 L
.80303 .19733 L
F
.83189 .19733 m
.83189 .22619 L
.86075 .22619 L
.86075 .19733 L
F
.88961 .19733 m
.88961 .22619 L
.91847 .22619 L
.91847 .19733 L
F
.94733 .19733 m
.94733 .22619 L
.97619 .22619 L
.97619 .19733 L
F
.77417 .13961 m
.77417 .16847 L
.80303 .16847 L
.80303 .13961 L
F
.88961 .13961 m
.88961 .16847 L
.91847 .16847 L
.91847 .13961 L
F
.77417 .08189 m
.77417 .11075 L
.80303 .11075 L
.80303 .08189 L
F
.83189 .08189 m
.83189 .11075 L
.86075 .11075 L
.86075 .08189 L
F
.77417 .02417 m
.77417 .05303 L
.80303 .05303 L
.80303 .02417 L
F
.99 .9 .79 r
.80303 .16847 m
.80303 .19733 L
.83189 .19733 L
.83189 .16847 L
F
.83189 .16847 m
.83189 .19733 L
.86075 .19733 L
.86075 .16847 L
F
.91847 .16847 m
.91847 .19733 L
.94733 .19733 L
.94733 .16847 L
F
.94733 .16847 m
.94733 .19733 L
.97619 .19733 L
.97619 .16847 L
F
.80303 .13961 m
.80303 .16847 L
.83189 .16847 L
.83189 .13961 L
F
.91847 .13961 m
.91847 .16847 L
.94733 .16847 L
.94733 .13961 L
F
.80303 .05303 m
.80303 .08189 L
.83189 .08189 L
.83189 .05303 L
F
.83189 .05303 m
.83189 .08189 L
.86075 .08189 L
.86075 .05303 L
F
.80303 .02417 m
.80303 .05303 L
.83189 .05303 L
.83189 .02417 L
F
.941 .902 .549 r
.83189 .13961 m
.83189 .16847 L
.86075 .16847 L
.86075 .13961 L
F
.94733 .13961 m
.94733 .16847 L
.97619 .16847 L
.97619 .13961 L
F
.83189 .02417 m
.83189 .05303 L
.86075 .05303 L
.86075 .02417 L
F
.541 .169 .886 r
.86075 .11075 m
.86075 .13961 L
.88961 .13961 L
.88961 .11075 L
F
.88961 .11075 m
.88961 .13961 L
.91847 .13961 L
.91847 .11075 L
F
.91847 .11075 m
.91847 .13961 L
.94733 .13961 L
.94733 .11075 L
F
.94733 .11075 m
.94733 .13961 L
.97619 .13961 L
.97619 .11075 L
F
.86075 .08189 m
.86075 .11075 L
.88961 .11075 L
.88961 .08189 L
F
.91847 .08189 m
.91847 .11075 L
.94733 .11075 L
.94733 .08189 L
F
.86075 .05303 m
.86075 .08189 L
.88961 .08189 L
.88961 .05303 L
F
.88961 .05303 m
.88961 .08189 L
.91847 .08189 L
.91847 .05303 L
F
.86075 .02417 m
.86075 .05303 L
.88961 .05303 L
.88961 .02417 L
F
1 .38 .01 r
.88961 .08189 m
.88961 .11075 L
.91847 .11075 L
.91847 .08189 L
F
.94733 .08189 m
.94733 .11075 L
.97619 .11075 L
.97619 .08189 L
F
.88961 .02417 m
.88961 .05303 L
.91847 .05303 L
.91847 .02417 L
F
.89 .09 .05 r
.91847 .05303 m
.91847 .08189 L
.94733 .08189 L
.94733 .05303 L
F
.94733 .05303 m
.94733 .08189 L
.97619 .08189 L
.97619 .05303 L
F
.91847 .02417 m
.91847 .05303 L
.94733 .05303 L
.94733 .02417 L
F
.02 .72 .8 r
.94733 .02417 m
.94733 .05303 L
.97619 .05303 L
.97619 .02417 L
F
1 1 0 r
.05267 .94769 m
.05267 .97655 L
.08153 .97655 L
.08153 .94769 L
F
1 .5 0 r
.08153 .94769 m
.08153 .97655 L
.11039 .97655 L
.11039 .94769 L
F
.56 .37 .6 r
.11039 .94769 m
.11039 .97655 L
.13925 .97655 L
.13925 .94769 L
F
0 0 1 r
.13925 .94769 m
.13925 .97655 L
.16811 .97655 L
.16811 .94769 L
F
.74 .99 .79 r
.16811 .94769 m
.16811 .97655 L
.19697 .97655 L
.19697 .94769 L
F
.251 .878 .816 r
.19697 .94769 m
.19697 .97655 L
.22583 .97655 L
.22583 .94769 L
F
0 .79 .34 r
.22583 .94769 m
.22583 .97655 L
.25469 .97655 L
.25469 .94769 L
F
0 .392 0 r
.25469 .94769 m
.25469 .97655 L
.28355 .97655 L
.28355 .94769 L
F
1 .753 .796 r
.28355 .94769 m
.28355 .97655 L
.31241 .97655 L
.31241 .94769 L
F
.678 .847 .902 r
.31241 .94769 m
.31241 .97655 L
.34127 .97655 L
.34127 .94769 L
F
.89 .81 .34 r
.34127 .94769 m
.34127 .97655 L
.37013 .97655 L
.37013 .94769 L
F
0 1 0 r
.37013 .94769 m
.37013 .97655 L
.39899 .97655 L
.39899 .94769 L
F
.5 .165 .165 r
.39899 .94769 m
.39899 .97655 L
.42785 .97655 L
.42785 .94769 L
F
.753 .753 .753 r
.42785 .94769 m
.42785 .97655 L
.45671 .97655 L
.45671 .94769 L
F
1 0 0 r
.45671 .94769 m
.45671 .97655 L
.48557 .97655 L
.48557 .94769 L
F
.628 .126 .941 r
.48557 .94769 m
.48557 .97655 L
.51443 .97655 L
.51443 .94769 L
F
1 .6 .07 r
.51443 .94769 m
.51443 .97655 L
.54329 .97655 L
.54329 .94769 L
F
.69 .188 .377 r
.54329 .94769 m
.54329 .97655 L
.57215 .97655 L
.57215 .94769 L
F
0 0 .502 r
.57215 .94769 m
.57215 .97655 L
.60101 .97655 L
.60101 .94769 L
F
.98 .502 .447 r
.60101 .94769 m
.60101 .97655 L
.62987 .97655 L
.62987 .94769 L
F
.498 1 .831 r
.62987 .94769 m
.62987 .97655 L
.65873 .97655 L
.65873 .94769 L
F
.03 .18 .33 r
.65873 .94769 m
.65873 .97655 L
.68759 .97655 L
.68759 .94769 L
F
.902 .902 .98 r
.68759 .94769 m
.68759 .97655 L
.71645 .97655 L
.71645 .94769 L
F
.981 .922 .845 r
.71645 .94769 m
.71645 .97655 L
.74531 .97655 L
.74531 .94769 L
F
1 .898 .772 r
.74531 .94769 m
.74531 .97655 L
.77417 .97655 L
.77417 .94769 L
F
.871 .722 .529 r
.77417 .94769 m
.77417 .97655 L
.80303 .97655 L
.80303 .94769 L
F
.99 .9 .79 r
.80303 .94769 m
.80303 .97655 L
.83189 .97655 L
.83189 .94769 L
F
.941 .902 .549 r
.83189 .94769 m
.83189 .97655 L
.86075 .97655 L
.86075 .94769 L
F
.541 .169 .886 r
.86075 .94769 m
.86075 .97655 L
.88961 .97655 L
.88961 .94769 L
F
1 .38 .01 r
.88961 .94769 m
.88961 .97655 L
.91847 .97655 L
.91847 .94769 L
F
.89 .09 .05 r
.91847 .94769 m
.91847 .97655 L
.94733 .97655 L
.94733 .94769 L
F
.02 .72 .8 r
.94733 .94769 m
.94733 .97655 L
.97619 .97655 L
.97619 .94769 L
F
1 1 0 r
.02381 .91883 m
.02381 .94769 L
.05267 .94769 L
.05267 .91883 L
F
1 .5 0 r
.02381 .88997 m
.02381 .91883 L
.05267 .91883 L
.05267 .88997 L
F
.56 .37 .6 r
.02381 .86111 m
.02381 .88997 L
.05267 .88997 L
.05267 .86111 L
F
0 0 1 r
.02381 .83225 m
.02381 .86111 L
.05267 .86111 L
.05267 .83225 L
F
.74 .99 .79 r
.02381 .80339 m
.02381 .83225 L
.05267 .83225 L
.05267 .80339 L
F
.251 .878 .816 r
.02381 .77453 m
.02381 .80339 L
.05267 .80339 L
.05267 .77453 L
F
0 .79 .34 r
.02381 .74567 m
.02381 .77453 L
.05267 .77453 L
.05267 .74567 L
F
0 .392 0 r
.02381 .71681 m
.02381 .74567 L
.05267 .74567 L
.05267 .71681 L
F
1 .753 .796 r
.02381 .68795 m
.02381 .71681 L
.05267 .71681 L
.05267 .68795 L
F
.678 .847 .902 r
.02381 .65909 m
.02381 .68795 L
.05267 .68795 L
.05267 .65909 L
F
.89 .81 .34 r
.02381 .63023 m
.02381 .65909 L
.05267 .65909 L
.05267 .63023 L
F
0 1 0 r
.02381 .60137 m
.02381 .63023 L
.05267 .63023 L
.05267 .60137 L
F
.5 .165 .165 r
.02381 .57251 m
.02381 .60137 L
.05267 .60137 L
.05267 .57251 L
F
.753 .753 .753 r
.02381 .54365 m
.02381 .57251 L
.05267 .57251 L
.05267 .54365 L
F
1 0 0 r
.02381 .51479 m
.02381 .54365 L
.05267 .54365 L
.05267 .51479 L
F
.628 .126 .941 r
.02381 .48593 m
.02381 .51479 L
.05267 .51479 L
.05267 .48593 L
F
1 .6 .07 r
.02381 .45707 m
.02381 .48593 L
.05267 .48593 L
.05267 .45707 L
F
.69 .188 .377 r
.02381 .42821 m
.02381 .45707 L
.05267 .45707 L
.05267 .42821 L
F
0 0 .502 r
.02381 .39935 m
.02381 .42821 L
.05267 .42821 L
.05267 .39935 L
F
.98 .502 .447 r
.02381 .37049 m
.02381 .39935 L
.05267 .39935 L
.05267 .37049 L
F
.498 1 .831 r
.02381 .34163 m
.02381 .37049 L
.05267 .37049 L
.05267 .34163 L
F
.03 .18 .33 r
.02381 .31277 m
.02381 .34163 L
.05267 .34163 L
.05267 .31277 L
F
.902 .902 .98 r
.02381 .28391 m
.02381 .31277 L
.05267 .31277 L
.05267 .28391 L
F
.981 .922 .845 r
.02381 .25505 m
.02381 .28391 L
.05267 .28391 L
.05267 .25505 L
F
1 .898 .772 r
.02381 .22619 m
.02381 .25505 L
.05267 .25505 L
.05267 .22619 L
F
.871 .722 .529 r
.02381 .19733 m
.02381 .22619 L
.05267 .22619 L
.05267 .19733 L
F
.99 .9 .79 r
.02381 .16847 m
.02381 .19733 L
.05267 .19733 L
.05267 .16847 L
F
.941 .902 .549 r
.02381 .13961 m
.02381 .16847 L
.05267 .16847 L
.05267 .13961 L
F
.541 .169 .886 r
.02381 .11075 m
.02381 .13961 L
.05267 .13961 L
.05267 .11075 L
F
1 .38 .01 r
.02381 .08189 m
.02381 .11075 L
.05267 .11075 L
.05267 .08189 L
F
.89 .09 .05 r
.02381 .05303 m
.02381 .08189 L
.05267 .08189 L
.05267 .05303 L
F
.02 .72 .8 r
.02381 .02417 m
.02381 .05303 L
.05267 .05303 L
.05267 .02417 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02417 m
.02381 .97655 L
s
.02381 .02417 m
.97619 .02417 L
s
.02381 .05303 m
.97619 .05303 L
s
.02381 .08189 m
.97619 .08189 L
s
.02381 .11075 m
.97619 .11075 L
s
.02381 .13961 m
.97619 .13961 L
s
.02381 .16847 m
.97619 .16847 L
s
.02381 .19733 m
.97619 .19733 L
s
.02381 .22619 m
.97619 .22619 L
s
.02381 .25505 m
.97619 .25505 L
s
.02381 .28391 m
.97619 .28391 L
s
.02381 .31277 m
.97619 .31277 L
s
.02381 .34163 m
.97619 .34163 L
s
.02381 .37049 m
.97619 .37049 L
s
.02381 .39935 m
.97619 .39935 L
s
.02381 .42821 m
.97619 .42821 L
s
.02381 .45707 m
.97619 .45707 L
s
.02381 .48593 m
.97619 .48593 L
s
.02381 .51479 m
.97619 .51479 L
s
.02381 .54365 m
.97619 .54365 L
s
.02381 .57251 m
.97619 .57251 L
s
.02381 .60137 m
.97619 .60137 L
s
.02381 .63023 m
.97619 .63023 L
s
.02381 .65909 m
.97619 .65909 L
s
.02381 .68795 m
.97619 .68795 L
s
.02381 .71681 m
.97619 .71681 L
s
.02381 .74567 m
.97619 .74567 L
s
.02381 .77453 m
.97619 .77453 L
s
.02381 .80339 m
.97619 .80339 L
s
.02381 .83225 m
.97619 .83225 L
s
.02381 .86111 m
.97619 .86111 L
s
.02381 .88997 m
.97619 .88997 L
s
.02381 .91883 m
.97619 .91883 L
s
.02381 .94769 m
.97619 .94769 L
s
.02381 .97655 m
.97619 .97655 L
s
.05267 .02417 m
.05267 .97655 L
s
.08153 .02417 m
.08153 .97655 L
s
.11039 .02417 m
.11039 .97655 L
s
.13925 .02417 m
.13925 .97655 L
s
.16811 .02417 m
.16811 .97655 L
s
.19697 .02417 m
.19697 .97655 L
s
.22583 .02417 m
.22583 .97655 L
s
.25469 .02417 m
.25469 .97655 L
s
.28355 .02417 m
.28355 .97655 L
s
.31241 .02417 m
.31241 .97655 L
s
.34127 .02417 m
.34127 .97655 L
s
.37013 .02417 m
.37013 .97655 L
s
.39899 .02417 m
.39899 .97655 L
s
.42785 .02417 m
.42785 .97655 L
s
.45671 .02417 m
.45671 .97655 L
s
.48557 .02417 m
.48557 .97655 L
s
.51443 .02417 m
.51443 .97655 L
s
.54329 .02417 m
.54329 .97655 L
s
.57215 .02417 m
.57215 .97655 L
s
.60101 .02417 m
.60101 .97655 L
s
.62987 .02417 m
.62987 .97655 L
s
.65873 .02417 m
.65873 .97655 L
s
.68759 .02417 m
.68759 .97655 L
s
.71645 .02417 m
.71645 .97655 L
s
.74531 .02417 m
.74531 .97655 L
s
.77417 .02417 m
.77417 .97655 L
s
.80303 .02417 m
.80303 .97655 L
s
.83189 .02417 m
.83189 .97655 L
s
.86075 .02417 m
.86075 .97655 L
s
.88961 .02417 m
.88961 .97655 L
s
.91847 .02417 m
.91847 .97655 L
s
.94733 .02417 m
.94733 .97655 L
s
.97619 .02417 m
.97619 .97655 L
s
.02381 .97655 m
.05267 .94769 L
s
2.6 Mabswid
.05267 .02417 m
.05267 .97655 L
s
.02381 .94769 m
.97619 .94769 L
s
[(Multiplication)] .02381 .99098 -1 0 Mshowa
gsave
.97619 .99098 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .03362 .95722 0 0 Mshowa
[(y)] .04545 .96789 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{288, 139.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000R`P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X000?o`;000_l01l2`oalS7ol00el05om>LDko0Zoo
eP;FojlF[on[0Z_o0^Ko00?F01Co860Po`h33_n_OolP<23o;Vh^o`>O00CoSTko0al02Ol[:b_o4BhA
o`02d00<onj_k_oe3oGo_fKo0e003?nPh:3o3[0>o`?Fo`=<00Wom7kdoimOWol00]l00ol0000A0004
ok3oo`?O00SoWenOooAno`=<00co0mH3o`j`3_nPh?l3D00<okmV_ooe3oGokZoo0m001OlA;Q7o00<[
00So7aooSTj>o`>O01Co;Vh^ob0`ojmo[ol>0`ko860Po`;F01So0^H2oj/2Zon_5ZooeP;o0Zl2odia
C_l2G`09ob<O8oo0/<3o00/0000:0003o`S000;o03l8`?mO8eooWenOoh5>POl30_mV0VKo_njoof/2
JoofU_oFa]Ko860Po`<>0om_[ol`833oKSi^ofnOKom>?_l00al02Ol[:b_o;U4^o`02d00Kojo_[ol?
cPooi[ooD91@on2Ph?l>l@ko3`?o00=<00WoOW5noimOWol00]l00ol0000A0004ol3oo`?O00SoWenO
ogiao`=<01_o3`<?o`ka3_oPX?n@D93oi[oVo`o>3on_kol00m001Ol^DBko00<[04Co7aooCSi>ofnO
Kom^?Vko<23oKjm_o`<>0olPH23oe/KomYKfof/2Jonok[ooIP;o0`83oh5>POnOGolSGb?o2<08o`/0
000:0003ol2`00;o00O0/?lO8aoo00=O01OoCW5>o`:_omH2e_n_5ZooZ`:[o`;Vo`03eP0Dob1P8?l>
0`ko[goo830Pobi^;_l3W`04ohi>o`<O00Wo:b/[oa4^4Ol00]003?o^[nkom@oeokmVo`=@00coX>2P
o`j`3_l3e_l3C009ooAnm?nOGioo00;O00?o00004@001?n`ool3g`08oimOWoodO_l3C00<o`?F0ol>
/0koX>3o0e003?noI[oom@oeonj_o`?@00Go4BhAo`03:`08oalOohi>S_l3W`0Dobi^;_lP<?n_Ojoo
3P<>ob1P8?l2eP0Ho`;V0_n[0Z_o[aJ_omH2o`:_0_m>LDko0Ul02OlS7b?o`;30o`0;00002P1loa<0
O?l;00002P000olS7`02o`0;8aoo/<2`odiaC_l00el04?l2e_n_0ZooZ`:[ojlF[ol2eP0DonH2i_l>
0`ko860Poc0Pogn_Ool3W`05obi^;_l00Ql02Om>STko4BhAo`03:`04ojo^o`?@00co_fJoooD?oj3P
X?l3D00<o`?F0ol>/?odO_Co0d`02?oOgmooWeoo4`001?lOool3g`0bomoOgoodO_mnm7ko0mH3o`?F
0onPh?oPX>3o_fJookmV_oo^[on_kZoo4BhAoa4^4Ol27`05oalO7ol00il05?nOWioo833o<20`o`h3
3_l>0`ko0]H08ooFe]KoZ`:[oj/2ZooF0_l2eP;oCW5>odiaob<O8olS7b?o00/0000:0003ob=O00;o
03`SGoo02<3oPDj1oimOWol2I_l20`;oJ`9[oko^_oo6e_nFmYKo0`h3ob1P8?lP<?n_KjooKim_ofhn
K_l27`09oci>?_l^DBko00<[00Cokjoo0m006ooV_nKo3lkoh:3Poe2@D?l?0`oo3_7oOW5no`03C008
omoOgonOGolC0004oeooo`?O03;ogmoOogiaog5nLOl?0`oo3`<?on2Poj3PX?oV_nKoi[oVojo_onn_
kol^DBko;U4^o`8O047o7alOofnOKom_Wfoo<23o830Po`<>0ol33P?oe/Koa]K6of/2Jom[0V_oIP;o
0VH2oh5>POn1C_lSGb?o8elSo`0;00002P1loa<0O?l;00002P000omOW`02o`0lGiooPDj1ol08`?mO
8eook[ooJ`9[o`830_mV0VKoH23o0`h3oiKfU_oFa]Ko?VkoKim_ojm_[ol`833o0R/02Ol^DBko?Thn
o`037`08olh?onJoi_l3d00Gojo_o`ka3_l?0`ooD91@on2PoimOWol00ml02?m<C4coOW7o4`001?nO
ool3g`05oimOWol00]l09omOWeoo3`<?o`ka3_l?0ooa3_7oi[oVo`o>3ooV_oo>3lko;U4^o`03:`04
obiAo`<[03goKim_ofhnK_m_WolnKSko0`h3ob1P8?l33_mP863oJ`9[oko^_om[0_o^_nkoPDj1oimO
odj1C_mOWeoo00/0000:0003oemO00;o0Ul09om>LDko/<2`oalS7olF[on[0Z_o[`:_omH2e_mP8?l>
0`koiP;Vo`03eP04ofh^o`>O00WoOjmoob0`8?l00R/02OlA;Q7oCXi>o`037`08o`oeokmV_ol3d00<
onj_o`j`3_l3eP?o0e002?nPh?nOGioo0ml02?m<C4com7ko4`001?mOool3g`05oimOWol00]l09omO
Weoo0mH3o`j`3_l3e_n`3[3o_fJoooD?mOnoI_l?m@oo4BhAo`03:`04oa4^o`<[00WoWinOobi^;_l0
0Yl09om^;Vko3P<>ob1P8?l>0omP863oZ`:[ojlF[on[0_lF[aKoCW5>o`02G`05og5>LOl00el00ol0
000900002P000omOW`02o`0lGiooPDj1ol08`?mO8eook[ooJ`9[o`830_mV0VKoH23o0`h3oiKfU_oF
a]Ko?VkoKim_ojm_[ol`833o0R/02Ol^DBko?Thno`037`08olh?onJoi_l3d00Gojo_o`ka3_l?0`oo
D91@on2PoimOWol00ml02?m<C4coOW7o4`001?nOool3g`05oimOWol00]l09omOWeoo3`<?o`ka3_l?
0ooa3_7oi[oVo`o>3ooV_oo>3lko;U4^o`03:`04obiAo`<[03goKim_ofhnK_m_WolnKSko0`h3ob1P
8?l33_mP863oJ`9[oko^_om[0_o^_nkoPDj1oimOodj1C_mOWeoo00/0000:07co4`1lo`/0000:0003
odj100;o03m>POnOGiooGb=Ool08`?l2Jonok[ooIP9Vo`830_l>0olPH23oe/KFoiKfU_nOKom^?Vko
<20`ojm_[omA;_l00b/05?lO7aoo?ThnokoVo`o>3on_kjoo0]004?l?0`oo3_4>on2Ph?m@T?l3g`09
oimOWomnLGko009<00?o00004@001?n1ool3g`05omoOgol00]l0K_oOgmoo3`<?o`l33ol?0ol33`?o
i[oVonJoi_oV_onoi[oo;U4^obiA;_l^DOmA;U7oKim_ofnOKom_WonOKioo0`h3o`<>0ol33_l>0`ko
J`9[of/2Jom[0_l2J`;oPDj1oh5>odj1C_m>PDko2`0000X000?oLDh00_l00g5>o`03G`0OoalS7on`
`;3o0Z_o[aJ_omH2e_n_0Zoo0`ko860Po`03eP05onH2i_l00Yl04?l^KRko830Pogn_Ool^4Ol3:`0D
oalO7om>STkoI[oom@oeonj_k_l2d00=o`?F0ol>/0koX>2Po`02D00=omoOgonOGioom7kdo`02C003
o`00014000CoC_oo0ml01OoOgmoo00;O03;ogmoOo`?F0ol3eP?o0mKoeP?FokmV_onoI[oo_fKoI[mV
oa4^4OlA;Q7o4Bko;Q4^o`>O00GoWinOo`02W`0boinOWol>0`ko3P<>o`h3o`<>0on[0Z_oZ`:[oj/2
o`:[0_m>LDkoCW7oLDiaog5>LOl;00002P000om>P@02o`0oCX7oWenOoelSGoo02<3o0V_o_njoofH2
I_l20`;o3P?o860PomK6e_nFmYKoWfooKSi^oc0P<?n_KjooDBko00<[01Co7alOoci>?_noi_l?cPoo
[nn_o`;@013o3`<?o`ka3_oPX>3oD93o0ml02OnOGiooOW5no`02C003o`00014000CoPOoo0ml01OoO
gmoo00;O06kogmoOo`l33ol?0`oo3`?o0`l3onJoi_oV_nKoi[oo_nJoobiA;_l^DBko;U7oDBiAofnO
Kom_WfooKiooWfnOo`<>0ol33P?o0`ko3P<>of/2Jom[0V_oJ`;o0V/2oh5>POn1C_m>PDkoCX5>o`/0
000:07co4`1lo`/0000:0003o`8300;o03`20ol2IP;ok[o^o`9[0_o02?lSGb?oGimOodj1C_n_KolP
<23o?Vhnoim_WonFm_o6e/KoH21Po`h33_l2d00@onn_koo>3lko_nJooci>o`<O00So:b/[oe4^o`=<
00WoLGiaoenOGol00]l04?n@D93oX>2Poo4>lOl33olC0004o`?oo`?O00SoWenOogiao`=<00cogmoO
oenOGomaO_l3C00<onJoi_l?cPoo[noo0m003?noi[oocPo>onn_o`?@03goKim_ofhnK_l`8?m_[foo
WfnOoci^?_lP<?n_KjooJ`9[oko^_omV0_l30P?o0V/2onjoofH2I_l20`;o00/0000:0003ojl200;o
01J_0_l2eP;o5ZlFo`:[0_n``?lS7b?o0el04?maCW7oOjoo<20`ofh^K_l3W`04onH2o`?F00WoH21P
o`<>0ol00]004?n_kZoo3oD?ofJoI_m>S_l37`08ob/[:ol^4Ol3C009ogkdO_mOWeoo00;O013oD51@
on2Ph?n`3[3oeP?o4`001?l2ool3g`08oimOWoodO_l3C00<omoOgomOWeooO_Co0d`03?noI[oom@oe
onj_o`?@00coI[mVo`oe3on_k_l3d00@oinOWol^KRko833o[gn_o`>O02[oKRi^oc0Pogn_Oon[0Z_o
[aJ_omH2o`:_0_l2Z`;o5ZooeP;Fojl2[ol;00002P1loa<0O?l;00002P000ooF0P02o`0JeP;o0Zl2
o`:[0_lF[aKo7b?o`;30og5>LOl3G`08ob0`ojmo[ol3W`05ofh^K_l00]H04?l2iP;o0`h3of0PH?o^
[ol3d009ofJoI_l?m@oo008O00WoSTj>obhA;_l00R/01Omnm7ko00=<00cogmoOoenOon2Ph?l3D008
omH3e_n`3_lC0004o`;oo`?O00cogmoOooAnogkdO_l3g`0ZomoOgomnm?odO_Co_fJookmV_oo^[on_
kZooI[mVofJoI_n_k_o^[nko0il03?nOWioo833o<20`o`>O02[oWinOoc0Pob0`8?n[0Z_oZ`:[omH2
o`;F0_l2Z`;o0Z_oeP;FomH2e_l;00002P000omV0P02o`0oIP;o0`83o`9[0_o^_nkoGb?o2<08odj1
C_mOWeoo<23oKjm_oim_WolnKSkoe/KomYKfo`h33_mP863o[noo00?@00Wo_nJoolh?c_l00Ql02Om>
?TkoDBiAo`02:`05og5nLOl00d`05ooOgmooGiooX>2Poi1@T?l33`?ol@ko01<000Co0_oo0ml03?oO
gmooOW7oLGiao`?O06KogmoOog5nogiaO_oV_nKoi[oVojo_onn_konoi[oo_nJoonn_ojo_[om_Wfoo
Kim_oc0Pob0`8?nOKiooWfnOob0`oc0P<?m[0V_oJ`9[ofH2o`9V0_l2J`;o0V_oIP9VofH2I_l;0000
2P000ooF0P02o`0JeP;o0Zl2o`:[0_lF[aKo7b?o`;30og5>LOl3G`08ob0`ojmo[ol3W`05ofh^K_l0
0]H04?l2iP;o0`h3of0PH?o^[ol3d009ofJoI_l?m@oo008O00WoSTj>obhA;_l00R/01Omnm7ko00=<
00cogmoOoenOon2Ph?l3D008omH3e_n`3_lC0004o`;oo`?O00cogmoOooAnogkdO_l3g`0ZomoOgomn
m?odO_Co_fJookmV_oo^[on_kZooI[mVofJoI_n_k_o^[nko0il03?nOWioo833o<20`o`>O02[oWinO
oc0Pob0`8?n[0Z_oZ`:[omH2o`;F0_l2Z`;o0Z_oeP;FomH2e_l;00002P1loa<0O?l;00002P000on_
5P02o`0?[aKo0Z/2o`:_0_l2eP;o009O013oLDiaol2``?lS7b?o;Vko0il05?n_Ojoo<20`ob1Po`<>
0ol2iP;o0mH02?oe3omV_fKo0m001On_kZoo008[00Wo;Q4^ohi>S_l00Ql01OmOWeoo00?O013oC4a<
ogkdok0>/?oF0mKo0e001?oPX?lC0004oaKoo`?O00GoWenOo`02g`05oenOGol00ml01OmOWeoo00;O
02?oWenOokmV_ooe3oGo_fKo3oD?ofJoI_l?m@ooI[oom@oeo`03W`05obi^;_l00Yl01Om^;Vko00>O
00GoKRi^o`02W`0Sobi^;_n[0Z_o[aJ_oj/2oaJ_5_l2Z`;o5ZooZ`:[ojlF[ol02`0000X000?o_nh0
0_l0@ko^o`9[0_l30P?o0VH2oimOodj1C_l8`0So8elSofhnoim_Wom_[foo830Pob1Po`h33_ofU_Ko
a]K6o`o>okoV_ol00m001Oo_[noo008[00WoDBiAodhnC_l00Ql01OmOWeoo00?O01OoC4a<og5noo4>
lOl33`?oT52@oj3Po`0C0004onkoo`?O00GoWenOo`02g`05oenOGol00ml01OmOWeoo00;O05ooWenO
onJoi_l?cPooi[oocPo>okoV_oo>3lko_nKo3lh?ofnOKom^?VkoKioo?Vhnoim_WolnKSkoWfooKSi^
of/2Jonok[ooJ`;ok[o^o`9[0_o^_om[0V_o_njoo`0;00002P000on_5P02o`0?[aKo0Z/2o`:_0_l2
eP;o009O013oLDiaol2``?lS7b?o;Vko0il05?n_Ojoo<20`ob1Po`<>0ol2iP;o0mH02?oe3omV_fKo
0m001On_kZoo008[00Wo;Q4^ohi>S_l00Ql01OmOWeoo00?O013oC4a<ogkdok0>/?oF0mKo0e001?oP
X?lC0004oaKoo`?O00GoWenOo`02g`05oenOGol00ml01OmOWeoo00;O02?oWenOokmV_ooe3oGo_fKo
3oD?ofJoI_l?m@ooI[oom@oeo`03W`05obi^;_l00Yl01Om^;Vko00>O00GoKRi^o`02W`0Sobi^;_n[
0Z_o[aJ_oj/2oaJ_5_l2Z`;o5ZooZ`:[ojlF[ol02`0000X0O?lC07co2`0000X000?oZ`800_l04Z/2
oaJ_5_l2eP;o0Zl2odiao`=O00Wo8alSol2``?l00Yl05?m^;Vko<20`ojmo[ol>0omP863o0mH04?l2
iP;o_fKo3oD?ojo^[ol3d004oa4^o`<[00So7alOohi>o`?O00WoGimOogkdO_l00T`03OoF0mKo/0j`
on2Ph?l00U000ol0000A0004o`;oo`?O00GogmoOo`02g`05omoOgol00ml01OoOgmoo00;O02?ogmoO
okmV_onoI[oo_fKoI[mVofJoI_mV_fKoI[oo_fJoo`03W`05oinOWol00Yl01OnOWioo00>O00GoWinO
o`02W`0SoinOWon[0Z_oZ`:[oj/2o`:[0_l2Z`;o0Z_oZ`:[oj/2Zol02`0000X000?oJ`800_l0Af/2
onjok_l2IP;o0`83oh5>oenOGolSGb?o2<08ofnOoci^?_lP<23oKjm_o`<>of0PH?o6e/KomYKfonJo
olh?c_o_[noo00?@00Co;U7o0b/02?lO7aooCSko0ml02OmOWeooLGiao`02C00@o`<?0ooa3_7oX>2P
oi1@oa<000Co0_oo0ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l0GooOgmooi[oVonJoi_oV
_onoi[oo_nJookoV_onoi_oV_nKoKim_ofnOKom_WonOKiooWfnOoim_WonOKom_WfooJ`9[of/2Jom[
0_l2J`;o0V/2o`9[of/2Jom[0V_o00/0000:0003oj/200;o01:[0_lF[aKo0]H2o`:_0_m>LOl3G`09
ob<O8oo0/<3o00:O01CoKRi^oc0P<?n_Ojoo3P?oH21Po`?F013o0^H2okmVo`oe3on_kZoo0m001?lA
;_l3:`08oalO7on>C_l3g`09oenOGomnm7ko009<00goeP?Fok0>/?oPX>3o009@00?o00004@001?l2
ool3g`05omoOgol00]l01OoOgmoo00?O00GogmoOo`02g`0SomoOgonoI[oo_fJookmVofJoI_mV_fKo
I[mVofJookmV_ol00il01OnOWioo00:O00GoWinOo`03W`05oinOWol00Yl08onOWiooZ`:[oj/2Zon[
0_l2Z`;o0Z/2o`:[oj/2Zon[0Z_o00/0000:07co4`1lo`/0000:0003o`;V00;o00<2i_l00mH05?lP
H23o3P<>ojmoob0`8?l^KRko0il02?o0/?lO8aoo0el05?m>LDko0ZooeP;FojlF[on[0Z_o0U003OnP
h:3o3[0>o`?F0ol00T`02OodO_CoWenOo`02g`05odj>C_l00al02?l[:b_o4Bko0m003?o^[nkom@oe
okmVoa<000Coi_oo0ml02?nOGioom7ko0d`03?l3eP?o3[0>oj3Po`=@00cogmoOoimOWoodO_l3C00<
o`?F0ol>/0koX>3o0e006?nOWioo;Vh^ob0`ojmo[ol>0`ko860Po`;F00Go0^H2o`03W`0Cobi^;_lP
<?n_Ojoo3P<>ob1Po`03eP05o`;V0_l02`0000X000?omYH00_l0BoJFomK6e_lPH23o0`h3ofn_oc0P
<?m^?VkoKim_o`S0oelSGonOGiooPDj1o`<2ofH2I_nok[ooJ`9[oi1@on2Ph?l>l@ko3`<?o`02C009
ogiaO_nOGioo00;O00Go?Thno`037`08ob/[:ol^DOl3d00<ojo_[ol?cPooi[oo4`001?nFool3g`08
oimOWomnLOl3C00@o`l33ol>l@koh:3oT52@o`?O00SoWenOogiao`=<04co3`<?o`ka3_oPX?n@D93o
Kim_ofhnK_l`8?m_[foo0`h3ob1P8?oFa_ofU_KoKim_ofhnK_l`8?m_[foo0`h3ob1PolKFa_ofU_Ko
2`0000X0O?lC07co2`0000X000?oa]H00_l0C/KFoiKfU_l33P?o860Pob0`ojm_[om_WfooKSi^ob=O
ol08`?n1CX7oWenOo`9Vo`830_m[0V_o_njooj3Poe2@D?l?0`oo3_4>og5no`=<00SogmoOoimOo`<O
00Wo?ThnobiA;_l00R/01On_kjoo00?@00Soi[oVo`o>oa<000Coe_oo0ml06ooOgmooOW7oLGiao`l3
3ol?0`ooh:3oX>2Po`03g`1GomoOgomnLOmaOW7o3`<?o`l33ooPX?nPh:3oKim_ofnOKol`8?lP<23o
0`h3o`<>0ooFa_o6e/KoKim_ofnOKol`8?lP<23o0`h3o`<>olKFa_o6e/Ko00/0000:0003omKF00;o
0]H05?oV0^Ko3P<>ob1P8?l`8?mo[goo0il04?l^KRko8aoo/<2`odiaC_l3G`0Co`;Fojl2[on[0Z_o
[aJ_on2Po`03D00<o`?F0ol>/0koO_Co0d`02?oOgmooWeoo0al02Om>STko4BhAo`02:`05onj_k_l0
0m002?noI[oom@oo4`001?oFool3g`0KomoOgoodO_mnm7ko0mH3o`?F0onPh?oPX>3o00?O01_ogmoO
ooAnogkdO_l3eP?o0mH3oj3Pon2Ph?l00il05?nOWioo833o<20`o`h33_l>0`ko0]H01OoFe]Ko00>O
01?oWinOob0`oc0P<?l>0`ko3P?o00?F00Goe]KFo`0;00002P000oo6eP02o`1>a]KoU_JFo`<>0olP
H23o833o[fn_ofnOKom^?Vko8eoo`0S0oh5>POnOGioo0VKo0P<2of/2Jonok[ooX>3oD91@o`l33ol>
l@koLGko0d`02?oOgmooWeoo0al02OlnCSko;U4^o`02:`05ojo_[ol00m002?oV_nKo3lko4`001?oF
ool3g`0KomoOgomnLOmaOW7o3`<?o`l33ooPX?nPh:3o00?O05OogmoOogiaog5nLOl?0`oo3`<?on2P
oj3PX?m_WfooKim_oc0Pob0`8?l33P?o0`h3omK6olKFa_m_WfooKim_oc0Pob0`8?l33P?o0`koa]K6
olKFa_l02`0000X0O?lC07co2`0000X000?oH2000_l0CV0Po`<>0onFmYKoe/KFoci^ofnOKon_Kjoo
<20`oenOoh5>POo02<3oGb=Oonjoof/2Jol20`;oIP9Voo4>o`l33om@T53oh:3PoenOo`?O00SoC4a<
ogiao`<[00Wo;U4^oci>?_l00Ql02Ol?cPooi[oVo`03d004ojo_oa<000Co8?oo0ml01OnOGioo00;O
01CoGimOo`l33ol>l@ko3`?ol@kao`?O00GoWenOo`02g`1@oenOGol?0`oo3_4>o`l3oo4>lOm_Wfoo
KSi^ofnOoci^?_l33P?o860Po`<>of0PH?m_WfooKSi^ofnOoci^?_l33P?o863o3P<>of0PH?l;0000
2P000omP8002o`0;H23o3P<>onH2i_l00mH01?m^;_l3W`09ogn_OolP<23o009O02?oCW5>ok30/?lO
8aoo5ZooZ`:[ojl2[ooF0]Ko/0ko0mH3o`03D008oj3PX?mOWol3g`08oda<C?odO_l3:`09oa4^4Om>
STko008O00Wom@oeokmV_ol00m001?o^[olC0004ob3oo`?O00GoWenOo`02g`0DoenOGol3eP?o3[0>
o`?Fok0>/?l3g`05oimOWol00]l05?mOWeoo0mH3o`j`3_l3e_n`3[3o0il01Ol^KRko00:O01CoKRi^
o`h33_lPH23o3P?oH21Po`>O00Go;Vh^o`02W`0Dofh^K_l>0`ko863o0`h3of0PH?l;00002P000omP
8002o`1>H23o0`h3oiKfU_oFa]Ko?VkoKim_ojm_[ol`833oGiooPDj1ol08`?mO8eook[ooJ`9[o`83
0_mV0VKol@ko3`<?oe2@D?oPX>3oGioo0ml02?m<C4coOW7o0b/02Ol^DBko?Thno`027`09o`o>3ooV
_nKo00?@00Co[noo4`001?lPool3g`05oimOWol00]l05?mOWeoo3`<?o`ka3_l?0ooa3_7o0ml01OnO
Gioo00;O053oGimOo`l33ol>l@ko3`?ol@kaofnOKom^?VkoKioo?Vhno`<>0olPH23o0`koH21PofnO
Kom^?VkoKioo?Vhno`<>0olPH?l>0`koH21Po`/0000:07co4`1lo`/0000:0003o`h300;o04/>0olP
H23oe/KFoiKfU_nOKom^?Vko<20`ojm_[om>POnOGiooGb=Ool08`?l2Jonok[ooIP9Vo`830_l33ol>
l@koh:3Poe2@D?l00]l02OnOGiooOW5no`02C005obiA;_l00b/05?lO7aoo?Tkoi[oVo`o>3on_kjoo
0]000ol0000A0004o`?oo`?O00GogmoOo`02g`0DomoOgol?0`oo3`<?o`l3o`<?0ol3g`05omoOgol0
0]l0D?oOgmoo3`<?o`l33ol?0ol33`?oKim_ofnOKom_WonOKioo0`h3o`<>0ol33_l>0`koKim_ofnO
Kom_WonOKioo0`h3o`<>o`h33_l>0`ko2`0000X000?o0`h00_l01`<>ob1P8?l00mH01OoV0^Ko00:O
013o;Vh^ob0`8?mo[gooLDko0el08olO8aoo/<2`o`:[ojlF[ooF0]Ko[`:_omH3o`j`3_nPh:3o00=@
00cogmooWenOooAnm?l2C005oa4^4Ol00b/05?lO7aooCXko_fJoooD?mOo^[nko0]000ol0000A0004
o`koo`?O00GogmoOo`02g`0DomoOgol3eP?o0mH3o`?FomH3e_l3g`05omoOgol00]l05?oOgmoo0mH3
o`?F0ol3e_oF0mKo0il01OnOWioo00:O01CoWinOo`h33_l>0`ko3P?o0`h3o`>O00GoWinOo`02W`0D
oinOWol>0`ko3P?o0`h3o`<>0ol;00002P000ol>0`02o`1;3P?o860PomK6e_nFmYKoWfooKSi^oc0P
<?n_KjooCX7oWenOoelSGoo02<3o0V_o_njoofH2I_l20`;o0`oo3_4>on2Ph?m@T53o00;O00WoWenO
ogiaO_l00T`01Ol^DBko00<[01Co7alOoci>onJoi_l?cPoo[nn_o`;@00?o00004@001?l3ool3g`05
omoOgol00]l05?oOgmoo3`<?o`l33ol?0ol33`?o0ml01OoOgmoo00;O053ogmoOo`l33ol?0`oo3`?o
0`l3ofnOKom_WfooKiooWfnOo`<>0ol33P?o0`ko3P<>ofnOKom_WfooKiooWfnOo`<>0ol33_l>0`ko
3P<>o`/0000:07co4`1lo`/0000:0003ojm_00;o03b_KolP<23o?Vhnoim_WonFm_o6e/KoH21Po`h3
3_l20ol2IP;ok[o^o`9[0_o02?lSGb?oGimOodj1C_l2C009og5nLOmOWeoo00?O00ooD93oX>2Poo4>
lOl33ol00m004?o_[noocPo>okoVodhnC_l37`08ob/[:omA;_lC0004ofooo`?O00SoWenOogiao`=<
00cogmoOoenOGomaO_l3C00<omoOgonOGiooOW7o0d`03?oOgmooGimOog5no`=<03goKim_ofhnK_l`
8?m_[fooWfnOoci^?_lP<?n_KjooKim_ofhnK_l`8?m_[fooWfnOoci^oc0P<?n_Kjoo00/0000:0003
ogn_00;o00]o[ol`833oKRi^o`03W`04onH2o`?F01ooH21Po`<>0on_0_l2eP;o5ZlFo`:[0_n``?lS
7b?o00=O00GoLDiao`02C009ogkdO_mOWeoo00?O00ooD53oh:3Pok0>/?oF0ol00m004?n_kZoo3oD?
ofJoohi>S_l37`08ob/[:ol^4OlC0004ojooo`?O00SoWenOooAno`=<00cogmoOoenOGomnm?l3C00<
omoOgonOGioom7ko0d`03?oOgmooGimOogkdo`=<013oWinOobi^;_lP<?n_Ojoo0il03?m^;Vko<23o
Ojmoo`>O00co;Vh^ob0`ojmo[ol3W`0<ofh^ob0`8?mo[goo2`0000X0O?lC07co2`0000X000?o8300
0_l01b0`ojmo[ol00il01Om^;Vko00;F02Oo0^H2o`<>0omP863oeP;o0Zl2o`:[0_lF[aKo7b?o`;30
og5>LOl00el01?odO_l3C00<omoOgomOWeooX>3o0e003?oF0mKo/0ko[nj_o`?@00SoI[mVo`oeo`<O
00WoSTj>obhA;_l00R/00ol0000A0004oc3oo`?O00cogmoOooAnogkdO_l3g`0<omoOgomnm?odO_Co
0ml03?oOgmoom7koO_Ano`?O00cogmoOogkdooAnm?l3W`0<oinOWolP<?l`833o0il03?nOWioo<23o
830Po`>O00coWinOob0`oc0P<?l3W`0<oinOob0`8?lP<23o2`0000X000?o<2000_l0?c0Pofn_KonO
Kioo?VhnomK6ooJFm_l>0`koH21PofH2o`<20ol2J`;ok[o^oelSo`S02?m>PDkoGimOogiao`03C00K
omoOgomOWeooh:3oT52@o`<?0ooa3_o_[noo00?@00So_nJoolh?o`<O00WoCSi>oe4^DOl00R/00ol0
000A0004ob3oo`?O00cogmoOogiaog5nLOl3g`0<omoOgomaO_mnLGko0ml03?oOgmooOW7oLGiao`?O
04SogmoOog5nogiaO_m_WfooKim_oc0Pob0`8?nOKiooWfnOob0`oc0P<?m_WfooKim_oc0Pob0`8?nO
KiooWfoo<20`oc0P<?l;00002P000olP<002o`07833o[gn_o`03W`05ofh^K_l00]H09ol2iP;o0`h3
of0PH?oF0_l2[`;o0Z/2oaJ_5_lO8oo0/<3oLDiao`03G`04ooAno`=<00cogmoOoenOGonPh?l3D00<
omH3e_n`3_n_kZoo0m002?mV_fKo3oGo0al02On>CXko;Q4^o`02:`03o`00014000Co<?oo0ml03?oO
gmoom7koO_Ano`?O00cogmoOogkdooAnm?l3g`0<omoOgoodO_mnm7ko0ml03?oOgmooO_Com7kdo`>O
00coWinOob0`oc0P<?l3W`0<oinOWol`8?lP<23o0il03?nOWioo833o<20`o`>O00coWioo830Pob0`
8?l;00002P1loa<0O?l;00002P000ol^KP02o`03;Vko00>O01Co[gn_oc0P<?lPH?l33P?o0^H2o`?F
013o[aKo0Z/2o`:_0_l2eP;o0Ul04?maCW7o`;30ob<O8onOGol3g`0@oda<C?mnm7ko3[3oeP?Fo`=@
00coh:3o3oD?ofJoI_l3d004ojo^o`<[00Wo;Q4^ohi>S_l00Ql00ol0000A0004ofkoo`?O00GoWenO
o`02g`05oenOGol00ml01OmOWeoo00;O00GoWenOo`03g`05oimOWol00]l01OmOWeoo00?O00GoGimO
o`02g`05oimOWol00il01Ol^KRko00:O00GoKRi^o`03W`05ofh^K_l00Yl01Ol^KRko00>O00Go;Vh^
o`02W`05ofh^K_l00il01?m^;_l3W`05obi^;_l02`0000X000?oKSh00_l0?fhnoim_Wom_[foo830P
ob1Po`h33_ofU_Koa]K6oko^o`9[0_l30P?o0VH2oimOodj1C_l8`0So8elSoimOo`03g`0Ooda<C?ma
OW7o3_7o0`l3oi1@T?nPh?o>3lko_nJoo`03d004onn_o`<[00WoDBiAodhnC_l00Ql00ol0000A0004
ockoo`?O00GoWenOo`02g`05oenOGol00ml01OmOWeoo00;O00GoWenOo`03g`05oimOWol00]l01OmO
Weoo00?O00GoGimOo`02g`11oimOWom_WfooKSi^ofnOoci^?_nOKioo?Vhnoim_ofhnK_m_WfooKSi^
ofnOoci^?_nOKioo?VkoKim_ofhnK_l02`0000X000?o;Vh00_l00bi^o`03W`0Dojmo[ol`833o863o
0`h3o`;V0_l3eP0@ojlFo`:[0_l2[`;o0]H2o`9O013oLDiaol2``?lS7b?oWeoo0ml04?m<C4coO_An
o`j`omH3e_l3D00<on2Po`oe3omV_fKo0m001?n_k_l3:`09obhA;_n>CXko008O00?o00004@001?m^
ool3g`05oimOWol00]l01OmOWeoo00?O00GoGimOo`02g`05oimOWol00ml01OnOGioo00;O00GoGimO
o`03g`05oenOGol00]l01OnOGioo00>O00Go;Vh^o`02W`05ofh^K_l00il01Om^;Vko00:O00Go;Vh^
o`03W`05obi^;_l00Yl01Om^;Vko00>O00CoKRko0il01Ol^KRko00/0000:07co4`1lo`/0000:0003
oinO00;o0Yl05?m^;Vko<20`ojmo[ol>0omP863o0mH05ol2iP;oZ`;o5ZlFo`;F0_l2[`;oCW7o00=O
00Wo8alSol2``?l00]l02OmOWeooO_Ano`03C00<o`?Fok0>/?oPX>3o0U003OmV_fKo3oD?ojo^[ol0
0]001Ol^4Bko00<[00So7alOohi>oa<000CoWooo0ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol0
0]l01OoOgmoo00?O00GogmoOo`02g`05omoOgol00ml01OoOgmoo00;O00GogmoOo`03W`05oinOWol0
0Yl01OnOWioo00>O00GoWinOo`02W`05oinOWol00il01OnOWioo00:O00GoWinOo`03W`04oinOo`>O
00GoWinOo`0;00002P000om_W`02o`0lKioo?Vhnob0`8?m_[foo0`koH21PolKFa_ofU_KoJ`;ok[o^
o`9V0_l30P?oPDkoGimOob=O8ol8`0So0]l02OmOWeooLGiao`03C00Ko`l3oo4>lOnPh:3oT53o_nJo
olh?c_o_[noo00;@00GoDBiAo`03:`08oalO7om>?_lC0004oiooo`?O00GogmoOo`02g`05omoOgol0
0ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l01OoOgmoo00?O00GogmoOo`02g`11omoOgom_
WfooKim_ofnOoim_WonOKiooWfnOoim_ofnOKom_WfooKim_ofnOoim_WonOKiooWfooKim_ofnOKol0
2`0000X000?oWil00_l2W`0Dofh^K_l`833o[gn_o`h3of0PH?l3eP0Go`;V0_n[0_lF[aKo0]H2o`:_
0_m>LOl00el02OlS7b?o`;30o`02g`09oenOGomnm7ko00=<00co0mKo/0j`on2Ph?l2D00=ofJoI_l?
m@oo[nj_o`02d005obhA;_l00b/02?lO7aooSTko4`001?nOool3g`05omoOgol00]l01OoOgmoo00?O
00GogmoOo`02g`05omoOgol00ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l01OoOgmoo00>O
00GoWinOo`02W`05oinOWol00il01OnOWioo00:O00GoWinOo`03W`05oinOWol00Yl01OnOWioo00>O
00CoWioo0il01OnOWioo00/0000:07co4`1lo`/0000:0003ohi>00;o00>>C_l00al02Ol[:b_o4BhA
o`02d00=onj_k_oe3oGo_fJoo`02D00=oj3PX?l>/0ko0mH3o`02C009ooAnm?nOGioo00?O00So`;3o
7b<Oo`=O01OoCW5>o`:_omH2e_n_5ZooZ`;oiP;Vo`03eP0Dob1P8?l>0omo[goo830Pobi^;_l2W`03
o`00014000CoC_oo0ml02?nOGioom7ko0d`03?l3eP?o3[0>oj3Po`=@00co_fJoooD?mOo^[ol3d005
oa4^4Ol00b/02?lO7on>CXko0ml02?nOGioom7ko0d`03?l3eP?o3[0>oj3Po`=@00co_fJoooD?mOo^
[ol3d005oa4^4Ol00R/02OlO7aooSTj>o`0;00002P000om>?P02o`03CSko00<O00Wo:b/[obiA;_l0
0]007?n_kjoo3lh?onJoi_n@D?oPX>3o3_4>o`l33ol2C009ogiaO_nOGioo00?O03co2<3oGb=OoimO
Won1CX7o0`;oIP9Voko^_om[0_nFmYKoe/KFob1P8?l33_n_Kjoo<20`ofhnK_m_WolC0004ockoo`?O
00SoWenOogiao`=<01_o3`<?o`ka3_oPX?n@D93oi[oVo`o>3on_kol00m001Ol^DBko00<[00So7aoo
CSi>o`?O00SoWenOogiao`=<01_o3`<?o`ka3_oPX?n@D93oi[oVo`o>3on_kol00m001Ol^DBko008[
00Wo7alOodhnC_l02`0000X0O?lC07co2`0000X000?o7al00_l27`09oci>?_l^DBko00<[00Cokjoo
0m006ooV_nKo3lh?oj3Poe2@D?l?0`oo3_4>og5no`03C014omoOgonOGioo8eoo`0S0oh5>POnOGioo
0VKo0P<2of/2Jonok_oFa]KoU_JFo`<>0olPH?l`833o[fn_ofnOKom^?_lC0004oaooo`?O03;ogmoO
ogiaog5nLOl?0`oo3`<?on2Poj3PX?oV_nKoi[oVojo_onn_kol^DBko;U4^o`8O00Go7alOo`03g`0a
omoOgomnLOmaOW7o3`<?o`l33ooPX?nPh:3oi[oVonJoi_n_koo_[noo;U4^obiAo`037`05oalO7ol0
2`0000X000?o7al00_l27`09odj>C_lA;Q7o00<[00Co[nko0m003?noI[oom@oeon2Po`=@00co0mH3
o`j`3_mnm?l3C00DomoOgonOGioo8aoo/<2`odiaC_l3G`0?o`;Fojl2[on[0Z_o[aKo00?F01CoiP;V
o`h33_lPH?lP<23oOjmoo`>O00Co;Vko4`001?lOool3g`0bomoOgoodO_mnm7ko0mH3o`?F0onPh?oP
X>3o_fJookmV_oo^[on_kZoo4BhAoa4^4Ol27`05oalO7ol00ml0<OoOgmoom7koO_Ano`?F0ol3eP?o
X>3oh:3PokmV_onoI[ookZoo[nj_oa4^4OlA;_l00al01OlO7aoo00/0000:0003oalO00;o0Ql02Oln
CSko;U4^o`03:`04onn_o`?@01_oi[oVo`o>3onPh?m@T53o3`<?o`ka3_maO_l00d`0A?oOgmooWenO
ob=Ool08`?n1CX7oWenOo`9Vo`830_m[0V_o_nkoe/KFoiKfU_l33P?o863o<20`ojm_[om_WfooKSko
4`001?lOool3g`0bomoOgomnLOmaOW7o3`<?o`l33ooPX?nPh:3oi[oVonJoi_n_koo_[noo;U4^obiA
;_l27`05oalO7ol00ml0<OoOgmooOW7oLGiao`l33ol?0`ooh:3oX>2PonJoi_oV_nKo[nookjo_obiA
;_l^DOl00al01OlO7aoo00/0000:07co4`1lo`/0000:0003ob/[00;o0R/02Ol^DBko?Thno`037`08
olh?onJoi_l3d00Gojo_[ooa3_l?0`ooD91@on2Ph?mOWol00ml0A?m<C4coOW5noenOoh5>POo02<3o
Gb=Oonjoof/2Jol20`;oIP;o860Po`<>0onFmYKoe/KoKSi^ofnOKon_Kjoo<23o4`001?l[ool3g`05
oimOWol00]l09omOWeoo3`<?o`ka3_l?0ooa3_7oi[oVo`o>3ooV_oo>3lko;U4^o`03:`04obiAo`<[
00WogmoOoimOWol00]l09omOWeoo3`<?o`ka3_l?0ooa3_7oi[oVo`o>3ooV_oo>3lko;U4^o`02:`05
oe4^DOl00b/00ol0000900002P000ol[:`02o`8[00Wo4BhAodj>C_l00al02?l?mOnoI[oo0m003?o^
[nko/0ko0mH3o`=@00SoX>2PoenOo`?O00WoC4a<ooAnm?l00Ul09om>LDko/<2`oalS7olF[on[0Z_o
[`:_omH2ob1P8?l>0`koiP;Vo`02eP05obi^;_l00il02?mo[goo833o4`001?l[ool3g`05oimOWol0
0]l09omOWeoo0mH3o`j`3_l3e_n`3[3o_fJoooD?mOnoI_l?m@oo4BhAo`03:`04oa4^o`<[00WogmoO
oimOWol00]l09omOWeoo0mH3o`j`3_l3e_n`3[3o_fJoooD?mOnoI_l?m@oo4BhAo`02:`05obhA;_l0
0b/00ol0000900002P000ol[:`02o`8[00Wo;U4^oci>?_l00al02?o>3ooV_nKo0m005on_kjool@ko
3`<?oe2@D?oPX>3oGioo00?O04CoC4a<ogiaO_mOWon1CX7o`0S0oelSGoo^_om[0V_o0P<2ofH2ob1P
8?l33P?oU_JFomK6ofhnK_m_Wfoo[fn_oc0Poa<000Co:ooo0ml01OnOGioo00;O02OoGimOo`l33ol>
l@ko3`?ol@kaonJoi_l?cPooi[oocPo>obiA;_l00b/01?l^DOl3:`09omoOgonOGioo00;O02OoGimO
o`l33ol>l@ko3`?ol@kaonJoi_l?cPooi[oocPo>obiA;_l00R/01OmA;U7o00<[00?o00002@0000X0
O?lC07co2`0000X000?oDBh00_l00e4^o`03:`0DoalO7olnCSko_nKo3lh?ojo_[ol3d00@o`<?o`ka
3_oPX>3oD91@o`;O00WoWenOogiaO_l00d`0??m>POnOGiooGb=Ool08`?l2Jonok[ooIP9Vo`83o`<>
0olPH23oe/KFoiKfofnOKom^?Vko<20`ojm_oa<000Co;_oo0ml01OoOgmoo00;O03;ogmoOo`l33ol?
0`oo3`?o0`l3onJoi_oV_nKoi[oo_nJoobiA;_l^DBko;U7oDBiAo`?O00GogmoOo`02g`0bomoOgol?
0`oo3`<?o`l3o`<?0ooV_nKoi[oVonJookoV_ol^DBko;U7oDBiAoe4^DOl;00002P000ol^4@02o`03
;Q7o00<[01Co7alOodj>C_mV_ooe3oGokZo^o`?@00coeP?o3[0>oj3PX?l3D00<omoOoimOWoodO_Co
0d`01?maC_l3G`0OoalS7on``;3o0Z_o[aJ_omH2e_n_0_l>0`ko860Po`03eP04onH2o`>O00co;Vh^
ob0`8?mo[olC0004oa7oo`?O00GogmoOo`02g`0bomoOgol3eP?o0mH3o`?FomH3e_noI[oo_fJookmV
ofJoI_lA;Q7o4BhAoa4^obhA;_l3g`05omoOgol00]l0<_oOgmoo0mH3o`?F0ol3e_oF0mKo_fJookmV
_onoI_mV_fKo4BhAoa4^obhA;_l^4Bko2`0000X000?oDBh00_l00e4^o`03:`0DoalO7olnCSko_nKo
3lh?ojo_[ol3d00@o`<?o`ka3_oPX>3oD91@o`;O00WoWenOogiaO_l00d`0??m>POnOGiooGb=Ool08
`?l2Jonok[ooIP9Vo`83o`<>0olPH23oe/KFoiKfofnOKom^?Vko<20`ojm_oa<000Co;_oo0ml01OoO
gmoo00;O03;ogmoOo`l33ol?0`oo3`?o0`l3onJoi_oV_nKoi[oo_nJoobiA;_l^DBko;U7oDBiAo`?O
00GogmoOo`02g`0bomoOgol?0`oo3`<?o`l3o`<?0ooV_nKoi[oVonJookoV_ol^DBko;U7oDBiAoe4^
DOl;00002P1loa<0O?l;00002P000oo@d002o`;@013okjo_olh?c_noi[oo?Tko0al02Ol[:b_oDBiA
o`02C009og5nLOmOWeoo00?O04_oD93oX>2Poo4>lOl33`?o0P?o0VH2onjok_l2J`;o`0So8elSoenO
Gom>POm_[foo830Poci^?_nOKoofU_Koa]K6of0PH?l>0ol04`001?o@ool3g`08oimOWomnLOl3C00<
omoOgomOWeooLGko0d`03?oV_nKo3lh?ojo_o`?@00co_nJoolh?c_o_[ol3d00<omoOgonOGiooOW7o
0d`03?oOgmooGimOog5no`=<00coi[oVo`o>3on_kol3d00<okoV_oo>3on_kjoo0m000ol000090000
2P000oo@d002o`;@013o[nj_o`oe3omV_fKoCXko0al02Ol[:b_o;Q4^o`02C009ogkdO_mOWeoo00?O
02KoD53oh:3Pok0>/?oF0mKo[`;o0]H2oaJ_5_l2Z`;o/<3o8alSo`=O013oLDko[gn_oc0P<?m^;Vko
0Yl01Ol2iP;o00?F00SoH21Po`<>oa<000Cod?oo0ml02?nOGioom7ko0d`03?oOgmooGimOogkdo`=<
00co_fJoooD?mOo^[ol3d00<ofJoI_l?m@oo[nko0m003?oOgmooWenOooAno`=<00cogmoOoenOGomn
m?l3C00<okmV_ooe3oGokZoo0m003?mV_fKo3oGokZo^o`?@00?o00002@0000X0O?lC07co2`0000X0
00?okZl00_l00nj_o`03d009ofJoI_l?m@oo008O00WoSTj>obhA;_l00b/01?odO_l3C00<omoOgomO
WeooX>3o0e008ooF0mKo/0j`omH2o`:_0_l2Z`;o5ZlFoalSol2``?maCW7o009O00Wo<20`ojmo[ol0
0il01?m^;_l3eP0<o`;V0_l33P?oH23o4`001?n_ool3g`0<omoOgoodO_mnm7ko0ml0:_oOgmooO_Co
m7kdokmV_onoI[ookZoo[nj_ofJoI_mV_fKo[nkokZo^o`?O00cogmoOooAnogkdO_l3g`0ZomoOgomn
m?odO_Co_fJookmV_oo^[on_kZooI[mVofJoonj_k_o^[nko2`0000X000?o[nl00_l00jo_o`03d009
okoV_oo>3lko008O00WoCSi>oe4^DOl00b/01?mnLOl3C01ComoOgomOWeooh:3oT52@o`<?0ooa3_7o
IP;o0`83o`9[0_o^_nkoGb?o2<08odj1C_mOWolP<23oKjm_oim_WolnK_o6e/KomYKfo`h33_mP8?l0
4`001?o_ool3g`0<omoOgomnLOmaOW7o0ml0:_oOgmooLGkoOW5nonJoi_oV_nKo[nookjo_okoV_ono
i[ookjoo[nn_o`?O00cogmoOogiaog5nLOl3g`0ZomoOgomaO_mnLGkoi[oVonJoi_n_koo_[noo_nJo
okoVojo_[on_kjoo2`0000X000?okZl00_l00nj_o`03d009ofJoI_l?m@oo008O00WoSTj>obhA;_l0
0b/01?odO_l3C00<omoOgomOWeooX>3o0e008ooF0mKo/0j`omH2o`:_0_l2Z`;o5ZlFoalSol2``?ma
CW7o009O00Wo<20`ojmo[ol00il01?m^;_l3eP0<o`;V0_l33P?oH23o4`001?n_ool3g`0<omoOgood
O_mnm7ko0ml0:_oOgmooO_Com7kdokmV_onoI[ookZoo[nj_ofJoI_mV_fKo[nkokZo^o`?O00cogmoO
ooAnogkdO_l3g`0ZomoOgomnm?odO_Co_fJookmV_oo^[on_kZooI[mVofJoonj_k_o^[nko2`0000X0
O?lC07co2`0000X000?om@l00_l01oD?ofJoI_l00m001On_kZoo008[00Wo;Q4^ohi>S_l00al01?nO
Gol3g`0@oda<C?mnm7ko3[3oeP?Fo`=@01Coh:3PojlFo`:[0_l2[`;o0]H2o`9O013oLDiaol2``?lS
7om^;Vko0il05?n_Ojoo<23oH21Po`<>0ol2iP;o0]H00ol0000A0004o`ooo`?O00GoWenOo`02g`05
oenOGol00ml01OmOWeoo00;O02?oWenOokmV_ooe3oGo_fKo3oD?ofJoI_l?m@ooI[oom@oeo`03g`05
oimOWol00]l01OmOWeoo00?O00GoGimOo`02g`0SoimOWonoI[oom@oeokmVo`oe3omV_fKo3oGo_fJo
ooD?mOl02`0000X000?o3lh00_l01`o>okoV_ol00m001Oo_[noo008[00WoDBiAodhnC_l00al01?nO
Gol3g`1Coda<C?maOW7o3_7o0`l3oi1@T?nPh:3o_nko0V/2o`<20ol2IP;oWeooCX5>o`S02?lSGoln
KSkoWfnOofn_KolP<?mP863o3P<>ooJFm_o6e_l04`001?o>ool3g`05oimOWol00]l01OmOWeoo00?O
00GoGimOo`02g`0SoimOWooV_nKo3lh?onJoolh?c_noi[oocPo>okoVo`o>3ol00ml01OnOGioo00;O
00GoGimOo`03g`05oenOGol00]l08onOGiooi[oVo`o>3ooV_oo>3lko_nJoolh?onJoi_l?cPoo00/0
000:0003ooD?00;o00Oe3omV_fKo00?@00Go[nj_o`02:`09obhA;_n>CXko00<O00CoWeoo0ml04?m<
C4coO_Ano`j`omH3e_l3D00Don2Ph?n_5_l2Z`;o0Zl2o`;F0_l2G`0@og5>LOo0/<3o8aooKRi^o`>O
01Co[gn_oc0Pof0PH?l33P?o0^H2o`;F00?o00004@001?l?ool3g`05oimOWol00]l01OmOWeoo00?O
00GoGimOo`02g`0SoimOWonoI[oom@oeokmVo`oe3omV_fKo3oD?ofJoooD?mOl00ml01OnOGioo00;O
00GoGimOo`03g`05oenOGol00]l08onOGioo_fJoooD?mOnoI_l?m@ooI[mVo`oeokmV_ooe3oGo00/0
000:07co4`1lo`/0000:0003okmV00;o00^oI_l?m@oo[nj_o`03d004oa4^o`<[00Wo7alOohi>S_l0
0]l02OmOWeooO_Ano`03C00<o`?Fok0>/?oPX>3o0e004on[0_lF[aKo0]H2o`:_0_m>LOl00el02?lS
7b?o`;3o0il05?m^;Vko<20`ojmoo`<>0omP863o0mH01?l2i_lC0004ofKoo`?O00GogmoOo`02g`05
omoOgol00ml01OoOgmoo00;O02?ogmoOokmV_onoI[oo_fKoI[mVofJoI_mV_fKoI[oo_fJoo`03g`05
omoOgol00]l01OoOgmoo00?O00GogmoOo`02g`0SomoOgonoI[oo_fJookmVofJoI_mV_fKoI[oo_fJo
okmV_ol02`0000X000?oi[l00_l02nJoolh?c_o_[noo00?@00Co;U7o0b/02OlO7aooCSi>o`02g`09
oenOGomaOW7o00=<04_o3`?ol@kaoj3PX?n@D93oJ`;ok[o^o`9V0_l30P?oPDkoGimOob=O8ol8`?nO
Kioo?Vhnob0`8?m_[ol>0`koH21PolKFa_ofU_l04`001?noool3g`05omoOgol00]l01OoOgmoo00?O
00GogmoOo`02g`0SomoOgooV_nKoi[oVonJookoV_onoi[oo_nJookoVonJoi_l00ml01OoOgmoo00;O
00GogmoOo`03g`05omoOgol00]l08ooOgmooi[oVonJoi_oV_onoi[oo_nJookoVonJoi_oV_nKo00/0
000:0003okmV00;o00^oI_l?m@oo[nj_o`03d004oa4^o`<[00Wo7alOohi>S_l00]l02OmOWeooO_An
o`03C00<o`?Fok0>/?oPX>3o0e004on[0_lF[aKo0]H2o`:_0_m>LOl00el02?lS7b?o`;3o0il05?m^
;Vko<20`ojmoo`<>0omP863o0mH01?l2i_lC0004ofKoo`?O00GogmoOo`02g`05omoOgol00ml01OoO
gmoo00;O02?ogmoOokmV_onoI[oo_fKoI[mVofJoI_mV_fKoI[oo_fJoo`03g`05omoOgol00]l01OoO
gmoo00?O00GogmoOo`02g`0SomoOgonoI[oo_fJookmVofJoI_mV_fKoI[oo_fJookmV_ol02`0000X0
O?lC07co2`0000X000?oD5000_l2D00=oj3PX?l>/0ko0mH3o`02C009ooAnm?nOGioo00?O00CoSTko
0al02Ol[:b_o4BhAo`02d00@onj_k_oe3oGo_fJoo`;Vo`?F01Co860Po`h33_n_OolP<23o;Vh^o`:O
00Wo/<2`oalS7ol00el04om>LOn_0ZooeP;FojlF[on[0_l04`001?m@ool3g`08oimOWoodO_l3C00<
o`?F0ol>/0koX>3o0e003?oOgmooWenOooAno`=<00co0mH3o`j`3_nPh?l3D00<omoOgonOGioom7ko
0d`03?l3eP?o3[0>oj3Po`=@00cogmoOoimOWoodO_l3C00<o`?F0ol>/?oPX>3o0e000ol000090000
2P000on@D002o`0?T53oh:3Po`ka3_l?0`oo009<00WoOW5noimOWol00ml01?m>?_l37`09ob/[:ol^
DBko00;@04So[nn_o`o>3ooV_nKomYKoe/KFob1P8?l33P?oKjoo<20`ofhnK_m_Woo02<3oGb=OoimO
Won1C_l20`;oIP9Voko^_om[0_lC0004oe3oo`?O00SoWenOogiao`=<013o3`<?o`ka3_oPX?n@D93o
0ml02?nOGiooOW7o0d`04?l?0`oo3_4>on2Poi1@T?l3g`08oimOWomnLOl3C00@o`l33ol>l@koh:3o
T52@o`?O00SoWenOogiao`=<013o3`<?o`kaoj3PX?n@D93o2`0000X0O?lC07co2`0000X000?oX>00
0_l04Z3Poe2@D?l?0`oo3_4>og5no`=<00WogmoOoimOWol00Ql02OlnCSko;U4^o`03:`04onn_o`?@
04Coi[oVo`o>3oo6e_nFmYKo0`h3ob1P8?lP<?n_KjooKim_ofhnoelSGoo02<3oPDj1oimOofH2I_l2
0`;oJ`9[oko^oa<000Coh?oo0ml06ooOgmooOW7oLGiao`l33ol?0`ooh:3oX>2Po`03g`0KomoOgomn
LOmaOW7o3`<?o`l33ooPX?nPh:3o00?O01_ogmoOogiaog5nLOl?0`oo3`<?on2Poj3PX?l00ml06ooO
gmooOW7oLGiao`l33ol?0onPh:3oX>2Po`0;00002P000ooPX002o`03h:3o00=@00co0mH3o`j`3_mn
m?l3C009omoOgonOGioo008O00WoCXi>oa4^4Ol00b/01?n_k_l3d009okmV_ooe3oGo00;F01CoiP;V
o`h33_lPH23o<23oOjmoo`>O013o;Vko7b<Ook30/?m>LDko0Ul04?oF0]Ko[`:_oj/2Zon_5_lC0004
oj3oo`?O01_ogmoOooAnogkdO_l3eP?o0mH3oj3Pon2Ph?l00ml06ooOgmoom7koO_Ano`?F0ol3eP?o
X>3oh:3Po`03g`0KomoOgoodO_mnm7ko0mH3o`?F0onPh?oPX>3o00?O01_ogmoOooAnogkdO_l3eP?o
0mKoh:3Pon2Ph?l02`0000X000?oX>000_l04Z3Poe2@D?l?0`oo3_4>og5no`=<00WogmoOoimOWol0
0Ql02OlnCSko;U4^o`03:`04onn_o`?@04Coi[oVo`o>3oo6e_nFmYKo0`h3ob1P8?lP<?n_KjooKim_
ofhnoelSGoo02<3oPDj1oimOofH2I_l20`;oJ`9[oko^oa<000Coh?oo0ml06ooOgmooOW7oLGiao`l3
3ol?0`ooh:3oX>2Po`03g`0KomoOgomnLOmaOW7o3`<?o`l33ooPX?nPh:3o00?O01_ogmoOogiaog5n
LOl?0`oo3`<?on2Poj3PX?l00ml06ooOgmooOW7oLGiao`l33ol?0onPh:3oX>2Po`0;00002P1loa<0
O?l;00002P000ooa3P02o`0Bl@ko3`<?oe2@D?oPX>3oGioo0ml02Om<C4coOW5no`02:`09obiA;_ln
CSko00<O00SocPooi[oVo`?@043o[nn_of0Po`<>0onFmYKoe/KFoci^ofnOKon_Kjoo<23oWenOoh5>
POo02<3oGb?o_njoof/2Jol20`;oIP;o4`001?l>ool3g`05oimOWol00]l05?mOWeoo3`<?o`ka3_l?
0ooa3_7o0ml01OnOGioo00;O01CoGimOo`l33ol>l@ko3`?ol@kao`?O00GoWenOo`02g`0DoenOGol?
0`oo3_4>o`l3oo4>lOl3g`05oimOWol00]l05?mOWeoo3`<?o`kao`<?0ooa3_7o2`0000X000?o/0h0
0_l01k0>o`?F0ol00e002?nPh:3oGioo0ml02Om<C4com7kdo`02:`09oa4^4Om>STko00<O00So3oGo
_fJoo`?@013okZo^of0Po`h33_oV0^Ko0mH01?m^;_l3W`08ogn_OolP<?l3G`0KodiaC_n``;3o7b?o
[aJ_oj/2Zon_0ZooeP;o01<000Co3_oo0ml01OnOGioo00;O01CoGimOo`?F0ol>/0ko0mKo/0j`o`?O
00GoWenOo`02g`0DoenOGol3eP?o3[0>o`?Fok0>/?l3g`05oimOWol00]l05?mOWeoo0mH3o`j`3_l3
e_n`3[3o0ml01OnOGioo00;O01CoGimOo`?F0ol>/?oF0mKo/0j`o`/0000:0003oo4>00;o01;a3_l?
0`ooD91@on2Ph?mOWol3g`09oda<C?mnLGko008[00Wo;U4^oci>?_l00al02?o>3ooV_nKo0m00@?n_
kjooH23o0`h3oiKfU_oFa]Ko?VkoKim_ojm_[ol`8?nOGiooPDj1ol08`?mO8onok[ooJ`9[o`830_mV
0_lC0004o`koo`?O00GoWenOo`02g`0DoenOGol?0`oo3_4>o`l3oo4>lOl3g`05oimOWol00]l05?mO
Weoo3`<?o`ka3_l?0ooa3_7o0ml01OnOGioo00;O01CoGimOo`l33ol>l@ko3`?ol@kao`?O00GoWenO
o`02g`0DoenOGol?0`oo3_7o0`l3oo4>lOl;00002P1loa<0O?l;00002P000ol33`02o`0?0`oo3_4>
on2Ph?m@T53o00;O00WoWenOogiaO_l00d`01?mA;_l3:`0DoalO7olnCSko_nKo3lh?ojo_[ol3d00l
o`h3ob1P8?oFa]KoU_JFoim_ofhnK_l`833o[fooPDj1oimOWomO8eoo`0SoJ`9[oko^_omV0VKo0P?o
4`001?l?ool3g`05omoOgol00]l05?oOgmoo3`<?o`l33ol?0ol33`?o0ml01OoOgmoo00;O01CogmoO
o`l33ol?0`oo3`?o0`l3o`?O00GogmoOo`02g`0DomoOgol?0`oo3`<?o`l3o`<?0ol3g`05omoOgol0
0]l05?oOgmoo3`<?o`l3o`<?0ol33`?o2`0000X000?oeP<00_l02mH3o`j`3_nPh:3o00=@00cogmoo
WenOooAnm?l3C004obhAo`<[01Co7alOodj>C_mV_ooe3oGokZo^o`?@00So0`ko860Po`?F00GoiP;V
o`02W`0@obi^;_lP<23oOjooCW5>o`=O01Oo7b<Ook30oj/2Zon_5ZooeP;Fojl2o`0C0004o`?oo`?O
00GogmoOo`02g`0DomoOgol3eP?o0mH3o`?FomH3e_l3g`05omoOgol00]l05?oOgmoo0mH3o`?F0ol3
e_oF0mKo0ml01OoOgmoo00;O01CogmoOo`?F0ol3eP?o0mKoeP?Fo`?O00GogmoOo`02g`0DomoOgol3
eP?o0mKoeP?FomH3e_l;00002P000ol33`02o`0?0`oo3_4>on2Ph?m@T53o00;O00WoWenOogiaO_l0
0d`01?mA;_l3:`0DoalO7olnCSko_nKo3lh?ojo_[ol3d00lo`h3ob1P8?oFa]KoU_JFoim_ofhnK_l`
833o[fooPDj1oimOWomO8eoo`0SoJ`9[oko^_omV0VKo0P?o4`001?l?ool3g`05omoOgol00]l05?oO
gmoo3`<?o`l33ol?0ol33`?o0ml01OoOgmoo00;O01CogmoOo`l33ol?0`oo3`?o0`l3o`?O00GogmoO
o`02g`0DomoOgol?0`oo3`<?o`l3o`<?0ol3g`05omoOgol00]l05?oOgmoo3`<?o`l3o`<?0ol33`?o
2`0000X0O?lC07co2`0000X000?oC4`00_l2C009og5nLOmOWeoo00?O013oD93oX>2Poo4>lOl33`?o
0]004?o_[noocPo>okoV_olnC_l37`14ob/[:omA;U7o[foo830Poci^?_nOKiooU_Koa]K6of0PH?l>
0ol30P?o0VH2onjok_l2Jol8`0So8elSoenOGom>POlC0004odcoo`?O00SoWenOogiao`=<00cogmoO
oenOGomaO_l3C00<omoOgonOGiooOW7o0d`03?oOgmooGimOog5no`=<00cogmoOoimOWomnLOl3C00<
omoOgomOWeooLGko0d`03?oOgmooWenOogiao`=<00cogmoOoenOogiaO_l3C003o`0000T0000:0003
oda<00;o0T`02Omnm7koGimOo`03g`0@oe1@on2Ph?n`3[3oeP?Fo`;@013o[nj_o`oe3omV_fKoCXko
0al05?l[:b_o;Q4^ogn_oc0P<?m^;Vko0il01?oV0_l3eP0Oof0PH?l33_l2[`;o0]H2oaJ_5_l2Zoo0
/<3o8alSo`03G`04og5>oa<000CoC?oo0ml02?nOGioom7ko0d`03?oOgmooGimOogkdo`=<00cogmoO
oimOWoodO_l3C00<omoOgomOWeooO_Co0d`03?oOgmooWenOooAno`=<00cogmoOoenOGomnm?l3C00<
omoOgonOGioom7ko0d`03?oOgmooGioom7kdo`=<00?o00002@0000X0O?lC07co2`0000X000?om7h0
0_l00oAno`03C00<omoOgomOWeooX>3o0e003?oF0mKo/0j`onj_o`?@00WoI[mVo`oe3ol00Ql02On>
CXko;Q4^o`03:`08ob0`ojmo[ol3W`05ofh^K_l00]H09ol2iP;o0`h3of0Po`;F0_l2[`;o0Z/2oaJ_
ob<O8oo0/<3oLDiao`02G`03o`00014000CoO_oo0ml03?oOgmoom7koO_Ano`?O00cogmoOogkdooAn
m?l3g`0<omoOgoodO_mnm7ko0ml03?oOgmooO_Com7kdo`?O00cogmoOooAnogkdO_l3g`0<omoOgomn
m?odO_Co0ml03?oOgmoom7koO_Ano`?O00cogmoom7kdooAnm?l;00002P000omnL@02o`03OW7o00=<
01_ogmoOoenOGooPX?n@D93o0`l3oo4>lOn_kol00m002Onoi[oocPo>o`027`09odhnC_mA;U7o00<[
03co<23oKjm_oim_WolnKSkoe/KomYKfo`h33_mP8?l2IP;o0`83o`9[0_o^_olSGb?o2<08odj1C_mO
WolC0004og7oo`?O00cogmoOogiaog5nLOl3g`0<omoOgomaO_mnLGko0ml03?oOgmooOW7oLGiao`?O
00cogmoOog5nogiaO_l3g`0<omoOgomnLOmaOW7o0ml03?oOgmooLGkoOW5no`?O00cogmoOogiaog5n
LOl3g`0<omoOogiaO_mnLGko2`0000X000?om7h00_l00oAno`03C00<omoOgomOWeooX>3o0e003?oF
0mKo/0j`onj_o`?@00WoI[mVo`oe3ol00Ql02On>CXko;Q4^o`03:`08ob0`ojmo[ol3W`05ofh^K_l0
0]H09ol2iP;o0`h3of0Po`;F0_l2[`;o0Z/2oaJ_ob<O8oo0/<3oLDiao`02G`03o`00014000CoO_oo
0ml03?oOgmoom7koO_Ano`?O00cogmoOogkdooAnm?l3g`0<omoOgoodO_mnm7ko0ml03?oOgmooO_Co
m7kdo`?O00cogmoOooAnogkdO_l3g`0<omoOgomnm?odO_Co0ml03?oOgmoom7koO_Ano`?O00cogmoo
m7kdooAnm?l;00002P1loa<0O?l;00002P000onOG`02o`03Weoo00?O013oC4a<ogkdO_l>/?oF0mKo
0e003?oPX>3om@ooI[mVo`?@00Go[nj_o`02:`09obhA;_n>CXko00<O00Co;Vko0il05?n_Ojoo<20`
ob1Po`<>0ol2iP;o0]H04?lF[aKo0Z/2o`:_0_l2e_l3G`0<og5>LOo0/<3o8aoo4`001?mOool3g`05
oimOWol00]l01OmOWeoo00?O00GoGimOo`02g`05oimOWol00ml01OnOGioo00;O00GoGimOo`03g`05
oenOGol00]l01OnOGioo00?O00GoWenOo`02g`05oenOGol00ml01OmOWeoo00;O00GoWenOo`03g`05
oimOWol00]l01OmOWeoo00?O00CoGioo0ml01OnOGioo00/0000:0003oimO00;o00>OGol00ml07om<
C4coLGiao`kao`<?0on@D93oX>2Po`o>okoV_ol00m001Oo_[noo008[00WoDBiAodhnC_l00al0??m^
?_nOKiooKjm_ob0`8?lPH?l>0`komYKfolKFonjok_l2J`;o0`83o`9VoenOGom>PDko2<08ob=Ooa<0
00CoGooo0ml01OnOGioo00;O00GoGimOo`03g`05oenOGol00]l01OnOGioo00?O00GoWenOo`02g`05
oenOGol00ml01OmOWeoo00;O00GoWenOo`03g`05oimOWol00]l01OmOWeoo00?O00GoGimOo`02g`05
oimOWol00ml01OnOGioo00;O00GoGimOo`03g`04oenOo`?O00GoWenOo`0;00002P000onOG`02o`03
Weoo00?O013oC4a<ogkdO_l>/?oF0mKo0e003?oPX>3om@ooI[mVo`?@00Go[nj_o`02:`09obhA;_n>
CXko00<O00Co;Vko0il05?n_Ojoo<20`ob1Po`<>0ol2iP;o0]H04?lF[aKo0Z/2o`:_0_l2e_l3G`0<
og5>LOo0/<3o8aoo4`001?mOool3g`05oimOWol00]l01OmOWeoo00?O00GoGimOo`02g`05oimOWol0
0ml01OnOGioo00;O00GoGimOo`03g`05oenOGol00]l01OnOGioo00?O00GoWenOo`02g`05oenOGol0
0ml01OmOWeoo00;O00GoWenOo`03g`05oimOWol00]l01OmOWeoo00?O00CoGioo0ml01OnOGioo00/0
000:07co4`1lo`/0000:0003omoO00;o0]l02OmOWeooO_Ano`03C00<o`?Fok0>/?oPX>3o0e003?no
I_l?m@oo[nj_o`?@00Co4Bko0b/02OlO7aooSTj>o`02W`0Dofh^K_l`833o[gn_o`h3of0PH?l3eP0G
o`;Vo`:[0_lF[aKo0]H2o`:_og5>LOl00el02?lS7b?o`;3o4`001?oOool3g`05omoOgol00]l01OoO
gmoo00?O00GogmoOo`02g`05omoOgol00ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l01OoO
gmoo00?O00GogmoOo`02g`05omoOgol00ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l01OoO
gmoo00?O00Cogmoo0ml01OoOgmoo00/0000:00Go0]l02OmOWeooLGiao`03C00Ko`l3oo4>lOnPh:3o
T52@onJoolh?c_o_[noo00?@00Co;U7o0b/0A?lO7aooCSi>ofnOoci^?_lP<23oKjm_o`<>of0PH?o6
e/KomYKo0V/2onjok_l2IP;o0`;oCX5>oenOGolSGb?o2<3o4P05o`?O00GogmoOo`02g`05omoOgol0
0ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l01OoOgmoo00?O00GogmoOo`02g`05omoOgol0
0ml01OoOgmoo00;O00GogmoOo`03g`05omoOgol00]l01OoOgmoo00?O00GogmoOo`02g`05omoOgol0
0ml01?oOgol3g`05omoOgol02`0000P0O_lA07ko2`0000T0OOlB07go2`0000X000?o0?l00_l2g`09
oenOGomnm7ko00=<00co0mKo/0j`on2Ph?l3D00<okmVo`oe3on_kZoo0m001?lA;_l3:`09oalO7on>
CXko00:O01CoKRi^oc0P<?n_Ojoo3P?oH21Po`?F01Oo0^Ko0Z/2oaJ_5_l2eP;o0ZooLDiao`02G`?o
00HO8oo0/?lC00Co0ml02?nOGioom7ko0d`02ol3eP?o3[0>oj3P00Go00^oI[oom@oeonj_o`03d005
oa4^4Ol00b/02?lO7on>CXko0il05?l^KRko833o[gn_o`h33_lPH23o0]H06?l2iP;oZ`:[ojlF[ooF
0_l2[`;oCW5>o`9O0ol01R?o`;30o`/0000900?o00<0ool00]l02OmOWeooLGiao`03C00Ko`l3oo4>
lOnPh:3oT52@onJoolh?c_o_[noo00?@00Co;U7o0b/0A?lO7aooCSi>ofnOoci^?_lP<23oKjm_o`<>
of0PH?o6e/KomYKo0V/2onjok_l2IP;o0`;oCX5>oenOGolSGb?o2<3o4P05o`?O00SoWenOogiao`=<
01_o3`<?o`ka3_oPX?n@oi3oi[oVo`o>3on_kol00m001Ol^DBko00<[03_o7aooCSi>ofnOKom^?Vko
<23oKjm_o`<>0olPH23oe/KomYKfof/2Jonok[ooIP;o0`83oh5>POnOG`02o`07Gb?o2<08o`0;0000
201noa40O_l;00002P02o`030?oo008000Oo0000o`3o00<000Go0000o`040004o`00o`<000Go0000
o`030003o`3o008000?o0000:`000ol0o`0;0003o`0000P000?o00005P05o`040?l0o`8000?o0000
0P000ol000020004o`00o`<000Go0000o`030005o`000?l01@001Ol0003o00<000?o0?l00P001Ol0
003o008000Go0000o`030007o`000?l0o`020003o`0000L000?o0?l02`000ol000080003o`0000l0
000;00?o0`001ol0003o0?l00`001Ol0003o00@000?o000010001Ol0003o00<000?o0?l00P000ol0
000/0003o`0000P01Ol70003o`3o01T000Oo0?l0o`3o008000?o00000P000ol000020003o`0000@0
00Go0000o`030005o`000?l01@001Ol0003o00D01?l30003o`0000@000Go0000o`030003o`3o0080
00?o000020000ol0000800Go1`000ol0o`0@00002`000ol0o`030007o`000?l0o`030005o`000?l0
10000ol000040005o`000?l00`000ol0o`020003o`0002/000?o0?l02`000ol000070003o`3o01T0
00Oo0?l0o`3o008000?o00000P000ol000020003o`0000@000Go0000o`030005o`000?l01@001Ol0
003o00<000?o00000P001Ol0003o00H000Go0000o`030003o`3o008000?o00001`000ol0o`0;0003
o`0000L000?o0?l0400000`000?o00000`04o`801?l200;o0`04o`<00_l400?o00<0ool00ol/00;o
00<0ool02P000ol0000600;o00<0ool06002o`030?oo00;o00<0ool010001?l00004o`<00_l200Go
10000ol0000200;o1004o`800ol200Co0`02o`@00ol00`3oo`03o`P00_l00`3oo`0C00;o00<0ool0
3`0000/00_l80003o`0000<000?o00001P000ol0001b00;o0`02o`P000?o00000P000ol0000@0003
o`0001@000?o0000AP0001@00_l400;o0`000ol000020003o`0000@000?o0000N003o`@000?o0000
10000ol0000700?o1@000ol0000>0003o`0000@000?o0000?`000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {138.188, 0}} -> {-0.0541985, -0.0241755, 
  0.00734634, 0.00734634}, {{7.375, 137}, {134.875, 
  3.25}} -> {-3.79661, -1.72799, 0.267312, 0.267312}, {{149.938, 279.562}, {
  134.875, 3.25}} -> {-41.9053, -1.72799, 0.267312, 0.267312}},
  CellTags->"Cayley"]
}, Open  ]],

Cell["3.6 Building other structures", "Subsection",
  CellTags->{"DirectProducts", "i:4"}],

Cell["\<\
As with groups, the use of direct products, substructures, and \
quotient structures is an effective means of obtaining new ringoids.\
\>", 
  "Text",
  CellTags->"DirectProducts"],

Cell["3.6.1 Direct products", "Subsubsection",
  CellTags->{"DirectProducts", "i:5"}],

Cell[TextData[{
  "The direct product of two or more ringoids can be constructed with ",
  StyleBox["DirectProduct", "MR",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->"DirectProducts"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DirectProduct",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[\(R\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(R\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(\(return\ the\ ringoid\ with\ domain\ the\ Cartesian\)\ 
                  product\ of\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["domains",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R\_1\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R\_2\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coordinate\[Hyphen]wise",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operations",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["DirectProduct",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[\(R\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(R\_2\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", "\[Ellipsis]"}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["direct",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["products",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                "Text",
                SingleLetterItalics->False], 
              StyleBox["ringoids",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R\_1, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R\_2, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\[Ellipsis]",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["DirectSum",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[\(R\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(R\_2\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", "\[Ellipsis]"}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(identical\ in\ functionality\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox["DirectProduct",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox[\([R\_1, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R\_2, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\[Ellipsis]",
                  SingleLetterItalics->False]}], 
              StyleBox["]",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"DirectProducts", "i:6"}],

Cell["Functions that generate direct products/sums.", "Caption",
  CellTags->"DirectProducts"],

Cell["Here is yet another ring with eight elements.", "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T = DirectProduct[ZR[2], ZR[4]]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \(Ringoid[{{0, 0}, {0, 1}, {0, 2}, {0, 3}, {1, 0}, {1, 1}, {1, 2}, {1, 
          3}}, "-Addition-", "-Multiplication-"]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell[TextData[
"Here is its unity\[LongDash]not exactly the number 1, but close."], 
  "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Unity[T]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell["\<\
The units in a direct product must have units in each coordinate.\
\
\>", "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Units[T, Mode \[Rule] Textual]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"{1, 1} is a unit because {1, 1} . {1, 1} = {1, 1}.\"\>"},
          {"\<\"{1, 3} is a unit because {1, 3} . {1, 3} = {1, 1}.\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {"{1, 1} is a unit because {1, 1} . {1, 1} = {1, 1}.", 
        "{1, 3} is a unit because {1, 3} . {1, 3} = {1, 1}."}]]], "Print",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \({{1, 1}, {1, 3}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell[TextData[{
  "More than two ringoids can be \[OpenCurlyDoubleQuote]multiplied.\
\[CloseCurlyDoubleQuote] In this case, there are three copies of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ", giving one more example of a ring with eight elements."
}], "MathCaption",
  CellTags->"DirectProducts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Elements[DirectProduct[ZR[2], ZR[2], ZR[2]]]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"DirectProducts"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 0, 1}, {0, 1, 0}, {0, 1, 1}, {1, 0, 0}, {1, 0, 1}, {1, 
        1, 0}, {1, 1, 1}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"DirectProducts"]
}, Open  ]],

Cell["3.6.2 Subrings and ideals", "Subsubsection",
  CellTags->{"Subrings", "i:7"}],

Cell[TextData[{
  "When the ringoid ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " is a ring, the expression ",
  StyleBox["SubringQ", "MR"],
  "[",
  StyleBox["S, R",
    FontSlant->"Italic"],
  "] tests whether a list of elements ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " is a subring of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ". This is done by testing whether ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " is nonempty and closed with respect to addition and multiplication in ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ". Subrings must also contain negations of its elements, but in a finite \
ring, it is sufficient to verify closure to conclude that this property is \
true."
}], "Text",
  CellTags->"Subrings"],

Cell[TextData[{
  "Given a subring ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ", we call it a two-sided ",
  StyleBox["ideal",
    FontSlant->"Italic"],
  " of the ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " if for every ",
  Cell[BoxData[
      \(TraditionalForm\`r \[Element] R\)]],
  " and every ",
  Cell[BoxData[
      \(TraditionalForm\`s \[Element] S\)]],
  " both ",
  Cell[BoxData[
      \(TraditionalForm\`r  s\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`s  r\)]],
  " are in ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Left ideals and right ideals require only one of these products to be in \
",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "."
}], "Text",
  CellTags->"Subrings"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SubringQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(S, \ R\),
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    StyleBox["S",
                      "Text"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["given",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], "as", " ", 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["ringoid",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["with",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["operations",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], "\n", 
                    StyleBox["matching",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["those",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["in",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["R",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["or",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["as",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["list",
                      SingleLetterItalics->False]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subring",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["ringoid",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["IdealQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(S, \ R\),
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["S",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((two\[Hyphen]sided)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ideal",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\(, \ and\)\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["LeftIdealQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(S, \ R\),
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  StyleBox["S",
                    "Text"],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ a\ left\ ideal\ of\ the\ ringoid\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["RightIdealQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(S, \ R\),
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  StyleBox["S",
                    "Text"],
                  "TraditionalForm"], 
                StyleBox[\(\ is\ a\ right\ ideal\ of\ the\ ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\(, \ and\)\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Subrings", "i:8"}],

Cell["Subring and ideal testing.", "Caption",
  CellTags->"Subrings"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is even, the even elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " are a subring."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubringQ[{0, 2, 4, 6, 8}, Z[10]]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "This is essentially the same test as the previous one, except the first \
argument is a ",
  StyleBox["Ringoid", "MR"],
  ", not a list. This flexibility resides in many functions such as this."
}], "MathCaption",
  CellTags->{"Subrings", "i:9"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubringQ[Z[10, 2], Z[10]]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "This is ",
  Cell[BoxData[
      StyleBox[\(Z[10, \ 2]\),
        "MR"]], "Input"],
  " with the addition and the multiplication exchanged."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rrev = 
      FormRingoid[Range[0, 8, 2], \(Z[10]\)[\([3]\)], \(Z[10]\)[\([2]\)]]\)], 
  "Input",
  CellLabel->"In[13]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(Ringoid[{0, 2, 4, 6, 8}, "-Addition-", "-Multiplication-"]\)], "Output",\

  CellLabel->"Out[13]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Rrev", "MR"],
  " ",
  "shows that the operations, not just the elements, need to match."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubringQ[Rrev, \ Z[10]]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(Operation::"fail" \( : \ \) 
      "The operation of the substructure(s) does not match that of the parent \
structure."\)], "Message",
  CellTags->"Subrings"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "When a subring is an ideal, we are able to build a new ring with ",
  StyleBox["QuotientRing", "MR"],
  "."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ideal\  = \ Range[0, 8, 2], IdealQ[ideal, \ Z[10]], \ 
        QuotientRing[Z[10], \ ideal]} // ColumnForm\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(QuotientRing::"NS" \( : \ \) 
      "This quotient ring uses NS to represent the ideal (normal subgroup) \!\
\({0, 2, 4, 6, 8}\) you specified. Use CosetToList to convert this coset \
representation to a list of the elements."\)], "Message",
  CellTags->"Subrings"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({0, 2, 4, 6, 8}\)},
          {"True"},
          {\(Ringoid[{NS, 1 + NS}, "-Addition-", "-Multiplication-"]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{0, 2, 4, 6, 8}, True, 
        AbstractAlgebra`Core`Private`ringoid[ {
          AbstractAlgebra`Joint`Private`acoset[ 0, NS], 
          AbstractAlgebra`Joint`Private`acoset[ 1, NS]}, 
          AbstractAlgebra`Joint`Private`QGCosetSum[ 
          AbstractAlgebra`RingProperties`Private`AG$15355, 
            AbstractAlgebra`RingProperties`Private`cosets$15355, #, #2, 
            AbstractAlgebra`RingProperties`Private`reps$15355]&, 
          AbstractAlgebra`Joint`Private`QGCosetSum[ 
          AbstractAlgebra`RingProperties`Private`MG$15355, 
            AbstractAlgebra`RingProperties`Private`cosets$15355, #, #2, 
            AbstractAlgebra`RingProperties`Private`reps$15355]&, {{True}, {
          NS, 
          Plus[ 1, NS]}, {}, {}, {
          AbstractAlgebra`RingProperties`Private`cosetlist -> {{0, 2, 4, 6, 
          8}, {1, 3, 5, 7, 9}}, 
          AbstractAlgebra`RingProperties`Private`cosetreps -> {0, 1}, 
          AbstractAlgebra`RingProperties`Private`Qnum -> 
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2, 3, 4, 5, 6, 7, 8, 
            9}, Mod[ 
              Plus[ #, #2], 10]&, Mod[ 
              Times[ #, #2], 10]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[10]", RingoidDescription -> "the ring of integers mod 10", 
            FormatOperator -> False}}], 
          AbstractAlgebra`RingProperties`Private`Qden -> {0, 2, 4, 6, 8}, 
          AbstractAlgebra`RingProperties`Private`Qform -> Cosets}, {
          RingoidName -> "Z[10]/NS", KeyForm -> OutputForm, IsARing -> True, 
          WideElements -> True, 
          AbstractAlgebra`Core`Private`ExtraInformation -> {{True}, {NS, 
          Plus[ 1, NS]}, {}, {}, {
          AbstractAlgebra`RingProperties`Private`cosetlist -> {{0, 2, 4, 6, 
          8}, {1, 3, 5, 7, 9}}, 
          AbstractAlgebra`RingProperties`Private`cosetreps -> {0, 1}, 
          AbstractAlgebra`RingProperties`Private`Qnum -> 
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2, 3, 4, 5, 6, 7, 8, 
            9}, Mod[ 
              Plus[ #, #2], 10]&, Mod[ 
              Times[ #, #2], 10]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[10]", RingoidDescription -> "the ring of integers mod 10", 
            FormatOperator -> False}}], 
          AbstractAlgebra`RingProperties`Private`Qden -> {0, 2, 4, 6, 8}, 
          AbstractAlgebra`RingProperties`Private`Qform -> Cosets}}}}]}],
      Editable->False]], "Output",
  CellLabel->"Out[15]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell["Not every subring is an ideal.", "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({SubringQ[{{}, {1, 2, 3}}, BooleanRing[3]], 
      IdealQ[{{}, {1, 2, 3}}, BooleanRing[3]]}\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "Also, not every ideal is both a left and a right ideal. In this example, \
we consider the two-by-two matrices over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " and consider the set of elements (calling it ",
  StyleBox["LI", "MR"],
  ") whose first column is all zeros. (These happen to be in positions 1, 2, \
5 and 6 in the ring.)"
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\  = \ ToRingoid[Mat[Z[2], 2]]; \n
    Map[MatrixForm, \((LI\  = \ \(Elements[M]\)[\([{1, 2, 5, 6}]\)])\)]\)], 
  "Input",
  CellLabel->"In[17]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0"},
                {"0", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0"},
                {"0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1"},
                {"0", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1"},
                {"0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "Now we verify that ",
  StyleBox["LI", "MR"],
  " is indeed a subring and also a left ideal, but not a right ideal."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({SubringQ[LI, M], LeftIdealQ[LI, M], RightIdealQ[LI, M]}\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \({True, True, False}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Textual", "MR"],
  " mode is supported by ",
  StyleBox["SubringQ", "MR",
    FontWeight->"Plain"],
  "."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubringQ[{{}, {1, 2, 3}}, BooleanRing[3], Mode \[Rule] Textual]\)], 
  "Input",
  CellLabel->"In[19]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \("Prospective subring is not empty; passes the first test."\)], "Print",
  CellTags->"Subrings"],

Cell[BoxData[
    \("Prospective subring is closed with respect to addition; passes the \
second test."\)], "Print",
  CellTags->"Subrings"],

Cell[BoxData[
    \("Prospective subring is closed with respect to multiplication; passes \
the third test."\)], "Print",
  CellTags->"Subrings"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["principal ideal generated by",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in a commutative ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " is defined to be ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]r\[RightAngleBracket] = {s\ r\  | s \[Element] R}
          \)]],
  ". Given a subset ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " of the commutative ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ", we define the ",
  StyleBox["annihilator",
    FontSlant->"Italic"],
  " of S by ",
  Cell[BoxData[
      \(TraditionalForm
      \`Ann(S) = {r \[Element] R | r\ s = 0\ for\ all\ s \[Element] S}\)]],
  "; this is an ideal."
}], "Text",
  CellTags->{"Subrings", "i:10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PrincipalIdeal",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ principal\ ideal\ generated\ by\ \),
                  SingleLetterItalics->False], 
                FormBox["r",
                  "TraditionalForm"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Annihilator",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox["S",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["annihilator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  StyleBox["S",
                    "Text"],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ in\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"Subrings", "i:11"}],

Cell["Methods to create specialized ideals.", "Caption",
  CellTags->"Subrings"],

Cell["\<\
We get a principal ideal by multiplying the generator by the ring \
elements, so here we get the multiples of 8.\
\>", "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrincipalIdeal[Z[20], 8]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(Ringoid[{0, 4, 8, 12, 16}, Mod[#1 + #2, 20]&, Mod[#1\ #2, 20]&]\)], 
  "Output",
  CellLabel->"Out[20]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "Multiplication in Boolean rings is set intersection, so the ideal \
generated by ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \ 2}\)]],
  " is the intersection of ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \ 2}\)]],
  " with other sets in the ring."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrincipalIdeal[BooleanRing[4], {1, 2}]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(Ringoid[{{}, {1}, {2}, {1, 2}}, "-Addition-", "-Multiplication-"]\)], 
  "Output",
  CellLabel->"Out[21]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  " Here are all the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  " that annihilate 4."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Annihilator[Z[8], {4}]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(Ringoid[{0, 2, 4, 6}, Mod[#1 + #2, 8]&, Mod[#1\ #2, 8]&]\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell["\<\
 Similarly, here are all the elements in the Boolean ring on {1, 2, \
3} that annihilate the element {1, 2}.\
\>", "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Annihilator[BooleanRing[3], {{1, 2}}]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \(Ringoid[{{}, {3}}, "-Addition-", "-Multiplication-"]\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "In addition to principal ideals, ",
  StyleBox["prime",
    FontSlant->"Italic"],
  " and ",
  StyleBox["maximal",
    FontSlant->"Italic"],
  " ideals are also of importance. A proper ideal ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " of a commutative ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " is said to be a prime ideal of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " if whenever",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`a, b \[Element] R\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`a\ b \[Element] P\)]],
  ", we have either ",
  Cell[BoxData[
      \(TraditionalForm\`a \[Element] P\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`b \[Element] P\)]],
  ". A proper ideal ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " of a commutative ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " is said to be a maximal ideal of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " if whenever ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " is an ideal of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`M \[SubsetEqual] N \[SubsetEqual] R\)]],
  ", then either ",
  Cell[BoxData[
      \(TraditionalForm\`M = N\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`N = R\)]],
  "."
}], "Text",
  CellTags->{"Subrings", "i:13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MaximalIdealQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["R",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["S",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ a\ maximal\ ideal\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["PrimeIdealQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["R",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["S",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ a\ prime\ ideal\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"Subrings", "i:12"}],

Cell["Testing for maximal and prime ideals.", "Caption",
  CellTags->"Subrings"],

Cell[TextData[{
  "Here are the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  " that generate a maximal principal ideal. Do you see a pattern?"
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(maxGen\  = \ 
      Select[Range[1, 11], MaximalIdealQ[PrincipalIdeal[Z[12], #], Z[12]]&]
        \)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \({2, 3, 9, 10}\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell["\<\
Perhaps looking at the actual principal ideals (preceded by their \
generators) may be helpful.\
\>", "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{#, Elements[PrincipalIdeal[Z[12], #]]}&, \ maxGen]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \({{2, {0, 2, 4, 6, 8, 10}}, {3, {0, 3, 6, 9}}, {9, {0, 3, 6, 9}}, {
        10, {0, 2, 4, 6, 8, 10}}}\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell[TextData[{
  "In a commutative ring with unity, every maximal ideal is prime. In finite \
rings, we also have every prime ideal being maximal (in a commutative ring \
with unity).",
  " ",
  "Here are the generators of the prime (or maximal) principal ideals in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_14\)]],
  "."
}], "MathCaption",
  CellTags->"Subrings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Range[1, 13], PrimeIdealQ[PrincipalIdeal[Z[14], #], Z[14]]&]\)], 
  "Input",
  CellLabel->"In[26]:=",
  CellTags->"Subrings"],

Cell[BoxData[
    \({2, 4, 6, 7, 8, 10, 12}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"Subrings"]
}, Open  ]],

Cell["3.6.3 Quotient rings", "Subsubsection",
  CellTags->{"QuotientRings", "i:14"}],

Cell[TextData[{
  "The cosets of an ideal can form a ring using ",
  StyleBox["QuotientRing", "MR"],
  ".",
  " "
}], "Text",
  CellTags->"QuotientRings"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["QuotientRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["T",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(return\ the\ quotient\ ring\ formed\ by\ the\ ring\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ and\ the\ ideal\ \),
                  SingleLetterItalics->False], 
                FormBox["T",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["LeftCosets",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["T",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(return\ the\ set\ of\ left\ cosets\ of\ the\ subring\ \),
                  SingleLetterItalics->False], 
                FormBox["T",
                  "TraditionalForm"], 
                StyleBox[\(\ in\ the\ ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RightCosets",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["T",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(return\ the\ set\ of\ right\ cosets\ of\ the\ subring\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["T",
                  "TraditionalForm"], 
                StyleBox[\(\ in\ the\ ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["LeftCoset",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["T",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ left\ coset\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  RowBox[{
                    StyleBox["r",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["+",
                      SingleLetterItalics->False], 
                    StyleBox[
                      RowBox[{
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          FontSlant->"Italic"]}]], 
                    StyleBox["T",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"]}],
                  "TraditionalForm"], 
                StyleBox[\(\ when\ given\ the\ element\ \),
                  SingleLetterItalics->False], 
                FormBox["r",
                  "TraditionalForm"], 
                StyleBox[\(\ from\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ and\ the\ subring\ \),
                  SingleLetterItalics->False], 
                FormBox["T",
                  "TraditionalForm"], 
                StyleBox[\(\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RightCoset",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["T",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ right\ coset\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  FormBox[
                    RowBox[{
                      StyleBox["T",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox["+",
                        SingleLetterItalics->False], 
                      StyleBox[
                        RowBox[{
                          StyleBox[" ",
                            SingleLetterItalics->False], 
                          StyleBox[" ",
                            FontSlant->"Italic"]}]], 
                      StyleBox["r",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"]}],
                    "TraditionalForm"],
                  "TraditionalForm"], 
                StyleBox[\(\ when\ given\ the\ element\ \),
                  SingleLetterItalics->False], 
                FormBox["r",
                  "TraditionalForm"], 
                StyleBox[\(\ from\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ and\ the\ subring\ \),
                  SingleLetterItalics->False], 
                FormBox["T",
                  "TraditionalForm"], 
                StyleBox[\(\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["CosetToList",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["Q",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["coset",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ \),
                SingleLetterItalics->False], 
              StyleBox["coset",
                FontSlant->"Italic"], 
              StyleBox[\(\ represented\ as\ a\ list\ of\ elements\ from\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ where\ \),
                SingleLetterItalics->False], 
              StyleBox["coset",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Q",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], " ", 
                    StyleBox["=",
                      SingleLetterItalics->False], " ", 
                    StyleBox[\(R/T\),
                      SingleLetterItalics->False,
                      FontSlant->"Italic"]}],
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["FactorRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["T",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["QuotientRing",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["R",
                    "TI"], 
                  StyleBox[",",
                    "MR"], " ", 
                  StyleBox["T",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"QuotientRings", "i:15"}],

Cell["Functions for quotient rings and related structures.", "Caption",
  CellTags->"QuotientRings"],

Cell[TextData[{
  "Earlier we identified {0, 2, 4, 6, 8} as an ideal of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_10\)]],
  ". Thus, we can form the quotient ring."
}], "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(QuotientRing[Z[10], {0, 2, 4, 6, 8}]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    RowBox[{"Ringoid", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox["NS",
              HoldForm], ",", 
            TagBox[\(1 + NS\),
              HoldForm]}], "}"}], ",", "\<\"-Addition-\"\>", ",", 
        "\<\"-Multiplication-\"\>"}], "]"}]], "Output",
  CellLabel->"Out[27]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell["We are notified if a subset is not an ideal.", "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorRing[DirectProduct[Z[4], Z[4]], {{0, 0}, {2, 2}}]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \(QuotientRing::"notideal" \( : \ \) 
      "The set \!\({\({0, 0}\), \({2, 2}\)}\) is not an ideal of the Ringoid \
\!\(\"Z[4] x Z[4]\"\)."\)], "Message",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell["\<\
There is a variety of forms in which the cosets can appear. Here \
representatives are used to describe the cosets.\
\>", "MathCaption",
  CellTags->{"QuotientRings", "i:16"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(QuotientRing[
      DirectProduct[Z[4], Z[4]], {{0, 0}, {1, 0}, {2, 0}, {3, 0}}, 
      Form \[Rule] Representatives]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \(Ringoid[{{0, 0}, {0, 1}, {0, 2}, {0, 3}}, "-Addition-", 
      "-Multiplication-"]\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell[TextData[{
  "Here is a quotient ring with the coset representatives selected randomly, \
but the cosets are listed in the ",
  "form",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(r\ \)\)]],
  "+ ",
  StyleBox["NS", "MR"],
  "."
}], "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q = QuotientRing[Z[21], {0, 7, 14}, Representatives \[Rule] Random]\)], 
  "Input",
  CellLabel->"In[30]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    RowBox[{"Ringoid", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox["NS",
              HoldForm], ",", 
            TagBox[\(1 + NS\),
              HoldForm], ",", 
            TagBox[\(2 + NS\),
              HoldForm], ",", 
            TagBox[\(10 + NS\),
              HoldForm], ",", 
            TagBox[\(18 + NS\),
              HoldForm], ",", 
            TagBox[\(19 + NS\),
              HoldForm], ",", 
            TagBox[\(13 + NS\),
              HoldForm]}], "}"}], ",", "\<\"-Addition-\"\>", ",", 
        "\<\"-Multiplication-\"\>"}], "]"}]], "Output",
  CellLabel->"Out[30]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell[TextData[{
  "To retrieve the complete list of elements of a coset within a quotient \
ring, use ",
  StyleBox["CosetToList", "MR"],
  ". The elements of one of the cosets are listed here."
}], "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CosetToList[Q, 5 + NS]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \({5, 12, 19}\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell[TextData[{
  "In cases where a subring is not an ideal we can still form cosets. \
However, in this case multiplication of cosets using coset representatives is \
not well defined. This is why ",
  StyleBox["QuotientRing", "MR"],
  " requires an ideal as its second argument."
}], "Text",
  CellTags->{"QuotientRings", "i:17"}],

Cell["\<\
We can illustrate the problem of an ill-defined multiplication with \
the following list of cosets.\
\>", "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((cosets = LeftCosets[BooleanRing[3], {{}, {1, 2, 3}}])\) // ColumnForm
      \)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({{}, {1, 2, 3}}\)},
          {\({{3}, {1, 2}}\)},
          {\({{2}, {1, 3}}\)},
          {\({{2, 3}, {1}}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{{}, {1, 2, 3}}, {{3}, {1, 2}}, {{2}, {1, 3}}, {{2, 3}, {
        1}}}],
      Editable->False]], "Output",
  CellLabel->"Out[32]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell["\<\
Using the first elements of the second and third cosets, the \
product is in the first coset.\
\>", "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Multiplication[BooleanRing[3]]\)[cosets[\([2, 1]\)], 
      cosets[\([3, 1]\)]]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell["\<\
Using the last elements of the same cosets, the product is in the \
fourth coset. Thus, multiplication of cosets is not well-defined in this \
case.\
\>", "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Multiplication[BooleanRing[3]]\)[cosets[\([2, 2]\)], 
      cosets[\([3, 2]\)]]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \({1}\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"QuotientRings"]
}, Open  ]],

Cell["\<\
By studying the following Cayley table showing how the left cosets \
multiply, we can visually see the same results.\
\>", "MathCaption",
  CellTags->"QuotientRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LeftCosets[BooleanRing[3], {{}, {1, 2, 3}}, \ 
      Mode\  \[Rule] \ Visual, \ Operation\  \[Rule] \ Multiplication]; 
    \)\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"QuotientRings"],

Cell[BoxData[
    \("KEY for Mult(Bool[3]): label used \[Rule] element: {g1 \[Rule] {}, g2 \
\[Rule] {1, 2, 3}, g3 \[Rule] {3}, g4 \[Rule] {1, 2}, g5 \[Rule] {2}, g6 \
\[Rule] {1, 3}, g7 \[Rule] {2, 3}, g8 \[Rule] {1}}"\)], "Print",
  CellTags->"QuotientRings"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
1 .5 0 r
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.56 .37 .6 r
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
0 0 1 r
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
1 .5 0 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.56 .37 .6 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 0 1 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
1 .5 0 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.56 .37 .6 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 0 1 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g1)] .28836 .81878 0 0 Mshowa
[(g1)] .39418 .81878 0 0 Mshowa
[(g1)] .5 .81878 0 0 Mshowa
[(g1)] .60582 .81878 0 0 Mshowa
[(g1)] .71164 .81878 0 0 Mshowa
[(g1)] .81746 .81878 0 0 Mshowa
[(g1)] .92328 .81878 0 0 Mshowa
[(g1)] .18254 .71296 0 0 Mshowa
[(g2)] .28836 .71296 0 0 Mshowa
[(g3)] .39418 .71296 0 0 Mshowa
[(g4)] .5 .71296 0 0 Mshowa
[(g5)] .60582 .71296 0 0 Mshowa
[(g6)] .71164 .71296 0 0 Mshowa
[(g7)] .81746 .71296 0 0 Mshowa
[(g8)] .92328 .71296 0 0 Mshowa
[(g1)] .18254 .60714 0 0 Mshowa
[(g3)] .28836 .60714 0 0 Mshowa
[(g3)] .39418 .60714 0 0 Mshowa
[(g1)] .5 .60714 0 0 Mshowa
[(g1)] .60582 .60714 0 0 Mshowa
[(g3)] .71164 .60714 0 0 Mshowa
[(g3)] .81746 .60714 0 0 Mshowa
[(g1)] .92328 .60714 0 0 Mshowa
[(g1)] .18254 .50132 0 0 Mshowa
[(g4)] .28836 .50132 0 0 Mshowa
[(g1)] .39418 .50132 0 0 Mshowa
[(g4)] .5 .50132 0 0 Mshowa
[(g5)] .60582 .50132 0 0 Mshowa
[(g8)] .71164 .50132 0 0 Mshowa
[(g5)] .81746 .50132 0 0 Mshowa
[(g8)] .92328 .50132 0 0 Mshowa
[(g1)] .18254 .3955 0 0 Mshowa
[(g5)] .28836 .3955 0 0 Mshowa
[(g1)] .39418 .3955 0 0 Mshowa
[(g5)] .5 .3955 0 0 Mshowa
[(g5)] .60582 .3955 0 0 Mshowa
[(g1)] .71164 .3955 0 0 Mshowa
[(g5)] .81746 .3955 0 0 Mshowa
[(g1)] .92328 .3955 0 0 Mshowa
[(g1)] .18254 .28968 0 0 Mshowa
[(g6)] .28836 .28968 0 0 Mshowa
[(g3)] .39418 .28968 0 0 Mshowa
[(g8)] .5 .28968 0 0 Mshowa
[(g1)] .60582 .28968 0 0 Mshowa
[(g6)] .71164 .28968 0 0 Mshowa
[(g3)] .81746 .28968 0 0 Mshowa
[(g8)] .92328 .28968 0 0 Mshowa
[(g1)] .18254 .18386 0 0 Mshowa
[(g7)] .28836 .18386 0 0 Mshowa
[(g3)] .39418 .18386 0 0 Mshowa
[(g5)] .5 .18386 0 0 Mshowa
[(g5)] .60582 .18386 0 0 Mshowa
[(g3)] .71164 .18386 0 0 Mshowa
[(g7)] .81746 .18386 0 0 Mshowa
[(g1)] .92328 .18386 0 0 Mshowa
[(g1)] .18254 .07804 0 0 Mshowa
[(g8)] .28836 .07804 0 0 Mshowa
[(g1)] .39418 .07804 0 0 Mshowa
[(g8)] .5 .07804 0 0 Mshowa
[(g1)] .60582 .07804 0 0 Mshowa
[(g8)] .71164 .07804 0 0 Mshowa
[(g1)] .81746 .07804 0 0 Mshowa
[(g8)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Mult\\(Bool[3]\\))] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[35]:=",
  ImageSize->{272.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l04@000?l04@000?l04@000?l04@000?l0
4@000?l04@000?l04@0000H0ool5o`H000060003oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<
C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?o0000100000H000?oC4`06D`2oacO
00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?ogml06]l00om<C00IC003omoO01[O00?oC4`06T`00ol0
000400001P000om<C00IC0;o7=l00om<C00IC003omoO01[O00?oC4`06T`00ooOg`0Jg`03oda<01U<
00?ogml06]l00om<C00JC003o`0000@000060003oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<
C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?o0000100000H000?oC4`06D`2oacO
00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?ogml06]l00om<C00IC003omoO01[O00?oC4`06T`00ol0
000400001P000om<C00IC0;o7=l00om<C00IC003omoO01[O00?oC4`06T`00ooOg`0Jg`03oda<01U<
00?ogml06]l00om<C00JC003o`0000@000060003oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<
C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?o0000100000H000?oC4`06D`2oacO
00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?ogml06]l00om<C00IC003omoO01[O00?oC4`06T`00ol0
000400001P000om<C00IC0;o7=l00om<C00IC003omoO01[O00?oC4`06T`00ooOg`0Jg`03oda<01U<
00?ogml06]l00om<C00JC003o`0000@000060003oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<
C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?o0000100000H000?oC4`01d`3o`m<
0_l9g`?o4=l00om<C007C0?o3d`00ooOg`08g`?o3ml00om<C007C0?o44`00ooOg`07g`?o4=l00om<
C007C0?o3d`00ooOg`08g`?o3ml00om<C007C0?o44`00ol0000400001P000om<C00:C003oda<00a<
0_l<g`03omoO00gO00?oC4`02T`00om<C00<C003omoO00_O00?ogml03=l00om<C00:C003oda<00e<
00?ogml02]l00ooOg`0=g`03oda<00Y<00?oC4`034`00ooOg`0;g`03omoO00cO00?oC4`02T`00om<
C00=C003o`0000@000060003oda<00M<1?l2C0;o2T`2o`WO1?l01=ooool;g`03oda<00M<1?l2C0;o
2T`00ooOg`08g`Co00COoooo2]l00om<C007C0Co0T`2o`]<00?ogml01ml4o`04goooo`_O00?oC4`0
1d`4o`9<0_l:C003omoO00SO1?l01=ooool:g`03oda<00M<1?l2C0;o2d`00ol0000400001P000om<
C006C007oda<C?m<o`02C003oda<00M<0_l8g`05omoOgol00]l00ooOg`0:g`03oda<00I<00OoC4a<
odco009<00?oC4`01d`00ooOg`07g`05omoOgol00]l00ooOg`09g`03oda<00I<00OoC4a<odco009<
00?oC4`024`00ooOg`06g`05omoOgol00]l00ooOg`0:g`03oda<00I<00OoC4a<odco009<00?oC4`0
1d`00ooOg`07g`05omoOgol00]l00ooOg`09g`03oda<00I<00OoC4a<odco009<00?oC4`024`00ol0
000400001P000om<C006C007oda<C?m<o`02C003oda<00M<0_l8g`05omoOgol00]l00ooOg`0:g`03
oda<00I<00OoC4a<odco009<00?oC4`01d`00ooOg`07g`05omoOgol00]l00ooOg`09g`03oda<00I<
00OoC4a<odco009<00?oC4`024`00ooOg`06g`05omoOgol00]l00ooOg`0:g`03oda<00I<00OoC4a<
odco009<00?oC4`01d`00ooOg`07g`05omoOgol00]l00ooOg`09g`03oda<00I<00OoC4a<odco009<
00?oC4`024`00ol0000400001P000om<C006C005oda<C?l00T`2o`Y<0_l8g`05omoOgol00]l00ooO
g`0:g`03oda<00I<00GoC4a<o`02C0;o2T`00ooOg`07g`05omoOgol00]l00ooOg`09g`03oda<00I<
00GoC4a<o`02C0;o2d`00ooOg`06g`05omoOgol00]l00ooOg`0:g`03oda<00I<00GoC4a<o`02C0;o
2T`00ooOg`07g`05omoOgol00]l00ooOg`09g`03oda<00I<00GoC4a<o`02C0;o2d`00ol000040000
1P000om<C007C0Ko0T`00om<C007C0;o2Ml5o`03gooO00_O00?oC4`01d`6o`9<00?oC4`01d`00ooO
g`08g`Go00?Ooml02]l00om<C007C0Ko0T`00om<C008C003omoO00OO1Ol00moog`0;g`03oda<00M<
1_l2C003oda<00M<00?ogml02=l5o`03gooO00[O00?oC4`01d`6o`9<00?oC4`024`00ol000040000
1P000om<C00=C0;o2T`2o`kO0_l<g`03oda<00e<0_l:C003omoO00gO0_l;g`03oda<00e<0_l;C003
omoO00cO0_l<g`03oda<00e<0_l:C003omoO00gO0_l;g`03oda<00e<0_l;C003o`0000@000060003
oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03
oda<01Y<00?o0000100000H000?oC4`06D`2oacO00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?ogml0
6]l00om<C00IC003omoO01[O00?oC4`06T`00ol0000400001P000om<C00IC0;o7=l00om<C00IC003
omoO01[O00?oC4`06T`00ooOg`0Jg`03oda<01U<00?ogml06]l00om<C00JC003o`0000@000060003
oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03
oda<01Y<00?o0000100000H000?oC4`06D`2oacO00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?ogml0
6]l00om<C00IC003omoO01[O00?oC4`06T`00ol0000400001P000om<C00IC0;o7=l00om<C00IC003
omoO01[O00?oC4`06T`00ooOg`0Jg`03oda<01U<00?ogml06]l00om<C00JC003o`0000@000060003
oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03
oda<01Y<00?o0000100000H000?oC4`06D`2oacO00?oC4`06D`00ooOg`0Jg`03oda<01Y<00?ogml0
6]l00om<C00IC003omoO01[O00?oC4`06T`00ol0000400001P000om<C00IC0;o7=l00om<C00IC003
omoO01[O00?oC4`06T`00ooOg`0Jg`03oda<01U<00?ogml06]l00om<C00JC003o`0000@000060003
oda<01U<0_lLg`03oda<01U<00?ogml06]l00om<C00JC003omoO01[O00?oC4`06D`00ooOg`0Jg`03
oda<01Y<00?o0000100000H0ool5o`H000060003oda<01U<0_lLg`03oda<01U<07CoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l00ol0
000400001P000om<C00IC0;o7=l00om<C00IC01doimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenO
GimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O00?o0000100000H000?oC4`06D`2oacO
00?oC4`06D`0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo74`00ooOg`0Jg`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l00ol0
000400001P000om<C00IC0;o7=l00om<C00IC01doimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenO
GimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O00?o0000100000H000?oC4`06D`2oacO
00?oC4`06D`0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo74`00ooOg`0Jg`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l00ol0
000400001P000om<C00IC0;o7=l00om<C00IC01doimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenO
GimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O00?o0000100000H000?oC4`06D`2oacO
00?oC4`06D`0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo74`00ooOg`0Jg`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l00ol0
000400001P000om<C007C0?o3d`2o`WO0ol@g`03oda<00M<0ol?C00;oimOWenOGimOWel00ol06EnO
GimOWenOGimOWenOGomnm7kdO_Anm7h00ol06WkdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kd0ol06_An
m7kdO_Anm7kdO_Anm7koGimOWenOGimO0ol045nOGimOWenOGimOWenOGol:C0?o3d`00ooOg`07g`?o
4=l00ol0000400001P000om<C00:C003oda<00a<0_l<g`03omoO00gO00?oC4`02T`00om<C00<C01d
oimOWenOGimOWenOGiooWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaO_mn
LGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWonOGimOWenOGimOWenOGol=C003
oda<00a<00?ogml02]l00ooOg`0=g`03o`0000@000060003oda<00M<1?l2C003oda<00U<0_l9g`Co
00COoooo2ml00om<C007C0Co0T`00om<C009C00;oimOWenOGimOWel01?l069oooonOGimOWenOGimO
ogkdO_Anm7kdOPCo01Wdoooom7kdO_Anm7kdO_Com7kdO_Anm7kd00Co01UnooooO_Anm7kdO_Anm7ko
GimOWenOGimO00Co00nOooooWenOGimOWenOGol02T`4o`9<00?oC4`02D`00ooOg`07g`Co00COoooo
2ml00ol0000400001P000om<C006C005oda<C?l00T`00om<C009C0;o2=l01OoOgmoo00;O00?ogml0
2]l00om<C006C005oda<C?l00T`00om<C009C01doimOWenOGimOWonOGiooWenOGomOWenOGimOWeoo
LGiaOW5nLGkoOW5nogiaOW7oLGiaOW5nLGiaO_mnLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGiaoenO
GimOWenOoimOWonOGimOoenOGimOWenOGol9C005oda<C?l00T`00om<C009C003omoO00KO00GogmoO
o`02g`03omoO00[O00?o0000100000H000?oC4`01T`01Om<C4co00=<00?oC4`024`2o`SO00GogmoO
o`02g`03omoO00[O00?oC4`01T`01Om<C4co00=<00?oC4`024`0M?nOGimOWenOGiooWenOoimOWeoo
GimOWenOGimOogkdO_Anm7kdooAnm?odO_AnogkdO_Anm7kdO_Com7kdO_Anm7koO_AnogkdO_Com7kd
O_Anm7kdO_mOWenOGimOWonOGiooWenOGomOWenOGimOWeoo2D`01Om<C4co00=<00?oC4`024`00ooO
g`06g`05omoOgol00]l00ooOg`0:g`03o`0000@000060003oda<00I<00GoC4a<o`03C003oda<00Q<
0_l8g`05omoOgol00]l00ooOg`0:g`03oda<00I<00GoC4a<o`03C003oda<00Q<017oWenOGimOWenO
oimOWonOG`02o`0IWenOGimOWenOGomaOW5nLGiaO_mnLGkoOP03o`0JOW5nLGiaOW5nLGkoOW5nLGia
OW7oLGiaog43o`0KLGiaOW5nLGiaOW7oGimOWenOGiooWenOoimO00;o00^OGimOWenOGimOo`09C005
oda<C?l00d`00om<C008C003omoO00KO00GogmoOo`02g`03omoO00[O00?o0000100000H000?oC4`0
1d`5o`=<00?oC4`01d`2o`WO1Ol00moog`0;g`03oda<00M<1Ol3C003oda<00M<00_oWenOGimOWenO
G`05o`0GGimOoenOGimOWenOGomnm7kdO_Anm7h01_l05oAnm7kdO_Anm7kdO_Com7kdO_Anm7kd00Ko
01Mnm7kdO_Anm7kdO_AnoenOGimOWenOG`05o`0>GimOoenOGimOWenOGol:C0Go0d`00om<C007C003
omoO00OO1Ol00moog`0;g`03o`0000@000060003oda<00a<1?l9C0;o3]l2o`cO00?oC4`034`4o`U<
013oWenOGimOWenOGimOWenO0ol06ImOWenOGimOWeooLGiaOW5nLGiaOW5nLGh01?l06G5nLGiaOW5n
LGkoOW5nLGiaOW5nLGiaOW401?l06GiaOW5nLGiaOW7oGimOWenOGimOWenOGil00ol02imOWenOGimO
Weoo00m<1?l9C003omoO00cO0_l<g`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml0
6]l00ol0000400001P000om<C00IC0;o7=l00om<C00IC01doimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O00?o0000100000H000?oC4`0
6D`2oacO00?oC4`06D`0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo74`00ooOg`0Jg`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml0
6]l00ol0000400001P000om<C00IC0;o7=l00om<C00IC01doimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O00?o0000100000H000?oC4`0
6D`2oacO00?oC4`06D`0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo74`00ooOg`0Jg`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml0
6]l00ol0000400001P000om<C00IC0;o7=l00om<C00IC01doimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O00?o0000100000H000?oC4`0
6D`2oacO00?oC4`06D`0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo74`00ooOg`0Jg`03o`0000@000060003oda<01U<0_lLg`03oda<01U<07CoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml0
6]l00ol0000400001P3oo`Go1P0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`0j
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<
00?ogml06]l0>_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolLC003o`0000@00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l0>_od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003
omoO01[O03[oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo74`00ol0000400001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO03[oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo74`00ooO
g`0Jg`0jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoaa<00?o0000100000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0jooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml0
6]l0>_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimO
WolLC003o`0000@00006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l0>_mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O
03[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
74`00ol0000400001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO03[om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo74`00ooOg`0Jg`0j
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<
00?o0000100000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`0jogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l0>_ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLC003
o`0000@00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l0>_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O03[oO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo74`00ol0
000400001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO03[oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo74`00ooOg`0Jg`0jog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<00?o0000
100000H000[om7kdO_Anm7kd0ol03oAnm7kdO_Anm7kdO_Anm002o`WO0ol@g`0:ooAnm7kdO_Anm0?o
01[dO_Anm7kdO_Anm7kdO_CoWenOGimOWenOG`?o011OWenOGimOWenOGimOWeoo2D`3oa1<00?ogml0
1ml3oa3O00[oO_Anm7kdO_An0ol06WkdO_Anm7kdO_Anm7kdO_mOWenOGimOWenO0ol049mOWenOGimO
WenOGimOWol9C0?o44`00ol0000400001P007?mnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGh2o`cO
00?ogml03Ml0>_mnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWonOGimOWenO
GimOWenOGol<C003oda<00e<00?ogml02]l00ooOg`0=g`0jog5nLGiaOW5nLGiaO_mnLGiaOW5nLGia
OW5nLOmOWenOGimOWenOGimOoenOGimOWenOGimOWenOo`a<00?oC4`03D`00ol0000400001P002_od
O_Anm7kdO_@4o`0>O_CoogkdO_Anm7kdO_@2o`WO1?l01=ooool;g`0:ooAnm7kdO_Anm0Co01Unm?oo
O_Anm7kdO_Anm?nOGimOWenOGimO00Co00nOooooWenOGimOWenOGol02D`4o`9<0_l;C003omoO00OO
1?l01=ooool;g`0:ogkdO_Anm7kdOPCo01WdO_oom7kdO_Anm7kdO_mOWenOGimOWenO00Co00mOoooo
GimOWenOGimOWol02D`4o`9<0_l;C003o`0000@00006000LogiaOW5nLGiaog5nLOmaog5nogiaOW5n
LGiaOP;o2=l01OoOgmoo00;O00?ogml02]l0>_mnLGiaOW5nLOmaOW7oLOmaO_mnLGiaOW5nLGkoWenO
GimOWenOoimOWonOGimOoenOGimOWenOGol8C007oda<C?m<o`02C003oda<00Q<00?ogml01]l01OoO
gmoo00;O00?ogml02]l0>_maOW5nLGiaO_mnLGkoO_mnLOmaOW5nLGiaOW7oGimOWenOGimOoenOGomO
WenOoimOWenOGimOWol8C007oda<C?m<o`02C003oda<00Q<00?o0000100000H001com7kdO_Anm7ko
O_AnogkoO_Com7kdO_Anm7kd0_l8g`05omoOgol00]l00ooOg`0:g`0jooAnm7kdO_AnogkdO_mnogkd
ooAnm7kdO_Anm?nOGimOWenOGiooWenOoimOWeooGimOWenOGimOo`Q<00OoC4a<odco009<00?oC4`0
24`00ooOg`06g`05omoOgol00]l00ooOg`0:g`0jogkdO_Anm7kdooAnm?odooAnogkdO_Anm7kdO_mO
WenOGimOWeooGimOoenOGiooWenOGimOWenOo`Q<00OoC4a<odco009<00?oC4`024`00ol000040000
1P003omnLGiaOW5nLOmaOW7oL@03o`0:LGiaOW5nLGiaOP;o2=l01OoOgmoo00;O00?ogml02]l03omn
LGiaOW5nLOmaOW7oL@03o`0KLGiaOW5nLGiaO_nOGimOWenOGiooWenOoimO00;o00^OGimOWenOGimO
o`08C005oda<C?l00T`2o`]<00?ogml01]l01OoOgmoo00;O00?ogml02]l03omaOW5nLGiaO_mnLGko
OP03o`0KOW5nLGiaOW5nLOmOWenOGimOWeooGimOoenO00;o00]OWenOGimOWenOo`08C005oda<C?l0
0T`2o`]<00?o0000100000H000[om7kdO_Anm7kd1_l037kdO_Anm7kdO_Anm0;o2Ml5o`03gooO00_O
00[om7kdO_Anm7kd1_l05gkdO_Anm7kdO_Anm?nOGimOWenOGimO00Go00iOWeooGimOWenOGimOo`U<
1_l2C003oda<00Q<00?ogml01ml5o`03gooO00_O00[oO_Anm7kdO_An1_l05oAnm7kdO_Anm7kdO_mO
WenOGimOWenO00Go00jOGiooWenOGimOWenOo`U<1_l2C003oda<00Q<00?o0000100000H0013oOW5n
LGiaOW5nLGiaOW5n0ol02GiaOW5nLGiaOP02o`kO0_l<g`0@ogiaOW5nLGiaOW5nLGiaOP?o01UnLGia
OW5nLGkoWenOGimOWenOGimOWenO00?o00^OGimOWenOGimOo`0?C0;o2d`00ooOg`0<g`;o3=l04?ma
OW5nLGiaOW5nLGiaOW43o`0ILGiaOW5nLGiaoenOGimOWenOGimOWenOG`03o`0;GimOWenOGimOWol0
3d`2o`]<00?o0000100000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0jooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml0
6]l0>_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimO
WolLC003o`0000@00006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l0>_mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O
03[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
74`00ol0000400001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO03[om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo74`00ooOg`0Jg`0j
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<
00?o0000100000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`0jogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l0>_ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLC003
o`0000@00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l0>_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O03[oO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo74`00ol0
000400001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO03[oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo74`00ooOg`0Jg`0jog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<00?o0000
100000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0jooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l0>_mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLC003o`0000@0
0006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l0>_mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O03[oLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo74`00ol000040000
1P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO03[om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo74`00ooOg`0Jg`0jogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<00?o0000100000H0
01coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`0jogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa<00?ogml06]l0>_maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLC003o`0000@00006000L
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l0>_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLC003omoO01[O03[oO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo74`00ol0000400001P3oo`Go
1P0000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0MooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l07=l0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko01_O01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLg`03o`0000@0
0006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l07OmnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko01cO03_oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0Kg`0Nog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko7=l00ol000040000
1P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO01gom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0Lg`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l06ml07_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoacO00?o0000100000H0
01coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`0MogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l07=l0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o01_O01koLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLg`03o`0000@00006000L
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l07OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co01cO03_oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Ano`0Kg`0NogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co7=l00ol0000400001P007?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO01goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Lg`0kog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl06ml07_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noacO00?o0000100000H001com7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0MooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
7=l0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01_O01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLg`03o`0000@00006000LogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l07OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01cO
03_oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0Kg`0Nog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko7=l00ol0000400001P007?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO01gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Lg`0k
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
6ml07_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoacO00?o0000100000H000[oOW5nLGiaOW5n
0ol03giaOW5nLGiaOW5nLGiaOP02o`WO0ol@g`0:ogiaOW5nLGiaOP?o011nLGiaOW5nLGiaOW5nLGko
2]l3o`oO00[oLGiaOW5nLGia0ol06W5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5n0ol04GiaOW5nLGia
OW5nLGiaOW7o00WO0ol?g`0;og5nLGiaOW5nLGh00ol047iaOW5nLGiaOW5nLGiaO_l9g`?o4=l00ol0
000400001P007?odO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_@2o`cO00?ogml03Ml07OodO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdO_Co00gO00?ogml03=l0>omnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_An
m7kdooAnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7ko00cO00?ogml03=l07_mnm7kdO_Anm7kdO_An
ogkdO_Anm7kdO_Anm7kdo`cO00?ogml03Ml00ol0000400001P002_mnLGiaOW5nLGh4o`0>LOooog5n
LGiaOW5nLGh2o`WO1?l01=ooool;g`0:ogiaOW5nLGiaOPCo00maooooLGiaOW5nLGiaO_l02]l4o`04
goooo`[O00[oLGiaOW5nLGia1?l06GkooomnLGiaOW5nLGiaO_mnLGiaOW5nLGh01?l0477ooomaOW5n
LGiaOW5nLOl9g`Co00COoooo2]l02omaOW5nLGiaOW5n00Co00maooooLGiaOW5nLGiaO_l02Ml4o`04
goooo`_O00?o0000100000H001com7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kd0_l8g`05omoOgol0
0]l00ooOg`0:g`0MooAnm7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm?l02Ml01OoOgmoo00;O00?ogml0
2Ml0>omnm7kdO_Anm?odO_Com7kdO_mnm7kdO_Anm7kdooAnm7kdO_AnogkdO_mnm7kdooAnm7kdO_An
m7ko00SO00GogmoOo`02g`03omoO00WO01koO_Anm7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm?l8g`05
omoOgol00]l00ooOg`0:g`03o`0000@00006000LogiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOP;o
2=l01OoOgmoo00;O00?ogml02]l07OmnLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGko00WO00GogmoO
o`02g`03omoO00WO03_oLGiaOW5nLGkoOW5nogiaOW7oLGiaOW5nLGiaO_mnLGiaOW5nLOmaOW7oLGia
O_mnLGiaOW5nLGiao`08g`05omoOgol00]l00ooOg`09g`0Nog5nLGiaOW5nLOmaOW7oLGiaO_mnLGia
OW5nLGko2=l01OoOgmoo00;O00?ogml02]l00ol0000400001P003oodO_Anm7kdO_mnm7koOP03o`0:
O_Anm7kdO_Anm0;o2=l01OoOgmoo00;O00?ogml02]l03oodO_Anm7kdO_mnm7koOP03o`0;O_Anm7kd
O_Anm?l02Ml01OoOgmoo00;O00?ogml02Ml03omnm7kdO_Anm?odO_Com003o`0Jm7kdO_Anm7kdO_Co
m7kdO_Anm7koO_Anogh3o`0<O_Anm7kdO_Anm7ko2=l01OoOgmoo00;O00?ogml02Ml04?mnm7kdO_An
m7koO_Anogh3o`0;O_Anm7kdO_Anm?l02=l01OoOgmoo00;O00?ogml02]l00ol0000400001P002_mn
LGiaOW5nLGh6o`0<LGiaOW5nLGiaOW5n0_l9g`Go00?Ooml02ml02_mnLGiaOW5nLGh6o`0=LGiaOW5n
LGiaOW5no`0:g`Go00?Ooml02]l02_maOW5nLGiaOW46o`0GOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGh0
1_l03W5nLGiaOW5nLGiaOW7o2Ml5o`03gooO00[O00_oLGiaOW5nLGiaOP06o`0=LGiaOW5nLGiaOW5n
o`09g`Go00?Ooml02ml00ol0000400001P003oodO_Anm7kdO_Anm7kdOP04o`09m7kdO_Anm7kd00;o
3]l2o`cO00oom7kdO_Anm7kdO_Anm7h01?l02_Anm7kdO_Anm?l?g`;o2ml03omnm7kdO_Anm7kdO_An
m004o`0IO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdOP04o`0;m7kdO_Anm7kdO_l03]l2o`_O013oO_An
m7kdO_Anm7kdO_An1?l02_Anm7kdO_Anm?l>g`;o3=l00ol0000400001P007?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2oacO01goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Lg`0kog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl06ml07_ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noacO00?o0000100000H001com7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_lLg`0MooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07=l0>omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01_O01koO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLg`03o`0000@00006000LogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o7=l07OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01cO03_oLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0Kg`0Nog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko7=l00ol0000400001P007?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2oacO01gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Lg`0kogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l06ml07_mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoacO00?o0000100000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_lLg`0MogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07=l0>omaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01_O01koLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_lLg`03o`0000@00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o7=l07OodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01cO03_oO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0Kg`0NogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co7=l00ol0000400001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2oacO01goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Lg`0kog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl06ml07_maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noacO00?o0000100000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_lLg`0MooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07=l0>omnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01_O01koO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lLg`03o`0000@00006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
7=l07OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01cO03_oLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0Kg`0Nog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko7=l00ol0000400001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO
01gom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Lg`0kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l06ml07_mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoacO00?o0000100000H0ool5o`H00006000LoimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO03_oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0KC00NogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co74`00ol0000400001P007?nOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oacO01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0koenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl06d`07_maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noaa<00?o0000100000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_lLg`0MoimOWenOGimOWenOGimOWenOGimOWenOGimOWol07=l0>omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01]<01koO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lLC003o`0000@00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenOGioo01cO03_oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0KC00Nog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko74`00ol0000400001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO
01goWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0koenOGimOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l06d`07_mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoaa<00?o0000100000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0M
oimOWenOGimOWenOGimOWenOGimOWenOGimOWol07=l0>omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01]<01koLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_lLC003o`0000@00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnO
GimOWenOGimOWenOGimOWenOGimOWenOGioo01cO03_oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0KC00NogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co74`00ol0000400001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0Lg`0koenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl06d`07_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noaa<00?o0000100000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0MoimOWenO
GimOWenOGimOWenOGimOWenOGimOWol07=l0>omOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01]<01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lLC003o`0000@00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenO
GimOWenOGimOWenOGimOWenOGioo01cO03_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0KC00Nog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
74`00ol0000400001P002_nOGimOWenOGil3o`0?WenOGimOWenOGimOWenO00;o2Ml3oa3O00[oWenO
GimOWenO0ol049mOWenOGimOWenOGimOWol:g`?o3ml02_mOWenOGimOWel3o`0JGimOWenOGimOWenO
GimOWoodO_Anm7kdO_@3o`0Am7kdO_Anm7kdO_Anm7kdO_l02D`3o`m<00_oO_Anm7kdO_Anm003o`0@
m7kdO_Anm7kdO_Anm7kdo`U<0ol@C003o`0000@00006000LoimOWenOGimOWenOGomOWenOGimOWenO
GimOW`;o3=l00ooOg`0=g`0MoimOWenOGimOWenOGomOWenOGimOWenOGimOWol03Ml00ooOg`0<g`0k
oenOGimOWenOGimOWonOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLOl0
34`00om<C00<C00Nog5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGko34`00om<C00=C003o`0000@0
0006000:oimOWenOGimOW`Co00=OWol00_l02ImOWenOGimOW`02o`WO1?l01=ooool;g`0:oimOWenO
GimOW`Co00=OWol00_l02YmOWenOGimOWol:g`Co00COoooo2]l02_mOWenOGimOWel4o`03Weoo00;o
01AOWenOGimOWenOooAnm7kdO_Anm0Co011nooooO_Anm7kdO_Anm7ko2D`4o`9<0_l:C00;ogkdO_An
m7kdO_@01?l03gkooomnm7kdO_Anm7kdo`09C0Co0T`2o`]<00?o0000100000H001coWenOGimOWeoo
GimOoenOGomOWenOGimOWenO0_l8g`05omoOgol00]l00ooOg`0:g`0MoimOWenOGimOoenOGomOWeoo
GimOWenOGimOWol02Ml01OoOgmoo00;O00?ogml02Ml0>omOWenOGimOWonOGiooWenOoimOWenOGimO
WenOogiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW7o00Q<00OoC4a<odco009<00?oC4`01d`07_ma
OW5nLGiaOW7oLGiaog5nLGkoOW5nLGiaOW5no`Q<00OoC4a<odco009<00?oC4`024`00ol000040000
1P003onOGimOWenOGomOWeooG`04o`09WenOGimOWenO00;o2=l01OoOgmoo00;O00?ogml02]l03onO
GimOWenOGomOWeooG`04o`0:WenOGimOWenOo`WO00GogmoOo`02g`03omoO00WO00ooGimOWenOGioo
WenOoil01?l0:5nOGimOWenOGioom7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdO_l8C007oda<C?m<
o`02C003oda<00M<01koO_Anm7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm?l8C007oda<C?m<o`02C003
oda<00Q<00?o0000100000H001coWenOGimOWeooGimOoeooGomOWenOGimOWenO0_l8g`05omoOgol0
0]l00ooOg`0:g`0MoimOWenOGimOoenOGomOoeooGimOWenOGimOWol02Ml01OoOgmoo00;O00?ogml0
2Ml0;?mOWenOGimOWonOGiooWonOoimOWenOGimOWenOogiaOW5nLGiaog5nLOma0ol0375nLGiaOW5n
LGiao`Q<00GoC4a<o`02C0;o2T`04?maOW5nLGiaOW7oLGiaog43o`0;LGiaOW5nLGiaO_l024`01Om<
C4co009<0_l;C003o`0000@00006000:oimOWenOGimOW`Ko00aOoenOGimOWenOGil2o`WO1Ol00moo
g`0;g`0:oimOWenOGimOW`Ko00eOoenOGimOWenOGioo00[O1Ol00moog`0:g`0:oenOGimOWenOG`Ko
01NOoimOWenOGimOWenOooAnm7kdO_Anm006o`0>O_Anm7kdO_Anm7kdO_l9C0Ko0T`00om<C007C00;
ogkdO_Anm7kdO_@01_l03GkdO_Anm7kdO_Anm?l02D`6o`9<00?oC4`024`00ol0000400001P004?nO
GimOWenOGimOWenOGil2o`0:GimOWenOGimOW`;o3]l2o`cO013oWenOGimOWenOGimOWenO0_l02enO
GimOWenOGioo00oO0_l;g`0@oenOGimOWenOGimOWenOG`;o01ZOGimOWenOGimOWomnLGiaOW5nLGia
OW5nL@Co00]nLGiaOW5nLGiao`0?C0;o2T`04?maOW5nLGiaOW5nLGiaOW44o`0:OW5nLGiaOW5no`m<
0_l;C003o`0000@00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenO
GimOWenOGimOWenOGimOWenOGioo01cO03_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0KC00NogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
74`00ol0000400001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0Lg`0koenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl06d`07_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaa<
00?o0000100000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0MoimOWenOGimOWenO
GimOWenOGimOWenOGimOWol07=l0>omOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7ko01]<01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003
o`0000@00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01cO03_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiao`0KC00Nog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko74`00ol0
000400001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0Lg`0koenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l06d`07_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaa<00?o0000
100000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0MoimOWenOGimOWenOGimOWenO
GimOWenOGimOWol07=l0>omOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01]<01koLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lLC003o`0000@0
0006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01cO03_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0KC00NogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co74`00ol000040000
1P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO01goWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0Lg`0koenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl06d`07_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaa<00?o0000100000H0
01coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0MoimOWenOGimOWenOGimOWenOGimOWenO
GimOWol07=l0>omOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko01]<01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC003o`0000@00006000L
oimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l07OnOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo01cO03_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0KC00Nog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko74`00ol0000400001P3oo`Go
1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenO
GimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimO
WenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@0
0006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l0>_nOGimOWenOGimOWenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03omoO01[O03[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol000040000
1P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO03[oWenOGimOWenOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ooOg`0Jg`0joenOGimOWenOGimO
WenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H0
01coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000L
oimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
GiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03omoO01[O03[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?nO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ooOg`0Jg`0joenOGimOWenOGimOWenOGimO
WenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H001coWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000LoimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolLg`03omoO01[O03[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?nOGimOWenO
GimOWenOGimOWenOGimOWenOGil2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo7=l00ooOg`0Jg`0joenOGimOWenOGimOWenOGimOWenOGimO
WenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H001coWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000:oimOWenOGimOW`?o
00nOGimOWenOGimOWenOGil00_l9g`?o4=l02_nOGimOWenOGil3o`0JWenOGimOWenOGimOWenOoimO
WenOGimOWel3o`0@GimOWenOGimOWenOGimOo`WO0ol@g`03omoO00OO0ol@g`0:oenOGimOWenOG`?o
01YOWenOGimOWenOGimOWeooGimOWenOGimOW`?o012OGimOWenOGimOWenOGioo2Ml3oa3O00?o0000
100000H001coWenOGimOWenOGimOoenOGimOWenOGimOWenO0_l<g`03omoO00gO03[oWenOGimOWenO
GimOoenOGimOWenOGimOWenOoimOWenOGimOWenOGiooWenOGimOWenOGimOWeoo3=l00ooOg`0=g`03
omoO00[O00?ogml03Ml0>_mOWenOGimOWenOGiooWenOGimOWenOGimOWeooGimOWenOGimOWenOGomO
WenOGimOWenOGimOWol<g`03omoO00gO00?o0000100000H000[oWenOGimOWenO1?l03UoooomOWenO
GimOWenO0_l9g`Co00COoooo2ml02_nOGimOWenOGil4o`0IGooooenOGimOWenOGiooWenOGimOWenO
G`04o`0?WooooimOWenOGimOWeoo00WO1?l01=ooool;g`03omoO00OO1?l01=ooool;g`0:oenOGimO
WenOG`Co01VOooooWenOGimOWenOGomOWenOGimOWenO00Co00mOooooGimOWenOGimOWol02Ml4o`04
goooo`_O00?o0000100000H001coWenOGimOWeooGimOoenOGiooWenOGimOWenO0_l8g`05omoOgol0
0]l00ooOg`0:g`0joimOWenOGimOoenOGomOWenOoimOWenOGimOWonOGimOWenOGiooWenOoimOWeoo
GimOWenOGimOo`SO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml02]l0>_mO
WenOGimOWonOGiooWenOGomOWenOGimOWeooGimOWenOGimOoenOGomOWenOoimOWenOGimOWol8g`05
omoOgol00]l00ooOg`0:g`03o`0000@00006000LoimOWenOGimOoenOGomOWenOoimOWenOGimOW`;o
2=l01OoOgmoo00;O00?ogml02]l0>_nOGimOWenOGomOWeooGimOWonOGimOWenOGiooWenOGimOWenO
oimOWonOGimOoenOGimOWenOGol8g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03
omoO00[O03[oGimOWenOGiooWenOoimOWeooGimOWenOGimOoenOGimOWenOGomOWeooGimOWonOGimO
WenOGioo2=l01OoOgmoo00;O00?ogml02]l00ol0000400001P004?nOGimOWenOGomOWeooGil2o`0:
GimOWenOGimOW`;o2=l01OoOgmoo00;O00?ogml02]l04?nOGimOWenOGomOWeooGil2o`0KGimOWenO
GimOWonOGimOWenOGiooWenOoimO00;o00^OGimOWenOGimOo`08g`05omoOgol00]l00ooOg`0:g`03
omoO00KO00GogmoOo`02g`03omoO00[O013oGimOWenOGiooWenOoimO0_l06imOWenOGimOWeooGimO
WenOGimOoenOGomOW`02o`0;GimOWenOGimOWol02=l01OoOgmoo00;O00?ogml02]l00ol000040000
1P002_nOGimOWenOGil5o`0=WenOoimOWenOGimOW`02o`WO1Ol00moog`0;g`0:oimOWenOGimOW`Go
01ROGiooWenOGimOWenOoimOWenOGimOWel5o`0>GimOoenOGimOWenOGol9g`Go00?Ooml02ml00ooO
g`07g`Go00?Ooml02ml02_mOWenOGimOWel5o`0HGimOoenOGimOWenOGomOWenOGimOWenO1Ol03YmO
WonOGimOWenOGioo2Ml5o`03gooO00_O00?o0000100000H000ooWenOGimOWenOGimOWel00ol02UnO
GimOWenOGil2o`kO0_l<g`0?oimOWenOGimOWenOGimO00?o01YOWenOGimOWenOoimOWenOGimOWenO
GimOW`?o00^OGimOWenOGimOo`0>g`;o3=l00ooOg`0<g`;o3=l03omOWenOGimOWenOGimOW`03o`0J
WenOGimOWenOGomOWenOGimOWenOGimOWel3o`0;GimOWenOGimOWol03]l2o`cO00?o0000100000H0
01coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000L
oimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
GiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLg`03omoO01[O03[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?nO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7=l00ooOg`0Jg`0joenOGimOWenOGimOWenOGimO
WenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H001coWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000LoimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolLg`03omoO01[O03[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?nOGimOWenO
GimOWenOGimOWenOGimOWenOGil2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo7=l00ooOg`0Jg`0joenOGimOWenOGimOWenOGimOWenOGimO
WenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H001coWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@00006000LoimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolLg`03omoO01[O03[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo7=l00ol0000400001P007?nOGimOWenOGimOWenO
GimOWenOGimOWenOGil2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo7=l00ooOg`0Jg`0joenOGimOWenOGimOWenOGimOWenOGimOWenOGomO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoacO00?o0000100000H001coWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoacO00?ogml06]l0>_mOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolLg`03o`0000@000060?oo1Ol600001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC003oda<01Y<00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003
o`0000@000060003omoO01WO0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?oC4`06T`00ol0000400001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlLC003oda<01Y<00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`00om<C00JC003
o`0000@000060003omoO01WO0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?oC4`06T`00ol0000400001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC003oda<01Y<00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003
o`0000@000060003omoO01WO0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?oC4`06T`00ol0000400001P000ooOg`07g`?o
3ml2o`WO0ol@g`03omoO00OO0ol?g`0;oimOWenOGimOWel00ol06EnOGimOWenOGimOWenOGomOWenO
GimOWel00ol06UnOGimOWenOGimOWenOGiooOW5nLGiaOW5n0ol06WiaOW5nLGiaOW5nLGiaOW7oLGia
OW5nLGia0ol0475nLGiaOW5nLGiaOW5nLOl:C0?o3d`00om<C007C0?o44`00ol0000400001P000ooO
g`0:g`03omoO00cO0_l<g`03omoO00gO00?ogml02]l00ooOg`0<g`1doimOWenOGimOWenOGiooWenO
GimOWenOGimOWeooGimOWenOGimOWenOoimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_AnogkdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_l=C003oda<00a<00?oC4`02T`00om<
C00=C003o`0000@000060003omoO00OO1?l00mooo`02o`WO0_l9g`Co00COoooo2ml00ooOg`07g`Co
00?Oool00_l9g`0;oimOWenOGimOWel01?l069oooonOGimOWenOGimOoenOGimOWenOG`Co00>OGol0
0_l055nOGimOWenOGiooOW5nLGiaOW5n1?l06G7ooomaOW5nLGiaOW5nLOmaOW5nLGiaOW401?l03gia
oomnLGiaOW5nLGiao`0:C0Co0T`00om<C009C003oda<00M<1?l2C0;o2d`00ol0000400001P000ooO
g`06g`05omoOgol00]l00ooOg`09g`;o2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol0
0]l00ooOg`09g`1doimOWenOGimOWonOGiooWenOGomOWenOGimOWeooGimOWenOGiooWenOoimOWonO
GimOWenOGimOWoodO_Anm7kdO_mnm7koO_Anm?odO_Anm7kdO_AnogkdO_Anm7kdooAnm?odooAnogkd
O_Anm7kdO_l9C005oda<C?l00T`00om<C009C003oda<00I<00OoC4a<odco009<00?oC4`024`00ol0
000400001P000ooOg`06g`05omoOgol00ml00ooOg`08g`;o2=l01OoOgmoo00;O00?ogml02]l00ooO
g`06g`05omoOgol00ml00ooOg`08g`0/oimOWenOGimOWonOGiooWenOGomOWenOGimOWeooGimOWenO
GiooWenOoil4o`14GimOWenOGimOWomnLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGiaog5nLGiaOW5n
ogiaO_mnogiaog5nLGiaOW5nLOl9C005oda<C?l00d`00om<C008C003oda<00I<00OoC4a<odco009<
00?oC4`024`00ol0000400001P000ooOg`06g`05omoOgol01=l00ooOg`07g`;o2=l01OoOgmoo00;O
00?ogml02]l00ooOg`06g`05omoOgol01=l00ooOg`07g`0AoimOWenOGimOWonOGiooWel00_l0=YmO
WenOGimOWeooGimOWenOGiooWenOoiooWonOGimOWenOGimOWoodO_Anm7kdO_mnm7koOP?o01Ynm7kd
O_Anm7kdO_mnm7kdO_Anm?odO_Com0?o00_dO_Anm7kdO_Ano`09C005oda<C?l00d`00om<C008C003
oda<00I<00GoC4a<o`02C0;o2d`00ol0000400001P000ooOg`07g`Ko0]l00ooOg`07g`;o2Ml5o`03
gooO00_O00?ogml01ml6o`;O00?ogml01ml02onOGimOWenOGimO00Go01MOWeooGimOWenOGimOoenO
GimOWenOG`06o`0GWonOGimOWenOGimOWomnLGiaOW5nLGh01_l05g5nLGiaOW5nLGiaOW7oLGiaOW5n
LGia00Ko00enLGiaOW5nLGiaOW7o00Y<1Ol3C003oda<00M<00?oC4`01d`6o`9<00?oC4`024`00ol0
000400001P000ooOg`0=g`;o2]l2o`kO0_l<g`03omoO00gO0_l:g`0@oimOWenOGimOWenOGimOW`?o
01ZOGimOWenOGimOoenOGimOWenOGimOWenOG`;o01ZOGimOWenOGimOWoodO_Anm7kdO_Anm7kdOPCo
01[dO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdOP?o00Ynm7kdO_Anm7ko3d`4o`U<00?oC4`03D`2o`]<
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003o`0000@000060003omoO01WO
0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<00?oC4`06T`00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC003oda<01Y<
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`00om<C00JC003o`0000@000060003omoO01WO
0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaa<00?oC4`06T`00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC003oda<01Y<
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003o`0000@000060003omoO01WO
0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<00?oC4`06T`00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`1doimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC003oda<01Y<
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`00om<C00JC003o`0000@000060003omoO01WO
0_lLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaa<00?oC4`06T`00ol0000400001P3oo`Go1P0000H000?ogml06Ml2oacO00?ogml0
6Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol000040000
1P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml0
6]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03
omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO00?ogml0
6Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol000040000
1P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml0
6]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03
omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO00?ogml0
6Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol000040000
1P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml0
6]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03
omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml01ml3o`oO0_l9g`?o
4=l00ooOg`07g`?o3ml00ooOg`08g`?o3ml00ooOg`07g`?o4=l00ooOg`07g`?o4=l00ooOg`07g`?o
3ml00ooOg`08g`?o3ml00ooOg`07g`?o4=l00ol0000400001P000ooOg`0:g`03omoO00cO0_l<g`03
omoO00gO00?ogml02]l00ooOg`0<g`03omoO00_O00?ogml03=l00ooOg`0:g`03omoO00gO00?ogml0
2]l00ooOg`0=g`03omoO00[O00?ogml03=l00ooOg`0;g`03omoO00cO00?ogml02]l00ooOg`0=g`03
o`0000@000060003omoO00OO1?l01=ooool:g`;o2Ml4o`04goooo`_O00?ogml01ml4o`04goooo`[O
00?ogml02=l4o`04goooo`[O00?ogml01ml4o`04goooo`_O00?ogml01ml4o`04goooo`_O00?ogml0
1ml4o`04goooo`[O00?ogml02=l4o`04goooo`[O00?ogml01ml4o`04goooo`_O00?o0000100000H0
00?ogml01]l01OoOgmoo00;O00?ogml02Ml2o`SO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoO
gmoo00;O00?ogml02Ml00ooOg`07g`05omoOgol00]l00ooOg`09g`03omoO00KO00GogmoOo`02g`03
omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`03
omoO00OO00GogmoOo`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O00?ogml02]l00ol000040000
1P000ooOg`06g`05omoOgol00]l00ooOg`09g`;o2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05
omoOgol00]l00ooOg`09g`03omoO00OO00GogmoOo`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O
00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO
00?ogml01ml01OoOgmoo00;O00?ogml02Ml00ooOg`06g`05omoOgol00]l00ooOg`0:g`03o`0000@0
00060003omoO00KO00GogmoOo`02g`03omoO00WO0_l8g`05omoOgol00]l00ooOg`0:g`03omoO00KO
00GogmoOo`02g`03omoO00WO00?ogml01ml01OoOgmoo00;O00?ogml02Ml00ooOg`06g`05omoOgol0
0]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml0
2Ml00ooOg`07g`05omoOgol00]l00ooOg`09g`03omoO00KO00GogmoOo`02g`03omoO00[O00?o0000
100000H000?ogml01ml5o`03gooO00[O0_l9g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02]l00ooO
g`08g`Go00?Ooml02]l00ooOg`07g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02ml00ooOg`07g`Go
00?Ooml02]l00ooOg`08g`Go00?Ooml02]l00ooOg`07g`Go00?Ooml02ml00ol0000400001P000ooO
g`0<g`;o2ml2o`kO0_l<g`03omoO00cO0_l;g`03omoO00gO0_l;g`03omoO00cO0_l<g`03omoO00cO
0_l<g`03omoO00cO0_l;g`03omoO00gO0_l;g`03omoO00cO0_l<g`03o`0000@000060003omoO01WO
0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooO
g`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O
00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO
0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooO
g`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O
00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO
0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O
00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooO
g`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O
00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO
0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O
00?o0000100000D0ool6o`H000050?oo1_l600001P000ol0000H00?o7=l00ooOg`0Ig`1doimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC003oda<01Y<
00?o0000100000H000?o00005`001?l0oolLg`03omoO01WO07CoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<00?oC4`06T`00ol0000400001P000ol0
000F0003o`0000;o7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenO
GimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lLC003oda<01Y<00?o0000100000H000?o00005@001?l00002oacO
00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o74`00om<C00JC003o`0000@000060003o`0001@000?o00000P02oacO00?ogml06Ml0M?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`00om<
C00JC003o`0000@000060003o`0001<000?o00000`02oacO00?ogml06Ml0M?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003o`0000@0
00060003o`0000@00_l00`3oo`090003o`0000@00_lLg`03omoO01WO07CoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?oC4`06T`00ol000040000
1P000ol000050003o`3o00T000?o00001@02oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003o`0000@000060003
o`0000H000?o00001`000ol0000600;o7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC003oda<01Y<00?o0000100000H000?o0000
1@000ol0o`070003o`0000L00_l9g`?o4=l00ooOg`07g`?o3ml02onOGimOWenOGimO00?o01UOWenO
GimOWenOGimOWeooGimOWenOGimO00?o01YOWenOGimOWenOGimOWenOogiaOW5nLGiaOP?o01YnLGia
OW5nLGiaOW5nLGiaog5nLGiaOW5nL@?o011aOW5nLGiaOW5nLGiaOW7o2T`3o`m<00?oC4`01d`3oa1<
00?o0000100000H000?o00001002o`030?oo00D000?o00002002o`cO00?ogml03Ml00ooOg`0:g`03
omoO00cO07CoWenOGimOWenOGimOWonOGimOWenOGimOWenOGomOWenOGimOWenOGiooWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kd
O_Ano`e<00?oC4`034`00om<C00:C003oda<00e<00?o0000100000H000?o00003@000ol0000900;o
2Ml4o`04goooo`_O00?ogml01ml4o`03gooo00;o2Ml02onOGimOWenOGimO00Co01ROooooWenOGimO
WenOGomOWenOGimOWel4o`03Weoo00;o01AOWenOGimOWenOogiaOW5nLGiaOPCo01UaooooLGiaOW5n
LGiaOW7oLGiaOW5nLGia00Co00mnLOooOW5nLGiaOW5nLOl02T`4o`9<00?oC4`02D`00om<C007C0Co
0T`2o`]<00?o0000100000H000?o000030000ol0000:00;o2=l01OoOgmoo00;O00?ogml02]l00ooO
g`06g`05omoOgol00]l00ooOg`09g`1doimOWenOGimOWonOGiooWenOGomOWenOGimOWeooGimOWenO
GiooWenOoimOWonOGimOWenOGimOWoodO_Anm7kdO_mnm7koO_Anm?odO_Anm7kdO_AnogkdO_Anm7kd
ooAnm?odooAnogkdO_Anm7kdO_l9C005oda<C?l00T`00om<C009C003oda<00I<00OoC4a<odco009<
00?oC4`024`00ol0000400001P000ol0000;0003o`0000/00_l8g`05omoOgol00]l00ooOg`0:g`03
omoO00KO00GogmoOo`03g`03omoO00SO02coWenOGimOWenOoimOWonOGimOoenOGimOWenOGomOWenO
GimOWonOGiooW`Co04AOWenOGimOWenOogiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW7oLGiaOW5n
LGkoOW5nogkoOW7oLGiaOW5nLGiao`U<00GoC4a<o`03C003oda<00Q<00?oC4`01T`01om<C4coC?l0
0T`00om<C008C003o`0000@000060003o`0000X000?o00003002o`SO00GogmoOo`02g`03omoO00[O
00?ogml01]l01OoOgmoo00CO00?ogml01ml04OnOGimOWenOGiooWenOoimO00;o03JOGimOWenOGimO
oenOGimOWenOoimOWonOoiooWenOGimOWenOGioom7kdO_Anm7koO_Anogh3o`0JO_Anm7kdO_Anm7ko
O_Anm7kdO_Com7kdoo@3o`0;m7kdO_Anm7kdO_l02D`01Om<C4co00=<00?oC4`024`00om<C006C005
oda<C?l00T`2o`]<00?o0000100000H000?o00002@000ol0000400?o1P02o`WO1Ol00moog`0;g`03
omoO00OO1_l2g`03omoO00OO00_oWenOGimOWenOG`05o`0GGimOoenOGimOWenOGomOWenOGimOWel0
1_l05iooWenOGimOWenOGiooOW5nLGiaOW5n00Ko01MaOW5nLGiaOW5nLGiaog5nLGiaOW5nL@06o`0=
OW5nLGiaOW5nLGiao`0:C0Go0d`00om<C007C003oda<00M<1_l2C003oda<00Q<00?o0000100000H0
00?o000020000ol000060003o`0000D00_l>g`;o3=l00ooOg`0=g`;o2]l04?nOGimOWenOGimOWenO
Gil3o`0JWenOGimOWenOGomOWenOGimOWenOGimOWel2o`0JWenOGimOWenOGioom7kdO_Anm7kdO_An
m7h4o`0Jm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7h3o`0:O_Anm7kdO_Ano`m<1?l9C003oda<00e<
0_l;C003o`0000@000060003o`0000L000?o000020000ol0000400;o7=l00ooOg`0Ig`1doimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC003oda<01Y<
00?o0000100000H000?o00001P000ol000090003o`0000@00_lLg`03omoO01WO07CoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?oC4`06T`00ol0
000400001P000ol000050003o`0000T000?o0?l01@02oacO00?ogml06Ml0M?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003o`0000@0
00060003o`0000@000?o00002P000ol0o`0500;o7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC003oda<01Y<00?o0000100000H0
00?o00000`000ol0000:00;o00<0ool01002oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`00om<C00JC003o`0000@000060003
o`00008000?o00005002oacO00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenO
GimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`00om<C00JC003o`0000@000060005o`000?l05`02oacO
00?ogml06Ml0M?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o74`00om<C00JC003o`0000@000060004o`00oaP00_lLg`03omoO01WO07CoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<00?oC4`06T`00ol0
000400001P000ol0o`0I00;o7=l00ooOg`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC003oda<01Y<00?o0000100000H00_lJ00;o7=l00ooO
g`0Ig`1doimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lLC003oda<01Y<00?o0000100000H0ool5o`H0000R00;ok0000?l04@000?l04@000?l04@000?l0
4@000?l04@000?l04@000?l04@000?l04@000?l04@00024000?o00006P02o`X00_l40003o`000:h0
0ol<000080000ol0000K0003o`0000X000?o00000`000ol0002^0003o`0000/000070006o`000?l0
1Ol00`3oo`03o`800ol30004o`0000Co1003o`<00ol200Go0P000ol0000200?o1@000ol000030003
o`0009D00_l00`3oo`090003o`3o00T000?o00002P0000L000Oo0000o`3o008000?o00000P000ol0
00020004o`00o`8000?o00000P001?l00?l20007o`000?l0o`030005o`000?l010000ol000050003
o`00008000?o00000`000ol0002F0003o`3o00/000?o000020000ol0000:00001`001ol0o`3o0?l0
0P000ol000020003o`00008000?o00000`000ol000020004o`00o`8000Oo0000o`3o00<000Go0000
o`040003o`0000D000?o00000P000ol000030003o`0009L000?o00002005o`L000?o0?l02`0000L0
00Oo0?l0o`3o008000?o00000P000ol000020003o`0000<000?o00000P03o`<000Oo0000o`3o00<0
00Go0000o`040003o`0000<00_l50003o`0000<000?o0000UP000ol0o`0;0003o`0000L000?o0?l0
2`0000L00_l00`3oo`02o`030?oo00@000Co00001?l30003o`00008000Co003o0`03o`<00ol40003
o`00008000?o00001@000ol000020003o`0000<000?o0000U@02o`030?oo01<00_l00`3oo`0:0000
1P02o`<00_l80003o`00008000?o000010000ol00004oa4000?o00000P02o`<00ol400;o10000ol0
002m00004`03o`@000?o00006P03omH0003o0140003o01400000\
\>"],
  ImageRangeCache->{{{0, 271.812}, {287, 0}} -> {-1.22505, -0.239038, 
  0.034767, 0.034767}},
  CellTags->"QuotientRings"]
}, Open  ]],

Cell["3.7 Extension ringoids", "Subsection",
  CellTags->{"ExtensionRings", "i:18"}],

Cell[TextData[{
  "The time and memory needed to evaluate interesting expressions on large \
ringoids is unacceptably high. In order to make it feasible to work with \
polynomials, matrices, and functions over a ringoid, an extension ring \
structure has been created. In the case of matrices and functions, these \
extension rings are still finite, but they grow in proportion to ",
  Cell[BoxData[
      \(TraditionalForm\`n\^\(n\^2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`n\^n\)]],
  " (where ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is the order of the base ring). All but the most trivial cases become \
awkward to implement as ",
  StyleBox["Ringoids", "MR"],
  ". Of course, polynomial rings are infinite and representation as a finite \
",
  StyleBox["Ringoid", "MR"],
  " is out of the question. "
}], "Text",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PolynomialsOver",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["generate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomials",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["over",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["MatricesOver",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"m", 
                        StyleBox[",",
                          "MR"], " ", "n"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["generate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["m",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ by\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ matrices\ over\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["MatricesOver",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["generate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ by\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ matrices\ over\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["FunctionsOver",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["generate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["functions",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->"ExtensionRings"],

Cell["Ring extensions.", "Caption",
  CellTags->"ExtensionRings"],

Cell["Here is a polynomial extension.", "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(P = PolynomialsOver[Z[3]]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    \("-Ring of Polynomials over Z[3]-"\)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell["Here is a matrix extension with the same base ring.", "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(M = MatricesOver[Z[3], 2]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"-\"\>", "\[InvisibleSpace]", 
        InterpretationBox[\("Mat"\_"2"\),
          Subscripted[ 
            "Mat"[ "2"]],
          Editable->False], "\[InvisibleSpace]", "\<\"(Z[3])-\"\>"}],
      SequenceForm[ "-", 
        Subscripted[ 
          "Mat"[ "2"]], "(Z[3])-"],
      Editable->False]], "Output",
  CellLabel->"Out[37]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell[TextData[{
  "And here is a function extension, again with the base ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  "."
}], "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(F = FunctionsOver[Z[3]]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    \("-Ring of Functions over Z[3]-"\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell[TextData[{
  "Once an extension is created, its ",
  StyleBox["type",
    FontSlant->"Italic"],
  " can be retrieved."
}], "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ExtensionType, {P, M, F}]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    \({PolyRing, Matrices, FuncRing}\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell["Its base ring is also accessible.", "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[BaseRing, {P, M, F}]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    \({Ringoid[{0, 1, 2}, Mod[#1 + #2, 3]&, Mod[#1\ #2, 3]&], 
      Ringoid[{0, 1, 2}, Mod[#1 + #2, 3]&, Mod[#1\ #2, 3]&], 
      Ringoid[{0, 1, 2}, Mod[#1 + #2, 3]&, Mod[#1\ #2, 3]&]}\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ExtensionType",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ext",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ type\ of\ extension\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox["ext",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["BaseRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ext",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ base\ ring\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox["ext",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ElementQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(x, \ ext\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["x",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ an\ element\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox["ext",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["otherwise",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["Addition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ext",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["addition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ext",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["Multiplication",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ext",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ext",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"ExtensionRings", "i:19"}],

Cell["Defining parameters of an extension.", "Caption",
  CellTags->"ExtensionRings"],

Cell[TextData[{
  "To be a member of the polynomial ring ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " (defined earlier), not only does the element have to be a polynomial \
formed with the special function ",
  StyleBox["Poly", "MR"],
  ", but the correct base ring must also be used in its formation."
}], "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      ElementQ[#, P]&, {p = \ Poly[Z[3], \ x\^2 + \ 2\ x\  - 1], \ \ 
        Poly[Z[4], \ x\^2 + \ 2\ x\  - 1], \ \ x\^2 + \ 2\ x\  - 1}]\)], 
  "Input",
  CellLabel->"In[41]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    \({True, False, False}\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell["Here we form another polynomial.", "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(q\  = \ 
      Poly[Z[3], \ x\^3 + \ 3\ x\  - 2, \ 
        PowersIncrease\  \[Rule] \ RightToLeft]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(x\^3\),
          Subscripted[ 
            x[ 3], {}, {1}],
          Editable->False], "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ 
        Subscripted[ 
          x[ 3], {}, {1}], " + ", 1],
      Editable->False]], "Output",
  CellLabel->"Out[42]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell[TextData[{
  "Here are several ways of adding and multiplying the polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " formed in the last two input cells."
}], "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Addition[P, p, \ q], \ Addition[p, \ q], \ Multiplication[P, p, \ q], 
        \ Multiplication[p, \ q]} // ColumnForm\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(2\ x + x\^2 + x\^3\)},
          {\(2\ x + x\^2 + x\^3\)},
          {\("2" + 2\ x + x\^2 + 2\ x\^3 + 2\ x\^4 + x\^5\)},
          {\("2" + 2\ x + x\^2 + 2\ x\^3 + 2\ x\^4 + x\^5\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {0, 2, 1, 
          1}], 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {0, 2, 1, 
          1}], 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {2, 2, 1, 2, 
          2, 1}], 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {2, 2, 1, 2, 
          2, 1}]}],
      Editable->False]], "Output",
  CellLabel->"Out[43]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell["The following works as well.", "MathCaption",
  CellTags->"ExtensionRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({p\  + \ q, \ p\ q}\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"ExtensionRings"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(2\ x\), "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"2\"\>", "+", \(2\ x\), "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^3\),
              Subscripted[ 
                x[ 3], {}, {1}],
              Editable->False]}], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^5\),
            Subscripted[ 
              x[ 5], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[44]=",
  CellTags->"ExtensionRings"]
}, Open  ]],

Cell["3.8 Polynomials over a ringoid", "Subsection",
  CellTags->{"FormingPolynomials", "i:20"}],

Cell[TextData[{
  "The ",
  StyleBox["PolynomialsOver", "MR"],
  " function returns an extension ringoid representing the ring of \
polynomials over the ringoid ",
  Cell[BoxData[
      FormBox["R", TraditionalForm]]],
  ". A current restriction on ",
  StyleBox["Ringoids", "MR"],
  " is that they must be finite, but over any ring with two or more elements \
there are an infinite number of polynomials. Therefore, the resulting object \
is a ",
  StyleBox["RingExtension", "MR"],
  ". "
}], "Text",
  CellTags->"FormingPolynomials"],

Cell["3.8.1 Forming polynomials", "Subsubsection",
  CellTags->{"FormingPolynomials", "i:21"}],

Cell[TextData[{
  "An individual polynomial over a ringoid ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " is created by entering either an input of the form ",
  StyleBox["Poly", "MR"],
  "[",
  StyleBox["R",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expression",
    FontSlant->"Italic"],
  "] or ",
  StyleBox["Poly", "MR"],
  "[",
  StyleBox["R",
    FontSlant->"Italic"],
  ", ",
  StyleBox["coefficients",
    FontSlant->"Italic"],
  "]."
}], "Text",
  CellTags->"FormingPolynomials"],

Cell[TextData[{
  "Here is a polynomial over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " entered as an expression."
}], "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p = Poly[Z[5], t\^2 + 2\ t + 3]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"3\"\>", "+", \(2\ t\), "+", 
      InterpretationBox[\(t\^2\),
        Subscripted[ 
          t[ 2], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[45]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell["Here is another formed by listing just the coefficients.", "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(q = Poly[Z[5], 4, 3, 2, 1]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"4\"\>", "+", \(3\ x\), "+", 
      RowBox[{"2", " ", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False]}], "+", 
      InterpretationBox[\(x\^3\),
        Subscripted[ 
          x[ 3], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[46]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell[TextData[{
  "The entries in a coefficient sequence are assumed, by default, to start \
with the constant term and increase in degree. The indeterminate is explicit \
when an expression is entered, but when only the coefficients are provided, \
the default is ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The option ",
  StyleBox["Indeterminate", "MR"],
  " can be used to specify an alternate indeterminate. The option ",
  StyleBox["PowersIncrease", "MR"],
  " reflects the order in which the coefficients should be entered, as well \
as specifying the output format."
}], "Text",
  CellTags->"FormingPolynomials"],

Cell["\<\
Here is how to specify an alternate indeterminate when listing \
coefficients.\
\>", "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(r = Poly[Z[5], 1, 0, 2, Indeterminate \[Rule] \[Lambda]]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"1\"\>", "+", 
      RowBox[{"2", " ", 
        InterpretationBox[\(\[Lambda]\^2\),
          Subscripted[ 
            \[Lambda][ 2], {}, {1}],
          Editable->False]}]}]], "Output",
  CellLabel->"Out[47]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell["\<\
Notice that any terms that are missing from a polynomial because \
the coefficient is zero must still be accounted for when giving the list of \
coefficients.\
\>", "Text",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Poly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["expr",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(create\ the\ polynomial\ over\ the\ ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ given\ by\ \),
                  SingleLetterItalics->False], 
                StyleBox["expr",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Poly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["expr",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["create",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomial",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["over",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ given\ by\ \),
                SingleLetterItalics->False], 
              StyleBox["expr",
                FontSlant->"Italic"], 
              StyleBox[\(\ using\ the\ options\ given\ by\ \),
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["Poly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["coeffs",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["create",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coefficients",
                  SingleLetterItalics->False]}], "\n", 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["coeffs",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["using",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    FontSlant->"Italic"], "options", " ", 
                  StyleBox["opts",
                    FontSlant->"Italic"]}]}]}]},
          {
            RowBox[{
              StyleBox["Poly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["PolynomialsOver",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["R",
                    "TI"], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["args",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Poly",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["R",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["args",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"FormingPolynomials", "i:22"}],

Cell[TextData[{
  "Entering polynomials using ",
  StyleBox["Poly",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormingPolynomials"],

Cell[TextData[{
  "There are several options to consider for ",
  StyleBox["Poly", "MR"],
  "."
}], "Text",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["PowersIncrease",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["LeftToRight",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{\(for\ input\), ",", " ", 
                StyleBox[\(determines\ whether\ sequences\ of\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(coefficients\ start\ with\ the\ constant\ or\ leading\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              
              StyleBox[\(coefficient; \ for\ output, \ 
                specifies\ whether\ the\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["powers",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomials",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["increase",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["from",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["right",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["right",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  StyleBox["RightToLeft",
                    "MR"], 
                  StyleBox[")",
                    SingleLetterItalics->False]}]}]}]},
          {
            StyleBox[
              FormBox["Indeterminate",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["x",
                "StandardForm"],
              "Text"], 
            StyleBox[\(indeterminate\ to\ be\ used\ in\ a\ polynomial\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["FlexibleEntering",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["if",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["set",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["to",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["True",
                      "MR"]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[\(allows\ negations\ of\ ring\),
                    SingleLetterItalics->False]}], "\n", 
                StyleBox[\(elements\ in\ polynomial\ expressions\ and\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], "\n", 
                RowBox[{
                  StyleBox["arbitrary",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["integers",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["polynomials",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["over",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(\[DoubleStruckCapitalZ]\_n\),
                      "TraditionalForm"],
                    "Text"]}]}], 
              StyleBox[" ",
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.2, 0.6},
  RowLines->{True, False}},
  CellTags->{"FormingPolynomials", "i:23"}],

Cell[TextData[{
  "Options for ",
  StyleBox["Poly",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormingPolynomials"],

Cell[TextData[{
  "If you are more comfortable entering coefficients starting with the term \
with the highest degree, you can consider the ",
  StyleBox["PowersIncrease", "MR"],
  " option. Use this as an option to ",
  StyleBox["Poly", "MR"],
  " if you want to order the coefficients this way only occasionally."
}], "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Poly[Z[5], 4, 3, 2, 1, PowersIncrease \[Rule] RightToLeft]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"4", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x\^3\),
          Subscripted[ 
            x[ 3], {}, {1}],
          Editable->False], "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False], "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ 4, " ", 
        Subscripted[ 
          x[ 3], {}, {1}], " + ", 3, " ", 
        Subscripted[ 
          x[ 2], {}, {1}], " + ", 2, " ", x, " + ", 1],
      Editable->False]], "Output",
  CellLabel->"Out[48]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell["\<\
If you want to consistently start with the coefficient of the term \
with the highest degree, change the default.\
\>", "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[Poly, PowersIncrease \[Rule] RightToLeft]\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    \({PowersIncrease \[Rule] RightToLeft, Indeterminate \[Rule] x, 
      FlexibleEntering \[Rule] True}\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell["Now this order is the default.", "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Poly[Z[5], 4, 3, 2, 1]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"4", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x\^3\),
          Subscripted[ 
            x[ 3], {}, {1}],
          Editable->False], "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False], "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ 4, " ", 
        Subscripted[ 
          x[ 3], {}, {1}], " + ", 3, " ", 
        Subscripted[ 
          x[ 2], {}, {1}], " + ", 2, " ", x, " + ", 1],
      Editable->False]], "Output",
  CellLabel->"Out[50]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell["\<\
You can always reverse the change and the original ordering is back \
in effect. (Note that we get a completely different polynomial; it is not \
just the output that is affected.)\
\>", "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[Poly, PowersIncrease \[Rule] LeftToRight]; \n
    Poly[Z[5], 4, 3, 2, 1]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"4\"\>", "+", \(3\ x\), "+", 
      RowBox[{"2", " ", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False]}], "+", 
      InterpretationBox[\(x\^3\),
        Subscripted[ 
          x[ 3], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[51]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["FlexibleEntering", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  ", some natural ",
  "extens",
  "ions to notation are allowed. Over the integers mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", any integers can be entered and they are reduced mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Poly[Z[5], x\^2 - x + 11]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"1\"\>", "+", \(4\ x\), "+", 
      InterpretationBox[\(x\^2\),
        Subscripted[ 
          x[ 2], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[52]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell[TextData[{
  "This is not valid if ",
  StyleBox["FlexibleEntering", "MR"],
  " is set to ",
  StyleBox["False", "MR"]
}], "MathCaption",
  CellTags->"FormingPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Poly[Z[5], x\^2 - x + 11, FlexibleEntering \[Rule] False]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    \(MemberQ::"elmnts" \( : \ \) 
      "At least one of \!\(\"the coefficients {11, -1, 1}\"\) is not an \
element of \!\(\" the base ring\"\)."\)], "Message",
  CellTags->"FormingPolynomials"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"FormingPolynomials"]
}, Open  ]],

Cell["3.8.2 Random polynomials", "Subsubsection",
  CellTags->{"RandomPolynomials", "i:24"}],

Cell[TextData[{
  "A request for a random polynomial is meaningless unless an upper limit on \
the degree is specified, so a degree must be specified as a second argument. \
If degree ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is specified, then ",
  Cell[BoxData[
      \(TraditionalForm\`n + 1\)]],
  " random elements from the base ring are selected for coefficients. By \
default, the leading coefficient is usually not allowed to be the zero of the \
ring, so the degree will be exactly ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". Options can be used to control the selection of coefficients to allow a \
degree less than or equal to ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". "
}], "Text",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RandomElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["PolynomialsOver",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["R",
                    "TI"], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ a\ random\ polynomial\ of\ degree\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\ over\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RandomElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["PolynomialsOver",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["R",
                    "TI"], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ a\ random\ polynomial\ of\ degree\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\ \((or\ less)\)\ over\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ according\ to\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RandomElements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["PolynomialsOver",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["R",
                    "TI"], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ \),
                  SingleLetterItalics->False], 
                FormBox["k",
                  "TraditionalForm"], 
                StyleBox[\(\ random\ polynomials\ of\ degree\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\ \((or\ less)\)\ over\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ according\ to\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.47, 0.53}},
  CellTags->{"RandomPolynomials", "i:25"}],

Cell["Obtaining random polynomials.", "Caption",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["NonZero",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                
                StyleBox[
                  \(determines\ whether\ certain\ polynomials\ are\ to\ be\ 
                    excluded\ in\ selecting\ random\ polynomials\),
                  SingleLetterItalics->False], 
                StyleBox[";",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["other",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["possible",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["values",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["are",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["Any",
                    "MR"]}]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["NonUnity",
                "MR"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["NonIdentity",
                "MR"]}]},
          {
            StyleBox[
              FormBox["LowerDegreeOK",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ whether\ the\ requested\ degree\ must\ be\ exact\ 
                or\ whether\ polynomials\ of\ lesser\ degree\ may\ be\ 
                selected\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Monic",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ whether\ the\ random\ polynomial\ \nshould\ be\ 
                monic\ \((
                  leading\ coefficient\ equal\ \nto\ the\ unity\ of\ the\ base
                    \ ringoid)\)\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.24, 0.17, 0.59},
  RowLines->{True, False}},
  CellTags->{"RandomPolynomials", "i:26"}],

Cell[TextData[{
  "Options of ",
  StyleBox["RandomElement",
    FontFamily->"Courier"],
  " for polynomial extensions."
}], "Caption",
  CellTags->"RandomPolynomials"],

Cell[TextData[{
  "Here is a random cubic polynomial over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  "."
}], "MathCaption",
  CellTags->"RandomPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[PolynomialsOver[Z[6]], 3]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"3\"\>", "+", \(5\ x\), "+", 
      RowBox[{"2", " ", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False]}], "+", 
      InterpretationBox[\(x\^3\),
        Subscripted[ 
          x[ 3], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[54]=",
  CellTags->"RandomPolynomials"]
}, Open  ]],

Cell[TextData[{
  "The unity of ",
  Cell[BoxData[
      StyleBox[\(BooleanRing[3]\),
        "MR"]], "Input"],
  " is ",
  StyleBox["{1, 2, 3}.", "MR"]
}], "MathCaption",
  CellTags->"RandomPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[PolynomialsOver[BooleanRing[3]], 2, Monic \[Rule] True]
      \)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"{1, 3}\"\>", "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "\<\"{2, 3}\"\>", "\[InvisibleSpace]", 
        "\<\" \"\>", "\[InvisibleSpace]", "x", "\[InvisibleSpace]", 
        "\<\" + \"\>", "\[InvisibleSpace]", "\<\"{1, 2, 3}\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False]}],
      SequenceForm[ 
      "{1, 3}", " + ", "{2, 3}", " ", x, " + ", "{1, 2, 3}", " ", 
        Subscripted[ 
          x[ 2], {}, {1}]],
      Editable->False]], "Output",
  CellLabel->"Out[55]=",
  CellTags->"RandomPolynomials"]
}, Open  ]],

Cell[TextData[{
  "Over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  ", monic polynomials have a leading coefficient of 1."
}], "MathCaption",
  CellTags->"RandomPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[PolynomialsOver[Z[5]], 2, Monic \[Rule] True]\)], "Input",\

  CellLabel->"In[56]:=",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"2\"\>", "+", \(3\ x\), "+", 
      InterpretationBox[\(x\^2\),
        Subscripted[ 
          x[ 2], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[56]=",
  CellTags->"RandomPolynomials"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["SelectFrom", "MR"],
  " set to ",
  StyleBox["Any", "MR"],
  ", we may expect a zero polynomial here."
}], "MathCaption",
  CellTags->"RandomPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
      RandomElement[PolynomialsOver[Z[2]], 2, LowerDegreeOK \[Rule] True, \ 
        SelectFrom\  \[Rule] \ Any], {8}]\)], "Input",
  CellLabel->"In[57]:=",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False], ",", 
        RowBox[{"\<\"1\"\>", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False], ",", "0", ",", 
        RowBox[{"\<\"1\"\>", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", \("1" + x\)}], "}"}]], "Output",
  CellLabel->"Out[57]=",
  CellTags->"RandomPolynomials"]
}, Open  ]],

Cell["\<\
Here are five random polynomials of degree 2, not requiring them to \
be monic and not allowing replacement.\
\>", "MathCaption",
  CellTags->"RandomPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElements[PolynomialsOver[Z[3]], \ 2, \ 5, \ 
      Monic\  \[Rule] \ False, \ Replacement\  \[Rule] \ False]\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->"RandomPolynomials"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", \(2\ x\), "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}], ",", 
        RowBox[{"\<\"2\"\>", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"2\"\>", "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}], ",", 
        RowBox[{"\<\"2\"\>", "+", "x", "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}], ",", 
        RowBox[{"\<\"2\"\>", "+", \(2\ x\), "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}]}], "}"}]], "Output",
  CellLabel->"Out[58]=",
  CellTags->"RandomPolynomials"]
}, Open  ]],

Cell["3.8.3 Polynomial arithmetic", "Subsubsection",
  CellTags->{"PolynomialArith", "i:27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox["Addition",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["P",
                  FontSlant->"Italic"], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ sum\ of\ polynomials\ \),
                  SingleLetterItalics->False], 
                FormBox["a",
                  "TraditionalForm"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                FormBox["b",
                  "TraditionalForm"], 
                StyleBox[\(\ in\ the\ polynomial\ extension\ \),
                  SingleLetterItalics->False], 
                FormBox["P",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Addition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox[
                        RowBox[{
                          StyleBox["Addition",
                            SingleLetterItalics->False], 
                          StyleBox["[",
                            "MR"], 
                          StyleBox["P",
                            "TI"], 
                          StyleBox["]",
                            "MR"]}],
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["a",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["b",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Addition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["both",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["some",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["extension",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[
                  FormBox[\(P, \),
                    "TraditionalForm"],
                  "Text"], " ", 
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          StyleBox[
                            RowBox[{
                              StyleBox["Addition",
                                SingleLetterItalics->False], 
                              StyleBox["[",
                                "MR"], 
                              StyleBox["P",
                                "TI"], 
                              StyleBox["]",
                                "MR"]}],
                            "MR"], 
                          StyleBox["[",
                            "MR"], 
                          RowBox[{
                            StyleBox["a",
                              "TI"], 
                            StyleBox[",",
                              "TI"], " ", 
                            StyleBox["b",
                              "TI"]}], 
                          StyleBox["]",
                            "TI"]}], 
                        StyleBox[",",
                          "TI"]}], 
                      StyleBox[" ",
                        "TI"]}],
                    "StandardForm"],
                  "Text"], 
                StyleBox["otherwise",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"]}]}]},
          {
            StyleBox[
              FormBox[
                RowBox[{"a", " ", 
                  StyleBox["+",
                    "MR"], " ", "b"}],
                "TraditionalForm"],
              "TI"], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Addition",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["a",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["b",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["Multiplication",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["P",
                  FontSlant->"Italic"], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ product\ of\ polynomials\ \),
                  SingleLetterItalics->False], 
                FormBox["a",
                  "TraditionalForm"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                FormBox["b",
                  "TraditionalForm"], 
                StyleBox[\(\ in\ the\ polynomial\ extension\ \),
                  SingleLetterItalics->False], 
                FormBox["P",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"PolynomialArith", "i:28"}],

Cell["Arithmetic in a polynomial extension.", "Caption",
  CellTags->"PolynomialArith"],

Cell[TextData[{
  "Addition and multiplication of polynomials are defined in the usual way, \
with the coefficients of the sums and products based on calculations in the \
base ring. If the base rings of the polynomial extension and polynomials do \
not match, the result is ",
  StyleBox["$Failed", "MR"],
  ". The multiplication has available all the alternate methods shown for the \
addition."
}], "Text",
  CellTags->"PolynomialArith"],

Cell[TextData[{
  "Here we form polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(P = PolynomialsOver[Z[3]]\)], "Input",
  CellLabel->"In[59]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \("-Ring of Polynomials over Z[3]-"\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
We demonstrate polynomial arithmetic with these two \
polynomials.\
\>", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a = Poly[Z[3], 1 + 2  x\^3 + x\^4], b = Poly[Z[3], x + x\^2 + x\^3]}
      \)], "Input",
  CellLabel->"In[60]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^3\),
              Subscripted[ 
                x[ 3], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[60]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["Here are the four ways of finding the sum.", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({\(Addition[P]\)[a, b], Addition[P, a, b], Addition[a, b], a + b}\)], 
  "Input",
  CellLabel->"In[61]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[61]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["There are analogous ways of finding the product.", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({\(Multiplication[P]\)[a, b], Multiplication[P, a, b], 
      Multiplication[a, b], a\ b, a\ *b}\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^7\),
            Subscripted[ 
              x[ 7], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^7\),
            Subscripted[ 
              x[ 7], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^7\),
            Subscripted[ 
              x[ 7], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^7\),
            Subscripted[ 
              x[ 7], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^7\),
            Subscripted[ 
              x[ 7], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[62]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
Many of the common functions that apply to ringoids also apply to \
polynomial extensions. Here are some of the more important ones.\
\>", "Text",\

  CellTags->"PolynomialArith"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["HasZeroQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["P",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ polynomial\ extension\ \),
                  SingleLetterItalics->False], 
                FormBox["P",
                  "TraditionalForm"], 
                StyleBox[\(\ has\ a\ zero, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Zero",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["P",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["zero",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["P",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ if\ one\ such\ exists, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["$Failed",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["NegationOf",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ negation\ of\ polynomial\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["P",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["coefficients",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["have",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["negation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["base",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ring",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(P, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["WithUnityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["P",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["P",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ has\ a\ unity, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Unity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["P",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["unity",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(P, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["one",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["such",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["exists",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"PolynomialArith", "i:29"}],

Cell["\<\
Examples of general ringoid functions working in a polynomial \
extension.\
\>", "Caption",
  CellTags->"PolynomialArith"],

Cell[TextData[{
  "Recall ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "; its zero is not too surprising."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({P, HasZeroQ[P], Zero[P]}\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \({"-Ring of Polynomials over Z[3]-", True, 0}\)], "Output",
  CellLabel->"Out[63]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["Nor is the unity a surprise.", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(un\  = If[WithUnityQ[P], Unity[P]]\)], "Input",
  CellLabel->"In[64]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \("1"\)], "Output",
  CellLabel->"Out[64]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
What is behind a simple 1 may be a surprise, however. Since it is \
still a polynomial, it uses the (complicated) internal form of a general \
polynomial.\
\>", "MathCaption",
  CellTags->{"PolynomialArith", "i:30"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(un // InputForm\)], "Input",
  CellLabel->"In[65]:=",
  CellTags->"PolynomialArith"],

Cell["\<\
AbstractAlgebra`RingExtensions`Private`poly[{
   AbstractAlgebra`Core`Private`ringoid[{0, 1, 2}, 
    Mod[#1 + #2, 3] & , Mod[#1*#2, 3] & , 
    {{}, {}, {}, {}, {}, 
     {RingoidName -> \"Z[3]\", 
      RingoidDescription -> \"the ring of integers \\
mod 3\", FormatOperator -> False}}], LeftToRight, x, 
   True}, {1}]\
\>", "Output",
  CellLabel->"Out[65]//InputForm=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "All polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " have negations."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NegationOf[P, 
      Poly[Z[3], \ 2  x\^2\  - \ x\  + \ 1, \ 
        PowersIncrease\  \[Rule] \ RightToLeft]]\)], "Input",
  CellLabel->"In[66]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False], "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", "\<\" + \"\>", 
        "\[InvisibleSpace]", "2"}],
      SequenceForm[ 
        Subscripted[ 
          x[ 2], {}, {1}], " + ", x, " + ", 2],
      Editable->False]], "Output",
  CellLabel->"Out[66]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "A distinctive aspect of polynomials is the division property. If ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " are polynomials and the leading coefficient of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " is a unit of the base ring, then there are two unique polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`a\  = \ b\ q\  + \ r\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`r\  = \ 0\)]],
  " or the degree of ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " is less than the degree of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ".",
  " "
}], "Text",
  CellTags->{"PolynomialArith", "i:31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PolynomialDivision",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["pair",
                  SingleLetterItalics->False], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{"{", 
                      RowBox[{
                        StyleBox["q",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"], ",", " ", 
                        StyleBox["r",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"]}], "}"}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["consisting",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["quotient",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["remainder",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["division",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ by\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["PolynomialRemainder",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ remainder\ in\ the\ division\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["a",
                  "TraditionalForm"], 
                StyleBox[\(\ by\ \),
                  SingleLetterItalics->False], 
                FormBox["b",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["PolynomialQuotient",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ quotient\ in\ the\ division\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["a",
                  "TraditionalForm"], 
                StyleBox[\(\ by\ \),
                  SingleLetterItalics->False], 
                FormBox["b",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.36, 0.64}},
  CellTags->{"PolynomialArith", "i:32"}],

Cell["\<\
Extensions of built-in polynomial functions for working in \
polynomial extensions.\
\>", "Caption",
  CellTags->"PolynomialArith"],

Cell["\<\
Note that each of these functions can also be used by giving just \
the two polynomials, assuming that they both have the same base ring. \
Additionally, note that these are extensions of built-in functions, which are \
still available for ordinary polynomials.\
\>", "Text",
  CellTags->"PolynomialArith"],

Cell["\<\
Here we divide a fourth-degree polynomial by a cubic \
polynomial.\
\>", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({q, r} = 
      PolynomialDivision[P, a = Poly[Z[3], 1 + 2  x\^3 + x\^4], 
        b = Poly[Z[3], x + x\^2 + x\^3]]\)], "Input",
  CellLabel->"In[67]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\("1" + x\), ",", 
        RowBox[{"\<\"1\"\>", "+", \(2\ x\), "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[67]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["We can verify that the quotient and remainder are correct.", 
  "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, \(Addition[P]\)[\(Multiplication[P]\)[b, q], r]}\)], "Input",
  CellLabel->"In[68]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^3\),
              Subscripted[ 
                x[ 3], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^3\),
              Subscripted[ 
                x[ 3], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[68]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "Frequently only the remainder, ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", is needed, such as in finite field calculations."
}], "Text",
  CellTags->"PolynomialArith"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider the polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " be a modulus that is irreducible over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(P2 = PolynomialsOver[Z[2]]; \n
    m = Poly[Z[2], \[Alpha]\^2 + \[Alpha] + 1]\)], "Input",
  CellLabel->"In[69]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"\<\"1\"\>", "+", "\[Alpha]", "+", 
      InterpretationBox[\(\[Alpha]\^2\),
        Subscripted[ 
          \[Alpha][ 2], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[69]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "Consider an element ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " in the Galois field of polynomials mod ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t = Poly[Z[2], \[Alpha] + 1]\)], "Input",
  CellLabel->"In[70]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \("1" + \[Alpha]\)], "Output",
  CellLabel->"Out[70]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "To square ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", we multiply it by itself and then divide by the modulus. The result is \
the remainder. (Using functions in ",
  StyleBox["AbstractAlgebra`FiniteFields", "MR"],
  " makes this process easier.)"
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialRemainder[P2, \(Multiplication[P2]\)[t, t], m]\)], "Input",
  CellLabel->"In[71]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \(\[Alpha]\)], "Output",
  CellLabel->"Out[71]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "The base ring does not need to be a field, but the leading coefficient of \
the divisor must be a unit. ",
  "Here the leading coefficient of the divisor is 3, which is a unit of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialDivision[PolynomialsOver[Z[4]], Poly[Z[4], x\^3 + 2\ x + 1], 
      Poly[Z[4], 3\ x + 3]]\)], "Input",
  CellLabel->"In[72]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          RowBox[{"3", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}], ",", "\<\"2\"\>"}], "}"}]], "Output",
  CellLabel->"Out[72]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "This time, the leading coefficient of the divisor is 2, which is not a \
unit of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialDivision[PolynomialsOver[Z[4]], Poly[Z[4], x\^3 + 2\ x + 1], 
      Poly[Z[4], 2\ x + 3]]\)], "Input",
  CellLabel->"In[73]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \(PolynomialDivision::"undef" \( : \ \) 
      "Since the leading coefficient, \!\(2\), is not a unit in \
\!\(\"Z[4]\"\), division is undefined."\)], "Message",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[73]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Textual", "MR"],
  " mode is supported by ",
  StyleBox["PolynomialDivision", "MR"],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialDivision[Poly[ZR[3], x\^3 + 2\ x + 1], Poly[ZR[3], 2\ x + 1], 
      Mode \[Rule] Textual]\)], "Input",
  CellLabel->"In[74]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \("a(x) = b(x)q(x) + r(x) where"\)], "Print",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"a(x) = \"\>", "\[InvisibleSpace]", 
        RowBox[{"\<\"1\"\>", "+", \(2\ x\), "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], "\[InvisibleSpace]", "\<\",\"\>"}],
      SequenceForm[ "a(x) = ", 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {1, 2, 0, 1}], 
        ","],
      Editable->False]], "Print",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    InterpretationBox[
      \("b(x) = "\[InvisibleSpace]\("1" + 2\ x\)\[InvisibleSpace]","\),
      SequenceForm[ "b(x) = ", 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {1, 2}], ","],
      Editable->False]], "Print",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"q(x) = \"\>", "\[InvisibleSpace]", 
        RowBox[{\(2\ x\), "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}], "\[InvisibleSpace]", "\<\" and\"\>"}],
      SequenceForm[ "q(x) = ", 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {0, 2, 2}], 
        " and"],
      Editable->False]], "Print",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    InterpretationBox[\("r(x) = "\[InvisibleSpace]"1"\[InvisibleSpace]"."\),
      SequenceForm[ "r(x) = ", 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {1}], "."],
      Editable->False]], "Print",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \("Notice that either r(x) = 0 or deg r < deg b."\)], "Print",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(2\ x\), "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}]}], ",", "\<\"1\"\>"}], "}"}]], "Output",
  CellLabel->"Out[74]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
The Euclidean algorithm for computing the greatest common factor of \
two polynomials has been implemented over a ringoid. The algorithm fails if \
any of the polynomial divisions are undefined.\
\>", "Text",
  CellTags->{"PolynomialArith", "i:34"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PolynomialGCD",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["greatest",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["common",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["divisor",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomials",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["a",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["b",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ in\ the\ polynomial\ extension\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["P",
                  "TraditionalForm"],
                "Text"]}]},
          {
            StyleBox[
              FormBox[
                RowBox[{
                  RowBox[{
                    StyleBox["PolynomialGCD",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{"a", 
                      StyleBox[",",
                        "MR"], " ", "b"}], 
                    StyleBox["]",
                      "MR"]}], " "}],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              StyleBox[\(if\ both\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["a",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["b",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(P, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["PolynomialGCD",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{
                      StyleBox["P",
                        "TI"], 
                      StyleBox[",",
                        "TI"], " ", 
                      StyleBox["a",
                        "TI"], 
                      StyleBox[",",
                        "TI"], " ", 
                      StyleBox["b",
                        "TI"]}], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["PolynomialLCM",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["b",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(return\ the\ least\ common\ multiple\ of\ the\ polynomials\ 
                \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["a",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["b",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["P",
                  "TraditionalForm"],
                "Text"]}]},
          {
            StyleBox[
              FormBox[
                RowBox[{
                  RowBox[{
                    StyleBox["PolynomialLCM",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{"a", 
                      StyleBox[",",
                        "MR"], " ", "b"}], 
                    StyleBox["]",
                      "MR"]}], " "}],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              StyleBox[\(if\ both\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["a",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["b",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(P, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["PolynomialLCM",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{
                      StyleBox["P",
                        "TI"], 
                      StyleBox[",",
                        "TI"], " ", 
                      StyleBox["a",
                        "TI"], 
                      StyleBox[",",
                        "TI"], " ", 
                      StyleBox["b",
                        "TI"]}], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.37, 0.63}},
  CellTags->{"PolynomialArith", "i:33"}],

Cell["GCD and LCM on polynomial extensions.", "Caption",
  CellTags->"PolynomialArith"],

Cell[TextData[{
  "Here are two new polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  "."
}], "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a = Poly[Z[3], x\^5 + x\^4 + 2\ x\^3 + x + 1], 
      b = Poly[Z[3], x\^4 + 2]}\)], "Input",
  CellLabel->"In[75]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^3\),
              Subscripted[ 
                x[ 3], {}, {1}],
              Editable->False]}], "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^5\),
            Subscripted[ 
              x[ 5], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"2\"\>", "+", 
          InterpretationBox[\(x\^4\),
            Subscripted[ 
              x[ 4], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[75]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
Here is their greatest common divisor and least common \
multiple.\
\>", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \({h = PolynomialGCD[a, b], g = PolynomialLCM[a, b]} // ColumnForm\)], 
  "Input",
  CellLabel->"In[76]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\("1" + 2\ x\)},
          {
            \("2" + x + x\^2 + 2\ x\^3 + 2\ x\^4 + 2\ x\^5 + 2\ x\^6 + x\^7 + 
              2\ x\^8\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {1, 2}], 
        AbstractAlgebra`RingExtensions`Private`poly[ {
          AbstractAlgebra`Core`Private`ringoid[ {0, 1, 2}, Mod[ 
              Plus[ #, #2], 3]&, Mod[ 
              Times[ #, #2], 3]&, {{}, {}, {}, {}, {}, {RingoidName -> 
            "Z[3]", RingoidDescription -> "the ring of integers mod 3", 
            FormatOperator -> False}}], LeftToRight, x, True}, {2, 1, 1, 2, 
          2, 2, 2, 1, 2}]}],
      Editable->False]], "Output",
  CellLabel->"Out[76]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
The product of the LCM and GCD should equal the product of the \
original polynomials.\
\>", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Multiplication[PolynomialsOver[Z[3]], h, g] == 
      Multiplication[PolynomialsOver[Z[3]], a, b]\)], "Input",
  CellLabel->"In[77]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[77]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell["\<\
The problem here is that the leading coefficient of the divisor is \
not a unit, so the first division in the Euclidean algorithm cannot be \
performed.\
\>", "MathCaption",
  CellTags->"PolynomialArith"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialGCD[PolynomialsOver[Z[4]], Poly[Z[4], x\^3 + x + 1], 
      Poly[Z[4], 2\ x\^2 + 1]]\)], "Input",
  CellLabel->"In[78]:=",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \(PolynomialGCD::"undefined" \( : \ \) 
      "Result of PolynomialGCD is undefined due to a nonring base or an \
undefined division."\)], "Message",
  CellTags->"PolynomialArith"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[78]=",
  CellTags->"PolynomialArith"]
}, Open  ]],

Cell[TextData[{
  "The standard (built-in) uses for ",
  StyleBox["PolynomialGCD", "MR"],
  " and ",
  StyleBox["PolynomialLCM", "MR"],
  " still work for ordinary polynomials."
}], "Text",
  CellTags->"PolynomialArith"],

Cell["3.8.4 Quotient rings of polynomials", "Subsubsection",
  CellTags->{"QuotientPolynomials", "i:35"}],

Cell[TextData[{
  "A transition back to ringoids is made by ",
  StyleBox["QuotientRing", "MR"],
  ". Given a polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " of degree ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ", ",
  StyleBox["QuotientRing[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[",", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox["]", "MR"],
  " generates a ",
  StyleBox["Ringoid", "MR"],
  " with all polynomials of degree less than ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " over ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ". The operations are polynomial addition and multiplication modulo the \
polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ". "
}], "Text",
  CellTags->"QuotientPolynomials"],

Cell[TextData[{
  "With a cubic polynomial over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ", the domain of the ",
  StyleBox["QuotientRing", "MR"],
  " contains eight polynomials."
}], "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q = QuotientRing[Z[2], Poly[Z[2], x\^3 + x + 1]]\)], "Input",
  CellLabel->"In[79]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    RowBox[{"Ringoid", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False], ",", "x", ",", 
            RowBox[{"x", "+", 
              InterpretationBox[\(x\^2\),
                Subscripted[ 
                  x[ 2], {}, {1}],
                Editable->False]}], ",", "\<\"1\"\>", ",", 
            RowBox[{"\<\"1\"\>", "+", 
              InterpretationBox[\(x\^2\),
                Subscripted[ 
                  x[ 2], {}, {1}],
                Editable->False]}], ",", \("1" + x\), ",", 
            RowBox[{"\<\"1\"\>", "+", "x", "+", 
              InterpretationBox[\(x\^2\),
                Subscripted[ 
                  x[ 2], {}, {1}],
                Editable->False]}]}], "}"}], ",", "\<\"-Addition-\"\>", ",", 
        "\<\"-Multiplication-\"\>"}], "]"}]], "Output",
  CellLabel->"Out[79]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell["\<\
The first argument may also be a polynomial extension instead of \
the base ring. The result is the same.\
\>", "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q = QuotientRing[PolynomialsOver[Z[2]], Poly[Z[2], x\^3 + x + 1]]\)], 
  "Input",
  CellLabel->"In[80]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    RowBox[{"Ringoid", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False], ",", "x", ",", 
            RowBox[{"x", "+", 
              InterpretationBox[\(x\^2\),
                Subscripted[ 
                  x[ 2], {}, {1}],
                Editable->False]}], ",", "\<\"1\"\>", ",", 
            RowBox[{"\<\"1\"\>", "+", 
              InterpretationBox[\(x\^2\),
                Subscripted[ 
                  x[ 2], {}, {1}],
                Editable->False]}], ",", \("1" + x\), ",", 
            RowBox[{"\<\"1\"\>", "+", "x", "+", 
              InterpretationBox[\(x\^2\),
                Subscripted[ 
                  x[ 2], {}, {1}],
                Editable->False]}]}], "}"}], ",", "\<\"-Addition-\"\>", ",", 
        "\<\"-Multiplication-\"\>"}], "]"}]], "Output",
  CellLabel->"Out[80]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["QuotientRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["PolynomialsOver",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["R",
                    "TI"], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomials",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["mod",
                  SingleLetterItalics->False], " ", 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ \(is\ a\ ringoid\ with\ unity, \)\),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["p",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"]}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ a\ polynomial\ over\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ the\ leading\ coefficient\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ a\ unit\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["QuotientRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["QuotientRing",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        RowBox[{
                          StyleBox["PolynomialsOver",
                            "MR"], 
                          StyleBox["[",
                            "MR"], 
                          StyleBox["R",
                            "TI"], 
                          StyleBox["]",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", 
                        StyleBox["p",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ModulusPolynomial",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["Q",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(return\ the\ polynomial\ from\ which\ the\ quotient\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["ring",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["Q",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["was",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["created",
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->{"QuotientPolynomials", "i:36"}],

Cell["Polynomial quotient rings.", "Caption",
  CellTags->"QuotientPolynomials"],

Cell[TextData[{
  "The modulus can be extracted from the result of ",
  StyleBox["QuotientRing", "MR"],
  "."
}], "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ModulusPolynomial[Q]\)], "Input",
  CellLabel->"In[81]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    RowBox[{"\<\"1\"\>", "+", "x", "+", 
      InterpretationBox[\(x\^3\),
        Subscripted[ 
          x[ 3], {}, {1}],
        Editable->False]}]], "Output",
  CellLabel->"Out[81]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell[TextData[{
  "The polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3\  + \ x\  + \ 1\)]],
  " is irreducible over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ", so ",
  StyleBox["Q", "MR"],
  " is a finite field with eight elements, ",
  StyleBox["GF",
    FontSlant->"Italic"],
  "(8). (",
  StyleBox["Q", "MR"],
  " can also be constructed by ",
  StyleBox["GF", "MR"],
  "[8, ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 + x + 1\)]],
  "].) Here is the multiplication table for this field."
}], "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultiplicationTable[Q, Mode \[Rule] Visual, \ 
      KeyForm\  \[Rule] \ StandardForm]; \)\)], "Input",
  CellLabel->"In[82]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
  "\<\"KEY for                                 3\\nMult(Quotient Ring mod 1 + \
x + x ): label used \[Rule] element: {g1 \[Rule] \\!\\(0\\), g2 \[Rule] \
\\!\\(\\*InterpretationBox[\\(x\\^2\\), Subscripted[x[2], List[], List[1]], \
Rule[Editable, False]]\\), g3 \[Rule] \\!\\(x\\), g4 \[Rule] \\!\\(x + \
\\*InterpretationBox[\\(x\\^2\\), Subscripted[x[2], List[], List[1]], \
Rule[Editable, False]]\\), g5 \[Rule] \\!\\(\\\"1\\\"\\), g6 \[Rule] \\!\\(\\\
\"1\\\" + \\*InterpretationBox[\\(x\\^2\\), Subscripted[x[2], List[], \
List[1]], Rule[Editable, False]]\\), g7 \[Rule] \\!\\(\\\"1\\\" + x\\), g8 \
\[Rule] \\!\\(\\\"1\\\" + x + \\*InterpretationBox[\\(x\\^2\\), \
Subscripted[x[2], List[], List[1]], Rule[Editable, False]]\\)}\"\>"], "Print",\

  CellTags->"QuotientPolynomials"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 .5 0 r
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.56 .37 .6 r
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
0 0 1 r
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.74 .99 .79 r
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.251 .878 .816 r
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .79 .34 r
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 .392 0 r
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g1)] .28836 .81878 0 0 Mshowa
[(g1)] .39418 .81878 0 0 Mshowa
[(g1)] .5 .81878 0 0 Mshowa
[(g1)] .60582 .81878 0 0 Mshowa
[(g1)] .71164 .81878 0 0 Mshowa
[(g1)] .81746 .81878 0 0 Mshowa
[(g1)] .92328 .81878 0 0 Mshowa
[(g1)] .18254 .71296 0 0 Mshowa
[(g4)] .28836 .71296 0 0 Mshowa
[(g7)] .39418 .71296 0 0 Mshowa
[(g6)] .5 .71296 0 0 Mshowa
[(g2)] .60582 .71296 0 0 Mshowa
[(g3)] .71164 .71296 0 0 Mshowa
[(g8)] .81746 .71296 0 0 Mshowa
[(g5)] .92328 .71296 0 0 Mshowa
[(g1)] .18254 .60714 0 0 Mshowa
[(g7)] .28836 .60714 0 0 Mshowa
[(g2)] .39418 .60714 0 0 Mshowa
[(g8)] .5 .60714 0 0 Mshowa
[(g3)] .60582 .60714 0 0 Mshowa
[(g5)] .71164 .60714 0 0 Mshowa
[(g4)] .81746 .60714 0 0 Mshowa
[(g6)] .92328 .60714 0 0 Mshowa
[(g1)] .18254 .50132 0 0 Mshowa
[(g6)] .28836 .50132 0 0 Mshowa
[(g8)] .39418 .50132 0 0 Mshowa
[(g3)] .5 .50132 0 0 Mshowa
[(g4)] .60582 .50132 0 0 Mshowa
[(g7)] .71164 .50132 0 0 Mshowa
[(g5)] .81746 .50132 0 0 Mshowa
[(g2)] .92328 .50132 0 0 Mshowa
[(g1)] .18254 .3955 0 0 Mshowa
[(g2)] .28836 .3955 0 0 Mshowa
[(g3)] .39418 .3955 0 0 Mshowa
[(g4)] .5 .3955 0 0 Mshowa
[(g5)] .60582 .3955 0 0 Mshowa
[(g6)] .71164 .3955 0 0 Mshowa
[(g7)] .81746 .3955 0 0 Mshowa
[(g8)] .92328 .3955 0 0 Mshowa
[(g1)] .18254 .28968 0 0 Mshowa
[(g3)] .28836 .28968 0 0 Mshowa
[(g5)] .39418 .28968 0 0 Mshowa
[(g7)] .5 .28968 0 0 Mshowa
[(g6)] .60582 .28968 0 0 Mshowa
[(g8)] .71164 .28968 0 0 Mshowa
[(g2)] .81746 .28968 0 0 Mshowa
[(g4)] .92328 .28968 0 0 Mshowa
[(g1)] .18254 .18386 0 0 Mshowa
[(g8)] .28836 .18386 0 0 Mshowa
[(g4)] .39418 .18386 0 0 Mshowa
[(g5)] .5 .18386 0 0 Mshowa
[(g7)] .60582 .18386 0 0 Mshowa
[(g2)] .71164 .18386 0 0 Mshowa
[(g6)] .81746 .18386 0 0 Mshowa
[(g3)] .92328 .18386 0 0 Mshowa
[(g1)] .18254 .07804 0 0 Mshowa
[(g5)] .28836 .07804 0 0 Mshowa
[(g6)] .39418 .07804 0 0 Mshowa
[(g2)] .5 .07804 0 0 Mshowa
[(g8)] .60582 .07804 0 0 Mshowa
[(g4)] .71164 .07804 0 0 Mshowa
[(g3)] .81746 .07804 0 0 Mshowa
[(g7)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(                            3)(\\(Quotient Ring mod 1 + x + x , x\\))] \
.02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[82]:=",
  ImageSize->{272.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l04@000?l04@000?l04@000?l04@000?l0
4@000?l04@000?l04@0000H0ool5o`H00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o
7=l0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o
6d`0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>3o00H000060003oe1@01U@0_lLg`1GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo01a@00?oC4`0
6D`0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3o00H00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o7=l0M?l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_mOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o6d`0>omaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00H000060003oe1@01U@
0_lLg`1GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo01a@00?oC4`06D`0>omnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000Loi1@T52@
D91@T52@D91@T52@D91@T52@D91@T0;o7=l0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoi1@T52@
D91@T52@D91@T52@D91@T52@D91@T53o6d`0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00H000060003oe1@01U@0_lLg`1GomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo01a@00?oC4`06D`0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdon2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000Loi1@T52@D91@T52@D91@T52@D91@T52@
D91@T0;o7=l0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoi1@T52@D91@T52@D91@T52@D91@T52@
D91@T53o6d`0>omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noj3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>3o00H000060003oe1@01U@0_lLg`1GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo01a@
00?oC4`06D`0>omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdon2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3o00H00006000Loi1@T52@D91@T52@D91@T52@D91@T52@D91@T0;o7=l0M?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_mOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o6d`0>omaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o00H000060003
oe1@01U@0_lLg`1GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo01a@00?oC4`06D`0>omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o00H00006000:
oi1@T52@D91@T0?o00n@D91@T52@D91@T52@D9000_l9g`?o4=l02_l33`<?0`l33`<3o`0J0`l33`<?
0`l33`<?0`l3oo4>l@ka3_4>l@h3o`0I3_4>l@ka3_4>l@ka3_4>oenOGimOWenOG`03o`0JGimOWenO
GimOWenOGimOWon@D91@T52@D903o`0AT52@D91@T52@D91@T52@D?l02D`3o`m<00_oLGiaOW5nLGia
OP03o`0IOW5nLGiaOW5nLGiaOW5noj3PX>2Ph:3PX003o`0AX>2Ph:3PX>2Ph:3PX>2Ph?l01P0000H0
00?oD5002U000om@D00<D0;o3=l00ooOg`0=g`1GomH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3e_n`
3[0>/0j`3[0>/0j`ok0>/0j`3[0>/0j`3[0>oenOGimOWenOGimOWonOGimOWenOGimOWenOGioo00a@
00?oD5003E000om<C00:C003oda<00a<03_oO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm?oPX>2P
h:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>2Po`0600001P002_n@D91@T52@D904o`0>D93ooe2@D91@T52@
D902o`WO1?l01=ooool;g`0:o`<?0`l33`<?0`Co01T?oooo3`<?0`l33`<?0ooa3_4>l@ka3_4>00Co
01Sa3_ool@ka3_4>l@ka3_mOWenOGimOWel4o`03Wooo00;o01AOWenOGimOWenOoi1@T52@D91@T0Co
011@T?ooD91@T52@D91@T53o2D`4o`9<0ol9C00;og5nLGiaOW5nLGh01?l0677ooomaOW5nLGiaOW5n
oj3PX>2Ph:3PX0Co013PX?nPh:3PX>2Ph:3PX>3o1P0000H000?oD5001U001om@D53oD?l00U000om@
D007D0;o2=l01OoOgmoo00;O00?ogml02]l0EooF0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mKo/0j`
3[0>/0j`ok0>/?n`ok0>o`j`3[0>/0j`3_mOWenOGimOWonOGiooWeooGimOWenOGimOWenOo`08D007
oe1@D?m@o`02D003oe1@00Q@00?oC4`01T`01Om<C4co00=<00?oC4`024`0>omnm7kdO_Anm7koO_An
ogkdO_Com7kdO_Anm7kdon2Ph:3PX>2Poj3PX?nPh?oPX>2Ph:3PX>2Ph:3o00H00006000Loi1@T52@
D91@oe2@D?m@oe2@oi1@T52@D91@T0;o2=l01OoOgmoo00;O00?ogml02]l0M?l33`<?0`l33ol?0`oo
3`<?0ol33`<?0`l33`?ol@ka3_4>l@kaoo4>lOoaoo4>o`ka3_4>l@ka3_mOWenOGimOWonOGiooWenO
oimOWenOGimOWenOoi1@T52@D91@oe2@D?m@oe2@oi1@T52@D91@T53o24`01_m<C4coC0Co2D`0>oma
OW5nLGiaOW7oLGiaog5nLGkoOW5nLGiaOW5noj3PX>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3PX>3o00H0
00060003oe1@00I@00GoD51@o`02D0;o2U02o`SO00GogmoOo`02g`03omoO00[O00ooeP?F0mH3eP?o
0mH3o`<00ol06P?F0mH3eP?F0mKo/0j`3[0>/0j`ok0>/?n`0ol0:;0>/0j`3[0>/0koGimOWenOGioo
WenOoimOWeooGimOWenOGimOWol8D005oe1@D?l00U02o`]@00?oC4`01T`02Om<C4coC?m<o`0:C00A
ogkdO_Anm7kdO_mnm7koO_@00_l0:7kdO_Anm7kdO_Coh:3PX>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph:3P
X?l600001P002_n@D91@T52@D906o`0<D93oT52@D91@T52@0_l9g`Go00?Ooml02ml02_l33`<?0`l3
3`<6o`0G3`<?0`l33`<?0`l3oo4>l@ka3_4>l@h01_l05_4>l@ka3_4>l@ka3_mOWenOGimOWel6o`0G
WeooGimOWenOGimOWon@D91@T52@D9001_l03U2@oi1@T52@D91@T53o2D`6o`03C?m<00U<00_oLGia
OW5nLGiaOP05o`0GOW5nogiaOW5nLGiaO_nPh:3PX>2Ph:001Ol03j3PX?nPh:3PX>2Ph:3Po`060000
1P000om@D00=D0;o2U02o`kO0_l<g`0?omH3eP?F0mH3eP?F0mH300Co01[F0mH3eP?F0mKo/0j`3[0>
/0j`3[0>/0j`3P?o01T>/0j`3[0>/0koGimOWenOGimOWenOGimO00;o00bOGimOWenOGimOWol?D0;o
2e000om<C00=C0;o2T`04?mnm7kdO_Anm7kdO_Anm7h3o`0IO_Anm7kdO_Anm?oPX>2Ph:3PX>2Ph:3P
X004o`0;h:3PX>2Ph:3PX?l01P0000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_lLg`1d
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>oenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooT52@D91@T52@D91@T52@D91@T52@D91@T52@D?lKC00k
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l0
1P0000H000?oD5006E02oacO05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0koGimOWenOGimOWenOGimOWenOGimOWenOGimOWol075000om<C00IC00k
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l0
1P0000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_lLg`1do`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>oenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooT52@D91@T52@D91@T52@D91@T52@D91@T52@D?lKC00kog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGkoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l01P0000H000?oD5006E02oacO
05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol075000om<C00IC00kogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l01P0000H001coT52@D91@T52@
D91@T52@D91@T52@D91@T52@0_lLg`1do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>oenOGimOWenOGimOWenOGimOWenOGimOWenOGiooT52@D91@T52@
D91@T52@D91@T52@D91@T52@D?lKC00kog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l01P0000H000?oD5006E02oacO05OoeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol075000om<C00IC00kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Coh:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l01P0000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@
0_lLg`1do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>oenOGimOWenOGimOWenOGimOWenOGimOWenOGiooT52@D91@T52@D91@T52@D91@T52@D91@T52@
D?lKC00kog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?l01P0000H000?oD5006E02oacO05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koGimOWenOGimOWenOGimOWenOGimOWenOGimOWol075000om<
C00IC00kogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?l01P0000H001coT52@D91@T52@D91@T52@D91@T52@D91@T52@0_lLg`1do`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>oenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooT52@D91@T52@D91@T52@D91@T52@D91@T52@D?lKC00kog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGkoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l01P0000H000?oD500
6E02oacO05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0koGimOWenOGimOWenOGimOWenOGimOWenOGimOWol075000om<C00IC00kogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l01P0000H0ool5o`H0
0006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003oda<01Y<097o0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoenOGimO
WenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o
7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWenOGimOWenOGimO
WenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o00H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003oda<01Y<
097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oenOGimOWenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX0;o7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWenOGimO
WenOGimOWenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o00H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003
oda<01Y<097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2PoenOGimOWenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX0;o7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimO
WenOGimOWenOGimOWenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o00H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@
D00ID003oda<01Y<097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2PoenOGimOWenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX0;o7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimO
WenOGimOWenOGimOWenOGimOWenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7o00H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o
7=l00om@D00ID003oda<01Y<097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2PoenOGimOWenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<
097o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
oenOGimOWenOGimOWenOGimOWenOGimOWenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o00H00006000:on2Ph:3PX>2Ph0?o00oPX>2Ph:3PX>2P
h:3PX>000_l9g`?o4=l00om@D007D0?o3e000om<C008C0?o3d`02_l3eP?F0mH3eP<3o`0J0mH3eP?F
0mH3eP?F0mH3e_oPX>2Ph:3PX>03o`0Jh:3PX>2Ph:3PX>2Ph:3PX?mOWenOGimOWel3o`0JGimOWenO
GimOWenOGimOo`j`3[0>/0j`3[03o`0I/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm003o`0Am7kdO_An
m7kdO_Anm7kdO_l01P0000H001coX>2Ph:3PX>2Ph:3Pon2Ph:3PX>2Ph:3PX>2P0_l<g`03omoO00gO
01goT52@D91@T52@D91@oe2@D91@T52@D91@T52@o`0=C003oda<00a<097o3`<?0`l33`<?0`l3o`<?
0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>3oh:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWonOGimO
WenOGimOWenOGol>l@ka3_4>l@ka3_4>o`ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLOmaOW5nLGia
OW5nLGiaOW7o00H00006000:on2Ph:3PX>2Ph0Co00jPh?oPX>2Ph:3PX>2Ph0;o2Ml4o`04goooo`_O
00?oD5001e04o`9@0_l:D003oda<00Q<1?l2C0?o2D`02_l3eP?F0mH3eP<4o`0Ie_ooomH3eP?F0mH3
eP?Fon2Ph:3PX>2Ph004o`0IX>3oh:3PX>2Ph:3PX>2PoenOGimOWenOG`04o`03Wooo00;o01AOWenO
GimOWeoo3[0>/0j`3[0>/0Co01P>/?oo3[0>/0j`3[0>/?odO_Anm7kdO_@4o`0@O_ooogkdO_Anm7kd
O_Ano`H00006000Loj3PX>2Ph:3Pon2Ph?oPX?nPh:3PX>2Ph:3PX0;o2=l01OoOgmoo00;O00?ogml0
2]l07On@D91@T52@D?m@T53oD?m@T?n@D91@T52@D93o00U<00GoC4a<o`03C003oda<00Q<097o3`<?
0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?0onPh:3PX>2Ph?oPX>3oh:3oX>2Ph:3PX>2Ph:3PoenOGimO
WenOoimOWonOGomOWenOGimOWenOGol>l@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@kaogiaOW5nLGia
og5nLOmaOW5nogiaOW5nLGiaOW7o00H00006000Lon2Ph:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>2Ph0;o
2=l01OoOgmoo00;O00?ogml02]l00om@D006D007oe1@D?m@o`02D003oe1@00M@00?oC4`01d`01_m<
C4coC0Co2D`0TOl3eP?F0mH3e_oF0mKoeP?F0ol3eP?F0mH3eP?Fon2Ph:3PX>2Poj3PX?nPh:3oX>2P
h:3PX>2Ph:3oGimOWenOGiooWenOoimOWonOGimOWenOGimOo`j`3[0>/0j`3_l>/0ko3_l>/?n`3[0>
/0j`3[3om7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdO_l01P0000H001coX>2Ph:3PX>3oh:3Pon2P
h?oPX>2Ph:3PX>2P0_l8g`05omoOgol00]l00ooOg`0:g`0@oi1@T52@D91@oe2@D?m@T0;o00]@T52@
D91@T52@o`09C009oda<C?m<odco00Y<00oo3`<?0`l33`?o0`l3o`<00ol0E0<?0`l33`<?0`l3oj3P
X>2Ph:3Pon2Ph?oPX>3oh:3PX>2Ph:3PX>3oGimOWenOGiooWenOoimOWeooGimOWenOGimOo`ka3_4>
l@ka3_l>l@ko3P?o01X>l@ka3_4>l@kaogiaOW5nLGiaog5nLOmaOP;o00aaOW5nLGiaOW5nLOl60000
1P002_oPX>2Ph:3PX>05o`0=h:3Pon2Ph:3PX>2Ph002o`WO1Ol00moog`0;g`03oe1@00M@1_l2D003
oe1@00M@00?oC4`024`6o`03C?m<00U<00[o0mH3eP?F0mH31_l05mH3eP?F0mH3eP?F0mKoh:3PX>2P
h:3P00Go01SPX>3oh:3PX>2Ph:3PX?mOWenOGimOWel6o`0GWeooGimOWenOGimOo`j`3[0>/0j`3[00
1_l05Pj`3[0>/0j`3[0>/?odO_Anm7kdO_@5o`0?m7kdooAnm7kdO_Anm7ko00H00006000?oj3PX>2P
h:3PX>2Ph:3P00Co00VPh:3PX>2Ph:000_l>g`;o3=l04?n@D91@T52@D91@T52@D902o`0;D91@T52@
D91@T?l044`2o`Y<00oo3`<?0`l33`<?0`l33`<01?l06@l33`<?0`l33`?oX>2Ph:3PX>2Ph:3PX>00
1?l06Z3PX>2Ph:3PX>3oGimOWenOGimOWenOGimO0_l06imOWenOGimOWeoo3_4>l@ka3_4>l@ka3_4>
l@03o`0Hl@ka3_4>l@kaogiaOW5nLGiaOW5nLGia0ol0375nLGiaOW5nLGiao`H00006000Lon2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003oda<01Y<097o0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoenOGimOWenOGimOWenOGimO
WenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o7=l07On@D91@T52@
D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onPh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWenOGimOWenOGimOWenOGol>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o00H00006000L
on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003oda<01Y<097o0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoenOGimOWenOGimO
WenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o7=l07On@
D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWenOGimOWenOGimOWenOGol>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o00H0
0006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003oda<01Y<097o0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoenOGimO
WenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX0;o
7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWenOGimOWenOGimO
WenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o00H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003oda<01Y<
097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oenOGimOWenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX0;o7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimOWenOGimO
WenOGimOWenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o00H00006000Lon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph0;o7=l00om@D00ID003
oda<01Y<097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2PoenOGimOWenOGimOWenOGimOWenOGimOWenOGol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko00H00006000Loj3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX0;o7=l07On@D91@T52@D91@T52@D91@T52@D91@T52@D93o01a<097o3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoenOGimOWenOGimO
WenOGimOWenOGimOWenOGol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o00H000060?oo1Ol600001P007?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_42oacO0:goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>oe2@D91@T52@D91@T52@D91@T52@D91@T52@D?mOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0LC003o`0000@00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l0M?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Pok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko6e007_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoaa<00?o0000100000H001col@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka0_lLg`2]ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_m@T52@D91@T52@D91@T52@D91@T52@D91@T53oGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol074`00ol0000400001P007?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[02oacO07Com7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oa]@01koGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolLC003o`0000@00006000Loo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@;o7=l0[OmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@koD91@T52@D91@T52@D91@T52@D91@T52@D91@oenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo01a<00?o0000100000H001co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`0_lLg`1d
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_lKD00N
oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo74`00ol0000400001P007?oa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_42oacO0:goOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?oa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>oe2@D91@T52@D91@T52@D91@T52@D91@T52@D?mOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0LC003o`0000@00006000Lok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o
7=l0M?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Pok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
6e007_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<00?o0000100000H001col@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka0_lLg`2]ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3ol@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@T52@D91@T52@D91@T52@D91@T53oGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol074`00ol0000400001P002_n`3[0>/0j`3[03o`0?/0j`3[0>/0j`3[0>
/0j`00;o2Ml3oa3O00[om7kdO_Anm7kd0ol06_Anm7kdO_Anm7kdO_Anm?oF0mH3eP?F0mH30ol06@?F
0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:000ol06Z3PX>2Ph:3PX>2Ph:3PX>3o/0j`3[0>/0j`0ol04K0>
/0j`3[0>/0j`3[0>/0ko00U@0ol?D00;oenOGimOWenOGil00ol049mOWenOGimOWenOGimOWol9C0?o
44`00ol0000400001P007?oa3_4>l@ka3_4>l@ko3_4>l@ka3_4>l@ka3_42o`cO00?ogml03Ml0[Omn
LGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l33ooPX>2P
h:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_l>l@ka3_4>l@ka3_4>l@koD91@T52@
D91@T52@oi1@T52@D91@T52@D91@oenOGimOWenOGimOWeooGimOWenOGimOWenOGioo00a<00?oC4`0
3D`00ol0000400001P002_n`3[0>/0j`3[04o`0>3[3oo`j`3[0>/0j`3[02o`WO1?l01=ooool;g`0:
ooAnm7kdO_Anm0Co01UnooooO_Anm7kdO_Anm?oF0mH3eP?F0mH300Co01SFooooeP?F0mH3eP?F0onP
h:3PX>2Ph:04o`0Ih:3oX>2Ph:3PX>2Ph:3Pok0>/0j`3[0>/004o`0@3[3oo`j`3[0>/0j`3[0>o`U@
1?l2D0;o2U002omOWenOGimOWenO00Co00=Oool00_l02YmOWenOGimOWol9C0Co0T`3o`Y<00?o0000
100000H001col@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@ka0_l8g`05omoOgol00]l00ooOg`0:g`2]
ogiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaO_l33`<?0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?on2P
h:3PX>2Poj3PX?nPh?oPX>2Ph:3PX>2Ph:3ol@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@ka3_m@T52@
D91@T?n@D93oT?n@D?m@T52@D91@T53oGimOWenOGimOoenOGomOWonOGimOWenOGimOWol024`01Om<
C4co00=<00?oC4`02D`00ol0000400001P007?n`3[0>/0j`3_l>/0ko3_l>/?n`3[0>/0j`3[02o`SO
00GogmoOo`02g`03omoO00[O07Com7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdomH3eP?F0mH3e_oF
0mKoeP?F0ol3eP?F0mH3eP?oX>2Ph:3PX>3oh:3Pon2Ph?oPX>2Ph:3PX>2Ph?n`3[0>/0j`3_l>/0ko
3_l>/?n`3[0>/0j`3[0>o`Q@00OoD51@oe3o009@00?oD5001e007_mOWenOGimOWeooGimOoenOGomO
WenOGimOWenOo`Q<00KoC4a<od`4o`Y<00?o0000100000H000ool@ka3_4>l@ko3_4>o`h00ol02Pka
3_4>l@ka3_42o`SO00GogmoOo`02g`03omoO00[O013oOW5nLGiaOW7oLGiaog5n0_l06W5nLGiaOW5n
LGko0`l33`<?0`l3o`<?0ol30ol0=P<?0`l33`<?0`ooh:3PX>2Ph:3oX>2Poj3PX?nPh:3PX>2Ph:3P
X?oa3_4>l@ka3_l>l@ko3P?o01/>l@ka3_4>l@ka3_m@T52@D91@T?n@D93oT5000_l0:91@T52@D91@
T53oGimOWenOGimOoenOGomOWenOoimOWenOGimOWol8C009oda<C?m<odco00]<00?o0000100000H0
00[o/0j`3[0>/0j`1_l030j`3[0>/0j`3[0>/0;o2Ml5o`03gooO00_O00[om7kdO_Anm7kd1Ol06?An
m?odO_Anm7kdO_CoeP?F0mH3eP?F0`Ko01KF0mH3eP?F0mH3eP?oX>2Ph:3PX>2P1Ol06:3PX?nPh:3P
X>2Ph:3Pok0>/0j`3[0>/0Ko00h>/0j`3[0>/0j`3[0>o`U@1_l2D003oe1@00M@00_oGimOWenOGimO
W`06o`0=GiooWenOGimOWenOo`09C0Ko00=<od`02T`00ol0000400001P004?oa3_4>l@ka3_4>l@ka
3_43o`09l@ka3_4>l@ka00;o3]l2o`cO00ooOW5nLGiaOW5nLGiaOW400ol06W5nLGiaOW5nLGko0`l3
3`<?0`l33`<?0`l31?l060l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX0Co01[PX>2Ph:3PX>2Poo4>l@ka
3_4>l@ka3_4>l@?o01[a3_4>l@ka3_4>oe2@D91@T52@D91@T52@D0;o01^@D91@T52@D91@oenOGimO
WenOGimOWenOGil00_l02enOGimOWenOGioo00m<0_l;C003o`0000@00006000Lok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0;o7=l0M?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Pok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0ko6e007_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoaa<00?o0000
100000H001col@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka0_lLg`2]ogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@T52@D91@T52@D91@T52@
D91@T53oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol074`00ol0000400001P007?n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[02oacO07Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>oa]@01koGimOWenOGimOWenOGimOWenOGimOWenOGimOWolLC003
o`0000@00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l0[OmnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ooPX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koD91@T52@D91@T52@D91@T52@
D91@T52@D91@oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo01a<00?o0000100000H001co/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`0_lLg`1dooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?oF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_lKD00NoenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
74`00ol0000400001P007?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_42oacO0:goOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`ooh:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX?oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>oe2@D91@T52@D91@T52@
D91@T52@D91@T52@D?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0LC003o`0000@00006000L
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0;o7=l0M?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_CoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0onPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko6e007_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoaa<00?o0000100000H001col@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka0_lLg`2]ogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?on2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_m@T52@D91@T52@
D91@T52@D91@T52@D91@T53oGimOWenOGimOWenOGimOWenOGimOWenOGimOWol074`00ol000040000
1P007?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[02oacO07Com7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph?n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oa]@01koGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolLC003o`0000@00006000Loo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@;o7=l0[Omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ooPX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koD91@T52@
D91@T52@D91@T52@D91@T52@D91@oenOGimOWenOGimOWenOGimOWenOGimOWenOGioo01a<00?o0000
100000H001co/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`0_lLg`1dooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>3o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_lKD00NoenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo74`00ol0000400001P3oo`Go1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P007?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P007?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P007?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P007?l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<2oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H001coeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P002_l3
3`<?0`l33`<3o`0?0`l33`<?0`l33`<?0`l300;o2Ml3oa3O00[oWenOGimOWenO0ol06YmOWenOGimO
WenOGimOWomnLGiaOW5nLGia0ol0475nLGiaOW5nLGiaOW5nLOl9C0?o44`02_l33`<?0`l33`<3o`0J
0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@h3o`0J3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:03o`0I
X>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T003o`0AT52@D91@T52@D91@T52@D?l01P0000H001coeP?F
0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0_l<g`03omoO00gO03[oWenOGimOWenOGimOoenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7ko34`00om<C00=C01GomH3eP?F0mH3eP?F
0ol3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`ok0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3o
X>2Ph:3PX>2Ph:3PX>3o00a@00?oD5003E000ol0000400001P002_l33`<?0`l33`<4o`0>3oooo`l3
3`<?0`l33`<2o`WO1?l01=ooool;g`0:oimOWenOGimOW`Co00=Oool00_l059mOWenOGimOWomnLGia
OW5nLGia1?l03gkooomnLGiaOW5nLGiao`09C0Co0T`3o`Y<00[o0`l33`<?0`l31?l06@ooool?0`l3
3`<?0`l33ol>l@ka3_4>l@h01?l06O4>oooa3_4>l@ka3_4>on2Ph:3PX>2Ph:001?l06>2Poj3PX>2P
h:3PX>2Poi1@T52@D91@T0Co011@T?ooD91@T52@D91@T53o1P0000H001coeP?F0mH3eP?o0mH3o`?F
0mKoeP?F0mH3eP?F0_l8g`05omoOgol00]l00ooOg`0:g`0joimOWenOGimOoenOGomOWonOGimOWenO
GimOWoodO_Anm7kdO_Com7kdooAnm7koO_Anm7kdO_Ano`Q<00GoC4a<o`03C003oda<00U<05OoeP?F
0mH3eP?o0mH3o`?F0mKoeP?F0mH3eP?F0ol>/0j`3[0>/?n`3[3o/?n`3_l>/0j`3[0>/0koX>2Ph:3P
X>2Poj3PX?nPh?oPX>2Ph:3PX>2Ph?l025001om@D53oD?l00U000om@D008D003o`0000@00006000L
o`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0`;o2=l01OoOgmoo00;O00?ogml02]l0>_nOGimOWenO
GomOWeooGimOoenOGimOWenOGiooOW5nLGiaOW5nogiaO_mnLGiaog5nLGiaOW5nLOl8C006oda<C?m<
1?l:C01do`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0`oo3_4>l@ka3_7ol@kaoo7ol@ko3_4>l@ka
3_4>on2Ph:3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>2Ph:3oT52@D91@T53oD91@oe3oD93oT52@D91@T52@
D?l600001P003ooF0mH3eP?F0ol3eP?o0`03o`0:0mH3eP?F0mH3eP;o2=l01OoOgmoo00;O00?ogml0
2]l0;OnOGimOWenOGomOWeooGimOWonOGimOWenOGioom7kdO_Anm7kdooAnm?odOP02o`0;m7kdO_An
m7kdO_l024`02Om<C4coC?m<o`0;C00?omH3eP?F0mH3o`?F0ol300?o01X3eP?F0mH3eP?F0ol>/0j`
3[0>/?n`3[3o/0?o02R`3[0>/0j`3[0>oj3PX>2Ph:3PX?nPh:3oX>2Poj3PX>2Ph:3PX>3o25001Om@
D53o009@0_l;D003o`0000@00006000:o`<?0`l33`<?0`Ko00`?0`l33`<?0`l33`<2o`WO1Ol00moo
g`0;g`0:oimOWenOGimOW`Ko01MOWonOGimOWenOGiooOW5nLGiaOW5nL@05o`0>LGiaog5nLGiaOW5n
LOl9C0Ko00=<od`02T`02_l33`<?0`l33`<6o`0G3`<?0`l33`<?0`l33ol>l@ka3_4>l@h01_l05o4>
l@ka3_4>l@ka3_oPX>2Ph:3PX>2P00Go01NPh:3oX>2Ph:3PX>2Poi1@T52@D91@T006o`0>D93oT52@
D91@T52@D?l600001P003ooF0mH3eP?F0mH3eP?F0`04o`09eP?F0mH3eP?F00;o3]l2o`cO013oWenO
GimOWenOGimOWenO0_l06UnOGimOWenOGioom7kdO_Anm7kdO_Anm7kd0ol02oAnm7kdO_Anm7ko00m<
0_l;C00?omH3eP?F0mH3eP?F0mH300Co01[F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3P?o01T>/0j`
3[0>/0koX>2Ph:3PX>2Ph:3PX>2P00Co00[PX>2Ph:3PX>3o3e02o`]@00?o0000100000H001co0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l30_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@
D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H001co0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l30_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@
D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H001co0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l30_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@
D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H001co0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l30_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@
D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H001co0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l30_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@
D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H00006000LomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o01a@00?o0000100000H0ool5o`H0
00060003oda<01U<0_lLg`0Mok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l075007_mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoaa<05OoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01P0000H0
00?oC4`06D`2oacO05Ool@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoi1@T52@D91@T52@D91@T52@
D91@T52@D91@T53oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l074`0EooPX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0600001P000om<C00IC0;o7=l07On`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[3o01a@01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC01Goj3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FoimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00H000060003oda<01U<0_lLg`1Goo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOn@
D91@T52@D91@T52@D91@T52@D91@T52@D91@og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01a<
05Ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol01P0000H000?oC4`06D`2oacO01go/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`o`0LD00NogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co74`0EonP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_nOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0600001P000om<C00IC0;o7=l0Eooa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_7oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?maOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0LC01Gon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l3oimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00H000060003oda<01U<
0_lLg`0Mok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l075007_mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoaa<05OoX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mKoWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01P0000H000?oC4`06D`2oacO
05Ool@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l074`0EooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>3o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0onOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0600001P000om<C00IC0;o7=l07On`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o01a@01koO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC01Goj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00H0
00060003oda<01U<0_lLg`1Goo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@
D91@T52@D91@T52@D91@og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01a<05Ooh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Po`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol01P0000H000?oC4`01d`3o`m<0_l9g`?o4=l02_n`3[0>/0j`3[03o`0@
/0j`3[0>/0j`3[0>/0j`o`Y@0ol?D00:ogkdO_Anm7kdOP?o015nm7kdO_Anm7kdO_Anm7kdo`09C0?o
44`02_nPh:3PX>2Ph:03o`0JX>2Ph:3PX>2Ph:3PX>2Po`?F0mH3eP?F0mH3o`0IeP?F0mH3eP?F0mH3
eP?FoimOWenOGimOW`03o`0AWenOGimOWenOGimOWenOGol01P0000H000?oC4`02T`00om<C00<C0;o
3=l00ooOg`0=g`1Goo4>l@ka3_4>l@ka3_l>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@oi1@T52@
D91@T52@D91@og5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGko00a<00?oC4`03D`0EooPX>2Ph:3P
X>2Ph:3oX>2Ph:3PX>2Ph:3PX>3o3`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0onOGimOWenOGimO
WeooGimOWenOGimOWenOGimOo`0600001P000om<C007C0Co0T`3o`U<0_l9g`Co00COoooo2ml02_n`
3[0>/0j`3[04o`0?3[3oo`j`3[0>/0j`3[3o00Y@1?l2D0;o2U002_mnm7kdO_Anm7h4o`0@m?ooooAn
m7kdO_Anm7kdo`U<1?l2C0?o2T`02_nPh:3PX>2Ph:04o`0Ih:3oX>2Ph:3PX>2Ph:3o0mH3eP?F0mH3
eP04o`0H0oooo`?F0mH3eP?F0mKoWenOGimOWenO1?l00eooo`02o`0;WenOGimOWenOGol01P0000H0
00?oC4`01T`01Om<C4co00=<00?oC4`024`2o`SO00GogmoOo`02g`03omoO00[O05Ool@ka3_4>l@ko
3_4>o`ko3_7ol@ka3_4>l@kaoi1@T52@D91@T?n@D93oT?n@D?m@T52@D91@T53oLGiaOW5nLGkoOW5n
ogiaOW7oLGiaOW5nLGiaO_l024`01Om<C4co00=<00?oC4`02D`0EooPX>2Ph:3PX?nPh:3oX>3oh:3P
X>2Ph:3PX>3o3`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0onOGimOWenOGomOWeooGiooWenOGimO
WenOGimOo`0600001P000om<C006C006oda<C?m<1?l9C0;o2=l01OoOgmoo00;O00?ogml02]l07On`
3[0>/0j`3_l>/0ko3_l>/?n`3[0>/0j`3[3o00U@00OoD51@oe3o009@00?oD5001e007_mnm7kdO_An
m?odO_Com7kdO_mnm7kdO_Anm7kdo`Q<00KoC4a<od`4o`Y<05OoX>2Ph:3PX>3oh:3Pon2Ph?oPX>2P
h:3PX>2Po`?F0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mKoWenOGimOWeooGimOoenOGomOWenOGimO
WenOGol01P0000H000?oC4`01T`02Om<C4coC?m<o`0:C0;o2=l01OoOgmoo00;O00?ogml02]l03ooa
3_4>l@ka3_l>l@ko3P03o`0K3_4>l@ka3_4>lOn@D91@T52@D93oT52@oi1@00;o01Z@D91@T52@D91@
og5nLGiaOW5nogiaO_mnL@;o00anLGiaOW5nLGiaO_l8C009oda<C?m<odco00]<02coh:3PX>2Ph:3o
X>2Poj3PX?nPh:3PX>2Ph:3Po`l33`<?0`l33ol?0`oo3`?o02P?0`l33`<?0`l3oimOWenOGimOoenO
GomOWenOoimOWenOGimOWeoo1P0000H000?oC4`01d`6o`03C?m<00U<0_l9g`Go00?Ooml02ml02_n`
3[0>/0j`3[06o`0=3[0>/0j`3[0>/0j`o`0:D0Ko0U000om@D007D00:ogkdO_Anm7kdOPGo00mnm7ko
O_Anm7kdO_Anm?l02D`6o`03C?m<00Y<00[oX>2Ph:3PX>2P1Ol06:3PX?nPh:3PX>2Ph:3o0mH3eP?F
0mH3ePKo01H3eP?F0mH3eP?F0mKoWenOGimOWenO1_l03UnOoimOWenOGimOWeoo1P0000H000?oC4`0
3D`2o`Y<0_l>g`;o3=l04?oa3_4>l@ka3_4>l@ka3_43o`0Jl@ka3_4>l@kaoi1@T52@D91@T52@D91@
T502o`0IT52@D91@T52@D?maOW5nLGiaOW5nLGiaOP03o`0<OW5nLGiaOW5nLGko3d`2o`]<00ooh:3P
X>2Ph:3PX>2Ph:001?l06N2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l01?l06@<?0`l33`<?0onOGimO
WenOGimOWenOGil00_l035nOGimOWenOGimOo`H000060003oda<01U<0_lLg`0Mok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/?l075007_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaa<05OoX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoWenOGimO
WenOGimOWenOGimOWenOGimOWenOGol01P0000H000?oC4`06D`2oacO05Ool@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@kaoi1@T52@D91@T52@D91@T52@D91@T52@D91@T53oLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l074`0EooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0onOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0600001P000om<C00IC0;o
7=l07On`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o01a@01koO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lLC01Goj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?FoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00H000060003oda<01U<0_lLg`1G
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@D91@T52@D91@T52@D91@og5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01a<05Ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
1P0000H000?oC4`06D`2oacO01go/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`o`0LD00NogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co74`0EonPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`060000
1P000om<C00IC0;o7=l0Eooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oT52@D91@T52@D91@T52@
D91@T52@D91@T52@D?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0LC01Gon2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph?l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo00H000060003oda<01U<0_lLg`0Mok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/?l075007_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoaa<05OoX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Po`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKoWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol01P0000H000?oC4`06D`2oacO05Ool@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
oi1@T52@D91@T52@D91@T52@D91@T52@D91@T53oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
74`0EooPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0onOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0600001P000om<C00IC0;o7=l07On`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[3o01a@01koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lLC01G
oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?FoimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo00H000060003oda<01U<0_lLg`1Goo4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>lOn@D91@T52@D91@T52@D91@T52@D91@T52@D91@og5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko01a<05Ooh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01P0000H0ool5o`H0
0006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l0T?nPh:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGom@T52@D91@T52@D91@T52@D91@T52@
D91@T52@ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o3`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?oaa<01kol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P007?odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2oacO03[oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo7500>_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0olLC00Nok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0
01coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`2@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoe2@D91@T52@D91@T52@D91@T52@D91@T52@
D93oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo
74`07_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H00006000LooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm0;o7=l0>_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGolLD00jooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3oaa<01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO093oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
oimOWenOGimOWenOGimOWenOGimOWenOGimOWeooD91@T52@D91@T52@D91@T52@D91@T52@D91@T?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33olLC00N
oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_lLg`0jon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoaa@03[om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?o74`07_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H00006000LogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l0T?nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGom@T52@D91@T52@D91@T52@D91@T52@D91@T52@ogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?oaa<01kol@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2oacO03[oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PoimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo7500>_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0olLC00Nok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H001coOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_lLg`2@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoe2@D91@T52@D91@T52@D91@T52@D91@T52@D93oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo74`07_oa3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o
7=l0>_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolLD00jooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3oaa<01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P002_mnLGiaOW5nLGh3o`0?
OW5nLGiaOW5nLGiaOW5n00;o2Ml3oa3O00[oX>2Ph:3PX>2P0ol06Z3PX>2Ph:3PX>2Ph:3PX?nOGimO
WenOGimO0ol06EnOGimOWenOGimOWenOGom@T52@D91@T5000ol06U2@D91@T52@D91@T52@D93oOW5n
LGiaOW5n0ol06WiaOW5nLGiaOW5nLGiaOW7o3`<?0`l33`<?0ol040l33`<?0`l33`<?0`l33ol:C0?o
3d`02_oa3_4>l@ka3_43o`0Al@ka3_4>l@ka3_4>l@ka3_l01P0000H001com7kdO_Anm7kdO_Anogkd
O_Anm7kdO_Anm7kd0_l<g`03omoO00gO03[oh:3PX>2Ph:3PX>2Poj3PX>2Ph:3PX>2Ph:3PoimOWenO
GimOWenOGiooWenOGimOWenOGimOWeoo35000om@D00=D00jooAnm7kdO_Anm7kdO_mnm7kdO_Anm7kd
O_Anm7ko0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0mH3o`e<00?oC4`034`07_n`3[0>/0j`3[0>/0ko
3[0>/0j`3[0>/0j`3[0>o`H00006000:ogiaOW5nLGiaOPCo00iaooooLGiaOW5nLGiaOP;o2Ml4o`04
goooo`_O00[oX>2Ph:3PX>2P1?l06N2Poj3PX>2Ph:3PX>2PoimOWenOGimOWel01?l00iooo`02o`0C
GimOWenOGimOoe2@D91@T52@D004o`0IT53ooi1@T52@D91@T52@ogiaOW5nLGiaOP04o`0ILOooog5n
LGiaOW5nLGiao`l33`<?0`l33`04o`0?0oooo`<?0`l33`<?0`oo00Y<1?l2C0?o2D`02_oa3_4>l@ka
3_44o`0@3_7oo`ka3_4>l@ka3_4>o`H00006000LooAnm7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm0;o
2=l01OoOgmoo00;O00?ogml02]l0>_oPX>2Ph:3PX?nPh:3oX>3oh:3PX>2Ph:3PX>3oWenOGimOWenO
oimOWonOGomOWenOGimOWenOGol8D007oe1@D?m@o`02D003oe1@00Q@03[om7kdO_Anm7koO_Anogkd
O_Com7kdO_Anm7kdO_l3eP?F0mH3e_oF0mKoeP?F0ol3eP?F0mH3eP?o2D`01Om<C4co00=<00?oC4`0
24`07_n`3[0>/0j`3_l>/0ko3_l>/?n`3[0>/0j`3[0>o`H00006000LogiaOW5nLGiaog5nLOmaOW5n
ogiaOW5nLGiaOP;o2=l01OoOgmoo00;O00?ogml02]l0T?nPh:3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>2P
h:3oWenOGimOWenOoimOWonOGiooWenOGimOWenOGom@T52@D91@T?n@D93oT?n@D?m@T52@D91@T52@
ogiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW7o3`<?0`l33`?o0`l3o`<?0`oo3`<?0`l33`<?o`U<
00KoC4a<od`4o`U<01kol@ka3_4>l@ko3_4>o`ko3_7ol@ka3_4>l@ka3_l600001P004?odO_Anm7kd
O_mnm7koO_@2o`0:O_Anm7kdO_Anm0;o2=l01OoOgmoo00;O00?ogml02]l0>_oPX>2Ph:3PX?nPh:3o
X>2Poj3PX>2Ph:3PX>3oWenOGimOWenOoimOWonOGimOoenOGimOWenOGol8D005oe1@D?l00U02o`]@
013om7kdO_Anm7koO_Anogkd0_l06WkdO_Anm7kdO_Ano`?F0mH3eP?FomH3e_oF0ol02mH3eP?F0mH3
eP?o00U<00WoC4a<odcoC?l02T`03on`3[0>/0j`3_l>/0ko3P03o`0<3[0>/0j`3[0>/0ko1P0000H0
00[oOW5nLGiaOW5n1Ol03GiaO_mnLGiaOW5nLGh00_l9g`Go00?Ooml02ml02_nPh:3PX>2Ph:05o`0H
X>2Poj3PX>2Ph:3PX?nOGimOWenOGimO1_l05YmOoenOGimOWenOGom@T52@D91@T506o`0GT53oD91@
T52@D91@T?mnLGiaOW5nLGh01Ol067iaO_mnLGiaOW5nLGiao`l33`<?0`l33`Ko00d33`<?0`l33`<?
0`oo00Y<1_l00dcoC009C00:oo4>l@ka3_4>l@Ko00h>l@ka3_4>l@ka3_4>o`H00006000?ooAnm7kd
O_Anm7kdO_An00?o00Ynm7kdO_Anm7kd0_l>g`;o3=l03ooPX>2Ph:3PX>2Ph:3PX004o`0Jh:3PX>2P
h:3PoimOWenOGimOWenOGimOWel2o`0;WenOGimOWenOGol03e02o`]@00oom7kdO_Anm7kdO_Anm7h0
0ol06WkdO_Anm7kdO_Ano`?F0mH3eP?F0mH3eP?F1?l02P?F0mH3eP?F0ol@C0;o2T`04?n`3[0>/0j`
3[0>/0j`3[03o`0;/0j`3[0>/0j`3_l01P0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_lLg`2@oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoe2@D91@T52@D91@T52@D91@T52@D91@T52@D93oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo74`07_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>o`H00006000LooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l0>_oPX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLD00jooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oaa<01ko/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO
093oX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
D91@T52@D91@T52@D91@T52@D91@T52@D91@T?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33olLC00Noo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko
1P0000H001com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0jon2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoaa@03[om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o74`07_n`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>o`H00006000LogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o7=l0T?nP
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGom@T52@
D91@T52@D91@T52@D91@T52@D91@T52@ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o3`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?oaa<01kol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l60000
1P007?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2oacO03[oh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo7500>_odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Ano`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0olLC00Nok0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0ko1P0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_lLg`2@oj3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOoe2@D91@T52@
D91@T52@D91@T52@D91@T52@D93oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`oo74`07_oa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H00006000L
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o7=l0>_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGolLD00jooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3oaa<01ko/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l600001P007?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2oacO093oX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2PoimOWenOGimOWenOGimOWenOGimOWenOGimOWeooD91@T52@D91@T52@
D91@T52@D91@T52@D91@T?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33olLC00Noo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H001com7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_lLg`0jon2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoaa@03[om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o74`07_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>o`H000060?oo1Ol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO00?oC4`0
6D`0M?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
75007_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000LoimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o7=l00om<C00IC02^oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOm@T52@D91@T52@D91@T52@D91@T52@D91@T52@o`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`oo1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`03
oda<01U<07Coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`oimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoaa@01koeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P007?nOGimOWenOGimOWenO
GimOWenOGimOWenOGil2oacO00?oC4`06D`0[_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oD91@T52@D91@T52@D91@T52@D91@T52@D91@T?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
7=l00om<C00IC01don2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lLD00NomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H001coWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_lLg`03oda<01U<0:koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h?l>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaoimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoe2@D91@T52@D91@T52@D91@T52@D91@T52@D93o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oacO00?oC4`06D`0M?oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[3oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko75007_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000LoimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o7=l00om<C00IC02^oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX>3o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOm@T52@D91@T52@D91@T52@D91@T52@D91@T52@
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H001coWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_lLg`03oda<01U<07Coh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`oimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoaa@01koeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P002_nO
GimOWenOGil3o`0?WenOGimOWenOGimOWenO00;o2Ml3oa3O00?oC4`01d`3o`m<00_oX>2Ph:3PX>2P
h003o`0Ih:3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3P03o`0J3_4>l@ka3_4>l@ka3_4>lOnOGimOWenO
Gil3o`0JWenOGimOWenOGimOWenOGomaOW5nLGiaOW43o`0JLGiaOW5nLGiaOW5nLGiaoe2@D91@T52@
D903o`0IT52@D91@T52@D91@T52@o`<?0`l33`<?0`03o`0A0`l33`<?0`l33`<?0`l33ol01P0000H0
01coWenOGimOWenOGimOoenOGimOWenOGimOWenO0_l<g`03omoO00gO00?oC4`02T`00om<C00<C01d
on2Ph:3PX>2Ph:3PX>3oh:3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0j`ok0>/0j`3[0>/0j`3[0>/?nO
GimOWenOGimOWeooGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_l=D003
oe1@00a@01koeP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0ol600001P002_nOGimOWenOGil4o`03
Gooo00;o00VOGimOWenOGil00_l9g`Co00COoooo2ml00om<C007C0Co0T`3o`U<00_oX>2Ph:3PX>2P
h004o`0HX>3oh:3PX>2Ph:3PX>3o3_4>l@ka3_4>1?l06O4>oooa3_4>l@ka3_4>lOnOGimOWenOGil0
1?l00eooo`02o`0DWenOGimOWenOGomaOW5nLGiaOW44o`0IO_ooogiaOW5nLGiaOW7oD91@T52@D91@
T004o`0HD93ooe2@D91@T52@D93o0`l33`<?0`l31?l040ooool?0`l33`<?0`l33ol600001P007?nO
GimOWenOGomOWeooGiooWenOGimOWenOGil2o`SO00GogmoOo`02g`03omoO00[O00?oC4`01T`01Om<
C4co00=<00?oC4`024`0M?oPX>2Ph:3PX>3oh:3Pon2Poj3PX>2Ph:3PX>2Po`j`3[0>/0j`ok0>/?n`
ok0>o`j`3[0>/0j`3[3oWenOGimOWeooGimOoenOoimOWenOGimOWenOGomnm7kdO_Anm?odO_Com7kd
O_mnm7kdO_Anm7ko2E001om@D53oD?l00U000om@D007D00NomH3eP?F0mH3o`?F0ol3eP?FomH3eP?F
0mH3eP?o1P0000H001coWenOGimOWeooGimOoenOGomOWenOGimOWenO0_l8g`05omoOgol00]l00ooO
g`0:g`03oda<00I<00KoC4a<od`4o`U<0:koX>2Ph:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>2Ph?l>l@ka
3_4>lOoa3_7olOoa3_l>l@ka3_4>l@kaoimOWenOGimOoenOGomOWeooGimOWenOGimOWeooLGiaOW5n
LGkoOW5nogiaOW7oLGiaOW5nLGiaoe2@D91@T52@D?m@T53oD?m@T?n@D91@T52@D93o0`l33`<?0`oo
3`<?o`l33`?o0`l33`<?0`l33ol600001P007?nOGimOWenOGomOWeooGimOWonOGimOWenOGil2o`SO
00GogmoOo`02g`03omoO00[O00?oC4`01T`02Om<C4coC?m<o`0:C00/on2Ph:3PX>2Ph?oPX>3oh:3P
on2Ph:3PX>2Ph:3o3[0>/0j`3[3o/0j`ok03o`0h/0j`3[0>/0j`3[3oWenOGimOWeooGimOoenOGioo
WenOGimOWenOGomnm7kdO_Anm?odO_Com7h2o`0;m7kdO_Anm7kdO_l02E001Om@D53o009@0_l:D00?
omH3eP?F0mH3o`?F0ol300?o00`3eP?F0mH3eP?F0ol600001P002_nOGimOWenOGil6o`0<GiooWenO
GimOWenO0_l9g`Go00?Ooml02ml00om<C007C0Ko00=<od`02D`02onPh:3PX>2Ph:3P00Go01OPX>3o
h:3PX>2Ph:3Po`ka3_4>l@ka3P06o`0Gl@ka3_4>l@ka3_4>lOnOGimOWenOGil01_l05enOoimOWenO
GimOWeooLGiaOW5nLGia00Go01QaOW7oLGiaOW5nLGiaoe2@D91@T52@D906o`0FD93oT52@D91@T52@
o`<?0`l33`<?0`Ko00h?0`l33`<?0`l33`<?o`H00006000@oimOWenOGimOWenOGimOW`;o00YOWenO
GimOWenO0_l>g`;o3=l00om<C00=C0;o2T`04?oPX>2Ph:3PX>2Ph:3PX>04o`0IX>2Ph:3PX>2Po`j`
3[0>/0j`3[0>/0j`3P03o`0J3[0>/0j`3[0>/?nOGimOWenOGimOWenOGil2o`0JGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_@3o`0;m7kdO_Anm7kdO_l04502o`Y@00ooeP?F0mH3eP?F0mH3eP<01?l02mH3
eP?F0mH3eP?o00H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l00om<C00IC02^
oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOm@T52@
D91@T52@D91@T52@D91@T52@D91@T52@o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H0
01coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`03oda<01U<07Coh:3PX>2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX?l>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa@01koeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0ol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO00?oC4`0
6D`0[_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_7oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
D91@T52@D91@T52@D91@T52@D91@T52@D91@T?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H0
0006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l00om<C00IC01don2Ph:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLD00NomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?o1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`03
oda<01U<0:koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@kaoimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoe2@D91@T52@D91@T52@D91@T52@D91@T52@D93o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3ol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenOGil2oacO00?oC4`06D`0M?oPX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Po`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko75007_oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
7=l00om<C00IC02^oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>3o3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>lOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOm@T52@D91@T52@D91@T52@D91@T52@D91@T52@o`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo1P0000H001coWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lLg`03oda<01U<07Coh:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?l>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa@01koeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P007?nOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oacO00?oC4`06D`0[_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_7oWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7oD91@T52@D91@T52@D91@T52@D91@T52@D91@T?l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?o`H00006000LoimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o7=l00om<C00IC01d
on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLD00N
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H001coWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_lLg`03oda<01U<0:koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kaoimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoe2@D91@T52@D91@T52@D91@T52@D91@T52@D93o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33ol600001P3oo`Go1P0000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03
omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03
o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml0
6Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03
omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03
o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml0
6Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03
omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O00?ogml06]l00ol0000400001P000ooOg`0Ig`;o
7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooOg`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03
o`0000@000060003omoO01WO0_lLg`03omoO01WO00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml0
6Ml00ooOg`0Jg`03omoO01[O00?o0000100000H000?ogml01ml3o`oO0_l9g`?o4=l00ooOg`07g`?o
3ml00ooOg`08g`?o3ml00ooOg`07g`?o4=l00ooOg`07g`?o4=l00ooOg`07g`?o3ml00ooOg`08g`?o
3ml00ooOg`07g`?o4=l00ol0000400001P000ooOg`0:g`03omoO00cO0_l<g`03omoO00gO00?ogml0
2]l00ooOg`0<g`03omoO00_O00?ogml03=l00ooOg`0:g`03omoO00gO00?ogml02]l00ooOg`0=g`03
omoO00[O00?ogml03=l00ooOg`0;g`03omoO00cO00?ogml02]l00ooOg`0=g`03o`0000@000060003
omoO00OO1?l01=ooool:g`;o2Ml4o`04goooo`_O00?ogml01ml4o`04goooo`[O00?ogml02=l4o`04
goooo`[O00?ogml01ml4o`04goooo`_O00?ogml01ml4o`04goooo`_O00?ogml01ml4o`04goooo`[O
00?ogml02=l4o`04goooo`[O00?ogml01ml4o`04goooo`_O00?o0000100000H000?ogml01]l01OoO
gmoo00;O00?ogml02Ml2o`SO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml0
2Ml00ooOg`07g`05omoOgol00]l00ooOg`09g`03omoO00KO00GogmoOo`02g`03omoO00[O00?ogml0
1]l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooOg`09g`03omoO00OO00GogmoO
o`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O00?ogml02]l00ol0000400001P000ooOg`06g`05
omoOgol00]l00ooOg`09g`;o2=l01OoOgmoo00;O00?ogml02]l00ooOg`06g`05omoOgol00]l00ooO
g`09g`03omoO00OO00GogmoOo`02g`03omoO00WO00?ogml01]l01OoOgmoo00;O00?ogml02]l00ooO
g`06g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03omoO00WO00?ogml01ml01OoO
gmoo00;O00?ogml02Ml00ooOg`06g`05omoOgol00]l00ooOg`0:g`03o`0000@000060003omoO00KO
00GogmoOo`02g`03omoO00WO0_l8g`05omoOgol00]l00ooOg`0:g`03omoO00KO00GogmoOo`02g`03
omoO00WO00?ogml01ml01OoOgmoo00;O00?ogml02Ml00ooOg`06g`05omoOgol00]l00ooOg`0:g`03
omoO00KO00GogmoOo`02g`03omoO00[O00?ogml01]l01OoOgmoo00;O00?ogml02Ml00ooOg`07g`05
omoOgol00]l00ooOg`09g`03omoO00KO00GogmoOo`02g`03omoO00[O00?o0000100000H000?ogml0
1ml5o`03gooO00[O0_l9g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02]l00ooOg`08g`Go00?Ooml0
2]l00ooOg`07g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02ml00ooOg`07g`Go00?Ooml02]l00ooO
g`08g`Go00?Ooml02]l00ooOg`07g`Go00?Ooml02ml00ol0000400001P000ooOg`0<g`;o2ml2o`kO
0_l<g`03omoO00cO0_l;g`03omoO00gO0_l;g`03omoO00cO0_l<g`03omoO00cO0_l<g`03omoO00cO
0_l;g`03omoO00gO0_l;g`03omoO00cO0_l<g`03o`0000@000060003omoO01WO0_lLg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H0
00?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O
00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooO
g`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H0
00?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O
00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooO
g`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000H0
00?ogml06Ml2oacO00?ogml06Ml00ooOg`0Jg`03omoO01[O00?ogml06]l00ooOg`0Ig`03omoO01[O
00?ogml06]l00ol0000400001P000ooOg`0Ig`;o7=l00ooOg`0Ig`03omoO01[O00?ogml06]l00ooO
g`0Jg`03omoO01WO00?ogml06]l00ooOg`0Jg`03o`0000@000060003omoO01WO0_lLg`03omoO01WO
00?ogml06]l00ooOg`0Jg`03omoO01[O00?ogml06Ml00ooOg`0Jg`03omoO01[O00?o0000100000D0
ool6o`H000050?oo1_l600001P000ol0000H00?o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lLC01GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3P
X>3o01a@00?o0000100000H000?o00005`001?l0oolLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003o`0001H000?o00000_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<
05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ol0000E0004o`0000;o
7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@
D?l600001P000ol0000D0003o`0000800_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l0
75000ol0000400001P000ol0000C0003o`0000<00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@D91@o`H000060003o`0000@00_l00`3oo`090003
o`0000@00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoaa<05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ol0
00050003o`3o00T000?o00001@02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@
D91@T52@D91@T52@D91@T52@D91@T53o1P0000H000?o00001P000ol000070003o`0000H00_lLg`0j
oimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoaa<
05OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko
X>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph?l075000ol0000400001P000ol000050003o`3o00L0
00?o00001`02o`WO0ol@g`0:oimOWenOGimOW`?o01ZOGimOWenOGimOWenOGiooOW5nLGiaOW5nL@?o
011aOW5nLGiaOW5nLGiaOW7o2D`3oa1<00[o0`l33`<?0`l30ol06P<?0`l33`<?0`l33`<?0`oo3_4>
l@ka3_4>0ol06Pka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P0ol06J3PX>2Ph:3PX>2Ph:3PX?n@D91@
T52@D9000ol04I1@T52@D91@T52@D91@T53o00H000060003o`0000@00_l00`3oo`050003o`0000P0
0_l<g`03omoO00gO03[oWenOGimOWenOGimOoenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Com7kd
O_Anm7kdO_Anm7ko34`00om<C00=C01GomH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?o3[0>/0j`
3[0>/0j`ok0>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX>3o00a@00?oD500
3E000ol0000400001P000ol0000=0003o`0000T00_l9g`Co00COoooo2ml02_nOGimOWenOGil4o`03
Gooo00;o01BOGimOWenOGiooOW5nLGiaOW5nL@Co00mnooooOW5nLGiaOW5nLOl02D`4o`9<0ol:C00:
o`<?0`l33`<?0`Co01T?oooo3`<?0`l33`<?0`oo3_4>l@ka3_4>00Co01Wa3_ool@ka3_4>l@ka3_oP
X>2Ph:3PX>2P00Co01SPX?nPh:3PX>2Ph:3PX?n@D91@T52@D904o`0@D93ooe2@D91@T52@D91@o`H0
00060003o`0000`000?o00002P02o`SO00GogmoOo`02g`03omoO00[O03[oWenOGimOWeooGimOoenO
oimOWenOGimOWenOooAnm7kdO_Anm?odO_Com7kdO_mnm7kdO_Anm7ko24`01Om<C4co00=<00?oC4`0
2D`0EooF0mH3eP?F0ol3eP?o0mH3e_oF0mH3eP?F0mH3o`j`3[0>/0j`ok0>/?n`ok0>o`j`3[0>/0j`
3_nPh:3PX>2Ph:3oX>2Poj3Pon2Ph:3PX>2Ph:3Po`08D007oe1@D?m@o`02D003oe1@00Q@00?o0000
100000H000?o00002`000ol0000;00;o2=l01OoOgmoo00;O00?ogml02]l0>_nOGimOWenOGomOWeoo
GimOoenOGimOWenOGiooOW5nLGiaOW5nogiaO_mnLGiaog5nLGiaOW5nLOl8C006oda<C?m<1?l:C01d
o`<?0`l33`<?o`l33ol?0`l3o`<?0`l33`<?0`oo3_4>l@ka3_7ol@kaoo7ol@ko3_4>l@ka3_4>on2P
h:3PX>2Ph?oPX>3oh:3Pon2Ph:3PX>2Ph:3oT52@D91@T53oD91@oe3oD93oT52@D91@T52@D?l60000
1P000ol0000:0003o`0000`00_l8g`05omoOgol00]l00ooOg`0:g`0]oimOWenOGimOoenOGomOWenO
oimOWenOGimOWoodO_Anm7kdO_Com7kdooAn00;o00_dO_Anm7kdO_Ano`08C009oda<C?m<odco00]<
00ooeP?F0mH3eP?o0mH3o`<00ol06P?F0mH3eP?F0mH3o`j`3[0>/0j`ok0>/?n`0ol0:;0>/0j`3[0>
/0koX>2Ph:3PX>2Poj3PX?nPh:3oX>2Ph:3PX>2Ph?l8D005oe1@D?l00U02o`]@00?o0000100000H0
00?o00002@000ol0000400?o1P02o`WO1Ol00moog`0;g`0:oimOWenOGimOW`Ko01MOWonOGimOWenO
GiooOW5nLGiaOW5nL@05o`0>LGiaog5nLGiaOW5nLOl9C0Ko00=<od`02T`02_l33`<?0`l33`<6o`0G
3`<?0`l33`<?0`l33ol>l@ka3_4>l@h01_l05o4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P00Go01NPh:3o
X>2Ph:3PX>2Poi1@T52@D91@T006o`0>D93oT52@D91@T52@D?l600001P000ol000080003o`0000H0
00?o00001@02o`kO0_l<g`0@oimOWenOGimOWenOGimOW`;o01YOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm0?o00_dO_Anm7kdO_Ano`0?C0;o2d`03ooF0mH3eP?F0mH3eP?F0`04o`0JeP?F0mH3eP?F0ol>
/0j`3[0>/0j`3[0>/0h3o`0I3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3PX004o`0:h:3PX>2Ph:3Po`m@
0_l;D003o`0000@000060003o`0000L000?o000020000ol0000400;o7=l0>_nOGimOWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ol000060003
o`0000T000?o00001002oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@0
00060003o`0000D000?o00002@000ol0o`0500;o7=l0>_nOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlLC01do`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2P
h:3oT52@D91@T52@D91@T52@D91@T52@D91@T52@D?l600001P000ol000040003o`0000X000?o0?l0
1@02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`0000<0
00?o00002P02o`030?oo00@00_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@
D91@T52@D91@T52@D91@T52@D91@o`H000060003o`00008000?o00005002oacO03[oWenOGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3P
X>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060005o`000?l05`02oacO03[oWenOGimOWenO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o74`0M?l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2P
h:3PX>2Ph:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D91@T52@D91@T52@D91@T53o1P0000H000Co003o
6002oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@000060003o`3o01T0
0_lLg`0joimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoaa<07Co0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@koh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@D91@T52@D91@T52@
D91@o`H0000600;o6P02oacO03[oWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko74`0EooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Ph:3PX>2Ph:3PX>2Ph:3Po`0LD003o`0000@0
00060?oo1Ol600008P02on`0003o0140003o0140003o014000090004o`0000CoA@03ofl000?o0000
A@0000P000?o00000P000ol000190003o`0005X000?o000040000ol00014000020000ol0000200?o
0`05o`800ol300?o0P05o`801?l0103oo`02o`800ol700;o0P02o`030?oo00?o00@0ool00_l200Co
1`001Ol0o`3o00800ol300Go1P03o`/000?o00001P02o`030?oo00X000?o00001P02o`030?oo00T0
00?o00001`02o`030?oo00@000?o0000A00000P000Go0000o`030004o`00o`8000Co003o0`001?l0
0?l20005o`000?l00`000ol000030004o`00o`<000Co003o1`001?l0ool40005o`000?l00P001?l0
0?l30003o`0000D000Oo0?l0o`3o00<000?o0?l00`000ol000060003o`0000X000?o00001`000ol0
o`0;0003o`0000L000?o0?l02`000ol000070003o`3o00D000?o0000A00000P000Go0000o`030004
o`00o`8000Co003o0`001?l00?l60004o`0000Go00D0o`00o`030003o`0000P00ol50005o`000?l0
0P001?l00?l30003o`0000D000Oo0?l0o`3o00<000?o0?l00`000ol000060003o`0000P01Ol80003
o`0000P01Ol80003o`0001D000?o000010000ol00014000020001Ol0003o00<000Co003o0P001?l0
0?l30004o`00o`H000Go0000o`030003o`3o008000Go0000o`0:0004o`00o`@000Go0000o`020004
o`00o`<000?o00001@001ol0o`3o0?l00`000ol0o`030003o`0000H000?o00002P000ol000070003
o`3o00/000?o00001`000ol0o`0E0003o`3o00D000?o0000A00000P000Go0000o`030005o`3oo`00
0_l300?o0P04o`<00_l400?o00<0ool00ol200Co20001?l00?l300;o0P05o`<01Ol500Ko0P03o`<0
1?l80003o`0000X000?o00001P02o`030?oo00X000?o00001P02o`030?oo01<00_l00`3oo`040003
o`0003D00ol<00002@001?l00003oa0000?o00005@000ol0000700Co:`000ol0000500;oC@000ol0
000g0003o`0000/0000P0003o`0000@000?o00003P000ol0000@0003o`0002800_mg00;o00<0ool0
2@000ol0o`090003o`0000X0003Z0003o`3o00/000?o000020000ol0000:0000j`000ol0000800Go
1`000ol0o`0;0000jP000ol0o`0;0003o`0000L000?o0?l02`000>T00_l00`3oo`0C00;o00<0ool0
2P000?l04@000:l00omN0000/P000ol0001K0000/P000ol0001K0000\
\>"],
  ImageRangeCache->{{{0, 271.812}, {287, 0}} -> {-1.22505, -0.239038, 
  0.034767, 0.034767}},
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell[TextData[{
  "A limit to the size of a polynomial quotient ring is controlled by the \
option ",
  StyleBox["SizeLimit", "MR"],
  ". The default limit is 50. "
}], "Text",
  CellTags->"QuotientPolynomials"],

Cell[TextData[{
  "This ringoid, with ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(11\^4\), "=", 
          FormBox["14641",
            "TraditionalForm"]}], TraditionalForm]]],
  " elements, is far too large to generate (in this version of ",
  StyleBox["AbstractAlgebra", "MR"],
  ")."
}], "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(QuotientRing[Z[11], Poly[Z[11], x\^4 + x + 1]]\)], "Input",
  CellLabel->"In[83]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    \(QuotientRing::"toobig" \( : \ \) 
      "Requested quotient ring is likely to be too large. Option SizeLimit \
can be reset."\)], "Message",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[83]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell["\<\
The modulus polynomial need not be irreducible, as in the following \
case.\
\>", "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Q2 = QuotientRing[Z[3], Poly[Z[3], x\^2 + 2]]\)], "Input",
  CellLabel->"In[84]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    \(Ringoid[{0, x, 2\ x, "1", "1" + x, "1" + 2\ x, "2", "2" + x, 
        "2" + 2\ x}, "-Addition-", "-Multiplication-"]\)], "Output",
  CellLabel->"Out[84]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell[TextData[{
  "Fields do not have zero divisors, but ",
  StyleBox["Q2", "MR"],
  " clearly does."
}], "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Multiplication[Q2]\)[Poly[Z[3], x + 1], Poly[Z[3], x + 2]]\)], "Input",\

  CellLabel->"In[85]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[85]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell[TextData[{
  "Consider the element ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  " in ",
  StyleBox["Q2", "MR"],
  ". Note that ",
  Cell[BoxData[
      \(TraditionalForm\`\((2  x)\)\^2 + 2 = \(4  x\^2 + 2 = x\^2 + 2\)\)]],
  ". Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  " is a root (zero) of the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2\)]],
  " over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  ". The following function confirms this."
}], "MathCaption",
  CellTags->"QuotientPolynomials"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EvaluationInExtension[Q2, ModulusPolynomial[Q2], \ Poly[Z[3], \ 2  x]]
      \)], "Input",
  CellLabel->"In[86]:=",
  CellTags->"QuotientPolynomials"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[86]=",
  CellTags->"QuotientPolynomials"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EvaluationInExtension",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(E, \ p, \ q\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["E",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ as\ the\ quotient\ ring\ of\ a\ field\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["F",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["irreducible",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"]}], ",", " ", 
              RowBox[{
                StyleBox["this",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["evaluates",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["induced",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coset",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["equivalent",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ at\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["q",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["E",
                    "TraditionalForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"QuotientPolynomials", "i:37"}],

Cell["Doing evaluation in field extensions.", "Caption",
  CellTags->"QuotientPolynomials"],

Cell["3.8.5 Irreducibility of integer-based polynomials", "Subsubsection",
  CellTags->{"Irreducibility", "i:38"}],

Cell[TextData[{
  "Assuming ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is a polynomial over the integers, ",
  Cell[BoxData[
      \(TraditionalForm\`p(0) \[NotEqual] 0\)]],
  ", then if ",
  Cell[BoxData[
      \(TraditionalForm\`r\/s\)]],
  " is a rational root of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " must be a divisor of the constant coefficient and ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " must divide the leading coefficient. This is the essence of the Rational \
Root Theorem. Eisenstein\[CloseCurlyQuote]s Criterion and the Mod ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " Irreducibility Test are two other methods for determining the \
irreducibility of polynomials over the integers. Some or all of these \
approaches are in most standard abstract algebra books, as well as in ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  ". Note that these functions work with polynomials that are ",
  StyleBox["not",
    FontSlant->"Italic"],
  " constructed with the ",
  StyleBox["Poly", "MR"],
  " function; ordinary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " polynomials are used."
}], "Text",
  CellTags->"Irreducibility"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RationalRootCandidates",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["zpoly",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["candidates",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rational",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["roots",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomial",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["zpoly",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["RationalRootTheorem",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["zpoly",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["pair",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["lists",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["consisting",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rational",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["roots",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["zpoly",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(followed\ by\ the\ candidates\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ModpIrreducibilityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["zpoly",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomial",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["zpoly",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["irreducible",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["according",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "Mod", " ", 
              StyleBox["p",
                FontSlant->"Italic"], " ", "Irreducibility", " ", "Test", 
              " ", 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["prime",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(p, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ModpIrreducibilityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(zpoly, \ n\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["zpoly",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["determined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["irreducible",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["according",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Mod",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["p",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Irreducibility",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Test",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["using",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["first",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["n",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["primes",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((defaulting\ to\ 25)\),
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ModpIrreducibilityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["zpoly",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Mode\  \[Rule] \ Textual\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["textual",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["commentary",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["result",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["applying",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Mod",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["p",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Irreducibility",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Test",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["zpoly",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(also\ giving\ the\ computational\ result\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["EisensteinsCriterionQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["zpoly",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["zpoly",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["irreducible",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[\(according\ to\ Eisenstein' s\ Criterion\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["EisensteinsCriterionQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["zpoly",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[
                      FormBox[
                        StyleBox[\(Mode\  \[Rule] \ Textual\),
                          "MR"],
                        "TraditionalForm"],
                      "TI"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["textual",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["commentary",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["result",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["applying",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(Eisenstein' s\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Criterion",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["zpoly",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(also\ giving\ the\ computational\ result\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"Irreducibility", "i:41"}],

Cell["\<\
Functions for testing irreducibility of integer-based \
polynomials.\
\>", "Caption",
  CellTags->"Irreducibility"],

Cell["\<\
The possible rational roots here are determined by the numbers -7 \
and 4: divisors of -7 divided by divisors of 4.\
\>", "MathCaption",
  CellTags->"Irreducibility"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RationalRootCandidates[4\ x\^5 + 5\ x\^3 - 2\ x\^2 - 7]\)], "Input",
  CellLabel->"In[87]:=",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \({\(-7\), \(-\(7\/2\)\), \(-\(7\/4\)\), \(-1\), \(-\(1\/2\)\), 
      \(-\(1\/4\)\), 1\/4, 1\/2, 1, 7\/4, 7\/2, 7}\)], "Output",
  CellLabel->"Out[87]=",
  CellTags->"Irreducibility"]
}, Open  ]],

Cell["\<\
Here the list of candidates is preceded by the list of rational \
roots.\
\>", "MathCaption",
  CellTags->"Irreducibility"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RationalRootTheorem[4\ x\^5 + 5\ x\^3 - 2\ x\^2 - 7]\)], "Input",
  CellLabel->"In[88]:=",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \({{1}, {\(-7\), \(-\(7\/2\)\), \(-\(7\/4\)\), \(-1\), \(-\(1\/2\)\), 
        \(-\(1\/4\)\), 1\/4, 1\/2, 7\/4, 7\/2, 7}}\)], "Output",
  CellLabel->"Out[88]=",
  CellTags->"Irreducibility"]
}, Open  ]],

Cell[TextData[{
  "Now we consider the irreducibility of the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^6 + 7  x\^2 - 6\)]],
  " over the integers. Reducing the polynomial mod 2, we see that this \
reduced polynomial is not irreducible."
}], "MathCaption",
  CellTags->"Irreducibility"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ModpIrreducibilityQ[2, x\^6 + 7\ x\^2 - 6]\)], "Input",
  CellLabel->"In[89]:=",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[89]=",
  CellTags->"Irreducibility"]
}, Open  ]],

Cell[TextData[{
  "Considering the same polynomial, we find that when we get to the sixth \
prime (13), we can show that this polynomial is indeed irreducible, by means \
of the Mod ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " Irreducibility Test."
}], "MathCaption",
  CellTags->"Irreducibility"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ModpIrreducibilityQ[x\^6 + 7\ x\^2 - 6, Mode \[Rule] Textual]\)], 
  "Input",
  CellLabel->"In[90]:=",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("When the coefficients are reduced mod 2, this polynomial becomes "\
\[InvisibleSpace]\(x\^2 + x\^6\)\[InvisibleSpace]"."\),
      SequenceForm[ 
      "When the coefficients are reduced mod 2, this polynomial becomes ", 
        Plus[ 
          Power[ x, 2], 
          Power[ x, 6]], "."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("Factoring over Z[2], we obtain "\[InvisibleSpace]\(x\^2\ 
          \((1 + x)\)\^4
            \)\[InvisibleSpace]" Since this modified polynomial is not \
irreducible or does not have the same degree as the original, we try the next \
prime."\),
      SequenceForm[ "Factoring over Z[2], we obtain ", 
        Times[ 
          Power[ x, 2], 
          Power[ 
            Plus[ 1, x], 4]], 
        " Since this modified polynomial is not irreducible or does not have \
the same degree as the original, we try the next prime."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("When the coefficients are reduced mod 3, this polynomial becomes "\
\[InvisibleSpace]\(x\^2 + x\^6\)\[InvisibleSpace]"."\),
      SequenceForm[ 
      "When the coefficients are reduced mod 3, this polynomial becomes ", 
        Plus[ 
          Power[ x, 2], 
          Power[ x, 6]], "."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("Factoring over Z[3], we obtain "\[InvisibleSpace]\(x\^2\ 
          \((2 + x + x\^2)\)\ 
          \((2 + 2\ x + x\^2)
            \)\)\[InvisibleSpace]" Since this modified polynomial is not \
irreducible or does not have the same degree as the original, we try the next \
prime."\),
      SequenceForm[ "Factoring over Z[3], we obtain ", 
        Times[ 
          Power[ x, 2], 
          Plus[ 2, x, 
            Power[ x, 2]], 
          Plus[ 2, 
            Times[ 2, x], 
            Power[ x, 2]]], 
        " Since this modified polynomial is not irreducible or does not have \
the same degree as the original, we try the next prime."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("When the coefficients are reduced mod 5, this polynomial becomes "\
\[InvisibleSpace]\(4 + 2\ x\^2 + x\^6\)\[InvisibleSpace]"."\),
      SequenceForm[ 
      "When the coefficients are reduced mod 5, this polynomial becomes ", 
        Plus[ 4, 
          Times[ 2, 
            Power[ x, 2]], 
          Power[ x, 6]], "."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("Factoring over Z[5], we obtain "\[InvisibleSpace]\(\((
            1 + 3\ x + x\^2 + x\^3)\)\ 
          \((4 + 3\ x + 4\ x\^2 + x\^3)
            \)\)\[InvisibleSpace]" Since this modified polynomial is not \
irreducible or does not have the same degree as the original, we try the next \
prime."\),
      SequenceForm[ "Factoring over Z[5], we obtain ", 
        Times[ 
          Plus[ 1, 
            Times[ 3, x], 
            Power[ x, 2], 
            Power[ x, 3]], 
          Plus[ 4, 
            Times[ 3, x], 
            Times[ 4, 
              Power[ x, 2]], 
            Power[ x, 3]]], 
        " Since this modified polynomial is not irreducible or does not have \
the same degree as the original, we try the next prime."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("When the coefficients are reduced mod 7, this polynomial becomes "\
\[InvisibleSpace]\(1 + x\^6\)\[InvisibleSpace]"."\),
      SequenceForm[ 
      "When the coefficients are reduced mod 7, this polynomial becomes ", 
        Plus[ 1, 
          Power[ x, 6]], "."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("Factoring over Z[7], we obtain "\[InvisibleSpace]\(\((1 + x\^2)\)\ 
          \((2 + x\^2)\)\ 
          \((4 + x\^2)
            \)\)\[InvisibleSpace]" Since this modified polynomial is not \
irreducible or does not have the same degree as the original, we try the next \
prime."\),
      SequenceForm[ "Factoring over Z[7], we obtain ", 
        Times[ 
          Plus[ 1, 
            Power[ x, 2]], 
          Plus[ 2, 
            Power[ x, 2]], 
          Plus[ 4, 
            Power[ x, 2]]], 
        " Since this modified polynomial is not irreducible or does not have \
the same degree as the original, we try the next prime."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("When the coefficients are reduced mod 11, this polynomial becomes "\
\[InvisibleSpace]\(5 + 7\ x\^2 + x\^6\)\[InvisibleSpace]"."\),
      SequenceForm[ 
      "When the coefficients are reduced mod 11, this polynomial becomes ", 
        Plus[ 5, 
          Times[ 7, 
            Power[ x, 2]], 
          Power[ x, 6]], "."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("Factoring over Z[11], we obtain "\[InvisibleSpace]\(\((4 + x)\)\ 
          \((7 + x)\)\ 
          \((10 + 5\ x\^2 + x\^4)
            \)\)\[InvisibleSpace]" Since this modified polynomial is not \
irreducible or does not have the same degree as the original, we try the next \
prime."\),
      SequenceForm[ "Factoring over Z[11], we obtain ", 
        Times[ 
          Plus[ 4, x], 
          Plus[ 7, x], 
          Plus[ 10, 
            Times[ 5, 
              Power[ x, 2]], 
            Power[ x, 4]]], 
        " Since this modified polynomial is not irreducible or does not have \
the same degree as the original, we try the next prime."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[
      \("When the coefficients are reduced mod 13, this polynomial becomes "\
\[InvisibleSpace]\(7 + 7\ x\^2 + x\^6\)\[InvisibleSpace]"."\),
      SequenceForm[ 
      "When the coefficients are reduced mod 13, this polynomial becomes ", 
        Plus[ 7, 
          Times[ 7, 
            Power[ x, 2]], 
          Power[ x, 6]], "."],
      Editable->False]], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \("Since this modified polynomial is irreducible over Z[13], then the \
original is irreducible over Q by the Mod p Irreducibility Test."\)], "Print",\

  CellTags->"Irreducibility"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[90]=",
  CellTags->"Irreducibility"]
}, Open  ]],

Cell[TextData[{
  "Using the option ",
  StyleBox["Modulus", "MR"],
  " in the ",
  StyleBox["Factor", "MR"],
  " function, we can obtain similar results."
}], "MathCaption",
  CellTags->"Irreducibility"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Factor[x\^6 + 7  x\^2 - 6, \ Modulus\  \[Rule] \ Prime[#]]&, 
        Range[1, 6]] // ColumnForm\)], "Input",
  CellLabel->"In[91]:=",
  CellTags->"Irreducibility"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(x\^2\ \((1 + x)\)\^4\)},
          {\(x\^2\ \((2 + x + x\^2)\)\ \((2 + 2\ x + x\^2)\)\)},
          {
            \(\((1 + 3\ x + x\^2 + x\^3)\)\ 
              \((4 + 3\ x + 4\ x\^2 + x\^3)\)\)},
          {\(\((1 + x\^2)\)\ \((2 + x\^2)\)\ \((4 + x\^2)\)\)},
          {\(\((4 + x)\)\ \((7 + x)\)\ \((10 + 5\ x\^2 + x\^4)\)\)},
          {\(7 + 7\ x\^2 + x\^6\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        Times[ 
          Power[ x, 2], 
          Power[ 
            Plus[ 1, x], 4]], 
        Times[ 
          Power[ x, 2], 
          Plus[ 2, x, 
            Power[ x, 2]], 
          Plus[ 2, 
            Times[ 2, x], 
            Power[ x, 2]]], 
        Times[ 
          Plus[ 1, 
            Times[ 3, x], 
            Power[ x, 2], 
            Power[ x, 3]], 
          Plus[ 4, 
            Times[ 3, x], 
            Times[ 4, 
              Power[ x, 2]], 
            Power[ x, 3]]], 
        Times[ 
          Plus[ 1, 
            Power[ x, 2]], 
          Plus[ 2, 
            Power[ x, 2]], 
          Plus[ 4, 
            Power[ x, 2]]], 
        Times[ 
          Plus[ 4, x], 
          Plus[ 7, x], 
          Plus[ 10, 
            Times[ 5, 
              Power[ x, 2]], 
            Power[ x, 4]]], 
        Plus[ 7, 
          Times[ 7, 
            Power[ x, 2]], 
          Power[ x, 6]]}],
      Editable->False]], "Output",
  CellLabel->"Out[91]=",
  CellTags->"Irreducibility"]
}, Open  ]],

Cell[TextData[
"For certain polynomials, Eisenstein\[CloseCurlyQuote]s Criterion ably \
determines irreducibility."], "MathCaption",
  CellTags->"Irreducibility"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EisensteinsCriterionQ[5\ x\^4 - 27\ x\^2 + 6\ x + 12, 
      Mode \[Rule] Textual]\)], "Input",
  CellLabel->"In[92]:=",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \("The coefficients to consider (from low degree to high degree) are: \
{12, 6, -27, 0, 5}"\)], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \("3 is a prime that divides all of the first n-1 coefficients."\)], 
  "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \("Is it true that 3 does not divide 5? \[Rule] True"\)], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \("Is it true that 9 does not divide 12? \[Rule] True"\)], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \("Therefore, 3 is a prime that illustrates the polynomial is \
irreducible."\)], "Print",
  CellTags->"Irreducibility"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[92]=",
  CellTags->"Irreducibility"]
}, Open  ]],

Cell["3.8.6 Functions related to solving equations or evaluation", 
  "Subsubsection",
  CellTags->{"FunctionsSolving", "i:42"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PolynomialEvaluation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["\[Alpha]",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(given\ the\ polynomial\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(p, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["evaluate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  StyleBox[\(p(\[Alpha])\),
                    SingleLetterItalics->False],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ for\ \[Alpha]\ in\ the\ base\ ring\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["p",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["PolynomialEvaluation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["\[Alpha]",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(given\ the\ polynomial\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["p",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ in\ the\ ring\ of\ polynomials\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(P, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["evaluate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  StyleBox[\(p(\[Alpha])\),
                    SingleLetterItalics->False],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ for\ \[Alpha]\ in\ the\ base\ ring\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["p",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["PolynomialEvaluation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["P",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["rules",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"use", " ", 
              StyleBox["rules",
                FontSlant->"Italic"], " ", "to", " ", "specify", " ", "the", 
              " ", "value", \((s)\), " ", "at", " ", "which", " ", "the", 
              " ", "polynomial", 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["p",
                FontSlant->"Italic"], " ", "should", " ", "be", " ", 
              "evaluated"}]},
          {
            RowBox[{
              StyleBox["Solve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{"p", " ", 
                    StyleBox["==",
                      "MR"], " ", "\[Alpha]"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ a\ polynomial\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["value",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\[Alpha]",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["base",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(p, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["solve",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["equation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["p",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["=",
                      SingleLetterItalics->False], " ", 
                    StyleBox["\[Alpha]",
                      SingleLetterItalics->False]}],
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Zeros",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["zeros",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomial",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["p",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"FunctionsSolving", "i:43"}],

Cell["\<\
Functions for solving equations or evaluating polynomials in a \
polynomial extension.\
\>", "Caption",
  CellTags->"FunctionsSolving"],

Cell[TextData[{
  "If we are interested in the zeros of the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2  x - 3\)]],
  " over the ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  ", we can map the ",
  StyleBox["PolynomialEvaluation", "MR"],
  " function over the elements of the ring and look for a zero."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{#, PolynomialEvaluation[p = Poly[Z[5], \ x\^2 + 2  x\  - 3], #]}&, 
        \ Elements[Z[5]]] // 
      TableForm[#, \ TableHeadings\  \[Rule] {None, {"\<x\>", "\<p(x)\n\>"}}]&
        \)], "Input",
  CellLabel->"In[93]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"x\"\>", \("p(x)\n"\)},
          {"0", "2"},
          {"1", "0"},
          {"2", "0"},
          {"3", "2"},
          {"4", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"x", "p(x)\n"}}]&)]], "Output",
  CellLabel->"Out[93]//TableForm=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "This result can also be obtained using the ",
  StyleBox["Zeros", "MR"],
  " function."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Zeros[p]\)], "Input",
  CellLabel->"In[94]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    \({1, 2}\)], "Output",
  CellLabel->"Out[94]=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Solve", "MR"],
  " function is one more means of finding the zeros of a polynomial \
function."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeros\  = \ Solve[p\  == \ 0]\)], "Input",
  CellLabel->"In[95]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    \({{x \[Rule] 1}, {x \[Rule] 2}}\)], "Output",
  CellLabel->"Out[95]=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "The output of the ",
  StyleBox["Solve", "MR"],
  " command is in the same form used by the standard ",
  StyleBox["Solve", "MR"],
  " command. Furthermore, this output can be used by the ",
  StyleBox["ReplaceAll", "MR"],
  " function (alias /.)."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p\  /. \ zeros\)], "Input",
  CellLabel->"In[96]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    \({0, 0}\)], "Output",
  CellLabel->"Out[96]=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Solve", "MR"],
  " function is useful for more than locating zeros."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sols\  = \ Solve[p\  == \ 2]\)], "Input",
  CellLabel->"In[97]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    \({{x \[Rule] 0}, {x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[97]=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "By evaluating the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " at the solutions given by the ",
  StyleBox["Solve", "MR"],
  " command, we can confirm that indeed these yield the value 2 in each \
case."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialEvaluation[PolynomialsOver[Z[5]], \ p, sols]\)], "Input",
  CellLabel->"In[98]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    \({2, 2}\)], "Output",
  CellLabel->"Out[98]=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "A single rule can be given, such as ",
  StyleBox["x \[Rule] 3", "MR"],
  ", or a list of rules can be given as the third argument."
}], "MathCaption",
  CellTags->"FunctionsSolving"],

Cell[CellGroupData[{

Cell[BoxData[
    \({PolynomialEvaluation[\ Poly[Z[7], \ x\^2 + \ 2  x\  - 3], \ 
        x\  \[Rule] \ 3], 
      PolynomialEvaluation[\ 
        Poly[Z[7], \ x\^2 + \ 2  x\  - 3], {x \[Rule] 3, x \[Rule] 2}]}\)], 
  "Input",
  CellLabel->"In[99]:=",
  CellTags->"FunctionsSolving"],

Cell[BoxData[
    \({5, {5, 5}}\)], "Output",
  CellLabel->"Out[99]=",
  CellTags->"FunctionsSolving"]
}, Open  ]],

Cell[TextData[{
  "3.",
  "8.7 Extensions of ordinary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions"
}], "Subsubsection",
  CellTags->{"ExtensionsOfOrdinary", "i:44"}],

Cell[TextData[{
  "We have already seen the functions ",
  StyleBox["PolynomialQuotient", "MR"],
  ", ",
  StyleBox["PolynomialDivision", "MR"],
  ", ",
  StyleBox["PolynomialRemainder", "MR"],
  ", ",
  StyleBox["PolynomialGCD", "MR"],
  ", and ",
  StyleBox["PolynomialLCM", "MR"],
  " having natural extensions in an extension ringoid of polynomials. Here we \
consider some other extensions of built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions."
}], "Text",
  CellTags->"ExtensionsOfOrdinary"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Equal",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["PolynomialsOver",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["R",
                    "TI"], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["q",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ polynomials\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                FormBox["q",
                  "TraditionalForm"], 
                StyleBox[\(\ are\ equal, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Equal",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["q",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(assuming\ that\ the\ polynomials\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["q",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["both",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(over\ the\ same\ ring\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["give",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[\(if\ they\ are\ equal\),
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["False",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["otherwise",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["Equal",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["q",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                RowBox[{
                  StyleBox[
                    FormBox[
                      StyleBox["IgnoreIndeterminate",
                        "MR"],
                      "TraditionalForm"],
                    "TI"], " ", 
                  StyleBox["\[Rule]",
                    "MR"], " ", 
                  StyleBox["False",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(give\ \),
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["polynomials",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["p",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ and\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["q",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["have",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["same",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coefficients",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["same",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["indeterminate",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["and",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["False",
                      "MR"], 
                    StyleBox[\(\ otherwise\),
                      SingleLetterItalics->False]}]}]}]}]},
          {
            RowBox[{
              StyleBox["Exponent",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ degree\ of\ the\ polynomial\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Degree",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox["Exponent",
                  "MR"], "[", 
                StyleBox["p",
                  FontSlant->"Italic"], "]"}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Variables",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(return\ the\ variable\ used\ in\ the\ polynomial\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Coefficient",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["ind",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ a\ polynomial\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ in\ the\ indeterminate\ \),
                  SingleLetterItalics->False], 
                StyleBox["ind",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["coefficient",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["ind",
                    FontSlant->"Italic"], 
                  StyleBox["^",
                    "Text"], 
                  StyleBox["n",
                    "Text",
                    FontSlant->"Italic"]}]}]}]},
          {
            RowBox[{
              StyleBox["CoefficientList",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                
                StyleBox[
                  \(return\ the\ list\ of\ coefficients\ for\ the\ polynomial
                    \),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["order",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(PowersIncrease\  \[Rule] \ LeftToRight\),
                "MR"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"ExtensionsOfOrdinary", "i:45"}],

Cell[TextData[{
  "Extensions of ordinary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions."
}], "Caption",
  CellTags->"ExtensionsOfOrdinary"],

Cell[TextData[{
  "Here are three polynomials to consider, as well as an illustration that \
the ",
  StyleBox["AbstractAlgebra", "MR"],
  " packages do not currently support polynomials with more than one \
indeterminate."
}], "MathCaption",
  CellTags->"ExtensionsOfOrdinary"],

Cell[CellGroupData[{

Cell[BoxData[
    \({p = Poly[Z[3], x\^2 + 2\ x], q = Poly[Z[4], x\^2 + 2\ x], 
      r = Poly[Z[3], y\^2 + 2\ y], s = Poly[Z[5], x\^2\ y\^4 - x\ y + 1]}\)], 
  "Input",
  CellLabel->"In[100]:=",
  CellTags->"ExtensionsOfOrdinary"],

Cell[BoxData[
    \(Poly::"mixvars" \( : \ \) 
      "In your polynomial \!\(1 - \(x\\ y\) + \(x\^2\\ y\^4\)\), you should \
be using only a single variable (such as x), but the variables \!\({x, y}\) \
were used."\)], "Message",
  CellTags->"ExtensionsOfOrdinary"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(2\ x\), "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{\(2\ x\), "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{\(2\ y\), "+", 
          InterpretationBox[\(y\^2\),
            Subscripted[ 
              y[ 2], {}, {1}],
            Editable->False]}], ",", "$Failed"}], "}"}]], "Output",
  CellLabel->"Out[100]=",
  CellTags->"ExtensionsOfOrdinary"]
}, Open  ]],

Cell[TextData[{
  "Polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are not the same since they have different base rings. Polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " are the same if the indeterminate is ignored, but otherwise they are \
different.",
  " "
}], "MathCaption",
  CellTags->"ExtensionsOfOrdinary"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Equal[p, q], \ Equal[p, r], \ 
      Equal[p, r, IgnoreIndeterminate\  \[Rule] \ False]}\)], "Input",
  CellLabel->"In[101]:=",
  CellTags->"ExtensionsOfOrdinary"],

Cell[BoxData[
    \({False, True, False}\)], "Output",
  CellLabel->"Out[101]=",
  CellTags->"ExtensionsOfOrdinary"]
}, Open  ]],

Cell["The following illustrates some of the other functions.", "MathCaption",
  CellTags->"ExtensionsOfOrdinary"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Exponent[p], \ Coefficient[p, x, 2], Coefficient[p, y, 2], \ 
      Coefficient[p, 2], CoefficientList[p]}\)], "Input",
  CellLabel->"In[102]:=",
  CellTags->"ExtensionsOfOrdinary"],

Cell[BoxData[
    \(Coefficient::"ind" \( : \ \) 
      "Since \!\(\(2\\ x\) + x\^2\) uses the indeterminate \!\(x\), \!\(y\) \
shouldn't be specified as the indeterminate. Mention of the indeterminate is \
optional; it can be omitted."\)], "Message",
  CellTags->"ExtensionsOfOrdinary"],

Cell[BoxData[
    \({2, 1, $Failed, 1, {0, 2, 1}}\)], "Output",
  CellLabel->"Out[102]=",
  CellTags->"ExtensionsOfOrdinary"]
}, Open  ]],

Cell["3.8.8 Miscellaneous functions", "Subsubsection",
  CellTags->"MiscPoly"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ToOrdinaryPolynomial",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["polynomial",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["produced",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Poly",
                  "MR",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["function",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(return\ a\ polynomial\ in\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["Mathematica",
                    FontSlant->"Italic"], 
                  StyleBox["'",
                    SingleLetterItalics->False]}], 
                StyleBox["s",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ordinary",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["usage",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(where\ this\ makes\ sense\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["PolyQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ polynomial\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"], 
                StyleBox[\(\ was\ created\ in\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["AbstractAlgebra",
                  "MR"], 
                StyleBox[\(\ packages\ with\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Poly",
                  "MR"], 
                StyleBox[\(\ function, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Monomial",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["c",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ \),
                  SingleLetterItalics->False], 
                StyleBox["Poly",
                  "MR"], "[", 
                StyleBox["PolynomialsOver",
                  "MR"], "[", 
                StyleBox["R",
                  FontSlant->"Italic"], 
                StyleBox[\(\(], \)\ \),
                  SingleLetterItalics->False], 
                StyleBox["c",
                  FontSlant->"Italic"], " ", 
                FormBox[\(x\^n\),
                  "TraditionalForm"], "]"}],
              "Text"]},
          {
            RowBox[{
              StyleBox["BaseRing",
                "MR"], "[", 
              StyleBox["p",
                FontSlant->"Italic"], "]"}], 
            RowBox[{
            "return", " ", "the", " ", "underlying", " ", "ringoid", " ", 
              "of", " ", "the", " ", "polynomial", " ", 
              StyleBox["p",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"MiscPoly", "i:46"}],

Cell["Some miscellaneous functions.", "Caption",
  CellTags->"MiscPoly"],

Cell["Here we form two polynomials.", "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \({p\  = \ Poly[Z[7], \ 9  x\^4 - \ 12\ x\^2 + \ 3  x\  - \ 2], \n
      q\  = \ Poly[
          BooleanRing[{"\<a\>", "\<b\>", "\<c\>"}], {"\<a\>", "\<b\>"}, {}, {
            "\<a\>"}]}\)], "Input",
  CellLabel->"In[103]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"5\"\>", "+", \(3\ x\), "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}], "+", 
          RowBox[{"2", " ", 
            InterpretationBox[\(x\^4\),
              Subscripted[ 
                x[ 4], {}, {1}],
              Editable->False]}]}], ",", 
        InterpretationBox[
          RowBox[{
          "\<\"{a, b}\"\>", "\[InvisibleSpace]", "\<\" + \"\>", 
            "\[InvisibleSpace]", "\<\"{}\"\>", "\[InvisibleSpace]", 
            "\<\" \"\>", "\[InvisibleSpace]", "x", "\[InvisibleSpace]", 
            "\<\" + \"\>", "\[InvisibleSpace]", "\<\"{a}\"\>", 
            "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
            InterpretationBox[\(x\^2\),
              Subscripted[ 
                x[ 2], {}, {1}],
              Editable->False]}],
          SequenceForm[ "{a, b}", " + ", "{}", " ", x, " + ", "{a}", " ", 
            Subscripted[ 
              x[ 2], {}, {1}]],
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[103]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Poly", "MR"],
  " function was used to construct ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " but not ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " (which is defined in the following cell)."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[PolyQ, \ {p, \ q, \ r = x\^2 + 3  x\  - 5}]\)], "Input",
  CellLabel->"In[104]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    \({True, True, False}\)], "Output",
  CellLabel->"Out[104]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "Even if the dot product could be completed, the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " has no meaning in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " apart from the ",
  StyleBox["AbstractAlgebra", "MR"],
  " packages, while the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " does."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ToOrdinaryPolynomial, \ {p, \ q, \ r}]\)], "Input",
  CellLabel->"In[105]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    \(Dot::"dotsh" \( : \ \) 
      "Tensors \!\({\({\"a\", \"b\"}\), \({}\), \({\"a\"}\)}\) and \!\({1, x, \
x\^2}\) have incompatible shapes."\)], "Message",
  CellTags->"MiscPoly"],

Cell[BoxData[
    \({5 + 3\ x + 2\ x\^2 + 2\ x\^4, {{"a", "b"}, {}, {"a"}} . {1, x, x\^2}, 
      \(-5\) + 3\ x + x\^2}\)], "Output",
  CellLabel->"Out[105]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "The zero of ",
  StyleBox["LatticeRing", "MR"],
  "[10] is 1, which explains why the quadratic term is \
\[OpenCurlyDoubleQuote]lost\[CloseCurlyDoubleQuote] here."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToOrdinaryPolynomial[Poly[LatticeRing[10], 5, 10, 1]]\)], "Input",
  CellLabel->"In[106]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    \(5 + 10\ x\)], "Output",
  CellLabel->"Out[106]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "Every polynomial constructed using the ",
  StyleBox["Poly", "MR"],
  " function has an underlying base ring."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[BaseRing, \ {p, q}]\)], "Input",
  CellLabel->"In[107]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    \({Ringoid[{0, 1, 2, 3, 4, 5, 6}, Mod[#1 + #2, 7]&, Mod[#1\ #2, 7]&], 
      Ringoid[{{}, {"c"}, {"b"}, {"b", "c"}, {"a"}, {"a", "c"}, {"a", "b"}, {
            "a", "b", "c"}}, "-Addition-", "-Multiplication-"]}\)], "Output",
  CellLabel->"Out[107]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell["Here we build a polynomial from some monomials.", "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p\  = Sum[Monomial[Z[5], k, k], {k, 1, 3}]\)], "Input",
  CellLabel->"In[108]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    RowBox[{"x", "+", 
      RowBox[{"2", " ", 
        InterpretationBox[\(x\^2\),
          Subscripted[ 
            x[ 2], {}, {1}],
          Editable->False]}], "+", 
      RowBox[{"3", " ", 
        InterpretationBox[\(x\^3\),
          Subscripted[ 
            x[ 3], {}, {1}],
          Editable->False]}]}]], "Output",
  CellLabel->"Out[108]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "This polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is the same as constructing it as a single polynomial."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p\  == \ Poly[Z[5], x\  + \ 2  x\^2 + 3  x\^3]\)], "Input",
  CellLabel->"In[109]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[109]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PolynomialsOfDegreeN",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomials",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["degree",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["over",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["according",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["restrictions",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["PolynomialsUpToDegreeN",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomials",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["up",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], \((and\ including)\), " ", 
              StyleBox["degree",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["over",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["ringoid",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["using",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["options",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["opts",
                    FontSlant->"Italic"]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"MiscPoly", "i:47"}],

Cell["Generating complete lists of polynomials.", "Caption",
  CellTags->"MiscPoly"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["SizeLimit",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["125",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["maximum",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["size",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["created",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["Indeterminate",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["x",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["indeterminate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["used",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["polynomials",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.24, 0.15, 0.61},
  RowLines->{True, False}},
  CellTags->{"MiscPoly", "i:48"}],

Cell[TextData[{
  "Options for ",
  StyleBox["PolynomialsOfDegreeN",
    FontFamily->"Courier"],
  " and ",
  StyleBox["PolynomialsUpToDegreeN",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"MiscPoly"],

Cell[TextData[{
  "Here are all the cubic polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  "."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialsOfDegreeN[Z[2], 3]\)], "Input",
  CellLabel->"In[110]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(x\^3\),
          Subscripted[ 
            x[ 3], {}, {1}],
          Editable->False], ",", 
        RowBox[{
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}], ",", 
        RowBox[{"\<\"1\"\>", "+", "x", "+", 
          InterpretationBox[\(x\^2\),
            Subscripted[ 
              x[ 2], {}, {1}],
            Editable->False], "+", 
          InterpretationBox[\(x\^3\),
            Subscripted[ 
              x[ 3], {}, {1}],
            Editable->False]}]}], "}"}]], "Output",
  CellLabel->"Out[110]=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "Here are all polynomials of degree 2 or less over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  ", which is as big a set as usually possible without using the ",
  StyleBox["SizeLimit", "MR"],
  " option."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialsUpToDegreeN[Z[5], 2] // Short\)], "Input",
  CellLabel->"In[111]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    TagBox[
      \({x\^2, 2\ x\^2, 3\ x\^2, 4\ x\^2, x + x\^2, 
        \[LeftSkeleton]115\[RightSkeleton], 0, "1", "2", "3", "4"}\),
      Short]], "Output",
  CellLabel->"Out[111]//Short=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell[TextData[{
  "There are 1024 polynomials of degree 9 or less over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ". Here they are in the indeterminate \[Alpha]."
}], "MathCaption",
  CellTags->"MiscPoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[
      PolynomialsUpToDegreeN[ZR[2], 9, Indeterminate \[Rule] \[Alpha], \ 
        SizeLimit \[Rule] 1024], 2]\)], "Input",
  CellLabel->"In[112]:=",
  CellTags->"MiscPoly"],

Cell[BoxData[
    TagBox[
      \({\[Alpha]\^9, \[Alpha]\^8 + \[Alpha]\^9, \[Alpha]\^7 + \[Alpha]\^9, 
        \[Alpha]\^7 + \[Alpha]\^8 + \[Alpha]\^9, \[Alpha]\^6 + \[Alpha]\^9, 
        \[Alpha]\^6 + \[Alpha]\^8 + \[Alpha]\^9, 
        \[LeftSkeleton]1012\[RightSkeleton], "1" + \[Alpha]\^2, 
        "1" + \[Alpha] + \[Alpha]\^2, \[Alpha], "1" + \[Alpha], 0, "1"}\),
      (Short[ #, 2]&)]], "Output",
  CellLabel->"Out[112]//Short=",
  CellTags->"MiscPoly"]
}, Open  ]],

Cell["3.9 Matrices over a ringoid", "Subsection",
  CellTags->{"MatricesOver", "i:49"}],

Cell[TextData[{
  "For any ringoid ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ", the expression ",
  Cell[BoxData[
      RowBox[{
        StyleBox["MatricesOver",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["R",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox["n",
            "TI"]}], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " generates an extension ringoid that represents the ringoid of all ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrices over ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ". The domain of this system is finite but tends to be quite large, so the \
normal ",
  StyleBox["Ringoid", "MR"],
  " structure is not used. Alternatively, one can obtain ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrices over some ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " by using ",
  Cell[BoxData[
      RowBox[{
        StyleBox["MatricesOver",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["R",
            "TI"], 
          StyleBox[",",
            "MR"], 
          RowBox[{
            StyleBox["{",
              "MR"], 
            RowBox[{
              StyleBox["m",
                "TI"], 
              StyleBox[",",
                "MR"], 
              StyleBox["n",
                "TI"]}], 
            StyleBox["}",
              "TI"]}]}], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  "."
}], "Text",
  CellTags->{"MatricesOver", "i:50"}],

Cell["\<\
This represents a matrix extension with 625 matrices as elements.\
\
\>", "MathCaption",
  CellTags->"MatricesOver"],

Cell[CellGroupData[{

Cell[BoxData[
    \(M = MatricesOver[Z[5], 2]\)], "Input",
  CellLabel->"In[113]:=",
  CellTags->"MatricesOver"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"-\"\>", "\[InvisibleSpace]", 
        InterpretationBox[\("Mat"\_"2"\),
          Subscripted[ 
            "Mat"[ "2"]],
          Editable->False], "\[InvisibleSpace]", "\<\"(Z[5])-\"\>"}],
      SequenceForm[ "-", 
        Subscripted[ 
          "Mat"[ "2"]], "(Z[5])-"],
      Editable->False]], "Output",
  CellLabel->"Out[113]=",
  CellTags->"MatricesOver"]
}, Open  ]],

Cell[TextData[{
  "There are several shortcuts to creating matrix extensions. The ",
  StyleBox["Mat", "MR"],
  " function is equivalent to ",
  StyleBox["MatricesOver", "MR"],
  ". The functions ",
  StyleBox["MatA", "MR"],
  " and ",
  StyleBox["MatM", "MR"],
  " are useful if one wishes to later convert these extensions to a groupoid; \
in the former case, the operation is addition, while multiplication is used \
in the latter case."
}], "Text",
  CellTags->"MatricesOver"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Mat",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(identical\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["MatricesOver",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox["R",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Mat",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"m", 
                        StyleBox[",",
                          "MR"], " ", "n"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(identical\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["MatricesOver",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox["R",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["{",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["m",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["n",
                        FontSlant->"Italic"]}], 
                    StyleBox["}",
                      FontSlant->"Italic"]}]}], 
                StyleBox["]",
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["MatA",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(identical\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["MatricesOver",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox["R",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox[\(Operation\  \[Rule] \ Addition\),
                    "MR"]}], 
                StyleBox["]",
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["MatA",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"m", 
                        StyleBox[",",
                          "MR"], " ", "n"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(identical\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["MatricesOver",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox["R",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["{",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["m",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["n",
                        FontSlant->"Italic"]}], 
                    StyleBox["}",
                      FontSlant->"Italic"]}], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox[\(Operation\  \[Rule] \ Addition\),
                    "MR"]}], 
                StyleBox["]",
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["MatM",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(identical\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["MatricesOver",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox["R",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox[\(Operation\  \[Rule] \ Multiplication\),
                    "MR"]}], 
                StyleBox["]",
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.26, 0.74}},
  CellTags->{"MatricesOver", "i:51"}],

Cell["Alternate forms of creating matrix extensions.", "Caption",
  CellTags->"MatricesOver"],

Cell[TextData[{
  "Using ",
  StyleBox["Mat", "MR"],
  " to create an extension, we pick a random two-by-two matrix over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  "."
}], "MathCaption",
  CellTags->"MatricesOver"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[Mat[Z[5], \ 2]] // MatrixForm\)], "Input",
  CellLabel->"In[114]:=",
  CellTags->"MatricesOver"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"4", "1"},
            {"3", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[114]//MatrixForm=",
  CellTags->"MatricesOver"]
}, Open  ]],

Cell[TextData[{
  "Here we see that the operation is indeed multiplication when the ",
  StyleBox["MatM", "MR"],
  " function is used."
}], "MathCaption",
  CellTags->"MatricesOver"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToGroupoid[MatM[Z[4], 2]] // Operation\)], "Input",
  CellLabel->"In[115]:=",
  CellTags->"MatricesOver"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"Multiplication", "[", 
          InterpretationBox[
            RowBox[{"\<\"-\"\>", "\[InvisibleSpace]", 
              InterpretationBox[\("Mat"\_"2"\),
                Subscripted[ 
                  "Mat"[ "2"]],
                Editable->False], "\[InvisibleSpace]", "\<\"(Z[4])-\"\>"}],
            SequenceForm[ "-", 
              Subscripted[ 
                "Mat"[ "2"]], "(Z[4])-"],
            Editable->False], "]"}], "[", \(#1, #2\), "]"}], "&"}]], "Output",\

  CellLabel->"Out[115]=",
  CellTags->"MatricesOver"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["MatA", "MR"],
  " is used to create an extension, the inherent operation is addition."
}], "MathCaption",
  CellTags->"MatricesOver"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixOperation[MatA[Z[3], \ {2, 5}]]\)], "Input",
  CellLabel->"In[116]:=",
  CellTags->"MatricesOver"],

Cell[BoxData[
    \(Addition\)], "Output",
  CellLabel->"Out[116]=",
  CellTags->"MatricesOver"]
}, Open  ]],

Cell["3.9.1 Individual matrices", "Subsubsection",
  CellTags->{"IndividualMatrices", "i:52"}],

Cell[TextData[{
  "The structure of a matrix in a matrix extension is identical to the usual \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " matrix structure and matrices are entered in exactly the same manner. "
}], "Text",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ElementQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(A, \ M\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["A",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["matrix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["M",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["otherwise",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["RandomElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["M",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(return\ a\ random\ nonzero\ matrix\ in\ the\ matrix\ 
                    extension\ \),
                  SingleLetterItalics->False], 
                FormBox["M",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RandomElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(return\ a\ random\ matrix\ in\ the\ matrix\ extension\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["M",
                  "TraditionalForm"], 
                StyleBox[\(\ according\ to\ the\ options\ specified\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RandomElements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["k",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["random",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["matrices",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["matrix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["extension",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["M",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ according\ to\ the\ options\ specified\ in\ \),
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["RandomMatrix",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ a\ random\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ matrix\ over\ the\ ringoid\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ with\ no\ restrictions\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["RandomMatrix",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["MatrixType",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox["\[Rule]",
                        "MR"], " ", "type"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ a\ random\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ by\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["matrix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["over",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["specified",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["type",
                FontSlant->"Italic"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[\((choices\ below)\),
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"IndividualMatrices", "i:53"}],

Cell["Functions relating to individual matrices.", "Caption",
  CellTags->"IndividualMatrices"],

Cell["Matrices are entered in the usual way.", "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(M = MatricesOver[Z[5], 2]; \nA = {{4, 2}, {1, 4}}\)], "Input",
  CellLabel->"In[117]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    \({{4, 2}, {1, 4}}\)], "Output",
  CellLabel->"Out[117]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[TextData[{
  "Any matrix can be tested for membership in a matrix extension with ",
  StyleBox["ElementQ.", "MR"]
}], "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ElementQ[A, M]\)], "Input",
  CellLabel->"In[118]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[118]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[TextData[{
  "The following matrix contains a symbol, so ",
  StyleBox["ElementQ", "MR"],
  " returns ",
  StyleBox["False", "MR"],
  "."
}], "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ElementQ[{{\[Mu], 3}, {4, \[Mu]}}, M]\)], "Input",
  CellLabel->"In[119]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[119]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ElementQ", "MR"],
  " also returns ",
  StyleBox["False", "MR"],
  " if the order of a matrix doesn\[CloseCurlyQuote]t match that of the \
extension."
}], "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ElementQ[{{1, 0, 0}, {1, 1, 1}, {1, 2, 4}}, M]\)], "Input",
  CellLabel->"In[120]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[120]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RandomElement", "MR"],
  " acts on matrix extensions."
}], "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[M]\)], "Input",
  CellLabel->"In[121]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    \({{3, 2}, {4, 3}}\)], "Output",
  CellLabel->"Out[121]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["NonZero",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[\(specifies\ restrictions\ on\ the\ random\ matrix\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox[\(that\ is\ selected\),
                    SingleLetterItalics->False], 
                  StyleBox[";",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox[\(values\ are\),
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["Any",
                      "MR"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["NonZero",
                      "MR"]}]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["NonIdentity",
                    "MR"], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["NonUnity",
                    "MR"]}]}]}]},
          {
            StyleBox[
              FormBox["SelectBaseElementsFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Any",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[
                \(specifies\ restrictions\ on\ the\ individual\ entries\ that
                  \ appear\ in\ a\ random\ matrix; \ values\ are\ \),
                SingleLetterItalics->False], 
              StyleBox["Any",
                "MR"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["NonZero",
                "MR"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["NonUnity",
                "MR"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["NonIdentity",
                "MR",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.22, 0.16, 0.62},
  RowLines->{True, False}},
  CellTags->{"IndividualMatrices", "i:54"}],

Cell[TextData[{
  "Options on ",
  StyleBox["RandomElement",
    FontFamily->"Courier"],
  " for matrices."
}], "Caption",
  CellTags->"IndividualMatrices"],

Cell["A random nonzero matrix may have some zero entries.", "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[MatricesOver[Z[3], 5]] // MatrixForm\)], "Input",
  CellLabel->"In[122]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "1", "1", "1", "2"},
            {"1", "1", "0", "1", "0"},
            {"1", "0", "1", "2", "0"},
            {"0", "2", "1", "1", "0"},
            {"0", "0", "2", "1", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[122]//MatrixForm=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell["Here is how to get a matrix with all nonzero entries.", "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[MatricesOver[Z[3], 5], 
        SelectBaseElementsFrom \[Rule] NonZero] // MatrixForm\)], "Input",
  CellLabel->"In[123]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "2", "2", "2", "2"},
            {"1", "1", "2", "1", "2"},
            {"2", "2", "1", "2", "2"},
            {"1", "1", "2", "1", "1"},
            {"2", "2", "1", "2", "2"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[123]//MatrixForm=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[TextData[{
  "Whereas ",
  StyleBox["RandomElement", "MR"],
  " requires its first argument to be a matrix extension, ",
  StyleBox["RandomMatrix", "MR"],
  " uses the base ring for its first argument, and optionally one can specify \
the type of matrix being sought by giving a type with the ",
  StyleBox["MatrixType", "MR"],
  " option. Here are some possibilities."
}], "Text",
  CellTags->{"IndividualMatrices", "i:56"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox["All",
                "StandardForm"],
              "Text"], 
            StyleBox[\(any\ matrix\ \((default)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["GL",
                "StandardForm"],
              "Text"], 
            StyleBox[\(general\ linear\ \((an\ invertible\ matrix)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["SL",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(special\ linear\ 
                \((matrix\ with\ determinant\ equal\ to\ the\ unity\ of\ \nthe
                    \ base\ ring)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Diag",
                "StandardForm"],
              "Text"], 
            StyleBox[\(diagonal\ \((an\ invertible\ diagonal\ matrix)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["UT",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(strictly\ upper\ triangular\ 
                \((nonzero\ entries\ only\ above\ the\ diagonal)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["LT",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(strictly\ lower\ triangular\ 
                \((nonzero\ entries\ only\ below\ the\ diagonal)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["UTD",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(upper\ triangular\ 
                \((nonzero\ entries\ only\ above\ and\ on\ the\ diagonal)
                  \)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["LTD",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(lower\ triangular\ 
                \((nonzero\ entries\ only\ below\ and\ on\ the\ diagonal)
                  \)\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.17, 0.83}},
  CellTags->{"IndividualMatrices", "i:55"}],

Cell[TextData[{
  "Possible values of ",
  StyleBox["MatrixType",
    FontFamily->"Courier"],
  ", an option of ",
  StyleBox["RandomMatrix",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"IndividualMatrices"],

Cell[TextData[{
  "Here some three-by-three matrices over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " illustrating the various types."
}], "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[TraditionalForm, 
      examples = 
        Map[RandomMatrix[Z[5], 3, MatrixType \[Rule] #]&, {\ GL, \ SL, \ 
            Diag, \ UT, \ LT, \ UTD, \ \ LTD\ , All}]]\)], "Input",
  CellLabel->"In[124]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"1", "0", "1"},
                  {"0", "1", "4"},
                  {"4", "1", "2"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"4", "0", "2"},
                  {"1", "2", "4"},
                  {"4", "0", "4"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"3", "0", "0"},
                  {"0", "2", "0"},
                  {"0", "0", "1"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"0", "0", "3"},
                  {"0", "0", "1"},
                  {"0", "0", "0"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"0", "0", "0"},
                  {"3", "0", "0"},
                  {"2", "1", "0"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"1", "3", "0"},
                  {"0", "4", "4"},
                  {"0", "0", "1"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"1", "0", "0"},
                  {"2", "1", "0"},
                  {"4", "0", "3"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True], ",", 
        TagBox[
          FormBox[
            RowBox[{"(", GridBox[{
                  {"2", "1", "2"},
                  {"1", "4", "4"},
                  {"2", "3", "4"}
                  },
                ColumnAlignments->{Decimal}], ")"}],
            "TraditionalForm"],
          TraditionalForm,
          Editable->True]}], "}"}]], "Output",
  CellLabel->"Out[124]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell["\<\
Some of the determinants of these examples are predictable. (Which \
ones?)\
\>", "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Det[Z[5], #]&, examples]\)], "Input",
  CellLabel->"In[125]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    \({4, 1, 1, 0, 0, 4, 3, 2}\)], "Output",
  CellLabel->"Out[125]=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DiagQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(give\ \),
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[\(\ if\ the\ matrix\ \),
                    SingleLetterItalics->False], 
                  StyleBox["A",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["diagonal",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["matrix",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["ringoid",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["R",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["GLQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ matrix\ \),
                  SingleLetterItalics->False], 
                StyleBox["A",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["invertible",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["matrix",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["over",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["ringoid",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["R",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["SLQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ matrix\ \),
                  SingleLetterItalics->False], 
                StyleBox["A",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["invertible",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["matrix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False]}], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["R",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["with",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["determinant",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["unity",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["R",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.22, 0.78}},
  CellTags->{"IndividualMatrices", "i:57"}],

Cell["Testing for special types of matrices.", "Caption",
  CellTags->"IndividualMatrices"],

Cell["\<\
Here we test the foregoing matrices with these three \
functions.\
\>", "MathCaption",
  CellTags->"IndividualMatrices"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(mats
      \  = {Map[MatrixForm, examples], Map[DiagQ[Z[5], #]&, \ examples], 
          Map[GLQ[Z[5], #]&, \ examples], Map[SLQ[Z[5], #]&, \ examples]} // 
        Transpose; 
    \n{r1, r2} = 
      Map[Transpose, {mats[\([{1, 2, 3, 4}]\)], mats[\([{5, 6, 7, 8}]\)]}]; \n
    TableForm[r1, \ TableSpacing\  \[Rule] \ {0.5, 1}, \ 
      TableHeadings\  \[Rule] \ 
        \((heads = {{"\<matrix\>", "\<DiagQ\>", "\<GLQ\>", "\<SLQ\>"}, None})
          \)]\), 
    \(TableForm[r2, \ TableSpacing\  \[Rule] \ {0.5, 1}, \ 
      TableHeadings\  \[Rule] \ heads]\)}], "Input",
  CellLabel->"In[126]:=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"matrix\"\>", 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"1", "0", "1"},
                    {"0", "1", "4"},
                    {"4", "1", "2"}
                    }], ")"}],
              (MatrixForm[ #]&)], 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"4", "0", "2"},
                    {"1", "2", "4"},
                    {"4", "0", "4"}
                    }], ")"}],
              (MatrixForm[ #]&)], 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"3", "0", "0"},
                    {"0", "2", "0"},
                    {"0", "0", "1"}
                    }], ")"}],
              (MatrixForm[ #]&)], 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"0", "0", "3"},
                    {"0", "0", "1"},
                    {"0", "0", "0"}
                    }], ")"}],
              (MatrixForm[ #]&)]},
          {"\<\"DiagQ\"\>", "False", "False", "True", "False"},
          {"\<\"GLQ\"\>", "True", "True", "True", "False"},
          {"\<\"SLQ\"\>", "False", "True", "True", "False"}
          },
        RowSpacings->0.5,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0.5, 1}, TableHeadings -> {{"matrix", 
        "DiagQ", "GLQ", "SLQ"}, None}]&)]], "Output",
  CellLabel->"Out[126]//TableForm=",
  CellTags->"IndividualMatrices"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"matrix\"\>", 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"0", "0", "0"},
                    {"3", "0", "0"},
                    {"2", "1", "0"}
                    }], ")"}],
              (MatrixForm[ #]&)], 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"1", "3", "0"},
                    {"0", "4", "4"},
                    {"0", "0", "1"}
                    }], ")"}],
              (MatrixForm[ #]&)], 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"1", "0", "0"},
                    {"2", "1", "0"},
                    {"4", "0", "3"}
                    }], ")"}],
              (MatrixForm[ #]&)], 
            TagBox[
              RowBox[{"(", GridBox[{
                    {"2", "1", "2"},
                    {"1", "4", "4"},
                    {"2", "3", "4"}
                    }], ")"}],
              (MatrixForm[ #]&)]},
          {"\<\"DiagQ\"\>", "False", "False", "False", "False"},
          {"\<\"GLQ\"\>", "False", "True", "True", "True"},
          {"\<\"SLQ\"\>", "False", "False", "False", "False"}
          },
        RowSpacings->0.5,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0.5, 1}, TableHeadings -> {{"matrix", 
        "DiagQ", "GLQ", "SLQ"}, None}]&)]], "Output",
  CellLabel->"Out[127]//TableForm=",
  CellTags->"IndividualMatrices"]
}, Open  ]],

Cell["3.9.2 Matrix arithmetic", "Subsubsection",
  CellTags->{"MatrixArithmetic", "i:58"}],

Cell[TextData[{
  "For any matrix extension ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ", we can add and multiply matrices belonging to ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ", with products making sense only if we are in a square matrix extension. \
By specifying the base ring (and not a matrix extension), appropriately \
dimensioned nonsquare matrices can also be multiplied. The underlying ring \
operations determine the result of the matrix operations."
}], "Text",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox[
                RowBox[{"Addition", 
                  StyleBox["[",
                    "MR"], "M", 
                  StyleBox["]",
                    "MR"]}],
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["A",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["B",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ sum\ of\ matrices\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["A",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["B",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["matrix",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["extension",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["M",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Addition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["B",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox[
                        RowBox[{
                          StyleBox["Addition",
                            SingleLetterItalics->False], 
                          StyleBox["[",
                            "MR"], 
                          StyleBox["M",
                            "TI"], 
                          StyleBox["]",
                            "MR"]}],
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["A",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["B",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Addition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["B",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{"i", 
                      StyleBox["f",
                        SingleLetterItalics->False]}]], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["ringoid",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["or",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["groupoid",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(identical\ to\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox[
                      RowBox[{
                        StyleBox["Addition",
                          SingleLetterItalics->False], "[", 
                        StyleBox["MatricesOver",
                          SingleLetterItalics->False], "[", 
                        StyleBox["R",
                          "TI"], \(]]\)}],
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["A",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["B",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              RowBox[{
                StyleBox["Multiplication",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["M",
                  FontSlant->"Italic"], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["A",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["B",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ product\ of\ matrices\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["A",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["B",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["matrix",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["extension",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["M",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["and",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["if",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["dimensions",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["match",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["appropriately",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], "\n", 
                    StyleBox["when",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["M",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["is",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["ring",
                      SingleLetterItalics->False]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["MatrixPower",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["A",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["k",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["th",
                      SingleLetterItalics->False]}]], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["power",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["square",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["matrix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["A",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["matrix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["extension",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((or\ ring)\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["M",
                    "TraditionalForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"MatrixArithmetic", "i:59"}],

Cell["Basic arithmetic functions over matrix extensions.", "Caption",
  CellTags->"MatrixArithmetic"],

Cell[TextData[{
  "Note that there are variations of the ",
  StyleBox["Multiplication", "MR"],
  " function comparable to those for ",
  StyleBox["Addition", "MR"],
  "."
}], "Text",
  CellTags->"MatrixArithmetic"],

Cell[TextData[{
  "Here we form a matrix extension over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  " to illustrate some of these functions."
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(M3 = MatricesOver[Z[7], 3]\)], "Input",
  CellLabel->"In[128]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"-\"\>", "\[InvisibleSpace]", 
        InterpretationBox[\("Mat"\_"3"\),
          Subscripted[ 
            "Mat"[ "3"]],
          Editable->False], "\[InvisibleSpace]", "\<\"(Z[7])-\"\>"}],
      SequenceForm[ "-", 
        Subscripted[ 
          "Mat"[ "3"]], "(Z[7])-"],
      Editable->False]], "Output",
  CellLabel->"Out[128]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["Here is how a cyclic matrix can be created.", "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((A = Map[RotateRight[{1, 2, 6}, #]&, {0, 1, 2}])\) // MatrixForm\)], 
  "Input",
  CellLabel->"In[129]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "2", "6"},
            {"6", "1", "2"},
            {"2", "6", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[129]//MatrixForm=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["Here is a second matrix.", "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((B = {{0, 0, 1}, {0, 1, 2}, {1, 0, 0}})\) // MatrixForm\)], "Input",
  CellLabel->"In[130]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "1"},
            {"0", "1", "2"},
            {"1", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[130]//MatrixForm=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell[TextData[{
  "Here are the three methods by which we can find the sum of matrices ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  "."
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      MatrixForm, {\(Addition[M3]\)[A, B], \ Addition[M3, A, B], 
        Addition[Z[7], A, B]}]\)], "Input",
  CellLabel->"In[131]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "2", "0"},
                {"6", "2", "4"},
                {"3", "6", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "2", "0"},
                {"6", "2", "4"},
                {"3", "6", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "2", "0"},
                {"6", "2", "4"},
                {"3", "6", "1"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[131]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["Here is their product.", "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      MatrixForm, {\(Multiplication[M3]\)[A, B], \ Multiplication[M3, A, B], 
        Multiplication[Z[7], A, B]}]\)], "Input",
  CellLabel->"In[132]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"6", "2", "5"},
                {"2", "1", "1"},
                {"1", "6", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"6", "2", "5"},
                {"2", "1", "1"},
                {"1", "6", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"6", "2", "5"},
                {"2", "1", "1"},
                {"1", "6", "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[132]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell[TextData[{
  "While ",
  StyleBox["M3", "MR"],
  " consisted of only three-by-three matrices, here we obtain a random \
three-by-two matrix over the same base ring, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  ", as well as a two-by-three matrix (also over the same base ring)."
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \({\((F\  = \ RandomElement[MatricesOver[Z[7], {3, 2}]])\) // MatrixForm, 
      \ \((G\  = \ RandomElement[MatricesOver[Z[7], {2, 3}]])\) // MatrixForm}
      \)], "Input",
  CellLabel->"In[133]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "2"},
                {"0", "4"},
                {"2", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"2", "4", "3"},
                {"5", "1", "5"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[133]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell[TextData[{
  "There is a variety of products that can now be computed with the matrices \
",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      MatrixForm, {Multiplication[Z[7], \ A, \ F], \ 
        Multiplication[Z[7], \ G, \ A], \ Multiplication[Z[7], \ G, F], 
        Multiplication[Z[7], \ F, \ G]}]\)], "Input",
  CellLabel->"In[134]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"2", "3"},
                {"0", "2"},
                {"3", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "5", "2"},
                {"0", "6", "2"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "6"},
                {"2", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "4", "1"},
                {"6", "4", "6"},
                {"4", "1", "6"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[134]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["There are also some products that do not make sense.", "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Multiplication[Z[7], F, \ A]\)], "Input",
  CellLabel->"In[135]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    \(Multiplication::"fail" \( : \ \) 
      "A \!\(3\) by \!\(2\) matrix can not be multiplied by a \!\(3\) by \
\!\(3\) matrix."\)], "Message",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[135]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell[TextData[{
  "Here are the powers -1 through 3 of the matrix ",
  Cell[BoxData[
      RowBox[{"(", GridBox[{
            {"2", "3"},
            {"4", "5"}
            }], ")"}]]],
  "over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  "."
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[MatrixForm, 
      Table[MatrixPower[Z[7], {{2, 3}, {4, 5}}, k], {k, \(-1\), 3}]]\)], 
  "Input",
  CellLabel->"In[136]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "5"},
                {"2", "6"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0"},
                {"0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"2", "3"},
                {"4", "5"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"2", "0"},
                {"0", "2"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"4", "6"},
                {"1", "3"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[136]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["\<\
As with polynomials, much of the basic ringoid functionality \
carries over into a matrix extension.\
\>", "Text",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["HasZeroQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["M",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox["M",
                  "TraditionalForm"], 
                StyleBox[\(\ has\ a\ zero, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Zero",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["M",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["return",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["zero",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["M",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(if\ it\ exists\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR"]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox["otherwise",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["NegationOf",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ negation\ of\ matrix\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["A",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["its",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["entries",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["have",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[\(a\ negation\ in\ the\ base\ ring\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["WithUnityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["M",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox["M",
                  "TraditionalForm"], 
                StyleBox[\(\ has\ a\ unity, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\ \),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Unity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["M",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ unity\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["M",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((actually\ the\ identity\ matrix)\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(if\ it\ exists\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["UnitQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox["A",
                  "TraditionalForm"], 
                
                StyleBox[\(\ 
                  is\ a\ unit\ \((has\ a\ multiplicative\ inverse\ in\ \)\),
                  SingleLetterItalics->False], 
                FormBox["M",
                  "TraditionalForm"], 
                StyleBox[\(\(), \ and\)\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZeroDivisorQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["A",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ a\ zero\ divisor\ in\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["M",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"MatrixArithmetic", "i:60"}],

Cell["Using ringoid functions in a matrix extension.", "Caption",
  CellTags->"MatrixArithmetic"],

Cell[TextData[{
  "The negation of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " is easily determined."
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[MatrixForm, {A, NegationOf[M3, A]}]\)], "Input",
  CellLabel->"In[137]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "2", "6"},
                {"6", "1", "2"},
                {"2", "6", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"6", "5", "1"},
                {"1", "6", "5"},
                {"5", "1", "6"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[137]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["The zero and one are well known.", "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[MatrixForm, {Zero[M3], Unity[M3]}]\)], "Input",
  CellLabel->"In[138]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0", "0"},
                {"0", "0", "0"},
                {"0", "0", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0"},
                {"0", "1", "0"},
                {"0", "0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[138]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell[TextData[{
  "We can reuse ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " in a matrix extension over a different ",
  StyleBox["Ringoid", "MR"],
  " in which the multiplication is always zero. (Observe that matrices do not \
carry with them the underlying ring, as do the polynomials discussed \
earlier.)"
}], "MathCaption",
  CellTags->"MatrixArithmetic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      MatrixForm, {A, B, 
        \(Multiplication[MatricesOver[TrivialZR[7], 3]]\)[A, B]}]\)], "Input",\

  CellLabel->"In[139]:=",
  CellTags->"MatrixArithmetic"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "2", "6"},
                {"6", "1", "2"},
                {"2", "6", "1"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0", "1"},
                {"0", "1", "2"},
                {"1", "0", "0"}
                }], ")"}],
          (MatrixForm[ #]&)], ",", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0", "0"},
                {"0", "0", "0"},
                {"0", "0", "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}], "}"}]], "Output",
  CellLabel->"Out[139]=",
  CellTags->"MatrixArithmetic"]
}, Open  ]],

Cell["3.9.3 Determinants and inverses", "Subsubsection",
  CellTags->{"Determinants", "i:61"}],

Cell[TextData[{
  "The function ",
  StyleBox["Det", "MR"],
  " is extended in ",
  StyleBox["AbstractAlgebra", "MR"],
  " to compute the determinant of a square matrix over an arbitrary ringoid."
}], "Text",
  CellTags->"Determinants"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Det",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                
                StyleBox[\(return\ the\ determinant\ of\ the\ square\ matrix\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["A",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ring",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["extension",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["M",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Det",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(for\ a\ ringoid\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Det",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{
                      RowBox[{
                        StyleBox["MatricesOver",
                          "MR"], 
                        StyleBox["[",
                          "MR"], 
                        RowBox[{
                          StyleBox["R",
                            "TI"], 
                          StyleBox[",",
                            "MR"], " ", 
                          RowBox[{
                            StyleBox["Length",
                              "MR"], 
                            StyleBox["[",
                              "MR"], 
                            StyleBox["A",
                              "TI"], 
                            StyleBox["]",
                              "MR"]}]}], 
                        StyleBox["]",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["A",
                        "TI"]}], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["MultiplicativeInverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["M",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ multiplicative\ inverse\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["A",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["matrix",
                  SingleLetterItalics->False]}], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["extension",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[\((or\ ring)\),
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["M",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(if\ it\ exists\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR"]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox["otherwise",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Inverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["A",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["MultiplicativeInverse",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["R",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["A",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Determinants", "i:62"}],

Cell[TextData[{
  "Extensions of ",
  StyleBox["Det",
    FontFamily->"Courier"],
  " and",
  " ",
  StyleBox["MultiplicativeInverse",
    FontFamily->"Courier"],
  " for matrix extensions."
}], "Caption",
  CellTags->"Determinants"],

Cell["\<\
Recall that for a two-by-two matrix, the determinant is the \
difference between two products: the product of the two diagonal elements and \
the product of the two off-diagonal elements.\
\>", "MathCaption",
  CellTags->{"Determinants", "i:63"}],

Cell[CellGroupData[{

Cell[TextData[
"Needs[\"Graphics`Arrow`\",\"Arrow.m\"];\n{Line[{{-2,2},{-2,-2}}], \
Line[{{2,2},{2,-2}}], Text[\"a\",{-1,1}], Text[\"c\", {-1,-1}], \
Text[\"b\",{1,1}], Text[\"d\",{1,-1}], Arrow[{-1.5,1.5},{1.5,-1.5}], \
Arrow[{-1.5,-1.5},{1.5,1.5}], Text[\"a d - b c\",{4.2,0}], \
Text[\"=\",{2.45,0}], RGBColor[1,0,0], Arrow[{1.5,-1.5},{3,-0.2}], \
Arrow[{1.5,1.5},{4.2,0.2}]}//Graphics[#,DefaultFont\[Rule]{\"Times\",24}]&//\n\
 Show[#,PlotRange\[Rule]{{-2.3,5.5},{-2.3,2.3}}]&;"], "Input",
  CellLabel->"In[140]:=",
  CellTags->"Determinants"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .58974 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 24  scalefont  setfont
% Scaling calculations
0.294872 0.128205 0.294872 0.128205 [
[ 0 0 0 0 ]
[ 1 .58974 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .58974 L
0 .58974 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.03846 .55128 m
.03846 .03846 L
s
.55128 .55128 m
.55128 .03846 L
s
[(a)] .16667 .42308 0 0 Mshowa
[(c)] .16667 .16667 0 0 Mshowa
[(b)] .42308 .42308 0 0 Mshowa
[(d)] .42308 .16667 0 0 Mshowa
.10256 .48718 m
.48718 .10256 L
s
% Start of user PostScript
-1.5 1.5 1.5 -1.5 MAarrowhead1
% End of user PostScript
.10256 .10256 m
.48718 .48718 L
s
% Start of user PostScript
-1.5 -1.5 1.5 1.5 MAarrowhead1
% End of user PostScript
[(a d - b c)] .83333 .29487 0 0 Mshowa
[(=)] .60897 .29487 0 0 Mshowa
1 0 0 r
.48718 .10256 m
.67949 .26923 L
s
% Start of user PostScript
1.5 -1.5 3. -0.2 MAarrowhead1
% End of user PostScript
.48718 .48718 m
.83333 .32051 L
s
% Start of user PostScript
1.5 1.5 4.2 0.2 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[140]:=",
  ImageSize->{288, 169.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000Z@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0000/000?o0000T0000ol0001o0000
2`000ol0002@0003o`0007l0000;0003o`00090000?o0000O`0000/000?o0000T0000ol0001o0000
2`000ol0002@0003o`0007l0000;0003o`00090000?o0000O`0000/000?o0000T0000ol0001o0000
2`000ol0002@0003o`0007l0000;0003o`00090000?o0000O`0000/000?o0000T0000ol0001o0000
2`000ol0002@0003o`0007l0000;0003o`00090000?o0000O`0000/000?o0000T0000ol0001o0000
2`000ol0002@0003o`0007l0000;0003o`00090000?o0000O`0000/000?o0000T0000ol0001o0000
2`000ol0002@0003o`0007l0000;0003o`00090000?o0000O`0000/000?o00003`000ol0001Z0003
oalO014000?o0000O`0000/000?o000040000ol0001X00?o00<07`003`000ol0001o00002`000ol0
000A0003o`0006D01?l300037`0000d000?o0000O`0000/000?o00004P000ol0001S00Go10000al0
000<0003o`0007l0000;0003o`0001<000?o0000H006o`H000<O00002`000ol0001o00002`000ol0
000D0003o`0005h01ol700037`0000X000?o0000O`0000/000?o00005@000ol0001K00So2@000al0
00090003o`0007l0000;0003o`0001H000?o0000F@08o`/00Ql90003o`0007l0000;0003o`0001L0
00?o0000E`09o`d000<O00001P000ol0001o00002`000ol0000H0003o`0005L01ol?00037`0000D0
00?o0000O`0000/000?o00006@000ol0001G00Ko40000al000040003o`0007l0000;0003o`0001X0
00?o0000E@000ol0o`03oa8000<O00000`000ol0001o00002`000ol0000K0003o`0005<000Co0000
0olC00037`00008000?o0000O`0000/000?o000070001?l00003odD01?l01@3o003o00D000?o0000
4`001Al0003o0840000;0003o`0001d02?m200?o0P04oad00Ql00`3o002000002`000ol0000N00?o
0`000ol0001000;o1002ob0000<Oo`00P00000/000?o00007@03o`D000?o0000?P02o`D00_lQ0003
7`0007l0000;0003o`0001d00_l00`3o001400;o1003ob4000?o7`00O`0000/000?o00007@02o`80
00?o0000@P02o`<000Co0?oo8@000ol07`1o00002`000ol0000M00;o0`000ol0001100;o0P000ol0
0002ob4000Co000OOP0000/000?o00007@02o`@00om000;o00<0o`000P02ob4000Go00007`1m0000
2`000ol0000N00;o1002od400_l400;o8@000ol00002008ON`0000/000?o00007`02o`800om100;o
0`03ob4000?o000010000al0001h00002`000ol0000P00Co0P000ol0000m0003o`3o00?o00<0ool0
8@000ol0000500037`0007L0000;0003o`0002L000?o0000>`000ol0000500;o8@000ol000060003
7`0007H0000;0003o`0002P000?o0000>@000ol0000600;o8@000ol0000700037`0007D0000;0003
o`0002T000?o0000=`000ol0000700;o8@000ol0000800037`0007@0000;0003o`0002X000?o0000
=@000ol0000800;o8@000ol00009008OM00000/000?o0000:`000ol0000c0003o`0000P00olQ0003
o`0000/000<O0000L@0000/000?o0000;0000ol0000a0003o`0000/000?o00007`000ol0000<0003
7`000700000;0003o`0002d000?o0000;`000ol0000^0003o`0000d000<O0000K`0000/000?o0000
;P000ol0000]0003o`0002l000?o00003P000al0001^00002`000ol0000_0003o`0002/000?o0000
<0000ol0000?00037`0006d0000;0003o`00030000?o0000:@000ol0000a0003o`00010000<O0000
K00000/000?o0000<@000ol0000W0003o`00038000?o00004@027f`0000;0003o`00038000?o0000
9@000ol0000c0003o`0001<000<O0000J@0000/000?o0000<`000ol0000S0003o`0003@000?o0000
50000al0000200037`0006<0000;0003o`0003@000?o00008@000ol0000e0003o`0001D000<O0000
0QmU00002`000ol0000e0003o`0001l000?o0000=P000ol0000F00DOI00000/000?o0000=P000ol0
000M0003o`0003L000?o00005P067f<0000;0003o`0003L000?o00006`000ol0000h0003o`0001D0
1amS00002`000ol0000h0003o`0001T000?o0000>@000ol0000D00TOHP0000/000?o0000>@000ol0
000G0003o`0003X000?o00005P087f40000;0003o`0003X000?o00005@000ol0000k0003o`0001P0
1QmQ00002`000ol0000k0003o`0001<000?o0000?0000ol0000J00DOH00000/000?o0000?0000ol0
000A0003o`0003d000?o000070047el0000;0003o`0003d000?o00003`000ol0000n0003o`0001d0
0amO00002`000ol0000n0003o`0000d000?o0000?`000ol0000O008OGP0000/000?o0000?`000ol0
000;0003o`00040000?o00008@000al0001K00002`000ol000100003o`0000T000?o0000@@000ol0
001o00002`000ol000110003o`0000L000?o0000@P000ol0000Y00Co00@0oooo2P04o`030?l001T0
1Ol>00?o3P0000/000?o0000@P000ol000050003o`0004<000?o0000:003o`800ol:00?o0P04oaL0
0_l40003o`0000T01ol<00002`000ol000130003o`0000<000?o0000A0000ol0000X00;o1002o`X0
0_l400;o6002o`@00_l:00?o0`000ol0000:00002`000ol000140005o`000?l0A`000ol0000600co
5P02o`@00_l900;o1@02oaP00_l500;o2003o`D000?o00002@0000/000?o0000A@000ol0o`180003
o`0002T00_l300;o2@02o`D00_lH00;o1@02o`P00_lB00002`000ol000160003o`0004L000?o0000
:P03o`030?oo00T00_l500;o2@06o`T00_l500;o2002oa80000;0003o`0004D000?o0?l0B0000ol0
000]00?o2@02o`D00_lH00;o1@02o`P00_lB00002`000ol000140005o`000?l0A`000ol0000^00;o
2@02o`D00_lH00;o1@02o`P00_l500;o2`0000/000?o0000@`000ol000030003o`0004