(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1532322,      27789]*)
(*NotebookOutlinePosition[   1562859,      28603]*)
(*  CellTagsIndexPosition[   1561842,      28564]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Chapter 4",
    FontSize->18],
  "\n",
  StyleBox["Morphoids", "MR"]
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  CellTags->{"What", "i:1"}],

Cell[TextData[{
  "Given two groups (or rings), one may want to establish some function \
between them. Usually, the interest is not just how the function interacts \
with the elements of the two structures, but also how it relates to the \
operations. Given groups ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((\(G\_1, \)\ \)*) \)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\((G\_2, \ #)\)\)]],
  ", we are often interested in a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\  : \ G\_1\), " ", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], " ", \(G\_2\)}], TraditionalForm]]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\ *\ y)\  = \ \(f(x)\)\ #\ \(f(y)\)\)]],
  " for all ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  ". In this case, we say ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is a ",
  StyleBox["homomorphism",
    FontSlant->"Italic"],
  " between the two groups. Clearly not all functions between groups are \
homomorphisms. In ",
  StyleBox["AbstractAlgebra", "MR"],
  ", we define a data structure called a ",
  StyleBox["Morphoid", "MR"],
  " that reflects a mathematical function between two groupoids or ringoids. \
In this chapter, we consider how to form and explore ",
  StyleBox["Morphoids", "MR"],
  "."
}], "Text",
  CellTags->"What"],

Cell["4.0 Read me first", "Subsection",
  CellTags->"First"],

Cell["\<\
To evaluate any of the Input cells in this chapter, the following \
cell should be evaluated first.\
\>", "Text",
  CellTags->"First"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Master`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"First"],

Cell[TextData[{
  "Since we wish to primarily focus on groups, we use the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function."
}], "Text",
  CellTags->"First"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Group]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"First"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"First"]
}, Open  ]],

Cell[TextData[{
  "4.1 Forming ",
  StyleBox["Morphoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->{"Form", "i:2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FormMorphoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ \),
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[\(\ determined\ by\ the\ function\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["between",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["structures",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(S\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(S\_2\),
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["FormMorphoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["rules",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ \),
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["determined",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rules",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["given",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rules",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["gives",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["mapping",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["between",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["structures",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(S\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(and\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(S\_2\),
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["FormMorphoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["positionList",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["determined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["indices",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["found",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["positionList",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["gives",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["mapping",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["between",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["structures",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(S\_1\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(and\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(S\_2\),
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["FormMorphoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{\(S\_2\), ",", " ", 
                      RowBox[{
                        StyleBox["FormatFunction",
                          "MR"], 
                        StyleBox[" ",
                          "MR"], 
                        StyleBox["\[Rule]",
                          "MR"], " ", "val"}]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{"after", " ", "forming", " ", "the", " ", 
                  StyleBox["Morphoid",
                    "MR"]}], ",", " ", \(format\ it\ according\)}], " ", 
              RowBox[{
                RowBox[{"to", " ", 
                  StyleBox["val",
                    FontSlant->"Italic"]}], ",", " ", 
                RowBox[{"with", " ", 
                  StyleBox["False",
                    "MR"], " ", "being", " ", "the", " ", "default", " ", 
                  "value"}]}]}]},
          {
            RowBox[{
              StyleBox["FormMorphoidSetup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[\(S\_1\),
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[\(S\_2\),
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["provide",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["graphic",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["assist",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["position\[Hyphen]list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["approach",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["forming",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"Form", "i:3"}],

Cell[TextData[{
  "Methods of forming a ",
  StyleBox["Morphoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Form"],

Cell[TextData[{
  "The function between two groupoids (or ringoids) used to determine a ",
  StyleBox["Morphoid", "MR"],
  " can be a built-in function or a pure function."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \({f1\  = \ FormMorphoid[Identity, \ Z[5], \ Z[5]], \ 
      f2\  = \ FormMorphoid[Mod[#\  + \ 2, \ 5]\ &, \ Z[5], \ Z[5]]}\)], 
  "Input",
  CellLabel->"In[3]:=",
  CellTags->"Form"],

Cell[BoxData[
    \({Morphoid[Identity[#1]&, "-Z[5]-", "-Z[5]-"], 
      Morphoid[Mod[#1 + 2, 5]&, "-Z[5]-", "-Z[5]-"]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "One can also define a function on each element of the domain and then \
construct a ",
  StyleBox["Morphoid", "MR"],
  ". Here we also illustrate the ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["FormMorphoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[g]; \nDo[g[i]\  = \ Mod[i + 2, \ 5], \ {i, \ 0, \ 4}]\), 
    \(f3\  = \ 
      FormMorphoid[g, \ Z[5], \ Z[5], \ Mode\  \[Rule] \ Visual]\)}], "Input",\

  CellLabel->"In[4]:=",
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.42857 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.238095 0.238095 0.238095 [
[ 0 0 0 0 ]
[ 1 1.42857 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.42857 L
0 1.42857 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[5])] .5 1.30952 0 0 Mshowa
[(0)] .02381 1.19048 0 0 Mshowa
[(1)] .2619 1.19048 0 0 Mshowa
[(2)] .5 1.19048 0 0 Mshowa
[(3)] .7381 1.19048 0 0 Mshowa
[(4)] .97619 1.19048 0 0 Mshowa
[(Z[5])] .5 .11905 0 0 Mshowa
[(0)] .02381 .2381 0 0 Mshowa
[(1)] .2619 .2381 0 0 Mshowa
[(2)] .5 .2381 0 0 Mshowa
[(3)] .7381 .2381 0 0 Mshowa
[(4)] .97619 .2381 0 0 Mshowa
0 0 1 r
.5 Mabswid
[ ] 0 setdash
.02381 1.11905 m
.5 .30952 L
s
% Start of user PostScript
0 3.7 2. 0.3 MAarrowhead1
% End of user PostScript
.2619 1.11905 m
.7381 .30952 L
s
% Start of user PostScript
1. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
.5 1.11905 m
.97619 .30952 L
s
% Start of user PostScript
2. 3.7 4. 0.3 MAarrowhead1
% End of user PostScript
.7381 1.11905 m
.02381 .30952 L
s
% Start of user PostScript
3. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.97619 1.11905 m
.2619 .30952 L
s
% Start of user PostScript
4. 3.7 1. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{201.562, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400039000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000<T00000b>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP00
0<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1UP00063V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82o`0:
iP;V0^H2iP;V0P;o05[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000FNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00Co00P2iP;o0^H2iP?o
063V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_Kom_ofU_KomYKfU_JFm_ofU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0_l2iP;V0^H2o`;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001UU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFmYKfooJFmYH00ol0H9KfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKoiP;V0_l2iP;VonH2iP;V0^KoiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001IU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
1?l00oJFmP02o`03U_JF00Co00?fU_H00_l0FYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0000>FmYH00_l0;OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmP03o`0]mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf00Co02bFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP?o
02gfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00ol00oJFmP01UP00
0<SV0_l2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^KoiP;V0P7V0000`IKfooJFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH01?l00oJFmP01UP0009?V0_l2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l0<`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;VonKoiP;V0P01iP000<RFm_ofU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFm_ofU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKoU_JFmP6F00000nH2iP02o`0]
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200;o02oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02o`0]0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200?o02d2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP800_l01>H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00004iP;V0P9<02kV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20T`0GNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C00c0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2007V000019KfU_H3C00]
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00=<02cfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<02gfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00d`0;OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP02C004U_JFmP6F00001NH2iP;V00A<02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPA<02T2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0P03C00/0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H4C00/
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H3C004iP;V0P7V00001IKf
U_JF00E<02^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00E<02NFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00d`0;9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf14`0;9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0d`01OJFmYKf006F00001^H2iP;V0PI<02[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP86C00TiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
14`0:nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H01D`0:nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H014`01@;V0^H2007V00001iKfU_JFmYH0
1T`0:_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUPI<02;fU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF1D`0:YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmPI<02ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H5C005
mYKfU_H00IH00007iP;V0^H2iP07C00YiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H01d`08>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H21D`0:P;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPI<02X2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H5C006iP;V0^H20NH00008U_JFmYKfU_H4C00/U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H4C00QU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF00I<02WfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP07C00YmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H01T`01YKfU_JFmP6F00002>H2iP;V0^H2
14`0;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H214`08nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00A<02/2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H200E<02/2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H200A<00KV0^H2iP81iP0005nFmYKfU_JFmYI<U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP03C00]
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00=<02bFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP=<00OfU_JFmYKf006F0000b>H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0T`2iP;V0^H20NH00038U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP81iP00
0<RFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H20NH00038U_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmP6F
0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH0001@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C01fiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C09<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C09<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0003fFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<02kfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0T`0FOJFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf006F0000?NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H00T`0;P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2C01I0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800NH00038U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFC9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001JU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0T`0;IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP02C00mmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP01UP0005[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C01/iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000b>H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0<SV0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H20NH00038U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0P7V
0000b9KfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf0IH00038iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP81iP000<RFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmP6F0000b>H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H20NH00038U_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_H1UP000<SV0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0P7V0000b9KfU_JFC9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
0IH00038iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0000>FmYH00_l0;OJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP03o`0]mYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00Co02bFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP?o02gfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_H00ol00oJFmP01UP000<SV0_l2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0P7V0000`IKfooJFoiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
1?l00oJFmP01UP0009?V0_l2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l0<`;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKoiP;V0P01iP000<RFm_ofU_nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKo
U_JFmP6F00000nH2iP02o`0]0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H200;o02oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02o`0]
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200?o02d2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800_l01>H2iP81iP000<RFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP00
0<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1UP00063V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82o`0:
iP;V0^H2iP;V0P;o05[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000FNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00Co00P2iP;o0^H2iP?o
063V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_Kom_ofU_KomYKfU_JFm_ofU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0_l2iP;V0^H2o`;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001UU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFmYKfooJFmYH00ol0H9KfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKoiP;V0_l2iP;VonH2iP;V0^KoiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001IU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
1?l00oJFmP02o`03U_JF00Co00?fU_H00_l0FYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH00038iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000b>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1UP000<SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000b9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00038
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000<RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000b>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH00038U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000<SV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V0000\
\>"],
  ImageRangeCache->{{{0, 200.562}, {287, 0}} -> {-0.100021, -1.00508, 
  0.0209413, 0.0209413}},
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[g[#1]&, "-Z[5]-", "-Z[5]-"]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Although ",
  StyleBox["f2", "MR"],
  " and ",
  StyleBox["f3", "MR"],
  " were produced by different means, they represent the same mathematical \
function and are equal as ",
  StyleBox["Morphoids", "MR"],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EqualMorphoidQ[f2, \ f3]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Using a list of rules (showing how domain elements are to be mapped to \
codomain elements) is another approach to forming a ",
  StyleBox["Morphoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f4\  = \ 
      FormMorphoid[{0\  \[Rule] \ 2, \ 1\  \[Rule] \ 3, \ 2\  \[Rule] \ 4, \ 
          3\  \[Rule] \ 0, \ 4\  \[Rule] \ 1}, \ Z[5], \ Z[5]]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 2, 1 \[Rule] 3, 2 \[Rule] 4, 3 \[Rule] 0, 
        4 \[Rule] 1}, "-Z[5]-", "-Z[5]-"]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"Form"]
}, Open  ]],

Cell["\<\
The listing of the rules is automatically suppressed if the list is \
too long; we can also manually suppress the list from being displayed.\
\>", 
  "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormMorphoid[{0\  \[Rule] \ 2, \ 1\  \[Rule] \ 3, \ 2\  \[Rule] \ 4, \ 
        3\  \[Rule] \ 0, \ 4\  \[Rule] \ 1}, \ Z[5], \ Z[5], \ 
      FormatFunction\  \[Rule] \ True]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid["-Rules-", "-Z[5]-", "-Z[5]-"]\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Applying ",
  StyleBox["EqualMorphoidQ", "MR"],
  " over the Cartesian product of two lists both containing ",
  StyleBox["f2", "MR"],
  ", ",
  StyleBox["f3", "MR"],
  ", and ",
  StyleBox["f4", "MR"],
  " shows that these three ",
  StyleBox["Morphoids", "MR"],
  " are identical."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CloseSets[{f2, f3, f4}, {f2, \ f3, \ f4}, \ EqualMorphoidQ]\)], "Input",\

  CellLabel->"In[9]:=",
  CellTags->"Form"],

Cell[BoxData[
    \({True}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  " are isomorphic, we should be able to find an isomorphism between them. \
Since there is no natural formula to define this as a function, and setting \
up a list of rules is a bit tedious for these two groups, it is useful to \
formulate the ",
  StyleBox["Morphoid", "MR"],
  " by using a list of positions in the codomain to give the pairing. The ",
  StyleBox["FormMorphoidSetup", "MR"],
  " function is used to begin this process."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FormMorphoidSetup[Symmetric[3], \ Dihedral[3]]; \)\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.05 0.25 0.05 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .05 m
.5 .45 L
s
[(Domain)] .2 .4 0 0 Mshowa
[(Codomain)] .8 .4 0 0 Mshowa
[({1, 2, 3})] .2 .35 0 0 Mshowa
[(1)] .45 .35 0 0 Mshowa
[({1, 3, 2})] .2 .3 0 0 Mshowa
[(2)] .45 .3 0 0 Mshowa
[({2, 1, 3})] .2 .25 0 0 Mshowa
[(3)] .45 .25 0 0 Mshowa
[({2, 3, 1})] .2 .2 0 0 Mshowa
[(4)] .45 .2 0 0 Mshowa
[({3, 1, 2})] .2 .15 0 0 Mshowa
[(5)] .45 .15 0 0 Mshowa
[({3, 2, 1})] .2 .1 0 0 Mshowa
[(6)] .45 .1 0 0 Mshowa
[(1)] .8 .35 0 0 Mshowa
[(1)] .55 .35 0 0 Mshowa
[(Rot)] .8 .3 0 0 Mshowa
[(2)] .55 .3 0 0 Mshowa
[(Rot^2)] .8 .25 0 0 Mshowa
[(3)] .55 .25 0 0 Mshowa
[(Ref)] .8 .2 0 0 Mshowa
[(4)] .55 .2 0 0 Mshowa
[(Rot**Ref)] .8 .15 0 0 Mshowa
[(5)] .55 .15 0 0 Mshowa
[(Rot^2**Ref)] .8 .1 0 0 Mshowa
[(6)] .55 .1 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 144},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0002000_l]00;o?P000ol0002>000080000ol000090003o`0000l000?o00003`000ol0000l0003
o`0008h0000P0003o`0000800ol40003o`0000P01?l30003o`0000P00ol40003o`0002d00_l=0003
o`0000X00_lY00;o0P02o`800ol300?o2004o`d00_l200;o0P04o`030?oo00;o7P00020000?o0000
1@000ol000020003o`0000P000?o000010000ol000080003o`0000<000?o0000;0001?l00?l<0003
o`0000T000Co003o:@001?l0ool20005o`000?l00P001?l00?l80003o`0000h000Co0?oo0P000ol0
00040003o`0001h0000O0003o`0000H000?o00003P000ol0000>0003o`0000@000?o0000:`001?l0
0?l<0003o`0000T000Co003o:@03o`<000Go0000o`020003o`0000X000?o00000P000ol0o`030003
o`3o00800ol300Go0P000ol0000N000080000ol0000300;o4P000ol0000=0003o`0000<000?o0000
;003o`d000?o00002@03obX000Co003o0P001Ol0003o008000?o00002`000ol000020003o`0000<0
00Go0000o`020004o`00o`<000Co003o8000020000?o00001@000ol0000<0004o`00o`l000?o0000
0`000ol0000/0003o`0000d000?o00002@000ol0000Z0004o`00o`<00ol200Co20001?l00?l200Go
00<0ool00ol01@3o003o00<00ol200Co7P0002000_l300?o4002o`l00_l400;o;`03o``000?o0000
2P03obP01?l:0003o`00008000?o0?l01002o`D000?o00000`000ol00004o`X000?o00007P0008l0
00?o0000@`000ol000030003o`0002400olN0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>00008002obd00_ln0003o`0008h0000P0003o`0000T0
00?o00003`000ol0000?0003o`0003`000?o0000SP00020000?o00000P03o`@000?o00002003o`@0
00?o00002004o`<000?o0000;003o`d000?o00002@03obl00_l200;o0P03o`<00ol=00;o0P02o`80
1?l00`3oo`02ob@0000P0003o`0000D000?o00000P000ol000080003o`0000@000?o000020000ol0
00030003o`0002l000?o00002P000ol0000<0003o`0002d000Co0?oo0P001Ol0003o008000Co003o
3@001?l0ool20003o`0000@000?o0000900001l000?o00001P000ol0000=0003o`00010000?o0000
0`000ol0000^0003o`0000X000?o000030000ol0000]00?o0`001Ol0003o008000?o00000`000ol0
o`030003o`3o00800ol300Go0P000ol0000T000080000ol0000300;o40000ol0000A0005o`000?l0
;P03o`d000?o00002@03oc0000Co003o0P001Ol0003o008000?o000010000ol000030005o`000?l0
0P001?l00?l30004o`00obH0000P0003o`0000D000?o00003@000ol0000>0004o`00o`<000?o0000
;0000ol0000=0003o`0000T000?o0000<0001?l00?l300?o0P04o`801Ol00`3oo`03o`050?l00?l0
0`03o`801?lT00008002o`<00ol?00;o4@02o`<00_l^00Co30000ol0000900Co;P04o`X000?o0000
10000ol000030003o`0000Co2P000ol0000T0000S`000ol000190003o`0001/00olT0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>00008002obd00_ln0003o`0008h0000P0003o`0000T000?o00003`000ol0000?0003o`0003`0
00?o0000SP00020000?o00000P04o`<000?o00002003o`@000?o00002003o`@000?o0000;@03o``0
00?o00002P03ocd00_l200;o0P04o`030?oo00;o<`00020000?o00000`000ol000040003o`0000X0
00?o00000P000ol000080003o`0000<000?o0000;P000ol0000;0003o`0000/000?o0000?@001?l0
ool20003o`0000@000?o0000<`0001l000?o00001@000ol0000@0003o`0000d000?o000010000ol0
000[00Co30000ol0000900Co?P03o`<01Ol20003o`0003<0000P0003o`0000D000?o00003@02oa00
00?o00000`000ol0000/0003o`3o00d000?o00002@000ol0o`0o0004o`00o`8000Go0000o`020003
o`0003<0000P0003o`00008000Co003o4@000ol0000=0003o`0000<000?o0000;0000ol0o`0=0003
o`0000T000?o0?l0?`001?l00?l300?o0P04oc<0000P00;o1002o`l00ol?00;o1002obl00_l=0003
o`0000X00_ln00Co2P000ol0000c0000S`000ol0001H00?o<`0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0002000_l]00;o?P000ol0002>0000
80000ol000090003o`0000l000?o00003`000ol0000l0003o`0008h0000P0003o`0000801?l30003
o`0000P00ol40003o`0000P00ol40003o`0002`00ol=0003o`0000T00olh00;o0P02o`800ol300?o
2004obd0000P0003o`0000<000?o000010000ol000080003o`0000@000?o00002P001Ol0003o0340
00?o00002P000ol0000<0003o`0003H000Co0?oo0P001Ol0003o008000Co003o20000ol0000]0000
7`000ol000050003o`0000h000?o00004@000ol000020003o`0002h000?o00002P000ol0000<0003
o`0003H00ol30005o`000?l00P000ol0000:0003o`0002`0000P0003o`0000D000?o00003@000ol0
000?00;o10000ol0000]00;o3@000ol0000:00;o>@001?l00?l20005o`000?l00P000ol0000;0003
o`0002/0000P0003o`00008000Co003o3`000ol0000A0005o`000?l0<@000ol0000:0003o`0000`0
00?o0000=P001?l00?l300?o0P04o`P000Co003o;@0002000_l400;o3`02oa000ol300;o;P03o`d0
00?o00002@03ocP01?l:0003o`00008000?o0?l01002obh0002?0003o`00058000?o00000`000ol0
000c0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>00008002obd00_ln0003o`0008h0000P0003o`0000T000?o00003`000ol0000?0003o`0003`0
00?o0000SP00020000?o00000P03o`@000?o00002003o`@000?o00002004o`<000?o0000;004o``0
00?o00002@04ocd00_l200;o0P03o`<00olc000080000ol000030003o`0000@000?o00002P000ol0
00020003o`0000P000?o00000`000ol0000]0003o`0000`000?o00002P000ol0000n0004o`3oo`80
00Go0000o`020004o`00oc80000O0003o`0000@000?o00004@000ol0000>0003o`0000<000?o0000
;@000ol0000;0003o`0000/000?o0000?@03o`<000Go0000o`020003o`0003<0000P0003o`0000<0
00?o00003`02oa8000Go0000o`0a0003o`0000X000?o000030000ol0000l0004o`00o`8000Go0000
o`020003o`0003<0000P0003o`0000<000?o00004@000ol0000<0004o`00o`<000?o0000;0001?l0
0?l<0003o`0000T000Co003o?P001?l00?l300?o0P04oc<0000P00;o0`02oa000ol@00;o0`02obl0
0_l=0003o`0000X00_ln00Co2P000ol0000c0000S`000ol0001H0003o`0003<0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
000P00;o;@02och000?o0000SP00020000?o00002@000ol0000?0003o`0000l000?o0000?0000ol0
002>000080000ol0000200?o10000ol0000800Co0`000ol0000800?o10000ol0000/00?o3@000ol0
000900?oA@03ocX0000P0003o`0000<000?o000010000ol000080003o`0000@000?o00002P001Ol0
003o02l000?o000030000ol0000:0003o`0004D000?o0000>@0001l000?o000010000ol0000@0003
o`00010000?o00000P000ol0000/0003o`0000`000?o00002P000ol000150003o`0003T0000P0003
o`0000<000?o00004@000ol0000=00;o10000ol0000]0003o`0000`000?o00002P000ol000150003
o`0003T0000P0003o`0000<000?o00003P001?l00?lA0005o`000?l0;`000ol0000<0003o`0000X0
00?o0000A@000ol0000i00008002o`<00_lA00;o3`03o`<00_l^00;o3P000ol0000900;oAP02oc/0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0000W00Go0`03o`8000Ko0?l0o`05o`03
0?oo00?o00@0ool00_m40003o`0003`01?l300?o0`05o`040?ooo`8000Ko0?l0o`05o`030?oo00?o
00@0ool00_lS0000:0001ol0003o0?l00`002Ol0o`3o0?l0o`020003o`00008000Go0000o`020003
o`0004<000?o0000>`000ol000040007o`000?l0o`030003o`3o00<000Wo0?l0o`3o0?l00P000ol0
00020005o`000?l00P000ol0000R0000:0001ol0003o0?l00`002?l0o`3o0?l01?l40005o`000?l0
0P000ol000130003o`0003/000?o000010001ol0003o0?l00`000ol0o`030008o`3o0?l0o`04o`@0
00Go0000o`020003o`000280000X0007o`000?l0o`030007o`3o0?l0o`040003o`00008000Go0000
o`020003o`0004<000?o0000>`000ol000040007o`000?l0o`030003o`3o00<000Oo0?l0o`3o00@0
00?o00000P001Ol0003o008000?o00008P0002P000Go0000o`0200?o00<0ool01?l200?o0`02o`80
1Om50003o`0003/000Go0000o`0300?o0`04o`800ol00`3oo`04o`800ol300;o0P05ob@0000W00Go
H`000ol0000l00Co30000ol0000o0000@P000ol0001:0003o`0004/00_lE0003o`0002T0002?0003
o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003
o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-10.0351, -5.00005, 0.0699308, 
  0.0699308}},
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Using the preceding graphic, suppose that we want to map {1, 2, 3} to 1, \
{1, 3, 2} to ",
  Cell[BoxData[
      FormBox[
        StyleBox["Ref",
          "MR"], TraditionalForm]]],
  ", {2, 1, 3} to ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Rot\^2**\ Ref\),
          "MR"], TraditionalForm]]],
  ", {2, 3, 1} to ",
  Cell[BoxData[
      FormBox[
        StyleBox["Rot",
          "MR"], TraditionalForm]]],
  ", {3, 1, 2} to ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Rot\^2\),
          "MR"], TraditionalForm]]],
  ", and finally {3, 2, 1} to ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Rot**\ Ref\),
          "MR"], TraditionalForm]]],
  ". Note that the (ordered) images of this map occur in positions {1, 4, 6, \
2, 3, 5} in the list of elements in ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  "."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f5 = 
      FormMorphoid[{1, 4, 6\ , \ 2, \ 3, \ 5}, \ Symmetric[3], \ Dihedral[3]]
        \)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[{{1, 2, 3} \[Rule] 1, {1, 3, 2} \[Rule] Ref, {2, 1, 3} \[Rule] 
          Rot\^2**Ref, {2, 3, 1} \[Rule] Rot, {3, 1, 2} \[Rule] 
          Rot\^2, {3, 2, 1} \[Rule] Rot**Ref}, "-S[3]-", "-D[3]-"]\)], 
  "Output",
  CellLabel->"Out[11]=",
  CellTags->"Form"]
}, Open  ]],

Cell["The follwoing shows that this is an isomorphism.", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsomorphismQ[f5, \ Cautious\  \[Rule] \ True]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(IsomorphismQ::"notHom" \( : \ \) 
      "The Morphoid is not a homomorphism, so it is not possible to be an \
isomorphism."\)], "Message",
  CellTags->"Form"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Recall how the ",
  StyleBox["Parity", "MR"],
  " function works."
}], "MathCaption",
  CellTags->{"Form", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(parityList\  = \ Map[{#, Parity[#]}&, \ Elements[Symmetric[3]]]\)], 
  "Input",
  CellLabel->"In[13]:=",
  CellTags->"Form"],

Cell[BoxData[
    \({{{1, 2, 3}, 1}, {{1, 3, 2}, \(-1\)}, {{2, 1, 3}, \(-1\)}, {{2, 3, 1}, 
        1}, {{3, 1, 2}, 1}, {{3, 2, 1}, \(-1\)}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Now consider a \[OpenCurlyDoubleQuote]natural\[CloseCurlyDoubleQuote] \
morphism with ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " as its domain and {\[PlusMinus]1} as the codomain."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FormMorphoidSetup[Symmetric[3], IntegerUnits]; \)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Form"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.05 0.25 0.05 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .05 m
.5 .45 L
s
[(Domain)] .2 .4 0 0 Mshowa
[(Codomain)] .8 .3 0 0 Mshowa
[({1, 2, 3})] .2 .35 0 0 Mshowa
[(1)] .45 .35 0 0 Mshowa
[({1, 3, 2})] .2 .3 0 0 Mshowa
[(2)] .45 .3 0 0 Mshowa
[({2, 1, 3})] .2 .25 0 0 Mshowa
[(3)] .45 .25 0 0 Mshowa
[({2, 3, 1})] .2 .2 0 0 Mshowa
[(4)] .45 .2 0 0 Mshowa
[({3, 1, 2})] .2 .15 0 0 Mshowa
[(5)] .45 .15 0 0 Mshowa
[({3, 2, 1})] .2 .1 0 0 Mshowa
[(6)] .45 .1 0 0 Mshowa
[(1)] .8 .25 0 0 Mshowa
[(1)] .55 .25 0 0 Mshowa
[(-1)] .8 .2 0 0 Mshowa
[(2)] .55 .2 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0002000_l]00;o?P000ol0002>000080000ol000090003o`0000l000?o00003`000ol0000l0003
o`0008h0000P0003o`0000800ol40003o`0000P01?l30003o`0000P00ol40003o`0002d00_l=0003
o`0008h0000P0003o`0000D000?o00000P000ol000080003o`0000@000?o000020000ol000030003
o`0002`000Co003o30000ol0002>00007`000ol000060003o`0000h000?o00003P000ol000040003
o`0002/000Co003o30000ol0002>000080000ol0000300;o4P000ol0000=0003o`0000<000?o0000
;003o`d000?o0000SP00020000?o00001@000ol0000<0004o`00o`l000?o00000`000ol0000/0003
o`0000d000?o0000SP0002000_l300?o4002o`l00_l400;o;`03o``000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0002000_l]00;o?P000ol0002>000080000ol000090003o`0000l000?o00003`000ol0000l0003
o`0008h0000P0003o`0000800ol40003o`0000P00ol40003o`0000P01?l30003o`0002`00ol=0003
o`0008h0000P0003o`0000D000?o00000P000ol000080003o`0000@000?o000020000ol000030003
o`0002l000?o00002P000ol0002>00007`000ol000060003o`0000d000?o000040000ol000030003
o`0002h000?o00002P000ol0002>000080000ol0000300;o40000ol0000A0005o`000?l0;P03o`d0
00?o0000SP00020000?o00001@000ol0000=0003o`0000h000Co003o0`000ol0000/0003o`0000d0
00?o0000SP0002000_l300?o3`02oa400_l300;o;P04o``000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0002000_l]00;o?P000ol0002>000080000ol000090003o`0000l000?o00003`000ol0
000l0003o`0008h0000P0003o`0000801?l30003o`0000P00ol40003o`0000P00ol40003o`0002d0
0ol<0003o`0000T01?m700?o=`00020000?o00000`000ol000040003o`0000X000?o00000P000ol0
00080003o`0000<000?o0000;P000ol0000;0003o`0000X000?o0000B0000ol0000f00007`000ol0
00050003o`00010000?o00003@000ol000040003o`0002/01?l<0003o`0000/000?o0000@005o`80
00?o0000=P00020000?o00001@000ol0000=00;o40000ol000030003o`0002`000?o0?l03@000ol0
000<0003o`0004H000?o0000=P00020000?o00000P001?l00?lA0003o`0000d000?o00000`000ol0
000/0003o`3o00d000?o00002@001?l00?m80003o`0003H0000P00;o1002o`l00ol?00;o1002obl0
0_l=0003o`0000X00_m800;o>00008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0002000_l]00;o?P000ol0002>000080000ol0
00090003o`0000l000?o00003`000ol0000l0003o`0008h0000P0003o`0000801?l30003o`0000P0
0ol40003o`0000P00ol40003o`0002`00ol=0003o`0000T00om500?o>P00020000?o00000`000ol0
00040003o`0000P000?o000010000ol0000:0005o`000?l0<@000ol0000:0003o`0000X000?o0000
A@000ol0000i00007`000ol000050003o`0000h000?o00004@000ol000020003o`0002h000?o0000
2P000ol0000:0003o`0004D000?o0000>@00020000?o00001@000ol0000=0003o`0000l00_l40003
o`0002d00_l=0003o`0000X000?o0000A@000ol0000i000080000ol000020004o`00o`l000?o0000
4@001Ol0003o034000?o00002P000ol0000:0003o`0004D000?o0000>@0002000_l400;o3`02oa00
0ol300;o;P03o`d000?o00002@02odH00_lk0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>00008002obd00_ln0003o`0008h0
000P0003o`0000T000?o00003`000ol0000?0003o`0003`000?o0000SP00020000?o00000P03o`@0
00?o00002003o`@000?o00002004o`<000?o0000;004o``000?o0000?004o`<00ol300Go00@0oooo
0P001_l0o`3o00Go00<0ool00ol0103oo`02ob<0000P0003o`0000<000?o000010000ol0000:0003
o`00008000?o000020000ol000030003o`0002d000?o000030000ol0000k0003o`0000@000Oo0000
o`3o00<000?o0?l00`002Ol0o`3o0?l0o`020003o`00008000Go0000o`020003o`000280000O0003
o`0000@000?o00004@000ol0000>0003o`0000<000?o0000;@000ol0000;0003o`0003/000?o0000
10001ol0003o0?l00`000ol0o`030008o`3o0?l0o`04o`@000Go0000o`020003o`000280000P0003
o`0000<000?o00003`02oa8000Go0000o`0a0003o`0000X000?o0000>`000ol000040007o`000?l0
o`030003o`3o00<000Oo0?l0o`3o00@000?o00000P001Ol0003o008000?o00008P00020000?o0000
0`000ol0000A0003o`0000`000Co003o0`000ol0000/0004o`00o``000?o0000>`001Ol0003o00<0
0ol300Co0P03o`030?oo00Co0P03o`<00_l200Go900002000_l300;o4003oa000_l300;o;`02o`d0
00?o0000?004o``000?o0000?`0008l000?o0000B`02oaD000?o0000:@0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP000200
0_l]00;o?P000ol0002>000080000ol000090003o`0000l000?o00003`000ol0000l0003o`0008h0
000P0003o`0000800ol40003o`0000P01?l30003o`0000P00ol40003o`0002`00ol=0003o`0008h0
000P0003o`0000<000?o000010000ol000080003o`0000@000?o00002P001Ol0003o02l000?o0000
30000ol0002>00007`000ol000040003o`00010000?o000040000ol000020003o`0002`000?o0000
30000ol0002>000080000ol000030003o`00014000?o00003@02o`@000?o0000;@000ol0000<0003
o`0008h0000P0003o`0000<000?o00003P001?l00?lA0005o`000?l0;`000ol0000<0003o`0008h0
000P00;o0`02oa400_l?00?o0`02obh00_l>0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0000W00Go0`03o`8000Ko0?l0o`05o`030?oo00?o00@0ool00_m40003o`0008h0
000X0007o`000?l0o`030009o`3o0?l0o`3o008000?o00000P001Ol0003o008000?o0000@`000ol0
002>0000:0001ol0003o0?l00`002?l0o`3o0?l01?l40005o`000?l00P000ol000130003o`0008h0
000X0007o`000?l0o`030007o`3o0?l0o`040003o`00008000Go0000o`020003o`0004<000?o0000
SP0002P000Go0000o`0200?o00<0ool01?l200?o0`02o`801Om50003o`0008h0000W00GoH`000ol0
002>0000@P000ol0001:0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0002?0003o`0008h0003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-10.0351, -5.00005, 0.0699308, 
  0.0699308}},
  CellTags->"Form"]
}, Open  ]],

Cell["\<\
We want the elements with parity -1 to go to position 2 in the list \
of the codomain elements.\
\>", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(positions\  = \ 
      Last[Transpose[parityList]]\  /. \ \(-1\)\  \[Rule] \ 2\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"Form"],

Cell[BoxData[
    \({1, 2, 2, 1, 1, 2}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "Now we can easily form the ",
  StyleBox["Morphoid", "MR"],
  " using this list of positions."
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f6\  = \ FormMorphoid[positions, Symmetric[3], IntegerUnits]\)], "Input",\

  CellLabel->"In[16]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid[{{1, 2, 3} \[Rule] 1, {1, 3, 2} \[Rule] \(-1\), {2, 1, 3} 
          \[Rule] \(-1\), {2, 3, 1} \[Rule] 1, {3, 1, 2} \[Rule] 1, {3, 2, 1} 
          \[Rule] \(-1\)}, "-S[3]-", "-IntegerUnits-"]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"Form"]
}, Open  ]],

Cell["This is indeed a homomorphism.", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MorphismQ[f6]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"Form"]
}, Open  ]],

Cell["\<\
In fact, the kernel of this homomorphism is the alternating group \
on three letters.\
\>", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Elements[Kernel[f6]] === \ Elements[Alternating[3]]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "If the domain is a cyclic groupoid, we can get by with just specifying a \
single defining rule. (In this case, this will define the other rules since ",
  
  StyleBox["\"g\"", "MR"],
  " is a generator of ",
  StyleBox["CyclicGroup", "MR"],
  "[5]. Note also that ",
  StyleBox["ZG[5]", "MR"],
  " is the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  ".)"
}], "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f7 = FormMorphoid[\ "\<g\>" \[Rule] 3, \ CyclicGroup[5], ZG[5]]\)], 
  "Input",
  CellLabel->"In[19]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(Morphoid["g \[Rule] 3", "-Cyclic[5]-", "-Z[5]-"]\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"Form"]
}, Open  ]],

Cell["As expected, these two groups are isomorphic.", "MathCaption",
  CellTags->"Form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsomorphismQ[f7]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"Form"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"Form"]
}, Open  ]],

Cell[TextData[{
  "4.2 Structure of ",
  StyleBox["Morphoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->{"Structure", "i:5"}],

Cell[TextData[{
  "There are three fundamental parts of a ",
  StyleBox["Morphoid", "MR"],
  ": the function, domain, and codomain."
}], "Text",
  CellTags->"Structure"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MorphoidFunction",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["function",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((or\ list\ of\ rules)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["MorphoidRules",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rules",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((or\ function)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Domain",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ the\ domain\ of\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], " ", 
                FormBox["f",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Codomain",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(give\ the\ codomain\ \((target\ space)\)\ of\ the\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], " ", 
                FormBox["f",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"Structure", "i:6"}],

Cell[TextData[{
  "Extracting parts of a ",
  StyleBox["Morphoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Structure"],

Cell[TextData[{
  "Define the ",
  StyleBox["Morphoid", "MR"],
  " that takes any element ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_10\)]],
  " and maps it to ",
  Cell[BoxData[
      \(TraditionalForm\`3  x\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_30\)]],
  "."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g1\  = \ FormMorphoid[Mod[3  #, \ 30]&, \ Z[10], \ Z[30]]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \(Morphoid[Mod[3\ #1, 30]&, "-Z[10]-", "-Z[30]-"]\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Here is how we extract the function, domain, and codomain of ",
  StyleBox["g1", "MR"],
  "."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({MorphoidFunction[g1], Domain[g1], \ Codomain[g1]}\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({Mod[3\ #1, 30]&, 
      Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, Mod[#1 + #2, 10]&], 
      Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29}, Mod[#1 + #2, 30]&]}
      \)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Sometimes we may wish to change the way we view a function or ",
  StyleBox["Morphoid", "MR"],
  "; here are some methods of doing so."
}], "Text",
  CellTags->"Structure"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ToRules",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["convert",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["function",
                    SingleLetterItalics->False], 
                  StyleBox["\[Hyphen]",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox["based",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rules\[Hyphen]based",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"]}]},
          {
            RowBox[{
              StyleBox["ToRules",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(f, \ D\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox[\(convert\ the\ function\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["f",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ with\ domain\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["D",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ \((where\ \)\),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["D",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["can",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["be",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[\(a\ set, \ groupoid, \ or\ ringoid\),
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rules",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(x\  \[Rule] \),
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[\(f[x]\),
                "MR"]}]},
          {
            RowBox[{
              StyleBox["ToRules",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(f, \ D, \ C\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(convert\ the\ function\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ with\ domain\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["D",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["rules",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["form",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["x",
                      "MR"]}], 
                  StyleBox[" ",
                    "MR"], 
                  StyleBox["\[Rule]",
                    "MR"], 
                  StyleBox[" ",
                    "Text"], 
                  StyleBox[\(f[x]\),
                    "MR"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(guaranteeing\ that\ the\ images\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["fall",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["codomain",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["C",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["returning",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["codomain",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["C",
                      "TraditionalForm"],
                    "Text"], " ", 
                  StyleBox["does",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["not",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["contain",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["all",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["images",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ToFunction",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["convert",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["rules",
                    SingleLetterItalics->False], 
                  StyleBox["\[Hyphen]",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox["based",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["function\[Hyphen]based",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"]}]},
          {
            RowBox[{
              StyleBox["ToFunction",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["convert",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["rules",
                    SingleLetterItalics->False], 
                  StyleBox["\[Hyphen]",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox["based",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["function\[Hyphen]based",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[\(\ named\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["ToFunction",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["rules",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(convert\ a\ list\ of\ rules\ into\ a\ function\ named\ \),
                SingleLetterItalics->False], 
              StyleBox["ffx",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["where",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["x",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["an",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["integer",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ToFunction",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["rules",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(convert\ a\ list\ of\ rules\ into\ a\ function\ named\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["g",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"Structure", "i:7"}],

Cell["Converting between rules and functions.", "Caption",
  CellTags->"Structure"],

Cell[TextData[{
  "This is the result of converting the ",
  StyleBox["Morphoid", "MR"],
  " we previously defined into a rules-based ",
  StyleBox["Morphoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g2\  = \ ToRules[g1]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 0, 1 \[Rule] 3, 2 \[Rule] 6, 3 \[Rule] 9, 
        4 \[Rule] 12, 5 \[Rule] 15, 6 \[Rule] 18, 7 \[Rule] 21, 8 \[Rule] 24, 
        9 \[Rule] 27}, "-Z[10]-", "-Z[30]-"]\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MorphoidRules", "MR"],
  " extracts just the list of rules."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(someRules\  = \ MorphoidRules[g2]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({0 \[Rule] 0, 1 \[Rule] 3, 2 \[Rule] 6, 3 \[Rule] 9, 4 \[Rule] 12, 
      5 \[Rule] 15, 6 \[Rule] 18, 7 \[Rule] 21, 8 \[Rule] 24, 9 \[Rule] 27}
      \)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToFunction", "MR"],
  " works in different ways with different types of input."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({g5\  = \ ToFunction[g2], \ ToFunction[g2, \ g3], \ 
      ToFunction[someRules], \ ToFunction[someRules, \ g4]}\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \({Morphoid[ff3[#1]&, "-Z[10]-", "-Z[30]-"], 
      Morphoid[g3[#1]&, "-Z[10]-", "-Z[30]-"], ff4, g4}\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Note that the function listed in the ",
  StyleBox["Morphoid", "MR"],
  " ",
  StyleBox["g5", "MR"],
  " (starting with ",
  StyleBox["ff", "MR"],
  ") can be inspected with ",
  StyleBox["Information", "MR"],
  " or ?."
}], "Text",
  CellTags->"Structure"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EqualMorphoidQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(give\ \),
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[\(\ if\ \),
                    SingleLetterItalics->False], 
                  StyleBox["Morphoids",
                    "MR"], 
                  StyleBox[" ",
                    "Text"], 
                  StyleBox[
                    FormBox["f",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ and\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["g",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["are",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["equal",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["mathematical",
                  SingleLetterItalics->False], 
                StyleBox["  ",
                  SingleLetterItalics->False], 
                StyleBox["functions",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["MorphoidComposition",
                "MR"], 
              StyleBox["[",
                "MR"], " ", 
              StyleBox[\(g, \ f\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"give", " ", "the", " ", 
              StyleBox["Morphoid",
                "MR"], " ", "resulting", " ", "from", " ", "composing", " ", 
              StyleBox["f",
                FontSlant->"Italic"], " ", "followed", " ", "by", 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["g",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.42, 0.58}},
  CellTags->{"Structure", "i:8"}],

Cell[TextData[{
  "Functions on pairs of ",
  StyleBox["Morphoids",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Structure"],

Cell[TextData[{
  "Given two ",
  StyleBox["Morphoids", "MR"],
  ", we may want to compose these two functions."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f1\  = \ FormMorphoid[Mod[#\  + \ 3, \ 8]&, \ Z[4], \ Z[7]]; \n
    f2\  = \ FormMorphoid[Mod[#^2\  + \ 1, \ 12]&, \ Z[7], \ Z[12]]; \n
    MorphoidComposition[f2, \ f1]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 10, 1 \[Rule] 5, 2 \[Rule] 2, 3 \[Rule] 1}, 
      "-Z[4]-", "-Z[12]-"]\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "Note that the order of the operands is important; the composition does not \
make sense in the other direction. ",
  Cell[BoxData[
      RowBox[{
        StyleBox["MorphoidComposition",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["g",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox["f",
            "TI"]}], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " returns a function ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " where we have ",
  Cell[BoxData[
      \(TraditionalForm\`h(x)\  = \ g(f(x))\)]],
  "."
}], "MathCaption",
  CellTags->"Structure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MorphoidComposition[f1, f2]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"Structure"],

Cell[BoxData[
    \(MorphoidComposition::"notdef" \( : \ \) 
      "Composition is not defined because the image of the first map is \
\!\(\"Z[12]\"\) while the domain of the second map is \!\(\"Z[4]\"\), which \
are not the same."\)], "Message",
  CellTags->"Structure"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"Structure"]
}, Open  ]],

Cell[TextData[{
  "4.3 Built-in ",
  StyleBox["Morphoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->{"BuiltIn", "i:9"}],

Cell[TextData[{
  "There are several built-in ",
  StyleBox["Morphoids", "MR"],
  " that reflect commonly used functions."
}], "Text",
  CellTags->"BuiltIn"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ZMap",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["m",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(form\ the\ \),
                    SingleLetterItalics->False], 
                  StyleBox["Morphoid",
                    "MR"], 
                  StyleBox[\(\ from\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(\[DoubleStruckCapitalZ]\_m\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ to\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(\[DoubleStruckCapitalZ]\_n\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["with",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["function",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox[\(Mod[#, \ n]&\),
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox[\(i . e . \),
                        SingleLetterItalics->False], 
                      StyleBox[",",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      RowBox[{
                        StyleBox[\(reduce\ mod\),
                          SingleLetterItalics->False], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox[
                          FormBox["n",
                            "TraditionalForm"],
                          "Text"]}]}], 
                    StyleBox[")",
                      SingleLetterItalics->False]}]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["where",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["current",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["value",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["DefaultStructure",
                      "MR"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["specifies",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["whether",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["these",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["structures",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["are",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["to",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["be",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["considered",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["groups",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["or",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["rings",
                      SingleLetterItalics->False]}]}]}]}]},
          {
            RowBox[{
              StyleBox["ZMap",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["m",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{"g", " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", "h"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(for\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["g",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ a\ generator\ of\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(\[DoubleStruckCapitalZ]\_m, \),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["form",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["Morphoid",
                    "MR"], 
                  StyleBox[\(\ from\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(\[DoubleStruckCapitalZ]\_m\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ to\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[\(\[DoubleStruckCapitalZ]\_n\),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ defined\ by\ the\ rule\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["g",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\[Rule]",
                  SingleLetterItalics->False,
                  FontFamily->"Courier"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox[
                    FormBox[\(h, \),
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["where",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["current",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["value",
                    SingleLetterItalics->False]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["DefaultStructure",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["specifies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["whether",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["these",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["structures",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["considered",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groups",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["rings",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ZMap",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["m",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Structure",
                        "MR",
                        FontSlant->"Plain"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", "StType"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(form\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["ZMap",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["m",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["n",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"], 
                StyleBox[\(\ using\ the\ structure\ \),
                  SingleLetterItalics->False], 
                StyleBox["StType",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"BuiltIn", "i:10"}],

Cell[TextData[{
  "Variations of the ",
  StyleBox["ZMap",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"BuiltIn"],

Cell[TextData[{
  "There is a natural ",
  "morphism",
  " from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_18\)]],
  " into ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  "."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f\  = \ ZMap[18, \ 3]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \(Morphoid["1 \[Rule] 1", "-Z[18]-", "-Z[3]-"]\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"BuiltIn"]
}, Open  ]],

Cell["\<\
Here is how the function actually works on each domain \
element.\
\>", "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToRules[f]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 0, 1 \[Rule] 1, 2 \[Rule] 2, 3 \[Rule] 0, 
        4 \[Rule] 1, 5 \[Rule] 2, 6 \[Rule] 0, 7 \[Rule] 1, 8 \[Rule] 2, 
        9 \[Rule] 0, 10 \[Rule] 1, 11 \[Rule] 2, 12 \[Rule] 0, 13 \[Rule] 1, 
        14 \[Rule] 2, 15 \[Rule] 0, 16 \[Rule] 1, 17 \[Rule] 2}, "-Z[18]-", 
      "-Z[3]-"]\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "The following visualization also makes it clear what is happening with the \
function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(VisualizeMorphoid[f, \ ColorCodomain\  \[Rule] \ Automatic]; \)\)], 
  "Input",
  CellLabel->"In[30]:=",
  CellTags->"BuiltIn"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33613 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.0560224 0.0560224 0.0560224 [
[ 0 0 0 0 ]
[ 1 .33613 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .33613 L
0 .33613 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[18])] .5 .30812 0 0 Mshowa
[(0)] .02381 .28011 0 0 Mshowa
[(1)] .07983 .28011 0 0 Mshowa
[(2)] .13585 .28011 0 0 Mshowa
[(3)] .19188 .28011 0 0 Mshowa
[(4)] .2479 .28011 0 0 Mshowa
[(5)] .30392 .28011 0 0 Mshowa
[(6)] .35994 .28011 0 0 Mshowa
[(7)] .41597 .28011 0 0 Mshowa
[(8)] .47199 .28011 0 0 Mshowa
[(9)] .52801 .28011 0 0 Mshowa
[(10)] .58403 .28011 0 0 Mshowa
[(11)] .64006 .28011 0 0 Mshowa
[(12)] .69608 .28011 0 0 Mshowa
[(13)] .7521 .28011 0 0 Mshowa
[(14)] .80812 .28011 0 0 Mshowa
[(15)] .86415 .28011 0 0 Mshowa
[(16)] .92017 .28011 0 0 Mshowa
[(17)] .97619 .28011 0 0 Mshowa
[(Z[3])] .5 .02801 0 0 Mshowa
[(0)] .02381 .05602 0 0 Mshowa
[(1)] .35994 .05602 0 0 Mshowa
[(2)] .69608 .05602 0 0 Mshowa
0 1 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .26331 m
.02381 .07283 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.07983 .26331 m
.35994 .07283 L
s
% Start of user PostScript
1. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.13585 .26331 m
.69608 .07283 L
s
% Start of user PostScript
2. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.19188 .26331 m
.02381 .07283 L
s
% Start of user PostScript
3. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.2479 .26331 m
.35994 .07283 L
s
% Start of user PostScript
4. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.30392 .26331 m
.69608 .07283 L
s
% Start of user PostScript
5. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.35994 .26331 m
.02381 .07283 L
s
% Start of user PostScript
6. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.41597 .26331 m
.35994 .07283 L
s
% Start of user PostScript
7. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.47199 .26331 m
.69608 .07283 L
s
% Start of user PostScript
8. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.52801 .26331 m
.02381 .07283 L
s
% Start of user PostScript
9. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.58403 .26331 m
.35994 .07283 L
s
% Start of user PostScript
10. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.64006 .26331 m
.69608 .07283 L
s
% Start of user PostScript
11. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.69608 .26331 m
.02381 .07283 L
s
% Start of user PostScript
12. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.7521 .26331 m
.35994 .07283 L
s
% Start of user PostScript
13. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.80812 .26331 m
.69608 .07283 L
s
% Start of user PostScript
14. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.86415 .26331 m
.02381 .07283 L
s
% Start of user PostScript
15. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.92017 .26331 m
.35994 .07283 L
s
% Start of user PostScript
16. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.97619 .26331 m
.69608 .07283 L
s
% Start of user PostScript
17. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[30]:=",
  ImageSize->{288, 96.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81000008^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;o00[fU_JFmYKfU_JF0_l0Q_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;o0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81000008BFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H4o`08U_JFoiKfU_H3o`2<mYKfU_KomYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKoiP;VonH2iP;V0^KoiP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKoU_JFmYKfU_nFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002A
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;o0^H2i_oV0^H2iP02o`2<0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_Kom_ofU_JFoiKfU_JFmYKoU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000Q>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0PCo00?V0^H00_l00`;V0P03o`040^H2iP;o08H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81000000JFmYKfU_H2o`1MU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00?o05fFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01?l0E_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^KoiP;o0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_nFm_ofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;VonH2
o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKoU_KomYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1000000KV0^H2iP82o`1MiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00;o05l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P02o`1GiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001iKfU_JFmYH04=00CoJFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H0
1T`0EiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP067`1FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000000OV0^H2iP;V013@04`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V44`0B@;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8041l0DnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001iKfU_JFmYH04=00B_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF5T`0@OJF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf01HO056FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000006iP;V0^H24M00B0;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQQ<
0442iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0P0H7`1?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000000JFmYKfU_HFd010U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQY<04:FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_HK7`1<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP4000001^H2iP;V0Q3@00?V0]000]000`;@d002d00jiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Qi<03oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
7Ql0BP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0@000006U_JFmYKf0m000oK@d00=d003mYK@00?@00?fd=000]00=IKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF01a<00?fU_H0
0d`0>OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mP037`03mYHO01`O04VFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF004000001^H2iP;V0Po@00@2iP;V0m000nH2iP03d003
iP;@00C@0302iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H=C003
iTa<00i<00@2iP;V0d`0<nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP037`04iP;V0Q0O00?V7al02al0BNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000005U_JFmYH01M000iK@
d00:d005mYKfU_H00]0019KfU_H4d003U_JF00C@02gfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_H034`00iKfC00<C009mYI<C?JFmYKf00=<02gfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00al01OJFmYKf008O00>FmQl031l00oJF7`0;7`1:
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH1000000GV0^H2iP05d003i]3@00O@00?V0^H00]001@;V0^H200?@00D2iP;V
0P03d0040^H2iPC@02P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V3D`00nH2
C00;C005iP;V0^H00T`01P;V0^H2iP=<02OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00al01^H2iP;V0P8O00GV0^H2iP0<7`030^HO00`O04WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001IKf
U_JF00K@00?fd=001]003IKfU_JFd9KfU_JFmYH00]001_JFmYKfUPC@00CfU_JF1M009YKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf2D`00oJFmP0<C007U_JFmYKfUP02C007mYKfU_JF
mP03C00QmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00<O00OfU_JFmYKf008O00NFmYKf
U_JF00`O00?fU_H02Al0C?JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000000GV0^H2iP06d0030]3@00G@00L2iP;V
0^H200;@00OV0^H2iP;V00?@00OV0^H2iP;V00?@00KV0^H2iP84d00LiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P9<00GV0^H2iP08C0030^H200I<00oVC4a<iP9<0^H2iP;V0^H00T`020;V0^H2iP;V
0T`07@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2008O00SV0^H2iP;V0P8O00_V0^H2iP;V0Ql2
iP037`03iQlO00@O00<2iP8021l01NH2iP;V008O04H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@000005U_JFmYH01]000oJF
d004d00:U_JFmYKfU_JFmP;@00RFmYKfU_JFmP?@00OfU_JFmYKf00C@00JFmYKfU_H5d00PmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYH6C003mYKf00M<00KfC?JFmYH2C008mYKfU_JFmYH2C008
mYKfU_JFmYH3C00GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00al029KfU_JFmYKf0Ql029KfU_JFmYKf
0Ql01YKfU_HOmPLO00?fU_H01Ql0CiKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000004iP;V0PO@00<2i]00
0]003^H2d0;V0^H2iP;V0^H20]002NH2iP;V0^H2iP02d0090^H2iP;V0^H200?@00P2iP;V0^H2iPC@
0102iP;V0^H2iP;V0^H2iP;V0T`02`;V0^H2iP;V0^H200E<00<2iP8024`04NH2iP;V0^I<iP;V0^H2
iP;V009<00T2iP;V0^H2iP800d`04@;V0^H2iP;V0^H2iP;V0^H200<O00T2iP;V0^H2iP800Ql04NH2
iP;V0^H2iQoV0^H2iP;V00PO00<2iP801Al02`;V0^H2iP;V0^H2008O04?V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0040000019Kf
U_H8d00OU_K@mYKfU]2FmYKfU_JFmYKfU_K@mYKfU_JFmYKfUP03d009U_JFmYKfU_JF00C@00SfU_JF
mYKfUPC@01_fU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYI<U_H00T`019KfU_H5C00FmYKfU_JFmYKfU_I<
mYKfU_JFmYKfUP=<00VFmYKfU_JFmYH00d`02iKfU_JFmYKfU_JF00<O00VFmYKfU_JFmYH00al05YKf
U_JFmYKfU_HOmYKfU_JFmYKfU_H57`04mYKfUP8O05;fUQnFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000004
iP;V0PS@01GV0^H2iP;V0]02iP;V0^H2iP;V0^H00]002`;V0^H2iP;V0^H200?@00X2iP;V0^H2iP;V
0m002NH2iP;V0^H2iP05d004iP;V0P9<01KV0^H2iP;V0^H2iP;VC>H2iTcV0^H20T`07>I<iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP82C00:iP;V0^H2iP;V0P=<00D2iP;V0P037`0:0^H2iP;V0^H2iP8O
01`2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iQoV0Ql05P;V0^HOiP;V7nH2iP;V0^H2iP;V0^H27`10
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP4000008iKfU_JFmYK@U_JFmYKfU_JFmYKfU]2FmYKfU_JFmYKfU_JF00;@00cfU_JFmYKfU_JF
mYH2d00;mYKfU_JFmYKfU_H01=002YKfU_JFmYKfU_H4d00hU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_H2C00;U_JFmYKfU_JFmYH00d`27`0;U_JFmYKf
U_JFmYH00Ql0N?JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKf7oJFmYKfU_JF
mYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP4000009NH2iP;V0^K@iP;V0^H2iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H00]0030;V
0^H2iP;V0^H2iP?@00cV0^H2iP;V0^H2iP83d00;0^H2iP;V0^H2C0801=00=^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0P9<00SV0^H2iP;V0P<O00`2C4a<
0^H2iP;V0^H27`1j0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^HOiP;V
0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H1000003JFmYKfU_JFd9KfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYK@
U_JFmYKfU_JFmYKfU_H2d00=U_JFmYKfU_JFmYKfUP04d003mYKf009<00JFmYKfU_H5d00SmYKfUTbF
mYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_H00T`03YKfU_JFmYKfU_JFmYKf0T`00iKfUP037`07
U_JFmYKfUP03C003U_JF008O00kfU_JFmYKfU_JFmYKfUP8O02kfU_JFmYKfU_JFmYKfU_HOmYKfU_JF
mYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JF0Ql0??JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000:>H2iP;V0^K@iP;V0^H2iP;V0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iP82d00>iP;V0^H2iP;V0^H2iP83d00>0^H2iP;V0^H2iP;V0^H3d00=iP;V0^H2
iP;V0^H2iP04d00a0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V
0P02C00>7`;V0^H2iP;V0^H2iP83C01n0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H27`;V
0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000ZU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKf
d?JFmYKfU_JFmYKfU_JFmYKf0]003iKfU_JFmYKfU_JFmYKfUP03d00;U_JFmYKfU_JFmYH00T`00oK@
d002d00=U_JFmYKfU_JFmYKfC004d00ZmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFC9KfU_JF
mYKfU_JF0al03iKfC4bFmYKfU_JFmYKfUP027`03mYI<009<042FmYKfU_JFmYKfUQnFmYKfU_JFmYKf
U_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf0Ql0>IKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000002cV0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0P;@013V0^H2iP;V0^H2iP;V0^H20]004>H2
iP;V0^H2C0;V0^H2iP83d00>0^H2iP;V0^I<iP;V0^H5d00RiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0P<O00L2iP;V0^H2009<00OV0^H2iP;V008O00L2iP;V0^H200=<07P2iP;V0^H27`;V
0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H10000042FmYKf
U_JFd9KfU_JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf
0m000oJFmP02C00;U_JFmYKfU_JFmYH01=003oJFmTcfU_JFmYKfU_JFmP04d00LU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmP8O00bFmYKfU_JFmYKfU_H2C003U_JF008O00cfU_JFmYKfU_JFmYH2C00n
mYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JF
mYH27`0fmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
0@00000_iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H00]004P;V
0^H2iP;V0^H2iP;V0^H2iP?@017V0^H2iP;V0^H2iP;V0^H2iP03d00@C0;V0^H2iP;V0^H2iP;V0PG@
01@2iP;V0^H2iP;V0^H2iP;V0^H2C0<O013V0^H2iP;V0^H2iP;V0^H20T`04Al2iP;V0^H2iP;V0^H2
iP;V00=<07<O0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00400000<IKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYH0
0]004?JFmYKfU_JFmYKfU_JFmYH2C00Em]3@U_JFmYKfU_JFmYKfU_JFmYI<00C@016FmYKfU_JFmYKf
U_JFmYKfC004d00=mYKfU_JFmYKfU_JFmP037`9<013fU_JFmYKfU_JFmYKfU_JF0Ql04oI<C9KfU_JF
mYKfU_JFmYKfU_H00Ql3C00kmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JF
mYKfU_JFmYKfU_JFmYKfU_H00Ql0<iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP01000003?V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00]004`;V0^H2iP;V0^H2iP9<0^H2iP800m004`;V0^H2iP;V0^H2iP;VC>H2iP80
0m004P;V0^H2iP;V0^H2iP9<0^H2iPC@00H2iP;V0^H37`0CiP;V0^I<iP;V0^H2iP;V0^H2iP027`05
0^H2iP800T`04nH2iP;V0^H2iP;V0^HOiP;V0^H00d`0KNH2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000010U_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYK@
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKfU_JFmP9<00VFmYKfU_JFmYH00]005?JFmYKfU_JF
mYKfC?JFmYKfU_JF1=004_JFmYKfU_JFmTcfU_JFmYKfUPG@01DOmYKfU_JFmYKfC?JFmYKfU_JFmYH0
0Ql02OJFmYKfU_JFmP02C00DU_JFmYKfU_JFmQofU_JFmYKfU_H3C00hmYKfU_JFmYKfU_HOmYKfU_JF
mYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYH27`0`mYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00000fiP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20]005NH2iP;V0^I<iP;V0^H2iP;V0^H2iP03d00E
iP;V0^H2iP9<0^H2iP;V0^H2iP;V00?@00oV0^H2iP;VC>H2iP;V0^H00al00nH2d003d00?iP;V0^H2
iTcV0^H2iP;V008O00d2iP;V0^H2iP;V0^H2009<01GV0^H2iP;V7nH2iP;V0^H2iP;V0^H00d`0InH2
iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000hU_JFmYKfU]2FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2d00FU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmP?@01GfU_JFC9KfU_JFmYKfU_JFmYKfU_H00m002OJFmYI<U_JFmP037`09mYKfU_JF
mYKf00C@00VFmYKfC?JFmYH00Ql04OJFmYKfU_JFmYKfU_JFmYKf009<01JFmYKf7oJFmYKfU_JFmYKf
U_JFmYKf0d`0I?JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000003cV0^H2
iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d082C00E
iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@01H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V1=000dcV7`027`0@
iP;V0^H2iP;V0^H2iP;V0PG@01U<iQlO0^H2iP;V0^H2iP;V0^H2iP;V0^H2009<01OV7nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP03C00ciQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V008O02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP40
0000>iKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF00;@01SfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH3d00GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQl0
0m005iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00C@01OfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP02C00H
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0d`0G_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000003WV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00T`07@;Vd=02iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H200;@017V0^H2iP;V0^H2iP;V0^H2
iP037`04iP9<0PC@017V0^H2iP;V0^H2iP;V0^H2iP027`040^I<C0C@0142iP;V0^H2iP;V0^H2iP;V
0P027`0MiP9<C>H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H00d`0<>H2iP;V0^H2iP;V0^H2iP;V0^H2
iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P8O02WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP01000003nFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYH00]006OJFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_H00m002oJF
mYKfU_JFmYKf00<O00_fU_JFmTcfU_JFmP03d00<mYKfU_JFmYKfU_JF0Ql02_JFmYKfUTbFmYH5d00B
U_JFmYKfU_JFmYHOU_JFmYKf0T`06YKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKf0d`0F?JFmYKfU_JF
mYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH1000003KV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i]3V0^H2iP;V0^H2iP;V0^H2iP82C00UiP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP03d006iP;V0^H20Ql04NH2iP;V0^H2C0;V0^H2iP;V00C@00H2iP;V0^H27`0A0^H2iP;V0^H2C0;V
0^H2iP801=004>H2iP;V0Ql2iP;V0^H2iP82C00KiP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V009<
02h2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql09P;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@000012U_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf0]0079KfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_H2d00KUQlO7iKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF00?@01ZF7aofU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmPG@00dOU_JFmYKfU_JFmYKf009<01^FmYKfU_JFmYKfU_JFmYHOU_JFmYKf
U_JFmYH00d`0DiKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000<nH2iP;V0^K@iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP02C00?0^H2iP;V0^H2iP;V0^H200;@01[V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0P8O0m006`;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V7`04d00K
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP8O00C@00/2iP;V0^H2iP;V0P02C00LiP;V0^H2iP;V0^H2
iQoV0^H2iP;V0^H2iP;V0P=<02/2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2008O02?V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000004JFmYKfU_JFd9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
0]005IKfU_JFmYKfU_I<mYKfU_JFmYKfUP037`05U_JFmYH00m005IKfU_JFmYKfUTbFmYKfU_JFmYKf
UP027`05mYKfU_H00m007?JFmYKfU_JFmYI<U_JFmYKfU_JFmYHOU_JFmYH4d009mYKfU_JFmYKf009<
01fFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfUP03C01=U_JFmYKfU_JFmQofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00000`
iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H20T`0:>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;@0^H2iP;V0^H2C0;V0^H2iP837`0;0^H2iP;V0^H2iP800]004NH2iP;V0^H2
C0;V0^H2iP;V008O00X2iP;V0^H2iP;V1=001`;V0^H2iP800T`01nH2iP;V0^H00Ql02P;V0^H2iP;V
0^H5d006iP;V0^H20T`07^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0P=<02P2iP;V0^H27`;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql080;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@000019U_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]3fU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02d00<mYKfU_JFC9KfU_JF0al049KfU_JFmYKfU_JFmYKf
U_H3d00<mYKfU_I<mYKfU_JF0Ql04?JFmYKfU_JFmYKfU_JFmYH3d00NU_JFmYKfC?JFmYKf7oJFmYKf
U_JFmYKfU_JFmYKf1=0019KfU_H2C00OU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP03C017
U_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00001;iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K@
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@00L2iP;VC>H200<O01H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0]0020;V0T`2iP;V0Ql05@;V0^H2iP;V0^H2iP;V0^H2iP;V0P04d00NiP;VC>H2
iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H21=009>H2C4cV0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P=<04@2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP400000;9KfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFd9Kf0T`07iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00]000oI<7`027`0KU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00?@00=<mYH00Ql06oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mP03d00OmTcf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP05d00RC9Kf7oJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP=<02<OmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP027`0L
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000L^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0]1<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Qo@7`;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P?@0202iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iPC@0202iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPC@0242iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP800d`0?P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000YU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00T`08=2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0al08YI<d=2FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H27`03UTbF00;@02;fU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf7oI<0m008IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOUP04d00PmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iH3C00PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H27`0IU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000004SV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP837`070^H2C0;V
0P02d00JiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP827`07iP;VC>H2iP03d00JiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP827`03iP;V009<00<2d=000]007nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iQoV0^H00T`5d00NiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H20d`0>0;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000VU_JFmYKfU]2FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C00NU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0Ql039KfU_JFmTcfU_JFmP;@01JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0Ql039KfU_JFmTcfU_JFmP?@
02?fU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYI<U_JFmP03d00NmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_HOmYKfU_JF0T`00oJFmP04d00MU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYH00T`07_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP8O01KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000013
iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0]02iP;V0^H2iP;V0^H2
iP;V0^H2iP037`0TiP;V0^H2iTcV0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H20Ql04NH2iP;V0^H2
C0;V0^H2iP;V00;@02@2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0T`2iP;V0^H4d00L0^H2iP;V
0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP9<00D2iP;V0P05d00J0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V
0^H3C00ciP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
00008iKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<01_fU_JFmYKfU_JFd9KfU_JF
mYKfU_JFmYKfU_H00al05?JFmYKfU_JFmYI<U_JFmYKfU_JF0]003oJFmYKfU_JFmYKfU_JFmP027`0E
U_JFmYKfU_JFmTcfU_JFmYKfU_JF00?@02FFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYI<U_JFmYKf
U_JF00?@01^FmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYH00T`02?JFmYKfU_JF1=006OJFmYKfU_JF
mYKfU_JF7iKfU_JFmYKfU_H00d`06oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP027`0CU_JFmYKf
U_JFmYKfU_JFmYKfUP01000003gV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;@0^H2iP;V0^H2iP;V00<O01WV0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V00;@00/2iP;V
0^H2iP;V0P027`0JiP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP82d00ViP;V0^H2iP;V0^H27`;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP84d00IiP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP02C00:0^H2iP;V
0^H2iPC@01P2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H3C00]iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8O0^H2iP;V0^H2iP;V0^H2iP;V0040000089KfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0T`069KfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmP<O01kfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JF
mYH2d007mYKfU_JFmP027`0NU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf0m009oJFmYKfU_JF
7iKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmP03d00HmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JF
0T`03?JFmYKfU_JFmYKfUPG@01JFmYKfU_JF7iKfU_JFmYKfU_JFmYKf0d`06?JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP8O013fU_JFmYKfU_JFmYKfU_JF0@00000giP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2i]3V0^H2iP037`0XiP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^K@iP;V0P8O02?V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP03d003
iP;V008O0142iP;V0^H2iP;V0^H2iP;V0P02C00?iP;V0^H2iP;V0^H2iP;V00C@01H2iP;V7nH2iP;V
0^H2iP;V0^H2iP;V0T`03`;V0^H2iP;V0^H2iP;V0P04d00EiP;V7nH2iP;V0^H2iP;V0^H2iP;V00=<
02OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H00@00000dU_JFmYKfU]2FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_K@mP<O02OfU_JFmYKfU_JFmYKfU_JF
mYKfC?JFmYKfU_JFmYKfU_JFmYKfU_H00]027`0XU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmP;@02TOmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfUP03d00E
UQnFmYKfU_JFmYKfU_JFmYKfU_JF009<017fU_JFmYKfU_JFmYKfU_JFmP04d00D7oJFmYKfU_JFmYKf
U_JFmYKfU_H3C00TmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JF0@00000LiP;V0^H2
i]3V0^H2iP;V0^H2iP;V0^H2iP;V0P9<01?V0^H2iP;V0^H2iP;V0^H2iP;V008O02_@iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2008O0]00:^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V7`?@02T2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V
0^H2iP;V0P04d00CiP;V0^H2iP;V0^H2iP;V0^H2iP02C00C0^H2iP;V0^H2iP;V0^H2iP;V0P05d00B
0^H2iP;V0^H2iP;V0^H2iP;V0d`04nH2iP;V0^H2iP;V0^H2iP;V0^H00Ql030;V0^H2iP;V0^H2iP40
0000;YKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_H37`0[mYKfd?JF
mYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmP027`04U_JFmP;@02^FmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmQofU_JF00;@02_fU_JFmYKfU_JFmYKfU_JFmYKfC?JF
mYKfU_JFmYKfU_JFmYKfU_HOmYKf00?@01;fU_JFmYKfU_JFmYKfU_JFmYH2C00FmYKfU_JFmYKfU_JF
mYKfU_JF7iKfUPC@017fU_JFmYKfU_JFmYKfU_JFmP03C00NmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JF
mYKfU_JF0@00000IiP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP02C00@0^H2iP;V0^H2iP;V0^H2iP<O
02cV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0P8O03GV0^H2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP03d00[iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP04d00@0^H2iP;V0^H2iP;V0^H2iP9<01P2iP;V
0^H2iP;V0^H2iP;V0Ql2iP;V0^H4d00@0^H2iP;V0^H2iP;V0^H2iP=<013V0^H2iP;V0^H2iP;V0^H2
0Ql02NH2iP;V0^H2iP01000002RFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
0al0;OJFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmP027`0;U_JFmYKf
U_JFmYH00]00;OJFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmP03d00/
mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYH3d00?U_JFmYKfU_JFmYKf
U_JF009<01[fU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfUPG@00jFmYKfU_JFmYKfU_JFmP=<01SfU_JF
mYKfU_JFmYKfU_HOmYKfU_JFmYH100000<KV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^HOiP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^HOiP;V0^H2
iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP82d00^iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0P;@02OV0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H00@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P4000001YKfU_JFmP;o00fFmYKfU_JFmYKfU_JF00?o00fFmYKfU_JFmYKfU_JF00Co
00cfU_JFmYKfU_JFmYH3o`0>U_JFmYKfU_JFmYKfU_H3o`0<mYKfU_JFmYKfU_JF0ol03YKfU_JFmYKf
U_JFmYKf0_l07YKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmP;o00fFmYKfU_JFmYKfU_JF00?o
00ZFmYKfU_JFmYKf0ol01?JFmYH2o`07mYKfU_JFmP03o`03mYKf00?o00OfU_JFmYKf00?o00?fU_H0
1?l01YKfU_JFmP?o00?fU_H00ol01oJFmYKfU_H00ol01?JFmYH3o`06U_JFmYKf0ol00oJFmP03o`07
mYKfU_JFmP03o`04mYKfUP;o00OfU_JFmYKf00?o00[fU_JFoiKfU_JF0@00003oiP;V0^KoiP;o0^H2
iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^Ko
iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^KoiP;o0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2
i_oV0_l2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2i_oV0^H2o`;VonH2iP;V0^KoiP;V0^KoiP;V0^H2
iP;VonH2iP;VonH2iP;V0^H2i_oV0^H2iP;VonH2iP;V0^KoiP;V0^H2o`;V0^H2iP;VonH2iP;V0^Ko
iP;V000PiP;V0^KoiP;o0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP81000004FFmYKfU_nFm_ofU_JFmYKf
U_JFmYKfooJFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYH01?l0COJF
mYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_nF
m_ofU_JFmYKfU_JFmYKf00?o04ofU_JFmYKfU_JFoiKfU_KomYKoU_JFmYKfU_nFmYKfU_nFmYKfU_JF
mYKoU_JFmYKfooJFmYKfU_JFoiKfU_JFmYKoU_JFmYKfU_nFmYKf00Co03>FmYKfU_JFoiKfU_JFmYKo
U_JFmYKfU_nFmYKfooJFoiKfU_JFmYKoU_JFmYKfooJFmYH00@00000fiP;V0^KoiP;o0^H2iP;V0^H2
iP;V0_l2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H20_l07NH2iP;V0^H2iP;V0^Koi_oV0^H2
iP;V0^H2iP;V00?o00gV0^H2iP;V0^H2iP;V00?o01kV0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2
iP82o`1AiP;V0^H2iP;V0^H2i_oV0_l2iP;V0^H2iP;VonH2iP;o0^KoiP;V0^H2i_oV0^H2i_oV0^H2
iP;V0^KoiP;V0^H2i_oV0^H2iP;VonH2iP;V00;o01d2iP;V0^H2i_oV0^H2o`;o0^H2iP;V0^KoiP;V
0P03o`0=0^H2iP;V0^KoiP;V0P03o`0D0^H2iP;V0^KoiP;V0^H2o`;V0^H100000?nFmYKfU_nFm_of
U_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKo
U_nFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKf
U_JFoiKfooJFmYKfU_JFmYKfU_nFm_ofU_JFmYKfU_JFoiKfU_KomYKoU_JFmYKfU_nFmYKfU_nFmYKf
U_JFmYKoU_JFm_ofU_nFmYKfU_JFoiKfU_JFmYKoU_JFmYKfU_nFmYKfooKomYKfU_JFmYKoU_JFm_of
U_JFmYH0022FmYKfU_nFm_ofU_JFmYKfU_JFmYKfooJFmYKfU_JFmP4000001^H2iP;V0P;o00gV0^H2
iP;V0^H2iP;V00;o00l2iP;V0^H2iP;V0^H2iP800_l03NH2iP;V0^H2iP;V0^H00ol03^H2iP;V0^H2
iP;V0^H20_l03NH2iP;V0^H2iP;V0^H01?l03@;V0^H2iP;V0^H2iP800ol030;V0^H2iP;V0^H2iPCo
00d2iP;V0^H2iP;V0^H200;o00kV0^H2iP;V0^H2iP;V0P;o00[V0^H2iP;V0^H20_l01NH2iP;V00;o
00L2iP;V0^H200;o00CV0^H20_l02>H2iP;V0^H20_l01NH2iP;V00;o00L2iP;V0^H200;o00CV0^H2
0ol01`;V0^H2iP800_l01NH2iP;V00;o00L2iP;V0^H200;o00CV0^H21?l01^H2iP;V0P;o00GV0^H2
iP03o`06iP;V0^H20_l01>H2iP84o`03iP;V00400000R9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`0@U_JFmYKf
U_JFmYKfU_JFmP;o08>FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2
iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000PIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP04o`08mYKfooJFmYH3o`04U_JFmP;o
08VFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;o0^H2o`;V0^H2o`;V0^KoiP;o0^H2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_KomYKfU_KomYKfU_nFm_ofU_JFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00002DiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0_l2iP;V0_l2iP;V0P;o08WV0^H2i_oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_nFmYKfooJFmYKfooJFmYKoU_KomYKfU_nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000PNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP04o`030^H200;o00?V0^H00_l01@;V0^H200;o00CV0^H20_l0PnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000001
\
\>"],
  ImageRangeCache->{{{0, 287}, {95.75, 0}} -> {-0.492138, -1.00003, 0.062663, 
  0.062663}},
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "With the same domain and codomain, we can also set up a map defined by \
sending the generator 5 in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_18\)]],
  " to the generator 1 in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  "."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(VisualizeMorphoid[ZMap[18, \ 3, \ 5\  \[Rule] \ 1], \ 
      ColorCodomain\  \[Rule] \ Automatic]; \)\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"BuiltIn"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33613 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.0560224 0.0560224 0.0560224 [
[ 0 0 0 0 ]
[ 1 .33613 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .33613 L
0 .33613 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[18])] .5 .30812 0 0 Mshowa
[(0)] .02381 .28011 0 0 Mshowa
[(1)] .07983 .28011 0 0 Mshowa
[(2)] .13585 .28011 0 0 Mshowa
[(3)] .19188 .28011 0 0 Mshowa
[(4)] .2479 .28011 0 0 Mshowa
[(5)] .30392 .28011 0 0 Mshowa
[(6)] .35994 .28011 0 0 Mshowa
[(7)] .41597 .28011 0 0 Mshowa
[(8)] .47199 .28011 0 0 Mshowa
[(9)] .52801 .28011 0 0 Mshowa
[(10)] .58403 .28011 0 0 Mshowa
[(11)] .64006 .28011 0 0 Mshowa
[(12)] .69608 .28011 0 0 Mshowa
[(13)] .7521 .28011 0 0 Mshowa
[(14)] .80812 .28011 0 0 Mshowa
[(15)] .86415 .28011 0 0 Mshowa
[(16)] .92017 .28011 0 0 Mshowa
[(17)] .97619 .28011 0 0 Mshowa
[(Z[3])] .5 .02801 0 0 Mshowa
[(0)] .02381 .05602 0 0 Mshowa
[(1)] .35994 .05602 0 0 Mshowa
[(2)] .69608 .05602 0 0 Mshowa
0 1 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .26331 m
.02381 .07283 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.07983 .26331 m
.69608 .07283 L
s
% Start of user PostScript
1. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.13585 .26331 m
.35994 .07283 L
s
% Start of user PostScript
2. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.19188 .26331 m
.02381 .07283 L
s
% Start of user PostScript
3. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.2479 .26331 m
.69608 .07283 L
s
% Start of user PostScript
4. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.30392 .26331 m
.35994 .07283 L
s
% Start of user PostScript
5. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.35994 .26331 m
.02381 .07283 L
s
% Start of user PostScript
6. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.41597 .26331 m
.69608 .07283 L
s
% Start of user PostScript
7. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.47199 .26331 m
.35994 .07283 L
s
% Start of user PostScript
8. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.52801 .26331 m
.02381 .07283 L
s
% Start of user PostScript
9. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.58403 .26331 m
.69608 .07283 L
s
% Start of user PostScript
10. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.64006 .26331 m
.35994 .07283 L
s
% Start of user PostScript
11. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.69608 .26331 m
.02381 .07283 L
s
% Start of user PostScript
12. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.7521 .26331 m
.69608 .07283 L
s
% Start of user PostScript
13. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.80812 .26331 m
.35994 .07283 L
s
% Start of user PostScript
14. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.86415 .26331 m
.02381 .07283 L
s
% Start of user PostScript
15. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.92017 .26331 m
.69608 .07283 L
s
% Start of user PostScript
16. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.97619 .26331 m
.35994 .07283 L
s
% Start of user PostScript
17. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[31]:=",
  ImageSize->{288, 96.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81000008^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;o00[fU_JFmYKfU_JF0_l0Q_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;o0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81000008BFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H4o`08U_JFoiKfU_H3o`2<mYKfU_KomYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKoiP;VonH2iP;V0^KoiP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKoU_JFmYKfU_nFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002A
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;o0^H2i_oV0^H2iP02o`2<0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_Kom_ofU_JFoiKfU_JFmYKoU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000Q>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0PCo00?V0^H00_l00`;V0P03o`040^H2iP;o08H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81000000JFmYKfU_H2o`1MU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00?o05fFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01?l0E_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^KoiP;o0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_nFm_ofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;VonH2
o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKoU_KomYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1000000KV0^H2iP82o`1MiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00;o05l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P02o`1GiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001iKfU_JFmYH04=00CoJFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H0
2T`0D9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf2Al0E_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000007
iP;V0^H2iP0@d01=0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP804d`0@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H201<O05@2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H1000000NFmYKfU_JF013@04_fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H05D`0@OJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf01DO05;fU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JF0@000006iP;V0^H24M00B@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP805d`0@@;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H201LO
0502iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP4000001YKfU_JFmQK@04>FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF01Q<047fU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP0H7`1?
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP01000000KV0^H2iP8@d003iP;@00;@00<2d=000]00?NH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H07D`0>nH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V01dO
04gV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP01000000JFmYKfU_H3d003m]3@00g@00?fU]000m000oK@d002d00g
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0LC003
mYKf00=<03GfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mP037`03mYKf01`O04^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000006iP;V0^H23m0010;V0^H3d003iP;V00?@
00?V0]001=00<@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP80
3T`00nI<C00;C007iTa<0^H2iP03C00_iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00al01>H2iP827`03iQlO00/O00?V7al031l0BP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@000005
U_JFmYH01M000iK@d00:d005mYKfU_H00]0019KfU_H4d003U_JF00C@02kfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF34`00oJFC00;C004mYKfUP=<00BFmYKf0d`0:OJF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00<O00CfU_JF0al019KfU_H<7`03
UQlO00/O04^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000005iP;V0^H01M000nK@d007d003iP;V00;@00D2iP;V
0P03d0050^H2iP800m0010;V0^H4d00[0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0P0;C0030^I<00a<00KV0^H2iP82C005iP;V0^H00d`08nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00<O00GV0^H2iP027`060^H2iP;V3Al00nHO7`0:7`1<0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP4000001IKfU_JF00K@00?fd=001]003IKfU_JFd9KfU_JFmYH00]001_JFmYKfUPC@00CfU_JF
1M009iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<UP0:C003mYKf00U<00_fU_I<
mYKfU_JFmP02C006U_JFmYKf14`06iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP047`06mYKfU_JF
0Ql02oJFmYKfU_HOmYKf00TO00?fUQl02Ql0CIHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF004000001NH2iP;V00K@
00<2d=001M001`;V0^H2iP800]001nH2iP;V0^H00m001nH2iP;V0^H00m001^H2iP;V0PC@02CV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP89C0030^H200Q<00GV0^H2iP02C0070^H2iP;V
0P03C0070^H2iP;V0P03C00E0^H2iP;V0^H2iP;V0^H2iP;V0^H200<O00L2iP;V0^H200<O00L2iP;V
0^H2008O00GV0^H2iP087`030^HO00TO04h2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000000FFmYKfUP06d003
mYK@00C@00ZFmYKfU_JFmYKf0]0029KfU_JFmYKf0m001oJFmYKfU_H01=001YKfU_JFmPG@01WfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKf009<00NFmYKfUTbF00I<00?fU_H01T`04iKfU_JFmYKfUTbFmYKf
U_JFmYH00T`02?JFmYKfU_JF0d`03iKfU_JFmYKfU_JFmYKfUP037`08U_JFmYKfU_H27`0CU_JFmYKf
U_JF7iKfU_JFmYKfUP067`03mYHO00HO00NF7iKfU_JF008O04SfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000000CV0^H2
1m000`;Vd002d00>iP;@0^H2iP;V0^H2iP82d009iP;V0^H2iP;V00;@00T2iP;V0^H2iP800m0020;V
0^H2iP;V1=007@;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H200M<00<2iP801D`02`;V0^H2iP;V
0^H2009<00WV0^H2iP;V0^H00T`02@;V0^H2iP;V0P03C0090^H2iP;V0^H200<O00T2iP;V0^H2iP80
0Ql02NH2iP;V0^H2iP027`0;0^H2iP;V0^H2iP801Al00`;V7`077`1@0^H2iP;V0^HOiP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H1000000BFmYKf2=007iKfd?JFmYK@U_JFmYKfU_JFmYKfd?JFmYKfU_JFmYH00m002IKfU_JFmYKf
UP04d008mYKfU_JFmYH4d00LmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfUPA<00CfU_JF0T`06_JF
C9KfU_JFmYKfU_JFmTcfU_JFmYKfU_JF0d`02IKfU_JFmYKfUP03C003U_JF00<O00VFmYKfU_JFmYH0
0al06YKfU_JFmYKfU_HOmYKfU_JFmYKfU_JF7iKf0Ql00iKfUP057`1CU_JFmYKfU_JFmYKf7oJFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@000004iP;V0PS@01GV0^H2iP;V0]02iP;V0^H2iP;V0^H00]002`;V0^H2iP;V0^H200?@
00X2iP;V0^H2iP;V0m002NH2iP;V0^H2iP05d00aiP;V0^H2iP;VC>H2iP;V0^H2iP;V0^I<iP9<0^H2
iTcV0^I<iP;V0^H2iP;V0^H2iP02C00;0^H2iP;V0^H2iP800T`02^H2iP;V0^H2iQl4C009iP;V0^H2
iP;V008O00/2iP;V0^H2iP;V0P027`0EiP;V0^H2iP;V0^H2iQoV0^HOiP;V008O05H2iQoV0^H2iP;V
0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP4000008iKfU_JFmYK@U_JFmYKfU_JFmYKfU]2FmYKfU_JFmYKfU_JF00;@
00cfU_JFmYKfU_JFmYH2d00;mYKfU_JFmYKfU_H01=002YKfU_JFmYKfU_H4d00lU_JFmTcfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf0T`019KfU_H37`05
mYKfU_H00d`01?JFmYH27`1lmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_HO
mYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP4000009NH2iP;V0^K@iP;V0^H2iP;V0^H2i]3V0^H2iP;V0^H2
iP;V0^H00]0030;V0^H2iP;V0^H2iP?@00cV0^H2iP;V0^H2iP83d00;0^H2iP;V0^H2iP801=00>^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP83C00<
7nH2iP;V0^H2iP;V0d`0Oal2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2
7`;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000fU_JFmYKfU]2FmYKfU_JFmYKfU_JFm]3fU_JFmYKf
U_JFmYKfU_JFd9KfU_JFmYKfU_JFmYKf0]003IKfU_JFmYKfU_JFmYH01=002?JFmYKfU_JF0T`00oK@
d003d00XmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfUP9<00WfU_JFmYKfU_H0
0al03OJFC4cfU_JFmYKfU_H00Ql00iKfC002C009mYKfU_JFmYKf008O02jFmYKfU_JFmYKfU_JFmYHO
U_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKf0Ql0@IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000:>H2iP;V0^K@iP;V0^H2
iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP82d00>iP;V0^H2iP;V0^H2iP83d00>0^H2iP;V0^H2iP;V
0^H3d00=iP;V0T`2iP;V0^H2iP04d00/0^H2iP9<0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V
0^I<iP;V0^H37`07iP;V0^H2iP02C0050^H2iP800Ql01nH2iP;V0^H00d`0NNH2iP;V7nH2iP;V0^H2
iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000ZU_JFmYKf
U]2FmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf0]003iKfU_JFmYKfU_JFmYKfUP03d00>
U_JFmYKfU_JFmYKfU_H4d00=U_JFmYKfU_JFmYKfUP04d00SC9KfU_JFmYKfU_JFmYKfU_I<mYKfU_JF
mYKfU_JFmYKfU_H00T`37`0<mYKfU_JFmYKfU_JF0d`27`0<U_JFmYKfU_JFmYKf14`0MAofU_JFmYKf
U_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000002cV0^H2
iP;Vd>H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0P;@013V0^H2iP;V0^H2iP;V0^H2
0]004>H2iP;V0^H2iP;V0^H2C083d00>0^H2iP;V0^H2iP;V0^H5d00LiP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0P<O0102C0;V0^H2iP;V0^H2iP;V0Ql04`9<C>H2iP;V0^H2iP;V0^H27`800d`0LP;V
0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000@9Kf
U_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_H3d00@mYKfU_JFmYKfUTbFmYKfUPC@00ofU_JFmYKfU_JFC9KfU_H01=005IKfU_JFmYKfU_I<mYKf
U_JFmYKfUP037`05U_JFmYH00T`02_JFmYKfU_JFmYH27`05mYKfU_H00T`02YKfU_JFmYKfU_H27`05
U_JFmYH00d`0KiKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYHO
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP01000002oV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP02d00B
0^H2iP;V0^H2iP;V0^H2iP;V0m004NH2iP;V0T`2iP;V0^H2iP;V00?@013V0^H2iP9<0^H2iP;V0^H2
1M003@;V0^H2C0;V0^H2iP800al04@;V0^H2iP;V0^I<iP;V0^H200<O00T2iP;V0^H2iP800d`04@;V
0^H2iQoV0^H2iP;V0^H200=<06`2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V
0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H10000036FmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf
U_JF00;@01?fU_JFmYKfU_JFmYKfU_JFmYKf00;@01:FmTa<U_JFmYKfU_JFmYKfU_H4d00AU_I<mYKf
U_JFmYKfU_JFmYH01=001_JFC9KfUP<O00jFmYKfU_JFmYKfU_JFmP9<01>FmQlOU_JFmYKfU_JFmYKf
U_JF009<01;fUQlOmYKfU_JFmYKfU_JFmYH3C00]U_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKf
U_JFmYKfU_JFmYKfU_JF008O03[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JF0@00000ciP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00;@01<2iP;V0^H2iP;V0^H2iP;V0^H200?@01<2iP;V0^H2iP;V0^H2iP;V
0^H200?@0182iP;V0^H2iP;V0^H2iP;V0^H4d08O02P2iP;V0^H2iP;V0^H2iP;V0^H2C1oV0^H2iP;V
0^H2iP;V0^H2iP;V0T`04`;V0^H2iP;V0^H2iP;V0^H2iP8014`0INH2iP;V0^H2iP;V0^H2iP;V0^H2
7`;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000BiKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFd9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmTcfUP02d00DmYKfU_JFmYKfU_JF
mYKfU_JFmT`4d00=mYKfU_JFmYKfU_JFmP037`03mTc@00C@00fFmYKfU_JFmYKfU_JF00<O01BFC4cf
U_JFmYKfU_JFmYKfU_JFmP8O01RFC4a<U_JFmYKfU_JFmYKfU_JFmYKf7oH3C01RmYKfU_JFmYKfU_JF
mYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000003KV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82d00EiP;V0^H2iP;V0^H2iP;VC>H2iP;V00?@01GV0^H2
iP;V0^H2iP;V0^I<iP;V0^H00m001nH2iP;V0^H00al02^H2iP9<0^H2iP84d007iP;V0^H2iP027`0M
0^H2iP;VC>H2iP;V0^H2iP;V0^H2iQoV0^H2iP800T`05NH2iP;V0^H2iP;V0^H2iP8O0^H2iP03C01O
iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000hU_JFmYKfU]2FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2d00FU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmP?@01GfU_JFmYKfU_JFmYI<U_JFmYKfU_H00m005OHO7aofU_JFmYKfUTbFmYKfU_JFmP04d00T
UQlOmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_HOmYKfU_JFmYKf0T`05YKfU_JFmYKfU_JFmYHOU_JFmYKf
U_H3C01LmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000005?V0^H2iP;Vd>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP02d00D0^H2iP;V0^H2iTcV0^H2iP;V0^H27`C@01<2iP;V0^H2iP9<0^H2iP;V0^H2008O
1M0020;V0^H2iP;V0T`02@;V0^H2iP;V0P027`0<iP;V0^H2iP;V0^H20d`05P;V0^H2iP;V0Ql2iP;V
0^H2iP;V0^H3C01IiP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000kU_JFmYKfU]2FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00]006?JFmYKfU_I<
mYKfU_JFmYKfU_JFmYKfUP?@00fFmYKfU_I<mYKfU_JF00@O00KfU_JFmYH3d00>U_JFmYKfC?JFmYKf
U_H27`07U_JFmYKfUP04d00PmYKfU_JFC9KfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYH2C00GmYKfU_JF
mQofU_JFmYKfU_JFmYKfU_H014`0EIKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00000miP;V0^H2
i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02d003
0^H2009<01CV0^H2iP;V0^H2iP;V0^H2iP;V0P;@00SV0^H2C0;V0P<O00d2iP;V0^H2iP;V0^H200C@
00SV0^I<iP;V0P8O00gV0^H2iP;V0^H2iP;V00C@00<2iP800T`00nH2iP027`0D0^H2iP;V0^H2iP;V
0^H2iP;V0^H2C00I0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0P03C00N0^H27`;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0Ql0<P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@00000oU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00;@01U<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00?@00?fC1l00Ql059Kf
U_JFmYKfU_JFmYKfU_JFmYKf0m000dbF7`027`0CU_JFmYKfU_JFmYKfU_JFmYKfUP05d00KC?HOmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00=<01VF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00=<04lOmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00400000GNH2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<d>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`03d00I
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP04d00I0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P04d00J
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C00JiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP83C01<
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP400000@YKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]3f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmP;@01FFmYKfU_JFmYKfU_JFmYKfU_JFmYH00al019I<
U_H2d00EU_JFmYKfU_JFmYKfU_JFmYKfU_JF008O00CfC?JF0m006YKfU_JFmYKfU_JFmYKfU_JFmYKf
UQnFmYI<1M005oJFmYKfU_JFmYKfU_JFmYKfU_JFmQof009<01^FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF7iH00d`0BIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000014iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP82d00?iP;V0^H2iP;V0^H2iP;V00@O
00T2iP;VC>H2iP800m003`;V0^H2iP;V0^H2iP;V0P037`090^H2iTcV0^H200C@00oV0^H2iP;V0^H2
iP;V0^H00Ql01@;V0^H2009<00?V0^H01=005@;V0^H2iP;V0^H2iP;V0^HOiP;V0P03C00K0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iQoV0^H200A<04GV0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000016U_JFmYKfU]2FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmP;@00ZFmYKf
U_JFmYKf0al04?JFmYKfU_JFC9KfU_JFmYH3d00:U_JFmYKfU_JFmP8O012FmYKfU_JFmTcfU_JFmYKf
0m007?JFmYKfU_JFmYKf7oJFmYKfU_JFmTcfU_JFmYH4d00DmYKfU_JFmYKfU_HOmYKfU_JFmYH2C00M
mYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_H00d`0@_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000>nH2iP;V0^K@iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V009<0182iP;V0^H2iP;V
0]02iP;V0^H37`0FiP;V0^H2iP;V0T`2iP;V0^H2iP;V0P;@00KV0^H2iP827`0EiP;V0^H2iP;V0T`2
iP;V0^H2iP;V00C@00D2iP;V0P027`0;iP;V0^H2iP;V0^H00T`020;V0^H2iP;V1M004NH2iP;V0Ql2
iP;V0^H2iP;V009<01h2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H3C00BiP;V0^H2iP;V0^H2
iP;V0^H20Ql0:nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000019
U_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfUP02d00OmQlO7oJFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmP03d0<O01^FmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYH00m007YHOU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmPC@
00nF7iKfU_JFmYKfU_JFmYH00d`07YKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmP=<03cfU_JF
mYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH10000
04WV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V008O0]007P;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP8O0]007`;V
0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP801=007^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0PC@00kV0^H2iP;V0^H2iP;V0P9<01oV0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V00=<
03WV0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@000015U_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JF00@O00CfU_JF0]006_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JF0Ql01?JF
mYH3d00JU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_H27`04U_JFmP?@00cfU_JFmYKfU_JFmYH2C00A
mYKfU_JFmYKfU_JFmQofU_H01M002oJFmYKfU_JFmYKf009<022FmYKfU_JFmYKfU_HOmYKfU_JFmYKf
U_JFmYKfU_JFmPA<03FFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000004;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;@0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP837`0Q0^H2iP;V0^H2i]3V0^H2iP;V0^H2iTcV0^H2iP;V0^H200<O
00T2iP;V0^H2iP800m0080;V0^H2iP;V0^I<iP;V0^H2iP;V0^HOiP;V0^H2iP;V1=0080;V0^H2iP;V
0^I<iP;V0^H2iP;V0^HOiP;V0^H2iP;V1=002@;V0^H2iP;V0P03C00Q0^H2iP;V0^H2iQoV0^H2iP;V
0^H2iP;V0^H2iP;V0^H200=<0382iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000?iKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@
U_JFmYKfU_JFmTcfU_JFmYKfUP037`0>U_JFmYKfU_JFmYKfU_H2d00BU_JFmYKfU_JFC9KfU_JFmYKf
0Ql03iKfU_JFmYKfU_JFmYKfUP02d00BmYKfU_JFmYI<U_JFmYKfU_JF0Ql03_JFmYKfU_JFmYKfU_JF
0m0029KfU_JFmYKf0T`05iKfU_JFmYKfUQnFmYKfU_JFmYKfU_JF00C@00SfU_JFmYKfUP9<02;fU_JF
mYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0d`0;iKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000=>H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2d0;V0^H2iP82C006iP;V0^H20al04`;V0^H2iP;V0^H2iP;V0^H2iP800]003^H2
iP;V0^I<iP;V0^H20Ql04nH2iP;V0^H2iP;V0^H2iP;V0^H00m008^H2iP;V0T`2iP;V0^H27`;V0^H2
iP;V0^H2iP;V0^H2iP84d00QiP;V0^H2C0;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V00G@00GV0^H2
iP02C00S0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800d`01P;V0^H2iP8O02@2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000003VFmYKfU_JFd9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYI<U_JFmYH00al069KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP;@00VFmYKfC?JFmYH00al069KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP?@00WfU_I<mYKfU_H0
0Ql069KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP?@00CfU_JF0T`07OJFmYKf7oJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf00C@00>FmYH00d`08iKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00=<
02VFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000003GV0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0T`2iP047`0T0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;@0^H2C0;V0Ql07P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;@
02@2iTcV0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H4d00S0^I<iP;V7nH2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP801M009`9<C>H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0P04C00UiP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000003:FmYKfU_JFd9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FC0<O02;fU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JF0]009_I<7aofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
0m009IHO7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00m02C00SUQnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH01=009d`OmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmP03C00R7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000FNH2iP;V0^K@
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7m0OiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8O00;@02L2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP800]009^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H21=009NH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H01=009P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0d`07nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000/U_JFmYKf
U]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H37`0WC=3fU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKf008O00>FC9H00]008oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf008O00>FC=000]009oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnF
C003d00VmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iH5d00TU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHO0d`07?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH10000
02WV0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP037`0XiTa<0^K@iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P8O037V0^I<iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iQoV0^I<iP;V00?@02OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HO
iP;VC>H01=0090;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP9<00<2d=000]008>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20Ql07NI<C4cV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V004000009IKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH011l0:?JFmTcfU_JF
m]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH37`0:U_JFmYI<U_JFmP;@02ZFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_I<mYKfU_H2d00YU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf7oJFmYKfC?JFmYH00m008iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JF00=<
00>Fm]000m008YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_H4C00EU_JFmYKfU_JFmYKf
U_JFmYKfU_JF004000008^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP837`0Z0^H2iP;V
C>H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql03`;V0^H2iP9<0^H2iP;V0P02d00J
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP827`0>iP;V0^H2C0;V0^H2iP83d00R0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H27`;V0^H2iP9<00D2iP;V0P04d00RiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8O0^H2iP;V0P9<00CV0^H21M008@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0P03C00B
0^H2iP;V0^H2iP;V0^H2iP;V0@00000OU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP037`0[
U_JFmYKfU_I<mYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP027`0CmYKfU_JFmYKfC?JF
mYKfU_JFmP02d00[U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFC9KfU_JFmYKfUP02d00[
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfUTbFmYKfU_JFmP03d00QmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_HOmYKfU_JFmYKf009<00NFmYKfU_JF00C@023fU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mQofU_JFmYKfUP=<00nFmYKfU_JFmYKfU_JFmYH00@00000LiP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2
iP;V0P<O02/2iP;V0^H2iP;VC>H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H200<O02`2iP;V
0^H2iP;V0T`2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP8O01H2iP;V0^H2iP;V0T`2iP;V
0^H2iP;V0m008>H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H20T`02NH2iP;V0^H2iP04d00O
0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0P03C0080^H2iP;V0^H4d00O0^H2iP;V0^H2iP;V
0^H2iP;V0^HOiP;V0^H2iP;V0P03C00<0^H2iP;V0^H2iP;V0@00000IU_JFmYKfU]2FmYKfU_JFmYKf
U_JFmYKfUP037`0/U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_H27`0K
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JF00;@02gfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JF
mYKfC?JFmYKfU_JFmYKfU_H00m00;?JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_I<mYKfU_JF
mYKfU_JF0m007iKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYH00T`02_JFmYKfU_JFmYH5d00M
U_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYH00d`02IKfU_JFmYKfUP01000001OV0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iP027`2]0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V
0^H2iQoV0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V
0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^I<iP;V
0^H2iP;V0^H2iP800]00;^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP82d00NiP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H20T`01nH2iP;V0^H00@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P4000001YKfU_JFmP;o00fFmYKf
U_JFmYKfU_JF00?o00fFmYKfU_JFmYKfU_JF00Co00cfU_JFmYKfU_JFmYH3o`0>U_JFmYKfU_JFmYKf
U_H3o`0<mYKfU_JFmYKfU_JF0ol03YKfU_JFmYKfU_JFmYKf0_l07YKfU_JFmYKfU_JFmYKfooJFmYKf
U_JFmYKfU_JFmP;o00fFmYKfU_JFmYKfU_JF00?o00ZFmYKfU_JFmYKf0ol01?JFmYH2o`07mYKfU_JF
mP03o`03mYKf00?o00OfU_JFmYKf00?o00?fU_H01?l01YKfU_JFmP?o00?fU_H00ol01oJFmYKfU_H0
0ol01?JFmYH3o`06U_JFmYKf0ol00oJFmP03o`07mYKfU_JFmP03o`04mYKfUP;o00OfU_JFmYKf00?o
00[fU_JFoiKfU_JF0@00003oiP;V0^KoiP;o0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;o0^H2
iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^Ko
iP;o0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2
i_oV0^H2o`;VonH2iP;V0^KoiP;V0^KoiP;V0^H2iP;VonH2iP;VonH2iP;V0^H2i_oV0^H2iP;VonH2
iP;V0^KoiP;V0^H2o`;V0^H2iP;VonH2iP;V0^KoiP;V000PiP;V0^KoiP;o0^H2iP;V0^H2iP;V0_l2
iP;V0^H2iP81000004FFmYKfU_nFm_ofU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKoU_JFmYKf
U_JFmYKfU_JFm_ofU_JFmYKfU_JFmYH01?l0COJFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKoU_Ko
mYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_nFm_ofU_JFmYKfU_JFmYKf00?o04ofU_JFmYKfU_JF
oiKfU_KomYKoU_JFmYKfU_nFmYKfU_nFmYKfU_JFmYKoU_JFmYKfooJFmYKfU_JFoiKfU_JFmYKoU_JF
mYKfU_nFmYKf00Co03>FmYKfU_JFoiKfU_JFmYKoU_JFmYKfU_nFmYKfooJFoiKfU_JFmYKoU_JFmYKf
ooJFmYH00@00000fiP;V0^KoiP;o0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2
iP;V0^H20_l07NH2iP;V0^H2iP;V0^Koi_oV0^H2iP;V0^H2iP;V00?o00gV0^H2iP;V0^H2iP;V00?o
01kV0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP82o`1AiP;V0^H2iP;V0^H2i_oV0_l2iP;V0^H2
iP;VonH2iP;o0^KoiP;V0^H2i_oV0^H2i_oV0^H2iP;V0^KoiP;V0^H2i_oV0^H2iP;VonH2iP;V00;o
01d2iP;V0^H2i_oV0^H2o`;o0^H2iP;V0^KoiP;V0P03o`0=0^H2iP;V0^KoiP;V0P03o`0D0^H2iP;V
0^KoiP;V0^H2o`;V0^H100000?nFmYKfU_nFm_ofU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFoiKf
ooJFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKoU_nFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKf
U_nFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKfU_nFm_ofU_JFmYKf
U_JFoiKfU_KomYKoU_JFmYKfU_nFmYKfU_nFmYKfU_JFmYKoU_JFm_ofU_nFmYKfU_JFoiKfU_JFmYKo
U_JFmYKfU_nFmYKfooKomYKfU_JFmYKoU_JFm_ofU_JFmYH0022FmYKfU_nFm_ofU_JFmYKfU_JFmYKf
ooJFmYKfU_JFmP4000001^H2iP;V0P;o00gV0^H2iP;V0^H2iP;V00;o00l2iP;V0^H2iP;V0^H2iP80
0_l03NH2iP;V0^H2iP;V0^H00ol03^H2iP;V0^H2iP;V0^H20_l03NH2iP;V0^H2iP;V0^H01?l03@;V
0^H2iP;V0^H2iP800ol030;V0^H2iP;V0^H2iPCo00d2iP;V0^H2iP;V0^H200;o00kV0^H2iP;V0^H2
iP;V0P;o00[V0^H2iP;V0^H20_l01NH2iP;V00;o00L2iP;V0^H200;o00CV0^H20_l02>H2iP;V0^H2
0_l01NH2iP;V00;o00L2iP;V0^H200;o00CV0^H20ol01`;V0^H2iP800_l01NH2iP;V00;o00L2iP;V
0^H200;o00CV0^H21?l01^H2iP;V0P;o00GV0^H2iP03o`06iP;V0^H20_l01>H2iP84o`03iP;V0040
0000R9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H2o`0@U_JFmYKfU_JFmYKfU_JFmP;o08>FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP010000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000PIKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP04o`08mYKfooJFmYH3o`04U_JFmP;o08VFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2o`;o0^H2o`;V0^H2o`;V0^KoiP;o0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_KomYKfU_KomYKfU_KomYKfU_nFm_ofU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002DiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko
iP;V0_l2iP;V0_l2iP;V0P;o08WV0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_nFmYKf
ooJFmYKfooJFmYKoU_KomYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000PNH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP04o`030^H200;o
00?V0^H00_l01@;V0^H200;o00CV0^H20_l0PnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {95.75, 0}} -> {-0.492138, -1.00003, 0.062663, 
  0.062663}},
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "Given any morphism ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\  : \ G\), " ", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], " ", "H"}], TraditionalForm]]],
  " between groups (or rings), there are two natural morphisms induced from ",
  
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". The first is ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(g\  : \ G\), " ", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], " ", \(G/\(Ker(f)\)\)}], 
        TraditionalForm]]],
  " defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \  \[RightTeeArrow] \ x\ \(Ker(f)\)\)]],
  " and the second is ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(h\  : \ G/\(Ker(f)\)\), " ", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], " ", \(Im(f)\)}], TraditionalForm]]],
  " defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(Ker(f)\)\  \[RightTeeArrow] \ f(x)\)]],
  ". What follows is a typical diagram to illustrate the relations between \
these morphisms."
}], "Text",
  CellTags->{"BuiltIn", "i:12"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
      Graphics[{Text["\<G\>", {0, 0}], \ Text["\<H\>", {5, 0}], \ 
          Text["\<G/Ker(f)\>", {2.5, \(-3.5\)}], \ RGBColor[0, 0, 1], 
          Arrow[{ .25, \ 0}, \ {4.75, 0}], \ 
          Arrow[{ .15, \(- .15\)}, {2.35, \ \(-3.35\)}], \ 
          Arrow[{2.65, \ \(-3.35\)}, {4.85, \ \(- .15\)}], \ 
          Text["\<f\>", {2.5, \  .15}], \ Text["\<g\>", {1.1, \(-1.75\)}], \ 
          Text["\<h\>", {3.9, \ \(-1.75\)}]}]]; \)\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"BuiltIn"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .73 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.684048 0.190476 [
[ 0 0 0 0 ]
[ 1 .73 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .73 L
0 .73 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
[(G)] .02381 .68405 0 0 Mshowa
[(H)] .97619 .68405 0 0 Mshowa
[(G/Ker\\(f\\))] .5 .01738 0 0 Mshowa
0 0 1 r
.5 Mabswid
[ ] 0 setdash
.07143 .68405 m
.92857 .68405 L
s
% Start of user PostScript
0.25 0 4.75 0 MAarrowhead1
% End of user PostScript
.05238 .65548 m
.47143 .04595 L
s
% Start of user PostScript
0.15 -0.15 2.35 -3.35 MAarrowhead1
% End of user PostScript
.52857 .04595 m
.94762 .65548 L
s
% Start of user PostScript
2.65 -3.35 4.85 -0.15 MAarrowhead1
% End of user PostScript
[(f)] .5 .71262 0 0 Mshowa
[(g)] .23333 .35071 0 0 Mshowa
[(h)] .76667 .35071 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 210.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000dPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@0009P000?o000020000ol0001j0000
OP000ol0000F0003o`0000X000?o0000N@0007P01?l20003o`0000800_l20004o`0000Co00<0ool0
0_l30003o`0000801?l40003o`0007T0001g0005o`000?l00`000ol000020003o`3o00<000?o0000
10000ol000030003o`0000<000?o000010000ol0001i0000M`000ol0o`02o`<000?o00000P03o`<0
1Ol20003o`0000<000?o00000`000ol000040003o`0007T0001g0003o`0000H000Co00000_l40005
o`000?l00P02o`@000?o00000`000ol000040003o`0007T0001g0005o`000?l010001ol0003o0?l0
1003o`800_l00`3oo`020003o`0000801?l40003o`0007T0001h00Co1@001Ol0ool000;o40000ol0
00020003o`0000<000?o0000NP00084000?o00006@03oh00003o0240003o0240003o02400026009<
3`000d`000260000Q@03C0l000=<0000QP0008@00d`A0003C00008D0002300A<4P000d`000240000
PP05C18000=<0000Q00008401D`D0003C00008<0002000I<5@000d`000220000O`07C1D000=<0000
PP0007h01d`G0003C0000840001m00Q<60000d`000200000O009C1T000=<0000O`0007h01T`J0003
C00007l0001o00E<6`000d`0001n0000OP000d`00003C1`000=<0000O@0007h000E<0000C00M0003
C00007d0001m0003C000024000=<0000O00007`000=<00008`000d`0001k0000O0000d`0000S0003
C00007/0001k0003C00002D000=<0000NP0007X000=<00009`000d`0001i0000NP000d`0000W0003
C00007T0001i0003C00002T000=<0000N00007P000=<0000:`000d`0001g0000N0000d`0000[0003
C00007L0001g0003C00002d000=<0000MP0007H000=<0000;`000d`0001e0000MP000d`0000_0003
C00007D0001e0003C000034000=<0000M00007@000=<0000<`000d`0001c0000L`000d`0000e0003
C0000780001c0003C00003D000=<0000LP00078000=<0000=`000d`0001a0000L@000d`0000i0003
C0000700001a0003C00003T000=<0000L000070000=<0000>`000d`0001_0000K`000d`0000m0003
C00006h0001_0003C00003d000=<0000KP0006h000=<0000?`000d`0001]0000K@000d`000110003
C00006`0001]0003C000044000=<0000K00006`000=<0000@`000d`0001[0000J`000d`000150003
C00006X0001[0003C00004D000=<0000JP0006X000=<0000A`000d`0001Y0000J@000d`000190003
C00006P0001X0003C00004/000=<0000I`0006P000=<0000B`000d`0001W0000I`000d`0001=0003
C00006H0001V0003C00004l000=<0000I@0006H000=<0000C`000d`0001U0000I@000d`0001A0003
C00006@0001T0003C00005<000=<0000H`0006@000=<0000D`000d`0001S0000H`000d`0001E0003
C0000680001R0003C00005L000=<0000H@00068000=<0000E`000d`0001Q0000H@000d`0001I0003
C0000600001P0003C00005/000=<0000G`00060000=<0000F`000d`0001O0000G`000d`0001M0003
C00005h0001N0003C00005l000=<0000G@0005h000=<0000G`000d`0001M0000G@000d`0001Q0003
C00005`0001L0003C00006<000=<0000F`0005/000=<0000I@000d`0001J0000F`000d`0001U0003
C00005X0001J0003C00006L000=<0000F@0005T000=<0000J@000d`0001H0000F@000d`0001Y0003
C00005P0001H0003C00006/000=<0000E`0005L000=<0000K@000d`0001F0000E`000d`0001]0003
C00005H0001F0003C00006l000=<0000E@0005D000=<0000L@000d`0001D0000E@000d`0001a0003
C00005@0001D0003C00007<000=<0000D`0005<000=<0000M@000d`0001B0000D`000d`0001e0003
C0000580001B0003C00007L000=<0000D@00054000=<0000N@000d`0001@0000D0000d`0001k0003
C00004l0001@0003C00007/000=<0000C`0004l000=<0000O@000d`0001>0000CP000d`0001o0003
C00004d0001200=<2@000d`0001o0003C00004d000150003C00000D000=<0000P@000d`0001<0000
@P04C0H000=<0000P`000d`00004009<00<0C4`0@P00044000E<0000C0060003C00008<000=<0000
100014`004a30000@@001D`0001<00D000=<0000Q@000d`000030004C000C4<000110005C00004`0
10000d`000270003C000008000A<001<@`0004801D`30003C00008L000=<00000P04C4<000190003
C00008T000E<0000C0160000B0000d`0002;0004C01<C4H000180003C00008/000=<0000A`0004L0
00=<0000S@000d`000160000AP000d`0002?0003C00004D000160003C00008l000=<0000A@0004D0
00=<0000T@000d`000140000A0000d`0002C0003C00004<000130003C00009D000=<0000@P0004<0
00=<0000U@000d`000120000@P000d`0002G0003C000044000110003C00009T000=<0000@0000440
00=<0000V@000d`000100000@0000d`0002K0003C00003l0000o0003C00009d000=<0000?P0003l0
00=<0000W@000d`0000n0000?P000d`0002O0003C00003d0000m0003C0000:4000=<0000?00003d0
00=<0000X@000d`0000l0000?0000d`0002S0003C00003/0000k0003C0000:D000=<0000>P0003/0
00=<0000Y@000d`0000j0000>P000d`0002W0003C00003T0000i0003C0000:T000=<0000>00003P0
00=<0000Z`000d`0000g0000>0000d`0002[0003C00003L0000g0003C0000:d000=<0000=P0003H0
00=<0000[`000d`0000e0000=P000d`0002_0003C00003D0000e0003C0000;4000=<0000=00003@0
00=<0000/`000d`0000c0000=0000d`0002c0003C00003<0000c0003C0000;D000=<0000<P000380
00=<0000]`000d`0000a0000<P000d`0002g0003C0000340000a0003C0000;T000=<0000<0000300
00=<0000^`000d`0000_0000<0000d`0002k0003C00002l0000_0003C0000;d000=<0000;P0002h0
00=<0000_`000d`0000]0000;P000d`0002o0003C00002d0000]0003C0000<4000=<0000;00002`0
00=<0000``000d`0000[0000:`000d`000350003C00002X0000[0003C0000<D000=<0000:P0002X0
00=<0000a`000d`0000Y0000:@000d`000390003C00002P0000Y0003C0000<T000=<0000:00002P0
00=<0000b`000d`0000W00009`000d`0003=0003C00002H0000W0003C0000<d000=<00009P0002H0
00=<0000c`000d`0000U00009@000d`0003A0003C00002@0000U0003C0000=4000=<0000900002@0
00=<0000d`000d`0000S00008`000d`0003E0003C0000280000S0003C0000=D000=<00008P000280
00=<0000e`000d`0000Q00008@000d`0003I0003C0000200000P0003C0000=/000=<00007`000200
00=<0000f`000d`0000O00007`000d`0003M0003C00001h0000N0003C0000=l000=<00007@0001h0
00=<0000g`000d`0000M00007@000d`0003Q0003C00001`0000L0003C0000><000=<00006`0001`0
00=<0000h`000d`0000K00006`000d`0003U0003C00001X0000J0003C0000>L000=<00006@0001X0
00=<0000i`000d`0000I00006@000d`0003Y0004C000009<5@0001P000=<0000j`000d`0C002C1D0
000H0003C0000>/01T`D00005`000d`0003[00M<500001H000=<0000j`08C1@0000F0003C0000>d0
1d`C00005@000d`0003_00I<4`0001@000=<0000l@05C1<0000C0003C0000?<01D`B00004`000d`0
003d00A<4P00018000=<0000mP03C180000A0003C0000?P00d`A00004@000d`0003i009<4@000100
00=<0000n`000d`0000?00003`000d`0003m0003C00000h0003o0240003o0240003o0240003o0240
003k00A<8@0000D01?ob00U<4002o`800_l6000010001Ol0003o0?803T`<0004o`00o`L000040003
o`3o00;o2`3gC0X000Co003o1`0000@000?o0000m00=C0d01?l7000010001Ol0003o0?802D`A0004
o`00o`L0000500ColP06C1<00_l200;o1P000?/00T`S0000o`0Q0000o`0Q0000S@04C8l0002>0003
C00008l0002>0003C00008l0002>0003C00008l0002=00A<S`0008h000=<0000S`0008h00db?0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {209.188, 0}} -> {-0.129073, -3.59127, 
  0.0183211, 0.0183211}},
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InducedCanonical",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["given",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], " ", "morphism", " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["f",
                        SingleLetterItalics->False], " ", 
                      StyleBox[":",
                        SingleLetterItalics->False], " ", 
                      StyleBox["G",
                        SingleLetterItalics->False]}], " ", 
                    StyleBox["\[Rule]",
                      "MR",
                      SingleLetterItalics->False], " ", 
                    StyleBox["H",
                      SingleLetterItalics->False]}],
                  "TraditionalForm"],
                FontSlant->"Italic"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["induced",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[
                  RowBox[{" ", 
                    StyleBox[" ",
                      "Text",
                      FontSlant->"Italic"]}]], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      RowBox[{
                        StyleBox["g",
                          SingleLetterItalics->False], " ", 
                        StyleBox[":",
                          SingleLetterItalics->False], " ", 
                        StyleBox["G",
                          SingleLetterItalics->False]}], " ", 
                      StyleBox["\[Rule]",
                        "MR",
                        SingleLetterItalics->False], " ", 
                      RowBox[{
                        StyleBox["G",
                          SingleLetterItalics->False], 
                        StyleBox["/",
                          SingleLetterItalics->False], 
                        RowBox[{
                          StyleBox["Kernel",
                            "MR",
                            SingleLetterItalics->False], "[", 
                          StyleBox["f",
                            SingleLetterItalics->False], "]"}]}]}],
                    "TraditionalForm"],
                  "Text",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["InducedIsomorphism",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["given",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], " ", "morphism", " ", 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        RowBox[{
                          StyleBox["f",
                            SingleLetterItalics->False], " ", 
                          StyleBox[":",
                            SingleLetterItalics->False], " ", 
                          StyleBox["G",
                            SingleLetterItalics->False]}], " ", 
                        StyleBox["\[Rule]",
                          "MR",
                          SingleLetterItalics->False], " ", 
                        StyleBox["H",
                          SingleLetterItalics->False]}],
                      "TraditionalForm"],
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(return\ the\ induced\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["Morphoid",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      RowBox[{
                        StyleBox["h",
                          SingleLetterItalics->False], " ", 
                        StyleBox[":",
                          SingleLetterItalics->False], " ", 
                        RowBox[{
                          StyleBox["G",
                            SingleLetterItalics->False], 
                          StyleBox["/",
                            SingleLetterItalics->False], 
                          RowBox[{
                            StyleBox["Kernel",
                              "MR",
                              SingleLetterItalics->False], "[", 
                            StyleBox["f",
                              SingleLetterItalics->False], "]"}]}]}], " ", 
                      StyleBox["\[Rule]",
                        "MR",
                        SingleLetterItalics->False], " ", 
                      RowBox[{
                        StyleBox["Image",
                          "MR",
                          SingleLetterItalics->False], "[", "f", "]"}]}],
                    "TraditionalForm"],
                  "Text",
                  FontSlant->"Italic"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.37, 0.63}},
  CellTags->{"BuiltIn", "i:11"}],

Cell[TextData[{
  "Induced ",
  StyleBox["Morphoids",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"BuiltIn"],

Cell[TextData[{
  "Here is the induced canonical homomorphism based on ",
  StyleBox["ZMap[18, 6]", "MR"],
  "."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f3\  = \ InducedCanonical[ZMap[18, 6]]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \(QuotientGroup::"NS" \( : \ \) 
      "This quotient group uses NS to represent the normal subgroup \!\({0, \
6, 12}\) that you specified. Use CosetToList to convert this coset \
representation to a list of elements."\)], "Message",
  CellTags->"BuiltIn"],

Cell[BoxData[
    RowBox[{"Morphoid", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"0", "\[Rule]", 
              TagBox["NS",
                HoldForm]}], ",", 
            RowBox[{"1", "\[Rule]", 
              TagBox[\(1 + NS\),
                HoldForm]}], ",", 
            RowBox[{"2", "\[Rule]", 
              TagBox[\(2 + NS\),
                HoldForm]}], ",", 
            RowBox[{"3", "\[Rule]", 
              TagBox[\(3 + NS\),
                HoldForm]}], ",", 
            RowBox[{"4", "\[Rule]", 
              TagBox[\(4 + NS\),
                HoldForm]}], ",", 
            RowBox[{"5", "\[Rule]", 
              TagBox[\(5 + NS\),
                HoldForm]}], ",", 
            RowBox[{"6", "\[Rule]", 
              TagBox["NS",
                HoldForm]}], ",", 
            RowBox[{"7", "\[Rule]", 
              TagBox[\(1 + NS\),
                HoldForm]}], ",", 
            RowBox[{"8", "\[Rule]", 
              TagBox[\(2 + NS\),
                HoldForm]}], ",", 
            RowBox[{"9", "\[Rule]", 
              TagBox[\(3 + NS\),
                HoldForm]}], ",", 
            RowBox[{"10", "\[Rule]", 
              TagBox[\(4 + NS\),
                HoldForm]}], ",", 
            RowBox[{"11", "\[Rule]", 
              TagBox[\(5 + NS\),
                HoldForm]}], ",", 
            RowBox[{"12", "\[Rule]", 
              TagBox["NS",
                HoldForm]}], ",", 
            RowBox[{"13", "\[Rule]", 
              TagBox[\(1 + NS\),
                HoldForm]}], ",", 
            RowBox[{"14", "\[Rule]", 
              TagBox[\(2 + NS\),
                HoldForm]}], ",", 
            RowBox[{"15", "\[Rule]", 
              TagBox[\(3 + NS\),
                HoldForm]}], ",", 
            RowBox[{"16", "\[Rule]", 
              TagBox[\(4 + NS\),
                HoldForm]}], ",", 
            RowBox[{"17", "\[Rule]", 
              TagBox[\(5 + NS\),
                HoldForm]}]}], "}"}], ",", "\<\"-Z[18]-\"\>", ",", 
        "\<\"-Z[18]/NS-\"\>"}], "]"}]], "Output",
  CellLabel->"Out[33]=",
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "This ",
  "morphism",
  " sends an element ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_18\)]],
  " to the coset ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " + {0, 6, 12}."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(VisualizeMorphoid[f3, \ ColorCodomain\  \[Rule] \ Automatic]; \)\)], 
  "Input",
  CellLabel->"In[34]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \("KEY for Z[18]/NS: label used \[Rule] element: {h1 \[Rule] NS, h2 \
\[Rule] 1 + NS, h3 \[Rule] 2 + NS, h4 \[Rule] 3 + NS, h5 \[Rule] 4 + NS, h6 \
\[Rule] 5 + NS}"\)], "Print",
  CellTags->"BuiltIn"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33613 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.0560224 0.0560224 0.0560224 [
[ 0 0 0 0 ]
[ 1 .33613 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .33613 L
0 .33613 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[18])] .5 .30812 0 0 Mshowa
[(0)] .02381 .28011 0 0 Mshowa
[(1)] .07983 .28011 0 0 Mshowa
[(2)] .13585 .28011 0 0 Mshowa
[(3)] .19188 .28011 0 0 Mshowa
[(4)] .2479 .28011 0 0 Mshowa
[(5)] .30392 .28011 0 0 Mshowa
[(6)] .35994 .28011 0 0 Mshowa
[(7)] .41597 .28011 0 0 Mshowa
[(8)] .47199 .28011 0 0 Mshowa
[(9)] .52801 .28011 0 0 Mshowa
[(10)] .58403 .28011 0 0 Mshowa
[(11)] .64006 .28011 0 0 Mshowa
[(12)] .69608 .28011 0 0 Mshowa
[(13)] .7521 .28011 0 0 Mshowa
[(14)] .80812 .28011 0 0 Mshowa
[(15)] .86415 .28011 0 0 Mshowa
[(16)] .92017 .28011 0 0 Mshowa
[(17)] .97619 .28011 0 0 Mshowa
[(Z[18]/NS)] .5 .02801 0 0 Mshowa
[(h1)] .02381 .05602 0 0 Mshowa
[(h2)] .19188 .05602 0 0 Mshowa
[(h3)] .35994 .05602 0 0 Mshowa
[(h4)] .52801 .05602 0 0 Mshowa
[(h5)] .69608 .05602 0 0 Mshowa
[(h6)] .86415 .05602 0 0 Mshowa
1 1 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .26331 m
.02381 .07283 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.07983 .26331 m
.19188 .07283 L
s
% Start of user PostScript
1. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
0 1 1 r
.13585 .26331 m
.35994 .07283 L
s
% Start of user PostScript
2. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.19188 .26331 m
.52801 .07283 L
s
% Start of user PostScript
3. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.2479 .26331 m
.69608 .07283 L
s
% Start of user PostScript
4. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.30392 .26331 m
.86415 .07283 L
s
% Start of user PostScript
5. 3.7 15. 0.3 MAarrowhead1
% End of user PostScript
1 1 0 r
.35994 .26331 m
.02381 .07283 L
s
% Start of user PostScript
6. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.41597 .26331 m
.19188 .07283 L
s
% Start of user PostScript
7. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
0 1 1 r
.47199 .26331 m
.35994 .07283 L
s
% Start of user PostScript
8. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.52801 .26331 m
.52801 .07283 L
s
% Start of user PostScript
9. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.58403 .26331 m
.69608 .07283 L
s
% Start of user PostScript
10. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.64006 .26331 m
.86415 .07283 L
s
% Start of user PostScript
11. 3.7 15. 0.3 MAarrowhead1
% End of user PostScript
1 1 0 r
.69608 .26331 m
.02381 .07283 L
s
% Start of user PostScript
12. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.7521 .26331 m
.19188 .07283 L
s
% Start of user PostScript
13. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
0 1 1 r
.80812 .26331 m
.35994 .07283 L
s
% Start of user PostScript
14. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.86415 .26331 m
.52801 .07283 L
s
% Start of user PostScript
15. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.92017 .26331 m
.69608 .07283 L
s
% Start of user PostScript
16. 3.7 12. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.97619 .26331 m
.86415 .07283 L
s
% Start of user PostScript
17. 3.7 15. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[34]:=",
  ImageSize->{288, 96.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81000007nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;o013fU_JFmYKfU_JFmYKfU_JF0_l0S?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;o0^H2o`;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81000007RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H4o`08U_JFoiKfU_H3o`04mYKfUP;o00kfU_JFm_ofU_KomYKfUP;o00GfU_nF
mP03o`1jmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYH1000009kV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VonKoiP;VonH2iP;VonH2iP;o0^KoiP;V0_l2iP;VonH2iP;o0P;o07oV0_l2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00400000WYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKoU_JFmYKoU_JFmYKoU_JFm_ofU_nFmYKfooJFmYKoU_JFm_of0_l019KfU_H2o`1i
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP01000008_V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0_l2iP;VonH2iP;VonH2iP;V00;o00l2iP;V0_l2iP;V0_l2iP800_l01>KoiP82o`1k
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00400000W9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm_ofooJFmYKoU_JFmYKoU_JFm_ofU_nFmYKfooJFmYKfooJFmP;o086FoiKfooJFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0@00001hiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H21?l00nH2iP02o`030^H200;o00GV0^H2iP02o`040^H2iP;o00P2iP;V0^KoiP;o00H2i_oo
0^H3o`1iiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@000005U_KooiH00_l0:oKoooofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H0
0_l019KoooH4o`0VU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`04U_oomP?o
02OfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00_l01IKoooJF00?o02JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o00BFooof0ol09oJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP02o`05U_oomYH00_l09?JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP400000onH2o`;VonH2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2o`;VonH2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
o`;VonH2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;VonH2iP;o0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;VonH2iP;VonH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;VonH2o`;VonH2iP008>H2o`;VonH2i_oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00002HU_KomYKoU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKoU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKo
U_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKoU_H4o`23U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKoU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KomYKoU_KomYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@00001YiP;o0^KoiP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;o0^KoiP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^KoiP;V00;o
05d2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^KoiP;o0_l2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^KoiP800ol0;@;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0_l2i_oV0P03o`0T0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@000003U_Ko00?o02bFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmPCo02bFm_ofU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPCo02bFmYKf
U_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPCo02bFm_ofooJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPCo02bFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmPCo02VFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP01000000SV0_l2iP;V0P;o02oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
o`;V0^H2iP02o`0]0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H200?o
02h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0_l0;@;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0P04o`0]iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V00?o02?V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000000NFooofU_JF00WO026FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0_l01?JFmYH5d00UU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02o`03mYKf00D1
02KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP;o00?fUT`014`09iKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02o`03mYI?00=?02SfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0_l57`0WU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF004000001nH2iP;V0^H04=l080;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
3=008@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P040@03iP4100D102;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H22d`08`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H200I?00?VCdl00Tl08@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P0<7`0WiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000002IKfU_JFmYKOUP0>g`0OmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP0Ad00KmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00L1
00?f0@402@406OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H024`00iI<UP08C00JmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH:C`03mTm?00E?01_fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H04Al09_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000006iP;V0^H20ml00`;Og`0;g`0N
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]000`;Vd00=d00I0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0P060@05iP810NH0304050;V0^H2iP;V0^H2iP;V0^H2iP;V2T`01@9<C4`200Y<01CV0^H2
iP;V0^H2iP;V0^H2iP;V0Pa?00GVCdl2iP06C`0I0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P0>7`0Y
iP8O7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000006U_JFmYKf0ml00oJF
g`0<g`0LU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP?@00?fU_H03=006IKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH01`400iKf0@020@03mYH100T101;fU_JFmYKfU_JFmYKfU_JFmYH;C003U_I<009<
00?fUT`02T`04YKfU_JFmYKfU_JFmYKfU_JFmPY?00>FmTl00Tl00oJFC`06C`0IU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0<7`03mYKf00<O02CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000000KV0^H2iP83g`030^H200[O00?V0]l00]l060;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPC@
00<2iP803]005NH2iP;V0^H2iP;V0^H2iP;V0^H2iP080@030^H200@100?V0P401`404nH2iP;V0^H2
iP;V0^H2iP;V0^H02T`00`;V0P03C0030^H200Y<01?V0^H2iP;V0^H2iP;V0^H2iP;V00Q?00<2iTl0
0dl00`;V0P08C`0EiP;V0^H2iP;V0^H2iP;V0^H2iP;V00hO00<2iP8011l08nH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001YKfU_JFmP?O00CfU_JF2Ml01IKfU_JF00CO01?fU_JF
mYKfU_JFmYKfU_JFmYKf00G@00CfU_JF2m000iKfd002d00@mYKfU_JFmYKfU_JFmYKfUPT100BFmYKf
1@400oJF0@070@0CmYKfU_JFmYKfU_JFmYKfU_JFmP08C004U_JFmP=<00CfU_JF24`04oJFmYKfU_JF
mYKfU_JFmYKfU_H024l00iKfC`04C`04mYKfUPU?012FmYKfU_JFmYKfU_JFmYKf0al00oJF7`0:7`04
U_JFmPDO02;fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000006iP;V0^H21=l01>H2
iP87g`0:0^H2iP;V0^H2iP?O00oV0^H2iP;V0^H2iP;V0^H01M001^H2iP;V0PW@00H2iP;V0^H3d00<
iP;V0^H2iP;V0^H22P401NH2iP;V00D100?V0^H010405@;V0@42iP;V0^H2iP;V0^H2iP;V0P07C004
0^H2iPE<00CV0^H21d`04@;V0^H2iP;V0^H2iP;V0^H2009?00?V0Tl00dl00nH2iP05C`05iP;V0^H0
2Tl030;V0^H2iP;V0^H2iP<O00KV0^H2iP897`060^H2iP;V1Al08NH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP01000000FFmYKfUP05g`05U_JFmYH02=l02oJFmYKfU_JFmYKf00CO00ZFmYKf
U_JFmYKf1]001iKfU_JFmYH02=002OJFmYKfU_JFmP03d00:mYKfU_JFmYKfUPP100KfU_JFmYH60@03
mYKf00<100CfU_JF0`4039KfU_JFmYKfU_JFmP9<00>FC4`00d`01IKfU_JF00E<00FFmYKfUP05C00?
UTa<mYKfU_JFmYKfU_JF00=?00BFmYKf0dl00oJFmP06C`06U_JFmYKf24l02YKfU_JFmYKfU_H37`09
mYKfU_JFmYKf00PO00NFmYKfU_JF00HO023fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP40
00001NH2iP;V00GO00KV0^H2iP84g`03iP;V00;O00d2iP;V0^H2iP;V0^H200?O00H2iP;V0^H7d007
iP;V0^H2iP07d00=iP;V0^H2iP;V0^H2iP03d008iP;V0^H2iP860@07iP;V0^H2iP070@0<iP;V0NH2
iP;V0^H20P402>H2iP;V0^H20T`00nH2iP04C0060^H2iP;V1D`01^H2iP;V0PA<00?V0^H00T`020;V
0^H2iP;V0Tl030;V0^H2iP;VCnH2iPM?00OV0^H2iP;V00I?00P2iP;V0^H2iP<O00gV0^H2iP;V0^H2
iP;V00LO00OV0^H2iP;V00LO01oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001IKf
U_JF00KO00KfU_JFmYH3g`0EU_JFmYKOU_JFmYKfU_JFmYKfU_JF00CO00?fd=001M002OJFmYKfU_JF
mP06d00@U_JFmYKfU_JFmYKfU_JFmP?@00KfU_JF0IH50@08U_JFmYKfU_H70@0=mYKfU_JFmYKfU_JF
mP020@0;U_JFmYI<U_JFmYH00d`01YKfU_JFmPM<00KfU_JFmYH3C00;U_JFmYI<U_JFmYH00Tl03OJF
mYKfU_JFmYKfU_H01dl02?JFmYKfU_JF1Dl01YI?U_JFmP<O013fU_JFmYKfU_JFmYKfU_JF1Ql02OJF
mYKfU_JFmP077`0NmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000005iP;V0^H01]l03`;V
0^H2iP;O0^H2iP;V0P02g`0AiP;V0^H2iP;V0^H2iP;V0^H00ml5d00:0^H2iP;V0^H2iP?@01GV0]02
iP;V0^H2iP;V0^H2iP;V0^H00]001@810^H200<100T2iP;V0^H2iP8020403^H2iP;V0^H2iP;V0^H2
0`42C00?0^H2iP;V0T`2iP;V0^H200M<00l2iP;V0^H2C0;V0^H2iP800T`3C`0>0^H2iP;V0^H2iP;V
0^H8C`090^H2iP;V0^H200=?00D2iP9?0P027`0EiP;V0^H2iP;V0^H2iP;V0^H27`;V00<O00[V0^H2
iP;V0^H221l07NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001IKfU_JF00KO017fU_JF
mYKfU_JFmYKfU_JFmP02g`0BU_JFmYKfU_JFmYKfU_JFmYK@1=l04M3fU_JFmYKfU_JFm]3fU_JF00;@
01;fU_JFmYKfU_JFmYKfU_JFmP43d00>U_JF0IKfU_JFmYKfU_H60@0AU_JFmYKfU_JFmYKfU_JFmYH0
0T`20@0?mYKfU_JFmYKfU_JFmYKf00M<00ofU_JFmYKfU_JFmYKfU_H00Tl2C00AU_JFmYKfU_JFmYKf
U_JFmYH01Tl03_JFmYKfU_JFmYI?U_JF0Ql2C`0AmYKfU_JFmYKfU_JFmYKfU_H00Ql049KfU_HOmYKf
U_JFmYKfU_H67`0OU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000000CV0^H21ml04`;V
0^H2iP;V0^H2iP;V0^H2iP800]l04>H2iP;V0^H2iP;V0^H2iP84d0?O02D2iP;V0^H2iP;V0^H2iP;V
d>H2iP;V0^H2iP;V0^H2iP7V0^H200?@00/2iP;V0^H2iP;V0P050@0@0^H2iP;V0^H2iP;V0^H2iP9<
00@2iP;V0P403@;V0^H2iP;V0^H2iP801d`03@;V0^H2iP;V0^H2iP800Tl01>H2iP82C00@iP;V0^H2
iP;V0^H2iP;V0PE?00/2iP;V0^H2iP;V0P037`0W0^H2iToV0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V
0^H2iP;V0^H200DO0202iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP40000019KfU_H8g`0V
U_JFmYKfU_JFmYKfU_JFmYKfU_KOmYKfU_JFmYKfU_JFmYK@U_H2d003U_JF00CO02CfU_JFmYKfU_JF
mYKfd?JFmYKfU_JFmYKfU_H1mYKfU_JFmYH3d009U_JFmYKfU_JF008101[fUP6FmYKfU_JFmYKfU_JF
mTcfU_JFmYKfUP<100VFmYKfU_JFmYH02D`02IKfU_JFmYKfUP03C`0JU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYI?U_H2C`09U_JFmYKfU_JF00<O02^FmYKfU_JFmTofU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKf
U_JFmYKfU_JF008O02;fUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000004iP;V0PSO
01GV0^H2iP;V0^H2iP;V0^H2iP;V0^H00]l060;V0^H2iP;V0^H2i]3V0^K@iP;V0^H2iP?O02CV0^H2
iP;V0^H2i]3V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP83d00G0^H2iP;V0NH2iP7V0^H2iP;V0^H2iP80
0T`03>H2iP;V0^H2iP;V0P8100OV0^H2iP;V00U<00OV0^H2iP;V009?00`2iP;V0^H2iP;V0^H2C00G
0^H2iP;V0^H2iP;VCnH2iToV0^H2iP800al0DP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iQoV0^H2iP;V
0^H2iP;V0^H2iP;V0^HOiP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000002>FmYKf
U_JFgiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02g`0ImYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JF
mP04g`0SU_JFmYKfU_K@mYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYH00m004YKfU_JFmYKf0OJFmYKf
U_JFmP9<012FmYKfU_JFmYKfU_JFmYKf0P404iKfU_JFmYKfUTbFmYKfU_JFmYH00Tl04?JFmYKfU_JF
mYKfU_JFmYH2C00BmYKfU_JFmYKfCoJFmYKfU_JF0al0EIKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKf
7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0@00000UiP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02g`0K0^H2iP;Vd>H2iP;V
0^H2iP;V0^H2iP;V0^H200?O02<2iP;V0^K@iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0P03d00=
0^H2iP;V0NH2iP;V0P02C00DiP;V0^H2iP;V0^H2iP;V0^H2iP830@0=0^H2iP;VC>H2iP;V0P03C`0D
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C00=0^H2iP;VCnH2iP;V0P037`1H0^H2iP;V0^H2iP;V0^H2iP;V
0^I?iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000AIKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]nFmYKf
U]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP04g`03mYKf00;@00>FmYH00P406?JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP?@02>FmYH1U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP020@09mYKfUTbF
mYKf009?02>FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFCiKfUP037`0HU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0Tl00iKfUP027`0lmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00000XiP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P;O01oV0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00?O02;V0]020@;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20m0010810^H2C00L0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP8100D2iTcV0P02C`0LiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<00CV0Tl20al0GP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000002ZFmYKfU_JFgiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H2g`0Pd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H4g`0Q
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00?@025<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00`42C`0PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C01SCanFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000;>H2iP;V0^KOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K@0]l08^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@83g`0N0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`08P7@d=02iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2C`0QC041iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200<O06A?C4cV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00001CU_JFmYKfU]nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFm]ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1
U_JFd9H01=l08?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf0OJF0]006_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0Tl01OJFC9Kf008101ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP8O06NFmTof
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000;nH2iP;V0^KOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]02iP;V00;O02H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP810^H2iP;@0^H2iP?O01CV0^H2iP;V0^H2iP;V0^H2iP;V0P9<00WV0^H20@;V0^H00m005>H2
iP;V0^H2iP;V0^H2iP;V0^H20dl02@;V0^I<iP;V0P030@0D0^H2iP;V0^H2iP;V0^H2iP;V0^H37`09
iP;V0Tl2iP;V009<05h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP9?0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000aU_JFmYKf
U]nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKfUP02g`0GmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_H00P401iKfU_JFmYH00]001OJFmYKf00CO00jFmYKfU_JFmYKfU_JFmP9<00jFmYKf
U_JF0IKfU_JFmP?@00ofU_JFmYKfU_JFmYKfU_H00Tl03iKfU_JFmYI<U_JFmYKfUP020@0?mYKfU_JF
mYKfU_JFmYKf00<O00kfU_JFmYI?U_JFmYKfUP9<01OfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP027`07
U_JFmYKfUP02C`0jmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000<nH2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2
iP;V0^H2iP02g`0Y0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^K@iP;V0^H2iP800ml02@;V
0^H2iP;V0P02C00CiP;V0^H2iP;V0NH2iP;V0^H2iP03d00:iP;V0^H2iP;V0P9?01?V0^H2iP;V0^I<
iP;V0^H2iP;V008100X2iP;V0^H2iP;V0al04nH2iP;V0^H2iToV0^H2iP;V0^H00T`0FP;V0^H2iP;V
0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000HIKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_K@mYKfU_JFmYKfU_JFgiKfU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfd?JFmYKf
U_JFmYH01=l07OJFmYI<U_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKf00?@00CfU_JF0dl05iKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JF00<100BFmYKf0al0L_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000=^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;@0^H2iP;V0^H2iP;V0P;O02gV0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;Vd>H2
iP;V0^H2iP;V0^H00ml07D`2iP;V0^H2iP;V0^H20@;V0^H2iP;V0^H2iP;V00?@01i?0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP820@8O01cV0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H20T`0EnH2
iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
7`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000003RFmYKfU_JFgiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmP;O02^FmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKf
U_K@mYKfU_JFmYKfU_JF009<01kfgmoOmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYH2C`0Mm]3@d?JF
mYKfU_JFmYKfUTbFmYKfU_JFmYKfU_H00al08OH10IKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JF
mP02C01EU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000006_V0^H2iP;VgnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2g`;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2
iP;V0^H2i]3V0^H2iP;V0^H2C0;V0^H2iP04g`0C0^H2iP;V0^H20@;V0^H2iP;V0P03C`060^H2iP;V
0m004nH2iP;V0^H2iTcV0^H2iP;V0^H00al01^H2iP;V0P<10782iP;V0^H2iP9?0^H2iP;V0^H2iP;V
0^H2iP;V0T`2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000003^FmYKfU_JFgiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfUP02g`0UmYKfU_JFmP7fU_JFmYKfU_JF
mYKfU_JFmYKfU_K@mYKfU_JFmP02C00;U_JFmYKfU_JFmYH00ml03YKfU_JFmP7fU_JFmYKf0Tl039Kf
U_JFmYKfU_JFmP?@00gfU_JFmYI<U_JFmYKf00<O00cfU_JFmYKfU_JFmYH20@0LmYKfU_JFmTofU_JF
mYKfU_JFmYKfU_JFmYKfUP9<05;fU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00000miP;V0^H2i]oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02g`030^H20081
01OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02d0030^H2009<013V0^H2iP;V0^H2iP;V0^H21=l02>H2
iP7V0^H20Tl04NH2iP;V0^H2iP;V0^H2iP;V00?@00OV0^I<iP;V00<O017V0^H2iP;V0^H2iP;V0^H2
iP020@0L0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<00<2iP800Ql05nH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V009?0382iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V
0^H2iP400000?iKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP02g`0M0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]000T`05YKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H3g`030II?009?01JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0m006T`O7aofU_JF
mYKfU_JFmYKfU_JFmYKfU_JF0`406iI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C01>7iKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00001iiP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7OiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC=02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP04g`0J0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2d00K0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2008106WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Qm<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@000012U_JFmYKfU]nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKf0]l05iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<01[fU]2F
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9?00Cf0OJF0ml04iKfU_JFmYKfU_JFmYKfU_JFmYH00al00iI<
UP03d00JU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoH20@0JU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHO
U_H2C01;U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
7oJFmYKfU_JFmYKfU_JFmYKfU_JF00400000A>H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H20]l04nH2iP;V0^H2iP;V0^H2iP;V0^H0
0T`06@;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP800dl02@;V0^H1iP;V0P04g`0<iP;V0^H2iP;V0^H2
0al02@;V0^I<iP;V0P03d00I0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0P030@0I0^H2iP;V0^H2iP;V
0^H2iP;V0Ql2iP;V0P02C019iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP01000004JFmYKfU_JFgiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKf0]l03iKfU_JFmYKf
U_JFmYKfUP02C00ImYKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmP02C`0@U_JFmYKfU_H1mYKfU_JFmP?O
00KfU_JFmYH37`0?U_JFmYKfUTbFmYKfU_JF00?@01VFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JF0081
01WfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKf009<04NFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfUP01000003_V0^H2iP;VgnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP020@0U0^H2iP;V
0^H2iP;O0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0P02d00<iP;V0^H2iP;V0^H20Tl05NH2iP;V0^H2
iP810^H2iP;V0^H2iP04g`8O01D2iP;V0^H2iP;VC>H2iP;V0^H2iP800m0060;V0^H2iP;V0^H2iP9?
0^H2iP;V0^H2iP8100`2iP;V0^H2iP;V0^H27`0U0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0P02C`0[iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP010000
04VFmYKfU_JFgiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0OJFmYKfU_JFmYKfU_JF00;O00WfU_JFmYKfU_H00T`05iKfU_JFmYKfU_JFmYKfd?JFmYKfU_JF00=?
01NFmYKfU_JFmYKfU_JF0IKfU_JFmYKfUP037`0KU]oOgiKfU_JFmYKfUTbFmYKfU_JFmYKfU_JF00?@
01NFmYKfU_JFmYI?U_JFmYKfU_JFmYKfUP030@0GU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYH00T`0A?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JF
mYKfU_JF0@00001;iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2iP;V00;O00D2iP;V0P02C00GiP;V0^H2iP;V0^H2iP;V0^K@
iP;V0^H00Tl05`;V0^H2iP;V0^H2iP;V0^H1iP;V0^H200<O00L2iP;V0^H200CO01KV0^H2iTcV0^H2
iP;V0^H2iP;V0^H20m005`;V0^H2iToV0^H2iP;V0^H2iP;V0^H2008101OV0^H2iQoV0^H2iP;V0^H2
iP;V0^H2iP02C0120^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
7nH2iP;V0^H2iP;V0^H2iP;V0@00001=U_JFmYKfU]nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_K@mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYH00]l06_I<C9KfU_JFmYKfU_JF
mYKfU_JFmYKfd?JF0Tl05_JFmYKfU_JFmYKfU_JFmYKfU_H1mYH37`0>U_JFmYKfU_JFmYKfU_H3g`0F
mYI<U_JFmYKfU_JFmYKfU_JFmYKfUP?@01JFmTofU_JFmYKfU_JFmYKfU_JFmYKf0P405iKf7oJFmYKf
U_JFmYKfU_JFmYKfU_JF009<043fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmQofU_JFmYKfU_JFmYKfU_JF0@00002EiP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i]3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2Cm1?0^H2iP;V0^H2iP;V0^H2iP;V0^H27`4O0^H2iP;V0^H2iP;V0^H2iP;V0^H0
1=l05@;V0^H2iP;V0^H2iP;V0^H2iP;V0P03d00E0^H2iP;V0^H2iP;V0^H2iP;V0^H200<105H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP400000CIKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<01GfgmnFmYKfU_JF
mYKfU_JFmYKfU_H00Tl05IKfd?JFmYKfU_JFmYKfU_JFmYKfUP037`0KUP6FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbF00?O01FFmYKfU_JFmYKfU_JFmYKfU_JFCiH00m005IKfU_JFmYKfU_JFmYKfU_JFmQof
UP020@0EmYKfU_JFmYKfU_JFmYKfU_JFmYKf009<03fFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKf
U_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JF00400000=>H2iP;V0^KOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP820@0EiP;V0^H2iP;V0^H2iP;V0^H2iP;V009<
00D2iP;V0P02g`0>iP;V0^H2iP;V0^H2iP82C`05iP;V0^H00]003@;V0^H2iP;V0^H2iP800al08@;V
0^H20@;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0P04g`0DiP;V0^H2iP;V0^H2iP9?0^H2iP83d00=
0^H2iP;V0^H2iP;V0P027`05iP;V0^H00P405@;V0^H2iP;V0^H2iP;V0^H2iP;V0P02C00EiP;V0^H2
iP;V0^H2iP;V0^H2iP;V009?02@2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H10000
04VFmYKfU_JFgiKfU_JFmYKfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKf
U_JFmYKfU_JFmYKfU_JF009<00WfU_JFmYKfU_H00]l02IKfU_JFmYKfUP03C`0DU_JFmYKfU_JFd9Kf
U_JFmYKfU_H27`0XU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmP?O01CfU_JF
mYKfU_JFmTofU_JFmYKfUP;@01CfU_JFmYKfU_JF7iKfU_JFmYKfUP<101BFmYKfU_JFmYKfU_JFmYKf
U_JFmP9<03VFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKf
U_JFmYH00@00001MiP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2
iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;O0^H2iP;V009?01@2iP;V0^H2iP;V
0^H2d0;V0^H2iP<O02gV0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H0
1=l04P;V0^H2iToV0^H2iP;V0^H2iP?@01CV0^H2iP8O0^H2iP;V0^H2iP;V0P8104gV0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2
iP;V0^H2iP01000004JFmYKfU_JFgiKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKf
U_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKf0T`03iKfU_JFmYKfU_JFmYKfUP02g`0GmYI?CoJFmYKfU_JF
mYKfU_JFmYK@U_H00al0=?JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYH3g`0BU_JFCiKfU_JFmYKfU_JFmYKf0m004oJF7iKfU_JFmYKfU_JFmYKfU_H00P404iKf
U_JFmYKfU_JFmYKfU_JFmYH00T`0=_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JF
mYHOU_JFmYKfU_JFmYKfUP400000A>H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;@0^H2iP;V0^H2
iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H20T`04nH2iP;V0^H2iP;V0^H2iP;V0Tl00]l0C`;V
0^H2iP;V0^H2iP;V0^H2iQo@7nH2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iTcV
0^H2iP;V0^H2iP;V0^H2iP801=l04NH2iP;V0^H2iP;V0^H2iP;V00?@01;V0^H2iP;V0^H2iP;V0^H2
iP830@0B0^H2iP;V0^H2iP;V0^H2iP;V0T`0=0;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V
0^H2iP;V0Ql2iP;V0^H2iP;V0^H1000004:FmYKfU_JFgiKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKf
U_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKfU_H2C00BU_JFmYKfU_JFmYKfU_JFmYKf0Tl00iKf
UP02g`0=mYKfU_JFmYKfU_JFmP037`11mYK@U_JFmYKfU_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKfU_JF
mYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYI?U_H00ml04OJFmYKfU_JFmYKfU_JF7iKf00?@01;fU_JF
mYKfU_JFmYKfU_JFmYH20@0BmYKfU_JFmYKfU_JFmYKfU_JF0T`0<_JFmYKfU_JFmYKfU_JFmYKfUTnF
mYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JF0@00000]iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2
iP;Vd>H2iP;V0^H2iP;V0^H2iP;V008102D2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V
0^H2009?017V0^H2iP;VgnH2iP;V0^H2iP037`06iP;V0^H20]00?nH2iP;V0^H2iP;V0^H2iP;V0NH2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP04g`080^H2iP;V0^H27`06
0^H2iP;V0m004NH2iP;V0^H2iP;V0^H2iP;V008102D2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V
0^H2iP;V0^H2009?01gV0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP01000003nFmYKfU_JFgiKf
U_JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYH00T`04?JF
mYKfU_JFmYKfU_JFmYH3C`0:U_JFmYKfU_JFmP;O00BFmYKf0al0C_JFmYKfU_JFmYKfd?JFmYKfU_JF
mYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfUP?O
012FmYKf7oJFmYKfU_JFmYKf0m004?JFmYKfU_JFmYKfU_JFmYH30@0@U_JFmYKfU_JFmYKfU_JFmP9<
02nFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfUP01000003gV0^H2
iP;VgnH2iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2iP;V009<
0102iP;V0^H2iP;V0^H2iP;V0Tl03`;V0^H2iP;V0^H2iP;V0P02g`8O05CV0^H2iP;V0^H2iP;V0^K@
iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2
iP;V0^H2iP84g`0?iP;V0^H2iP;V0^H2iP;V00?@013V0^H2iP;V0^H2iP;V0^H20P404>H2iP;V0^H2
iP;V0^H2iP82C00]iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0040
0000>iKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKf
U_JF009<013fU_JFmYKfU_JFmYKfU_JF0Tl03oJFmYKfU_JFmYKfU_JFmP037`1Km]oOU_JFmYKfU_JF
mYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JF
CiKfU_JFmYKfU_JFmYKfU_HOmP03g`0?mYKfU_JFmYKfU_JFmYKf00?@00ofU_JFmYKfU_JFmYKfU_H0
0P4049KfU_JFmYKfU_JFmYKfU_H2C00[U_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JF7iKf
U_JFmYKfUP01000004[V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP7V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0P=?00h2iP;V0^H2iP;V0^H2iP<O067V0^H2iP;O0^H2
iP;V0^H2iP;V0^H2i]3V0^H2iP;V0^H2iP;V0^H20@;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0Tl2iP;V0^H2iP;V0^H2iP;V7nH2iP;V00CO00h2iP;V0^H2iP;V0^H2iP?@00kV0^H2iP;V0^H2
iP;V0P<103X2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H27`;V
0^H2iP;V0@00000hU_JFmYKfU]nFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmP7fU_JFmYKf
U_JFmYKfU_H2C00>U_JFmYKfU_JFmYKfU_H2C`0>U_JFmYKfU_JFmYKfU_H37`0:mYKfU_JFmYKfUP;O
05cfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JF
mYKfU_JFmTofU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfUP?O00jFmYKfU_JFmYKfU_JFmP?@00kfU_JF
mYKfU_JFmYKfUP8100kfU_JFmYKfU_JFmYKfUP9<02SfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JF
mYKf7oJFmYKfU_JF0@000036iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0NH2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2
i]oV0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^I?iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H20]l0EnH2iP;V0^H2iP;V0^H2i]3V0^H2
iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^HO
iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@000006U_JFmYKf0_l03IKfU_JFmYKfU_JFmYH00ol03IKfU_JFmYKfU_JFmYH01?l03?JFmYKfU_JF
mYKfUP?o00jFmYKfU_JFmYKfU_JFmP?o00cfU_JFmYKfU_JFmYH3o`0>U_JFmYKfU_JFmYKfU_H2o`0N
U_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKf0_l03IKfU_JFmYKfU_JFmYH00ol02YKfU_JFmYKf
U_H3o`04mYKfUP;o00OfU_JFmYKf00?o00?fU_H00ol01oJFmYKfU_H00ol00oJFmP04o`06U_JFmYKf
0ol00oJFmP03o`07mYKfU_JFmP03o`04mYKfUP?o00JFmYKfU_H3o`03mYKf00?o00OfU_JFmYKf00?o
00CfU_JF0_l01oJFmYKfU_H00ol02_JFmYKoU_JFmYH100000?oV0^H2i_oV0_l2iP;V0^H2iP;V0^H2
o`;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2
iP;V0^H2o`;V0^H2iP;V0^H2i_oV0_l2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;VonH2o`;V0^H2
iP;V0^H2iP;V0_l2iP;V0^H2iP;VonH2iP;o0^KoiP;V0^H2i_oV0^H2i_oV0^H2iP;V0^KoiP;V0^Ko
iP;V0^H2iP;VonH2iP;V0^KoiP;V0^H2i_oV0^H2iP;o0^H2iP;V0^KoiP;V0^H2i_oV0^H0023V0^H2
i_oV0_l2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0P400000AIKfU_JFoiKfooJFmYKfU_JFmYKfU_KomYKf
U_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfUP04o`1=mYKfU_JFmYKfU_JF
mYKfooJFmYKfU_JFmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JF
mYKfU_H00ol0CoJFmYKfU_JFmYKoU_JFm_ofU_nFmYKfU_JFoiKfU_JFoiKfU_JFmYKfU_nFmYKfU_Ko
mYKfU_JFmYKoU_JFmYKfU_nFmYKfU_JFoiKfU_H01?l0<iKfU_JFmYKoU_JFmYKfU_nFmYKfU_JFoiKf
U_KomYKoU_JFmYKfU_nFmYKfU_KomYKfUP01000003KV0^H2i_oV0_l2iP;V0^H2iP;V0^H2o`;V0^H2
iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP82o`0MiP;V0^H2iP;V0^H2i_oVonH2iP;V0^H2iP;V0^H0
0ol03NH2iP;V0^H2iP;V0^H00ol07^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0P;o057V0^H2
iP;V0^H2iP;VonH2o`;V0^H2iP;V0^KoiP;V0_l2i_oV0^H2iP;VonH2iP;VonH2iP;V0^H2i_oV0^H2
iP;VonH2iP;V0^KoiP;V0^H00_l07@;V0^H2iP;VonH2iP;o0_l2iP;V0^H2i_oV0^H200?o00d2iP;V
0^H2i_oV0^H200?o01@2iP;V0^H2i_oV0^H2iP;o0^H2iP400000oiKfU_JFoiKfooJFmYKfU_JFmYKf
U_KomYKfU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_nFoiKfU_JFmYKf
U_JFmYKoU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKoU_KomYKf
U_JFmYKfU_JFoiKfooJFmYKfU_JFmYKoU_JFm_ofU_nFmYKfU_JFoiKfU_JFoiKfU_JFmYKfU_nFmYKf
ooJFoiKfU_JFmYKoU_JFmYKfU_nFmYKfU_JFoiKfU_Kom_ofU_JFmYKfU_nFmYKfooJFmYKfUP0089Kf
U_JFoiKfooJFmYKfU_JFmYKfU_KomYKfU_JFmYKf0@000006iP;V0^H20_l03NH2iP;V0^H2iP;V0^H0
0_l03`;V0^H2iP;V0^H2iP;V0P02o`0=iP;V0^H2iP;V0^H2iP03o`0>iP;V0^H2iP;V0^H2iP82o`0=
iP;V0^H2iP;V0^H2iP04o`0=0^H2iP;V0^H2iP;V0P03o`0<0^H2iP;V0^H2iP;V1?l03@;V0^H2iP;V
0^H2iP800_l03^H2iP;V0^H2iP;V0^H20_l02^H2iP;V0^H2iP82o`05iP;V0^H00_l01`;V0^H2iP80
0_l01>H2iP82o`08iP;V0^H2iP82o`05iP;V0^H00_l01`;V0^H2iP800_l01>H2iP83o`070^H2iP;V
0P02o`05iP;V0^H00_l01`;V0^H2iP800_l01>H2iP84o`06iP;V0^H20_l01NH2iP;V00?o00KV0^H2
iP82o`04iP;V0PCo00?V0^H00@000028U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o012FmYKfU_JFmYKfU_JFmYKf
0_l0PiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;VonH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@000021U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00Co00SfU_KomYKfUP?o00BFmYKf0_l0RIKfU_JFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0_l2iP;o0^H2iP;o0^H2i_oV0_l2iP;VonH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFm_ofU_JFm_ofU_JFoiKfooJFmYKoU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1000009CV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2o`;V0^H2o`;V0^H20_l0RNH2iP;VonH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_nFoiKfU_KomYKfU_KomYKfU_nFm_ofU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000021
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00Co00<2iP800_l00nH2iP02o`050^H2iP800_l01>H2iP82o`23iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000\
\>"],
  ImageRangeCache->{{{0, 287}, {95.75, 0}} -> {-0.492138, -1.00003, 0.062663, 
  0.062663}},
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "In contrast, the induced iso",
  "morphism",
  " maps from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_18/{0, \ 6, \ 12}\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  " (the image, in this case)."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f4\  = \ InducedIsomorphism[ZMap[18, 6]]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    RowBox[{"Morphoid", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              TagBox["NS",
                HoldForm], "\[Rule]", "0"}], ",", 
            RowBox[{
              TagBox[\(1 + NS\),
                HoldForm], "\[Rule]", "1"}], ",", 
            RowBox[{
              TagBox[\(2 + NS\),
                HoldForm], "\[Rule]", "2"}], ",", 
            RowBox[{
              TagBox[\(3 + NS\),
                HoldForm], "\[Rule]", "3"}], ",", 
            RowBox[{
              TagBox[\(4 + NS\),
                HoldForm], "\[Rule]", "4"}], ",", 
            RowBox[{
              TagBox[\(5 + NS\),
                HoldForm], "\[Rule]", "5"}]}], "}"}], ",", 
        "\<\"-Z[18]/NS-\"\>", ",", "\<\"-Z[6]-\"\>"}], "]"}]], "Output",
  CellLabel->"Out[35]=",
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s compose ",
  StyleBox["f3", "MR"],
  " and ",
  StyleBox["f4", "MR"],
  "."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f5\  = \ MorphoidComposition[f4, f3]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \(Morphoid[{0 \[Rule] 0, 1 \[Rule] 1, 2 \[Rule] 2, 3 \[Rule] 3, 
        4 \[Rule] 4, 5 \[Rule] 5, 6 \[Rule] 0, 7 \[Rule] 1, 8 \[Rule] 2, 
        9 \[Rule] 3, 10 \[Rule] 4, 11 \[Rule] 5, 12 \[Rule] 0, 13 \[Rule] 1, 
        14 \[Rule] 2, 15 \[Rule] 3, 16 \[Rule] 4, 17 \[Rule] 5}, "-Z[18]-", 
      "-Z[6]-"]\)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[TextData[{
  "Note that this composition is the same as ",
  Cell[BoxData[
      StyleBox[\(ZMap[18, 6]\),
        "MR"]], "Input"],
  "."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EqualMorphoidQ[f5, \ ZMap[18, \ 6]]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"BuiltIn"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Sgn",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "given", " ", "a", " ", "permutation", " ", "group", " ", 
              StyleBox["G",
                FontSlant->"Italic"], 
              StyleBox[",",
                FontSlant->"Italic"], "return", " ", "the", " ", 
              StyleBox["Morphoid",
                "MR"], " ", "determined", " ", "\n", "by", " ", "the", " ", 
              StyleBox["Parity",
                "MR"], " ", "function"}]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.19, 0.81}},
  CellTags->{"BuiltIn", "i:11"}],

Cell["Other built-in Morphoids.", "Caption",
  CellTags->"BuiltIn"],

Cell[TextData[{
  "Under the ",
  StyleBox["Sgn", "MR"],
  " function, odd permutations go to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  ", while even permutations go to 1."
}], "MathCaption",
  CellTags->"BuiltIn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(VisualizeMorphoid[Sgn[SymmetricGroup[3]]]; \)\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"BuiltIn"],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {1, 2, 3}, g2 \
\[Rule] {1, 3, 2}, g3 \[Rule] {2, 1, 3}, g4 \[Rule] {2, 3, 1}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"BuiltIn"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.14286 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.190476 0.190476 0.190476 [
[ 0 0 0 0 ]
[ 1 1.14286 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.14286 L
0 1.14286 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(S[3])] .5 1.04762 0 0 Mshowa
[(g1)] .02381 .95238 0 0 Mshowa
[(g2)] .21429 .95238 0 0 Mshowa
[(g3)] .40476 .95238 0 0 Mshowa
[(g4)] .59524 .95238 0 0 Mshowa
[(g5)] .78571 .95238 0 0 Mshowa
[(g6)] .97619 .95238 0 0 Mshowa
[(IntegerUnits)] .5 .09524 0 0 Mshowa
[(1)] .02381 .19048 0 0 Mshowa
[(-1)] .59524 .19048 0 0 Mshowa
0 0 1 r
.5 Mabswid
[ ] 0 setdash
.02381 .89524 m
.02381 .24762 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.21429 .89524 m
.59524 .24762 L
s
% Start of user PostScript
1. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
.40476 .89524 m
.59524 .24762 L
s
% Start of user PostScript
2. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
.59524 .89524 m
.02381 .24762 L
s
% Start of user PostScript
3. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.78571 .89524 m
.02381 .24762 L
s
% Start of user PostScript
4. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.97619 .89524 m
.59524 .24762 L
s
% Start of user PostScript
5. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[38]:=",
  ImageSize->{251.938, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003k000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?/00000n^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003j
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0001c
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP03o`24
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000F^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0PGo00@2oooV0_l00`;Vo`02o`03iP;V00Co00<2i_l00ol00`;Vo`03o`030_oo00;o00?V0^H0
0_l00`;V0P02o`04i_oo0PGo00<2i_l00_l00nH2o`03o`1JiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfooJFoiKfU_nFm_of
ooJFmYKfooJFm_ofooJFmYKfU_nFmYKfooJFoiKfooJFoiKfU_KomYKfU_nFm_ofU_JFoiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000K>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
o`;V0_l2i_oV0^KoiP;V0PGo00L2o`;V0_l200Go01l2i_oV0^H2o`;VonH2o`;VonH2iP;o0^H2i_oV
0^H200Co05[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0007nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFm_ofU_KomYKoU_JFoiKfU_KomYKfooKomYKfooKomYKfooJF00;o07WfU_Ko
mYKoU_KomYKoU_JFm_ofU_JFoiKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf006F
0000GnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V00Go00?V0_l00ol00nH2iP03o`03
iP;V00Go00KVooooiP82o`09i_oo0_l2i_oV00Go00?V0^H00_l00`;V0P04o`03iP;o00?o05[V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0005ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H5o`0TmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0_l0MOJFooofU_JFmYKfU_JF
mYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP01UP000?[V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0_l2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V00000iKfUP03o`2@U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0ol0HOJF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00IH0003jiP;V0_l2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000T9Kf
U_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmPGo06GfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmP01UP000?[V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F00000nH2iP02o`2A0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0P02o`1RiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003j
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
00001NH2iP;V009<0?<2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP800NH00005U_JFmYH01D`0RYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP=<06?fU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00IH00005iP;V0^H01d`0QnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP05C01RiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0000BFmYKf
2T`0Q9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmPM<067fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf006F
00001>H2iP8=C0200^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H9C01PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH00004U_JFmPi<07jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H;C01OmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H0
0IH00004iP;V0Pi<07gV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP0=C01NiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
00000iKfUP05C003UTa<00I<07gfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP07C003mYI<00E<05gfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_H00IH00003iP;V00e<07gV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP08C0030^I<00I<05cV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V00000iKfUP06C003mTa<00=<07gfC?JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP09C003mYI<00M<05_fU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf006F00000nH2iP06C0030Ta<009<083V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PM<
00<2iT`01D`0G@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P01iP0000>FmT`01d`029I<
U_I<mYKf0T`0NYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf1d`00oJFmP04C01NU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
00000nH2C007C027iP;V0^I<iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V00A<06D2iP9<0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0P01iP000?ZFmYKfUTbFmYKfU_JFmYKfC?JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFC9KfC?JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^I<iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iTcV0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9Kf
U_JFmYKfU_JFmTcfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYI<U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1UP0001SV0^H2iTcV0^H2iP;V0^H2iP;VC>H2iP82C03PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0T`2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmTcfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_I<mYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2
iP;VC>H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2C0;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKf
U_JFC9KfU_JFmYKfU_JFmYKfUTbFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmTcfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2C0;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iTcV0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F00007nH2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H00T`0f@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP9<0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP80
0NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V00009IKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYH00T`0doJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000:nH2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H00T`0c@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2C0;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800NH0003jU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP0003;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0P9<0<KV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0000hU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_H2C030U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP0003nFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYH00T`0^OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf006F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP0004GV0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H00T`0/`;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;VC>H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2007V0000nYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP00
04^FmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYH00T`0[OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<
mYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKf006F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001BU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmP9<0:JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003j
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
0000F>H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP82C02PiP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0001OiP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H00T`0V@;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P01iP00
0?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C09<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH0001UU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`0ToJFmYKfU_JF
mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmP01UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcVC>H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0001[iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H00T`0S@;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P01iP000?ZFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000L^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0P9<08KV0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003j
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0005^FmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF009<01_fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00T`0P9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0001KiP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C02M0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C09<
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0P01iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9I<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH0001oU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfUP02C01imYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP01UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH00025iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP02C01c
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P01iP00
0?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH0002;U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C01]mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmP01UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000TYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0T`0IYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F
0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81iP00072FmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0T`0R9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001aU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`0QoJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmP01UP0009SV0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<063V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000WnH2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C01I0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP800NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003j
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P7V0000YIKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP02C01CmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_H00IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmP6F0000ZnH2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C01=0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP800NH0003j
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmP6F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0P7V
0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_H1UP000;;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20T`0A^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf0IH0003jiP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H20NH0002hU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<042FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf0IH0003j
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H20NH0003jU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmP6F
0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP81iP000;nFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C00imYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf006F0000n^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP81iP000?ZFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKf0IH0003jiP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0P7V0000nYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_H1UP000?[V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H20NH0003j
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V
0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000<IKooonFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00ol0;IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP03o`0]U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00?o02fFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0ol0;9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0ol01oJFmYKfU_H0
0IH0003jiP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VonH2iP;V0P7V00000iKoo`02o`0/m_ooooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH4o`03m_oo00;o02NFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01?l0;?KoooofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF1?l00oJF
o`02o`0WU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00Co02_foooomYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00Co00JFm_ooU_H1UP000?[o0^H2o`;VonH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2o`;VonH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2o`;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;o0^H2o`;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;o0^H2o`;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^Koi_oV0_l2
0NH0002FooJFm_ofU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFm_of
U_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFm_ofU_JFoiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFm_of1?l0H9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfooJFm_ofU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKoU_JFoiKoU_KomP6F0000Iol2iP;o0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0_l2iP;o0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2
iP;o0^H00_l0G@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;o0_l2o`;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;o0P03o`0/0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;VonH3o`7V0@81iP0000>Fool00ol0:iKoU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH01_l0:_JFoiKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUPGo02^FmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00Ko02[fooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH6o`0Y
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H01_l019KfU_H1UP0000KV0^H2
iP82o`0_iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l0;@;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P03o`0^0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o02d2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP801?l0;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20ol10P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP00
0?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP6F0000NNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l02P;V0^H2iP;V0^H2o`1c0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P01iP000?ZFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFm_of
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0001b
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol02@;V
0^KoiP;V0P03o`1i0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0P01iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_KomYKoU_JFoiKfU_JFmYKoU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0001diP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82o`24iP;VonH2iP;V0^KoiP;V0_l2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0001bU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0_l02iKfU_JFoiKf
U_JF00;o07WfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf006F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0_l2i_oV0^KoiP;V0^H2i_oV0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP0007>FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00?o00>FmYH00_l00oJFmP03o`04mYKfUP;o07?fU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf006F0000n^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP00
0?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P7V0000nYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP6F0000n^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81iP000?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000nYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1UP000?[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20NH0003jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP6F0000n^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81iP00
0?ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0IH0003jiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P7V0000\
\>"],
  ImageRangeCache->{{{0, 250.938}, {287, 0}} -> {-0.125026, -1.00226, 
  0.0209218, 0.0209218}},
  CellTags->"BuiltIn"]
}, Open  ]],

Cell["4.4 Properties", "Subsection",
  CellTags->{"Properties", "i:13"}],

Cell["4.4.1 Surjectivity and injectivity", "Subsubsection",
  CellTags->"Properties"],

Cell[TextData[{
  "There are two standard properties of functions that are often of interest. \
A function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\  : \ A\), " ", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], " ", "B"}], TraditionalForm]]],
  " is said to be ",
  StyleBox["injective",
    FontSlant->"Italic"],
  " if ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\  = \ f(y)\)]],
  " implies ",
  Cell[BoxData[
      \(TraditionalForm\`x\  = \ y\)]],
  " and ",
  StyleBox["surjective",
    FontSlant->"Italic"],
  " if for all ",
  Cell[BoxData[
      \(TraditionalForm\`b\  \[Element] \ B\)]],
  " there exists an ",
  Cell[BoxData[
      \(TraditionalForm\`a\  \[Element] \ A\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`f(a)\  = \ b\)]],
  "."
}], "Text",
  CellTags->"Properties"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InjectiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["injective",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  StyleBox[
                    RowBox[{
                      StyleBox["one",
                        SingleLetterItalics->False], 
                      StyleBox["\[Hyphen]",
                        "Text",
                        SingleLetterItalics->False], 
                      StyleBox["to\[Hyphen]one",
                        SingleLetterItalics->False]}]], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["SurjectiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], " ", 
                FormBox["f",
                  "TraditionalForm"], 
                StyleBox[\(\ is\ surjective\ \((onto)\), \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["OneToOneQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["InjectiveQ",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["f",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["OntoQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["SurjectiveQ",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["f",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Properties", "i:14"}],

Cell["Basic properties of functions.", "Caption",
  CellTags->"Properties"],

Cell[TextData[{
  "As is the case over the integers, the squaring function is also not \
injective over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_10\)]],
  "."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InjectiveQ[f\  = \ FormMorphoid[Mod[#^2, \ 10]&, \ Z[10], \ Z[10]]]\)], 
  "Input",
  CellLabel->"In[39]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"Properties"]
}, Open  ]],

Cell["Here is a way of seeing why injectivity fails.", "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(VisualizeMorphoid[f, \ ColorCodomain\  \[Rule] \ Automatic]; \)\)], 
  "Input",
  CellLabel->"In[40]:=",
  CellTags->"Properties"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .63492 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.10582 0.10582 0.10582 [
[ 0 0 0 0 ]
[ 1 .63492 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .63492 L
0 .63492 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[10])] .5 .58201 0 0 Mshowa
[(0)] .02381 .5291 0 0 Mshowa
[(1)] .12963 .5291 0 0 Mshowa
[(2)] .23545 .5291 0 0 Mshowa
[(3)] .34127 .5291 0 0 Mshowa
[(4)] .44709 .5291 0 0 Mshowa
[(5)] .55291 .5291 0 0 Mshowa
[(6)] .65873 .5291 0 0 Mshowa
[(7)] .76455 .5291 0 0 Mshowa
[(8)] .87037 .5291 0 0 Mshowa
[(9)] .97619 .5291 0 0 Mshowa
[(Z[10])] .5 .05291 0 0 Mshowa
[(0)] .02381 .10582 0 0 Mshowa
[(1)] .12963 .10582 0 0 Mshowa
[(2)] .23545 .10582 0 0 Mshowa
[(3)] .34127 .10582 0 0 Mshowa
[(4)] .44709 .10582 0 0 Mshowa
[(5)] .55291 .10582 0 0 Mshowa
[(6)] .65873 .10582 0 0 Mshowa
[(7)] .76455 .10582 0 0 Mshowa
[(8)] .87037 .10582 0 0 Mshowa
[(9)] .97619 .10582 0 0 Mshowa
1 .6 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .49735 m
.02381 .13757 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.8 1 0 r
.12963 .49735 m
.12963 .13757 L
s
% Start of user PostScript
1. 3.7 1. 0.3 MAarrowhead1
% End of user PostScript
0 1 1 r
.23545 .49735 m
.44709 .13757 L
s
% Start of user PostScript
2. 3.7 4. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.34127 .49735 m
.97619 .13757 L
s
% Start of user PostScript
3. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
.2 0 1 r
.44709 .49735 m
.65873 .13757 L
s
% Start of user PostScript
4. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 .4 1 r
.55291 .49735 m
.55291 .13757 L
s
% Start of user PostScript
5. 3.7 5. 0.3 MAarrowhead1
% End of user PostScript
.2 0 1 r
.65873 .49735 m
.65873 .13757 L
s
% Start of user PostScript
6. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.76455 .49735 m
.97619 .13757 L
s
% Start of user PostScript
7. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
0 1 1 r
.87037 .49735 m
.44709 .13757 L
s
% Start of user PostScript
8. 3.7 4. 0.3 MAarrowhead1
% End of user PostScript
.8 1 0 r
.97619 .49735 m
.12963 .13757 L
s
% Start of user PostScript
9. 3.7 1. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[40]:=",
  ImageSize->{288, 182.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000]PP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003o
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000R>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP82o`0@iP;V0^H2iP;V0^H2iP;V0P;o08?V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000PNH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP04o`08
0^H2o`;V0^H3o`04iP;V0P;o08WV0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooKomYKf
ooJFmYKfooJFmYKoU_KomYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;o0^H2
iP;o0^H2i_oV0_l2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFm_ofU_JFm_of
U_JFoiKfooJFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Koi_oV0^H2o`;V0^H2o`;V0^Ko
iP;o0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000PIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP04o`03mYKf00;o00>FmYH00_l01OJF
mYKf00;o00BFmYKf0_l0PiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P4000001YKf
U_JFmP;o01^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00ol06iKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP04o`0KmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00?o01cfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0ol06YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0ol07?JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH2o`0kmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_H00_l06iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP03o`07U_JFmYKf
UP0100000?oV0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;o0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VonH2o`;V0^H0023V0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000OYKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmPCo09BFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm_ofU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0ol01_JFmYKfUP400000HNH2
iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l0>@;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0_l2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P03o`0K0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H200?o03/2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0P02o`0UiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2o`;V0^H2iP010000
0?nFmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_Kom_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFoiKfooJFmYH0022FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP4000001^H2
iP;V0P;o01_V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l07@;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H200;o01cV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol070;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2o`0K0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200Co01_V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H00ol06nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP04o`0K0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H200;o01cV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20_l01nH2
iP;V0^H00@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003o
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000P>H2iP;V0^JO
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOg]oNgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0P40TnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP037`07iP;V0^H2iP01000007nFmYKfU_JFGiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKNgmkOg]oNgmkOmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00D1
08jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf1Ql01iKfU_JFmYH00@00001niP;V0^H2iYoV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2i]oV0]kOg]oNgmkOg]oNgmh2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H22040R>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC442iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8:7`07iP;V0^H2iP01000007fFmYKfU_JOGiofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_KOg]ofU]kOg]oNgmkOg]oNgoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP030@03U_H100D108>FmYKfU_JFmYKfU_JFmYKf
U_JFmYK0P<2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTa1C46FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0<7`08
mYKfU_JFmYH1000000KV0^H2iP83W`1c0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g]oN0^H2i]oN
gmkOg]oNgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0P040@03iP8100H101@2iP;V0^H2iP;V0^H2iP;V0^H2iP>006WV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC45<@DcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H03Ql020;V0^H2iP;V0@00001k
U_JFmYKfWenOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfgmkOmYKfU_KOg]oNgmkOgYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF00D100>FmYH02040O_JFmYKfU_JFmYKfU_JFmYKfU/20`9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mTa1C45<@IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUPhO00SfU_JFmYKfUP4000001NH2iP;V00BO0742iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2i]oNgmkOiP;V0^KOg]oNgmkOgP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P050@050^H2iP802@4040;V
0^H2iP;V0^H2iP;V0^H4P01Y0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTa1C45<@Da10^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H200`O00WV0^H2iP;V0^H00@00001iU_JFmYIOWenOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKN
gmkOgYKfU_JFmYKNgmkOmYKNgmjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP060@05mYKfU_H02P40O9KfU_JFmYKfU_JFmYKfU/20`83f
U_JFmYKfU_JFmYKfU_JFmYKfU_I<@Da1C45<@DcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H<7`09U_JFmYKfU_JF0040
00001NH2iP;V00FO06kV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgmkOg]oV0^H2iP;V0]kOgP;V0^H2
g]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0PL100H2iP;V0^H80@0?0^H2iP;V0^H2iP;V0^H200F006L2iP;V0^H2iP;V0^H2iP;V0^H2iTa1
C45<@Da1C442iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2008O00?V7al02Al02NH2iP;V0^H2iP01000007NFmYKfUUnOGimO
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]kOg]oNU_JFmYKfU_JFgYKfU_JFmYKfgmjFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP080@07mYKfU_JF
mP060@1jU_JFmYKfU_JFmYKfU_JFmX30P<20mYKfU_JFmYKfU_JFmYKfU_JFmTa1C45<@Da1C45<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H27`04U_JFmPXO00VFmYKfU_JFmYH00@000004iP;V0PJO06cV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;NgmkOg]oN0^H2iP;V0^H2iP;V0^H2iP;V0]kOgP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP880@08iP;V0^H2iP850@0A0P42iP;V0^H2iP;V
0^H2iP801X00JnH2iP;V0^H2iP;V0^H2iP;VC45<@Da1C45<@Da1C>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V00PO
00X2iP;V0^H2iP;V0@00001eU_JFmYmOWenOGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]oNgmkOg]of
U_JFmYKfU_JFmYKfU_JFmYKfU_JFg]ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00T100VFmYKfU_JFmYH00`400iKfUP020@1dmYKfU_JFmYKfU_JFmX30P<20
`9KfU_JFmYKfU_JFmYKfU_I<@Da1C45<@Da1C45<@IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH27`08mYKfU_JFmYH87`0:mYKfU_JF
mYKfUP4000001>H2iP86W`1]iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g]oNgmkOgP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2i]oN0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP070@0NiP;V0^H2iP;V0P42iP;V0^H1iP;V0^H2iP;V0^H21X00GnH2iP;V0^H2iP;V0^H2
iP;V0T5<@Da1C45<@Da1C>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V008O00`2iP;V0^H2iP;V0^H67`0:0^H2iP;V0^H2iP400000NIKf
UUnOGimOWenOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]kOg]oNgmkOgYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKNgmjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
1040P_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU/20`830P<20mYKfU_JFmYKfU_JFmYKfU_JF
@Da1C45<@Da1C45<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH27`0?mYKfU_JFmYKfU_JFmYKf00@O00^FmYKfU_JFmYKfUP01000000?V0^H0
29l0T0;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOg]oNgmkOg]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2g]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H20@;V
0^H2iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2iPR007`2iP;V0^H2iP;V0^H2iP;V0T42iP91C45<@Da1
C442iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H27`;V0^H2iP;V0^H2iP;V0^HOiP;V7nH2iP;V0^H2iP;V0@00003lU_JFmYKfUUnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfgmjFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1mYKfU_JFmYKfU_J0mYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0Ql08IKf
U_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfUP0100000?[V0^H2iP;VWnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]kOgP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H1iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0T42iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20Ql08nH2iP;V0^H2
iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V00400000U9KfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFg]ofU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H20@1RU_JFmYKfU_J0mYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H27`0UU_JFmYKfU_JFmYKf
U_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfUP0100000?KV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vgmh2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP810^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2@@;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP827`0WiP;V0^H2iP;V0^H2iP;V0^H2
iP;V7nH2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]kOgYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1
U_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKfUT6FmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfUP0089KfU_JFmYIOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003ciP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g]oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2
iP:00^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V008O02X2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V
0^H2iP;V0^H2iP;V0^H100000?6FmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]oNgoJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmX3f
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF008O02cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JF
mYKfU_JFmYKfUP400000knH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vgmh2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2P0;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V008O02h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V
0^H2iP;V0@00002KU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]kOmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00P40P_J0mYKfU_JF
mYKfU_JFmYKfUT6FmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JF
mYH100000>cV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOg]oV0^H2iP;V0^H2iP;V0^H2
iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0H02iP;V0^H2iP;V0^H2
iP910^H2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P8O037V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
0000jYKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]oNU_JFmYKfU_JFmYKfU_JF0IKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP8O
03>FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003X
iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;NgnH2iP;V0^H2iP;V0^H1iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP:00NH2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P8O03GV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKf
U_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfgmkOmYKfU_JFmYKf0OJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3f0OJFmYKfU_JFmYKfUT6FmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000iNH2iP;V0^JO
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOgP;V0^H2iP810^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0NH2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2
@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00Ql0>0;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00002RU_JFmYKfUUnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFg]ofU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKf0P40?iKfU_JFmYI1U_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP027`0jmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000hNH2iP;V0^JOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgmkOiP7V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0^H20@;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2@@;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP027`0l0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00003oU_JFmYKfUUnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KOgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKfU_JF0IKfU_I<mYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000=kV0^H2iP;VWnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2g]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0X02iP;V0^H20@;V0T42iP;V0^H2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP827`0oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000g9KfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFm]oNgoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfP?JFmYKfU_JF0II1U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H27`11U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00002XiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H2iP;Vgmh2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP:00^H2iP;V0^H20P40<>H2iP;V0^H2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P8O04?V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFg]ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfP?JFmYKfU_JFmTcf0OJFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYIOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003GiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2i]oNgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP:00^H2iP;V0^I<iP;V0NH2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0Ql0AP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H100000=FFmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfgmjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3f
U_JFmYKfUT6FmYKf0OJFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00Ql0B?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000dnH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP810^H2iP;V0^H2iP;V0^H2iP;V0]kOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0^H2
iP910^H2iP;V0NH2iP;V0^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00Ql0BP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@00003oU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KOg]ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKfU_JFmTcf
U_JFmYKf0OJFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H100000:oV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2i]oN0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0X02iP;V0^I<iP;V0^H2
iP;V008101l2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2008O04gV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP0100000<jFmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFg]oNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFmTcfU_JFmYKf
U_JFmYH1U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmP8O04nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0040
0000c>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;NgnH2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0^H2@@;V0^H2iP;V0^H2
iP810^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0P8O057V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003o
U_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfgmjFmYKfU_JFmYKfU_JFmYKfU_J0mYKfUT6FmYKfU_JFmYKfU_JFmYH1
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_HO000PU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000<WV0^H2
iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0]kOgP;V0^H2iP;V0^H2iP;V0X02iP;VC>H2iP;V0^H2iP;V0^H2iP810^H2
iP;V0T42iP;V0^H2iP;V0^H00Ql0E0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000aiKfU_JFmYIO
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFg]ofU_JFmYKfU_JFmYKfP?JFmTcfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKf
C?JFmYKfU_JFmYH00Ql0E_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00002fiP;V0^H2iYoV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2i]oN0^H2iP;V0^H2iP:00^I<iP;V0^H2iP;V0^H2iP;V0^H2iP820@0=iP;V0T42
iP;V0^H2iP027`1H0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFmYIOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU]kOgYKfU_JFmYKfP?JF@IKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfC?JFmYKf
U_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQof
UP0089KfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000032iP;V0^H2iYoV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2g]oV0^H2iP:00T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP910^H2iP827`1K
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000<2FmYKfU_JFGiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm]oNU_JFmX3fC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mTcfU_H27`1MU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000_^H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;Ngmh2P4cV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1@@827`1OiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00002lU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]kO@IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H20@1QU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0X3OgP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7d420@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H0023V0^H2iP;VWnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000^IKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKN
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI1
P?JFg]oNU_JFmYKfU_JFmYKfU_JFmYKfU_JF008O06CfC?JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00002giP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTb00^H2
iP;NgnH2iP;V0^H2iP;V0^H2iP;V008O06H2iP910^H20@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H100000;FFmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mX3fU_JFmYKf
gmjFmYKfU_JFmYKfU_JF008O06SfU_JFmTcfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000onH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T42P0;V0^H2iP;V0]kO
gP;V0^H2iP;V0Ql2iP;V0^H2@@;V0^H20@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP008>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00002bU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI1U_J0mYKfU_JFmYKfU_JFg]of
U_JFmP8O00nFmYKfU_JFmTcfU_JFmYH00P40F_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP40
0000/>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2P0;V0^H2iP;V0^H2iP;Vgmh2
0Ql0KNH2iP;V0^H2iP910^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003o
U_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_J0mYKfU_JFmYKfU_JFmYKf7mkOgYKf
U_JFmYKfU_I<mYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYHOU_JFmYKfU_JF000PU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2
iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0X02iP;V0^H2iP;V0^H2iQoV0^H2g]oV0^H2
iP;V0T42iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
7`;V0^H2iP;V0^H0023V0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000ZiKfU_JFmYIO
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUT6FmYKfP?JFmYKfU_JFmYKfUP027`1bmYKfU_JFm]oNU_JF
mYKfC?JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HO
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00002YiP;V0^H2iYoV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP:00^H2iP;V0^H2iP027`1d0^H2iP;V0^H2iP;Ngmh2iP91
0^H2iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000:NFmYKfU_JFGiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmX3fU_JFmYKfUP027`0QmYKfU_JFmYKfU_JFmYKfU]kOmTcfU_JF
mYKfU_JFmYKf008105>FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;VWnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0X02iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;VgmkOiP;V0^H2
iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H0
023V0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000Y9KfU_JFmYIOU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfP?JFmYKf0Ql0NIKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<m]oNU_JFmYKf
U_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00002RiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2@@;V0^H2iP:00^H20Ql0NnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T42iP;NgnH2iP;V0^H2
iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000:2FmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UT6FmYKfU_JFmX3f0Ql0OIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfgmkOmYKfU_JFmYKf
UP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2P1oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2@@;V0^H2iP;Vgmh2iP;V0^H2iP810^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP008>H2iP;V0^JOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@00003AU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
UQn0mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU]kOmYKfU_JFmYH00P40C?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH1000009_V0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2@@;V0^H2iP027`22
0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^KOg]oV0^H2iP;V0NH2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000VIKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUT6FmYKfUP027`24mYKfP?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFm]oNU_JFmYKf0OJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@00003oiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP8O0^H2iP:00^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;NgnH2iP;V0NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81000009JFmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_H27`27U_JFmYKfP?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_KOg]ofU_H1mYKfU_JFmYKfU_JFmYKf
U_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0040
0000U>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP827`11iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oN0^H00P40AP;V0^H2iP;V0^H2iP;V
0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H10000
09:FmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF@@8O08^FmYKfU_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]kOmYH1U_JFmYKfU_JFmYKfU_JFmYKf
7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2
iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T4OiP;V0^H2iP;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgmkO0@;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKf
UUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI17oJFmYKfU_JFmYKfU_J0mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KOgYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000008gV0^H2iP;VWnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00Ql0T4cV0^H2iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g]oV0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000RiKfU_JFmYIOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00Ql0T_I<mYKfU_JFmYKfU_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0MoNgoJFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003NiP;V0^H2iYoV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
7`;V0T42iP;V0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20P40?nKOgP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000008RFmYKfU_JFGiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0Ql0UIKf
UT6FmYKfU_JFmYKfU_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0OJFg]ofU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000Q^H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20Ql0UnH2iP;VC>H2
iP;V0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2i]oNgal2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000024U_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0Ql0VIKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0OJFmYHOgmjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP7V0Ql2iP;Ngmh2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;VWnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000PIKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKN
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP027`2LmYKfU_JFmYI1U_JFmYKfU_JFmYKfU_JF
mYKfP?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP7f7oJFmYKfU]kOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00001oiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP027`1T0^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP:0
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP8103P2iP;V0^H2i]oN0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000OIKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF008O0:3fU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfP?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYHOUP6FmYKfU_JFmYKNgmjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@00001kiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V008O0:82iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP:00^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H27`;V0P42iP;V0^H2iP;V0]kOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H100000?nFmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKf
UP6FmYKfU_JFmYKfU_KOgYKfU_JFmYH0022FmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000N>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P8O0:GV0^H2iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2
0@;V0^H2iP;V0^H2iP;Ngmh2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00001f
U_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP8O
0:NFmYKfU_JFmYKfU_JFmYI1U_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JF0IKf
U_JFmYKfU_JFmYKfU]kOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000007CV0^H2
iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P8O07KV0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H20P40<NH2
iP;V0^H2iP;V0^H2i]oN0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003oU_JFmYKf
UUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmP7fU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000077V0^H2iP;VWnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP027`2/0^H2iP;V0^H2iP;V
0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP7V0^H2iP;V
0^H2iP;V0^H2iP;NgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000KiKfU_JFmYIOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP027`2^mYKfU_JFmYKfU_JFmYKfU_JF
mYI1U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JF
mYKfU_JFmYKfgmjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00001]iP;V0^H2iYoV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP027`2`0^H2iP;V0^H2iP;V0^H2iP;V0^H2@@;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V
0^H2iP;V0]kOgP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?:FmYKfU_JFGiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmP8102^FmYKfU_JFmYKfU_JFmYKf
U_JFmYKNgoJFmYKfU_JFmYKfU_JFmYKfU_JF00400000J^H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP827`2ciP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2
iP;Vgmh2iP;V0^H2iP;V0^H2iP;V0^H00@00001XU_JFmYKfUUnFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H27`2eU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUT6FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP6FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U]kOgYKfU_JFmYKfU_JFmYKfUP01000006KV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP827`2giP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
g]oV0^H2iP;V0^H2iP;V00400000oiKfU_JFmYIOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKN
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUT6FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
P?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmYKfUP0089KfU_JFmYIOU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00001SiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V008O
0;X2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP:0
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g]oN
0^H2iP;V0^H100000?nFmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1U_JFmYH0022FmYKfU_JFGiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP4000001^H2iP;V0P;o01_V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00ol06nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP04o`0K
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200?o01`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0ol06^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol070;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2o`0k0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP800_l06nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP03o`07iP;V0^H2iP0100000?nFmYKf
U_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_KomYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFoiKfooJFmYH0022FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000O^H2iP;VonH2
o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PCo
09CV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko
iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol01P;V0^H2iP400000HIKfU_JFoiKfooJFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00_l0>OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofooJF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP03o`0KmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00?o
03_fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mP02o`0UU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfooJFmYKfUP0100000?oV0^H2i_oV0_l2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0_l2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0_l2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2
o`;V0^H0023V0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P4000001YKfU_JFmP;o01^FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00_l07OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00;o
01bFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0ol07?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH2o`0KmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00Co01^FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00ol06iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP04o`0KmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKf00;o01bFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0_l01iKfU_JFmYH00@00003o
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81000008RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0_l049KfU_JFmYKf
U_JFmYKfU_H2o`23U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2
iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP810000086FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH01?l02?JFm_ofU_JF0ol019KfU_H2o`29
U_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2o`;V0_l2iP;V0_l2iP;VonH2o`;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfooJFmYKfooJFmYKoU_KomYKfU_nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;o0^H2iP;o0^H2i_oV0_l2iP;VonH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKoU_JFm_ofU_JFm_ofU_JFoiKfooJFmYKoU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H10000087V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H01?l00`;V0P02o`03iP;V00;o00D2iP;V0P02o`04iP;V0P;o08?V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP810000\
\>"],
  ImageRangeCache->{{{0, 287}, {181.812, 0}} -> {-0.235691, -1.00003, 
  0.0330014, 0.0330014}},
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      RowBox[{
        StyleBox["ZMap",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["m",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox["n",
            "TI"]}], 
        StyleBox["]",
          "MR"]}]], "Input"],
  " is always surjective as long as ",
  Cell[BoxData[
      \(TraditionalForm\`m\  \[GreaterEqual] \ n\)]],
  "."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SurjectiveQ[g\  = \ ZMap[12, \ 5]]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "The reason for the surjectivity is simple: there are enough elements in \
the domain to cover the codomain, since the map sends ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(VisualizeMorphoid[g, \ ColorDomain\  \[Rule] \ Automatic]; \)\)], 
  "Input",
  CellLabel->"In[42]:=",
  CellTags->"Properties"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .51948 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.0865801 0.0865801 0.0865801 [
[ 0 0 0 0 ]
[ 1 .51948 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .51948 L
0 .51948 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[12])] .5 .47619 0 0 Mshowa
[(0)] .02381 .4329 0 0 Mshowa
[(1)] .11039 .4329 0 0 Mshowa
[(2)] .19697 .4329 0 0 Mshowa
[(3)] .28355 .4329 0 0 Mshowa
[(4)] .37013 .4329 0 0 Mshowa
[(5)] .45671 .4329 0 0 Mshowa
[(6)] .54329 .4329 0 0 Mshowa
[(7)] .62987 .4329 0 0 Mshowa
[(8)] .71645 .4329 0 0 Mshowa
[(9)] .80303 .4329 0 0 Mshowa
[(10)] .88961 .4329 0 0 Mshowa
[(11)] .97619 .4329 0 0 Mshowa
[(Z[5])] .5 .04329 0 0 Mshowa
[(0)] .02381 .08658 0 0 Mshowa
[(1)] .2316 .08658 0 0 Mshowa
[(2)] .43939 .08658 0 0 Mshowa
[(3)] .64719 .08658 0 0 Mshowa
[(4)] .85498 .08658 0 0 Mshowa
1 .5 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .40693 m
.02381 .11255 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 1 0 r
.11039 .40693 m
.2316 .11255 L
s
% Start of user PostScript
1. 3.7 2.4 0.3 MAarrowhead1
% End of user PostScript
.5 1 0 r
.19697 .40693 m
.43939 .11255 L
s
% Start of user PostScript
2. 3.7 4.8 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.28355 .40693 m
.64719 .11255 L
s
% Start of user PostScript
3. 3.7 7.2 0.3 MAarrowhead1
% End of user PostScript
0 1 .5 r
.37013 .40693 m
.85498 .11255 L
s
% Start of user PostScript
4. 3.7 9.6 0.3 MAarrowhead1
% End of user PostScript
0 1 1 r
.45671 .40693 m
.02381 .11255 L
s
% Start of user PostScript
5. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 .5 1 r
.54329 .40693 m
.2316 .11255 L
s
% Start of user PostScript
6. 3.7 2.4 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.62987 .40693 m
.43939 .11255 L
s
% Start of user PostScript
7. 3.7 4.8 0.3 MAarrowhead1
% End of user PostScript
.5 0 1 r
.71645 .40693 m
.64719 .11255 L
s
% Start of user PostScript
8. 3.7 7.2 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.80303 .40693 m
.85498 .11255 L
s
% Start of user PostScript
9. 3.7 9.6 0.3 MAarrowhead1
% End of user PostScript
1 0 .5 r
.88961 .40693 m
.02381 .11255 L
s
% Start of user PostScript
10. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.97619 .40693 m
.2316 .11255 L
s
% Start of user PostScript
11. 3.7 2.4 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[42]:=",
  ImageSize->{288, 149.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000U@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000RnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l02P;V0^H2iP;V0^H2o`260^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H10000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000Q>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0PCo00SV0^KoiP;V0P?o08`2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKoU_nFmYKoU_JFmYKfU_nFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i_oV0^H2i_oV0^H2iP;VonH2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000092FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_JFoiKfU_H3o`2<mYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0_l2iP;VonH2
iP;o0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000Q9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPCo00>FmYH00_l00oJF
mP04o`03U_JF00;o08KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@000006U_JFmYKf0_l0>9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0ol0>OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP04o`0gU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP03o`0jU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP?o02SfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
0@00003oiP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KoiP;V0^H2iP;V000PiP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?>FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01?l0:?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH100000;SV0^H2
i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0_l0INH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i_oVonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFoiKf
ooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKo
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFoiKf
U_JFmYKfUP0089KfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000006iP;V0^H20_l0>>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20_l0>nH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;o
03P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP?o
03[V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0_l0:NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000@^H2iP;V0^Ho;cl_?blo;coV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PDO0=P2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KNC0;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]1>iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V2>1?iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000000NFmYKfU_JF008103/o;cl_?blo;cl_?blo;oJF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_J0`00:7`0`U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]7N0T`0=YKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP?@06I>U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH8h0SP2>1?U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH1000000SV0^H2iP;VW`8103L_?blo;cl_?blo;cl_0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;O00?0P1l031l0;>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vg]7N0d`0<`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P05d00kCT42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2h0SP2>08h0P00Tl0:NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V004000002IKfU_JFmUnOG`030@0d;cl_?blo;cl_?iKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP?O00?fP<0031l0;IKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU]kAg]7NUP03C00_U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH01m00?9I>@OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm^08h0SP2>08h0SPmP9?02VFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000000[V0^H2iP9OWel20`40<Sl_?blo;cl_?nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V1=l01@:0`83000TO02h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;Ag]7Nd@;V14`0;0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V2=00?0;VCT5>iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2h0SP
2>08h0SP2>08iP=?02WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP010000
00^FmYKfU_IOWeofUP040@0`?blo;cl_?bloU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0ml01iKfU/20`80021l0;_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
g]7NdMkAmYH5C00YU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH02]00??JF
CT5>U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfh0SP2>08h0SP2>3fUP=?
02VFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000000cV0^H2iYmOWel2
iP840@0^;cl_?bl1iP8_?bl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PCO00SV0^K0
P<20`0HO033V7al2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vg]7NdMkAg^H2iP85C00W
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200[@03cV0^I>@Di10^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V2>08h0SP2>08iP84C`0YiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000=U_JFmYJOGimOmYKfUP050@0[;cl_mYKf
U_JF?bloU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP05g`0:U_JFmX30P<20`0@O00>FmYH0
0al0:YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]7NdMkAg]7fU_JFmPI<02JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPW@03gfU_JFCT5>@DjFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUPSP2>08h0SPmYKf00A?02VFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP01000000kV0^H2iYmOWenOiP;V0PD102To0@;V0^H2iP;V0Rlo;`;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P06g`0;iP;V0^K0P<20`8000al01^H2iP;V0P<O02L2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]kAg]7NdMkA0^H2iP801d`09P;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V1m00?NH2iP;VCT5>@DkV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iPSP2>08h0SV0^H01Tl0:0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H1000000nFmYKfUYmOWenOU_JFmYH01@40:9H1U_JFmYKfU_JFmYHo;cnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H6g`0GU_JFmYK0P<20`8307oJFmYKfU_JFmYH00Ql09OJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfdMkAg]7NdMjFmYKfU_H024`09IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01m00?IKfU_JFCT5>@Di1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH8
h?JF2>08h?JFmYH01Tl0:?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH10000
013V0^H2GimOWenOiP;V0^H20`400`;V0P020@0SiP;V0^H2iP;V0^H2;cl_0^H2iP;V0^H2iP;V0^H2
iP;V0^H01ml06NH2iP;V0X30P<20`>H2iP;V0^H2iP;V0^H00al08nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;Ag]7NdMkV0^H2iP;V00Q<02D2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]0200G@
03d2iP;V0^I>@Di1CT42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2h0;V0^H8h0SV
0^H200M?02P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000jU_JFmUnO
GimOWiKfU_JFmYH1U_JFmYKf0OJFmYKfU_JFmYKfU_JF?bloU_JFmYKfU_JFmYKfU_JFmPSO01bFmYKf
U_J0`830P?J0mYKfU_JFmYKfU_JFmYKf0Ql08IKfU_JFmYKfU_JFmYKfU_JFmYKfU]kAg]7fU_JFmYKf
UP06C00XmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFd9KfUP?@03jFmYKfU_JFCT5>
@Di1CYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KP29KfU_JFm^3fU_JFmPM?02SfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00000iiP;V0UnOGimOWnH2iP;V0^H2
iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2;cl_0^H2iP;V0^H2iP;V00SO01l2iP;V0^H2i/20`>H2i/3V
0^H2iP;V0^H2iP;V0^H200<O01h2iP;V0^H2iP;V0^H2iP;V0]42dMkA0^H2iP;V0^H5C01YiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2d0;V0^H2iP;VCT5>@Di1C^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2h0SV0^H2iP;V0^H2iP;V00Q?02P2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000JU_JFWenOGimOWeofU_JFmYKfU_JFmYKfU_H20@0O
U_JFmYKfU_JFmYKfU_JFmYHo;cnFmYKfU_JFmYKfUP06g`0RmYKfU_JFmYKfP?JFmYKfP?JFmYKfU_JF
mYKfU_JFmYKfUP8O01gfU_JFmYKfU_JFmYKfU_KAmYKNU_JFmYKfU_JFmP02C00TU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00AIKfU_JFmYKfU_JFmYKfUTi1CT5>@Di1mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF29KfU_JFmYKfU_JFmYKfUP08C`0XmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000?NH2iYmOWenOGimO0^H2iP;V0^H2iP;V0^H2iP810^H2
iP;V0^H2iP;V0^H2iP;V0Rlo;`;V0^H2iP;V0^H01=l090;V0^H2iP;V0^H2iP;V0^K0iP;V0^H2iP;V
0^H2iP;V0^H2iP<O08KV0^H2iP;V0^H2i]kV0^H2iP;V0^H2iP;V0T`2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^I>@Di1C^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H8h0;V0^H2iP;V0^H2iP;V0PU?02P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@00000MU_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKfU_JFmYH00P40BOJFmYKfU_JF
mYKfU_JFmYKfU_JF?bloU_JFmYKfgoJFm]ofU_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JF
mYKfU_H00Ql0R9KfU_JFmYKfdOJFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYI>@OI1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF2>3fU_JFmYKfU_JFmYKfU_JFmYKfU_H5C`0XmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000J^H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0Rlo;`;V0]l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V`>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP837`2b0^H2i]kV0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I>iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^02iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP40000089KfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0P40BiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF?boOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfP<2FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP027`0dm]7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP;@
07[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI>U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KP29KfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000KnH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V?bloiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP037`2]iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;VC^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^08iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@00000SU_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00P40COJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKOU_H_?bofU_JFmYKfU_JFmYKfU_JFmYKfU_JF`9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
gYKf008O0:^FmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYK@U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFCYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF29KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0@00001diP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2
iP;V0]l2iP;V0^Ho;coV0^H2iP;V0^H2iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;A0^H2
iP837`2X0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;@0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H8h0;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000V
U_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H20@1?U_JFmYKfU_JFmYKfU_JFmYKf
goJFmYKfU_JFmRlo;oJFmYKfU_JFmYKfU_JFmYKfU/2FmYKfU_JFmYKfU_JFmYKfU_JFgYKfU_JFmYKf
UP037`0TU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf0]00OiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmT7fU_JFmYKfU_JFmYKfU_JFmYH8h?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00001j
iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V0^H2iP;VgnH2
iP;V0^H2iP;V0^Ho;coV0^H2iP;V0^H2iP;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2d@;V0^H2iP;V0^H2
iP827`2SiP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2h0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000002VFmYKf
U_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP020@1AmYKfU_JFmYKfU_JFmYKOU_JF
mYKfU_JFmYKfU_JFmRlo;oJFmYKfU_JFmYKfU_JF`9KfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JF
mYKf00<O0:3fU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_I1mYKfU_JFmYKfU_JFmYKfh0RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00001oiP;V0^H2
iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;O0^H2iP;V0^H2
iP;V0^H2iP;V0^Ho;coV0^H2iP;V0^H2iP:00^H2iP;V0^H2iP;V0]42iP;V0^H2iP;V0^H2iP;V0^H2
iP027`2N0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^I>iP;V0^H2iP;V0^H2h0SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1000002bFmYKfU_JFWiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP8105>FmYKfU_JFmYKfgoJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf;cl_mYKfU_JFmYKfU/2FmYKfU_JFmYKfU_KAmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP037`0EU_JFmYKfU_JFmTcfU_JFmYKfU_JF00;@08CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYI>U_JFmYKfU_JFmYH8U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000008CV0^H2iP;VWnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H2iP;V0]l2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iSl_?nH2iP;V0^H2P0;V0^H2iP;V0^KNiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP827`2IiP;V0^H2iP9<0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC^H2iP;V0^H2iPSP0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000;iKfU_JFmYJOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF008105GfU_JFmYKOU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKf;cl_mYKfU_JF`9KfU_JFmYKfdOJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf00<O09KfU_JFmYI<U_JFmYKfU]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI>U_JFmYKfUPSPmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000008WV0^H2iP;VWnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iSl_?nH2iP:00^H2iP;Vg^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP027`2D0^H2iP9<0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP91
0^H2iP;P0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000<YKfU_JFmYJOU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0P40EiKfgoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H_?bofU/2FmYKfdOJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP037`06U_I<mYKf0]00RIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmT7f
U_KP29KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000S^H2iP;V0^JOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810]l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V?bloP0;Vg^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP827`2?iTcVd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2@@;V2>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00000eU_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00P40FOJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_H_?boNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf00<O08cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I12>3fU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000TnH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH1iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP:0?bloiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K@
C0027`2:0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V2>1>iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00002EU_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKOU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFgYK0U_H_?bofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFC9H0
0al0QiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfh?JFCYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP01000003WV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2g`;V0^H00P40D`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0]42iP:0`>H2iSl_0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200;@00SV0^H2
C0;V0P8O08GV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2h0SV0^I>iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000VYKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KOmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKNU_JFmYKfP?JFmYHo;cnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FmYKfU_I<mYKf
U_H37`22mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KP29KfU_JFCYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP400000?>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;O0^H2iP;V0P8105oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
d@;V0^H2iP;V`>H2iP;V0Rlo;`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;@0^H2iP;V0^I<iP;V0^H2
iP037`1oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPSV0^H2iP;VC^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP0100000:2FmYKfU_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKOU_JFmYKfU_JFmP7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KAmYKf
U_JFmYKfP?JFmYKfU_JF?bloU_JFmYKfU_JFmYKfU_JFmYKfU_JFd9KfU_JFmYKfUTbFmYKfU_JFmYKf
0Ql0OIKfU_JFmYKfU_JFmYKfU_JFmYKfUPSPmYKfU_JFmYKf@OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00400000?nH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i]oV0^H2iP;V0^H2iP020@180^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vg^H2iP;V
0^H2iP;V`>H2iP;V0^H2iP8_?bl2iP;V0^H2iP;V0^H2iP;V0]005`;V0^H2iP;V0^H2C0;V0^H2iP;V
0^H200<O07X2iP;V0^H2iP;V0^H2iP;V2>02iP;V0^H2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000YIKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfgoJFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KAmYKfU_JFmYKf
U_JFmX3fU_JFmYKfU_JFmYHo;cnFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
UP027`1hmYKfU_JFmYKfU_JFm^3fU_JFmYKfU_JFmYKf@OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@000012iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;O0^H2iP;V0^H2iP;V0^H20P40HnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KNiP;V0^H2iP;V0^H2
iP;V`>H2iP;V0^H2iP;V0^H2;cl_0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP037`1eiP;V0^H2iP;P2>H2iP;V0^H2iP;V0^H2@@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00400000ZYKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
goJFmYKfU_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfdOJFmYKfU_JFmYKfU_JFmYKf
P?JFmYKfU_JFmYKfU_JFmYHo;cnFmYKfd?JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
0Ql0LiKfU_KP29KfU_JFmYKfU_JFmYKfU_JFCYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0@000015iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2
iP;V0^H2iP;V0^H2iP;V008106D2iP;V0^H2iP;V0^H2iP;V0^H2i]kV0^H2iP;V0^H2iP;V0^H2iP;V
`>H2iP;V0^H2iP;V0^H2iP;V0Rlo;m3V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V
0P037`1`2>H2iP;V0^H2iP;V0^H2iP;V0^I>iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP40
0000[iKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKOU_JFmYKf
U_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKf
U_JFmYKfU_JFmYKfU_JFd9Ho;cnFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JF2>00
0Ql0K_JFmYKfU_JFmYKfU_JFmYKfUTjFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000018
iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g`;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20P40InH2iP;V0^H2iP;V0^H2iP;A0^H2iP;V0^H2iP;V0^H2iP;V0^H2i/3V0^H2
iP;V0^H2iP;V0^H2d0;V0^H2;cl_0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H8h0;V0^H0
0al0JnH2iP;V0^H2iP;V0^H2iTkV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000]9Kf
U_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]ofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0OJFmYKfU_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFmYKf
U_JFmYKfU]2FmYKfU_JFmYHo;cnFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfh?JFmYKfU_JFmP8O
06VFmYKfU_JFmYKfU_JFmT7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00001;iP;V0^H2
iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00810382iP;V0^H2iP;V0]42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i/3V0^H2iP;V
0^H2iP;@03D2iP;V0^H2iP;V0^H2;cl_0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;P2>H2iP;V0^H2iP;V
0P037`1V0^H2iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00002iU_JFmYKf
UYnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH1U_JFmYKfU_JFgYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKfU_JFmYKf
d?JFmYKfU_JFmYKfU_JFmYKfUSl_?iKfU_JFmYKfC?JFmYKfU_JFm^08U_JFmYKfU_JFmYKfU_JFmYH0
0Ql0I?JFmYKfU_JFmT7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH1000004kV0^H2iP;VWnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP820@1[iP;V0^H2d@;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i/3V0^H2iP;Vd>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8_?bl2iP;V0^I<iP;V0^H2iPSV0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0al0HNH2iP;V0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00002nU_JFmYKfUYnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1mYKfU_KAmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3fU_JFm]3fU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUSl_?iKfUTbFmYKfUPSPmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP<O
05kfU_JFCYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00001AiP;V0^H2iYoV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V008102L2i]kV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K0P0800]00ANH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0RloiP9<0^H8h0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP027`1L0^I>iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000<>FmYKfU_JFWiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfgoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP7AmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF`9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H_?bofh?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0al0FIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000E>H2iP;V0^JOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VgP81073V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0:00^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;P?bloiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I>
0Ql0EnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000<RFmYKfU_JFWiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
dOJFmP7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FmYK0U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_KP29KfC?H_?bofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I1mP<O
05CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH100000<_V0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0]l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KNiP;V0^H1
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iPSV0^H2C0;V0^Ho;coV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP027`1B
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000F9KfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfgoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_H20@0J
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2d01GU_JFmYKfU/2FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH8h?JFmYKfUTbFmYKfU_H_?bofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I1mYKfU_JF00<O
04nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000d>H2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2g`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d@;V0^H2iP;V0P42
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
h0;V0^H2iP;V0T`2iP;V0^H2iSl_?nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T42iP;V0^H2iP827`1=
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H00@00001KU_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfUP020@1e
mYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU/2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfh0RF
mYKfU_JFmYKfC?JFmYKfU_JFmYKf;cl_mYKfU_JFmYKfU_JFmYKfU_JFmYKf@OJFmYKfU_JFmYKf00<O
04[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP400000eNH2iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]42iP;V0^H2iP;V0^H2iP7V0^H2
iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2P0;V0^H2iP;V0^H2iP;V0^H2iP;P2>H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iSl_?nH2iP;V0^H2iP;V0^H2iP;V0^I>iP;V0^H2iP;V0^H2iP027`18
0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@00001NU_JFmYKfUYnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
goJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmP8100nFmYKf
U_JFmYKfU_JFmYH00]00I_JFmYKfU_JFmYKfU_JFmYK0U_JFmYKfU_JFmYKfU_JFmYH8U_JFmYKfU_JF
mYKfU_JFmTcfU_JFmYKfU_JFmYKfU_H_?bofU_JFmYKfU_JFmYKfU_JFCYKfU_JFmYKfU_JFmYKfUP<O
04FFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00003JiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
g`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]42iP;V0^H2iP;V0^H2iP;V0^H20@;V0^H2
iP;V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0X02iP;V0^H2iP;V0^H2iPSP0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V?bloiP;V0^H2iP;V0^H2iTkV0^H2iP;V0^H2iP;V0^H2iP827`13
iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP010000066FmYKfU_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KOmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfdOJFmYKfU_JFmYKfU_JFmYKfU_JF008107WfU_JF
mYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfU/2FmYKfU_JFmYKfUPSPmYKfU_JFmYKfU_JFmYKfU_JF
mYI<U_JFmYKfU_JFmYKfU_JFmYKfU_H_?bofU_JFmYKfU_JFCYKfU_JFmYKfU_JFmYKfU_JFmYKf00<O
043fU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@00003OiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vg^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0NH2iP;V0^H2
d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2P0;V0^H2iP;V0^02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V?bloiP;V0^H2iP910^H2iP;V0^H2iP;V0^H2iP;V0^H2iP027`0n
0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H1000006BFmYKfU_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm]7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0P4019KfU_H2d01e
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU/2FmYKfU_KP29KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf;cl_mYKfU_I1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00<O
03^FmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0100000>CV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2g`;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;Vg^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810^K@iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0X02iP;P2>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ho;coV0T42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP837`0h
0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H10000
06NFmYKfU_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfgoJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_KAmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF008107kfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYK0UPRFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H_?bofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH27`0f
CiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003Y
iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^KNiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]3V0NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V2802iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V?bloiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00al0<nH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000006FFmYKf
U_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02d003mYKf0081082FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF2>3fU/20mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI>U_H_?iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmP8O
036FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000k^H2
iP;V0^JOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;A0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;@0^H2iP;V0P42iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^02iP;V0^K0iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTkV0^H2;cl_0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP837`0^
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000KIKfU_JFmYJO
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfgoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FmYKfU_JFmYH00P40P_JFmYKfU_JFmYKfU_JF
mYKfU_KP29KfU_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUTjFmYKfU_JF?bloU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYH27`0/
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH100000??V0^H2iP;VWnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]42
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]02iP;V0^H2iP;V0^H1iP;V0^H2iP;V0^H2iP;V0^08
iP;V0^H2iP;V0^K0iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2@@;V0^H2iP;V0Rlo;`;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H00al0:NH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000H9KfU_JFmYJOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;@00jFmYKfU_JFmYKfU_JFmP8108BFmYKfU_JFmYKfU_JF29Kf
U_JFmYKfU_JFmYKfP?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf@OJFmYKfU_JFmYKfUSl_?iKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_H27`0W
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000n>H2iP;V0^JOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]42iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0P42iP;V0^H2iP;V2>02iP;V0^H2
iP;V0^H2iP;V`>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP910^H2iP;V0^H2iP;V0^H2;cl_0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H20al090;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000LiKfU_JFmYJOU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]7fU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYH00P40Q_JFmYKfUPSPmYKfU_JFmYKfU_JF
mYKfU_JFmX3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_I1mYKfU_JFmYKfU_JFmYKfU_JF?bloU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JF0Ql08_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH100000?gV0^H2iP;VWnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]kV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H1iP;V0^02iP;V0^H2iP;V0^H2iP;V0^H2
iP;V`>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTkV0^H2iP;V0^H2iP;V0^H2iP;V0Rlo;`;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V00<O01oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm]ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KAmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1m^08U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
P?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF?bloU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01UP8O01fFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP01000005[V0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i]oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KNiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP82d00KiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;P008108T2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2i/3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
C^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2;cl_0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P037`0J
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU]nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm]7fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U]2FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH8U_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
P?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTjFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?USl_?iKfU_JFmYKfU_JFmYKfU_JFmYH000JFmYKfU_H37`0G
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00001jiP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^KOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i]kV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPSP0^H2iP820@2<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
i/3V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTkV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0Rlo;`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP827`0E
iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_KOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKNU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]2FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF2>3fU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmT7fU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JF?bloU_JFmYKfU_JFmYKfUP002iKfU_JFmYJOU_JF00<O
01;fU_JFmYKfU_JFmYKfU_JFmYH1000005GV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
g`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;A0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@02H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2h0;V0^H2iP;V0^H2iP8108h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^K0iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T42iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2;cl_0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0Ql040;V0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_JFWiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKO
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFm^08U_JFmYKfU_JFmYKfU_JF0IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmX3f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I1mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfUSl_?iKfU_JFmYH0012FmYKfU_JFWiKfU_JFmYKf
0al03IKfU_JFmYKfU_JFmYH00@000020iP;V0^H2iYoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VgnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2h0SV0^H2iP;V0^H2iP;V0^H2iP820@2@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K0
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP910^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0Rlo;`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0Ql02nH2iP;V0^H2iP;V00400000oiKfU_JFmYJOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU]nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU]jFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF29KfU_JFmYKfU_JFmYKfU_JFmYKfU_H1mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_J0mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI>U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKfU_JF?bloUP005IKfU_JFmYJOU_JFmYKfU_JFmYKf
UP037`08mYKfU_JFmYH100000?oV0^H2iP;VWnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0]l2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0]42iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2h0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP7V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i/3V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Rl0023V0^H2iP;VWnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003o
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000000KV0^H2
iP82o`0FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P?o01D2iP;V0^H2iP;V0^H2iP;V0^H2iP801?l05NH2
iP;V0^H2iP;V0^H2iP;V0^H2iP03o`0GiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00ol05NH2iP;V0^H2
iP;V0^H2iP;V0^H2iP03o`0FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P;o033V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82o`0FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P?o
0182iP;V0^H2iP;V0^H2iP;V0^H3o`04iP;V0P;o013V0^H2iP;V0^H2iP;V0^H20ol00`;V0P03o`04
0^H2iP400000oiKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_nFm_ofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_nFmYKfU_JFmYKfU_JFmYKfU_KomYKfUP0089KfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKo
0@00001XiP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP84o`1iiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP03o`0g
iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2i_oV0^H2i_oV0^H2iP010000
052FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKo
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o02nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooKomYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP03o`0EU_JFmYKfU_JFmYKfU_JFmYKfU_JF00?o032FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`1AU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_nFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFoiKfU_JFoiKfU_JF0040
0000onH2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;o0^H2iP;V0^H2
iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2i_oV0^H2
iP;V0^H2iP;V0^H2iP;o0^H2iP008>H2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko0@000006
U_JFmYKf0_l05YKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`0GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0_l05_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH3o`0GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00_l05_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH4o`0EmYKfU_JFmYKfU_JFmYKfU_JFmYKf00?o01GfU_JFmYKfU_JF
mYKfU_JFmYKfU_H01?l05YKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`0GU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00_l04_JFmYKfU_JFmYKfU_JFmYKfUP;o00GfU_JFmP02o`0@U_JFmYKfU_JFmYKfU_JFmP;o
00BFmYKf0_l01IKfU_JF00400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@000028iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P;o013V0^H2iP;V0^H2iP;V0^H20_l0PnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000021
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00Co00P2iP;o0^H2iP?o00?V0^H01?l0R0;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfooKomYKfooJFmYKfooJFmYKfooJFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;o0^H2iP;o0^H2iP;o0^H2iP;VonH2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKo
U_JFm_ofU_JFm_ofU_JFmYKfooJFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Koi_oV0^H2
o`;V0^H2o`;V0^KoiP;o0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000PIKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP04o`03mYKf00;o
00>FmYH00_l01OJFmYKf00;o00BFmYKf0_l0PiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000\
\>"],
  ImageRangeCache->{{{0, 287}, {148.562, 0}} -> {-0.295592, -1.00003, 
  0.0403874, 0.0403874}},
  CellTags->"Properties"]
}, Open  ]],

Cell["4.4.2 Preserving operations", "Subsubsection",
  CellTags->"Properties"],

Cell[TextData[{
  "While injectivity and surjectivity are general properties for any \
functions, the possibility of operation preserving occurs when the function \
is between two structured sets, such as groups or rings. Given a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"f", " ", ":", " ", 
            FormBox[\(\((G\_1, \)*) \),
              "TraditionalForm"]}], " ", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], " ", 
          RowBox[{"(", 
            FormBox[\(G\_2, #)\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  " between two groups, we say ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " preserves the operation of group ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " for the pair ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, \ y)\)\)]],
  " (for ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  ") if ",
  Cell[BoxData[
      \(TraditionalForm\`f(x*y)\  = \ \(f(x)\)\ #\ \(f(y)\)\)]],
  ". If the operation is preserved for all pairs coming from the domain, then \
the function is a homomorphism (or morphism). For rings, we require both the \
addition and the multiplication to be preserved."
}], "Text",
  CellTags->{"Properties", "i:15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PreservesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"a", 
                        StyleBox[",",
                          "MR"], " ", "b"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ the\ \),
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["preserves",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["binary",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(operation \((s)\)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["pair",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], \(, \ \), 
                    StyleBox["b",
                      SingleLetterItalics->False], 
                    StyleBox[")",
                      SingleLetterItalics->False]}],
                  "TraditionalForm"],
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["domain",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["PreservesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"a", 
                        StyleBox[",",
                          "MR"], " ", "b"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Mode",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox["Visual",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["addition",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["giving",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(give\ a\ visualization\ illustrating\ the\ process\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ the\ \),
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["preserves",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["binary",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(operation \((s)\)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["pairs",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], \(, \ \), 
                    StyleBox["b",
                      SingleLetterItalics->False], 
                    StyleBox[")",
                      SingleLetterItalics->False]}],
                  "TraditionalForm"],
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["domain",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[\(\(\ and\)\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Mode\  \[Rule] \ Visual\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["addition",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["to",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["giving",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[\(\ or\ \),
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(give\ a\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(visualization\ illustrating\ which\ pairs\ preserve\ the\ 
                  operations\ and\ which\ do\ not\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["HomomorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["MorphismQ",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["f",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"Properties", "i:16"}],

Cell["Functions to test for operation preseveration.", "Caption",
  CellTags->"Properties"],

Cell[TextData[{
  "Consider the following two ",
  StyleBox["Morphoids", "MR"],
  ", whose only difference is the structure used (group versus ring)."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \({f\_g\  = \ 
        ZMap[10, \ 10, \ 1\  \[Rule] \ 3, \ Structure\  \[Rule] \ Group], \ \n
      \tf\_r\  = \ 
        ZMap[10, \ 10, \ 1\  \[Rule] \ 3, \ Structure\  \[Rule] \ Ring]}\)], 
  "Input",
  CellLabel->"In[43]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \({Morphoid["1 \[Rule] 3", "-Z[10]-", "-Z[10]-"], 
      Morphoid["1 \[Rule] 3", "-Z[10]-", "-Z[10]-"]}\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "As we track what happens to the elements 2 and 5 in the following diagram, \
we see that indeed ",
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  "(2 + 5) = ",
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  "(2) + ",
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  "(5). Therefore, the operation is preserved for this pair."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PreservesQ[f\_g, \ {2, \ 5}, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"Properties"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70588 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.184874 0.070028 0.0588235 0.070028 [
[.5 .56653 -3 -4.5 ]
[.5 .56653 3 4.5 ]
[.5 .42647 -3 -4.5 ]
[.5 .42647 3 4.5 ]
[.5 .14636 -3 -4.5 ]
[.5 .14636 3 4.5 ]
[.2549 .33193 -3 -4.5 ]
[.2549 .33193 3 4.5 ]
[.7451 .33193 -3 -4.5 ]
[.7451 .33193 3 4.5 ]
[.2549 .12885 -3 -4.5 ]
[.2549 .12885 3 4.5 ]
[.2549 .18487 -9 -4.5 ]
[.2549 .18487 9 4.5 ]
[.11485 .40896 -3 -4.5 ]
[.11485 .40896 3 4.5 ]
[.11485 .46499 -3 -4.5 ]
[.11485 .46499 3 4.5 ]
[.32493 .54902 -3 -4.5 ]
[.32493 .54902 3 4.5 ]
[.32493 .60504 -3 -4.5 ]
[.32493 .60504 3 4.5 ]
[.2549 .68908 -15 -4.5 ]
[.2549 .68908 15 4.5 ]
[.7451 .07283 -18 -4.5 ]
[.7451 .07283 18 4.5 ]
[.7451 .12885 -3 -4.5 ]
[.7451 .12885 3 4.5 ]
[.7451 .18487 -3 -4.5 ]
[.7451 .18487 3 4.5 ]
[.7451 .2409 -27 -4.5 ]
[.7451 .2409 27 4.5 ]
[.67507 .40896 -3 -4.5 ]
[.67507 .40896 3 4.5 ]
[.67507 .46499 -12 -4.5 ]
[.67507 .46499 12 4.5 ]
[.88515 .54902 -3 -4.5 ]
[.88515 .54902 3 4.5 ]
[.88515 .60504 -12 -4.5 ]
[.88515 .60504 12 4.5 ]
[.7451 .68908 -15 -4.5 ]
[.7451 .68908 15 4.5 ]
[ 0 0 0 0 ]
[ 1 .70588 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 0 r
2 Mabswid
[ ] 0 setdash
.16387 .66106 m
.34594 .66106 L
s
.65406 .66106 m
.83613 .66106 L
s
1 .72 1 r
.64706 .14986 m
.64706 .26891 L
.84314 .26891 L
.84314 .14986 L
F
.54 1 0 r
.64706 .04482 m
.64706 .14986 L
.84314 .14986 L
.84314 .04482 L
F
1 0 1 r
.79412 .52101 m
.79412 .57703 L
.97619 .57703 L
.97619 .52101 L
F
.58403 .38095 m
.58403 .43697 L
.76611 .43697 L
.76611 .38095 L
F
.65406 .15686 m
.65406 .21289 L
.83613 .21289 L
.83613 .15686 L
F
0 1 0 r
.23389 .52101 m
.23389 .57703 L
.41597 .57703 L
.41597 .52101 L
F
.02381 .38095 m
.02381 .43697 L
.20588 .43697 L
.20588 .38095 L
F
.16387 .10084 m
.16387 .15686 L
.34594 .15686 L
.34594 .10084 L
F
.65406 .10084 m
.65406 .15686 L
.83613 .15686 L
.83613 .10084 L
F
1 0 1 r
.5 Mabswid
.42997 .54902 m
.78011 .54902 L
s
% Start of user PostScript
3.5 7. 8.5 7. MAarrowhead1
% End of user PostScript
.21989 .40896 m
.57003 .40896 L
s
% Start of user PostScript
0.5 5. 5.5 5. MAarrowhead1
% End of user PostScript
.67507 .36695 m
.7451 .27591 L
s
% Start of user PostScript
7. 4.4 8. 3.1 MAarrowhead1
% End of user PostScript
.88515 .507 m
.7451 .27591 L
s
% Start of user PostScript
10. 6.4 8. 3.1 MAarrowhead1
% End of user PostScript
0 1 0 r
.35994 .12885 m
.64006 .12885 L
s
% Start of user PostScript
2.5 1. 6.5 1. MAarrowhead1
% End of user PostScript
.11485 .37395 m
.2549 .23389 L
s
% Start of user PostScript
-1. 4.5 1. 2.5 MAarrowhead1
% End of user PostScript
.32493 .51401 m
.2549 .23389 L
s
% Start of user PostScript
2. 6.5 1. 2.5 MAarrowhead1
% End of user PostScript
1 0 1 r
[(f)] .5 .56653 0 0 Mshowa
[(f)] .5 .42647 0 0 Mshowa
0 1 0 r
[(f)] .5 .14636 0 0 Mshowa
0 0 0 r
[(+)] .2549 .33193 0 0 Mshowa
[(+)] .7451 .33193 0 0 Mshowa
0 g
[(7)] .2549 .12885 0 0 Mshowa
[(a+b)] .2549 .18487 0 0 Mshowa
[(2)] .11485 .40896 0 0 Mshowa
[(a)] .11485 .46499 0 0 Mshowa
[(5)] .32493 .54902 0 0 Mshowa
[(b)] .32493 .60504 0 0 Mshowa
[(Z[10])] .2549 .68908 0 0 Mshowa
[(f\\(a+b\\))] .7451 .07283 0 0 Mshowa
[(1)] .7451 .12885 0 0 Mshowa
[(1)] .7451 .18487 0 0 Mshowa
[(f\\(a\\)+f\\(b\\))] .7451 .2409 0 0 Mshowa
[(6)] .67507 .40896 0 0 Mshowa
[(f\\(a\\))] .67507 .46499 0 0 Mshowa
[(5)] .88515 .54902 0 0 Mshowa
[(f\\(b\\))] .88515 .60504 0 0 Mshowa
[(Z[10])] .7451 .68908 0 0 Mshowa
0 0 m
1 0 L
1 .70588 L
0 .70588 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[44]:=",
  ImageSize->{288, 203.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000b`P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000;T0
03SAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAgRl0
002i000hg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkA
g]4_0000^@00>=7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7N
dMkAg]7N;`000;T003SNdMkAg]7NdMkAg]7NdMkAg]7NomkAg]7NdMkAg]7NdMkAg]7NdMkAg]7odMkA
g]7NdMkAg]7NdBl0002i000hdMkAg]7NdMkAg]7NdMkAg]7NomkAg]7NdMkAg]7NdMkAg]7NdMkAg]7N
dOoAg]7NdMkAg]7NdMh_0000^@002mkAg]7NdMkAg]7N00Co00SAg]7odMkAgPGo00ONdMkog]7N00Co
017Ag]7NomkAg]7NdMkAg]7Nd@0_0000^@00>=7NdMkAg]7NdMkAg_oNdMkAg_oNdMkAom7NomkAg]7o
dMkAom7NdOoAg]7odMkAg]7NdMkAg]7N;`000;T001ONdMkAg]7NdMkAg]7odMkAg]7odMkAgP04o`03
dMko00Co01KNomkAg_oNdMkog]7NdMkAg]7NdMkA;`000;T003SAg]7NdMkAg]7NdMkog]7NdMkog]7N
dMkAg_oNdMkAom7NdOoAg]7odMkAom7NdMkAg]7NdMkAgRl0002i000;g]7NdMkAg]7NdMh01?l02M7N
dOoAg]7Nd@03o`08dMkAg_oNdMh4o`0AdMkAg_oNdMkAg]7NdMkAg]40;`000;T003SAg]7NdMkAg]7N
dMkog]7NdMkAom7NdMkAg]7NdMkAg]7NdOoAg]7NdMkog]7NdMkAg]7NdMkAgRl0002i000<g]7NdMkA
g]7NdMkA0ol04m7NdMkAg]7NdMkAg]7NdMkAg]400_l05=kAg]7NdMkAg]7NdMkAg]7NdMkA;`000;T0
03SAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAgRl0
002i000hg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkA
g]4_0000^@00>=7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7N
dMkAg]7N;`000;T003SNdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkAg]7NdMkA
g]7NdMkAg]7NdBl0000_03C@EP000m7Nd00cd003dMh002h0000_03C@EP000mkAd00cd003g]4002h0
000_03C@EP000m7Nd00cd003dMh002h0000_03C@EP000mkAd00cd003g]4002h0000_03C@AP03d0d0
00?Ag]00<m000m7N000^0000;`0Id003om3@01S@AP08d0P000?NdM005m03oaW@00?Nd@00;P0002l0
6M000oo@d00Hd4H03M030003dMk@01S@00?od=006=000m7N000^0000;`0Jd003om3@01O@101Ad003
0=kA01W@00?od=006=000mkA000^0000;`0Jd003om3@01O@AP0<d0@000?Ag]006=000oo@d00Hd003
dMh002h0000_01_@00?od=005]1600W@1`000mkAd00Hd003om3@01S@00?Nd@00;P0002l06=04oaS@
:P04d1P01M0;0003dMk@01O@0_lJd003dMh002h0000_03C@:`000m00000H00;@3P000mkAd00cd003
g]4002h0000_03C@:`000m00000X0003dMk@03?@00?AgP00;P0002l0==0[0003d00002P000?NdM00
<m000mkA000^0000;`0dd2X01=0X00;?==02cbl0000_03C@:`000m00000Y0003cm3@03;@00<0c`00
;P0008h00m0X00;?=4l2cbl0002j0003cdm?039?00<0c`00;P000;T00/ldC`;?;`000;X000??Cdl0
<Tl00`3?000^0000^@02ccA?0/l_0000@@05o`<000Co00001?mY0003cdm?01I?0olIC`030<l002h0
00110004o`00o`@000Go0000o`030003o`0006D00/lIC`03odm?01Q?0/l_0000@@04o`801Ol00`3o
00020003o`0006H000??Cdl05dl00om?C`0HC`030<l002h000140003o`00008000Go0000o`030003
o`0006D00/lIC`03odm?01Q?0/l_0000@P03o`@000Co00001?mY0003cdm?01M?00?oCdl064l00`3?
000^0000C@000ol0001Y00;?64l2oaY?0/l_0000C002of`000??Cdl0<Tl00`3?000^0000^@02ccA?
0/l_0000^P000lm?C`0bC`030<l002h0002i00;?=4l2cbl0002j0003cdm?039?00<0c`00;P000;T0
><l_0000^P00=ll0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0
c`3?0<l0;`000;T0><l_0000^P00=ll0c`3?0<l0coo?0<l0c`3?0<l0o`3?0<l0c`3?0<l0c`3?0<l0
coo?0<l0c`3?0<l0o`3?0<l0;`000;T02Ll00oo?c`0:c`03olo?00k?00?ocll02/l01?o?cll_0000
B002d70000??ool00_l0203?0?l0c`3?1Ol03Ll0coo?0<l0coo?0<l01?l0203?0?l0c`3?1?l0203?
0<ooc`3?;`0004L00m1_00??00?ocll00ll00oo?c`02c`04olo?o`C?00?ocll00ll00oo?c`02c`03
olo?00??00?ocll00/l01Oo?cloo00??00Coclo?;`0004D01]1_000=c`3o0<l0c`3o0<l0c`04o`08
0<l0coo?0<l5o`0Ic`3o0<l0c`3o0<l0coo?0<ooc`3?oll0c`0_0000@`05d0030=3@06h00ll00oo?
c`03c`03olo?00G?00?ocll00/l00oo?c`03c`03olo?00;?00?ocll00ll00oo?c`02c`05olo?col0
0ll01?o?cll_0000@P06d0040=3@d6h000??ool00_l02@3?0?l0c`3?0003o`0>0<l0coo?0<l0coo?
0<l4o`080<l0o`3?0<l4o`080<l0coo?0<l_0000@007d0800m1]00??00?ocll01<l00oo?c`08c`03
olo?00W?00?ocll01<l01Oo?cloo00K?00?ocll00/l_0000?P09d0801=1]0003c`3o00;o01/0c`3?
0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`000ol01`3?0<l0c`000_l02ll0c`3?0<l0c`3?02l0000m00W@
0`05d6/0><l_0000?009d0@01M1/000gc`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0
c`3?0<l0c`3?0<l0c`3?0<l0c`0_0000?@08d0@01]1Z03S?;`0003h01]0500K@J`00=ll0c`3?0<l0
c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0c`3?0<l0;`0003h01]0500O@
d00003d000?@00000m0600O@Q002CdX0000l0003d000008000?@00001@08d88014m90000>`000m00
000;00G@Q003C`0304m?04P0000j0003d00000`00]020003d000084014l0101?Cdm70000>@000m00
000A0003d00007l01Dl200A?AP0003P000?@00004P000m00001n00I?0`04CdD0000g0003d00001<0
00?@0000O@07C`<01Dm40000=P000m00000E0003d00007/01dl400I?@`0003D000?@00005P000m00
001j00Q?1@06Cd80000d0003d00001L000?@0000N@08C`H01dm10000<`000m00000H0003d00007X0
1dl600Q?@000038000?@00006P000m00001j00E?2008Ccl0000a0003d00001/000?@0000NP05C`P0
1Tm10000<0000m00000L0003d00007T000=?00000dl800A?@`0002l000?@00005`000ol000030003
d00007T000E?0000C`050003o`00008000A?001?@P0002h000?@000060000ol000040003d00007L0
00=?000020000ol000060003C`0003l0000]0003d00001L01Ol40003d00007H000=?00001`05o`H0
00=?0000?`0002`000?@00006P000ol000040003d00007D000=?00002P000ol000070003C`0003h0
000[0003d00001/000?o000010000m00001e0003C`0000X000?o00001`000dl0000n0000:P000m00
000T0003d00007<000=?00005P000dl0000m0000:@000m00000U0003d000078000=?000060000dl0
000l0000:0000m00000V0003d000074000=?00006@000dl0000l00009`000m00000W0003d0000700
00=?00006`000dl0000k00009P000m00000Y0003d00006l000=?00006`000dl0000k00009@000m00
000Z0003d00006h000=?00007@000dl0000j000090000m00000[0003d00006d000=?00007`000dl0
000i00008`000m00000/0003d00006`000=?000080000dl0000i00008P000m00000^0003d00008l0
00=?0000>000024000?@0000;`000m00002?0003C`0003P0001C0003d000090000=?0000=`0005<0
00?@0000T@000dl0000f00001`0dd1P000?@0000D@0dC``000=?0000=P0000L0==0I0003d0000500
=4l=0003C`0003D0000703C@6@000m00001@03A?3@000dl0000e00001`0dd1T000?@0000D00dC`h0
00=?0000=00000L0==0I0003d00003h00dl?03A?3`000dl0000c00001`0Hd0Co6=0J0003d00003d0
24l:01U?0_lIC`l000=?0000<`0000L06M000oo@d00Hd1X000?@0000?@0=C`D064l01?m?ColHCa00
00=?0000<P0000L06]000oo@d00Gd0@05Tl00m1?C`1<C`<064l01?m?ColHCa0000=?0000<P0000L0
6m000oo@d00Fd1X000?@0000?@0<C`H064l3oaU?4@000dl0000a00001`0Hd004om3@oaS@6`000m00
000l00U?2@0HC`03odm?01U?4P000dl0000`00001`0Id0;o6M0K0003d00003@014l400E?3@0IC`?o
64lB0003C`000300000703C@6`000m00000e0003C`0000@00Tl@03A?4`000dl0000_00001`0dd1/0
00?@0000=@000dl0000F03A?4`000dl0000_00001`0dd1`000?@0000=0000dl0000F03A?50000dl0
000^00001`0dd1`000?@0000<`04CaH0=4lE0003C`0002d0000703C@70000m00000d0003C`0001H0
=4lE0003C`0002d0001G0003d00003@00dmP0003C`0002`0001H0003d00009H000=?0000;00005P0
00?@0000U`000dl0000[0000F0000m00001S0003o`0000P000?o00009`000dl0000Z0000F0000m00
001R0003o`0000X000?o00009P000dl0000Z00007`05ocD000?@0000FP04o`<000?o00000P05o`<0
00?o00009`000dl0000Y00007`001?l00?lf0003d00005/000?o00000`000ol000020004o`00o`@0
00?o00009`000dl0000Y00007`04ocH000?@0000F`000ol000030003o`0000801?l40003o`0002P0
00=?0000:000028000?o0000=0000m00001K0003o`0000<000?o00001@000ol000020003o`0002T0
00=?00009`0002000olg0003d00005T01?l30003o`0000<00ol40003o`0002T000=?00009`0005X0
00?@0000FP000ol000040003o`0000P000?o0000:`000dl0000V0000FP000m00001J00?o?@000dl0
000V0000FP000m00002K0003C`0002D0001K0003d00009/000=?0000900005/000?@0000V`000dl0
000T0000F`000m00002L0003C`0002<0001K0003d00009`000=?00008`0005`000?@0000W0000dl0
000R0000G0000m00002M0003C`000240001L0003d00009d000=?00008@0005`000?@0000WP000dl0
000P0000G@000m0000300000G@000m0000300000o`0Q0000o`0Q0000@`0dd6`0=4l90000@`0dd6`0
=4l90000@`0dd6`0=4l90000@`0dd5X00dl?03A?2@0004<0==1J00I?300dC`T0001301S@0olId5X0
2Tl801Q?0olIC`T0001301_@00?od=005]1J00e?1@0KC`03odm?01I?2@0004<06m000oo@d00Fd0@0
IDl301]?00?oCdl05Tl90000@`0Hd0?o6M1J00a?1P0HC`?o6Dl90000@`0Hd003om3@01W@FP07C`/0
64l00om?C`0IC`T0001301S@1?lHd1H014m0009?400HC`Co64l90000@`0dd1L000=?0000DP0dC`T0
001303C@5`000dl0001B03A?2@0004<0==0G0003C`000580=4l90000@`0dd1H014mB03A?2@0004<0
==0G0003C`000580=4l90000SP03Chl0003o0240003o0240003j0003o`0000P000?o000060000?T0
00?o00002P000ol0000G0000F`04oi<01?l30003o`0000801?l40003o`0001L0001K0005o`000?l0
T`000ol000030003o`00008000Go0000o`030003o`0001L0001K0005o`000?l0T`000ol000030003
o`00008000Go0000o`030003o`0001L0001K0005o`000?l0T`000ol000030003o`00008000Go0000
o`030003o`0001L0001K00CoT`04o`<000?o00000P04o`@000?o00005`0005/000?o0000U@000ol0
00040005o`000?l01P000ol0000H0000FP02oiL00ol700;o8@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0002h0=QmF03HO<00002h0
=QmF03HO<0000?l08@000?l08@0004800_l@00;oN002oa000_ln0000@P000ol0000@0003o`0007H0
00?o000040000ol0000l0000>`04o`<000?o00000P03o`@00_l50003o`0006l01?l30003o`000080
0ol400;o1@000ol0000l0000?0000ol0o`030003o`0000<000?o00000P001?l00?l40003o`000700
00?o0?l00`000ol000030003o`00008000Co003o10000ol0000l0000?0000ol000030003o`0000<0
00?o00000P001?l00?l40003o`00070000?o00000`000ol000030003o`00008000Co003o10000ol0
000l0000?@000ol000020003o`0000<000?o00000P001?l00?l40003o`00074000?o00000P000ol0
00030003o`00008000Co003o10000ol0000l0000>`000ol0o`040003o`0000<000?o00000P001?l0
0?l40003o`0006l000?o0?l010000ol000030003o`00008000Co003o10000ol0000l0000>`04o`<0
0_l300;o1@02o`@00_ma00Co0`02o`<00_l500;o1002och0003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {202.25, 0}} -> {-2.65199, -0.84005, 
  0.0498396, 0.0498396}},
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "We can test every pair by using the ",
  StyleBox["Mor", "MR"],
  StyleBox["phi", "MR"],
  StyleBox["smQ", "MR"],
  " function."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MorphismQ[f\_g]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "When a ",
  StyleBox["Morphoid", "MR"],
  " is based on a ring, one needs to check both the addition and the \
multiplication. Here is the ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["MorphismQ", "MR"],
  " for the ring ",
  StyleBox["Morphoid", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontSlant->"Italic"], "r"], TraditionalForm]]],
  "."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MorphismQ[f\_r, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \("The table entry corresponding to the sum a+b (resp. product a*b) in \
the domain of the morphoid is colored if and only if addition (resp. \
multiplication) of the  pair {a,b} is preserved by the morphiod; i.e., f(a+b) \
= f(a)+f(b) (resp.  f(a*b) = f(a)*f(b)) "\)], "Print",
  CellTags->"Properties"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .49784 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0118532 0.47619 [
[ 0 0 0 0 ]
[ 1 .49784 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .49784 L
0 .49784 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0118532 0.477324 0.485982 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.11039 0.0865801 0.0248918 0.0865801 [
[ 0 0 0 0 ]
[ 1 1.04545 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04545 L
0 1.04545 L
closepath
clip
newpath
1 1 0 r
.11039 .80411 m
.11039 .89069 L
.19697 .89069 L
.19697 .80411 L
F
.19697 .80411 m
.19697 .89069 L
.28355 .89069 L
.28355 .80411 L
F
.28355 .80411 m
.28355 .89069 L
.37013 .89069 L
.37013 .80411 L
F
.37013 .80411 m
.37013 .89069 L
.45671 .89069 L
.45671 .80411 L
F
.45671 .80411 m
.45671 .89069 L
.54329 .89069 L
.54329 .80411 L
F
.54329 .80411 m
.54329 .89069 L
.62987 .89069 L
.62987 .80411 L
F
.62987 .80411 m
.62987 .89069 L
.71645 .89069 L
.71645 .80411 L
F
.71645 .80411 m
.71645 .89069 L
.80303 .89069 L
.80303 .80411 L
F
.80303 .80411 m
.80303 .89069 L
.88961 .89069 L
.88961 .80411 L
F
.88961 .80411 m
.88961 .89069 L
.97619 .89069 L
.97619 .80411 L
F
.11039 .71753 m
.11039 .80411 L
.19697 .80411 L
.19697 .71753 L
F
.19697 .71753 m
.19697 .80411 L
.28355 .80411 L
.28355 .71753 L
F
.28355 .71753 m
.28355 .80411 L
.37013 .80411 L
.37013 .71753 L
F
.37013 .71753 m
.37013 .80411 L
.45671 .80411 L
.45671 .71753 L
F
.45671 .71753 m
.45671 .80411 L
.54329 .80411 L
.54329 .71753 L
F
.54329 .71753 m
.54329 .80411 L
.62987 .80411 L
.62987 .71753 L
F
.62987 .71753 m
.62987 .80411 L
.71645 .80411 L
.71645 .71753 L
F
.71645 .71753 m
.71645 .80411 L
.80303 .80411 L
.80303 .71753 L
F
.80303 .71753 m
.80303 .80411 L
.88961 .80411 L
.88961 .71753 L
F
.88961 .71753 m
.88961 .80411 L
.97619 .80411 L
.97619 .71753 L
F
.11039 .63095 m
.11039 .71753 L
.19697 .71753 L
.19697 .63095 L
F
.19697 .63095 m
.19697 .71753 L
.28355 .71753 L
.28355 .63095 L
F
.28355 .63095 m
.28355 .71753 L
.37013 .71753 L
.37013 .63095 L
F
.37013 .63095 m
.37013 .71753 L
.45671 .71753 L
.45671 .63095 L
F
.45671 .63095 m
.45671 .71753 L
.54329 .71753 L
.54329 .63095 L
F
.54329 .63095 m
.54329 .71753 L
.62987 .71753 L
.62987 .63095 L
F
.62987 .63095 m
.62987 .71753 L
.71645 .71753 L
.71645 .63095 L
F
.71645 .63095 m
.71645 .71753 L
.80303 .71753 L
.80303 .63095 L
F
.80303 .63095 m
.80303 .71753 L
.88961 .71753 L
.88961 .63095 L
F
.88961 .63095 m
.88961 .71753 L
.97619 .71753 L
.97619 .63095 L
F
.11039 .54437 m
.11039 .63095 L
.19697 .63095 L
.19697 .54437 L
F
.19697 .54437 m
.19697 .63095 L
.28355 .63095 L
.28355 .54437 L
F
.28355 .54437 m
.28355 .63095 L
.37013 .63095 L
.37013 .54437 L
F
.37013 .54437 m
.37013 .63095 L
.45671 .63095 L
.45671 .54437 L
F
.45671 .54437 m
.45671 .63095 L
.54329 .63095 L
.54329 .54437 L
F
.54329 .54437 m
.54329 .63095 L
.62987 .63095 L
.62987 .54437 L
F
.62987 .54437 m
.62987 .63095 L
.71645 .63095 L
.71645 .54437 L
F
.71645 .54437 m
.71645 .63095 L
.80303 .63095 L
.80303 .54437 L
F
.80303 .54437 m
.80303 .63095 L
.88961 .63095 L
.88961 .54437 L
F
.88961 .54437 m
.88961 .63095 L
.97619 .63095 L
.97619 .54437 L
F
.11039 .45779 m
.11039 .54437 L
.19697 .54437 L
.19697 .45779 L
F
.19697 .45779 m
.19697 .54437 L
.28355 .54437 L
.28355 .45779 L
F
.28355 .45779 m
.28355 .54437 L
.37013 .54437 L
.37013 .45779 L
F
.37013 .45779 m
.37013 .54437 L
.45671 .54437 L
.45671 .45779 L
F
.45671 .45779 m
.45671 .54437 L
.54329 .54437 L
.54329 .45779 L
F
.54329 .45779 m
.54329 .54437 L
.62987 .54437 L
.62987 .45779 L
F
.62987 .45779 m
.62987 .54437 L
.71645 .54437 L
.71645 .45779 L
F
.71645 .45779 m
.71645 .54437 L
.80303 .54437 L
.80303 .45779 L
F
.80303 .45779 m
.80303 .54437 L
.88961 .54437 L
.88961 .45779 L
F
.88961 .45779 m
.88961 .54437 L
.97619 .54437 L
.97619 .45779 L
F
.11039 .37121 m
.11039 .45779 L
.19697 .45779 L
.19697 .37121 L
F
.19697 .37121 m
.19697 .45779 L
.28355 .45779 L
.28355 .37121 L
F
.28355 .37121 m
.28355 .45779 L
.37013 .45779 L
.37013 .37121 L
F
.37013 .37121 m
.37013 .45779 L
.45671 .45779 L
.45671 .37121 L
F
.45671 .37121 m
.45671 .45779 L
.54329 .45779 L
.54329 .37121 L
F
.54329 .37121 m
.54329 .45779 L
.62987 .45779 L
.62987 .37121 L
F
.62987 .37121 m
.62987 .45779 L
.71645 .45779 L
.71645 .37121 L
F
.71645 .37121 m
.71645 .45779 L
.80303 .45779 L
.80303 .37121 L
F
.80303 .37121 m
.80303 .45779 L
.88961 .45779 L
.88961 .37121 L
F
.88961 .37121 m
.88961 .45779 L
.97619 .45779 L
.97619 .37121 L
F
.11039 .28463 m
.11039 .37121 L
.19697 .37121 L
.19697 .28463 L
F
.19697 .28463 m
.19697 .37121 L
.28355 .37121 L
.28355 .28463 L
F
.28355 .28463 m
.28355 .37121 L
.37013 .37121 L
.37013 .28463 L
F
.37013 .28463 m
.37013 .37121 L
.45671 .37121 L
.45671 .28463 L
F
.45671 .28463 m
.45671 .37121 L
.54329 .37121 L
.54329 .28463 L
F
.54329 .28463 m
.54329 .37121 L
.62987 .37121 L
.62987 .28463 L
F
.62987 .28463 m
.62987 .37121 L
.71645 .37121 L
.71645 .28463 L
F
.71645 .28463 m
.71645 .37121 L
.80303 .37121 L
.80303 .28463 L
F
.80303 .28463 m
.80303 .37121 L
.88961 .37121 L
.88961 .28463 L
F
.88961 .28463 m
.88961 .37121 L
.97619 .37121 L
.97619 .28463 L
F
.11039 .19805 m
.11039 .28463 L
.19697 .28463 L
.19697 .19805 L
F
.19697 .19805 m
.19697 .28463 L
.28355 .28463 L
.28355 .19805 L
F
.28355 .19805 m
.28355 .28463 L
.37013 .28463 L
.37013 .19805 L
F
.37013 .19805 m
.37013 .28463 L
.45671 .28463 L
.45671 .19805 L
F
.45671 .19805 m
.45671 .28463 L
.54329 .28463 L
.54329 .19805 L
F
.54329 .19805 m
.54329 .28463 L
.62987 .28463 L
.62987 .19805 L
F
.62987 .19805 m
.62987 .28463 L
.71645 .28463 L
.71645 .19805 L
F
.71645 .19805 m
.71645 .28463 L
.80303 .28463 L
.80303 .19805 L
F
.80303 .19805 m
.80303 .28463 L
.88961 .28463 L
.88961 .19805 L
F
.88961 .19805 m
.88961 .28463 L
.97619 .28463 L
.97619 .19805 L
F
.11039 .11147 m
.11039 .19805 L
.19697 .19805 L
.19697 .11147 L
F
.19697 .11147 m
.19697 .19805 L
.28355 .19805 L
.28355 .11147 L
F
.28355 .11147 m
.28355 .19805 L
.37013 .19805 L
.37013 .11147 L
F
.37013 .11147 m
.37013 .19805 L
.45671 .19805 L
.45671 .11147 L
F
.45671 .11147 m
.45671 .19805 L
.54329 .19805 L
.54329 .11147 L
F
.54329 .11147 m
.54329 .19805 L
.62987 .19805 L
.62987 .11147 L
F
.62987 .11147 m
.62987 .19805 L
.71645 .19805 L
.71645 .11147 L
F
.71645 .11147 m
.71645 .19805 L
.80303 .19805 L
.80303 .11147 L
F
.80303 .11147 m
.80303 .19805 L
.88961 .19805 L
.88961 .11147 L
F
.88961 .11147 m
.88961 .19805 L
.97619 .19805 L
.97619 .11147 L
F
.11039 .02489 m
.11039 .11147 L
.19697 .11147 L
.19697 .02489 L
F
.19697 .02489 m
.19697 .11147 L
.28355 .11147 L
.28355 .02489 L
F
.28355 .02489 m
.28355 .11147 L
.37013 .11147 L
.37013 .02489 L
F
.37013 .02489 m
.37013 .11147 L
.45671 .11147 L
.45671 .02489 L
F
.45671 .02489 m
.45671 .11147 L
.54329 .11147 L
.54329 .02489 L
F
.54329 .02489 m
.54329 .11147 L
.62987 .11147 L
.62987 .02489 L
F
.62987 .02489 m
.62987 .11147 L
.71645 .11147 L
.71645 .02489 L
F
.71645 .02489 m
.71645 .11147 L
.80303 .11147 L
.80303 .02489 L
F
.80303 .02489 m
.80303 .11147 L
.88961 .11147 L
.88961 .02489 L
F
.88961 .02489 m
.88961 .11147 L
.97619 .11147 L
.97619 .02489 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02489 m
.02381 .97727 L
s
.02381 .02489 m
.97619 .02489 L
s
.02381 .11147 m
.97619 .11147 L
s
.02381 .19805 m
.97619 .19805 L
s
.02381 .28463 m
.97619 .28463 L
s
.02381 .37121 m
.97619 .37121 L
s
.02381 .45779 m
.97619 .45779 L
s
.02381 .54437 m
.97619 .54437 L
s
.02381 .63095 m
.97619 .63095 L
s
.02381 .71753 m
.97619 .71753 L
s
.02381 .80411 m
.97619 .80411 L
s
.02381 .89069 m
.97619 .89069 L
s
.02381 .97727 m
.97619 .97727 L
s
.11039 .02489 m
.11039 .97727 L
s
.19697 .02489 m
.19697 .97727 L
s
.28355 .02489 m
.28355 .97727 L
s
.37013 .02489 m
.37013 .97727 L
s
.45671 .02489 m
.45671 .97727 L
s
.54329 .02489 m
.54329 .97727 L
s
.62987 .02489 m
.62987 .97727 L
s
.71645 .02489 m
.71645 .97727 L
s
.80303 .02489 m
.80303 .97727 L
s
.88961 .02489 m
.88961 .97727 L
s
.97619 .02489 m
.97619 .97727 L
s
.02381 .97727 m
.11039 .89069 L
s
2.6 Mabswid
.11039 .02489 m
.11039 .97727 L
s
.02381 .89069 m
.97619 .89069 L
s
[(0)] .15368 .8474 0 0 Mshowa
[(1)] .24026 .8474 0 0 Mshowa
[(2)] .32684 .8474 0 0 Mshowa
[(3)] .41342 .8474 0 0 Mshowa
[(4)] .5 .8474 0 0 Mshowa
[(5)] .58658 .8474 0 0 Mshowa
[(6)] .67316 .8474 0 0 Mshowa
[(7)] .75974 .8474 0 0 Mshowa
[(8)] .84632 .8474 0 0 Mshowa
[(9)] .9329 .8474 0 0 Mshowa
[(1)] .15368 .76082 0 0 Mshowa
[(2)] .24026 .76082 0 0 Mshowa
[(3)] .32684 .76082 0 0 Mshowa
[(4)] .41342 .76082 0 0 Mshowa
[(5)] .5 .76082 0 0 Mshowa
[(6)] .58658 .76082 0 0 Mshowa
[(7)] .67316 .76082 0 0 Mshowa
[(8)] .75974 .76082 0 0 Mshowa
[(9)] .84632 .76082 0 0 Mshowa
[(0)] .9329 .76082 0 0 Mshowa
[(2)] .15368 .67424 0 0 Mshowa
[(3)] .24026 .67424 0 0 Mshowa
[(4)] .32684 .67424 0 0 Mshowa
[(5)] .41342 .67424 0 0 Mshowa
[(6)] .5 .67424 0 0 Mshowa
[(7)] .58658 .67424 0 0 Mshowa
[(8)] .67316 .67424 0 0 Mshowa
[(9)] .75974 .67424 0 0 Mshowa
[(0)] .84632 .67424 0 0 Mshowa
[(1)] .9329 .67424 0 0 Mshowa
[(3)] .15368 .58766 0 0 Mshowa
[(4)] .24026 .58766 0 0 Mshowa
[(5)] .32684 .58766 0 0 Mshowa
[(6)] .41342 .58766 0 0 Mshowa
[(7)] .5 .58766 0 0 Mshowa
[(8)] .58658 .58766 0 0 Mshowa
[(9)] .67316 .58766 0 0 Mshowa
[(0)] .75974 .58766 0 0 Mshowa
[(1)] .84632 .58766 0 0 Mshowa
[(2)] .9329 .58766 0 0 Mshowa
[(4)] .15368 .50108 0 0 Mshowa
[(5)] .24026 .50108 0 0 Mshowa
[(6)] .32684 .50108 0 0 Mshowa
[(7)] .41342 .50108 0 0 Mshowa
[(8)] .5 .50108 0 0 Mshowa
[(9)] .58658 .50108 0 0 Mshowa
[(0)] .67316 .50108 0 0 Mshowa
[(1)] .75974 .50108 0 0 Mshowa
[(2)] .84632 .50108 0 0 Mshowa
[(3)] .9329 .50108 0 0 Mshowa
[(5)] .15368 .4145 0 0 Mshowa
[(6)] .24026 .4145 0 0 Mshowa
[(7)] .32684 .4145 0 0 Mshowa
[(8)] .41342 .4145 0 0 Mshowa
[(9)] .5 .4145 0 0 Mshowa
[(0)] .58658 .4145 0 0 Mshowa
[(1)] .67316 .4145 0 0 Mshowa
[(2)] .75974 .4145 0 0 Mshowa
[(3)] .84632 .4145 0 0 Mshowa
[(4)] .9329 .4145 0 0 Mshowa
[(6)] .15368 .32792 0 0 Mshowa
[(7)] .24026 .32792 0 0 Mshowa
[(8)] .32684 .32792 0 0 Mshowa
[(9)] .41342 .32792 0 0 Mshowa
[(0)] .5 .32792 0 0 Mshowa
[(1)] .58658 .32792 0 0 Mshowa
[(2)] .67316 .32792 0 0 Mshowa
[(3)] .75974 .32792 0 0 Mshowa
[(4)] .84632 .32792 0 0 Mshowa
[(5)] .9329 .32792 0 0 Mshowa
[(7)] .15368 .24134 0 0 Mshowa
[(8)] .24026 .24134 0 0 Mshowa
[(9)] .32684 .24134 0 0 Mshowa
[(0)] .41342 .24134 0 0 Mshowa
[(1)] .5 .24134 0 0 Mshowa
[(2)] .58658 .24134 0 0 Mshowa
[(3)] .67316 .24134 0 0 Mshowa
[(4)] .75974 .24134 0 0 Mshowa
[(5)] .84632 .24134 0 0 Mshowa
[(6)] .9329 .24134 0 0 Mshowa
[(8)] .15368 .15476 0 0 Mshowa
[(9)] .24026 .15476 0 0 Mshowa
[(0)] .32684 .15476 0 0 Mshowa
[(1)] .41342 .15476 0 0 Mshowa
[(2)] .5 .15476 0 0 Mshowa
[(3)] .58658 .15476 0 0 Mshowa
[(4)] .67316 .15476 0 0 Mshowa
[(5)] .75974 .15476 0 0 Mshowa
[(6)] .84632 .15476 0 0 Mshowa
[(7)] .9329 .15476 0 0 Mshowa
[(9)] .15368 .06818 0 0 Mshowa
[(0)] .24026 .06818 0 0 Mshowa
[(1)] .32684 .06818 0 0 Mshowa
[(2)] .41342 .06818 0 0 Mshowa
[(3)] .5 .06818 0 0 Mshowa
[(4)] .58658 .06818 0 0 Mshowa
[(5)] .67316 .06818 0 0 Mshowa
[(6)] .75974 .06818 0 0 Mshowa
[(7)] .84632 .06818 0 0 Mshowa
[(8)] .9329 .06818 0 0 Mshowa
[(0)] .0671 .8474 0 0 Mshowa
[(1)] .0671 .76082 0 0 Mshowa
[(2)] .0671 .67424 0 0 Mshowa
[(3)] .0671 .58766 0 0 Mshowa
[(4)] .0671 .50108 0 0 Mshowa
[(5)] .0671 .4145 0 0 Mshowa
[(6)] .0671 .32792 0 0 Mshowa
[(7)] .0671 .24134 0 0 Mshowa
[(8)] .0671 .15476 0 0 Mshowa
[(9)] .0671 .06818 0 0 Mshowa
[(0)] .15368 .93398 0 0 Mshowa
[(1)] .24026 .93398 0 0 Mshowa
[(2)] .32684 .93398 0 0 Mshowa
[(3)] .41342 .93398 0 0 Mshowa
[(4)] .5 .93398 0 0 Mshowa
[(5)] .58658 .93398 0 0 Mshowa
[(6)] .67316 .93398 0 0 Mshowa
[(7)] .75974 .93398 0 0 Mshowa
[(8)] .84632 .93398 0 0 Mshowa
[(9)] .9329 .93398 0 0 Mshowa
[(Add\\(Z[10]\\))] .02381 1.02056 -1 0 Mshowa
gsave
.97619 1.02056 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05325 .91926 0 0 Mshowa
[(y)] .08874 .9513 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0118532 0.97619 0.485982 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.11039 0.0865801 0.0248918 0.0865801 [
[ 0 0 0 0 ]
[ 1 1.04545 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04545 L
0 1.04545 L
closepath
clip
newpath
1 1 1 r
.19697 .02489 m
.19697 .11147 L
.28355 .11147 L
.28355 .02489 L
F
.19697 .11147 m
.19697 .19805 L
.28355 .19805 L
.28355 .11147 L
F
.19697 .19805 m
.19697 .28463 L
.28355 .28463 L
.28355 .19805 L
F
.19697 .28463 m
.19697 .37121 L
.28355 .37121 L
.28355 .28463 L
F
.19697 .45779 m
.19697 .54437 L
.28355 .54437 L
.28355 .45779 L
F
.19697 .54437 m
.19697 .63095 L
.28355 .63095 L
.28355 .54437 L
F
.19697 .63095 m
.19697 .71753 L
.28355 .71753 L
.28355 .63095 L
F
.19697 .71753 m
.19697 .80411 L
.28355 .80411 L
.28355 .71753 L
F
.28355 .02489 m
.28355 .11147 L
.37013 .11147 L
.37013 .02489 L
F
.28355 .11147 m
.28355 .19805 L
.37013 .19805 L
.37013 .11147 L
F
.28355 .19805 m
.28355 .28463 L
.37013 .28463 L
.37013 .19805 L
F
.28355 .28463 m
.28355 .37121 L
.37013 .37121 L
.37013 .28463 L
F
.28355 .45779 m
.28355 .54437 L
.37013 .54437 L
.37013 .45779 L
F
.28355 .54437 m
.28355 .63095 L
.37013 .63095 L
.37013 .54437 L
F
.28355 .63095 m
.28355 .71753 L
.37013 .71753 L
.37013 .63095 L
F
.28355 .71753 m
.28355 .80411 L
.37013 .80411 L
.37013 .71753 L
F
.37013 .02489 m
.37013 .11147 L
.45671 .11147 L
.45671 .02489 L
F
.37013 .11147 m
.37013 .19805 L
.45671 .19805 L
.45671 .11147 L
F
.37013 .19805 m
.37013 .28463 L
.45671 .28463 L
.45671 .19805 L
F
.37013 .28463 m
.37013 .37121 L
.45671 .37121 L
.45671 .28463 L
F
.37013 .45779 m
.37013 .54437 L
.45671 .54437 L
.45671 .45779 L
F
.37013 .54437 m
.37013 .63095 L
.45671 .63095 L
.45671 .54437 L
F
.37013 .63095 m
.37013 .71753 L
.45671 .71753 L
.45671 .63095 L
F
.37013 .71753 m
.37013 .80411 L
.45671 .80411 L
.45671 .71753 L
F
.45671 .02489 m
.45671 .11147 L
.54329 .11147 L
.54329 .02489 L
F
.45671 .11147 m
.45671 .19805 L
.54329 .19805 L
.54329 .11147 L
F
.45671 .19805 m
.45671 .28463 L
.54329 .28463 L
.54329 .19805 L
F
.45671 .28463 m
.45671 .37121 L
.54329 .37121 L
.54329 .28463 L
F
.45671 .45779 m
.45671 .54437 L
.54329 .54437 L
.54329 .45779 L
F
.45671 .54437 m
.45671 .63095 L
.54329 .63095 L
.54329 .54437 L
F
.45671 .63095 m
.45671 .71753 L
.54329 .71753 L
.54329 .63095 L
F
.45671 .71753 m
.45671 .80411 L
.54329 .80411 L
.54329 .71753 L
F
.62987 .02489 m
.62987 .11147 L
.71645 .11147 L
.71645 .02489 L
F
.62987 .11147 m
.62987 .19805 L
.71645 .19805 L
.71645 .11147 L
F
.62987 .19805 m
.62987 .28463 L
.71645 .28463 L
.71645 .19805 L
F
.62987 .28463 m
.62987 .37121 L
.71645 .37121 L
.71645 .28463 L
F
.62987 .45779 m
.62987 .54437 L
.71645 .54437 L
.71645 .45779 L
F
.62987 .54437 m
.62987 .63095 L
.71645 .63095 L
.71645 .54437 L
F
.62987 .63095 m
.62987 .71753 L
.71645 .71753 L
.71645 .63095 L
F
.62987 .71753 m
.62987 .80411 L
.71645 .80411 L
.71645 .71753 L
F
.71645 .02489 m
.71645 .11147 L
.80303 .11147 L
.80303 .02489 L
F
.71645 .11147 m
.71645 .19805 L
.80303 .19805 L
.80303 .11147 L
F
.71645 .19805 m
.71645 .28463 L
.80303 .28463 L
.80303 .19805 L
F
.71645 .28463 m
.71645 .37121 L
.80303 .37121 L
.80303 .28463 L
F
.71645 .45779 m
.71645 .54437 L
.80303 .54437 L
.80303 .45779 L
F
.71645 .54437 m
.71645 .63095 L
.80303 .63095 L
.80303 .54437 L
F
.71645 .63095 m
.71645 .71753 L
.80303 .71753 L
.80303 .63095 L
F
.71645 .71753 m
.71645 .80411 L
.80303 .80411 L
.80303 .71753 L
F
.80303 .02489 m
.80303 .11147 L
.88961 .11147 L
.88961 .02489 L
F
.80303 .11147 m
.80303 .19805 L
.88961 .19805 L
.88961 .11147 L
F
.80303 .19805 m
.80303 .28463 L
.88961 .28463 L
.88961 .19805 L
F
.80303 .28463 m
.80303 .37121 L
.88961 .37121 L
.88961 .28463 L
F
.80303 .45779 m
.80303 .54437 L
.88961 .54437 L
.88961 .45779 L
F
.80303 .54437 m
.80303 .63095 L
.88961 .63095 L
.88961 .54437 L
F
.80303 .63095 m
.80303 .71753 L
.88961 .71753 L
.88961 .63095 L
F
.80303 .71753 m
.80303 .80411 L
.88961 .80411 L
.88961 .71753 L
F
.88961 .02489 m
.88961 .11147 L
.97619 .11147 L
.97619 .02489 L
F
.88961 .11147 m
.88961 .19805 L
.97619 .19805 L
.97619 .11147 L
F
.88961 .19805 m
.88961 .28463 L
.97619 .28463 L
.97619 .19805 L
F
.88961 .28463 m
.88961 .37121 L
.97619 .37121 L
.97619 .28463 L
F
.88961 .45779 m
.88961 .54437 L
.97619 .54437 L
.97619 .45779 L
F
.88961 .54437 m
.88961 .63095 L
.97619 .63095 L
.97619 .54437 L
F
.88961 .63095 m
.88961 .71753 L
.97619 .71753 L
.97619 .63095 L
F
.88961 .71753 m
.88961 .80411 L
.97619 .80411 L
.97619 .71753 L
F
1 1 0 r
.11039 .80411 m
.11039 .89069 L
.19697 .89069 L
.19697 .80411 L
F
.19697 .80411 m
.19697 .89069 L
.28355 .89069 L
.28355 .80411 L
F
.28355 .80411 m
.28355 .89069 L
.37013 .89069 L
.37013 .80411 L
F
.37013 .80411 m
.37013 .89069 L
.45671 .89069 L
.45671 .80411 L
F
.45671 .80411 m
.45671 .89069 L
.54329 .89069 L
.54329 .80411 L
F
.54329 .80411 m
.54329 .89069 L
.62987 .89069 L
.62987 .80411 L
F
.62987 .80411 m
.62987 .89069 L
.71645 .89069 L
.71645 .80411 L
F
.71645 .80411 m
.71645 .89069 L
.80303 .89069 L
.80303 .80411 L
F
.80303 .80411 m
.80303 .89069 L
.88961 .89069 L
.88961 .80411 L
F
.88961 .80411 m
.88961 .89069 L
.97619 .89069 L
.97619 .80411 L
F
.11039 .71753 m
.11039 .80411 L
.19697 .80411 L
.19697 .71753 L
F
.54329 .71753 m
.54329 .80411 L
.62987 .80411 L
.62987 .71753 L
F
.11039 .63095 m
.11039 .71753 L
.19697 .71753 L
.19697 .63095 L
F
.54329 .63095 m
.54329 .71753 L
.62987 .71753 L
.62987 .63095 L
F
.11039 .54437 m
.11039 .63095 L
.19697 .63095 L
.19697 .54437 L
F
.54329 .54437 m
.54329 .63095 L
.62987 .63095 L
.62987 .54437 L
F
.11039 .45779 m
.11039 .54437 L
.19697 .54437 L
.19697 .45779 L
F
.54329 .45779 m
.54329 .54437 L
.62987 .54437 L
.62987 .45779 L
F
.11039 .37121 m
.11039 .45779 L
.19697 .45779 L
.19697 .37121 L
F
.19697 .37121 m
.19697 .45779 L
.28355 .45779 L
.28355 .37121 L
F
.28355 .37121 m
.28355 .45779 L
.37013 .45779 L
.37013 .37121 L
F
.37013 .37121 m
.37013 .45779 L
.45671 .45779 L
.45671 .37121 L
F
.45671 .37121 m
.45671 .45779 L
.54329 .45779 L
.54329 .37121 L
F
.54329 .37121 m
.54329 .45779 L
.62987 .45779 L
.62987 .37121 L
F
.62987 .37121 m
.62987 .45779 L
.71645 .45779 L
.71645 .37121 L
F
.71645 .37121 m
.71645 .45779 L
.80303 .45779 L
.80303 .37121 L
F
.80303 .37121 m
.80303 .45779 L
.88961 .45779 L
.88961 .37121 L
F
.88961 .37121 m
.88961 .45779 L
.97619 .45779 L
.97619 .37121 L
F
.11039 .28463 m
.11039 .37121 L
.19697 .37121 L
.19697 .28463 L
F
.54329 .28463 m
.54329 .37121 L
.62987 .37121 L
.62987 .28463 L
F
.11039 .19805 m
.11039 .28463 L
.19697 .28463 L
.19697 .19805 L
F
.54329 .19805 m
.54329 .28463 L
.62987 .28463 L
.62987 .19805 L
F
.11039 .11147 m
.11039 .19805 L
.19697 .19805 L
.19697 .11147 L
F
.54329 .11147 m
.54329 .19805 L
.62987 .19805 L
.62987 .11147 L
F
.11039 .02489 m
.11039 .11147 L
.19697 .11147 L
.19697 .02489 L
F
.54329 .02489 m
.54329 .11147 L
.62987 .11147 L
.62987 .02489 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02489 m
.02381 .97727 L
s
.02381 .02489 m
.97619 .02489 L
s
.02381 .11147 m
.97619 .11147 L
s
.02381 .19805 m
.97619 .19805 L
s
.02381 .28463 m
.97619 .28463 L
s
.02381 .37121 m
.97619 .37121 L
s
.02381 .45779 m
.97619 .45779 L
s
.02381 .54437 m
.97619 .54437 L
s
.02381 .63095 m
.97619 .63095 L
s
.02381 .71753 m
.97619 .71753 L
s
.02381 .80411 m
.97619 .80411 L
s
.02381 .89069 m
.97619 .89069 L
s
.02381 .97727 m
.97619 .97727 L
s
.11039 .02489 m
.11039 .97727 L
s
.19697 .02489 m
.19697 .97727 L
s
.28355 .02489 m
.28355 .97727 L
s
.37013 .02489 m
.37013 .97727 L
s
.45671 .02489 m
.45671 .97727 L
s
.54329 .02489 m
.54329 .97727 L
s
.62987 .02489 m
.62987 .97727 L
s
.71645 .02489 m
.71645 .97727 L
s
.80303 .02489 m
.80303 .97727 L
s
.88961 .02489 m
.88961 .97727 L
s
.97619 .02489 m
.97619 .97727 L
s
.02381 .97727 m
.11039 .89069 L
s
2.6 Mabswid
.11039 .02489 m
.11039 .97727 L
s
.02381 .89069 m
.97619 .89069 L
s
[(0)] .15368 .8474 0 0 Mshowa
[(0)] .24026 .8474 0 0 Mshowa
[(0)] .32684 .8474 0 0 Mshowa
[(0)] .41342 .8474 0 0 Mshowa
[(0)] .5 .8474 0 0 Mshowa
[(0)] .58658 .8474 0 0 Mshowa
[(0)] .67316 .8474 0 0 Mshowa
[(0)] .75974 .8474 0 0 Mshowa
[(0)] .84632 .8474 0 0 Mshowa
[(0)] .9329 .8474 0 0 Mshowa
[(0)] .15368 .76082 0 0 Mshowa
[(1)] .24026 .76082 0 0 Mshowa
[(2)] .32684 .76082 0 0 Mshowa
[(3)] .41342 .76082 0 0 Mshowa
[(4)] .5 .76082 0 0 Mshowa
[(5)] .58658 .76082 0 0 Mshowa
[(6)] .67316 .76082 0 0 Mshowa
[(7)] .75974 .76082 0 0 Mshowa
[(8)] .84632 .76082 0 0 Mshowa
[(9)] .9329 .76082 0 0 Mshowa
[(0)] .15368 .67424 0 0 Mshowa
[(2)] .24026 .67424 0 0 Mshowa
[(4)] .32684 .67424 0 0 Mshowa
[(6)] .41342 .67424 0 0 Mshowa
[(8)] .5 .67424 0 0 Mshowa
[(0)] .58658 .67424 0 0 Mshowa
[(2)] .67316 .67424 0 0 Mshowa
[(4)] .75974 .67424 0 0 Mshowa
[(6)] .84632 .67424 0 0 Mshowa
[(8)] .9329 .67424 0 0 Mshowa
[(0)] .15368 .58766 0 0 Mshowa
[(3)] .24026 .58766 0 0 Mshowa
[(6)] .32684 .58766 0 0 Mshowa
[(9)] .41342 .58766 0 0 Mshowa
[(2)] .5 .58766 0 0 Mshowa
[(5)] .58658 .58766 0 0 Mshowa
[(8)] .67316 .58766 0 0 Mshowa
[(1)] .75974 .58766 0 0 Mshowa
[(4)] .84632 .58766 0 0 Mshowa
[(7)] .9329 .58766 0 0 Mshowa
[(0)] .15368 .50108 0 0 Mshowa
[(4)] .24026 .50108 0 0 Mshowa
[(8)] .32684 .50108 0 0 Mshowa
[(2)] .41342 .50108 0 0 Mshowa
[(6)] .5 .50108 0 0 Mshowa
[(0)] .58658 .50108 0 0 Mshowa
[(4)] .67316 .50108 0 0 Mshowa
[(8)] .75974 .50108 0 0 Mshowa
[(2)] .84632 .50108 0 0 Mshowa
[(6)] .9329 .50108 0 0 Mshowa
[(0)] .15368 .4145 0 0 Mshowa
[(5)] .24026 .4145 0 0 Mshowa
[(0)] .32684 .4145 0 0 Mshowa
[(5)] .41342 .4145 0 0 Mshowa
[(0)] .5 .4145 0 0 Mshowa
[(5)] .58658 .4145 0 0 Mshowa
[(0)] .67316 .4145 0 0 Mshowa
[(5)] .75974 .4145 0 0 Mshowa
[(0)] .84632 .4145 0 0 Mshowa
[(5)] .9329 .4145 0 0 Mshowa
[(0)] .15368 .32792 0 0 Mshowa
[(6)] .24026 .32792 0 0 Mshowa
[(2)] .32684 .32792 0 0 Mshowa
[(8)] .41342 .32792 0 0 Mshowa
[(4)] .5 .32792 0 0 Mshowa
[(0)] .58658 .32792 0 0 Mshowa
[(6)] .67316 .32792 0 0 Mshowa
[(2)] .75974 .32792 0 0 Mshowa
[(8)] .84632 .32792 0 0 Mshowa
[(4)] .9329 .32792 0 0 Mshowa
[(0)] .15368 .24134 0 0 Mshowa
[(7)] .24026 .24134 0 0 Mshowa
[(4)] .32684 .24134 0 0 Mshowa
[(1)] .41342 .24134 0 0 Mshowa
[(8)] .5 .24134 0 0 Mshowa
[(5)] .58658 .24134 0 0 Mshowa
[(2)] .67316 .24134 0 0 Mshowa
[(9)] .75974 .24134 0 0 Mshowa
[(6)] .84632 .24134 0 0 Mshowa
[(3)] .9329 .24134 0 0 Mshowa
[(0)] .15368 .15476 0 0 Mshowa
[(8)] .24026 .15476 0 0 Mshowa
[(6)] .32684 .15476 0 0 Mshowa
[(4)] .41342 .15476 0 0 Mshowa
[(2)] .5 .15476 0 0 Mshowa
[(0)] .58658 .15476 0 0 Mshowa
[(8)] .67316 .15476 0 0 Mshowa
[(6)] .75974 .15476 0 0 Mshowa
[(4)] .84632 .15476 0 0 Mshowa
[(2)] .9329 .15476 0 0 Mshowa
[(0)] .15368 .06818 0 0 Mshowa
[(9)] .24026 .06818 0 0 Mshowa
[(8)] .32684 .06818 0 0 Mshowa
[(7)] .41342 .06818 0 0 Mshowa
[(6)] .5 .06818 0 0 Mshowa
[(5)] .58658 .06818 0 0 Mshowa
[(4)] .67316 .06818 0 0 Mshowa
[(3)] .75974 .06818 0 0 Mshowa
[(2)] .84632 .06818 0 0 Mshowa
[(1)] .9329 .06818 0 0 Mshowa
[(0)] .0671 .8474 0 0 Mshowa
[(1)] .0671 .76082 0 0 Mshowa
[(2)] .0671 .67424 0 0 Mshowa
[(3)] .0671 .58766 0 0 Mshowa
[(4)] .0671 .50108 0 0 Mshowa
[(5)] .0671 .4145 0 0 Mshowa
[(6)] .0671 .32792 0 0 Mshowa
[(7)] .0671 .24134 0 0 Mshowa
[(8)] .0671 .15476 0 0 Mshowa
[(9)] .0671 .06818 0 0 Mshowa
[(0)] .15368 .93398 0 0 Mshowa
[(1)] .24026 .93398 0 0 Mshowa
[(2)] .32684 .93398 0 0 Mshowa
[(3)] .41342 .93398 0 0 Mshowa
[(4)] .5 .93398 0 0 Mshowa
[(5)] .58658 .93398 0 0 Mshowa
[(6)] .67316 .93398 0 0 Mshowa
[(7)] .75974 .93398 0 0 Mshowa
[(8)] .84632 .93398 0 0 Mshowa
[(9)] .9329 .93398 0 0 Mshowa
[(Mult\\(Z[10]\\))] .02381 1.02056 -1 0 Mshowa
gsave
.97619 1.02056 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05325 .91926 0 0 Mshowa
[(y)] .08874 .9513 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[46]:=",
  ImageSize->{288, 143.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000S`P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X000?o00001`02o`[O00?ogml02Ml00ooOg`08g`03
omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?o0000
4@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol000080003omoO00SO00?o0000
20000ol000090003o`0000P000?o000020000ol0000900002P000ol0000700;o2]l00ooOg`09g`03
omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml0
2=l00ol0000A0003o`0000L00_l:g`03o`0000P000?o000020000ol000090003o`0000P000?ogml0
2=l00ol000080003o`0000T000?o000020000ol000080003o`0000T0000:0004o`0000?o0`02o`?O
0ol4g`03omoO00;O0_l5g`03omoO00?o1Ml00ooOg`04o`CO00CogmoO0ol4g`03omoO00;O0ol3g`04
omoOg`?o1Ml01?oOgml2o`GO00?ogml00]l00ooOg`03g`03omoO00;O0_l4g`03o`00014000?o0000
0ol400;o0ml2o`GO00Co00000ol40003o`0000800_l40003o`00008000?o000010001?l00002o`D0
00CogmoO0ol4g`03o`0000800ol30004o`0000?o1@000ol00004o`@000?o00000ol50003o`0000T0
000:0003o`0000@000?o00000_l6g`05omoOgol00ml01?oOgol4g`05omoOgol01]l01OoOgmoo00KO
00?ogml01=l01OoOgmoo00GO00?ogml00]l00ooOg`04g`03omoO00;O00Cogmoo0]l00ooOg`02g`03
omoO00;O00?ogml00ml01OoOgmoo00;O00GogmoOo`0C0003o`0000<000Co00000_l2g`04omoOo`CO
00?o000010001Ol0003o00<000Co003o0`000ol000020003o`0000@000Co003o0P000ol000020003
omoO00CO00GogmoOo`050003o`00008000?o000010000ol000020005o`000?l01P001Ol0003o00H0
00?o00002@0000X000?o00000P03o`800_l4g`?o0ml01OoOgmoo00;O00?ogml00]l01OoOgmoo00KO
00?ogml00]l00ooOg`03g`03omoO00CO00GogmoOo`03g`Co0ml00ooOg`04g`03omoO00;O00Cogmoo
0]l00ooOg`02g`03omoO00?O00?ogml00]l01OoOgmoo00;O00GogmoOo`0C0004o`0000?o0`02o`;O
00Cogmoo1=l00ol0000200?o0`001Ol0003o008000Go0000o`050003o`0000<000Co003o0P000ol0
00020003omoO00CO00GogmoOo`0300Co0`000ol000040003o`00008000?o00000P000ol000030005
o`000?l01P000ol0000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O00GogmoOo`02g`03
omoO00;O00GogmoOo`06g`03omoO00?O00?ogml00]l00ooOg`02g`;o1=l01ooOgmoogol01=l01?oO
gml3o`GO00?ogml00ol5g`03omoO00?O00?ogml00]l00ooOg`02g`;o1=l00ol0000A0004o`00o`80
00Co00000_l2g`04omoOo`CO00Go0000o`020005o`000?l01002o`@000?o00000`000ol000030003
o`0000?o1@001?oOgml3o`CO00Oo0000o`3o00@000?o00000P02o`D000?o00000`000ol000020005
o`000?l01P000ol0000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O00GogmoOo`02g`03
omoO00;O00GogmoOo`06g`04omoOo`;O00?ogml00]l00ooOg`04g`05omoOgol00ml00ooOo`04g`05
omoOgol01ml01?oOgol7g`03omoO00CO00GogmoOo`03g`04omoOo`?O00?o00004@001?l00?l20004
o`0000;o0]l01?oOgol4g`05o`000?l00P001Ol0003o00<000Co003o0`000ol000040003o`000080
00Co003o1`001OoOgmoo00KO00Oo0000o`3o00@000?o000010000ol000020004o`00o`8000?o0000
0P001Ol0003o00H000?o00002@0000X000?o00000P02o`<00_l4g`;o1=l00ooOg`02g`;o1Ml00ooO
g`02o`KO00CogmoO0_l5g`04omoOg`?o1=l00ooOg`02g`;o1=l01?oOgml4o`CO00CogmoO0ol4g`04
omoOg`Co0ml00ooOg`02g`;o1=l00ol0000A0004o`0000;o1002o`?O0_l5g`03o`0000800_l40003
o`0000800_l40004o`0000Co10001?l00003o`@000CogmoO1?l3g`03o`0000800_l40004o`0000?o
1@001?l00002o`D000?o00000_l60003o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml0
2=l00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03
o`00014000?o00001`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooOg`08g`03
o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X000?o00001`02o`[O00?ogml0
2Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03
omoO00SO00?o00004@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol000080003
omoO00SO00?o000020000ol000090003o`0000P000?o000020000ol0000900002P1loa<0O?l;0000
2P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml0
2Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03o`0000P000?o0000
20000ol000090003o`0000P000?ogml02=l00ol000080003o`0000T000?o000020000ol000080003
o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml0
2=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`00014000?o00001`02o`[O00?o0000
20000ol000080003o`0000T000?o000020000ooOg`08g`03o`0000P000?o00002@000ol000080003
o`0000P000?o00002@0000X000?o00001`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml0
2=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o
2]l00ol000080003o`0000P000?o00002@000ol000080003omoO00SO00?o000020000ol000090003
o`0000P000?o000020000ol0000900002P000ol0000200;o0`02o`CO0_l4g`04omoOg`?o1Ml01?oO
gml2o`GO00?ogml00ol5g`04omoOg`Co0ml01?oOgml3o`CO00?ogml00]l3o`CO00?ogml00ol5g`03
omoO00;O0_l4g`03omoO00;O00?ogml00ml00ol0000A0004o`0000;o1002o`?O0_l5g`03o`000080
0_l40003o`0000800_l40003o`0000800ol40003o`0000Co10000ooOg`02g`;o1=l00ol0000200;o
10000ol0000200;o1@001?l00003o`@000?o00001?l40003o`0000T0000:0005o`000?l00P000ol0
0002o`?O00Cogmoo0ml00ooOg`04g`03omoO00;O00Cogmoo0]l00ooOg`02g`05omoOgol01]l00ooO
g`02g`03omoO00?O00?ogml01=l01OoOgmoo00GO00?ogml00ml00ooOg`03g`03omoO00;O00GogmoO
o`02g`05omoOgol01=l00ooOg`03g`03o`00014000Co003o0P001?l00002o`;O00Cogmoo1=l01Ol0
003o008000Go0000o`030004o`00o`<000?o00000`000ol000030005o`000?l01P001OoOgmoo00;O
00GogmoOo`030004o`00o`<000Go0000o`020003o`00008000?o00000P000ol000030005o`000?l0
1P000ol0000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O00?ogml00]l3o`CO00Cogmoo
0]l00ooOg`02g`05omoOgol01]l00ooOg`03g`03omoO00;O00?ogml01=l01OoOgmoo00?O1?l4g`03
omoO00?O00?ogml00]l01OoOgmoo00;O00GogmoOo`05g`03omoO00;O00?o00004@001?l00?l20004
o`0000;o0]l01?oOgol4g`05o`000?l00P001Ol0003o00<000Co003o0`001?l00004o`@000?o0000
0P000ol000030005omoOgol00]l01OoOgmoo00<000Co003o0`001Ol0003o008000?o00000P000ol0
0004o`@000?o00000P000ol000030003o`0000T0000:0003o`0000800_l300;o1=l2o`CO00GogmoO
o`02g`03omoO00;O00Cogmoo0]l00ooOg`02g`05omoOgol01]l00ooOg`04g`05omoOgol01=l2o`CO
00OogmoOomoo00GO00?ogml00ol5g`04omoOg`?o1=l00ooOg`03g`03omoO00;O00?o00004@001?l0
0002o`@00_l2g`04omoOo`CO00?o00000P02o`@000Co00000ol40007o`000?l0o`050003o`0000<0
00?o00000P001OoOgmoo00;O00GogmoOo`0400;o10001?l00003o`D000Ko003o0?l50003o`0000<0
00?o00000P000ol0000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O00GogmoOo`02g`03
omoO00;O00Cogmoo0]l00ooOg`02g`05omoOgol01]l01OoOgmoo00;O00GogmoOo`06g`05omoOgol0
0ml00ooOo`05g`04omoOo`OO00GogmoOo`06g`03omoO00CO00GogmoOo`0C0004o`00o`8000Co0000
0_l2g`04omoOo`CO00Go0000o`020005o`000?l00`000ol000040007o`000?l0o`050004o`00o`80
00?o00000P001OoOgmoo00;O00GogmoOo`030004o`00o`<000Go0000o`070006o`00o`3o1@001?l0
0?l20003o`00008000?o00002@0000X000?o00000P02o`<00_l4g`;o1=l00ooOg`02g`;o1Ml01?oO
gml2o`GO00?ogml00_l6g`03omoO00;O0_l4g`04omoOg`?o1=l00ooOg`02g`;o1Ml00ooOg`04o`CO
00?ogml00]l3o`?O00CogmoO1?l3g`03o`00014000Co00000_l400;o0ml2o`GO00?o00000P02o`@0
00?o00000P03o`<000?o00000P02o`D000Co00000_l50003omoO00;O0_l4g`03o`0000800_l40003
o`0000800ol40004o`0000;o1@001?l00002o`D000?o00002@0000X000?o00001`02o`[O00?ogml0
2Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03
omoO00SO00?o00004@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol000080003
omoO00SO00?o000020000ol000090003o`0000P000?o000020000ol0000900002P1loa<0O?l;0000
2P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml0
2Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03o`0000P000?o0000
20000ol000090003o`0000P000?ogml02=l00ol000080003o`0000T000?o000020000ol000080003
o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml0
2=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`00014000?o00001`02o`[O00?o0000
20000ol000080003o`0000T000?o000020000ooOg`08g`03o`0000P000?o00002@000ol000080003
o`0000P000?o00002@0000X000?o00001`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml0
2=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o
2]l00ol000080003o`0000P000?o00002@000ol000080003omoO00SO00?o000020000ol000090003
o`0000P000?o000020000ol0000900002P000ol000020003o`0000800_l4g`03omoO00?O00?ogml0
0]l2o`GO00?ogml00ol5g`04omoOg`;o1Ml01?oOgml3o`CO00CogmoO1?l3g`04omoOg`?o1Ml01?oO
gml3o`CO00CogmoO0ol4g`03omoO00;O0_l4g`03o`00014000Go0000o`0500;o0ml2o`GO00?o0000
0P000ol000030003o`0000800ol30004o`0000?o1@001?l00002o`D000CogmoO0ol4g`04o`0000Co
0`001?l00003o`D000Co00000_l50003o`0000?o1@000ol0000900002P000ol000020003o`000080
0_l4g`03omoO00?O00GogmoOo`02g`03omoO00;O00?ogml00ml00ooOg`02g`04omoOo`;O00?ogml0
0]l00ooOg`02g`03omoO00?O00?ogml00]l00ooOg`03g`03omoO00CO00?ogml00]l00ooOg`02g`03
omoO00?O00?ogml01=l01OoOgmoo00?O00Cogmoo0ml00ol0000A0005o`000?l01@02o`;O00Cogmoo
1=l00ol000020003o`0000<000?o00000`000ol000020003o`00008000?o000010001?l00?l20003
o`00008000?ogml01=l01OoOgmoo00@000?o00000`000ol000040003o`00008000Co003o0P000ol0
00020003o`0000<000?o00000P000ol0000900002P000ol000030004o`0000;o1Ml00ooOg`02g`05
omoOgol00]l00ooOg`02g`04omoOg`?o1=l01?oOgol2g`03omoO00;O00?ogml00]l00ooOg`03g`03
omoO00?O00?ogml00]l00ooOg`04g`03omoO00;O00?ogml01?l4g`03omoO00CO00GogmoOo`03g`04
omoOo`?O00?o00004@000ol000020003o`0000800_l2g`04omoOo`CO00?o00000`000ol000020004
o`0000Co0`000ol000020003o`0000@000Co003o0P000ol000020003omoO00CO00GogmoOo`050003
o`00008000?o00000P03o`@000Co003o0P000ol000020003o`0000<000?o00000P000ol000090000
2P000ol000030004o`0000;o1Ml00ooOg`02g`03omoO00;O0_l5g`04omoOo`;O00?ogml00]l01?oO
gol2g`03omoO00;O00?ogml00]l00ooOg`03g`03omoO00CO00GogmoOo`04g`;o1Ml01_oOgooOo`GO
00CogmoO0ol4g`04omoOg`?o1=l00ol0000A0003o`00008000?o00000P02o`;O00Cogmoo1=l00ol0
00030003o`00008000Oo0000o`3o00@000?o00000P000ol000040004o`0000;o1@001?oOgml3o`CO
00?o000010001Ol0003o00<000Co003o10000ol00003o`D000Co00000_l50003o`0000T0000:0003
o`0000@000?o00000_l6g`05omoOgol00ml01?oOgol4g`04omoOo`;O00?ogml00]l01?oOgol2g`03
omoO00;O00?ogml00]l00ooOg`03g`05omoOgol00]l01OoOgmoo00KO00?ogml00]l01_oOgooOo`GO
00GogmoOo`06g`05omoOgol01]l00ol0000A0003o`0000<000Co00000_l2g`04omoOo`CO00?o0000
10001Ol0003o00<000?o0?l010000ol000020003o`0000@000Co003o0P000ol000020005omoOgol0
1]l01Ol0003o008000Go0000o`030004o`00o`@000Co003o1`000ol000030003o`00008000?o0000
2@0000X000Co00001?l200;o0ml4o`?O00?ogml00]l2o`GO00CogmoO0_l5g`04omoOg`;o1Ml01?oO
gml2o`GO00?ogml00]l2o`CO00CogmoO0ol5g`04omoOg`;o1Ml01?oOgml4o`?O00?ogml00]l3o`?O
00?o00004@000ol00004o`<00_l3g`;o1Ml01?l00004o`<000?o00000P02o`@000Co00000_l60004
o`0000;o1@001?oOgml4o`?O00?o00000P02o`@000?o00000P02o`D000Co00000ol40003o`0000?o
1@000ol0000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03
omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03
o`0000P000?o000020000ol000090003o`0000P000?ogml02=l00ol000080003o`0000T000?o0000
20000ol000080003o`0000T0000:07co4`1lo`/0000:0003o`0000L00_l:g`03omoO00WO00?ogml0
2=l00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03
o`00014000?o00001`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooOg`08g`03
o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X000?o00001`02o`[O00?ogml0
2Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03
omoO00SO00?o00004@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol000080003
omoO00SO00?o000020000ol000090003o`0000P000?o000020000ol0000900002P000ol0000700;o
2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03
omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03o`0000P000?o000020000ol000090003
o`0000P000?ogml02=l00ol000080003o`0000T000?o000020000ol000080003o`0000T0000:0003
o`0000800_l300;o1=l2o`CO00?ogml00]l00ooOg`04g`04omoOg`;o1Ml00ooOg`03o`GO00?ogml0
0]l2o`CO00CogmoO0ol4g`04omoOg`Co1=l00ooOg`03o`GO00?ogml00]l3o`?O00CogmoO0ol4g`03
o`00014000Co00000_l400;o0ml2o`GO00?o00000P02o`@000Co00001?l30003o`0000800_l50004
o`0000?o10000ooOg`02g`;o1=l00ol0000200;o10001?l00004o`@000Co00000_l50004o`0000?o
10000ol0000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O00?ogml00]l00ooOg`04g`04
omoOo`;O00?ogml00]l00ooOg`03g`03omoO00;O00GogmoOo`02g`05omoOgol01=l00ooOg`03g`03
omoO00;O00?ogml01=l00ooOg`03g`03omoO00;O00?ogml00ml00ooOg`02g`03omoO00CO00GogmoO
o`0C0004o`00o`8000Co00000_l2g`04omoOo`CO00Go0000o`020005o`000?l010000ol000030005
o`000?l00P000ol000020003o`00008000?o00000`001OoOgmoo00;O00GogmoOo`030004o`00o`<0
00?o00000P000ol000040004o`00o`8000?o00000P000ol000020003o`0000<000?o00002@0000X0
00Go0000o`020003o`0000;o0ml01?oOgol3g`03omoO00?O00?ogml00ml01?oOgol2g`03omoO00;O
00CogmoO0ol4g`05omoOgol00]l01OoOgmoo00CO00?ogml00ml00ooOg`03g`03omoO00?O00?ogml0
0ml00ooOg`02g`04omoOg`Co0ml00ooOg`04g`05omoOgol04`001?l00?l20004o`0000;o0]l01?oO
gol4g`05o`000?l00P001Ol0003o00D000?o00000P001Ol0003o008000?o00000P000ol00004o`@0
00GogmoOo`02g`05omoOgol00`001?l00?l30003o`0000<000?o00000`001?l00?l20003o`000080
00?o00001?l40003o`0000T0000:0004o`0000?o0`02o`?O0ol4g`03omoO00?O00?ogml00ml01?oO
gml2o`GO00Cogmoo0]l00ooOg`02g`05omoOgol00]l01OoOgmoo00CO00?ogml00ml00ooOg`04g`03
omoO00;O00CogmoO0_l5g`07omoOgooOo`04g`04omoOg`?o1=l00ol0000A0003o`0000?o1002o`;O
00Cogmoo1=l01?l00003o`@000?o000010001Ol0003o00@00_l50006o`00o`3o1@001OoOgmoo00;O
00GogmoOo`0300?o10000ol000040003o`00008000Co00000_l50006o`00o`3o1@000ol000090000
2P001Ol0003o00D00_l3g`03omoO00CO00?ogml01=l00ooOg`02g`04omoOo`;O00?ogml00]l01?oO
gol2g`03omoO00;O00GogmoOo`02g`05omoOgol01=l00ooOg`03g`05omoOgol00]l00ooOg`02g`03
omoO00?O00?ogml00]l01ooOgmoogol01=l01OoOgmoo00KO00?o00004@001?l00?l600;o0]l01?oO
gol4g`05o`000?l01P001Ol0003o008000Go0000o`030004o`00o`@000Ko003o0?l50005omoOgol0
0]l01OoOgmoo00<000?o000010001Ol0003o008000?o00000P001?l00?l20003o`00008000Ko003o
0?l50003o`0000T0000:0003o`0000800ol200;o1=l3o`?O00CogmoO1?l4g`04omoOg`;o1Ml01?oO
gml2o`GO00?ogml00]l2o`CO00CogmoO0_l5g`03omoO00;O0_l5g`03omoO00?o1Ml00ooOg`02g`;o
1=l01?oOgml4o`?O00?o00004@001?l00003o`<00_l3g`;o1Ml00ol0000200?o0`000ol0000200;o
10000ol0000200;o1@001?l00002o`D000?ogml00]l2o`CO00?o00000P03o`<000?o00000P02o`D0
00Co00000_l50004o`0000;o1@000ol0000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO
00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0
000A0003o`0000L00_l:g`03o`0000P000?o000020000ol000090003o`0000P000?ogml02=l00ol0
00080003o`0000T000?o000020000ol000080003o`0000T0000:0003o`0000L00_l:g`03omoO00WO
00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooO
g`08g`03o`00014000?o00001`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooO
g`08g`03o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X0O?lC07co2`0000X0
00?o00001`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO
00?ogml02=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o2]l00ooOg`08g`03omoO00SO
00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ol0
000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO
00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03omoO00SO
00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooO
g`08g`03o`0000T0000:0004o`0000?o0`02o`?O0ol4g`03omoO00;O0_l5g`05omoOgol01]l01?oO
gml2o`GO00CogmoO0ol4g`03omoO00;O0_l4g`04omoOg`?o1Ml00ooOg`04o`CO00CogmoO0ol4g`03
omoO00;O0ol3g`03o`00014000?o00000ol400;o0ml2o`GO00CogmoO0ol4g`03omoO00;O0_l4g`04
omoOg`?o1Ml01?oOgml2o`GO00CogmoO0ol4g`03omoO00;O0_l4g`04omoOg`?o1Ml01?oOgml2o`GO
00?ogml00ol5g`03o`0000T0000:0003o`0000@000?o00000_l6g`05omoOgol00ml01?oOgol4g`05
omoOgol01]l01?oOgol2g`03omoO00;O00?ogml01=l01OoOgmoo00?O00Cogmoo0ml00ooOg`02g`03
omoO00CO00GogmoOo`06g`03omoO00CO00GogmoOo`05g`03omoO00;O00?o00004@000ol000030004
o`0000;o0]l01?oOgol4g`03omoO00CO00GogmoOo`03g`04omoOo`?O00?ogml01=l00ooOg`02g`04
omoOo`;O00?ogml00]l00ooOg`04g`05omoOgol00ml01?oOgol3g`03omoO00CO00?ogml00]l01?oO
gol2g`03omoO00;O00?ogml00ml00ooOg`02g`03o`0000T0000:0003o`0000@000?o00000_l6g`05
omoOgol00ml01?oOgol4g`03omoO00;O00?ogml00ml01?oOgol2g`03omoO00;O00?ogml00]l3o`?O
00GogmoOo`02g`05omoOgol01=l00ooOg`04g`03omoO00;O00?ogml00ml00ooOg`04g`05omoOgol0
0ml4o`?O00?o00004@000ol000030004o`0000;o0]l01?oOgol4g`03omoO00CO00GogmoOo`03g`04
omoOo`?O00?ogml01=l00ooOg`02g`04omoOo`;O00?ogml00]l00ooOg`04g`05omoOgol00ml01?oO
gol3g`03omoO00CO00?ogml00]l01?oOgol2g`03omoO00;O00?ogml00ml00ooOg`02g`03o`0000T0
000:0004o`0000?o0`02o`?O0ol4g`04omoOg`?o1Ml00ooOg`02g`03omoO00?O00CogmoO0_l5g`05
omoOgol00]l01OoOgmoo00?O00Cogmoo0ml00ooOg`02g`03omoO00CO00?ogml00ml00ooOg`02g`03
omoO00;O0_l4g`07omoOgooOo`04g`03o`00014000?o00000ol400;o0]l01?oOgol4g`04omoOg`?o
1=l01OoOgmoo00;O00GogmoOo`03g`?o1Ml01?oOgol2g`03omoO00;O00CogmoO0ol4g`05omoOgol0
0]l01OoOgmoo00?O0ol5g`04omoOo`;O00?ogml00]l00ooOg`03o`GO00?o00002@0000X000Go0000
o`0500;o0ml00ooOg`04g`05omoOgol01ml00ooOg`03g`03omoO00;O00Cogmoo0]l00ooOg`02g`05
omoOgol00]l01OoOgmoo00?O00Cogmoo0ml00ooOg`02g`03omoO00CO00Cogmoo0]l00ooOg`02g`03
omoO00CO00GogmoOo`03g`03omoo00CO00?o00004@001?l00?l600;o0]l01?oOgol4g`05omoOgol0
1]l01OoOgmoo00;O00GogmoOo`03g`03omoO00GO00Cogmoo0]l00ooOg`02g`05omoOgol01]l01OoO
gmoo00;O00GogmoOo`03g`03omoO00GO00Cogmoo0]l00ooOg`02g`04omoOo`OO00?o00002@0000X0
00Co00001?l200;o0ml4o`?O00?ogml00]l3o`CO00?ogml01?l4g`04omoOg`;o1Ml00ooOg`02g`;o
1=l00ooOg`02g`;o1=l01?oOgml2o`KO00CogmoO0_l5g`04omoOg`?o1=l00ooOg`02g`;o1=l00ol0
000A0003o`0000Co0`02o`?O0_l5g`04omoOg`Co0ml00ooOg`02g`;o1=l01?oOgml4o`CO00CogmoO
0_l5g`04omoOg`Co0ml00ooOg`02g`;o1=l01?oOgml4o`CO00CogmoO0_l5g`03omoO00Co1=l00ol0
000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO
00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03omoO00SO
00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooO
g`08g`03o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO
00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`00014000?o00001`02o`[O
00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooO
g`08g`03omoO00SO00?o00002@0000X0O?lC07co2`0000X000?o00001`02o`[O00?ogml02Ml00ooO
g`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO
00?o00004@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol000080003omoO00SO
00?o000020000ol000090003o`0000P000?o000020000ol0000900002P000ol0000700;o2]l00ooO
g`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO
00?ogml02=l00ol0000A0003o`0000L00_l:g`03o`0000P000?o000020000ol000090003o`0000P0
00?ogml02=l00ol000080003o`0000T000?o000020000ol000080003o`0000T0000:0003o`0000L0
0_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO
00?ogml02=l00ooOg`08g`03o`00014000?o00001`02o`[O00?o000020000ol000080003o`0000T0
00?o000020000ooOg`08g`03o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X0
00?o00000P03o`800_l4g`?o0ml01?oOgml3o`GO00CogmoO0_l5g`05omoOgol01]l00ooOg`02g`;o
1=l01?oOgml3o`CO00?ogml00]l2o`GO00?ogml00ol5g`04omoOg`Co0ml01?oOgml3o`CO00?o0000
4@001?l00003o`<00_l3g`;o1Ml00ol0000200?o0`000ol0000200;o10001?l00004o`@000Co0000
0_l50003omoO00;O0_l4g`03o`0000800ol30003o`0000800_l50003o`0000Co10001?l00002o`D0
00?o00002@0000X000?o00000`001?l00002o`GO00?ogml00]l00ooOg`04g`03omoO00;O00Cogmoo
0]l00ooOg`02g`05omoOgol01]l01OoOgmoo00;O00GogmoOo`06g`05omoOgol00ml01?oOgol4g`05
omoOgol01]l00ooOg`02g`03omoO00?O00?ogml01=l01OoOgmoo01<000?o00000P000ol0000200;o
0]l01?oOgol4g`03o`0000<000?o00000P001Ol0003o008000Go0000o`040003o`0000@000Co003o
0P000ol000020005omoOgol00]l01OoOgmoo00D000?o00000P001Ol0003o008000?o00000P001Ol0
003o00H000Co003o0P000ol000020003o`0000T0000:0004o`0000Co0P02o`?O1?l3g`03omoO00CO
00?ogml00]l01?oOgol2g`03omoO00;O00?ogml00]l00ooOg`03g`05omoOgol00]l01OoOgmoo00CO
0ol3g`05omoOgol00]l00ooOg`02g`05omoOgol01]l00ooOg`03g`03omoO00;O00?ogml01=l01OoO
gmoo01<000?o00001?l300;o0]l01?oOgol4g`04o`0000Co0`001Ol0003o008000Go0000o`050003
o`0000<000Co003o0P000ol000020005omoOgol00]l01OoOgmoo00<01?l30005o`000?l00P000ol0
00020003o`00008000?o00000`001?l00?l20003o`00008000?o00002@0000X000Oo0000o`3o00<0
0_l3g`03omoo00CO00CogmoO0ol5g`03omoO00?o1Ml00ooOg`02g`03omoO00?O00?ogml00]l2o`CO
00GogmoOo`02g`05omoOgol00ml01?oOgol4g`05omoOgol01]l00ooOg`04g`05omoOgol01=l2o`CO
00?o00004@001_l00?l0o`@00_l2g`04omoOo`CO00Oo0000o`3o00@000?o00000P02o`@000?o0000
10000ol000020003o`0000?o1@001OoOgmoo00;O00GogmoOo`030003o`3o00@000?o00000P02o`D0
00?o00000`000ol000020003o`0000?o1@000ol0000900002P001ol0003o0?l00`02o`?O00?ogol0
1=l01OoOgmoo00OO00Cogmoo1ml00ooOg`03g`03omoO00;O00GogmoOo`02g`05omoOgol00ml01?oO
gol3g`05omoOgol00]l00ooOg`02g`05omoOgol01]l01OoOgmoo00;O00GogmoOo`06g`05omoOgol0
4`001_l00?l0o`@00_l2g`04omoOo`CO00Oo0000o`3o00@000Go0000o`020005o`000?l00`001?l0
0?l40004o`00o`L000GogmoOo`02g`05omoOgol00`000ol0o`040005o`000?l00P000ol000020004
o`00o`8000?o00000P001?l00?l70003o`0000T0000:0003o`0000800_l300;o1=l2o`CO00CogmoO
1?l4g`04omoOg`?o1=l00ooOg`04o`CO00?ogml00]l2o`CO00?ogml00]l2o`CO00?ogml00]l2o`GO
00?ogml00_l6g`03omoO00;O0_l4g`04omoOg`?o1=l00ol0000A0004o`0000;o1002o`?O0_l5g`03
o`0000800_l40003o`0000800_l40003o`0000800_l50004o`0000?o10000ooOg`02g`;o1=l00ol0
000200;o10000ol0000200;o1@001?l00002o`D000Co00000ol40003o`0000T0000:0003o`0000L0
0_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO
00?ogml02=l00ooOg`08g`03o`00014000?o00001`02o`[O00?o000020000ol000080003o`0000T0
00?o000020000ooOg`08g`03o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X0
O?lC07co2`0000X000?o00001`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooO
g`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o2]l00ol0
00080003o`0000P000?o00002@000ol000080003omoO00SO00?o000020000ol000090003o`0000P0
00?o000020000ol0000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooO
g`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L0
0_l:g`03o`0000P000?o000020000ol000090003o`0000P000?ogml02=l00ol000080003o`0000T0
00?o000020000ol000080003o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooO
g`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`000140
00?o00001`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooOg`08g`03o`0000P0
00?o00002@000ol000080003o`0000P000?o00002@0000X000Co00000ol300;o0ml3o`CO00?ogml0
0]l3o`CO00?ogml00ol5g`04omoOg`;o1Ml00ooOg`02g`03omoO00?O00?ogml00]l2o`CO00CogmoO
0ol5g`04omoOg`;o1Ml01?oOgml3o`CO00CogmoO1?l3g`03o`00014000?o00000ol400;o0ml2o`GO
00Co00000ol40003o`0000800_l40004o`0000?o1@000ol00004o`@000CogmoO0ol4g`03o`000080
0_l40004o`0000?o1@001?l00003o`@000Go0000o`060003o`0000T0000:0003o`0000@000?o0000
0_l6g`05omoOgol01Ml00ooOg`03g`03omoO00?O00?ogml00]l01?oOgol2g`03omoO00;O00?ogml0
0]l00ooOg`03g`05omoOgol00]l01OoOgmoo00KO00?ogml00]l01?oOgol2g`03omoO00;O00?ogml0
0]l00ooOg`03g`03omoO00;O00?ogml00ml00ol0000A0003o`0000<000Co00000_l2g`04omoOo`CO
00?o000010001Ol0003o00<000Co003o0`000ol000040003o`00008000Go0000o`060003omoO00CO
00GogmoOo`030004o`00o`<000?o00000P000ol000040003o`00008000?o00000`001Ol0003o00H0
00?o00002@0000X000?o000010000ol00002o`KO00GogmoOo`03g`Co1=l00ooOg`03g`03omoO00;O
00Cogmoo0]l00ooOg`02g`03omoO00?O00?ogml00]l01OoOgmoo00;O00GogmoOo`04g`?o1=l01?oO
gol2g`03omoO00;O00?ogml00]l00ooOg`03g`03omoO00?O00?ogml00]l00ol0000A0003o`0000<0
00Co00000_l2g`04omoOo`CO00?o000010001Ol0003o00<000Co003o0`000ol0000200?o10000ol0
00020003o`0000<000?ogml01=l01OoOgmoo00<000Co003o0`000ol000020003o`0000@000?o0000
1?l40003o`00008000?o00000`000ol0000900002P000ol0000200;o0`02o`CO0_l4g`07omoOgooO
o`05g`03omoO00?o1Ml00ooOg`03o`GO00?ogml00ml00ooOg`02g`03omoO00;O0_l4g`05omoOgol0
0]l00ooOg`02g`04omoOo`;O00?ogml00]l00ooOg`02g`03omoO00?O00?ogml01=l01OoOgmoo01<0
00Co00000_l400;o0]l01?oOgol4g`03o`0000800_l40004o`0000?o10001Ol0003o008000?o0000
0P000ol000030003o`00008000CogmoO0ol4g`03o`0000800_l40003o`00008000?o000010001_l0
0?l0o`D000?o00000P000ol000030003o`0000T0000:0003o`0000@000?o00000_l6g`05omoOgol0
0ml00ooOo`05g`04omoOo`OO00Cogmoo1ml00ooOg`04g`05omoOgol00ml01?oOgol3g`05omoOgol0
0]l00ooOg`02g`04omoOo`;O00?ogml00]l00ooOg`02g`03omoO00?O00GogmoOo`02g`05omoOgol0
4`000ol000030004o`0000;o0]l01?oOgol4g`03o`0000@000Go0000o`030003o`0000@000Go0000
o`020003o`00008000Co003o0P000ol000020005omoOgol01]l01Ol0003o008000Go0000o`040003
o`0000@000Ko003o0?l50003o`0000<000?o00000P000ol0000900002P001?l00003o`<00_l3g`?o
1=l00ooOg`02g`;o1Ml00ooOg`04o`CO00CogmoO0ol4g`04omoOg`Co0ml00ooOg`02g`;o1=l00ooO
g`02g`;o1Ml01?oOgml2o`GO00CogmoO0_l5g`03omoO00;O0_l4g`03o`00014000?o00000ol400;o
0ml2o`GO00Co00000ol40003o`0000800ol30003o`0000800_l50004o`0000;o1@001?oOgml4o`?O
00?o00000P02o`@000Co00000_l60004o`0000;o1@000ol00004o`@000?o00002@0000X000?o0000
1`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml0
2=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o2]l00ol000080003o`0000P000?o0000
2@000ol000080003omoO00SO00?o000020000ol000090003o`0000P000?o000020000ol000090000
2P1loa<0O?l;00002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03
omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03
o`0000P000?o000020000ol000090003o`0000P000?ogml02=l00ol000080003o`0000T000?o0000
20000ol000080003o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03
omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`00014000?o0000
1`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooOg`08g`03o`0000P000?o0000
2@000ol000080003o`0000P000?o00002@0000X000?o00001`02o`[O00?ogml02Ml00ooOg`08g`03
omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?o0000
4@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol000080003omoO00SO00?o0000
20000ol000090003o`0000P000?o000020000ol0000900002P001?l00004o`800_l3g`Co0ml01?oO
gml3o`GO00CogmoO0ol4g`03omoO00?o1Ml00ooOg`02g`;o1=l00ooOg`02g`03omoO00?O00?ogml0
0]l2o`GO00?ogml00ol5g`03omoO00;O0_l4g`04omoOg`?o1=l00ol0000A0003o`0000Co0`02o`?O
0_l5g`04o`0000Co0`000ol0000200?o0`000ol0000200;o1@001?l00002o`D000?ogml00]l2o`CO
00Co00001?l30003o`0000800ol40004o`0000;o1@001?l00002o`D000?o00002@0000X000?o0000
0P000ol0000200;o1=l00ooOg`03g`03omoO00CO00?ogml00]l00ooOg`02g`03omoO00?O00?ogml0
0ml00ooOg`02g`05omoOgol00]l01OoOgmoo00CO00?ogml00ml01OoOgmoo00;O00?ogml00]l00ooO
g`03g`03omoO00;O00GogmoOo`02g`05omoOgol01=l00ooOg`03g`03o`00014000Go0000o`0500;o
0]l01?oOgol4g`03o`00008000?o00000`000ol000030003o`00008000Go0000o`020003o`000080
00Co003o0P000ol000020005omoOgol00]l01OoOgmoo00@000?o00000`000ol000030003o`0000<0
00Co003o0P000ol000020004o`00o`8000?o00000P000ol0000900002P000ol000030004o`0000;o
1Ml00ooOg`02g`03omoO00CO00?ogml00]l00ooOg`04o`CO00?ogml00ml00ooOg`02g`05omoOgol0
0]l01OoOgmoo00GO00?ogml00]l01OoOgmoo00;O00?ogml00]l01?oOgml3o`CO00GogmoOo`02g`05
omoOgol01=l00ooOg`03g`03o`00014000?o00000P000ol0000200;o0]l01?oOgol4g`03o`0000<0
00?o00000P001?l00004o`<000Go0000o`020003o`00008000Co003o0P000ol000020005omoOgol0
0]l01OoOgmoo00D000?o00000P001?l00004o`@000Co003o0P000ol000020004o`00o`8000?o0000
0P000ol0000900002P000ol000040003o`0000;o1]l01OoOgmoo00CO0_l5g`06omoOomoo1Ml00ooO
g`03o`GO00CogmoO0ol4g`03omoO00?O00?ogml00]l00ooOg`02g`;o1Ml01?oOgol2g`03omoO00;O
00GogmoOo`02g`05omoOgol01=l00ooOg`03g`03o`00014000?o00000`001?l00002o`;O00Cogmoo
1=l00ol000040005o`000?l00`000ol0o`040004o`0000?o1@001?l00002o`D000GogmoOo`02g`05
omoOgol01P001Ol0003o00<000?o0?l01@000ol00003o`D000Co00000_l50003o`0000T0000:0005
o`000?l00P000ol00002o`?O00Cogmoo0ml00ooOg`04g`03omoO00;O00Kogmoogol5g`04omoOo`OO
00GogmoOo`06g`03omoO00CO00GogmoOo`03g`04omoOo`CO00Cogmoo0]l00ooOg`02g`05omoOgol0
0]l01OoOgmoo00CO00?ogml00ml00ol0000A0004o`00o`8000Co00000_l2g`04omoOo`CO00Go0000
o`020005o`000?l00`000ol0o`040005o`000?l01`001?l00?l20003o`00008000GogmoOo`02g`05
omoOgol00`001?l00?l30007o`000?l0o`050004o`00o`L000Co003o0P000ol000020003o`0000T0
000:0003o`0000800_l300;o1=l2o`CO00CogmoO0ol5g`04omoOg`;o1Ml00ooOg`04o`CO00?ogml0
0]l3o`?O00CogmoO1?l3g`03omoO00;O0_l5g`04omoOg`;o1Ml00ooOg`02g`;o1=l01?oOgml2o`GO
00?o00004@001?l00002o`@00_l3g`;o1Ml00ol0000200;o10000ol0000200;o10000ol0000200?o
10001?l00002o`D000?ogml00]l2o`CO00?o00000P02o`@000?o00000P02o`D000Co00000ol40004
o`0000;o1@000ol0000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooO
g`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L0
0_l:g`03o`0000P000?o000020000ol000090003o`0000P000?ogml02=l00ol000080003o`0000T0
00?o000020000ol000080003o`0000T0000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooO
g`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`000140
00?o00001`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooOg`08g`03o`0000P0
00?o00002@000ol000080003o`0000P000?o00002@0000X0O?lC07co2`0000X000?o00001`02o`[O
00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooO
g`08g`03omoO00SO00?o00004@000ol0000700;o2]l00ol000080003o`0000P000?o00002@000ol0
00080003omoO00SO00?o000020000ol000090003o`0000P000?o000020000ol0000900002P000ol0
000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooO
g`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03o`0000P000?o000020000ol0
00090003o`0000P000?ogml02=l00ol000080003o`0000T000?o000020000ol000080003o`0000T0
000:0004o`0000?o0`02o`?O0ol4g`04omoOg`Co1=l00ooOg`03o`GO00CogmoO0ol4g`04omoOg`?o
1=l00ooOg`02g`;o1=l00ooOg`02g`03omoO00CO00CogmoO0_l5g`04omoOg`?o1=l00ooOg`02g`;o
1=l00ol0000A0003o`0000?o1002o`?O0_l5g`04o`0000?o10001?l00004o`<000Co00000ol50004
o`0000?o10001?oOgml3o`CO00?o00000P02o`@000?o00000P000ol000040004o`0000;o1@000ol0
0003o`D000?o00002@0000X000?o00000P000ol0000200;o1=l00ooOg`03g`03omoO00;O00?ogml0
1=l00ooOg`03g`03omoO00;O00?ogml00]l00ooOg`03g`03omoO00CO00GogmoOo`03g`04omoOo`?O
00?ogml00]l00ooOg`04g`04omoOo`;O00?ogml00]l00ooOg`04g`05omoOgol00ml01?oOgol3g`03
o`00014000Go0000o`0500;o0]l01?oOgol4g`03o`00008000?o00000`000ol000020003o`0000<0
00?o000010000ol000020003o`00008000?o00000`000ooOg`04g`05omoOgol00`001?l00?l30003
o`00008000?o000010001?l00?l20003o`00008000?o00000`000ol000020003o`0000T0000:0003
o`00008000?o00000P02o`CO00?ogml00ml00ooOg`03g`03omoO00?O00?ogml00ml00ooOg`02g`03
omoO00Co1=l00ooOg`04g`05omoOgol00ml01?oOgol3g`03omoO00?O00?ogml00ml01?oOgol2g`03
omoO00;O00?ogml00]l3o`?O00GogmoOo`02g`05omoOgol04`001Ol0003o00D00_l2g`04omoOo`CO
00?o00000P000ol000030003o`0000<000?o00000P000ol000040003o`00008000?o00001?l40003
omoO00CO00GogmoOo`030004o`00o`<000?o00000`000ol000030004o`00o`8000?o00000P001?l0
0003o`@000?o00002@0000X000?o00000P000ol0000200;o1=l00ooOg`03g`03omoO00CO00?ogml0
0]l01?oOgml2o`GO00Kogmoogol5g`04omoOg`?o1=l01?oOgml3o`CO00?ogml00ml00ooOg`03g`04
omoOg`;o1Ml01OoOgmoo00;O00GogmoOo`03g`04omoOo`?O00?o00004@001Ol0003o00D00_l2g`04
omoOo`CO00?o00000P000ol000030003o`0000@000Go0000o`0400;o1@001_l00?l0o`D000CogmoO
0ol4g`04o`0000?o10000ol000030003o`0000<000Co00000_l50004o`00o`8000?o00000P000ol0
000900002P000ol000020003o`0000800_l4g`03omoO00?O00GogmoOo`02g`03omoO00;O00?ogml0
0ml00ooOg`02g`06omoOomoo1Ml01OoOgmoo00KO00GogmoOo`06g`03omoO00CO00?ogml00]l01?oO
gol2g`03omoO00;O00GogmoOo`02g`05omoOgol00ml01?oOgol3g`03o`00014000Go0000o`0500;o
0]l01?oOgol4g`03o`00008000?o00000`001Ol0003o008000Go0000o`060003o`00008000Ko003o
0?l50005omoOgol01]l01Ol0003o00H000?o000010000ol000020004o`00o`8000?o00000P001?l0
0?l20003o`00008000?o00002@0000X000Co00000_l400;o0ml2o`GO00?ogml00]l2o`GO00?ogml0
0ol5g`04omoOg`;o1Ml01?oOgml4o`?O00?ogml00]l3o`?O00CogmoO1?l4g`04omoOg`;o1Ml00ooO
g`02g`;o1=l00ooOg`02g`;o1=l00ol0000A0003o`0000;o1@02o`?O0_l5g`04o`0000;o1@000ol0
000200;o10001?l00003o`D000Co00000_l50004omoOg`Co0ml00ol0000200?o0`001?l00004o`@0
00Co00000_l50004o`0000;o1@000ol0000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO
00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0
000A0003o`0000L00_l:g`03o`0000P000?o000020000ol000090003o`0000P000?ogml02=l00ol0
00080003o`0000T000?o000020000ol000080003o`0000T0000:0003o`0000L00_l:g`03omoO00WO
00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooO
g`08g`03o`00014000?o00001`02o`[O00?o000020000ol000080003o`0000T000?o000020000ooO
g`08g`03o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X0O?lC07co2`0000X0
00?o00001`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO
00?ogml02=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o2]l00ooOg`08g`03omoO00SO
00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ol0
000900002P000ol0000700;o2]l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00SO
00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ol0000A0003o`0000L00_l:g`03omoO00SO
00?ogml02=l00ooOg`09g`03omoO00SO00?ogml02=l00ooOg`08g`03omoO00WO00?ogml02=l00ooO
g`08g`03o`0000T0000:0003o`0000800_l300;o1=l2o`CO00CogmoO0ol5g`03omoO00Co1=l00ooO
g`03o`GO00?ogml00]l3o`?O00CogmoO0ol4g`03omoO00;O0_l5g`05omoOgol01]l00ooOg`02g`;o
1=l01?oOgml3o`CO00?o00004@001?l00002o`@00_l3g`;o1Ml00ooOg`02g`;o1=l00ooOg`02g`;o
1=l00ooOg`02g`;o1Ml01?oOgml2o`GO00?ogml00]l2o`CO00?ogml00]l2o`CO00?ogml00]l2o`GO
00CogmoO0_l5g`04omoOg`;o1Ml00ol0000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O
00?ogml00]l00ooOg`04g`05omoOgol01]l00ooOg`03g`03omoO00;O00?ogml00ml00ooOg`02g`03
omoO00CO00GogmoOo`03g`04omoOo`CO00GogmoOo`06g`05omoOgol00]l01OoOgmoo00KO00GogmoO
o`0C0004o`00o`8000Co00000_l2g`04omoOo`CO00GogmoOo`02g`05omoOgol00ml01?oOgol3g`05
omoOgol00]l00ooOg`02g`04omoOo`;O00?ogml00]l01OoOgmoo00;O00GogmoOo`03g`04omoOo`?O
00GogmoOo`02g`03omoO00;O00Cogmoo0]l00ooOg`02g`04omoOo`;O00?ogml00]l00ol000090000
2P001Ol0003o008000?o00000_l3g`04omoOo`?O00?ogml00]l00ooOg`04g`03omoO00;O00?ogml0
0ml00ooOg`03g`03omoO00;O00CogmoO1?l3g`03omoO00CO00GogmoOo`03g`04omoOo`CO00?ogml0
0]l00ooOg`03g`05omoOgol00]l01OoOgmoo00CO0ol3g`03o`00014000Co003o0P001?l00002o`;O
00Cogmoo1=l01OoOgmoo00;O00GogmoOo`03g`04omoOo`?O00GogmoOo`02g`03omoO00;O00Cogmoo
0]l00ooOg`02g`05omoOgol00]l01OoOgmoo00?O00Cogmoo0ml01OoOgmoo00;O00?ogml00]l01?oO
gol2g`03omoO00;O00Cogmoo0]l00ooOg`02g`03o`0000T0000:0005o`000?l00P000ol00002o`?O
00Cogmoo0ml00ooOg`02g`03omoO00CO00?ogml00ml00ooOg`02g`04omoOg`;o1Ml01ooOgmoogol0
1=l01?oOgml3o`CO00CogmoO0ol5g`03omoO00;O00?ogml00ml00ooOg`02g`;o1=l01OoOgmoo00;O
00GogmoOo`0C0004o`00o`8000Co00000_l2g`04omoOo`CO00GogmoOo`02g`05omoOgol00ml01?oO
gol3g`05omoOgol00]l00ooOg`02g`04omoOo`;O00?ogml00]l01OoOgmoo00;O00GogmoOo`03g`04
omoOo`?O00GogmoOo`02g`03omoO00;O00Cogmoo0]l00ooOg`02g`04omoOo`;O00?ogml00]l00ol0
000900002P001Ol0003o008000?o00000_l3g`04omoOo`?O00?ogml00]l00ooOg`04g`04omoOo`;O
00?ogml00]l00ooOg`03g`03omoO00;O00OogmoOomoo00CO00GogmoOo`06g`05omoOgol01ml00ooO
g`03g`03omoO00;O00GogmoOo`02g`05omoOgol00ml01?oOgol3g`03o`00014000Co003o0P001?l0
0002o`;O00Cogmoo1=l01OoOgmoo00;O00GogmoOo`03g`04omoOo`?O00GogmoOo`02g`03omoO00;O
00Cogmoo0]l00ooOg`02g`05omoOgol00]l01OoOgmoo00?O00Cogmoo0ml01OoOgmoo00;O00?ogml0
0]l01?oOgol2g`03omoO00;O00Cogmoo0]l00ooOg`02g`03o`0000T0000:0003o`0000800_l300;o
1=l2o`CO00CogmoO0_l6g`04omoOg`;o1Ml00ooOg`03o`GO00?ogml00]l2o`CO00CogmoO1?l3g`03
omoO00;O0ol4g`03omoO00Co1=l00ooOg`02g`;o1=l00ooOg`02g`;o1=l00ol0000A0004o`0000;o
1002o`?O0_l5g`03omoO00;O0_l4g`03omoO00;O0_l4g`03omoO00;O0_l5g`04omoOg`;o1Ml00ooO
g`02g`;o1=l00ooOg`02g`;o1=l00ooOg`02g`;o1Ml01?oOgml2o`GO00CogmoO0_l5g`03o`0000T0
000:0003o`0000L00_l:g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02=l00ooO
g`09g`03omoO00SO00?ogml02=l00ooOg`08g`03o`00014000?o00001`02o`[O00?ogml02=l00ooO
g`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO
00?o00002@0000X000?o00001`02o`[O00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooO
g`08g`03omoO00WO00?ogml02=l00ooOg`08g`03omoO00SO00?o00004@000ol0000700;o2]l00ooO
g`08g`03omoO00SO00?ogml02Ml00ooOg`08g`03omoO00SO00?ogml02=l00ooOg`09g`03omoO00SO
00?ogml02=l00ol0000900002@1moa80OOl;00002@1moa80OOl;00002P03o`030?oo00<00ol:0003
o`0000T000?o000020000ol000080003o`0000P000?o000020000ol000090003o`0000P000?o0000
20000ol000080003o`0001400_l00`3oo`0400?o2P000ol000080003o`0000P000?o00002@000ol0
00080003o`0000P000?o000020000ol000090003o`0000P000?o000020000ol0000900002P001Ol0
o`3o00<000Co0?oo2P000ol000090003o`0000P000?o000020000ol000080003o`0000P000?o0000
2@000ol000080003o`0000P000?o000020000ol0000A00;o00<0o`000`001?l0ool:0003o`0000P0
00?o000020000ol000090003o`0000P000?o000020000ol000080003o`0000T000?o000020000ol0
00080003o`0000T0000:0005o`00o`000ol200;o1002o`@000Co00000ol50003o`0000Co10000ol0
0003o`D000?o00000P03o`<000Co00000ol40003o`0000800_l50005o`000?l01P000ol0000200;o
10001?l00003o`@000?o00004@000ol0o`0200?o0P02o`<00_l50004o`0000?o10001?l00004o`<0
00Co00000ol50004o`0000?o10001?l00003o`@000?o00000P02o`@000?o00000P000ol000040004
o`0000;o1@000ol00003o`D000?o00002@0000X000Oo0?l0o`3o00<00_l30004o`00o`<000?o0000
0P000ol000040005o`000?l01P000ol000030003o`00008000?o00000`000ol000020003o`0000@0
00Go0000o`030004o`00o`@000Go0000o`060005o`000?l00P001Ol0003o00H000Go0000o`0C00;o
00D0o`00o`0300;o0P001?l00?l40003o`00008000?o00000`000ol000020003o`0000<000?o0000
10000ol000020003o`00008000?o00000`000ol000040005o`000?l00`001?l00?l30003o`000080
00?o000010001?l00?l20003o`00008000?o00000`000ol000020003o`0000T0000:00?o00D0ool0
o`0200;o0`001?l00?l30003o`00008000?o000010000ol000020003o`0000<000?o00000`000ol0
00020004o`0000Co0`000ol000040005o`000?l00`001?l00?l40003o`00008000?o00000`001Ol0
003o008000Go0000o`0400?o0`000ol0000A00;o00H0oooo0?l200;o0P001?l00?l40003o`000080
00?o00000`000ol000030003o`00008000?o000010000ol000020003o`0000Co10000ol000040005
o`000?l00`001?l00?l30003o`0000<000?o00000`001?l00?l20003o`00008000Co00000ol40003
o`0000T0000:0005o`000?l00P000ol00002o`<000Co003o0`000ol000020003o`0000@000?o0000
0`000ol000020004o`0000;o1@001ol0003o0?l010001?l00003o`@000Co00000ol50003o`000080
00?o00000`000ol0000200;o10001Ol0003o008000Go0000o`0C0005o`000?l00P000ol00002o`80
00Co003o10000ol000020003o`0000<000?o000010001Ol0003o00@00_l50006o`00o`3o1@001?l0
0003o`@000Co00000ol40003o`0000<000?o00000`001?l00002o`D000Co003o0P000ol000020003
o`0000T0000:0004o`00o`8000Co0?l00_l30004o`00o`<000?o00000P000ol000040004o`00o`80
00?o00000P000ol000030003o`00008000Oo0000o`3o00@000Go0000o`060005o`000?l01`000ol0
00030003o`00008000Go0000o`020005o`000?l00`001?l00?l30003o`00014000Co003o0P001?l0
o`02o`8000Co003o10000ol000020003o`0000<000Go0000o`020005o`000?l01P000ol000020006
o`00o`3o1@001Ol0003o00H000Go0000o`060003o`0000@000?o00000P001?l00?l20003o`000080
00Co003o0P000ol000020003o`0000T0000:0003o`3o00<000Co0?l00_l400;o10001?l00002o`H0
00Co00000_l50003o`0000?o1@000ol0000200;o10001?l00004o`<000?o00000P03o`@000?o0000
1?l40003o`0000800_l40003o`0000800_l40003o`00014000?o0?l00`001?l0o`02o`<00_l50004
o`0000;o1@000ol0000200;o10001?l00003o`D000Co00000_l50004o`0000Co0`000ol0000200?o
0`001?l00004o`@000Co00000_l50004o`0000;o1@000ol0000900002P02o`<00_l00`3oo`02o`X0
00?o00002@000ol000080003o`0000P000?o000020000ol000080003o`0000T000?o000020000ol0
00080003o`0000P000?o00004@02o`<00_l00`3oo`02o`X000?o000020000ol000080003o`0000T0
00?o000020000ol000080003o`0000P000?o00002@000ol000080003o`0000P000?o00002@0000X0
O?lC07co2`0001@00_n=00;oN`0001l000?o00002002oa000_l40003o`0003P00old0003o`0000P0
0_l@00;o10000ol0000b00?o4@0001h000?o00002@000ol0000@0003o`0000<000?o0000>0000ol0
000b0003o`0000T000?o000040000ol000030003o`00038000?o0000400000X00_l00`3oo`0300Go
00<0ool00ol00`3o000300Co0`000ol0000200?o1002o`D000?o00000`000ol0000O00;o00<0ool0
2@000ol0o`090003o`0001P000Ko0000o`05o`030?oo00?o0P03o`<000?o00000P04o`<000?o0000
0P03o`@00_l50003o`0000<000?o00006@02o`030?oo00T000?o0?l02@000ol0000?00002`000ol0
o`030007o`000?l0o`030004o`00o`D000?o0?l00`000ol000030003o`00008000Co003o10000ol0
00030003o`00020000?o0?l02`000ol000080003o`0001P000Oo0000o`3o008000?o00000P000ol0
00020004o`00o`8000?o00000`000ol0o`030003o`0000<000?o00000P001?l00?l40003o`0000<0
00?o00006P000ol0o`0;0003o`0000P000?o00003`0000/00ol30007o`000?l0o`030004o`00o`D0
00?o00000`000ol000030003o`00008000Co003o10000ol000030003o`00024000?o00002005o`L0
00?o0?l06@001ol0o`3o0?l00P000ol000020003o`00008000?o00000`000ol000030003o`0000<0
00?o00000`000ol000020004o`00o`@000?o00000`000ol0000K0003o`0000P01Ol70003o`3o0100
000;0003o`3o00<000Oo0000o`3o00<000Co003o1P000ol000020003o`0000<000?o00000P001?l0
0?l40003o`0000<000?o000080000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l00P000ol0
00020003o`00008000?o00000`000ol000040003o`00008000?o00000`000ol000020004o`00o`@0
00?o00000`000ol0000J0003o`3o00/000?o00001`000ol0o`0@000030000ol0000300Co0P04o`80
00?o00000P000ol0o`040003o`0000<000?o00000P001?l00?l40003o`0000<000?o00007`02o`03
0?oo01<00_l00`3oo`0H00;o00<0ool00_l00`3oo`040004o`0000Co0`000ol000020003o`3o00@0
00?o00000`000ol000020004o`00o`@000?o00000`000ol0000I00;o00<0ool04`02o`030?oo00l0
000;00;o20000ol000030005o`000?l00`04o`<00_l300;o1@02o`@00_l40003o`0005@00_l300;o
20000ol000020003o`0000@000Co00001?l300;o0`02o`D00_l400;o10000ol0001600005002o`@0
0_n:00?o10000ol0001`0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {142.375, 0}} -> {-0.0537354, -0.024897, 
  0.00734311, 0.00734311}, {{7.3125, 137}, {138.938, 
  3.375}} -> {-1.92724, -0.593752, 0.0890738, 0.0890738}, {{149.938, 
  279.625}, {138.938, 3.375}} -> {-14.6314, -0.593752, 0.0890738, 
  0.0890738}},
  CellTags->"Properties"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->"Properties"]
}, Open  ]],

Cell["\<\
From the preceding tables, we see that the pair (2, 3) does not \
preserve the multiplication operation. Here is an illustration of an \
explanation.\
\>", "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PreservesQ[f\_r, \ {2, \ 3}, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"Properties"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33613 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0080032 0.47619 [
[ 0 0 0 0 ]
[ 1 .33613 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .33613 L
0 .33613 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
% Start of sub-graphic
p
0.0238095 0.0080032 0.477324 0.328131 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.184874 0.070028 0.0588235 0.070028 [
[.5 .56653 -3 -4.5 ]
[.5 .56653 3 4.5 ]
[.5 .42647 -3 -4.5 ]
[.5 .42647 3 4.5 ]
[.5 .14636 -3 -4.5 ]
[.5 .14636 3 4.5 ]
[.2549 .33193 -3 -4.5 ]
[.2549 .33193 3 4.5 ]
[.7451 .33193 -3 -4.5 ]
[.7451 .33193 3 4.5 ]
[.2549 .12885 -3 -4.5 ]
[.2549 .12885 3 4.5 ]
[.2549 .18487 -9 -4.5 ]
[.2549 .18487 9 4.5 ]
[.11485 .40896 -3 -4.5 ]
[.11485 .40896 3 4.5 ]
[.11485 .46499 -3 -4.5 ]
[.11485 .46499 3 4.5 ]
[.32493 .54902 -3 -4.5 ]
[.32493 .54902 3 4.5 ]
[.32493 .60504 -3 -4.5 ]
[.32493 .60504 3 4.5 ]
[.2549 .68908 -15 -4.5 ]
[.2549 .68908 15 4.5 ]
[.7451 .07283 -18 -4.5 ]
[.7451 .07283 18 4.5 ]
[.7451 .12885 -3 -4.5 ]
[.7451 .12885 3 4.5 ]
[.7451 .18487 -3 -4.5 ]
[.7451 .18487 3 4.5 ]
[.7451 .2409 -27 -4.5 ]
[.7451 .2409 27 4.5 ]
[.67507 .40896 -3 -4.5 ]
[.67507 .40896 3 4.5 ]
[.67507 .46499 -12 -4.5 ]
[.67507 .46499 12 4.5 ]
[.88515 .54902 -3 -4.5 ]
[.88515 .54902 3 4.5 ]
[.88515 .60504 -12 -4.5 ]
[.88515 .60504 12 4.5 ]
[.7451 .68908 -15 -4.5 ]
[.7451 .68908 15 4.5 ]
[.493 .01681 -24 -4.5 ]
[.493 .01681 24 4.5 ]
[ 0 0 0 0 ]
[ 1 .70588 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
2 Mabswid
[ ] 0 setdash
.16387 .66106 m
.34594 .66106 L
s
.65406 .66106 m
.83613 .66106 L
s
1 .72 1 r
.64706 .14986 m
.64706 .26891 L
.84314 .26891 L
.84314 .14986 L
F
.54 1 0 r
.64706 .04482 m
.64706 .14986 L
.84314 .14986 L
.84314 .04482 L
F
1 0 1 r
.79412 .52101 m
.79412 .57703 L
.97619 .57703 L
.97619 .52101 L
F
.58403 .38095 m
.58403 .43697 L
.76611 .43697 L
.76611 .38095 L
F
.65406 .15686 m
.65406 .21289 L
.83613 .21289 L
.83613 .15686 L
F
0 1 0 r
.23389 .52101 m
.23389 .57703 L
.41597 .57703 L
.41597 .52101 L
F
.02381 .38095 m
.02381 .43697 L
.20588 .43697 L
.20588 .38095 L
F
.16387 .10084 m
.16387 .15686 L
.34594 .15686 L
.34594 .10084 L
F
.65406 .10084 m
.65406 .15686 L
.83613 .15686 L
.83613 .10084 L
F
1 0 1 r
.5 Mabswid
.42997 .54902 m
.78011 .54902 L
s
% Start of user PostScript
3.5 7. 8.5 7. MAarrowhead1
% End of user PostScript
.21989 .40896 m
.57003 .40896 L
s
% Start of user PostScript
0.5 5. 5.5 5. MAarrowhead1
% End of user PostScript
.67507 .36695 m
.7451 .27591 L
s
% Start of user PostScript
7. 4.4 8. 3.1 MAarrowhead1
% End of user PostScript
.88515 .507 m
.7451 .27591 L
s
% Start of user PostScript
10. 6.4 8. 3.1 MAarrowhead1
% End of user PostScript
0 1 0 r
.35994 .12885 m
.64006 .12885 L
s
% Start of user PostScript
2.5 1. 6.5 1. MAarrowhead1
% End of user PostScript
.11485 .37395 m
.2549 .23389 L
s
% Start of user PostScript
-1. 4.5 1. 2.5 MAarrowhead1
% End of user PostScript
.32493 .51401 m
.2549 .23389 L
s
% Start of user PostScript
2. 6.5 1. 2.5 MAarrowhead1
% End of user PostScript
1 0 1 r
[(f)] .5 .56653 0 0 Mshowa
[(f)] .5 .42647 0 0 Mshowa
0 1 0 r
[(f)] .5 .14636 0 0 Mshowa
0 0 0 r
[(+)] .2549 .33193 0 0 Mshowa
[(+)] .7451 .33193 0 0 Mshowa
0 g
[(5)] .2549 .12885 0 0 Mshowa
[(a+b)] .2549 .18487 0 0 Mshowa
[(2)] .11485 .40896 0 0 Mshowa
[(a)] .11485 .46499 0 0 Mshowa
[(3)] .32493 .54902 0 0 Mshowa
[(b)] .32493 .60504 0 0 Mshowa
[(Z[10])] .2549 .68908 0 0 Mshowa
[(f\\(a+b\\))] .7451 .07283 0 0 Mshowa
[(5)] .7451 .12885 0 0 Mshowa
[(5)] .7451 .18487 0 0 Mshowa
[(f\\(a\\)+f\\(b\\))] .7451 .2409 0 0 Mshowa
[(6)] .67507 .40896 0 0 Mshowa
[(f\\(a\\))] .67507 .46499 0 0 Mshowa
[(9)] .88515 .54902 0 0 Mshowa
[(f\\(b\\))] .88515 .60504 0 0 Mshowa
[(Z[10])] .7451 .68908 0 0 Mshowa
[(Addition)] .493 .01681 0 0 Mshowa
0 0 m
1 0 L
1 .70588 L
0 .70588 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0080032 0.97619 0.328131 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.184874 0.070028 0.0588235 0.070028 [
[.5 .56653 -3 -4.5 ]
[.5 .56653 3 4.5 ]
[.5 .42647 -3 -4.5 ]
[.5 .42647 3 4.5 ]
[.5 .14636 -3 -4.5 ]
[.5 .14636 3 4.5 ]
[.2549 .33193 -3 -4.5 ]
[.2549 .33193 3 4.5 ]
[.7451 .33193 -3 -4.5 ]
[.7451 .33193 3 4.5 ]
[.2549 .12885 -3 -4.5 ]
[.2549 .12885 3 4.5 ]
[.2549 .18487 -9 -4.5 ]
[.2549 .18487 9 4.5 ]
[.11485 .40896 -3 -4.5 ]
[.11485 .40896 3 4.5 ]
[.11485 .46499 -3 -4.5 ]
[.11485 .46499 3 4.5 ]
[.32493 .54902 -3 -4.5 ]
[.32493 .54902 3 4.5 ]
[.32493 .60504 -3 -4.5 ]
[.32493 .60504 3 4.5 ]
[.2549 .68908 -15 -4.5 ]
[.2549 .68908 15 4.5 ]
[.7451 .07283 -18 -4.5 ]
[.7451 .07283 18 4.5 ]
[.7451 .12885 -3 -4.5 ]
[.7451 .12885 3 4.5 ]
[.7451 .18487 -3 -4.5 ]
[.7451 .18487 3 4.5 ]
[.7451 .2409 -27 -4.5 ]
[.7451 .2409 27 4.5 ]
[.67507 .40896 -3 -4.5 ]
[.67507 .40896 3 4.5 ]
[.67507 .46499 -12 -4.5 ]
[.67507 .46499 12 4.5 ]
[.88515 .54902 -3 -4.5 ]
[.88515 .54902 3 4.5 ]
[.88515 .60504 -12 -4.5 ]
[.88515 .60504 12 4.5 ]
[.7451 .68908 -15 -4.5 ]
[.7451 .68908 15 4.5 ]
[.493 .01681 -42 -4.5 ]
[.493 .01681 42 4.5 ]
[ 0 0 0 0 ]
[ 1 .70588 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
2 Mabswid
[ ] 0 setdash
.16387 .66106 m
.34594 .66106 L
s
.65406 .66106 m
.83613 .66106 L
s
1 .72 1 r
.64706 .14986 m
.64706 .26891 L
.84314 .26891 L
.84314 .14986 L
F
.54 1 0 r
.64706 .04482 m
.64706 .14986 L
.84314 .14986 L
.84314 .04482 L
F
1 0 1 r
.79412 .52101 m
.79412 .57703 L
.97619 .57703 L
.97619 .52101 L
F
.58403 .38095 m
.58403 .43697 L
.76611 .43697 L
.76611 .38095 L
F
.65406 .15686 m
.65406 .21289 L
.83613 .21289 L
.83613 .15686 L
F
0 1 0 r
.23389 .52101 m
.23389 .57703 L
.41597 .57703 L
.41597 .52101 L
F
.02381 .38095 m
.02381 .43697 L
.20588 .43697 L
.20588 .38095 L
F
.16387 .10084 m
.16387 .15686 L
.34594 .15686 L
.34594 .10084 L
F
.65406 .10084 m
.65406 .15686 L
.83613 .15686 L
.83613 .10084 L
F
1 0 1 r
.5 Mabswid
.42997 .54902 m
.78011 .54902 L
s
% Start of user PostScript
3.5 7. 8.5 7. MAarrowhead1
% End of user PostScript
.21989 .40896 m
.57003 .40896 L
s
% Start of user PostScript
0.5 5. 5.5 5. MAarrowhead1
% End of user PostScript
.67507 .36695 m
.7451 .27591 L
s
% Start of user PostScript
7. 4.4 8. 3.1 MAarrowhead1
% End of user PostScript
.88515 .507 m
.7451 .27591 L
s
% Start of user PostScript
10. 6.4 8. 3.1 MAarrowhead1
% End of user PostScript
0 1 0 r
.35994 .12885 m
.64006 .12885 L
s
% Start of user PostScript
2.5 1. 6.5 1. MAarrowhead1
% End of user PostScript
.11485 .37395 m
.2549 .23389 L
s
% Start of user PostScript
-1. 4.5 1. 2.5 MAarrowhead1
% End of user PostScript
.32493 .51401 m
.2549 .23389 L
s
% Start of user PostScript
2. 6.5 1. 2.5 MAarrowhead1
% End of user PostScript
1 0 1 r
[(f)] .5 .56653 0 0 Mshowa
[(f)] .5 .42647 0 0 Mshowa
0 1 0 r
[(f)] .5 .14636 0 0 Mshowa
0 0 0 r
[(*)] .2549 .33193 0 0 Mshowa
[(*)] .7451 .33193 0 0 Mshowa
0 g
[(6)] .2549 .12885 0 0 Mshowa
[(a*b)] .2549 .18487 0 0 Mshowa
[(2)] .11485 .40896 0 0 Mshowa
[(a)] .11485 .46499 0 0 Mshowa
[(3)] .32493 .54902 0 0 Mshowa
[(b)] .32493 .60504 0 0 Mshowa
[(Z[10])] .2549 .68908 0 0 Mshowa
[(f\\(a*b\\))] .7451 .07283 0 0 Mshowa
[(8)] .7451 .12885 0 0 Mshowa
[(4)] .7451 .18487 0 0 Mshowa
[(f\\(a\\)*f\\(b\\))] .7451 .2409 0 0 Mshowa
[(6)] .67507 .40896 0 0 Mshowa
[(f\\(a\\))] .67507 .46499 0 0 Mshowa
[(9)] .88515 .54902 0 0 Mshowa
[(f\\(b\\))] .88515 .60504 0 0 Mshowa
[(Z[10])] .7451 .68908 0 0 Mshowa
[(Multiplication)] .493 .01681 0 0 Mshowa
0 0 m
1 0 L
1 .70588 L
0 .70588 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[47]:=",
  ImageSize->{288, 96.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000<T01?mC0000
bP000ol0001C0000;`02o`030?oo00<01Ol00`3oo`08o`800ol200Go0P03o`800_l00`3oo`1=0006
o`000?l01Ol00`3oo`03o`800ol200Go00<0ool00_l200Go00<0ool00ol200?o0P05o`800ol200Go
0P03o`800_l00`3oo`0Q0000<0000ol0o`030007o`000?l0o`030005o`000?l010001?l00?l30005
o`000?l00`000ol0o`020003o`0004`000Oo0000o`3o008000?o00000P000ol000020004o`00o`<0
00Go0000o`030005o`000?l01@001Ol0003o00<000?o0?l00P001Ol0003o008000Go0000o`030007
o`000?l0o`020003o`000200000`00?o0`001ol0003o0?l00`001Ol0003o00@000?o000010001Ol0
003o00<000?o0?l00P000ol0001<0007o`3o0?l0o`020003o`00008000?o00000P000ol000040005
o`000?l00`001Ol0003o00D000Go0000o`0500Co0`000ol000040005o`000?l00`000ol0o`020003
o`000200000`0003o`3o00<000Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000o`030003
o`3o008000?o0000C0001ol0o`3o0?l00P000ol000020003o`00008000?o000010001Ol0003o00<0
00Go0000o`050005o`000?l00`000ol000020005o`000?l01P001Ol0003o00<000?o0?l00P000ol0
000P0000<@000ol0000300Co0P04o`800_l300Co0`02o`@00ol00`3oo`03oaH000?o0000=@02o`03
0?oo00;o00<0ool010001?l00004o`<00_l200Go10000ol0000200;o1004o`800ol200Co0`02o`@0
0ol00`3oo`03o`@000?o00006`0003000_l80003o`0000<000?o00001P000ol0000@0003o`0001H0
00?o0000<`02o`<00_l80003o`00008000?o000040000ol0000D00;o60000ol0000J0000>@02o`@0
0_l30003o`00008000?o000010000ol0000200Co00P0g]7odMkAgPGo00ONdMkog]7N00Co00GA0000
o`1200?o10000ol000040003o`0000L00ol50003o`0000P01?l0203NoooAg]7N1Ol01mkAg]7NdMh0
1?l01M40003o01`0001F000Lo`000=7NomkAg]7odMkog]7NdOoAg]7odMkAo`<000?o0000K0007?l0
003Ag_oNdMkAom7NomkAg]7NdMkAom7NdOl30003o`0001X0001F000;o`000=kAom7NdMh01?l00m7N
o`04o`06g_oNdMko0`000ol0001/000;o`000=kAom7NdMh01?l03M7NdOoAom7NomkAg_l00`000ol0
000J0000EP007?l0003Ag_oNdMkAg]7NomkAg]7odMkAom7NdOl30003o`0006`001co0000dMkog]7N
dMkAg_oNdMkAom7NdOoAg]7o0`000ol0000J0000E@04o`090=kAom7NdMkA00?o00SAg]7NomkAgPCo
00GA0000o`1]00Co00T0g]7odMkAg]400ol00m7No`04o`03g_oo00;o00GA0000o`0L0000EP007?l0
003Ag]7odMkAg]7NdMkAg]7NdMkAom7NdMh20003o`0006d001co0000dMkAom7NdMkAg]7NdMkAom7N
dOoAg]7N0P000ol0000K0000EP03o`0C0=kAg]7NdMkAg]7NdMkAg]7Nd@02o`04g]7NdG800ol04`3N
dMkAg]7NdMkAg]7NdMkAg]400_l01=kAg]4P00007`09d0?o2]0U0003dM3@00O@0ol:d003gP0003T0
2]02o`[@9@000m7@d008d0;o2]000mh0000N00007`0<d003om3@00O@7P04d0<000?Nd=002]000oo@
d007d003d@0003T02M001?o@d?l9d1h01=030003g]3@00O@00Cod=3o2M000m40000N00007`0<d003
om3@00O@0P0Sd003dM3@00[@00?od=001m000mh0000i00W@00Cod=3o2M0202?@00?Ad=001m001?o@
d?l9d003gP0001h0000O00W@0ol:d18000?@00002@05d08000?Nd=001m03o`[@00?A0000>@09d0?o
2]0B0003d00000T01M020003g]3@00S@0_l:d003d@0001h0000O00W@00?od=002]0B0003d00000T0
0]050003dM3@00O@00?od=002]000mh0000i00W@00?od=002]0B0003d00000T00]050003dM3@00O@
00Cod=3o2M000mh0000N00007`09d0Co2M0B0003d000010000?Nd=001m04o`W@00?A0000>@0:d0?o
2M0B0003d000010000?Nd=002=02o`[@00?A00007P0001l05]0A00C@40000lo@d00Dd3`05]0A00C@
40000lo@d00Dd240000R00Go0`001?l00004oaD000?@000040000lm?C`07C`?o2Tl00ll0000l00Go
1`04oaD000?@000040000lm?C`08C`?o2Dl00ll0000N00008P001?l00?l40005o`000?l00`000ol0
000B00?@40000lm?C`0:C`03odm?00M??`001?l00?l80005o`000?l05003d10000??Cdl02Dl00om?
C`08Cb40000R00Co0P05o`030?l0008000?o00009@000lm?C`0:C`03odm?00M?00??0000?004o`<0
00?o0?l00P001Ol0003o02L000??Cdl01dl4o`U?00??00007P0002D000?o00000P001Ol0003o00<0
00?o00009@000lm?C`07C`?o2Tm20003o`00008000Go0000o`030003o`0002D000??Cdl01dl00om?
o`0:Cb40000S00?o10001?l00004obP000??Cdl01dl00om?C`0:C`03c`0003d00ol200Go00<0ool0
0_lX0003cdm?00M?00?oCol02Tl00ll0000N0000;P000ol0000S0003o`0000<000??Cdl00Tl00om?
C`02C`Co2Dl00`3o00090003o`0003P000Go0000o`0U0003o`0000<000??Cdl00Tl00om?C`03C`;o
2Tl00`3o00090003o`000180000]00;o90000ol000040003cdm?00=?00?oCdl03Tl00ol0000:0003
o`0003X00_lT0003o`0000@000??Cdl00dl00om?C`0>C`03o`0000X000?o00004@0004`01?l30003
o`0000801Ol03@3?0?l0c`3?0?l0c`001?l01<l0col400Co10000ol0001I00Co0`000ol0000200Go
00d0c`3o0<l0c`3?0<l000Co00C?0<oo1004o`@000?o00004@0002T00]0R0003o`0000<000?o0000
0P001?l0col4c`03olo?00??00?ocll00/l00oo?c`03c`03o`00008000Go0000o`030003o`0003H0
0]0R0003o`0000<000?o00000P001?l0col4c`03olo?00S?00?ocll00ll00ol000020005o`000?l0
0`000ol0000A00009`04d28000?o00000`000ol0000200Co00S?0<l0o`3?00Go00T0coo?0<l0col0
10001Ol0003o00<000?o0000=004d28000?o00000`000ol0000200Co01K?0<l0o`3?0<oocoo?0<oo
c`3?0<oo10001Ol0003o00<000?o00004@0002H01]0Q0003o`0000<000?o000010000looc`03c`03
olo?00??00?ocll00/l00oo?c`03c`03o`00008000Go0000o`030003o`0003<01]0Q0003o`0000<0
00?o000010000looc`03c`03olo?00??00?ocll00/l00oo?c`03c`03o`00008000Go0000o`030003
o`000140000U00O@8004o`<000?o00000`03o`0>c`3?0?l0c`3?0?l0c`04o`04c`3?o`@01?l40003
o`0003801m0P00Co0`000ol0000300?o00S?0<l0o`3?00Go00<0ool00_l01<l0col400Co10000ol0
000A00009@04d0040=3@d20000?o000010000ol0000300G?00?ocll02Ll00oo?c`04c`05o`000?l0
1P000ol0000c00C@00@0d=3@80000ol000040003o`0000<01Ll00oo?c`04c`03olo?00;?00?ocll0
1<l01Ol0003o00H000?o00004P0002D01=00103@d=0P00?o5@02C`@00ol700;o?004d0040=3@d200
0olE009?1003o`L00_lK000090001=000=0200C@=P03Cd/000C@003@0P04d3H00dl[00008`000m00
00060003d00003@00dl00`1?00180003d00000H000?@0000=003C`0304l002T0000R0003d00000L0
00?@0000<`04C`0304m?04L000?@00001`000m00000c00A?00<0Cdl0:@00024000?@000020000m00
000b00A?0P03CdD000?@000020000m00000b00A?0P03CbP0000P0003d00000L000Co003@=003C`03
0?l000=?@`000m00000:0003d00003800dl300=?9`0001l000?@000020001?l00=0c0003C`1?0080
00Co04m?@`000m00000;0003d000034000=?04l01002CbP0000N0003d00000L01Ol00m00000a0003
C`0000Go00<0C`00@0000m0000080005o`3o0=00<`001dl0003o0?l00P000dl0000U00007@000m00
000:0004o`00d38000=?00000`000ol000020003C`0003d000?@00002P001?l00=0b0003C`0000<0
00?o00000P000dl0000T000070000m00000;0005o`000=00<0000dl000040003o`00008000=?0000
?0000m00000900Go00<0d000;`000dl0000200Go0P000dl0000T00006`000m00000@0003d00002d0
00=?00002`000dl0000j0003d00000`000Go0000d00_0003C`0000D000?o00000`000dl0000S0000
6P000m00000A0003d00002`000=?000030000dl0000i0003d000014000?@0000;0000dl0000<0003
C`0002<0000I0003d000018000?@0000?0000dl0000g0003d000018000?@0000?0000dl0000R0000
;`000m00000l0003C`0004`000?@0000?0000dl0000Q00003P0Fd0/000?@0000800FC`H000=?0000
:`0Fd0/000?@0000800GC`D000=?00008@0000h02M04o`W@2`000m00000H00=?1@0:C`;o2Tl70003
C`0002X02M04o`W@2`000m00000H00=?1@0:C`;o2dl60003C`000200000>00[@00?od=002M0;0003
d00001P01Tl200U?00CoCdoo2Dl70003C`0002X02]000oo@d009d0/000?@00006006C`802Dl01?m?
Col:C`H000=?0000800000h02m000oo@d008d0802Tl00m1?C`0NC`0304m?00M?00CoCdoo2Dl80003
C`0002T02m000oo@d008d0802Tl00m1?C`0XC`04odm?o`Y?1`000dl0000O00003P0<d003om3@00O@
30000m00000D0003C`0000=?1@09C`?o2Tl90003C`0002P03=000oo@d007d0`000?@000050000dl0
0004C`@02Dl3o`]?20000dl0000N00003P09d004om3@o`W@30000m00000D0003C`0000P024l2o`U?
00?oCdl02@000dl0000X00W@00Cod=3o2M0<0003d00001@000=?00002008C`;o2Dl01?m?Cdl80003
C`0001h0000>00[@0_l:d0`000?@000050000dl0000800M?00?oCdl00ol7C`03odl000T000=?0000
9`0:d0;o2]0<0003d00001@000=?00002007C`03odm?00?o1dl00om?C`090003C`0001d0000G00Go
5@000m00000B00A?2004o`<000?o00000P05o`<000?o00002@000dl0000`00Go5@000m00000B00A?
2004o`<000?o00000P05o`<000?o00002@000dl0000M00005`001?l00?lF0003d00001<000=?0000
2@000ol000030003o`00008000Co003o10000ol0000:0003C`0002l000Co003o5P000m00000C0003
C`0000T000?o00000`000ol000020004o`00o`@000?o00002P000dl0000L00005`04oaH000?@0000
4`03C`T000?o00000`000ol0000200Co10000ol0000;0003C`0002h01?lF0003d00001<00dl90003
o`0000<000?o00000P04o`@000?o00002`000dl0000K00006P000ol0000E0003d00001h000?o0000
0`000ol000050003o`00008000?o00002`000dl0000a0003o`0001D000?@00007P000ol000030003
o`0000D000?o00000P000ol0000;0003C`0001/0000H00?o5`000m00000M00Co0`000ol0000300?o
10000ol0000<0003C`0002h00olG0003d00001d01?l30003o`0000<00ol40003o`0000`000=?0000
6P00038000?@00007P000ol000040003o`0000P000?o00003@000dl000180003d00001h000?o0000
10000ol000080003o`0000d000=?00006P00038000?@00007P03ob0000=?0000A`000m00000N00?o
80000dl0000I0000<`000m0000110003C`0004L000?@0000@@000dl0000H0000<`000m00002;0003
d00005`0003o0240000W01O@;P0FCc@05]0^01I?400002L02]03o`[@9P03C`D02Dl3o`Y?=009d0?o
2]0V00=?1@09C`?o2Tl@00009`0=d003om3@00O@9P06C`8034l00om?C`07Cc@03=000oo@d007d2H0
1Tl200a?00?oCdl01dl@00009`0=d003om3@00O@00<0Cdl0:Tl00`1?C`08C`?o2Dld00c@00?od=00
1m000`1?C`0ZC`0304m?00Q?0ol9Ca00000W00_@0_l:d0T000=?00006P03C`D02Dl01?m?Col9Cc@0
2]02o`[@2@000dl0000J00=?1@09C`04odm?o`U?400002L03M000oo@d007d0T000=?00008P08C`;o
0Tl00om?C`04C`03odm?03@03=000oo@d007d0T000=?00008P08C`;o0Tl00om?C`04C`03odm?0100
000W00[@0ol:d0T000=?00008P07C`03odm?00;o24l00om?000c00W@0ol:d0T000=?00008P07C`03
odm?00;o24l00om?000?0000<@04oa4014lR00Co0`000ol0000200Co10000ol0000l00Co4@04Cb80
1?l30003o`0000801?l40003o`0000l0000a0005o`000?l04@000dl0000S0003o`0000<000?o0000
0P001Ol0003o00<000?o0000?0001Ol0003o014000=?00008`000ol000030003o`00008000Go0000
o`030003o`0000l0000a0005o`000?l04@03Cb<000?o00000`000ol000020005o`000?l00`000ol0
000l0005o`000?l04@03Cb<000?o00000`000ol000020005o`000?l00`000ol0000?0000<@001Ol0
003o03L000?o00000`000ol000020005o`000?l00`000ol0000l0005o`000?l0=`000ol000030003
o`00008000Go0000o`030003o`0000l0000a00Co=`04o`<000?o00000P04o`@000?o0000?004ocL0
1?l30003o`0000801?l40003o`0000l0000a0003o`0003T000?o000010001Ol0003o00H000?o0000
?@000ol0000i0003o`0000@000Go0000o`060003o`000100000`00;o>`03o`L00_m500;o>`03o`L0
0_lI0000o`0Q0000o`0Q00007P057`;o41l2ob<01Al2oa0O0_li00DO0_l@7`;o8`057`;o41l2oal0
000N00DO00?o7al041l00ol0000Q00DO00?o7al041l00ol0000g00DO00?o7al041l00ol0000Q00DO
00?o7al041l00ol0000M00007004o`<000?o00000P03o`@00_l50003o`0001l01?l30003o`000080
0ol400;o1@000ol0000e00Co0`000ol0000200?o1002o`D000?o00007`04o`<000?o00000P03o`@0
0_l50003o`0001d0000M0003o`3o00<000?o00000`000ol000020004o`00o`@000?o000080000ol0
o`030003o`0000<000?o00000P001?l00?l40003o`0003H000?o0?l00`000ol000030003o`000080
00Co003o10000ol0000P0003o`3o00<000?o00000`000ol000020004o`00o`@000?o00007@0001d0
00?o00000`000ol000030003o`00008000Co003o10000ol0000P0003o`0000<000?o00000`000ol0
00020004o`00o`@000?o0000=P000ol000030003o`0000<000?o00000P001?l00?l40003o`000200
00?o00000`000ol000030003o`00008000Co003o10000ol0000M00007P000ol000020003o`0000<0
00?o00000P001?l00?l40003o`00024000?o00000P000ol000030003o`00008000Co003o10000ol0
000g0003o`00008000?o00000`000ol000020004o`00o`@000?o00008@000ol000020003o`0000<0
00?o00000P001?l00?l40003o`0001d0000L0003o`3o00@000?o00000`000ol000020004o`00o`@0
00?o00007`000ol0o`040003o`0000<000?o00000P001?l00?l40003o`0003D000?o0?l010000ol0
00030003o`00008000Co003o10000ol0000O0003o`3o00@000?o00000`000ol000020004o`00o`@0
00?o00007@0001`01?l300;o0`02o`D00_l400;o8@04o`<00_l300;o1@02o`@00_lg00Co0`02o`<0
0_l500;o1002ob401?l300;o0`02o`D00_l400;o7`000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {95.75, 0}} -> {-0.0578986, -0.0168103, 
  0.00737212, 0.00737212}, {{7.8125, 137}, {93.4375, 
  2.25}} -> {-3.95759, -1.39575, 0.116807, 0.116807}, {{149.938, 279.125}, {
  93.4375, 2.25}} -> {-20.5589, -1.39575, 0.116807, 0.116807}},
  CellTags->"Properties"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "Whereas ",
  StyleBox["MorphismQ", "MR"],
  " checks every pair of elements to see if the operations are preserved, ",
  StyleBox["ProbableMorphismQ", "MR"],
  " pursues the same question randomly by testing a shorter list of pairs."
}], "Text",
  CellTags->"Properties"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ProbableMorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["probably",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(a\ morphism\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["ProbableMorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["use",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"], " ", "to", " ", "determine", " ", 
              "if", 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["f",
                FontSlant->"Italic"], " ", "is", " ", "probably", " ", "a", 
              " ", "morphism"}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.43, 0.57}},
  CellTags->{"Properties", "i:17"}],

Cell["Probabilistic approach to checking if a morphism.", "Caption",
  CellTags->"Properties"],

Cell[TextData[{
  "We can use a probabilistic approach to check for morphisms with the ",
  StyleBox["ProbableMorphismQ", "MR"],
  " function."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProbableMorphismQ[f\_r]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(ProbableMorphismQ::"warning" \( : \ \) 
      "The ProbableMorphismQ function is being used; 'True' results are only \
probable, not certain."\)], "Message",
  CellTags->"Properties"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->"Properties"]
}, Open  ]],

Cell["There are several options to consider for this function.", "Text",
  CellTags->"Properties"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              FontSlant->"Italic"], 
            StyleBox[\(default\ value\),
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["PrintMessage",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["warning",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["given",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["about",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["probabilistic",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["approach",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["SampleSize",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["5",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["size",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sample",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["checking",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["randomly",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["SamplePairs",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Random",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["method",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["which",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["pairs",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["checked",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["(",
                SingleLetterItalics->False], 
              StyleBox["alternatively",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Default",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["uses",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["built\[Hyphen]in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["pairs",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["positions",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["can",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["provided",
                SingleLetterItalics->False], 
              StyleBox[")",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.22, 0.17, 0.61},
  RowLines->{True, False}},
  CellTags->{"Properties", "i:18"}],

Cell[TextData[{
  "Options for ",
  StyleBox["ProbableMorphismQ",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Properties"],

Cell["\<\
If we choose pairs carefully, we can obtain erroneous results with \
this function. Here we use pairs of positions in the domain, where {3, 6} \
indicates that we are testing the third element (2) and the sixth element \
(5).\
\>", "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProbableMorphismQ[f\_r, \ PrintMessage\  \[Rule] \ False, \ 
      SamplePairs\  \[Rule] \ {{1, 1}, {1, 6}, {3, 6}, {6, \ 8}}]\)], "Input",\

  CellLabel->"In[49]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "Setting the ",
  StyleBox["SampleSize", "MR"],
  " is immaterial when we use the built-in list of pairs specified by ",
  StyleBox["Default", "MR"],
  "."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProbableMorphismQ[f\_r, \ SampleSize\  \[Rule] \ 2000, \ 
      SamplePairs\  \[Rule] Default, \ PrintMessage\  \[Rule] \ False]\)], 
  "Input",
  CellLabel->"In[50]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "A function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is an ",
  StyleBox["isomorphism",
    FontSlant->"Italic"],
  " if it is an injective and surjective (i.e., bijective) homomorphism."
}], "Text",
  CellTags->"Properties"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["IsomorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["isomorphism",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["using",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["ProbableMorphismQ",
                      "MR"]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["IsomorphismQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Cautious\  \[Rule] \ True\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["isomorphism",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["using",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["MorphismQ",
                      "MR"]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Properties", "i:19"}],

Cell[TextData[{
  StyleBox["IsomorphismQ",
    FontFamily->"Courier"],
  " variations."
}], "Caption",
  CellTags->"Properties"],

Cell[TextData[{
  "The function on ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_20\)]],
  " defined by the rule 1 ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " 5 is not surjective, thus failing one of the requirements to be an \
isomorphism."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsomorphismQ[ZMap[20, \ 20, \ 1\  \[Rule] \ 5]]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(Morphoid::"notonto" \( : \ \) 
      "Since the Morphoid is not onto, it can not be an isomorphism."\)], 
  "Message",
  CellTags->"Properties"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "If we send 1 to a generator such as 7, we do obtain an isomorphism. (At \
least we are informed that it is ",
  StyleBox["probably",
    FontSlant->"Italic"],
  " an isomorphism.)"
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsomorphismQ[ZMap[20, \ 20, \ 1\  \[Rule] \ 7]]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(ProbableMorphismQ::"warning" \( : \ \) 
      "The ProbableMorphismQ function is being used; 'True' results are only \
probable, not certain."\)], "Message",
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "If we want to be certain, we can use the ",
  StyleBox["Cautious", "MR"],
  " option. (Using ",
  StyleBox["SetOptions", "MR"],
  ", we can change it so that ",
  StyleBox["True", "MR"],
  " is the default value for this option)."
}], "MathCaption",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsomorphismQ[ZMap[20, \ 20, \ 1\  \[Rule] \ 7], \ 
      Cautious\  \[Rule] \ True]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "4.5 ",
  StyleBox["Kernel",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Image",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["InverseImage",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->"Kernel"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Kernel",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["kernel",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((as\ a\ groupoid\ or\ ringoid)\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              
              StyleBox[
                \((assuming\ the\ codomain\ has\ an\ identity\ element)\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Image",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["image",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((as\ a\ groupoid\ or\ ringoid)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Image",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["S",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["image",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((as\ a\ groupoid\ or\ ringoid)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subset",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["S",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ of\ the\ domain\ under\ the\ \),
                SingleLetterItalics->False], 
              StyleBox["Morphoid",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["f",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.21, 0.79}},
  CellTags->{"Kernel", "i:20"}],

Cell[TextData[{
  StyleBox["Kernel",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Image",
    FontFamily->"Courier"],
  " functions."
}], "Caption",
  CellTags->"Kernel"],

Cell[TextData[{
  "Define the following ",
  StyleBox["Morphoid", "MR"],
  " that is not a homomorphism."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f\  = \ FormMorphoid[Mod[#\  - \ 2, \ 13]&, \ Z[5], \ Z[13]]\)], "Input",\

  CellLabel->"In[54]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \(Morphoid[Mod[#1 - 2, 13]&, "-Z[5]-", "-Z[13]-"]\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "It still makes sense to ask about the kernel, even if ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " does not satisfy ",
  StyleBox["Mor", "MR"],
  StyleBox["phi", "MR"],
  StyleBox["smQ", "MR"],
  "."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \({MorphismQ[f], Kernel[f]}\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \({False, Groupoid[{2}, Mod[#1 + #2, 5]&]}\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Kernel", "MR"],
  " function has a ",
  StyleBox["Visual", "MR"],
  " mode."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(K\  = \ Kernel[ZMap[12, \ 4], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"Kernel"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .51948 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.0865801 0.0865801 0.0865801 [
[ 0 0 0 0 ]
[ 1 .51948 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .51948 L
0 .51948 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[12])] .5 .47619 0 0 Mshowa
[(0)] .02381 .4329 0 0 Mshowa
[(1)] .11039 .4329 0 0 Mshowa
[(2)] .19697 .4329 0 0 Mshowa
[(3)] .28355 .4329 0 0 Mshowa
[(4)] .37013 .4329 0 0 Mshowa
[(5)] .45671 .4329 0 0 Mshowa
[(6)] .54329 .4329 0 0 Mshowa
[(7)] .62987 .4329 0 0 Mshowa
[(8)] .71645 .4329 0 0 Mshowa
[(9)] .80303 .4329 0 0 Mshowa
[(10)] .88961 .4329 0 0 Mshowa
[(11)] .97619 .4329 0 0 Mshowa
[(Z[4])] .5 .04329 0 0 Mshowa
[(0)] .02381 .08658 0 0 Mshowa
[(1)] .28355 .08658 0 0 Mshowa
[(2)] .54329 .08658 0 0 Mshowa
[(3)] .80303 .08658 0 0 Mshowa
1 0 1 r
.5 Mabswid
[ ] 0 setdash
.02381 .40693 m
.02381 .11255 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.11039 .40693 m
.28355 .11255 L
s
% Start of user PostScript
1. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
.19697 .40693 m
.54329 .11255 L
s
% Start of user PostScript
2. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
.28355 .40693 m
.80303 .11255 L
s
% Start of user PostScript
3. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.37013 .40693 m
.02381 .11255 L
s
% Start of user PostScript
4. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.45671 .40693 m
.28355 .11255 L
s
% Start of user PostScript
5. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
.54329 .40693 m
.54329 .11255 L
s
% Start of user PostScript
6. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
.62987 .40693 m
.80303 .11255 L
s
% Start of user PostScript
7. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.71645 .40693 m
.02381 .11255 L
s
% Start of user PostScript
8. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.80303 .40693 m
.28355 .11255 L
s
% Start of user PostScript
9. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
.88961 .40693 m
.54329 .11255 L
s
% Start of user PostScript
10. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
.97619 .40693 m
.80303 .11255 L
s
% Start of user PostScript
11. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[56]:=",
  ImageSize->{288, 149.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000U@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000RnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l02P;V0^H2iP;V0^H2o`260^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H10000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000Q>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0PCo00WV0^KoiP;V0^H00ol0RnH2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFoiKfU_nFmYKfU_KomYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000093V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VonH2iP;VonH2iP84o`2;iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_JFoiKfU_Kom_ofU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2o`;V0^Ko
iP;V0_l2o`;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000024U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf1?l00iKfUP02o`04
mYKfUP;o00CfU_JF0_l0Q_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81000000JFmYKfU_H2o`17U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00ol0AiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00Co04OfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mP03o`0hmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH100000?oV0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000oiKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003U
iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02o`0h0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP4000001^H2iP;V0P;o
04OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP02o`190^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P02o`18iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol0>0;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000007iP;V0^H2iP05C`15iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00=<04KV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20d`0A`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200=<03P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP4000001iKfU_JFmYH034l0@?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9H4C011
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_H01d`0@OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKf00M<03SfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP4000001nH2iP;V0^H03dl0>^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP83C0030Ta<00E<03/2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P0;C00l0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V2d`0=nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000006U_JFmYKf
44l0>IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP02C004mTa<UPU<03JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H?C00fmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF3D`0>II<C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000000KV0^H2iP8@C`0hiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP83C0050Ta<C0802T`0<nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0:C0030Ta<00E<0382iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPm<03WVC4a<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000006U_JFmYKf0dl00oI?C`09C`0hmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH4C003mTa<009<
00>FC4`01d`0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
24`01OI<C4cf00U<033fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH>C003mYI<00=<03CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@000005iP;V0^H014l00`;VC`0;C`0e0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8014`00nH2iP04C0030Ta<00E<0302iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H9C003iP9<00=<00?VC4`024`0;`;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200e<00<2iP8014`0<nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000000FFmYKfUP04C`03
mYI?00U?00?fUTl00Tl0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01D`00iKfUP05C003UTa<00A<02ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP0:C003U_I<00=<00>FmT`02D`0;iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00a<00?fU_H01D`0<_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000005iP;V0^H01Dl00nH2C`07C`06iP;V0^H20Tl0;^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP86C003iP;V00I<00<2C4`0
0T`0<NI<C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H024`00`;V
C004C003iP;V00Q<02h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
3D`01>H2iP86C00aiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP01000000FFmYKfUP05C`03U_JF00M?00RFmYKfU_JFmP9?02^FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00M<00>FmYH01d`01iI<C4bFmYH00T`0;OJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP06C003U_JF00E<00>FmYH01d`0;IKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C003mYKf00Y<00BFmYKf1d`0<?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP4000001>H2iP86C`03
iP;V00E?00cVCnH2iP;V0^H2iP83C`0W0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H200M<00D2iP;V0P07C0080T`2iP;V0^H2C00/0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;VC>H5C003iP;V00I<00<2iP801T`0:nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H00T`01P;V0^H2iPU<00GV0^H2iP07C00_iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000004U_JFmPI?00BFmYKf0dl00oJFmP02C`0;
U_JFmYKfU_JFmYH00Tl09?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUPQ<00GfU_JF
mP08C00aU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C003
mYKf00=<00CfU_JF1T`01?JFmYH3C00eU_I<C9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYH024`01_JFmYKfUPQ<02kfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JF0@000004iP;V0PI?01WV0^H2iToV0^H2iP9?0^H2iP;V0^H2iP;V009?
02@2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H6C0050^H2iP801T`03>H2iP;V0^H2
iP;V0P9<037V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;VC>H2iP;V00I<
0342iP;V0T`2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2009<00_V0^H2
iP;V0^H2iP06C0060^H2iP;V1T`0<0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP4000000iKfUP08C`0JmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYH3C`0RU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPA<00NFmYKfU_JF00A<00ofU_JFmYKfU_JFmYKfU_H0
0T`0;YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_H8C00^U_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<00nFmYKfU_JFmYKfU_JFmYH0
14`01oJFmYKfU_H014`0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@000003iP;V00Q?01d2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0P02C`10iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^I<iP;V0^H2iTcV0^I<iP;V0^H2iP;V0^H2iP;V0P9<
02cV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0PQ<02cV0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<057V0^H2iP;V0^H2iP;V0^H2C0;VC>H2
iP;V0^H2C0;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@00000ZU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKf0dl0l_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmTcfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JF
C9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00000]
iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V009?03h2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP9<05X2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP9<
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C01D0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V
0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000K
U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JF009?01;fU_JFmYKfU_JFmYKfU_JFmYH2C`0nmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYH2C00E
mYKfU_JFmYKfU_JFmYKfU_JFmYKf009<02NFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf
U_JFmYH00T`05_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH2C01FmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JF
mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH10000037V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V00=?
03gV0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V009<0582iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V
0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0T`0F0;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V
0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H1000003BFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKf
0Tl0?IKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00T`0C_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfUP9<05[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JF
mYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000003KV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP82C`3WiP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
0000>9KfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0dl0>oJFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf009<04RFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_H2C01MU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0040
00008NH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C`0H0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0Tl0>`;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2009<00KV0^H2iP82C00ciP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V009<00L2iP;V0^H2009<05oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000003fFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF009?03_fU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmP02C010U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmP9<066FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00400000?nH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP03C`3MiTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00@000012U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0Tl0>IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP02C00jmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<06CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@000014iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C082C`0iiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V009<03H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C01V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@000016U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmP=?03SfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUTbFmYKfUP9<03;fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP9<06SfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000:>H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C`0OiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP02C`0^0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP9<00P2iP;V0^H2iP9<02h2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0T`01`;V0^H2iP800T`0HNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00001;U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
CoJFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JF00=?0=6FmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000004kV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP82C`0fiP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H20T`0:>H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP82C01]iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP010000052FmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTof
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmP9?03JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_H2C00TU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKf0T`0KiKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000005;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H20dl0=@;V0^H2iP;V0^H2iP;V0T`2iP;V
0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2009<023V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0P9<077V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000005FFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
CoJFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009?0<SfU_JFmYKfU_JFmYKfC?JF
mYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000;nH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V009?
02H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?01T2iP;V0^H2iP;V0^I<iP;V
0^H2iP;V0^H2009<01WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V009<01X2iP;V0^H2iP;V0^I<iP;V
0^H2iP;V0^H2iP9<01P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C01J0^H2iP;V0^H2iP;V0T`2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@00001IU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTnFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00dl0<iKfU_JFmYKf
U_I<mYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C00FmYKfU_JFmYKfUTbF
mYKfU_JFmYKfUP9<07KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFC9KfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00001LiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9?0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C`0ciP;V0^H2
iP9<0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V009<0182iP;V0^H2iTcV
0^H2iP;V0^H2C01h0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;VC>H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@00001NU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFCiKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9?03>FmYKf
U_JFC9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`03_JFmYKfUTbF
mYKfU_JF0T`0N_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_I<mYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00001PiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0Tl2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20dl0_0;V
0^I<iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;VC>H2iP;V
0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP9<0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@00000eU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00Tl0;?JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0Tl01oJF
mTcfU_H00T`0:9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C008U_JFC9Kf
U_H2C00WU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<05CfU_JFC9KfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH1000006GV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VCnH2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP02C`0a0^I<iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P02C004
iTcV0P9<07oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00400000IiKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfCdbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00dl0<4cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPA<
086FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00001ZiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC09?02oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C022
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000K9KfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?I<mP=?02[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH3C00aUTa<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C01@mYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYH1000006oV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iTcV0^H00Tl09P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`01P;VC>H2iP9<
07h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;VC>H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H1000003bFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfU_H2C`0WU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<
00[fU_JFC9KfU_JF0Tl08_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH2C00:mYKfUTbF
mYKfUP9<02gfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_H00T`0CIKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00400000LnH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0T`2iP;V0^H00dl0ZNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^I<
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00001fU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfUTbFmYKfU_JFmP9?01ZFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<012FmYKfU_JFC9Kf
U_JFmYKf0T`0NIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00001hiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iTcV0^H2iP;V0^H20Tl05^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C00DiP;V0^H2iP;VC>H2
iP;V0^H2iP82C01giP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00001jU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_H3C`0AmYKfU_JFmYKfU_JFmYKfU_H00T`069KfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmP9<07FFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@000012iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H20Tl06nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C00L
0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP9?00d2iP;V0^H2iP;V0^H2009<01cV0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H20T`0:^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0P9<04OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP01000007nFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF009?09kfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfUTbFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JF
mYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP400000PNH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP03C`05iP;V0^H00T`08P;V0^H2iP;V0^H2iP;V
0^I<iP;V0^H2iP;V0^H2iP;V0^H2C01`0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V
0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP400000Q9KfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmP9?02VFC4cfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfUP02C01^mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JF
mYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH1000008KV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;VC09?02WV0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP02C01/0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V
0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@000028U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfC?JFmP=?09CfU_JFmYKfU_JFmYKfU_JFC9KfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_I<
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@000019iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C`0=0^H2iP;V0^H2iP;V0P02C00XiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0P9<00OV0^H2iP;V009?02L2iP;V0^H2iP;V0^H2iTcV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800T`09nH2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP02C0100^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP400000P9KfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf0T`02iKfU_JFmYKfU_JF00=?02JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<06NFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00400000O^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0P9<013V0^H2iP;V0^H2iP;V0^H20Tl09^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0INH2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00400000O9KfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_H2C00DU_JFmYKfU_JFmYKfU_JFmYKfU_H2C`0VU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C01SU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00400000U>H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP83C`280^H2iTcV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000NIKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYH00T`07?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH2C`0TmYI<U_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0T`0H?JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000D>H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20Tl094`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P=<0202iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?02A<iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H3C00RiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P9<03WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00001eU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mTofU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF009<02CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH3C`0S
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`0G?JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00002NiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^I?iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP82C`1o
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP01000007:FmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H2C00/U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_H2C`0R
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmP9<05VFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfUP010000073V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20T`0<>H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0P=?
0242iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP800T`0EnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP01000004^FmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`02OJFmYKfU_JFmP02C`0FU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP9<03FFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfUP02C`0QmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf009<022FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<03>FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYH00@00001/iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0Tl2iP;V0^H2
iP;V0^H2iP;V0^H20T`0>NH2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP02C`0Q0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2009<05?V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP0100000:VFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfUTnFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JF00=?07>FmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JF00400000JNH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2
iP;V0^H2iP02C0110^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
C>H2iP;V0^H2iP;V0^H2iP800Tl07nH2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H00T`0D0;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^I<iP;V0^H2iP;V0^H2iP;V0@00001WU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKf
U_JFmYKfUP02C015mYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI<U_JFmYKfU_JFmYKfU_JFmYKf00=?01kfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYH2C01>
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI<U_JFmYKfU_JFmYKfU_JF0@00001UiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2
iP;V0^H00T`0BP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl07P;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<
04`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2C0;V0^H2iP;V0^H2iP;V0@000014U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C00GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0Tl0E?JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9?03cfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH2C00/mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_I<mYKfU_JFmYKfU_JFmYH1000006;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iToV0P9<057V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00dl07>H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP82C019iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP0100000;RFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I?C9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0Tl074cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H2C017U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYH00@00001NiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<
05[VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iT`2C`0LiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P9<04GV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H00@00002lU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_H3C`1PmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
C9KfU_JFmYKfU_JF0@00000niP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP82C00KiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V009<00H2iP;V
0^H2C`1J0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
C>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0Tl06P;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0T`06P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`09P;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;VC>H2iP;V0^H2iP;V0@00001IU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`0I_JF
mYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfUP9?01[fU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP9<043fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmTcfU_JFmYKfU_JF0@00001GiP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V009<06X2iP;V
0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0dl06NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00T`0?P;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0T`2iP;V0^H2iP;V0@00001EU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C01_mYKfU_JF
mYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf009?01VFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF009<03cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUTbFmYKfU_JFmYH100000<SV0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0P9?05GV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V00400000DYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C01fU_JFmYKfU_JFmYKf
U_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmP=?01OfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP02C00iU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JF00400000onH2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0008>H2iP;V0^I?iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP4000001^H2
iP;V0P;o01KV0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol05@;V0^H2iP;V0^H2iP;V0^H2iP;V0P04o`0E
iP;V0^H2iP;V0^H2iP;V0^H2iP;V00?o01OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP03o`0EiP;V0^H2
iP;V0^H2iP;V0^H2iP;V00?o01KV0^H2iP;V0^H2iP;V0^H2iP;V0^H20_l0<>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P;o01KV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0ol04P;V0^H2iP;V0^H2iP;V0^H2iP?o00CV0^H20_l04>H2iP;V0^H2iP;V0^H2iP83o`030^H200?o
00@2iP;V0@00003oU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFoiKfU_JFmYKfU_JFmYKfU_JFm_ofU_JF000PU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_l1000006SV0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0PCo07WV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00?o
03OV0^H2iP;V0^H2iP;V0^H2iP;o0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;VonH2iP;VonH2iP;V0040
0000D9KfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0_l0;iKfU_JFmYKfU_JFmYKfU_JFmYKfU_Kom_ofU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00?o01FFmYKfU_JFmYKfU_JFmYKfU_JFmYH00ol0<9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o056FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
ooJFoiKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKoU_JFmYKoU_JFmYH0
0@00003oiP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
o`;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0_l2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;VonH2
iP;V0^H2iP;V0^H2iP;V0_l2iP;V000PiP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_l10000
00JFmYKfU_H2o`0FU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o01NFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP02o`0FmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP?o01NFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02o`0F
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUPCo01GfU_JFmYKfU_JFmYKfU_JFmYKfU_H00ol05OJFmYKfU_JF
mYKfU_JFmYKfU_JFmP04o`0FU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o01NFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP02o`0BmYKfU_JFmYKfU_JFmYKfU_JF0_l01OJFmYKf00;o012FmYKfU_JFmYKfU_JFmYKf
0_l019KfU_H2o`05U_JFmYH00@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1000008SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20_l04>H2iP;V0^H2iP;V0^H2iP82o`23iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
087V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H01?l020;V0_l2iP;V0ol00nH2iP04o`280^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_Kom_ofU_KomYKfU_KomYKfU_KomYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0_l2iP;V0_l2iP;V0_l2iP;V0^KoiP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_nFmYKfooJFmYKfooJFmYKfU_KomYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oVonH2
iP;o0^H2iP;o0^H2i_oV0_l2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000021U_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00Co00?fU_H0
0_l00iKfUP02o`05mYKfU_H00_l019KfU_H2o`23U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {148.562, 0}} -> {-0.295592, -1.00003, 
  0.0403874, 0.0403874}},
  CellTags->"Kernel"],

Cell[BoxData[
    \(Groupoid[{0, 4, 8}, Mod[#1 + #2, 12]&]\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "Using the ",
  StyleBox["Parity", "MR"],
  " function, the image of all elements in ",
  Cell[BoxData[
      \(TraditionalForm\`A\_3\)]],
  " is 1."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Image[FormMorphoid[Parity, Alternating[3], \ IntegerUnits]]\)], "Input",\

  CellLabel->"In[57]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \(Groupoid[{1}, Times]\)], "Output",
  CellLabel->"Out[57]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "We make a quotient group with the kernel ",
  StyleBox["K", "MR"],
  " as a normal subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  " and form a morphism between it and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  "."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FormMorphoidSetup[QuotientGroup[Z[12], \ K], \ Z[4]]; \)\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \(QuotientGroup::"NS" \( : \ \) 
      "This quotient group uses NS to represent the normal subgroup \!\({0, \
4, 8}\) that you specified. Use CosetToList to convert this coset \
representation to a list of elements."\)], "Message",
  CellTags->"Kernel"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .4 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.05 0.2 0.05 [
[ 0 0 0 0 ]
[ 1 .4 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .4 L
0 .4 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .05 m
.5 .35 L
s
[(Domain)] .2 .3 0 0 Mshowa
[(Codomain)] .8 .3 0 0 Mshowa
[(NS)] .2 .25 0 0 Mshowa
[(1)] .45 .25 0 0 Mshowa
[(1 + NS)] .2 .2 0 0 Mshowa
[(2)] .45 .2 0 0 Mshowa
[(2 + NS)] .2 .15 0 0 Mshowa
[(3)] .45 .15 0 0 Mshowa
[(3 + NS)] .2 .1 0 0 Mshowa
[(4)] .45 .1 0 0 Mshowa
[(0)] .8 .25 0 0 Mshowa
[(1)] .55 .25 0 0 Mshowa
[(1)] .8 .2 0 0 Mshowa
[(2)] .55 .2 0 0 Mshowa
[(2)] .8 .15 0 0 Mshowa
[(3)] .55 .15 0 0 Mshowa
[(3)] .8 .1 0 0 Mshowa
[(4)] .55 .1 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[58]:=",
  ImageSize->{288, 115.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000L`P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0002P00ol;0003o`0000H00_l20003o`0000?o=`03o``0
00?o00002P03od@00olj0000:`000ol000080003o`0000L000Co0?oo0P001?l00?lg0003o`0000/0
00?o00002`000ol000160003o`0003L0000[0003o`0000H01Ol70004o`3oo`@00_le00Co30000ol0
000900CoA`000ol0000g0000:@02o`/000?o00001`02o`040?l000;o=`000ol0o`0=0003o`0000T0
00?o0?l0AP02ocX0000[0003o`0000P000?o00001`02o`050?l00?l00P000ol0000c0003o`3o00d0
00?o00002@000ol0o`180003o`0003L0000X00?o5002o`800_l200?o=P02o`d000?o00002P02odD0
0olj0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000:004o`X000?o00001P02o`80
00?o00000olf00?o3@000ol0000900?oA@04ocT0000Y0003o`0000X000?o00001`001?l0ool20004
o`00ocP000?o00002P000ol0000<0003o`0004<000?o0000>@0002X000?o00001`05o`L000Co0?oo
1002ocP000?o00002P000ol0000<0003o`0004@000?o0000>00002/000?o000020000ol0000700;o
00@0o`000_lh00;o3@000ol0000:00;oB0000ol0000g0000:0001?l00?l:0003o`0000L00_l01@3o
003o008000?o0000=P000ol0000:0003o`0000`000?o0000@P001?l00?li0000:@02oa@00_l200;o
0P03ocD00ol=0003o`0000T00om600;o>P0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0002P00ol;0003o`0000H00_l20003o`0000?o=P04o``000?o00002@04od@00olj0000:@000ol0
000:0003o`0000L000Co0?oo0P001?l00?lf0003o`0000`000?o00002P000ol000150003o`0003T0
000Y0003o`0000P01Ol70004o`3oo`@00_lg0003o`0000/000?o00002`000ol000140003o`0003T0
000Y0003o`0000X000?o00001`02o`040?l000;o>P000ol0000:0003o`0000`000?o0000@`000ol0
000i0000:@000ol0000:0003o`0000L00_l01@3o003o008000?o0000<`001?l00?l<0003o`0000T0
00Co003oA@000ol0000i0000:002oaD00_l200;o0P03ocH00_l=0003o`0000X00_m500;o>`0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0003<00_l20003o`0000?o
@P03o`d000?o00002@03odH00_lj0000=0001?l0ool20004o`00od8000?o000030000ol0000:0003
o`0004@000Co003o>@0003@000Co0?oo1002od8000?o000030000ol0000:0003o`0004@000Co003o
>@0003@00_l0103o0002od@000?o000030000ol0000:0003o`0004@000Co003o>@0003@00_l01@3o
003o008000?o0000@0000ol0000<0003o`0000X000?o0000A0001?l00?li0000<`02o`800_l200?o
@@02o`h000?o00002@02odL00_lj0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000
S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000
9`05o`<00ol20006o`3o0?l01Ol00`3oo`03o`040?oo00;oA0000ol0000l00Co0`03o`<01Ol0103o
ool20006o`3o0?l01Ol00`3oo`03o`040?oo00;o8`0002P000Oo0000o`3o00<000Wo0?l0o`3o0?l0
0P000ol000020005o`000?l00P000ol000130003o`0003/000?o000010001ol0003o0?l00`000ol0
o`030009o`3o0?l0o`3o008000?o00000P001Ol0003o008000?o00008P0002P000Oo0000o`3o00<0
00So0?l0o`3o00Co10001Ol0003o008000?o0000@`000ol0000k0003o`0000@000Oo0000o`3o00<0
00?o0?l00`002?l0o`3o0?l01?l40005o`000?l00P000ol0000R0000:0001ol0003o0?l00`001ol0
o`3o0?l010000ol000020005o`000?l00P000ol000130003o`0003/000?o000010001ol0003o0?l0
0`000ol0o`030007o`3o0?l0o`040003o`00008000Go0000o`020003o`000280000X0005o`000?l0
0P03o`030?oo00Co0P03o`<00_l200GoA@000ol0000k0005o`000?l00`03o`<01?l200?o00<0ool0
1?l200?o0`02o`801OlT00009`05of<000?o0000?004o``000?o0000?`00048000?o0000BP000ol0
001;00;o5@000ol0000Y0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0
002>0000S`000ol0002>0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {114.188, 0}} -> {-10.0537, -4.00004, 
  0.0700609, 0.0700609}},
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "The First Isomorphism Theorem guarantees that this is an iso",
  "morphism",
  "; ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " agrees."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsomorphismQ[\ 
      FormMorphoid[{1, 2, 3, 4}, \ QuotientGroup[Z[12], \ K], \ Z[4]]]\)], 
  "Input",
  CellLabel->"In[59]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell["\<\
Note that the codomain is the target set, while the image is the \
set that is actually hit.\
\>", "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f\  = \ ZMap[12, 24, \ 1\  \[Rule] 2]; \n
    Map[Elements, {Codomain[f], Image[f]}]\)], "Input",
  CellLabel->"In[60]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \({{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
        20, 21, 22, 23}, {0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22}}\)], 
  "Output",
  CellLabel->"Out[60]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InverseImage",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["y",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(give\ the\ list\ of\ elements\ in\ the\ domain\ of\ the\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], " ", 
                FormBox["f",
                  "TraditionalForm"], 
                StyleBox[\(\ whose\ image\ is\ \),
                  SingleLetterItalics->False], 
                FormBox["y",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["InverseImage",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{\(y\_1\), 
                        StyleBox[",",
                          "MR"], " ", \(y\_2\), 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(give\ the\ list\ of\ elements\ in\ the\ domain\ of\ the\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox["Morphoid",
                  "MR"], " ", 
                FormBox["f",
                  "TraditionalForm"], 
                StyleBox[\(\ whose\ image\ is\ in\ {\),
                  SingleLetterItalics->False], 
                FormBox[
                  RowBox[{
                    RowBox[{\(y\_1\), 
                      StyleBox[",",
                        SingleLetterItalics->False], " ", \(y\_2\), 
                      StyleBox[",",
                        SingleLetterItalics->False], " ", 
                      StyleBox["\[Ellipsis]",
                        SingleLetterItalics->False]}], "}"}],
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["InverseImages",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["f",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["equivalent",
                SingleLetterItalics->False], 
              StyleBox["  ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["InverseImage",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["f",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["Elements",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["Codomain",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["f",
                      "TI"], 
                    StyleBox["]",
                      "MR"], 
                    StyleBox["]",
                      "MR"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["but",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["partitioned",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["preimages",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["codomain",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["InverseImages",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(WithImages\  \[Rule] \ True\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(list\ the\ image\ elements\ with\ the\ list\ of\ preimages\ 
                for\ each\ image\ element\),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["Fiber",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["f",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["S",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"equivalent", " ", "to", " ", 
              RowBox[{
                StyleBox["InverseImage",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["f",
                    "TI"], 
                  StyleBox[",",
                    "TI"], " ", 
                  StyleBox["S",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Kernel", "i:21"}],

Cell["Functions related to inverse images.", "Caption",
  CellTags->"Kernel"],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["InverseImage", "MR"],
  " illustrates the elements that are mapped onto 2 for the ",
  StyleBox["Morphoid ZMap[12,4]", "MR"],
  "."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseImage[ZMap[12, \ 4], \ 2, \ Mode\  \[Rule] \ Visual]\)], "Input",\

  CellLabel->"In[61]:=",
  CellTags->"Kernel"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .51948 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.0865801 0.0865801 0.0865801 [
[ 0 0 0 0 ]
[ 1 .51948 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .51948 L
0 .51948 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[12])] .5 .47619 0 0 Mshowa
[(0)] .02381 .4329 0 0 Mshowa
[(1)] .11039 .4329 0 0 Mshowa
[(2)] .19697 .4329 0 0 Mshowa
[(3)] .28355 .4329 0 0 Mshowa
[(4)] .37013 .4329 0 0 Mshowa
[(5)] .45671 .4329 0 0 Mshowa
[(6)] .54329 .4329 0 0 Mshowa
[(7)] .62987 .4329 0 0 Mshowa
[(8)] .71645 .4329 0 0 Mshowa
[(9)] .80303 .4329 0 0 Mshowa
[(10)] .88961 .4329 0 0 Mshowa
[(11)] .97619 .4329 0 0 Mshowa
[(Z[4])] .5 .04329 0 0 Mshowa
[(0)] .02381 .08658 0 0 Mshowa
[(1)] .28355 .08658 0 0 Mshowa
[(2)] .54329 .08658 0 0 Mshowa
[(3)] .80303 .08658 0 0 Mshowa
0 0 1 r
.5 Mabswid
[ ] 0 setdash
.02381 .40693 m
.02381 .11255 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.11039 .40693 m
.28355 .11255 L
s
% Start of user PostScript
1. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.19697 .40693 m
.54329 .11255 L
s
% Start of user PostScript
2. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.28355 .40693 m
.80303 .11255 L
s
% Start of user PostScript
3. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
.37013 .40693 m
.02381 .11255 L
s
% Start of user PostScript
4. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.45671 .40693 m
.28355 .11255 L
s
% Start of user PostScript
5. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.54329 .40693 m
.54329 .11255 L
s
% Start of user PostScript
6. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.62987 .40693 m
.80303 .11255 L
s
% Start of user PostScript
7. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
.71645 .40693 m
.02381 .11255 L
s
% Start of user PostScript
8. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
.80303 .40693 m
.28355 .11255 L
s
% Start of user PostScript
9. 3.7 3. 0.3 MAarrowhead1
% End of user PostScript
1 0 1 r
.88961 .40693 m
.54329 .11255 L
s
% Start of user PostScript
10. 3.7 6. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.97619 .40693 m
.80303 .11255 L
s
% Start of user PostScript
11. 3.7 9. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[61]:=",
  ImageSize->{288, 149.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000U@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000RnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00_l02P;V0^H2iP;V0^H2o`260^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H10000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000Q>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0PCo00WV0^KoiP;V0^H00ol0RnH2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFoiKfU_nFmYKfU_KomYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000093V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VonH2iP;VonH2iP84o`2;iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_JFoiKfU_Kom_ofU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2o`;V0^Ko
iP;V0_l2o`;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000024U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf1?l00iKfUP02o`04
mYKfUP;o00CfU_JF0_l0Q_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP81000000JFmYKfU_H2o`17U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00ol0AiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00Co04OfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mP03o`0hmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH100000?oV0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2i_oV0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000oiKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003U
iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02o`0h0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP4000001^H2iP;V0P;o
04OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP02o`190^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P02o`18iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol0>0;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000007iP;V0^H2iP05C015iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00=<04KV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20dl0A`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200=<03P2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP4000001iKfU_JFmYH034`0@?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9H4C011
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_H01dl0@OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKf00M<03SfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP4000001nH2iP;V0^H03d`0>^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP83C0030Ta<00E<03/2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P0;C`0l0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V2d`0=nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000006U_JFmYKf
44`0>IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP02C004mTa<UPU<03JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H?C`0fmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF3D`0>II<C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000000KV0^H2iP8@C00hiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP83C0050Ta<C0802T`0<nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0:C`030Tm?00E?0382iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iPm<03WVC4a<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000006U_JFmYKf0d`00oI<C009C00hmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH4C003mTa<009<
00>FC4`01d`0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
24l01OI?Cdof00U?033fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH>C003mYI<00=<03CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@000005iP;V0^H014`00`;VC00;C00e0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8014`00nH2iP04C0030Ta<00E<0302iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H9C`03iP9?00=?00?VCdl024l0;`;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200e<00<2iP8014`0<nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP01000000FFmYKfUP04C003
mYI<00U<00?fUT`00T`0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH01D`00iKfUP05C003UTa<00A<02ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP0:C`03U_I?00=?00>FmTl02Dl0;iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00a<00?fU_H01D`0<_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000005iP;V0^H01D`00nH2C007C006iP;V0^H20T`0;^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP86C003iP;V00I<00<2C4`0
0T`0<NI<C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H024l00`;V
C`04C`03iP;V00Q?02h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
3D`01>H2iP86C00aiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP01000000FFmYKfUP05C003U_JF00M<00RFmYKfU_JFmP9<02^FmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00M<00>FmYH01d`01iI<C4bFmYH00T`0;OJFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP06C`03U_JF00E?00>FmYH01dl0;IKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C003mYKf00Y<00BFmYKf1d`0<?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP4000001>H2iP86C003
iP;V00E<00cVC>H2iP;V0^H2iP83C00W0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H200M<00D2iP;V0P07C0080T`2iP;V0^H2C00/0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;VCnH5C`03iP;V00I?00<2iP801Tl0:nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H00T`01P;V0^H2iPU<00GV0^H2iP07C00_iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@000004U_JFmPI<00BFmYKf0d`00oJFmP02C00;
U_JFmYKfU_JFmYH00T`09?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUPQ<00GfU_JF
mP08C00aU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C`03
mYKf00=?00CfU_JF1Tl01?JFmYH3C`0eU_I?CiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYH024`01_JFmYKfUPQ<02kfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JF0@000004iP;V0PI<01WV0^H2iTcV0^H2iP9<0^H2iP;V0^H2iP;V009<
02@2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H6C0050^H2iP801T`03>H2iP;V0^H2
iP;V0P9<037V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;VCnH2iP;V00I?
0342iP;V0Tl2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2009<00_V0^H2
iP;V0^H2iP06C0060^H2iP;V1T`0<0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP4000000iKfUP08C00JmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYH3C00RU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPA<00NFmYKfU_JF00A<00ofU_JFmYKfU_JFmYKfU_H0
0T`0;YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_H8C`0^U_JFmYKf
U_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<00nFmYKfU_JFmYKfU_JFmYH0
14`01oJFmYKfU_H014`0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@000003iP;V00Q<01d2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0P02C010iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^I<iP;V0^H2iTcV0^I<iP;V0^H2iP;V0^H2iP;V0P9<
02cV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0PQ?02cV0^H2iP;V0^H2
iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<057V0^H2iP;V0^H2iP;V0^H2C0;VC>H2
iP;V0^H2C0;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@00000ZU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf0d`0l_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmTcfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JF
CiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00000]
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V009<03h2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP9<05X2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP9?
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C01D0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V
0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00000K
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JF009<01;fU_JFmYKfU_JFmYKfU_JFmYH2C00nmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYH2C00E
mYKfU_JFmYKfU_JFmYKfU_JFmYKf009?02NFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKf
U_JFmYH00Tl05_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH2C01FmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JF
mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH10000037V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V00=<
03gV0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V009<0582iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V
0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0T`0F0;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V
0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H1000003BFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
0T`0?IKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00T`0C_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JF
mYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfUP9<05[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JF
mYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000003KV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP82C03WiP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
0000>9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0d`0>oJFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf009<04RFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I?mYKfU_JFmYKfU_H2C01MU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0040
00008NH2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C00H0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0T`0>`;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2009<00KV0^H2iP82C`0ciP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V009?00L2iP;V0^H2009<05oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000003fFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF009<03_fU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmP02C010U_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmP9<066FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00400000?nH2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP03C03MiTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00@000012U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0T`0>IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP02C02PmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTm<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000A>H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`20T`0>NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0Tl2iP02C00f0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0T`0IP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP400000AYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_H3C00hmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYI?U_JFmYH2C00bmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYH2C01XmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000002SV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`07nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H00T`0;P;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2C`080^H2iP;V0^H2C00^0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP9<00L2iP;V0^H2009?067V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00400000BiKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfUP03C03AU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@00001>iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H20T`0=^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0P9<02SV0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2
iP;V0^H2iP;V0^H20T`0KNH2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00@00001@U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_H2C00fU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKf0T`099KfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKf
U_JFmYKfU_JFmP9<06nFmYKfU_JFmYKfU_JFmYKfCoJFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@00001BiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0P=<03D2iP;V0^H2iP;V0^H2iP9<0^H2iP;V
0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0P02C00PiP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2
iP;V0^H2iP82C01aiP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00@00001EU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C038mYKfU_JFmYKfU_JFmTcfU_JF
mYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JF
mYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000002oV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C00V
0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C00I0^H2iP;V0^H2iP;VC>H2iP;V
0^H2iP;V0P02C`0IiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C00J0^H2iP;V0^H2iP;VCnH2iP;V
0^H2iP;V0^H2C00H0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl0FP;V0^H2iP;V0^H2iP9<0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000FIKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00=<03>FmYKfU_JFmYKf
C?JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`05_JFmYKfU_JFmYI?U_JF
mYKfU_JFmYH2C01fmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfUTbFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000G>H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0<nH2iP;V0^H2
C0;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C00B0^H2iP;V0^I?iP;V
0^H2iP;V0T`0N0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iTcV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000GYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2C00cU_JFmYKf
UTbFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<00kfU_JFmYI?U_JF
mYKfUP9<07[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfC?JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000H>H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P=<0;`2iP;V
C>H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iToV0^H2iP9<
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2C0;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP400000=IKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF009<02cfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<00OfU_I<
mYKf009?02RFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`029KfUTnFmYKf
0T`09iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C`1DmYKfUTbFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00001UiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0T`0<@;VC>I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800T`01>I?
iP82C01oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP01000003RFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP9<02fFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00d`0<4ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPA<
086FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfCoI<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00001ZiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;VC`9<0;?V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTm<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000006bFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTof
C?H3C00ZmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0T`0Q4nFC4cfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC4ofU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000KnH2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;VC>H2
iP02C00V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0060^I?iP;V0T`0OP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^I?iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP400000?9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmP9<02NFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00Tl02_JF
mYI<U_JFmYH2C00RmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<00[fU_JFCiKfU_JF
0T`0;OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmP02C`1=U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00001ciP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2
iP;V0^H2C0;V0^H2iP03C02YiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iToV0^H2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP9?0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000007JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKf
U_JFC9KfU_JFmYKf0T`06YKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`049KfU_JFmYI?U_JFmYKf
U_H2C01iU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFCiKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000007SV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2
iP;VC>H2iP;V0^H2iP82C00FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<01CV0^H2iP;V0^I?iP;V0^H2
iP;V0P9<07OV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0Tl2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000007ZFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmP=<017fU_JFmYKfU_JFmYKfU_JFmP02C00HU_JFmYKfU_JFmYI?U_JFmYKf
U_JFmYKf0T`0MIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYI?U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUP01000004;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP82C00KiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V009?01`2iP;V
0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0T`03@;V0^H2iP;V0^H2iP800T`07>H2iP;V0^H2iP;V0^I?
iP;V0^H2iP;V0^H2iP82C00ZiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
0Tl0AnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00400000OiKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYH00T`0W_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF
CiKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JF
mTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@000021iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V00=<00GV0^H2iP02C00R0^H2iP;V0^H2iP;V0^H2iToV
0^H2iP;V0^H2iP;V0^H2iP9<0702iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V
0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@000024U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf0T`0:II<C?JFmYKfU_JFmYKfU_JFmYKfUTnFmYKf
U_JFmYKfU_JFmYKfU_JF009<06kfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JF
mTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP400000QNH2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H00d`0:NH2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2
iP;V0^H2iP;V0^H2iP;V009<06`2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V
CnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H1000008RFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_I<mYKf0d`0U?JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmTofU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000004WV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V009<00d2iP;V0^H2iP;V0^H2009?02SV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H20T`01nH2iP;V0^H00T`09`;V0^H2iP;V0^H2iP;VCnH2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0P02C00WiP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V009?0402iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@000020U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_H2C00;U_JFmYKfU_JFmYH00d`09YKfU_JFmYKfU_JFCiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`0IiKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00001niP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H20T`04>H2iP;V0^H2iP;V0^H2iP82C00ViP;V0^H2iP;VCnH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C01UiP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00001lU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmP9<01BFmYKfU_JFmYKfU_JFmYKfU_JFmP9<02JFmYKfU_JFCiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<06>FmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00@00002DiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P=<08P2iP;VCnH2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@00001iU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFC9KfUP02C00LmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<02CfUTnFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH2C01PmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JF
mYKfU_JF0@00001@iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C00TC`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20d`080;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`094oV0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP=<02;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20Tl0>NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP01000007FFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTofC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH00T`09?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP=<02>FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C01LmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JF
mYKfU_JFmYH1000009kV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0P9<07oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2
iP;V00400000LYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTofU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP9<02bFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmP9<02:FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf0T`0FIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JF00400000L>H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP82C00`iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H20d`08@;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0P02C01GiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V00400000BiKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C`09mYKfU_JFmYKf009<01JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0T`0=IKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKf
U_JF009<027fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_H00T`089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0Tl0<iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfUP01000006cV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP82C00iiP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2
iP;V0^H2iP;V009<0242iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP800T`0DnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V00400000ZIKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKf
U_JFmYKfU_JFmYH00d`0LiKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYH00@00001YiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V009<0442iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V
0^H2iP;V0^H2iP;V0P02C00OiP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP02C01@0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV
0^H2iP;V0^H2iP;V0^H1000006NFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JF009<04GfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTnF
mYKfU_JFmYKfU_JFmYKfU_H00d`07_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfUP9<04kfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbF
mYKfU_JFmYKfU_JFmYH1000006GV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP02C01:0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C00N0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`0C0;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<
0^H2iP;V0^H2iP;V0^H1000004BFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9?01NFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP02C01D
mYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
CiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0T`0??JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9?02cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mTcfU_JFmYKfU_JFmYKfUP400000H^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
0T`0DNH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP03C00LiP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P9<
04WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V00400000H9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP9<
05JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP=<01_fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H0
0T`0AiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYKfU_JF00400000G^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82C01I
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00d`07>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP82C015iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VCnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V00400000_9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf0d`0H?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I?mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbF
mYKfU_JFmYKfUP400000?^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H20Tl06nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C0060^H2iP;V
0T`0FP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP9<01X2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP9<01X2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?02H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iTcV0^H2iP;V0^H2iP400000FIKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF009<06KfU_JF
mYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
CiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYH2C00JmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYH2C010mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_I<mYKfU_JFmYKfUP400000EnH2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02C01Z0^H2iP;V
0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
CnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP=<01WV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V009<03h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C`;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP9<0^H2iP;V0^H2iP400000EIKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00T`0KoJFmYKfU_JF
mYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
CiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmP02C00IU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP02C00lmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYI<U_JFmYKfU_JF0@000038iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I?
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP82C01EiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9?0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP01000005:FmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI?U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`0MYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_H3C00GmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_H00T`0>IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFCiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfUP0100000?oV0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0Tl2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iToV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Tl0023V0^H2iP;VC>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003o
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000000KV0^H2
iP82o`0FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P?o01D2iP;V0^H2iP;V0^H2iP;V0^H2iP801?l05NH2
iP;V0^H2iP;V0^H2iP;V0^H2iP03o`0GiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00ol05NH2iP;V0^H2
iP;V0^H2iP;V0^H2iP03o`0FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P;o033V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP82o`0FiP;V0^H2iP;V0^H2iP;V0^H2iP;V0P?o
0182iP;V0^H2iP;V0^H2iP;V0^H3o`04iP;V0P;o013V0^H2iP;V0^H2iP;V0^H20ol00`;V0P03o`04
0^H2iP400000oiKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_nFm_ofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_nFmYKfU_JFmYKfU_JFmYKfU_KomYKfUP0089KfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKo
0@00001XiP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP84o`1iiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP03o`0g
iP;V0^H2iP;V0^H2iP;V0^H2o`;V0^KoiP;o0^H2iP;V0^H2iP;V0^H2i_oV0^H2i_oV0^H2iP010000
052FmYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKo
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP;o02nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooKomYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP03o`0EU_JFmYKfU_JFmYKfU_JFmYKfU_JF00?o032FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`1AU_JFmYKfU_JFmYKfU_JFmYKfU_JFm_of
U_nFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_nFm_ofU_JFmYKfU_JFmYKfU_JFoiKfU_JFoiKfU_JF0040
0000onH2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2
i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2o`;o0^H2iP;V0^H2
iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2i_oV0^H2
iP;V0^H2iP;V0^H2iP;o0^H2iP008>H2iP;VonH2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^Ko0@000006
U_JFmYKf0_l05YKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`0GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
0_l05_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH3o`0GU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00_l05_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH4o`0EmYKfU_JFmYKfU_JFmYKfU_JFmYKf00?o01GfU_JFmYKfU_JF
mYKfU_JFmYKfU_H01?l05YKfU_JFmYKfU_JFmYKfU_JFmYKfU_H2o`0GU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00_l04_JFmYKfU_JFmYKfU_JFmYKfUP;o00GfU_JFmP02o`0@U_JFmYKfU_JFmYKfU_JFmP;o
00BFmYKf0_l01IKfU_JF00400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@000028iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P;o013V0^H2iP;V0^H2iP;V0^H20_l0PnH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0040
0000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000021
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00Co00P2iP;o0^H2iP?o00?V0^H01?l0R0;V0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfooKomYKfooJFmYKfooJFmYKfooJFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;o0^H2iP;o0^H2iP;o0^H2iP;VonH2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKo
U_JFm_ofU_JFm_ofU_JFmYKfooJFmYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^Koi_oV0^H2
o`;V0^H2o`;V0^KoiP;o0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000PIKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP04o`03mYKf00;o
00>FmYH00_l01OJFmYKf00;o00BFmYKf0_l0PiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000\
\>"],
  ImageRangeCache->{{{0, 287}, {148.562, 0}} -> {-0.295592, -1.00003, 
  0.0403874, 0.0403874}},
  CellTags->"Kernel"],

Cell[BoxData[
    \({2, 6, 10}\)], "Output",
  CellLabel->"Out[61]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "Two observations should be made from the following output: (1) elements \
not in the codomain are ignored (but a warning message is given); (2) {0, 2} \
is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  " and the set of inverse images for it is also a subgroup (in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  ", in this case)."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \({SubgroupQ[inv\  = InverseImage[ZMap[12, \ 4], \ {0, 2, \ 5}], Z[12]], 
      \ inv}\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \(MemberQ::"elmnt" \( : \ \) 
      "\!\(5\) is not an element of \!\(\"Z[4]\"\)."\)], "Message",
  CellTags->"Kernel"],

Cell[BoxData[
    \({True, {0, 4, 8, 2, 6, 10}}\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["InverseImages", "MR"],
  " makes it clear which elements from the domain are assigned to ",
  "which",
  " elements of the codomain."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseImages[h\  = \ FormMorphoid[Mod[#^2, 5]&, \ Z[7], \ Z[7]], \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->"Kernel"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95238 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.981 .922 .845 r
MFill
% Scaling calculations
0.0238095 0.15873 0.15873 0.15873 [
[ 0 0 0 0 ]
[ 1 .95238 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95238 L
0 .95238 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
[(Z[7])] .5 .87302 0 0 Mshowa
[(0)] .02381 .79365 0 0 Mshowa
[(1)] .18254 .79365 0 0 Mshowa
[(2)] .34127 .79365 0 0 Mshowa
[(3)] .5 .79365 0 0 Mshowa
[(4)] .65873 .79365 0 0 Mshowa
[(5)] .81746 .79365 0 0 Mshowa
[(6)] .97619 .79365 0 0 Mshowa
[(Z[7])] .5 .07937 0 0 Mshowa
[(0)] .02381 .15873 0 0 Mshowa
[(1)] .18254 .15873 0 0 Mshowa
[(2)] .34127 .15873 0 0 Mshowa
[(3)] .5 .15873 0 0 Mshowa
[(4)] .65873 .15873 0 0 Mshowa
[(5)] .81746 .15873 0 0 Mshowa
[(6)] .97619 .15873 0 0 Mshowa
0 1 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .74603 m
.02381 .20635 L
s
% Start of user PostScript
0 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.18254 .74603 m
.18254 .20635 L
s
% Start of user PostScript
1. 3.7 1. 0.3 MAarrowhead1
% End of user PostScript
1 0 0 r
.34127 .74603 m
.65873 .20635 L
s
% Start of user PostScript
2. 3.7 4. 0.3 MAarrowhead1
% End of user PostScript
.5 .74603 m
.65873 .20635 L
s
% Start of user PostScript
3. 3.7 4. 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.65873 .74603 m
.18254 .20635 L
s
% Start of user PostScript
4. 3.7 1. 0.3 MAarrowhead1
% End of user PostScript
0 1 0 r
.81746 .74603 m
.02381 .20635 L
s
% Start of user PostScript
5. 3.7 0 0.3 MAarrowhead1
% End of user PostScript
0 0 1 r
.97619 .74603 m
.18254 .20635 L
s
% Start of user PostScript
6. 3.7 1. 0.3 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[63]:=",
  ImageSize->{288, 274.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014PP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@00003oiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002;iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP02o`0:0^H2iP;V
0^H2iP;o08H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JFmYKf
ooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@000024iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H21?l0UnH2i_oV0^H2i_oV0^H2iP;o0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFoiKfU_nFmYKfU_nFmYKfU_KomYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;VonH2iP;V0_l2iP;V0_l2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFmYKoU_JFmYKfooJFmYKfooJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2o`;o0^H2i_oV0^H2iP;VonH2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
08BFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H4o`03U_JF00;o00?fU_H01?l00iKfUP02o`26mYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH10000
0?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000005U_JFmYH0
0_l0:oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00ol0:_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUPCo02[fU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH3o`0/U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H3o`0YmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00ol0;?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0_l01_JFmYKfUP400000onH2
iP;o0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;o0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00002kU_JFm_of
U_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP04o`1PmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFoiKfU_JF0@00002>iP;V0_l2i_oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P;o05SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKo
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol0:`;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800ol01P;V0^H2iP400000oiKfU_KomYKoU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_KomYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000005iP;V0^H00_l0:`;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800_l0;>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20_l0:nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00ol0;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0_l0:^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PCo02_V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00?o00GV0^H2iP0100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1000000KV0^H2iP82d00/iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP82C03YiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H00@000006U_JFmYKf1M00:OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf00E<08?fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmP027`1QU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP01000000KV0^H2iP87d00W0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200M<
0802iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP<O067V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001IKf
U_JF00[@02CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH:C01mmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H011l0HIKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000005iP;V0^H00m000nK@d007d00Q
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00e<07WV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00DO067V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001IKfU_JF00?@00>Fm]002M007iKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH03d`0MYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H67`1QU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP01000000GV0^H2iP03d003iP;V00[@01h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H3C003
iTa<00Y<07@2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iPLO067V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V004000001IKfU_JF00C@
00?fU]002M007OJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf00A<00>FC4`02T`0LoJFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H021l0HIKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@000004iP;V0PG@00<2iP802=007^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PE<00<2C4`024`0LnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H021l0HP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0@000004U_JFmPG@00CfU_JF1]007oK@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_H01D`00oI<C007C01cmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmP097`1RmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH10000
00CV0^H21]001>H2iP85d00N0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V1T`00`;VC007C01b
0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V2Ql0HP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@000004U_JFmPK@00FFmYKfUP03d004
U_JFmP;@01VFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00I<00?fUT`01T`019KfU_H2C01/U_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf2al0H_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@000004iP;V0PK@02OV0^H2iP;@0^H2iP;V0]02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H01T`00`;V0P05C01e0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H200TO0682iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP4000000iKfUP07d00?U_JFmYKfU_JFmYKfU_JF00;@01KfU_JFmYKfU_JFmYKfU_JF
mYKfU_JF1d`00iKfC002C00:mYI<U_JFmYKfUP9<06cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH87`1RmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYH1000000?V0^H02=009@;V0^H2iP;V0^H2iP;V0^K@iP;V0^H2iP;V0^H2iP;V0^H2iP8024`0OnH2
iTcV0^H2C0;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V7nH01Ql0HP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@000003U_JF00S@
017fU_JFmYKfU_JFmYKfU_JFmP02d00BU_JFmYKfU_JFmYKfU_JFmYKf24`04YKfU_JFmYKfUTbFmYKf
U_JFmP9<06bFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_H27`1U
UQlOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2d0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0Ql2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d081000001nFmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFC9KfU_JF
mYKfUP9<0=3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_HOmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0Ql2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81000002:FmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
0T`0cIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmQofU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP81000002FFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfUP9<
0<[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP81000002RFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0]00;9KfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf0T`0aiKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2d0;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP81000002^FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF00;@02cfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfUP9<0<CfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;Vd>H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H27`;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
d?JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUQnFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000;nH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@
02`2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP9<0<02iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^HOiP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFd9Kf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
7oJFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP40
0000<^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20]00;4`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H20T`0_NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HO
iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP010000
0?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKf
U_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000=NH2
iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<00;@02`2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP9<0;X2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V
0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFd9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfUQnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000>>H2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H20]00;>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H20T`0]nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iQoV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_K@mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfd?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfUQnFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000>nH2iP;V0]02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V00;@02`2iP;V0^H2iP;V
0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0;@2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0Ql2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFd9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0
022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000?^H2iP;V0]02iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H20]00;>H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0/NH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000@NH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V00;@02`2iP;V0^H2iP;V0^H2iP;V
0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0:h2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000A>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H20]00;>H2iP;V0^H2iP;V0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0ZnH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmQofU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^HOiP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@000018U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0T`0YiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYHOU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00400000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2
iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20@00001;U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP9<0:CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnF
mYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP400000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2
iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00001>U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0T`0XIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKf
U_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0040
0000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0Ql2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00001A
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP9<09kfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_HO
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000onH2
iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00001DU_JFmYKf
d?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0T`0ViKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JF7iKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00001GU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP9<09SfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000onH2iP;V0]02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00001JU_JFmYKfd?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0T`0UIKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00400000onH2iP;V0]02iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2
iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00001MU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF00;@02cfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<
09;fU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP400000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;Vd>H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfd?JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JF7iKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H10000067V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00;@02`2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<08h2iP;V
0^H27`;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0@00003oU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFd9KfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_HOmYKf
U_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfd?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_H1000006CV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0]00;>H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0RnH2iQoV0^H2
iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00@00003oU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
d?JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfUQnFmYKfU_JFmYKf
U_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H1000006OV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@
02`2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<08P2iP;V0^H2iP;V
0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0@00003oU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFd9Kf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7dbFmYKfU_JFmYKfU_JFmYKf
UQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_H1000006[V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20]00;>H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH20T`0QNH2iP;V0^H2iP;V0^H2
iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0
0@00003oU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmTcfU_JFmYKfU_JFmYKfUQnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000
06gV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@02`2iTcV
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP9<0882iP;V0^H2iP;V0Ql2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00003o
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFd9KfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfUTbFmYKfU_JFmYKf7oJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JF000PU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H10000073V0^H2
iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20]00;>I<iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H20T`0OnH2iP;V0^H27`;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003oU_JFmYKf
d?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmTcfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000007?V0^H2iP;@0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@02a<iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP9<07`2iP;V7nH2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00003oU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFd4cfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfUTbFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF000PU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000007KV0^H2iP;@0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20]00;>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H20T`0NNHOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H00@00003oU_JFmYKfd?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2
iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H27dcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000NYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<0]00;9KfU_JFmYKfU_JFmYKfU_JFmQof
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmQof0T`0MIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2d0;V0^H2iP;V0^H2iP;V0^H27`;V0^H2
iP;V0^H2iP;V0^H2iP;V0^HOiP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000OIKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbF00;@02cfU_JFmYKfU_JFmYKfUQnFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUQnFmYKfUP9<07;fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH100000?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;Vd>H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^HOiP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000P9KfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9Kf0]00;9KfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF7iKfU_JFmYKf0T`0KiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0100000?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2d0;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0Ql2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P400000PiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JF00;@02cfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKf7oJFmYKfU_JFmYKfUP9<06cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYH100000?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;Vd>H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000QYKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf0]00;9Kf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKf
U_JFmYKfU_JFmYKf0T`0JIKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0100000?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2d1oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P40
0000RIKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_HO00;@02cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JF
mYKfU_JFmYKfUP9<06KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH10000
0?oV0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H27`;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000S9Kf
U_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmTcfUQnFmYKf0]00;9KfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0T`0HiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0100000?oV0^H2
iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;VC>HOiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000SiKfU_JFm]3f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfUP9<063fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH100000?oV0^H2iP;@0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0Qm<iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H0023V0^H2iP;@0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFm]3fU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHO
U_I<mYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002CiP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0T`2
iP;V0^H2iP;V00;@02`2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<
05`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFm]3fU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFC9Kf
U_JFmYKfU_JFd9KfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089Kf
U_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002FiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2C0;V0^H2
iP;V0^H20]00;>H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0FNH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYI<U_JFmYKf
U_JFmYKfd?JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFm]3f
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002IiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V00;@02`2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<05H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP400000oiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFd9KfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFm]3fU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0@00002LiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
0]00;>HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0DnH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00400000oiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKf
d1nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFm]3fU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00002OiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP8O00;@
02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0502iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP400000oiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf7oJFd9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf0@00002RiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP8O0^H20]00;>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0CNH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00400000oiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYHOU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00002UiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iQoV0^H2iP;V00;@02`2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<04X2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP40
0000oiKfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYHOU_JFmYKfU_JFd9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00002X
iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iQoV0^H2iP;V0^H20]00;>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`0AnH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00400000oiKf
U_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmQofU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUP0089KfU_JFm]3fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2
d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H27`;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000:bFmYKfU_K@mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_HOmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`0@iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2d0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^HOiP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000:nFmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYI<UQnFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<043fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`OiP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000;:FmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf7dbFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`0?IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0Ql2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2
d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000;FFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf7oJFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<03[fU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0Ql2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000;RFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHO
U_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf0T`0=iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH00@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2
iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8100000;^FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP9<03CfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JF0@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^I<
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8100000;jFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_I<mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0T`0<IKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH00@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iTcV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8100000<6FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
C?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfUP9<02kfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
0@00003oiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HO
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;VC>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iTcV0^H2iP;V0^H2iP;V000PiP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmTcfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000aNH2
iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V00;@02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP9<02X2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKf
U_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UTbFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000b>H2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20]00;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0T`09nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_K@mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000bnH2iP;V0]02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00;@02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<
02@2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYI<U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYH0
022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000c^H2iP;V0]02iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H20]00;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`08NH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmT`0022FmYKf
U_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000dNH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V00;@02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<01h2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFd9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000e>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0]00;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`06nH2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
d?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000enH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iTcV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00;@
02`2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<01P2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFd9Kf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmP400000f^H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
7`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;VC>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20]00;>H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20T`05NH2iP;V0^H2iP;V0^H2
iP;V0^H2iP0100000?nFmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfC?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF7iKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_I<mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_K@mYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^I<iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@00003NU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfUTbFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`04IKfU_JFmYKfU_JFmYKfU_JF0040
0000onH2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2C0;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003Q
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFC9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<00kfU_JFmYKfU_JFmYKfUP400000onH2
iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8O0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^HOiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003TU_JFmYKf
d?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmQofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYI<
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0]00;9KfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0T`02iKfU_JFmYKfU_JF00400000onH2iP;V0]02
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iQoV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0Ql2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0T`2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2d0;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003WU_JFmYKfd?JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_HOmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf7oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUTbFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF00;@02cfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP9<00SfU_JFmYKfUP400000onH2iP;V0]02iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP9<0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H27`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V7nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2C0;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;Vd>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0]02iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfd?JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmTcfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfUQnFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYHOU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFC9KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfd?JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@000005U_JFmYH0
0_l0:oJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00ol0:_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUPCo02[fU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYH3o`0/U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H3o`0YmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H00ol0;?JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF0_l01_JFmYKfUP400000onH2
iP;o0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2i_oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2i_oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;o0^KoiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00002kU_JFm_of
U_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP04o`1PmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfooJFoiKfU_JF0@00002>iP;V0_l2i_oV0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonH2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0P;o05SV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;VonKo
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20ol0:`;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800ol01P;V0^H2iP400000oiKfU_KomYKoU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKfooJFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKoU_nFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_KomYKoU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@000005iP;V0^H00_l0:`;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP800_l0;>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20_l0:nH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H00ol0;>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0_l0:^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0PCo02_V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V00?o00GV0^H2iP0100000?nFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000P
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000008_V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V00;o00X2iP;V0^H2iP;V0_l0QP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V
0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0@00003oU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_nFmYKfU_JFmYKfU_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H1000008CV0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP84o`2G
iP;VonH2iP;VonH2iP;V0_l2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP0100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFoiKoU_JFoiKf
U_JFoiKfU_JFm_ofU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^KoiP;V0^KoiP;V0^H2
o`;V0^H2o`;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_KomYKfU_nFmYKfU_KomYKf
U_KomYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;o0_l2iP;VonH2iP;V0^KoiP;V0_l2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000Q9KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmPCo00>FmYH00_l00oJFmP04o`03U_JF00;o
08KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF
mYKfU_JFmYKfU_JFmYKfUP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP810000
0?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JF000PU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
UP0089KfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000P
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H20@00003oU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JF000PU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_H100000?oV0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H0023V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0P400000oiKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfUP0089KfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKf0@00003oiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V000PiP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP8100000?nFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYH0022FmYKfU_JFmYKfU_JFmYKfU_JFmYKfU_JFmYKf
U_JFmP400000onH2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP008>H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2iP;V0^H2
0@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.25, 0}} -> {-0.150989, -1.00003, 
  0.0219581, 0.0219581}},
  CellTags->"Kernel"],

Cell[BoxData[
    \({{0, 5}, {1, 4, 6}, {}, {}, {2, 3}, {}, {}}\)], "Output",
  CellLabel->"Out[63]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["WithImages", "MR"],
  " option is intended to make it explicit which codomain elements are \
associated with ",
  "which",
  " domain elements."
}], "MathCaption",
  CellTags->"Kernel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseImages[h\ , \ WithImages\  \[Rule] \ True]\)], "Input",
  CellLabel->"In[64]:=",
  CellTags->"Kernel"],

Cell[BoxData[
    \({{{0, 5}, 0}, {{1, 4, 6}, 1}, {{}, 2}, {{}, 3}, {{2, 3}, 4}, {{}, 
        5}, {{}, 6}}\)], "Output",
  CellLabel->"Out[64]=",
  CellTags->"Kernel"]
}, Open  ]],

Cell["4.6 Automorphisms", "Subsection",
  CellTags->{"Automorphisms", "i:22"}],

Cell["\<\
Whereas a morphism describes a function between two groups, an \
automorphism describes an isomorphism between a group and itself.\
\>", "Text",\

  CellTags->"Automorphisms"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Automorphism",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{"x", " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", "y"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(for\ a\ cyclic\ group\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["G",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(form\ the\ automorphism\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["determined",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  S