(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     51207,       1777]*)
(*NotebookOutlinePosition[     54420,       1882]*)
(*  CellTagsIndexPosition[     54120,       1868]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 2",
    FontSize->18],
  "\nDetermining the Symmetry Group of a Given Figure"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.2"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.3.2"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user\[CloseCurlyQuote]s guide with printed and \
electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.4.2"],

Cell["\<\
Though not absolutely necessary, it would be useful if you \
completed Group Lab 1 before attempting this lab.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2 Goals", "Section",
  CellMargins->{{Inherited, 37}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.5.2"],

Cell[TextData[
"In this lab, we continue to look at symmetries. We resume where Group Lab 1 \
left off. The goal is to find the complete list of symmetries (via \
permutations) for a variety of (more or less) random figures. When \
\[OpenCurlyDoubleQuote]complete,\[CloseCurlyDoubleQuote] this list should be \
the \[OpenCurlyDoubleQuote]symmetry group\[CloseCurlyDoubleQuote] of the \
object."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3 Symmetries and how to find them", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.2"],

Cell[TextData[{
  StyleBox["To start this lab, the following package needs to be read into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["Consider the following array of figures.", "Text",
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119048 0.47619 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.0119048 0.477324 0.238662 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.25 0.190476 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
.74 .99 .79 r
.02 w
.88095 .44048 m
.88095 .05952 L
.11905 .44048 L
.11905 .05952 L
s
P
p
[(1)] .97619 .4881 0 0 Mshowa
[(2)] .97619 .0119 0 0 Mshowa
[(3)] .02381 .0119 0 0 Mshowa
[(4)] .02381 .4881 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.88095 .44048 Mdot
P
p
0 1 0 r
.035 w
.88095 .05952 Mdot
P
p
0 0 1 r
.035 w
.11905 .05952 Mdot
P
p
1 1 0 r
.035 w
.11905 .44048 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119048 0.97619 0.238662 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.400557 0.459434 0.400557 [
[ 0 0 0 0 ]
[ 1 .98355 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .98355 L
0 .98355 L
closepath
clip
newpath
p
p
p
.74 .99 .79 r
.88095 .58321 m
.73544 .13538 L
.26456 .13538 L
.11905 .58321 L
.5 .85999 L
F
P
p
0 0 0 r
.004 w
.88095 .58321 m
.73544 .13538 L
.26456 .13538 L
.11905 .58321 L
.5 .85999 L
.88095 .58321 L
s
P
P
p
[(1)] .97619 .61416 0 0 Mshowa
[(2)] .7943 .05436 0 0 Mshowa
[(3)] .2057 .05436 0 0 Mshowa
[(4)] .02381 .61416 0 0 Mshowa
[(5)] .5 .96013 0 0 Mshowa
P
p
.004 w
.73544 .13538 m
.69906 .02342 L
s
.26456 .13538 m
.14684 .13538 L
s
.11905 .58321 m
.08267 .69517 L
s
.5 .85999 m
.59524 .92919 L
s
.88095 .58321 m
.97619 .51402 L
s
P
p
p
1 0 0 r
.035 w
.88095 .58321 Mdot
P
p
0 1 0 r
.035 w
.73544 .13538 Mdot
P
p
0 0 1 r
.035 w
.26456 .13538 Mdot
P
p
1 1 0 r
.035 w
.11905 .58321 Mdot
P
p
.628 .126 .941 r
.035 w
.5 .85999 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.261338 0.477324 0.488095 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.25 0.190476 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
.74 .99 .79 r
.88095 .44048 m
.88095 .05952 L
.11905 .05952 L
.11905 .44048 L
F
P
p
[(1)] .97619 .4881 0 0 Mshowa
[(2)] .97619 .0119 0 0 Mshowa
[(3)] .02381 .0119 0 0 Mshowa
[(4)] .02381 .4881 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.88095 .44048 Mdot
P
p
0 1 0 r
.035 w
.88095 .05952 Mdot
P
p
0 0 1 r
.035 w
.11905 .05952 Mdot
P
p
1 1 0 r
.035 w
.11905 .44048 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.261338 0.97619 0.488095 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.386829 0.477823 0.386829 [
[ 0 0 0 0 ]
[ 1 .98481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .98481 L
0 .98481 L
closepath
clip
newpath
p
p
p
.74 .99 .79 r
.74865 .77415 m
.88095 .545 L
.835 .28441 L
.6323 .11432 L
.3677 .11432 L
.165 .28441 L
.11905 .545 L
.25135 .77415 L
.5 .86465 L
F
P
p
0 0 0 r
.004 w
.74865 .77415 m
.88095 .545 L
.835 .28441 L
.6323 .11432 L
.3677 .11432 L
.165 .28441 L
.11905 .545 L
.25135 .77415 L
.5 .86465 L
.74865 .77415 L
s
P
P
p
[(1)] .81081 .84823 0 0 Mshowa
[(2)] .97619 .56179 0 0 Mshowa
[(3)] .91875 .23606 0 0 Mshowa
[(4)] .66538 .02345 0 0 Mshowa
[(5)] .33462 .02345 0 0 Mshowa
[(6)] .08125 .23606 0 0 Mshowa
[(7)] .02381 .56179 0 0 Mshowa
[(8)] .18919 .84823 0 0 Mshowa
[(9)] .5 .96136 0 0 Mshowa
P
p
p
1 0 0 r
.035 w
.74865 .77415 Mdot
P
p
0 1 0 r
.035 w
.88095 .545 Mdot
P
p
0 0 1 r
.035 w
.835 .28441 Mdot
P
p
1 1 0 r
.035 w
.6323 .11432 Mdot
P
p
.628 .126 .941 r
.035 w
.3677 .11432 Mdot
P
p
1 .5 0 r
.035 w
.165 .28441 Mdot
P
p
.251 .878 .816 r
.035 w
.11905 .545 Mdot
P
p
.69 .188 .377 r
.035 w
.25135 .77415 Mdot
P
p
0 0 .502 r
.035 w
.5 .86465 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{494, 244},
  ImageMargins->{{35, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007^0000m1000`40O003h00Oogookgoo003oOoo_
Ool00?moonmoo`00ogookgoo003oOoo_Ool00?moonmoo`00ogookgoo000BOol3003?Ool4003oOol7
Ool001Eoo`03001oogoo0<eoo`03001oogoo0?moo`Moo`005Goo00<007ooOol0cWoo00<007ooOol0
W7oo00<007ooOol0IWoo000COol2003BOol00`00Oomoo`1ROol3000fOol00`00Oomoo`06Ool4001L
Ool001Eoo`03001oogoo0<aoo`04001oogoo001WOol00`00Oomoo`0dOol00`00Oomoo`06Ool00`00
Oomoo`1LOol0019oo`<00=1oo`8006Qoo`03001oogoo03Aoo`03001oogoo00Moo`03001oogoo05]o
o`00ogooCWoo0P00=goo00<007ooOol027oo00<007ooOol0FWoo003oOom@Ool00`00Oomoo`0eOol0
0`00Oomoo`04Ool01000Oomoo`00G7oo003oOom=Ool3000hOol00`00Oomoo`05Ool2001MOol00?mo
ohUoo`03001oogoo06=oo`009goo0`0OYGoo0`?P]Woo00<007ooOol0Hgoo000VOol501nSOol50n2f
Ool00`00Oomoo`1ROol002Eoo`L07j1oo`03GoT3h0?P00D3h;Eoo`03001oogoo069oo`009Goo1`0O
WWoo0eoi1`?P]Goo00<007ooOol0HWoo000UOol701nLOol5GoT70n1dOol;000301lb00030n1SOol0
02Ioo`D07i]oo`QOn@D3h81oo`<07c9On@<3h6=oo`009goo0`0O00=OnGooOol0Ugoo2eoi0`?P00=O
nGooOol0OWoo0`0O<Uoi0`?PHgoo000WOol4GoVGOol;GoT2Ool4GoV1Ool00`00GoUOn@0dGoT00`00
Oomoo`1POol002Moo`AOnIEoo`]On@Aoo`AOnH5oo`03001OnEoi03AOn@03001oogoo061oo`009goo
15oiTgoo2eoi1Woo15oiPGoo00<005oiGoT0=5oi00<007ooOol0H7oo000WOol4GoVAOol;GoT8Ool4
GoV0Ool00`00GoUOn@0fGoT00`00Oomoo`1OOol002Moo`AOnHmoo`]On@Yoo`AOnH1oo`03001OnEoi
03IOn@03001oogoo05moo`009goo15oiSGoo2eoi37oo15oiP7oo00<005oiGoT0=Uoi00<007ooOol0
Ggoo000WOol4GoV;Ool;GoT>Ool4GoUoOol00`00GoUOn@0hGoT00`00Oomoo`1NOol002Moo`AOnHUo
o`]OnA1oo`AOnGmoo`03001OnEoi03QOn@03001oogoo05ioo`009goo15oiQgoo2eoi4Woo15oiOgoo
00<005oiGoT0>5oi00<007ooOol0GWoo000WOol4GoV5Ool;GoTDOol4GoUnOol00`00GoUOn@0jGoT0
0`00Oomoo`1MOol002Moo`AOnH=oo`]OnAIoo`AOnGioo`03001OnEoi03YOn@03001oogoo05eoo`00
9goo15oiPGoo2eoi67oo15oiOWoo00<005oiGoT0>Uoi00<007ooOol0GGoo000WOol4GoUoOol;GoTJ
Ool4GoUmOol00`00GoUOn@0lGoT00`00Oomoo`1LOol002Moo`AOnGeoo`]OnAaoo`AOnGeoo`03001O
nEoi03aOn@03001oogoo05aoo`009goo15oiNgoo2eoi7Woo15oiOGoo00<005oiGoT0?5oi00<007oo
Ool0G7oo000WOol4GoUiOol;GoTPOol4GoUmOol00`00GoUOn@0lGoT00`00Oomoo`1LOol002Moo`AO
nGMoo`]OnB9oo`AOnGaoo`03001OnEoi03iOn@03001oogoo05]oo`009goo15oiMGoo2eoi97oo15oi
O7oo00<005oiGoT0?Uoi00<007ooOol0Fgoo000WOol4GoUcOol;GoTVOol4GoUlOol00`00GoUOn@0n
GoT00`00Oomoo`1KOol002Moo`AOnG5oo`]OnBQoo`AOnG]oo`03001OnEoi041On@03001oogoo05Yo
o`009goo15oiKgoo2eoi:Woo15oiNgoo00<005oiGoT0@5oi00<007ooOol0FWoo000WOol4GoU]Ool;
GoT/Ool4GoUkOol00`00GoUOn@10GoT00`00Oomoo`1JOol002Moo`AOnF]oo`]OnBioo`AOnGYoo`03
001OnEoi049On@03001oogoo05Uoo`009goo15oiJGoo2eoi<7oo15oiNWoo00<005oiGoT0@Uoi00<0
07ooOol0FGoo000WOol4GoUWOol;GoTbOol4GoUjOol00`00GoUOn@12GoT00`00Oomoo`1IOol002Mo
o`AOnFEoo`]OnCAoo`AOnGUoo`03001OnEoi04AOn@03001oogoo05Qoo`009goo15oiHgoo2eoi=Woo
15oiNGoo00<005oiGoT0A5oi00<007ooOol0F7oo000WOol4GoUQOol;GoThOol4GoUiOol00`00GoUO
n@14GoT00`00Oomoo`1HOol002Moo`AOnEmoo`]OnCYoo`AOnGQoo`03001OnEoi04IOn@03001oogoo
05Moo`009goo15oiGGoo2eoi?7oo15oiN7oo00<005oiGoT0AUoi00<007ooOol0Egoo000WOol4GoUK
Ool;GoTnOol4GoUhOol00`00GoUOn@16GoT00`00Oomoo`1GOol002Moo`AOnEUoo`]OnD1oo`AOnGMo
o`03001OnEoi04QOn@03001oogoo05Ioo`009goo15oiEgoo2eoi@Woo15oiMgoo00<005oiGoT0B5oi
00<007ooOol0EWoo000WOol4GoUEOol;GoU4Ool4GoUgOol00`00GoUOn@18GoT00`00Oomoo`1FOol0
02Moo`AOnE=oo`]OnDIoo`AOnGMoo`03001OnEoi04QOn@03001oogoo05Ioo`009goo15oiDGoo2eoi
B7oo15oiMWoo00<005oiGoT0BUoi00<007ooOol0EGoo000WOol4GoU?Ool;GoU:Ool4GoUfOol00`00
GoUOn@1:GoT00`00Oomoo`1EOol002Moo`AOnDeoo`]OnDaoo`AOnGIoo`03001OnEoi04YOn@03001o
ogoo05Eoo`009goo15oiBgoo2eoiCWoo15oiMGoo00<005oiGoT0C5oi00<007ooOol0E7oo000WOol4
GoU9Ool;GoU@Ool4GoUeOol00`00GoUOn@1<GoT00`00Oomoo`1DOol002Moo`AOnDMoo`]OnE9oo`AO
nGEoo`03001OnEoi04aOn@03001oogoo00Yoo`8004Qoo`009goo15oiAGoo2eoiE7oo15oiM7oo00<0
05oiGoT0CUoi00<007ooOol027oo00<007ooOol0B7oo000WOol4GoU3Ool;GoUFOol4GoUdOol00`00
GoUOn@1>GoT00`00Oomoo`07Ool00`00Oomoo`19Ool002Moo`AOnD5oo`]OnEQoo`AOnGAoo`03001O
nEoi04iOn@03001oogoo00Eoo`8004aoo`009goo15oi?goo2eoiFWoo15oiLgoo00<005oiGoT0D5oi
00<007ooOol00goo00<007ooOol0C7oo000WOol4GoTmOol;GoULOol4GoUcOol00`00GoUOn@1@GoT0
1000Oomoogoo0P00Cgoo000WOol4GoTkOol;GoUNOol4GoUcOol00`00GoUOn@1@GoT01000Oomoo`00
DGoo000WOol4GoTiOol;GoUPOol4GoU`Ool3On1BGoT3O0000`00Oomoo`1@Ool002Moo`AOnCMoo`]O
nF9oo`AOnG1oo`=oh003001OnEoi04mOn@=l05=oo`009goo15oi=Goo2eoiI7oo15oiIWoo0`001goo
0goP00=oo`00GoT0Ceoi0g`027oo0`00B7oo000WOol4GoTcOol;GoUVOol4GoUWOol00`00Oomoo`07
Ool01@00Oomoogoo0000CUoi00<007ooOol02Woo00<007ooOol0Agoo000WOol4GoTaOol;GoUXOol4
GoUUOol40008Ool00`00Oomoo`02Ool2001:GoT2000=Ool00`00Oomoo`17Ool002Moo`AOnBmoo`]O
nFYoo`AOnFEoo`03001oo`0000Uoo`03001oogoo00Aoo`03001OnEoi04IOn@03001oogoo00eoo`03
001oogoo04Moo`009goo15oi;Goo2eoiK7oo15oiIGoo00<007oo000027oo00<007ooOol01Woo00<0
05oiGoT0@eoi0P0047oo00<007ooOol0Agoo000WOol4GoT[Ool;GoU^Ool4GoUVOol20008Ool00`00
Oomoo`07Ool20012GoT00`00Oomoo`0?Ool20019Ool002Moo`AOnBUoo`]OnG1oo`AOnFmoo`03001o
ogoo00Yoo`03001OnEoi03iOn@03001oogoo05]oo`009goo15oi9goo2eoiLWoo15oiKgoo00<007oo
Ool02goo0P00?5oi0P00GWoo000WOol4GoTUOol;GoUdOol4GoU^Ool00`00Oomoo`0>Ool00`00GoUO
n@0hGoT00`00Oomoo`1NOol002Moo`AOnB=oo`]OnGIoo`AOnFioo`03001oogoo00moo`03001OnEoi
03EOn@80065oo`009goo15oi8Goo2eoiN7oo15oiKWoo00<007ooOol047oo0P00=5oi00<007ooOol0
HGoo000WOol4GoTOOol;GoUjOol4GoU]Ool00`00Oomoo`0COol00`00GoUOn@0`GoT00`00Oomoo`1R
Ool002Moo`AOnAeoo`]OnGaoo`AOnHAoo`03001OnEoi02eOn@8006Eoo`009goo15oi6goo2eoiOWoo
15oiQGoo0P00;5oi00<007ooOol0IGoo000WOol4GoTIOol;GoV0Ool4GoV7Ool00`00GoUOn@0XGoT0
0`00Oomoo`1VOol002Moo`AOnAMoo`]OnH9oo`AOnHQoo`03001OnEoi02EOn@8006Uoo`009goo15oi
5Goo2eoiQ7oo15oiRGoo0P0095oi00<007ooOol0JGoo000WOol4GoTCOol;GoV6Ool4GoV;Ool00`00
GoUOn@0OGoT2001/Ool002Moo`AOnA5oo`]OnHQoo`AOnHaoo`03001OnEoi01eOn@03001oogoo06ao
o`009goo15oi3goo2eoiRWoo15oiSGoo0P0075oi00<007ooOol0KGoo000WOol4GoT=Ool;GoV<Ool4
GoV?Ool00`00GoUOn@0GGoT2001`Ool002Moo`AOn@]oo`]OnHioo`AOnI1oo`03001OnEoi01EOn@03
001oogoo071oo`009goo15oi2Goo2eoiT7oo15oiTGoo0P004eoi0P00Lgoo000WOol4GoT7Ool;GoVB
Ool4GoVCOol00`00GoUOn@0?GoT00`00Oomoo`1cOol002Moo`AOn@Eoo`]OnIAoo`AOnIAoo`8000iO
n@03001oogoo07Aoo`009goo15oi0goo2eoiUWoo15oiUWoo00<005oiGoT02Eoi0P00Mgoo000WOol4
GoT00gooGoUOn@09GoVHOol4GoVGOol00`00GoUOn@07GoT00`00Oomoo`1gOol002Moo`iOnIYoo`AO
nIQoo`8000EOn@8007Yoo`009goo0goP2EoiW7oo0g`000=OnGooOol0V7oo00D005oiGoUOn@0007ao
o`009Woo1GoP1UoiWGoo1G`0Vgoo0e2NOGoo000UOol7On03GoVNOol7O02JOol3D9imOol002Eoo`Mo
h003GoUoogoo09ioo`Ml09Yoo`=@WP03001oogoo07Yoo`009Goo1goPXGoo1g`0WWoo0P00NWoo000V
Ool5On2SOol5O02QOol00`00Oomoo`1gOol002Moo`=oh:Eoo`=l0:=oo`8007Moo`00ogooN7oo0P00
MGoo003oOomjOol00`00Oomoo`1bOol00?moog]oo`03001oogoo075oo`00ogookgoo000COol3003>
Ool30026Ool3001nOol001Aoo`03001oogoo0<ioo`03001oogoo08Qoo`03001oogoo07]oo`004Woo
1000cgoo00<007ooOol0R7oo00<007ooOol0Ngoo000BOol00`00Ool0003@Ool00`00Oomoo`25Ool3
001nOol0019oo`03001oo`000=1oo`03001oogoo08Eoo`03001oogoo07ioo`004goo0P00cgoo0P00
Qgoo1000OGoo003oOoo_Ool00?moonmoo`00ogookgoo003oOoo_Ool00?moonmoo`00ogookgoo003o
Ooo_Ool00?moonmoo`00ogookgoo003oOoo_Ool0019oo`<00<moo`@007=oo`<002=oo`<006Yoo`00
5Goo00<007ooOol0cGoo00<007ooOol0MWoo00<007ooOol08Goo00<007ooOol0JGoo000EOol00`00
Oomoo`3>Ool00`00Oomoo`1eOol00`00Oomoo`0OOol4001ZOol001=oo`800=9oo`03001oogoo075o
o`<0029oo`03001oo`0006]oo`005Goo00<007ooOol0c7oo00@007ooOol007=oo`03001oogoo029o
o`03001oo`0006]oo`004Woo0`00d7oo0P00M7oo10008Woo0P00Jgoo003oOoo_Ool00?moonmoo`00
ogookgoo003oOoo_Ool002Moo`<07jEoo`<3h?mooaeoo`009Woo1@0OXgoo1@?Pogoo77oo000UOol7
01nQOol70n2;Ool3D9hK0003On1^Ool002Eoo`L07j5oo`L3h8Yoo`04001@WU2ND9hKGoT3On000`00
Oomoo`1[Ool002Eoo`L07j5On@L3h8Uoo`03001OnE2N009@WQ]On@=oh003GoT007oo06]oo`009Woo
1@0OXeoi1@?PRGoo00<005oiGoT08eoi00<007ooOol0JGoo000WOol301nUGoT30n29Ool00`00GoUO
n@0UGoT00`00Oomoo`1XOol002UoojQOnHUoo`03001OnEoi02MOn@8006Qoo`00:GooZ5oiQgoo0P00
;5oi00<007ooOol0IGoo000YOonXGoV6Ool00`00GoUOn@0]GoT00`00Oomoo`1TOol002UoojQOnHEo
o`03001OnEoi02mOn@03001oogoo06=oo`00:GooZ5oiQ7oo00<005oiGoT0<Eoi00<007ooOol0HWoo
000YOonXGoV3Ool00`00GoUOn@0cGoT2001ROol002UoojQOnH9oo`03001OnEoi03IOn@03001oogoo
05moo`00:GooZ5oiKWoo0P004Goo00<005oiGoT0>5oi00<007ooOol037oo0`00Cgoo000YOonXGoU]
Ool01000Oomoo`003Woo0P00?5oi00<007ooOol03Woo00<007ooOol0C7oo000YOonXGoU]Ool01000
Oomoo`003Goo00<005oiGoT0?Eoi0P003Woo00<007ooOol0C7oo000YOonXGoU]Ool3000=Ool00`00
GoUOn@10GoT00`00Oomoo`09Ool2001?Ool002UoojQOnFeoo`03001oogoo00aoo`03001OnEoi049O
n@03001oogoo00Yoo`03001oogoo04aoo`00:GooZ5oiKWoo0`002Woo00<005oiGoT0A5oi00<007oo
Ool01Woo0`00Cgoo000YOonXGoUjOol00`00GoUOn@16GoT00`00Oomoo`1GOol002UoojQOnGMoo`=m
h4QOn@<07eQoo`00:GooZ5oiMgoo0ggPB5oi0`0OF7oo000YOonXGoUgOol3ON18GoT301mHOol002Uo
ojQOnGUoo`03001OnEoi04QOn@03001oogoo05Ioo`00:GooZ5oiN7oo00<005oiGoT0BUoi00<007oo
Ool0EGoo000YOonXGoUhOol00`00GoUOn@1:GoT00`00Oomoo`1EOol002UoojQOnGQoo`03001OnEoi
04YOn@03001oogoo05Eoo`00:GooZ5oiN7oo00<005oiGoT0BUoi00<007ooOol0EGoo000YOonXGoUh
Ool00`00GoUOn@1:GoT00`00Oomoo`1EOol002UoojQOnGQoo`03001OnEoi04YOn@03001oogoo05Eo
o`00:GooZ5oiMgoo00<005oiGoT0C5oi00<007ooOol0E7oo000YOonXGoUgOol00`00GoUOn@1<GoT0
0`00Oomoo`1DOol002UoojQOnGMoo`03001OnEoi04aOn@03001oogoo05Aoo`00:GooZ5oiMgoo00<0
05oiGoT0C5oi00<007ooOol0E7oo000YOonXGoUgOol00`00GoUOn@1<GoT00`00Oomoo`1DOol002Uo
ojQOnGMoo`03001OnEoi04aOn@03001oogoo05Aoo`00:GooZ5oiMWoo00<005oiGoT0CUoi00<007oo
Ool0Dgoo000YOonXGoUfOol00`00GoUOn@1>GoT00`00Oomoo`1COol002UoojQOnGIoo`03001OnEoi
04iOn@03001oogoo05=oo`00:GooZ5oiMWoo00<005oiGoT0CUoi00<007ooOol0Dgoo000YOonXGoUf
Ool00`00GoUOn@1>GoT00`00Oomoo`1COol002UoojQOnGIoo`03001OnEoi04iOn@03001oogoo05=o
o`00:GooZ5oiMGoo00<005oiGoT0D5oi00<007ooOol0DWoo000YOonXGoUeOol00`00GoUOn@1@GoT0
0`00Oomoo`1BOol002UoojQOnGEoo`03001OnEoi051On@03001oogoo059oo`00:GooZ5oiMGoo00<0
05oiGoT0D5oi00<007ooOol0DWoo000YOonXGoUeOol00`00GoUOn@1@GoT00`00Oomoo`1BOol002Uo
ojQOnGEoo`03001OnEoi051On@03001oogoo059oo`00:GooZ5oiM7oo00<005oiGoT0DUoi00<007oo
Ool0DGoo000YOonXGoUXOol00`00Oomoo`07Ool38iYBGoT30n07Ool40018Ool002UoojQOnFQoo`03
001oogoo00Moo`<SVU9On@<3h0Qoo`03001oogoo04Qoo`00:GooZ5oiJGoo00<007ooOol01Woo0b>J
DUoi0`?P2Goo00<007ooOol0Agoo000YOonXGoUYOol00`00Oomoo`09Ool00`00GoUOn@1@GoT00`00
Oomoo`09Ool00`00Oomoo`16Ool002UoojQOnFYoo`03001oogoo00Qoo`03001OnEoi04mOn@03001o
ogoo00Moo`04001oogoo0018Ool002UoojQOnFMoo`@000]oo`03001OnEoi04iOn@03001oogoo00Qo
o`8004Uoo`00:GooZ5oiMgoo00<005oiGoT0C5oi00<007ooOol0E7oo000YOonXGoUgOol00`00GoUO
n@1<GoT00`00Oomoo`1DOol002UoojQOnGQoo`03001OnEoi04YOn@03001oogoo05Eoo`00:GooZ5oi
N7oo00<005oiGoT0BEoi00<007ooOol0EWoo000YOonXGoUiOol00`00GoUOn@18GoT00`00Oomoo`1F
Ool002UoojQOnGUoo`03001OnEoi04MOn@03001oogoo05Moo`00:GooZ5oiNWoo00<005oiGoT0AUoi
00<007ooOol0Egoo000YOonXGoUjOol00`00GoUOn@15GoT00`00Oomoo`1HOol002UoojQOnG]oo`03
001OnEoi04=On@03001oogoo05Uoo`00:GooZ5oiO7oo00<005oiGoT0@Uoi00<007ooOol0FGoo000Y
OonXGoUlOol00`00GoUOn@11GoT00`00Oomoo`1JOol002UoojQOnGeoo`03001OnEoi041On@03001o
ogoo05Yoo`00:GooZ5oiOGoo00<005oiGoT0?eoi00<007ooOol0Fgoo000YOonXGoUnOol00`00GoUO
n@0mGoT00`00Oomoo`1LOol002UoojQOnGioo`03001OnEoi03eOn@03001oogoo05aoo`00:GooZ5oi
Ogoo00<005oiGoT0>eoi00<007ooOol0GGoo000YOonXGoUoOol00`00GoUOn@0kGoT00`00Oomoo`1M
Ool002UoojQOnH1oo`03001OnEoi03UOn@03001oogoo05ioo`00:GooZ5oiPGoo00<005oiGoT0=eoi
00<007ooOol0Ggoo000YOonXGoV1Ool00`00GoUOn@0gGoT00`00Oomoo`1OOol002UoojQOnH5oo`=H
c3EOn@=l065oo`00:GooZ5oiPGoo0eS<0`00;eoi0`000g`0HGoo000YOonXGoV1Ool3F<`3Ool3000Y
GoT30003Ool3O01QOol002UoojQOnHYoo`<002=On@<006Yoo`00:GooZ5oiSGoo0`007Eoi0`00KGoo
000YOonXGoV@Ool2000IGoT2001`Ool002UoojQOnGYoo`8001Ioo`<001=On@<001Aoo`<005]oo`00
:GooZ5oiNGoo00@007ooOol001Qoo`<000eOn@<001Qoo`03001oogoo05Yoo`009goo0goPYEoi0g`0
N7oo00@007ooOol001]oo`<000MOn@<001]oo`03001oogoo05Yoo`009Woo1GoPXeoi1G`0N7oo0P00
7goo0`0000AOn@00000001ioo`03001oogoo05Yoo`009Goo1goPXEoi1g`0MWoo00@007ooOol0021o
o`<0421oo`03001oogoo05Yoo`009Goo1goPXEoi1g`0Mgoo0P008Goo0`0@7goo0P00G7oo000UOol7
On2QOol7O02JOol3011mOol002Ioo`Eoh:=oo`El0?mooaaoo`009goo0goPYGoo0g`0ogoo7Goo003o
Ooo_Ool00?moonmoo`00ogookgoo003oOoo_Ool001=oo`<00<ioo`<008Ioo`<007ioo`0057oo00<0
07ooOol0cWoo00<007ooOol0R7oo00<007ooOol0Ngoo000BOol4003?Ool00`00Oomoo`26Ool3001m
Ool0019oo`03001oo`000=1oo`03001oogoo08Eoo`04001oogoo001mOol0019oo`03001oo`000=1o
o`03001oogoo08Eoo`04001oogoo001mOol001=oo`800<moo`8008Qoo`8007ioo`00ogookgoo003o
Ooo_Ool00?moonmoo`00ogookgoo003oOoo_Ool00001\
\>"],
  ImageRangeCache->{{{0, 493}, {243, 0}} -> {-0.0651341, -0.0250054, 
  0.00432103, 0.00432103}, {{15.0625, 235.438}, {237.188, 
  127}} -> {-2.98387, -1.45099, 0.0238233, 0.0238233}, {{257.5, 477.875}, {
  237.188, 127}} -> {-8.19376, -1.27653, 0.0222846, 0.0222846}, {{15.0625, 
  235.438}, {115.938, 5.75}} -> {-2.98387, -4.33956, 0.0238233, 0.0238233}, {{
  257.5, 477.875}, {115.938, 5.75}} -> {-8.49541, -4.17102, 0.023105, 
  0.023105}}],

Cell[TextData[{
  StyleBox[
  "When we look for the \[OpenCurlyDoubleQuote]symmetry group\
\[CloseCurlyDoubleQuote] of any one of these objects, we look for a complete \
list of symmetries for the object. (Technically, a symmetry of an object ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" is an isometry \[Pi] that maps ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[
  " onto itself, with distances being preserved. Since an isometry is \
actually a function, the \[OpenCurlyDoubleQuote]natural\
\[CloseCurlyDoubleQuote] way of combining symmetries is to use function \
composition.) ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Symmetries can come in several varieties. They often involve ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["rotations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " about a certain point (the \[OpenCurlyDoubleQuote]center\
\[CloseCurlyDoubleQuote]) through some angle. For example, if we rotate the \
figure at the upper left about the center of the rectangle (where the \
diagonals intersect) through an angle of 180\[Degree], the figure is placed \
back onto itself. Note that the figure does NOT include the colored and \
labeled dots used to mark the vertices; these are only tags to help \
coordinate the movements. With this rotation, observe that vertices 1 and 3 \
are interchanged, as are vertices 2 and 4. We can describe this by",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"{1 \[Rule] 3, 2 \[Rule] 4, 3 \[Rule] 1, 4 \[Rule] 2}",
  FontFamily->"Courier"]], "Text",
  TextAlignment->Center,
  TextJustification->0],

Cell["or, in block permutation notation,", "Text",
  CellMargins->{{Inherited, 34}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[{1 \[Rule] 3, 2 \[Rule] 4, 3 \[Rule] 1, 4 \[Rule] 2}]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["or, as you may recall from the last lab, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{3, \ 4, \ 1, \ 2}\)]],
  ",",
  StyleBox[
  " which constitutes the second coordinates or row of the representations \
above. Each of these is a representation for the permutation of the vertices \
that corresponds to the described rotational symmetry. Thus, we can say that \
the permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{3, \ 4, \ 1, \ 2}\)]],
  StyleBox[
  " represents one of the symmetries of this figure. (What are the others?) ",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Consider the rectangle again. If we imagine a horizontal line parallel to \
the base and through the center and consider it a line of reflection, then we \
have another common type of symmetry: the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["reflection",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". In this case, we could also describe the symmetry by what happens to the \
vertices. We would say that",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"{1 \[Rule] 2, 2 \[Rule] 1, 3 \[Rule] 4, 4 \[Rule] 3}",
  FontFamily->"Courier"]], "Text",
  TextAlignment->Center,
  TextJustification->0],

Cell["or", "Text",
  CellMargins->{{Inherited, 34}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[{1 \[Rule] 2, 2 \[Rule] 1, 3 \[Rule] 4, 4 \[Rule] 3}]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{2, \ 1, \ 4, \ 3}\)]],
  StyleBox[
  " describes the permutation of the vertices that corresponds to this \
reflectional symmetry.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "There are several questions you may ask yourself. Is every symmetry either \
a rotation or a reflection? (You might consider the case of a finite object, \
such as the rectangle in the figure, in contrast with an infinite object, \
such as an infinitely long wall-papered wall.) You might also wonder if every \
object has both rotational and reflectional symmetries. For this, consider \
the lower right figure, ",
  StyleBox["which",
    Evaluatable->False,
    AspectRatioFixed->True],
  " has extra \[OpenCurlyDoubleQuote]wings\[CloseCurlyDoubleQuote] off the \
edges. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["2.3.1 Getting started ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.2"],

Cell["\<\
Evaluate the following cell to see the figure you will first \
consider.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(firstfig = ShowOne[Lab2]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Your task is to determine the symmetry group for this figure, using \
permutations as the elements. In other words, as in the first lab, you are to \
determine the symmetries (transformations) in the form of permutations that \
will move the figure onto itself. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "As before, you may express your permutations in either the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{a, b, c, \[Ellipsis]}\)]],
  StyleBox[" or the form {1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", 2 ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", 3 ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ", \[Ellipsis]}",
  StyleBox[". Also, as in Group Lab 1, use",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" p[1] = {a,b,c, \[Ellipsis]}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1] = {1 \[Rule]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" a, 2 \[Rule] b, 3 \[Rule] c, \[Ellipsis]}",
    FontFamily->"Courier"],
  StyleBox[" to define your first permutation, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for your second, and so on. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Following is a list of functions that can be used for bookkeeping \
and testing while determining the permutations in the symmetry group of a \
figure. At the end of this section is a button that will bring up a palette \
to make working with these functions a bit easier.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3.2 Functions/variables to use in this lab ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.4.2"],

Cell[TextData[{
  StyleBox[
  "From Group Lab 1, you may already be familiar with how the functions ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowPermutation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " work; to refresh yourself, simply type ? followed by the command.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ShowPermutation\)\)], "Input"],

Cell[BoxData[
    \(\(?MultiplyPermutations\)\)], "Input"],

Cell["\<\
What follows is a short description of the other functions that can \
be used in this lab. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Type ",
  StyleBox["ShowOne[Lab2]",
    FontFamily->"Courier"],
  " to get a figure with which to work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ShowOne\)\)], "Input"],

Cell[TextData[{
  StyleBox["If you are fully confident that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is indeed a permutation of the vertices and is a symmetry of the figure, \
then type ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AddPermToGroup[p[i]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", which will add it to the list of all your symmetries.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?AddPermToGroup\)\)], "Input"],

Cell[TextData[{
  StyleBox["DropPermFromGroup[p[i]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" removes the permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" from the accumulated list of symmetries.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?DropPermFromGroup\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "To see the list of symmetries accumulated thus far by the previous two \
functions, type",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" MySymmetryGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MySymmetryGroup\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If you have a permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that you believe is a symmetry, but you want to check to be sure, type ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["TestPermutationQ[p[i]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and either ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["False",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" will be returned.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?TestPermutationQ\)\)], "Input"],

Cell[TextData[{
  StyleBox["To determine whether the accumulated permutations (as found in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MySymmetryGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ") are all proper elements of the symmetry group of the figure, calling ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GoodGroupElementsQ[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" answers with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["False",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?GoodGroupElementsQ\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "When you believe that you have found all the symmetries and have added \
them to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MySymmetryGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" via ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AddPermToGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", then you may check to see if your group is correct (complete) by typing \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CompleteGroupQ[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", which will return ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["False",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and possibly additional information. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?CompleteGroupQ\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "If you get stuck trying to think of what other possible permutations might \
yield a symmetry, type ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowPossiblePermutations[n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" being the number of vertices if a regular ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  "-gon is shown, or 2 if a zee or rectangle is shown). You are given a list \
of all possible permutations.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ShowPossiblePermutations\)\)], "Input"],

Cell[TextData[{
  StyleBox["ShowPossiblePermsAsRules[n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is the same as the last function except that the permutations are listed \
as rules, which may be helpful in using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RestrictList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function described below.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ShowPossiblePermsAsRules\)\)], "Input"],

Cell[TextData[{
  StyleBox["RestrictList[r]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" can be used to restrict the list produced by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowPossiblePermsAsRules",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " when you know that you want one vertex to go to another specific vertex \
but want to explore what can happen with the other vertices. Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" should be in the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  StyleBox[", {",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  StyleBox["}, or as a list of either of these.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?RestrictList\)\)], "Input"],

Cell[TextData[{
  StyleBox["It is easy to forget this list of functions. By typing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AvailableFunctions",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " (after evaluating the following), you can have the list of names always \
available.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(AvailableFunctions := {ShowPermutation, MultiplyPermutations, 
        ShowOne, AddPermToGroup, DropPermFromGroup, "\<MySymmetryGroup\>", 
        TestPermutationQ, GoodGroupElementsQ, CompleteGroupQ, 
        ShowPossiblePermutations, ShowPossiblePermsAsRules, RestrictList}; 
    \)\), 
    \(AvailableFunctions\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  "As an alternative to typing the functions just described, there is a \
palette specifically designed for this lab. This also includes a tool that \
makes the specification of permutations easier. Click ",
  ButtonBox["here",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
        "AbstractAlgebra", "Palettes", "GroupLabTwoPalette.nb"}], None},
    ButtonStyle->"Hyperlink"],
  " to use this palette."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4 Your turn", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.7.2"],

Cell[TextData[{
  StyleBox[
  "To see the figure again for the first exercise, evaluate the following \
cell. (Note: You should have already viewed it once when evaluating ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["firstfig = ShowOne[Lab2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" in the section 2.3.1.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(firstfig[[1]] // Show; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Using the information found in section 2.3.2, determine the complete \
list of all the symmetries (in the form of permutations) for the given \
figure. Use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" notation for each one (or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ppp[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " if used by one of the functions described above). Show all work in \
establishing this list. (Or show your work with the Permutation Specifier, \
found in a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["palette",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
        "AbstractAlgebra", "Palettes", "GroupLabTwoPalette.nb"}], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[" for this lab.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(AvailableFunctions\ 
    \n (*\ evaluate\ to\ be\ reminded\ what\ functions\ are\ available\ *) 
      \)\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " as in the Group Lab 1 to determine the Cayley table for the symmetry \
group of this figure. (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations[p[i], p[j]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" determines the permutation of",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" p[j]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".) ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Repeat the steps in questions 1 and 2 with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["secondfig",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[p, ppp]\), 
    \(secondfig = ShowOne[Lab2]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(AvailableFunctions\ 
    \n (*\ evaluate\ to\ be\ reminded\ what\ functions\ are\ available\ *) 
      \)\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Repeat the steps in questions 1 and 2 again. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[p, ppp]\), 
    \(thirdfig = ShowOne[Lab2]\)}], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.8.2"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?PermutationMatrix", "Input",
  AspectRatioFixed->True],

Cell["?ShowOne", "Input",
  AspectRatioFixed->True],

Cell["?ShowPermutation", "Input",
  AspectRatioFixed->True],

Cell["?MultiplyPermutations", "Input",
  AspectRatioFixed->True],

Cell["?AddPermToGroup", "Input",
  AspectRatioFixed->True],

Cell["?DropPermFromGroup", "Input",
  AspectRatioFixed->True],

Cell["?TestPermutationQ", "Input",
  AspectRatioFixed->True],

Cell["?GoodGroupElementsQ", "Input",
  AspectRatioFixed->True],

Cell["?CompleteGroupQ", "Input",
  AspectRatioFixed->True],

Cell["?ShowPossiblePermutations", "Input",
  AspectRatioFixed->True],

Cell["?ShowPossiblePermsAsRules", "Input",
  AspectRatioFixed->True],

Cell["?RestrictList", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{628, 433},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->8,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 2 Determining the symmetry group of a given figure", 
            FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right,
"GraphicsPrintingFormat"->"RenderInFrontEnd"},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AkXY0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:2.2"->{
    Cell[2382, 76, 197, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:2.2"]},
  "a:2.3.2"->{
    Cell[2604, 87, 484, 18, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.3.2"]},
  "a:2.4.2"->{
    Cell[7216, 244, 107, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.4.2"]},
  "a:2.5.2"->{
    Cell[7545, 259, 157, 4, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.5.2"]},
  "a:2.6.2"->{
    Cell[8194, 278, 125, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.6.2"]},
  "a:2.6.3.2"->{
    Cell[31322, 1020, 117, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.2"]},
  "a:2.6.4.2"->{
    Cell[33954, 1117, 140, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:2.6.4.2"]},
  "a:2.7.2"->{
    Cell[45034, 1533, 103, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.7.2"]},
  "a:2.8.2"->{
    Cell[49702, 1712, 370, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.8.2"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:2.2", 53075, 1828},
  {"a:2.3.2", 53183, 1832},
  {"a:2.4.2", 53296, 1836},
  {"a:2.5.2", 53409, 1840},
  {"a:2.6.2", 53522, 1844},
  {"a:2.6.3.2", 53637, 1848},
  {"a:2.6.4.2", 53759, 1852},
  {"a:2.7.2", 53879, 1856},
  {"a:2.8.2", 53994, 1860}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 197, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:2.2"],

Cell[CellGroupData[{
Cell[2604, 87, 484, 18, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.3.2"],
Cell[3091, 107, 802, 20, 109, "Text",
  Evaluatable->False],
Cell[3896, 129, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5292, 172, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5470, 178, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6118, 201, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6836, 228, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7216, 244, 107, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.4.2"],
Cell[7326, 249, 182, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7545, 259, 157, 4, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.5.2"],
Cell[7705, 265, 452, 8, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8194, 278, 125, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.6.2"],
Cell[8322, 283, 378, 13, 33, "Text",
  Evaluatable->False],
Cell[8703, 298, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[8878, 304, 162, 3, 33, "Text",
  Evaluatable->False],
Cell[9043, 309, 17114, 551, 252, 4416, 387, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[26160, 862, 838, 23, 90, "Text",
  Evaluatable->False],
Cell[27001, 887, 951, 21, 128, "Text",
  Evaluatable->False],
Cell[27955, 910, 163, 4, 32, "Text"],
Cell[28121, 916, 156, 3, 33, "Text",
  Evaluatable->False],
Cell[28280, 921, 137, 3, 27, "Input"],
Cell[28420, 926, 788, 23, 90, "Text",
  Evaluatable->False],
Cell[29211, 951, 621, 18, 90, "Text",
  Evaluatable->False],
Cell[29835, 971, 163, 4, 32, "Text"],
Cell[30001, 977, 124, 3, 33, "Text",
  Evaluatable->False],
Cell[30128, 982, 137, 3, 27, "Input"],
Cell[30268, 987, 373, 13, 52, "Text",
  Evaluatable->False],
Cell[30644, 1002, 653, 14, 109, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31322, 1020, 117, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.2"],
Cell[31442, 1025, 144, 5, 33, "Text",
  Evaluatable->False],
Cell[31589, 1032, 83, 2, 27, "Input"],
Cell[31675, 1036, 334, 7, 71, "Text",
  Evaluatable->False],
Cell[32012, 1045, 1558, 58, 71, "Text",
  Evaluatable->False],
Cell[33573, 1105, 344, 7, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[33954, 1117, 140, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:2.6.4.2"],
Cell[34097, 1122, 649, 22, 71, "Text",
  Evaluatable->False],
Cell[34749, 1146, 53, 1, 27, "Input"],
Cell[34805, 1149, 58, 1, 27, "Input"],
Cell[34866, 1152, 163, 5, 33, "Text",
  Evaluatable->False],
Cell[35032, 1159, 183, 7, 33, "Text",
  Evaluatable->False],
Cell[35218, 1168, 45, 1, 27, "Input"],
Cell[35266, 1171, 668, 22, 71, "Text",
  Evaluatable->False],
Cell[35937, 1195, 52, 1, 27, "Input"],
Cell[35992, 1198, 493, 17, 52, "Text",
  Evaluatable->False],
Cell[36488, 1217, 55, 1, 27, "Input"],
Cell[36546, 1220, 414, 15, 52, "Text",
  Evaluatable->False],
Cell[36963, 1237, 74, 2, 27, "Input"],
Cell[37040, 1241, 964, 35, 52, "Text",
  Evaluatable->False],
Cell[38007, 1278, 54, 1, 27, "Input"],
Cell[38064, 1281, 994, 35, 71, "Text",
  Evaluatable->False],
Cell[39061, 1318, 56, 1, 27, "Input"],
Cell[39120, 1321, 1241, 45, 90, "Text",
  Evaluatable->False],
Cell[40364, 1368, 52, 1, 27, "Input"],
Cell[40419, 1371, 820, 27, 71, "Text",
  Evaluatable->False],
Cell[41242, 1400, 62, 1, 27, "Input"],
Cell[41307, 1403, 588, 19, 71, "Text",
  Evaluatable->False],
Cell[41898, 1424, 62, 1, 27, "Input"],
Cell[41963, 1427, 1619, 58, 90, "Text",
  Evaluatable->False],
Cell[43585, 1487, 50, 1, 27, "Input"],
Cell[43638, 1490, 466, 15, 52, "Text",
  Evaluatable->False],
Cell[44107, 1507, 404, 8, 107, "Input",
  InitializationCell->True],
Cell[44514, 1517, 471, 10, 71, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[45034, 1533, 103, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.7.2"],
Cell[45140, 1538, 496, 15, 52, "Text",
  Evaluatable->False],
Cell[45639, 1555, 60, 1, 27, "Input"],
Cell[45702, 1558, 1221, 38, 105, "Question",
  Evaluatable->False],
Cell[46926, 1598, 166, 4, 43, "Input"],
Cell[47095, 1604, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[47172, 1608, 1116, 40, 86, "Question",
  Evaluatable->False],
Cell[48291, 1650, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[48368, 1654, 459, 17, 48, "Question",
  Evaluatable->False],
Cell[48830, 1673, 110, 3, 43, "Input"],
Cell[48943, 1678, 166, 4, 43, "Input"],
Cell[49112, 1684, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[49189, 1688, 287, 10, 48, "Question",
  Evaluatable->False],
Cell[49479, 1700, 109, 3, 43, "Input"],
Cell[49591, 1705, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[49702, 1712, 370, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.8.2"],
Cell[50075, 1728, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[50420, 1739, 61, 1, 27, "Input"],
Cell[50484, 1742, 51, 1, 27, "Input"],
Cell[50538, 1745, 59, 1, 27, "Input"],
Cell[50600, 1748, 64, 1, 27, "Input"],
Cell[50667, 1751, 58, 1, 27, "Input"],
Cell[50728, 1754, 61, 1, 27, "Input"],
Cell[50792, 1757, 60, 1, 27, "Input"],
Cell[50855, 1760, 62, 1, 27, "Input"],
Cell[50920, 1763, 58, 1, 27, "Input"],
Cell[50981, 1766, 68, 1, 27, "Input"],
Cell[51052, 1769, 68, 1, 27, "Input"],
Cell[51123, 1772, 56, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

