(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    145446,       4956]*)
(*NotebookOutlinePosition[    174071,       6004]*)
(*  CellTagsIndexPosition[    173733,       5989]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 4",
    FontSize->18],
  "\n",
  "Let\[CloseCurlyQuote]s Get These Orders Straight"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.4"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.5.4"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.6.4"],

Cell[TextData[{
  StyleBox[
  "To complete this lab you should be familiar with the basic definition of a \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["group",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". You should also be familiar with the definition of the order",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["of an element in a group. (Recall that the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["order ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["of an element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" of a finite group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" is the least positive integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^k\)]],
  StyleBox[" is equal to the identity of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.7.4"],

Cell[TextData[{
  "In this lab, we look at issues regarding the order of groups and their \
elements. First we consider the relationship between the order of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " and the order of the inverse of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ". We then look at the distribution of the orders of elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", followed by an inspection of which elements share a common order. We \
then begin an exploration regarding the probability that an arbitrary element \
of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " will generate the whole group. Finally, we consider the order of the \
group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " (the multiplicative units of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ") and try to find an expression for this order in terms of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.3 Order of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " and its inverse"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.8.4"],

Cell[TextData[{
  StyleBox["Suppose we consider any group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and take a random element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[". The issue we would like to consider is how the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", denoted ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\(| g\) | \)\)]],
  StyleBox[", compares with the order of its inverse, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\( | g\^\(-1\) | \)\)]],
  "."
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "For this section of the lab, the groups we consider come from the \
following list: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[DoubleStruckCapitalZ]\_\(n\ \)\)(1 < n < 31)\)]],
  StyleBox[",",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\ U\_n\ \((2 < n < 41)\)\)\)]],
  StyleBox[",",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\ D\_n\ \((1 < n < 8)\)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GaussianUnits",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{\(\[PlusMinus]1\), \(\[PlusMinus]i\)}\)]],
  StyleBox[", under multiplication), and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["IntegerUnits",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ({",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]1\)\)]],
  StyleBox["}, under multiplication).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowOne[Lab4]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" presents a random group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" from the preceding list and then chooses a random element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" from the chosen group. First, we read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code needed for this lab; evaluate the following two cells.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\), 
    \(\(SetOptions[ListPlot, PlotStyle \[Rule] RGBColor[0, 0, 1]]; \)\)}], 
  "Input",
  CellDingbat->None,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[{
    \({G, g} = ShowOne[Lab4]\), 
    \(\(op = Operation[G]; \)\)}], "Input",
  CellDingbat->None],

Cell[TextData[{
  StyleBox["This gives a random group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and an element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["; we have also defined ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["op",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" as a variable for the group operation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We now wish to determine the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[". We can do this by successively applying the operation to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(op[g, g]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This calculates ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^2\)]],
  StyleBox[". To calculate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^3\)]],
  StyleBox[", apply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["op",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and the last result (indicated by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["%",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(op[g, %]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["To calculate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^4\)]],
  StyleBox[", apply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["op",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and the last result (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["%",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["), and so on.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(op[g, %]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" given above, determine the order of the element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[". Also record your group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s pick another group and element."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({G, g} = ShowOne[Lab4]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["As an alternative, one can use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ElementToPower",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function that calculates ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^n\)]],
  StyleBox[" for any integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ElementToPower[G, g, 2]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  "The following calculates the first 6 powers; adjust the range of the table \
accordingly to determine ",
  Cell[BoxData[
      \(TraditionalForm\`\(\( | g\) | \)\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Table[ElementToPower[G, g, k], {k, 1, 6}]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in this case? (Record your group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"We can also use the following function to calculate the order. Since it is \
important to know how to calculate orders, be sure you answer questions 1 and \
2 \[OpenCurlyDoubleQuote]by hand\[CloseCurlyDoubleQuote] before confirming \
your answer with this function."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Order[G, g]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For the given group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", determine the inverse of the element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in the group. (You are expected to do this without using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Just as it is important to be able to determine orders through calculations, \
it is also important to be able to determine (\[OpenCurlyDoubleQuote]by hand\
\[CloseCurlyDoubleQuote]) the inverse of an element. The following command \
can be used to confirm your answer to the last question, but evaluate it only \
after you have found an answer."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(invg = GroupInverse[G, g]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s ask ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to help us calculate the order of the inverse.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Order[G, invg]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". In this case, what is the relationship between the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and the order of its inverse? Record ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  "\[CloseCurlyQuote]",
  StyleBox["s inverse.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s try this again. First we pick out a group and an \
element."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({G, g} = ShowOne[Lab4]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Next determine the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" (without ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[") and then use the following to confirm your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Order[G, g]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  "Now determine the inverse of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " and confirm with the following."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(invg = GroupInverse[G, g]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  "Finally, calculate the order of the inverse and compare it to the order of \
",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " itself."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Order[G, invg]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". In this case, what is the relationship between the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and the order of its inverse? Since the pair ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((G, g)\)\)]],
  StyleBox[
  " you investigated was randomly generated, include in your answer the group \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g\^\(-1\)\)]],
  StyleBox[", and the orders of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^\(-1\)\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s generate some more data. The output from the \
following cell might take a little time to compute. It will consist of a list \
of several groups, a random element from each group, the inverse of the \
element, and the orders of the element and its inverse."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{G, g} = ShowOne[Lab4, Verbal \[Rule] False]; {GroupoidName[G], 
          g, invg = GroupInverse[G, g], Order[G, g], Order[G, invg]}, {20}], 
      TableHeadings 
        \[Rule] {
          None, {"\<group\>", "\<g\>", \*"\"\<\!\(g\^\(-1\)\)\>\"", 
            "\<|g|\>", \*"\"\<|\!\(g\^\(-1\)\)|\\n\>\""}}, 
      TableSpacing \[Rule] {0.5, 3}]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Make a conjecture about the relationship between the order of an element \
in a group and the order of its inverse.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Try to prove your conjecture.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.4 Distribution of the orders of elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]]
}], "Section",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.9.4"],

Cell[TextData[{
  "We now pick a random index ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " between 20 and 60 and consider the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  "."
}], "Text",
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {20, 60}]\), 
    \(G = Z[n]\)}], "Input",
  CellDingbat->None,
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s take a random element from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " and find its order. Making a table, we will do this experiment with 20 \
trials."
}], "Text",
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(numTrials = 20; \)\), 
    \(TableForm[Table[g = RandomElement[G]; {g, Order[G, g]}, {numTrials}], 
      TableHeadings \[Rule] {None, {"\<g\>", "\<|g|\n\>"}}, 
      TableSpacing \[Rule] {0.5, 3}]\)}], "Input",
  CellDingbat->None,
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Record, either here or on your paper, both the index ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" used and all the ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["different",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " orders (appearing in the second column); at this point, we only want to \
record ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["which",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" orders occur for a given index ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[".",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Now repeat this experiment with a new group by evaluating the following \
cell. ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  "In the unlikely event that you get the same index, evaluate the cell again \
to get a new value for n.",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(n = Random[Integer, {20, 60}]; \)\), 
    \(G = Z[n]\), 
    \(\(numTrials = 20; \)\), 
    \(TableForm[Table[g = RandomElement[G]; {g, Order[G, g]}, {numTrials}], 
      TableHeadings \[Rule] {None, {"\<g\>", "\<|g|\n\>"}}, 
      TableSpacing \[Rule] {0.5, 3}]\)}], "Input",
  CellDingbat->None,
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell[TextData[{
  "Record both the index ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and the orders that appear. Keep evaluating this input cell until you can \
answer question 8."
}], "Text",
  CellMargins->{{Inherited, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    FontWeight->"Bold"],
  StyleBox[". Given a positive integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", what can you say about the orders of the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox["? State your conclusion formally in the form of a conjecture.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["4.5 Another look at orders", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.10.4"],

Cell[TextData[{
  "In section 4.4, we considered the relationship between ",
  Cell[BoxData[
      \(TraditionalForm\`\(| g | \)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(| G | \)\)]],
  " for elements ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " from some group ",
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_n\)]],
  ". Now that the relationship is determined, we wish to consider the \
frequencies of various orders. In other words, how frequently does a \
particular order occur, once we know that it does occur? For the moment, we \
will still consider ",
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_n\)]],
  ". Let\[CloseCurlyQuote]s pick an arbitrary index for this group."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {8, 50}]\), 
    \(G = Z[n]\)}], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["Evaluate the following command.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(ShowGroupOrders[Z[n]]; \)\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"If these graphics are hard to read, you may wish to enlarge them. (To do so, \
click once on the graphic to select it and then drag from the lower right \
corner until the graphic is sufficiently enlarged.) ",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "A word of explanation is in order. The first graph, a ",
  StyleBox["ListPlot",
    FontFamily->"Courier"],
  ", consists of a graphical representation of what was accomplished in \
section 4.4",
  StyleBox[". Along the horizontal axis are the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[
  " and along the vertical axis are the orders the elements can take. For \
each element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  ", there is a dot at the height corresponding to the order of that element. \
",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"The second graph is a bar chart showing the frequencies with which the \
orders occur. Along the bottom are the different orders of elements in the \
group, and the height of the bar corresponds with how many elements in the \
group have that particular order.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Consider another example.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {8, 50}]\), 
    \(G = Z[n]\), 
    \(\(ShowGroupOrders[G]; \)\)}], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["\<\
Evaluate this cell a few more times until you can answer the \
following question.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is composite. (If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " is prime, the graphs are trivially simple.) What can you say about the \
frequencies of the orders? What can you say about the shape of the frequency \
histogram (second graph)? What can you say about the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ListPlot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Try the following, which executes the same commands but looks at the group \
",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " (the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " that have multiplicative inverses, with the group operation being \
multiplication mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ")."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Do[ShowGroupOrders[U[i]], {i, 14, 20}]; \)\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Reconsider what you answered in question 9. Are any of your answers \
specific to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[", not holding here with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox["? Are any still true with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["With the preceding work, we worried not about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["which",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" but about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["how many",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" elements lead to various orders. Now we wish to focus on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["which",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" elements. Evaluate the following.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n\  = \ Random[Integer, \ {8, \ 50}]\), 
    \(CollectOrders[OrderOfAllElements[Z[n]]] // ColumnForm\)}], "Input",
  CellDingbat->None],

Cell[TextData[{
  "Here we pick a random integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and then pairs of the form ",
  Cell[BoxData[
      \(TraditionalForm\`{k, A}\)]],
  " are returned, where ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is an order that occurs in the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " is the set of all elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " that have this order ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ". Study the output. Try evaluating the cell again. And again. And again, \
until you can answer the following questions."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What relationship is there among the elements in the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  StyleBox[" when a given pair ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{k, A}\)]],
  StyleBox[
  " is the output? Can you formalize a relationship in the form of a \
(generalized) conjecture?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For a given pair ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{k, A}\)]],
  StyleBox[", what relationships are there between the elements in the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  "? Can you formalize a relationship in the form of a (generalized) \
conjecture?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.6 What is ",
  Cell[BoxData[
      \(TraditionalForm\`P(\(\( | g\) | \) = n)\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  "?"
}], "Section",
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.11.4"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s pick a random group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`{15, 16,  ... , 40\)]],
  Cell[BoxData[
      \(TraditionalForm\`}\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {15, 40}]\), 
    \(G = Z[n]\)}], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Of all the elements in this group, how many of them have order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["? Think about it. How many do you think?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Using the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Orders",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" pairs are returned, each taking the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{g, \( | g | \)}\)]],
  StyleBox[", an element and its order.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Orders\)\)], "Input",
  CellDingbat->None],

Cell[BoxData[
    \(orders = Orders[G]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  "From this list, we select those whose second coordinate is equal to ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " (the order of the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ")."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(nIsOrder = 
      Select[orders, #1\[LeftDoubleBracket]2\[RightDoubleBracket] == n&]\)], 
  "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["How many have this order? ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Length",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" will find out.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(howMany = Length[nIsOrder]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["To calculate the ratio, we can do the following.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(N[howMany\/n]\)], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s record our results. What information is really \
significant to record? How about the index ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and the percentage found in the last result? Record this somewhere. Now \
let\[CloseCurlyQuote]s do this again, but compact all the steps in one cell."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {5, 40}]\), 
    \(G = Z[n]\), 
    \(orders = OrderOfAllElements[G]\), 
    \(nIsOrder = 
      Select[orders, #1\[LeftDoubleBracket]2\[RightDoubleBracket] == n&]\), 
    \(howMany = Length[nIsOrder]\), 
    \(N[howMany\/n]\)}], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Or if you are a real ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" nerd, you might combine it as follows (output is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{n, percentage}\)]],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(n\  = \ Random[Integer, \ {5, \ 40}]; 
    \n{n, \ N[
        Length[Select[OrderOfAllElements[Z[n]], \n\t\((#[\([2]\)] == n)\)&]]/
          n]}\)], "Input",
  CellDingbat->None],

Cell[TextData[{
  "The advantage of the last method is that it is a little quicker and easier \
to put in a loop if one wants to repeat it a number of times (say, 15). \
Depending on your computer and the indices ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " that will be chosen, the following may take some time. Recall that the \
output is of the form {",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "} where ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is the percentage of elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " that have have order ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(numTrials\  = \ 15; \n
    percents\  = \ 
      Table[n\  = \ Random[Integer, \ {5, \ 40}]; \n
          \t{n, N[Length[
                  Select[OrderOfAllElements[Z[n]], \n\t
                    \((#[\([2]\)] == n)\)&]]/n]}, \ {numTrials}] // Union\)], 
  "Input",
  CellDingbat->None],

Cell[BoxData[
    \(\(ListPlot[percents, PlotRange \[Rule] {0, 1}, 
      AxesOrigin 
        \[Rule] {
          Min[\(Transpose[percents]\)\[LeftDoubleBracket]1
                \[RightDoubleBracket]] - 1, 0}, 
      PlotStyle \[Rule] {RGBColor[0, 0, 1], PointSize[0.015]}]; \)\)], "Input",\

  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Look at the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ListPlot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", as well as the data above. Which integers yield high percentages? Which \
yield low percentages? Can you give any explanation for this phenomenon? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s calculate the overall average (arithmetic mean)."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(mean\  = \ 
      Apply[Plus, \ \(Transpose[percents]\)[\([2]\)]]/Length[percents]\)], 
  "Input",
  CellDingbat->None],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s consider calculating the percentages for all ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " up to ",
  Cell[BoxData[
      \(TraditionalForm\`n = 25\)]],
  ". (The watch means that it would take some time if you were to evaluate \
the next cell; instead, simply open it up to look at the preevaluated \
output.)"
}], "Text",
  CellDingbat->None,
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[\n\t{n, \ 
          N[Length[
                Select[OrderOfAllElements[Z[n]], \n\t\((#[\([2]\)] == n)\)&]]/
              n]}, \ {n, \ 2, \ 25}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{2, 0.5`}, {3, 0.666666666666666607`}, {4, 0.5`}, {5, 0.8`}, {6, 
        0.333333333333333303`}, {7, 0.857142857142857117`}, {8, 0.5`}, {9, 
        0.666666666666666607`}, {10, 0.4`}, {11, 0.909090909090908994`}, {12, 
        0.333333333333333303`}, {13, 0.923076923076923172`}, {14, 
        0.428571428571428558`}, {15, 0.533333333333333303`}, {16, 0.5`}, {17, 
        0.941176470588235325`}, {18, 0.333333333333333303`}, {19, 
        0.947368421052631504`}, {20, 0.4`}, {21, 0.571428571428571352`}, {22, 
        0.454545454545454497`}, {23, 0.956521739130434767`}, {24, 
        0.333333333333333303`}, {25, 0.8`}}\)], "Output",
  Editable->False,
  Selectable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0380952 0 0.618034 [
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -6 -9 ]
[.40476 -0.0125 6 0 ]
[.59524 -0.0125 -6 -9 ]
[.59524 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
[(5)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(10)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(15)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(20)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(25)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.0619 0 m
.0619 .00375 L
s
.1 0 m
.1 .00375 L
s
.1381 0 m
.1381 .00375 L
s
.17619 0 m
.17619 .00375 L
s
.25238 0 m
.25238 .00375 L
s
.29048 0 m
.29048 .00375 L
s
.32857 0 m
.32857 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.44286 0 m
.44286 .00375 L
s
.48095 0 m
.48095 .00375 L
s
.51905 0 m
.51905 .00375 L
s
.55714 0 m
.55714 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.67143 0 m
.67143 .00375 L
s
.70952 0 m
.70952 .00375 L
s
.74762 0 m
.74762 .00375 L
s
.82381 0 m
.82381 .00375 L
s
.8619 0 m
.8619 .00375 L
s
.9 0 m
.9 .00375 L
s
.9381 0 m
.9381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.1 .30902 Mdot
.1381 .41202 Mdot
.17619 .30902 Mdot
.21429 .49443 Mdot
.25238 .20601 Mdot
.29048 .52974 Mdot
.32857 .30902 Mdot
.36667 .41202 Mdot
.40476 .24721 Mdot
.44286 .56185 Mdot
.48095 .20601 Mdot
.51905 .57049 Mdot
.55714 .26487 Mdot
.59524 .32962 Mdot
.63333 .30902 Mdot
.67143 .58168 Mdot
.70952 .20601 Mdot
.74762 .58551 Mdot
.78571 .24721 Mdot
.82381 .35316 Mdot
.8619 .28092 Mdot
.9 .59116 Mdot
.9381 .20601 Mdot
.97619 .49443 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Selectable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool004Yoo`<002aoo`<000Aoo`8002Qoo`<000=oo`<002Uoo`@000=oo`8002Qoo`@0009oo`<000Yo
o`00CGoo00<007ooOol0:Woo00<007ooOol00Woo00@007ooOol002Qoo`03001oogoo00Eoo`03001o
ogoo02Moo`03001oogoo009oo`04001oogoo000XOol00`00Oomoo`05Ool00`00Oomoo`07Ool004eo
o`03001oogoo02Yoo`03001oogoo009oo`04001oogoo000XOol00`00Oomoo`05Ool00`00Oomoo`0X
Ool01@00Oomoogoo00000Woo00<007ooOol09goo00<007ooOol017oo00<007ooOol01goo001:Ool3
000]Ool00`00Oomoo`02Ool01000Oomoo`00:7oo00<007ooOol00Woo0`00;7oo00@007ooOol0009o
o`03001oogoo02Qoo`03001oogoo00<000Yoo`00BWoo00<007ooOol0;Goo00<007ooOol00Woo00@0
07ooOol002Qoo`03001oogoo009oo`03001oogoo02Uoo`04001oogoo0002Ool01000Oomoo`009goo
00@007ooOol0009oo`03001oogoo00Yoo`00BWoo1000:goo0P001Goo0P00:7oo0P0017oo1000:Goo
0P0017oo0P00:Goo0P000goo10002Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Eo
ool000D000Moo`006goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol02goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=o
o`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=o
o`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=o
o`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo
00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo
00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007oo
Ool0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007oo
Ool0ogoo0goo000KOol00`00Oomoo`3oOol3Ool000Qoo`8000Aoo`8000=oo`@000Aoo`03001oogoo
0?moo`=oo`001goo00@007ooOol000=oo`8000Aoo`03001oogoo00Aoo`03001oogoo0?moo`=oo`00
1goo00@007ooOol000Yoo`03001oogoo00=oo`<00?moo`=oo`001goo00@007ooOol000]oo`03001o
ogoo009oo`03001oogoo0?moo`=oo`001goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomo
o`3oOol3Ool000Qoo`8000Yoo`8000Eoo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo03Qoo`807cUoo`807cUoo`807cYoo`807aIoo`006goo00<007oo
Ool0>7oo0P0O>Goo0P0O>Goo0P0O>Woo0P0O5Woo000KOol00`00Oomoo`3oOol3Ool001]oo`800?mo
o`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?mo
o`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool000Qoo`8000Aoo`8000Ao
o`<000Aoo`03001oogoo0?moo`=oo`001goo00@007ooOol000=oo`8000Eoo`03001oogoo00=oo`03
001oogoo05moo`807f5oo`807cioo`001goo00@007ooOol000Qoo`@000Aoo`<005moo`807f5oo`80
7cioo`001goo00@007ooOol000Qoo`03001oo`0000Eoo`03001oogoo0?moo`=oo`001goo00@007oo
Ool000Qoo`03001oo`0000Eoo`03001oogoo0?moo`=oo`0027oo0P002Woo0P001Goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`27Ool201miOol001]oo`03001oogoo08Moo`807gUoo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800=Moo`807bYoo`006goo00<007oo
Ool0eWoo0P0O:Woo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol047oo0P0O4Woo0P0O9Woo0P0OCGoo0P0OIGoo000KOol2000AOol201lBOol201lVOol201m=
Ool201mUOol001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0TGoo0P0OKgoo000KOol00`00
Oomoo`2AOol201m_Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0c7oo0P0O=7oo000KOol00`00
Oomoo`3<Ool201ldOol001]oo`03001oogoo0?moo`=oo`0027oo0P0017oo0P0017oo0P001Goo00<0
07ooOol0ogoo0goo0007Ool01000Oomoo`000goo0P000goo00@007ooOol000Aoo`03001oogoo0?mo
o`=oo`001goo00@007ooOol000Qoo`04001oogoo0004Ool3003oOol3Ool000Moo`04001oogoo0008
Ool30005Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0008Ool00`00Oomoo`05Ool00`00Oomo
o`3oOol3Ool000Qoo`8000Yoo`<000Aoo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol06Woo0P0O>Goo0P0O
Zgoo000KOol00`00Oomoo`0JOol201liOol201n[Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00
ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool000Qoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo0?moo`=oo`00
1goo00@007ooOol000=oo`8000=oo`04001oogoo0004Ool00`00Oomoo`0^Ool201o3Ool201l=Ool0
00Moo`04001oogoo0008Ool01000Oomoo`0017oo0`00;Woo0P0O`goo0P0O3Goo0007Ool01000Oomo
o`002Goo0P001Goo00<007ooOol0ogoo0goo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`03
001oogoo0?moo`=oo`0027oo0P002Woo0P001Goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0@Woo0P0O_Woo000KOol00`00Oomoo`12Ool2
01nnOol001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool0
01]oo`03001oogoo06Uoo`807iMoo`006goo00<007ooOol0JGoo0P0OUgoo000KOol00`00Oomoo`1m
Ool201n3Ool001]oo`03001oogoo07eoo`807h=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`2TOol201mLOol001]oo`03001oogoo0:Aoo`807a9oo`807dQoo`006goo0P00^Goo0P0OB7oo
000KOol00`00Oomoo`3POol201lPOol001]oo`03001oogoo0>1oo`807b1oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`004goo0`001Goo00<0
07ooOol0ogoo0goo000DOol00`00Oomoo`04Ool00`00Oomoo`3oOol3Ool001Aoo`03001oogoo00Ao
o`<00?moo`=oo`0057oo00<007ooOol0ogoo2Woo000DOol00`00Oomoo`3oOol:Ool001=oo`800?mo
o`aoo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.79548, -0.0764114, 
  0.101272, 0.00624232}}]
}, Closed]],

Cell[TextData[{
  "As well as the percentages from ",
  Cell[BoxData[
      \(TraditionalForm\`n = 26\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`n = 40\)]],
  ": "
}], "Text",
  CellDingbat->None,
  CellMargins->{{12, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[\n\t{n, \ 
          N[Length[
                Select[OrderOfAllElements[Z[n]], \n\t\((#[\([2]\)] == n)\)&]]/
              n]}, \ {n, \ 26, \ 40}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {26, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{26, 0.461538461538461586`}, {27, 0.666666666666666607`}, {28, 
        0.428571428571428558`}, {29, 0.96551724137931032`}, {30, 
        0.266666666666666651`}, {31, 0.967741935483870996`}, {32, 0.5`}, {33, 
        0.606060606060606055`}, {34, 0.470588235294117662`}, {35, 
        0.685714285714285765`}, {36, 0.333333333333333303`}, {37, 
        0.972972972972972982`}, {38, 0.473684210526315752`}, {39, 
        0.615384615384615418`}, {40, 0.4`}}\)], "Output",
  Editable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.7449 0.0680272 0 0.618034 [
[.15986 -0.0125 -6 -9 ]
[.15986 -0.0125 6 0 ]
[.29592 -0.0125 -6 -9 ]
[.29592 -0.0125 6 0 ]
[.43197 -0.0125 -6 -9 ]
[.43197 -0.0125 6 0 ]
[.56803 -0.0125 -6 -9 ]
[.56803 -0.0125 6 0 ]
[.70408 -0.0125 -6 -9 ]
[.70408 -0.0125 6 0 ]
[.84014 -0.0125 -6 -9 ]
[.84014 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15986 0 m
.15986 .00625 L
s
[(28)] .15986 -0.0125 0 1 Mshowa
.29592 0 m
.29592 .00625 L
s
[(30)] .29592 -0.0125 0 1 Mshowa
.43197 0 m
.43197 .00625 L
s
[(32)] .43197 -0.0125 0 1 Mshowa
.56803 0 m
.56803 .00625 L
s
[(34)] .56803 -0.0125 0 1 Mshowa
.70408 0 m
.70408 .00625 L
s
[(36)] .70408 -0.0125 0 1 Mshowa
.84014 0 m
.84014 .00625 L
s
[(38)] .84014 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(40)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05782 0 m
.05782 .00375 L
s
.09184 0 m
.09184 .00375 L
s
.12585 0 m
.12585 .00375 L
s
.19388 0 m
.19388 .00375 L
s
.22789 0 m
.22789 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.32993 0 m
.32993 .00375 L
s
.36395 0 m
.36395 .00375 L
s
.39796 0 m
.39796 .00375 L
s
.46599 0 m
.46599 .00375 L
s
.5 0 m
.5 .00375 L
s
.53401 0 m
.53401 .00375 L
s
.60204 0 m
.60204 .00375 L
s
.63605 0 m
.63605 .00375 L
s
.67007 0 m
.67007 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.77211 0 m
.77211 .00375 L
s
.80612 0 m
.80612 .00375 L
s
.87415 0 m
.87415 .00375 L
s
.90816 0 m
.90816 .00375 L
s
.94218 0 m
.94218 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.02381 .28525 Mdot
.09184 .41202 Mdot
.15986 .26487 Mdot
.22789 .59672 Mdot
.29592 .16481 Mdot
.36395 .5981 Mdot
.43197 .30902 Mdot
.5 .37457 Mdot
.56803 .29084 Mdot
.63605 .42379 Mdot
.70408 .20601 Mdot
.77211 .60133 Mdot
.84014 .29275 Mdot
.90816 .38033 Mdot
.97619 .24721 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool003Uoo`@000=oo`8001]oo`<000Aoo`8001Yoo`<000=oo`@001Uoo`<000Aoo`<001Uoo`<000Ao
o`8001]oo`<000Aoo`8001]oo`<000=oo`8000Yoo`00>Woo00<007ooOol00Woo00@007ooOol001eo
o`04001oogoo0002Ool00`00Oomoo`0JOol01@00Oomoogoo00007Woo00<007ooOol00Woo00<007oo
Ool06goo00@007ooOol0009oo`03001oogoo01]oo`04001oogoo0002Ool00`00Oomoo`0IOol01@00
Oomoogoo00000Woo00<007ooOol01goo000kOol01@00Oomoogoo00000Woo00<007ooOol06goo00@0
07ooOol0009oo`03001oogoo01Yoo`03001oogoo009oo`03001oogoo01]oo`03001oogoo00@001ao
o`04001oogoo0002Ool00`00Oomoo`0KOol01000Oomoo`000Woo00<007ooOol05goo10000Woo00@0
07ooOol000Uoo`00?7oo00@007ooOomoo`8001aoo`8000=oo`04001oogoo000JOol20006Ool00`00
Oomoo`0HOol20003Ool00`00Ool0000KOol20003Ool3000LOol20004Ool2000JOol00`00Ool00003
Ool01000Oomoo`002Goo000iOol01000Oomoo`000Woo00@007ooOol001eoo`04001oogoo0002Ool0
0`00Oomoo`0JOol01000Oomoo`000Woo00<007ooOol06Woo00H007ooOol007oo000MOol01000Oomo
o`0087oo00@007ooOol0009oo`03001oogoo01Moo`03001oo`0000=oo`04001oogoo0009Ool003Yo
o`8000Aoo`8001]oo`<000Aoo`8001Yoo`<000Aoo`8001Yoo`<000Aoo`8001Yoo`<000Aoo`<001Yo
o`<000Aoo`8001]oo`8000Aoo`8000Yoo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000E
Oooo00050007Ool001]oo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00]oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?mo
o`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?mo
o`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo0008Ool20004Ool20003Ool40004Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0003
Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo000:Ool00`00Oomo
o`03Ool3003oOol3Ool000Moo`04001oogoo000;Ool00`00Oomoo`02Ool00`00Oomoo`3oOol3Ool0
00Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0ogoo0goo0008Ool2000:Ool20005
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo04=oo`807keoo`006goo00<007ooOol0@goo0P0O_Goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`2]Ool201mCOol001]oo`03001oogoo0:eoo`807e=oo`006goo00<007ooOol0ogoo0goo000K
Ool2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo0008Ool20004
Ool20004Ool30004Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0003Ool20005Ool00`00Oomo
o`03Ool00`00Oomoo`3cOol201l=Ool000Moo`04001oogoo0008Ool40004Ool3003cOol201l=Ool0
00Moo`04001oogoo0008Ool00`00Ool00005Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0008
Ool00`00Ool00005Ool00`00Oomoo`3oOol3Ool000Qoo`8000Yoo`8000Eoo`03001oogoo0?moo`=o
o`006goo00<007ooOol087oo0P0Oh7oo000KOol00`00Oomoo`0POol201oPOol001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`807omoo`Aoo`006goo
0P0Oogoo17oo000KOol00`00Oomoo`2:Ool201m4Ool201l`Ool001]oo`03001oogoo08Yoo`807dAo
o`807c1oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
06Ioo`807iYoo`006goo0P00Igoo0P0OVWoo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Ao
o`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=o
o`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool000Qoo`8000Aoo`8000Aoo`80
00Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000=oo`8000=oo`04001oogoo0004Ool00`00
Oomoo`3oOol3Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo0`00N7oo0P0OR7oo0007Ool0
1000Oomoo`0027oo0`001Goo00<007ooOol0N7oo0P0OR7oo0007Ool01000Oomoo`0027oo00<007oo
Ool01Goo00<007ooOol0hWoo0P0O7Woo0008Ool2000:Ool30004Ool00`00Oomoo`3ROol201lNOol0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo00ioo`807o9oo`006goo00<007ooOol03Woo0P0OlWoo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo09]oo`807fEoo`006goo00<007ooOol0Vgoo0P0OIGoo000KOol00`00Oomoo`3o
Ool3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03
001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo0008Ool20004Ool20004Ool20005Ool00`00
Oomoo`3oOol3Ool000Moo`04001oogoo0003Ool20003Ool01000Oomoo`0017oo00<007ooOol0ogoo
0goo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`<00?moo`=oo`001goo00@007ooOol000Uo
o`8000Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomo
o`3oOol3Ool000Qoo`8000Yoo`8000Eoo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomo
o`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`0bOol2
01lQOol201n[Ool001]oo`03001oogoo039oo`807b5oo`807fQoo`807d5oo`006goo00<007ooOol0
_goo0P0O@Goo000KOol00`00Oomoo`3oOol3Ool001=oo`<000Eoo`03001oogoo0?moo`=oo`0057oo
00<007ooOol017oo00<007ooOol0ogoo0goo000DOol00`00Oomoo`04Ool3003oOol3Ool001Aoo`03
001oogoo0?moo`Yoo`0057oo00<007ooOol0ogoo2Woo000COol2003oOol<Ool00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {24.4346, -0.0764114, 
  0.0567121, 0.00624232}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Make one or more conjectures about the probability that a random element \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" has order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " (and thus will generate the whole group). You may wish to specialize, \
having your conjecture depend on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[". Consider the cells that follow.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Now let\[CloseCurlyQuote]s consider prime indices."], "Text",
  CellDingbat->None,
  CellMargins->{{12, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[n\  = \ Prime[j]; \n
        \t{n, \ N[
            Length[Select[OrderOfAllElements[Z[n]], \n\t
                  \((#[\([2]\)] == n)\)&]]/n]}, \ {j, \ 1, \ 20}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{2, 0.5`}, {3, 0.666666666666666607`}, {5, 0.8`}, {7, 
        0.857142857142857117`}, {11, 0.909090909090908994`}, {13, 
        0.923076923076923172`}, {17, 0.941176470588235325`}, {19, 
        0.947368421052631504`}, {23, 0.956521739130434767`}, {29, 
        0.96551724137931032`}, {31, 0.967741935483870996`}, {37, 
        0.972972972972972982`}, {41, 0.975609756097560953`}, {43, 
        0.976744186046511586`}, {47, 0.978723404255319096`}, {53, 
        0.981132075471698072`}, {59, 0.983050847457627163`}, {61, 
        0.983606557377049206`}, {67, 0.985074626865671554`}, {71, 
        0.985915492957746408`}}\)], "Output",
  Editable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0134138 0 0.618034 [
[.15795 -0.0125 -6 -9 ]
[.15795 -0.0125 6 0 ]
[.29209 -0.0125 -6 -9 ]
[.29209 -0.0125 6 0 ]
[.42622 -0.0125 -6 -9 ]
[.42622 -0.0125 6 0 ]
[.56036 -0.0125 -6 -9 ]
[.56036 -0.0125 6 0 ]
[.6945 -0.0125 -6 -9 ]
[.6945 -0.0125 6 0 ]
[.82864 -0.0125 -6 -9 ]
[.82864 -0.0125 6 0 ]
[.96278 -0.0125 -6 -9 ]
[.96278 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15795 0 m
.15795 .00625 L
s
[(10)] .15795 -0.0125 0 1 Mshowa
.29209 0 m
.29209 .00625 L
s
[(20)] .29209 -0.0125 0 1 Mshowa
.42622 0 m
.42622 .00625 L
s
[(30)] .42622 -0.0125 0 1 Mshowa
.56036 0 m
.56036 .00625 L
s
[(40)] .56036 -0.0125 0 1 Mshowa
.6945 0 m
.6945 .00625 L
s
[(50)] .6945 -0.0125 0 1 Mshowa
.82864 0 m
.82864 .00625 L
s
[(60)] .82864 -0.0125 0 1 Mshowa
.96278 0 m
.96278 .00625 L
s
[(70)] .96278 -0.0125 0 1 Mshowa
.125 Mabswid
.05064 0 m
.05064 .00375 L
s
.07746 0 m
.07746 .00375 L
s
.10429 0 m
.10429 .00375 L
s
.13112 0 m
.13112 .00375 L
s
.18478 0 m
.18478 .00375 L
s
.2116 0 m
.2116 .00375 L
s
.23843 0 m
.23843 .00375 L
s
.26526 0 m
.26526 .00375 L
s
.31891 0 m
.31891 .00375 L
s
.34574 0 m
.34574 .00375 L
s
.37257 0 m
.37257 .00375 L
s
.3994 0 m
.3994 .00375 L
s
.45305 0 m
.45305 .00375 L
s
.47988 0 m
.47988 .00375 L
s
.50671 0 m
.50671 .00375 L
s
.53353 0 m
.53353 .00375 L
s
.58719 0 m
.58719 .00375 L
s
.61402 0 m
.61402 .00375 L
s
.64085 0 m
.64085 .00375 L
s
.66767 0 m
.66767 .00375 L
s
.72133 0 m
.72133 .00375 L
s
.74816 0 m
.74816 .00375 L
s
.77498 0 m
.77498 .00375 L
s
.80181 0 m
.80181 .00375 L
s
.85547 0 m
.85547 .00375 L
s
.88229 0 m
.88229 .00375 L
s
.90912 0 m
.90912 .00375 L
s
.93595 0 m
.93595 .00375 L
s
.9896 0 m
.9896 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.05064 .30902 Mdot
.06405 .41202 Mdot
.09088 .49443 Mdot
.11771 .52974 Mdot
.17136 .56185 Mdot
.19819 .57049 Mdot
.25184 .58168 Mdot
.27867 .58551 Mdot
.33233 .59116 Mdot
.41281 .59672 Mdot
.43964 .5981 Mdot
.52012 .60133 Mdot
.57378 .60296 Mdot
.6006 .60366 Mdot
.65426 .60488 Mdot
.73474 .60637 Mdot
.81522 .60756 Mdot
.84205 .6079 Mdot
.92254 .60881 Mdot
.97619 .60933 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool003Uoo`<000Aoo`8001Yoo`@000=oo`8001Uoo`<000Aoo`8001]oo`<000=oo`8001Yoo`<000Ao
o`8001]oo`8000Aoo`8001Yoo`03001oogoo00=oo`8000ioo`00>Woo00<007ooOol00Woo00@007oo
Ool001Yoo`03001oogoo009oo`04001oogoo000KOol01000Oomoo`000Woo00<007ooOol06Goo00D0
07ooOomoo`00009oo`03001oogoo01Yoo`04001oogoo0002Ool00`00Oomoo`0GOol01000Oomoo`00
0Woo00@007ooOol001Uoo`03001oogoo009oo`04001oogoo000=Ool003Yoo`03001oogoo009oo`04
001oogoo000KOol01@00Oomoogoo00000Woo00<007ooOol06Goo00@007ooOol0009oo`03001oogoo
01Moo`@0009oo`04001oogoo000LOol01000Oomoo`000Woo00<007ooOol05goo00@007ooOol0009o
o`04001oogoo000JOol01@00Oomoogoo00000Woo00<007ooOol02goo000jOol00`00Oomoo`02Ool0
1000Oomoo`0077oo00@007ooOol0009oo`03001oogoo01Moo`8000=oo`04001oogoo000IOol00`00
Ool00003Ool01000Oomoo`006Goo0`000goo00@007ooOol001Uoo`<000=oo`04001oogoo000JOol0
1@00Oomoogoo00000Woo00<007ooOol02goo000jOol00`00Oomoo`02Ool01000Oomoo`006Goo00@0
07ooOol0009oo`04001oogoo000KOol01000Oomoo`000Woo00<007ooOol05goo00<007oo00000goo
00@007ooOol001Uoo`03001oogoo00=oo`04001oogoo000IOol00`00Oomoo`03Ool01000Oomoo`00
6goo00@007ooOol0009oo`03001oogoo00]oo`00>Goo0P001Goo0P006goo0P0017oo0P006Goo0`00
17oo0P006goo0P0017oo0P006Woo10000goo0P006goo0`000goo0P006Goo10000goo0P003Woo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Eoool000D000Moo`006goo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol00goo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol00goo00<007ooOol017oo
00<007ooOol027oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool000Qoo`8000Aoo`8000=oo`@000Aoo`03001oogoo0?moo`=oo`001goo00@0
07ooOol000=oo`8000Aoo`03001oogoo00Aoo`03001oogoo0?moo`=oo`001goo00@007ooOol000Yo
o`03001oogoo00=oo`<00?moo`=oo`001goo00@007ooOol000]oo`03001oogoo009oo`03001oogoo
0?moo`=oo`001goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`3oOol3Ool000Qoo`80
00Yoo`8000Eoo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`80
0?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool000Qoo`8000Aoo`80
00Aoo`<000Aoo`03001oogoo0?moo`=oo`001goo00@007ooOol000=oo`8000Eoo`03001oogoo00=o
o`03001oogoo0?moo`=oo`001goo00@007ooOol000Qoo`@000Aoo`<00?moo`=oo`001goo00@007oo
Ool000Qoo`03001oo`0000Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000Qoo`03001oo`00
00Eoo`03001oogoo0?moo`=oo`0027oo0P002Woo0P001Goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol017oo0P0Oo7oo000KOol20005Ool2
01olOol001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`0027oo0P0017oo0P0017oo0P001Goo00<007ooOol0ogoo0goo0007
Ool01000Oomoo`000goo0P000goo00@007ooOol000Aoo`03001oogoo0?moo`=oo`001goo00@007oo
Ool000Qoo`04001oogoo0004Ool3003oOol3Ool000Moo`04001oogoo0008Ool30005Ool00`00Oomo
o`3oOol3Ool000Moo`04001oogoo0008Ool00`00Oomoo`05Ool00`00Oomoo`3oOol3Ool000Qoo`80
00Yoo`<000Aoo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol01goo0P0OnGoo000KOol00`00Oomoo`07Ool2
01oiOol001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool000Qoo`80
00Aoo`8000Aoo`8000Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000=oo`8000=oo`04001o
ogoo0004Ool00`00Oomoo`0>Ool201obOol000Moo`04001oogoo0008Ool01000Oomoo`0017oo0`00
3Woo0P0OlWoo0007Ool01000Oomoo`002Goo0P001Goo00<007ooOol0ogoo0goo0007Ool01000Oomo
o`0027oo00@007ooOol000Aoo`03001oogoo0?moo`=oo`0027oo0P002Woo0P001Goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol05Goo0P0O
jgoo000KOol00`00Oomoo`0EOol201o[Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo02=oo`807meoo`006goo00<007ooOol08goo
0P0OgGoo000KOol00`00Oomoo`0ZOol201oFOol001]oo`03001oogoo02Yoo`807mIoo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`0hOol201o8Ool001]oo`03001oogoo03Qoo`807`Eoo`80
7l5oo`006goo0P00@7oo0P0O`Goo000KOol00`00Oomoo`1=Ool201ncOol001]oo`03001oogoo04eo
o`807a9oo`807`Eoo`807iQoo`006goo00<007ooOol0HGoo0P0O1Goo0P0O4goo0P0OPgoo000KOol0
0`00Oomoo`1mOol201l<Ool201l5Ool201l<Ool201lCOol201m;Ool001]oo`03001oogoo08]oo`80
7`Eoo`807`aoo`807a=oo`807a=oo`807`Eoo`807a=oo`807`]oo`807`eoo`004goo0`001Goo00<0
07ooOol0bWoo0P0O1Goo0P0O4goo0P0O2goo0P0O3Goo000DOol00`00Oomoo`04Ool00`00Oomoo`3o
Ool3Ool001Aoo`03001oogoo00Aoo`<00?moo`=oo`0057oo00<007ooOol0ogoo2Woo000DOol00`00
Oomoo`3oOol:Ool001=oo`800?moo`aoo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-7.93916, -0.0764114, 
  0.287612, 0.00624232}}]
}, Closed]],

Cell["How about looking at indices that are squares?", "Text",
  CellDingbat->None,
  CellMargins->{{12, 10}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[n\  = \ j\^2; \n
        \t{n, \ N[
            Length[Select[OrderOfAllElements[Z[n]], \n\t
                  \((#[\([2]\)] == n)\)&]]/n]}, \ {j, \ 2, \ 13}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{4, 0.5`}, {9, 0.666666666666666607`}, {16, 0.5`}, {25, 0.8`}, {36, 
        0.333333333333333303`}, {49, 0.857142857142857117`}, {64, 0.5`}, {81, 
        0.666666666666666607`}, {100, 0.4`}, {121, 0.909090909090908994`}, {
        144, 0.333333333333333303`}, {169, 0.923076923076923172`}}\)], 
  "Output",
  Editable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00563539 0 0.618034 [
[.16469 -0.0125 -6 -9 ]
[.16469 -0.0125 6 0 ]
[.30558 -0.0125 -6 -9 ]
[.30558 -0.0125 6 0 ]
[.44646 -0.0125 -6 -9 ]
[.44646 -0.0125 6 0 ]
[.58735 -0.0125 -9 -9 ]
[.58735 -0.0125 9 0 ]
[.72823 -0.0125 -9 -9 ]
[.72823 -0.0125 9 0 ]
[.86912 -0.0125 -9 -9 ]
[.86912 -0.0125 9 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16469 0 m
.16469 .00625 L
s
[(25)] .16469 -0.0125 0 1 Mshowa
.30558 0 m
.30558 .00625 L
s
[(50)] .30558 -0.0125 0 1 Mshowa
.44646 0 m
.44646 .00625 L
s
[(75)] .44646 -0.0125 0 1 Mshowa
.58735 0 m
.58735 .00625 L
s
[(100)] .58735 -0.0125 0 1 Mshowa
.72823 0 m
.72823 .00625 L
s
[(125)] .72823 -0.0125 0 1 Mshowa
.86912 0 m
.86912 .00625 L
s
[(150)] .86912 -0.0125 0 1 Mshowa
.125 Mabswid
.05199 0 m
.05199 .00375 L
s
.08016 0 m
.08016 .00375 L
s
.10834 0 m
.10834 .00375 L
s
.13652 0 m
.13652 .00375 L
s
.19287 0 m
.19287 .00375 L
s
.22105 0 m
.22105 .00375 L
s
.24923 0 m
.24923 .00375 L
s
.2774 0 m
.2774 .00375 L
s
.33376 0 m
.33376 .00375 L
s
.36193 0 m
.36193 .00375 L
s
.39011 0 m
.39011 .00375 L
s
.41829 0 m
.41829 .00375 L
s
.47464 0 m
.47464 .00375 L
s
.50282 0 m
.50282 .00375 L
s
.53099 0 m
.53099 .00375 L
s
.55917 0 m
.55917 .00375 L
s
.61553 0 m
.61553 .00375 L
s
.6437 0 m
.6437 .00375 L
s
.67188 0 m
.67188 .00375 L
s
.70006 0 m
.70006 .00375 L
s
.75641 0 m
.75641 .00375 L
s
.78459 0 m
.78459 .00375 L
s
.81276 0 m
.81276 .00375 L
s
.84094 0 m
.84094 .00375 L
s
.8973 0 m
.8973 .00375 L
s
.92547 0 m
.92547 .00375 L
s
.95365 0 m
.95365 .00375 L
s
.98183 0 m
.98183 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.04635 .30902 Mdot
.07453 .41202 Mdot
.11398 .30902 Mdot
.16469 .49443 Mdot
.22668 .20601 Mdot
.29994 .52974 Mdot
.38447 .30902 Mdot
.48028 .41202 Mdot
.58735 .24721 Mdot
.70569 .56185 Mdot
.83531 .20601 Mdot
.97619 .57049 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool003]oo`@0009oo`<001]oo`<000Aoo`8001eoo`03001oogoo009oo`<001Qoo`<000Aoo`8000Ao
o`8001Ioo`<000=oo`@0009oo`<001Eoo`<000=oo`<000Aoo`8002=oo`00?7oo00<007ooOol01Goo
00<007ooOol06goo00@007ooOol0009oo`03001oogoo01Yoo`03001oogoo00Eoo`03001oogoo01Io
o`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`005Woo00<007ooOol00goo00<007ooOol0
1Goo00<007ooOol04goo00<007ooOol01Goo00@007ooOol0009oo`03001oogoo021oo`00?Goo00<0
07ooOol017oo00<007ooOol06goo00@007ooOol0009oo`03001oogoo01]oo`03001oogoo00Aoo`03
001oogoo01Ioo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`005Woo00<007ooOol017oo
00<007ooOol017oo00<007ooOol04goo00<007ooOol01Goo00@007ooOol0009oo`03001oogoo021o
o`00?Woo00<007ooOol00`006goo0`000goo00@007ooOol001eoo`04001oogooOol3000IOol00`00
Oomoo`02Ool01000Oomoo`000Woo00@007ooOol001Ioo`03001oogoo00Eoo`03001oogoo00<001Io
o`03001oogoo009oo`<000=oo`04001oogoo000ROol003]oo`04001oogoo0002Ool00`00Oomoo`0K
Ool00`00Oomoo`03Ool01000Oomoo`007Woo00@007ooOol001]oo`03001oogoo009oo`04001oogoo
0002Ool01000Oomoo`005Woo00<007ooOol00Woo00@007ooOol0009oo`03001oogoo01Ioo`03001o
ogoo009oo`03001oogoo00=oo`04001oogoo000ROol003aoo`8000=oo`@001Yoo`@000=oo`8001ao
o`@0009oo`@001Moo`8000Eoo`8000Aoo`8001Ioo`8000Eoo`8000=oo`@001Aoo`8000Aoo`@000=o
o`8002=oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000EOooo00050007Ool001]oo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Yoo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00
6goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
0008Ool20004Ool20003Ool40004Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0003Ool20004
Ool00`00Oomoo`04Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo000:Ool00`00Oomoo`03Ool3
003oOol3Ool000Moo`04001oogoo000;Ool00`00Oomoo`02Ool00`00Oomoo`3oOol3Ool000Moo`04
001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0ogoo0goo0008Ool2000:Ool20005Ool00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`0aOol201nL
Ool201laOol001]oo`03001oogoo035oo`807iaoo`807c5oo`006goo00<007ooOol0ogoo0goo000K
Ool2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo0008Ool20004
Ool20004Ool30004Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0003Ool20005Ool00`00Oomo
o`03Ool00`00Oomoo`2?Ool201maOol000Moo`04001oogoo0008Ool40004Ool3002?Ool201maOol0
00Moo`04001oogoo0008Ool00`00Ool00005Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0008
Ool00`00Ool00005Ool00`00Oomoo`3oOol3Ool000Qoo`8000Yoo`8000Eoo`03001oogoo0?moo`=o
o`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=o
o`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo
00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo
00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo009oo`807a1oo`80
7dAoo`807jIoo`006goo0P000goo0P0O47oo0P0OA7oo0P0OYWoo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool000Qoo`80
00Aoo`8000Aoo`8000Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000=oo`8000=oo`04001o
ogoo0004Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo0`00ogoo
0goo0007Ool01000Oomoo`0027oo0`001Goo00<007ooOol0ogoo0goo0007Ool01000Oomoo`0027oo
00<007ooOol01Goo00<007ooOol0ogoo0goo0008Ool2000:Ool30004Ool00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03
001oogoo00Yoo`807fMoo`807heoo`006goo00<007ooOol02Woo0P0OIgoo0P0OSGoo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo0008Ool20004Ool20004Ool20005
Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0003Ool20003Ool01000Oomoo`0017oo00<007oo
Ool08Goo0P0Oggoo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`<0025oo`807mmoo`001goo
00@007ooOol000Uoo`8000Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000Qoo`04001oogoo
0004Ool00`00Oomoo`3oOol3Ool000Qoo`8000Yoo`8000Eoo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo04Aoo`807kaoo`006goo00<007oo
Ool0A7oo0P0O_7oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00
ogoo17oo000KOol00`00Oomoo`2]Ool201mCOol001]oo`03001oogoo0:eoo`807e=oo`006goo00<0
07ooOol0lgoo0P0O3Goo000KOol00`00Oomoo`3cOol201l=Ool001]oo`03001oogoo0?moo`=oo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001=oo`<000Eoo`03001oogoo0?moo`=oo`00
57oo00<007ooOol017oo00<007ooOol0ogoo0goo000DOol00`00Oomoo`04Ool3003oOol3Ool001Ao
o`03001oogoo0?moo`Yoo`0057oo00<007ooOol0ogoo2Woo000COol2003oOol<Ool00?moob5oo`00
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-18.8974, -0.0764114, 
  0.684596, 0.00624232}}]
}, Closed]],

Cell["Or powers of two?", "Text",
  CellDingbat->None,
  CellMargins->{{12, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[n\  = \ 2\^j; \n
        \t{n, \ N[
            Length[Select[OrderOfAllElements[Z[n]], \n\t
                  \((#[\([2]\)] == n)\)&]]/n]}, \ {j, \ 1, \ 6}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{2, 0.5`}, {4, 0.5`}, {8, 0.5`}, {16, 0.5`}, {32, 0.5`}, {64, 0.5`}}
      \)], "Output",
  Editable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00691244 0.015361 0 0.618034 [
[.1467 -0.0125 -6 -9 ]
[.1467 -0.0125 6 0 ]
[.30031 -0.0125 -6 -9 ]
[.30031 -0.0125 6 0 ]
[.45392 -0.0125 -6 -9 ]
[.45392 -0.0125 6 0 ]
[.60753 -0.0125 -6 -9 ]
[.60753 -0.0125 6 0 ]
[.76114 -0.0125 -6 -9 ]
[.76114 -0.0125 6 0 ]
[.91475 -0.0125 -6 -9 ]
[.91475 -0.0125 6 0 ]
[-0.01941 .12361 -18 -4.5 ]
[-0.01941 .12361 0 4.5 ]
[-0.01941 .24721 -18 -4.5 ]
[-0.01941 .24721 0 4.5 ]
[-0.01941 .37082 -18 -4.5 ]
[-0.01941 .37082 0 4.5 ]
[-0.01941 .49443 -18 -4.5 ]
[-0.01941 .49443 0 4.5 ]
[-0.01941 .61803 -6 -4.5 ]
[-0.01941 .61803 0 4.5 ]
[ -0.00691 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1467 0 m
.1467 .00625 L
s
[(10)] .1467 -0.0125 0 1 Mshowa
.30031 0 m
.30031 .00625 L
s
[(20)] .30031 -0.0125 0 1 Mshowa
.45392 0 m
.45392 .00625 L
s
[(30)] .45392 -0.0125 0 1 Mshowa
.60753 0 m
.60753 .00625 L
s
[(40)] .60753 -0.0125 0 1 Mshowa
.76114 0 m
.76114 .00625 L
s
[(50)] .76114 -0.0125 0 1 Mshowa
.91475 0 m
.91475 .00625 L
s
[(60)] .91475 -0.0125 0 1 Mshowa
.125 Mabswid
.02381 0 m
.02381 .00375 L
s
.05453 0 m
.05453 .00375 L
s
.08525 0 m
.08525 .00375 L
s
.11598 0 m
.11598 .00375 L
s
.17742 0 m
.17742 .00375 L
s
.20814 0 m
.20814 .00375 L
s
.23886 0 m
.23886 .00375 L
s
.26959 0 m
.26959 .00375 L
s
.33103 0 m
.33103 .00375 L
s
.36175 0 m
.36175 .00375 L
s
.39247 0 m
.39247 .00375 L
s
.4232 0 m
.4232 .00375 L
s
.48464 0 m
.48464 .00375 L
s
.51536 0 m
.51536 .00375 L
s
.54608 0 m
.54608 .00375 L
s
.5768 0 m
.5768 .00375 L
s
.63825 0 m
.63825 .00375 L
s
.66897 0 m
.66897 .00375 L
s
.69969 0 m
.69969 .00375 L
s
.73041 0 m
.73041 .00375 L
s
.79186 0 m
.79186 .00375 L
s
.82258 0 m
.82258 .00375 L
s
.8533 0 m
.8533 .00375 L
s
.88402 0 m
.88402 .00375 L
s
.94547 0 m
.94547 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
-0.00691 .12361 m
-0.00066 .12361 L
s
[(0.2)] -0.01941 .12361 1 0 Mshowa
-0.00691 .24721 m
-0.00066 .24721 L
s
[(0.4)] -0.01941 .24721 1 0 Mshowa
-0.00691 .37082 m
-0.00066 .37082 L
s
[(0.6)] -0.01941 .37082 1 0 Mshowa
-0.00691 .49443 m
-0.00066 .49443 L
s
[(0.8)] -0.01941 .49443 1 0 Mshowa
-0.00691 .61803 m
-0.00066 .61803 L
s
[(1)] -0.01941 .61803 1 0 Mshowa
.125 Mabswid
-0.00691 .0309 m
-0.00316 .0309 L
s
-0.00691 .0618 m
-0.00316 .0618 L
s
-0.00691 .09271 m
-0.00316 .09271 L
s
-0.00691 .15451 m
-0.00316 .15451 L
s
-0.00691 .18541 m
-0.00316 .18541 L
s
-0.00691 .21631 m
-0.00316 .21631 L
s
-0.00691 .27812 m
-0.00316 .27812 L
s
-0.00691 .30902 m
-0.00316 .30902 L
s
-0.00691 .33992 m
-0.00316 .33992 L
s
-0.00691 .40172 m
-0.00316 .40172 L
s
-0.00691 .43262 m
-0.00316 .43262 L
s
-0.00691 .46353 m
-0.00316 .46353 L
s
-0.00691 .52533 m
-0.00316 .52533 L
s
-0.00691 .55623 m
-0.00316 .55623 L
s
-0.00691 .58713 m
-0.00316 .58713 L
s
.25 Mabswid
-0.00691 0 m
-0.00691 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.02381 .30902 Mdot
.05453 .30902 Mdot
.11598 .30902 Mdot
.23886 .30902 Mdot
.48464 .30902 Mdot
.97619 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool003Yoo`<000Aoo`8001moo`@000=oo`8001moo`<000Aoo`8001moo`<000=oo`8001moo`<000Ao
o`80021oo`8000Aoo`8001Ioo`00>goo00<007ooOol00Woo00@007ooOol001moo`03001oogoo009o
o`04001oogoo000QOol01000Oomoo`000Woo00<007ooOol07Goo00D007ooOomoo`00009oo`03001o
ogoo01moo`04001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001Eoo`00
>goo00<007ooOol00Woo00@007ooOol0021oo`05001oogooOol00002Ool00`00Oomoo`0OOol01000
Oomoo`000Woo00<007ooOol06goo10000Woo00@007ooOol0025oo`04001oogoo0002Ool00`00Oomo
o`0LOol01000Oomoo`000Woo00@007ooOol001Eoo`00>goo00<007ooOol00Woo00@007ooOol0025o
o`04001oogoo0002Ool00`00Oomoo`0MOol20003Ool01000Oomoo`007Goo00<007oo00000goo00@0
07ooOol001ioo`<000=oo`04001oogoo000NOol30003Ool01000Oomoo`005Goo000kOol00`00Oomo
o`02Ool01000Oomoo`007Woo00@007ooOol0009oo`04001oogoo000QOol01000Oomoo`000Woo00<0
07ooOol06goo00<007oo00000goo00@007ooOol001ioo`03001oogoo00=oo`04001oogoo000NOol0
0`00Oomoo`03Ool01000Oomoo`005Goo000jOol20005Ool2000POol20004Ool2000OOol30004Ool2
000OOol20004Ool2000OOol40003Ool2000POol30003Ool2000FOol00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`005goo00<007oo0000o`0010000goo000GOol00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`07Ool001Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000G
Ool00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000G
Ool00`00Oomoo`3oOol7Ool001Moo`800?moo`Qoo`005goo00<007ooOol0ogoo1goo000GOol00`00
Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00
Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol2003o
Ool8Ool001Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3o
Ool7Ool001Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3o
Ool7Ool001Moo`03001oogoo0?moo`Moo`005goo0P00ogoo27oo000GOol00`00Oomoo`3oOol7Ool0
01Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool0
01Moo`03001oogoo0?moo`Moo`0017oo0P0017oo0P000goo100017oo00<007ooOol0ogoo1goo0003
Ool01000Oomoo`000goo0P0017oo00<007ooOol017oo00<007ooOol0ogoo1goo0003Ool01000Oomo
o`002Woo00<007ooOol00goo0`00ogoo1goo0003Ool01000Oomoo`002goo00<007ooOol00Woo00<0
07ooOol0ogoo1goo0003Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo0?moo`Moo`00
17oo0P002Woo0P001Goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001o
ogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`800?mo
o`Qoo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?mo
o`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?mo
o`Moo`005goo00<007ooOol0ogoo1goo000GOol2003oOol8Ool001Moo`03001oogoo0?moo`Moo`00
5goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`00
5goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`00
5goo0P00ogoo27oo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`005goo00<0
07ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`0017oo0P00
17oo0P0017oo0`0017oo00<007ooOol0ogoo1goo0003Ool01000Oomoo`000goo0P001Goo00<007oo
Ool00goo00<007ooOol0ogoo1goo0003Ool01000Oomoo`0027oo100017oo0`00ogoo1goo0003Ool0
1000Oomoo`0027oo00<007oo00001Goo00<007ooOol0ogoo1goo0003Ool01000Oomoo`0027oo00<0
07oo00001Goo00<007ooOol0ogoo1goo0004Ool2000:Ool20005Ool00`00Oomoo`3oOol7Ool001Mo
o`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Mo
o`03001oogoo0?moo`Moo`005goo0P00ogoo27oo000GOol00`00Oomoo`3oOol7Ool001Moo`03001o
ogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001o
ogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`05Ool201l6Ool201l=Ool2
01lNOol201lnOol201mmOol201l9Ool001Moo`8000Ioo`807`Ioo`807`eoo`807aioo`807cioo`80
7geoo`807`Uoo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001o
ogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001o
ogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol2003oOol8Ool001Moo`03001oogoo0?mo
o`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?mo
o`Moo`005goo00<007ooOol0ogoo1goo0004Ool20004Ool20004Ool20005Ool00`00Oomoo`3oOol7
Ool000=oo`04001oogoo0003Ool20003Ool01000Oomoo`0017oo00<007ooOol0ogoo1goo0003Ool0
1000Oomoo`0027oo00@007ooOol000Aoo`<00?moo`Moo`000goo00@007ooOol000Qoo`<000Eoo`03
001oogoo0?moo`Moo`000goo00@007ooOol000Qoo`03001oogoo00Eoo`03001oogoo0?moo`Moo`00
17oo0P002Woo0`0017oo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001o
ogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`800?mo
o`Qoo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?mo
o`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?mo
o`Moo`005goo00<007ooOol0ogoo1goo000GOol2003oOol8Ool001Moo`03001oogoo0?moo`Moo`00
5goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`00
5goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`00
5goo0P00ogoo27oo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`005goo00<0
07ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Moo`0017oo0P00
17oo0P0017oo0P001Goo00<007ooOol0ogoo1goo0003Ool01000Oomoo`000goo0P000goo00@007oo
Ool000Aoo`03001oogoo0?moo`Moo`000goo00@007ooOol000Qoo`04001oogoo0004Ool3003oOol7
Ool000=oo`04001oogoo0009Ool20005Ool00`00Oomoo`3oOol7Ool000=oo`04001oogoo0008Ool0
1000Oomoo`0017oo00<007ooOol0ogoo1goo0004Ool2000:Ool20005Ool00`00Oomoo`3oOol7Ool0
01Moo`03001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool0
01Moo`03001oogoo0?moo`Moo`005goo0P00ogoo27oo000GOol00`00Oomoo`3oOol7Ool001Moo`03
001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03
001oogoo0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`80
0?moo`Qoo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo
0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo
0?moo`Moo`005goo00<007ooOol0ogoo1goo000GOol2003oOol8Ool001Moo`03001oogoo0?moo`Mo
o`005goo00<007ooOol0ogoo1goo000GOol00`00Oomoo`3oOol7Ool001Moo`03001oogoo0?moo`Mo
o`005goo00<007ooOol0ogoo1goo000?Ool30005Ool00`00Oomoo`3oOol7Ool0011oo`03001oogoo
00Aoo`03001oogoo0?moo`Moo`0047oo00<007ooOol017oo0`00ogoo1goo000@Ool00`00Oomoo`3o
Ool>Ool0011oo`03001oogoo0?moo`ioo`003goo0P00ogoo47oo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-5.93271, -0.0764114, 
  0.251153, 0.00624232}}]
}, Closed]],

Cell["Or multiples of two?", "Text",
  CellDingbat->None,
  CellMargins->{{12, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[n\  = \ 2  j; \n
        \t{n, \ N[
            Length[Select[OrderOfAllElements[Z[n]], \n\t
                  \((#[\([2]\)] == n)\)&]]/n]}, \ {j, \ 1, \ 25}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{2, 0.5`}, {4, 0.5`}, {6, 0.333333333333333303`}, {8, 0.5`}, {10, 
        0.4`}, {12, 0.333333333333333303`}, {14, 0.428571428571428558`}, {16, 
        0.5`}, {18, 0.333333333333333303`}, {20, 0.4`}, {22, 
        0.454545454545454497`}, {24, 0.333333333333333303`}, {26, 
        0.461538461538461586`}, {28, 0.428571428571428558`}, {30, 
        0.266666666666666651`}, {32, 0.5`}, {34, 0.470588235294117662`}, {36, 
        0.333333333333333303`}, {38, 0.473684210526315752`}, {40, 0.4`}, {42, 
        0.285714285714285676`}, {44, 0.454545454545454497`}, {46, 
        0.478260869565217383`}, {48, 0.333333333333333303`}, {50, 0.4`}}\)], 
  "Output",
  Editable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0190476 0 0.618034 [
[.21429 -0.0125 -6 -9 ]
[.21429 -0.0125 6 0 ]
[.40476 -0.0125 -6 -9 ]
[.40476 -0.0125 6 0 ]
[.59524 -0.0125 -6 -9 ]
[.59524 -0.0125 6 0 ]
[.78571 -0.0125 -6 -9 ]
[.78571 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
[(10)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(20)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(30)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(40)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(50)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.0619 0 m
.0619 .00375 L
s
.1 0 m
.1 .00375 L
s
.1381 0 m
.1381 .00375 L
s
.17619 0 m
.17619 .00375 L
s
.25238 0 m
.25238 .00375 L
s
.29048 0 m
.29048 .00375 L
s
.32857 0 m
.32857 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.44286 0 m
.44286 .00375 L
s
.48095 0 m
.48095 .00375 L
s
.51905 0 m
.51905 .00375 L
s
.55714 0 m
.55714 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.67143 0 m
.67143 .00375 L
s
.70952 0 m
.70952 .00375 L
s
.74762 0 m
.74762 .00375 L
s
.82381 0 m
.82381 .00375 L
s
.8619 0 m
.8619 .00375 L
s
.9 0 m
.9 .00375 L
s
.9381 0 m
.9381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.0619 .30902 Mdot
.1 .30902 Mdot
.1381 .20601 Mdot
.17619 .30902 Mdot
.21429 .24721 Mdot
.25238 .20601 Mdot
.29048 .26487 Mdot
.32857 .30902 Mdot
.36667 .20601 Mdot
.40476 .24721 Mdot
.44286 .28092 Mdot
.48095 .20601 Mdot
.51905 .28525 Mdot
.55714 .26487 Mdot
.59524 .16481 Mdot
.63333 .30902 Mdot
.67143 .29084 Mdot
.70952 .20601 Mdot
.74762 .29275 Mdot
.78571 .24721 Mdot
.82381 .17658 Mdot
.8619 .28092 Mdot
.9 .29558 Mdot
.9381 .20601 Mdot
.97619 .24721 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool004Moo`<000Aoo`8002Uoo`@000=oo`8002Qoo`<000Aoo`8002Yoo`<000=oo`8002Qoo`<000Ao
o`8000Yoo`00B7oo00<007ooOol00Woo00@007ooOol002Uoo`03001oogoo009oo`04001oogoo000Z
Ool01000Oomoo`000Woo00<007ooOol0:7oo00D007ooOomoo`00009oo`03001oogoo02Qoo`04001o
ogoo0002Ool00`00Oomoo`07Ool004Qoo`03001oogoo009oo`04001oogoo000ZOol01@00Oomoogoo
00000Woo00<007ooOol0:7oo00@007ooOol0009oo`03001oogoo02Ioo`@0009oo`04001oogoo000Z
Ool01000Oomoo`000Woo00<007ooOol01goo0018Ool00`00Oomoo`02Ool01000Oomoo`00:goo00@0
07ooOol0009oo`03001oogoo02Ioo`8000=oo`04001oogoo000XOol00`00Ool00003Ool01000Oomo
o`009goo0`000goo00@007ooOol000Uoo`00B7oo00<007ooOol00Woo00@007ooOol002Qoo`04001o
ogoo0002Ool01000Oomoo`00:Woo00@007ooOol0009oo`03001oogoo02Ioo`03001oo`0000=oo`04
001oogoo000WOol00`00Oomoo`03Ool01000Oomoo`002Goo0017Ool20005Ool2000ZOol20004Ool2
000XOol30004Ool2000ZOol20004Ool2000XOol40003Ool2000:Ool00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`005Gooo`001@001goo000KOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool001]oo`03001oogoo0?mo
o`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?mo
o`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00
6goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00
6goo00<007ooOol0ogoo0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00
ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`0027oo0P0017oo0P00
0goo100017oo00<007ooOol0ogoo0goo0007Ool01000Oomoo`000goo0P0017oo00<007ooOol017oo
00<007ooOol0ogoo0goo0007Ool01000Oomoo`002Woo00<007ooOol00goo0`00ogoo0goo0007Ool0
1000Oomoo`002goo00<007ooOol00Woo00<007ooOol0ogoo0goo0007Ool01000Oomoo`0027oo00@0
07ooOol000Aoo`03001oogoo0?moo`=oo`0027oo0P002Woo0P001Goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`2AOol201m_Ool001]oo`03001oogoo095oo`807fmoo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3<Ool201ldOol001]oo`03001oogoo0<aoo`807cAoo`006goo00<007ooOol0ogoo
0goo000KOol2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol06Woo0P0O77oo
0P0O6goo0P0O77oo0P0O>Goo0P0O>Woo0P0O5Woo000KOol00`00Oomoo`0JOol201lLOol201lKOol2
01lLOol201liOol201ljOol201lFOol001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`0027oo0P0017oo0P0017oo0`0017oo
00<007ooOol0ogoo0goo0007Ool01000Oomoo`000goo0P001Goo00<007ooOol00goo00<007ooOol0
;Woo0P0O;goo0P0OHGoo0P0O;goo0P0O3Goo0007Ool01000Oomoo`0027oo100017oo0`00;Woo0P0O
;goo0P0OHGoo0P0O;goo0P0O3Goo0007Ool01000Oomoo`0027oo00<007oo00001Goo00<007ooOol0
ogoo0goo0007Ool01000Oomoo`0027oo00<007oo00001Goo00<007ooOol0ogoo0goo0008Ool2000:
Ool20005Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo049oo`807d=oo`807gUoo`006goo00<0
07ooOol0@Woo0P0O@goo0P0ONGoo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=o
o`006goo0P00JWoo0P0OJgoo0P0O:Woo000KOol00`00Oomoo`1YOol201lBOol201mGOol201lZOol0
01]oo`03001oogoo07eoo`807h=oo`006goo00<007ooOol0Y7oo0P0O4Woo0P0OB7oo000KOol00`00
Oomoo`2TOol201lBOol201lVOol201lPOol001]oo`03001oogoo0>1oo`807b1oo`006goo00<007oo
Ool0ogoo0goo000KOol00`00Oomoo`06Ool201l8Ool201lBOol201lVOol201m=Ool201mUOol001]o
o`8000Moo`807`Qoo`807a9oo`807bIoo`807deoo`807fEoo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool2003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo0008Ool20004
Ool20004Ool20005Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0003Ool20003Ool01000Oomo
o`0017oo00<007ooOol0ogoo0goo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`<00?moo`=o
o`001goo00@007ooOol000Qoo`<000Eoo`03001oogoo0?moo`=oo`001goo00@007ooOol000Qoo`03
001oogoo00Eoo`03001oogoo0?moo`=oo`0027oo0P002Woo0`0017oo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000K
Ool00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00
Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2003o
Ool4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3o
Ool3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`0027oo0P0017oo0P0017oo0P001Goo00<007ooOol0ogoo0goo0007
Ool01000Oomoo`000goo0P000goo00@007ooOol000Aoo`03001oogoo0?moo`=oo`001goo00@007oo
Ool000Qoo`04001oogoo0004Ool3003oOol3Ool000Moo`04001oogoo0009Ool20005Ool00`00Oomo
o`3oOol3Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0ogoo0goo0008Ool2
000:Ool20005Ool00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol2
003oOol4Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomo
o`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000COol30005Ool0
0`00Oomoo`3oOol3Ool001Aoo`03001oogoo00Aoo`03001oogoo0?moo`=oo`0057oo00<007ooOol0
17oo0`00ogoo0goo000DOol00`00Oomoo`3oOol:Ool001Aoo`03001oogoo0?moo`Yoo`004goo0P00
ogoo37oo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-5.59096, -0.0764114, 
  0.202543, 0.00624232}}]
}, Closed]],

Cell["Or powers of three?", "Text",
  CellDingbat->None,
  CellMargins->{{12, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(percents\  = \ 
      Table[n\  = \ 3^j; \n
        \t{n, \ N[
            Length[Select[OrderOfAllElements[Z[n]], \n\t
                  \((#[\([2]\)] == n)\)&]]/n]}, \ {j, \ 1, \ 4}]\), 
    \(\(ListPlot[percents, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    \({{3, 0.666666666666666607`}, {9, 0.666666666666666607`}, {27, 
        0.666666666666666607`}, {81, 0.666666666666666607`}}\)], "Output",
  Editable->False,
  Deletable->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0128205 0.01221 0 0.618034 [
[.23138 -0.0125 -6 -9 ]
[.23138 -0.0125 6 0 ]
[.47558 -0.0125 -6 -9 ]
[.47558 -0.0125 6 0 ]
[.71978 -0.0125 -6 -9 ]
[.71978 -0.0125 6 0 ]
[.96398 -0.0125 -6 -9 ]
[.96398 -0.0125 6 0 ]
[-0.02532 .12361 -18 -4.5 ]
[-0.02532 .12361 0 4.5 ]
[-0.02532 .24721 -18 -4.5 ]
[-0.02532 .24721 0 4.5 ]
[-0.02532 .37082 -18 -4.5 ]
[-0.02532 .37082 0 4.5 ]
[-0.02532 .49443 -18 -4.5 ]
[-0.02532 .49443 0 4.5 ]
[-0.02532 .61803 -6 -4.5 ]
[-0.02532 .61803 0 4.5 ]
[ -0.01282 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23138 0 m
.23138 .00625 L
s
[(20)] .23138 -0.0125 0 1 Mshowa
.47558 0 m
.47558 .00625 L
s
[(40)] .47558 -0.0125 0 1 Mshowa
.71978 0 m
.71978 .00625 L
s
[(60)] .71978 -0.0125 0 1 Mshowa
.96398 0 m
.96398 .00625 L
s
[(80)] .96398 -0.0125 0 1 Mshowa
.125 Mabswid
.29243 0 m
.29243 .00375 L
s
.35348 0 m
.35348 .00375 L
s
.41453 0 m
.41453 .00375 L
s
.53663 0 m
.53663 .00375 L
s
.59768 0 m
.59768 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.78083 0 m
.78083 .00375 L
s
.84188 0 m
.84188 .00375 L
s
.90293 0 m
.90293 .00375 L
s
.17033 0 m
.17033 .00375 L
s
.10928 0 m
.10928 .00375 L
s
.04823 0 m
.04823 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
-0.01282 .12361 m
-0.00657 .12361 L
s
[(0.2)] -0.02532 .12361 1 0 Mshowa
-0.01282 .24721 m
-0.00657 .24721 L
s
[(0.4)] -0.02532 .24721 1 0 Mshowa
-0.01282 .37082 m
-0.00657 .37082 L
s
[(0.6)] -0.02532 .37082 1 0 Mshowa
-0.01282 .49443 m
-0.00657 .49443 L
s
[(0.8)] -0.02532 .49443 1 0 Mshowa
-0.01282 .61803 m
-0.00657 .61803 L
s
[(1)] -0.02532 .61803 1 0 Mshowa
.125 Mabswid
-0.01282 .0309 m
-0.00907 .0309 L
s
-0.01282 .0618 m
-0.00907 .0618 L
s
-0.01282 .09271 m
-0.00907 .09271 L
s
-0.01282 .15451 m
-0.00907 .15451 L
s
-0.01282 .18541 m
-0.00907 .18541 L
s
-0.01282 .21631 m
-0.00907 .21631 L
s
-0.01282 .27812 m
-0.00907 .27812 L
s
-0.01282 .30902 m
-0.00907 .30902 L
s
-0.01282 .33992 m
-0.00907 .33992 L
s
-0.01282 .40172 m
-0.00907 .40172 L
s
-0.01282 .43262 m
-0.00907 .43262 L
s
-0.01282 .46353 m
-0.00907 .46353 L
s
-0.01282 .52533 m
-0.00907 .52533 L
s
-0.01282 .55623 m
-0.00907 .55623 L
s
-0.01282 .58713 m
-0.00907 .58713 L
s
.25 Mabswid
-0.01282 0 m
-0.01282 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.008 w
.02381 .41202 Mdot
.09707 .41202 Mdot
.31685 .41202 Mdot
.97619 .41202 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool0055oo`@000=oo`8003Moo`<000=oo`8003Moo`8000Aoo`8003Qoo`8000Aoo`8000Qoo`00DWoo
00<007ooOol00Woo00@007ooOol003Moo`05001oogooOol00002Ool00`00Oomoo`0cOol01000Oomo
o`000Woo00@007ooOol003Ioo`04001oogoo0002Ool01000Oomoo`001goo001COol01@00Oomoogoo
00000Woo00<007ooOol0<goo10000Woo00@007ooOol003Eoo`04001oogoo0002Ool01000Oomoo`00
=Woo00@007ooOol0009oo`04001oogoo0007Ool005Aoo`04001oogoo0002Ool00`00Oomoo`0cOol0
0`00Ool00003Ool01000Oomoo`00=Goo0`000goo00@007ooOol003Moo`8000=oo`04001oogoo0007
Ool0055oo`04001oogoo0002Ool01000Oomoo`00=Goo00<007oo00000goo00@007ooOol003Eoo`03
001oogoo00=oo`04001oogoo000fOol01000Oomoo`000Woo00@007ooOol000Moo`00DWoo0P0017oo
0P00=goo0P0017oo0P00=goo0`000goo0P00>7oo0P0017oo0P0027oo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol001Ioo`04001oogooOooo00050002Ool001Ioo`03001oogoo00eoo`03001o
ogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00eoo`03001o
ogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00aoo`03001o
ogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03001o
ogoo00Uoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo
0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo
0?moo`Qoo`005Woo0P00ogoo2Goo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qo
o`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qo
o`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`800?moo`Uoo`005Woo
00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo
00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo
00<007ooOol0ogoo27oo000FOol2003oOol9Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007oo
Ool0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007oo
Ool0ogoo27oo0003Ool20004Ool20003Ool40004Ool00`00Oomoo`3oOol8Ool0009oo`04001oogoo
0003Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`3oOol8Ool0009oo`04001oogoo000:Ool00`00
Oomoo`03Ool3003oOol8Ool0009oo`04001oogoo000;Ool00`00Oomoo`02Ool00`00Oomoo`3oOol8
Ool0009oo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0ogoo27oo0003Ool2000:Ool2
0005Ool00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo
000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo0P00ogoo2Goo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`800?moo`Uoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomo
o`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomo
o`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol2003oOol9
Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8
Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo0003Ool20004Ool20004Ool3
0004Ool00`00Oomoo`3oOol8Ool0009oo`04001oogoo0003Ool20005Ool00`00Oomoo`03Ool00`00
Oomoo`3oOol8Ool0009oo`04001oogoo0008Ool40004Ool3003oOol8Ool0009oo`04001oogoo0008
Ool00`00Ool00005Ool00`00Oomoo`3oOol8Ool0009oo`04001oogoo0008Ool00`00Ool00005Ool0
0`00Oomoo`3oOol8Ool000=oo`8000Yoo`8000Eoo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0
ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0
ogoo27oo000FOol2003oOol9Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo
000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo
000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo0P00ogoo2Goo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`800?moo`Uoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomo
o`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomo
o`3oOol8Ool000=oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo0?moo`Qoo`000Woo00@007ooOol0
00=oo`8000=oo`04001oogoo0004Ool00`00Oomoo`3oOol8Ool0009oo`04001oogoo0008Ool01000
Oomoo`0017oo0`00ogoo27oo0002Ool01000Oomoo`0027oo0`001Goo00<007ooOol0ogoo27oo0002
Ool01000Oomoo`0027oo00<007ooOol01Goo00<007ooOol0ogoo27oo0003Ool2000:Ool30004Ool0
0`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol0
0`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo0P00ogoo2Goo000FOol00`00Oomo
o`3oOol8Ool001Ioo`03001oogoo00Ioo`807a5oo`807cMoo`807jUoo`807`Qoo`005Woo00<007oo
Ool01Woo0P0O4Goo0P0O=goo0P0OZGoo0P0O27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001o
ogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`800?mo
o`Uoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?mo
o`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?mo
o`Qoo`005Woo00<007ooOol0ogoo27oo000FOol2003oOol9Ool001Ioo`03001oogoo0?moo`Qoo`00
5Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo0?moo`Qoo`00
5Woo00<007ooOol0ogoo27oo0003Ool20004Ool20004Ool20005Ool00`00Oomoo`3oOol8Ool0009o
o`04001oogoo0003Ool20003Ool01000Oomoo`0017oo00<007ooOol0ogoo27oo0002Ool01000Oomo
o`0027oo00@007ooOol000Aoo`<00?moo`Qoo`000Woo00@007ooOol000Uoo`8000Eoo`03001oogoo
0?moo`Qoo`000Woo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`3oOol8Ool000=oo`80
00Yoo`8000Eoo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3o
Ool8Ool001Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol2003oOol9Ool0
01Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool0
01Ioo`03001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool0
01Ioo`03001oogoo0?moo`Qoo`005Woo0P00ogoo2Goo000FOol00`00Oomoo`3oOol8Ool001Ioo`03
001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03
001oogoo0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`80
0?moo`Uoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool001Ioo`03001oogoo
0?moo`Qoo`005Woo00<007ooOol0ogoo27oo000FOol00`00Oomoo`3oOol8Ool000ioo`<000Eoo`03
001oogoo0?moo`Qoo`003goo00<007ooOol017oo00<007ooOol0ogoo27oo000?Ool00`00Oomoo`04
Ool3003oOol8Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo000>Ool2003o
OolAOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-7.22189, -0.0764114, 
  0.315968, 0.00624232}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Do you wish to change any of your conjectures? Can you prove any of \
them?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.7 More questions about ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.12.4"],

Cell[TextData[{
  StyleBox["What is the order of the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[", as a function of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["? Below is a list of the orders ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\( | U\_n | \)\)],
    ShowShortBoxForm->False],
  StyleBox[" for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" from 1 to 60, followed by a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ListPlot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" of the same orders.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  ShowShortBoxForm->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(data = Table[Size[U[n]], {n, 1, 60}]\), 
    \(\(ListPlot[data]; \)\)}], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why does the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ListPlot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " seem to be limited to the lower triangle of the rectangle? What values \
are making the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[OpenCurlyDoubleQuote]",
  StyleBox["diagonal?\[CloseCurlyDoubleQuote]",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s now change the form of what we observe. Instead of \
simply making a list of the orders, we divide the order of the group by the \
index ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and then plot these values."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(data = MapIndexed[#1\/First[#2]&, data]\), 
    \(\(ListPlot[data, AxesOrigin \[Rule] {0, 0}, PlotRange \[Rule] {0, 1}]; 
    \)\)}], "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does this look at all familiar? Have you seen this before?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s continue our investigation into the order of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " by considering various types of integers ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". For example, when ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is prime we get"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(data1\  = \ 
      Table[n\  = \ Prime[p]; \n\t{n, \ Size[U[n]]}, \ {p, \ 1, \ 40}]\), 
    \(data2\  = \ 
      Table[n\  = \ Prime[p]; \n\t{n, \ Size[U[n]]/n}, \ {p, \ 1, \ 40}]; \n
    Show[GraphicsArray[{
          ListPlot[data1, DisplayFunction\  \[Rule] \n\tIdentity, \ 
            Ticks\  \[Rule] \ {Table[50  i, {i, \ 1, \ 4}], \ Automatic}], \ 
          \n\tListPlot[data2, \ DisplayFunction\  \[Rule] \n\tIdentity, \ 
            PlotRange\  \[Rule] \ {0, \ 1}, \n\t
            Ticks\  \[Rule] 
              \ {Table[50  i, \ {i, \ 1, \ 4}], \ Automatic}]}], \ \n\t
      DisplayFunction\  \[Rule] \ $DisplayFunction]; \)}], "Input",
  CellDingbat->None],

Cell[TextData[{
  "The first plot reflects the orders of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " for prime ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " (horizontal axis is ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and vertical is ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(| U\)\_n | \)\)],
    ShowShortBoxForm->False],
  "). The second plot has the vertical axis being ",
  Cell[BoxData[
      \(TraditionalForm\`\( | U\_n\/n | \)\)],
    ShowShortBoxForm->False],
  " (again, for prime ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "). We use just the latter type of plot in what follows."
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is a power of two we get"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(max\  = \ 8; \n
    data1\  = \ 
      Table[n\  = \ 2\^p; \n\t{n, \ Size[U[n]]}, \ {p, \ 1, \ max}]\), 
    \(data2\  = \ 
      Table[n\  = \ 2^p; \n\t{n, \ Size[U[n]]/n}, \ {p, \ 1, \ max}]\), 
    \(\(ListPlot[data2, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->None],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is a power of three we get"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(max\  = \ 8; \n
    data1\  = \ 
      Table[n\  = \ 3\^p; \n\t{n, \ Size[U[n]]}, \ {p, \ 1, \ max}]\), 
    \(data2\  = \ 
      Table[n\  = \ 3^p; \n\t{n, \ Size[U[n]]/n}, \ {p, \ 1, \ max}]\), 
    \(\(ListPlot[data2, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->None],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". The following code shows similar results for powers of 4. Evaluate it. \
Then change it to powers of 5, 6, 7, 8, 9, and so on until you can make some \
kind of conjecture. Can you prove it? (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["max",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is the number of terms to compute; you may wish to reduce ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["max",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to 5 for larger values.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(powersOf\  = \ 4; \nmax\  = \ 6; \n
    data1\  = \ 
      Table[n\  = \ powersOf\^p; \n\t{n, \ Size[U[n]]}, \ {p, \ 1, \ max}]
        \), 
    \(data2\  = \ 
      Table[n\  = \ powersOf\^p; \n\t{n, \ Size[U[n]]/n}, \ {p, \ 1, \ max}]
        \), 
    \(\(ListPlot[data2, \ PlotRange\  \[Rule] \ {0, \ 1}, \ 
      AxesOrigin\  \[Rule] \ {0, \ 0}]; \)\)}], "Input",
  CellDingbat->None],

Cell[TextData[StyleBox["Now consider multiples of three.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(data1\  = \ 
      Table[n\  = \ 3  p; \n\t{n, \ Size[U[n]]}, \ {p, \ 1, \ 40}]\), 
    \(data2\  = \ 
      Table[n\  = \ 3  p; \n\t{n, \ Size[U[n]]/n}, \ {p, \ 1, \ 40}]; \n
    Show[GraphicsArray[{
          ListPlot[data1, \ DisplayFunction\  \[Rule] \n\tIdentity, \ 
            PlotStyle\  \[Rule] 
              \ {RGBColor[0, \ 0, \ 1], \ PointSize[0.025]}], \n\t
          ListPlot[data2, \ DisplayFunction\  \[Rule] \ Identity, \ 
            AxesOrigin\  \[Rule] \n\t{0, \ 0}, \ 
            PlotRange\  \[Rule] \ {0, \ 1}, \ 
            PlotStyle\  \[Rule] 
              \ {RGBColor[0, \ 0, \ 1], \n\tPointSize[0.025]}]}], \ 
      DisplayFunction\  \[Rule] \ $DisplayFunction]; \)}], "Input",
  CellDingbat->None],

Cell["\<\
If the graphs appear a little small, click on the graph, then move \
the mouse to the lower right corner. When the cursor is a double arrow \
(facing NW and SE), then press down and drag to an appropriate size.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Can you see any dichotomy in the immediately preceding graphs? Describe \
it and try to explain why it exists. Look at the data used to generate the \
plots. (In particular, consider factoring some of the indices.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try multiples of two."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(multiplesOf\  = \ 2; \nmax\  = \ 60; \n
    data1\  = \ 
      Table[n\  = \ multiplesOf*p; \n\t{n, \ Size[U[n]]}, \ {p, \ 1, \ max}]
        \), 
    \(data2\  = \ 
      Table[n\  = \ multiplesOf*p; \n\t{n, \ Size[U[n]]/n}, 
        \ {p, \ 1, \ max}]; \n
    Show[GraphicsArray[{
          ListPlot[data1, \ DisplayFunction\  \[Rule] \n\tIdentity, \ 
            PlotStyle\  \[Rule] \ {RGBColor[0, \ 0, \ 1], PointSize[0.025]}], 
          \n\tListPlot[data2, \ DisplayFunction\  \[Rule] \ Identity, \ 
            AxesOrigin\  \[Rule] \n\t{0, 0}, \ 
            PlotRange\  \[Rule] \ {0, \ 1}, \ 
            PlotStyle\  \[Rule] 
              \ {RGBColor[0, \ 0, \ 1], \n\tPointSize[0.025]}]}], \ 
      DisplayFunction\  \[Rule] \ $DisplayFunction]; \)}], "Input",
  CellDingbat->None],

Cell[TextData[{
  StyleBox["Q20",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Change ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["multiplesOf",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to 5, 6, 7, 8, 9, and so on until you can make some kind of conjecture. \
(Again, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["max",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " indicates the number of terms that are calculated; you may wish to modify \
it.) Can you provide any proof? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q21",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox["? Give as complete an answer as possible, even if you don",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t have all the cases covered.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.8 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.13.4"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?ShowOne", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?ColumnForm", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Operation", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?ElementToPower", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Table", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Order", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?GroupInverse", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?TableForm", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Random", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?RandomElement", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Z", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?ShowGroupOrders", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?CollectOrders", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Orders", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?OrderOfAllElements", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Length ", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?N\)\)], "Input",
  CellDingbat->None],

Cell["?ListPlot", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Apply", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?Size", "Input",
  CellDingbat->None,
  AspectRatioFixed->True],

Cell["?U", "Input",
  CellDingbat->None,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{623, 425},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 4 Let's get these orders straight", FontSlant -> "Italic"], 
          "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->14],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Margins"->{1, 1},
    "Widths"->{0, 5}},
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellFrame->True,
    CellMargins->{{12, Inherited}, {20, 10}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    TextAlignment->Center,
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Times",
    FontSize->24,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1],
    Background->GrayLevel[1]],
  
  Cell[StyleData["Title", "Presentation"],
    CellFrame->True,
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    Background->GrayLevel[1]],
  
  Cell[StyleData["Title", "Condensed"],
    CellFrame->True,
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20,
    Background->GrayLevel[1]],
  
  Cell[StyleData["Title", "Printout"],
    CellFrame->False,
    CellMargins->{{2, 10}, {15, 30}},
    CellBracketOptions->{"Color"->RGBColor[0, 0, 1]},
    FontColor->GrayLevel[0]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {10, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    TextAlignment->Center,
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Times",
    FontSize->24,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {15, 20}},
    TextAlignment->Center,
    LineSpacing->{1, 0},
    FontFamily->"Times",
    FontSize->36,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    TextAlignment->Center,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    TextAlignment->Center,
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {10, 20}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    TextAlignment->Center,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Times",
    FontSize->24,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {10, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 12}},
    FontSize->20],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[GraySquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Times",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellDingbat->"\[GraySquare]",
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontFamily->"Times",
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellDingbat->"\[GraySquare]",
    CellMargins->{{18, Inherited}, {6, 12}},
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellDingbat->"\[GraySquare]",
    CellMargins->{{13, 0}, {7, 22}},
    FontFamily->"Times",
    FontSize->14]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellDingbat->None,
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    FontSize->14],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    LineSpacing->{1, 2},
    FontSize->10]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"SmallText",
    FontFamily->"Times",
    FontSize->10],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontFamily->"Times",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    FontFamily->"Times",
    FontSize->10]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["unique styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Question"],
    Deletable->False,
    CellFrame->True,
    CellMargins->{{12, 10}, {6, 6}},
    Evaluatable->False,
    LineSpacing->{1, 3},
    FontFamily->"Times",
    FontSize->14,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Question", "Presentation"],
    CellFrame->True,
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Question", "Condensed"],
    CellFrame->True,
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->12],
  
  Cell[StyleData["Question", "Printout"],
    CellFrame->True,
    CellMargins->{{2, 2}, {3, 3}},
    LineSpacing->{1, 2},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Answer"],
    Deletable->True,
    CellFrame->True,
    CellMargins->{{12, 10}, {6, 6}},
    Evaluatable->False,
    LineSpacing->{1, 3},
    FontFamily->"Times",
    FontSize->14,
    FontColor->RGBColor[0, 0, 1],
    Background->GrayLevel[0.8]],
  
  Cell[StyleData["Answer", "Presentation"],
    CellFrame->True,
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->16,
    Background->GrayLevel[0.800015]],
  
  Cell[StyleData["Answer", "Condensed"],
    CellFrame->True,
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->12,
    Background->GrayLevel[0.800015]],
  
  Cell[StyleData["Answer", "Printout"],
    CellFrame->True,
    CellMargins->{{2, 2}, {5, 5}},
    FontSize->12,
    Background->GrayLevel[1]]
  }, Open  ]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellDingbat->"\[WatchIcon]",
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Open  ]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None,
    FontSize->14],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageSize->{175, 175},
    ImageMargins->{{38, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageSize->{250, 250},
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    FontSize->14],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    ScriptLevel->0,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SelectionPlaceholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True],
  
  Cell[StyleData["SelectionPlaceholder", "Presentation"]],
  
  Cell[StyleData["SelectionPlaceholder", "Condensed"]],
  
  Cell[StyleData["SelectionPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{1, -5},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@`l`=0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:4.4"->{
    Cell[2382, 76, 203, 8, 99, "Title",
      Evaluatable->False,
      CellTags->"a:4.4"]},
  "a:4.5.4"->{
    Cell[2610, 88, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.5.4"]},
  "a:4.6.4"->{
    Cell[7133, 241, 107, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.6.4"]},
  "a:4.7.4"->{
    Cell[8791, 305, 99, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.7.4"]},
  "a:4.8.4"->{
    Cell[10026, 344, 189, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.8.4"]},
  "a:4.9.4"->{
    Cell[27999, 1040, 283, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.9.4"]},
  "a:4.10.4"->{
    Cell[32918, 1200, 117, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.10.4"]},
  "a:4.11.4"->{
    Cell[42272, 1537, 403, 15, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.11.4"]},
  "a:4.12.4"->{
    Cell[131753, 4454, 183, 7, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.12.4"]},
  "a:4.13.4"->{
    Cell[143173, 4845, 309, 12, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.13.4"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:4.4", 172576, 5945},
  {"a:4.5.4", 172684, 5949},
  {"a:4.6.4", 172797, 5953},
  {"a:4.7.4", 172910, 5957},
  {"a:4.8.4", 173022, 5961},
  {"a:4.9.4", 173136, 5965},
  {"a:4.10.4", 173252, 5969},
  {"a:4.11.4", 173369, 5973},
  {"a:4.12.4", 173487, 5977},
  {"a:4.13.4", 173605, 5981}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 203, 8, 99, "Title",
  Evaluatable->False,
  CellTags->"a:4.4"],

Cell[CellGroupData[{
Cell[2610, 88, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.5.4"],
Cell[2936, 101, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3813, 126, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5209, 169, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5387, 175, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6035, 198, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6753, 225, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7133, 241, 107, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.6.4"],
Cell[7243, 246, 1511, 54, 90, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8791, 305, 99, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.7.4"],
Cell[8893, 310, 1096, 29, 128, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10026, 344, 189, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.8.4"],
Cell[10218, 354, 1007, 35, 52, "Text",
  Evaluatable->False],
Cell[11228, 391, 1383, 48, 71, "Text",
  Evaluatable->False],
Cell[12614, 441, 925, 30, 71, "Text",
  Evaluatable->False],
Cell[13542, 473, 270, 7, 59, "Input",
  InitializationCell->True],
Cell[13815, 482, 112, 3, 43, "Input"],
Cell[13930, 487, 763, 28, 52, "Text",
  Evaluatable->False],
Cell[14696, 517, 592, 21, 52, "Text",
  Evaluatable->False],
Cell[15291, 540, 88, 3, 27, "Input"],
Cell[15382, 545, 905, 35, 33, "Text",
  Evaluatable->False],
Cell[16290, 582, 88, 3, 27, "Input"],
Cell[16381, 587, 766, 30, 33, "Text",
  Evaluatable->False],
Cell[17150, 619, 88, 3, 27, "Input"],
Cell[17241, 624, 808, 30, 67, "Question",
  Evaluatable->False],
Cell[18052, 656, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[18129, 660, 129, 3, 33, "Text",
  Evaluatable->False],
Cell[18261, 665, 102, 3, 27, "Input"],
Cell[18366, 670, 633, 23, 52, "Text",
  Evaluatable->False],
Cell[19002, 695, 103, 3, 27, "Input"],
Cell[19108, 700, 251, 8, 52, "Text",
  Evaluatable->False],
Cell[19362, 710, 121, 3, 27, "Input"],
Cell[19486, 715, 660, 25, 48, "Question",
  Evaluatable->False],
Cell[20149, 742, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20226, 746, 340, 6, 71, "Text",
  Evaluatable->False],
Cell[20569, 754, 91, 3, 27, "Input"],
Cell[20663, 759, 765, 27, 67, "Question",
  Evaluatable->False],
Cell[21431, 788, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21508, 792, 420, 7, 71, "Text",
  Evaluatable->False],
Cell[21931, 801, 105, 3, 27, "Input"],
Cell[22039, 806, 466, 17, 33, "Text",
  Evaluatable->False],
Cell[22508, 825, 94, 3, 27, "Input"],
Cell[22605, 830, 727, 26, 67, "Question",
  Evaluatable->False],
Cell[23335, 858, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23412, 862, 157, 4, 33, "Text",
  Evaluatable->False],
Cell[23572, 868, 102, 3, 27, "Input"],
Cell[23677, 873, 640, 23, 52, "Text",
  Evaluatable->False],
Cell[24320, 898, 91, 3, 27, "Input"],
Cell[24414, 903, 195, 7, 33, "Text",
  Evaluatable->False],
Cell[24612, 912, 105, 3, 27, "Input"],
Cell[24720, 917, 219, 8, 33, "Text",
  Evaluatable->False],
Cell[24942, 927, 94, 3, 27, "Input"],
Cell[25039, 932, 1245, 45, 86, "Question",
  Evaluatable->False],
Cell[26287, 979, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26364, 983, 354, 6, 71, "Text",
  Evaluatable->False],
Cell[26721, 991, 450, 10, 101, "Input"],
Cell[27174, 1003, 360, 12, 67, "Question",
  Evaluatable->False],
Cell[27537, 1017, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[27614, 1021, 271, 10, 48, "Question",
  Evaluatable->False],
Cell[27888, 1033, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[27999, 1040, 283, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.9.4"],
Cell[28285, 1050, 341, 11, 33, "Text",
  Evaluatable->False],
Cell[28629, 1063, 188, 5, 43, "Input"],
Cell[28820, 1070, 348, 9, 52, "Text",
  Evaluatable->False],
Cell[29171, 1081, 339, 7, 59, "Input"],
Cell[29513, 1090, 1377, 40, 71, "Text",
  Evaluatable->False],
Cell[30893, 1132, 601, 17, 52, "Text",
  Evaluatable->False],
Cell[31497, 1151, 404, 9, 91, "Input"],
Cell[31904, 1162, 309, 9, 52, "Text",
  Evaluatable->False],
Cell[32216, 1173, 588, 18, 67, "Question",
  Evaluatable->False],
Cell[32807, 1193, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[32918, 1200, 117, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.10.4"],
Cell[33038, 1205, 819, 22, 109, "Text",
  Evaluatable->False],
Cell[33860, 1229, 129, 4, 43, "Input"],
Cell[33992, 1235, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[34090, 1239, 107, 3, 27, "Input"],
Cell[34200, 1244, 340, 7, 71, "Text",
  Evaluatable->False],
Cell[34543, 1253, 818, 25, 90, "Text",
  Evaluatable->False],
Cell[35364, 1280, 393, 8, 71, "Text",
  Evaluatable->False],
Cell[35760, 1290, 157, 4, 33, "Text",
  Evaluatable->False],
Cell[35920, 1296, 164, 5, 59, "Input"],
Cell[36087, 1303, 154, 5, 33, "Text",
  Evaluatable->False],
Cell[36244, 1310, 1030, 35, 86, "Question",
  Evaluatable->False],
Cell[37277, 1347, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37354, 1351, 455, 15, 52, "Text",
  Evaluatable->False],
Cell[37812, 1368, 124, 3, 27, "Input"],
Cell[37939, 1373, 758, 27, 67, "Question",
  Evaluatable->False],
Cell[38700, 1402, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[38777, 1406, 792, 27, 52, "Text",
  Evaluatable->False],
Cell[39572, 1435, 156, 3, 43, "Input"],
Cell[39731, 1440, 808, 26, 90, "Text",
  Evaluatable->False],
Cell[40542, 1468, 652, 22, 67, "Question",
  Evaluatable->False],
Cell[41197, 1492, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41274, 1496, 884, 32, 67, "Question",
  Evaluatable->False],
Cell[42161, 1530, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[42272, 1537, 403, 15, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.11.4"],
Cell[42678, 1554, 385, 15, 33, "Text",
  Evaluatable->False],
Cell[43066, 1571, 130, 4, 43, "Input"],
Cell[43199, 1577, 361, 11, 52, "Text",
  Evaluatable->False],
Cell[43563, 1590, 648, 23, 52, "Text",
  Evaluatable->False],
Cell[44214, 1615, 65, 2, 27, "Input"],
Cell[44282, 1619, 98, 3, 27, "Input"],
Cell[44383, 1624, 308, 10, 33, "Text",
  Evaluatable->False],
Cell[44694, 1636, 167, 5, 27, "Input"],
Cell[44864, 1643, 352, 13, 33, "Text",
  Evaluatable->False],
Cell[45219, 1658, 106, 3, 27, "Input"],
Cell[45328, 1663, 112, 2, 33, "Text",
  Evaluatable->False],
Cell[45443, 1667, 93, 3, 42, "Input"],
Cell[45539, 1672, 400, 9, 71, "Text",
  Evaluatable->False],
Cell[45942, 1683, 326, 9, 124, "Input"],
Cell[46271, 1694, 517, 18, 52, "Text",
  Evaluatable->False],
Cell[46791, 1714, 199, 5, 59, "Input"],
Cell[46993, 1721, 786, 25, 90, "Text",
  Evaluatable->False],
Cell[47782, 1748, 308, 8, 75, "Input"],
Cell[48093, 1758, 340, 9, 59, "Input"],
Cell[48436, 1769, 578, 19, 86, "Question",
  Evaluatable->False],
Cell[49017, 1790, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[49094, 1794, 149, 4, 33, "Text",
  Evaluatable->False],
Cell[49246, 1800, 139, 4, 27, "Input"],
Cell[49388, 1806, 530, 14, 71, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[49943, 1824, 351, 8, 75, "Input"],
Cell[50297, 1834, 718, 12, 86, "Output"],
Cell[51018, 1848, 10238, 332, 186, 3352, 240, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[61271, 2183, 308, 12, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[61604, 2199, 353, 8, 75, "Input"],
Cell[61960, 2209, 527, 9, 71, "Output"],
Cell[62490, 2220, 10526, 339, 186, 3443, 246, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[73031, 2562, 967, 34, 84, "Question",
  Evaluatable->False],
Cell[74001, 2598, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[74078, 2602, 196, 4, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[74299, 2610, 367, 8, 75, "Input"],
Cell[74669, 2620, 695, 12, 86, "Output"],
Cell[75367, 2634, 11235, 373, 186, 3775, 275, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[86617, 3010, 182, 4, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[86824, 3018, 363, 8, 84, "Input"],
Cell[87190, 3028, 368, 7, 56, "Output"],
Cell[87561, 3037, 10829, 355, 186, 3498, 258, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[98405, 3395, 153, 4, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[98583, 3403, 362, 8, 84, "Input"],
Cell[98948, 3413, 149, 4, 26, "Output"],
Cell[99100, 3419, 10514, 339, 186, 3439, 246, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[109629, 3761, 156, 4, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[109810, 3769, 363, 8, 75, "Input"],
Cell[110176, 3779, 716, 12, 86, "Output"],
Cell[110895, 3793, 10402, 334, 186, 3371, 241, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[121312, 4130, 155, 4, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[121492, 4138, 361, 8, 75, "Input"],
Cell[121856, 4148, 196, 4, 26, "Output"],
Cell[122055, 4154, 9248, 276, 186, 2788, 190, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[131318, 4433, 321, 12, 46, "Question",
  Evaluatable->False],
Cell[131642, 4447, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[131753, 4454, 183, 7, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.12.4"],
Cell[131939, 4463, 985, 35, 52, "Text",
  Evaluatable->False],
Cell[132927, 4500, 149, 4, 43, "Input"],
Cell[133079, 4506, 649, 23, 67, "Question",
  Evaluatable->False],
Cell[133731, 4531, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[133808, 4535, 322, 9, 52, "Text",
  Evaluatable->False],
Cell[134133, 4546, 210, 5, 62, "Input"],
Cell[134346, 4553, 301, 10, 48, "Question",
  Evaluatable->False],
Cell[134650, 4565, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[134727, 4569, 391, 13, 52, "Text",
  Evaluatable->False],
Cell[135121, 4584, 690, 13, 171, "Input"],
Cell[135814, 4599, 731, 25, 73, "Text",
  Evaluatable->False],
Cell[136548, 4626, 164, 7, 33, "Text",
  Evaluatable->False],
Cell[136715, 4635, 356, 8, 107, "Input"],
Cell[137074, 4645, 166, 7, 33, "Text",
  Evaluatable->False],
Cell[137243, 4654, 356, 8, 107, "Input"],
Cell[137602, 4664, 853, 27, 105, "Question",
  Evaluatable->False],
Cell[138458, 4693, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[138535, 4697, 409, 10, 123, "Input"],
Cell[138947, 4709, 164, 4, 33, "Text",
  Evaluatable->False],
Cell[139114, 4715, 749, 15, 155, "Input"],
Cell[139866, 4732, 285, 7, 71, "Text",
  Evaluatable->False],
Cell[140154, 4741, 460, 13, 86, "Question",
  Evaluatable->False],
Cell[140617, 4756, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[140694, 4760, 118, 2, 33, "Text",
  Evaluatable->False],
Cell[140815, 4764, 812, 17, 187, "Input"],
Cell[141630, 4783, 788, 28, 86, "Question",
  Evaluatable->False],
Cell[142421, 4813, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[142498, 4817, 561, 19, 67, "Question",
  Evaluatable->False],
Cell[143062, 4838, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[143173, 4845, 309, 12, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.13.4"],
Cell[143485, 4859, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[143830, 4870, 72, 2, 27, "Input"],
Cell[143905, 4874, 75, 2, 27, "Input"],
Cell[143983, 4878, 74, 2, 27, "Input"],
Cell[144060, 4882, 79, 2, 27, "Input"],
Cell[144142, 4886, 70, 2, 27, "Input"],
Cell[144215, 4890, 70, 2, 27, "Input"],
Cell[144288, 4894, 77, 2, 27, "Input"],
Cell[144368, 4898, 74, 2, 27, "Input"],
Cell[144445, 4902, 71, 2, 27, "Input"],
Cell[144519, 4906, 78, 2, 27, "Input"],
Cell[144600, 4910, 66, 2, 27, "Input"],
Cell[144669, 4914, 80, 2, 27, "Input"],
Cell[144752, 4918, 78, 2, 27, "Input"],
Cell[144833, 4922, 71, 2, 27, "Input"],
Cell[144907, 4926, 83, 2, 27, "Input"],
Cell[144993, 4930, 72, 2, 27, "Input"],
Cell[145068, 4934, 60, 2, 27, "Input"],
Cell[145131, 4938, 73, 2, 27, "Input"],
Cell[145207, 4942, 70, 2, 27, "Input"],
Cell[145280, 4946, 69, 2, 27, "Input"],
Cell[145352, 4950, 66, 2, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

