(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38520,       1458]*)
(*NotebookOutlinePosition[     41509,       1555]*)
(*  CellTagsIndexPosition[     41218,       1542]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 12",
    FontSize->18],
  "\nNormality and Factor Groups"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.12"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.13.12"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.14.12"],

Cell["\<\
Before attempting this lab you should complete Group Lab 11 (on \
cosets). \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.15.12"],

Cell[TextData[{
  "After defining a ",
  StyleBox["normal",
    FontSlant->"Italic"],
  " subgroup, we try to make some sense of finding an operation to act on \
cosets. This leads to the development of the ",
  StyleBox["quotient",
    FontSlant->"Italic"],
  " or ",
  StyleBox["factor",
    FontSlant->"Italic"],
  " group. We conclude by illustrating why normality is important in \
constructing the factor group."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Normal subgroups"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.16.12"],

Cell[TextData[{
  StyleBox[
  "Suppose we start out, as we did in the last lab, with the dihedral group \
of order 8, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  StyleBox[". First we read in the code needed for this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Dihedral[4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now consider a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", say ",
  Cell[BoxData[
      \(TraditionalForm\`H = {1, Rot\^2}\)]],
  ", consisting of the identity and the 180\[Degree] rotation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(H = {1, Rot\^2}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "In Group Lab 11 we saw that on some occasions a left coset was the same as \
a right coset. Will this happen in this case? Following is a table consisting \
of a column of the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " followed by the elements in the left and right cosets of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " containing ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #]}&, \n\t
        Elements[G]], \ TableDepth\  \[Rule] \ 2, \ 
      TableHeadings\  \[Rule] \ {None, \ {"\<g\>", "\<gH\>", "\<Hg\n\>"}}]
      \)], "Input"],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Would you say that every left coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" is equal to the right coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox["? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Consider another example. Suppose we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = U\_40\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = U[40]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " be the subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]13\[RightAngleBracket]\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(H = SubgroupGenerated[G, 13]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s check out the left cosets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" and the right cosets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox[" (same ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox["). This time we will let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " do the checking of equality. (Note that we sort the two cosets before \
comparing for equality. Why is this done?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #], \ 
            Sort[LeftCoset[G, \ H, \ #]]\  === \ 
              Sort[RightCoset[G, \ H, \ #]]}&, \ Elements[G]], \ 
      TableDepth\  \[Rule] \ 2, \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<gH\>", \n"\<Hg\>", \ "\<= ?\n\>"}}]\)], 
  "Input"],

Cell[TextData[{
  StyleBox["We repeat this with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = S\_3\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`H = \[LeftAngleBracket]{1, 3, 2}\[RightAngleBracket]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = Symmetric[3]\), 
    \(H = SubgroupGenerated[G, {1, 3, 2}]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #], \ 
            Sort[LeftCoset[G, \ H, \ #]]\  === \ 
              Sort[RightCoset[G, \ H, \ #]]}&, \ Elements[G]], 
      TableDepth\  \[Rule] \ 2, \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<gH\>", \n"\<Hg\>", \ "\<= ?\n\>"}}]\)], 
  "Input"],

Cell[TextData[{
  StyleBox[
  "Here we note that four of the left cosets are not equal to their \
corresponding right cosets. So we have evidence that equality of left and \
right cosets is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a general property for all groups or subgroups. This leads to a \
definition: Given a subgroup ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" of a group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H = H\ g\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", we say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["normal",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[". We can use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NormalQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to test for normality of a subgroup.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NormalQ[H, G]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that if we change ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " to a different subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " we may obtain normality."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NormalQ[SubgroupGenerated[G, {2, 3, 1}], G]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Furthermore, note the ",
  StyleBox["index",
    FontSlant->"Italic"],
  " of this subgroup in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " (i.e., the number of cosets)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Index[G, SubgroupGenerated[G, {2, 3, 1}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "An exercise in group theory is to show that any subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " whose index in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is 2 will always be normal in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". Let\[CloseCurlyQuote]s try some other groups."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(NormalQ[{0, 4}, Z[8]]\), 
    \(NormalQ[SubgroupGenerated[U[52], 15], U[52]]\), 
    \(NormalQ[SubgroupGenerated[Dihedral[4], Ref], Dihedral[4]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  " is an Abelian group. What can you say about the normality of any subgroup \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["? Why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_5\[Cross]U\_6\)]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`H = \[LeftAngleBracket]\((2, 5)\)\[RightAngleBracket]\)]],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" normal in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["? Give an answer and justification and then check using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" (recalling that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DirectProduct",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is used to obtain the desired direct product).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Making a new group"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.17.12"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider the group ",
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_8\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`H = {0, 4}\)]],
  " and investigate the cosets that arise."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = Z[8]\), 
    \(H = {0, 4}\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider the following four cosets. (Recall that the coset ",
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  " is written ",
  Cell[BoxData[
      \(TraditionalForm\`g + H\)]],
  " when the group is written additively.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    RowBox[{\(0 + H\)}], \(1 + H\), \(2 + H\), 
    RowBox[{\(3 + H\), "\n", 
      RowBox[{
        StyleBox["(*",
          AspectRatioFixed->True], 
        StyleBox[" ",
          AspectRatioFixed->True], 
        RowBox[{
          RowBox[{
            StyleBox["if",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["you",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["think",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["Mathematica",
              AspectRatioFixed->True,
              FontSlant->"Italic"], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["knows",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["what",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["it",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["is",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["doing",
              AspectRatioFixed->True], 
            StyleBox[" ",
              AspectRatioFixed->True], 
            StyleBox["here",
              AspectRatioFixed->True]}], 
          StyleBox[",",
            AspectRatioFixed->True], 
          StyleBox["\n",
            AspectRatioFixed->True], 
          StyleBox[\(understanding\ cosets\),
            AspectRatioFixed->True], 
          StyleBox[",",
            AspectRatioFixed->True], 
          StyleBox[" ",
            AspectRatioFixed->True], 
          StyleBox[\(you\ are\ mistaken\  - \ try\ 5\  + \ H\),
            AspectRatioFixed->True]}], 
        StyleBox[" ",
          AspectRatioFixed->True], 
        StyleBox["*)",
          AspectRatioFixed->True]}]}]}], "Input"],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Why are these the only cosets considered? In other words, why aren",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "t both left cosets and right cosets considered? Additionally, what about \
the cosets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`4 + H\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`5 + H\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`6 + H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`7 + H\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Suppose we consider these four cosets and think about a way in which we \
might combine (operate on) any two of them. What might it mean to add two \
cosets, say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2 + H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3 + H\)]],
  StyleBox["? As alluded to, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" doesn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t really (yet) know how to add these cosets.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\((2\  + \ H)\)\), 
    \(\((3\  + \ H)\)\), 
    \(\((2\  + \ H)\)\  + \ \((3\  + \ H)\)\), 
    \(Mod[\((2\  + \ H)\)\  + \ \((3\  + \ H)\), \ 8]\)}], "Input"],

Cell[TextData[{
  "Even reducing these mod 8 is not right. What might it mean to \
\[OpenCurlyDoubleQuote]add\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      \(TraditionalForm\`{2, 6}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`{3, 7}\)]],
  "? Suppose we try all possible sums and then reduce mod 8."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({2 + 3, 2 + 7, 6 + 3, 6 + 7}\)], "Input",
  AspectRatioFixed->True],

Cell["Reduce mod 8:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Mod[%, 8]\)], "Input",
  AspectRatioFixed->True],

Cell["Finally, remove duplicates.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Union[%]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note that this is really ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`5 + H\)]],
  StyleBox[" (as well as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`1 + H\)]],
  StyleBox["). Note also that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2 + 3 = 5\)]],
  StyleBox[". Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2 + H\)]],
  StyleBox[" could have been written as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`6 + H\)]],
  StyleBox[
  ", one might wonder if interchanging them would affect how we \
\[OpenCurlyDoubleQuote]add\[CloseCurlyDoubleQuote] these cosets. As will \
likely be proved in your class, it does not.",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["In fact, given any group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and any normal subgroup ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", the set of all (left) cosets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{g\ N | g \[Element] G}\)]],
  StyleBox[" forms a group under the operation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((g\ N)\)\ \((h\ N)\) = \((g\ h)\) N\)]],
  StyleBox[" (shown multiplicatively here",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  StyleBox["additively it would be written ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\(\((g + N)\) + \((h + N)\) = \((g + h)\) + N)\)\)]],
  StyleBox[". This new group is called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["factor group",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[", or the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["quotient group",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". This is frequently denoted ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G/H\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(FactorGroup[G, H]\), 
    \(QuotientGroup[G, H]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?QuotientGroup\)\)], "Input"],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Try adding a few of these cosets (as elements of the factor group). On \
scratch paper, you may wish to make the Cayley table for the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G/H\)]],
  StyleBox[". To what group is this isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Factor groups"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.18.12"],

Cell[TextData[{
  StyleBox["Maybe you thought about making the Cayley table with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". (If not, why not?) Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s do so.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(G = Z[8]; \)\), 
    \(\(H = {0, 4}; \)\), 
    \(CayleyTable[QuotientGroup[G, H]]\)}], "Input",
  AspectRatioFixed->True],

Cell["Of course, there is also the pretty version.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(gr1 = 
      CayleyTable[QuotientGroup[G, H], Mode \[Rule] Visual, 
        Output \[Rule] Graphics]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Observe that the elements in the group table are the left cosets of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = {0, 4}\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  StyleBox[". Just as a reminder, here they are.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(LeftCosets[G, H]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". To what group is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8/{0, 4}\)]],
  " isomorphic?"
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Here is a visual way of seeing how these cosets interact with each \
other.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(gr2 = LeftCosets[G, H, Mode \[Rule] Visual, Output \[Rule] Graphics]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Putting these two graphics together, we obtain the following.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Show[GraphicsArray[{gr1, gr2}]]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What observations can you make from considering these two tables? \
Include an accounting of the coloring of both tables and the \
\[OpenCurlyDoubleQuote]blocking\[CloseCurlyDoubleQuote] (coloring by \
\[OpenCurlyDoubleQuote]chunks\[CloseCurlyDoubleQuote]) in the second table.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Recall that the subgroup ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`H = \[LeftAngleBracket]{1, 3, 2}\[RightAngleBracket]\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" normal in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NormalQ[SubgroupGenerated[S[3], {1, 3, 2}], S[3]]\)], "Input",
  AspectRatioFixed->True],

Cell["How do the left cosets interact in this case?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(LeftCosets[S[3], SubgroupGenerated[S[3], {1, 3, 2}], 
      Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Before we can form the factor group, the subgroup must be normal. What \
goes wrong when the subgroup is not normal? Consider the preceding \
visualization and answer this question. Focus, in particular, on the last \
four columns and try to determine why the coloration does not occur in square \
blocks there. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Give specific explanations for the coloring in the last four columns."
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Next we consider the same group and subgroup but focus on the right \
cosets.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RightCosets[S[3], SubgroupGenerated[S[3], {1, 3, 2}], 
      Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Explain why the last four rows occur as they do. Provide explicit \
details.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    FontWeight->"Bold"],
  ". Determine another subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of some group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " that is not normal in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". Define them below. Now consider the left and right cosets visually, \
using the cell below your definitions."
}], "Question"],

Cell["Answer: ", "Answer"],

Cell[BoxData[
    \(G\  = \ \ \n\(H\  = \ \ \nNormalQ[G, \ H]\)\)], "Input"],

Cell[BoxData[{
    \(LeftCosets[G, \ H, \ Mode\  \[Rule] \ Visual]\), 
    \(RightCosets[G, \ H, \ Mode\  \[Rule] \ Visual]\)}], "Input"],

Cell[TextData[
"Now let\[CloseCurlyQuote]s consider two more examples of normal subgroups \
and the corresponding products of cosets."], "Text"],

Cell[BoxData[{
    \(G\  = \ U[16]\), 
    \(H\  = \ SubgroupGenerated[G, \ 3]\), 
    \(NormalQ[H, \ G]\)}], "Input"],

Cell[BoxData[
    \(LeftCosets[G, \ H, \ Mode\  \[Rule] \ Visual]\)], "Input"],

Cell[BoxData[{
    \(G\  = \ Z[6]\), 
    \(H\  = \ {0, \ 3}\), 
    \(NormalQ[H, \ G]\)}], "Input"],

Cell[BoxData[
    \(LeftCosets[G, \ H, \ Mode\  \[Rule] \ Visual]\)], "Input"],

Cell[TextData[{
  StyleBox["Q11",
    FontWeight->"Bold"],
  ". For these normal subgroups, why did we only look at the visual \
representation of the left cosets (and not the right cosets)?"
}], "Question"],

Cell["Answer: ", "Answer"],

Cell[TextData[{
  StyleBox["Q12",
    FontWeight->"Bold"],
  ". Make a summary statement regarding why normality is a requirement for a \
quotient group to be a coherent, well-defined structure."
}], "Question"],

Cell["Answer: ", "Answer"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.19.12"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Dihedral", "Input",
  AspectRatioFixed->True],

Cell["?U", "Input",
  AspectRatioFixed->True],

Cell["?LeftCoset", "Input",
  AspectRatioFixed->True],

Cell["?RightCoset", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?SubgroupGenerated", "Input",
  AspectRatioFixed->True],

Cell["?Symmetric", "Input",
  AspectRatioFixed->True],

Cell["?NormalQ", "Input",
  AspectRatioFixed->True],

Cell["?Index", "Input",
  AspectRatioFixed->True],

Cell["?Z", "Input",
  AspectRatioFixed->True],

Cell["?Mod", "Input",
  AspectRatioFixed->True],

Cell["?Union", "Input",
  AspectRatioFixed->True],

Cell["?FactorGroup", "Input",
  AspectRatioFixed->True],

Cell["?QuotientGroup", "Input",
  AspectRatioFixed->True],

Cell["?CayleyTable", "Input",
  AspectRatioFixed->True],

Cell["?LeftCosets", "Input",
  AspectRatioFixed->True],

Cell["?Output", "Input",
  AspectRatioFixed->True],

Cell["?RightCosets", "Input",
  AspectRatioFixed->True],

Cell["?GraphicsArray", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{628, 429},
WindowMargins->{{2, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{3, 4},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 12 Normality and factor groups", FontSlant -> "Italic"], 
          "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:12.12"->{
    Cell[2382, 76, 179, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:12.12"]},
  "a:12.13.12"->{
    Cell[2586, 87, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.13.12"]},
  "a:12.14.12"->{
    Cell[7113, 240, 195, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.14.12"]},
  "a:12.15.12"->{
    Cell[7495, 260, 187, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:12.15.12"]},
  "a:12.16.12"->{
    Cell[8200, 290, 198, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:12.16.12"]},
  "a:12.17.12"->{
    Cell[19304, 718, 200, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.17.12"]},
  "a:12.18.12"->{
    Cell[29301, 1085, 195, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.18.12"]},
  "a:12.19.12"->{
    Cell[36722, 1372, 374, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.19.12"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:12.12", 40259, 1506},
  {"a:12.13.12", 40372, 1510},
  {"a:12.14.12", 40491, 1514},
  {"a:12.15.12", 40610, 1518},
  {"a:12.16.12", 40729, 1522},
  {"a:12.17.12", 40848, 1526},
  {"a:12.18.12", 40968, 1530},
  {"a:12.19.12", 41089, 1534}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 179, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:12.12"],

Cell[CellGroupData[{
Cell[2586, 87, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.13.12"],
Cell[2916, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3793, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5189, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5367, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6015, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6733, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7113, 240, 195, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.14.12"],
Cell[7311, 250, 147, 5, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7495, 260, 187, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:12.15.12"],
Cell[7685, 270, 478, 15, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8200, 290, 198, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:12.16.12"],
Cell[8401, 300, 399, 13, 52, "Text",
  Evaluatable->False],
Cell[8803, 315, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[8978, 321, 74, 2, 27, "Input"],
Cell[9055, 325, 294, 10, 33, "Text",
  Evaluatable->False],
Cell[9352, 337, 74, 2, 31, "Input"],
Cell[9429, 341, 559, 18, 71, "Text",
  Evaluatable->False],
Cell[9991, 361, 252, 5, 59, "Input"],
Cell[10246, 368, 562, 20, 48, "Question",
  Evaluatable->False],
Cell[10811, 390, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[10888, 394, 247, 9, 33, "Text",
  Evaluatable->False],
Cell[11138, 405, 68, 2, 27, "Input"],
Cell[11209, 409, 250, 10, 33, "Text",
  Evaluatable->False],
Cell[11462, 421, 87, 2, 27, "Input"],
Cell[11552, 425, 963, 34, 71, "Text",
  Evaluatable->False],
Cell[12518, 461, 368, 8, 91, "Input"],
Cell[12889, 471, 465, 17, 33, "Text",
  Evaluatable->False],
Cell[13357, 490, 123, 3, 43, "Input"],
Cell[13483, 495, 366, 8, 91, "Input"],
Cell[13852, 505, 1847, 67, 109, "Text",
  Evaluatable->False],
Cell[15702, 574, 72, 2, 27, "Input"],
Cell[15777, 578, 264, 10, 33, "Text",
  Evaluatable->False],
Cell[16044, 590, 102, 2, 27, "Input"],
Cell[16149, 594, 259, 10, 33, "Text",
  Evaluatable->False],
Cell[16411, 606, 100, 2, 27, "Input"],
Cell[16514, 610, 393, 13, 52, "Text",
  Evaluatable->False],
Cell[16910, 625, 205, 4, 59, "Input"],
Cell[17118, 631, 688, 27, 67, "Question",
  Evaluatable->False],
Cell[17809, 660, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[17886, 664, 1304, 45, 86, "Question",
  Evaluatable->False],
Cell[19193, 711, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[19304, 718, 200, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.17.12"],
Cell[19507, 728, 312, 10, 33, "Text",
  Evaluatable->False],
Cell[19822, 740, 90, 3, 43, "Input"],
Cell[19915, 745, 305, 10, 52, "Text",
  Evaluatable->False],
Cell[20223, 757, 2152, 64, 107, "Input"],
Cell[22378, 823, 982, 37, 67, "Question",
  Evaluatable->False],
Cell[23363, 862, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23440, 866, 883, 30, 71, "Text",
  Evaluatable->False],
Cell[24326, 898, 182, 4, 75, "Input"],
Cell[24511, 904, 375, 11, 52, "Text",
  Evaluatable->False],
Cell[24889, 917, 87, 2, 27, "Input"],
Cell[24979, 921, 77, 2, 33, "Text",
  Evaluatable->False],
Cell[25059, 925, 68, 2, 27, "Input"],
Cell[25130, 929, 91, 2, 33, "Text",
  Evaluatable->False],
Cell[25224, 933, 67, 2, 27, "Input"],
Cell[25294, 937, 3187, 112, 147, "Text",
  Evaluatable->False],
Cell[28484, 1051, 108, 3, 43, "Input"],
Cell[28595, 1056, 51, 1, 27, "Input"],
Cell[28649, 1059, 538, 17, 67, "Question",
  Evaluatable->False],
Cell[29190, 1078, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[29301, 1085, 195, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.18.12"],
Cell[29499, 1095, 491, 17, 52, "Text",
  Evaluatable->False],
Cell[29993, 1114, 145, 4, 59, "Input"],
Cell[30141, 1120, 108, 2, 33, "Text",
  Evaluatable->False],
Cell[30252, 1124, 165, 4, 43, "Input"],
Cell[30420, 1130, 519, 17, 52, "Text",
  Evaluatable->False],
Cell[30942, 1149, 75, 2, 27, "Input"],
Cell[31020, 1153, 357, 13, 48, "Question",
  Evaluatable->False],
Cell[31380, 1168, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[31457, 1172, 147, 5, 33, "Text",
  Evaluatable->False],
Cell[31607, 1179, 138, 3, 27, "Input"],
Cell[31748, 1184, 136, 5, 33, "Text",
  Evaluatable->False],
Cell[31887, 1191, 96, 2, 27, "Input"],
Cell[31986, 1195, 522, 14, 67, "Question",
  Evaluatable->False],
Cell[32511, 1211, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32588, 1215, 640, 24, 33, "Text",
  Evaluatable->False],
Cell[33231, 1241, 108, 2, 27, "Input"],
Cell[33342, 1245, 109, 2, 33, "Text",
  Evaluatable->False],
Cell[33454, 1249, 139, 3, 27, "Input"],
Cell[33596, 1254, 632, 16, 124, "Question",
  Evaluatable->False],
Cell[34231, 1272, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34308, 1276, 149, 5, 33, "Text",
  Evaluatable->False],
Cell[34460, 1283, 140, 3, 27, "Input"],
Cell[34603, 1288, 321, 12, 48, "Question",
  Evaluatable->False],
Cell[34927, 1302, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[35004, 1306, 418, 14, 67, "Question"],
Cell[35425, 1322, 26, 0, 47, "Answer"],
Cell[35454, 1324, 76, 1, 59, "Input"],
Cell[35533, 1327, 137, 2, 43, "Input"],
Cell[35673, 1331, 144, 2, 52, "Text"],
Cell[35820, 1335, 118, 3, 59, "Input"],
Cell[35941, 1340, 78, 1, 27, "Input"],
Cell[36022, 1343, 100, 3, 59, "Input"],
Cell[36125, 1348, 78, 1, 27, "Input"],
Cell[36206, 1351, 207, 5, 67, "Question"],
Cell[36416, 1358, 26, 0, 47, "Answer"],
Cell[36445, 1360, 211, 5, 67, "Question"],
Cell[36659, 1367, 26, 0, 47, "Answer"]
}, Closed]],

Cell[CellGroupData[{
Cell[36722, 1372, 374, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.19.12"],
Cell[37099, 1388, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[37444, 1399, 52, 1, 27, "Input"],
Cell[37499, 1402, 45, 1, 27, "Input"],
Cell[37547, 1405, 53, 1, 27, "Input"],
Cell[37603, 1408, 54, 1, 27, "Input"],
Cell[37660, 1411, 52, 1, 27, "Input"],
Cell[37715, 1414, 61, 1, 27, "Input"],
Cell[37779, 1417, 53, 1, 27, "Input"],
Cell[37835, 1420, 51, 1, 27, "Input"],
Cell[37889, 1423, 49, 1, 27, "Input"],
Cell[37941, 1426, 45, 1, 27, "Input"],
Cell[37989, 1429, 47, 1, 27, "Input"],
Cell[38039, 1432, 49, 1, 27, "Input"],
Cell[38091, 1435, 55, 1, 27, "Input"],
Cell[38149, 1438, 57, 1, 27, "Input"],
Cell[38209, 1441, 55, 1, 27, "Input"],
Cell[38267, 1444, 54, 1, 27, "Input"],
Cell[38324, 1447, 50, 1, 27, "Input"],
Cell[38377, 1450, 55, 1, 27, "Input"],
Cell[38435, 1453, 57, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

