(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     69612,       2676]*)
(*NotebookOutlinePosition[     73841,       2811]*)
(*  CellTagsIndexPosition[     73284,       2790]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 13",
    FontSize->18],
  "\nGroup Homomorphisms"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.13"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.14.13"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.15.13"],

Cell["\<\
The reader should be familiar with isomorphisms (Group Lab 8) and \
cosets (Group Lab 11).\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.16.13"],

Cell["\<\
This lab explores the concept of group homomorphisms. The ultimate \
goal is an understanding of the relationship between the domain, kernel, and \
image of a homomorphism through the Fundamental Theorem of Group \
Homomorphisms. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "What is a group homomorphism?"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.17.13"],

Cell[TextData[{
  StyleBox["Note on terminology:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" The terms ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["homomorphism ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["morphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " are used synonymously in algebra. Since the former is somewhat more \
prevalent in textbooks, we use it here, but in the interest of using shorter \
names where possible, we use the latter in our ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["homomorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" from a group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\((\(G, \)\ \)*\))\)\)]],
  StyleBox[" into a group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((H, #)\)\)]],
  StyleBox[" is a function from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " that preserves the operations between the two groups (* and # \
respectively). That is, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is a homomorphism, then for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[",",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`f(x*y) = \(\(f(x)\)\ #\)\ \(f(y)\)\)]],
  "."
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "You should be familiar with the one-to-one, onto variety of these \
functions, called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["isomorphisms",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". Recall that the existence of an isomorphism between two groups \
establishes that the two groups are \[OpenCurlyDoubleQuote]equal\
\[CloseCurlyDoubleQuote] in an algebraic sense. The automorphisms on a group \
(isomorphisms from a group to itself) help us to categorize groups. \
Homomorphisms provide us with yet another tool in exploring groups. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"Before continuing, we first read in the code used in this lab.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "To review the notion of preserving an operation, we start by looking at \
two functions from the group of integers modulo 12 into the group of integers \
modulo 6. Again we use objects called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FormMorphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to create them. The first function adds 3 to each element of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[
  " and then takes the residue modulo 6 (reduces it mod 6). The second adds 6 \
before taking the residue modulo 6.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f = FormMorphoid[Mod[#1 + 3, 6]&, Z[12], Z[6]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(g = FormMorphoid[Mod[#1 + 6, 6]&, Z[12], Z[6]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Next we see if either function preserves the operations between the two \
groups for a specific pair of elements, say 5 and 9. We use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mode of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PreservesQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to help visualize the process. First ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[f, {5, 9}, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The operations are not preserved: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(5 + 9)\), 
          StyleBox["\[NotEqual]",
            FontFamily->"Courier"], \(f(5) + f(9)\)}], TraditionalForm]]],
  StyleBox[". So, with this single example, we see that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is not a homomorphism. Now we look at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[
  ". (Note: The visual mode displays the name of any function generically as \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[", but here ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" is the function we are examining.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[g, {5, 9}, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For the pair ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((5, 9)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" acts like a homomorphism. Does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" satisfy this property for all pairs in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox["? We can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MorphismQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to test all pairs. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[g, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" is replaced with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" in this cell, an opposite color pattern results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". There is a simpler way to define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" than the function we used. Can you describe it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The kernel and image"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.18.13"],

Cell["\<\
The kernel and image of a homomorphism are special subsets worthy \
of consideration. The kernel is a subset of the domain and the image is a \
subset of the codomain.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["13.4.1 The kernel", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.18.14.13"],

Cell[TextData[{
  "The kernel of a group homomorphism is the set of elements in the domain \
that map onto the identity of the codomain. Recall that ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " is a homomorphism."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Kernel[g]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Kernel",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function returns a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", which we know by now does not in itself imply that it is a group (or a \
subgroup of the domain)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". In this case, is the kernel a group (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[")?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s look at some more kernels. Consider the following ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f2 = FormMorphoid[Mod[#1, 5]&, Z[10], Z[5]]\), 
    \(f3 = FormMorphoid[Mod[#1, 2]&, Z[10], Z[2]]\), 
    \(f4 = FormMorphoid[2 \[Rule] 1, U[25], Z[20]]\), 
    \(f5 = FormMorphoid[2 \[Rule] 2, U[25], Z[20]]\), 
    \(f6 = FormMorphoid[Mod[#1, 3]&, Z[10], Z[5]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s determine which of these are homomorphisms and \
compute the kernels."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[MorphismQ, \ {f2, \ f3, \ f4, \ f5, \ f6}]\)], "Input"],

Cell[BoxData[
    \(Map[Kernel, \ {f2, \ f3, \ f4, \ f5, \ f6}]\)], "Input"],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For which of these five functions is the kernel a group (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", a subgroup of the domain)?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" is a homomorphism and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" are in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K = Kernel[h]\)]],
  StyleBox[", explain why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a*b\)]],
  StyleBox[" must also be in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  ".",
  StyleBox[" (In other words, show that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[
  " is closed.) Note: Closure of a (nonempty) subset of a finite group \
implies that it is a subgroup.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Kernel",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" acts on any ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". If the codomain has an identity, it returns a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (it returns ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["$Failed",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" otherwise). Recall that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" was not a homomorphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Kernel[f]\), 
    \(ClosedQ[%]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". True or false: If \[Phi] is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" from some group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" into some group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" and Kernel[\[Phi]] is a subgroup of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  ", then \[Phi] is a homomorphism. (See the hint at end of the section, if \
needed.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"In some sense, the size of the kernel indicates how much the domain is \
\[OpenCurlyDoubleQuote]reduced\[CloseCurlyDoubleQuote] when a homomorphism is \
applied to it."], "Text",
  Evaluatable->False,
  CellGroupingRules->"InputGrouping",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Hint", "Subsubsection",
  CellTags->"a:13.18.14.14.13"],

Cell[TextData[{
  "Consider ",
  Cell[BoxData[
      \(TraditionalForm\`G = \(H = \[DoubleStruckCapitalZ]\_3\)\)]],
  " and the function that squares its input (mod 3)."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["13.4.2 The image", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.18.15.13"],

Cell[TextData[{
  "The image of a homomorphism is the range of the function and thus is a \
subset of the codomain. We want to know when this subset is a subgroup. For \
our first homomorphism, ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ", the image is the whole codomain, and so it is clearly a subgroup. This \
is a common situation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Image[g]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider the five ",
  StyleBox["Morphoids",
    FontFamily->"Courier"],
  " defined in section 13.4.1, in addition to ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " defined at the outset of the lab. Are the images subgroups of the \
codomain?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\ {f, \ f2, \ f3, \ f4, \ f5, \ f6} // ColumnForm\)\)], "Input"],

Cell[BoxData[
    \(Map[Image, \ {f, \ f2, \ f3, \ f4, \ f5, \ f6}]\)], "Input"],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Which of these images are subgroups of the given codomain?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose \[Pi] is a function from the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" into the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  ". Consider the following two statements: (1) If \[Pi] is a homomorphism, \
then the image of \[Pi] is a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[", (2) If the image of \[Pi] is a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  ", then \[Pi] is a homomorphism. Determine whether these statements are \
true or false. If true, give a proof; if false, provide an example of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" that demonstrates it is false.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Properties that are preserved by homomorphisms"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.19.13"],

Cell[TextData[StyleBox[
"The following results are proven in many abstract algebra texts, so we \
simply report them and give a few illustrations.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" be a homomorphism from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Then",
  StyleBox["\n\n\t1. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox["(the identity of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[") = the identity of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[".\n\t2. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(f(x\^\(-1\)\)\)]],
  StyleBox[") = ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(f(x)\)\^\(-1\)\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[".\n\t3. If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  StyleBox[" is a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(S) = {f(s) | s \[Element] S}\)]],
  StyleBox[" is a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"We use one homomorphism to illustrate these three properties, mapping the \
integers modulo 16 into the fourth roots of unity.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = Z[16]\), 
    \(H = RootsOfUnity[4, Mode \[Rule] Visual]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The visual form of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RootsOfUnity[4]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is given to illustrate that this group is the set of complex numbers (on \
the unit circle) that satisfy the equation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^4\)]],
  StyleBox[" = 1.",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" maps each integer to that power of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox[", so ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox["\[RightTeeArrow]",
            FontFamily->"Courier"], \(i\^x\)}], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[f]; \nf\  = \ FormMorphoid[\((I^#)\)&, \ G, \ H]\)], "Input"],

Cell[TextData[{
  "The identities here are 0 and 1, respectively. Therefore, by property 1, \
the element 0 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " should be mapped to the element 1 in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f[0] == 1\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Notice below how the equation is much more explicit in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  "than in property 2. To test the property we need to specify the groups in \
which each inversion is taking place. We pick a random element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" out of the domain and then test property 2.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(x = RandomElement[G]\), 
    \(f[GroupInverse[G, x]] == GroupInverse[H, f[x]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s generate a few more examples and place them in a table. The third and \
fifth columns should match if our ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is a morphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[x = RandomElement[G]; xinv = GroupInverse[G, x]; fxinv = f[xinv]; 
        fx = f[x]; 
        invfx = GroupInverse[H, f[x]]; {x, xinv, fxinv, fx, invfx}, {10}], 
      TableHeadings 
        \[Rule] {
          None, {"\<x\>", \*"\"\<\!\(x\^\(-1\)\)\>\"", 
            \*"\"\<f(\!\(x\^\(-1\)\))\>\"", "\<f(x)\>", 
            \*"\"\<f(x\!\(\()\^\(-1\)\)\)\\n\>\""}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "For property 3, note that the even elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_16\)]],
  " are a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Y = Range[0, 15, 2]\), 
    \(SubgroupQ[Y, G]\)}], "Input",
  AspectRatioFixed->True],

Cell["Now consider its image.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(W = Union[Map[f, Y]]\), 
    \(SubgroupQ[W, H]\)}], "Input",
  AspectRatioFixed->True],

Cell["This too is a subgroup.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Recall the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["f5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " defined earlier. Verify that these three properties hold for this \
morphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f5 = FormMorphoid[2 \[Rule] 2, U[25], Z[20]]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The kernel is normal"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.20.13"],

Cell["\<\
The kernel of a homomorphism is not just an ordinary subgroup; it \
is always a normal subgroup. One proof of this statement is based on the \
definition of a normal subgroup.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is a normal subgroup of ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " ",
  StyleBox["if and only if ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^\(-1\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True,
    FontVariations->{"CompatibilityType"->"Subscript"}],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" is in ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" in ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[".",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["In other words, every conjugate of an element of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is also in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". (Recall that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\^\(-1\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", for some ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", is a conjugate of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Verify that if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is a homomorphism and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" is in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K = Kernel[f]\)]],
  StyleBox[", then any conjugate of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" is also in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Since every subgroup of an Abelian group is normal (Do you know why?) we \
need to consider a nonabelian group to illustrate the normality of the \
kernel. Consider the cyclic subgroup generated by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(H = SubgroupGenerated[Dihedral[3], Ref]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can choose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" to be any element of the group\[LongDash]here we pick ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and look at its conjugates.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[Conjugate[Dihedral[3], \ #, \ Rot]&, \ Elements[H]]\)], "Input"],

Cell[TextData[{
  StyleBox["This result shows that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " is not a normal subgroup. (Why?) It also implies something we can not \
easily illustrate: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is not the kernel of any homomorphism with domain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[". Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s see what kernels we ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["can",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" get from homomorphisms on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[". Suppose we consider the exponent of the symbol ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" in any element of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[". Recall the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Elements[Dihedral[3]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Clearly the exponent is an integer in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{0, 1, 2}\)]],
  ",",
  StyleBox[" so let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider this as a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" expression here is a bit complicated because the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[" involve the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NonCommutativeMultiply",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(xifunction = 
      Exponent[# /. {NonCommutativeMultiply \[Rule] Times}, Rot]&\)], "Input",\

  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We put the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" into rules-form to make it easier to read.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Xi]\  = \ 
      FormMorphoid[xifunction, \ Dihedral[3], \ Z[3]] // ToRules\)], "Input"],

Cell["Now consider the kernel.", "Text"],

Cell[BoxData[
    \(Kernel[\[Xi]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Since the kernel of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["\[Xi]", TraditionalForm]]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{"1", ",", "Ref"}], "}"}], TraditionalForm]]],
  StyleBox[", what immediate conclusion should we draw regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["\[Xi]", TraditionalForm]]],
  StyleBox["? You might want to use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PreservesQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MorphismQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to verify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s do the same thing, but with the exponent of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(taufunction = 
      Exponent[#1 /. {NonCommutativeMultiply \[Rule] Times}, Ref]&\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Tau]\  = \ 
      FormMorphoid[taufunction, \ Dihedral[3], \ Z[2]] // ToRules\)], "Input"],

Cell["We get a different kernel here.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Kernel[\[Tau]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Is the kernel normal? We can use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NormalQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NormalQ[K, Dihedral[3]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Alternatively, we can ask whether \[Tau] is a homomorphism."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[\[Tau]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Explain why checking the value of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MorphismQ[\[Tau]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" gives us more information than does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NormalQ[K, Dihedral[3]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["13.7 The First Homomorphism Theorem",
  Evaluatable->False,
  AspectRatioFixed->True]], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.21.13"],

Cell[TextData[{
  "Recall that normality is exactly the condition on a subgroup required in \
order for its left (or right) cosets to form a group. If ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is a homomorphism from ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " into ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " with kernel ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  ", we examine the quotient group ",
  Cell[BoxData[
      \(TraditionalForm\`G/K\)]],
  ". We start with the most recent example."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Q = QuotientGroup[Dihedral[3], K]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The quotient group has just two elements, so it clearly must be isomorphic \
to ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ", which happens to be the image of \[Tau]. Let\[CloseCurlyQuote]s formally \
establish this fact by creating an isomorphism between ",
  StyleBox["G/Kernel[\[Tau]]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Image[\[Tau]]",
    FontFamily->"Courier"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(FormMorphoidSetup[Q, Image[\[Tau]]]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "We want to map the identity of the domain to the identity of the codomain, \
so we define the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" by position using the list ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 2}\)]],
  StyleBox[" to indicate that the first element of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  StyleBox[" goes to the first element of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Image[",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Tau]",
    FontFamily->"Courier"],
  StyleBox["]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and the second to the second.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta] = FormMorphoid[{1, 2}, Q, Image[\[Tau]]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[\[Theta]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The isomorphism that we",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "ve just created is not coincidental. It follows from the following \
theorem. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Fundamental Homomorphism Theorem: ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" be a group homomorphism from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" with kernel ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[" and image ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(G)\)]],
  StyleBox[". Then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(G)\)]],
  StyleBox[" is isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G/K\)]],
  StyleBox[", an isomorphism between these two groups being \[Psi]: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(G/K\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], \(f(G)\)}], TraditionalForm]]],
  StyleBox[" defined by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Psi](a\ K) = f(a)\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["In the example, notice how the coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ NS\)\)]],
  StyleBox[" is mapped to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Tau]",
  StyleBox["[Ref]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" = 1, while ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(NS = 1\ \)\)]],
  Cell[BoxData[
      \(TraditionalForm\`NS\)]],
  StyleBox[" is mapped to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Tau]",
  StyleBox["[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" = 0.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Virtually every abstract algebra text has a proof of this theorem or some \
slight variation of the theorem. For example, one popular text starts with \
the assumption that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is onto (and so ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(G) = H\)]],
  StyleBox[
  "). The proof is still essentially the same. We close this section by \
illustrating the theorem with two more examples.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["13.7.1 Example 2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.21.14.13"],

Cell[TextData[{
  "Consider the direct product ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_5\[Cross]\[DoubleStruckCapitalZ]\_5\)]],
  " and map each ",
  "pair ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " into ",
  Cell[BoxData[
      \(TraditionalForm\`4\ a + 3\ b\)]],
  " (mod 5) in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = DirectProduct[Z[5], Z[5]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Alpha] = FormMorphoid[Mod[Plus@@\(({4, 3} . #1)\), 5]&, G, Z[5]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[
"It may not be obvious whether \[Alpha] is a homomorphism, so we verify that \
it is."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[\[Alpha]]\)], "Input",
  AspectRatioFixed->True],

Cell["We compute the kernel and image. ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Kernel[\[Alpha]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Image[\[Alpha]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Notice that \[Alpha] is onto, so we can establish an isomorphism between ",
  
  Cell[BoxData[
      \(TraditionalForm\`G/K\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Q2 = QuotientGroup[G, K]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Gamma] = FormMorphoid[\[Alpha][First[#1]]&, Q2, Image[\[Alpha]]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[\[Gamma]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["G = DirectProduct[Z[4], Z[4]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontSize->12],
  StyleBox["and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["K = {{0,0}, {0,2}, {2,0}, {2,2}}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". To what group is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G/K\)]],
  StyleBox[" isomorphic? To prove your answer, find a homomorphism from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" into some other group that has ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[" as its kernel. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["13.7.2 Example 3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.21.15.13"],

Cell[TextData[{
  StyleBox[
  "In this example, we map the divisors of 42 into the divisors of 30 with \
the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GCD[#, 30]&",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". We form the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" between the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MixedDivisors",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" based on these sets.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?MixedDivisors\)\)], "Input"],

Cell[BoxData[
    \(\[Eta] = 
      FormMorphoid[GCD[#1, 30]&, MixedDivisors[42], MixedDivisors[30]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
The kernel will be the divisors of 42 that are relatively prime to \
30.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Kernel[\[Eta]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Not every divisor of 30 is in the range, so \[Eta] is not onto."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Image[\[Eta]]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
The Fundamental Homomorphism Theorem tells us that the image is \
isomorphic to the following quotient group.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Q3 = QuotientGroup[MixedDivisors[42], K]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"The isomorphism we define maps each of these cosets to the image under \
\[Eta] of its first element."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta] = FormMorphoid[\[Eta][First[#1]]&, Q3, Image[\[Eta]]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[\[Theta]]\)], "Input",
  AspectRatioFixed->True],

Cell["Again, our result is not a surprise.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"The Fundamental Homomorphism Theorem is occasionally called the First \
Homomorphism Theorem. You might wonder about a Second Homomorphism Theorem. \
There is one, and it is often called the Diamond Homomorphism Theorem. There \
is also a Third (Zassenhauss\[CloseCurlyQuote] Theorem). These theorems are \
stated and proved in many introductory abstract algebra books."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["square-free integer ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  "is an integer that has no square divisors other than 1. For example, 42 \
and 30 are square-free, while 50 is not. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MixedDivisors[m]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is a group if and only if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" is square-free. As a general rule, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" are both square-free integers and we map ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MixedDivisors[m]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MixedDivisors[n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GCD[#, n]&",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", what will be the kernel and range of this morphism? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.8 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The alternating group\[LongDash]parity as a morphism"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.22.13"],

Cell[TextData[{
  StyleBox[
  "We have seen that every permutation is either odd or even. Now we will \
think of this classification as a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mapping ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_n\)]],
  StyleBox[" into the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, \(-1\)}\)]],
  StyleBox[" with multiplication, which we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["IntegerUnits",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Here we will work with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = 4\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sign = FormMorphoid[Parity, Symmetric[4], IntegerUnits]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This happens to be a significant morphism for any ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(MorphismQ[sign]\ \)\)], "Input",
  AspectRatioFixed->True],

Cell["The kernel is quite significant here. ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Kernel[sign]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Describe the elements of the kernel in terms of their parity.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The kernel, which happens to be a normal subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_4\)]],
  ",",
  StyleBox[" is called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["alternating group",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of degree 4, or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`A\_4\)]],
  StyleBox[". This group can be accessed directly without morphisms using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Alternating",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Alternating\)\)], "Input"],

Cell[BoxData[
    \(Alternating[4]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
There are many interesting properties of the alternating groups \
that you can read about in your text.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.9 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.23.13"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?FormMorphoid", "Input",
  AspectRatioFixed->True],

Cell["?Z", "Input",
  AspectRatioFixed->True],

Cell["?PreservesQ", "Input",
  AspectRatioFixed->True],

Cell["?Visual", "Input",
  AspectRatioFixed->True],

Cell["?MorphismQ", "Input",
  AspectRatioFixed->True],

Cell["?Kernel", "Input",
  AspectRatioFixed->True],

Cell["?U", "Input",
  AspectRatioFixed->True],

Cell["?Map", "Input",
  AspectRatioFixed->True],

Cell["?Image", "Input",
  AspectRatioFixed->True],

Cell["?ClosedQ", "Input",
  AspectRatioFixed->True],

Cell["?RootsOfUnity", "Input",
  AspectRatioFixed->True],

Cell["?RandomElement", "Input",
  AspectRatioFixed->True],

Cell["?GroupInverse", "Input",
  AspectRatioFixed->True],

Cell["?Range", "Input",
  AspectRatioFixed->True],

Cell["?SubgroupQ", "Input",
  AspectRatioFixed->True],

Cell["?Dihedral", "Input",
  AspectRatioFixed->True],

Cell["?SubgroupGenerated", "Input",
  AspectRatioFixed->True],

Cell["?InnerAutomorphism", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?Exponent", "Input",
  AspectRatioFixed->True],

Cell["?NormalQ", "Input",
  AspectRatioFixed->True],

Cell["?QuotientGroup", "Input",
  AspectRatioFixed->True],

Cell["?FormMorphoidSetup", "Input",
  AspectRatioFixed->True],

Cell["?IsomorphismQ", "Input",
  AspectRatioFixed->True],

Cell["?DirectProduct", "Input",
  AspectRatioFixed->True],

Cell["?MixedDivisors", "Input",
  AspectRatioFixed->True],

Cell["?Parity", "Input",
  AspectRatioFixed->True],

Cell["?Symmetric", "Input",
  AspectRatioFixed->True],

Cell["?IntegerUnits", "Input",
  AspectRatioFixed->True],

Cell["?Alternating", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{628, 427},
WindowMargins->{{6, Automatic}, {Automatic, 4}},
PrintingCopies->1,
PrintingPageRange->{9, 10},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 13 Group homomorphisms", FontSlant -> "Italic"], 
          "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:13.13"->{
    Cell[2382, 76, 171, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:13.13"]},
  "a:13.14.13"->{
    Cell[2578, 87, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:13.14.13"]},
  "a:13.15.13"->{
    Cell[7105, 240, 195, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.15.13"]},
  "a:13.16.13"->{
    Cell[7502, 260, 187, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.16.13"]},
  "a:13.17.13"->{
    Cell[8031, 282, 211, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.17.13"]},
  "a:13.18.13"->{
    Cell[17342, 623, 202, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.18.13"]},
  "a:13.18.14.13"->{
    Cell[17811, 643, 116, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:13.18.14.13"]},
  "a:13.18.14.14.13"->{
    Cell[25138, 927, 61, 1, 42, "Subsubsection",
      CellTags->"a:13.18.14.14.13"]},
  "a:13.18.15.13"->{
    Cell[25432, 941, 115, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:13.18.15.13"]},
  "a:13.19.13"->{
    Cell[28320, 1048, 228, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.19.13"]},
  "a:13.20.13"->{
    Cell[36277, 1353, 202, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.20.13"]},
  "a:13.21.13"->{
    Cell[49109, 1858, 196, 5, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.21.13"]},
  "a:13.21.14.13"->{
    Cell[55552, 2099, 115, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:13.21.14.13"]},
  "a:13.21.15.13"->{
    Cell[58819, 2234, 115, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:13.21.15.13"]},
  "a:13.22.13"->{
    Cell[63702, 2417, 234, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.22.13"]},
  "a:13.23.13"->{
    Cell[67173, 2557, 374, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.23.13"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:13.13", 71333, 2723},
  {"a:13.14.13", 71446, 2727},
  {"a:13.15.13", 71565, 2731},
  {"a:13.16.13", 71684, 2735},
  {"a:13.17.13", 71803, 2739},
  {"a:13.18.13", 71922, 2743},
  {"a:13.18.14.13", 72045, 2747},
  {"a:13.18.14.14.13", 72177, 2751},
  {"a:13.18.15.13", 72285, 2754},
  {"a:13.19.13", 72411, 2758},
  {"a:13.20.13", 72532, 2762},
  {"a:13.21.13", 72653, 2766},
  {"a:13.21.14.13", 72777, 2770},
  {"a:13.21.15.13", 72907, 2774},
  {"a:13.22.13", 73034, 2778},
  {"a:13.23.13", 73155, 2782}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 171, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:13.13"],

Cell[CellGroupData[{
Cell[2578, 87, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:13.14.13"],
Cell[2908, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3785, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5181, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5359, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6007, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6725, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7105, 240, 195, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.15.13"],
Cell[7303, 250, 162, 5, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7502, 260, 187, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.16.13"],
Cell[7692, 270, 302, 7, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8031, 282, 211, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.17.13"],
Cell[8245, 292, 990, 34, 72, "Text",
  Evaluatable->False],
Cell[9238, 328, 1479, 55, 71, "Text",
  Evaluatable->False],
Cell[10720, 385, 187, 7, 33, "Text",
  Evaluatable->False],
Cell[10910, 394, 757, 20, 109, "Text",
  Evaluatable->False],
Cell[11670, 416, 195, 5, 33, "Text",
  Evaluatable->False],
Cell[11868, 423, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[12043, 429, 1021, 30, 109, "Text",
  Evaluatable->False],
Cell[13067, 461, 105, 2, 27, "Input"],
Cell[13175, 465, 105, 2, 27, "Input"],
Cell[13283, 469, 727, 25, 71, "Text",
  Evaluatable->False],
Cell[14013, 496, 101, 2, 27, "Input"],
Cell[14117, 500, 1087, 36, 71, "Text",
  Evaluatable->False],
Cell[15207, 538, 101, 2, 27, "Input"],
Cell[15311, 542, 933, 33, 52, "Text",
  Evaluatable->False],
Cell[16247, 577, 92, 2, 27, "Input"],
Cell[16342, 581, 444, 16, 33, "Text",
  Evaluatable->False],
Cell[16789, 599, 439, 15, 48, "Question",
  Evaluatable->False],
Cell[17231, 616, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[17342, 623, 202, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.18.13"],
Cell[17547, 633, 239, 6, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17811, 643, 116, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:13.18.14.13"],
Cell[17930, 648, 283, 8, 52, "Text",
  Evaluatable->False],
Cell[18216, 658, 68, 2, 27, "Input"],
Cell[18287, 662, 607, 22, 52, "Text",
  Evaluatable->False],
Cell[18897, 686, 517, 19, 48, "Question",
  Evaluatable->False],
Cell[19417, 707, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19494, 711, 462, 17, 33, "Text",
  Evaluatable->False],
Cell[19959, 730, 322, 6, 91, "Input"],
Cell[20284, 738, 167, 4, 33, "Text",
  Evaluatable->False],
Cell[20454, 744, 79, 1, 27, "Input"],
Cell[20536, 747, 76, 1, 27, "Input"],
Cell[20615, 750, 405, 14, 48, "Question",
  Evaluatable->False],
Cell[21023, 766, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21100, 770, 1276, 48, 86, "Question",
  Evaluatable->False],
Cell[22379, 820, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22456, 824, 1248, 46, 52, "Text",
  Evaluatable->False],
Cell[23707, 872, 91, 3, 43, "Input"],
Cell[23801, 877, 952, 34, 86, "Question",
  Evaluatable->False],
Cell[24756, 913, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[24833, 917, 280, 6, 52, "Text",
  Evaluatable->False,
  CellGroupingRules->"InputGrouping"],

Cell[CellGroupData[{
Cell[25138, 927, 61, 1, 42, "Subsubsection",
  CellTags->"a:13.18.14.14.13"],
Cell[25202, 930, 181, 5, 33, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[25432, 941, 115, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:13.18.15.13"],
Cell[25550, 946, 406, 10, 71, "Text",
  Evaluatable->False],
Cell[25959, 958, 67, 2, 27, "Input"],
Cell[26029, 962, 331, 11, 52, "Text",
  Evaluatable->False],
Cell[26363, 975, 86, 1, 27, "Input"],
Cell[26452, 978, 80, 1, 27, "Input"],
Cell[26535, 981, 300, 10, 48, "Question",
  Evaluatable->False],
Cell[26838, 993, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26915, 997, 1279, 41, 124, "Question",
  Evaluatable->False],
Cell[28197, 1040, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28320, 1048, 228, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.19.13"],
Cell[28551, 1058, 254, 6, 52, "Text",
  Evaluatable->False],
Cell[28808, 1066, 1996, 77, 109, "Text",
  Evaluatable->False],
Cell[30807, 1145, 259, 6, 52, "Text",
  Evaluatable->False],
Cell[31069, 1153, 121, 3, 43, "Input"],
Cell[31193, 1158, 1221, 44, 71, "Text",
  Evaluatable->False],
Cell[32417, 1204, 87, 1, 43, "Input"],
Cell[32507, 1207, 319, 11, 52, "Text",
  Evaluatable->False],
Cell[32829, 1220, 68, 2, 27, "Input"],
Cell[32900, 1224, 672, 20, 71, "Text",
  Evaluatable->False],
Cell[33575, 1246, 138, 3, 43, "Input"],
Cell[33716, 1251, 534, 19, 52, "Text",
  Evaluatable->False],
Cell[34253, 1272, 449, 10, 82, "Input"],
Cell[34705, 1284, 281, 10, 33, "Text",
  Evaluatable->False],
Cell[34989, 1296, 106, 3, 43, "Input"],
Cell[35098, 1301, 87, 2, 33, "Text",
  Evaluatable->False],
Cell[35188, 1305, 107, 3, 43, "Input"],
Cell[35298, 1310, 87, 2, 33, "Text",
  Evaluatable->False],
Cell[35388, 1314, 669, 26, 67, "Question",
  Evaluatable->False],
Cell[36060, 1342, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36137, 1346, 103, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[36277, 1353, 202, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.20.13"],
Cell[36482, 1363, 247, 6, 52, "Text",
  Evaluatable->False],
Cell[36732, 1371, 1576, 62, 43, "Text",
  Evaluatable->False],
Cell[38311, 1435, 1124, 43, 52, "Text",
  Evaluatable->False],
Cell[39438, 1480, 916, 35, 67, "Question",
  Evaluatable->False],
Cell[40357, 1517, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40434, 1521, 633, 21, 71, "Text",
  Evaluatable->False],
Cell[41070, 1544, 98, 2, 27, "Input"],
Cell[41171, 1548, 521, 18, 33, "Text",
  Evaluatable->False],
Cell[41695, 1568, 88, 1, 27, "Input"],
Cell[41786, 1571, 1589, 56, 90, "Text",
  Evaluatable->False],
Cell[43378, 1629, 80, 2, 27, "Input"],
Cell[43461, 1633, 1316, 47, 71, "Text",
  Evaluatable->False],
Cell[44780, 1682, 140, 4, 27, "Input"],
Cell[44923, 1688, 367, 13, 33, "Text",
  Evaluatable->False],
Cell[45293, 1703, 110, 2, 27, "Input"],
Cell[45406, 1707, 40, 0, 33, "Text"],
Cell[45449, 1709, 72, 2, 27, "Input"],
Cell[45524, 1713, 1155, 41, 67, "Question",
  Evaluatable->False],
Cell[46682, 1756, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[46759, 1760, 450, 17, 33, "Text",
  Evaluatable->False],
Cell[47212, 1779, 142, 4, 27, "Input"],
Cell[47357, 1785, 112, 2, 27, "Input"],
Cell[47472, 1789, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[47570, 1793, 77, 2, 27, "Input"],
Cell[47650, 1797, 359, 13, 33, "Text",
  Evaluatable->False],
Cell[48012, 1812, 82, 2, 27, "Input"],
Cell[48097, 1816, 134, 3, 33, "Text",
  Evaluatable->False],
Cell[48234, 1821, 76, 2, 27, "Input"],
Cell[48313, 1825, 682, 24, 67, "Question",
  Evaluatable->False],
Cell[48998, 1851, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[49109, 1858, 196, 5, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.21.13"],
Cell[49308, 1865, 599, 20, 71, "Text",
  Evaluatable->False],
Cell[49910, 1887, 92, 2, 27, "Input"],
Cell[50005, 1891, 504, 15, 71, "Text",
  Evaluatable->False],
Cell[50512, 1908, 100, 2, 27, "Input"],
Cell[50615, 1912, 1088, 38, 71, "Text",
  Evaluatable->False],
Cell[51706, 1952, 108, 2, 27, "Input"],
Cell[51817, 1956, 81, 2, 27, "Input"],
Cell[51901, 1960, 338, 12, 52, "Text",
  Evaluatable->False],
Cell[52242, 1974, 1604, 58, 72, "Text",
  Evaluatable->False],
Cell[53849, 2034, 979, 38, 52, "Text",
  Evaluatable->False],
Cell[54831, 2074, 696, 21, 90, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[55552, 2099, 115, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:13.21.14.13"],
Cell[55670, 2104, 478, 18, 33, "Text",
  Evaluatable->False],
Cell[56151, 2124, 88, 2, 27, "Input"],
Cell[56242, 2128, 128, 3, 27, "Input"],
Cell[56373, 2133, 159, 4, 33, "Text",
  Evaluatable->False],
Cell[56535, 2139, 78, 2, 27, "Input"],
Cell[56616, 2143, 97, 2, 33, "Text",
  Evaluatable->False],
Cell[56716, 2147, 79, 2, 27, "Input"],
Cell[56798, 2151, 74, 2, 27, "Input"],
Cell[56875, 2155, 297, 11, 33, "Text",
  Evaluatable->False],
Cell[57175, 2168, 83, 2, 27, "Input"],
Cell[57261, 2172, 128, 3, 27, "Input"],
Cell[57392, 2177, 81, 2, 27, "Input"],
Cell[57476, 2181, 1229, 44, 86, "Question",
  Evaluatable->False],
Cell[58708, 2227, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[58819, 2234, 115, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:13.21.15.13"],
Cell[58937, 2239, 974, 36, 52, "Text",
  Evaluatable->False],
Cell[59914, 2277, 51, 1, 27, "Input"],
Cell[59968, 2280, 142, 4, 27, "Input"],
Cell[60113, 2286, 144, 5, 33, "Text",
  Evaluatable->False],
Cell[60260, 2293, 77, 2, 27, "Input"],
Cell[60340, 2297, 138, 3, 33, "Text",
  Evaluatable->False],
Cell[60481, 2302, 72, 2, 27, "Input"],
Cell[60556, 2306, 181, 5, 52, "Text",
  Evaluatable->False],
Cell[60740, 2313, 99, 2, 27, "Input"],
Cell[60842, 2317, 176, 4, 33, "Text",
  Evaluatable->False],
Cell[61021, 2323, 124, 3, 27, "Input"],
Cell[61148, 2328, 81, 2, 27, "Input"],
Cell[61232, 2332, 100, 2, 33, "Text",
  Evaluatable->False],
Cell[61335, 2336, 444, 7, 90, "Text",
  Evaluatable->False],
Cell[61782, 2345, 1794, 62, 124, "Question",
  Evaluatable->False],
Cell[63579, 2409, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[63702, 2417, 234, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.22.13"],
Cell[63939, 2427, 1050, 37, 71, "Text",
  Evaluatable->False],
Cell[64992, 2466, 114, 2, 27, "Input"],
Cell[65109, 2470, 185, 7, 33, "Text",
  Evaluatable->False],
Cell[65297, 2479, 80, 2, 27, "Input"],
Cell[65380, 2483, 102, 2, 33, "Text",
  Evaluatable->False],
Cell[65485, 2487, 71, 2, 27, "Input"],
Cell[65559, 2491, 304, 10, 48, "Question",
  Evaluatable->False],
Cell[65866, 2503, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[65943, 2507, 887, 31, 52, "Text",
  Evaluatable->False],
Cell[66833, 2540, 49, 1, 27, "Input"],
Cell[66885, 2543, 73, 2, 27, "Input"],
Cell[66961, 2547, 175, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[67173, 2557, 374, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.23.13"],
Cell[67550, 2573, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[67895, 2584, 56, 1, 27, "Input"],
Cell[67954, 2587, 45, 1, 27, "Input"],
Cell[68002, 2590, 54, 1, 27, "Input"],
Cell[68059, 2593, 50, 1, 27, "Input"],
Cell[68112, 2596, 53, 1, 27, "Input"],
Cell[68168, 2599, 50, 1, 27, "Input"],
Cell[68221, 2602, 45, 1, 27, "Input"],
Cell[68269, 2605, 47, 1, 27, "Input"],
Cell[68319, 2608, 49, 1, 27, "Input"],
Cell[68371, 2611, 51, 1, 27, "Input"],
Cell[68425, 2614, 56, 1, 27, "Input"],
Cell[68484, 2617, 57, 1, 27, "Input"],
Cell[68544, 2620, 56, 1, 27, "Input"],
Cell[68603, 2623, 49, 1, 27, "Input"],
Cell[68655, 2626, 53, 1, 27, "Input"],
Cell[68711, 2629, 52, 1, 27, "Input"],
Cell[68766, 2632, 61, 1, 27, "Input"],
Cell[68830, 2635, 61, 1, 27, "Input"],
Cell[68894, 2638, 52, 1, 27, "Input"],
Cell[68949, 2641, 52, 1, 27, "Input"],
Cell[69004, 2644, 51, 1, 27, "Input"],
Cell[69058, 2647, 57, 1, 27, "Input"],
Cell[69118, 2650, 61, 1, 27, "Input"],
Cell[69182, 2653, 56, 1, 27, "Input"],
Cell[69241, 2656, 57, 1, 27, "Input"],
Cell[69301, 2659, 57, 1, 27, "Input"],
Cell[69361, 2662, 50, 1, 27, "Input"],
Cell[69414, 2665, 53, 1, 27, "Input"],
Cell[69470, 2668, 56, 1, 27, "Input"],
Cell[69529, 2671, 55, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

