(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     67299,       2113]*)
(*NotebookOutlinePosition[     71581,       2257]*)
(*  CellTagsIndexPosition[     70922,       2231]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Deletable->True,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Lab 0\nGetting started with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:0.0"],

Cell[TextData[{
  StyleBox["This lab is intended to be an introduction to using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". There are several key skills and concepts that need to be mastered to \
ensure success with the labs in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". They are:\n\n\t1. how to recognize nested cells\n\t2. how to open and \
close nested cells\n\t3. how to evaluate an expression in an input cell\n\t4. \
how to create an input cell in order to create one\[CloseCurlyQuote]s own ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" input\n\t5. learn some of the general principles of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" syntax\n\t6. learn where to get more help",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Let\[CloseCurlyQuote]s begin with the first two goals. For users of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " 2.2, every cell has one or more brackets surrounding it on the right side \
of the window. For users of version 3.0 or higher, the brackets may be \
replaced by, or supplemented with, arrows (triangles) on the left that can be \
toggled. For instance, look at the next cell, headed by the title \
\[OpenCurlyDoubleQuote]0.0 Note regarding Exploring Abstract Algebra with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ".\[CloseCurlyDoubleQuote] (You may need to scroll down to see it. This \
section occurs only in the notebook version, not in the printed version.) \
Note that this cell has a standard square bracket as well as another bracket \
to its right that looks somewhat like a harpoon. This indicates that there \
are cells nested inside. When you move the cursor over the bracket with the \
harpoon, the cursor takes on the shape of an arrow pointing left toward a \
vertical bar. When the cursor has this shape, you can double-click on the \
harpoon. This will open up to reveal the inner, nested cells. Try this now \
with any of these first three sections (0.0, 0.1, or 0.2); after reading any \
or all of these, proceed to section 0.3 and open it up to continue.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["0.0 Note regarding Exploring Abstract Algebra with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  CellTags->"a:0.1.0"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user\[CloseCurlyQuote]s guide with printed and \
electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["0.1 Prerequisites", "Section",
  Evaluatable->False,
  CellTags->"a:0.2.0"],

Cell["There are no prerequisites for this lab.", "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["0.2 Goals for this lab", "Section",
  Evaluatable->False,
  CellTags->"a:0.3.0"],

Cell[TextData[{
  StyleBox["This lab is intended to introduce a few of the basics of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", as well as introduce a few rudimentary algebraic ideas.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox[
  "0.3 The In\[CloseCurlyQuote]s and Out\[CloseCurlyQuote]s of evaluating ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" expressions",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  CellTags->"a:0.4.0"],

Cell["\<\
These nested cells are not too difficult to open up, once you get \
the hang of it, right?\
\>", "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Go to section 0.4 (below) and open up the nested cells. What do you find \
inside at the inner-most nested level?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox[
  "You may have noticed that some cells appear differently than others. For \
instance, this text is in a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Text",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" cell, while the cell heading this section (0.3) is called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Section",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " cell. If you go up and click anywhere in the characters of the section \
0.3 cell, you will see the word ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Section",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " appear in the pop-up menu in the ruler at the top of the window. This \
menu indicates the current cell type; it can also be used to change one type \
of cell to another. To tell ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " to compute an evaluation, we need to use a special type of cell, called \
an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" cell. Consider the following cell.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FractionBox["26", "3"]], "Input"],

Cell[TextData[{
  StyleBox[
  "Click the cursor anywhere in the body of the above cell containing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`26\/3\)]],
  StyleBox[
  ", or select its cell bracket. (Note that the name of the cell type becomes \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" in the pop-up menu in the ruler.) To ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["evaluate",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " this cell (assuming you have clicked in the cell or selected its \
bracket), press the SHIFT/RETURN key combination (or just the ENTER key on a \
Macintosh). ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" will then evaluate this request and return its value. Do so.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Do not be too disappointed with the result; ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " always tries to return an exact result whenever possible. In this case, ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`26\/3\)]],
  StyleBox[
  " is more exact than 8.7 or 8.6667 or 8.666666667. Each of these \
approximations can be obtained as follows (evaluate this next cell).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"N", "[", 
          RowBox[{
            FractionBox["26", "3"], ",", "2"}], "]"}], ",", 
        RowBox[{"N", "[", 
          RowBox[{
            FractionBox["26", "3"], ",", "5"}], "]"}], ",", 
        RowBox[{"N", "[", 
          RowBox[{
            FractionBox["26", "3"], ",", "10"}], "]"}]}], "}"}]], "Input"],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Evaluate the cell below. (Remember to use the SHIFT/RETURN combination.) \
What do these results have in common with the above approximations of 26/3?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"N", "[", 
      RowBox[{"{", 
        RowBox[{
          FractionBox["29", "3"], ",", 
          FractionBox["23", "3"], ",", 
          FractionBox["20", "3"]}], "}"}], "]"}]], "Input"],

Cell[TextData[{
  StyleBox["The next thing to learn is how to make your own ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " cell so that you can type in your own request. Move the cursor (slowly) \
right below the text in this paragraph. As you move it, you should see the \
cursor take on one or more of the following shapes: a horizontal I-beam, a \
down-arrow, a circle with a plus, a vertical I-beam or possibly other shapes. \
When it is just below this text, but yet above the next cell, you should see \
the cursor become a horizontal I-beam. On clicking the mouse when this cursor \
is present, a horizontal line appears in the window. You can now start typing \
and you are automatically in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" style.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Above this cell, but below the preceding paragraph of text, create an \
input cell, type in 17/3, and evaluate the cell. Create another cell and \
determine the decimal approximations of 14/3 and 11/3. What do these results \
have in common with previous results?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Evaluate the following ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " cell. Next, create a new input cell and either retype the line just \
evaluated or copy it and paste it in the new cell. (You are not expected to \
understand what these instructions in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " cell mean.) Before evaluating, change the 2 to a 1. What do the results \
in the output have in common? How do they compare to the previous output?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"Map", "[", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{"N", "[", 
              FractionBox["#1", "3"], "]"}], "&"}], ")"}], ",", 
        RowBox[{"Range", "[", 
          RowBox[{"2", ",", "30", ",", "3"}], "]"}]}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.4 What is inside?", "Section",
  Evaluatable->False,
  CellTags->"a:0.5.0"],

Cell[CellGroupData[{

Cell["You have to open up each layer to find out.", "Subsection",
  Evaluatable->False,
  CellTags->"a:0.5.1.0"],

Cell[CellGroupData[{

Cell["Is there another level inside this?", "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.5.1.1.0"],

Cell["No. A subsubsection is the lowest level here.", "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.5 Some syntax basics", "Section",
  Evaluatable->False,
  CellTags->"a:0.6.0"],

Cell["\<\
Recall earlier where we evaluated the following cell; evaluate it \
again.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"N", "[", 
      RowBox[{"{", 
        RowBox[{
          FractionBox["29", "3"], ",", 
          FractionBox["23", "3"], ",", 
          FractionBox["20", "3"]}], "}"}], "]"}]], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " is very particular in expecting the exact syntax for communicating \
requests. For example, the following are incorrect methods (for various \
reasons) of inputting the previous cell. Evaluate each of the following.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{"example", " ", "1"}], " ", "*)"}], " ", 
      RowBox[{"n", "[", 
        RowBox[{"{", 
          RowBox[{
            FractionBox["29", "3"], ",", 
            FractionBox["23", "3"], ",", 
            FractionBox["20", "3"]}], "}"}], "]"}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{"example", " ", "2"}], " ", "*)"}], " ", 
      RowBox[{"N", "[", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"29", "/", "3"}], ",", " ", 
            RowBox[{"23", "/", "3"}], ",", " ", 
            RowBox[{"20", "/", "3"}]}], ")"}], "]"}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{"example", " ", "3"}], " ", "*)"}], " ", 
      RowBox[{"N", " ", 
        RowBox[{"{", 
          RowBox[{
            FractionBox["29", "3"], ",", 
            FractionBox["23", "3"], ",", 
            FractionBox["20", "3"]}], "}"}]}]}]], "Input"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{"example", " ", "4"}], " ", "*)"}], " ", 
      RowBox[{"N", "[", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"29", "/", "3"}], " ", 
            RowBox[{"23", "/", "3"}], " ", 
            RowBox[{"20", "/", "3"}]}], "}"}], "]"}]}], 
    RowBox[{"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t", 
      RowBox[{"N", "[", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"29", "/", "3"}], ";", " ", 
            RowBox[{"23", "/", "3"}], ";", " ", 
            RowBox[{"20", "/", "3"}]}], "}"}], "]"}]}]}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{"example", " ", "5"}], " ", "*)"}], " ", 
      RowBox[{"N", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{"29", "/", "3"}], ",", " ", 
              RowBox[{"23", "/", "3"}], ",", " ", 
              RowBox[{"20", "/", "3"}]}]}], "]"}]}], "}"}]], "Input"],

Cell[TextData[{
  StyleBox[
  "In addition to the error messages that were given, here are additional \
reasons why these are incorrect.\n\n1. All ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " commands or functions start with capital letters.\n\n2. Lists are always \
enclosed with curly brackets {}; parentheses are used ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["only",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " for grouping expressions to alter the standard order of operations (such \
as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((a + b)\)\^2\)]],
  StyleBox[" in contrast to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a + b\^2\)]],
  StyleBox[").\n\n3. Arguments for functions (such as the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["N",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function in this case) must always be enclosed in square brackets [], not \
parentheses (which are used only as grouping symbols).\n\n4. Lists must \
always have their elements separated by commas. (Here the terms were \
multiplied, in the first instance, since a space implies multiplication.)\n\n\
",
    Evaluatable->False,
    AspectRatioFixed->True],
  "5. Of the three types of brackets, (), {}, and [], each type can only be \
used for\nthe specific use for which it is intended. Furthermore every left \
bracket must\nhave a matching right bracket of the same type."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Evaluate the following ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Input",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " cell. What error(s) does it have? Correct the error(s) to arrive at the \
intended input.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"Expand", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{"x", "+", "y"}], "}"}], "^", "2"}]}], ")"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.6 Help", "Section",
  Evaluatable->False,
  CellTags->{"a:0.7.0", "linkex"}],

Cell[TextData[{
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" has a sophisticated help facility called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Help Browser",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Function Browser",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for 2.2 users). The last item on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["\[CloseCurlyQuote]s menubar is the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Help",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" menu. Choose this and select the first item (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Help",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Ellipsis] in 3.x or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Open Function Browser",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\[Ellipsis] in 2.2). In the browser for version 2.2, you have the choice \
of reviewing the use of any names in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Built-in Functions",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Packages",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Loaded Packages",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" by pressing the appropriate button. (For ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Loaded Packages",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", first press the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Update",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " button.) In version 3.0 or later, the browser is much more sophisticated. \
In addition to the previous three categories, one can find the whole ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " book on-line, as well as an index to it and all the packages, in addition \
to other information. This browser is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " notebook and not just a static display device as in version 2.2. Try it \
out and find out for yourself. To learn more about the functions in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" in version 3.0 or higher, click on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Add-ons",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" button and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " should show up in the first column if a correct installation has been \
made (including a call to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rebuild Help Index",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the last item on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Help",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" menu).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Using the help facility, learn more about the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Expand",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function. What does this function do? (Hint: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Expand",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is a built-in function used for algebraic computations in basic \
algebra.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Another feature that occurs beginning in version 3.0 is the use of \
hyperlinks. By clicking on any underlined, blue text, one can be linked to \
another part of the ",
  ButtonBox["notebook",
    ButtonData:>"linkex",
    ButtonStyle->"Hyperlink"],
  " (or a different notebook altogether), the ",
  ButtonBox["main book",
    ButtonData:>"2.2.2",
    ButtonStyle->"MainBookLink"],
  " in the Help Browser, ",
  ButtonBox["package documentation",
    ButtonData:>"Introduction to AbstractAlgebra",
    ButtonStyle->"AddOnsLink"],
  " in the Help Browser, or even to a ",
  ButtonBox["web page",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["0.7 Using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to learn a mod idea",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  CellTags->"a:0.8.0"],

Cell["\<\
Above we saw that 26/3, 29/3, 23/3 and several other fractions all \
had one thing in common: the quotient had a decimal part returning .666667. \
In other words, on  division by three, the remainder was always two. Observe:\
\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"26", "==", 
      RowBox[{
        RowBox[{"8", "*", "3"}], "+", "2"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"29", "==", 
      RowBox[{
        RowBox[{"9", "*", "3"}], "+", "2"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"23", "==", 
      RowBox[{
        RowBox[{"7", "*", "3"}], "+", "2"}]}]], "Input"],

Cell[TextData[{
  StyleBox[
  "In each case, we see that the numbers 26, 29 and 23 have a remainder of \
two, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "on ",
  StyleBox[
  " division by 3. We can see this visually as well. First, select all the \
cells in the following subsection. (You do not need to open up the \
subsection, simply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["select",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " the outer harpoon bracket surrounding it.) Next, evaluate all these cells \
(type SHIFT/RETURN). This will define some functions we will be using. Now go \
to the next section.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell["\<\
Evaluate all cells in this subsection, if not done on  opening\
\>",
   "Subsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.0"],

Cell[CellGroupData[{

Cell["usage/messages", "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.1.0"],

Cell[BoxData[{
    \(Off[General::"\<spell\>", General::"\<spell1\>"]; 
    \n$FormatType\  = \ OutputForm; \nNeeds["\<Graphics`Colors`\>"]\), 
    \(\(IllustrateModReduction::"\<arg\>" = 
      "\<The first argument of  IllustrateModReduction must be an integer and \
the second must be a  positive integer.\>"; \)\), 
    \(\(IllustrateModAddition::"\<arg\>" = 
      "\<The first two arguments of  IllustrateModAddition must be integers \
and the third must be a  positive integer.\>"; \)\), 
    \(\(IllustrateModAddition::"\<usage\>" = 
      "\<IllustrateModAddition[a_, b_, n_] is a function which takes three \
integer arguments. The purpose of  the function is to illustrate how the \
number 'a' (first arg) is  added to 'b' (second arg) using modulo 'n' (third \
arg) arithmetic.  It draws bars of multiples of n and the remainders and \
regroups to  show the addition.\>"; \)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["IllustrateModReduction", "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.2.0"],

Cell[BoxData[{
    \(\(IllustrateModReduction[a_Integer, n_Integer?Positive, opts___] := 
      Show[computeModReduction[a, n, opts]]; \)\), 
    \(IllustrateModReduction[a_, n_, opts___] := 
      Message[IllustrateModReduction::"\<arg\>"]\), 
    \(\(Options[computeModReduction] = {showText \[Rule] True, 
        dotColor \[Rule] Blue}; \)\), 
    \(textPortionOfReduction[a_, n_, r_, q_] := 
      \((Print[a, "\< mod \>", n, "\< is \>", Mod[a, n], "\< since \>", a, 
          "\< = \>", Quotient[a, n], "\<*\>", n, "\< + \>", Mod[a, n], 
          "\<.\>"]; 
        Print["\<In other words, \>", a, "\< mod \>", n, 
          "\< is the remainder \>"]; 
        Print["\<on  division of \>", a, "\< by \>", n, "\<.\>"]; 
        If[a > 0, 
          Print["\<To illustrate, \>", "\<below \>", 
            If[q == 1, "\<is \>", "\<are \>"], q, "\< full column\>", 
            If[q =!= 1, "\<s\>", "\<\>"]]; 
          Print["\<of height \>", n, 
            If[r > 0, "\< and one column with height \>", "\<\>"], 
            If[r > 0, r, "\<\>"], "\<.\>"]; 
          If[r == 0, 
            Print["\<Since there is no remainder, \>", a, "\< mod \>", n, 
              "\< is 0.\>"], 
            Print["\<Since the remainder is \>", r, "\<, \>", a, "\< mod \>", 
              n, "\< is \>", r, "\<.\>"]]])\)\), 
    \(computeModReduction[a_, n_, opts___] := 
      Module[{r, q, showtext, dotcolor}, 
        SetOptions[Graphics, AspectRatio \[Rule] 1\/GoldenRatio]; 
        r = Mod[a, n]; q = Quotient[a, n]; 
        dotcolor = \(dotColor /. {opts}\) /. Options[computeModReduction]; 
        showtext = \(showText /. {opts}\) /. Options[computeModReduction]; 
        If[showtext, textPortionOfReduction[a, n, r, q]]; 
        If[q == 0, makeDots[1, 1, r, dotcolor, Yellow, 0.025], 
          If[r == 0, 
            makeDots[1, q, n, dotcolor, Red, 0.025, colLabels \[Rule] True], {
              makeDots[1, q, n, dotcolor, Red, 0.025, 
                colLabels \[Rule] True], 
              makeDots[q + 1.5, 1, r, dotcolor, Yellow, 0.025]}]]]\)}], 
  "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["IllustrateModAddition", "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.3.0"],

Cell[BoxData[{
    \(IllustrateModAddition[a_Integer, b_Integer, n_Integer?Positive] := 
      Module[{ra, rb, qa, qb}, 
        SetOptions[Graphics, AspectRatio \[Rule] 1\/GoldenRatio]; 
        ra = Mod[a, n]; qa = Quotient[a, n]; rb = Mod[b, n]; 
        qb = Quotient[b, n]; 
        Print["\<We wish to calculate \>", a, "\< mod \>", n, "\<  +  \>", b, 
          "\< mod \>", n, "\<.\>"]; 
        Print["\<To do so, we determine the quotients and remainders \
when\>"]; Print[a, "\< and \>", b, "\< are divided by \>", n, "\<.\>"]; 
        showStageOne[ra, rb, qa, qb, n]; 
        If[qa + qb > Max[qa, qb] && ra + rb > Max[ra, rb], 
          showStageTwo[ra, rb, qa, qb, n]]; 
        If[qa =!= 0 && qb =!= 0, showStageThree[ra, rb, qa, qb, n]]; 
        If[n > ra + rb, showStageFive[ra, rb, qa, qb, n], 
          showStageFour[ra, rb, qa, qb, n]; 
          showStageFive[ra, rb, qa, qb, n]]; ]\), 
    \(IllustrateModAddition[a_, b_, n_] := 
      Message[IllustrateModAddition::"\<arg\>"]\), 
    \(showStageOne[ra_, rb_, qa_, qb_, n_] := 
      Show[{makeDots[1, qa, n, Blue, Red, 0.025, colLabels \[Rule] True], 
          makeDots[1 + qa +  .5, 1, ra, Blue, Yellow, 0.025], 
          makeDots[1 + qa + 3, qb, n, Black, Red, 0.025, 
            colLabels \[Rule] True], 
          makeDots[1 + qa + 3 + qb +  .5, 1, rb, Black, Yellow, 0.025]}, 
        PlotLabel \[Rule] 
          ToString[qa\ n + ra]<>"\< = \>"<>ToString[qa]<>"\<*\>"<>
            ToString[n]<>"\< + \>"<>ToString[ra]<>"\< and \n\>"<>
            ToString[qb\ n + rb]<>"\< = \>"<>ToString[qb]<>"\<*\>"<>
            ToString[n]<>"\< + \>"<>ToString[rb]]\), 
    \(showStageTwo[ra_, rb_, qa_, qb_, n_] := 
      Show[{makeDots[1, qa, n, Blue, Red, 0.025, colLabels \[Rule] True], 
          makeDots[1 + qa + 1, qb, n, Black, Red, 0.025, 
            colLabels \[Rule] True], 
          makeDots[1 + qa + 1 + qb + 2, 1, ra, Blue, Yellow, 0.025], 
          makeDots[1 + qa + 1 + qb + 4, 1, rb, Black, Yellow, 0.025]}, 
        PlotLabel \[Rule] 
          "\<Combining our multiples of \>"<>ToString[n]<>
            "\<\nand our remainders...\>"]\), 
    \(showStageThree[ra_, rb_, qa_, qb_, n_] := 
      Show[{makeDots[1, qa, n, Blue, Red, 0.025, colLabels \[Rule] True], 
          makeDots[1 + qa, qb, n, Black, Red, 0.025, rowLabels \[Rule] False, 
            colLabels \[Rule] True, colStart \[Rule] 1 + qa], 
          makeDots[1 + qa + qb + 2, 1, ra, Blue, Yellow, 0.025], 
          makeDots[1 + qa + qb + 3.5, 1, rb, Black, Yellow, 0.025]}, 
        PlotLabel \[Rule] 
          "\<results in \>"<>ToString[qa + qb]<>"\< multiples of \>"<>
            ToString[n]<>"\<\nwith remainders \>"<>ToString[ra]<>"\< and \>"<>
            ToString[rb]<>"\<.\>"]\), 
    \(showStageFour[ra_, rb_, qa_, qb_, n_] := 
      Show[{makeDots[1, qa + qb, n, TurquoiseDark, Red, 0.025, 
            colLabels \[Rule] True], 
          makeDots[1 + qa + qb + 2, 1, Min[ra + rb, n], TurquoiseDark, 
            Yellow, 0.025], 
          makeDots[1 + qa + qb + 3.5, 1, ra + rb - n, TurquoiseDark, Yellow, 
            0.025]}, 
        PlotLabel \[Rule] 
          "\<Since the remainders add up to at\nleast \>"<>ToString[n]<>
            "\<, we form a multiple of \>"<>ToString[n]<>
            "\<\nand determine the new remainder.\>"]\), 
    \(showStageFive[ra_, rb_, qa_, qb_, n_] := 
      Show[{makeDots[1, qa + qb + Quotient[rb + ra, n], n, TurquoiseDark, 
            Red, 0.025, colLabels \[Rule] True], 
          makeDots[1 + qa + qb + 2, 1, Mod[ra + rb, n], TurquoiseDark, 
            Yellow, 0.025]}, 
        PlotLabel \[Rule] 
          "\<Finally, we have our multiples of \>"<>ToString[n]<>
            "\< and\nonly consider the remainder.\>"<>"\< Thus,\n\>"<>
            ToString[qa\ n + ra]<>"\< mod \>"<>ToString[n]<>"\<  +  \>"<>
            ToString[qb\ n + rb]<>"\< mod \>"<>ToString[n]<>"\<  =  \>"<>
            ToString[Mod[ra + rb, n]]<>"\< mod \>"<>ToString[n]]\)}], "Input",\

  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
core functions for IllustrateModReduction and IllustrateModAddition\
\
\>", "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.4.0"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"makeDots", "[", 
        RowBox[{
        "xStart_", ",", "width_", ",", "height_", ",", "dotcolor_", ",", 
          "backcolor_", ",", "dotsize_", ",", "opts___"}], "]"}], ":=", 
      RowBox[{"Module", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{"adj", "=", "0.4"}], ",", "i", ",", "j", ",", "crds", 
              ",", "bcrds", ",", "tcrds", ",", "rcrds", ",", "ccrds", ",", 
              "rl", ",", "cl", ",", "cs"}], "}"}], ",", 
          RowBox[{
            RowBox[{"rl", "=", 
              RowBox[{
                RowBox[{"rowLabels", "/.", 
                  RowBox[{"{", "opts", "}"}]}], "/.", 
                RowBox[{"Options", "[", "makeDots", "]"}]}]}], ";", 
            RowBox[{"cl", "=", 
              RowBox[{
                RowBox[{"colLabels", "/.", 
                  RowBox[{"{", "opts", "}"}]}], "/.", 
                RowBox[{"Options", "[", "makeDots", "]"}]}]}], ";", 
            RowBox[{"cs", "=", 
              RowBox[{
                RowBox[{"colStart", "/.", 
                  RowBox[{"{", "opts", "}"}]}], "/.", 
                RowBox[{"Options", "[", "makeDots", "]"}]}]}], ";", 
            RowBox[{"crds", "=", 
              RowBox[{"Table", "[", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{"i", "+", "xStart", "-", "1"}], ",", "j"}], 
                    "}"}], ",", 
                  RowBox[{"{", 
                    RowBox[{"i", ",", "width"}], "}"}], ",", 
                  RowBox[{"{", 
                    RowBox[{"j", ",", "height"}], "}"}]}], "]"}]}], ";", 
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{
                  RowBox[{"crds", "==", 
                    RowBox[{"{", "}"}]}], "||", 
                  RowBox[{"crds", "==", 
                    RowBox[{"{", 
                      RowBox[{"{", "}"}], "}"}]}]}], ",", 
                RowBox[{"nullGraphics", "[", "]"}], ",", 
                RowBox[{
                  RowBox[{"ccrds", "=", 
                    RowBox[{
                      RowBox[{"Last", "[", 
                        RowBox[{"Transpose", "[", "crds", "]"}], "]"}], "+", 
                      RowBox[{"Table", "[", 
                        RowBox[{
                          RowBox[{"{", 
                            RowBox[{"0", ",", "0.75"}], "}"}], ",", 
                          RowBox[{"{", "width", "}"}]}], "]"}]}]}], ";", 
                  RowBox[{"rcrds", "=", 
                    RowBox[{
                      RowBox[{"First", "[", "crds", "]"}], "+", 
                      RowBox[{"Table", "[", 
                        RowBox[{
                          RowBox[{"{", 
                            RowBox[{
                              RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
                          RowBox[{"{", "height", "}"}]}], "]"}]}]}], ";", 
                  RowBox[{"bcrds", "=", 
                    RowBox[{"First", "[", 
                      RowBox[{"Transpose", "[", "crds", "]"}], "]"}]}], ";", 
                  RowBox[{"tcrds", "=", 
                    RowBox[{"Last", "[", 
                      RowBox[{"Transpose", "[", "crds", "]"}], "]"}]}], ";", 
                  RowBox[{"rects", "=", 
                    RowBox[{"Table", "[", 
                      RowBox[{
                        RowBox[{"Rectangle", "[", 
                          RowBox[{
                            RowBox[{
                              RowBox[{
                              "bcrds", "\[LeftDoubleBracket]", "i", 
                                "\[RightDoubleBracket]"}], "+", 
                              RowBox[{"{", 
                                RowBox[{
                                  RowBox[{"-", "adj"}], ",", 
                                  RowBox[{"-", "adj"}]}], "}"}]}], ",", 
                            RowBox[{
                              RowBox[{
                              "tcrds", "\[LeftDoubleBracket]", "i", 
                                "\[RightDoubleBracket]"}], "+", 
                              RowBox[{"{", 
                                RowBox[{"adj", ",", "adj"}], "}"}]}]}], 
                          "]"}], ",", 
                        RowBox[{"{", 
                          RowBox[{"i", ",", "width"}], "}"}]}], "]"}]}], 
                  ";", 
                  RowBox[{"Graphics", "[", 
                    RowBox[{"{", 
                      RowBox[{
                        RowBox[{"If", "[", 
                          RowBox[{"rl", ",", 
                            RowBox[{"{", 
                              RowBox[{"Evaluate", "[", 
                                RowBox[{"Table", "[", 
                                  RowBox[{
                                    RowBox[{"Text", "[", 
                                      RowBox[{
                                        RowBox[{"ToString", "[", "i", "]"}], 
                                        ",", 
                                        RowBox[{
                                        "rcrds", "\[LeftDoubleBracket]", "i", 
                                        "\[RightDoubleBracket]"}], ",", 
                                        RowBox[{"{", 
                                        RowBox[{"1", ",", "0"}], "}"}]}], 
                                      "]"}], ",", 
                                    RowBox[{"{", 
                                      RowBox[{"i", ",", "height"}], "}"}]}], 
                                  "]"}], "]"}], "}"}], ",", 
                            RowBox[{"nullPreGraphics", "[", "]"}]}], "]"}], 
                        ",", 
                        RowBox[{"If", "[", 
                          RowBox[{"cl", ",", 
                            RowBox[{"{", 
                              RowBox[{"Evaluate", "[", 
                                RowBox[{"Table", "[", 
                                  RowBox[{
                                    RowBox[{"Text", "[", 
                                      RowBox[{
                                        RowBox[{"ToString", "[", 
                                        RowBox[{"i", "+", "cs", "-", "1"}], 
                                        "]"}], ",", 
                                        RowBox[{
                                        "ccrds", "\[LeftDoubleBracket]", "i", 
                                        "\[RightDoubleBracket]"}], ",", 
                                        RowBox[{"{", 
                                        RowBox[{"0", ",", "0"}], "}"}]}], 
                                      "]"}], ",", 
                                    RowBox[{"{", 
                                      RowBox[{"i", ",", "width"}], "}"}]}], 
                                  "]"}], "]"}], "}"}], ",", 
                            RowBox[{"nullPreGraphics", "[", "]"}]}], "]"}], 
                        ",", 
                        RowBox[{"{", 
                          RowBox[{"backcolor", ",", "rects"}], "}"}], ",", 
                        RowBox[{"{", 
                          RowBox[{
                            RowBox[{"PointSize", "[", "dotsize", "]"}], ",", 
                            "dotcolor", ",", 
                            RowBox[{"Point", "/@", 
                              RowBox[{"Flatten", "[", 
                                RowBox[{"crds", ",", "1"}], "]"}]}]}], 
                          "}"}]}], "}"}], "]"}]}]}], "]"}]}]}], "]"}]}], 
    RowBox[{
      RowBox[{
        RowBox[{"Options", "[", "makeDots", "]"}], "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"rowLabels", "\[Rule]", "True"}], ",", 
            RowBox[{"colLabels", "\[Rule]", "False"}], ",", 
            RowBox[{"colStart", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
    RowBox[{
      RowBox[{"nullGraphics", "[", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
        RowBox[{"{", 
          RowBox[{"White", ",", 
            RowBox[{"Rectangle", "[", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
    RowBox[{
      RowBox[{"nullPreGraphics", "[", "]"}], ":=", 
      RowBox[{"{", 
        RowBox[{"White", ",", 
          RowBox[{"Rectangle", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]}], "Input",\

  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Continue on in this subsection", "Subsection",
  Evaluatable->False,
  CellTags->"a:0.8.2.0"],

Cell["\<\
By evaluating the cell below, you can see why 2 is the remainder of \
26 on  division by 3.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"IllustrateModReduction", "[", 
        RowBox[{"26", ",", "3"}], "]"}], ";"}]], "Input"],

Cell[TextData[{
  StyleBox[
  "Note that the word \[OpenCurlyDoubleQuote]mod\[CloseCurlyDoubleQuote] is \
used in the function name. We say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`26\ mod\ 3\)]],
  StyleBox[" is 2 because 2 is the remainder when 26 is divided by 3. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" can compute this directly.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"Mod", "[", 
      RowBox[{"26", ",", "3"}], "]"}]], "Input"],

Cell["\<\
Note that each of 29, 26 and 23, when reduced modulo 3, results in \
the value 2.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"Mod", "[", 
          RowBox[{"29", ",", "3"}], "]"}], ",", 
        RowBox[{"Mod", "[", 
          RowBox[{"26", ",", "3"}], "]"}], ",", 
        RowBox[{"Mod", "[", 
          RowBox[{"23", ",", "3"}], "]"}]}], "}"}]], "Input"],

Cell["\<\
In other words, 2 is the remainder when 29 is divided by 3 and when \
23 is divided by 3. These can be seen visually as well; evaluate one or both \
of the following.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"IllustrateModReduction", "[", 
        RowBox[{"29", ",", "3"}], "]"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"IllustrateModReduction", "[", 
        RowBox[{"23", ",", "3"}], "]"}], ";"}]], "Input"],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine the values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"22", " ", "mod", " ", "3"}], TraditionalForm]]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"25", " ", "mod", " ", "3"}], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"28", " ", "mod", " ", "3"}], TraditionalForm]]],
  StyleBox[" using either the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mod",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function or the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["IllustrateModReduction",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function. What do these three values have in common? How are 22, 25 and \
28 related to each other?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine the values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"21", " ", "mod", " ", "3"}], TraditionalForm]]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"24", " ", "mod", " ", "3"}], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"27", " ", "mod", " ", "3"}], TraditionalForm]]],
  StyleBox[" using either the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mod",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function or the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["IllustrateModReduction",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function. What do these three values have in common? How are 21, 24 and \
27 related to each other?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.8 Divide and conquer", "Section",
  Evaluatable->False,
  CellTags->"a:0.9.0"],

Cell[TextData[{
  StyleBox[
  "Select the input cell below. After evaluating it, come back here and \
finish reading this text. There are some mathematical observations to make, \
as well some ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" observations. First, note that this is showing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\ mod\ 3\)]],
  StyleBox[" for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[
  " running from 18 to 28. As you look at the value of this (the value of the \
remainder of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[
  " divided by 3, which is also the height of the yellow rectangle), note how \
it cycles through 0 to 1 to 2 to 0 to 1 to 2 and so on. Do you know why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox[
"Second, note that all the graphics are each in their own cell but there is \
also one cell that surrounds the whole collection of graphics. Put the cursor \
over this surrounding bracket and double-click. This will close up and hide \
the nested cells with only the first one showing. If you now double-click on \
the top graphic, an animation should take place. Since the motion may be \
going too fast, you may want to know how to adjust it. Typing any number from \
1 to 9 adjusts the speed (1 slow and 9 fast), while pressing an up-arrow or \
down-arrow key causes one step to be taken in the specified direction. Try \
it.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"Do", "[", 
      RowBox[{
        RowBox[{"IllustrateModReduction", "[", 
          RowBox[{"k", ",", "3", ",", 
            RowBox[{"showText", "\[Rule]", "False"}]}], "]"}], ",", 
        RowBox[{"{", 
          RowBox[{"k", ",", "18", ",", "28"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
  StyleBox["For each of the cases where the remainder is zero (ie., ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\ mod\ 3\  = \ 0\)]],
  StyleBox["), observe that this happens because 3 is a divisor of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[". Mathematically, we say \[OpenCurlyDoubleQuote]3 divides ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox["\[CloseCurlyDoubleQuote] and denote this by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3\  | \ k\)]],
  StyleBox[". Consider ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\  = \ 24\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\  = \ 30\)]],
  StyleBox[
  ". In both cases we have 3 as a divisor. There are, however, other divisors \
of each. In previous course-work, you may have encountered the notion of the \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["greatest common divisor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ", or gcd. In this case, the gcd of 24 and 30, frequently denoted gcd(24, \
30) or simply (24, 30), is actually 6. Here is how we get ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to confirm this. (Note the capital letters.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"GCD", "[", 
      RowBox[{"24", ",", "30"}], "]"}]], "Input"],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the gcd of 242652 and 3054876?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Suppose we consider the problem of determining the gcd of two fairly large \
numbers, say ",
  Cell[BoxData[
      FormBox[
        RowBox[{"a", " ", "=", " ", "1234567891011121314"}], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"b", " ", "=", " ", "1413121110987654321"}], 
        TraditionalForm]]],
  ". "
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    RowBox[{"a", "=", "1234567891011121314"}], 
    RowBox[{"b", "=", "1413121110987654321"}]}], "Input"],

Cell[TextData[{
  StyleBox["We will pursue the gcd in two ways. First, we will find ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["all",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" the divisors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["a", TraditionalForm]]],
  StyleBox[" (and record how much time this took).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"divisorsOfa", "=", 
      RowBox[{"Timing", "[", 
        RowBox[{"Divisors", "[", "a", "]"}], "]"}]}]], "Input"],

Cell[TextData[{
  StyleBox["And then do the same for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["b", TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"divisorsOfb", "=", 
      RowBox[{"Timing", "[", 
        RowBox[{"Divisors", "[", "b", "]"}], "]"}]}]], "Input"],

Cell[TextData[{
  StyleBox[
  "Next we take the intersection of the lists of divisors and ask for the \
maximum value. (Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["divisorsOfa",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["divisorsOfb",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " consist of a list containing both the time and the list of divisors. \
Since we want the second part, the list of divisors, we specify this by using \
the notation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["div",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["isorsOf",
    FontFamily->"Courier"],
  StyleBox["a[[2]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"max", "=", 
      RowBox[{"Timing", "[", 
        RowBox[{"Max", "[", 
          RowBox[{"Intersection", "[", 
            RowBox[{
              RowBox[{
              "divisorsOfa", "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}], ",", 
              RowBox[{
              "divisorsOfb", "\[LeftDoubleBracket]", "2", 
                "\[RightDoubleBracket]"}]}], "]"}], "]"}], "]"}]}]], "Input"],

Cell["\<\
We see that the gcd is 3. How much time did this take? We can add \
up the amounts found in the first part of each result.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"totalTime", "=", 
      RowBox[{
        RowBox[{
        "divisorsOfa", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}], "+", 
        RowBox[{
        "divisorsOfb", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}], "+", 
        RowBox[{
        "max", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]], 
  "Input"],

Cell[TextData[
"Now let\[CloseCurlyQuote]s see how long it takes for the GCD function?"], 
  "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"Timing", "[", 
      RowBox[{"GCD", "[", 
        RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input"],

Cell[TextData[{
  StyleBox["Is this surprising? The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GCD",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function did not use any previous results to enable it to be this fast, \
but rather the method of calculating the gcd happens to be a very fast \
algorithm called the Euclidean Algorithm. Hopefully, you will be learning \
more about this algorithm in this course; we will see it in this suite of \
labs when we study polynomial rings in Ring Lab 6. If you increase the number \
of digits in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" by only a few, the time difference will be even more dramatic.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["0.9 It all adds up", "Section",
  Evaluatable->False,
  CellTags->"a:0.10.0"],

Cell[TextData[{
  "Earlier we saw how the values of ",
  Cell[BoxData[
      \(TraditionalForm\`k\ mod\ 3\)]],
  " (",
  StyleBox["Mod[",
    FontFamily->"Courier"],
  StyleBox["k",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[", 3]",
    FontFamily->"Courier"],
  ") are 0, 1 or 2."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"Table", "[", 
      RowBox[{
        RowBox[{"Mod", "[", 
          RowBox[{"k", ",", "3"}], "]"}], ",", 
        RowBox[{"{", 
          RowBox[{"k", ",", "18", ",", "28"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
  "A question that algebraists ask in such a situation is \
\[OpenCurlyDoubleQuote]Does the set {0, 1, 2} have any other structure?\
\[CloseCurlyDoubleQuote] In other words, is there a natural operation that \
may exist between, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`14\ mod\ 3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`16\ mod\ 3\)]],
  "? In particular, does this answer have anything to do with ",
  Cell[BoxData[
      \(TraditionalForm\`30\ mod\ 3\)]],
  "?"
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    RowBox[{"Mod", "[", 
      RowBox[{"14", ",", "3"}], "]"}], 
    RowBox[{"Mod", "[", 
      RowBox[{"16", ",", "3"}], "]"}], 
    RowBox[{"Mod", "[", 
      RowBox[{"30", ",", "3"}], "]"}]}], "Input"],

Cell["This can be illustrated visually below.", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"IllustrateModAddition", "[", 
      RowBox[{"14", ",", "16", ",", "3"}], "]"}]], "Input"],

Cell[TextData[{
  "Note that (",
  Cell[BoxData[
      \(TraditionalForm\`14\ mod\ 3\)]],
  ") plus (",
  Cell[BoxData[
      \(TraditionalForm\`14\ mod\ 3\)]],
  ") (ie., 2 \[OpenCurlyDoubleQuote]plus\[CloseCurlyDoubleQuote] 2) yields 1, \
which is also ",
  Cell[BoxData[
      \(TraditionalForm\`28\ mod\ 3\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    RowBox[{"Mod", "[", 
      RowBox[{"14", ",", "3"}], "]"}], 
    RowBox[{"Mod", "[", 
      RowBox[{"14", ",", "3"}], "]"}], 
    RowBox[{"Mod", "[", 
      RowBox[{"28", ",", "3"}], "]"}]}], "Input"],

Cell[BoxData[
    RowBox[{"IllustrateModAddition", "[", 
      RowBox[{"14", ",", "14", ",", "3"}], "]"}]], "Input"],

Cell["\<\
The collection of values where the integers are reduced by some \
modulus (3 in this example) forms a very interesting structure for \
algebraists. Much more will be said about this in the future.\
\>", "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["0.10 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  CellTags->"a:0.11.0"],

Cell[TextData[{
  StyleBox["If you wish to learn more about how to use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " commands or functions used in this lab, type ? followed by the command. \
Below are some used in this lab that may be useful for later work.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{"?", "N"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Map"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Range"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Expand"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Mod"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "GCD"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Divisors"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Timing"}]], "Input"],

Cell[BoxData[
    RowBox[{"?", "Table"}]], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 422},
WindowMargins->{{7, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:0.0"->{
    Cell[2401, 77, 296, 11, 106, "Title",
      Evaluatable->False,
      CellTags->"a:0.0"]},
  "a:0.1.0"->{
    Cell[5905, 177, 297, 10, 55, "Section",
      Evaluatable->False,
      CellTags->"a:0.1.0"]},
  "a:0.2.0"->{
    Cell[10174, 320, 81, 2, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.2.0"]},
  "a:0.3.0"->{
    Cell[10373, 330, 86, 2, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.3.0"]},
  "a:0.4.0"->{
    Cell[10901, 351, 400, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.4.0"]},
  "a:0.5.0"->{
    Cell[19213, 635, 83, 2, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.5.0"]},
  "a:0.5.1.0"->{
    Cell[19321, 641, 112, 2, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:0.5.1.0"]},
  "a:0.5.1.1.0"->{
    Cell[19458, 647, 109, 2, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:0.5.1.1.0"]},
  "a:0.6.0"->{
    Cell[19714, 659, 86, 2, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.6.0"]},
  "a:0.7.0"->{
    Cell[25110, 839, 84, 2, 35, "Section",
      Evaluatable->False,
      CellTags->{"a:0.7.0", "linkex"}]},
  "linkex"->{
    Cell[25110, 839, 84, 2, 35, "Section",
      Evaluatable->False,
      CellTags->{"a:0.7.0", "linkex"}]},
  "a:0.8.0"->{
    Cell[31110, 1046, 344, 13, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.8.0"]},
  "a:0.8.1.0"->{
    Cell[32883, 1112, 142, 5, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:0.8.1.0"]},
  "a:0.8.1.1.0"->{
    Cell[33050, 1121, 88, 2, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:0.8.1.1.0"]},
  "a:0.8.1.2.0"->{
    Cell[34106, 1145, 96, 2, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:0.8.1.2.0"]},
  "a:0.8.1.3.0"->{
    Cell[36350, 1194, 95, 2, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:0.8.1.3.0"]},
  "a:0.8.1.4.0"->{
    Cell[40504, 1275, 151, 5, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:0.8.1.4.0"]},
  "a:0.8.2.0"->{
    Cell[49364, 1471, 99, 2, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:0.8.2.0"]},
  "a:0.9.0"->{
    Cell[53965, 1644, 86, 2, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.9.0"]},
  "a:0.10.0"->{
    Cell[63359, 1956, 83, 2, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.10.0"]},
  "a:0.11.0"->{
    Cell[65962, 2053, 346, 13, 35, "Section",
      Evaluatable->False,
      CellTags->"a:0.11.0"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:0.0", 68403, 2143},
  {"a:0.1.0", 68513, 2147},
  {"a:0.2.0", 68627, 2151},
  {"a:0.3.0", 68740, 2155},
  {"a:0.4.0", 68853, 2159},
  {"a:0.5.0", 68968, 2163},
  {"a:0.5.1.0", 69083, 2167},
  {"a:0.5.1.1.0", 69206, 2171},
  {"a:0.6.0", 69330, 2175},
  {"a:0.7.0", 69443, 2179},
  {"linkex", 69567, 2183},
  {"a:0.8.0", 69692, 2187},
  {"a:0.8.1.0", 69810, 2191},
  {"a:0.8.1.1.0", 69934, 2195},
  {"a:0.8.1.2.0", 70062, 2199},
  {"a:0.8.1.3.0", 70190, 2203},
  {"a:0.8.1.4.0", 70318, 2207},
  {"a:0.8.2.0", 70445, 2211},
  {"a:0.9.0", 70564, 2215},
  {"a:0.10.0", 70679, 2219},
  {"a:0.11.0", 70795, 2223}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 94, 3, 47, "Answer",
  Evaluatable->False],
Cell[1806, 54, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2401, 77, 296, 11, 106, "Title",
  Evaluatable->False,
  CellTags->"a:0.0"],
Cell[2700, 90, 1510, 46, 204, "Text",
  Evaluatable->False],
Cell[4213, 138, 1667, 35, 242, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5905, 177, 297, 10, 55, "Section",
  Evaluatable->False,
  CellTags->"a:0.1.0"],
Cell[6205, 189, 776, 19, 109, "Text",
  Evaluatable->False],
Cell[6984, 210, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[8354, 252, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[8506, 257, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[9128, 279, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[9820, 305, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10174, 320, 81, 2, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.2.0"],
Cell[10258, 324, 78, 1, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10373, 330, 86, 2, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.3.0"],
Cell[10462, 334, 402, 12, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10901, 351, 400, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.4.0"],
Cell[11304, 367, 136, 4, 33, "Text",
  Evaluatable->False],
Cell[11443, 373, 332, 11, 67, "Question",
  Evaluatable->False],
Cell[11778, 386, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[11829, 389, 1538, 49, 128, "Text",
  Evaluatable->False],
Cell[13370, 440, 51, 1, 42, "Input"],
Cell[13424, 443, 1156, 37, 112, "Text",
  Evaluatable->False],
Cell[14583, 482, 670, 21, 74, "Text",
  Evaluatable->False],
Cell[15256, 505, 381, 11, 42, "Input"],
Cell[15640, 518, 369, 11, 67, "Question",
  Evaluatable->False],
Cell[16012, 531, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[16063, 534, 213, 6, 42, "Input"],
Cell[16279, 542, 1091, 27, 147, "Text",
  Evaluatable->False],
Cell[17373, 571, 482, 13, 86, "Question",
  Evaluatable->False],
Cell[17858, 586, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[17909, 589, 920, 28, 105, "Question",
  Evaluatable->False],
Cell[18832, 619, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[18883, 622, 293, 8, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[19213, 635, 83, 2, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.5.0"],

Cell[CellGroupData[{
Cell[19321, 641, 112, 2, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:0.5.1.0"],

Cell[CellGroupData[{
Cell[19458, 647, 109, 2, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.5.1.1.0"],
Cell[19570, 651, 83, 1, 33, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19714, 659, 86, 2, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.6.0"],
Cell[19803, 663, 120, 4, 33, "Text",
  Evaluatable->False],
Cell[19926, 669, 213, 6, 42, "Input"],
Cell[20142, 677, 439, 12, 71, "Text",
  Evaluatable->False],
Cell[20584, 691, 324, 9, 42, "Input"],
Cell[20911, 702, 340, 9, 27, "Input"],
Cell[21254, 713, 319, 9, 42, "Input"],
Cell[21576, 724, 604, 16, 43, "Input"],
Cell[22183, 742, 369, 10, 27, "Input"],
Cell[22555, 754, 1789, 50, 337, "Text",
  Evaluatable->False],
Cell[24347, 806, 500, 18, 67, "Question",
  Evaluatable->False],
Cell[24850, 826, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[24901, 829, 172, 5, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[25110, 839, 84, 2, 35, "Section",
  Evaluatable->False,
  CellTags->{"a:0.7.0", "linkex"}],
Cell[25197, 843, 4358, 145, 261, "Text",
  Evaluatable->False],
Cell[29558, 990, 725, 25, 67, "Question",
  Evaluatable->False],
Cell[30286, 1017, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[30337, 1020, 736, 21, 90, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[31110, 1046, 344, 13, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.8.0"],
Cell[31457, 1061, 272, 6, 71, "Text",
  Evaluatable->False],
Cell[31732, 1069, 110, 3, 27, "Input"],
Cell[31845, 1074, 110, 3, 27, "Input"],
Cell[31958, 1079, 110, 3, 27, "Input"],
Cell[32071, 1084, 787, 24, 109, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[32883, 1112, 142, 5, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.0"],

Cell[CellGroupData[{
Cell[33050, 1121, 88, 2, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.1.0"],
Cell[33141, 1125, 928, 15, 267, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[34106, 1145, 96, 2, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.2.0"],
Cell[34205, 1149, 2108, 40, 484, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[36350, 1194, 95, 2, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.3.0"],
Cell[36448, 1198, 4019, 72, 965, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[40504, 1275, 151, 5, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:0.8.1.4.0"],
Cell[40658, 1282, 8657, 183, 379, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[49364, 1471, 99, 2, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:0.8.2.0"],
Cell[49466, 1475, 137, 4, 33, "Text",
  Evaluatable->False],
Cell[49606, 1481, 130, 3, 27, "Input"],
Cell[49739, 1486, 610, 19, 52, "Text",
  Evaluatable->False],
Cell[50352, 1507, 87, 2, 27, "Input"],
Cell[50442, 1511, 127, 4, 33, "Text",
  Evaluatable->False],
Cell[50572, 1517, 293, 8, 27, "Input"],
Cell[50868, 1527, 212, 5, 52, "Text",
  Evaluatable->False],
Cell[51083, 1534, 130, 3, 27, "Input"],
Cell[51216, 1539, 130, 3, 27, "Input"],
Cell[51349, 1544, 1231, 43, 86, "Question",
  Evaluatable->False],
Cell[52583, 1589, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[52634, 1592, 1231, 43, 86, "Question",
  Evaluatable->False],
Cell[53868, 1637, 48, 1, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[53965, 1644, 86, 2, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.9.0"],
Cell[54054, 1648, 1107, 34, 109, "Text",
  Evaluatable->False],
Cell[55164, 1684, 734, 12, 147, "Text",
  Evaluatable->False],
Cell[55901, 1698, 303, 7, 27, "Input"],
Cell[56207, 1707, 1779, 54, 128, "Text",
  Evaluatable->False],
Cell[57989, 1763, 88, 2, 27, "Input"],
Cell[58080, 1767, 254, 9, 48, "Question",
  Evaluatable->False],
Cell[58337, 1778, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[58388, 1781, 405, 14, 52, "Text",
  Evaluatable->False],
Cell[58796, 1797, 120, 2, 43, "Input"],
Cell[58919, 1801, 514, 17, 52, "Text",
  Evaluatable->False],
Cell[59436, 1820, 140, 3, 27, "Input"],
Cell[59579, 1825, 265, 10, 33, "Text",
  Evaluatable->False],
Cell[59847, 1837, 140, 3, 27, "Input"],
Cell[59990, 1842, 1058, 37, 90, "Text",
  Evaluatable->False],
Cell[61051, 1881, 449, 11, 27, "Input"],
Cell[61503, 1894, 168, 4, 52, "Text",
  Evaluatable->False],
Cell[61674, 1900, 390, 11, 27, "Input"],
Cell[62067, 1913, 122, 3, 33, "Text",
  Evaluatable->False],
Cell[62192, 1918, 125, 3, 27, "Input"],
Cell[62320, 1923, 1002, 28, 109, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[63359, 1956, 83, 2, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.10.0"],
Cell[63445, 1960, 336, 14, 33, "Text",
  Evaluatable->False],
Cell[63784, 1976, 227, 6, 27, "Input"],
Cell[64014, 1984, 547, 15, 71, "Text",
  Evaluatable->False],
Cell[64564, 2001, 219, 6, 59, "Input"],
Cell[64786, 2009, 77, 1, 33, "Text",
  Evaluatable->False],
Cell[64866, 2012, 116, 2, 27, "Input"],
Cell[64985, 2016, 354, 13, 33, "Text",
  Evaluatable->False],
Cell[65342, 2031, 219, 6, 59, "Input"],
Cell[65564, 2039, 116, 2, 27, "Input"],
Cell[65683, 2043, 242, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[65962, 2053, 346, 13, 35, "Section",
  Evaluatable->False,
  CellTags->"a:0.11.0"],
Cell[66311, 2068, 479, 14, 71, "Text",
  Evaluatable->False],
Cell[66793, 2084, 47, 1, 27, "Input"],
Cell[66843, 2087, 49, 1, 27, "Input"],
Cell[66895, 2090, 51, 1, 27, "Input"],
Cell[66949, 2093, 52, 1, 27, "Input"],
Cell[67004, 2096, 49, 1, 27, "Input"],
Cell[67056, 2099, 49, 1, 27, "Input"],
Cell[67108, 2102, 54, 1, 27, "Input"],
Cell[67165, 2105, 52, 1, 27, "Input"],
Cell[67220, 2108, 51, 1, 27, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

