(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3839,        107]*)
(*NotebookOutlinePosition[      5379,        161]*)
(*  CellTagsIndexPosition[      5303,        155]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\(Galois\ field\)\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with Galois fields"]},
        {
          ButtonBox[\(AdditiveToMult ... \),
            ButtonData:>RowBox[ {"AdditiveToMultiplicative", "[", 
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]"}], 
                "]"}],
            ButtonNote->"convert add. form to mult."]},
        {
          ButtonBox[\(FieldIrreducible[\[SelectionPlaceholder]]\),
            ButtonNote->"return irreducible poly used"]},
        {
          ButtonBox[\(GF[\[SelectionPlaceholder]]\),
            ButtonNote->"p^n  Galois field"]},
        {
          ButtonBox[\(GF[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"p, n  Galois field"]},
        {
          ButtonBox[\(MultiplicativeToAdd ... \),
            ButtonData:>RowBox[ {"MultiplicativeToAdditive", "[", 
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]"}], 
                "]"}],
            ButtonNote->"convert mult. form to add."]},
        {
          ButtonBox[\(PrimitivePolynomials[\[SelectionPlaceholder]]\),
            ButtonNote->"all prim. polynomials"]},
        {
          ButtonBox[\(TableOfPowers[\[SelectionPlaceholder]]\),
            ButtonNote->"convert add. form to mult."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  CellTags->"GaloisField"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
Editable->False,
WindowToolbars->{},
PageWidth->399,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 6}, {14, Automatic}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "GaloisField"->{
    Cell[1710, 49, 2125, 56, 143, NotebookDefault,
      Evaluatable->True,
      CellGroupingRules->"InputGrouping",
      PageBreakAbove->True,
      PageBreakWithin->False,
      CounterIncrements->"Input",
      CellTags->"GaloisField"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"GaloisField", 5035, 143}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 2125, 56, 143, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input",
  CellTags->"GaloisField"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

