(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10039,        218]*)
(*NotebookOutlinePosition[     11057,        253]*)
(*  CellTagsIndexPosition[     10983,        247]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Permutation Specifier", "Title"],

Cell["\<\
This tool allows you to easily construct permutations by filling in \
empty boxes, either by typing or clicking. To continue, click on the button \
below.\
\>", "Text"],

Cell[BoxData[
    ButtonBox[\(use\ the\ permutation\ specifier\ tool\),
      ButtonFunction:>CompoundExpression[ 
          NotebookFind[ 
          ButtonNotebook, "evaluate", All, CellTags, AutoScroll -> False], 
          SelectionEvaluate[ ButtonNotebook, After]],
      ButtonEvaluator->Automatic,
      ButtonStyle->None]], "Input",
  Active->True],

Cell[CellGroupData[{

Cell["Code (which is evaluated by button above)", "Section"],

Cell[BoxData[{
    \(continueButton\  := \ 
      Module[{n, nb, \ mat}, \n\t
        n\  = \ Input["\<How many vertices are there on your figure?\>"]; \n\t
        nb\  = \ ButtonNotebook; \n\t
        NotebookFind[nb, "\<cont\>", All, CellTags, \ 
          AutoScroll\  -> \ False]; \n\t
        SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n\t
        LastPermName\  = \ ToString[Unique[permq]]; \n
        NotebookWrite[nb, 
          Cell["\<For each box, select it and either type in a number or \
click on the button with the appropriate number. Tab will take you to the \
next box.\>", "\<Text\>"]]; \n\t
        mat\  = \ {Prepend[Range[1, n], "\<vertex #\>"], 
            Prepend[Table["\<\[DoubleDownArrow]\>", {n}], "\<goes to\>"], 
            Prepend[Table["\<\[Placeholder]\>", {n}], "\<vertex #\>"]}; \n\t
        SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n\t
        NotebookWrite[nb, 
          Cell[BoxData[
              RowBox[{GridBox[mat, GridFrame -> True, \n\ \ \ \ \ \ \ \ 
                    ColumnLines -> True]}]], "\<Text\>", \ 
            CellTags\  -> \ LastPermName, TextAlignment\  -> \ Center]]; \n\t
        SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n\t
        NotebookWrite[nb, 
          Cell[BoxData[
              RowBox[Map[ButtonBox[#, ButtonStyle\  -> \ "\<Paste\>"]&, 
                  Range[1, n]]]], "\<Input\>", \ Active\  -> \ True, 
            TextAlignment\  -> \ Center]]; \n\t
        SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n\t\t
        NotebookWrite[nb, 
          Cell[BoxData[\n\ \ \ \ 
              ButtonBox["\<click when ready to define the permutation\>", \n
                \ \ \ \ \ \ ButtonFunction :> definePerm, \n\ \ \ \ \ \ 
                ButtonEvaluator -> "\<Local\>"]], \ "\<Input\>", \n\ \ 
            Active -> True]]; NumberOfVertices\  = \ n; \n\t]\n\), 
    \(definePerm\  := \ 
      Module[{ok, nb, \ perm, \ n\  = \ NumberOfVertices}, \n\t
        nb\  = \ ButtonNotebook; \n\t
        NotebookFind[nb, LastPermName, All, CellTags, \ 
          AutoScroll\  -> \ False]; \n\t
        SelectionMove[nb, All, Cell, \ AutoScroll\  -> \ False]; \n\t\t
        myCell\  = \ NotebookRead[nb]; \n\t\t
        perm\  = \ Drop[myCell[[1, 1, 1, 3]], 1]; \n\t\t
        perm\  = \ Map[ToExpression, perm]; \n\t\t
        ok\  = \ TestPermutationQ[perm]; \n\t
        SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n\t
        NotebookWrite[nb, Cell["\<You entered\>", "\<Text\>"]]; \n\t\t
        NotebookWrite[nb, 
          Cell[ToString[perm], "\<Text\>", TextAlignment\  -> \ Center]]; \n\t
        NotebookWrite[nb, Cell["\<as your permutation. \>", "\<Text\>"]]; \n
        \t\tIf[Not[PermutationQ[perm]], \n\t\t\t\t
          NotebookWrite[nb, 
            Cell[StringJoin[
                "\<This does not, however, represent a permutation on \>", 
                ToString[n], "\< vertices. \>"], "\<Text\>"]], \n\t\t\t
          If[ok, NotebookWrite[nb, 
              Cell["\<This represents a valid permutation for this \
figure.\>", "\<Text\>"]], 
            NotebookWrite[nb, 
              Cell["\<While this does represent a permutation, it is not a \
permutation representing a symmetry of this figure.\>", "\<Text\>"]]]\n
          \t\t\t]; \n\t\t
        junk349\  := 
          \((\n\t\t\t\t\t
            SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n
            \t\t\t\t\t
            NotebookWrite[nb, 
              Cell[BoxData[\n\ \ \ \ 
                  RowBox[{"\<ShowPermutation\>", \ "\<[\>", \ ToString[perm], 
                      \ "\<]\>"}]], \ "\<Input\>"], \ All]; \n\t\t\t\t
            SelectionEvaluate[nb, After]\n\t\t)\); \n\t\t
        junk348\  := 
          \((SelectionMove[nb, After, Notebook, \ AutoScroll\  -> \ False]; \n
            \t\t\t\t\t
            NotebookWrite[nb, 
              Cell[BoxData[\n\ \ \ \ 
                  RowBox[{"\<AddPermToGroup\>", \ "\<[\>", \ ToString[perm], 
                      \ "\<]\>"}]], \ "\<Input\>"], \ All]; \n\t\t\t\t
            SelectionEvaluate[nb, After]\n\t\t)\); \n\t\t\t
        NotebookWrite[nb, 
          Cell["\<Choose one (or more) of the following three options.\>", 
            "\<Text\>"]]; \n\t\t\t
        NotebookWrite[nb, 
          Cell[BoxData[
              GridBox[{\n
                  \ \ \ \ \ \ \ \ {\n\ \ \ \ \ \ \ \ \ \ 
                    ButtonBox[\n\ \ \ \ \ \ \ \ \ \ \ \ 
                      RowBox[{\n\ \ \ \ \ \ \ \ \ \ \ \ "\<apply\>", \ 
                          "\< \>", \ "\<ShowPermutation\>", \ "\< \>", \ 
                          "\<to\>", \ "\< \>", \ "\<this\>", \ "\< \>", \ \n
                          \ \ \ \ \ \ \ \ \ \ \ \ \ \ "\<permutation\>"}], \ 
                      ButtonFunction :> junk349, \ 
                      ButtonEvaluator\  -> \ Local]}, \n
                  \ \ \ \ \ \ \ \ {\n\ \ \ \ \ \ \ \ \ \ 
                    ButtonBox[\n\ \ \ \ \ \ \ \ \ \ \ \ 
                      RowBox[{\n\ \ \ \ \ \ \ \ \ \ \ \ "\<add\>", \ "\< \>", 
                          \ "\<this\>", \ "\< \>", \ "\<permutation\>", \ 
                          "\< \>", \ "\<to\>", \ "\< \>", \ "\<the\>", \ \n
                          \ \ \ \ \ \ \ \ \ \ \ \ \ \ "\< \>", \ "\<list\>", 
                          \ "\< \>", \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                          RowBox[{"\<(\>", \ "\<group\>", \ "\<)\>"}]}], \n
                      \ \ \ \ \ \ \ \ \ \ \ \ \ \ ButtonFunction :> junk348, 
                      \ ButtonEvaluator\  -> \ Local]}, \n
                  \ \ \ \ \ \ \ \ {\n\ \ \ \ \ \ \ \ \ \ 
                    ButtonBox[\n\ \ \ \ \ \ \ \ \ \ \ \ 
                      RowBox[{\n\ \ \ \ \ \ \ \ \ \ \ \ "\<use\>", \ "\< \>", 
                          \ "\<this\>", \ "\< \>", \ "\<approach\>", \ 
                          "\< \>", \ "\<to\>", \ "\< \>", \ "\<determine\>", 
                          \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ "\< \>", \ 
                          "\<another\>", \ "\< \>", \ "\<permutation\>"}], \n
                      \ \ \ \ \ \ \ \ \ \ \ \ 
                      ButtonFunction :> continueButton, \n
                      \ \ \ \ \ \ \ \ \ \ \ \ ButtonEvaluator\  -> \ Local]}\n
                  \ \ \ \ \ \ \ \ }, \n\ \ \ \ \ \ RowSpacings -> 0, \n
                \ \ \ \ \ \ ColumnSpacings -> 0, \n\ \ \ \ \ \ 
                RowLines -> True, \n\ \ \ \ \ \ ColumnLines -> True]], \ 
            "\<Input\>", \ Active\  -> \ True]]; \n\t]\n\), 
    \(Transition\  := \ 
      Module[{nb, \ nb2}, \n\t\tnb2\  = SelectedNotebook[]; \n
        nb\  = \ NotebookCreate[WindowSize \[Rule] {598, 231}, 
            WindowMargins \[Rule] {{1, Automatic}, {3, Automatic}}, 
            StyleDefinitions \[Rule] "\<EAAM.nb\>"]; \n
        NotebookWrite[nb, 
          Cell["\<\<\
This notebook is meant to facilitate the construction \
of a \
permutation that represents a symmetry of the figure in question. To \
begin, \
make sure you can see both the figure and this notebook. Next, \
evaluate the \
following button and follow the instructions.\
\>\>", \ 
            "\<Text\>"]]; \n
        NotebookWrite[nb, 
          Cell[BoxData[\n\ \ \ \ 
              ButtonBox["\<continue\>", \n\ \ \ \ \ \ 
                ButtonFunction :> continueButton, \n\ \ \ \ \ \ 
                ButtonEvaluator -> "\<Local\>"]], \ "\<Input\>", \n\ \ 
            Active -> True, \n\ \ CellTags -> "\<cont\>"]]; \n\t\t
        NotebookClose[nb2]]\n\), 
    \(Transition\)}], "Input",
  CellTags->"evaluate"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{620, 234},
WindowMargins->{{4, Automatic}, {0, Automatic}},
Background->GrayLevel[1],
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "evaluate"->{
    Cell[2396, 73, 7615, 141, 1723, "Input",
      CellTags->"evaluate"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"evaluate", 10883, 240}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 38, 0, 76, "Title"],
Cell[1772, 53, 178, 4, 52, "Text"],
Cell[1953, 59, 355, 8, 31, "Input"],

Cell[CellGroupData[{
Cell[2333, 71, 60, 0, 55, "Section"],
Cell[2396, 73, 7615, 141, 1723, "Input",
  CellTags->"evaluate"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

