(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

(* :Title:  AbstractAlgebra`RingExtensions *)

(* :Context: AbstractAlgebra`RingExtensions` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)

incomingStructure = DefaultStructure;

BeginPackage["AbstractAlgebra`RingExtensions`",
{"AbstractAlgebra`Core`", "AbstractAlgebra`RingProperties`", 
"AbstractAlgebra`Joint`","Graphics`Graphics`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];

Off[AppendTo::rvalue];

BaseRing::usage="BaseRing[R] returns the base ring of an extension or
quotient ring. If p is a polynomial, BaseRing[p] returns the underlying
base ring for the polynomial.";

Coefficient::usage = "Coefficient[poly, ind, n], given a polynomial over
some ring in the indeterminate ind, returns the coefficient of ind^n.
Coefficient[poly, n] works similarly, without the indeterminate needing
to be specified. The standard (built-in) usage still exists:
Coefficient[expr, form] gives the coefficient of form in the polynomial
expr. Coefficient[expr, form, n] gives the coefficient of form^n in
expr.";

CoefficientList::usage = "CoefficientList[poly] returns the list of
coefficients used in the polynomial poly over some ring R. Note that
these are returned in the order as if PowersIncrease -> RightToLeft was
given. In other words, CoefficientList[x^2 + 2x + 3] returns {3,2,1}.
The standard (built-in) usage still exists: CoefficientList[poly, var]
gives a list of coefficients of powers of var in poly, starting with
power 0. CoefficientList[poly, {var1, var2, ...}] gives a matrix of
coefficients of the vari.";

Degree::usage = "Degree[PolynomialsOver[R], p] determines the degree of
the polynomial p when viewed as an element in the ring of polynomials
over the Ringoid R. Degree[p] assumes p is defined in some ring of
polynomials. The standard (built-in) usage still exists: Degree gives
the number of radians in one degree. It has a numerical value of
Pi/180.";

EvaluationInExtension::usage = "EvaluationInExtension[E, p, q] evaluates
the polynomial p (a polynomial over the base ring of extension E) at q,
an element of that extension. Note: both p and q should both be
polynomials over the base ring with identical indeterminates.";

Equal::usage = "Equal[PolynomialsOver[R], p, q] returns True or False
depending on whether the polynomials p and q are equal as elements in
the ring of polynomials over the Ringoid R. Equal[p, q] assumes that
both p and q are well-defined in some ring of polynomials. The option
IgnoreIndeterminate can be set to True (default) or False and determines
whether the indeterminate used should be considered when deciding
equality. The standard (built-in) usage still exists: lhs == rhs returns
True if lhs and rhs are identical.";

Exponent::usage = "Exponent[PolynomialsOver[R], p] determines the degree
of the polynomial p when viewed as an element in the ring of polynomials
over the Ringoid R. Exponent[p] assumes p is defined in some ring of
polynomials. The standard (built-in) usage still exists: Exponent[expr,
form] gives the maximum power with which form appears in expr.
Exponent[expr, form, h] applies h to the set of exponents with which
form appears in expr.";

(*ExtensionEvaluation::usage = "ExtensionEvaluation[E, q], given E as the
quotient ring of F over the irreducible polynomial p, evaluates the
induced coset polynomial equivalent to p at the element q in E. The
function InducedCosetPolynomialFunction is related.";*)

ExtensionType::usage = "ExtensionType[extension] returns the type of
extension for this extension ring.";

FlexibleEntering::usage = "FlexibleEntering is an option, taking either
True or False, for the Poly function, which creates polynomials. When
set to True (which is the default value), the call Poly[R, x^2 - 2x + 1]
is treated as Poly[R, x^2 + NegationOf[R, 2]x + 1]. Additionally, if R =
Z[n], then all coefficients are reduced mod n before processing.";

Func::usage="Func is the head for a function in a FunctionsOver
extension.";

FuncRing::usage="FuncRing is the first parameter for any function
extension.";

FunctionsOver::usage="FunctionsOver[R] returns the extension of
functions on the Ringoid R.";

FuncToRules::usage="FuncToRules[f, FunctionsOver[R]] converts f to a
list of rules.";

IgnoreIndeterminate::usage = "IgnoreIndeterminate is an option for the
Equal command that is used when determining when two polynomials are
equal. The default value for this option is True, which means that 4x^2
+ 3x + 1 and 4y^2 + 3y + 1 are considered equal as polynomials. One can
optionally set this to False.";

Indeterminate::usage = "Indeterminate is an option for the function Poly
(that creates polynomials). The default value is 'x', though one can
specify any other symbol as the indeterminate to be used in a
polynomial. The standard (built-in) usage still exists: Indeterminate is
a symbol that represents a numerical quantity whose magnitude cannot be
determined.";

(*InducedCosetPolynomialFunction::usage =
"InducedCosetPolynomialFunction[E], given E as the quotient ring of F
over the irreducible polynomial p, returns (as a function) the coset
polynomial equivalent to p. In other words, the function that is
returned represents the polynomial function induced from p by replacing
the coefficients (from F) of p with the corresponding (coset)
polynomials from E and replacing the addition and multiplication of F
from within p to the multiplication and addition within E.";*)

Matrices::usage = "Matrices is a possible type of RingExtension.";

ModulusPolynomial::usage="ModulusPolynomial[Q_] is the polynomial from
which a quotient ring Q has been created.";

Monomial::usage="Monomial[R, c, n] returns the monomial c x^n in the
ring extension PolynomialsOver[R]; Monomial[PolynomialsOver[R], c, n]
returns the same.";

Poly::usage = "Poly[R, expr, opts] creates the polynomial over the
Ringoid R given by expr and using the options given by opts. A
polynomial such as 2 + 3x + x^3 (over some ring R) can be constructed by
Poly[R, 2 + 3x + x^3], which, by default, would return 2 + 3x + x^3. The
form x^3 + 3x + 2 could be returned by entering Poly[R, 2 + 3x + x^3,
PowersIncrease -> RightToLeft], or by changing this option globally. One
can also specify a polynomial by just using the coefficients. Thus,
Poly[R, 1, 0, 3, 2] returns 1 + 3x^2 + 2x^3, while Poly[R, 2, 3, 0, 1,
PowersIncrease -> RightToLeft] returns 2x^3 + 3x^2 + 1. When entering
just the coefficients, the default indeterminate is 'x', but this can be
changed by using the option Indeterminate -> var, where var is any
(value-less) symbol. FlexibleEntering, an option taking either True or
False (defaulting to True), can be used if one wishes to enter
polynomials allowing subtraction of terms or allowing entering the
negation of an element by using -r. It also allows all coefficients of
the polynomial to be reduced mod n if the base ring is Z[n]. If RP is a
ring of polynomials, Poly[RP, expr, opts] works in a similar fashion.";

PolynomialDivision::usage="PolynomialDivision[PolynomialsOver[R], a, b],
for polynomials a and b in the ring of polynomials over R, returns the
pair of polynomials {q, r} where a = b q + r with r = 0 or deg r < deg
b, provided that the leading coefficient of b is a unit in R.
PolynomialDivision[a, b] works similarly as long as polynomials a and b
are both from the same ring of polynomials. The standard (built-in)
usage still exists: PolynomialDivision[p, q, x] gives a list of the
quotient and remainder obtained by division of the polynomials p and q
in x.";

PolynomialEvaluation::usage = "PolynomialEvaluation[PolynomialsOver[R],
p, alpha] evaluates the polynomial p at alpha using the operations of
Ringoid R. PolynomialEvaluation[p, alpha] works similarly.";

PolynomialGCD::usage = "PolynomialGCD[PolynomialsOver[R], p, q] returns
the greatest common divisor of the polynomials p and q (as elements of
the ring of polynomials over R). PolynomialGCD[p, q] works similarly as
long as polynomials p and q are both from the same ring of polynomials.
The standard (built-in) usage still exists: PolynomialGCD[poly1, poly2,
...] gives the greatest common divisor of the polynomials poly1, poly2,
... . PolynomialGCD[poly1, poly2, ..., Modulus->p] gives the GCD modulo
the prime p.";

PolynomialLCM::usage = "PolynomialLCM[PolynomialsOver[R], p, q] returns
the least common multiple of the polynomials p and q (as elements of the
ring of polynomials over R). PolynomialLCM[p, q] works similarly as long
as polynomials p and q are both from the same ring of polynomials. The
standard (built-in) usage still exists: PolynomialLCM[poly1, poly2, ...]
gives the least common multiple of the polynomials poly1, poly2, ... .
PolynomialLCM[poly1, poly2, ..., Modulus->p] gives the LCM modulo the
prime p.";

PolynomialQuotient::usage = "PolynomialQuotient[PolynomialsOver[R], p,
q] returns the quotient when the polynomial p is divided by the
polynomial q (as elements of the ring of polynomials over R), provided
that the leading coefficient of q is a unit in R. PolynomialQuotient[p,
q] works similarly as long as polynomials p and q are both from the same
ring of polynomials. The standard (built-in) usage still exists:
PolynomialQuotient[p, q, x] gives the quotient of p and q, treated as
polynomials in x, with any remainder dropped.";

PolynomialRemainder::usage = "PolynomialRemainder[PolynomialsOver[R], p,
q] returns the remainder when the polynomial p is divided by the
polynomial q (as elements of the ring of polynomials over R), provided
that the leading coefficient of q is a unit in R. PolynomialRemainder[p,
q] works similarly as long as polynomials p and q are both from the same
ring of polynomials. The standard (built-in) usage still exists:
PolynomialRemainder[p, q, x] gives the remainder from dividing p by q,
treated as polynomials in x.";

PolynomialsOfDegreeN::usage = "PolynomialsOfDegreeN[R, n, opts] returns
all polynomials of degree n over the ring R. Since this number can
increase rather quickly, the option SizeLimit provides a maximum for the
number of polynomials that will be produced. The default value is 125,
but this can be changed using the option. Unless Indeterminate -> symbol
is set, the default indeterminate is x. A related function is
PolynomialsUpToDegreeN.";

PolynomialsOver::usage="PolynomialsOver[R] generates the RingExtension
of polynomials over R.";

PolynomialsUpToDegreeN::usage = "PolynomialsUpToDegreeN[R, n, opts]
returns all polynomials of degree n or less over the ring R. Since this
number can increase rather quickly, the option SizeLimit provides a
maximum for the number of polynomials that will be produced. The default
value is 125, but this can be changed using the option. Unless
Indeterminate -> symbol is set, the default indeterminate is x. A
related function is PolynomialsOfDegreeN.";

PolyQ::usage = "PolyQ[p] returns True if p is a polynomial obtained by
the Poly function in AbstractAlgebra, and False otherwise.";

PolyRing::usage="PolyRing is a parameter of RingExtension.";

PowersIncrease::usage = "PowersIncrease is an option that is used in
specifying how a polynomial should be presented when called with the
Poly function. It takes two values: RightToLeft and LeftToRight. The
former would return a polynomial in the form 4x^2 + 3x + 1 while the
latter would return 1 + 3x + 4x^2 for the same polynomial.";

RingExtension::usage="RingExtension is the Head for the ring
extenstions.";

Solve::usage = "Solve[PolynomialsOver[R], poly == r], when given a
polynomial poly from the ring of polynomials over the Ringoid R and an
element r from R, solves the equation poly == r in the indeterminate x.
(Solve[poly == r] can also be used, with the underlying ring extracted
from poly.) Solutions are returned as a list of rules (as per normal
usage), prefixed by the ring of polynomials. These solutions can be used
with ReplaceAll (or its equivalent, /.) just as the results of the
ordinary (built-in) Solve, whose functionality still works: Solve[eqns,
vars] attempts to solve an equation or set of equations for the
variables vars. Any variable in eqns but not vars is regarded as a
parameter. Solve[eqns] treats all variables encountered as vars above.
Solve[eqns, vars, elims] attempts to solve the equations for vars,
eliminating the variables elims.";

TestFunction::usage = "Test[ext] returns the function for the ring
extension ext that determines if an element is a member of the
extension.";

PolyToFunction::usage = "PolyToFunction[R, p] constructs the function
on the ringoid R that is defined by the polynomial p (constructed with
Poly). If R has no unity, then $Failed is returned.";

ToOrdinaryPolynomial::usage = "ToOrdinaryPolynomial[p] returns an
expression that will be regarded as a polynomial in Mathematica's
ordinary sense. Note that the underlying ring is lost in this transition
and the new polynomial may or may not make sense (to ordinary
Mathematica functions), depending on the ring.";

Zeros::usage = "Zeros[PolynomialsOver[R], p] returns the zeros, if any,
of the polynomial p as a polynomial with coefficients from R. In other
words, if z is the zero of R, this returns {x : p(x) = z}. Zeros[p] is
another method of obtaining the same result.";

Coefficient::ind = "Since `1` uses the indeterminate `2`, `3` shouldn't
be specified as the indeterminate. Mention of the indeterminate
is optional; it can be omitted."

PolynomialDivision::undef="Since the leading coefficient, `1`, is not a unit in `2`,
division is undefined.";

FuncToRules::invalid="Incorrect dimension for Func object to match base
ring.";

Poly::badInd = "The indeterminate chosen for this polynomial, `1`, can
not be used. (Perhaps it is a symbol with an assigned value.) 'X' will
be the indeterminate used.";

Poly::bragrm = "To perform operations on polynomials, one must use the
same base ring for both polynomials.";

Poly::extagrm = "To perform operations on polynomials, one must use the
same base ring for the polynomials as for the specified base ring in the
extension.";

Poly::mixvars = "In your polynomial `1`, you should be using only a
single variable (such as x), but the variables `2` were used.";

PolynomialGCD::undefined= "Result of PolynomialGCD is undefined due to a
nonring base or an undefined division.";

PolynomialsOfDegreeN::toobig ="Using degree `1`, the set of polynomials
would be of length about `2`, which is larger than the current limit of
`3`. You can override this limit by using the option SizeLimit -> `2`.";

RandomElements::toomanyk = "You can not obtain `1` random elements from
this structure using the given options.";

RingExtension::NoInverse="No mult. inverse in extension ring due to a
lack of mult inverse in the base ring.";

RingExtension::NoNegat="No negation in extension ring due to a lack of
negation in the base ring.";

RingExtension::NoUnity = "The extension ring does not have a unity
because the base ring does not have a unity (or possibly a zero).";

RingExtension::NoZero ="The extension ring does not have a zero because
the base ring does not have a zero.";

RingExtension::NotBaseElement = "The element `1` is not in the base ring
";

Begin["`Private`"];

AddRingInfo[G_, ok_, mess1_, mess2_] := 
	(If[AbstractAlgebra`Core`Private`untestedQ[RingInfo[G]], RingInfo[G] = {}];
	If[ok,
		If[!MemberQ[RingInfo[G],mess1],
			AppendTo[RingInfo[G],mess1]],
		If[!MemberQ[RingInfo[G],mess2],
			AppendTo[RingInfo[G],mess2]]];)

ModifiedAnd[x_, y_] := If[MemberQ[{x,y},$Failed],
	$Failed, x && y]

GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]

BaseRing[RingExtension[Type_,base_,param_,test_]] := base;

ExtensionType[RingExtension[Type_,base_,param_,test_]]:=Type

TestFunction[RingExtension[Type_,base_,param_,test_]]:=test

ClosedQ[R_RingExtension] := 
	ModifiedAnd[ClosedQ[R, Operation -> Addition],
		ClosedQ[R, Operation -> Multiplication]]
		
HasIdentityQ[R_RingExtension] := ModifiedAnd[HasZeroQ[R], WithUnityQ[R]]

HasIdentityQ[R_RingExtension, Operation -> Addition] :=	HasZeroQ[R]

HasIdentityQ[R_RingExtension, Operation -> Multiplication] :=	WithUnityQ[R]

InvertibleQ[R_RingExtension, r_] :=  
	ModifiedAnd[HasNegativeQ[R,r], UnitQ[R,r]]

InvertibleQ[R_RingExtension, r_, Operation -> Addition] := HasNegativeQ[R,r]
	
InvertibleQ[R_RingExtension, r_, Operation -> Multiplication] :=UnitQ[R,r]

Format[RingExtension[PolyRing,R_,__]] := 
"-Ring of Polynomials over " <> RingoidName[R] <> "-"

PolynomialsOver[R_?RingoidQ] := PolynomialsOver[R] = Module[{er},
	er = RingExtension[PolyRing, R, {}, (Head[#]===poly) && 
		(Apply[And,Map[MemberQ[R[[1]],#]&,Last[#]]])&];
	RingInfo[er]={"ring of polynomials over "<>RingoidName[R]};
	er]

identitiesToStrings[R_, coeffs_List] := Module[{one = Unity[R], 
		zero = Zero[R], newone, newzero},
	newzero = If[zero === 0, 0, ToString[zero]];
	newone = If[one === 1, 1, ToString[one]];
	coeffs/.{zero -> newzero, one -> newone}]

polyToPolynomial[var_Symbol,coef_List,RightToLeft, True] := 
		Module[{n = Length[coef], pol},
	pol = coef.Table[Subscripted[var[k],{},{1}], {k, 0, n-1}]/.
		{Subscripted[var[0],{},{1}] -> 1, Subscripted[var[1],{},{1}] -> var};
	pol = If[Head[pol]===Plus,
		Flatten[{List@@pol},1],
		{pol}];
	pol = Drop[MapThread[Sequence, {Reverse[pol], Table[" + ", {Length[pol]}]}],-1];
	pol = 
		Apply[SequenceForm,Flatten[pol /. Times[c_, h_] :> List[c," ",h],1]/.Power[var,e_] :>
		Subscripted[var[e],{},{1}]]]
		
polyToPolynomial[var_Symbol,coefs_List,LeftToRight,False] := 
		Module[{n = Length[coefs],k,powers,polystuff, coef = ToString /@ coefs},
	If[n > 2, powers = Join[{1,var}, Table[Subscripted[var[k],{},{1}], 
		{k, 2, n-1}]]];
	If[n == 1, polystuff = {First[coef]}];
	If[n == 2, polystuff = {First[coef]," + ", coef[[2]]," ",var}];
	If[n > 2, polystuff = Join[{First[coef]," + ", coef[[2]]," ",var},
		Flatten[Table[{" + ", coef[[k]]," ",powers[[k]]},{k, 3, n}],1]]];
	Apply[SequenceForm,polystuff]]
	

polyToPolynomial[var_Symbol,coefs_List,RightToLeft,False] := 
		Module[{n = Length[coefs],k,powers,polystuff, coef = ToString /@ coefs},
	If[n > 2, powers = Join[{1,var}, Table[Subscripted[var[k],{},{1}], 
		{k, 2, n-1}]]//Reverse];
	If[n == 1, polystuff = {First[coef]}];
	If[n == 2, polystuff = {coef[[2]]," ",var," + ",First[coef]}];
	If[n > 2, polystuff = Join[Flatten[Table[{coef[[n-k+1]]," ",
		powers[[k]]," + "},{k, 1, n-2}],1],{coef[[2]]," ",var," + ",First[coef]}]];
	Apply[SequenceForm,polystuff]]

(*polyToPolynomial[var_Symbol,coef_List,LeftToRight,True] := 
	coef.Table[Subscripted[var[k],{},{1}], {k, 0, Length[coef] - 1}]/.
		{Subscripted[var[0],{},{1}] -> 1, Subscripted[var[1],{},{1}] -> var}*)

polyToPolynomial[var_Symbol,coef_List,LeftToRight,True] :=
 (Rest[coef].Table[Subscripted[var[k],{},{1}], {k, 1, Length[coef] -
1}]/.
  {Subscripted[var[1],{},{1}] -> var})//
  If[First[coef]==0,#,ToString[First[coef]]+#]&
  
Format[p_poly] := polyToPolynomial[p[[1,3]], Last[p], p[[1,2]],
	p[[1,4]]]
	
ZRingoidQn[R_?RingoidQ] := Module[{chars, zpartq, index, ok, nm = RingoidName[R]},
	If[Head[nm] === String, 
		Off[ToExpression::esntx, ToExpression::sntx,ToExpression::sntxi];
		chars = Characters[nm];
		zpartq = Join[Take[chars,2],{Last[chars]}];
		index = ComplementNoSort[chars,zpartq]//StringJoin//ToExpression;
		On[ToExpression::esntx, ToExpression::sntx, ToExpression::sntxi];
		zpartq = StringJoin[zpartq];
		ok = IntegerQ[index] && zpartq === "Z[]";
		If[ok, {ok, index}, {ok, Null}], {False, Null}]]
	
numericalCoefficientsQ[coefs_List]:= 
   Fold[(#1&&NumberQ[#2])&,NumberQ[First[coefs]],Rest[coefs]]

PolyQ[p_] := Head[p] === poly

Options[Poly] = {PowersIncrease -> LeftToRight, Indeterminate -> Global`x,
	FlexibleEntering -> True};

Poly[R_?RingoidQ, exprs__, opts___?OptionQ] := Module[{ok,
		ind = Indeterminate/.Flatten[{opts, Options[Poly]}],
		pi = PowersIncrease/.Flatten[{opts, Options[Poly]}],
		fe = FlexibleEntering/.Flatten[{opts, Options[Poly]}],
		coefficients, nc, znq, index,vars, varsUsedQ = False, 
		indNotSpecQ = FreeQ[{opts},Indeterminate], expr},
	Off[Head::argx];
	If[Head[exprs]===TraditionalForm, expr = exprs[[1]], expr = exprs];
	If[Not[MemberQ[{String,Symbol},Head[ind]]], Message[Poly::badInd,ind];
		ind = Global`x];
	If[Not[MemberQ[{Plus,Symbol, Power, Times},Head[expr]]], ok = True; 
		coefficients = 
		If[pi === RightToLeft,
			Reverse[{expr}], {expr}],
		(* else *)
		vars = Variables[expr];
		varsUsedQ = True;
		ok = Length[vars] == 1;
		If[ok, coefficients = CoefficientList[expr, First[vars]]/. 0 -> Zero[R],
			Message[Poly::mixvars, expr, Variables[expr]]]];
	On[Head::argx];
	If[ok, 
		If[fe, 
			{znq, index} = ZRingoidQn[R];
			If[znq,
				coefficients = Mod[coefficients, index],
				coefficients = coefficients /. Times[-1, r_] :> NegationOf[R, r];
				coefficients = Map[If[Abs[#] === -#, NegationOf[R,-#], #]&,coefficients]]];
		ok = ElementsQ[coefficients,R];
		If[indNotSpecQ && varsUsedQ, ind =First[vars]];
		If[Not[ok], Message[MemberQ::elmnts,"the coefficients "<>ToString[coefficients],
			" the base ring"]]];
	If[ok, 
		coefficients = coefficients //.{{cc__,Zero[R]}:>{cc}}; (* remove extra zeros *)
		coefficients = identitiesToStrings[R,coefficients];
		nc = numericalCoefficientsQ[coefficients]];
	If[ok && Not[nc], coefficients = Map[If[Head[#]===String,
		ToExpression[#],#]&,coefficients]];
	If[ok,poly[{R, pi, ind, nc}, coefficients], $Failed]
]

Poly[RingExtension[PolyRing,R_,{},test_], expr__, opts___?OptionQ] :=
	Poly[R, expr, opts]

pring[p_poly] := p[[1,1]]
pdir[p_poly] := p[[1,2]]
pind[p_poly] := p[[1,3]]
pnc[p_poly] := p[[1,4]]

Unprotect[Variables,CoefficientList, Coefficient];

Variables[p_poly] ^:= {pind[p]}

CoefficientList[p_poly] ^:= Last[p]

poly /: Coefficient[p_poly, ind_, 0] := If[pind[p]===ind, First[Last[p]],
	Message[Coefficient::ind, p, pind[p], ind]; $Failed]

poly /: Coefficient[p_poly, ind_, n_Integer?Positive] := 
	If[pind[p]===ind,Part[Last[p],n+1],
	Message[Coefficient::ind, p, pind[p], ind];$Failed]

poly /: Coefficient[p_poly, n_Integer?Positive] := Part[Last[p],n+1]

Protect[Variables,CoefficientList, Coefficient];

BaseRing[p_poly] := pring[p]

ToOrdinaryPolynomial[p_poly] :=
	Last[p].Table[pind[p]^k,{k,0, Length[Last[p]]-1}]
	
ToOrdinaryPolynomial[p_] :=  
	If[Length[Variables[p]]==1 && 
		PolynomialQ[p, First[Variables[p]]],p]

zeepoly[R_,k_] := Poly[R,Sequence@@Table[Zero[R],{k}]]

Addition[RingExtension[PolyRing,R_,{},test_]]:=
	Addition[RingExtension[PolyRing,R,{},test],#1, #2]&

extAndBaseMatchQ[RingExtension[PolyRing,R_,{},test_], p_poly] :=
	If[R === pring[p], True,
		Message[Poly::extagrm]; False]
		
extAndBasesMatchQ[RingExtension[PolyRing,R_,{},test_], p_poly, q_poly] :=
	If[R === pring[p] && R === pring[q], True,
		Message[Poly::extagrm]; False]
		
basesMatchQ[p_poly, q_poly] :=
	If[pring[p]  === pring[q], True,
		Message[Poly::bragrm]; False]

indToUse[p_poly, q_poly] := If[p[[1,3]] === q[[1,3]], p[[1,3]], 
			Indeterminate/.Options[Poly]]
			
dirToUse[p_poly, q_poly] := If[p[[1,2]] === q[[1,2]], p[[1,2]], 
			PowersIncrease/.Options[Poly]]
			
Addition[RingExtension[PolyRing,R_,{},test_], p_poly, q_poly]:=
	If[extAndBasesMatchQ[RingExtension[PolyRing,R,{},test], p, q] &&
		basesMatchQ[p,q],
	Block[{m1,m2,max,k,cc,coef, c1=Last[p], c2=Last[q], dir, var},
		m1=Length[c1];m2=Length[c2];
		max=Max[m1,m2];
		coef = Apply[Addition[R],{Join[c1, Table[Zero[R],{max-m1}]],
			Join[c2,Table[Zero[R],{max-m2}]]}//Transpose,1];
		coef = coef //.{{cc__,Zero[R]}->{cc}};
		dir = dirToUse[p,q];
		var = indToUse[p,q];
		Poly[R, Sequence@@If[dir===RightToLeft,Reverse[coef],coef], 
			PowersIncrease -> dir, Indeterminate -> var]
	], $Failed]

Addition[p_poly, q_poly]:=
	If[basesMatchQ[p,q],
		Addition[PolynomialsOver[p[[1,1]]],p,q], $Failed]
		
Unprotect[Plus, Times];

poly /: Plus[p_poly, q_poly] := Addition[p,q]
poly /: Times[p_poly, q_poly] := Multiplication[p,q]
poly /: Times[-1, q_poly] := NegationOf[q]

Protect[Plus, Times];
		
Multiplication[RingExtension[PolyRing,R_,{},test_], p_poly, q_poly]:=
	If[extAndBasesMatchQ[RingExtension[PolyRing,R,{},test], p, q] &&
		basesMatchQ[p,q],
	Block[{m1,k,cc,coef, c1=Last[p], c2=Last[q], dir, var, tr},
		m1=Length[c1];
		coef = Table[Join[Table[Zero[R],{k-1}], 
			Map[Multiplication[R][c1[[k]],#]&,
			c2], Table[Zero[R],{m1-k}]],{k,1,m1}];
		coef = If[Length[coef] < 2, First[coef],
			Map[Fold[Addition[R],First[#],Rest[#]]&, Transpose[coef]]];
		coef = coef //.{{cc__,Zero[R]}->{cc}};
		dir = dirToUse[p,q];
		var = indToUse[p,q];
		Poly[R, Sequence@@If[dir===RightToLeft,Reverse[coef],coef], 
			PowersIncrease -> dir, Indeterminate -> var]
	], $Failed]

Multiplication[RingExtension[PolyRing,R_,{},test_]]:=
	Multiplication[RingExtension[PolyRing,R,{},test],#1, #2]&

Multiplication[p_poly, q_poly]:=
	If[basesMatchQ[p,q],
		Multiplication[PolynomialsOver[p[[1,1]]],p,q], $Failed]
	
ClosedQ[RingExtension[PolyRing,R_,{},test_], Operation -> Addition]:=
	Module[{aok},
		aok = ClosedQ[R, Operation -> Addition];
		AddRingInfo[RingExtension[PolyRing,R,{},test], aok, "the set is closed under addition",
			"the set is not closed under this addition"];
		aok]

ClosedQ[RingExtension[PolyRing,R_,{},test_], Operation -> Multiplication]:=
	Module[{mok},
		mok = ClosedQ[R, Operation -> Multiplication];
		AddRingInfo[RingExtension[PolyRing,R,{},test], mok, 
			"the set is closed under multiplication",
			"the set is not closed under this multiplication"];
		mok]

HasZeroQ[RingExtension[PolyRing,R_,{},test_]] := HasZeroQ[R]

Zero[RingExtension[PolyRing,R_,{},test_]] := Zero[RingExtension[PolyRing,R,{},test]] =
	If[HasZeroQ[R], Poly[R,Zero[R]],
		Message[RingExtension::NoZero]; $Failed]

WithUnityQ[RingExtension[PolyRing,R_,{},test_]] := WithUnityQ[R]
           
Unity[RingExtension[PolyRing,R_,{},test_]] := Unity[RingExtension[PolyRing,R,{},test]] =
	If[WithUnityQ[R], Poly[R,Unity[R]],
	Message[RingExtension::NoUnity]; $Failed]
	
HasNegativeQ[RingExtension[PolyRing,R_,{},test_], p_poly] :=
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},test], p],
	Module[{ng = Apply[And,Map[HasNegativeQ[R,#]&,Last[p]]]},
		If[Not[test[p]], Message[MemberQ::elmnt, p, "the ring of polynomials"]; 
			ng = False];
		If[ng===True, True,False]], $Failed]

HasNegativeQ[p_poly] :=
	Module[{ng = Apply[And,Map[HasNegativeQ[p//pring,#]&,Last[p]]]},
		If[Not[test[p]], Message[MemberQ::elmnt, p, "the ring of polynomials"]; 
			ng = False];
		If[ng===True, True,False]]

NegationOf[RingExtension[PolyRing,R_,{},test_], p_poly] :=
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},test], p],
		If[HasNegativeQ[RingExtension[PolyRing,R,{},test],p], poly[First[p],
				Map[NegationOf[R,#]&,Last[p]]],
			Message[RingExtension::NoNegat];$Failed], $Failed]

NegationOf[p_poly] :=
		If[HasNegativeQ[p], poly[First[p],Map[NegationOf[p//pring,#]&,Last[p]]],
			Message[RingExtension::NoNegat];$Failed]

UnitQ[RingExtension[PolyRing,R_,{},test_], poly[info_List,{a_}]] := 
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},test], poly[info,{a}]],
	If[test[poly[info,{a}]], UnitQ[R, a],
		Message[MemberQ::elmnt, poly[info,{a}], "the ring of polynomials"]; False],
	$Failed]

UnitQ[RingExtension[PolyRing,R_,{},test_], $Failed] := $Failed

UnitQ[poly[info_List,{a_}]] := UnitQ[First[info], a]

UnitQ[RingExtension[PolyRing,R_,{},test_], poly[info_List,coef_List]] := 
	If[UnitQ[normalizePolynomial[poly[info,coef]]], True, False]

UnitQ[poly[info_List,__]] := False

MultiplicativeInverse[RingExtension[PolyRing,R_,{},test_], poly[info_List,{a_}]]:=
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},test], poly[info,{a}]],
	If[UnitQ[RingExtension[PolyRing, R, {}, test], poly[info,{a}]], 
		Poly[R,MultiplicativeInverse[R,a]],
		Message[Ringoid::NotUnit,Poly[R,a],"the polynomials over "<>
    	RingoidName[R]]; $Failed], $Failed]
                                            
MultiplicativeInverse[poly[info_,coef_]]:=
	MultiplicativeInverse[PolynomialsOver[info//First],poly[info,coef]]
                                            
MultiplicativeInverse[RingExtension[PolyRing,R_,{},test_], poly[info_List, {a__}]]:=
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},test], poly[info,{a}]],
		Module[{temp},
			If[UnitQ[RingExtension[PolyRing, R, {}, test], temp = 
					normalizePolynomial[poly[info,{a}]]],  
				Poly[R,MultiplicativeInverse[R,temp[[2,1]]]],
				Message[Ringoid::NotUnit,poly[info,{a}],"the polynomials over "<>
    	RingoidName[R]]; $Failed]], $Failed]
                                            
Units[RingExtension[PolyRing,R_,{},test_]] := Map[Poly[R,#]&,Units[R]]

(* TO DO:Fix problem with nonstandard rings such as DirectProducts *)

Monomial[RingExtension[PolyRing,R_,{},test_], c_, k_] := 
	Poly[R, Sequence@@Join[Table[Zero[R],{k}],{c}], PowersIncrease -> LeftToRight]

Monomial[R_?RingoidQ, c_, k_] := 
	Monomial[PolynomialsOver[R], c, k]

changeIndeterminate[p_poly, var_] := p /. pind[p] -> var

Unprotect[PolynomialQuotient, PolynomialRemainder, PolynomialGCD,
	PolynomialDivision, PolynomialLCM];

poly /: PolynomialDivision[c_poly, d_poly] :=
	If[basesMatchQ[c,d],
		PolynomialDivision[PolynomialsOver[pring[c]], c, d], 
		$Failed]
		
poly /: PolynomialDivision[RingExtension[PolyRing,R_,{},t_], c_poly, d_poly] :=
	If[extAndBasesMatchQ[RingExtension[PolyRing,R,{},t], c, d] && basesMatchQ[c,d],
		Module[{lq,lr,PR=RingExtension[PolyRing,R,{},t], a = Last[c], 
			b = Last[d],lc,var = indToUse[c,d]},
	If[UnitQ[R, lc = Last[b]],
		{lq,lr} = If[Length[b]==1,
			{poly[First[c],Map[(Multiplication[R][MultiplicativeInverse[R, First[b]],#])&,a]],
			Poly[R,Zero[R]]},      
		Module[{lci=MultiplicativeInverse[R, Last[b]],
			deg=Length[b],ah,qh,monom,divison,Nmonom},
		division[ah_,qh_] := If[Length[ah//Last]<deg,{qh,ah},
			monom=Monomial[R, Multiplication[R][Last[ah//Last],lci],
				Length[ah//Last]-deg];
			Nmonom=Monomial[R,Multiplication[R][Last[ah//Last],NegationOf[R,lci]],
				Length[ah//Last]-deg];
			division[Addition[PR][ah,Multiplication[PR][Nmonom,d]],
				Addition[PR][qh,monom] ]];
		division[c, Poly[R,Zero[R]]] ]];
		{changeIndeterminate[lq,var],changeIndeterminate[lr,var]},     
		Message[PolynomialDivision::undef,lc, AbstractAlgebra`Core`Private`StructureName[R]];
		$Failed]], $Failed]

poly /: PolynomialDivision[c_poly, d_poly, Mode -> Textual] :=
	If[basesMatchQ[c,d],
		PolynomialDivision[PolynomialsOver[pring[c]], c, d, Mode -> Textual],
		$Failed]

poly /: PolynomialDivision[RingExtension[PolyRing,R_,{},t_], c_poly, d_poly, Mode -> Textual]:=
		Module[{lq,lr, da, a = Last[c], b = Last[d]},
	da = PolynomialDivision[RingExtension[PolyRing,R,{},t], c,d];
	If[UnitQ[R, Last[b]],
		{lq,lr} = If[da =!= $Failed, da];
		PolynomialDivisionTextual[c,d,lq,lr];
		{lq,lr},     
		$Failed]];

PolynomialDivisionTextual[a_poly, b_poly, q_poly, r_poly] := 
	Module[{var = pind[a]//ToString},
		Print["a("<>var<>") = b("<>var<>")q("<>var<>") + r("<>var<>") where"];
		Print["a("<>var<>") = ",a,","];
		Print["b("<>var<>") = ",b,","];
		Print["q("<>var<>") = ",q," and"];
		Print["r("<>var<>") = ",r,"."];
		Print["Notice that either r("<>var<>") = 0 or deg r < deg b."];]
 
poly /: PolynomialQuotient[c_poly, d_poly] :=
	If[basesMatchQ[c,d],
		PolynomialQuotient[PolynomialsOver[c[[1,1]]], c, d],
		$Failed]
            
poly /: PolynomialQuotient[RingExtension[PolyRing,R_,{},t_], a_poly, b_poly] :=
	Module[{da = PolynomialDivision[RingExtension[PolyRing,R,{},t], a,b]},
		If[da =!= $Failed, First[da], $Failed]]

poly /: PolynomialRemainder[c_poly, d_poly] :=
	If[basesMatchQ[c,d],
		PolynomialRemainder[PolynomialsOver[c[[1,1]]], c, d],
		$Failed]
   
poly /: PolynomialRemainder[RingExtension[PolyRing,R_,{},t_], a_poly, b_poly] :=
	Module[{da = PolynomialDivision[RingExtension[PolyRing,R,{},t], a,b]},
		If[da =!= $Failed, Last[da], $Failed]]

poly /: PolynomialGCD[c_poly, d_poly] :=
	If[basesMatchQ[c,d],
		PolynomialGCD[PolynomialsOver[c[[1,1]]], c, d],
		$Failed]

poly /: PolynomialGCD[RingExtension[PolyRing,basering_?RingoidQ,{},t_], c_poly, d_poly]:=
	If[extAndBasesMatchQ[RingExtension[PolyRing,basering,{},t], c, d] && basesMatchQ[c,d],
	Module[{gcd,result,T,zp=Poly[basering,Zero[basering]], a = Last[c], b = Last[d]},
		If[(RingQ[basering] && WithUnityQ[basering] &&
				Length[b]>0 && (UnitQ[basering, Last[b]]||(b===Last[zp]))),
		(*case where result is returned *)
			T = PolynomialsOver[basering];
			gcd = (If[(Last[#2]===Last[zp]), #1, If[UnitQ[basering, Last[#2//Last]],
				gcd[#2,PolynomialRemainder[T,#1,#2]], 
				Message[PolynomialGCD::undefined];$Failed]])&;     
			result=gcd[c,d],
		(*case where no result is returned *)
	   Message[PolynomialGCD::undefined];$Failed]], $Failed]
      
poly /: PolynomialLCM[c_poly, d_poly] :=
	If[basesMatchQ[c,d],
		PolynomialLCM[PolynomialsOver[c[[1,1]]], c, d],
		$Failed]

poly /: PolynomialLCM[RingExtension[PolyRing,basering_?RingoidQ,{},t_], c_poly, d_poly]:=
	If[extAndBasesMatchQ[RingExtension[PolyRing,basering,{},t], c, d] && basesMatchQ[c,d],
	Module[{result,T,zp=Poly[basering,Zero[basering]], a = Last[c], b = Last[d]},
		If[(RingQ[basering] && WithUnityQ[basering] &&
				Length[b]>0 && (UnitQ[basering, Last[b]]||(b===Last[zp]))),
		(*case where result is returned *)
			PolynomialQuotient[RingExtension[PolyRing,basering,{},t],c * d,PolynomialGCD[c,d]],
		(*case where no result is returned *)
	   Message[PolynomialGCD::undefined];$Failed]], $Failed]
      
Protect[PolynomialQuotient, PolynomialRemainder, PolynomialGCD,
	PolynomialDivision, PolynomialLCM];

(* Options[QuotientRing]={SizeLimit->16};*)

QuotientRing[basering_?RingoidQ, p_poly,opts___?OptionQ] := 
	QuotientRing[basering, p,opts] = 
	QuotientRing[PolynomialsOver[basering], p]

QuotientRing[RingExtension[PolyRing,basering_?RingoidQ,{},t_], q_poly, 
		opts___?OptionQ]:= 
QuotientRing[RingExtension[PolyRing,basering,{},t], q, opts] =
	If[extAndBaseMatchQ[RingExtension[PolyRing,basering,{},t], q],
	Block[{small,qr,p = Last[q], dir = pdir[q], var = pind[q]},
  	small=(SizeLimit/.Flatten[{opts, Options[QuotientRing]}]);
	If[(Length[Elements[basering]]^(Length[p]-1))<=small,
		If[WithUnityQ[basering],
			If[UnitQ[basering, Last[p]],
				qr = Block[{dom, m=Length[p]-1,z=Zero[basering]},
        	dom=CartesianProduct@@Table[Elements[basering],{m}]//
						Map[(#//.{{a__,z}->{a}})&,#]&;
				If[dir === RightToLeft, dom = Map[Reverse,dom]];
				dom =	Map[Poly[basering,Sequence@@#, Indeterminate -> var]&,dom];
				FormRingoid[dom,(Addition[PolynomialsOver[basering]][#1,#2])&,
					(PolynomialRemainder[RingExtension[PolyRing,basering,{},True],
					(Multiplication[RingExtension[PolyRing,basering,{},True]][#1,#2]),
					q])&, RingoidName -> "Quotient Ring mod "<>
						ToString[ToOrdinaryPolynomial[q]//StandardForm],
  				WideElements->True, KeyForm -> StandardForm, IsARing -> True]
  			];
      BaseRing[qr]=basering;
      RingQ[qr]=RingQ[basering];
      If[HasZeroQ[basering], HasZeroQ[qr] = True;
      	Zero[qr] = Poly[basering, Zero[basering]],
        HasZeroQ[qr] = False];
      If[WithUnityQ[basering], WithUnityQ[qr]=True;
      	Unity[qr]=Poly[basering,Unity[basering]],
   			WithUnityQ[qr]=False];
      ModulusPolynomial[qr] = q;
      qr,
			Message[PolynomialDivision::undef, Last[p],
				AbstractAlgebra`Core`Private`StructureName[R]];$Failed],
		Message[Ringoid::NoUnity];$Failed],
	Message[QuotientRing::toobig];$Failed]], $Failed]

InducedCosetPolynomialFunction[QR_?RingoidQ] := 
	Module[{coef, deg, R = BaseRing[QR], var, p = ModulusPolynomial[QR]},
		coef = p[[2]];
		deg = Length[coef] - 1;
		coef = Map[Poly[R, #, Indeterminate -> p[[1,3]]]&, coef];
		Function[var,
			Sum[coef[[k+1]] ElementToPower[QR, var, k], {k, deg, 0, -1}]]]

ExtensionEvaluation[extension_?RingoidQ, lst_List]:= 
	Map[ExtensionEvaluation[extension, #]&, lst]

ExtensionEvaluation[extension_?RingoidQ, a_poly]:=
	InducedCosetPolynomialFunction[extension][a]
	
(*UnitQ[R_?RingoidQ, a_poly, opts___?OptionQ]:=
   Module[{p=ModulusPolynomial[R],
           b=BaseRing[R],g},
         If[Head[p]==poly && (Head[b]==Ringoid || Head[b]==AbstractAlgebra`Core`Private`ringoid),
              g=PolynomialGCD[PolynomialsOver[b], p, a];
              Length[g]==1 && UnitQ[b, g[[1]]],
              False]]*)


Unprotect[Degree, Exponent];

poly /: Degree[RingExtension[PolyRing,R_,{},t_],p_poly] := 
	Degree[p]
	
poly /: Degree[p_poly] := 
	Length[Last[normalizePolynomial[p]]]-1

poly /: Exponent[RingExtension[PolyRing,R_,{},t_],p_poly] := 
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},t], p],
		Degree[RingExtension[PolyRing,R,{},t],p], $Failed]

poly /: Exponent[p_poly] := Degree[p]

Protect[Degree, Exponent];

Unprotect[Equal];

Options[Equal] = {IgnoreIndeterminate -> True};

poly /: Equal[RingExtension[PolyRing,R_,{},t_], p_poly, q_poly, opts___?OptionQ] :=
	Equal[p,q, opts]
	
poly /: Equal[p_poly, q_poly, opts___?OptionQ] :=
	BaseRing[p]===BaseRing[q] &&
	SameQ[Last[normalizePolynomial[p]],
		Last[normalizePolynomial[q]]] && 
		If[IgnoreIndeterminate/.Flatten[{opts, Options[Equal]}], True,
			SameQ[Variables[p], Variables[q]]]
	
Protect[Equal];

normalizePolynomial[RingExtension[PolyRing,R_,{},t_],p_poly] := 
	normalizePolynomial[p]

normalizePolynomial[p_poly] := 
	poly[First[p],(Last[p])//.{vvv___,Zero[pring[p]]} :>{vvv}]

PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],poly[{R_,d_,var_,n_},
		coef_List], Rule[var_,r_]] :=
	PolynomialEvaluation[RingExtension[PolyRing,R,{},test],poly[{R,d,var,n},coef], r]

PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],poly[{R_,d_,var_,n_},
		coef_List], {{Rule[var_,r_]}}] :=
	PolynomialEvaluation[RingExtension[PolyRing,R,{},test],poly[{R,d,var,n},coef], r]

PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],poly[{R_,d_,var_,n_},
		coef_List], {Rule[var_,r_]}] :=
	PolynomialEvaluation[RingExtension[PolyRing,R,{},test],poly[{R,d,var,n},coef], r]

PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],p_poly, rules:{_Rule..}] :=
	Map[PolynomialEvaluation[RingExtension[PolyRing,R,{},test],p, {#}]&, rules]

PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],p_poly, rules:{{_Rule}..}] :=
	Map[PolynomialEvaluation[RingExtension[PolyRing,R,{},test],p, {#}]&, rules]
	
PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],p_poly, {}] := {}

PolynomialEvaluation[q_poly, r_] :=
	PolynomialEvaluation[PolynomialsOver[q[[1,1]]], q, r]

PolynomialEvaluation[RingExtension[PolyRing,R_,{},test_],q_poly, r_] := 
	If[extAndBaseMatchQ[RingExtension[PolyRing,R,{},t], q],
		Module[{out, p = Last[q]},
	If[test[q] && ElementQ[r,R],
		out = Module[{rest,f,mult},
			mult = Multiplication[R];
			rest = Drop[p,1];
			f[c_,{d_}] := Multiplication[R][c,ElementToPower[R,r,d]];
			Fold[Addition[R],p[[1]],MapIndexed[f,rest]]],
		If[Not[test[q]],
			Message[MemberQ::elmnt, q, "the ring of polynomials"]; out = $Failed];
		If[Not[ElementQ[r,R]],Message[RingExtension::NotBaseElement, r]; out = $Failed];
		out]], $Failed]
		
Zeros[RingExtension[PolyRing,R_,{},test_], p_poly] :=
		If[test[p] && extAndBaseMatchQ[RingExtension[PolyRing,R,{},test], p],
			Module[{els,z,evals, temp},
				els = Elements[R];
				z = Zero[R];
				evals = Map[PolynomialEvaluation[RingExtension[PolyRing,R,{},
					test],p,#]&,els];
				temp = Select[Transpose[{els,evals}],(#[[2]]===z)&];
				If[temp==={},temp,temp//Transpose//First]],
			Message[MemberQ::elmnt, p, "the ring of polynomials"]; 
			$Failed]

Zeros[p_poly] := Zeros[PolynomialsOver[p[[1,1]]],p]
	   		
Unprotect[Solve, ReplaceAll];

Solve[p_poly == r_] := 
		Module[{er, sols, R = p[[1,1]], d = p[[1,2]], var = p[[1,3]],
			n = p[[1,4]], coef = p[[2]], q=p},
			If[ElementQ[r,R],
				er = PolynomialsOver[R];
				q[[2,1]] = Addition[R][NegationOf[R,r], First[coef]];
				sols = Zeros[er, q];
				If[sols === {}, sols, Map[{Rule[var,#]}&,sols]],
			$Failed]]

RingExtension /: Solve[RingExtension[PolyRing,R_,{},test_], p_poly == r_] := Solve[p == r]

poly /: ReplaceAll[poly[{R_,d_,var_,n_}, coef_List], {{Rule[var_, r_]}}] := 
	PolynomialEvaluation[poly[{R,d,var,n},coef], r]

poly /: ReplaceAll[p_poly, rules:{{_Rule}..}] := Module[{temp},
	temp = Transpose[Flatten[rules/.Rule :> List,1]];
	If[Union[First[temp]] === Variables[p],
		Map[PolynomialEvaluation[p, #]&,Last[temp]],
		Print["Bad rules - change to Message about mixing up variables"]; $Failed]]
	
Protect[Solve, ReplaceAll];

constantToPoly[R_?RingoidQ, r_, opts___?OptionQ] := If[ElementQ[r,R], 
	Poly[R, r, opts],
	Message[MemberQ::elmnt, r, AbstractAlgebra`Core`Private`StructureName[R]]; $Failed]
	
Options[PolynomialsOfDegreeN] = {SizeLimit -> 125, Indeterminate -> Global`x};

PolynomialsOfDegreeN[basering_?RingoidQ, 0, opts___?OptionQ] :=
	Map[constantToPoly[basering, #, Indeterminate -> 
		(Indeterminate/.Flatten[{opts, Options[PolynomialsOfDegreeN]}])]&, 
		Elements[basering]]

PolynomialsOfDegreeN[basering_?RingoidQ, n_,opts___?OptionQ] :=
	PolynomialsOfDegreeN[basering, n, opts] =
	Module[{k, z = Zero[basering], coef, els = Elements[basering],
		ind = Indeterminate/.Flatten[{opts,Options[PolynomialsOfDegreeN]}],
		small = SizeLimit/.Flatten[{opts,Options[PolynomialsOfDegreeN]}]},
		If[(k = Length[els]^n * (Length[els]-1)) <= small,
 		coef = CartesianProduct@@Append[Table[els,{n}],Complement[els,{z}]];
 		Map[Poly[basering, Sequence@@#, Indeterminate->ind]&, coef],
	Message[PolynomialsOfDegreeN::toobig,n,k,small];$Failed]]
	 	
 	PolynomialsUpToDegreeN[basering_?RingoidQ, n_,opts___?OptionQ] :=
	PolynomialsUpToDegreeN[basering, n, opts] =
	Module[{k,j,
		ind = Indeterminate/.Flatten[{opts, Options[PolynomialsOfDegreeN]}],
		small = SizeLimit/.Flatten[{opts, Options[PolynomialsOfDegreeN]}]},
		If[(k = Length[els]^(n+1)) <= small,
 			Flatten[Table[PolynomialsOfDegreeN[basering,j,
 				Indeterminate -> ind, SizeLimit->small],{j,n,0,-1}],1],
 			Message[PolynomialsOfDegreeN::toobig,n,k,small];
		$Failed]]

ElementQ[exp_, RingExtension[Type_,base_,param_,test_,___]] := test[exp];

ElementsQ[exps_List, RingExtension[Type_,base_,param_,test_,___]] := 
	Apply[And,Map[test,exps]]

Format[RingExtension[FuncRing,R_,__]] := 
"-Ring of Functions over " <> RingoidName[R] <> "-"

FunctionsOver[R_] := FunctionsOver[R] = 
	RingExtension[FuncRing, R, {}, (Length[#]===Length[Elements[R]] && 
		Apply[And,Map[ElementQ[#,R]&,#]])&];

Addition[RingExtension[FuncRing,R_,{},t_]][a_Func,b_Func]:=
	Inner[Addition[R],a,b,Func];
	
Addition[RingExtension[FuncRing,R_,{},t_], a_Func, b_Func] :=
	Addition[RingExtension[FuncRing,R,{},t]][a,b]
    
Multiplication[RingExtension[FuncRing,R_,{},t_]][a_Func,b_Func]:=
	Inner[Multiplication[R],a,b,Func];
                        
Multiplication[RingExtension[FuncRing,R_,{},t_], a_Func, b_Func] :=
	Multiplication[RingExtension[FuncRing,R,{},t]][a,b]
    
PolyToFunction[RingExtension[FuncRing,R_,{},t_], a_poly]:=
	Catch[If[WithUnityQ[R],Map[First[PolynomialRemainder[PolynomialsOver[R],a,
		poly[{R, LeftToRight,a[[1,3]],a[[1,4]]},{NegationOf[R,#],Unity[R]}]]//Last]&,
      Elements[R]]//Apply[Func,#]&,Throw[$Failed]]]

PolyToFunction[R_?RingoidQ, a_poly]:=  PolyToFunction[FunctionsOver[R], a]

PolyToFunction[a_poly]:= PolyToFunction[FunctionsOver[a[[1,1]]], a]
  
HasZeroQ[RingExtension[FuncRing,R_,{},t_]] := HasZeroQ[R]
 
Zero[RingExtension[FuncRing,R_,{},t_]] := Zero[RingExtension[FuncRing,R,{},t]] = 
	If[HasZeroQ[R], Func@@Table[Zero[R],{Length[Elements[R]]}],
		Message[RingExtension::NoZero];$Failed];

WithUnityQ[RingExtension[FuncRing,R_,{},t_]] := WithUnityQ[R]

Unity[RingExtension[FuncRing,R_,{},t_]]:= Unity[RingExtension[FuncRing,R,{},t]] = 
	If[WithUnityQ[R],
		Func@@Table[Unity[R],{Length[Elements[R]]}],
		Message[RingExtension::NoUnity];$Failed];

ZeroDivisorQ[RingExtension[FuncRing,R_,{},t_], f_Func]:=
	!UnitQ[RingExtension[FuncRing,R,{},t], f];

HasNegativeQ[RingExtension[FuncRing,R_,{},t_], f_Func]:=
	Fold[And[#1,HasNegativeQ[R, #2]]&,HasNegativeQ[R, First[f]],
		List@@Rest[f]];
                  
NegationOf[RingExtension[FuncRing,R_,{},t_], f_Func]:=
	If[HasNegativeQ[RingExtension[FuncRing,R,{},t],f],
		Map[NegationOf[R, #]&,f],
		Message[RingExtension::NoNegat]];

UnitQ[RingExtension[FuncRing,R_,{},t_], f_Func]:=
	Fold[And[#1,UnitQ[R,#2]]&,UnitQ[R, First[f]],
		List@@Rest[f]]

MultiplicativeInverse[RingExtension[FuncRing,R_,{},t_], f_Func]:=
	If[UnitQ[RingExtension[FuncRing,R,{},t], f],
		Map[MultiplicativeInverse[R,#]&,f],
		Message[RingExtension::NoInverse];$Failed]

FuncToRules[RingExtension[FuncRing,R_,{},t_], f_Func]:=
	If[Length[f]==Length[Elements[R]],
		Inner[Rule[#1,#2]&,Elements[R],List@@f,List],
		Message[FuncToRules::invalid];{}]

distinct = (Length[#]==Length[Union@@Map[{#}&,#]])&;

L[i_,{pts__},R_?RingoidQ]:=
		Module[{denom,numer,uno=({pts}[[i]]),zeros, P = PolynomialsOver[R]},
			zeros = Complement[{pts},{uno}];
			denom = Fold[Multiplication[R][#1,Addition[R][uno,NegationOf[R, #2]]]&,
				Unity[R],zeros];
			numer = Fold[Multiplication[P][#1, poly[{R,LeftToRight,Global`X,
    		True},{NegationOf[R, #2],Unity[R]}]]&,
				Unity[P],zeros];
			Multiplication[P][numer,poly[{R,LeftToRight,Global`X,
    		True},{MultiplicativeInverse[R, denom]}]]];

InterpolatingPolynomial//Unprotect;

AbstractAlgebra`Core`Private`ringoid /: 
	InterpolatingPolynomial[R_AbstractAlgebra`Core`Private`ringoid,
		 {pairs__}]:=
	Module[{xs,ys,len,P=PolynomialsOver[R]}, 
		{xs,ys}=Transpose[{pairs}];
  If[distinct[xs],
    len=Length[xs];
    Fold[Addition[P][#1,Multiplication[P][poly[{R,LeftToRight,Global`X,
    		True},{ys[[#2]]}],
      L[#2,xs,R]]]&, Zero[P],Range[1,len]],
    Message[InterpolatingPolynomial::ipdup]]]
 
 Protect[InterpolatingPolynomial];    

randElement[{}] := {};

randElement[Dom_List]:=
       Dom[[Random[Integer,{1,Length[Dom]}]]];

RandomElement[RingExtension[PolyRing,R_,{},t_], 0, opts___?OptionQ]:=
	Poly[R, RandomElement[R, opts]]
       
RandomElement[RingExtension[PolyRing,R_,{},t_], deg_Integer?Positive, opts___?OptionQ]:=
	Module[{z,cc,selp=SelectFrom/.Flatten[{opts, Options[RandomElement]}],
	flag = LowerDegreeOK/.Flatten[{opts, Options[RandomElement]}],
		mon=(Monic/.Flatten[{opts, Options[RandomElement]}]),
		coef, dir = PowersIncrease/.Options[Poly], ind = Indeterminate/.Options[Poly]},
	If[mon,flag=False];
	If[Not[flag],(*Degree is exactly deg *)
	           coef = RandomElements[R,deg,SelectFrom->Any];
	           PrependTo[coef,If[mon, Unity[R],
		        RandomElement[R, SelectFrom->NonZero]]],
		        (*Degree can be less than deg*)
		        z=Zero[R];
		        coef = RandomElements[R,deg+1,SelectFrom->Any];
		        If[selp==NonZero,While[And@@((#==z)&/@coef),
		       							coef=RandomElements[R,deg+1,SelectFrom->Any]],coef]
	       ];
	(*coef = coef //.{{cc__,Zero[R]}->{cc}};*)
	coef = If[dir===RightToLeft,coef,Reverse[coef]];
	Poly[R, Sequence@@coef, Indeterminate -> ind,
		PowersIncrease -> dir]] 
      
RandomElements[RingExtension[PolyRing,R_,{},t_], deg_Integer?Positive, 
	k_Integer?Positive, opts___?OptionQ]:= Module[{rep, done, its=0, tab, ok=True},
rep=Replacement/.Flatten[{opts, Options[RandomElements]}];
tab = Table[RandomElement[RingExtension[PolyRing,R,{},t], deg, opts], {k}];
If[rep, tab,
	tab = UnionNoSort[tab];
	done = Length[tab]==k;
	While[Not[done],
		tab = Table[RandomElement[RingExtension[PolyRing,R,{},t], deg, opts], {2k}];
		tab = UnionNoSort[tab];
		If[Length[tab] >= k, 
			done = ok = True;
			tab = Take[tab,k],
			done = its++ > 6;
			ok = False]];
	If[done && ok, tab, Message[RandomElements::toomanyk,k];$Failed]
	]]

RandomElement[RingExtension[FuncRing,R_,{},t_], opts___?OptionQ]:=
	Module[{sel = SelectBaseElementsFrom/.Flatten[{opts, Options[RandomElement]}]},
		RandomElements[R, Length[Elements[R]], SelectFrom->sel]//
        (Func@@#)&]

RandomElements[RingExtension[FuncRing,R_,{},t_], k_Integer?Positive, opts___?OptionQ]:=
	Module[{sel = SelectFrom/.Flatten[{opts, Options[RandomElements]}]},
		Table[RandomElements[R, Length[Elements[R]], SelectFrom->sel]//
        (Func@@#)&,{k}]]

EvaluationInExtension[E_?RingoidQ, poly[{R_,d_,z_,boo_}, {a_}], 
	poly[{R_,d_,z_,boo_},{c__}]] := poly[{R,d,z,boo}, {a}]

EvaluationInExtension[E_?RingoidQ, poly[{R_,d_,z_,boo_}, {a_,b__}],
	poly[{R_,d_,z_,boo_}, {c__}]]:=
	Addition[E][poly[{R,d,z,boo}, {a}],
		Multiplication[E][EvaluationInExtension[E, poly[{R,d,z,boo}, {b}],
		poly[{R,d,z,boo},{c}]],poly[{R,d,z,boo},{c}]]]
		
EvaluationInExtension[E_?RingoidQ, poly[{R_,d_,z_,boo_}, {a_,b__}],
	polys_List]:= Map[EvaluationInExtension[E, poly[{R,d,z,boo},{a,b}],#]&, polys]

End[];
EndPackage[];

DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];