(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     57408,       2181]*)
(*NotebookOutlinePosition[     59958,       2268]*)
(*  CellTagsIndexPosition[     59653,       2254]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 6",
    FontSize->18],
  "\nPolynomial Rings"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.6"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.7.6"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.8.6"],

Cell[TextData[{
  StyleBox["To work on this lab, you need only a cursory familiarity with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", mostly ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.9.6"],

Cell[TextData[{
  StyleBox[
  "The goal of this lab is discovering some of the basic properties of \
polynomial algebra over a ring, through division and the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GCD",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function. Factorization is discussed in detail in Ring Lab 7.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Introduction to polynomials"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.10.6"],

Cell[TextData[
"To get started, let\[CloseCurlyQuote]s read in the package that provides the \
functionality needed for this lab."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p = x\^2 + 3  x - 4\)]],
  ". This type of expression has been familiar to you for many years. You \
should know how to factor it and how to graph ",
  Cell[BoxData[
      \(TraditionalForm\`y = p\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". How do you factor this polynomial? What does the graph of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" look like? Try also to get ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to do both of these tasks.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We implicitly consider viewing the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[
  " as having coefficients coming from the integers (or possibly real \
numbers). Do we need to confine our coefficients to the integers, rationals, \
reals or complex numbers? No.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" be any commutative ring. We define the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ring of polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" in the indeterminate ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" as the set of all (formal) symbols of the form",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + \[CenterEllipsis] + 
        \(a\_2\) x\^2 + \(a\_1\) x + a\_0\)]],
  ","
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["where the coefficients ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_i\)]],
  StyleBox[" are from the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " is a nonnegative integer. We denote this ring of polynomials by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R[x]\)]],
  StyleBox[". In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", we can create a ring of polynomials as follows.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(P = PolynomialsOver[Z[7]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The ring ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " is the set of all polynomials whose coefficients come from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why don",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t we list all the elements? How many are there?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The first thing we need to think about when working with polynomials is to \
be able to identify two elements as different or the same. Suppose we have a \
polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  " of the form"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + \[CenterEllipsis] + 
        \(a\_2\) x\^2 + \(a\_1\) x + a\_0\)]],
  "."
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["In this case, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[" is not zero, we say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" has ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["degree",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" and we call the coefficient ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[" the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["leading coefficient.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" We say that the two polynomials ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" and",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`g(x) = \(b\_m\) x\^m + \(b\_\(m - 1\)\) x\^\(m - 1\) + 
        \[CenterEllipsis] + \(b\_2\) x\^2 + \(b\_1\) x + b\_0\)]]], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["are equal if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = m\)]],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", they have the same degree) and if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_i = b\_i\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i \[LessEqual] n\)]],
  StyleBox[
  ". Note that what is important in a polynomial is only the list of \
coefficients used; the variable (and its powers) act merely as place holders, \
indicating the position of the coefficients. Thus, in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ", one way we create a polynomial is to simply give the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " a sequence of coefficients, prefixed by the ring from which the \
coefficients come. For example,",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[x]\), 
    \(p = Poly[Z[7], 6, 1, 0, 2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "yields the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\^3 + x + 6\)]],
  ". In this case, the indeterminate is denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". You can specify some other indeterminate."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[y]\), 
    \(p2 = Poly[Z[7], 6, 1, 0, 2, Indeterminate \[Rule] y]\)}], "Input",
  AspectRatioFixed->True],

Cell["You can also enter a polynomial directly:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p3 = Poly[Z[7], 2\ x\^3 + x + 6]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "It is important to remember to specify the ring from which the \
coefficients come. If this is forgotten, the expression will be returned as \
entered (which is a standard ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" means for communicating that the input is unsuitable).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p4 = Poly[2\ x\^3 + x + 6]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
As usual, asking for information about a function is often \
useful.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Poly\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "In particular, note that if you are accustomed to entering polynomials (as \
well as viewing them) the way ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " returns them, you will feel at home with the default setting of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PowersIncrease",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". On the other hand, if you prefer to have the powers of the polynomial \
increase from right to left for both input and output, you may wish to use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SetOptions",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and change the default on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PowersIncrease",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Note how this option works.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Poly[Z[5], 1, 2, 3]\), 
    \(Poly[Z[5], 1, 2, 3, PowersIncrease \[Rule] RightToLeft]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
Note that both the input method (when just giving a sequence of \
coefficients) and the output display is governed by this option. Based on the \
method you prefer, evaluate one of the following two cells.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(SetOptions[Poly, PowersIncrease \[Rule] LeftToRight]\n (*\ 
      output\ will\ be\ similar\ to\ 1\  + \ 2  x\  + \ 3  x\^2\ *) \)\)], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(SetOptions[Poly, PowersIncrease \[Rule] RightToLeft]\n (*\ 
      output\ will\ be\ similar\ to\ 3  x\^2\  + \ 2  x\  + \ 1\ *) \)\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider the following polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(r = Poly[Z[7], 7\ x\^4 - 4\ x + 4\ x\^2 + 9]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "When the base ring is ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", polynomials can be entered with coefficients from the integers (positive \
or negative), and they will be reduced mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". (This property can be turned off by adding the option ",
  StyleBox["FlexibleEntering \[Rule] False",
    FontFamily->"Courier"],
  ".)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Finally, recall the Boolean ring over ",
  Cell[BoxData[
      \(TraditionalForm\`{a, b}\)]],
  " and consider the following polynomials."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[a, b]\), 
    \(R3 = BooleanRing[{a, b}]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(s1 = Poly[R3, {b}, {a, b}, {}, {b}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(s2 = Poly[R3, {c}, {a, b, c}, {y}, {b}]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
When a polynomial is constructed, the coefficients are checked for \
membership against the base ring; an error message is given if the polynomial \
is ill-formed.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Construct a well-formed and an ill-formed third-degree polynomial over ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_10\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s pick a couple of random polynomials of degree 3. \
(Recall that ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " is our extension ring of polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  ".)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = RandomElement[P, 3]\), 
    \(b = RandomElement[P, 3]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". List your polynomials. You should have a reasonable guess or idea how to \
add these two polynomials. Do so (by hand). Also, determine their product.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "In the ring of polynomials, there is a built-in addition and \
multiplication. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s define some ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" aliases for these functions in our ring of polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(add = Addition[P]; \)\), 
    \(\(mult = Multiplication[P]; \)\n (*\ no\ output\ is\ given\ *) \)}], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s add and multiply ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " (and note that this should check your answer to question 4)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(add[a, b]\), 
    \(mult[a, b]\)}], "Input",
  AspectRatioFixed->True],

Cell["Conventional notation works as well.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a + b\), 
    \(a\ b\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the degree of the product of polynomials ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Degree",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function determines the degree of a polynomial.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Degree[Poly[Z[8], 4\ x\^2 + 7\ x - 2]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Degree[a\ b]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What are the constant polynomials in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox["? (These are the polynomials without the indeterminate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does this ring of polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[
  " have a zero? What about a unity? If you answered yes to either, what is \
it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Can we add two polynomials of degree ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[
  " and obtain a sum of a lower degree? Try the following code once or twice \
(or more times, if you feel it is necessary) and consider the results. If \
obtaining a sum with lower degree cannot happen, explain why not; if it can, \
cite circumstances under which it can.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Print["\<Let d(p) be the degree of the polynomial p:\>"]; \)\), 
    \(\((TableForm[#1, 
            TableHeadings 
              \[Rule] {
                None, {"\<polynomial a\>", "\<polynomial b\>", 
                  "\<{d(a), d(b)}\>", "\<d(a + b)\n\>"}}, 
            TableSpacing \[Rule] {0, 3}, TableDepth \[Rule] 2]&)\)[
      Table[a = RandomElement[P, 2]; 
        b = RandomElement[P, 2]; {a, b, {Degree[a], Degree[b]}, 
          Degree[a + b]}, {25}]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What happens when we multiply a polynomial of degree 3 with one of \
degree 2? What is the degree of the product? Try the code below once or twice \
(or more times, if you feel it necessary) and consider the results. Explain \
your conclusion.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((TableForm[#1, 
            TableHeadings 
              \[Rule] {
                None, {"\<polynomial a\>", "\<polynomial b\>", 
                  "\<d(a * b)\n\>"}}, TableSpacing \[Rule] {0, 3}]&)\)[
      Table[a = RandomElement[P, 3]; 
        b = RandomElement[P, 2]; {a, b, 
          Degree[P, \(Multiplication[P]\)[a, b]]}, {20}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" is the ring of all polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[", we can ask about the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Zero",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Unity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" of this ring.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({z, u} = {Zero[P], Unity[P]}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Of course, we need to be careful about how we interpret what we see here. \
If we ask if ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " is equal to the number 0 and if ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is equal to the number 1, we get the following."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(z === 0\), 
    \(u === 1\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Explain these results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s shift gears for a moment and consider polynomials \
over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  " and look at two polynomials and their product in this context."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[P]\), 
    \(P\_2 = PolynomialsOver[Z[6]]\), 
    \(a = Poly[Z[6], 3\ x\^3 + x\^2 + x + 1]\), 
    \(b = Poly[Z[6], 2\ x\^2 + 5]\), 
    \(a\ b\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What can you surmise from this example? Look carefully at the output. \
Give another example of a similar occurrence in the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "of polynomials over",
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  "."
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Divide and conquer"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.11.6"],

Cell["\<\
The main reason arithmetic with polynomials is interesting (and so \
similar to integer arithmetic) is because of the division property. The \
division property is often referred to as the Division Algorithm in algebra \
texts.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s do some quick reviewing of familiar territory before \
looking at general polynomial rings. When we divide 159 by 13, we seek to \
find the number of times we can multiply 13 and still remain less than 159. \
Or in the vernacular, \[OpenCurlyDoubleQuote]How many times does 13 go into \
159?\[CloseCurlyDoubleQuote] In this case, 12 times 13 equals 156, leaving a \
remainder of 3."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(159 == 13\ 12 + 3\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Note that we have written 159 as the product of an integer times 13 \
plus a remainder whose value is less than 13.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Now consider the following polynomials (over the integers).", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = x\^3 + 5\ x\^2 - 3\ x + 8\), 
    \(b = x - 7\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "What do we get when we divide ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  "? In other words, can we write ",
  Cell[BoxData[
      \(TraditionalForm\`a = b\ q + r\)]],
  " for some polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  "? "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". You should know how to do this by hand. Do so and report your results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " has some built-in functions to find the quotient and remainder when \
considering polynomials over the integers (as well as some other standard \
rings).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(q = PolynomialQuotient[a, b, x]\), 
    \(r = PolynomialRemainder[a, b, x]\)}], "Input",
  AspectRatioFixed->True],

Cell["Do these work as we suppose?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(a == b\ q + r\)], "Input",
  AspectRatioFixed->True],

Cell["We need to do some coaxing.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(a == Expand[b\ q + r]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "To consider equivalent functionality over arbitrary rings, we need to use \
the functions built into the packages that were read in at the beginning. In \
this scenario, we use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialDivision",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Here, we define polynomials ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " ",
  StyleBox["and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " ",
  StyleBox["in the ring of polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = Poly[Z[7], x\^4 + 5\ x\^2 + 3\ x + 4]\), 
    \(b = Poly[Z[7], x\^2 + 3\ x + 2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Try your hand, using paper and pencil, at determining the quotient and \
remainder of ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " divided by ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ". Confirm your results with the following cell."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\n{q, r} = PolynomialDivision[a, b]\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We can test this result by multiplying the quotient ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " times ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", then adding the remainder ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(a == b\ *q + r\)], "Input"],

Cell[TextData[
"Often it\[CloseCurlyQuote]s necessary to know only the remainder or the \
quotient. The built-in functions already used also have extensions in these \
packages."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?PolynomialQuotient\)\)], "Input"],

Cell[BoxData[
    \(\(?PolynomialRemainder\)\)], "Input"],

Cell[BoxData[{
    \(PolynomialQuotient[a, b]\), 
    \(PolynomialRemainder[a, b]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider another example by changing ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " to a linear polynomial"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = Poly[Z[7], 4\ x\^4 + 3\ x\^3 + 5\ x\^2 + 1]\), 
    \(b = Poly[Z[7], x - 3]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that ",
  Cell[BoxData[
      \(TraditionalForm\`x - 3\)]],
  " is the same polynomial as ",
  Cell[BoxData[
      \(TraditionalForm\`x + 4\)]],
  " in the ring of polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Use long division to determine the quotient and remainder. Now evaluate \
the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" at the value 3.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
To evaluate any polynomial, simply substitute in the value and \
compute in the ring. In this case, we reduce mod 7 as we go. Try it. We can \
also use the following function.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialEvaluation[a, 3]\)], "Input",
  AspectRatioFixed->True],

Cell["Compare this to the following.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialRemainder[a, b]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Why did we divide by ",
  Cell[BoxData[
      \(TraditionalForm\`x - 3\)]],
  " and evaluate at 3? See if you can understand why with a couple more \
examples. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s change ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " to a different linear polynomial. We divide and examine the remainder."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(b = Poly[Z[7], x - 2]\), 
    \(PolynomialRemainder[a, b]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Also, evaluate ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " when ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is given the value 2."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialEvaluation[a, 2]\)], "Input",
  AspectRatioFixed->True],

Cell["And again, one more time, over a different ring.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = Poly[Z[13], 4\ x\^4 + 3\ x\^3 + 5\ x\^2 + 1]\), 
    \(b = Poly[Z[13], x + 5]\), 
    \(PolynomialEvaluation[a, 8]\), 
    \(PolynomialRemainder[a, b]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Can you make a conjecture based on these examples? You may wish to try \
some other linear polynomials. Note that you need to determine where to \
evaluate the polynomial, and this depends on the linear polynomial. What is \
this relationship? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a = f(x)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b = x - k\)]],
  StyleBox[
  ". Based on your answer to question 14, what can you say about the \
remainder ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" when we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(k) = 0\)]],
  StyleBox["? (Consider the following example, if you wish.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = Poly[Z[7], x\^4 + 2\ x\^3 + 2\ x\^2 + 1]\), 
    \(b = Poly[Z[7], x - 3]\), 
    \(PolynomialEvaluation[a, 3]\), 
    \(PolynomialRemainder[a, b]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". In all the examples we have encountered, what is the relationship \
between the degree of the remainder ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" and the degree of the divisor ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s fix a polynomial and consider the zeros of the \
polynomial over various rings ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ". By a zero, we mean a value such that the polynomial evaluates to the \
zero of the base ring (which, in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", is 0). For example, consider the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 3  x + 2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p = x\^2 + 3\ x + 2\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider finding the zeros for this polynomial over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_17\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_37\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Zeros[Poly[Z[15], p]]\), 
    \(Zeros[Poly[Z[17], p]]\), 
    \(Zeros[Poly[Z[37], p]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Suppose we consider all ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_k\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`k = 2\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`k = 11\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[{k, Zeros[Poly[Z[k], x\^2 + 3\ x + 2]]}, {k, 2, 11}], 
      TableHeadings 
        \[Rule] {
          None, {"\<k\>", 
            \*"\"\<zeros over \!\(\[DoubleStruckCapitalZ]\_k\)\\n\>\""}}, 
      TableDepth \[Rule] 2, TableSpacing \[Rule] {0, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". While several indices ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[
  " resulted in four zeros, most resulted in two. For those that yielded only \
two, is there anything significant about the two zeros? What is the \
explanation for this?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Note that finding zeros is a special case of solving an equation \
set equal to zero.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Solve[Poly[Z[11], x\^2 + 3\ x + 2] == 0]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Of course, we can also solve equations involving other constants.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(solns = Solve[Poly[Z[11], x\^2 + 3\ x + 2] == 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We can also verify the solutions. (Recall that ",
  StyleBox["x + 3 /. {x \[Rule] 5}",
    FontFamily->"Courier"],
  " results in 8.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(x + 3 /. {x \[Rule] 5}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Poly[Z[11], x\^2 + 3\ x + 2] /. solns\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try another polynomial."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(TableForm[
      Table[{k, Zeros[Poly[Z[k], 3\ x\^3 + x\^2 + 3\ x + 2]]}, {k, 2, 11}], 
      TableHeadings 
        \[Rule] {
          None, {"\<k\>", 
            \*"\"\<zeros over \!\(\[DoubleStruckCapitalZ]\_k\)\\n\>\""}}, 
      TableDepth \[Rule] 2, TableSpacing \[Rule] {0, 3}]\n (*\ 
      an\ empty\ position\ indicates\ no\ zeros\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". By modifying this code, try another polynomial and/or other rings to see \
if you can determine a relationship between the (maximum) number of zeros and \
the index ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" of the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_k\)]],
  StyleBox[" under consideration.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["6.4.1 The Euclidean Algorithm", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.11.7.6"],

Cell[TextData[{
  StyleBox["The greatest common divisor of two polynomials, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" not zero, can be determined using the fact that if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" is the result of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialRemainder[a, b]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`gcd(a, b) = gcd(b, r)\)]],
  StyleBox[
  ". This is an extension with polynomials of what you have already seen with \
integers. In other words, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a = 24\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b = 40\)]],
  StyleBox[", we know that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`gcd(a, b) = 8\)]],
  StyleBox[". Below we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mod",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", which is the integer equivalent to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialRemainder",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", to implement the Euclidean Algorithm. First define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = 40\), 
    \(b = 24\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Calculate the new values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[". Let the new ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" become the old ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" and the new ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" become the remainder on dividing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mod[a, b]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["). Now call these values ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" again.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(newa = b\), 
    \(newb = Mod[a, b]\), 
    \({a, b} = {newa, newb}\)}], "Input",
  AspectRatioFixed->True],

Cell["Repeat.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(newa = b\), 
    \(newb = Mod[a, b]\), 
    \({a, b} = {newa, newb}\)}], "Input",
  AspectRatioFixed->True],

Cell["Repeat.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(newa = b\), 
    \(newb = Mod[a, b]\), 
    \({a, b} = {newa, newb}\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "You are done when the remainder (",
  StyleBox["newb",
    FontFamily->"Courier"],
  ") becomes 0; the gcd is then the last nonzero remainder (",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ")."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Employ this algorithm by verifying that the gcd of 21 and 13 is 1.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q20",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Employ the Euclidean Algorithm for polynomials to determine the gcd of \
the polynomials ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^4 + 2  x\^3 + 2  x\^2 + 2\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^4 + 3  x\^3 + 3  x\^2 + 3  x + 2\)]],
  StyleBox[", both over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = Poly[Z[5], x\^4 + 2\ x\^3 + 2\ x\^2 + 2]\), 
    \(b = Poly[Z[5], x\^4 + 3\ x\^3 + 3\ x\^2 + 3\ x + 2]\)}], "Input",
  AspectRatioFixed->True],

Cell["You might find this cell handy.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(newa = b\), 
    \(newb = PolynomialRemainder[a, b]\), 
    \({a, b} = {newa, newb}\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["6.4.2 Another approach", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.11.8.6"],

Cell[TextData[{
  StyleBox[
  "Algorithms are great things to instruct computers to do. The Euclidean \
Algorithm has been implemented in the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialGCD",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialGCD[a, b]\)], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.12.6"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?PolynomialsOver", "Input",
  AspectRatioFixed->True],

Cell["?Poly", "Input",
  AspectRatioFixed->True],

Cell["?Indeterminate", "Input",
  AspectRatioFixed->True],

Cell["?PowersIncrease", "Input",
  AspectRatioFixed->True],

Cell["?LeftToRight", "Input",
  AspectRatioFixed->True],

Cell["?Equal", "Input",
  AspectRatioFixed->True],

Cell["?BooleanRing", "Input",
  AspectRatioFixed->True],

Cell["?RandomElement", "Input",
  AspectRatioFixed->True],

Cell["?Addition", "Input",
  AspectRatioFixed->True],

Cell["?Multiplication", "Input",
  AspectRatioFixed->True],

Cell["?Degree", "Input",
  AspectRatioFixed->True],

Cell["?Zero", "Input",
  AspectRatioFixed->True],

Cell["?Unity", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialQuotient", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialRemainder", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialDivision", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialEvaluation", "Input",
  AspectRatioFixed->True],

Cell["?Zeros", "Input",
  AspectRatioFixed->True],

Cell["?Solve", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialGCD", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingStartingPageNumber->37,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@Bbem0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:6.6"->{
    Cell[2382, 76, 164, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:6.6"]},
  "a:6.7.6"->{
    Cell[2571, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:6.7.6"]},
  "a:6.8.6"->{
    Cell[6938, 234, 191, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.8.6"]},
  "a:6.9.6"->{
    Cell[7696, 267, 183, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.9.6"]},
  "a:6.10.6"->{
    Cell[8419, 297, 206, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.10.6"]},
  "a:6.11.6"->{
    Cell[32443, 1198, 197, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:6.11.6"]},
  "a:6.11.7.6"->{
    Cell[48294, 1805, 125, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:6.11.7.6"]},
  "a:6.11.8.6"->{
    Cell[54810, 2062, 118, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:6.11.8.6"]},
  "a:6.12.6"->{
    Cell[55503, 2092, 371, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:6.12.6"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:6.6", 58598, 2214},
  {"a:6.7.6", 58706, 2218},
  {"a:6.8.6", 58819, 2222},
  {"a:6.9.6", 58932, 2226},
  {"a:6.10.6", 59046, 2230},
  {"a:6.11.6", 59161, 2234},
  {"a:6.11.7.6", 59280, 2238},
  {"a:6.11.8.6", 59404, 2242},
  {"a:6.12.6", 59526, 2246}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 164, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:6.6"],

Cell[CellGroupData[{
Cell[2571, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:6.7.6"],
Cell[2897, 100, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3748, 124, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5118, 166, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5270, 171, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5892, 193, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6584, 219, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6938, 234, 191, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.8.6"],
Cell[7132, 244, 527, 18, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7696, 267, 183, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.9.6"],
Cell[7882, 277, 500, 15, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8419, 297, 206, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.10.6"],
Cell[8628, 307, 188, 4, 33, "Text",
  Evaluatable->False],
Cell[8819, 313, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[8993, 319, 354, 11, 52, "Text",
  Evaluatable->False],
Cell[9350, 332, 643, 22, 67, "Question",
  Evaluatable->False],
Cell[9996, 356, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[10073, 360, 484, 14, 71, "Text",
  Evaluatable->False],
Cell[10560, 376, 746, 26, 52, "Text",
  Evaluatable->False],
Cell[11309, 404, 270, 9, 33, "Text",
  Evaluatable->False],
Cell[11582, 415, 953, 34, 52, "Text",
  Evaluatable->False],
Cell[12538, 451, 84, 2, 27, "Input"],
Cell[12625, 455, 283, 10, 33, "Text",
  Evaluatable->False],
Cell[12911, 467, 388, 14, 48, "Question",
  Evaluatable->False],
Cell[13302, 483, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13379, 487, 316, 9, 52, "Text",
  Evaluatable->False],
Cell[13698, 498, 270, 9, 33, "Text",
  Evaluatable->False],
Cell[13971, 509, 1197, 45, 52, "Text",
  Evaluatable->False],
Cell[15171, 556, 260, 6, 30, "Text",
  Evaluatable->False],
Cell[15434, 564, 1369, 45, 109, "Text",
  Evaluatable->False],
Cell[16806, 611, 106, 3, 43, "Input"],
Cell[16915, 616, 315, 10, 52, "Text",
  Evaluatable->False],
Cell[17233, 628, 132, 3, 43, "Input"],
Cell[17368, 633, 105, 2, 33, "Text",
  Evaluatable->False],
Cell[17476, 637, 91, 2, 31, "Input"],
Cell[17570, 641, 544, 16, 71, "Text",
  Evaluatable->False],
Cell[18117, 659, 85, 2, 31, "Input"],
Cell[18205, 663, 140, 5, 33, "Text",
  Evaluatable->False],
Cell[18348, 670, 42, 1, 27, "Input"],
Cell[18393, 673, 1227, 39, 109, "Text",
  Evaluatable->False],
Cell[19623, 714, 146, 3, 43, "Input"],
Cell[19772, 719, 277, 6, 71, "Text",
  Evaluatable->False],
Cell[20052, 727, 194, 4, 44, "Input"],
Cell[20249, 733, 194, 4, 44, "Input"],
Cell[20446, 739, 169, 7, 33, "Text",
  Evaluatable->False],
Cell[20618, 748, 103, 2, 31, "Input"],
Cell[20724, 752, 492, 14, 71, "Text",
  Evaluatable->False],
Cell[21219, 768, 217, 7, 33, "Text",
  Evaluatable->False],
Cell[21439, 777, 107, 3, 43, "Input"],
Cell[21549, 782, 94, 2, 27, "Input"],
Cell[21646, 786, 98, 2, 27, "Input"],
Cell[21747, 790, 235, 6, 52, "Text",
  Evaluatable->False],
Cell[21985, 798, 464, 17, 48, "Question",
  Evaluatable->False],
Cell[22452, 817, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22529, 821, 345, 11, 52, "Text",
  Evaluatable->False],
Cell[22877, 834, 118, 3, 43, "Input"],
Cell[22998, 839, 394, 12, 67, "Question",
  Evaluatable->False],
Cell[23395, 853, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23472, 857, 708, 24, 52, "Text",
  Evaluatable->False],
Cell[24183, 883, 161, 4, 59, "Input"],
Cell[24347, 889, 298, 10, 33, "Text",
  Evaluatable->False],
Cell[24648, 901, 91, 3, 43, "Input"],
Cell[24742, 906, 100, 2, 33, "Text",
  Evaluatable->False],
Cell[24845, 910, 81, 3, 43, "Input"],
Cell[24929, 915, 529, 20, 48, "Question",
  Evaluatable->False],
Cell[25461, 937, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25538, 941, 363, 13, 33, "Text",
  Evaluatable->False],
Cell[25904, 956, 97, 2, 31, "Input"],
Cell[26004, 960, 71, 2, 27, "Input"],
Cell[26078, 964, 568, 20, 67, "Question",
  Evaluatable->False],
Cell[26649, 986, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26726, 990, 499, 17, 67, "Question",
  Evaluatable->False],
Cell[27228, 1009, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[27305, 1013, 667, 19, 105, "Question",
  Evaluatable->False],
Cell[27975, 1034, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[28052, 1038, 529, 11, 107, "Input"],
Cell[28584, 1051, 488, 14, 86, "Question",
  Evaluatable->False],
Cell[29075, 1067, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[29152, 1071, 400, 9, 91, "Input"],
Cell[29555, 1082, 819, 30, 33, "Text",
  Evaluatable->False],
Cell[30377, 1114, 87, 2, 27, "Input"],
Cell[30467, 1118, 358, 11, 52, "Text",
  Evaluatable->False],
Cell[30828, 1131, 86, 3, 43, "Input"],
Cell[30917, 1136, 265, 10, 48, "Question",
  Evaluatable->False],
Cell[31185, 1148, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[31262, 1152, 302, 8, 52, "Text",
  Evaluatable->False],
Cell[31567, 1162, 210, 6, 100, "Input"],
Cell[31780, 1170, 549, 19, 67, "Question",
  Evaluatable->False],
Cell[32332, 1191, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[32443, 1198, 197, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:6.11.6"],
Cell[32643, 1208, 299, 7, 71, "Text",
  Evaluatable->False],
Cell[32945, 1217, 479, 8, 90, "Text",
  Evaluatable->False],
Cell[33427, 1227, 76, 2, 27, "Input"],
Cell[33506, 1231, 187, 5, 52, "Text",
  Evaluatable->False],
Cell[33696, 1238, 123, 2, 33, "Text",
  Evaluatable->False],
Cell[33822, 1242, 110, 3, 45, "Input"],
Cell[33935, 1247, 455, 19, 52, "Text",
  Evaluatable->False],
Cell[34393, 1268, 316, 11, 48, "Question",
  Evaluatable->False],
Cell[34712, 1281, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34789, 1285, 403, 13, 52, "Text",
  Evaluatable->False],
Cell[35195, 1300, 135, 3, 43, "Input"],
Cell[35333, 1305, 92, 2, 33, "Text",
  Evaluatable->False],
Cell[35428, 1309, 72, 2, 27, "Input"],
Cell[35503, 1313, 91, 2, 33, "Text",
  Evaluatable->False],
Cell[35597, 1317, 80, 2, 27, "Input"],
Cell[35680, 1321, 970, 33, 90, "Text",
  Evaluatable->False],
Cell[36653, 1356, 144, 3, 51, "Input"],
Cell[36800, 1361, 333, 11, 52, "Text",
  Evaluatable->False],
Cell[37136, 1374, 98, 2, 43, "Input"],
Cell[37237, 1378, 330, 13, 33, "Text",
  Evaluatable->False],
Cell[37570, 1393, 47, 1, 27, "Input"],
Cell[37620, 1396, 236, 5, 52, "Text",
  Evaluatable->False],
Cell[37859, 1403, 56, 1, 27, "Input"],
Cell[37918, 1406, 57, 1, 27, "Input"],
Cell[37978, 1409, 121, 3, 43, "Input"],
Cell[38102, 1414, 217, 7, 33, "Text",
  Evaluatable->False],
Cell[38322, 1423, 140, 3, 48, "Input"],
Cell[38465, 1428, 346, 13, 33, "Text",
  Evaluatable->False],
Cell[38814, 1443, 467, 17, 67, "Question",
  Evaluatable->False],
Cell[39284, 1462, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[39361, 1466, 247, 6, 52, "Text",
  Evaluatable->False],
Cell[39611, 1474, 85, 2, 27, "Input"],
Cell[39699, 1478, 94, 2, 33, "Text",
  Evaluatable->False],
Cell[39796, 1482, 84, 2, 27, "Input"],
Cell[39883, 1486, 240, 8, 52, "Text",
  Evaluatable->False],
Cell[40126, 1496, 235, 7, 33, "Text",
  Evaluatable->False],
Cell[40364, 1505, 118, 3, 43, "Input"],
Cell[40485, 1510, 231, 10, 33, "Text",
  Evaluatable->False],
Cell[40719, 1522, 85, 2, 27, "Input"],
Cell[40807, 1526, 112, 2, 33, "Text",
  Evaluatable->False],
Cell[40922, 1530, 215, 5, 80, "Input"],
Cell[41140, 1537, 490, 14, 86, "Question",
  Evaluatable->False],
Cell[41633, 1553, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41710, 1557, 890, 32, 86, "Question",
  Evaluatable->False],
Cell[42603, 1591, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[42680, 1595, 210, 5, 80, "Input"],
Cell[42893, 1602, 614, 22, 67, "Question",
  Evaluatable->False],
Cell[43510, 1626, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[43587, 1630, 565, 15, 71, "Text",
  Evaluatable->False],
Cell[44155, 1647, 78, 2, 29, "Input"],
Cell[44236, 1651, 380, 13, 33, "Text",
  Evaluatable->False],
Cell[44619, 1666, 146, 4, 59, "Input"],
Cell[44768, 1672, 310, 13, 33, "Text",
  Evaluatable->False],
Cell[45081, 1687, 327, 7, 67, "Input"],
Cell[45411, 1696, 552, 18, 67, "Question",
  Evaluatable->False],
Cell[45966, 1716, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[46043, 1720, 157, 5, 33, "Text",
  Evaluatable->False],
Cell[46203, 1727, 99, 2, 31, "Input"],
Cell[46305, 1731, 139, 5, 33, "Text",
  Evaluatable->False],
Cell[46447, 1738, 107, 2, 31, "Input"],
Cell[46557, 1742, 213, 7, 33, "Text",
  Evaluatable->False],
Cell[46773, 1751, 81, 2, 27, "Input"],
Cell[46857, 1755, 96, 2, 31, "Input"],
Cell[46956, 1759, 120, 2, 33, "Text",
  Evaluatable->False],
Cell[47079, 1763, 408, 9, 84, "Input"],
Cell[47490, 1774, 702, 23, 86, "Question",
  Evaluatable->False],
Cell[48195, 1799, 74, 2, 47, "Answer",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[48294, 1805, 125, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:6.11.7.6"],
Cell[48422, 1810, 2252, 79, 128, "Text",
  Evaluatable->False],
Cell[50677, 1891, 84, 3, 43, "Input"],
Cell[50764, 1896, 1512, 58, 52, "Text",
  Evaluatable->False],
Cell[52279, 1956, 128, 4, 59, "Input"],
Cell[52410, 1962, 71, 2, 33, "Text",
  Evaluatable->False],
Cell[52484, 1966, 128, 4, 59, "Input"],
Cell[52615, 1972, 71, 2, 33, "Text",
  Evaluatable->False],
Cell[52689, 1976, 128, 4, 59, "Input"],
Cell[52820, 1982, 279, 10, 52, "Text",
  Evaluatable->False],
Cell[53102, 1994, 312, 11, 48, "Question",
  Evaluatable->False],
Cell[53417, 2007, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[53494, 2011, 787, 27, 67, "Question",
  Evaluatable->False],
Cell[54284, 2040, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[54361, 2044, 167, 3, 51, "Input"],
Cell[54531, 2049, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[54629, 2053, 144, 4, 59, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[54810, 2062, 118, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:6.11.8.6"],
Cell[54931, 2067, 442, 15, 52, "Text",
  Evaluatable->False],
Cell[55376, 2084, 78, 2, 27, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[55503, 2092, 371, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:6.12.6"],
Cell[55877, 2108, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[56222, 2119, 59, 1, 27, "Input"],
Cell[56284, 2122, 48, 1, 27, "Input"],
Cell[56335, 2125, 57, 1, 27, "Input"],
Cell[56395, 2128, 58, 1, 27, "Input"],
Cell[56456, 2131, 55, 1, 27, "Input"],
Cell[56514, 2134, 49, 1, 27, "Input"],
Cell[56566, 2137, 55, 1, 27, "Input"],
Cell[56624, 2140, 57, 1, 27, "Input"],
Cell[56684, 2143, 52, 1, 27, "Input"],
Cell[56739, 2146, 58, 1, 27, "Input"],
Cell[56800, 2149, 50, 1, 27, "Input"],
Cell[56853, 2152, 48, 1, 27, "Input"],
Cell[56904, 2155, 49, 1, 27, "Input"],
Cell[56956, 2158, 62, 1, 27, "Input"],
Cell[57021, 2161, 63, 1, 27, "Input"],
Cell[57087, 2164, 62, 1, 27, "Input"],
Cell[57152, 2167, 64, 1, 27, "Input"],
Cell[57219, 2170, 49, 1, 27, "Input"],
Cell[57271, 2173, 49, 1, 27, "Input"],
Cell[57323, 2176, 57, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

